// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__76744 = arguments.length;
switch (G__76744) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__16345__auto___76892 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_76831){
var state_val_76832 = (state_76831[(1)]);
if((state_val_76832 === (7))){
var inst_76762 = (state_76831[(7)]);
var inst_76765 = cljs.core.not_EQ_.call(null,(0),inst_76762);
var state_76831__$1 = state_76831;
var statearr_76833_76893 = state_76831__$1;
(statearr_76833_76893[(2)] = inst_76765);

(statearr_76833_76893[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (20))){
var inst_76757 = (state_76831[(8)]);
var inst_76786 = (state_76831[(9)]);
var inst_76790 = fluree.db.auth.roles.call(null,inst_76757,inst_76786);
var state_76831__$1 = state_76831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76831__$1,(23),inst_76790);
} else {
if((state_val_76832 === (27))){
var inst_76757 = (state_76831[(8)]);
var inst_76805 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_76806 = fluree.db.time_travel.as_of_block.call(null,inst_76757,inst_76805);
var state_76831__$1 = state_76831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76831__$1,(30),inst_76806);
} else {
if((state_val_76832 === (1))){
var state_76831__$1 = state_76831;
var statearr_76834_76894 = state_76831__$1;
(statearr_76834_76894[(2)] = null);

(statearr_76834_76894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (24))){
var inst_76757 = (state_76831[(8)]);
var inst_76798 = (state_76831[(10)]);
var inst_76800 = fluree.db.permissions.permission_map.call(null,inst_76757,inst_76798,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_76831__$1 = state_76831;
var statearr_76835_76895 = state_76831__$1;
(statearr_76835_76895[(2)] = inst_76800);

(statearr_76835_76895[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (4))){
var inst_76745 = (state_76831[(2)]);
var inst_76746 = cljs.core.async.put_BANG_.call(null,pc,inst_76745);
var inst_76747 = cljs.core.async.close_BANG_.call(null,pc);
var state_76831__$1 = (function (){var statearr_76836 = state_76831;
(statearr_76836[(11)] = inst_76746);

return statearr_76836;
})();
var statearr_76837_76896 = state_76831__$1;
(statearr_76837_76896[(2)] = inst_76747);

(statearr_76837_76896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (15))){
var inst_76762 = (state_76831[(7)]);
var inst_76776 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76762)," unknown."].join('');
var inst_76777 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76778 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_76779 = cljs.core.PersistentHashMap.fromArrays(inst_76777,inst_76778);
var inst_76780 = cljs.core.ex_info.call(null,inst_76776,inst_76779);
var inst_76781 = (function(){throw inst_76780})();
var state_76831__$1 = state_76831;
var statearr_76838_76897 = state_76831__$1;
(statearr_76838_76897[(2)] = inst_76781);

(statearr_76838_76897[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (21))){
var state_76831__$1 = state_76831;
var statearr_76839_76898 = state_76831__$1;
(statearr_76839_76898[(2)] = null);

(statearr_76839_76898[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (31))){
var inst_76762 = (state_76831[(7)]);
var inst_76812 = (state_76831[(12)]);
var inst_76814 = cljs.core.assoc.call(null,inst_76812,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_76762);
var state_76831__$1 = state_76831;
var statearr_76840_76899 = state_76831__$1;
(statearr_76840_76899[(2)] = inst_76814);

(statearr_76840_76899[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (32))){
var inst_76812 = (state_76831[(12)]);
var state_76831__$1 = state_76831;
var statearr_76841_76900 = state_76831__$1;
(statearr_76841_76900[(2)] = inst_76812);

(statearr_76841_76900[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (33))){
var inst_76798 = (state_76831[(10)]);
var inst_76817 = (state_76831[(2)]);
var state_76831__$1 = (function (){var statearr_76842 = state_76831;
(statearr_76842[(13)] = inst_76817);

return statearr_76842;
})();
if(cljs.core.truth_(inst_76798)){
var statearr_76843_76901 = state_76831__$1;
(statearr_76843_76901[(1)] = (34));

} else {
var statearr_76844_76902 = state_76831__$1;
(statearr_76844_76902[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (13))){
var inst_76773 = (state_76831[(14)]);
var inst_76772 = (state_76831[(2)]);
var inst_76773__$1 = fluree.db.util.async.throw_err.call(null,inst_76772);
var state_76831__$1 = (function (){var statearr_76845 = state_76831;
(statearr_76845[(14)] = inst_76773__$1);

return statearr_76845;
})();
if(cljs.core.truth_(inst_76773__$1)){
var statearr_76846_76903 = state_76831__$1;
(statearr_76846_76903[(1)] = (14));

} else {
var statearr_76847_76904 = state_76831__$1;
(statearr_76847_76904[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (22))){
var inst_76796 = (state_76831[(2)]);
var state_76831__$1 = state_76831;
var statearr_76848_76905 = state_76831__$1;
(statearr_76848_76905[(2)] = inst_76796);

(statearr_76848_76905[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (36))){
var inst_76825 = (state_76831[(2)]);
var inst_76826 = cljs.core.async.put_BANG_.call(null,pc,inst_76825);
var _ = (function (){var statearr_76849 = state_76831;
(statearr_76849[(4)] = cljs.core.rest.call(null,(state_76831[(4)])));

return statearr_76849;
})();
var state_76831__$1 = state_76831;
var statearr_76850_76906 = state_76831__$1;
(statearr_76850_76906[(2)] = inst_76826);

(statearr_76850_76906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (29))){
var inst_76762 = (state_76831[(7)]);
var inst_76812 = (state_76831[(2)]);
var state_76831__$1 = (function (){var statearr_76851 = state_76831;
(statearr_76851[(12)] = inst_76812);

return statearr_76851;
})();
if(cljs.core.truth_(inst_76762)){
var statearr_76852_76907 = state_76831__$1;
(statearr_76852_76907[(1)] = (31));

} else {
var statearr_76853_76908 = state_76831__$1;
(statearr_76853_76908[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (6))){
var inst_76762 = (state_76831[(7)]);
var inst_76756 = (state_76831[(2)]);
var inst_76757 = fluree.db.util.async.throw_err.call(null,inst_76756);
var inst_76758 = opts;
var inst_76759 = cljs.core.__destructure_map.call(null,inst_76758);
var inst_76760 = cljs.core.get.call(null,inst_76759,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_76761 = cljs.core.get.call(null,inst_76759,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_76762__$1 = cljs.core.get.call(null,inst_76759,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_76763 = cljs.core.get.call(null,inst_76759,new cljs.core.Keyword(null,"block","block",664686210));
var state_76831__$1 = (function (){var statearr_76854 = state_76831;
(statearr_76854[(15)] = inst_76761);

(statearr_76854[(8)] = inst_76757);

(statearr_76854[(16)] = inst_76760);

(statearr_76854[(17)] = inst_76763);

(statearr_76854[(7)] = inst_76762__$1);

return statearr_76854;
})();
if(cljs.core.truth_(inst_76762__$1)){
var statearr_76855_76909 = state_76831__$1;
(statearr_76855_76909[(1)] = (7));

} else {
var statearr_76856_76910 = state_76831__$1;
(statearr_76856_76910[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (28))){
var inst_76757 = (state_76831[(8)]);
var state_76831__$1 = state_76831;
var statearr_76857_76911 = state_76831__$1;
(statearr_76857_76911[(2)] = inst_76757);

(statearr_76857_76911[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (25))){
var state_76831__$1 = state_76831;
var statearr_76858_76912 = state_76831__$1;
(statearr_76858_76912[(2)] = null);

(statearr_76858_76912[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (34))){
var inst_76803 = (state_76831[(18)]);
var state_76831__$1 = state_76831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76831__$1,(37),inst_76803);
} else {
if((state_val_76832 === (17))){
var inst_76760 = (state_76831[(16)]);
var state_76831__$1 = state_76831;
var statearr_76859_76913 = state_76831__$1;
(statearr_76859_76913[(2)] = inst_76760);

(statearr_76859_76913[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (3))){
var inst_76829 = (state_76831[(2)]);
var state_76831__$1 = state_76831;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76831__$1,inst_76829);
} else {
if((state_val_76832 === (12))){
var inst_76760 = (state_76831[(16)]);
var inst_76786 = (state_76831[(2)]);
var state_76831__$1 = (function (){var statearr_76860 = state_76831;
(statearr_76860[(9)] = inst_76786);

return statearr_76860;
})();
if(cljs.core.truth_(inst_76760)){
var statearr_76861_76914 = state_76831__$1;
(statearr_76861_76914[(1)] = (17));

} else {
var statearr_76862_76915 = state_76831__$1;
(statearr_76862_76915[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (2))){
var _ = (function (){var statearr_76863 = state_76831;
(statearr_76863[(4)] = cljs.core.cons.call(null,(5),(state_76831[(4)])));

return statearr_76863;
})();
var inst_76754 = fluree.db.session.db.call(null,conn,ledger,null);
var state_76831__$1 = state_76831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76831__$1,(6),inst_76754);
} else {
if((state_val_76832 === (23))){
var inst_76792 = (state_76831[(2)]);
var inst_76793 = fluree.db.util.async.throw_err.call(null,inst_76792);
var state_76831__$1 = state_76831;
var statearr_76864_76916 = state_76831__$1;
(statearr_76864_76916[(2)] = inst_76793);

(statearr_76864_76916[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (35))){
var inst_76817 = (state_76831[(13)]);
var state_76831__$1 = state_76831;
var statearr_76865_76917 = state_76831__$1;
(statearr_76865_76917[(2)] = inst_76817);

(statearr_76865_76917[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (19))){
var inst_76798 = (state_76831[(10)]);
var inst_76798__$1 = (state_76831[(2)]);
var state_76831__$1 = (function (){var statearr_76866 = state_76831;
(statearr_76866[(10)] = inst_76798__$1);

return statearr_76866;
})();
if(cljs.core.truth_(inst_76798__$1)){
var statearr_76867_76918 = state_76831__$1;
(statearr_76867_76918[(1)] = (24));

} else {
var statearr_76868_76919 = state_76831__$1;
(statearr_76868_76919[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (11))){
var state_76831__$1 = state_76831;
var statearr_76870_76920 = state_76831__$1;
(statearr_76870_76920[(2)] = null);

(statearr_76870_76920[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (9))){
var inst_76768 = (state_76831[(2)]);
var state_76831__$1 = state_76831;
if(cljs.core.truth_(inst_76768)){
var statearr_76871_76921 = state_76831__$1;
(statearr_76871_76921[(1)] = (10));

} else {
var statearr_76872_76922 = state_76831__$1;
(statearr_76872_76922[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (5))){
var _ = (function (){var statearr_76873 = state_76831;
(statearr_76873[(4)] = cljs.core.rest.call(null,(state_76831[(4)])));

return statearr_76873;
})();
var state_76831__$1 = state_76831;
var ex76869 = (state_76831__$1[(2)]);
var statearr_76874_76923 = state_76831__$1;
(statearr_76874_76923[(5)] = ex76869);


var statearr_76875_76924 = state_76831__$1;
(statearr_76875_76924[(1)] = (4));

(statearr_76875_76924[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (14))){
var inst_76773 = (state_76831[(14)]);
var state_76831__$1 = state_76831;
var statearr_76876_76925 = state_76831__$1;
(statearr_76876_76925[(2)] = inst_76773);

(statearr_76876_76925[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (26))){
var inst_76763 = (state_76831[(17)]);
var inst_76803 = (state_76831[(2)]);
var state_76831__$1 = (function (){var statearr_76877 = state_76831;
(statearr_76877[(18)] = inst_76803);

return statearr_76877;
})();
if(cljs.core.truth_(inst_76763)){
var statearr_76878_76926 = state_76831__$1;
(statearr_76878_76926[(1)] = (27));

} else {
var statearr_76879_76927 = state_76831__$1;
(statearr_76879_76927[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (16))){
var inst_76783 = (state_76831[(2)]);
var state_76831__$1 = state_76831;
var statearr_76880_76928 = state_76831__$1;
(statearr_76880_76928[(2)] = inst_76783);

(statearr_76880_76928[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (30))){
var inst_76808 = (state_76831[(2)]);
var inst_76809 = fluree.db.util.async.throw_err.call(null,inst_76808);
var state_76831__$1 = state_76831;
var statearr_76881_76929 = state_76831__$1;
(statearr_76881_76929[(2)] = inst_76809);

(statearr_76881_76929[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (10))){
var inst_76757 = (state_76831[(8)]);
var inst_76762 = (state_76831[(7)]);
var inst_76770 = fluree.db.dbproto._subid.call(null,inst_76757,inst_76762);
var state_76831__$1 = state_76831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76831__$1,(13),inst_76770);
} else {
if((state_val_76832 === (18))){
var inst_76786 = (state_76831[(9)]);
var state_76831__$1 = state_76831;
if(cljs.core.truth_(inst_76786)){
var statearr_76882_76930 = state_76831__$1;
(statearr_76882_76930[(1)] = (20));

} else {
var statearr_76883_76931 = state_76831__$1;
(statearr_76883_76931[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (37))){
var inst_76817 = (state_76831[(13)]);
var inst_76820 = (state_76831[(2)]);
var inst_76821 = fluree.db.util.async.throw_err.call(null,inst_76820);
var inst_76822 = cljs.core.assoc.call(null,inst_76817,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_76821);
var state_76831__$1 = state_76831;
var statearr_76884_76932 = state_76831__$1;
(statearr_76884_76932[(2)] = inst_76822);

(statearr_76884_76932[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76832 === (8))){
var inst_76762 = (state_76831[(7)]);
var state_76831__$1 = state_76831;
var statearr_76885_76933 = state_76831__$1;
(statearr_76885_76933[(2)] = inst_76762);

(statearr_76885_76933[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__16221__auto__ = null;
var fluree$db$api$query$state_machine__16221__auto____0 = (function (){
var statearr_76886 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76886[(0)] = fluree$db$api$query$state_machine__16221__auto__);

(statearr_76886[(1)] = (1));

return statearr_76886;
});
var fluree$db$api$query$state_machine__16221__auto____1 = (function (state_76831){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_76831);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e76887){var ex__16224__auto__ = e76887;
var statearr_76888_76934 = state_76831;
(statearr_76888_76934[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_76831[(4)]))){
var statearr_76889_76935 = state_76831;
(statearr_76889_76935[(1)] = cljs.core.first.call(null,(state_76831[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76936 = state_76831;
state_76831 = G__76936;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__16221__auto__ = function(state_76831){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__16221__auto____1.call(this,state_76831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__16221__auto____0;
fluree$db$api$query$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__16221__auto____1;
return fluree$db$api$query$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_76890 = f__16346__auto__.call(null);
(statearr_76890[(6)] = c__16345__auto___76892);

return statearr_76890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_77077){
var state_val_77078 = (state_77077[(1)]);
if((state_val_77078 === (7))){
var inst_76957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76958 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_76959 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_76960 = [inst_76958,inst_76959];
var inst_76961 = (new cljs.core.PersistentVector(null,2,(5),inst_76957,inst_76960,null));
var state_77077__$1 = state_77077;
var statearr_77079_77149 = state_77077__$1;
(statearr_77079_77149[(2)] = inst_76961);

(statearr_77079_77149[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (20))){
var inst_76987 = (state_77077[(7)]);
var state_77077__$1 = state_77077;
var statearr_77080_77150 = state_77077__$1;
(statearr_77080_77150[(2)] = inst_76987);

(statearr_77080_77150[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (27))){
var state_77077__$1 = state_77077;
var statearr_77081_77151 = state_77077__$1;
(statearr_77081_77151[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (1))){
var state_77077__$1 = state_77077;
var statearr_77083_77152 = state_77077__$1;
(statearr_77083_77152[(2)] = null);

(statearr_77083_77152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (24))){
var inst_76986 = (state_77077[(8)]);
var state_77077__$1 = state_77077;
if(cljs.core.truth_(inst_76986)){
var statearr_77084_77153 = state_77077__$1;
(statearr_77084_77153[(1)] = (26));

} else {
var statearr_77085_77154 = state_77077__$1;
(statearr_77085_77154[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (39))){
var inst_77032 = (state_77077[(9)]);
var inst_77033 = (state_77077[(10)]);
var inst_77058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77059 = [inst_77032,inst_77033];
var inst_77060 = (new cljs.core.PersistentVector(null,2,(5),inst_77058,inst_77059,null));
var state_77077__$1 = state_77077;
var statearr_77086_77155 = state_77077__$1;
(statearr_77086_77155[(2)] = inst_77060);

(statearr_77086_77155[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (4))){
var inst_76937 = (state_77077[(2)]);
var state_77077__$1 = state_77077;
var statearr_77087_77156 = state_77077__$1;
(statearr_77087_77156[(2)] = inst_76937);

(statearr_77087_77156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (15))){
var inst_76971 = (state_77077[(11)]);
var inst_76966 = (state_77077[(12)]);
var inst_76980 = (state_77077[(2)]);
var inst_76981 = [inst_76971,inst_76980];
var inst_76982 = (new cljs.core.PersistentVector(null,2,(5),inst_76966,inst_76981,null));
var state_77077__$1 = state_77077;
var statearr_77088_77157 = state_77077__$1;
(statearr_77088_77157[(2)] = inst_76982);

(statearr_77088_77157[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (21))){
var inst_76986 = (state_77077[(8)]);
var state_77077__$1 = state_77077;
var statearr_77089_77158 = state_77077__$1;
(statearr_77089_77158[(2)] = inst_76986);

(statearr_77089_77158[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (31))){
var inst_77027 = (state_77077[(2)]);
var state_77077__$1 = state_77077;
var statearr_77090_77159 = state_77077__$1;
(statearr_77090_77159[(2)] = inst_77027);

(statearr_77090_77159[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (32))){
var inst_77033 = (state_77077[(10)]);
var inst_77036 = cljs.core.pos_int_QMARK_.call(null,inst_77033);
var state_77077__$1 = state_77077;
var statearr_77091_77160 = state_77077__$1;
(statearr_77091_77160[(2)] = inst_77036);

(statearr_77091_77160[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (40))){
var inst_77064 = (state_77077[(13)]);
var inst_76988 = (state_77077[(14)]);
var inst_77062 = (state_77077[(2)]);
var inst_77063 = cljs.core.nth.call(null,inst_77062,(0),null);
var inst_77064__$1 = cljs.core.nth.call(null,inst_77062,(1),null);
var inst_77065 = (inst_77064__$1 > inst_76988);
var state_77077__$1 = (function (){var statearr_77092 = state_77077;
(statearr_77092[(13)] = inst_77064__$1);

(statearr_77092[(15)] = inst_77063);

return statearr_77092;
})();
if(cljs.core.truth_(inst_77065)){
var statearr_77093_77161 = state_77077__$1;
(statearr_77093_77161[(1)] = (41));

} else {
var statearr_77094_77162 = state_77077__$1;
(statearr_77094_77162[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (33))){
var inst_77034 = (state_77077[(16)]);
var state_77077__$1 = state_77077;
var statearr_77095_77163 = state_77077__$1;
(statearr_77095_77163[(2)] = inst_77034);

(statearr_77095_77163[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (13))){
var inst_76972 = (state_77077[(17)]);
var inst_76974 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_76972);
var state_77077__$1 = state_77077;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77077__$1,(16),inst_76974);
} else {
if((state_val_77078 === (22))){
var inst_77005 = (state_77077[(2)]);
var state_77077__$1 = state_77077;
if(cljs.core.truth_(inst_77005)){
var statearr_77096_77164 = state_77077__$1;
(statearr_77096_77164[(1)] = (23));

} else {
var statearr_77097_77165 = state_77077__$1;
(statearr_77097_77165[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (36))){
var state_77077__$1 = state_77077;
var statearr_77098_77166 = state_77077__$1;
(statearr_77098_77166[(2)] = null);

(statearr_77098_77166[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (41))){
var inst_76988 = (state_77077[(14)]);
var state_77077__$1 = state_77077;
var statearr_77099_77167 = state_77077__$1;
(statearr_77099_77167[(2)] = inst_76988);

(statearr_77099_77167[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (43))){
var inst_77063 = (state_77077[(15)]);
var inst_77069 = (state_77077[(2)]);
var inst_77070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77071 = [inst_77063,inst_77069];
var inst_77072 = (new cljs.core.PersistentVector(null,2,(5),inst_77070,inst_77071,null));
var _ = (function (){var statearr_77100 = state_77077;
(statearr_77100[(4)] = cljs.core.rest.call(null,(state_77077[(4)])));

return statearr_77100;
})();
var state_77077__$1 = state_77077;
var statearr_77101_77168 = state_77077__$1;
(statearr_77101_77168[(2)] = inst_77072);

(statearr_77101_77168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (29))){
var inst_76963 = (state_77077[(18)]);
var inst_77018 = cljs.core.pr_str.call(null,inst_76963);
var inst_77019 = ["Invalid block range provided: ",inst_77018].join('');
var inst_77020 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77021 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_77022 = cljs.core.PersistentHashMap.fromArrays(inst_77020,inst_77021);
var inst_77023 = cljs.core.ex_info.call(null,inst_77019,inst_77022);
var inst_77024 = (function(){throw inst_77023})();
var state_77077__$1 = state_77077;
var statearr_77102_77169 = state_77077__$1;
(statearr_77102_77169[(2)] = inst_77024);

(statearr_77102_77169[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (6))){
var inst_76955 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_77077__$1 = state_77077;
var statearr_77103_77170 = state_77077__$1;
(statearr_77103_77170[(2)] = inst_76955);

(statearr_77103_77170[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (28))){
var inst_77029 = (state_77077[(2)]);
var state_77077__$1 = state_77077;
var statearr_77104_77171 = state_77077__$1;
(statearr_77104_77171[(2)] = inst_77029);

(statearr_77104_77171[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (25))){
var inst_77032 = (state_77077[(9)]);
var inst_77034 = (state_77077[(16)]);
var inst_77031 = (state_77077[(2)]);
var inst_77032__$1 = cljs.core.nth.call(null,inst_77031,(0),null);
var inst_77033 = cljs.core.nth.call(null,inst_77031,(1),null);
var inst_77034__$1 = cljs.core.pos_int_QMARK_.call(null,inst_77032__$1);
var state_77077__$1 = (function (){var statearr_77105 = state_77077;
(statearr_77105[(9)] = inst_77032__$1);

(statearr_77105[(16)] = inst_77034__$1);

(statearr_77105[(10)] = inst_77033);

return statearr_77105;
})();
if(inst_77034__$1){
var statearr_77106_77172 = state_77077__$1;
(statearr_77106_77172[(1)] = (32));

} else {
var statearr_77107_77173 = state_77077__$1;
(statearr_77107_77173[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (34))){
var inst_77039 = (state_77077[(2)]);
var inst_77040 = cljs.core.not.call(null,inst_77039);
var state_77077__$1 = state_77077;
if(inst_77040){
var statearr_77108_77174 = state_77077__$1;
(statearr_77108_77174[(1)] = (35));

} else {
var statearr_77109_77175 = state_77077__$1;
(statearr_77109_77175[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (17))){
var inst_76986 = (state_77077[(8)]);
var inst_76988 = (state_77077[(14)]);
var inst_76991 = cljs.core.pr_str.call(null,inst_76986);
var inst_76992 = cljs.core.pr_str.call(null,inst_76988);
var inst_76993 = ["Start block is out of range for this ledger. Start block provided: ",inst_76991,". Database block: ",inst_76992].join('');
var inst_76994 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76995 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76996 = cljs.core.PersistentHashMap.fromArrays(inst_76994,inst_76995);
var inst_76997 = cljs.core.ex_info.call(null,inst_76993,inst_76996);
var inst_76998 = (function(){throw inst_76997})();
var state_77077__$1 = state_77077;
var statearr_77110_77176 = state_77077__$1;
(statearr_77110_77176[(2)] = inst_76998);

(statearr_77110_77176[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (3))){
var inst_77075 = (state_77077[(2)]);
var state_77077__$1 = state_77077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77077__$1,inst_77075);
} else {
if((state_val_77078 === (12))){
var inst_76963 = (state_77077[(18)]);
var inst_76972 = (state_77077[(17)]);
var inst_76970 = (state_77077[(2)]);
var inst_76971 = fluree.db.util.async.throw_err.call(null,inst_76970);
var inst_76972__$1 = cljs.core.second.call(null,inst_76963);
var state_77077__$1 = (function (){var statearr_77111 = state_77077;
(statearr_77111[(11)] = inst_76971);

(statearr_77111[(17)] = inst_76972__$1);

return statearr_77111;
})();
if(cljs.core.truth_(inst_76972__$1)){
var statearr_77112_77177 = state_77077__$1;
(statearr_77112_77177[(1)] = (13));

} else {
var statearr_77113_77178 = state_77077__$1;
(statearr_77113_77178[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (2))){
var _ = (function (){var statearr_77114 = state_77077;
(statearr_77114[(4)] = cljs.core.cons.call(null,(5),(state_77077[(4)])));

return statearr_77114;
})();
var inst_76952 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_76953 = cljs.core.sequential_QMARK_.call(null,inst_76952);
var state_77077__$1 = state_77077;
if(inst_76953){
var statearr_77115_77179 = state_77077__$1;
(statearr_77115_77179[(1)] = (6));

} else {
var statearr_77116_77180 = state_77077__$1;
(statearr_77116_77180[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (23))){
var inst_76986 = (state_77077[(8)]);
var inst_76987 = (state_77077[(7)]);
var inst_77007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77008 = [inst_76986,inst_76987];
var inst_77009 = (new cljs.core.PersistentVector(null,2,(5),inst_77007,inst_77008,null));
var state_77077__$1 = state_77077;
var statearr_77117_77181 = state_77077__$1;
(statearr_77117_77181[(2)] = inst_77009);

(statearr_77117_77181[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (35))){
var inst_76963 = (state_77077[(18)]);
var inst_77042 = cljs.core.pr_str.call(null,inst_76963);
var inst_77043 = ["Invalid block range provided: ",inst_77042].join('');
var inst_77044 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77045 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_77046 = cljs.core.PersistentHashMap.fromArrays(inst_77044,inst_77045);
var inst_77047 = cljs.core.ex_info.call(null,inst_77043,inst_77046);
var inst_77048 = (function(){throw inst_77047})();
var state_77077__$1 = state_77077;
var statearr_77118_77182 = state_77077__$1;
(statearr_77118_77182[(2)] = inst_77048);

(statearr_77118_77182[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (19))){
var inst_76986 = (state_77077[(8)]);
var inst_77001 = (state_77077[(2)]);
var state_77077__$1 = (function (){var statearr_77119 = state_77077;
(statearr_77119[(19)] = inst_77001);

return statearr_77119;
})();
if(cljs.core.truth_(inst_76986)){
var statearr_77120_77183 = state_77077__$1;
(statearr_77120_77183[(1)] = (20));

} else {
var statearr_77121_77184 = state_77077__$1;
(statearr_77121_77184[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (11))){
var inst_76986 = (state_77077[(8)]);
var inst_76988 = (state_77077[(14)]);
var inst_76985 = (state_77077[(2)]);
var inst_76986__$1 = cljs.core.nth.call(null,inst_76985,(0),null);
var inst_76987 = cljs.core.nth.call(null,inst_76985,(1),null);
var inst_76988__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_76989 = (inst_76986__$1 > inst_76988__$1);
var state_77077__$1 = (function (){var statearr_77123 = state_77077;
(statearr_77123[(8)] = inst_76986__$1);

(statearr_77123[(14)] = inst_76988__$1);

(statearr_77123[(7)] = inst_76987);

return statearr_77123;
})();
if(cljs.core.truth_(inst_76989)){
var statearr_77124_77185 = state_77077__$1;
(statearr_77124_77185[(1)] = (17));

} else {
var statearr_77125_77186 = state_77077__$1;
(statearr_77125_77186[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (9))){
var inst_76963 = (state_77077[(18)]);
var inst_76966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76967 = cljs.core.first.call(null,inst_76963);
var inst_76968 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_76967);
var state_77077__$1 = (function (){var statearr_77126 = state_77077;
(statearr_77126[(12)] = inst_76966);

return statearr_77126;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77077__$1,(12),inst_76968);
} else {
if((state_val_77078 === (5))){
var _ = (function (){var statearr_77127 = state_77077;
(statearr_77127[(4)] = cljs.core.rest.call(null,(state_77077[(4)])));

return statearr_77127;
})();
var state_77077__$1 = state_77077;
var ex77122 = (state_77077__$1[(2)]);
var statearr_77128_77187 = state_77077__$1;
(statearr_77128_77187[(5)] = ex77122);


if((ex77122 instanceof Error)){
var statearr_77129_77188 = state_77077__$1;
(statearr_77129_77188[(1)] = (4));

(statearr_77129_77188[(5)] = null);

} else {
throw ex77122;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (14))){
var state_77077__$1 = state_77077;
var statearr_77130_77189 = state_77077__$1;
(statearr_77130_77189[(2)] = null);

(statearr_77130_77189[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (26))){
var inst_76986 = (state_77077[(8)]);
var inst_77012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77013 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_77014 = [inst_76986,inst_77013];
var inst_77015 = (new cljs.core.PersistentVector(null,2,(5),inst_77012,inst_77014,null));
var state_77077__$1 = state_77077;
var statearr_77131_77190 = state_77077__$1;
(statearr_77131_77190[(2)] = inst_77015);

(statearr_77131_77190[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (16))){
var inst_76976 = (state_77077[(2)]);
var inst_76977 = fluree.db.util.async.throw_err.call(null,inst_76976);
var state_77077__$1 = state_77077;
var statearr_77132_77191 = state_77077__$1;
(statearr_77132_77191[(2)] = inst_76977);

(statearr_77132_77191[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (38))){
var inst_77032 = (state_77077[(9)]);
var inst_77033 = (state_77077[(10)]);
var inst_77054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77055 = [inst_77033,inst_77032];
var inst_77056 = (new cljs.core.PersistentVector(null,2,(5),inst_77054,inst_77055,null));
var state_77077__$1 = state_77077;
var statearr_77133_77192 = state_77077__$1;
(statearr_77133_77192[(2)] = inst_77056);

(statearr_77133_77192[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (30))){
var state_77077__$1 = state_77077;
var statearr_77134_77193 = state_77077__$1;
(statearr_77134_77193[(2)] = null);

(statearr_77134_77193[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (10))){
var inst_76963 = (state_77077[(18)]);
var state_77077__$1 = state_77077;
var statearr_77135_77194 = state_77077__$1;
(statearr_77135_77194[(2)] = inst_76963);

(statearr_77135_77194[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (18))){
var state_77077__$1 = state_77077;
var statearr_77136_77195 = state_77077__$1;
(statearr_77136_77195[(2)] = null);

(statearr_77136_77195[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (42))){
var inst_77064 = (state_77077[(13)]);
var state_77077__$1 = state_77077;
var statearr_77137_77196 = state_77077__$1;
(statearr_77137_77196[(2)] = inst_77064);

(statearr_77137_77196[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (37))){
var inst_77032 = (state_77077[(9)]);
var inst_77033 = (state_77077[(10)]);
var inst_77051 = (state_77077[(2)]);
var inst_77052 = (inst_77033 < inst_77032);
var state_77077__$1 = (function (){var statearr_77138 = state_77077;
(statearr_77138[(20)] = inst_77051);

return statearr_77138;
})();
if(cljs.core.truth_(inst_77052)){
var statearr_77139_77197 = state_77077__$1;
(statearr_77139_77197[(1)] = (38));

} else {
var statearr_77140_77198 = state_77077__$1;
(statearr_77140_77198[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77078 === (8))){
var inst_76963 = (state_77077[(18)]);
var inst_76963__$1 = (state_77077[(2)]);
var inst_76964 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_76963__$1);
var state_77077__$1 = (function (){var statearr_77141 = state_77077;
(statearr_77141[(18)] = inst_76963__$1);

return statearr_77141;
})();
if(cljs.core.truth_(inst_76964)){
var statearr_77142_77199 = state_77077__$1;
(statearr_77142_77199[(1)] = (9));

} else {
var statearr_77143_77200 = state_77077__$1;
(statearr_77143_77200[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__16221__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__16221__auto____0 = (function (){
var statearr_77144 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77144[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__16221__auto__);

(statearr_77144[(1)] = (1));

return statearr_77144;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__16221__auto____1 = (function (state_77077){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_77077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e77145){var ex__16224__auto__ = e77145;
var statearr_77146_77201 = state_77077;
(statearr_77146_77201[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_77077[(4)]))){
var statearr_77147_77202 = state_77077;
(statearr_77147_77202[(1)] = cljs.core.first.call(null,(state_77077[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77203 = state_77077;
state_77077 = G__77203;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__16221__auto__ = function(state_77077){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__16221__auto____1.call(this,state_77077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__16221__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__16221__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_77148 = f__16346__auto__.call(null);
(statearr_77148[(6)] = c__16345__auto__);

return statearr_77148;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_77353){
var state_val_77354 = (state_77353[(1)]);
if((state_val_77354 === (7))){
var inst_77265 = (state_77353[(2)]);
var inst_77266 = cljs.core.nth.call(null,inst_77265,(0),null);
var inst_77267 = cljs.core.nth.call(null,inst_77265,(1),null);
var inst_77275 = cljs.core.vals.call(null,inst_77267);
var inst_77276 = cljs.core.seq.call(null,inst_77275);
var inst_77277 = cljs.core.first.call(null,inst_77276);
var inst_77278 = cljs.core.next.call(null,inst_77276);
var inst_77279 = cljs.core.PersistentVector.EMPTY;
var inst_77280 = inst_77275;
var inst_77281 = inst_77279;
var state_77353__$1 = (function (){var statearr_77355 = state_77353;
(statearr_77355[(7)] = inst_77277);

(statearr_77355[(8)] = inst_77281);

(statearr_77355[(9)] = inst_77278);

(statearr_77355[(10)] = inst_77280);

(statearr_77355[(11)] = inst_77266);

return statearr_77355;
})();
var statearr_77356_77409 = state_77353__$1;
(statearr_77356_77409[(2)] = null);

(statearr_77356_77409[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (20))){
var inst_77287 = (state_77353[(12)]);
var inst_77292 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_77293 = cljs.core.PersistentHashMap.EMPTY;
var inst_77294 = [true,inst_77293];
var inst_77295 = cljs.core.PersistentHashMap.fromArrays(inst_77292,inst_77294);
var inst_77296 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_77295,inst_77287);
var state_77353__$1 = state_77353;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77353__$1,(22),inst_77296);
} else {
if((state_val_77354 === (27))){
var inst_77341 = (state_77353[(2)]);
var state_77353__$1 = state_77353;
var statearr_77357_77410 = state_77353__$1;
(statearr_77357_77410[(2)] = inst_77341);

(statearr_77357_77410[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (1))){
var state_77353__$1 = state_77353;
var statearr_77358_77411 = state_77353__$1;
(statearr_77358_77411[(2)] = null);

(statearr_77358_77411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (24))){
var inst_77305 = (state_77353[(13)]);
var inst_77343 = (state_77353[(2)]);
var inst_77344 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_77345 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_77346 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_77347 = [inst_77345,inst_77346,inst_77305,inst_77343];
var inst_77348 = cljs.core.PersistentHashMap.fromArrays(inst_77344,inst_77347);
var _ = (function (){var statearr_77360 = state_77353;
(statearr_77360[(4)] = cljs.core.rest.call(null,(state_77353[(4)])));

return statearr_77360;
})();
var state_77353__$1 = state_77353;
var statearr_77361_77412 = state_77353__$1;
(statearr_77361_77412[(2)] = inst_77348);

(statearr_77361_77412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (4))){
var inst_77206 = (state_77353[(2)]);
var state_77353__$1 = state_77353;
var statearr_77362_77413 = state_77353__$1;
(statearr_77362_77413[(2)] = inst_77206);

(statearr_77362_77413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (15))){
var inst_77244 = (state_77353[(14)]);
var inst_77246 = (state_77353[(15)]);
var inst_77251 = (state_77353[(16)]);
var inst_77229 = (state_77353[(17)]);
var inst_77228 = (state_77353[(18)]);
var inst_77225 = (state_77353[(19)]);
var inst_77230 = (state_77353[(20)]);
var inst_77222 = (state_77353[(21)]);
var inst_77224 = (state_77353[(22)]);
var inst_77236 = (state_77353[(23)]);
var inst_77237 = (state_77353[(24)]);
var inst_77257 = (function (){var subject = inst_77244;
var flake = inst_77236;
var seq__77220 = inst_77225;
var r = inst_77237;
var asserted_subjects = inst_77229;
var G__77218 = inst_77228;
var flake_SINGLEQUOTE_ = inst_77251;
var retracted_subjects = inst_77230;
var first__77221 = inst_77224;
var vec__77219 = inst_77222;
var first__77234 = inst_77236;
var vec__77232 = inst_77228;
var seq__77233 = inst_77237;
var asserted_QMARK_ = inst_77246;
return (function (p1__77205_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__77205_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_77258 = cljs.core.update.call(null,inst_77230,inst_77244,inst_77257);
var tmp77359 = inst_77229;
var inst_77228__$1 = inst_77237;
var inst_77229__$1 = tmp77359;
var inst_77230__$1 = inst_77258;
var state_77353__$1 = (function (){var statearr_77363 = state_77353;
(statearr_77363[(17)] = inst_77229__$1);

(statearr_77363[(18)] = inst_77228__$1);

(statearr_77363[(20)] = inst_77230__$1);

return statearr_77363;
})();
var statearr_77364_77414 = state_77353__$1;
(statearr_77364_77414[(2)] = null);

(statearr_77364_77414[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (21))){
var inst_77303 = (state_77353[(2)]);
var state_77353__$1 = state_77353;
var statearr_77365_77415 = state_77353__$1;
(statearr_77365_77415[(2)] = inst_77303);

(statearr_77365_77415[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (13))){
var inst_77246 = (state_77353[(15)]);
var inst_77251 = (state_77353[(2)]);
var state_77353__$1 = (function (){var statearr_77366 = state_77353;
(statearr_77366[(16)] = inst_77251);

return statearr_77366;
})();
if(cljs.core.truth_(inst_77246)){
var statearr_77367_77416 = state_77353__$1;
(statearr_77367_77416[(1)] = (14));

} else {
var statearr_77368_77417 = state_77353__$1;
(statearr_77368_77417[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (22))){
var inst_77281 = (state_77353[(8)]);
var inst_77288 = (state_77353[(25)]);
var inst_77298 = (state_77353[(2)]);
var inst_77299 = fluree.db.util.async.throw_err.call(null,inst_77298);
var inst_77300 = cljs.core.conj.call(null,inst_77281,inst_77299);
var inst_77280 = inst_77288;
var inst_77281__$1 = inst_77300;
var state_77353__$1 = (function (){var statearr_77369 = state_77353;
(statearr_77369[(8)] = inst_77281__$1);

(statearr_77369[(10)] = inst_77280);

return statearr_77369;
})();
var statearr_77370_77418 = state_77353__$1;
(statearr_77370_77418[(2)] = null);

(statearr_77370_77418[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (6))){
var inst_77228 = (state_77353[(18)]);
var inst_77236 = (state_77353[(23)]);
var inst_77235 = cljs.core.seq.call(null,inst_77228);
var inst_77236__$1 = cljs.core.first.call(null,inst_77235);
var inst_77237 = cljs.core.next.call(null,inst_77235);
var inst_77238 = cljs.core.not.call(null,inst_77236__$1);
var state_77353__$1 = (function (){var statearr_77371 = state_77353;
(statearr_77371[(23)] = inst_77236__$1);

(statearr_77371[(24)] = inst_77237);

return statearr_77371;
})();
if(inst_77238){
var statearr_77372_77419 = state_77353__$1;
(statearr_77372_77419[(1)] = (8));

} else {
var statearr_77373_77420 = state_77353__$1;
(statearr_77373_77420[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (28))){
var inst_77319 = (state_77353[(26)]);
var inst_77326 = (state_77353[(27)]);
var inst_77336 = (state_77353[(2)]);
var inst_77337 = fluree.db.util.async.throw_err.call(null,inst_77336);
var inst_77338 = cljs.core.conj.call(null,inst_77319,inst_77337);
var inst_77318 = inst_77326;
var inst_77319__$1 = inst_77338;
var state_77353__$1 = (function (){var statearr_77374 = state_77353;
(statearr_77374[(26)] = inst_77319__$1);

(statearr_77374[(28)] = inst_77318);

return statearr_77374;
})();
var statearr_77375_77421 = state_77353__$1;
(statearr_77375_77421[(2)] = null);

(statearr_77375_77421[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (25))){
var inst_77319 = (state_77353[(26)]);
var state_77353__$1 = state_77353;
var statearr_77376_77422 = state_77353__$1;
(statearr_77376_77422[(2)] = inst_77319);

(statearr_77376_77422[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (17))){
var inst_77287 = (state_77353[(12)]);
var inst_77280 = (state_77353[(10)]);
var inst_77286 = cljs.core.seq.call(null,inst_77280);
var inst_77287__$1 = cljs.core.first.call(null,inst_77286);
var inst_77288 = cljs.core.next.call(null,inst_77286);
var inst_77289 = cljs.core.not.call(null,inst_77287__$1);
var state_77353__$1 = (function (){var statearr_77377 = state_77353;
(statearr_77377[(12)] = inst_77287__$1);

(statearr_77377[(25)] = inst_77288);

return statearr_77377;
})();
if(inst_77289){
var statearr_77378_77423 = state_77353__$1;
(statearr_77378_77423[(1)] = (19));

} else {
var statearr_77379_77424 = state_77353__$1;
(statearr_77379_77424[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (3))){
var inst_77351 = (state_77353[(2)]);
var state_77353__$1 = state_77353;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77353__$1,inst_77351);
} else {
if((state_val_77354 === (12))){
var inst_77236 = (state_77353[(23)]);
var inst_77249 = fluree.db.flake.flip_flake.call(null,inst_77236);
var state_77353__$1 = state_77353;
var statearr_77380_77425 = state_77353__$1;
(statearr_77380_77425[(2)] = inst_77249);

(statearr_77380_77425[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (2))){
var inst_77222 = (state_77353[(21)]);
var _ = (function (){var statearr_77381 = state_77353;
(statearr_77381[(4)] = cljs.core.cons.call(null,(5),(state_77353[(4)])));

return statearr_77381;
})();
var inst_77222__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_77223 = cljs.core.seq.call(null,inst_77222__$1);
var inst_77224 = cljs.core.first.call(null,inst_77223);
var inst_77225 = cljs.core.next.call(null,inst_77223);
var inst_77226 = cljs.core.PersistentHashMap.EMPTY;
var inst_77227 = cljs.core.PersistentHashMap.EMPTY;
var inst_77228 = inst_77222__$1;
var inst_77229 = inst_77226;
var inst_77230 = inst_77227;
var state_77353__$1 = (function (){var statearr_77382 = state_77353;
(statearr_77382[(17)] = inst_77229);

(statearr_77382[(18)] = inst_77228);

(statearr_77382[(19)] = inst_77225);

(statearr_77382[(20)] = inst_77230);

(statearr_77382[(21)] = inst_77222__$1);

(statearr_77382[(22)] = inst_77224);

return statearr_77382;
})();
var statearr_77383_77426 = state_77353__$1;
(statearr_77383_77426[(2)] = null);

(statearr_77383_77426[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (23))){
var inst_77318 = (state_77353[(28)]);
var inst_77325 = (state_77353[(29)]);
var inst_77324 = cljs.core.seq.call(null,inst_77318);
var inst_77325__$1 = cljs.core.first.call(null,inst_77324);
var inst_77326 = cljs.core.next.call(null,inst_77324);
var inst_77327 = cljs.core.not.call(null,inst_77325__$1);
var state_77353__$1 = (function (){var statearr_77384 = state_77353;
(statearr_77384[(27)] = inst_77326);

(statearr_77384[(29)] = inst_77325__$1);

return statearr_77384;
})();
if(inst_77327){
var statearr_77385_77427 = state_77353__$1;
(statearr_77385_77427[(1)] = (25));

} else {
var statearr_77386_77428 = state_77353__$1;
(statearr_77386_77428[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (19))){
var inst_77281 = (state_77353[(8)]);
var state_77353__$1 = state_77353;
var statearr_77387_77429 = state_77353__$1;
(statearr_77387_77429[(2)] = inst_77281);

(statearr_77387_77429[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (11))){
var inst_77236 = (state_77353[(23)]);
var state_77353__$1 = state_77353;
var statearr_77389_77430 = state_77353__$1;
(statearr_77389_77430[(2)] = inst_77236);

(statearr_77389_77430[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (9))){
var inst_77246 = (state_77353[(15)]);
var inst_77236 = (state_77353[(23)]);
var inst_77244 = inst_77236.s;
var inst_77245 = inst_77236.op;
var inst_77246__$1 = inst_77245 === true;
var state_77353__$1 = (function (){var statearr_77391 = state_77353;
(statearr_77391[(14)] = inst_77244);

(statearr_77391[(15)] = inst_77246__$1);

return statearr_77391;
})();
if(cljs.core.truth_(inst_77246__$1)){
var statearr_77392_77431 = state_77353__$1;
(statearr_77392_77431[(1)] = (11));

} else {
var statearr_77393_77432 = state_77353__$1;
(statearr_77393_77432[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (5))){
var _ = (function (){var statearr_77394 = state_77353;
(statearr_77394[(4)] = cljs.core.rest.call(null,(state_77353[(4)])));

return statearr_77394;
})();
var state_77353__$1 = state_77353;
var ex77388 = (state_77353__$1[(2)]);
var statearr_77395_77433 = state_77353__$1;
(statearr_77395_77433[(5)] = ex77388);


if((ex77388 instanceof Error)){
var statearr_77396_77434 = state_77353__$1;
(statearr_77396_77434[(1)] = (4));

(statearr_77396_77434[(5)] = null);

} else {
throw ex77388;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (14))){
var inst_77244 = (state_77353[(14)]);
var inst_77246 = (state_77353[(15)]);
var inst_77251 = (state_77353[(16)]);
var inst_77229 = (state_77353[(17)]);
var inst_77228 = (state_77353[(18)]);
var inst_77225 = (state_77353[(19)]);
var inst_77230 = (state_77353[(20)]);
var inst_77222 = (state_77353[(21)]);
var inst_77224 = (state_77353[(22)]);
var inst_77236 = (state_77353[(23)]);
var inst_77237 = (state_77353[(24)]);
var inst_77253 = (function (){var subject = inst_77244;
var flake = inst_77236;
var seq__77220 = inst_77225;
var r = inst_77237;
var asserted_subjects = inst_77229;
var G__77218 = inst_77228;
var flake_SINGLEQUOTE_ = inst_77251;
var retracted_subjects = inst_77230;
var first__77221 = inst_77224;
var vec__77219 = inst_77222;
var first__77234 = inst_77236;
var vec__77232 = inst_77228;
var seq__77233 = inst_77237;
var asserted_QMARK_ = inst_77246;
return (function (p1__77204_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__77204_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_77254 = cljs.core.update.call(null,inst_77229,inst_77244,inst_77253);
var tmp77390 = inst_77230;
var inst_77228__$1 = inst_77237;
var inst_77229__$1 = inst_77254;
var inst_77230__$1 = tmp77390;
var state_77353__$1 = (function (){var statearr_77397 = state_77353;
(statearr_77397[(17)] = inst_77229__$1);

(statearr_77397[(18)] = inst_77228__$1);

(statearr_77397[(20)] = inst_77230__$1);

return statearr_77397;
})();
var statearr_77398_77435 = state_77353__$1;
(statearr_77398_77435[(2)] = null);

(statearr_77398_77435[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (26))){
var inst_77325 = (state_77353[(29)]);
var inst_77330 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_77331 = cljs.core.PersistentHashMap.EMPTY;
var inst_77332 = [true,inst_77331];
var inst_77333 = cljs.core.PersistentHashMap.fromArrays(inst_77330,inst_77332);
var inst_77334 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_77333,inst_77325);
var state_77353__$1 = state_77353;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77353__$1,(28),inst_77334);
} else {
if((state_val_77354 === (16))){
var inst_77261 = (state_77353[(2)]);
var state_77353__$1 = state_77353;
var statearr_77399_77436 = state_77353__$1;
(statearr_77399_77436[(2)] = inst_77261);

(statearr_77399_77436[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (10))){
var inst_77263 = (state_77353[(2)]);
var state_77353__$1 = state_77353;
var statearr_77400_77437 = state_77353__$1;
(statearr_77400_77437[(2)] = inst_77263);

(statearr_77400_77437[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (18))){
var inst_77266 = (state_77353[(11)]);
var inst_77305 = (state_77353[(2)]);
var inst_77313 = cljs.core.vals.call(null,inst_77266);
var inst_77314 = cljs.core.seq.call(null,inst_77313);
var inst_77315 = cljs.core.first.call(null,inst_77314);
var inst_77316 = cljs.core.next.call(null,inst_77314);
var inst_77317 = cljs.core.PersistentVector.EMPTY;
var inst_77318 = inst_77313;
var inst_77319 = inst_77317;
var state_77353__$1 = (function (){var statearr_77401 = state_77353;
(statearr_77401[(30)] = inst_77316);

(statearr_77401[(31)] = inst_77315);

(statearr_77401[(26)] = inst_77319);

(statearr_77401[(13)] = inst_77305);

(statearr_77401[(28)] = inst_77318);

return statearr_77401;
})();
var statearr_77402_77438 = state_77353__$1;
(statearr_77402_77438[(2)] = null);

(statearr_77402_77438[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77354 === (8))){
var inst_77229 = (state_77353[(17)]);
var inst_77230 = (state_77353[(20)]);
var inst_77240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77241 = [inst_77229,inst_77230];
var inst_77242 = (new cljs.core.PersistentVector(null,2,(5),inst_77240,inst_77241,null));
var state_77353__$1 = state_77353;
var statearr_77403_77439 = state_77353__$1;
(statearr_77403_77439[(2)] = inst_77242);

(statearr_77403_77439[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__16221__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__16221__auto____0 = (function (){
var statearr_77404 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77404[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__16221__auto__);

(statearr_77404[(1)] = (1));

return statearr_77404;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__16221__auto____1 = (function (state_77353){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_77353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e77405){var ex__16224__auto__ = e77405;
var statearr_77406_77440 = state_77353;
(statearr_77406_77440[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_77353[(4)]))){
var statearr_77407_77441 = state_77353;
(statearr_77407_77441[(1)] = cljs.core.first.call(null,(state_77353[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77442 = state_77353;
state_77353 = G__77442;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__16221__auto__ = function(state_77353){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__16221__auto____1.call(this,state_77353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__16221__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__16221__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_77408 = f__16346__auto__.call(null);
(statearr_77408[(6)] = c__16345__auto__);

return statearr_77408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_77474){
var state_val_77475 = (state_77474[(1)]);
if((state_val_77475 === (1))){
var inst_77443 = cljs.core.volatile_BANG_.call(null,(0));
var inst_77444 = cljs.core.PersistentHashMap.EMPTY;
var inst_77445 = cljs.core.volatile_BANG_.call(null,inst_77444);
var inst_77446 = cljs.core.first.call(null,resp);
var inst_77447 = cljs.core.rest.call(null,resp);
var inst_77448 = cljs.core.PersistentVector.EMPTY;
var inst_77449 = inst_77443;
var inst_77450 = inst_77445;
var inst_77451 = inst_77446;
var inst_77452 = inst_77447;
var inst_77453 = inst_77448;
var state_77474__$1 = (function (){var statearr_77476 = state_77474;
(statearr_77476[(7)] = inst_77449);

(statearr_77476[(8)] = inst_77450);

(statearr_77476[(9)] = inst_77451);

(statearr_77476[(10)] = inst_77452);

(statearr_77476[(11)] = inst_77453);

return statearr_77476;
})();
var statearr_77477_77492 = state_77474__$1;
(statearr_77477_77492[(2)] = null);

(statearr_77477_77492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77475 === (2))){
var inst_77449 = (state_77474[(7)]);
var inst_77450 = (state_77474[(8)]);
var inst_77451 = (state_77474[(9)]);
var inst_77455 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_77451,inst_77450,inst_77449);
var state_77474__$1 = state_77474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77474__$1,(4),inst_77455);
} else {
if((state_val_77475 === (3))){
var inst_77472 = (state_77474[(2)]);
var state_77474__$1 = state_77474;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77474__$1,inst_77472);
} else {
if((state_val_77475 === (4))){
var inst_77452 = (state_77474[(10)]);
var inst_77453 = (state_77474[(11)]);
var inst_77457 = (state_77474[(2)]);
var inst_77458 = fluree.db.util.async.throw_err.call(null,inst_77457);
var inst_77459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77460 = [inst_77458];
var inst_77461 = (new cljs.core.PersistentVector(null,1,(5),inst_77459,inst_77460,null));
var inst_77462 = cljs.core.concat.call(null,inst_77453,inst_77461);
var inst_77463 = cljs.core.first.call(null,inst_77452);
var state_77474__$1 = (function (){var statearr_77480 = state_77474;
(statearr_77480[(12)] = inst_77462);

return statearr_77480;
})();
if(cljs.core.truth_(inst_77463)){
var statearr_77481_77493 = state_77474__$1;
(statearr_77481_77493[(1)] = (5));

} else {
var statearr_77482_77494 = state_77474__$1;
(statearr_77482_77494[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77475 === (5))){
var inst_77449 = (state_77474[(7)]);
var inst_77450 = (state_77474[(8)]);
var inst_77462 = (state_77474[(12)]);
var inst_77452 = (state_77474[(10)]);
var inst_77465 = cljs.core.first.call(null,inst_77452);
var inst_77466 = cljs.core.rest.call(null,inst_77452);
var tmp77478 = inst_77449;
var tmp77479 = inst_77450;
var inst_77449__$1 = tmp77478;
var inst_77450__$1 = tmp77479;
var inst_77451 = inst_77465;
var inst_77452__$1 = inst_77466;
var inst_77453 = inst_77462;
var state_77474__$1 = (function (){var statearr_77483 = state_77474;
(statearr_77483[(7)] = inst_77449__$1);

(statearr_77483[(8)] = inst_77450__$1);

(statearr_77483[(9)] = inst_77451);

(statearr_77483[(10)] = inst_77452__$1);

(statearr_77483[(11)] = inst_77453);

return statearr_77483;
})();
var statearr_77484_77495 = state_77474__$1;
(statearr_77484_77495[(2)] = null);

(statearr_77484_77495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77475 === (6))){
var inst_77462 = (state_77474[(12)]);
var state_77474__$1 = state_77474;
var statearr_77485_77496 = state_77474__$1;
(statearr_77485_77496[(2)] = inst_77462);

(statearr_77485_77496[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77475 === (7))){
var inst_77470 = (state_77474[(2)]);
var state_77474__$1 = state_77474;
var statearr_77486_77497 = state_77474__$1;
(statearr_77486_77497[(2)] = inst_77470);

(statearr_77486_77497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__16221__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__16221__auto____0 = (function (){
var statearr_77487 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77487[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__16221__auto__);

(statearr_77487[(1)] = (1));

return statearr_77487;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__16221__auto____1 = (function (state_77474){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_77474);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e77488){var ex__16224__auto__ = e77488;
var statearr_77489_77498 = state_77474;
(statearr_77489_77498[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_77474[(4)]))){
var statearr_77490_77499 = state_77474;
(statearr_77490_77499[(1)] = cljs.core.first.call(null,(state_77474[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77500 = state_77474;
state_77474 = G__77500;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__16221__auto__ = function(state_77474){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__16221__auto____1.call(this,state_77474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__16221__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__16221__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_77491 = f__16346__auto__.call(null);
(statearr_77491[(6)] = c__16345__auto__);

return statearr_77491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__77502 = arguments.length;
switch (G__77502) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__77504){
var map__77505 = p__77504;
var map__77505__$1 = cljs.core.__destructure_map.call(null,map__77505);
var query = map__77505__$1;
var opts = cljs.core.get.call(null,map__77505__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_77590){
var state_val_77591 = (state_77590[(1)]);
if((state_val_77591 === (7))){
var inst_77516 = (state_77590[(7)]);
var inst_77520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77521 = ["_auth/id",inst_77516];
var inst_77522 = (new cljs.core.PersistentVector(null,2,(5),inst_77520,inst_77521,null));
var state_77590__$1 = state_77590;
var statearr_77592_77636 = state_77590__$1;
(statearr_77592_77636[(2)] = inst_77522);

(statearr_77592_77636[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (20))){
var inst_77570 = (state_77590[(2)]);
var inst_77571 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_77590__$1 = (function (){var statearr_77593 = state_77590;
(statearr_77593[(8)] = inst_77570);

return statearr_77593;
})();
if(cljs.core.truth_(inst_77571)){
var statearr_77594_77637 = state_77590__$1;
(statearr_77594_77637[(1)] = (22));

} else {
var statearr_77595_77638 = state_77590__$1;
(statearr_77595_77638[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (27))){
var inst_77517 = (state_77590[(9)]);
var inst_77573 = (state_77590[(10)]);
var inst_77579 = (state_77590[(2)]);
var inst_77580 = fluree.db.util.core.response_time_formatted.call(null,inst_77517);
var inst_77581 = [(200),inst_77579,(100),inst_77580];
var inst_77582 = cljs.core.PersistentHashMap.fromArrays(inst_77573,inst_77581);
var state_77590__$1 = state_77590;
var statearr_77596_77639 = state_77590__$1;
(statearr_77596_77639[(2)] = inst_77582);

(statearr_77596_77639[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (1))){
var state_77590__$1 = state_77590;
var statearr_77597_77640 = state_77590__$1;
(statearr_77597_77640[(2)] = null);

(statearr_77597_77640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (24))){
var inst_77585 = (state_77590[(2)]);
var _ = (function (){var statearr_77598 = state_77590;
(statearr_77598[(4)] = cljs.core.rest.call(null,(state_77590[(4)])));

return statearr_77598;
})();
var state_77590__$1 = state_77590;
var statearr_77599_77641 = state_77590__$1;
(statearr_77599_77641[(2)] = inst_77585);

(statearr_77599_77641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (4))){
var inst_77506 = (state_77590[(2)]);
var state_77590__$1 = state_77590;
var statearr_77600_77642 = state_77590__$1;
(statearr_77600_77642[(2)] = inst_77506);

(statearr_77600_77642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (15))){
var inst_77557 = (state_77590[(11)]);
var state_77590__$1 = state_77590;
var statearr_77601_77643 = state_77590__$1;
(statearr_77601_77643[(2)] = inst_77557);

(statearr_77601_77643[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (21))){
var inst_77566 = (state_77590[(2)]);
var inst_77567 = fluree.db.util.async.throw_err.call(null,inst_77566);
var state_77590__$1 = state_77590;
var statearr_77602_77644 = state_77590__$1;
(statearr_77602_77644[(2)] = inst_77567);

(statearr_77602_77644[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (13))){
var inst_77515 = (state_77590[(12)]);
var inst_77557 = (state_77590[(11)]);
var inst_77556 = (state_77590[(2)]);
var inst_77557__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_77515);
var state_77590__$1 = (function (){var statearr_77603 = state_77590;
(statearr_77603[(11)] = inst_77557__$1);

(statearr_77603[(13)] = inst_77556);

return statearr_77603;
})();
if(cljs.core.truth_(inst_77557__$1)){
var statearr_77604_77645 = state_77590__$1;
(statearr_77604_77645[(1)] = (15));

} else {
var statearr_77605_77646 = state_77590__$1;
(statearr_77605_77646[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (22))){
var inst_77570 = (state_77590[(8)]);
var inst_77573 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_77574 = cljs.core.sequential_QMARK_.call(null,inst_77570);
var state_77590__$1 = (function (){var statearr_77606 = state_77590;
(statearr_77606[(10)] = inst_77573);

return statearr_77606;
})();
if(inst_77574){
var statearr_77607_77647 = state_77590__$1;
(statearr_77607_77647[(1)] = (25));

} else {
var statearr_77608_77648 = state_77590__$1;
(statearr_77608_77648[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (6))){
var inst_77515 = (state_77590[(12)]);
var inst_77531 = (state_77590[(14)]);
var inst_77530 = (state_77590[(2)]);
var inst_77531__$1 = fluree.db.util.async.throw_err.call(null,inst_77530);
var inst_77532 = fluree.db.api.query.resolve_block_range.call(null,inst_77531__$1,inst_77515);
var state_77590__$1 = (function (){var statearr_77609 = state_77590;
(statearr_77609[(14)] = inst_77531__$1);

return statearr_77609;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77590__$1,(10),inst_77532);
} else {
if((state_val_77591 === (25))){
var inst_77570 = (state_77590[(8)]);
var inst_77576 = cljs.core.doall.call(null,inst_77570);
var state_77590__$1 = state_77590;
var statearr_77610_77649 = state_77590__$1;
(statearr_77610_77649[(2)] = inst_77576);

(statearr_77610_77649[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (17))){
var inst_77562 = (state_77590[(2)]);
var state_77590__$1 = state_77590;
if(cljs.core.truth_(inst_77562)){
var statearr_77611_77650 = state_77590__$1;
(statearr_77611_77650[(1)] = (18));

} else {
var statearr_77612_77651 = state_77590__$1;
(statearr_77612_77651[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (3))){
var inst_77588 = (state_77590[(2)]);
var state_77590__$1 = state_77590;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77590__$1,inst_77588);
} else {
if((state_val_77591 === (12))){
var inst_77515 = (state_77590[(12)]);
var inst_77548 = cljs.core.pr_str.call(null,inst_77515);
var inst_77549 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_77548].join('');
var inst_77550 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77551 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_77552 = cljs.core.PersistentHashMap.fromArrays(inst_77550,inst_77551);
var inst_77553 = cljs.core.ex_info.call(null,inst_77549,inst_77552);
var inst_77554 = (function(){throw inst_77553})();
var state_77590__$1 = state_77590;
var statearr_77613_77652 = state_77590__$1;
(statearr_77613_77652[(2)] = inst_77554);

(statearr_77613_77652[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (2))){
var inst_77516 = (state_77590[(7)]);
var _ = (function (){var statearr_77614 = state_77590;
(statearr_77614[(4)] = cljs.core.cons.call(null,(5),(state_77590[(4)])));

return statearr_77614;
})();
var inst_77515 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_77516__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_77517 = fluree.db.util.core.current_time_millis.call(null);
var inst_77518 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_77590__$1 = (function (){var statearr_77615 = state_77590;
(statearr_77615[(9)] = inst_77517);

(statearr_77615[(12)] = inst_77515);

(statearr_77615[(15)] = inst_77518);

(statearr_77615[(7)] = inst_77516__$1);

return statearr_77615;
})();
if(cljs.core.truth_(inst_77516__$1)){
var statearr_77616_77653 = state_77590__$1;
(statearr_77616_77653[(1)] = (7));

} else {
var statearr_77617_77654 = state_77590__$1;
(statearr_77617_77654[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (23))){
var inst_77570 = (state_77590[(8)]);
var state_77590__$1 = state_77590;
var statearr_77618_77655 = state_77590__$1;
(statearr_77618_77655[(2)] = inst_77570);

(statearr_77618_77655[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (19))){
var inst_77556 = (state_77590[(13)]);
var state_77590__$1 = state_77590;
var statearr_77619_77656 = state_77590__$1;
(statearr_77619_77656[(2)] = inst_77556);

(statearr_77619_77656[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (11))){
var inst_77537 = (state_77590[(16)]);
var inst_77536 = (state_77590[(17)]);
var inst_77531 = (state_77590[(14)]);
var inst_77543 = fluree.db.api.query.block_range.call(null,inst_77531,inst_77536,inst_77537,opts);
var state_77590__$1 = state_77590;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77590__$1,(14),inst_77543);
} else {
if((state_val_77591 === (9))){
var inst_77518 = (state_77590[(15)]);
var inst_77525 = (state_77590[(2)]);
var inst_77526 = [inst_77525];
var inst_77527 = cljs.core.PersistentHashMap.fromArrays(inst_77518,inst_77526);
var inst_77528 = fluree.db.api.query.db.call(null,conn,ledger,inst_77527);
var state_77590__$1 = state_77590;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77590__$1,(6),inst_77528);
} else {
if((state_val_77591 === (5))){
var _ = (function (){var statearr_77621 = state_77590;
(statearr_77621[(4)] = cljs.core.rest.call(null,(state_77590[(4)])));

return statearr_77621;
})();
var state_77590__$1 = state_77590;
var ex77620 = (state_77590__$1[(2)]);
var statearr_77622_77657 = state_77590__$1;
(statearr_77622_77657[(5)] = ex77620);


if((ex77620 instanceof Error)){
var statearr_77623_77658 = state_77590__$1;
(statearr_77623_77658[(1)] = (4));

(statearr_77623_77658[(5)] = null);

} else {
throw ex77620;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (14))){
var inst_77545 = (state_77590[(2)]);
var inst_77546 = fluree.db.util.async.throw_err.call(null,inst_77545);
var state_77590__$1 = state_77590;
var statearr_77624_77659 = state_77590__$1;
(statearr_77624_77659[(2)] = inst_77546);

(statearr_77624_77659[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (26))){
var inst_77570 = (state_77590[(8)]);
var state_77590__$1 = state_77590;
var statearr_77625_77660 = state_77590__$1;
(statearr_77625_77660[(2)] = inst_77570);

(statearr_77625_77660[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (16))){
var inst_77515 = (state_77590[(12)]);
var inst_77560 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_77515);
var state_77590__$1 = state_77590;
var statearr_77626_77661 = state_77590__$1;
(statearr_77626_77661[(2)] = inst_77560);

(statearr_77626_77661[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (10))){
var inst_77515 = (state_77590[(12)]);
var inst_77534 = (state_77590[(2)]);
var inst_77535 = fluree.db.util.async.throw_err.call(null,inst_77534);
var inst_77536 = cljs.core.nth.call(null,inst_77535,(0),null);
var inst_77537 = cljs.core.nth.call(null,inst_77535,(1),null);
var inst_77538 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_77539 = cljs.core.dissoc.call(null,inst_77515,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_77540 = cljs.core.keys.call(null,inst_77539);
var inst_77541 = cljs.core._EQ_.call(null,inst_77538,inst_77540);
var state_77590__$1 = (function (){var statearr_77627 = state_77590;
(statearr_77627[(16)] = inst_77537);

(statearr_77627[(17)] = inst_77536);

return statearr_77627;
})();
if(inst_77541){
var statearr_77628_77662 = state_77590__$1;
(statearr_77628_77662[(1)] = (11));

} else {
var statearr_77629_77663 = state_77590__$1;
(statearr_77629_77663[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77591 === (18))){
var inst_77556 = (state_77590[(13)]);
var inst_77531 = (state_77590[(14)]);
var inst_77564 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_77531,inst_77556);
var state_77590__$1 = state_77590;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77590__$1,(21),inst_77564);
} else {
if((state_val_77591 === (8))){
var state_77590__$1 = state_77590;
var statearr_77630_77664 = state_77590__$1;
(statearr_77630_77664[(2)] = null);

(statearr_77630_77664[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__16221__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__16221__auto____0 = (function (){
var statearr_77631 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77631[(0)] = fluree$db$api$query$block_query_async_$_state_machine__16221__auto__);

(statearr_77631[(1)] = (1));

return statearr_77631;
});
var fluree$db$api$query$block_query_async_$_state_machine__16221__auto____1 = (function (state_77590){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_77590);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e77632){var ex__16224__auto__ = e77632;
var statearr_77633_77665 = state_77590;
(statearr_77633_77665[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_77590[(4)]))){
var statearr_77634_77666 = state_77590;
(statearr_77634_77666[(1)] = cljs.core.first.call(null,(state_77590[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77667 = state_77590;
state_77590 = G__77667;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__16221__auto__ = function(state_77590){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__16221__auto____1.call(this,state_77590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__16221__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__16221__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_77635 = f__16346__auto__.call(null);
(statearr_77635[(6)] = c__16345__auto__);

return statearr_77635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__77668 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__77668,(0),null);
var p = cljs.core.nth.call(null,vec__77668,(1),null);
var o = cljs.core.nth.call(null,vec__77668,(2),null);
var t = cljs.core.nth.call(null,vec__77668,(3),null);
var vec__77671 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__77671,(0),null);
var idx = cljs.core.nth.call(null,vec__77671,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__77674 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__77674,(0),null);
var id = cljs.core.nth.call(null,vec__77674,(1),null);
var or__4212__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4824__auto__ = [];
var len__4818__auto___77678 = arguments.length;
var i__4819__auto___77679 = (0);
while(true){
if((i__4819__auto___77679 < len__4818__auto___77678)){
args__4824__auto__.push((arguments[i__4819__auto___77679]));

var G__77680 = (i__4819__auto___77679 + (1));
i__4819__auto___77679 = G__77680;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq77677){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq77677));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_77876){
var state_val_77877 = (state_77876[(1)]);
if((state_val_77877 === (7))){
var inst_77796 = (state_77876[(7)]);
var inst_77803 = (state_77876[(8)]);
var inst_77802 = cljs.core.seq.call(null,inst_77796);
var inst_77803__$1 = cljs.core.first.call(null,inst_77802);
var inst_77804 = cljs.core.next.call(null,inst_77802);
var state_77876__$1 = (function (){var statearr_77878 = state_77876;
(statearr_77878[(9)] = inst_77804);

(statearr_77878[(8)] = inst_77803__$1);

return statearr_77878;
})();
if(cljs.core.truth_(inst_77803__$1)){
var statearr_77879_77979 = state_77876__$1;
(statearr_77879_77979[(1)] = (9));

} else {
var statearr_77880_77980 = state_77876__$1;
(statearr_77880_77980[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (20))){
var inst_77866 = (state_77876[(2)]);
var state_77876__$1 = state_77876;
var statearr_77881_77981 = state_77876__$1;
(statearr_77881_77981[(2)] = inst_77866);

(statearr_77881_77981[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (27))){
var inst_77821 = (state_77876[(10)]);
var inst_77824 = (state_77876[(11)]);
var inst_77842 = (state_77876[(12)]);
var inst_77844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77845 = [inst_77824,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_77846 = (new cljs.core.PersistentVector(null,2,(5),inst_77844,inst_77845,null));
var inst_77847 = cljs.core.update_in.call(null,inst_77842,inst_77846,fluree.db.api.query.min_safe,inst_77821);
var state_77876__$1 = state_77876;
var statearr_77882_77982 = state_77876__$1;
(statearr_77882_77982[(2)] = inst_77847);

(statearr_77882_77982[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (1))){
var state_77876__$1 = state_77876;
var statearr_77883_77983 = state_77876__$1;
(statearr_77883_77983[(2)] = null);

(statearr_77883_77983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (24))){
var inst_77834 = (state_77876[(13)]);
var inst_77803 = (state_77876[(8)]);
var inst_77824 = (state_77876[(11)]);
var inst_77836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77837 = [inst_77824,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_77838 = (new cljs.core.PersistentVector(null,2,(5),inst_77836,inst_77837,null));
var inst_77839 = cljs.core.update_in.call(null,inst_77834,inst_77838,cljs.core.conj,inst_77803);
var state_77876__$1 = state_77876;
var statearr_77885_77984 = state_77876__$1;
(statearr_77885_77984[(2)] = inst_77839);

(statearr_77885_77984[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (4))){
var inst_77682 = (state_77876[(2)]);
var state_77876__$1 = state_77876;
var statearr_77886_77985 = state_77876__$1;
(statearr_77886_77985[(2)] = inst_77682);

(statearr_77886_77985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (15))){
var inst_77804 = (state_77876[(9)]);
var inst_77797 = (state_77876[(14)]);
var tmp77884 = inst_77797;
var inst_77796 = inst_77804;
var inst_77797__$1 = tmp77884;
var state_77876__$1 = (function (){var statearr_77887 = state_77876;
(statearr_77887[(7)] = inst_77796);

(statearr_77887[(14)] = inst_77797__$1);

return statearr_77887;
})();
var statearr_77888_77986 = state_77876__$1;
(statearr_77888_77986[(2)] = null);

(statearr_77888_77986[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (21))){
var inst_77797 = (state_77876[(14)]);
var inst_77824 = (state_77876[(11)]);
var inst_77828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77829 = [inst_77824,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_77830 = (new cljs.core.PersistentVector(null,2,(5),inst_77828,inst_77829,null));
var inst_77831 = cljs.core.assoc_in.call(null,inst_77797,inst_77830,inst_77824);
var state_77876__$1 = state_77876;
var statearr_77889_77987 = state_77876__$1;
(statearr_77889_77987[(2)] = inst_77831);

(statearr_77889_77987[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (31))){
var inst_77850 = (state_77876[(15)]);
var state_77876__$1 = state_77876;
var statearr_77890_77988 = state_77876__$1;
(statearr_77890_77988[(2)] = inst_77850);

(statearr_77890_77988[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (32))){
var inst_77804 = (state_77876[(9)]);
var inst_77858 = (state_77876[(2)]);
var inst_77796 = inst_77804;
var inst_77797 = inst_77858;
var state_77876__$1 = (function (){var statearr_77891 = state_77876;
(statearr_77891[(7)] = inst_77796);

(statearr_77891[(14)] = inst_77797);

return statearr_77891;
})();
var statearr_77892_77989 = state_77876__$1;
(statearr_77892_77989[(2)] = null);

(statearr_77892_77989[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (33))){
var inst_77797 = (state_77876[(14)]);
var state_77876__$1 = state_77876;
var statearr_77893_77990 = state_77876__$1;
(statearr_77893_77990[(2)] = inst_77797);

(statearr_77893_77990[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (13))){
var inst_77806 = (state_77876[(16)]);
var state_77876__$1 = state_77876;
var statearr_77894_77991 = state_77876__$1;
(statearr_77894_77991[(2)] = inst_77806);

(statearr_77894_77991[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (22))){
var inst_77797 = (state_77876[(14)]);
var state_77876__$1 = state_77876;
var statearr_77895_77992 = state_77876__$1;
(statearr_77895_77992[(2)] = inst_77797);

(statearr_77895_77992[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (29))){
var inst_77850 = (state_77876[(2)]);
var state_77876__$1 = (function (){var statearr_77896 = state_77876;
(statearr_77896[(15)] = inst_77850);

return statearr_77896;
})();
if(cljs.core.truth_(show_auth)){
var statearr_77897_77993 = state_77876__$1;
(statearr_77897_77993[(1)] = (30));

} else {
var statearr_77898_77994 = state_77876__$1;
(statearr_77898_77994[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (6))){
var inst_77782 = (state_77876[(2)]);
var inst_77783 = fluree.db.util.async.throw_err.call(null,inst_77782);
var inst_77791 = resp;
var inst_77792 = cljs.core.seq.call(null,inst_77791);
var inst_77793 = cljs.core.first.call(null,inst_77792);
var inst_77794 = cljs.core.next.call(null,inst_77792);
var inst_77795 = cljs.core.PersistentHashMap.EMPTY;
var inst_77796 = inst_77791;
var inst_77797 = inst_77795;
var state_77876__$1 = (function (){var statearr_77899 = state_77876;
(statearr_77899[(17)] = inst_77794);

(statearr_77899[(18)] = inst_77783);

(statearr_77899[(7)] = inst_77796);

(statearr_77899[(19)] = inst_77793);

(statearr_77899[(14)] = inst_77797);

return statearr_77899;
})();
var statearr_77900_77995 = state_77876__$1;
(statearr_77900_77995[(2)] = null);

(statearr_77900_77995[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (28))){
var inst_77842 = (state_77876[(12)]);
var state_77876__$1 = state_77876;
var statearr_77901_77996 = state_77876__$1;
(statearr_77901_77996[(2)] = inst_77842);

(statearr_77901_77996[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (25))){
var inst_77834 = (state_77876[(13)]);
var state_77876__$1 = state_77876;
var statearr_77902_77997 = state_77876__$1;
(statearr_77902_77997[(2)] = inst_77834);

(statearr_77902_77997[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (34))){
var state_77876__$1 = state_77876;
var statearr_77903_77998 = state_77876__$1;
(statearr_77903_77998[(2)] = null);

(statearr_77903_77998[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (17))){
var inst_77868 = (state_77876[(2)]);
var state_77876__$1 = state_77876;
var statearr_77904_77999 = state_77876__$1;
(statearr_77904_77999[(2)] = inst_77868);

(statearr_77904_77999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (3))){
var inst_77874 = (state_77876[(2)]);
var state_77876__$1 = state_77876;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77876__$1,inst_77874);
} else {
if((state_val_77877 === (12))){
var inst_77783 = (state_77876[(18)]);
var inst_77803 = (state_77876[(8)]);
var inst_77808 = fluree.db.api.query.auth_match.call(null,auth,inst_77783,inst_77803);
var inst_77809 = cljs.core.not.call(null,inst_77808);
var state_77876__$1 = state_77876;
var statearr_77905_78000 = state_77876__$1;
(statearr_77905_78000[(2)] = inst_77809);

(statearr_77905_78000[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (2))){
var _ = (function (){var statearr_77906 = state_77876;
(statearr_77906[(4)] = cljs.core.cons.call(null,(5),(state_77876[(4)])));

return statearr_77906;
})();
var inst_77688 = (function (){return (function (p1__77681_SHARP_){
return p1__77681_SHARP_.t;
});
})();
var inst_77689 = cljs.core.map.call(null,inst_77688,resp);
var inst_77690 = cljs.core.set.call(null,inst_77689);
var inst_77778 = cljs.core.async.chan.call(null,(1));
var inst_77779 = (function (){var ts = inst_77690;
var c__16345__auto____$1 = inst_77778;
return (function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_77776){
var state_val_77777 = (state_77776[(1)]);
if((state_val_77777 === (7))){
var inst_77722 = (state_77776[(7)]);
var inst_77716 = (state_77776[(8)]);
var inst_77704 = (state_77776[(9)]);
var inst_77710 = (state_77776[(10)]);
var inst_77715 = (state_77776[(2)]);
var inst_77716__$1 = fluree.db.util.async.throw_err.call(null,inst_77715);
var inst_77718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77719 = [inst_77710,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_77720 = (new cljs.core.PersistentVector(null,2,(5),inst_77718,inst_77719,null));
var inst_77721 = cljs.core.assoc_in.call(null,inst_77704,inst_77720,inst_77716__$1);
var inst_77722__$1 = auth;
var state_77776__$1 = (function (){var statearr_77907 = state_77776;
(statearr_77907[(11)] = inst_77721);

(statearr_77907[(7)] = inst_77722__$1);

(statearr_77907[(8)] = inst_77716__$1);

return statearr_77907;
})();
if(cljs.core.truth_(inst_77722__$1)){
var statearr_77908_78001 = state_77776__$1;
(statearr_77908_78001[(1)] = (8));

} else {
var statearr_77909_78002 = state_77776__$1;
(statearr_77909_78002[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77777 === (1))){
var inst_77698 = (state_77776[(12)]);
var inst_77698__$1 = ts;
var inst_77699 = cljs.core.seq.call(null,inst_77698__$1);
var inst_77700 = cljs.core.first.call(null,inst_77699);
var inst_77701 = cljs.core.next.call(null,inst_77699);
var inst_77702 = cljs.core.PersistentHashMap.EMPTY;
var inst_77703 = inst_77698__$1;
var inst_77704 = inst_77702;
var state_77776__$1 = (function (){var statearr_77910 = state_77776;
(statearr_77910[(12)] = inst_77698__$1);

(statearr_77910[(13)] = inst_77700);

(statearr_77910[(14)] = inst_77701);

(statearr_77910[(9)] = inst_77704);

(statearr_77910[(15)] = inst_77703);

return statearr_77910;
})();
var statearr_77911_78003 = state_77776__$1;
(statearr_77911_78003[(2)] = null);

(statearr_77911_78003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77777 === (4))){
var inst_77710 = (state_77776[(10)]);
var inst_77713 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_77710);
var state_77776__$1 = state_77776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77776__$1,(7),inst_77713);
} else {
if((state_val_77777 === (13))){
var inst_77711 = (state_77776[(16)]);
var inst_77768 = (state_77776[(2)]);
var inst_77703 = inst_77711;
var inst_77704 = inst_77768;
var state_77776__$1 = (function (){var statearr_77912 = state_77776;
(statearr_77912[(9)] = inst_77704);

(statearr_77912[(15)] = inst_77703);

return statearr_77912;
})();
var statearr_77913_78004 = state_77776__$1;
(statearr_77913_78004[(2)] = null);

(statearr_77913_78004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77777 === (6))){
var inst_77772 = (state_77776[(2)]);
var state_77776__$1 = state_77776;
var statearr_77914_78005 = state_77776__$1;
(statearr_77914_78005[(2)] = inst_77772);

(statearr_77914_78005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77777 === (3))){
var inst_77774 = (state_77776[(2)]);
var state_77776__$1 = state_77776;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77776__$1,inst_77774);
} else {
if((state_val_77777 === (12))){
var inst_77721 = (state_77776[(11)]);
var state_77776__$1 = state_77776;
var statearr_77915_78006 = state_77776__$1;
(statearr_77915_78006[(2)] = inst_77721);

(statearr_77915_78006[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77777 === (2))){
var inst_77710 = (state_77776[(10)]);
var inst_77703 = (state_77776[(15)]);
var inst_77709 = cljs.core.seq.call(null,inst_77703);
var inst_77710__$1 = cljs.core.first.call(null,inst_77709);
var inst_77711 = cljs.core.next.call(null,inst_77709);
var state_77776__$1 = (function (){var statearr_77916 = state_77776;
(statearr_77916[(16)] = inst_77711);

(statearr_77916[(10)] = inst_77710__$1);

return statearr_77916;
})();
if(cljs.core.truth_(inst_77710__$1)){
var statearr_77917_78007 = state_77776__$1;
(statearr_77917_78007[(1)] = (4));

} else {
var statearr_77918_78008 = state_77776__$1;
(statearr_77918_78008[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77777 === (11))){
var inst_77698 = (state_77776[(12)]);
var inst_77721 = (state_77776[(11)]);
var inst_77700 = (state_77776[(13)]);
var inst_77701 = (state_77776[(14)]);
var inst_77716 = (state_77776[(8)]);
var inst_77704 = (state_77776[(9)]);
var inst_77711 = (state_77776[(16)]);
var inst_77710 = (state_77776[(10)]);
var inst_77703 = (state_77776[(15)]);
var inst_77728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77729 = [inst_77710,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_77730 = (new cljs.core.PersistentVector(null,2,(5),inst_77728,inst_77729,null));
var inst_77743 = cljs.core.async.chan.call(null,(1));
var inst_77744 = (function (){var t = inst_77710;
var vec__77706 = inst_77703;
var first__77708 = inst_77710;
var G__77717 = inst_77721;
var seq__77696 = inst_77701;
var block = inst_77716;
var r = inst_77711;
var seq__77707 = inst_77711;
var acc = inst_77704;
var vec__77695 = inst_77698;
var G__77694 = inst_77703;
var c__16345__auto____$2 = inst_77743;
var first__77697 = inst_77700;
return (function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_77741){
var state_val_77742 = (state_77741[(1)]);
if((state_val_77742 === (1))){
var state_77741__$1 = state_77741;
var statearr_77919_78009 = state_77741__$1;
(statearr_77919_78009[(2)] = null);

(statearr_77919_78009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77742 === (2))){
var ___$1 = (function (){var statearr_77920 = state_77741;
(statearr_77920[(4)] = cljs.core.cons.call(null,(5),(state_77741[(4)])));

return statearr_77920;
})();
var ___$2 = (function (){var statearr_77921 = state_77741;
(statearr_77921[(4)] = cljs.core.rest.call(null,(state_77741[(4)])));

return statearr_77921;
})();
var state_77741__$1 = state_77741;
var statearr_77922_78010 = state_77741__$1;
(statearr_77922_78010[(2)] = db);

(statearr_77922_78010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77742 === (3))){
var inst_77739 = (state_77741[(2)]);
var state_77741__$1 = state_77741;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77741__$1,inst_77739);
} else {
if((state_val_77742 === (4))){
var inst_77731 = (state_77741[(2)]);
var state_77741__$1 = state_77741;
var statearr_77924_78011 = state_77741__$1;
(statearr_77924_78011[(2)] = inst_77731);

(statearr_77924_78011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77742 === (5))){
var ___$1 = (function (){var statearr_77925 = state_77741;
(statearr_77925[(4)] = cljs.core.rest.call(null,(state_77741[(4)])));

return statearr_77925;
})();
var state_77741__$1 = state_77741;
var ex77923 = (state_77741__$1[(2)]);
var statearr_77926_78012 = state_77741__$1;
(statearr_77926_78012[(5)] = ex77923);


if((ex77923 instanceof Error)){
var statearr_77927_78013 = state_77741__$1;
(statearr_77927_78013[(1)] = (4));

(statearr_77927_78013[(5)] = null);

} else {
throw ex77923;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____0 = (function (){
var statearr_77928 = [null,null,null,null,null,null,null];
(statearr_77928[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__);

(statearr_77928[(1)] = (1));

return statearr_77928;
});
var fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____1 = (function (state_77741){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_77741);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e77929){var ex__16224__auto__ = e77929;
var statearr_77930_78014 = state_77741;
(statearr_77930_78014[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_77741[(4)]))){
var statearr_77931_78015 = state_77741;
(statearr_77931_78015[(1)] = cljs.core.first.call(null,(state_77741[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78016 = state_77741;
state_77741 = G__78016;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__ = function(state_77741){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____1.call(this,state_77741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_77932 = f__16346__auto__.call(null);
(statearr_77932[(6)] = c__16345__auto____$2);

return statearr_77932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
});
})();
var inst_77745 = cljs.core.async.impl.dispatch.run.call(null,inst_77744);
var inst_77746 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_77747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77748 = ["?auth","?id"];
var inst_77749 = (new cljs.core.PersistentVector(null,2,(5),inst_77747,inst_77748,null));
var inst_77750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77752 = [inst_77710,"_tx/auth","?auth"];
var inst_77753 = (new cljs.core.PersistentVector(null,3,(5),inst_77751,inst_77752,null));
var inst_77754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77755 = ["?auth","_auth/id","?id"];
var inst_77756 = (new cljs.core.PersistentVector(null,3,(5),inst_77754,inst_77755,null));
var inst_77757 = [inst_77753,inst_77756];
var inst_77758 = (new cljs.core.PersistentVector(null,2,(5),inst_77750,inst_77757,null));
var inst_77759 = [inst_77749,inst_77758];
var inst_77760 = cljs.core.PersistentHashMap.fromArrays(inst_77746,inst_77759);
var inst_77761 = fluree.db.api.query.query_async.call(null,inst_77743,inst_77760);
var state_77776__$1 = (function (){var statearr_77933 = state_77776;
(statearr_77933[(17)] = inst_77730);

(statearr_77933[(18)] = inst_77745);

return statearr_77933;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77776__$1,(14),inst_77761);
} else {
if((state_val_77777 === (9))){
var state_77776__$1 = state_77776;
var statearr_77934_78017 = state_77776__$1;
(statearr_77934_78017[(2)] = show_auth);

(statearr_77934_78017[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77777 === (5))){
var inst_77704 = (state_77776[(9)]);
var state_77776__$1 = state_77776;
var statearr_77935_78018 = state_77776__$1;
(statearr_77935_78018[(2)] = inst_77704);

(statearr_77935_78018[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77777 === (14))){
var inst_77721 = (state_77776[(11)]);
var inst_77730 = (state_77776[(17)]);
var inst_77763 = (state_77776[(2)]);
var inst_77764 = fluree.db.util.async.throw_err.call(null,inst_77763);
var inst_77765 = cljs.core.assoc_in.call(null,inst_77721,inst_77730,inst_77764);
var state_77776__$1 = state_77776;
var statearr_77936_78019 = state_77776__$1;
(statearr_77936_78019[(2)] = inst_77765);

(statearr_77936_78019[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77777 === (10))){
var inst_77726 = (state_77776[(2)]);
var state_77776__$1 = state_77776;
if(cljs.core.truth_(inst_77726)){
var statearr_77937_78020 = state_77776__$1;
(statearr_77937_78020[(1)] = (11));

} else {
var statearr_77938_78021 = state_77776__$1;
(statearr_77938_78021[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77777 === (8))){
var inst_77722 = (state_77776[(7)]);
var state_77776__$1 = state_77776;
var statearr_77939_78022 = state_77776__$1;
(statearr_77939_78022[(2)] = inst_77722);

(statearr_77939_78022[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____0 = (function (){
var statearr_77940 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77940[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__);

(statearr_77940[(1)] = (1));

return statearr_77940;
});
var fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____1 = (function (state_77776){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_77776);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e77941){var ex__16224__auto__ = e77941;
var statearr_77942_78023 = state_77776;
(statearr_77942_78023[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_77776[(4)]))){
var statearr_77943_78024 = state_77776;
(statearr_77943_78024[(1)] = cljs.core.first.call(null,(state_77776[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78025 = state_77776;
state_77776 = G__78025;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__ = function(state_77776){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____1.call(this,state_77776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_77944 = f__16346__auto__.call(null);
(statearr_77944[(6)] = c__16345__auto____$1);

return statearr_77944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
});
})();
var inst_77780 = cljs.core.async.impl.dispatch.run.call(null,inst_77779);
var state_77876__$1 = (function (){var statearr_77945 = state_77876;
(statearr_77945[(20)] = inst_77780);

return statearr_77945;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77876__$1,(6),inst_77778);
} else {
if((state_val_77877 === (23))){
var inst_77834 = (state_77876[(2)]);
var state_77876__$1 = (function (){var statearr_77946 = state_77876;
(statearr_77946[(13)] = inst_77834);

return statearr_77946;
})();
var statearr_77947_78026 = state_77876__$1;
(statearr_77947_78026[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (35))){
var inst_77864 = (state_77876[(2)]);
var state_77876__$1 = state_77876;
var statearr_77949_78027 = state_77876__$1;
(statearr_77949_78027[(2)] = inst_77864);

(statearr_77949_78027[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (19))){
var state_77876__$1 = state_77876;
var statearr_77950_78028 = state_77876__$1;
(statearr_77950_78028[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (11))){
var inst_77815 = (state_77876[(2)]);
var state_77876__$1 = state_77876;
if(cljs.core.truth_(inst_77815)){
var statearr_77953_78029 = state_77876__$1;
(statearr_77953_78029[(1)] = (15));

} else {
var statearr_77954_78030 = state_77876__$1;
(statearr_77954_78030[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (9))){
var inst_77806 = (state_77876[(16)]);
var inst_77806__$1 = auth;
var state_77876__$1 = (function (){var statearr_77955 = state_77876;
(statearr_77955[(16)] = inst_77806__$1);

return statearr_77955;
})();
if(cljs.core.truth_(inst_77806__$1)){
var statearr_77956_78031 = state_77876__$1;
(statearr_77956_78031[(1)] = (12));

} else {
var statearr_77957_78032 = state_77876__$1;
(statearr_77957_78032[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (5))){
var _ = (function (){var statearr_77958 = state_77876;
(statearr_77958[(4)] = cljs.core.rest.call(null,(state_77876[(4)])));

return statearr_77958;
})();
var state_77876__$1 = state_77876;
var ex77952 = (state_77876__$1[(2)]);
var statearr_77959_78033 = state_77876__$1;
(statearr_77959_78033[(5)] = ex77952);


if((ex77952 instanceof Error)){
var statearr_77960_78034 = state_77876__$1;
(statearr_77960_78034[(1)] = (4));

(statearr_77960_78034[(5)] = null);

} else {
throw ex77952;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (14))){
var inst_77812 = (state_77876[(2)]);
var state_77876__$1 = state_77876;
var statearr_77961_78035 = state_77876__$1;
(statearr_77961_78035[(2)] = inst_77812);

(statearr_77961_78035[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (26))){
var inst_77842 = (state_77876[(2)]);
var state_77876__$1 = (function (){var statearr_77962 = state_77876;
(statearr_77962[(12)] = inst_77842);

return statearr_77962;
})();
var statearr_77963_78036 = state_77876__$1;
(statearr_77963_78036[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (16))){
var inst_77803 = (state_77876[(8)]);
var state_77876__$1 = state_77876;
if(cljs.core.truth_(inst_77803)){
var statearr_77965_78037 = state_77876__$1;
(statearr_77965_78037[(1)] = (18));

} else {
var statearr_77966_78038 = state_77876__$1;
(statearr_77966_78038[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (30))){
var inst_77850 = (state_77876[(15)]);
var inst_77825 = (state_77876[(21)]);
var inst_77824 = (state_77876[(11)]);
var inst_77852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77853 = [inst_77824,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_77854 = (new cljs.core.PersistentVector(null,2,(5),inst_77852,inst_77853,null));
var inst_77855 = cljs.core.assoc_in.call(null,inst_77850,inst_77854,inst_77825);
var state_77876__$1 = state_77876;
var statearr_77967_78039 = state_77876__$1;
(statearr_77967_78039[(2)] = inst_77855);

(statearr_77967_78039[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (10))){
var inst_77803 = (state_77876[(8)]);
var state_77876__$1 = state_77876;
var statearr_77968_78040 = state_77876__$1;
(statearr_77968_78040[(2)] = inst_77803);

(statearr_77968_78040[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (18))){
var inst_77783 = (state_77876[(18)]);
var inst_77821 = (state_77876[(10)]);
var inst_77803 = (state_77876[(8)]);
var inst_77821__$1 = inst_77803.t;
var inst_77822 = cljs.core.get.call(null,inst_77783,inst_77821__$1);
var inst_77823 = cljs.core.__destructure_map.call(null,inst_77822);
var inst_77824 = cljs.core.get.call(null,inst_77823,new cljs.core.Keyword(null,"block","block",664686210));
var inst_77825 = cljs.core.get.call(null,inst_77823,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_77876__$1 = (function (){var statearr_77969 = state_77876;
(statearr_77969[(21)] = inst_77825);

(statearr_77969[(10)] = inst_77821__$1);

(statearr_77969[(11)] = inst_77824);

return statearr_77969;
})();
var statearr_77970_78041 = state_77876__$1;
(statearr_77970_78041[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77877 === (8))){
var inst_77870 = (state_77876[(2)]);
var inst_77871 = cljs.core.vals.call(null,inst_77870);
var _ = (function (){var statearr_77972 = state_77876;
(statearr_77972[(4)] = cljs.core.rest.call(null,(state_77876[(4)])));

return statearr_77972;
})();
var state_77876__$1 = state_77876;
var statearr_77973_78042 = state_77876__$1;
(statearr_77973_78042[(2)] = inst_77871);

(statearr_77973_78042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____0 = (function (){
var statearr_77974 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77974[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__);

(statearr_77974[(1)] = (1));

return statearr_77974;
});
var fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____1 = (function (state_77876){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_77876);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e77975){var ex__16224__auto__ = e77975;
var statearr_77976_78043 = state_77876;
(statearr_77976_78043[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_77876[(4)]))){
var statearr_77977_78044 = state_77876;
(statearr_77977_78044[(1)] = cljs.core.first.call(null,(state_77876[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78045 = state_77876;
state_77876 = G__78045;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__ = function(state_77876){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____1.call(this,state_77876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__16221__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_77978 = f__16346__auto__.call(null);
(statearr_77978[(6)] = c__16345__auto__);

return statearr_77978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_78172){
var state_val_78173 = (state_78172[(1)]);
if((state_val_78173 === (7))){
var inst_78068 = (state_78172[(7)]);
var inst_78070 = fluree.db.api.query.resolve_block_range.call(null,inst_78068,query_map);
var state_78172__$1 = state_78172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78172__$1,(10),inst_78070);
} else {
if((state_val_78173 === (20))){
var inst_78097 = (state_78172[(2)]);
var inst_78098 = fluree.db.util.async.throw_err.call(null,inst_78097);
var inst_78099 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_78098);
var inst_78100 = (inst_78099 - (1));
var state_78172__$1 = state_78172;
var statearr_78174_78237 = state_78172__$1;
(statearr_78174_78237[(2)] = inst_78100);

(statearr_78174_78237[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (27))){
var state_78172__$1 = state_78172;
var statearr_78175_78238 = state_78172__$1;
(statearr_78175_78238[(2)] = null);

(statearr_78175_78238[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (1))){
var state_78172__$1 = state_78172;
var statearr_78176_78239 = state_78172__$1;
(statearr_78176_78239[(2)] = null);

(statearr_78176_78239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (24))){
var inst_78107 = (state_78172[(2)]);
var inst_78108 = fluree.db.util.async.throw_err.call(null,inst_78107);
var inst_78109 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_78108);
var state_78172__$1 = state_78172;
var statearr_78177_78240 = state_78172__$1;
(statearr_78177_78240[(2)] = inst_78109);

(statearr_78177_78240[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (39))){
var inst_78144 = (state_78172[(2)]);
var inst_78145 = fluree.db.util.async.throw_err.call(null,inst_78144);
var state_78172__$1 = state_78172;
var statearr_78178_78241 = state_78172__$1;
(statearr_78178_78241[(2)] = inst_78145);

(statearr_78178_78241[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (4))){
var inst_78046 = (state_78172[(2)]);
var state_78172__$1 = state_78172;
var statearr_78179_78242 = state_78172__$1;
(statearr_78179_78242[(2)] = inst_78046);

(statearr_78179_78242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (15))){
var inst_78077 = (state_78172[(8)]);
var state_78172__$1 = state_78172;
var statearr_78180_78243 = state_78172__$1;
(statearr_78180_78243[(2)] = inst_78077);

(statearr_78180_78243[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (21))){
var inst_78068 = (state_78172[(7)]);
var inst_78078 = (state_78172[(9)]);
var inst_78105 = fluree.db.time_travel.as_of_block.call(null,inst_78068,inst_78078);
var state_78172__$1 = state_78172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78172__$1,(24),inst_78105);
} else {
if((state_val_78173 === (31))){
var inst_78062 = (state_78172[(10)]);
var state_78172__$1 = state_78172;
var statearr_78181_78244 = state_78172__$1;
(statearr_78181_78244[(2)] = inst_78062);

(statearr_78181_78244[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (32))){
var inst_78068 = (state_78172[(7)]);
var inst_78128 = (state_78172[(11)]);
var inst_78123 = (state_78172[(12)]);
var inst_78132 = (state_78172[(2)]);
var inst_78133 = fluree.db.api.query.format_history_resp.call(null,inst_78068,inst_78123,inst_78128,inst_78132);
var state_78172__$1 = state_78172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78172__$1,(29),inst_78133);
} else {
if((state_val_78173 === (40))){
var inst_78123 = (state_78172[(12)]);
var inst_78149 = (state_78172[(13)]);
var inst_78151 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_78152 = cljs.core.count.call(null,inst_78123);
var inst_78153 = [inst_78149,inst_78152,(200)];
var inst_78154 = cljs.core.PersistentHashMap.fromArrays(inst_78151,inst_78153);
var state_78172__$1 = state_78172;
var statearr_78182_78245 = state_78172__$1;
(statearr_78182_78245[(2)] = inst_78154);

(statearr_78182_78245[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (33))){
var inst_78061 = (state_78172[(14)]);
var state_78172__$1 = state_78172;
var statearr_78183_78246 = state_78172__$1;
(statearr_78183_78246[(2)] = inst_78061);

(statearr_78183_78246[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (13))){
var inst_78167 = (state_78172[(2)]);
var _ = (function (){var statearr_78184 = state_78172;
(statearr_78184[(4)] = cljs.core.rest.call(null,(state_78172[(4)])));

return statearr_78184;
})();
var state_78172__$1 = state_78172;
var statearr_78185_78247 = state_78172__$1;
(statearr_78185_78247[(2)] = inst_78167);

(statearr_78185_78247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (22))){
var inst_78068 = (state_78172[(7)]);
var inst_78111 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_78068);
var state_78172__$1 = state_78172;
var statearr_78186_78248 = state_78172__$1;
(statearr_78186_78248[(2)] = inst_78111);

(statearr_78186_78248[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (36))){
var inst_78068 = (state_78172[(7)]);
var inst_78136 = (state_78172[(15)]);
var inst_78142 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_78068,inst_78136);
var state_78172__$1 = state_78172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78172__$1,(39),inst_78142);
} else {
if((state_val_78173 === (41))){
var inst_78149 = (state_78172[(13)]);
var state_78172__$1 = state_78172;
var statearr_78187_78249 = state_78172__$1;
(statearr_78187_78249[(2)] = inst_78149);

(statearr_78187_78249[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (29))){
var inst_78061 = (state_78172[(14)]);
var inst_78135 = (state_78172[(2)]);
var inst_78136 = fluree.db.util.async.throw_err.call(null,inst_78135);
var state_78172__$1 = (function (){var statearr_78188 = state_78172;
(statearr_78188[(15)] = inst_78136);

return statearr_78188;
})();
if(cljs.core.truth_(inst_78061)){
var statearr_78189_78250 = state_78172__$1;
(statearr_78189_78250[(1)] = (33));

} else {
var statearr_78190_78251 = state_78172__$1;
(statearr_78190_78251[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (6))){
var inst_78058 = (state_78172[(16)]);
var inst_78067 = (state_78172[(2)]);
var inst_78068 = fluree.db.util.async.throw_err.call(null,inst_78067);
var state_78172__$1 = (function (){var statearr_78191 = state_78172;
(statearr_78191[(7)] = inst_78068);

return statearr_78191;
})();
if(cljs.core.truth_(inst_78058)){
var statearr_78192_78252 = state_78172__$1;
(statearr_78192_78252[(1)] = (7));

} else {
var statearr_78193_78253 = state_78172__$1;
(statearr_78193_78253[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (28))){
var inst_78063 = (state_78172[(17)]);
var inst_78128 = (state_78172[(2)]);
var state_78172__$1 = (function (){var statearr_78194 = state_78172;
(statearr_78194[(11)] = inst_78128);

return statearr_78194;
})();
if(cljs.core.truth_(inst_78063)){
var statearr_78195_78254 = state_78172__$1;
(statearr_78195_78254[(1)] = (30));

} else {
var statearr_78196_78255 = state_78172__$1;
(statearr_78196_78255[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (25))){
var inst_78064 = (state_78172[(18)]);
var inst_78122 = (state_78172[(2)]);
var inst_78123 = fluree.db.util.async.throw_err.call(null,inst_78122);
var state_78172__$1 = (function (){var statearr_78197 = state_78172;
(statearr_78197[(12)] = inst_78123);

return statearr_78197;
})();
if(cljs.core.truth_(inst_78064)){
var statearr_78198_78256 = state_78172__$1;
(statearr_78198_78256[(1)] = (26));

} else {
var statearr_78199_78257 = state_78172__$1;
(statearr_78199_78257[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (34))){
var inst_78060 = (state_78172[(19)]);
var state_78172__$1 = state_78172;
var statearr_78200_78258 = state_78172__$1;
(statearr_78200_78258[(2)] = inst_78060);

(statearr_78200_78258[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (17))){
var inst_78068 = (state_78172[(7)]);
var inst_78077 = (state_78172[(8)]);
var inst_78094 = (inst_78077 - (1));
var inst_78095 = fluree.db.time_travel.as_of_block.call(null,inst_78068,inst_78094);
var state_78172__$1 = state_78172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78172__$1,(20),inst_78095);
} else {
if((state_val_78173 === (3))){
var inst_78170 = (state_78172[(2)]);
var state_78172__$1 = state_78172;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78172__$1,inst_78170);
} else {
if((state_val_78173 === (12))){
var inst_78159 = cljs.core.pr_str.call(null,query_map);
var inst_78160 = ["History query not properly formatted. Provided ",inst_78159].join('');
var inst_78161 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78162 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_78163 = cljs.core.PersistentHashMap.fromArrays(inst_78161,inst_78162);
var inst_78164 = cljs.core.ex_info.call(null,inst_78160,inst_78163);
var inst_78165 = (function(){throw inst_78164})();
var state_78172__$1 = state_78172;
var statearr_78201_78259 = state_78172__$1;
(statearr_78201_78259[(2)] = inst_78165);

(statearr_78201_78259[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (2))){
var _ = (function (){var statearr_78202 = state_78172;
(statearr_78202[(4)] = cljs.core.cons.call(null,(5),(state_78172[(4)])));

return statearr_78202;
})();
var inst_78056 = query_map;
var inst_78057 = cljs.core.__destructure_map.call(null,inst_78056);
var inst_78058 = cljs.core.get.call(null,inst_78057,new cljs.core.Keyword(null,"block","block",664686210));
var inst_78059 = cljs.core.get.call(null,inst_78057,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_78060 = cljs.core.get.call(null,inst_78057,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_78061 = cljs.core.get.call(null,inst_78057,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_78062 = cljs.core.get.call(null,inst_78057,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_78063 = cljs.core.get.call(null,inst_78057,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_78064 = cljs.core.get.call(null,inst_78057,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_78065 = cljs.core.get.call(null,inst_78057,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_78172__$1 = (function (){var statearr_78203 = state_78172;
(statearr_78203[(18)] = inst_78064);

(statearr_78203[(20)] = inst_78059);

(statearr_78203[(16)] = inst_78058);

(statearr_78203[(21)] = inst_78065);

(statearr_78203[(10)] = inst_78062);

(statearr_78203[(17)] = inst_78063);

(statearr_78203[(19)] = inst_78060);

(statearr_78203[(14)] = inst_78061);

return statearr_78203;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78172__$1,(6),sources);
} else {
if((state_val_78173 === (23))){
var inst_78068 = (state_78172[(7)]);
var inst_78059 = (state_78172[(20)]);
var inst_78103 = (state_78172[(22)]);
var inst_78113 = (state_78172[(2)]);
var inst_78114 = fluree.db.api.query.get_history_pattern.call(null,inst_78059);
var inst_78115 = cljs.core.nth.call(null,inst_78114,(0),null);
var inst_78116 = cljs.core.nth.call(null,inst_78114,(1),null);
var inst_78117 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_78118 = [inst_78103,inst_78113];
var inst_78119 = cljs.core.PersistentHashMap.fromArrays(inst_78117,inst_78118);
var inst_78120 = fluree.db.query.range.time_range.call(null,inst_78068,inst_78116,cljs.core._EQ_,inst_78115,inst_78119);
var state_78172__$1 = state_78172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78172__$1,(25),inst_78120);
} else {
if((state_val_78173 === (35))){
var inst_78140 = (state_78172[(2)]);
var state_78172__$1 = state_78172;
if(cljs.core.truth_(inst_78140)){
var statearr_78204_78260 = state_78172__$1;
(statearr_78204_78260[(1)] = (36));

} else {
var statearr_78205_78261 = state_78172__$1;
(statearr_78205_78261[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (19))){
var inst_78078 = (state_78172[(9)]);
var inst_78103 = (state_78172[(2)]);
var state_78172__$1 = (function (){var statearr_78206 = state_78172;
(statearr_78206[(22)] = inst_78103);

return statearr_78206;
})();
if(cljs.core.truth_(inst_78078)){
var statearr_78207_78262 = state_78172__$1;
(statearr_78207_78262[(1)] = (21));

} else {
var statearr_78208_78263 = state_78172__$1;
(statearr_78208_78263[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (11))){
var inst_78077 = (state_78172[(8)]);
var inst_78065 = (state_78172[(21)]);
var inst_78087 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_78065);
var state_78172__$1 = (function (){var statearr_78210 = state_78172;
(statearr_78210[(23)] = inst_78087);

return statearr_78210;
})();
if(cljs.core.truth_(inst_78077)){
var statearr_78211_78264 = state_78172__$1;
(statearr_78211_78264[(1)] = (14));

} else {
var statearr_78212_78265 = state_78172__$1;
(statearr_78212_78265[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (9))){
var inst_78076 = (state_78172[(2)]);
var inst_78077 = cljs.core.nth.call(null,inst_78076,(0),null);
var inst_78078 = cljs.core.nth.call(null,inst_78076,(1),null);
var inst_78079 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_78080 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_78081 = cljs.core.keys.call(null,inst_78080);
var inst_78082 = cljs.core._EQ_.call(null,inst_78079,inst_78081);
var state_78172__$1 = (function (){var statearr_78213 = state_78172;
(statearr_78213[(9)] = inst_78078);

(statearr_78213[(8)] = inst_78077);

return statearr_78213;
})();
if(inst_78082){
var statearr_78214_78266 = state_78172__$1;
(statearr_78214_78266[(1)] = (11));

} else {
var statearr_78215_78267 = state_78172__$1;
(statearr_78215_78267[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (5))){
var _ = (function (){var statearr_78216 = state_78172;
(statearr_78216[(4)] = cljs.core.rest.call(null,(state_78172[(4)])));

return statearr_78216;
})();
var state_78172__$1 = state_78172;
var ex78209 = (state_78172__$1[(2)]);
var statearr_78217_78268 = state_78172__$1;
(statearr_78217_78268[(5)] = ex78209);


if((ex78209 instanceof Error)){
var statearr_78218_78269 = state_78172__$1;
(statearr_78218_78269[(1)] = (4));

(statearr_78218_78269[(5)] = null);

} else {
throw ex78209;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (14))){
var inst_78077 = (state_78172[(8)]);
var inst_78089 = cljs.core.not_EQ_.call(null,(1),inst_78077);
var state_78172__$1 = state_78172;
var statearr_78219_78270 = state_78172__$1;
(statearr_78219_78270[(2)] = inst_78089);

(statearr_78219_78270[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (26))){
var inst_78064 = (state_78172[(18)]);
var inst_78125 = cljs.core.set.call(null,inst_78064);
var state_78172__$1 = state_78172;
var statearr_78220_78271 = state_78172__$1;
(statearr_78220_78271[(2)] = inst_78125);

(statearr_78220_78271[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (16))){
var inst_78092 = (state_78172[(2)]);
var state_78172__$1 = state_78172;
if(cljs.core.truth_(inst_78092)){
var statearr_78221_78272 = state_78172__$1;
(statearr_78221_78272[(1)] = (17));

} else {
var statearr_78222_78273 = state_78172__$1;
(statearr_78222_78273[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (38))){
var inst_78087 = (state_78172[(23)]);
var inst_78149 = (state_78172[(2)]);
var state_78172__$1 = (function (){var statearr_78223 = state_78172;
(statearr_78223[(13)] = inst_78149);

return statearr_78223;
})();
if(cljs.core.truth_(inst_78087)){
var statearr_78224_78274 = state_78172__$1;
(statearr_78224_78274[(1)] = (40));

} else {
var statearr_78225_78275 = state_78172__$1;
(statearr_78225_78275[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (30))){
var inst_78063 = (state_78172[(17)]);
var state_78172__$1 = state_78172;
var statearr_78226_78276 = state_78172__$1;
(statearr_78226_78276[(2)] = inst_78063);

(statearr_78226_78276[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (10))){
var inst_78072 = (state_78172[(2)]);
var inst_78073 = fluree.db.util.async.throw_err.call(null,inst_78072);
var state_78172__$1 = state_78172;
var statearr_78227_78277 = state_78172__$1;
(statearr_78227_78277[(2)] = inst_78073);

(statearr_78227_78277[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (18))){
var state_78172__$1 = state_78172;
var statearr_78228_78278 = state_78172__$1;
(statearr_78228_78278[(2)] = (-1));

(statearr_78228_78278[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (42))){
var inst_78157 = (state_78172[(2)]);
var state_78172__$1 = state_78172;
var statearr_78229_78279 = state_78172__$1;
(statearr_78229_78279[(2)] = inst_78157);

(statearr_78229_78279[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (37))){
var inst_78136 = (state_78172[(15)]);
var inst_78147 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_78136);
var state_78172__$1 = state_78172;
var statearr_78230_78280 = state_78172__$1;
(statearr_78230_78280[(2)] = inst_78147);

(statearr_78230_78280[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78173 === (8))){
var state_78172__$1 = state_78172;
var statearr_78231_78281 = state_78172__$1;
(statearr_78231_78281[(2)] = null);

(statearr_78231_78281[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__16221__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__16221__auto____0 = (function (){
var statearr_78232 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78232[(0)] = fluree$db$api$query$history_query_async_$_state_machine__16221__auto__);

(statearr_78232[(1)] = (1));

return statearr_78232;
});
var fluree$db$api$query$history_query_async_$_state_machine__16221__auto____1 = (function (state_78172){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_78172);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e78233){var ex__16224__auto__ = e78233;
var statearr_78234_78282 = state_78172;
(statearr_78234_78282[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_78172[(4)]))){
var statearr_78235_78283 = state_78172;
(statearr_78235_78283[(1)] = cljs.core.first.call(null,(state_78172[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78284 = state_78172;
state_78172 = G__78284;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__16221__auto__ = function(state_78172){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__16221__auto____1.call(this,state_78172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__16221__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__16221__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_78236 = f__16346__auto__.call(null);
(statearr_78236[(6)] = c__16345__auto__);

return statearr_78236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_78417){
var state_val_78418 = (state_78417[(1)]);
if((state_val_78418 === (7))){
var inst_78314 = cljs.core.pr_str.call(null,flureeQL);
var inst_78315 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_78314].join('');
var inst_78316 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78317 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_78318 = cljs.core.PersistentHashMap.fromArrays(inst_78316,inst_78317);
var inst_78319 = cljs.core.ex_info.call(null,inst_78315,inst_78318);
var inst_78320 = (function(){throw inst_78319})();
var state_78417__$1 = state_78417;
var statearr_78419_78498 = state_78417__$1;
(statearr_78419_78498[(2)] = inst_78320);

(statearr_78419_78498[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (20))){
var inst_78352 = (state_78417[(2)]);
var state_78417__$1 = state_78417;
if(cljs.core.truth_(inst_78352)){
var statearr_78420_78499 = state_78417__$1;
(statearr_78420_78499[(1)] = (21));

} else {
var statearr_78421_78500 = state_78417__$1;
(statearr_78421_78500[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (27))){
var inst_78296 = (state_78417[(7)]);
var state_78417__$1 = state_78417;
var statearr_78422_78501 = state_78417__$1;
(statearr_78422_78501[(2)] = inst_78296);

(statearr_78422_78501[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (1))){
var state_78417__$1 = state_78417;
var statearr_78423_78502 = state_78417__$1;
(statearr_78423_78502[(2)] = null);

(statearr_78423_78502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (24))){
var inst_78358 = (state_78417[(8)]);
var state_78417__$1 = state_78417;
var statearr_78424_78503 = state_78417__$1;
(statearr_78424_78503[(2)] = inst_78358);

(statearr_78424_78503[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (39))){
var inst_78302 = (state_78417[(9)]);
var state_78417__$1 = state_78417;
if(cljs.core.truth_(inst_78302)){
var statearr_78425_78504 = state_78417__$1;
(statearr_78425_78504[(1)] = (42));

} else {
var statearr_78426_78505 = state_78417__$1;
(statearr_78426_78505[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (46))){
var inst_78390 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78391 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_78392 = cljs.core.PersistentHashMap.fromArrays(inst_78390,inst_78391);
var inst_78393 = cljs.core.ex_info.call(null,"Invalid query.",inst_78392);
var inst_78394 = (function(){throw inst_78393})();
var state_78417__$1 = state_78417;
var statearr_78427_78506 = state_78417__$1;
(statearr_78427_78506[(2)] = inst_78394);

(statearr_78427_78506[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (4))){
var inst_78286 = (state_78417[(2)]);
var state_78417__$1 = state_78417;
var statearr_78428_78507 = state_78417__$1;
(statearr_78428_78507[(2)] = inst_78286);

(statearr_78428_78507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (15))){
var inst_78299 = (state_78417[(10)]);
var inst_78337 = (state_78417[(11)]);
var inst_78339 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_78337);
var inst_78340 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_78337);
var inst_78341 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_78337);
var inst_78342 = fluree.db.api.query.get_sources.call(null,inst_78339,inst_78340,inst_78341,inst_78299);
var state_78417__$1 = state_78417;
var statearr_78429_78508 = state_78417__$1;
(statearr_78429_78508[(2)] = inst_78342);

(statearr_78429_78508[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (48))){
var inst_78347 = (state_78417[(12)]);
var inst_78401 = (state_78417[(2)]);
var inst_78402 = fluree.db.util.async.throw_err.call(null,inst_78401);
var state_78417__$1 = (function (){var statearr_78430 = state_78417;
(statearr_78430[(13)] = inst_78402);

return statearr_78430;
})();
if(cljs.core.truth_(inst_78347)){
var statearr_78431_78509 = state_78417__$1;
(statearr_78431_78509[(1)] = (49));

} else {
var statearr_78432_78510 = state_78417__$1;
(statearr_78432_78510[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (50))){
var inst_78402 = (state_78417[(13)]);
var state_78417__$1 = state_78417;
var statearr_78433_78511 = state_78417__$1;
(statearr_78433_78511[(2)] = inst_78402);

(statearr_78433_78511[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (21))){
var inst_78354 = cljs.core.volatile_BANG_.call(null,(0));
var state_78417__$1 = state_78417;
var statearr_78434_78512 = state_78417__$1;
(statearr_78434_78512[(2)] = inst_78354);

(statearr_78434_78512[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (31))){
var inst_78300 = (state_78417[(14)]);
var state_78417__$1 = state_78417;
if(cljs.core.truth_(inst_78300)){
var statearr_78435_78513 = state_78417__$1;
(statearr_78435_78513[(1)] = (33));

} else {
var statearr_78436_78514 = state_78417__$1;
(statearr_78436_78514[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (32))){
var inst_78377 = (state_78417[(2)]);
var state_78417__$1 = state_78417;
var statearr_78437_78515 = state_78417__$1;
(statearr_78437_78515[(2)] = inst_78377);

(statearr_78437_78515[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (40))){
var inst_78379 = (state_78417[(15)]);
var state_78417__$1 = state_78417;
var statearr_78438_78516 = state_78417__$1;
(statearr_78438_78516[(2)] = inst_78379);

(statearr_78438_78516[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (33))){
var inst_78300 = (state_78417[(14)]);
var state_78417__$1 = state_78417;
var statearr_78439_78517 = state_78417__$1;
(statearr_78439_78517[(2)] = inst_78300);

(statearr_78439_78517[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (13))){
var inst_78297 = (state_78417[(16)]);
var inst_78326 = (state_78417[(2)]);
var inst_78327 = fluree.db.util.async.throw_err.call(null,inst_78326);
var inst_78328 = fluree.db.time_travel.as_of_block.call(null,inst_78327,inst_78297);
var state_78417__$1 = state_78417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78417__$1,(12),inst_78328);
} else {
if((state_val_78418 === (22))){
var state_78417__$1 = state_78417;
var statearr_78440_78518 = state_78417__$1;
(statearr_78440_78518[(2)] = null);

(statearr_78440_78518[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (36))){
var inst_78304 = (state_78417[(17)]);
var state_78417__$1 = state_78417;
var statearr_78441_78519 = state_78417__$1;
(statearr_78441_78519[(2)] = inst_78304);

(statearr_78441_78519[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (41))){
var inst_78387 = (state_78417[(2)]);
var state_78417__$1 = state_78417;
if(cljs.core.truth_(inst_78387)){
var statearr_78442_78520 = state_78417__$1;
(statearr_78442_78520[(1)] = (45));

} else {
var statearr_78443_78521 = state_78417__$1;
(statearr_78443_78521[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (43))){
var inst_78298 = (state_78417[(18)]);
var state_78417__$1 = state_78417;
var statearr_78444_78522 = state_78417__$1;
(statearr_78444_78522[(2)] = inst_78298);

(statearr_78444_78522[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (29))){
var inst_78379 = (state_78417[(15)]);
var inst_78379__$1 = (state_78417[(2)]);
var state_78417__$1 = (function (){var statearr_78445 = state_78417;
(statearr_78445[(15)] = inst_78379__$1);

return statearr_78445;
})();
if(cljs.core.truth_(inst_78379__$1)){
var statearr_78446_78523 = state_78417__$1;
(statearr_78446_78523[(1)] = (39));

} else {
var statearr_78447_78524 = state_78417__$1;
(statearr_78447_78524[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (44))){
var inst_78384 = (state_78417[(2)]);
var state_78417__$1 = state_78417;
var statearr_78448_78525 = state_78417__$1;
(statearr_78448_78525[(2)] = inst_78384);

(statearr_78448_78525[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (6))){
var state_78417__$1 = state_78417;
var statearr_78449_78526 = state_78417__$1;
(statearr_78449_78526[(2)] = null);

(statearr_78449_78526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (28))){
var inst_78301 = (state_78417[(19)]);
var state_78417__$1 = state_78417;
if(cljs.core.truth_(inst_78301)){
var statearr_78450_78527 = state_78417__$1;
(statearr_78450_78527[(1)] = (30));

} else {
var statearr_78451_78528 = state_78417__$1;
(statearr_78451_78528[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (51))){
var inst_78412 = (state_78417[(2)]);
var _ = (function (){var statearr_78452 = state_78417;
(statearr_78452[(4)] = cljs.core.rest.call(null,(state_78417[(4)])));

return statearr_78452;
})();
var state_78417__$1 = state_78417;
var statearr_78453_78529 = state_78417__$1;
(statearr_78453_78529[(2)] = inst_78412);

(statearr_78453_78529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (25))){
var state_78417__$1 = state_78417;
var statearr_78454_78530 = state_78417__$1;
(statearr_78454_78530[(2)] = (1000000));

(statearr_78454_78530[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (34))){
var inst_78304 = (state_78417[(17)]);
var state_78417__$1 = state_78417;
if(cljs.core.truth_(inst_78304)){
var statearr_78455_78531 = state_78417__$1;
(statearr_78455_78531[(1)] = (36));

} else {
var statearr_78456_78532 = state_78417__$1;
(statearr_78456_78532[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (17))){
var inst_78303 = (state_78417[(20)]);
var inst_78348 = (state_78417[(21)]);
var inst_78346 = (state_78417[(2)]);
var inst_78347 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_78303);
var inst_78348__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_78303);
var state_78417__$1 = (function (){var statearr_78457 = state_78417;
(statearr_78457[(22)] = inst_78346);

(statearr_78457[(12)] = inst_78347);

(statearr_78457[(21)] = inst_78348__$1);

return statearr_78457;
})();
if(cljs.core.truth_(inst_78348__$1)){
var statearr_78458_78533 = state_78417__$1;
(statearr_78458_78533[(1)] = (18));

} else {
var statearr_78459_78534 = state_78417__$1;
(statearr_78459_78534[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (3))){
var inst_78415 = (state_78417[(2)]);
var state_78417__$1 = state_78417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78417__$1,inst_78415);
} else {
if((state_val_78418 === (12))){
var inst_78330 = (state_78417[(2)]);
var inst_78331 = fluree.db.util.async.throw_err.call(null,inst_78330);
var state_78417__$1 = state_78417;
var statearr_78460_78535 = state_78417__$1;
(statearr_78460_78535[(2)] = inst_78331);

(statearr_78460_78535[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (2))){
var inst_78296 = (state_78417[(7)]);
var inst_78298 = (state_78417[(18)]);
var inst_78304 = (state_78417[(17)]);
var inst_78303 = (state_78417[(20)]);
var inst_78300 = (state_78417[(14)]);
var inst_78299 = (state_78417[(10)]);
var inst_78301 = (state_78417[(19)]);
var inst_78297 = (state_78417[(16)]);
var inst_78302 = (state_78417[(9)]);
var inst_78295 = (state_78417[(23)]);
var _ = (function (){var statearr_78461 = state_78417;
(statearr_78461[(4)] = cljs.core.cons.call(null,(5),(state_78417[(4)])));

return statearr_78461;
})();
var inst_78293 = flureeQL;
var inst_78294 = cljs.core.__destructure_map.call(null,inst_78293);
var inst_78295__$1 = cljs.core.get.call(null,inst_78294,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_78296__$1 = cljs.core.get.call(null,inst_78294,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_78297__$1 = cljs.core.get.call(null,inst_78294,new cljs.core.Keyword(null,"block","block",664686210));
var inst_78298__$1 = cljs.core.get.call(null,inst_78294,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_78299__$1 = cljs.core.get.call(null,inst_78294,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_78300__$1 = cljs.core.get.call(null,inst_78294,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_78301__$1 = cljs.core.get.call(null,inst_78294,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_78302__$1 = cljs.core.get.call(null,inst_78294,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_78303__$1 = cljs.core.get.call(null,inst_78294,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_78304__$1 = cljs.core.get.call(null,inst_78294,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_78305 = (function (){var construct = inst_78295__$1;
var select = inst_78296__$1;
var block = inst_78297__$1;
var map__78292 = inst_78294;
var where = inst_78298__$1;
var prefixes = inst_78299__$1;
var selectDistinct = inst_78300__$1;
var selectOne = inst_78301__$1;
var from = inst_78302__$1;
var opts = inst_78303__$1;
var selectReduced = inst_78304__$1;
return (function (p1__78285_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__78285_SHARP_);
});
})();
var inst_78306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78307 = [inst_78296__$1,inst_78301__$1,inst_78300__$1,inst_78304__$1];
var inst_78308 = (new cljs.core.PersistentVector(null,4,(5),inst_78306,inst_78307,null));
var inst_78309 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_78308);
var inst_78310 = cljs.core.count.call(null,inst_78309);
var inst_78311 = inst_78305.call(null,inst_78310);
var state_78417__$1 = (function (){var statearr_78462 = state_78417;
(statearr_78462[(7)] = inst_78296__$1);

(statearr_78462[(18)] = inst_78298__$1);

(statearr_78462[(17)] = inst_78304__$1);

(statearr_78462[(20)] = inst_78303__$1);

(statearr_78462[(14)] = inst_78300__$1);

(statearr_78462[(10)] = inst_78299__$1);

(statearr_78462[(19)] = inst_78301__$1);

(statearr_78462[(16)] = inst_78297__$1);

(statearr_78462[(9)] = inst_78302__$1);

(statearr_78462[(23)] = inst_78295__$1);

return statearr_78462;
})();
if(cljs.core.truth_(inst_78311)){
var statearr_78463_78536 = state_78417__$1;
(statearr_78463_78536[(1)] = (6));

} else {
var statearr_78464_78537 = state_78417__$1;
(statearr_78464_78537[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (23))){
var inst_78358 = (state_78417[(8)]);
var inst_78303 = (state_78417[(20)]);
var inst_78357 = (state_78417[(2)]);
var inst_78358__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_78303);
var state_78417__$1 = (function (){var statearr_78465 = state_78417;
(statearr_78465[(8)] = inst_78358__$1);

(statearr_78465[(24)] = inst_78357);

return statearr_78465;
})();
if(cljs.core.truth_(inst_78358__$1)){
var statearr_78466_78538 = state_78417__$1;
(statearr_78466_78538[(1)] = (24));

} else {
var statearr_78467_78539 = state_78417__$1;
(statearr_78467_78539[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (47))){
var inst_78363 = (state_78417[(25)]);
var inst_78337 = (state_78417[(11)]);
var inst_78396 = (state_78417[(2)]);
var inst_78397 = fluree.db.util.core.current_time_millis.call(null);
var inst_78398 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_78363);
var inst_78399 = fluree.db.query.fql.query.call(null,inst_78337,inst_78398);
var state_78417__$1 = (function (){var statearr_78468 = state_78417;
(statearr_78468[(26)] = inst_78397);

(statearr_78468[(27)] = inst_78396);

return statearr_78468;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78417__$1,(48),inst_78399);
} else {
if((state_val_78418 === (35))){
var inst_78375 = (state_78417[(2)]);
var state_78417__$1 = state_78417;
var statearr_78469_78540 = state_78417__$1;
(statearr_78469_78540[(2)] = inst_78375);

(statearr_78469_78540[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (19))){
var inst_78347 = (state_78417[(12)]);
var state_78417__$1 = state_78417;
var statearr_78470_78541 = state_78417__$1;
(statearr_78470_78541[(2)] = inst_78347);

(statearr_78470_78541[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (11))){
var inst_78299 = (state_78417[(10)]);
var inst_78337 = (state_78417[(2)]);
var state_78417__$1 = (function (){var statearr_78472 = state_78417;
(statearr_78472[(11)] = inst_78337);

return statearr_78472;
})();
if(cljs.core.truth_(inst_78299)){
var statearr_78473_78542 = state_78417__$1;
(statearr_78473_78542[(1)] = (15));

} else {
var statearr_78474_78543 = state_78417__$1;
(statearr_78474_78543[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (9))){
var inst_78323 = (state_78417[(28)]);
var state_78417__$1 = state_78417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78417__$1,(13),inst_78323);
} else {
if((state_val_78418 === (5))){
var _ = (function (){var statearr_78475 = state_78417;
(statearr_78475[(4)] = cljs.core.rest.call(null,(state_78417[(4)])));

return statearr_78475;
})();
var state_78417__$1 = state_78417;
var ex78471 = (state_78417__$1[(2)]);
var statearr_78476_78544 = state_78417__$1;
(statearr_78476_78544[(5)] = ex78471);


if((ex78471 instanceof Error)){
var statearr_78477_78545 = state_78417__$1;
(statearr_78477_78545[(1)] = (4));

(statearr_78477_78545[(5)] = null);

} else {
throw ex78471;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (14))){
var inst_78334 = (state_78417[(2)]);
var inst_78335 = fluree.db.util.async.throw_err.call(null,inst_78334);
var state_78417__$1 = state_78417;
var statearr_78478_78546 = state_78417__$1;
(statearr_78478_78546[(2)] = inst_78335);

(statearr_78478_78546[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (45))){
var state_78417__$1 = state_78417;
var statearr_78479_78547 = state_78417__$1;
(statearr_78479_78547[(2)] = null);

(statearr_78479_78547[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (26))){
var inst_78296 = (state_78417[(7)]);
var inst_78346 = (state_78417[(22)]);
var inst_78303 = (state_78417[(20)]);
var inst_78357 = (state_78417[(24)]);
var inst_78362 = (state_78417[(2)]);
var inst_78363 = cljs.core.assoc.call(null,inst_78303,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_78346,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_78362,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_78357);
var state_78417__$1 = (function (){var statearr_78480 = state_78417;
(statearr_78480[(25)] = inst_78363);

return statearr_78480;
})();
if(cljs.core.truth_(inst_78296)){
var statearr_78481_78548 = state_78417__$1;
(statearr_78481_78548[(1)] = (27));

} else {
var statearr_78482_78549 = state_78417__$1;
(statearr_78482_78549[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (16))){
var inst_78344 = cljs.core.PersistentHashMap.EMPTY;
var state_78417__$1 = state_78417;
var statearr_78483_78550 = state_78417__$1;
(statearr_78483_78550[(2)] = inst_78344);

(statearr_78483_78550[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (38))){
var inst_78373 = (state_78417[(2)]);
var state_78417__$1 = state_78417;
var statearr_78484_78551 = state_78417__$1;
(statearr_78484_78551[(2)] = inst_78373);

(statearr_78484_78551[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (30))){
var inst_78301 = (state_78417[(19)]);
var state_78417__$1 = state_78417;
var statearr_78485_78552 = state_78417__$1;
(statearr_78485_78552[(2)] = inst_78301);

(statearr_78485_78552[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (10))){
var inst_78323 = (state_78417[(28)]);
var state_78417__$1 = state_78417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78417__$1,(14),inst_78323);
} else {
if((state_val_78418 === (18))){
var inst_78348 = (state_78417[(21)]);
var state_78417__$1 = state_78417;
var statearr_78486_78553 = state_78417__$1;
(statearr_78486_78553[(2)] = inst_78348);

(statearr_78486_78553[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (42))){
var inst_78302 = (state_78417[(9)]);
var state_78417__$1 = state_78417;
var statearr_78487_78554 = state_78417__$1;
(statearr_78487_78554[(2)] = inst_78302);

(statearr_78487_78554[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (37))){
var inst_78295 = (state_78417[(23)]);
var state_78417__$1 = state_78417;
var statearr_78488_78555 = state_78417__$1;
(statearr_78488_78555[(2)] = inst_78295);

(statearr_78488_78555[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (8))){
var inst_78297 = (state_78417[(16)]);
var inst_78322 = (state_78417[(2)]);
var inst_78323 = sources;
var state_78417__$1 = (function (){var statearr_78489 = state_78417;
(statearr_78489[(28)] = inst_78323);

(statearr_78489[(29)] = inst_78322);

return statearr_78489;
})();
if(cljs.core.truth_(inst_78297)){
var statearr_78490_78556 = state_78417__$1;
(statearr_78490_78556[(1)] = (9));

} else {
var statearr_78491_78557 = state_78417__$1;
(statearr_78491_78557[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78418 === (49))){
var inst_78397 = (state_78417[(26)]);
var inst_78337 = (state_78417[(11)]);
var inst_78357 = (state_78417[(24)]);
var inst_78402 = (state_78417[(13)]);
var inst_78404 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_78405 = cljs.core.deref.call(null,inst_78357);
var inst_78406 = fluree.db.util.core.response_time_formatted.call(null,inst_78397);
var inst_78407 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_78337);
var inst_78408 = [(200),inst_78402,inst_78405,inst_78406,inst_78407];
var inst_78409 = cljs.core.PersistentHashMap.fromArrays(inst_78404,inst_78408);
var state_78417__$1 = state_78417;
var statearr_78492_78558 = state_78417__$1;
(statearr_78492_78558[(2)] = inst_78409);

(statearr_78492_78558[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__16221__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__16221__auto____0 = (function (){
var statearr_78493 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78493[(0)] = fluree$db$api$query$query_async_$_state_machine__16221__auto__);

(statearr_78493[(1)] = (1));

return statearr_78493;
});
var fluree$db$api$query$query_async_$_state_machine__16221__auto____1 = (function (state_78417){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_78417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e78494){var ex__16224__auto__ = e78494;
var statearr_78495_78559 = state_78417;
(statearr_78495_78559[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_78417[(4)]))){
var statearr_78496_78560 = state_78417;
(statearr_78496_78560[(1)] = cljs.core.first.call(null,(state_78417[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78561 = state_78417;
state_78417 = G__78561;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__16221__auto__ = function(state_78417){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__16221__auto____1.call(this,state_78417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__16221__auto____0;
fluree$db$api$query$query_async_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__16221__auto____1;
return fluree$db$api$query$query_async_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_78497 = f__16346__auto__.call(null);
(statearr_78497[(6)] = c__16345__auto__);

return statearr_78497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_78702){
var state_val_78703 = (state_78702[(1)]);
if((state_val_78703 === (7))){
var inst_78697 = (state_78702[(2)]);
var _ = (function (){var statearr_78704 = state_78702;
(statearr_78704[(4)] = cljs.core.rest.call(null,(state_78702[(4)])));

return statearr_78704;
})();
var state_78702__$1 = state_78702;
var statearr_78705_78781 = state_78702__$1;
(statearr_78705_78781[(2)] = inst_78697);

(statearr_78705_78781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (20))){
var inst_78669 = (state_78702[(2)]);
var state_78702__$1 = state_78702;
var statearr_78706_78782 = state_78702__$1;
(statearr_78706_78782[(2)] = inst_78669);

(statearr_78706_78782[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (27))){
var inst_78649 = (state_78702[(7)]);
var state_78702__$1 = state_78702;
var statearr_78707_78783 = state_78702__$1;
(statearr_78707_78783[(2)] = inst_78649);

(statearr_78707_78783[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (1))){
var state_78702__$1 = state_78702;
var statearr_78708_78784 = state_78702__$1;
(statearr_78708_78784[(2)] = null);

(statearr_78708_78784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (24))){
var inst_78646 = (state_78702[(8)]);
var state_78702__$1 = state_78702;
var statearr_78709_78785 = state_78702__$1;
(statearr_78709_78785[(2)] = inst_78646);

(statearr_78709_78785[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (39))){
var inst_78603 = (state_78702[(9)]);
var inst_78614 = (state_78702[(10)]);
var inst_78636 = (state_78702[(11)]);
var inst_78680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78681 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_78614];
var inst_78682 = (new cljs.core.PersistentVector(null,2,(5),inst_78680,inst_78681,null));
var inst_78683 = cljs.core.assoc_in.call(null,inst_78603,inst_78682,inst_78636);
var state_78702__$1 = state_78702;
var statearr_78710_78786 = state_78702__$1;
(statearr_78710_78786[(2)] = inst_78683);

(statearr_78710_78786[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (4))){
var inst_78562 = (state_78702[(2)]);
var state_78702__$1 = state_78702;
var statearr_78711_78787 = state_78702__$1;
(statearr_78711_78787[(2)] = inst_78562);

(statearr_78711_78787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (15))){
var inst_78601 = (state_78702[(12)]);
var inst_78636 = (state_78702[(11)]);
var inst_78639 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_78636);
var inst_78640 = (inst_78601 == null);
var state_78702__$1 = (function (){var statearr_78712 = state_78702;
(statearr_78712[(13)] = inst_78639);

return statearr_78712;
})();
if(cljs.core.truth_(inst_78640)){
var statearr_78713_78788 = state_78702__$1;
(statearr_78713_78788[(1)] = (18));

} else {
var statearr_78714_78789 = state_78702__$1;
(statearr_78714_78789[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (21))){
var inst_78639 = (state_78702[(13)]);
var state_78702__$1 = state_78702;
var statearr_78715_78790 = state_78702__$1;
(statearr_78715_78790[(2)] = inst_78639);

(statearr_78715_78790[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (31))){
var state_78702__$1 = state_78702;
var statearr_78716_78791 = state_78702__$1;
(statearr_78716_78791[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (32))){
var inst_78665 = (state_78702[(2)]);
var state_78702__$1 = state_78702;
var statearr_78718_78792 = state_78702__$1;
(statearr_78718_78792[(2)] = inst_78665);

(statearr_78718_78792[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (40))){
var inst_78634 = (state_78702[(14)]);
var state_78702__$1 = state_78702;
if(cljs.core.truth_(inst_78634)){
var statearr_78719_78793 = state_78702__$1;
(statearr_78719_78793[(1)] = (42));

} else {
var statearr_78720_78794 = state_78702__$1;
(statearr_78720_78794[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (33))){
var inst_78601 = (state_78702[(12)]);
var inst_78639 = (state_78702[(13)]);
var inst_78660 = ((inst_78639 > inst_78601) ? inst_78639 : inst_78601);
var state_78702__$1 = state_78702;
var statearr_78721_78795 = state_78702__$1;
(statearr_78721_78795[(2)] = inst_78660);

(statearr_78721_78795[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (13))){
var inst_78625 = (state_78702[(2)]);
var state_78702__$1 = state_78702;
var statearr_78722_78796 = state_78702__$1;
(statearr_78722_78796[(2)] = inst_78625);

(statearr_78722_78796[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (22))){
var inst_78646 = (state_78702[(8)]);
var inst_78639 = (state_78702[(13)]);
var inst_78646__$1 = cljs.core._EQ_.call(null,(200),inst_78639);
var state_78702__$1 = (function (){var statearr_78723 = state_78702;
(statearr_78723[(8)] = inst_78646__$1);

return statearr_78723;
})();
if(inst_78646__$1){
var statearr_78724_78797 = state_78702__$1;
(statearr_78724_78797[(1)] = (24));

} else {
var statearr_78725_78798 = state_78702__$1;
(statearr_78725_78798[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (36))){
var inst_78602 = (state_78702[(15)]);
var inst_78636 = (state_78702[(11)]);
var inst_78674 = cljs.core.get.call(null,inst_78636,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_78675 = (inst_78602 + inst_78674);
var state_78702__$1 = state_78702;
var statearr_78726_78799 = state_78702__$1;
(statearr_78726_78799[(2)] = inst_78675);

(statearr_78726_78799[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (41))){
var inst_78672 = (state_78702[(16)]);
var inst_78613 = (state_78702[(17)]);
var inst_78678 = (state_78702[(18)]);
var inst_78692 = (state_78702[(2)]);
var inst_78600 = inst_78613;
var inst_78601 = inst_78672;
var inst_78602 = inst_78678;
var inst_78603 = inst_78692;
var state_78702__$1 = (function (){var statearr_78727 = state_78702;
(statearr_78727[(12)] = inst_78601);

(statearr_78727[(19)] = inst_78600);

(statearr_78727[(9)] = inst_78603);

(statearr_78727[(15)] = inst_78602);

return statearr_78727;
})();
var statearr_78728_78800 = state_78702__$1;
(statearr_78728_78800[(2)] = null);

(statearr_78728_78800[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (43))){
var inst_78636 = (state_78702[(11)]);
var state_78702__$1 = state_78702;
var statearr_78729_78801 = state_78702__$1;
(statearr_78729_78801[(2)] = inst_78636);

(statearr_78729_78801[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (29))){
var inst_78654 = (state_78702[(2)]);
var state_78702__$1 = state_78702;
var statearr_78730_78802 = state_78702__$1;
(statearr_78730_78802[(2)] = inst_78654);

(statearr_78730_78802[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (44))){
var inst_78603 = (state_78702[(9)]);
var inst_78614 = (state_78702[(10)]);
var inst_78689 = (state_78702[(2)]);
var inst_78690 = cljs.core.assoc.call(null,inst_78603,inst_78614,inst_78689);
var state_78702__$1 = state_78702;
var statearr_78731_78803 = state_78702__$1;
(statearr_78731_78803[(2)] = inst_78690);

(statearr_78731_78803[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (6))){
var inst_78600 = (state_78702[(19)]);
var inst_78615 = (state_78702[(20)]);
var inst_78611 = cljs.core.seq.call(null,inst_78600);
var inst_78612 = cljs.core.first.call(null,inst_78611);
var inst_78613 = cljs.core.next.call(null,inst_78611);
var inst_78614 = cljs.core.nth.call(null,inst_78612,(0),null);
var inst_78615__$1 = cljs.core.nth.call(null,inst_78612,(1),null);
var inst_78616 = (inst_78615__$1 == null);
var state_78702__$1 = (function (){var statearr_78732 = state_78702;
(statearr_78732[(20)] = inst_78615__$1);

(statearr_78732[(17)] = inst_78613);

(statearr_78732[(10)] = inst_78614);

return statearr_78732;
})();
if(cljs.core.truth_(inst_78616)){
var statearr_78733_78804 = state_78702__$1;
(statearr_78733_78804[(1)] = (8));

} else {
var statearr_78734_78805 = state_78702__$1;
(statearr_78734_78805[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (28))){
var inst_78601 = (state_78702[(12)]);
var inst_78652 = cljs.core._EQ_.call(null,(207),inst_78601);
var state_78702__$1 = state_78702;
var statearr_78735_78806 = state_78702__$1;
(statearr_78735_78806[(2)] = inst_78652);

(statearr_78735_78806[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (25))){
var inst_78601 = (state_78702[(12)]);
var inst_78649 = (state_78702[(7)]);
var inst_78649__$1 = cljs.core._EQ_.call(null,(200),inst_78601);
var state_78702__$1 = (function (){var statearr_78736 = state_78702;
(statearr_78736[(7)] = inst_78649__$1);

return statearr_78736;
})();
if(inst_78649__$1){
var statearr_78737_78807 = state_78702__$1;
(statearr_78737_78807[(1)] = (27));

} else {
var statearr_78738_78808 = state_78702__$1;
(statearr_78738_78808[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (34))){
var state_78702__$1 = state_78702;
var statearr_78739_78809 = state_78702__$1;
(statearr_78739_78809[(2)] = null);

(statearr_78739_78809[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (17))){
var inst_78633 = (state_78702[(21)]);
var inst_78672 = (state_78702[(2)]);
var state_78702__$1 = (function (){var statearr_78740 = state_78702;
(statearr_78740[(16)] = inst_78672);

return statearr_78740;
})();
if(cljs.core.truth_(inst_78633)){
var statearr_78741_78810 = state_78702__$1;
(statearr_78741_78810[(1)] = (36));

} else {
var statearr_78742_78811 = state_78702__$1;
(statearr_78742_78811[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (3))){
var inst_78700 = (state_78702[(2)]);
var state_78702__$1 = state_78702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78702__$1,inst_78700);
} else {
if((state_val_78703 === (12))){
var inst_78603 = (state_78702[(9)]);
var state_78702__$1 = state_78702;
var statearr_78743_78812 = state_78702__$1;
(statearr_78743_78812[(2)] = inst_78603);

(statearr_78743_78812[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (2))){
var inst_78576 = (state_78702[(22)]);
var inst_78572 = (state_78702[(23)]);
var inst_78577 = (state_78702[(24)]);
var _ = (function (){var statearr_78744 = state_78702;
(statearr_78744[(4)] = cljs.core.cons.call(null,(5),(state_78702[(4)])));

return statearr_78744;
})();
var inst_78568 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_78569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78570 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_78571 = (new cljs.core.PersistentVector(null,2,(5),inst_78569,inst_78570,null));
var inst_78572__$1 = cljs.core.get_in.call(null,flureeQL,inst_78571);
var inst_78573 = (function (){var global_block = inst_78568;
var global_meta_QMARK_ = inst_78572__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4212__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4210__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__4210__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_78574 = cljs.core.PersistentHashMap.EMPTY;
var inst_78575 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_78576__$1 = cljs.core.reduce_kv.call(null,inst_78573,inst_78574,inst_78575);
var inst_78577__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_78579 = (function (){var global_block = inst_78568;
var global_meta_QMARK_ = inst_78572__$1;
var queries = inst_78576__$1;
var start_time = inst_78577__$1;
return (function (p__78578){
var vec__78745 = p__78578;
var alias = cljs.core.nth.call(null,vec__78745,(0),null);
var q = cljs.core.nth.call(null,vec__78745,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_78580 = cljs.core.map.call(null,inst_78579,inst_78576__$1);
var inst_78594 = cljs.core.seq.call(null,inst_78580);
var inst_78595 = cljs.core.first.call(null,inst_78594);
var inst_78596 = cljs.core.next.call(null,inst_78594);
var inst_78597 = cljs.core.nth.call(null,inst_78595,(0),null);
var inst_78598 = cljs.core.nth.call(null,inst_78595,(1),null);
var inst_78599 = cljs.core.PersistentHashMap.EMPTY;
var inst_78600 = inst_78580;
var inst_78601 = null;
var inst_78602 = (0);
var inst_78603 = inst_78599;
var state_78702__$1 = (function (){var statearr_78748 = state_78702;
(statearr_78748[(25)] = inst_78597);

(statearr_78748[(22)] = inst_78576__$1);

(statearr_78748[(23)] = inst_78572__$1);

(statearr_78748[(12)] = inst_78601);

(statearr_78748[(19)] = inst_78600);

(statearr_78748[(9)] = inst_78603);

(statearr_78748[(15)] = inst_78602);

(statearr_78748[(24)] = inst_78577__$1);

(statearr_78748[(26)] = inst_78598);

(statearr_78748[(27)] = inst_78596);

return statearr_78748;
})();
var statearr_78749_78813 = state_78702__$1;
(statearr_78749_78813[(2)] = null);

(statearr_78749_78813[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (23))){
var inst_78667 = (state_78702[(2)]);
var state_78702__$1 = state_78702;
var statearr_78750_78814 = state_78702__$1;
(statearr_78750_78814[(2)] = inst_78667);

(statearr_78750_78814[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (35))){
var inst_78663 = (state_78702[(2)]);
var state_78702__$1 = state_78702;
var statearr_78751_78815 = state_78702__$1;
(statearr_78751_78815[(2)] = inst_78663);

(statearr_78751_78815[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (19))){
var inst_78601 = (state_78702[(12)]);
var inst_78639 = (state_78702[(13)]);
var inst_78643 = cljs.core._EQ_.call(null,inst_78601,inst_78639);
var state_78702__$1 = state_78702;
if(inst_78643){
var statearr_78752_78816 = state_78702__$1;
(statearr_78752_78816[(1)] = (21));

} else {
var statearr_78753_78817 = state_78702__$1;
(statearr_78753_78817[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (11))){
var inst_78601 = (state_78702[(12)]);
var inst_78603 = (state_78702[(9)]);
var inst_78602 = (state_78702[(15)]);
var inst_78577 = (state_78702[(24)]);
var inst_78619 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_78620 = fluree.db.util.core.response_time_formatted.call(null,inst_78577);
var inst_78621 = [inst_78603,inst_78602,inst_78601,inst_78620];
var inst_78622 = cljs.core.PersistentHashMap.fromArrays(inst_78619,inst_78621);
var state_78702__$1 = state_78702;
var statearr_78755_78818 = state_78702__$1;
(statearr_78755_78818[(2)] = inst_78622);

(statearr_78755_78818[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (9))){
var inst_78576 = (state_78702[(22)]);
var inst_78615 = (state_78702[(20)]);
var inst_78614 = (state_78702[(10)]);
var inst_78628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78629 = [inst_78614,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_78630 = (new cljs.core.PersistentVector(null,2,(5),inst_78628,inst_78629,null));
var inst_78631 = cljs.core.get_in.call(null,inst_78576,inst_78630);
var inst_78632 = cljs.core.__destructure_map.call(null,inst_78631);
var inst_78633 = cljs.core.get.call(null,inst_78632,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_78634 = cljs.core.get.call(null,inst_78632,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_78702__$1 = (function (){var statearr_78756 = state_78702;
(statearr_78756[(21)] = inst_78633);

(statearr_78756[(14)] = inst_78634);

return statearr_78756;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78702__$1,(14),inst_78615);
} else {
if((state_val_78703 === (5))){
var _ = (function (){var statearr_78757 = state_78702;
(statearr_78757[(4)] = cljs.core.rest.call(null,(state_78702[(4)])));

return statearr_78757;
})();
var state_78702__$1 = state_78702;
var ex78754 = (state_78702__$1[(2)]);
var statearr_78758_78819 = state_78702__$1;
(statearr_78758_78819[(5)] = ex78754);


var statearr_78759_78820 = state_78702__$1;
(statearr_78759_78820[(1)] = (4));

(statearr_78759_78820[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (14))){
var inst_78633 = (state_78702[(21)]);
var inst_78636 = (state_78702[(11)]);
var inst_78636__$1 = (state_78702[(2)]);
var inst_78637 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_78636__$1);
var state_78702__$1 = (function (){var statearr_78760 = state_78702;
(statearr_78760[(28)] = inst_78637);

(statearr_78760[(11)] = inst_78636__$1);

return statearr_78760;
})();
if(cljs.core.truth_(inst_78633)){
var statearr_78761_78821 = state_78702__$1;
(statearr_78761_78821[(1)] = (15));

} else {
var statearr_78762_78822 = state_78702__$1;
(statearr_78762_78822[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (26))){
var inst_78656 = (state_78702[(2)]);
var state_78702__$1 = state_78702;
if(cljs.core.truth_(inst_78656)){
var statearr_78763_78823 = state_78702__$1;
(statearr_78763_78823[(1)] = (30));

} else {
var statearr_78764_78824 = state_78702__$1;
(statearr_78764_78824[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (16))){
var state_78702__$1 = state_78702;
var statearr_78765_78825 = state_78702__$1;
(statearr_78765_78825[(2)] = null);

(statearr_78765_78825[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (38))){
var inst_78637 = (state_78702[(28)]);
var inst_78678 = (state_78702[(2)]);
var state_78702__$1 = (function (){var statearr_78766 = state_78702;
(statearr_78766[(18)] = inst_78678);

return statearr_78766;
})();
if(cljs.core.truth_(inst_78637)){
var statearr_78767_78826 = state_78702__$1;
(statearr_78767_78826[(1)] = (39));

} else {
var statearr_78768_78827 = state_78702__$1;
(statearr_78768_78827[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (30))){
var state_78702__$1 = state_78702;
var statearr_78769_78828 = state_78702__$1;
(statearr_78769_78828[(2)] = (207));

(statearr_78769_78828[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (10))){
var inst_78695 = (state_78702[(2)]);
var state_78702__$1 = state_78702;
var statearr_78770_78829 = state_78702__$1;
(statearr_78770_78829[(2)] = inst_78695);

(statearr_78770_78829[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (18))){
var inst_78639 = (state_78702[(13)]);
var state_78702__$1 = state_78702;
var statearr_78771_78830 = state_78702__$1;
(statearr_78771_78830[(2)] = inst_78639);

(statearr_78771_78830[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (42))){
var inst_78636 = (state_78702[(11)]);
var inst_78686 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_78636);
var state_78702__$1 = state_78702;
var statearr_78772_78831 = state_78702__$1;
(statearr_78772_78831[(2)] = inst_78686);

(statearr_78772_78831[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (37))){
var state_78702__$1 = state_78702;
var statearr_78773_78832 = state_78702__$1;
(statearr_78773_78832[(2)] = null);

(statearr_78773_78832[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78703 === (8))){
var inst_78572 = (state_78702[(23)]);
var state_78702__$1 = state_78702;
if(cljs.core.truth_(inst_78572)){
var statearr_78774_78833 = state_78702__$1;
(statearr_78774_78833[(1)] = (11));

} else {
var statearr_78775_78834 = state_78702__$1;
(statearr_78775_78834[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__16221__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__16221__auto____0 = (function (){
var statearr_78776 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78776[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__16221__auto__);

(statearr_78776[(1)] = (1));

return statearr_78776;
});
var fluree$db$api$query$multi_query_async_$_state_machine__16221__auto____1 = (function (state_78702){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_78702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e78777){var ex__16224__auto__ = e78777;
var statearr_78778_78835 = state_78702;
(statearr_78778_78835[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_78702[(4)]))){
var statearr_78779_78836 = state_78702;
(statearr_78779_78836[(1)] = cljs.core.first.call(null,(state_78702[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78837 = state_78702;
state_78702 = G__78837;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__16221__auto__ = function(state_78702){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__16221__auto____1.call(this,state_78702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__16221__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__16221__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_78780 = f__16346__auto__.call(null);
(statearr_78780[(6)] = c__16345__auto__);

return statearr_78780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__78838 = query_type;
var G__78838__$1 = (((G__78838 instanceof cljs.core.Keyword))?G__78838.fqn:null);
switch (G__78838__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__78838__$1)].join('')));

}
});
