// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__89396 = arguments.length;
switch (G__89396) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__16345__auto___89435 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_89417){
var state_val_89418 = (state_89417[(1)]);
if((state_val_89418 === (1))){
var state_89417__$1 = state_89417;
var statearr_89419_89436 = state_89417__$1;
(statearr_89419_89436[(2)] = null);

(statearr_89419_89436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89418 === (2))){
var _ = (function (){var statearr_89420 = state_89417;
(statearr_89420[(4)] = cljs.core.cons.call(null,(5),(state_89417[(4)])));

return statearr_89420;
})();
var inst_89403 = fluree.db.session.db.call(null,conn,ledger,null);
var state_89417__$1 = state_89417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89417__$1,(7),inst_89403);
} else {
if((state_val_89418 === (3))){
var inst_89413 = (state_89417[(2)]);
var inst_89414 = cljs.core.async.put_BANG_.call(null,pc,inst_89413);
var inst_89415 = cljs.core.async.close_BANG_.call(null,pc);
var state_89417__$1 = (function (){var statearr_89422 = state_89417;
(statearr_89422[(7)] = inst_89414);

return statearr_89422;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89417__$1,inst_89415);
} else {
if((state_val_89418 === (4))){
var inst_89397 = (state_89417[(2)]);
var state_89417__$1 = state_89417;
var statearr_89423_89437 = state_89417__$1;
(statearr_89423_89437[(2)] = inst_89397);

(statearr_89423_89437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89418 === (5))){
var _ = (function (){var statearr_89424 = state_89417;
(statearr_89424[(4)] = cljs.core.rest.call(null,(state_89417[(4)])));

return statearr_89424;
})();
var state_89417__$1 = state_89417;
var ex89421 = (state_89417__$1[(2)]);
var statearr_89425_89438 = state_89417__$1;
(statearr_89425_89438[(5)] = ex89421);


var statearr_89426_89439 = state_89417__$1;
(statearr_89426_89439[(1)] = (4));

(statearr_89426_89439[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89418 === (6))){
var inst_89409 = (state_89417[(2)]);
var inst_89410 = fluree.db.util.async.throw_err.call(null,inst_89409);
var _ = (function (){var statearr_89427 = state_89417;
(statearr_89427[(4)] = cljs.core.rest.call(null,(state_89417[(4)])));

return statearr_89427;
})();
var state_89417__$1 = state_89417;
var statearr_89428_89440 = state_89417__$1;
(statearr_89428_89440[(2)] = inst_89410);

(statearr_89428_89440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89418 === (7))){
var inst_89405 = (state_89417[(2)]);
var inst_89406 = fluree.db.util.async.throw_err.call(null,inst_89405);
var inst_89407 = fluree.db.time_travel.as_of_block.call(null,inst_89406,block);
var state_89417__$1 = state_89417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89417__$1,(6),inst_89407);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__16221__auto__ = null;
var fluree$db$api$ledger$state_machine__16221__auto____0 = (function (){
var statearr_89429 = [null,null,null,null,null,null,null,null];
(statearr_89429[(0)] = fluree$db$api$ledger$state_machine__16221__auto__);

(statearr_89429[(1)] = (1));

return statearr_89429;
});
var fluree$db$api$ledger$state_machine__16221__auto____1 = (function (state_89417){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_89417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e89430){var ex__16224__auto__ = e89430;
var statearr_89431_89441 = state_89417;
(statearr_89431_89441[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_89417[(4)]))){
var statearr_89432_89442 = state_89417;
(statearr_89432_89442[(1)] = cljs.core.first.call(null,(state_89417[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89443 = state_89417;
state_89417 = G__89443;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__16221__auto__ = function(state_89417){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__16221__auto____1.call(this,state_89417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__16221__auto____0;
fluree$db$api$ledger$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__16221__auto____1;
return fluree$db$api$ledger$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_89433 = f__16346__auto__.call(null);
(statearr_89433[(6)] = c__16345__auto___89435);

return statearr_89433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_89484){
var state_val_89485 = (state_89484[(1)]);
if((state_val_89485 === (7))){
var inst_89453 = cljs.core._EQ_.call(null,(0),auth);
var state_89484__$1 = state_89484;
if(inst_89453){
var statearr_89486_89517 = state_89484__$1;
(statearr_89486_89517[(1)] = (9));

} else {
var statearr_89487_89518 = state_89484__$1;
(statearr_89487_89518[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (1))){
var state_89484__$1 = state_89484;
var statearr_89488_89519 = state_89484__$1;
(statearr_89488_89519[(2)] = null);

(statearr_89488_89519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (4))){
var inst_89444 = (state_89484[(2)]);
var state_89484__$1 = state_89484;
var statearr_89489_89520 = state_89484__$1;
(statearr_89489_89520[(2)] = inst_89444);

(statearr_89489_89520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (15))){
var inst_89461 = (state_89484[(7)]);
var inst_89460 = (state_89484[(2)]);
var inst_89461__$1 = fluree.db.util.async.throw_err.call(null,inst_89460);
var state_89484__$1 = (function (){var statearr_89490 = state_89484;
(statearr_89490[(7)] = inst_89461__$1);

return statearr_89490;
})();
if(cljs.core.truth_(inst_89461__$1)){
var statearr_89491_89521 = state_89484__$1;
(statearr_89491_89521[(1)] = (16));

} else {
var statearr_89492_89522 = state_89484__$1;
(statearr_89492_89522[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (13))){
var state_89484__$1 = state_89484;
var statearr_89493_89523 = state_89484__$1;
(statearr_89493_89523[(2)] = null);

(statearr_89493_89523[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (6))){
var state_89484__$1 = state_89484;
var statearr_89494_89524 = state_89484__$1;
(statearr_89494_89524[(2)] = db);

(statearr_89494_89524[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (17))){
var inst_89465 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_89466 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_89467 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_89468 = cljs.core.PersistentHashMap.fromArrays(inst_89466,inst_89467);
var inst_89469 = cljs.core.ex_info.call(null,inst_89465,inst_89468);
var inst_89470 = (function(){throw inst_89469})();
var state_89484__$1 = state_89484;
var statearr_89495_89525 = state_89484__$1;
(statearr_89495_89525[(2)] = inst_89470);

(statearr_89495_89525[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (3))){
var inst_89482 = (state_89484[(2)]);
var state_89484__$1 = state_89484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89484__$1,inst_89482);
} else {
if((state_val_89485 === (12))){
var inst_89458 = fluree.db.dbproto._subid.call(null,db,auth);
var state_89484__$1 = state_89484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89484__$1,(15),inst_89458);
} else {
if((state_val_89485 === (2))){
var _ = (function (){var statearr_89496 = state_89484;
(statearr_89496[(4)] = cljs.core.cons.call(null,(5),(state_89484[(4)])));

return statearr_89496;
})();
var inst_89450 = cljs.core.not.call(null,auth);
var state_89484__$1 = state_89484;
if(inst_89450){
var statearr_89497_89526 = state_89484__$1;
(statearr_89497_89526[(1)] = (6));

} else {
var statearr_89498_89527 = state_89484__$1;
(statearr_89498_89527[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (11))){
var inst_89477 = (state_89484[(2)]);
var state_89484__$1 = state_89484;
var statearr_89500_89528 = state_89484__$1;
(statearr_89500_89528[(2)] = inst_89477);

(statearr_89500_89528[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (9))){
var inst_89455 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_89484__$1 = state_89484;
var statearr_89501_89529 = state_89484__$1;
(statearr_89501_89529[(2)] = inst_89455);

(statearr_89501_89529[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (5))){
var _ = (function (){var statearr_89502 = state_89484;
(statearr_89502[(4)] = cljs.core.rest.call(null,(state_89484[(4)])));

return statearr_89502;
})();
var state_89484__$1 = state_89484;
var ex89499 = (state_89484__$1[(2)]);
var statearr_89503_89530 = state_89484__$1;
(statearr_89503_89530[(5)] = ex89499);


if((ex89499 instanceof Error)){
var statearr_89504_89531 = state_89484__$1;
(statearr_89504_89531[(1)] = (4));

(statearr_89504_89531[(5)] = null);

} else {
throw ex89499;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (14))){
var inst_89475 = (state_89484[(2)]);
var state_89484__$1 = state_89484;
var statearr_89505_89532 = state_89484__$1;
(statearr_89505_89532[(2)] = inst_89475);

(statearr_89505_89532[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (16))){
var inst_89461 = (state_89484[(7)]);
var inst_89463 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_89461);
var state_89484__$1 = state_89484;
var statearr_89506_89533 = state_89484__$1;
(statearr_89506_89533[(2)] = inst_89463);

(statearr_89506_89533[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (10))){
var state_89484__$1 = state_89484;
var statearr_89507_89534 = state_89484__$1;
(statearr_89507_89534[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (18))){
var inst_89472 = (state_89484[(2)]);
var state_89484__$1 = state_89484;
var statearr_89509_89535 = state_89484__$1;
(statearr_89509_89535[(2)] = inst_89472);

(statearr_89509_89535[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89485 === (8))){
var inst_89479 = (state_89484[(2)]);
var _ = (function (){var statearr_89510 = state_89484;
(statearr_89510[(4)] = cljs.core.rest.call(null,(state_89484[(4)])));

return statearr_89510;
})();
var state_89484__$1 = state_89484;
var statearr_89511_89536 = state_89484__$1;
(statearr_89511_89536[(2)] = inst_89479);

(statearr_89511_89536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__16221__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__16221__auto____0 = (function (){
var statearr_89512 = [null,null,null,null,null,null,null,null];
(statearr_89512[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__16221__auto__);

(statearr_89512[(1)] = (1));

return statearr_89512;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__16221__auto____1 = (function (state_89484){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_89484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e89513){var ex__16224__auto__ = e89513;
var statearr_89514_89537 = state_89484;
(statearr_89514_89537[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_89484[(4)]))){
var statearr_89515_89538 = state_89484;
(statearr_89515_89538[(1)] = cljs.core.first.call(null,(state_89484[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89539 = state_89484;
state_89484 = G__89539;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__16221__auto__ = function(state_89484){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__16221__auto____1.call(this,state_89484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__16221__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__16221__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_89516 = f__16346__auto__.call(null);
(statearr_89516[(6)] = c__16345__auto__);

return statearr_89516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_89603){
var state_val_89604 = (state_89603[(1)]);
if((state_val_89604 === (7))){
var inst_89549 = cljs.core._EQ_.call(null,(0),auth);
var state_89603__$1 = state_89603;
if(inst_89549){
var statearr_89605_89654 = state_89603__$1;
(statearr_89605_89654[(1)] = (9));

} else {
var statearr_89606_89655 = state_89603__$1;
(statearr_89606_89655[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (20))){
var inst_89573 = (state_89603[(7)]);
var state_89603__$1 = state_89603;
if(cljs.core.truth_(inst_89573)){
var statearr_89607_89656 = state_89603__$1;
(statearr_89607_89656[(1)] = (22));

} else {
var statearr_89608_89657 = state_89603__$1;
(statearr_89608_89657[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (27))){
var state_89603__$1 = state_89603;
var statearr_89609_89658 = state_89603__$1;
(statearr_89609_89658[(2)] = null);

(statearr_89609_89658[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (1))){
var state_89603__$1 = state_89603;
var statearr_89610_89659 = state_89603__$1;
(statearr_89610_89659[(2)] = null);

(statearr_89610_89659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (24))){
var inst_89587 = (state_89603[(2)]);
var state_89603__$1 = state_89603;
var statearr_89611_89660 = state_89603__$1;
(statearr_89611_89660[(2)] = inst_89587);

(statearr_89611_89660[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (4))){
var inst_89540 = (state_89603[(2)]);
var state_89603__$1 = state_89603;
var statearr_89612_89661 = state_89603__$1;
(statearr_89612_89661[(2)] = inst_89540);

(statearr_89612_89661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (15))){
var inst_89556 = (state_89603[(8)]);
var inst_89555 = (state_89603[(2)]);
var inst_89556__$1 = fluree.db.util.async.throw_err.call(null,inst_89555);
var state_89603__$1 = (function (){var statearr_89613 = state_89603;
(statearr_89613[(8)] = inst_89556__$1);

return statearr_89613;
})();
if(cljs.core.truth_(inst_89556__$1)){
var statearr_89614_89662 = state_89603__$1;
(statearr_89614_89662[(1)] = (16));

} else {
var statearr_89615_89663 = state_89603__$1;
(statearr_89615_89663[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (21))){
var inst_89589 = (state_89603[(9)]);
var inst_89589__$1 = (state_89603[(2)]);
var state_89603__$1 = (function (){var statearr_89616 = state_89603;
(statearr_89616[(9)] = inst_89589__$1);

return statearr_89616;
})();
if(cljs.core.truth_(inst_89589__$1)){
var statearr_89617_89664 = state_89603__$1;
(statearr_89617_89664[(1)] = (29));

} else {
var statearr_89618_89665 = state_89603__$1;
(statearr_89618_89665[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (31))){
var inst_89573 = (state_89603[(7)]);
var inst_89589 = (state_89603[(9)]);
var inst_89597 = (state_89603[(2)]);
var inst_89598 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_89573,new cljs.core.Keyword(null,"roles","roles",143379530),inst_89589,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_89597);
var _ = (function (){var statearr_89619 = state_89603;
(statearr_89619[(4)] = cljs.core.rest.call(null,(state_89603[(4)])));

return statearr_89619;
})();
var state_89603__$1 = state_89603;
var statearr_89620_89666 = state_89603__$1;
(statearr_89620_89666[(2)] = inst_89598);

(statearr_89620_89666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (32))){
var inst_89593 = (state_89603[(2)]);
var inst_89594 = fluree.db.util.async.throw_err.call(null,inst_89593);
var state_89603__$1 = state_89603;
var statearr_89621_89667 = state_89603__$1;
(statearr_89621_89667[(2)] = inst_89594);

(statearr_89621_89667[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (13))){
var state_89603__$1 = state_89603;
var statearr_89622_89668 = state_89603__$1;
(statearr_89622_89668[(2)] = null);

(statearr_89622_89668[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (22))){
var inst_89573 = (state_89603[(7)]);
var inst_89577 = fluree.db.auth.roles.call(null,db,inst_89573);
var state_89603__$1 = state_89603;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89603__$1,(25),inst_89577);
} else {
if((state_val_89604 === (29))){
var inst_89589 = (state_89603[(9)]);
var inst_89591 = fluree.db.permissions.permission_map.call(null,db,inst_89589,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_89603__$1 = state_89603;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89603__$1,(32),inst_89591);
} else {
if((state_val_89604 === (6))){
var state_89603__$1 = state_89603;
var statearr_89623_89669 = state_89603__$1;
(statearr_89623_89669[(2)] = null);

(statearr_89623_89669[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (28))){
var inst_89585 = (state_89603[(2)]);
var state_89603__$1 = state_89603;
var statearr_89624_89670 = state_89603__$1;
(statearr_89624_89670[(2)] = inst_89585);

(statearr_89624_89670[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (25))){
var inst_89579 = (state_89603[(2)]);
var inst_89580 = fluree.db.util.async.throw_err.call(null,inst_89579);
var state_89603__$1 = state_89603;
var statearr_89625_89671 = state_89603__$1;
(statearr_89625_89671[(2)] = inst_89580);

(statearr_89625_89671[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (17))){
var inst_89559 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_89560 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_89561 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_89562 = cljs.core.PersistentHashMap.fromArrays(inst_89560,inst_89561);
var inst_89563 = cljs.core.ex_info.call(null,inst_89559,inst_89562);
var inst_89564 = (function(){throw inst_89563})();
var state_89603__$1 = state_89603;
var statearr_89626_89672 = state_89603__$1;
(statearr_89626_89672[(2)] = inst_89564);

(statearr_89626_89672[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (3))){
var inst_89601 = (state_89603[(2)]);
var state_89603__$1 = state_89603;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89603__$1,inst_89601);
} else {
if((state_val_89604 === (12))){
var inst_89553 = fluree.db.dbproto._subid.call(null,db,auth);
var state_89603__$1 = state_89603;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89603__$1,(15),inst_89553);
} else {
if((state_val_89604 === (2))){
var _ = (function (){var statearr_89627 = state_89603;
(statearr_89627[(4)] = cljs.core.cons.call(null,(5),(state_89603[(4)])));

return statearr_89627;
})();
var inst_89546 = (auth == null);
var state_89603__$1 = state_89603;
if(cljs.core.truth_(inst_89546)){
var statearr_89628_89673 = state_89603__$1;
(statearr_89628_89673[(1)] = (6));

} else {
var statearr_89629_89674 = state_89603__$1;
(statearr_89629_89674[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (23))){
var state_89603__$1 = state_89603;
var statearr_89630_89675 = state_89603__$1;
(statearr_89630_89675[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (19))){
var state_89603__$1 = state_89603;
var statearr_89632_89676 = state_89603__$1;
(statearr_89632_89676[(2)] = roles);

(statearr_89632_89676[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (11))){
var inst_89571 = (state_89603[(2)]);
var state_89603__$1 = state_89603;
var statearr_89634_89677 = state_89603__$1;
(statearr_89634_89677[(2)] = inst_89571);

(statearr_89634_89677[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (9))){
var state_89603__$1 = state_89603;
var statearr_89635_89678 = state_89603__$1;
(statearr_89635_89678[(2)] = (0));

(statearr_89635_89678[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (5))){
var _ = (function (){var statearr_89636 = state_89603;
(statearr_89636[(4)] = cljs.core.rest.call(null,(state_89603[(4)])));

return statearr_89636;
})();
var state_89603__$1 = state_89603;
var ex89633 = (state_89603__$1[(2)]);
var statearr_89637_89679 = state_89603__$1;
(statearr_89637_89679[(5)] = ex89633);


if((ex89633 instanceof Error)){
var statearr_89638_89680 = state_89603__$1;
(statearr_89638_89680[(1)] = (4));

(statearr_89638_89680[(5)] = null);

} else {
throw ex89633;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (14))){
var inst_89569 = (state_89603[(2)]);
var state_89603__$1 = state_89603;
var statearr_89639_89681 = state_89603__$1;
(statearr_89639_89681[(2)] = inst_89569);

(statearr_89639_89681[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (26))){
var state_89603__$1 = state_89603;
var statearr_89640_89682 = state_89603__$1;
(statearr_89640_89682[(2)] = null);

(statearr_89640_89682[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (16))){
var inst_89556 = (state_89603[(8)]);
var state_89603__$1 = state_89603;
var statearr_89641_89683 = state_89603__$1;
(statearr_89641_89683[(2)] = inst_89556);

(statearr_89641_89683[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (30))){
var state_89603__$1 = state_89603;
var statearr_89642_89684 = state_89603__$1;
(statearr_89642_89684[(2)] = null);

(statearr_89642_89684[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (10))){
var state_89603__$1 = state_89603;
if(cljs.core.truth_(auth)){
var statearr_89643_89685 = state_89603__$1;
(statearr_89643_89685[(1)] = (12));

} else {
var statearr_89644_89686 = state_89603__$1;
(statearr_89644_89686[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (18))){
var inst_89566 = (state_89603[(2)]);
var state_89603__$1 = state_89603;
var statearr_89645_89687 = state_89603__$1;
(statearr_89645_89687[(2)] = inst_89566);

(statearr_89645_89687[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89604 === (8))){
var inst_89573 = (state_89603[(2)]);
var state_89603__$1 = (function (){var statearr_89646 = state_89603;
(statearr_89646[(7)] = inst_89573);

return statearr_89646;
})();
if(cljs.core.truth_(roles)){
var statearr_89647_89688 = state_89603__$1;
(statearr_89647_89688[(1)] = (19));

} else {
var statearr_89648_89689 = state_89603__$1;
(statearr_89648_89689[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__16221__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__16221__auto____0 = (function (){
var statearr_89649 = [null,null,null,null,null,null,null,null,null,null];
(statearr_89649[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__16221__auto__);

(statearr_89649[(1)] = (1));

return statearr_89649;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__16221__auto____1 = (function (state_89603){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_89603);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e89650){var ex__16224__auto__ = e89650;
var statearr_89651_89690 = state_89603;
(statearr_89651_89690[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_89603[(4)]))){
var statearr_89652_89691 = state_89603;
(statearr_89652_89691[(1)] = cljs.core.first.call(null,(state_89603[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89692 = state_89603;
state_89603 = G__89692;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__16221__auto__ = function(state_89603){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__16221__auto____1.call(this,state_89603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__16221__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__16221__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_89653 = f__16346__auto__.call(null);
(statearr_89653[(6)] = c__16345__auto__);

return statearr_89653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__89693 = db;
var map__89693__$1 = cljs.core.__destructure_map.call(null,map__89693);
var conn = cljs.core.get.call(null,map__89693__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__89693__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__89693__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.call(null,"NEW EVENT:",cljs.core.pr_str.call(null,evt),cljs.core.pr_str.call(null,data));

if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);

var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_89700){
var state_val_89701 = (state_89700[(1)]);
if((state_val_89701 === (1))){
var inst_89694 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_89695 = fluree.db.session.db.call(null,conn,inst_89694,null);
var state_89700__$1 = state_89700;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89700__$1,(2),inst_89695);
} else {
if((state_val_89701 === (2))){
var inst_89697 = (state_89700[(2)]);
var inst_89698 = cljs.core.async.put_BANG_.call(null,resp_port,inst_89697);
var state_89700__$1 = state_89700;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89700__$1,inst_89698);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto____0 = (function (){
var statearr_89702 = [null,null,null,null,null,null,null];
(statearr_89702[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto__);

(statearr_89702[(1)] = (1));

return statearr_89702;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto____1 = (function (state_89700){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_89700);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e89703){var ex__16224__auto__ = e89703;
var statearr_89704_89731 = state_89700;
(statearr_89704_89731[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_89700[(4)]))){
var statearr_89705_89732 = state_89700;
(statearr_89705_89732[(1)] = cljs.core.first.call(null,(state_89700[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89733 = state_89700;
state_89700 = G__89733;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto__ = function(state_89700){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto____1.call(this,state_89700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_89706 = f__16346__auto__.call(null);
(statearr_89706[(6)] = c__16345__auto__);

return statearr_89706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,dbid,listen_id,event_fn);

var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_89719){
var state_val_89720 = (state_89719[(1)]);
if((state_val_89720 === (1))){
var inst_89707 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_89708 = fluree.db.session.db.call(null,conn,inst_89707,null);
var state_89719__$1 = state_89719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89719__$1,(2),inst_89708);
} else {
if((state_val_89720 === (2))){
var inst_89710 = (state_89719[(7)]);
var inst_89710__$1 = (state_89719[(2)]);
var inst_89711 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_89710__$1);
var inst_89712 = newer_block_QMARK_.call(null,inst_89711);
var state_89719__$1 = (function (){var statearr_89721 = state_89719;
(statearr_89721[(7)] = inst_89710__$1);

return statearr_89721;
})();
if(inst_89712){
var statearr_89722_89734 = state_89719__$1;
(statearr_89722_89734[(1)] = (3));

} else {
var statearr_89723_89735 = state_89719__$1;
(statearr_89723_89735[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89720 === (3))){
var inst_89710 = (state_89719[(7)]);
var inst_89714 = cljs.core.async.put_BANG_.call(null,resp_port,inst_89710);
var state_89719__$1 = state_89719;
var statearr_89724_89736 = state_89719__$1;
(statearr_89724_89736[(2)] = inst_89714);

(statearr_89724_89736[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89720 === (4))){
var state_89719__$1 = state_89719;
var statearr_89725_89737 = state_89719__$1;
(statearr_89725_89737[(2)] = null);

(statearr_89725_89737[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89720 === (5))){
var inst_89717 = (state_89719[(2)]);
var state_89719__$1 = state_89719;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89719__$1,inst_89717);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto____0 = (function (){
var statearr_89726 = [null,null,null,null,null,null,null,null];
(statearr_89726[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto__);

(statearr_89726[(1)] = (1));

return statearr_89726;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto____1 = (function (state_89719){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_89719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e89727){var ex__16224__auto__ = e89727;
var statearr_89728_89738 = state_89719;
(statearr_89728_89738[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_89719[(4)]))){
var statearr_89729_89739 = state_89719;
(statearr_89729_89739[(1)] = cljs.core.first.call(null,(state_89719[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89740 = state_89719;
state_89719 = G__89740;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto__ = function(state_89719){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto____1.call(this,state_89719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_89730 = f__16346__auto__.call(null);
(statearr_89730[(6)] = c__16345__auto__);

return statearr_89730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__89741 = db;
var map__89741__$1 = cljs.core.__destructure_map.call(null,map__89741);
var conn = cljs.core.get.call(null,map__89741__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__89741__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__89741__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__4298__auto__ = syncTimeout;
var y__4299__auto__ = (120000);
return ((x__4298__auto__ < y__4299__auto__) ? x__4298__auto__ : y__4299__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__16345__auto___89817 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_89791){
var state_val_89792 = (state_89791[(1)]);
if((state_val_89792 === (7))){
var inst_89757 = (state_89791[(7)]);
var inst_89768 = cljs.core._EQ_.call(null,inst_89757,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_89791__$1 = state_89791;
if(inst_89768){
var statearr_89793_89818 = state_89791__$1;
(statearr_89793_89818[(1)] = (9));

} else {
var statearr_89794_89819 = state_89791__$1;
(statearr_89794_89819[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89792 === (1))){
var inst_89750 = (state_89791[(8)]);
var inst_89742 = (state_89791[(9)]);
var inst_89742__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_89750__$1 = res_port;
var inst_89751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_89752 = [inst_89742__$1,inst_89750__$1];
var inst_89753 = (new cljs.core.PersistentVector(null,2,(5),inst_89751,inst_89752,null));
var state_89791__$1 = (function (){var statearr_89795 = state_89791;
(statearr_89795[(8)] = inst_89750__$1);

(statearr_89795[(9)] = inst_89742__$1);

return statearr_89795;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_89791__$1,(2),inst_89753);
} else {
if((state_val_89792 === (4))){
var inst_89750 = (state_89791[(8)]);
var inst_89757 = (state_89791[(7)]);
var inst_89761 = cljs.core._EQ_.call(null,inst_89757,inst_89750);
var state_89791__$1 = state_89791;
if(inst_89761){
var statearr_89796_89820 = state_89791__$1;
(statearr_89796_89820[(1)] = (6));

} else {
var statearr_89797_89821 = state_89791__$1;
(statearr_89797_89821[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89792 === (13))){
var inst_89776 = (state_89791[(10)]);
var inst_89787 = cljs.core.async.put_BANG_.call(null,pc,inst_89776);
var state_89791__$1 = state_89791;
var statearr_89798_89822 = state_89791__$1;
(statearr_89798_89822[(2)] = inst_89787);

(statearr_89798_89822[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89792 === (6))){
var inst_89755 = (state_89791[(11)]);
var inst_89766 = cljs.core.nth.call(null,inst_89755,(0),null);
var state_89791__$1 = state_89791;
var statearr_89799_89823 = state_89791__$1;
(statearr_89799_89823[(2)] = inst_89766);

(statearr_89799_89823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89792 === (3))){
var state_89791__$1 = state_89791;
var statearr_89800_89824 = state_89791__$1;
(statearr_89800_89824[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_89800_89824[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89792 === (12))){
var inst_89780 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_89781 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_89782 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_89783 = cljs.core.PersistentHashMap.fromArrays(inst_89781,inst_89782);
var inst_89784 = cljs.core.ex_info.call(null,inst_89780,inst_89783);
var inst_89785 = cljs.core.async.put_BANG_.call(null,pc,inst_89784);
var state_89791__$1 = state_89791;
var statearr_89801_89825 = state_89791__$1;
(statearr_89801_89825[(2)] = inst_89785);

(statearr_89801_89825[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89792 === (2))){
var inst_89755 = (state_89791[(11)]);
var inst_89742 = (state_89791[(9)]);
var inst_89757 = (state_89791[(7)]);
var inst_89755__$1 = (state_89791[(2)]);
var inst_89756 = cljs.core.nth.call(null,inst_89755__$1,(0),null);
var inst_89757__$1 = cljs.core.nth.call(null,inst_89755__$1,(1),null);
var inst_89758 = cljs.core._EQ_.call(null,inst_89757__$1,inst_89742);
var state_89791__$1 = (function (){var statearr_89802 = state_89791;
(statearr_89802[(11)] = inst_89755__$1);

(statearr_89802[(12)] = inst_89756);

(statearr_89802[(7)] = inst_89757__$1);

return statearr_89802;
})();
if(inst_89758){
var statearr_89803_89826 = state_89791__$1;
(statearr_89803_89826[(1)] = (3));

} else {
var statearr_89804_89827 = state_89791__$1;
(statearr_89804_89827[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89792 === (11))){
var inst_89772 = (state_89791[(2)]);
var state_89791__$1 = state_89791;
var statearr_89805_89828 = state_89791__$1;
(statearr_89805_89828[(2)] = inst_89772);

(statearr_89805_89828[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89792 === (9))){
var inst_89756 = (state_89791[(12)]);
var state_89791__$1 = state_89791;
var statearr_89806_89829 = state_89791__$1;
(statearr_89806_89829[(2)] = inst_89756);

(statearr_89806_89829[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89792 === (5))){
var inst_89776 = (state_89791[(10)]);
var inst_89776__$1 = (state_89791[(2)]);
var inst_89777 = fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);
var inst_89778 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_89776__$1);
var state_89791__$1 = (function (){var statearr_89807 = state_89791;
(statearr_89807[(13)] = inst_89777);

(statearr_89807[(10)] = inst_89776__$1);

return statearr_89807;
})();
if(inst_89778){
var statearr_89808_89830 = state_89791__$1;
(statearr_89808_89830[(1)] = (12));

} else {
var statearr_89809_89831 = state_89791__$1;
(statearr_89809_89831[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89792 === (14))){
var inst_89789 = (state_89791[(2)]);
var state_89791__$1 = state_89791;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89791__$1,inst_89789);
} else {
if((state_val_89792 === (10))){
var state_89791__$1 = state_89791;
var statearr_89810_89832 = state_89791__$1;
(statearr_89810_89832[(2)] = null);

(statearr_89810_89832[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89792 === (8))){
var inst_89774 = (state_89791[(2)]);
var state_89791__$1 = state_89791;
var statearr_89811_89833 = state_89791__$1;
(statearr_89811_89833[(2)] = inst_89774);

(statearr_89811_89833[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__16221__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__16221__auto____0 = (function (){
var statearr_89812 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_89812[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__16221__auto__);

(statearr_89812[(1)] = (1));

return statearr_89812;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__16221__auto____1 = (function (state_89791){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_89791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e89813){var ex__16224__auto__ = e89813;
var statearr_89814_89834 = state_89791;
(statearr_89814_89834[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_89791[(4)]))){
var statearr_89815_89835 = state_89791;
(statearr_89815_89835[(1)] = cljs.core.first.call(null,(state_89791[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89836 = state_89791;
state_89791 = G__89836;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__16221__auto__ = function(state_89791){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__16221__auto____1.call(this,state_89791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__16221__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__16221__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_89816 = f__16346__auto__.call(null);
(statearr_89816[(6)] = c__16345__auto___89817);

return statearr_89816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__89838 = arguments.length;
switch (G__89838) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__89839){
var map__89840 = p__89839;
var map__89840__$1 = cljs.core.__destructure_map.call(null,map__89840);
var opts = map__89840__$1;
var roles = cljs.core.get.call(null,map__89840__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__89840__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__89840__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__89840__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__89840__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__16345__auto___89929 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_89891){
var state_val_89892 = (state_89891[(1)]);
if((state_val_89892 === (7))){
var inst_89853 = (state_89891[(7)]);
var inst_89855 = fluree.db.api.ledger.syncTo_db.call(null,inst_89853,syncTo,syncTimeout);
var state_89891__$1 = state_89891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89891__$1,(10),inst_89855);
} else {
if((state_val_89892 === (20))){
var inst_89877 = (state_89891[(8)]);
var state_89891__$1 = state_89891;
var statearr_89893_89930 = state_89891__$1;
(statearr_89893_89930[(2)] = inst_89877);

(statearr_89893_89930[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (1))){
var state_89891__$1 = state_89891;
var statearr_89894_89931 = state_89891__$1;
(statearr_89894_89931[(2)] = null);

(statearr_89894_89931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (4))){
var inst_89841 = (state_89891[(2)]);
var inst_89842 = cljs.core.async.put_BANG_.call(null,pc,inst_89841);
var inst_89843 = cljs.core.async.close_BANG_.call(null,pc);
var state_89891__$1 = (function (){var statearr_89895 = state_89891;
(statearr_89895[(9)] = inst_89842);

return statearr_89895;
})();
var statearr_89896_89932 = state_89891__$1;
(statearr_89896_89932[(2)] = inst_89843);

(statearr_89896_89932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (15))){
var inst_89869 = (state_89891[(10)]);
var inst_89871 = fluree.db.api.ledger.add_db_permissions.call(null,inst_89869,auth,roles);
var state_89891__$1 = state_89891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89891__$1,(18),inst_89871);
} else {
if((state_val_89892 === (21))){
var inst_89885 = (state_89891[(2)]);
var inst_89886 = cljs.core.async.put_BANG_.call(null,pc,inst_89885);
var _ = (function (){var statearr_89897 = state_89891;
(statearr_89897[(4)] = cljs.core.rest.call(null,(state_89891[(4)])));

return statearr_89897;
})();
var state_89891__$1 = state_89891;
var statearr_89898_89933 = state_89891__$1;
(statearr_89898_89933[(2)] = inst_89886);

(statearr_89898_89933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (13))){
var inst_89869 = (state_89891[(2)]);
var state_89891__$1 = (function (){var statearr_89899 = state_89891;
(statearr_89899[(10)] = inst_89869);

return statearr_89899;
})();
if(cljs.core.truth_(roles)){
var statearr_89900_89934 = state_89891__$1;
(statearr_89900_89934[(1)] = (15));

} else {
var statearr_89901_89935 = state_89891__$1;
(statearr_89901_89935[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (22))){
var inst_89881 = (state_89891[(2)]);
var inst_89882 = fluree.db.util.async.throw_err.call(null,inst_89881);
var state_89891__$1 = state_89891;
var statearr_89902_89936 = state_89891__$1;
(statearr_89902_89936[(2)] = inst_89882);

(statearr_89902_89936[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (6))){
var inst_89852 = (state_89891[(2)]);
var inst_89853 = fluree.db.util.async.throw_err.call(null,inst_89852);
var state_89891__$1 = (function (){var statearr_89903 = state_89891;
(statearr_89903[(7)] = inst_89853);

return statearr_89903;
})();
if(cljs.core.truth_(syncTo)){
var statearr_89904_89937 = state_89891__$1;
(statearr_89904_89937[(1)] = (7));

} else {
var statearr_89905_89938 = state_89891__$1;
(statearr_89905_89938[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (17))){
var inst_89877 = (state_89891[(2)]);
var state_89891__$1 = (function (){var statearr_89906 = state_89891;
(statearr_89906[(8)] = inst_89877);

return statearr_89906;
})();
if(cljs.core.truth_(auth)){
var statearr_89907_89939 = state_89891__$1;
(statearr_89907_89939[(1)] = (19));

} else {
var statearr_89908_89940 = state_89891__$1;
(statearr_89908_89940[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (3))){
var inst_89889 = (state_89891[(2)]);
var state_89891__$1 = state_89891;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89891__$1,inst_89889);
} else {
if((state_val_89892 === (12))){
var inst_89861 = (state_89891[(11)]);
var state_89891__$1 = state_89891;
var statearr_89909_89941 = state_89891__$1;
(statearr_89909_89941[(2)] = inst_89861);

(statearr_89909_89941[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (2))){
var _ = (function (){var statearr_89910 = state_89891;
(statearr_89910[(4)] = cljs.core.cons.call(null,(5),(state_89891[(4)])));

return statearr_89910;
})();
var inst_89850 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_89891__$1 = state_89891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89891__$1,(6),inst_89850);
} else {
if((state_val_89892 === (19))){
var inst_89877 = (state_89891[(8)]);
var inst_89879 = fluree.db.api.ledger.add_db_permissions.call(null,inst_89877,auth,roles);
var state_89891__$1 = state_89891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89891__$1,(22),inst_89879);
} else {
if((state_val_89892 === (11))){
var inst_89861 = (state_89891[(11)]);
var inst_89863 = fluree.db.time_travel.as_of_block.call(null,inst_89861,block);
var state_89891__$1 = state_89891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89891__$1,(14),inst_89863);
} else {
if((state_val_89892 === (9))){
var inst_89861 = (state_89891[(2)]);
var state_89891__$1 = (function (){var statearr_89912 = state_89891;
(statearr_89912[(11)] = inst_89861);

return statearr_89912;
})();
if(cljs.core.truth_(block)){
var statearr_89913_89942 = state_89891__$1;
(statearr_89913_89942[(1)] = (11));

} else {
var statearr_89914_89943 = state_89891__$1;
(statearr_89914_89943[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (5))){
var _ = (function (){var statearr_89915 = state_89891;
(statearr_89915[(4)] = cljs.core.rest.call(null,(state_89891[(4)])));

return statearr_89915;
})();
var state_89891__$1 = state_89891;
var ex89911 = (state_89891__$1[(2)]);
var statearr_89916_89944 = state_89891__$1;
(statearr_89916_89944[(5)] = ex89911);


var statearr_89917_89945 = state_89891__$1;
(statearr_89917_89945[(1)] = (4));

(statearr_89917_89945[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (14))){
var inst_89865 = (state_89891[(2)]);
var inst_89866 = fluree.db.util.async.throw_err.call(null,inst_89865);
var state_89891__$1 = state_89891;
var statearr_89918_89946 = state_89891__$1;
(statearr_89918_89946[(2)] = inst_89866);

(statearr_89918_89946[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (16))){
var inst_89869 = (state_89891[(10)]);
var state_89891__$1 = state_89891;
var statearr_89919_89947 = state_89891__$1;
(statearr_89919_89947[(2)] = inst_89869);

(statearr_89919_89947[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (10))){
var inst_89857 = (state_89891[(2)]);
var inst_89858 = fluree.db.util.async.throw_err.call(null,inst_89857);
var state_89891__$1 = state_89891;
var statearr_89920_89948 = state_89891__$1;
(statearr_89920_89948[(2)] = inst_89858);

(statearr_89920_89948[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (18))){
var inst_89873 = (state_89891[(2)]);
var inst_89874 = fluree.db.util.async.throw_err.call(null,inst_89873);
var state_89891__$1 = state_89891;
var statearr_89921_89949 = state_89891__$1;
(statearr_89921_89949[(2)] = inst_89874);

(statearr_89921_89949[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89892 === (8))){
var inst_89853 = (state_89891[(7)]);
var state_89891__$1 = state_89891;
var statearr_89922_89950 = state_89891__$1;
(statearr_89922_89950[(2)] = inst_89853);

(statearr_89922_89950[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__16221__auto__ = null;
var fluree$db$api$ledger$state_machine__16221__auto____0 = (function (){
var statearr_89923 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_89923[(0)] = fluree$db$api$ledger$state_machine__16221__auto__);

(statearr_89923[(1)] = (1));

return statearr_89923;
});
var fluree$db$api$ledger$state_machine__16221__auto____1 = (function (state_89891){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_89891);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e89924){var ex__16224__auto__ = e89924;
var statearr_89925_89951 = state_89891;
(statearr_89925_89951[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_89891[(4)]))){
var statearr_89926_89952 = state_89891;
(statearr_89926_89952[(1)] = cljs.core.first.call(null,(state_89891[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89953 = state_89891;
state_89891 = G__89953;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__16221__auto__ = function(state_89891){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__16221__auto____1.call(this,state_89891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__16221__auto____0;
fluree$db$api$ledger$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__16221__auto____1;
return fluree$db$api$ledger$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_89927 = f__16346__auto__.call(null);
(statearr_89927[(6)] = c__16345__auto___89929);

return statearr_89927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

