// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__18278 = arguments.length;
switch (G__18278) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18279 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18279 = (function (f,blockable,meta18280){
this.f = f;
this.blockable = blockable;
this.meta18280 = meta18280;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18279.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18281,meta18280__$1){
var self__ = this;
var _18281__$1 = this;
return (new cljs.core.async.t_cljs$core$async18279(self__.f,self__.blockable,meta18280__$1));
}));

(cljs.core.async.t_cljs$core$async18279.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18281){
var self__ = this;
var _18281__$1 = this;
return self__.meta18280;
}));

(cljs.core.async.t_cljs$core$async18279.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18279.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async18279.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async18279.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async18279.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta18280","meta18280",2143529812,null)], null);
}));

(cljs.core.async.t_cljs$core$async18279.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18279.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18279");

(cljs.core.async.t_cljs$core$async18279.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write.call(null,writer__4451__auto__,"cljs.core.async/t_cljs$core$async18279");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18279.
 */
cljs.core.async.__GT_t_cljs$core$async18279 = (function cljs$core$async$__GT_t_cljs$core$async18279(f__$1,blockable__$1,meta18280){
return (new cljs.core.async.t_cljs$core$async18279(f__$1,blockable__$1,meta18280));
});

}

return (new cljs.core.async.t_cljs$core$async18279(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__18285 = arguments.length;
switch (G__18285) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__18288 = arguments.length;
switch (G__18288) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__18291 = arguments.length;
switch (G__18291) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_18293 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_18293);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_18293);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__18295 = arguments.length;
switch (G__18295) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4695__auto___18297 = n;
var x_18298 = (0);
while(true){
if((x_18298 < n__4695__auto___18297)){
(a[x_18298] = x_18298);

var G__18299 = (x_18298 + (1));
x_18298 = G__18299;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18300 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18300 = (function (flag,meta18301){
this.flag = flag;
this.meta18301 = meta18301;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18300.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18302,meta18301__$1){
var self__ = this;
var _18302__$1 = this;
return (new cljs.core.async.t_cljs$core$async18300(self__.flag,meta18301__$1));
}));

(cljs.core.async.t_cljs$core$async18300.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18302){
var self__ = this;
var _18302__$1 = this;
return self__.meta18301;
}));

(cljs.core.async.t_cljs$core$async18300.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18300.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async18300.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async18300.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async18300.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta18301","meta18301",-63252715,null)], null);
}));

(cljs.core.async.t_cljs$core$async18300.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18300.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18300");

(cljs.core.async.t_cljs$core$async18300.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write.call(null,writer__4451__auto__,"cljs.core.async/t_cljs$core$async18300");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18300.
 */
cljs.core.async.__GT_t_cljs$core$async18300 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async18300(flag__$1,meta18301){
return (new cljs.core.async.t_cljs$core$async18300(flag__$1,meta18301));
});

}

return (new cljs.core.async.t_cljs$core$async18300(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18303 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18303 = (function (flag,cb,meta18304){
this.flag = flag;
this.cb = cb;
this.meta18304 = meta18304;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18303.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18305,meta18304__$1){
var self__ = this;
var _18305__$1 = this;
return (new cljs.core.async.t_cljs$core$async18303(self__.flag,self__.cb,meta18304__$1));
}));

(cljs.core.async.t_cljs$core$async18303.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18305){
var self__ = this;
var _18305__$1 = this;
return self__.meta18304;
}));

(cljs.core.async.t_cljs$core$async18303.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18303.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async18303.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async18303.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async18303.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta18304","meta18304",-698229056,null)], null);
}));

(cljs.core.async.t_cljs$core$async18303.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18303.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18303");

(cljs.core.async.t_cljs$core$async18303.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write.call(null,writer__4451__auto__,"cljs.core.async/t_cljs$core$async18303");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18303.
 */
cljs.core.async.__GT_t_cljs$core$async18303 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async18303(flag__$1,cb__$1,meta18304){
return (new cljs.core.async.t_cljs$core$async18303(flag__$1,cb__$1,meta18304));
});

}

return (new cljs.core.async.t_cljs$core$async18303(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18306_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18306_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18307_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18307_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4212__auto__ = wport;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return port;
}
})()], null));
} else {
var G__18308 = (i + (1));
i = G__18308;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4212__auto__ = ret;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4210__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___18313 = arguments.length;
var i__4819__auto___18314 = (0);
while(true){
if((i__4819__auto___18314 < len__4818__auto___18313)){
args__4824__auto__.push((arguments[i__4819__auto___18314]));

var G__18315 = (i__4819__auto___18314 + (1));
i__4819__auto___18314 = G__18315;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__18311){
var map__18312 = p__18311;
var map__18312__$1 = cljs.core.__destructure_map.call(null,map__18312);
var opts = map__18312__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq18309){
var G__18310 = cljs.core.first.call(null,seq18309);
var seq18309__$1 = cljs.core.next.call(null,seq18309);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18310,seq18309__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__18317 = arguments.length;
switch (G__18317) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16345__auto___18364 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_18341){
var state_val_18342 = (state_18341[(1)]);
if((state_val_18342 === (7))){
var inst_18337 = (state_18341[(2)]);
var state_18341__$1 = state_18341;
var statearr_18343_18365 = state_18341__$1;
(statearr_18343_18365[(2)] = inst_18337);

(statearr_18343_18365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18342 === (1))){
var state_18341__$1 = state_18341;
var statearr_18344_18366 = state_18341__$1;
(statearr_18344_18366[(2)] = null);

(statearr_18344_18366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18342 === (4))){
var inst_18320 = (state_18341[(7)]);
var inst_18320__$1 = (state_18341[(2)]);
var inst_18321 = (inst_18320__$1 == null);
var state_18341__$1 = (function (){var statearr_18345 = state_18341;
(statearr_18345[(7)] = inst_18320__$1);

return statearr_18345;
})();
if(cljs.core.truth_(inst_18321)){
var statearr_18346_18367 = state_18341__$1;
(statearr_18346_18367[(1)] = (5));

} else {
var statearr_18347_18368 = state_18341__$1;
(statearr_18347_18368[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18342 === (13))){
var state_18341__$1 = state_18341;
var statearr_18348_18369 = state_18341__$1;
(statearr_18348_18369[(2)] = null);

(statearr_18348_18369[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18342 === (6))){
var inst_18320 = (state_18341[(7)]);
var state_18341__$1 = state_18341;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18341__$1,(11),to,inst_18320);
} else {
if((state_val_18342 === (3))){
var inst_18339 = (state_18341[(2)]);
var state_18341__$1 = state_18341;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18341__$1,inst_18339);
} else {
if((state_val_18342 === (12))){
var state_18341__$1 = state_18341;
var statearr_18349_18370 = state_18341__$1;
(statearr_18349_18370[(2)] = null);

(statearr_18349_18370[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18342 === (2))){
var state_18341__$1 = state_18341;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18341__$1,(4),from);
} else {
if((state_val_18342 === (11))){
var inst_18330 = (state_18341[(2)]);
var state_18341__$1 = state_18341;
if(cljs.core.truth_(inst_18330)){
var statearr_18350_18371 = state_18341__$1;
(statearr_18350_18371[(1)] = (12));

} else {
var statearr_18351_18372 = state_18341__$1;
(statearr_18351_18372[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18342 === (9))){
var state_18341__$1 = state_18341;
var statearr_18352_18373 = state_18341__$1;
(statearr_18352_18373[(2)] = null);

(statearr_18352_18373[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18342 === (5))){
var state_18341__$1 = state_18341;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18353_18374 = state_18341__$1;
(statearr_18353_18374[(1)] = (8));

} else {
var statearr_18354_18375 = state_18341__$1;
(statearr_18354_18375[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18342 === (14))){
var inst_18335 = (state_18341[(2)]);
var state_18341__$1 = state_18341;
var statearr_18355_18376 = state_18341__$1;
(statearr_18355_18376[(2)] = inst_18335);

(statearr_18355_18376[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18342 === (10))){
var inst_18327 = (state_18341[(2)]);
var state_18341__$1 = state_18341;
var statearr_18356_18377 = state_18341__$1;
(statearr_18356_18377[(2)] = inst_18327);

(statearr_18356_18377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18342 === (8))){
var inst_18324 = cljs.core.async.close_BANG_.call(null,to);
var state_18341__$1 = state_18341;
var statearr_18357_18378 = state_18341__$1;
(statearr_18357_18378[(2)] = inst_18324);

(statearr_18357_18378[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16221__auto__ = null;
var cljs$core$async$state_machine__16221__auto____0 = (function (){
var statearr_18358 = [null,null,null,null,null,null,null,null];
(statearr_18358[(0)] = cljs$core$async$state_machine__16221__auto__);

(statearr_18358[(1)] = (1));

return statearr_18358;
});
var cljs$core$async$state_machine__16221__auto____1 = (function (state_18341){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_18341);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e18359){var ex__16224__auto__ = e18359;
var statearr_18360_18379 = state_18341;
(statearr_18360_18379[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_18341[(4)]))){
var statearr_18361_18380 = state_18341;
(statearr_18361_18380[(1)] = cljs.core.first.call(null,(state_18341[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18381 = state_18341;
state_18341 = G__18381;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$state_machine__16221__auto__ = function(state_18341){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16221__auto____1.call(this,state_18341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16221__auto____0;
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16221__auto____1;
return cljs$core$async$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_18362 = f__16346__auto__.call(null);
(statearr_18362[(6)] = c__16345__auto___18364);

return statearr_18362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__18382){
var vec__18383 = p__18382;
var v = cljs.core.nth.call(null,vec__18383,(0),null);
var p = cljs.core.nth.call(null,vec__18383,(1),null);
var job = vec__18383;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__16345__auto___18559 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_18390){
var state_val_18391 = (state_18390[(1)]);
if((state_val_18391 === (1))){
var state_18390__$1 = state_18390;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18390__$1,(2),res,v);
} else {
if((state_val_18391 === (2))){
var inst_18387 = (state_18390[(2)]);
var inst_18388 = cljs.core.async.close_BANG_.call(null,res);
var state_18390__$1 = (function (){var statearr_18392 = state_18390;
(statearr_18392[(7)] = inst_18387);

return statearr_18392;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18390__$1,inst_18388);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0 = (function (){
var statearr_18393 = [null,null,null,null,null,null,null,null];
(statearr_18393[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__);

(statearr_18393[(1)] = (1));

return statearr_18393;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1 = (function (state_18390){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_18390);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e18394){var ex__16224__auto__ = e18394;
var statearr_18395_18560 = state_18390;
(statearr_18395_18560[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_18390[(4)]))){
var statearr_18396_18561 = state_18390;
(statearr_18396_18561[(1)] = cljs.core.first.call(null,(state_18390[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18562 = state_18390;
state_18390 = G__18562;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__ = function(state_18390){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1.call(this,state_18390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_18397 = f__16346__auto__.call(null);
(statearr_18397[(6)] = c__16345__auto___18559);

return statearr_18397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__18398){
var vec__18399 = p__18398;
var v = cljs.core.nth.call(null,vec__18399,(0),null);
var p = cljs.core.nth.call(null,vec__18399,(1),null);
var job = vec__18399;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4695__auto___18563 = n;
var __18564 = (0);
while(true){
if((__18564 < n__4695__auto___18563)){
var G__18402_18565 = type;
var G__18402_18566__$1 = (((G__18402_18565 instanceof cljs.core.Keyword))?G__18402_18565.fqn:null);
switch (G__18402_18566__$1) {
case "compute":
var c__16345__auto___18568 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18564,c__16345__auto___18568,G__18402_18565,G__18402_18566__$1,n__4695__auto___18563,jobs,results,process,async){
return (function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = ((function (__18564,c__16345__auto___18568,G__18402_18565,G__18402_18566__$1,n__4695__auto___18563,jobs,results,process,async){
return (function (state_18415){
var state_val_18416 = (state_18415[(1)]);
if((state_val_18416 === (1))){
var state_18415__$1 = state_18415;
var statearr_18417_18569 = state_18415__$1;
(statearr_18417_18569[(2)] = null);

(statearr_18417_18569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18416 === (2))){
var state_18415__$1 = state_18415;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18415__$1,(4),jobs);
} else {
if((state_val_18416 === (3))){
var inst_18413 = (state_18415[(2)]);
var state_18415__$1 = state_18415;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18415__$1,inst_18413);
} else {
if((state_val_18416 === (4))){
var inst_18405 = (state_18415[(2)]);
var inst_18406 = process.call(null,inst_18405);
var state_18415__$1 = state_18415;
if(cljs.core.truth_(inst_18406)){
var statearr_18418_18570 = state_18415__$1;
(statearr_18418_18570[(1)] = (5));

} else {
var statearr_18419_18571 = state_18415__$1;
(statearr_18419_18571[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18416 === (5))){
var state_18415__$1 = state_18415;
var statearr_18420_18572 = state_18415__$1;
(statearr_18420_18572[(2)] = null);

(statearr_18420_18572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18416 === (6))){
var state_18415__$1 = state_18415;
var statearr_18421_18573 = state_18415__$1;
(statearr_18421_18573[(2)] = null);

(statearr_18421_18573[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18416 === (7))){
var inst_18411 = (state_18415[(2)]);
var state_18415__$1 = state_18415;
var statearr_18422_18574 = state_18415__$1;
(statearr_18422_18574[(2)] = inst_18411);

(statearr_18422_18574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18564,c__16345__auto___18568,G__18402_18565,G__18402_18566__$1,n__4695__auto___18563,jobs,results,process,async))
;
return ((function (__18564,switch__16220__auto__,c__16345__auto___18568,G__18402_18565,G__18402_18566__$1,n__4695__auto___18563,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0 = (function (){
var statearr_18423 = [null,null,null,null,null,null,null];
(statearr_18423[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__);

(statearr_18423[(1)] = (1));

return statearr_18423;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1 = (function (state_18415){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_18415);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e18424){var ex__16224__auto__ = e18424;
var statearr_18425_18575 = state_18415;
(statearr_18425_18575[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_18415[(4)]))){
var statearr_18426_18576 = state_18415;
(statearr_18426_18576[(1)] = cljs.core.first.call(null,(state_18415[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18577 = state_18415;
state_18415 = G__18577;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__ = function(state_18415){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1.call(this,state_18415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__;
})()
;})(__18564,switch__16220__auto__,c__16345__auto___18568,G__18402_18565,G__18402_18566__$1,n__4695__auto___18563,jobs,results,process,async))
})();
var state__16347__auto__ = (function (){var statearr_18427 = f__16346__auto__.call(null);
(statearr_18427[(6)] = c__16345__auto___18568);

return statearr_18427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
});})(__18564,c__16345__auto___18568,G__18402_18565,G__18402_18566__$1,n__4695__auto___18563,jobs,results,process,async))
);


break;
case "async":
var c__16345__auto___18578 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18564,c__16345__auto___18578,G__18402_18565,G__18402_18566__$1,n__4695__auto___18563,jobs,results,process,async){
return (function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = ((function (__18564,c__16345__auto___18578,G__18402_18565,G__18402_18566__$1,n__4695__auto___18563,jobs,results,process,async){
return (function (state_18440){
var state_val_18441 = (state_18440[(1)]);
if((state_val_18441 === (1))){
var state_18440__$1 = state_18440;
var statearr_18442_18579 = state_18440__$1;
(statearr_18442_18579[(2)] = null);

(statearr_18442_18579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18441 === (2))){
var state_18440__$1 = state_18440;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18440__$1,(4),jobs);
} else {
if((state_val_18441 === (3))){
var inst_18438 = (state_18440[(2)]);
var state_18440__$1 = state_18440;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18440__$1,inst_18438);
} else {
if((state_val_18441 === (4))){
var inst_18430 = (state_18440[(2)]);
var inst_18431 = async.call(null,inst_18430);
var state_18440__$1 = state_18440;
if(cljs.core.truth_(inst_18431)){
var statearr_18443_18580 = state_18440__$1;
(statearr_18443_18580[(1)] = (5));

} else {
var statearr_18444_18581 = state_18440__$1;
(statearr_18444_18581[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18441 === (5))){
var state_18440__$1 = state_18440;
var statearr_18445_18582 = state_18440__$1;
(statearr_18445_18582[(2)] = null);

(statearr_18445_18582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18441 === (6))){
var state_18440__$1 = state_18440;
var statearr_18446_18583 = state_18440__$1;
(statearr_18446_18583[(2)] = null);

(statearr_18446_18583[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18441 === (7))){
var inst_18436 = (state_18440[(2)]);
var state_18440__$1 = state_18440;
var statearr_18447_18584 = state_18440__$1;
(statearr_18447_18584[(2)] = inst_18436);

(statearr_18447_18584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18564,c__16345__auto___18578,G__18402_18565,G__18402_18566__$1,n__4695__auto___18563,jobs,results,process,async))
;
return ((function (__18564,switch__16220__auto__,c__16345__auto___18578,G__18402_18565,G__18402_18566__$1,n__4695__auto___18563,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0 = (function (){
var statearr_18448 = [null,null,null,null,null,null,null];
(statearr_18448[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__);

(statearr_18448[(1)] = (1));

return statearr_18448;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1 = (function (state_18440){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_18440);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e18449){var ex__16224__auto__ = e18449;
var statearr_18450_18585 = state_18440;
(statearr_18450_18585[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_18440[(4)]))){
var statearr_18451_18586 = state_18440;
(statearr_18451_18586[(1)] = cljs.core.first.call(null,(state_18440[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18587 = state_18440;
state_18440 = G__18587;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__ = function(state_18440){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1.call(this,state_18440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__;
})()
;})(__18564,switch__16220__auto__,c__16345__auto___18578,G__18402_18565,G__18402_18566__$1,n__4695__auto___18563,jobs,results,process,async))
})();
var state__16347__auto__ = (function (){var statearr_18452 = f__16346__auto__.call(null);
(statearr_18452[(6)] = c__16345__auto___18578);

return statearr_18452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
});})(__18564,c__16345__auto___18578,G__18402_18565,G__18402_18566__$1,n__4695__auto___18563,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18402_18566__$1)].join('')));

}

var G__18588 = (__18564 + (1));
__18564 = G__18588;
continue;
} else {
}
break;
}

var c__16345__auto___18589 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_18474){
var state_val_18475 = (state_18474[(1)]);
if((state_val_18475 === (7))){
var inst_18470 = (state_18474[(2)]);
var state_18474__$1 = state_18474;
var statearr_18476_18590 = state_18474__$1;
(statearr_18476_18590[(2)] = inst_18470);

(statearr_18476_18590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (1))){
var state_18474__$1 = state_18474;
var statearr_18477_18591 = state_18474__$1;
(statearr_18477_18591[(2)] = null);

(statearr_18477_18591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (4))){
var inst_18455 = (state_18474[(7)]);
var inst_18455__$1 = (state_18474[(2)]);
var inst_18456 = (inst_18455__$1 == null);
var state_18474__$1 = (function (){var statearr_18478 = state_18474;
(statearr_18478[(7)] = inst_18455__$1);

return statearr_18478;
})();
if(cljs.core.truth_(inst_18456)){
var statearr_18479_18592 = state_18474__$1;
(statearr_18479_18592[(1)] = (5));

} else {
var statearr_18480_18593 = state_18474__$1;
(statearr_18480_18593[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (6))){
var inst_18455 = (state_18474[(7)]);
var inst_18460 = (state_18474[(8)]);
var inst_18460__$1 = cljs.core.async.chan.call(null,(1));
var inst_18461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18462 = [inst_18455,inst_18460__$1];
var inst_18463 = (new cljs.core.PersistentVector(null,2,(5),inst_18461,inst_18462,null));
var state_18474__$1 = (function (){var statearr_18481 = state_18474;
(statearr_18481[(8)] = inst_18460__$1);

return statearr_18481;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18474__$1,(8),jobs,inst_18463);
} else {
if((state_val_18475 === (3))){
var inst_18472 = (state_18474[(2)]);
var state_18474__$1 = state_18474;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18474__$1,inst_18472);
} else {
if((state_val_18475 === (2))){
var state_18474__$1 = state_18474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18474__$1,(4),from);
} else {
if((state_val_18475 === (9))){
var inst_18467 = (state_18474[(2)]);
var state_18474__$1 = (function (){var statearr_18482 = state_18474;
(statearr_18482[(9)] = inst_18467);

return statearr_18482;
})();
var statearr_18483_18594 = state_18474__$1;
(statearr_18483_18594[(2)] = null);

(statearr_18483_18594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (5))){
var inst_18458 = cljs.core.async.close_BANG_.call(null,jobs);
var state_18474__$1 = state_18474;
var statearr_18484_18595 = state_18474__$1;
(statearr_18484_18595[(2)] = inst_18458);

(statearr_18484_18595[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (8))){
var inst_18460 = (state_18474[(8)]);
var inst_18465 = (state_18474[(2)]);
var state_18474__$1 = (function (){var statearr_18485 = state_18474;
(statearr_18485[(10)] = inst_18465);

return statearr_18485;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18474__$1,(9),results,inst_18460);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0 = (function (){
var statearr_18486 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18486[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__);

(statearr_18486[(1)] = (1));

return statearr_18486;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1 = (function (state_18474){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_18474);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e18487){var ex__16224__auto__ = e18487;
var statearr_18488_18596 = state_18474;
(statearr_18488_18596[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_18474[(4)]))){
var statearr_18489_18597 = state_18474;
(statearr_18489_18597[(1)] = cljs.core.first.call(null,(state_18474[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18598 = state_18474;
state_18474 = G__18598;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__ = function(state_18474){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1.call(this,state_18474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_18490 = f__16346__auto__.call(null);
(statearr_18490[(6)] = c__16345__auto___18589);

return statearr_18490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_18528){
var state_val_18529 = (state_18528[(1)]);
if((state_val_18529 === (7))){
var inst_18524 = (state_18528[(2)]);
var state_18528__$1 = state_18528;
var statearr_18530_18599 = state_18528__$1;
(statearr_18530_18599[(2)] = inst_18524);

(statearr_18530_18599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (20))){
var state_18528__$1 = state_18528;
var statearr_18531_18600 = state_18528__$1;
(statearr_18531_18600[(2)] = null);

(statearr_18531_18600[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (1))){
var state_18528__$1 = state_18528;
var statearr_18532_18601 = state_18528__$1;
(statearr_18532_18601[(2)] = null);

(statearr_18532_18601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (4))){
var inst_18493 = (state_18528[(7)]);
var inst_18493__$1 = (state_18528[(2)]);
var inst_18494 = (inst_18493__$1 == null);
var state_18528__$1 = (function (){var statearr_18533 = state_18528;
(statearr_18533[(7)] = inst_18493__$1);

return statearr_18533;
})();
if(cljs.core.truth_(inst_18494)){
var statearr_18534_18602 = state_18528__$1;
(statearr_18534_18602[(1)] = (5));

} else {
var statearr_18535_18603 = state_18528__$1;
(statearr_18535_18603[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (15))){
var inst_18506 = (state_18528[(8)]);
var state_18528__$1 = state_18528;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18528__$1,(18),to,inst_18506);
} else {
if((state_val_18529 === (21))){
var inst_18519 = (state_18528[(2)]);
var state_18528__$1 = state_18528;
var statearr_18536_18604 = state_18528__$1;
(statearr_18536_18604[(2)] = inst_18519);

(statearr_18536_18604[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (13))){
var inst_18521 = (state_18528[(2)]);
var state_18528__$1 = (function (){var statearr_18537 = state_18528;
(statearr_18537[(9)] = inst_18521);

return statearr_18537;
})();
var statearr_18538_18605 = state_18528__$1;
(statearr_18538_18605[(2)] = null);

(statearr_18538_18605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (6))){
var inst_18493 = (state_18528[(7)]);
var state_18528__$1 = state_18528;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18528__$1,(11),inst_18493);
} else {
if((state_val_18529 === (17))){
var inst_18514 = (state_18528[(2)]);
var state_18528__$1 = state_18528;
if(cljs.core.truth_(inst_18514)){
var statearr_18539_18606 = state_18528__$1;
(statearr_18539_18606[(1)] = (19));

} else {
var statearr_18540_18607 = state_18528__$1;
(statearr_18540_18607[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (3))){
var inst_18526 = (state_18528[(2)]);
var state_18528__$1 = state_18528;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18528__$1,inst_18526);
} else {
if((state_val_18529 === (12))){
var inst_18503 = (state_18528[(10)]);
var state_18528__$1 = state_18528;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18528__$1,(14),inst_18503);
} else {
if((state_val_18529 === (2))){
var state_18528__$1 = state_18528;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18528__$1,(4),results);
} else {
if((state_val_18529 === (19))){
var state_18528__$1 = state_18528;
var statearr_18541_18608 = state_18528__$1;
(statearr_18541_18608[(2)] = null);

(statearr_18541_18608[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (11))){
var inst_18503 = (state_18528[(2)]);
var state_18528__$1 = (function (){var statearr_18542 = state_18528;
(statearr_18542[(10)] = inst_18503);

return statearr_18542;
})();
var statearr_18543_18609 = state_18528__$1;
(statearr_18543_18609[(2)] = null);

(statearr_18543_18609[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (9))){
var state_18528__$1 = state_18528;
var statearr_18544_18610 = state_18528__$1;
(statearr_18544_18610[(2)] = null);

(statearr_18544_18610[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (5))){
var state_18528__$1 = state_18528;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18545_18611 = state_18528__$1;
(statearr_18545_18611[(1)] = (8));

} else {
var statearr_18546_18612 = state_18528__$1;
(statearr_18546_18612[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (14))){
var inst_18506 = (state_18528[(8)]);
var inst_18508 = (state_18528[(11)]);
var inst_18506__$1 = (state_18528[(2)]);
var inst_18507 = (inst_18506__$1 == null);
var inst_18508__$1 = cljs.core.not.call(null,inst_18507);
var state_18528__$1 = (function (){var statearr_18547 = state_18528;
(statearr_18547[(8)] = inst_18506__$1);

(statearr_18547[(11)] = inst_18508__$1);

return statearr_18547;
})();
if(inst_18508__$1){
var statearr_18548_18613 = state_18528__$1;
(statearr_18548_18613[(1)] = (15));

} else {
var statearr_18549_18614 = state_18528__$1;
(statearr_18549_18614[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (16))){
var inst_18508 = (state_18528[(11)]);
var state_18528__$1 = state_18528;
var statearr_18550_18615 = state_18528__$1;
(statearr_18550_18615[(2)] = inst_18508);

(statearr_18550_18615[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (10))){
var inst_18500 = (state_18528[(2)]);
var state_18528__$1 = state_18528;
var statearr_18551_18616 = state_18528__$1;
(statearr_18551_18616[(2)] = inst_18500);

(statearr_18551_18616[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (18))){
var inst_18511 = (state_18528[(2)]);
var state_18528__$1 = state_18528;
var statearr_18552_18617 = state_18528__$1;
(statearr_18552_18617[(2)] = inst_18511);

(statearr_18552_18617[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18529 === (8))){
var inst_18497 = cljs.core.async.close_BANG_.call(null,to);
var state_18528__$1 = state_18528;
var statearr_18553_18618 = state_18528__$1;
(statearr_18553_18618[(2)] = inst_18497);

(statearr_18553_18618[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0 = (function (){
var statearr_18554 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18554[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__);

(statearr_18554[(1)] = (1));

return statearr_18554;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1 = (function (state_18528){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_18528);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e18555){var ex__16224__auto__ = e18555;
var statearr_18556_18619 = state_18528;
(statearr_18556_18619[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_18528[(4)]))){
var statearr_18557_18620 = state_18528;
(statearr_18557_18620[(1)] = cljs.core.first.call(null,(state_18528[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18621 = state_18528;
state_18528 = G__18621;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__ = function(state_18528){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1.call(this,state_18528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16221__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_18558 = f__16346__auto__.call(null);
(statearr_18558[(6)] = c__16345__auto__);

return statearr_18558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__18623 = arguments.length;
switch (G__18623) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__18626 = arguments.length;
switch (G__18626) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__18629 = arguments.length;
switch (G__18629) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__16345__auto___18679 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_18655){
var state_val_18656 = (state_18655[(1)]);
if((state_val_18656 === (7))){
var inst_18651 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
var statearr_18657_18680 = state_18655__$1;
(statearr_18657_18680[(2)] = inst_18651);

(statearr_18657_18680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (1))){
var state_18655__$1 = state_18655;
var statearr_18658_18681 = state_18655__$1;
(statearr_18658_18681[(2)] = null);

(statearr_18658_18681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (4))){
var inst_18632 = (state_18655[(7)]);
var inst_18632__$1 = (state_18655[(2)]);
var inst_18633 = (inst_18632__$1 == null);
var state_18655__$1 = (function (){var statearr_18659 = state_18655;
(statearr_18659[(7)] = inst_18632__$1);

return statearr_18659;
})();
if(cljs.core.truth_(inst_18633)){
var statearr_18660_18682 = state_18655__$1;
(statearr_18660_18682[(1)] = (5));

} else {
var statearr_18661_18683 = state_18655__$1;
(statearr_18661_18683[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (13))){
var state_18655__$1 = state_18655;
var statearr_18662_18684 = state_18655__$1;
(statearr_18662_18684[(2)] = null);

(statearr_18662_18684[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (6))){
var inst_18632 = (state_18655[(7)]);
var inst_18638 = p.call(null,inst_18632);
var state_18655__$1 = state_18655;
if(cljs.core.truth_(inst_18638)){
var statearr_18663_18685 = state_18655__$1;
(statearr_18663_18685[(1)] = (9));

} else {
var statearr_18664_18686 = state_18655__$1;
(statearr_18664_18686[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (3))){
var inst_18653 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18655__$1,inst_18653);
} else {
if((state_val_18656 === (12))){
var state_18655__$1 = state_18655;
var statearr_18665_18687 = state_18655__$1;
(statearr_18665_18687[(2)] = null);

(statearr_18665_18687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (2))){
var state_18655__$1 = state_18655;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18655__$1,(4),ch);
} else {
if((state_val_18656 === (11))){
var inst_18632 = (state_18655[(7)]);
var inst_18642 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18655__$1,(8),inst_18642,inst_18632);
} else {
if((state_val_18656 === (9))){
var state_18655__$1 = state_18655;
var statearr_18666_18688 = state_18655__$1;
(statearr_18666_18688[(2)] = tc);

(statearr_18666_18688[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (5))){
var inst_18635 = cljs.core.async.close_BANG_.call(null,tc);
var inst_18636 = cljs.core.async.close_BANG_.call(null,fc);
var state_18655__$1 = (function (){var statearr_18667 = state_18655;
(statearr_18667[(8)] = inst_18635);

return statearr_18667;
})();
var statearr_18668_18689 = state_18655__$1;
(statearr_18668_18689[(2)] = inst_18636);

(statearr_18668_18689[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (14))){
var inst_18649 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
var statearr_18669_18690 = state_18655__$1;
(statearr_18669_18690[(2)] = inst_18649);

(statearr_18669_18690[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (10))){
var state_18655__$1 = state_18655;
var statearr_18670_18691 = state_18655__$1;
(statearr_18670_18691[(2)] = fc);

(statearr_18670_18691[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18656 === (8))){
var inst_18644 = (state_18655[(2)]);
var state_18655__$1 = state_18655;
if(cljs.core.truth_(inst_18644)){
var statearr_18671_18692 = state_18655__$1;
(statearr_18671_18692[(1)] = (12));

} else {
var statearr_18672_18693 = state_18655__$1;
(statearr_18672_18693[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16221__auto__ = null;
var cljs$core$async$state_machine__16221__auto____0 = (function (){
var statearr_18673 = [null,null,null,null,null,null,null,null,null];
(statearr_18673[(0)] = cljs$core$async$state_machine__16221__auto__);

(statearr_18673[(1)] = (1));

return statearr_18673;
});
var cljs$core$async$state_machine__16221__auto____1 = (function (state_18655){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_18655);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e18674){var ex__16224__auto__ = e18674;
var statearr_18675_18694 = state_18655;
(statearr_18675_18694[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_18655[(4)]))){
var statearr_18676_18695 = state_18655;
(statearr_18676_18695[(1)] = cljs.core.first.call(null,(state_18655[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18696 = state_18655;
state_18655 = G__18696;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$state_machine__16221__auto__ = function(state_18655){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16221__auto____1.call(this,state_18655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16221__auto____0;
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16221__auto____1;
return cljs$core$async$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_18677 = f__16346__auto__.call(null);
(statearr_18677[(6)] = c__16345__auto___18679);

return statearr_18677;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_18718){
var state_val_18719 = (state_18718[(1)]);
if((state_val_18719 === (7))){
var inst_18714 = (state_18718[(2)]);
var state_18718__$1 = state_18718;
var statearr_18720_18739 = state_18718__$1;
(statearr_18720_18739[(2)] = inst_18714);

(statearr_18720_18739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18719 === (1))){
var inst_18697 = init;
var inst_18698 = inst_18697;
var state_18718__$1 = (function (){var statearr_18721 = state_18718;
(statearr_18721[(7)] = inst_18698);

return statearr_18721;
})();
var statearr_18722_18740 = state_18718__$1;
(statearr_18722_18740[(2)] = null);

(statearr_18722_18740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18719 === (4))){
var inst_18701 = (state_18718[(8)]);
var inst_18701__$1 = (state_18718[(2)]);
var inst_18702 = (inst_18701__$1 == null);
var state_18718__$1 = (function (){var statearr_18723 = state_18718;
(statearr_18723[(8)] = inst_18701__$1);

return statearr_18723;
})();
if(cljs.core.truth_(inst_18702)){
var statearr_18724_18741 = state_18718__$1;
(statearr_18724_18741[(1)] = (5));

} else {
var statearr_18725_18742 = state_18718__$1;
(statearr_18725_18742[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18719 === (6))){
var inst_18701 = (state_18718[(8)]);
var inst_18698 = (state_18718[(7)]);
var inst_18705 = (state_18718[(9)]);
var inst_18705__$1 = f.call(null,inst_18698,inst_18701);
var inst_18706 = cljs.core.reduced_QMARK_.call(null,inst_18705__$1);
var state_18718__$1 = (function (){var statearr_18726 = state_18718;
(statearr_18726[(9)] = inst_18705__$1);

return statearr_18726;
})();
if(inst_18706){
var statearr_18727_18743 = state_18718__$1;
(statearr_18727_18743[(1)] = (8));

} else {
var statearr_18728_18744 = state_18718__$1;
(statearr_18728_18744[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18719 === (3))){
var inst_18716 = (state_18718[(2)]);
var state_18718__$1 = state_18718;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18718__$1,inst_18716);
} else {
if((state_val_18719 === (2))){
var state_18718__$1 = state_18718;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18718__$1,(4),ch);
} else {
if((state_val_18719 === (9))){
var inst_18705 = (state_18718[(9)]);
var inst_18698 = inst_18705;
var state_18718__$1 = (function (){var statearr_18729 = state_18718;
(statearr_18729[(7)] = inst_18698);

return statearr_18729;
})();
var statearr_18730_18745 = state_18718__$1;
(statearr_18730_18745[(2)] = null);

(statearr_18730_18745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18719 === (5))){
var inst_18698 = (state_18718[(7)]);
var state_18718__$1 = state_18718;
var statearr_18731_18746 = state_18718__$1;
(statearr_18731_18746[(2)] = inst_18698);

(statearr_18731_18746[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18719 === (10))){
var inst_18712 = (state_18718[(2)]);
var state_18718__$1 = state_18718;
var statearr_18732_18747 = state_18718__$1;
(statearr_18732_18747[(2)] = inst_18712);

(statearr_18732_18747[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18719 === (8))){
var inst_18705 = (state_18718[(9)]);
var inst_18708 = cljs.core.deref.call(null,inst_18705);
var state_18718__$1 = state_18718;
var statearr_18733_18748 = state_18718__$1;
(statearr_18733_18748[(2)] = inst_18708);

(statearr_18733_18748[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__16221__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16221__auto____0 = (function (){
var statearr_18734 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18734[(0)] = cljs$core$async$reduce_$_state_machine__16221__auto__);

(statearr_18734[(1)] = (1));

return statearr_18734;
});
var cljs$core$async$reduce_$_state_machine__16221__auto____1 = (function (state_18718){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_18718);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e18735){var ex__16224__auto__ = e18735;
var statearr_18736_18749 = state_18718;
(statearr_18736_18749[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_18718[(4)]))){
var statearr_18737_18750 = state_18718;
(statearr_18737_18750[(1)] = cljs.core.first.call(null,(state_18718[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18751 = state_18718;
state_18718 = G__18751;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16221__auto__ = function(state_18718){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16221__auto____1.call(this,state_18718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16221__auto____0;
cljs$core$async$reduce_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16221__auto____1;
return cljs$core$async$reduce_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_18738 = f__16346__auto__.call(null);
(statearr_18738[(6)] = c__16345__auto__);

return statearr_18738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_18757){
var state_val_18758 = (state_18757[(1)]);
if((state_val_18758 === (1))){
var inst_18752 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_18757__$1 = state_18757;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18757__$1,(2),inst_18752);
} else {
if((state_val_18758 === (2))){
var inst_18754 = (state_18757[(2)]);
var inst_18755 = f__$1.call(null,inst_18754);
var state_18757__$1 = state_18757;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18757__$1,inst_18755);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__16221__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16221__auto____0 = (function (){
var statearr_18759 = [null,null,null,null,null,null,null];
(statearr_18759[(0)] = cljs$core$async$transduce_$_state_machine__16221__auto__);

(statearr_18759[(1)] = (1));

return statearr_18759;
});
var cljs$core$async$transduce_$_state_machine__16221__auto____1 = (function (state_18757){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_18757);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e18760){var ex__16224__auto__ = e18760;
var statearr_18761_18764 = state_18757;
(statearr_18761_18764[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_18757[(4)]))){
var statearr_18762_18765 = state_18757;
(statearr_18762_18765[(1)] = cljs.core.first.call(null,(state_18757[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18766 = state_18757;
state_18757 = G__18766;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16221__auto__ = function(state_18757){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16221__auto____1.call(this,state_18757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16221__auto____0;
cljs$core$async$transduce_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16221__auto____1;
return cljs$core$async$transduce_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_18763 = f__16346__auto__.call(null);
(statearr_18763[(6)] = c__16345__auto__);

return statearr_18763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__18768 = arguments.length;
switch (G__18768) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_18793){
var state_val_18794 = (state_18793[(1)]);
if((state_val_18794 === (7))){
var inst_18775 = (state_18793[(2)]);
var state_18793__$1 = state_18793;
var statearr_18795_18817 = state_18793__$1;
(statearr_18795_18817[(2)] = inst_18775);

(statearr_18795_18817[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (1))){
var inst_18769 = cljs.core.seq.call(null,coll);
var inst_18770 = inst_18769;
var state_18793__$1 = (function (){var statearr_18796 = state_18793;
(statearr_18796[(7)] = inst_18770);

return statearr_18796;
})();
var statearr_18797_18818 = state_18793__$1;
(statearr_18797_18818[(2)] = null);

(statearr_18797_18818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (4))){
var inst_18770 = (state_18793[(7)]);
var inst_18773 = cljs.core.first.call(null,inst_18770);
var state_18793__$1 = state_18793;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18793__$1,(7),ch,inst_18773);
} else {
if((state_val_18794 === (13))){
var inst_18787 = (state_18793[(2)]);
var state_18793__$1 = state_18793;
var statearr_18798_18819 = state_18793__$1;
(statearr_18798_18819[(2)] = inst_18787);

(statearr_18798_18819[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (6))){
var inst_18778 = (state_18793[(2)]);
var state_18793__$1 = state_18793;
if(cljs.core.truth_(inst_18778)){
var statearr_18799_18820 = state_18793__$1;
(statearr_18799_18820[(1)] = (8));

} else {
var statearr_18800_18821 = state_18793__$1;
(statearr_18800_18821[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (3))){
var inst_18791 = (state_18793[(2)]);
var state_18793__$1 = state_18793;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18793__$1,inst_18791);
} else {
if((state_val_18794 === (12))){
var state_18793__$1 = state_18793;
var statearr_18801_18822 = state_18793__$1;
(statearr_18801_18822[(2)] = null);

(statearr_18801_18822[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (2))){
var inst_18770 = (state_18793[(7)]);
var state_18793__$1 = state_18793;
if(cljs.core.truth_(inst_18770)){
var statearr_18802_18823 = state_18793__$1;
(statearr_18802_18823[(1)] = (4));

} else {
var statearr_18803_18824 = state_18793__$1;
(statearr_18803_18824[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (11))){
var inst_18784 = cljs.core.async.close_BANG_.call(null,ch);
var state_18793__$1 = state_18793;
var statearr_18804_18825 = state_18793__$1;
(statearr_18804_18825[(2)] = inst_18784);

(statearr_18804_18825[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (9))){
var state_18793__$1 = state_18793;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18805_18826 = state_18793__$1;
(statearr_18805_18826[(1)] = (11));

} else {
var statearr_18806_18827 = state_18793__$1;
(statearr_18806_18827[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (5))){
var inst_18770 = (state_18793[(7)]);
var state_18793__$1 = state_18793;
var statearr_18807_18828 = state_18793__$1;
(statearr_18807_18828[(2)] = inst_18770);

(statearr_18807_18828[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (10))){
var inst_18789 = (state_18793[(2)]);
var state_18793__$1 = state_18793;
var statearr_18808_18829 = state_18793__$1;
(statearr_18808_18829[(2)] = inst_18789);

(statearr_18808_18829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (8))){
var inst_18770 = (state_18793[(7)]);
var inst_18780 = cljs.core.next.call(null,inst_18770);
var inst_18770__$1 = inst_18780;
var state_18793__$1 = (function (){var statearr_18809 = state_18793;
(statearr_18809[(7)] = inst_18770__$1);

return statearr_18809;
})();
var statearr_18810_18830 = state_18793__$1;
(statearr_18810_18830[(2)] = null);

(statearr_18810_18830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16221__auto__ = null;
var cljs$core$async$state_machine__16221__auto____0 = (function (){
var statearr_18811 = [null,null,null,null,null,null,null,null];
(statearr_18811[(0)] = cljs$core$async$state_machine__16221__auto__);

(statearr_18811[(1)] = (1));

return statearr_18811;
});
var cljs$core$async$state_machine__16221__auto____1 = (function (state_18793){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_18793);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e18812){var ex__16224__auto__ = e18812;
var statearr_18813_18831 = state_18793;
(statearr_18813_18831[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_18793[(4)]))){
var statearr_18814_18832 = state_18793;
(statearr_18814_18832[(1)] = cljs.core.first.call(null,(state_18793[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18833 = state_18793;
state_18793 = G__18833;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$state_machine__16221__auto__ = function(state_18793){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16221__auto____1.call(this,state_18793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16221__auto____0;
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16221__auto____1;
return cljs$core$async$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_18815 = f__16346__auto__.call(null);
(statearr_18815[(6)] = c__16345__auto__);

return statearr_18815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__18835 = arguments.length;
switch (G__18835) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_18837 = (function (_){
var x__4509__auto__ = (((_ == null))?null:_);
var m__4510__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,_);
} else {
var m__4508__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_18837.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_18838 = (function (m,ch,close_QMARK_){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4508__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_18838.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_18839 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,m,ch);
} else {
var m__4508__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_18839.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_18840 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,m);
} else {
var m__4508__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_18840.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18841 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18841 = (function (ch,cs,meta18842){
this.ch = ch;
this.cs = cs;
this.meta18842 = meta18842;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18841.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18843,meta18842__$1){
var self__ = this;
var _18843__$1 = this;
return (new cljs.core.async.t_cljs$core$async18841(self__.ch,self__.cs,meta18842__$1));
}));

(cljs.core.async.t_cljs$core$async18841.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18843){
var self__ = this;
var _18843__$1 = this;
return self__.meta18842;
}));

(cljs.core.async.t_cljs$core$async18841.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18841.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async18841.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18841.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async18841.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async18841.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async18841.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18842","meta18842",426521762,null)], null);
}));

(cljs.core.async.t_cljs$core$async18841.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18841.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18841");

(cljs.core.async.t_cljs$core$async18841.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write.call(null,writer__4451__auto__,"cljs.core.async/t_cljs$core$async18841");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18841.
 */
cljs.core.async.__GT_t_cljs$core$async18841 = (function cljs$core$async$mult_$___GT_t_cljs$core$async18841(ch__$1,cs__$1,meta18842){
return (new cljs.core.async.t_cljs$core$async18841(ch__$1,cs__$1,meta18842));
});

}

return (new cljs.core.async.t_cljs$core$async18841(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__16345__auto___19060 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_18976){
var state_val_18977 = (state_18976[(1)]);
if((state_val_18977 === (7))){
var inst_18972 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
var statearr_18978_19061 = state_18976__$1;
(statearr_18978_19061[(2)] = inst_18972);

(statearr_18978_19061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (20))){
var inst_18877 = (state_18976[(7)]);
var inst_18889 = cljs.core.first.call(null,inst_18877);
var inst_18890 = cljs.core.nth.call(null,inst_18889,(0),null);
var inst_18891 = cljs.core.nth.call(null,inst_18889,(1),null);
var state_18976__$1 = (function (){var statearr_18979 = state_18976;
(statearr_18979[(8)] = inst_18890);

return statearr_18979;
})();
if(cljs.core.truth_(inst_18891)){
var statearr_18980_19062 = state_18976__$1;
(statearr_18980_19062[(1)] = (22));

} else {
var statearr_18981_19063 = state_18976__$1;
(statearr_18981_19063[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (27))){
var inst_18926 = (state_18976[(9)]);
var inst_18846 = (state_18976[(10)]);
var inst_18919 = (state_18976[(11)]);
var inst_18921 = (state_18976[(12)]);
var inst_18926__$1 = cljs.core._nth.call(null,inst_18919,inst_18921);
var inst_18927 = cljs.core.async.put_BANG_.call(null,inst_18926__$1,inst_18846,done);
var state_18976__$1 = (function (){var statearr_18982 = state_18976;
(statearr_18982[(9)] = inst_18926__$1);

return statearr_18982;
})();
if(cljs.core.truth_(inst_18927)){
var statearr_18983_19064 = state_18976__$1;
(statearr_18983_19064[(1)] = (30));

} else {
var statearr_18984_19065 = state_18976__$1;
(statearr_18984_19065[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (1))){
var state_18976__$1 = state_18976;
var statearr_18985_19066 = state_18976__$1;
(statearr_18985_19066[(2)] = null);

(statearr_18985_19066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (24))){
var inst_18877 = (state_18976[(7)]);
var inst_18896 = (state_18976[(2)]);
var inst_18897 = cljs.core.next.call(null,inst_18877);
var inst_18855 = inst_18897;
var inst_18856 = null;
var inst_18857 = (0);
var inst_18858 = (0);
var state_18976__$1 = (function (){var statearr_18986 = state_18976;
(statearr_18986[(13)] = inst_18858);

(statearr_18986[(14)] = inst_18857);

(statearr_18986[(15)] = inst_18856);

(statearr_18986[(16)] = inst_18896);

(statearr_18986[(17)] = inst_18855);

return statearr_18986;
})();
var statearr_18987_19067 = state_18976__$1;
(statearr_18987_19067[(2)] = null);

(statearr_18987_19067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (39))){
var state_18976__$1 = state_18976;
var statearr_18991_19068 = state_18976__$1;
(statearr_18991_19068[(2)] = null);

(statearr_18991_19068[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (4))){
var inst_18846 = (state_18976[(10)]);
var inst_18846__$1 = (state_18976[(2)]);
var inst_18847 = (inst_18846__$1 == null);
var state_18976__$1 = (function (){var statearr_18992 = state_18976;
(statearr_18992[(10)] = inst_18846__$1);

return statearr_18992;
})();
if(cljs.core.truth_(inst_18847)){
var statearr_18993_19069 = state_18976__$1;
(statearr_18993_19069[(1)] = (5));

} else {
var statearr_18994_19070 = state_18976__$1;
(statearr_18994_19070[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (15))){
var inst_18858 = (state_18976[(13)]);
var inst_18857 = (state_18976[(14)]);
var inst_18856 = (state_18976[(15)]);
var inst_18855 = (state_18976[(17)]);
var inst_18873 = (state_18976[(2)]);
var inst_18874 = (inst_18858 + (1));
var tmp18988 = inst_18857;
var tmp18989 = inst_18856;
var tmp18990 = inst_18855;
var inst_18855__$1 = tmp18990;
var inst_18856__$1 = tmp18989;
var inst_18857__$1 = tmp18988;
var inst_18858__$1 = inst_18874;
var state_18976__$1 = (function (){var statearr_18995 = state_18976;
(statearr_18995[(13)] = inst_18858__$1);

(statearr_18995[(14)] = inst_18857__$1);

(statearr_18995[(15)] = inst_18856__$1);

(statearr_18995[(18)] = inst_18873);

(statearr_18995[(17)] = inst_18855__$1);

return statearr_18995;
})();
var statearr_18996_19071 = state_18976__$1;
(statearr_18996_19071[(2)] = null);

(statearr_18996_19071[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (21))){
var inst_18900 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
var statearr_19000_19072 = state_18976__$1;
(statearr_19000_19072[(2)] = inst_18900);

(statearr_19000_19072[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (31))){
var inst_18926 = (state_18976[(9)]);
var inst_18930 = cljs.core.async.untap_STAR_.call(null,m,inst_18926);
var state_18976__$1 = state_18976;
var statearr_19001_19073 = state_18976__$1;
(statearr_19001_19073[(2)] = inst_18930);

(statearr_19001_19073[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (32))){
var inst_18918 = (state_18976[(19)]);
var inst_18920 = (state_18976[(20)]);
var inst_18919 = (state_18976[(11)]);
var inst_18921 = (state_18976[(12)]);
var inst_18932 = (state_18976[(2)]);
var inst_18933 = (inst_18921 + (1));
var tmp18997 = inst_18918;
var tmp18998 = inst_18920;
var tmp18999 = inst_18919;
var inst_18918__$1 = tmp18997;
var inst_18919__$1 = tmp18999;
var inst_18920__$1 = tmp18998;
var inst_18921__$1 = inst_18933;
var state_18976__$1 = (function (){var statearr_19002 = state_18976;
(statearr_19002[(21)] = inst_18932);

(statearr_19002[(19)] = inst_18918__$1);

(statearr_19002[(20)] = inst_18920__$1);

(statearr_19002[(11)] = inst_18919__$1);

(statearr_19002[(12)] = inst_18921__$1);

return statearr_19002;
})();
var statearr_19003_19074 = state_18976__$1;
(statearr_19003_19074[(2)] = null);

(statearr_19003_19074[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (40))){
var inst_18945 = (state_18976[(22)]);
var inst_18949 = cljs.core.async.untap_STAR_.call(null,m,inst_18945);
var state_18976__$1 = state_18976;
var statearr_19004_19075 = state_18976__$1;
(statearr_19004_19075[(2)] = inst_18949);

(statearr_19004_19075[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (33))){
var inst_18936 = (state_18976[(23)]);
var inst_18938 = cljs.core.chunked_seq_QMARK_.call(null,inst_18936);
var state_18976__$1 = state_18976;
if(inst_18938){
var statearr_19005_19076 = state_18976__$1;
(statearr_19005_19076[(1)] = (36));

} else {
var statearr_19006_19077 = state_18976__$1;
(statearr_19006_19077[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (13))){
var inst_18867 = (state_18976[(24)]);
var inst_18870 = cljs.core.async.close_BANG_.call(null,inst_18867);
var state_18976__$1 = state_18976;
var statearr_19007_19078 = state_18976__$1;
(statearr_19007_19078[(2)] = inst_18870);

(statearr_19007_19078[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (22))){
var inst_18890 = (state_18976[(8)]);
var inst_18893 = cljs.core.async.close_BANG_.call(null,inst_18890);
var state_18976__$1 = state_18976;
var statearr_19008_19079 = state_18976__$1;
(statearr_19008_19079[(2)] = inst_18893);

(statearr_19008_19079[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (36))){
var inst_18936 = (state_18976[(23)]);
var inst_18940 = cljs.core.chunk_first.call(null,inst_18936);
var inst_18941 = cljs.core.chunk_rest.call(null,inst_18936);
var inst_18942 = cljs.core.count.call(null,inst_18940);
var inst_18918 = inst_18941;
var inst_18919 = inst_18940;
var inst_18920 = inst_18942;
var inst_18921 = (0);
var state_18976__$1 = (function (){var statearr_19009 = state_18976;
(statearr_19009[(19)] = inst_18918);

(statearr_19009[(20)] = inst_18920);

(statearr_19009[(11)] = inst_18919);

(statearr_19009[(12)] = inst_18921);

return statearr_19009;
})();
var statearr_19010_19080 = state_18976__$1;
(statearr_19010_19080[(2)] = null);

(statearr_19010_19080[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (41))){
var inst_18936 = (state_18976[(23)]);
var inst_18951 = (state_18976[(2)]);
var inst_18952 = cljs.core.next.call(null,inst_18936);
var inst_18918 = inst_18952;
var inst_18919 = null;
var inst_18920 = (0);
var inst_18921 = (0);
var state_18976__$1 = (function (){var statearr_19011 = state_18976;
(statearr_19011[(25)] = inst_18951);

(statearr_19011[(19)] = inst_18918);

(statearr_19011[(20)] = inst_18920);

(statearr_19011[(11)] = inst_18919);

(statearr_19011[(12)] = inst_18921);

return statearr_19011;
})();
var statearr_19012_19081 = state_18976__$1;
(statearr_19012_19081[(2)] = null);

(statearr_19012_19081[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (43))){
var state_18976__$1 = state_18976;
var statearr_19013_19082 = state_18976__$1;
(statearr_19013_19082[(2)] = null);

(statearr_19013_19082[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (29))){
var inst_18960 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
var statearr_19014_19083 = state_18976__$1;
(statearr_19014_19083[(2)] = inst_18960);

(statearr_19014_19083[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (44))){
var inst_18969 = (state_18976[(2)]);
var state_18976__$1 = (function (){var statearr_19015 = state_18976;
(statearr_19015[(26)] = inst_18969);

return statearr_19015;
})();
var statearr_19016_19084 = state_18976__$1;
(statearr_19016_19084[(2)] = null);

(statearr_19016_19084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (6))){
var inst_18910 = (state_18976[(27)]);
var inst_18909 = cljs.core.deref.call(null,cs);
var inst_18910__$1 = cljs.core.keys.call(null,inst_18909);
var inst_18911 = cljs.core.count.call(null,inst_18910__$1);
var inst_18912 = cljs.core.reset_BANG_.call(null,dctr,inst_18911);
var inst_18917 = cljs.core.seq.call(null,inst_18910__$1);
var inst_18918 = inst_18917;
var inst_18919 = null;
var inst_18920 = (0);
var inst_18921 = (0);
var state_18976__$1 = (function (){var statearr_19017 = state_18976;
(statearr_19017[(27)] = inst_18910__$1);

(statearr_19017[(19)] = inst_18918);

(statearr_19017[(20)] = inst_18920);

(statearr_19017[(11)] = inst_18919);

(statearr_19017[(28)] = inst_18912);

(statearr_19017[(12)] = inst_18921);

return statearr_19017;
})();
var statearr_19018_19085 = state_18976__$1;
(statearr_19018_19085[(2)] = null);

(statearr_19018_19085[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (28))){
var inst_18936 = (state_18976[(23)]);
var inst_18918 = (state_18976[(19)]);
var inst_18936__$1 = cljs.core.seq.call(null,inst_18918);
var state_18976__$1 = (function (){var statearr_19019 = state_18976;
(statearr_19019[(23)] = inst_18936__$1);

return statearr_19019;
})();
if(inst_18936__$1){
var statearr_19020_19086 = state_18976__$1;
(statearr_19020_19086[(1)] = (33));

} else {
var statearr_19021_19087 = state_18976__$1;
(statearr_19021_19087[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (25))){
var inst_18920 = (state_18976[(20)]);
var inst_18921 = (state_18976[(12)]);
var inst_18923 = (inst_18921 < inst_18920);
var inst_18924 = inst_18923;
var state_18976__$1 = state_18976;
if(cljs.core.truth_(inst_18924)){
var statearr_19022_19088 = state_18976__$1;
(statearr_19022_19088[(1)] = (27));

} else {
var statearr_19023_19089 = state_18976__$1;
(statearr_19023_19089[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (34))){
var state_18976__$1 = state_18976;
var statearr_19024_19090 = state_18976__$1;
(statearr_19024_19090[(2)] = null);

(statearr_19024_19090[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (17))){
var state_18976__$1 = state_18976;
var statearr_19025_19091 = state_18976__$1;
(statearr_19025_19091[(2)] = null);

(statearr_19025_19091[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (3))){
var inst_18974 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18976__$1,inst_18974);
} else {
if((state_val_18977 === (12))){
var inst_18905 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
var statearr_19026_19092 = state_18976__$1;
(statearr_19026_19092[(2)] = inst_18905);

(statearr_19026_19092[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (2))){
var state_18976__$1 = state_18976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18976__$1,(4),ch);
} else {
if((state_val_18977 === (23))){
var state_18976__$1 = state_18976;
var statearr_19027_19093 = state_18976__$1;
(statearr_19027_19093[(2)] = null);

(statearr_19027_19093[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (35))){
var inst_18958 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
var statearr_19028_19094 = state_18976__$1;
(statearr_19028_19094[(2)] = inst_18958);

(statearr_19028_19094[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (19))){
var inst_18877 = (state_18976[(7)]);
var inst_18881 = cljs.core.chunk_first.call(null,inst_18877);
var inst_18882 = cljs.core.chunk_rest.call(null,inst_18877);
var inst_18883 = cljs.core.count.call(null,inst_18881);
var inst_18855 = inst_18882;
var inst_18856 = inst_18881;
var inst_18857 = inst_18883;
var inst_18858 = (0);
var state_18976__$1 = (function (){var statearr_19029 = state_18976;
(statearr_19029[(13)] = inst_18858);

(statearr_19029[(14)] = inst_18857);

(statearr_19029[(15)] = inst_18856);

(statearr_19029[(17)] = inst_18855);

return statearr_19029;
})();
var statearr_19030_19095 = state_18976__$1;
(statearr_19030_19095[(2)] = null);

(statearr_19030_19095[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (11))){
var inst_18855 = (state_18976[(17)]);
var inst_18877 = (state_18976[(7)]);
var inst_18877__$1 = cljs.core.seq.call(null,inst_18855);
var state_18976__$1 = (function (){var statearr_19031 = state_18976;
(statearr_19031[(7)] = inst_18877__$1);

return statearr_19031;
})();
if(inst_18877__$1){
var statearr_19032_19096 = state_18976__$1;
(statearr_19032_19096[(1)] = (16));

} else {
var statearr_19033_19097 = state_18976__$1;
(statearr_19033_19097[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (9))){
var inst_18907 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
var statearr_19034_19098 = state_18976__$1;
(statearr_19034_19098[(2)] = inst_18907);

(statearr_19034_19098[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (5))){
var inst_18853 = cljs.core.deref.call(null,cs);
var inst_18854 = cljs.core.seq.call(null,inst_18853);
var inst_18855 = inst_18854;
var inst_18856 = null;
var inst_18857 = (0);
var inst_18858 = (0);
var state_18976__$1 = (function (){var statearr_19035 = state_18976;
(statearr_19035[(13)] = inst_18858);

(statearr_19035[(14)] = inst_18857);

(statearr_19035[(15)] = inst_18856);

(statearr_19035[(17)] = inst_18855);

return statearr_19035;
})();
var statearr_19036_19099 = state_18976__$1;
(statearr_19036_19099[(2)] = null);

(statearr_19036_19099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (14))){
var state_18976__$1 = state_18976;
var statearr_19037_19100 = state_18976__$1;
(statearr_19037_19100[(2)] = null);

(statearr_19037_19100[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (45))){
var inst_18966 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
var statearr_19038_19101 = state_18976__$1;
(statearr_19038_19101[(2)] = inst_18966);

(statearr_19038_19101[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (26))){
var inst_18910 = (state_18976[(27)]);
var inst_18962 = (state_18976[(2)]);
var inst_18963 = cljs.core.seq.call(null,inst_18910);
var state_18976__$1 = (function (){var statearr_19039 = state_18976;
(statearr_19039[(29)] = inst_18962);

return statearr_19039;
})();
if(inst_18963){
var statearr_19040_19102 = state_18976__$1;
(statearr_19040_19102[(1)] = (42));

} else {
var statearr_19041_19103 = state_18976__$1;
(statearr_19041_19103[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (16))){
var inst_18877 = (state_18976[(7)]);
var inst_18879 = cljs.core.chunked_seq_QMARK_.call(null,inst_18877);
var state_18976__$1 = state_18976;
if(inst_18879){
var statearr_19042_19104 = state_18976__$1;
(statearr_19042_19104[(1)] = (19));

} else {
var statearr_19043_19105 = state_18976__$1;
(statearr_19043_19105[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (38))){
var inst_18955 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
var statearr_19044_19106 = state_18976__$1;
(statearr_19044_19106[(2)] = inst_18955);

(statearr_19044_19106[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (30))){
var state_18976__$1 = state_18976;
var statearr_19045_19107 = state_18976__$1;
(statearr_19045_19107[(2)] = null);

(statearr_19045_19107[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (10))){
var inst_18858 = (state_18976[(13)]);
var inst_18856 = (state_18976[(15)]);
var inst_18866 = cljs.core._nth.call(null,inst_18856,inst_18858);
var inst_18867 = cljs.core.nth.call(null,inst_18866,(0),null);
var inst_18868 = cljs.core.nth.call(null,inst_18866,(1),null);
var state_18976__$1 = (function (){var statearr_19046 = state_18976;
(statearr_19046[(24)] = inst_18867);

return statearr_19046;
})();
if(cljs.core.truth_(inst_18868)){
var statearr_19047_19108 = state_18976__$1;
(statearr_19047_19108[(1)] = (13));

} else {
var statearr_19048_19109 = state_18976__$1;
(statearr_19048_19109[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (18))){
var inst_18903 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
var statearr_19049_19110 = state_18976__$1;
(statearr_19049_19110[(2)] = inst_18903);

(statearr_19049_19110[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (42))){
var state_18976__$1 = state_18976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18976__$1,(45),dchan);
} else {
if((state_val_18977 === (37))){
var inst_18846 = (state_18976[(10)]);
var inst_18936 = (state_18976[(23)]);
var inst_18945 = (state_18976[(22)]);
var inst_18945__$1 = cljs.core.first.call(null,inst_18936);
var inst_18946 = cljs.core.async.put_BANG_.call(null,inst_18945__$1,inst_18846,done);
var state_18976__$1 = (function (){var statearr_19050 = state_18976;
(statearr_19050[(22)] = inst_18945__$1);

return statearr_19050;
})();
if(cljs.core.truth_(inst_18946)){
var statearr_19051_19111 = state_18976__$1;
(statearr_19051_19111[(1)] = (39));

} else {
var statearr_19052_19112 = state_18976__$1;
(statearr_19052_19112[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (8))){
var inst_18858 = (state_18976[(13)]);
var inst_18857 = (state_18976[(14)]);
var inst_18860 = (inst_18858 < inst_18857);
var inst_18861 = inst_18860;
var state_18976__$1 = state_18976;
if(cljs.core.truth_(inst_18861)){
var statearr_19053_19113 = state_18976__$1;
(statearr_19053_19113[(1)] = (10));

} else {
var statearr_19054_19114 = state_18976__$1;
(statearr_19054_19114[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__16221__auto__ = null;
var cljs$core$async$mult_$_state_machine__16221__auto____0 = (function (){
var statearr_19055 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19055[(0)] = cljs$core$async$mult_$_state_machine__16221__auto__);

(statearr_19055[(1)] = (1));

return statearr_19055;
});
var cljs$core$async$mult_$_state_machine__16221__auto____1 = (function (state_18976){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_18976);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e19056){var ex__16224__auto__ = e19056;
var statearr_19057_19115 = state_18976;
(statearr_19057_19115[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_18976[(4)]))){
var statearr_19058_19116 = state_18976;
(statearr_19058_19116[(1)] = cljs.core.first.call(null,(state_18976[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19117 = state_18976;
state_18976 = G__19117;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16221__auto__ = function(state_18976){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16221__auto____1.call(this,state_18976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16221__auto____0;
cljs$core$async$mult_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16221__auto____1;
return cljs$core$async$mult_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_19059 = f__16346__auto__.call(null);
(statearr_19059[(6)] = c__16345__auto___19060);

return statearr_19059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__19119 = arguments.length;
switch (G__19119) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_19121 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,m,ch);
} else {
var m__4508__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_19121.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_19122 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,m,ch);
} else {
var m__4508__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_19122.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_19123 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,m);
} else {
var m__4508__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_19123.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_19124 = (function (m,state_map){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,m,state_map);
} else {
var m__4508__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_19124.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_19125 = (function (m,mode){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,m,mode);
} else {
var m__4508__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_19125.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___19135 = arguments.length;
var i__4819__auto___19136 = (0);
while(true){
if((i__4819__auto___19136 < len__4818__auto___19135)){
args__4824__auto__.push((arguments[i__4819__auto___19136]));

var G__19137 = (i__4819__auto___19136 + (1));
i__4819__auto___19136 = G__19137;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((3) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4825__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__19130){
var map__19131 = p__19130;
var map__19131__$1 = cljs.core.__destructure_map.call(null,map__19131);
var opts = map__19131__$1;
var statearr_19132_19138 = state;
(statearr_19132_19138[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_19133_19139 = state;
(statearr_19133_19139[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_19134_19140 = state;
(statearr_19134_19140[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq19126){
var G__19127 = cljs.core.first.call(null,seq19126);
var seq19126__$1 = cljs.core.next.call(null,seq19126);
var G__19128 = cljs.core.first.call(null,seq19126__$1);
var seq19126__$2 = cljs.core.next.call(null,seq19126__$1);
var G__19129 = cljs.core.first.call(null,seq19126__$2);
var seq19126__$3 = cljs.core.next.call(null,seq19126__$2);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19127,G__19128,G__19129,seq19126__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async19141 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19141 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta19142){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta19142 = meta19142;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async19141.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19143,meta19142__$1){
var self__ = this;
var _19143__$1 = this;
return (new cljs.core.async.t_cljs$core$async19141(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta19142__$1));
}));

(cljs.core.async.t_cljs$core$async19141.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19143){
var self__ = this;
var _19143__$1 = this;
return self__.meta19142;
}));

(cljs.core.async.t_cljs$core$async19141.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19141.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async19141.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19141.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async19141.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async19141.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async19141.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async19141.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async19141.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta19142","meta19142",1225279326,null)], null);
}));

(cljs.core.async.t_cljs$core$async19141.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async19141.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19141");

(cljs.core.async.t_cljs$core$async19141.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write.call(null,writer__4451__auto__,"cljs.core.async/t_cljs$core$async19141");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async19141.
 */
cljs.core.async.__GT_t_cljs$core$async19141 = (function cljs$core$async$mix_$___GT_t_cljs$core$async19141(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19142){
return (new cljs.core.async.t_cljs$core$async19141(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19142));
});

}

return (new cljs.core.async.t_cljs$core$async19141(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16345__auto___19256 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_19211){
var state_val_19212 = (state_19211[(1)]);
if((state_val_19212 === (7))){
var inst_19171 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
if(cljs.core.truth_(inst_19171)){
var statearr_19213_19257 = state_19211__$1;
(statearr_19213_19257[(1)] = (8));

} else {
var statearr_19214_19258 = state_19211__$1;
(statearr_19214_19258[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (20))){
var inst_19164 = (state_19211[(7)]);
var state_19211__$1 = state_19211;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19211__$1,(23),out,inst_19164);
} else {
if((state_val_19212 === (1))){
var inst_19147 = calc_state.call(null);
var inst_19148 = cljs.core.__destructure_map.call(null,inst_19147);
var inst_19149 = cljs.core.get.call(null,inst_19148,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19150 = cljs.core.get.call(null,inst_19148,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19151 = cljs.core.get.call(null,inst_19148,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_19152 = inst_19147;
var state_19211__$1 = (function (){var statearr_19215 = state_19211;
(statearr_19215[(8)] = inst_19150);

(statearr_19215[(9)] = inst_19149);

(statearr_19215[(10)] = inst_19152);

(statearr_19215[(11)] = inst_19151);

return statearr_19215;
})();
var statearr_19216_19259 = state_19211__$1;
(statearr_19216_19259[(2)] = null);

(statearr_19216_19259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (24))){
var inst_19155 = (state_19211[(12)]);
var inst_19152 = inst_19155;
var state_19211__$1 = (function (){var statearr_19217 = state_19211;
(statearr_19217[(10)] = inst_19152);

return statearr_19217;
})();
var statearr_19218_19260 = state_19211__$1;
(statearr_19218_19260[(2)] = null);

(statearr_19218_19260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (4))){
var inst_19164 = (state_19211[(7)]);
var inst_19166 = (state_19211[(13)]);
var inst_19163 = (state_19211[(2)]);
var inst_19164__$1 = cljs.core.nth.call(null,inst_19163,(0),null);
var inst_19165 = cljs.core.nth.call(null,inst_19163,(1),null);
var inst_19166__$1 = (inst_19164__$1 == null);
var state_19211__$1 = (function (){var statearr_19219 = state_19211;
(statearr_19219[(14)] = inst_19165);

(statearr_19219[(7)] = inst_19164__$1);

(statearr_19219[(13)] = inst_19166__$1);

return statearr_19219;
})();
if(cljs.core.truth_(inst_19166__$1)){
var statearr_19220_19261 = state_19211__$1;
(statearr_19220_19261[(1)] = (5));

} else {
var statearr_19221_19262 = state_19211__$1;
(statearr_19221_19262[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (15))){
var inst_19185 = (state_19211[(15)]);
var inst_19156 = (state_19211[(16)]);
var inst_19185__$1 = cljs.core.empty_QMARK_.call(null,inst_19156);
var state_19211__$1 = (function (){var statearr_19222 = state_19211;
(statearr_19222[(15)] = inst_19185__$1);

return statearr_19222;
})();
if(inst_19185__$1){
var statearr_19223_19263 = state_19211__$1;
(statearr_19223_19263[(1)] = (17));

} else {
var statearr_19224_19264 = state_19211__$1;
(statearr_19224_19264[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (21))){
var inst_19155 = (state_19211[(12)]);
var inst_19152 = inst_19155;
var state_19211__$1 = (function (){var statearr_19225 = state_19211;
(statearr_19225[(10)] = inst_19152);

return statearr_19225;
})();
var statearr_19226_19265 = state_19211__$1;
(statearr_19226_19265[(2)] = null);

(statearr_19226_19265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (13))){
var inst_19178 = (state_19211[(2)]);
var inst_19179 = calc_state.call(null);
var inst_19152 = inst_19179;
var state_19211__$1 = (function (){var statearr_19227 = state_19211;
(statearr_19227[(17)] = inst_19178);

(statearr_19227[(10)] = inst_19152);

return statearr_19227;
})();
var statearr_19228_19266 = state_19211__$1;
(statearr_19228_19266[(2)] = null);

(statearr_19228_19266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (22))){
var inst_19205 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
var statearr_19229_19267 = state_19211__$1;
(statearr_19229_19267[(2)] = inst_19205);

(statearr_19229_19267[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (6))){
var inst_19165 = (state_19211[(14)]);
var inst_19169 = cljs.core._EQ_.call(null,inst_19165,change);
var state_19211__$1 = state_19211;
var statearr_19230_19268 = state_19211__$1;
(statearr_19230_19268[(2)] = inst_19169);

(statearr_19230_19268[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (25))){
var state_19211__$1 = state_19211;
var statearr_19231_19269 = state_19211__$1;
(statearr_19231_19269[(2)] = null);

(statearr_19231_19269[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (17))){
var inst_19157 = (state_19211[(18)]);
var inst_19165 = (state_19211[(14)]);
var inst_19187 = inst_19157.call(null,inst_19165);
var inst_19188 = cljs.core.not.call(null,inst_19187);
var state_19211__$1 = state_19211;
var statearr_19232_19270 = state_19211__$1;
(statearr_19232_19270[(2)] = inst_19188);

(statearr_19232_19270[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (3))){
var inst_19209 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19211__$1,inst_19209);
} else {
if((state_val_19212 === (12))){
var state_19211__$1 = state_19211;
var statearr_19233_19271 = state_19211__$1;
(statearr_19233_19271[(2)] = null);

(statearr_19233_19271[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (2))){
var inst_19155 = (state_19211[(12)]);
var inst_19152 = (state_19211[(10)]);
var inst_19155__$1 = cljs.core.__destructure_map.call(null,inst_19152);
var inst_19156 = cljs.core.get.call(null,inst_19155__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19157 = cljs.core.get.call(null,inst_19155__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19158 = cljs.core.get.call(null,inst_19155__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_19211__$1 = (function (){var statearr_19234 = state_19211;
(statearr_19234[(18)] = inst_19157);

(statearr_19234[(12)] = inst_19155__$1);

(statearr_19234[(16)] = inst_19156);

return statearr_19234;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19211__$1,(4),inst_19158);
} else {
if((state_val_19212 === (23))){
var inst_19196 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
if(cljs.core.truth_(inst_19196)){
var statearr_19235_19272 = state_19211__$1;
(statearr_19235_19272[(1)] = (24));

} else {
var statearr_19236_19273 = state_19211__$1;
(statearr_19236_19273[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (19))){
var inst_19191 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
var statearr_19237_19274 = state_19211__$1;
(statearr_19237_19274[(2)] = inst_19191);

(statearr_19237_19274[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (11))){
var inst_19165 = (state_19211[(14)]);
var inst_19175 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_19165);
var state_19211__$1 = state_19211;
var statearr_19238_19275 = state_19211__$1;
(statearr_19238_19275[(2)] = inst_19175);

(statearr_19238_19275[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (9))){
var inst_19182 = (state_19211[(19)]);
var inst_19165 = (state_19211[(14)]);
var inst_19156 = (state_19211[(16)]);
var inst_19182__$1 = inst_19156.call(null,inst_19165);
var state_19211__$1 = (function (){var statearr_19239 = state_19211;
(statearr_19239[(19)] = inst_19182__$1);

return statearr_19239;
})();
if(cljs.core.truth_(inst_19182__$1)){
var statearr_19240_19276 = state_19211__$1;
(statearr_19240_19276[(1)] = (14));

} else {
var statearr_19241_19277 = state_19211__$1;
(statearr_19241_19277[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (5))){
var inst_19166 = (state_19211[(13)]);
var state_19211__$1 = state_19211;
var statearr_19242_19278 = state_19211__$1;
(statearr_19242_19278[(2)] = inst_19166);

(statearr_19242_19278[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (14))){
var inst_19182 = (state_19211[(19)]);
var state_19211__$1 = state_19211;
var statearr_19243_19279 = state_19211__$1;
(statearr_19243_19279[(2)] = inst_19182);

(statearr_19243_19279[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (26))){
var inst_19201 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
var statearr_19244_19280 = state_19211__$1;
(statearr_19244_19280[(2)] = inst_19201);

(statearr_19244_19280[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (16))){
var inst_19193 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
if(cljs.core.truth_(inst_19193)){
var statearr_19245_19281 = state_19211__$1;
(statearr_19245_19281[(1)] = (20));

} else {
var statearr_19246_19282 = state_19211__$1;
(statearr_19246_19282[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (10))){
var inst_19207 = (state_19211[(2)]);
var state_19211__$1 = state_19211;
var statearr_19247_19283 = state_19211__$1;
(statearr_19247_19283[(2)] = inst_19207);

(statearr_19247_19283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (18))){
var inst_19185 = (state_19211[(15)]);
var state_19211__$1 = state_19211;
var statearr_19248_19284 = state_19211__$1;
(statearr_19248_19284[(2)] = inst_19185);

(statearr_19248_19284[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19212 === (8))){
var inst_19164 = (state_19211[(7)]);
var inst_19173 = (inst_19164 == null);
var state_19211__$1 = state_19211;
if(cljs.core.truth_(inst_19173)){
var statearr_19249_19285 = state_19211__$1;
(statearr_19249_19285[(1)] = (11));

} else {
var statearr_19250_19286 = state_19211__$1;
(statearr_19250_19286[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__16221__auto__ = null;
var cljs$core$async$mix_$_state_machine__16221__auto____0 = (function (){
var statearr_19251 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19251[(0)] = cljs$core$async$mix_$_state_machine__16221__auto__);

(statearr_19251[(1)] = (1));

return statearr_19251;
});
var cljs$core$async$mix_$_state_machine__16221__auto____1 = (function (state_19211){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_19211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e19252){var ex__16224__auto__ = e19252;
var statearr_19253_19287 = state_19211;
(statearr_19253_19287[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_19211[(4)]))){
var statearr_19254_19288 = state_19211;
(statearr_19254_19288[(1)] = cljs.core.first.call(null,(state_19211[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19289 = state_19211;
state_19211 = G__19289;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16221__auto__ = function(state_19211){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16221__auto____1.call(this,state_19211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16221__auto____0;
cljs$core$async$mix_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16221__auto____1;
return cljs$core$async$mix_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_19255 = f__16346__auto__.call(null);
(statearr_19255[(6)] = c__16345__auto___19256);

return statearr_19255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_19292 = (function (p,v,ch,close_QMARK_){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4508__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_19292.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_19293 = (function (p,v,ch){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,p,v,ch);
} else {
var m__4508__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_19293.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_19294 = (function() {
var G__19295 = null;
var G__19295__1 = (function (p){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,p);
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__19295__2 = (function (p,v){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return m__4510__auto__.call(null,p,v);
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return m__4508__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__19295 = function(p,v){
switch(arguments.length){
case 1:
return G__19295__1.call(this,p);
case 2:
return G__19295__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19295.cljs$core$IFn$_invoke$arity$1 = G__19295__1;
G__19295.cljs$core$IFn$_invoke$arity$2 = G__19295__2;
return G__19295;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__19291 = arguments.length;
switch (G__19291) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_19294.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_19294.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__19299 = arguments.length;
switch (G__19299) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4212__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__19297_SHARP_){
if(cljs.core.truth_(p1__19297_SHARP_.call(null,topic))){
return p1__19297_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19297_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async19300 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19300 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19301){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19301 = meta19301;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async19300.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19302,meta19301__$1){
var self__ = this;
var _19302__$1 = this;
return (new cljs.core.async.t_cljs$core$async19300(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19301__$1));
}));

(cljs.core.async.t_cljs$core$async19300.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19302){
var self__ = this;
var _19302__$1 = this;
return self__.meta19301;
}));

(cljs.core.async.t_cljs$core$async19300.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19300.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async19300.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19300.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async19300.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async19300.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async19300.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async19300.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19301","meta19301",1675812009,null)], null);
}));

(cljs.core.async.t_cljs$core$async19300.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async19300.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19300");

(cljs.core.async.t_cljs$core$async19300.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write.call(null,writer__4451__auto__,"cljs.core.async/t_cljs$core$async19300");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async19300.
 */
cljs.core.async.__GT_t_cljs$core$async19300 = (function cljs$core$async$__GT_t_cljs$core$async19300(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19301){
return (new cljs.core.async.t_cljs$core$async19300(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19301));
});

}

return (new cljs.core.async.t_cljs$core$async19300(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16345__auto___19421 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_19374){
var state_val_19375 = (state_19374[(1)]);
if((state_val_19375 === (7))){
var inst_19370 = (state_19374[(2)]);
var state_19374__$1 = state_19374;
var statearr_19376_19422 = state_19374__$1;
(statearr_19376_19422[(2)] = inst_19370);

(statearr_19376_19422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (20))){
var state_19374__$1 = state_19374;
var statearr_19377_19423 = state_19374__$1;
(statearr_19377_19423[(2)] = null);

(statearr_19377_19423[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (1))){
var state_19374__$1 = state_19374;
var statearr_19378_19424 = state_19374__$1;
(statearr_19378_19424[(2)] = null);

(statearr_19378_19424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (24))){
var inst_19353 = (state_19374[(7)]);
var inst_19362 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19353);
var state_19374__$1 = state_19374;
var statearr_19379_19425 = state_19374__$1;
(statearr_19379_19425[(2)] = inst_19362);

(statearr_19379_19425[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (4))){
var inst_19305 = (state_19374[(8)]);
var inst_19305__$1 = (state_19374[(2)]);
var inst_19306 = (inst_19305__$1 == null);
var state_19374__$1 = (function (){var statearr_19380 = state_19374;
(statearr_19380[(8)] = inst_19305__$1);

return statearr_19380;
})();
if(cljs.core.truth_(inst_19306)){
var statearr_19381_19426 = state_19374__$1;
(statearr_19381_19426[(1)] = (5));

} else {
var statearr_19382_19427 = state_19374__$1;
(statearr_19382_19427[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (15))){
var inst_19347 = (state_19374[(2)]);
var state_19374__$1 = state_19374;
var statearr_19383_19428 = state_19374__$1;
(statearr_19383_19428[(2)] = inst_19347);

(statearr_19383_19428[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (21))){
var inst_19367 = (state_19374[(2)]);
var state_19374__$1 = (function (){var statearr_19384 = state_19374;
(statearr_19384[(9)] = inst_19367);

return statearr_19384;
})();
var statearr_19385_19429 = state_19374__$1;
(statearr_19385_19429[(2)] = null);

(statearr_19385_19429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (13))){
var inst_19329 = (state_19374[(10)]);
var inst_19331 = cljs.core.chunked_seq_QMARK_.call(null,inst_19329);
var state_19374__$1 = state_19374;
if(inst_19331){
var statearr_19386_19430 = state_19374__$1;
(statearr_19386_19430[(1)] = (16));

} else {
var statearr_19387_19431 = state_19374__$1;
(statearr_19387_19431[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (22))){
var inst_19359 = (state_19374[(2)]);
var state_19374__$1 = state_19374;
if(cljs.core.truth_(inst_19359)){
var statearr_19388_19432 = state_19374__$1;
(statearr_19388_19432[(1)] = (23));

} else {
var statearr_19389_19433 = state_19374__$1;
(statearr_19389_19433[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (6))){
var inst_19353 = (state_19374[(7)]);
var inst_19355 = (state_19374[(11)]);
var inst_19305 = (state_19374[(8)]);
var inst_19353__$1 = topic_fn.call(null,inst_19305);
var inst_19354 = cljs.core.deref.call(null,mults);
var inst_19355__$1 = cljs.core.get.call(null,inst_19354,inst_19353__$1);
var state_19374__$1 = (function (){var statearr_19390 = state_19374;
(statearr_19390[(7)] = inst_19353__$1);

(statearr_19390[(11)] = inst_19355__$1);

return statearr_19390;
})();
if(cljs.core.truth_(inst_19355__$1)){
var statearr_19391_19434 = state_19374__$1;
(statearr_19391_19434[(1)] = (19));

} else {
var statearr_19392_19435 = state_19374__$1;
(statearr_19392_19435[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (25))){
var inst_19364 = (state_19374[(2)]);
var state_19374__$1 = state_19374;
var statearr_19393_19436 = state_19374__$1;
(statearr_19393_19436[(2)] = inst_19364);

(statearr_19393_19436[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (17))){
var inst_19329 = (state_19374[(10)]);
var inst_19338 = cljs.core.first.call(null,inst_19329);
var inst_19339 = cljs.core.async.muxch_STAR_.call(null,inst_19338);
var inst_19340 = cljs.core.async.close_BANG_.call(null,inst_19339);
var inst_19341 = cljs.core.next.call(null,inst_19329);
var inst_19315 = inst_19341;
var inst_19316 = null;
var inst_19317 = (0);
var inst_19318 = (0);
var state_19374__$1 = (function (){var statearr_19394 = state_19374;
(statearr_19394[(12)] = inst_19318);

(statearr_19394[(13)] = inst_19340);

(statearr_19394[(14)] = inst_19317);

(statearr_19394[(15)] = inst_19315);

(statearr_19394[(16)] = inst_19316);

return statearr_19394;
})();
var statearr_19395_19437 = state_19374__$1;
(statearr_19395_19437[(2)] = null);

(statearr_19395_19437[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (3))){
var inst_19372 = (state_19374[(2)]);
var state_19374__$1 = state_19374;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19374__$1,inst_19372);
} else {
if((state_val_19375 === (12))){
var inst_19349 = (state_19374[(2)]);
var state_19374__$1 = state_19374;
var statearr_19396_19438 = state_19374__$1;
(statearr_19396_19438[(2)] = inst_19349);

(statearr_19396_19438[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (2))){
var state_19374__$1 = state_19374;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19374__$1,(4),ch);
} else {
if((state_val_19375 === (23))){
var state_19374__$1 = state_19374;
var statearr_19397_19439 = state_19374__$1;
(statearr_19397_19439[(2)] = null);

(statearr_19397_19439[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (19))){
var inst_19355 = (state_19374[(11)]);
var inst_19305 = (state_19374[(8)]);
var inst_19357 = cljs.core.async.muxch_STAR_.call(null,inst_19355);
var state_19374__$1 = state_19374;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19374__$1,(22),inst_19357,inst_19305);
} else {
if((state_val_19375 === (11))){
var inst_19329 = (state_19374[(10)]);
var inst_19315 = (state_19374[(15)]);
var inst_19329__$1 = cljs.core.seq.call(null,inst_19315);
var state_19374__$1 = (function (){var statearr_19398 = state_19374;
(statearr_19398[(10)] = inst_19329__$1);

return statearr_19398;
})();
if(inst_19329__$1){
var statearr_19399_19440 = state_19374__$1;
(statearr_19399_19440[(1)] = (13));

} else {
var statearr_19400_19441 = state_19374__$1;
(statearr_19400_19441[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (9))){
var inst_19351 = (state_19374[(2)]);
var state_19374__$1 = state_19374;
var statearr_19401_19442 = state_19374__$1;
(statearr_19401_19442[(2)] = inst_19351);

(statearr_19401_19442[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (5))){
var inst_19312 = cljs.core.deref.call(null,mults);
var inst_19313 = cljs.core.vals.call(null,inst_19312);
var inst_19314 = cljs.core.seq.call(null,inst_19313);
var inst_19315 = inst_19314;
var inst_19316 = null;
var inst_19317 = (0);
var inst_19318 = (0);
var state_19374__$1 = (function (){var statearr_19402 = state_19374;
(statearr_19402[(12)] = inst_19318);

(statearr_19402[(14)] = inst_19317);

(statearr_19402[(15)] = inst_19315);

(statearr_19402[(16)] = inst_19316);

return statearr_19402;
})();
var statearr_19403_19443 = state_19374__$1;
(statearr_19403_19443[(2)] = null);

(statearr_19403_19443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (14))){
var state_19374__$1 = state_19374;
var statearr_19407_19444 = state_19374__$1;
(statearr_19407_19444[(2)] = null);

(statearr_19407_19444[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (16))){
var inst_19329 = (state_19374[(10)]);
var inst_19333 = cljs.core.chunk_first.call(null,inst_19329);
var inst_19334 = cljs.core.chunk_rest.call(null,inst_19329);
var inst_19335 = cljs.core.count.call(null,inst_19333);
var inst_19315 = inst_19334;
var inst_19316 = inst_19333;
var inst_19317 = inst_19335;
var inst_19318 = (0);
var state_19374__$1 = (function (){var statearr_19408 = state_19374;
(statearr_19408[(12)] = inst_19318);

(statearr_19408[(14)] = inst_19317);

(statearr_19408[(15)] = inst_19315);

(statearr_19408[(16)] = inst_19316);

return statearr_19408;
})();
var statearr_19409_19445 = state_19374__$1;
(statearr_19409_19445[(2)] = null);

(statearr_19409_19445[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (10))){
var inst_19318 = (state_19374[(12)]);
var inst_19317 = (state_19374[(14)]);
var inst_19315 = (state_19374[(15)]);
var inst_19316 = (state_19374[(16)]);
var inst_19323 = cljs.core._nth.call(null,inst_19316,inst_19318);
var inst_19324 = cljs.core.async.muxch_STAR_.call(null,inst_19323);
var inst_19325 = cljs.core.async.close_BANG_.call(null,inst_19324);
var inst_19326 = (inst_19318 + (1));
var tmp19404 = inst_19317;
var tmp19405 = inst_19315;
var tmp19406 = inst_19316;
var inst_19315__$1 = tmp19405;
var inst_19316__$1 = tmp19406;
var inst_19317__$1 = tmp19404;
var inst_19318__$1 = inst_19326;
var state_19374__$1 = (function (){var statearr_19410 = state_19374;
(statearr_19410[(12)] = inst_19318__$1);

(statearr_19410[(14)] = inst_19317__$1);

(statearr_19410[(15)] = inst_19315__$1);

(statearr_19410[(17)] = inst_19325);

(statearr_19410[(16)] = inst_19316__$1);

return statearr_19410;
})();
var statearr_19411_19446 = state_19374__$1;
(statearr_19411_19446[(2)] = null);

(statearr_19411_19446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (18))){
var inst_19344 = (state_19374[(2)]);
var state_19374__$1 = state_19374;
var statearr_19412_19447 = state_19374__$1;
(statearr_19412_19447[(2)] = inst_19344);

(statearr_19412_19447[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19375 === (8))){
var inst_19318 = (state_19374[(12)]);
var inst_19317 = (state_19374[(14)]);
var inst_19320 = (inst_19318 < inst_19317);
var inst_19321 = inst_19320;
var state_19374__$1 = state_19374;
if(cljs.core.truth_(inst_19321)){
var statearr_19413_19448 = state_19374__$1;
(statearr_19413_19448[(1)] = (10));

} else {
var statearr_19414_19449 = state_19374__$1;
(statearr_19414_19449[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16221__auto__ = null;
var cljs$core$async$state_machine__16221__auto____0 = (function (){
var statearr_19415 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19415[(0)] = cljs$core$async$state_machine__16221__auto__);

(statearr_19415[(1)] = (1));

return statearr_19415;
});
var cljs$core$async$state_machine__16221__auto____1 = (function (state_19374){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_19374);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e19416){var ex__16224__auto__ = e19416;
var statearr_19417_19450 = state_19374;
(statearr_19417_19450[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_19374[(4)]))){
var statearr_19418_19451 = state_19374;
(statearr_19418_19451[(1)] = cljs.core.first.call(null,(state_19374[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19452 = state_19374;
state_19374 = G__19452;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$state_machine__16221__auto__ = function(state_19374){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16221__auto____1.call(this,state_19374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16221__auto____0;
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16221__auto____1;
return cljs$core$async$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_19419 = f__16346__auto__.call(null);
(statearr_19419[(6)] = c__16345__auto___19421);

return statearr_19419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__19454 = arguments.length;
switch (G__19454) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__19457 = arguments.length;
switch (G__19457) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__19460 = arguments.length;
switch (G__19460) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__16345__auto___19538 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_19503){
var state_val_19504 = (state_19503[(1)]);
if((state_val_19504 === (7))){
var state_19503__$1 = state_19503;
var statearr_19505_19539 = state_19503__$1;
(statearr_19505_19539[(2)] = null);

(statearr_19505_19539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (1))){
var state_19503__$1 = state_19503;
var statearr_19506_19540 = state_19503__$1;
(statearr_19506_19540[(2)] = null);

(statearr_19506_19540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (4))){
var inst_19463 = (state_19503[(7)]);
var inst_19464 = (state_19503[(8)]);
var inst_19466 = (inst_19464 < inst_19463);
var state_19503__$1 = state_19503;
if(cljs.core.truth_(inst_19466)){
var statearr_19507_19541 = state_19503__$1;
(statearr_19507_19541[(1)] = (6));

} else {
var statearr_19508_19542 = state_19503__$1;
(statearr_19508_19542[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (15))){
var inst_19489 = (state_19503[(9)]);
var inst_19494 = cljs.core.apply.call(null,f,inst_19489);
var state_19503__$1 = state_19503;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19503__$1,(17),out,inst_19494);
} else {
if((state_val_19504 === (13))){
var inst_19489 = (state_19503[(9)]);
var inst_19489__$1 = (state_19503[(2)]);
var inst_19490 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19489__$1);
var state_19503__$1 = (function (){var statearr_19509 = state_19503;
(statearr_19509[(9)] = inst_19489__$1);

return statearr_19509;
})();
if(cljs.core.truth_(inst_19490)){
var statearr_19510_19543 = state_19503__$1;
(statearr_19510_19543[(1)] = (14));

} else {
var statearr_19511_19544 = state_19503__$1;
(statearr_19511_19544[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (6))){
var state_19503__$1 = state_19503;
var statearr_19512_19545 = state_19503__$1;
(statearr_19512_19545[(2)] = null);

(statearr_19512_19545[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (17))){
var inst_19496 = (state_19503[(2)]);
var state_19503__$1 = (function (){var statearr_19514 = state_19503;
(statearr_19514[(10)] = inst_19496);

return statearr_19514;
})();
var statearr_19515_19546 = state_19503__$1;
(statearr_19515_19546[(2)] = null);

(statearr_19515_19546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (3))){
var inst_19501 = (state_19503[(2)]);
var state_19503__$1 = state_19503;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19503__$1,inst_19501);
} else {
if((state_val_19504 === (12))){
var _ = (function (){var statearr_19516 = state_19503;
(statearr_19516[(4)] = cljs.core.rest.call(null,(state_19503[(4)])));

return statearr_19516;
})();
var state_19503__$1 = state_19503;
var ex19513 = (state_19503__$1[(2)]);
var statearr_19517_19547 = state_19503__$1;
(statearr_19517_19547[(5)] = ex19513);


if((ex19513 instanceof Object)){
var statearr_19518_19548 = state_19503__$1;
(statearr_19518_19548[(1)] = (11));

(statearr_19518_19548[(5)] = null);

} else {
throw ex19513;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (2))){
var inst_19462 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19463 = cnt;
var inst_19464 = (0);
var state_19503__$1 = (function (){var statearr_19519 = state_19503;
(statearr_19519[(7)] = inst_19463);

(statearr_19519[(8)] = inst_19464);

(statearr_19519[(11)] = inst_19462);

return statearr_19519;
})();
var statearr_19520_19549 = state_19503__$1;
(statearr_19520_19549[(2)] = null);

(statearr_19520_19549[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (11))){
var inst_19468 = (state_19503[(2)]);
var inst_19469 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19503__$1 = (function (){var statearr_19521 = state_19503;
(statearr_19521[(12)] = inst_19468);

return statearr_19521;
})();
var statearr_19522_19550 = state_19503__$1;
(statearr_19522_19550[(2)] = inst_19469);

(statearr_19522_19550[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (9))){
var inst_19464 = (state_19503[(8)]);
var _ = (function (){var statearr_19523 = state_19503;
(statearr_19523[(4)] = cljs.core.cons.call(null,(12),(state_19503[(4)])));

return statearr_19523;
})();
var inst_19475 = chs__$1.call(null,inst_19464);
var inst_19476 = done.call(null,inst_19464);
var inst_19477 = cljs.core.async.take_BANG_.call(null,inst_19475,inst_19476);
var ___$1 = (function (){var statearr_19524 = state_19503;
(statearr_19524[(4)] = cljs.core.rest.call(null,(state_19503[(4)])));

return statearr_19524;
})();
var state_19503__$1 = state_19503;
var statearr_19525_19551 = state_19503__$1;
(statearr_19525_19551[(2)] = inst_19477);

(statearr_19525_19551[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (5))){
var inst_19487 = (state_19503[(2)]);
var state_19503__$1 = (function (){var statearr_19526 = state_19503;
(statearr_19526[(13)] = inst_19487);

return statearr_19526;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19503__$1,(13),dchan);
} else {
if((state_val_19504 === (14))){
var inst_19492 = cljs.core.async.close_BANG_.call(null,out);
var state_19503__$1 = state_19503;
var statearr_19527_19552 = state_19503__$1;
(statearr_19527_19552[(2)] = inst_19492);

(statearr_19527_19552[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (16))){
var inst_19499 = (state_19503[(2)]);
var state_19503__$1 = state_19503;
var statearr_19528_19553 = state_19503__$1;
(statearr_19528_19553[(2)] = inst_19499);

(statearr_19528_19553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (10))){
var inst_19464 = (state_19503[(8)]);
var inst_19480 = (state_19503[(2)]);
var inst_19481 = (inst_19464 + (1));
var inst_19464__$1 = inst_19481;
var state_19503__$1 = (function (){var statearr_19529 = state_19503;
(statearr_19529[(14)] = inst_19480);

(statearr_19529[(8)] = inst_19464__$1);

return statearr_19529;
})();
var statearr_19530_19554 = state_19503__$1;
(statearr_19530_19554[(2)] = null);

(statearr_19530_19554[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19504 === (8))){
var inst_19485 = (state_19503[(2)]);
var state_19503__$1 = state_19503;
var statearr_19531_19555 = state_19503__$1;
(statearr_19531_19555[(2)] = inst_19485);

(statearr_19531_19555[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16221__auto__ = null;
var cljs$core$async$state_machine__16221__auto____0 = (function (){
var statearr_19532 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19532[(0)] = cljs$core$async$state_machine__16221__auto__);

(statearr_19532[(1)] = (1));

return statearr_19532;
});
var cljs$core$async$state_machine__16221__auto____1 = (function (state_19503){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_19503);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e19533){var ex__16224__auto__ = e19533;
var statearr_19534_19556 = state_19503;
(statearr_19534_19556[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_19503[(4)]))){
var statearr_19535_19557 = state_19503;
(statearr_19535_19557[(1)] = cljs.core.first.call(null,(state_19503[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19558 = state_19503;
state_19503 = G__19558;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$state_machine__16221__auto__ = function(state_19503){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16221__auto____1.call(this,state_19503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16221__auto____0;
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16221__auto____1;
return cljs$core$async$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_19536 = f__16346__auto__.call(null);
(statearr_19536[(6)] = c__16345__auto___19538);

return statearr_19536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__19561 = arguments.length;
switch (G__19561) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16345__auto___19616 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_19593){
var state_val_19594 = (state_19593[(1)]);
if((state_val_19594 === (7))){
var inst_19572 = (state_19593[(7)]);
var inst_19573 = (state_19593[(8)]);
var inst_19572__$1 = (state_19593[(2)]);
var inst_19573__$1 = cljs.core.nth.call(null,inst_19572__$1,(0),null);
var inst_19574 = cljs.core.nth.call(null,inst_19572__$1,(1),null);
var inst_19575 = (inst_19573__$1 == null);
var state_19593__$1 = (function (){var statearr_19595 = state_19593;
(statearr_19595[(9)] = inst_19574);

(statearr_19595[(7)] = inst_19572__$1);

(statearr_19595[(8)] = inst_19573__$1);

return statearr_19595;
})();
if(cljs.core.truth_(inst_19575)){
var statearr_19596_19617 = state_19593__$1;
(statearr_19596_19617[(1)] = (8));

} else {
var statearr_19597_19618 = state_19593__$1;
(statearr_19597_19618[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19594 === (1))){
var inst_19562 = cljs.core.vec.call(null,chs);
var inst_19563 = inst_19562;
var state_19593__$1 = (function (){var statearr_19598 = state_19593;
(statearr_19598[(10)] = inst_19563);

return statearr_19598;
})();
var statearr_19599_19619 = state_19593__$1;
(statearr_19599_19619[(2)] = null);

(statearr_19599_19619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19594 === (4))){
var inst_19563 = (state_19593[(10)]);
var state_19593__$1 = state_19593;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19593__$1,(7),inst_19563);
} else {
if((state_val_19594 === (6))){
var inst_19589 = (state_19593[(2)]);
var state_19593__$1 = state_19593;
var statearr_19600_19620 = state_19593__$1;
(statearr_19600_19620[(2)] = inst_19589);

(statearr_19600_19620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19594 === (3))){
var inst_19591 = (state_19593[(2)]);
var state_19593__$1 = state_19593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19593__$1,inst_19591);
} else {
if((state_val_19594 === (2))){
var inst_19563 = (state_19593[(10)]);
var inst_19565 = cljs.core.count.call(null,inst_19563);
var inst_19566 = (inst_19565 > (0));
var state_19593__$1 = state_19593;
if(cljs.core.truth_(inst_19566)){
var statearr_19602_19621 = state_19593__$1;
(statearr_19602_19621[(1)] = (4));

} else {
var statearr_19603_19622 = state_19593__$1;
(statearr_19603_19622[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19594 === (11))){
var inst_19563 = (state_19593[(10)]);
var inst_19582 = (state_19593[(2)]);
var tmp19601 = inst_19563;
var inst_19563__$1 = tmp19601;
var state_19593__$1 = (function (){var statearr_19604 = state_19593;
(statearr_19604[(10)] = inst_19563__$1);

(statearr_19604[(11)] = inst_19582);

return statearr_19604;
})();
var statearr_19605_19623 = state_19593__$1;
(statearr_19605_19623[(2)] = null);

(statearr_19605_19623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19594 === (9))){
var inst_19573 = (state_19593[(8)]);
var state_19593__$1 = state_19593;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19593__$1,(11),out,inst_19573);
} else {
if((state_val_19594 === (5))){
var inst_19587 = cljs.core.async.close_BANG_.call(null,out);
var state_19593__$1 = state_19593;
var statearr_19606_19624 = state_19593__$1;
(statearr_19606_19624[(2)] = inst_19587);

(statearr_19606_19624[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19594 === (10))){
var inst_19585 = (state_19593[(2)]);
var state_19593__$1 = state_19593;
var statearr_19607_19625 = state_19593__$1;
(statearr_19607_19625[(2)] = inst_19585);

(statearr_19607_19625[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19594 === (8))){
var inst_19574 = (state_19593[(9)]);
var inst_19563 = (state_19593[(10)]);
var inst_19572 = (state_19593[(7)]);
var inst_19573 = (state_19593[(8)]);
var inst_19577 = (function (){var cs = inst_19563;
var vec__19568 = inst_19572;
var v = inst_19573;
var c = inst_19574;
return (function (p1__19559_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19559_SHARP_);
});
})();
var inst_19578 = cljs.core.filterv.call(null,inst_19577,inst_19563);
var inst_19563__$1 = inst_19578;
var state_19593__$1 = (function (){var statearr_19608 = state_19593;
(statearr_19608[(10)] = inst_19563__$1);

return statearr_19608;
})();
var statearr_19609_19626 = state_19593__$1;
(statearr_19609_19626[(2)] = null);

(statearr_19609_19626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16221__auto__ = null;
var cljs$core$async$state_machine__16221__auto____0 = (function (){
var statearr_19610 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19610[(0)] = cljs$core$async$state_machine__16221__auto__);

(statearr_19610[(1)] = (1));

return statearr_19610;
});
var cljs$core$async$state_machine__16221__auto____1 = (function (state_19593){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_19593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e19611){var ex__16224__auto__ = e19611;
var statearr_19612_19627 = state_19593;
(statearr_19612_19627[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_19593[(4)]))){
var statearr_19613_19628 = state_19593;
(statearr_19613_19628[(1)] = cljs.core.first.call(null,(state_19593[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19629 = state_19593;
state_19593 = G__19629;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$state_machine__16221__auto__ = function(state_19593){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16221__auto____1.call(this,state_19593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16221__auto____0;
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16221__auto____1;
return cljs$core$async$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_19614 = f__16346__auto__.call(null);
(statearr_19614[(6)] = c__16345__auto___19616);

return statearr_19614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__19631 = arguments.length;
switch (G__19631) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16345__auto___19677 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_19655){
var state_val_19656 = (state_19655[(1)]);
if((state_val_19656 === (7))){
var inst_19637 = (state_19655[(7)]);
var inst_19637__$1 = (state_19655[(2)]);
var inst_19638 = (inst_19637__$1 == null);
var inst_19639 = cljs.core.not.call(null,inst_19638);
var state_19655__$1 = (function (){var statearr_19657 = state_19655;
(statearr_19657[(7)] = inst_19637__$1);

return statearr_19657;
})();
if(inst_19639){
var statearr_19658_19678 = state_19655__$1;
(statearr_19658_19678[(1)] = (8));

} else {
var statearr_19659_19679 = state_19655__$1;
(statearr_19659_19679[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19656 === (1))){
var inst_19632 = (0);
var state_19655__$1 = (function (){var statearr_19660 = state_19655;
(statearr_19660[(8)] = inst_19632);

return statearr_19660;
})();
var statearr_19661_19680 = state_19655__$1;
(statearr_19661_19680[(2)] = null);

(statearr_19661_19680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19656 === (4))){
var state_19655__$1 = state_19655;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19655__$1,(7),ch);
} else {
if((state_val_19656 === (6))){
var inst_19650 = (state_19655[(2)]);
var state_19655__$1 = state_19655;
var statearr_19662_19681 = state_19655__$1;
(statearr_19662_19681[(2)] = inst_19650);

(statearr_19662_19681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19656 === (3))){
var inst_19652 = (state_19655[(2)]);
var inst_19653 = cljs.core.async.close_BANG_.call(null,out);
var state_19655__$1 = (function (){var statearr_19663 = state_19655;
(statearr_19663[(9)] = inst_19652);

return statearr_19663;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19655__$1,inst_19653);
} else {
if((state_val_19656 === (2))){
var inst_19632 = (state_19655[(8)]);
var inst_19634 = (inst_19632 < n);
var state_19655__$1 = state_19655;
if(cljs.core.truth_(inst_19634)){
var statearr_19664_19682 = state_19655__$1;
(statearr_19664_19682[(1)] = (4));

} else {
var statearr_19665_19683 = state_19655__$1;
(statearr_19665_19683[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19656 === (11))){
var inst_19632 = (state_19655[(8)]);
var inst_19642 = (state_19655[(2)]);
var inst_19643 = (inst_19632 + (1));
var inst_19632__$1 = inst_19643;
var state_19655__$1 = (function (){var statearr_19666 = state_19655;
(statearr_19666[(8)] = inst_19632__$1);

(statearr_19666[(10)] = inst_19642);

return statearr_19666;
})();
var statearr_19667_19684 = state_19655__$1;
(statearr_19667_19684[(2)] = null);

(statearr_19667_19684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19656 === (9))){
var state_19655__$1 = state_19655;
var statearr_19668_19685 = state_19655__$1;
(statearr_19668_19685[(2)] = null);

(statearr_19668_19685[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19656 === (5))){
var state_19655__$1 = state_19655;
var statearr_19669_19686 = state_19655__$1;
(statearr_19669_19686[(2)] = null);

(statearr_19669_19686[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19656 === (10))){
var inst_19647 = (state_19655[(2)]);
var state_19655__$1 = state_19655;
var statearr_19670_19687 = state_19655__$1;
(statearr_19670_19687[(2)] = inst_19647);

(statearr_19670_19687[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19656 === (8))){
var inst_19637 = (state_19655[(7)]);
var state_19655__$1 = state_19655;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19655__$1,(11),out,inst_19637);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16221__auto__ = null;
var cljs$core$async$state_machine__16221__auto____0 = (function (){
var statearr_19671 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19671[(0)] = cljs$core$async$state_machine__16221__auto__);

(statearr_19671[(1)] = (1));

return statearr_19671;
});
var cljs$core$async$state_machine__16221__auto____1 = (function (state_19655){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_19655);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e19672){var ex__16224__auto__ = e19672;
var statearr_19673_19688 = state_19655;
(statearr_19673_19688[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_19655[(4)]))){
var statearr_19674_19689 = state_19655;
(statearr_19674_19689[(1)] = cljs.core.first.call(null,(state_19655[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19690 = state_19655;
state_19655 = G__19690;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$state_machine__16221__auto__ = function(state_19655){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16221__auto____1.call(this,state_19655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16221__auto____0;
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16221__auto____1;
return cljs$core$async$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_19675 = f__16346__auto__.call(null);
(statearr_19675[(6)] = c__16345__auto___19677);

return statearr_19675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async19692 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19692 = (function (f,ch,meta19693){
this.f = f;
this.ch = ch;
this.meta19693 = meta19693;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async19692.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19694,meta19693__$1){
var self__ = this;
var _19694__$1 = this;
return (new cljs.core.async.t_cljs$core$async19692(self__.f,self__.ch,meta19693__$1));
}));

(cljs.core.async.t_cljs$core$async19692.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19694){
var self__ = this;
var _19694__$1 = this;
return self__.meta19693;
}));

(cljs.core.async.t_cljs$core$async19692.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19692.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async19692.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async19692.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19692.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async19695 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19695 = (function (f,ch,meta19693,_,fn1,meta19696){
this.f = f;
this.ch = ch;
this.meta19693 = meta19693;
this._ = _;
this.fn1 = fn1;
this.meta19696 = meta19696;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async19695.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19697,meta19696__$1){
var self__ = this;
var _19697__$1 = this;
return (new cljs.core.async.t_cljs$core$async19695(self__.f,self__.ch,self__.meta19693,self__._,self__.fn1,meta19696__$1));
}));

(cljs.core.async.t_cljs$core$async19695.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19697){
var self__ = this;
var _19697__$1 = this;
return self__.meta19696;
}));

(cljs.core.async.t_cljs$core$async19695.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19695.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async19695.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async19695.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__19691_SHARP_){
return f1.call(null,(((p1__19691_SHARP_ == null))?null:self__.f.call(null,p1__19691_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async19695.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19693","meta19693",486981801,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19692","cljs.core.async/t_cljs$core$async19692",968502166,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19696","meta19696",1413168498,null)], null);
}));

(cljs.core.async.t_cljs$core$async19695.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async19695.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19695");

(cljs.core.async.t_cljs$core$async19695.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write.call(null,writer__4451__auto__,"cljs.core.async/t_cljs$core$async19695");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async19695.
 */
cljs.core.async.__GT_t_cljs$core$async19695 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19695(f__$1,ch__$1,meta19693__$1,___$2,fn1__$1,meta19696){
return (new cljs.core.async.t_cljs$core$async19695(f__$1,ch__$1,meta19693__$1,___$2,fn1__$1,meta19696));
});

}

return (new cljs.core.async.t_cljs$core$async19695(self__.f,self__.ch,self__.meta19693,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4210__auto__ = ret;
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4210__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async19692.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19692.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async19692.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19693","meta19693",486981801,null)], null);
}));

(cljs.core.async.t_cljs$core$async19692.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async19692.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19692");

(cljs.core.async.t_cljs$core$async19692.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write.call(null,writer__4451__auto__,"cljs.core.async/t_cljs$core$async19692");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async19692.
 */
cljs.core.async.__GT_t_cljs$core$async19692 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19692(f__$1,ch__$1,meta19693){
return (new cljs.core.async.t_cljs$core$async19692(f__$1,ch__$1,meta19693));
});

}

return (new cljs.core.async.t_cljs$core$async19692(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async19698 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19698 = (function (f,ch,meta19699){
this.f = f;
this.ch = ch;
this.meta19699 = meta19699;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async19698.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19700,meta19699__$1){
var self__ = this;
var _19700__$1 = this;
return (new cljs.core.async.t_cljs$core$async19698(self__.f,self__.ch,meta19699__$1));
}));

(cljs.core.async.t_cljs$core$async19698.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19700){
var self__ = this;
var _19700__$1 = this;
return self__.meta19699;
}));

(cljs.core.async.t_cljs$core$async19698.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19698.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async19698.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19698.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async19698.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19698.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async19698.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19699","meta19699",-585450043,null)], null);
}));

(cljs.core.async.t_cljs$core$async19698.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async19698.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19698");

(cljs.core.async.t_cljs$core$async19698.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write.call(null,writer__4451__auto__,"cljs.core.async/t_cljs$core$async19698");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async19698.
 */
cljs.core.async.__GT_t_cljs$core$async19698 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19698(f__$1,ch__$1,meta19699){
return (new cljs.core.async.t_cljs$core$async19698(f__$1,ch__$1,meta19699));
});

}

return (new cljs.core.async.t_cljs$core$async19698(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async19701 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19701 = (function (p,ch,meta19702){
this.p = p;
this.ch = ch;
this.meta19702 = meta19702;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async19701.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19703,meta19702__$1){
var self__ = this;
var _19703__$1 = this;
return (new cljs.core.async.t_cljs$core$async19701(self__.p,self__.ch,meta19702__$1));
}));

(cljs.core.async.t_cljs$core$async19701.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19703){
var self__ = this;
var _19703__$1 = this;
return self__.meta19702;
}));

(cljs.core.async.t_cljs$core$async19701.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19701.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async19701.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async19701.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19701.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async19701.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19701.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async19701.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19702","meta19702",-1360358125,null)], null);
}));

(cljs.core.async.t_cljs$core$async19701.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async19701.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19701");

(cljs.core.async.t_cljs$core$async19701.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write.call(null,writer__4451__auto__,"cljs.core.async/t_cljs$core$async19701");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async19701.
 */
cljs.core.async.__GT_t_cljs$core$async19701 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19701(p__$1,ch__$1,meta19702){
return (new cljs.core.async.t_cljs$core$async19701(p__$1,ch__$1,meta19702));
});

}

return (new cljs.core.async.t_cljs$core$async19701(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__19705 = arguments.length;
switch (G__19705) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16345__auto___19746 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_19726){
var state_val_19727 = (state_19726[(1)]);
if((state_val_19727 === (7))){
var inst_19722 = (state_19726[(2)]);
var state_19726__$1 = state_19726;
var statearr_19728_19747 = state_19726__$1;
(statearr_19728_19747[(2)] = inst_19722);

(statearr_19728_19747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19727 === (1))){
var state_19726__$1 = state_19726;
var statearr_19729_19748 = state_19726__$1;
(statearr_19729_19748[(2)] = null);

(statearr_19729_19748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19727 === (4))){
var inst_19708 = (state_19726[(7)]);
var inst_19708__$1 = (state_19726[(2)]);
var inst_19709 = (inst_19708__$1 == null);
var state_19726__$1 = (function (){var statearr_19730 = state_19726;
(statearr_19730[(7)] = inst_19708__$1);

return statearr_19730;
})();
if(cljs.core.truth_(inst_19709)){
var statearr_19731_19749 = state_19726__$1;
(statearr_19731_19749[(1)] = (5));

} else {
var statearr_19732_19750 = state_19726__$1;
(statearr_19732_19750[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19727 === (6))){
var inst_19708 = (state_19726[(7)]);
var inst_19713 = p.call(null,inst_19708);
var state_19726__$1 = state_19726;
if(cljs.core.truth_(inst_19713)){
var statearr_19733_19751 = state_19726__$1;
(statearr_19733_19751[(1)] = (8));

} else {
var statearr_19734_19752 = state_19726__$1;
(statearr_19734_19752[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19727 === (3))){
var inst_19724 = (state_19726[(2)]);
var state_19726__$1 = state_19726;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19726__$1,inst_19724);
} else {
if((state_val_19727 === (2))){
var state_19726__$1 = state_19726;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19726__$1,(4),ch);
} else {
if((state_val_19727 === (11))){
var inst_19716 = (state_19726[(2)]);
var state_19726__$1 = state_19726;
var statearr_19735_19753 = state_19726__$1;
(statearr_19735_19753[(2)] = inst_19716);

(statearr_19735_19753[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19727 === (9))){
var state_19726__$1 = state_19726;
var statearr_19736_19754 = state_19726__$1;
(statearr_19736_19754[(2)] = null);

(statearr_19736_19754[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19727 === (5))){
var inst_19711 = cljs.core.async.close_BANG_.call(null,out);
var state_19726__$1 = state_19726;
var statearr_19737_19755 = state_19726__$1;
(statearr_19737_19755[(2)] = inst_19711);

(statearr_19737_19755[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19727 === (10))){
var inst_19719 = (state_19726[(2)]);
var state_19726__$1 = (function (){var statearr_19738 = state_19726;
(statearr_19738[(8)] = inst_19719);

return statearr_19738;
})();
var statearr_19739_19756 = state_19726__$1;
(statearr_19739_19756[(2)] = null);

(statearr_19739_19756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19727 === (8))){
var inst_19708 = (state_19726[(7)]);
var state_19726__$1 = state_19726;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19726__$1,(11),out,inst_19708);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16221__auto__ = null;
var cljs$core$async$state_machine__16221__auto____0 = (function (){
var statearr_19740 = [null,null,null,null,null,null,null,null,null];
(statearr_19740[(0)] = cljs$core$async$state_machine__16221__auto__);

(statearr_19740[(1)] = (1));

return statearr_19740;
});
var cljs$core$async$state_machine__16221__auto____1 = (function (state_19726){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_19726);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e19741){var ex__16224__auto__ = e19741;
var statearr_19742_19757 = state_19726;
(statearr_19742_19757[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_19726[(4)]))){
var statearr_19743_19758 = state_19726;
(statearr_19743_19758[(1)] = cljs.core.first.call(null,(state_19726[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19759 = state_19726;
state_19726 = G__19759;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$state_machine__16221__auto__ = function(state_19726){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16221__auto____1.call(this,state_19726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16221__auto____0;
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16221__auto____1;
return cljs$core$async$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_19744 = f__16346__auto__.call(null);
(statearr_19744[(6)] = c__16345__auto___19746);

return statearr_19744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__19761 = arguments.length;
switch (G__19761) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_19824){
var state_val_19825 = (state_19824[(1)]);
if((state_val_19825 === (7))){
var inst_19820 = (state_19824[(2)]);
var state_19824__$1 = state_19824;
var statearr_19826_19865 = state_19824__$1;
(statearr_19826_19865[(2)] = inst_19820);

(statearr_19826_19865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (20))){
var inst_19790 = (state_19824[(7)]);
var inst_19801 = (state_19824[(2)]);
var inst_19802 = cljs.core.next.call(null,inst_19790);
var inst_19776 = inst_19802;
var inst_19777 = null;
var inst_19778 = (0);
var inst_19779 = (0);
var state_19824__$1 = (function (){var statearr_19827 = state_19824;
(statearr_19827[(8)] = inst_19778);

(statearr_19827[(9)] = inst_19779);

(statearr_19827[(10)] = inst_19776);

(statearr_19827[(11)] = inst_19777);

(statearr_19827[(12)] = inst_19801);

return statearr_19827;
})();
var statearr_19828_19866 = state_19824__$1;
(statearr_19828_19866[(2)] = null);

(statearr_19828_19866[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (1))){
var state_19824__$1 = state_19824;
var statearr_19829_19867 = state_19824__$1;
(statearr_19829_19867[(2)] = null);

(statearr_19829_19867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (4))){
var inst_19765 = (state_19824[(13)]);
var inst_19765__$1 = (state_19824[(2)]);
var inst_19766 = (inst_19765__$1 == null);
var state_19824__$1 = (function (){var statearr_19830 = state_19824;
(statearr_19830[(13)] = inst_19765__$1);

return statearr_19830;
})();
if(cljs.core.truth_(inst_19766)){
var statearr_19831_19868 = state_19824__$1;
(statearr_19831_19868[(1)] = (5));

} else {
var statearr_19832_19869 = state_19824__$1;
(statearr_19832_19869[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (15))){
var state_19824__$1 = state_19824;
var statearr_19836_19870 = state_19824__$1;
(statearr_19836_19870[(2)] = null);

(statearr_19836_19870[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (21))){
var state_19824__$1 = state_19824;
var statearr_19837_19871 = state_19824__$1;
(statearr_19837_19871[(2)] = null);

(statearr_19837_19871[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (13))){
var inst_19778 = (state_19824[(8)]);
var inst_19779 = (state_19824[(9)]);
var inst_19776 = (state_19824[(10)]);
var inst_19777 = (state_19824[(11)]);
var inst_19786 = (state_19824[(2)]);
var inst_19787 = (inst_19779 + (1));
var tmp19833 = inst_19778;
var tmp19834 = inst_19776;
var tmp19835 = inst_19777;
var inst_19776__$1 = tmp19834;
var inst_19777__$1 = tmp19835;
var inst_19778__$1 = tmp19833;
var inst_19779__$1 = inst_19787;
var state_19824__$1 = (function (){var statearr_19838 = state_19824;
(statearr_19838[(8)] = inst_19778__$1);

(statearr_19838[(9)] = inst_19779__$1);

(statearr_19838[(10)] = inst_19776__$1);

(statearr_19838[(14)] = inst_19786);

(statearr_19838[(11)] = inst_19777__$1);

return statearr_19838;
})();
var statearr_19839_19872 = state_19824__$1;
(statearr_19839_19872[(2)] = null);

(statearr_19839_19872[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (22))){
var state_19824__$1 = state_19824;
var statearr_19840_19873 = state_19824__$1;
(statearr_19840_19873[(2)] = null);

(statearr_19840_19873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (6))){
var inst_19765 = (state_19824[(13)]);
var inst_19774 = f.call(null,inst_19765);
var inst_19775 = cljs.core.seq.call(null,inst_19774);
var inst_19776 = inst_19775;
var inst_19777 = null;
var inst_19778 = (0);
var inst_19779 = (0);
var state_19824__$1 = (function (){var statearr_19841 = state_19824;
(statearr_19841[(8)] = inst_19778);

(statearr_19841[(9)] = inst_19779);

(statearr_19841[(10)] = inst_19776);

(statearr_19841[(11)] = inst_19777);

return statearr_19841;
})();
var statearr_19842_19874 = state_19824__$1;
(statearr_19842_19874[(2)] = null);

(statearr_19842_19874[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (17))){
var inst_19790 = (state_19824[(7)]);
var inst_19794 = cljs.core.chunk_first.call(null,inst_19790);
var inst_19795 = cljs.core.chunk_rest.call(null,inst_19790);
var inst_19796 = cljs.core.count.call(null,inst_19794);
var inst_19776 = inst_19795;
var inst_19777 = inst_19794;
var inst_19778 = inst_19796;
var inst_19779 = (0);
var state_19824__$1 = (function (){var statearr_19843 = state_19824;
(statearr_19843[(8)] = inst_19778);

(statearr_19843[(9)] = inst_19779);

(statearr_19843[(10)] = inst_19776);

(statearr_19843[(11)] = inst_19777);

return statearr_19843;
})();
var statearr_19844_19875 = state_19824__$1;
(statearr_19844_19875[(2)] = null);

(statearr_19844_19875[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (3))){
var inst_19822 = (state_19824[(2)]);
var state_19824__$1 = state_19824;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19824__$1,inst_19822);
} else {
if((state_val_19825 === (12))){
var inst_19810 = (state_19824[(2)]);
var state_19824__$1 = state_19824;
var statearr_19845_19876 = state_19824__$1;
(statearr_19845_19876[(2)] = inst_19810);

(statearr_19845_19876[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (2))){
var state_19824__$1 = state_19824;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19824__$1,(4),in$);
} else {
if((state_val_19825 === (23))){
var inst_19818 = (state_19824[(2)]);
var state_19824__$1 = state_19824;
var statearr_19846_19877 = state_19824__$1;
(statearr_19846_19877[(2)] = inst_19818);

(statearr_19846_19877[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (19))){
var inst_19805 = (state_19824[(2)]);
var state_19824__$1 = state_19824;
var statearr_19847_19878 = state_19824__$1;
(statearr_19847_19878[(2)] = inst_19805);

(statearr_19847_19878[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (11))){
var inst_19776 = (state_19824[(10)]);
var inst_19790 = (state_19824[(7)]);
var inst_19790__$1 = cljs.core.seq.call(null,inst_19776);
var state_19824__$1 = (function (){var statearr_19848 = state_19824;
(statearr_19848[(7)] = inst_19790__$1);

return statearr_19848;
})();
if(inst_19790__$1){
var statearr_19849_19879 = state_19824__$1;
(statearr_19849_19879[(1)] = (14));

} else {
var statearr_19850_19880 = state_19824__$1;
(statearr_19850_19880[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (9))){
var inst_19812 = (state_19824[(2)]);
var inst_19813 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19824__$1 = (function (){var statearr_19851 = state_19824;
(statearr_19851[(15)] = inst_19812);

return statearr_19851;
})();
if(cljs.core.truth_(inst_19813)){
var statearr_19852_19881 = state_19824__$1;
(statearr_19852_19881[(1)] = (21));

} else {
var statearr_19853_19882 = state_19824__$1;
(statearr_19853_19882[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (5))){
var inst_19768 = cljs.core.async.close_BANG_.call(null,out);
var state_19824__$1 = state_19824;
var statearr_19854_19883 = state_19824__$1;
(statearr_19854_19883[(2)] = inst_19768);

(statearr_19854_19883[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (14))){
var inst_19790 = (state_19824[(7)]);
var inst_19792 = cljs.core.chunked_seq_QMARK_.call(null,inst_19790);
var state_19824__$1 = state_19824;
if(inst_19792){
var statearr_19855_19884 = state_19824__$1;
(statearr_19855_19884[(1)] = (17));

} else {
var statearr_19856_19885 = state_19824__$1;
(statearr_19856_19885[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (16))){
var inst_19808 = (state_19824[(2)]);
var state_19824__$1 = state_19824;
var statearr_19857_19886 = state_19824__$1;
(statearr_19857_19886[(2)] = inst_19808);

(statearr_19857_19886[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19825 === (10))){
var inst_19779 = (state_19824[(9)]);
var inst_19777 = (state_19824[(11)]);
var inst_19784 = cljs.core._nth.call(null,inst_19777,inst_19779);
var state_19824__$1 = state_19824;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19824__$1,(13),out,inst_19784);
} else {
if((state_val_19825 === (18))){
var inst_19790 = (state_19824[(7)]);
var inst_19799 = cljs.core.first.call(null,inst_19790);
var state_19824__$1 = state_19824;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19824__$1,(20),out,inst_19799);
} else {
if((state_val_19825 === (8))){
var inst_19778 = (state_19824[(8)]);
var inst_19779 = (state_19824[(9)]);
var inst_19781 = (inst_19779 < inst_19778);
var inst_19782 = inst_19781;
var state_19824__$1 = state_19824;
if(cljs.core.truth_(inst_19782)){
var statearr_19858_19887 = state_19824__$1;
(statearr_19858_19887[(1)] = (10));

} else {
var statearr_19859_19888 = state_19824__$1;
(statearr_19859_19888[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16221__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16221__auto____0 = (function (){
var statearr_19860 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19860[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16221__auto__);

(statearr_19860[(1)] = (1));

return statearr_19860;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16221__auto____1 = (function (state_19824){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_19824);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e19861){var ex__16224__auto__ = e19861;
var statearr_19862_19889 = state_19824;
(statearr_19862_19889[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_19824[(4)]))){
var statearr_19863_19890 = state_19824;
(statearr_19863_19890[(1)] = cljs.core.first.call(null,(state_19824[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19891 = state_19824;
state_19824 = G__19891;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16221__auto__ = function(state_19824){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16221__auto____1.call(this,state_19824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16221__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16221__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_19864 = f__16346__auto__.call(null);
(statearr_19864[(6)] = c__16345__auto__);

return statearr_19864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__19893 = arguments.length;
switch (G__19893) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__19896 = arguments.length;
switch (G__19896) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__19899 = arguments.length;
switch (G__19899) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16345__auto___19947 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_19923){
var state_val_19924 = (state_19923[(1)]);
if((state_val_19924 === (7))){
var inst_19918 = (state_19923[(2)]);
var state_19923__$1 = state_19923;
var statearr_19925_19948 = state_19923__$1;
(statearr_19925_19948[(2)] = inst_19918);

(statearr_19925_19948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19924 === (1))){
var inst_19900 = null;
var state_19923__$1 = (function (){var statearr_19926 = state_19923;
(statearr_19926[(7)] = inst_19900);

return statearr_19926;
})();
var statearr_19927_19949 = state_19923__$1;
(statearr_19927_19949[(2)] = null);

(statearr_19927_19949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19924 === (4))){
var inst_19903 = (state_19923[(8)]);
var inst_19903__$1 = (state_19923[(2)]);
var inst_19904 = (inst_19903__$1 == null);
var inst_19905 = cljs.core.not.call(null,inst_19904);
var state_19923__$1 = (function (){var statearr_19928 = state_19923;
(statearr_19928[(8)] = inst_19903__$1);

return statearr_19928;
})();
if(inst_19905){
var statearr_19929_19950 = state_19923__$1;
(statearr_19929_19950[(1)] = (5));

} else {
var statearr_19930_19951 = state_19923__$1;
(statearr_19930_19951[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19924 === (6))){
var state_19923__$1 = state_19923;
var statearr_19931_19952 = state_19923__$1;
(statearr_19931_19952[(2)] = null);

(statearr_19931_19952[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19924 === (3))){
var inst_19920 = (state_19923[(2)]);
var inst_19921 = cljs.core.async.close_BANG_.call(null,out);
var state_19923__$1 = (function (){var statearr_19932 = state_19923;
(statearr_19932[(9)] = inst_19920);

return statearr_19932;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19923__$1,inst_19921);
} else {
if((state_val_19924 === (2))){
var state_19923__$1 = state_19923;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19923__$1,(4),ch);
} else {
if((state_val_19924 === (11))){
var inst_19903 = (state_19923[(8)]);
var inst_19912 = (state_19923[(2)]);
var inst_19900 = inst_19903;
var state_19923__$1 = (function (){var statearr_19933 = state_19923;
(statearr_19933[(10)] = inst_19912);

(statearr_19933[(7)] = inst_19900);

return statearr_19933;
})();
var statearr_19934_19953 = state_19923__$1;
(statearr_19934_19953[(2)] = null);

(statearr_19934_19953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19924 === (9))){
var inst_19903 = (state_19923[(8)]);
var state_19923__$1 = state_19923;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19923__$1,(11),out,inst_19903);
} else {
if((state_val_19924 === (5))){
var inst_19903 = (state_19923[(8)]);
var inst_19900 = (state_19923[(7)]);
var inst_19907 = cljs.core._EQ_.call(null,inst_19903,inst_19900);
var state_19923__$1 = state_19923;
if(inst_19907){
var statearr_19936_19954 = state_19923__$1;
(statearr_19936_19954[(1)] = (8));

} else {
var statearr_19937_19955 = state_19923__$1;
(statearr_19937_19955[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19924 === (10))){
var inst_19915 = (state_19923[(2)]);
var state_19923__$1 = state_19923;
var statearr_19938_19956 = state_19923__$1;
(statearr_19938_19956[(2)] = inst_19915);

(statearr_19938_19956[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19924 === (8))){
var inst_19900 = (state_19923[(7)]);
var tmp19935 = inst_19900;
var inst_19900__$1 = tmp19935;
var state_19923__$1 = (function (){var statearr_19939 = state_19923;
(statearr_19939[(7)] = inst_19900__$1);

return statearr_19939;
})();
var statearr_19940_19957 = state_19923__$1;
(statearr_19940_19957[(2)] = null);

(statearr_19940_19957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16221__auto__ = null;
var cljs$core$async$state_machine__16221__auto____0 = (function (){
var statearr_19941 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19941[(0)] = cljs$core$async$state_machine__16221__auto__);

(statearr_19941[(1)] = (1));

return statearr_19941;
});
var cljs$core$async$state_machine__16221__auto____1 = (function (state_19923){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_19923);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e19942){var ex__16224__auto__ = e19942;
var statearr_19943_19958 = state_19923;
(statearr_19943_19958[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_19923[(4)]))){
var statearr_19944_19959 = state_19923;
(statearr_19944_19959[(1)] = cljs.core.first.call(null,(state_19923[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19960 = state_19923;
state_19923 = G__19960;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$state_machine__16221__auto__ = function(state_19923){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16221__auto____1.call(this,state_19923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16221__auto____0;
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16221__auto____1;
return cljs$core$async$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_19945 = f__16346__auto__.call(null);
(statearr_19945[(6)] = c__16345__auto___19947);

return statearr_19945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__19962 = arguments.length;
switch (G__19962) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16345__auto___20029 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_20000){
var state_val_20001 = (state_20000[(1)]);
if((state_val_20001 === (7))){
var inst_19996 = (state_20000[(2)]);
var state_20000__$1 = state_20000;
var statearr_20002_20030 = state_20000__$1;
(statearr_20002_20030[(2)] = inst_19996);

(statearr_20002_20030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20001 === (1))){
var inst_19963 = (new Array(n));
var inst_19964 = inst_19963;
var inst_19965 = (0);
var state_20000__$1 = (function (){var statearr_20003 = state_20000;
(statearr_20003[(7)] = inst_19965);

(statearr_20003[(8)] = inst_19964);

return statearr_20003;
})();
var statearr_20004_20031 = state_20000__$1;
(statearr_20004_20031[(2)] = null);

(statearr_20004_20031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20001 === (4))){
var inst_19968 = (state_20000[(9)]);
var inst_19968__$1 = (state_20000[(2)]);
var inst_19969 = (inst_19968__$1 == null);
var inst_19970 = cljs.core.not.call(null,inst_19969);
var state_20000__$1 = (function (){var statearr_20005 = state_20000;
(statearr_20005[(9)] = inst_19968__$1);

return statearr_20005;
})();
if(inst_19970){
var statearr_20006_20032 = state_20000__$1;
(statearr_20006_20032[(1)] = (5));

} else {
var statearr_20007_20033 = state_20000__$1;
(statearr_20007_20033[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20001 === (15))){
var inst_19990 = (state_20000[(2)]);
var state_20000__$1 = state_20000;
var statearr_20008_20034 = state_20000__$1;
(statearr_20008_20034[(2)] = inst_19990);

(statearr_20008_20034[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20001 === (13))){
var state_20000__$1 = state_20000;
var statearr_20009_20035 = state_20000__$1;
(statearr_20009_20035[(2)] = null);

(statearr_20009_20035[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20001 === (6))){
var inst_19965 = (state_20000[(7)]);
var inst_19986 = (inst_19965 > (0));
var state_20000__$1 = state_20000;
if(cljs.core.truth_(inst_19986)){
var statearr_20010_20036 = state_20000__$1;
(statearr_20010_20036[(1)] = (12));

} else {
var statearr_20011_20037 = state_20000__$1;
(statearr_20011_20037[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20001 === (3))){
var inst_19998 = (state_20000[(2)]);
var state_20000__$1 = state_20000;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20000__$1,inst_19998);
} else {
if((state_val_20001 === (12))){
var inst_19964 = (state_20000[(8)]);
var inst_19988 = cljs.core.vec.call(null,inst_19964);
var state_20000__$1 = state_20000;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20000__$1,(15),out,inst_19988);
} else {
if((state_val_20001 === (2))){
var state_20000__$1 = state_20000;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20000__$1,(4),ch);
} else {
if((state_val_20001 === (11))){
var inst_19980 = (state_20000[(2)]);
var inst_19981 = (new Array(n));
var inst_19964 = inst_19981;
var inst_19965 = (0);
var state_20000__$1 = (function (){var statearr_20012 = state_20000;
(statearr_20012[(7)] = inst_19965);

(statearr_20012[(8)] = inst_19964);

(statearr_20012[(10)] = inst_19980);

return statearr_20012;
})();
var statearr_20013_20038 = state_20000__$1;
(statearr_20013_20038[(2)] = null);

(statearr_20013_20038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20001 === (9))){
var inst_19964 = (state_20000[(8)]);
var inst_19978 = cljs.core.vec.call(null,inst_19964);
var state_20000__$1 = state_20000;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20000__$1,(11),out,inst_19978);
} else {
if((state_val_20001 === (5))){
var inst_19965 = (state_20000[(7)]);
var inst_19964 = (state_20000[(8)]);
var inst_19973 = (state_20000[(11)]);
var inst_19968 = (state_20000[(9)]);
var inst_19972 = (inst_19964[inst_19965] = inst_19968);
var inst_19973__$1 = (inst_19965 + (1));
var inst_19974 = (inst_19973__$1 < n);
var state_20000__$1 = (function (){var statearr_20014 = state_20000;
(statearr_20014[(12)] = inst_19972);

(statearr_20014[(11)] = inst_19973__$1);

return statearr_20014;
})();
if(cljs.core.truth_(inst_19974)){
var statearr_20015_20039 = state_20000__$1;
(statearr_20015_20039[(1)] = (8));

} else {
var statearr_20016_20040 = state_20000__$1;
(statearr_20016_20040[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20001 === (14))){
var inst_19993 = (state_20000[(2)]);
var inst_19994 = cljs.core.async.close_BANG_.call(null,out);
var state_20000__$1 = (function (){var statearr_20018 = state_20000;
(statearr_20018[(13)] = inst_19993);

return statearr_20018;
})();
var statearr_20019_20041 = state_20000__$1;
(statearr_20019_20041[(2)] = inst_19994);

(statearr_20019_20041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20001 === (10))){
var inst_19984 = (state_20000[(2)]);
var state_20000__$1 = state_20000;
var statearr_20020_20042 = state_20000__$1;
(statearr_20020_20042[(2)] = inst_19984);

(statearr_20020_20042[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20001 === (8))){
var inst_19964 = (state_20000[(8)]);
var inst_19973 = (state_20000[(11)]);
var tmp20017 = inst_19964;
var inst_19964__$1 = tmp20017;
var inst_19965 = inst_19973;
var state_20000__$1 = (function (){var statearr_20021 = state_20000;
(statearr_20021[(7)] = inst_19965);

(statearr_20021[(8)] = inst_19964__$1);

return statearr_20021;
})();
var statearr_20022_20043 = state_20000__$1;
(statearr_20022_20043[(2)] = null);

(statearr_20022_20043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16221__auto__ = null;
var cljs$core$async$state_machine__16221__auto____0 = (function (){
var statearr_20023 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20023[(0)] = cljs$core$async$state_machine__16221__auto__);

(statearr_20023[(1)] = (1));

return statearr_20023;
});
var cljs$core$async$state_machine__16221__auto____1 = (function (state_20000){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_20000);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e20024){var ex__16224__auto__ = e20024;
var statearr_20025_20044 = state_20000;
(statearr_20025_20044[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_20000[(4)]))){
var statearr_20026_20045 = state_20000;
(statearr_20026_20045[(1)] = cljs.core.first.call(null,(state_20000[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20046 = state_20000;
state_20000 = G__20046;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$state_machine__16221__auto__ = function(state_20000){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16221__auto____1.call(this,state_20000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16221__auto____0;
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16221__auto____1;
return cljs$core$async$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_20027 = f__16346__auto__.call(null);
(statearr_20027[(6)] = c__16345__auto___20029);

return statearr_20027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__20048 = arguments.length;
switch (G__20048) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16345__auto___20126 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_20093){
var state_val_20094 = (state_20093[(1)]);
if((state_val_20094 === (7))){
var inst_20089 = (state_20093[(2)]);
var state_20093__$1 = state_20093;
var statearr_20095_20127 = state_20093__$1;
(statearr_20095_20127[(2)] = inst_20089);

(statearr_20095_20127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (1))){
var inst_20049 = [];
var inst_20050 = inst_20049;
var inst_20051 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_20093__$1 = (function (){var statearr_20096 = state_20093;
(statearr_20096[(7)] = inst_20051);

(statearr_20096[(8)] = inst_20050);

return statearr_20096;
})();
var statearr_20097_20128 = state_20093__$1;
(statearr_20097_20128[(2)] = null);

(statearr_20097_20128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (4))){
var inst_20054 = (state_20093[(9)]);
var inst_20054__$1 = (state_20093[(2)]);
var inst_20055 = (inst_20054__$1 == null);
var inst_20056 = cljs.core.not.call(null,inst_20055);
var state_20093__$1 = (function (){var statearr_20098 = state_20093;
(statearr_20098[(9)] = inst_20054__$1);

return statearr_20098;
})();
if(inst_20056){
var statearr_20099_20129 = state_20093__$1;
(statearr_20099_20129[(1)] = (5));

} else {
var statearr_20100_20130 = state_20093__$1;
(statearr_20100_20130[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (15))){
var inst_20050 = (state_20093[(8)]);
var inst_20081 = cljs.core.vec.call(null,inst_20050);
var state_20093__$1 = state_20093;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20093__$1,(18),out,inst_20081);
} else {
if((state_val_20094 === (13))){
var inst_20076 = (state_20093[(2)]);
var state_20093__$1 = state_20093;
var statearr_20101_20131 = state_20093__$1;
(statearr_20101_20131[(2)] = inst_20076);

(statearr_20101_20131[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (6))){
var inst_20050 = (state_20093[(8)]);
var inst_20078 = inst_20050.length;
var inst_20079 = (inst_20078 > (0));
var state_20093__$1 = state_20093;
if(cljs.core.truth_(inst_20079)){
var statearr_20102_20132 = state_20093__$1;
(statearr_20102_20132[(1)] = (15));

} else {
var statearr_20103_20133 = state_20093__$1;
(statearr_20103_20133[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (17))){
var inst_20086 = (state_20093[(2)]);
var inst_20087 = cljs.core.async.close_BANG_.call(null,out);
var state_20093__$1 = (function (){var statearr_20104 = state_20093;
(statearr_20104[(10)] = inst_20086);

return statearr_20104;
})();
var statearr_20105_20134 = state_20093__$1;
(statearr_20105_20134[(2)] = inst_20087);

(statearr_20105_20134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (3))){
var inst_20091 = (state_20093[(2)]);
var state_20093__$1 = state_20093;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20093__$1,inst_20091);
} else {
if((state_val_20094 === (12))){
var inst_20050 = (state_20093[(8)]);
var inst_20069 = cljs.core.vec.call(null,inst_20050);
var state_20093__$1 = state_20093;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20093__$1,(14),out,inst_20069);
} else {
if((state_val_20094 === (2))){
var state_20093__$1 = state_20093;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20093__$1,(4),ch);
} else {
if((state_val_20094 === (11))){
var inst_20058 = (state_20093[(11)]);
var inst_20054 = (state_20093[(9)]);
var inst_20050 = (state_20093[(8)]);
var inst_20066 = inst_20050.push(inst_20054);
var tmp20106 = inst_20050;
var inst_20050__$1 = tmp20106;
var inst_20051 = inst_20058;
var state_20093__$1 = (function (){var statearr_20107 = state_20093;
(statearr_20107[(12)] = inst_20066);

(statearr_20107[(7)] = inst_20051);

(statearr_20107[(8)] = inst_20050__$1);

return statearr_20107;
})();
var statearr_20108_20135 = state_20093__$1;
(statearr_20108_20135[(2)] = null);

(statearr_20108_20135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (9))){
var inst_20051 = (state_20093[(7)]);
var inst_20062 = cljs.core.keyword_identical_QMARK_.call(null,inst_20051,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_20093__$1 = state_20093;
var statearr_20109_20136 = state_20093__$1;
(statearr_20109_20136[(2)] = inst_20062);

(statearr_20109_20136[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (5))){
var inst_20058 = (state_20093[(11)]);
var inst_20051 = (state_20093[(7)]);
var inst_20054 = (state_20093[(9)]);
var inst_20059 = (state_20093[(13)]);
var inst_20058__$1 = f.call(null,inst_20054);
var inst_20059__$1 = cljs.core._EQ_.call(null,inst_20058__$1,inst_20051);
var state_20093__$1 = (function (){var statearr_20110 = state_20093;
(statearr_20110[(11)] = inst_20058__$1);

(statearr_20110[(13)] = inst_20059__$1);

return statearr_20110;
})();
if(inst_20059__$1){
var statearr_20111_20137 = state_20093__$1;
(statearr_20111_20137[(1)] = (8));

} else {
var statearr_20112_20138 = state_20093__$1;
(statearr_20112_20138[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (14))){
var inst_20058 = (state_20093[(11)]);
var inst_20054 = (state_20093[(9)]);
var inst_20071 = (state_20093[(2)]);
var inst_20072 = [];
var inst_20073 = inst_20072.push(inst_20054);
var inst_20050 = inst_20072;
var inst_20051 = inst_20058;
var state_20093__$1 = (function (){var statearr_20113 = state_20093;
(statearr_20113[(14)] = inst_20073);

(statearr_20113[(15)] = inst_20071);

(statearr_20113[(7)] = inst_20051);

(statearr_20113[(8)] = inst_20050);

return statearr_20113;
})();
var statearr_20114_20139 = state_20093__$1;
(statearr_20114_20139[(2)] = null);

(statearr_20114_20139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (16))){
var state_20093__$1 = state_20093;
var statearr_20115_20140 = state_20093__$1;
(statearr_20115_20140[(2)] = null);

(statearr_20115_20140[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (10))){
var inst_20064 = (state_20093[(2)]);
var state_20093__$1 = state_20093;
if(cljs.core.truth_(inst_20064)){
var statearr_20116_20141 = state_20093__$1;
(statearr_20116_20141[(1)] = (11));

} else {
var statearr_20117_20142 = state_20093__$1;
(statearr_20117_20142[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (18))){
var inst_20083 = (state_20093[(2)]);
var state_20093__$1 = state_20093;
var statearr_20118_20143 = state_20093__$1;
(statearr_20118_20143[(2)] = inst_20083);

(statearr_20118_20143[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20094 === (8))){
var inst_20059 = (state_20093[(13)]);
var state_20093__$1 = state_20093;
var statearr_20119_20144 = state_20093__$1;
(statearr_20119_20144[(2)] = inst_20059);

(statearr_20119_20144[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16221__auto__ = null;
var cljs$core$async$state_machine__16221__auto____0 = (function (){
var statearr_20120 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20120[(0)] = cljs$core$async$state_machine__16221__auto__);

(statearr_20120[(1)] = (1));

return statearr_20120;
});
var cljs$core$async$state_machine__16221__auto____1 = (function (state_20093){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_20093);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e20121){var ex__16224__auto__ = e20121;
var statearr_20122_20145 = state_20093;
(statearr_20122_20145[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_20093[(4)]))){
var statearr_20123_20146 = state_20093;
(statearr_20123_20146[(1)] = cljs.core.first.call(null,(state_20093[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20147 = state_20093;
state_20093 = G__20147;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
cljs$core$async$state_machine__16221__auto__ = function(state_20093){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16221__auto____1.call(this,state_20093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16221__auto____0;
cljs$core$async$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16221__auto____1;
return cljs$core$async$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_20124 = f__16346__auto__.call(null);
(statearr_20124[(6)] = c__16345__auto___20126);

return statearr_20124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

