// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__10493 = s;
var map__10493__$1 = cljs.core.__destructure_map.call(null,map__10493);
var name = cljs.core.get.call(null,map__10493__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__10493__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__10495 = info;
var map__10496 = G__10495;
var map__10496__$1 = cljs.core.__destructure_map.call(null,map__10496);
var shadow = cljs.core.get.call(null,map__10496__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__10495__$1 = G__10495;
while(true){
var d__$2 = d__$1;
var map__10498 = G__10495__$1;
var map__10498__$1 = cljs.core.__destructure_map.call(null,map__10498);
var shadow__$1 = cljs.core.get.call(null,map__10498__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__10499 = (d__$2 + (1));
var G__10500 = shadow__$1;
d__$1 = G__10499;
G__10495__$1 = G__10500;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__10501){
var map__10502 = p__10501;
var map__10502__$1 = cljs.core.__destructure_map.call(null,map__10502);
var name_var = map__10502__$1;
var name = cljs.core.get.call(null,map__10502__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__10502__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__10503 = info;
var map__10503__$1 = cljs.core.__destructure_map.call(null,map__10503);
var ns = cljs.core.get.call(null,map__10503__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__10503__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.call(null,reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__10505 = arguments.length;
switch (G__10505) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11639,11639,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)])).call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__10507 = cp;
switch (G__10507) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__10509_10513 = cljs.core.seq.call(null,s);
var chunk__10510_10514 = null;
var count__10511_10515 = (0);
var i__10512_10516 = (0);
while(true){
if((i__10512_10516 < count__10511_10515)){
var c_10517 = cljs.core._nth.call(null,chunk__10510_10514,i__10512_10516);
sb.append(cljs.compiler.escape_char.call(null,c_10517));


var G__10518 = seq__10509_10513;
var G__10519 = chunk__10510_10514;
var G__10520 = count__10511_10515;
var G__10521 = (i__10512_10516 + (1));
seq__10509_10513 = G__10518;
chunk__10510_10514 = G__10519;
count__10511_10515 = G__10520;
i__10512_10516 = G__10521;
continue;
} else {
var temp__5753__auto___10522 = cljs.core.seq.call(null,seq__10509_10513);
if(temp__5753__auto___10522){
var seq__10509_10523__$1 = temp__5753__auto___10522;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10509_10523__$1)){
var c__4638__auto___10524 = cljs.core.chunk_first.call(null,seq__10509_10523__$1);
var G__10525 = cljs.core.chunk_rest.call(null,seq__10509_10523__$1);
var G__10526 = c__4638__auto___10524;
var G__10527 = cljs.core.count.call(null,c__4638__auto___10524);
var G__10528 = (0);
seq__10509_10513 = G__10525;
chunk__10510_10514 = G__10526;
count__10511_10515 = G__10527;
i__10512_10516 = G__10528;
continue;
} else {
var c_10529 = cljs.core.first.call(null,seq__10509_10523__$1);
sb.append(cljs.compiler.escape_char.call(null,c_10529));


var G__10530 = cljs.core.next.call(null,seq__10509_10523__$1);
var G__10531 = null;
var G__10532 = (0);
var G__10533 = (0);
seq__10509_10513 = G__10530;
chunk__10510_10514 = G__10531;
count__10511_10515 = G__10532;
i__10512_10516 = G__10533;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4701__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__10534_10537 = ast;
var map__10534_10538__$1 = cljs.core.__destructure_map.call(null,map__10534_10537);
var env_10539 = cljs.core.get.call(null,map__10534_10538__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_10539))){
var map__10535_10540 = env_10539;
var map__10535_10541__$1 = cljs.core.__destructure_map.call(null,map__10535_10540);
var line_10542 = cljs.core.get.call(null,map__10535_10541__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_10543 = cljs.core.get.call(null,map__10535_10541__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__10536 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast)))){
return cljs.core.assoc.call(null,G__10536,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__10536;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_10542 - (1))], null),cljs.core.fnil.call(null,(function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_10543)?(column_10543 - (1)):(0))], null),cljs.core.fnil.call(null,(function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__10552 = arguments.length;
switch (G__10552) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4839__auto__ = [];
var len__4818__auto___10559 = arguments.length;
var i__4819__auto___10560 = (0);
while(true){
if((i__4819__auto___10560 < len__4818__auto___10559)){
args_arr__4839__auto__.push((arguments[i__4819__auto___10560]));

var G__10561 = (i__4819__auto___10560 + (1));
i__4819__auto___10560 = G__10561;
continue;
} else {
}
break;
}

var argseq__4840__auto__ = (new cljs.core.IndexedSeq(args_arr__4839__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4840__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,a)){
cljs.compiler.emit.call(null,a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_.call(null,a)){
cljs.core.apply.call(null,cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
a.call(null);
} else {
var s_10562 = (function (){var G__10553 = a;
if((!(typeof a === 'string'))){
return G__10553.toString();
} else {
return G__10553;
}
})();
var temp__5757__auto___10563 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___10563 == null)){
} else {
var sm_data_10564 = temp__5757__auto___10563;
cljs.core.swap_BANG_.call(null,sm_data_10564,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__10544_SHARP_){
return (p1__10544_SHARP_ + s_10562.length);
}));
}

cljs.core.print.call(null,s_10562);

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

return cljs.compiler.emits.call(null,b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler.emits.call(null,c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler.emits.call(null,d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler.emits.call(null,e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__10554 = cljs.core.seq.call(null,xs);
var chunk__10555 = null;
var count__10556 = (0);
var i__10557 = (0);
while(true){
if((i__10557 < count__10556)){
var x = cljs.core._nth.call(null,chunk__10555,i__10557);
cljs.compiler.emits.call(null,x);


var G__10565 = seq__10554;
var G__10566 = chunk__10555;
var G__10567 = count__10556;
var G__10568 = (i__10557 + (1));
seq__10554 = G__10565;
chunk__10555 = G__10566;
count__10556 = G__10567;
i__10557 = G__10568;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__10554);
if(temp__5753__auto__){
var seq__10554__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10554__$1)){
var c__4638__auto__ = cljs.core.chunk_first.call(null,seq__10554__$1);
var G__10569 = cljs.core.chunk_rest.call(null,seq__10554__$1);
var G__10570 = c__4638__auto__;
var G__10571 = cljs.core.count.call(null,c__4638__auto__);
var G__10572 = (0);
seq__10554 = G__10569;
chunk__10555 = G__10570;
count__10556 = G__10571;
i__10557 = G__10572;
continue;
} else {
var x = cljs.core.first.call(null,seq__10554__$1);
cljs.compiler.emits.call(null,x);


var G__10573 = cljs.core.next.call(null,seq__10554__$1);
var G__10574 = null;
var G__10575 = (0);
var G__10576 = (0);
seq__10554 = G__10573;
chunk__10555 = G__10574;
count__10556 = G__10575;
i__10557 = G__10576;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq10546){
var G__10547 = cljs.core.first.call(null,seq10546);
var seq10546__$1 = cljs.core.next.call(null,seq10546);
var G__10548 = cljs.core.first.call(null,seq10546__$1);
var seq10546__$2 = cljs.core.next.call(null,seq10546__$1);
var G__10549 = cljs.core.first.call(null,seq10546__$2);
var seq10546__$3 = cljs.core.next.call(null,seq10546__$2);
var G__10550 = cljs.core.first.call(null,seq10546__$3);
var seq10546__$4 = cljs.core.next.call(null,seq10546__$3);
var G__10551 = cljs.core.first.call(null,seq10546__$4);
var seq10546__$5 = cljs.core.next.call(null,seq10546__$4);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__10547,G__10548,G__10549,G__10550,G__10551,seq10546__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.call(null);

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__10577){
var map__10578 = p__10577;
var map__10578__$1 = cljs.core.__destructure_map.call(null,map__10578);
var m = map__10578__$1;
var gen_line = cljs.core.get.call(null,map__10578__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__10586 = arguments.length;
switch (G__10586) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4839__auto__ = [];
var len__4818__auto___10592 = arguments.length;
var i__4819__auto___10593 = (0);
while(true){
if((i__4819__auto___10593 < len__4818__auto___10592)){
args_arr__4839__auto__.push((arguments[i__4819__auto___10593]));

var G__10594 = (i__4819__auto___10593 + (1));
i__4819__auto___10593 = G__10594;
continue;
} else {
}
break;
}

var argseq__4840__auto__ = (new cljs.core.IndexedSeq(args_arr__4839__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4840__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.call(null,a);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__10587_10595 = cljs.core.seq.call(null,xs);
var chunk__10588_10596 = null;
var count__10589_10597 = (0);
var i__10590_10598 = (0);
while(true){
if((i__10590_10598 < count__10589_10597)){
var x_10599 = cljs.core._nth.call(null,chunk__10588_10596,i__10590_10598);
cljs.compiler.emits.call(null,x_10599);


var G__10600 = seq__10587_10595;
var G__10601 = chunk__10588_10596;
var G__10602 = count__10589_10597;
var G__10603 = (i__10590_10598 + (1));
seq__10587_10595 = G__10600;
chunk__10588_10596 = G__10601;
count__10589_10597 = G__10602;
i__10590_10598 = G__10603;
continue;
} else {
var temp__5753__auto___10604 = cljs.core.seq.call(null,seq__10587_10595);
if(temp__5753__auto___10604){
var seq__10587_10605__$1 = temp__5753__auto___10604;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10587_10605__$1)){
var c__4638__auto___10606 = cljs.core.chunk_first.call(null,seq__10587_10605__$1);
var G__10607 = cljs.core.chunk_rest.call(null,seq__10587_10605__$1);
var G__10608 = c__4638__auto___10606;
var G__10609 = cljs.core.count.call(null,c__4638__auto___10606);
var G__10610 = (0);
seq__10587_10595 = G__10607;
chunk__10588_10596 = G__10608;
count__10589_10597 = G__10609;
i__10590_10598 = G__10610;
continue;
} else {
var x_10611 = cljs.core.first.call(null,seq__10587_10605__$1);
cljs.compiler.emits.call(null,x_10611);


var G__10612 = cljs.core.next.call(null,seq__10587_10605__$1);
var G__10613 = null;
var G__10614 = (0);
var G__10615 = (0);
seq__10587_10595 = G__10612;
chunk__10588_10596 = G__10613;
count__10589_10597 = G__10614;
i__10590_10598 = G__10615;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln.call(null);
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq10580){
var G__10581 = cljs.core.first.call(null,seq10580);
var seq10580__$1 = cljs.core.next.call(null,seq10580);
var G__10582 = cljs.core.first.call(null,seq10580__$1);
var seq10580__$2 = cljs.core.next.call(null,seq10580__$1);
var G__10583 = cljs.core.first.call(null,seq10580__$2);
var seq10580__$3 = cljs.core.next.call(null,seq10580__$2);
var G__10584 = cljs.core.first.call(null,seq10580__$3);
var seq10580__$4 = cljs.core.next.call(null,seq10580__$3);
var G__10585 = cljs.core.first.call(null,seq10580__$4);
var seq10580__$5 = cljs.core.next.call(null,seq10580__$4);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__10581,G__10582,G__10583,G__10584,G__10585,seq10580__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4749__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__10616_10620 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__10617_10621 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__10618_10622 = true;
var _STAR_print_fn_STAR__temp_val__10619_10623 = (function (x__4750__auto__){
return sb__4749__auto__.append(x__4750__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__10618_10622);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__10619_10623);

try{cljs.compiler.emit.call(null,expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__10617_10621);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__10616_10620);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4749__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4701__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.call(null,cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_.call(null,x)){
return cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.core.record_QMARK_.call(null,x)){
var vec__10624 = cljs.analyzer.record_ns_PLUS_name.call(null,x);
var ns = cljs.core.nth.call(null,vec__10624,(0),null);
var name = cljs.core.nth.call(null,vec__10624,(1),null);
return cljs.compiler.emit_record_value.call(null,ns,name,(function (){
return cljs.compiler.emit_constant.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,x));
}));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,x)){
return cljs.compiler.emit_map.call(null,cljs.core.keys.call(null,x),cljs.core.vals.call(null,x),cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_.call(null,x)){
return cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_.call(null,x)){
return cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
return cljs.compiler.emit_constant_STAR_.call(null,x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta.call(null,cljs.core.meta.call(null,v));
if((!((cljs.core.seq.call(null,m) == null)))){
return cljs.compiler.emit_with_meta.call(null,(function (){
return cljs.compiler.emit_constant_no_meta.call(null,v);
}),(function (){
return cljs.compiler.emit_constant_no_meta.call(null,m);
}));
} else {
return cljs.compiler.emit_constant_no_meta.call(null,v);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.call(null,cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__10627 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.call(null,vec__10627,(0),null);
var flags = cljs.core.nth.call(null,vec__10627,(1),null);
var pattern = cljs.core.nth.call(null,vec__10627,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4210__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4210__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4210__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4210__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.call(null,cljs.core.map_indexed.call(null,(function (i,m){
if(cljs.core.even_QMARK_.call(null,i)){
return cljs.compiler.emit_constant.call(null,m);
} else {
return cljs.compiler.emits.call(null,m);
}
}),cljs.compiler.comma_sep.call(null,cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.call(null,"new Date(",inst_ms,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Date,(function (date){
return cljs.compiler.emit_inst.call(null,date.getTime());
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_.call(null,items)){
return cljs.compiler.emit_js_object.call(null,items,(function (p1__10630_SHARP_){
return (function (){
return cljs.compiler.emit_constant.call(null,p1__10630_SHARP_);
});
}));
} else {
return cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__10632){
var map__10633 = p__10632;
var map__10633__$1 = cljs.core.__destructure_map.call(null,map__10633);
var ast = map__10633__$1;
var info = cljs.core.get.call(null,map__10633__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__10633__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__10633__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5751__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__10634 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__10634__$1 = cljs.core.__destructure_map.call(null,map__10634);
var cenv = map__10634__$1;
var options = cljs.core.get.call(null,map__10634__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4212__auto__ = js_module_name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__10635 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.namespace.call(null,var_name) == null)));
} else {
return and__4210__auto__;
}
})())){
return clojure.set.difference.call(null,G__10635,cljs.analyzer.es5_allowed);
} else {
return G__10635;
}
})();
var js_module = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4212__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})()], null));
var info__$2 = (function (){var G__10636 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__10636,reserved);
} else {
return G__10636;
}
})();
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var G__10637_10638 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__10637_10639__$1 = (((G__10637_10638 instanceof cljs.core.Keyword))?G__10637_10638.fqn:null);
switch (G__10637_10639__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace.call(null,var_name))){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"].",cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved));
} else {
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.call(null,"default",cljs.core.name.call(null,var_name));
} else {
return and__4210__auto__;
}
})())){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.call(null,info__$2);
}

break;
default:
cljs.compiler.emits.call(null,info__$2);

}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__10641){
var map__10642 = p__10641;
var map__10642__$1 = cljs.core.__destructure_map.call(null,map__10642);
var arg = map__10642__$1;
var env = cljs.core.get.call(null,map__10642__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__10642__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__10642__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__10642__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__10643 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__10643__$1 = cljs.core.__destructure_map.call(null,map__10643);
var name = cljs.core.get.call(null,map__10643__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__10644){
var map__10645 = p__10644;
var map__10645__$1 = cljs.core.__destructure_map.call(null,map__10645);
var expr = cljs.core.get.call(null,map__10645__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__10645__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__10645__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_with_meta.call(null,expr,meta);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_.call(null,(function (p1__10646_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__10646_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count.call(null,keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count.call(null,keys) === (0))){
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(distinct_keys_QMARK_.call(null,keys))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",comma_sep.call(null,keys),"],[",comma_sep.call(null,vals),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__10647){
var map__10648 = p__10647;
var map__10648__$1 = cljs.core.__destructure_map.call(null,map__10648);
var env = cljs.core.get.call(null,map__10648__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__10648__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__10648__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_map.call(null,keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.call(null,"cljs.core.list(",comma_sep.call(null,items),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count.call(null,items);
if((cnt < (32))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",comma_sep.call(null,items),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",comma_sep.call(null,items),"], true)");
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__10649){
var map__10650 = p__10649;
var map__10650__$1 = cljs.core.__destructure_map.call(null,map__10650);
var items = cljs.core.get.call(null,map__10650__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__10650__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_vector.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_.call(null,(function (p1__10651_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__10651_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count.call(null,items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(distinct_constants_QMARK_.call(null,items))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",comma_sep.call(null,items),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__10652){
var map__10653 = p__10652;
var map__10653__$1 = cljs.core.__destructure_map.call(null,map__10653);
var items = cljs.core.get.call(null,map__10653__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__10653__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_set.call(null,items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.call(null,"({");

var temp__5753__auto___10676 = cljs.core.seq.call(null,items);
if(temp__5753__auto___10676){
var items_10677__$1 = temp__5753__auto___10676;
var vec__10654_10678 = items_10677__$1;
var seq__10655_10679 = cljs.core.seq.call(null,vec__10654_10678);
var first__10656_10680 = cljs.core.first.call(null,seq__10655_10679);
var seq__10655_10681__$1 = cljs.core.next.call(null,seq__10655_10679);
var vec__10657_10682 = first__10656_10680;
var k_10683 = cljs.core.nth.call(null,vec__10657_10682,(0),null);
var v_10684 = cljs.core.nth.call(null,vec__10657_10682,(1),null);
var r_10685 = seq__10655_10681__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_10683),"\": ",emit_js_object_val.call(null,v_10684));

var seq__10660_10686 = cljs.core.seq.call(null,r_10685);
var chunk__10661_10687 = null;
var count__10662_10688 = (0);
var i__10663_10689 = (0);
while(true){
if((i__10663_10689 < count__10662_10688)){
var vec__10670_10690 = cljs.core._nth.call(null,chunk__10661_10687,i__10663_10689);
var k_10691__$1 = cljs.core.nth.call(null,vec__10670_10690,(0),null);
var v_10692__$1 = cljs.core.nth.call(null,vec__10670_10690,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_10691__$1),"\": ",emit_js_object_val.call(null,v_10692__$1));


var G__10693 = seq__10660_10686;
var G__10694 = chunk__10661_10687;
var G__10695 = count__10662_10688;
var G__10696 = (i__10663_10689 + (1));
seq__10660_10686 = G__10693;
chunk__10661_10687 = G__10694;
count__10662_10688 = G__10695;
i__10663_10689 = G__10696;
continue;
} else {
var temp__5753__auto___10697__$1 = cljs.core.seq.call(null,seq__10660_10686);
if(temp__5753__auto___10697__$1){
var seq__10660_10698__$1 = temp__5753__auto___10697__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10660_10698__$1)){
var c__4638__auto___10699 = cljs.core.chunk_first.call(null,seq__10660_10698__$1);
var G__10700 = cljs.core.chunk_rest.call(null,seq__10660_10698__$1);
var G__10701 = c__4638__auto___10699;
var G__10702 = cljs.core.count.call(null,c__4638__auto___10699);
var G__10703 = (0);
seq__10660_10686 = G__10700;
chunk__10661_10687 = G__10701;
count__10662_10688 = G__10702;
i__10663_10689 = G__10703;
continue;
} else {
var vec__10673_10704 = cljs.core.first.call(null,seq__10660_10698__$1);
var k_10705__$1 = cljs.core.nth.call(null,vec__10673_10704,(0),null);
var v_10706__$1 = cljs.core.nth.call(null,vec__10673_10704,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_10705__$1),"\": ",emit_js_object_val.call(null,v_10706__$1));


var G__10707 = cljs.core.next.call(null,seq__10660_10698__$1);
var G__10708 = null;
var G__10709 = (0);
var G__10710 = (0);
seq__10660_10686 = G__10707;
chunk__10661_10687 = G__10708;
count__10662_10688 = G__10709;
i__10663_10689 = G__10710;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.call(null,"[",comma_sep.call(null,items),"]");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__10711){
var map__10712 = p__10711;
var map__10712__$1 = cljs.core.__destructure_map.call(null,map__10712);
var keys = cljs.core.get.call(null,map__10712__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__10712__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.call(null,map__10712__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_object.call(null,cljs.core.map.call(null,cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__10713){
var map__10714 = p__10713;
var map__10714__$1 = cljs.core.__destructure_map.call(null,map__10714);
var items = cljs.core.get.call(null,map__10714__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__10714__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_array.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__10715){
var map__10716 = p__10715;
var map__10716__$1 = cljs.core.__destructure_map.call(null,map__10716);
var expr = cljs.core.get.call(null,map__10716__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__10717){
var map__10718 = p__10717;
var map__10718__$1 = cljs.core.__destructure_map.call(null,map__10718);
var form = cljs.core.get.call(null,map__10718__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__10718__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__10719 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__10719__$1 = cljs.core.__destructure_map.call(null,map__10719);
var op = cljs.core.get.call(null,map__10719__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__10719__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__10719__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4212__auto__ = (function (){var and__4210__auto__ = cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__4210__auto__){
var and__4210__auto____$1 = form;
if(cljs.core.truth_(and__4210__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.call(null,form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto__ = (!((const_expr == null)));
if(and__4210__auto__){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return and__4210__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__10720 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__10720__$1 = cljs.core.__destructure_map.call(null,map__10720);
var op = cljs.core.get.call(null,map__10720__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__10720__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__10720__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4212__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4212__auto__){
return or__4212__auto__;
} else {
var and__4210__auto__ = (!((const_expr == null)));
if(and__4210__auto__){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return and__4210__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__4212__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__10721){
var map__10722 = p__10721;
var map__10722__$1 = cljs.core.__destructure_map.call(null,map__10722);
var test = cljs.core.get.call(null,map__10722__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__10722__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__10722__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__10722__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__10722__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__4212__auto__ = unchecked;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__10723){
var map__10724 = p__10723;
var map__10724__$1 = cljs.core.__destructure_map.call(null,map__10724);
var v = cljs.core.get.call(null,map__10724__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.call(null,map__10724__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.call(null,map__10724__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__10724__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__10725_10753 = cljs.core.seq.call(null,nodes);
var chunk__10726_10754 = null;
var count__10727_10755 = (0);
var i__10728_10756 = (0);
while(true){
if((i__10728_10756 < count__10727_10755)){
var map__10741_10757 = cljs.core._nth.call(null,chunk__10726_10754,i__10728_10756);
var map__10741_10758__$1 = cljs.core.__destructure_map.call(null,map__10741_10757);
var ts_10759 = cljs.core.get.call(null,map__10741_10758__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__10742_10760 = cljs.core.get.call(null,map__10741_10758__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__10742_10761__$1 = cljs.core.__destructure_map.call(null,map__10742_10760);
var then_10762 = cljs.core.get.call(null,map__10742_10761__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__10743_10763 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_10759));
var chunk__10744_10764 = null;
var count__10745_10765 = (0);
var i__10746_10766 = (0);
while(true){
if((i__10746_10766 < count__10745_10765)){
var test_10767 = cljs.core._nth.call(null,chunk__10744_10764,i__10746_10766);
cljs.compiler.emitln.call(null,"case ",test_10767,":");


var G__10768 = seq__10743_10763;
var G__10769 = chunk__10744_10764;
var G__10770 = count__10745_10765;
var G__10771 = (i__10746_10766 + (1));
seq__10743_10763 = G__10768;
chunk__10744_10764 = G__10769;
count__10745_10765 = G__10770;
i__10746_10766 = G__10771;
continue;
} else {
var temp__5753__auto___10772 = cljs.core.seq.call(null,seq__10743_10763);
if(temp__5753__auto___10772){
var seq__10743_10773__$1 = temp__5753__auto___10772;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10743_10773__$1)){
var c__4638__auto___10774 = cljs.core.chunk_first.call(null,seq__10743_10773__$1);
var G__10775 = cljs.core.chunk_rest.call(null,seq__10743_10773__$1);
var G__10776 = c__4638__auto___10774;
var G__10777 = cljs.core.count.call(null,c__4638__auto___10774);
var G__10778 = (0);
seq__10743_10763 = G__10775;
chunk__10744_10764 = G__10776;
count__10745_10765 = G__10777;
i__10746_10766 = G__10778;
continue;
} else {
var test_10779 = cljs.core.first.call(null,seq__10743_10773__$1);
cljs.compiler.emitln.call(null,"case ",test_10779,":");


var G__10780 = cljs.core.next.call(null,seq__10743_10773__$1);
var G__10781 = null;
var G__10782 = (0);
var G__10783 = (0);
seq__10743_10763 = G__10780;
chunk__10744_10764 = G__10781;
count__10745_10765 = G__10782;
i__10746_10766 = G__10783;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_10762);
} else {
cljs.compiler.emitln.call(null,then_10762);
}

cljs.compiler.emitln.call(null,"break;");


var G__10784 = seq__10725_10753;
var G__10785 = chunk__10726_10754;
var G__10786 = count__10727_10755;
var G__10787 = (i__10728_10756 + (1));
seq__10725_10753 = G__10784;
chunk__10726_10754 = G__10785;
count__10727_10755 = G__10786;
i__10728_10756 = G__10787;
continue;
} else {
var temp__5753__auto___10788 = cljs.core.seq.call(null,seq__10725_10753);
if(temp__5753__auto___10788){
var seq__10725_10789__$1 = temp__5753__auto___10788;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10725_10789__$1)){
var c__4638__auto___10790 = cljs.core.chunk_first.call(null,seq__10725_10789__$1);
var G__10791 = cljs.core.chunk_rest.call(null,seq__10725_10789__$1);
var G__10792 = c__4638__auto___10790;
var G__10793 = cljs.core.count.call(null,c__4638__auto___10790);
var G__10794 = (0);
seq__10725_10753 = G__10791;
chunk__10726_10754 = G__10792;
count__10727_10755 = G__10793;
i__10728_10756 = G__10794;
continue;
} else {
var map__10747_10795 = cljs.core.first.call(null,seq__10725_10789__$1);
var map__10747_10796__$1 = cljs.core.__destructure_map.call(null,map__10747_10795);
var ts_10797 = cljs.core.get.call(null,map__10747_10796__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__10748_10798 = cljs.core.get.call(null,map__10747_10796__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__10748_10799__$1 = cljs.core.__destructure_map.call(null,map__10748_10798);
var then_10800 = cljs.core.get.call(null,map__10748_10799__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__10749_10801 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_10797));
var chunk__10750_10802 = null;
var count__10751_10803 = (0);
var i__10752_10804 = (0);
while(true){
if((i__10752_10804 < count__10751_10803)){
var test_10805 = cljs.core._nth.call(null,chunk__10750_10802,i__10752_10804);
cljs.compiler.emitln.call(null,"case ",test_10805,":");


var G__10806 = seq__10749_10801;
var G__10807 = chunk__10750_10802;
var G__10808 = count__10751_10803;
var G__10809 = (i__10752_10804 + (1));
seq__10749_10801 = G__10806;
chunk__10750_10802 = G__10807;
count__10751_10803 = G__10808;
i__10752_10804 = G__10809;
continue;
} else {
var temp__5753__auto___10810__$1 = cljs.core.seq.call(null,seq__10749_10801);
if(temp__5753__auto___10810__$1){
var seq__10749_10811__$1 = temp__5753__auto___10810__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10749_10811__$1)){
var c__4638__auto___10812 = cljs.core.chunk_first.call(null,seq__10749_10811__$1);
var G__10813 = cljs.core.chunk_rest.call(null,seq__10749_10811__$1);
var G__10814 = c__4638__auto___10812;
var G__10815 = cljs.core.count.call(null,c__4638__auto___10812);
var G__10816 = (0);
seq__10749_10801 = G__10813;
chunk__10750_10802 = G__10814;
count__10751_10803 = G__10815;
i__10752_10804 = G__10816;
continue;
} else {
var test_10817 = cljs.core.first.call(null,seq__10749_10811__$1);
cljs.compiler.emitln.call(null,"case ",test_10817,":");


var G__10818 = cljs.core.next.call(null,seq__10749_10811__$1);
var G__10819 = null;
var G__10820 = (0);
var G__10821 = (0);
seq__10749_10801 = G__10818;
chunk__10750_10802 = G__10819;
count__10751_10803 = G__10820;
i__10752_10804 = G__10821;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_10800);
} else {
cljs.compiler.emitln.call(null,then_10800);
}

cljs.compiler.emitln.call(null,"break;");


var G__10822 = cljs.core.next.call(null,seq__10725_10789__$1);
var G__10823 = null;
var G__10824 = (0);
var G__10825 = (0);
seq__10725_10753 = G__10822;
chunk__10726_10754 = G__10823;
count__10727_10755 = G__10824;
i__10728_10756 = G__10825;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__10826){
var map__10827 = p__10826;
var map__10827__$1 = cljs.core.__destructure_map.call(null,map__10827);
var throw$ = cljs.core.get.call(null,map__10827__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.call(null,map__10827__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__10829 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__10829,(0),null);
var rstr = cljs.core.nth.call(null,vec__10829,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,(function (p1__10828_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__10828_SHARP_);
}),clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__10832 = ["function(",clojure.string.join.call(null,",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__10832,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__10832;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",clojure.string.join.call(null,"|",cljs.core.map.call(null,(function (p1__10833_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__10833_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__10834 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__10835 = cljs.core.seq.call(null,vec__10834);
var first__10836 = cljs.core.first.call(null,seq__10835);
var seq__10835__$1 = cljs.core.next.call(null,seq__10835);
var p = first__10836;
var first__10836__$1 = cljs.core.first.call(null,seq__10835__$1);
var seq__10835__$2 = cljs.core.next.call(null,seq__10835__$1);
var ts = first__10836__$1;
var first__10836__$2 = cljs.core.first.call(null,seq__10835__$2);
var seq__10835__$3 = cljs.core.next.call(null,seq__10835__$2);
var n = first__10836__$2;
var xs = seq__10835__$3;
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.call(null,"@param",p);
if(and__4210__auto__){
var and__4210__auto____$1 = ts;
if(cljs.core.truth_(and__4210__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__10837 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__10838 = cljs.core.seq.call(null,vec__10837);
var first__10839 = cljs.core.first.call(null,seq__10838);
var seq__10838__$1 = cljs.core.next.call(null,seq__10838);
var p = first__10839;
var first__10839__$1 = cljs.core.first.call(null,seq__10838__$1);
var seq__10838__$2 = cljs.core.next.call(null,seq__10838__$1);
var ts = first__10839__$1;
var xs = seq__10838__$2;
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.call(null,"@return",p);
if(and__4210__auto__){
var and__4210__auto____$1 = ts;
if(cljs.core.truth_(and__4210__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__10842 = arguments.length;
switch (G__10842) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__10850 = cljs.core.map.call(null,(function (p1__10840_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__10840_SHARP_);
} else {
return p1__10840_SHARP_;
}
}),clojure.string.split_lines.call(null,e));
var seq__10851 = cljs.core.seq.call(null,vec__10850);
var first__10852 = cljs.core.first.call(null,seq__10851);
var seq__10851__$1 = cljs.core.next.call(null,seq__10851);
var x = first__10852;
var ys = seq__10851__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__10853 = cljs.core.seq.call(null,ys);
var chunk__10854 = null;
var count__10855 = (0);
var i__10856 = (0);
while(true){
if((i__10856 < count__10855)){
var next_line = cljs.core._nth.call(null,chunk__10854,i__10856);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__10862 = seq__10853;
var G__10863 = chunk__10854;
var G__10864 = count__10855;
var G__10865 = (i__10856 + (1));
seq__10853 = G__10862;
chunk__10854 = G__10863;
count__10855 = G__10864;
i__10856 = G__10865;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__10853);
if(temp__5753__auto__){
var seq__10853__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10853__$1)){
var c__4638__auto__ = cljs.core.chunk_first.call(null,seq__10853__$1);
var G__10866 = cljs.core.chunk_rest.call(null,seq__10853__$1);
var G__10867 = c__4638__auto__;
var G__10868 = cljs.core.count.call(null,c__4638__auto__);
var G__10869 = (0);
seq__10853 = G__10866;
chunk__10854 = G__10867;
count__10855 = G__10868;
i__10856 = G__10869;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__10853__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__10870 = cljs.core.next.call(null,seq__10853__$1);
var G__10871 = null;
var G__10872 = (0);
var G__10873 = (0);
seq__10853 = G__10870;
chunk__10854 = G__10871;
count__10855 = G__10872;
i__10856 = G__10873;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__10857_10874 = cljs.core.seq.call(null,docs__$2);
var chunk__10858_10875 = null;
var count__10859_10876 = (0);
var i__10860_10877 = (0);
while(true){
if((i__10860_10877 < count__10859_10876)){
var e_10878 = cljs.core._nth.call(null,chunk__10858_10875,i__10860_10877);
if(cljs.core.truth_(e_10878)){
print_comment_lines.call(null,e_10878);
} else {
}


var G__10879 = seq__10857_10874;
var G__10880 = chunk__10858_10875;
var G__10881 = count__10859_10876;
var G__10882 = (i__10860_10877 + (1));
seq__10857_10874 = G__10879;
chunk__10858_10875 = G__10880;
count__10859_10876 = G__10881;
i__10860_10877 = G__10882;
continue;
} else {
var temp__5753__auto___10883 = cljs.core.seq.call(null,seq__10857_10874);
if(temp__5753__auto___10883){
var seq__10857_10884__$1 = temp__5753__auto___10883;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10857_10884__$1)){
var c__4638__auto___10885 = cljs.core.chunk_first.call(null,seq__10857_10884__$1);
var G__10886 = cljs.core.chunk_rest.call(null,seq__10857_10884__$1);
var G__10887 = c__4638__auto___10885;
var G__10888 = cljs.core.count.call(null,c__4638__auto___10885);
var G__10889 = (0);
seq__10857_10874 = G__10886;
chunk__10858_10875 = G__10887;
count__10859_10876 = G__10888;
i__10860_10877 = G__10889;
continue;
} else {
var e_10890 = cljs.core.first.call(null,seq__10857_10884__$1);
if(cljs.core.truth_(e_10890)){
print_comment_lines.call(null,e_10890);
} else {
}


var G__10891 = cljs.core.next.call(null,seq__10857_10884__$1);
var G__10892 = null;
var G__10893 = (0);
var G__10894 = (0);
seq__10857_10874 = G__10891;
chunk__10858_10875 = G__10892;
count__10859_10876 = G__10893;
i__10860_10877 = G__10894;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4210__auto__ = cljs.core.some.call(null,(function (p1__10896_SHARP_){
return goog.string.startsWith(p1__10896_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = opts;
if(cljs.core.truth_(and__4210__auto____$1)){
var and__4210__auto____$2 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__4210__auto____$2){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_.call(null,define)){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return and__4210__auto____$2;
}
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__10897){
var map__10898 = p__10897;
var map__10898__$1 = cljs.core.__destructure_map.call(null,map__10898);
var doc = cljs.core.get.call(null,map__10898__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__10898__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.call(null,map__10898__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.call(null,map__10898__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.call(null,map__10898__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.call(null,map__10898__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__10898__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.call(null,map__10898__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.call(null,map__10898__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.call(null,map__10898__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4212__auto__ = init;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,(cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
return test;
} else {
return and__4210__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__10899){
var map__10900 = p__10899;
var map__10900__$1 = cljs.core.__destructure_map.call(null,map__10900);
var name = cljs.core.get.call(null,map__10900__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__10900__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__10900__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__10901_10925 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__10902_10926 = null;
var count__10903_10927 = (0);
var i__10904_10928 = (0);
while(true){
if((i__10904_10928 < count__10903_10927)){
var vec__10911_10929 = cljs.core._nth.call(null,chunk__10902_10926,i__10904_10928);
var i_10930 = cljs.core.nth.call(null,vec__10911_10929,(0),null);
var param_10931 = cljs.core.nth.call(null,vec__10911_10929,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_10931);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__10932 = seq__10901_10925;
var G__10933 = chunk__10902_10926;
var G__10934 = count__10903_10927;
var G__10935 = (i__10904_10928 + (1));
seq__10901_10925 = G__10932;
chunk__10902_10926 = G__10933;
count__10903_10927 = G__10934;
i__10904_10928 = G__10935;
continue;
} else {
var temp__5753__auto___10936 = cljs.core.seq.call(null,seq__10901_10925);
if(temp__5753__auto___10936){
var seq__10901_10937__$1 = temp__5753__auto___10936;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10901_10937__$1)){
var c__4638__auto___10938 = cljs.core.chunk_first.call(null,seq__10901_10937__$1);
var G__10939 = cljs.core.chunk_rest.call(null,seq__10901_10937__$1);
var G__10940 = c__4638__auto___10938;
var G__10941 = cljs.core.count.call(null,c__4638__auto___10938);
var G__10942 = (0);
seq__10901_10925 = G__10939;
chunk__10902_10926 = G__10940;
count__10903_10927 = G__10941;
i__10904_10928 = G__10942;
continue;
} else {
var vec__10914_10943 = cljs.core.first.call(null,seq__10901_10937__$1);
var i_10944 = cljs.core.nth.call(null,vec__10914_10943,(0),null);
var param_10945 = cljs.core.nth.call(null,vec__10914_10943,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_10945);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__10946 = cljs.core.next.call(null,seq__10901_10937__$1);
var G__10947 = null;
var G__10948 = (0);
var G__10949 = (0);
seq__10901_10925 = G__10946;
chunk__10902_10926 = G__10947;
count__10903_10927 = G__10948;
i__10904_10928 = G__10949;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__10917_10950 = cljs.core.seq.call(null,params);
var chunk__10918_10951 = null;
var count__10919_10952 = (0);
var i__10920_10953 = (0);
while(true){
if((i__10920_10953 < count__10919_10952)){
var param_10954 = cljs.core._nth.call(null,chunk__10918_10951,i__10920_10953);
cljs.compiler.emit.call(null,param_10954);

if(cljs.core._EQ_.call(null,param_10954,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__10955 = seq__10917_10950;
var G__10956 = chunk__10918_10951;
var G__10957 = count__10919_10952;
var G__10958 = (i__10920_10953 + (1));
seq__10917_10950 = G__10955;
chunk__10918_10951 = G__10956;
count__10919_10952 = G__10957;
i__10920_10953 = G__10958;
continue;
} else {
var temp__5753__auto___10959 = cljs.core.seq.call(null,seq__10917_10950);
if(temp__5753__auto___10959){
var seq__10917_10960__$1 = temp__5753__auto___10959;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10917_10960__$1)){
var c__4638__auto___10961 = cljs.core.chunk_first.call(null,seq__10917_10960__$1);
var G__10962 = cljs.core.chunk_rest.call(null,seq__10917_10960__$1);
var G__10963 = c__4638__auto___10961;
var G__10964 = cljs.core.count.call(null,c__4638__auto___10961);
var G__10965 = (0);
seq__10917_10950 = G__10962;
chunk__10918_10951 = G__10963;
count__10919_10952 = G__10964;
i__10920_10953 = G__10965;
continue;
} else {
var param_10966 = cljs.core.first.call(null,seq__10917_10960__$1);
cljs.compiler.emit.call(null,param_10966);

if(cljs.core._EQ_.call(null,param_10966,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__10967 = cljs.core.next.call(null,seq__10917_10960__$1);
var G__10968 = null;
var G__10969 = (0);
var G__10970 = (0);
seq__10917_10950 = G__10967;
chunk__10918_10951 = G__10968;
count__10919_10952 = G__10969;
i__10920_10953 = G__10970;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__10921_10971 = cljs.core.seq.call(null,params);
var chunk__10922_10972 = null;
var count__10923_10973 = (0);
var i__10924_10974 = (0);
while(true){
if((i__10924_10974 < count__10923_10973)){
var param_10975 = cljs.core._nth.call(null,chunk__10922_10972,i__10924_10974);
cljs.compiler.emit.call(null,param_10975);

if(cljs.core._EQ_.call(null,param_10975,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__10976 = seq__10921_10971;
var G__10977 = chunk__10922_10972;
var G__10978 = count__10923_10973;
var G__10979 = (i__10924_10974 + (1));
seq__10921_10971 = G__10976;
chunk__10922_10972 = G__10977;
count__10923_10973 = G__10978;
i__10924_10974 = G__10979;
continue;
} else {
var temp__5753__auto___10980 = cljs.core.seq.call(null,seq__10921_10971);
if(temp__5753__auto___10980){
var seq__10921_10981__$1 = temp__5753__auto___10980;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10921_10981__$1)){
var c__4638__auto___10982 = cljs.core.chunk_first.call(null,seq__10921_10981__$1);
var G__10983 = cljs.core.chunk_rest.call(null,seq__10921_10981__$1);
var G__10984 = c__4638__auto___10982;
var G__10985 = cljs.core.count.call(null,c__4638__auto___10982);
var G__10986 = (0);
seq__10921_10971 = G__10983;
chunk__10922_10972 = G__10984;
count__10923_10973 = G__10985;
i__10924_10974 = G__10986;
continue;
} else {
var param_10987 = cljs.core.first.call(null,seq__10921_10981__$1);
cljs.compiler.emit.call(null,param_10987);

if(cljs.core._EQ_.call(null,param_10987,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__10988 = cljs.core.next.call(null,seq__10921_10981__$1);
var G__10989 = null;
var G__10990 = (0);
var G__10991 = (0);
seq__10921_10971 = G__10988;
chunk__10922_10972 = G__10989;
count__10923_10973 = G__10990;
i__10924_10974 = G__10991;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__10992 = cljs.core.seq.call(null,params);
var chunk__10993 = null;
var count__10994 = (0);
var i__10995 = (0);
while(true){
if((i__10995 < count__10994)){
var param = cljs.core._nth.call(null,chunk__10993,i__10995);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__10996 = seq__10992;
var G__10997 = chunk__10993;
var G__10998 = count__10994;
var G__10999 = (i__10995 + (1));
seq__10992 = G__10996;
chunk__10993 = G__10997;
count__10994 = G__10998;
i__10995 = G__10999;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__10992);
if(temp__5753__auto__){
var seq__10992__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10992__$1)){
var c__4638__auto__ = cljs.core.chunk_first.call(null,seq__10992__$1);
var G__11000 = cljs.core.chunk_rest.call(null,seq__10992__$1);
var G__11001 = c__4638__auto__;
var G__11002 = cljs.core.count.call(null,c__4638__auto__);
var G__11003 = (0);
seq__10992 = G__11000;
chunk__10993 = G__11001;
count__10994 = G__11002;
i__10995 = G__11003;
continue;
} else {
var param = cljs.core.first.call(null,seq__10992__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__11004 = cljs.core.next.call(null,seq__10992__$1);
var G__11005 = null;
var G__11006 = (0);
var G__11007 = (0);
seq__10992 = G__11004;
chunk__10993 = G__11005;
count__10994 = G__11006;
i__10995 = G__11007;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__11008){
var map__11009 = p__11008;
var map__11009__$1 = cljs.core.__destructure_map.call(null,map__11009);
var expr = cljs.core.get.call(null,map__11009__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.call(null,map__11009__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__11009__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__11009__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__11009__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__11009__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__11010){
var map__11011 = p__11010;
var map__11011__$1 = cljs.core.__destructure_map.call(null,map__11011);
var f = map__11011__$1;
var expr = cljs.core.get.call(null,map__11011__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.call(null,map__11011__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.call(null,map__11011__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.call(null,map__11011__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__11011__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__11011__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__11011__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__11011__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_11020__$1 = (function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_11021 = cljs.compiler.munge.call(null,name_11020__$1);
var delegate_name_11022 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_11021),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_11022," = function (");

var seq__11012_11023 = cljs.core.seq.call(null,params);
var chunk__11013_11024 = null;
var count__11014_11025 = (0);
var i__11015_11026 = (0);
while(true){
if((i__11015_11026 < count__11014_11025)){
var param_11027 = cljs.core._nth.call(null,chunk__11013_11024,i__11015_11026);
cljs.compiler.emit.call(null,param_11027);

if(cljs.core._EQ_.call(null,param_11027,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__11028 = seq__11012_11023;
var G__11029 = chunk__11013_11024;
var G__11030 = count__11014_11025;
var G__11031 = (i__11015_11026 + (1));
seq__11012_11023 = G__11028;
chunk__11013_11024 = G__11029;
count__11014_11025 = G__11030;
i__11015_11026 = G__11031;
continue;
} else {
var temp__5753__auto___11032 = cljs.core.seq.call(null,seq__11012_11023);
if(temp__5753__auto___11032){
var seq__11012_11033__$1 = temp__5753__auto___11032;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11012_11033__$1)){
var c__4638__auto___11034 = cljs.core.chunk_first.call(null,seq__11012_11033__$1);
var G__11035 = cljs.core.chunk_rest.call(null,seq__11012_11033__$1);
var G__11036 = c__4638__auto___11034;
var G__11037 = cljs.core.count.call(null,c__4638__auto___11034);
var G__11038 = (0);
seq__11012_11023 = G__11035;
chunk__11013_11024 = G__11036;
count__11014_11025 = G__11037;
i__11015_11026 = G__11038;
continue;
} else {
var param_11039 = cljs.core.first.call(null,seq__11012_11033__$1);
cljs.compiler.emit.call(null,param_11039);

if(cljs.core._EQ_.call(null,param_11039,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__11040 = cljs.core.next.call(null,seq__11012_11033__$1);
var G__11041 = null;
var G__11042 = (0);
var G__11043 = (0);
seq__11012_11023 = G__11040;
chunk__11013_11024 = G__11041;
count__11014_11025 = G__11042;
i__11015_11026 = G__11043;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_11021," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_11044 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_11044,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_11022,".call(this,");

var seq__11016_11045 = cljs.core.seq.call(null,params);
var chunk__11017_11046 = null;
var count__11018_11047 = (0);
var i__11019_11048 = (0);
while(true){
if((i__11019_11048 < count__11018_11047)){
var param_11049 = cljs.core._nth.call(null,chunk__11017_11046,i__11019_11048);
cljs.compiler.emit.call(null,param_11049);

if(cljs.core._EQ_.call(null,param_11049,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__11050 = seq__11016_11045;
var G__11051 = chunk__11017_11046;
var G__11052 = count__11018_11047;
var G__11053 = (i__11019_11048 + (1));
seq__11016_11045 = G__11050;
chunk__11017_11046 = G__11051;
count__11018_11047 = G__11052;
i__11019_11048 = G__11053;
continue;
} else {
var temp__5753__auto___11054 = cljs.core.seq.call(null,seq__11016_11045);
if(temp__5753__auto___11054){
var seq__11016_11055__$1 = temp__5753__auto___11054;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11016_11055__$1)){
var c__4638__auto___11056 = cljs.core.chunk_first.call(null,seq__11016_11055__$1);
var G__11057 = cljs.core.chunk_rest.call(null,seq__11016_11055__$1);
var G__11058 = c__4638__auto___11056;
var G__11059 = cljs.core.count.call(null,c__4638__auto___11056);
var G__11060 = (0);
seq__11016_11045 = G__11057;
chunk__11017_11046 = G__11058;
count__11018_11047 = G__11059;
i__11019_11048 = G__11060;
continue;
} else {
var param_11061 = cljs.core.first.call(null,seq__11016_11055__$1);
cljs.compiler.emit.call(null,param_11061);

if(cljs.core._EQ_.call(null,param_11061,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__11062 = cljs.core.next.call(null,seq__11016_11055__$1);
var G__11063 = null;
var G__11064 = (0);
var G__11065 = (0);
seq__11016_11045 = G__11062;
chunk__11017_11046 = G__11063;
count__11018_11047 = G__11064;
i__11019_11048 = G__11065;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_11021,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_11021,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_11020__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_11021,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_11022,";");

cljs.compiler.emitln.call(null,"return ",mname_11021,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__11069){
var map__11070 = p__11069;
var map__11070__$1 = cljs.core.__destructure_map.call(null,map__11070);
var variadic = cljs.core.get.call(null,map__11070__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.call(null,map__11070__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__11070__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__11070__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__11070__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.call(null,map__11070__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.call(null,map__11070__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.call(null,map__11070__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,(function (p1__11066_SHARP_){
var and__4210__auto__ = p1__11066_SHARP_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__11066_SHARP_));
} else {
return and__4210__auto__;
}
}),recur_frames));
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,recur_params,(cljs.core.truth_((function (){var or__4212__auto__ = in_loop;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.seq.call(null,recur_params);
}
})())?cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets):null))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_11122__$1 = (function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_11123 = cljs.compiler.munge.call(null,name_11122__$1);
var maxparams_11124 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_11125 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_11123),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_11126 = cljs.core.sort_by.call(null,(function (p1__11067_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__11067_SHARP_)));
}),cljs.core.seq.call(null,mmap_11125));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_11123," = null;");

var seq__11071_11127 = cljs.core.seq.call(null,ms_11126);
var chunk__11072_11128 = null;
var count__11073_11129 = (0);
var i__11074_11130 = (0);
while(true){
if((i__11074_11130 < count__11073_11129)){
var vec__11081_11131 = cljs.core._nth.call(null,chunk__11072_11128,i__11074_11130);
var n_11132 = cljs.core.nth.call(null,vec__11081_11131,(0),null);
var meth_11133 = cljs.core.nth.call(null,vec__11081_11131,(1),null);
cljs.compiler.emits.call(null,"var ",n_11132," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_11133))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_11133);
} else {
cljs.compiler.emit_fn_method.call(null,meth_11133);
}

cljs.compiler.emitln.call(null,";");


var G__11134 = seq__11071_11127;
var G__11135 = chunk__11072_11128;
var G__11136 = count__11073_11129;
var G__11137 = (i__11074_11130 + (1));
seq__11071_11127 = G__11134;
chunk__11072_11128 = G__11135;
count__11073_11129 = G__11136;
i__11074_11130 = G__11137;
continue;
} else {
var temp__5753__auto___11138 = cljs.core.seq.call(null,seq__11071_11127);
if(temp__5753__auto___11138){
var seq__11071_11139__$1 = temp__5753__auto___11138;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11071_11139__$1)){
var c__4638__auto___11140 = cljs.core.chunk_first.call(null,seq__11071_11139__$1);
var G__11141 = cljs.core.chunk_rest.call(null,seq__11071_11139__$1);
var G__11142 = c__4638__auto___11140;
var G__11143 = cljs.core.count.call(null,c__4638__auto___11140);
var G__11144 = (0);
seq__11071_11127 = G__11141;
chunk__11072_11128 = G__11142;
count__11073_11129 = G__11143;
i__11074_11130 = G__11144;
continue;
} else {
var vec__11084_11145 = cljs.core.first.call(null,seq__11071_11139__$1);
var n_11146 = cljs.core.nth.call(null,vec__11084_11145,(0),null);
var meth_11147 = cljs.core.nth.call(null,vec__11084_11145,(1),null);
cljs.compiler.emits.call(null,"var ",n_11146," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_11147))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_11147);
} else {
cljs.compiler.emit_fn_method.call(null,meth_11147);
}

cljs.compiler.emitln.call(null,";");


var G__11148 = cljs.core.next.call(null,seq__11071_11139__$1);
var G__11149 = null;
var G__11150 = (0);
var G__11151 = (0);
seq__11071_11127 = G__11148;
chunk__11072_11128 = G__11149;
count__11073_11129 = G__11150;
i__11074_11130 = G__11151;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_11123," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_11124),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_11124)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_11124));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__11087_11152 = cljs.core.seq.call(null,ms_11126);
var chunk__11088_11153 = null;
var count__11089_11154 = (0);
var i__11090_11155 = (0);
while(true){
if((i__11090_11155 < count__11089_11154)){
var vec__11097_11156 = cljs.core._nth.call(null,chunk__11088_11153,i__11090_11155);
var n_11157 = cljs.core.nth.call(null,vec__11097_11156,(0),null);
var meth_11158 = cljs.core.nth.call(null,vec__11097_11156,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_11158))){
cljs.compiler.emitln.call(null,"default:");

var restarg_11159 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_11159," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_11160 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_11159," = new cljs.core.IndexedSeq(",a_11160,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_11157,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_11124)),(((cljs.core.count.call(null,maxparams_11124) > (1)))?", ":null),restarg_11159,");");
} else {
var pcnt_11161 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_11158));
cljs.compiler.emitln.call(null,"case ",pcnt_11161,":");

cljs.compiler.emitln.call(null,"return ",n_11157,".call(this",(((pcnt_11161 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_11161,maxparams_11124)),null,(1),null)),(2),null))),");");
}


var G__11162 = seq__11087_11152;
var G__11163 = chunk__11088_11153;
var G__11164 = count__11089_11154;
var G__11165 = (i__11090_11155 + (1));
seq__11087_11152 = G__11162;
chunk__11088_11153 = G__11163;
count__11089_11154 = G__11164;
i__11090_11155 = G__11165;
continue;
} else {
var temp__5753__auto___11166 = cljs.core.seq.call(null,seq__11087_11152);
if(temp__5753__auto___11166){
var seq__11087_11167__$1 = temp__5753__auto___11166;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11087_11167__$1)){
var c__4638__auto___11168 = cljs.core.chunk_first.call(null,seq__11087_11167__$1);
var G__11169 = cljs.core.chunk_rest.call(null,seq__11087_11167__$1);
var G__11170 = c__4638__auto___11168;
var G__11171 = cljs.core.count.call(null,c__4638__auto___11168);
var G__11172 = (0);
seq__11087_11152 = G__11169;
chunk__11088_11153 = G__11170;
count__11089_11154 = G__11171;
i__11090_11155 = G__11172;
continue;
} else {
var vec__11100_11173 = cljs.core.first.call(null,seq__11087_11167__$1);
var n_11174 = cljs.core.nth.call(null,vec__11100_11173,(0),null);
var meth_11175 = cljs.core.nth.call(null,vec__11100_11173,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_11175))){
cljs.compiler.emitln.call(null,"default:");

var restarg_11176 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_11176," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_11177 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_11176," = new cljs.core.IndexedSeq(",a_11177,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_11174,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_11124)),(((cljs.core.count.call(null,maxparams_11124) > (1)))?", ":null),restarg_11176,");");
} else {
var pcnt_11178 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_11175));
cljs.compiler.emitln.call(null,"case ",pcnt_11178,":");

cljs.compiler.emitln.call(null,"return ",n_11174,".call(this",(((pcnt_11178 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_11178,maxparams_11124)),null,(1),null)),(2),null))),");");
}


var G__11179 = cljs.core.next.call(null,seq__11087_11167__$1);
var G__11180 = null;
var G__11181 = (0);
var G__11182 = (0);
seq__11087_11152 = G__11179;
chunk__11088_11153 = G__11180;
count__11089_11154 = G__11181;
i__11090_11155 = G__11182;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

var arg_count_js_11183 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,cljs.core.first.call(null,ms_11126)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + ",arg_count_js_11183,"));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_11123,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_11123,".cljs$lang$applyTo = ",cljs.core.some.call(null,(function (p1__11068_SHARP_){
var vec__11103 = p1__11068_SHARP_;
var n = cljs.core.nth.call(null,vec__11103,(0),null);
var m = cljs.core.nth.call(null,vec__11103,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_11126),".cljs$lang$applyTo;");
} else {
}

var seq__11106_11184 = cljs.core.seq.call(null,ms_11126);
var chunk__11107_11185 = null;
var count__11108_11186 = (0);
var i__11109_11187 = (0);
while(true){
if((i__11109_11187 < count__11108_11186)){
var vec__11116_11188 = cljs.core._nth.call(null,chunk__11107_11185,i__11109_11187);
var n_11189 = cljs.core.nth.call(null,vec__11116_11188,(0),null);
var meth_11190 = cljs.core.nth.call(null,vec__11116_11188,(1),null);
var c_11191 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_11190));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_11190))){
cljs.compiler.emitln.call(null,mname_11123,".cljs$core$IFn$_invoke$arity$variadic = ",n_11189,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_11123,".cljs$core$IFn$_invoke$arity$",c_11191," = ",n_11189,";");
}


var G__11192 = seq__11106_11184;
var G__11193 = chunk__11107_11185;
var G__11194 = count__11108_11186;
var G__11195 = (i__11109_11187 + (1));
seq__11106_11184 = G__11192;
chunk__11107_11185 = G__11193;
count__11108_11186 = G__11194;
i__11109_11187 = G__11195;
continue;
} else {
var temp__5753__auto___11196 = cljs.core.seq.call(null,seq__11106_11184);
if(temp__5753__auto___11196){
var seq__11106_11197__$1 = temp__5753__auto___11196;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11106_11197__$1)){
var c__4638__auto___11198 = cljs.core.chunk_first.call(null,seq__11106_11197__$1);
var G__11199 = cljs.core.chunk_rest.call(null,seq__11106_11197__$1);
var G__11200 = c__4638__auto___11198;
var G__11201 = cljs.core.count.call(null,c__4638__auto___11198);
var G__11202 = (0);
seq__11106_11184 = G__11199;
chunk__11107_11185 = G__11200;
count__11108_11186 = G__11201;
i__11109_11187 = G__11202;
continue;
} else {
var vec__11119_11203 = cljs.core.first.call(null,seq__11106_11197__$1);
var n_11204 = cljs.core.nth.call(null,vec__11119_11203,(0),null);
var meth_11205 = cljs.core.nth.call(null,vec__11119_11203,(1),null);
var c_11206 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_11205));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_11205))){
cljs.compiler.emitln.call(null,mname_11123,".cljs$core$IFn$_invoke$arity$variadic = ",n_11204,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_11123,".cljs$core$IFn$_invoke$arity$",c_11206," = ",n_11204,";");
}


var G__11207 = cljs.core.next.call(null,seq__11106_11197__$1);
var G__11208 = null;
var G__11209 = (0);
var G__11210 = (0);
seq__11106_11184 = G__11207;
chunk__11107_11185 = G__11208;
count__11108_11186 = G__11209;
i__11109_11187 = G__11210;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_11123,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__11211){
var map__11212 = p__11211;
var map__11212__$1 = cljs.core.__destructure_map.call(null,map__11212);
var statements = cljs.core.get.call(null,map__11212__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__11212__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__11212__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__11213_11217 = cljs.core.seq.call(null,statements);
var chunk__11214_11218 = null;
var count__11215_11219 = (0);
var i__11216_11220 = (0);
while(true){
if((i__11216_11220 < count__11215_11219)){
var s_11221 = cljs.core._nth.call(null,chunk__11214_11218,i__11216_11220);
cljs.compiler.emitln.call(null,s_11221);


var G__11222 = seq__11213_11217;
var G__11223 = chunk__11214_11218;
var G__11224 = count__11215_11219;
var G__11225 = (i__11216_11220 + (1));
seq__11213_11217 = G__11222;
chunk__11214_11218 = G__11223;
count__11215_11219 = G__11224;
i__11216_11220 = G__11225;
continue;
} else {
var temp__5753__auto___11226 = cljs.core.seq.call(null,seq__11213_11217);
if(temp__5753__auto___11226){
var seq__11213_11227__$1 = temp__5753__auto___11226;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11213_11227__$1)){
var c__4638__auto___11228 = cljs.core.chunk_first.call(null,seq__11213_11227__$1);
var G__11229 = cljs.core.chunk_rest.call(null,seq__11213_11227__$1);
var G__11230 = c__4638__auto___11228;
var G__11231 = cljs.core.count.call(null,c__4638__auto___11228);
var G__11232 = (0);
seq__11213_11217 = G__11229;
chunk__11214_11218 = G__11230;
count__11215_11219 = G__11231;
i__11216_11220 = G__11232;
continue;
} else {
var s_11233 = cljs.core.first.call(null,seq__11213_11227__$1);
cljs.compiler.emitln.call(null,s_11233);


var G__11234 = cljs.core.next.call(null,seq__11213_11227__$1);
var G__11235 = null;
var G__11236 = (0);
var G__11237 = (0);
seq__11213_11217 = G__11234;
chunk__11214_11218 = G__11235;
count__11215_11219 = G__11236;
i__11216_11220 = G__11237;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__11238){
var map__11239 = p__11238;
var map__11239__$1 = cljs.core.__destructure_map.call(null,map__11239);
var try$ = cljs.core.get.call(null,map__11239__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.call(null,map__11239__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.call(null,map__11239__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__11239__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__11239__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote.call(null,finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__11240,is_loop){
var map__11241 = p__11240;
var map__11241__$1 = cljs.core.__destructure_map.call(null,map__11241);
var expr = cljs.core.get.call(null,map__11241__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__11241__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__11241__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__11242_11252 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__11243_11253 = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,(function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__11243_11253);

try{var seq__11244_11254 = cljs.core.seq.call(null,bindings);
var chunk__11245_11255 = null;
var count__11246_11256 = (0);
var i__11247_11257 = (0);
while(true){
if((i__11247_11257 < count__11246_11256)){
var map__11250_11258 = cljs.core._nth.call(null,chunk__11245_11255,i__11247_11257);
var map__11250_11259__$1 = cljs.core.__destructure_map.call(null,map__11250_11258);
var binding_11260 = map__11250_11259__$1;
var init_11261 = cljs.core.get.call(null,map__11250_11259__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_11260);

cljs.compiler.emitln.call(null," = ",init_11261,";");


var G__11262 = seq__11244_11254;
var G__11263 = chunk__11245_11255;
var G__11264 = count__11246_11256;
var G__11265 = (i__11247_11257 + (1));
seq__11244_11254 = G__11262;
chunk__11245_11255 = G__11263;
count__11246_11256 = G__11264;
i__11247_11257 = G__11265;
continue;
} else {
var temp__5753__auto___11266 = cljs.core.seq.call(null,seq__11244_11254);
if(temp__5753__auto___11266){
var seq__11244_11267__$1 = temp__5753__auto___11266;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11244_11267__$1)){
var c__4638__auto___11268 = cljs.core.chunk_first.call(null,seq__11244_11267__$1);
var G__11269 = cljs.core.chunk_rest.call(null,seq__11244_11267__$1);
var G__11270 = c__4638__auto___11268;
var G__11271 = cljs.core.count.call(null,c__4638__auto___11268);
var G__11272 = (0);
seq__11244_11254 = G__11269;
chunk__11245_11255 = G__11270;
count__11246_11256 = G__11271;
i__11247_11257 = G__11272;
continue;
} else {
var map__11251_11273 = cljs.core.first.call(null,seq__11244_11267__$1);
var map__11251_11274__$1 = cljs.core.__destructure_map.call(null,map__11251_11273);
var binding_11275 = map__11251_11274__$1;
var init_11276 = cljs.core.get.call(null,map__11251_11274__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_11275);

cljs.compiler.emitln.call(null," = ",init_11276,";");


var G__11277 = cljs.core.next.call(null,seq__11244_11267__$1);
var G__11278 = null;
var G__11279 = (0);
var G__11280 = (0);
seq__11244_11254 = G__11277;
chunk__11245_11255 = G__11278;
count__11246_11256 = G__11279;
i__11247_11257 = G__11280;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__11242_11252);
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__11281){
var map__11282 = p__11281;
var map__11282__$1 = cljs.core.__destructure_map.call(null,map__11282);
var frame = cljs.core.get.call(null,map__11282__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__11282__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__11282__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4695__auto___11283 = cljs.core.count.call(null,exprs);
var i_11284 = (0);
while(true){
if((i_11284 < n__4695__auto___11283)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_11284)," = ",exprs.call(null,i_11284),";");

var G__11285 = (i_11284 + (1));
i_11284 = G__11285;
continue;
} else {
}
break;
}

var n__4695__auto___11286 = cljs.core.count.call(null,exprs);
var i_11287 = (0);
while(true){
if((i_11287 < n__4695__auto___11286)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_11287))," = ",temps.call(null,i_11287),";");

var G__11288 = (i_11287 + (1));
i_11287 = G__11288;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__11289){
var map__11290 = p__11289;
var map__11290__$1 = cljs.core.__destructure_map.call(null,map__11290);
var expr = cljs.core.get.call(null,map__11290__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__11290__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__11290__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__11291_11299 = cljs.core.seq.call(null,bindings);
var chunk__11292_11300 = null;
var count__11293_11301 = (0);
var i__11294_11302 = (0);
while(true){
if((i__11294_11302 < count__11293_11301)){
var map__11297_11303 = cljs.core._nth.call(null,chunk__11292_11300,i__11294_11302);
var map__11297_11304__$1 = cljs.core.__destructure_map.call(null,map__11297_11303);
var binding_11305 = map__11297_11304__$1;
var init_11306 = cljs.core.get.call(null,map__11297_11304__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_11305)," = ",init_11306,";");


var G__11307 = seq__11291_11299;
var G__11308 = chunk__11292_11300;
var G__11309 = count__11293_11301;
var G__11310 = (i__11294_11302 + (1));
seq__11291_11299 = G__11307;
chunk__11292_11300 = G__11308;
count__11293_11301 = G__11309;
i__11294_11302 = G__11310;
continue;
} else {
var temp__5753__auto___11311 = cljs.core.seq.call(null,seq__11291_11299);
if(temp__5753__auto___11311){
var seq__11291_11312__$1 = temp__5753__auto___11311;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11291_11312__$1)){
var c__4638__auto___11313 = cljs.core.chunk_first.call(null,seq__11291_11312__$1);
var G__11314 = cljs.core.chunk_rest.call(null,seq__11291_11312__$1);
var G__11315 = c__4638__auto___11313;
var G__11316 = cljs.core.count.call(null,c__4638__auto___11313);
var G__11317 = (0);
seq__11291_11299 = G__11314;
chunk__11292_11300 = G__11315;
count__11293_11301 = G__11316;
i__11294_11302 = G__11317;
continue;
} else {
var map__11298_11318 = cljs.core.first.call(null,seq__11291_11312__$1);
var map__11298_11319__$1 = cljs.core.__destructure_map.call(null,map__11298_11318);
var binding_11320 = map__11298_11319__$1;
var init_11321 = cljs.core.get.call(null,map__11298_11319__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_11320)," = ",init_11321,";");


var G__11322 = cljs.core.next.call(null,seq__11291_11312__$1);
var G__11323 = null;
var G__11324 = (0);
var G__11325 = (0);
seq__11291_11299 = G__11322;
chunk__11292_11300 = G__11323;
count__11293_11301 = G__11324;
i__11294_11302 = G__11325;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__11328){
var map__11329 = p__11328;
var map__11329__$1 = cljs.core.__destructure_map.call(null,map__11329);
var expr = map__11329__$1;
var f = cljs.core.get.call(null,map__11329__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.call(null,map__11329__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__11329__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4210__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__4210__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4210__auto__ = protocol;
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = tag;
if(cljs.core.truth_(and__4210__auto____$1)){
var or__4212__auto__ = (function (){var and__4210__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto____$2)){
var and__4210__auto____$3 = protocol;
if(cljs.core.truth_(and__4210__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4210__auto____$3;
}
} else {
return and__4210__auto____$2;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto____$2 = (function (){var or__4212__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4210__auto____$2)){
var or__4212__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__4212__auto____$1){
return or__4212__auto____$1;
} else {
var and__4210__auto____$3 = (!(cljs.core.set_QMARK_.call(null,tag)));
if(and__4210__auto____$3){
var and__4210__auto____$4 = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null).call(null,tag));
if(and__4210__auto____$4){
var temp__5753__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,cljs.core.vary_meta.call(null,tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return and__4210__auto____$4;
}
} else {
return and__4210__auto____$3;
}
}
} else {
return and__4210__auto____$2;
}
}
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null).call(null,first_arg_tag))));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag.call(null,env,f);
var js_QMARK_ = (function (){var or__4212__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4212__auto____$1){
return or__4212__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4212__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4212__auto__ = cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4212__auto__){
return or__4212__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote.call(null,f);
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__11330 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return (arity > mfa);
} else {
return and__4210__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__11326_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__11326_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__11327_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__11327_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__11330,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__11330,(1),null);
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"(!(",cljs.core.first.call(null,args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.call(null,"((",cljs.core.first.call(null,args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_11333 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_11333,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_11334 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_11334,args)),(((mfa_11334 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_11334,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1));
} else {
return and__4210__auto__;
}
})())){
var fprop_11335 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.call(null,"(",f__$1,fprop_11335," ? ",f__$1,fprop_11335,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_11335," ? ",f__$1,fprop_11335,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__11336){
var map__11337 = p__11336;
var map__11337__$1 = cljs.core.__destructure_map.call(null,map__11337);
var ctor = cljs.core.get.call(null,map__11337__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.call(null,map__11337__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__11337__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__11338){
var map__11339 = p__11338;
var map__11339__$1 = cljs.core.__destructure_map.call(null,map__11339);
var target = cljs.core.get.call(null,map__11339__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__11339__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__11339__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(",target," = ",val,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.call(null,sublib,/\./);
return cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (p1__11340_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__11340_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__11341 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__11341,(0),null);
var sublib = cljs.core.nth.call(null,vec__11341,(1),null);
return cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib)," = goog.global",cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.call(null,cljs.core.name.call(null,(function (){var or__4212__auto__ = cljs.core.get.call(null,global_exports,cljs.core.symbol.call(null,lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.call(null,global_exports,cljs.core.name.call(null,lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.compiler.sublib_select.call(null,sublib),";");
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__11344 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__11344__$1 = cljs.core.__destructure_map.call(null,map__11344);
var options = cljs.core.get.call(null,map__11344__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__11344__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__11345 = options;
var map__11345__$1 = cljs.core.__destructure_map.call(null,map__11345);
var target = cljs.core.get.call(null,map__11345__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.call(null,map__11345__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.call(null,map__11345__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__11346 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__11349 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__11349__$1 = cljs.core.__destructure_map.call(null,map__11349);
var node_libs = cljs.core.get.call(null,map__11349__$1,true);
var libs_to_load = cljs.core.get.call(null,map__11349__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__11346,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__11346,(1),null);
var global_exports_libs = cljs.core.filter.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__11350_11378 = cljs.core.seq.call(null,libs_to_load);
var chunk__11351_11379 = null;
var count__11352_11380 = (0);
var i__11353_11381 = (0);
while(true){
if((i__11353_11381 < count__11352_11380)){
var lib_11382 = cljs.core._nth.call(null,chunk__11351_11379,i__11353_11381);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_11382)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_11382),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_11382),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_11382),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_11382),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_11382,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_11382),"');");
}

}
}
}


var G__11383 = seq__11350_11378;
var G__11384 = chunk__11351_11379;
var G__11385 = count__11352_11380;
var G__11386 = (i__11353_11381 + (1));
seq__11350_11378 = G__11383;
chunk__11351_11379 = G__11384;
count__11352_11380 = G__11385;
i__11353_11381 = G__11386;
continue;
} else {
var temp__5753__auto___11387 = cljs.core.seq.call(null,seq__11350_11378);
if(temp__5753__auto___11387){
var seq__11350_11388__$1 = temp__5753__auto___11387;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11350_11388__$1)){
var c__4638__auto___11389 = cljs.core.chunk_first.call(null,seq__11350_11388__$1);
var G__11390 = cljs.core.chunk_rest.call(null,seq__11350_11388__$1);
var G__11391 = c__4638__auto___11389;
var G__11392 = cljs.core.count.call(null,c__4638__auto___11389);
var G__11393 = (0);
seq__11350_11378 = G__11390;
chunk__11351_11379 = G__11391;
count__11352_11380 = G__11392;
i__11353_11381 = G__11393;
continue;
} else {
var lib_11394 = cljs.core.first.call(null,seq__11350_11388__$1);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_11394)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_11394),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_11394),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_11394),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_11394),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_11394,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_11394),"');");
}

}
}
}


var G__11395 = cljs.core.next.call(null,seq__11350_11388__$1);
var G__11396 = null;
var G__11397 = (0);
var G__11398 = (0);
seq__11350_11378 = G__11395;
chunk__11351_11379 = G__11396;
count__11352_11380 = G__11397;
i__11353_11381 = G__11398;
continue;
}
} else {
}
}
break;
}

var seq__11354_11399 = cljs.core.seq.call(null,node_libs);
var chunk__11355_11400 = null;
var count__11356_11401 = (0);
var i__11357_11402 = (0);
while(true){
if((i__11357_11402 < count__11356_11401)){
var lib_11403 = cljs.core._nth.call(null,chunk__11355_11400,i__11357_11402);
var vec__11364_11404 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_11403);
var lib_SINGLEQUOTE__11405 = cljs.core.nth.call(null,vec__11364_11404,(0),null);
var sublib_11406 = cljs.core.nth.call(null,vec__11364_11404,(1),null);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_11403)," = require('",lib_SINGLEQUOTE__11405,"')",cljs.compiler.sublib_select.call(null,sublib_11406),";");


var G__11407 = seq__11354_11399;
var G__11408 = chunk__11355_11400;
var G__11409 = count__11356_11401;
var G__11410 = (i__11357_11402 + (1));
seq__11354_11399 = G__11407;
chunk__11355_11400 = G__11408;
count__11356_11401 = G__11409;
i__11357_11402 = G__11410;
continue;
} else {
var temp__5753__auto___11411 = cljs.core.seq.call(null,seq__11354_11399);
if(temp__5753__auto___11411){
var seq__11354_11412__$1 = temp__5753__auto___11411;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11354_11412__$1)){
var c__4638__auto___11413 = cljs.core.chunk_first.call(null,seq__11354_11412__$1);
var G__11414 = cljs.core.chunk_rest.call(null,seq__11354_11412__$1);
var G__11415 = c__4638__auto___11413;
var G__11416 = cljs.core.count.call(null,c__4638__auto___11413);
var G__11417 = (0);
seq__11354_11399 = G__11414;
chunk__11355_11400 = G__11415;
count__11356_11401 = G__11416;
i__11357_11402 = G__11417;
continue;
} else {
var lib_11418 = cljs.core.first.call(null,seq__11354_11412__$1);
var vec__11367_11419 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_11418);
var lib_SINGLEQUOTE__11420 = cljs.core.nth.call(null,vec__11367_11419,(0),null);
var sublib_11421 = cljs.core.nth.call(null,vec__11367_11419,(1),null);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_11418)," = require('",lib_SINGLEQUOTE__11420,"')",cljs.compiler.sublib_select.call(null,sublib_11421),";");


var G__11422 = cljs.core.next.call(null,seq__11354_11412__$1);
var G__11423 = null;
var G__11424 = (0);
var G__11425 = (0);
seq__11354_11399 = G__11422;
chunk__11355_11400 = G__11423;
count__11356_11401 = G__11424;
i__11357_11402 = G__11425;
continue;
}
} else {
}
}
break;
}

var seq__11370_11426 = cljs.core.seq.call(null,global_exports_libs);
var chunk__11371_11427 = null;
var count__11372_11428 = (0);
var i__11373_11429 = (0);
while(true){
if((i__11373_11429 < count__11372_11428)){
var lib_11430 = cljs.core._nth.call(null,chunk__11371_11427,i__11373_11429);
var map__11376_11431 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,cljs.core.first.call(null,cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_11430))));
var map__11376_11432__$1 = cljs.core.__destructure_map.call(null,map__11376_11431);
var global_exports_11433 = cljs.core.get.call(null,map__11376_11432__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_11433,lib_11430);


var G__11434 = seq__11370_11426;
var G__11435 = chunk__11371_11427;
var G__11436 = count__11372_11428;
var G__11437 = (i__11373_11429 + (1));
seq__11370_11426 = G__11434;
chunk__11371_11427 = G__11435;
count__11372_11428 = G__11436;
i__11373_11429 = G__11437;
continue;
} else {
var temp__5753__auto___11438 = cljs.core.seq.call(null,seq__11370_11426);
if(temp__5753__auto___11438){
var seq__11370_11439__$1 = temp__5753__auto___11438;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11370_11439__$1)){
var c__4638__auto___11440 = cljs.core.chunk_first.call(null,seq__11370_11439__$1);
var G__11441 = cljs.core.chunk_rest.call(null,seq__11370_11439__$1);
var G__11442 = c__4638__auto___11440;
var G__11443 = cljs.core.count.call(null,c__4638__auto___11440);
var G__11444 = (0);
seq__11370_11426 = G__11441;
chunk__11371_11427 = G__11442;
count__11372_11428 = G__11443;
i__11373_11429 = G__11444;
continue;
} else {
var lib_11445 = cljs.core.first.call(null,seq__11370_11439__$1);
var map__11377_11446 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,cljs.core.first.call(null,cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_11445))));
var map__11377_11447__$1 = cljs.core.__destructure_map.call(null,map__11377_11446);
var global_exports_11448 = cljs.core.get.call(null,map__11377_11447__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_11448,lib_11445);


var G__11449 = cljs.core.next.call(null,seq__11370_11439__$1);
var G__11450 = null;
var G__11451 = (0);
var G__11452 = (0);
seq__11370_11426 = G__11449;
chunk__11371_11427 = G__11450;
count__11372_11428 = G__11451;
i__11373_11429 = G__11452;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__11453){
var map__11454 = p__11453;
var map__11454__$1 = cljs.core.__destructure_map.call(null,map__11454);
var name = cljs.core.get.call(null,map__11454__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__11454__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__11454__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__11454__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__11454__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__11454__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__11454__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"'nil';");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__11455){
var map__11456 = p__11455;
var map__11456__$1 = cljs.core.__destructure_map.call(null,map__11456);
var name = cljs.core.get.call(null,map__11456__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__11456__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__11456__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__11456__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__11456__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__11456__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__11456__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__11457){
var map__11458 = p__11457;
var map__11458__$1 = cljs.core.__destructure_map.call(null,map__11458);
var t = cljs.core.get.call(null,map__11458__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__11458__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__11458__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__11458__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__11458__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__11459_11483 = cljs.core.seq.call(null,protocols);
var chunk__11460_11484 = null;
var count__11461_11485 = (0);
var i__11462_11486 = (0);
while(true){
if((i__11462_11486 < count__11461_11485)){
var protocol_11487 = cljs.core._nth.call(null,chunk__11460_11484,i__11462_11486);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11487)),"}");


var G__11488 = seq__11459_11483;
var G__11489 = chunk__11460_11484;
var G__11490 = count__11461_11485;
var G__11491 = (i__11462_11486 + (1));
seq__11459_11483 = G__11488;
chunk__11460_11484 = G__11489;
count__11461_11485 = G__11490;
i__11462_11486 = G__11491;
continue;
} else {
var temp__5753__auto___11492 = cljs.core.seq.call(null,seq__11459_11483);
if(temp__5753__auto___11492){
var seq__11459_11493__$1 = temp__5753__auto___11492;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11459_11493__$1)){
var c__4638__auto___11494 = cljs.core.chunk_first.call(null,seq__11459_11493__$1);
var G__11495 = cljs.core.chunk_rest.call(null,seq__11459_11493__$1);
var G__11496 = c__4638__auto___11494;
var G__11497 = cljs.core.count.call(null,c__4638__auto___11494);
var G__11498 = (0);
seq__11459_11483 = G__11495;
chunk__11460_11484 = G__11496;
count__11461_11485 = G__11497;
i__11462_11486 = G__11498;
continue;
} else {
var protocol_11499 = cljs.core.first.call(null,seq__11459_11493__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11499)),"}");


var G__11500 = cljs.core.next.call(null,seq__11459_11493__$1);
var G__11501 = null;
var G__11502 = (0);
var G__11503 = (0);
seq__11459_11483 = G__11500;
chunk__11460_11484 = G__11501;
count__11461_11485 = G__11502;
i__11462_11486 = G__11503;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__11463_11504 = cljs.core.seq.call(null,fields__$1);
var chunk__11464_11505 = null;
var count__11465_11506 = (0);
var i__11466_11507 = (0);
while(true){
if((i__11466_11507 < count__11465_11506)){
var fld_11508 = cljs.core._nth.call(null,chunk__11464_11505,i__11466_11507);
cljs.compiler.emitln.call(null,"this.",fld_11508," = ",fld_11508,";");


var G__11509 = seq__11463_11504;
var G__11510 = chunk__11464_11505;
var G__11511 = count__11465_11506;
var G__11512 = (i__11466_11507 + (1));
seq__11463_11504 = G__11509;
chunk__11464_11505 = G__11510;
count__11465_11506 = G__11511;
i__11466_11507 = G__11512;
continue;
} else {
var temp__5753__auto___11513 = cljs.core.seq.call(null,seq__11463_11504);
if(temp__5753__auto___11513){
var seq__11463_11514__$1 = temp__5753__auto___11513;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11463_11514__$1)){
var c__4638__auto___11515 = cljs.core.chunk_first.call(null,seq__11463_11514__$1);
var G__11516 = cljs.core.chunk_rest.call(null,seq__11463_11514__$1);
var G__11517 = c__4638__auto___11515;
var G__11518 = cljs.core.count.call(null,c__4638__auto___11515);
var G__11519 = (0);
seq__11463_11504 = G__11516;
chunk__11464_11505 = G__11517;
count__11465_11506 = G__11518;
i__11466_11507 = G__11519;
continue;
} else {
var fld_11520 = cljs.core.first.call(null,seq__11463_11514__$1);
cljs.compiler.emitln.call(null,"this.",fld_11520," = ",fld_11520,";");


var G__11521 = cljs.core.next.call(null,seq__11463_11514__$1);
var G__11522 = null;
var G__11523 = (0);
var G__11524 = (0);
seq__11463_11504 = G__11521;
chunk__11464_11505 = G__11522;
count__11465_11506 = G__11523;
i__11466_11507 = G__11524;
continue;
}
} else {
}
}
break;
}

var seq__11467_11525 = cljs.core.seq.call(null,pmasks);
var chunk__11468_11526 = null;
var count__11469_11527 = (0);
var i__11470_11528 = (0);
while(true){
if((i__11470_11528 < count__11469_11527)){
var vec__11477_11529 = cljs.core._nth.call(null,chunk__11468_11526,i__11470_11528);
var pno_11530 = cljs.core.nth.call(null,vec__11477_11529,(0),null);
var pmask_11531 = cljs.core.nth.call(null,vec__11477_11529,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_11530,"$ = ",pmask_11531,";");


var G__11532 = seq__11467_11525;
var G__11533 = chunk__11468_11526;
var G__11534 = count__11469_11527;
var G__11535 = (i__11470_11528 + (1));
seq__11467_11525 = G__11532;
chunk__11468_11526 = G__11533;
count__11469_11527 = G__11534;
i__11470_11528 = G__11535;
continue;
} else {
var temp__5753__auto___11536 = cljs.core.seq.call(null,seq__11467_11525);
if(temp__5753__auto___11536){
var seq__11467_11537__$1 = temp__5753__auto___11536;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11467_11537__$1)){
var c__4638__auto___11538 = cljs.core.chunk_first.call(null,seq__11467_11537__$1);
var G__11539 = cljs.core.chunk_rest.call(null,seq__11467_11537__$1);
var G__11540 = c__4638__auto___11538;
var G__11541 = cljs.core.count.call(null,c__4638__auto___11538);
var G__11542 = (0);
seq__11467_11525 = G__11539;
chunk__11468_11526 = G__11540;
count__11469_11527 = G__11541;
i__11470_11528 = G__11542;
continue;
} else {
var vec__11480_11543 = cljs.core.first.call(null,seq__11467_11537__$1);
var pno_11544 = cljs.core.nth.call(null,vec__11480_11543,(0),null);
var pmask_11545 = cljs.core.nth.call(null,vec__11480_11543,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_11544,"$ = ",pmask_11545,";");


var G__11546 = cljs.core.next.call(null,seq__11467_11537__$1);
var G__11547 = null;
var G__11548 = (0);
var G__11549 = (0);
seq__11467_11525 = G__11546;
chunk__11468_11526 = G__11547;
count__11469_11527 = G__11548;
i__11470_11528 = G__11549;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__11550){
var map__11551 = p__11550;
var map__11551__$1 = cljs.core.__destructure_map.call(null,map__11551);
var t = cljs.core.get.call(null,map__11551__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__11551__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__11551__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__11551__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__11551__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__11552_11576 = cljs.core.seq.call(null,protocols);
var chunk__11553_11577 = null;
var count__11554_11578 = (0);
var i__11555_11579 = (0);
while(true){
if((i__11555_11579 < count__11554_11578)){
var protocol_11580 = cljs.core._nth.call(null,chunk__11553_11577,i__11555_11579);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11580)),"}");


var G__11581 = seq__11552_11576;
var G__11582 = chunk__11553_11577;
var G__11583 = count__11554_11578;
var G__11584 = (i__11555_11579 + (1));
seq__11552_11576 = G__11581;
chunk__11553_11577 = G__11582;
count__11554_11578 = G__11583;
i__11555_11579 = G__11584;
continue;
} else {
var temp__5753__auto___11585 = cljs.core.seq.call(null,seq__11552_11576);
if(temp__5753__auto___11585){
var seq__11552_11586__$1 = temp__5753__auto___11585;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11552_11586__$1)){
var c__4638__auto___11587 = cljs.core.chunk_first.call(null,seq__11552_11586__$1);
var G__11588 = cljs.core.chunk_rest.call(null,seq__11552_11586__$1);
var G__11589 = c__4638__auto___11587;
var G__11590 = cljs.core.count.call(null,c__4638__auto___11587);
var G__11591 = (0);
seq__11552_11576 = G__11588;
chunk__11553_11577 = G__11589;
count__11554_11578 = G__11590;
i__11555_11579 = G__11591;
continue;
} else {
var protocol_11592 = cljs.core.first.call(null,seq__11552_11586__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11592)),"}");


var G__11593 = cljs.core.next.call(null,seq__11552_11586__$1);
var G__11594 = null;
var G__11595 = (0);
var G__11596 = (0);
seq__11552_11576 = G__11593;
chunk__11553_11577 = G__11594;
count__11554_11578 = G__11595;
i__11555_11579 = G__11596;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__11556_11597 = cljs.core.seq.call(null,fields__$1);
var chunk__11557_11598 = null;
var count__11558_11599 = (0);
var i__11559_11600 = (0);
while(true){
if((i__11559_11600 < count__11558_11599)){
var fld_11601 = cljs.core._nth.call(null,chunk__11557_11598,i__11559_11600);
cljs.compiler.emitln.call(null,"this.",fld_11601," = ",fld_11601,";");


var G__11602 = seq__11556_11597;
var G__11603 = chunk__11557_11598;
var G__11604 = count__11558_11599;
var G__11605 = (i__11559_11600 + (1));
seq__11556_11597 = G__11602;
chunk__11557_11598 = G__11603;
count__11558_11599 = G__11604;
i__11559_11600 = G__11605;
continue;
} else {
var temp__5753__auto___11606 = cljs.core.seq.call(null,seq__11556_11597);
if(temp__5753__auto___11606){
var seq__11556_11607__$1 = temp__5753__auto___11606;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11556_11607__$1)){
var c__4638__auto___11608 = cljs.core.chunk_first.call(null,seq__11556_11607__$1);
var G__11609 = cljs.core.chunk_rest.call(null,seq__11556_11607__$1);
var G__11610 = c__4638__auto___11608;
var G__11611 = cljs.core.count.call(null,c__4638__auto___11608);
var G__11612 = (0);
seq__11556_11597 = G__11609;
chunk__11557_11598 = G__11610;
count__11558_11599 = G__11611;
i__11559_11600 = G__11612;
continue;
} else {
var fld_11613 = cljs.core.first.call(null,seq__11556_11607__$1);
cljs.compiler.emitln.call(null,"this.",fld_11613," = ",fld_11613,";");


var G__11614 = cljs.core.next.call(null,seq__11556_11607__$1);
var G__11615 = null;
var G__11616 = (0);
var G__11617 = (0);
seq__11556_11597 = G__11614;
chunk__11557_11598 = G__11615;
count__11558_11599 = G__11616;
i__11559_11600 = G__11617;
continue;
}
} else {
}
}
break;
}

var seq__11560_11618 = cljs.core.seq.call(null,pmasks);
var chunk__11561_11619 = null;
var count__11562_11620 = (0);
var i__11563_11621 = (0);
while(true){
if((i__11563_11621 < count__11562_11620)){
var vec__11570_11622 = cljs.core._nth.call(null,chunk__11561_11619,i__11563_11621);
var pno_11623 = cljs.core.nth.call(null,vec__11570_11622,(0),null);
var pmask_11624 = cljs.core.nth.call(null,vec__11570_11622,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_11623,"$ = ",pmask_11624,";");


var G__11625 = seq__11560_11618;
var G__11626 = chunk__11561_11619;
var G__11627 = count__11562_11620;
var G__11628 = (i__11563_11621 + (1));
seq__11560_11618 = G__11625;
chunk__11561_11619 = G__11626;
count__11562_11620 = G__11627;
i__11563_11621 = G__11628;
continue;
} else {
var temp__5753__auto___11629 = cljs.core.seq.call(null,seq__11560_11618);
if(temp__5753__auto___11629){
var seq__11560_11630__$1 = temp__5753__auto___11629;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11560_11630__$1)){
var c__4638__auto___11631 = cljs.core.chunk_first.call(null,seq__11560_11630__$1);
var G__11632 = cljs.core.chunk_rest.call(null,seq__11560_11630__$1);
var G__11633 = c__4638__auto___11631;
var G__11634 = cljs.core.count.call(null,c__4638__auto___11631);
var G__11635 = (0);
seq__11560_11618 = G__11632;
chunk__11561_11619 = G__11633;
count__11562_11620 = G__11634;
i__11563_11621 = G__11635;
continue;
} else {
var vec__11573_11636 = cljs.core.first.call(null,seq__11560_11630__$1);
var pno_11637 = cljs.core.nth.call(null,vec__11573_11636,(0),null);
var pmask_11638 = cljs.core.nth.call(null,vec__11573_11636,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_11637,"$ = ",pmask_11638,";");


var G__11639 = cljs.core.next.call(null,seq__11560_11630__$1);
var G__11640 = null;
var G__11641 = (0);
var G__11642 = (0);
seq__11560_11618 = G__11639;
chunk__11561_11619 = G__11640;
count__11562_11620 = G__11641;
i__11563_11621 = G__11642;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__11643){
var map__11644 = p__11643;
var map__11644__$1 = cljs.core.__destructure_map.call(null,map__11644);
var target = cljs.core.get.call(null,map__11644__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__11644__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__11644__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__11644__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__11644__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__11645){
var map__11646 = p__11645;
var map__11646__$1 = cljs.core.__destructure_map.call(null,map__11646);
var op = cljs.core.get.call(null,map__11646__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__11646__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__11646__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__11646__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__11646__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4210__auto__ = code;
if(cljs.core.truth_(and__4210__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__4210__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__9281__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9281__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__11651 = cljs.core.seq.call(null,table);
var chunk__11652 = null;
var count__11653 = (0);
var i__11654 = (0);
while(true){
if((i__11654 < count__11653)){
var vec__11661 = cljs.core._nth.call(null,chunk__11652,i__11654);
var sym = cljs.core.nth.call(null,vec__11661,(0),null);
var value = cljs.core.nth.call(null,vec__11661,(1),null);
var ns_11667 = cljs.core.namespace.call(null,sym);
var name_11668 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__11669 = seq__11651;
var G__11670 = chunk__11652;
var G__11671 = count__11653;
var G__11672 = (i__11654 + (1));
seq__11651 = G__11669;
chunk__11652 = G__11670;
count__11653 = G__11671;
i__11654 = G__11672;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__11651);
if(temp__5753__auto__){
var seq__11651__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11651__$1)){
var c__4638__auto__ = cljs.core.chunk_first.call(null,seq__11651__$1);
var G__11673 = cljs.core.chunk_rest.call(null,seq__11651__$1);
var G__11674 = c__4638__auto__;
var G__11675 = cljs.core.count.call(null,c__4638__auto__);
var G__11676 = (0);
seq__11651 = G__11673;
chunk__11652 = G__11674;
count__11653 = G__11675;
i__11654 = G__11676;
continue;
} else {
var vec__11664 = cljs.core.first.call(null,seq__11651__$1);
var sym = cljs.core.nth.call(null,vec__11664,(0),null);
var value = cljs.core.nth.call(null,vec__11664,(1),null);
var ns_11677 = cljs.core.namespace.call(null,sym);
var name_11678 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__11679 = cljs.core.next.call(null,seq__11651__$1);
var G__11680 = null;
var G__11681 = (0);
var G__11682 = (0);
seq__11651 = G__11679;
chunk__11652 = G__11680;
count__11653 = G__11681;
i__11654 = G__11682;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__11684 = arguments.length;
switch (G__11684) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs.call(null):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_11689 = cljs.core.first.call(null,ks);
var vec__11685_11690 = cljs.core.conj.call(null,prefix,k_11689);
var top_11691 = cljs.core.nth.call(null,vec__11685_11690,(0),null);
var prefix_SINGLEQUOTE__11692 = vec__11685_11690;
if(((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_11689)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__11692) == null)))){
if((!(((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_11691)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_11691)))))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__11692)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_11691);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__11692)),";");
}
} else {
}

var m_11693 = cljs.core.get.call(null,externs,k_11689);
if(cljs.core.empty_QMARK_.call(null,m_11693)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__11692,m_11693,top_level,known_externs);
}

var G__11694 = cljs.core.next.call(null,ks);
ks = G__11694;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

