// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__46686(s__46687){
return (new cljs.core.LazySeq(null,(function (){
var s__46687__$1 = s__46687;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__46687__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__46692 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46692,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46692,(1),null);
var iterys__4607__auto__ = ((function (s__46687__$1,vec__46692,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__46686_$_iter__46688(s__46689){
return (new cljs.core.LazySeq(null,((function (s__46687__$1,vec__46692,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__46689__$1 = s__46689;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__46689__$1);
if(temp__5753__auto____$1){
var s__46689__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__46689__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__46689__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__46691 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__46690 = (0);
while(true){
if((i__46690 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__46690);
cljs.core.chunk_append(b__46691,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__46744 = (i__46690 + (1));
i__46690 = G__46744;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__46691),tailrecursion$priority_map$iter__46686_$_iter__46688(cljs.core.chunk_rest(s__46689__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__46691),null);
}
} else {
var item = cljs.core.first(s__46689__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__46686_$_iter__46688(cljs.core.rest(s__46689__$2)));
}
} else {
return null;
}
break;
}
});})(s__46687__$1,vec__46692,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__46687__$1,vec__46692,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__46686(cljs.core.rest(s__46687__$1)));
} else {
var G__46745 = cljs.core.rest(s__46687__$1);
s__46687__$1 = G__46745;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__46695(s__46696){
return (new cljs.core.LazySeq(null,(function (){
var s__46696__$1 = s__46696;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__46696__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__46701 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46701,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46701,(1),null);
var iterys__4607__auto__ = ((function (s__46696__$1,vec__46701,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__46695_$_iter__46697(s__46698){
return (new cljs.core.LazySeq(null,((function (s__46696__$1,vec__46701,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__46698__$1 = s__46698;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__46698__$1);
if(temp__5753__auto____$1){
var s__46698__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__46698__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__46698__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__46700 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__46699 = (0);
while(true){
if((i__46699 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__46699);
cljs.core.chunk_append(b__46700,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__46746 = (i__46699 + (1));
i__46699 = G__46746;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__46700),tailrecursion$priority_map$iter__46695_$_iter__46697(cljs.core.chunk_rest(s__46698__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__46700),null);
}
} else {
var item = cljs.core.first(s__46698__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__46695_$_iter__46697(cljs.core.rest(s__46698__$2)));
}
} else {
return null;
}
break;
}
});})(s__46696__$1,vec__46701,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__46696__$1,vec__46701,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__46695(cljs.core.rest(s__46696__$1)));
} else {
var G__46747 = cljs.core.rest(s__46696__$1);
s__46696__$1 = G__46747;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__46704 = item;
var G__46705 = new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517);
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__46704,G__46705) : self__.item__GT_priority.call(null,G__46704,G__46705));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__46706(s__46707){
return (new cljs.core.LazySeq(null,(function (){
var s__46707__$1 = s__46707;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__46707__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__46712 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46712,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46712,(1),null);
var iterys__4607__auto__ = ((function (s__46707__$1,vec__46712,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__46706_$_iter__46708(s__46709){
return (new cljs.core.LazySeq(null,((function (s__46707__$1,vec__46712,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__46709__$1 = s__46709;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__46709__$1);
if(temp__5753__auto____$1){
var s__46709__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__46709__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__46709__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__46711 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__46710 = (0);
while(true){
if((i__46710 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__46710);
cljs.core.chunk_append(b__46711,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__46748 = (i__46710 + (1));
i__46710 = G__46748;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__46711),tailrecursion$priority_map$iter__46706_$_iter__46708(cljs.core.chunk_rest(s__46709__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__46711),null);
}
} else {
var item = cljs.core.first(s__46709__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__46706_$_iter__46708(cljs.core.rest(s__46709__$2)));
}
} else {
return null;
}
break;
}
});})(s__46707__$1,vec__46712,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__46707__$1,vec__46712,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__46706(cljs.core.rest(s__46707__$1)));
} else {
var G__46749 = cljs.core.rest(s__46707__$1);
s__46707__$1 = G__46749;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__46715(s__46716){
return (new cljs.core.LazySeq(null,(function (){
var s__46716__$1 = s__46716;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__46716__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__46721 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46721,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46721,(1),null);
var iterys__4607__auto__ = ((function (s__46716__$1,vec__46721,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__46715_$_iter__46717(s__46718){
return (new cljs.core.LazySeq(null,((function (s__46716__$1,vec__46721,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__46718__$1 = s__46718;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__46718__$1);
if(temp__5753__auto____$1){
var s__46718__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__46718__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__46718__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__46720 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__46719 = (0);
while(true){
if((i__46719 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__46719);
cljs.core.chunk_append(b__46720,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__46750 = (i__46719 + (1));
i__46719 = G__46750;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__46720),tailrecursion$priority_map$iter__46715_$_iter__46717(cljs.core.chunk_rest(s__46718__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__46720),null);
}
} else {
var item = cljs.core.first(s__46718__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__46715_$_iter__46717(cljs.core.rest(s__46718__$2)));
}
} else {
return null;
}
break;
}
});})(s__46716__$1,vec__46721,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__46716__$1,vec__46721,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__46715(cljs.core.rest(s__46716__$1)));
} else {
var G__46751 = cljs.core.rest(s__46716__$1);
s__46716__$1 = G__46751;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__46752 = null;
var G__46752__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__46752__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__46752 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__46752__2.call(this,self__,item);
case 3:
return G__46752__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__46752.cljs$core$IFn$_invoke$arity$2 = G__46752__2;
G__46752.cljs$core$IFn$_invoke$arity$3 = G__46752__3;
return G__46752;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args46685){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args46685)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__46724 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__46724.cljs$core$IFn$_invoke$arity$1 ? fexpr__46724.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__46724.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__46725(s__46726){
return (new cljs.core.LazySeq(null,(function (){
var s__46726__$1 = s__46726;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__46726__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__46731 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46731,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46731,(1),null);
var iterys__4607__auto__ = ((function (s__46726__$1,vec__46731,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__46725_$_iter__46727(s__46728){
return (new cljs.core.LazySeq(null,((function (s__46726__$1,vec__46731,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__46728__$1 = s__46728;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__46728__$1);
if(temp__5753__auto____$1){
var s__46728__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__46728__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__46728__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__46730 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__46729 = (0);
while(true){
if((i__46729 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__46729);
cljs.core.chunk_append(b__46730,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__46753 = (i__46729 + (1));
i__46729 = G__46753;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__46730),tailrecursion$priority_map$iter__46725_$_iter__46727(cljs.core.chunk_rest(s__46728__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__46730),null);
}
} else {
var item = cljs.core.first(s__46728__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__46725_$_iter__46727(cljs.core.rest(s__46728__$2)));
}
} else {
return null;
}
break;
}
});})(s__46726__$1,vec__46731,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__46726__$1,vec__46731,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__46725(cljs.core.rest(s__46726__$1)));
} else {
var G__46754 = cljs.core.rest(s__46726__$1);
s__46726__$1 = G__46754;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__46734(s__46735){
return (new cljs.core.LazySeq(null,(function (){
var s__46735__$1 = s__46735;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__46735__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__46740 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46740,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46740,(1),null);
var iterys__4607__auto__ = ((function (s__46735__$1,vec__46740,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__46734_$_iter__46736(s__46737){
return (new cljs.core.LazySeq(null,((function (s__46735__$1,vec__46740,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__46737__$1 = s__46737;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__46737__$1);
if(temp__5753__auto____$1){
var s__46737__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__46737__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__46737__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__46739 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__46738 = (0);
while(true){
if((i__46738 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__46738);
cljs.core.chunk_append(b__46739,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__46755 = (i__46738 + (1));
i__46738 = G__46755;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__46739),tailrecursion$priority_map$iter__46734_$_iter__46736(cljs.core.chunk_rest(s__46737__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__46739),null);
}
} else {
var item = cljs.core.first(s__46737__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__46734_$_iter__46736(cljs.core.rest(s__46737__$2)));
}
} else {
return null;
}
break;
}
});})(s__46735__$1,vec__46740,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__46735__$1,vec__46740,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__46734(cljs.core.rest(s__46735__$1)));
} else {
var G__46756 = cljs.core.rest(s__46735__$1);
s__46735__$1 = G__46756;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__46743 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__46743) : self__.keyfn.call(null,G__46743));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__46758 = arguments.length;
switch (G__46758) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46761 = arguments.length;
var i__4819__auto___46762 = (0);
while(true){
if((i__4819__auto___46762 < len__4818__auto___46761)){
args__4824__auto__.push((arguments[i__4819__auto___46762]));

var G__46763 = (i__4819__auto___46762 + (1));
i__4819__auto___46762 = G__46763;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__46764 = cljs.core.nnext(in$);
var G__46765 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__46764;
out = G__46765;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq46760){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46760));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46768 = arguments.length;
var i__4819__auto___46769 = (0);
while(true){
if((i__4819__auto___46769 < len__4818__auto___46768)){
args__4824__auto__.push((arguments[i__4819__auto___46769]));

var G__46770 = (i__4819__auto___46769 + (1));
i__4819__auto___46769 = G__46770;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__46771 = cljs.core.nnext(in$);
var G__46772 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__46771;
out = G__46772;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq46766){
var G__46767 = cljs.core.first(seq46766);
var seq46766__$1 = cljs.core.next(seq46766);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46767,seq46766__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46775 = arguments.length;
var i__4819__auto___46776 = (0);
while(true){
if((i__4819__auto___46776 < len__4818__auto___46775)){
args__4824__auto__.push((arguments[i__4819__auto___46776]));

var G__46777 = (i__4819__auto___46776 + (1));
i__4819__auto___46776 = G__46777;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__46778 = cljs.core.nnext(in$);
var G__46779 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__46778;
out = G__46779;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq46773){
var G__46774 = cljs.core.first(seq46773);
var seq46773__$1 = cljs.core.next(seq46773);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46774,seq46773__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4824__auto__ = [];
var len__4818__auto___46783 = arguments.length;
var i__4819__auto___46784 = (0);
while(true){
if((i__4819__auto___46784 < len__4818__auto___46783)){
args__4824__auto__.push((arguments[i__4819__auto___46784]));

var G__46785 = (i__4819__auto___46784 + (1));
i__4819__auto___46784 = G__46785;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__46786 = cljs.core.nnext(in$);
var G__46787 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__46786;
out = G__46787;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq46780){
var G__46781 = cljs.core.first(seq46780);
var seq46780__$1 = cljs.core.next(seq46780);
var G__46782 = cljs.core.first(seq46780__$1);
var seq46780__$2 = cljs.core.next(seq46780__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46781,G__46782,seq46780__$2);
}));

