// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.response;
if(cljs.core.truth_(temp__5753__auto__)){
var resp = temp__5753__auto__;
var temp__5753__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5753__auto____$1)){
var st = temp__5753__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4210__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return (status >= (500));
} else {
return and__4210__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["XHTTP Request Error:",e.request], 0));

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return (status > (0));
} else {
return and__4210__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__38450 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38450,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__38450;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__38451 = opts;
var map__38451__$1 = cljs.core.__destructure_map(map__38451);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38451__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38451__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38451__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__38452 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__38452__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__38452,headers], 0)):G__38452);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38452__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__38452__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__38453 = opts;
var map__38453__$1 = cljs.core.__destructure_map(map__38453);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38453__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38453__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38453__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38453__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38453__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__38454 = cljs.core.PersistentArrayMap.EMPTY;
var G__38454__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__38454,headers], 0)):G__38454);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38454__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__38454__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__38455 = output_format;
var G__38455__$1 = (((G__38455 instanceof cljs.core.Keyword))?G__38455.fqn:null);
switch (G__38455__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__38457 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38457,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__38457;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_38489){
var state_val_38490 = (state_38489[(1)]);
if((state_val_38490 === (7))){
var inst_38485 = (state_38489[(2)]);
var state_38489__$1 = state_38489;
var statearr_38491_38516 = state_38489__$1;
(statearr_38491_38516[(2)] = inst_38485);

(statearr_38491_38516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (1))){
var state_38489__$1 = state_38489;
var statearr_38492_38517 = state_38489__$1;
(statearr_38492_38517[(2)] = null);

(statearr_38492_38517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (4))){
var inst_38460 = (state_38489[(7)]);
var inst_38460__$1 = (state_38489[(2)]);
var inst_38461 = (inst_38460__$1 == null);
var state_38489__$1 = (function (){var statearr_38493 = state_38489;
(statearr_38493[(7)] = inst_38460__$1);

return statearr_38493;
})();
if(cljs.core.truth_(inst_38461)){
var statearr_38494_38518 = state_38489__$1;
(statearr_38494_38518[(1)] = (5));

} else {
var statearr_38495_38519 = state_38489__$1;
(statearr_38495_38519[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (6))){
var inst_38460 = (state_38489[(7)]);
var inst_38468 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38460,(0),null);
var inst_38469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38460,(1),null);
var state_38489__$1 = (function (){var statearr_38496 = state_38489;
(statearr_38496[(8)] = inst_38468);

(statearr_38496[(9)] = inst_38469);

return statearr_38496;
})();
var statearr_38497_38520 = state_38489__$1;
(statearr_38497_38520[(2)] = null);

(statearr_38497_38520[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (3))){
var inst_38487 = (state_38489[(2)]);
var state_38489__$1 = state_38489;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38489__$1,inst_38487);
} else {
if((state_val_38490 === (2))){
var state_38489__$1 = state_38489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38489__$1,(4),pub_chan);
} else {
if((state_val_38490 === (11))){
var _ = (function (){var statearr_38499 = state_38489;
(statearr_38499[(4)] = cljs.core.rest((state_38489[(4)])));

return statearr_38499;
})();
var state_38489__$1 = state_38489;
var ex38498 = (state_38489__$1[(2)]);
var statearr_38500_38521 = state_38489__$1;
(statearr_38500_38521[(5)] = ex38498);


var statearr_38501_38522 = state_38489__$1;
(statearr_38501_38522[(1)] = (10));

(statearr_38501_38522[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (9))){
var inst_38482 = (state_38489[(2)]);
var state_38489__$1 = (function (){var statearr_38502 = state_38489;
(statearr_38502[(10)] = inst_38482);

return statearr_38502;
})();
var statearr_38503_38523 = state_38489__$1;
(statearr_38503_38523[(2)] = null);

(statearr_38503_38523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (5))){
var inst_38463 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_38489__$1 = state_38489;
var statearr_38504_38524 = state_38489__$1;
(statearr_38504_38524[(2)] = inst_38463);

(statearr_38504_38524[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (10))){
var inst_38468 = (state_38489[(8)]);
var inst_38469 = (state_38489[(9)]);
var inst_38470 = (state_38489[(2)]);
var inst_38471 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38470,"Error sending websocket message:",inst_38468], 0));
var inst_38472 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38469,false);
var state_38489__$1 = (function (){var statearr_38505 = state_38489;
(statearr_38505[(11)] = inst_38471);

return statearr_38505;
})();
var statearr_38506_38525 = state_38489__$1;
(statearr_38506_38525[(2)] = inst_38472);

(statearr_38506_38525[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (8))){
var inst_38468 = (state_38489[(8)]);
var inst_38469 = (state_38489[(9)]);
var _ = (function (){var statearr_38507 = state_38489;
(statearr_38507[(4)] = cljs.core.cons((11),(state_38489[(4)])));

return statearr_38507;
})();
var inst_38478 = ws.send(inst_38468);
var inst_38479 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38469,true);
var ___$1 = (function (){var statearr_38508 = state_38489;
(statearr_38508[(4)] = cljs.core.rest((state_38489[(4)])));

return statearr_38508;
})();
var state_38489__$1 = (function (){var statearr_38509 = state_38489;
(statearr_38509[(12)] = inst_38478);

return statearr_38509;
})();
var statearr_38510_38526 = state_38489__$1;
(statearr_38510_38526[(2)] = inst_38479);

(statearr_38510_38526[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17178__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17178__auto____0 = (function (){
var statearr_38511 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38511[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17178__auto__);

(statearr_38511[(1)] = (1));

return statearr_38511;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17178__auto____1 = (function (state_38489){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_38489);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e38512){var ex__17181__auto__ = e38512;
var statearr_38513_38527 = state_38489;
(statearr_38513_38527[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_38489[(4)]))){
var statearr_38514_38528 = state_38489;
(statearr_38514_38528[(1)] = cljs.core.first((state_38489[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38529 = state_38489;
state_38489 = G__38529;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17178__auto__ = function(state_38489){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17178__auto____1.call(this,state_38489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17178__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17178__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_38515 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_38515[(6)] = c__17304__auto__);

return statearr_38515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__17304__auto___38567 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_38554){
var state_val_38555 = (state_38554[(1)]);
if((state_val_38555 === (1))){
var inst_38533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38534 = [open_QMARK_,timeout_chan];
var inst_38535 = (new cljs.core.PersistentVector(null,2,(5),inst_38533,inst_38534,null));
var state_38554__$1 = state_38554;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_38554__$1,(2),inst_38535,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_38555 === (2))){
var inst_38537 = (state_38554[(2)]);
var inst_38538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38537,(0),null);
var inst_38539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38537,(1),null);
var inst_38540 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38539,timeout_chan);
var state_38554__$1 = (function (){var statearr_38556 = state_38554;
(statearr_38556[(7)] = inst_38538);

return statearr_38556;
})();
if(inst_38540){
var statearr_38557_38568 = state_38554__$1;
(statearr_38557_38568[(1)] = (3));

} else {
var statearr_38558_38569 = state_38554__$1;
(statearr_38558_38569[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38555 === (3))){
var inst_38542 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_38543 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38544 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_38545 = cljs.core.PersistentHashMap.fromArrays(inst_38543,inst_38544);
var inst_38546 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38542,inst_38545);
var inst_38547 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_38546);
var inst_38548 = fluree.db.util.xhttp.close_websocket(ws);
var state_38554__$1 = (function (){var statearr_38559 = state_38554;
(statearr_38559[(8)] = inst_38547);

return statearr_38559;
})();
var statearr_38560_38570 = state_38554__$1;
(statearr_38560_38570[(2)] = inst_38548);

(statearr_38560_38570[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38555 === (4))){
var inst_38550 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_38554__$1 = state_38554;
var statearr_38561_38571 = state_38554__$1;
(statearr_38561_38571[(2)] = inst_38550);

(statearr_38561_38571[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38555 === (5))){
var inst_38552 = (state_38554[(2)]);
var state_38554__$1 = state_38554;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38554__$1,inst_38552);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__17178__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__17178__auto____0 = (function (){
var statearr_38562 = [null,null,null,null,null,null,null,null,null];
(statearr_38562[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__17178__auto__);

(statearr_38562[(1)] = (1));

return statearr_38562;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__17178__auto____1 = (function (state_38554){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_38554);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e38563){var ex__17181__auto__ = e38563;
var statearr_38564_38572 = state_38554;
(statearr_38564_38572[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_38554[(4)]))){
var statearr_38565_38573 = state_38554;
(statearr_38565_38573[(1)] = cljs.core.first((state_38554[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38574 = state_38554;
state_38554 = G__38574;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__17178__auto__ = function(state_38554){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__17178__auto____1.call(this,state_38554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__17178__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__17178__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_38566 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_38566[(6)] = c__17304__auto___38567);

return statearr_38566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
