// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_35881){
var state_val_35882 = (state_35881[(1)]);
if((state_val_35882 === (7))){
var inst_35870 = (state_35881[(7)]);
var inst_35872 = fluree.db.storage.core.serde(conn);
var inst_35873 = fluree.db.serde.protocol._deserialize_block(inst_35872,inst_35870);
var state_35881__$1 = state_35881;
var statearr_35883_35902 = state_35881__$1;
(statearr_35883_35902[(2)] = inst_35873);

(statearr_35883_35902[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35882 === (1))){
var state_35881__$1 = state_35881;
var statearr_35884_35903 = state_35881__$1;
(statearr_35884_35903[(2)] = null);

(statearr_35884_35903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35882 === (4))){
var inst_35860 = (state_35881[(2)]);
var state_35881__$1 = state_35881;
var statearr_35885_35904 = state_35881__$1;
(statearr_35885_35904[(2)] = inst_35860);

(statearr_35885_35904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35882 === (6))){
var inst_35870 = (state_35881[(7)]);
var inst_35869 = (state_35881[(2)]);
var inst_35870__$1 = fluree.db.util.async.throw_err(inst_35869);
var state_35881__$1 = (function (){var statearr_35886 = state_35881;
(statearr_35886[(7)] = inst_35870__$1);

return statearr_35886;
})();
if(cljs.core.truth_(inst_35870__$1)){
var statearr_35887_35905 = state_35881__$1;
(statearr_35887_35905[(1)] = (7));

} else {
var statearr_35888_35906 = state_35881__$1;
(statearr_35888_35906[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35882 === (3))){
var inst_35879 = (state_35881[(2)]);
var state_35881__$1 = state_35881;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35881__$1,inst_35879);
} else {
if((state_val_35882 === (2))){
var _ = (function (){var statearr_35890 = state_35881;
(statearr_35890[(4)] = cljs.core.cons((5),(state_35881[(4)])));

return statearr_35890;
})();
var inst_35866 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_35867 = fluree.db.storage.core.storage_read(conn,inst_35866);
var state_35881__$1 = state_35881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35881__$1,(6),inst_35867);
} else {
if((state_val_35882 === (9))){
var inst_35876 = (state_35881[(2)]);
var _ = (function (){var statearr_35891 = state_35881;
(statearr_35891[(4)] = cljs.core.rest((state_35881[(4)])));

return statearr_35891;
})();
var state_35881__$1 = state_35881;
var statearr_35892_35907 = state_35881__$1;
(statearr_35892_35907[(2)] = inst_35876);

(statearr_35892_35907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35882 === (5))){
var _ = (function (){var statearr_35893 = state_35881;
(statearr_35893[(4)] = cljs.core.rest((state_35881[(4)])));

return statearr_35893;
})();
var state_35881__$1 = state_35881;
var ex35889 = (state_35881__$1[(2)]);
var statearr_35894_35908 = state_35881__$1;
(statearr_35894_35908[(5)] = ex35889);


if((ex35889 instanceof Error)){
var statearr_35895_35909 = state_35881__$1;
(statearr_35895_35909[(1)] = (4));

(statearr_35895_35909[(5)] = null);

} else {
throw ex35889;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35882 === (8))){
var state_35881__$1 = state_35881;
var statearr_35896_35910 = state_35881__$1;
(statearr_35896_35910[(2)] = null);

(statearr_35896_35910[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__17178__auto____0 = (function (){
var statearr_35897 = [null,null,null,null,null,null,null,null];
(statearr_35897[(0)] = fluree$db$storage$core$read_block_$_state_machine__17178__auto__);

(statearr_35897[(1)] = (1));

return statearr_35897;
});
var fluree$db$storage$core$read_block_$_state_machine__17178__auto____1 = (function (state_35881){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_35881);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e35898){var ex__17181__auto__ = e35898;
var statearr_35899_35911 = state_35881;
(statearr_35899_35911[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_35881[(4)]))){
var statearr_35900_35912 = state_35881;
(statearr_35900_35912[(1)] = cljs.core.first((state_35881[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35913 = state_35881;
state_35881 = G__35913;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__17178__auto__ = function(state_35881){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__17178__auto____1.call(this,state_35881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__17178__auto____0;
fluree$db$storage$core$read_block_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__17178__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_35901 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_35901[(6)] = c__17304__auto__);

return statearr_35901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_35936){
var state_val_35937 = (state_35936[(1)]);
if((state_val_35937 === (7))){
var inst_35925 = (state_35936[(7)]);
var inst_35927 = fluree.db.storage.core.serde(conn);
var inst_35928 = fluree.db.serde.protocol._deserialize_block(inst_35927,inst_35925);
var state_35936__$1 = state_35936;
var statearr_35938_35957 = state_35936__$1;
(statearr_35938_35957[(2)] = inst_35928);

(statearr_35938_35957[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (1))){
var state_35936__$1 = state_35936;
var statearr_35939_35958 = state_35936__$1;
(statearr_35939_35958[(2)] = null);

(statearr_35939_35958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (4))){
var inst_35914 = (state_35936[(2)]);
var state_35936__$1 = state_35936;
var statearr_35940_35959 = state_35936__$1;
(statearr_35940_35959[(2)] = inst_35914);

(statearr_35940_35959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (6))){
var inst_35925 = (state_35936[(7)]);
var inst_35924 = (state_35936[(2)]);
var inst_35925__$1 = fluree.db.util.async.throw_err(inst_35924);
var state_35936__$1 = (function (){var statearr_35941 = state_35936;
(statearr_35941[(7)] = inst_35925__$1);

return statearr_35941;
})();
if(cljs.core.truth_(inst_35925__$1)){
var statearr_35942_35960 = state_35936__$1;
(statearr_35942_35960[(1)] = (7));

} else {
var statearr_35943_35961 = state_35936__$1;
(statearr_35943_35961[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (3))){
var inst_35934 = (state_35936[(2)]);
var state_35936__$1 = state_35936;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35936__$1,inst_35934);
} else {
if((state_val_35937 === (2))){
var _ = (function (){var statearr_35945 = state_35936;
(statearr_35945[(4)] = cljs.core.cons((5),(state_35936[(4)])));

return statearr_35945;
})();
var inst_35920 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_35921 = [inst_35920,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_35922 = fluree.db.storage.core.storage_read(conn,inst_35921);
var state_35936__$1 = state_35936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35936__$1,(6),inst_35922);
} else {
if((state_val_35937 === (9))){
var inst_35931 = (state_35936[(2)]);
var _ = (function (){var statearr_35946 = state_35936;
(statearr_35946[(4)] = cljs.core.rest((state_35936[(4)])));

return statearr_35946;
})();
var state_35936__$1 = state_35936;
var statearr_35947_35962 = state_35936__$1;
(statearr_35947_35962[(2)] = inst_35931);

(statearr_35947_35962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (5))){
var _ = (function (){var statearr_35948 = state_35936;
(statearr_35948[(4)] = cljs.core.rest((state_35936[(4)])));

return statearr_35948;
})();
var state_35936__$1 = state_35936;
var ex35944 = (state_35936__$1[(2)]);
var statearr_35949_35963 = state_35936__$1;
(statearr_35949_35963[(5)] = ex35944);


if((ex35944 instanceof Error)){
var statearr_35950_35964 = state_35936__$1;
(statearr_35950_35964[(1)] = (4));

(statearr_35950_35964[(5)] = null);

} else {
throw ex35944;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35937 === (8))){
var state_35936__$1 = state_35936;
var statearr_35951_35965 = state_35936__$1;
(statearr_35951_35965[(2)] = null);

(statearr_35951_35965[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__17178__auto____0 = (function (){
var statearr_35952 = [null,null,null,null,null,null,null,null];
(statearr_35952[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__17178__auto__);

(statearr_35952[(1)] = (1));

return statearr_35952;
});
var fluree$db$storage$core$read_block_version_$_state_machine__17178__auto____1 = (function (state_35936){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_35936);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e35953){var ex__17181__auto__ = e35953;
var statearr_35954_35966 = state_35936;
(statearr_35954_35966[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_35936[(4)]))){
var statearr_35955_35967 = state_35936;
(statearr_35955_35967[(1)] = cljs.core.first((state_35936[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35968 = state_35936;
state_35936 = G__35968;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__17178__auto__ = function(state_35936){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__17178__auto____1.call(this,state_35936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__17178__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__17178__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_35956 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_35956[(6)] = c__17304__auto__);

return statearr_35956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_35992){
var state_val_35993 = (state_35992[(1)]);
if((state_val_35993 === (1))){
var state_35992__$1 = state_35992;
var statearr_35994_36008 = state_35992__$1;
(statearr_35994_36008[(2)] = null);

(statearr_35994_36008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35993 === (2))){
var _ = (function (){var statearr_35995 = state_35992;
(statearr_35995[(4)] = cljs.core.cons((5),(state_35992[(4)])));

return statearr_35995;
})();
var inst_35975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35976 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_35977 = (new cljs.core.PersistentVector(null,3,(5),inst_35975,inst_35976,null));
var inst_35978 = cljs.core.select_keys(block_data,inst_35977);
var inst_35979 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_35978);
var inst_35980 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_35979);
var inst_35981 = [inst_35980,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_35982 = fluree.db.storage.core.serde(conn);
var inst_35983 = fluree.db.serde.protocol._serialize_block(inst_35982,inst_35978);
var inst_35984 = fluree.db.storage.core.storage_write(conn,inst_35981,inst_35983);
var state_35992__$1 = state_35992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35992__$1,(6),inst_35984);
} else {
if((state_val_35993 === (3))){
var inst_35990 = (state_35992[(2)]);
var state_35992__$1 = state_35992;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35992__$1,inst_35990);
} else {
if((state_val_35993 === (4))){
var inst_35969 = (state_35992[(2)]);
var state_35992__$1 = state_35992;
var statearr_35997_36009 = state_35992__$1;
(statearr_35997_36009[(2)] = inst_35969);

(statearr_35997_36009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35993 === (5))){
var _ = (function (){var statearr_35998 = state_35992;
(statearr_35998[(4)] = cljs.core.rest((state_35992[(4)])));

return statearr_35998;
})();
var state_35992__$1 = state_35992;
var ex35996 = (state_35992__$1[(2)]);
var statearr_35999_36010 = state_35992__$1;
(statearr_35999_36010[(5)] = ex35996);


if((ex35996 instanceof Error)){
var statearr_36000_36011 = state_35992__$1;
(statearr_36000_36011[(1)] = (4));

(statearr_36000_36011[(5)] = null);

} else {
throw ex35996;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35993 === (6))){
var inst_35986 = (state_35992[(2)]);
var inst_35987 = fluree.db.util.async.throw_err(inst_35986);
var _ = (function (){var statearr_36001 = state_35992;
(statearr_36001[(4)] = cljs.core.rest((state_35992[(4)])));

return statearr_36001;
})();
var state_35992__$1 = state_35992;
var statearr_36002_36012 = state_35992__$1;
(statearr_36002_36012[(2)] = inst_35987);

(statearr_36002_36012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__17178__auto____0 = (function (){
var statearr_36003 = [null,null,null,null,null,null,null];
(statearr_36003[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__17178__auto__);

(statearr_36003[(1)] = (1));

return statearr_36003;
});
var fluree$db$storage$core$write_block_version_$_state_machine__17178__auto____1 = (function (state_35992){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_35992);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36004){var ex__17181__auto__ = e36004;
var statearr_36005_36013 = state_35992;
(statearr_36005_36013[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_35992[(4)]))){
var statearr_36006_36014 = state_35992;
(statearr_36006_36014[(1)] = cljs.core.first((state_35992[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36015 = state_35992;
state_35992 = G__36015;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__17178__auto__ = function(state_35992){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__17178__auto____1.call(this,state_35992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__17178__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__17178__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36007 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36007[(6)] = c__17304__auto__);

return statearr_36007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36038){
var state_val_36039 = (state_36038[(1)]);
if((state_val_36039 === (1))){
var state_36038__$1 = state_36038;
var statearr_36040_36054 = state_36038__$1;
(statearr_36040_36054[(2)] = null);

(statearr_36040_36054[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36039 === (2))){
var _ = (function (){var statearr_36041 = state_36038;
(statearr_36041[(4)] = cljs.core.cons((5),(state_36038[(4)])));

return statearr_36041;
})();
var inst_36022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36023 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_36024 = (new cljs.core.PersistentVector(null,3,(5),inst_36022,inst_36023,null));
var inst_36025 = cljs.core.select_keys(block_data,inst_36024);
var inst_36026 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_36025);
var inst_36027 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_36026);
var inst_36028 = fluree.db.storage.core.serde(conn);
var inst_36029 = fluree.db.serde.protocol._serialize_block(inst_36028,inst_36025);
var inst_36030 = fluree.db.storage.core.storage_write(conn,inst_36027,inst_36029);
var state_36038__$1 = state_36038;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36038__$1,(6),inst_36030);
} else {
if((state_val_36039 === (3))){
var inst_36036 = (state_36038[(2)]);
var state_36038__$1 = state_36038;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36038__$1,inst_36036);
} else {
if((state_val_36039 === (4))){
var inst_36016 = (state_36038[(2)]);
var state_36038__$1 = state_36038;
var statearr_36043_36055 = state_36038__$1;
(statearr_36043_36055[(2)] = inst_36016);

(statearr_36043_36055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36039 === (5))){
var _ = (function (){var statearr_36044 = state_36038;
(statearr_36044[(4)] = cljs.core.rest((state_36038[(4)])));

return statearr_36044;
})();
var state_36038__$1 = state_36038;
var ex36042 = (state_36038__$1[(2)]);
var statearr_36045_36056 = state_36038__$1;
(statearr_36045_36056[(5)] = ex36042);


if((ex36042 instanceof Error)){
var statearr_36046_36057 = state_36038__$1;
(statearr_36046_36057[(1)] = (4));

(statearr_36046_36057[(5)] = null);

} else {
throw ex36042;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36039 === (6))){
var inst_36032 = (state_36038[(2)]);
var inst_36033 = fluree.db.util.async.throw_err(inst_36032);
var _ = (function (){var statearr_36047 = state_36038;
(statearr_36047[(4)] = cljs.core.rest((state_36038[(4)])));

return statearr_36047;
})();
var state_36038__$1 = state_36038;
var statearr_36048_36058 = state_36038__$1;
(statearr_36048_36058[(2)] = inst_36033);

(statearr_36048_36058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__17178__auto____0 = (function (){
var statearr_36049 = [null,null,null,null,null,null,null];
(statearr_36049[(0)] = fluree$db$storage$core$write_block_$_state_machine__17178__auto__);

(statearr_36049[(1)] = (1));

return statearr_36049;
});
var fluree$db$storage$core$write_block_$_state_machine__17178__auto____1 = (function (state_36038){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36038);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36050){var ex__17181__auto__ = e36050;
var statearr_36051_36059 = state_36038;
(statearr_36051_36059[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36038[(4)]))){
var statearr_36052_36060 = state_36038;
(statearr_36052_36060[(1)] = cljs.core.first((state_36038[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36061 = state_36038;
state_36038 = G__36061;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__17178__auto__ = function(state_36038){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__17178__auto____1.call(this,state_36038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__17178__auto____0;
fluree$db$storage$core$write_block_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__17178__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36053 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36053[(6)] = c__17304__auto__);

return statearr_36053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36081){
var state_val_36082 = (state_36081[(1)]);
if((state_val_36082 === (1))){
var state_36081__$1 = state_36081;
var statearr_36083_36097 = state_36081__$1;
(statearr_36083_36097[(2)] = null);

(statearr_36083_36097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36082 === (2))){
var _ = (function (){var statearr_36084 = state_36081;
(statearr_36084[(4)] = cljs.core.cons((5),(state_36081[(4)])));

return statearr_36084;
})();
var inst_36068 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_36069 = [history,next_his_key];
var inst_36070 = cljs.core.PersistentHashMap.fromArrays(inst_36068,inst_36069);
var inst_36071 = fluree.db.storage.core.serde(conn);
var inst_36072 = fluree.db.serde.protocol._serialize_leaf(inst_36071,inst_36070);
var inst_36073 = fluree.db.storage.core.storage_write(conn,his_key,inst_36072);
var state_36081__$1 = state_36081;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36081__$1,(6),inst_36073);
} else {
if((state_val_36082 === (3))){
var inst_36079 = (state_36081[(2)]);
var state_36081__$1 = state_36081;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36081__$1,inst_36079);
} else {
if((state_val_36082 === (4))){
var inst_36062 = (state_36081[(2)]);
var state_36081__$1 = state_36081;
var statearr_36086_36098 = state_36081__$1;
(statearr_36086_36098[(2)] = inst_36062);

(statearr_36086_36098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36082 === (5))){
var _ = (function (){var statearr_36087 = state_36081;
(statearr_36087[(4)] = cljs.core.rest((state_36081[(4)])));

return statearr_36087;
})();
var state_36081__$1 = state_36081;
var ex36085 = (state_36081__$1[(2)]);
var statearr_36088_36099 = state_36081__$1;
(statearr_36088_36099[(5)] = ex36085);


if((ex36085 instanceof Error)){
var statearr_36089_36100 = state_36081__$1;
(statearr_36089_36100[(1)] = (4));

(statearr_36089_36100[(5)] = null);

} else {
throw ex36085;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36082 === (6))){
var inst_36075 = (state_36081[(2)]);
var inst_36076 = fluree.db.util.async.throw_err(inst_36075);
var _ = (function (){var statearr_36090 = state_36081;
(statearr_36090[(4)] = cljs.core.rest((state_36081[(4)])));

return statearr_36090;
})();
var state_36081__$1 = state_36081;
var statearr_36091_36101 = state_36081__$1;
(statearr_36091_36101[(2)] = inst_36076);

(statearr_36091_36101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__17178__auto____0 = (function (){
var statearr_36092 = [null,null,null,null,null,null,null];
(statearr_36092[(0)] = fluree$db$storage$core$write_history_$_state_machine__17178__auto__);

(statearr_36092[(1)] = (1));

return statearr_36092;
});
var fluree$db$storage$core$write_history_$_state_machine__17178__auto____1 = (function (state_36081){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36081);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36093){var ex__17181__auto__ = e36093;
var statearr_36094_36102 = state_36081;
(statearr_36094_36102[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36081[(4)]))){
var statearr_36095_36103 = state_36081;
(statearr_36095_36103[(1)] = cljs.core.first((state_36081[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36104 = state_36081;
state_36081 = G__36104;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__17178__auto__ = function(state_36081){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__17178__auto____1.call(this,state_36081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__17178__auto____0;
fluree$db$storage$core$write_history_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__17178__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36096 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36096[(6)] = c__17304__auto__);

return statearr_36096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36130){
var state_val_36131 = (state_36130[(1)]);
if((state_val_36131 === (1))){
var state_36130__$1 = state_36130;
var statearr_36132_36149 = state_36130__$1;
(statearr_36132_36149[(2)] = null);

(statearr_36132_36149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36131 === (2))){
var inst_36111 = (state_36130[(7)]);
var _ = (function (){var statearr_36133 = state_36130;
(statearr_36133[(4)] = cljs.core.cons((5),(state_36130[(4)])));

return statearr_36133;
})();
var inst_36111__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_36112 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36111__$1),"-his"].join('');
var inst_36113 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_36114 = [flakes,inst_36112];
var inst_36115 = cljs.core.PersistentHashMap.fromArrays(inst_36113,inst_36114);
var inst_36116 = fluree.db.storage.core.serde(conn);
var inst_36117 = fluree.db.serde.protocol._serialize_leaf(inst_36116,inst_36115);
var inst_36118 = fluree.db.storage.core.write_history(conn,history,inst_36112,null);
var inst_36119 = fluree.db.storage.core.storage_write(conn,inst_36111__$1,inst_36117);
var state_36130__$1 = (function (){var statearr_36134 = state_36130;
(statearr_36134[(8)] = inst_36119);

(statearr_36134[(7)] = inst_36111__$1);

return statearr_36134;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36130__$1,(6),inst_36118);
} else {
if((state_val_36131 === (3))){
var inst_36128 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36130__$1,inst_36128);
} else {
if((state_val_36131 === (4))){
var inst_36105 = (state_36130[(2)]);
var state_36130__$1 = state_36130;
var statearr_36136_36150 = state_36130__$1;
(statearr_36136_36150[(2)] = inst_36105);

(statearr_36136_36150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36131 === (5))){
var _ = (function (){var statearr_36137 = state_36130;
(statearr_36137[(4)] = cljs.core.rest((state_36130[(4)])));

return statearr_36137;
})();
var state_36130__$1 = state_36130;
var ex36135 = (state_36130__$1[(2)]);
var statearr_36138_36151 = state_36130__$1;
(statearr_36138_36151[(5)] = ex36135);


if((ex36135 instanceof Error)){
var statearr_36139_36152 = state_36130__$1;
(statearr_36139_36152[(1)] = (4));

(statearr_36139_36152[(5)] = null);

} else {
throw ex36135;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36131 === (6))){
var inst_36119 = (state_36130[(8)]);
var inst_36121 = (state_36130[(2)]);
var inst_36122 = fluree.db.util.async.throw_err(inst_36121);
var state_36130__$1 = (function (){var statearr_36140 = state_36130;
(statearr_36140[(9)] = inst_36122);

return statearr_36140;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36130__$1,(7),inst_36119);
} else {
if((state_val_36131 === (7))){
var inst_36111 = (state_36130[(7)]);
var inst_36124 = (state_36130[(2)]);
var inst_36125 = fluree.db.util.async.throw_err(inst_36124);
var _ = (function (){var statearr_36141 = state_36130;
(statearr_36141[(4)] = cljs.core.rest((state_36130[(4)])));

return statearr_36141;
})();
var state_36130__$1 = (function (){var statearr_36142 = state_36130;
(statearr_36142[(10)] = inst_36125);

return statearr_36142;
})();
var statearr_36143_36153 = state_36130__$1;
(statearr_36143_36153[(2)] = inst_36111);

(statearr_36143_36153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__17178__auto____0 = (function (){
var statearr_36144 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36144[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__17178__auto__);

(statearr_36144[(1)] = (1));

return statearr_36144;
});
var fluree$db$storage$core$write_leaf_$_state_machine__17178__auto____1 = (function (state_36130){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36130);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36145){var ex__17181__auto__ = e36145;
var statearr_36146_36154 = state_36130;
(statearr_36146_36154[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36130[(4)]))){
var statearr_36147_36155 = state_36130;
(statearr_36147_36155[(1)] = cljs.core.first((state_36130[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36156 = state_36130;
state_36130 = G__36156;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__17178__auto__ = function(state_36130){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__17178__auto____1.call(this,state_36130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__17178__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__17178__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36148 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36148[(6)] = c__17304__auto__);

return statearr_36148;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36173){
var state_val_36174 = (state_36173[(1)]);
if((state_val_36174 === (1))){
var state_36173__$1 = state_36173;
var statearr_36175_36190 = state_36173__$1;
(statearr_36175_36190[(2)] = null);

(statearr_36175_36190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36174 === (2))){
var _ = (function (){var statearr_36176 = state_36173;
(statearr_36176[(4)] = cljs.core.cons((5),(state_36173[(4)])));

return statearr_36176;
})();
var inst_36163 = fluree.db.storage.core.serde(conn);
var inst_36164 = fluree.db.serde.protocol._serialize_branch(inst_36163,data);
var inst_36165 = fluree.db.storage.core.storage_write(conn,key,inst_36164);
var state_36173__$1 = state_36173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36173__$1,(6),inst_36165);
} else {
if((state_val_36174 === (3))){
var inst_36171 = (state_36173[(2)]);
var state_36173__$1 = state_36173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36173__$1,inst_36171);
} else {
if((state_val_36174 === (4))){
var inst_36157 = (state_36173[(2)]);
var state_36173__$1 = state_36173;
var statearr_36178_36191 = state_36173__$1;
(statearr_36178_36191[(2)] = inst_36157);

(statearr_36178_36191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36174 === (5))){
var _ = (function (){var statearr_36179 = state_36173;
(statearr_36179[(4)] = cljs.core.rest((state_36173[(4)])));

return statearr_36179;
})();
var state_36173__$1 = state_36173;
var ex36177 = (state_36173__$1[(2)]);
var statearr_36180_36192 = state_36173__$1;
(statearr_36180_36192[(5)] = ex36177);


if((ex36177 instanceof Error)){
var statearr_36181_36193 = state_36173__$1;
(statearr_36181_36193[(1)] = (4));

(statearr_36181_36193[(5)] = null);

} else {
throw ex36177;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36174 === (6))){
var inst_36167 = (state_36173[(2)]);
var inst_36168 = fluree.db.util.async.throw_err(inst_36167);
var _ = (function (){var statearr_36182 = state_36173;
(statearr_36182[(4)] = cljs.core.rest((state_36173[(4)])));

return statearr_36182;
})();
var state_36173__$1 = (function (){var statearr_36183 = state_36173;
(statearr_36183[(7)] = inst_36168);

return statearr_36183;
})();
var statearr_36184_36194 = state_36173__$1;
(statearr_36184_36194[(2)] = key);

(statearr_36184_36194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__17178__auto____0 = (function (){
var statearr_36185 = [null,null,null,null,null,null,null,null];
(statearr_36185[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__17178__auto__);

(statearr_36185[(1)] = (1));

return statearr_36185;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__17178__auto____1 = (function (state_36173){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36173);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36186){var ex__17181__auto__ = e36186;
var statearr_36187_36195 = state_36173;
(statearr_36187_36195[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36173[(4)]))){
var statearr_36188_36196 = state_36173;
(statearr_36188_36196[(1)] = cljs.core.first((state_36173[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36197 = state_36173;
state_36173 = G__36197;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__17178__auto__ = function(state_36173){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__17178__auto____1.call(this,state_36173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__17178__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__17178__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36189 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36189[(6)] = c__17304__auto__);

return statearr_36189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__36198_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__36198_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__36199){
var map__36200 = p__36199;
var map__36200__$1 = cljs.core.__destructure_map(map__36200);
var progress = map__36200__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36200__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36228){
var state_val_36229 = (state_36228[(1)]);
if((state_val_36229 === (1))){
var state_36228__$1 = state_36228;
var statearr_36230_36246 = state_36228__$1;
(statearr_36230_36246[(2)] = null);

(statearr_36230_36246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36229 === (2))){
var inst_36214 = (state_36228[(7)]);
var _ = (function (){var statearr_36231 = state_36228;
(statearr_36231[(4)] = cljs.core.cons((5),(state_36228[(4)])));

return statearr_36231;
})();
var inst_36208 = db;
var inst_36209 = cljs.core.__destructure_map(inst_36208);
var inst_36210 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36209,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_36211 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36209,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_36212 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36209,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_36213 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36209,new cljs.core.Keyword(null,"block","block",664686210));
var inst_36214__$1 = fluree.db.storage.core.ledger_garbage_key(inst_36211,inst_36212,inst_36213);
var inst_36215 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_36216 = [inst_36212,inst_36213,garbage];
var inst_36217 = cljs.core.PersistentHashMap.fromArrays(inst_36215,inst_36216);
var inst_36218 = fluree.db.storage.core.serde(inst_36210);
var inst_36219 = fluree.db.serde.protocol._serialize_garbage(inst_36218,inst_36217);
var inst_36220 = fluree.db.storage.core.storage_write(inst_36210,inst_36214__$1,inst_36219);
var state_36228__$1 = (function (){var statearr_36232 = state_36228;
(statearr_36232[(7)] = inst_36214__$1);

return statearr_36232;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36228__$1,(6),inst_36220);
} else {
if((state_val_36229 === (3))){
var inst_36226 = (state_36228[(2)]);
var state_36228__$1 = state_36228;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36228__$1,inst_36226);
} else {
if((state_val_36229 === (4))){
var inst_36201 = (state_36228[(2)]);
var state_36228__$1 = state_36228;
var statearr_36234_36247 = state_36228__$1;
(statearr_36234_36247[(2)] = inst_36201);

(statearr_36234_36247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36229 === (5))){
var _ = (function (){var statearr_36235 = state_36228;
(statearr_36235[(4)] = cljs.core.rest((state_36228[(4)])));

return statearr_36235;
})();
var state_36228__$1 = state_36228;
var ex36233 = (state_36228__$1[(2)]);
var statearr_36236_36248 = state_36228__$1;
(statearr_36236_36248[(5)] = ex36233);


if((ex36233 instanceof Error)){
var statearr_36237_36249 = state_36228__$1;
(statearr_36237_36249[(1)] = (4));

(statearr_36237_36249[(5)] = null);

} else {
throw ex36233;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36229 === (6))){
var inst_36214 = (state_36228[(7)]);
var inst_36222 = (state_36228[(2)]);
var inst_36223 = fluree.db.util.async.throw_err(inst_36222);
var _ = (function (){var statearr_36238 = state_36228;
(statearr_36238[(4)] = cljs.core.rest((state_36228[(4)])));

return statearr_36238;
})();
var state_36228__$1 = (function (){var statearr_36239 = state_36228;
(statearr_36239[(8)] = inst_36223);

return statearr_36239;
})();
var statearr_36240_36250 = state_36228__$1;
(statearr_36240_36250[(2)] = inst_36214);

(statearr_36240_36250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__17178__auto____0 = (function (){
var statearr_36241 = [null,null,null,null,null,null,null,null,null];
(statearr_36241[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__17178__auto__);

(statearr_36241[(1)] = (1));

return statearr_36241;
});
var fluree$db$storage$core$write_garbage_$_state_machine__17178__auto____1 = (function (state_36228){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36228);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36242){var ex__17181__auto__ = e36242;
var statearr_36243_36251 = state_36228;
(statearr_36243_36251[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36228[(4)]))){
var statearr_36244_36252 = state_36228;
(statearr_36244_36252[(1)] = cljs.core.first((state_36228[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36253 = state_36228;
state_36228 = G__36253;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__17178__auto__ = function(state_36228){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__17178__auto____1.call(this,state_36228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__17178__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__17178__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36245 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36245[(6)] = c__17304__auto__);

return statearr_36245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__36255 = arguments.length;
switch (G__36255) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36311){
var state_val_36312 = (state_36311[(1)]);
if((state_val_36312 === (7))){
var state_36311__$1 = state_36311;
var statearr_36313_36339 = state_36311__$1;
(statearr_36313_36339[(2)] = (0));

(statearr_36313_36339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36312 === (1))){
var state_36311__$1 = state_36311;
var statearr_36314_36340 = state_36311__$1;
(statearr_36314_36340[(2)] = null);

(statearr_36314_36340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36312 === (4))){
var inst_36256 = (state_36311[(2)]);
var state_36311__$1 = state_36311;
var statearr_36315_36341 = state_36311__$1;
(statearr_36315_36341[(2)] = inst_36256);

(statearr_36315_36341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36312 === (6))){
var inst_36281 = (state_36311[(7)]);
var state_36311__$1 = state_36311;
var statearr_36316_36342 = state_36311__$1;
(statearr_36316_36342[(2)] = inst_36281);

(statearr_36316_36342[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36312 === (3))){
var inst_36309 = (state_36311[(2)]);
var state_36311__$1 = state_36311;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36311__$1,inst_36309);
} else {
if((state_val_36312 === (12))){
var inst_36278 = (state_36311[(8)]);
var inst_36305 = (state_36311[(2)]);
var inst_36306 = fluree.db.util.async.throw_err(inst_36305);
var _ = (function (){var statearr_36317 = state_36311;
(statearr_36317[(4)] = cljs.core.rest((state_36311[(4)])));

return statearr_36317;
})();
var state_36311__$1 = (function (){var statearr_36318 = state_36311;
(statearr_36318[(9)] = inst_36306);

return statearr_36318;
})();
var statearr_36319_36343 = state_36311__$1;
(statearr_36319_36343[(2)] = inst_36278);

(statearr_36319_36343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36312 === (2))){
var inst_36281 = (state_36311[(7)]);
var inst_36271 = (state_36311[(10)]);
var inst_36269 = (state_36311[(11)]);
var inst_36273 = (state_36311[(12)]);
var _ = (function (){var statearr_36320 = state_36311;
(statearr_36320[(4)] = cljs.core.cons((5),(state_36311[(4)])));

return statearr_36320;
})();
var inst_36263 = db;
var inst_36264 = cljs.core.__destructure_map(inst_36263);
var inst_36265 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_36266 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_36267 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_36268 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_36269__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_36270 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_36271__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"block","block",664686210));
var inst_36272 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_36273__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_36274 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_36275 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_36276 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_36277 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36264,new cljs.core.Keyword(null,"post","post",269697687));
var inst_36278 = fluree.db.storage.core.ledger_root_key(inst_36265,inst_36273__$1,inst_36271__$1);
var inst_36279 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_36280 = fluree.db.storage.core.child_data(inst_36272);
var inst_36281__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_36269__$1);
var state_36311__$1 = (function (){var statearr_36321 = state_36311;
(statearr_36321[(13)] = inst_36277);

(statearr_36321[(7)] = inst_36281__$1);

(statearr_36321[(14)] = inst_36275);

(statearr_36321[(8)] = inst_36278);

(statearr_36321[(10)] = inst_36271__$1);

(statearr_36321[(15)] = inst_36268);

(statearr_36321[(16)] = inst_36266);

(statearr_36321[(17)] = inst_36274);

(statearr_36321[(18)] = inst_36279);

(statearr_36321[(19)] = inst_36276);

(statearr_36321[(20)] = inst_36267);

(statearr_36321[(11)] = inst_36269__$1);

(statearr_36321[(12)] = inst_36273__$1);

(statearr_36321[(21)] = inst_36280);

(statearr_36321[(22)] = inst_36270);

return statearr_36321;
})();
if(cljs.core.truth_(inst_36281__$1)){
var statearr_36322_36344 = state_36311__$1;
(statearr_36322_36344[(1)] = (6));

} else {
var statearr_36323_36345 = state_36311__$1;
(statearr_36323_36345[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36312 === (11))){
var inst_36277 = (state_36311[(13)]);
var inst_36285 = (state_36311[(23)]);
var inst_36275 = (state_36311[(14)]);
var inst_36278 = (state_36311[(8)]);
var inst_36271 = (state_36311[(10)]);
var inst_36268 = (state_36311[(15)]);
var inst_36266 = (state_36311[(16)]);
var inst_36279 = (state_36311[(18)]);
var inst_36276 = (state_36311[(19)]);
var inst_36267 = (state_36311[(20)]);
var inst_36269 = (state_36311[(11)]);
var inst_36273 = (state_36311[(12)]);
var inst_36280 = (state_36311[(21)]);
var inst_36270 = (state_36311[(22)]);
var inst_36290 = (state_36311[(2)]);
var inst_36291 = fluree.db.storage.core.child_data(inst_36275);
var inst_36292 = fluree.db.storage.core.child_data(inst_36277);
var inst_36293 = fluree.db.util.core.current_time_millis();
var inst_36294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36295 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_36296 = (new cljs.core.PersistentVector(null,2,(5),inst_36294,inst_36295,null));
var inst_36297 = cljs.core.select_keys(inst_36269,inst_36296);
var inst_36298 = fluree.db.storage.core.child_data(inst_36268);
var inst_36299 = [inst_36271,inst_36280,inst_36273,inst_36285,inst_36290,inst_36291,inst_36292,inst_36266,inst_36293,inst_36267,inst_36276,inst_36297,inst_36298];
var inst_36300 = cljs.core.PersistentHashMap.fromArrays(inst_36279,inst_36299);
var inst_36301 = fluree.db.storage.core.serde(inst_36270);
var inst_36302 = fluree.db.serde.protocol._serialize_db_root(inst_36301,inst_36300);
var inst_36303 = fluree.db.storage.core.storage_write(inst_36270,inst_36278,inst_36302);
var state_36311__$1 = state_36311;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36311__$1,(12),inst_36303);
} else {
if((state_val_36312 === (9))){
var inst_36286 = (state_36311[(24)]);
var state_36311__$1 = state_36311;
var statearr_36325_36346 = state_36311__$1;
(statearr_36325_36346[(2)] = inst_36286);

(statearr_36325_36346[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36312 === (5))){
var _ = (function (){var statearr_36326 = state_36311;
(statearr_36326[(4)] = cljs.core.rest((state_36311[(4)])));

return statearr_36326;
})();
var state_36311__$1 = state_36311;
var ex36324 = (state_36311__$1[(2)]);
var statearr_36327_36347 = state_36311__$1;
(statearr_36327_36347[(5)] = ex36324);


if((ex36324 instanceof Error)){
var statearr_36328_36348 = state_36311__$1;
(statearr_36328_36348[(1)] = (4));

(statearr_36328_36348[(5)] = null);

} else {
throw ex36324;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36312 === (10))){
var inst_36274 = (state_36311[(17)]);
var state_36311__$1 = state_36311;
var statearr_36329_36349 = state_36311__$1;
(statearr_36329_36349[(2)] = inst_36274);

(statearr_36329_36349[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36312 === (8))){
var inst_36286 = (state_36311[(24)]);
var inst_36285 = (state_36311[(2)]);
var inst_36286__$1 = custom_ecount;
var state_36311__$1 = (function (){var statearr_36330 = state_36311;
(statearr_36330[(23)] = inst_36285);

(statearr_36330[(24)] = inst_36286__$1);

return statearr_36330;
})();
if(cljs.core.truth_(inst_36286__$1)){
var statearr_36331_36350 = state_36311__$1;
(statearr_36331_36350[(1)] = (9));

} else {
var statearr_36332_36351 = state_36311__$1;
(statearr_36332_36351[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__17178__auto__ = null;
var fluree$db$storage$core$state_machine__17178__auto____0 = (function (){
var statearr_36333 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36333[(0)] = fluree$db$storage$core$state_machine__17178__auto__);

(statearr_36333[(1)] = (1));

return statearr_36333;
});
var fluree$db$storage$core$state_machine__17178__auto____1 = (function (state_36311){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36311);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36334){var ex__17181__auto__ = e36334;
var statearr_36335_36352 = state_36311;
(statearr_36335_36352[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36311[(4)]))){
var statearr_36336_36353 = state_36311;
(statearr_36336_36353[(1)] = cljs.core.first((state_36311[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36354 = state_36311;
state_36311 = G__36354;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__17178__auto__ = function(state_36311){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__17178__auto____1.call(this,state_36311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__17178__auto____0;
fluree$db$storage$core$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__17178__auto____1;
return fluree$db$storage$core$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36337 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36337[(6)] = c__17304__auto__);

return statearr_36337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__17304__auto___36413 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36387){
var state_val_36388 = (state_36387[(1)]);
if((state_val_36388 === (7))){
var inst_36367 = (state_36387[(7)]);
var state_36387__$1 = state_36387;
var statearr_36389_36414 = state_36387__$1;
(statearr_36389_36414[(2)] = inst_36367);

(statearr_36389_36414[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36388 === (1))){
var state_36387__$1 = state_36387;
var statearr_36390_36415 = state_36387__$1;
(statearr_36390_36415[(2)] = null);

(statearr_36390_36415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36388 === (4))){
var inst_36355 = (state_36387[(2)]);
var inst_36356 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_36357 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_36355);
var inst_36358 = cljs.core.async.close_BANG_(return_ch);
var state_36387__$1 = (function (){var statearr_36391 = state_36387;
(statearr_36391[(8)] = inst_36357);

(statearr_36391[(9)] = inst_36356);

return statearr_36391;
})();
var statearr_36392_36416 = state_36387__$1;
(statearr_36392_36416[(2)] = inst_36358);

(statearr_36392_36416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36388 === (6))){
var inst_36366 = (state_36387[(10)]);
var inst_36367 = (state_36387[(7)]);
var inst_36366__$1 = (state_36387[(2)]);
var inst_36367__$1 = (inst_36366__$1 == null);
var state_36387__$1 = (function (){var statearr_36393 = state_36387;
(statearr_36393[(10)] = inst_36366__$1);

(statearr_36393[(7)] = inst_36367__$1);

return statearr_36393;
})();
if(cljs.core.truth_(inst_36367__$1)){
var statearr_36394_36417 = state_36387__$1;
(statearr_36394_36417[(1)] = (7));

} else {
var statearr_36395_36418 = state_36387__$1;
(statearr_36395_36418[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36388 === (3))){
var inst_36385 = (state_36387[(2)]);
var state_36387__$1 = state_36387;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36387__$1,inst_36385);
} else {
if((state_val_36388 === (12))){
var inst_36382 = (state_36387[(2)]);
var _ = (function (){var statearr_36396 = state_36387;
(statearr_36396[(4)] = cljs.core.rest((state_36387[(4)])));

return statearr_36396;
})();
var state_36387__$1 = state_36387;
var statearr_36397_36419 = state_36387__$1;
(statearr_36397_36419[(2)] = inst_36382);

(statearr_36397_36419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36388 === (2))){
var _ = (function (){var statearr_36398 = state_36387;
(statearr_36398[(4)] = cljs.core.cons((5),(state_36387[(4)])));

return statearr_36398;
})();
var inst_36364 = fluree.db.storage.core.storage_read(conn,key);
var state_36387__$1 = state_36387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36387__$1,(6),inst_36364);
} else {
if((state_val_36388 === (11))){
var inst_36366 = (state_36387[(10)]);
var inst_36376 = fluree.db.storage.core.serde(conn);
var inst_36377 = fluree.db.serde.protocol._deserialize_leaf(inst_36376,inst_36366);
var inst_36378 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_36377);
var inst_36379 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_36378);
var inst_36380 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_36379);
var state_36387__$1 = state_36387;
var statearr_36400_36420 = state_36387__$1;
(statearr_36400_36420[(2)] = inst_36380);

(statearr_36400_36420[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36388 === (9))){
var inst_36372 = (state_36387[(2)]);
var state_36387__$1 = state_36387;
if(cljs.core.truth_(inst_36372)){
var statearr_36401_36421 = state_36387__$1;
(statearr_36401_36421[(1)] = (10));

} else {
var statearr_36402_36422 = state_36387__$1;
(statearr_36402_36422[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36388 === (5))){
var _ = (function (){var statearr_36403 = state_36387;
(statearr_36403[(4)] = cljs.core.rest((state_36387[(4)])));

return statearr_36403;
})();
var state_36387__$1 = state_36387;
var ex36399 = (state_36387__$1[(2)]);
var statearr_36404_36423 = state_36387__$1;
(statearr_36404_36423[(5)] = ex36399);


var statearr_36405_36424 = state_36387__$1;
(statearr_36405_36424[(1)] = (4));

(statearr_36405_36424[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36388 === (10))){
var inst_36374 = cljs.core.async.close_BANG_(return_ch);
var state_36387__$1 = state_36387;
var statearr_36406_36425 = state_36387__$1;
(statearr_36406_36425[(2)] = inst_36374);

(statearr_36406_36425[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36388 === (8))){
var inst_36366 = (state_36387[(10)]);
var inst_36370 = (inst_36366 instanceof Error);
var state_36387__$1 = state_36387;
var statearr_36407_36426 = state_36387__$1;
(statearr_36407_36426[(2)] = inst_36370);

(statearr_36407_36426[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__17178__auto____0 = (function (){
var statearr_36408 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36408[(0)] = fluree$db$storage$core$reify_history_$_state_machine__17178__auto__);

(statearr_36408[(1)] = (1));

return statearr_36408;
});
var fluree$db$storage$core$reify_history_$_state_machine__17178__auto____1 = (function (state_36387){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36387);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36409){var ex__17181__auto__ = e36409;
var statearr_36410_36427 = state_36387;
(statearr_36410_36427[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36387[(4)]))){
var statearr_36411_36428 = state_36387;
(statearr_36411_36428[(1)] = cljs.core.first((state_36387[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36429 = state_36387;
state_36387 = G__36429;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__17178__auto__ = function(state_36387){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__17178__auto____1.call(this,state_36387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__17178__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__17178__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36412 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36412[(6)] = c__17304__auto___36413);

return statearr_36412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__36431 = arguments.length;
switch (G__36431) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4210__auto__ = (rhs == null);
if(and__4210__auto__){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__17304__auto___36543 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36494){
var state_val_36495 = (state_36494[(1)]);
if((state_val_36495 === (7))){
var state_36494__$1 = state_36494;
var statearr_36496_36544 = state_36494__$1;
(statearr_36496_36544[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_36496_36544[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (20))){
var inst_36473 = cljs.core.PersistentVector.EMPTY;
var state_36494__$1 = state_36494;
var statearr_36497_36545 = state_36494__$1;
(statearr_36497_36545[(2)] = inst_36473);

(statearr_36497_36545[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (1))){
var state_36494__$1 = state_36494;
var statearr_36498_36546 = state_36494__$1;
(statearr_36498_36546[(2)] = null);

(statearr_36498_36546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (24))){
var state_36494__$1 = state_36494;
var statearr_36499_36547 = state_36494__$1;
(statearr_36499_36547[(2)] = null);

(statearr_36499_36547[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (4))){
var inst_36434 = (state_36494[(2)]);
var inst_36435 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_36436 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_36434);
var inst_36437 = cljs.core.async.close_BANG_(result_ch);
var state_36494__$1 = (function (){var statearr_36500 = state_36494;
(statearr_36500[(7)] = inst_36436);

(statearr_36500[(8)] = inst_36435);

return statearr_36500;
})();
var statearr_36501_36548 = state_36494__$1;
(statearr_36501_36548[(2)] = inst_36437);

(statearr_36501_36548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (15))){
var inst_36459 = (state_36494[(2)]);
var state_36494__$1 = state_36494;
var statearr_36502_36549 = state_36494__$1;
(statearr_36502_36549[(2)] = inst_36459);

(statearr_36502_36549[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (21))){
var inst_36447 = (state_36494[(9)]);
var inst_36476 = (state_36494[(10)]);
var inst_36446 = (state_36494[(11)]);
var inst_36448 = (state_36494[(12)]);
var inst_36463 = (state_36494[(13)]);
var inst_36483 = (state_36494[(2)]);
var inst_36484 = (function (){var base_node = inst_36446;
var first_flake = inst_36447;
var node_t = inst_36448;
var source = inst_36463;
var coll = inst_36476;
var conj_QMARK_ = inst_36483;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__36504 = f.p;
var fexpr__36503 = (function (){var or__4212__auto__ = remove_preds;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__36503.cljs$core$IFn$_invoke$arity$1 ? fexpr__36503.cljs$core$IFn$_invoke$arity$1(G__36504) : fexpr__36503.call(null,G__36504));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_36485 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_36446);
var inst_36486 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36484,inst_36485,inst_36476);
var inst_36487 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_36486);
var inst_36488 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36446,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_36487);
var inst_36489 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_36488);
var _ = (function (){var statearr_36505 = state_36494;
(statearr_36505[(4)] = cljs.core.rest((state_36494[(4)])));

return statearr_36505;
})();
var state_36494__$1 = state_36494;
var statearr_36506_36550 = state_36494__$1;
(statearr_36506_36550[(2)] = inst_36489);

(statearr_36506_36550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (13))){
var state_36494__$1 = state_36494;
var statearr_36507_36551 = state_36494__$1;
(statearr_36507_36551[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_36507_36551[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (22))){
var inst_36447 = (state_36494[(9)]);
var inst_36476 = (state_36494[(10)]);
var inst_36446 = (state_36494[(11)]);
var inst_36448 = (state_36494[(12)]);
var inst_36463 = (state_36494[(13)]);
var inst_36477 = (function (){var base_node = inst_36446;
var first_flake = inst_36447;
var node_t = inst_36448;
var source = inst_36463;
var coll = inst_36476;
return (function (f){
return f.op === true;
});
})();
var state_36494__$1 = state_36494;
var statearr_36508_36552 = state_36494__$1;
(statearr_36508_36552[(2)] = inst_36477);

(statearr_36508_36552[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (6))){
var inst_36446 = (state_36494[(11)]);
var inst_36448 = (state_36494[(12)]);
var inst_36445 = (state_36494[(2)]);
var inst_36446__$1 = fluree.db.util.async.throw_err(inst_36445);
var inst_36447 = fluree.db.dbproto._first_flake(inst_36446__$1);
var inst_36448__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_36446__$1);
var inst_36449 = (inst_36448__$1 > t);
var state_36494__$1 = (function (){var statearr_36509 = state_36494;
(statearr_36509[(9)] = inst_36447);

(statearr_36509[(11)] = inst_36446__$1);

(statearr_36509[(12)] = inst_36448__$1);

return statearr_36509;
})();
if(cljs.core.truth_(inst_36449)){
var statearr_36510_36553 = state_36494__$1;
(statearr_36510_36553[(1)] = (7));

} else {
var statearr_36511_36554 = state_36494__$1;
(statearr_36511_36554[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (17))){
var inst_36447 = (state_36494[(9)]);
var inst_36464 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_36447,rhs,leftmost_QMARK_,t);
var state_36494__$1 = state_36494;
var statearr_36512_36555 = state_36494__$1;
(statearr_36512_36555[(2)] = inst_36464);

(statearr_36512_36555[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (3))){
var inst_36492 = (state_36494[(2)]);
var state_36494__$1 = state_36494;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36494__$1,inst_36492);
} else {
if((state_val_36495 === (12))){
var inst_36461 = (state_36494[(2)]);
var state_36494__$1 = state_36494;
var statearr_36513_36556 = state_36494__$1;
(statearr_36513_36556[(2)] = inst_36461);

(statearr_36513_36556[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (2))){
var _ = (function (){var statearr_36514 = state_36494;
(statearr_36514[(4)] = cljs.core.cons((5),(state_36494[(4)])));

return statearr_36514;
})();
var inst_36443 = fluree.db.dbproto._resolve(node);
var state_36494__$1 = state_36494;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36494__$1,(6),inst_36443);
} else {
if((state_val_36495 === (23))){
var inst_36447 = (state_36494[(9)]);
var inst_36476 = (state_36494[(10)]);
var inst_36446 = (state_36494[(11)]);
var inst_36448 = (state_36494[(12)]);
var inst_36463 = (state_36494[(13)]);
var inst_36479 = (function (){var base_node = inst_36446;
var first_flake = inst_36447;
var node_t = inst_36448;
var source = inst_36463;
var coll = inst_36476;
return (function (f){
return f.op === false;
});
})();
var state_36494__$1 = state_36494;
var statearr_36515_36557 = state_36494__$1;
(statearr_36515_36557[(2)] = inst_36479);

(statearr_36515_36557[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (19))){
var inst_36466 = (state_36494[(14)]);
var inst_36469 = (state_36494[(2)]);
var inst_36470 = fluree.db.util.async.throw_err(inst_36469);
var inst_36471 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_36466,inst_36470);
var state_36494__$1 = state_36494;
var statearr_36516_36558 = state_36494__$1;
(statearr_36516_36558[(2)] = inst_36471);

(statearr_36516_36558[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (11))){
var inst_36448 = (state_36494[(12)]);
var inst_36455 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36448,t);
var state_36494__$1 = state_36494;
if(inst_36455){
var statearr_36518_36559 = state_36494__$1;
(statearr_36518_36559[(1)] = (13));

} else {
var statearr_36519_36560 = state_36494__$1;
(statearr_36519_36560[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (9))){
var inst_36463 = (state_36494[(13)]);
var inst_36463__$1 = (state_36494[(2)]);
var state_36494__$1 = (function (){var statearr_36520 = state_36494;
(statearr_36520[(13)] = inst_36463__$1);

return statearr_36520;
})();
var G__36521_36561 = inst_36463__$1;
var G__36521_36562__$1 = (((G__36521_36561 instanceof cljs.core.Keyword))?G__36521_36561.fqn:null);
switch (G__36521_36562__$1) {
case "novelty":
var statearr_36522_36564 = state_36494__$1;
(statearr_36522_36564[(1)] = (17));


break;
case "history":
var statearr_36523_36565 = state_36494__$1;
(statearr_36523_36565[(1)] = (18));


break;
case "none":
var statearr_36524_36566 = state_36494__$1;
(statearr_36524_36566[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36521_36562__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (5))){
var _ = (function (){var statearr_36525 = state_36494;
(statearr_36525[(4)] = cljs.core.rest((state_36494[(4)])));

return statearr_36525;
})();
var state_36494__$1 = state_36494;
var ex36517 = (state_36494__$1[(2)]);
var statearr_36526_36567 = state_36494__$1;
(statearr_36526_36567[(5)] = ex36517);


var statearr_36527_36568 = state_36494__$1;
(statearr_36527_36568[(1)] = (4));

(statearr_36527_36568[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (14))){
var state_36494__$1 = state_36494;
var statearr_36528_36569 = state_36494__$1;
(statearr_36528_36569[(2)] = null);

(statearr_36528_36569[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (16))){
var inst_36463 = (state_36494[(13)]);
var inst_36476 = (state_36494[(2)]);
var state_36494__$1 = (function (){var statearr_36529 = state_36494;
(statearr_36529[(10)] = inst_36476);

return statearr_36529;
})();
var G__36530_36570 = inst_36463;
var G__36530_36571__$1 = (((G__36530_36570 instanceof cljs.core.Keyword))?G__36530_36570.fqn:null);
switch (G__36530_36571__$1) {
case "novelty":
var statearr_36531_36573 = state_36494__$1;
(statearr_36531_36573[(1)] = (22));


break;
case "history":
var statearr_36532_36574 = state_36494__$1;
(statearr_36532_36574[(1)] = (23));


break;
case "none":
var statearr_36533_36575 = state_36494__$1;
(statearr_36533_36575[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36530_36571__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (10))){
var state_36494__$1 = state_36494;
var statearr_36534_36576 = state_36494__$1;
(statearr_36534_36576[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_36534_36576[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36495 === (18))){
var inst_36447 = (state_36494[(9)]);
var inst_36446 = (state_36494[(11)]);
var inst_36448 = (state_36494[(12)]);
var inst_36463 = (state_36494[(13)]);
var inst_36466 = (function (){var base_node = inst_36446;
var first_flake = inst_36447;
var node_t = inst_36448;
var source = inst_36463;
return (function (p1__36433_SHARP_){
return (p1__36433_SHARP_.t <= t);
});
})();
var inst_36467 = fluree.db.dbproto._resolve_history(node);
var state_36494__$1 = (function (){var statearr_36535 = state_36494;
(statearr_36535[(14)] = inst_36466);

return statearr_36535;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36494__$1,(19),inst_36467);
} else {
if((state_val_36495 === (8))){
var inst_36448 = (state_36494[(12)]);
var inst_36452 = (inst_36448 < t);
var state_36494__$1 = state_36494;
if(cljs.core.truth_(inst_36452)){
var statearr_36536_36577 = state_36494__$1;
(statearr_36536_36577[(1)] = (10));

} else {
var statearr_36537_36578 = state_36494__$1;
(statearr_36537_36578[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__17178__auto____0 = (function (){
var statearr_36538 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36538[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__17178__auto__);

(statearr_36538[(1)] = (1));

return statearr_36538;
});
var fluree$db$storage$core$resolve_t_$_state_machine__17178__auto____1 = (function (state_36494){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36494);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36539){var ex__17181__auto__ = e36539;
var statearr_36540_36579 = state_36494;
(statearr_36540_36579[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36494[(4)]))){
var statearr_36541_36580 = state_36494;
(statearr_36541_36580[(1)] = cljs.core.first((state_36494[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36581 = state_36494;
state_36494 = G__36581;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__17178__auto__ = function(state_36494){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__17178__auto____1.call(this,state_36494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__17178__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__17178__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36542 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36542[(6)] = c__17304__auto___36543);

return statearr_36542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36641){
var state_val_36642 = (state_36641[(1)]);
if((state_val_36642 === (7))){
var inst_36592 = (state_36641[(7)]);
var inst_36596 = (inst_36592 <= from_t);
var state_36641__$1 = state_36641;
var statearr_36643_36683 = state_36641__$1;
(statearr_36643_36683[(2)] = inst_36596);

(statearr_36643_36683[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (20))){
var inst_36626 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_36627 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36626)].join('');
var inst_36628 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_36629 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_36630 = cljs.core.PersistentHashMap.fromArrays(inst_36628,inst_36629);
var inst_36631 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36627,inst_36630);
var inst_36632 = (function(){throw inst_36631})();
var state_36641__$1 = state_36641;
var statearr_36644_36684 = state_36641__$1;
(statearr_36644_36684[(2)] = inst_36632);

(statearr_36644_36684[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (1))){
var state_36641__$1 = state_36641;
var statearr_36645_36685 = state_36641__$1;
(statearr_36645_36685[(2)] = null);

(statearr_36645_36685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (4))){
var inst_36584 = (state_36641[(2)]);
var inst_36585 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_36584], 0));
var inst_36586 = (function(){throw inst_36584})();
var state_36641__$1 = (function (){var statearr_36646 = state_36641;
(statearr_36646[(8)] = inst_36585);

return statearr_36646;
})();
var statearr_36647_36686 = state_36641__$1;
(statearr_36647_36686[(2)] = inst_36586);

(statearr_36647_36686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (15))){
var inst_36611 = (state_36641[(2)]);
var state_36641__$1 = (function (){var statearr_36648 = state_36641;
(statearr_36648[(9)] = inst_36611);

return statearr_36648;
})();
if(cljs.core.truth_(from_t)){
var statearr_36649_36687 = state_36641__$1;
(statearr_36649_36687[(1)] = (16));

} else {
var statearr_36650_36688 = state_36641__$1;
(statearr_36650_36688[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (21))){
var inst_36622 = (state_36641[(10)]);
var inst_36621 = (state_36641[(11)]);
var inst_36620 = (state_36641[(12)]);
var inst_36634 = (state_36641[(2)]);
var inst_36635 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_36621,inst_36622,leftmost_QMARK_,to_t);
var inst_36636 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36635,inst_36620);
var _ = (function (){var statearr_36651 = state_36641;
(statearr_36651[(4)] = cljs.core.rest((state_36641[(4)])));

return statearr_36651;
})();
var state_36641__$1 = (function (){var statearr_36652 = state_36641;
(statearr_36652[(13)] = inst_36634);

return statearr_36652;
})();
var statearr_36653_36689 = state_36641__$1;
(statearr_36653_36689[(2)] = inst_36636);

(statearr_36653_36689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (13))){
var inst_36592 = (state_36641[(7)]);
var inst_36604 = (state_36641[(14)]);
var inst_36607 = (function (){var node_t = inst_36592;
var G__36600 = inst_36604;
return (function (p1__36582_SHARP_){
return (p1__36582_SHARP_.t < to_t);
});
})();
var inst_36608 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_36607,inst_36604);
var state_36641__$1 = state_36641;
var statearr_36654_36690 = state_36641__$1;
(statearr_36654_36690[(2)] = inst_36608);

(statearr_36654_36690[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (6))){
var inst_36593 = (state_36641[(15)]);
var state_36641__$1 = state_36641;
var statearr_36655_36691 = state_36641__$1;
(statearr_36655_36691[(2)] = inst_36593);

(statearr_36655_36691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (17))){
var inst_36611 = (state_36641[(9)]);
var state_36641__$1 = state_36641;
var statearr_36656_36692 = state_36641__$1;
(statearr_36656_36692[(2)] = inst_36611);

(statearr_36656_36692[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (3))){
var inst_36639 = (state_36641[(2)]);
var state_36641__$1 = state_36641;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36641__$1,inst_36639);
} else {
if((state_val_36642 === (12))){
var inst_36592 = (state_36641[(7)]);
var inst_36603 = (state_36641[(2)]);
var inst_36604 = fluree.db.util.async.throw_err(inst_36603);
var inst_36605 = (to_t > inst_36592);
var state_36641__$1 = (function (){var statearr_36657 = state_36641;
(statearr_36657[(14)] = inst_36604);

return statearr_36657;
})();
if(cljs.core.truth_(inst_36605)){
var statearr_36658_36693 = state_36641__$1;
(statearr_36658_36693[(1)] = (13));

} else {
var statearr_36659_36694 = state_36641__$1;
(statearr_36659_36694[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (2))){
var inst_36593 = (state_36641[(15)]);
var _ = (function (){var statearr_36660 = state_36641;
(statearr_36660[(4)] = cljs.core.cons((5),(state_36641[(4)])));

return statearr_36660;
})();
var inst_36592 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_36593__$1 = (from_t == null);
var state_36641__$1 = (function (){var statearr_36661 = state_36641;
(statearr_36661[(15)] = inst_36593__$1);

(statearr_36661[(7)] = inst_36592);

return statearr_36661;
})();
if(cljs.core.truth_(inst_36593__$1)){
var statearr_36662_36695 = state_36641__$1;
(statearr_36662_36695[(1)] = (6));

} else {
var statearr_36663_36696 = state_36641__$1;
(statearr_36663_36696[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (19))){
var state_36641__$1 = state_36641;
var statearr_36664_36697 = state_36641__$1;
(statearr_36664_36697[(2)] = null);

(statearr_36664_36697[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (11))){
var inst_36620 = (state_36641[(2)]);
var inst_36621 = fluree.db.dbproto._first_flake(node);
var inst_36622 = fluree.db.dbproto._rhs(node);
var inst_36623 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_36641__$1 = (function (){var statearr_36666 = state_36641;
(statearr_36666[(10)] = inst_36622);

(statearr_36666[(11)] = inst_36621);

(statearr_36666[(12)] = inst_36620);

return statearr_36666;
})();
if(cljs.core.truth_(inst_36623)){
var statearr_36667_36698 = state_36641__$1;
(statearr_36667_36698[(1)] = (19));

} else {
var statearr_36668_36699 = state_36641__$1;
(statearr_36668_36699[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (9))){
var inst_36601 = fluree.db.dbproto._resolve_history(node);
var state_36641__$1 = state_36641;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36641__$1,(12),inst_36601);
} else {
if((state_val_36642 === (5))){
var _ = (function (){var statearr_36669 = state_36641;
(statearr_36669[(4)] = cljs.core.rest((state_36641[(4)])));

return statearr_36669;
})();
var state_36641__$1 = state_36641;
var ex36665 = (state_36641__$1[(2)]);
var statearr_36670_36700 = state_36641__$1;
(statearr_36670_36700[(5)] = ex36665);


var statearr_36671_36701 = state_36641__$1;
(statearr_36671_36701[(1)] = (4));

(statearr_36671_36701[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (14))){
var inst_36604 = (state_36641[(14)]);
var state_36641__$1 = state_36641;
var statearr_36672_36702 = state_36641__$1;
(statearr_36672_36702[(2)] = inst_36604);

(statearr_36672_36702[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (16))){
var inst_36611 = (state_36641[(9)]);
var inst_36592 = (state_36641[(7)]);
var inst_36613 = (function (){var node_t = inst_36592;
var G__36600 = inst_36611;
return (function (p1__36583_SHARP_){
return (p1__36583_SHARP_.t <= from_t);
});
})();
var inst_36614 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_36613,inst_36611);
var state_36641__$1 = state_36641;
var statearr_36673_36703 = state_36641__$1;
(statearr_36673_36703[(2)] = inst_36614);

(statearr_36673_36703[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (10))){
var state_36641__$1 = state_36641;
var statearr_36674_36704 = state_36641__$1;
(statearr_36674_36704[(2)] = null);

(statearr_36674_36704[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (18))){
var inst_36617 = (state_36641[(2)]);
var state_36641__$1 = state_36641;
var statearr_36675_36705 = state_36641__$1;
(statearr_36675_36705[(2)] = inst_36617);

(statearr_36675_36705[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36642 === (8))){
var inst_36598 = (state_36641[(2)]);
var state_36641__$1 = state_36641;
if(cljs.core.truth_(inst_36598)){
var statearr_36676_36706 = state_36641__$1;
(statearr_36676_36706[(1)] = (9));

} else {
var statearr_36677_36707 = state_36641__$1;
(statearr_36677_36707[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__17178__auto____0 = (function (){
var statearr_36678 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36678[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__17178__auto__);

(statearr_36678[(1)] = (1));

return statearr_36678;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__17178__auto____1 = (function (state_36641){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36641);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36679){var ex__17181__auto__ = e36679;
var statearr_36680_36708 = state_36641;
(statearr_36680_36708[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36641[(4)]))){
var statearr_36681_36709 = state_36641;
(statearr_36681_36709[(1)] = cljs.core.first((state_36641[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36710 = state_36641;
state_36641 = G__36710;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__17178__auto__ = function(state_36641){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__17178__auto____1.call(this,state_36641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__17178__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__17178__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36682 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36682[(6)] = c__17304__auto__);

return statearr_36682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4212__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__36711_36721 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__36712_36722 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__36711_36721,G__36712_36722) : object_cache.call(null,G__36711_36721,G__36712_36722));

var G__36713 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__36714 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__36715 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__36716 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__36715,G__36716) : object_cache.call(null,G__36715,G__36716));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__36713,G__36714) : object_cache.call(null,G__36713,G__36714));
} else {
var G__36717 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__36718 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__36719 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__36720 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__36719,G__36720) : object_cache.call(null,G__36719,G__36720));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__36717,G__36718) : object_cache.call(null,G__36717,G__36718));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36743){
var state_val_36744 = (state_36743[(1)]);
if((state_val_36744 === (7))){
var inst_36732 = (state_36743[(7)]);
var inst_36734 = fluree.db.storage.core.serde(conn);
var inst_36735 = fluree.db.serde.protocol._deserialize_branch(inst_36734,inst_36732);
var state_36743__$1 = state_36743;
var statearr_36745_36764 = state_36743__$1;
(statearr_36745_36764[(2)] = inst_36735);

(statearr_36745_36764[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36744 === (1))){
var state_36743__$1 = state_36743;
var statearr_36746_36765 = state_36743__$1;
(statearr_36746_36765[(2)] = null);

(statearr_36746_36765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36744 === (4))){
var inst_36723 = (state_36743[(2)]);
var state_36743__$1 = state_36743;
var statearr_36747_36766 = state_36743__$1;
(statearr_36747_36766[(2)] = inst_36723);

(statearr_36747_36766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36744 === (6))){
var inst_36732 = (state_36743[(7)]);
var inst_36731 = (state_36743[(2)]);
var inst_36732__$1 = fluree.db.util.async.throw_err(inst_36731);
var state_36743__$1 = (function (){var statearr_36748 = state_36743;
(statearr_36748[(7)] = inst_36732__$1);

return statearr_36748;
})();
if(cljs.core.truth_(inst_36732__$1)){
var statearr_36749_36767 = state_36743__$1;
(statearr_36749_36767[(1)] = (7));

} else {
var statearr_36750_36768 = state_36743__$1;
(statearr_36750_36768[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36744 === (3))){
var inst_36741 = (state_36743[(2)]);
var state_36743__$1 = state_36743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36743__$1,inst_36741);
} else {
if((state_val_36744 === (2))){
var _ = (function (){var statearr_36752 = state_36743;
(statearr_36752[(4)] = cljs.core.cons((5),(state_36743[(4)])));

return statearr_36752;
})();
var inst_36729 = fluree.db.storage.core.storage_read(conn,key);
var state_36743__$1 = state_36743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36743__$1,(6),inst_36729);
} else {
if((state_val_36744 === (9))){
var inst_36738 = (state_36743[(2)]);
var _ = (function (){var statearr_36753 = state_36743;
(statearr_36753[(4)] = cljs.core.rest((state_36743[(4)])));

return statearr_36753;
})();
var state_36743__$1 = state_36743;
var statearr_36754_36769 = state_36743__$1;
(statearr_36754_36769[(2)] = inst_36738);

(statearr_36754_36769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36744 === (5))){
var _ = (function (){var statearr_36755 = state_36743;
(statearr_36755[(4)] = cljs.core.rest((state_36743[(4)])));

return statearr_36755;
})();
var state_36743__$1 = state_36743;
var ex36751 = (state_36743__$1[(2)]);
var statearr_36756_36770 = state_36743__$1;
(statearr_36756_36770[(5)] = ex36751);


if((ex36751 instanceof Error)){
var statearr_36757_36771 = state_36743__$1;
(statearr_36757_36771[(1)] = (4));

(statearr_36757_36771[(5)] = null);

} else {
throw ex36751;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36744 === (8))){
var state_36743__$1 = state_36743;
var statearr_36758_36772 = state_36743__$1;
(statearr_36758_36772[(2)] = null);

(statearr_36758_36772[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__17178__auto____0 = (function (){
var statearr_36759 = [null,null,null,null,null,null,null,null];
(statearr_36759[(0)] = fluree$db$storage$core$read_branch_$_state_machine__17178__auto__);

(statearr_36759[(1)] = (1));

return statearr_36759;
});
var fluree$db$storage$core$read_branch_$_state_machine__17178__auto____1 = (function (state_36743){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36743);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36760){var ex__17181__auto__ = e36760;
var statearr_36761_36773 = state_36743;
(statearr_36761_36773[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36743[(4)]))){
var statearr_36762_36774 = state_36743;
(statearr_36762_36774[(1)] = cljs.core.first((state_36743[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36775 = state_36743;
state_36743 = G__36775;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__17178__auto__ = function(state_36743){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__17178__auto____1.call(this,state_36743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__17178__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__17178__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36763 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36763[(6)] = c__17304__auto__);

return statearr_36763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__17304__auto___36854 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36826){
var state_val_36827 = (state_36826[(1)]);
if((state_val_36827 === (7))){
var inst_36793 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_36794 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_36795 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_36796 = cljs.core.PersistentHashMap.fromArrays(inst_36794,inst_36795);
var inst_36797 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36793,inst_36796);
var inst_36798 = (function(){throw inst_36797})();
var state_36826__$1 = state_36826;
var statearr_36828_36855 = state_36826__$1;
(statearr_36828_36855[(2)] = inst_36798);

(statearr_36828_36855[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36827 === (1))){
var state_36826__$1 = state_36826;
var statearr_36829_36856 = state_36826__$1;
(statearr_36829_36856[(2)] = null);

(statearr_36829_36856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36827 === (4))){
var inst_36776 = (state_36826[(2)]);
var inst_36777 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_36778 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_36776);
var inst_36779 = cljs.core.async.close_BANG_(return_ch);
var state_36826__$1 = (function (){var statearr_36830 = state_36826;
(statearr_36830[(7)] = inst_36777);

(statearr_36830[(8)] = inst_36778);

return statearr_36830;
})();
var statearr_36831_36857 = state_36826__$1;
(statearr_36831_36857[(2)] = inst_36779);

(statearr_36831_36857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36827 === (6))){
var inst_36790 = (state_36826[(9)]);
var inst_36789 = (state_36826[(2)]);
var inst_36790__$1 = fluree.db.util.async.throw_err(inst_36789);
var inst_36791 = (inst_36790__$1 == null);
var state_36826__$1 = (function (){var statearr_36832 = state_36826;
(statearr_36832[(9)] = inst_36790__$1);

return statearr_36832;
})();
if(cljs.core.truth_(inst_36791)){
var statearr_36833_36858 = state_36826__$1;
(statearr_36833_36858[(1)] = (7));

} else {
var statearr_36834_36859 = state_36826__$1;
(statearr_36834_36859[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36827 === (3))){
var inst_36824 = (state_36826[(2)]);
var state_36826__$1 = state_36826;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36826__$1,inst_36824);
} else {
if((state_val_36827 === (12))){
var inst_36790 = (state_36826[(9)]);
var inst_36807 = (state_36826[(2)]);
var inst_36808 = cljs.core.__destructure_map(inst_36790);
var inst_36809 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36808,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_36810 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36808,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_36811 = config;
var inst_36812 = cljs.core.__destructure_map(inst_36811);
var inst_36813 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36812,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_36815 = (function (){var data = inst_36790;
var _ = inst_36807;
var map__36785 = inst_36808;
var children = inst_36809;
var rhs = inst_36810;
var map__36786 = inst_36812;
var comparator = inst_36813;
return (function (idx,p__36814){
var map__36835 = p__36814;
var map__36835__$1 = cljs.core.__destructure_map(map__36835);
var child = map__36835__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36835__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36835__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36835__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36835__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36835__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4210__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return (idx === (0));
} else {
return and__4210__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_36816 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_36815,inst_36809);
var inst_36817 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_36816);
var inst_36818 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_36817,inst_36816);
var inst_36819 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_36813,inst_36818);
var inst_36820 = fluree.db.index.__GT_IndexNode(block,t,inst_36810,inst_36819,config,leftmost_QMARK_);
var inst_36821 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_36820);
var _ = (function (){var statearr_36836 = state_36826;
(statearr_36836[(4)] = cljs.core.rest((state_36826[(4)])));

return statearr_36836;
})();
var state_36826__$1 = state_36826;
var statearr_36837_36860 = state_36826__$1;
(statearr_36837_36860[(2)] = inst_36821);

(statearr_36837_36860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36827 === (2))){
var _ = (function (){var statearr_36838 = state_36826;
(statearr_36838[(4)] = cljs.core.cons((5),(state_36826[(4)])));

return statearr_36838;
})();
var inst_36787 = fluree.db.storage.core.read_branch(conn,key);
var state_36826__$1 = state_36826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36826__$1,(6),inst_36787);
} else {
if((state_val_36827 === (11))){
var state_36826__$1 = state_36826;
var statearr_36840_36861 = state_36826__$1;
(statearr_36840_36861[(2)] = null);

(statearr_36840_36861[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36827 === (9))){
var inst_36790 = (state_36826[(9)]);
var inst_36801 = (state_36826[(2)]);
var inst_36802 = fluree.db.util.core.exception_QMARK_(inst_36790);
var state_36826__$1 = (function (){var statearr_36841 = state_36826;
(statearr_36841[(10)] = inst_36801);

return statearr_36841;
})();
if(inst_36802){
var statearr_36842_36862 = state_36826__$1;
(statearr_36842_36862[(1)] = (10));

} else {
var statearr_36843_36863 = state_36826__$1;
(statearr_36843_36863[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36827 === (5))){
var _ = (function (){var statearr_36844 = state_36826;
(statearr_36844[(4)] = cljs.core.rest((state_36826[(4)])));

return statearr_36844;
})();
var state_36826__$1 = state_36826;
var ex36839 = (state_36826__$1[(2)]);
var statearr_36845_36864 = state_36826__$1;
(statearr_36845_36864[(5)] = ex36839);


var statearr_36846_36865 = state_36826__$1;
(statearr_36846_36865[(1)] = (4));

(statearr_36846_36865[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36827 === (10))){
var inst_36790 = (state_36826[(9)]);
var inst_36804 = (function(){throw inst_36790})();
var state_36826__$1 = state_36826;
var statearr_36847_36866 = state_36826__$1;
(statearr_36847_36866[(2)] = inst_36804);

(statearr_36847_36866[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36827 === (8))){
var state_36826__$1 = state_36826;
var statearr_36848_36867 = state_36826__$1;
(statearr_36848_36867[(2)] = null);

(statearr_36848_36867[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__17178__auto____0 = (function (){
var statearr_36849 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36849[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__17178__auto__);

(statearr_36849[(1)] = (1));

return statearr_36849;
});
var fluree$db$storage$core$reify_branch_$_state_machine__17178__auto____1 = (function (state_36826){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36826);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36850){var ex__17181__auto__ = e36850;
var statearr_36851_36868 = state_36826;
(statearr_36851_36868[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36826[(4)]))){
var statearr_36852_36869 = state_36826;
(statearr_36852_36869[(1)] = cljs.core.first((state_36826[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36870 = state_36826;
state_36826 = G__36870;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__17178__auto__ = function(state_36826){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__17178__auto____1.call(this,state_36826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__17178__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__17178__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36853 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36853[(6)] = c__17304__auto___36854);

return statearr_36853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36891){
var state_val_36892 = (state_36891[(1)]);
if((state_val_36892 === (7))){
var state_36891__$1 = state_36891;
var statearr_36893_36913 = state_36891__$1;
(statearr_36893_36913[(2)] = null);

(statearr_36893_36913[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (1))){
var state_36891__$1 = state_36891;
var statearr_36894_36914 = state_36891__$1;
(statearr_36894_36914[(2)] = null);

(statearr_36894_36914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (4))){
var inst_36871 = (state_36891[(2)]);
var state_36891__$1 = state_36891;
var statearr_36895_36915 = state_36891__$1;
(statearr_36895_36915[(2)] = inst_36871);

(statearr_36895_36915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (6))){
var inst_36877 = (state_36891[(7)]);
var inst_36879 = fluree.db.storage.core.serde(conn);
var state_36891__$1 = (function (){var statearr_36896 = state_36891;
(statearr_36896[(8)] = inst_36879);

return statearr_36896;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36891__$1,(9),inst_36877);
} else {
if((state_val_36892 === (3))){
var inst_36889 = (state_36891[(2)]);
var state_36891__$1 = state_36891;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36891__$1,inst_36889);
} else {
if((state_val_36892 === (2))){
var inst_36877 = (state_36891[(7)]);
var _ = (function (){var statearr_36898 = state_36891;
(statearr_36898[(4)] = cljs.core.cons((5),(state_36891[(4)])));

return statearr_36898;
})();
var inst_36877__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_36891__$1 = (function (){var statearr_36899 = state_36891;
(statearr_36899[(7)] = inst_36877__$1);

return statearr_36899;
})();
if(cljs.core.truth_(inst_36877__$1)){
var statearr_36900_36916 = state_36891__$1;
(statearr_36900_36916[(1)] = (6));

} else {
var statearr_36901_36917 = state_36891__$1;
(statearr_36901_36917[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (9))){
var inst_36879 = (state_36891[(8)]);
var inst_36881 = (state_36891[(2)]);
var inst_36882 = fluree.db.util.async.throw_err(inst_36881);
var inst_36883 = fluree.db.serde.protocol._deserialize_leaf(inst_36879,inst_36882);
var state_36891__$1 = state_36891;
var statearr_36902_36918 = state_36891__$1;
(statearr_36902_36918[(2)] = inst_36883);

(statearr_36902_36918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (5))){
var _ = (function (){var statearr_36903 = state_36891;
(statearr_36903[(4)] = cljs.core.rest((state_36891[(4)])));

return statearr_36903;
})();
var state_36891__$1 = state_36891;
var ex36897 = (state_36891__$1[(2)]);
var statearr_36904_36919 = state_36891__$1;
(statearr_36904_36919[(5)] = ex36897);


if((ex36897 instanceof Error)){
var statearr_36905_36920 = state_36891__$1;
(statearr_36905_36920[(1)] = (4));

(statearr_36905_36920[(5)] = null);

} else {
throw ex36897;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (8))){
var inst_36886 = (state_36891[(2)]);
var _ = (function (){var statearr_36906 = state_36891;
(statearr_36906[(4)] = cljs.core.rest((state_36891[(4)])));

return statearr_36906;
})();
var state_36891__$1 = state_36891;
var statearr_36907_36921 = state_36891__$1;
(statearr_36907_36921[(2)] = inst_36886);

(statearr_36907_36921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__17178__auto____0 = (function (){
var statearr_36908 = [null,null,null,null,null,null,null,null,null];
(statearr_36908[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__17178__auto__);

(statearr_36908[(1)] = (1));

return statearr_36908;
});
var fluree$db$storage$core$read_leaf_$_state_machine__17178__auto____1 = (function (state_36891){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36891);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36909){var ex__17181__auto__ = e36909;
var statearr_36910_36922 = state_36891;
(statearr_36910_36922[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36891[(4)]))){
var statearr_36911_36923 = state_36891;
(statearr_36911_36923[(1)] = cljs.core.first((state_36891[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36924 = state_36891;
state_36891 = G__36924;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__17178__auto__ = function(state_36891){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__17178__auto____1.call(this,state_36891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__17178__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__17178__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36912 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36912[(6)] = c__17304__auto__);

return statearr_36912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__17304__auto___36997 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_36969){
var state_val_36970 = (state_36969[(1)]);
if((state_val_36970 === (7))){
var inst_36941 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_36942 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_36943 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_36944 = cljs.core.PersistentHashMap.fromArrays(inst_36942,inst_36943);
var inst_36945 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36941,inst_36944);
var inst_36946 = (function(){throw inst_36945})();
var state_36969__$1 = state_36969;
var statearr_36971_36998 = state_36969__$1;
(statearr_36971_36998[(2)] = inst_36946);

(statearr_36971_36998[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36970 === (1))){
var state_36969__$1 = state_36969;
var statearr_36972_36999 = state_36969__$1;
(statearr_36972_36999[(2)] = null);

(statearr_36972_36999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36970 === (4))){
var inst_36925 = (state_36969[(2)]);
var inst_36926 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_36927 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_36925);
var inst_36928 = cljs.core.async.close_BANG_(return_ch);
var state_36969__$1 = (function (){var statearr_36973 = state_36969;
(statearr_36973[(7)] = inst_36927);

(statearr_36973[(8)] = inst_36926);

return statearr_36973;
})();
var statearr_36974_37000 = state_36969__$1;
(statearr_36974_37000[(2)] = inst_36928);

(statearr_36974_37000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36970 === (6))){
var inst_36938 = (state_36969[(9)]);
var inst_36938__$1 = (state_36969[(2)]);
var inst_36939 = (inst_36938__$1 == null);
var state_36969__$1 = (function (){var statearr_36975 = state_36969;
(statearr_36975[(9)] = inst_36938__$1);

return statearr_36975;
})();
if(cljs.core.truth_(inst_36939)){
var statearr_36976_37001 = state_36969__$1;
(statearr_36976_37001[(1)] = (7));

} else {
var statearr_36977_37002 = state_36969__$1;
(statearr_36977_37002[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36970 === (3))){
var inst_36967 = (state_36969[(2)]);
var state_36969__$1 = state_36969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36969__$1,inst_36967);
} else {
if((state_val_36970 === (12))){
var inst_36938 = (state_36969[(9)]);
var inst_36955 = (state_36969[(2)]);
var inst_36956 = cljs.core.__destructure_map(inst_36938);
var inst_36957 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36956,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_36958 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36956,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_36959 = config;
var inst_36960 = cljs.core.__destructure_map(inst_36959);
var inst_36961 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36960,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_36962 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_36961,inst_36957);
var inst_36963 = fluree.db.index.data_node(block,t,inst_36962,rhs,config);
var inst_36964 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_36963);
var _ = (function (){var statearr_36978 = state_36969;
(statearr_36978[(4)] = cljs.core.rest((state_36969[(4)])));

return statearr_36978;
})();
var state_36969__$1 = (function (){var statearr_36979 = state_36969;
(statearr_36979[(10)] = inst_36958);

(statearr_36979[(11)] = inst_36955);

return statearr_36979;
})();
var statearr_36980_37003 = state_36969__$1;
(statearr_36980_37003[(2)] = inst_36964);

(statearr_36980_37003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36970 === (2))){
var _ = (function (){var statearr_36981 = state_36969;
(statearr_36981[(4)] = cljs.core.cons((5),(state_36969[(4)])));

return statearr_36981;
})();
var inst_36936 = fluree.db.storage.core.read_leaf(conn,key);
var state_36969__$1 = state_36969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36969__$1,(6),inst_36936);
} else {
if((state_val_36970 === (11))){
var state_36969__$1 = state_36969;
var statearr_36983_37004 = state_36969__$1;
(statearr_36983_37004[(2)] = null);

(statearr_36983_37004[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36970 === (9))){
var inst_36938 = (state_36969[(9)]);
var inst_36949 = (state_36969[(2)]);
var inst_36950 = fluree.db.util.core.exception_QMARK_(inst_36938);
var state_36969__$1 = (function (){var statearr_36984 = state_36969;
(statearr_36984[(12)] = inst_36949);

return statearr_36984;
})();
if(inst_36950){
var statearr_36985_37005 = state_36969__$1;
(statearr_36985_37005[(1)] = (10));

} else {
var statearr_36986_37006 = state_36969__$1;
(statearr_36986_37006[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36970 === (5))){
var _ = (function (){var statearr_36987 = state_36969;
(statearr_36987[(4)] = cljs.core.rest((state_36969[(4)])));

return statearr_36987;
})();
var state_36969__$1 = state_36969;
var ex36982 = (state_36969__$1[(2)]);
var statearr_36988_37007 = state_36969__$1;
(statearr_36988_37007[(5)] = ex36982);


var statearr_36989_37008 = state_36969__$1;
(statearr_36989_37008[(1)] = (4));

(statearr_36989_37008[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36970 === (10))){
var inst_36938 = (state_36969[(9)]);
var inst_36952 = (function(){throw inst_36938})();
var state_36969__$1 = state_36969;
var statearr_36990_37009 = state_36969__$1;
(statearr_36990_37009[(2)] = inst_36952);

(statearr_36990_37009[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36970 === (8))){
var state_36969__$1 = state_36969;
var statearr_36991_37010 = state_36969__$1;
(statearr_36991_37010[(2)] = null);

(statearr_36991_37010[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__17178__auto____0 = (function (){
var statearr_36992 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36992[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__17178__auto__);

(statearr_36992[(1)] = (1));

return statearr_36992;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__17178__auto____1 = (function (state_36969){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_36969);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e36993){var ex__17181__auto__ = e36993;
var statearr_36994_37011 = state_36969;
(statearr_36994_37011[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_36969[(4)]))){
var statearr_36995_37012 = state_36969;
(statearr_36995_37012[(1)] = cljs.core.first((state_36969[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37013 = state_36969;
state_36969 = G__37013;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__17178__auto__ = function(state_36969){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__17178__auto____1.call(this,state_36969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__17178__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__17178__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_36996 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_36996[(6)] = c__17304__auto___36997);

return statearr_36996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k37015,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__37019 = k37015;
var G__37019__$1 = (((G__37019 instanceof cljs.core.Keyword))?G__37019.fqn:null);
switch (G__37019__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k37015,else__4464__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__37020){
var vec__37021 = p__37020;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37021,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37021,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__37014){
var self__ = this;
var G__37014__$1 = this;
return (new cljs.core.RecordIter((0),G__37014__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__37024 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__37025 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__37026 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__37027 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__37026,G__37027) : object_cache.call(null,G__37026,G__37027));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__37028 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__37029 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__37028,G__37029) : object_cache.call(null,G__37028,G__37029));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__37024,G__37025) : object_cache.call(null,G__37024,G__37025));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__37030 = history_id;
var G__37031 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__37030,G__37031) : object_cache.call(null,G__37030,G__37031));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__37032 = (function (coll__4458__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__37032(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this37016,other37017){
var self__ = this;
var this37016__$1 = this;
return (((!((other37017 == null)))) && ((((this37016__$1.constructor === other37017.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.conn,other37017.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.config,other37017.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.network,other37017.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.dbid,other37017.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.id,other37017.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.leaf,other37017.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.first,other37017.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.rhs,other37017.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.size,other37017.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.block,other37017.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.t,other37017.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.tt_id,other37017.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.leftmost_QMARK_,other37017.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.tempid,other37017.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37016__$1.__extmap,other37017.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k37015){
var self__ = this;
var this__4468__auto____$1 = this;
var G__37033 = k37015;
var G__37033__$1 = (((G__37033 instanceof cljs.core.Keyword))?G__37033.fqn:null);
switch (G__37033__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k37015);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__37014){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__37034 = cljs.core.keyword_identical_QMARK_;
var expr__37035 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__37037 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__37038 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37037,G__37038) : pred__37034.call(null,G__37037,G__37038));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__37014,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37039 = new cljs.core.Keyword(null,"config","config",994861415);
var G__37040 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37039,G__37040) : pred__37034.call(null,G__37039,G__37040));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__37014,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37041 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__37042 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37041,G__37042) : pred__37034.call(null,G__37041,G__37042));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__37014,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37043 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__37044 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37043,G__37044) : pred__37034.call(null,G__37043,G__37044));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__37014,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37045 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__37046 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37045,G__37046) : pred__37034.call(null,G__37045,G__37046));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__37014,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37047 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__37048 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37047,G__37048) : pred__37034.call(null,G__37047,G__37048));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__37014,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37049 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__37050 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37049,G__37050) : pred__37034.call(null,G__37049,G__37050));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__37014,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37051 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__37052 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37051,G__37052) : pred__37034.call(null,G__37051,G__37052));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__37014,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37053 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__37054 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37053,G__37054) : pred__37034.call(null,G__37053,G__37054));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__37014,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37055 = new cljs.core.Keyword(null,"block","block",664686210);
var G__37056 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37055,G__37056) : pred__37034.call(null,G__37055,G__37056));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__37014,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37057 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__37058 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37057,G__37058) : pred__37034.call(null,G__37057,G__37058));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__37014,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37059 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__37060 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37059,G__37060) : pred__37034.call(null,G__37059,G__37060));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__37014,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37061 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__37062 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37061,G__37062) : pred__37034.call(null,G__37061,G__37062));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__37014,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37063 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__37064 = expr__37035;
return (pred__37034.cljs$core$IFn$_invoke$arity$2 ? pred__37034.cljs$core$IFn$_invoke$arity$2(G__37063,G__37064) : pred__37034.call(null,G__37063,G__37064));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__37014,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__37014),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__37014){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__37014,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__37018){
var extmap__4501__auto__ = (function (){var G__37065 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__37018,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__37018)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__37065);
} else {
return G__37065;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__37018),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__37018),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__37068 = blank_db;
var map__37068__$1 = cljs.core.__destructure_map(map__37068);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37068__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37068__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37068__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__37069 = root_data;
var map__37069__$1 = cljs.core.__destructure_map(map__37069);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37069__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37069__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37069__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37069__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_37091){
var state_val_37092 = (state_37091[(1)]);
if((state_val_37092 === (7))){
var state_37091__$1 = state_37091;
var statearr_37093_37113 = state_37091__$1;
(statearr_37093_37113[(2)] = null);

(statearr_37093_37113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37092 === (1))){
var state_37091__$1 = state_37091;
var statearr_37094_37114 = state_37091__$1;
(statearr_37094_37114[(2)] = null);

(statearr_37094_37114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37092 === (4))){
var inst_37070 = (state_37091[(2)]);
var state_37091__$1 = state_37091;
var statearr_37095_37115 = state_37091__$1;
(statearr_37095_37115[(2)] = inst_37070);

(statearr_37095_37115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37092 === (6))){
var inst_37077 = (state_37091[(7)]);
var inst_37079 = fluree.db.storage.core.serde(conn);
var state_37091__$1 = (function (){var statearr_37096 = state_37091;
(statearr_37096[(8)] = inst_37079);

return statearr_37096;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37091__$1,(9),inst_37077);
} else {
if((state_val_37092 === (3))){
var inst_37089 = (state_37091[(2)]);
var state_37091__$1 = state_37091;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37091__$1,inst_37089);
} else {
if((state_val_37092 === (2))){
var inst_37077 = (state_37091[(7)]);
var _ = (function (){var statearr_37098 = state_37091;
(statearr_37098[(4)] = cljs.core.cons((5),(state_37091[(4)])));

return statearr_37098;
})();
var inst_37076 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_37077__$1 = fluree.db.storage.core.storage_read(conn,inst_37076);
var state_37091__$1 = (function (){var statearr_37099 = state_37091;
(statearr_37099[(7)] = inst_37077__$1);

return statearr_37099;
})();
if(cljs.core.truth_(inst_37077__$1)){
var statearr_37100_37116 = state_37091__$1;
(statearr_37100_37116[(1)] = (6));

} else {
var statearr_37101_37117 = state_37091__$1;
(statearr_37101_37117[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37092 === (9))){
var inst_37079 = (state_37091[(8)]);
var inst_37081 = (state_37091[(2)]);
var inst_37082 = fluree.db.util.async.throw_err(inst_37081);
var inst_37083 = fluree.db.serde.protocol._deserialize_garbage(inst_37079,inst_37082);
var state_37091__$1 = state_37091;
var statearr_37102_37118 = state_37091__$1;
(statearr_37102_37118[(2)] = inst_37083);

(statearr_37102_37118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37092 === (5))){
var _ = (function (){var statearr_37103 = state_37091;
(statearr_37103[(4)] = cljs.core.rest((state_37091[(4)])));

return statearr_37103;
})();
var state_37091__$1 = state_37091;
var ex37097 = (state_37091__$1[(2)]);
var statearr_37104_37119 = state_37091__$1;
(statearr_37104_37119[(5)] = ex37097);


if((ex37097 instanceof Error)){
var statearr_37105_37120 = state_37091__$1;
(statearr_37105_37120[(1)] = (4));

(statearr_37105_37120[(5)] = null);

} else {
throw ex37097;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37092 === (8))){
var inst_37086 = (state_37091[(2)]);
var _ = (function (){var statearr_37106 = state_37091;
(statearr_37106[(4)] = cljs.core.rest((state_37091[(4)])));

return statearr_37106;
})();
var state_37091__$1 = state_37091;
var statearr_37107_37121 = state_37091__$1;
(statearr_37107_37121[(2)] = inst_37086);

(statearr_37107_37121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__17178__auto____0 = (function (){
var statearr_37108 = [null,null,null,null,null,null,null,null,null];
(statearr_37108[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__17178__auto__);

(statearr_37108[(1)] = (1));

return statearr_37108;
});
var fluree$db$storage$core$read_garbage_$_state_machine__17178__auto____1 = (function (state_37091){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_37091);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e37109){var ex__17181__auto__ = e37109;
var statearr_37110_37122 = state_37091;
(statearr_37110_37122[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_37091[(4)]))){
var statearr_37111_37123 = state_37091;
(statearr_37111_37123[(1)] = cljs.core.first((state_37091[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37124 = state_37091;
state_37091 = G__37124;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__17178__auto__ = function(state_37091){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__17178__auto____1.call(this,state_37091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__17178__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__17178__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_37112 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_37112[(6)] = c__17304__auto__);

return statearr_37112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_37146){
var state_val_37147 = (state_37146[(1)]);
if((state_val_37147 === (7))){
var inst_37135 = (state_37146[(7)]);
var inst_37137 = fluree.db.storage.core.serde(conn);
var inst_37138 = fluree.db.serde.protocol._deserialize_db_root(inst_37137,inst_37135);
var state_37146__$1 = state_37146;
var statearr_37148_37167 = state_37146__$1;
(statearr_37148_37167[(2)] = inst_37138);

(statearr_37148_37167[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37147 === (1))){
var state_37146__$1 = state_37146;
var statearr_37149_37168 = state_37146__$1;
(statearr_37149_37168[(2)] = null);

(statearr_37149_37168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37147 === (4))){
var inst_37125 = (state_37146[(2)]);
var state_37146__$1 = state_37146;
var statearr_37150_37169 = state_37146__$1;
(statearr_37150_37169[(2)] = inst_37125);

(statearr_37150_37169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37147 === (6))){
var inst_37135 = (state_37146[(7)]);
var inst_37134 = (state_37146[(2)]);
var inst_37135__$1 = fluree.db.util.async.throw_err(inst_37134);
var state_37146__$1 = (function (){var statearr_37151 = state_37146;
(statearr_37151[(7)] = inst_37135__$1);

return statearr_37151;
})();
if(cljs.core.truth_(inst_37135__$1)){
var statearr_37152_37170 = state_37146__$1;
(statearr_37152_37170[(1)] = (7));

} else {
var statearr_37153_37171 = state_37146__$1;
(statearr_37153_37171[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37147 === (3))){
var inst_37144 = (state_37146[(2)]);
var state_37146__$1 = state_37146;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37146__$1,inst_37144);
} else {
if((state_val_37147 === (2))){
var _ = (function (){var statearr_37155 = state_37146;
(statearr_37155[(4)] = cljs.core.cons((5),(state_37146[(4)])));

return statearr_37155;
})();
var inst_37131 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_37132 = fluree.db.storage.core.storage_read(conn,inst_37131);
var state_37146__$1 = state_37146;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37146__$1,(6),inst_37132);
} else {
if((state_val_37147 === (9))){
var inst_37141 = (state_37146[(2)]);
var _ = (function (){var statearr_37156 = state_37146;
(statearr_37156[(4)] = cljs.core.rest((state_37146[(4)])));

return statearr_37156;
})();
var state_37146__$1 = state_37146;
var statearr_37157_37172 = state_37146__$1;
(statearr_37157_37172[(2)] = inst_37141);

(statearr_37157_37172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37147 === (5))){
var _ = (function (){var statearr_37158 = state_37146;
(statearr_37158[(4)] = cljs.core.rest((state_37146[(4)])));

return statearr_37158;
})();
var state_37146__$1 = state_37146;
var ex37154 = (state_37146__$1[(2)]);
var statearr_37159_37173 = state_37146__$1;
(statearr_37159_37173[(5)] = ex37154);


if((ex37154 instanceof Error)){
var statearr_37160_37174 = state_37146__$1;
(statearr_37160_37174[(1)] = (4));

(statearr_37160_37174[(5)] = null);

} else {
throw ex37154;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37147 === (8))){
var state_37146__$1 = state_37146;
var statearr_37161_37175 = state_37146__$1;
(statearr_37161_37175[(2)] = null);

(statearr_37161_37175[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__17178__auto____0 = (function (){
var statearr_37162 = [null,null,null,null,null,null,null,null];
(statearr_37162[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__17178__auto__);

(statearr_37162[(1)] = (1));

return statearr_37162;
});
var fluree$db$storage$core$read_db_root_$_state_machine__17178__auto____1 = (function (state_37146){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_37146);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e37163){var ex__17181__auto__ = e37163;
var statearr_37164_37176 = state_37146;
(statearr_37164_37176[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_37146[(4)]))){
var statearr_37165_37177 = state_37146;
(statearr_37165_37177[(1)] = cljs.core.first((state_37146[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37178 = state_37146;
state_37146 = G__37178;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__17178__auto__ = function(state_37146){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__17178__auto____1.call(this,state_37146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__17178__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__17178__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_37166 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_37166[(6)] = c__17304__auto__);

return statearr_37166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_37214){
var state_val_37215 = (state_37214[(1)]);
if((state_val_37215 === (7))){
var inst_37188 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_37189 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37190 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_37191 = cljs.core.PersistentHashMap.fromArrays(inst_37189,inst_37190);
var inst_37192 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37188,inst_37191);
var inst_37193 = (function(){throw inst_37192})();
var state_37214__$1 = state_37214;
var statearr_37216_37238 = state_37214__$1;
(statearr_37216_37238[(2)] = inst_37193);

(statearr_37216_37238[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37215 === (1))){
var state_37214__$1 = state_37214;
var statearr_37217_37239 = state_37214__$1;
(statearr_37217_37239[(2)] = null);

(statearr_37217_37239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37215 === (4))){
var inst_37179 = (state_37214[(2)]);
var state_37214__$1 = state_37214;
var statearr_37218_37240 = state_37214__$1;
(statearr_37218_37240[(2)] = inst_37179);

(statearr_37218_37240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37215 === (6))){
var state_37214__$1 = state_37214;
var statearr_37219_37241 = state_37214__$1;
(statearr_37219_37241[(2)] = null);

(statearr_37219_37241[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37215 === (3))){
var inst_37212 = (state_37214[(2)]);
var state_37214__$1 = state_37214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37214__$1,inst_37212);
} else {
if((state_val_37215 === (2))){
var inst_37185 = (state_37214[(7)]);
var _ = (function (){var statearr_37220 = state_37214;
(statearr_37220[(4)] = cljs.core.cons((5),(state_37214[(4)])));

return statearr_37220;
})();
var inst_37185__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_37214__$1 = (function (){var statearr_37221 = state_37214;
(statearr_37221[(7)] = inst_37185__$1);

return statearr_37221;
})();
if(cljs.core.truth_(inst_37185__$1)){
var statearr_37222_37242 = state_37214__$1;
(statearr_37222_37242[(1)] = (6));

} else {
var statearr_37223_37243 = state_37214__$1;
(statearr_37223_37243[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37215 === (11))){
var inst_37204 = (state_37214[(8)]);
var inst_37207 = (state_37214[(2)]);
var inst_37208 = fluree.db.util.async.throw_err(inst_37207);
var inst_37209 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37204,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_37208);
var _ = (function (){var statearr_37225 = state_37214;
(statearr_37225[(4)] = cljs.core.rest((state_37214[(4)])));

return statearr_37225;
})();
var state_37214__$1 = state_37214;
var statearr_37226_37244 = state_37214__$1;
(statearr_37226_37244[(2)] = inst_37209);

(statearr_37226_37244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37215 === (9))){
var inst_37199 = (state_37214[(9)]);
var inst_37197 = (state_37214[(2)]);
var inst_37198 = fluree.db.util.async.throw_err(inst_37197);
var inst_37199__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_37198);
var inst_37200 = fluree.db.query.schema.schema_map(inst_37199__$1);
var state_37214__$1 = (function (){var statearr_37227 = state_37214;
(statearr_37227[(9)] = inst_37199__$1);

return statearr_37227;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37214__$1,(10),inst_37200);
} else {
if((state_val_37215 === (5))){
var _ = (function (){var statearr_37228 = state_37214;
(statearr_37228[(4)] = cljs.core.rest((state_37214[(4)])));

return statearr_37228;
})();
var state_37214__$1 = state_37214;
var ex37224 = (state_37214__$1[(2)]);
var statearr_37229_37245 = state_37214__$1;
(statearr_37229_37245[(5)] = ex37224);


if((ex37224 instanceof Error)){
var statearr_37230_37246 = state_37214__$1;
(statearr_37230_37246[(1)] = (4));

(statearr_37230_37246[(5)] = null);

} else {
throw ex37224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37215 === (10))){
var inst_37204 = (state_37214[(8)]);
var inst_37199 = (state_37214[(9)]);
var inst_37202 = (state_37214[(2)]);
var inst_37203 = fluree.db.util.async.throw_err(inst_37202);
var inst_37204__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37199,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_37203);
var inst_37205 = fluree.db.query.schema.setting_map(inst_37204__$1);
var state_37214__$1 = (function (){var statearr_37231 = state_37214;
(statearr_37231[(8)] = inst_37204__$1);

return statearr_37231;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37214__$1,(11),inst_37205);
} else {
if((state_val_37215 === (8))){
var inst_37185 = (state_37214[(7)]);
var inst_37195 = (state_37214[(2)]);
var state_37214__$1 = (function (){var statearr_37232 = state_37214;
(statearr_37232[(10)] = inst_37195);

return statearr_37232;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37214__$1,(9),inst_37185);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__17178__auto____0 = (function (){
var statearr_37233 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37233[(0)] = fluree$db$storage$core$reify_db_$_state_machine__17178__auto__);

(statearr_37233[(1)] = (1));

return statearr_37233;
});
var fluree$db$storage$core$reify_db_$_state_machine__17178__auto____1 = (function (state_37214){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_37214);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e37234){var ex__17181__auto__ = e37234;
var statearr_37235_37247 = state_37214;
(statearr_37235_37247[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_37214[(4)]))){
var statearr_37236_37248 = state_37214;
(statearr_37236_37248[(1)] = cljs.core.first((state_37214[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37249 = state_37214;
state_37214 = G__37249;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__17178__auto__ = function(state_37214){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__17178__auto____1.call(this,state_37214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__17178__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__17178__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_37237 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_37237[(6)] = c__17304__auto__);

return statearr_37237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__37251 = arguments.length;
switch (G__37251) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_37304){
var state_val_37305 = (state_37304[(1)]);
if((state_val_37305 === (7))){
var inst_37261 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_37262 = (new Error(inst_37261));
var inst_37263 = (function(){throw inst_37262})();
var state_37304__$1 = state_37304;
var statearr_37306_37346 = state_37304__$1;
(statearr_37306_37346[(2)] = inst_37263);

(statearr_37306_37346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (20))){
var inst_37295 = (state_37304[(2)]);
var state_37304__$1 = state_37304;
var statearr_37307_37347 = state_37304__$1;
(statearr_37307_37347[(2)] = inst_37295);

(statearr_37307_37347[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (1))){
var state_37304__$1 = state_37304;
var statearr_37308_37348 = state_37304__$1;
(statearr_37308_37348[(2)] = null);

(statearr_37308_37348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (4))){
var inst_37252 = (state_37304[(2)]);
var state_37304__$1 = state_37304;
var statearr_37309_37349 = state_37304__$1;
(statearr_37309_37349[(2)] = inst_37252);

(statearr_37309_37349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (15))){
var inst_37270 = (state_37304[(7)]);
var state_37304__$1 = state_37304;
var statearr_37310_37350 = state_37304__$1;
(statearr_37310_37350[(2)] = inst_37270);

(statearr_37310_37350[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (21))){
var inst_37270 = (state_37304[(7)]);
var inst_37274 = (state_37304[(8)]);
var inst_37269 = (state_37304[(9)]);
var inst_37288 = (inst_37269 + (1));
var inst_37289 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37270,inst_37274);
var inst_37269__$1 = inst_37288;
var inst_37270__$1 = inst_37289;
var state_37304__$1 = (function (){var statearr_37311 = state_37304;
(statearr_37311[(7)] = inst_37270__$1);

(statearr_37311[(9)] = inst_37269__$1);

return statearr_37311;
})();
var statearr_37312_37351 = state_37304__$1;
(statearr_37312_37351[(2)] = null);

(statearr_37312_37351[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (13))){
var inst_37274 = (state_37304[(8)]);
var inst_37278 = (inst_37274 instanceof Error);
var state_37304__$1 = state_37304;
var statearr_37313_37352 = state_37304__$1;
(statearr_37313_37352[(2)] = inst_37278);

(statearr_37313_37352[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (22))){
var state_37304__$1 = state_37304;
var statearr_37314_37353 = state_37304__$1;
(statearr_37314_37353[(2)] = null);

(statearr_37314_37353[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (6))){
var state_37304__$1 = state_37304;
var statearr_37315_37354 = state_37304__$1;
(statearr_37315_37354[(2)] = null);

(statearr_37315_37354[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (17))){
var inst_37297 = (state_37304[(2)]);
var state_37304__$1 = state_37304;
var statearr_37316_37355 = state_37304__$1;
(statearr_37316_37355[(2)] = inst_37297);

(statearr_37316_37355[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (3))){
var inst_37302 = (state_37304[(2)]);
var state_37304__$1 = state_37304;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37304__$1,inst_37302);
} else {
if((state_val_37305 === (12))){
var inst_37275 = (state_37304[(10)]);
var state_37304__$1 = state_37304;
var statearr_37317_37356 = state_37304__$1;
(statearr_37317_37356[(2)] = inst_37275);

(statearr_37317_37356[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (2))){
var _ = (function (){var statearr_37318 = state_37304;
(statearr_37318[(4)] = cljs.core.cons((5),(state_37304[(4)])));

return statearr_37318;
})();
var inst_37258 = (end >= start);
var state_37304__$1 = state_37304;
if(cljs.core.truth_(inst_37258)){
var statearr_37319_37357 = state_37304__$1;
(statearr_37319_37357[(1)] = (6));

} else {
var statearr_37320_37358 = state_37304__$1;
(statearr_37320_37358[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (23))){
var inst_37293 = (state_37304[(2)]);
var state_37304__$1 = state_37304;
var statearr_37321_37359 = state_37304__$1;
(statearr_37321_37359[(2)] = inst_37293);

(statearr_37321_37359[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (19))){
var state_37304__$1 = state_37304;
var statearr_37322_37360 = state_37304__$1;
(statearr_37322_37360[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (11))){
var inst_37275 = (state_37304[(10)]);
var inst_37274 = (state_37304[(8)]);
var inst_37274__$1 = (state_37304[(2)]);
var inst_37275__$1 = (inst_37274__$1 == null);
var state_37304__$1 = (function (){var statearr_37325 = state_37304;
(statearr_37325[(10)] = inst_37275__$1);

(statearr_37325[(8)] = inst_37274__$1);

return statearr_37325;
})();
if(cljs.core.truth_(inst_37275__$1)){
var statearr_37326_37361 = state_37304__$1;
(statearr_37326_37361[(1)] = (12));

} else {
var statearr_37327_37362 = state_37304__$1;
(statearr_37327_37362[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (9))){
var inst_37269 = (state_37304[(9)]);
var inst_37272 = fluree.db.storage.core.read_block(conn,network,dbid,inst_37269);
var state_37304__$1 = state_37304;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37304__$1,(11),inst_37272);
} else {
if((state_val_37305 === (5))){
var _ = (function (){var statearr_37328 = state_37304;
(statearr_37328[(4)] = cljs.core.rest((state_37304[(4)])));

return statearr_37328;
})();
var state_37304__$1 = state_37304;
var ex37324 = (state_37304__$1[(2)]);
var statearr_37329_37363 = state_37304__$1;
(statearr_37329_37363[(5)] = ex37324);


if((ex37324 instanceof Error)){
var statearr_37330_37364 = state_37304__$1;
(statearr_37330_37364[(1)] = (4));

(statearr_37330_37364[(5)] = null);

} else {
throw ex37324;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (14))){
var inst_37280 = (state_37304[(2)]);
var state_37304__$1 = state_37304;
if(cljs.core.truth_(inst_37280)){
var statearr_37331_37365 = state_37304__$1;
(statearr_37331_37365[(1)] = (15));

} else {
var statearr_37332_37366 = state_37304__$1;
(statearr_37332_37366[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (16))){
var inst_37269 = (state_37304[(9)]);
var inst_37283 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37269,end);
var state_37304__$1 = state_37304;
if(inst_37283){
var statearr_37333_37367 = state_37304__$1;
(statearr_37333_37367[(1)] = (18));

} else {
var statearr_37334_37368 = state_37304__$1;
(statearr_37334_37368[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (10))){
var inst_37299 = (state_37304[(2)]);
var _ = (function (){var statearr_37335 = state_37304;
(statearr_37335[(4)] = cljs.core.rest((state_37304[(4)])));

return statearr_37335;
})();
var state_37304__$1 = state_37304;
var statearr_37336_37369 = state_37304__$1;
(statearr_37336_37369[(2)] = inst_37299);

(statearr_37336_37369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (18))){
var inst_37270 = (state_37304[(7)]);
var inst_37274 = (state_37304[(8)]);
var inst_37285 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37270,inst_37274);
var state_37304__$1 = state_37304;
var statearr_37337_37370 = state_37304__$1;
(statearr_37337_37370[(2)] = inst_37285);

(statearr_37337_37370[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37305 === (8))){
var inst_37265 = (state_37304[(2)]);
var inst_37266 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_37267 = start;
var inst_37268 = cljs.core.PersistentVector.EMPTY;
var inst_37269 = inst_37267;
var inst_37270 = inst_37268;
var state_37304__$1 = (function (){var statearr_37338 = state_37304;
(statearr_37338[(7)] = inst_37270);

(statearr_37338[(11)] = inst_37266);

(statearr_37338[(9)] = inst_37269);

(statearr_37338[(12)] = inst_37265);

return statearr_37338;
})();
var statearr_37339_37371 = state_37304__$1;
(statearr_37339_37371[(2)] = null);

(statearr_37339_37371[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__17178__auto__ = null;
var fluree$db$storage$core$state_machine__17178__auto____0 = (function (){
var statearr_37340 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37340[(0)] = fluree$db$storage$core$state_machine__17178__auto__);

(statearr_37340[(1)] = (1));

return statearr_37340;
});
var fluree$db$storage$core$state_machine__17178__auto____1 = (function (state_37304){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_37304);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e37341){var ex__17181__auto__ = e37341;
var statearr_37342_37372 = state_37304;
(statearr_37342_37372[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_37304[(4)]))){
var statearr_37343_37373 = state_37304;
(statearr_37343_37373[(1)] = cljs.core.first((state_37304[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37374 = state_37304;
state_37304 = G__37374;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__17178__auto__ = function(state_37304){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__17178__auto____1.call(this,state_37304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__17178__auto____0;
fluree$db$storage$core$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__17178__auto____1;
return fluree$db$storage$core$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_37344 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_37344[(6)] = c__17304__auto__);

return statearr_37344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_37390){
var state_val_37391 = (state_37390[(1)]);
if((state_val_37391 === (1))){
var state_37390__$1 = state_37390;
var statearr_37392_37406 = state_37390__$1;
(statearr_37392_37406[(2)] = null);

(statearr_37392_37406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37391 === (2))){
var _ = (function (){var statearr_37393 = state_37390;
(statearr_37393[(4)] = cljs.core.cons((5),(state_37390[(4)])));

return statearr_37393;
})();
var inst_37381 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_37390__$1 = state_37390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37390__$1,(6),inst_37381);
} else {
if((state_val_37391 === (3))){
var inst_37388 = (state_37390[(2)]);
var state_37390__$1 = state_37390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37390__$1,inst_37388);
} else {
if((state_val_37391 === (4))){
var inst_37375 = (state_37390[(2)]);
var state_37390__$1 = state_37390;
var statearr_37395_37407 = state_37390__$1;
(statearr_37395_37407[(2)] = inst_37375);

(statearr_37395_37407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37391 === (5))){
var _ = (function (){var statearr_37396 = state_37390;
(statearr_37396[(4)] = cljs.core.rest((state_37390[(4)])));

return statearr_37396;
})();
var state_37390__$1 = state_37390;
var ex37394 = (state_37390__$1[(2)]);
var statearr_37397_37408 = state_37390__$1;
(statearr_37397_37408[(5)] = ex37394);


if((ex37394 instanceof Error)){
var statearr_37398_37409 = state_37390__$1;
(statearr_37398_37409[(1)] = (4));

(statearr_37398_37409[(5)] = null);

} else {
throw ex37394;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37391 === (6))){
var inst_37383 = (state_37390[(2)]);
var inst_37384 = fluree.db.util.async.throw_err(inst_37383);
var inst_37385 = cljs.core.first(inst_37384);
var _ = (function (){var statearr_37399 = state_37390;
(statearr_37399[(4)] = cljs.core.rest((state_37390[(4)])));

return statearr_37399;
})();
var state_37390__$1 = state_37390;
var statearr_37400_37410 = state_37390__$1;
(statearr_37400_37410[(2)] = inst_37385);

(statearr_37400_37410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__17178__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__17178__auto____0 = (function (){
var statearr_37401 = [null,null,null,null,null,null,null];
(statearr_37401[(0)] = fluree$db$storage$core$block_$_state_machine__17178__auto__);

(statearr_37401[(1)] = (1));

return statearr_37401;
});
var fluree$db$storage$core$block_$_state_machine__17178__auto____1 = (function (state_37390){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_37390);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e37402){var ex__17181__auto__ = e37402;
var statearr_37403_37411 = state_37390;
(statearr_37403_37411[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_37390[(4)]))){
var statearr_37404_37412 = state_37390;
(statearr_37404_37412[(1)] = cljs.core.first((state_37390[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37413 = state_37390;
state_37390 = G__37413;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__17178__auto__ = function(state_37390){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__17178__auto____1.call(this,state_37390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__17178__auto____0;
fluree$db$storage$core$block_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__17178__auto____1;
return fluree$db$storage$core$block_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_37405 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_37405[(6)] = c__17304__auto__);

return statearr_37405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
