// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4212__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__32380 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32380,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32380,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32380,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32380,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32380,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32380,(5),null);
var G__32383 = idx;
var G__32383__$1 = (((G__32383 instanceof cljs.core.Keyword))?G__32383.fqn:null);
switch (G__32383__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32383__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__32385 = idx;
var G__32385__$1 = (((G__32385 instanceof cljs.core.Keyword))?G__32385.fqn:null);
switch (G__32385__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32385__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__32387 = idx;
var G__32387__$1 = (((G__32387 instanceof cljs.core.Keyword))?G__32387.fqn:null);
switch (G__32387__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32387__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__32390 = arguments.length;
switch (G__32390) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__32391 = (function (){var pred__32394 = cljs.core.identical_QMARK_;
var expr__32395 = test;
if(cljs.core.truth_((pred__32394.cljs$core$IFn$_invoke$arity$2 ? pred__32394.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__32395) : pred__32394.call(null,cljs.core._EQ_,expr__32395)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__32394.cljs$core$IFn$_invoke$arity$2 ? pred__32394.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__32395) : pred__32394.call(null,cljs.core._LT_,expr__32395)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__32394.cljs$core$IFn$_invoke$arity$2 ? pred__32394.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__32395) : pred__32394.call(null,cljs.core._LT__EQ_,expr__32395)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__32394.cljs$core$IFn$_invoke$arity$2 ? pred__32394.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__32395) : pred__32394.call(null,cljs.core._GT_,expr__32395)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__32394.cljs$core$IFn$_invoke$arity$2 ? pred__32394.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__32395) : pred__32394.call(null,cljs.core._GT__EQ_,expr__32395)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__32395)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32391,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32391,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32391,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32391,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_32634){
var state_val_32635 = (state_32634[(1)]);
if((state_val_32635 === (65))){
var inst_32605 = (state_32634[(7)]);
var inst_32549 = (state_32634[(8)]);
var inst_32605__$1 = (state_32634[(2)]);
var inst_32606 = cljs.core.count(inst_32605__$1);
var state_32634__$1 = (function (){var statearr_32636 = state_32634;
(statearr_32636[(7)] = inst_32605__$1);

(statearr_32636[(9)] = inst_32606);

return statearr_32636;
})();
if(cljs.core.truth_(inst_32549)){
var statearr_32637_32774 = state_32634__$1;
(statearr_32637_32774[(1)] = (81));

} else {
var statearr_32638_32775 = state_32634__$1;
(statearr_32638_32775[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (70))){
var inst_32580 = (state_32634[(2)]);
var state_32634__$1 = state_32634;
if(cljs.core.truth_(inst_32580)){
var statearr_32639_32776 = state_32634__$1;
(statearr_32639_32776[(1)] = (71));

} else {
var statearr_32640_32777 = state_32634__$1;
(statearr_32640_32777[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (62))){
var inst_32519 = (state_32634[(10)]);
var inst_32533 = (state_32634[(11)]);
var inst_32548 = (state_32634[(2)]);
var inst_32549 = fluree.db.dbproto._rhs(inst_32533);
var state_32634__$1 = (function (){var statearr_32641 = state_32634;
(statearr_32641[(8)] = inst_32549);

(statearr_32641[(12)] = inst_32548);

return statearr_32641;
})();
if(cljs.core.truth_(inst_32519)){
var statearr_32642_32778 = state_32634__$1;
(statearr_32642_32778[(1)] = (63));

} else {
var statearr_32643_32779 = state_32634__$1;
(statearr_32643_32779[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (74))){
var inst_32573 = (state_32634[(13)]);
var inst_32587 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_32573);
var state_32634__$1 = state_32634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32634__$1,(77),inst_32587);
} else {
if((state_val_32635 === (7))){
var inst_32410 = (state_32634[(14)]);
var state_32634__$1 = state_32634;
var statearr_32644_32780 = state_32634__$1;
(statearr_32644_32780[(2)] = inst_32410);

(statearr_32644_32780[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (59))){
var inst_32540 = (state_32634[(15)]);
var inst_32496 = (state_32634[(16)]);
var inst_32495 = (state_32634[(17)]);
var inst_32539 = (state_32634[(2)]);
var inst_32540__$1 = fluree.db.util.async.throw_err(inst_32539);
var inst_32541 = fluree.db.flake.subrange(inst_32540__$1,start_test,inst_32495,end_test,inst_32496);
var inst_32542 = fluree.db.query.range.value_with_nil_pred(idx,inst_32495,inst_32496);
var state_32634__$1 = (function (){var statearr_32645 = state_32634;
(statearr_32645[(15)] = inst_32540__$1);

(statearr_32645[(18)] = inst_32541);

return statearr_32645;
})();
if(inst_32542){
var statearr_32646_32781 = state_32634__$1;
(statearr_32646_32781[(1)] = (60));

} else {
var statearr_32647_32782 = state_32634__$1;
(statearr_32647_32782[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (86))){
var inst_32614 = (state_32634[(2)]);
var state_32634__$1 = state_32634;
var statearr_32648_32783 = state_32634__$1;
(statearr_32648_32783[(2)] = inst_32614);

(statearr_32648_32783[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (20))){
var inst_32411 = (state_32634[(19)]);
var inst_32459 = (state_32634[(20)]);
var inst_32458 = (state_32634[(2)]);
var inst_32459__$1 = (inst_32411 == null);
var state_32634__$1 = (function (){var statearr_32649 = state_32634;
(statearr_32649[(21)] = inst_32458);

(statearr_32649[(20)] = inst_32459__$1);

return statearr_32649;
})();
if(cljs.core.truth_(inst_32459__$1)){
var statearr_32650_32784 = state_32634__$1;
(statearr_32650_32784[(1)] = (22));

} else {
var statearr_32651_32785 = state_32634__$1;
(statearr_32651_32785[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (72))){
var inst_32566 = (state_32634[(22)]);
var inst_32584 = (inst_32566 + (1));
var inst_32585 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_32634__$1 = (function (){var statearr_32652 = state_32634;
(statearr_32652[(23)] = inst_32584);

return statearr_32652;
})();
if(cljs.core.truth_(inst_32585)){
var statearr_32653_32786 = state_32634__$1;
(statearr_32653_32786[(1)] = (74));

} else {
var statearr_32654_32787 = state_32634__$1;
(statearr_32654_32787[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (58))){
var inst_32629 = (state_32634[(2)]);
var _ = (function (){var statearr_32655 = state_32634;
(statearr_32655[(4)] = cljs.core.rest((state_32634[(4)])));

return statearr_32655;
})();
var state_32634__$1 = state_32634;
var statearr_32656_32788 = state_32634__$1;
(statearr_32656_32788[(2)] = inst_32629);

(statearr_32656_32788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (60))){
var inst_32458 = (state_32634[(21)]);
var inst_32420 = (state_32634[(24)]);
var inst_32540 = (state_32634[(15)]);
var inst_32421 = (state_32634[(25)]);
var inst_32485 = (state_32634[(26)]);
var inst_32414 = (state_32634[(27)]);
var inst_32528 = (state_32634[(28)]);
var inst_32416 = (state_32634[(29)]);
var inst_32494 = (state_32634[(30)]);
var inst_32534 = (state_32634[(31)]);
var inst_32506 = (state_32634[(32)]);
var inst_32502 = (state_32634[(33)]);
var inst_32449 = (state_32634[(34)]);
var inst_32440 = (state_32634[(35)]);
var inst_32519 = (state_32634[(10)]);
var inst_32467 = (state_32634[(36)]);
var inst_32533 = (state_32634[(11)]);
var inst_32496 = (state_32634[(16)]);
var inst_32523 = (state_32634[(37)]);
var inst_32431 = (state_32634[(38)]);
var inst_32541 = (state_32634[(18)]);
var inst_32501 = (state_32634[(39)]);
var inst_32535 = (state_32634[(40)]);
var inst_32413 = (state_32634[(41)]);
var inst_32495 = (state_32634[(17)]);
var inst_32512 = (state_32634[(42)]);
var inst_32409 = (state_32634[(43)]);
var inst_32476 = (state_32634[(44)]);
var inst_32513 = (state_32634[(45)]);
var inst_32544 = (function (){var no_filter_QMARK_ = inst_32519;
var next_node = inst_32533;
var flakes = inst_32540;
var s1 = inst_32431;
var o2 = inst_32458;
var t1 = inst_32413;
var i = inst_32534;
var m1 = inst_32485;
var root_node = inst_32528;
var to_t = inst_32513;
var s2 = inst_32440;
var p2 = inst_32476;
var vec__32406 = inst_32416;
var permissions = inst_32502;
var limit = inst_32501;
var start_flake = inst_32495;
var acc = inst_32535;
var t2 = inst_32420;
var op1 = inst_32414;
var o1 = inst_32449;
var end_flake = inst_32496;
var base_result = inst_32541;
var vec__32403 = inst_32409;
var p1 = inst_32467;
var idx_compare = inst_32506;
var op2 = inst_32421;
var from_t = inst_32512;
var m2 = inst_32494;
var novelty = inst_32523;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_32545 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32544,inst_32541,inst_32541);
var state_32634__$1 = state_32634;
var statearr_32657_32789 = state_32634__$1;
(statearr_32657_32789[(2)] = inst_32545);

(statearr_32657_32789[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (27))){
var inst_32468 = (state_32634[(46)]);
var inst_32418 = (state_32634[(47)]);
var inst_32467 = (state_32634[(2)]);
var inst_32468__$1 = (inst_32418 == null);
var state_32634__$1 = (function (){var statearr_32658 = state_32634;
(statearr_32658[(46)] = inst_32468__$1);

(statearr_32658[(36)] = inst_32467);

return statearr_32658;
})();
if(cljs.core.truth_(inst_32468__$1)){
var statearr_32659_32790 = state_32634__$1;
(statearr_32659_32790[(1)] = (28));

} else {
var statearr_32660_32791 = state_32634__$1;
(statearr_32660_32791[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (1))){
var state_32634__$1 = state_32634;
var statearr_32661_32792 = state_32634__$1;
(statearr_32661_32792[(2)] = null);

(statearr_32661_32792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (69))){
var inst_32501 = (state_32634[(39)]);
var inst_32566 = (state_32634[(22)]);
var inst_32578 = (inst_32566 > inst_32501);
var state_32634__$1 = state_32634;
var statearr_32662_32793 = state_32634__$1;
(statearr_32662_32793[(2)] = inst_32578);

(statearr_32662_32793[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (24))){
var inst_32463 = (state_32634[(2)]);
var state_32634__$1 = state_32634;
if(cljs.core.truth_(inst_32463)){
var statearr_32663_32794 = state_32634__$1;
(statearr_32663_32794[(1)] = (25));

} else {
var statearr_32664_32795 = state_32634__$1;
(statearr_32664_32795[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (55))){
var inst_32528 = (state_32634[(28)]);
var inst_32495 = (state_32634[(17)]);
var inst_32527 = (state_32634[(2)]);
var inst_32528__$1 = fluree.db.util.async.throw_err(inst_32527);
var inst_32529 = fluree.db.dbproto._lookup_leaf(inst_32528__$1,inst_32495);
var state_32634__$1 = (function (){var statearr_32665 = state_32634;
(statearr_32665[(28)] = inst_32528__$1);

return statearr_32665;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32634__$1,(56),inst_32529);
} else {
if((state_val_32635 === (85))){
var inst_32609 = (state_32634[(48)]);
var state_32634__$1 = state_32634;
var statearr_32666_32796 = state_32634__$1;
(statearr_32666_32796[(2)] = inst_32609);

(statearr_32666_32796[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (39))){
var inst_32483 = (state_32634[(2)]);
var state_32634__$1 = state_32634;
var statearr_32667_32797 = state_32634__$1;
(statearr_32667_32797[(2)] = inst_32483);

(statearr_32667_32797[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (88))){
var inst_32528 = (state_32634[(28)]);
var inst_32549 = (state_32634[(8)]);
var inst_32621 = fluree.db.dbproto._lookup_leaf(inst_32528,inst_32549);
var state_32634__$1 = state_32634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32634__$1,(90),inst_32621);
} else {
if((state_val_32635 === (46))){
var inst_32497 = (state_32634[(49)]);
var state_32634__$1 = state_32634;
var statearr_32668_32798 = state_32634__$1;
(statearr_32668_32798[(2)] = inst_32497);

(statearr_32668_32798[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (4))){
var inst_32397 = (state_32634[(2)]);
var state_32634__$1 = state_32634;
var statearr_32669_32799 = state_32634__$1;
(statearr_32669_32799[(2)] = inst_32397);

(statearr_32669_32799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (77))){
var inst_32589 = (state_32634[(2)]);
var inst_32590 = fluree.db.util.async.throw_err(inst_32589);
var state_32634__$1 = state_32634;
if(cljs.core.truth_(inst_32590)){
var statearr_32670_32800 = state_32634__$1;
(statearr_32670_32800[(1)] = (78));

} else {
var statearr_32671_32801 = state_32634__$1;
(statearr_32671_32801[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (54))){
var inst_32519 = (state_32634[(2)]);
var inst_32520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32521 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_32522 = (new cljs.core.PersistentVector(null,2,(5),inst_32520,inst_32521,null));
var inst_32523 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_32522);
var inst_32524 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_32525 = fluree.db.dbproto._resolve(inst_32524);
var state_32634__$1 = (function (){var statearr_32672 = state_32634;
(statearr_32672[(10)] = inst_32519);

(statearr_32672[(37)] = inst_32523);

return statearr_32672;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32634__$1,(55),inst_32525);
} else {
if((state_val_32635 === (15))){
var inst_32412 = (state_32634[(50)]);
var state_32634__$1 = state_32634;
var statearr_32673_32802 = state_32634__$1;
(statearr_32673_32802[(2)] = inst_32412);

(statearr_32673_32802[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (48))){
var inst_32507 = (state_32634[(51)]);
var inst_32501 = (state_32634[(2)]);
var inst_32502 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_32503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32504 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_32505 = (new cljs.core.PersistentVector(null,3,(5),inst_32503,inst_32504,null));
var inst_32506 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_32505);
var inst_32507__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_32634__$1 = (function (){var statearr_32674 = state_32634;
(statearr_32674[(32)] = inst_32506);

(statearr_32674[(33)] = inst_32502);

(statearr_32674[(39)] = inst_32501);

(statearr_32674[(51)] = inst_32507__$1);

return statearr_32674;
})();
if(cljs.core.truth_(inst_32507__$1)){
var statearr_32675_32803 = state_32634__$1;
(statearr_32675_32803[(1)] = (49));

} else {
var statearr_32676_32804 = state_32634__$1;
(statearr_32676_32804[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (50))){
var inst_32510 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_32634__$1 = state_32634;
var statearr_32677_32805 = state_32634__$1;
(statearr_32677_32805[(2)] = inst_32510);

(statearr_32677_32805[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (75))){
var inst_32567 = (state_32634[(52)]);
var state_32634__$1 = state_32634;
var statearr_32678_32806 = state_32634__$1;
(statearr_32678_32806[(2)] = inst_32567);

(statearr_32678_32806[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (21))){
var inst_32454 = (state_32634[(2)]);
var inst_32455 = fluree.db.util.async.throw_err(inst_32454);
var state_32634__$1 = state_32634;
var statearr_32679_32807 = state_32634__$1;
(statearr_32679_32807[(2)] = inst_32455);

(statearr_32679_32807[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (31))){
var state_32634__$1 = state_32634;
var statearr_32680_32808 = state_32634__$1;
(statearr_32680_32808[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_32680_32808[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (32))){
var inst_32418 = (state_32634[(47)]);
var state_32634__$1 = state_32634;
var statearr_32681_32809 = state_32634__$1;
(statearr_32681_32809[(2)] = inst_32418);

(statearr_32681_32809[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (40))){
var inst_32422 = (state_32634[(53)]);
var state_32634__$1 = state_32634;
var statearr_32682_32810 = state_32634__$1;
(statearr_32682_32810[(2)] = inst_32422);

(statearr_32682_32810[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (56))){
var inst_32531 = (state_32634[(2)]);
var inst_32532 = fluree.db.util.async.throw_err(inst_32531);
var inst_32533 = inst_32532;
var inst_32534 = (0);
var inst_32535 = null;
var state_32634__$1 = (function (){var statearr_32683 = state_32634;
(statearr_32683[(31)] = inst_32534);

(statearr_32683[(11)] = inst_32533);

(statearr_32683[(40)] = inst_32535);

return statearr_32683;
})();
var statearr_32684_32811 = state_32634__$1;
(statearr_32684_32811[(2)] = null);

(statearr_32684_32811[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (33))){
var inst_32415 = (state_32634[(54)]);
var inst_32476 = (state_32634[(2)]);
var state_32634__$1 = (function (){var statearr_32685 = state_32634;
(statearr_32685[(44)] = inst_32476);

return statearr_32685;
})();
if(cljs.core.truth_(inst_32415)){
var statearr_32686_32812 = state_32634__$1;
(statearr_32686_32812[(1)] = (34));

} else {
var statearr_32687_32813 = state_32634__$1;
(statearr_32687_32813[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (13))){
var inst_32436 = (state_32634[(2)]);
var inst_32437 = fluree.db.util.async.throw_err(inst_32436);
var state_32634__$1 = state_32634;
var statearr_32688_32814 = state_32634__$1;
(statearr_32688_32814[(2)] = inst_32437);

(statearr_32688_32814[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (22))){
var inst_32449 = (state_32634[(34)]);
var state_32634__$1 = state_32634;
var statearr_32689_32815 = state_32634__$1;
(statearr_32689_32815[(2)] = inst_32449);

(statearr_32689_32815[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (90))){
var inst_32605 = (state_32634[(7)]);
var inst_32606 = (state_32634[(9)]);
var inst_32623 = (state_32634[(2)]);
var inst_32624 = fluree.db.util.async.throw_err(inst_32623);
var inst_32533 = inst_32624;
var inst_32534 = inst_32606;
var inst_32535 = inst_32605;
var state_32634__$1 = (function (){var statearr_32690 = state_32634;
(statearr_32690[(31)] = inst_32534);

(statearr_32690[(11)] = inst_32533);

(statearr_32690[(40)] = inst_32535);

return statearr_32690;
})();
var statearr_32691_32816 = state_32634__$1;
(statearr_32691_32816[(2)] = null);

(statearr_32691_32816[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (36))){
var inst_32422 = (state_32634[(53)]);
var inst_32485 = (state_32634[(2)]);
var state_32634__$1 = (function (){var statearr_32692 = state_32634;
(statearr_32692[(26)] = inst_32485);

return statearr_32692;
})();
if(cljs.core.truth_(inst_32422)){
var statearr_32693_32817 = state_32634__$1;
(statearr_32693_32817[(1)] = (40));

} else {
var statearr_32694_32818 = state_32634__$1;
(statearr_32694_32818[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (41))){
var inst_32488 = (cljs.core._LT__EQ_ === end_test);
var state_32634__$1 = state_32634;
if(cljs.core.truth_(inst_32488)){
var statearr_32695_32819 = state_32634__$1;
(statearr_32695_32819[(1)] = (43));

} else {
var statearr_32696_32820 = state_32634__$1;
(statearr_32696_32820[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (89))){
var inst_32627 = (state_32634[(2)]);
var state_32634__$1 = state_32634;
var statearr_32697_32821 = state_32634__$1;
(statearr_32697_32821[(2)] = inst_32627);

(statearr_32697_32821[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (43))){
var state_32634__$1 = state_32634;
var statearr_32698_32822 = state_32634__$1;
(statearr_32698_32822[(2)] = (2147483647));

(statearr_32698_32822[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (61))){
var inst_32541 = (state_32634[(18)]);
var state_32634__$1 = state_32634;
var statearr_32699_32823 = state_32634__$1;
(statearr_32699_32823[(2)] = inst_32541);

(statearr_32699_32823[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (29))){
var inst_32468 = (state_32634[(46)]);
var state_32634__$1 = state_32634;
var statearr_32700_32824 = state_32634__$1;
(statearr_32700_32824[(2)] = inst_32468);

(statearr_32700_32824[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (44))){
var state_32634__$1 = state_32634;
var statearr_32701_32825 = state_32634__$1;
(statearr_32701_32825[(2)] = fluree.db.util.core.min_integer);

(statearr_32701_32825[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (6))){
var inst_32410 = (state_32634[(14)]);
var inst_32425 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_32410);
var state_32634__$1 = state_32634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32634__$1,(9),inst_32425);
} else {
if((state_val_32635 === (28))){
var inst_32458 = (state_32634[(21)]);
var state_32634__$1 = state_32634;
var statearr_32702_32826 = state_32634__$1;
(statearr_32702_32826[(2)] = inst_32458);

(statearr_32702_32826[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (64))){
var inst_32534 = (state_32634[(31)]);
var inst_32548 = (state_32634[(12)]);
var inst_32562 = cljs.core.seq(inst_32548);
var inst_32563 = cljs.core.first(inst_32562);
var inst_32564 = cljs.core.next(inst_32562);
var inst_32565 = inst_32548;
var inst_32566 = inst_32534;
var inst_32567 = inst_32548;
var state_32634__$1 = (function (){var statearr_32703 = state_32634;
(statearr_32703[(55)] = inst_32563);

(statearr_32703[(56)] = inst_32564);

(statearr_32703[(22)] = inst_32566);

(statearr_32703[(57)] = inst_32565);

(statearr_32703[(52)] = inst_32567);

return statearr_32703;
})();
var statearr_32704_32827 = state_32634__$1;
(statearr_32704_32827[(2)] = null);

(statearr_32704_32827[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (51))){
var inst_32512 = (state_32634[(2)]);
var inst_32513 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_32514 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_32634__$1 = (function (){var statearr_32705 = state_32634;
(statearr_32705[(42)] = inst_32512);

(statearr_32705[(45)] = inst_32513);

return statearr_32705;
})();
if(cljs.core.truth_(inst_32514)){
var statearr_32706_32828 = state_32634__$1;
(statearr_32706_32828[(1)] = (52));

} else {
var statearr_32707_32829 = state_32634__$1;
(statearr_32707_32829[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (25))){
var state_32634__$1 = state_32634;
var statearr_32708_32830 = state_32634__$1;
(statearr_32708_32830[(2)] = (-1));

(statearr_32708_32830[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (34))){
var inst_32415 = (state_32634[(54)]);
var state_32634__$1 = state_32634;
var statearr_32709_32831 = state_32634__$1;
(statearr_32709_32831[(2)] = inst_32415);

(statearr_32709_32831[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (17))){
var inst_32445 = (state_32634[(2)]);
var inst_32446 = fluree.db.util.async.throw_err(inst_32445);
var state_32634__$1 = state_32634;
var statearr_32710_32832 = state_32634__$1;
(statearr_32710_32832[(2)] = inst_32446);

(statearr_32710_32832[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (3))){
var inst_32632 = (state_32634[(2)]);
var state_32634__$1 = state_32634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32634__$1,inst_32632);
} else {
if((state_val_32635 === (12))){
var inst_32412 = (state_32634[(50)]);
var inst_32440 = (state_32634[(2)]);
var inst_32441 = fluree.db.util.core.pred_ident_QMARK_(inst_32412);
var state_32634__$1 = (function (){var statearr_32711 = state_32634;
(statearr_32711[(35)] = inst_32440);

return statearr_32711;
})();
if(inst_32441){
var statearr_32712_32833 = state_32634__$1;
(statearr_32712_32833[(1)] = (14));

} else {
var statearr_32713_32834 = state_32634__$1;
(statearr_32713_32834[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (2))){
var inst_32416 = (state_32634[(29)]);
var inst_32410 = (state_32634[(14)]);
var inst_32409 = (state_32634[(43)]);
var _ = (function (){var statearr_32714 = state_32634;
(statearr_32714[(4)] = cljs.core.cons((5),(state_32634[(4)])));

return statearr_32714;
})();
var inst_32409__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_32410__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32409__$1,(0),null);
var inst_32411 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32409__$1,(1),null);
var inst_32412 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32409__$1,(2),null);
var inst_32413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32409__$1,(3),null);
var inst_32414 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32409__$1,(4),null);
var inst_32415 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32409__$1,(5),null);
var inst_32416__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_32417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32416__$1,(0),null);
var inst_32418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32416__$1,(1),null);
var inst_32419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32416__$1,(2),null);
var inst_32420 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32416__$1,(3),null);
var inst_32421 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32416__$1,(4),null);
var inst_32422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32416__$1,(5),null);
var inst_32423 = fluree.db.util.core.pred_ident_QMARK_(inst_32410__$1);
var state_32634__$1 = (function (){var statearr_32715 = state_32634;
(statearr_32715[(19)] = inst_32411);

(statearr_32715[(24)] = inst_32420);

(statearr_32715[(25)] = inst_32421);

(statearr_32715[(58)] = inst_32417);

(statearr_32715[(27)] = inst_32414);

(statearr_32715[(29)] = inst_32416__$1);

(statearr_32715[(53)] = inst_32422);

(statearr_32715[(50)] = inst_32412);

(statearr_32715[(47)] = inst_32418);

(statearr_32715[(54)] = inst_32415);

(statearr_32715[(14)] = inst_32410__$1);

(statearr_32715[(59)] = inst_32419);

(statearr_32715[(41)] = inst_32413);

(statearr_32715[(43)] = inst_32409__$1);

return statearr_32715;
})();
if(inst_32423){
var statearr_32716_32835 = state_32634__$1;
(statearr_32716_32835[(1)] = (6));

} else {
var statearr_32717_32836 = state_32634__$1;
(statearr_32717_32836[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (66))){
var inst_32573 = (state_32634[(13)]);
var inst_32575 = (state_32634[(60)]);
var inst_32565 = (state_32634[(57)]);
var inst_32572 = cljs.core.seq(inst_32565);
var inst_32573__$1 = cljs.core.first(inst_32572);
var inst_32574 = cljs.core.next(inst_32572);
var inst_32575__$1 = (inst_32573__$1 == null);
var state_32634__$1 = (function (){var statearr_32718 = state_32634;
(statearr_32718[(13)] = inst_32573__$1);

(statearr_32718[(61)] = inst_32574);

(statearr_32718[(60)] = inst_32575__$1);

return statearr_32718;
})();
if(cljs.core.truth_(inst_32575__$1)){
var statearr_32719_32837 = state_32634__$1;
(statearr_32719_32837[(1)] = (68));

} else {
var statearr_32720_32838 = state_32634__$1;
(statearr_32720_32838[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (23))){
var inst_32459 = (state_32634[(20)]);
var state_32634__$1 = state_32634;
var statearr_32721_32839 = state_32634__$1;
(statearr_32721_32839[(2)] = inst_32459);

(statearr_32721_32839[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (47))){
var state_32634__$1 = state_32634;
var statearr_32722_32840 = state_32634__$1;
(statearr_32722_32840[(2)] = fluree.db.util.core.max_long);

(statearr_32722_32840[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (35))){
var inst_32479 = (cljs.core._GT__EQ_ === start_test);
var state_32634__$1 = state_32634;
if(cljs.core.truth_(inst_32479)){
var statearr_32723_32841 = state_32634__$1;
(statearr_32723_32841[(1)] = (37));

} else {
var statearr_32724_32842 = state_32634__$1;
(statearr_32724_32842[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (82))){
var inst_32549 = (state_32634[(8)]);
var state_32634__$1 = state_32634;
var statearr_32725_32843 = state_32634__$1;
(statearr_32725_32843[(2)] = inst_32549);

(statearr_32725_32843[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (76))){
var inst_32584 = (state_32634[(23)]);
var inst_32574 = (state_32634[(61)]);
var inst_32598 = (state_32634[(2)]);
var inst_32565 = inst_32574;
var inst_32566 = inst_32584;
var inst_32567 = inst_32598;
var state_32634__$1 = (function (){var statearr_32726 = state_32634;
(statearr_32726[(22)] = inst_32566);

(statearr_32726[(57)] = inst_32565);

(statearr_32726[(52)] = inst_32567);

return statearr_32726;
})();
var statearr_32727_32844 = state_32634__$1;
(statearr_32727_32844[(2)] = null);

(statearr_32727_32844[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (19))){
var inst_32419 = (state_32634[(59)]);
var state_32634__$1 = state_32634;
var statearr_32728_32845 = state_32634__$1;
(statearr_32728_32845[(2)] = inst_32419);

(statearr_32728_32845[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (57))){
var inst_32533 = (state_32634[(11)]);
var inst_32523 = (state_32634[(37)]);
var inst_32512 = (state_32634[(42)]);
var inst_32513 = (state_32634[(45)]);
var inst_32537 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_32533,inst_32512,inst_32513,inst_32523);
var state_32634__$1 = state_32634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32634__$1,(59),inst_32537);
} else {
if((state_val_32635 === (68))){
var inst_32575 = (state_32634[(60)]);
var state_32634__$1 = state_32634;
var statearr_32729_32846 = state_32634__$1;
(statearr_32729_32846[(2)] = inst_32575);

(statearr_32729_32846[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (11))){
var inst_32417 = (state_32634[(58)]);
var state_32634__$1 = state_32634;
var statearr_32731_32847 = state_32634__$1;
(statearr_32731_32847[(2)] = inst_32417);

(statearr_32731_32847[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (9))){
var inst_32427 = (state_32634[(2)]);
var inst_32428 = fluree.db.util.async.throw_err(inst_32427);
var state_32634__$1 = state_32634;
var statearr_32732_32848 = state_32634__$1;
(statearr_32732_32848[(2)] = inst_32428);

(statearr_32732_32848[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (5))){
var _ = (function (){var statearr_32733 = state_32634;
(statearr_32733[(4)] = cljs.core.rest((state_32634[(4)])));

return statearr_32733;
})();
var state_32634__$1 = state_32634;
var ex32730 = (state_32634__$1[(2)]);
var statearr_32734_32849 = state_32634__$1;
(statearr_32734_32849[(5)] = ex32730);


if((ex32730 instanceof Error)){
var statearr_32735_32850 = state_32634__$1;
(statearr_32735_32850[(1)] = (4));

(statearr_32735_32850[(5)] = null);

} else {
throw ex32730;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (83))){
var inst_32617 = (state_32634[(2)]);
var inst_32618 = cljs.core.not(inst_32617);
var state_32634__$1 = state_32634;
if(inst_32618){
var statearr_32736_32851 = state_32634__$1;
(statearr_32736_32851[(1)] = (87));

} else {
var statearr_32737_32852 = state_32634__$1;
(statearr_32737_32852[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (14))){
var inst_32412 = (state_32634[(50)]);
var inst_32443 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_32412);
var state_32634__$1 = state_32634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32634__$1,(17),inst_32443);
} else {
if((state_val_32635 === (45))){
var inst_32492 = (state_32634[(2)]);
var state_32634__$1 = state_32634;
var statearr_32738_32853 = state_32634__$1;
(statearr_32738_32853[(2)] = inst_32492);

(statearr_32738_32853[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (53))){
var state_32634__$1 = state_32634;
var statearr_32739_32854 = state_32634__$1;
(statearr_32739_32854[(2)] = true);

(statearr_32739_32854[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (78))){
var inst_32567 = (state_32634[(52)]);
var state_32634__$1 = state_32634;
var statearr_32740_32855 = state_32634__$1;
(statearr_32740_32855[(2)] = inst_32567);

(statearr_32740_32855[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (26))){
var inst_32411 = (state_32634[(19)]);
var state_32634__$1 = state_32634;
var statearr_32741_32856 = state_32634__$1;
(statearr_32741_32856[(2)] = inst_32411);

(statearr_32741_32856[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (16))){
var inst_32419 = (state_32634[(59)]);
var inst_32449 = (state_32634[(2)]);
var inst_32450 = fluree.db.util.core.pred_ident_QMARK_(inst_32419);
var state_32634__$1 = (function (){var statearr_32742 = state_32634;
(statearr_32742[(34)] = inst_32449);

return statearr_32742;
})();
if(inst_32450){
var statearr_32743_32857 = state_32634__$1;
(statearr_32743_32857[(1)] = (18));

} else {
var statearr_32744_32858 = state_32634__$1;
(statearr_32744_32858[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (81))){
var inst_32609 = (state_32634[(48)]);
var inst_32549 = (state_32634[(8)]);
var inst_32506 = (state_32634[(32)]);
var inst_32496 = (state_32634[(16)]);
var inst_32608 = (inst_32506.cljs$core$IFn$_invoke$arity$2 ? inst_32506.cljs$core$IFn$_invoke$arity$2(inst_32549,inst_32496) : inst_32506.call(null,inst_32549,inst_32496));
var inst_32609__$1 = (inst_32608 < (0));
var state_32634__$1 = (function (){var statearr_32745 = state_32634;
(statearr_32745[(48)] = inst_32609__$1);

return statearr_32745;
})();
if(cljs.core.truth_(inst_32609__$1)){
var statearr_32746_32859 = state_32634__$1;
(statearr_32746_32859[(1)] = (84));

} else {
var statearr_32747_32860 = state_32634__$1;
(statearr_32747_32860[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (79))){
var inst_32573 = (state_32634[(13)]);
var inst_32567 = (state_32634[(52)]);
var inst_32593 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_32567,inst_32573);
var state_32634__$1 = state_32634;
var statearr_32748_32861 = state_32634__$1;
(statearr_32748_32861[(2)] = inst_32593);

(statearr_32748_32861[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (38))){
var state_32634__$1 = state_32634;
var statearr_32749_32862 = state_32634__$1;
(statearr_32749_32862[(2)] = (2147483647));

(statearr_32749_32862[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (87))){
var inst_32605 = (state_32634[(7)]);
var state_32634__$1 = state_32634;
var statearr_32750_32863 = state_32634__$1;
(statearr_32750_32863[(2)] = inst_32605);

(statearr_32750_32863[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (30))){
var inst_32472 = (state_32634[(2)]);
var state_32634__$1 = state_32634;
if(cljs.core.truth_(inst_32472)){
var statearr_32751_32864 = state_32634__$1;
(statearr_32751_32864[(1)] = (31));

} else {
var statearr_32752_32865 = state_32634__$1;
(statearr_32752_32865[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (73))){
var inst_32601 = (state_32634[(2)]);
var state_32634__$1 = state_32634;
var statearr_32753_32866 = state_32634__$1;
(statearr_32753_32866[(2)] = inst_32601);

(statearr_32753_32866[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (10))){
var inst_32417 = (state_32634[(58)]);
var inst_32434 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_32417);
var state_32634__$1 = state_32634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32634__$1,(13),inst_32434);
} else {
if((state_val_32635 === (18))){
var inst_32419 = (state_32634[(59)]);
var inst_32452 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_32419);
var state_32634__$1 = state_32634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32634__$1,(21),inst_32452);
} else {
if((state_val_32635 === (52))){
var inst_32502 = (state_32634[(33)]);
var inst_32440 = (state_32634[(35)]);
var inst_32467 = (state_32634[(36)]);
var inst_32431 = (state_32634[(38)]);
var inst_32476 = (state_32634[(44)]);
var inst_32516 = fluree.db.permissions_validate.no_filter_QMARK_(inst_32502,inst_32431,inst_32440,inst_32467,inst_32476);
var state_32634__$1 = state_32634;
var statearr_32754_32867 = state_32634__$1;
(statearr_32754_32867[(2)] = inst_32516);

(statearr_32754_32867[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (67))){
var inst_32603 = (state_32634[(2)]);
var state_32634__$1 = state_32634;
var statearr_32755_32868 = state_32634__$1;
(statearr_32755_32868[(2)] = inst_32603);

(statearr_32755_32868[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (71))){
var inst_32535 = (state_32634[(40)]);
var inst_32567 = (state_32634[(52)]);
var inst_32582 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32567,inst_32535);
var state_32634__$1 = state_32634;
var statearr_32756_32869 = state_32634__$1;
(statearr_32756_32869[(2)] = inst_32582);

(statearr_32756_32869[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (42))){
var inst_32458 = (state_32634[(21)]);
var inst_32420 = (state_32634[(24)]);
var inst_32421 = (state_32634[(25)]);
var inst_32485 = (state_32634[(26)]);
var inst_32414 = (state_32634[(27)]);
var inst_32494 = (state_32634[(30)]);
var inst_32449 = (state_32634[(34)]);
var inst_32440 = (state_32634[(35)]);
var inst_32467 = (state_32634[(36)]);
var inst_32431 = (state_32634[(38)]);
var inst_32413 = (state_32634[(41)]);
var inst_32497 = (state_32634[(49)]);
var inst_32476 = (state_32634[(44)]);
var inst_32494__$1 = (state_32634[(2)]);
var inst_32495 = fluree.db.flake.__GT_Flake(inst_32431,inst_32467,inst_32449,inst_32413,inst_32414,inst_32485);
var inst_32496 = fluree.db.flake.__GT_Flake(inst_32440,inst_32476,inst_32458,inst_32420,inst_32421,inst_32494__$1);
var inst_32497__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_32634__$1 = (function (){var statearr_32757 = state_32634;
(statearr_32757[(30)] = inst_32494__$1);

(statearr_32757[(16)] = inst_32496);

(statearr_32757[(17)] = inst_32495);

(statearr_32757[(49)] = inst_32497__$1);

return statearr_32757;
})();
if(cljs.core.truth_(inst_32497__$1)){
var statearr_32758_32870 = state_32634__$1;
(statearr_32758_32870[(1)] = (46));

} else {
var statearr_32759_32871 = state_32634__$1;
(statearr_32759_32871[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (80))){
var inst_32595 = (state_32634[(2)]);
var state_32634__$1 = state_32634;
var statearr_32760_32872 = state_32634__$1;
(statearr_32760_32872[(2)] = inst_32595);

(statearr_32760_32872[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (37))){
var state_32634__$1 = state_32634;
var statearr_32761_32873 = state_32634__$1;
(statearr_32761_32873[(2)] = fluree.db.util.core.min_integer);

(statearr_32761_32873[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (63))){
var inst_32534 = (state_32634[(31)]);
var inst_32501 = (state_32634[(39)]);
var inst_32535 = (state_32634[(40)]);
var inst_32548 = (state_32634[(12)]);
var inst_32551 = (inst_32501 - inst_32534);
var inst_32552 = fluree.db.flake.take(inst_32551,inst_32548);
var inst_32553 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32552,inst_32535);
var state_32634__$1 = state_32634;
var statearr_32762_32874 = state_32634__$1;
(statearr_32762_32874[(2)] = inst_32553);

(statearr_32762_32874[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (8))){
var inst_32417 = (state_32634[(58)]);
var inst_32431 = (state_32634[(2)]);
var inst_32432 = fluree.db.util.core.pred_ident_QMARK_(inst_32417);
var state_32634__$1 = (function (){var statearr_32763 = state_32634;
(statearr_32763[(38)] = inst_32431);

return statearr_32763;
})();
if(inst_32432){
var statearr_32764_32875 = state_32634__$1;
(statearr_32764_32875[(1)] = (10));

} else {
var statearr_32765_32876 = state_32634__$1;
(statearr_32765_32876[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (49))){
var inst_32507 = (state_32634[(51)]);
var state_32634__$1 = state_32634;
var statearr_32766_32877 = state_32634__$1;
(statearr_32766_32877[(2)] = inst_32507);

(statearr_32766_32877[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32635 === (84))){
var inst_32501 = (state_32634[(39)]);
var inst_32606 = (state_32634[(9)]);
var inst_32611 = (inst_32606 < inst_32501);
var state_32634__$1 = state_32634;
var statearr_32767_32878 = state_32634__$1;
(statearr_32767_32878[(2)] = inst_32611);

(statearr_32767_32878[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__17178__auto__ = null;
var fluree$db$query$range$state_machine__17178__auto____0 = (function (){
var statearr_32768 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32768[(0)] = fluree$db$query$range$state_machine__17178__auto__);

(statearr_32768[(1)] = (1));

return statearr_32768;
});
var fluree$db$query$range$state_machine__17178__auto____1 = (function (state_32634){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_32634);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e32769){var ex__17181__auto__ = e32769;
var statearr_32770_32879 = state_32634;
(statearr_32770_32879[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_32634[(4)]))){
var statearr_32771_32880 = state_32634;
(statearr_32771_32880[(1)] = cljs.core.first((state_32634[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32881 = state_32634;
state_32634 = G__32881;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__17178__auto__ = function(state_32634){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__17178__auto____1.call(this,state_32634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__17178__auto____0;
fluree$db$query$range$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__17178__auto____1;
return fluree$db$query$range$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_32772 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_32772[(6)] = c__17304__auto__);

return statearr_32772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_32956){
var state_val_32957 = (state_32956[(1)]);
if((state_val_32957 === (7))){
var inst_32951 = (state_32956[(2)]);
var _ = (function (){var statearr_32958 = state_32956;
(statearr_32958[(4)] = cljs.core.rest((state_32956[(4)])));

return statearr_32958;
})();
var state_32956__$1 = state_32956;
var statearr_32959_32999 = state_32956__$1;
(statearr_32959_32999[(2)] = inst_32951);

(statearr_32959_32999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (20))){
var inst_32933 = (state_32956[(2)]);
var inst_32934 = fluree.db.util.async.throw_err(inst_32933);
var state_32956__$1 = state_32956;
var statearr_32960_33000 = state_32956__$1;
(statearr_32960_33000[(2)] = inst_32934);

(statearr_32960_33000[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (1))){
var state_32956__$1 = state_32956;
var statearr_32961_33001 = state_32956__$1;
(statearr_32961_33001[(2)] = null);

(statearr_32961_33001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (4))){
var inst_32882 = (state_32956[(2)]);
var state_32956__$1 = state_32956;
var statearr_32962_33002 = state_32956__$1;
(statearr_32962_33002[(2)] = inst_32882);

(statearr_32962_33002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (15))){
var inst_32929 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_32956__$1 = state_32956;
if(cljs.core.truth_(inst_32929)){
var statearr_32963_33003 = state_32956__$1;
(statearr_32963_33003[(1)] = (17));

} else {
var statearr_32964_33004 = state_32956__$1;
(statearr_32964_33004[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (21))){
var state_32956__$1 = state_32956;
var statearr_32965_33005 = state_32956__$1;
(statearr_32965_33005[(2)] = (0));

(statearr_32965_33005[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (13))){
var inst_32921 = (state_32956[(2)]);
var state_32956__$1 = state_32956;
var statearr_32966_33006 = state_32956__$1;
(statearr_32966_33006[(2)] = inst_32921);

(statearr_32966_33006[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (22))){
var state_32956__$1 = state_32956;
var statearr_32967_33007 = state_32956__$1;
(statearr_32967_33007[(2)] = (1));

(statearr_32967_33007[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (6))){
var inst_32911 = (state_32956[(7)]);
var inst_32913 = (state_32956[(8)]);
var inst_32902 = (state_32956[(9)]);
var inst_32910 = cljs.core.seq(inst_32902);
var inst_32911__$1 = cljs.core.first(inst_32910);
var inst_32912 = cljs.core.next(inst_32910);
var inst_32913__$1 = (inst_32911__$1 == null);
var state_32956__$1 = (function (){var statearr_32968 = state_32956;
(statearr_32968[(7)] = inst_32911__$1);

(statearr_32968[(8)] = inst_32913__$1);

(statearr_32968[(10)] = inst_32912);

return statearr_32968;
})();
if(cljs.core.truth_(inst_32913__$1)){
var statearr_32969_33008 = state_32956__$1;
(statearr_32969_33008[(1)] = (8));

} else {
var statearr_32970_33009 = state_32956__$1;
(statearr_32970_33009[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (17))){
var inst_32911 = (state_32956[(7)]);
var inst_32931 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_32911);
var state_32956__$1 = state_32956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32956__$1,(20),inst_32931);
} else {
if((state_val_32957 === (3))){
var inst_32954 = (state_32956[(2)]);
var state_32956__$1 = state_32956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32956__$1,inst_32954);
} else {
if((state_val_32957 === (12))){
var inst_32904 = (state_32956[(11)]);
var inst_32919 = (inst_32904 >= subject_limit);
var state_32956__$1 = state_32956;
var statearr_32971_33010 = state_32956__$1;
(statearr_32971_33010[(2)] = inst_32919);

(statearr_32971_33010[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (2))){
var _ = (function (){var statearr_32972 = state_32956;
(statearr_32972[(4)] = cljs.core.cons((5),(state_32956[(4)])));

return statearr_32972;
})();
var inst_32895 = subject_groups;
var inst_32896 = cljs.core.seq(inst_32895);
var inst_32897 = cljs.core.first(inst_32896);
var inst_32898 = cljs.core.next(inst_32896);
var inst_32899 = flake_start;
var inst_32900 = subject_start;
var inst_32901 = cljs.core.PersistentVector.EMPTY;
var inst_32902 = inst_32895;
var inst_32903 = inst_32899;
var inst_32904 = inst_32900;
var inst_32905 = inst_32901;
var state_32956__$1 = (function (){var statearr_32973 = state_32956;
(statearr_32973[(9)] = inst_32902);

(statearr_32973[(11)] = inst_32904);

(statearr_32973[(12)] = inst_32898);

(statearr_32973[(13)] = inst_32897);

(statearr_32973[(14)] = inst_32905);

(statearr_32973[(15)] = inst_32903);

return statearr_32973;
})();
var statearr_32974_33011 = state_32956__$1;
(statearr_32974_33011[(2)] = null);

(statearr_32974_33011[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (23))){
var inst_32938 = (state_32956[(16)]);
var inst_32904 = (state_32956[(11)]);
var inst_32912 = (state_32956[(10)]);
var inst_32937 = (state_32956[(17)]);
var inst_32905 = (state_32956[(14)]);
var inst_32903 = (state_32956[(15)]);
var inst_32943 = (state_32956[(2)]);
var inst_32944 = (inst_32903 + inst_32938);
var inst_32945 = (inst_32904 + inst_32943);
var inst_32946 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32905,inst_32937);
var inst_32902 = inst_32912;
var inst_32903__$1 = inst_32944;
var inst_32904__$1 = inst_32945;
var inst_32905__$1 = inst_32946;
var state_32956__$1 = (function (){var statearr_32975 = state_32956;
(statearr_32975[(9)] = inst_32902);

(statearr_32975[(11)] = inst_32904__$1);

(statearr_32975[(14)] = inst_32905__$1);

(statearr_32975[(15)] = inst_32903__$1);

return statearr_32975;
})();
var statearr_32976_33012 = state_32956__$1;
(statearr_32976_33012[(2)] = null);

(statearr_32976_33012[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (19))){
var inst_32938 = (state_32956[(16)]);
var inst_32937 = (state_32956[(17)]);
var inst_32937__$1 = (state_32956[(2)]);
var inst_32938__$1 = cljs.core.count(inst_32937__$1);
var inst_32939 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_32938__$1);
var state_32956__$1 = (function (){var statearr_32977 = state_32956;
(statearr_32977[(16)] = inst_32938__$1);

(statearr_32977[(17)] = inst_32937__$1);

return statearr_32977;
})();
if(inst_32939){
var statearr_32978_33013 = state_32956__$1;
(statearr_32978_33013[(1)] = (21));

} else {
var statearr_32979_33014 = state_32956__$1;
(statearr_32979_33014[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (11))){
var inst_32916 = (state_32956[(18)]);
var state_32956__$1 = state_32956;
var statearr_32981_33015 = state_32956__$1;
(statearr_32981_33015[(2)] = inst_32916);

(statearr_32981_33015[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (9))){
var inst_32916 = (state_32956[(18)]);
var inst_32903 = (state_32956[(15)]);
var inst_32916__$1 = (inst_32903 >= flake_limit);
var state_32956__$1 = (function (){var statearr_32982 = state_32956;
(statearr_32982[(18)] = inst_32916__$1);

return statearr_32982;
})();
if(cljs.core.truth_(inst_32916__$1)){
var statearr_32983_33016 = state_32956__$1;
(statearr_32983_33016[(1)] = (11));

} else {
var statearr_32984_33017 = state_32956__$1;
(statearr_32984_33017[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (5))){
var _ = (function (){var statearr_32985 = state_32956;
(statearr_32985[(4)] = cljs.core.rest((state_32956[(4)])));

return statearr_32985;
})();
var state_32956__$1 = state_32956;
var ex32980 = (state_32956__$1[(2)]);
var statearr_32986_33018 = state_32956__$1;
(statearr_32986_33018[(5)] = ex32980);


if((ex32980 instanceof Error)){
var statearr_32987_33019 = state_32956__$1;
(statearr_32987_33019[(1)] = (4));

(statearr_32987_33019[(5)] = null);

} else {
throw ex32980;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (14))){
var inst_32904 = (state_32956[(11)]);
var inst_32905 = (state_32956[(14)]);
var inst_32903 = (state_32956[(15)]);
var inst_32925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32926 = [inst_32903,inst_32904,inst_32905];
var inst_32927 = (new cljs.core.PersistentVector(null,3,(5),inst_32925,inst_32926,null));
var state_32956__$1 = state_32956;
var statearr_32988_33020 = state_32956__$1;
(statearr_32988_33020[(2)] = inst_32927);

(statearr_32988_33020[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (16))){
var inst_32949 = (state_32956[(2)]);
var state_32956__$1 = state_32956;
var statearr_32989_33021 = state_32956__$1;
(statearr_32989_33021[(2)] = inst_32949);

(statearr_32989_33021[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (10))){
var inst_32923 = (state_32956[(2)]);
var state_32956__$1 = state_32956;
if(cljs.core.truth_(inst_32923)){
var statearr_32990_33022 = state_32956__$1;
(statearr_32990_33022[(1)] = (14));

} else {
var statearr_32991_33023 = state_32956__$1;
(statearr_32991_33023[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (18))){
var inst_32911 = (state_32956[(7)]);
var state_32956__$1 = state_32956;
var statearr_32992_33024 = state_32956__$1;
(statearr_32992_33024[(2)] = inst_32911);

(statearr_32992_33024[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32957 === (8))){
var inst_32913 = (state_32956[(8)]);
var state_32956__$1 = state_32956;
var statearr_32993_33025 = state_32956__$1;
(statearr_32993_33025[(2)] = inst_32913);

(statearr_32993_33025[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__17178__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__17178__auto____0 = (function (){
var statearr_32994 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32994[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__17178__auto__);

(statearr_32994[(1)] = (1));

return statearr_32994;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__17178__auto____1 = (function (state_32956){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_32956);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e32995){var ex__17181__auto__ = e32995;
var statearr_32996_33026 = state_32956;
(statearr_32996_33026[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_32956[(4)]))){
var statearr_32997_33027 = state_32956;
(statearr_32997_33027[(1)] = cljs.core.first((state_32956[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33028 = state_32956;
state_32956 = G__33028;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__17178__auto__ = function(state_32956){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__17178__auto____1.call(this,state_32956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__17178__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__17178__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_32998 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_32998[(6)] = c__17304__auto__);

return statearr_32998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_33074){
var state_val_33075 = (state_33074[(1)]);
if((state_val_33075 === (7))){
var state_33074__$1 = state_33074;
var statearr_33076_33114 = state_33074__$1;
(statearr_33076_33114[(2)] = null);

(statearr_33076_33114[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (20))){
var inst_33060 = (state_33074[(2)]);
var inst_33061 = fluree.db.util.async.throw_err(inst_33060);
var inst_33039 = inst_33061;
var state_33074__$1 = (function (){var statearr_33077 = state_33074;
(statearr_33077[(7)] = inst_33039);

return statearr_33077;
})();
var statearr_33078_33115 = state_33074__$1;
(statearr_33078_33115[(2)] = null);

(statearr_33078_33115[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (1))){
var state_33074__$1 = state_33074;
var statearr_33079_33116 = state_33074__$1;
(statearr_33079_33116[(2)] = null);

(statearr_33079_33116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (4))){
var inst_33029 = (state_33074[(2)]);
var state_33074__$1 = state_33074;
var statearr_33080_33117 = state_33074__$1;
(statearr_33080_33117[(2)] = inst_33029);

(statearr_33080_33117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (15))){
var inst_33056 = (state_33074[(8)]);
var inst_33039 = (state_33074[(7)]);
var inst_33056__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_33039);
var state_33074__$1 = (function (){var statearr_33081 = state_33074;
(statearr_33081[(8)] = inst_33056__$1);

return statearr_33081;
})();
if(cljs.core.truth_(inst_33056__$1)){
var statearr_33082_33118 = state_33074__$1;
(statearr_33082_33118[(1)] = (17));

} else {
var statearr_33083_33119 = state_33074__$1;
(statearr_33083_33119[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (13))){
var inst_33049 = (state_33074[(2)]);
var inst_33050 = fluree.db.util.async.throw_err(inst_33049);
var _ = (function (){var statearr_33084 = state_33074;
(statearr_33084[(4)] = cljs.core.rest((state_33074[(4)])));

return statearr_33084;
})();
var state_33074__$1 = state_33074;
var statearr_33085_33120 = state_33074__$1;
(statearr_33085_33120[(2)] = inst_33050);

(statearr_33085_33120[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (6))){
var inst_33037 = (state_33074[(2)]);
var inst_33038 = fluree.db.util.async.throw_err(inst_33037);
var inst_33039 = inst_33038;
var state_33074__$1 = (function (){var statearr_33086 = state_33074;
(statearr_33086[(7)] = inst_33039);

return statearr_33086;
})();
var statearr_33087_33121 = state_33074__$1;
(statearr_33087_33121[(2)] = null);

(statearr_33087_33121[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (17))){
var inst_33056 = (state_33074[(8)]);
var inst_33058 = fluree.db.dbproto._lookup_leaf(root_node,inst_33056);
var state_33074__$1 = state_33074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33074__$1,(20),inst_33058);
} else {
if((state_val_33075 === (3))){
var inst_33072 = (state_33074[(2)]);
var state_33074__$1 = state_33074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33074__$1,inst_33072);
} else {
if((state_val_33075 === (12))){
var _ = (function (){var statearr_33089 = state_33074;
(statearr_33089[(4)] = cljs.core.rest((state_33074[(4)])));

return statearr_33089;
})();
var state_33074__$1 = state_33074;
var ex33088 = (state_33074__$1[(2)]);
var statearr_33090_33122 = state_33074__$1;
(statearr_33090_33122[(5)] = ex33088);


var statearr_33091_33123 = state_33074__$1;
(statearr_33091_33123[(1)] = (11));

(statearr_33091_33123[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (2))){
var _ = (function (){var statearr_33092 = state_33074;
(statearr_33092[(4)] = cljs.core.cons((5),(state_33074[(4)])));

return statearr_33092;
})();
var inst_33035 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_33074__$1 = state_33074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33074__$1,(6),inst_33035);
} else {
if((state_val_33075 === (19))){
var inst_33065 = (state_33074[(2)]);
var state_33074__$1 = state_33074;
var statearr_33093_33124 = state_33074__$1;
(statearr_33093_33124[(2)] = inst_33065);

(statearr_33093_33124[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (11))){
var inst_33041 = (state_33074[(2)]);
var state_33074__$1 = (function (){var statearr_33095 = state_33074;
(statearr_33095[(9)] = inst_33041);

return statearr_33095;
})();
var statearr_33096_33125 = state_33074__$1;
(statearr_33096_33125[(2)] = null);

(statearr_33096_33125[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (9))){
var inst_33039 = (state_33074[(7)]);
var _ = (function (){var statearr_33097 = state_33074;
(statearr_33097[(4)] = cljs.core.cons((12),(state_33074[(4)])));

return statearr_33097;
})();
var inst_33047 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_33039,t,novelty,fast_forward_db_QMARK_);
var state_33074__$1 = state_33074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33074__$1,(13),inst_33047);
} else {
if((state_val_33075 === (5))){
var _ = (function (){var statearr_33098 = state_33074;
(statearr_33098[(4)] = cljs.core.rest((state_33074[(4)])));

return statearr_33098;
})();
var state_33074__$1 = state_33074;
var ex33094 = (state_33074__$1[(2)]);
var statearr_33099_33126 = state_33074__$1;
(statearr_33099_33126[(5)] = ex33094);


if((ex33094 instanceof Error)){
var statearr_33100_33127 = state_33074__$1;
(statearr_33100_33127[(1)] = (4));

(statearr_33100_33127[(5)] = null);

} else {
throw ex33094;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (14))){
var inst_33053 = (state_33074[(10)]);
var state_33074__$1 = state_33074;
var statearr_33101_33128 = state_33074__$1;
(statearr_33101_33128[(2)] = inst_33053);

(statearr_33101_33128[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (16))){
var inst_33067 = (state_33074[(2)]);
var state_33074__$1 = state_33074;
var statearr_33102_33129 = state_33074__$1;
(statearr_33102_33129[(2)] = inst_33067);

(statearr_33102_33129[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (10))){
var inst_33053 = (state_33074[(10)]);
var inst_33053__$1 = (state_33074[(2)]);
var state_33074__$1 = (function (){var statearr_33103 = state_33074;
(statearr_33103[(10)] = inst_33053__$1);

return statearr_33103;
})();
if(cljs.core.truth_(inst_33053__$1)){
var statearr_33104_33130 = state_33074__$1;
(statearr_33104_33130[(1)] = (14));

} else {
var statearr_33105_33131 = state_33074__$1;
(statearr_33105_33131[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (18))){
var state_33074__$1 = state_33074;
var statearr_33106_33132 = state_33074__$1;
(statearr_33106_33132[(2)] = null);

(statearr_33106_33132[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33075 === (8))){
var inst_33069 = (state_33074[(2)]);
var _ = (function (){var statearr_33107 = state_33074;
(statearr_33107[(4)] = cljs.core.rest((state_33074[(4)])));

return statearr_33107;
})();
var state_33074__$1 = state_33074;
var statearr_33108_33133 = state_33074__$1;
(statearr_33108_33133[(2)] = inst_33069);

(statearr_33108_33133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__17178__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__17178__auto____0 = (function (){
var statearr_33109 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33109[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__17178__auto__);

(statearr_33109[(1)] = (1));

return statearr_33109;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__17178__auto____1 = (function (state_33074){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_33074);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e33110){var ex__17181__auto__ = e33110;
var statearr_33111_33134 = state_33074;
(statearr_33111_33134[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_33074[(4)]))){
var statearr_33112_33135 = state_33074;
(statearr_33112_33135[(1)] = cljs.core.first((state_33074[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33136 = state_33074;
state_33074 = G__33136;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__17178__auto__ = function(state_33074){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__17178__auto____1.call(this,state_33074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__17178__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__17178__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_33113 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_33113[(6)] = c__17304__auto__);

return statearr_33113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__33143 = arguments.length;
switch (G__33143) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__33144 = (function (){var pred__33147 = cljs.core.identical_QMARK_;
var expr__33148 = test;
if(cljs.core.truth_((pred__33147.cljs$core$IFn$_invoke$arity$2 ? pred__33147.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__33148) : pred__33147.call(null,cljs.core._EQ_,expr__33148)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__33147.cljs$core$IFn$_invoke$arity$2 ? pred__33147.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__33148) : pred__33147.call(null,cljs.core._LT_,expr__33148)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__33147.cljs$core$IFn$_invoke$arity$2 ? pred__33147.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__33148) : pred__33147.call(null,cljs.core._LT__EQ_,expr__33148)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__33147.cljs$core$IFn$_invoke$arity$2 ? pred__33147.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__33148) : pred__33147.call(null,cljs.core._GT_,expr__33148)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__33147.cljs$core$IFn$_invoke$arity$2 ? pred__33147.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__33148) : pred__33147.call(null,cljs.core._GT__EQ_,expr__33148)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__33148)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33144,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33144,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33144,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33144,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_33520){
var state_val_33521 = (state_33520[(1)]);
if((state_val_33521 === (121))){
var inst_33476 = (state_33520[(7)]);
var state_33520__$1 = state_33520;
var statearr_33522_33718 = state_33520__$1;
(statearr_33522_33718[(2)] = inst_33476);

(statearr_33522_33718[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (65))){
var inst_33328 = (state_33520[(8)]);
var inst_33334 = (state_33520[(2)]);
var state_33520__$1 = (function (){var statearr_33523 = state_33520;
(statearr_33523[(9)] = inst_33334);

return statearr_33523;
})();
if(cljs.core.truth_(inst_33328)){
var statearr_33524_33719 = state_33520__$1;
(statearr_33524_33719[(1)] = (66));

} else {
var statearr_33525_33720 = state_33520__$1;
(statearr_33525_33720[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (70))){
var inst_33512 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33526_33721 = state_33520__$1;
(statearr_33526_33721[(2)] = inst_33512);

(statearr_33526_33721[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (62))){
var inst_33327 = (state_33520[(2)]);
var inst_33328 = fluree.db.util.async.throw_err(inst_33327);
var inst_33329 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_33520__$1 = (function (){var statearr_33527 = state_33520;
(statearr_33527[(8)] = inst_33328);

return statearr_33527;
})();
if(cljs.core.truth_(inst_33329)){
var statearr_33528_33722 = state_33520__$1;
(statearr_33528_33722[(1)] = (63));

} else {
var statearr_33529_33723 = state_33520__$1;
(statearr_33529_33723[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (74))){
var inst_33298 = (state_33520[(10)]);
var inst_33328 = (state_33520[(8)]);
var inst_33337 = (state_33520[(11)]);
var inst_33334 = (state_33520[(9)]);
var inst_33313 = (state_33520[(12)]);
var inst_33269 = (state_33520[(13)]);
var inst_33308 = (state_33520[(14)]);
var inst_33309 = (state_33520[(15)]);
var inst_33177 = (state_33520[(16)]);
var inst_33251 = (state_33520[(17)]);
var inst_33287 = (state_33520[(18)]);
var inst_33347 = (state_33520[(19)]);
var inst_33318 = (state_33520[(20)]);
var inst_33319 = (state_33520[(21)]);
var inst_33197 = (state_33520[(22)]);
var inst_33297 = (state_33520[(23)]);
var inst_33341 = (state_33520[(24)]);
var inst_33307 = (state_33520[(25)]);
var inst_33324 = (state_33520[(26)]);
var inst_33186 = (state_33520[(27)]);
var inst_33238 = (state_33520[(28)]);
var inst_33170 = (state_33520[(29)]);
var inst_33355 = (state_33520[(30)]);
var inst_33187 = (state_33520[(31)]);
var inst_33182 = (state_33520[(32)]);
var inst_33181 = (state_33520[(33)]);
var inst_33174 = (state_33520[(34)]);
var inst_33260 = (state_33520[(35)]);
var inst_33338 = (state_33520[(36)]);
var inst_33278 = (state_33520[(37)]);
var inst_33175 = (state_33520[(38)]);
var inst_33296 = (state_33520[(39)]);
var inst_33340 = (state_33520[(40)]);
var inst_33239 = (state_33520[(41)]);
var inst_33300 = (state_33520[(42)]);
var inst_33339 = (state_33520[(43)]);
var inst_33301 = (state_33520[(44)]);
var inst_33185 = (state_33520[(45)]);
var inst_33206 = (state_33520[(46)]);
var inst_33314 = (state_33520[(47)]);
var inst_33242 = (state_33520[(48)]);
var inst_33357 = (function (){var no_filter_QMARK_ = inst_33334;
var t = inst_33314;
var max_limit_QMARK_ = inst_33308;
var map__33169 = inst_33300;
var next_node = inst_33337;
var fast_forward_db_QMARK_ = inst_33319;
var s1 = inst_33197;
var o2 = inst_33260;
var t1 = inst_33174;
var predicate_fn = inst_33187;
var i = inst_33339;
var m1 = inst_33287;
var root_node = inst_33324;
var s2 = inst_33206;
var vec__33159 = inst_33177;
var vec__33156 = inst_33170;
var p2 = inst_33278;
var vec__33166 = inst_33239;
var permissions = inst_33309;
var limit = inst_33307;
var start_flake = inst_33297;
var flake_limit = inst_33301;
var offset = inst_33338;
var acc = inst_33341;
var t2 = inst_33181;
var op1 = inst_33175;
var o1 = inst_33251;
var end_flake = inst_33298;
var base_result = inst_33347;
var s = inst_33340;
var node_start = inst_33328;
var map__33162 = inst_33185;
var p1 = inst_33269;
var subject_fn = inst_33186;
var vec__33163 = inst_33238;
var object_fn = inst_33242;
var idx_compare = inst_33313;
var op2 = inst_33182;
var m2 = inst_33296;
var G__33348 = inst_33355;
var novelty = inst_33318;
return (function (p1__33138_SHARP_){
var G__33530 = p1__33138_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__33530) : subject_fn.call(null,G__33530));
});
})();
var inst_33358 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_33357,inst_33355);
var state_33520__$1 = state_33520;
var statearr_33531_33724 = state_33520__$1;
(statearr_33531_33724[(2)] = inst_33358);

(statearr_33531_33724[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (110))){
var inst_33489 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33532_33725 = state_33520__$1;
(statearr_33532_33725[(2)] = inst_33489);

(statearr_33532_33725[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (7))){
var inst_33171 = (state_33520[(49)]);
var state_33520__$1 = state_33520;
var statearr_33533_33726 = state_33520__$1;
(statearr_33533_33726[(2)] = inst_33171);

(statearr_33533_33726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (59))){
var state_33520__$1 = state_33520;
var statearr_33534_33727 = state_33520__$1;
(statearr_33534_33727[(2)] = fluree.db.util.core.max_long);

(statearr_33534_33727[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (86))){
var inst_33334 = (state_33520[(9)]);
var state_33520__$1 = state_33520;
var statearr_33535_33728 = state_33520__$1;
(statearr_33535_33728[(2)] = inst_33334);

(statearr_33535_33728[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (20))){
var state_33520__$1 = state_33520;
var statearr_33536_33729 = state_33520__$1;
(statearr_33536_33729[(2)] = null);

(statearr_33536_33729[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (72))){
var inst_33347 = (state_33520[(19)]);
var state_33520__$1 = state_33520;
var statearr_33537_33730 = state_33520__$1;
(statearr_33537_33730[(2)] = inst_33347);

(statearr_33537_33730[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (58))){
var inst_33302 = (state_33520[(50)]);
var state_33520__$1 = state_33520;
var statearr_33538_33731 = state_33520__$1;
(statearr_33538_33731[(2)] = inst_33302);

(statearr_33538_33731[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (60))){
var inst_33307 = (state_33520[(25)]);
var inst_33307__$1 = (state_33520[(2)]);
var inst_33308 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33307__$1,fluree.db.util.core.max_long);
var inst_33309 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_33310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33311 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_33312 = (new cljs.core.PersistentVector(null,3,(5),inst_33310,inst_33311,null));
var inst_33313 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_33312);
var inst_33314 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_33315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33316 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_33317 = (new cljs.core.PersistentVector(null,2,(5),inst_33315,inst_33316,null));
var inst_33318 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_33317);
var inst_33319 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_33320 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_33321 = fluree.db.dbproto._resolve(inst_33320);
var state_33520__$1 = (function (){var statearr_33539 = state_33520;
(statearr_33539[(12)] = inst_33313);

(statearr_33539[(14)] = inst_33308);

(statearr_33539[(15)] = inst_33309);

(statearr_33539[(20)] = inst_33318);

(statearr_33539[(21)] = inst_33319);

(statearr_33539[(25)] = inst_33307__$1);

(statearr_33539[(47)] = inst_33314);

return statearr_33539;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33520__$1,(61),inst_33321);
} else {
if((state_val_33521 === (27))){
var inst_33240 = (state_33520[(51)]);
var state_33520__$1 = state_33520;
var statearr_33540_33732 = state_33520__$1;
(statearr_33540_33732[(2)] = inst_33240);

(statearr_33540_33732[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (1))){
var state_33520__$1 = state_33520;
var statearr_33541_33733 = state_33520__$1;
(statearr_33541_33733[(2)] = null);

(statearr_33541_33733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (69))){
var inst_33298 = (state_33520[(10)]);
var inst_33337 = (state_33520[(11)]);
var inst_33297 = (state_33520[(23)]);
var inst_33346 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_33337);
var inst_33347 = fluree.db.flake.subrange(inst_33346,start_test,inst_33297,end_test,inst_33298);
var inst_33349 = fluree.db.query.range.value_with_nil_pred(idx,inst_33297,inst_33298);
var state_33520__$1 = (function (){var statearr_33542 = state_33520;
(statearr_33542[(19)] = inst_33347);

return statearr_33542;
})();
if(inst_33349){
var statearr_33543_33734 = state_33520__$1;
(statearr_33543_33734[(1)] = (71));

} else {
var statearr_33544_33735 = state_33520__$1;
(statearr_33544_33735[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (101))){
var inst_33433 = (state_33520[(52)]);
var inst_33435 = (state_33520[(53)]);
var inst_33434 = (state_33520[(54)]);
var inst_33301 = (state_33520[(44)]);
var inst_33438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33439 = (inst_33435 - inst_33301);
var inst_33440 = (inst_33434 - inst_33439);
var inst_33441 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_33440,inst_33433);
var inst_33442 = [inst_33301,inst_33441];
var inst_33443 = (new cljs.core.PersistentVector(null,2,(5),inst_33438,inst_33442,null));
var state_33520__$1 = state_33520;
var statearr_33545_33736 = state_33520__$1;
(statearr_33545_33736[(2)] = inst_33443);

(statearr_33545_33736[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (24))){
var inst_33183 = (state_33520[(55)]);
var inst_33173 = (state_33520[(56)]);
var inst_33177 = (state_33520[(16)]);
var inst_33172 = (state_33520[(57)]);
var inst_33179 = (state_33520[(58)]);
var inst_33197 = (state_33520[(22)]);
var inst_33176 = (state_33520[(59)]);
var inst_33186 = (state_33520[(27)]);
var inst_33170 = (state_33520[(29)]);
var inst_33187 = (state_33520[(31)]);
var inst_33182 = (state_33520[(32)]);
var inst_33181 = (state_33520[(33)]);
var inst_33174 = (state_33520[(34)]);
var inst_33175 = (state_33520[(38)]);
var inst_33220 = (state_33520[(60)]);
var inst_33188 = (state_33520[(61)]);
var inst_33180 = (state_33520[(62)]);
var inst_33185 = (state_33520[(45)]);
var inst_33206 = (state_33520[(46)]);
var inst_33230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33232 = [null,null];
var inst_33233 = (new cljs.core.PersistentVector(null,2,(5),inst_33231,inst_33232,null));
var inst_33234 = (function (){var bool = inst_33220;
var s1 = inst_33197;
var o2 = inst_33180;
var t1 = inst_33174;
var predicate_fn = inst_33187;
var m1 = inst_33176;
var s2 = inst_33206;
var vec__33159 = inst_33177;
var vec__33156 = inst_33170;
var p2 = inst_33179;
var t2 = inst_33181;
var op1 = inst_33175;
var o1 = inst_33173;
var map__33162 = inst_33185;
var p1 = inst_33172;
var subject_fn = inst_33186;
var object_fn = inst_33188;
var op2 = inst_33182;
var m2 = inst_33183;
var temp__5755__auto__ = inst_33220;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_33235 = [inst_33233,inst_33234];
var inst_33236 = (new cljs.core.PersistentVector(null,2,(5),inst_33230,inst_33235,null));
var state_33520__$1 = state_33520;
var statearr_33546_33737 = state_33520__$1;
(statearr_33546_33737[(2)] = inst_33236);

(statearr_33546_33737[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (102))){
var inst_33433 = (state_33520[(52)]);
var inst_33435 = (state_33520[(53)]);
var inst_33445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33446 = [inst_33435,inst_33433];
var inst_33447 = (new cljs.core.PersistentVector(null,2,(5),inst_33445,inst_33446,null));
var state_33520__$1 = state_33520;
var statearr_33547_33738 = state_33520__$1;
(statearr_33547_33738[(2)] = inst_33447);

(statearr_33547_33738[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (55))){
var state_33520__$1 = state_33520;
var statearr_33548_33739 = state_33520__$1;
(statearr_33548_33739[(2)] = (2147483647));

(statearr_33548_33739[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (85))){
var inst_33383 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
if(cljs.core.truth_(inst_33383)){
var statearr_33549_33740 = state_33520__$1;
(statearr_33549_33740[(1)] = (89));

} else {
var statearr_33550_33741 = state_33520__$1;
(statearr_33550_33741[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (39))){
var inst_33270 = (state_33520[(63)]);
var inst_33179 = (state_33520[(58)]);
var inst_33269 = (state_33520[(2)]);
var inst_33270__$1 = (inst_33179 == null);
var state_33520__$1 = (function (){var statearr_33551 = state_33520;
(statearr_33551[(13)] = inst_33269);

(statearr_33551[(63)] = inst_33270__$1);

return statearr_33551;
})();
if(cljs.core.truth_(inst_33270__$1)){
var statearr_33552_33742 = state_33520__$1;
(statearr_33552_33742[(1)] = (40));

} else {
var statearr_33553_33743 = state_33520__$1;
(statearr_33553_33743[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (88))){
var inst_33380 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33554_33744 = state_33520__$1;
(statearr_33554_33744[(2)] = inst_33380);

(statearr_33554_33744[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (46))){
var inst_33176 = (state_33520[(59)]);
var state_33520__$1 = state_33520;
var statearr_33555_33745 = state_33520__$1;
(statearr_33555_33745[(2)] = inst_33176);

(statearr_33555_33745[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (4))){
var inst_33150 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33556_33746 = state_33520__$1;
(statearr_33556_33746[(2)] = inst_33150);

(statearr_33556_33746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (77))){
var inst_33298 = (state_33520[(10)]);
var inst_33328 = (state_33520[(8)]);
var inst_33337 = (state_33520[(11)]);
var inst_33334 = (state_33520[(9)]);
var inst_33313 = (state_33520[(12)]);
var inst_33269 = (state_33520[(13)]);
var inst_33308 = (state_33520[(14)]);
var inst_33309 = (state_33520[(15)]);
var inst_33177 = (state_33520[(16)]);
var inst_33251 = (state_33520[(17)]);
var inst_33287 = (state_33520[(18)]);
var inst_33347 = (state_33520[(19)]);
var inst_33318 = (state_33520[(20)]);
var inst_33319 = (state_33520[(21)]);
var inst_33197 = (state_33520[(22)]);
var inst_33297 = (state_33520[(23)]);
var inst_33341 = (state_33520[(24)]);
var inst_33307 = (state_33520[(25)]);
var inst_33324 = (state_33520[(26)]);
var inst_33186 = (state_33520[(27)]);
var inst_33238 = (state_33520[(28)]);
var inst_33170 = (state_33520[(29)]);
var inst_33187 = (state_33520[(31)]);
var inst_33182 = (state_33520[(32)]);
var inst_33181 = (state_33520[(33)]);
var inst_33361 = (state_33520[(64)]);
var inst_33174 = (state_33520[(34)]);
var inst_33260 = (state_33520[(35)]);
var inst_33338 = (state_33520[(36)]);
var inst_33278 = (state_33520[(37)]);
var inst_33175 = (state_33520[(38)]);
var inst_33296 = (state_33520[(39)]);
var inst_33340 = (state_33520[(40)]);
var inst_33239 = (state_33520[(41)]);
var inst_33300 = (state_33520[(42)]);
var inst_33339 = (state_33520[(43)]);
var inst_33301 = (state_33520[(44)]);
var inst_33185 = (state_33520[(45)]);
var inst_33206 = (state_33520[(46)]);
var inst_33314 = (state_33520[(47)]);
var inst_33242 = (state_33520[(48)]);
var inst_33363 = (function (){var no_filter_QMARK_ = inst_33334;
var t = inst_33314;
var max_limit_QMARK_ = inst_33308;
var map__33169 = inst_33300;
var next_node = inst_33337;
var fast_forward_db_QMARK_ = inst_33319;
var s1 = inst_33197;
var o2 = inst_33260;
var t1 = inst_33174;
var predicate_fn = inst_33187;
var i = inst_33339;
var m1 = inst_33287;
var root_node = inst_33324;
var s2 = inst_33206;
var vec__33159 = inst_33177;
var vec__33156 = inst_33170;
var p2 = inst_33278;
var vec__33166 = inst_33239;
var permissions = inst_33309;
var limit = inst_33307;
var start_flake = inst_33297;
var flake_limit = inst_33301;
var offset = inst_33338;
var acc = inst_33341;
var t2 = inst_33181;
var op1 = inst_33175;
var o1 = inst_33251;
var end_flake = inst_33298;
var base_result = inst_33347;
var s = inst_33340;
var node_start = inst_33328;
var map__33162 = inst_33185;
var p1 = inst_33269;
var subject_fn = inst_33186;
var vec__33163 = inst_33238;
var object_fn = inst_33242;
var idx_compare = inst_33313;
var op2 = inst_33182;
var m2 = inst_33296;
var G__33348 = inst_33361;
var novelty = inst_33318;
return (function (p1__33139_SHARP_){
var G__33557 = p1__33139_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__33557) : predicate_fn.call(null,G__33557));
});
})();
var inst_33364 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_33363,inst_33361);
var state_33520__$1 = state_33520;
var statearr_33558_33747 = state_33520__$1;
(statearr_33558_33747[(2)] = inst_33364);

(statearr_33558_33747[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (106))){
var inst_33374 = (state_33520[(65)]);
var state_33520__$1 = state_33520;
var statearr_33559_33748 = state_33520__$1;
(statearr_33559_33748[(2)] = inst_33374);

(statearr_33559_33748[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (119))){
var inst_33492 = (state_33520[(66)]);
var state_33520__$1 = state_33520;
var statearr_33560_33749 = state_33520__$1;
(statearr_33560_33749[(2)] = inst_33492);

(statearr_33560_33749[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (95))){
var inst_33307 = (state_33520[(25)]);
var inst_33407 = (state_33520[(67)]);
var inst_33417 = (state_33520[(68)]);
var inst_33340 = (state_33520[(40)]);
var inst_33416 = (state_33520[(69)]);
var inst_33415 = (state_33520[(70)]);
var inst_33415__$1 = cljs.core.count(inst_33407);
var inst_33416__$1 = (inst_33340 + inst_33415__$1);
var inst_33417__$1 = (inst_33416__$1 - inst_33307);
var inst_33418 = cljs.core.pos_int_QMARK_(inst_33417__$1);
var state_33520__$1 = (function (){var statearr_33561 = state_33520;
(statearr_33561[(68)] = inst_33417__$1);

(statearr_33561[(69)] = inst_33416__$1);

(statearr_33561[(70)] = inst_33415__$1);

return statearr_33561;
})();
if(inst_33418){
var statearr_33562_33750 = state_33520__$1;
(statearr_33562_33750[(1)] = (98));

} else {
var statearr_33563_33751 = state_33520__$1;
(statearr_33563_33751[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (54))){
var inst_33302 = (state_33520[(50)]);
var inst_33269 = (state_33520[(13)]);
var inst_33251 = (state_33520[(17)]);
var inst_33287 = (state_33520[(18)]);
var inst_33197 = (state_33520[(22)]);
var inst_33182 = (state_33520[(32)]);
var inst_33181 = (state_33520[(33)]);
var inst_33174 = (state_33520[(34)]);
var inst_33260 = (state_33520[(35)]);
var inst_33278 = (state_33520[(37)]);
var inst_33175 = (state_33520[(38)]);
var inst_33296 = (state_33520[(39)]);
var inst_33300 = (state_33520[(42)]);
var inst_33206 = (state_33520[(46)]);
var inst_33296__$1 = (state_33520[(2)]);
var inst_33297 = fluree.db.flake.__GT_Flake(inst_33197,inst_33269,inst_33251,inst_33174,inst_33175,inst_33287);
var inst_33298 = fluree.db.flake.__GT_Flake(inst_33206,inst_33278,inst_33260,inst_33181,inst_33182,inst_33296__$1);
var inst_33299 = opts;
var inst_33300__$1 = cljs.core.__destructure_map(inst_33299);
var inst_33301 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_33300__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_33302__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33300__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_33303 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_33300__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_33520__$1 = (function (){var statearr_33564 = state_33520;
(statearr_33564[(10)] = inst_33298);

(statearr_33564[(50)] = inst_33302__$1);

(statearr_33564[(23)] = inst_33297);

(statearr_33564[(39)] = inst_33296__$1);

(statearr_33564[(42)] = inst_33300__$1);

(statearr_33564[(71)] = inst_33303);

(statearr_33564[(44)] = inst_33301);

return statearr_33564;
})();
if(cljs.core.truth_(inst_33302__$1)){
var statearr_33565_33752 = state_33520__$1;
(statearr_33565_33752[(1)] = (58));

} else {
var statearr_33566_33753 = state_33520__$1;
(statearr_33566_33753[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (92))){
var inst_33396 = (state_33520[(72)]);
var inst_33341 = (state_33520[(24)]);
var inst_33338 = (state_33520[(36)]);
var inst_33340 = (state_33520[(40)]);
var inst_33339 = (state_33520[(43)]);
var inst_33399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33400 = (inst_33338 - inst_33396);
var inst_33401 = [inst_33400,inst_33339,inst_33340,inst_33341];
var inst_33402 = (new cljs.core.PersistentVector(null,4,(5),inst_33399,inst_33401,null));
var state_33520__$1 = state_33520;
var statearr_33567_33754 = state_33520__$1;
(statearr_33567_33754[(2)] = inst_33402);

(statearr_33567_33754[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (104))){
var inst_33458 = (state_33520[(2)]);
var inst_33459 = fluree.db.util.async.throw_err(inst_33458);
var state_33520__$1 = state_33520;
var statearr_33568_33755 = state_33520__$1;
(statearr_33568_33755[(2)] = inst_33459);

(statearr_33568_33755[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (15))){
var inst_33180 = (state_33520[(62)]);
var inst_33210 = cljs.core.boolean_QMARK_(inst_33180);
var state_33520__$1 = state_33520;
if(inst_33210){
var statearr_33569_33756 = state_33520__$1;
(statearr_33569_33756[(1)] = (17));

} else {
var statearr_33570_33757 = state_33520__$1;
(statearr_33570_33757[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (48))){
var inst_33183 = (state_33520[(55)]);
var inst_33287 = (state_33520[(2)]);
var state_33520__$1 = (function (){var statearr_33571 = state_33520;
(statearr_33571[(18)] = inst_33287);

return statearr_33571;
})();
if(cljs.core.truth_(inst_33183)){
var statearr_33572_33758 = state_33520__$1;
(statearr_33572_33758[(1)] = (52));

} else {
var statearr_33573_33759 = state_33520__$1;
(statearr_33573_33759[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (50))){
var state_33520__$1 = state_33520;
var statearr_33574_33760 = state_33520__$1;
(statearr_33574_33760[(2)] = (2147483647));

(statearr_33574_33760[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (116))){
var inst_33492 = (state_33520[(66)]);
var inst_33500 = (state_33520[(2)]);
var state_33520__$1 = (function (){var statearr_33575 = state_33520;
(statearr_33575[(73)] = inst_33500);

return statearr_33575;
})();
if(cljs.core.truth_(inst_33492)){
var statearr_33576_33761 = state_33520__$1;
(statearr_33576_33761[(1)] = (118));

} else {
var statearr_33577_33762 = state_33520__$1;
(statearr_33577_33762[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (75))){
var inst_33355 = (state_33520[(30)]);
var state_33520__$1 = state_33520;
var statearr_33578_33763 = state_33520__$1;
(statearr_33578_33763[(2)] = inst_33355);

(statearr_33578_33763[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (99))){
var inst_33416 = (state_33520[(69)]);
var inst_33425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33426 = [inst_33416,inst_33416];
var inst_33427 = (new cljs.core.PersistentVector(null,2,(5),inst_33425,inst_33426,null));
var state_33520__$1 = state_33520;
var statearr_33579_33764 = state_33520__$1;
(statearr_33579_33764[(2)] = inst_33427);

(statearr_33579_33764[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (21))){
var state_33520__$1 = state_33520;
var statearr_33580_33765 = state_33520__$1;
(statearr_33580_33765[(2)] = null);

(statearr_33580_33765[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (31))){
var inst_33241 = (state_33520[(74)]);
var state_33520__$1 = state_33520;
var statearr_33581_33766 = state_33520__$1;
(statearr_33581_33766[(2)] = inst_33241);

(statearr_33581_33766[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (113))){
var inst_33486 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33582_33767 = state_33520__$1;
(statearr_33582_33767[(2)] = inst_33486);

(statearr_33582_33767[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (32))){
var inst_33172 = (state_33520[(57)]);
var inst_33261 = (state_33520[(75)]);
var inst_33260 = (state_33520[(2)]);
var inst_33261__$1 = (inst_33172 == null);
var state_33520__$1 = (function (){var statearr_33583 = state_33520;
(statearr_33583[(35)] = inst_33260);

(statearr_33583[(75)] = inst_33261__$1);

return statearr_33583;
})();
if(cljs.core.truth_(inst_33261__$1)){
var statearr_33584_33768 = state_33520__$1;
(statearr_33584_33768[(1)] = (34));

} else {
var statearr_33585_33769 = state_33520__$1;
(statearr_33585_33769[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (40))){
var inst_33260 = (state_33520[(35)]);
var state_33520__$1 = state_33520;
var statearr_33586_33770 = state_33520__$1;
(statearr_33586_33770[(2)] = inst_33260);

(statearr_33586_33770[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (91))){
var inst_33374 = (state_33520[(65)]);
var inst_33472 = (state_33520[(2)]);
var inst_33473 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33472,(0),null);
var inst_33474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33472,(1),null);
var inst_33475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33472,(2),null);
var inst_33476 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33472,(3),null);
var state_33520__$1 = (function (){var statearr_33587 = state_33520;
(statearr_33587[(76)] = inst_33474);

(statearr_33587[(77)] = inst_33475);

(statearr_33587[(78)] = inst_33473);

(statearr_33587[(7)] = inst_33476);

return statearr_33587;
})();
if(cljs.core.truth_(inst_33374)){
var statearr_33588_33771 = state_33520__$1;
(statearr_33588_33771[(1)] = (105));

} else {
var statearr_33589_33772 = state_33520__$1;
(statearr_33589_33772[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (117))){
var inst_33496 = (state_33520[(2)]);
var inst_33497 = fluree.db.util.async.throw_err(inst_33496);
var state_33520__$1 = state_33520;
var statearr_33590_33773 = state_33520__$1;
(statearr_33590_33773[(2)] = inst_33497);

(statearr_33590_33773[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (108))){
var inst_33474 = (state_33520[(76)]);
var inst_33481 = (state_33520[(79)]);
var inst_33301 = (state_33520[(44)]);
var inst_33481__$1 = (inst_33474 < inst_33301);
var state_33520__$1 = (function (){var statearr_33591 = state_33520;
(statearr_33591[(79)] = inst_33481__$1);

return statearr_33591;
})();
if(cljs.core.truth_(inst_33481__$1)){
var statearr_33592_33774 = state_33520__$1;
(statearr_33592_33774[(1)] = (111));

} else {
var statearr_33593_33775 = state_33520__$1;
(statearr_33593_33775[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (56))){
var state_33520__$1 = state_33520;
var statearr_33594_33776 = state_33520__$1;
(statearr_33594_33776[(2)] = fluree.db.util.core.min_integer);

(statearr_33594_33776[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (33))){
var inst_33256 = (state_33520[(2)]);
var inst_33257 = fluree.db.util.async.throw_err(inst_33256);
var state_33520__$1 = state_33520;
var statearr_33595_33777 = state_33520__$1;
(statearr_33595_33777[(2)] = inst_33257);

(statearr_33595_33777[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (13))){
var inst_33202 = (state_33520[(2)]);
var inst_33203 = fluree.db.util.async.throw_err(inst_33202);
var state_33520__$1 = state_33520;
var statearr_33596_33778 = state_33520__$1;
(statearr_33596_33778[(2)] = inst_33203);

(statearr_33596_33778[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (22))){
var inst_33216 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33597_33779 = state_33520__$1;
(statearr_33597_33779[(2)] = inst_33216);

(statearr_33597_33779[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (90))){
var inst_33298 = (state_33520[(10)]);
var inst_33328 = (state_33520[(8)]);
var inst_33337 = (state_33520[(11)]);
var inst_33334 = (state_33520[(9)]);
var inst_33313 = (state_33520[(12)]);
var inst_33269 = (state_33520[(13)]);
var inst_33308 = (state_33520[(14)]);
var inst_33396 = (state_33520[(72)]);
var inst_33309 = (state_33520[(15)]);
var inst_33177 = (state_33520[(16)]);
var inst_33251 = (state_33520[(17)]);
var inst_33287 = (state_33520[(18)]);
var inst_33347 = (state_33520[(19)]);
var inst_33373 = (state_33520[(80)]);
var inst_33318 = (state_33520[(20)]);
var inst_33319 = (state_33520[(21)]);
var inst_33197 = (state_33520[(22)]);
var inst_33297 = (state_33520[(23)]);
var inst_33341 = (state_33520[(24)]);
var inst_33307 = (state_33520[(25)]);
var inst_33324 = (state_33520[(26)]);
var inst_33395 = (state_33520[(81)]);
var inst_33186 = (state_33520[(27)]);
var inst_33238 = (state_33520[(28)]);
var inst_33170 = (state_33520[(29)]);
var inst_33187 = (state_33520[(31)]);
var inst_33182 = (state_33520[(32)]);
var inst_33181 = (state_33520[(33)]);
var inst_33174 = (state_33520[(34)]);
var inst_33260 = (state_33520[(35)]);
var inst_33338 = (state_33520[(36)]);
var inst_33278 = (state_33520[(37)]);
var inst_33175 = (state_33520[(38)]);
var inst_33296 = (state_33520[(39)]);
var inst_33340 = (state_33520[(40)]);
var inst_33239 = (state_33520[(41)]);
var inst_33300 = (state_33520[(42)]);
var inst_33339 = (state_33520[(43)]);
var inst_33301 = (state_33520[(44)]);
var inst_33185 = (state_33520[(45)]);
var inst_33206 = (state_33520[(46)]);
var inst_33374 = (state_33520[(65)]);
var inst_33314 = (state_33520[(47)]);
var inst_33242 = (state_33520[(48)]);
var inst_33394 = (function (){var no_filter_QMARK_ = inst_33334;
var base_result_SINGLEQUOTE_ = inst_33373;
var t = inst_33314;
var max_limit_QMARK_ = inst_33308;
var map__33169 = inst_33300;
var next_node = inst_33337;
var fast_forward_db_QMARK_ = inst_33319;
var s1 = inst_33197;
var o2 = inst_33260;
var t1 = inst_33174;
var predicate_fn = inst_33187;
var i = inst_33339;
var rhs = inst_33374;
var m1 = inst_33287;
var root_node = inst_33324;
var s2 = inst_33206;
var vec__33159 = inst_33177;
var vec__33156 = inst_33170;
var p2 = inst_33278;
var vec__33166 = inst_33239;
var permissions = inst_33309;
var limit = inst_33307;
var start_flake = inst_33297;
var flake_limit = inst_33301;
var offset = inst_33338;
var acc = inst_33341;
var t2 = inst_33181;
var op1 = inst_33175;
var o1 = inst_33251;
var end_flake = inst_33298;
var base_result = inst_33347;
var s = inst_33340;
var node_start = inst_33328;
var map__33162 = inst_33185;
var p1 = inst_33269;
var subject_fn = inst_33186;
var vec__33163 = inst_33238;
var object_fn = inst_33242;
var idx_compare = inst_33313;
var op2 = inst_33182;
var m2 = inst_33296;
var novelty = inst_33318;
return (function (p1__33141_SHARP_){
return p1__33141_SHARP_.s;
});
})();
var inst_33395__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_33394,inst_33373);
var inst_33396__$1 = cljs.core.count(inst_33395__$1);
var inst_33397 = (inst_33338 > inst_33396__$1);
var state_33520__$1 = (function (){var statearr_33598 = state_33520;
(statearr_33598[(72)] = inst_33396__$1);

(statearr_33598[(81)] = inst_33395__$1);

return statearr_33598;
})();
if(cljs.core.truth_(inst_33397)){
var statearr_33599_33780 = state_33520__$1;
(statearr_33599_33780[(1)] = (92));

} else {
var statearr_33600_33781 = state_33520__$1;
(statearr_33600_33781[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (109))){
var inst_33479 = (state_33520[(82)]);
var state_33520__$1 = state_33520;
var statearr_33601_33782 = state_33520__$1;
(statearr_33601_33782[(2)] = inst_33479);

(statearr_33601_33782[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (36))){
var inst_33265 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
if(cljs.core.truth_(inst_33265)){
var statearr_33602_33783 = state_33520__$1;
(statearr_33602_33783[(1)] = (37));

} else {
var statearr_33603_33784 = state_33520__$1;
(statearr_33603_33784[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (41))){
var inst_33270 = (state_33520[(63)]);
var state_33520__$1 = state_33520;
var statearr_33604_33785 = state_33520__$1;
(statearr_33604_33785[(2)] = inst_33270);

(statearr_33604_33785[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (118))){
var inst_33500 = (state_33520[(73)]);
var state_33520__$1 = state_33520;
var statearr_33605_33786 = state_33520__$1;
(statearr_33605_33786[(2)] = inst_33500);

(statearr_33605_33786[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (89))){
var inst_33373 = (state_33520[(80)]);
var inst_33341 = (state_33520[(24)]);
var inst_33340 = (state_33520[(40)]);
var inst_33339 = (state_33520[(43)]);
var inst_33301 = (state_33520[(44)]);
var inst_33385 = cljs.core.count(inst_33373);
var inst_33386 = (inst_33301 - inst_33339);
var inst_33387 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_33386,inst_33373);
var inst_33388 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33341,inst_33387);
var inst_33389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33390 = (inst_33339 + inst_33385);
var inst_33391 = [(0),inst_33390,inst_33340,inst_33388];
var inst_33392 = (new cljs.core.PersistentVector(null,4,(5),inst_33389,inst_33391,null));
var state_33520__$1 = state_33520;
var statearr_33606_33787 = state_33520__$1;
(statearr_33606_33787[(2)] = inst_33392);

(statearr_33606_33787[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (100))){
var inst_33433 = (state_33520[(52)]);
var inst_33407 = (state_33520[(67)]);
var inst_33435 = (state_33520[(53)]);
var inst_33339 = (state_33520[(43)]);
var inst_33434 = (state_33520[(54)]);
var inst_33301 = (state_33520[(44)]);
var inst_33429 = (state_33520[(2)]);
var inst_33430 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33429,(0),null);
var inst_33431 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33429,(1),null);
var inst_33432 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_33431,inst_33407);
var inst_33433__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_33432);
var inst_33434__$1 = cljs.core.count(inst_33433__$1);
var inst_33435__$1 = (inst_33339 + inst_33434__$1);
var inst_33436 = (inst_33435__$1 > inst_33301);
var state_33520__$1 = (function (){var statearr_33607 = state_33520;
(statearr_33607[(52)] = inst_33433__$1);

(statearr_33607[(83)] = inst_33430);

(statearr_33607[(53)] = inst_33435__$1);

(statearr_33607[(54)] = inst_33434__$1);

return statearr_33607;
})();
if(cljs.core.truth_(inst_33436)){
var statearr_33608_33788 = state_33520__$1;
(statearr_33608_33788[(1)] = (101));

} else {
var statearr_33609_33789 = state_33520__$1;
(statearr_33609_33789[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (122))){
var inst_33474 = (state_33520[(76)]);
var inst_33500 = (state_33520[(73)]);
var inst_33475 = (state_33520[(77)]);
var inst_33473 = (state_33520[(78)]);
var inst_33476 = (state_33520[(7)]);
var inst_33337 = inst_33500;
var inst_33338 = inst_33473;
var inst_33339 = inst_33474;
var inst_33340 = inst_33475;
var inst_33341 = inst_33476;
var state_33520__$1 = (function (){var statearr_33610 = state_33520;
(statearr_33610[(11)] = inst_33337);

(statearr_33610[(24)] = inst_33341);

(statearr_33610[(36)] = inst_33338);

(statearr_33610[(40)] = inst_33340);

(statearr_33610[(43)] = inst_33339);

return statearr_33610;
})();
var statearr_33611_33790 = state_33520__$1;
(statearr_33611_33790[(2)] = null);

(statearr_33611_33790[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (43))){
var state_33520__$1 = state_33520;
var statearr_33612_33791 = state_33520__$1;
(statearr_33612_33791[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_33612_33791[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (61))){
var inst_33318 = (state_33520[(20)]);
var inst_33319 = (state_33520[(21)]);
var inst_33297 = (state_33520[(23)]);
var inst_33324 = (state_33520[(26)]);
var inst_33314 = (state_33520[(47)]);
var inst_33323 = (state_33520[(2)]);
var inst_33324__$1 = fluree.db.util.async.throw_err(inst_33323);
var inst_33325 = fluree.db.query.range.find_next_valid_node(inst_33324__$1,inst_33297,inst_33314,inst_33318,inst_33319);
var state_33520__$1 = (function (){var statearr_33613 = state_33520;
(statearr_33613[(26)] = inst_33324__$1);

return statearr_33613;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33520__$1,(62),inst_33325);
} else {
if((state_val_33521 === (29))){
var inst_33247 = (state_33520[(2)]);
var inst_33248 = fluree.db.util.async.throw_err(inst_33247);
var state_33520__$1 = state_33520;
var statearr_33614_33792 = state_33520__$1;
(statearr_33614_33792[(2)] = inst_33248);

(statearr_33614_33792[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (44))){
var inst_33179 = (state_33520[(58)]);
var state_33520__$1 = state_33520;
var statearr_33615_33793 = state_33520__$1;
(statearr_33615_33793[(2)] = inst_33179);

(statearr_33615_33793[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (93))){
var inst_33334 = (state_33520[(9)]);
var inst_33395 = (state_33520[(81)]);
var inst_33338 = (state_33520[(36)]);
var inst_33407 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_33338,inst_33395);
var state_33520__$1 = (function (){var statearr_33616 = state_33520;
(statearr_33616[(67)] = inst_33407);

return statearr_33616;
})();
if(cljs.core.truth_(inst_33334)){
var statearr_33617_33794 = state_33520__$1;
(statearr_33617_33794[(1)] = (95));

} else {
var statearr_33618_33795 = state_33520__$1;
(statearr_33618_33795[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (6))){
var inst_33171 = (state_33520[(49)]);
var inst_33191 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_33171);
var state_33520__$1 = state_33520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33520__$1,(9),inst_33191);
} else {
if((state_val_33521 === (111))){
var inst_33475 = (state_33520[(77)]);
var inst_33307 = (state_33520[(25)]);
var inst_33483 = (inst_33475 < inst_33307);
var state_33520__$1 = state_33520;
var statearr_33619_33796 = state_33520__$1;
(statearr_33619_33796[(2)] = inst_33483);

(statearr_33619_33796[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (28))){
var inst_33241 = (state_33520[(74)]);
var inst_33251 = (state_33520[(2)]);
var inst_33252 = fluree.db.util.core.pred_ident_QMARK_(inst_33241);
var state_33520__$1 = (function (){var statearr_33620 = state_33520;
(statearr_33620[(17)] = inst_33251);

return statearr_33620;
})();
if(inst_33252){
var statearr_33621_33797 = state_33520__$1;
(statearr_33621_33797[(1)] = (30));

} else {
var statearr_33622_33798 = state_33520__$1;
(statearr_33622_33798[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (64))){
var state_33520__$1 = state_33520;
var statearr_33623_33799 = state_33520__$1;
(statearr_33623_33799[(2)] = true);

(statearr_33623_33799[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (103))){
var inst_33430 = (state_33520[(83)]);
var inst_33449 = (state_33520[(2)]);
var inst_33450 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33449,(0),null);
var inst_33451 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33449,(1),null);
var inst_33452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33453 = [inst_33450,inst_33430,inst_33451];
var inst_33454 = (new cljs.core.PersistentVector(null,3,(5),inst_33452,inst_33453,null));
var state_33520__$1 = state_33520;
var statearr_33624_33800 = state_33520__$1;
(statearr_33624_33800[(2)] = inst_33454);

(statearr_33624_33800[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (51))){
var inst_33285 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33625_33801 = state_33520__$1;
(statearr_33625_33801[(2)] = inst_33285);

(statearr_33625_33801[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (25))){
var inst_33238 = (state_33520[(28)]);
var inst_33239 = (state_33520[(41)]);
var inst_33240 = (state_33520[(51)]);
var inst_33238__$1 = (state_33520[(2)]);
var inst_33239__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33238__$1,(0),null);
var inst_33240__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33239__$1,(0),null);
var inst_33241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33239__$1,(1),null);
var inst_33242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33238__$1,(1),null);
var inst_33243 = fluree.db.util.core.pred_ident_QMARK_(inst_33240__$1);
var state_33520__$1 = (function (){var statearr_33626 = state_33520;
(statearr_33626[(28)] = inst_33238__$1);

(statearr_33626[(41)] = inst_33239__$1);

(statearr_33626[(51)] = inst_33240__$1);

(statearr_33626[(74)] = inst_33241);

(statearr_33626[(48)] = inst_33242);

return statearr_33626;
})();
if(inst_33243){
var statearr_33627_33802 = state_33520__$1;
(statearr_33627_33802[(1)] = (26));

} else {
var statearr_33628_33803 = state_33520__$1;
(statearr_33628_33803[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (34))){
var inst_33251 = (state_33520[(17)]);
var state_33520__$1 = state_33520;
var statearr_33629_33804 = state_33520__$1;
(statearr_33629_33804[(2)] = inst_33251);

(statearr_33629_33804[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (17))){
var inst_33180 = (state_33520[(62)]);
var state_33520__$1 = state_33520;
var statearr_33630_33805 = state_33520__$1;
(statearr_33630_33805[(2)] = inst_33180);

(statearr_33630_33805[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (3))){
var inst_33518 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33520__$1,inst_33518);
} else {
if((state_val_33521 === (12))){
var inst_33173 = (state_33520[(56)]);
var inst_33206 = (state_33520[(2)]);
var inst_33207 = cljs.core.boolean_QMARK_(inst_33173);
var state_33520__$1 = (function (){var statearr_33631 = state_33520;
(statearr_33631[(46)] = inst_33206);

return statearr_33631;
})();
if(inst_33207){
var statearr_33632_33806 = state_33520__$1;
(statearr_33632_33806[(1)] = (14));

} else {
var statearr_33633_33807 = state_33520__$1;
(statearr_33633_33807[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (2))){
var inst_33177 = (state_33520[(16)]);
var inst_33171 = (state_33520[(49)]);
var inst_33170 = (state_33520[(29)]);
var inst_33185 = (state_33520[(45)]);
var _ = (function (){var statearr_33634 = state_33520;
(statearr_33634[(4)] = cljs.core.cons((5),(state_33520[(4)])));

return statearr_33634;
})();
var inst_33170__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_33171__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33170__$1,(0),null);
var inst_33172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33170__$1,(1),null);
var inst_33173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33170__$1,(2),null);
var inst_33174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33170__$1,(3),null);
var inst_33175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33170__$1,(4),null);
var inst_33176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33170__$1,(5),null);
var inst_33177__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_33178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33177__$1,(0),null);
var inst_33179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33177__$1,(1),null);
var inst_33180 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33177__$1,(2),null);
var inst_33181 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33177__$1,(3),null);
var inst_33182 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33177__$1,(4),null);
var inst_33183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33177__$1,(5),null);
var inst_33184 = opts;
var inst_33185__$1 = cljs.core.__destructure_map(inst_33184);
var inst_33186 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33185__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_33187 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33185__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_33188 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33185__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_33189 = fluree.db.util.core.pred_ident_QMARK_(inst_33171__$1);
var state_33520__$1 = (function (){var statearr_33635 = state_33520;
(statearr_33635[(55)] = inst_33183);

(statearr_33635[(56)] = inst_33173);

(statearr_33635[(16)] = inst_33177__$1);

(statearr_33635[(57)] = inst_33172);

(statearr_33635[(58)] = inst_33179);

(statearr_33635[(59)] = inst_33176);

(statearr_33635[(84)] = inst_33178);

(statearr_33635[(27)] = inst_33186);

(statearr_33635[(49)] = inst_33171__$1);

(statearr_33635[(29)] = inst_33170__$1);

(statearr_33635[(31)] = inst_33187);

(statearr_33635[(32)] = inst_33182);

(statearr_33635[(33)] = inst_33181);

(statearr_33635[(34)] = inst_33174);

(statearr_33635[(38)] = inst_33175);

(statearr_33635[(61)] = inst_33188);

(statearr_33635[(62)] = inst_33180);

(statearr_33635[(45)] = inst_33185__$1);

return statearr_33635;
})();
if(inst_33189){
var statearr_33636_33808 = state_33520__$1;
(statearr_33636_33808[(1)] = (6));

} else {
var statearr_33637_33809 = state_33520__$1;
(statearr_33637_33809[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (66))){
var inst_33328 = (state_33520[(8)]);
var inst_33303 = (state_33520[(71)]);
var inst_33336 = cljs.core.PersistentVector.EMPTY;
var inst_33337 = inst_33328;
var inst_33338 = inst_33303;
var inst_33339 = (0);
var inst_33340 = (0);
var inst_33341 = inst_33336;
var state_33520__$1 = (function (){var statearr_33638 = state_33520;
(statearr_33638[(11)] = inst_33337);

(statearr_33638[(24)] = inst_33341);

(statearr_33638[(36)] = inst_33338);

(statearr_33638[(40)] = inst_33340);

(statearr_33638[(43)] = inst_33339);

return statearr_33638;
})();
var statearr_33639_33810 = state_33520__$1;
(statearr_33639_33810[(2)] = null);

(statearr_33639_33810[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (107))){
var inst_33492 = (state_33520[(66)]);
var inst_33492__$1 = (state_33520[(2)]);
var state_33520__$1 = (function (){var statearr_33640 = state_33520;
(statearr_33640[(66)] = inst_33492__$1);

return statearr_33640;
})();
if(cljs.core.truth_(inst_33492__$1)){
var statearr_33641_33811 = state_33520__$1;
(statearr_33641_33811[(1)] = (114));

} else {
var statearr_33642_33812 = state_33520__$1;
(statearr_33642_33812[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (23))){
var inst_33173 = (state_33520[(56)]);
var inst_33188 = (state_33520[(61)]);
var inst_33180 = (state_33520[(62)]);
var inst_33223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33225 = [inst_33173,inst_33180];
var inst_33226 = (new cljs.core.PersistentVector(null,2,(5),inst_33224,inst_33225,null));
var inst_33227 = [inst_33226,inst_33188];
var inst_33228 = (new cljs.core.PersistentVector(null,2,(5),inst_33223,inst_33227,null));
var state_33520__$1 = state_33520;
var statearr_33643_33813 = state_33520__$1;
(statearr_33643_33813[(2)] = inst_33228);

(statearr_33643_33813[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (47))){
var inst_33281 = (cljs.core._GT__EQ_ === start_test);
var state_33520__$1 = state_33520;
if(cljs.core.truth_(inst_33281)){
var statearr_33644_33814 = state_33520__$1;
(statearr_33644_33814[(1)] = (49));

} else {
var statearr_33645_33815 = state_33520__$1;
(statearr_33645_33815[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (35))){
var inst_33261 = (state_33520[(75)]);
var state_33520__$1 = state_33520;
var statearr_33646_33816 = state_33520__$1;
(statearr_33646_33816[(2)] = inst_33261);

(statearr_33646_33816[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (82))){
var inst_33337 = (state_33520[(11)]);
var inst_33308 = (state_33520[(14)]);
var inst_33373 = (state_33520[(2)]);
var inst_33374 = fluree.db.dbproto._rhs(inst_33337);
var state_33520__$1 = (function (){var statearr_33647 = state_33520;
(statearr_33647[(80)] = inst_33373);

(statearr_33647[(65)] = inst_33374);

return statearr_33647;
})();
if(cljs.core.truth_(inst_33308)){
var statearr_33648_33817 = state_33520__$1;
(statearr_33648_33817[(1)] = (83));

} else {
var statearr_33649_33818 = state_33520__$1;
(statearr_33649_33818[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (76))){
var inst_33187 = (state_33520[(31)]);
var inst_33361 = (state_33520[(2)]);
var state_33520__$1 = (function (){var statearr_33650 = state_33520;
(statearr_33650[(64)] = inst_33361);

return statearr_33650;
})();
if(cljs.core.truth_(inst_33187)){
var statearr_33651_33819 = state_33520__$1;
(statearr_33651_33819[(1)] = (77));

} else {
var statearr_33652_33820 = state_33520__$1;
(statearr_33652_33820[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (97))){
var inst_33341 = (state_33520[(24)]);
var inst_33461 = (state_33520[(2)]);
var inst_33462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33461,(0),null);
var inst_33463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33461,(1),null);
var inst_33464 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33461,(2),null);
var inst_33465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33466 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33341,inst_33464);
var inst_33467 = [(0),inst_33462,inst_33463,inst_33466];
var inst_33468 = (new cljs.core.PersistentVector(null,4,(5),inst_33465,inst_33467,null));
var state_33520__$1 = state_33520;
var statearr_33653_33821 = state_33520__$1;
(statearr_33653_33821[(2)] = inst_33468);

(statearr_33653_33821[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (19))){
var inst_33218 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33654_33822 = state_33520__$1;
(statearr_33654_33822[(2)] = inst_33218);

(statearr_33654_33822[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (57))){
var inst_33294 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33655_33823 = state_33520__$1;
(statearr_33655_33823[(2)] = inst_33294);

(statearr_33655_33823[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (68))){
var inst_33515 = (state_33520[(2)]);
var _ = (function (){var statearr_33656 = state_33520;
(statearr_33656[(4)] = cljs.core.rest((state_33520[(4)])));

return statearr_33656;
})();
var state_33520__$1 = state_33520;
var statearr_33657_33824 = state_33520__$1;
(statearr_33657_33824[(2)] = inst_33515);

(statearr_33657_33824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (11))){
var inst_33178 = (state_33520[(84)]);
var state_33520__$1 = state_33520;
var statearr_33658_33825 = state_33520__$1;
(statearr_33658_33825[(2)] = inst_33178);

(statearr_33658_33825[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (115))){
var state_33520__$1 = state_33520;
var statearr_33660_33826 = state_33520__$1;
(statearr_33660_33826[(2)] = null);

(statearr_33660_33826[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (9))){
var inst_33193 = (state_33520[(2)]);
var inst_33194 = fluree.db.util.async.throw_err(inst_33193);
var state_33520__$1 = state_33520;
var statearr_33661_33827 = state_33520__$1;
(statearr_33661_33827[(2)] = inst_33194);

(statearr_33661_33827[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (5))){
var _ = (function (){var statearr_33662 = state_33520;
(statearr_33662[(4)] = cljs.core.rest((state_33520[(4)])));

return statearr_33662;
})();
var state_33520__$1 = state_33520;
var ex33659 = (state_33520__$1[(2)]);
var statearr_33663_33828 = state_33520__$1;
(statearr_33663_33828[(5)] = ex33659);


if((ex33659 instanceof Error)){
var statearr_33664_33829 = state_33520__$1;
(statearr_33664_33829[(1)] = (4));

(statearr_33664_33829[(5)] = null);

} else {
throw ex33659;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (112))){
var inst_33481 = (state_33520[(79)]);
var state_33520__$1 = state_33520;
var statearr_33665_33830 = state_33520__$1;
(statearr_33665_33830[(2)] = inst_33481);

(statearr_33665_33830[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (83))){
var inst_33338 = (state_33520[(36)]);
var inst_33376 = (state_33520[(85)]);
var inst_33376__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_33338);
var state_33520__$1 = (function (){var statearr_33666 = state_33520;
(statearr_33666[(85)] = inst_33376__$1);

return statearr_33666;
})();
if(inst_33376__$1){
var statearr_33667_33831 = state_33520__$1;
(statearr_33667_33831[(1)] = (86));

} else {
var statearr_33668_33832 = state_33520__$1;
(statearr_33668_33832[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (14))){
var inst_33173 = (state_33520[(56)]);
var state_33520__$1 = state_33520;
var statearr_33669_33833 = state_33520__$1;
(statearr_33669_33833[(2)] = inst_33173);

(statearr_33669_33833[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (45))){
var inst_33176 = (state_33520[(59)]);
var inst_33278 = (state_33520[(2)]);
var state_33520__$1 = (function (){var statearr_33670 = state_33520;
(statearr_33670[(37)] = inst_33278);

return statearr_33670;
})();
if(cljs.core.truth_(inst_33176)){
var statearr_33671_33834 = state_33520__$1;
(statearr_33671_33834[(1)] = (46));

} else {
var statearr_33672_33835 = state_33520__$1;
(statearr_33672_33835[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (53))){
var inst_33290 = (cljs.core._LT__EQ_ === end_test);
var state_33520__$1 = state_33520;
if(cljs.core.truth_(inst_33290)){
var statearr_33673_33836 = state_33520__$1;
(statearr_33673_33836[(1)] = (55));

} else {
var statearr_33674_33837 = state_33520__$1;
(statearr_33674_33837[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (78))){
var inst_33361 = (state_33520[(64)]);
var state_33520__$1 = state_33520;
var statearr_33675_33838 = state_33520__$1;
(statearr_33675_33838[(2)] = inst_33361);

(statearr_33675_33838[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (26))){
var inst_33240 = (state_33520[(51)]);
var inst_33245 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_33240);
var state_33520__$1 = state_33520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33520__$1,(29),inst_33245);
} else {
if((state_val_33521 === (123))){
var inst_33510 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33676_33839 = state_33520__$1;
(statearr_33676_33839[(2)] = inst_33510);

(statearr_33676_33839[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (16))){
var inst_33220 = (state_33520[(60)]);
var inst_33220__$1 = (state_33520[(2)]);
var inst_33221 = (inst_33220__$1 == null);
var state_33520__$1 = (function (){var statearr_33677 = state_33520;
(statearr_33677[(60)] = inst_33220__$1);

return statearr_33677;
})();
if(cljs.core.truth_(inst_33221)){
var statearr_33678_33840 = state_33520__$1;
(statearr_33678_33840[(1)] = (23));

} else {
var statearr_33679_33841 = state_33520__$1;
(statearr_33679_33841[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (81))){
var inst_33367 = (state_33520[(86)]);
var state_33520__$1 = state_33520;
var statearr_33680_33842 = state_33520__$1;
(statearr_33680_33842[(2)] = inst_33367);

(statearr_33680_33842[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (120))){
var inst_33504 = (state_33520[(2)]);
var inst_33505 = cljs.core.not(inst_33504);
var state_33520__$1 = state_33520;
if(inst_33505){
var statearr_33681_33843 = state_33520__$1;
(statearr_33681_33843[(1)] = (121));

} else {
var statearr_33682_33844 = state_33520__$1;
(statearr_33682_33844[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (79))){
var inst_33242 = (state_33520[(48)]);
var inst_33367 = (state_33520[(2)]);
var state_33520__$1 = (function (){var statearr_33683 = state_33520;
(statearr_33683[(86)] = inst_33367);

return statearr_33683;
})();
if(cljs.core.truth_(inst_33242)){
var statearr_33684_33845 = state_33520__$1;
(statearr_33684_33845[(1)] = (80));

} else {
var statearr_33685_33846 = state_33520__$1;
(statearr_33685_33846[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (38))){
var inst_33172 = (state_33520[(57)]);
var state_33520__$1 = state_33520;
var statearr_33686_33847 = state_33520__$1;
(statearr_33686_33847[(2)] = inst_33172);

(statearr_33686_33847[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (98))){
var inst_33307 = (state_33520[(25)]);
var inst_33417 = (state_33520[(68)]);
var inst_33415 = (state_33520[(70)]);
var inst_33420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33421 = (inst_33415 - inst_33417);
var inst_33422 = [inst_33307,inst_33421];
var inst_33423 = (new cljs.core.PersistentVector(null,2,(5),inst_33420,inst_33422,null));
var state_33520__$1 = state_33520;
var statearr_33687_33848 = state_33520__$1;
(statearr_33687_33848[(2)] = inst_33423);

(statearr_33687_33848[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (87))){
var inst_33376 = (state_33520[(85)]);
var state_33520__$1 = state_33520;
var statearr_33688_33849 = state_33520__$1;
(statearr_33688_33849[(2)] = inst_33376);

(statearr_33688_33849[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (30))){
var inst_33241 = (state_33520[(74)]);
var inst_33254 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_33241);
var state_33520__$1 = state_33520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33520__$1,(33),inst_33254);
} else {
if((state_val_33521 === (73))){
var inst_33186 = (state_33520[(27)]);
var inst_33355 = (state_33520[(2)]);
var state_33520__$1 = (function (){var statearr_33689 = state_33520;
(statearr_33689[(30)] = inst_33355);

return statearr_33689;
})();
if(cljs.core.truth_(inst_33186)){
var statearr_33690_33850 = state_33520__$1;
(statearr_33690_33850[(1)] = (74));

} else {
var statearr_33691_33851 = state_33520__$1;
(statearr_33691_33851[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (96))){
var inst_33307 = (state_33520[(25)]);
var inst_33407 = (state_33520[(67)]);
var inst_33340 = (state_33520[(40)]);
var inst_33339 = (state_33520[(43)]);
var inst_33301 = (state_33520[(44)]);
var inst_33456 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_33407,inst_33339,inst_33340,inst_33301,inst_33307);
var state_33520__$1 = state_33520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33520__$1,(104),inst_33456);
} else {
if((state_val_33521 === (10))){
var inst_33178 = (state_33520[(84)]);
var inst_33200 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_33178);
var state_33520__$1 = state_33520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33520__$1,(13),inst_33200);
} else {
if((state_val_33521 === (18))){
var state_33520__$1 = state_33520;
var statearr_33692_33852 = state_33520__$1;
(statearr_33692_33852[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (105))){
var inst_33298 = (state_33520[(10)]);
var inst_33313 = (state_33520[(12)]);
var inst_33479 = (state_33520[(82)]);
var inst_33374 = (state_33520[(65)]);
var inst_33478 = (inst_33313.cljs$core$IFn$_invoke$arity$2 ? inst_33313.cljs$core$IFn$_invoke$arity$2(inst_33374,inst_33298) : inst_33313.call(null,inst_33374,inst_33298));
var inst_33479__$1 = (inst_33478 < (0));
var state_33520__$1 = (function (){var statearr_33694 = state_33520;
(statearr_33694[(82)] = inst_33479__$1);

return statearr_33694;
})();
if(cljs.core.truth_(inst_33479__$1)){
var statearr_33695_33853 = state_33520__$1;
(statearr_33695_33853[(1)] = (108));

} else {
var statearr_33696_33854 = state_33520__$1;
(statearr_33696_33854[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (52))){
var inst_33183 = (state_33520[(55)]);
var state_33520__$1 = state_33520;
var statearr_33697_33855 = state_33520__$1;
(statearr_33697_33855[(2)] = inst_33183);

(statearr_33697_33855[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (114))){
var inst_33318 = (state_33520[(20)]);
var inst_33319 = (state_33520[(21)]);
var inst_33324 = (state_33520[(26)]);
var inst_33374 = (state_33520[(65)]);
var inst_33314 = (state_33520[(47)]);
var inst_33494 = fluree.db.query.range.find_next_valid_node(inst_33324,inst_33374,inst_33314,inst_33318,inst_33319);
var state_33520__$1 = state_33520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33520__$1,(117),inst_33494);
} else {
if((state_val_33521 === (67))){
var state_33520__$1 = state_33520;
var statearr_33698_33856 = state_33520__$1;
(statearr_33698_33856[(2)] = null);

(statearr_33698_33856[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (71))){
var inst_33298 = (state_33520[(10)]);
var inst_33328 = (state_33520[(8)]);
var inst_33337 = (state_33520[(11)]);
var inst_33334 = (state_33520[(9)]);
var inst_33313 = (state_33520[(12)]);
var inst_33269 = (state_33520[(13)]);
var inst_33308 = (state_33520[(14)]);
var inst_33309 = (state_33520[(15)]);
var inst_33177 = (state_33520[(16)]);
var inst_33251 = (state_33520[(17)]);
var inst_33287 = (state_33520[(18)]);
var inst_33347 = (state_33520[(19)]);
var inst_33318 = (state_33520[(20)]);
var inst_33319 = (state_33520[(21)]);
var inst_33197 = (state_33520[(22)]);
var inst_33297 = (state_33520[(23)]);
var inst_33341 = (state_33520[(24)]);
var inst_33307 = (state_33520[(25)]);
var inst_33324 = (state_33520[(26)]);
var inst_33186 = (state_33520[(27)]);
var inst_33238 = (state_33520[(28)]);
var inst_33170 = (state_33520[(29)]);
var inst_33187 = (state_33520[(31)]);
var inst_33182 = (state_33520[(32)]);
var inst_33181 = (state_33520[(33)]);
var inst_33174 = (state_33520[(34)]);
var inst_33260 = (state_33520[(35)]);
var inst_33338 = (state_33520[(36)]);
var inst_33278 = (state_33520[(37)]);
var inst_33175 = (state_33520[(38)]);
var inst_33296 = (state_33520[(39)]);
var inst_33340 = (state_33520[(40)]);
var inst_33239 = (state_33520[(41)]);
var inst_33300 = (state_33520[(42)]);
var inst_33339 = (state_33520[(43)]);
var inst_33301 = (state_33520[(44)]);
var inst_33185 = (state_33520[(45)]);
var inst_33206 = (state_33520[(46)]);
var inst_33314 = (state_33520[(47)]);
var inst_33242 = (state_33520[(48)]);
var inst_33351 = (function (){var no_filter_QMARK_ = inst_33334;
var t = inst_33314;
var max_limit_QMARK_ = inst_33308;
var map__33169 = inst_33300;
var next_node = inst_33337;
var fast_forward_db_QMARK_ = inst_33319;
var s1 = inst_33197;
var o2 = inst_33260;
var t1 = inst_33174;
var predicate_fn = inst_33187;
var i = inst_33339;
var m1 = inst_33287;
var root_node = inst_33324;
var s2 = inst_33206;
var vec__33159 = inst_33177;
var vec__33156 = inst_33170;
var p2 = inst_33278;
var vec__33166 = inst_33239;
var permissions = inst_33309;
var limit = inst_33307;
var start_flake = inst_33297;
var flake_limit = inst_33301;
var offset = inst_33338;
var acc = inst_33341;
var t2 = inst_33181;
var op1 = inst_33175;
var o1 = inst_33251;
var end_flake = inst_33298;
var base_result = inst_33347;
var s = inst_33340;
var node_start = inst_33328;
var map__33162 = inst_33185;
var p1 = inst_33269;
var subject_fn = inst_33186;
var vec__33163 = inst_33238;
var object_fn = inst_33242;
var idx_compare = inst_33313;
var op2 = inst_33182;
var m2 = inst_33296;
var G__33348 = inst_33347;
var novelty = inst_33318;
return (function (p1__33137_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__33137_SHARP_.o,start_flake.o);
});
})();
var inst_33352 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_33351,inst_33347);
var state_33520__$1 = state_33520;
var statearr_33699_33857 = state_33520__$1;
(statearr_33699_33857[(2)] = inst_33352);

(statearr_33699_33857[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (42))){
var inst_33274 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
if(cljs.core.truth_(inst_33274)){
var statearr_33700_33858 = state_33520__$1;
(statearr_33700_33858[(1)] = (43));

} else {
var statearr_33701_33859 = state_33520__$1;
(statearr_33701_33859[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (80))){
var inst_33298 = (state_33520[(10)]);
var inst_33328 = (state_33520[(8)]);
var inst_33337 = (state_33520[(11)]);
var inst_33334 = (state_33520[(9)]);
var inst_33367 = (state_33520[(86)]);
var inst_33313 = (state_33520[(12)]);
var inst_33269 = (state_33520[(13)]);
var inst_33308 = (state_33520[(14)]);
var inst_33309 = (state_33520[(15)]);
var inst_33177 = (state_33520[(16)]);
var inst_33251 = (state_33520[(17)]);
var inst_33287 = (state_33520[(18)]);
var inst_33347 = (state_33520[(19)]);
var inst_33318 = (state_33520[(20)]);
var inst_33319 = (state_33520[(21)]);
var inst_33197 = (state_33520[(22)]);
var inst_33297 = (state_33520[(23)]);
var inst_33341 = (state_33520[(24)]);
var inst_33307 = (state_33520[(25)]);
var inst_33324 = (state_33520[(26)]);
var inst_33186 = (state_33520[(27)]);
var inst_33238 = (state_33520[(28)]);
var inst_33170 = (state_33520[(29)]);
var inst_33187 = (state_33520[(31)]);
var inst_33182 = (state_33520[(32)]);
var inst_33181 = (state_33520[(33)]);
var inst_33174 = (state_33520[(34)]);
var inst_33260 = (state_33520[(35)]);
var inst_33338 = (state_33520[(36)]);
var inst_33278 = (state_33520[(37)]);
var inst_33175 = (state_33520[(38)]);
var inst_33296 = (state_33520[(39)]);
var inst_33340 = (state_33520[(40)]);
var inst_33239 = (state_33520[(41)]);
var inst_33300 = (state_33520[(42)]);
var inst_33339 = (state_33520[(43)]);
var inst_33301 = (state_33520[(44)]);
var inst_33185 = (state_33520[(45)]);
var inst_33206 = (state_33520[(46)]);
var inst_33314 = (state_33520[(47)]);
var inst_33242 = (state_33520[(48)]);
var inst_33369 = (function (){var no_filter_QMARK_ = inst_33334;
var t = inst_33314;
var max_limit_QMARK_ = inst_33308;
var map__33169 = inst_33300;
var next_node = inst_33337;
var fast_forward_db_QMARK_ = inst_33319;
var s1 = inst_33197;
var o2 = inst_33260;
var t1 = inst_33174;
var predicate_fn = inst_33187;
var i = inst_33339;
var m1 = inst_33287;
var root_node = inst_33324;
var s2 = inst_33206;
var vec__33159 = inst_33177;
var vec__33156 = inst_33170;
var p2 = inst_33278;
var vec__33166 = inst_33239;
var permissions = inst_33309;
var limit = inst_33307;
var start_flake = inst_33297;
var flake_limit = inst_33301;
var offset = inst_33338;
var acc = inst_33341;
var t2 = inst_33181;
var op1 = inst_33175;
var o1 = inst_33251;
var end_flake = inst_33298;
var base_result = inst_33347;
var s = inst_33340;
var node_start = inst_33328;
var map__33162 = inst_33185;
var p1 = inst_33269;
var subject_fn = inst_33186;
var vec__33163 = inst_33238;
var object_fn = inst_33242;
var idx_compare = inst_33313;
var op2 = inst_33182;
var m2 = inst_33296;
var G__33348 = inst_33367;
var novelty = inst_33318;
return (function (p1__33140_SHARP_){
var G__33702 = p1__33140_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__33702) : object_fn.call(null,G__33702));
});
})();
var inst_33370 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_33369,inst_33367);
var state_33520__$1 = state_33520;
var statearr_33703_33860 = state_33520__$1;
(statearr_33703_33860[(2)] = inst_33370);

(statearr_33703_33860[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (37))){
var state_33520__$1 = state_33520;
var statearr_33704_33861 = state_33520__$1;
(statearr_33704_33861[(2)] = (-1));

(statearr_33704_33861[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (63))){
var inst_33269 = (state_33520[(13)]);
var inst_33309 = (state_33520[(15)]);
var inst_33197 = (state_33520[(22)]);
var inst_33278 = (state_33520[(37)]);
var inst_33206 = (state_33520[(46)]);
var inst_33331 = fluree.db.permissions_validate.no_filter_QMARK_(inst_33309,inst_33197,inst_33206,inst_33269,inst_33278);
var state_33520__$1 = state_33520;
var statearr_33705_33862 = state_33520__$1;
(statearr_33705_33862[(2)] = inst_33331);

(statearr_33705_33862[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (94))){
var inst_33470 = (state_33520[(2)]);
var state_33520__$1 = state_33520;
var statearr_33706_33863 = state_33520__$1;
(statearr_33706_33863[(2)] = inst_33470);

(statearr_33706_33863[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (8))){
var inst_33178 = (state_33520[(84)]);
var inst_33197 = (state_33520[(2)]);
var inst_33198 = fluree.db.util.core.pred_ident_QMARK_(inst_33178);
var state_33520__$1 = (function (){var statearr_33707 = state_33520;
(statearr_33707[(22)] = inst_33197);

return statearr_33707;
})();
if(inst_33198){
var statearr_33708_33864 = state_33520__$1;
(statearr_33708_33864[(1)] = (10));

} else {
var statearr_33709_33865 = state_33520__$1;
(statearr_33709_33865[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (49))){
var state_33520__$1 = state_33520;
var statearr_33710_33866 = state_33520__$1;
(statearr_33710_33866[(2)] = fluree.db.util.core.min_integer);

(statearr_33710_33866[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33521 === (84))){
var inst_33308 = (state_33520[(14)]);
var state_33520__$1 = state_33520;
var statearr_33711_33867 = state_33520__$1;
(statearr_33711_33867[(2)] = inst_33308);

(statearr_33711_33867[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__17178__auto__ = null;
var fluree$db$query$range$state_machine__17178__auto____0 = (function (){
var statearr_33712 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33712[(0)] = fluree$db$query$range$state_machine__17178__auto__);

(statearr_33712[(1)] = (1));

return statearr_33712;
});
var fluree$db$query$range$state_machine__17178__auto____1 = (function (state_33520){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_33520);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e33713){var ex__17181__auto__ = e33713;
var statearr_33714_33868 = state_33520;
(statearr_33714_33868[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_33520[(4)]))){
var statearr_33715_33869 = state_33520;
(statearr_33715_33869[(1)] = cljs.core.first((state_33520[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33870 = state_33520;
state_33520 = G__33870;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__17178__auto__ = function(state_33520){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__17178__auto____1.call(this,state_33520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__17178__auto____0;
fluree$db$query$range$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__17178__auto____1;
return fluree$db$query$range$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_33716 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_33716[(6)] = c__17304__auto__);

return statearr_33716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_33926){
var state_val_33927 = (state_33926[(1)]);
if((state_val_33927 === (7))){
var inst_33890 = (state_33926[(7)]);
var inst_33900 = (state_33926[(8)]);
var inst_33898 = fluree.db.flake.Flake__GT_parts(inst_33890);
var inst_33899 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33898,(0),null);
var inst_33900__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33898,(1),null);
var inst_33901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33898,(2),null);
var inst_33902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33898,(3),null);
var inst_33903 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33898,(4),null);
var inst_33904 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33898,(5),null);
var inst_33905 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_33901,inst_33900__$1);
var state_33926__$1 = (function (){var statearr_33928 = state_33926;
(statearr_33928[(9)] = inst_33899);

(statearr_33928[(10)] = inst_33904);

(statearr_33928[(11)] = inst_33902);

(statearr_33928[(8)] = inst_33900__$1);

(statearr_33928[(12)] = inst_33903);

return statearr_33928;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33926__$1,(10),inst_33905);
} else {
if((state_val_33927 === (1))){
var inst_33878 = flakes;
var inst_33879 = cljs.core.seq(inst_33878);
var inst_33880 = cljs.core.first(inst_33879);
var inst_33881 = cljs.core.next(inst_33879);
var inst_33882 = cljs.core.PersistentVector.EMPTY;
var inst_33883 = inst_33878;
var inst_33884 = inst_33882;
var state_33926__$1 = (function (){var statearr_33929 = state_33926;
(statearr_33929[(13)] = inst_33883);

(statearr_33929[(14)] = inst_33881);

(statearr_33929[(15)] = inst_33880);

(statearr_33929[(16)] = inst_33884);

return statearr_33929;
})();
var statearr_33930_33948 = state_33926__$1;
(statearr_33930_33948[(2)] = null);

(statearr_33930_33948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33927 === (4))){
var inst_33890 = (state_33926[(7)]);
var inst_33893 = fluree.db.query.range.is_tag_flake_QMARK_(inst_33890);
var state_33926__$1 = state_33926;
if(inst_33893){
var statearr_33931_33949 = state_33926__$1;
(statearr_33931_33949[(1)] = (7));

} else {
var statearr_33932_33950 = state_33926__$1;
(statearr_33932_33950[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33927 === (6))){
var inst_33922 = (state_33926[(2)]);
var state_33926__$1 = state_33926;
var statearr_33933_33951 = state_33926__$1;
(statearr_33933_33951[(2)] = inst_33922);

(statearr_33933_33951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33927 === (3))){
var inst_33924 = (state_33926[(2)]);
var state_33926__$1 = state_33926;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33926__$1,inst_33924);
} else {
if((state_val_33927 === (2))){
var inst_33883 = (state_33926[(13)]);
var inst_33890 = (state_33926[(7)]);
var inst_33889 = cljs.core.seq(inst_33883);
var inst_33890__$1 = cljs.core.first(inst_33889);
var inst_33891 = cljs.core.next(inst_33889);
var state_33926__$1 = (function (){var statearr_33934 = state_33926;
(statearr_33934[(7)] = inst_33890__$1);

(statearr_33934[(17)] = inst_33891);

return statearr_33934;
})();
if(cljs.core.truth_(inst_33890__$1)){
var statearr_33935_33952 = state_33926__$1;
(statearr_33935_33952[(1)] = (4));

} else {
var statearr_33936_33953 = state_33926__$1;
(statearr_33936_33953[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33927 === (9))){
var inst_33919 = (state_33926[(2)]);
var state_33926__$1 = state_33926;
var statearr_33937_33954 = state_33926__$1;
(statearr_33937_33954[(2)] = inst_33919);

(statearr_33937_33954[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33927 === (5))){
var inst_33884 = (state_33926[(16)]);
var state_33926__$1 = state_33926;
var statearr_33938_33955 = state_33926__$1;
(statearr_33938_33955[(2)] = inst_33884);

(statearr_33938_33955[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33927 === (10))){
var inst_33899 = (state_33926[(9)]);
var inst_33904 = (state_33926[(10)]);
var inst_33902 = (state_33926[(11)]);
var inst_33891 = (state_33926[(17)]);
var inst_33900 = (state_33926[(8)]);
var inst_33903 = (state_33926[(12)]);
var inst_33884 = (state_33926[(16)]);
var inst_33907 = (state_33926[(2)]);
var inst_33908 = fluree.db.util.async.throw_err(inst_33907);
var inst_33909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33910 = [inst_33899,inst_33900,inst_33908,inst_33902,inst_33903,inst_33904];
var inst_33911 = (new cljs.core.PersistentVector(null,6,(5),inst_33909,inst_33910,null));
var inst_33912 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_33911);
var inst_33913 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33884,inst_33912);
var inst_33883 = inst_33891;
var inst_33884__$1 = inst_33913;
var state_33926__$1 = (function (){var statearr_33939 = state_33926;
(statearr_33939[(13)] = inst_33883);

(statearr_33939[(16)] = inst_33884__$1);

return statearr_33939;
})();
var statearr_33940_33956 = state_33926__$1;
(statearr_33940_33956[(2)] = null);

(statearr_33940_33956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33927 === (8))){
var inst_33890 = (state_33926[(7)]);
var inst_33891 = (state_33926[(17)]);
var inst_33884 = (state_33926[(16)]);
var inst_33916 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33884,inst_33890);
var inst_33883 = inst_33891;
var inst_33884__$1 = inst_33916;
var state_33926__$1 = (function (){var statearr_33941 = state_33926;
(statearr_33941[(13)] = inst_33883);

(statearr_33941[(16)] = inst_33884__$1);

return statearr_33941;
})();
var statearr_33942_33957 = state_33926__$1;
(statearr_33942_33957[(2)] = null);

(statearr_33942_33957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__17178__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__17178__auto____0 = (function (){
var statearr_33943 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33943[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__17178__auto__);

(statearr_33943[(1)] = (1));

return statearr_33943;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__17178__auto____1 = (function (state_33926){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_33926);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e33944){var ex__17181__auto__ = e33944;
var statearr_33945_33958 = state_33926;
(statearr_33945_33958[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_33926[(4)]))){
var statearr_33946_33959 = state_33926;
(statearr_33946_33959[(1)] = cljs.core.first((state_33926[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33960 = state_33926;
state_33926 = G__33960;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__17178__auto__ = function(state_33926){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__17178__auto____1.call(this,state_33926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__17178__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__17178__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_33947 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_33947[(6)] = c__17304__auto__);

return statearr_33947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__33962 = arguments.length;
switch (G__33962) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_34132){
var state_val_34133 = (state_34132[(1)]);
if((state_val_34133 === (65))){
var state_34132__$1 = state_34132;
var statearr_34134_34234 = state_34132__$1;
(statearr_34134_34234[(2)] = null);

(statearr_34134_34234[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (70))){
var inst_34127 = (state_34132[(2)]);
var _ = (function (){var statearr_34135 = state_34132;
(statearr_34135[(4)] = cljs.core.rest((state_34132[(4)])));

return statearr_34135;
})();
var state_34132__$1 = state_34132;
var statearr_34136_34235 = state_34132__$1;
(statearr_34136_34235[(2)] = inst_34127);

(statearr_34136_34235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (62))){
var inst_34113 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
var statearr_34137_34236 = state_34132__$1;
(statearr_34137_34236[(2)] = inst_34113);

(statearr_34137_34236[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (7))){
var state_34132__$1 = state_34132;
var statearr_34138_34237 = state_34132__$1;
(statearr_34138_34237[(2)] = false);

(statearr_34138_34237[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (59))){
var inst_34087 = (state_34132[(2)]);
var inst_34088 = fluree.db.util.async.throw_err(inst_34087);
var state_34132__$1 = state_34132;
var statearr_34139_34238 = state_34132__$1;
(statearr_34139_34238[(2)] = inst_34088);

(statearr_34139_34238[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (20))){
var state_34132__$1 = state_34132;
var statearr_34140_34239 = state_34132__$1;
(statearr_34140_34239[(2)] = null);

(statearr_34140_34239[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (58))){
var inst_34077 = (state_34132[(2)]);
var inst_34078 = fluree.db.util.async.throw_err(inst_34077);
var inst_34079 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_34078);
var state_34132__$1 = state_34132;
var statearr_34141_34240 = state_34132__$1;
(statearr_34141_34240[(2)] = inst_34079);

(statearr_34141_34240[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (60))){
var inst_33973 = (state_34132[(7)]);
var inst_33974 = (state_34132[(8)]);
var inst_33976 = (state_34132[(9)]);
var inst_34013 = (state_34132[(10)]);
var inst_34093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34094 = [inst_33974,inst_33973,inst_34013,inst_33976];
var inst_34095 = (new cljs.core.PersistentVector(null,4,(5),inst_34093,inst_34094,null));
var inst_34096 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_34095,opts);
var state_34132__$1 = state_34132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34132__$1,(63),inst_34096);
} else {
if((state_val_34133 === (27))){
var inst_34024 = (state_34132[(11)]);
var inst_34013 = (state_34132[(10)]);
var inst_34024__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_34013);
var state_34132__$1 = (function (){var statearr_34142 = state_34132;
(statearr_34142[(11)] = inst_34024__$1);

return statearr_34142;
})();
if(inst_34024__$1){
var statearr_34143_34241 = state_34132__$1;
(statearr_34143_34241[(1)] = (30));

} else {
var statearr_34144_34242 = state_34132__$1;
(statearr_34144_34242[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (1))){
var state_34132__$1 = state_34132;
var statearr_34145_34243 = state_34132__$1;
(statearr_34145_34243[(2)] = null);

(statearr_34145_34243[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (69))){
var inst_34119 = (state_34132[(12)]);
var state_34132__$1 = state_34132;
var statearr_34146_34244 = state_34132__$1;
(statearr_34146_34244[(2)] = inst_34119);

(statearr_34146_34244[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (24))){
var inst_33974 = (state_34132[(8)]);
var state_34132__$1 = state_34132;
if(cljs.core.truth_(inst_33974)){
var statearr_34147_34245 = state_34132__$1;
(statearr_34147_34245[(1)] = (27));

} else {
var statearr_34148_34246 = state_34132__$1;
(statearr_34148_34246[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (55))){
var inst_34013 = (state_34132[(10)]);
var inst_34071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34072 = [inst_34013];
var inst_34073 = (new cljs.core.PersistentVector(null,1,(5),inst_34071,inst_34072,null));
var inst_34074 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_34075 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_34073,inst_34074);
var state_34132__$1 = state_34132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34132__$1,(58),inst_34075);
} else {
if((state_val_34133 === (39))){
var inst_34044 = (state_34132[(2)]);
var inst_34045 = fluree.db.util.async.throw_err(inst_34044);
var state_34132__$1 = state_34132;
var statearr_34149_34247 = state_34132__$1;
(statearr_34149_34247[(2)] = inst_34045);

(statearr_34149_34247[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (46))){
var inst_34057 = (state_34132[(13)]);
var inst_34057__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_34132__$1 = (function (){var statearr_34150 = state_34132;
(statearr_34150[(13)] = inst_34057__$1);

return statearr_34150;
})();
if(cljs.core.truth_(inst_34057__$1)){
var statearr_34151_34248 = state_34132__$1;
(statearr_34151_34248[(1)] = (49));

} else {
var statearr_34152_34249 = state_34132__$1;
(statearr_34152_34249[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (4))){
var inst_33963 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
var statearr_34153_34250 = state_34132__$1;
(statearr_34153_34250[(2)] = inst_33963);

(statearr_34153_34250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (54))){
var inst_34069 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
if(cljs.core.truth_(inst_34069)){
var statearr_34154_34251 = state_34132__$1;
(statearr_34154_34251[(1)] = (55));

} else {
var statearr_34155_34252 = state_34132__$1;
(statearr_34155_34252[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (15))){
var inst_33975 = (state_34132[(14)]);
var inst_33994 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_33975);
var state_34132__$1 = state_34132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34132__$1,(18),inst_33994);
} else {
if((state_val_34133 === (48))){
var inst_34115 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
var statearr_34156_34253 = state_34132__$1;
(statearr_34156_34253[(2)] = inst_34115);

(statearr_34156_34253[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (50))){
var inst_33988 = (state_34132[(15)]);
var inst_33973 = (state_34132[(7)]);
var inst_33974 = (state_34132[(8)]);
var inst_33983 = (state_34132[(16)]);
var inst_34057 = (state_34132[(13)]);
var inst_33976 = (state_34132[(9)]);
var inst_33972 = (state_34132[(17)]);
var inst_33977 = (state_34132[(18)]);
var inst_34013 = (state_34132[(10)]);
var inst_34061 = (function (){var t = inst_33976;
var vec__33969 = inst_33972;
var p = inst_33974;
var idx_predicate_QMARK_ = inst_33977;
var o = inst_34013;
var tag_predicate_QMARK_ = inst_33983;
var temp__5751__auto__ = inst_34057;
var s = inst_33973;
var o_coerce_QMARK_ = inst_33988;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_34132__$1 = state_34132;
var statearr_34157_34254 = state_34132__$1;
(statearr_34157_34254[(2)] = inst_34061);

(statearr_34157_34254[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (21))){
var inst_34009 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
var statearr_34158_34255 = state_34132__$1;
(statearr_34158_34255[(2)] = inst_34009);

(statearr_34158_34255[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (31))){
var inst_34024 = (state_34132[(11)]);
var state_34132__$1 = state_34132;
var statearr_34159_34256 = state_34132__$1;
(statearr_34159_34256[(2)] = inst_34024);

(statearr_34159_34256[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (32))){
var inst_34034 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
var statearr_34160_34257 = state_34132__$1;
(statearr_34160_34257[(2)] = inst_34034);

(statearr_34160_34257[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (40))){
var inst_34048 = (state_34132[(19)]);
var inst_33977 = (state_34132[(18)]);
var inst_34048__$1 = cljs.core.not(inst_33977);
var state_34132__$1 = (function (){var statearr_34161 = state_34132;
(statearr_34161[(19)] = inst_34048__$1);

return statearr_34161;
})();
if(inst_34048__$1){
var statearr_34162_34258 = state_34132__$1;
(statearr_34162_34258[(1)] = (43));

} else {
var statearr_34163_34259 = state_34132__$1;
(statearr_34163_34259[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (56))){
var inst_33973 = (state_34132[(7)]);
var inst_33974 = (state_34132[(8)]);
var inst_34063 = (state_34132[(20)]);
var inst_33976 = (state_34132[(9)]);
var inst_34081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34082 = [inst_33974,inst_33973,null,inst_33976];
var inst_34083 = (new cljs.core.PersistentVector(null,4,(5),inst_34081,inst_34082,null));
var inst_34084 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_34063);
var inst_34085 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_34083,inst_34084);
var state_34132__$1 = state_34132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34132__$1,(59),inst_34085);
} else {
if((state_val_34133 === (33))){
var inst_34013 = (state_34132[(10)]);
var inst_34027 = cljs.core.fn_QMARK_(inst_34013);
var inst_34028 = (!(inst_34027));
var state_34132__$1 = state_34132;
var statearr_34164_34260 = state_34132__$1;
(statearr_34164_34260[(2)] = inst_34028);

(statearr_34164_34260[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (13))){
var inst_33975 = (state_34132[(14)]);
var inst_33992 = fluree.db.query.range.tag_string_QMARK_(inst_33975);
var state_34132__$1 = state_34132;
if(cljs.core.truth_(inst_33992)){
var statearr_34165_34261 = state_34132__$1;
(statearr_34165_34261[(1)] = (15));

} else {
var statearr_34166_34262 = state_34132__$1;
(statearr_34166_34262[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (22))){
var inst_34005 = (state_34132[(2)]);
var inst_34006 = fluree.db.util.async.throw_err(inst_34005);
var state_34132__$1 = state_34132;
var statearr_34167_34263 = state_34132__$1;
(statearr_34167_34263[(2)] = inst_34006);

(statearr_34167_34263[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (36))){
var inst_33973 = (state_34132[(7)]);
var inst_33974 = (state_34132[(8)]);
var inst_33976 = (state_34132[(9)]);
var inst_34013 = (state_34132[(10)]);
var inst_34039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34040 = [inst_33974,inst_34013,inst_33973,inst_33976];
var inst_34041 = (new cljs.core.PersistentVector(null,4,(5),inst_34039,inst_34040,null));
var inst_34042 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_34041,opts);
var state_34132__$1 = state_34132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34132__$1,(39),inst_34042);
} else {
if((state_val_34133 === (41))){
var inst_33974 = (state_34132[(8)]);
var state_34132__$1 = state_34132;
var statearr_34168_34264 = state_34132__$1;
(statearr_34168_34264[(2)] = inst_33974);

(statearr_34168_34264[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (43))){
var inst_34013 = (state_34132[(10)]);
var state_34132__$1 = state_34132;
var statearr_34169_34265 = state_34132__$1;
(statearr_34169_34265[(2)] = inst_34013);

(statearr_34169_34265[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (61))){
var inst_34013 = (state_34132[(10)]);
var state_34132__$1 = state_34132;
if(cljs.core.truth_(inst_34013)){
var statearr_34170_34266 = state_34132__$1;
(statearr_34170_34266[(1)] = (64));

} else {
var statearr_34171_34267 = state_34132__$1;
(statearr_34171_34267[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (29))){
var inst_34037 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
if(cljs.core.truth_(inst_34037)){
var statearr_34172_34268 = state_34132__$1;
(statearr_34172_34268[(1)] = (36));

} else {
var statearr_34173_34269 = state_34132__$1;
(statearr_34173_34269[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (44))){
var inst_34048 = (state_34132[(19)]);
var state_34132__$1 = state_34132;
var statearr_34174_34270 = state_34132__$1;
(statearr_34174_34270[(2)] = inst_34048);

(statearr_34174_34270[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (6))){
var inst_33974 = (state_34132[(8)]);
var inst_33979 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_33974);
var inst_33980 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_33979);
var state_34132__$1 = state_34132;
var statearr_34175_34271 = state_34132__$1;
(statearr_34175_34271[(2)] = inst_33980);

(statearr_34175_34271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (28))){
var inst_33974 = (state_34132[(8)]);
var state_34132__$1 = state_34132;
var statearr_34176_34272 = state_34132__$1;
(statearr_34176_34272[(2)] = inst_33974);

(statearr_34176_34272[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (64))){
var inst_33973 = (state_34132[(7)]);
var inst_33974 = (state_34132[(8)]);
var inst_33976 = (state_34132[(9)]);
var inst_34013 = (state_34132[(10)]);
var inst_34102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34103 = [inst_34013,inst_33974,inst_33973,inst_33976];
var inst_34104 = (new cljs.core.PersistentVector(null,4,(5),inst_34102,inst_34103,null));
var inst_34105 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_34104,opts);
var state_34132__$1 = state_34132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34132__$1,(67),inst_34105);
} else {
if((state_val_34133 === (51))){
var inst_33974 = (state_34132[(8)]);
var inst_34064 = (state_34132[(21)]);
var inst_34063 = (state_34132[(2)]);
var inst_34064__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_33974);
var state_34132__$1 = (function (){var statearr_34177 = state_34132;
(statearr_34177[(21)] = inst_34064__$1);

(statearr_34177[(20)] = inst_34063);

return statearr_34177;
})();
if(inst_34064__$1){
var statearr_34178_34273 = state_34132__$1;
(statearr_34178_34273[(1)] = (52));

} else {
var statearr_34179_34274 = state_34132__$1;
(statearr_34179_34274[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (25))){
var inst_33983 = (state_34132[(16)]);
var inst_34119 = (state_34132[(2)]);
var state_34132__$1 = (function (){var statearr_34180 = state_34132;
(statearr_34180[(12)] = inst_34119);

return statearr_34180;
})();
if(cljs.core.truth_(inst_33983)){
var statearr_34181_34275 = state_34132__$1;
(statearr_34181_34275[(1)] = (68));

} else {
var statearr_34182_34276 = state_34132__$1;
(statearr_34182_34276[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (34))){
var inst_33977 = (state_34132[(18)]);
var state_34132__$1 = state_34132;
var statearr_34183_34277 = state_34132__$1;
(statearr_34183_34277[(2)] = inst_33977);

(statearr_34183_34277[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (17))){
var inst_34011 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
var statearr_34184_34278 = state_34132__$1;
(statearr_34184_34278[(2)] = inst_34011);

(statearr_34184_34278[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (3))){
var inst_34130 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34132__$1,inst_34130);
} else {
if((state_val_34133 === (12))){
var inst_33975 = (state_34132[(14)]);
var state_34132__$1 = state_34132;
var statearr_34185_34279 = state_34132__$1;
(statearr_34185_34279[(2)] = inst_33975);

(statearr_34185_34279[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (2))){
var inst_33974 = (state_34132[(8)]);
var inst_33972 = (state_34132[(17)]);
var _ = (function (){var statearr_34186 = state_34132;
(statearr_34186[(4)] = cljs.core.cons((5),(state_34132[(4)])));

return statearr_34186;
})();
var inst_33972__$1 = fparts;
var inst_33973 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33972__$1,(0),null);
var inst_33974__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33972__$1,(1),null);
var inst_33975 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33972__$1,(2),null);
var inst_33976 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33972__$1,(3),null);
var inst_33977 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_33974__$1);
var state_34132__$1 = (function (){var statearr_34187 = state_34132;
(statearr_34187[(7)] = inst_33973);

(statearr_34187[(8)] = inst_33974__$1);

(statearr_34187[(14)] = inst_33975);

(statearr_34187[(9)] = inst_33976);

(statearr_34187[(17)] = inst_33972__$1);

(statearr_34187[(18)] = inst_33977);

return statearr_34187;
})();
if(cljs.core.truth_(inst_33974__$1)){
var statearr_34188_34280 = state_34132__$1;
(statearr_34188_34280[(1)] = (6));

} else {
var statearr_34189_34281 = state_34132__$1;
(statearr_34189_34281[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (66))){
var inst_34111 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
var statearr_34190_34282 = state_34132__$1;
(statearr_34190_34282[(2)] = inst_34111);

(statearr_34190_34282[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (23))){
var inst_33973 = (state_34132[(7)]);
var inst_33974 = (state_34132[(8)]);
var inst_33976 = (state_34132[(9)]);
var inst_34013 = (state_34132[(10)]);
var inst_34015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34016 = [inst_33973,inst_33974,inst_34013,inst_33976];
var inst_34017 = (new cljs.core.PersistentVector(null,4,(5),inst_34015,inst_34016,null));
var inst_34018 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_34017,opts);
var state_34132__$1 = state_34132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34132__$1,(26),inst_34018);
} else {
if((state_val_34133 === (47))){
var inst_33974 = (state_34132[(8)]);
var state_34132__$1 = state_34132;
if(cljs.core.truth_(inst_33974)){
var statearr_34191_34283 = state_34132__$1;
(statearr_34191_34283[(1)] = (60));

} else {
var statearr_34192_34284 = state_34132__$1;
(statearr_34192_34284[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (35))){
var inst_34031 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
var statearr_34193_34285 = state_34132__$1;
(statearr_34193_34285[(2)] = inst_34031);

(statearr_34193_34285[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (19))){
var inst_33974 = (state_34132[(8)]);
var inst_33975 = (state_34132[(14)]);
var inst_34001 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_33974);
var inst_34002 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34001),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33975)].join('');
var inst_34003 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_34002);
var state_34132__$1 = state_34132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34132__$1,(22),inst_34003);
} else {
if((state_val_34133 === (57))){
var inst_34090 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
var statearr_34194_34286 = state_34132__$1;
(statearr_34194_34286[(2)] = inst_34090);

(statearr_34194_34286[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (68))){
var inst_34119 = (state_34132[(12)]);
var inst_34121 = fluree.db.query.range.coerce_tag_flakes(db,inst_34119);
var state_34132__$1 = state_34132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34132__$1,(71),inst_34121);
} else {
if((state_val_34133 === (11))){
var inst_33988 = (state_34132[(15)]);
var inst_33988__$1 = (state_34132[(2)]);
var inst_33989 = cljs.core.not(inst_33988__$1);
var state_34132__$1 = (function (){var statearr_34196 = state_34132;
(statearr_34196[(15)] = inst_33988__$1);

return statearr_34196;
})();
if(inst_33989){
var statearr_34197_34287 = state_34132__$1;
(statearr_34197_34287[(1)] = (12));

} else {
var statearr_34198_34288 = state_34132__$1;
(statearr_34198_34288[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (9))){
var inst_33975 = (state_34132[(14)]);
var inst_33985 = typeof inst_33975 === 'string';
var state_34132__$1 = state_34132;
var statearr_34199_34289 = state_34132__$1;
(statearr_34199_34289[(2)] = inst_33985);

(statearr_34199_34289[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (5))){
var _ = (function (){var statearr_34200 = state_34132;
(statearr_34200[(4)] = cljs.core.rest((state_34132[(4)])));

return statearr_34200;
})();
var state_34132__$1 = state_34132;
var ex34195 = (state_34132__$1[(2)]);
var statearr_34201_34290 = state_34132__$1;
(statearr_34201_34290[(5)] = ex34195);


if((ex34195 instanceof Error)){
var statearr_34202_34291 = state_34132__$1;
(statearr_34202_34291[(1)] = (4));

(statearr_34202_34291[(5)] = null);

} else {
throw ex34195;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (14))){
var inst_33973 = (state_34132[(7)]);
var inst_34013 = (state_34132[(2)]);
var state_34132__$1 = (function (){var statearr_34203 = state_34132;
(statearr_34203[(10)] = inst_34013);

return statearr_34203;
})();
if(cljs.core.truth_(inst_33973)){
var statearr_34204_34292 = state_34132__$1;
(statearr_34204_34292[(1)] = (23));

} else {
var statearr_34205_34293 = state_34132__$1;
(statearr_34205_34293[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (45))){
var inst_34052 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
var statearr_34206_34294 = state_34132__$1;
(statearr_34206_34294[(2)] = inst_34052);

(statearr_34206_34294[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (53))){
var inst_34064 = (state_34132[(21)]);
var state_34132__$1 = state_34132;
var statearr_34207_34295 = state_34132__$1;
(statearr_34207_34295[(2)] = inst_34064);

(statearr_34207_34295[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (26))){
var inst_34020 = (state_34132[(2)]);
var inst_34021 = fluree.db.util.async.throw_err(inst_34020);
var state_34132__$1 = state_34132;
var statearr_34208_34296 = state_34132__$1;
(statearr_34208_34296[(2)] = inst_34021);

(statearr_34208_34296[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (16))){
var inst_33975 = (state_34132[(14)]);
var inst_33999 = typeof inst_33975 === 'string';
var state_34132__$1 = state_34132;
if(cljs.core.truth_(inst_33999)){
var statearr_34209_34297 = state_34132__$1;
(statearr_34209_34297[(1)] = (19));

} else {
var statearr_34210_34298 = state_34132__$1;
(statearr_34210_34298[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (38))){
var inst_34117 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
var statearr_34211_34299 = state_34132__$1;
(statearr_34211_34299[(2)] = inst_34117);

(statearr_34211_34299[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (30))){
var inst_33977 = (state_34132[(18)]);
var state_34132__$1 = state_34132;
if(cljs.core.truth_(inst_33977)){
var statearr_34212_34300 = state_34132__$1;
(statearr_34212_34300[(1)] = (33));

} else {
var statearr_34213_34301 = state_34132__$1;
(statearr_34213_34301[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (10))){
var inst_33983 = (state_34132[(16)]);
var state_34132__$1 = state_34132;
var statearr_34214_34302 = state_34132__$1;
(statearr_34214_34302[(2)] = inst_33983);

(statearr_34214_34302[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (18))){
var inst_33996 = (state_34132[(2)]);
var inst_33997 = fluree.db.util.async.throw_err(inst_33996);
var state_34132__$1 = state_34132;
var statearr_34215_34303 = state_34132__$1;
(statearr_34215_34303[(2)] = inst_33997);

(statearr_34215_34303[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (52))){
var inst_34013 = (state_34132[(10)]);
var inst_34066 = cljs.core.int_QMARK_(inst_34013);
var state_34132__$1 = state_34132;
var statearr_34216_34304 = state_34132__$1;
(statearr_34216_34304[(2)] = inst_34066);

(statearr_34216_34304[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (67))){
var inst_34107 = (state_34132[(2)]);
var inst_34108 = fluree.db.util.async.throw_err(inst_34107);
var state_34132__$1 = state_34132;
var statearr_34217_34305 = state_34132__$1;
(statearr_34217_34305[(2)] = inst_34108);

(statearr_34217_34305[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (71))){
var inst_34123 = (state_34132[(2)]);
var inst_34124 = fluree.db.util.async.throw_err(inst_34123);
var state_34132__$1 = state_34132;
var statearr_34218_34306 = state_34132__$1;
(statearr_34218_34306[(2)] = inst_34124);

(statearr_34218_34306[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (42))){
var inst_34055 = (state_34132[(2)]);
var state_34132__$1 = state_34132;
if(cljs.core.truth_(inst_34055)){
var statearr_34219_34307 = state_34132__$1;
(statearr_34219_34307[(1)] = (46));

} else {
var statearr_34220_34308 = state_34132__$1;
(statearr_34220_34308[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (37))){
var inst_33974 = (state_34132[(8)]);
var state_34132__$1 = state_34132;
if(cljs.core.truth_(inst_33974)){
var statearr_34221_34309 = state_34132__$1;
(statearr_34221_34309[(1)] = (40));

} else {
var statearr_34222_34310 = state_34132__$1;
(statearr_34222_34310[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (63))){
var inst_34098 = (state_34132[(2)]);
var inst_34099 = fluree.db.util.async.throw_err(inst_34098);
var state_34132__$1 = state_34132;
var statearr_34223_34311 = state_34132__$1;
(statearr_34223_34311[(2)] = inst_34099);

(statearr_34223_34311[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (8))){
var inst_33983 = (state_34132[(16)]);
var inst_33983__$1 = (state_34132[(2)]);
var state_34132__$1 = (function (){var statearr_34224 = state_34132;
(statearr_34224[(16)] = inst_33983__$1);

return statearr_34224;
})();
if(cljs.core.truth_(inst_33983__$1)){
var statearr_34225_34312 = state_34132__$1;
(statearr_34225_34312[(1)] = (9));

} else {
var statearr_34226_34313 = state_34132__$1;
(statearr_34226_34313[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34133 === (49))){
var inst_33988 = (state_34132[(15)]);
var inst_33973 = (state_34132[(7)]);
var inst_33974 = (state_34132[(8)]);
var inst_33983 = (state_34132[(16)]);
var inst_34057 = (state_34132[(13)]);
var inst_33976 = (state_34132[(9)]);
var inst_33972 = (state_34132[(17)]);
var inst_33977 = (state_34132[(18)]);
var inst_34013 = (state_34132[(10)]);
var inst_34059 = (function (){var obj_fn = inst_34057;
var t = inst_33976;
var vec__33969 = inst_33972;
var p = inst_33974;
var idx_predicate_QMARK_ = inst_33977;
var o = inst_34013;
var tag_predicate_QMARK_ = inst_33983;
var temp__5751__auto__ = inst_34057;
var s = inst_33973;
var o_coerce_QMARK_ = inst_33988;
return (function (x){
var and__4210__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4210__auto__;
}
});
})();
var state_34132__$1 = state_34132;
var statearr_34227_34314 = state_34132__$1;
(statearr_34227_34314[(2)] = inst_34059);

(statearr_34227_34314[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__17178__auto__ = null;
var fluree$db$query$range$state_machine__17178__auto____0 = (function (){
var statearr_34228 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34228[(0)] = fluree$db$query$range$state_machine__17178__auto__);

(statearr_34228[(1)] = (1));

return statearr_34228;
});
var fluree$db$query$range$state_machine__17178__auto____1 = (function (state_34132){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_34132);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e34229){var ex__17181__auto__ = e34229;
var statearr_34230_34315 = state_34132;
(statearr_34230_34315[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_34132[(4)]))){
var statearr_34231_34316 = state_34132;
(statearr_34231_34316[(1)] = cljs.core.first((state_34132[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34317 = state_34132;
state_34132 = G__34317;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__17178__auto__ = function(state_34132){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__17178__auto____1.call(this,state_34132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__17178__auto____0;
fluree$db$query$range$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__17178__auto____1;
return fluree$db$query$range$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_34232 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_34232[(6)] = c__17304__auto__);

return statearr_34232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__34319 = arguments.length;
switch (G__34319) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_34354){
var state_val_34355 = (state_34354[(1)]);
if((state_val_34355 === (7))){
var inst_34341 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_34342 = ["Invalid collection name: ",inst_34341].join('');
var inst_34343 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_34344 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_34345 = cljs.core.PersistentHashMap.fromArrays(inst_34343,inst_34344);
var inst_34346 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34342,inst_34345);
var inst_34347 = (function(){throw inst_34346})();
var state_34354__$1 = state_34354;
var statearr_34356_34376 = state_34354__$1;
(statearr_34356_34376[(2)] = inst_34347);

(statearr_34356_34376[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34355 === (1))){
var state_34354__$1 = state_34354;
var statearr_34357_34377 = state_34354__$1;
(statearr_34357_34377[(2)] = null);

(statearr_34357_34377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34355 === (4))){
var inst_34320 = (state_34354[(2)]);
var state_34354__$1 = state_34354;
var statearr_34358_34378 = state_34354__$1;
(statearr_34358_34378[(2)] = inst_34320);

(statearr_34358_34378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34355 === (6))){
var inst_34326 = (state_34354[(7)]);
var inst_34328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34329 = fluree.db.flake.max_subject_id(inst_34326);
var inst_34330 = [inst_34329];
var inst_34331 = (new cljs.core.PersistentVector(null,1,(5),inst_34328,inst_34330,null));
var inst_34332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34333 = fluree.db.flake.min_subject_id(inst_34326);
var inst_34334 = [inst_34333];
var inst_34335 = (new cljs.core.PersistentVector(null,1,(5),inst_34332,inst_34334,null));
var inst_34336 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_34331,cljs.core._LT__EQ_,inst_34335,opts);
var state_34354__$1 = state_34354;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34354__$1,(9),inst_34336);
} else {
if((state_val_34355 === (3))){
var inst_34352 = (state_34354[(2)]);
var state_34354__$1 = state_34354;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34354__$1,inst_34352);
} else {
if((state_val_34355 === (2))){
var inst_34326 = (state_34354[(7)]);
var _ = (function (){var statearr_34360 = state_34354;
(statearr_34360[(4)] = cljs.core.cons((5),(state_34354[(4)])));

return statearr_34360;
})();
var inst_34326__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_34354__$1 = (function (){var statearr_34361 = state_34354;
(statearr_34361[(7)] = inst_34326__$1);

return statearr_34361;
})();
if(cljs.core.truth_(inst_34326__$1)){
var statearr_34362_34379 = state_34354__$1;
(statearr_34362_34379[(1)] = (6));

} else {
var statearr_34363_34380 = state_34354__$1;
(statearr_34363_34380[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34355 === (9))){
var inst_34338 = (state_34354[(2)]);
var inst_34339 = fluree.db.util.async.throw_err(inst_34338);
var state_34354__$1 = state_34354;
var statearr_34364_34381 = state_34354__$1;
(statearr_34364_34381[(2)] = inst_34339);

(statearr_34364_34381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34355 === (5))){
var _ = (function (){var statearr_34365 = state_34354;
(statearr_34365[(4)] = cljs.core.rest((state_34354[(4)])));

return statearr_34365;
})();
var state_34354__$1 = state_34354;
var ex34359 = (state_34354__$1[(2)]);
var statearr_34366_34382 = state_34354__$1;
(statearr_34366_34382[(5)] = ex34359);


var statearr_34367_34383 = state_34354__$1;
(statearr_34367_34383[(1)] = (4));

(statearr_34367_34383[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34355 === (8))){
var inst_34349 = (state_34354[(2)]);
var _ = (function (){var statearr_34368 = state_34354;
(statearr_34368[(4)] = cljs.core.rest((state_34354[(4)])));

return statearr_34368;
})();
var state_34354__$1 = state_34354;
var statearr_34369_34384 = state_34354__$1;
(statearr_34369_34384[(2)] = inst_34349);

(statearr_34369_34384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__17178__auto__ = null;
var fluree$db$query$range$state_machine__17178__auto____0 = (function (){
var statearr_34370 = [null,null,null,null,null,null,null,null];
(statearr_34370[(0)] = fluree$db$query$range$state_machine__17178__auto__);

(statearr_34370[(1)] = (1));

return statearr_34370;
});
var fluree$db$query$range$state_machine__17178__auto____1 = (function (state_34354){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_34354);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e34371){var ex__17181__auto__ = e34371;
var statearr_34372_34385 = state_34354;
(statearr_34372_34385[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_34354[(4)]))){
var statearr_34373_34386 = state_34354;
(statearr_34373_34386[(1)] = cljs.core.first((state_34354[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34387 = state_34354;
state_34354 = G__34387;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__17178__auto__ = function(state_34354){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__17178__auto____1.call(this,state_34354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__17178__auto____0;
fluree$db$query$range$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__17178__auto____1;
return fluree$db$query$range$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_34374 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_34374[(6)] = c__17304__auto__);

return statearr_34374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__34391 = flakes;
var vec__34392 = G__34391;
var seq__34393 = cljs.core.seq(vec__34392);
var first__34394 = cljs.core.first(seq__34393);
var seq__34393__$1 = cljs.core.next(seq__34393);
var flake_SINGLEQUOTE_ = first__34394;
var r = seq__34393__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__34391__$1 = G__34391;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__34400 = G__34391__$1;
var seq__34401 = cljs.core.seq(vec__34400);
var first__34402 = cljs.core.first(seq__34401);
var seq__34401__$1 = cljs.core.next(seq__34401);
var flake_SINGLEQUOTE___$1 = first__34402;
var r__$1 = seq__34401__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e34404){var e = e34404;
return null;
}})();
var map__34403 = cmd_map;
var map__34403__$1 = cljs.core.__destructure_map(map__34403);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34403__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34403__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34403__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34403__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34403__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34403__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__34405 = r__$1;
var G__34406 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__34391__$1 = G__34405;
result_STAR___$1 = G__34406;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__34415 = blocks;
var vec__34416 = G__34415;
var seq__34417 = cljs.core.seq(vec__34416);
var first__34418 = cljs.core.first(seq__34417);
var seq__34417__$1 = cljs.core.next(seq__34417);
var block_SINGLEQUOTE_ = first__34418;
var r = seq__34417__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__34415__$1 = G__34415;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__34423 = G__34415__$1;
var seq__34424 = cljs.core.seq(vec__34423);
var first__34425 = cljs.core.first(seq__34424);
var seq__34424__$1 = cljs.core.next(seq__34424);
var block_SINGLEQUOTE___$1 = first__34425;
var r__$1 = seq__34424__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__34426 = block_SINGLEQUOTE___$1;
var map__34426__$1 = cljs.core.__destructure_map(map__34426);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34426__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34426__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34426__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__34415__$1,result_STAR___$1,map__34426,map__34426__$1,block,t,flakes,vec__34423,seq__34424,first__34425,seq__34424__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__34415,vec__34416,seq__34417,first__34418,seq__34417__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__34407_SHARP_){
var f = p1__34407_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__34415__$1,result_STAR___$1,map__34426,map__34426__$1,block,t,flakes,vec__34423,seq__34424,first__34425,seq__34424__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__34415,vec__34416,seq__34417,first__34418,seq__34417__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__34415__$1,result_STAR___$1,map__34426,map__34426__$1,block,t,flakes,prev_hash,vec__34423,seq__34424,first__34425,seq__34424__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__34415,vec__34416,seq__34417,first__34418,seq__34417__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__34408_SHARP_){
var f = p1__34408_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__34415__$1,result_STAR___$1,map__34426,map__34426__$1,block,t,flakes,prev_hash,vec__34423,seq__34424,first__34425,seq__34424__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__34415,vec__34416,seq__34417,first__34418,seq__34417__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__34415__$1,result_STAR___$1,map__34426,map__34426__$1,block,t,flakes,prev_hash,hash,vec__34423,seq__34424,first__34425,seq__34424__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__34415,vec__34416,seq__34417,first__34418,seq__34417__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__34409_SHARP_){
var f = p1__34409_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__34415__$1,result_STAR___$1,map__34426,map__34426__$1,block,t,flakes,prev_hash,hash,vec__34423,seq__34424,first__34425,seq__34424__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__34415,vec__34416,seq__34417,first__34418,seq__34417__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__34415__$1,result_STAR___$1,map__34426,map__34426__$1,block,t,flakes,prev_hash,hash,instant,vec__34423,seq__34424,first__34425,seq__34424__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__34415,vec__34416,seq__34417,first__34418,seq__34417__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__34410_SHARP_){
var f = p1__34410_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__34415__$1,result_STAR___$1,map__34426,map__34426__$1,block,t,flakes,prev_hash,hash,instant,vec__34423,seq__34424,first__34425,seq__34424__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__34415,vec__34416,seq__34417,first__34418,seq__34417__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__34415__$1,result_STAR___$1,map__34426,map__34426__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__34423,seq__34424,first__34425,seq__34424__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__34415,vec__34416,seq__34417,first__34418,seq__34417__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__34411_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__34411_SHARP_.p,(106));
});})(G__34415__$1,result_STAR___$1,map__34426,map__34426__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__34423,seq__34424,first__34425,seq__34424__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__34415,vec__34416,seq__34417,first__34418,seq__34417__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__34427 = r__$1;
var G__34428 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__34415__$1 = G__34427;
result_STAR___$1 = G__34428;
continue;
}
break;
}
});
