// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__40750 = arguments.length;
switch (G__40750) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__40751 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__40751) : f.call(null,G__40751));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__40752 = cljs.core._deref(vol);
var G__40753 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__40752,G__40753) : f.call(null,G__40752,G__40753));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__40754 = cljs.core._deref(vol);
var G__40755 = arg1;
var G__40756 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__40754,G__40755,G__40756) : f.call(null,G__40754,G__40755,G__40756));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__40757 = cljs.core._deref(vol);
var G__40758 = arg1;
var G__40759 = arg2;
var G__40760 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__40757,G__40758,G__40759,G__40760) : f.call(null,G__40757,G__40758,G__40759,G__40760));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__40763 = arguments.length;
switch (G__40763) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__40765 = null;
var G__40765__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__40765__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__40765__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__40765 = function(result,flake){
switch(arguments.length){
case 0:
return G__40765__0.call(this);
case 1:
return G__40765__1.call(this,result);
case 2:
return G__40765__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__40765.cljs$core$IFn$_invoke$arity$0 = G__40765__0;
G__40765.cljs$core$IFn$_invoke$arity$1 = G__40765__1;
G__40765.cljs$core$IFn$_invoke$arity$2 = G__40765__2;
return G__40765;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__40766 = null;
var G__40766__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__40766__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__40766__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__40766 = function(result,flakes){
switch(arguments.length){
case 0:
return G__40766__0.call(this);
case 1:
return G__40766__1.call(this,result);
case 2:
return G__40766__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__40766.cljs$core$IFn$_invoke$arity$0 = G__40766__0;
G__40766.cljs$core$IFn$_invoke$arity$1 = G__40766__1;
G__40766.cljs$core$IFn$_invoke$arity$2 = G__40766__2;
return G__40766;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__40768 = res;
var G__40768__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__40767_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__40767_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__40768):G__40768);
var G__40768__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__40768__$1):G__40768__$1);
var G__40768__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__40768__$2):G__40768__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__40768__$3);
} else {
return G__40768__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__40772 = arguments.length;
switch (G__40772) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_41211){
var state_val_41212 = (state_41211[(1)]);
if((state_val_41212 === (121))){
var inst_41134 = (state_41211[(2)]);
var inst_41135 = fluree.db.util.async.throw_err(inst_41134);
var inst_41136 = cljs.core.seq(inst_41135);
var state_41211__$1 = state_41211;
if(inst_41136){
var statearr_41213_41427 = state_41211__$1;
(statearr_41213_41427[(1)] = (122));

} else {
var statearr_41214_41428 = state_41211__$1;
(statearr_41214_41428[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (65))){
var inst_40927 = (state_41211[(7)]);
var inst_40926 = (state_41211[(2)]);
var inst_40927__$1 = fluree.db.util.async.throw_err(inst_40926);
var inst_40928 = cljs.core.seq(inst_40927__$1);
var state_41211__$1 = (function (){var statearr_41215 = state_41211;
(statearr_41215[(7)] = inst_40927__$1);

return statearr_41215;
})();
if(inst_40928){
var statearr_41216_41429 = state_41211__$1;
(statearr_41216_41429[(1)] = (66));

} else {
var statearr_41217_41430 = state_41211__$1;
(statearr_41217_41430[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (70))){
var inst_40927 = (state_41211[(7)]);
var inst_40938 = cljs.core.count(inst_40927);
var inst_40939 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_40938);
var state_41211__$1 = state_41211;
var statearr_41218_41431 = state_41211__$1;
(statearr_41218_41431[(2)] = inst_40939);

(statearr_41218_41431[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (62))){
var inst_40917 = (state_41211[(8)]);
var inst_40920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40921 = inst_40917.o;
var inst_40922 = [inst_40921];
var inst_40923 = (new cljs.core.PersistentVector(null,1,(5),inst_40920,inst_40922,null));
var inst_40924 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_40923);
var state_41211__$1 = state_41211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41211__$1,(65),inst_40924);
} else {
if((state_val_41212 === (74))){
var inst_40911 = (state_41211[(9)]);
var state_41211__$1 = state_41211;
var statearr_41219_41432 = state_41211__$1;
(statearr_41219_41432[(2)] = inst_40911);

(statearr_41219_41432[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (110))){
var inst_41096 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_41097 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_41096);
var inst_41098 = inst_41097 === true;
var state_41211__$1 = state_41211;
if(cljs.core.truth_(inst_41098)){
var statearr_41220_41433 = state_41211__$1;
(statearr_41220_41433[(1)] = (113));

} else {
var statearr_41221_41434 = state_41211__$1;
(statearr_41221_41434[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (130))){
var inst_41206 = (state_41211[(2)]);
var _ = (function (){var statearr_41222 = state_41211;
(statearr_41222[(4)] = cljs.core.rest((state_41211[(4)])));

return statearr_41222;
})();
var state_41211__$1 = state_41211;
var statearr_41223_41435 = state_41211__$1;
(statearr_41223_41435[(2)] = inst_41206);

(statearr_41223_41435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (128))){
var inst_41181 = (state_41211[(10)]);
var inst_41184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41185 = [acc,inst_41181];
var inst_41186 = (new cljs.core.PersistentVector(null,2,(5),inst_41184,inst_41185,null));
var state_41211__$1 = state_41211;
var statearr_41224_41436 = state_41211__$1;
(statearr_41224_41436[(2)] = inst_41186);

(statearr_41224_41436[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (7))){
var inst_40784 = (state_41211[(11)]);
var state_41211__$1 = state_41211;
var statearr_41225_41437 = state_41211__$1;
(statearr_41225_41437[(2)] = inst_40784);

(statearr_41225_41437[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (59))){
var inst_41175 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41226_41438 = state_41211__$1;
(statearr_41226_41438[(2)] = inst_41175);

(statearr_41226_41438[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (86))){
var inst_41005 = (state_41211[(12)]);
var inst_41005__$1 = (state_41211[(2)]);
var state_41211__$1 = (function (){var statearr_41227 = state_41211;
(statearr_41227[(12)] = inst_41005__$1);

return statearr_41227;
})();
if(cljs.core.truth_(inst_41005__$1)){
var statearr_41228_41439 = state_41211__$1;
(statearr_41228_41439[(1)] = (88));

} else {
var statearr_41229_41440 = state_41211__$1;
(statearr_41229_41440[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (20))){
var inst_40826 = (state_41211[(13)]);
var inst_40825 = (state_41211[(14)]);
var inst_40813 = (state_41211[(15)]);
var inst_40824 = (state_41211[(2)]);
var inst_40825__$1 = cljs.core.__destructure_map(inst_40813);
var inst_40826__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40825__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_40827 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40825__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_40828 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40825__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_40829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40825__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_40830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40825__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_40831 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40825__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_41211__$1 = (function (){var statearr_41230 = state_41211;
(statearr_41230[(13)] = inst_40826__$1);

(statearr_41230[(16)] = inst_40829);

(statearr_41230[(17)] = inst_40824);

(statearr_41230[(18)] = inst_40831);

(statearr_41230[(19)] = inst_40830);

(statearr_41230[(20)] = inst_40828);

(statearr_41230[(21)] = inst_40827);

(statearr_41230[(14)] = inst_40825__$1);

return statearr_41230;
})();
if(cljs.core.truth_(inst_40826__$1)){
var statearr_41231_41441 = state_41211__$1;
(statearr_41231_41441[(1)] = (24));

} else {
var statearr_41232_41442 = state_41211__$1;
(statearr_41232_41442[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (72))){
var inst_40936 = (state_41211[(22)]);
var inst_40942 = (state_41211[(2)]);
var inst_40943 = cljs.core.seq(inst_40936);
var state_41211__$1 = (function (){var statearr_41233 = state_41211;
(statearr_41233[(23)] = inst_40942);

return statearr_41233;
})();
if(inst_40943){
var statearr_41234_41443 = state_41211__$1;
(statearr_41234_41443[(1)] = (73));

} else {
var statearr_41235_41444 = state_41211__$1;
(statearr_41235_41444[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (58))){
var inst_40813 = (state_41211[(15)]);
var inst_40958 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_40813);
var state_41211__$1 = state_41211;
if(cljs.core.truth_(inst_40958)){
var statearr_41236_41445 = state_41211__$1;
(statearr_41236_41445[(1)] = (76));

} else {
var statearr_41237_41446 = state_41211__$1;
(statearr_41237_41446[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (60))){
var inst_40910 = (state_41211[(24)]);
var inst_40917 = (state_41211[(8)]);
var inst_40916 = cljs.core.seq(inst_40910);
var inst_40917__$1 = cljs.core.first(inst_40916);
var inst_40918 = cljs.core.next(inst_40916);
var state_41211__$1 = (function (){var statearr_41238 = state_41211;
(statearr_41238[(8)] = inst_40917__$1);

(statearr_41238[(25)] = inst_40918);

return statearr_41238;
})();
if(cljs.core.truth_(inst_40917__$1)){
var statearr_41239_41447 = state_41211__$1;
(statearr_41239_41447[(1)] = (62));

} else {
var statearr_41240_41448 = state_41211__$1;
(statearr_41240_41448[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (27))){
var inst_40834 = (state_41211[(26)]);
var inst_40830 = (state_41211[(19)]);
var inst_40834__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_40830);
var state_41211__$1 = (function (){var statearr_41241 = state_41211;
(statearr_41241[(26)] = inst_40834__$1);

return statearr_41241;
})();
if(inst_40834__$1){
var statearr_41242_41449 = state_41211__$1;
(statearr_41242_41449[(1)] = (30));

} else {
var statearr_41243_41450 = state_41211__$1;
(statearr_41243_41450[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (1))){
var state_41211__$1 = state_41211;
var statearr_41244_41451 = state_41211__$1;
(statearr_41244_41451[(2)] = null);

(statearr_41244_41451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (69))){
var inst_40932 = (state_41211[(2)]);
var inst_40933 = fluree.db.util.async.throw_err(inst_40932);
var state_41211__$1 = state_41211;
var statearr_41245_41452 = state_41211__$1;
(statearr_41245_41452[(2)] = inst_40933);

(statearr_41245_41452[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (101))){
var inst_41089 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41246_41453 = state_41211__$1;
(statearr_41246_41453[(2)] = inst_41089);

(statearr_41246_41453[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (24))){
var inst_40830 = (state_41211[(19)]);
var state_41211__$1 = state_41211;
if(cljs.core.truth_(inst_40830)){
var statearr_41247_41454 = state_41211__$1;
(statearr_41247_41454[(1)] = (27));

} else {
var statearr_41248_41455 = state_41211__$1;
(statearr_41248_41455[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (102))){
var inst_41061 = (state_41211[(27)]);
var inst_41060 = (state_41211[(2)]);
var inst_41061__$1 = fluree.db.util.async.throw_err(inst_41060);
var inst_41062 = cljs.core.empty_QMARK_(inst_41061__$1);
var state_41211__$1 = (function (){var statearr_41249 = state_41211;
(statearr_41249[(27)] = inst_41061__$1);

return statearr_41249;
})();
if(inst_41062){
var statearr_41250_41456 = state_41211__$1;
(statearr_41250_41456[(1)] = (103));

} else {
var statearr_41251_41457 = state_41211__$1;
(statearr_41251_41457[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (135))){
var state_41211__$1 = state_41211;
var statearr_41252_41458 = state_41211__$1;
(statearr_41252_41458[(2)] = null);

(statearr_41252_41458[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (55))){
var inst_40813 = (state_41211[(15)]);
var inst_40886 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_40813);
var state_41211__$1 = state_41211;
var statearr_41253_41459 = state_41211__$1;
(statearr_41253_41459[(2)] = inst_40886);

(statearr_41253_41459[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (85))){
var inst_40980 = (state_41211[(28)]);
var inst_40813 = (state_41211[(15)]);
var inst_40992 = inst_40980.o;
var inst_40993 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_40813);
var inst_40994 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_40992,inst_40993);
var state_41211__$1 = state_41211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41211__$1,(87),inst_40994);
} else {
if((state_val_41212 === (39))){
var inst_40829 = (state_41211[(16)]);
var inst_40861 = (state_41211[(29)]);
var inst_40861__$1 = cljs.core.not(inst_40829);
var state_41211__$1 = (function (){var statearr_41254 = state_41211;
(statearr_41254[(29)] = inst_40861__$1);

return statearr_41254;
})();
if(inst_40861__$1){
var statearr_41255_41460 = state_41211__$1;
(statearr_41255_41460[(1)] = (42));

} else {
var statearr_41256_41461 = state_41211__$1;
(statearr_41256_41461[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (88))){
var inst_41005 = (state_41211[(12)]);
var inst_40974 = (state_41211[(30)]);
var inst_41007 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40974,inst_41005);
var state_41211__$1 = state_41211;
var statearr_41257_41462 = state_41211__$1;
(statearr_41257_41462[(2)] = inst_41007);

(statearr_41257_41462[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (46))){
var inst_40828 = (state_41211[(20)]);
var state_41211__$1 = state_41211;
var statearr_41258_41463 = state_41211__$1;
(statearr_41258_41463[(2)] = inst_40828);

(statearr_41258_41463[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (4))){
var inst_40773 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41259_41464 = state_41211__$1;
(statearr_41259_41464[(2)] = inst_40773);

(statearr_41259_41464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (77))){
var inst_41020 = (state_41211[(31)]);
var inst_41020__$1 = componentFollow_QMARK_;
var state_41211__$1 = (function (){var statearr_41260 = state_41211;
(statearr_41260[(31)] = inst_41020__$1);

return statearr_41260;
})();
if(cljs.core.truth_(inst_41020__$1)){
var statearr_41261_41465 = state_41211__$1;
(statearr_41261_41465[(1)] = (91));

} else {
var statearr_41262_41466 = state_41211__$1;
(statearr_41262_41466[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (106))){
var inst_41041 = (state_41211[(32)]);
var inst_41075 = (state_41211[(2)]);
var inst_41076 = fluree.db.util.async.throw_err(inst_41075);
var inst_41077 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41041,inst_41076);
var state_41211__$1 = state_41211;
var statearr_41263_41467 = state_41211__$1;
(statearr_41263_41467[(2)] = inst_41077);

(statearr_41263_41467[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (119))){
var inst_41119 = (state_41211[(33)]);
var inst_41149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41150 = [inst_41119,offset_map];
var inst_41151 = (new cljs.core.PersistentVector(null,2,(5),inst_41149,inst_41150,null));
var state_41211__$1 = state_41211;
var statearr_41264_41468 = state_41211__$1;
(statearr_41264_41468[(2)] = inst_41151);

(statearr_41264_41468[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (95))){
var inst_40827 = (state_41211[(21)]);
var state_41211__$1 = state_41211;
if(cljs.core.truth_(inst_40827)){
var statearr_41265_41469 = state_41211__$1;
(statearr_41265_41469[(1)] = (110));

} else {
var statearr_41266_41470 = state_41211__$1;
(statearr_41266_41470[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (54))){
var inst_40883 = (state_41211[(34)]);
var state_41211__$1 = state_41211;
var statearr_41267_41471 = state_41211__$1;
(statearr_41267_41471[(2)] = inst_40883);

(statearr_41267_41471[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (92))){
var inst_41020 = (state_41211[(31)]);
var state_41211__$1 = state_41211;
var statearr_41268_41472 = state_41211__$1;
(statearr_41268_41472[(2)] = inst_41020);

(statearr_41268_41472[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (104))){
var inst_40783 = (state_41211[(35)]);
var inst_41061 = (state_41211[(27)]);
var inst_41070 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_41071 = [true,inst_40783];
var inst_41072 = cljs.core.PersistentHashMap.fromArrays(inst_41070,inst_41071);
var inst_41073 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_41072,inst_41061) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_41072,inst_41061));
var state_41211__$1 = state_41211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41211__$1,(106),inst_41073);
} else {
if((state_val_41212 === (15))){
var inst_40783 = (state_41211[(35)]);
var inst_40806 = (state_41211[(36)]);
var inst_40810 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40806,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_40783);
var state_41211__$1 = state_41211;
var statearr_41269_41473 = state_41211__$1;
(statearr_41269_41473[(2)] = inst_40810);

(statearr_41269_41473[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (48))){
var inst_40877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40878 = [null,offset_map];
var inst_40879 = (new cljs.core.PersistentVector(null,2,(5),inst_40877,inst_40878,null));
var state_41211__$1 = state_41211;
var statearr_41270_41474 = state_41211__$1;
(statearr_41270_41474[(2)] = inst_40879);

(statearr_41270_41474[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (50))){
var inst_41177 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41271_41475 = state_41211__$1;
(statearr_41271_41475[(2)] = inst_41177);

(statearr_41271_41475[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (116))){
var inst_41118 = (state_41211[(37)]);
var inst_41125 = (state_41211[(38)]);
var inst_41124 = cljs.core.seq(inst_41118);
var inst_41125__$1 = cljs.core.first(inst_41124);
var inst_41126 = cljs.core.next(inst_41124);
var state_41211__$1 = (function (){var statearr_41272 = state_41211;
(statearr_41272[(39)] = inst_41126);

(statearr_41272[(38)] = inst_41125__$1);

return statearr_41272;
})();
if(cljs.core.truth_(inst_41125__$1)){
var statearr_41273_41476 = state_41211__$1;
(statearr_41273_41476[(1)] = (118));

} else {
var statearr_41274_41477 = state_41211__$1;
(statearr_41274_41477[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (75))){
var inst_40918 = (state_41211[(25)]);
var inst_40948 = (state_41211[(2)]);
var inst_40910 = inst_40918;
var inst_40911 = inst_40948;
var state_41211__$1 = (function (){var statearr_41275 = state_41211;
(statearr_41275[(24)] = inst_40910);

(statearr_41275[(9)] = inst_40911);

return statearr_41275;
})();
var statearr_41276_41478 = state_41211__$1;
(statearr_41276_41478[(2)] = null);

(statearr_41276_41478[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (99))){
var inst_41047 = (state_41211[(40)]);
var inst_40813 = (state_41211[(15)]);
var inst_41050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41051 = inst_41047.o;
var inst_41052 = [inst_41051];
var inst_41053 = (new cljs.core.PersistentVector(null,1,(5),inst_41050,inst_41052,null));
var inst_41054 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_41055 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_40813);
var inst_41056 = [inst_41055];
var inst_41057 = cljs.core.PersistentHashMap.fromArrays(inst_41054,inst_41056);
var inst_41058 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_41053,inst_41057);
var state_41211__$1 = state_41211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41211__$1,(102),inst_41058);
} else {
if((state_val_41212 === (21))){
var inst_40817 = (state_41211[(41)]);
var state_41211__$1 = state_41211;
var statearr_41277_41479 = state_41211__$1;
(statearr_41277_41479[(2)] = inst_40817);

(statearr_41277_41479[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (31))){
var inst_40834 = (state_41211[(26)]);
var state_41211__$1 = state_41211;
var statearr_41278_41480 = state_41211__$1;
(statearr_41278_41480[(2)] = inst_40834);

(statearr_41278_41480[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (113))){
var inst_40783 = (state_41211[(35)]);
var inst_40826 = (state_41211[(13)]);
var inst_40829 = (state_41211[(16)]);
var inst_40824 = (state_41211[(17)]);
var inst_40831 = (state_41211[(18)]);
var inst_40830 = (state_41211[(19)]);
var inst_40828 = (state_41211[(20)]);
var inst_40827 = (state_41211[(21)]);
var inst_40825 = (state_41211[(14)]);
var inst_40798 = (state_41211[(42)]);
var inst_40813 = (state_41211[(15)]);
var inst_41100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41101 = (function (){var p = inst_40831;
var pred_spec__$1 = inst_40798;
var orderBy = inst_40829;
var multi_QMARK_ = inst_40826;
var limit = inst_40828;
var map__40779 = inst_40825;
var offset = inst_40830;
var k = inst_40824;
var compact_QMARK_ = inst_40783;
var pred_spec_SINGLEQUOTE_ = inst_40813;
var ref_QMARK_ = inst_40827;
return (function (p1__40769_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__40769_SHARP_.o]);
});
})();
var inst_41102 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_41101,flakes);
var inst_41103 = [inst_41102,offset_map];
var inst_41104 = (new cljs.core.PersistentVector(null,2,(5),inst_41100,inst_41103,null));
var state_41211__$1 = state_41211;
var statearr_41279_41481 = state_41211__$1;
(statearr_41279_41481[(2)] = inst_41104);

(statearr_41279_41481[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (32))){
var inst_40840 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41280_41482 = state_41211__$1;
(statearr_41280_41482[(2)] = inst_40840);

(statearr_41280_41482[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (136))){
var inst_41202 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41281_41483 = state_41211__$1;
(statearr_41281_41483[(2)] = inst_41202);

(statearr_41281_41483[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (40))){
var inst_40826 = (state_41211[(13)]);
var state_41211__$1 = state_41211;
var statearr_41282_41484 = state_41211__$1;
(statearr_41282_41484[(2)] = inst_40826);

(statearr_41282_41484[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (129))){
var inst_40826 = (state_41211[(13)]);
var state_41211__$1 = state_41211;
if(cljs.core.truth_(inst_40826)){
var statearr_41283_41485 = state_41211__$1;
(statearr_41283_41485[(1)] = (131));

} else {
var statearr_41284_41486 = state_41211__$1;
(statearr_41284_41486[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (91))){
var inst_40813 = (state_41211[(15)]);
var inst_41022 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_40813);
var state_41211__$1 = state_41211;
var statearr_41285_41487 = state_41211__$1;
(statearr_41285_41487[(2)] = inst_41022);

(statearr_41285_41487[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (117))){
var inst_41155 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41286_41488 = state_41211__$1;
(statearr_41286_41488[(2)] = inst_41155);

(statearr_41286_41488[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (108))){
var state_41211__$1 = state_41211;
var statearr_41287_41489 = state_41211__$1;
(statearr_41287_41489[(2)] = null);

(statearr_41287_41489[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (56))){
var inst_40888 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41288_41490 = state_41211__$1;
(statearr_41288_41490[(2)] = inst_40888);

(statearr_41288_41490[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (33))){
var inst_40831 = (state_41211[(18)]);
var inst_40848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40849 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_40831);
var state_41211__$1 = (function (){var statearr_41289 = state_41211;
(statearr_41289[(43)] = inst_40848);

return statearr_41289;
})();
if(cljs.core.truth_(inst_40849)){
var statearr_41290_41491 = state_41211__$1;
(statearr_41290_41491[(1)] = (36));

} else {
var statearr_41291_41492 = state_41211__$1;
(statearr_41291_41492[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (13))){
var inst_40798 = (state_41211[(42)]);
var state_41211__$1 = state_41211;
var statearr_41292_41493 = state_41211__$1;
(statearr_41292_41493[(2)] = inst_40798);

(statearr_41292_41493[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (22))){
var inst_40813 = (state_41211[(15)]);
var inst_40820 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_40813);
var state_41211__$1 = state_41211;
var statearr_41293_41494 = state_41211__$1;
(statearr_41293_41494[(2)] = inst_40820);

(statearr_41293_41494[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (90))){
var inst_40981 = (state_41211[(44)]);
var inst_41010 = (state_41211[(2)]);
var inst_40973 = inst_40981;
var inst_40974 = inst_41010;
var state_41211__$1 = (function (){var statearr_41294 = state_41211;
(statearr_41294[(30)] = inst_40974);

(statearr_41294[(45)] = inst_40973);

return statearr_41294;
})();
var statearr_41295_41495 = state_41211__$1;
(statearr_41295_41495[(2)] = null);

(statearr_41295_41495[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (109))){
var inst_41048 = (state_41211[(46)]);
var inst_41079 = (state_41211[(47)]);
var inst_41085 = (state_41211[(2)]);
var inst_41040 = inst_41048;
var inst_41041 = inst_41079;
var state_41211__$1 = (function (){var statearr_41296 = state_41211;
(statearr_41296[(48)] = inst_41040);

(statearr_41296[(32)] = inst_41041);

(statearr_41296[(49)] = inst_41085);

return statearr_41296;
})();
var statearr_41297_41496 = state_41211__$1;
(statearr_41297_41496[(2)] = null);

(statearr_41297_41496[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (36))){
var inst_40831 = (state_41211[(18)]);
var inst_40851 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_40831,cljs.core.dec);
var state_41211__$1 = state_41211;
var statearr_41298_41497 = state_41211__$1;
(statearr_41298_41497[(2)] = inst_40851);

(statearr_41298_41497[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (41))){
var inst_40875 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
if(cljs.core.truth_(inst_40875)){
var statearr_41299_41498 = state_41211__$1;
(statearr_41299_41498[(1)] = (48));

} else {
var statearr_41300_41499 = state_41211__$1;
(statearr_41300_41499[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (118))){
var inst_41125 = (state_41211[(38)]);
var inst_41128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41129 = inst_41125.o;
var inst_41130 = [inst_41129];
var inst_41131 = (new cljs.core.PersistentVector(null,1,(5),inst_41128,inst_41130,null));
var inst_41132 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_41131);
var state_41211__$1 = state_41211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41211__$1,(121),inst_41132);
} else {
if((state_val_41212 === (89))){
var inst_40974 = (state_41211[(30)]);
var state_41211__$1 = state_41211;
var statearr_41301_41500 = state_41211__$1;
(statearr_41301_41500[(2)] = inst_40974);

(statearr_41301_41500[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (100))){
var inst_41041 = (state_41211[(32)]);
var state_41211__$1 = state_41211;
var statearr_41302_41501 = state_41211__$1;
(statearr_41302_41501[(2)] = inst_41041);

(statearr_41302_41501[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (131))){
var inst_41181 = (state_41211[(10)]);
var inst_40824 = (state_41211[(17)]);
var inst_41180 = (state_41211[(50)]);
var inst_41189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41190 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_40824,inst_41180);
var inst_41191 = [inst_41190,inst_41181];
var inst_41192 = (new cljs.core.PersistentVector(null,2,(5),inst_41189,inst_41191,null));
var state_41211__$1 = state_41211;
var statearr_41303_41502 = state_41211__$1;
(statearr_41303_41502[(2)] = inst_41192);

(statearr_41303_41502[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (122))){
var inst_41119 = (state_41211[(33)]);
var inst_41126 = (state_41211[(39)]);
var inst_41125 = (state_41211[(38)]);
var inst_41138 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_41139 = inst_41125.o;
var inst_41140 = [inst_41139];
var inst_41141 = cljs.core.PersistentHashMap.fromArrays(inst_41138,inst_41140);
var inst_41142 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41119,inst_41141);
var inst_41118 = inst_41126;
var inst_41119__$1 = inst_41142;
var state_41211__$1 = (function (){var statearr_41304 = state_41211;
(statearr_41304[(37)] = inst_41118);

(statearr_41304[(33)] = inst_41119__$1);

return statearr_41304;
})();
var statearr_41305_41503 = state_41211__$1;
(statearr_41305_41503[(2)] = null);

(statearr_41305_41503[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (43))){
var inst_40861 = (state_41211[(29)]);
var state_41211__$1 = state_41211;
var statearr_41306_41504 = state_41211__$1;
(statearr_41306_41504[(2)] = inst_40861);

(statearr_41306_41504[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (61))){
var inst_40897 = (state_41211[(51)]);
var inst_40954 = (state_41211[(2)]);
var inst_40955 = [inst_40954,offset_map];
var inst_40956 = (new cljs.core.PersistentVector(null,2,(5),inst_40897,inst_40955,null));
var state_41211__$1 = state_41211;
var statearr_41307_41505 = state_41211__$1;
(statearr_41307_41505[(2)] = inst_40956);

(statearr_41307_41505[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (29))){
var inst_40843 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41308_41506 = state_41211__$1;
(statearr_41308_41506[(2)] = inst_40843);

(statearr_41308_41506[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (44))){
var inst_40872 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41309_41507 = state_41211__$1;
(statearr_41309_41507[(2)] = inst_40872);

(statearr_41309_41507[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (93))){
var inst_41025 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
if(cljs.core.truth_(inst_41025)){
var statearr_41310_41508 = state_41211__$1;
(statearr_41310_41508[(1)] = (94));

} else {
var statearr_41311_41509 = state_41211__$1;
(statearr_41311_41509[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (6))){
var inst_40786 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_40787 = (inst_40786 == null);
var state_41211__$1 = state_41211;
var statearr_41312_41510 = state_41211__$1;
(statearr_41312_41510[(2)] = inst_40787);

(statearr_41312_41510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (111))){
var state_41211__$1 = state_41211;
var statearr_41313_41511 = state_41211__$1;
(statearr_41313_41511[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (28))){
var inst_40830 = (state_41211[(19)]);
var state_41211__$1 = state_41211;
var statearr_41315_41512 = state_41211__$1;
(statearr_41315_41512[(2)] = inst_40830);

(statearr_41315_41512[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (134))){
var inst_41181 = (state_41211[(10)]);
var inst_40824 = (state_41211[(17)]);
var inst_41180 = (state_41211[(50)]);
var inst_41195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41196 = cljs.core.first(inst_41180);
var inst_41197 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_40824,inst_41196);
var inst_41198 = [inst_41197,inst_41181];
var inst_41199 = (new cljs.core.PersistentVector(null,2,(5),inst_41195,inst_41198,null));
var state_41211__$1 = state_41211;
var statearr_41316_41513 = state_41211__$1;
(statearr_41316_41513[(2)] = inst_41199);

(statearr_41316_41513[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (64))){
var inst_40952 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41317_41514 = state_41211__$1;
(statearr_41317_41514[(2)] = inst_40952);

(statearr_41317_41514[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (103))){
var inst_41041 = (state_41211[(32)]);
var inst_41047 = (state_41211[(40)]);
var inst_41064 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_41065 = inst_41047.o;
var inst_41066 = [inst_41065];
var inst_41067 = cljs.core.PersistentHashMap.fromArrays(inst_41064,inst_41066);
var inst_41068 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41041,inst_41067);
var state_41211__$1 = state_41211;
var statearr_41318_41515 = state_41211__$1;
(statearr_41318_41515[(2)] = inst_41068);

(statearr_41318_41515[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (51))){
var inst_40883 = (state_41211[(34)]);
var inst_40813 = (state_41211[(15)]);
var inst_40883__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_40813);
var state_41211__$1 = (function (){var statearr_41319 = state_41211;
(statearr_41319[(34)] = inst_40883__$1);

return statearr_41319;
})();
if(cljs.core.truth_(inst_40883__$1)){
var statearr_41320_41516 = state_41211__$1;
(statearr_41320_41516[(1)] = (54));

} else {
var statearr_41321_41517 = state_41211__$1;
(statearr_41321_41517[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (25))){
var inst_40826 = (state_41211[(13)]);
var state_41211__$1 = state_41211;
var statearr_41322_41518 = state_41211__$1;
(statearr_41322_41518[(2)] = inst_40826);

(statearr_41322_41518[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (34))){
var inst_40826 = (state_41211[(13)]);
var state_41211__$1 = state_41211;
if(cljs.core.truth_(inst_40826)){
var statearr_41323_41519 = state_41211__$1;
(statearr_41323_41519[(1)] = (39));

} else {
var statearr_41324_41520 = state_41211__$1;
(statearr_41324_41520[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (125))){
var inst_40783 = (state_41211[(35)]);
var inst_40826 = (state_41211[(13)]);
var inst_40829 = (state_41211[(16)]);
var inst_40824 = (state_41211[(17)]);
var inst_40831 = (state_41211[(18)]);
var inst_40830 = (state_41211[(19)]);
var inst_40828 = (state_41211[(20)]);
var inst_40827 = (state_41211[(21)]);
var inst_40825 = (state_41211[(14)]);
var inst_40798 = (state_41211[(42)]);
var inst_40813 = (state_41211[(15)]);
var inst_41160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41161 = (function (){var p = inst_40831;
var pred_spec__$1 = inst_40798;
var orderBy = inst_40829;
var multi_QMARK_ = inst_40826;
var limit = inst_40828;
var map__40779 = inst_40825;
var offset = inst_40830;
var k = inst_40824;
var compact_QMARK_ = inst_40783;
var pred_spec_SINGLEQUOTE_ = inst_40813;
var ref_QMARK_ = inst_40827;
return (function (p1__40770_SHARP_){
return p1__40770_SHARP_.o;
});
})();
var inst_41162 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_41161,flakes);
var inst_41163 = [inst_41162,offset_map];
var inst_41164 = (new cljs.core.PersistentVector(null,2,(5),inst_41160,inst_41163,null));
var state_41211__$1 = state_41211;
var statearr_41325_41521 = state_41211__$1;
(statearr_41325_41521[(2)] = inst_41164);

(statearr_41325_41521[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (17))){
var inst_40814 = (state_41211[(52)]);
var inst_40813 = (state_41211[(15)]);
var inst_40813__$1 = (state_41211[(2)]);
var inst_40814__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_40813__$1);
var state_41211__$1 = (function (){var statearr_41326 = state_41211;
(statearr_41326[(52)] = inst_40814__$1);

(statearr_41326[(15)] = inst_40813__$1);

return statearr_41326;
})();
if(cljs.core.truth_(inst_40814__$1)){
var statearr_41327_41522 = state_41211__$1;
(statearr_41327_41522[(1)] = (18));

} else {
var statearr_41328_41523 = state_41211__$1;
(statearr_41328_41523[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (3))){
var inst_41209 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41211__$1,inst_41209);
} else {
if((state_val_41212 === (12))){
var inst_40798 = (state_41211[(42)]);
var inst_40803 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40798,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_41211__$1 = state_41211;
var statearr_41329_41524 = state_41211__$1;
(statearr_41329_41524[(2)] = inst_40803);

(statearr_41329_41524[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (2))){
var inst_40784 = (state_41211[(11)]);
var _ = (function (){var statearr_41330 = state_41211;
(statearr_41330[(4)] = cljs.core.cons((5),(state_41211[(4)])));

return statearr_41330;
})();
var inst_40783 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_40784__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_41211__$1 = (function (){var statearr_41331 = state_41211;
(statearr_41331[(35)] = inst_40783);

(statearr_41331[(11)] = inst_40784__$1);

return statearr_41331;
})();
if(cljs.core.truth_(inst_40784__$1)){
var statearr_41332_41525 = state_41211__$1;
(statearr_41332_41525[(1)] = (6));

} else {
var statearr_41333_41526 = state_41211__$1;
(statearr_41333_41526[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (66))){
var inst_40896 = (state_41211[(53)]);
var inst_40927 = (state_41211[(7)]);
var inst_40930 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_40896,inst_40927) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_40896,inst_40927));
var state_41211__$1 = state_41211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41211__$1,(69),inst_40930);
} else {
if((state_val_41212 === (107))){
var inst_41061 = (state_41211[(27)]);
var inst_41081 = cljs.core.count(inst_41061);
var inst_41082 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_41081);
var state_41211__$1 = state_41211;
var statearr_41334_41527 = state_41211__$1;
(statearr_41334_41527[(2)] = inst_41082);

(statearr_41334_41527[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (23))){
var inst_40822 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41335_41528 = state_41211__$1;
(statearr_41335_41528[(2)] = inst_40822);

(statearr_41335_41528[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (47))){
var inst_40869 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41336_41529 = state_41211__$1;
(statearr_41336_41529[(2)] = inst_40869);

(statearr_41336_41529[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (35))){
var inst_41180 = (state_41211[(50)]);
var inst_41179 = (state_41211[(2)]);
var inst_41180__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41179,(0),null);
var inst_41181 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41179,(1),null);
var inst_41182 = cljs.core.empty_QMARK_(inst_41180__$1);
var state_41211__$1 = (function (){var statearr_41337 = state_41211;
(statearr_41337[(10)] = inst_41181);

(statearr_41337[(50)] = inst_41180__$1);

return statearr_41337;
})();
if(inst_41182){
var statearr_41338_41530 = state_41211__$1;
(statearr_41338_41530[(1)] = (128));

} else {
var statearr_41339_41531 = state_41211__$1;
(statearr_41339_41531[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (127))){
var inst_41167 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41340_41532 = state_41211__$1;
(statearr_41340_41532[(2)] = inst_41167);

(statearr_41340_41532[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (82))){
var inst_40974 = (state_41211[(30)]);
var state_41211__$1 = state_41211;
var statearr_41341_41533 = state_41211__$1;
(statearr_41341_41533[(2)] = inst_40974);

(statearr_41341_41533[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (76))){
var inst_40960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40968 = flakes;
var inst_40969 = cljs.core.seq(inst_40968);
var inst_40970 = cljs.core.first(inst_40969);
var inst_40971 = cljs.core.next(inst_40969);
var inst_40972 = cljs.core.PersistentVector.EMPTY;
var inst_40973 = inst_40968;
var inst_40974 = inst_40972;
var state_41211__$1 = (function (){var statearr_41342 = state_41211;
(statearr_41342[(54)] = inst_40970);

(statearr_41342[(55)] = inst_40960);

(statearr_41342[(56)] = inst_40971);

(statearr_41342[(30)] = inst_40974);

(statearr_41342[(45)] = inst_40973);

return statearr_41342;
})();
var statearr_41343_41534 = state_41211__$1;
(statearr_41343_41534[(2)] = null);

(statearr_41343_41534[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (97))){
var inst_41040 = (state_41211[(48)]);
var inst_41047 = (state_41211[(40)]);
var inst_41046 = cljs.core.seq(inst_41040);
var inst_41047__$1 = cljs.core.first(inst_41046);
var inst_41048 = cljs.core.next(inst_41046);
var state_41211__$1 = (function (){var statearr_41344 = state_41211;
(statearr_41344[(46)] = inst_41048);

(statearr_41344[(40)] = inst_41047__$1);

return statearr_41344;
})();
if(cljs.core.truth_(inst_41047__$1)){
var statearr_41345_41535 = state_41211__$1;
(statearr_41345_41535[(1)] = (99));

} else {
var statearr_41346_41536 = state_41211__$1;
(statearr_41346_41536[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (19))){
var inst_40817 = (state_41211[(41)]);
var inst_40813 = (state_41211[(15)]);
var inst_40817__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_40813);
var state_41211__$1 = (function (){var statearr_41347 = state_41211;
(statearr_41347[(41)] = inst_40817__$1);

return statearr_41347;
})();
if(cljs.core.truth_(inst_40817__$1)){
var statearr_41348_41537 = state_41211__$1;
(statearr_41348_41537[(1)] = (21));

} else {
var statearr_41349_41538 = state_41211__$1;
(statearr_41349_41538[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (57))){
var inst_40813 = (state_41211[(15)]);
var inst_40893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40894 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_40895 = (new cljs.core.PersistentVector(null,3,(5),inst_40893,inst_40894,null));
var inst_40896 = cljs.core.select_keys(inst_40813,inst_40895);
var inst_40897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40905 = flakes;
var inst_40906 = cljs.core.seq(inst_40905);
var inst_40907 = cljs.core.first(inst_40906);
var inst_40908 = cljs.core.next(inst_40906);
var inst_40909 = cljs.core.PersistentVector.EMPTY;
var inst_40910 = inst_40905;
var inst_40911 = inst_40909;
var state_41211__$1 = (function (){var statearr_41350 = state_41211;
(statearr_41350[(57)] = inst_40907);

(statearr_41350[(53)] = inst_40896);

(statearr_41350[(24)] = inst_40910);

(statearr_41350[(51)] = inst_40897);

(statearr_41350[(9)] = inst_40911);

(statearr_41350[(58)] = inst_40908);

return statearr_41350;
})();
var statearr_41351_41539 = state_41211__$1;
(statearr_41351_41539[(2)] = null);

(statearr_41351_41539[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (68))){
var inst_40936 = (state_41211[(2)]);
var state_41211__$1 = (function (){var statearr_41352 = state_41211;
(statearr_41352[(22)] = inst_40936);

return statearr_41352;
})();
if(cljs.core.truth_(fuel)){
var statearr_41353_41540 = state_41211__$1;
(statearr_41353_41540[(1)] = (70));

} else {
var statearr_41354_41541 = state_41211__$1;
(statearr_41354_41541[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (11))){
var inst_40798 = (state_41211[(42)]);
var inst_40798__$1 = (state_41211[(2)]);
var inst_40800 = cljs.core.contains_QMARK_(inst_40798__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_40801 = (!(inst_40800));
var state_41211__$1 = (function (){var statearr_41355 = state_41211;
(statearr_41355[(42)] = inst_40798__$1);

return statearr_41355;
})();
if(inst_40801){
var statearr_41356_41542 = state_41211__$1;
(statearr_41356_41542[(1)] = (12));

} else {
var statearr_41357_41543 = state_41211__$1;
(statearr_41357_41543[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (115))){
var inst_41157 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41359_41544 = state_41211__$1;
(statearr_41359_41544[(2)] = inst_41157);

(statearr_41359_41544[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (9))){
var inst_40792 = cljs.core.first(flakes);
var inst_40793 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_40792);
var inst_40794 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_40795 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_40793,inst_40794);
var state_41211__$1 = state_41211;
var statearr_41360_41545 = state_41211__$1;
(statearr_41360_41545[(2)] = inst_40795);

(statearr_41360_41545[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (5))){
var _ = (function (){var statearr_41361 = state_41211;
(statearr_41361[(4)] = cljs.core.rest((state_41211[(4)])));

return statearr_41361;
})();
var state_41211__$1 = state_41211;
var ex41358 = (state_41211__$1[(2)]);
var statearr_41362_41546 = state_41211__$1;
(statearr_41362_41546[(5)] = ex41358);


if((ex41358 instanceof Error)){
var statearr_41363_41547 = state_41211__$1;
(statearr_41363_41547[(1)] = (4));

(statearr_41363_41547[(5)] = null);

} else {
throw ex41358;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (112))){
var inst_41169 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41364_41548 = state_41211__$1;
(statearr_41364_41548[(2)] = inst_41169);

(statearr_41364_41548[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (83))){
var inst_41014 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41365_41549 = state_41211__$1;
(statearr_41365_41549[(2)] = inst_41014);

(statearr_41365_41549[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (14))){
var inst_40798 = (state_41211[(42)]);
var inst_40806 = (state_41211[(2)]);
var inst_40807 = cljs.core.contains_QMARK_(inst_40798,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_40808 = (!(inst_40807));
var state_41211__$1 = (function (){var statearr_41366 = state_41211;
(statearr_41366[(36)] = inst_40806);

return statearr_41366;
})();
if(inst_40808){
var statearr_41367_41550 = state_41211__$1;
(statearr_41367_41550[(1)] = (15));

} else {
var statearr_41368_41551 = state_41211__$1;
(statearr_41368_41551[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (45))){
var inst_40824 = (state_41211[(17)]);
var inst_40828 = (state_41211[(20)]);
var inst_40864 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_40824);
var inst_40865 = cljs.core.count(inst_40864);
var inst_40866 = (inst_40865 >= inst_40828);
var state_41211__$1 = state_41211;
var statearr_41369_41552 = state_41211__$1;
(statearr_41369_41552[(2)] = inst_40866);

(statearr_41369_41552[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (53))){
var inst_40891 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
if(cljs.core.truth_(inst_40891)){
var statearr_41370_41553 = state_41211__$1;
(statearr_41370_41553[(1)] = (57));

} else {
var statearr_41371_41554 = state_41211__$1;
(statearr_41371_41554[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (78))){
var inst_41173 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41372_41555 = state_41211__$1;
(statearr_41372_41555[(2)] = inst_41173);

(statearr_41372_41555[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (132))){
var state_41211__$1 = state_41211;
var statearr_41374_41556 = state_41211__$1;
(statearr_41374_41556[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (26))){
var inst_40846 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
if(cljs.core.truth_(inst_40846)){
var statearr_41376_41557 = state_41211__$1;
(statearr_41376_41557[(1)] = (33));

} else {
var statearr_41377_41558 = state_41211__$1;
(statearr_41377_41558[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (123))){
var inst_41119 = (state_41211[(33)]);
var inst_41126 = (state_41211[(39)]);
var tmp41373 = inst_41119;
var inst_41118 = inst_41126;
var inst_41119__$1 = tmp41373;
var state_41211__$1 = (function (){var statearr_41378 = state_41211;
(statearr_41378[(37)] = inst_41118);

(statearr_41378[(33)] = inst_41119__$1);

return statearr_41378;
})();
var statearr_41379_41559 = state_41211__$1;
(statearr_41379_41559[(2)] = null);

(statearr_41379_41559[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (16))){
var inst_40806 = (state_41211[(36)]);
var state_41211__$1 = state_41211;
var statearr_41380_41560 = state_41211__$1;
(statearr_41380_41560[(2)] = inst_40806);

(statearr_41380_41560[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (133))){
var inst_41204 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41381_41561 = state_41211__$1;
(statearr_41381_41561[(2)] = inst_41204);

(statearr_41381_41561[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (81))){
var inst_40989 = (state_41211[(59)]);
var inst_40980 = (state_41211[(28)]);
var inst_40813 = (state_41211[(15)]);
var inst_40983 = cljs.core.deref(cache);
var inst_40984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40985 = inst_40980.o;
var inst_40986 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_40813);
var inst_40987 = [inst_40985,inst_40986];
var inst_40988 = (new cljs.core.PersistentVector(null,2,(5),inst_40984,inst_40987,null));
var inst_40989__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40983,inst_40988);
var state_41211__$1 = (function (){var statearr_41382 = state_41211;
(statearr_41382[(59)] = inst_40989__$1);

return statearr_41382;
})();
if(cljs.core.truth_(inst_40989__$1)){
var statearr_41383_41562 = state_41211__$1;
(statearr_41383_41562[(1)] = (84));

} else {
var statearr_41384_41563 = state_41211__$1;
(statearr_41384_41563[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (120))){
var inst_41153 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41385_41564 = state_41211__$1;
(statearr_41385_41564[(2)] = inst_41153);

(statearr_41385_41564[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (79))){
var inst_40973 = (state_41211[(45)]);
var inst_40980 = (state_41211[(28)]);
var inst_40979 = cljs.core.seq(inst_40973);
var inst_40980__$1 = cljs.core.first(inst_40979);
var inst_40981 = cljs.core.next(inst_40979);
var state_41211__$1 = (function (){var statearr_41386 = state_41211;
(statearr_41386[(28)] = inst_40980__$1);

(statearr_41386[(44)] = inst_40981);

return statearr_41386;
})();
if(cljs.core.truth_(inst_40980__$1)){
var statearr_41387_41565 = state_41211__$1;
(statearr_41387_41565[(1)] = (81));

} else {
var statearr_41388_41566 = state_41211__$1;
(statearr_41388_41566[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (38))){
var inst_40848 = (state_41211[(43)]);
var inst_40856 = (state_41211[(2)]);
var inst_40857 = [null,inst_40856];
var inst_40858 = (new cljs.core.PersistentVector(null,2,(5),inst_40848,inst_40857,null));
var state_41211__$1 = state_41211;
var statearr_41389_41567 = state_41211__$1;
(statearr_41389_41567[(2)] = inst_40858);

(statearr_41389_41567[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (126))){
var state_41211__$1 = state_41211;
var statearr_41390_41568 = state_41211__$1;
(statearr_41390_41568[(2)] = null);

(statearr_41390_41568[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (98))){
var inst_41027 = (state_41211[(60)]);
var inst_41091 = (state_41211[(2)]);
var inst_41092 = [inst_41091,offset_map];
var inst_41093 = (new cljs.core.PersistentVector(null,2,(5),inst_41027,inst_41092,null));
var state_41211__$1 = state_41211;
var statearr_41391_41569 = state_41211__$1;
(statearr_41391_41569[(2)] = inst_41093);

(statearr_41391_41569[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (124))){
var inst_41147 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41392_41570 = state_41211__$1;
(statearr_41392_41570[(2)] = inst_41147);

(statearr_41392_41570[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (87))){
var inst_40980 = (state_41211[(28)]);
var inst_40813 = (state_41211[(15)]);
var inst_40996 = (state_41211[(2)]);
var inst_40997 = fluree.db.util.async.throw_err(inst_40996);
var inst_40998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40999 = inst_40980.o;
var inst_41000 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_40813);
var inst_41001 = [inst_40999,inst_41000];
var inst_41002 = (new cljs.core.PersistentVector(null,2,(5),inst_40998,inst_41001,null));
var inst_41003 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_41002,inst_40997);
var state_41211__$1 = (function (){var statearr_41393 = state_41211;
(statearr_41393[(61)] = inst_41003);

return statearr_41393;
})();
var statearr_41394_41571 = state_41211__$1;
(statearr_41394_41571[(2)] = inst_40997);

(statearr_41394_41571[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (30))){
var inst_40831 = (state_41211[(18)]);
var inst_40836 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_40831);
var inst_40837 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_40836);
var state_41211__$1 = state_41211;
var statearr_41395_41572 = state_41211__$1;
(statearr_41395_41572[(2)] = inst_40837);

(statearr_41395_41572[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (73))){
var inst_40936 = (state_41211[(22)]);
var inst_40911 = (state_41211[(9)]);
var inst_40945 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40911,inst_40936);
var state_41211__$1 = state_41211;
var statearr_41396_41573 = state_41211__$1;
(statearr_41396_41573[(2)] = inst_40945);

(statearr_41396_41573[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (96))){
var inst_41171 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
var statearr_41397_41574 = state_41211__$1;
(statearr_41397_41574[(2)] = inst_41171);

(statearr_41397_41574[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (10))){
var state_41211__$1 = state_41211;
var statearr_41398_41575 = state_41211__$1;
(statearr_41398_41575[(2)] = pred_spec);

(statearr_41398_41575[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (18))){
var inst_40814 = (state_41211[(52)]);
var state_41211__$1 = state_41211;
var statearr_41399_41576 = state_41211__$1;
(statearr_41399_41576[(2)] = inst_40814);

(statearr_41399_41576[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (105))){
var inst_41079 = (state_41211[(2)]);
var state_41211__$1 = (function (){var statearr_41400 = state_41211;
(statearr_41400[(47)] = inst_41079);

return statearr_41400;
})();
if(cljs.core.truth_(fuel)){
var statearr_41401_41577 = state_41211__$1;
(statearr_41401_41577[(1)] = (107));

} else {
var statearr_41402_41578 = state_41211__$1;
(statearr_41402_41578[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (52))){
var inst_40881 = (state_41211[(62)]);
var state_41211__$1 = state_41211;
var statearr_41403_41579 = state_41211__$1;
(statearr_41403_41579[(2)] = inst_40881);

(statearr_41403_41579[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (114))){
var inst_41113 = flakes;
var inst_41114 = cljs.core.seq(inst_41113);
var inst_41115 = cljs.core.first(inst_41114);
var inst_41116 = cljs.core.next(inst_41114);
var inst_41117 = cljs.core.PersistentVector.EMPTY;
var inst_41118 = inst_41113;
var inst_41119 = inst_41117;
var state_41211__$1 = (function (){var statearr_41404 = state_41211;
(statearr_41404[(37)] = inst_41118);

(statearr_41404[(33)] = inst_41119);

(statearr_41404[(63)] = inst_41115);

(statearr_41404[(64)] = inst_41116);

return statearr_41404;
})();
var statearr_41405_41580 = state_41211__$1;
(statearr_41405_41580[(2)] = null);

(statearr_41405_41580[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (67))){
var state_41211__$1 = state_41211;
var statearr_41406_41581 = state_41211__$1;
(statearr_41406_41581[(2)] = null);

(statearr_41406_41581[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (71))){
var state_41211__$1 = state_41211;
var statearr_41407_41582 = state_41211__$1;
(statearr_41407_41582[(2)] = null);

(statearr_41407_41582[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (42))){
var inst_40828 = (state_41211[(20)]);
var state_41211__$1 = state_41211;
if(cljs.core.truth_(inst_40828)){
var statearr_41408_41583 = state_41211__$1;
(statearr_41408_41583[(1)] = (45));

} else {
var statearr_41409_41584 = state_41211__$1;
(statearr_41409_41584[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (80))){
var inst_40960 = (state_41211[(55)]);
var inst_41016 = (state_41211[(2)]);
var inst_41017 = [inst_41016,offset_map];
var inst_41018 = (new cljs.core.PersistentVector(null,2,(5),inst_40960,inst_41017,null));
var state_41211__$1 = state_41211;
var statearr_41410_41585 = state_41211__$1;
(statearr_41410_41585[(2)] = inst_41018);

(statearr_41410_41585[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (37))){
var inst_40831 = (state_41211[(18)]);
var inst_40830 = (state_41211[(19)]);
var inst_40853 = (inst_40830 - (1));
var inst_40854 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_40831,inst_40853);
var state_41211__$1 = state_41211;
var statearr_41411_41586 = state_41211__$1;
(statearr_41411_41586[(2)] = inst_40854);

(statearr_41411_41586[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (63))){
var inst_40911 = (state_41211[(9)]);
var state_41211__$1 = state_41211;
var statearr_41412_41587 = state_41211__$1;
(statearr_41412_41587[(2)] = inst_40911);

(statearr_41412_41587[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (94))){
var inst_41027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41035 = flakes;
var inst_41036 = cljs.core.seq(inst_41035);
var inst_41037 = cljs.core.first(inst_41036);
var inst_41038 = cljs.core.next(inst_41036);
var inst_41039 = cljs.core.PersistentVector.EMPTY;
var inst_41040 = inst_41035;
var inst_41041 = inst_41039;
var state_41211__$1 = (function (){var statearr_41413 = state_41211;
(statearr_41413[(48)] = inst_41040);

(statearr_41413[(32)] = inst_41041);

(statearr_41413[(60)] = inst_41027);

(statearr_41413[(65)] = inst_41038);

(statearr_41413[(66)] = inst_41037);

return statearr_41413;
})();
var statearr_41414_41588 = state_41211__$1;
(statearr_41414_41588[(2)] = null);

(statearr_41414_41588[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (8))){
var inst_40790 = (state_41211[(2)]);
var state_41211__$1 = state_41211;
if(cljs.core.truth_(inst_40790)){
var statearr_41415_41589 = state_41211__$1;
(statearr_41415_41589[(1)] = (9));

} else {
var statearr_41416_41590 = state_41211__$1;
(statearr_41416_41590[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (49))){
var inst_40881 = (state_41211[(62)]);
var inst_40881__$1 = cljs.core.not(recur_QMARK_);
var state_41211__$1 = (function (){var statearr_41417 = state_41211;
(statearr_41417[(62)] = inst_40881__$1);

return statearr_41417;
})();
if(inst_40881__$1){
var statearr_41418_41591 = state_41211__$1;
(statearr_41418_41591[(1)] = (51));

} else {
var statearr_41419_41592 = state_41211__$1;
(statearr_41419_41592[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41212 === (84))){
var inst_40989 = (state_41211[(59)]);
var state_41211__$1 = state_41211;
var statearr_41420_41593 = state_41211__$1;
(statearr_41420_41593[(2)] = inst_40989);

(statearr_41420_41593[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__17178__auto__ = null;
var fluree$db$query$fql$state_machine__17178__auto____0 = (function (){
var statearr_41421 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41421[(0)] = fluree$db$query$fql$state_machine__17178__auto__);

(statearr_41421[(1)] = (1));

return statearr_41421;
});
var fluree$db$query$fql$state_machine__17178__auto____1 = (function (state_41211){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_41211);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e41422){var ex__17181__auto__ = e41422;
var statearr_41423_41594 = state_41211;
(statearr_41423_41594[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_41211[(4)]))){
var statearr_41424_41595 = state_41211;
(statearr_41424_41595[(1)] = cljs.core.first((state_41211[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41596 = state_41211;
state_41211 = G__41596;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__17178__auto__ = function(state_41211){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__17178__auto____1.call(this,state_41211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__17178__auto____0;
fluree$db$query$fql$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__17178__auto____1;
return fluree$db$query$fql$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_41425 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_41425[(6)] = c__17304__auto__);

return statearr_41425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_41756){
var state_val_41757 = (state_41756[(1)]);
if((state_val_41757 === (7))){
var inst_41751 = (state_41756[(2)]);
var _ = (function (){var statearr_41758 = state_41756;
(statearr_41758[(4)] = cljs.core.rest((state_41756[(4)])));

return statearr_41758;
})();
var state_41756__$1 = state_41756;
var statearr_41759_41841 = state_41756__$1;
(statearr_41759_41841[(2)] = inst_41751);

(statearr_41759_41841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (20))){
var inst_41678 = (state_41756[(7)]);
var state_41756__$1 = state_41756;
var statearr_41760_41842 = state_41756__$1;
(statearr_41760_41842[(2)] = inst_41678);

(statearr_41760_41842[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (27))){
var inst_41633 = (state_41756[(8)]);
var state_41756__$1 = state_41756;
if(cljs.core.truth_(inst_41633)){
var statearr_41761_41843 = state_41756__$1;
(statearr_41761_41843[(1)] = (29));

} else {
var statearr_41762_41844 = state_41756__$1;
(statearr_41762_41844[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (1))){
var state_41756__$1 = state_41756;
var statearr_41763_41845 = state_41756__$1;
(statearr_41763_41845[(2)] = null);

(statearr_41763_41845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (24))){
var inst_41634 = (state_41756[(9)]);
var state_41756__$1 = state_41756;
var statearr_41764_41846 = state_41756__$1;
(statearr_41764_41846[(2)] = inst_41634);

(statearr_41764_41846[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (39))){
var inst_41670 = (state_41756[(10)]);
var state_41756__$1 = state_41756;
var statearr_41765_41847 = state_41756__$1;
(statearr_41765_41847[(2)] = inst_41670);

(statearr_41765_41847[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (46))){
var inst_41635 = (state_41756[(11)]);
var state_41756__$1 = state_41756;
var statearr_41766_41848 = state_41756__$1;
(statearr_41766_41848[(2)] = inst_41635);

(statearr_41766_41848[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (4))){
var inst_41597 = (state_41756[(2)]);
var state_41756__$1 = state_41756;
var statearr_41767_41849 = state_41756__$1;
(statearr_41767_41849[(2)] = inst_41597);

(statearr_41767_41849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (15))){
var inst_41646 = (state_41756[(12)]);
var inst_41652 = cljs.core.count(inst_41646);
var inst_41653 = fluree.db.query.fql.add_fuel(fuel,inst_41652,max_fuel);
var state_41756__$1 = state_41756;
var statearr_41768_41850 = state_41756__$1;
(statearr_41768_41850[(2)] = inst_41653);

(statearr_41768_41850[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (48))){
var inst_41615 = (state_41756[(13)]);
var inst_41737 = (state_41756[(14)]);
var inst_41622 = (state_41756[(15)]);
var inst_41745 = (state_41756[(2)]);
var inst_41746 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41615,inst_41745,inst_41737);
var inst_41614 = inst_41622;
var inst_41615__$1 = inst_41746;
var state_41756__$1 = (function (){var statearr_41769 = state_41756;
(statearr_41769[(13)] = inst_41615__$1);

(statearr_41769[(16)] = inst_41614);

return statearr_41769;
})();
var statearr_41770_41851 = state_41756__$1;
(statearr_41770_41851[(2)] = null);

(statearr_41770_41851[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (50))){
var inst_41637 = (state_41756[(17)]);
var state_41756__$1 = state_41756;
var statearr_41771_41852 = state_41756__$1;
(statearr_41771_41852[(2)] = inst_41637);

(statearr_41771_41852[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (21))){
var inst_41634 = (state_41756[(9)]);
var state_41756__$1 = state_41756;
if(cljs.core.truth_(inst_41634)){
var statearr_41773_41853 = state_41756__$1;
(statearr_41773_41853[(1)] = (23));

} else {
var statearr_41774_41854 = state_41756__$1;
(statearr_41774_41854[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (31))){
var inst_41694 = (state_41756[(2)]);
var state_41756__$1 = state_41756;
if(cljs.core.truth_(inst_41694)){
var statearr_41775_41855 = state_41756__$1;
(statearr_41775_41855[(1)] = (32));

} else {
var statearr_41776_41856 = state_41756__$1;
(statearr_41776_41856[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (32))){
var inst_41677 = (state_41756[(18)]);
var inst_41669 = (state_41756[(19)]);
var inst_41670 = (state_41756[(10)]);
var inst_41696 = (inst_41669 + (1));
var tmp41772 = inst_41670;
var inst_41668 = inst_41677;
var inst_41669__$1 = inst_41696;
var inst_41670__$1 = tmp41772;
var state_41756__$1 = (function (){var statearr_41777 = state_41756;
(statearr_41777[(20)] = inst_41668);

(statearr_41777[(19)] = inst_41669__$1);

(statearr_41777[(10)] = inst_41670__$1);

return statearr_41777;
})();
var statearr_41778_41857 = state_41756__$1;
(statearr_41778_41857[(2)] = null);

(statearr_41778_41857[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (40))){
var state_41756__$1 = state_41756;
if(cljs.core.truth_(fuel)){
var statearr_41779_41858 = state_41756__$1;
(statearr_41779_41858[(1)] = (42));

} else {
var statearr_41780_41859 = state_41756__$1;
(statearr_41780_41859[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (33))){
var state_41756__$1 = state_41756;
var statearr_41781_41860 = state_41756__$1;
(statearr_41781_41860[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (13))){
var inst_41646 = (state_41756[(12)]);
var state_41756__$1 = state_41756;
var statearr_41783_41861 = state_41756__$1;
(statearr_41783_41861[(2)] = inst_41646);

(statearr_41783_41861[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (22))){
var inst_41687 = (state_41756[(2)]);
var state_41756__$1 = state_41756;
if(cljs.core.truth_(inst_41687)){
var statearr_41784_41862 = state_41756__$1;
(statearr_41784_41862[(1)] = (26));

} else {
var statearr_41785_41863 = state_41756__$1;
(statearr_41785_41863[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (36))){
var state_41756__$1 = state_41756;
var statearr_41786_41864 = state_41756__$1;
(statearr_41786_41864[(2)] = null);

(statearr_41786_41864[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (41))){
var inst_41677 = (state_41756[(18)]);
var inst_41669 = (state_41756[(19)]);
var inst_41726 = (state_41756[(2)]);
var inst_41727 = (inst_41669 + (1));
var inst_41668 = inst_41677;
var inst_41669__$1 = inst_41727;
var inst_41670 = inst_41726;
var state_41756__$1 = (function (){var statearr_41787 = state_41756;
(statearr_41787[(20)] = inst_41668);

(statearr_41787[(19)] = inst_41669__$1);

(statearr_41787[(10)] = inst_41670);

return statearr_41787;
})();
var statearr_41788_41865 = state_41756__$1;
(statearr_41788_41865[(2)] = null);

(statearr_41788_41865[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (43))){
var state_41756__$1 = state_41756;
var statearr_41789_41866 = state_41756__$1;
(statearr_41789_41866[(2)] = null);

(statearr_41789_41866[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (29))){
var inst_41633 = (state_41756[(8)]);
var inst_41669 = (state_41756[(19)]);
var inst_41691 = (inst_41669 < inst_41633);
var state_41756__$1 = state_41756;
var statearr_41790_41867 = state_41756__$1;
(statearr_41790_41867[(2)] = inst_41691);

(statearr_41790_41867[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (44))){
var inst_41706 = (state_41756[(21)]);
var inst_41710 = (state_41756[(22)]);
var inst_41719 = (state_41756[(2)]);
var inst_41720 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_41710,inst_41706) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_41710,inst_41706));
var state_41756__$1 = (function (){var statearr_41791 = state_41756;
(statearr_41791[(23)] = inst_41719);

return statearr_41791;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41756__$1,(45),inst_41720);
} else {
if((state_val_41757 === (6))){
var inst_41614 = (state_41756[(16)]);
var inst_41621 = (state_41756[(24)]);
var inst_41620 = cljs.core.seq(inst_41614);
var inst_41621__$1 = cljs.core.first(inst_41620);
var inst_41622 = cljs.core.next(inst_41620);
var inst_41623 = cljs.core.not(inst_41621__$1);
var state_41756__$1 = (function (){var statearr_41792 = state_41756;
(statearr_41792[(24)] = inst_41621__$1);

(statearr_41792[(15)] = inst_41622);

return statearr_41792;
})();
if(inst_41623){
var statearr_41793_41868 = state_41756__$1;
(statearr_41793_41868[(1)] = (8));

} else {
var statearr_41794_41869 = state_41756__$1;
(statearr_41794_41869[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (28))){
var inst_41735 = (state_41756[(2)]);
var state_41756__$1 = state_41756;
var statearr_41795_41870 = state_41756__$1;
(statearr_41795_41870[(2)] = inst_41735);

(statearr_41795_41870[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (51))){
var inst_41743 = (state_41756[(2)]);
var state_41756__$1 = state_41756;
var statearr_41796_41871 = state_41756__$1;
(statearr_41796_41871[(2)] = inst_41743);

(statearr_41796_41871[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (25))){
var inst_41685 = (state_41756[(2)]);
var state_41756__$1 = state_41756;
var statearr_41797_41872 = state_41756__$1;
(statearr_41797_41872[(2)] = inst_41685);

(statearr_41797_41872[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (34))){
var inst_41733 = (state_41756[(2)]);
var state_41756__$1 = state_41756;
var statearr_41798_41873 = state_41756__$1;
(statearr_41798_41873[(2)] = inst_41733);

(statearr_41798_41873[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (17))){
var inst_41646 = (state_41756[(12)]);
var inst_41656 = (state_41756[(2)]);
var inst_41664 = cljs.core.seq(inst_41646);
var inst_41665 = cljs.core.first(inst_41664);
var inst_41666 = cljs.core.next(inst_41664);
var inst_41667 = cljs.core.PersistentVector.EMPTY;
var inst_41668 = inst_41646;
var inst_41669 = (0);
var inst_41670 = inst_41667;
var state_41756__$1 = (function (){var statearr_41799 = state_41756;
(statearr_41799[(25)] = inst_41666);

(statearr_41799[(20)] = inst_41668);

(statearr_41799[(26)] = inst_41656);

(statearr_41799[(27)] = inst_41665);

(statearr_41799[(19)] = inst_41669);

(statearr_41799[(10)] = inst_41670);

return statearr_41799;
})();
var statearr_41800_41874 = state_41756__$1;
(statearr_41800_41874[(2)] = null);

(statearr_41800_41874[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (3))){
var inst_41754 = (state_41756[(2)]);
var state_41756__$1 = state_41756;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41756__$1,inst_41754);
} else {
if((state_val_41757 === (12))){
var state_41756__$1 = state_41756;
var statearr_41801_41875 = state_41756__$1;
(statearr_41801_41875[(2)] = fuel);

(statearr_41801_41875[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (2))){
var _ = (function (){var statearr_41802 = state_41756;
(statearr_41802[(4)] = cljs.core.cons((5),(state_41756[(4)])));

return statearr_41802;
})();
var inst_41610 = reverse_refs_specs;
var inst_41611 = cljs.core.seq(inst_41610);
var inst_41612 = cljs.core.first(inst_41611);
var inst_41613 = cljs.core.next(inst_41611);
var inst_41614 = inst_41610;
var inst_41615 = null;
var state_41756__$1 = (function (){var statearr_41803 = state_41756;
(statearr_41803[(13)] = inst_41615);

(statearr_41803[(28)] = inst_41612);

(statearr_41803[(16)] = inst_41614);

(statearr_41803[(29)] = inst_41613);

return statearr_41803;
})();
var statearr_41804_41876 = state_41756__$1;
(statearr_41804_41876[(2)] = null);

(statearr_41804_41876[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (23))){
var inst_41669 = (state_41756[(19)]);
var inst_41634 = (state_41756[(9)]);
var inst_41682 = (inst_41669 >= inst_41634);
var state_41756__$1 = state_41756;
var statearr_41805_41877 = state_41756__$1;
(statearr_41805_41877[(2)] = inst_41682);

(statearr_41805_41877[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (47))){
var inst_41636 = (state_41756[(30)]);
var state_41756__$1 = state_41756;
if(cljs.core.truth_(inst_41636)){
var statearr_41806_41878 = state_41756__$1;
(statearr_41806_41878[(1)] = (49));

} else {
var statearr_41807_41879 = state_41756__$1;
(statearr_41807_41879[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (35))){
var inst_41676 = (state_41756[(31)]);
var inst_41700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41701 = [inst_41676];
var inst_41702 = (new cljs.core.PersistentVector(null,1,(5),inst_41700,inst_41701,null));
var inst_41703 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_41702);
var state_41756__$1 = state_41756;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41756__$1,(38),inst_41703);
} else {
if((state_val_41757 === (19))){
var inst_41635 = (state_41756[(11)]);
var inst_41737 = (state_41756[(2)]);
var state_41756__$1 = (function (){var statearr_41808 = state_41756;
(statearr_41808[(14)] = inst_41737);

return statearr_41808;
})();
if(cljs.core.truth_(inst_41635)){
var statearr_41809_41880 = state_41756__$1;
(statearr_41809_41880[(1)] = (46));

} else {
var statearr_41810_41881 = state_41756__$1;
(statearr_41810_41881[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (11))){
var inst_41646 = (state_41756[(12)]);
var inst_41643 = (state_41756[(2)]);
var inst_41644 = fluree.db.util.async.throw_err(inst_41643);
var inst_41645 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_41644);
var inst_41646__$1 = cljs.core.not_empty(inst_41645);
var state_41756__$1 = (function (){var statearr_41812 = state_41756;
(statearr_41812[(12)] = inst_41646__$1);

return statearr_41812;
})();
if(cljs.core.truth_(inst_41646__$1)){
var statearr_41813_41882 = state_41756__$1;
(statearr_41813_41882[(1)] = (12));

} else {
var statearr_41814_41883 = state_41756__$1;
(statearr_41814_41883[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (9))){
var inst_41621 = (state_41756[(24)]);
var inst_41631 = (state_41756[(32)]);
var inst_41630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41621,(0),null);
var inst_41631__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41621,(1),null);
var inst_41632 = cljs.core.__destructure_map(inst_41631__$1);
var inst_41633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41632,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_41634 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41632,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_41635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41632,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_41636 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41632,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_41637 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41632,new cljs.core.Keyword(null,"p","p",151049309));
var inst_41638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41639 = [subject_id,inst_41630];
var inst_41640 = (new cljs.core.PersistentVector(null,2,(5),inst_41638,inst_41639,null));
var inst_41641 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_41640);
var state_41756__$1 = (function (){var statearr_41815 = state_41756;
(statearr_41815[(11)] = inst_41635);

(statearr_41815[(8)] = inst_41633);

(statearr_41815[(30)] = inst_41636);

(statearr_41815[(32)] = inst_41631__$1);

(statearr_41815[(9)] = inst_41634);

(statearr_41815[(17)] = inst_41637);

return statearr_41815;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41756__$1,(11),inst_41641);
} else {
if((state_val_41757 === (5))){
var _ = (function (){var statearr_41816 = state_41756;
(statearr_41816[(4)] = cljs.core.rest((state_41756[(4)])));

return statearr_41816;
})();
var state_41756__$1 = state_41756;
var ex41811 = (state_41756__$1[(2)]);
var statearr_41817_41884 = state_41756__$1;
(statearr_41817_41884[(5)] = ex41811);


if((ex41811 instanceof Error)){
var statearr_41818_41885 = state_41756__$1;
(statearr_41818_41885[(1)] = (4));

(statearr_41818_41885[(5)] = null);

} else {
throw ex41811;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (14))){
var inst_41650 = (state_41756[(2)]);
var state_41756__$1 = state_41756;
if(cljs.core.truth_(inst_41650)){
var statearr_41819_41886 = state_41756__$1;
(statearr_41819_41886[(1)] = (15));

} else {
var statearr_41820_41887 = state_41756__$1;
(statearr_41820_41887[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (45))){
var inst_41670 = (state_41756[(10)]);
var inst_41722 = (state_41756[(2)]);
var inst_41723 = fluree.db.util.async.throw_err(inst_41722);
var inst_41724 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41670,inst_41723);
var state_41756__$1 = state_41756;
var statearr_41821_41888 = state_41756__$1;
(statearr_41821_41888[(2)] = inst_41724);

(statearr_41821_41888[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (26))){
var inst_41670 = (state_41756[(10)]);
var state_41756__$1 = state_41756;
var statearr_41822_41889 = state_41756__$1;
(statearr_41822_41889[(2)] = inst_41670);

(statearr_41822_41889[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (16))){
var state_41756__$1 = state_41756;
var statearr_41823_41890 = state_41756__$1;
(statearr_41823_41890[(2)] = null);

(statearr_41823_41890[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (38))){
var inst_41706 = (state_41756[(21)]);
var inst_41631 = (state_41756[(32)]);
var inst_41705 = (state_41756[(2)]);
var inst_41706__$1 = fluree.db.util.async.throw_err(inst_41705);
var inst_41707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41708 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_41709 = (new cljs.core.PersistentVector(null,4,(5),inst_41707,inst_41708,null));
var inst_41710 = cljs.core.select_keys(inst_41631,inst_41709);
var inst_41711 = cljs.core.empty_QMARK_(inst_41706__$1);
var state_41756__$1 = (function (){var statearr_41824 = state_41756;
(statearr_41824[(21)] = inst_41706__$1);

(statearr_41824[(22)] = inst_41710);

return statearr_41824;
})();
if(inst_41711){
var statearr_41825_41891 = state_41756__$1;
(statearr_41825_41891[(1)] = (39));

} else {
var statearr_41826_41892 = state_41756__$1;
(statearr_41826_41892[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (30))){
var inst_41633 = (state_41756[(8)]);
var state_41756__$1 = state_41756;
var statearr_41827_41893 = state_41756__$1;
(statearr_41827_41893[(2)] = inst_41633);

(statearr_41827_41893[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (10))){
var inst_41749 = (state_41756[(2)]);
var state_41756__$1 = state_41756;
var statearr_41828_41894 = state_41756__$1;
(statearr_41828_41894[(2)] = inst_41749);

(statearr_41828_41894[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (18))){
var inst_41676 = (state_41756[(31)]);
var inst_41668 = (state_41756[(20)]);
var inst_41678 = (state_41756[(7)]);
var inst_41675 = cljs.core.seq(inst_41668);
var inst_41676__$1 = cljs.core.first(inst_41675);
var inst_41677 = cljs.core.next(inst_41675);
var inst_41678__$1 = cljs.core.not(inst_41676__$1);
var state_41756__$1 = (function (){var statearr_41829 = state_41756;
(statearr_41829[(31)] = inst_41676__$1);

(statearr_41829[(18)] = inst_41677);

(statearr_41829[(7)] = inst_41678__$1);

return statearr_41829;
})();
if(inst_41678__$1){
var statearr_41830_41895 = state_41756__$1;
(statearr_41830_41895[(1)] = (20));

} else {
var statearr_41831_41896 = state_41756__$1;
(statearr_41831_41896[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (42))){
var inst_41706 = (state_41756[(21)]);
var inst_41715 = cljs.core.count(inst_41706);
var inst_41716 = fluree.db.query.fql.add_fuel(fuel,inst_41715,max_fuel);
var state_41756__$1 = state_41756;
var statearr_41832_41897 = state_41756__$1;
(statearr_41832_41897[(2)] = inst_41716);

(statearr_41832_41897[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (37))){
var inst_41731 = (state_41756[(2)]);
var state_41756__$1 = state_41756;
var statearr_41833_41898 = state_41756__$1;
(statearr_41833_41898[(2)] = inst_41731);

(statearr_41833_41898[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (8))){
var inst_41615 = (state_41756[(13)]);
var state_41756__$1 = state_41756;
var statearr_41834_41899 = state_41756__$1;
(statearr_41834_41899[(2)] = inst_41615);

(statearr_41834_41899[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41757 === (49))){
var inst_41636 = (state_41756[(30)]);
var state_41756__$1 = state_41756;
var statearr_41835_41900 = state_41756__$1;
(statearr_41835_41900[(2)] = inst_41636);

(statearr_41835_41900[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17178__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17178__auto____0 = (function (){
var statearr_41836 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41836[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17178__auto__);

(statearr_41836[(1)] = (1));

return statearr_41836;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17178__auto____1 = (function (state_41756){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_41756);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e41837){var ex__17181__auto__ = e41837;
var statearr_41838_41901 = state_41756;
(statearr_41838_41901[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_41756[(4)]))){
var statearr_41839_41902 = state_41756;
(statearr_41839_41902[(1)] = cljs.core.first((state_41756[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41903 = state_41756;
state_41756 = G__41903;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17178__auto__ = function(state_41756){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17178__auto____1.call(this,state_41756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17178__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17178__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_41840 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_41840[(6)] = c__17304__auto__);

return statearr_41840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__41904 = select_spec;
var map__41904__$1 = cljs.core.__destructure_map(map__41904);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41904__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41904__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_42018){
var state_val_42019 = (state_42018[(1)]);
if((state_val_42019 === (7))){
var inst_41930 = flakes;
var inst_41931 = cljs.core.seq(inst_41930);
var inst_41932 = cljs.core.first(inst_41931);
var inst_41933 = cljs.core.next(inst_41931);
var inst_41934 = cljs.core.PersistentVector.EMPTY;
var inst_41935 = inst_41930;
var inst_41936 = (0);
var inst_41937 = inst_41934;
var state_42018__$1 = (function (){var statearr_42020 = state_42018;
(statearr_42020[(7)] = inst_41935);

(statearr_42020[(8)] = inst_41937);

(statearr_42020[(9)] = inst_41932);

(statearr_42020[(10)] = inst_41936);

(statearr_42020[(11)] = inst_41933);

return statearr_42020;
})();
var statearr_42021_42087 = state_42018__$1;
(statearr_42021_42087[(2)] = null);

(statearr_42021_42087[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (20))){
var state_42018__$1 = state_42018;
var statearr_42022_42088 = state_42018__$1;
(statearr_42022_42088[(2)] = results);

(statearr_42022_42088[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (27))){
var state_42018__$1 = state_42018;
var statearr_42023_42089 = state_42018__$1;
(statearr_42023_42089[(2)] = null);

(statearr_42023_42089[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (1))){
var state_42018__$1 = state_42018;
var statearr_42024_42090 = state_42018__$1;
(statearr_42024_42090[(2)] = null);

(statearr_42024_42090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (24))){
var state_42018__$1 = state_42018;
var statearr_42025_42091 = state_42018__$1;
(statearr_42025_42091[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (39))){
var inst_41999 = (state_42018[(12)]);
var inst_41937 = (state_42018[(8)]);
var inst_41944 = (state_42018[(13)]);
var inst_42002 = (state_42018[(2)]);
var inst_42003 = fluree.db.util.async.throw_err(inst_42002);
var inst_42004 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41937,inst_42003);
var inst_41935 = inst_41944;
var inst_41936 = inst_41999;
var inst_41937__$1 = inst_42004;
var state_42018__$1 = (function (){var statearr_42027 = state_42018;
(statearr_42027[(7)] = inst_41935);

(statearr_42027[(8)] = inst_41937__$1);

(statearr_42027[(10)] = inst_41936);

return statearr_42027;
})();
var statearr_42028_42092 = state_42018__$1;
(statearr_42028_42092[(2)] = null);

(statearr_42028_42092[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (4))){
var inst_41905 = (state_42018[(2)]);
var state_42018__$1 = state_42018;
var statearr_42029_42093 = state_42018__$1;
(statearr_42029_42093[(2)] = inst_41905);

(statearr_42029_42093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (15))){
var inst_41918 = (state_42018[(14)]);
var state_42018__$1 = state_42018;
var statearr_42030_42094 = state_42018__$1;
(statearr_42030_42094[(2)] = inst_41918);

(statearr_42030_42094[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (21))){
var inst_41914 = (state_42018[(15)]);
var state_42018__$1 = state_42018;
if(cljs.core.truth_(inst_41914)){
var statearr_42031_42095 = state_42018__$1;
(statearr_42031_42095[(1)] = (23));

} else {
var statearr_42032_42096 = state_42018__$1;
(statearr_42032_42096[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (31))){
var inst_41982 = (state_42018[(16)]);
var state_42018__$1 = state_42018;
var statearr_42033_42097 = state_42018__$1;
(statearr_42033_42097[(2)] = inst_41982);

(statearr_42033_42097[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (32))){
var inst_41974 = (state_42018[(17)]);
var inst_41988 = (state_42018[(2)]);
var state_42018__$1 = (function (){var statearr_42034 = state_42018;
(statearr_42034[(18)] = inst_41988);

return statearr_42034;
})();
if(cljs.core.truth_(inst_41974)){
var statearr_42035_42098 = state_42018__$1;
(statearr_42035_42098[(1)] = (33));

} else {
var statearr_42036_42099 = state_42018__$1;
(statearr_42036_42099[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (33))){
var inst_41974 = (state_42018[(17)]);
var state_42018__$1 = state_42018;
var statearr_42037_42100 = state_42018__$1;
(statearr_42037_42100[(2)] = inst_41974);

(statearr_42037_42100[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (13))){
var inst_41954 = (state_42018[(2)]);
var state_42018__$1 = state_42018;
if(cljs.core.truth_(inst_41954)){
var statearr_42039_42101 = state_42018__$1;
(statearr_42039_42101[(1)] = (17));

} else {
var statearr_42040_42102 = state_42018__$1;
(statearr_42040_42102[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (22))){
var inst_41971 = (state_42018[(2)]);
var state_42018__$1 = state_42018;
var statearr_42041_42103 = state_42018__$1;
(statearr_42041_42103[(2)] = inst_41971);

(statearr_42041_42103[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (36))){
var inst_41937 = (state_42018[(8)]);
var inst_41944 = (state_42018[(13)]);
var inst_41936 = (state_42018[(10)]);
var inst_41996 = (inst_41936 + (1));
var tmp42038 = inst_41937;
var inst_41935 = inst_41944;
var inst_41936__$1 = inst_41996;
var inst_41937__$1 = tmp42038;
var state_42018__$1 = (function (){var statearr_42042 = state_42018;
(statearr_42042[(7)] = inst_41935);

(statearr_42042[(8)] = inst_41937__$1);

(statearr_42042[(10)] = inst_41936__$1);

return statearr_42042;
})();
var statearr_42043_42104 = state_42018__$1;
(statearr_42043_42104[(2)] = null);

(statearr_42043_42104[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (29))){
var inst_41981 = (state_42018[(2)]);
var inst_41982 = fluree.db.util.async.throw_err(inst_41981);
var state_42018__$1 = (function (){var statearr_42044 = state_42018;
(statearr_42044[(16)] = inst_41982);

return statearr_42044;
})();
if(cljs.core.truth_(fuel)){
var statearr_42045_42105 = state_42018__$1;
(statearr_42045_42105[(1)] = (30));

} else {
var statearr_42046_42106 = state_42018__$1;
(statearr_42046_42106[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (6))){
var state_42018__$1 = state_42018;
var statearr_42047_42107 = state_42018__$1;
(statearr_42047_42107[(2)] = results);

(statearr_42047_42107[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (28))){
var inst_41967 = (state_42018[(2)]);
var state_42018__$1 = state_42018;
var statearr_42048_42108 = state_42018__$1;
(statearr_42048_42108[(2)] = inst_41967);

(statearr_42048_42108[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (25))){
var inst_41969 = (state_42018[(2)]);
var state_42018__$1 = state_42018;
var statearr_42049_42109 = state_42018__$1;
(statearr_42049_42109[(2)] = inst_41969);

(statearr_42049_42109[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (34))){
var inst_41988 = (state_42018[(18)]);
var inst_41991 = cljs.core.empty_QMARK_(inst_41988);
var state_42018__$1 = state_42018;
var statearr_42050_42110 = state_42018__$1;
(statearr_42050_42110[(2)] = inst_41991);

(statearr_42050_42110[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (17))){
var inst_41937 = (state_42018[(8)]);
var inst_41956 = cljs.core.empty_QMARK_(inst_41937);
var state_42018__$1 = state_42018;
if(inst_41956){
var statearr_42051_42111 = state_42018__$1;
(statearr_42051_42111[(1)] = (20));

} else {
var statearr_42052_42112 = state_42018__$1;
(statearr_42052_42112[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (3))){
var inst_42016 = (state_42018[(2)]);
var state_42018__$1 = state_42018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42018__$1,inst_42016);
} else {
if((state_val_42019 === (12))){
var inst_41918 = (state_42018[(14)]);
var state_42018__$1 = state_42018;
if(cljs.core.truth_(inst_41918)){
var statearr_42053_42113 = state_42018__$1;
(statearr_42053_42113[(1)] = (14));

} else {
var statearr_42054_42114 = state_42018__$1;
(statearr_42054_42114[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (2))){
var _ = (function (){var statearr_42055 = state_42018;
(statearr_42055[(4)] = cljs.core.cons((5),(state_42018[(4)])));

return statearr_42055;
})();
var inst_41912 = select_spec;
var inst_41913 = cljs.core.__destructure_map(inst_41912);
var inst_41914 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41913,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_41915 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41913,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_41916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41913,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_41917 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41913,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_41918 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41913,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_41919 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_41920 = (inst_41917 > inst_41919);
var state_42018__$1 = (function (){var statearr_42056 = state_42018;
(statearr_42056[(19)] = inst_41916);

(statearr_42056[(14)] = inst_41918);

(statearr_42056[(20)] = inst_41915);

(statearr_42056[(15)] = inst_41914);

return statearr_42056;
})();
if(cljs.core.truth_(inst_41920)){
var statearr_42057_42115 = state_42018__$1;
(statearr_42057_42115[(1)] = (6));

} else {
var statearr_42058_42116 = state_42018__$1;
(statearr_42058_42116[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (23))){
var inst_41915 = (state_42018[(20)]);
var inst_41937 = (state_42018[(8)]);
var inst_41960 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_41915,inst_41937);
var state_42018__$1 = state_42018;
var statearr_42059_42117 = state_42018__$1;
(statearr_42059_42117[(2)] = inst_41960);

(statearr_42059_42117[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (35))){
var inst_41943 = (state_42018[(21)]);
var inst_41993 = (state_42018[(2)]);
var inst_41994 = fluree.db.query.fql.recur_select_spec(select_spec,inst_41943);
var state_42018__$1 = (function (){var statearr_42060 = state_42018;
(statearr_42060[(22)] = inst_41994);

return statearr_42060;
})();
if(cljs.core.truth_(inst_41993)){
var statearr_42061_42118 = state_42018__$1;
(statearr_42061_42118[(1)] = (36));

} else {
var statearr_42062_42119 = state_42018__$1;
(statearr_42062_42119[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (19))){
var inst_42009 = (state_42018[(2)]);
var state_42018__$1 = state_42018;
var statearr_42063_42120 = state_42018__$1;
(statearr_42063_42120[(2)] = inst_42009);

(statearr_42063_42120[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (11))){
var inst_41945 = (state_42018[(23)]);
var state_42018__$1 = state_42018;
var statearr_42065_42121 = state_42018__$1;
(statearr_42065_42121[(2)] = inst_41945);

(statearr_42065_42121[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (9))){
var inst_41943 = (state_42018[(21)]);
var inst_41945 = (state_42018[(23)]);
var inst_41935 = (state_42018[(7)]);
var inst_41942 = cljs.core.seq(inst_41935);
var inst_41943__$1 = cljs.core.first(inst_41942);
var inst_41944 = cljs.core.next(inst_41942);
var inst_41945__$1 = cljs.core.not(inst_41943__$1);
var state_42018__$1 = (function (){var statearr_42066 = state_42018;
(statearr_42066[(21)] = inst_41943__$1);

(statearr_42066[(23)] = inst_41945__$1);

(statearr_42066[(13)] = inst_41944);

return statearr_42066;
})();
if(inst_41945__$1){
var statearr_42067_42122 = state_42018__$1;
(statearr_42067_42122[(1)] = (11));

} else {
var statearr_42068_42123 = state_42018__$1;
(statearr_42068_42123[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (5))){
var _ = (function (){var statearr_42069 = state_42018;
(statearr_42069[(4)] = cljs.core.rest((state_42018[(4)])));

return statearr_42069;
})();
var state_42018__$1 = state_42018;
var ex42064 = (state_42018__$1[(2)]);
var statearr_42070_42124 = state_42018__$1;
(statearr_42070_42124[(5)] = ex42064);


if((ex42064 instanceof Error)){
var statearr_42071_42125 = state_42018__$1;
(statearr_42071_42125[(1)] = (4));

(statearr_42071_42125[(5)] = null);

} else {
throw ex42064;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (14))){
var inst_41918 = (state_42018[(14)]);
var inst_41936 = (state_42018[(10)]);
var inst_41949 = (inst_41936 < inst_41918);
var state_42018__$1 = state_42018;
var statearr_42072_42126 = state_42018__$1;
(statearr_42072_42126[(2)] = inst_41949);

(statearr_42072_42126[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (26))){
var inst_41915 = (state_42018[(20)]);
var inst_41937 = (state_42018[(8)]);
var inst_41963 = cljs.core.first(inst_41937);
var inst_41964 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_41915,inst_41963);
var state_42018__$1 = state_42018;
var statearr_42073_42127 = state_42018__$1;
(statearr_42073_42127[(2)] = inst_41964);

(statearr_42073_42127[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (16))){
var inst_41952 = (state_42018[(2)]);
var state_42018__$1 = state_42018;
var statearr_42074_42128 = state_42018__$1;
(statearr_42074_42128[(2)] = inst_41952);

(statearr_42074_42128[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (38))){
var inst_42007 = (state_42018[(2)]);
var state_42018__$1 = state_42018;
var statearr_42075_42129 = state_42018__$1;
(statearr_42075_42129[(2)] = inst_42007);

(statearr_42075_42129[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (30))){
var inst_41982 = (state_42018[(16)]);
var inst_41984 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_41985 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_41984,inst_41982);
var state_42018__$1 = state_42018;
var statearr_42076_42130 = state_42018__$1;
(statearr_42076_42130[(2)] = inst_41985);

(statearr_42076_42130[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (10))){
var inst_42011 = (state_42018[(2)]);
var state_42018__$1 = state_42018;
var statearr_42077_42131 = state_42018__$1;
(statearr_42077_42131[(2)] = inst_42011);

(statearr_42077_42131[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42019 === (18))){
var inst_41916 = (state_42018[(19)]);
var inst_41943 = (state_42018[(21)]);
var inst_41973 = inst_41943.o;
var inst_41974 = cljs.core.contains_QMARK_(inst_41916,inst_41973);
var inst_41976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41977 = [inst_41973];
var inst_41978 = (new cljs.core.PersistentVector(null,1,(5),inst_41976,inst_41977,null));
var inst_41979 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_41978);
var state_42018__$1 = (function (){var statearr_42078 = state_42018;
(statearr_42078[(17)] = inst_41974);

return statearr_42078;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42018__$1,(29),inst_41979);
} else {
if((state_val_42019 === (37))){
var inst_41994 = (state_42018[(22)]);
var inst_41988 = (state_42018[(18)]);
var inst_41936 = (state_42018[(10)]);
var inst_41999 = (inst_41936 + (1));
var inst_42000 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_41994,inst_41988) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_41994,inst_41988));
var state_42018__$1 = (function (){var statearr_42079 = state_42018;
(statearr_42079[(12)] = inst_41999);

return statearr_42079;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42018__$1,(39),inst_42000);
} else {
if((state_val_42019 === (8))){
var inst_42013 = (state_42018[(2)]);
var _ = (function (){var statearr_42080 = state_42018;
(statearr_42080[(4)] = cljs.core.rest((state_42018[(4)])));

return statearr_42080;
})();
var state_42018__$1 = state_42018;
var statearr_42081_42132 = state_42018__$1;
(statearr_42081_42132[(2)] = inst_42013);

(statearr_42081_42132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__17178__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__17178__auto____0 = (function (){
var statearr_42082 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42082[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__17178__auto__);

(statearr_42082[(1)] = (1));

return statearr_42082;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__17178__auto____1 = (function (state_42018){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_42018);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e42083){var ex__17181__auto__ = e42083;
var statearr_42084_42133 = state_42018;
(statearr_42084_42133[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_42018[(4)]))){
var statearr_42085_42134 = state_42018;
(statearr_42085_42134[(1)] = cljs.core.first((state_42018[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42135 = state_42018;
state_42018 = G__42135;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__17178__auto__ = function(state_42018){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__17178__auto____1.call(this,state_42018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__17178__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__17178__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_42086 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_42086[(6)] = c__17304__auto__);

return statearr_42086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_42316){
var state_val_42317 = (state_42316[(1)]);
if((state_val_42317 === (7))){
var state_42316__$1 = state_42316;
var statearr_42318_42404 = state_42316__$1;
(statearr_42318_42404[(2)] = null);

(statearr_42318_42404[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (20))){
var inst_42174 = cljs.core.PersistentHashMap.EMPTY;
var state_42316__$1 = state_42316;
var statearr_42319_42405 = state_42316__$1;
(statearr_42319_42405[(2)] = inst_42174);

(statearr_42319_42405[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (27))){
var inst_42176 = (state_42316[(7)]);
var inst_42162 = (state_42316[(8)]);
var inst_42192 = (state_42316[(9)]);
var inst_42156 = (state_42316[(10)]);
var inst_42295 = (state_42316[(2)]);
var inst_42296 = (function (){var top_level_subject = inst_42156;
var select_spec = inst_42162;
var base_acc = inst_42176;
var acc_PLUS_refs = inst_42192;
var result = inst_42295;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4212__auto__ = (function (){var and__4210__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_42297 = cljs.core.PersistentVector.EMPTY;
var inst_42298 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_42162);
var inst_42299 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_42298);
var inst_42300 = cljs.core.vals(inst_42299);
var inst_42301 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_42162);
var inst_42302 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_42301);
var inst_42303 = cljs.core.vals(inst_42302);
var inst_42304 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_42300,inst_42303);
var inst_42305 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_42296,inst_42297,inst_42304);
var inst_42307 = (function (){var top_level_subject = inst_42156;
var select_spec = inst_42162;
var base_acc = inst_42176;
var acc_PLUS_refs = inst_42192;
var result = inst_42295;
var sort_preds = inst_42305;
return (function (acc,p__42306){
var vec__42320 = p__42306;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42320,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42320,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42320,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42320,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_42308 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_42307,inst_42295,inst_42305);
var state_42316__$1 = state_42316;
var statearr_42323_42406 = state_42316__$1;
(statearr_42323_42406[(2)] = inst_42308);

(statearr_42323_42406[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (1))){
var state_42316__$1 = state_42316;
var statearr_42324_42407 = state_42316__$1;
(statearr_42324_42407[(2)] = null);

(statearr_42324_42407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (24))){
var inst_42192 = (state_42316[(9)]);
var inst_42192__$1 = (state_42316[(2)]);
var inst_42193 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_42194 = cljs.core.PersistentHashMap.EMPTY;
var inst_42195 = inst_42193;
var inst_42196 = inst_42192__$1;
var inst_42197 = inst_42194;
var state_42316__$1 = (function (){var statearr_42325 = state_42316;
(statearr_42325[(11)] = inst_42195);

(statearr_42325[(9)] = inst_42192__$1);

(statearr_42325[(12)] = inst_42196);

(statearr_42325[(13)] = inst_42197);

return statearr_42325;
})();
var statearr_42326_42408 = state_42316__$1;
(statearr_42326_42408[(2)] = null);

(statearr_42326_42408[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (39))){
var inst_42205 = (state_42316[(14)]);
var inst_42212 = (state_42316[(15)]);
var inst_42162 = (state_42316[(8)]);
var inst_42196 = (state_42316[(12)]);
var inst_42241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42242 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_42196,inst_42162,inst_42205,inst_42212,false);
var state_42316__$1 = (function (){var statearr_42327 = state_42316;
(statearr_42327[(16)] = inst_42241);

return statearr_42327;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42316__$1,(42),inst_42242);
} else {
if((state_val_42317 === (46))){
var inst_42205 = (state_42316[(14)]);
var inst_42195 = (state_42316[(11)]);
var inst_42197 = (state_42316[(13)]);
var inst_42259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42260 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_42261 = cljs.core.first(inst_42205);
var inst_42262 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_42261);
var inst_42263 = [inst_42262];
var inst_42264 = cljs.core.PersistentHashMap.fromArrays(inst_42260,inst_42263);
var inst_42265 = cljs.core.rest(inst_42195);
var inst_42266 = [inst_42264,inst_42265,inst_42197];
var inst_42267 = (new cljs.core.PersistentVector(null,3,(5),inst_42259,inst_42266,null));
var state_42316__$1 = state_42316;
var statearr_42328_42409 = state_42316__$1;
(statearr_42328_42409[(2)] = inst_42267);

(statearr_42328_42409[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (4))){
var inst_42136 = (state_42316[(2)]);
var state_42316__$1 = state_42316;
var statearr_42329_42410 = state_42316__$1;
(statearr_42329_42410[(2)] = inst_42136);

(statearr_42329_42410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (15))){
var inst_42163 = (state_42316[(17)]);
var inst_42162 = (state_42316[(8)]);
var inst_42162__$1 = (state_42316[(2)]);
var inst_42163__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_42162__$1);
var state_42316__$1 = (function (){var statearr_42330 = state_42316;
(statearr_42330[(17)] = inst_42163__$1);

(statearr_42330[(8)] = inst_42162__$1);

return statearr_42330;
})();
if(cljs.core.truth_(inst_42163__$1)){
var statearr_42331_42411 = state_42316__$1;
(statearr_42331_42411[(1)] = (16));

} else {
var statearr_42332_42412 = state_42316__$1;
(statearr_42332_42412[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (48))){
var inst_42278 = (state_42316[(2)]);
var state_42316__$1 = state_42316;
var statearr_42333_42413 = state_42316__$1;
(statearr_42333_42413[(2)] = inst_42278);

(statearr_42333_42413[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (50))){
var state_42316__$1 = state_42316;
var statearr_42334_42414 = state_42316__$1;
(statearr_42334_42414[(2)] = null);

(statearr_42334_42414[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (21))){
var inst_42162 = (state_42316[(8)]);
var inst_42176 = (state_42316[(2)]);
var inst_42177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42178 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_42179 = (new cljs.core.PersistentVector(null,2,(5),inst_42177,inst_42178,null));
var inst_42180 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_42162,inst_42179);
var state_42316__$1 = (function (){var statearr_42335 = state_42316;
(statearr_42335[(7)] = inst_42176);

return statearr_42335;
})();
if(cljs.core.truth_(inst_42180)){
var statearr_42336_42415 = state_42316__$1;
(statearr_42336_42415[(1)] = (22));

} else {
var statearr_42337_42416 = state_42316__$1;
(statearr_42337_42416[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (31))){
var inst_42211 = (state_42316[(18)]);
var inst_42205 = (state_42316[(14)]);
var inst_42196 = (state_42316[(12)]);
var inst_42215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42216 = fluree.db.query.fql.flake__GT_recur(db,inst_42205,inst_42211,inst_42196,fuel,max_fuel,cache);
var state_42316__$1 = (function (){var statearr_42338 = state_42316;
(statearr_42338[(19)] = inst_42215);

return statearr_42338;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42316__$1,(34),inst_42216);
} else {
if((state_val_42317 === (32))){
var inst_42211 = (state_42316[(18)]);
var state_42316__$1 = state_42316;
if(cljs.core.truth_(inst_42211)){
var statearr_42339_42417 = state_42316__$1;
(statearr_42339_42417[(1)] = (35));

} else {
var statearr_42340_42418 = state_42316__$1;
(statearr_42340_42418[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (40))){
var inst_42252 = (state_42316[(20)]);
var inst_42162 = (state_42316[(8)]);
var inst_42251 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_42162);
var inst_42252__$1 = cljs.core.empty_QMARK_(inst_42251);
var state_42316__$1 = (function (){var statearr_42341 = state_42316;
(statearr_42341[(20)] = inst_42252__$1);

return statearr_42341;
})();
if(inst_42252__$1){
var statearr_42342_42419 = state_42316__$1;
(statearr_42342_42419[(1)] = (43));

} else {
var statearr_42343_42420 = state_42316__$1;
(statearr_42343_42420[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (33))){
var inst_42205 = (state_42316[(14)]);
var inst_42284 = (state_42316[(2)]);
var inst_42285 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42284,(0),null);
var inst_42286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42284,(1),null);
var inst_42287 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42284,(2),null);
var inst_42288 = cljs.core.first(inst_42205);
var inst_42289 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_42288);
var inst_42290 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42285,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_42289);
var inst_42195 = inst_42286;
var inst_42196 = inst_42290;
var inst_42197 = inst_42287;
var state_42316__$1 = (function (){var statearr_42344 = state_42316;
(statearr_42344[(11)] = inst_42195);

(statearr_42344[(12)] = inst_42196);

(statearr_42344[(13)] = inst_42197);

return statearr_42344;
})();
var statearr_42345_42421 = state_42316__$1;
(statearr_42345_42421[(2)] = null);

(statearr_42345_42421[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (13))){
var inst_42156 = (state_42316[(10)]);
var inst_42159 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_42156);
var state_42316__$1 = state_42316;
var statearr_42346_42422 = state_42316__$1;
(statearr_42346_42422[(2)] = inst_42159);

(statearr_42346_42422[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (22))){
var inst_42162 = (state_42316[(8)]);
var inst_42182 = cljs.core.first(flakes);
var inst_42183 = fluree.db.query.fql.s(inst_42182);
var inst_42184 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_42162);
var inst_42185 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_42183,inst_42184);
var state_42316__$1 = state_42316;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42316__$1,(25),inst_42185);
} else {
if((state_val_42317 === (36))){
var inst_42162 = (state_42316[(8)]);
var inst_42239 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_42162);
var state_42316__$1 = state_42316;
if(cljs.core.truth_(inst_42239)){
var statearr_42347_42423 = state_42316__$1;
(statearr_42347_42423[(1)] = (39));

} else {
var statearr_42348_42424 = state_42316__$1;
(statearr_42348_42424[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (41))){
var inst_42280 = (state_42316[(2)]);
var state_42316__$1 = state_42316;
var statearr_42349_42425 = state_42316__$1;
(statearr_42349_42425[(2)] = inst_42280);

(statearr_42349_42425[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (43))){
var inst_42162 = (state_42316[(8)]);
var inst_42254 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_42162);
var state_42316__$1 = state_42316;
var statearr_42350_42426 = state_42316__$1;
(statearr_42350_42426[(2)] = inst_42254);

(statearr_42350_42426[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (29))){
var inst_42211 = (state_42316[(18)]);
var inst_42205 = (state_42316[(14)]);
var inst_42195 = (state_42316[(11)]);
var inst_42162 = (state_42316[(8)]);
var inst_42205__$1 = cljs.core.first(inst_42195);
var inst_42206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42207 = cljs.core.first(inst_42205__$1);
var inst_42208 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_42207);
var inst_42209 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_42208];
var inst_42210 = (new cljs.core.PersistentVector(null,3,(5),inst_42206,inst_42209,null));
var inst_42211__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_42162,inst_42210);
var inst_42212 = fluree.db.query.fql.component_follow_QMARK_(inst_42211__$1,inst_42162);
var inst_42213 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_42211__$1);
var state_42316__$1 = (function (){var statearr_42351 = state_42316;
(statearr_42351[(18)] = inst_42211__$1);

(statearr_42351[(14)] = inst_42205__$1);

(statearr_42351[(15)] = inst_42212);

return statearr_42351;
})();
if(cljs.core.truth_(inst_42213)){
var statearr_42352_42427 = state_42316__$1;
(statearr_42352_42427[(1)] = (31));

} else {
var statearr_42353_42428 = state_42316__$1;
(statearr_42353_42428[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (44))){
var inst_42252 = (state_42316[(20)]);
var state_42316__$1 = state_42316;
var statearr_42354_42429 = state_42316__$1;
(statearr_42354_42429[(2)] = inst_42252);

(statearr_42354_42429[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (6))){
var state_42316__$1 = state_42316;
var statearr_42355_42430 = state_42316__$1;
(statearr_42355_42430[(2)] = null);

(statearr_42355_42430[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (28))){
var inst_42196 = (state_42316[(12)]);
var state_42316__$1 = state_42316;
var statearr_42356_42431 = state_42316__$1;
(statearr_42356_42431[(2)] = inst_42196);

(statearr_42356_42431[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (51))){
var inst_42276 = (state_42316[(2)]);
var state_42316__$1 = state_42316;
var statearr_42357_42432 = state_42316__$1;
(statearr_42357_42432[(2)] = inst_42276);

(statearr_42357_42432[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (25))){
var inst_42176 = (state_42316[(7)]);
var inst_42187 = (state_42316[(2)]);
var inst_42188 = fluree.db.util.async.throw_err(inst_42187);
var inst_42189 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42176,inst_42188], 0));
var state_42316__$1 = state_42316;
var statearr_42358_42433 = state_42316__$1;
(statearr_42358_42433[(2)] = inst_42189);

(statearr_42358_42433[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (34))){
var inst_42195 = (state_42316[(11)]);
var inst_42215 = (state_42316[(19)]);
var inst_42197 = (state_42316[(13)]);
var inst_42218 = (state_42316[(2)]);
var inst_42219 = fluree.db.util.async.throw_err(inst_42218);
var inst_42220 = cljs.core.rest(inst_42195);
var inst_42221 = [inst_42219,inst_42220,inst_42197];
var inst_42222 = (new cljs.core.PersistentVector(null,3,(5),inst_42215,inst_42221,null));
var state_42316__$1 = state_42316;
var statearr_42359_42434 = state_42316__$1;
(statearr_42359_42434[(2)] = inst_42222);

(statearr_42359_42434[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (17))){
var inst_42162 = (state_42316[(8)]);
var inst_42166 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_42162);
var state_42316__$1 = state_42316;
var statearr_42361_42435 = state_42316__$1;
(statearr_42361_42435[(2)] = inst_42166);

(statearr_42361_42435[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (3))){
var inst_42314 = (state_42316[(2)]);
var state_42316__$1 = state_42316;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42316__$1,inst_42314);
} else {
if((state_val_42317 === (12))){
var _ = (function (){var statearr_42362 = state_42316;
(statearr_42362[(4)] = cljs.core.rest((state_42316[(4)])));

return statearr_42362;
})();
var state_42316__$1 = state_42316;
var ex42360 = (state_42316__$1[(2)]);
var statearr_42363_42436 = state_42316__$1;
(statearr_42363_42436[(5)] = ex42360);


var statearr_42364_42437 = state_42316__$1;
(statearr_42364_42437[(1)] = (11));

(statearr_42364_42437[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (2))){
var _ = (function (){var statearr_42365 = state_42316;
(statearr_42365[(4)] = cljs.core.cons((5),(state_42316[(4)])));

return statearr_42365;
})();
var inst_42142 = cljs.core.not_empty(flakes);
var state_42316__$1 = state_42316;
if(cljs.core.truth_(inst_42142)){
var statearr_42366_42438 = state_42316__$1;
(statearr_42366_42438[(1)] = (6));

} else {
var statearr_42367_42439 = state_42316__$1;
(statearr_42367_42439[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (23))){
var inst_42176 = (state_42316[(7)]);
var state_42316__$1 = state_42316;
var statearr_42368_42440 = state_42316__$1;
(statearr_42368_42440[(2)] = inst_42176);

(statearr_42368_42440[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (47))){
var state_42316__$1 = state_42316;
var statearr_42369_42441 = state_42316__$1;
(statearr_42369_42441[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (35))){
var inst_42211 = (state_42316[(18)]);
var inst_42205 = (state_42316[(14)]);
var inst_42212 = (state_42316[(15)]);
var inst_42196 = (state_42316[(12)]);
var inst_42197 = (state_42316[(13)]);
var inst_42228 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_42196,inst_42211,inst_42205,inst_42212,false,inst_42197);
var state_42316__$1 = state_42316;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42316__$1,(38),inst_42228);
} else {
if((state_val_42317 === (19))){
var inst_42156 = (state_42316[(10)]);
var inst_42170 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_42171 = [inst_42156];
var inst_42172 = cljs.core.PersistentHashMap.fromArrays(inst_42170,inst_42171);
var state_42316__$1 = state_42316;
var statearr_42371_42442 = state_42316__$1;
(statearr_42371_42442[(2)] = inst_42172);

(statearr_42371_42442[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (11))){
var inst_42144 = (state_42316[(2)]);
var inst_42145 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42144], 0));
var inst_42146 = (function(){throw inst_42144})();
var state_42316__$1 = (function (){var statearr_42373 = state_42316;
(statearr_42373[(21)] = inst_42145);

return statearr_42373;
})();
var statearr_42374_42443 = state_42316__$1;
(statearr_42374_42443[(2)] = inst_42146);

(statearr_42374_42443[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (9))){
var _ = (function (){var statearr_42375 = state_42316;
(statearr_42375[(4)] = cljs.core.cons((12),(state_42316[(4)])));

return statearr_42375;
})();
var inst_42152 = cljs.core.first(flakes);
var inst_42153 = fluree.db.query.fql.s(inst_42152);
var ___$1 = (function (){var statearr_42376 = state_42316;
(statearr_42376[(4)] = cljs.core.rest((state_42316[(4)])));

return statearr_42376;
})();
var state_42316__$1 = state_42316;
var statearr_42377_42444 = state_42316__$1;
(statearr_42377_42444[(2)] = inst_42153);

(statearr_42377_42444[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (5))){
var _ = (function (){var statearr_42378 = state_42316;
(statearr_42378[(4)] = cljs.core.rest((state_42316[(4)])));

return statearr_42378;
})();
var state_42316__$1 = state_42316;
var ex42372 = (state_42316__$1[(2)]);
var statearr_42379_42445 = state_42316__$1;
(statearr_42379_42445[(5)] = ex42372);


if((ex42372 instanceof Error)){
var statearr_42380_42446 = state_42316__$1;
(statearr_42380_42446[(1)] = (4));

(statearr_42380_42446[(5)] = null);

} else {
throw ex42372;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (14))){
var state_42316__$1 = state_42316;
var statearr_42381_42447 = state_42316__$1;
(statearr_42381_42447[(2)] = base_select_spec);

(statearr_42381_42447[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (45))){
var inst_42257 = (state_42316[(2)]);
var state_42316__$1 = state_42316;
if(cljs.core.truth_(inst_42257)){
var statearr_42382_42448 = state_42316__$1;
(statearr_42382_42448[(1)] = (46));

} else {
var statearr_42383_42449 = state_42316__$1;
(statearr_42383_42449[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (26))){
var inst_42195 = (state_42316[(11)]);
var inst_42199 = cljs.core.empty_QMARK_(inst_42195);
var state_42316__$1 = state_42316;
if(inst_42199){
var statearr_42384_42450 = state_42316__$1;
(statearr_42384_42450[(1)] = (28));

} else {
var statearr_42385_42451 = state_42316__$1;
(statearr_42385_42451[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (16))){
var inst_42163 = (state_42316[(17)]);
var state_42316__$1 = state_42316;
var statearr_42386_42452 = state_42316__$1;
(statearr_42386_42452[(2)] = inst_42163);

(statearr_42386_42452[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (38))){
var inst_42195 = (state_42316[(11)]);
var inst_42230 = (state_42316[(2)]);
var inst_42231 = fluree.db.util.async.throw_err(inst_42230);
var inst_42232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42231,(0),null);
var inst_42233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42231,(1),null);
var inst_42234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42235 = cljs.core.rest(inst_42195);
var inst_42236 = [inst_42232,inst_42235,inst_42233];
var inst_42237 = (new cljs.core.PersistentVector(null,3,(5),inst_42234,inst_42236,null));
var state_42316__$1 = state_42316;
var statearr_42387_42453 = state_42316__$1;
(statearr_42387_42453[(2)] = inst_42237);

(statearr_42387_42453[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (30))){
var inst_42293 = (state_42316[(2)]);
var state_42316__$1 = state_42316;
var statearr_42388_42454 = state_42316__$1;
(statearr_42388_42454[(2)] = inst_42293);

(statearr_42388_42454[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (10))){
var inst_42156 = (state_42316[(2)]);
var inst_42157 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_42316__$1 = (function (){var statearr_42389 = state_42316;
(statearr_42389[(10)] = inst_42156);

return statearr_42389;
})();
if(cljs.core.truth_(inst_42157)){
var statearr_42390_42455 = state_42316__$1;
(statearr_42390_42455[(1)] = (13));

} else {
var statearr_42391_42456 = state_42316__$1;
(statearr_42391_42456[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (18))){
var inst_42168 = (state_42316[(2)]);
var state_42316__$1 = state_42316;
if(cljs.core.truth_(inst_42168)){
var statearr_42392_42457 = state_42316__$1;
(statearr_42392_42457[(1)] = (19));

} else {
var statearr_42393_42458 = state_42316__$1;
(statearr_42393_42458[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (42))){
var inst_42195 = (state_42316[(11)]);
var inst_42241 = (state_42316[(16)]);
var inst_42197 = (state_42316[(13)]);
var inst_42244 = (state_42316[(2)]);
var inst_42245 = fluree.db.util.async.throw_err(inst_42244);
var inst_42246 = cljs.core.first(inst_42245);
var inst_42247 = cljs.core.rest(inst_42195);
var inst_42248 = [inst_42246,inst_42247,inst_42197];
var inst_42249 = (new cljs.core.PersistentVector(null,3,(5),inst_42241,inst_42248,null));
var state_42316__$1 = state_42316;
var statearr_42394_42459 = state_42316__$1;
(statearr_42394_42459[(2)] = inst_42249);

(statearr_42394_42459[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (37))){
var inst_42282 = (state_42316[(2)]);
var state_42316__$1 = state_42316;
var statearr_42395_42460 = state_42316__$1;
(statearr_42395_42460[(2)] = inst_42282);

(statearr_42395_42460[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (8))){
var inst_42311 = (state_42316[(2)]);
var _ = (function (){var statearr_42396 = state_42316;
(statearr_42396[(4)] = cljs.core.rest((state_42316[(4)])));

return statearr_42396;
})();
var state_42316__$1 = state_42316;
var statearr_42397_42461 = state_42316__$1;
(statearr_42397_42461[(2)] = inst_42311);

(statearr_42397_42461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42317 === (49))){
var inst_42195 = (state_42316[(11)]);
var inst_42196 = (state_42316[(12)]);
var inst_42197 = (state_42316[(13)]);
var inst_42270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42271 = cljs.core.rest(inst_42195);
var inst_42272 = [inst_42196,inst_42271,inst_42197];
var inst_42273 = (new cljs.core.PersistentVector(null,3,(5),inst_42270,inst_42272,null));
var state_42316__$1 = state_42316;
var statearr_42398_42462 = state_42316__$1;
(statearr_42398_42462[(2)] = inst_42273);

(statearr_42398_42462[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__17178__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__17178__auto____0 = (function (){
var statearr_42399 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42399[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__17178__auto__);

(statearr_42399[(1)] = (1));

return statearr_42399;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__17178__auto____1 = (function (state_42316){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_42316);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e42400){var ex__17181__auto__ = e42400;
var statearr_42401_42463 = state_42316;
(statearr_42401_42463[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_42316[(4)]))){
var statearr_42402_42464 = state_42316;
(statearr_42402_42464[(1)] = cljs.core.first((state_42316[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42465 = state_42316;
state_42316 = G__42465;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__17178__auto__ = function(state_42316){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__17178__auto____1.call(this,state_42316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__17178__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__17178__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_42403 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_42403[(6)] = c__17304__auto__);

return statearr_42403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__42468 = arguments.length;
switch (G__42468) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_42510){
var state_val_42511 = (state_42510[(1)]);
if((state_val_42511 === (7))){
var inst_42476 = (state_42510[(7)]);
var state_42510__$1 = state_42510;
var statearr_42512_42542 = state_42510__$1;
(statearr_42512_42542[(2)] = inst_42476);

(statearr_42512_42542[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42511 === (1))){
var state_42510__$1 = state_42510;
var statearr_42513_42543 = state_42510__$1;
(statearr_42513_42543[(2)] = null);

(statearr_42513_42543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42511 === (4))){
var inst_42469 = (state_42510[(2)]);
var state_42510__$1 = state_42510;
var statearr_42514_42544 = state_42510__$1;
(statearr_42514_42544[(2)] = inst_42469);

(statearr_42514_42544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42511 === (15))){
var inst_42504 = (state_42510[(2)]);
var inst_42505 = fluree.db.util.async.throw_err(inst_42504);
var _ = (function (){var statearr_42515 = state_42510;
(statearr_42515[(4)] = cljs.core.rest((state_42510[(4)])));

return statearr_42515;
})();
var state_42510__$1 = state_42510;
var statearr_42516_42545 = state_42510__$1;
(statearr_42516_42545[(2)] = inst_42505);

(statearr_42516_42545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42511 === (13))){
var inst_42488 = (state_42510[(8)]);
var state_42510__$1 = state_42510;
var statearr_42517_42546 = state_42510__$1;
(statearr_42517_42546[(2)] = inst_42488);

(statearr_42517_42546[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42511 === (6))){
var inst_42476 = (state_42510[(7)]);
var inst_42478 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_42479 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_42476,inst_42478);
var state_42510__$1 = state_42510;
var statearr_42518_42547 = state_42510__$1;
(statearr_42518_42547[(2)] = inst_42479);

(statearr_42518_42547[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42511 === (3))){
var inst_42508 = (state_42510[(2)]);
var state_42510__$1 = state_42510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42510__$1,inst_42508);
} else {
if((state_val_42511 === (12))){
var inst_42488 = (state_42510[(8)]);
var inst_42490 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_42491 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_42488,inst_42490);
var state_42510__$1 = state_42510;
var statearr_42519_42548 = state_42510__$1;
(statearr_42519_42548[(2)] = inst_42491);

(statearr_42519_42548[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42511 === (2))){
var _ = (function (){var statearr_42520 = state_42510;
(statearr_42520[(4)] = cljs.core.cons((5),(state_42510[(4)])));

return statearr_42520;
})();
var inst_42476 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_42510__$1 = (function (){var statearr_42521 = state_42510;
(statearr_42521[(7)] = inst_42476);

return statearr_42521;
})();
if(cljs.core.truth_(fuel)){
var statearr_42522_42549 = state_42510__$1;
(statearr_42522_42549[(1)] = (6));

} else {
var statearr_42523_42550 = state_42510__$1;
(statearr_42523_42550[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42511 === (11))){
var inst_42488 = (state_42510[(2)]);
var state_42510__$1 = (function (){var statearr_42525 = state_42510;
(statearr_42525[(8)] = inst_42488);

return statearr_42525;
})();
if(cljs.core.truth_(limit)){
var statearr_42526_42551 = state_42510__$1;
(statearr_42526_42551[(1)] = (12));

} else {
var statearr_42527_42552 = state_42510__$1;
(statearr_42527_42552[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42511 === (9))){
var inst_42482 = (state_42510[(9)]);
var inst_42484 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_42485 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_42482,inst_42484);
var state_42510__$1 = state_42510;
var statearr_42528_42553 = state_42510__$1;
(statearr_42528_42553[(2)] = inst_42485);

(statearr_42528_42553[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42511 === (5))){
var _ = (function (){var statearr_42529 = state_42510;
(statearr_42529[(4)] = cljs.core.rest((state_42510[(4)])));

return statearr_42529;
})();
var state_42510__$1 = state_42510;
var ex42524 = (state_42510__$1[(2)]);
var statearr_42530_42554 = state_42510__$1;
(statearr_42530_42554[(5)] = ex42524);


if((ex42524 instanceof Error)){
var statearr_42531_42555 = state_42510__$1;
(statearr_42531_42555[(1)] = (4));

(statearr_42531_42555[(5)] = null);

} else {
throw ex42524;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42511 === (14))){
var inst_42494 = (state_42510[(2)]);
var inst_42495 = (function (){return (function (x){
var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4210__auto__;
}
});
})();
var inst_42496 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_42495);
var inst_42497 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_42494,inst_42496);
var inst_42498 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_42497,flakes);
var inst_42499 = cljs.core.PersistentVector.EMPTY;
var inst_42500 = (function (){var xf = inst_42497;
var flakes_by_sub = inst_42498;
return (function (p1__42466_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__42466_SHARP_);
});
})();
var inst_42501 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_42500,inst_42498);
var inst_42502 = fluree.db.util.async.merge_into_QMARK_(inst_42499,inst_42501);
var state_42510__$1 = state_42510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42510__$1,(15),inst_42502);
} else {
if((state_val_42511 === (10))){
var inst_42482 = (state_42510[(9)]);
var state_42510__$1 = state_42510;
var statearr_42532_42556 = state_42510__$1;
(statearr_42532_42556[(2)] = inst_42482);

(statearr_42532_42556[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42511 === (8))){
var inst_42482 = (state_42510[(2)]);
var state_42510__$1 = (function (){var statearr_42533 = state_42510;
(statearr_42533[(9)] = inst_42482);

return statearr_42533;
})();
if(cljs.core.truth_(offset)){
var statearr_42534_42557 = state_42510__$1;
(statearr_42534_42557[(1)] = (9));

} else {
var statearr_42535_42558 = state_42510__$1;
(statearr_42535_42558[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__17178__auto__ = null;
var fluree$db$query$fql$state_machine__17178__auto____0 = (function (){
var statearr_42536 = [null,null,null,null,null,null,null,null,null,null];
(statearr_42536[(0)] = fluree$db$query$fql$state_machine__17178__auto__);

(statearr_42536[(1)] = (1));

return statearr_42536;
});
var fluree$db$query$fql$state_machine__17178__auto____1 = (function (state_42510){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_42510);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e42537){var ex__17181__auto__ = e42537;
var statearr_42538_42559 = state_42510;
(statearr_42538_42559[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_42510[(4)]))){
var statearr_42539_42560 = state_42510;
(statearr_42539_42560[(1)] = cljs.core.first((state_42510[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42561 = state_42510;
state_42510 = G__42561;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__17178__auto__ = function(state_42510){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__17178__auto____1.call(this,state_42510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__17178__auto____0;
fluree$db$query$fql$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__17178__auto____1;
return fluree$db$query$fql$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_42540 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_42540[(6)] = c__17304__auto__);

return statearr_42540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__42563 = arguments.length;
switch (G__42563) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_42649){
var state_val_42650 = (state_42649[(1)]);
if((state_val_42650 === (7))){
var inst_42644 = (state_42649[(2)]);
var _ = (function (){var statearr_42652 = state_42649;
(statearr_42652[(4)] = cljs.core.rest((state_42649[(4)])));

return statearr_42652;
})();
var state_42649__$1 = state_42649;
var statearr_42653_42705 = state_42649__$1;
(statearr_42653_42705[(2)] = inst_42644);

(statearr_42653_42705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (20))){
var inst_42584 = (state_42649[(7)]);
var inst_42583 = (state_42649[(8)]);
var inst_42591 = (state_42649[(9)]);
var inst_42612 = (inst_42583 + (1));
var tmp42651 = inst_42584;
var inst_42582 = inst_42591;
var inst_42583__$1 = inst_42612;
var inst_42584__$1 = tmp42651;
var state_42649__$1 = (function (){var statearr_42654 = state_42649;
(statearr_42654[(7)] = inst_42584__$1);

(statearr_42654[(8)] = inst_42583__$1);

(statearr_42654[(10)] = inst_42582);

return statearr_42654;
})();
var statearr_42655_42706 = state_42649__$1;
(statearr_42655_42706[(2)] = null);

(statearr_42655_42706[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (27))){
var inst_42622 = (state_42649[(11)]);
var inst_42624 = cljs.core.count(inst_42622);
var inst_42625 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_42624);
var state_42649__$1 = state_42649;
var statearr_42656_42707 = state_42649__$1;
(statearr_42656_42707[(2)] = inst_42625);

(statearr_42656_42707[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (1))){
var state_42649__$1 = state_42649;
var statearr_42657_42708 = state_42649__$1;
(statearr_42657_42708[(2)] = null);

(statearr_42657_42708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (24))){
var state_42649__$1 = state_42649;
var statearr_42658_42709 = state_42649__$1;
(statearr_42658_42709[(2)] = null);

(statearr_42658_42709[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (4))){
var inst_42564 = (state_42649[(2)]);
var state_42649__$1 = state_42649;
var statearr_42659_42710 = state_42649__$1;
(statearr_42659_42710[(2)] = inst_42564);

(statearr_42659_42710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (15))){
var inst_42605 = (state_42649[(12)]);
var inst_42605__$1 = offset;
var state_42649__$1 = (function (){var statearr_42660 = state_42649;
(statearr_42660[(12)] = inst_42605__$1);

return statearr_42660;
})();
if(cljs.core.truth_(inst_42605__$1)){
var statearr_42661_42711 = state_42649__$1;
(statearr_42661_42711[(1)] = (17));

} else {
var statearr_42662_42712 = state_42649__$1;
(statearr_42662_42712[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (21))){
var state_42649__$1 = state_42649;
var statearr_42663_42713 = state_42649__$1;
(statearr_42663_42713[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (13))){
var inst_42600 = (state_42649[(2)]);
var state_42649__$1 = state_42649;
var statearr_42665_42714 = state_42649__$1;
(statearr_42665_42714[(2)] = inst_42600);

(statearr_42665_42714[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (22))){
var inst_42640 = (state_42649[(2)]);
var state_42649__$1 = state_42649;
var statearr_42666_42715 = state_42649__$1;
(statearr_42666_42715[(2)] = inst_42640);

(statearr_42666_42715[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (29))){
var inst_42622 = (state_42649[(11)]);
var inst_42583 = (state_42649[(8)]);
var inst_42628 = (state_42649[(2)]);
var inst_42629 = (inst_42583 + (1));
var inst_42630 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_42622);
var state_42649__$1 = (function (){var statearr_42667 = state_42649;
(statearr_42667[(13)] = inst_42628);

(statearr_42667[(14)] = inst_42629);

return statearr_42667;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42649__$1,(30),inst_42630);
} else {
if((state_val_42650 === (6))){
var inst_42592 = (state_42649[(15)]);
var inst_42590 = (state_42649[(16)]);
var inst_42582 = (state_42649[(10)]);
var inst_42589 = cljs.core.seq(inst_42582);
var inst_42590__$1 = cljs.core.first(inst_42589);
var inst_42591 = cljs.core.next(inst_42589);
var inst_42592__$1 = (inst_42590__$1 == null);
var state_42649__$1 = (function (){var statearr_42668 = state_42649;
(statearr_42668[(15)] = inst_42592__$1);

(statearr_42668[(16)] = inst_42590__$1);

(statearr_42668[(9)] = inst_42591);

return statearr_42668;
})();
if(cljs.core.truth_(inst_42592__$1)){
var statearr_42669_42716 = state_42649__$1;
(statearr_42669_42716[(1)] = (8));

} else {
var statearr_42670_42717 = state_42649__$1;
(statearr_42670_42717[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (28))){
var state_42649__$1 = state_42649;
var statearr_42671_42718 = state_42649__$1;
(statearr_42671_42718[(2)] = null);

(statearr_42671_42718[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (25))){
var inst_42638 = (state_42649[(2)]);
var state_42649__$1 = state_42649;
var statearr_42672_42719 = state_42649__$1;
(statearr_42672_42719[(2)] = inst_42638);

(statearr_42672_42719[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (17))){
var inst_42583 = (state_42649[(8)]);
var inst_42607 = (inst_42583 < offset);
var state_42649__$1 = state_42649;
var statearr_42673_42720 = state_42649__$1;
(statearr_42673_42720[(2)] = inst_42607);

(statearr_42673_42720[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (3))){
var inst_42647 = (state_42649[(2)]);
var state_42649__$1 = state_42649;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42649__$1,inst_42647);
} else {
if((state_val_42650 === (12))){
var inst_42595 = (state_42649[(17)]);
var state_42649__$1 = state_42649;
var statearr_42674_42721 = state_42649__$1;
(statearr_42674_42721[(2)] = inst_42595);

(statearr_42674_42721[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (2))){
var _ = (function (){var statearr_42675 = state_42649;
(statearr_42675[(4)] = cljs.core.cons((5),(state_42649[(4)])));

return statearr_42675;
})();
var inst_42577 = subjects;
var inst_42578 = cljs.core.seq(inst_42577);
var inst_42579 = cljs.core.first(inst_42578);
var inst_42580 = cljs.core.next(inst_42578);
var inst_42581 = cljs.core.PersistentVector.EMPTY;
var inst_42582 = inst_42577;
var inst_42583 = (0);
var inst_42584 = inst_42581;
var state_42649__$1 = (function (){var statearr_42676 = state_42649;
(statearr_42676[(18)] = inst_42580);

(statearr_42676[(7)] = inst_42584);

(statearr_42676[(8)] = inst_42583);

(statearr_42676[(19)] = inst_42579);

(statearr_42676[(10)] = inst_42582);

return statearr_42676;
})();
var statearr_42677_42722 = state_42649__$1;
(statearr_42677_42722[(2)] = null);

(statearr_42677_42722[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (23))){
var inst_42590 = (state_42649[(16)]);
var inst_42616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42617 = [inst_42590];
var inst_42618 = (new cljs.core.PersistentVector(null,1,(5),inst_42616,inst_42617,null));
var inst_42619 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_42618);
var state_42649__$1 = state_42649;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42649__$1,(26),inst_42619);
} else {
if((state_val_42650 === (19))){
var inst_42610 = (state_42649[(2)]);
var state_42649__$1 = state_42649;
if(cljs.core.truth_(inst_42610)){
var statearr_42678_42723 = state_42649__$1;
(statearr_42678_42723[(1)] = (20));

} else {
var statearr_42679_42724 = state_42649__$1;
(statearr_42679_42724[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (11))){
var inst_42583 = (state_42649[(8)]);
var inst_42597 = (inst_42583 > limit);
var state_42649__$1 = state_42649;
var statearr_42681_42725 = state_42649__$1;
(statearr_42681_42725[(2)] = inst_42597);

(statearr_42681_42725[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (9))){
var inst_42595 = (state_42649[(17)]);
var inst_42595__$1 = limit;
var state_42649__$1 = (function (){var statearr_42682 = state_42649;
(statearr_42682[(17)] = inst_42595__$1);

return statearr_42682;
})();
if(cljs.core.truth_(inst_42595__$1)){
var statearr_42683_42726 = state_42649__$1;
(statearr_42683_42726[(1)] = (11));

} else {
var statearr_42684_42727 = state_42649__$1;
(statearr_42684_42727[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (5))){
var _ = (function (){var statearr_42685 = state_42649;
(statearr_42685[(4)] = cljs.core.rest((state_42649[(4)])));

return statearr_42685;
})();
var state_42649__$1 = state_42649;
var ex42680 = (state_42649__$1[(2)]);
var statearr_42686_42728 = state_42649__$1;
(statearr_42686_42728[(5)] = ex42680);


if((ex42680 instanceof Error)){
var statearr_42687_42729 = state_42649__$1;
(statearr_42687_42729[(1)] = (4));

(statearr_42687_42729[(5)] = null);

} else {
throw ex42680;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (14))){
var inst_42584 = (state_42649[(7)]);
var state_42649__$1 = state_42649;
var statearr_42688_42730 = state_42649__$1;
(statearr_42688_42730[(2)] = inst_42584);

(statearr_42688_42730[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (26))){
var inst_42621 = (state_42649[(2)]);
var inst_42622 = fluree.db.util.async.throw_err(inst_42621);
var state_42649__$1 = (function (){var statearr_42689 = state_42649;
(statearr_42689[(11)] = inst_42622);

return statearr_42689;
})();
if(cljs.core.truth_(fuel)){
var statearr_42690_42731 = state_42649__$1;
(statearr_42690_42731[(1)] = (27));

} else {
var statearr_42691_42732 = state_42649__$1;
(statearr_42691_42732[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (16))){
var inst_42642 = (state_42649[(2)]);
var state_42649__$1 = state_42649;
var statearr_42692_42733 = state_42649__$1;
(statearr_42692_42733[(2)] = inst_42642);

(statearr_42692_42733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (30))){
var inst_42584 = (state_42649[(7)]);
var inst_42591 = (state_42649[(9)]);
var inst_42629 = (state_42649[(14)]);
var inst_42632 = (state_42649[(2)]);
var inst_42633 = fluree.db.util.async.throw_err(inst_42632);
var inst_42634 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42584,inst_42633);
var inst_42582 = inst_42591;
var inst_42583 = inst_42629;
var inst_42584__$1 = inst_42634;
var state_42649__$1 = (function (){var statearr_42693 = state_42649;
(statearr_42693[(7)] = inst_42584__$1);

(statearr_42693[(8)] = inst_42583);

(statearr_42693[(10)] = inst_42582);

return statearr_42693;
})();
var statearr_42694_42734 = state_42649__$1;
(statearr_42694_42734[(2)] = null);

(statearr_42694_42734[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (10))){
var inst_42602 = (state_42649[(2)]);
var state_42649__$1 = state_42649;
if(cljs.core.truth_(inst_42602)){
var statearr_42695_42735 = state_42649__$1;
(statearr_42695_42735[(1)] = (14));

} else {
var statearr_42696_42736 = state_42649__$1;
(statearr_42696_42736[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (18))){
var inst_42605 = (state_42649[(12)]);
var state_42649__$1 = state_42649;
var statearr_42697_42737 = state_42649__$1;
(statearr_42697_42737[(2)] = inst_42605);

(statearr_42697_42737[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42650 === (8))){
var inst_42592 = (state_42649[(15)]);
var state_42649__$1 = state_42649;
var statearr_42698_42738 = state_42649__$1;
(statearr_42698_42738[(2)] = inst_42592);

(statearr_42698_42738[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__17178__auto__ = null;
var fluree$db$query$fql$state_machine__17178__auto____0 = (function (){
var statearr_42699 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42699[(0)] = fluree$db$query$fql$state_machine__17178__auto__);

(statearr_42699[(1)] = (1));

return statearr_42699;
});
var fluree$db$query$fql$state_machine__17178__auto____1 = (function (state_42649){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_42649);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e42700){var ex__17181__auto__ = e42700;
var statearr_42701_42739 = state_42649;
(statearr_42701_42739[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_42649[(4)]))){
var statearr_42702_42740 = state_42649;
(statearr_42702_42740[(1)] = cljs.core.first((state_42649[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42741 = state_42649;
state_42649 = G__42741;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__17178__auto__ = function(state_42649){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__17178__auto____1.call(this,state_42649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__17178__auto____0;
fluree$db$query$fql$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__17178__auto____1;
return fluree$db$query$fql$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_42703 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_42703[(6)] = c__17304__auto__);

return statearr_42703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4212__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__42743 = arguments.length;
switch (G__42743) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__42744){
var map__42745 = p__42744;
var map__42745__$1 = cljs.core.__destructure_map(map__42745);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42745__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42745__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_43009){
var state_val_43010 = (state_43009[(1)]);
if((state_val_43010 === (65))){
var inst_42972 = (state_43009[(7)]);
var inst_42972__$1 = (state_43009[(2)]);
var state_43009__$1 = (function (){var statearr_43011 = state_43009;
(statearr_43011[(7)] = inst_42972__$1);

return statearr_43011;
})();
if(cljs.core.truth_(inst_42972__$1)){
var statearr_43012_43130 = state_43009__$1;
(statearr_43012_43130[(1)] = (66));

} else {
var statearr_43013_43131 = state_43009__$1;
(statearr_43013_43131[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (70))){
var inst_42975 = (state_43009[(8)]);
var state_43009__$1 = state_43009;
var statearr_43014_43132 = state_43009__$1;
(statearr_43014_43132[(2)] = inst_42975);

(statearr_43014_43132[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (62))){
var inst_42963 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43015_43133 = state_43009__$1;
(statearr_43015_43133[(2)] = inst_42963);

(statearr_43015_43133[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (74))){
var inst_42982 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43016_43134 = state_43009__$1;
(statearr_43016_43134[(2)] = inst_42982);

(statearr_43016_43134[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (7))){
var inst_42758 = (state_43009[(9)]);
var state_43009__$1 = state_43009;
var statearr_43017_43135 = state_43009__$1;
(statearr_43017_43135[(2)] = inst_42758);

(statearr_43017_43135[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (59))){
var inst_42787 = (state_43009[(10)]);
var inst_42955 = cljs.core.empty_QMARK_(inst_42787);
var state_43009__$1 = state_43009;
if(inst_42955){
var statearr_43018_43136 = state_43009__$1;
(statearr_43018_43136[(1)] = (60));

} else {
var statearr_43019_43137 = state_43009__$1;
(statearr_43019_43137[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (20))){
var state_43009__$1 = state_43009;
if(cljs.core.truth_(offset)){
var statearr_43020_43138 = state_43009__$1;
(statearr_43020_43138[(1)] = (23));

} else {
var statearr_43021_43139 = state_43009__$1;
(statearr_43021_43139[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (72))){
var inst_42772 = (state_43009[(11)]);
var inst_42952 = (state_43009[(12)]);
var inst_42978 = cljs.core.count(inst_42952);
var inst_42979 = (inst_42978 > inst_42772);
var state_43009__$1 = state_43009;
var statearr_43022_43140 = state_43009__$1;
(statearr_43022_43140[(2)] = inst_42979);

(statearr_43022_43140[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (58))){
var inst_42787 = (state_43009[(10)]);
var inst_42952 = (state_43009[(12)]);
var inst_42953 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_42787,inst_42952);
var state_43009__$1 = state_43009;
var statearr_43023_43141 = state_43009__$1;
(statearr_43023_43141[(2)] = inst_42953);

(statearr_43023_43141[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (60))){
var inst_42787 = (state_43009[(10)]);
var inst_42952 = (state_43009[(12)]);
var inst_42957 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_42787,inst_42952);
var state_43009__$1 = state_43009;
var statearr_43024_43142 = state_43009__$1;
(statearr_43024_43142[(2)] = inst_42957);

(statearr_43024_43142[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (27))){
var inst_42802 = (state_43009[(13)]);
var state_43009__$1 = state_43009;
var statearr_43025_43143 = state_43009__$1;
(statearr_43025_43143[(2)] = inst_42802);

(statearr_43025_43143[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (1))){
var state_43009__$1 = state_43009;
var statearr_43026_43144 = state_43009__$1;
(statearr_43026_43144[(2)] = null);

(statearr_43026_43144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (69))){
var inst_42772 = (state_43009[(11)]);
var state_43009__$1 = state_43009;
if(cljs.core.truth_(inst_42772)){
var statearr_43027_43145 = state_43009__$1;
(statearr_43027_43145[(1)] = (72));

} else {
var statearr_43028_43146 = state_43009__$1;
(statearr_43028_43146[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (24))){
var inst_42787 = (state_43009[(10)]);
var state_43009__$1 = state_43009;
var statearr_43029_43147 = state_43009__$1;
(statearr_43029_43147[(2)] = inst_42787);

(statearr_43029_43147[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (55))){
var inst_42941 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43030_43148 = state_43009__$1;
(statearr_43030_43148[(2)] = inst_42941);

(statearr_43030_43148[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (39))){
var inst_42949 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43031_43149 = state_43009__$1;
(statearr_43031_43149[(2)] = inst_42949);

(statearr_43031_43149[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (46))){
var inst_42831 = (state_43009[(14)]);
var inst_42813 = (state_43009[(15)]);
var inst_42907 = (inst_42831.cljs$core$IFn$_invoke$arity$2 ? inst_42831.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_42813) : inst_42831.call(null,cljs.core._LT_,inst_42813));
var state_43009__$1 = state_43009;
if(cljs.core.truth_(inst_42907)){
var statearr_43032_43150 = state_43009__$1;
(statearr_43032_43150[(1)] = (49));

} else {
var statearr_43033_43151 = state_43009__$1;
(statearr_43033_43151[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (4))){
var inst_42746 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43034_43152 = state_43009__$1;
(statearr_43034_43152[(2)] = inst_42746);

(statearr_43034_43152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (77))){
var inst_42997 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43035_43153 = state_43009__$1;
(statearr_43035_43153[(2)] = inst_42997);

(statearr_43035_43153[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (54))){
var inst_42939 = cljs.core.PersistentVector.EMPTY;
var state_43009__$1 = state_43009;
var statearr_43036_43154 = state_43009__$1;
(statearr_43036_43154[(2)] = inst_42939);

(statearr_43036_43154[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (15))){
var inst_42757 = (state_43009[(16)]);
var inst_42782 = cljs.core.seq(inst_42757);
var inst_42783 = cljs.core.first(inst_42782);
var inst_42784 = cljs.core.next(inst_42782);
var inst_42785 = cljs.core.PersistentHashSet.EMPTY;
var inst_42786 = inst_42757;
var inst_42787 = inst_42785;
var state_43009__$1 = (function (){var statearr_43037 = state_43009;
(statearr_43037[(17)] = inst_42786);

(statearr_43037[(10)] = inst_42787);

(statearr_43037[(18)] = inst_42783);

(statearr_43037[(19)] = inst_42784);

return statearr_43037;
})();
var statearr_43038_43155 = state_43009__$1;
(statearr_43038_43155[(2)] = null);

(statearr_43038_43155[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (48))){
var inst_42904 = (state_43009[(2)]);
var inst_42905 = fluree.db.util.async.throw_err(inst_42904);
var state_43009__$1 = state_43009;
var statearr_43039_43156 = state_43009__$1;
(statearr_43039_43156[(2)] = inst_42905);

(statearr_43039_43156[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (50))){
var inst_42831 = (state_43009[(14)]);
var inst_42813 = (state_43009[(15)]);
var inst_42923 = (inst_42831.cljs$core$IFn$_invoke$arity$2 ? inst_42831.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_42813) : inst_42831.call(null,cljs.core._LT__EQ_,inst_42813));
var state_43009__$1 = state_43009;
if(cljs.core.truth_(inst_42923)){
var statearr_43040_43157 = state_43009__$1;
(statearr_43040_43157[(1)] = (53));

} else {
var statearr_43041_43158 = state_43009__$1;
(statearr_43041_43158[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (75))){
var state_43009__$1 = state_43009;
if(cljs.core.truth_(offset)){
var statearr_43042_43159 = state_43009__$1;
(statearr_43042_43159[(1)] = (78));

} else {
var statearr_43043_43160 = state_43009__$1;
(statearr_43043_43160[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (21))){
var inst_42812 = (state_43009[(20)]);
var inst_42793 = (state_43009[(21)]);
var inst_42812__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42793,(0),null);
var inst_42813 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42793,(1),null);
var inst_42814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42793,(2),null);
var inst_42815 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_42812__$1);
var inst_42816 = cljs.core.not(inst_42815);
var state_43009__$1 = (function (){var statearr_43044 = state_43009;
(statearr_43044[(15)] = inst_42813);

(statearr_43044[(22)] = inst_42814);

(statearr_43044[(20)] = inst_42812__$1);

return statearr_43044;
})();
if(inst_42816){
var statearr_43045_43161 = state_43009__$1;
(statearr_43045_43161[(1)] = (29));

} else {
var statearr_43046_43162 = state_43009__$1;
(statearr_43046_43162[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (31))){
var inst_42831 = (state_43009[(14)]);
var inst_42813 = (state_43009[(15)]);
var inst_42827 = (state_43009[(2)]);
var inst_42831__$1 = cljs.core.identical_QMARK_;
var inst_42832 = (inst_42831__$1.cljs$core$IFn$_invoke$arity$2 ? inst_42831__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_42813) : inst_42831__$1.call(null,cljs.core.not_EQ_,inst_42813));
var state_43009__$1 = (function (){var statearr_43047 = state_43009;
(statearr_43047[(14)] = inst_42831__$1);

(statearr_43047[(23)] = inst_42827);

return statearr_43047;
})();
if(cljs.core.truth_(inst_42832)){
var statearr_43048_43163 = state_43009__$1;
(statearr_43048_43163[(1)] = (32));

} else {
var statearr_43049_43164 = state_43009__$1;
(statearr_43049_43164[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (32))){
var inst_42772 = (state_43009[(11)]);
var inst_42814 = (state_43009[(22)]);
var inst_42812 = (state_43009[(20)]);
var inst_42834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42835 = [inst_42812,inst_42814];
var inst_42836 = (new cljs.core.PersistentVector(null,2,(5),inst_42834,inst_42835,null));
var inst_42837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42838 = [inst_42812];
var inst_42839 = (new cljs.core.PersistentVector(null,1,(5),inst_42837,inst_42838,null));
var inst_42840 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_42841 = [inst_42772];
var inst_42842 = cljs.core.PersistentHashMap.fromArrays(inst_42840,inst_42841);
var inst_42843 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_42836,cljs.core._LT__EQ_,inst_42839,inst_42842);
var state_43009__$1 = state_43009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43009__$1,(35),inst_42843);
} else {
if((state_val_43010 === (40))){
var inst_42872 = (state_43009[(2)]);
var inst_42873 = fluree.db.util.async.throw_err(inst_42872);
var state_43009__$1 = state_43009;
var statearr_43050_43165 = state_43009__$1;
(statearr_43050_43165[(2)] = inst_42873);

(statearr_43050_43165[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (56))){
var inst_42936 = (state_43009[(2)]);
var inst_42937 = fluree.db.util.async.throw_err(inst_42936);
var state_43009__$1 = state_43009;
var statearr_43051_43166 = state_43009__$1;
(statearr_43051_43166[(2)] = inst_42937);

(statearr_43051_43166[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (33))){
var inst_42831 = (state_43009[(14)]);
var inst_42813 = (state_43009[(15)]);
var inst_42862 = (inst_42831.cljs$core$IFn$_invoke$arity$2 ? inst_42831.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_42813) : inst_42831.call(null,cljs.core._EQ_,inst_42813));
var state_43009__$1 = state_43009;
if(cljs.core.truth_(inst_42862)){
var statearr_43052_43167 = state_43009__$1;
(statearr_43052_43167[(1)] = (37));

} else {
var statearr_43053_43168 = state_43009__$1;
(statearr_43053_43168[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (13))){
var state_43009__$1 = state_43009;
var statearr_43054_43169 = state_43009__$1;
(statearr_43054_43169[(2)] = limit);

(statearr_43054_43169[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (22))){
var inst_42999 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43055_43170 = state_43009__$1;
(statearr_43055_43170[(2)] = inst_42999);

(statearr_43055_43170[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (36))){
var inst_42846 = (state_43009[(24)]);
var inst_42858 = (state_43009[(2)]);
var inst_42859 = fluree.db.util.async.throw_err(inst_42858);
var inst_42860 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_42846,inst_42859);
var state_43009__$1 = state_43009;
var statearr_43056_43171 = state_43009__$1;
(statearr_43056_43171[(2)] = inst_42860);

(statearr_43056_43171[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (41))){
var inst_42772 = (state_43009[(11)]);
var inst_42814 = (state_43009[(22)]);
var inst_42812 = (state_43009[(20)]);
var inst_42877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42878 = [inst_42812,inst_42814];
var inst_42879 = (new cljs.core.PersistentVector(null,2,(5),inst_42877,inst_42878,null));
var inst_42880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42881 = [inst_42812];
var inst_42882 = (new cljs.core.PersistentVector(null,1,(5),inst_42880,inst_42881,null));
var inst_42883 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_42884 = [inst_42772];
var inst_42885 = cljs.core.PersistentHashMap.fromArrays(inst_42883,inst_42884);
var inst_42886 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_42879,cljs.core._LT__EQ_,inst_42882,inst_42885);
var state_43009__$1 = state_43009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43009__$1,(44),inst_42886);
} else {
if((state_val_43010 === (43))){
var inst_42947 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43057_43172 = state_43009__$1;
(statearr_43057_43172[(2)] = inst_42947);

(statearr_43057_43172[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (61))){
var inst_42787 = (state_43009[(10)]);
var inst_42952 = (state_43009[(12)]);
var inst_42959 = cljs.core.PersistentHashSet.EMPTY;
var inst_42960 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_42959,inst_42952);
var inst_42961 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_42787,inst_42960);
var state_43009__$1 = state_43009;
var statearr_43058_43173 = state_43009__$1;
(statearr_43058_43173[(2)] = inst_42961);

(statearr_43058_43173[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (29))){
var inst_42812 = (state_43009[(20)]);
var inst_42818 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_42812);
var inst_42819 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42818)].join('');
var inst_42820 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_42821 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_42822 = cljs.core.PersistentHashMap.fromArrays(inst_42820,inst_42821);
var inst_42823 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42819,inst_42822);
var inst_42824 = (function(){throw inst_42823})();
var state_43009__$1 = state_43009;
var statearr_43059_43174 = state_43009__$1;
(statearr_43059_43174[(2)] = inst_42824);

(statearr_43059_43174[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (44))){
var inst_42888 = (state_43009[(2)]);
var inst_42889 = fluree.db.util.async.throw_err(inst_42888);
var state_43009__$1 = state_43009;
var statearr_43060_43175 = state_43009__$1;
(statearr_43060_43175[(2)] = inst_42889);

(statearr_43060_43175[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (6))){
var inst_42756 = (state_43009[(25)]);
var inst_42760 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_42756);
var state_43009__$1 = state_43009;
var statearr_43061_43176 = state_43009__$1;
(statearr_43061_43176[(2)] = inst_42760);

(statearr_43061_43176[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (28))){
var inst_42807 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43062_43177 = state_43009__$1;
(statearr_43062_43177[(2)] = inst_42807);

(statearr_43062_43177[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (64))){
var inst_42967 = (state_43009[(26)]);
var state_43009__$1 = state_43009;
var statearr_43063_43178 = state_43009__$1;
(statearr_43063_43178[(2)] = inst_42967);

(statearr_43063_43178[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (51))){
var inst_42943 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43064_43179 = state_43009__$1;
(statearr_43064_43179[(2)] = inst_42943);

(statearr_43064_43179[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (25))){
var inst_42802 = (state_43009[(2)]);
var state_43009__$1 = (function (){var statearr_43065 = state_43009;
(statearr_43065[(13)] = inst_42802);

return statearr_43065;
})();
if(cljs.core.truth_(limit)){
var statearr_43066_43180 = state_43009__$1;
(statearr_43066_43180[(1)] = (26));

} else {
var statearr_43067_43181 = state_43009__$1;
(statearr_43067_43181[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (34))){
var inst_42756 = (state_43009[(25)]);
var inst_42951 = (state_43009[(2)]);
var inst_42952 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_42951);
var state_43009__$1 = (function (){var statearr_43068 = state_43009;
(statearr_43068[(12)] = inst_42952);

return statearr_43068;
})();
var G__43069_43182 = inst_42756;
var G__43069_43183__$1 = (((G__43069_43182 instanceof cljs.core.Keyword))?G__43069_43182.fqn:null);
switch (G__43069_43183__$1) {
case "or":
var statearr_43070_43185 = state_43009__$1;
(statearr_43070_43185[(1)] = (58));


break;
case "and":
var statearr_43071_43186 = state_43009__$1;
(statearr_43071_43186[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43069_43183__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (17))){
var inst_43004 = (state_43009[(2)]);
var _ = (function (){var statearr_43072 = state_43009;
(statearr_43072[(4)] = cljs.core.rest((state_43009[(4)])));

return statearr_43072;
})();
var state_43009__$1 = state_43009;
var statearr_43073_43187 = state_43009__$1;
(statearr_43073_43187[(2)] = inst_43004);

(statearr_43073_43187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (3))){
var inst_43007 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43009__$1,inst_43007);
} else {
if((state_val_43010 === (12))){
var inst_42766 = (offset + limit);
var state_43009__$1 = state_43009;
var statearr_43074_43188 = state_43009__$1;
(statearr_43074_43188[(2)] = inst_42766);

(statearr_43074_43188[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (2))){
var inst_42758 = (state_43009[(9)]);
var _ = (function (){var statearr_43075 = state_43009;
(statearr_43075[(4)] = cljs.core.cons((5),(state_43009[(4)])));

return statearr_43075;
})();
var inst_42755 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_42756 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42755,(0),null);
var inst_42757 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42755,(1),null);
var inst_42758__$1 = limit;
var state_43009__$1 = (function (){var statearr_43076 = state_43009;
(statearr_43076[(16)] = inst_42757);

(statearr_43076[(9)] = inst_42758__$1);

(statearr_43076[(25)] = inst_42756);

return statearr_43076;
})();
if(cljs.core.truth_(inst_42758__$1)){
var statearr_43077_43189 = state_43009__$1;
(statearr_43077_43189[(1)] = (6));

} else {
var statearr_43078_43190 = state_43009__$1;
(statearr_43078_43190[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (66))){
var inst_42972 = (state_43009[(7)]);
var state_43009__$1 = state_43009;
var statearr_43079_43191 = state_43009__$1;
(statearr_43079_43191[(2)] = inst_42972);

(statearr_43079_43191[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (23))){
var inst_42787 = (state_43009[(10)]);
var inst_42799 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_42787);
var state_43009__$1 = state_43009;
var statearr_43080_43192 = state_43009__$1;
(statearr_43080_43192[(2)] = inst_42799);

(statearr_43080_43192[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (47))){
var inst_42945 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43081_43193 = state_43009__$1;
(statearr_43081_43193[(2)] = inst_42945);

(statearr_43081_43193[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (35))){
var inst_42772 = (state_43009[(11)]);
var inst_42814 = (state_43009[(22)]);
var inst_42812 = (state_43009[(20)]);
var inst_42845 = (state_43009[(2)]);
var inst_42846 = fluree.db.util.async.throw_err(inst_42845);
var inst_42847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42848 = [inst_42812];
var inst_42849 = (new cljs.core.PersistentVector(null,1,(5),inst_42847,inst_42848,null));
var inst_42850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42851 = [inst_42812,inst_42814];
var inst_42852 = (new cljs.core.PersistentVector(null,2,(5),inst_42850,inst_42851,null));
var inst_42853 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_42854 = [inst_42772];
var inst_42855 = cljs.core.PersistentHashMap.fromArrays(inst_42853,inst_42854);
var inst_42856 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_42849,cljs.core._LT_,inst_42852,inst_42855);
var state_43009__$1 = (function (){var statearr_43082 = state_43009;
(statearr_43082[(24)] = inst_42846);

return statearr_43082;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43009__$1,(36),inst_42856);
} else {
if((state_val_43010 === (76))){
var inst_42966 = (state_43009[(27)]);
var inst_42794 = (state_43009[(28)]);
var inst_42786 = inst_42794;
var inst_42787 = inst_42966;
var state_43009__$1 = (function (){var statearr_43083 = state_43009;
(statearr_43083[(17)] = inst_42786);

(statearr_43083[(10)] = inst_42787);

return statearr_43083;
})();
var statearr_43084_43194 = state_43009__$1;
(statearr_43084_43194[(2)] = null);

(statearr_43084_43194[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (19))){
var inst_43001 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43085_43195 = state_43009__$1;
(statearr_43085_43195[(2)] = inst_43001);

(statearr_43085_43195[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (57))){
var inst_42967 = (state_43009[(26)]);
var inst_42756 = (state_43009[(25)]);
var inst_42966 = (state_43009[(2)]);
var inst_42967__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_42756);
var state_43009__$1 = (function (){var statearr_43086 = state_43009;
(statearr_43086[(26)] = inst_42967__$1);

(statearr_43086[(27)] = inst_42966);

return statearr_43086;
})();
if(inst_42967__$1){
var statearr_43087_43196 = state_43009__$1;
(statearr_43087_43196[(1)] = (63));

} else {
var statearr_43088_43197 = state_43009__$1;
(statearr_43088_43197[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (68))){
var inst_42987 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
if(cljs.core.truth_(inst_42987)){
var statearr_43089_43198 = state_43009__$1;
(statearr_43089_43198[(1)] = (75));

} else {
var statearr_43090_43199 = state_43009__$1;
(statearr_43090_43199[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (11))){
var inst_42757 = (state_43009[(16)]);
var inst_42772 = (state_43009[(2)]);
var inst_42773 = cljs.core.not_empty(inst_42757);
var state_43009__$1 = (function (){var statearr_43092 = state_43009;
(statearr_43092[(11)] = inst_42772);

return statearr_43092;
})();
if(cljs.core.truth_(inst_42773)){
var statearr_43093_43200 = state_43009__$1;
(statearr_43093_43200[(1)] = (15));

} else {
var statearr_43094_43201 = state_43009__$1;
(statearr_43094_43201[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (9))){
var state_43009__$1 = state_43009;
if(cljs.core.truth_(offset)){
var statearr_43095_43202 = state_43009__$1;
(statearr_43095_43202[(1)] = (12));

} else {
var statearr_43096_43203 = state_43009__$1;
(statearr_43096_43203[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (5))){
var _ = (function (){var statearr_43097 = state_43009;
(statearr_43097[(4)] = cljs.core.rest((state_43009[(4)])));

return statearr_43097;
})();
var state_43009__$1 = state_43009;
var ex43091 = (state_43009__$1[(2)]);
var statearr_43098_43204 = state_43009__$1;
(statearr_43098_43204[(5)] = ex43091);


if((ex43091 instanceof Error)){
var statearr_43099_43205 = state_43009__$1;
(statearr_43099_43205[(1)] = (4));

(statearr_43099_43205[(5)] = null);

} else {
throw ex43091;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (14))){
var inst_42769 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43100_43206 = state_43009__$1;
(statearr_43100_43206[(2)] = inst_42769);

(statearr_43100_43206[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (45))){
var inst_42772 = (state_43009[(11)]);
var inst_42814 = (state_43009[(22)]);
var inst_42812 = (state_43009[(20)]);
var inst_42893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42894 = [inst_42812,inst_42814];
var inst_42895 = (new cljs.core.PersistentVector(null,2,(5),inst_42893,inst_42894,null));
var inst_42896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42897 = [inst_42812];
var inst_42898 = (new cljs.core.PersistentVector(null,1,(5),inst_42896,inst_42897,null));
var inst_42899 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_42900 = [inst_42772];
var inst_42901 = cljs.core.PersistentHashMap.fromArrays(inst_42899,inst_42900);
var inst_42902 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_42895,cljs.core._LT__EQ_,inst_42898,inst_42901);
var state_43009__$1 = state_43009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43009__$1,(48),inst_42902);
} else {
if((state_val_43010 === (53))){
var inst_42772 = (state_43009[(11)]);
var inst_42814 = (state_43009[(22)]);
var inst_42812 = (state_43009[(20)]);
var inst_42925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42926 = [inst_42812];
var inst_42927 = (new cljs.core.PersistentVector(null,1,(5),inst_42925,inst_42926,null));
var inst_42928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42929 = [inst_42812,inst_42814];
var inst_42930 = (new cljs.core.PersistentVector(null,2,(5),inst_42928,inst_42929,null));
var inst_42931 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_42932 = [inst_42772];
var inst_42933 = cljs.core.PersistentHashMap.fromArrays(inst_42931,inst_42932);
var inst_42934 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_42927,cljs.core._LT__EQ_,inst_42930,inst_42933);
var state_43009__$1 = state_43009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43009__$1,(56),inst_42934);
} else {
if((state_val_43010 === (78))){
var inst_42966 = (state_43009[(27)]);
var inst_42990 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_42966);
var state_43009__$1 = state_43009;
var statearr_43101_43207 = state_43009__$1;
(statearr_43101_43207[(2)] = inst_42990);

(statearr_43101_43207[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (26))){
var inst_42802 = (state_43009[(13)]);
var inst_42804 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_42802);
var state_43009__$1 = state_43009;
var statearr_43102_43208 = state_43009__$1;
(statearr_43102_43208[(2)] = inst_42804);

(statearr_43102_43208[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (16))){
var state_43009__$1 = state_43009;
var statearr_43103_43209 = state_43009__$1;
(statearr_43103_43209[(2)] = null);

(statearr_43103_43209[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (79))){
var inst_42966 = (state_43009[(27)]);
var state_43009__$1 = state_43009;
var statearr_43104_43210 = state_43009__$1;
(statearr_43104_43210[(2)] = inst_42966);

(statearr_43104_43210[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (38))){
var inst_42831 = (state_43009[(14)]);
var inst_42813 = (state_43009[(15)]);
var inst_42875 = (inst_42831.cljs$core$IFn$_invoke$arity$2 ? inst_42831.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_42813) : inst_42831.call(null,cljs.core._GT_,inst_42813));
var state_43009__$1 = state_43009;
if(cljs.core.truth_(inst_42875)){
var statearr_43105_43211 = state_43009__$1;
(statearr_43105_43211[(1)] = (41));

} else {
var statearr_43106_43212 = state_43009__$1;
(statearr_43106_43212[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (30))){
var state_43009__$1 = state_43009;
var statearr_43107_43213 = state_43009__$1;
(statearr_43107_43213[(2)] = null);

(statearr_43107_43213[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (73))){
var inst_42772 = (state_43009[(11)]);
var state_43009__$1 = state_43009;
var statearr_43108_43214 = state_43009__$1;
(statearr_43108_43214[(2)] = inst_42772);

(statearr_43108_43214[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (10))){
var state_43009__$1 = state_43009;
var statearr_43109_43215 = state_43009__$1;
(statearr_43109_43215[(2)] = null);

(statearr_43109_43215[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (18))){
var inst_42786 = (state_43009[(17)]);
var inst_42793 = (state_43009[(21)]);
var inst_42792 = cljs.core.seq(inst_42786);
var inst_42793__$1 = cljs.core.first(inst_42792);
var inst_42794 = cljs.core.next(inst_42792);
var inst_42795 = cljs.core.not(inst_42793__$1);
var state_43009__$1 = (function (){var statearr_43110 = state_43009;
(statearr_43110[(28)] = inst_42794);

(statearr_43110[(21)] = inst_42793__$1);

return statearr_43110;
})();
if(inst_42795){
var statearr_43111_43216 = state_43009__$1;
(statearr_43111_43216[(1)] = (20));

} else {
var statearr_43112_43217 = state_43009__$1;
(statearr_43112_43217[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (52))){
var inst_42920 = (state_43009[(2)]);
var inst_42921 = fluree.db.util.async.throw_err(inst_42920);
var state_43009__$1 = state_43009;
var statearr_43113_43218 = state_43009__$1;
(statearr_43113_43218[(2)] = inst_42921);

(statearr_43113_43218[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (67))){
var inst_42975 = (state_43009[(8)]);
var inst_42756 = (state_43009[(25)]);
var inst_42975__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_42756);
var state_43009__$1 = (function (){var statearr_43114 = state_43009;
(statearr_43114[(8)] = inst_42975__$1);

return statearr_43114;
})();
if(inst_42975__$1){
var statearr_43115_43219 = state_43009__$1;
(statearr_43115_43219[(1)] = (69));

} else {
var statearr_43116_43220 = state_43009__$1;
(statearr_43116_43220[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (71))){
var inst_42985 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43117_43221 = state_43009__$1;
(statearr_43117_43221[(2)] = inst_42985);

(statearr_43117_43221[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (42))){
var inst_42831 = (state_43009[(14)]);
var inst_42813 = (state_43009[(15)]);
var inst_42891 = (inst_42831.cljs$core$IFn$_invoke$arity$2 ? inst_42831.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_42813) : inst_42831.call(null,cljs.core._GT__EQ_,inst_42813));
var state_43009__$1 = state_43009;
if(cljs.core.truth_(inst_42891)){
var statearr_43118_43222 = state_43009__$1;
(statearr_43118_43222[(1)] = (45));

} else {
var statearr_43119_43223 = state_43009__$1;
(statearr_43119_43223[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (80))){
var inst_42993 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
var statearr_43120_43224 = state_43009__$1;
(statearr_43120_43224[(2)] = inst_42993);

(statearr_43120_43224[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (37))){
var inst_42772 = (state_43009[(11)]);
var inst_42814 = (state_43009[(22)]);
var inst_42812 = (state_43009[(20)]);
var inst_42864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42865 = [inst_42812,inst_42814];
var inst_42866 = (new cljs.core.PersistentVector(null,2,(5),inst_42864,inst_42865,null));
var inst_42867 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_42868 = [inst_42772];
var inst_42869 = cljs.core.PersistentHashMap.fromArrays(inst_42867,inst_42868);
var inst_42870 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_42866,inst_42869);
var state_43009__$1 = state_43009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43009__$1,(40),inst_42870);
} else {
if((state_val_43010 === (63))){
var inst_42966 = (state_43009[(27)]);
var inst_42969 = cljs.core.empty_QMARK_(inst_42966);
var state_43009__$1 = state_43009;
var statearr_43121_43225 = state_43009__$1;
(statearr_43121_43225[(2)] = inst_42969);

(statearr_43121_43225[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (8))){
var inst_42763 = (state_43009[(2)]);
var state_43009__$1 = state_43009;
if(cljs.core.truth_(inst_42763)){
var statearr_43122_43226 = state_43009__$1;
(statearr_43122_43226[(1)] = (9));

} else {
var statearr_43123_43227 = state_43009__$1;
(statearr_43123_43227[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43010 === (49))){
var inst_42772 = (state_43009[(11)]);
var inst_42814 = (state_43009[(22)]);
var inst_42812 = (state_43009[(20)]);
var inst_42909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42910 = [inst_42812];
var inst_42911 = (new cljs.core.PersistentVector(null,1,(5),inst_42909,inst_42910,null));
var inst_42912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42913 = [inst_42812,inst_42814];
var inst_42914 = (new cljs.core.PersistentVector(null,2,(5),inst_42912,inst_42913,null));
var inst_42915 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_42916 = [inst_42772];
var inst_42917 = cljs.core.PersistentHashMap.fromArrays(inst_42915,inst_42916);
var inst_42918 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_42911,cljs.core._LT_,inst_42914,inst_42917);
var state_43009__$1 = state_43009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43009__$1,(52),inst_42918);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__17178__auto__ = null;
var fluree$db$query$fql$state_machine__17178__auto____0 = (function (){
var statearr_43124 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43124[(0)] = fluree$db$query$fql$state_machine__17178__auto__);

(statearr_43124[(1)] = (1));

return statearr_43124;
});
var fluree$db$query$fql$state_machine__17178__auto____1 = (function (state_43009){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_43009);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e43125){var ex__17181__auto__ = e43125;
var statearr_43126_43228 = state_43009;
(statearr_43126_43228[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_43009[(4)]))){
var statearr_43127_43229 = state_43009;
(statearr_43127_43229[(1)] = cljs.core.first((state_43009[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43230 = state_43009;
state_43009 = G__43230;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__17178__auto__ = function(state_43009){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__17178__auto____1.call(this,state_43009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__17178__auto____0;
fluree$db$query$fql$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__17178__auto____1;
return fluree$db$query$fql$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_43128 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_43128[(6)] = c__17304__auto__);

return statearr_43128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4212__auto__ = cljs.core.every_QMARK_((function (p1__43231_SHARP_){
return ((typeof p1__43231_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__43231_SHARP_)));
}),select_smt);
if(or__4212__auto__){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__43232_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__43232_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__43236 = vars;
var vec__43237 = G__43236;
var seq__43238 = cljs.core.seq(vec__43237);
var first__43239 = cljs.core.first(seq__43238);
var seq__43238__$1 = cljs.core.next(seq__43238);
var var$ = first__43239;
var r = seq__43238__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__43236__$1 = G__43236;
var all_vars__$1 = all_vars;
while(true){
var vec__43244 = G__43236__$1;
var seq__43245 = cljs.core.seq(vec__43244);
var first__43246 = cljs.core.first(seq__43245);
var seq__43245__$1 = cljs.core.next(seq__43245);
var var$__$1 = first__43246;
var r__$1 = seq__43245__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__43247 = cljs.core.set(all_vars__$2);
return (fexpr__43247.cljs$core$IFn$_invoke$arity$1 ? fexpr__43247.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__43247.call(null,var$__$1));
})())){
var G__43248 = r__$1;
var G__43249 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__43236__$1 = G__43248;
all_vars__$1 = G__43249;
continue;
} else {
var G__43250 = r__$1;
var G__43251 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__43236__$1 = G__43250;
all_vars__$1 = G__43251;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_43286){
var state_val_43287 = (state_43286[(1)]);
if((state_val_43287 === (1))){
var inst_43259 = functionArray;
var inst_43260 = cljs.core.seq(inst_43259);
var inst_43261 = cljs.core.first(inst_43260);
var inst_43262 = cljs.core.next(inst_43260);
var inst_43263 = cljs.core.PersistentVector.EMPTY;
var inst_43264 = inst_43259;
var inst_43265 = inst_43263;
var state_43286__$1 = (function (){var statearr_43288 = state_43286;
(statearr_43288[(7)] = inst_43265);

(statearr_43288[(8)] = inst_43261);

(statearr_43288[(9)] = inst_43262);

(statearr_43288[(10)] = inst_43264);

return statearr_43288;
})();
var statearr_43289_43302 = state_43286__$1;
(statearr_43289_43302[(2)] = null);

(statearr_43289_43302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43287 === (2))){
var inst_43271 = (state_43286[(11)]);
var inst_43264 = (state_43286[(10)]);
var inst_43270 = cljs.core.seq(inst_43264);
var inst_43271__$1 = cljs.core.first(inst_43270);
var inst_43272 = cljs.core.next(inst_43270);
var state_43286__$1 = (function (){var statearr_43290 = state_43286;
(statearr_43290[(12)] = inst_43272);

(statearr_43290[(11)] = inst_43271__$1);

return statearr_43290;
})();
if(cljs.core.truth_(inst_43271__$1)){
var statearr_43291_43303 = state_43286__$1;
(statearr_43291_43303[(1)] = (4));

} else {
var statearr_43292_43304 = state_43286__$1;
(statearr_43292_43304[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43287 === (3))){
var inst_43284 = (state_43286[(2)]);
var state_43286__$1 = state_43286;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43286__$1,inst_43284);
} else {
if((state_val_43287 === (4))){
var inst_43271 = (state_43286[(11)]);
var inst_43274 = (inst_43271.cljs$core$IFn$_invoke$arity$1 ? inst_43271.cljs$core$IFn$_invoke$arity$1(tuple) : inst_43271.call(null,tuple));
var state_43286__$1 = state_43286;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43286__$1,(7),inst_43274);
} else {
if((state_val_43287 === (5))){
var inst_43265 = (state_43286[(7)]);
var state_43286__$1 = state_43286;
var statearr_43293_43305 = state_43286__$1;
(statearr_43293_43305[(2)] = inst_43265);

(statearr_43293_43305[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43287 === (6))){
var inst_43282 = (state_43286[(2)]);
var state_43286__$1 = state_43286;
var statearr_43294_43306 = state_43286__$1;
(statearr_43294_43306[(2)] = inst_43282);

(statearr_43294_43306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43287 === (7))){
var inst_43272 = (state_43286[(12)]);
var inst_43265 = (state_43286[(7)]);
var inst_43276 = (state_43286[(2)]);
var inst_43277 = fluree.db.util.async.throw_err(inst_43276);
var inst_43278 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_43265,inst_43277);
var inst_43264 = inst_43272;
var inst_43265__$1 = inst_43278;
var state_43286__$1 = (function (){var statearr_43295 = state_43286;
(statearr_43295[(7)] = inst_43265__$1);

(statearr_43295[(10)] = inst_43264);

return statearr_43295;
})();
var statearr_43296_43307 = state_43286__$1;
(statearr_43296_43307[(2)] = null);

(statearr_43296_43307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__17178__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__17178__auto____0 = (function (){
var statearr_43297 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43297[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__17178__auto__);

(statearr_43297[(1)] = (1));

return statearr_43297;
});
var fluree$db$query$fql$format_tuple_$_state_machine__17178__auto____1 = (function (state_43286){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_43286);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e43298){var ex__17181__auto__ = e43298;
var statearr_43299_43308 = state_43286;
(statearr_43299_43308[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_43286[(4)]))){
var statearr_43300_43309 = state_43286;
(statearr_43300_43309[(1)] = cljs.core.first((state_43286[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43310 = state_43286;
state_43286 = G__43310;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__17178__auto__ = function(state_43286){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__17178__auto____1.call(this,state_43286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__17178__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__17178__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_43301 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_43301[(6)] = c__17304__auto__);

return statearr_43301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__43311){
var vec__43312 = p__43311;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43312,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43312,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_43326){
var state_val_43327 = (state_43326[(1)]);
if((state_val_43327 === (1))){
var inst_43315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43316 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_43317 = [query_map,_id,query_opts];
var inst_43318 = cljs.core.PersistentHashMap.fromArrays(inst_43316,inst_43317);
var inst_43319 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_43318) : fluree.db.query.fql.query.call(null,db,inst_43318));
var state_43326__$1 = (function (){var statearr_43328 = state_43326;
(statearr_43328[(7)] = inst_43315);

return statearr_43328;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43326__$1,(2),inst_43319);
} else {
if((state_val_43327 === (2))){
var inst_43315 = (state_43326[(7)]);
var inst_43321 = (state_43326[(2)]);
var inst_43322 = fluree.db.util.async.throw_err(inst_43321);
var inst_43323 = [tuple_index,inst_43322];
var inst_43324 = (new cljs.core.PersistentVector(null,2,(5),inst_43315,inst_43323,null));
var state_43326__$1 = state_43326;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43326__$1,inst_43324);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__17178__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__17178__auto____0 = (function (){
var statearr_43329 = [null,null,null,null,null,null,null,null];
(statearr_43329[(0)] = fluree$db$query$fql$expand_map_$_state_machine__17178__auto__);

(statearr_43329[(1)] = (1));

return statearr_43329;
});
var fluree$db$query$fql$expand_map_$_state_machine__17178__auto____1 = (function (state_43326){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_43326);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e43330){var ex__17181__auto__ = e43330;
var statearr_43331_43334 = state_43326;
(statearr_43331_43334[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_43326[(4)]))){
var statearr_43332_43335 = state_43326;
(statearr_43332_43335[(1)] = cljs.core.first((state_43326[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43336 = state_43326;
state_43326 = G__43336;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__17178__auto__ = function(state_43326){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__17178__auto____1.call(this,state_43326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__17178__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__17178__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_43333 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_43333[(6)] = c__17304__auto__);

return statearr_43333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__43337 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43337,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43337,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_43400){
var state_val_43401 = (state_43400[(1)]);
if((state_val_43401 === (7))){
var inst_43395 = (state_43400[(2)]);
var _ = (function (){var statearr_43402 = state_43400;
(statearr_43402[(4)] = cljs.core.rest((state_43400[(4)])));

return statearr_43402;
})();
var state_43400__$1 = state_43400;
var statearr_43403_43494 = state_43400__$1;
(statearr_43403_43494[(2)] = inst_43395);

(statearr_43403_43494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (20))){
var inst_43386 = (state_43400[(2)]);
var state_43400__$1 = state_43400;
var statearr_43404_43495 = state_43400__$1;
(statearr_43404_43495[(2)] = inst_43386);

(statearr_43404_43495[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (1))){
var state_43400__$1 = state_43400;
var statearr_43405_43496 = state_43400__$1;
(statearr_43405_43496[(2)] = null);

(statearr_43405_43496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (4))){
var inst_43342 = (state_43400[(2)]);
var state_43400__$1 = state_43400;
var statearr_43406_43497 = state_43400__$1;
(statearr_43406_43497[(2)] = inst_43342);

(statearr_43406_43497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (15))){
var inst_43362 = (state_43400[(7)]);
var inst_43371 = cljs.core.second(inst_43362);
var inst_43372 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_43371);
var inst_43373 = (inst_43372 > max_fuel);
var state_43400__$1 = state_43400;
if(cljs.core.truth_(inst_43373)){
var statearr_43407_43498 = state_43400__$1;
(statearr_43407_43498[(1)] = (18));

} else {
var statearr_43408_43499 = state_43400__$1;
(statearr_43408_43499[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (13))){
var state_43400__$1 = state_43400;
var statearr_43409_43500 = state_43400__$1;
(statearr_43409_43500[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (6))){
var inst_43350 = (state_43400[(8)]);
var state_43400__$1 = state_43400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43400__$1,(8),inst_43350);
} else {
if((state_val_43401 === (17))){
var inst_43389 = (state_43400[(2)]);
var state_43400__$1 = state_43400;
var statearr_43411_43501 = state_43400__$1;
(statearr_43411_43501[(2)] = inst_43389);

(statearr_43411_43501[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (3))){
var inst_43398 = (state_43400[(2)]);
var state_43400__$1 = state_43400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43400__$1,inst_43398);
} else {
if((state_val_43401 === (12))){
var inst_43362 = (state_43400[(7)]);
var inst_43351 = (state_43400[(9)]);
var inst_43368 = (inst_43351.cljs$core$IFn$_invoke$arity$0 ? inst_43351.cljs$core$IFn$_invoke$arity$0() : inst_43351.call(null));
var state_43400__$1 = (function (){var statearr_43412 = state_43400;
(statearr_43412[(10)] = inst_43368);

return statearr_43412;
})();
var statearr_43413_43502 = state_43400__$1;
(statearr_43413_43502[(2)] = inst_43362);

(statearr_43413_43502[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (2))){
var inst_43350 = (state_43400[(8)]);
var inst_43351 = (state_43400[(9)]);
var _ = (function (){var statearr_43414 = state_43400;
(statearr_43414[(4)] = cljs.core.cons((5),(state_43400[(4)])));

return statearr_43414;
})();
var inst_43348 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_43349 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_43350__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_43351__$1 = (function (){var expandMaps = inst_43348;
var queue_ch = inst_43349;
var res_ch = inst_43350__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_43352 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_43353 = cljs.core.volatile_BANG_((0));
var inst_43354 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43352,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_43353);
var inst_43355 = (function (){var expandMaps = inst_43348;
var queue_ch = inst_43349;
var res_ch = inst_43350__$1;
var stop_BANG_ = inst_43351__$1;
var opts_STAR_ = inst_43354;
return (function (tuple_res,port){
var c__17304__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_43447){
var state_val_43448 = (state_43447[(1)]);
if((state_val_43448 === (7))){
var state_43447__$1 = state_43447;
var statearr_43449_43503 = state_43447__$1;
(statearr_43449_43503[(2)] = tuple_res);

(statearr_43449_43503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43448 === (1))){
var state_43447__$1 = state_43447;
var statearr_43450_43504 = state_43447__$1;
(statearr_43450_43504[(2)] = null);

(statearr_43450_43504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43448 === (4))){
var inst_43415 = (state_43447[(2)]);
var inst_43416 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_43415);
var inst_43417 = cljs.core.async.close_BANG_(port);
var state_43447__$1 = (function (){var statearr_43451 = state_43447;
(statearr_43451[(7)] = inst_43416);

return statearr_43451;
})();
var statearr_43452_43505 = state_43447__$1;
(statearr_43452_43505[(2)] = inst_43417);

(statearr_43452_43505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43448 === (6))){
var inst_43424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43425 = [tuple_res];
var inst_43426 = (new cljs.core.PersistentVector(null,1,(5),inst_43424,inst_43425,null));
var state_43447__$1 = state_43447;
var statearr_43453_43506 = state_43447__$1;
(statearr_43453_43506[(2)] = inst_43426);

(statearr_43453_43506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43448 === (3))){
var inst_43445 = (state_43447[(2)]);
var state_43447__$1 = state_43447;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43447__$1,inst_43445);
} else {
if((state_val_43448 === (2))){
var ___$1 = (function (){var statearr_43455 = state_43447;
(statearr_43455[(4)] = cljs.core.cons((5),(state_43447[(4)])));

return statearr_43455;
})();
var state_43447__$1 = state_43447;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_43456_43507 = state_43447__$1;
(statearr_43456_43507[(1)] = (6));

} else {
var statearr_43457_43508 = state_43447__$1;
(statearr_43457_43508[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43448 === (9))){
var inst_43431 = (state_43447[(8)]);
var inst_43429 = (state_43447[(9)]);
var inst_43438 = (state_43447[(2)]);
var inst_43439 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_43429,inst_43438);
var inst_43440 = (inst_43431.cljs$core$IFn$_invoke$arity$1 ? inst_43431.cljs$core$IFn$_invoke$arity$1(inst_43439) : inst_43431.call(null,inst_43439));
var inst_43441 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_43440);
var inst_43442 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_43458 = state_43447;
(statearr_43458[(4)] = cljs.core.rest((state_43447[(4)])));

return statearr_43458;
})();
var state_43447__$1 = (function (){var statearr_43459 = state_43447;
(statearr_43459[(10)] = inst_43441);

return statearr_43459;
})();
var statearr_43460_43509 = state_43447__$1;
(statearr_43460_43509[(2)] = inst_43442);

(statearr_43460_43509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43448 === (5))){
var ___$1 = (function (){var statearr_43461 = state_43447;
(statearr_43461[(4)] = cljs.core.rest((state_43447[(4)])));

return statearr_43461;
})();
var state_43447__$1 = state_43447;
var ex43454 = (state_43447__$1[(2)]);
var statearr_43462_43510 = state_43447__$1;
(statearr_43462_43510[(5)] = ex43454);


var statearr_43463_43511 = state_43447__$1;
(statearr_43463_43511[(1)] = (4));

(statearr_43463_43511[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43448 === (8))){
var inst_43429 = (state_43447[(9)]);
var inst_43429__$1 = (state_43447[(2)]);
var inst_43430 = cljs.core.volatile_BANG_((0));
var inst_43431 = (function (){var tuple_res_SINGLEQUOTE_ = inst_43429__$1;
var query_fuel = inst_43430;
return (function (p1__43341_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__43341_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43341_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_43432 = cljs.core.PersistentVector.EMPTY;
var inst_43433 = (function (){var tuple_res_SINGLEQUOTE_ = inst_43429__$1;
var query_fuel = inst_43430;
return (function (p1__43340_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__43340_SHARP_);
});
})();
var inst_43434 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_43433,expandMaps);
var inst_43435 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_43434);
var inst_43436 = cljs.core.async.into(inst_43432,inst_43435);
var state_43447__$1 = (function (){var statearr_43464 = state_43447;
(statearr_43464[(8)] = inst_43431);

(statearr_43464[(9)] = inst_43429__$1);

return statearr_43464;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43447__$1,(9),inst_43436);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto____0 = (function (){
var statearr_43465 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43465[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto__);

(statearr_43465[(1)] = (1));

return statearr_43465;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto____1 = (function (state_43447){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_43447);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e43466){var ex__17181__auto__ = e43466;
var statearr_43467_43512 = state_43447;
(statearr_43467_43512[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_43447[(4)]))){
var statearr_43468_43513 = state_43447;
(statearr_43468_43513[(1)] = cljs.core.first((state_43447[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43514 = state_43447;
state_43447 = G__43514;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto__ = function(state_43447){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto____1.call(this,state_43447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_43469 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_43469[(6)] = c__17304__auto____$1);

return statearr_43469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto____$1;
});
})();
var inst_43356 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_43349,tuples_res);
var inst_43357 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_43350__$1,inst_43355,inst_43349);
var inst_43358 = cljs.core.PersistentVector.EMPTY;
var inst_43359 = inst_43358;
var state_43400__$1 = (function (){var statearr_43470 = state_43400;
(statearr_43470[(11)] = inst_43357);

(statearr_43470[(8)] = inst_43350__$1);

(statearr_43470[(12)] = inst_43356);

(statearr_43470[(13)] = inst_43359);

(statearr_43470[(9)] = inst_43351__$1);

return statearr_43470;
})();
var statearr_43471_43515 = state_43400__$1;
(statearr_43471_43515[(2)] = null);

(statearr_43471_43515[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (19))){
var inst_43362 = (state_43400[(7)]);
var inst_43359 = (state_43400[(13)]);
var inst_43382 = cljs.core.first(inst_43362);
var inst_43383 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_43359,inst_43382);
var inst_43359__$1 = inst_43383;
var state_43400__$1 = (function (){var statearr_43472 = state_43400;
(statearr_43472[(13)] = inst_43359__$1);

return statearr_43472;
})();
var statearr_43473_43516 = state_43400__$1;
(statearr_43473_43516[(2)] = null);

(statearr_43473_43516[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (11))){
var inst_43393 = (state_43400[(2)]);
var state_43400__$1 = state_43400;
var statearr_43475_43517 = state_43400__$1;
(statearr_43475_43517[(2)] = inst_43393);

(statearr_43475_43517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (9))){
var inst_43359 = (state_43400[(13)]);
var state_43400__$1 = state_43400;
var statearr_43476_43518 = state_43400__$1;
(statearr_43476_43518[(2)] = inst_43359);

(statearr_43476_43518[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (5))){
var _ = (function (){var statearr_43477 = state_43400;
(statearr_43477[(4)] = cljs.core.rest((state_43400[(4)])));

return statearr_43477;
})();
var state_43400__$1 = state_43400;
var ex43474 = (state_43400__$1[(2)]);
var statearr_43478_43519 = state_43400__$1;
(statearr_43478_43519[(5)] = ex43474);


if((ex43474 instanceof Error)){
var statearr_43479_43520 = state_43400__$1;
(statearr_43479_43520[(1)] = (4));

(statearr_43479_43520[(5)] = null);

} else {
throw ex43474;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (14))){
var inst_43391 = (state_43400[(2)]);
var state_43400__$1 = state_43400;
var statearr_43480_43521 = state_43400__$1;
(statearr_43480_43521[(2)] = inst_43391);

(statearr_43480_43521[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (16))){
var state_43400__$1 = state_43400;
var statearr_43481_43522 = state_43400__$1;
(statearr_43481_43522[(2)] = null);

(statearr_43481_43522[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (10))){
var inst_43362 = (state_43400[(7)]);
var inst_43366 = fluree.db.util.core.exception_QMARK_(inst_43362);
var state_43400__$1 = state_43400;
if(inst_43366){
var statearr_43482_43523 = state_43400__$1;
(statearr_43482_43523[(1)] = (12));

} else {
var statearr_43483_43524 = state_43400__$1;
(statearr_43483_43524[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (18))){
var inst_43351 = (state_43400[(9)]);
var inst_43375 = (inst_43351.cljs$core$IFn$_invoke$arity$0 ? inst_43351.cljs$core$IFn$_invoke$arity$0() : inst_43351.call(null));
var inst_43376 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_43377 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_43378 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_43379 = cljs.core.PersistentHashMap.fromArrays(inst_43377,inst_43378);
var inst_43380 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43376,inst_43379);
var state_43400__$1 = (function (){var statearr_43484 = state_43400;
(statearr_43484[(14)] = inst_43375);

return statearr_43484;
})();
var statearr_43485_43525 = state_43400__$1;
(statearr_43485_43525[(2)] = inst_43380);

(statearr_43485_43525[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43401 === (8))){
var inst_43362 = (state_43400[(7)]);
var inst_43362__$1 = (state_43400[(2)]);
var inst_43363 = (inst_43362__$1 == null);
var state_43400__$1 = (function (){var statearr_43486 = state_43400;
(statearr_43486[(7)] = inst_43362__$1);

return statearr_43486;
})();
if(cljs.core.truth_(inst_43363)){
var statearr_43487_43526 = state_43400__$1;
(statearr_43487_43526[(1)] = (9));

} else {
var statearr_43488_43527 = state_43400__$1;
(statearr_43488_43527[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto____0 = (function (){
var statearr_43489 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43489[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto__);

(statearr_43489[(1)] = (1));

return statearr_43489;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto____1 = (function (state_43400){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_43400);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e43490){var ex__17181__auto__ = e43490;
var statearr_43491_43528 = state_43400;
(statearr_43491_43528[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_43400[(4)]))){
var statearr_43492_43529 = state_43400;
(statearr_43492_43529[(1)] = cljs.core.first((state_43400[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43530 = state_43400;
state_43400 = G__43530;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto__ = function(state_43400){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto____1.call(this,state_43400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_43493 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_43493[(6)] = c__17304__auto__);

return statearr_43493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__43531 = select;
var map__43531__$1 = cljs.core.__destructure_map(map__43531);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43531__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43531__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43531__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4212__auto__ = as;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__43534 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43534,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43534,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43534,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__43532_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__43532_SHARP_,compare_idx));
}):(function (p1__43533_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__43533_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__43539 = arguments.length;
switch (G__43539) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__43540,p__43541,group_limit,opts){
var map__43542 = p__43540;
var map__43542__$1 = cljs.core.__destructure_map(map__43542);
var res = map__43542__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43542__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__43543 = p__43541;
var map__43543__$1 = cljs.core.__destructure_map(map__43543);
var select_spec = map__43543__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43543__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43543__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43543__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43543__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43543__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43543__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43543__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43543__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43543__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43543__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_43680){
var state_val_43681 = (state_43680[(1)]);
if((state_val_43681 === (7))){
var inst_43550 = (state_43680[(7)]);
var state_43680__$1 = state_43680;
var statearr_43682_43784 = state_43680__$1;
(statearr_43682_43784[(2)] = inst_43550);

(statearr_43682_43784[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (59))){
var inst_43673 = (state_43680[(2)]);
var state_43680__$1 = state_43680;
var statearr_43683_43785 = state_43680__$1;
(statearr_43683_43785[(2)] = inst_43673);

(statearr_43683_43785[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (20))){
var inst_43586 = (state_43680[(8)]);
var inst_43589 = (state_43680[(9)]);
var inst_43585 = (state_43680[(2)]);
var inst_43586__$1 = cljs.core.__destructure_map(inst_43585);
var inst_43587 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43586__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_43588 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43586__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_43589__$1 = offset;
var state_43680__$1 = (function (){var statearr_43684 = state_43680;
(statearr_43684[(10)] = inst_43588);

(statearr_43684[(8)] = inst_43586__$1);

(statearr_43684[(9)] = inst_43589__$1);

(statearr_43684[(11)] = inst_43587);

return statearr_43684;
})();
if(cljs.core.truth_(inst_43589__$1)){
var statearr_43685_43786 = state_43680__$1;
(statearr_43685_43786[(1)] = (21));

} else {
var statearr_43686_43787 = state_43680__$1;
(statearr_43686_43787[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (58))){
var inst_43665 = (state_43680[(12)]);
var state_43680__$1 = state_43680;
var statearr_43687_43788 = state_43680__$1;
(statearr_43687_43788[(2)] = inst_43665);

(statearr_43687_43788[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (60))){
var inst_43669 = (state_43680[(2)]);
var inst_43670 = fluree.db.util.async.throw_err(inst_43669);
var state_43680__$1 = state_43680;
var statearr_43688_43789 = state_43680__$1;
(statearr_43688_43789[(2)] = inst_43670);

(statearr_43688_43789[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (27))){
var inst_43601 = cljs.core.not(inVector_QMARK_);
var state_43680__$1 = state_43680;
var statearr_43689_43790 = state_43680__$1;
(statearr_43689_43790[(2)] = inst_43601);

(statearr_43689_43790[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (1))){
var state_43680__$1 = state_43680;
var statearr_43690_43791 = state_43680__$1;
(statearr_43690_43791[(2)] = null);

(statearr_43690_43791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (24))){
var state_43680__$1 = state_43680;
var statearr_43691_43792 = state_43680__$1;
(statearr_43691_43792[(2)] = offset);

(statearr_43691_43792[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (55))){
var inst_43659 = (state_43680[(13)]);
var state_43680__$1 = state_43680;
var statearr_43692_43793 = state_43680__$1;
(statearr_43692_43793[(2)] = inst_43659);

(statearr_43692_43793[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (39))){
var inst_43627 = (state_43680[(14)]);
var inst_43629 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_43630 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_43627,inst_43629);
var state_43680__$1 = state_43680;
var statearr_43693_43794 = state_43680__$1;
(statearr_43693_43794[(2)] = inst_43630);

(statearr_43693_43794[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (46))){
var inst_43639 = (state_43680[(15)]);
var state_43680__$1 = state_43680;
var statearr_43694_43795 = state_43680__$1;
(statearr_43694_43795[(2)] = inst_43639);

(statearr_43694_43795[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (4))){
var inst_43544 = (state_43680[(2)]);
var state_43680__$1 = state_43680;
var statearr_43695_43796 = state_43680__$1;
(statearr_43695_43796[(2)] = inst_43544);

(statearr_43695_43796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (54))){
var inst_43659 = (state_43680[(13)]);
var inst_43653 = (state_43680[(16)]);
var inst_43661 = cljs.core.PersistentVector.EMPTY;
var inst_43662 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_43661,inst_43653,inst_43659);
var state_43680__$1 = state_43680;
var statearr_43696_43797 = state_43680__$1;
(statearr_43696_43797[(2)] = inst_43662);

(statearr_43696_43797[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (15))){
var inst_43571 = (state_43680[(17)]);
var inst_43573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43574 = [inst_43571];
var inst_43575 = (new cljs.core.PersistentVector(null,1,(5),inst_43573,inst_43574,null));
var state_43680__$1 = state_43680;
var statearr_43697_43798 = state_43680__$1;
(statearr_43697_43798[(2)] = inst_43575);

(statearr_43697_43798[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (48))){
var inst_43604 = (state_43680[(18)]);
var inst_43588 = (state_43680[(10)]);
var inst_43645 = (state_43680[(19)]);
var inst_43586 = (state_43680[(8)]);
var inst_43587 = (state_43680[(11)]);
var inst_43609 = (state_43680[(20)]);
var inst_43598 = (state_43680[(21)]);
var inst_43647 = (function (){var map__43580 = inst_43586;
var headers = inst_43587;
var tuples = inst_43588;
var offset_SINGLEQUOTE_ = inst_43598;
var single_result_QMARK_ = inst_43604;
var pp_keys = inst_43609;
var G__43610 = inst_43645;
return (function (p1__43537_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__43537_SHARP_);
});
})();
var inst_43648 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_43647);
var inst_43649 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_43645,inst_43648);
var state_43680__$1 = state_43680;
var statearr_43698_43799 = state_43680__$1;
(statearr_43698_43799[(2)] = inst_43649);

(statearr_43698_43799[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (50))){
var inst_43652 = (state_43680[(2)]);
var inst_43653 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_43652);
var state_43680__$1 = (function (){var statearr_43699 = state_43680;
(statearr_43699[(16)] = inst_43653);

return statearr_43699;
})();
if(cljs.core.truth_(orderBy)){
var statearr_43700_43800 = state_43680__$1;
(statearr_43700_43800[(1)] = (51));

} else {
var statearr_43701_43801 = state_43680__$1;
(statearr_43701_43801[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (21))){
var inst_43591 = cljs.core.not(groupBy);
var state_43680__$1 = state_43680;
var statearr_43702_43802 = state_43680__$1;
(statearr_43702_43802[(2)] = inst_43591);

(statearr_43702_43802[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (31))){
var state_43680__$1 = state_43680;
var statearr_43703_43803 = state_43680__$1;
(statearr_43703_43803[(2)] = null);

(statearr_43703_43803[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (32))){
var inst_43604 = (state_43680[(18)]);
var inst_43587 = (state_43680[(11)]);
var inst_43609 = (state_43680[(2)]);
var inst_43611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43612 = fluree.db.query.fql.select_tuples_fn(inst_43587,vars,select);
var inst_43613 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_43612);
var inst_43614 = [inst_43613];
var inst_43615 = (new cljs.core.PersistentVector(null,1,(5),inst_43611,inst_43614,null));
var state_43680__$1 = (function (){var statearr_43704 = state_43680;
(statearr_43704[(22)] = inst_43615);

(statearr_43704[(20)] = inst_43609);

return statearr_43704;
})();
if(cljs.core.truth_(inst_43604)){
var statearr_43705_43804 = state_43680__$1;
(statearr_43705_43804[(1)] = (33));

} else {
var statearr_43706_43805 = state_43680__$1;
(statearr_43706_43805[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (40))){
var inst_43627 = (state_43680[(14)]);
var state_43680__$1 = state_43680;
var statearr_43707_43806 = state_43680__$1;
(statearr_43707_43806[(2)] = inst_43627);

(statearr_43707_43806[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (56))){
var inst_43665 = (state_43680[(2)]);
var state_43680__$1 = (function (){var statearr_43708 = state_43680;
(statearr_43708[(12)] = inst_43665);

return statearr_43708;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_43709_43807 = state_43680__$1;
(statearr_43709_43807[(1)] = (57));

} else {
var statearr_43710_43808 = state_43680__$1;
(statearr_43710_43808[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (33))){
var inst_43615 = (state_43680[(22)]);
var inst_43617 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_43618 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_43615,inst_43617);
var state_43680__$1 = state_43680;
var statearr_43711_43809 = state_43680__$1;
(statearr_43711_43809[(2)] = inst_43618);

(statearr_43711_43809[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (13))){
var inst_43560 = (state_43680[(23)]);
var state_43680__$1 = state_43680;
var statearr_43712_43810 = state_43680__$1;
(statearr_43712_43810[(2)] = inst_43560);

(statearr_43712_43810[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (22))){
var inst_43589 = (state_43680[(9)]);
var state_43680__$1 = state_43680;
var statearr_43713_43811 = state_43680__$1;
(statearr_43713_43811[(2)] = inst_43589);

(statearr_43713_43811[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (36))){
var inst_43621 = (state_43680[(24)]);
var inst_43623 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_43624 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_43621,inst_43623);
var state_43680__$1 = state_43680;
var statearr_43714_43812 = state_43680__$1;
(statearr_43714_43812[(2)] = inst_43624);

(statearr_43714_43812[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (41))){
var inst_43598 = (state_43680[(21)]);
var inst_43633 = (state_43680[(2)]);
var state_43680__$1 = (function (){var statearr_43715 = state_43680;
(statearr_43715[(25)] = inst_43633);

return statearr_43715;
})();
if(cljs.core.truth_(inst_43598)){
var statearr_43716_43813 = state_43680__$1;
(statearr_43716_43813[(1)] = (42));

} else {
var statearr_43717_43814 = state_43680__$1;
(statearr_43717_43814[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (43))){
var inst_43633 = (state_43680[(25)]);
var state_43680__$1 = state_43680;
var statearr_43718_43815 = state_43680__$1;
(statearr_43718_43815[(2)] = inst_43633);

(statearr_43718_43815[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (29))){
var inst_43604 = (state_43680[(2)]);
var state_43680__$1 = (function (){var statearr_43719 = state_43680;
(statearr_43719[(18)] = inst_43604);

return statearr_43719;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_43720_43816 = state_43680__$1;
(statearr_43720_43816[(1)] = (30));

} else {
var statearr_43721_43817 = state_43680__$1;
(statearr_43721_43817[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (44))){
var inst_43639 = (state_43680[(2)]);
var state_43680__$1 = (function (){var statearr_43722 = state_43680;
(statearr_43722[(15)] = inst_43639);

return statearr_43722;
})();
if(cljs.core.truth_(group_limit)){
var statearr_43723_43818 = state_43680__$1;
(statearr_43723_43818[(1)] = (45));

} else {
var statearr_43724_43819 = state_43680__$1;
(statearr_43724_43819[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (6))){
var inst_43552 = cljs.core.count(select);
var inst_43553 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_43552);
var state_43680__$1 = state_43680;
var statearr_43725_43820 = state_43680__$1;
(statearr_43725_43820[(2)] = inst_43553);

(statearr_43725_43820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (28))){
var inst_43599 = (state_43680[(26)]);
var state_43680__$1 = state_43680;
var statearr_43726_43821 = state_43680__$1;
(statearr_43726_43821[(2)] = inst_43599);

(statearr_43726_43821[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (51))){
var inst_43588 = (state_43680[(10)]);
var inst_43587 = (state_43680[(11)]);
var inst_43656 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_43587,orderBy,inst_43588);
var state_43680__$1 = state_43680;
var statearr_43727_43822 = state_43680__$1;
(statearr_43727_43822[(2)] = inst_43656);

(statearr_43727_43822[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (25))){
var state_43680__$1 = state_43680;
var statearr_43728_43823 = state_43680__$1;
(statearr_43728_43823[(2)] = null);

(statearr_43728_43823[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (34))){
var inst_43615 = (state_43680[(22)]);
var state_43680__$1 = state_43680;
var statearr_43729_43824 = state_43680__$1;
(statearr_43729_43824[(2)] = inst_43615);

(statearr_43729_43824[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (17))){
var inst_43578 = (state_43680[(2)]);
var state_43680__$1 = state_43680;
var statearr_43730_43825 = state_43680__$1;
(statearr_43730_43825[(2)] = inst_43578);

(statearr_43730_43825[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (3))){
var inst_43678 = (state_43680[(2)]);
var state_43680__$1 = state_43680;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43680__$1,inst_43678);
} else {
if((state_val_43681 === (12))){
var inst_43560 = (state_43680[(23)]);
var inst_43562 = cljs.core.first(select);
var inst_43563 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_43562);
var inst_43564 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43563);
var inst_43565 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_43564,(1));
var inst_43566 = [inst_43565];
var inst_43567 = [inst_43560];
var inst_43568 = cljs.core.PersistentHashMap.fromArrays(inst_43566,inst_43567);
var state_43680__$1 = state_43680;
var statearr_43731_43826 = state_43680__$1;
(statearr_43731_43826[(2)] = inst_43568);

(statearr_43731_43826[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (2))){
var inst_43550 = (state_43680[(7)]);
var _ = (function (){var statearr_43732 = state_43680;
(statearr_43732[(4)] = cljs.core.cons((5),(state_43680[(4)])));

return statearr_43732;
})();
var inst_43550__$1 = aggregates;
var state_43680__$1 = (function (){var statearr_43733 = state_43680;
(statearr_43733[(7)] = inst_43550__$1);

return statearr_43733;
})();
if(cljs.core.truth_(inst_43550__$1)){
var statearr_43734_43827 = state_43680__$1;
(statearr_43734_43827[(1)] = (6));

} else {
var statearr_43735_43828 = state_43680__$1;
(statearr_43735_43828[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (23))){
var inst_43594 = (state_43680[(2)]);
var state_43680__$1 = state_43680;
if(cljs.core.truth_(inst_43594)){
var statearr_43736_43829 = state_43680__$1;
(statearr_43736_43829[(1)] = (24));

} else {
var statearr_43737_43830 = state_43680__$1;
(statearr_43737_43830[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (47))){
var inst_43645 = (state_43680[(2)]);
var state_43680__$1 = (function (){var statearr_43738 = state_43680;
(statearr_43738[(19)] = inst_43645);

return statearr_43738;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_43739_43831 = state_43680__$1;
(statearr_43739_43831[(1)] = (48));

} else {
var statearr_43740_43832 = state_43680__$1;
(statearr_43740_43832[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (35))){
var inst_43621 = (state_43680[(2)]);
var state_43680__$1 = (function (){var statearr_43741 = state_43680;
(statearr_43741[(24)] = inst_43621);

return statearr_43741;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_43742_43833 = state_43680__$1;
(statearr_43742_43833[(1)] = (36));

} else {
var statearr_43743_43834 = state_43680__$1;
(statearr_43743_43834[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (19))){
var state_43680__$1 = state_43680;
var statearr_43744_43835 = state_43680__$1;
(statearr_43744_43835[(2)] = res);

(statearr_43744_43835[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (57))){
var inst_43604 = (state_43680[(18)]);
var inst_43665 = (state_43680[(12)]);
var inst_43609 = (state_43680[(20)]);
var inst_43667 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_43609,inst_43604,db,fuel,max_fuel,opts,(8),inst_43665);
var state_43680__$1 = state_43680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43680__$1,(60),inst_43667);
} else {
if((state_val_43681 === (11))){
var inst_43675 = (state_43680[(2)]);
var _ = (function (){var statearr_43746 = state_43680;
(statearr_43746[(4)] = cljs.core.rest((state_43680[(4)])));

return statearr_43746;
})();
var state_43680__$1 = state_43680;
var statearr_43747_43836 = state_43680__$1;
(statearr_43747_43836[(2)] = inst_43675);

(statearr_43747_43836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (9))){
var inst_43558 = cljs.core.first(aggregates);
var inst_43559 = fluree.db.query.analytical.calculate_aggregate(res,inst_43558);
var inst_43560 = cljs.core.second(inst_43559);
var state_43680__$1 = (function (){var statearr_43748 = state_43680;
(statearr_43748[(23)] = inst_43560);

return statearr_43748;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_43749_43837 = state_43680__$1;
(statearr_43749_43837[(1)] = (12));

} else {
var statearr_43750_43838 = state_43680__$1;
(statearr_43750_43838[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (5))){
var _ = (function (){var statearr_43751 = state_43680;
(statearr_43751[(4)] = cljs.core.rest((state_43680[(4)])));

return statearr_43751;
})();
var state_43680__$1 = state_43680;
var ex43745 = (state_43680__$1[(2)]);
var statearr_43752_43839 = state_43680__$1;
(statearr_43752_43839[(5)] = ex43745);


if((ex43745 instanceof Error)){
var statearr_43753_43840 = state_43680__$1;
(statearr_43753_43840[(1)] = (4));

(statearr_43753_43840[(5)] = null);

} else {
throw ex43745;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (14))){
var inst_43571 = (state_43680[(2)]);
var state_43680__$1 = (function (){var statearr_43754 = state_43680;
(statearr_43754[(17)] = inst_43571);

return statearr_43754;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_43755_43841 = state_43680__$1;
(statearr_43755_43841[(1)] = (15));

} else {
var statearr_43756_43842 = state_43680__$1;
(statearr_43756_43842[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (45))){
var inst_43639 = (state_43680[(15)]);
var inst_43641 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_43642 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_43639,inst_43641);
var state_43680__$1 = state_43680;
var statearr_43757_43843 = state_43680__$1;
(statearr_43757_43843[(2)] = inst_43642);

(statearr_43757_43843[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (53))){
var inst_43659 = (state_43680[(2)]);
var state_43680__$1 = (function (){var statearr_43758 = state_43680;
(statearr_43758[(13)] = inst_43659);

return statearr_43758;
})();
var statearr_43759_43844 = state_43680__$1;
(statearr_43759_43844[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (26))){
var inst_43599 = (state_43680[(26)]);
var inst_43598 = (state_43680[(2)]);
var inst_43599__$1 = cljs.core.not(prettyPrint);
var state_43680__$1 = (function (){var statearr_43761 = state_43680;
(statearr_43761[(26)] = inst_43599__$1);

(statearr_43761[(21)] = inst_43598);

return statearr_43761;
})();
if(inst_43599__$1){
var statearr_43762_43845 = state_43680__$1;
(statearr_43762_43845[(1)] = (27));

} else {
var statearr_43763_43846 = state_43680__$1;
(statearr_43763_43846[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (16))){
var inst_43571 = (state_43680[(17)]);
var state_43680__$1 = state_43680;
var statearr_43764_43847 = state_43680__$1;
(statearr_43764_43847[(2)] = inst_43571);

(statearr_43764_43847[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (38))){
var inst_43627 = (state_43680[(2)]);
var state_43680__$1 = (function (){var statearr_43765 = state_43680;
(statearr_43765[(14)] = inst_43627);

return statearr_43765;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_43766_43848 = state_43680__$1;
(statearr_43766_43848[(1)] = (39));

} else {
var statearr_43767_43849 = state_43680__$1;
(statearr_43767_43849[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (30))){
var inst_43606 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_43680__$1 = state_43680;
var statearr_43768_43850 = state_43680__$1;
(statearr_43768_43850[(2)] = inst_43606);

(statearr_43768_43850[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (10))){
var state_43680__$1 = state_43680;
if(cljs.core.truth_(aggregates)){
var statearr_43769_43851 = state_43680__$1;
(statearr_43769_43851[(1)] = (18));

} else {
var statearr_43770_43852 = state_43680__$1;
(statearr_43770_43852[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (18))){
var inst_43582 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_43680__$1 = state_43680;
var statearr_43771_43853 = state_43680__$1;
(statearr_43771_43853[(2)] = inst_43582);

(statearr_43771_43853[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (52))){
var inst_43588 = (state_43680[(10)]);
var state_43680__$1 = state_43680;
var statearr_43772_43854 = state_43680__$1;
(statearr_43772_43854[(2)] = inst_43588);

(statearr_43772_43854[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (42))){
var inst_43633 = (state_43680[(25)]);
var inst_43598 = (state_43680[(21)]);
var inst_43635 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_43598);
var inst_43636 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_43633,inst_43635);
var state_43680__$1 = state_43680;
var statearr_43773_43855 = state_43680__$1;
(statearr_43773_43855[(2)] = inst_43636);

(statearr_43773_43855[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (37))){
var inst_43621 = (state_43680[(24)]);
var state_43680__$1 = state_43680;
var statearr_43774_43856 = state_43680__$1;
(statearr_43774_43856[(2)] = inst_43621);

(statearr_43774_43856[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (8))){
var inst_43556 = (state_43680[(2)]);
var state_43680__$1 = state_43680;
if(cljs.core.truth_(inst_43556)){
var statearr_43775_43857 = state_43680__$1;
(statearr_43775_43857[(1)] = (9));

} else {
var statearr_43776_43858 = state_43680__$1;
(statearr_43776_43858[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43681 === (49))){
var inst_43645 = (state_43680[(19)]);
var state_43680__$1 = state_43680;
var statearr_43777_43859 = state_43680__$1;
(statearr_43777_43859[(2)] = inst_43645);

(statearr_43777_43859[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__17178__auto__ = null;
var fluree$db$query$fql$state_machine__17178__auto____0 = (function (){
var statearr_43778 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43778[(0)] = fluree$db$query$fql$state_machine__17178__auto__);

(statearr_43778[(1)] = (1));

return statearr_43778;
});
var fluree$db$query$fql$state_machine__17178__auto____1 = (function (state_43680){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_43680);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e43779){var ex__17181__auto__ = e43779;
var statearr_43780_43860 = state_43680;
(statearr_43780_43860[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_43680[(4)]))){
var statearr_43781_43861 = state_43680;
(statearr_43781_43861[(1)] = cljs.core.first((state_43680[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43862 = state_43680;
state_43680 = G__43862;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__17178__auto__ = function(state_43680){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__17178__auto____1.call(this,state_43680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__17178__auto____0;
fluree$db$query$fql$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__17178__auto____1;
return fluree$db$query$fql$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_43782 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_43782[(6)] = c__17304__auto__);

return statearr_43782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__43865,groupBy){
var map__43866 = p__43865;
var map__43866__$1 = cljs.core.__destructure_map(map__43866);
var res = map__43866__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43866__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43866__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__43867 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43867,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43867,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43863_SHARP_){
return fluree.db.util.core.index_of(headers,p1__43863_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43864_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__43864_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__43870 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43870,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43870,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__43873,p__43874,opts){
var map__43875 = p__43873;
var map__43875__$1 = cljs.core.__destructure_map(map__43875);
var res = map__43875__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43875__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43875__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__43876 = p__43874;
var map__43876__$1 = cljs.core.__destructure_map(map__43876);
var select_spec = map__43876__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43876__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43876__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43876__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43876__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43876__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43876__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43876__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_44118){
var state_val_44119 = (state_44118[(1)]);
if((state_val_44119 === (65))){
var state_44118__$1 = state_44118;
var statearr_44120_44271 = state_44118__$1;
(statearr_44120_44271[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (70))){
var inst_44039 = (state_44118[(7)]);
var state_44118__$1 = state_44118;
var statearr_44122_44272 = state_44118__$1;
(statearr_44122_44272[(2)] = inst_44039);

(statearr_44122_44272[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (62))){
var state_44118__$1 = state_44118;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_44123_44273 = state_44118__$1;
(statearr_44123_44273[(1)] = (64));

} else {
var statearr_44124_44274 = state_44118__$1;
(statearr_44124_44274[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (74))){
var inst_43946 = (state_44118[(8)]);
var inst_43955 = (state_44118[(9)]);
var inst_44014 = (state_44118[(10)]);
var inst_44047 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43946,inst_43955,inst_44014);
var state_44118__$1 = state_44118;
var statearr_44125_44275 = state_44118__$1;
(statearr_44125_44275[(2)] = inst_44047);

(statearr_44125_44275[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (7))){
var state_44118__$1 = state_44118;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_44126_44276 = state_44118__$1;
(statearr_44126_44276[(1)] = (82));

} else {
var statearr_44127_44277 = state_44118__$1;
(statearr_44127_44277[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (59))){
var inst_44014 = (state_44118[(10)]);
var inst_43944 = (state_44118[(11)]);
var inst_44018 = cljs.core.count(inst_44014);
var inst_44019 = (inst_43944 - inst_44018);
var state_44118__$1 = state_44118;
var statearr_44128_44278 = state_44118__$1;
(statearr_44128_44278[(2)] = inst_44019);

(statearr_44128_44278[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (86))){
var state_44118__$1 = state_44118;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_44129_44279 = state_44118__$1;
(statearr_44129_44279[(1)] = (89));

} else {
var statearr_44130_44280 = state_44118__$1;
(statearr_44130_44280[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (20))){
var state_44118__$1 = state_44118;
var statearr_44131_44281 = state_44118__$1;
(statearr_44131_44281[(2)] = (0));

(statearr_44131_44281[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (72))){
var inst_44044 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
if(cljs.core.truth_(inst_44044)){
var statearr_44132_44282 = state_44118__$1;
(statearr_44132_44282[(1)] = (73));

} else {
var statearr_44133_44283 = state_44118__$1;
(statearr_44133_44283[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (58))){
var state_44118__$1 = state_44118;
var statearr_44134_44284 = state_44118__$1;
(statearr_44134_44284[(2)] = null);

(statearr_44134_44284[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (60))){
var inst_43945 = (state_44118[(12)]);
var inst_44021 = (state_44118[(2)]);
var inst_44022 = (inst_43945 <= (0));
var state_44118__$1 = (function (){var statearr_44135 = state_44118;
(statearr_44135[(13)] = inst_44021);

return statearr_44135;
})();
if(cljs.core.truth_(inst_44022)){
var statearr_44136_44285 = state_44118__$1;
(statearr_44136_44285[(1)] = (61));

} else {
var statearr_44137_44286 = state_44118__$1;
(statearr_44137_44286[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (27))){
var inst_43944 = (state_44118[(11)]);
var inst_43968 = (inst_43944 < (1));
var state_44118__$1 = state_44118;
var statearr_44138_44287 = state_44118__$1;
(statearr_44138_44287[(2)] = inst_43968);

(statearr_44138_44287[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (1))){
var state_44118__$1 = state_44118;
var statearr_44139_44288 = state_44118__$1;
(statearr_44139_44288[(2)] = null);

(statearr_44139_44288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (69))){
var inst_44034 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44140_44289 = state_44118__$1;
(statearr_44140_44289[(2)] = inst_44034);

(statearr_44140_44289[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (24))){
var inst_43946 = (state_44118[(8)]);
var state_44118__$1 = state_44118;
var statearr_44141_44290 = state_44118__$1;
(statearr_44141_44290[(2)] = inst_43946);

(statearr_44141_44290[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (55))){
var inst_44004 = (state_44118[(14)]);
var inst_43944 = (state_44118[(11)]);
var inst_44011 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_43944,inst_44004);
var state_44118__$1 = state_44118;
var statearr_44142_44291 = state_44118__$1;
(statearr_44142_44291[(2)] = inst_44011);

(statearr_44142_44291[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (85))){
var inst_44089 = (state_44118[(15)]);
var inst_44088 = (state_44118[(2)]);
var inst_44089__$1 = fluree.db.util.async.throw_err(inst_44088);
var inst_44090 = cljs.core.coll_QMARK_(inst_44089__$1);
var inst_44091 = (!(inst_44090));
var state_44118__$1 = (function (){var statearr_44143 = state_44118;
(statearr_44143[(15)] = inst_44089__$1);

return statearr_44143;
})();
if(inst_44091){
var statearr_44144_44292 = state_44118__$1;
(statearr_44144_44292[(1)] = (86));

} else {
var statearr_44145_44293 = state_44118__$1;
(statearr_44145_44293[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (39))){
var inst_43963 = (state_44118[(16)]);
var inst_43985 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_43986 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_43987 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_43963,inst_43985,inst_43986);
var state_44118__$1 = state_44118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44118__$1,(42),inst_43987);
} else {
if((state_val_44119 === (88))){
var inst_44111 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44146_44294 = state_44118__$1;
(statearr_44146_44294[(2)] = inst_44111);

(statearr_44146_44294[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (46))){
var inst_43945 = (state_44118[(12)]);
var inst_43999 = ((0) < inst_43945);
var state_44118__$1 = state_44118;
if(cljs.core.truth_(inst_43999)){
var statearr_44147_44295 = state_44118__$1;
(statearr_44147_44295[(1)] = (49));

} else {
var statearr_44148_44296 = state_44118__$1;
(statearr_44148_44296[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (4))){
var inst_43877 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44149_44297 = state_44118__$1;
(statearr_44149_44297[(2)] = inst_43877);

(statearr_44149_44297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (77))){
var inst_43944 = (state_44118[(11)]);
var inst_44055 = (inst_43944 - (1));
var state_44118__$1 = state_44118;
var statearr_44150_44298 = state_44118__$1;
(statearr_44150_44298[(2)] = inst_44055);

(statearr_44150_44298[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (95))){
var inst_44089 = (state_44118[(15)]);
var state_44118__$1 = state_44118;
var statearr_44151_44299 = state_44118__$1;
(statearr_44151_44299[(2)] = inst_44089);

(statearr_44151_44299[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (54))){
var inst_44009 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
if(cljs.core.truth_(inst_44009)){
var statearr_44152_44300 = state_44118__$1;
(statearr_44152_44300[(1)] = (55));

} else {
var statearr_44153_44301 = state_44118__$1;
(statearr_44153_44301[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (92))){
var inst_44089 = (state_44118[(15)]);
var inst_44102 = cljs.core.first(inst_44089);
var state_44118__$1 = state_44118;
var statearr_44154_44302 = state_44118__$1;
(statearr_44154_44302[(2)] = inst_44102);

(statearr_44154_44302[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (15))){
var inst_43895 = (state_44118[(17)]);
var inst_43903 = (state_44118[(2)]);
var inst_43904 = fluree.db.util.async.throw_err(inst_43903);
var inst_43905 = [inst_43895];
var inst_43906 = [inst_43904];
var inst_43907 = cljs.core.PersistentHashMap.fromArrays(inst_43905,inst_43906);
var state_44118__$1 = state_44118;
var statearr_44155_44303 = state_44118__$1;
(statearr_44155_44303[(2)] = inst_43907);

(statearr_44155_44303[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (48))){
var inst_44067 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44156_44304 = state_44118__$1;
(statearr_44156_44304[(2)] = inst_44067);

(statearr_44156_44304[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (50))){
var inst_43990 = (state_44118[(18)]);
var state_44118__$1 = state_44118;
var statearr_44157_44305 = state_44118__$1;
(statearr_44157_44305[(2)] = inst_43990);

(statearr_44157_44305[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (75))){
var inst_43959 = (state_44118[(19)]);
var inst_43956 = (state_44118[(20)]);
var inst_44038 = (state_44118[(21)]);
var inst_44021 = (state_44118[(13)]);
var inst_44049 = (state_44118[(2)]);
var inst_43942 = inst_43956;
var inst_43943 = inst_43959;
var inst_43944 = inst_44021;
var inst_43945 = inst_44038;
var inst_43946 = inst_44049;
var state_44118__$1 = (function (){var statearr_44158 = state_44118;
(statearr_44158[(8)] = inst_43946);

(statearr_44158[(22)] = inst_43942);

(statearr_44158[(23)] = inst_43943);

(statearr_44158[(12)] = inst_43945);

(statearr_44158[(11)] = inst_43944);

return statearr_44158;
})();
var statearr_44159_44306 = state_44118__$1;
(statearr_44159_44306[(2)] = null);

(statearr_44159_44306[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (21))){
var inst_43927 = (state_44118[(24)]);
var inst_43923 = (state_44118[(25)]);
var inst_43935 = (state_44118[(26)]);
var inst_43940 = (state_44118[(2)]);
var inst_43941 = cljs.core.PersistentHashMap.EMPTY;
var inst_43942 = inst_43923;
var inst_43943 = inst_43927;
var inst_43944 = inst_43935;
var inst_43945 = inst_43940;
var inst_43946 = inst_43941;
var state_44118__$1 = (function (){var statearr_44160 = state_44118;
(statearr_44160[(8)] = inst_43946);

(statearr_44160[(22)] = inst_43942);

(statearr_44160[(23)] = inst_43943);

(statearr_44160[(12)] = inst_43945);

(statearr_44160[(11)] = inst_43944);

return statearr_44160;
})();
var statearr_44161_44307 = state_44118__$1;
(statearr_44161_44307[(2)] = null);

(statearr_44161_44307[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (31))){
var inst_43960 = (state_44118[(27)]);
var inst_43945 = (state_44118[(12)]);
var inst_43974 = (inst_43945 >= inst_43960);
var state_44118__$1 = state_44118;
if(cljs.core.truth_(inst_43974)){
var statearr_44162_44308 = state_44118__$1;
(statearr_44162_44308[(1)] = (33));

} else {
var statearr_44163_44309 = state_44118__$1;
(statearr_44163_44309[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (32))){
var inst_44074 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44164_44310 = state_44118__$1;
(statearr_44164_44310[(2)] = inst_44074);

(statearr_44164_44310[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (40))){
var state_44118__$1 = state_44118;
var statearr_44165_44311 = state_44118__$1;
(statearr_44165_44311[(2)] = null);

(statearr_44165_44311[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (91))){
var inst_44099 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44166_44312 = state_44118__$1;
(statearr_44166_44312[(2)] = inst_44099);

(statearr_44166_44312[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (56))){
var inst_44004 = (state_44118[(14)]);
var state_44118__$1 = state_44118;
var statearr_44167_44313 = state_44118__$1;
(statearr_44167_44313[(2)] = inst_44004);

(statearr_44167_44313[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (33))){
var state_44118__$1 = state_44118;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_44168_44314 = state_44118__$1;
(statearr_44168_44314[(1)] = (36));

} else {
var statearr_44169_44315 = state_44118__$1;
(statearr_44169_44315[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (13))){
var inst_43927 = (state_44118[(24)]);
var inst_43892 = (state_44118[(28)]);
var inst_43923 = (state_44118[(25)]);
var inst_43923__$1 = cljs.core.keys(inst_43892);
var inst_43924 = cljs.core.seq(inst_43923__$1);
var inst_43925 = cljs.core.first(inst_43924);
var inst_43926 = cljs.core.next(inst_43924);
var inst_43927__$1 = cljs.core.vals(inst_43892);
var inst_43928 = cljs.core.seq(inst_43927__$1);
var inst_43929 = cljs.core.first(inst_43928);
var inst_43930 = cljs.core.next(inst_43928);
var inst_43931 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_44118__$1 = (function (){var statearr_44170 = state_44118;
(statearr_44170[(29)] = inst_43929);

(statearr_44170[(24)] = inst_43927__$1);

(statearr_44170[(30)] = inst_43930);

(statearr_44170[(31)] = inst_43925);

(statearr_44170[(25)] = inst_43923__$1);

(statearr_44170[(32)] = inst_43926);

return statearr_44170;
})();
if(inst_43931){
var statearr_44171_44316 = state_44118__$1;
(statearr_44171_44316[(1)] = (16));

} else {
var statearr_44172_44317 = state_44118__$1;
(statearr_44172_44317[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (22))){
var inst_43942 = (state_44118[(22)]);
var inst_43943 = (state_44118[(23)]);
var inst_43954 = cljs.core.seq(inst_43942);
var inst_43955 = cljs.core.first(inst_43954);
var inst_43956 = cljs.core.next(inst_43954);
var inst_43957 = cljs.core.seq(inst_43943);
var inst_43958 = cljs.core.first(inst_43957);
var inst_43959 = cljs.core.next(inst_43957);
var inst_43960 = cljs.core.count(inst_43958);
var inst_43961 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_43962 = [headers,vars,inst_43958];
var inst_43963 = cljs.core.PersistentHashMap.fromArrays(inst_43961,inst_43962);
var inst_43964 = (inst_43958 == null);
var state_44118__$1 = (function (){var statearr_44173 = state_44118;
(statearr_44173[(19)] = inst_43959);

(statearr_44173[(20)] = inst_43956);

(statearr_44173[(9)] = inst_43955);

(statearr_44173[(27)] = inst_43960);

(statearr_44173[(16)] = inst_43963);

return statearr_44173;
})();
if(cljs.core.truth_(inst_43964)){
var statearr_44174_44318 = state_44118__$1;
(statearr_44174_44318[(1)] = (24));

} else {
var statearr_44175_44319 = state_44118__$1;
(statearr_44175_44319[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (90))){
var inst_44089 = (state_44118[(15)]);
var state_44118__$1 = state_44118;
var statearr_44176_44320 = state_44118__$1;
(statearr_44176_44320[(2)] = inst_44089);

(statearr_44176_44320[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (36))){
var inst_43945 = (state_44118[(12)]);
var inst_43977 = (inst_43945 - (1));
var state_44118__$1 = state_44118;
var statearr_44177_44321 = state_44118__$1;
(statearr_44177_44321[(2)] = inst_43977);

(statearr_44177_44321[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (41))){
var inst_44070 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44178_44322 = state_44118__$1;
(statearr_44178_44322[(2)] = inst_44070);

(statearr_44178_44322[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (89))){
var inst_44089 = (state_44118[(15)]);
var inst_44094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44095 = [inst_44089];
var inst_44096 = (new cljs.core.PersistentVector(null,1,(5),inst_44094,inst_44095,null));
var state_44118__$1 = state_44118;
var statearr_44179_44323 = state_44118__$1;
(statearr_44179_44323[(2)] = inst_44096);

(statearr_44179_44323[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (43))){
var inst_43990 = (state_44118[(18)]);
var inst_43993 = cljs.core.seq(inst_43990);
var state_44118__$1 = state_44118;
var statearr_44180_44324 = state_44118__$1;
(statearr_44180_44324[(2)] = inst_43993);

(statearr_44180_44324[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (61))){
var state_44118__$1 = state_44118;
var statearr_44181_44325 = state_44118__$1;
(statearr_44181_44325[(2)] = (0));

(statearr_44181_44325[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (29))){
var inst_43971 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
if(cljs.core.truth_(inst_43971)){
var statearr_44182_44326 = state_44118__$1;
(statearr_44182_44326[(1)] = (30));

} else {
var statearr_44183_44327 = state_44118__$1;
(statearr_44183_44327[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (44))){
var inst_43991 = (state_44118[(33)]);
var state_44118__$1 = state_44118;
var statearr_44184_44328 = state_44118__$1;
(statearr_44184_44328[(2)] = inst_43991);

(statearr_44184_44328[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (93))){
var state_44118__$1 = state_44118;
var statearr_44185_44329 = state_44118__$1;
(statearr_44185_44329[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (6))){
var inst_43884 = (state_44118[(34)]);
var inst_43884__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_43886 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_44118__$1 = (function (){var statearr_44187 = state_44118;
(statearr_44187[(34)] = inst_43884__$1);

(statearr_44187[(35)] = inst_43886);

return statearr_44187;
})();
if(cljs.core.truth_(inst_43884__$1)){
var statearr_44188_44330 = state_44118__$1;
(statearr_44188_44330[(1)] = (9));

} else {
var statearr_44189_44331 = state_44118__$1;
(statearr_44189_44331[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (28))){
var inst_43944 = (state_44118[(11)]);
var state_44118__$1 = state_44118;
var statearr_44190_44332 = state_44118__$1;
(statearr_44190_44332[(2)] = inst_43944);

(statearr_44190_44332[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (64))){
var inst_43945 = (state_44118[(12)]);
var inst_44026 = (inst_43945 - (1));
var state_44118__$1 = state_44118;
var statearr_44191_44333 = state_44118__$1;
(statearr_44191_44333[(2)] = inst_44026);

(statearr_44191_44333[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (51))){
var inst_43944 = (state_44118[(11)]);
var inst_44004 = (state_44118[(2)]);
var state_44118__$1 = (function (){var statearr_44192 = state_44118;
(statearr_44192[(14)] = inst_44004);

return statearr_44192;
})();
if(cljs.core.truth_(inst_43944)){
var statearr_44193_44334 = state_44118__$1;
(statearr_44193_44334[(1)] = (52));

} else {
var statearr_44194_44335 = state_44118__$1;
(statearr_44194_44335[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (25))){
var inst_43944 = (state_44118[(11)]);
var state_44118__$1 = state_44118;
if(cljs.core.truth_(inst_43944)){
var statearr_44195_44336 = state_44118__$1;
(statearr_44195_44336[(1)] = (27));

} else {
var statearr_44196_44337 = state_44118__$1;
(statearr_44196_44337[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (34))){
var state_44118__$1 = state_44118;
var statearr_44197_44338 = state_44118__$1;
(statearr_44197_44338[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (17))){
var state_44118__$1 = state_44118;
var statearr_44199_44339 = state_44118__$1;
(statearr_44199_44339[(2)] = limit);

(statearr_44199_44339[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (3))){
var inst_44116 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44118__$1,inst_44116);
} else {
if((state_val_44119 === (12))){
var inst_43892 = (state_44118[(28)]);
var inst_43894 = cljs.core.keys(inst_43892);
var inst_43895 = cljs.core.first(inst_43894);
var inst_43896 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_43897 = cljs.core.vals(inst_43892);
var inst_43898 = cljs.core.first(inst_43897);
var inst_43899 = [headers,vars,inst_43898];
var inst_43900 = cljs.core.PersistentHashMap.fromArrays(inst_43896,inst_43899);
var inst_43901 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_43900,select_spec,limit,opts);
var state_44118__$1 = (function (){var statearr_44200 = state_44118;
(statearr_44200[(17)] = inst_43895);

return statearr_44200;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44118__$1,(15),inst_43901);
} else {
if((state_val_44119 === (2))){
var _ = (function (){var statearr_44201 = state_44118;
(statearr_44201[(4)] = cljs.core.cons((5),(state_44118[(4)])));

return statearr_44201;
})();
var state_44118__$1 = state_44118;
if(cljs.core.truth_(groupBy)){
var statearr_44202_44340 = state_44118__$1;
(statearr_44202_44340[(1)] = (6));

} else {
var statearr_44203_44341 = state_44118__$1;
(statearr_44203_44341[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (66))){
var inst_44036 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44204_44342 = state_44118__$1;
(statearr_44204_44342[(2)] = inst_44036);

(statearr_44204_44342[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (23))){
var inst_44078 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44205_44343 = state_44118__$1;
(statearr_44205_44343[(2)] = inst_44078);

(statearr_44205_44343[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (47))){
var inst_43944 = (state_44118[(11)]);
var inst_44052 = (inst_43944 == null);
var state_44118__$1 = state_44118;
if(cljs.core.truth_(inst_44052)){
var statearr_44206_44344 = state_44118__$1;
(statearr_44206_44344[(1)] = (76));

} else {
var statearr_44207_44345 = state_44118__$1;
(statearr_44207_44345[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (35))){
var inst_44072 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44208_44346 = state_44118__$1;
(statearr_44208_44346[(2)] = inst_44072);

(statearr_44208_44346[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (82))){
var state_44118__$1 = state_44118;
var statearr_44209_44347 = state_44118__$1;
(statearr_44209_44347[(2)] = (1));

(statearr_44209_44347[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (76))){
var state_44118__$1 = state_44118;
var statearr_44210_44348 = state_44118__$1;
(statearr_44210_44348[(2)] = null);

(statearr_44210_44348[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (97))){
var inst_44107 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44211_44349 = state_44118__$1;
(statearr_44211_44349[(2)] = inst_44107);

(statearr_44211_44349[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (19))){
var inst_43936 = (state_44118[(36)]);
var state_44118__$1 = state_44118;
var statearr_44212_44350 = state_44118__$1;
(statearr_44212_44350[(2)] = inst_43936);

(statearr_44212_44350[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (57))){
var inst_43944 = (state_44118[(11)]);
var inst_44014 = (state_44118[(2)]);
var inst_44015 = (inst_43944 == null);
var state_44118__$1 = (function (){var statearr_44213 = state_44118;
(statearr_44213[(10)] = inst_44014);

return statearr_44213;
})();
if(cljs.core.truth_(inst_44015)){
var statearr_44214_44351 = state_44118__$1;
(statearr_44214_44351[(1)] = (58));

} else {
var statearr_44215_44352 = state_44118__$1;
(statearr_44215_44352[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (68))){
var state_44118__$1 = state_44118;
var statearr_44216_44353 = state_44118__$1;
(statearr_44216_44353[(2)] = null);

(statearr_44216_44353[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (11))){
var inst_43892 = (state_44118[(2)]);
var state_44118__$1 = (function (){var statearr_44218 = state_44118;
(statearr_44218[(28)] = inst_43892);

return statearr_44218;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_44219_44354 = state_44118__$1;
(statearr_44219_44354[(1)] = (12));

} else {
var statearr_44220_44355 = state_44118__$1;
(statearr_44220_44355[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (9))){
var inst_43884 = (state_44118[(34)]);
var inst_43886 = (state_44118[(35)]);
var inst_43888 = cljs.core.sorted_map_by(inst_43884);
var inst_43889 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_43888,inst_43886);
var state_44118__$1 = state_44118;
var statearr_44221_44356 = state_44118__$1;
(statearr_44221_44356[(2)] = inst_43889);

(statearr_44221_44356[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (5))){
var _ = (function (){var statearr_44222 = state_44118;
(statearr_44222[(4)] = cljs.core.rest((state_44118[(4)])));

return statearr_44222;
})();
var state_44118__$1 = state_44118;
var ex44217 = (state_44118__$1[(2)]);
var statearr_44223_44357 = state_44118__$1;
(statearr_44223_44357[(5)] = ex44217);


if((ex44217 instanceof Error)){
var statearr_44224_44358 = state_44118__$1;
(statearr_44224_44358[(1)] = (4));

(statearr_44224_44358[(5)] = null);

} else {
throw ex44217;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (83))){
var state_44118__$1 = state_44118;
var statearr_44225_44359 = state_44118__$1;
(statearr_44225_44359[(2)] = limit);

(statearr_44225_44359[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (14))){
var inst_44080 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44226_44360 = state_44118__$1;
(statearr_44226_44360[(2)] = inst_44080);

(statearr_44226_44360[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (45))){
var inst_43996 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
if(cljs.core.truth_(inst_43996)){
var statearr_44227_44361 = state_44118__$1;
(statearr_44227_44361[(1)] = (46));

} else {
var statearr_44228_44362 = state_44118__$1;
(statearr_44228_44362[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (53))){
var inst_43944 = (state_44118[(11)]);
var state_44118__$1 = state_44118;
var statearr_44229_44363 = state_44118__$1;
(statearr_44229_44363[(2)] = inst_43944);

(statearr_44229_44363[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (78))){
var inst_43945 = (state_44118[(12)]);
var inst_44057 = (state_44118[(2)]);
var inst_44058 = (inst_43945 <= (0));
var state_44118__$1 = (function (){var statearr_44230 = state_44118;
(statearr_44230[(37)] = inst_44057);

return statearr_44230;
})();
if(cljs.core.truth_(inst_44058)){
var statearr_44231_44364 = state_44118__$1;
(statearr_44231_44364[(1)] = (79));

} else {
var statearr_44232_44365 = state_44118__$1;
(statearr_44232_44365[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (26))){
var inst_44076 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44233_44366 = state_44118__$1;
(statearr_44233_44366[(2)] = inst_44076);

(statearr_44233_44366[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (16))){
var state_44118__$1 = state_44118;
var statearr_44234_44367 = state_44118__$1;
(statearr_44234_44367[(2)] = null);

(statearr_44234_44367[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (81))){
var inst_43959 = (state_44118[(19)]);
var inst_43946 = (state_44118[(8)]);
var inst_43956 = (state_44118[(20)]);
var inst_43955 = (state_44118[(9)]);
var inst_44057 = (state_44118[(37)]);
var inst_43990 = (state_44118[(18)]);
var inst_44063 = (state_44118[(2)]);
var inst_44064 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43946,inst_43955,inst_43990);
var inst_43942 = inst_43956;
var inst_43943 = inst_43959;
var inst_43944 = inst_44057;
var inst_43945 = inst_44063;
var inst_43946__$1 = inst_44064;
var state_44118__$1 = (function (){var statearr_44237 = state_44118;
(statearr_44237[(8)] = inst_43946__$1);

(statearr_44237[(22)] = inst_43942);

(statearr_44237[(23)] = inst_43943);

(statearr_44237[(12)] = inst_43945);

(statearr_44237[(11)] = inst_43944);

return statearr_44237;
})();
var statearr_44238_44368 = state_44118__$1;
(statearr_44238_44368[(2)] = null);

(statearr_44238_44368[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (79))){
var state_44118__$1 = state_44118;
var statearr_44239_44369 = state_44118__$1;
(statearr_44239_44369[(2)] = (0));

(statearr_44239_44369[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (38))){
var inst_43959 = (state_44118[(19)]);
var inst_43946 = (state_44118[(8)]);
var inst_43956 = (state_44118[(20)]);
var inst_43944 = (state_44118[(11)]);
var inst_43981 = (state_44118[(2)]);
var tmp44235 = inst_43946;
var tmp44236 = inst_43944;
var inst_43942 = inst_43956;
var inst_43943 = inst_43959;
var inst_43944__$1 = tmp44236;
var inst_43945 = inst_43981;
var inst_43946__$1 = tmp44235;
var state_44118__$1 = (function (){var statearr_44240 = state_44118;
(statearr_44240[(8)] = inst_43946__$1);

(statearr_44240[(22)] = inst_43942);

(statearr_44240[(23)] = inst_43943);

(statearr_44240[(12)] = inst_43945);

(statearr_44240[(11)] = inst_43944__$1);

return statearr_44240;
})();
var statearr_44241_44370 = state_44118__$1;
(statearr_44241_44370[(2)] = null);

(statearr_44241_44370[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (87))){
var state_44118__$1 = state_44118;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_44242_44371 = state_44118__$1;
(statearr_44242_44371[(1)] = (92));

} else {
var statearr_44243_44372 = state_44118__$1;
(statearr_44243_44372[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (30))){
var inst_43946 = (state_44118[(8)]);
var state_44118__$1 = state_44118;
var statearr_44244_44373 = state_44118__$1;
(statearr_44244_44373[(2)] = inst_43946);

(statearr_44244_44373[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (73))){
var inst_43946 = (state_44118[(8)]);
var state_44118__$1 = state_44118;
var statearr_44245_44374 = state_44118__$1;
(statearr_44245_44374[(2)] = inst_43946);

(statearr_44245_44374[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (96))){
var state_44118__$1 = state_44118;
var statearr_44246_44375 = state_44118__$1;
(statearr_44246_44375[(2)] = null);

(statearr_44246_44375[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (10))){
var inst_43886 = (state_44118[(35)]);
var state_44118__$1 = state_44118;
var statearr_44247_44376 = state_44118__$1;
(statearr_44247_44376[(2)] = inst_43886);

(statearr_44247_44376[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (18))){
var inst_43936 = (state_44118[(36)]);
var inst_43935 = (state_44118[(2)]);
var inst_43936__$1 = offset;
var state_44118__$1 = (function (){var statearr_44248 = state_44118;
(statearr_44248[(36)] = inst_43936__$1);

(statearr_44248[(26)] = inst_43935);

return statearr_44248;
})();
if(cljs.core.truth_(inst_43936__$1)){
var statearr_44249_44377 = state_44118__$1;
(statearr_44249_44377[(1)] = (19));

} else {
var statearr_44250_44378 = state_44118__$1;
(statearr_44250_44378[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (52))){
var inst_43944 = (state_44118[(11)]);
var inst_44006 = ((0) < inst_43944);
var state_44118__$1 = state_44118;
var statearr_44251_44379 = state_44118__$1;
(statearr_44251_44379[(2)] = inst_44006);

(statearr_44251_44379[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (67))){
var inst_43960 = (state_44118[(27)]);
var inst_44014 = (state_44118[(10)]);
var inst_43945 = (state_44118[(12)]);
var inst_44029 = cljs.core.count(inst_44014);
var inst_44030 = (inst_43960 - inst_44029);
var inst_44031 = (inst_43945 - inst_44030);
var state_44118__$1 = state_44118;
var statearr_44252_44380 = state_44118__$1;
(statearr_44252_44380[(2)] = inst_44031);

(statearr_44252_44380[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (71))){
var inst_44014 = (state_44118[(10)]);
var inst_44042 = cljs.core.empty_QMARK_(inst_44014);
var state_44118__$1 = state_44118;
var statearr_44253_44381 = state_44118__$1;
(statearr_44253_44381[(2)] = inst_44042);

(statearr_44253_44381[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (42))){
var inst_43991 = (state_44118[(33)]);
var inst_43990 = (state_44118[(18)]);
var inst_43989 = (state_44118[(2)]);
var inst_43990__$1 = fluree.db.util.async.throw_err(inst_43989);
var inst_43991__$1 = cljs.core.coll_QMARK_(inst_43990__$1);
var state_44118__$1 = (function (){var statearr_44254 = state_44118;
(statearr_44254[(33)] = inst_43991__$1);

(statearr_44254[(18)] = inst_43990__$1);

return statearr_44254;
})();
if(inst_43991__$1){
var statearr_44255_44382 = state_44118__$1;
(statearr_44255_44382[(1)] = (43));

} else {
var statearr_44256_44383 = state_44118__$1;
(statearr_44256_44383[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (80))){
var inst_43945 = (state_44118[(12)]);
var inst_44061 = (inst_43945 - (1));
var state_44118__$1 = state_44118;
var statearr_44257_44384 = state_44118__$1;
(statearr_44257_44384[(2)] = inst_44061);

(statearr_44257_44384[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (37))){
var inst_43960 = (state_44118[(27)]);
var inst_43945 = (state_44118[(12)]);
var inst_43979 = (inst_43945 - inst_43960);
var state_44118__$1 = state_44118;
var statearr_44258_44385 = state_44118__$1;
(statearr_44258_44385[(2)] = inst_43979);

(statearr_44258_44385[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (63))){
var inst_44014 = (state_44118[(10)]);
var inst_44039 = (state_44118[(7)]);
var inst_44038 = (state_44118[(2)]);
var inst_44039__$1 = (inst_44014 == null);
var state_44118__$1 = (function (){var statearr_44259 = state_44118;
(statearr_44259[(21)] = inst_44038);

(statearr_44259[(7)] = inst_44039__$1);

return statearr_44259;
})();
if(cljs.core.truth_(inst_44039__$1)){
var statearr_44260_44386 = state_44118__$1;
(statearr_44260_44386[(1)] = (70));

} else {
var statearr_44261_44387 = state_44118__$1;
(statearr_44261_44387[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (94))){
var inst_44109 = (state_44118[(2)]);
var state_44118__$1 = state_44118;
var statearr_44262_44388 = state_44118__$1;
(statearr_44262_44388[(2)] = inst_44109);

(statearr_44262_44388[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (8))){
var inst_44113 = (state_44118[(2)]);
var _ = (function (){var statearr_44263 = state_44118;
(statearr_44263[(4)] = cljs.core.rest((state_44118[(4)])));

return statearr_44263;
})();
var state_44118__$1 = state_44118;
var statearr_44264_44389 = state_44118__$1;
(statearr_44264_44389[(2)] = inst_44113);

(statearr_44264_44389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (49))){
var inst_43945 = (state_44118[(12)]);
var inst_43990 = (state_44118[(18)]);
var inst_44001 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_43945,inst_43990);
var state_44118__$1 = state_44118;
var statearr_44265_44390 = state_44118__$1;
(statearr_44265_44390[(2)] = inst_44001);

(statearr_44265_44390[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44119 === (84))){
var inst_44085 = (state_44118[(2)]);
var inst_44086 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_44085,opts);
var state_44118__$1 = state_44118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44118__$1,(85),inst_44086);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17178__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17178__auto____0 = (function (){
var statearr_44266 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44266[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17178__auto__);

(statearr_44266[(1)] = (1));

return statearr_44266;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17178__auto____1 = (function (state_44118){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_44118);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e44267){var ex__17181__auto__ = e44267;
var statearr_44268_44391 = state_44118;
(statearr_44268_44391[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_44118[(4)]))){
var statearr_44269_44392 = state_44118;
(statearr_44269_44392[(1)] = cljs.core.first((state_44118[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44393 = state_44118;
state_44118 = G__44393;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17178__auto__ = function(state_44118){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17178__auto____1.call(this,state_44118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17178__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17178__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_44270 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_44270[(6)] = c__17304__auto__);

return statearr_44270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__44396,opts){
var map__44397 = p__44396;
var map__44397__$1 = cljs.core.__destructure_map(map__44397);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44397__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44397__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44397__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44397__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4212__auto__ = selectOne;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = select;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
var or__4212__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4212__auto____$2)){
return or__4212__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__44394_SHARP_){
return cljs.core.contains_QMARK_(p1__44394_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__44395_SHARP_){
return cljs.core.contains_QMARK_(p1__44395_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4212__auto__ = typeof orderBy === 'string';
if(or__4212__auto__){
return or__4212__auto__;
} else {
var and__4210__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4210__auto__){
var G__44399 = cljs.core.first(orderBy);
var fexpr__44398 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__44398.cljs$core$IFn$_invoke$arity$1 ? fexpr__44398.cljs$core$IFn$_invoke$arity$1(G__44399) : fexpr__44398.call(null,G__44399));
} else {
return and__4210__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})(),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4212__auto__ = selectDistinct;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__44400,p__44401){
var map__44402 = p__44400;
var map__44402__$1 = cljs.core.__destructure_map(map__44402);
var query_map = map__44402__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44402__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__44403 = p__44401;
var map__44403__$1 = cljs.core.__destructure_map(map__44403);
var where_result = map__44403__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44403__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44403__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__44404 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44404,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44404,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44404,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_44437){
var state_val_44438 = (state_44437[(1)]);
if((state_val_44438 === (7))){
var inst_44416 = (state_44437[(7)]);
var state_44437__$1 = state_44437;
var statearr_44439_44462 = state_44437__$1;
(statearr_44439_44462[(2)] = inst_44416);

(statearr_44439_44462[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44438 === (1))){
var state_44437__$1 = state_44437;
var statearr_44440_44463 = state_44437__$1;
(statearr_44440_44463[(2)] = null);

(statearr_44440_44463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44438 === (4))){
var inst_44407 = (state_44437[(2)]);
var state_44437__$1 = state_44437;
var statearr_44441_44464 = state_44437__$1;
(statearr_44441_44464[(2)] = inst_44407);

(statearr_44441_44464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44438 === (13))){
var inst_44426 = (state_44437[(2)]);
var inst_44427 = fluree.db.util.async.throw_err(inst_44426);
var state_44437__$1 = state_44437;
var statearr_44442_44465 = state_44437__$1;
(statearr_44442_44465[(2)] = inst_44427);

(statearr_44442_44465[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44438 === (6))){
var inst_44416 = (state_44437[(7)]);
var inst_44415 = (state_44437[(2)]);
var inst_44416__$1 = fluree.db.util.async.throw_err(inst_44415);
var inst_44417 = fluree.db.util.core.exception_QMARK_(inst_44416__$1);
var state_44437__$1 = (function (){var statearr_44443 = state_44437;
(statearr_44443[(7)] = inst_44416__$1);

return statearr_44443;
})();
if(inst_44417){
var statearr_44444_44466 = state_44437__$1;
(statearr_44444_44466[(1)] = (7));

} else {
var statearr_44445_44467 = state_44437__$1;
(statearr_44445_44467[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44438 === (3))){
var inst_44435 = (state_44437[(2)]);
var state_44437__$1 = state_44437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44437__$1,inst_44435);
} else {
if((state_val_44438 === (12))){
var inst_44430 = (state_44437[(2)]);
var state_44437__$1 = state_44437;
var statearr_44446_44468 = state_44437__$1;
(statearr_44446_44468[(2)] = inst_44430);

(statearr_44446_44468[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44438 === (2))){
var _ = (function (){var statearr_44447 = state_44437;
(statearr_44447[(4)] = cljs.core.cons((5),(state_44437[(4)])));

return statearr_44447;
})();
var inst_44413 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_44437__$1 = state_44437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44437__$1,(6),inst_44413);
} else {
if((state_val_44438 === (11))){
var state_44437__$1 = state_44437;
var statearr_44449_44469 = state_44437__$1;
(statearr_44449_44469[(2)] = null);

(statearr_44449_44469[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44438 === (9))){
var inst_44432 = (state_44437[(2)]);
var _ = (function (){var statearr_44450 = state_44437;
(statearr_44450[(4)] = cljs.core.rest((state_44437[(4)])));

return statearr_44450;
})();
var state_44437__$1 = state_44437;
var statearr_44451_44470 = state_44437__$1;
(statearr_44451_44470[(2)] = inst_44432);

(statearr_44451_44470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44438 === (5))){
var _ = (function (){var statearr_44452 = state_44437;
(statearr_44452[(4)] = cljs.core.rest((state_44437[(4)])));

return statearr_44452;
})();
var state_44437__$1 = state_44437;
var ex44448 = (state_44437__$1[(2)]);
var statearr_44453_44471 = state_44437__$1;
(statearr_44453_44471[(5)] = ex44448);


if((ex44448 instanceof Error)){
var statearr_44454_44472 = state_44437__$1;
(statearr_44454_44472[(1)] = (4));

(statearr_44454_44472[(5)] = null);

} else {
throw ex44448;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44438 === (10))){
var inst_44416 = (state_44437[(7)]);
var inst_44421 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_44416);
var inst_44422 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_44416);
var inst_44423 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_44421,inst_44422,query_map,opts);
var inst_44424 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_44416,inst_44423,opts);
var state_44437__$1 = state_44437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44437__$1,(13),inst_44424);
} else {
if((state_val_44438 === (8))){
var state_44437__$1 = state_44437;
var statearr_44455_44473 = state_44437__$1;
(statearr_44455_44473[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__17178__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__17178__auto____0 = (function (){
var statearr_44457 = [null,null,null,null,null,null,null,null];
(statearr_44457[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__17178__auto__);

(statearr_44457[(1)] = (1));

return statearr_44457;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__17178__auto____1 = (function (state_44437){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_44437);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e44458){var ex__17181__auto__ = e44458;
var statearr_44459_44474 = state_44437;
(statearr_44459_44474[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_44437[(4)]))){
var statearr_44460_44475 = state_44437;
(statearr_44460_44475[(1)] = cljs.core.first((state_44437[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44476 = state_44437;
state_44437 = G__44476;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__17178__auto__ = function(state_44437){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__17178__auto____1.call(this,state_44437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__17178__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__17178__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_44461 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_44461[(6)] = c__17304__auto__);

return statearr_44461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__44477 = query_map;
var map__44477__$1 = cljs.core.__destructure_map(map__44477);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44477__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44477__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44477__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44477__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44477__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44477__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44477__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44477__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44477__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44477__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44477__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44477__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__44478 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4212__auto__ = offset;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44478,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__44478;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.truth_((function (){var or__4212__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_44836){
var state_val_44837 = (state_44836[(1)]);
if((state_val_44837 === (121))){
var inst_44797 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44838_45033 = state_44836__$1;
(statearr_44838_45033[(2)] = inst_44797);

(statearr_44838_45033[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (65))){
var inst_44674 = typeof from === 'string';
var state_44836__$1 = state_44836;
if(cljs.core.truth_(inst_44674)){
var statearr_44839_45034 = state_44836__$1;
(statearr_44839_45034[(1)] = (72));

} else {
var statearr_44840_45035 = state_44836__$1;
(statearr_44840_45035[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (70))){
var inst_44542 = (state_44836[(7)]);
var inst_44540 = (state_44836[(8)]);
var inst_44667 = (state_44836[(2)]);
var inst_44668 = fluree.db.util.async.throw_err(inst_44667);
var inst_44669 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_44542,fuel,max_fuel,inst_44540,inst_44668);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(71),inst_44669);
} else {
if((state_val_44837 === (62))){
var inst_44647 = (state_44836[(9)]);
var state_44836__$1 = state_44836;
var statearr_44841_45036 = state_44836__$1;
(statearr_44841_45036[(2)] = inst_44647);

(statearr_44841_45036[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (74))){
var inst_44803 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44842_45037 = state_44836__$1;
(statearr_44842_45037[(2)] = inst_44803);

(statearr_44842_45037[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (110))){
var inst_44738 = (state_44836[(10)]);
var state_44836__$1 = state_44836;
var statearr_44843_45038 = state_44836__$1;
(statearr_44843_45038[(2)] = inst_44738);

(statearr_44843_45038[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (130))){
var inst_44823 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44844_45039 = state_44836__$1;
(statearr_44844_45039[(2)] = inst_44823);

(statearr_44844_45039[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (128))){
var inst_44814 = (state_44836[(11)]);
var inst_44819 = fluree.db.util.core.exception_QMARK_(inst_44814);
var inst_44820 = (!(inst_44819));
var state_44836__$1 = state_44836;
var statearr_44845_45040 = state_44836__$1;
(statearr_44845_45040[(2)] = inst_44820);

(statearr_44845_45040[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (7))){
var inst_44510 = (state_44836[(12)]);
var inst_44510__$1 = selectOne;
var state_44836__$1 = (function (){var statearr_44846 = state_44836;
(statearr_44846[(12)] = inst_44510__$1);

return statearr_44846;
})();
if(cljs.core.truth_(inst_44510__$1)){
var statearr_44847_45041 = state_44836__$1;
(statearr_44847_45041[(1)] = (9));

} else {
var statearr_44848_45042 = state_44836__$1;
(statearr_44848_45042[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (59))){
var inst_44530 = (state_44836[(13)]);
var inst_44625 = (state_44836[(14)]);
var inst_44542 = (state_44836[(7)]);
var inst_44540 = (state_44836[(8)]);
var inst_44639 = (state_44836[(2)]);
var inst_44640 = fluree.db.util.async.throw_err(inst_44639);
var inst_44641 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_44625,inst_44640);
var inst_44642 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_44542,fuel,max_fuel,inst_44540,inst_44641,inst_44530);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(60),inst_44642);
} else {
if((state_val_44837 === (86))){
var inst_44530 = (state_44836[(13)]);
var inst_44532 = (state_44836[(15)]);
var inst_44542 = (state_44836[(7)]);
var inst_44540 = (state_44836[(8)]);
var inst_44707 = (state_44836[(2)]);
var inst_44708 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_44542,fuel,max_fuel,inst_44540,inst_44707,inst_44530,inst_44532);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(87),inst_44708);
} else {
if((state_val_44837 === (20))){
var inst_44574 = (state_44836[(2)]);
var inst_44575 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44574,(0),null);
var inst_44576 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44574,(1),null);
var inst_44577 = typeof where === 'string';
var state_44836__$1 = (function (){var statearr_44849 = state_44836;
(statearr_44849[(16)] = inst_44575);

(statearr_44849[(17)] = inst_44576);

return statearr_44849;
})();
if(cljs.core.truth_(inst_44577)){
var statearr_44850_45043 = state_44836__$1;
(statearr_44850_45043[(1)] = (30));

} else {
var statearr_44851_45044 = state_44836__$1;
(statearr_44851_45044[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (72))){
var inst_44529 = (state_44836[(18)]);
var state_44836__$1 = state_44836;
if(cljs.core.truth_(inst_44529)){
var statearr_44852_45045 = state_44836__$1;
(statearr_44852_45045[(1)] = (75));

} else {
var statearr_44853_45046 = state_44836__$1;
(statearr_44853_45046[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (58))){
var inst_44633 = (state_44836[(2)]);
var inst_44634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44635 = [from];
var inst_44636 = (new cljs.core.PersistentVector(null,1,(5),inst_44634,inst_44635,null));
var inst_44637 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_44636,inst_44633);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(59),inst_44637);
} else {
if((state_val_44837 === (60))){
var inst_44644 = (state_44836[(2)]);
var inst_44645 = fluree.db.util.async.throw_err(inst_44644);
var state_44836__$1 = state_44836;
var statearr_44854_45047 = state_44836__$1;
(statearr_44854_45047[(2)] = inst_44645);

(statearr_44854_45047[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (27))){
var inst_44559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44560 = [null,null];
var inst_44561 = (new cljs.core.PersistentVector(null,2,(5),inst_44559,inst_44560,null));
var state_44836__$1 = state_44836;
var statearr_44855_45048 = state_44836__$1;
(statearr_44855_45048[(2)] = inst_44561);

(statearr_44855_45048[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (1))){
var state_44836__$1 = state_44836;
var statearr_44856_45049 = state_44836__$1;
(statearr_44856_45049[(2)] = null);

(statearr_44856_45049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (69))){
var inst_44664 = (state_44836[(2)]);
var inst_44665 = fluree.db.query.range._block_or_tx_collection(db,inst_44664);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(70),inst_44665);
} else {
if((state_val_44837 === (101))){
var inst_44770 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44857_45050 = state_44836__$1;
(statearr_44857_45050[(2)] = inst_44770);

(statearr_44857_45050[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (24))){
var inst_44529 = (state_44836[(18)]);
var inst_44554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44555 = [inst_44529,"ASC"];
var inst_44556 = (new cljs.core.PersistentVector(null,2,(5),inst_44554,inst_44555,null));
var state_44836__$1 = state_44836;
var statearr_44858_45051 = state_44836__$1;
(statearr_44858_45051[(2)] = inst_44556);

(statearr_44858_45051[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (102))){
var inst_44744 = (state_44836[(19)]);
var state_44836__$1 = state_44836;
var statearr_44859_45052 = state_44836__$1;
(statearr_44859_45052[(2)] = inst_44744);

(statearr_44859_45052[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (55))){
var inst_44529 = (state_44836[(18)]);
var inst_44625 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44860 = state_44836;
(statearr_44860[(14)] = inst_44625);

return statearr_44860;
})();
if(cljs.core.truth_(inst_44529)){
var statearr_44861_45053 = state_44836__$1;
(statearr_44861_45053[(1)] = (56));

} else {
var statearr_44862_45054 = state_44836__$1;
(statearr_44862_45054[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (85))){
var inst_44699 = (state_44836[(20)]);
var inst_44703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44704 = [inst_44699];
var inst_44705 = (new cljs.core.PersistentVector(null,1,(5),inst_44703,inst_44704,null));
var state_44836__$1 = state_44836;
var statearr_44863_45055 = state_44836__$1;
(statearr_44863_45055[(2)] = inst_44705);

(statearr_44863_45055[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (39))){
var inst_44530 = (state_44836[(13)]);
var state_44836__$1 = state_44836;
var statearr_44864_45056 = state_44836__$1;
(statearr_44864_45056[(2)] = inst_44530);

(statearr_44864_45056[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (88))){
var inst_44713 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_44836__$1 = state_44836;
var statearr_44865_45057 = state_44836__$1;
(statearr_44865_45057[(2)] = inst_44713);

(statearr_44865_45057[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (46))){
var inst_44610 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
if(cljs.core.truth_(inst_44610)){
var statearr_44866_45058 = state_44836__$1;
(statearr_44866_45058[(1)] = (47));

} else {
var statearr_44867_45059 = state_44836__$1;
(statearr_44867_45059[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (4))){
var inst_44497 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44868_45060 = state_44836__$1;
(statearr_44868_45060[(2)] = inst_44497);

(statearr_44868_45060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (77))){
var inst_44683 = (state_44836[(2)]);
var inst_44684 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_44683);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(78),inst_44684);
} else {
if((state_val_44837 === (106))){
var state_44836__$1 = state_44836;
var statearr_44869_45061 = state_44836__$1;
(statearr_44869_45061[(2)] = null);

(statearr_44869_45061[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (119))){
var inst_44789 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_44790 = ["Invalid 'from' in query:",inst_44789].join('');
var inst_44791 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_44792 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_44793 = cljs.core.PersistentHashMap.fromArrays(inst_44791,inst_44792);
var inst_44794 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_44790,inst_44793);
var state_44836__$1 = state_44836;
var statearr_44870_45062 = state_44836__$1;
(statearr_44870_45062[(2)] = inst_44794);

(statearr_44870_45062[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (95))){
var state_44836__$1 = state_44836;
var statearr_44871_45063 = state_44836__$1;
(statearr_44871_45063[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (54))){
var inst_44619 = (state_44836[(21)]);
var state_44836__$1 = state_44836;
var statearr_44873_45064 = state_44836__$1;
(statearr_44873_45064[(2)] = inst_44619);

(statearr_44873_45064[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (92))){
var inst_44718 = (state_44836[(22)]);
var state_44836__$1 = state_44836;
var statearr_44874_45065 = state_44836__$1;
(statearr_44874_45065[(2)] = inst_44718);

(statearr_44874_45065[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (104))){
var inst_44762 = (state_44836[(23)]);
var inst_44762__$1 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44875 = state_44836;
(statearr_44875[(23)] = inst_44762__$1);

return statearr_44875;
})();
if(cljs.core.truth_(inst_44762__$1)){
var statearr_44876_45066 = state_44836__$1;
(statearr_44876_45066[(1)] = (109));

} else {
var statearr_44877_45067 = state_44836__$1;
(statearr_44877_45067[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (15))){
var inst_44533 = (state_44836[(24)]);
var inst_44531 = (state_44836[(25)]);
var inst_44537 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_44533,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_44531);
var state_44836__$1 = state_44836;
var statearr_44878_45068 = state_44836__$1;
(statearr_44878_45068[(2)] = inst_44537);

(statearr_44878_45068[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (48))){
var inst_44647 = (state_44836[(9)]);
var inst_44647__$1 = typeof from === 'string';
var state_44836__$1 = (function (){var statearr_44879 = state_44836;
(statearr_44879[(9)] = inst_44647__$1);

return statearr_44879;
})();
if(cljs.core.truth_(inst_44647__$1)){
var statearr_44880_45069 = state_44836__$1;
(statearr_44880_45069[(1)] = (61));

} else {
var statearr_44881_45070 = state_44836__$1;
(statearr_44881_45070[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (50))){
var inst_44613 = (state_44836[(26)]);
var inst_44615 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_44616 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_44613,inst_44615);
var state_44836__$1 = state_44836;
var statearr_44882_45071 = state_44836__$1;
(statearr_44882_45071[(2)] = inst_44616);

(statearr_44882_45071[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (116))){
var state_44836__$1 = state_44836;
var statearr_44883_45072 = state_44836__$1;
(statearr_44883_45072[(2)] = null);

(statearr_44883_45072[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (75))){
var inst_44677 = cljs.core.PersistentHashMap.EMPTY;
var state_44836__$1 = state_44836;
var statearr_44884_45073 = state_44836__$1;
(statearr_44884_45073[(2)] = inst_44677);

(statearr_44884_45073[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (99))){
var inst_44738 = (state_44836[(10)]);
var state_44836__$1 = state_44836;
var statearr_44885_45074 = state_44836__$1;
(statearr_44885_45074[(2)] = inst_44738);

(statearr_44885_45074[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (21))){
var inst_44529 = (state_44836[(18)]);
var inst_44546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44547 = cljs.core.second(inst_44529);
var inst_44548 = cljs.core.first(inst_44529);
var inst_44549 = [inst_44547,inst_44548];
var inst_44550 = (new cljs.core.PersistentVector(null,2,(5),inst_44546,inst_44549,null));
var state_44836__$1 = state_44836;
var statearr_44886_45075 = state_44836__$1;
(statearr_44886_45075[(2)] = inst_44550);

(statearr_44886_45075[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (31))){
var inst_44604 = (state_44836[(27)]);
var inst_44604__$1 = typeof from === 'string';
var state_44836__$1 = (function (){var statearr_44887 = state_44836;
(statearr_44887[(27)] = inst_44604__$1);

return statearr_44887;
})();
if(cljs.core.truth_(inst_44604__$1)){
var statearr_44888_45076 = state_44836__$1;
(statearr_44888_45076[(1)] = (44));

} else {
var statearr_44889_45077 = state_44836__$1;
(statearr_44889_45077[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (113))){
var state_44836__$1 = state_44836;
var statearr_44890_45078 = state_44836__$1;
(statearr_44890_45078[(2)] = null);

(statearr_44890_45078[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (32))){
var inst_44575 = (state_44836[(16)]);
var inst_44809 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44891 = state_44836;
(statearr_44891[(28)] = inst_44809);

return statearr_44891;
})();
if(cljs.core.truth_(inst_44575)){
var statearr_44892_45079 = state_44836__$1;
(statearr_44892_45079[(1)] = (122));

} else {
var statearr_44893_45080 = state_44836__$1;
(statearr_44893_45080[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (40))){
var inst_44529 = (state_44836[(18)]);
var inst_44594 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44894 = state_44836;
(statearr_44894[(29)] = inst_44594);

return statearr_44894;
})();
if(cljs.core.truth_(inst_44529)){
var statearr_44895_45081 = state_44836__$1;
(statearr_44895_45081[(1)] = (41));

} else {
var statearr_44896_45082 = state_44836__$1;
(statearr_44896_45082[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (129))){
var inst_44817 = (state_44836[(30)]);
var state_44836__$1 = state_44836;
var statearr_44897_45083 = state_44836__$1;
(statearr_44897_45083[(2)] = inst_44817);

(statearr_44897_45083[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (91))){
var inst_44720 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_44836__$1 = state_44836;
var statearr_44898_45084 = state_44836__$1;
(statearr_44898_45084[(2)] = inst_44720);

(statearr_44898_45084[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (117))){
var inst_44532 = (state_44836[(15)]);
var state_44836__$1 = state_44836;
var statearr_44899_45085 = state_44836__$1;
(statearr_44899_45085[(2)] = inst_44532);

(statearr_44899_45085[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (108))){
var inst_44759 = (state_44836[(2)]);
var inst_44760 = fluree.db.util.async.throw_err(inst_44759);
var state_44836__$1 = state_44836;
var statearr_44900_45086 = state_44836__$1;
(statearr_44900_45086[(2)] = inst_44760);

(statearr_44900_45086[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (56))){
var inst_44627 = cljs.core.PersistentHashMap.EMPTY;
var state_44836__$1 = state_44836;
var statearr_44901_45087 = state_44836__$1;
(statearr_44901_45087[(2)] = inst_44627);

(statearr_44901_45087[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (33))){
var state_44836__$1 = state_44836;
var statearr_44902_45088 = state_44836__$1;
(statearr_44902_45088[(2)] = from);

(statearr_44902_45088[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (13))){
var inst_44516 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_44517 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_44518 = cljs.core.PersistentHashMap.fromArrays(inst_44516,inst_44517);
var inst_44519 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_44518);
var inst_44520 = (function(){throw inst_44519})();
var state_44836__$1 = state_44836;
var statearr_44903_45089 = state_44836__$1;
(statearr_44903_45089[(2)] = inst_44520);

(statearr_44903_45089[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (22))){
var inst_44529 = (state_44836[(18)]);
var inst_44552 = typeof inst_44529 === 'string';
var state_44836__$1 = state_44836;
if(cljs.core.truth_(inst_44552)){
var statearr_44904_45090 = state_44836__$1;
(statearr_44904_45090[(1)] = (24));

} else {
var statearr_44905_45091 = state_44836__$1;
(statearr_44905_45091[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (90))){
var inst_44711 = (state_44836[(31)]);
var inst_44716 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44906 = state_44836;
(statearr_44906[(32)] = inst_44716);

return statearr_44906;
})();
var statearr_44907_45092 = state_44836__$1;
(statearr_44907_45092[(2)] = inst_44711);

(statearr_44907_45092[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (109))){
var inst_44762 = (state_44836[(23)]);
var inst_44738 = (state_44836[(10)]);
var inst_44764 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_44738,inst_44762);
var state_44836__$1 = state_44836;
var statearr_44908_45093 = state_44836__$1;
(statearr_44908_45093[(2)] = inst_44764);

(statearr_44908_45093[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (36))){
var inst_44529 = (state_44836[(18)]);
var inst_44589 = (state_44836[(2)]);
var inst_44590 = fluree.db.util.async.throw_err(inst_44589);
var state_44836__$1 = (function (){var statearr_44909 = state_44836;
(statearr_44909[(33)] = inst_44590);

return statearr_44909;
})();
if(cljs.core.truth_(inst_44529)){
var statearr_44910_45094 = state_44836__$1;
(statearr_44910_45094[(1)] = (38));

} else {
var statearr_44911_45095 = state_44836__$1;
(statearr_44911_45095[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (41))){
var state_44836__$1 = state_44836;
var statearr_44912_45096 = state_44836__$1;
(statearr_44912_45096[(2)] = null);

(statearr_44912_45096[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (118))){
var inst_44774 = (state_44836[(34)]);
var inst_44542 = (state_44836[(7)]);
var inst_44540 = (state_44836[(8)]);
var inst_44778 = (state_44836[(35)]);
var inst_44782 = (state_44836[(2)]);
var inst_44783 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_44542,fuel,max_fuel,inst_44540,inst_44774,inst_44778,inst_44782);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(112),inst_44783);
} else {
if((state_val_44837 === (89))){
var state_44836__$1 = state_44836;
var statearr_44913_45097 = state_44836__$1;
(statearr_44913_45097[(2)] = null);

(statearr_44913_45097[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (100))){
var inst_44744 = (state_44836[(19)]);
var inst_44749 = cljs.core.int_QMARK_(inst_44744);
var state_44836__$1 = state_44836;
if(inst_44749){
var statearr_44914_45098 = state_44836__$1;
(statearr_44914_45098[(1)] = (102));

} else {
var statearr_44915_45099 = state_44836__$1;
(statearr_44915_45099[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (131))){
var inst_44814 = (state_44836[(11)]);
var inst_44828 = cljs.core.first(inst_44814);
var state_44836__$1 = state_44836;
var statearr_44916_45100 = state_44836__$1;
(statearr_44916_45100[(2)] = inst_44828);

(statearr_44916_45100[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (122))){
var inst_44575 = (state_44836[(16)]);
var inst_44530 = (state_44836[(13)]);
var inst_44532 = (state_44836[(15)]);
var inst_44576 = (state_44836[(17)]);
var inst_44809 = (state_44836[(28)]);
var inst_44811 = fluree.db.query.fql.sort_offset_and_limit_res(inst_44575,inst_44576,inst_44532,inst_44530,inst_44809);
var state_44836__$1 = state_44836;
var statearr_44917_45101 = state_44836__$1;
(statearr_44917_45101[(2)] = inst_44811);

(statearr_44917_45101[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (43))){
var inst_44594 = (state_44836[(29)]);
var inst_44590 = (state_44836[(33)]);
var inst_44542 = (state_44836[(7)]);
var inst_44540 = (state_44836[(8)]);
var inst_44598 = (state_44836[(2)]);
var inst_44599 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_44542,fuel,max_fuel,inst_44540,inst_44590,inst_44594,inst_44598);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(37),inst_44599);
} else {
if((state_val_44837 === (61))){
var inst_44649 = ["_tx",null,"_block",null];
var inst_44650 = (new cljs.core.PersistentArrayMap(null,2,inst_44649,null));
var inst_44651 = (new cljs.core.PersistentHashSet(null,inst_44650,null));
var inst_44652 = (inst_44651.cljs$core$IFn$_invoke$arity$1 ? inst_44651.cljs$core$IFn$_invoke$arity$1(from) : inst_44651.call(null,from));
var state_44836__$1 = state_44836;
var statearr_44918_45102 = state_44836__$1;
(statearr_44918_45102[(2)] = inst_44652);

(statearr_44918_45102[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (29))){
var inst_44564 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44919_45103 = state_44836__$1;
(statearr_44919_45103[(2)] = inst_44564);

(statearr_44919_45103[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (44))){
var inst_44606 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_44607 = clojure.string.includes_QMARK_(inst_44606,"/");
var state_44836__$1 = state_44836;
var statearr_44920_45104 = state_44836__$1;
(statearr_44920_45104[(2)] = inst_44607);

(statearr_44920_45104[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (93))){
var inst_44723 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
if(cljs.core.truth_(inst_44723)){
var statearr_44921_45105 = state_44836__$1;
(statearr_44921_45105[(1)] = (94));

} else {
var statearr_44922_45106 = state_44836__$1;
(statearr_44922_45106[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (6))){
var inst_44507 = (state_44836[(36)]);
var state_44836__$1 = state_44836;
var statearr_44923_45107 = state_44836__$1;
(statearr_44923_45107[(2)] = inst_44507);

(statearr_44923_45107[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (111))){
var inst_44745 = (state_44836[(37)]);
var inst_44767 = (state_44836[(2)]);
var inst_44737 = inst_44745;
var inst_44738 = inst_44767;
var state_44836__$1 = (function (){var statearr_44924 = state_44836;
(statearr_44924[(38)] = inst_44737);

(statearr_44924[(10)] = inst_44738);

return statearr_44924;
})();
var statearr_44925_45108 = state_44836__$1;
(statearr_44925_45108[(2)] = null);

(statearr_44925_45108[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (28))){
var state_44836__$1 = state_44836;
var statearr_44926_45109 = state_44836__$1;
(statearr_44926_45109[(2)] = null);

(statearr_44926_45109[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (64))){
var inst_44529 = (state_44836[(18)]);
var state_44836__$1 = state_44836;
if(cljs.core.truth_(inst_44529)){
var statearr_44927_45110 = state_44836__$1;
(statearr_44927_45110[(1)] = (67));

} else {
var statearr_44928_45111 = state_44836__$1;
(statearr_44928_45111[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (103))){
var state_44836__$1 = state_44836;
if(cljs.core.truth_(fuel)){
var statearr_44929_45112 = state_44836__$1;
(statearr_44929_45112[(1)] = (105));

} else {
var statearr_44930_45113 = state_44836__$1;
(statearr_44930_45113[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (51))){
var inst_44613 = (state_44836[(26)]);
var state_44836__$1 = state_44836;
var statearr_44931_45114 = state_44836__$1;
(statearr_44931_45114[(2)] = inst_44613);

(statearr_44931_45114[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (25))){
var state_44836__$1 = state_44836;
var statearr_44932_45115 = state_44836__$1;
(statearr_44932_45115[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (34))){
var state_44836__$1 = state_44836;
var statearr_44934_45116 = state_44836__$1;
(statearr_44934_45116[(2)] = null);

(statearr_44934_45116[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (125))){
var inst_44814 = (state_44836[(11)]);
var inst_44817 = (state_44836[(30)]);
var inst_44817__$1 = cljs.core.coll_QMARK_(inst_44814);
var state_44836__$1 = (function (){var statearr_44935 = state_44836;
(statearr_44935[(30)] = inst_44817__$1);

return statearr_44935;
})();
if(inst_44817__$1){
var statearr_44936_45117 = state_44836__$1;
(statearr_44936_45117[(1)] = (128));

} else {
var statearr_44937_45118 = state_44836__$1;
(statearr_44937_45118[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (17))){
var inst_44529 = (state_44836[(18)]);
var inst_44540 = (state_44836[(2)]);
var inst_44541 = cljs.core.PersistentHashMap.EMPTY;
var inst_44542 = cljs.core.volatile_BANG_(inst_44541);
var state_44836__$1 = (function (){var statearr_44938 = state_44836;
(statearr_44938[(7)] = inst_44542);

(statearr_44938[(8)] = inst_44540);

return statearr_44938;
})();
if(cljs.core.truth_(inst_44529)){
var statearr_44939_45119 = state_44836__$1;
(statearr_44939_45119[(1)] = (18));

} else {
var statearr_44940_45120 = state_44836__$1;
(statearr_44940_45120[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (3))){
var inst_44834 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44836__$1,inst_44834);
} else {
if((state_val_44837 === (12))){
var inst_44513 = (state_44836[(39)]);
var state_44836__$1 = state_44836;
var statearr_44941_45121 = state_44836__$1;
(statearr_44941_45121[(2)] = inst_44513);

(statearr_44941_45121[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (2))){
var inst_44507 = (state_44836[(36)]);
var _ = (function (){var statearr_44942 = state_44836;
(statearr_44942[(4)] = cljs.core.cons((5),(state_44836[(4)])));

return statearr_44942;
})();
var inst_44507__$1 = select;
var state_44836__$1 = (function (){var statearr_44943 = state_44836;
(statearr_44943[(36)] = inst_44507__$1);

return statearr_44943;
})();
if(cljs.core.truth_(inst_44507__$1)){
var statearr_44944_45122 = state_44836__$1;
(statearr_44944_45122[(1)] = (6));

} else {
var statearr_44945_45123 = state_44836__$1;
(statearr_44945_45123[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (66))){
var inst_44805 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44946_45124 = state_44836__$1;
(statearr_44946_45124[(2)] = inst_44805);

(statearr_44946_45124[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (107))){
var inst_44744 = (state_44836[(19)]);
var inst_44756 = (state_44836[(2)]);
var inst_44757 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_44744,false);
var state_44836__$1 = (function (){var statearr_44947 = state_44836;
(statearr_44947[(40)] = inst_44756);

return statearr_44947;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(108),inst_44757);
} else {
if((state_val_44837 === (23))){
var inst_44568 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44948_45125 = state_44836__$1;
(statearr_44948_45125[(2)] = inst_44568);

(statearr_44948_45125[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (47))){
var inst_44613 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_44836__$1 = (function (){var statearr_44949 = state_44836;
(statearr_44949[(26)] = inst_44613);

return statearr_44949;
})();
if(cljs.core.truth_(fuel)){
var statearr_44950_45126 = state_44836__$1;
(statearr_44950_45126[(1)] = (50));

} else {
var statearr_44951_45127 = state_44836__$1;
(statearr_44951_45127[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (35))){
var inst_44530 = (state_44836[(13)]);
var inst_44532 = (state_44836[(15)]);
var inst_44583 = (state_44836[(2)]);
var inst_44584 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_44585 = [inst_44530,inst_44532];
var inst_44586 = cljs.core.PersistentHashMap.fromArrays(inst_44584,inst_44585);
var inst_44587 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where,inst_44583,inst_44586);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(36),inst_44587);
} else {
if((state_val_44837 === (127))){
var inst_44826 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
if(cljs.core.truth_(inst_44826)){
var statearr_44952_45128 = state_44836__$1;
(statearr_44952_45128[(1)] = (131));

} else {
var statearr_44953_45129 = state_44836__$1;
(statearr_44953_45129[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (82))){
var inst_44801 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44954_45130 = state_44836__$1;
(statearr_44954_45130[(2)] = inst_44801);

(statearr_44954_45130[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (76))){
var inst_44530 = (state_44836[(13)]);
var inst_44532 = (state_44836[(15)]);
var inst_44679 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_44680 = [inst_44530,inst_44532];
var inst_44681 = cljs.core.PersistentHashMap.fromArrays(inst_44679,inst_44680);
var state_44836__$1 = state_44836;
var statearr_44955_45131 = state_44836__$1;
(statearr_44955_45131[(2)] = inst_44681);

(statearr_44955_45131[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (97))){
var inst_44744 = (state_44836[(19)]);
var inst_44737 = (state_44836[(38)]);
var inst_44743 = cljs.core.seq(inst_44737);
var inst_44744__$1 = cljs.core.first(inst_44743);
var inst_44745 = cljs.core.next(inst_44743);
var inst_44746 = cljs.core.not(inst_44744__$1);
var state_44836__$1 = (function (){var statearr_44956 = state_44836;
(statearr_44956[(19)] = inst_44744__$1);

(statearr_44956[(37)] = inst_44745);

return statearr_44956;
})();
if(inst_44746){
var statearr_44957_45132 = state_44836__$1;
(statearr_44957_45132[(1)] = (99));

} else {
var statearr_44958_45133 = state_44836__$1;
(statearr_44958_45133[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (19))){
var inst_44570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44571 = [null,null];
var inst_44572 = (new cljs.core.PersistentVector(null,2,(5),inst_44570,inst_44571,null));
var state_44836__$1 = state_44836;
var statearr_44959_45134 = state_44836__$1;
(statearr_44959_45134[(2)] = inst_44572);

(statearr_44959_45134[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (57))){
var inst_44530 = (state_44836[(13)]);
var inst_44532 = (state_44836[(15)]);
var inst_44629 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_44630 = [inst_44530,inst_44532];
var inst_44631 = cljs.core.PersistentHashMap.fromArrays(inst_44629,inst_44630);
var state_44836__$1 = state_44836;
var statearr_44960_45135 = state_44836__$1;
(statearr_44960_45135[(2)] = inst_44631);

(statearr_44960_45135[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (68))){
var inst_44530 = (state_44836[(13)]);
var inst_44532 = (state_44836[(15)]);
var inst_44660 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_44661 = [inst_44530,inst_44532];
var inst_44662 = cljs.core.PersistentHashMap.fromArrays(inst_44660,inst_44661);
var state_44836__$1 = state_44836;
var statearr_44961_45136 = state_44836__$1;
(statearr_44961_45136[(2)] = inst_44662);

(statearr_44961_45136[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (11))){
var inst_44524 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44962_45137 = state_44836__$1;
(statearr_44962_45137[(2)] = inst_44524);

(statearr_44962_45137[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (115))){
var inst_44529 = (state_44836[(18)]);
var inst_44778 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_44964 = state_44836;
(statearr_44964[(35)] = inst_44778);

return statearr_44964;
})();
if(cljs.core.truth_(inst_44529)){
var statearr_44965_45138 = state_44836__$1;
(statearr_44965_45138[(1)] = (116));

} else {
var statearr_44966_45139 = state_44836__$1;
(statearr_44966_45139[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (9))){
var inst_44510 = (state_44836[(12)]);
var state_44836__$1 = state_44836;
var statearr_44967_45140 = state_44836__$1;
(statearr_44967_45140[(2)] = inst_44510);

(statearr_44967_45140[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (5))){
var _ = (function (){var statearr_44968 = state_44836;
(statearr_44968[(4)] = cljs.core.rest((state_44836[(4)])));

return statearr_44968;
})();
var state_44836__$1 = state_44836;
var ex44963 = (state_44836__$1[(2)]);
var statearr_44969_45141 = state_44836__$1;
(statearr_44969_45141[(5)] = ex44963);


if((ex44963 instanceof Error)){
var statearr_44970_45142 = state_44836__$1;
(statearr_44970_45142[(1)] = (4));

(statearr_44970_45142[(5)] = null);

} else {
throw ex44963;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (112))){
var inst_44785 = (state_44836[(2)]);
var inst_44786 = fluree.db.util.async.throw_err(inst_44785);
var state_44836__$1 = state_44836;
var statearr_44971_45143 = state_44836__$1;
(statearr_44971_45143[(2)] = inst_44786);

(statearr_44971_45143[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (83))){
var inst_44699 = (state_44836[(20)]);
var inst_44698 = (state_44836[(2)]);
var inst_44699__$1 = fluree.db.util.async.throw_err(inst_44698);
var inst_44700 = (inst_44699__$1 == null);
var state_44836__$1 = (function (){var statearr_44972 = state_44836;
(statearr_44972[(20)] = inst_44699__$1);

return statearr_44972;
})();
if(cljs.core.truth_(inst_44700)){
var statearr_44973_45144 = state_44836__$1;
(statearr_44973_45144[(1)] = (84));

} else {
var statearr_44974_45145 = state_44836__$1;
(statearr_44974_45145[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (14))){
var inst_44522 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44975_45146 = state_44836__$1;
(statearr_44975_45146[(2)] = inst_44522);

(statearr_44975_45146[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (45))){
var inst_44604 = (state_44836[(27)]);
var state_44836__$1 = state_44836;
var statearr_44976_45147 = state_44836__$1;
(statearr_44976_45147[(2)] = inst_44604);

(statearr_44976_45147[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (53))){
var inst_44619 = (state_44836[(21)]);
var inst_44621 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_44622 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_44619,inst_44621);
var state_44836__$1 = state_44836;
var statearr_44977_45148 = state_44836__$1;
(statearr_44977_45148[(2)] = inst_44622);

(statearr_44977_45148[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (78))){
var inst_44542 = (state_44836[(7)]);
var inst_44540 = (state_44836[(8)]);
var inst_44686 = (state_44836[(2)]);
var inst_44687 = fluree.db.util.async.throw_err(inst_44686);
var inst_44688 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_44542,fuel,max_fuel,inst_44540,inst_44687);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(79),inst_44688);
} else {
if((state_val_44837 === (132))){
var inst_44814 = (state_44836[(11)]);
var state_44836__$1 = state_44836;
var statearr_44978_45149 = state_44836__$1;
(statearr_44978_45149[(2)] = inst_44814);

(statearr_44978_45149[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (26))){
var inst_44566 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_44979_45150 = state_44836__$1;
(statearr_44979_45150[(2)] = inst_44566);

(statearr_44979_45150[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (123))){
var inst_44809 = (state_44836[(28)]);
var state_44836__$1 = state_44836;
var statearr_44980_45151 = state_44836__$1;
(statearr_44980_45151[(2)] = inst_44809);

(statearr_44980_45151[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (16))){
var inst_44533 = (state_44836[(24)]);
var state_44836__$1 = state_44836;
var statearr_44981_45152 = state_44836__$1;
(statearr_44981_45152[(2)] = inst_44533);

(statearr_44981_45152[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (133))){
var inst_44831 = (state_44836[(2)]);
var _ = (function (){var statearr_44982 = state_44836;
(statearr_44982[(4)] = cljs.core.rest((state_44836[(4)])));

return statearr_44982;
})();
var state_44836__$1 = state_44836;
var statearr_44983_45153 = state_44836__$1;
(statearr_44983_45153[(2)] = inst_44831);

(statearr_44983_45153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (81))){
var inst_44718 = (state_44836[(22)]);
var inst_44718__$1 = cljs.core.sequential_QMARK_(from);
var state_44836__$1 = (function (){var statearr_44984 = state_44836;
(statearr_44984[(22)] = inst_44718__$1);

return statearr_44984;
})();
if(inst_44718__$1){
var statearr_44985_45154 = state_44836__$1;
(statearr_44985_45154[(1)] = (91));

} else {
var statearr_44986_45155 = state_44836__$1;
(statearr_44986_45155[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (120))){
var state_44836__$1 = state_44836;
var statearr_44987_45156 = state_44836__$1;
(statearr_44987_45156[(2)] = null);

(statearr_44987_45156[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (79))){
var inst_44690 = (state_44836[(2)]);
var inst_44691 = fluree.db.util.async.throw_err(inst_44690);
var state_44836__$1 = state_44836;
var statearr_44988_45157 = state_44836__$1;
(statearr_44988_45157[(2)] = inst_44691);

(statearr_44988_45157[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (38))){
var state_44836__$1 = state_44836;
var statearr_44989_45158 = state_44836__$1;
(statearr_44989_45158[(2)] = null);

(statearr_44989_45158[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (126))){
var inst_44815 = (state_44836[(41)]);
var state_44836__$1 = state_44836;
var statearr_44990_45159 = state_44836__$1;
(statearr_44990_45159[(2)] = inst_44815);

(statearr_44990_45159[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (98))){
var inst_44529 = (state_44836[(18)]);
var inst_44772 = (state_44836[(2)]);
var inst_44773 = cljs.core.PersistentVector.EMPTY;
var inst_44774 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_44773,inst_44772);
var state_44836__$1 = (function (){var statearr_44991 = state_44836;
(statearr_44991[(34)] = inst_44774);

return statearr_44991;
})();
if(cljs.core.truth_(inst_44529)){
var statearr_44992_45160 = state_44836__$1;
(statearr_44992_45160[(1)] = (113));

} else {
var statearr_44993_45161 = state_44836__$1;
(statearr_44993_45161[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (124))){
var inst_44815 = (state_44836[(41)]);
var inst_44814 = (state_44836[(2)]);
var inst_44815__$1 = selectOne;
var state_44836__$1 = (function (){var statearr_44994 = state_44836;
(statearr_44994[(41)] = inst_44815__$1);

(statearr_44994[(11)] = inst_44814);

return statearr_44994;
})();
if(cljs.core.truth_(inst_44815__$1)){
var statearr_44995_45162 = state_44836__$1;
(statearr_44995_45162[(1)] = (125));

} else {
var statearr_44996_45163 = state_44836__$1;
(statearr_44996_45163[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (87))){
var inst_44710 = (state_44836[(2)]);
var inst_44711 = fluree.db.util.async.throw_err(inst_44710);
var state_44836__$1 = (function (){var statearr_44997 = state_44836;
(statearr_44997[(31)] = inst_44711);

return statearr_44997;
})();
if(cljs.core.truth_(fuel)){
var statearr_44998_45164 = state_44836__$1;
(statearr_44998_45164[(1)] = (88));

} else {
var statearr_44999_45165 = state_44836__$1;
(statearr_44999_45165[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (30))){
var inst_44579 = typeof from === 'string';
var state_44836__$1 = state_44836;
if(cljs.core.truth_(inst_44579)){
var statearr_45000_45166 = state_44836__$1;
(statearr_45000_45166[(1)] = (33));

} else {
var statearr_45001_45167 = state_44836__$1;
(statearr_45001_45167[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (73))){
var inst_44693 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_44836__$1 = state_44836;
if(inst_44693){
var statearr_45002_45168 = state_44836__$1;
(statearr_45002_45168[(1)] = (80));

} else {
var statearr_45003_45169 = state_44836__$1;
(statearr_45003_45169[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (96))){
var inst_44799 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_45004_45170 = state_44836__$1;
(statearr_45004_45170[(2)] = inst_44799);

(statearr_45004_45170[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (10))){
var inst_44513 = (state_44836[(39)]);
var inst_44513__$1 = selectDistinct;
var state_44836__$1 = (function (){var statearr_45005 = state_44836;
(statearr_45005[(39)] = inst_44513__$1);

return statearr_45005;
})();
if(cljs.core.truth_(inst_44513__$1)){
var statearr_45006_45171 = state_44836__$1;
(statearr_45006_45171[(1)] = (12));

} else {
var statearr_45007_45172 = state_44836__$1;
(statearr_45007_45172[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (18))){
var inst_44529 = (state_44836[(18)]);
var inst_44544 = cljs.core.vector_QMARK_(inst_44529);
var state_44836__$1 = state_44836;
if(inst_44544){
var statearr_45008_45173 = state_44836__$1;
(statearr_45008_45173[(1)] = (21));

} else {
var statearr_45009_45174 = state_44836__$1;
(statearr_45009_45174[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (105))){
var inst_44753 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_44836__$1 = state_44836;
var statearr_45010_45175 = state_44836__$1;
(statearr_45010_45175[(2)] = inst_44753);

(statearr_45010_45175[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (52))){
var inst_44619 = (state_44836[(2)]);
var state_44836__$1 = (function (){var statearr_45011 = state_44836;
(statearr_45011[(21)] = inst_44619);

return statearr_45011;
})();
var statearr_45012_45176 = state_44836__$1;
(statearr_45012_45176[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (114))){
var inst_44530 = (state_44836[(13)]);
var state_44836__$1 = state_44836;
var statearr_45014_45177 = state_44836__$1;
(statearr_45014_45177[(2)] = inst_44530);

(statearr_45014_45177[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (67))){
var inst_44658 = cljs.core.PersistentHashMap.EMPTY;
var state_44836__$1 = state_44836;
var statearr_45015_45178 = state_44836__$1;
(statearr_45015_45178[(2)] = inst_44658);

(statearr_45015_45178[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (71))){
var inst_44671 = (state_44836[(2)]);
var inst_44672 = fluree.db.util.async.throw_err(inst_44671);
var state_44836__$1 = state_44836;
var statearr_45016_45179 = state_44836__$1;
(statearr_45016_45179[(2)] = inst_44672);

(statearr_45016_45179[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (42))){
var inst_44532 = (state_44836[(15)]);
var state_44836__$1 = state_44836;
var statearr_45017_45180 = state_44836__$1;
(statearr_45017_45180[(2)] = inst_44532);

(statearr_45017_45180[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (80))){
var inst_44696 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_44836__$1 = state_44836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44836__$1,(83),inst_44696);
} else {
if((state_val_44837 === (37))){
var inst_44601 = (state_44836[(2)]);
var inst_44602 = fluree.db.util.async.throw_err(inst_44601);
var state_44836__$1 = state_44836;
var statearr_45018_45181 = state_44836__$1;
(statearr_45018_45181[(2)] = inst_44602);

(statearr_45018_45181[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (63))){
var inst_44655 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
if(cljs.core.truth_(inst_44655)){
var statearr_45019_45182 = state_44836__$1;
(statearr_45019_45182[(1)] = (64));

} else {
var statearr_45020_45183 = state_44836__$1;
(statearr_45020_45183[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (94))){
var inst_44732 = from;
var inst_44733 = cljs.core.seq(inst_44732);
var inst_44734 = cljs.core.first(inst_44733);
var inst_44735 = cljs.core.next(inst_44733);
var inst_44736 = cljs.core.PersistentVector.EMPTY;
var inst_44737 = inst_44732;
var inst_44738 = inst_44736;
var state_44836__$1 = (function (){var statearr_45021 = state_44836;
(statearr_45021[(38)] = inst_44737);

(statearr_45021[(42)] = inst_44735);

(statearr_45021[(10)] = inst_44738);

(statearr_45021[(43)] = inst_44734);

return statearr_45021;
})();
var statearr_45022_45184 = state_44836__$1;
(statearr_45022_45184[(2)] = null);

(statearr_45022_45184[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (8))){
var inst_44531 = (state_44836[(25)]);
var inst_44526 = (state_44836[(2)]);
var inst_44527 = opts_SINGLEQUOTE_;
var inst_44528 = cljs.core.__destructure_map(inst_44527);
var inst_44529 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44528,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_44530 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44528,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_44531__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44528,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_44532 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44528,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_44533 = fluree.db.query.fql_parser.parse_db(db,inst_44526,opts_SINGLEQUOTE_);
var inst_44534 = (inst_44531__$1 == null);
var inst_44535 = cljs.core.not(inst_44534);
var state_44836__$1 = (function (){var statearr_45023 = state_44836;
(statearr_45023[(13)] = inst_44530);

(statearr_45023[(18)] = inst_44529);

(statearr_45023[(15)] = inst_44532);

(statearr_45023[(24)] = inst_44533);

(statearr_45023[(25)] = inst_44531__$1);

return statearr_45023;
})();
if(inst_44535){
var statearr_45024_45185 = state_44836__$1;
(statearr_45024_45185[(1)] = (15));

} else {
var statearr_45025_45186 = state_44836__$1;
(statearr_45025_45186[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (49))){
var inst_44807 = (state_44836[(2)]);
var state_44836__$1 = state_44836;
var statearr_45026_45187 = state_44836__$1;
(statearr_45026_45187[(2)] = inst_44807);

(statearr_45026_45187[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44837 === (84))){
var state_44836__$1 = state_44836;
var statearr_45027_45188 = state_44836__$1;
(statearr_45027_45188[(2)] = null);

(statearr_45027_45188[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__17178__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__17178__auto____0 = (function (){
var statearr_45028 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45028[(0)] = fluree$db$query$fql$query_$_state_machine__17178__auto__);

(statearr_45028[(1)] = (1));

return statearr_45028;
});
var fluree$db$query$fql$query_$_state_machine__17178__auto____1 = (function (state_44836){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_44836);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e45029){var ex__17181__auto__ = e45029;
var statearr_45030_45189 = state_44836;
(statearr_45030_45189[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_44836[(4)]))){
var statearr_45031_45190 = state_44836;
(statearr_45031_45190[(1)] = cljs.core.first((state_44836[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45191 = state_44836;
state_44836 = G__45191;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__17178__auto__ = function(state_44836){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__17178__auto____1.call(this,state_44836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__17178__auto____0;
fluree$db$query$fql$query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__17178__auto____1;
return fluree$db$query$fql$query_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_45032 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_45032[(6)] = c__17304__auto__);

return statearr_45032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}

});
