// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38577_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__38577_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__38581 = coll;
var vec__38582 = G__38581;
var seq__38583 = cljs.core.seq(vec__38582);
var first__38584 = cljs.core.first(seq__38583);
var seq__38583__$1 = cljs.core.next(seq__38583);
var clause = first__38584;
var r = seq__38583__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__38581__$1 = G__38581;
var res__$1 = res;
while(true){
var vec__38588 = G__38581__$1;
var seq__38589 = cljs.core.seq(vec__38588);
var first__38590 = cljs.core.first(seq__38589);
var seq__38589__$1 = cljs.core.next(seq__38589);
var clause__$1 = first__38590;
var r__$1 = seq__38589__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__38591 = r__$1;
var G__38592 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__38581__$1 = G__38591;
res__$1 = G__38592;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__38593){
var map__38594 = p__38593;
var map__38594__$1 = cljs.core.__destructure_map(map__38594);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38594__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__38598 = coll;
var vec__38599 = G__38598;
var seq__38600 = cljs.core.seq(vec__38599);
var first__38601 = cljs.core.first(seq__38600);
var seq__38600__$1 = cljs.core.next(seq__38600);
var clause = first__38601;
var r = seq__38600__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__38598__$1 = G__38598;
var res__$1 = res;
while(true){
var vec__38605 = G__38598__$1;
var seq__38606 = cljs.core.seq(vec__38605);
var first__38607 = cljs.core.first(seq__38606);
var seq__38606__$1 = cljs.core.next(seq__38606);
var clause__$1 = first__38607;
var r__$1 = seq__38606__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__38608 = r__$1;
var G__38609 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__38598__$1 = G__38608;
res__$1 = G__38609;
continue;
} else {
var G__38610 = r__$1;
var G__38611 = res__$2;
G__38598__$1 = G__38610;
res__$1 = G__38611;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__38615 = coll;
var vec__38616 = G__38615;
var seq__38617 = cljs.core.seq(vec__38616);
var first__38618 = cljs.core.first(seq__38617);
var seq__38617__$1 = cljs.core.next(seq__38617);
var clause = first__38618;
var r = seq__38617__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__38615__$1 = G__38615;
var res__$1 = res;
while(true){
var vec__38622 = G__38615__$1;
var seq__38623 = cljs.core.seq(vec__38622);
var first__38624 = cljs.core.first(seq__38623);
var seq__38623__$1 = cljs.core.next(seq__38623);
var clause__$1 = first__38624;
var r__$1 = seq__38623__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__38625 = r__$1;
var G__38626 = res__$2;
G__38615__$1 = G__38625;
res__$1 = G__38626;
continue;
} else {
var G__38627 = r__$1;
var G__38628 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__38615__$1 = G__38627;
res__$1 = G__38628;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__38631 = clause;
var G__38631__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__38631):G__38631);
var G__38631__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__38631__$1)
;
var G__38631__$3 = (function (){var fexpr__38632 = (function (p1__38629_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__38629_SHARP_)," ."].join('');
});
return fexpr__38632(G__38631__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__38633 = (function (p1__38630_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__38630_SHARP_),"}"].join('');
});
return fexpr__38633(G__38631__$3);
} else {
return G__38631__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__38637 = opts;
var map__38637__$1 = cljs.core.__destructure_map(map__38637);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38637__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38637__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38637__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38637__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38637__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38634_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__38634_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__38635_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__38635_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__38636_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__38636_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4212__auto__ = language;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_38651){
var state_val_38652 = (state_38651[(1)]);
if((state_val_38652 === (1))){
var inst_38638 = fluree.db.util.core.url_encode(query);
var inst_38639 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38638)].join('');
var inst_38640 = ["User-Agent","Accept"];
var inst_38641 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_38642 = cljs.core.PersistentHashMap.fromArrays(inst_38640,inst_38641);
var inst_38643 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_38644 = [inst_38642,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_38645 = cljs.core.PersistentHashMap.fromArrays(inst_38643,inst_38644);
var inst_38646 = fluree.db.util.xhttp.get(inst_38639,inst_38645);
var state_38651__$1 = state_38651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38651__$1,(2),inst_38646);
} else {
if((state_val_38652 === (2))){
var inst_38648 = (state_38651[(2)]);
var inst_38649 = fluree.db.util.async.throw_err(inst_38648);
var state_38651__$1 = state_38651;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38651__$1,inst_38649);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17178__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17178__auto____0 = (function (){
var statearr_38653 = [null,null,null,null,null,null,null];
(statearr_38653[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17178__auto__);

(statearr_38653[(1)] = (1));

return statearr_38653;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17178__auto____1 = (function (state_38651){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_38651);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e38654){var ex__17181__auto__ = e38654;
var statearr_38655_38658 = state_38651;
(statearr_38655_38658[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_38651[(4)]))){
var statearr_38656_38659 = state_38651;
(statearr_38656_38659[(1)] = cljs.core.first((state_38651[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38660 = state_38651;
state_38651 = G__38660;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17178__auto__ = function(state_38651){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17178__auto____1.call(this,state_38651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17178__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17178__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_38657 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_38657[(6)] = c__17304__auto__);

return statearr_38657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_38678){
var state_val_38679 = (state_38678[(1)]);
if((state_val_38679 === (1))){
var inst_38661 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_38678__$1 = state_38678;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38678__$1,(2),inst_38661);
} else {
if((state_val_38679 === (2))){
var inst_38664 = (state_38678[(7)]);
var inst_38663 = (state_38678[(2)]);
var inst_38664__$1 = fluree.db.util.async.throw_err(inst_38663);
var inst_38665 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_38664__$1);
var inst_38666 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_38665);
var state_38678__$1 = (function (){var statearr_38680 = state_38678;
(statearr_38680[(7)] = inst_38664__$1);

return statearr_38680;
})();
if(inst_38666){
var statearr_38681_38690 = state_38678__$1;
(statearr_38681_38690[(1)] = (3));

} else {
var statearr_38682_38691 = state_38678__$1;
(statearr_38682_38691[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38679 === (3))){
var inst_38664 = (state_38678[(7)]);
var state_38678__$1 = state_38678;
var statearr_38683_38692 = state_38678__$1;
(statearr_38683_38692[(2)] = inst_38664);

(statearr_38683_38692[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38679 === (4))){
var inst_38664 = (state_38678[(7)]);
var inst_38669 = (function (){var body = inst_38664;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_38670 = cljs.core.second(inst_38664);
var inst_38671 = cljs.core.second(inst_38670);
var inst_38672 = cljs.core.first(inst_38671);
var inst_38673 = cljs.core.second(inst_38672);
var inst_38674 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_38669,inst_38673);
var state_38678__$1 = state_38678;
var statearr_38684_38693 = state_38678__$1;
(statearr_38684_38693[(2)] = inst_38674);

(statearr_38684_38693[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38679 === (5))){
var inst_38676 = (state_38678[(2)]);
var state_38678__$1 = state_38678;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38678__$1,inst_38676);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17178__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17178__auto____0 = (function (){
var statearr_38685 = [null,null,null,null,null,null,null,null];
(statearr_38685[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17178__auto__);

(statearr_38685[(1)] = (1));

return statearr_38685;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17178__auto____1 = (function (state_38678){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_38678);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e38686){var ex__17181__auto__ = e38686;
var statearr_38687_38694 = state_38678;
(statearr_38687_38694[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_38678[(4)]))){
var statearr_38688_38695 = state_38678;
(statearr_38688_38695[(1)] = cljs.core.first((state_38678[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38696 = state_38678;
state_38678 = G__38696;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17178__auto__ = function(state_38678){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17178__auto____1.call(this,state_38678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17178__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17178__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_38689 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_38689[(6)] = c__17304__auto__);

return statearr_38689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38697_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__38697_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38698_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__38698_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38699_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__38699_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__38699_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__38699_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_38745){
var state_val_38746 = (state_38745[(1)]);
if((state_val_38746 === (7))){
var inst_38710 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_38745__$1 = state_38745;
var statearr_38747_38775 = state_38745__$1;
(statearr_38747_38775[(2)] = inst_38710);

(statearr_38747_38775[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (1))){
var state_38745__$1 = state_38745;
var statearr_38748_38776 = state_38745__$1;
(statearr_38748_38776[(2)] = null);

(statearr_38748_38776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (4))){
var inst_38700 = (state_38745[(2)]);
var state_38745__$1 = state_38745;
var statearr_38749_38777 = state_38745__$1;
(statearr_38749_38777[(2)] = inst_38700);

(statearr_38749_38777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (15))){
var inst_38719 = (state_38745[(7)]);
var inst_38724 = (state_38745[(8)]);
var inst_38718 = (state_38745[(9)]);
var inst_38729 = (state_38745[(2)]);
var inst_38730 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_38724,(0),inst_38729);
var inst_38731 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38732 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_38718);
var inst_38733 = [inst_38719,inst_38732];
var inst_38734 = cljs.core.PersistentHashMap.fromArrays(inst_38731,inst_38733);
var inst_38735 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38730,inst_38734);
var inst_38736 = (function(){throw inst_38735})();
var state_38745__$1 = state_38745;
var statearr_38750_38778 = state_38745__$1;
(statearr_38750_38778[(2)] = inst_38736);

(statearr_38750_38778[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (13))){
var inst_38723 = (state_38745[(10)]);
var state_38745__$1 = state_38745;
var statearr_38751_38779 = state_38745__$1;
(statearr_38751_38779[(2)] = inst_38723);

(statearr_38751_38779[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (6))){
var state_38745__$1 = state_38745;
var statearr_38752_38780 = state_38745__$1;
(statearr_38752_38780[(2)] = null);

(statearr_38752_38780[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (3))){
var inst_38743 = (state_38745[(2)]);
var state_38745__$1 = state_38745;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38745__$1,inst_38743);
} else {
if((state_val_38746 === (12))){
var inst_38740 = (state_38745[(2)]);
var _ = (function (){var statearr_38753 = state_38745;
(statearr_38753[(4)] = cljs.core.rest((state_38745[(4)])));

return statearr_38753;
})();
var state_38745__$1 = state_38745;
var statearr_38754_38781 = state_38745__$1;
(statearr_38754_38781[(2)] = inst_38740);

(statearr_38754_38781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (2))){
var _ = (function (){var statearr_38755 = state_38745;
(statearr_38755[(4)] = cljs.core.cons((5),(state_38745[(4)])));

return statearr_38755;
})();
var inst_38707 = cljs.core.empty_QMARK_(matching_vars);
var state_38745__$1 = state_38745;
if(inst_38707){
var statearr_38756_38782 = state_38745__$1;
(statearr_38756_38782[(1)] = (6));

} else {
var statearr_38757_38783 = state_38745__$1;
(statearr_38757_38783[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (11))){
var inst_38718 = (state_38745[(9)]);
var inst_38738 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_38718,all_vars);
var state_38745__$1 = state_38745;
var statearr_38759_38784 = state_38745__$1;
(statearr_38759_38784[(2)] = inst_38738);

(statearr_38759_38784[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (9))){
var inst_38719 = (state_38745[(7)]);
var inst_38718 = (state_38745[(9)]);
var inst_38716 = (state_38745[(2)]);
var inst_38717 = fluree.db.util.async.throw_err(inst_38716);
var inst_38718__$1 = cljs.core.__destructure_map(inst_38717);
var inst_38719__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38718__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_38720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38718__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_38721 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_38719__$1);
var state_38745__$1 = (function (){var statearr_38760 = state_38745;
(statearr_38760[(7)] = inst_38719__$1);

(statearr_38760[(9)] = inst_38718__$1);

(statearr_38760[(11)] = inst_38720);

return statearr_38760;
})();
if(inst_38721){
var statearr_38761_38785 = state_38745__$1;
(statearr_38761_38785[(1)] = (10));

} else {
var statearr_38762_38786 = state_38745__$1;
(statearr_38762_38786[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (5))){
var _ = (function (){var statearr_38763 = state_38745;
(statearr_38763[(4)] = cljs.core.rest((state_38745[(4)])));

return statearr_38763;
})();
var state_38745__$1 = state_38745;
var ex38758 = (state_38745__$1[(2)]);
var statearr_38764_38787 = state_38745__$1;
(statearr_38764_38787[(5)] = ex38758);


if((ex38758 instanceof Error)){
var statearr_38765_38788 = state_38745__$1;
(statearr_38765_38788[(1)] = (4));

(statearr_38765_38788[(5)] = null);

} else {
throw ex38758;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (14))){
var state_38745__$1 = state_38745;
var statearr_38766_38789 = state_38745__$1;
(statearr_38766_38789[(2)] = (1000));

(statearr_38766_38789[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (10))){
var inst_38718 = (state_38745[(9)]);
var inst_38720 = (state_38745[(11)]);
var inst_38723 = (state_38745[(10)]);
var inst_38723__$1 = cljs.core.count(inst_38720);
var inst_38724 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_38718);
var inst_38725 = (inst_38723__$1 < (1000));
var state_38745__$1 = (function (){var statearr_38767 = state_38745;
(statearr_38767[(8)] = inst_38724);

(statearr_38767[(10)] = inst_38723__$1);

return statearr_38767;
})();
if(cljs.core.truth_(inst_38725)){
var statearr_38768_38790 = state_38745__$1;
(statearr_38768_38790[(1)] = (13));

} else {
var statearr_38769_38791 = state_38745__$1;
(statearr_38769_38791[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38746 === (8))){
var inst_38712 = (state_38745[(2)]);
var inst_38713 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_38712,optional_clauses);
var inst_38714 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_38713);
var state_38745__$1 = state_38745;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38745__$1,(9),inst_38714);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17178__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17178__auto____0 = (function (){
var statearr_38770 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38770[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17178__auto__);

(statearr_38770[(1)] = (1));

return statearr_38770;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17178__auto____1 = (function (state_38745){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_38745);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e38771){var ex__17181__auto__ = e38771;
var statearr_38772_38792 = state_38745;
(statearr_38772_38792[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_38745[(4)]))){
var statearr_38773_38793 = state_38745;
(statearr_38773_38793[(1)] = cljs.core.first((state_38745[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38794 = state_38745;
state_38745 = G__38794;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17178__auto__ = function(state_38745){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17178__auto____1.call(this,state_38745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17178__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17178__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_38774 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_38774[(6)] = c__17304__auto__);

return statearr_38774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
