// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__45194 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45194,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45194,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45194,(2),null);
if(cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__45197){
var map__45198 = p__45197;
var map__45198__$1 = cljs.core.__destructure_map(map__45198);
var opts = map__45198__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45198__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_45258){
var state_val_45259 = (state_45258[(1)]);
if((state_val_45259 === (7))){
var inst_45229 = cljs.core.not(reindex_QMARK_);
var state_45258__$1 = state_45258;
var statearr_45260_45284 = state_45258__$1;
(statearr_45260_45284[(2)] = inst_45229);

(statearr_45260_45284[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45259 === (1))){
var state_45258__$1 = state_45258;
var statearr_45261_45285 = state_45258__$1;
(statearr_45261_45285[(2)] = null);

(statearr_45261_45285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45259 === (4))){
var inst_45199 = (state_45258[(2)]);
var state_45258__$1 = state_45258;
var statearr_45262_45286 = state_45258__$1;
(statearr_45262_45286[(2)] = inst_45199);

(statearr_45262_45286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45259 === (6))){
var inst_45227 = (state_45258[(7)]);
var inst_45219 = (state_45258[(8)]);
var inst_45213 = (state_45258[(9)]);
var inst_45212 = (state_45258[(2)]);
var inst_45213__$1 = fluree.db.util.async.throw_err(inst_45212);
var inst_45214 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_45215 = cljs.core.__destructure_map(inst_45214);
var inst_45216 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45215,new cljs.core.Keyword(null,"post","post",269697687));
var inst_45217 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45215,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_45218 = fluree.db.flake.size_bytes(inst_45213__$1);
var inst_45219__$1 = (inst_45217 + inst_45218);
var inst_45220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45221 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_45222 = (new cljs.core.PersistentVector(null,2,(5),inst_45220,inst_45221,null));
var inst_45223 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_45222);
var inst_45224 = cljs.core.__destructure_map(inst_45223);
var inst_45225 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45224,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_45226 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45224,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_45227__$1 = (inst_45219__$1 > inst_45226);
var state_45258__$1 = (function (){var statearr_45263 = state_45258;
(statearr_45263[(10)] = inst_45225);

(statearr_45263[(7)] = inst_45227__$1);

(statearr_45263[(8)] = inst_45219__$1);

(statearr_45263[(9)] = inst_45213__$1);

(statearr_45263[(11)] = inst_45216);

return statearr_45263;
})();
if(cljs.core.truth_(inst_45227__$1)){
var statearr_45264_45287 = state_45258__$1;
(statearr_45264_45287[(1)] = (7));

} else {
var statearr_45265_45288 = state_45258__$1;
(statearr_45265_45288[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45259 === (3))){
var inst_45256 = (state_45258[(2)]);
var state_45258__$1 = state_45258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45258__$1,inst_45256);
} else {
if((state_val_45259 === (12))){
var inst_45219 = (state_45258[(8)]);
var inst_45213 = (state_45258[(9)]);
var inst_45216 = (state_45258[(11)]);
var inst_45242 = (state_45258[(2)]);
var inst_45243 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_45216,inst_45213);
var inst_45244 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_45245 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_45244,cljs.core.empty);
var inst_45246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45247 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_45248 = (new cljs.core.PersistentVector(null,2,(5),inst_45246,inst_45247,null));
var inst_45249 = cljs.core.assoc_in(db,inst_45248,inst_45243);
var inst_45250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45251 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_45252 = (new cljs.core.PersistentVector(null,2,(5),inst_45250,inst_45251,null));
var inst_45253 = cljs.core.assoc_in(inst_45249,inst_45252,inst_45219);
var _ = (function (){var statearr_45266 = state_45258;
(statearr_45266[(4)] = cljs.core.rest((state_45258[(4)])));

return statearr_45266;
})();
var state_45258__$1 = (function (){var statearr_45267 = state_45258;
(statearr_45267[(12)] = inst_45242);

(statearr_45267[(13)] = inst_45245);

return statearr_45267;
})();
var statearr_45268_45289 = state_45258__$1;
(statearr_45268_45289[(2)] = inst_45253);

(statearr_45268_45289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45259 === (2))){
var _ = (function (){var statearr_45269 = state_45258;
(statearr_45269[(4)] = cljs.core.cons((5),(state_45258[(4)])));

return statearr_45269;
})();
var inst_45207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45208 = [pred_id];
var inst_45209 = (new cljs.core.PersistentVector(null,1,(5),inst_45207,inst_45208,null));
var inst_45210 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_45209);
var state_45258__$1 = state_45258;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45258__$1,(6),inst_45210);
} else {
if((state_val_45259 === (11))){
var state_45258__$1 = state_45258;
var statearr_45271_45290 = state_45258__$1;
(statearr_45271_45290[(2)] = null);

(statearr_45271_45290[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45259 === (9))){
var inst_45232 = (state_45258[(2)]);
var state_45258__$1 = state_45258;
if(cljs.core.truth_(inst_45232)){
var statearr_45272_45291 = state_45258__$1;
(statearr_45272_45291[(1)] = (10));

} else {
var statearr_45273_45292 = state_45258__$1;
(statearr_45273_45292[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45259 === (5))){
var _ = (function (){var statearr_45274 = state_45258;
(statearr_45274[(4)] = cljs.core.rest((state_45258[(4)])));

return statearr_45274;
})();
var state_45258__$1 = state_45258;
var ex45270 = (state_45258__$1[(2)]);
var statearr_45275_45293 = state_45258__$1;
(statearr_45275_45293[(5)] = ex45270);


if((ex45270 instanceof Error)){
var statearr_45276_45294 = state_45258__$1;
(statearr_45276_45294[(1)] = (4));

(statearr_45276_45294[(5)] = null);

} else {
throw ex45270;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45259 === (10))){
var inst_45234 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_45235 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_45236 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_45237 = cljs.core.PersistentHashMap.fromArrays(inst_45235,inst_45236);
var inst_45238 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45234,inst_45237);
var inst_45239 = (function(){throw inst_45238})();
var state_45258__$1 = state_45258;
var statearr_45277_45295 = state_45258__$1;
(statearr_45277_45295[(2)] = inst_45239);

(statearr_45277_45295[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45259 === (8))){
var inst_45227 = (state_45258[(7)]);
var state_45258__$1 = state_45258;
var statearr_45278_45296 = state_45258__$1;
(statearr_45278_45296[(2)] = inst_45227);

(statearr_45278_45296[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__17178__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__17178__auto____0 = (function (){
var statearr_45279 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45279[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__17178__auto__);

(statearr_45279[(1)] = (1));

return statearr_45279;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__17178__auto____1 = (function (state_45258){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_45258);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e45280){var ex__17181__auto__ = e45280;
var statearr_45281_45297 = state_45258;
(statearr_45281_45297[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_45258[(4)]))){
var statearr_45282_45298 = state_45258;
(statearr_45282_45298[(1)] = cljs.core.first((state_45258[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45299 = state_45258;
state_45258 = G__45299;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__17178__auto__ = function(state_45258){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__17178__auto____1.call(this,state_45258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__17178__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__17178__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_45283 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_45283[(6)] = c__17304__auto__);

return statearr_45283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__45304 = arguments.length;
switch (G__45304) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_45500){
var state_val_45501 = (state_45500[(1)]);
if((state_val_45501 === (7))){
var state_45500__$1 = state_45500;
var statearr_45502_45570 = state_45500__$1;
(statearr_45502_45570[(2)] = null);

(statearr_45502_45570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (20))){
var inst_45393 = (state_45500[(7)]);
var inst_45425 = (state_45500[(8)]);
var inst_45342 = (state_45500[(9)]);
var inst_45423 = (state_45500[(10)]);
var inst_45426 = (state_45500[(11)]);
var inst_45424 = (state_45500[(12)]);
var inst_45343 = (state_45500[(13)]);
var inst_45422 = (state_45500[(14)]);
var inst_45436 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_45437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45438 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_45439 = (new cljs.core.PersistentVector(null,2,(5),inst_45437,inst_45438,null));
var inst_45440 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_45393,inst_45439);
var inst_45441 = (inst_45342 + inst_45440);
var inst_45442 = [inst_45422,inst_45423,inst_45424,inst_45425,inst_45441];
var inst_45443 = cljs.core.PersistentHashMap.fromArrays(inst_45436,inst_45442);
var inst_45444 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_45393,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_45426,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_45443], 0));
var state_45500__$1 = (function (){var statearr_45503 = state_45500;
(statearr_45503[(15)] = inst_45444);

return statearr_45503;
})();
if(cljs.core.truth_(inst_45343)){
var statearr_45504_45571 = state_45500__$1;
(statearr_45504_45571[(1)] = (23));

} else {
var statearr_45505_45572 = state_45500__$1;
(statearr_45505_45572[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (27))){
var inst_45444 = (state_45500[(15)]);
var state_45500__$1 = state_45500;
var statearr_45506_45573 = state_45500__$1;
(statearr_45506_45573[(2)] = inst_45444);

(statearr_45506_45573[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (1))){
var state_45500__$1 = state_45500;
var statearr_45507_45574 = state_45500__$1;
(statearr_45507_45574[(2)] = null);

(statearr_45507_45574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (24))){
var inst_45444 = (state_45500[(15)]);
var inst_45447 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_45444);
var inst_45448 = (inst_45447 == null);
var state_45500__$1 = state_45500;
var statearr_45508_45575 = state_45500__$1;
(statearr_45508_45575[(2)] = inst_45448);

(statearr_45508_45575[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (39))){
var inst_45475 = (state_45500[(16)]);
var inst_45474 = (state_45500[(17)]);
var inst_45433 = (state_45500[(18)]);
var inst_45476 = (state_45500[(19)]);
var inst_45483 = (state_45500[(20)]);
var inst_45490 = (state_45500[(2)]);
var inst_45421 = inst_45433;
var inst_45422 = inst_45475;
var inst_45423 = inst_45476;
var inst_45424 = inst_45483;
var inst_45425 = inst_45490;
var inst_45426 = inst_45474;
var state_45500__$1 = (function (){var statearr_45509 = state_45500;
(statearr_45509[(8)] = inst_45425);

(statearr_45509[(10)] = inst_45423);

(statearr_45509[(11)] = inst_45426);

(statearr_45509[(21)] = inst_45421);

(statearr_45509[(12)] = inst_45424);

(statearr_45509[(14)] = inst_45422);

return statearr_45509;
})();
var statearr_45510_45576 = state_45500__$1;
(statearr_45510_45576[(2)] = null);

(statearr_45510_45576[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (4))){
var inst_45305 = (state_45500[(2)]);
var state_45500__$1 = state_45500;
var statearr_45511_45577 = state_45500__$1;
(statearr_45511_45577[(2)] = inst_45305);

(statearr_45511_45577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (15))){
var inst_45365 = (state_45500[(22)]);
var state_45500__$1 = state_45500;
var statearr_45512_45578 = state_45500__$1;
(statearr_45512_45578[(2)] = inst_45365);

(statearr_45512_45578[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (21))){
var inst_45393 = (state_45500[(7)]);
var inst_45337 = (state_45500[(23)]);
var inst_45403 = (state_45500[(24)]);
var inst_45432 = (state_45500[(25)]);
var inst_45425 = (state_45500[(8)]);
var inst_45433 = (state_45500[(18)]);
var inst_45342 = (state_45500[(9)]);
var inst_45352 = (state_45500[(26)]);
var inst_45327 = (state_45500[(27)]);
var inst_45329 = (state_45500[(28)]);
var inst_45341 = (state_45500[(29)]);
var inst_45312 = (state_45500[(30)]);
var inst_45423 = (state_45500[(10)]);
var inst_45426 = (state_45500[(11)]);
var inst_45402 = (state_45500[(31)]);
var inst_45421 = (state_45500[(21)]);
var inst_45344 = (state_45500[(32)]);
var inst_45424 = (state_45500[(12)]);
var inst_45333 = (state_45500[(33)]);
var inst_45343 = (state_45500[(13)]);
var inst_45346 = (state_45500[(34)]);
var inst_45422 = (state_45500[(14)]);
var inst_45471 = inst_45432.s;
var inst_45472 = fluree.db.flake.sid__GT_cid(inst_45471);
var inst_45473 = (function (){var flakes_bytes = inst_45342;
var t = inst_45312;
var spot = inst_45422;
var add_flakes = inst_45329;
var root_setting_change_QMARK_ = inst_45344;
var seq__45399 = inst_45403;
var ref_QMARK__map = inst_45341;
var r = inst_45433;
var psot = inst_45423;
var vec__45428 = inst_45421;
var add_pred_to_idx_QMARK_ = inst_45352;
var vec__45398 = inst_45329;
var _ = inst_45327;
var first__45400 = inst_45402;
var cid = inst_45472;
var ecount = inst_45426;
var pred_ecount = inst_45346;
var db_STAR_ = inst_45393;
var schema_change_QMARK_ = inst_45343;
var first__45430 = inst_45432;
var add_preds = inst_45333;
var opst = inst_45425;
var idx_QMARK__map = inst_45337;
var seq__45429 = inst_45433;
var post = inst_45424;
var G__45397 = inst_45421;
var f = inst_45432;
return (function (p1__45302_SHARP_){
if(cljs.core.truth_(p1__45302_SHARP_)){
var x__4295__auto__ = p1__45302_SHARP_;
var y__4296__auto__ = f.s;
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
} else {
return f.s;
}
});
})();
var inst_45474 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_45426,inst_45472,inst_45473);
var inst_45475 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_45422,inst_45432);
var inst_45476 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_45423,inst_45432);
var inst_45477 = inst_45432.p;
var inst_45478 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45337,inst_45477);
var state_45500__$1 = (function (){var statearr_45513 = state_45500;
(statearr_45513[(16)] = inst_45475);

(statearr_45513[(17)] = inst_45474);

(statearr_45513[(19)] = inst_45476);

return statearr_45513;
})();
if(cljs.core.truth_(inst_45478)){
var statearr_45514_45579 = state_45500__$1;
(statearr_45514_45579[(1)] = (34));

} else {
var statearr_45515_45580 = state_45500__$1;
(statearr_45515_45580[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (31))){
var inst_45459 = (state_45500[(35)]);
var state_45500__$1 = state_45500;
var statearr_45516_45581 = state_45500__$1;
(statearr_45516_45581[(2)] = inst_45459);

(statearr_45516_45581[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (32))){
var inst_45469 = (state_45500[(2)]);
var state_45500__$1 = state_45500;
var statearr_45517_45582 = state_45500__$1;
(statearr_45517_45582[(2)] = inst_45469);

(statearr_45517_45582[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (33))){
var inst_45459 = (state_45500[(35)]);
var inst_45464 = (state_45500[(2)]);
var inst_45465 = fluree.db.util.async.throw_err(inst_45464);
var inst_45466 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_45459,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_45465);
var state_45500__$1 = state_45500;
var statearr_45518_45583 = state_45500__$1;
(statearr_45518_45583[(2)] = inst_45466);

(statearr_45518_45583[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (13))){
var inst_45393 = (state_45500[(7)]);
var inst_45342 = (state_45500[(9)]);
var inst_45329 = (state_45500[(28)]);
var inst_45312 = (state_45500[(30)]);
var inst_45383 = (state_45500[(2)]);
var inst_45384 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_45383,new cljs.core.Keyword(null,"t","t",-1397832519),inst_45312);
var inst_45385 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45386 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_45387 = (new cljs.core.PersistentVector(null,2,(5),inst_45385,inst_45386,null));
var inst_45388 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_45384,inst_45387,cljs.core._PLUS_,inst_45342);
var inst_45389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45390 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_45391 = (new cljs.core.PersistentVector(null,2,(5),inst_45389,inst_45390,null));
var inst_45392 = cljs.core.count(inst_45329);
var inst_45393__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_45388,inst_45391,cljs.core._PLUS_,inst_45392);
var inst_45401 = cljs.core.seq(inst_45329);
var inst_45402 = cljs.core.first(inst_45401);
var inst_45403 = cljs.core.next(inst_45401);
var inst_45404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45405 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_45406 = (new cljs.core.PersistentVector(null,2,(5),inst_45404,inst_45405,null));
var inst_45407 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_45393__$1,inst_45406);
var inst_45408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45409 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_45410 = (new cljs.core.PersistentVector(null,2,(5),inst_45408,inst_45409,null));
var inst_45411 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_45393__$1,inst_45410);
var inst_45412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45413 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_45414 = (new cljs.core.PersistentVector(null,2,(5),inst_45412,inst_45413,null));
var inst_45415 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_45393__$1,inst_45414);
var inst_45416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45417 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_45418 = (new cljs.core.PersistentVector(null,2,(5),inst_45416,inst_45417,null));
var inst_45419 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_45393__$1,inst_45418);
var inst_45420 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_45421 = inst_45329;
var inst_45422 = inst_45407;
var inst_45423 = inst_45411;
var inst_45424 = inst_45415;
var inst_45425 = inst_45419;
var inst_45426 = inst_45420;
var state_45500__$1 = (function (){var statearr_45519 = state_45500;
(statearr_45519[(7)] = inst_45393__$1);

(statearr_45519[(24)] = inst_45403);

(statearr_45519[(8)] = inst_45425);

(statearr_45519[(10)] = inst_45423);

(statearr_45519[(11)] = inst_45426);

(statearr_45519[(31)] = inst_45402);

(statearr_45519[(21)] = inst_45421);

(statearr_45519[(12)] = inst_45424);

(statearr_45519[(14)] = inst_45422);

return statearr_45519;
})();
var statearr_45520_45584 = state_45500__$1;
(statearr_45520_45584[(2)] = null);

(statearr_45520_45584[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (22))){
var inst_45493 = (state_45500[(2)]);
var state_45500__$1 = state_45500;
var statearr_45521_45585 = state_45500__$1;
(statearr_45521_45585[(2)] = inst_45493);

(statearr_45521_45585[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (36))){
var inst_45432 = (state_45500[(25)]);
var inst_45341 = (state_45500[(29)]);
var inst_45483 = (state_45500[(2)]);
var inst_45484 = inst_45432.p;
var inst_45485 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45341,inst_45484);
var state_45500__$1 = (function (){var statearr_45522 = state_45500;
(statearr_45522[(20)] = inst_45483);

return statearr_45522;
})();
if(cljs.core.truth_(inst_45485)){
var statearr_45523_45586 = state_45500__$1;
(statearr_45523_45586[(1)] = (37));

} else {
var statearr_45524_45587 = state_45500__$1;
(statearr_45524_45587[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (29))){
var inst_45444 = (state_45500[(15)]);
var inst_45454 = (state_45500[(2)]);
var inst_45455 = fluree.db.util.async.throw_err(inst_45454);
var inst_45456 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_45444,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_45455);
var state_45500__$1 = state_45500;
var statearr_45525_45588 = state_45500__$1;
(statearr_45525_45588[(2)] = inst_45456);

(statearr_45525_45588[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (6))){
var inst_45312 = (state_45500[(30)]);
var inst_45317 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_45318 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_45319 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45317)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45318)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45312),"."].join('');
var inst_45320 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_45321 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_45322 = cljs.core.PersistentHashMap.fromArrays(inst_45320,inst_45321);
var inst_45323 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45319,inst_45322);
var inst_45324 = (function(){throw inst_45323})();
var state_45500__$1 = state_45500;
var statearr_45526_45589 = state_45500__$1;
(statearr_45526_45589[(2)] = inst_45324);

(statearr_45526_45589[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (28))){
var inst_45344 = (state_45500[(32)]);
var inst_45459 = (state_45500[(2)]);
var state_45500__$1 = (function (){var statearr_45527 = state_45500;
(statearr_45527[(35)] = inst_45459);

return statearr_45527;
})();
if(cljs.core.truth_(inst_45344)){
var statearr_45528_45590 = state_45500__$1;
(statearr_45528_45590[(1)] = (30));

} else {
var statearr_45529_45591 = state_45500__$1;
(statearr_45529_45591[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (25))){
var inst_45450 = (state_45500[(2)]);
var state_45500__$1 = state_45500;
if(cljs.core.truth_(inst_45450)){
var statearr_45530_45592 = state_45500__$1;
(statearr_45530_45592[(1)] = (26));

} else {
var statearr_45531_45593 = state_45500__$1;
(statearr_45531_45593[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (34))){
var inst_45432 = (state_45500[(25)]);
var inst_45424 = (state_45500[(12)]);
var inst_45480 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_45424,inst_45432);
var state_45500__$1 = state_45500;
var statearr_45532_45594 = state_45500__$1;
(statearr_45532_45594[(2)] = inst_45480);

(statearr_45532_45594[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (17))){
var inst_45372 = (state_45500[(36)]);
var inst_45376 = (state_45500[(2)]);
var inst_45377 = fluree.db.util.async.throw_err(inst_45376);
var inst_45364 = inst_45372;
var inst_45365 = inst_45377;
var state_45500__$1 = (function (){var statearr_45533 = state_45500;
(statearr_45533[(37)] = inst_45364);

(statearr_45533[(22)] = inst_45365);

return statearr_45533;
})();
var statearr_45534_45595 = state_45500__$1;
(statearr_45534_45595[(2)] = null);

(statearr_45534_45595[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (3))){
var inst_45498 = (state_45500[(2)]);
var state_45500__$1 = state_45500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45500__$1,inst_45498);
} else {
if((state_val_45501 === (12))){
var inst_45364 = (state_45500[(37)]);
var inst_45371 = (state_45500[(38)]);
var inst_45370 = cljs.core.seq(inst_45364);
var inst_45371__$1 = cljs.core.first(inst_45370);
var inst_45372 = cljs.core.next(inst_45370);
var state_45500__$1 = (function (){var statearr_45535 = state_45500;
(statearr_45535[(36)] = inst_45372);

(statearr_45535[(38)] = inst_45371__$1);

return statearr_45535;
})();
if(cljs.core.truth_(inst_45371__$1)){
var statearr_45536_45596 = state_45500__$1;
(statearr_45536_45596[(1)] = (14));

} else {
var statearr_45537_45597 = state_45500__$1;
(statearr_45537_45597[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (2))){
var inst_45312 = (state_45500[(30)]);
var _ = (function (){var statearr_45538 = state_45500;
(statearr_45538[(4)] = cljs.core.cons((5),(state_45500[(4)])));

return statearr_45538;
})();
var inst_45311 = cljs.core.first(flakes);
var inst_45312__$1 = inst_45311.t;
var inst_45313 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_45314 = (inst_45313 - (1));
var inst_45315 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_45312__$1,inst_45314);
var state_45500__$1 = (function (){var statearr_45539 = state_45500;
(statearr_45539[(30)] = inst_45312__$1);

return statearr_45539;
})();
if(inst_45315){
var statearr_45540_45598 = state_45500__$1;
(statearr_45540_45598[(1)] = (6));

} else {
var statearr_45541_45599 = state_45500__$1;
(statearr_45541_45599[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (23))){
var inst_45343 = (state_45500[(13)]);
var state_45500__$1 = state_45500;
var statearr_45542_45600 = state_45500__$1;
(statearr_45542_45600[(2)] = inst_45343);

(statearr_45542_45600[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (35))){
var inst_45424 = (state_45500[(12)]);
var state_45500__$1 = state_45500;
var statearr_45543_45601 = state_45500__$1;
(statearr_45543_45601[(2)] = inst_45424);

(statearr_45543_45601[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (19))){
var inst_45495 = (state_45500[(2)]);
var _ = (function (){var statearr_45544 = state_45500;
(statearr_45544[(4)] = cljs.core.rest((state_45500[(4)])));

return statearr_45544;
})();
var state_45500__$1 = state_45500;
var statearr_45545_45602 = state_45500__$1;
(statearr_45545_45602[(2)] = inst_45495);

(statearr_45545_45602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (11))){
var inst_45352 = (state_45500[(26)]);
var inst_45352__$1 = (state_45500[(2)]);
var inst_45360 = cljs.core.seq(inst_45352__$1);
var inst_45361 = cljs.core.first(inst_45360);
var inst_45362 = cljs.core.next(inst_45360);
var inst_45363 = db;
var inst_45364 = inst_45352__$1;
var inst_45365 = inst_45363;
var state_45500__$1 = (function (){var statearr_45547 = state_45500;
(statearr_45547[(37)] = inst_45364);

(statearr_45547[(39)] = inst_45361);

(statearr_45547[(26)] = inst_45352__$1);

(statearr_45547[(40)] = inst_45362);

(statearr_45547[(22)] = inst_45365);

return statearr_45547;
})();
var statearr_45548_45603 = state_45500__$1;
(statearr_45548_45603[(2)] = null);

(statearr_45548_45603[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (9))){
var inst_45329 = (state_45500[(28)]);
var inst_45346 = (state_45500[(34)]);
var inst_45348 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_45329,inst_45346);
var state_45500__$1 = state_45500;
var statearr_45549_45604 = state_45500__$1;
(statearr_45549_45604[(2)] = inst_45348);

(statearr_45549_45604[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (5))){
var _ = (function (){var statearr_45550 = state_45500;
(statearr_45550[(4)] = cljs.core.rest((state_45500[(4)])));

return statearr_45550;
})();
var state_45500__$1 = state_45500;
var ex45546 = (state_45500__$1[(2)]);
var statearr_45551_45605 = state_45500__$1;
(statearr_45551_45605[(5)] = ex45546);


if((ex45546 instanceof Error)){
var statearr_45552_45606 = state_45500__$1;
(statearr_45552_45606[(1)] = (4));

(statearr_45552_45606[(5)] = null);

} else {
throw ex45546;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (14))){
var inst_45365 = (state_45500[(22)]);
var inst_45371 = (state_45500[(38)]);
var inst_45374 = fluree.db.graphdb.add_predicate_to_idx(inst_45365,inst_45371,opts);
var state_45500__$1 = state_45500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45500__$1,(17),inst_45374);
} else {
if((state_val_45501 === (26))){
var inst_45444 = (state_45500[(15)]);
var inst_45452 = fluree.db.query.schema.schema_map(inst_45444);
var state_45500__$1 = state_45500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45500__$1,(29),inst_45452);
} else {
if((state_val_45501 === (16))){
var inst_45381 = (state_45500[(2)]);
var state_45500__$1 = state_45500;
var statearr_45553_45607 = state_45500__$1;
(statearr_45553_45607[(2)] = inst_45381);

(statearr_45553_45607[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (38))){
var inst_45425 = (state_45500[(8)]);
var state_45500__$1 = state_45500;
var statearr_45554_45608 = state_45500__$1;
(statearr_45554_45608[(2)] = inst_45425);

(statearr_45554_45608[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (30))){
var inst_45459 = (state_45500[(35)]);
var inst_45462 = fluree.db.query.schema.setting_map(inst_45459);
var state_45500__$1 = state_45500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45500__$1,(33),inst_45462);
} else {
if((state_val_45501 === (10))){
var inst_45350 = cljs.core.PersistentVector.EMPTY;
var state_45500__$1 = state_45500;
var statearr_45555_45609 = state_45500__$1;
(statearr_45555_45609[(2)] = inst_45350);

(statearr_45555_45609[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (18))){
var inst_45432 = (state_45500[(25)]);
var inst_45421 = (state_45500[(21)]);
var inst_45431 = cljs.core.seq(inst_45421);
var inst_45432__$1 = cljs.core.first(inst_45431);
var inst_45433 = cljs.core.next(inst_45431);
var inst_45434 = cljs.core.not(inst_45432__$1);
var state_45500__$1 = (function (){var statearr_45556 = state_45500;
(statearr_45556[(25)] = inst_45432__$1);

(statearr_45556[(18)] = inst_45433);

return statearr_45556;
})();
if(inst_45434){
var statearr_45557_45610 = state_45500__$1;
(statearr_45557_45610[(1)] = (20));

} else {
var statearr_45558_45611 = state_45500__$1;
(statearr_45558_45611[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (37))){
var inst_45432 = (state_45500[(25)]);
var inst_45425 = (state_45500[(8)]);
var inst_45487 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_45425,inst_45432);
var state_45500__$1 = state_45500;
var statearr_45559_45612 = state_45500__$1;
(statearr_45559_45612[(2)] = inst_45487);

(statearr_45559_45612[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45501 === (8))){
var inst_45337 = (state_45500[(23)]);
var inst_45327 = (state_45500[(27)]);
var inst_45329 = (state_45500[(28)]);
var inst_45312 = (state_45500[(30)]);
var inst_45333 = (state_45500[(33)]);
var inst_45343 = (state_45500[(13)]);
var inst_45327__$1 = (state_45500[(2)]);
var inst_45328 = (function (){var t = inst_45312;
var _ = inst_45327__$1;
return (function (p1__45300_SHARP_){
return cljs.core.not((function (){var G__45560 = p1__45300_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__45560) : fluree.db.graphdb.exclude_predicates.call(null,G__45560));
})());
});
})();
var inst_45329__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_45328,flakes);
var inst_45330 = cljs.core.PersistentHashSet.EMPTY;
var inst_45331 = (function (){var t = inst_45312;
var _ = inst_45327__$1;
var add_flakes = inst_45329__$1;
return (function (p1__45301_SHARP_){
return p1__45301_SHARP_.p;
});
})();
var inst_45332 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_45331,inst_45329__$1);
var inst_45333__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_45330,inst_45332);
var inst_45334 = cljs.core.PersistentHashMap.EMPTY;
var inst_45335 = (function (){var t = inst_45312;
var _ = inst_45327__$1;
var add_flakes = inst_45329__$1;
var add_preds = inst_45333__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_45336 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_45335,inst_45333__$1);
var inst_45337__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_45334,inst_45336);
var inst_45338 = cljs.core.PersistentHashMap.EMPTY;
var inst_45339 = (function (){var t = inst_45312;
var _ = inst_45327__$1;
var add_flakes = inst_45329__$1;
var add_preds = inst_45333__$1;
var idx_QMARK__map = inst_45337__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_45340 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_45339,inst_45333__$1);
var inst_45341 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_45338,inst_45340);
var inst_45342 = fluree.db.flake.size_bytes(inst_45329__$1);
var inst_45343__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_45329__$1);
var inst_45344 = fluree.db.util.schema.setting_change_QMARK_(inst_45329__$1);
var inst_45345 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_45346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45345,(0));
var state_45500__$1 = (function (){var statearr_45561 = state_45500;
(statearr_45561[(23)] = inst_45337__$1);

(statearr_45561[(9)] = inst_45342);

(statearr_45561[(27)] = inst_45327__$1);

(statearr_45561[(28)] = inst_45329__$1);

(statearr_45561[(29)] = inst_45341);

(statearr_45561[(32)] = inst_45344);

(statearr_45561[(33)] = inst_45333__$1);

(statearr_45561[(13)] = inst_45343__$1);

(statearr_45561[(34)] = inst_45346);

return statearr_45561;
})();
if(cljs.core.truth_(inst_45343__$1)){
var statearr_45562_45613 = state_45500__$1;
(statearr_45562_45613[(1)] = (9));

} else {
var statearr_45563_45614 = state_45500__$1;
(statearr_45563_45614[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__17178__auto__ = null;
var fluree$db$graphdb$state_machine__17178__auto____0 = (function (){
var statearr_45564 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45564[(0)] = fluree$db$graphdb$state_machine__17178__auto__);

(statearr_45564[(1)] = (1));

return statearr_45564;
});
var fluree$db$graphdb$state_machine__17178__auto____1 = (function (state_45500){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_45500);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e45565){var ex__17181__auto__ = e45565;
var statearr_45566_45615 = state_45500;
(statearr_45566_45615[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_45500[(4)]))){
var statearr_45567_45616 = state_45500;
(statearr_45567_45616[(1)] = cljs.core.first((state_45500[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45617 = state_45500;
state_45500 = G__45617;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__17178__auto__ = function(state_45500){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__17178__auto____1.call(this,state_45500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__17178__auto____0;
fluree$db$graphdb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__17178__auto____1;
return fluree$db$graphdb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_45568 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_45568[(6)] = c__17304__auto__);

return statearr_45568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__45619 = arguments.length;
switch (G__45619) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__17304__auto___45766 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_45715){
var state_val_45716 = (state_45715[(1)]);
if((state_val_45716 === (7))){
var state_45715__$1 = state_45715;
var statearr_45717_45767 = state_45715__$1;
(statearr_45717_45767[(2)] = null);

(statearr_45717_45767[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (20))){
var inst_45664 = (state_45715[(7)]);
var inst_45663 = (state_45715[(8)]);
var inst_45665 = (state_45715[(9)]);
var inst_45684 = (inst_45663 + (1));
var inst_45685 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_45665,new cljs.core.Keyword(null,"t","t",-1397832519),inst_45684);
var inst_45686 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_45685,inst_45664,opts);
var state_45715__$1 = state_45715;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45715__$1,(23),inst_45686);
} else {
if((state_val_45716 === (1))){
var state_45715__$1 = state_45715;
var statearr_45718_45768 = state_45715__$1;
(statearr_45718_45768[(2)] = null);

(statearr_45718_45768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (24))){
var inst_45689 = (state_45715[(10)]);
var inst_45692 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_45689,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_45715__$1 = state_45715;
var statearr_45719_45769 = state_45715__$1;
(statearr_45719_45769[(2)] = inst_45692);

(statearr_45719_45769[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (4))){
var inst_45620 = (state_45715[(2)]);
var inst_45621 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_45620);
var state_45715__$1 = state_45715;
var statearr_45720_45770 = state_45715__$1;
(statearr_45720_45770[(2)] = inst_45621);

(statearr_45720_45770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (15))){
var inst_45671 = (state_45715[(11)]);
var state_45715__$1 = state_45715;
var statearr_45721_45771 = state_45715__$1;
(statearr_45721_45771[(2)] = inst_45671);

(statearr_45721_45771[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (21))){
var state_45715__$1 = state_45715;
var statearr_45722_45772 = state_45715__$1;
(statearr_45722_45772[(2)] = null);

(statearr_45722_45772[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (13))){
var inst_45707 = (state_45715[(2)]);
var inst_45708 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_45707);
var state_45715__$1 = state_45715;
var statearr_45723_45773 = state_45715__$1;
(statearr_45723_45773[(2)] = inst_45708);

(statearr_45723_45773[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (22))){
var inst_45703 = (state_45715[(2)]);
var state_45715__$1 = state_45715;
var statearr_45724_45774 = state_45715__$1;
(statearr_45724_45774[(2)] = inst_45703);

(statearr_45724_45774[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (6))){
var inst_45631 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_45632 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_45633 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45631)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45632)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_45634 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_45635 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_45636 = cljs.core.PersistentHashMap.fromArrays(inst_45634,inst_45635);
var inst_45637 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45633,inst_45636);
var inst_45638 = (function(){throw inst_45637})();
var state_45715__$1 = state_45715;
var statearr_45727_45775 = state_45715__$1;
(statearr_45727_45775[(2)] = inst_45638);

(statearr_45727_45775[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (25))){
var inst_45689 = (state_45715[(10)]);
var inst_45672 = (state_45715[(12)]);
var inst_45671 = (state_45715[(11)]);
var inst_45694 = inst_45671.t;
var inst_45695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45696 = [inst_45671];
var inst_45697 = (new cljs.core.PersistentVector(null,1,(5),inst_45695,inst_45696,null));
var inst_45662 = inst_45672;
var inst_45663 = inst_45694;
var inst_45664 = inst_45697;
var inst_45665 = inst_45689;
var state_45715__$1 = (function (){var statearr_45728 = state_45715;
(statearr_45728[(7)] = inst_45664);

(statearr_45728[(8)] = inst_45663);

(statearr_45728[(9)] = inst_45665);

(statearr_45728[(13)] = inst_45662);

return statearr_45728;
})();
var statearr_45729_45776 = state_45715__$1;
(statearr_45729_45776[(2)] = null);

(statearr_45729_45776[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (17))){
var inst_45664 = (state_45715[(7)]);
var inst_45663 = (state_45715[(8)]);
var inst_45665 = (state_45715[(9)]);
var inst_45672 = (state_45715[(12)]);
var inst_45671 = (state_45715[(11)]);
var inst_45680 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_45664,inst_45671);
var tmp45725 = inst_45663;
var tmp45726 = inst_45665;
var inst_45662 = inst_45672;
var inst_45663__$1 = tmp45725;
var inst_45664__$1 = inst_45680;
var inst_45665__$1 = tmp45726;
var state_45715__$1 = (function (){var statearr_45730 = state_45715;
(statearr_45730[(7)] = inst_45664__$1);

(statearr_45730[(8)] = inst_45663__$1);

(statearr_45730[(9)] = inst_45665__$1);

(statearr_45730[(13)] = inst_45662);

return statearr_45730;
})();
var statearr_45731_45777 = state_45715__$1;
(statearr_45731_45777[(2)] = null);

(statearr_45731_45777[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (3))){
var inst_45713 = (state_45715[(2)]);
var state_45715__$1 = state_45715;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45715__$1,inst_45713);
} else {
if((state_val_45716 === (12))){
var inst_45662 = (state_45715[(13)]);
var inst_45671 = (state_45715[(11)]);
var inst_45670 = cljs.core.seq(inst_45662);
var inst_45671__$1 = cljs.core.first(inst_45670);
var inst_45672 = cljs.core.next(inst_45670);
var state_45715__$1 = (function (){var statearr_45732 = state_45715;
(statearr_45732[(12)] = inst_45672);

(statearr_45732[(11)] = inst_45671__$1);

return statearr_45732;
})();
if(cljs.core.truth_(inst_45671__$1)){
var statearr_45733_45778 = state_45715__$1;
(statearr_45733_45778[(1)] = (14));

} else {
var statearr_45734_45779 = state_45715__$1;
(statearr_45734_45779[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (2))){
var _ = (function (){var statearr_45735 = state_45715;
(statearr_45735[(4)] = cljs.core.cons((5),(state_45715[(4)])));

return statearr_45735;
})();
var inst_45627 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_45628 = (inst_45627 + (1));
var inst_45629 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_45628);
var state_45715__$1 = state_45715;
if(inst_45629){
var statearr_45736_45780 = state_45715__$1;
(statearr_45736_45780[(1)] = (6));

} else {
var statearr_45737_45781 = state_45715__$1;
(statearr_45737_45781[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (23))){
var inst_45671 = (state_45715[(11)]);
var inst_45688 = (state_45715[(2)]);
var inst_45689 = fluree.db.util.async.throw_err(inst_45688);
var inst_45690 = (inst_45671 == null);
var state_45715__$1 = (function (){var statearr_45738 = state_45715;
(statearr_45738[(10)] = inst_45689);

return statearr_45738;
})();
if(cljs.core.truth_(inst_45690)){
var statearr_45739_45782 = state_45715__$1;
(statearr_45739_45782[(1)] = (24));

} else {
var statearr_45740_45783 = state_45715__$1;
(statearr_45740_45783[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (19))){
var inst_45705 = (state_45715[(2)]);
var state_45715__$1 = state_45715;
var statearr_45741_45784 = state_45715__$1;
(statearr_45741_45784[(2)] = inst_45705);

(statearr_45741_45784[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (11))){
var inst_45710 = (state_45715[(2)]);
var _ = (function (){var statearr_45743 = state_45715;
(statearr_45743[(4)] = cljs.core.rest((state_45715[(4)])));

return statearr_45743;
})();
var state_45715__$1 = state_45715;
var statearr_45744_45785 = state_45715__$1;
(statearr_45744_45785[(2)] = inst_45710);

(statearr_45744_45785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (9))){
var inst_45644 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_45645 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_45644);
var state_45715__$1 = state_45715;
var statearr_45745_45786 = state_45715__$1;
(statearr_45745_45786[(2)] = inst_45645);

(statearr_45745_45786[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (5))){
var _ = (function (){var statearr_45746 = state_45715;
(statearr_45746[(4)] = cljs.core.rest((state_45715[(4)])));

return statearr_45746;
})();
var state_45715__$1 = state_45715;
var ex45742 = (state_45715__$1[(2)]);
var statearr_45747_45787 = state_45715__$1;
(statearr_45747_45787[(5)] = ex45742);


var statearr_45748_45788 = state_45715__$1;
(statearr_45748_45788[(1)] = (4));

(statearr_45748_45788[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (14))){
var inst_45663 = (state_45715[(8)]);
var inst_45671 = (state_45715[(11)]);
var inst_45674 = inst_45671.t;
var inst_45675 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45663,inst_45674);
var state_45715__$1 = state_45715;
var statearr_45749_45789 = state_45715__$1;
(statearr_45749_45789[(2)] = inst_45675);

(statearr_45749_45789[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (26))){
var inst_45700 = (state_45715[(2)]);
var state_45715__$1 = state_45715;
var statearr_45750_45790 = state_45715__$1;
(statearr_45750_45790[(2)] = inst_45700);

(statearr_45750_45790[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (16))){
var inst_45678 = (state_45715[(2)]);
var state_45715__$1 = state_45715;
if(cljs.core.truth_(inst_45678)){
var statearr_45751_45791 = state_45715__$1;
(statearr_45751_45791[(1)] = (17));

} else {
var statearr_45752_45792 = state_45715__$1;
(statearr_45752_45792[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (10))){
var inst_45647 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_45648 = cljs.core.first(inst_45647);
var inst_45656 = cljs.core.seq(inst_45647);
var inst_45657 = cljs.core.first(inst_45656);
var inst_45658 = cljs.core.next(inst_45656);
var inst_45659 = inst_45648.t;
var inst_45660 = cljs.core.PersistentVector.EMPTY;
var inst_45661 = db;
var inst_45662 = inst_45647;
var inst_45663 = inst_45659;
var inst_45664 = inst_45660;
var inst_45665 = inst_45661;
var state_45715__$1 = (function (){var statearr_45753 = state_45715;
(statearr_45753[(7)] = inst_45664);

(statearr_45753[(8)] = inst_45663);

(statearr_45753[(9)] = inst_45665);

(statearr_45753[(13)] = inst_45662);

(statearr_45753[(14)] = inst_45657);

(statearr_45753[(15)] = inst_45658);

return statearr_45753;
})();
var statearr_45754_45793 = state_45715__$1;
(statearr_45754_45793[(2)] = null);

(statearr_45754_45793[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (18))){
var state_45715__$1 = state_45715;
var statearr_45755_45794 = state_45715__$1;
(statearr_45755_45794[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45716 === (8))){
var inst_45641 = (state_45715[(2)]);
var inst_45642 = cljs.core.empty_QMARK_(flakes);
var state_45715__$1 = (function (){var statearr_45757 = state_45715;
(statearr_45757[(16)] = inst_45641);

return statearr_45757;
})();
if(inst_45642){
var statearr_45758_45795 = state_45715__$1;
(statearr_45758_45795[(1)] = (9));

} else {
var statearr_45759_45796 = state_45715__$1;
(statearr_45759_45796[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__17178__auto__ = null;
var fluree$db$graphdb$state_machine__17178__auto____0 = (function (){
var statearr_45760 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45760[(0)] = fluree$db$graphdb$state_machine__17178__auto__);

(statearr_45760[(1)] = (1));

return statearr_45760;
});
var fluree$db$graphdb$state_machine__17178__auto____1 = (function (state_45715){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_45715);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e45761){var ex__17181__auto__ = e45761;
var statearr_45762_45797 = state_45715;
(statearr_45762_45797[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_45715[(4)]))){
var statearr_45763_45798 = state_45715;
(statearr_45763_45798[(1)] = cljs.core.first((state_45715[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45799 = state_45715;
state_45715 = G__45799;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__17178__auto__ = function(state_45715){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__17178__auto____1.call(this,state_45715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__17178__auto____0;
fluree$db$graphdb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__17178__auto____1;
return fluree$db$graphdb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_45764 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_45764[(6)] = c__17304__auto___45766);

return statearr_45764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_45855){
var state_val_45856 = (state_45855[(1)]);
if((state_val_45856 === (7))){
var state_45855__$1 = state_45855;
var statearr_45857_45884 = state_45855__$1;
(statearr_45857_45884[(2)] = tt_id);

(statearr_45857_45884[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (1))){
var state_45855__$1 = state_45855;
var statearr_45858_45885 = state_45855__$1;
(statearr_45858_45885[(2)] = null);

(statearr_45858_45885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (4))){
var inst_45800 = (state_45855[(2)]);
var state_45855__$1 = state_45855;
var statearr_45859_45886 = state_45855__$1;
(statearr_45859_45886[(2)] = inst_45800);

(statearr_45859_45886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (13))){
var inst_45848 = (state_45855[(2)]);
var state_45855__$1 = state_45855;
var statearr_45860_45887 = state_45855__$1;
(statearr_45860_45887[(2)] = inst_45848);

(statearr_45860_45887[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (6))){
var inst_45808 = fluree.db.util.core.random_uuid();
var state_45855__$1 = state_45855;
var statearr_45861_45888 = state_45855__$1;
(statearr_45861_45888[(2)] = inst_45808);

(statearr_45861_45888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (3))){
var inst_45853 = (state_45855[(2)]);
var state_45855__$1 = state_45855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45855__$1,inst_45853);
} else {
if((state_val_45856 === (12))){
var inst_45831 = (state_45855[(7)]);
var state_45855__$1 = state_45855;
var statearr_45862_45889 = state_45855__$1;
(statearr_45862_45889[(2)] = inst_45831);

(statearr_45862_45889[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (2))){
var _ = (function (){var statearr_45863 = state_45855;
(statearr_45863[(4)] = cljs.core.cons((5),(state_45855[(4)])));

return statearr_45863;
})();
var inst_45806 = (tt_id == null);
var state_45855__$1 = state_45855;
if(cljs.core.truth_(inst_45806)){
var statearr_45864_45890 = state_45855__$1;
(statearr_45864_45890[(1)] = (6));

} else {
var statearr_45865_45891 = state_45855__$1;
(statearr_45865_45891[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (11))){
var inst_45838 = (state_45855[(8)]);
var inst_45831 = (state_45855[(7)]);
var inst_45841 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_45831,inst_45838);
var state_45855__$1 = state_45855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45855__$1,(14),inst_45841);
} else {
if((state_val_45856 === (9))){
var inst_45838 = (state_45855[(8)]);
var inst_45832 = (state_45855[(9)]);
var inst_45837 = cljs.core.seq(inst_45832);
var inst_45838__$1 = cljs.core.first(inst_45837);
var inst_45839 = cljs.core.next(inst_45837);
var state_45855__$1 = (function (){var statearr_45867 = state_45855;
(statearr_45867[(8)] = inst_45838__$1);

(statearr_45867[(10)] = inst_45839);

return statearr_45867;
})();
if(cljs.core.truth_(inst_45838__$1)){
var statearr_45868_45892 = state_45855__$1;
(statearr_45868_45892[(1)] = (11));

} else {
var statearr_45869_45893 = state_45855__$1;
(statearr_45869_45893[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (5))){
var _ = (function (){var statearr_45870 = state_45855;
(statearr_45870[(4)] = cljs.core.rest((state_45855[(4)])));

return statearr_45870;
})();
var state_45855__$1 = state_45855;
var ex45866 = (state_45855__$1[(2)]);
var statearr_45871_45894 = state_45855__$1;
(statearr_45871_45894[(5)] = ex45866);


if((ex45866 instanceof Error)){
var statearr_45872_45895 = state_45855__$1;
(statearr_45872_45895[(1)] = (4));

(statearr_45872_45895[(5)] = null);

} else {
throw ex45866;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (14))){
var inst_45839 = (state_45855[(10)]);
var inst_45843 = (state_45855[(2)]);
var inst_45844 = fluree.db.util.async.throw_err(inst_45843);
var inst_45831 = inst_45844;
var inst_45832 = inst_45839;
var state_45855__$1 = (function (){var statearr_45873 = state_45855;
(statearr_45873[(7)] = inst_45831);

(statearr_45873[(9)] = inst_45832);

return statearr_45873;
})();
var statearr_45874_45896 = state_45855__$1;
(statearr_45874_45896[(2)] = null);

(statearr_45874_45896[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (10))){
var inst_45850 = (state_45855[(2)]);
var _ = (function (){var statearr_45875 = state_45855;
(statearr_45875[(4)] = cljs.core.rest((state_45855[(4)])));

return statearr_45875;
})();
var state_45855__$1 = state_45855;
var statearr_45876_45897 = state_45855__$1;
(statearr_45876_45897[(2)] = inst_45850);

(statearr_45876_45897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (8))){
var inst_45811 = (state_45855[(2)]);
var inst_45812 = (function (){var tt_id_SINGLEQUOTE_ = inst_45811;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_45813 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_45811);
var inst_45814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45815 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_45816 = (new cljs.core.PersistentVector(null,4,(5),inst_45814,inst_45815,null));
var inst_45817 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_45812,inst_45813,inst_45816);
var inst_45818 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_45819 = cljs.core.reverse(inst_45818);
var inst_45820 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_45819);
var inst_45828 = cljs.core.seq(inst_45820);
var inst_45829 = cljs.core.first(inst_45828);
var inst_45830 = cljs.core.next(inst_45828);
var inst_45831 = inst_45817;
var inst_45832 = inst_45820;
var state_45855__$1 = (function (){var statearr_45877 = state_45855;
(statearr_45877[(11)] = inst_45830);

(statearr_45877[(7)] = inst_45831);

(statearr_45877[(12)] = inst_45829);

(statearr_45877[(9)] = inst_45832);

return statearr_45877;
})();
var statearr_45878_45898 = state_45855__$1;
(statearr_45878_45898[(2)] = null);

(statearr_45878_45898[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__17178__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__17178__auto____0 = (function (){
var statearr_45879 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45879[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__17178__auto__);

(statearr_45879[(1)] = (1));

return statearr_45879;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__17178__auto____1 = (function (state_45855){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_45855);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e45880){var ex__17181__auto__ = e45880;
var statearr_45881_45899 = state_45855;
(statearr_45881_45899[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_45855[(4)]))){
var statearr_45882_45900 = state_45855;
(statearr_45882_45900[(1)] = cljs.core.first((state_45855[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45901 = state_45855;
state_45855 = G__45901;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__17178__auto__ = function(state_45855){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__17178__auto____1.call(this,state_45855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__17178__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__17178__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_45883 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_45883[(6)] = c__17304__auto__);

return statearr_45883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__17304__auto___46088 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_46019){
var state_val_46020 = (state_46019[(1)]);
if((state_val_46020 === (7))){
var inst_45929 = (state_46019[(7)]);
var inst_45929__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_46019__$1 = (function (){var statearr_46021 = state_46019;
(statearr_46021[(7)] = inst_45929__$1);

return statearr_46021;
})();
if(inst_45929__$1){
var statearr_46022_46089 = state_46019__$1;
(statearr_46022_46089[(1)] = (13));

} else {
var statearr_46023_46090 = state_46019__$1;
(statearr_46023_46090[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (20))){
var state_46019__$1 = state_46019;
var statearr_46024_46091 = state_46019__$1;
(statearr_46024_46091[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (27))){
var inst_45965 = (state_46019[(8)]);
var inst_45969 = inst_45965.s;
var state_46019__$1 = state_46019;
var statearr_46026_46092 = state_46019__$1;
(statearr_46026_46092[(2)] = inst_45969);

(statearr_46026_46092[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (1))){
var state_46019__$1 = state_46019;
var statearr_46027_46093 = state_46019__$1;
(statearr_46027_46093[(2)] = null);

(statearr_46027_46093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (24))){
var inst_45959 = (state_46019[(9)]);
var inst_45963 = cljs.core.first(inst_45959);
var state_46019__$1 = state_46019;
var statearr_46028_46094 = state_46019__$1;
(statearr_46028_46094[(2)] = inst_45963);

(statearr_46028_46094[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (39))){
var state_46019__$1 = state_46019;
var statearr_46029_46095 = state_46019__$1;
(statearr_46029_46095[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (4))){
var inst_45902 = (state_46019[(2)]);
var inst_45903 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_45904 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_45905 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_45906 = cljs.core.PersistentHashMap.fromArrays(inst_45904,inst_45905);
var inst_45907 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_45903,inst_45906,inst_45902);
var inst_45908 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_45907);
var state_46019__$1 = state_46019;
var statearr_46031_46096 = state_46019__$1;
(statearr_46031_46096[(2)] = inst_45908);

(statearr_46031_46096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (15))){
var inst_45936 = (state_46019[(2)]);
var state_46019__$1 = state_46019;
if(cljs.core.truth_(inst_45936)){
var statearr_46032_46097 = state_46019__$1;
(statearr_46032_46097[(1)] = (16));

} else {
var statearr_46033_46098 = state_46019__$1;
(statearr_46033_46098[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (21))){
var inst_45985 = (state_46019[(2)]);
var state_46019__$1 = state_46019;
var statearr_46034_46099 = state_46019__$1;
(statearr_46034_46099[(2)] = inst_45985);

(statearr_46034_46099[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (31))){
var inst_45983 = (state_46019[(2)]);
var state_46019__$1 = state_46019;
var statearr_46035_46100 = state_46019__$1;
(statearr_46035_46100[(2)] = inst_45983);

(statearr_46035_46100[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (32))){
var inst_45989 = (state_46019[(10)]);
var inst_45991 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_45989);
var state_46019__$1 = state_46019;
var statearr_46036_46101 = state_46019__$1;
(statearr_46036_46101[(2)] = inst_45991);

(statearr_46036_46101[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (40))){
var inst_46012 = (state_46019[(2)]);
var state_46019__$1 = state_46019;
var statearr_46037_46102 = state_46019__$1;
(statearr_46037_46102[(2)] = inst_46012);

(statearr_46037_46102[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (33))){
var inst_45993 = (state_46019[(11)]);
var inst_45989 = (state_46019[(10)]);
var inst_45993__$1 = (inst_45989 == null);
var state_46019__$1 = (function (){var statearr_46038 = state_46019;
(statearr_46038[(11)] = inst_45993__$1);

return statearr_46038;
})();
if(cljs.core.truth_(inst_45993__$1)){
var statearr_46039_46103 = state_46019__$1;
(statearr_46039_46103[(1)] = (35));

} else {
var statearr_46040_46104 = state_46019__$1;
(statearr_46040_46104[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (13))){
var inst_45931 = cljs.core.first(ident);
var inst_45932 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_45931);
var inst_45933 = (inst_45932 == null);
var state_46019__$1 = state_46019;
var statearr_46041_46105 = state_46019__$1;
(statearr_46041_46105[(2)] = inst_45933);

(statearr_46041_46105[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (22))){
var inst_45959 = (state_46019[(9)]);
var inst_45958 = (state_46019[(2)]);
var inst_45959__$1 = fluree.db.util.async.throw_err(inst_45958);
var inst_45960 = (inst_45959__$1 == null);
var state_46019__$1 = (function (){var statearr_46042 = state_46019;
(statearr_46042[(9)] = inst_45959__$1);

return statearr_46042;
})();
if(cljs.core.truth_(inst_45960)){
var statearr_46043_46106 = state_46019__$1;
(statearr_46043_46106[(1)] = (23));

} else {
var statearr_46044_46107 = state_46019__$1;
(statearr_46044_46107[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (36))){
var inst_45993 = (state_46019[(11)]);
var state_46019__$1 = state_46019;
var statearr_46045_46108 = state_46019__$1;
(statearr_46045_46108[(2)] = inst_45993);

(statearr_46045_46108[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (41))){
var inst_46007 = cljs.core.async.close_BANG_(return_chan);
var state_46019__$1 = state_46019;
var statearr_46046_46109 = state_46019__$1;
(statearr_46046_46109[(2)] = inst_46007);

(statearr_46046_46109[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (43))){
var inst_46010 = (state_46019[(2)]);
var state_46019__$1 = state_46019;
var statearr_46047_46110 = state_46019__$1;
(statearr_46047_46110[(2)] = inst_46010);

(statearr_46047_46110[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (29))){
var inst_45974 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_45975 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_45974].join('');
var inst_45976 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_45977 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_45978 = cljs.core.PersistentHashMap.fromArrays(inst_45976,inst_45977);
var inst_45979 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45975,inst_45978);
var inst_45980 = (function(){throw inst_45979})();
var state_46019__$1 = state_46019;
var statearr_46048_46111 = state_46019__$1;
(statearr_46048_46111[(2)] = inst_45980);

(statearr_46048_46111[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (6))){
var inst_45916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45917 = [ident];
var inst_45918 = (new cljs.core.PersistentVector(null,1,(5),inst_45916,inst_45917,null));
var inst_45919 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_45918);
var state_46019__$1 = state_46019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46019__$1,(9),inst_45919);
} else {
if((state_val_46020 === (28))){
var inst_45971 = (state_46019[(2)]);
var state_46019__$1 = state_46019;
var statearr_46049_46112 = state_46019__$1;
(statearr_46049_46112[(2)] = inst_45971);

(statearr_46049_46112[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (25))){
var inst_45965 = (state_46019[(8)]);
var inst_45965__$1 = (state_46019[(2)]);
var inst_45966 = (inst_45965__$1 == null);
var state_46019__$1 = (function (){var statearr_46050 = state_46019;
(statearr_46050[(8)] = inst_45965__$1);

return statearr_46050;
})();
if(cljs.core.truth_(inst_45966)){
var statearr_46051_46113 = state_46019__$1;
(statearr_46051_46113[(1)] = (26));

} else {
var statearr_46052_46114 = state_46019__$1;
(statearr_46052_46114[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (34))){
var inst_46014 = (state_46019[(2)]);
var _ = (function (){var statearr_46053 = state_46019;
(statearr_46053[(4)] = cljs.core.rest((state_46019[(4)])));

return statearr_46053;
})();
var state_46019__$1 = state_46019;
var statearr_46054_46115 = state_46019__$1;
(statearr_46054_46115[(2)] = inst_46014);

(statearr_46054_46115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (17))){
var inst_45947 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_46019__$1 = state_46019;
if(inst_45947){
var statearr_46055_46116 = state_46019__$1;
(statearr_46055_46116[(1)] = (19));

} else {
var statearr_46056_46117 = state_46019__$1;
(statearr_46056_46117[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (3))){
var inst_46017 = (state_46019[(2)]);
var state_46019__$1 = state_46019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46019__$1,inst_46017);
} else {
if((state_val_46020 === (12))){
var inst_45927 = (state_46019[(2)]);
var state_46019__$1 = state_46019;
var statearr_46057_46118 = state_46019__$1;
(statearr_46057_46118[(2)] = inst_45927);

(statearr_46057_46118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (2))){
var _ = (function (){var statearr_46058 = state_46019;
(statearr_46058[(4)] = cljs.core.cons((5),(state_46019[(4)])));

return statearr_46058;
})();
var inst_45914 = typeof ident === 'number';
var state_46019__$1 = state_46019;
if(cljs.core.truth_(inst_45914)){
var statearr_46059_46119 = state_46019__$1;
(statearr_46059_46119[(1)] = (6));

} else {
var statearr_46060_46120 = state_46019__$1;
(statearr_46060_46120[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (23))){
var state_46019__$1 = state_46019;
var statearr_46061_46121 = state_46019__$1;
(statearr_46061_46121[(2)] = null);

(statearr_46061_46121[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (35))){
var state_46019__$1 = state_46019;
var statearr_46062_46122 = state_46019__$1;
(statearr_46062_46122[(2)] = strict_QMARK_);

(statearr_46062_46122[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (19))){
var inst_45950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45951 = cljs.core.first(ident);
var inst_45952 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_45951);
var inst_45953 = cljs.core.second(ident);
var inst_45954 = [inst_45952,inst_45953];
var inst_45955 = (new cljs.core.PersistentVector(null,2,(5),inst_45950,inst_45954,null));
var inst_45956 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_45955);
var state_46019__$1 = state_46019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46019__$1,(22),inst_45956);
} else {
if((state_val_46020 === (11))){
var state_46019__$1 = state_46019;
var statearr_46064_46123 = state_46019__$1;
(statearr_46064_46123[(2)] = null);

(statearr_46064_46123[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (9))){
var inst_45921 = (state_46019[(2)]);
var inst_45922 = fluree.db.util.async.throw_err(inst_45921);
var inst_45923 = cljs.core.not_empty(inst_45922);
var state_46019__$1 = state_46019;
if(cljs.core.truth_(inst_45923)){
var statearr_46065_46124 = state_46019__$1;
(statearr_46065_46124[(1)] = (10));

} else {
var statearr_46066_46125 = state_46019__$1;
(statearr_46066_46125[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (5))){
var _ = (function (){var statearr_46067 = state_46019;
(statearr_46067[(4)] = cljs.core.rest((state_46019[(4)])));

return statearr_46067;
})();
var state_46019__$1 = state_46019;
var ex46063 = (state_46019__$1[(2)]);
var statearr_46068_46126 = state_46019__$1;
(statearr_46068_46126[(5)] = ex46063);


var statearr_46069_46127 = state_46019__$1;
(statearr_46069_46127[(1)] = (4));

(statearr_46069_46127[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (14))){
var inst_45929 = (state_46019[(7)]);
var state_46019__$1 = state_46019;
var statearr_46070_46128 = state_46019__$1;
(statearr_46070_46128[(2)] = inst_45929);

(statearr_46070_46128[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (26))){
var state_46019__$1 = state_46019;
var statearr_46071_46129 = state_46019__$1;
(statearr_46071_46129[(2)] = null);

(statearr_46071_46129[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (16))){
var inst_45938 = cljs.core.first(ident);
var inst_45939 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_45938], 0));
var inst_45940 = ["Subject ID lookup failed. The predicate ",inst_45939," does not exist."].join('');
var inst_45941 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_45942 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_45943 = cljs.core.PersistentHashMap.fromArrays(inst_45941,inst_45942);
var inst_45944 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45940,inst_45943);
var inst_45945 = (function(){throw inst_45944})();
var state_46019__$1 = state_46019;
var statearr_46072_46130 = state_46019__$1;
(statearr_46072_46130[(2)] = inst_45945);

(statearr_46072_46130[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (38))){
var inst_45999 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_46000 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_46001 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_46002 = cljs.core.PersistentHashMap.fromArrays(inst_46000,inst_46001);
var inst_46003 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45999,inst_46002);
var inst_46004 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_46003);
var state_46019__$1 = state_46019;
var statearr_46073_46131 = state_46019__$1;
(statearr_46073_46131[(2)] = inst_46004);

(statearr_46073_46131[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (30))){
var state_46019__$1 = state_46019;
var statearr_46074_46132 = state_46019__$1;
(statearr_46074_46132[(2)] = null);

(statearr_46074_46132[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (10))){
var state_46019__$1 = state_46019;
var statearr_46075_46133 = state_46019__$1;
(statearr_46075_46133[(2)] = ident);

(statearr_46075_46133[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (18))){
var inst_45987 = (state_46019[(2)]);
var state_46019__$1 = state_46019;
var statearr_46076_46134 = state_46019__$1;
(statearr_46076_46134[(2)] = inst_45987);

(statearr_46076_46134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (42))){
var state_46019__$1 = state_46019;
var statearr_46077_46135 = state_46019__$1;
(statearr_46077_46135[(2)] = null);

(statearr_46077_46135[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (37))){
var inst_45997 = (state_46019[(2)]);
var state_46019__$1 = state_46019;
if(cljs.core.truth_(inst_45997)){
var statearr_46078_46136 = state_46019__$1;
(statearr_46078_46136[(1)] = (38));

} else {
var statearr_46079_46137 = state_46019__$1;
(statearr_46079_46137[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46020 === (8))){
var inst_45989 = (state_46019[(10)]);
var inst_45989__$1 = (state_46019[(2)]);
var state_46019__$1 = (function (){var statearr_46080 = state_46019;
(statearr_46080[(10)] = inst_45989__$1);

return statearr_46080;
})();
if(cljs.core.truth_(inst_45989__$1)){
var statearr_46081_46138 = state_46019__$1;
(statearr_46081_46138[(1)] = (32));

} else {
var statearr_46082_46139 = state_46019__$1;
(statearr_46082_46139[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__17178__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__17178__auto____0 = (function (){
var statearr_46083 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46083[(0)] = fluree$db$graphdb$subid_$_state_machine__17178__auto__);

(statearr_46083[(1)] = (1));

return statearr_46083;
});
var fluree$db$graphdb$subid_$_state_machine__17178__auto____1 = (function (state_46019){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_46019);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e46084){var ex__17181__auto__ = e46084;
var statearr_46085_46140 = state_46019;
(statearr_46085_46140[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_46019[(4)]))){
var statearr_46086_46141 = state_46019;
(statearr_46086_46141[(1)] = cljs.core.first((state_46019[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46142 = state_46019;
state_46019 = G__46142;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__17178__auto__ = function(state_46019){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__17178__auto____1.call(this,state_46019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__17178__auto____0;
fluree$db$graphdb$subid_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__17178__auto____1;
return fluree$db$graphdb$subid_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_46087 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_46087[(6)] = c__17304__auto___46088);

return statearr_46087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__46143){
var map__46144 = p__46143;
var map__46144__$1 = cljs.core.__destructure_map(map__46144);
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46144__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46144__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_46160){
var state_val_46161 = (state_46160[(1)]);
if((state_val_46161 === (1))){
var state_46160__$1 = state_46160;
var statearr_46162_46176 = state_46160__$1;
(statearr_46162_46176[(2)] = null);

(statearr_46162_46176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46161 === (2))){
var _ = (function (){var statearr_46163 = state_46160;
(statearr_46163[(4)] = cljs.core.cons((5),(state_46160[(4)])));

return statearr_46163;
})();
var inst_46151 = (current_db_fn.cljs$core$IFn$_invoke$arity$0 ? current_db_fn.cljs$core$IFn$_invoke$arity$0() : current_db_fn.call(null));
var state_46160__$1 = state_46160;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46160__$1,(6),inst_46151);
} else {
if((state_val_46161 === (3))){
var inst_46158 = (state_46160[(2)]);
var state_46160__$1 = state_46160;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46160__$1,inst_46158);
} else {
if((state_val_46161 === (4))){
var inst_46145 = (state_46160[(2)]);
var state_46160__$1 = state_46160;
var statearr_46165_46177 = state_46160__$1;
(statearr_46165_46177[(2)] = inst_46145);

(statearr_46165_46177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46161 === (5))){
var _ = (function (){var statearr_46166 = state_46160;
(statearr_46166[(4)] = cljs.core.rest((state_46160[(4)])));

return statearr_46166;
})();
var state_46160__$1 = state_46160;
var ex46164 = (state_46160__$1[(2)]);
var statearr_46167_46178 = state_46160__$1;
(statearr_46167_46178[(5)] = ex46164);


if((ex46164 instanceof Error)){
var statearr_46168_46179 = state_46160__$1;
(statearr_46168_46179[(1)] = (4));

(statearr_46168_46179[(5)] = null);

} else {
throw ex46164;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46161 === (6))){
var inst_46153 = (state_46160[(2)]);
var inst_46154 = fluree.db.util.async.throw_err(inst_46153);
var inst_46155 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_46154,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_46169 = state_46160;
(statearr_46169[(4)] = cljs.core.rest((state_46160[(4)])));

return statearr_46169;
})();
var state_46160__$1 = state_46160;
var statearr_46170_46180 = state_46160__$1;
(statearr_46170_46180[(2)] = inst_46155);

(statearr_46170_46180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__17178__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__17178__auto____0 = (function (){
var statearr_46171 = [null,null,null,null,null,null,null];
(statearr_46171[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__17178__auto__);

(statearr_46171[(1)] = (1));

return statearr_46171;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__17178__auto____1 = (function (state_46160){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_46160);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e46172){var ex__17181__auto__ = e46172;
var statearr_46173_46181 = state_46160;
(statearr_46173_46181[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_46160[(4)]))){
var statearr_46174_46182 = state_46160;
(statearr_46174_46182[(1)] = cljs.core.first((state_46160[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46183 = state_46160;
state_46160 = G__46183;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__17178__auto__ = function(state_46160){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__17178__auto____1.call(this,state_46160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__17178__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__17178__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_46175 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_46175[(6)] = c__17304__auto__);

return statearr_46175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__46184,property,collection){
var map__46185 = p__46184;
var map__46185__$1 = cljs.core.__destructure_map(map__46185);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46185__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__46186 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__46186.cljs$core$IFn$_invoke$arity$1 ? fexpr__46186.cljs$core$IFn$_invoke$arity$1(property) : fexpr__46186.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__46187,property,predicate){
var map__46188 = p__46187;
var map__46188__$1 = cljs.core.__destructure_map(map__46188);
var this$ = map__46188__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46188__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__46189 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__46189.cljs$core$IFn$_invoke$arity$1 ? fexpr__46189.cljs$core$IFn$_invoke$arity$1(property) : fexpr__46189.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__46190 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__46190);
} else {
return G__46190;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__46192 = arguments.length;
switch (G__46192) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_46224){
var state_val_46225 = (state_46224[(1)]);
if((state_val_46225 === (7))){
var state_46224__$1 = state_46224;
var statearr_46226_46320 = state_46224__$1;
(statearr_46226_46320[(2)] = null);

(statearr_46226_46320[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46225 === (1))){
var state_46224__$1 = state_46224;
var statearr_46227_46321 = state_46224__$1;
(statearr_46227_46321[(2)] = null);

(statearr_46227_46321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46225 === (4))){
var inst_46193 = (state_46224[(2)]);
var state_46224__$1 = state_46224;
var statearr_46228_46322 = state_46224__$1;
(statearr_46228_46322[(2)] = inst_46193);

(statearr_46228_46322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46225 === (6))){
var inst_46207 = (state_46224[(7)]);
var inst_46206 = (state_46224[(2)]);
var inst_46207__$1 = fluree.db.util.async.throw_err(inst_46206);
var inst_46208 = (inst_46207__$1 == null);
var state_46224__$1 = (function (){var statearr_46229 = state_46224;
(statearr_46229[(7)] = inst_46207__$1);

return statearr_46229;
})();
if(cljs.core.truth_(inst_46208)){
var statearr_46230_46323 = state_46224__$1;
(statearr_46230_46323[(1)] = (7));

} else {
var statearr_46231_46324 = state_46224__$1;
(statearr_46231_46324[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46225 === (3))){
var inst_46222 = (state_46224[(2)]);
var state_46224__$1 = state_46224;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46224__$1,inst_46222);
} else {
if((state_val_46225 === (12))){
var inst_46219 = (state_46224[(2)]);
var _ = (function (){var statearr_46232 = state_46224;
(statearr_46232[(4)] = cljs.core.rest((state_46224[(4)])));

return statearr_46232;
})();
var state_46224__$1 = state_46224;
var statearr_46233_46325 = state_46224__$1;
(statearr_46233_46325[(2)] = inst_46219);

(statearr_46233_46325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46225 === (2))){
var _ = (function (){var statearr_46234 = state_46224;
(statearr_46234[(4)] = cljs.core.cons((5),(state_46224[(4)])));

return statearr_46234;
})();
var inst_46200 = fluree.db.dbproto._rootdb(this$);
var inst_46201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46202 = [tag_id,(30)];
var inst_46203 = (new cljs.core.PersistentVector(null,2,(5),inst_46201,inst_46202,null));
var inst_46204 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_46200,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_46203);
var state_46224__$1 = state_46224;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46224__$1,(6),inst_46204);
} else {
if((state_val_46225 === (11))){
var inst_46213 = (state_46224[(8)]);
var inst_46217 = inst_46213.o;
var state_46224__$1 = state_46224;
var statearr_46236_46326 = state_46224__$1;
(statearr_46236_46326[(2)] = inst_46217);

(statearr_46236_46326[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46225 === (9))){
var inst_46213 = (state_46224[(8)]);
var inst_46213__$1 = (state_46224[(2)]);
var inst_46214 = (inst_46213__$1 == null);
var state_46224__$1 = (function (){var statearr_46237 = state_46224;
(statearr_46237[(8)] = inst_46213__$1);

return statearr_46237;
})();
if(cljs.core.truth_(inst_46214)){
var statearr_46238_46327 = state_46224__$1;
(statearr_46238_46327[(1)] = (10));

} else {
var statearr_46239_46328 = state_46224__$1;
(statearr_46239_46328[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46225 === (5))){
var _ = (function (){var statearr_46240 = state_46224;
(statearr_46240[(4)] = cljs.core.rest((state_46224[(4)])));

return statearr_46240;
})();
var state_46224__$1 = state_46224;
var ex46235 = (state_46224__$1[(2)]);
var statearr_46241_46329 = state_46224__$1;
(statearr_46241_46329[(5)] = ex46235);


if((ex46235 instanceof Error)){
var statearr_46242_46330 = state_46224__$1;
(statearr_46242_46330[(1)] = (4));

(statearr_46242_46330[(5)] = null);

} else {
throw ex46235;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46225 === (10))){
var state_46224__$1 = state_46224;
var statearr_46243_46331 = state_46224__$1;
(statearr_46243_46331[(2)] = null);

(statearr_46243_46331[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46225 === (8))){
var inst_46207 = (state_46224[(7)]);
var inst_46211 = cljs.core.first(inst_46207);
var state_46224__$1 = state_46224;
var statearr_46244_46332 = state_46224__$1;
(statearr_46244_46332[(2)] = inst_46211);

(statearr_46244_46332[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__17178__auto__ = null;
var fluree$db$graphdb$state_machine__17178__auto____0 = (function (){
var statearr_46245 = [null,null,null,null,null,null,null,null,null];
(statearr_46245[(0)] = fluree$db$graphdb$state_machine__17178__auto__);

(statearr_46245[(1)] = (1));

return statearr_46245;
});
var fluree$db$graphdb$state_machine__17178__auto____1 = (function (state_46224){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_46224);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e46246){var ex__17181__auto__ = e46246;
var statearr_46247_46333 = state_46224;
(statearr_46247_46333[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_46224[(4)]))){
var statearr_46248_46334 = state_46224;
(statearr_46248_46334[(1)] = cljs.core.first((state_46224[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46335 = state_46224;
state_46224 = G__46335;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__17178__auto__ = function(state_46224){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__17178__auto____1.call(this,state_46224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__17178__auto____0;
fluree$db$graphdb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__17178__auto____1;
return fluree$db$graphdb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_46249 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_46249[(6)] = c__17304__auto__);

return statearr_46249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_46285){
var state_val_46286 = (state_46285[(1)]);
if((state_val_46286 === (7))){
var inst_46259 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_46285__$1 = state_46285;
var statearr_46287_46336 = state_46285__$1;
(statearr_46287_46336[(2)] = inst_46259);

(statearr_46287_46336[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (1))){
var state_46285__$1 = state_46285;
var statearr_46288_46337 = state_46285__$1;
(statearr_46288_46337[(2)] = null);

(statearr_46288_46337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (4))){
var inst_46250 = (state_46285[(2)]);
var state_46285__$1 = state_46285;
var statearr_46289_46338 = state_46285__$1;
(statearr_46289_46338[(2)] = inst_46250);

(statearr_46289_46338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (15))){
var inst_46280 = (state_46285[(2)]);
var _ = (function (){var statearr_46290 = state_46285;
(statearr_46290[(4)] = cljs.core.rest((state_46285[(4)])));

return statearr_46290;
})();
var state_46285__$1 = state_46285;
var statearr_46291_46339 = state_46285__$1;
(statearr_46291_46339[(2)] = inst_46280);

(statearr_46291_46339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (13))){
var inst_46265 = (state_46285[(7)]);
var inst_46271 = clojure.string.includes_QMARK_(inst_46265,":");
var state_46285__$1 = state_46285;
if(inst_46271){
var statearr_46292_46340 = state_46285__$1;
(statearr_46292_46340[(1)] = (16));

} else {
var statearr_46293_46341 = state_46285__$1;
(statearr_46293_46341[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (6))){
var state_46285__$1 = state_46285;
var statearr_46294_46342 = state_46285__$1;
(statearr_46294_46342[(2)] = pred);

(statearr_46294_46342[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (17))){
var inst_46265 = (state_46285[(7)]);
var state_46285__$1 = state_46285;
var statearr_46295_46343 = state_46285__$1;
(statearr_46295_46343[(2)] = inst_46265);

(statearr_46295_46343[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (3))){
var inst_46283 = (state_46285[(2)]);
var state_46285__$1 = state_46285;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46285__$1,inst_46283);
} else {
if((state_val_46286 === (12))){
var inst_46269 = (state_46285[(2)]);
var state_46285__$1 = state_46285;
if(cljs.core.truth_(inst_46269)){
var statearr_46296_46344 = state_46285__$1;
(statearr_46296_46344[(1)] = (13));

} else {
var statearr_46297_46345 = state_46285__$1;
(statearr_46297_46345[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (2))){
var _ = (function (){var statearr_46298 = state_46285;
(statearr_46298[(4)] = cljs.core.cons((5),(state_46285[(4)])));

return statearr_46298;
})();
var inst_46256 = typeof pred === 'string';
var state_46285__$1 = state_46285;
if(cljs.core.truth_(inst_46256)){
var statearr_46299_46346 = state_46285__$1;
(statearr_46299_46346[(1)] = (6));

} else {
var statearr_46300_46347 = state_46285__$1;
(statearr_46300_46347[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (11))){
var inst_46261 = (state_46285[(8)]);
var state_46285__$1 = state_46285;
var statearr_46302_46348 = state_46285__$1;
(statearr_46302_46348[(2)] = inst_46261);

(statearr_46302_46348[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (9))){
var inst_46261 = (state_46285[(8)]);
var inst_46264 = (state_46285[(2)]);
var inst_46265 = fluree.db.util.async.throw_err(inst_46264);
var state_46285__$1 = (function (){var statearr_46303 = state_46285;
(statearr_46303[(7)] = inst_46265);

return statearr_46303;
})();
if(cljs.core.truth_(inst_46261)){
var statearr_46304_46349 = state_46285__$1;
(statearr_46304_46349[(1)] = (10));

} else {
var statearr_46305_46350 = state_46285__$1;
(statearr_46305_46350[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (5))){
var _ = (function (){var statearr_46306 = state_46285;
(statearr_46306[(4)] = cljs.core.rest((state_46285[(4)])));

return statearr_46306;
})();
var state_46285__$1 = state_46285;
var ex46301 = (state_46285__$1[(2)]);
var statearr_46307_46351 = state_46285__$1;
(statearr_46307_46351[(5)] = ex46301);


if((ex46301 instanceof Error)){
var statearr_46308_46352 = state_46285__$1;
(statearr_46308_46352[(1)] = (4));

(statearr_46308_46352[(5)] = null);

} else {
throw ex46301;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (14))){
var state_46285__$1 = state_46285;
var statearr_46309_46353 = state_46285__$1;
(statearr_46309_46353[(2)] = null);

(statearr_46309_46353[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (16))){
var inst_46265 = (state_46285[(7)]);
var inst_46273 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_46265,/:/);
var inst_46274 = cljs.core.second(inst_46273);
var state_46285__$1 = state_46285;
var statearr_46310_46354 = state_46285__$1;
(statearr_46310_46354[(2)] = inst_46274);

(statearr_46310_46354[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (10))){
var inst_46265 = (state_46285[(7)]);
var state_46285__$1 = state_46285;
var statearr_46311_46355 = state_46285__$1;
(statearr_46311_46355[(2)] = inst_46265);

(statearr_46311_46355[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (18))){
var inst_46277 = (state_46285[(2)]);
var state_46285__$1 = state_46285;
var statearr_46312_46356 = state_46285__$1;
(statearr_46312_46356[(2)] = inst_46277);

(statearr_46312_46356[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46286 === (8))){
var inst_46261 = (state_46285[(2)]);
var inst_46262 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_46285__$1 = (function (){var statearr_46313 = state_46285;
(statearr_46313[(8)] = inst_46261);

return statearr_46313;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46285__$1,(9),inst_46262);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__17178__auto__ = null;
var fluree$db$graphdb$state_machine__17178__auto____0 = (function (){
var statearr_46314 = [null,null,null,null,null,null,null,null,null];
(statearr_46314[(0)] = fluree$db$graphdb$state_machine__17178__auto__);

(statearr_46314[(1)] = (1));

return statearr_46314;
});
var fluree$db$graphdb$state_machine__17178__auto____1 = (function (state_46285){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_46285);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e46315){var ex__17181__auto__ = e46315;
var statearr_46316_46357 = state_46285;
(statearr_46316_46357[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_46285[(4)]))){
var statearr_46317_46358 = state_46285;
(statearr_46317_46358[(1)] = cljs.core.first((state_46285[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46359 = state_46285;
state_46285 = G__46359;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__17178__auto__ = function(state_46285){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__17178__auto____1.call(this,state_46285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__17178__auto____0;
fluree$db$graphdb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__17178__auto____1;
return fluree$db$graphdb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_46318 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_46318[(6)] = c__17304__auto__);

return statearr_46318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__46361 = arguments.length;
switch (G__46361) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_46394){
var state_val_46395 = (state_46394[(1)]);
if((state_val_46395 === (7))){
var state_46394__$1 = state_46394;
var statearr_46396_46484 = state_46394__$1;
(statearr_46396_46484[(2)] = null);

(statearr_46396_46484[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46395 === (1))){
var state_46394__$1 = state_46394;
var statearr_46397_46485 = state_46394__$1;
(statearr_46397_46485[(2)] = null);

(statearr_46397_46485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46395 === (4))){
var inst_46362 = (state_46394[(2)]);
var state_46394__$1 = state_46394;
var statearr_46398_46486 = state_46394__$1;
(statearr_46398_46486[(2)] = inst_46362);

(statearr_46398_46486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46395 === (6))){
var inst_46377 = (state_46394[(7)]);
var inst_46376 = (state_46394[(2)]);
var inst_46377__$1 = fluree.db.util.async.throw_err(inst_46376);
var inst_46378 = (inst_46377__$1 == null);
var state_46394__$1 = (function (){var statearr_46399 = state_46394;
(statearr_46399[(7)] = inst_46377__$1);

return statearr_46399;
})();
if(cljs.core.truth_(inst_46378)){
var statearr_46400_46487 = state_46394__$1;
(statearr_46400_46487[(1)] = (7));

} else {
var statearr_46401_46488 = state_46394__$1;
(statearr_46401_46488[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46395 === (3))){
var inst_46392 = (state_46394[(2)]);
var state_46394__$1 = state_46394;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46394__$1,inst_46392);
} else {
if((state_val_46395 === (12))){
var inst_46389 = (state_46394[(2)]);
var _ = (function (){var statearr_46402 = state_46394;
(statearr_46402[(4)] = cljs.core.rest((state_46394[(4)])));

return statearr_46402;
})();
var state_46394__$1 = state_46394;
var statearr_46403_46489 = state_46394__$1;
(statearr_46403_46489[(2)] = inst_46389);

(statearr_46403_46489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46395 === (2))){
var _ = (function (){var statearr_46404 = state_46394;
(statearr_46404[(4)] = cljs.core.cons((5),(state_46394[(4)])));

return statearr_46404;
})();
var inst_46368 = (30);
var inst_46370 = fluree.db.dbproto._rootdb(this$);
var inst_46371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46372 = [inst_46368,tag_name];
var inst_46373 = (new cljs.core.PersistentVector(null,2,(5),inst_46371,inst_46372,null));
var inst_46374 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_46370,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_46373);
var state_46394__$1 = state_46394;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46394__$1,(6),inst_46374);
} else {
if((state_val_46395 === (11))){
var inst_46383 = (state_46394[(8)]);
var inst_46387 = inst_46383.s;
var state_46394__$1 = state_46394;
var statearr_46406_46490 = state_46394__$1;
(statearr_46406_46490[(2)] = inst_46387);

(statearr_46406_46490[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46395 === (9))){
var inst_46383 = (state_46394[(8)]);
var inst_46383__$1 = (state_46394[(2)]);
var inst_46384 = (inst_46383__$1 == null);
var state_46394__$1 = (function (){var statearr_46407 = state_46394;
(statearr_46407[(8)] = inst_46383__$1);

return statearr_46407;
})();
if(cljs.core.truth_(inst_46384)){
var statearr_46408_46491 = state_46394__$1;
(statearr_46408_46491[(1)] = (10));

} else {
var statearr_46409_46492 = state_46394__$1;
(statearr_46409_46492[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46395 === (5))){
var _ = (function (){var statearr_46410 = state_46394;
(statearr_46410[(4)] = cljs.core.rest((state_46394[(4)])));

return statearr_46410;
})();
var state_46394__$1 = state_46394;
var ex46405 = (state_46394__$1[(2)]);
var statearr_46411_46493 = state_46394__$1;
(statearr_46411_46493[(5)] = ex46405);


if((ex46405 instanceof Error)){
var statearr_46412_46494 = state_46394__$1;
(statearr_46412_46494[(1)] = (4));

(statearr_46412_46494[(5)] = null);

} else {
throw ex46405;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46395 === (10))){
var state_46394__$1 = state_46394;
var statearr_46413_46495 = state_46394__$1;
(statearr_46413_46495[(2)] = null);

(statearr_46413_46495[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46395 === (8))){
var inst_46377 = (state_46394[(7)]);
var inst_46381 = cljs.core.first(inst_46377);
var state_46394__$1 = state_46394;
var statearr_46414_46496 = state_46394__$1;
(statearr_46414_46496[(2)] = inst_46381);

(statearr_46414_46496[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__17178__auto__ = null;
var fluree$db$graphdb$state_machine__17178__auto____0 = (function (){
var statearr_46415 = [null,null,null,null,null,null,null,null,null];
(statearr_46415[(0)] = fluree$db$graphdb$state_machine__17178__auto__);

(statearr_46415[(1)] = (1));

return statearr_46415;
});
var fluree$db$graphdb$state_machine__17178__auto____1 = (function (state_46394){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_46394);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e46416){var ex__17181__auto__ = e46416;
var statearr_46417_46497 = state_46394;
(statearr_46417_46497[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_46394[(4)]))){
var statearr_46418_46498 = state_46394;
(statearr_46418_46498[(1)] = cljs.core.first((state_46394[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46499 = state_46394;
state_46394 = G__46499;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__17178__auto__ = function(state_46394){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__17178__auto____1.call(this,state_46394);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__17178__auto____0;
fluree$db$graphdb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__17178__auto____1;
return fluree$db$graphdb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_46419 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_46419[(6)] = c__17304__auto__);

return statearr_46419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_46454){
var state_val_46455 = (state_46454[(1)]);
if((state_val_46455 === (7))){
var inst_46433 = typeof pred === 'string';
var state_46454__$1 = state_46454;
if(cljs.core.truth_(inst_46433)){
var statearr_46456_46500 = state_46454__$1;
(statearr_46456_46500[(1)] = (10));

} else {
var statearr_46457_46501 = state_46454__$1;
(statearr_46457_46501[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46455 === (1))){
var state_46454__$1 = state_46454;
var statearr_46458_46502 = state_46454__$1;
(statearr_46458_46502[(2)] = null);

(statearr_46458_46502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46455 === (4))){
var inst_46420 = (state_46454[(2)]);
var state_46454__$1 = state_46454;
var statearr_46459_46503 = state_46454__$1;
(statearr_46459_46503[(2)] = inst_46420);

(statearr_46459_46503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46455 === (15))){
var inst_46447 = (state_46454[(2)]);
var state_46454__$1 = state_46454;
var statearr_46460_46504 = state_46454__$1;
(statearr_46460_46504[(2)] = inst_46447);

(statearr_46460_46504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46455 === (13))){
var inst_46438 = (state_46454[(7)]);
var inst_46440 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46438),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_46441 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_46440);
var state_46454__$1 = state_46454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46454__$1,(16),inst_46441);
} else {
if((state_val_46455 === (6))){
var inst_46428 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_46454__$1 = state_46454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46454__$1,(9),inst_46428);
} else {
if((state_val_46455 === (3))){
var inst_46452 = (state_46454[(2)]);
var state_46454__$1 = state_46454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46454__$1,inst_46452);
} else {
if((state_val_46455 === (12))){
var inst_46438 = (state_46454[(7)]);
var inst_46438__$1 = (state_46454[(2)]);
var state_46454__$1 = (function (){var statearr_46461 = state_46454;
(statearr_46461[(7)] = inst_46438__$1);

return statearr_46461;
})();
if(cljs.core.truth_(inst_46438__$1)){
var statearr_46462_46505 = state_46454__$1;
(statearr_46462_46505[(1)] = (13));

} else {
var statearr_46463_46506 = state_46454__$1;
(statearr_46463_46506[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46455 === (2))){
var _ = (function (){var statearr_46464 = state_46454;
(statearr_46464[(4)] = cljs.core.cons((5),(state_46454[(4)])));

return statearr_46464;
})();
var inst_46426 = clojure.string.includes_QMARK_(tag_name,"/");
var state_46454__$1 = state_46454;
if(inst_46426){
var statearr_46465_46507 = state_46454__$1;
(statearr_46465_46507[(1)] = (6));

} else {
var statearr_46466_46508 = state_46454__$1;
(statearr_46466_46508[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46455 === (11))){
var inst_46436 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_46454__$1 = state_46454;
var statearr_46468_46509 = state_46454__$1;
(statearr_46468_46509[(2)] = inst_46436);

(statearr_46468_46509[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46455 === (9))){
var inst_46430 = (state_46454[(2)]);
var inst_46431 = fluree.db.util.async.throw_err(inst_46430);
var state_46454__$1 = state_46454;
var statearr_46469_46510 = state_46454__$1;
(statearr_46469_46510[(2)] = inst_46431);

(statearr_46469_46510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46455 === (5))){
var _ = (function (){var statearr_46470 = state_46454;
(statearr_46470[(4)] = cljs.core.rest((state_46454[(4)])));

return statearr_46470;
})();
var state_46454__$1 = state_46454;
var ex46467 = (state_46454__$1[(2)]);
var statearr_46471_46511 = state_46454__$1;
(statearr_46471_46511[(5)] = ex46467);


if((ex46467 instanceof Error)){
var statearr_46472_46512 = state_46454__$1;
(statearr_46472_46512[(1)] = (4));

(statearr_46472_46512[(5)] = null);

} else {
throw ex46467;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46455 === (14))){
var state_46454__$1 = state_46454;
var statearr_46473_46513 = state_46454__$1;
(statearr_46473_46513[(2)] = null);

(statearr_46473_46513[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46455 === (16))){
var inst_46443 = (state_46454[(2)]);
var inst_46444 = fluree.db.util.async.throw_err(inst_46443);
var state_46454__$1 = state_46454;
var statearr_46474_46514 = state_46454__$1;
(statearr_46474_46514[(2)] = inst_46444);

(statearr_46474_46514[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46455 === (10))){
var state_46454__$1 = state_46454;
var statearr_46475_46515 = state_46454__$1;
(statearr_46475_46515[(2)] = pred);

(statearr_46475_46515[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46455 === (8))){
var inst_46449 = (state_46454[(2)]);
var _ = (function (){var statearr_46476 = state_46454;
(statearr_46476[(4)] = cljs.core.rest((state_46454[(4)])));

return statearr_46476;
})();
var state_46454__$1 = state_46454;
var statearr_46477_46516 = state_46454__$1;
(statearr_46477_46516[(2)] = inst_46449);

(statearr_46477_46516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__17178__auto__ = null;
var fluree$db$graphdb$state_machine__17178__auto____0 = (function (){
var statearr_46478 = [null,null,null,null,null,null,null,null];
(statearr_46478[(0)] = fluree$db$graphdb$state_machine__17178__auto__);

(statearr_46478[(1)] = (1));

return statearr_46478;
});
var fluree$db$graphdb$state_machine__17178__auto____1 = (function (state_46454){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_46454);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e46479){var ex__17181__auto__ = e46479;
var statearr_46480_46517 = state_46454;
(statearr_46480_46517[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_46454[(4)]))){
var statearr_46481_46518 = state_46454;
(statearr_46481_46518[(1)] = cljs.core.first((state_46454[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46519 = state_46454;
state_46454 = G__46519;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__17178__auto__ = function(state_46454){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__17178__auto____1.call(this,state_46454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__17178__auto____0;
fluree$db$graphdb$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__17178__auto____1;
return fluree$db$graphdb$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_46482 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_46482[(6)] = c__17304__auto__);

return statearr_46482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k46521,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__46525 = k46521;
var G__46525__$1 = (((G__46525 instanceof cljs.core.Keyword))?G__46525.fqn:null);
switch (G__46525__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46521,else__4464__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__46526){
var vec__46527 = p__46526;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46527,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46527,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46520){
var self__ = this;
var G__46520__$1 = this;
return (new cljs.core.RecordIter((0),G__46520__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__46530 = (function (coll__4458__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__46530(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46522,other46523){
var self__ = this;
var this46522__$1 = this;
return (((!((other46523 == null)))) && ((((this46522__$1.constructor === other46523.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.conn,other46523.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.network,other46523.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.dbid,other46523.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.block,other46523.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.t,other46523.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.tt_id,other46523.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.stats,other46523.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.spot,other46523.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.psot,other46523.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.post,other46523.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.opst,other46523.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.schema,other46523.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.settings,other46523.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.index_configs,other46523.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.schema_cache,other46523.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.novelty,other46523.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.permissions,other46523.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.fork,other46523.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.fork_block,other46523.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.current_db_fn,other46523.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46522__$1.__extmap,other46523.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k46521){
var self__ = this;
var this__4468__auto____$1 = this;
var G__46531 = k46521;
var G__46531__$1 = (((G__46531 instanceof cljs.core.Keyword))?G__46531.fqn:null);
switch (G__46531__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k46521);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__46520){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__46532 = cljs.core.keyword_identical_QMARK_;
var expr__46533 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__46535 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__46536 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46535,G__46536) : pred__46532.call(null,G__46535,G__46536));
})())){
return (new fluree.db.graphdb.GraphDb(G__46520,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46537 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__46538 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46537,G__46538) : pred__46532.call(null,G__46537,G__46538));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__46520,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46539 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__46540 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46539,G__46540) : pred__46532.call(null,G__46539,G__46540));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__46520,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46541 = new cljs.core.Keyword(null,"block","block",664686210);
var G__46542 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46541,G__46542) : pred__46532.call(null,G__46541,G__46542));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__46520,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46543 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__46544 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46543,G__46544) : pred__46532.call(null,G__46543,G__46544));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__46520,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46545 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__46546 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46545,G__46546) : pred__46532.call(null,G__46545,G__46546));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__46520,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46547 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__46548 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46547,G__46548) : pred__46532.call(null,G__46547,G__46548));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__46520,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46549 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__46550 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46549,G__46550) : pred__46532.call(null,G__46549,G__46550));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__46520,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46551 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__46552 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46551,G__46552) : pred__46532.call(null,G__46551,G__46552));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__46520,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46553 = new cljs.core.Keyword(null,"post","post",269697687);
var G__46554 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46553,G__46554) : pred__46532.call(null,G__46553,G__46554));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__46520,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46555 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__46556 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46555,G__46556) : pred__46532.call(null,G__46555,G__46556));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__46520,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46557 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__46558 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46557,G__46558) : pred__46532.call(null,G__46557,G__46558));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__46520,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46559 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__46560 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46559,G__46560) : pred__46532.call(null,G__46559,G__46560));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__46520,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46561 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__46562 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46561,G__46562) : pred__46532.call(null,G__46561,G__46562));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__46520,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46563 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__46564 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46563,G__46564) : pred__46532.call(null,G__46563,G__46564));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__46520,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46565 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__46566 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46565,G__46566) : pred__46532.call(null,G__46565,G__46566));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__46520,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46567 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__46568 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46567,G__46568) : pred__46532.call(null,G__46567,G__46568));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__46520,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46569 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__46570 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46569,G__46570) : pred__46532.call(null,G__46569,G__46570));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__46520,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46571 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__46572 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46571,G__46572) : pred__46532.call(null,G__46571,G__46572));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__46520,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__46573 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__46574 = expr__46533;
return (pred__46532.cljs$core$IFn$_invoke$arity$2 ? pred__46532.cljs$core$IFn$_invoke$arity$2(G__46573,G__46574) : pred__46532.call(null,G__46573,G__46574));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__46520,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__46520),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__46520){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__46520,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__46524){
var extmap__4501__auto__ = (function (){var G__46575 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46524,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__46524)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46575);
} else {
return G__46575;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__46524),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__46524),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
