// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47686 = arguments.length;
var i__4819__auto___47687 = (0);
while(true){
if((i__4819__auto___47687 < len__4818__auto___47686)){
args__4824__auto__.push((arguments[i__4819__auto___47687]));

var G__47688 = (i__4819__auto___47687 + (1));
i__4819__auto___47687 = G__47688;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq47683){
var G__47684 = cljs.core.first(seq47683);
var seq47683__$1 = cljs.core.next(seq47683);
var G__47685 = cljs.core.first(seq47683__$1);
var seq47683__$2 = cljs.core.next(seq47683__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47684,G__47685,seq47683__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e47689){var e = e47689;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e47690){var e = e47690;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e47691){var e = e47691;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e47692){var e = e47692;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e47693){var e = e47693;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47696 = arguments.length;
var i__4819__auto___47697 = (0);
while(true){
if((i__4819__auto___47697 < len__4818__auto___47696)){
args__4824__auto__.push((arguments[i__4819__auto___47697]));

var G__47698 = (i__4819__auto___47697 + (1));
i__4819__auto___47697 = G__47698;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e47695){var e = e47695;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq47694){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47694));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47701 = arguments.length;
var i__4819__auto___47702 = (0);
while(true){
if((i__4819__auto___47702 < len__4818__auto___47701)){
args__4824__auto__.push((arguments[i__4819__auto___47702]));

var G__47703 = (i__4819__auto___47702 + (1));
i__4819__auto___47702 = G__47703;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e47700){var e = e47700;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq47699){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47699));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e47704){var e = e47704;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47707 = arguments.length;
var i__4819__auto___47708 = (0);
while(true){
if((i__4819__auto___47708 < len__4818__auto___47707)){
args__4824__auto__.push((arguments[i__4819__auto___47708]));

var G__47709 = (i__4819__auto___47708 + (1));
i__4819__auto___47708 = G__47709;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e47706){var e = e47706;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq47705){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47705));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47712 = arguments.length;
var i__4819__auto___47713 = (0);
while(true){
if((i__4819__auto___47713 < len__4818__auto___47712)){
args__4824__auto__.push((arguments[i__4819__auto___47713]));

var G__47714 = (i__4819__auto___47713 + (1));
i__4819__auto___47713 = G__47714;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e47711){var e = e47711;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq47710){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47710));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e47715){var e = e47715;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e47716){var e = e47716;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47719 = arguments.length;
var i__4819__auto___47720 = (0);
while(true){
if((i__4819__auto___47720 < len__4818__auto___47719)){
args__4824__auto__.push((arguments[i__4819__auto___47720]));

var G__47721 = (i__4819__auto___47720 + (1));
i__4819__auto___47720 = G__47721;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e47718){var e = e47718;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq47717){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47717));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47724 = arguments.length;
var i__4819__auto___47725 = (0);
while(true){
if((i__4819__auto___47725 < len__4818__auto___47724)){
args__4824__auto__.push((arguments[i__4819__auto___47725]));

var G__47726 = (i__4819__auto___47725 + (1));
i__4819__auto___47725 = G__47726;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e47723){var e = e47723;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq47722){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47722));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47729 = arguments.length;
var i__4819__auto___47730 = (0);
while(true){
if((i__4819__auto___47730 < len__4818__auto___47729)){
args__4824__auto__.push((arguments[i__4819__auto___47730]));

var G__47731 = (i__4819__auto___47730 + (1));
i__4819__auto___47730 = G__47731;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e47728){var e = e47728;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq47727){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47727));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47734 = arguments.length;
var i__4819__auto___47735 = (0);
while(true){
if((i__4819__auto___47735 < len__4818__auto___47734)){
args__4824__auto__.push((arguments[i__4819__auto___47735]));

var G__47736 = (i__4819__auto___47735 + (1));
i__4819__auto___47735 = G__47736;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e47733){var e = e47733;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq47732){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47732));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47739 = arguments.length;
var i__4819__auto___47740 = (0);
while(true){
if((i__4819__auto___47740 < len__4818__auto___47739)){
args__4824__auto__.push((arguments[i__4819__auto___47740]));

var G__47741 = (i__4819__auto___47740 + (1));
i__4819__auto___47740 = G__47741;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e47738){var e = e47738;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq47737){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47737));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47744 = arguments.length;
var i__4819__auto___47745 = (0);
while(true){
if((i__4819__auto___47745 < len__4818__auto___47744)){
args__4824__auto__.push((arguments[i__4819__auto___47745]));

var G__47746 = (i__4819__auto___47745 + (1));
i__4819__auto___47745 = G__47746;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e47743){var e = e47743;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq47742){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47742));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___47749 = arguments.length;
var i__4819__auto___47750 = (0);
while(true){
if((i__4819__auto___47750 < len__4818__auto___47749)){
args__4824__auto__.push((arguments[i__4819__auto___47750]));

var G__47751 = (i__4819__auto___47750 + (1));
i__4819__auto___47750 = G__47751;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e47748){var e = e47748;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq47747){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47747));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__47753 = arguments.length;
switch (G__47753) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_47781){
var state_val_47782 = (state_47781[(1)]);
if((state_val_47782 === (7))){
var inst_47766 = (state_47781[(7)]);
var inst_47769 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_47766,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_47781__$1 = state_47781;
var statearr_47783_47869 = state_47781__$1;
(statearr_47783_47869[(2)] = inst_47769);

(statearr_47783_47869[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47782 === (1))){
var state_47781__$1 = state_47781;
var statearr_47784_47870 = state_47781__$1;
(statearr_47784_47870[(2)] = null);

(statearr_47784_47870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47782 === (4))){
var inst_47754 = (state_47781[(2)]);
var state_47781__$1 = state_47781;
var statearr_47785_47871 = state_47781__$1;
(statearr_47785_47871[(2)] = inst_47754);

(statearr_47785_47871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47782 === (6))){
var inst_47766 = (state_47781[(7)]);
var inst_47766__$1 = (state_47781[(2)]);
var inst_47767 = fluree.db.util.core.exception_QMARK_(inst_47766__$1);
var state_47781__$1 = (function (){var statearr_47786 = state_47781;
(statearr_47786[(7)] = inst_47766__$1);

return statearr_47786;
})();
if(inst_47767){
var statearr_47787_47872 = state_47781__$1;
(statearr_47787_47872[(1)] = (7));

} else {
var statearr_47788_47873 = state_47781__$1;
(statearr_47788_47873[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47782 === (3))){
var inst_47779 = (state_47781[(2)]);
var state_47781__$1 = state_47781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47781__$1,inst_47779);
} else {
if((state_val_47782 === (2))){
var inst_47760 = (state_47781[(8)]);
var _ = (function (){var statearr_47790 = state_47781;
(statearr_47790[(4)] = cljs.core.cons((5),(state_47781[(4)])));

return statearr_47790;
})();
var inst_47760__$1 = cljs.core.volatile_BANG_((0));
var inst_47761 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_47762 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_47761,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_47760__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_47763 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_47762);
var inst_47764 = fluree.db.query.fql.query(db,inst_47763);
var state_47781__$1 = (function (){var statearr_47791 = state_47781;
(statearr_47791[(8)] = inst_47760__$1);

return statearr_47791;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47781__$1,(6),inst_47764);
} else {
if((state_val_47782 === (9))){
var inst_47776 = (state_47781[(2)]);
var _ = (function (){var statearr_47792 = state_47781;
(statearr_47792[(4)] = cljs.core.rest((state_47781[(4)])));

return statearr_47792;
})();
var state_47781__$1 = state_47781;
var statearr_47793_47874 = state_47781__$1;
(statearr_47793_47874[(2)] = inst_47776);

(statearr_47793_47874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47782 === (5))){
var _ = (function (){var statearr_47794 = state_47781;
(statearr_47794[(4)] = cljs.core.rest((state_47781[(4)])));

return statearr_47794;
})();
var state_47781__$1 = state_47781;
var ex47789 = (state_47781__$1[(2)]);
var statearr_47795_47875 = state_47781__$1;
(statearr_47795_47875[(5)] = ex47789);


if((ex47789 instanceof Error)){
var statearr_47796_47876 = state_47781__$1;
(statearr_47796_47876[(1)] = (4));

(statearr_47796_47876[(5)] = null);

} else {
throw ex47789;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47782 === (8))){
var inst_47766 = (state_47781[(7)]);
var inst_47760 = (state_47781[(8)]);
var inst_47771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47772 = cljs.core.deref(inst_47760);
var inst_47773 = [inst_47766,inst_47772];
var inst_47774 = (new cljs.core.PersistentVector(null,2,(5),inst_47771,inst_47773,null));
var state_47781__$1 = state_47781;
var statearr_47797_47877 = state_47781__$1;
(statearr_47797_47877[(2)] = inst_47774);

(statearr_47797_47877[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__17178__auto____0 = (function (){
var statearr_47798 = [null,null,null,null,null,null,null,null,null];
(statearr_47798[(0)] = fluree$db$dbfunctions$internal$state_machine__17178__auto__);

(statearr_47798[(1)] = (1));

return statearr_47798;
});
var fluree$db$dbfunctions$internal$state_machine__17178__auto____1 = (function (state_47781){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_47781);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e47799){var ex__17181__auto__ = e47799;
var statearr_47800_47878 = state_47781;
(statearr_47800_47878[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_47781[(4)]))){
var statearr_47801_47879 = state_47781;
(statearr_47801_47879[(1)] = cljs.core.first((state_47781[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47880 = state_47781;
state_47781 = G__47880;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__17178__auto__ = function(state_47781){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__17178__auto____1.call(this,state_47781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__17178__auto____0;
fluree$db$dbfunctions$internal$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__17178__auto____1;
return fluree$db$dbfunctions$internal$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_47802 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_47802[(6)] = c__17304__auto__);

return statearr_47802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_47847){
var state_val_47848 = (state_47847[(1)]);
if((state_val_47848 === (7))){
var inst_47833 = (state_47847[(2)]);
var inst_47834 = fluree.db.query.fql.query(db,inst_47833);
var state_47847__$1 = state_47847;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47847__$1,(8),inst_47834);
} else {
if((state_val_47848 === (1))){
var inst_47803 = typeof select === 'string';
var state_47847__$1 = state_47847;
if(cljs.core.truth_(inst_47803)){
var statearr_47849_47881 = state_47847__$1;
(statearr_47849_47881[(1)] = (2));

} else {
var statearr_47850_47882 = state_47847__$1;
(statearr_47850_47882[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47848 === (4))){
var inst_47809 = (state_47847[(7)]);
var inst_47816 = (state_47847[(8)]);
var inst_47808 = (state_47847[(2)]);
var inst_47809__$1 = cljs.core.volatile_BANG_((0));
var inst_47810 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_47811 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_47812 = [inst_47809__$1,(100000)];
var inst_47813 = cljs.core.PersistentHashMap.fromArrays(inst_47811,inst_47812);
var inst_47814 = [inst_47808,from,where,block,limit,inst_47813];
var inst_47815 = cljs.core.PersistentHashMap.fromArrays(inst_47810,inst_47814);
var inst_47816__$1 = fluree.db.util.core.without_nils(inst_47815);
var inst_47817 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_47816__$1);
var inst_47818 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_47816__$1);
var inst_47819 = cljs.core.first(inst_47818);
var inst_47820 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47819], 0));
var inst_47821 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_47820);
var inst_47822 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_47816__$1);
var inst_47823 = cljs.core.last(inst_47822);
var inst_47824 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47823], 0));
var inst_47825 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_47824);
var inst_47826 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47817,inst_47821,inst_47825], 0));
var state_47847__$1 = (function (){var statearr_47851 = state_47847;
(statearr_47851[(7)] = inst_47809__$1);

(statearr_47851[(8)] = inst_47816__$1);

return statearr_47851;
})();
if(cljs.core.truth_(inst_47826)){
var statearr_47852_47883 = state_47847__$1;
(statearr_47852_47883[(1)] = (5));

} else {
var statearr_47853_47884 = state_47847__$1;
(statearr_47853_47884[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47848 === (6))){
var inst_47816 = (state_47847[(8)]);
var state_47847__$1 = state_47847;
var statearr_47854_47885 = state_47847__$1;
(statearr_47854_47885[(2)] = inst_47816);

(statearr_47854_47885[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47848 === (3))){
var state_47847__$1 = state_47847;
var statearr_47855_47886 = state_47847__$1;
(statearr_47855_47886[(2)] = select);

(statearr_47855_47886[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47848 === (2))){
var inst_47805 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_47847__$1 = state_47847;
var statearr_47856_47887 = state_47847__$1;
(statearr_47856_47887[(2)] = inst_47805);

(statearr_47856_47887[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47848 === (11))){
var inst_47845 = (state_47847[(2)]);
var state_47847__$1 = state_47847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47847__$1,inst_47845);
} else {
if((state_val_47848 === (9))){
var inst_47836 = (state_47847[(9)]);
var state_47847__$1 = state_47847;
var statearr_47857_47888 = state_47847__$1;
(statearr_47857_47888[(2)] = inst_47836);

(statearr_47857_47888[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47848 === (5))){
var inst_47816 = (state_47847[(8)]);
var inst_47828 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_47816);
var inst_47829 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_47828);
var inst_47830 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_47816,new cljs.core.Keyword(null,"where","where",-2044795965),inst_47829);
var state_47847__$1 = state_47847;
var statearr_47858_47889 = state_47847__$1;
(statearr_47858_47889[(2)] = inst_47830);

(statearr_47858_47889[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47848 === (10))){
var inst_47809 = (state_47847[(7)]);
var inst_47836 = (state_47847[(9)]);
var inst_47840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47841 = cljs.core.deref(inst_47809);
var inst_47842 = [inst_47836,inst_47841];
var inst_47843 = (new cljs.core.PersistentVector(null,2,(5),inst_47840,inst_47842,null));
var state_47847__$1 = state_47847;
var statearr_47859_47890 = state_47847__$1;
(statearr_47859_47890[(2)] = inst_47843);

(statearr_47859_47890[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47848 === (8))){
var inst_47836 = (state_47847[(9)]);
var inst_47836__$1 = (state_47847[(2)]);
var inst_47837 = fluree.db.util.core.exception_QMARK_(inst_47836__$1);
var state_47847__$1 = (function (){var statearr_47860 = state_47847;
(statearr_47860[(9)] = inst_47836__$1);

return statearr_47860;
})();
if(inst_47837){
var statearr_47861_47891 = state_47847__$1;
(statearr_47861_47891[(1)] = (9));

} else {
var statearr_47862_47892 = state_47847__$1;
(statearr_47862_47892[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__17178__auto____0 = (function (){
var statearr_47863 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47863[(0)] = fluree$db$dbfunctions$internal$state_machine__17178__auto__);

(statearr_47863[(1)] = (1));

return statearr_47863;
});
var fluree$db$dbfunctions$internal$state_machine__17178__auto____1 = (function (state_47847){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_47847);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e47864){var ex__17181__auto__ = e47864;
var statearr_47865_47893 = state_47847;
(statearr_47865_47893[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_47847[(4)]))){
var statearr_47866_47894 = state_47847;
(statearr_47866_47894[(1)] = cljs.core.first((state_47847[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47895 = state_47847;
state_47847 = G__47895;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__17178__auto__ = function(state_47847){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__17178__auto____1.call(this,state_47847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__17178__auto____0;
fluree$db$dbfunctions$internal$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__17178__auto____1;
return fluree$db$dbfunctions$internal$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_47867 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_47867[(6)] = c__17304__auto__);

return statearr_47867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__47899 = path;
var vec__47900 = G__47899;
var seq__47901 = cljs.core.seq(vec__47900);
var first__47902 = cljs.core.first(seq__47901);
var seq__47901__$1 = cljs.core.next(seq__47901);
var var$ = first__47902;
var r = seq__47901__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__47899__$1 = G__47899;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__47906 = G__47899__$1;
var seq__47907 = cljs.core.seq(vec__47906);
var first__47908 = cljs.core.first(seq__47907);
var seq__47907__$1 = cljs.core.next(seq__47907);
var var$__$1 = first__47908;
var r__$1 = seq__47907__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__47909 = r__$1;
var G__47910 = n__$2;
var G__47911 = next_clauses;
G__47899__$1 = G__47909;
n__$1 = G__47910;
where_clauses__$1 = G__47911;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__47912 = r__$1;
var G__47913 = next_n;
var G__47914 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__47899__$1 = G__47912;
n__$1 = G__47913;
where_clauses__$1 = G__47914;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_47951){
var state_val_47952 = (state_47951[(1)]);
if((state_val_47952 === (7))){
var inst_47924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47925 = [path];
var inst_47926 = (new cljs.core.PersistentVector(null,1,(5),inst_47924,inst_47925,null));
var state_47951__$1 = state_47951;
var statearr_47953_47981 = state_47951__$1;
(statearr_47953_47981[(2)] = inst_47926);

(statearr_47953_47981[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47952 === (1))){
var state_47951__$1 = state_47951;
var statearr_47954_47982 = state_47951__$1;
(statearr_47954_47982[(2)] = null);

(statearr_47954_47982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47952 === (4))){
var inst_47915 = (state_47951[(2)]);
var state_47951__$1 = state_47951;
var statearr_47955_47983 = state_47951__$1;
(statearr_47955_47983[(2)] = inst_47915);

(statearr_47955_47983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47952 === (13))){
var inst_47942 = (state_47951[(2)]);
var inst_47943 = fluree.db.util.async.throw_err(inst_47942);
var _ = (function (){var statearr_47956 = state_47951;
(statearr_47956[(4)] = cljs.core.rest((state_47951[(4)])));

return statearr_47956;
})();
var state_47951__$1 = state_47951;
var statearr_47957_47984 = state_47951__$1;
(statearr_47957_47984[(2)] = inst_47943);

(statearr_47957_47984[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47952 === (6))){
var state_47951__$1 = state_47951;
var statearr_47959_47985 = state_47951__$1;
(statearr_47959_47985[(2)] = path);

(statearr_47959_47985[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47952 === (3))){
var inst_47949 = (state_47951[(2)]);
var state_47951__$1 = state_47951;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47951__$1,inst_47949);
} else {
if((state_val_47952 === (12))){
var _ = (function (){var statearr_47960 = state_47951;
(statearr_47960[(4)] = cljs.core.rest((state_47951[(4)])));

return statearr_47960;
})();
var state_47951__$1 = state_47951;
var ex47958 = (state_47951__$1[(2)]);
var statearr_47961_47986 = state_47951__$1;
(statearr_47961_47986[(5)] = ex47958);


var statearr_47962_47987 = state_47951__$1;
(statearr_47962_47987[(1)] = (11));

(statearr_47962_47987[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47952 === (2))){
var _ = (function (){var statearr_47963 = state_47951;
(statearr_47963[(4)] = cljs.core.cons((5),(state_47951[(4)])));

return statearr_47963;
})();
var inst_47921 = cljs.core.vector_QMARK_(path);
var state_47951__$1 = state_47951;
if(inst_47921){
var statearr_47964_47988 = state_47951__$1;
(statearr_47964_47988[(1)] = (6));

} else {
var statearr_47965_47989 = state_47951__$1;
(statearr_47965_47989[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47952 === (11))){
var inst_47928 = (state_47951[(7)]);
var inst_47933 = (state_47951[(2)]);
var inst_47934 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_47933,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_47928,endSubject], 0));
var state_47951__$1 = state_47951;
var statearr_47967_47990 = state_47951__$1;
(statearr_47967_47990[(2)] = inst_47934);

(statearr_47967_47990[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47952 === (9))){
var inst_47932 = (state_47951[(8)]);
var _ = (function (){var statearr_47968 = state_47951;
(statearr_47968[(4)] = cljs.core.cons((12),(state_47951[(4)])));

return statearr_47968;
})();
var inst_47940 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_47932);
var state_47951__$1 = state_47951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47951__$1,(13),inst_47940);
} else {
if((state_val_47952 === (5))){
var _ = (function (){var statearr_47969 = state_47951;
(statearr_47969[(4)] = cljs.core.rest((state_47951[(4)])));

return statearr_47969;
})();
var state_47951__$1 = state_47951;
var ex47966 = (state_47951__$1[(2)]);
var statearr_47970_47991 = state_47951__$1;
(statearr_47970_47991[(5)] = ex47966);


if((ex47966 instanceof Error)){
var statearr_47971_47992 = state_47951__$1;
(statearr_47971_47992[(1)] = (4));

(statearr_47971_47992[(5)] = null);

} else {
throw ex47966;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47952 === (10))){
var inst_47946 = (state_47951[(2)]);
var _ = (function (){var statearr_47972 = state_47951;
(statearr_47972[(4)] = cljs.core.rest((state_47951[(4)])));

return statearr_47972;
})();
var state_47951__$1 = state_47951;
var statearr_47973_47993 = state_47951__$1;
(statearr_47973_47993[(2)] = inst_47946);

(statearr_47973_47993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47952 === (8))){
var inst_47928 = (state_47951[(7)]);
var inst_47928__$1 = (state_47951[(2)]);
var inst_47929 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_47928__$1,endSubject);
var inst_47930 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_47931 = ["?var1",inst_47929];
var inst_47932 = cljs.core.PersistentHashMap.fromArrays(inst_47930,inst_47931);
var state_47951__$1 = (function (){var statearr_47974 = state_47951;
(statearr_47974[(8)] = inst_47932);

(statearr_47974[(7)] = inst_47928__$1);

return statearr_47974;
})();
var statearr_47975_47994 = state_47951__$1;
(statearr_47975_47994[(2)] = null);

(statearr_47975_47994[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17178__auto____0 = (function (){
var statearr_47976 = [null,null,null,null,null,null,null,null,null];
(statearr_47976[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17178__auto__);

(statearr_47976[(1)] = (1));

return statearr_47976;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17178__auto____1 = (function (state_47951){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_47951);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e47977){var ex__17181__auto__ = e47977;
var statearr_47978_47995 = state_47951;
(statearr_47978_47995[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_47951[(4)]))){
var statearr_47979_47996 = state_47951;
(statearr_47979_47996[(1)] = cljs.core.first((state_47951[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47997 = state_47951;
state_47951 = G__47997;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17178__auto__ = function(state_47951){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17178__auto____1.call(this,state_47951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17178__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_47980 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_47980[(6)] = c__17304__auto__);

return statearr_47980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e47998){var e = e47998;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e47999){var e = e47999;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e48000){var e = e48000;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e48001){var e = e48001;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___48004 = arguments.length;
var i__4819__auto___48005 = (0);
while(true){
if((i__4819__auto___48005 < len__4818__auto___48004)){
args__4824__auto__.push((arguments[i__4819__auto___48005]));

var G__48006 = (i__4819__auto___48005 + (1));
i__4819__auto___48005 = G__48006;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e48003){var e = e48003;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq48002){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq48002));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___48009 = arguments.length;
var i__4819__auto___48010 = (0);
while(true){
if((i__4819__auto___48010 < len__4818__auto___48009)){
args__4824__auto__.push((arguments[i__4819__auto___48010]));

var G__48011 = (i__4819__auto___48010 + (1));
i__4819__auto___48010 = G__48011;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e48008){var e = e48008;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq48007){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq48007));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___48014 = arguments.length;
var i__4819__auto___48015 = (0);
while(true){
if((i__4819__auto___48015 < len__4818__auto___48014)){
args__4824__auto__.push((arguments[i__4819__auto___48015]));

var G__48016 = (i__4819__auto___48015 + (1));
i__4819__auto___48015 = G__48016;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4212__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e48013){var e = e48013;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq48012){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq48012));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___48019 = arguments.length;
var i__4819__auto___48020 = (0);
while(true){
if((i__4819__auto___48020 < len__4818__auto___48019)){
args__4824__auto__.push((arguments[i__4819__auto___48020]));

var G__48021 = (i__4819__auto___48020 + (1));
i__4819__auto___48020 = G__48021;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e48018){var e = e48018;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq48017){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq48017));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e48022){var e = e48022;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e48023){var e = e48023;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e48024){var e = e48024;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e48025){var e = e48025;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e48026){var e = e48026;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__48032 = path;
var vec__48033 = G__48032;
var seq__48034 = cljs.core.seq(vec__48033);
var first__48035 = cljs.core.first(seq__48034);
var seq__48034__$1 = cljs.core.next(seq__48034);
var pred = first__48035;
var r = seq__48034__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__48032__$1 = G__48032;
var subjects__$1 = subjects;
while(true){
var vec__48039 = G__48032__$1;
var seq__48040 = cljs.core.seq(vec__48039);
var first__48041 = cljs.core.first(seq__48040);
var seq__48040__$1 = cljs.core.next(seq__48040);
var pred__$1 = first__48041;
var r__$1 = seq__48040__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__48032__$1,subjects__$1,vec__48039,seq__48040,first__48041,seq__48040__$1,pred__$1,r__$1,subjects__$2,G__48032,vec__48033,seq__48034,first__48035,seq__48034__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__48032__$1,subjects__$1,vec__48039,seq__48040,first__48041,seq__48040__$1,pred__$1,r__$1,subjects__$2,G__48032,vec__48033,seq__48034,first__48035,seq__48034__$1,pred,r,subjects){
return (function (p1__48027_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__48027_SHARP_,pred__$1);
});})(G__48032__$1,subjects__$1,vec__48039,seq__48040,first__48041,seq__48040__$1,pred__$1,r__$1,subjects__$2,G__48032,vec__48033,seq__48034,first__48035,seq__48034__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__48032__$1,subjects__$1,vec__48039,seq__48040,first__48041,seq__48040__$1,pred__$1,r__$1,subjects__$2,G__48032,vec__48033,seq__48034,first__48035,seq__48034__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4210__auto__ = r__$1;
if(and__4210__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4210__auto__;
}
})())){
var G__48042 = r__$1;
var G__48043 = next_subjects;
G__48032__$1 = G__48042;
subjects__$1 = G__48043;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e48028){var e = e48028;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e48044){var e = e48044;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e48045){var e = e48045;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___48048 = arguments.length;
var i__4819__auto___48049 = (0);
while(true){
if((i__4819__auto___48049 < len__4818__auto___48048)){
args__4824__auto__.push((arguments[i__4819__auto___48049]));

var G__48050 = (i__4819__auto___48049 + (1));
i__4819__auto___48049 = G__48050;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e48047){var e = e48047;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq48046){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq48046));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e48051){var e = e48051;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___48054 = arguments.length;
var i__4819__auto___48055 = (0);
while(true){
if((i__4819__auto___48055 < len__4818__auto___48054)){
args__4824__auto__.push((arguments[i__4819__auto___48055]));

var G__48056 = (i__4819__auto___48055 + (1));
i__4819__auto___48055 = G__48056;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e48053){var e = e48053;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq48052){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq48052));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e48057){var e = e48057;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_48114){
var state_val_48115 = (state_48114[(1)]);
if((state_val_48115 === (7))){
var inst_48060 = (state_48114[(2)]);
var state_48114__$1 = state_48114;
var statearr_48116_48150 = state_48114__$1;
(statearr_48116_48150[(2)] = inst_48060);

(statearr_48116_48150[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (1))){
var state_48114__$1 = state_48114;
var statearr_48117_48151 = state_48114__$1;
(statearr_48117_48151[(2)] = null);

(statearr_48117_48151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (4))){
var inst_48059 = (state_48114[(2)]);
var state_48114__$1 = (function (){var statearr_48118 = state_48114;
(statearr_48118[(7)] = inst_48059);

return statearr_48118;
})();
var statearr_48119_48152 = state_48114__$1;
(statearr_48119_48152[(2)] = null);

(statearr_48119_48152[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (15))){
var inst_48097 = (state_48114[(8)]);
var inst_48094 = (state_48114[(9)]);
var inst_48082 = (state_48114[(10)]);
var inst_48084 = (state_48114[(11)]);
var inst_48095 = (state_48114[(12)]);
var inst_48085 = (state_48114[(13)]);
var inst_48101 = (function (){var db = inst_48082;
var prevT = inst_48084;
var db_SINGLEQUOTE_ = inst_48085;
var prev_vals = inst_48094;
var fuel = inst_48095;
var G__48096 = inst_48097;
return (function (p1__48058_SHARP_){
var f = p1__48058_SHARP_;
return f.o;
});
})();
var inst_48102 = (inst_48101.cljs$core$IFn$_invoke$arity$1 ? inst_48101.cljs$core$IFn$_invoke$arity$1(inst_48097) : inst_48101.call(null,inst_48097));
var state_48114__$1 = state_48114;
var statearr_48120_48153 = state_48114__$1;
(statearr_48120_48153[(2)] = inst_48102);

(statearr_48120_48153[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (13))){
var inst_48097 = (state_48114[(8)]);
var inst_48094 = (state_48114[(9)]);
var inst_48093 = (state_48114[(2)]);
var inst_48094__$1 = fluree.db.util.async.throw_err(inst_48093);
var inst_48095 = fluree.db.dbfunctions.internal.count(inst_48094__$1);
var inst_48097__$1 = cljs.core.first(inst_48094__$1);
var inst_48098 = (inst_48097__$1 == null);
var state_48114__$1 = (function (){var statearr_48121 = state_48114;
(statearr_48121[(8)] = inst_48097__$1);

(statearr_48121[(9)] = inst_48094__$1);

(statearr_48121[(12)] = inst_48095);

return statearr_48121;
})();
if(cljs.core.truth_(inst_48098)){
var statearr_48122_48154 = state_48114__$1;
(statearr_48122_48154[(1)] = (14));

} else {
var statearr_48123_48155 = state_48114__$1;
(statearr_48123_48155[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (6))){
var inst_48069 = (state_48114[(2)]);
var state_48114__$1 = state_48114;
var statearr_48124_48156 = state_48114__$1;
(statearr_48124_48156[(2)] = inst_48069);

(statearr_48124_48156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (3))){
var inst_48112 = (state_48114[(2)]);
var state_48114__$1 = state_48114;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48114__$1,inst_48112);
} else {
if((state_val_48115 === (12))){
var inst_48109 = (state_48114[(2)]);
var _ = (function (){var statearr_48125 = state_48114;
(statearr_48125[(4)] = cljs.core.rest((state_48114[(4)])));

return statearr_48125;
})();
var state_48114__$1 = state_48114;
var statearr_48126_48157 = state_48114__$1;
(statearr_48126_48157[(2)] = inst_48109);

(statearr_48126_48157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (2))){
var _ = (function (){var statearr_48128 = state_48114;
(statearr_48128[(4)] = cljs.core.cons((9),(state_48114[(4)])));

return statearr_48128;
})();
var inst_48075 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_48076 = typeof inst_48075 === 'string';
var state_48114__$1 = state_48114;
if(cljs.core.truth_(inst_48076)){
var statearr_48129_48158 = state_48114__$1;
(statearr_48129_48158[(1)] = (10));

} else {
var statearr_48130_48159 = state_48114__$1;
(statearr_48130_48159[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (11))){
var inst_48082 = (state_48114[(10)]);
var inst_48084 = (state_48114[(11)]);
var inst_48085 = (state_48114[(13)]);
var inst_48082__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_48083 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_48082__$1);
var inst_48084__$1 = fluree.db.dbfunctions.internal.inc(inst_48083);
var inst_48085__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_48082__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_48084__$1);
var inst_48086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48087 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_48088 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_48089 = [inst_48087,inst_48088];
var inst_48090 = (new cljs.core.PersistentVector(null,2,(5),inst_48086,inst_48089,null));
var inst_48091 = fluree.db.dbproto._search(inst_48085__$1,inst_48090);
var state_48114__$1 = (function (){var statearr_48131 = state_48114;
(statearr_48131[(10)] = inst_48082__$1);

(statearr_48131[(11)] = inst_48084__$1);

(statearr_48131[(13)] = inst_48085__$1);

return statearr_48131;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48114__$1,(13),inst_48091);
} else {
if((state_val_48115 === (9))){
var _ = (function (){var statearr_48132 = state_48114;
(statearr_48132[(4)] = cljs.core.rest((state_48114[(4)])));

return statearr_48132;
})();
var state_48114__$1 = state_48114;
var ex48127 = (state_48114__$1[(2)]);
var statearr_48133_48160 = state_48114__$1;
(statearr_48133_48160[(5)] = ex48127);


var statearr_48134_48161 = state_48114__$1;
(statearr_48134_48161[(1)] = (4));

(statearr_48134_48161[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (5))){
var inst_48059 = (state_48114[(7)]);
var _ = (function (){var statearr_48135 = state_48114;
(statearr_48135[(4)] = cljs.core.cons((8),(state_48114[(4)])));

return statearr_48135;
})();
var inst_48066 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_48059,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_48136 = state_48114;
(statearr_48136[(4)] = cljs.core.rest((state_48114[(4)])));

return statearr_48136;
})();
var state_48114__$1 = state_48114;
var statearr_48137_48162 = state_48114__$1;
(statearr_48137_48162[(2)] = inst_48066);

(statearr_48137_48162[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (14))){
var state_48114__$1 = state_48114;
var statearr_48138_48163 = state_48114__$1;
(statearr_48138_48163[(2)] = null);

(statearr_48138_48163[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (16))){
var inst_48095 = (state_48114[(12)]);
var inst_48104 = (state_48114[(2)]);
var inst_48105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48106 = [inst_48104,inst_48095];
var inst_48107 = (new cljs.core.PersistentVector(null,2,(5),inst_48105,inst_48106,null));
var state_48114__$1 = state_48114;
var statearr_48140_48164 = state_48114__$1;
(statearr_48140_48164[(2)] = inst_48107);

(statearr_48140_48164[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (10))){
var inst_48078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48079 = [null,(0)];
var inst_48080 = (new cljs.core.PersistentVector(null,2,(5),inst_48078,inst_48079,null));
var state_48114__$1 = state_48114;
var statearr_48141_48165 = state_48114__$1;
(statearr_48141_48165[(2)] = inst_48080);

(statearr_48141_48165[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48115 === (8))){
var _ = (function (){var statearr_48142 = state_48114;
(statearr_48142[(4)] = cljs.core.rest((state_48114[(4)])));

return statearr_48142;
})();
var state_48114__$1 = state_48114;
var ex48139 = (state_48114__$1[(2)]);
var statearr_48143_48166 = state_48114__$1;
(statearr_48143_48166[(5)] = ex48139);


var statearr_48144_48167 = state_48114__$1;
(statearr_48144_48167[(1)] = (7));

(statearr_48144_48167[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17178__auto____0 = (function (){
var statearr_48145 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48145[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17178__auto__);

(statearr_48145[(1)] = (1));

return statearr_48145;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17178__auto____1 = (function (state_48114){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_48114);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e48146){var ex__17181__auto__ = e48146;
var statearr_48147_48168 = state_48114;
(statearr_48147_48168[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_48114[(4)]))){
var statearr_48148_48169 = state_48114;
(statearr_48148_48169[(1)] = cljs.core.first((state_48114[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48170 = state_48114;
state_48114 = G__48170;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17178__auto__ = function(state_48114){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17178__auto____1.call(this,state_48114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_48149 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_48149[(6)] = c__17304__auto__);

return statearr_48149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_48222){
var state_val_48223 = (state_48222[(1)]);
if((state_val_48223 === (7))){
var inst_48172 = (state_48222[(2)]);
var state_48222__$1 = state_48222;
var statearr_48224_48253 = state_48222__$1;
(statearr_48224_48253[(2)] = inst_48172);

(statearr_48224_48253[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48223 === (1))){
var state_48222__$1 = state_48222;
var statearr_48225_48254 = state_48222__$1;
(statearr_48225_48254[(2)] = null);

(statearr_48225_48254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48223 === (4))){
var inst_48171 = (state_48222[(2)]);
var state_48222__$1 = (function (){var statearr_48226 = state_48222;
(statearr_48226[(7)] = inst_48171);

return statearr_48226;
})();
var statearr_48227_48255 = state_48222__$1;
(statearr_48227_48255[(2)] = null);

(statearr_48227_48255[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48223 === (13))){
var inst_48217 = (state_48222[(2)]);
var _ = (function (){var statearr_48228 = state_48222;
(statearr_48228[(4)] = cljs.core.rest((state_48222[(4)])));

return statearr_48228;
})();
var state_48222__$1 = state_48222;
var statearr_48229_48256 = state_48222__$1;
(statearr_48229_48256[(2)] = inst_48217);

(statearr_48229_48256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48223 === (6))){
var inst_48181 = (state_48222[(2)]);
var state_48222__$1 = state_48222;
var statearr_48230_48257 = state_48222__$1;
(statearr_48230_48257[(2)] = inst_48181);

(statearr_48230_48257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48223 === (3))){
var inst_48220 = (state_48222[(2)]);
var state_48222__$1 = state_48222;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48222__$1,inst_48220);
} else {
if((state_val_48223 === (12))){
var inst_48204 = (state_48222[(8)]);
var inst_48213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48214 = [null,inst_48204];
var inst_48215 = (new cljs.core.PersistentVector(null,2,(5),inst_48213,inst_48214,null));
var state_48222__$1 = state_48222;
var statearr_48231_48258 = state_48222__$1;
(statearr_48231_48258[(2)] = inst_48215);

(statearr_48231_48258[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48223 === (2))){
var _ = (function (){var statearr_48233 = state_48222;
(statearr_48233[(4)] = cljs.core.cons((9),(state_48222[(4)])));

return statearr_48233;
})();
var inst_48190 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_48191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48193 = [null,pred_name,"?o"];
var inst_48194 = (new cljs.core.PersistentVector(null,3,(5),inst_48192,inst_48193,null));
var inst_48195 = [inst_48194];
var inst_48196 = (new cljs.core.PersistentVector(null,1,(5),inst_48191,inst_48195,null));
var inst_48197 = ["?o",inst_48196,opts];
var inst_48198 = cljs.core.PersistentHashMap.fromArrays(inst_48190,inst_48197);
var inst_48199 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_48198);
var state_48222__$1 = state_48222;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48222__$1,(10),inst_48199);
} else {
if((state_val_48223 === (11))){
var inst_48204 = (state_48222[(8)]);
var inst_48203 = (state_48222[(9)]);
var inst_48208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48209 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_48203);
var inst_48210 = [inst_48209,inst_48204];
var inst_48211 = (new cljs.core.PersistentVector(null,2,(5),inst_48208,inst_48210,null));
var state_48222__$1 = state_48222;
var statearr_48234_48259 = state_48222__$1;
(statearr_48234_48259[(2)] = inst_48211);

(statearr_48234_48259[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48223 === (9))){
var _ = (function (){var statearr_48235 = state_48222;
(statearr_48235[(4)] = cljs.core.rest((state_48222[(4)])));

return statearr_48235;
})();
var state_48222__$1 = state_48222;
var ex48232 = (state_48222__$1[(2)]);
var statearr_48236_48260 = state_48222__$1;
(statearr_48236_48260[(5)] = ex48232);


var statearr_48237_48261 = state_48222__$1;
(statearr_48237_48261[(1)] = (4));

(statearr_48237_48261[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48223 === (5))){
var inst_48171 = (state_48222[(7)]);
var _ = (function (){var statearr_48239 = state_48222;
(statearr_48239[(4)] = cljs.core.cons((8),(state_48222[(4)])));

return statearr_48239;
})();
var inst_48178 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_48171,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_48240 = state_48222;
(statearr_48240[(4)] = cljs.core.rest((state_48222[(4)])));

return statearr_48240;
})();
var state_48222__$1 = state_48222;
var statearr_48241_48262 = state_48222__$1;
(statearr_48241_48262[(2)] = inst_48178);

(statearr_48241_48262[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48223 === (10))){
var inst_48203 = (state_48222[(9)]);
var inst_48201 = (state_48222[(2)]);
var inst_48202 = fluree.db.util.async.throw_err(inst_48201);
var inst_48203__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48202,(0),null);
var inst_48204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48202,(1),null);
var inst_48205 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_48203__$1);
var inst_48206 = cljs.core.not(inst_48205);
var state_48222__$1 = (function (){var statearr_48242 = state_48222;
(statearr_48242[(8)] = inst_48204);

(statearr_48242[(9)] = inst_48203__$1);

return statearr_48242;
})();
if(inst_48206){
var statearr_48243_48263 = state_48222__$1;
(statearr_48243_48263[(1)] = (11));

} else {
var statearr_48244_48264 = state_48222__$1;
(statearr_48244_48264[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48223 === (8))){
var _ = (function (){var statearr_48245 = state_48222;
(statearr_48245[(4)] = cljs.core.rest((state_48222[(4)])));

return statearr_48245;
})();
var state_48222__$1 = state_48222;
var ex48238 = (state_48222__$1[(2)]);
var statearr_48246_48265 = state_48222__$1;
(statearr_48246_48265[(5)] = ex48238);


var statearr_48247_48266 = state_48222__$1;
(statearr_48247_48266[(1)] = (7));

(statearr_48247_48266[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17178__auto____0 = (function (){
var statearr_48248 = [null,null,null,null,null,null,null,null,null,null];
(statearr_48248[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17178__auto__);

(statearr_48248[(1)] = (1));

return statearr_48248;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17178__auto____1 = (function (state_48222){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_48222);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e48249){var ex__17181__auto__ = e48249;
var statearr_48250_48267 = state_48222;
(statearr_48250_48267[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_48222[(4)]))){
var statearr_48251_48268 = state_48222;
(statearr_48251_48268[(1)] = cljs.core.first((state_48222[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48269 = state_48222;
state_48222 = G__48269;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17178__auto__ = function(state_48222){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17178__auto____1.call(this,state_48222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_48252 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_48252[(6)] = c__17304__auto__);

return statearr_48252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4210__auto__ = typeof email === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4210__auto__;
}
})());
}catch (e48270){var e = e48270;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__48272 = arguments.length;
switch (G__48272) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_48342){
var state_val_48343 = (state_48342[(1)]);
if((state_val_48343 === (7))){
var inst_48274 = (state_48342[(2)]);
var state_48342__$1 = state_48342;
var statearr_48344_48388 = state_48342__$1;
(statearr_48344_48388[(2)] = inst_48274);

(statearr_48344_48388[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (20))){
var inst_48318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48319 = ["*"];
var inst_48320 = (new cljs.core.PersistentVector(null,1,(5),inst_48318,inst_48319,null));
var state_48342__$1 = state_48342;
var statearr_48345_48389 = state_48342__$1;
(statearr_48345_48389[(2)] = inst_48320);

(statearr_48345_48389[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (1))){
var state_48342__$1 = state_48342;
var statearr_48346_48390 = state_48342__$1;
(statearr_48346_48390[(2)] = null);

(statearr_48346_48390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (4))){
var inst_48273 = (state_48342[(2)]);
var state_48342__$1 = (function (){var statearr_48347 = state_48342;
(statearr_48347[(7)] = inst_48273);

return statearr_48347;
})();
var statearr_48348_48391 = state_48342__$1;
(statearr_48348_48391[(2)] = null);

(statearr_48348_48391[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (15))){
var inst_48337 = (state_48342[(2)]);
var _ = (function (){var statearr_48349 = state_48342;
(statearr_48349[(4)] = cljs.core.rest((state_48342[(4)])));

return statearr_48349;
})();
var state_48342__$1 = state_48342;
var statearr_48350_48392 = state_48342__$1;
(statearr_48350_48392[(2)] = inst_48337);

(statearr_48350_48392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (21))){
var inst_48301 = (state_48342[(8)]);
var inst_48308 = (state_48342[(9)]);
var inst_48322 = (state_48342[(2)]);
var inst_48323 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_48324 = cljs.core.PersistentHashMap.EMPTY;
var inst_48325 = [inst_48322,inst_48308,inst_48324];
var inst_48326 = cljs.core.PersistentHashMap.fromArrays(inst_48323,inst_48325);
var inst_48327 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_48301,inst_48326);
var state_48342__$1 = state_48342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48342__$1,(22),inst_48327);
} else {
if((state_val_48343 === (13))){
var inst_48296 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_48342__$1 = state_48342;
var statearr_48351_48393 = state_48342__$1;
(statearr_48351_48393[(2)] = inst_48296);

(statearr_48351_48393[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (22))){
var inst_48329 = (state_48342[(2)]);
var inst_48330 = fluree.db.util.async.throw_err(inst_48329);
var inst_48331 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48330,(0),null);
var inst_48332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48330,(1),null);
var inst_48333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48334 = [inst_48331,inst_48332];
var inst_48335 = (new cljs.core.PersistentVector(null,2,(5),inst_48333,inst_48334,null));
var state_48342__$1 = state_48342;
var statearr_48352_48394 = state_48342__$1;
(statearr_48352_48394[(2)] = inst_48335);

(statearr_48352_48394[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (6))){
var inst_48283 = (state_48342[(2)]);
var state_48342__$1 = state_48342;
var statearr_48353_48395 = state_48342__$1;
(statearr_48353_48395[(2)] = inst_48283);

(statearr_48353_48395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (17))){
var inst_48305 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_48306 = fluree.db.dbfunctions.internal.get(inst_48305,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_48342__$1 = state_48342;
var statearr_48354_48396 = state_48342__$1;
(statearr_48354_48396[(2)] = inst_48306);

(statearr_48354_48396[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (3))){
var inst_48340 = (state_48342[(2)]);
var state_48342__$1 = state_48342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48342__$1,inst_48340);
} else {
if((state_val_48343 === (12))){
var inst_48294 = (state_48342[(2)]);
var state_48342__$1 = state_48342;
if(cljs.core.truth_(inst_48294)){
var statearr_48355_48397 = state_48342__$1;
(statearr_48355_48397[(1)] = (13));

} else {
var statearr_48356_48398 = state_48342__$1;
(statearr_48356_48398[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (2))){
var inst_48289 = (state_48342[(10)]);
var _ = (function (){var statearr_48357 = state_48342;
(statearr_48357[(4)] = cljs.core.cons((9),(state_48342[(4)])));

return statearr_48357;
})();
var inst_48289__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_48342__$1 = (function (){var statearr_48358 = state_48342;
(statearr_48358[(10)] = inst_48289__$1);

return statearr_48358;
})();
if(cljs.core.truth_(inst_48289__$1)){
var statearr_48359_48399 = state_48342__$1;
(statearr_48359_48399[(1)] = (10));

} else {
var statearr_48360_48400 = state_48342__$1;
(statearr_48360_48400[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (19))){
var inst_48310 = cljs.core.PersistentVector.EMPTY;
var inst_48311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48312 = ["*"];
var inst_48313 = (new cljs.core.PersistentVector(null,1,(5),inst_48311,inst_48312,null));
var inst_48314 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_48315 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_48313,inst_48314);
var inst_48316 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_48310,inst_48315);
var state_48342__$1 = state_48342;
var statearr_48362_48401 = state_48342__$1;
(statearr_48362_48401[(2)] = inst_48316);

(statearr_48362_48401[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (11))){
var inst_48289 = (state_48342[(10)]);
var state_48342__$1 = state_48342;
var statearr_48363_48402 = state_48342__$1;
(statearr_48363_48402[(2)] = inst_48289);

(statearr_48363_48402[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (9))){
var _ = (function (){var statearr_48364 = state_48342;
(statearr_48364[(4)] = cljs.core.rest((state_48342[(4)])));

return statearr_48364;
})();
var state_48342__$1 = state_48342;
var ex48361 = (state_48342__$1[(2)]);
var statearr_48365_48403 = state_48342__$1;
(statearr_48365_48403[(5)] = ex48361);


var statearr_48366_48404 = state_48342__$1;
(statearr_48366_48404[(1)] = (4));

(statearr_48366_48404[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (5))){
var inst_48273 = (state_48342[(7)]);
var _ = (function (){var statearr_48367 = state_48342;
(statearr_48367[(4)] = cljs.core.cons((8),(state_48342[(4)])));

return statearr_48367;
})();
var inst_48280 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_48273,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_48368 = state_48342;
(statearr_48368[(4)] = cljs.core.rest((state_48342[(4)])));

return statearr_48368;
})();
var state_48342__$1 = state_48342;
var statearr_48369_48405 = state_48342__$1;
(statearr_48369_48405[(2)] = inst_48280);

(statearr_48369_48405[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (14))){
var inst_48302 = (state_48342[(11)]);
var inst_48301 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_48302__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_48342__$1 = (function (){var statearr_48370 = state_48342;
(statearr_48370[(8)] = inst_48301);

(statearr_48370[(11)] = inst_48302__$1);

return statearr_48370;
})();
if(cljs.core.truth_(inst_48302__$1)){
var statearr_48371_48406 = state_48342__$1;
(statearr_48371_48406[(1)] = (16));

} else {
var statearr_48372_48407 = state_48342__$1;
(statearr_48372_48407[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (16))){
var inst_48302 = (state_48342[(11)]);
var state_48342__$1 = state_48342;
var statearr_48373_48408 = state_48342__$1;
(statearr_48373_48408[(2)] = inst_48302);

(statearr_48373_48408[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (10))){
var inst_48291 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_48342__$1 = state_48342;
var statearr_48375_48409 = state_48342__$1;
(statearr_48375_48409[(2)] = inst_48291);

(statearr_48375_48409[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (18))){
var inst_48308 = (state_48342[(2)]);
var state_48342__$1 = (function (){var statearr_48376 = state_48342;
(statearr_48376[(9)] = inst_48308);

return statearr_48376;
})();
if(cljs.core.truth_(additional_params)){
var statearr_48377_48410 = state_48342__$1;
(statearr_48377_48410[(1)] = (19));

} else {
var statearr_48378_48411 = state_48342__$1;
(statearr_48378_48411[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48343 === (8))){
var _ = (function (){var statearr_48379 = state_48342;
(statearr_48379[(4)] = cljs.core.rest((state_48342[(4)])));

return statearr_48379;
})();
var state_48342__$1 = state_48342;
var ex48374 = (state_48342__$1[(2)]);
var statearr_48380_48412 = state_48342__$1;
(statearr_48380_48412[(5)] = ex48374);


var statearr_48381_48413 = state_48342__$1;
(statearr_48381_48413[(1)] = (7));

(statearr_48381_48413[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__17178__auto____0 = (function (){
var statearr_48382 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48382[(0)] = fluree$db$dbfunctions$internal$state_machine__17178__auto__);

(statearr_48382[(1)] = (1));

return statearr_48382;
});
var fluree$db$dbfunctions$internal$state_machine__17178__auto____1 = (function (state_48342){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_48342);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e48383){var ex__17181__auto__ = e48383;
var statearr_48384_48414 = state_48342;
(statearr_48384_48414[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_48342[(4)]))){
var statearr_48385_48415 = state_48342;
(statearr_48385_48415[(1)] = cljs.core.first((state_48342[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48416 = state_48342;
state_48342 = G__48416;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__17178__auto__ = function(state_48342){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__17178__auto____1.call(this,state_48342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__17178__auto____0;
fluree$db$dbfunctions$internal$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__17178__auto____1;
return fluree$db$dbfunctions$internal$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_48386 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_48386[(6)] = c__17304__auto__);

return statearr_48386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__48418 = arguments.length;
switch (G__48418) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_48462){
var state_val_48463 = (state_48462[(1)]);
if((state_val_48463 === (7))){
var inst_48440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48441 = ["*"];
var inst_48442 = (new cljs.core.PersistentVector(null,1,(5),inst_48440,inst_48441,null));
var state_48462__$1 = state_48462;
var statearr_48464_48484 = state_48462__$1;
(statearr_48464_48484[(2)] = inst_48442);

(statearr_48464_48484[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48463 === (1))){
var state_48462__$1 = state_48462;
var statearr_48465_48485 = state_48462__$1;
(statearr_48465_48485[(2)] = null);

(statearr_48465_48485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48463 === (4))){
var inst_48419 = (state_48462[(2)]);
var inst_48420 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_48419,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_48462__$1 = state_48462;
var statearr_48466_48486 = state_48462__$1;
(statearr_48466_48486[(2)] = inst_48420);

(statearr_48466_48486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48463 === (6))){
var inst_48432 = cljs.core.PersistentVector.EMPTY;
var inst_48433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48434 = ["*"];
var inst_48435 = (new cljs.core.PersistentVector(null,1,(5),inst_48433,inst_48434,null));
var inst_48436 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_48437 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_48435,inst_48436);
var inst_48438 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_48432,inst_48437);
var state_48462__$1 = state_48462;
var statearr_48467_48487 = state_48462__$1;
(statearr_48467_48487[(2)] = inst_48438);

(statearr_48467_48487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48463 === (3))){
var inst_48460 = (state_48462[(2)]);
var state_48462__$1 = state_48462;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48462__$1,inst_48460);
} else {
if((state_val_48463 === (2))){
var _ = (function (){var statearr_48469 = state_48462;
(statearr_48469[(4)] = cljs.core.cons((5),(state_48462[(4)])));

return statearr_48469;
})();
var inst_48429 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_48430 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_48462__$1 = (function (){var statearr_48470 = state_48462;
(statearr_48470[(7)] = inst_48430);

(statearr_48470[(8)] = inst_48429);

return statearr_48470;
})();
if(cljs.core.truth_(additional_params)){
var statearr_48471_48488 = state_48462__$1;
(statearr_48471_48488[(1)] = (6));

} else {
var statearr_48472_48489 = state_48462__$1;
(statearr_48472_48489[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48463 === (9))){
var inst_48451 = (state_48462[(2)]);
var inst_48452 = fluree.db.util.async.throw_err(inst_48451);
var inst_48453 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48452,(0),null);
var inst_48454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48452,(1),null);
var inst_48455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48456 = [inst_48453,inst_48454];
var inst_48457 = (new cljs.core.PersistentVector(null,2,(5),inst_48455,inst_48456,null));
var _ = (function (){var statearr_48473 = state_48462;
(statearr_48473[(4)] = cljs.core.rest((state_48462[(4)])));

return statearr_48473;
})();
var state_48462__$1 = state_48462;
var statearr_48474_48490 = state_48462__$1;
(statearr_48474_48490[(2)] = inst_48457);

(statearr_48474_48490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48463 === (5))){
var _ = (function (){var statearr_48475 = state_48462;
(statearr_48475[(4)] = cljs.core.rest((state_48462[(4)])));

return statearr_48475;
})();
var state_48462__$1 = state_48462;
var ex48468 = (state_48462__$1[(2)]);
var statearr_48476_48491 = state_48462__$1;
(statearr_48476_48491[(5)] = ex48468);


var statearr_48477_48492 = state_48462__$1;
(statearr_48477_48492[(1)] = (4));

(statearr_48477_48492[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48463 === (8))){
var inst_48430 = (state_48462[(7)]);
var inst_48429 = (state_48462[(8)]);
var inst_48444 = (state_48462[(2)]);
var inst_48445 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_48446 = cljs.core.PersistentHashMap.EMPTY;
var inst_48447 = [inst_48444,inst_48430,inst_48446];
var inst_48448 = cljs.core.PersistentHashMap.fromArrays(inst_48445,inst_48447);
var inst_48449 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_48429,inst_48448);
var state_48462__$1 = state_48462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48462__$1,(9),inst_48449);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__17178__auto____0 = (function (){
var statearr_48478 = [null,null,null,null,null,null,null,null,null];
(statearr_48478[(0)] = fluree$db$dbfunctions$internal$state_machine__17178__auto__);

(statearr_48478[(1)] = (1));

return statearr_48478;
});
var fluree$db$dbfunctions$internal$state_machine__17178__auto____1 = (function (state_48462){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_48462);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e48479){var ex__17181__auto__ = e48479;
var statearr_48480_48493 = state_48462;
(statearr_48480_48493[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_48462[(4)]))){
var statearr_48481_48494 = state_48462;
(statearr_48481_48494[(1)] = cljs.core.first((state_48462[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48495 = state_48462;
state_48462 = G__48495;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__17178__auto__ = function(state_48462){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__17178__auto____1.call(this,state_48462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__17178__auto____0;
fluree$db$dbfunctions$internal$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__17178__auto____1;
return fluree$db$dbfunctions$internal$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_48482 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_48482[(6)] = c__17304__auto__);

return statearr_48482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_48539){
var state_val_48540 = (state_48539[(1)]);
if((state_val_48540 === (1))){
var state_48539__$1 = state_48539;
var statearr_48541_48555 = state_48539__$1;
(statearr_48541_48555[(2)] = null);

(statearr_48541_48555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48540 === (2))){
var _ = (function (){var statearr_48542 = state_48539;
(statearr_48542[(4)] = cljs.core.cons((5),(state_48539[(4)])));

return statearr_48542;
})();
var inst_48506 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_48507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48508 = ["_user/_auth"];
var inst_48509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48510 = ["*"];
var inst_48511 = (new cljs.core.PersistentVector(null,1,(5),inst_48509,inst_48510,null));
var inst_48512 = [inst_48511];
var inst_48513 = cljs.core.PersistentHashMap.fromArrays(inst_48508,inst_48512);
var inst_48514 = [inst_48513];
var inst_48515 = (new cljs.core.PersistentVector(null,1,(5),inst_48507,inst_48514,null));
var inst_48516 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_48517 = cljs.core.PersistentHashMap.EMPTY;
var inst_48518 = [inst_48515,inst_48516,inst_48517];
var inst_48519 = cljs.core.PersistentHashMap.fromArrays(inst_48506,inst_48518);
var inst_48520 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_48521 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_48520,inst_48519);
var state_48539__$1 = state_48539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48539__$1,(6),inst_48521);
} else {
if((state_val_48540 === (3))){
var inst_48537 = (state_48539[(2)]);
var state_48539__$1 = state_48539;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48539__$1,inst_48537);
} else {
if((state_val_48540 === (4))){
var inst_48496 = (state_48539[(2)]);
var inst_48497 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_48496,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_48539__$1 = state_48539;
var statearr_48544_48556 = state_48539__$1;
(statearr_48544_48556[(2)] = inst_48497);

(statearr_48544_48556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48540 === (5))){
var _ = (function (){var statearr_48545 = state_48539;
(statearr_48545[(4)] = cljs.core.rest((state_48539[(4)])));

return statearr_48545;
})();
var state_48539__$1 = state_48539;
var ex48543 = (state_48539__$1[(2)]);
var statearr_48546_48557 = state_48539__$1;
(statearr_48546_48557[(5)] = ex48543);


var statearr_48547_48558 = state_48539__$1;
(statearr_48547_48558[(1)] = (4));

(statearr_48547_48558[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48540 === (6))){
var inst_48523 = (state_48539[(2)]);
var inst_48524 = fluree.db.util.async.throw_err(inst_48523);
var inst_48525 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48524,(0),null);
var inst_48526 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48524,(1),null);
var inst_48527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48528 = ["_user/_auth","_id"];
var inst_48529 = (new cljs.core.PersistentVector(null,2,(5),inst_48527,inst_48528,null));
var inst_48530 = fluree.db.dbfunctions.internal.get_in(inst_48525,inst_48529);
var inst_48531 = cljs.core.first(inst_48530);
var inst_48532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48533 = [inst_48531,inst_48526];
var inst_48534 = (new cljs.core.PersistentVector(null,2,(5),inst_48532,inst_48533,null));
var _ = (function (){var statearr_48548 = state_48539;
(statearr_48548[(4)] = cljs.core.rest((state_48539[(4)])));

return statearr_48548;
})();
var state_48539__$1 = state_48539;
var statearr_48549_48559 = state_48539__$1;
(statearr_48549_48559[(2)] = inst_48534);

(statearr_48549_48559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17178__auto____0 = (function (){
var statearr_48550 = [null,null,null,null,null,null,null];
(statearr_48550[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17178__auto__);

(statearr_48550[(1)] = (1));

return statearr_48550;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17178__auto____1 = (function (state_48539){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_48539);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e48551){var ex__17181__auto__ = e48551;
var statearr_48552_48560 = state_48539;
(statearr_48552_48560[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_48539[(4)]))){
var statearr_48553_48561 = state_48539;
(statearr_48553_48561[(1)] = cljs.core.first((state_48539[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48562 = state_48539;
state_48539 = G__48562;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17178__auto__ = function(state_48539){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17178__auto____1.call(this,state_48539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_48554 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_48554[(6)] = c__17304__auto__);

return statearr_48554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_48579){
var state_val_48580 = (state_48579[(1)]);
if((state_val_48580 === (1))){
var state_48579__$1 = state_48579;
var statearr_48581_48595 = state_48579__$1;
(statearr_48581_48595[(2)] = null);

(statearr_48581_48595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48580 === (2))){
var _ = (function (){var statearr_48582 = state_48579;
(statearr_48582[(4)] = cljs.core.cons((5),(state_48579[(4)])));

return statearr_48582;
})();
var inst_48569 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_48570 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_48571 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_48570,inst_48569);
var state_48579__$1 = state_48579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48579__$1,(6),inst_48571);
} else {
if((state_val_48580 === (3))){
var inst_48577 = (state_48579[(2)]);
var state_48579__$1 = state_48579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48579__$1,inst_48577);
} else {
if((state_val_48580 === (4))){
var inst_48563 = (state_48579[(2)]);
var state_48579__$1 = state_48579;
var statearr_48584_48596 = state_48579__$1;
(statearr_48584_48596[(2)] = inst_48563);

(statearr_48584_48596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48580 === (5))){
var _ = (function (){var statearr_48585 = state_48579;
(statearr_48585[(4)] = cljs.core.rest((state_48579[(4)])));

return statearr_48585;
})();
var state_48579__$1 = state_48579;
var ex48583 = (state_48579__$1[(2)]);
var statearr_48586_48597 = state_48579__$1;
(statearr_48586_48597[(5)] = ex48583);


if((ex48583 instanceof Error)){
var statearr_48587_48598 = state_48579__$1;
(statearr_48587_48598[(1)] = (4));

(statearr_48587_48598[(5)] = null);

} else {
throw ex48583;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48580 === (6))){
var inst_48573 = (state_48579[(2)]);
var inst_48574 = fluree.db.util.async.throw_err(inst_48573);
var _ = (function (){var statearr_48588 = state_48579;
(statearr_48588[(4)] = cljs.core.rest((state_48579[(4)])));

return statearr_48588;
})();
var state_48579__$1 = state_48579;
var statearr_48589_48599 = state_48579__$1;
(statearr_48589_48599[(2)] = inst_48574);

(statearr_48589_48599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17178__auto____0 = (function (){
var statearr_48590 = [null,null,null,null,null,null,null];
(statearr_48590[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17178__auto__);

(statearr_48590[(1)] = (1));

return statearr_48590;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17178__auto____1 = (function (state_48579){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_48579);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e48591){var ex__17181__auto__ = e48591;
var statearr_48592_48600 = state_48579;
(statearr_48592_48600[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_48579[(4)]))){
var statearr_48593_48601 = state_48579;
(statearr_48593_48601[(1)] = cljs.core.first((state_48579[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48602 = state_48579;
state_48579 = G__48602;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17178__auto__ = function(state_48579){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17178__auto____1.call(this,state_48579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_48594 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_48594[(6)] = c__17304__auto__);

return statearr_48594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__48603_SHARP_){
return p1__48603_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__48604_SHARP_){
return p1__48604_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e48605){var e = e48605;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__48606_SHARP_){
return p1__48606_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__48607_SHARP_){
return p1__48607_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e48608){var e = e48608;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__48610 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__48610);
})() | (0));
return num;
}catch (e48609){var e = e48609;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_48690){
var state_val_48691 = (state_48690[(1)]);
if((state_val_48691 === (7))){
var inst_48629 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_48630 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_48631 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_48632 = cljs.core.PersistentHashMap.fromArrays(inst_48630,inst_48631);
var inst_48633 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_48629,inst_48632);
var inst_48634 = (function(){throw inst_48633})();
var state_48690__$1 = state_48690;
var statearr_48692_48727 = state_48690__$1;
(statearr_48692_48727[(2)] = inst_48634);

(statearr_48692_48727[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (1))){
var state_48690__$1 = state_48690;
var statearr_48693_48728 = state_48690__$1;
(statearr_48693_48728[(2)] = null);

(statearr_48693_48728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (4))){
var inst_48611 = (state_48690[(2)]);
var state_48690__$1 = state_48690;
var statearr_48694_48729 = state_48690__$1;
(statearr_48694_48729[(2)] = inst_48611);

(statearr_48694_48729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (15))){
var inst_48674 = (state_48690[(7)]);
var inst_48670 = (state_48690[(2)]);
var inst_48671 = fluree.db.util.async.throw_err(inst_48670);
var inst_48672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48671,(0),null);
var inst_48673 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48671,(1),null);
var inst_48674__$1 = cljs.core.first(inst_48672);
var inst_48675 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48674__$1,compare_val);
var state_48690__$1 = (function (){var statearr_48695 = state_48690;
(statearr_48695[(8)] = inst_48673);

(statearr_48695[(7)] = inst_48674__$1);

return statearr_48695;
})();
if(inst_48675){
var statearr_48696_48730 = state_48690__$1;
(statearr_48696_48730[(1)] = (16));

} else {
var statearr_48697_48731 = state_48690__$1;
(statearr_48697_48731[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (13))){
var state_48690__$1 = state_48690;
var statearr_48698_48732 = state_48690__$1;
(statearr_48698_48732[(2)] = null);

(statearr_48698_48732[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (6))){
var state_48690__$1 = state_48690;
var statearr_48699_48733 = state_48690__$1;
(statearr_48699_48733[(2)] = null);

(statearr_48699_48733[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (17))){
var inst_48674 = (state_48690[(7)]);
var inst_48678 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_48674)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_48679 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_48680 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_48681 = cljs.core.PersistentHashMap.fromArrays(inst_48679,inst_48680);
var inst_48682 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_48678,inst_48681);
var inst_48683 = (function(){throw inst_48682})();
var state_48690__$1 = state_48690;
var statearr_48700_48734 = state_48690__$1;
(statearr_48700_48734[(2)] = inst_48683);

(statearr_48700_48734[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (3))){
var inst_48688 = (state_48690[(2)]);
var state_48690__$1 = state_48690;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48690__$1,inst_48688);
} else {
if((state_val_48691 === (12))){
var inst_48626 = (state_48690[(9)]);
var inst_48649 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_48626], 0));
var inst_48650 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_48651 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_48652 = cljs.core.PersistentHashMap.fromArrays(inst_48650,inst_48651);
var inst_48653 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_48649,inst_48652);
var inst_48654 = (function(){throw inst_48653})();
var state_48690__$1 = state_48690;
var statearr_48701_48735 = state_48690__$1;
(statearr_48701_48735[(2)] = inst_48654);

(statearr_48701_48735[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (2))){
var inst_48623 = (state_48690[(10)]);
var inst_48624 = (state_48690[(11)]);
var inst_48625 = (state_48690[(12)]);
var _ = (function (){var statearr_48702 = state_48690;
(statearr_48702[(4)] = cljs.core.cons((5),(state_48690[(4)])));

return statearr_48702;
})();
var inst_48621 = _QMARK_ctx;
var inst_48622 = cljs.core.__destructure_map(inst_48621);
var inst_48623__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48622,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_48624__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48622,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_48625__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48622,new cljs.core.Keyword(null,"db","db",993250759));
var inst_48626 = fluree.db.dbproto._p_prop(inst_48625__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_48624__$1);
var state_48690__$1 = (function (){var statearr_48703 = state_48690;
(statearr_48703[(9)] = inst_48626);

(statearr_48703[(10)] = inst_48623__$1);

(statearr_48703[(11)] = inst_48624__$1);

(statearr_48703[(12)] = inst_48625__$1);

return statearr_48703;
})();
if(cljs.core.truth_(inst_48623__$1)){
var statearr_48704_48736 = state_48690__$1;
(statearr_48704_48736[(1)] = (6));

} else {
var statearr_48705_48737 = state_48690__$1;
(statearr_48705_48737[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (11))){
var inst_48624 = (state_48690[(11)]);
var inst_48625 = (state_48690[(12)]);
var inst_48646 = (state_48690[(2)]);
var inst_48647 = fluree.db.dbproto._p_prop(inst_48625,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_48624);
var state_48690__$1 = (function (){var statearr_48707 = state_48690;
(statearr_48707[(13)] = inst_48646);

return statearr_48707;
})();
if(cljs.core.truth_(inst_48647)){
var statearr_48708_48738 = state_48690__$1;
(statearr_48708_48738[(1)] = (12));

} else {
var statearr_48709_48739 = state_48690__$1;
(statearr_48709_48739[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (9))){
var state_48690__$1 = state_48690;
var statearr_48710_48740 = state_48690__$1;
(statearr_48710_48740[(2)] = null);

(statearr_48710_48740[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (5))){
var _ = (function (){var statearr_48711 = state_48690;
(statearr_48711[(4)] = cljs.core.rest((state_48690[(4)])));

return statearr_48711;
})();
var state_48690__$1 = state_48690;
var ex48706 = (state_48690__$1[(2)]);
var statearr_48712_48741 = state_48690__$1;
(statearr_48712_48741[(5)] = ex48706);


if((ex48706 instanceof Error)){
var statearr_48713_48742 = state_48690__$1;
(statearr_48713_48742[(1)] = (4));

(statearr_48713_48742[(5)] = null);

} else {
throw ex48706;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (14))){
var inst_48626 = (state_48690[(9)]);
var inst_48623 = (state_48690[(10)]);
var inst_48625 = (state_48690[(12)]);
var inst_48657 = (state_48690[(2)]);
var inst_48658 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_48659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48661 = [inst_48623,inst_48626,"?current-val"];
var inst_48662 = (new cljs.core.PersistentVector(null,3,(5),inst_48660,inst_48661,null));
var inst_48663 = [inst_48662];
var inst_48664 = (new cljs.core.PersistentVector(null,1,(5),inst_48659,inst_48663,null));
var inst_48665 = cljs.core.PersistentHashMap.EMPTY;
var inst_48666 = ["?current-val",inst_48664,inst_48665];
var inst_48667 = cljs.core.PersistentHashMap.fromArrays(inst_48658,inst_48666);
var inst_48668 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_48625,inst_48667);
var state_48690__$1 = (function (){var statearr_48714 = state_48690;
(statearr_48714[(14)] = inst_48657);

return statearr_48714;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48690__$1,(15),inst_48668);
} else {
if((state_val_48691 === (16))){
var state_48690__$1 = state_48690;
var statearr_48715_48743 = state_48690__$1;
(statearr_48715_48743[(2)] = new_val);

(statearr_48715_48743[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (10))){
var inst_48639 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_48640 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_48641 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_48642 = cljs.core.PersistentHashMap.fromArrays(inst_48640,inst_48641);
var inst_48643 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_48639,inst_48642);
var inst_48644 = (function(){throw inst_48643})();
var state_48690__$1 = state_48690;
var statearr_48716_48744 = state_48690__$1;
(statearr_48716_48744[(2)] = inst_48644);

(statearr_48716_48744[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (18))){
var inst_48685 = (state_48690[(2)]);
var _ = (function (){var statearr_48717 = state_48690;
(statearr_48717[(4)] = cljs.core.rest((state_48690[(4)])));

return statearr_48717;
})();
var state_48690__$1 = state_48690;
var statearr_48718_48745 = state_48690__$1;
(statearr_48718_48745[(2)] = inst_48685);

(statearr_48718_48745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48691 === (8))){
var inst_48626 = (state_48690[(9)]);
var inst_48636 = (state_48690[(2)]);
var state_48690__$1 = (function (){var statearr_48719 = state_48690;
(statearr_48719[(15)] = inst_48636);

return statearr_48719;
})();
if(cljs.core.truth_(inst_48626)){
var statearr_48720_48746 = state_48690__$1;
(statearr_48720_48746[(1)] = (9));

} else {
var statearr_48721_48747 = state_48690__$1;
(statearr_48721_48747[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__17178__auto____0 = (function (){
var statearr_48722 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48722[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__17178__auto__);

(statearr_48722[(1)] = (1));

return statearr_48722;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__17178__auto____1 = (function (state_48690){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_48690);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e48723){var ex__17181__auto__ = e48723;
var statearr_48724_48748 = state_48690;
(statearr_48724_48748[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_48690[(4)]))){
var statearr_48725_48749 = state_48690;
(statearr_48725_48749[(1)] = cljs.core.first((state_48690[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48750 = state_48690;
state_48690 = G__48750;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__17178__auto__ = function(state_48690){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__17178__auto____1.call(this,state_48690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_48726 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_48726[(6)] = c__17304__auto__);

return statearr_48726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
