// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4867__auto___72080 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72131){
var state_val_72132 = (state_72131[(1)]);
if((state_val_72132 === (7))){
var inst_72126 = (state_72131[(2)]);
var _ = (function (){var statearr_72133 = state_72131;
(statearr_72133[(4)] = cljs.core.rest((state_72131[(4)])));

return statearr_72133;
})();
var state_72131__$1 = state_72131;
var statearr_72134_72161 = state_72131__$1;
(statearr_72134_72161[(2)] = inst_72126);

(statearr_72134_72161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72132 === (1))){
var state_72131__$1 = state_72131;
var statearr_72135_72162 = state_72131__$1;
(statearr_72135_72162[(2)] = null);

(statearr_72135_72162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72132 === (4))){
var inst_72081 = (state_72131[(2)]);
var state_72131__$1 = state_72131;
var statearr_72136_72163 = state_72131__$1;
(statearr_72136_72163[(2)] = inst_72081);

(statearr_72136_72163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72132 === (13))){
var inst_72122 = (state_72131[(2)]);
var state_72131__$1 = state_72131;
var statearr_72137_72164 = state_72131__$1;
(statearr_72137_72164[(2)] = inst_72122);

(statearr_72137_72164[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72132 === (6))){
var inst_72106 = (state_72131[(7)]);
var inst_72099 = (state_72131[(8)]);
var inst_72105 = cljs.core.seq(inst_72099);
var inst_72106__$1 = cljs.core.first(inst_72105);
var inst_72107 = cljs.core.next(inst_72105);
var inst_72108 = cljs.core.not(inst_72106__$1);
var state_72131__$1 = (function (){var statearr_72138 = state_72131;
(statearr_72138[(7)] = inst_72106__$1);

(statearr_72138[(9)] = inst_72107);

return statearr_72138;
})();
if(inst_72108){
var statearr_72139_72165 = state_72131__$1;
(statearr_72139_72165[(1)] = (8));

} else {
var statearr_72140_72166 = state_72131__$1;
(statearr_72140_72166[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72132 === (3))){
var inst_72129 = (state_72131[(2)]);
var state_72131__$1 = state_72131;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72131__$1,inst_72129);
} else {
if((state_val_72132 === (12))){
var inst_72106 = (state_72131[(7)]);
var inst_72107 = (state_72131[(9)]);
var inst_72100 = (state_72131[(10)]);
var inst_72119 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_72100,inst_72106);
var inst_72099 = inst_72107;
var inst_72100__$1 = inst_72119;
var state_72131__$1 = (function (){var statearr_72141 = state_72131;
(statearr_72141[(8)] = inst_72099);

(statearr_72141[(10)] = inst_72100__$1);

return statearr_72141;
})();
var statearr_72142_72167 = state_72131__$1;
(statearr_72142_72167[(2)] = null);

(statearr_72142_72167[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72132 === (2))){
var _ = (function (){var statearr_72143 = state_72131;
(statearr_72143[(4)] = cljs.core.cons((5),(state_72131[(4)])));

return statearr_72143;
})();
var inst_72094 = args;
var inst_72095 = cljs.core.seq(inst_72094);
var inst_72096 = cljs.core.first(inst_72095);
var inst_72097 = cljs.core.next(inst_72095);
var inst_72098 = cljs.core.PersistentVector.EMPTY;
var inst_72099 = inst_72094;
var inst_72100 = inst_72098;
var state_72131__$1 = (function (){var statearr_72144 = state_72131;
(statearr_72144[(11)] = inst_72096);

(statearr_72144[(12)] = inst_72097);

(statearr_72144[(8)] = inst_72099);

(statearr_72144[(10)] = inst_72100);

return statearr_72144;
})();
var statearr_72145_72168 = state_72131__$1;
(statearr_72145_72168[(2)] = null);

(statearr_72145_72168[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72132 === (11))){
var inst_72106 = (state_72131[(7)]);
var state_72131__$1 = state_72131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72131__$1,(14),inst_72106);
} else {
if((state_val_72132 === (9))){
var inst_72106 = (state_72131[(7)]);
var inst_72111 = fluree.db.util.async.channel_QMARK_(inst_72106);
var state_72131__$1 = state_72131;
if(inst_72111){
var statearr_72147_72169 = state_72131__$1;
(statearr_72147_72169[(1)] = (11));

} else {
var statearr_72148_72170 = state_72131__$1;
(statearr_72148_72170[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72132 === (5))){
var _ = (function (){var statearr_72149 = state_72131;
(statearr_72149[(4)] = cljs.core.rest((state_72131[(4)])));

return statearr_72149;
})();
var state_72131__$1 = state_72131;
var ex72146 = (state_72131__$1[(2)]);
var statearr_72150_72171 = state_72131__$1;
(statearr_72150_72171[(5)] = ex72146);


if((ex72146 instanceof Error)){
var statearr_72151_72172 = state_72131__$1;
(statearr_72151_72172[(1)] = (4));

(statearr_72151_72172[(5)] = null);

} else {
throw ex72146;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72132 === (14))){
var inst_72107 = (state_72131[(9)]);
var inst_72100 = (state_72131[(10)]);
var inst_72114 = (state_72131[(2)]);
var inst_72115 = fluree.db.util.async.throw_err(inst_72114);
var inst_72116 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_72100,inst_72115);
var inst_72099 = inst_72107;
var inst_72100__$1 = inst_72116;
var state_72131__$1 = (function (){var statearr_72152 = state_72131;
(statearr_72152[(8)] = inst_72099);

(statearr_72152[(10)] = inst_72100__$1);

return statearr_72152;
})();
var statearr_72153_72173 = state_72131__$1;
(statearr_72153_72173[(2)] = null);

(statearr_72153_72173[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72132 === (10))){
var inst_72124 = (state_72131[(2)]);
var state_72131__$1 = state_72131;
var statearr_72154_72174 = state_72131__$1;
(statearr_72154_72174[(2)] = inst_72124);

(statearr_72154_72174[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72132 === (8))){
var inst_72100 = (state_72131[(10)]);
var state_72131__$1 = state_72131;
var statearr_72155_72175 = state_72131__$1;
(statearr_72155_72175[(2)] = inst_72100);

(statearr_72155_72175[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__17178__auto____0 = (function (){
var statearr_72156 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72156[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__17178__auto__);

(statearr_72156[(1)] = (1));

return statearr_72156;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__17178__auto____1 = (function (state_72131){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72131);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72157){var ex__17181__auto__ = e72157;
var statearr_72158_72176 = state_72131;
(statearr_72158_72176[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72131[(4)]))){
var statearr_72159_72177 = state_72131;
(statearr_72159_72177[(1)] = cljs.core.first((state_72131[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72178 = state_72131;
state_72131 = G__72178;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__17178__auto__ = function(state_72131){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__17178__auto____1.call(this,state_72131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72160 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72160[(6)] = c__17304__auto__);

return statearr_72160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__72179 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72179,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72179,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72227){
var state_val_72228 = (state_72227[(1)]);
if((state_val_72228 === (7))){
var state_72227__$1 = state_72227;
var statearr_72229_72258 = state_72227__$1;
(statearr_72229_72258[(2)] = coll);

(statearr_72229_72258[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72228 === (1))){
var state_72227__$1 = state_72227;
var statearr_72230_72259 = state_72227__$1;
(statearr_72230_72259[(2)] = null);

(statearr_72230_72259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72228 === (4))){
var inst_72182 = (state_72227[(2)]);
var state_72227__$1 = state_72227;
var statearr_72231_72260 = state_72227__$1;
(statearr_72231_72260[(2)] = inst_72182);

(statearr_72231_72260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72228 === (15))){
var inst_72201 = (state_72227[(7)]);
var inst_72209 = (state_72227[(2)]);
var inst_72210 = fluree.db.dbfunctions.internal.nth(inst_72201,inst_72209);
var inst_72211 = cljs.core.count(inst_72201);
var inst_72212 = ((9) + inst_72211);
var inst_72213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72214 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72216 = [inst_72201,inst_72209];
var inst_72217 = (new cljs.core.PersistentVector(null,2,(5),inst_72215,inst_72216,null));
var inst_72218 = ["nth",inst_72217,inst_72210];
var inst_72219 = cljs.core.PersistentHashMap.fromArrays(inst_72214,inst_72218);
var inst_72220 = [inst_72219,inst_72212];
var inst_72221 = (new cljs.core.PersistentVector(null,2,(5),inst_72213,inst_72220,null));
var inst_72222 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72221);
var _ = (function (){var statearr_72232 = state_72227;
(statearr_72232[(4)] = cljs.core.rest((state_72227[(4)])));

return statearr_72232;
})();
var state_72227__$1 = (function (){var statearr_72233 = state_72227;
(statearr_72233[(8)] = inst_72222);

return statearr_72233;
})();
var statearr_72234_72261 = state_72227__$1;
(statearr_72234_72261[(2)] = inst_72210);

(statearr_72234_72261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72228 === (13))){
var state_72227__$1 = state_72227;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72227__$1,(16),key);
} else {
if((state_val_72228 === (6))){
var state_72227__$1 = state_72227;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72227__$1,(9),coll);
} else {
if((state_val_72228 === (3))){
var inst_72225 = (state_72227[(2)]);
var state_72227__$1 = state_72227;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72227__$1,inst_72225);
} else {
if((state_val_72228 === (12))){
var inst_72201 = (state_72227[(2)]);
var inst_72202 = fluree.db.util.async.channel_QMARK_(key);
var state_72227__$1 = (function (){var statearr_72235 = state_72227;
(statearr_72235[(7)] = inst_72201);

return statearr_72235;
})();
if(inst_72202){
var statearr_72236_72262 = state_72227__$1;
(statearr_72236_72262[(1)] = (13));

} else {
var statearr_72237_72263 = state_72227__$1;
(statearr_72237_72263[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72228 === (2))){
var _ = (function (){var statearr_72238 = state_72227;
(statearr_72238[(4)] = cljs.core.cons((5),(state_72227[(4)])));

return statearr_72238;
})();
var inst_72188 = fluree.db.util.async.channel_QMARK_(coll);
var state_72227__$1 = state_72227;
if(inst_72188){
var statearr_72239_72264 = state_72227__$1;
(statearr_72239_72264[(1)] = (6));

} else {
var statearr_72240_72265 = state_72227__$1;
(statearr_72240_72265[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72228 === (11))){
var inst_72195 = (state_72227[(9)]);
var state_72227__$1 = state_72227;
var statearr_72242_72266 = state_72227__$1;
(statearr_72242_72266[(2)] = inst_72195);

(statearr_72242_72266[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72228 === (9))){
var inst_72191 = (state_72227[(2)]);
var inst_72192 = fluree.db.util.async.throw_err(inst_72191);
var state_72227__$1 = state_72227;
var statearr_72243_72267 = state_72227__$1;
(statearr_72243_72267[(2)] = inst_72192);

(statearr_72243_72267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72228 === (5))){
var _ = (function (){var statearr_72244 = state_72227;
(statearr_72244[(4)] = cljs.core.rest((state_72227[(4)])));

return statearr_72244;
})();
var state_72227__$1 = state_72227;
var ex72241 = (state_72227__$1[(2)]);
var statearr_72245_72268 = state_72227__$1;
(statearr_72245_72268[(5)] = ex72241);


if((ex72241 instanceof Error)){
var statearr_72246_72269 = state_72227__$1;
(statearr_72246_72269[(1)] = (4));

(statearr_72246_72269[(5)] = null);

} else {
throw ex72241;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72228 === (14))){
var state_72227__$1 = state_72227;
var statearr_72247_72270 = state_72227__$1;
(statearr_72247_72270[(2)] = key);

(statearr_72247_72270[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72228 === (16))){
var inst_72205 = (state_72227[(2)]);
var inst_72206 = fluree.db.util.async.throw_err(inst_72205);
var state_72227__$1 = state_72227;
var statearr_72248_72271 = state_72227__$1;
(statearr_72248_72271[(2)] = inst_72206);

(statearr_72248_72271[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72228 === (10))){
var inst_72195 = (state_72227[(9)]);
var inst_72198 = cljs.core.vec(inst_72195);
var state_72227__$1 = state_72227;
var statearr_72249_72272 = state_72227__$1;
(statearr_72249_72272[(2)] = inst_72198);

(statearr_72249_72272[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72228 === (8))){
var inst_72195 = (state_72227[(9)]);
var inst_72195__$1 = (state_72227[(2)]);
var inst_72196 = cljs.core.set_QMARK_(inst_72195__$1);
var state_72227__$1 = (function (){var statearr_72250 = state_72227;
(statearr_72250[(9)] = inst_72195__$1);

return statearr_72250;
})();
if(inst_72196){
var statearr_72251_72273 = state_72227__$1;
(statearr_72251_72273[(1)] = (10));

} else {
var statearr_72252_72274 = state_72227__$1;
(statearr_72252_72274[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__17178__auto____0 = (function (){
var statearr_72253 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72253[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__17178__auto__);

(statearr_72253[(1)] = (1));

return statearr_72253;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__17178__auto____1 = (function (state_72227){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72227);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72254){var ex__17181__auto__ = e72254;
var statearr_72255_72275 = state_72227;
(statearr_72255_72275[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72227[(4)]))){
var statearr_72256_72276 = state_72227;
(statearr_72256_72276[(1)] = cljs.core.first((state_72227[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72277 = state_72227;
state_72227 = G__72277;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__17178__auto__ = function(state_72227){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__17178__auto____1.call(this,state_72227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72257 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72257[(6)] = c__17304__auto__);

return statearr_72257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72338){
var state_val_72339 = (state_72338[(1)]);
if((state_val_72339 === (7))){
var state_72338__$1 = state_72338;
var statearr_72340_72374 = state_72338__$1;
(statearr_72340_72374[(2)] = test);

(statearr_72340_72374[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (20))){
var inst_72312 = (state_72338[(2)]);
var inst_72313 = fluree.db.util.async.throw_err(inst_72312);
var state_72338__$1 = state_72338;
var statearr_72341_72375 = state_72338__$1;
(statearr_72341_72375[(2)] = inst_72313);

(statearr_72341_72375[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (1))){
var state_72338__$1 = state_72338;
var statearr_72342_72376 = state_72338__$1;
(statearr_72342_72376[(2)] = null);

(statearr_72342_72376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (4))){
var inst_72278 = (state_72338[(2)]);
var state_72338__$1 = state_72338;
var statearr_72343_72377 = state_72338__$1;
(statearr_72343_72377[(2)] = inst_72278);

(statearr_72343_72377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (15))){
var inst_72296 = (state_72338[(7)]);
var inst_72304 = (state_72338[(2)]);
var inst_72305 = [inst_72304,f];
var inst_72306 = (new cljs.core.PersistentVector(null,2,(5),inst_72296,inst_72305,null));
var state_72338__$1 = state_72338;
var statearr_72344_72378 = state_72338__$1;
(statearr_72344_72378[(2)] = inst_72306);

(statearr_72344_72378[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (13))){
var state_72338__$1 = state_72338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72338__$1,(16),t);
} else {
if((state_val_72339 === (6))){
var state_72338__$1 = state_72338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72338__$1,(9),test);
} else {
if((state_val_72339 === (17))){
var state_72338__$1 = state_72338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72338__$1,(20),f);
} else {
if((state_val_72339 === (3))){
var inst_72336 = (state_72338[(2)]);
var state_72338__$1 = state_72338;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72338__$1,inst_72336);
} else {
if((state_val_72339 === (12))){
var inst_72294 = (state_72338[(8)]);
var inst_72320 = (state_72338[(2)]);
var inst_72321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72320,(0),null);
var inst_72322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72320,(1),null);
var inst_72323 = fluree.db.dbfunctions.internal.if_else(inst_72294,inst_72321,inst_72322);
var inst_72324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72325 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72327 = [inst_72294,inst_72321,inst_72322];
var inst_72328 = (new cljs.core.PersistentVector(null,3,(5),inst_72326,inst_72327,null));
var inst_72329 = ["if-else",inst_72328,inst_72323];
var inst_72330 = cljs.core.PersistentHashMap.fromArrays(inst_72325,inst_72329);
var inst_72331 = [inst_72330,(10)];
var inst_72332 = (new cljs.core.PersistentVector(null,2,(5),inst_72324,inst_72331,null));
var inst_72333 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72332);
var _ = (function (){var statearr_72345 = state_72338;
(statearr_72345[(4)] = cljs.core.rest((state_72338[(4)])));

return statearr_72345;
})();
var state_72338__$1 = (function (){var statearr_72346 = state_72338;
(statearr_72346[(9)] = inst_72333);

return statearr_72346;
})();
var statearr_72347_72379 = state_72338__$1;
(statearr_72347_72379[(2)] = inst_72323);

(statearr_72347_72379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (2))){
var _ = (function (){var statearr_72348 = state_72338;
(statearr_72348[(4)] = cljs.core.cons((5),(state_72338[(4)])));

return statearr_72348;
})();
var inst_72287 = fluree.db.util.async.channel_QMARK_(test);
var state_72338__$1 = state_72338;
if(inst_72287){
var statearr_72349_72380 = state_72338__$1;
(statearr_72349_72380[(1)] = (6));

} else {
var statearr_72350_72381 = state_72338__$1;
(statearr_72350_72381[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (19))){
var inst_72308 = (state_72338[(10)]);
var inst_72316 = (state_72338[(2)]);
var inst_72317 = [f,inst_72316];
var inst_72318 = (new cljs.core.PersistentVector(null,2,(5),inst_72308,inst_72317,null));
var state_72338__$1 = state_72338;
var statearr_72351_72382 = state_72338__$1;
(statearr_72351_72382[(2)] = inst_72318);

(statearr_72351_72382[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (11))){
var inst_72308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72309 = fluree.db.util.async.channel_QMARK_(f);
var state_72338__$1 = (function (){var statearr_72353 = state_72338;
(statearr_72353[(10)] = inst_72308);

return statearr_72353;
})();
if(inst_72309){
var statearr_72354_72383 = state_72338__$1;
(statearr_72354_72383[(1)] = (17));

} else {
var statearr_72355_72384 = state_72338__$1;
(statearr_72355_72384[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (9))){
var inst_72290 = (state_72338[(2)]);
var inst_72291 = fluree.db.util.async.throw_err(inst_72290);
var state_72338__$1 = state_72338;
var statearr_72356_72385 = state_72338__$1;
(statearr_72356_72385[(2)] = inst_72291);

(statearr_72356_72385[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (5))){
var _ = (function (){var statearr_72357 = state_72338;
(statearr_72357[(4)] = cljs.core.rest((state_72338[(4)])));

return statearr_72357;
})();
var state_72338__$1 = state_72338;
var ex72352 = (state_72338__$1[(2)]);
var statearr_72358_72386 = state_72338__$1;
(statearr_72358_72386[(5)] = ex72352);


if((ex72352 instanceof Error)){
var statearr_72359_72387 = state_72338__$1;
(statearr_72359_72387[(1)] = (4));

(statearr_72359_72387[(5)] = null);

} else {
throw ex72352;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (14))){
var state_72338__$1 = state_72338;
var statearr_72360_72388 = state_72338__$1;
(statearr_72360_72388[(2)] = t);

(statearr_72360_72388[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (16))){
var inst_72300 = (state_72338[(2)]);
var inst_72301 = fluree.db.util.async.throw_err(inst_72300);
var state_72338__$1 = state_72338;
var statearr_72361_72389 = state_72338__$1;
(statearr_72361_72389[(2)] = inst_72301);

(statearr_72361_72389[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (10))){
var inst_72296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72297 = fluree.db.util.async.channel_QMARK_(t);
var state_72338__$1 = (function (){var statearr_72362 = state_72338;
(statearr_72362[(7)] = inst_72296);

return statearr_72362;
})();
if(inst_72297){
var statearr_72363_72390 = state_72338__$1;
(statearr_72363_72390[(1)] = (13));

} else {
var statearr_72364_72391 = state_72338__$1;
(statearr_72364_72391[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (18))){
var state_72338__$1 = state_72338;
var statearr_72365_72392 = state_72338__$1;
(statearr_72365_72392[(2)] = f);

(statearr_72365_72392[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (8))){
var inst_72294 = (state_72338[(8)]);
var inst_72294__$1 = (state_72338[(2)]);
var state_72338__$1 = (function (){var statearr_72366 = state_72338;
(statearr_72366[(8)] = inst_72294__$1);

return statearr_72366;
})();
if(cljs.core.truth_(inst_72294__$1)){
var statearr_72367_72393 = state_72338__$1;
(statearr_72367_72393[(1)] = (10));

} else {
var statearr_72368_72394 = state_72338__$1;
(statearr_72368_72394[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__17178__auto____0 = (function (){
var statearr_72369 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_72369[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__17178__auto__);

(statearr_72369[(1)] = (1));

return statearr_72369;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__17178__auto____1 = (function (state_72338){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72338);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72370){var ex__17181__auto__ = e72370;
var statearr_72371_72395 = state_72338;
(statearr_72371_72395[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72338[(4)]))){
var statearr_72372_72396 = state_72338;
(statearr_72372_72396[(1)] = cljs.core.first((state_72338[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72397 = state_72338;
state_72338 = G__72397;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__17178__auto__ = function(state_72338){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__17178__auto____1.call(this,state_72338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72373 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72373[(6)] = c__17304__auto__);

return statearr_72373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72427){
var state_val_72428 = (state_72427[(1)]);
if((state_val_72428 === (7))){
var state_72427__$1 = state_72427;
var statearr_72429_72448 = state_72427__$1;
(statearr_72429_72448[(2)] = arg);

(statearr_72429_72448[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72428 === (1))){
var state_72427__$1 = state_72427;
var statearr_72430_72449 = state_72427__$1;
(statearr_72430_72449[(2)] = null);

(statearr_72430_72449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72428 === (4))){
var inst_72398 = (state_72427[(2)]);
var state_72427__$1 = state_72427;
var statearr_72431_72450 = state_72427__$1;
(statearr_72431_72450[(2)] = inst_72398);

(statearr_72431_72450[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72428 === (6))){
var state_72427__$1 = state_72427;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72427__$1,(9),arg);
} else {
if((state_val_72428 === (3))){
var inst_72425 = (state_72427[(2)]);
var state_72427__$1 = state_72427;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72427__$1,inst_72425);
} else {
if((state_val_72428 === (2))){
var _ = (function (){var statearr_72433 = state_72427;
(statearr_72433[(4)] = cljs.core.cons((5),(state_72427[(4)])));

return statearr_72433;
})();
var inst_72404 = fluree.db.util.async.channel_QMARK_(arg);
var state_72427__$1 = state_72427;
if(inst_72404){
var statearr_72434_72451 = state_72427__$1;
(statearr_72434_72451[(1)] = (6));

} else {
var statearr_72435_72452 = state_72427__$1;
(statearr_72435_72452[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72428 === (9))){
var inst_72407 = (state_72427[(2)]);
var inst_72408 = fluree.db.util.async.throw_err(inst_72407);
var state_72427__$1 = state_72427;
var statearr_72436_72453 = state_72427__$1;
(statearr_72436_72453[(2)] = inst_72408);

(statearr_72436_72453[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72428 === (5))){
var _ = (function (){var statearr_72437 = state_72427;
(statearr_72437[(4)] = cljs.core.rest((state_72427[(4)])));

return statearr_72437;
})();
var state_72427__$1 = state_72427;
var ex72432 = (state_72427__$1[(2)]);
var statearr_72438_72454 = state_72427__$1;
(statearr_72438_72454[(5)] = ex72432);


if((ex72432 instanceof Error)){
var statearr_72439_72455 = state_72427__$1;
(statearr_72439_72455[(1)] = (4));

(statearr_72439_72455[(5)] = null);

} else {
throw ex72432;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72428 === (8))){
var inst_72411 = (state_72427[(2)]);
var inst_72412 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_72411);
var inst_72413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72414 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72416 = [inst_72411];
var inst_72417 = (new cljs.core.PersistentVector(null,1,(5),inst_72415,inst_72416,null));
var inst_72418 = ["nil?",inst_72417,inst_72412];
var inst_72419 = cljs.core.PersistentHashMap.fromArrays(inst_72414,inst_72418);
var inst_72420 = [inst_72419,(10)];
var inst_72421 = (new cljs.core.PersistentVector(null,2,(5),inst_72413,inst_72420,null));
var inst_72422 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72421);
var _ = (function (){var statearr_72440 = state_72427;
(statearr_72440[(4)] = cljs.core.rest((state_72427[(4)])));

return statearr_72440;
})();
var state_72427__$1 = (function (){var statearr_72441 = state_72427;
(statearr_72441[(7)] = inst_72422);

return statearr_72441;
})();
var statearr_72442_72456 = state_72427__$1;
(statearr_72442_72456[(2)] = inst_72412);

(statearr_72442_72456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__17178__auto____0 = (function (){
var statearr_72443 = [null,null,null,null,null,null,null,null];
(statearr_72443[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__17178__auto__);

(statearr_72443[(1)] = (1));

return statearr_72443;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__17178__auto____1 = (function (state_72427){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72427);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72444){var ex__17181__auto__ = e72444;
var statearr_72445_72457 = state_72427;
(statearr_72445_72457[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72427[(4)]))){
var statearr_72446_72458 = state_72427;
(statearr_72446_72458[(1)] = cljs.core.first((state_72427[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72459 = state_72427;
state_72427 = G__72459;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__17178__auto__ = function(state_72427){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__17178__auto____1.call(this,state_72427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72447 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72447[(6)] = c__17304__auto__);

return statearr_72447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72489){
var state_val_72490 = (state_72489[(1)]);
if((state_val_72490 === (7))){
var state_72489__$1 = state_72489;
var statearr_72491_72510 = state_72489__$1;
(statearr_72491_72510[(2)] = arg);

(statearr_72491_72510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72490 === (1))){
var state_72489__$1 = state_72489;
var statearr_72492_72511 = state_72489__$1;
(statearr_72492_72511[(2)] = null);

(statearr_72492_72511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72490 === (4))){
var inst_72460 = (state_72489[(2)]);
var state_72489__$1 = state_72489;
var statearr_72493_72512 = state_72489__$1;
(statearr_72493_72512[(2)] = inst_72460);

(statearr_72493_72512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72490 === (6))){
var state_72489__$1 = state_72489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72489__$1,(9),arg);
} else {
if((state_val_72490 === (3))){
var inst_72487 = (state_72489[(2)]);
var state_72489__$1 = state_72489;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72489__$1,inst_72487);
} else {
if((state_val_72490 === (2))){
var _ = (function (){var statearr_72495 = state_72489;
(statearr_72495[(4)] = cljs.core.cons((5),(state_72489[(4)])));

return statearr_72495;
})();
var inst_72466 = fluree.db.util.async.channel_QMARK_(arg);
var state_72489__$1 = state_72489;
if(inst_72466){
var statearr_72496_72513 = state_72489__$1;
(statearr_72496_72513[(1)] = (6));

} else {
var statearr_72497_72514 = state_72489__$1;
(statearr_72497_72514[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72490 === (9))){
var inst_72469 = (state_72489[(2)]);
var inst_72470 = fluree.db.util.async.throw_err(inst_72469);
var state_72489__$1 = state_72489;
var statearr_72498_72515 = state_72489__$1;
(statearr_72498_72515[(2)] = inst_72470);

(statearr_72498_72515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72490 === (5))){
var _ = (function (){var statearr_72499 = state_72489;
(statearr_72499[(4)] = cljs.core.rest((state_72489[(4)])));

return statearr_72499;
})();
var state_72489__$1 = state_72489;
var ex72494 = (state_72489__$1[(2)]);
var statearr_72500_72516 = state_72489__$1;
(statearr_72500_72516[(5)] = ex72494);


if((ex72494 instanceof Error)){
var statearr_72501_72517 = state_72489__$1;
(statearr_72501_72517[(1)] = (4));

(statearr_72501_72517[(5)] = null);

} else {
throw ex72494;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72490 === (8))){
var inst_72473 = (state_72489[(2)]);
var inst_72474 = fluree.db.dbfunctions.internal.not(inst_72473);
var inst_72475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72476 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72478 = [inst_72473];
var inst_72479 = (new cljs.core.PersistentVector(null,1,(5),inst_72477,inst_72478,null));
var inst_72480 = ["not?",inst_72479,inst_72474];
var inst_72481 = cljs.core.PersistentHashMap.fromArrays(inst_72476,inst_72480);
var inst_72482 = [inst_72481,(10)];
var inst_72483 = (new cljs.core.PersistentVector(null,2,(5),inst_72475,inst_72482,null));
var inst_72484 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72483);
var _ = (function (){var statearr_72502 = state_72489;
(statearr_72502[(4)] = cljs.core.rest((state_72489[(4)])));

return statearr_72502;
})();
var state_72489__$1 = (function (){var statearr_72503 = state_72489;
(statearr_72503[(7)] = inst_72484);

return statearr_72503;
})();
var statearr_72504_72518 = state_72489__$1;
(statearr_72504_72518[(2)] = inst_72474);

(statearr_72504_72518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__17178__auto____0 = (function (){
var statearr_72505 = [null,null,null,null,null,null,null,null];
(statearr_72505[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__17178__auto__);

(statearr_72505[(1)] = (1));

return statearr_72505;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__17178__auto____1 = (function (state_72489){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72489);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72506){var ex__17181__auto__ = e72506;
var statearr_72507_72519 = state_72489;
(statearr_72507_72519[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72489[(4)]))){
var statearr_72508_72520 = state_72489;
(statearr_72508_72520[(1)] = cljs.core.first((state_72489[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72521 = state_72489;
state_72489 = G__72521;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__17178__auto__ = function(state_72489){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__17178__auto____1.call(this,state_72489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72509 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72509[(6)] = c__17304__auto__);

return statearr_72509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72551){
var state_val_72552 = (state_72551[(1)]);
if((state_val_72552 === (7))){
var state_72551__$1 = state_72551;
var statearr_72553_72572 = state_72551__$1;
(statearr_72553_72572[(2)] = arg);

(statearr_72553_72572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72552 === (1))){
var state_72551__$1 = state_72551;
var statearr_72554_72573 = state_72551__$1;
(statearr_72554_72573[(2)] = null);

(statearr_72554_72573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72552 === (4))){
var inst_72522 = (state_72551[(2)]);
var state_72551__$1 = state_72551;
var statearr_72555_72574 = state_72551__$1;
(statearr_72555_72574[(2)] = inst_72522);

(statearr_72555_72574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72552 === (6))){
var state_72551__$1 = state_72551;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72551__$1,(9),arg);
} else {
if((state_val_72552 === (3))){
var inst_72549 = (state_72551[(2)]);
var state_72551__$1 = state_72551;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72551__$1,inst_72549);
} else {
if((state_val_72552 === (2))){
var _ = (function (){var statearr_72557 = state_72551;
(statearr_72557[(4)] = cljs.core.cons((5),(state_72551[(4)])));

return statearr_72557;
})();
var inst_72528 = fluree.db.util.async.channel_QMARK_(arg);
var state_72551__$1 = state_72551;
if(inst_72528){
var statearr_72558_72575 = state_72551__$1;
(statearr_72558_72575[(1)] = (6));

} else {
var statearr_72559_72576 = state_72551__$1;
(statearr_72559_72576[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72552 === (9))){
var inst_72531 = (state_72551[(2)]);
var inst_72532 = fluree.db.util.async.throw_err(inst_72531);
var state_72551__$1 = state_72551;
var statearr_72560_72577 = state_72551__$1;
(statearr_72560_72577[(2)] = inst_72532);

(statearr_72560_72577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72552 === (5))){
var _ = (function (){var statearr_72561 = state_72551;
(statearr_72561[(4)] = cljs.core.rest((state_72551[(4)])));

return statearr_72561;
})();
var state_72551__$1 = state_72551;
var ex72556 = (state_72551__$1[(2)]);
var statearr_72562_72578 = state_72551__$1;
(statearr_72562_72578[(5)] = ex72556);


if((ex72556 instanceof Error)){
var statearr_72563_72579 = state_72551__$1;
(statearr_72563_72579[(1)] = (4));

(statearr_72563_72579[(5)] = null);

} else {
throw ex72556;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72552 === (8))){
var inst_72535 = (state_72551[(2)]);
var inst_72536 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_72535);
var inst_72537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72538 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72540 = [inst_72535];
var inst_72541 = (new cljs.core.PersistentVector(null,1,(5),inst_72539,inst_72540,null));
var inst_72542 = ["empty?",inst_72541,inst_72536];
var inst_72543 = cljs.core.PersistentHashMap.fromArrays(inst_72538,inst_72542);
var inst_72544 = [inst_72543,(10)];
var inst_72545 = (new cljs.core.PersistentVector(null,2,(5),inst_72537,inst_72544,null));
var inst_72546 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72545);
var _ = (function (){var statearr_72564 = state_72551;
(statearr_72564[(4)] = cljs.core.rest((state_72551[(4)])));

return statearr_72564;
})();
var state_72551__$1 = (function (){var statearr_72565 = state_72551;
(statearr_72565[(7)] = inst_72546);

return statearr_72565;
})();
var statearr_72566_72580 = state_72551__$1;
(statearr_72566_72580[(2)] = inst_72536);

(statearr_72566_72580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__17178__auto____0 = (function (){
var statearr_72567 = [null,null,null,null,null,null,null,null];
(statearr_72567[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__17178__auto__);

(statearr_72567[(1)] = (1));

return statearr_72567;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__17178__auto____1 = (function (state_72551){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72551);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72568){var ex__17181__auto__ = e72568;
var statearr_72569_72581 = state_72551;
(statearr_72569_72581[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72551[(4)]))){
var statearr_72570_72582 = state_72551;
(statearr_72570_72582[(1)] = cljs.core.first((state_72551[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72583 = state_72551;
state_72551 = G__72583;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__17178__auto__ = function(state_72551){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__17178__auto____1.call(this,state_72551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72571 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72571[(6)] = c__17304__auto__);

return statearr_72571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___72628 = arguments.length;
var i__4819__auto___72629 = (0);
while(true){
if((i__4819__auto___72629 < len__4818__auto___72628)){
args__4824__auto__.push((arguments[i__4819__auto___72629]));

var G__72630 = (i__4819__auto___72629 + (1));
i__4819__auto___72629 = G__72630;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72611){
var state_val_72612 = (state_72611[(1)]);
if((state_val_72612 === (1))){
var state_72611__$1 = state_72611;
var statearr_72613_72631 = state_72611__$1;
(statearr_72613_72631[(2)] = null);

(statearr_72613_72631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72612 === (2))){
var _ = (function (){var statearr_72614 = state_72611;
(statearr_72614[(4)] = cljs.core.cons((5),(state_72611[(4)])));

return statearr_72614;
})();
var inst_72592 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72611__$1 = state_72611;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72611__$1,(6),inst_72592);
} else {
if((state_val_72612 === (3))){
var inst_72609 = (state_72611[(2)]);
var state_72611__$1 = state_72611;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72611__$1,inst_72609);
} else {
if((state_val_72612 === (4))){
var inst_72586 = (state_72611[(2)]);
var state_72611__$1 = state_72611;
var statearr_72616_72632 = state_72611__$1;
(statearr_72616_72632[(2)] = inst_72586);

(statearr_72616_72632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72612 === (5))){
var _ = (function (){var statearr_72617 = state_72611;
(statearr_72617[(4)] = cljs.core.rest((state_72611[(4)])));

return statearr_72617;
})();
var state_72611__$1 = state_72611;
var ex72615 = (state_72611__$1[(2)]);
var statearr_72618_72633 = state_72611__$1;
(statearr_72618_72633[(5)] = ex72615);


if((ex72615 instanceof Error)){
var statearr_72619_72634 = state_72611__$1;
(statearr_72619_72634[(1)] = (4));

(statearr_72619_72634[(5)] = null);

} else {
throw ex72615;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72612 === (6))){
var inst_72594 = (state_72611[(2)]);
var inst_72595 = fluree.db.util.async.throw_err(inst_72594);
var inst_72596 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_72595);
var inst_72597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72598 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72600 = [inst_72595];
var inst_72601 = (new cljs.core.PersistentVector(null,1,(5),inst_72599,inst_72600,null));
var inst_72602 = ["str",inst_72601,inst_72596];
var inst_72603 = cljs.core.PersistentHashMap.fromArrays(inst_72598,inst_72602);
var inst_72604 = [inst_72603,(10)];
var inst_72605 = (new cljs.core.PersistentVector(null,2,(5),inst_72597,inst_72604,null));
var inst_72606 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72605);
var _ = (function (){var statearr_72620 = state_72611;
(statearr_72620[(4)] = cljs.core.rest((state_72611[(4)])));

return statearr_72620;
})();
var state_72611__$1 = (function (){var statearr_72621 = state_72611;
(statearr_72621[(7)] = inst_72606);

return statearr_72621;
})();
var statearr_72622_72635 = state_72611__$1;
(statearr_72622_72635[(2)] = inst_72596);

(statearr_72622_72635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_72623 = [null,null,null,null,null,null,null,null];
(statearr_72623[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_72623[(1)] = (1));

return statearr_72623;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_72611){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72611);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72624){var ex__17181__auto__ = e72624;
var statearr_72625_72636 = state_72611;
(statearr_72625_72636[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72611[(4)]))){
var statearr_72626_72637 = state_72611;
(statearr_72626_72637[(1)] = cljs.core.first((state_72611[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72638 = state_72611;
state_72611 = G__72638;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_72611){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_72611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72627 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72627[(6)] = c__17304__auto__);

return statearr_72627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq72584){
var G__72585 = cljs.core.first(seq72584);
var seq72584__$1 = cljs.core.next(seq72584);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72585,seq72584__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72664){
var state_val_72665 = (state_72664[(1)]);
if((state_val_72665 === (1))){
var state_72664__$1 = state_72664;
var statearr_72666_72681 = state_72664__$1;
(statearr_72666_72681[(2)] = null);

(statearr_72666_72681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72665 === (2))){
var _ = (function (){var statearr_72667 = state_72664;
(statearr_72667[(4)] = cljs.core.cons((5),(state_72664[(4)])));

return statearr_72667;
})();
var inst_72645 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72664__$1 = state_72664;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72664__$1,(6),inst_72645);
} else {
if((state_val_72665 === (3))){
var inst_72662 = (state_72664[(2)]);
var state_72664__$1 = state_72664;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72664__$1,inst_72662);
} else {
if((state_val_72665 === (4))){
var inst_72639 = (state_72664[(2)]);
var state_72664__$1 = state_72664;
var statearr_72669_72682 = state_72664__$1;
(statearr_72669_72682[(2)] = inst_72639);

(statearr_72669_72682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72665 === (5))){
var _ = (function (){var statearr_72670 = state_72664;
(statearr_72670[(4)] = cljs.core.rest((state_72664[(4)])));

return statearr_72670;
})();
var state_72664__$1 = state_72664;
var ex72668 = (state_72664__$1[(2)]);
var statearr_72671_72683 = state_72664__$1;
(statearr_72671_72683[(5)] = ex72668);


if((ex72668 instanceof Error)){
var statearr_72672_72684 = state_72664__$1;
(statearr_72672_72684[(1)] = (4));

(statearr_72672_72684[(5)] = null);

} else {
throw ex72668;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72665 === (6))){
var inst_72647 = (state_72664[(2)]);
var inst_72648 = fluree.db.util.async.throw_err(inst_72647);
var inst_72649 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_72648);
var inst_72650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72651 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72653 = [inst_72648];
var inst_72654 = (new cljs.core.PersistentVector(null,1,(5),inst_72652,inst_72653,null));
var inst_72655 = ["subs",inst_72654,inst_72649];
var inst_72656 = cljs.core.PersistentHashMap.fromArrays(inst_72651,inst_72655);
var inst_72657 = [inst_72656,(30)];
var inst_72658 = (new cljs.core.PersistentVector(null,2,(5),inst_72650,inst_72657,null));
var inst_72659 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72658);
var _ = (function (){var statearr_72673 = state_72664;
(statearr_72673[(4)] = cljs.core.rest((state_72664[(4)])));

return statearr_72673;
})();
var state_72664__$1 = (function (){var statearr_72674 = state_72664;
(statearr_72674[(7)] = inst_72659);

return statearr_72674;
})();
var statearr_72675_72685 = state_72664__$1;
(statearr_72675_72685[(2)] = inst_72649);

(statearr_72675_72685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__17178__auto____0 = (function (){
var statearr_72676 = [null,null,null,null,null,null,null,null];
(statearr_72676[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__17178__auto__);

(statearr_72676[(1)] = (1));

return statearr_72676;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__17178__auto____1 = (function (state_72664){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72664);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72677){var ex__17181__auto__ = e72677;
var statearr_72678_72686 = state_72664;
(statearr_72678_72686[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72664[(4)]))){
var statearr_72679_72687 = state_72664;
(statearr_72679_72687[(1)] = cljs.core.first((state_72664[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72688 = state_72664;
state_72664 = G__72688;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__17178__auto__ = function(state_72664){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__17178__auto____1.call(this,state_72664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72680 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72680[(6)] = c__17304__auto__);

return statearr_72680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72718){
var state_val_72719 = (state_72718[(1)]);
if((state_val_72719 === (7))){
var state_72718__$1 = state_72718;
var statearr_72720_72739 = state_72718__$1;
(statearr_72720_72739[(2)] = str);

(statearr_72720_72739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (1))){
var state_72718__$1 = state_72718;
var statearr_72721_72740 = state_72718__$1;
(statearr_72721_72740[(2)] = null);

(statearr_72721_72740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (4))){
var inst_72689 = (state_72718[(2)]);
var state_72718__$1 = state_72718;
var statearr_72722_72741 = state_72718__$1;
(statearr_72722_72741[(2)] = inst_72689);

(statearr_72722_72741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (6))){
var state_72718__$1 = state_72718;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72718__$1,(9),str);
} else {
if((state_val_72719 === (3))){
var inst_72716 = (state_72718[(2)]);
var state_72718__$1 = state_72718;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72718__$1,inst_72716);
} else {
if((state_val_72719 === (2))){
var _ = (function (){var statearr_72724 = state_72718;
(statearr_72724[(4)] = cljs.core.cons((5),(state_72718[(4)])));

return statearr_72724;
})();
var inst_72695 = fluree.db.util.async.channel_QMARK_(str);
var state_72718__$1 = state_72718;
if(inst_72695){
var statearr_72725_72742 = state_72718__$1;
(statearr_72725_72742[(1)] = (6));

} else {
var statearr_72726_72743 = state_72718__$1;
(statearr_72726_72743[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (9))){
var inst_72698 = (state_72718[(2)]);
var inst_72699 = fluree.db.util.async.throw_err(inst_72698);
var state_72718__$1 = state_72718;
var statearr_72727_72744 = state_72718__$1;
(statearr_72727_72744[(2)] = inst_72699);

(statearr_72727_72744[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (5))){
var _ = (function (){var statearr_72728 = state_72718;
(statearr_72728[(4)] = cljs.core.rest((state_72718[(4)])));

return statearr_72728;
})();
var state_72718__$1 = state_72718;
var ex72723 = (state_72718__$1[(2)]);
var statearr_72729_72745 = state_72718__$1;
(statearr_72729_72745[(5)] = ex72723);


if((ex72723 instanceof Error)){
var statearr_72730_72746 = state_72718__$1;
(statearr_72730_72746[(1)] = (4));

(statearr_72730_72746[(5)] = null);

} else {
throw ex72723;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72719 === (8))){
var inst_72702 = (state_72718[(2)]);
var inst_72703 = fluree.db.dbfunctions.internal.lower_case(inst_72702);
var inst_72704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72705 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72707 = [inst_72702];
var inst_72708 = (new cljs.core.PersistentVector(null,1,(5),inst_72706,inst_72707,null));
var inst_72709 = ["lower-case",inst_72708,inst_72703];
var inst_72710 = cljs.core.PersistentHashMap.fromArrays(inst_72705,inst_72709);
var inst_72711 = [inst_72710,(10)];
var inst_72712 = (new cljs.core.PersistentVector(null,2,(5),inst_72704,inst_72711,null));
var inst_72713 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72712);
var _ = (function (){var statearr_72731 = state_72718;
(statearr_72731[(4)] = cljs.core.rest((state_72718[(4)])));

return statearr_72731;
})();
var state_72718__$1 = (function (){var statearr_72732 = state_72718;
(statearr_72732[(7)] = inst_72713);

return statearr_72732;
})();
var statearr_72733_72747 = state_72718__$1;
(statearr_72733_72747[(2)] = inst_72703);

(statearr_72733_72747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__17178__auto____0 = (function (){
var statearr_72734 = [null,null,null,null,null,null,null,null];
(statearr_72734[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__17178__auto__);

(statearr_72734[(1)] = (1));

return statearr_72734;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__17178__auto____1 = (function (state_72718){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72718);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72735){var ex__17181__auto__ = e72735;
var statearr_72736_72748 = state_72718;
(statearr_72736_72748[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72718[(4)]))){
var statearr_72737_72749 = state_72718;
(statearr_72737_72749[(1)] = cljs.core.first((state_72718[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72750 = state_72718;
state_72718 = G__72750;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__17178__auto__ = function(state_72718){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__17178__auto____1.call(this,state_72718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72738 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72738[(6)] = c__17304__auto__);

return statearr_72738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72780){
var state_val_72781 = (state_72780[(1)]);
if((state_val_72781 === (7))){
var state_72780__$1 = state_72780;
var statearr_72782_72801 = state_72780__$1;
(statearr_72782_72801[(2)] = str);

(statearr_72782_72801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (1))){
var state_72780__$1 = state_72780;
var statearr_72783_72802 = state_72780__$1;
(statearr_72783_72802[(2)] = null);

(statearr_72783_72802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (4))){
var inst_72751 = (state_72780[(2)]);
var state_72780__$1 = state_72780;
var statearr_72784_72803 = state_72780__$1;
(statearr_72784_72803[(2)] = inst_72751);

(statearr_72784_72803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (6))){
var state_72780__$1 = state_72780;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72780__$1,(9),str);
} else {
if((state_val_72781 === (3))){
var inst_72778 = (state_72780[(2)]);
var state_72780__$1 = state_72780;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72780__$1,inst_72778);
} else {
if((state_val_72781 === (2))){
var _ = (function (){var statearr_72786 = state_72780;
(statearr_72786[(4)] = cljs.core.cons((5),(state_72780[(4)])));

return statearr_72786;
})();
var inst_72757 = fluree.db.util.async.channel_QMARK_(str);
var state_72780__$1 = state_72780;
if(inst_72757){
var statearr_72787_72804 = state_72780__$1;
(statearr_72787_72804[(1)] = (6));

} else {
var statearr_72788_72805 = state_72780__$1;
(statearr_72788_72805[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (9))){
var inst_72760 = (state_72780[(2)]);
var inst_72761 = fluree.db.util.async.throw_err(inst_72760);
var state_72780__$1 = state_72780;
var statearr_72789_72806 = state_72780__$1;
(statearr_72789_72806[(2)] = inst_72761);

(statearr_72789_72806[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (5))){
var _ = (function (){var statearr_72790 = state_72780;
(statearr_72790[(4)] = cljs.core.rest((state_72780[(4)])));

return statearr_72790;
})();
var state_72780__$1 = state_72780;
var ex72785 = (state_72780__$1[(2)]);
var statearr_72791_72807 = state_72780__$1;
(statearr_72791_72807[(5)] = ex72785);


if((ex72785 instanceof Error)){
var statearr_72792_72808 = state_72780__$1;
(statearr_72792_72808[(1)] = (4));

(statearr_72792_72808[(5)] = null);

} else {
throw ex72785;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72781 === (8))){
var inst_72764 = (state_72780[(2)]);
var inst_72765 = fluree.db.dbfunctions.internal.upper_case(inst_72764);
var inst_72766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72767 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72769 = [inst_72764];
var inst_72770 = (new cljs.core.PersistentVector(null,1,(5),inst_72768,inst_72769,null));
var inst_72771 = ["upper-case",inst_72770,inst_72765];
var inst_72772 = cljs.core.PersistentHashMap.fromArrays(inst_72767,inst_72771);
var inst_72773 = [inst_72772,(10)];
var inst_72774 = (new cljs.core.PersistentVector(null,2,(5),inst_72766,inst_72773,null));
var inst_72775 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72774);
var _ = (function (){var statearr_72793 = state_72780;
(statearr_72793[(4)] = cljs.core.rest((state_72780[(4)])));

return statearr_72793;
})();
var state_72780__$1 = (function (){var statearr_72794 = state_72780;
(statearr_72794[(7)] = inst_72775);

return statearr_72794;
})();
var statearr_72795_72809 = state_72780__$1;
(statearr_72795_72809[(2)] = inst_72765);

(statearr_72795_72809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__17178__auto____0 = (function (){
var statearr_72796 = [null,null,null,null,null,null,null,null];
(statearr_72796[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__17178__auto__);

(statearr_72796[(1)] = (1));

return statearr_72796;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__17178__auto____1 = (function (state_72780){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72780);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72797){var ex__17181__auto__ = e72797;
var statearr_72798_72810 = state_72780;
(statearr_72798_72810[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72780[(4)]))){
var statearr_72799_72811 = state_72780;
(statearr_72799_72811[(1)] = cljs.core.first((state_72780[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72812 = state_72780;
state_72780 = G__72812;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__17178__auto__ = function(state_72780){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__17178__auto____1.call(this,state_72780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72800 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72800[(6)] = c__17304__auto__);

return statearr_72800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4210__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4210__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__72814 = arguments.length;
switch (G__72814) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72842){
var state_val_72843 = (state_72842[(1)]);
if((state_val_72843 === (1))){
var state_72842__$1 = state_72842;
var statearr_72844_72860 = state_72842__$1;
(statearr_72844_72860[(2)] = null);

(statearr_72844_72860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72843 === (2))){
var _ = (function (){var statearr_72845 = state_72842;
(statearr_72845[(4)] = cljs.core.cons((5),(state_72842[(4)])));

return statearr_72845;
})();
var inst_72824 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_72842__$1 = state_72842;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72842__$1,(6),inst_72824);
} else {
if((state_val_72843 === (3))){
var inst_72840 = (state_72842[(2)]);
var state_72842__$1 = state_72842;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72842__$1,inst_72840);
} else {
if((state_val_72843 === (4))){
var inst_72815 = (state_72842[(2)]);
var state_72842__$1 = state_72842;
var statearr_72847_72861 = state_72842__$1;
(statearr_72847_72861[(2)] = inst_72815);

(statearr_72847_72861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72843 === (5))){
var _ = (function (){var statearr_72848 = state_72842;
(statearr_72848[(4)] = cljs.core.rest((state_72842[(4)])));

return statearr_72848;
})();
var state_72842__$1 = state_72842;
var ex72846 = (state_72842__$1[(2)]);
var statearr_72849_72862 = state_72842__$1;
(statearr_72849_72862[(5)] = ex72846);


if((ex72846 instanceof Error)){
var statearr_72850_72863 = state_72842__$1;
(statearr_72850_72863[(1)] = (4));

(statearr_72850_72863[(5)] = null);

} else {
throw ex72846;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72843 === (6))){
var inst_72826 = (state_72842[(2)]);
var inst_72827 = fluree.db.util.async.throw_err(inst_72826);
var inst_72828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72827,(0),null);
var inst_72829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72827,(1),null);
var inst_72830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72831 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72832 = ["?s","?ctx",inst_72828];
var inst_72833 = cljs.core.PersistentHashMap.fromArrays(inst_72831,inst_72832);
var inst_72834 = ((10) + inst_72829);
var inst_72835 = [inst_72833,inst_72834];
var inst_72836 = (new cljs.core.PersistentVector(null,2,(5),inst_72830,inst_72835,null));
var inst_72837 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72836);
var _ = (function (){var statearr_72851 = state_72842;
(statearr_72851[(4)] = cljs.core.rest((state_72842[(4)])));

return statearr_72851;
})();
var state_72842__$1 = (function (){var statearr_72852 = state_72842;
(statearr_72852[(7)] = inst_72837);

return statearr_72852;
})();
var statearr_72853_72864 = state_72842__$1;
(statearr_72853_72864[(2)] = inst_72828);

(statearr_72853_72864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_72854 = [null,null,null,null,null,null,null,null];
(statearr_72854[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_72854[(1)] = (1));

return statearr_72854;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_72842){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72842);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72855){var ex__17181__auto__ = e72855;
var statearr_72856_72865 = state_72842;
(statearr_72856_72865[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72842[(4)]))){
var statearr_72857_72866 = state_72842;
(statearr_72857_72866[(1)] = cljs.core.first((state_72842[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72867 = state_72842;
state_72842 = G__72867;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_72842){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_72842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72858 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72858[(6)] = c__17304__auto__);

return statearr_72858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__72869 = arguments.length;
switch (G__72869) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72907){
var state_val_72908 = (state_72907[(1)]);
if((state_val_72908 === (7))){
var inst_72900 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_72907__$1 = state_72907;
var statearr_72909_72929 = state_72907__$1;
(statearr_72909_72929[(2)] = inst_72900);

(statearr_72909_72929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72908 === (1))){
var state_72907__$1 = state_72907;
var statearr_72910_72930 = state_72907__$1;
(statearr_72910_72930[(2)] = null);

(statearr_72910_72930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72908 === (4))){
var inst_72870 = (state_72907[(2)]);
var state_72907__$1 = state_72907;
var statearr_72911_72931 = state_72907__$1;
(statearr_72911_72931[(2)] = inst_72870);

(statearr_72911_72931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72908 === (6))){
var inst_72881 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_72907__$1 = state_72907;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72907__$1,(10),inst_72881);
} else {
if((state_val_72908 === (3))){
var inst_72905 = (state_72907[(2)]);
var state_72907__$1 = state_72907;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72907__$1,inst_72905);
} else {
if((state_val_72908 === (2))){
var _ = (function (){var statearr_72913 = state_72907;
(statearr_72913[(4)] = cljs.core.cons((5),(state_72907[(4)])));

return statearr_72913;
})();
var inst_72876 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_72907__$1 = state_72907;
if(cljs.core.truth_(inst_72876)){
var statearr_72914_72932 = state_72907__$1;
(statearr_72914_72932[(1)] = (6));

} else {
var statearr_72915_72933 = state_72907__$1;
(statearr_72915_72933[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72908 === (9))){
var inst_72887 = (state_72907[(2)]);
var inst_72888 = fluree.db.util.async.throw_err(inst_72887);
var inst_72889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72888,(0),null);
var inst_72890 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72888,(1),null);
var inst_72891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72892 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72893 = ["?p","?ctx",inst_72889];
var inst_72894 = cljs.core.PersistentHashMap.fromArrays(inst_72892,inst_72893);
var inst_72895 = ((10) + inst_72890);
var inst_72896 = [inst_72894,inst_72895];
var inst_72897 = (new cljs.core.PersistentVector(null,2,(5),inst_72891,inst_72896,null));
var inst_72898 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72897);
var state_72907__$1 = (function (){var statearr_72916 = state_72907;
(statearr_72916[(7)] = inst_72898);

return statearr_72916;
})();
var statearr_72917_72934 = state_72907__$1;
(statearr_72917_72934[(2)] = inst_72889);

(statearr_72917_72934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72908 === (5))){
var _ = (function (){var statearr_72918 = state_72907;
(statearr_72918[(4)] = cljs.core.rest((state_72907[(4)])));

return statearr_72918;
})();
var state_72907__$1 = state_72907;
var ex72912 = (state_72907__$1[(2)]);
var statearr_72919_72935 = state_72907__$1;
(statearr_72919_72935[(5)] = ex72912);


if((ex72912 instanceof Error)){
var statearr_72920_72936 = state_72907__$1;
(statearr_72920_72936[(1)] = (4));

(statearr_72920_72936[(5)] = null);

} else {
throw ex72912;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72908 === (10))){
var inst_72883 = (state_72907[(2)]);
var inst_72884 = fluree.db.util.async.throw_err(inst_72883);
var inst_72885 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_72884);
var state_72907__$1 = state_72907;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72907__$1,(9),inst_72885);
} else {
if((state_val_72908 === (8))){
var inst_72902 = (state_72907[(2)]);
var _ = (function (){var statearr_72921 = state_72907;
(statearr_72921[(4)] = cljs.core.rest((state_72907[(4)])));

return statearr_72921;
})();
var state_72907__$1 = state_72907;
var statearr_72922_72937 = state_72907__$1;
(statearr_72922_72937[(2)] = inst_72902);

(statearr_72922_72937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_72923 = [null,null,null,null,null,null,null,null];
(statearr_72923[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_72923[(1)] = (1));

return statearr_72923;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_72907){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72907);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72924){var ex__17181__auto__ = e72924;
var statearr_72925_72938 = state_72907;
(statearr_72925_72938[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72907[(4)]))){
var statearr_72926_72939 = state_72907;
(statearr_72926_72939[(1)] = cljs.core.first((state_72907[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72940 = state_72907;
state_72907 = G__72940;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_72907){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_72907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72927 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72927[(6)] = c__17304__auto__);

return statearr_72927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___72989 = arguments.length;
var i__4819__auto___72990 = (0);
while(true){
if((i__4819__auto___72990 < len__4818__auto___72989)){
args__4824__auto__.push((arguments[i__4819__auto___72990]));

var G__72991 = (i__4819__auto___72990 + (1));
i__4819__auto___72990 = G__72991;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_72972){
var state_val_72973 = (state_72972[(1)]);
if((state_val_72973 === (1))){
var state_72972__$1 = state_72972;
var statearr_72974_72992 = state_72972__$1;
(statearr_72974_72992[(2)] = null);

(statearr_72974_72992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72973 === (2))){
var _ = (function (){var statearr_72975 = state_72972;
(statearr_72975[(4)] = cljs.core.cons((5),(state_72972[(4)])));

return statearr_72975;
})();
var inst_72949 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72972__$1 = state_72972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72972__$1,(6),inst_72949);
} else {
if((state_val_72973 === (3))){
var inst_72970 = (state_72972[(2)]);
var state_72972__$1 = state_72972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72972__$1,inst_72970);
} else {
if((state_val_72973 === (4))){
var inst_72943 = (state_72972[(2)]);
var state_72972__$1 = state_72972;
var statearr_72977_72993 = state_72972__$1;
(statearr_72977_72993[(2)] = inst_72943);

(statearr_72977_72993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72973 === (5))){
var _ = (function (){var statearr_72978 = state_72972;
(statearr_72978[(4)] = cljs.core.rest((state_72972[(4)])));

return statearr_72978;
})();
var state_72972__$1 = state_72972;
var ex72976 = (state_72972__$1[(2)]);
var statearr_72979_72994 = state_72972__$1;
(statearr_72979_72994[(5)] = ex72976);


if((ex72976 instanceof Error)){
var statearr_72980_72995 = state_72972__$1;
(statearr_72980_72995[(1)] = (4));

(statearr_72980_72995[(5)] = null);

} else {
throw ex72976;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72973 === (6))){
var inst_72951 = (state_72972[(2)]);
var inst_72952 = fluree.db.util.async.throw_err(inst_72951);
var inst_72953 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_72952);
var inst_72954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72955 = [inst_72952];
var inst_72956 = (new cljs.core.PersistentVector(null,1,(5),inst_72954,inst_72955,null));
var inst_72957 = cljs.core.count(inst_72956);
var inst_72958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72959 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72961 = [inst_72952];
var inst_72962 = (new cljs.core.PersistentVector(null,1,(5),inst_72960,inst_72961,null));
var inst_72963 = ["and",inst_72962,inst_72953];
var inst_72964 = cljs.core.PersistentHashMap.fromArrays(inst_72959,inst_72963);
var inst_72965 = [inst_72964,inst_72957];
var inst_72966 = (new cljs.core.PersistentVector(null,2,(5),inst_72958,inst_72965,null));
var inst_72967 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72966);
var _ = (function (){var statearr_72981 = state_72972;
(statearr_72981[(4)] = cljs.core.rest((state_72972[(4)])));

return statearr_72981;
})();
var state_72972__$1 = (function (){var statearr_72982 = state_72972;
(statearr_72982[(7)] = inst_72967);

return statearr_72982;
})();
var statearr_72983_72996 = state_72972__$1;
(statearr_72983_72996[(2)] = inst_72953);

(statearr_72983_72996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_72984 = [null,null,null,null,null,null,null,null];
(statearr_72984[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_72984[(1)] = (1));

return statearr_72984;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_72972){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_72972);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e72985){var ex__17181__auto__ = e72985;
var statearr_72986_72997 = state_72972;
(statearr_72986_72997[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_72972[(4)]))){
var statearr_72987_72998 = state_72972;
(statearr_72987_72998[(1)] = cljs.core.first((state_72972[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72999 = state_72972;
state_72972 = G__72999;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_72972){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_72972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_72988 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_72988[(6)] = c__17304__auto__);

return statearr_72988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq72941){
var G__72942 = cljs.core.first(seq72941);
var seq72941__$1 = cljs.core.next(seq72941);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72942,seq72941__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___73048 = arguments.length;
var i__4819__auto___73049 = (0);
while(true){
if((i__4819__auto___73049 < len__4818__auto___73048)){
args__4824__auto__.push((arguments[i__4819__auto___73049]));

var G__73050 = (i__4819__auto___73049 + (1));
i__4819__auto___73049 = G__73050;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73031){
var state_val_73032 = (state_73031[(1)]);
if((state_val_73032 === (1))){
var state_73031__$1 = state_73031;
var statearr_73033_73051 = state_73031__$1;
(statearr_73033_73051[(2)] = null);

(statearr_73033_73051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73032 === (2))){
var _ = (function (){var statearr_73034 = state_73031;
(statearr_73034[(4)] = cljs.core.cons((5),(state_73031[(4)])));

return statearr_73034;
})();
var inst_73008 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73031__$1 = state_73031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73031__$1,(6),inst_73008);
} else {
if((state_val_73032 === (3))){
var inst_73029 = (state_73031[(2)]);
var state_73031__$1 = state_73031;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73031__$1,inst_73029);
} else {
if((state_val_73032 === (4))){
var inst_73002 = (state_73031[(2)]);
var state_73031__$1 = state_73031;
var statearr_73036_73052 = state_73031__$1;
(statearr_73036_73052[(2)] = inst_73002);

(statearr_73036_73052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73032 === (5))){
var _ = (function (){var statearr_73037 = state_73031;
(statearr_73037[(4)] = cljs.core.rest((state_73031[(4)])));

return statearr_73037;
})();
var state_73031__$1 = state_73031;
var ex73035 = (state_73031__$1[(2)]);
var statearr_73038_73053 = state_73031__$1;
(statearr_73038_73053[(5)] = ex73035);


if((ex73035 instanceof Error)){
var statearr_73039_73054 = state_73031__$1;
(statearr_73039_73054[(1)] = (4));

(statearr_73039_73054[(5)] = null);

} else {
throw ex73035;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73032 === (6))){
var inst_73010 = (state_73031[(2)]);
var inst_73011 = fluree.db.util.async.throw_err(inst_73010);
var inst_73012 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_73011);
var inst_73013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73014 = [inst_73011];
var inst_73015 = (new cljs.core.PersistentVector(null,1,(5),inst_73013,inst_73014,null));
var inst_73016 = cljs.core.count(inst_73015);
var inst_73017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73018 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73020 = [inst_73011];
var inst_73021 = (new cljs.core.PersistentVector(null,1,(5),inst_73019,inst_73020,null));
var inst_73022 = ["or",inst_73021,inst_73012];
var inst_73023 = cljs.core.PersistentHashMap.fromArrays(inst_73018,inst_73022);
var inst_73024 = [inst_73023,inst_73016];
var inst_73025 = (new cljs.core.PersistentVector(null,2,(5),inst_73017,inst_73024,null));
var inst_73026 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73025);
var _ = (function (){var statearr_73040 = state_73031;
(statearr_73040[(4)] = cljs.core.rest((state_73031[(4)])));

return statearr_73040;
})();
var state_73031__$1 = (function (){var statearr_73041 = state_73031;
(statearr_73041[(7)] = inst_73026);

return statearr_73041;
})();
var statearr_73042_73055 = state_73031__$1;
(statearr_73042_73055[(2)] = inst_73012);

(statearr_73042_73055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_73043 = [null,null,null,null,null,null,null,null];
(statearr_73043[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_73043[(1)] = (1));

return statearr_73043;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_73031){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73031);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73044){var ex__17181__auto__ = e73044;
var statearr_73045_73056 = state_73031;
(statearr_73045_73056[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73031[(4)]))){
var statearr_73046_73057 = state_73031;
(statearr_73046_73057[(1)] = cljs.core.first((state_73031[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73058 = state_73031;
state_73031 = G__73058;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_73031){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_73031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73047 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73047[(6)] = c__17304__auto__);

return statearr_73047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq73000){
var G__73001 = cljs.core.first(seq73000);
var seq73000__$1 = cljs.core.next(seq73000);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73001,seq73000__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73096){
var state_val_73097 = (state_73096[(1)]);
if((state_val_73097 === (7))){
var inst_73072 = fluree.db.util.async.channel_QMARK_(coll);
var state_73096__$1 = state_73096;
if(inst_73072){
var statearr_73098_73121 = state_73096__$1;
(statearr_73098_73121[(1)] = (10));

} else {
var statearr_73099_73122 = state_73096__$1;
(statearr_73099_73122[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73097 === (1))){
var state_73096__$1 = state_73096;
var statearr_73100_73123 = state_73096__$1;
(statearr_73100_73123[(2)] = null);

(statearr_73100_73123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73097 === (4))){
var inst_73059 = (state_73096[(2)]);
var state_73096__$1 = state_73096;
var statearr_73101_73124 = state_73096__$1;
(statearr_73101_73124[(2)] = inst_73059);

(statearr_73101_73124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73097 === (13))){
var inst_73075 = (state_73096[(2)]);
var inst_73076 = fluree.db.util.async.throw_err(inst_73075);
var state_73096__$1 = state_73096;
var statearr_73102_73125 = state_73096__$1;
(statearr_73102_73125[(2)] = inst_73076);

(statearr_73102_73125[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73097 === (6))){
var inst_73067 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_73096__$1 = state_73096;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73096__$1,(9),inst_73067);
} else {
if((state_val_73097 === (3))){
var inst_73094 = (state_73096[(2)]);
var state_73096__$1 = state_73096;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73096__$1,inst_73094);
} else {
if((state_val_73097 === (12))){
var inst_73079 = (state_73096[(2)]);
var state_73096__$1 = state_73096;
var statearr_73103_73126 = state_73096__$1;
(statearr_73103_73126[(2)] = inst_73079);

(statearr_73103_73126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73097 === (2))){
var _ = (function (){var statearr_73104 = state_73096;
(statearr_73104[(4)] = cljs.core.cons((5),(state_73096[(4)])));

return statearr_73104;
})();
var inst_73065 = cljs.core.vector_QMARK_(coll);
var state_73096__$1 = state_73096;
if(inst_73065){
var statearr_73105_73127 = state_73096__$1;
(statearr_73105_73127[(1)] = (6));

} else {
var statearr_73106_73128 = state_73096__$1;
(statearr_73106_73128[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73097 === (11))){
var state_73096__$1 = state_73096;
var statearr_73108_73129 = state_73096__$1;
(statearr_73108_73129[(2)] = coll);

(statearr_73108_73129[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73097 === (9))){
var inst_73069 = (state_73096[(2)]);
var inst_73070 = fluree.db.util.async.throw_err(inst_73069);
var state_73096__$1 = state_73096;
var statearr_73109_73130 = state_73096__$1;
(statearr_73109_73130[(2)] = inst_73070);

(statearr_73109_73130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73097 === (5))){
var _ = (function (){var statearr_73110 = state_73096;
(statearr_73110[(4)] = cljs.core.rest((state_73096[(4)])));

return statearr_73110;
})();
var state_73096__$1 = state_73096;
var ex73107 = (state_73096__$1[(2)]);
var statearr_73111_73131 = state_73096__$1;
(statearr_73111_73131[(5)] = ex73107);


if((ex73107 instanceof Error)){
var statearr_73112_73132 = state_73096__$1;
(statearr_73112_73132[(1)] = (4));

(statearr_73112_73132[(5)] = null);

} else {
throw ex73107;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73097 === (10))){
var state_73096__$1 = state_73096;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73096__$1,(13),coll);
} else {
if((state_val_73097 === (8))){
var inst_73081 = (state_73096[(2)]);
var inst_73082 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_73081);
var inst_73083 = cljs.core.count(inst_73082);
var inst_73084 = ((9) + inst_73083);
var inst_73085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73086 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73087 = ["count",inst_73081,inst_73083];
var inst_73088 = cljs.core.PersistentHashMap.fromArrays(inst_73086,inst_73087);
var inst_73089 = [inst_73088,inst_73084];
var inst_73090 = (new cljs.core.PersistentVector(null,2,(5),inst_73085,inst_73089,null));
var inst_73091 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73090);
var _ = (function (){var statearr_73113 = state_73096;
(statearr_73113[(4)] = cljs.core.rest((state_73096[(4)])));

return statearr_73113;
})();
var state_73096__$1 = (function (){var statearr_73114 = state_73096;
(statearr_73114[(7)] = inst_73091);

return statearr_73114;
})();
var statearr_73115_73133 = state_73096__$1;
(statearr_73115_73133[(2)] = inst_73083);

(statearr_73115_73133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__17178__auto____0 = (function (){
var statearr_73116 = [null,null,null,null,null,null,null,null];
(statearr_73116[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__17178__auto__);

(statearr_73116[(1)] = (1));

return statearr_73116;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__17178__auto____1 = (function (state_73096){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73096);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73117){var ex__17181__auto__ = e73117;
var statearr_73118_73134 = state_73096;
(statearr_73118_73134[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73096[(4)]))){
var statearr_73119_73135 = state_73096;
(statearr_73119_73135[(1)] = cljs.core.first((state_73096[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73136 = state_73096;
state_73096 = G__73136;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__17178__auto__ = function(state_73096){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__17178__auto____1.call(this,state_73096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73120 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73120[(6)] = c__17304__auto__);

return statearr_73120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73186){
var state_val_73187 = (state_73186[(1)]);
if((state_val_73187 === (7))){
var state_73186__$1 = state_73186;
var statearr_73188_73221 = state_73186__$1;
(statearr_73188_73221[(2)] = subject);

(statearr_73188_73221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (1))){
var state_73186__$1 = state_73186;
var statearr_73189_73222 = state_73186__$1;
(statearr_73189_73222[(2)] = null);

(statearr_73189_73222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (4))){
var inst_73137 = (state_73186[(2)]);
var state_73186__$1 = state_73186;
var statearr_73190_73223 = state_73186__$1;
(statearr_73190_73223[(2)] = inst_73137);

(statearr_73190_73223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (15))){
var inst_73150 = (state_73186[(7)]);
var state_73186__$1 = state_73186;
var statearr_73191_73224 = state_73186__$1;
(statearr_73191_73224[(2)] = inst_73150);

(statearr_73191_73224[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (13))){
var inst_73154 = (state_73186[(2)]);
var inst_73155 = fluree.db.util.async.throw_err(inst_73154);
var state_73186__$1 = state_73186;
var statearr_73192_73225 = state_73186__$1;
(statearr_73192_73225[(2)] = inst_73155);

(statearr_73192_73225[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (6))){
var state_73186__$1 = state_73186;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73186__$1,(9),subject);
} else {
if((state_val_73187 === (17))){
var inst_73150 = (state_73186[(7)]);
var inst_73164 = cljs.core.first(inst_73150);
var state_73186__$1 = state_73186;
var statearr_73193_73226 = state_73186__$1;
(statearr_73193_73226[(2)] = inst_73164);

(statearr_73193_73226[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (3))){
var inst_73184 = (state_73186[(2)]);
var state_73186__$1 = state_73186;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73186__$1,inst_73184);
} else {
if((state_val_73187 === (12))){
var inst_73150 = (state_73186[(7)]);
var inst_73158 = (state_73186[(2)]);
var inst_73159 = cljs.core.vector_QMARK_(inst_73150);
var state_73186__$1 = (function (){var statearr_73194 = state_73186;
(statearr_73194[(8)] = inst_73158);

return statearr_73194;
})();
if(inst_73159){
var statearr_73195_73227 = state_73186__$1;
(statearr_73195_73227[(1)] = (14));

} else {
var statearr_73196_73228 = state_73186__$1;
(statearr_73196_73228[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (2))){
var _ = (function (){var statearr_73197 = state_73186;
(statearr_73197[(4)] = cljs.core.cons((5),(state_73186[(4)])));

return statearr_73197;
})();
var inst_73143 = fluree.db.util.async.channel_QMARK_(subject);
var state_73186__$1 = state_73186;
if(inst_73143){
var statearr_73198_73229 = state_73186__$1;
(statearr_73198_73229[(1)] = (6));

} else {
var statearr_73199_73230 = state_73186__$1;
(statearr_73199_73230[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (19))){
var inst_73167 = (state_73186[(2)]);
var state_73186__$1 = state_73186;
var statearr_73200_73231 = state_73186__$1;
(statearr_73200_73231[(2)] = inst_73167);

(statearr_73200_73231[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (11))){
var state_73186__$1 = state_73186;
var statearr_73202_73232 = state_73186__$1;
(statearr_73202_73232[(2)] = pred);

(statearr_73202_73232[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (9))){
var inst_73146 = (state_73186[(2)]);
var inst_73147 = fluree.db.util.async.throw_err(inst_73146);
var state_73186__$1 = state_73186;
var statearr_73203_73233 = state_73186__$1;
(statearr_73203_73233[(2)] = inst_73147);

(statearr_73203_73233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (5))){
var _ = (function (){var statearr_73204 = state_73186;
(statearr_73204[(4)] = cljs.core.rest((state_73186[(4)])));

return statearr_73204;
})();
var state_73186__$1 = state_73186;
var ex73201 = (state_73186__$1[(2)]);
var statearr_73205_73234 = state_73186__$1;
(statearr_73205_73234[(5)] = ex73201);


if((ex73201 instanceof Error)){
var statearr_73206_73235 = state_73186__$1;
(statearr_73206_73235[(1)] = (4));

(statearr_73206_73235[(5)] = null);

} else {
throw ex73201;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (14))){
var inst_73150 = (state_73186[(7)]);
var inst_73161 = cljs.core.count(inst_73150);
var inst_73162 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_73161);
var state_73186__$1 = state_73186;
if(inst_73162){
var statearr_73207_73236 = state_73186__$1;
(statearr_73207_73236[(1)] = (17));

} else {
var statearr_73208_73237 = state_73186__$1;
(statearr_73208_73237[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (16))){
var inst_73158 = (state_73186[(8)]);
var inst_73150 = (state_73186[(7)]);
var inst_73170 = (state_73186[(2)]);
var inst_73171 = fluree.db.dbfunctions.internal.get(inst_73170,inst_73158);
var inst_73172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73173 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73175 = [inst_73150,inst_73158];
var inst_73176 = (new cljs.core.PersistentVector(null,2,(5),inst_73174,inst_73175,null));
var inst_73177 = ["get",inst_73176,inst_73171];
var inst_73178 = cljs.core.PersistentHashMap.fromArrays(inst_73173,inst_73177);
var inst_73179 = [inst_73178,(10)];
var inst_73180 = (new cljs.core.PersistentVector(null,2,(5),inst_73172,inst_73179,null));
var inst_73181 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73180);
var _ = (function (){var statearr_73209 = state_73186;
(statearr_73209[(4)] = cljs.core.rest((state_73186[(4)])));

return statearr_73209;
})();
var state_73186__$1 = (function (){var statearr_73210 = state_73186;
(statearr_73210[(9)] = inst_73181);

return statearr_73210;
})();
var statearr_73211_73238 = state_73186__$1;
(statearr_73211_73238[(2)] = inst_73171);

(statearr_73211_73238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (10))){
var state_73186__$1 = state_73186;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73186__$1,(13),pred);
} else {
if((state_val_73187 === (18))){
var inst_73150 = (state_73186[(7)]);
var state_73186__$1 = state_73186;
var statearr_73212_73239 = state_73186__$1;
(statearr_73212_73239[(2)] = inst_73150);

(statearr_73212_73239[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73187 === (8))){
var inst_73150 = (state_73186[(2)]);
var inst_73151 = fluree.db.util.async.channel_QMARK_(pred);
var state_73186__$1 = (function (){var statearr_73213 = state_73186;
(statearr_73213[(7)] = inst_73150);

return statearr_73213;
})();
if(inst_73151){
var statearr_73214_73240 = state_73186__$1;
(statearr_73214_73240[(1)] = (10));

} else {
var statearr_73215_73241 = state_73186__$1;
(statearr_73215_73241[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__17178__auto____0 = (function (){
var statearr_73216 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73216[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__17178__auto__);

(statearr_73216[(1)] = (1));

return statearr_73216;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__17178__auto____1 = (function (state_73186){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73186);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73217){var ex__17181__auto__ = e73217;
var statearr_73218_73242 = state_73186;
(statearr_73218_73242[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73186[(4)]))){
var statearr_73219_73243 = state_73186;
(statearr_73219_73243[(1)] = cljs.core.first((state_73186[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73244 = state_73186;
state_73186 = G__73244;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__17178__auto__ = function(state_73186){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__17178__auto____1.call(this,state_73186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73220 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73220[(6)] = c__17304__auto__);

return statearr_73220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73283){
var state_val_73284 = (state_73283[(1)]);
if((state_val_73284 === (7))){
var inst_73251 = (state_73283[(7)]);
var state_73283__$1 = state_73283;
var statearr_73285_73309 = state_73283__$1;
(statearr_73285_73309[(2)] = inst_73251);

(statearr_73285_73309[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73284 === (1))){
var state_73283__$1 = state_73283;
var statearr_73286_73310 = state_73283__$1;
(statearr_73286_73310[(2)] = null);

(statearr_73286_73310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73284 === (4))){
var inst_73245 = (state_73283[(2)]);
var state_73283__$1 = state_73283;
var statearr_73287_73311 = state_73283__$1;
(statearr_73287_73311[(2)] = inst_73245);

(statearr_73287_73311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73284 === (6))){
var inst_73253 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73283__$1 = state_73283;
var statearr_73288_73312 = state_73283__$1;
(statearr_73288_73312[(2)] = inst_73253);

(statearr_73288_73312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73284 === (3))){
var inst_73281 = (state_73283[(2)]);
var state_73283__$1 = state_73283;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73283__$1,inst_73281);
} else {
if((state_val_73284 === (12))){
var inst_73263 = (state_73283[(2)]);
var inst_73264 = fluree.db.util.async.throw_err(inst_73263);
var inst_73265 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73264,(0),null);
var inst_73266 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73264,(1),null);
var inst_73267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73268 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73269 = ["?pO","?ctx",inst_73265];
var inst_73270 = cljs.core.PersistentHashMap.fromArrays(inst_73268,inst_73269);
var inst_73271 = ((10) + inst_73266);
var inst_73272 = [inst_73270,inst_73271];
var inst_73273 = (new cljs.core.PersistentVector(null,2,(5),inst_73267,inst_73272,null));
var inst_73274 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73273);
var state_73283__$1 = (function (){var statearr_73289 = state_73283;
(statearr_73289[(8)] = inst_73274);

return statearr_73289;
})();
var statearr_73290_73313 = state_73283__$1;
(statearr_73290_73313[(2)] = inst_73265);

(statearr_73290_73313[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73284 === (2))){
var inst_73251 = (state_73283[(7)]);
var _ = (function (){var statearr_73291 = state_73283;
(statearr_73291[(4)] = cljs.core.cons((5),(state_73283[(4)])));

return statearr_73291;
})();
var inst_73251__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73283__$1 = (function (){var statearr_73292 = state_73283;
(statearr_73292[(7)] = inst_73251__$1);

return statearr_73292;
})();
if(cljs.core.truth_(inst_73251__$1)){
var statearr_73293_73314 = state_73283__$1;
(statearr_73293_73314[(1)] = (6));

} else {
var statearr_73294_73315 = state_73283__$1;
(statearr_73294_73315[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73284 === (11))){
var inst_73278 = (state_73283[(2)]);
var _ = (function (){var statearr_73296 = state_73283;
(statearr_73296[(4)] = cljs.core.rest((state_73283[(4)])));

return statearr_73296;
})();
var state_73283__$1 = state_73283;
var statearr_73297_73316 = state_73283__$1;
(statearr_73297_73316[(2)] = inst_73278);

(statearr_73297_73316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73284 === (9))){
var inst_73261 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_73283__$1 = state_73283;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73283__$1,(12),inst_73261);
} else {
if((state_val_73284 === (5))){
var _ = (function (){var statearr_73298 = state_73283;
(statearr_73298[(4)] = cljs.core.rest((state_73283[(4)])));

return statearr_73298;
})();
var state_73283__$1 = state_73283;
var ex73295 = (state_73283__$1[(2)]);
var statearr_73299_73317 = state_73283__$1;
(statearr_73299_73317[(5)] = ex73295);


if((ex73295 instanceof Error)){
var statearr_73300_73318 = state_73283__$1;
(statearr_73300_73318[(1)] = (4));

(statearr_73300_73318[(5)] = null);

} else {
throw ex73295;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73284 === (10))){
var inst_73276 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_73283__$1 = state_73283;
var statearr_73301_73319 = state_73283__$1;
(statearr_73301_73319[(2)] = inst_73276);

(statearr_73301_73319[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73284 === (8))){
var inst_73256 = (state_73283[(2)]);
var state_73283__$1 = state_73283;
if(cljs.core.truth_(inst_73256)){
var statearr_73302_73320 = state_73283__$1;
(statearr_73302_73320[(1)] = (9));

} else {
var statearr_73303_73321 = state_73283__$1;
(statearr_73303_73321[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__17178__auto____0 = (function (){
var statearr_73304 = [null,null,null,null,null,null,null,null,null];
(statearr_73304[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__17178__auto__);

(statearr_73304[(1)] = (1));

return statearr_73304;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__17178__auto____1 = (function (state_73283){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73283);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73305){var ex__17181__auto__ = e73305;
var statearr_73306_73322 = state_73283;
(statearr_73306_73322[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73283[(4)]))){
var statearr_73307_73323 = state_73283;
(statearr_73307_73323[(1)] = cljs.core.first((state_73283[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73324 = state_73283;
state_73283 = G__73324;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__17178__auto__ = function(state_73283){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__17178__auto____1.call(this,state_73283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73308 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73308[(6)] = c__17304__auto__);

return statearr_73308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73376){
var state_val_73377 = (state_73376[(1)]);
if((state_val_73377 === (7))){
var state_73376__$1 = state_73376;
var statearr_73378_73411 = state_73376__$1;
(statearr_73378_73411[(2)] = subject);

(statearr_73378_73411[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (1))){
var state_73376__$1 = state_73376;
var statearr_73379_73412 = state_73376__$1;
(statearr_73379_73412[(2)] = null);

(statearr_73379_73412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (4))){
var inst_73325 = (state_73376[(2)]);
var state_73376__$1 = state_73376;
var statearr_73380_73413 = state_73376__$1;
(statearr_73380_73413[(2)] = inst_73325);

(statearr_73380_73413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (15))){
var inst_73338 = (state_73376[(7)]);
var state_73376__$1 = state_73376;
var statearr_73381_73414 = state_73376__$1;
(statearr_73381_73414[(2)] = inst_73338);

(statearr_73381_73414[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (13))){
var inst_73342 = (state_73376[(2)]);
var inst_73343 = fluree.db.util.async.throw_err(inst_73342);
var state_73376__$1 = state_73376;
var statearr_73382_73415 = state_73376__$1;
(statearr_73382_73415[(2)] = inst_73343);

(statearr_73382_73415[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (6))){
var state_73376__$1 = state_73376;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73376__$1,(9),subject);
} else {
if((state_val_73377 === (17))){
var inst_73338 = (state_73376[(7)]);
var inst_73352 = cljs.core.first(inst_73338);
var state_73376__$1 = state_73376;
var statearr_73383_73416 = state_73376__$1;
(statearr_73383_73416[(2)] = inst_73352);

(statearr_73383_73416[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (3))){
var inst_73374 = (state_73376[(2)]);
var state_73376__$1 = state_73376;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73376__$1,inst_73374);
} else {
if((state_val_73377 === (12))){
var inst_73338 = (state_73376[(7)]);
var inst_73346 = (state_73376[(2)]);
var inst_73347 = cljs.core.vector_QMARK_(inst_73338);
var state_73376__$1 = (function (){var statearr_73384 = state_73376;
(statearr_73384[(8)] = inst_73346);

return statearr_73384;
})();
if(inst_73347){
var statearr_73385_73417 = state_73376__$1;
(statearr_73385_73417[(1)] = (14));

} else {
var statearr_73386_73418 = state_73376__$1;
(statearr_73386_73418[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (2))){
var _ = (function (){var statearr_73387 = state_73376;
(statearr_73387[(4)] = cljs.core.cons((5),(state_73376[(4)])));

return statearr_73387;
})();
var inst_73331 = fluree.db.util.async.channel_QMARK_(subject);
var state_73376__$1 = state_73376;
if(inst_73331){
var statearr_73388_73419 = state_73376__$1;
(statearr_73388_73419[(1)] = (6));

} else {
var statearr_73389_73420 = state_73376__$1;
(statearr_73389_73420[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (19))){
var inst_73355 = (state_73376[(2)]);
var state_73376__$1 = state_73376;
var statearr_73390_73421 = state_73376__$1;
(statearr_73390_73421[(2)] = inst_73355);

(statearr_73390_73421[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (11))){
var state_73376__$1 = state_73376;
var statearr_73392_73422 = state_73376__$1;
(statearr_73392_73422[(2)] = path);

(statearr_73392_73422[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (9))){
var inst_73334 = (state_73376[(2)]);
var inst_73335 = fluree.db.util.async.throw_err(inst_73334);
var state_73376__$1 = state_73376;
var statearr_73393_73423 = state_73376__$1;
(statearr_73393_73423[(2)] = inst_73335);

(statearr_73393_73423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (5))){
var _ = (function (){var statearr_73394 = state_73376;
(statearr_73394[(4)] = cljs.core.rest((state_73376[(4)])));

return statearr_73394;
})();
var state_73376__$1 = state_73376;
var ex73391 = (state_73376__$1[(2)]);
var statearr_73395_73424 = state_73376__$1;
(statearr_73395_73424[(5)] = ex73391);


if((ex73391 instanceof Error)){
var statearr_73396_73425 = state_73376__$1;
(statearr_73396_73425[(1)] = (4));

(statearr_73396_73425[(5)] = null);

} else {
throw ex73391;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (14))){
var inst_73338 = (state_73376[(7)]);
var inst_73349 = cljs.core.count(inst_73338);
var inst_73350 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_73349);
var state_73376__$1 = state_73376;
if(inst_73350){
var statearr_73397_73426 = state_73376__$1;
(statearr_73397_73426[(1)] = (17));

} else {
var statearr_73398_73427 = state_73376__$1;
(statearr_73398_73427[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (16))){
var inst_73338 = (state_73376[(7)]);
var inst_73346 = (state_73376[(8)]);
var inst_73358 = (state_73376[(2)]);
var inst_73359 = fluree.db.dbfunctions.internal.get_all(inst_73358,inst_73346);
var inst_73360 = cljs.core.count(inst_73346);
var inst_73361 = ((9) + inst_73360);
var inst_73362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73363 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73365 = [inst_73338,inst_73346];
var inst_73366 = (new cljs.core.PersistentVector(null,2,(5),inst_73364,inst_73365,null));
var inst_73367 = ["get-all",inst_73366,inst_73359];
var inst_73368 = cljs.core.PersistentHashMap.fromArrays(inst_73363,inst_73367);
var inst_73369 = [inst_73368,inst_73361];
var inst_73370 = (new cljs.core.PersistentVector(null,2,(5),inst_73362,inst_73369,null));
var inst_73371 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73370);
var _ = (function (){var statearr_73399 = state_73376;
(statearr_73399[(4)] = cljs.core.rest((state_73376[(4)])));

return statearr_73399;
})();
var state_73376__$1 = (function (){var statearr_73400 = state_73376;
(statearr_73400[(9)] = inst_73371);

return statearr_73400;
})();
var statearr_73401_73428 = state_73376__$1;
(statearr_73401_73428[(2)] = inst_73359);

(statearr_73401_73428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (10))){
var state_73376__$1 = state_73376;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73376__$1,(13),path);
} else {
if((state_val_73377 === (18))){
var inst_73338 = (state_73376[(7)]);
var state_73376__$1 = state_73376;
var statearr_73402_73429 = state_73376__$1;
(statearr_73402_73429[(2)] = inst_73338);

(statearr_73402_73429[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73377 === (8))){
var inst_73338 = (state_73376[(2)]);
var inst_73339 = fluree.db.util.async.channel_QMARK_(path);
var state_73376__$1 = (function (){var statearr_73403 = state_73376;
(statearr_73403[(7)] = inst_73338);

return statearr_73403;
})();
if(inst_73339){
var statearr_73404_73430 = state_73376__$1;
(statearr_73404_73430[(1)] = (10));

} else {
var statearr_73405_73431 = state_73376__$1;
(statearr_73405_73431[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__17178__auto____0 = (function (){
var statearr_73406 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73406[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__17178__auto__);

(statearr_73406[(1)] = (1));

return statearr_73406;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__17178__auto____1 = (function (state_73376){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73376);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73407){var ex__17181__auto__ = e73407;
var statearr_73408_73432 = state_73376;
(statearr_73408_73432[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73376[(4)]))){
var statearr_73409_73433 = state_73376;
(statearr_73409_73433[(1)] = cljs.core.first((state_73376[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73434 = state_73376;
state_73376 = G__73434;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__17178__auto__ = function(state_73376){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__17178__auto____1.call(this,state_73376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73410 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73410[(6)] = c__17304__auto__);

return statearr_73410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73473){
var state_val_73474 = (state_73473[(1)]);
if((state_val_73474 === (7))){
var state_73473__$1 = state_73473;
var statearr_73475_73499 = state_73473__$1;
(statearr_73475_73499[(2)] = subject);

(statearr_73475_73499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73474 === (1))){
var state_73473__$1 = state_73473;
var statearr_73476_73500 = state_73473__$1;
(statearr_73476_73500[(2)] = null);

(statearr_73476_73500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73474 === (4))){
var inst_73435 = (state_73473[(2)]);
var state_73473__$1 = state_73473;
var statearr_73477_73501 = state_73473__$1;
(statearr_73477_73501[(2)] = inst_73435);

(statearr_73477_73501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73474 === (13))){
var inst_73452 = (state_73473[(2)]);
var inst_73453 = fluree.db.util.async.throw_err(inst_73452);
var state_73473__$1 = state_73473;
var statearr_73478_73502 = state_73473__$1;
(statearr_73478_73502[(2)] = inst_73453);

(statearr_73478_73502[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73474 === (6))){
var state_73473__$1 = state_73473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73473__$1,(9),subject);
} else {
if((state_val_73474 === (3))){
var inst_73471 = (state_73473[(2)]);
var state_73473__$1 = state_73473;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73473__$1,inst_73471);
} else {
if((state_val_73474 === (12))){
var inst_73448 = (state_73473[(7)]);
var inst_73456 = (state_73473[(2)]);
var inst_73457 = fluree.db.dbfunctions.internal.get_in(inst_73448,inst_73456);
var inst_73458 = cljs.core.count(inst_73456);
var inst_73459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73460 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73462 = [inst_73448,inst_73456];
var inst_73463 = (new cljs.core.PersistentVector(null,2,(5),inst_73461,inst_73462,null));
var inst_73464 = ["get-in",inst_73463,inst_73457];
var inst_73465 = cljs.core.PersistentHashMap.fromArrays(inst_73460,inst_73464);
var inst_73466 = [inst_73465,inst_73458];
var inst_73467 = (new cljs.core.PersistentVector(null,2,(5),inst_73459,inst_73466,null));
var inst_73468 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73467);
var _ = (function (){var statearr_73479 = state_73473;
(statearr_73479[(4)] = cljs.core.rest((state_73473[(4)])));

return statearr_73479;
})();
var state_73473__$1 = (function (){var statearr_73480 = state_73473;
(statearr_73480[(8)] = inst_73468);

return statearr_73480;
})();
var statearr_73481_73503 = state_73473__$1;
(statearr_73481_73503[(2)] = inst_73457);

(statearr_73481_73503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73474 === (2))){
var _ = (function (){var statearr_73482 = state_73473;
(statearr_73482[(4)] = cljs.core.cons((5),(state_73473[(4)])));

return statearr_73482;
})();
var inst_73441 = fluree.db.util.async.channel_QMARK_(subject);
var state_73473__$1 = state_73473;
if(inst_73441){
var statearr_73483_73504 = state_73473__$1;
(statearr_73483_73504[(1)] = (6));

} else {
var statearr_73484_73505 = state_73473__$1;
(statearr_73484_73505[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73474 === (11))){
var state_73473__$1 = state_73473;
var statearr_73486_73506 = state_73473__$1;
(statearr_73486_73506[(2)] = path);

(statearr_73486_73506[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73474 === (9))){
var inst_73444 = (state_73473[(2)]);
var inst_73445 = fluree.db.util.async.throw_err(inst_73444);
var state_73473__$1 = state_73473;
var statearr_73487_73507 = state_73473__$1;
(statearr_73487_73507[(2)] = inst_73445);

(statearr_73487_73507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73474 === (5))){
var _ = (function (){var statearr_73488 = state_73473;
(statearr_73488[(4)] = cljs.core.rest((state_73473[(4)])));

return statearr_73488;
})();
var state_73473__$1 = state_73473;
var ex73485 = (state_73473__$1[(2)]);
var statearr_73489_73508 = state_73473__$1;
(statearr_73489_73508[(5)] = ex73485);


if((ex73485 instanceof Error)){
var statearr_73490_73509 = state_73473__$1;
(statearr_73490_73509[(1)] = (4));

(statearr_73490_73509[(5)] = null);

} else {
throw ex73485;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73474 === (10))){
var state_73473__$1 = state_73473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73473__$1,(13),path);
} else {
if((state_val_73474 === (8))){
var inst_73448 = (state_73473[(2)]);
var inst_73449 = fluree.db.util.async.channel_QMARK_(path);
var state_73473__$1 = (function (){var statearr_73491 = state_73473;
(statearr_73491[(7)] = inst_73448);

return statearr_73491;
})();
if(inst_73449){
var statearr_73492_73510 = state_73473__$1;
(statearr_73492_73510[(1)] = (10));

} else {
var statearr_73493_73511 = state_73473__$1;
(statearr_73493_73511[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__17178__auto____0 = (function (){
var statearr_73494 = [null,null,null,null,null,null,null,null,null];
(statearr_73494[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__17178__auto__);

(statearr_73494[(1)] = (1));

return statearr_73494;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__17178__auto____1 = (function (state_73473){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73473);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73495){var ex__17181__auto__ = e73495;
var statearr_73496_73512 = state_73473;
(statearr_73496_73512[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73473[(4)]))){
var statearr_73497_73513 = state_73473;
(statearr_73497_73513[(1)] = cljs.core.first((state_73473[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73514 = state_73473;
state_73473 = G__73514;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__17178__auto__ = function(state_73473){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__17178__auto____1.call(this,state_73473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73498 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73498[(6)] = c__17304__auto__);

return statearr_73498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73559){
var state_val_73560 = (state_73559[(1)]);
if((state_val_73560 === (7))){
var state_73559__$1 = state_73559;
var statearr_73561_73590 = state_73559__$1;
(statearr_73561_73590[(2)] = coll);

(statearr_73561_73590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73560 === (1))){
var state_73559__$1 = state_73559;
var statearr_73562_73591 = state_73559__$1;
(statearr_73562_73591[(2)] = null);

(statearr_73562_73591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73560 === (4))){
var inst_73515 = (state_73559[(2)]);
var state_73559__$1 = state_73559;
var statearr_73563_73592 = state_73559__$1;
(statearr_73563_73592[(2)] = inst_73515);

(statearr_73563_73592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73560 === (15))){
var inst_73535 = (state_73559[(7)]);
var inst_73543 = (state_73559[(2)]);
var inst_73544 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_73535,inst_73543);
var inst_73545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73546 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73547 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73548 = [inst_73535,inst_73543];
var inst_73549 = (new cljs.core.PersistentVector(null,2,(5),inst_73547,inst_73548,null));
var inst_73550 = ["contains?",inst_73549,inst_73544];
var inst_73551 = cljs.core.PersistentHashMap.fromArrays(inst_73546,inst_73550);
var inst_73552 = [inst_73551,(10)];
var inst_73553 = (new cljs.core.PersistentVector(null,2,(5),inst_73545,inst_73552,null));
var inst_73554 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73553);
var _ = (function (){var statearr_73564 = state_73559;
(statearr_73564[(4)] = cljs.core.rest((state_73559[(4)])));

return statearr_73564;
})();
var state_73559__$1 = (function (){var statearr_73565 = state_73559;
(statearr_73565[(8)] = inst_73554);

return statearr_73565;
})();
var statearr_73566_73593 = state_73559__$1;
(statearr_73566_73593[(2)] = inst_73544);

(statearr_73566_73593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73560 === (13))){
var state_73559__$1 = state_73559;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73559__$1,(16),key);
} else {
if((state_val_73560 === (6))){
var state_73559__$1 = state_73559;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73559__$1,(9),coll);
} else {
if((state_val_73560 === (3))){
var inst_73557 = (state_73559[(2)]);
var state_73559__$1 = state_73559;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73559__$1,inst_73557);
} else {
if((state_val_73560 === (12))){
var inst_73535 = (state_73559[(2)]);
var inst_73536 = fluree.db.util.async.channel_QMARK_(key);
var state_73559__$1 = (function (){var statearr_73567 = state_73559;
(statearr_73567[(7)] = inst_73535);

return statearr_73567;
})();
if(inst_73536){
var statearr_73568_73594 = state_73559__$1;
(statearr_73568_73594[(1)] = (13));

} else {
var statearr_73569_73595 = state_73559__$1;
(statearr_73569_73595[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73560 === (2))){
var _ = (function (){var statearr_73570 = state_73559;
(statearr_73570[(4)] = cljs.core.cons((5),(state_73559[(4)])));

return statearr_73570;
})();
var inst_73521 = fluree.db.util.async.channel_QMARK_(coll);
var state_73559__$1 = state_73559;
if(inst_73521){
var statearr_73571_73596 = state_73559__$1;
(statearr_73571_73596[(1)] = (6));

} else {
var statearr_73572_73597 = state_73559__$1;
(statearr_73572_73597[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73560 === (11))){
var inst_73528 = (state_73559[(9)]);
var inst_73532 = cljs.core.flatten(inst_73528);
var inst_73533 = cljs.core.set(inst_73532);
var state_73559__$1 = state_73559;
var statearr_73574_73598 = state_73559__$1;
(statearr_73574_73598[(2)] = inst_73533);

(statearr_73574_73598[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73560 === (9))){
var inst_73524 = (state_73559[(2)]);
var inst_73525 = fluree.db.util.async.throw_err(inst_73524);
var state_73559__$1 = state_73559;
var statearr_73575_73599 = state_73559__$1;
(statearr_73575_73599[(2)] = inst_73525);

(statearr_73575_73599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73560 === (5))){
var _ = (function (){var statearr_73576 = state_73559;
(statearr_73576[(4)] = cljs.core.rest((state_73559[(4)])));

return statearr_73576;
})();
var state_73559__$1 = state_73559;
var ex73573 = (state_73559__$1[(2)]);
var statearr_73577_73600 = state_73559__$1;
(statearr_73577_73600[(5)] = ex73573);


if((ex73573 instanceof Error)){
var statearr_73578_73601 = state_73559__$1;
(statearr_73578_73601[(1)] = (4));

(statearr_73578_73601[(5)] = null);

} else {
throw ex73573;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73560 === (14))){
var state_73559__$1 = state_73559;
var statearr_73579_73602 = state_73559__$1;
(statearr_73579_73602[(2)] = key);

(statearr_73579_73602[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73560 === (16))){
var inst_73539 = (state_73559[(2)]);
var inst_73540 = fluree.db.util.async.throw_err(inst_73539);
var state_73559__$1 = state_73559;
var statearr_73580_73603 = state_73559__$1;
(statearr_73580_73603[(2)] = inst_73540);

(statearr_73580_73603[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73560 === (10))){
var inst_73528 = (state_73559[(9)]);
var state_73559__$1 = state_73559;
var statearr_73581_73604 = state_73559__$1;
(statearr_73581_73604[(2)] = inst_73528);

(statearr_73581_73604[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73560 === (8))){
var inst_73528 = (state_73559[(9)]);
var inst_73528__$1 = (state_73559[(2)]);
var inst_73529 = cljs.core.set_QMARK_(inst_73528__$1);
var state_73559__$1 = (function (){var statearr_73582 = state_73559;
(statearr_73582[(9)] = inst_73528__$1);

return statearr_73582;
})();
if(inst_73529){
var statearr_73583_73605 = state_73559__$1;
(statearr_73583_73605[(1)] = (10));

} else {
var statearr_73584_73606 = state_73559__$1;
(statearr_73584_73606[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__17178__auto____0 = (function (){
var statearr_73585 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73585[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__17178__auto__);

(statearr_73585[(1)] = (1));

return statearr_73585;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__17178__auto____1 = (function (state_73559){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73559);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73586){var ex__17181__auto__ = e73586;
var statearr_73587_73607 = state_73559;
(statearr_73587_73607[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73559[(4)]))){
var statearr_73588_73608 = state_73559;
(statearr_73588_73608[(1)] = cljs.core.first((state_73559[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73609 = state_73559;
state_73559 = G__73609;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__17178__auto__ = function(state_73559){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__17178__auto____1.call(this,state_73559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73589 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73589[(6)] = c__17304__auto__);

return statearr_73589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___73681 = arguments.length;
var i__4819__auto___73682 = (0);
while(true){
if((i__4819__auto___73682 < len__4818__auto___73681)){
args__4824__auto__.push((arguments[i__4819__auto___73682]));

var G__73683 = (i__4819__auto___73682 + (1));
i__4819__auto___73682 = G__73683;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73655){
var state_val_73656 = (state_73655[(1)]);
if((state_val_73656 === (7))){
var inst_73621 = (state_73655[(7)]);
var inst_73625 = cljs.core.first(inst_73621);
var inst_73626 = cljs.core.coll_QMARK_(inst_73625);
var state_73655__$1 = state_73655;
var statearr_73657_73684 = state_73655__$1;
(statearr_73657_73684[(2)] = inst_73626);

(statearr_73657_73684[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73656 === (1))){
var state_73655__$1 = state_73655;
var statearr_73658_73685 = state_73655__$1;
(statearr_73658_73685[(2)] = null);

(statearr_73658_73685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73656 === (4))){
var inst_73612 = (state_73655[(2)]);
var state_73655__$1 = state_73655;
var statearr_73659_73686 = state_73655__$1;
(statearr_73659_73686[(2)] = inst_73612);

(statearr_73659_73686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73656 === (6))){
var inst_73623 = (state_73655[(8)]);
var inst_73621 = (state_73655[(7)]);
var inst_73620 = (state_73655[(2)]);
var inst_73621__$1 = fluree.db.util.async.throw_err(inst_73620);
var inst_73622 = cljs.core.count(inst_73621__$1);
var inst_73623__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_73622);
var state_73655__$1 = (function (){var statearr_73660 = state_73655;
(statearr_73660[(8)] = inst_73623__$1);

(statearr_73660[(7)] = inst_73621__$1);

return statearr_73660;
})();
if(inst_73623__$1){
var statearr_73661_73687 = state_73655__$1;
(statearr_73661_73687[(1)] = (7));

} else {
var statearr_73662_73688 = state_73655__$1;
(statearr_73662_73688[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73656 === (3))){
var inst_73653 = (state_73655[(2)]);
var state_73655__$1 = state_73655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73655__$1,inst_73653);
} else {
if((state_val_73656 === (12))){
var inst_73634 = (state_73655[(2)]);
var inst_73635 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_73634);
var inst_73636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73637 = [inst_73634];
var inst_73638 = (new cljs.core.PersistentVector(null,1,(5),inst_73636,inst_73637,null));
var inst_73639 = cljs.core.count(inst_73638);
var inst_73640 = ((9) + inst_73639);
var inst_73641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73642 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73644 = [inst_73634];
var inst_73645 = (new cljs.core.PersistentVector(null,1,(5),inst_73643,inst_73644,null));
var inst_73646 = ["hash-set",inst_73645,inst_73635];
var inst_73647 = cljs.core.PersistentHashMap.fromArrays(inst_73642,inst_73646);
var inst_73648 = [inst_73647,inst_73640];
var inst_73649 = (new cljs.core.PersistentVector(null,2,(5),inst_73641,inst_73648,null));
var inst_73650 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73649);
var _ = (function (){var statearr_73663 = state_73655;
(statearr_73663[(4)] = cljs.core.rest((state_73655[(4)])));

return statearr_73663;
})();
var state_73655__$1 = (function (){var statearr_73664 = state_73655;
(statearr_73664[(9)] = inst_73650);

return statearr_73664;
})();
var statearr_73665_73689 = state_73655__$1;
(statearr_73665_73689[(2)] = inst_73635);

(statearr_73665_73689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73656 === (2))){
var _ = (function (){var statearr_73666 = state_73655;
(statearr_73666[(4)] = cljs.core.cons((5),(state_73655[(4)])));

return statearr_73666;
})();
var inst_73618 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73655__$1 = state_73655;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73655__$1,(6),inst_73618);
} else {
if((state_val_73656 === (11))){
var inst_73621 = (state_73655[(7)]);
var state_73655__$1 = state_73655;
var statearr_73668_73690 = state_73655__$1;
(statearr_73668_73690[(2)] = inst_73621);

(statearr_73668_73690[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73656 === (9))){
var inst_73629 = (state_73655[(2)]);
var state_73655__$1 = state_73655;
if(cljs.core.truth_(inst_73629)){
var statearr_73669_73691 = state_73655__$1;
(statearr_73669_73691[(1)] = (10));

} else {
var statearr_73670_73692 = state_73655__$1;
(statearr_73670_73692[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73656 === (5))){
var _ = (function (){var statearr_73671 = state_73655;
(statearr_73671[(4)] = cljs.core.rest((state_73655[(4)])));

return statearr_73671;
})();
var state_73655__$1 = state_73655;
var ex73667 = (state_73655__$1[(2)]);
var statearr_73672_73693 = state_73655__$1;
(statearr_73672_73693[(5)] = ex73667);


if((ex73667 instanceof Error)){
var statearr_73673_73694 = state_73655__$1;
(statearr_73673_73694[(1)] = (4));

(statearr_73673_73694[(5)] = null);

} else {
throw ex73667;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73656 === (10))){
var inst_73621 = (state_73655[(7)]);
var inst_73631 = cljs.core.first(inst_73621);
var state_73655__$1 = state_73655;
var statearr_73674_73695 = state_73655__$1;
(statearr_73674_73695[(2)] = inst_73631);

(statearr_73674_73695[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73656 === (8))){
var inst_73623 = (state_73655[(8)]);
var state_73655__$1 = state_73655;
var statearr_73675_73696 = state_73655__$1;
(statearr_73675_73696[(2)] = inst_73623);

(statearr_73675_73696[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_73676 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73676[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_73676[(1)] = (1));

return statearr_73676;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_73655){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73655);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73677){var ex__17181__auto__ = e73677;
var statearr_73678_73697 = state_73655;
(statearr_73678_73697[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73655[(4)]))){
var statearr_73679_73698 = state_73655;
(statearr_73679_73698[(1)] = cljs.core.first((state_73655[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73699 = state_73655;
state_73655 = G__73699;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_73655){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_73655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73680 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73680[(6)] = c__17304__auto__);

return statearr_73680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq73610){
var G__73611 = cljs.core.first(seq73610);
var seq73610__$1 = cljs.core.next(seq73610);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73611,seq73610__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___73749 = arguments.length;
var i__4819__auto___73750 = (0);
while(true){
if((i__4819__auto___73750 < len__4818__auto___73749)){
args__4824__auto__.push((arguments[i__4819__auto___73750]));

var G__73751 = (i__4819__auto___73750 + (1));
i__4819__auto___73750 = G__73751;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73732){
var state_val_73733 = (state_73732[(1)]);
if((state_val_73733 === (1))){
var state_73732__$1 = state_73732;
var statearr_73734_73752 = state_73732__$1;
(statearr_73734_73752[(2)] = null);

(statearr_73734_73752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (2))){
var _ = (function (){var statearr_73735 = state_73732;
(statearr_73735[(4)] = cljs.core.cons((5),(state_73732[(4)])));

return statearr_73735;
})();
var inst_73708 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73732__$1 = state_73732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73732__$1,(6),inst_73708);
} else {
if((state_val_73733 === (3))){
var inst_73730 = (state_73732[(2)]);
var state_73732__$1 = state_73732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73732__$1,inst_73730);
} else {
if((state_val_73733 === (4))){
var inst_73702 = (state_73732[(2)]);
var state_73732__$1 = state_73732;
var statearr_73737_73753 = state_73732__$1;
(statearr_73737_73753[(2)] = inst_73702);

(statearr_73737_73753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (5))){
var _ = (function (){var statearr_73738 = state_73732;
(statearr_73738[(4)] = cljs.core.rest((state_73732[(4)])));

return statearr_73738;
})();
var state_73732__$1 = state_73732;
var ex73736 = (state_73732__$1[(2)]);
var statearr_73739_73754 = state_73732__$1;
(statearr_73739_73754[(5)] = ex73736);


if((ex73736 instanceof Error)){
var statearr_73740_73755 = state_73732__$1;
(statearr_73740_73755[(1)] = (4));

(statearr_73740_73755[(5)] = null);

} else {
throw ex73736;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73733 === (6))){
var inst_73710 = (state_73732[(2)]);
var inst_73711 = fluree.db.util.async.throw_err(inst_73710);
var inst_73712 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_73711);
var inst_73713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73714 = [inst_73711];
var inst_73715 = (new cljs.core.PersistentVector(null,1,(5),inst_73713,inst_73714,null));
var inst_73716 = cljs.core.count(inst_73715);
var inst_73717 = ((9) + inst_73716);
var inst_73718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73719 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73721 = [inst_73711];
var inst_73722 = (new cljs.core.PersistentVector(null,1,(5),inst_73720,inst_73721,null));
var inst_73723 = ["==",inst_73722,inst_73712];
var inst_73724 = cljs.core.PersistentHashMap.fromArrays(inst_73719,inst_73723);
var inst_73725 = [inst_73724,inst_73717];
var inst_73726 = (new cljs.core.PersistentVector(null,2,(5),inst_73718,inst_73725,null));
var inst_73727 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73726);
var _ = (function (){var statearr_73741 = state_73732;
(statearr_73741[(4)] = cljs.core.rest((state_73732[(4)])));

return statearr_73741;
})();
var state_73732__$1 = (function (){var statearr_73742 = state_73732;
(statearr_73742[(7)] = inst_73727);

return statearr_73742;
})();
var statearr_73743_73756 = state_73732__$1;
(statearr_73743_73756[(2)] = inst_73712);

(statearr_73743_73756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_73744 = [null,null,null,null,null,null,null,null];
(statearr_73744[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_73744[(1)] = (1));

return statearr_73744;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_73732){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73732);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73745){var ex__17181__auto__ = e73745;
var statearr_73746_73757 = state_73732;
(statearr_73746_73757[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73732[(4)]))){
var statearr_73747_73758 = state_73732;
(statearr_73747_73758[(1)] = cljs.core.first((state_73732[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73759 = state_73732;
state_73732 = G__73759;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_73732){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_73732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73748 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73748[(6)] = c__17304__auto__);

return statearr_73748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq73700){
var G__73701 = cljs.core.first(seq73700);
var seq73700__$1 = cljs.core.next(seq73700);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73701,seq73700__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___73809 = arguments.length;
var i__4819__auto___73810 = (0);
while(true){
if((i__4819__auto___73810 < len__4818__auto___73809)){
args__4824__auto__.push((arguments[i__4819__auto___73810]));

var G__73811 = (i__4819__auto___73810 + (1));
i__4819__auto___73810 = G__73811;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73792){
var state_val_73793 = (state_73792[(1)]);
if((state_val_73793 === (1))){
var state_73792__$1 = state_73792;
var statearr_73794_73812 = state_73792__$1;
(statearr_73794_73812[(2)] = null);

(statearr_73794_73812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73793 === (2))){
var _ = (function (){var statearr_73795 = state_73792;
(statearr_73795[(4)] = cljs.core.cons((5),(state_73792[(4)])));

return statearr_73795;
})();
var inst_73768 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73792__$1 = state_73792;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73792__$1,(6),inst_73768);
} else {
if((state_val_73793 === (3))){
var inst_73790 = (state_73792[(2)]);
var state_73792__$1 = state_73792;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73792__$1,inst_73790);
} else {
if((state_val_73793 === (4))){
var inst_73762 = (state_73792[(2)]);
var state_73792__$1 = state_73792;
var statearr_73797_73813 = state_73792__$1;
(statearr_73797_73813[(2)] = inst_73762);

(statearr_73797_73813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73793 === (5))){
var _ = (function (){var statearr_73798 = state_73792;
(statearr_73798[(4)] = cljs.core.rest((state_73792[(4)])));

return statearr_73798;
})();
var state_73792__$1 = state_73792;
var ex73796 = (state_73792__$1[(2)]);
var statearr_73799_73814 = state_73792__$1;
(statearr_73799_73814[(5)] = ex73796);


if((ex73796 instanceof Error)){
var statearr_73800_73815 = state_73792__$1;
(statearr_73800_73815[(1)] = (4));

(statearr_73800_73815[(5)] = null);

} else {
throw ex73796;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73793 === (6))){
var inst_73770 = (state_73792[(2)]);
var inst_73771 = fluree.db.util.async.throw_err(inst_73770);
var inst_73772 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_73771);
var inst_73773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73774 = [inst_73771];
var inst_73775 = (new cljs.core.PersistentVector(null,1,(5),inst_73773,inst_73774,null));
var inst_73776 = cljs.core.count(inst_73775);
var inst_73777 = ((9) + inst_73776);
var inst_73778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73779 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73781 = [inst_73771];
var inst_73782 = (new cljs.core.PersistentVector(null,1,(5),inst_73780,inst_73781,null));
var inst_73783 = [">",inst_73782,inst_73772];
var inst_73784 = cljs.core.PersistentHashMap.fromArrays(inst_73779,inst_73783);
var inst_73785 = [inst_73784,inst_73777];
var inst_73786 = (new cljs.core.PersistentVector(null,2,(5),inst_73778,inst_73785,null));
var inst_73787 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73786);
var _ = (function (){var statearr_73801 = state_73792;
(statearr_73801[(4)] = cljs.core.rest((state_73792[(4)])));

return statearr_73801;
})();
var state_73792__$1 = (function (){var statearr_73802 = state_73792;
(statearr_73802[(7)] = inst_73787);

return statearr_73802;
})();
var statearr_73803_73816 = state_73792__$1;
(statearr_73803_73816[(2)] = inst_73772);

(statearr_73803_73816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_73804 = [null,null,null,null,null,null,null,null];
(statearr_73804[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_73804[(1)] = (1));

return statearr_73804;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_73792){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73792);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73805){var ex__17181__auto__ = e73805;
var statearr_73806_73817 = state_73792;
(statearr_73806_73817[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73792[(4)]))){
var statearr_73807_73818 = state_73792;
(statearr_73807_73818[(1)] = cljs.core.first((state_73792[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73819 = state_73792;
state_73792 = G__73819;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_73792){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_73792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73808 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73808[(6)] = c__17304__auto__);

return statearr_73808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq73760){
var G__73761 = cljs.core.first(seq73760);
var seq73760__$1 = cljs.core.next(seq73760);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73761,seq73760__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___73869 = arguments.length;
var i__4819__auto___73870 = (0);
while(true){
if((i__4819__auto___73870 < len__4818__auto___73869)){
args__4824__auto__.push((arguments[i__4819__auto___73870]));

var G__73871 = (i__4819__auto___73870 + (1));
i__4819__auto___73870 = G__73871;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73852){
var state_val_73853 = (state_73852[(1)]);
if((state_val_73853 === (1))){
var state_73852__$1 = state_73852;
var statearr_73854_73872 = state_73852__$1;
(statearr_73854_73872[(2)] = null);

(statearr_73854_73872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73853 === (2))){
var _ = (function (){var statearr_73855 = state_73852;
(statearr_73855[(4)] = cljs.core.cons((5),(state_73852[(4)])));

return statearr_73855;
})();
var inst_73828 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73852__$1 = state_73852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73852__$1,(6),inst_73828);
} else {
if((state_val_73853 === (3))){
var inst_73850 = (state_73852[(2)]);
var state_73852__$1 = state_73852;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73852__$1,inst_73850);
} else {
if((state_val_73853 === (4))){
var inst_73822 = (state_73852[(2)]);
var state_73852__$1 = state_73852;
var statearr_73857_73873 = state_73852__$1;
(statearr_73857_73873[(2)] = inst_73822);

(statearr_73857_73873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73853 === (5))){
var _ = (function (){var statearr_73858 = state_73852;
(statearr_73858[(4)] = cljs.core.rest((state_73852[(4)])));

return statearr_73858;
})();
var state_73852__$1 = state_73852;
var ex73856 = (state_73852__$1[(2)]);
var statearr_73859_73874 = state_73852__$1;
(statearr_73859_73874[(5)] = ex73856);


if((ex73856 instanceof Error)){
var statearr_73860_73875 = state_73852__$1;
(statearr_73860_73875[(1)] = (4));

(statearr_73860_73875[(5)] = null);

} else {
throw ex73856;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73853 === (6))){
var inst_73830 = (state_73852[(2)]);
var inst_73831 = fluree.db.util.async.throw_err(inst_73830);
var inst_73832 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_73831);
var inst_73833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73834 = [inst_73831];
var inst_73835 = (new cljs.core.PersistentVector(null,1,(5),inst_73833,inst_73834,null));
var inst_73836 = cljs.core.count(inst_73835);
var inst_73837 = ((9) + inst_73836);
var inst_73838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73839 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73841 = [inst_73831];
var inst_73842 = (new cljs.core.PersistentVector(null,1,(5),inst_73840,inst_73841,null));
var inst_73843 = ["<",inst_73842,inst_73832];
var inst_73844 = cljs.core.PersistentHashMap.fromArrays(inst_73839,inst_73843);
var inst_73845 = [inst_73844,inst_73837];
var inst_73846 = (new cljs.core.PersistentVector(null,2,(5),inst_73838,inst_73845,null));
var inst_73847 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73846);
var _ = (function (){var statearr_73861 = state_73852;
(statearr_73861[(4)] = cljs.core.rest((state_73852[(4)])));

return statearr_73861;
})();
var state_73852__$1 = (function (){var statearr_73862 = state_73852;
(statearr_73862[(7)] = inst_73847);

return statearr_73862;
})();
var statearr_73863_73876 = state_73852__$1;
(statearr_73863_73876[(2)] = inst_73832);

(statearr_73863_73876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_73864 = [null,null,null,null,null,null,null,null];
(statearr_73864[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_73864[(1)] = (1));

return statearr_73864;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_73852){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73852);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73865){var ex__17181__auto__ = e73865;
var statearr_73866_73877 = state_73852;
(statearr_73866_73877[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73852[(4)]))){
var statearr_73867_73878 = state_73852;
(statearr_73867_73878[(1)] = cljs.core.first((state_73852[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73879 = state_73852;
state_73852 = G__73879;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_73852){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_73852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73868 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73868[(6)] = c__17304__auto__);

return statearr_73868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq73820){
var G__73821 = cljs.core.first(seq73820);
var seq73820__$1 = cljs.core.next(seq73820);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73821,seq73820__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___73929 = arguments.length;
var i__4819__auto___73930 = (0);
while(true){
if((i__4819__auto___73930 < len__4818__auto___73929)){
args__4824__auto__.push((arguments[i__4819__auto___73930]));

var G__73931 = (i__4819__auto___73930 + (1));
i__4819__auto___73930 = G__73931;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73912){
var state_val_73913 = (state_73912[(1)]);
if((state_val_73913 === (1))){
var state_73912__$1 = state_73912;
var statearr_73914_73932 = state_73912__$1;
(statearr_73914_73932[(2)] = null);

(statearr_73914_73932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73913 === (2))){
var _ = (function (){var statearr_73915 = state_73912;
(statearr_73915[(4)] = cljs.core.cons((5),(state_73912[(4)])));

return statearr_73915;
})();
var inst_73888 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73912__$1 = state_73912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73912__$1,(6),inst_73888);
} else {
if((state_val_73913 === (3))){
var inst_73910 = (state_73912[(2)]);
var state_73912__$1 = state_73912;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73912__$1,inst_73910);
} else {
if((state_val_73913 === (4))){
var inst_73882 = (state_73912[(2)]);
var state_73912__$1 = state_73912;
var statearr_73917_73933 = state_73912__$1;
(statearr_73917_73933[(2)] = inst_73882);

(statearr_73917_73933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73913 === (5))){
var _ = (function (){var statearr_73918 = state_73912;
(statearr_73918[(4)] = cljs.core.rest((state_73912[(4)])));

return statearr_73918;
})();
var state_73912__$1 = state_73912;
var ex73916 = (state_73912__$1[(2)]);
var statearr_73919_73934 = state_73912__$1;
(statearr_73919_73934[(5)] = ex73916);


if((ex73916 instanceof Error)){
var statearr_73920_73935 = state_73912__$1;
(statearr_73920_73935[(1)] = (4));

(statearr_73920_73935[(5)] = null);

} else {
throw ex73916;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73913 === (6))){
var inst_73890 = (state_73912[(2)]);
var inst_73891 = fluree.db.util.async.throw_err(inst_73890);
var inst_73892 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_73891);
var inst_73893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73894 = [inst_73891];
var inst_73895 = (new cljs.core.PersistentVector(null,1,(5),inst_73893,inst_73894,null));
var inst_73896 = cljs.core.count(inst_73895);
var inst_73897 = ((9) + inst_73896);
var inst_73898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73899 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73901 = [inst_73891];
var inst_73902 = (new cljs.core.PersistentVector(null,1,(5),inst_73900,inst_73901,null));
var inst_73903 = ["<=",inst_73902,inst_73892];
var inst_73904 = cljs.core.PersistentHashMap.fromArrays(inst_73899,inst_73903);
var inst_73905 = [inst_73904,inst_73897];
var inst_73906 = (new cljs.core.PersistentVector(null,2,(5),inst_73898,inst_73905,null));
var inst_73907 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73906);
var _ = (function (){var statearr_73921 = state_73912;
(statearr_73921[(4)] = cljs.core.rest((state_73912[(4)])));

return statearr_73921;
})();
var state_73912__$1 = (function (){var statearr_73922 = state_73912;
(statearr_73922[(7)] = inst_73907);

return statearr_73922;
})();
var statearr_73923_73936 = state_73912__$1;
(statearr_73923_73936[(2)] = inst_73892);

(statearr_73923_73936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_73924 = [null,null,null,null,null,null,null,null];
(statearr_73924[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_73924[(1)] = (1));

return statearr_73924;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_73912){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73912);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73925){var ex__17181__auto__ = e73925;
var statearr_73926_73937 = state_73912;
(statearr_73926_73937[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73912[(4)]))){
var statearr_73927_73938 = state_73912;
(statearr_73927_73938[(1)] = cljs.core.first((state_73912[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73939 = state_73912;
state_73912 = G__73939;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_73912){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_73912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73928 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73928[(6)] = c__17304__auto__);

return statearr_73928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq73880){
var G__73881 = cljs.core.first(seq73880);
var seq73880__$1 = cljs.core.next(seq73880);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73881,seq73880__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___73989 = arguments.length;
var i__4819__auto___73990 = (0);
while(true){
if((i__4819__auto___73990 < len__4818__auto___73989)){
args__4824__auto__.push((arguments[i__4819__auto___73990]));

var G__73991 = (i__4819__auto___73990 + (1));
i__4819__auto___73990 = G__73991;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_73972){
var state_val_73973 = (state_73972[(1)]);
if((state_val_73973 === (1))){
var state_73972__$1 = state_73972;
var statearr_73974_73992 = state_73972__$1;
(statearr_73974_73992[(2)] = null);

(statearr_73974_73992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73973 === (2))){
var _ = (function (){var statearr_73975 = state_73972;
(statearr_73975[(4)] = cljs.core.cons((5),(state_73972[(4)])));

return statearr_73975;
})();
var inst_73948 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73972__$1 = state_73972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73972__$1,(6),inst_73948);
} else {
if((state_val_73973 === (3))){
var inst_73970 = (state_73972[(2)]);
var state_73972__$1 = state_73972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73972__$1,inst_73970);
} else {
if((state_val_73973 === (4))){
var inst_73942 = (state_73972[(2)]);
var state_73972__$1 = state_73972;
var statearr_73977_73993 = state_73972__$1;
(statearr_73977_73993[(2)] = inst_73942);

(statearr_73977_73993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73973 === (5))){
var _ = (function (){var statearr_73978 = state_73972;
(statearr_73978[(4)] = cljs.core.rest((state_73972[(4)])));

return statearr_73978;
})();
var state_73972__$1 = state_73972;
var ex73976 = (state_73972__$1[(2)]);
var statearr_73979_73994 = state_73972__$1;
(statearr_73979_73994[(5)] = ex73976);


if((ex73976 instanceof Error)){
var statearr_73980_73995 = state_73972__$1;
(statearr_73980_73995[(1)] = (4));

(statearr_73980_73995[(5)] = null);

} else {
throw ex73976;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73973 === (6))){
var inst_73950 = (state_73972[(2)]);
var inst_73951 = fluree.db.util.async.throw_err(inst_73950);
var inst_73952 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_73951);
var inst_73953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73954 = [inst_73951];
var inst_73955 = (new cljs.core.PersistentVector(null,1,(5),inst_73953,inst_73954,null));
var inst_73956 = cljs.core.count(inst_73955);
var inst_73957 = ((9) + inst_73956);
var inst_73958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73959 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73961 = [inst_73951];
var inst_73962 = (new cljs.core.PersistentVector(null,1,(5),inst_73960,inst_73961,null));
var inst_73963 = [">=",inst_73962,inst_73952];
var inst_73964 = cljs.core.PersistentHashMap.fromArrays(inst_73959,inst_73963);
var inst_73965 = [inst_73964,inst_73957];
var inst_73966 = (new cljs.core.PersistentVector(null,2,(5),inst_73958,inst_73965,null));
var inst_73967 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73966);
var _ = (function (){var statearr_73981 = state_73972;
(statearr_73981[(4)] = cljs.core.rest((state_73972[(4)])));

return statearr_73981;
})();
var state_73972__$1 = (function (){var statearr_73982 = state_73972;
(statearr_73982[(7)] = inst_73967);

return statearr_73982;
})();
var statearr_73983_73996 = state_73972__$1;
(statearr_73983_73996[(2)] = inst_73952);

(statearr_73983_73996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_73984 = [null,null,null,null,null,null,null,null];
(statearr_73984[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_73984[(1)] = (1));

return statearr_73984;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_73972){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_73972);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e73985){var ex__17181__auto__ = e73985;
var statearr_73986_73997 = state_73972;
(statearr_73986_73997[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_73972[(4)]))){
var statearr_73987_73998 = state_73972;
(statearr_73987_73998[(1)] = cljs.core.first((state_73972[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73999 = state_73972;
state_73972 = G__73999;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_73972){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_73972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_73988 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_73988[(6)] = c__17304__auto__);

return statearr_73988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq73940){
var G__73941 = cljs.core.first(seq73940);
var seq73940__$1 = cljs.core.next(seq73940);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73941,seq73940__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___74049 = arguments.length;
var i__4819__auto___74050 = (0);
while(true){
if((i__4819__auto___74050 < len__4818__auto___74049)){
args__4824__auto__.push((arguments[i__4819__auto___74050]));

var G__74051 = (i__4819__auto___74050 + (1));
i__4819__auto___74050 = G__74051;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74032){
var state_val_74033 = (state_74032[(1)]);
if((state_val_74033 === (1))){
var state_74032__$1 = state_74032;
var statearr_74034_74052 = state_74032__$1;
(statearr_74034_74052[(2)] = null);

(statearr_74034_74052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74033 === (2))){
var _ = (function (){var statearr_74035 = state_74032;
(statearr_74035[(4)] = cljs.core.cons((5),(state_74032[(4)])));

return statearr_74035;
})();
var inst_74008 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74032__$1 = state_74032;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74032__$1,(6),inst_74008);
} else {
if((state_val_74033 === (3))){
var inst_74030 = (state_74032[(2)]);
var state_74032__$1 = state_74032;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74032__$1,inst_74030);
} else {
if((state_val_74033 === (4))){
var inst_74002 = (state_74032[(2)]);
var state_74032__$1 = state_74032;
var statearr_74037_74053 = state_74032__$1;
(statearr_74037_74053[(2)] = inst_74002);

(statearr_74037_74053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74033 === (5))){
var _ = (function (){var statearr_74038 = state_74032;
(statearr_74038[(4)] = cljs.core.rest((state_74032[(4)])));

return statearr_74038;
})();
var state_74032__$1 = state_74032;
var ex74036 = (state_74032__$1[(2)]);
var statearr_74039_74054 = state_74032__$1;
(statearr_74039_74054[(5)] = ex74036);


if((ex74036 instanceof Error)){
var statearr_74040_74055 = state_74032__$1;
(statearr_74040_74055[(1)] = (4));

(statearr_74040_74055[(5)] = null);

} else {
throw ex74036;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74033 === (6))){
var inst_74010 = (state_74032[(2)]);
var inst_74011 = fluree.db.util.async.throw_err(inst_74010);
var inst_74012 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_74011);
var inst_74013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74014 = [inst_74011];
var inst_74015 = (new cljs.core.PersistentVector(null,1,(5),inst_74013,inst_74014,null));
var inst_74016 = cljs.core.count(inst_74015);
var inst_74017 = ((9) + inst_74016);
var inst_74018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74019 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74021 = [inst_74011];
var inst_74022 = (new cljs.core.PersistentVector(null,1,(5),inst_74020,inst_74021,null));
var inst_74023 = ["not=",inst_74022,inst_74012];
var inst_74024 = cljs.core.PersistentHashMap.fromArrays(inst_74019,inst_74023);
var inst_74025 = [inst_74024,inst_74017];
var inst_74026 = (new cljs.core.PersistentVector(null,2,(5),inst_74018,inst_74025,null));
var inst_74027 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74026);
var _ = (function (){var statearr_74041 = state_74032;
(statearr_74041[(4)] = cljs.core.rest((state_74032[(4)])));

return statearr_74041;
})();
var state_74032__$1 = (function (){var statearr_74042 = state_74032;
(statearr_74042[(7)] = inst_74027);

return statearr_74042;
})();
var statearr_74043_74056 = state_74032__$1;
(statearr_74043_74056[(2)] = inst_74012);

(statearr_74043_74056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_74044 = [null,null,null,null,null,null,null,null];
(statearr_74044[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_74044[(1)] = (1));

return statearr_74044;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_74032){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74032);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74045){var ex__17181__auto__ = e74045;
var statearr_74046_74057 = state_74032;
(statearr_74046_74057[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74032[(4)]))){
var statearr_74047_74058 = state_74032;
(statearr_74047_74058[(1)] = cljs.core.first((state_74032[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74059 = state_74032;
state_74032 = G__74059;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_74032){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_74032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74048 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74048[(6)] = c__17304__auto__);

return statearr_74048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq74000){
var G__74001 = cljs.core.first(seq74000);
var seq74000__$1 = cljs.core.next(seq74000);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74001,seq74000__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___74109 = arguments.length;
var i__4819__auto___74110 = (0);
while(true){
if((i__4819__auto___74110 < len__4818__auto___74109)){
args__4824__auto__.push((arguments[i__4819__auto___74110]));

var G__74111 = (i__4819__auto___74110 + (1));
i__4819__auto___74110 = G__74111;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74092){
var state_val_74093 = (state_74092[(1)]);
if((state_val_74093 === (1))){
var state_74092__$1 = state_74092;
var statearr_74094_74112 = state_74092__$1;
(statearr_74094_74112[(2)] = null);

(statearr_74094_74112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74093 === (2))){
var _ = (function (){var statearr_74095 = state_74092;
(statearr_74095[(4)] = cljs.core.cons((5),(state_74092[(4)])));

return statearr_74095;
})();
var inst_74068 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74092__$1 = state_74092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74092__$1,(6),inst_74068);
} else {
if((state_val_74093 === (3))){
var inst_74090 = (state_74092[(2)]);
var state_74092__$1 = state_74092;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74092__$1,inst_74090);
} else {
if((state_val_74093 === (4))){
var inst_74062 = (state_74092[(2)]);
var state_74092__$1 = state_74092;
var statearr_74097_74113 = state_74092__$1;
(statearr_74097_74113[(2)] = inst_74062);

(statearr_74097_74113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74093 === (5))){
var _ = (function (){var statearr_74098 = state_74092;
(statearr_74098[(4)] = cljs.core.rest((state_74092[(4)])));

return statearr_74098;
})();
var state_74092__$1 = state_74092;
var ex74096 = (state_74092__$1[(2)]);
var statearr_74099_74114 = state_74092__$1;
(statearr_74099_74114[(5)] = ex74096);


if((ex74096 instanceof Error)){
var statearr_74100_74115 = state_74092__$1;
(statearr_74100_74115[(1)] = (4));

(statearr_74100_74115[(5)] = null);

} else {
throw ex74096;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74093 === (6))){
var inst_74070 = (state_74092[(2)]);
var inst_74071 = fluree.db.util.async.throw_err(inst_74070);
var inst_74072 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_74071);
var inst_74073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74074 = [inst_74071];
var inst_74075 = (new cljs.core.PersistentVector(null,1,(5),inst_74073,inst_74074,null));
var inst_74076 = cljs.core.count(inst_74075);
var inst_74077 = ((9) + inst_74076);
var inst_74078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74079 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74081 = [inst_74071];
var inst_74082 = (new cljs.core.PersistentVector(null,1,(5),inst_74080,inst_74081,null));
var inst_74083 = ["max",inst_74082,inst_74072];
var inst_74084 = cljs.core.PersistentHashMap.fromArrays(inst_74079,inst_74083);
var inst_74085 = [inst_74084,inst_74077];
var inst_74086 = (new cljs.core.PersistentVector(null,2,(5),inst_74078,inst_74085,null));
var inst_74087 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74086);
var _ = (function (){var statearr_74101 = state_74092;
(statearr_74101[(4)] = cljs.core.rest((state_74092[(4)])));

return statearr_74101;
})();
var state_74092__$1 = (function (){var statearr_74102 = state_74092;
(statearr_74102[(7)] = inst_74087);

return statearr_74102;
})();
var statearr_74103_74116 = state_74092__$1;
(statearr_74103_74116[(2)] = inst_74072);

(statearr_74103_74116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_74104 = [null,null,null,null,null,null,null,null];
(statearr_74104[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_74104[(1)] = (1));

return statearr_74104;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_74092){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74092);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74105){var ex__17181__auto__ = e74105;
var statearr_74106_74117 = state_74092;
(statearr_74106_74117[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74092[(4)]))){
var statearr_74107_74118 = state_74092;
(statearr_74107_74118[(1)] = cljs.core.first((state_74092[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74119 = state_74092;
state_74092 = G__74119;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_74092){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_74092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74108 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74108[(6)] = c__17304__auto__);

return statearr_74108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq74060){
var G__74061 = cljs.core.first(seq74060);
var seq74060__$1 = cljs.core.next(seq74060);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74061,seq74060__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___74169 = arguments.length;
var i__4819__auto___74170 = (0);
while(true){
if((i__4819__auto___74170 < len__4818__auto___74169)){
args__4824__auto__.push((arguments[i__4819__auto___74170]));

var G__74171 = (i__4819__auto___74170 + (1));
i__4819__auto___74170 = G__74171;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74152){
var state_val_74153 = (state_74152[(1)]);
if((state_val_74153 === (1))){
var state_74152__$1 = state_74152;
var statearr_74154_74172 = state_74152__$1;
(statearr_74154_74172[(2)] = null);

(statearr_74154_74172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74153 === (2))){
var _ = (function (){var statearr_74155 = state_74152;
(statearr_74155[(4)] = cljs.core.cons((5),(state_74152[(4)])));

return statearr_74155;
})();
var inst_74128 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74152__$1 = state_74152;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74152__$1,(6),inst_74128);
} else {
if((state_val_74153 === (3))){
var inst_74150 = (state_74152[(2)]);
var state_74152__$1 = state_74152;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74152__$1,inst_74150);
} else {
if((state_val_74153 === (4))){
var inst_74122 = (state_74152[(2)]);
var state_74152__$1 = state_74152;
var statearr_74157_74173 = state_74152__$1;
(statearr_74157_74173[(2)] = inst_74122);

(statearr_74157_74173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74153 === (5))){
var _ = (function (){var statearr_74158 = state_74152;
(statearr_74158[(4)] = cljs.core.rest((state_74152[(4)])));

return statearr_74158;
})();
var state_74152__$1 = state_74152;
var ex74156 = (state_74152__$1[(2)]);
var statearr_74159_74174 = state_74152__$1;
(statearr_74159_74174[(5)] = ex74156);


if((ex74156 instanceof Error)){
var statearr_74160_74175 = state_74152__$1;
(statearr_74160_74175[(1)] = (4));

(statearr_74160_74175[(5)] = null);

} else {
throw ex74156;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74153 === (6))){
var inst_74130 = (state_74152[(2)]);
var inst_74131 = fluree.db.util.async.throw_err(inst_74130);
var inst_74132 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_74131);
var inst_74133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74134 = [inst_74131];
var inst_74135 = (new cljs.core.PersistentVector(null,1,(5),inst_74133,inst_74134,null));
var inst_74136 = cljs.core.count(inst_74135);
var inst_74137 = ((9) + inst_74136);
var inst_74138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74139 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74140 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74141 = [inst_74131];
var inst_74142 = (new cljs.core.PersistentVector(null,1,(5),inst_74140,inst_74141,null));
var inst_74143 = ["min",inst_74142,inst_74132];
var inst_74144 = cljs.core.PersistentHashMap.fromArrays(inst_74139,inst_74143);
var inst_74145 = [inst_74144,inst_74137];
var inst_74146 = (new cljs.core.PersistentVector(null,2,(5),inst_74138,inst_74145,null));
var inst_74147 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74146);
var _ = (function (){var statearr_74161 = state_74152;
(statearr_74161[(4)] = cljs.core.rest((state_74152[(4)])));

return statearr_74161;
})();
var state_74152__$1 = (function (){var statearr_74162 = state_74152;
(statearr_74162[(7)] = inst_74147);

return statearr_74162;
})();
var statearr_74163_74176 = state_74152__$1;
(statearr_74163_74176[(2)] = inst_74132);

(statearr_74163_74176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_74164 = [null,null,null,null,null,null,null,null];
(statearr_74164[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_74164[(1)] = (1));

return statearr_74164;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_74152){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74152);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74165){var ex__17181__auto__ = e74165;
var statearr_74166_74177 = state_74152;
(statearr_74166_74177[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74152[(4)]))){
var statearr_74167_74178 = state_74152;
(statearr_74167_74178[(1)] = cljs.core.first((state_74152[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74179 = state_74152;
state_74152 = G__74179;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_74152){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_74152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74168 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74168[(6)] = c__17304__auto__);

return statearr_74168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq74120){
var G__74121 = cljs.core.first(seq74120);
var seq74120__$1 = cljs.core.next(seq74120);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74121,seq74120__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__74181 = arguments.length;
switch (G__74181) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74226){
var state_val_74227 = (state_74226[(1)]);
if((state_val_74227 === (7))){
var state_74226__$1 = state_74226;
var statearr_74228_74365 = state_74226__$1;
(statearr_74228_74365[(2)] = query_map);

(statearr_74228_74365[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74227 === (1))){
var state_74226__$1 = state_74226;
var statearr_74229_74366 = state_74226__$1;
(statearr_74229_74366[(2)] = null);

(statearr_74229_74366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74227 === (4))){
var inst_74182 = (state_74226[(2)]);
var state_74226__$1 = state_74226;
var statearr_74230_74367 = state_74226__$1;
(statearr_74230_74367[(2)] = inst_74182);

(statearr_74230_74367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74227 === (13))){
var inst_74204 = (state_74226[(7)]);
var inst_74208 = (state_74226[(2)]);
var inst_74209 = fluree.db.util.async.throw_err(inst_74208);
var inst_74210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74209,(0),null);
var inst_74211 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74209,(1),null);
var inst_74212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74213 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74215 = [inst_74204];
var inst_74216 = (new cljs.core.PersistentVector(null,1,(5),inst_74214,inst_74215,null));
var inst_74217 = ["query",inst_74216,inst_74210];
var inst_74218 = cljs.core.PersistentHashMap.fromArrays(inst_74213,inst_74217);
var inst_74219 = [inst_74218,inst_74211];
var inst_74220 = (new cljs.core.PersistentVector(null,2,(5),inst_74212,inst_74219,null));
var inst_74221 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74220);
var _ = (function (){var statearr_74231 = state_74226;
(statearr_74231[(4)] = cljs.core.rest((state_74226[(4)])));

return statearr_74231;
})();
var state_74226__$1 = (function (){var statearr_74232 = state_74226;
(statearr_74232[(8)] = inst_74221);

return statearr_74232;
})();
var statearr_74233_74368 = state_74226__$1;
(statearr_74233_74368[(2)] = inst_74210);

(statearr_74233_74368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74227 === (6))){
var state_74226__$1 = state_74226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74226__$1,(9),query_map);
} else {
if((state_val_74227 === (3))){
var inst_74224 = (state_74226[(2)]);
var state_74226__$1 = state_74226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74226__$1,inst_74224);
} else {
if((state_val_74227 === (12))){
var inst_74204 = (state_74226[(7)]);
var inst_74204__$1 = (state_74226[(2)]);
var inst_74205 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_74206 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_74205,inst_74204__$1);
var state_74226__$1 = (function (){var statearr_74234 = state_74226;
(statearr_74234[(7)] = inst_74204__$1);

return statearr_74234;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74226__$1,(13),inst_74206);
} else {
if((state_val_74227 === (2))){
var _ = (function (){var statearr_74235 = state_74226;
(statearr_74235[(4)] = cljs.core.cons((5),(state_74226[(4)])));

return statearr_74235;
})();
var inst_74191 = fluree.db.util.async.channel_QMARK_(query_map);
var state_74226__$1 = state_74226;
if(inst_74191){
var statearr_74236_74369 = state_74226__$1;
(statearr_74236_74369[(1)] = (6));

} else {
var statearr_74237_74370 = state_74226__$1;
(statearr_74237_74370[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74227 === (11))){
var inst_74198 = (state_74226[(9)]);
var state_74226__$1 = state_74226;
var statearr_74239_74371 = state_74226__$1;
(statearr_74239_74371[(2)] = inst_74198);

(statearr_74239_74371[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74227 === (9))){
var inst_74194 = (state_74226[(2)]);
var inst_74195 = fluree.db.util.async.throw_err(inst_74194);
var state_74226__$1 = state_74226;
var statearr_74240_74372 = state_74226__$1;
(statearr_74240_74372[(2)] = inst_74195);

(statearr_74240_74372[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74227 === (5))){
var _ = (function (){var statearr_74241 = state_74226;
(statearr_74241[(4)] = cljs.core.rest((state_74226[(4)])));

return statearr_74241;
})();
var state_74226__$1 = state_74226;
var ex74238 = (state_74226__$1[(2)]);
var statearr_74242_74373 = state_74226__$1;
(statearr_74242_74373[(5)] = ex74238);


if((ex74238 instanceof Error)){
var statearr_74243_74374 = state_74226__$1;
(statearr_74243_74374[(1)] = (4));

(statearr_74243_74374[(5)] = null);

} else {
throw ex74238;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74227 === (10))){
var inst_74198 = (state_74226[(9)]);
var inst_74201 = fluree.db.util.json.parse(inst_74198);
var state_74226__$1 = state_74226;
var statearr_74244_74375 = state_74226__$1;
(statearr_74244_74375[(2)] = inst_74201);

(statearr_74244_74375[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74227 === (8))){
var inst_74198 = (state_74226[(9)]);
var inst_74198__$1 = (state_74226[(2)]);
var inst_74199 = typeof inst_74198__$1 === 'string';
var state_74226__$1 = (function (){var statearr_74245 = state_74226;
(statearr_74245[(9)] = inst_74198__$1);

return statearr_74245;
})();
if(cljs.core.truth_(inst_74199)){
var statearr_74246_74376 = state_74226__$1;
(statearr_74246_74376[(1)] = (10));

} else {
var statearr_74247_74377 = state_74226__$1;
(statearr_74247_74377[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_74248 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74248[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_74248[(1)] = (1));

return statearr_74248;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_74226){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74226);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74249){var ex__17181__auto__ = e74249;
var statearr_74250_74378 = state_74226;
(statearr_74250_74378[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74226[(4)]))){
var statearr_74251_74379 = state_74226;
(statearr_74251_74379[(1)] = cljs.core.first((state_74226[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74380 = state_74226;
state_74226 = G__74380;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_74226){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_74226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74252 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74252[(6)] = c__17304__auto__);

return statearr_74252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74323){
var state_val_74324 = (state_74323[(1)]);
if((state_val_74324 === (7))){
var state_74323__$1 = state_74323;
var statearr_74325_74381 = state_74323__$1;
(statearr_74325_74381[(2)] = select);

(statearr_74325_74381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (20))){
var inst_74293 = (state_74323[(2)]);
var inst_74294 = fluree.db.util.async.channel_QMARK_(limit);
var state_74323__$1 = (function (){var statearr_74326 = state_74323;
(statearr_74326[(7)] = inst_74293);

return statearr_74326;
})();
if(inst_74294){
var statearr_74327_74382 = state_74323__$1;
(statearr_74327_74382[(1)] = (22));

} else {
var statearr_74328_74383 = state_74323__$1;
(statearr_74328_74383[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (1))){
var state_74323__$1 = state_74323;
var statearr_74329_74384 = state_74323__$1;
(statearr_74329_74384[(2)] = null);

(statearr_74329_74384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (24))){
var inst_74277 = (state_74323[(8)]);
var inst_74269 = (state_74323[(9)]);
var inst_74293 = (state_74323[(7)]);
var inst_74285 = (state_74323[(10)]);
var inst_74301 = (state_74323[(2)]);
var inst_74302 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_74303 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_74302,inst_74269,inst_74277,inst_74285,inst_74293,inst_74301);
var state_74323__$1 = state_74323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74323__$1,(26),inst_74303);
} else {
if((state_val_74324 === (4))){
var inst_74253 = (state_74323[(2)]);
var state_74323__$1 = state_74323;
var statearr_74330_74385 = state_74323__$1;
(statearr_74330_74385[(2)] = inst_74253);

(statearr_74330_74385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (15))){
var state_74323__$1 = state_74323;
var statearr_74331_74386 = state_74323__$1;
(statearr_74331_74386[(2)] = where);

(statearr_74331_74386[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (21))){
var inst_74289 = (state_74323[(2)]);
var inst_74290 = fluree.db.util.async.throw_err(inst_74289);
var state_74323__$1 = state_74323;
var statearr_74332_74387 = state_74323__$1;
(statearr_74332_74387[(2)] = inst_74290);

(statearr_74332_74387[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (13))){
var inst_74273 = (state_74323[(2)]);
var inst_74274 = fluree.db.util.async.throw_err(inst_74273);
var state_74323__$1 = state_74323;
var statearr_74333_74388 = state_74323__$1;
(statearr_74333_74388[(2)] = inst_74274);

(statearr_74333_74388[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (22))){
var state_74323__$1 = state_74323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74323__$1,(25),limit);
} else {
if((state_val_74324 === (6))){
var state_74323__$1 = state_74323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74323__$1,(9),select);
} else {
if((state_val_74324 === (25))){
var inst_74297 = (state_74323[(2)]);
var inst_74298 = fluree.db.util.async.throw_err(inst_74297);
var state_74323__$1 = state_74323;
var statearr_74334_74389 = state_74323__$1;
(statearr_74334_74389[(2)] = inst_74298);

(statearr_74334_74389[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (17))){
var inst_74281 = (state_74323[(2)]);
var inst_74282 = fluree.db.util.async.throw_err(inst_74281);
var state_74323__$1 = state_74323;
var statearr_74335_74390 = state_74323__$1;
(statearr_74335_74390[(2)] = inst_74282);

(statearr_74335_74390[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (3))){
var inst_74321 = (state_74323[(2)]);
var state_74323__$1 = state_74323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74323__$1,inst_74321);
} else {
if((state_val_74324 === (12))){
var inst_74277 = (state_74323[(2)]);
var inst_74278 = fluree.db.util.async.channel_QMARK_(where);
var state_74323__$1 = (function (){var statearr_74336 = state_74323;
(statearr_74336[(8)] = inst_74277);

return statearr_74336;
})();
if(inst_74278){
var statearr_74337_74391 = state_74323__$1;
(statearr_74337_74391[(1)] = (14));

} else {
var statearr_74338_74392 = state_74323__$1;
(statearr_74338_74392[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (2))){
var _ = (function (){var statearr_74339 = state_74323;
(statearr_74339[(4)] = cljs.core.cons((5),(state_74323[(4)])));

return statearr_74339;
})();
var inst_74262 = fluree.db.util.async.channel_QMARK_(select);
var state_74323__$1 = state_74323;
if(inst_74262){
var statearr_74340_74393 = state_74323__$1;
(statearr_74340_74393[(1)] = (6));

} else {
var statearr_74341_74394 = state_74323__$1;
(statearr_74341_74394[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (23))){
var state_74323__$1 = state_74323;
var statearr_74342_74395 = state_74323__$1;
(statearr_74342_74395[(2)] = limit);

(statearr_74342_74395[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (19))){
var state_74323__$1 = state_74323;
var statearr_74343_74396 = state_74323__$1;
(statearr_74343_74396[(2)] = block);

(statearr_74343_74396[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (11))){
var state_74323__$1 = state_74323;
var statearr_74345_74397 = state_74323__$1;
(statearr_74345_74397[(2)] = from);

(statearr_74345_74397[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (9))){
var inst_74265 = (state_74323[(2)]);
var inst_74266 = fluree.db.util.async.throw_err(inst_74265);
var state_74323__$1 = state_74323;
var statearr_74346_74398 = state_74323__$1;
(statearr_74346_74398[(2)] = inst_74266);

(statearr_74346_74398[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (5))){
var _ = (function (){var statearr_74347 = state_74323;
(statearr_74347[(4)] = cljs.core.rest((state_74323[(4)])));

return statearr_74347;
})();
var state_74323__$1 = state_74323;
var ex74344 = (state_74323__$1[(2)]);
var statearr_74348_74399 = state_74323__$1;
(statearr_74348_74399[(5)] = ex74344);


if((ex74344 instanceof Error)){
var statearr_74349_74400 = state_74323__$1;
(statearr_74349_74400[(1)] = (4));

(statearr_74349_74400[(5)] = null);

} else {
throw ex74344;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (14))){
var state_74323__$1 = state_74323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74323__$1,(17),where);
} else {
if((state_val_74324 === (26))){
var inst_74277 = (state_74323[(8)]);
var inst_74269 = (state_74323[(9)]);
var inst_74293 = (state_74323[(7)]);
var inst_74285 = (state_74323[(10)]);
var inst_74305 = (state_74323[(2)]);
var inst_74306 = fluree.db.util.async.throw_err(inst_74305);
var inst_74307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74306,(0),null);
var inst_74308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74306,(1),null);
var inst_74309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74310 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74312 = [inst_74269,inst_74277,inst_74285,inst_74293];
var inst_74313 = (new cljs.core.PersistentVector(null,4,(5),inst_74311,inst_74312,null));
var inst_74314 = ["query",inst_74313,inst_74307];
var inst_74315 = cljs.core.PersistentHashMap.fromArrays(inst_74310,inst_74314);
var inst_74316 = [inst_74315,inst_74308];
var inst_74317 = (new cljs.core.PersistentVector(null,2,(5),inst_74309,inst_74316,null));
var inst_74318 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74317);
var _ = (function (){var statearr_74350 = state_74323;
(statearr_74350[(4)] = cljs.core.rest((state_74323[(4)])));

return statearr_74350;
})();
var state_74323__$1 = (function (){var statearr_74351 = state_74323;
(statearr_74351[(11)] = inst_74318);

return statearr_74351;
})();
var statearr_74352_74401 = state_74323__$1;
(statearr_74352_74401[(2)] = inst_74307);

(statearr_74352_74401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (16))){
var inst_74285 = (state_74323[(2)]);
var inst_74286 = fluree.db.util.async.channel_QMARK_(block);
var state_74323__$1 = (function (){var statearr_74353 = state_74323;
(statearr_74353[(10)] = inst_74285);

return statearr_74353;
})();
if(inst_74286){
var statearr_74354_74402 = state_74323__$1;
(statearr_74354_74402[(1)] = (18));

} else {
var statearr_74355_74403 = state_74323__$1;
(statearr_74355_74403[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74324 === (10))){
var state_74323__$1 = state_74323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74323__$1,(13),from);
} else {
if((state_val_74324 === (18))){
var state_74323__$1 = state_74323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74323__$1,(21),block);
} else {
if((state_val_74324 === (8))){
var inst_74269 = (state_74323[(2)]);
var inst_74270 = fluree.db.util.async.channel_QMARK_(from);
var state_74323__$1 = (function (){var statearr_74356 = state_74323;
(statearr_74356[(9)] = inst_74269);

return statearr_74356;
})();
if(inst_74270){
var statearr_74357_74404 = state_74323__$1;
(statearr_74357_74404[(1)] = (10));

} else {
var statearr_74358_74405 = state_74323__$1;
(statearr_74358_74405[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_74359 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74359[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_74359[(1)] = (1));

return statearr_74359;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_74323){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74323);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74360){var ex__17181__auto__ = e74360;
var statearr_74361_74406 = state_74323;
(statearr_74361_74406[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74323[(4)]))){
var statearr_74362_74407 = state_74323;
(statearr_74362_74407[(1)] = cljs.core.first((state_74323[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74408 = state_74323;
state_74323 = G__74408;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_74323){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_74323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74363 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74363[(6)] = c__17304__auto__);

return statearr_74363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74464){
var state_val_74465 = (state_74464[(1)]);
if((state_val_74465 === (7))){
var state_74464__$1 = state_74464;
var statearr_74466_74497 = state_74464__$1;
(statearr_74466_74497[(2)] = startSubject);

(statearr_74466_74497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (1))){
var state_74464__$1 = state_74464;
var statearr_74467_74498 = state_74464__$1;
(statearr_74467_74498[(2)] = null);

(statearr_74467_74498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (4))){
var inst_74409 = (state_74464[(2)]);
var state_74464__$1 = state_74464;
var statearr_74468_74499 = state_74464__$1;
(statearr_74468_74499[(2)] = inst_74409);

(statearr_74468_74499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (15))){
var inst_74441 = (state_74464[(2)]);
var inst_74442 = fluree.db.util.async.throw_err(inst_74441);
var inst_74443 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74442,(0),null);
var inst_74444 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74442,(1),null);
var inst_74445 = cljs.core.empty_QMARK_(inst_74443);
var state_74464__$1 = (function (){var statearr_74469 = state_74464;
(statearr_74469[(7)] = inst_74444);

return statearr_74469;
})();
if(inst_74445){
var statearr_74470_74500 = state_74464__$1;
(statearr_74470_74500[(1)] = (16));

} else {
var statearr_74471_74501 = state_74464__$1;
(statearr_74471_74501[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (13))){
var inst_74429 = (state_74464[(8)]);
var inst_74425 = (state_74464[(9)]);
var inst_74437 = (state_74464[(10)]);
var inst_74437__$1 = (state_74464[(2)]);
var inst_74438 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_74439 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_74438,inst_74425,inst_74429,inst_74437__$1);
var state_74464__$1 = (function (){var statearr_74472 = state_74464;
(statearr_74472[(10)] = inst_74437__$1);

return statearr_74472;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74464__$1,(15),inst_74439);
} else {
if((state_val_74465 === (6))){
var state_74464__$1 = state_74464;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74464__$1,(9),startSubject);
} else {
if((state_val_74465 === (17))){
var state_74464__$1 = state_74464;
var statearr_74473_74502 = state_74464__$1;
(statearr_74473_74502[(2)] = true);

(statearr_74473_74502[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (3))){
var inst_74462 = (state_74464[(2)]);
var state_74464__$1 = state_74464;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74464__$1,inst_74462);
} else {
if((state_val_74465 === (12))){
var state_74464__$1 = state_74464;
var statearr_74474_74503 = state_74464__$1;
(statearr_74474_74503[(2)] = endSubject);

(statearr_74474_74503[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (2))){
var _ = (function (){var statearr_74475 = state_74464;
(statearr_74475[(4)] = cljs.core.cons((5),(state_74464[(4)])));

return statearr_74475;
})();
var inst_74418 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_74464__$1 = state_74464;
if(inst_74418){
var statearr_74476_74504 = state_74464__$1;
(statearr_74476_74504[(1)] = (6));

} else {
var statearr_74477_74505 = state_74464__$1;
(statearr_74477_74505[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (11))){
var state_74464__$1 = state_74464;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74464__$1,(14),endSubject);
} else {
if((state_val_74465 === (9))){
var inst_74421 = (state_74464[(2)]);
var inst_74422 = fluree.db.util.async.throw_err(inst_74421);
var state_74464__$1 = state_74464;
var statearr_74479_74506 = state_74464__$1;
(statearr_74479_74506[(2)] = inst_74422);

(statearr_74479_74506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (5))){
var _ = (function (){var statearr_74480 = state_74464;
(statearr_74480[(4)] = cljs.core.rest((state_74464[(4)])));

return statearr_74480;
})();
var state_74464__$1 = state_74464;
var ex74478 = (state_74464__$1[(2)]);
var statearr_74481_74507 = state_74464__$1;
(statearr_74481_74507[(5)] = ex74478);


if((ex74478 instanceof Error)){
var statearr_74482_74508 = state_74464__$1;
(statearr_74482_74508[(1)] = (4));

(statearr_74482_74508[(5)] = null);

} else {
throw ex74478;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (14))){
var inst_74433 = (state_74464[(2)]);
var inst_74434 = fluree.db.util.async.throw_err(inst_74433);
var state_74464__$1 = state_74464;
var statearr_74483_74509 = state_74464__$1;
(statearr_74483_74509[(2)] = inst_74434);

(statearr_74483_74509[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (16))){
var state_74464__$1 = state_74464;
var statearr_74484_74510 = state_74464__$1;
(statearr_74484_74510[(2)] = false);

(statearr_74484_74510[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (10))){
var inst_74428 = (state_74464[(2)]);
var inst_74429 = fluree.db.util.async.throw_err(inst_74428);
var inst_74430 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_74464__$1 = (function (){var statearr_74485 = state_74464;
(statearr_74485[(8)] = inst_74429);

return statearr_74485;
})();
if(inst_74430){
var statearr_74486_74511 = state_74464__$1;
(statearr_74486_74511[(1)] = (11));

} else {
var statearr_74487_74512 = state_74464__$1;
(statearr_74487_74512[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (18))){
var inst_74429 = (state_74464[(8)]);
var inst_74425 = (state_74464[(9)]);
var inst_74437 = (state_74464[(10)]);
var inst_74444 = (state_74464[(7)]);
var inst_74449 = (state_74464[(2)]);
var inst_74450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74451 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74453 = [inst_74425,inst_74429,inst_74437];
var inst_74454 = (new cljs.core.PersistentVector(null,3,(5),inst_74452,inst_74453,null));
var inst_74455 = ["relationship?",inst_74454,inst_74449];
var inst_74456 = cljs.core.PersistentHashMap.fromArrays(inst_74451,inst_74455);
var inst_74457 = [inst_74456,inst_74444];
var inst_74458 = (new cljs.core.PersistentVector(null,2,(5),inst_74450,inst_74457,null));
var inst_74459 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74458);
var _ = (function (){var statearr_74488 = state_74464;
(statearr_74488[(4)] = cljs.core.rest((state_74464[(4)])));

return statearr_74488;
})();
var state_74464__$1 = (function (){var statearr_74489 = state_74464;
(statearr_74489[(11)] = inst_74459);

return statearr_74489;
})();
var statearr_74490_74513 = state_74464__$1;
(statearr_74490_74513[(2)] = inst_74449);

(statearr_74490_74513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74465 === (8))){
var inst_74425 = (state_74464[(2)]);
var inst_74426 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_74464__$1 = (function (){var statearr_74491 = state_74464;
(statearr_74491[(9)] = inst_74425);

return statearr_74491;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74464__$1,(10),inst_74426);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__17178__auto____0 = (function (){
var statearr_74492 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74492[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__17178__auto__);

(statearr_74492[(1)] = (1));

return statearr_74492;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__17178__auto____1 = (function (state_74464){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74464);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74493){var ex__17181__auto__ = e74493;
var statearr_74494_74514 = state_74464;
(statearr_74494_74514[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74464[(4)]))){
var statearr_74495_74515 = state_74464;
(statearr_74495_74515[(1)] = cljs.core.first((state_74464[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74516 = state_74464;
state_74464 = G__74516;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__17178__auto__ = function(state_74464){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__17178__auto____1.call(this,state_74464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74496 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74496[(6)] = c__17304__auto__);

return statearr_74496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74553){
var state_val_74554 = (state_74553[(1)]);
if((state_val_74554 === (7))){
var state_74553__$1 = state_74553;
var statearr_74555_74575 = state_74553__$1;
(statearr_74555_74575[(2)] = pred_name);

(statearr_74555_74575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74554 === (1))){
var state_74553__$1 = state_74553;
var statearr_74556_74576 = state_74553__$1;
(statearr_74556_74576[(2)] = null);

(statearr_74556_74576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74554 === (4))){
var inst_74517 = (state_74553[(2)]);
var state_74553__$1 = state_74553;
var statearr_74557_74577 = state_74553__$1;
(statearr_74557_74577[(2)] = inst_74517);

(statearr_74557_74577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74554 === (6))){
var state_74553__$1 = state_74553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74553__$1,(9),pred_name);
} else {
if((state_val_74554 === (3))){
var inst_74551 = (state_74553[(2)]);
var state_74553__$1 = state_74553;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74553__$1,inst_74551);
} else {
if((state_val_74554 === (2))){
var _ = (function (){var statearr_74559 = state_74553;
(statearr_74559[(4)] = cljs.core.cons((5),(state_74553[(4)])));

return statearr_74559;
})();
var inst_74526 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_74553__$1 = state_74553;
if(inst_74526){
var statearr_74560_74578 = state_74553__$1;
(statearr_74560_74578[(1)] = (6));

} else {
var statearr_74561_74579 = state_74553__$1;
(statearr_74561_74579[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74554 === (9))){
var inst_74529 = (state_74553[(2)]);
var inst_74530 = fluree.db.util.async.throw_err(inst_74529);
var state_74553__$1 = state_74553;
var statearr_74562_74580 = state_74553__$1;
(statearr_74562_74580[(2)] = inst_74530);

(statearr_74562_74580[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74554 === (5))){
var _ = (function (){var statearr_74563 = state_74553;
(statearr_74563[(4)] = cljs.core.rest((state_74553[(4)])));

return statearr_74563;
})();
var state_74553__$1 = state_74553;
var ex74558 = (state_74553__$1[(2)]);
var statearr_74564_74581 = state_74553__$1;
(statearr_74564_74581[(5)] = ex74558);


if((ex74558 instanceof Error)){
var statearr_74565_74582 = state_74553__$1;
(statearr_74565_74582[(1)] = (4));

(statearr_74565_74582[(5)] = null);

} else {
throw ex74558;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74554 === (10))){
var inst_74533 = (state_74553[(7)]);
var inst_74537 = (state_74553[(2)]);
var inst_74538 = fluree.db.util.async.throw_err(inst_74537);
var inst_74539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74538,(0),null);
var inst_74540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74538,(1),null);
var inst_74541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74542 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74543 = ["max-pred-val",inst_74533,inst_74539];
var inst_74544 = cljs.core.PersistentHashMap.fromArrays(inst_74542,inst_74543);
var inst_74545 = (inst_74540 + (10));
var inst_74546 = [inst_74544,inst_74545];
var inst_74547 = (new cljs.core.PersistentVector(null,2,(5),inst_74541,inst_74546,null));
var inst_74548 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74547);
var _ = (function (){var statearr_74566 = state_74553;
(statearr_74566[(4)] = cljs.core.rest((state_74553[(4)])));

return statearr_74566;
})();
var state_74553__$1 = (function (){var statearr_74567 = state_74553;
(statearr_74567[(8)] = inst_74548);

return statearr_74567;
})();
var statearr_74568_74583 = state_74553__$1;
(statearr_74568_74583[(2)] = inst_74539);

(statearr_74568_74583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74554 === (8))){
var inst_74533 = (state_74553[(7)]);
var inst_74533__$1 = (state_74553[(2)]);
var inst_74534 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_74535 = fluree.db.dbfunctions.internal.max_pred_val(inst_74534,inst_74533__$1,null);
var state_74553__$1 = (function (){var statearr_74569 = state_74553;
(statearr_74569[(7)] = inst_74533__$1);

return statearr_74569;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74553__$1,(10),inst_74535);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__17178__auto____0 = (function (){
var statearr_74570 = [null,null,null,null,null,null,null,null,null];
(statearr_74570[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__17178__auto__);

(statearr_74570[(1)] = (1));

return statearr_74570;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__17178__auto____1 = (function (state_74553){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74553);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74571){var ex__17181__auto__ = e74571;
var statearr_74572_74584 = state_74553;
(statearr_74572_74584[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74553[(4)]))){
var statearr_74573_74585 = state_74553;
(statearr_74573_74585[(1)] = cljs.core.first((state_74553[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74586 = state_74553;
state_74553 = G__74586;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__17178__auto__ = function(state_74553){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__17178__auto____1.call(this,state_74553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74574 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74574[(6)] = c__17304__auto__);

return statearr_74574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74613){
var state_val_74614 = (state_74613[(1)]);
if((state_val_74614 === (7))){
var state_74613__$1 = state_74613;
var statearr_74615_74634 = state_74613__$1;
(statearr_74615_74634[(2)] = n);

(statearr_74615_74634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74614 === (1))){
var state_74613__$1 = state_74613;
var statearr_74616_74635 = state_74613__$1;
(statearr_74616_74635[(2)] = null);

(statearr_74616_74635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74614 === (4))){
var inst_74587 = (state_74613[(2)]);
var state_74613__$1 = state_74613;
var statearr_74617_74636 = state_74613__$1;
(statearr_74617_74636[(2)] = inst_74587);

(statearr_74617_74636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74614 === (6))){
var state_74613__$1 = state_74613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74613__$1,(9),n);
} else {
if((state_val_74614 === (3))){
var inst_74611 = (state_74613[(2)]);
var state_74613__$1 = state_74613;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74613__$1,inst_74611);
} else {
if((state_val_74614 === (2))){
var _ = (function (){var statearr_74619 = state_74613;
(statearr_74619[(4)] = cljs.core.cons((5),(state_74613[(4)])));

return statearr_74619;
})();
var inst_74593 = fluree.db.util.async.channel_QMARK_(n);
var state_74613__$1 = state_74613;
if(inst_74593){
var statearr_74620_74637 = state_74613__$1;
(statearr_74620_74637[(1)] = (6));

} else {
var statearr_74621_74638 = state_74613__$1;
(statearr_74621_74638[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74614 === (9))){
var inst_74596 = (state_74613[(2)]);
var inst_74597 = fluree.db.util.async.throw_err(inst_74596);
var state_74613__$1 = state_74613;
var statearr_74622_74639 = state_74613__$1;
(statearr_74622_74639[(2)] = inst_74597);

(statearr_74622_74639[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74614 === (5))){
var _ = (function (){var statearr_74623 = state_74613;
(statearr_74623[(4)] = cljs.core.rest((state_74613[(4)])));

return statearr_74623;
})();
var state_74613__$1 = state_74613;
var ex74618 = (state_74613__$1[(2)]);
var statearr_74624_74640 = state_74613__$1;
(statearr_74624_74640[(5)] = ex74618);


if((ex74618 instanceof Error)){
var statearr_74625_74641 = state_74613__$1;
(statearr_74625_74641[(1)] = (4));

(statearr_74625_74641[(5)] = null);

} else {
throw ex74618;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74614 === (8))){
var inst_74600 = (state_74613[(2)]);
var inst_74601 = fluree.db.dbfunctions.internal.inc(inst_74600);
var inst_74602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74603 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74604 = ["inc",inst_74600,inst_74601];
var inst_74605 = cljs.core.PersistentHashMap.fromArrays(inst_74603,inst_74604);
var inst_74606 = [inst_74605,(10)];
var inst_74607 = (new cljs.core.PersistentVector(null,2,(5),inst_74602,inst_74606,null));
var inst_74608 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74607);
var _ = (function (){var statearr_74626 = state_74613;
(statearr_74626[(4)] = cljs.core.rest((state_74613[(4)])));

return statearr_74626;
})();
var state_74613__$1 = (function (){var statearr_74627 = state_74613;
(statearr_74627[(7)] = inst_74608);

return statearr_74627;
})();
var statearr_74628_74642 = state_74613__$1;
(statearr_74628_74642[(2)] = inst_74601);

(statearr_74628_74642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__17178__auto____0 = (function (){
var statearr_74629 = [null,null,null,null,null,null,null,null];
(statearr_74629[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__17178__auto__);

(statearr_74629[(1)] = (1));

return statearr_74629;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__17178__auto____1 = (function (state_74613){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74613);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74630){var ex__17181__auto__ = e74630;
var statearr_74631_74643 = state_74613;
(statearr_74631_74643[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74613[(4)]))){
var statearr_74632_74644 = state_74613;
(statearr_74632_74644[(1)] = cljs.core.first((state_74613[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74645 = state_74613;
state_74613 = G__74645;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__17178__auto__ = function(state_74613){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__17178__auto____1.call(this,state_74613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74633 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74633[(6)] = c__17304__auto__);

return statearr_74633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74672){
var state_val_74673 = (state_74672[(1)]);
if((state_val_74673 === (7))){
var state_74672__$1 = state_74672;
var statearr_74674_74693 = state_74672__$1;
(statearr_74674_74693[(2)] = n);

(statearr_74674_74693[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74673 === (1))){
var state_74672__$1 = state_74672;
var statearr_74675_74694 = state_74672__$1;
(statearr_74675_74694[(2)] = null);

(statearr_74675_74694[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74673 === (4))){
var inst_74646 = (state_74672[(2)]);
var state_74672__$1 = state_74672;
var statearr_74676_74695 = state_74672__$1;
(statearr_74676_74695[(2)] = inst_74646);

(statearr_74676_74695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74673 === (6))){
var state_74672__$1 = state_74672;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74672__$1,(9),n);
} else {
if((state_val_74673 === (3))){
var inst_74670 = (state_74672[(2)]);
var state_74672__$1 = state_74672;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74672__$1,inst_74670);
} else {
if((state_val_74673 === (2))){
var _ = (function (){var statearr_74678 = state_74672;
(statearr_74678[(4)] = cljs.core.cons((5),(state_74672[(4)])));

return statearr_74678;
})();
var inst_74652 = fluree.db.util.async.channel_QMARK_(n);
var state_74672__$1 = state_74672;
if(inst_74652){
var statearr_74679_74696 = state_74672__$1;
(statearr_74679_74696[(1)] = (6));

} else {
var statearr_74680_74697 = state_74672__$1;
(statearr_74680_74697[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74673 === (9))){
var inst_74655 = (state_74672[(2)]);
var inst_74656 = fluree.db.util.async.throw_err(inst_74655);
var state_74672__$1 = state_74672;
var statearr_74681_74698 = state_74672__$1;
(statearr_74681_74698[(2)] = inst_74656);

(statearr_74681_74698[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74673 === (5))){
var _ = (function (){var statearr_74682 = state_74672;
(statearr_74682[(4)] = cljs.core.rest((state_74672[(4)])));

return statearr_74682;
})();
var state_74672__$1 = state_74672;
var ex74677 = (state_74672__$1[(2)]);
var statearr_74683_74699 = state_74672__$1;
(statearr_74683_74699[(5)] = ex74677);


if((ex74677 instanceof Error)){
var statearr_74684_74700 = state_74672__$1;
(statearr_74684_74700[(1)] = (4));

(statearr_74684_74700[(5)] = null);

} else {
throw ex74677;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74673 === (8))){
var inst_74659 = (state_74672[(2)]);
var inst_74660 = fluree.db.dbfunctions.internal.dec(inst_74659);
var inst_74661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74662 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74663 = ["dec",inst_74659,inst_74660];
var inst_74664 = cljs.core.PersistentHashMap.fromArrays(inst_74662,inst_74663);
var inst_74665 = [inst_74664,(10)];
var inst_74666 = (new cljs.core.PersistentVector(null,2,(5),inst_74661,inst_74665,null));
var inst_74667 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74666);
var _ = (function (){var statearr_74685 = state_74672;
(statearr_74685[(4)] = cljs.core.rest((state_74672[(4)])));

return statearr_74685;
})();
var state_74672__$1 = (function (){var statearr_74686 = state_74672;
(statearr_74686[(7)] = inst_74667);

return statearr_74686;
})();
var statearr_74687_74701 = state_74672__$1;
(statearr_74687_74701[(2)] = inst_74660);

(statearr_74687_74701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__17178__auto____0 = (function (){
var statearr_74688 = [null,null,null,null,null,null,null,null];
(statearr_74688[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__17178__auto__);

(statearr_74688[(1)] = (1));

return statearr_74688;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__17178__auto____1 = (function (state_74672){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74672);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74689){var ex__17181__auto__ = e74689;
var statearr_74690_74702 = state_74672;
(statearr_74690_74702[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74672[(4)]))){
var statearr_74691_74703 = state_74672;
(statearr_74691_74703[(1)] = cljs.core.first((state_74672[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74704 = state_74672;
state_74672 = G__74704;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__17178__auto__ = function(state_74672){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__17178__auto____1.call(this,state_74672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74692 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74692[(6)] = c__17304__auto__);

return statearr_74692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___74754 = arguments.length;
var i__4819__auto___74755 = (0);
while(true){
if((i__4819__auto___74755 < len__4818__auto___74754)){
args__4824__auto__.push((arguments[i__4819__auto___74755]));

var G__74756 = (i__4819__auto___74755 + (1));
i__4819__auto___74755 = G__74756;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74737){
var state_val_74738 = (state_74737[(1)]);
if((state_val_74738 === (1))){
var state_74737__$1 = state_74737;
var statearr_74739_74757 = state_74737__$1;
(statearr_74739_74757[(2)] = null);

(statearr_74739_74757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74738 === (2))){
var _ = (function (){var statearr_74740 = state_74737;
(statearr_74740[(4)] = cljs.core.cons((5),(state_74737[(4)])));

return statearr_74740;
})();
var inst_74713 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74737__$1 = state_74737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74737__$1,(6),inst_74713);
} else {
if((state_val_74738 === (3))){
var inst_74735 = (state_74737[(2)]);
var state_74737__$1 = state_74737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74737__$1,inst_74735);
} else {
if((state_val_74738 === (4))){
var inst_74707 = (state_74737[(2)]);
var state_74737__$1 = state_74737;
var statearr_74742_74758 = state_74737__$1;
(statearr_74742_74758[(2)] = inst_74707);

(statearr_74742_74758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74738 === (5))){
var _ = (function (){var statearr_74743 = state_74737;
(statearr_74743[(4)] = cljs.core.rest((state_74737[(4)])));

return statearr_74743;
})();
var state_74737__$1 = state_74737;
var ex74741 = (state_74737__$1[(2)]);
var statearr_74744_74759 = state_74737__$1;
(statearr_74744_74759[(5)] = ex74741);


if((ex74741 instanceof Error)){
var statearr_74745_74760 = state_74737__$1;
(statearr_74745_74760[(1)] = (4));

(statearr_74745_74760[(5)] = null);

} else {
throw ex74741;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74738 === (6))){
var inst_74715 = (state_74737[(2)]);
var inst_74716 = fluree.db.util.async.throw_err(inst_74715);
var inst_74717 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_74716);
var inst_74718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74719 = [inst_74716];
var inst_74720 = (new cljs.core.PersistentVector(null,1,(5),inst_74718,inst_74719,null));
var inst_74721 = cljs.core.count(inst_74720);
var inst_74722 = ((9) + inst_74721);
var inst_74723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74724 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74726 = [inst_74716];
var inst_74727 = (new cljs.core.PersistentVector(null,1,(5),inst_74725,inst_74726,null));
var inst_74728 = ["+",inst_74727,inst_74717];
var inst_74729 = cljs.core.PersistentHashMap.fromArrays(inst_74724,inst_74728);
var inst_74730 = [inst_74729,inst_74722];
var inst_74731 = (new cljs.core.PersistentVector(null,2,(5),inst_74723,inst_74730,null));
var inst_74732 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74731);
var _ = (function (){var statearr_74746 = state_74737;
(statearr_74746[(4)] = cljs.core.rest((state_74737[(4)])));

return statearr_74746;
})();
var state_74737__$1 = (function (){var statearr_74747 = state_74737;
(statearr_74747[(7)] = inst_74732);

return statearr_74747;
})();
var statearr_74748_74761 = state_74737__$1;
(statearr_74748_74761[(2)] = inst_74717);

(statearr_74748_74761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_74749 = [null,null,null,null,null,null,null,null];
(statearr_74749[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_74749[(1)] = (1));

return statearr_74749;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_74737){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74737);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74750){var ex__17181__auto__ = e74750;
var statearr_74751_74762 = state_74737;
(statearr_74751_74762[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74737[(4)]))){
var statearr_74752_74763 = state_74737;
(statearr_74752_74763[(1)] = cljs.core.first((state_74737[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74764 = state_74737;
state_74737 = G__74764;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_74737){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_74737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74753 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74753[(6)] = c__17304__auto__);

return statearr_74753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq74705){
var G__74706 = cljs.core.first(seq74705);
var seq74705__$1 = cljs.core.next(seq74705);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74706,seq74705__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___74814 = arguments.length;
var i__4819__auto___74815 = (0);
while(true){
if((i__4819__auto___74815 < len__4818__auto___74814)){
args__4824__auto__.push((arguments[i__4819__auto___74815]));

var G__74816 = (i__4819__auto___74815 + (1));
i__4819__auto___74815 = G__74816;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74797){
var state_val_74798 = (state_74797[(1)]);
if((state_val_74798 === (1))){
var state_74797__$1 = state_74797;
var statearr_74799_74817 = state_74797__$1;
(statearr_74799_74817[(2)] = null);

(statearr_74799_74817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74798 === (2))){
var _ = (function (){var statearr_74800 = state_74797;
(statearr_74800[(4)] = cljs.core.cons((5),(state_74797[(4)])));

return statearr_74800;
})();
var inst_74773 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74797__$1 = state_74797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74797__$1,(6),inst_74773);
} else {
if((state_val_74798 === (3))){
var inst_74795 = (state_74797[(2)]);
var state_74797__$1 = state_74797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74797__$1,inst_74795);
} else {
if((state_val_74798 === (4))){
var inst_74767 = (state_74797[(2)]);
var state_74797__$1 = state_74797;
var statearr_74802_74818 = state_74797__$1;
(statearr_74802_74818[(2)] = inst_74767);

(statearr_74802_74818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74798 === (5))){
var _ = (function (){var statearr_74803 = state_74797;
(statearr_74803[(4)] = cljs.core.rest((state_74797[(4)])));

return statearr_74803;
})();
var state_74797__$1 = state_74797;
var ex74801 = (state_74797__$1[(2)]);
var statearr_74804_74819 = state_74797__$1;
(statearr_74804_74819[(5)] = ex74801);


if((ex74801 instanceof Error)){
var statearr_74805_74820 = state_74797__$1;
(statearr_74805_74820[(1)] = (4));

(statearr_74805_74820[(5)] = null);

} else {
throw ex74801;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74798 === (6))){
var inst_74775 = (state_74797[(2)]);
var inst_74776 = fluree.db.util.async.throw_err(inst_74775);
var inst_74777 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_74776);
var inst_74778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74779 = [inst_74776];
var inst_74780 = (new cljs.core.PersistentVector(null,1,(5),inst_74778,inst_74779,null));
var inst_74781 = cljs.core.count(inst_74780);
var inst_74782 = ((9) + inst_74781);
var inst_74783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74784 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74786 = [inst_74776];
var inst_74787 = (new cljs.core.PersistentVector(null,1,(5),inst_74785,inst_74786,null));
var inst_74788 = ["-",inst_74787,inst_74777];
var inst_74789 = cljs.core.PersistentHashMap.fromArrays(inst_74784,inst_74788);
var inst_74790 = [inst_74789,inst_74782];
var inst_74791 = (new cljs.core.PersistentVector(null,2,(5),inst_74783,inst_74790,null));
var inst_74792 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74791);
var _ = (function (){var statearr_74806 = state_74797;
(statearr_74806[(4)] = cljs.core.rest((state_74797[(4)])));

return statearr_74806;
})();
var state_74797__$1 = (function (){var statearr_74807 = state_74797;
(statearr_74807[(7)] = inst_74792);

return statearr_74807;
})();
var statearr_74808_74821 = state_74797__$1;
(statearr_74808_74821[(2)] = inst_74777);

(statearr_74808_74821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_74809 = [null,null,null,null,null,null,null,null];
(statearr_74809[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_74809[(1)] = (1));

return statearr_74809;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_74797){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74797);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74810){var ex__17181__auto__ = e74810;
var statearr_74811_74822 = state_74797;
(statearr_74811_74822[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74797[(4)]))){
var statearr_74812_74823 = state_74797;
(statearr_74812_74823[(1)] = cljs.core.first((state_74797[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74824 = state_74797;
state_74797 = G__74824;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_74797){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_74797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74813 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74813[(6)] = c__17304__auto__);

return statearr_74813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq74765){
var G__74766 = cljs.core.first(seq74765);
var seq74765__$1 = cljs.core.next(seq74765);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74766,seq74765__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___74874 = arguments.length;
var i__4819__auto___74875 = (0);
while(true){
if((i__4819__auto___74875 < len__4818__auto___74874)){
args__4824__auto__.push((arguments[i__4819__auto___74875]));

var G__74876 = (i__4819__auto___74875 + (1));
i__4819__auto___74875 = G__74876;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74857){
var state_val_74858 = (state_74857[(1)]);
if((state_val_74858 === (1))){
var state_74857__$1 = state_74857;
var statearr_74859_74877 = state_74857__$1;
(statearr_74859_74877[(2)] = null);

(statearr_74859_74877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74858 === (2))){
var _ = (function (){var statearr_74860 = state_74857;
(statearr_74860[(4)] = cljs.core.cons((5),(state_74857[(4)])));

return statearr_74860;
})();
var inst_74833 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74857__$1 = state_74857;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74857__$1,(6),inst_74833);
} else {
if((state_val_74858 === (3))){
var inst_74855 = (state_74857[(2)]);
var state_74857__$1 = state_74857;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74857__$1,inst_74855);
} else {
if((state_val_74858 === (4))){
var inst_74827 = (state_74857[(2)]);
var state_74857__$1 = state_74857;
var statearr_74862_74878 = state_74857__$1;
(statearr_74862_74878[(2)] = inst_74827);

(statearr_74862_74878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74858 === (5))){
var _ = (function (){var statearr_74863 = state_74857;
(statearr_74863[(4)] = cljs.core.rest((state_74857[(4)])));

return statearr_74863;
})();
var state_74857__$1 = state_74857;
var ex74861 = (state_74857__$1[(2)]);
var statearr_74864_74879 = state_74857__$1;
(statearr_74864_74879[(5)] = ex74861);


if((ex74861 instanceof Error)){
var statearr_74865_74880 = state_74857__$1;
(statearr_74865_74880[(1)] = (4));

(statearr_74865_74880[(5)] = null);

} else {
throw ex74861;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74858 === (6))){
var inst_74835 = (state_74857[(2)]);
var inst_74836 = fluree.db.util.async.throw_err(inst_74835);
var inst_74837 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_74836);
var inst_74838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74839 = [inst_74836];
var inst_74840 = (new cljs.core.PersistentVector(null,1,(5),inst_74838,inst_74839,null));
var inst_74841 = cljs.core.count(inst_74840);
var inst_74842 = ((9) + inst_74841);
var inst_74843 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74844 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74846 = [inst_74836];
var inst_74847 = (new cljs.core.PersistentVector(null,1,(5),inst_74845,inst_74846,null));
var inst_74848 = ["*",inst_74847,inst_74837];
var inst_74849 = cljs.core.PersistentHashMap.fromArrays(inst_74844,inst_74848);
var inst_74850 = [inst_74849,inst_74842];
var inst_74851 = (new cljs.core.PersistentVector(null,2,(5),inst_74843,inst_74850,null));
var inst_74852 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74851);
var _ = (function (){var statearr_74866 = state_74857;
(statearr_74866[(4)] = cljs.core.rest((state_74857[(4)])));

return statearr_74866;
})();
var state_74857__$1 = (function (){var statearr_74867 = state_74857;
(statearr_74867[(7)] = inst_74852);

return statearr_74867;
})();
var statearr_74868_74881 = state_74857__$1;
(statearr_74868_74881[(2)] = inst_74837);

(statearr_74868_74881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_74869 = [null,null,null,null,null,null,null,null];
(statearr_74869[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_74869[(1)] = (1));

return statearr_74869;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_74857){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74857);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74870){var ex__17181__auto__ = e74870;
var statearr_74871_74882 = state_74857;
(statearr_74871_74882[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74857[(4)]))){
var statearr_74872_74883 = state_74857;
(statearr_74872_74883[(1)] = cljs.core.first((state_74857[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74884 = state_74857;
state_74857 = G__74884;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_74857){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_74857);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74873 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74873[(6)] = c__17304__auto__);

return statearr_74873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq74825){
var G__74826 = cljs.core.first(seq74825);
var seq74825__$1 = cljs.core.next(seq74825);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74826,seq74825__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___74934 = arguments.length;
var i__4819__auto___74935 = (0);
while(true){
if((i__4819__auto___74935 < len__4818__auto___74934)){
args__4824__auto__.push((arguments[i__4819__auto___74935]));

var G__74936 = (i__4819__auto___74935 + (1));
i__4819__auto___74935 = G__74936;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74917){
var state_val_74918 = (state_74917[(1)]);
if((state_val_74918 === (1))){
var state_74917__$1 = state_74917;
var statearr_74919_74937 = state_74917__$1;
(statearr_74919_74937[(2)] = null);

(statearr_74919_74937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74918 === (2))){
var _ = (function (){var statearr_74920 = state_74917;
(statearr_74920[(4)] = cljs.core.cons((5),(state_74917[(4)])));

return statearr_74920;
})();
var inst_74893 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74917__$1 = state_74917;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74917__$1,(6),inst_74893);
} else {
if((state_val_74918 === (3))){
var inst_74915 = (state_74917[(2)]);
var state_74917__$1 = state_74917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74917__$1,inst_74915);
} else {
if((state_val_74918 === (4))){
var inst_74887 = (state_74917[(2)]);
var state_74917__$1 = state_74917;
var statearr_74922_74938 = state_74917__$1;
(statearr_74922_74938[(2)] = inst_74887);

(statearr_74922_74938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74918 === (5))){
var _ = (function (){var statearr_74923 = state_74917;
(statearr_74923[(4)] = cljs.core.rest((state_74917[(4)])));

return statearr_74923;
})();
var state_74917__$1 = state_74917;
var ex74921 = (state_74917__$1[(2)]);
var statearr_74924_74939 = state_74917__$1;
(statearr_74924_74939[(5)] = ex74921);


if((ex74921 instanceof Error)){
var statearr_74925_74940 = state_74917__$1;
(statearr_74925_74940[(1)] = (4));

(statearr_74925_74940[(5)] = null);

} else {
throw ex74921;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74918 === (6))){
var inst_74895 = (state_74917[(2)]);
var inst_74896 = fluree.db.util.async.throw_err(inst_74895);
var inst_74897 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_74896);
var inst_74898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74899 = [inst_74896];
var inst_74900 = (new cljs.core.PersistentVector(null,1,(5),inst_74898,inst_74899,null));
var inst_74901 = cljs.core.count(inst_74900);
var inst_74902 = ((9) + inst_74901);
var inst_74903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74904 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74906 = [inst_74896];
var inst_74907 = (new cljs.core.PersistentVector(null,1,(5),inst_74905,inst_74906,null));
var inst_74908 = ["/",inst_74907,inst_74897];
var inst_74909 = cljs.core.PersistentHashMap.fromArrays(inst_74904,inst_74908);
var inst_74910 = [inst_74909,inst_74902];
var inst_74911 = (new cljs.core.PersistentVector(null,2,(5),inst_74903,inst_74910,null));
var inst_74912 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74911);
var _ = (function (){var statearr_74926 = state_74917;
(statearr_74926[(4)] = cljs.core.rest((state_74917[(4)])));

return statearr_74926;
})();
var state_74917__$1 = (function (){var statearr_74927 = state_74917;
(statearr_74927[(7)] = inst_74912);

return statearr_74927;
})();
var statearr_74928_74941 = state_74917__$1;
(statearr_74928_74941[(2)] = inst_74897);

(statearr_74928_74941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_74929 = [null,null,null,null,null,null,null,null];
(statearr_74929[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_74929[(1)] = (1));

return statearr_74929;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_74917){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74917);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e74930){var ex__17181__auto__ = e74930;
var statearr_74931_74942 = state_74917;
(statearr_74931_74942[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74917[(4)]))){
var statearr_74932_74943 = state_74917;
(statearr_74932_74943[(1)] = cljs.core.first((state_74917[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74944 = state_74917;
state_74917 = G__74944;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_74917){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_74917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_74933 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_74933[(6)] = c__17304__auto__);

return statearr_74933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq74885){
var G__74886 = cljs.core.first(seq74885);
var seq74885__$1 = cljs.core.next(seq74885);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74886,seq74885__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_74982){
var state_val_74983 = (state_74982[(1)]);
if((state_val_74983 === (7))){
var state_74982__$1 = state_74982;
var statearr_74984_75008 = state_74982__$1;
(statearr_74984_75008[(2)] = n);

(statearr_74984_75008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74983 === (1))){
var state_74982__$1 = state_74982;
var statearr_74985_75009 = state_74982__$1;
(statearr_74985_75009[(2)] = null);

(statearr_74985_75009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74983 === (4))){
var inst_74945 = (state_74982[(2)]);
var state_74982__$1 = state_74982;
var statearr_74986_75010 = state_74982__$1;
(statearr_74986_75010[(2)] = inst_74945);

(statearr_74986_75010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74983 === (13))){
var inst_74962 = (state_74982[(2)]);
var inst_74963 = fluree.db.util.async.throw_err(inst_74962);
var state_74982__$1 = state_74982;
var statearr_74987_75011 = state_74982__$1;
(statearr_74987_75011[(2)] = inst_74963);

(statearr_74987_75011[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74983 === (6))){
var state_74982__$1 = state_74982;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74982__$1,(9),n);
} else {
if((state_val_74983 === (3))){
var inst_74980 = (state_74982[(2)]);
var state_74982__$1 = state_74982;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74982__$1,inst_74980);
} else {
if((state_val_74983 === (12))){
var inst_74958 = (state_74982[(7)]);
var inst_74966 = (state_74982[(2)]);
var inst_74967 = fluree.db.dbfunctions.internal.quot(inst_74958,inst_74966);
var inst_74968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74969 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74971 = [inst_74958,inst_74966];
var inst_74972 = (new cljs.core.PersistentVector(null,2,(5),inst_74970,inst_74971,null));
var inst_74973 = ["quot",inst_74972,inst_74967];
var inst_74974 = cljs.core.PersistentHashMap.fromArrays(inst_74969,inst_74973);
var inst_74975 = [inst_74974,(2)];
var inst_74976 = (new cljs.core.PersistentVector(null,2,(5),inst_74968,inst_74975,null));
var inst_74977 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74976);
var _ = (function (){var statearr_74988 = state_74982;
(statearr_74988[(4)] = cljs.core.rest((state_74982[(4)])));

return statearr_74988;
})();
var state_74982__$1 = (function (){var statearr_74989 = state_74982;
(statearr_74989[(8)] = inst_74977);

return statearr_74989;
})();
var statearr_74990_75012 = state_74982__$1;
(statearr_74990_75012[(2)] = inst_74967);

(statearr_74990_75012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74983 === (2))){
var _ = (function (){var statearr_74991 = state_74982;
(statearr_74991[(4)] = cljs.core.cons((5),(state_74982[(4)])));

return statearr_74991;
})();
var inst_74951 = fluree.db.util.async.channel_QMARK_(n);
var state_74982__$1 = state_74982;
if(inst_74951){
var statearr_74992_75013 = state_74982__$1;
(statearr_74992_75013[(1)] = (6));

} else {
var statearr_74993_75014 = state_74982__$1;
(statearr_74993_75014[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74983 === (11))){
var state_74982__$1 = state_74982;
var statearr_74995_75015 = state_74982__$1;
(statearr_74995_75015[(2)] = d);

(statearr_74995_75015[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74983 === (9))){
var inst_74954 = (state_74982[(2)]);
var inst_74955 = fluree.db.util.async.throw_err(inst_74954);
var state_74982__$1 = state_74982;
var statearr_74996_75016 = state_74982__$1;
(statearr_74996_75016[(2)] = inst_74955);

(statearr_74996_75016[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74983 === (5))){
var _ = (function (){var statearr_74997 = state_74982;
(statearr_74997[(4)] = cljs.core.rest((state_74982[(4)])));

return statearr_74997;
})();
var state_74982__$1 = state_74982;
var ex74994 = (state_74982__$1[(2)]);
var statearr_74998_75017 = state_74982__$1;
(statearr_74998_75017[(5)] = ex74994);


if((ex74994 instanceof Error)){
var statearr_74999_75018 = state_74982__$1;
(statearr_74999_75018[(1)] = (4));

(statearr_74999_75018[(5)] = null);

} else {
throw ex74994;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74983 === (10))){
var state_74982__$1 = state_74982;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74982__$1,(13),d);
} else {
if((state_val_74983 === (8))){
var inst_74958 = (state_74982[(2)]);
var inst_74959 = fluree.db.util.async.channel_QMARK_(d);
var state_74982__$1 = (function (){var statearr_75000 = state_74982;
(statearr_75000[(7)] = inst_74958);

return statearr_75000;
})();
if(inst_74959){
var statearr_75001_75019 = state_74982__$1;
(statearr_75001_75019[(1)] = (10));

} else {
var statearr_75002_75020 = state_74982__$1;
(statearr_75002_75020[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__17178__auto____0 = (function (){
var statearr_75003 = [null,null,null,null,null,null,null,null,null];
(statearr_75003[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__17178__auto__);

(statearr_75003[(1)] = (1));

return statearr_75003;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__17178__auto____1 = (function (state_74982){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_74982);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75004){var ex__17181__auto__ = e75004;
var statearr_75005_75021 = state_74982;
(statearr_75005_75021[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_74982[(4)]))){
var statearr_75006_75022 = state_74982;
(statearr_75006_75022[(1)] = cljs.core.first((state_74982[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75023 = state_74982;
state_74982 = G__75023;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__17178__auto__ = function(state_74982){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__17178__auto____1.call(this,state_74982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75007 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75007[(6)] = c__17304__auto__);

return statearr_75007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_75061){
var state_val_75062 = (state_75061[(1)]);
if((state_val_75062 === (7))){
var state_75061__$1 = state_75061;
var statearr_75063_75087 = state_75061__$1;
(statearr_75063_75087[(2)] = n);

(statearr_75063_75087[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75062 === (1))){
var state_75061__$1 = state_75061;
var statearr_75064_75088 = state_75061__$1;
(statearr_75064_75088[(2)] = null);

(statearr_75064_75088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75062 === (4))){
var inst_75024 = (state_75061[(2)]);
var state_75061__$1 = state_75061;
var statearr_75065_75089 = state_75061__$1;
(statearr_75065_75089[(2)] = inst_75024);

(statearr_75065_75089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75062 === (13))){
var inst_75041 = (state_75061[(2)]);
var inst_75042 = fluree.db.util.async.throw_err(inst_75041);
var state_75061__$1 = state_75061;
var statearr_75066_75090 = state_75061__$1;
(statearr_75066_75090[(2)] = inst_75042);

(statearr_75066_75090[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75062 === (6))){
var state_75061__$1 = state_75061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75061__$1,(9),n);
} else {
if((state_val_75062 === (3))){
var inst_75059 = (state_75061[(2)]);
var state_75061__$1 = state_75061;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75061__$1,inst_75059);
} else {
if((state_val_75062 === (12))){
var inst_75037 = (state_75061[(7)]);
var inst_75045 = (state_75061[(2)]);
var inst_75046 = fluree.db.dbfunctions.internal.mod(inst_75037,inst_75045);
var inst_75047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75048 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75050 = [inst_75037,inst_75045];
var inst_75051 = (new cljs.core.PersistentVector(null,2,(5),inst_75049,inst_75050,null));
var inst_75052 = ["mod",inst_75051,inst_75046];
var inst_75053 = cljs.core.PersistentHashMap.fromArrays(inst_75048,inst_75052);
var inst_75054 = [inst_75053,(2)];
var inst_75055 = (new cljs.core.PersistentVector(null,2,(5),inst_75047,inst_75054,null));
var inst_75056 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75055);
var _ = (function (){var statearr_75067 = state_75061;
(statearr_75067[(4)] = cljs.core.rest((state_75061[(4)])));

return statearr_75067;
})();
var state_75061__$1 = (function (){var statearr_75068 = state_75061;
(statearr_75068[(8)] = inst_75056);

return statearr_75068;
})();
var statearr_75069_75091 = state_75061__$1;
(statearr_75069_75091[(2)] = inst_75046);

(statearr_75069_75091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75062 === (2))){
var _ = (function (){var statearr_75070 = state_75061;
(statearr_75070[(4)] = cljs.core.cons((5),(state_75061[(4)])));

return statearr_75070;
})();
var inst_75030 = fluree.db.util.async.channel_QMARK_(n);
var state_75061__$1 = state_75061;
if(inst_75030){
var statearr_75071_75092 = state_75061__$1;
(statearr_75071_75092[(1)] = (6));

} else {
var statearr_75072_75093 = state_75061__$1;
(statearr_75072_75093[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75062 === (11))){
var state_75061__$1 = state_75061;
var statearr_75074_75094 = state_75061__$1;
(statearr_75074_75094[(2)] = d);

(statearr_75074_75094[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75062 === (9))){
var inst_75033 = (state_75061[(2)]);
var inst_75034 = fluree.db.util.async.throw_err(inst_75033);
var state_75061__$1 = state_75061;
var statearr_75075_75095 = state_75061__$1;
(statearr_75075_75095[(2)] = inst_75034);

(statearr_75075_75095[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75062 === (5))){
var _ = (function (){var statearr_75076 = state_75061;
(statearr_75076[(4)] = cljs.core.rest((state_75061[(4)])));

return statearr_75076;
})();
var state_75061__$1 = state_75061;
var ex75073 = (state_75061__$1[(2)]);
var statearr_75077_75096 = state_75061__$1;
(statearr_75077_75096[(5)] = ex75073);


if((ex75073 instanceof Error)){
var statearr_75078_75097 = state_75061__$1;
(statearr_75078_75097[(1)] = (4));

(statearr_75078_75097[(5)] = null);

} else {
throw ex75073;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75062 === (10))){
var state_75061__$1 = state_75061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75061__$1,(13),d);
} else {
if((state_val_75062 === (8))){
var inst_75037 = (state_75061[(2)]);
var inst_75038 = fluree.db.util.async.channel_QMARK_(d);
var state_75061__$1 = (function (){var statearr_75079 = state_75061;
(statearr_75079[(7)] = inst_75037);

return statearr_75079;
})();
if(inst_75038){
var statearr_75080_75098 = state_75061__$1;
(statearr_75080_75098[(1)] = (10));

} else {
var statearr_75081_75099 = state_75061__$1;
(statearr_75081_75099[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__17178__auto____0 = (function (){
var statearr_75082 = [null,null,null,null,null,null,null,null,null];
(statearr_75082[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__17178__auto__);

(statearr_75082[(1)] = (1));

return statearr_75082;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__17178__auto____1 = (function (state_75061){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_75061);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75083){var ex__17181__auto__ = e75083;
var statearr_75084_75100 = state_75061;
(statearr_75084_75100[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_75061[(4)]))){
var statearr_75085_75101 = state_75061;
(statearr_75085_75101[(1)] = cljs.core.first((state_75061[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75102 = state_75061;
state_75061 = G__75102;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__17178__auto__ = function(state_75061){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__17178__auto____1.call(this,state_75061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75086 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75086[(6)] = c__17304__auto__);

return statearr_75086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_75140){
var state_val_75141 = (state_75140[(1)]);
if((state_val_75141 === (7))){
var state_75140__$1 = state_75140;
var statearr_75142_75166 = state_75140__$1;
(statearr_75142_75166[(2)] = n);

(statearr_75142_75166[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75141 === (1))){
var state_75140__$1 = state_75140;
var statearr_75143_75167 = state_75140__$1;
(statearr_75143_75167[(2)] = null);

(statearr_75143_75167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75141 === (4))){
var inst_75103 = (state_75140[(2)]);
var state_75140__$1 = state_75140;
var statearr_75144_75168 = state_75140__$1;
(statearr_75144_75168[(2)] = inst_75103);

(statearr_75144_75168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75141 === (13))){
var inst_75120 = (state_75140[(2)]);
var inst_75121 = fluree.db.util.async.throw_err(inst_75120);
var state_75140__$1 = state_75140;
var statearr_75145_75169 = state_75140__$1;
(statearr_75145_75169[(2)] = inst_75121);

(statearr_75145_75169[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75141 === (6))){
var state_75140__$1 = state_75140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75140__$1,(9),n);
} else {
if((state_val_75141 === (3))){
var inst_75138 = (state_75140[(2)]);
var state_75140__$1 = state_75140;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75140__$1,inst_75138);
} else {
if((state_val_75141 === (12))){
var inst_75116 = (state_75140[(7)]);
var inst_75124 = (state_75140[(2)]);
var inst_75125 = fluree.db.dbfunctions.internal.rem(inst_75116,inst_75124);
var inst_75126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75127 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75129 = [inst_75116,inst_75124];
var inst_75130 = (new cljs.core.PersistentVector(null,2,(5),inst_75128,inst_75129,null));
var inst_75131 = ["rem",inst_75130,inst_75125];
var inst_75132 = cljs.core.PersistentHashMap.fromArrays(inst_75127,inst_75131);
var inst_75133 = [inst_75132,(2)];
var inst_75134 = (new cljs.core.PersistentVector(null,2,(5),inst_75126,inst_75133,null));
var inst_75135 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75134);
var _ = (function (){var statearr_75146 = state_75140;
(statearr_75146[(4)] = cljs.core.rest((state_75140[(4)])));

return statearr_75146;
})();
var state_75140__$1 = (function (){var statearr_75147 = state_75140;
(statearr_75147[(8)] = inst_75135);

return statearr_75147;
})();
var statearr_75148_75170 = state_75140__$1;
(statearr_75148_75170[(2)] = inst_75125);

(statearr_75148_75170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75141 === (2))){
var _ = (function (){var statearr_75149 = state_75140;
(statearr_75149[(4)] = cljs.core.cons((5),(state_75140[(4)])));

return statearr_75149;
})();
var inst_75109 = fluree.db.util.async.channel_QMARK_(n);
var state_75140__$1 = state_75140;
if(inst_75109){
var statearr_75150_75171 = state_75140__$1;
(statearr_75150_75171[(1)] = (6));

} else {
var statearr_75151_75172 = state_75140__$1;
(statearr_75151_75172[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75141 === (11))){
var state_75140__$1 = state_75140;
var statearr_75153_75173 = state_75140__$1;
(statearr_75153_75173[(2)] = d);

(statearr_75153_75173[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75141 === (9))){
var inst_75112 = (state_75140[(2)]);
var inst_75113 = fluree.db.util.async.throw_err(inst_75112);
var state_75140__$1 = state_75140;
var statearr_75154_75174 = state_75140__$1;
(statearr_75154_75174[(2)] = inst_75113);

(statearr_75154_75174[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75141 === (5))){
var _ = (function (){var statearr_75155 = state_75140;
(statearr_75155[(4)] = cljs.core.rest((state_75140[(4)])));

return statearr_75155;
})();
var state_75140__$1 = state_75140;
var ex75152 = (state_75140__$1[(2)]);
var statearr_75156_75175 = state_75140__$1;
(statearr_75156_75175[(5)] = ex75152);


if((ex75152 instanceof Error)){
var statearr_75157_75176 = state_75140__$1;
(statearr_75157_75176[(1)] = (4));

(statearr_75157_75176[(5)] = null);

} else {
throw ex75152;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75141 === (10))){
var state_75140__$1 = state_75140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75140__$1,(13),d);
} else {
if((state_val_75141 === (8))){
var inst_75116 = (state_75140[(2)]);
var inst_75117 = fluree.db.util.async.channel_QMARK_(d);
var state_75140__$1 = (function (){var statearr_75158 = state_75140;
(statearr_75158[(7)] = inst_75116);

return statearr_75158;
})();
if(inst_75117){
var statearr_75159_75177 = state_75140__$1;
(statearr_75159_75177[(1)] = (10));

} else {
var statearr_75160_75178 = state_75140__$1;
(statearr_75160_75178[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__17178__auto____0 = (function (){
var statearr_75161 = [null,null,null,null,null,null,null,null,null];
(statearr_75161[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__17178__auto__);

(statearr_75161[(1)] = (1));

return statearr_75161;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__17178__auto____1 = (function (state_75140){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_75140);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75162){var ex__17181__auto__ = e75162;
var statearr_75163_75179 = state_75140;
(statearr_75163_75179[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_75140[(4)]))){
var statearr_75164_75180 = state_75140;
(statearr_75164_75180[(1)] = cljs.core.first((state_75140[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75181 = state_75140;
state_75140 = G__75181;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__17178__auto__ = function(state_75140){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__17178__auto____1.call(this,state_75140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75165 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75165[(6)] = c__17304__auto__);

return statearr_75165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_75208){
var state_val_75209 = (state_75208[(1)]);
if((state_val_75209 === (7))){
var state_75208__$1 = state_75208;
var statearr_75210_75229 = state_75208__$1;
(statearr_75210_75229[(2)] = x);

(statearr_75210_75229[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75209 === (1))){
var state_75208__$1 = state_75208;
var statearr_75211_75230 = state_75208__$1;
(statearr_75211_75230[(2)] = null);

(statearr_75211_75230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75209 === (4))){
var inst_75182 = (state_75208[(2)]);
var state_75208__$1 = state_75208;
var statearr_75212_75231 = state_75208__$1;
(statearr_75212_75231[(2)] = inst_75182);

(statearr_75212_75231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75209 === (6))){
var state_75208__$1 = state_75208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75208__$1,(9),x);
} else {
if((state_val_75209 === (3))){
var inst_75206 = (state_75208[(2)]);
var state_75208__$1 = state_75208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75208__$1,inst_75206);
} else {
if((state_val_75209 === (2))){
var _ = (function (){var statearr_75214 = state_75208;
(statearr_75214[(4)] = cljs.core.cons((5),(state_75208[(4)])));

return statearr_75214;
})();
var inst_75188 = fluree.db.util.async.channel_QMARK_(x);
var state_75208__$1 = state_75208;
if(inst_75188){
var statearr_75215_75232 = state_75208__$1;
(statearr_75215_75232[(1)] = (6));

} else {
var statearr_75216_75233 = state_75208__$1;
(statearr_75216_75233[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75209 === (9))){
var inst_75191 = (state_75208[(2)]);
var inst_75192 = fluree.db.util.async.throw_err(inst_75191);
var state_75208__$1 = state_75208;
var statearr_75217_75234 = state_75208__$1;
(statearr_75217_75234[(2)] = inst_75192);

(statearr_75217_75234[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75209 === (5))){
var _ = (function (){var statearr_75218 = state_75208;
(statearr_75218[(4)] = cljs.core.rest((state_75208[(4)])));

return statearr_75218;
})();
var state_75208__$1 = state_75208;
var ex75213 = (state_75208__$1[(2)]);
var statearr_75219_75235 = state_75208__$1;
(statearr_75219_75235[(5)] = ex75213);


if((ex75213 instanceof Error)){
var statearr_75220_75236 = state_75208__$1;
(statearr_75220_75236[(1)] = (4));

(statearr_75220_75236[(5)] = null);

} else {
throw ex75213;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75209 === (8))){
var inst_75195 = (state_75208[(2)]);
var inst_75196 = fluree.db.dbfunctions.internal.boolean$(inst_75195);
var inst_75197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75198 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75199 = ["boolean",inst_75195,inst_75196];
var inst_75200 = cljs.core.PersistentHashMap.fromArrays(inst_75198,inst_75199);
var inst_75201 = [inst_75200,(10)];
var inst_75202 = (new cljs.core.PersistentVector(null,2,(5),inst_75197,inst_75201,null));
var inst_75203 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75202);
var _ = (function (){var statearr_75221 = state_75208;
(statearr_75221[(4)] = cljs.core.rest((state_75208[(4)])));

return statearr_75221;
})();
var state_75208__$1 = (function (){var statearr_75222 = state_75208;
(statearr_75222[(7)] = inst_75203);

return statearr_75222;
})();
var statearr_75223_75237 = state_75208__$1;
(statearr_75223_75237[(2)] = inst_75196);

(statearr_75223_75237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__17178__auto____0 = (function (){
var statearr_75224 = [null,null,null,null,null,null,null,null];
(statearr_75224[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__17178__auto__);

(statearr_75224[(1)] = (1));

return statearr_75224;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__17178__auto____1 = (function (state_75208){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_75208);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75225){var ex__17181__auto__ = e75225;
var statearr_75226_75238 = state_75208;
(statearr_75226_75238[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_75208[(4)]))){
var statearr_75227_75239 = state_75208;
(statearr_75227_75239[(1)] = cljs.core.first((state_75208[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75240 = state_75208;
state_75208 = G__75240;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__17178__auto__ = function(state_75208){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__17178__auto____1.call(this,state_75208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75228 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75228[(6)] = c__17304__auto__);

return statearr_75228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_75278){
var state_val_75279 = (state_75278[(1)]);
if((state_val_75279 === (7))){
var state_75278__$1 = state_75278;
var statearr_75280_75304 = state_75278__$1;
(statearr_75280_75304[(2)] = pattern);

(statearr_75280_75304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75279 === (1))){
var state_75278__$1 = state_75278;
var statearr_75281_75305 = state_75278__$1;
(statearr_75281_75305[(2)] = null);

(statearr_75281_75305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75279 === (4))){
var inst_75241 = (state_75278[(2)]);
var state_75278__$1 = state_75278;
var statearr_75282_75306 = state_75278__$1;
(statearr_75282_75306[(2)] = inst_75241);

(statearr_75282_75306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75279 === (13))){
var inst_75258 = (state_75278[(2)]);
var inst_75259 = fluree.db.util.async.throw_err(inst_75258);
var state_75278__$1 = state_75278;
var statearr_75283_75307 = state_75278__$1;
(statearr_75283_75307[(2)] = inst_75259);

(statearr_75283_75307[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75279 === (6))){
var state_75278__$1 = state_75278;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75278__$1,(9),pattern);
} else {
if((state_val_75279 === (3))){
var inst_75276 = (state_75278[(2)]);
var state_75278__$1 = state_75278;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75278__$1,inst_75276);
} else {
if((state_val_75279 === (12))){
var inst_75254 = (state_75278[(7)]);
var inst_75262 = (state_75278[(2)]);
var inst_75263 = fluree.db.dbfunctions.internal.re_find(inst_75254,inst_75262);
var inst_75264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75265 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75267 = [inst_75254,inst_75262];
var inst_75268 = (new cljs.core.PersistentVector(null,2,(5),inst_75266,inst_75267,null));
var inst_75269 = ["re-find",inst_75268,inst_75263];
var inst_75270 = cljs.core.PersistentHashMap.fromArrays(inst_75265,inst_75269);
var inst_75271 = [inst_75270,(10)];
var inst_75272 = (new cljs.core.PersistentVector(null,2,(5),inst_75264,inst_75271,null));
var inst_75273 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75272);
var _ = (function (){var statearr_75284 = state_75278;
(statearr_75284[(4)] = cljs.core.rest((state_75278[(4)])));

return statearr_75284;
})();
var state_75278__$1 = (function (){var statearr_75285 = state_75278;
(statearr_75285[(8)] = inst_75273);

return statearr_75285;
})();
var statearr_75286_75308 = state_75278__$1;
(statearr_75286_75308[(2)] = inst_75263);

(statearr_75286_75308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75279 === (2))){
var _ = (function (){var statearr_75287 = state_75278;
(statearr_75287[(4)] = cljs.core.cons((5),(state_75278[(4)])));

return statearr_75287;
})();
var inst_75247 = fluree.db.util.async.channel_QMARK_(pattern);
var state_75278__$1 = state_75278;
if(inst_75247){
var statearr_75288_75309 = state_75278__$1;
(statearr_75288_75309[(1)] = (6));

} else {
var statearr_75289_75310 = state_75278__$1;
(statearr_75289_75310[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75279 === (11))){
var state_75278__$1 = state_75278;
var statearr_75291_75311 = state_75278__$1;
(statearr_75291_75311[(2)] = string);

(statearr_75291_75311[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75279 === (9))){
var inst_75250 = (state_75278[(2)]);
var inst_75251 = fluree.db.util.async.throw_err(inst_75250);
var state_75278__$1 = state_75278;
var statearr_75292_75312 = state_75278__$1;
(statearr_75292_75312[(2)] = inst_75251);

(statearr_75292_75312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75279 === (5))){
var _ = (function (){var statearr_75293 = state_75278;
(statearr_75293[(4)] = cljs.core.rest((state_75278[(4)])));

return statearr_75293;
})();
var state_75278__$1 = state_75278;
var ex75290 = (state_75278__$1[(2)]);
var statearr_75294_75313 = state_75278__$1;
(statearr_75294_75313[(5)] = ex75290);


if((ex75290 instanceof Error)){
var statearr_75295_75314 = state_75278__$1;
(statearr_75295_75314[(1)] = (4));

(statearr_75295_75314[(5)] = null);

} else {
throw ex75290;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75279 === (10))){
var state_75278__$1 = state_75278;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75278__$1,(13),string);
} else {
if((state_val_75279 === (8))){
var inst_75254 = (state_75278[(2)]);
var inst_75255 = fluree.db.util.async.channel_QMARK_(string);
var state_75278__$1 = (function (){var statearr_75296 = state_75278;
(statearr_75296[(7)] = inst_75254);

return statearr_75296;
})();
if(inst_75255){
var statearr_75297_75315 = state_75278__$1;
(statearr_75297_75315[(1)] = (10));

} else {
var statearr_75298_75316 = state_75278__$1;
(statearr_75298_75316[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__17178__auto____0 = (function (){
var statearr_75299 = [null,null,null,null,null,null,null,null,null];
(statearr_75299[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__17178__auto__);

(statearr_75299[(1)] = (1));

return statearr_75299;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__17178__auto____1 = (function (state_75278){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_75278);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75300){var ex__17181__auto__ = e75300;
var statearr_75301_75317 = state_75278;
(statearr_75301_75317[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_75278[(4)]))){
var statearr_75302_75318 = state_75278;
(statearr_75302_75318[(1)] = cljs.core.first((state_75278[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75319 = state_75278;
state_75278 = G__75319;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__17178__auto__ = function(state_75278){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__17178__auto____1.call(this,state_75278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75303 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75303[(6)] = c__17304__auto__);

return statearr_75303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_75346){
var state_val_75347 = (state_75346[(1)]);
if((state_val_75347 === (7))){
var state_75346__$1 = state_75346;
var statearr_75348_75367 = state_75346__$1;
(statearr_75348_75367[(2)] = email);

(statearr_75348_75367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75347 === (1))){
var state_75346__$1 = state_75346;
var statearr_75349_75368 = state_75346__$1;
(statearr_75349_75368[(2)] = null);

(statearr_75349_75368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75347 === (4))){
var inst_75320 = (state_75346[(2)]);
var state_75346__$1 = state_75346;
var statearr_75350_75369 = state_75346__$1;
(statearr_75350_75369[(2)] = inst_75320);

(statearr_75350_75369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75347 === (6))){
var state_75346__$1 = state_75346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75346__$1,(9),email);
} else {
if((state_val_75347 === (3))){
var inst_75344 = (state_75346[(2)]);
var state_75346__$1 = state_75346;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75346__$1,inst_75344);
} else {
if((state_val_75347 === (2))){
var _ = (function (){var statearr_75352 = state_75346;
(statearr_75352[(4)] = cljs.core.cons((5),(state_75346[(4)])));

return statearr_75352;
})();
var inst_75326 = fluree.db.util.async.channel_QMARK_(email);
var state_75346__$1 = state_75346;
if(inst_75326){
var statearr_75353_75370 = state_75346__$1;
(statearr_75353_75370[(1)] = (6));

} else {
var statearr_75354_75371 = state_75346__$1;
(statearr_75354_75371[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75347 === (9))){
var inst_75329 = (state_75346[(2)]);
var inst_75330 = fluree.db.util.async.throw_err(inst_75329);
var state_75346__$1 = state_75346;
var statearr_75355_75372 = state_75346__$1;
(statearr_75355_75372[(2)] = inst_75330);

(statearr_75355_75372[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75347 === (5))){
var _ = (function (){var statearr_75356 = state_75346;
(statearr_75356[(4)] = cljs.core.rest((state_75346[(4)])));

return statearr_75356;
})();
var state_75346__$1 = state_75346;
var ex75351 = (state_75346__$1[(2)]);
var statearr_75357_75373 = state_75346__$1;
(statearr_75357_75373[(5)] = ex75351);


if((ex75351 instanceof Error)){
var statearr_75358_75374 = state_75346__$1;
(statearr_75358_75374[(1)] = (4));

(statearr_75358_75374[(5)] = null);

} else {
throw ex75351;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75347 === (8))){
var inst_75333 = (state_75346[(2)]);
var inst_75334 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_75333);
var inst_75335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75336 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75337 = ["re-find",inst_75333,inst_75334];
var inst_75338 = cljs.core.PersistentHashMap.fromArrays(inst_75336,inst_75337);
var inst_75339 = [inst_75338,(10)];
var inst_75340 = (new cljs.core.PersistentVector(null,2,(5),inst_75335,inst_75339,null));
var inst_75341 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75340);
var _ = (function (){var statearr_75359 = state_75346;
(statearr_75359[(4)] = cljs.core.rest((state_75346[(4)])));

return statearr_75359;
})();
var state_75346__$1 = (function (){var statearr_75360 = state_75346;
(statearr_75360[(7)] = inst_75341);

return statearr_75360;
})();
var statearr_75361_75375 = state_75346__$1;
(statearr_75361_75375[(2)] = inst_75334);

(statearr_75361_75375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__17178__auto____0 = (function (){
var statearr_75362 = [null,null,null,null,null,null,null,null];
(statearr_75362[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__17178__auto__);

(statearr_75362[(1)] = (1));

return statearr_75362;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__17178__auto____1 = (function (state_75346){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_75346);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75363){var ex__17181__auto__ = e75363;
var statearr_75364_75376 = state_75346;
(statearr_75364_75376[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_75346[(4)]))){
var statearr_75365_75377 = state_75346;
(statearr_75365_75377[(1)] = cljs.core.first((state_75346[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75378 = state_75346;
state_75346 = G__75378;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__17178__auto__ = function(state_75346){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__17178__auto____1.call(this,state_75346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75366 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75366[(6)] = c__17304__auto__);

return statearr_75366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_75425){
var state_val_75426 = (state_75425[(1)]);
if((state_val_75426 === (7))){
var inst_75395 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_75425__$1 = state_75425;
if(cljs.core.truth_(inst_75395)){
var statearr_75427_75454 = state_75425__$1;
(statearr_75427_75454[(1)] = (9));

} else {
var statearr_75428_75455 = state_75425__$1;
(statearr_75428_75455[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75426 === (1))){
var state_75425__$1 = state_75425;
var statearr_75429_75456 = state_75425__$1;
(statearr_75429_75456[(2)] = null);

(statearr_75429_75456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75426 === (4))){
var inst_75379 = (state_75425[(2)]);
var state_75425__$1 = state_75425;
var statearr_75430_75457 = state_75425__$1;
(statearr_75430_75457[(2)] = inst_75379);

(statearr_75430_75457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75426 === (15))){
var inst_75406 = (state_75425[(2)]);
var state_75425__$1 = state_75425;
var statearr_75431_75458 = state_75425__$1;
(statearr_75431_75458[(2)] = inst_75406);

(statearr_75431_75458[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75426 === (13))){
var inst_75403 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_75425__$1 = state_75425;
var statearr_75432_75459 = state_75425__$1;
(statearr_75432_75459[(2)] = inst_75403);

(statearr_75432_75459[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75426 === (6))){
var inst_75390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75391 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_75392 = [inst_75391,(0)];
var inst_75393 = (new cljs.core.PersistentVector(null,2,(5),inst_75390,inst_75392,null));
var state_75425__$1 = state_75425;
var statearr_75433_75460 = state_75425__$1;
(statearr_75433_75460[(2)] = inst_75393);

(statearr_75433_75460[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75426 === (3))){
var inst_75423 = (state_75425[(2)]);
var state_75425__$1 = state_75425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75425__$1,inst_75423);
} else {
if((state_val_75426 === (12))){
var inst_75399 = (state_75425[(2)]);
var inst_75400 = fluree.db.util.async.throw_err(inst_75399);
var state_75425__$1 = state_75425;
var statearr_75434_75461 = state_75425__$1;
(statearr_75434_75461[(2)] = inst_75400);

(statearr_75434_75461[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75426 === (2))){
var _ = (function (){var statearr_75435 = state_75425;
(statearr_75435[(4)] = cljs.core.cons((5),(state_75425[(4)])));

return statearr_75435;
})();
var inst_75388 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_75425__$1 = state_75425;
if(cljs.core.truth_(inst_75388)){
var statearr_75436_75462 = state_75425__$1;
(statearr_75436_75462[(1)] = (6));

} else {
var statearr_75437_75463 = state_75425__$1;
(statearr_75437_75463[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75426 === (11))){
var inst_75408 = (state_75425[(2)]);
var state_75425__$1 = state_75425;
var statearr_75439_75464 = state_75425__$1;
(statearr_75439_75464[(2)] = inst_75408);

(statearr_75439_75464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75426 === (9))){
var inst_75397 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_75425__$1 = state_75425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75425__$1,(12),inst_75397);
} else {
if((state_val_75426 === (5))){
var _ = (function (){var statearr_75440 = state_75425;
(statearr_75440[(4)] = cljs.core.rest((state_75425[(4)])));

return statearr_75440;
})();
var state_75425__$1 = state_75425;
var ex75438 = (state_75425__$1[(2)]);
var statearr_75441_75465 = state_75425__$1;
(statearr_75441_75465[(5)] = ex75438);


if((ex75438 instanceof Error)){
var statearr_75442_75466 = state_75425__$1;
(statearr_75442_75466[(1)] = (4));

(statearr_75442_75466[(5)] = null);

} else {
throw ex75438;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75426 === (14))){
var state_75425__$1 = state_75425;
var statearr_75443_75467 = state_75425__$1;
(statearr_75443_75467[(2)] = null);

(statearr_75443_75467[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75426 === (10))){
var state_75425__$1 = state_75425;
var statearr_75444_75468 = state_75425__$1;
(statearr_75444_75468[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75426 === (8))){
var inst_75410 = (state_75425[(2)]);
var inst_75411 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75410,(0),null);
var inst_75412 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75410,(1),null);
var inst_75413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75414 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75415 = ["?user_id","?ctx",inst_75411];
var inst_75416 = cljs.core.PersistentHashMap.fromArrays(inst_75414,inst_75415);
var inst_75417 = ((10) + inst_75412);
var inst_75418 = [inst_75416,inst_75417];
var inst_75419 = (new cljs.core.PersistentVector(null,2,(5),inst_75413,inst_75418,null));
var inst_75420 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75419);
var _ = (function (){var statearr_75446 = state_75425;
(statearr_75446[(4)] = cljs.core.rest((state_75425[(4)])));

return statearr_75446;
})();
var state_75425__$1 = (function (){var statearr_75447 = state_75425;
(statearr_75447[(7)] = inst_75420);

return statearr_75447;
})();
var statearr_75448_75469 = state_75425__$1;
(statearr_75448_75469[(2)] = inst_75411);

(statearr_75448_75469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__17178__auto____0 = (function (){
var statearr_75449 = [null,null,null,null,null,null,null,null];
(statearr_75449[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__17178__auto__);

(statearr_75449[(1)] = (1));

return statearr_75449;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__17178__auto____1 = (function (state_75425){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_75425);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75450){var ex__17181__auto__ = e75450;
var statearr_75451_75470 = state_75425;
(statearr_75451_75470[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_75425[(4)]))){
var statearr_75452_75471 = state_75425;
(statearr_75452_75471[(1)] = cljs.core.first((state_75425[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75472 = state_75425;
state_75425 = G__75472;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__17178__auto__ = function(state_75425){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__17178__auto____1.call(this,state_75425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75453 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75453[(6)] = c__17304__auto__);

return statearr_75453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_75500){
var state_val_75501 = (state_75500[(1)]);
if((state_val_75501 === (7))){
var inst_75493 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_75500__$1 = state_75500;
var statearr_75502_75521 = state_75500__$1;
(statearr_75502_75521[(2)] = inst_75493);

(statearr_75502_75521[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75501 === (1))){
var state_75500__$1 = state_75500;
var statearr_75503_75522 = state_75500__$1;
(statearr_75503_75522[(2)] = null);

(statearr_75503_75522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75501 === (4))){
var inst_75473 = (state_75500[(2)]);
var state_75500__$1 = state_75500;
var statearr_75504_75523 = state_75500__$1;
(statearr_75504_75523[(2)] = inst_75473);

(statearr_75504_75523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75501 === (6))){
var inst_75481 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_75500__$1 = state_75500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75500__$1,(9),inst_75481);
} else {
if((state_val_75501 === (3))){
var inst_75498 = (state_75500[(2)]);
var state_75500__$1 = state_75500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75500__$1,inst_75498);
} else {
if((state_val_75501 === (2))){
var _ = (function (){var statearr_75506 = state_75500;
(statearr_75506[(4)] = cljs.core.cons((5),(state_75500[(4)])));

return statearr_75506;
})();
var inst_75479 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_75500__$1 = state_75500;
if(cljs.core.truth_(inst_75479)){
var statearr_75507_75524 = state_75500__$1;
(statearr_75507_75524[(1)] = (6));

} else {
var statearr_75508_75525 = state_75500__$1;
(statearr_75508_75525[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75501 === (9))){
var inst_75483 = (state_75500[(2)]);
var inst_75484 = fluree.db.util.async.throw_err(inst_75483);
var inst_75485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75486 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75487 = ["?auth_id","?ctx",inst_75484];
var inst_75488 = cljs.core.PersistentHashMap.fromArrays(inst_75486,inst_75487);
var inst_75489 = [inst_75488,(10)];
var inst_75490 = (new cljs.core.PersistentVector(null,2,(5),inst_75485,inst_75489,null));
var inst_75491 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75490);
var state_75500__$1 = (function (){var statearr_75509 = state_75500;
(statearr_75509[(7)] = inst_75491);

return statearr_75509;
})();
var statearr_75510_75526 = state_75500__$1;
(statearr_75510_75526[(2)] = inst_75484);

(statearr_75510_75526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75501 === (5))){
var _ = (function (){var statearr_75511 = state_75500;
(statearr_75511[(4)] = cljs.core.rest((state_75500[(4)])));

return statearr_75511;
})();
var state_75500__$1 = state_75500;
var ex75505 = (state_75500__$1[(2)]);
var statearr_75512_75527 = state_75500__$1;
(statearr_75512_75527[(5)] = ex75505);


if((ex75505 instanceof Error)){
var statearr_75513_75528 = state_75500__$1;
(statearr_75513_75528[(1)] = (4));

(statearr_75513_75528[(5)] = null);

} else {
throw ex75505;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75501 === (8))){
var inst_75495 = (state_75500[(2)]);
var _ = (function (){var statearr_75514 = state_75500;
(statearr_75514[(4)] = cljs.core.rest((state_75500[(4)])));

return statearr_75514;
})();
var state_75500__$1 = state_75500;
var statearr_75515_75529 = state_75500__$1;
(statearr_75515_75529[(2)] = inst_75495);

(statearr_75515_75529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__17178__auto____0 = (function (){
var statearr_75516 = [null,null,null,null,null,null,null,null];
(statearr_75516[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__17178__auto__);

(statearr_75516[(1)] = (1));

return statearr_75516;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__17178__auto____1 = (function (state_75500){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_75500);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75517){var ex__17181__auto__ = e75517;
var statearr_75518_75530 = state_75500;
(statearr_75518_75530[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_75500[(4)]))){
var statearr_75519_75531 = state_75500;
(statearr_75519_75531[(1)] = cljs.core.first((state_75500[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75532 = state_75500;
state_75500 = G__75532;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__17178__auto__ = function(state_75500){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__17178__auto____1.call(this,state_75500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75520 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75520[(6)] = c__17304__auto__);

return statearr_75520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__75534 = arguments.length;
switch (G__75534) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_75576){
var state_val_75577 = (state_75576[(1)]);
if((state_val_75577 === (7))){
var state_75576__$1 = state_75576;
var statearr_75578_75608 = state_75576__$1;
(statearr_75578_75608[(2)] = seed);

(statearr_75578_75608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75577 === (1))){
var state_75576__$1 = state_75576;
var statearr_75579_75609 = state_75576__$1;
(statearr_75579_75609[(2)] = null);

(statearr_75579_75609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75577 === (4))){
var inst_75535 = (state_75576[(2)]);
var state_75576__$1 = state_75576;
var statearr_75580_75610 = state_75576__$1;
(statearr_75580_75610[(2)] = inst_75535);

(statearr_75580_75610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75577 === (15))){
var state_75576__$1 = state_75576;
var statearr_75581_75611 = state_75576__$1;
(statearr_75581_75611[(2)] = (10));

(statearr_75581_75611[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75577 === (13))){
var inst_75552 = (state_75576[(2)]);
var inst_75553 = fluree.db.util.async.throw_err(inst_75552);
var state_75576__$1 = state_75576;
var statearr_75582_75612 = state_75576__$1;
(statearr_75582_75612[(2)] = inst_75553);

(statearr_75582_75612[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75577 === (6))){
var state_75576__$1 = state_75576;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75576__$1,(9),seed);
} else {
if((state_val_75577 === (3))){
var inst_75574 = (state_75576[(2)]);
var state_75576__$1 = state_75576;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75576__$1,inst_75574);
} else {
if((state_val_75577 === (12))){
var inst_75556 = (state_75576[(7)]);
var inst_75556__$1 = (state_75576[(2)]);
var state_75576__$1 = (function (){var statearr_75583 = state_75576;
(statearr_75583[(7)] = inst_75556__$1);

return statearr_75583;
})();
if(cljs.core.truth_(inst_75556__$1)){
var statearr_75584_75613 = state_75576__$1;
(statearr_75584_75613[(1)] = (14));

} else {
var statearr_75585_75614 = state_75576__$1;
(statearr_75585_75614[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75577 === (2))){
var _ = (function (){var statearr_75586 = state_75576;
(statearr_75586[(4)] = cljs.core.cons((5),(state_75576[(4)])));

return statearr_75586;
})();
var inst_75541 = fluree.db.util.async.channel_QMARK_(seed);
var state_75576__$1 = state_75576;
if(inst_75541){
var statearr_75587_75615 = state_75576__$1;
(statearr_75587_75615[(1)] = (6));

} else {
var statearr_75588_75616 = state_75576__$1;
(statearr_75588_75616[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75577 === (11))){
var state_75576__$1 = state_75576;
var statearr_75590_75617 = state_75576__$1;
(statearr_75590_75617[(2)] = max);

(statearr_75590_75617[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75577 === (9))){
var inst_75544 = (state_75576[(2)]);
var inst_75545 = fluree.db.util.async.throw_err(inst_75544);
var state_75576__$1 = state_75576;
var statearr_75591_75618 = state_75576__$1;
(statearr_75591_75618[(2)] = inst_75545);

(statearr_75591_75618[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75577 === (5))){
var _ = (function (){var statearr_75592 = state_75576;
(statearr_75592[(4)] = cljs.core.rest((state_75576[(4)])));

return statearr_75592;
})();
var state_75576__$1 = state_75576;
var ex75589 = (state_75576__$1[(2)]);
var statearr_75593_75619 = state_75576__$1;
(statearr_75593_75619[(5)] = ex75589);


if((ex75589 instanceof Error)){
var statearr_75594_75620 = state_75576__$1;
(statearr_75594_75620[(1)] = (4));

(statearr_75594_75620[(5)] = null);

} else {
throw ex75589;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75577 === (14))){
var inst_75556 = (state_75576[(7)]);
var state_75576__$1 = state_75576;
var statearr_75595_75621 = state_75576__$1;
(statearr_75595_75621[(2)] = inst_75556);

(statearr_75595_75621[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75577 === (16))){
var inst_75548 = (state_75576[(8)]);
var inst_75560 = (state_75576[(2)]);
var inst_75561 = fluree.db.dbfunctions.internal.rand(inst_75548,inst_75560);
var inst_75562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75563 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75565 = [max,seed];
var inst_75566 = (new cljs.core.PersistentVector(null,2,(5),inst_75564,inst_75565,null));
var inst_75567 = ["rand",inst_75566,inst_75561];
var inst_75568 = cljs.core.PersistentHashMap.fromArrays(inst_75563,inst_75567);
var inst_75569 = [inst_75568,(10)];
var inst_75570 = (new cljs.core.PersistentVector(null,2,(5),inst_75562,inst_75569,null));
var inst_75571 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75570);
var _ = (function (){var statearr_75596 = state_75576;
(statearr_75596[(4)] = cljs.core.rest((state_75576[(4)])));

return statearr_75596;
})();
var state_75576__$1 = (function (){var statearr_75597 = state_75576;
(statearr_75597[(9)] = inst_75571);

return statearr_75597;
})();
var statearr_75598_75622 = state_75576__$1;
(statearr_75598_75622[(2)] = inst_75561);

(statearr_75598_75622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75577 === (10))){
var state_75576__$1 = state_75576;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75576__$1,(13),max);
} else {
if((state_val_75577 === (8))){
var inst_75548 = (state_75576[(2)]);
var inst_75549 = fluree.db.util.async.channel_QMARK_(max);
var state_75576__$1 = (function (){var statearr_75599 = state_75576;
(statearr_75599[(8)] = inst_75548);

return statearr_75599;
})();
if(inst_75549){
var statearr_75600_75623 = state_75576__$1;
(statearr_75600_75623[(1)] = (10));

} else {
var statearr_75601_75624 = state_75576__$1;
(statearr_75601_75624[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__17178__auto____0 = (function (){
var statearr_75602 = [null,null,null,null,null,null,null,null,null,null];
(statearr_75602[(0)] = fluree$db$dbfunctions$fns$state_machine__17178__auto__);

(statearr_75602[(1)] = (1));

return statearr_75602;
});
var fluree$db$dbfunctions$fns$state_machine__17178__auto____1 = (function (state_75576){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_75576);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75603){var ex__17181__auto__ = e75603;
var statearr_75604_75625 = state_75576;
(statearr_75604_75625[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_75576[(4)]))){
var statearr_75605_75626 = state_75576;
(statearr_75605_75626[(1)] = cljs.core.first((state_75576[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75627 = state_75576;
state_75576 = G__75627;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__17178__auto__ = function(state_75576){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__17178__auto____1.call(this,state_75576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75606 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75606[(6)] = c__17304__auto__);

return statearr_75606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_75648){
var state_val_75649 = (state_75648[(1)]);
if((state_val_75649 === (1))){
var state_75648__$1 = state_75648;
var statearr_75650_75665 = state_75648__$1;
(statearr_75650_75665[(2)] = null);

(statearr_75650_75665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75649 === (2))){
var _ = (function (){var statearr_75651 = state_75648;
(statearr_75651[(4)] = cljs.core.cons((5),(state_75648[(4)])));

return statearr_75651;
})();
var inst_75634 = fluree.db.util.core.random_uuid();
var inst_75635 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75634);
var inst_75636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75637 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75638 = cljs.core.PersistentVector.EMPTY;
var inst_75639 = ["uuid",inst_75638,inst_75635];
var inst_75640 = cljs.core.PersistentHashMap.fromArrays(inst_75637,inst_75639);
var inst_75641 = [inst_75640,(10)];
var inst_75642 = (new cljs.core.PersistentVector(null,2,(5),inst_75636,inst_75641,null));
var inst_75643 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75642);
var ___$1 = (function (){var statearr_75652 = state_75648;
(statearr_75652[(4)] = cljs.core.rest((state_75648[(4)])));

return statearr_75652;
})();
var state_75648__$1 = (function (){var statearr_75653 = state_75648;
(statearr_75653[(7)] = inst_75643);

return statearr_75653;
})();
var statearr_75654_75666 = state_75648__$1;
(statearr_75654_75666[(2)] = inst_75635);

(statearr_75654_75666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75649 === (3))){
var inst_75646 = (state_75648[(2)]);
var state_75648__$1 = state_75648;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75648__$1,inst_75646);
} else {
if((state_val_75649 === (4))){
var inst_75628 = (state_75648[(2)]);
var state_75648__$1 = state_75648;
var statearr_75656_75667 = state_75648__$1;
(statearr_75656_75667[(2)] = inst_75628);

(statearr_75656_75667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75649 === (5))){
var _ = (function (){var statearr_75657 = state_75648;
(statearr_75657[(4)] = cljs.core.rest((state_75648[(4)])));

return statearr_75657;
})();
var state_75648__$1 = state_75648;
var ex75655 = (state_75648__$1[(2)]);
var statearr_75658_75668 = state_75648__$1;
(statearr_75658_75668[(5)] = ex75655);


if((ex75655 instanceof Error)){
var statearr_75659_75669 = state_75648__$1;
(statearr_75659_75669[(1)] = (4));

(statearr_75659_75669[(5)] = null);

} else {
throw ex75655;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__17178__auto____0 = (function (){
var statearr_75660 = [null,null,null,null,null,null,null,null];
(statearr_75660[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__17178__auto__);

(statearr_75660[(1)] = (1));

return statearr_75660;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__17178__auto____1 = (function (state_75648){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_75648);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75661){var ex__17181__auto__ = e75661;
var statearr_75662_75670 = state_75648;
(statearr_75662_75670[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_75648[(4)]))){
var statearr_75663_75671 = state_75648;
(statearr_75663_75671[(1)] = cljs.core.first((state_75648[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75672 = state_75648;
state_75648 = G__75672;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__17178__auto__ = function(state_75648){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__17178__auto____1.call(this,state_75648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75664 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75664[(6)] = c__17304__auto__);

return statearr_75664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_75702){
var state_val_75703 = (state_75702[(1)]);
if((state_val_75703 === (7))){
var state_75702__$1 = state_75702;
var statearr_75704_75723 = state_75702__$1;
(statearr_75704_75723[(2)] = num);

(statearr_75704_75723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75703 === (1))){
var state_75702__$1 = state_75702;
var statearr_75705_75724 = state_75702__$1;
(statearr_75705_75724[(2)] = null);

(statearr_75705_75724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75703 === (4))){
var inst_75673 = (state_75702[(2)]);
var state_75702__$1 = state_75702;
var statearr_75706_75725 = state_75702__$1;
(statearr_75706_75725[(2)] = inst_75673);

(statearr_75706_75725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75703 === (6))){
var state_75702__$1 = state_75702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75702__$1,(9),num);
} else {
if((state_val_75703 === (3))){
var inst_75700 = (state_75702[(2)]);
var state_75702__$1 = state_75702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75702__$1,inst_75700);
} else {
if((state_val_75703 === (2))){
var _ = (function (){var statearr_75708 = state_75702;
(statearr_75708[(4)] = cljs.core.cons((5),(state_75702[(4)])));

return statearr_75708;
})();
var inst_75679 = fluree.db.util.async.channel_QMARK_(num);
var state_75702__$1 = state_75702;
if(inst_75679){
var statearr_75709_75726 = state_75702__$1;
(statearr_75709_75726[(1)] = (6));

} else {
var statearr_75710_75727 = state_75702__$1;
(statearr_75710_75727[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75703 === (9))){
var inst_75682 = (state_75702[(2)]);
var inst_75683 = fluree.db.util.async.throw_err(inst_75682);
var state_75702__$1 = state_75702;
var statearr_75711_75728 = state_75702__$1;
(statearr_75711_75728[(2)] = inst_75683);

(statearr_75711_75728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75703 === (5))){
var _ = (function (){var statearr_75712 = state_75702;
(statearr_75712[(4)] = cljs.core.rest((state_75702[(4)])));

return statearr_75712;
})();
var state_75702__$1 = state_75702;
var ex75707 = (state_75702__$1[(2)]);
var statearr_75713_75729 = state_75702__$1;
(statearr_75713_75729[(5)] = ex75707);


if((ex75707 instanceof Error)){
var statearr_75714_75730 = state_75702__$1;
(statearr_75714_75730[(1)] = (4));

(statearr_75714_75730[(5)] = null);

} else {
throw ex75707;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75703 === (8))){
var inst_75686 = (state_75702[(2)]);
var inst_75687 = fluree.db.dbfunctions.internal.ceil(inst_75686);
var inst_75688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75689 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75691 = [fluree.db.dbfunctions.fns.ceil];
var inst_75692 = (new cljs.core.PersistentVector(null,1,(5),inst_75690,inst_75691,null));
var inst_75693 = ["",inst_75692,inst_75687];
var inst_75694 = cljs.core.PersistentHashMap.fromArrays(inst_75689,inst_75693);
var inst_75695 = [inst_75694,(10)];
var inst_75696 = (new cljs.core.PersistentVector(null,2,(5),inst_75688,inst_75695,null));
var inst_75697 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75696);
var _ = (function (){var statearr_75715 = state_75702;
(statearr_75715[(4)] = cljs.core.rest((state_75702[(4)])));

return statearr_75715;
})();
var state_75702__$1 = (function (){var statearr_75716 = state_75702;
(statearr_75716[(7)] = inst_75697);

return statearr_75716;
})();
var statearr_75717_75731 = state_75702__$1;
(statearr_75717_75731[(2)] = inst_75687);

(statearr_75717_75731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__17178__auto____0 = (function (){
var statearr_75718 = [null,null,null,null,null,null,null,null];
(statearr_75718[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__17178__auto__);

(statearr_75718[(1)] = (1));

return statearr_75718;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__17178__auto____1 = (function (state_75702){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_75702);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75719){var ex__17181__auto__ = e75719;
var statearr_75720_75732 = state_75702;
(statearr_75720_75732[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_75702[(4)]))){
var statearr_75721_75733 = state_75702;
(statearr_75721_75733[(1)] = cljs.core.first((state_75702[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75734 = state_75702;
state_75702 = G__75734;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__17178__auto__ = function(state_75702){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__17178__auto____1.call(this,state_75702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75722 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75722[(6)] = c__17304__auto__);

return statearr_75722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_75764){
var state_val_75765 = (state_75764[(1)]);
if((state_val_75765 === (7))){
var state_75764__$1 = state_75764;
var statearr_75766_75785 = state_75764__$1;
(statearr_75766_75785[(2)] = num);

(statearr_75766_75785[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75765 === (1))){
var state_75764__$1 = state_75764;
var statearr_75767_75786 = state_75764__$1;
(statearr_75767_75786[(2)] = null);

(statearr_75767_75786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75765 === (4))){
var inst_75735 = (state_75764[(2)]);
var state_75764__$1 = state_75764;
var statearr_75768_75787 = state_75764__$1;
(statearr_75768_75787[(2)] = inst_75735);

(statearr_75768_75787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75765 === (6))){
var state_75764__$1 = state_75764;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75764__$1,(9),num);
} else {
if((state_val_75765 === (3))){
var inst_75762 = (state_75764[(2)]);
var state_75764__$1 = state_75764;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75764__$1,inst_75762);
} else {
if((state_val_75765 === (2))){
var _ = (function (){var statearr_75770 = state_75764;
(statearr_75770[(4)] = cljs.core.cons((5),(state_75764[(4)])));

return statearr_75770;
})();
var inst_75741 = fluree.db.util.async.channel_QMARK_(num);
var state_75764__$1 = state_75764;
if(inst_75741){
var statearr_75771_75788 = state_75764__$1;
(statearr_75771_75788[(1)] = (6));

} else {
var statearr_75772_75789 = state_75764__$1;
(statearr_75772_75789[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75765 === (9))){
var inst_75744 = (state_75764[(2)]);
var inst_75745 = fluree.db.util.async.throw_err(inst_75744);
var state_75764__$1 = state_75764;
var statearr_75773_75790 = state_75764__$1;
(statearr_75773_75790[(2)] = inst_75745);

(statearr_75773_75790[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75765 === (5))){
var _ = (function (){var statearr_75774 = state_75764;
(statearr_75774[(4)] = cljs.core.rest((state_75764[(4)])));

return statearr_75774;
})();
var state_75764__$1 = state_75764;
var ex75769 = (state_75764__$1[(2)]);
var statearr_75775_75791 = state_75764__$1;
(statearr_75775_75791[(5)] = ex75769);


if((ex75769 instanceof Error)){
var statearr_75776_75792 = state_75764__$1;
(statearr_75776_75792[(1)] = (4));

(statearr_75776_75792[(5)] = null);

} else {
throw ex75769;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75765 === (8))){
var inst_75748 = (state_75764[(2)]);
var inst_75749 = fluree.db.dbfunctions.internal.floor(inst_75748);
var inst_75750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75751 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75752 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75753 = [fluree.db.dbfunctions.fns.floor];
var inst_75754 = (new cljs.core.PersistentVector(null,1,(5),inst_75752,inst_75753,null));
var inst_75755 = ["",inst_75754,inst_75749];
var inst_75756 = cljs.core.PersistentHashMap.fromArrays(inst_75751,inst_75755);
var inst_75757 = [inst_75756,(10)];
var inst_75758 = (new cljs.core.PersistentVector(null,2,(5),inst_75750,inst_75757,null));
var inst_75759 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75758);
var _ = (function (){var statearr_75777 = state_75764;
(statearr_75777[(4)] = cljs.core.rest((state_75764[(4)])));

return statearr_75777;
})();
var state_75764__$1 = (function (){var statearr_75778 = state_75764;
(statearr_75778[(7)] = inst_75759);

return statearr_75778;
})();
var statearr_75779_75793 = state_75764__$1;
(statearr_75779_75793[(2)] = inst_75749);

(statearr_75779_75793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__17178__auto____0 = (function (){
var statearr_75780 = [null,null,null,null,null,null,null,null];
(statearr_75780[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__17178__auto__);

(statearr_75780[(1)] = (1));

return statearr_75780;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__17178__auto____1 = (function (state_75764){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_75764);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75781){var ex__17181__auto__ = e75781;
var statearr_75782_75794 = state_75764;
(statearr_75782_75794[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_75764[(4)]))){
var statearr_75783_75795 = state_75764;
(statearr_75783_75795[(1)] = cljs.core.first((state_75764[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75796 = state_75764;
state_75764 = G__75796;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__17178__auto__ = function(state_75764){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__17178__auto____1.call(this,state_75764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75784 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75784[(6)] = c__17304__auto__);

return statearr_75784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_75821){
var state_val_75822 = (state_75821[(1)]);
if((state_val_75822 === (1))){
var state_75821__$1 = state_75821;
var statearr_75823_75838 = state_75821__$1;
(statearr_75823_75838[(2)] = null);

(statearr_75823_75838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75822 === (2))){
var _ = (function (){var statearr_75824 = state_75821;
(statearr_75824[(4)] = cljs.core.cons((5),(state_75821[(4)])));

return statearr_75824;
})();
var inst_75803 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_75821__$1 = state_75821;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75821__$1,(6),inst_75803);
} else {
if((state_val_75822 === (3))){
var inst_75819 = (state_75821[(2)]);
var state_75821__$1 = state_75821;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75821__$1,inst_75819);
} else {
if((state_val_75822 === (4))){
var inst_75797 = (state_75821[(2)]);
var state_75821__$1 = state_75821;
var statearr_75826_75839 = state_75821__$1;
(statearr_75826_75839[(2)] = inst_75797);

(statearr_75826_75839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75822 === (5))){
var _ = (function (){var statearr_75827 = state_75821;
(statearr_75827[(4)] = cljs.core.rest((state_75821[(4)])));

return statearr_75827;
})();
var state_75821__$1 = state_75821;
var ex75825 = (state_75821__$1[(2)]);
var statearr_75828_75840 = state_75821__$1;
(statearr_75828_75840[(5)] = ex75825);


if((ex75825 instanceof Error)){
var statearr_75829_75841 = state_75821__$1;
(statearr_75829_75841[(1)] = (4));

(statearr_75829_75841[(5)] = null);

} else {
throw ex75825;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75822 === (6))){
var inst_75805 = (state_75821[(2)]);
var inst_75806 = fluree.db.util.async.throw_err(inst_75805);
var inst_75807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75808 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_75809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75810 = [compare_val,new_val];
var inst_75811 = (new cljs.core.PersistentVector(null,2,(5),inst_75809,inst_75810,null));
var inst_75812 = ["",inst_75811,inst_75806];
var inst_75813 = cljs.core.PersistentHashMap.fromArrays(inst_75808,inst_75812);
var inst_75814 = [inst_75813,(10)];
var inst_75815 = (new cljs.core.PersistentVector(null,2,(5),inst_75807,inst_75814,null));
var inst_75816 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75815);
var _ = (function (){var statearr_75830 = state_75821;
(statearr_75830[(4)] = cljs.core.rest((state_75821[(4)])));

return statearr_75830;
})();
var state_75821__$1 = (function (){var statearr_75831 = state_75821;
(statearr_75831[(7)] = inst_75816);

return statearr_75831;
})();
var statearr_75832_75842 = state_75821__$1;
(statearr_75832_75842[(2)] = inst_75806);

(statearr_75832_75842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__17178__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__17178__auto____0 = (function (){
var statearr_75833 = [null,null,null,null,null,null,null,null];
(statearr_75833[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__17178__auto__);

(statearr_75833[(1)] = (1));

return statearr_75833;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__17178__auto____1 = (function (state_75821){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_75821);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e75834){var ex__17181__auto__ = e75834;
var statearr_75835_75843 = state_75821;
(statearr_75835_75843[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_75821[(4)]))){
var statearr_75836_75844 = state_75821;
(statearr_75836_75844[(1)] = cljs.core.first((state_75821[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75845 = state_75821;
state_75821 = G__75845;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__17178__auto__ = function(state_75821){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__17178__auto____1.call(this,state_75821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__17178__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__17178__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_75837 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_75837[(6)] = c__17304__auto__);

return statearr_75837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
