// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__81721 = arguments.length;
switch (G__81721) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_81763){
var state_val_81764 = (state_81763[(1)]);
if((state_val_81764 === (7))){
var inst_81733 = typeof user === 'string';
var state_81763__$1 = state_81763;
if(cljs.core.truth_(inst_81733)){
var statearr_81765_81794 = state_81763__$1;
(statearr_81765_81794[(1)] = (9));

} else {
var statearr_81766_81795 = state_81763__$1;
(statearr_81766_81795[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (1))){
var state_81763__$1 = state_81763;
var statearr_81767_81796 = state_81763__$1;
(statearr_81767_81796[(2)] = null);

(statearr_81767_81796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (4))){
var inst_81722 = (state_81763[(2)]);
var inst_81723 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_81722], 0));
var inst_81724 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_81722) : reject.call(null,inst_81722));
var state_81763__$1 = (function (){var statearr_81768 = state_81763;
(statearr_81768[(7)] = inst_81723);

return statearr_81768;
})();
var statearr_81769_81797 = state_81763__$1;
(statearr_81769_81797[(2)] = inst_81724);

(statearr_81769_81797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (15))){
var inst_81752 = (state_81763[(2)]);
var inst_81753 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_81752);
var inst_81754 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_81755 = cljs.core.constantly(inst_81753);
var inst_81756 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_81754,inst_81755);
var inst_81757 = fluree.db.connection.add_token(conn,inst_81753);
var inst_81758 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_81752) : resolve.call(null,inst_81752));
var _ = (function (){var statearr_81770 = state_81763;
(statearr_81770[(4)] = cljs.core.rest((state_81763[(4)])));

return statearr_81770;
})();
var state_81763__$1 = (function (){var statearr_81771 = state_81763;
(statearr_81771[(8)] = inst_81757);

(statearr_81771[(9)] = inst_81756);

return statearr_81771;
})();
var statearr_81772_81798 = state_81763__$1;
(statearr_81772_81798[(2)] = inst_81758);

(statearr_81772_81798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (13))){
var state_81763__$1 = state_81763;
var statearr_81773_81799 = state_81763__$1;
(statearr_81773_81799[(2)] = null);

(statearr_81773_81799[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (6))){
var state_81763__$1 = state_81763;
var statearr_81774_81800 = state_81763__$1;
(statearr_81774_81800[(2)] = user);

(statearr_81774_81800[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (3))){
var inst_81761 = (state_81763[(2)]);
var state_81763__$1 = state_81763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81763__$1,inst_81761);
} else {
if((state_val_81764 === (12))){
var state_81763__$1 = state_81763;
var statearr_81775_81801 = state_81763__$1;
(statearr_81775_81801[(2)] = user);

(statearr_81775_81801[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (2))){
var _ = (function (){var statearr_81776 = state_81763;
(statearr_81776[(4)] = cljs.core.cons((5),(state_81763[(4)])));

return statearr_81776;
})();
var inst_81730 = typeof user === 'number';
var state_81763__$1 = state_81763;
if(cljs.core.truth_(inst_81730)){
var statearr_81777_81802 = state_81763__$1;
(statearr_81777_81802[(1)] = (6));

} else {
var statearr_81778_81803 = state_81763__$1;
(statearr_81778_81803[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (11))){
var inst_81744 = (state_81763[(2)]);
var state_81763__$1 = state_81763;
var statearr_81780_81804 = state_81763__$1;
(statearr_81780_81804[(2)] = inst_81744);

(statearr_81780_81804[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (9))){
var inst_81735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81736 = ["_user/username",user];
var inst_81737 = (new cljs.core.PersistentVector(null,2,(5),inst_81735,inst_81736,null));
var state_81763__$1 = state_81763;
var statearr_81781_81805 = state_81763__$1;
(statearr_81781_81805[(2)] = inst_81737);

(statearr_81781_81805[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (5))){
var _ = (function (){var statearr_81782 = state_81763;
(statearr_81782[(4)] = cljs.core.rest((state_81763[(4)])));

return statearr_81782;
})();
var state_81763__$1 = state_81763;
var ex81779 = (state_81763__$1[(2)]);
var statearr_81783_81806 = state_81763__$1;
(statearr_81783_81806[(5)] = ex81779);


var statearr_81784_81807 = state_81763__$1;
(statearr_81784_81807[(1)] = (4));

(statearr_81784_81807[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (14))){
var inst_81742 = (state_81763[(2)]);
var state_81763__$1 = state_81763;
var statearr_81785_81808 = state_81763__$1;
(statearr_81785_81808[(2)] = inst_81742);

(statearr_81785_81808[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (10))){
var state_81763__$1 = state_81763;
var statearr_81786_81809 = state_81763__$1;
(statearr_81786_81809[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81764 === (8))){
var inst_81746 = (state_81763[(2)]);
var inst_81747 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_81748 = [account,inst_81746,password,expireSeconds,syncTo];
var inst_81749 = cljs.core.PersistentHashMap.fromArrays(inst_81747,inst_81748);
var inst_81750 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_81749);
var state_81763__$1 = state_81763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81763__$1,(15),inst_81750);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__17178__auto__ = null;
var fluree$db$connection_js$state_machine__17178__auto____0 = (function (){
var statearr_81788 = [null,null,null,null,null,null,null,null,null,null];
(statearr_81788[(0)] = fluree$db$connection_js$state_machine__17178__auto__);

(statearr_81788[(1)] = (1));

return statearr_81788;
});
var fluree$db$connection_js$state_machine__17178__auto____1 = (function (state_81763){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_81763);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e81789){var ex__17181__auto__ = e81789;
var statearr_81790_81810 = state_81763;
(statearr_81790_81810[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_81763[(4)]))){
var statearr_81791_81811 = state_81763;
(statearr_81791_81811[(1)] = cljs.core.first((state_81763[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81812 = state_81763;
state_81763 = G__81812;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__17178__auto__ = function(state_81763){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__17178__auto____1.call(this,state_81763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__17178__auto____0;
fluree$db$connection_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__17178__auto____1;
return fluree$db$connection_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_81792 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_81792[(6)] = c__17304__auto__);

return statearr_81792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__81814 = arguments.length;
switch (G__81814) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_81823){
var state_val_81824 = (state_81823[(1)]);
if((state_val_81824 === (1))){
var inst_81815 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_81816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81817 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_81818 = (new cljs.core.PersistentVector(null,4,(5),inst_81816,inst_81817,null));
var inst_81819 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_81815,inst_81818);
var inst_81820 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__81825 = cljs.core.seq(cljs.core.keys(x));
var chunk__81826 = null;
var count__81827 = (0);
var i__81828 = (0);
while(true){
if((i__81828 < count__81827)){
var k = chunk__81826.cljs$core$IIndexed$_nth$arity$2(null,i__81828);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__81836 = seq__81825;
var G__81837 = chunk__81826;
var G__81838 = count__81827;
var G__81839 = (i__81828 + (1));
seq__81825 = G__81836;
chunk__81826 = G__81837;
count__81827 = G__81838;
i__81828 = G__81839;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__81825);
if(temp__5753__auto__){
var seq__81825__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__81825__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__81825__$1);
var G__81840 = cljs.core.chunk_rest(seq__81825__$1);
var G__81841 = c__4638__auto__;
var G__81842 = cljs.core.count(c__4638__auto__);
var G__81843 = (0);
seq__81825 = G__81840;
chunk__81826 = G__81841;
count__81827 = G__81842;
i__81828 = G__81843;
continue;
} else {
var k = cljs.core.first(seq__81825__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__81844 = cljs.core.next(seq__81825__$1);
var G__81845 = null;
var G__81846 = (0);
var G__81847 = (0);
seq__81825 = G__81844;
chunk__81826 = G__81845;
count__81827 = G__81846;
i__81828 = G__81847;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_81821 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_81820);
var state_81823__$1 = (function (){var statearr_81829 = state_81823;
(statearr_81829[(7)] = inst_81819);

return statearr_81829;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_81823__$1,inst_81821);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__17178__auto__ = null;
var fluree$db$connection_js$state_machine__17178__auto____0 = (function (){
var statearr_81830 = [null,null,null,null,null,null,null,null];
(statearr_81830[(0)] = fluree$db$connection_js$state_machine__17178__auto__);

(statearr_81830[(1)] = (1));

return statearr_81830;
});
var fluree$db$connection_js$state_machine__17178__auto____1 = (function (state_81823){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_81823);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e81831){var ex__17181__auto__ = e81831;
var statearr_81832_81848 = state_81823;
(statearr_81832_81848[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_81823[(4)]))){
var statearr_81833_81849 = state_81823;
(statearr_81833_81849[(1)] = cljs.core.first((state_81823[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81850 = state_81823;
state_81823 = G__81850;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__17178__auto__ = function(state_81823){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__17178__auto____1.call(this,state_81823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__17178__auto____0;
fluree$db$connection_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__17178__auto____1;
return fluree$db$connection_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_81834 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_81834[(6)] = c__17304__auto__);

return statearr_81834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__81852 = arguments.length;
switch (G__81852) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_81886){
var state_val_81887 = (state_81886[(1)]);
if((state_val_81887 === (1))){
var state_81886__$1 = state_81886;
var statearr_81888_81909 = state_81886__$1;
(statearr_81888_81909[(2)] = null);

(statearr_81888_81909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81887 === (2))){
var _ = (function (){var statearr_81889 = state_81886;
(statearr_81889[(4)] = cljs.core.cons((5),(state_81886[(4)])));

return statearr_81889;
})();
var inst_81861 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_81862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81863 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_81864 = (new cljs.core.PersistentVector(null,1,(5),inst_81862,inst_81863,null));
var inst_81865 = cljs.core.PersistentHashMap.EMPTY;
var inst_81866 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_81865);
var inst_81867 = cljs.core.assoc_in(inst_81861,inst_81864,inst_81866);
var inst_81868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81869 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_81870 = (new cljs.core.PersistentVector(null,1,(5),inst_81868,inst_81869,null));
var inst_81871 = cljs.core.PersistentHashMap.EMPTY;
var inst_81872 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_81871);
var inst_81873 = cljs.core.assoc_in(inst_81867,inst_81870,inst_81872);
var inst_81874 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_81875 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_81873);
var inst_81876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81877 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_81874,null];
var inst_81878 = (new cljs.core.PersistentVector(null,4,(5),inst_81876,inst_81877,null));
var inst_81879 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_81875,inst_81878);
var inst_81880 = (function (){var conn = inst_81873;
var pc = inst_81874;
return (function (x){
if((x == null)){
} else {
var seq__81890_81910 = cljs.core.seq(cljs.core.keys(x));
var chunk__81891_81911 = null;
var count__81892_81912 = (0);
var i__81893_81913 = (0);
while(true){
if((i__81893_81913 < count__81892_81912)){
var k_81914 = chunk__81891_81911.cljs$core$IIndexed$_nth$arity$2(null,i__81893_81913);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_81914], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_81914,null));


var G__81915 = seq__81890_81910;
var G__81916 = chunk__81891_81911;
var G__81917 = count__81892_81912;
var G__81918 = (i__81893_81913 + (1));
seq__81890_81910 = G__81915;
chunk__81891_81911 = G__81916;
count__81892_81912 = G__81917;
i__81893_81913 = G__81918;
continue;
} else {
var temp__5753__auto___81919 = cljs.core.seq(seq__81890_81910);
if(temp__5753__auto___81919){
var seq__81890_81920__$1 = temp__5753__auto___81919;
if(cljs.core.chunked_seq_QMARK_(seq__81890_81920__$1)){
var c__4638__auto___81921 = cljs.core.chunk_first(seq__81890_81920__$1);
var G__81922 = cljs.core.chunk_rest(seq__81890_81920__$1);
var G__81923 = c__4638__auto___81921;
var G__81924 = cljs.core.count(c__4638__auto___81921);
var G__81925 = (0);
seq__81890_81910 = G__81922;
chunk__81891_81911 = G__81923;
count__81892_81912 = G__81924;
i__81893_81913 = G__81925;
continue;
} else {
var k_81926 = cljs.core.first(seq__81890_81920__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_81926], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_81926,null));


var G__81927 = cljs.core.next(seq__81890_81920__$1);
var G__81928 = null;
var G__81929 = (0);
var G__81930 = (0);
seq__81890_81910 = G__81927;
chunk__81891_81911 = G__81928;
count__81892_81912 = G__81929;
i__81893_81913 = G__81930;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_81881 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_81874,inst_81880);
var ___$1 = (function (){var statearr_81894 = state_81886;
(statearr_81894[(4)] = cljs.core.rest((state_81886[(4)])));

return statearr_81894;
})();
var state_81886__$1 = (function (){var statearr_81895 = state_81886;
(statearr_81895[(7)] = inst_81879);

return statearr_81895;
})();
var statearr_81896_81931 = state_81886__$1;
(statearr_81896_81931[(2)] = inst_81881);

(statearr_81896_81931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81887 === (3))){
var inst_81884 = (state_81886[(2)]);
var state_81886__$1 = state_81886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81886__$1,inst_81884);
} else {
if((state_val_81887 === (4))){
var inst_81853 = (state_81886[(2)]);
var inst_81854 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_81853], 0));
var inst_81855 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_81853) : reject.call(null,inst_81853));
var state_81886__$1 = (function (){var statearr_81898 = state_81886;
(statearr_81898[(8)] = inst_81854);

return statearr_81898;
})();
var statearr_81899_81932 = state_81886__$1;
(statearr_81899_81932[(2)] = inst_81855);

(statearr_81899_81932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81887 === (5))){
var _ = (function (){var statearr_81900 = state_81886;
(statearr_81900[(4)] = cljs.core.rest((state_81886[(4)])));

return statearr_81900;
})();
var state_81886__$1 = state_81886;
var ex81897 = (state_81886__$1[(2)]);
var statearr_81901_81933 = state_81886__$1;
(statearr_81901_81933[(5)] = ex81897);


var statearr_81902_81934 = state_81886__$1;
(statearr_81902_81934[(1)] = (4));

(statearr_81902_81934[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__17178__auto__ = null;
var fluree$db$connection_js$state_machine__17178__auto____0 = (function (){
var statearr_81903 = [null,null,null,null,null,null,null,null,null];
(statearr_81903[(0)] = fluree$db$connection_js$state_machine__17178__auto__);

(statearr_81903[(1)] = (1));

return statearr_81903;
});
var fluree$db$connection_js$state_machine__17178__auto____1 = (function (state_81886){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_81886);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e81904){var ex__17181__auto__ = e81904;
var statearr_81905_81935 = state_81886;
(statearr_81905_81935[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_81886[(4)]))){
var statearr_81906_81936 = state_81886;
(statearr_81906_81936[(1)] = cljs.core.first((state_81886[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81937 = state_81886;
state_81886 = G__81937;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__17178__auto__ = function(state_81886){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__17178__auto____1.call(this,state_81886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__17178__auto____0;
fluree$db$connection_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__17178__auto____1;
return fluree$db$connection_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_81907 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_81907[(6)] = c__17304__auto__);

return statearr_81907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__81939 = arguments.length;
switch (G__81939) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__81941 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__81941,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__81941,(1),null);
var cb_STAR_ = (function (header,data){
var G__81944 = cljs.core.clj__GT_js(header);
var G__81945 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__81944,G__81945) : callback.call(null,G__81944,G__81945));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__81946 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__81946,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__81946,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_81999){
var state_val_82000 = (state_81999[(1)]);
if((state_val_82000 === (7))){
var inst_81960 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81961 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_81962 = cljs.core.PersistentHashMap.fromArrays(inst_81960,inst_81961);
var inst_81963 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_81962);
var inst_81964 = (function(){throw inst_81963})();
var state_81999__$1 = state_81999;
var statearr_82001_82033 = state_81999__$1;
(statearr_82001_82033[(2)] = inst_81964);

(statearr_82001_82033[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82000 === (1))){
var state_81999__$1 = state_81999;
var statearr_82002_82034 = state_81999__$1;
(statearr_82002_82034[(2)] = null);

(statearr_82002_82034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82000 === (4))){
var inst_81949 = (state_81999[(2)]);
var inst_81950 = cljs.core.clj__GT_js(inst_81949);
var inst_81951 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_81950) : reject.call(null,inst_81950));
var state_81999__$1 = state_81999;
var statearr_82003_82035 = state_81999__$1;
(statearr_82003_82035[(2)] = inst_81951);

(statearr_82003_82035[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82000 === (13))){
var inst_81978 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81979 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_81980 = cljs.core.PersistentHashMap.fromArrays(inst_81978,inst_81979);
var inst_81981 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_81980);
var inst_81982 = (function(){throw inst_81981})();
var state_81999__$1 = state_81999;
var statearr_82004_82036 = state_81999__$1;
(statearr_82004_82036[(2)] = inst_81982);

(statearr_82004_82036[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82000 === (6))){
var state_81999__$1 = state_81999;
var statearr_82005_82037 = state_81999__$1;
(statearr_82005_82037[(2)] = null);

(statearr_82005_82037[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82000 === (3))){
var inst_81997 = (state_81999[(2)]);
var state_81999__$1 = state_81999;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81999__$1,inst_81997);
} else {
if((state_val_82000 === (12))){
var state_81999__$1 = state_81999;
var statearr_82006_82038 = state_81999__$1;
(statearr_82006_82038[(2)] = null);

(statearr_82006_82038[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82000 === (2))){
var _ = (function (){var statearr_82007 = state_81999;
(statearr_82007[(4)] = cljs.core.cons((5),(state_81999[(4)])));

return statearr_82007;
})();
var inst_81957 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_81999__$1 = state_81999;
if(cljs.core.truth_(inst_81957)){
var statearr_82008_82039 = state_81999__$1;
(statearr_82008_82039[(1)] = (6));

} else {
var statearr_82009_82040 = state_81999__$1;
(statearr_82009_82040[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82000 === (11))){
var inst_81975 = (state_81999[(2)]);
var state_81999__$1 = (function (){var statearr_82011 = state_81999;
(statearr_82011[(7)] = inst_81975);

return statearr_82011;
})();
if(cljs.core.truth_(password)){
var statearr_82012_82041 = state_81999__$1;
(statearr_82012_82041[(1)] = (12));

} else {
var statearr_82013_82042 = state_81999__$1;
(statearr_82013_82042[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82000 === (9))){
var state_81999__$1 = state_81999;
var statearr_82014_82043 = state_81999__$1;
(statearr_82014_82043[(2)] = null);

(statearr_82014_82043[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82000 === (5))){
var _ = (function (){var statearr_82015 = state_81999;
(statearr_82015[(4)] = cljs.core.rest((state_81999[(4)])));

return statearr_82015;
})();
var state_81999__$1 = state_81999;
var ex82010 = (state_81999__$1[(2)]);
var statearr_82016_82044 = state_81999__$1;
(statearr_82016_82044[(5)] = ex82010);


var statearr_82017_82045 = state_81999__$1;
(statearr_82017_82045[(1)] = (4));

(statearr_82017_82045[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82000 === (14))){
var inst_81984 = (state_81999[(2)]);
var inst_81985 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_81986 = fluree.db.util.core.without_nils(inst_81985);
var inst_81987 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_81988 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_81989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81990 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_81986,inst_81987,null];
var inst_81991 = (new cljs.core.PersistentVector(null,4,(5),inst_81989,inst_81990,null));
var inst_81992 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_81988,inst_81991);
var inst_81993 = (function (){var _ = inst_81984;
var data = inst_81986;
var pc = inst_81987;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__82018 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__82018) : reject.call(null,G__82018));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__82019 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__82019) : reject.call(null,G__82019));
} else {
var G__82020 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__82020) : resolve.call(null,G__82020));

}
}
});
})();
var inst_81994 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_81987,inst_81993);
var _ = (function (){var statearr_82021 = state_81999;
(statearr_82021[(4)] = cljs.core.rest((state_81999[(4)])));

return statearr_82021;
})();
var state_81999__$1 = (function (){var statearr_82022 = state_81999;
(statearr_82022[(8)] = inst_81992);

return statearr_82022;
})();
var statearr_82023_82046 = state_81999__$1;
(statearr_82023_82046[(2)] = inst_81994);

(statearr_82023_82046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82000 === (10))){
var inst_81969 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_81970 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_81971 = cljs.core.PersistentHashMap.fromArrays(inst_81969,inst_81970);
var inst_81972 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_81971);
var inst_81973 = (function(){throw inst_81972})();
var state_81999__$1 = state_81999;
var statearr_82024_82047 = state_81999__$1;
(statearr_82024_82047[(2)] = inst_81973);

(statearr_82024_82047[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82000 === (8))){
var inst_81966 = (state_81999[(2)]);
var state_81999__$1 = (function (){var statearr_82025 = state_81999;
(statearr_82025[(9)] = inst_81966);

return statearr_82025;
})();
if(cljs.core.truth_(ledger)){
var statearr_82026_82048 = state_81999__$1;
(statearr_82026_82048[(1)] = (9));

} else {
var statearr_82027_82049 = state_81999__$1;
(statearr_82027_82049[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__17178__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__17178__auto____0 = (function (){
var statearr_82028 = [null,null,null,null,null,null,null,null,null,null];
(statearr_82028[(0)] = fluree$db$connection_js$password_generate_$_state_machine__17178__auto__);

(statearr_82028[(1)] = (1));

return statearr_82028;
});
var fluree$db$connection_js$password_generate_$_state_machine__17178__auto____1 = (function (state_81999){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_81999);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e82029){var ex__17181__auto__ = e82029;
var statearr_82030_82050 = state_81999;
(statearr_82030_82050[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_81999[(4)]))){
var statearr_82031_82051 = state_81999;
(statearr_82031_82051[(1)] = cljs.core.first((state_81999[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82052 = state_81999;
state_81999 = G__82052;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__17178__auto__ = function(state_81999){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__17178__auto____1.call(this,state_81999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__17178__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__17178__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_82032 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_82032[(6)] = c__17304__auto__);

return statearr_82032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__82054 = arguments.length;
switch (G__82054) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_82121){
var state_val_82122 = (state_82121[(1)]);
if((state_val_82122 === (7))){
var inst_82066 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_82067 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_82068 = cljs.core.PersistentHashMap.fromArrays(inst_82066,inst_82067);
var inst_82069 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_82068);
var inst_82070 = (function(){throw inst_82069})();
var state_82121__$1 = state_82121;
var statearr_82123_82165 = state_82121__$1;
(statearr_82123_82165[(2)] = inst_82070);

(statearr_82123_82165[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (20))){
var inst_82104 = (state_82121[(2)]);
var inst_82105 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_82106 = [ledger,password,user,auth,expire];
var inst_82107 = cljs.core.PersistentHashMap.fromArrays(inst_82105,inst_82106);
var inst_82108 = fluree.db.util.core.without_nils(inst_82107);
var inst_82109 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_82110 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_82111 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82112 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_82108,inst_82109,null];
var inst_82113 = (new cljs.core.PersistentVector(null,4,(5),inst_82111,inst_82112,null));
var inst_82114 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_82110,inst_82113);
var inst_82115 = (function (){var _ = inst_82104;
var data = inst_82108;
var pc = inst_82109;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__82124 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__82124) : reject.call(null,G__82124));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__82125 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__82125) : reject.call(null,G__82125));
} else {
fluree.db.connection.add_token(conn,result);

var G__82126 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__82126) : resolve.call(null,G__82126));

}
}
});
})();
var inst_82116 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_82109,inst_82115);
var _ = (function (){var statearr_82127 = state_82121;
(statearr_82127[(4)] = cljs.core.rest((state_82121[(4)])));

return statearr_82127;
})();
var state_82121__$1 = (function (){var statearr_82128 = state_82121;
(statearr_82128[(7)] = inst_82114);

return statearr_82128;
})();
var statearr_82129_82166 = state_82121__$1;
(statearr_82129_82166[(2)] = inst_82116);

(statearr_82129_82166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (1))){
var state_82121__$1 = state_82121;
var statearr_82130_82167 = state_82121__$1;
(statearr_82130_82167[(2)] = null);

(statearr_82130_82167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (4))){
var inst_82055 = (state_82121[(2)]);
var inst_82056 = cljs.core.clj__GT_js(inst_82055);
var inst_82057 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_82056) : reject.call(null,inst_82056));
var state_82121__$1 = state_82121;
var statearr_82131_82168 = state_82121__$1;
(statearr_82131_82168[(2)] = inst_82057);

(statearr_82131_82168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (15))){
var inst_82091 = (state_82121[(8)]);
var state_82121__$1 = state_82121;
var statearr_82132_82169 = state_82121__$1;
(statearr_82132_82169[(2)] = inst_82091);

(statearr_82132_82169[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (13))){
var inst_82084 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_82085 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_82086 = cljs.core.PersistentHashMap.fromArrays(inst_82084,inst_82085);
var inst_82087 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_82086);
var inst_82088 = (function(){throw inst_82087})();
var state_82121__$1 = state_82121;
var statearr_82133_82170 = state_82121__$1;
(statearr_82133_82170[(2)] = inst_82088);

(statearr_82133_82170[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (6))){
var state_82121__$1 = state_82121;
var statearr_82134_82171 = state_82121__$1;
(statearr_82134_82171[(2)] = null);

(statearr_82134_82171[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (17))){
var inst_82095 = (state_82121[(2)]);
var state_82121__$1 = state_82121;
if(cljs.core.truth_(inst_82095)){
var statearr_82135_82172 = state_82121__$1;
(statearr_82135_82172[(1)] = (18));

} else {
var statearr_82136_82173 = state_82121__$1;
(statearr_82136_82173[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (3))){
var inst_82119 = (state_82121[(2)]);
var state_82121__$1 = state_82121;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82121__$1,inst_82119);
} else {
if((state_val_82122 === (12))){
var state_82121__$1 = state_82121;
var statearr_82137_82174 = state_82121__$1;
(statearr_82137_82174[(2)] = null);

(statearr_82137_82174[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (2))){
var _ = (function (){var statearr_82138 = state_82121;
(statearr_82138[(4)] = cljs.core.cons((5),(state_82121[(4)])));

return statearr_82138;
})();
var inst_82063 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_82121__$1 = state_82121;
if(cljs.core.truth_(inst_82063)){
var statearr_82139_82175 = state_82121__$1;
(statearr_82139_82175[(1)] = (6));

} else {
var statearr_82140_82176 = state_82121__$1;
(statearr_82140_82176[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (19))){
var inst_82098 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_82099 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_82100 = cljs.core.PersistentHashMap.fromArrays(inst_82098,inst_82099);
var inst_82101 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_82100);
var inst_82102 = (function(){throw inst_82101})();
var state_82121__$1 = state_82121;
var statearr_82141_82177 = state_82121__$1;
(statearr_82141_82177[(2)] = inst_82102);

(statearr_82141_82177[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (11))){
var inst_82081 = (state_82121[(2)]);
var state_82121__$1 = (function (){var statearr_82143 = state_82121;
(statearr_82143[(9)] = inst_82081);

return statearr_82143;
})();
if(cljs.core.truth_(password)){
var statearr_82144_82178 = state_82121__$1;
(statearr_82144_82178[(1)] = (12));

} else {
var statearr_82145_82179 = state_82121__$1;
(statearr_82145_82179[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (9))){
var state_82121__$1 = state_82121;
var statearr_82146_82180 = state_82121__$1;
(statearr_82146_82180[(2)] = null);

(statearr_82146_82180[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (5))){
var _ = (function (){var statearr_82147 = state_82121;
(statearr_82147[(4)] = cljs.core.rest((state_82121[(4)])));

return statearr_82147;
})();
var state_82121__$1 = state_82121;
var ex82142 = (state_82121__$1[(2)]);
var statearr_82148_82181 = state_82121__$1;
(statearr_82148_82181[(5)] = ex82142);


var statearr_82149_82182 = state_82121__$1;
(statearr_82149_82182[(1)] = (4));

(statearr_82149_82182[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (14))){
var inst_82091 = (state_82121[(8)]);
var inst_82090 = (state_82121[(2)]);
var inst_82091__$1 = user;
var state_82121__$1 = (function (){var statearr_82150 = state_82121;
(statearr_82150[(8)] = inst_82091__$1);

(statearr_82150[(10)] = inst_82090);

return statearr_82150;
})();
if(cljs.core.truth_(inst_82091__$1)){
var statearr_82151_82183 = state_82121__$1;
(statearr_82151_82183[(1)] = (15));

} else {
var statearr_82152_82184 = state_82121__$1;
(statearr_82152_82184[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (16))){
var state_82121__$1 = state_82121;
var statearr_82153_82185 = state_82121__$1;
(statearr_82153_82185[(2)] = auth);

(statearr_82153_82185[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (10))){
var inst_82075 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_82076 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_82077 = cljs.core.PersistentHashMap.fromArrays(inst_82075,inst_82076);
var inst_82078 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_82077);
var inst_82079 = (function(){throw inst_82078})();
var state_82121__$1 = state_82121;
var statearr_82154_82186 = state_82121__$1;
(statearr_82154_82186[(2)] = inst_82079);

(statearr_82154_82186[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (18))){
var state_82121__$1 = state_82121;
var statearr_82155_82187 = state_82121__$1;
(statearr_82155_82187[(2)] = null);

(statearr_82155_82187[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82122 === (8))){
var inst_82072 = (state_82121[(2)]);
var state_82121__$1 = (function (){var statearr_82156 = state_82121;
(statearr_82156[(11)] = inst_82072);

return statearr_82156;
})();
if(cljs.core.truth_(ledger)){
var statearr_82157_82188 = state_82121__$1;
(statearr_82157_82188[(1)] = (9));

} else {
var statearr_82158_82189 = state_82121__$1;
(statearr_82158_82189[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__17178__auto__ = null;
var fluree$db$connection_js$state_machine__17178__auto____0 = (function (){
var statearr_82159 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82159[(0)] = fluree$db$connection_js$state_machine__17178__auto__);

(statearr_82159[(1)] = (1));

return statearr_82159;
});
var fluree$db$connection_js$state_machine__17178__auto____1 = (function (state_82121){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_82121);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e82160){var ex__17181__auto__ = e82160;
var statearr_82161_82190 = state_82121;
(statearr_82161_82190[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_82121[(4)]))){
var statearr_82162_82191 = state_82121;
(statearr_82162_82191[(1)] = cljs.core.first((state_82121[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82192 = state_82121;
state_82121 = G__82192;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__17178__auto__ = function(state_82121){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__17178__auto____1.call(this,state_82121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__17178__auto____0;
fluree$db$connection_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__17178__auto____1;
return fluree$db$connection_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_82163 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_82163[(6)] = c__17304__auto__);

return statearr_82163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__82194 = arguments.length;
switch (G__82194) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_82229){
var state_val_82230 = (state_82229[(1)]);
if((state_val_82230 === (1))){
var state_82229__$1 = state_82229;
var statearr_82231_82253 = state_82229__$1;
(statearr_82231_82253[(2)] = null);

(statearr_82231_82253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82230 === (2))){
var _ = (function (){var statearr_82232 = state_82229;
(statearr_82232[(4)] = cljs.core.cons((5),(state_82229[(4)])));

return statearr_82232;
})();
var inst_82203 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_82229__$1 = state_82229;
if(cljs.core.truth_(inst_82203)){
var statearr_82233_82254 = state_82229__$1;
(statearr_82233_82254[(1)] = (6));

} else {
var statearr_82234_82255 = state_82229__$1;
(statearr_82234_82255[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82230 === (3))){
var inst_82227 = (state_82229[(2)]);
var state_82229__$1 = state_82229;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82229__$1,inst_82227);
} else {
if((state_val_82230 === (4))){
var inst_82195 = (state_82229[(2)]);
var inst_82196 = cljs.core.clj__GT_js(inst_82195);
var inst_82197 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_82196) : reject.call(null,inst_82196));
var state_82229__$1 = state_82229;
var statearr_82236_82256 = state_82229__$1;
(statearr_82236_82256[(2)] = inst_82197);

(statearr_82236_82256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82230 === (5))){
var _ = (function (){var statearr_82237 = state_82229;
(statearr_82237[(4)] = cljs.core.rest((state_82229[(4)])));

return statearr_82237;
})();
var state_82229__$1 = state_82229;
var ex82235 = (state_82229__$1[(2)]);
var statearr_82238_82257 = state_82229__$1;
(statearr_82238_82257[(5)] = ex82235);


var statearr_82239_82258 = state_82229__$1;
(statearr_82239_82258[(1)] = (4));

(statearr_82239_82258[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82230 === (6))){
var state_82229__$1 = state_82229;
var statearr_82240_82259 = state_82229__$1;
(statearr_82240_82259[(2)] = null);

(statearr_82240_82259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82230 === (7))){
var inst_82206 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_82207 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_82208 = cljs.core.PersistentHashMap.fromArrays(inst_82206,inst_82207);
var inst_82209 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_82208);
var inst_82210 = (function(){throw inst_82209})();
var state_82229__$1 = state_82229;
var statearr_82241_82260 = state_82229__$1;
(statearr_82241_82260[(2)] = inst_82210);

(statearr_82241_82260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82230 === (8))){
var inst_82212 = (state_82229[(2)]);
var inst_82213 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_82214 = [jwt,expire];
var inst_82215 = cljs.core.PersistentHashMap.fromArrays(inst_82213,inst_82214);
var inst_82216 = fluree.db.util.core.without_nils(inst_82215);
var inst_82217 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_82218 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_82219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82220 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_82216,inst_82217,null];
var inst_82221 = (new cljs.core.PersistentVector(null,4,(5),inst_82219,inst_82220,null));
var inst_82222 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_82218,inst_82221);
var inst_82223 = (function (){var _ = inst_82212;
var data = inst_82216;
var pc = inst_82217;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__82242 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__82242) : reject.call(null,G__82242));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__82243 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__82243) : resolve.call(null,G__82243));

}
});
})();
var inst_82224 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_82217,inst_82223);
var _ = (function (){var statearr_82244 = state_82229;
(statearr_82244[(4)] = cljs.core.rest((state_82229[(4)])));

return statearr_82244;
})();
var state_82229__$1 = (function (){var statearr_82245 = state_82229;
(statearr_82245[(7)] = inst_82222);

return statearr_82245;
})();
var statearr_82246_82261 = state_82229__$1;
(statearr_82246_82261[(2)] = inst_82224);

(statearr_82246_82261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__17178__auto__ = null;
var fluree$db$connection_js$state_machine__17178__auto____0 = (function (){
var statearr_82247 = [null,null,null,null,null,null,null,null];
(statearr_82247[(0)] = fluree$db$connection_js$state_machine__17178__auto__);

(statearr_82247[(1)] = (1));

return statearr_82247;
});
var fluree$db$connection_js$state_machine__17178__auto____1 = (function (state_82229){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_82229);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e82248){var ex__17181__auto__ = e82248;
var statearr_82249_82262 = state_82229;
(statearr_82249_82262[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_82229[(4)]))){
var statearr_82250_82263 = state_82229;
(statearr_82250_82263[(1)] = cljs.core.first((state_82229[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82264 = state_82229;
state_82229 = G__82264;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__17178__auto__ = function(state_82229){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__17178__auto____1.call(this,state_82229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__17178__auto____0;
fluree$db$connection_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__17178__auto____1;
return fluree$db$connection_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_82251 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_82251[(6)] = c__17304__auto__);

return statearr_82251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

