// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4824__auto__ = [];
var len__4818__auto___82338 = arguments.length;
var i__4819__auto___82339 = (0);
while(true){
if((i__4819__auto___82339 < len__4818__auto___82338)){
args__4824__auto__.push((arguments[i__4819__auto___82339]));

var G__82340 = (i__4819__auto___82339 + (1));
i__4819__auto___82339 = G__82340;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__82270){
var vec__82271 = p__82270;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__82271,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__17304__auto___82341 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_82315){
var state_val_82316 = (state_82315[(1)]);
if((state_val_82316 === (7))){
var inst_82292 = (state_82315[(7)]);
var inst_82301 = (state_82315[(8)]);
var inst_82303 = fluree.db.time_travel.as_of_block(inst_82301,inst_82292);
var state_82315__$1 = state_82315;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82315__$1,(10),inst_82303);
} else {
if((state_val_82316 === (1))){
var state_82315__$1 = state_82315;
var statearr_82317_82342 = state_82315__$1;
(statearr_82317_82342[(2)] = null);

(statearr_82317_82342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82316 === (4))){
var inst_82274 = (state_82315[(2)]);
var inst_82275 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_82274], 0));
var inst_82276 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_82274);
var inst_82277 = cljs.core.async.close_BANG_(pc);
var state_82315__$1 = (function (){var statearr_82318 = state_82315;
(statearr_82318[(9)] = inst_82275);

(statearr_82318[(10)] = inst_82276);

return statearr_82318;
})();
var statearr_82319_82343 = state_82315__$1;
(statearr_82319_82343[(2)] = inst_82277);

(statearr_82319_82343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82316 === (6))){
var inst_82295 = (state_82315[(11)]);
var inst_82296 = (state_82315[(12)]);
var inst_82292 = (state_82315[(7)]);
var inst_82299 = (state_82315[(2)]);
var inst_82300 = fluree.db.util.async.throw_err(inst_82299);
var inst_82301 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_82300,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_82295,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_82296], 0));
var state_82315__$1 = (function (){var statearr_82320 = state_82315;
(statearr_82320[(8)] = inst_82301);

return statearr_82320;
})();
if(cljs.core.truth_(inst_82292)){
var statearr_82321_82344 = state_82315__$1;
(statearr_82321_82344[(1)] = (7));

} else {
var statearr_82322_82345 = state_82315__$1;
(statearr_82322_82345[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82316 === (3))){
var inst_82313 = (state_82315[(2)]);
var state_82315__$1 = state_82315;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82315__$1,inst_82313);
} else {
if((state_val_82316 === (2))){
var _ = (function (){var statearr_82324 = state_82315;
(statearr_82324[(4)] = cljs.core.cons((5),(state_82315[(4)])));

return statearr_82324;
})();
var inst_82287 = opts;
var inst_82288 = cljs.core.__destructure_map(inst_82287);
var inst_82289 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82288,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_82290 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82288,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_82291 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82288,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_82292 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82288,new cljs.core.Keyword(null,"block","block",664686210));
var inst_82293 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_82294 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_82295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_82294,(0),null);
var inst_82296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_82294,(1),null);
var inst_82297 = fluree.db.session.db(conn,ledger,opts);
var state_82315__$1 = (function (){var statearr_82325 = state_82315;
(statearr_82325[(11)] = inst_82295);

(statearr_82325[(13)] = inst_82291);

(statearr_82325[(12)] = inst_82296);

(statearr_82325[(7)] = inst_82292);

(statearr_82325[(14)] = inst_82289);

(statearr_82325[(15)] = inst_82293);

(statearr_82325[(16)] = inst_82290);

return statearr_82325;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82315__$1,(6),inst_82297);
} else {
if((state_val_82316 === (9))){
var inst_82309 = (state_82315[(2)]);
var inst_82310 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_82309);
var _ = (function (){var statearr_82326 = state_82315;
(statearr_82326[(4)] = cljs.core.rest((state_82315[(4)])));

return statearr_82326;
})();
var state_82315__$1 = state_82315;
var statearr_82327_82346 = state_82315__$1;
(statearr_82327_82346[(2)] = inst_82310);

(statearr_82327_82346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82316 === (5))){
var _ = (function (){var statearr_82328 = state_82315;
(statearr_82328[(4)] = cljs.core.rest((state_82315[(4)])));

return statearr_82328;
})();
var state_82315__$1 = state_82315;
var ex82323 = (state_82315__$1[(2)]);
var statearr_82329_82347 = state_82315__$1;
(statearr_82329_82347[(5)] = ex82323);


var statearr_82330_82348 = state_82315__$1;
(statearr_82330_82348[(1)] = (4));

(statearr_82330_82348[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82316 === (10))){
var inst_82305 = (state_82315[(2)]);
var inst_82306 = fluree.db.util.async.throw_err(inst_82305);
var state_82315__$1 = state_82315;
var statearr_82331_82349 = state_82315__$1;
(statearr_82331_82349[(2)] = inst_82306);

(statearr_82331_82349[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82316 === (8))){
var inst_82301 = (state_82315[(8)]);
var state_82315__$1 = state_82315;
var statearr_82332_82350 = state_82315__$1;
(statearr_82332_82350[(2)] = inst_82301);

(statearr_82332_82350[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__17178__auto__ = null;
var fluree$db$api_js$state_machine__17178__auto____0 = (function (){
var statearr_82333 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82333[(0)] = fluree$db$api_js$state_machine__17178__auto__);

(statearr_82333[(1)] = (1));

return statearr_82333;
});
var fluree$db$api_js$state_machine__17178__auto____1 = (function (state_82315){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_82315);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e82334){var ex__17181__auto__ = e82334;
var statearr_82335_82351 = state_82315;
(statearr_82335_82351[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_82315[(4)]))){
var statearr_82336_82352 = state_82315;
(statearr_82336_82352[(1)] = cljs.core.first((state_82315[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82353 = state_82315;
state_82315 = G__82353;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__17178__auto__ = function(state_82315){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__17178__auto____1.call(this,state_82315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__17178__auto____0;
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__17178__auto____1;
return fluree$db$api_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_82337 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_82337[(6)] = c__17304__auto___82341);

return statearr_82337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq82267){
var G__82268 = cljs.core.first(seq82267);
var seq82267__$1 = cljs.core.next(seq82267);
var G__82269 = cljs.core.first(seq82267__$1);
var seq82267__$2 = cljs.core.next(seq82267__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82268,G__82269,seq82267__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4210__auto__){
var and__4210__auto____$1 = open_api;
if(cljs.core.truth_(and__4210__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4210__auto__){
return open_api;
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4210__auto__){
return auth;
} else {
return and__4210__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__82355 = arguments.length;
switch (G__82355) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_82481){
var state_val_82482 = (state_82481[(1)]);
if((state_val_82482 === (7))){
var inst_82371 = (state_82481[(7)]);
var inst_82381 = (state_82481[(8)]);
var inst_82383 = fluree.db.time_travel.as_of_block(inst_82381,inst_82371);
var state_82481__$1 = state_82481;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82481__$1,(10),inst_82383);
} else {
if((state_val_82482 === (20))){
var inst_82375 = (state_82481[(9)]);
var state_82481__$1 = state_82481;
var statearr_82483_82563 = state_82481__$1;
(statearr_82483_82563[(2)] = inst_82375);

(statearr_82483_82563[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (27))){
var inst_82369 = (state_82481[(10)]);
var state_82481__$1 = state_82481;
var statearr_82484_82564 = state_82481__$1;
(statearr_82484_82564[(2)] = inst_82369);

(statearr_82484_82564[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (1))){
var state_82481__$1 = state_82481;
var statearr_82485_82565 = state_82481__$1;
(statearr_82485_82565[(2)] = null);

(statearr_82485_82565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (24))){
var inst_82378 = (state_82481[(11)]);
var state_82481__$1 = state_82481;
if(cljs.core.truth_(inst_82378)){
var statearr_82486_82566 = state_82481__$1;
(statearr_82486_82566[(1)] = (26));

} else {
var statearr_82487_82567 = state_82481__$1;
(statearr_82487_82567[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (39))){
var inst_82443 = (state_82481[(12)]);
var inst_82446 = cljs.core.ex_data(inst_82443);
var inst_82447 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_82448 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_82446);
var inst_82449 = cljs.core.ex_message(inst_82443);
var inst_82450 = [inst_82448,inst_82449,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_82451 = cljs.core.PersistentHashMap.fromArrays(inst_82447,inst_82450);
var state_82481__$1 = state_82481;
var statearr_82488_82568 = state_82481__$1;
(statearr_82488_82568[(2)] = inst_82451);

(statearr_82488_82568[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (46))){
var inst_82443 = (state_82481[(12)]);
var state_82481__$1 = state_82481;
var statearr_82489_82569 = state_82481__$1;
(statearr_82489_82569[(2)] = inst_82443);

(statearr_82489_82569[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (4))){
var inst_82356 = (state_82481[(2)]);
var inst_82357 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_82356], 0));
var inst_82358 = cljs.core.ex_data(inst_82356);
var inst_82359 = cljs.core.ex_message(inst_82356);
var inst_82360 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_82358,new cljs.core.Keyword(null,"message","message",-406056002),inst_82359);
var state_82481__$1 = (function (){var statearr_82490 = state_82481;
(statearr_82490[(13)] = inst_82357);

return statearr_82490;
})();
var statearr_82491_82570 = state_82481__$1;
(statearr_82491_82570[(2)] = inst_82360);

(statearr_82491_82570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (15))){
var state_82481__$1 = state_82481;
var statearr_82492_82571 = state_82481__$1;
(statearr_82492_82571[(2)] = (1000000));

(statearr_82492_82571[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (48))){
var inst_82443 = (state_82481[(12)]);
var state_82481__$1 = state_82481;
var statearr_82493_82572 = state_82481__$1;
(statearr_82493_82572[(2)] = inst_82443);

(statearr_82493_82572[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (50))){
var inst_82470 = (state_82481[(2)]);
var state_82481__$1 = state_82481;
var statearr_82494_82573 = state_82481__$1;
(statearr_82494_82573[(2)] = inst_82470);

(statearr_82494_82573[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (21))){
var inst_82374 = (state_82481[(14)]);
var state_82481__$1 = state_82481;
if(cljs.core.truth_(inst_82374)){
var statearr_82495_82574 = state_82481__$1;
(statearr_82495_82574[(1)] = (23));

} else {
var statearr_82496_82575 = state_82481__$1;
(statearr_82496_82575[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (31))){
var inst_82432 = (state_82481[(2)]);
var inst_82433 = cljs.core.not(inst_82432);
var state_82481__$1 = state_82481;
if(inst_82433){
var statearr_82497_82576 = state_82481__$1;
(statearr_82497_82576[(1)] = (35));

} else {
var statearr_82498_82577 = state_82481__$1;
(statearr_82498_82577[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (32))){
var inst_82376 = (state_82481[(15)]);
var state_82481__$1 = state_82481;
var statearr_82499_82578 = state_82481__$1;
(statearr_82499_82578[(2)] = inst_82376);

(statearr_82499_82578[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (40))){
var inst_82406 = (state_82481[(16)]);
var state_82481__$1 = state_82481;
if(cljs.core.truth_(inst_82406)){
var statearr_82500_82579 = state_82481__$1;
(statearr_82500_82579[(1)] = (42));

} else {
var statearr_82501_82580 = state_82481__$1;
(statearr_82501_82580[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (33))){
var inst_82372 = (state_82481[(17)]);
var state_82481__$1 = state_82481;
var statearr_82502_82581 = state_82481__$1;
(statearr_82502_82581[(2)] = inst_82372);

(statearr_82502_82581[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (13))){
var inst_82401 = (state_82481[(18)]);
var inst_82377 = (state_82481[(19)]);
var inst_82399 = (state_82481[(2)]);
var inst_82400 = cljs.core.volatile_BANG_((0));
var inst_82401__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_82377);
var state_82481__$1 = (function (){var statearr_82503 = state_82481;
(statearr_82503[(18)] = inst_82401__$1);

(statearr_82503[(20)] = inst_82400);

(statearr_82503[(21)] = inst_82399);

return statearr_82503;
})();
if(cljs.core.truth_(inst_82401__$1)){
var statearr_82504_82582 = state_82481__$1;
(statearr_82504_82582[(1)] = (14));

} else {
var statearr_82505_82583 = state_82481__$1;
(statearr_82505_82583[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (22))){
var inst_82422 = (state_82481[(2)]);
var state_82481__$1 = state_82481;
var statearr_82506_82584 = state_82481__$1;
(statearr_82506_82584[(2)] = inst_82422);

(statearr_82506_82584[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (36))){
var inst_82389 = (state_82481[(22)]);
var inst_82408 = (state_82481[(23)]);
var inst_82439 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_82408);
var inst_82440 = fluree.db.query.fql.query(inst_82389,inst_82439);
var state_82481__$1 = state_82481;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82481__$1,(38),inst_82440);
} else {
if((state_val_82482 === (41))){
var inst_82474 = (state_82481[(2)]);
var state_82481__$1 = state_82481;
var statearr_82507_82585 = state_82481__$1;
(statearr_82507_82585[(2)] = inst_82474);

(statearr_82507_82585[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (43))){
var state_82481__$1 = state_82481;
var statearr_82508_82586 = state_82481__$1;
(statearr_82508_82586[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (29))){
var inst_82376 = (state_82481[(15)]);
var state_82481__$1 = state_82481;
if(cljs.core.truth_(inst_82376)){
var statearr_82510_82587 = state_82481__$1;
(statearr_82510_82587[(1)] = (32));

} else {
var statearr_82511_82588 = state_82481__$1;
(statearr_82511_82588[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (44))){
var inst_82472 = (state_82481[(2)]);
var state_82481__$1 = state_82481;
var statearr_82512_82589 = state_82481__$1;
(statearr_82512_82589[(2)] = inst_82472);

(statearr_82512_82589[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (6))){
var inst_82371 = (state_82481[(7)]);
var inst_82380 = (state_82481[(2)]);
var inst_82381 = fluree.db.util.async.throw_err(inst_82380);
var state_82481__$1 = (function (){var statearr_82513 = state_82481;
(statearr_82513[(8)] = inst_82381);

return statearr_82513;
})();
if(cljs.core.truth_(inst_82371)){
var statearr_82514_82590 = state_82481__$1;
(statearr_82514_82590[(1)] = (7));

} else {
var statearr_82515_82591 = state_82481__$1;
(statearr_82515_82591[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (28))){
var inst_82418 = (state_82481[(2)]);
var state_82481__$1 = state_82481;
var statearr_82516_82592 = state_82481__$1;
(statearr_82516_82592[(2)] = inst_82418);

(statearr_82516_82592[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (25))){
var inst_82420 = (state_82481[(2)]);
var state_82481__$1 = state_82481;
var statearr_82517_82593 = state_82481__$1;
(statearr_82517_82593[(2)] = inst_82420);

(statearr_82517_82593[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (34))){
var inst_82429 = (state_82481[(2)]);
var state_82481__$1 = state_82481;
var statearr_82518_82594 = state_82481__$1;
(statearr_82518_82594[(2)] = inst_82429);

(statearr_82518_82594[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (17))){
var inst_82370 = (state_82481[(24)]);
var state_82481__$1 = state_82481;
var statearr_82519_82595 = state_82481__$1;
(statearr_82519_82595[(2)] = inst_82370);

(statearr_82519_82595[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (3))){
var inst_82479 = (state_82481[(2)]);
var state_82481__$1 = state_82481;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82481__$1,inst_82479);
} else {
if((state_val_82482 === (12))){
var inst_82397 = cljs.core.PersistentHashMap.EMPTY;
var state_82481__$1 = state_82481;
var statearr_82520_82596 = state_82481__$1;
(statearr_82520_82596[(2)] = inst_82397);

(statearr_82520_82596[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (2))){
var _ = (function (){var statearr_82521 = state_82481;
(statearr_82521[(4)] = cljs.core.cons((5),(state_82481[(4)])));

return statearr_82521;
})();
var inst_82367 = query_map;
var inst_82368 = cljs.core.__destructure_map(inst_82367);
var inst_82369 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82368,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_82370 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82368,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_82371 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82368,new cljs.core.Keyword(null,"block","block",664686210));
var inst_82372 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82368,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_82373 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82368,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_82374 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82368,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_82375 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82368,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_82376 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82368,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_82377 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82368,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_82378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82368,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_82481__$1 = (function (){var statearr_82522 = state_82481;
(statearr_82522[(14)] = inst_82374);

(statearr_82522[(7)] = inst_82371);

(statearr_82522[(15)] = inst_82376);

(statearr_82522[(11)] = inst_82378);

(statearr_82522[(17)] = inst_82372);

(statearr_82522[(24)] = inst_82370);

(statearr_82522[(9)] = inst_82375);

(statearr_82522[(19)] = inst_82377);

(statearr_82522[(10)] = inst_82369);

(statearr_82522[(25)] = inst_82373);

return statearr_82522;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82481__$1,(6),sources);
} else {
if((state_val_82482 === (23))){
var inst_82374 = (state_82481[(14)]);
var state_82481__$1 = state_82481;
var statearr_82523_82597 = state_82481__$1;
(statearr_82523_82597[(2)] = inst_82374);

(statearr_82523_82597[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (47))){
var inst_82400 = (state_82481[(20)]);
var inst_82407 = (state_82481[(26)]);
var inst_82389 = (state_82481[(22)]);
var inst_82454 = (state_82481[(27)]);
var inst_82460 = (state_82481[(2)]);
var inst_82461 = cljs.core.deref(inst_82400);
var inst_82462 = fluree.db.util.core.response_time_formatted(inst_82407);
var inst_82463 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_82389);
var inst_82464 = [(200),inst_82460,inst_82461,inst_82462,inst_82463];
var inst_82465 = cljs.core.PersistentHashMap.fromArrays(inst_82454,inst_82464);
var state_82481__$1 = state_82481;
var statearr_82524_82598 = state_82481__$1;
(statearr_82524_82598[(2)] = inst_82465);

(statearr_82524_82598[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (35))){
var inst_82435 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_82436 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_82437 = cljs.core.PersistentHashMap.fromArrays(inst_82435,inst_82436);
var state_82481__$1 = state_82481;
var statearr_82525_82599 = state_82481__$1;
(statearr_82525_82599[(2)] = inst_82437);

(statearr_82525_82599[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (19))){
var inst_82424 = (state_82481[(28)]);
var inst_82424__$1 = (state_82481[(2)]);
var state_82481__$1 = (function (){var statearr_82526 = state_82481;
(statearr_82526[(28)] = inst_82424__$1);

return statearr_82526;
})();
if(cljs.core.truth_(inst_82424__$1)){
var statearr_82527_82600 = state_82481__$1;
(statearr_82527_82600[(1)] = (29));

} else {
var statearr_82528_82601 = state_82481__$1;
(statearr_82528_82601[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (11))){
var inst_82390 = (state_82481[(29)]);
var inst_82389 = (state_82481[(22)]);
var inst_82373 = (state_82481[(25)]);
var inst_82392 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_82389);
var inst_82393 = fluree.db.connection_js.open_api_QMARK_(inst_82390);
var inst_82394 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_82389);
var inst_82395 = fluree.db.api_js.get_sources(inst_82390,inst_82392,inst_82393,inst_82394,inst_82373,db_fn);
var state_82481__$1 = state_82481;
var statearr_82530_82602 = state_82481__$1;
(statearr_82530_82602[(2)] = inst_82395);

(statearr_82530_82602[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (9))){
var inst_82389 = (state_82481[(22)]);
var inst_82373 = (state_82481[(25)]);
var inst_82389__$1 = (state_82481[(2)]);
var inst_82390 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_82389__$1);
var state_82481__$1 = (function (){var statearr_82531 = state_82481;
(statearr_82531[(29)] = inst_82390);

(statearr_82531[(22)] = inst_82389__$1);

return statearr_82531;
})();
if(cljs.core.truth_(inst_82373)){
var statearr_82532_82603 = state_82481__$1;
(statearr_82532_82603[(1)] = (11));

} else {
var statearr_82533_82604 = state_82481__$1;
(statearr_82533_82604[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (5))){
var _ = (function (){var statearr_82534 = state_82481;
(statearr_82534[(4)] = cljs.core.rest((state_82481[(4)])));

return statearr_82534;
})();
var state_82481__$1 = state_82481;
var ex82529 = (state_82481__$1[(2)]);
var statearr_82535_82605 = state_82481__$1;
(statearr_82535_82605[(5)] = ex82529);


var statearr_82536_82606 = state_82481__$1;
(statearr_82536_82606[(1)] = (4));

(statearr_82536_82606[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (14))){
var inst_82401 = (state_82481[(18)]);
var state_82481__$1 = state_82481;
var statearr_82537_82607 = state_82481__$1;
(statearr_82537_82607[(2)] = inst_82401);

(statearr_82537_82607[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (45))){
var inst_82443 = (state_82481[(12)]);
var inst_82457 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_82443);
var state_82481__$1 = state_82481;
var statearr_82538_82608 = state_82481__$1;
(statearr_82538_82608[(2)] = inst_82457);

(statearr_82538_82608[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (26))){
var inst_82378 = (state_82481[(11)]);
var state_82481__$1 = state_82481;
var statearr_82539_82609 = state_82481__$1;
(statearr_82539_82609[(2)] = inst_82378);

(statearr_82539_82609[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (16))){
var inst_82400 = (state_82481[(20)]);
var inst_82370 = (state_82481[(24)]);
var inst_82377 = (state_82481[(19)]);
var inst_82399 = (state_82481[(21)]);
var inst_82405 = (state_82481[(2)]);
var inst_82406 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_82377);
var inst_82407 = fluree.db.util.core.current_time_millis();
var inst_82408 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_82377,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_82399,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_82405,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_82400], 0));
var state_82481__$1 = (function (){var statearr_82540 = state_82481;
(statearr_82540[(26)] = inst_82407);

(statearr_82540[(16)] = inst_82406);

(statearr_82540[(23)] = inst_82408);

return statearr_82540;
})();
if(cljs.core.truth_(inst_82370)){
var statearr_82541_82610 = state_82481__$1;
(statearr_82541_82610[(1)] = (17));

} else {
var statearr_82542_82611 = state_82481__$1;
(statearr_82542_82611[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (38))){
var inst_82443 = (state_82481[(12)]);
var inst_82442 = (state_82481[(2)]);
var inst_82443__$1 = fluree.db.util.async.throw_err(inst_82442);
var inst_82444 = (inst_82443__$1 instanceof cljs.core.ExceptionInfo);
var state_82481__$1 = (function (){var statearr_82543 = state_82481;
(statearr_82543[(12)] = inst_82443__$1);

return statearr_82543;
})();
if(cljs.core.truth_(inst_82444)){
var statearr_82544_82612 = state_82481__$1;
(statearr_82544_82612[(1)] = (39));

} else {
var statearr_82545_82613 = state_82481__$1;
(statearr_82545_82613[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (30))){
var inst_82424 = (state_82481[(28)]);
var state_82481__$1 = state_82481;
var statearr_82546_82614 = state_82481__$1;
(statearr_82546_82614[(2)] = inst_82424);

(statearr_82546_82614[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (10))){
var inst_82385 = (state_82481[(2)]);
var inst_82386 = fluree.db.util.async.throw_err(inst_82385);
var state_82481__$1 = state_82481;
var statearr_82547_82615 = state_82481__$1;
(statearr_82547_82615[(2)] = inst_82386);

(statearr_82547_82615[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (18))){
var inst_82375 = (state_82481[(9)]);
var state_82481__$1 = state_82481;
if(cljs.core.truth_(inst_82375)){
var statearr_82548_82616 = state_82481__$1;
(statearr_82548_82616[(1)] = (20));

} else {
var statearr_82549_82617 = state_82481__$1;
(statearr_82549_82617[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (42))){
var inst_82443 = (state_82481[(12)]);
var inst_82454 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_82455 = cljs.core.sequential_QMARK_(inst_82443);
var state_82481__$1 = (function (){var statearr_82550 = state_82481;
(statearr_82550[(27)] = inst_82454);

return statearr_82550;
})();
if(inst_82455){
var statearr_82551_82618 = state_82481__$1;
(statearr_82551_82618[(1)] = (45));

} else {
var statearr_82552_82619 = state_82481__$1;
(statearr_82552_82619[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (37))){
var inst_82476 = (state_82481[(2)]);
var _ = (function (){var statearr_82553 = state_82481;
(statearr_82553[(4)] = cljs.core.rest((state_82481[(4)])));

return statearr_82553;
})();
var state_82481__$1 = state_82481;
var statearr_82554_82620 = state_82481__$1;
(statearr_82554_82620[(2)] = inst_82476);

(statearr_82554_82620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (8))){
var inst_82381 = (state_82481[(8)]);
var state_82481__$1 = state_82481;
var statearr_82555_82621 = state_82481__$1;
(statearr_82555_82621[(2)] = inst_82381);

(statearr_82555_82621[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82482 === (49))){
var state_82481__$1 = state_82481;
var statearr_82556_82622 = state_82481__$1;
(statearr_82556_82622[(2)] = null);

(statearr_82556_82622[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__17178__auto__ = null;
var fluree$db$api_js$state_machine__17178__auto____0 = (function (){
var statearr_82557 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82557[(0)] = fluree$db$api_js$state_machine__17178__auto__);

(statearr_82557[(1)] = (1));

return statearr_82557;
});
var fluree$db$api_js$state_machine__17178__auto____1 = (function (state_82481){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_82481);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e82558){var ex__17181__auto__ = e82558;
var statearr_82559_82623 = state_82481;
(statearr_82559_82623[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_82481[(4)]))){
var statearr_82560_82624 = state_82481;
(statearr_82560_82624[(1)] = cljs.core.first((state_82481[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82625 = state_82481;
state_82481 = G__82625;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__17178__auto__ = function(state_82481){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__17178__auto____1.call(this,state_82481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__17178__auto____0;
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__17178__auto____1;
return fluree$db$api_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_82561 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_82561[(6)] = c__17304__auto__);

return statearr_82561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__82626_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__82626_SHARP_);
}));

var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_82648){
var state_val_82649 = (state_82648[(1)]);
if((state_val_82649 === (1))){
var inst_82630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82631 = [resp_chan,timeout_chan];
var inst_82632 = (new cljs.core.PersistentVector(null,2,(5),inst_82630,inst_82631,null));
var state_82648__$1 = state_82648;
return cljs.core.async.ioc_alts_BANG_(state_82648__$1,(2),inst_82632);
} else {
if((state_val_82649 === (2))){
var inst_82634 = (state_82648[(2)]);
var inst_82635 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_82634,(0),null);
var inst_82636 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_82634,(1),null);
var inst_82637 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_82636);
var state_82648__$1 = (function (){var statearr_82650 = state_82648;
(statearr_82650[(7)] = inst_82635);

return statearr_82650;
})();
if(inst_82637){
var statearr_82651_82661 = state_82648__$1;
(statearr_82651_82661[(1)] = (3));

} else {
var statearr_82652_82662 = state_82648__$1;
(statearr_82652_82662[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82649 === (3))){
var inst_82639 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_82640 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_82641 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_82642 = [tid,(408),inst_82641];
var inst_82643 = cljs.core.PersistentHashMap.fromArrays(inst_82640,inst_82642);
var state_82648__$1 = (function (){var statearr_82653 = state_82648;
(statearr_82653[(8)] = inst_82639);

return statearr_82653;
})();
var statearr_82654_82663 = state_82648__$1;
(statearr_82654_82663[(2)] = inst_82643);

(statearr_82654_82663[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82649 === (4))){
var inst_82635 = (state_82648[(7)]);
var state_82648__$1 = state_82648;
var statearr_82655_82664 = state_82648__$1;
(statearr_82655_82664[(2)] = inst_82635);

(statearr_82655_82664[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82649 === (5))){
var inst_82646 = (state_82648[(2)]);
var state_82648__$1 = state_82648;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82648__$1,inst_82646);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__17178__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__17178__auto____0 = (function (){
var statearr_82656 = [null,null,null,null,null,null,null,null,null];
(statearr_82656[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__17178__auto__);

(statearr_82656[(1)] = (1));

return statearr_82656;
});
var fluree$db$api_js$monitor_tx_$_state_machine__17178__auto____1 = (function (state_82648){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_82648);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e82657){var ex__17181__auto__ = e82657;
var statearr_82658_82665 = state_82648;
(statearr_82658_82665[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_82648[(4)]))){
var statearr_82659_82666 = state_82648;
(statearr_82659_82666[(1)] = cljs.core.first((state_82648[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82667 = state_82648;
state_82648 = G__82667;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__17178__auto__ = function(state_82648){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__17178__auto____1.call(this,state_82648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__17178__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__17178__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_82660 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_82660[(6)] = c__17304__auto__);

return statearr_82660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__82669 = arguments.length;
switch (G__82669) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__82670 = opts;
var map__82670__$1 = cljs.core.__destructure_map(map__82670);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__82670__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__82670__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__82670__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__82670__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__82671 = (cljs.core.truth_((function (){var and__4210__auto__ = auth;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4210__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__82671,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__82671,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4212__auto__ = nonce;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4212__auto__ = expire;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e82674){var e = e82674;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__82677 = arguments.length;
switch (G__82677) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_82743){
var state_val_82744 = (state_82743[(1)]);
if((state_val_82744 === (7))){
var inst_82696 = (state_82743[(7)]);
var inst_82698 = (state_82743[(8)]);
var inst_82697 = (state_82743[(9)]);
var inst_82694 = (state_82743[(10)]);
var inst_82699 = (state_82743[(11)]);
var inst_82712 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_82713 = [ledger,txn,inst_82694,inst_82696,inst_82697,inst_82698,inst_82699];
var inst_82714 = cljs.core.PersistentHashMap.fromArrays(inst_82712,inst_82713);
var inst_82715 = fluree.db.util.core.without_nils(inst_82714);
var inst_82716 = fluree.db.operations.transact_async(conn,inst_82715);
var state_82743__$1 = state_82743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82743__$1,(13),inst_82716);
} else {
if((state_val_82744 === (20))){
var inst_82734 = (state_82743[(2)]);
var state_82743__$1 = state_82743;
var statearr_82745_82781 = state_82743__$1;
(statearr_82745_82781[(2)] = inst_82734);

(statearr_82745_82781[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (1))){
var state_82743__$1 = state_82743;
var statearr_82746_82782 = state_82743__$1;
(statearr_82746_82782[(2)] = null);

(statearr_82746_82782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (4))){
var inst_82678 = (state_82743[(2)]);
var inst_82679 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_82678], 0));
var inst_82680 = cljs.core.ex_data(inst_82678);
var inst_82681 = cljs.core.ex_message(inst_82678);
var inst_82682 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_82680,new cljs.core.Keyword(null,"message","message",-406056002),inst_82681);
var state_82743__$1 = (function (){var statearr_82747 = state_82743;
(statearr_82747[(12)] = inst_82679);

return statearr_82747;
})();
var statearr_82748_82783 = state_82743__$1;
(statearr_82748_82783[(2)] = inst_82682);

(statearr_82748_82783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (15))){
var inst_82718 = (state_82743[(13)]);
var inst_82693 = (state_82743[(14)]);
var inst_82721 = fluree.db.api_js.monitor_tx(conn,ledger,inst_82718,inst_82693);
var state_82743__$1 = state_82743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82743__$1,(17),inst_82721);
} else {
if((state_val_82744 === (13))){
var inst_82692 = (state_82743[(15)]);
var inst_82718 = (state_82743[(2)]);
var state_82743__$1 = (function (){var statearr_82749 = state_82743;
(statearr_82749[(13)] = inst_82718);

return statearr_82749;
})();
if(cljs.core.truth_(inst_82692)){
var statearr_82750_82784 = state_82743__$1;
(statearr_82750_82784[(1)] = (14));

} else {
var statearr_82751_82785 = state_82743__$1;
(statearr_82751_82785[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (6))){
var inst_82692 = (state_82743[(15)]);
var inst_82691 = (state_82743[(16)]);
var inst_82701 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_82691,opts);
var inst_82702 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_82701);
var inst_82703 = fluree.db.operations.command_async(conn,inst_82701);
var state_82743__$1 = (function (){var statearr_82752 = state_82743;
(statearr_82752[(17)] = inst_82703);

(statearr_82752[(18)] = inst_82702);

return statearr_82752;
})();
if(cljs.core.truth_(inst_82692)){
var statearr_82753_82786 = state_82743__$1;
(statearr_82753_82786[(1)] = (9));

} else {
var statearr_82754_82787 = state_82743__$1;
(statearr_82754_82787[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (17))){
var inst_82723 = (state_82743[(19)]);
var inst_82723__$1 = (state_82743[(2)]);
var inst_82724 = (inst_82723__$1 instanceof cljs.core.ExceptionInfo);
var state_82743__$1 = (function (){var statearr_82755 = state_82743;
(statearr_82755[(19)] = inst_82723__$1);

return statearr_82755;
})();
if(cljs.core.truth_(inst_82724)){
var statearr_82756_82788 = state_82743__$1;
(statearr_82756_82788[(1)] = (18));

} else {
var statearr_82757_82789 = state_82743__$1;
(statearr_82757_82789[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (3))){
var inst_82741 = (state_82743[(2)]);
var state_82743__$1 = state_82743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82743__$1,inst_82741);
} else {
if((state_val_82744 === (12))){
var inst_82708 = (state_82743[(2)]);
var state_82743__$1 = state_82743;
var statearr_82758_82790 = state_82743__$1;
(statearr_82758_82790[(2)] = inst_82708);

(statearr_82758_82790[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (2))){
var inst_82691 = (state_82743[(16)]);
var _ = (function (){var statearr_82759 = state_82743;
(statearr_82759[(4)] = cljs.core.cons((5),(state_82743[(4)])));

return statearr_82759;
})();
var inst_82689 = opts;
var inst_82690 = cljs.core.__destructure_map(inst_82689);
var inst_82691__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82690,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_82692 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82690,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_82693 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_82690,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_82694 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82690,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_82695 = fluree.db.util.core.current_time_millis();
var inst_82696 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_82690,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_82695);
var inst_82697 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82690,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_82698 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82690,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_82699 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_82690,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_82743__$1 = (function (){var statearr_82760 = state_82743;
(statearr_82760[(7)] = inst_82696);

(statearr_82760[(8)] = inst_82698);

(statearr_82760[(9)] = inst_82697);

(statearr_82760[(15)] = inst_82692);

(statearr_82760[(10)] = inst_82694);

(statearr_82760[(16)] = inst_82691__$1);

(statearr_82760[(14)] = inst_82693);

(statearr_82760[(11)] = inst_82699);

return statearr_82760;
})();
if(cljs.core.truth_(inst_82691__$1)){
var statearr_82761_82791 = state_82743__$1;
(statearr_82761_82791[(1)] = (6));

} else {
var statearr_82762_82792 = state_82743__$1;
(statearr_82762_82792[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (19))){
var inst_82723 = (state_82743[(19)]);
var state_82743__$1 = state_82743;
var statearr_82763_82793 = state_82743__$1;
(statearr_82763_82793[(2)] = inst_82723);

(statearr_82763_82793[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (11))){
var inst_82710 = (state_82743[(2)]);
var state_82743__$1 = state_82743;
var statearr_82765_82794 = state_82743__$1;
(statearr_82765_82794[(2)] = inst_82710);

(statearr_82765_82794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (9))){
var inst_82703 = (state_82743[(17)]);
var state_82743__$1 = state_82743;
var statearr_82766_82795 = state_82743__$1;
(statearr_82766_82795[(2)] = inst_82703);

(statearr_82766_82795[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (5))){
var _ = (function (){var statearr_82767 = state_82743;
(statearr_82767[(4)] = cljs.core.rest((state_82743[(4)])));

return statearr_82767;
})();
var state_82743__$1 = state_82743;
var ex82764 = (state_82743__$1[(2)]);
var statearr_82768_82796 = state_82743__$1;
(statearr_82768_82796[(5)] = ex82764);


var statearr_82769_82797 = state_82743__$1;
(statearr_82769_82797[(1)] = (4));

(statearr_82769_82797[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (14))){
var inst_82718 = (state_82743[(13)]);
var state_82743__$1 = state_82743;
var statearr_82770_82798 = state_82743__$1;
(statearr_82770_82798[(2)] = inst_82718);

(statearr_82770_82798[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (16))){
var inst_82736 = (state_82743[(2)]);
var state_82743__$1 = state_82743;
var statearr_82771_82799 = state_82743__$1;
(statearr_82771_82799[(2)] = inst_82736);

(statearr_82771_82799[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (10))){
var inst_82702 = (state_82743[(18)]);
var inst_82693 = (state_82743[(14)]);
var inst_82706 = fluree.db.api_js.monitor_tx(conn,ledger,inst_82702,inst_82693);
var state_82743__$1 = state_82743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82743__$1,(12),inst_82706);
} else {
if((state_val_82744 === (18))){
var inst_82723 = (state_82743[(19)]);
var inst_82726 = cljs.core.ex_data(inst_82723);
var inst_82727 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_82728 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_82726);
var inst_82729 = cljs.core.ex_message(inst_82723);
var inst_82730 = [inst_82728,inst_82729,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_82731 = cljs.core.PersistentHashMap.fromArrays(inst_82727,inst_82730);
var state_82743__$1 = state_82743;
var statearr_82772_82800 = state_82743__$1;
(statearr_82772_82800[(2)] = inst_82731);

(statearr_82772_82800[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82744 === (8))){
var inst_82738 = (state_82743[(2)]);
var _ = (function (){var statearr_82773 = state_82743;
(statearr_82773[(4)] = cljs.core.rest((state_82743[(4)])));

return statearr_82773;
})();
var state_82743__$1 = state_82743;
var statearr_82774_82801 = state_82743__$1;
(statearr_82774_82801[(2)] = inst_82738);

(statearr_82774_82801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__17178__auto__ = null;
var fluree$db$api_js$state_machine__17178__auto____0 = (function (){
var statearr_82775 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82775[(0)] = fluree$db$api_js$state_machine__17178__auto__);

(statearr_82775[(1)] = (1));

return statearr_82775;
});
var fluree$db$api_js$state_machine__17178__auto____1 = (function (state_82743){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_82743);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e82776){var ex__17181__auto__ = e82776;
var statearr_82777_82802 = state_82743;
(statearr_82777_82802[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_82743[(4)]))){
var statearr_82778_82803 = state_82743;
(statearr_82778_82803[(1)] = cljs.core.first((state_82743[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82804 = state_82743;
state_82743 = G__82804;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__17178__auto__ = function(state_82743){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__17178__auto____1.call(this,state_82743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__17178__auto____0;
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__17178__auto____1;
return fluree$db$api_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_82779 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_82779[(6)] = c__17304__auto__);

return statearr_82779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4824__auto__ = [];
var len__4818__auto___82806 = arguments.length;
var i__4819__auto___82807 = (0);
while(true){
if((i__4819__auto___82807 < len__4818__auto___82806)){
args__4824__auto__.push((arguments[i__4819__auto___82807]));

var G__82808 = (i__4819__auto___82807 + (1));
i__4819__auto___82807 = G__82808;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq82805){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq82805));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_82839){
var state_val_82840 = (state_82839[(1)]);
if((state_val_82840 === (1))){
var inst_82809 = cljs.core.first(flakes);
var inst_82810 = cljs.core.rest(flakes);
var inst_82811 = cljs.core.PersistentVector.EMPTY;
var inst_82812 = inst_82809;
var inst_82813 = inst_82810;
var inst_82814 = inst_82811;
var state_82839__$1 = (function (){var statearr_82841 = state_82839;
(statearr_82841[(7)] = inst_82814);

(statearr_82841[(8)] = inst_82812);

(statearr_82841[(9)] = inst_82813);

return statearr_82841;
})();
var statearr_82842_82855 = state_82839__$1;
(statearr_82842_82855[(2)] = null);

(statearr_82842_82855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82840 === (2))){
var inst_82812 = (state_82839[(8)]);
var inst_82816 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_82817 = cljs.core.PersistentHashMap.EMPTY;
var inst_82818 = [true,inst_82817];
var inst_82819 = cljs.core.PersistentHashMap.fromArrays(inst_82816,inst_82818);
var inst_82820 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_82819,inst_82812);
var state_82839__$1 = state_82839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82839__$1,(4),inst_82820);
} else {
if((state_val_82840 === (3))){
var inst_82837 = (state_82839[(2)]);
var state_82839__$1 = state_82839;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82839__$1,inst_82837);
} else {
if((state_val_82840 === (4))){
var inst_82814 = (state_82839[(7)]);
var inst_82813 = (state_82839[(9)]);
var inst_82822 = (state_82839[(2)]);
var inst_82823 = fluree.db.util.async.throw_err(inst_82822);
var inst_82824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82825 = [inst_82823];
var inst_82826 = (new cljs.core.PersistentVector(null,1,(5),inst_82824,inst_82825,null));
var inst_82827 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_82814,inst_82826);
var inst_82828 = cljs.core.first(inst_82813);
var state_82839__$1 = (function (){var statearr_82843 = state_82839;
(statearr_82843[(10)] = inst_82827);

return statearr_82843;
})();
if(cljs.core.truth_(inst_82828)){
var statearr_82844_82856 = state_82839__$1;
(statearr_82844_82856[(1)] = (5));

} else {
var statearr_82845_82857 = state_82839__$1;
(statearr_82845_82857[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82840 === (5))){
var inst_82827 = (state_82839[(10)]);
var inst_82813 = (state_82839[(9)]);
var inst_82830 = cljs.core.first(inst_82813);
var inst_82831 = cljs.core.rest(inst_82813);
var inst_82812 = inst_82830;
var inst_82813__$1 = inst_82831;
var inst_82814 = inst_82827;
var state_82839__$1 = (function (){var statearr_82846 = state_82839;
(statearr_82846[(7)] = inst_82814);

(statearr_82846[(8)] = inst_82812);

(statearr_82846[(9)] = inst_82813__$1);

return statearr_82846;
})();
var statearr_82847_82858 = state_82839__$1;
(statearr_82847_82858[(2)] = null);

(statearr_82847_82858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82840 === (6))){
var inst_82827 = (state_82839[(10)]);
var state_82839__$1 = state_82839;
var statearr_82848_82859 = state_82839__$1;
(statearr_82848_82859[(2)] = inst_82827);

(statearr_82848_82859[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82840 === (7))){
var inst_82835 = (state_82839[(2)]);
var state_82839__$1 = state_82839;
var statearr_82849_82860 = state_82839__$1;
(statearr_82849_82860[(2)] = inst_82835);

(statearr_82849_82860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__17178__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__17178__auto____0 = (function (){
var statearr_82850 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_82850[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__17178__auto__);

(statearr_82850[(1)] = (1));

return statearr_82850;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__17178__auto____1 = (function (state_82839){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_82839);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e82851){var ex__17181__auto__ = e82851;
var statearr_82852_82861 = state_82839;
(statearr_82852_82861[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_82839[(4)]))){
var statearr_82853_82862 = state_82839;
(statearr_82853_82862[(1)] = cljs.core.first((state_82839[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82863 = state_82839;
state_82839 = G__82863;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__17178__auto__ = function(state_82839){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__17178__auto____1.call(this,state_82839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__17178__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__17178__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_82854 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_82854[(6)] = c__17304__auto__);

return statearr_82854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_82931){
var state_val_82932 = (state_82931[(1)]);
if((state_val_82932 === (7))){
var inst_82891 = (state_82931[(2)]);
var inst_82892 = fluree.db.util.async.throw_err(inst_82891);
var state_82931__$1 = state_82931;
var statearr_82933_82959 = state_82931__$1;
(statearr_82933_82959[(2)] = inst_82892);

(statearr_82933_82959[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82932 === (1))){
var inst_82868 = cljs.core.volatile_BANG_((0));
var inst_82869 = cljs.core.PersistentHashMap.EMPTY;
var inst_82870 = cljs.core.volatile_BANG_(inst_82869);
var inst_82871 = cljs.core.first(resp);
var inst_82872 = cljs.core.rest(resp);
var inst_82873 = cljs.core.PersistentVector.EMPTY;
var inst_82874 = inst_82868;
var inst_82875 = inst_82870;
var inst_82876 = inst_82871;
var inst_82877 = inst_82872;
var inst_82878 = inst_82873;
var state_82931__$1 = (function (){var statearr_82934 = state_82931;
(statearr_82934[(7)] = inst_82876);

(statearr_82934[(8)] = inst_82878);

(statearr_82934[(9)] = inst_82877);

(statearr_82934[(10)] = inst_82874);

(statearr_82934[(11)] = inst_82875);

return statearr_82934;
})();
var statearr_82935_82960 = state_82931__$1;
(statearr_82935_82960[(2)] = null);

(statearr_82935_82960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82932 === (4))){
var inst_82876 = (state_82931[(7)]);
var inst_82878 = (state_82931[(8)]);
var inst_82880 = (state_82931[(12)]);
var inst_82877 = (state_82931[(9)]);
var inst_82882 = (state_82931[(13)]);
var inst_82874 = (state_82931[(10)]);
var inst_82875 = (state_82931[(11)]);
var inst_82886 = (function (){var fuel = inst_82874;
var cache = inst_82875;
var curr_block = inst_82876;
var rest_blocks = inst_82877;
var acc = inst_82878;
var flakes = inst_82880;
var asserted = inst_82882;
return (function (p1__82865_SHARP_){
return p1__82865_SHARP_.s;
});
})();
var inst_82887 = cljs.core.group_by(inst_82886,inst_82882);
var inst_82888 = cljs.core.vals(inst_82887);
var inst_82889 = fluree.db.api_js.format_flake_groups_pretty(db,inst_82875,inst_82874,inst_82888);
var state_82931__$1 = state_82931;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82931__$1,(7),inst_82889);
} else {
if((state_val_82932 === (13))){
var inst_82919 = (state_82931[(14)]);
var state_82931__$1 = state_82931;
var statearr_82936_82961 = state_82931__$1;
(statearr_82936_82961[(2)] = inst_82919);

(statearr_82936_82961[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82932 === (6))){
var inst_82876 = (state_82931[(7)]);
var inst_82878 = (state_82931[(8)]);
var inst_82895 = (state_82931[(15)]);
var inst_82897 = (state_82931[(16)]);
var inst_82880 = (state_82931[(12)]);
var inst_82877 = (state_82931[(9)]);
var inst_82882 = (state_82931[(13)]);
var inst_82874 = (state_82931[(10)]);
var inst_82875 = (state_82931[(11)]);
var inst_82895__$1 = (state_82931[(2)]);
var inst_82896 = (function (){var fuel = inst_82874;
var cache = inst_82875;
var curr_block = inst_82876;
var rest_blocks = inst_82877;
var acc = inst_82878;
var flakes = inst_82880;
var asserted = inst_82882;
var asserted_SINGLEQUOTE_ = inst_82895__$1;
return (function (p1__82866_SHARP_){
return p1__82866_SHARP_.op === false;
});
})();
var inst_82897__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_82896,inst_82880);
var inst_82898 = cljs.core.empty_QMARK_(inst_82897__$1);
var inst_82899 = (!(inst_82898));
var state_82931__$1 = (function (){var statearr_82939 = state_82931;
(statearr_82939[(15)] = inst_82895__$1);

(statearr_82939[(16)] = inst_82897__$1);

return statearr_82939;
})();
if(inst_82899){
var statearr_82940_82962 = state_82931__$1;
(statearr_82940_82962[(1)] = (8));

} else {
var statearr_82941_82963 = state_82931__$1;
(statearr_82941_82963[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82932 === (3))){
var inst_82929 = (state_82931[(2)]);
var state_82931__$1 = state_82931;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82931__$1,inst_82929);
} else {
if((state_val_82932 === (12))){
var inst_82877 = (state_82931[(9)]);
var inst_82874 = (state_82931[(10)]);
var inst_82875 = (state_82931[(11)]);
var inst_82919 = (state_82931[(14)]);
var inst_82922 = cljs.core.first(inst_82877);
var inst_82923 = cljs.core.rest(inst_82877);
var tmp82937 = inst_82874;
var tmp82938 = inst_82875;
var inst_82874__$1 = tmp82937;
var inst_82875__$1 = tmp82938;
var inst_82876 = inst_82922;
var inst_82877__$1 = inst_82923;
var inst_82878 = inst_82919;
var state_82931__$1 = (function (){var statearr_82942 = state_82931;
(statearr_82942[(7)] = inst_82876);

(statearr_82942[(8)] = inst_82878);

(statearr_82942[(9)] = inst_82877__$1);

(statearr_82942[(10)] = inst_82874__$1);

(statearr_82942[(11)] = inst_82875__$1);

return statearr_82942;
})();
var statearr_82943_82964 = state_82931__$1;
(statearr_82943_82964[(2)] = null);

(statearr_82943_82964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82932 === (2))){
var inst_82876 = (state_82931[(7)]);
var inst_82878 = (state_82931[(8)]);
var inst_82880 = (state_82931[(12)]);
var inst_82877 = (state_82931[(9)]);
var inst_82882 = (state_82931[(13)]);
var inst_82874 = (state_82931[(10)]);
var inst_82875 = (state_82931[(11)]);
var inst_82880__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_82876);
var inst_82881 = (function (){var fuel = inst_82874;
var cache = inst_82875;
var curr_block = inst_82876;
var rest_blocks = inst_82877;
var acc = inst_82878;
var flakes = inst_82880__$1;
return (function (p1__82864_SHARP_){
return p1__82864_SHARP_.op;
});
})();
var inst_82882__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_82881,inst_82880__$1);
var inst_82883 = cljs.core.empty_QMARK_(inst_82882__$1);
var inst_82884 = (!(inst_82883));
var state_82931__$1 = (function (){var statearr_82944 = state_82931;
(statearr_82944[(12)] = inst_82880__$1);

(statearr_82944[(13)] = inst_82882__$1);

return statearr_82944;
})();
if(inst_82884){
var statearr_82945_82965 = state_82931__$1;
(statearr_82945_82965[(1)] = (4));

} else {
var statearr_82946_82966 = state_82931__$1;
(statearr_82946_82966[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82932 === (11))){
var inst_82907 = (state_82931[(2)]);
var inst_82908 = fluree.db.util.async.throw_err(inst_82907);
var state_82931__$1 = state_82931;
var statearr_82947_82967 = state_82931__$1;
(statearr_82947_82967[(2)] = inst_82908);

(statearr_82947_82967[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82932 === (9))){
var state_82931__$1 = state_82931;
var statearr_82948_82968 = state_82931__$1;
(statearr_82948_82968[(2)] = null);

(statearr_82948_82968[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82932 === (5))){
var state_82931__$1 = state_82931;
var statearr_82949_82969 = state_82931__$1;
(statearr_82949_82969[(2)] = null);

(statearr_82949_82969[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82932 === (14))){
var inst_82927 = (state_82931[(2)]);
var state_82931__$1 = state_82931;
var statearr_82950_82970 = state_82931__$1;
(statearr_82950_82970[(2)] = inst_82927);

(statearr_82950_82970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82932 === (10))){
var inst_82876 = (state_82931[(7)]);
var inst_82878 = (state_82931[(8)]);
var inst_82895 = (state_82931[(15)]);
var inst_82877 = (state_82931[(9)]);
var inst_82911 = (state_82931[(2)]);
var inst_82912 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_82913 = [inst_82895,inst_82911];
var inst_82914 = cljs.core.PersistentHashMap.fromArrays(inst_82912,inst_82913);
var inst_82915 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_82876,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_82914);
var inst_82916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82917 = [inst_82915];
var inst_82918 = (new cljs.core.PersistentVector(null,1,(5),inst_82916,inst_82917,null));
var inst_82919 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_82878,inst_82918);
var inst_82920 = cljs.core.first(inst_82877);
var state_82931__$1 = (function (){var statearr_82951 = state_82931;
(statearr_82951[(14)] = inst_82919);

return statearr_82951;
})();
if(cljs.core.truth_(inst_82920)){
var statearr_82952_82971 = state_82931__$1;
(statearr_82952_82971[(1)] = (12));

} else {
var statearr_82953_82972 = state_82931__$1;
(statearr_82953_82972[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_82932 === (8))){
var inst_82876 = (state_82931[(7)]);
var inst_82878 = (state_82931[(8)]);
var inst_82895 = (state_82931[(15)]);
var inst_82897 = (state_82931[(16)]);
var inst_82880 = (state_82931[(12)]);
var inst_82877 = (state_82931[(9)]);
var inst_82882 = (state_82931[(13)]);
var inst_82874 = (state_82931[(10)]);
var inst_82875 = (state_82931[(11)]);
var inst_82901 = (function (){var flakes = inst_82880;
var rest_blocks = inst_82877;
var curr_block = inst_82876;
var asserted_SINGLEQUOTE_ = inst_82895;
var acc = inst_82878;
var fuel = inst_82874;
var cache = inst_82875;
var retracted = inst_82897;
var asserted = inst_82882;
return (function (p1__82867_SHARP_){
return p1__82867_SHARP_.s;
});
})();
var inst_82902 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_82897);
var inst_82903 = cljs.core.group_by(inst_82901,inst_82902);
var inst_82904 = cljs.core.vals(inst_82903);
var inst_82905 = fluree.db.api_js.format_flake_groups_pretty(db,inst_82875,inst_82874,inst_82904);
var state_82931__$1 = state_82931;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82931__$1,(11),inst_82905);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__17178__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__17178__auto____0 = (function (){
var statearr_82954 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_82954[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__17178__auto__);

(statearr_82954[(1)] = (1));

return statearr_82954;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__17178__auto____1 = (function (state_82931){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_82931);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e82955){var ex__17181__auto__ = e82955;
var statearr_82956_82973 = state_82931;
(statearr_82956_82973[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_82931[(4)]))){
var statearr_82957_82974 = state_82931;
(statearr_82957_82974[(1)] = cljs.core.first((state_82931[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__82975 = state_82931;
state_82931 = G__82975;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__17178__auto__ = function(state_82931){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__17178__auto____1.call(this,state_82931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__17178__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__17178__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_82958 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_82958[(6)] = c__17304__auto__);

return statearr_82958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_83075){
var state_val_83076 = (state_83075[(1)]);
if((state_val_83076 === (7))){
var inst_83040 = (state_83075[(7)]);
var inst_83047 = (state_83075[(8)]);
var inst_83046 = cljs.core.seq(inst_83040);
var inst_83047__$1 = cljs.core.first(inst_83046);
var inst_83048 = cljs.core.next(inst_83046);
var state_83075__$1 = (function (){var statearr_83077 = state_83075;
(statearr_83077[(9)] = inst_83048);

(statearr_83077[(8)] = inst_83047__$1);

return statearr_83077;
})();
if(cljs.core.truth_(inst_83047__$1)){
var statearr_83078_83115 = state_83075__$1;
(statearr_83078_83115[(1)] = (9));

} else {
var statearr_83079_83116 = state_83075__$1;
(statearr_83079_83116[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83076 === (1))){
var state_83075__$1 = state_83075;
var statearr_83080_83117 = state_83075__$1;
(statearr_83080_83117[(2)] = null);

(statearr_83080_83117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83076 === (4))){
var inst_82977 = (state_83075[(2)]);
var state_83075__$1 = state_83075;
var statearr_83081_83118 = state_83075__$1;
(statearr_83081_83118[(2)] = inst_82977);

(statearr_83081_83118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83076 === (6))){
var inst_83026 = (state_83075[(2)]);
var inst_83027 = fluree.db.util.async.throw_err(inst_83026);
var inst_83035 = resp;
var inst_83036 = cljs.core.seq(inst_83035);
var inst_83037 = cljs.core.first(inst_83036);
var inst_83038 = cljs.core.next(inst_83036);
var inst_83039 = cljs.core.PersistentHashMap.EMPTY;
var inst_83040 = inst_83035;
var inst_83041 = inst_83039;
var state_83075__$1 = (function (){var statearr_83082 = state_83075;
(statearr_83082[(10)] = inst_83038);

(statearr_83082[(7)] = inst_83040);

(statearr_83082[(11)] = inst_83037);

(statearr_83082[(12)] = inst_83027);

(statearr_83082[(13)] = inst_83041);

return statearr_83082;
})();
var statearr_83083_83119 = state_83075__$1;
(statearr_83083_83119[(2)] = null);

(statearr_83083_83119[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83076 === (3))){
var inst_83073 = (state_83075[(2)]);
var state_83075__$1 = state_83075;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83075__$1,inst_83073);
} else {
if((state_val_83076 === (2))){
var _ = (function (){var statearr_83084 = state_83075;
(statearr_83084[(4)] = cljs.core.cons((5),(state_83075[(4)])));

return statearr_83084;
})();
var inst_82983 = (function (){return (function (p1__82976_SHARP_){
return p1__82976_SHARP_.t;
});
})();
var inst_82984 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_82983,resp);
var inst_82985 = cljs.core.set(inst_82984);
var inst_83022 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_83023 = (function (){var ts = inst_82985;
var c__17304__auto____$1 = inst_83022;
return (function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_83020){
var state_val_83021 = (state_83020[(1)]);
if((state_val_83021 === (1))){
var inst_82993 = ts;
var inst_82994 = cljs.core.seq(inst_82993);
var inst_82995 = cljs.core.first(inst_82994);
var inst_82996 = cljs.core.next(inst_82994);
var inst_82997 = cljs.core.PersistentHashMap.EMPTY;
var inst_82998 = inst_82993;
var inst_82999 = inst_82997;
var state_83020__$1 = (function (){var statearr_83085 = state_83020;
(statearr_83085[(7)] = inst_82999);

(statearr_83085[(8)] = inst_82998);

(statearr_83085[(9)] = inst_82995);

(statearr_83085[(10)] = inst_82996);

return statearr_83085;
})();
var statearr_83086_83120 = state_83020__$1;
(statearr_83086_83120[(2)] = null);

(statearr_83086_83120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83021 === (2))){
var inst_82998 = (state_83020[(8)]);
var inst_83005 = (state_83020[(11)]);
var inst_83004 = cljs.core.seq(inst_82998);
var inst_83005__$1 = cljs.core.first(inst_83004);
var inst_83006 = cljs.core.next(inst_83004);
var state_83020__$1 = (function (){var statearr_83087 = state_83020;
(statearr_83087[(12)] = inst_83006);

(statearr_83087[(11)] = inst_83005__$1);

return statearr_83087;
})();
if(cljs.core.truth_(inst_83005__$1)){
var statearr_83088_83121 = state_83020__$1;
(statearr_83088_83121[(1)] = (4));

} else {
var statearr_83089_83122 = state_83020__$1;
(statearr_83089_83122[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83021 === (3))){
var inst_83018 = (state_83020[(2)]);
var state_83020__$1 = state_83020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83020__$1,inst_83018);
} else {
if((state_val_83021 === (4))){
var inst_83005 = (state_83020[(11)]);
var inst_83008 = fluree.db.time_travel.non_border_t_to_block(db,inst_83005);
var state_83020__$1 = state_83020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83020__$1,(7),inst_83008);
} else {
if((state_val_83021 === (5))){
var inst_82999 = (state_83020[(7)]);
var state_83020__$1 = state_83020;
var statearr_83090_83123 = state_83020__$1;
(statearr_83090_83123[(2)] = inst_82999);

(statearr_83090_83123[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83021 === (6))){
var inst_83016 = (state_83020[(2)]);
var state_83020__$1 = state_83020;
var statearr_83091_83124 = state_83020__$1;
(statearr_83091_83124[(2)] = inst_83016);

(statearr_83091_83124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83021 === (7))){
var inst_82999 = (state_83020[(7)]);
var inst_83006 = (state_83020[(12)]);
var inst_83005 = (state_83020[(11)]);
var inst_83010 = (state_83020[(2)]);
var inst_83011 = fluree.db.util.async.throw_err(inst_83010);
var inst_83012 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_82999,inst_83005,inst_83011);
var inst_82998 = inst_83006;
var inst_82999__$1 = inst_83012;
var state_83020__$1 = (function (){var statearr_83092 = state_83020;
(statearr_83092[(7)] = inst_82999__$1);

(statearr_83092[(8)] = inst_82998);

return statearr_83092;
})();
var statearr_83093_83125 = state_83020__$1;
(statearr_83093_83125[(2)] = null);

(statearr_83093_83125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__17178__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__17178__auto____0 = (function (){
var statearr_83094 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83094[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__17178__auto__);

(statearr_83094[(1)] = (1));

return statearr_83094;
});
var fluree$db$api_js$format_history_resp_$_state_machine__17178__auto____1 = (function (state_83020){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_83020);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e83095){var ex__17181__auto__ = e83095;
var statearr_83096_83126 = state_83020;
(statearr_83096_83126[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_83020[(4)]))){
var statearr_83097_83127 = state_83020;
(statearr_83097_83127[(1)] = cljs.core.first((state_83020[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83128 = state_83020;
state_83020 = G__83128;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__17178__auto__ = function(state_83020){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__17178__auto____1.call(this,state_83020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__17178__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__17178__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_83098 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_83098[(6)] = c__17304__auto____$1);

return statearr_83098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
});
})();
var inst_83024 = cljs.core.async.impl.dispatch.run(inst_83023);
var state_83075__$1 = (function (){var statearr_83099 = state_83075;
(statearr_83099[(14)] = inst_83024);

return statearr_83099;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83075__$1,(6),inst_83022);
} else {
if((state_val_83076 === (11))){
var inst_83067 = (state_83075[(2)]);
var state_83075__$1 = state_83075;
var statearr_83101_83129 = state_83075__$1;
(statearr_83101_83129[(2)] = inst_83067);

(statearr_83101_83129[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83076 === (9))){
var inst_83048 = (state_83075[(9)]);
var inst_83027 = (state_83075[(12)]);
var inst_83041 = (state_83075[(13)]);
var inst_83047 = (state_83075[(8)]);
var inst_83050 = inst_83047.t;
var inst_83051 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83027,inst_83050);
var inst_83052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83053 = [inst_83051,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_83054 = (new cljs.core.PersistentVector(null,2,(5),inst_83052,inst_83053,null));
var inst_83055 = cljs.core.assoc_in(inst_83041,inst_83054,inst_83051);
var inst_83056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83057 = [inst_83051,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_83058 = (new cljs.core.PersistentVector(null,2,(5),inst_83056,inst_83057,null));
var inst_83059 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_83055,inst_83058,cljs.core.conj,inst_83047);
var inst_83060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83061 = [inst_83051,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_83062 = (new cljs.core.PersistentVector(null,2,(5),inst_83060,inst_83061,null));
var inst_83063 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_83059,inst_83062,fluree.db.api_js.min_safe,inst_83050);
var inst_83040 = inst_83048;
var inst_83041__$1 = inst_83063;
var state_83075__$1 = (function (){var statearr_83102 = state_83075;
(statearr_83102[(7)] = inst_83040);

(statearr_83102[(13)] = inst_83041__$1);

return statearr_83102;
})();
var statearr_83103_83130 = state_83075__$1;
(statearr_83103_83130[(2)] = null);

(statearr_83103_83130[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83076 === (5))){
var _ = (function (){var statearr_83104 = state_83075;
(statearr_83104[(4)] = cljs.core.rest((state_83075[(4)])));

return statearr_83104;
})();
var state_83075__$1 = state_83075;
var ex83100 = (state_83075__$1[(2)]);
var statearr_83105_83131 = state_83075__$1;
(statearr_83105_83131[(5)] = ex83100);


if((ex83100 instanceof Error)){
var statearr_83106_83132 = state_83075__$1;
(statearr_83106_83132[(1)] = (4));

(statearr_83106_83132[(5)] = null);

} else {
throw ex83100;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83076 === (10))){
var inst_83041 = (state_83075[(13)]);
var state_83075__$1 = state_83075;
var statearr_83107_83133 = state_83075__$1;
(statearr_83107_83133[(2)] = inst_83041);

(statearr_83107_83133[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83076 === (8))){
var inst_83069 = (state_83075[(2)]);
var inst_83070 = cljs.core.vals(inst_83069);
var _ = (function (){var statearr_83108 = state_83075;
(statearr_83108[(4)] = cljs.core.rest((state_83075[(4)])));

return statearr_83108;
})();
var state_83075__$1 = state_83075;
var statearr_83109_83134 = state_83075__$1;
(statearr_83109_83134[(2)] = inst_83070);

(statearr_83109_83134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__17178__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__17178__auto____0 = (function (){
var statearr_83110 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83110[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__17178__auto__);

(statearr_83110[(1)] = (1));

return statearr_83110;
});
var fluree$db$api_js$format_history_resp_$_state_machine__17178__auto____1 = (function (state_83075){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_83075);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e83111){var ex__17181__auto__ = e83111;
var statearr_83112_83135 = state_83075;
(statearr_83112_83135[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_83075[(4)]))){
var statearr_83113_83136 = state_83075;
(statearr_83113_83136[(1)] = cljs.core.first((state_83075[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83137 = state_83075;
state_83075 = G__83137;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__17178__auto__ = function(state_83075){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__17178__auto____1.call(this,state_83075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__17178__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__17178__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_83114 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_83114[(6)] = c__17304__auto__);

return statearr_83114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_83282){
var state_val_83283 = (state_83282[(1)]);
if((state_val_83283 === (7))){
var inst_83162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83163 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_83164 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_83165 = [inst_83163,inst_83164];
var inst_83166 = (new cljs.core.PersistentVector(null,2,(5),inst_83162,inst_83165,null));
var state_83282__$1 = state_83282;
var statearr_83284_83355 = state_83282__$1;
(statearr_83284_83355[(2)] = inst_83166);

(statearr_83284_83355[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (20))){
var inst_83192 = (state_83282[(7)]);
var state_83282__$1 = state_83282;
var statearr_83285_83356 = state_83282__$1;
(statearr_83285_83356[(2)] = inst_83192);

(statearr_83285_83356[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (27))){
var state_83282__$1 = state_83282;
var statearr_83286_83357 = state_83282__$1;
(statearr_83286_83357[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (1))){
var state_83282__$1 = state_83282;
var statearr_83288_83358 = state_83282__$1;
(statearr_83288_83358[(2)] = null);

(statearr_83288_83358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (24))){
var inst_83191 = (state_83282[(8)]);
var state_83282__$1 = state_83282;
if(cljs.core.truth_(inst_83191)){
var statearr_83289_83359 = state_83282__$1;
(statearr_83289_83359[(1)] = (26));

} else {
var statearr_83290_83360 = state_83282__$1;
(statearr_83290_83360[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (39))){
var inst_83238 = (state_83282[(9)]);
var inst_83237 = (state_83282[(10)]);
var inst_83263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83264 = [inst_83237,inst_83238];
var inst_83265 = (new cljs.core.PersistentVector(null,2,(5),inst_83263,inst_83264,null));
var state_83282__$1 = state_83282;
var statearr_83291_83361 = state_83282__$1;
(statearr_83291_83361[(2)] = inst_83265);

(statearr_83291_83361[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (4))){
var inst_83138 = (state_83282[(2)]);
var inst_83139 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_83138], 0));
var inst_83140 = cljs.core.ex_data(inst_83138);
var inst_83141 = cljs.core.ex_message(inst_83138);
var inst_83142 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_83140,new cljs.core.Keyword(null,"message","message",-406056002),inst_83141);
var state_83282__$1 = (function (){var statearr_83292 = state_83282;
(statearr_83292[(11)] = inst_83139);

return statearr_83292;
})();
var statearr_83293_83362 = state_83282__$1;
(statearr_83293_83362[(2)] = inst_83142);

(statearr_83293_83362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (15))){
var inst_83176 = (state_83282[(12)]);
var inst_83171 = (state_83282[(13)]);
var inst_83185 = (state_83282[(2)]);
var inst_83186 = [inst_83176,inst_83185];
var inst_83187 = (new cljs.core.PersistentVector(null,2,(5),inst_83171,inst_83186,null));
var state_83282__$1 = state_83282;
var statearr_83294_83363 = state_83282__$1;
(statearr_83294_83363[(2)] = inst_83187);

(statearr_83294_83363[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (21))){
var inst_83191 = (state_83282[(8)]);
var state_83282__$1 = state_83282;
var statearr_83295_83364 = state_83282__$1;
(statearr_83295_83364[(2)] = inst_83191);

(statearr_83295_83364[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (31))){
var inst_83232 = (state_83282[(2)]);
var state_83282__$1 = state_83282;
var statearr_83296_83365 = state_83282__$1;
(statearr_83296_83365[(2)] = inst_83232);

(statearr_83296_83365[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (32))){
var inst_83238 = (state_83282[(9)]);
var inst_83241 = cljs.core.pos_int_QMARK_(inst_83238);
var state_83282__$1 = state_83282;
var statearr_83297_83366 = state_83282__$1;
(statearr_83297_83366[(2)] = inst_83241);

(statearr_83297_83366[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (40))){
var inst_83269 = (state_83282[(14)]);
var inst_83193 = (state_83282[(15)]);
var inst_83267 = (state_83282[(2)]);
var inst_83268 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83267,(0),null);
var inst_83269__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83267,(1),null);
var inst_83270 = (inst_83269__$1 > inst_83193);
var state_83282__$1 = (function (){var statearr_83298 = state_83282;
(statearr_83298[(14)] = inst_83269__$1);

(statearr_83298[(16)] = inst_83268);

return statearr_83298;
})();
if(cljs.core.truth_(inst_83270)){
var statearr_83299_83367 = state_83282__$1;
(statearr_83299_83367[(1)] = (41));

} else {
var statearr_83300_83368 = state_83282__$1;
(statearr_83300_83368[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (33))){
var inst_83239 = (state_83282[(17)]);
var state_83282__$1 = state_83282;
var statearr_83301_83369 = state_83282__$1;
(statearr_83301_83369[(2)] = inst_83239);

(statearr_83301_83369[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (13))){
var inst_83177 = (state_83282[(18)]);
var inst_83179 = fluree.db.time_travel.block_to_int_format(db,inst_83177);
var state_83282__$1 = state_83282;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83282__$1,(16),inst_83179);
} else {
if((state_val_83283 === (22))){
var inst_83210 = (state_83282[(2)]);
var state_83282__$1 = state_83282;
if(cljs.core.truth_(inst_83210)){
var statearr_83302_83370 = state_83282__$1;
(statearr_83302_83370[(1)] = (23));

} else {
var statearr_83303_83371 = state_83282__$1;
(statearr_83303_83371[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (36))){
var state_83282__$1 = state_83282;
var statearr_83304_83372 = state_83282__$1;
(statearr_83304_83372[(2)] = null);

(statearr_83304_83372[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (41))){
var inst_83193 = (state_83282[(15)]);
var state_83282__$1 = state_83282;
var statearr_83305_83373 = state_83282__$1;
(statearr_83305_83373[(2)] = inst_83193);

(statearr_83305_83373[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (43))){
var inst_83268 = (state_83282[(16)]);
var inst_83274 = (state_83282[(2)]);
var inst_83275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83276 = [inst_83268,inst_83274];
var inst_83277 = (new cljs.core.PersistentVector(null,2,(5),inst_83275,inst_83276,null));
var _ = (function (){var statearr_83306 = state_83282;
(statearr_83306[(4)] = cljs.core.rest((state_83282[(4)])));

return statearr_83306;
})();
var state_83282__$1 = state_83282;
var statearr_83307_83374 = state_83282__$1;
(statearr_83307_83374[(2)] = inst_83277);

(statearr_83307_83374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (29))){
var inst_83168 = (state_83282[(19)]);
var inst_83223 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_83168], 0));
var inst_83224 = ["Invalid block range provided: ",inst_83223].join('');
var inst_83225 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_83226 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_83227 = cljs.core.PersistentHashMap.fromArrays(inst_83225,inst_83226);
var inst_83228 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83224,inst_83227);
var inst_83229 = (function(){throw inst_83228})();
var state_83282__$1 = state_83282;
var statearr_83308_83375 = state_83282__$1;
(statearr_83308_83375[(2)] = inst_83229);

(statearr_83308_83375[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (6))){
var inst_83160 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_83282__$1 = state_83282;
var statearr_83309_83376 = state_83282__$1;
(statearr_83309_83376[(2)] = inst_83160);

(statearr_83309_83376[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (28))){
var inst_83234 = (state_83282[(2)]);
var state_83282__$1 = state_83282;
var statearr_83310_83377 = state_83282__$1;
(statearr_83310_83377[(2)] = inst_83234);

(statearr_83310_83377[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (25))){
var inst_83237 = (state_83282[(10)]);
var inst_83239 = (state_83282[(17)]);
var inst_83236 = (state_83282[(2)]);
var inst_83237__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83236,(0),null);
var inst_83238 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83236,(1),null);
var inst_83239__$1 = cljs.core.pos_int_QMARK_(inst_83237__$1);
var state_83282__$1 = (function (){var statearr_83311 = state_83282;
(statearr_83311[(9)] = inst_83238);

(statearr_83311[(10)] = inst_83237__$1);

(statearr_83311[(17)] = inst_83239__$1);

return statearr_83311;
})();
if(inst_83239__$1){
var statearr_83312_83378 = state_83282__$1;
(statearr_83312_83378[(1)] = (32));

} else {
var statearr_83313_83379 = state_83282__$1;
(statearr_83313_83379[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (34))){
var inst_83244 = (state_83282[(2)]);
var inst_83245 = cljs.core.not(inst_83244);
var state_83282__$1 = state_83282;
if(inst_83245){
var statearr_83314_83380 = state_83282__$1;
(statearr_83314_83380[(1)] = (35));

} else {
var statearr_83315_83381 = state_83282__$1;
(statearr_83315_83381[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (17))){
var inst_83193 = (state_83282[(15)]);
var inst_83191 = (state_83282[(8)]);
var inst_83196 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_83191], 0));
var inst_83197 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_83193], 0));
var inst_83198 = ["Start block is out of range for this ledger. Start block provided: ",inst_83196,". Database block: ",inst_83197].join('');
var inst_83199 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_83200 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_83201 = cljs.core.PersistentHashMap.fromArrays(inst_83199,inst_83200);
var inst_83202 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83198,inst_83201);
var inst_83203 = (function(){throw inst_83202})();
var state_83282__$1 = state_83282;
var statearr_83316_83382 = state_83282__$1;
(statearr_83316_83382[(2)] = inst_83203);

(statearr_83316_83382[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (3))){
var inst_83280 = (state_83282[(2)]);
var state_83282__$1 = state_83282;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83282__$1,inst_83280);
} else {
if((state_val_83283 === (12))){
var inst_83177 = (state_83282[(18)]);
var inst_83168 = (state_83282[(19)]);
var inst_83175 = (state_83282[(2)]);
var inst_83176 = fluree.db.util.async.throw_err(inst_83175);
var inst_83177__$1 = cljs.core.second(inst_83168);
var state_83282__$1 = (function (){var statearr_83317 = state_83282;
(statearr_83317[(18)] = inst_83177__$1);

(statearr_83317[(12)] = inst_83176);

return statearr_83317;
})();
if(cljs.core.truth_(inst_83177__$1)){
var statearr_83318_83383 = state_83282__$1;
(statearr_83318_83383[(1)] = (13));

} else {
var statearr_83319_83384 = state_83282__$1;
(statearr_83319_83384[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (2))){
var _ = (function (){var statearr_83320 = state_83282;
(statearr_83320[(4)] = cljs.core.cons((5),(state_83282[(4)])));

return statearr_83320;
})();
var inst_83157 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_83158 = cljs.core.sequential_QMARK_(inst_83157);
var state_83282__$1 = state_83282;
if(inst_83158){
var statearr_83321_83385 = state_83282__$1;
(statearr_83321_83385[(1)] = (6));

} else {
var statearr_83322_83386 = state_83282__$1;
(statearr_83322_83386[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (23))){
var inst_83192 = (state_83282[(7)]);
var inst_83191 = (state_83282[(8)]);
var inst_83212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83213 = [inst_83191,inst_83192];
var inst_83214 = (new cljs.core.PersistentVector(null,2,(5),inst_83212,inst_83213,null));
var state_83282__$1 = state_83282;
var statearr_83323_83387 = state_83282__$1;
(statearr_83323_83387[(2)] = inst_83214);

(statearr_83323_83387[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (35))){
var inst_83168 = (state_83282[(19)]);
var inst_83247 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_83168], 0));
var inst_83248 = ["Invalid block range provided: ",inst_83247].join('');
var inst_83249 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_83250 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_83251 = cljs.core.PersistentHashMap.fromArrays(inst_83249,inst_83250);
var inst_83252 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83248,inst_83251);
var inst_83253 = (function(){throw inst_83252})();
var state_83282__$1 = state_83282;
var statearr_83324_83388 = state_83282__$1;
(statearr_83324_83388[(2)] = inst_83253);

(statearr_83324_83388[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (19))){
var inst_83191 = (state_83282[(8)]);
var inst_83206 = (state_83282[(2)]);
var state_83282__$1 = (function (){var statearr_83325 = state_83282;
(statearr_83325[(20)] = inst_83206);

return statearr_83325;
})();
if(cljs.core.truth_(inst_83191)){
var statearr_83326_83389 = state_83282__$1;
(statearr_83326_83389[(1)] = (20));

} else {
var statearr_83327_83390 = state_83282__$1;
(statearr_83327_83390[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (11))){
var inst_83193 = (state_83282[(15)]);
var inst_83191 = (state_83282[(8)]);
var inst_83190 = (state_83282[(2)]);
var inst_83191__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83190,(0),null);
var inst_83192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83190,(1),null);
var inst_83193__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_83194 = (inst_83191__$1 > inst_83193__$1);
var state_83282__$1 = (function (){var statearr_83329 = state_83282;
(statearr_83329[(7)] = inst_83192);

(statearr_83329[(15)] = inst_83193__$1);

(statearr_83329[(8)] = inst_83191__$1);

return statearr_83329;
})();
if(cljs.core.truth_(inst_83194)){
var statearr_83330_83391 = state_83282__$1;
(statearr_83330_83391[(1)] = (17));

} else {
var statearr_83331_83392 = state_83282__$1;
(statearr_83331_83392[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (9))){
var inst_83168 = (state_83282[(19)]);
var inst_83171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83172 = cljs.core.first(inst_83168);
var inst_83173 = fluree.db.time_travel.block_to_int_format(db,inst_83172);
var state_83282__$1 = (function (){var statearr_83332 = state_83282;
(statearr_83332[(13)] = inst_83171);

return statearr_83332;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83282__$1,(12),inst_83173);
} else {
if((state_val_83283 === (5))){
var _ = (function (){var statearr_83333 = state_83282;
(statearr_83333[(4)] = cljs.core.rest((state_83282[(4)])));

return statearr_83333;
})();
var state_83282__$1 = state_83282;
var ex83328 = (state_83282__$1[(2)]);
var statearr_83334_83393 = state_83282__$1;
(statearr_83334_83393[(5)] = ex83328);


var statearr_83335_83394 = state_83282__$1;
(statearr_83335_83394[(1)] = (4));

(statearr_83335_83394[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (14))){
var state_83282__$1 = state_83282;
var statearr_83336_83395 = state_83282__$1;
(statearr_83336_83395[(2)] = null);

(statearr_83336_83395[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (26))){
var inst_83191 = (state_83282[(8)]);
var inst_83217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83218 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_83219 = [inst_83191,inst_83218];
var inst_83220 = (new cljs.core.PersistentVector(null,2,(5),inst_83217,inst_83219,null));
var state_83282__$1 = state_83282;
var statearr_83337_83396 = state_83282__$1;
(statearr_83337_83396[(2)] = inst_83220);

(statearr_83337_83396[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (16))){
var inst_83181 = (state_83282[(2)]);
var inst_83182 = fluree.db.util.async.throw_err(inst_83181);
var state_83282__$1 = state_83282;
var statearr_83338_83397 = state_83282__$1;
(statearr_83338_83397[(2)] = inst_83182);

(statearr_83338_83397[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (38))){
var inst_83238 = (state_83282[(9)]);
var inst_83237 = (state_83282[(10)]);
var inst_83259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83260 = [inst_83238,inst_83237];
var inst_83261 = (new cljs.core.PersistentVector(null,2,(5),inst_83259,inst_83260,null));
var state_83282__$1 = state_83282;
var statearr_83339_83398 = state_83282__$1;
(statearr_83339_83398[(2)] = inst_83261);

(statearr_83339_83398[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (30))){
var state_83282__$1 = state_83282;
var statearr_83340_83399 = state_83282__$1;
(statearr_83340_83399[(2)] = null);

(statearr_83340_83399[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (10))){
var inst_83168 = (state_83282[(19)]);
var state_83282__$1 = state_83282;
var statearr_83341_83400 = state_83282__$1;
(statearr_83341_83400[(2)] = inst_83168);

(statearr_83341_83400[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (18))){
var state_83282__$1 = state_83282;
var statearr_83342_83401 = state_83282__$1;
(statearr_83342_83401[(2)] = null);

(statearr_83342_83401[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (42))){
var inst_83269 = (state_83282[(14)]);
var state_83282__$1 = state_83282;
var statearr_83343_83402 = state_83282__$1;
(statearr_83343_83402[(2)] = inst_83269);

(statearr_83343_83402[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (37))){
var inst_83238 = (state_83282[(9)]);
var inst_83237 = (state_83282[(10)]);
var inst_83256 = (state_83282[(2)]);
var inst_83257 = (inst_83238 < inst_83237);
var state_83282__$1 = (function (){var statearr_83344 = state_83282;
(statearr_83344[(21)] = inst_83256);

return statearr_83344;
})();
if(cljs.core.truth_(inst_83257)){
var statearr_83345_83403 = state_83282__$1;
(statearr_83345_83403[(1)] = (38));

} else {
var statearr_83346_83404 = state_83282__$1;
(statearr_83346_83404[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83283 === (8))){
var inst_83168 = (state_83282[(19)]);
var inst_83168__$1 = (state_83282[(2)]);
var inst_83169 = cljs.core.some(cljs.core.string_QMARK_,inst_83168__$1);
var state_83282__$1 = (function (){var statearr_83347 = state_83282;
(statearr_83347[(19)] = inst_83168__$1);

return statearr_83347;
})();
if(cljs.core.truth_(inst_83169)){
var statearr_83348_83405 = state_83282__$1;
(statearr_83348_83405[(1)] = (9));

} else {
var statearr_83349_83406 = state_83282__$1;
(statearr_83349_83406[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__17178__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__17178__auto____0 = (function (){
var statearr_83350 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83350[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__17178__auto__);

(statearr_83350[(1)] = (1));

return statearr_83350;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__17178__auto____1 = (function (state_83282){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_83282);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e83351){var ex__17181__auto__ = e83351;
var statearr_83352_83407 = state_83282;
(statearr_83352_83407[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_83282[(4)]))){
var statearr_83353_83408 = state_83282;
(statearr_83353_83408[(1)] = cljs.core.first((state_83282[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83409 = state_83282;
state_83282 = G__83409;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__17178__auto__ = function(state_83282){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__17178__auto____1.call(this,state_83282);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__17178__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__17178__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_83354 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_83354[(6)] = c__17304__auto__);

return statearr_83354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__83411 = arguments.length;
switch (G__83411) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_83502){
var state_val_83503 = (state_83502[(1)]);
if((state_val_83503 === (7))){
var inst_83434 = (state_83502[(7)]);
var inst_83437 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_83434);
var state_83502__$1 = state_83502;
var statearr_83504_83555 = state_83502__$1;
(statearr_83504_83555[(2)] = inst_83437);

(statearr_83504_83555[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (20))){
var inst_83473 = (state_83502[(8)]);
var inst_83476 = fluree.db.api_js.format_block_resp_pretty(db,inst_83473);
var state_83502__$1 = state_83502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83502__$1,(23),inst_83476);
} else {
if((state_val_83503 === (27))){
var inst_83482 = (state_83502[(9)]);
var inst_83488 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_83482);
var state_83502__$1 = state_83502;
var statearr_83505_83556 = state_83502__$1;
(statearr_83505_83556[(2)] = inst_83488);

(statearr_83505_83556[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (1))){
var state_83502__$1 = state_83502;
var statearr_83506_83557 = state_83502__$1;
(statearr_83506_83557[(2)] = null);

(statearr_83506_83557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (24))){
var inst_83482 = (state_83502[(9)]);
var inst_83485 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_83486 = cljs.core.sequential_QMARK_(inst_83482);
var state_83502__$1 = (function (){var statearr_83507 = state_83502;
(statearr_83507[(10)] = inst_83485);

return statearr_83507;
})();
if(inst_83486){
var statearr_83508_83558 = state_83502__$1;
(statearr_83508_83558[(1)] = (27));

} else {
var statearr_83509_83559 = state_83502__$1;
(statearr_83509_83559[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (4))){
var inst_83412 = (state_83502[(2)]);
var inst_83413 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_83412], 0));
var inst_83414 = cljs.core.ex_data(inst_83412);
var inst_83415 = cljs.core.ex_message(inst_83412);
var inst_83416 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_83414,new cljs.core.Keyword(null,"message","message",-406056002),inst_83415);
var state_83502__$1 = (function (){var statearr_83510 = state_83502;
(statearr_83510[(11)] = inst_83413);

return statearr_83510;
})();
var statearr_83511_83560 = state_83502__$1;
(statearr_83511_83560[(2)] = inst_83416);

(statearr_83511_83560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (15))){
var inst_83434 = (state_83502[(7)]);
var inst_83447 = (state_83502[(2)]);
var inst_83448 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83447,inst_83434);
var inst_83449 = (function(){throw inst_83448})();
var state_83502__$1 = state_83502;
var statearr_83512_83561 = state_83502__$1;
(statearr_83512_83561[(2)] = inst_83449);

(statearr_83512_83561[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (21))){
var inst_83473 = (state_83502[(8)]);
var state_83502__$1 = state_83502;
var statearr_83513_83562 = state_83502__$1;
(statearr_83513_83562[(2)] = inst_83473);

(statearr_83513_83562[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (13))){
var inst_83442 = (state_83502[(12)]);
var state_83502__$1 = state_83502;
var statearr_83514_83563 = state_83502__$1;
(statearr_83514_83563[(2)] = inst_83442);

(statearr_83514_83563[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (22))){
var inst_83482 = (state_83502[(2)]);
var inst_83483 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_83502__$1 = (function (){var statearr_83515 = state_83502;
(statearr_83515[(9)] = inst_83482);

return statearr_83515;
})();
if(cljs.core.truth_(inst_83483)){
var statearr_83516_83564 = state_83502__$1;
(statearr_83516_83564[(1)] = (24));

} else {
var statearr_83517_83565 = state_83502__$1;
(statearr_83517_83565[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (29))){
var inst_83485 = (state_83502[(10)]);
var inst_83426 = (state_83502[(13)]);
var inst_83491 = (state_83502[(2)]);
var inst_83492 = fluree.db.util.core.response_time_formatted(inst_83426);
var inst_83493 = [(200),inst_83491,(100),inst_83492];
var inst_83494 = cljs.core.PersistentHashMap.fromArrays(inst_83485,inst_83493);
var state_83502__$1 = state_83502;
var statearr_83518_83566 = state_83502__$1;
(statearr_83518_83566[(2)] = inst_83494);

(statearr_83518_83566[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (6))){
var inst_83435 = (state_83502[(14)]);
var inst_83434 = (state_83502[(7)]);
var inst_83433 = (state_83502[(2)]);
var inst_83434__$1 = fluree.db.util.async.throw_err(inst_83433);
var inst_83435__$1 = cljs.core.map_QMARK_(inst_83434__$1);
var state_83502__$1 = (function (){var statearr_83519 = state_83502;
(statearr_83519[(14)] = inst_83435__$1);

(statearr_83519[(7)] = inst_83434__$1);

return statearr_83519;
})();
if(inst_83435__$1){
var statearr_83520_83567 = state_83502__$1;
(statearr_83520_83567[(1)] = (7));

} else {
var statearr_83521_83568 = state_83502__$1;
(statearr_83521_83568[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (28))){
var inst_83482 = (state_83502[(9)]);
var state_83502__$1 = state_83502;
var statearr_83522_83569 = state_83502__$1;
(statearr_83522_83569[(2)] = inst_83482);

(statearr_83522_83569[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (25))){
var inst_83482 = (state_83502[(9)]);
var state_83502__$1 = state_83502;
var statearr_83523_83570 = state_83502__$1;
(statearr_83523_83570[(2)] = inst_83482);

(statearr_83523_83570[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (17))){
var inst_83465 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_83466 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_83465].join('');
var inst_83467 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_83468 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_83469 = cljs.core.PersistentHashMap.fromArrays(inst_83467,inst_83468);
var inst_83470 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83466,inst_83469);
var inst_83471 = (function(){throw inst_83470})();
var state_83502__$1 = state_83502;
var statearr_83524_83571 = state_83502__$1;
(statearr_83524_83571[(2)] = inst_83471);

(statearr_83524_83571[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (3))){
var inst_83500 = (state_83502[(2)]);
var state_83502__$1 = state_83502;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83502__$1,inst_83500);
} else {
if((state_val_83503 === (12))){
var inst_83434 = (state_83502[(7)]);
var inst_83452 = (state_83502[(2)]);
var inst_83453 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83434,(0),null);
var inst_83454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83434,(1),null);
var inst_83455 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_83456 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_83457 = cljs.core.keys(inst_83456);
var inst_83458 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_83455,inst_83457);
var state_83502__$1 = (function (){var statearr_83525 = state_83502;
(statearr_83525[(15)] = inst_83454);

(statearr_83525[(16)] = inst_83453);

(statearr_83525[(17)] = inst_83452);

return statearr_83525;
})();
if(inst_83458){
var statearr_83526_83572 = state_83502__$1;
(statearr_83526_83572[(1)] = (16));

} else {
var statearr_83527_83573 = state_83502__$1;
(statearr_83527_83573[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (2))){
var _ = (function (){var statearr_83528 = state_83502;
(statearr_83528[(4)] = cljs.core.cons((5),(state_83502[(4)])));

return statearr_83528;
})();
var inst_83426 = fluree.db.util.core.current_time_millis();
var inst_83427 = db;
var inst_83428 = cljs.core.__destructure_map(inst_83427);
var inst_83429 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83428,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_83430 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83428,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_83431 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_83502__$1 = (function (){var statearr_83529 = state_83502;
(statearr_83529[(18)] = inst_83430);

(statearr_83529[(19)] = inst_83429);

(statearr_83529[(13)] = inst_83426);

return statearr_83529;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83502__$1,(6),inst_83431);
} else {
if((state_val_83503 === (23))){
var inst_83478 = (state_83502[(2)]);
var inst_83479 = fluree.db.util.async.throw_err(inst_83478);
var state_83502__$1 = state_83502;
var statearr_83530_83574 = state_83502__$1;
(statearr_83530_83574[(2)] = inst_83479);

(statearr_83530_83574[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (19))){
var inst_83462 = (state_83502[(2)]);
var inst_83463 = fluree.db.util.async.throw_err(inst_83462);
var state_83502__$1 = state_83502;
var statearr_83531_83575 = state_83502__$1;
(statearr_83531_83575[(2)] = inst_83463);

(statearr_83531_83575[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (11))){
var state_83502__$1 = state_83502;
var statearr_83533_83576 = state_83502__$1;
(statearr_83533_83576[(2)] = null);

(statearr_83533_83576[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (9))){
var inst_83440 = (state_83502[(2)]);
var state_83502__$1 = state_83502;
if(cljs.core.truth_(inst_83440)){
var statearr_83534_83577 = state_83502__$1;
(statearr_83534_83577[(1)] = (10));

} else {
var statearr_83535_83578 = state_83502__$1;
(statearr_83535_83578[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (5))){
var _ = (function (){var statearr_83536 = state_83502;
(statearr_83536[(4)] = cljs.core.rest((state_83502[(4)])));

return statearr_83536;
})();
var state_83502__$1 = state_83502;
var ex83532 = (state_83502__$1[(2)]);
var statearr_83537_83579 = state_83502__$1;
(statearr_83537_83579[(5)] = ex83532);


var statearr_83538_83580 = state_83502__$1;
(statearr_83538_83580[(1)] = (4));

(statearr_83538_83580[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (14))){
var inst_83430 = (state_83502[(18)]);
var inst_83429 = (state_83502[(19)]);
var inst_83445 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83429),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83430)].join('');
var state_83502__$1 = state_83502;
var statearr_83539_83581 = state_83502__$1;
(statearr_83539_83581[(2)] = inst_83445);

(statearr_83539_83581[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (26))){
var inst_83497 = (state_83502[(2)]);
var _ = (function (){var statearr_83540 = state_83502;
(statearr_83540[(4)] = cljs.core.rest((state_83502[(4)])));

return statearr_83540;
})();
var state_83502__$1 = state_83502;
var statearr_83541_83582 = state_83502__$1;
(statearr_83541_83582[(2)] = inst_83497);

(statearr_83541_83582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (16))){
var inst_83454 = (state_83502[(15)]);
var inst_83453 = (state_83502[(16)]);
var inst_83460 = fluree.db.query.block.block_range(db,inst_83453,inst_83454,opts);
var state_83502__$1 = state_83502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83502__$1,(19),inst_83460);
} else {
if((state_val_83503 === (10))){
var inst_83442 = (state_83502[(12)]);
var inst_83434 = (state_83502[(7)]);
var inst_83442__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_83434);
var state_83502__$1 = (function (){var statearr_83542 = state_83502;
(statearr_83542[(12)] = inst_83442__$1);

return statearr_83542;
})();
if(cljs.core.truth_(inst_83442__$1)){
var statearr_83543_83583 = state_83502__$1;
(statearr_83543_83583[(1)] = (13));

} else {
var statearr_83544_83584 = state_83502__$1;
(statearr_83544_83584[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (18))){
var inst_83473 = (state_83502[(2)]);
var inst_83474 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_83502__$1 = (function (){var statearr_83545 = state_83502;
(statearr_83545[(8)] = inst_83473);

return statearr_83545;
})();
if(cljs.core.truth_(inst_83474)){
var statearr_83546_83585 = state_83502__$1;
(statearr_83546_83585[(1)] = (20));

} else {
var statearr_83547_83586 = state_83502__$1;
(statearr_83547_83586[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83503 === (8))){
var inst_83435 = (state_83502[(14)]);
var state_83502__$1 = state_83502;
var statearr_83548_83587 = state_83502__$1;
(statearr_83548_83587[(2)] = inst_83435);

(statearr_83548_83587[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__17178__auto__ = null;
var fluree$db$api_js$state_machine__17178__auto____0 = (function (){
var statearr_83549 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83549[(0)] = fluree$db$api_js$state_machine__17178__auto__);

(statearr_83549[(1)] = (1));

return statearr_83549;
});
var fluree$db$api_js$state_machine__17178__auto____1 = (function (state_83502){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_83502);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e83550){var ex__17181__auto__ = e83550;
var statearr_83551_83588 = state_83502;
(statearr_83551_83588[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_83502[(4)]))){
var statearr_83552_83589 = state_83502;
(statearr_83552_83589[(1)] = cljs.core.first((state_83502[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83590 = state_83502;
state_83502 = G__83590;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__17178__auto__ = function(state_83502){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__17178__auto____1.call(this,state_83502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__17178__auto____0;
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__17178__auto____1;
return fluree$db$api_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_83553 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_83553[(6)] = c__17304__auto__);

return statearr_83553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__83592 = arguments.length;
switch (G__83592) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_83787){
var state_val_83788 = (state_83787[(1)]);
if((state_val_83788 === (62))){
var inst_83785 = (state_83787[(2)]);
var state_83787__$1 = state_83787;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83787__$1,inst_83785);
} else {
if((state_val_83788 === (7))){
var inst_83613 = (state_83787[(7)]);
var inst_83623 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_83613);
var state_83787__$1 = state_83787;
var statearr_83789_83880 = state_83787__$1;
(statearr_83789_83880[(2)] = inst_83623);

(statearr_83789_83880[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (59))){
var inst_83773 = (state_83787[(2)]);
var inst_83774 = fluree.db.util.async.throw_err(inst_83773);
var state_83787__$1 = state_83787;
var statearr_83790_83881 = state_83787__$1;
(statearr_83790_83881[(2)] = inst_83774);

(statearr_83790_83881[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (20))){
var inst_83689 = (state_83787[(8)]);
var inst_83681 = (state_83787[(9)]);
var inst_83681__$1 = (state_83787[(2)]);
var inst_83682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83683 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83681__$1,(0));
var inst_83684 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83681__$1,(1));
var inst_83685 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83681__$1,(2));
var inst_83686 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83681__$1,(3));
var inst_83687 = [inst_83683,inst_83684,inst_83685,inst_83686];
var inst_83688 = (new cljs.core.PersistentVector(null,4,(5),inst_83682,inst_83687,null));
var inst_83689__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83688,(0),null);
var inst_83690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83688,(1),null);
var inst_83691 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83688,(2),null);
var inst_83692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83688,(3),null);
var inst_83693 = (inst_83689__$1 == null);
var inst_83694 = cljs.core.not(inst_83693);
var state_83787__$1 = (function (){var statearr_83791 = state_83787;
(statearr_83791[(8)] = inst_83689__$1);

(statearr_83791[(9)] = inst_83681__$1);

(statearr_83791[(10)] = inst_83691);

(statearr_83791[(11)] = inst_83692);

(statearr_83791[(12)] = inst_83690);

return statearr_83791;
})();
if(inst_83694){
var statearr_83792_83882 = state_83787__$1;
(statearr_83792_83882[(1)] = (30));

} else {
var statearr_83793_83883 = state_83787__$1;
(statearr_83793_83883[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (58))){
var inst_83621 = (state_83787[(13)]);
var inst_83777 = (state_83787[(2)]);
var state_83787__$1 = (function (){var statearr_83794 = state_83787;
(statearr_83794[(14)] = inst_83777);

return statearr_83794;
})();
if(cljs.core.truth_(inst_83621)){
var statearr_83795_83884 = state_83787__$1;
(statearr_83795_83884[(1)] = (60));

} else {
var statearr_83796_83885 = state_83787__$1;
(statearr_83796_83885[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (60))){
var inst_83777 = (state_83787[(14)]);
var inst_83765 = (state_83787[(15)]);
var inst_83779 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_83780 = cljs.core.count(inst_83765);
var inst_83781 = [inst_83777,inst_83780,(200)];
var inst_83782 = cljs.core.PersistentHashMap.fromArrays(inst_83779,inst_83781);
var state_83787__$1 = state_83787;
var statearr_83797_83886 = state_83787__$1;
(statearr_83797_83886[(2)] = inst_83782);

(statearr_83797_83886[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (27))){
var inst_83600 = (state_83787[(16)]);
var inst_83669 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83600)].join('');
var inst_83670 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_83671 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_83672 = cljs.core.PersistentHashMap.fromArrays(inst_83670,inst_83671);
var inst_83673 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83669,inst_83672);
var inst_83674 = (function(){throw inst_83673})();
var state_83787__$1 = state_83787;
var statearr_83798_83887 = state_83787__$1;
(statearr_83798_83887[(2)] = inst_83674);

(statearr_83798_83887[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (1))){
var inst_83597 = query_map;
var inst_83598 = cljs.core.__destructure_map(inst_83597);
var inst_83599 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83598,new cljs.core.Keyword(null,"block","block",664686210));
var inst_83600 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83598,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_83601 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83598,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_83787__$1 = (function (){var statearr_83799 = state_83787;
(statearr_83799[(16)] = inst_83600);

(statearr_83799[(17)] = inst_83599);

(statearr_83799[(18)] = inst_83601);

return statearr_83799;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83787__$1,(2),sources);
} else {
if((state_val_83788 === (24))){
var inst_83600 = (state_83787[(16)]);
var inst_83658 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83600)].join('');
var inst_83659 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_83660 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_83661 = cljs.core.PersistentHashMap.fromArrays(inst_83659,inst_83660);
var inst_83662 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83658,inst_83661);
var inst_83663 = (function(){throw inst_83662})();
var state_83787__$1 = state_83787;
var statearr_83800_83888 = state_83787__$1;
(statearr_83800_83888[(2)] = inst_83663);

(statearr_83800_83888[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (55))){
var inst_83601 = (state_83787[(18)]);
var inst_83768 = (state_83787[(2)]);
var inst_83769 = fluree.db.util.async.throw_err(inst_83768);
var state_83787__$1 = (function (){var statearr_83801 = state_83787;
(statearr_83801[(19)] = inst_83769);

return statearr_83801;
})();
if(cljs.core.truth_(inst_83601)){
var statearr_83802_83889 = state_83787__$1;
(statearr_83802_83889[(1)] = (56));

} else {
var statearr_83803_83890 = state_83787__$1;
(statearr_83803_83890[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (39))){
var inst_83689 = (state_83787[(8)]);
var inst_83691 = (state_83787[(10)]);
var inst_83692 = (state_83787[(11)]);
var inst_83690 = (state_83787[(12)]);
var inst_83713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83715 = [inst_83690,inst_83689,inst_83691,inst_83692];
var inst_83716 = (new cljs.core.PersistentVector(null,4,(5),inst_83714,inst_83715,null));
var inst_83717 = [inst_83716,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_83718 = (new cljs.core.PersistentVector(null,2,(5),inst_83713,inst_83717,null));
var state_83787__$1 = state_83787;
var statearr_83804_83891 = state_83787__$1;
(statearr_83804_83891[(2)] = inst_83718);

(statearr_83804_83891[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (46))){
var inst_83723 = (state_83787[(20)]);
var state_83787__$1 = state_83787;
var statearr_83805_83892 = state_83787__$1;
(statearr_83805_83892[(2)] = inst_83723);

(statearr_83805_83892[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (4))){
var state_83787__$1 = state_83787;
var statearr_83806_83893 = state_83787__$1;
(statearr_83806_83893[(2)] = null);

(statearr_83806_83893[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (54))){
var inst_83604 = (state_83787[(21)]);
var inst_83765 = (state_83787[(15)]);
var inst_83764 = (state_83787[(2)]);
var inst_83765__$1 = fluree.db.util.async.throw_err(inst_83764);
var inst_83766 = fluree.db.api_js.format_history_resp(inst_83604,inst_83765__$1);
var state_83787__$1 = (function (){var statearr_83807 = state_83787;
(statearr_83807[(15)] = inst_83765__$1);

return statearr_83807;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83787__$1,(55),inst_83766);
} else {
if((state_val_83788 === (15))){
var inst_83604 = (state_83787[(21)]);
var inst_83645 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_83604);
var state_83787__$1 = state_83787;
var statearr_83808_83894 = state_83787__$1;
(statearr_83808_83894[(2)] = inst_83645);

(statearr_83808_83894[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (48))){
var inst_83689 = (state_83787[(8)]);
var inst_83691 = (state_83787[(10)]);
var inst_83692 = (state_83787[(11)]);
var inst_83690 = (state_83787[(12)]);
var inst_83734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83736 = [inst_83690,inst_83691,inst_83689,inst_83692];
var inst_83737 = (new cljs.core.PersistentVector(null,4,(5),inst_83735,inst_83736,null));
var inst_83738 = [inst_83737,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_83739 = (new cljs.core.PersistentVector(null,2,(5),inst_83734,inst_83738,null));
var state_83787__$1 = state_83787;
var statearr_83809_83895 = state_83787__$1;
(statearr_83809_83895[(2)] = inst_83739);

(statearr_83809_83895[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (50))){
var inst_83752 = (state_83787[(2)]);
var state_83787__$1 = state_83787;
var statearr_83810_83896 = state_83787__$1;
(statearr_83810_83896[(2)] = inst_83752);

(statearr_83810_83896[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (21))){
var inst_83600 = (state_83787[(16)]);
var inst_83656 = cljs.core.empty_QMARK_(inst_83600);
var state_83787__$1 = state_83787;
if(inst_83656){
var statearr_83811_83897 = state_83787__$1;
(statearr_83811_83897[(1)] = (24));

} else {
var statearr_83812_83898 = state_83787__$1;
(statearr_83812_83898[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (31))){
var inst_83689 = (state_83787[(8)]);
var inst_83700 = (state_83787[(22)]);
var inst_83700__$1 = (inst_83689 == null);
var state_83787__$1 = (function (){var statearr_83813 = state_83787;
(statearr_83813[(22)] = inst_83700__$1);

return statearr_83813;
})();
if(cljs.core.truth_(inst_83700__$1)){
var statearr_83814_83899 = state_83787__$1;
(statearr_83814_83899[(1)] = (33));

} else {
var statearr_83815_83900 = state_83787__$1;
(statearr_83815_83900[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (32))){
var inst_83647 = (state_83787[(23)]);
var inst_83604 = (state_83787[(21)]);
var inst_83637 = (state_83787[(24)]);
var inst_83756 = (state_83787[(2)]);
var inst_83757 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83756,(0),null);
var inst_83758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83756,(1),null);
var inst_83759 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_83760 = [inst_83637,inst_83647];
var inst_83761 = cljs.core.PersistentHashMap.fromArrays(inst_83759,inst_83760);
var inst_83762 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_83604,inst_83758,cljs.core._EQ_,inst_83757,inst_83761);
var state_83787__$1 = state_83787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83787__$1,(54),inst_83762);
} else {
if((state_val_83788 === (40))){
var inst_83689 = (state_83787[(8)]);
var inst_83720 = (state_83787[(25)]);
var inst_83720__$1 = (inst_83689 == null);
var state_83787__$1 = (function (){var statearr_83816 = state_83787;
(statearr_83816[(25)] = inst_83720__$1);

return statearr_83816;
})();
if(cljs.core.truth_(inst_83720__$1)){
var statearr_83817_83901 = state_83787__$1;
(statearr_83817_83901[(1)] = (42));

} else {
var statearr_83818_83902 = state_83787__$1;
(statearr_83818_83902[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (56))){
var inst_83604 = (state_83787[(21)]);
var inst_83769 = (state_83787[(19)]);
var inst_83771 = fluree.db.api_js.format_block_resp_pretty(inst_83604,inst_83769);
var state_83787__$1 = state_83787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83787__$1,(59),inst_83771);
} else {
if((state_val_83788 === (33))){
var inst_83703 = (state_83787[(26)]);
var inst_83690 = (state_83787[(12)]);
var inst_83702 = (inst_83690 == null);
var inst_83703__$1 = cljs.core.not(inst_83702);
var state_83787__$1 = (function (){var statearr_83819 = state_83787;
(statearr_83819[(26)] = inst_83703__$1);

return statearr_83819;
})();
if(inst_83703__$1){
var statearr_83820_83903 = state_83787__$1;
(statearr_83820_83903[(1)] = (36));

} else {
var statearr_83821_83904 = state_83787__$1;
(statearr_83821_83904[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (13))){
var inst_83631 = (state_83787[(2)]);
var inst_83632 = fluree.db.util.async.throw_err(inst_83631);
var inst_83633 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_83632);
var inst_83634 = (inst_83633 - (1));
var state_83787__$1 = state_83787;
var statearr_83822_83905 = state_83787__$1;
(statearr_83822_83905[(2)] = inst_83634);

(statearr_83822_83905[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (22))){
var state_83787__$1 = state_83787;
var statearr_83823_83906 = state_83787__$1;
(statearr_83823_83906[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (36))){
var inst_83691 = (state_83787[(10)]);
var inst_83705 = (inst_83691 == null);
var state_83787__$1 = state_83787;
var statearr_83825_83907 = state_83787__$1;
(statearr_83825_83907[(2)] = inst_83705);

(statearr_83825_83907[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (41))){
var inst_83754 = (state_83787[(2)]);
var state_83787__$1 = state_83787;
var statearr_83826_83908 = state_83787__$1;
(statearr_83826_83908[(2)] = inst_83754);

(statearr_83826_83908[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (43))){
var inst_83720 = (state_83787[(25)]);
var state_83787__$1 = state_83787;
var statearr_83827_83909 = state_83787__$1;
(statearr_83827_83909[(2)] = inst_83720);

(statearr_83827_83909[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (61))){
var inst_83777 = (state_83787[(14)]);
var state_83787__$1 = state_83787;
var statearr_83828_83910 = state_83787__$1;
(statearr_83828_83910[(2)] = inst_83777);

(statearr_83828_83910[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (29))){
var inst_83677 = (state_83787[(2)]);
var state_83787__$1 = state_83787;
var statearr_83829_83911 = state_83787__$1;
(statearr_83829_83911[(2)] = inst_83677);

(statearr_83829_83911[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (44))){
var inst_83732 = (state_83787[(2)]);
var state_83787__$1 = state_83787;
if(cljs.core.truth_(inst_83732)){
var statearr_83830_83912 = state_83787__$1;
(statearr_83830_83912[(1)] = (48));

} else {
var statearr_83831_83913 = state_83787__$1;
(statearr_83831_83913[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (6))){
var inst_83608 = (state_83787[(2)]);
var inst_83609 = fluree.db.util.async.throw_err(inst_83608);
var state_83787__$1 = state_83787;
var statearr_83832_83914 = state_83787__$1;
(statearr_83832_83914[(2)] = inst_83609);

(statearr_83832_83914[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (28))){
var state_83787__$1 = state_83787;
var statearr_83833_83915 = state_83787__$1;
(statearr_83833_83915[(2)] = null);

(statearr_83833_83915[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (51))){
var inst_83600 = (state_83787[(16)]);
var inst_83742 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83600)].join('');
var inst_83743 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_83744 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_83745 = cljs.core.PersistentHashMap.fromArrays(inst_83743,inst_83744);
var inst_83746 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83742,inst_83745);
var inst_83747 = (function(){throw inst_83746})();
var state_83787__$1 = state_83787;
var statearr_83834_83916 = state_83787__$1;
(statearr_83834_83916[(2)] = inst_83747);

(statearr_83834_83916[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (25))){
var inst_83600 = (state_83787[(16)]);
var state_83787__$1 = state_83787;
var statearr_83835_83917 = state_83787__$1;
(statearr_83835_83917[(2)] = inst_83600);

(statearr_83835_83917[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (34))){
var inst_83700 = (state_83787[(22)]);
var state_83787__$1 = state_83787;
var statearr_83836_83918 = state_83787__$1;
(statearr_83836_83918[(2)] = inst_83700);

(statearr_83836_83918[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (17))){
var inst_83641 = (state_83787[(2)]);
var inst_83642 = fluree.db.util.async.throw_err(inst_83641);
var inst_83643 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_83642);
var state_83787__$1 = state_83787;
var statearr_83837_83919 = state_83787__$1;
(statearr_83837_83919[(2)] = inst_83643);

(statearr_83837_83919[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (3))){
var inst_83604 = (state_83787[(21)]);
var inst_83606 = fluree.db.api_js.resolve_block_range(inst_83604,query_map);
var state_83787__$1 = state_83787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83787__$1,(6),inst_83606);
} else {
if((state_val_83788 === (12))){
var inst_83614 = (state_83787[(27)]);
var inst_83637 = (state_83787[(2)]);
var state_83787__$1 = (function (){var statearr_83838 = state_83787;
(statearr_83838[(24)] = inst_83637);

return statearr_83838;
})();
if(cljs.core.truth_(inst_83614)){
var statearr_83839_83920 = state_83787__$1;
(statearr_83839_83920[(1)] = (14));

} else {
var statearr_83840_83921 = state_83787__$1;
(statearr_83840_83921[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (2))){
var inst_83599 = (state_83787[(17)]);
var inst_83603 = (state_83787[(2)]);
var inst_83604 = fluree.db.util.async.throw_err(inst_83603);
var state_83787__$1 = (function (){var statearr_83841 = state_83787;
(statearr_83841[(21)] = inst_83604);

return statearr_83841;
})();
if(cljs.core.truth_(inst_83599)){
var statearr_83842_83922 = state_83787__$1;
(statearr_83842_83922[(1)] = (3));

} else {
var statearr_83843_83923 = state_83787__$1;
(statearr_83843_83923[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (23))){
var inst_83679 = (state_83787[(2)]);
var state_83787__$1 = state_83787;
var statearr_83844_83924 = state_83787__$1;
(statearr_83844_83924[(2)] = inst_83679);

(statearr_83844_83924[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (47))){
var inst_83729 = (state_83787[(2)]);
var state_83787__$1 = state_83787;
var statearr_83845_83925 = state_83787__$1;
(statearr_83845_83925[(2)] = inst_83729);

(statearr_83845_83925[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (35))){
var inst_83711 = (state_83787[(2)]);
var state_83787__$1 = state_83787;
if(cljs.core.truth_(inst_83711)){
var statearr_83846_83926 = state_83787__$1;
(statearr_83846_83926[(1)] = (39));

} else {
var statearr_83847_83927 = state_83787__$1;
(statearr_83847_83927[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (19))){
var inst_83600 = (state_83787[(16)]);
var inst_83654 = cljs.core.sequential_QMARK_(inst_83600);
var state_83787__$1 = state_83787;
if(inst_83654){
var statearr_83848_83928 = state_83787__$1;
(statearr_83848_83928[(1)] = (21));

} else {
var statearr_83849_83929 = state_83787__$1;
(statearr_83849_83929[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (57))){
var inst_83769 = (state_83787[(19)]);
var state_83787__$1 = state_83787;
var statearr_83850_83930 = state_83787__$1;
(statearr_83850_83930[(2)] = inst_83769);

(statearr_83850_83930[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (11))){
var state_83787__$1 = state_83787;
var statearr_83851_83931 = state_83787__$1;
(statearr_83851_83931[(2)] = (-1));

(statearr_83851_83931[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (9))){
var inst_83626 = (state_83787[(2)]);
var state_83787__$1 = state_83787;
if(cljs.core.truth_(inst_83626)){
var statearr_83852_83932 = state_83787__$1;
(statearr_83852_83932[(1)] = (10));

} else {
var statearr_83853_83933 = state_83787__$1;
(statearr_83853_83933[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (5))){
var inst_83613 = (state_83787[(7)]);
var inst_83612 = (state_83787[(2)]);
var inst_83613__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83612,(0),null);
var inst_83614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83612,(1),null);
var inst_83621 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_83787__$1 = (function (){var statearr_83854 = state_83787;
(statearr_83854[(13)] = inst_83621);

(statearr_83854[(7)] = inst_83613__$1);

(statearr_83854[(27)] = inst_83614);

return statearr_83854;
})();
if(cljs.core.truth_(inst_83613__$1)){
var statearr_83855_83934 = state_83787__$1;
(statearr_83855_83934[(1)] = (7));

} else {
var statearr_83856_83935 = state_83787__$1;
(statearr_83856_83935[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (14))){
var inst_83604 = (state_83787[(21)]);
var inst_83614 = (state_83787[(27)]);
var inst_83639 = fluree.db.time_travel.as_of_block(inst_83604,inst_83614);
var state_83787__$1 = state_83787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83787__$1,(17),inst_83639);
} else {
if((state_val_83788 === (45))){
var inst_83691 = (state_83787[(10)]);
var inst_83725 = (inst_83691 == null);
var inst_83726 = cljs.core.not(inst_83725);
var state_83787__$1 = state_83787;
var statearr_83857_83936 = state_83787__$1;
(statearr_83857_83936[(2)] = inst_83726);

(statearr_83857_83936[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (53))){
var inst_83750 = (state_83787[(2)]);
var state_83787__$1 = state_83787;
var statearr_83858_83937 = state_83787__$1;
(statearr_83858_83937[(2)] = inst_83750);

(statearr_83858_83937[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (26))){
var inst_83666 = (state_83787[(2)]);
var state_83787__$1 = state_83787;
var statearr_83859_83938 = state_83787__$1;
(statearr_83859_83938[(2)] = inst_83666);

(statearr_83859_83938[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (16))){
var inst_83600 = (state_83787[(16)]);
var inst_83647 = (state_83787[(2)]);
var inst_83648 = fluree.db.util.core.subj_ident_QMARK_(inst_83600);
var state_83787__$1 = (function (){var statearr_83860 = state_83787;
(statearr_83860[(23)] = inst_83647);

return statearr_83860;
})();
if(inst_83648){
var statearr_83861_83939 = state_83787__$1;
(statearr_83861_83939[(1)] = (18));

} else {
var statearr_83862_83940 = state_83787__$1;
(statearr_83862_83940[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (38))){
var inst_83708 = (state_83787[(2)]);
var state_83787__$1 = state_83787;
var statearr_83863_83941 = state_83787__$1;
(statearr_83863_83941[(2)] = inst_83708);

(statearr_83863_83941[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (30))){
var inst_83681 = (state_83787[(9)]);
var inst_83696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83697 = [inst_83681,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_83698 = (new cljs.core.PersistentVector(null,2,(5),inst_83696,inst_83697,null));
var state_83787__$1 = state_83787;
var statearr_83864_83942 = state_83787__$1;
(statearr_83864_83942[(2)] = inst_83698);

(statearr_83864_83942[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (10))){
var inst_83604 = (state_83787[(21)]);
var inst_83613 = (state_83787[(7)]);
var inst_83628 = (inst_83613 - (1));
var inst_83629 = fluree.db.time_travel.as_of_block(inst_83604,inst_83628);
var state_83787__$1 = state_83787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83787__$1,(13),inst_83629);
} else {
if((state_val_83788 === (18))){
var inst_83600 = (state_83787[(16)]);
var inst_83650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83651 = [inst_83600];
var inst_83652 = (new cljs.core.PersistentVector(null,1,(5),inst_83650,inst_83651,null));
var state_83787__$1 = state_83787;
var statearr_83865_83943 = state_83787__$1;
(statearr_83865_83943[(2)] = inst_83652);

(statearr_83865_83943[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (52))){
var state_83787__$1 = state_83787;
var statearr_83866_83944 = state_83787__$1;
(statearr_83866_83944[(2)] = null);

(statearr_83866_83944[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (42))){
var inst_83723 = (state_83787[(20)]);
var inst_83690 = (state_83787[(12)]);
var inst_83722 = (inst_83690 == null);
var inst_83723__$1 = cljs.core.not(inst_83722);
var state_83787__$1 = (function (){var statearr_83867 = state_83787;
(statearr_83867[(20)] = inst_83723__$1);

return statearr_83867;
})();
if(inst_83723__$1){
var statearr_83868_83945 = state_83787__$1;
(statearr_83868_83945[(1)] = (45));

} else {
var statearr_83869_83946 = state_83787__$1;
(statearr_83869_83946[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (37))){
var inst_83703 = (state_83787[(26)]);
var state_83787__$1 = state_83787;
var statearr_83870_83947 = state_83787__$1;
(statearr_83870_83947[(2)] = inst_83703);

(statearr_83870_83947[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (8))){
var inst_83613 = (state_83787[(7)]);
var state_83787__$1 = state_83787;
var statearr_83871_83948 = state_83787__$1;
(statearr_83871_83948[(2)] = inst_83613);

(statearr_83871_83948[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83788 === (49))){
var state_83787__$1 = state_83787;
var statearr_83872_83949 = state_83787__$1;
(statearr_83872_83949[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__17178__auto__ = null;
var fluree$db$api_js$state_machine__17178__auto____0 = (function (){
var statearr_83874 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83874[(0)] = fluree$db$api_js$state_machine__17178__auto__);

(statearr_83874[(1)] = (1));

return statearr_83874;
});
var fluree$db$api_js$state_machine__17178__auto____1 = (function (state_83787){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_83787);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e83875){var ex__17181__auto__ = e83875;
var statearr_83876_83950 = state_83787;
(statearr_83876_83950[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_83787[(4)]))){
var statearr_83877_83951 = state_83787;
(statearr_83877_83951[(1)] = cljs.core.first((state_83787[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__83952 = state_83787;
state_83787 = G__83952;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__17178__auto__ = function(state_83787){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__17178__auto____1.call(this,state_83787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__17178__auto____0;
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__17178__auto____1;
return fluree$db$api_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_83878 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_83878[(6)] = c__17304__auto__);

return statearr_83878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__83960 = arguments.length;
switch (G__83960) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5753__auto__)){
var block = temp__5753__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4210__auto__ = block;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__4210__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4210__auto__ = block;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__4210__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__83953_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__83953_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_84049){
var state_val_84050 = (state_84049[(1)]);
if((state_val_84050 === (7))){
var inst_84000 = (state_84049[(7)]);
var inst_84003 = (state_84049[(8)]);
var inst_84006 = (state_84049[(9)]);
var inst_84010 = (state_84049[(10)]);
var inst_84016 = (function (){var responses = inst_84000;
var responses_STAR_ = inst_84003;
var statuses = inst_84006;
var fuel = inst_84010;
return (function (p1__83956_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__83956_SHARP_);
});
})();
var inst_84017 = cljs.core.some(inst_84016,inst_84006);
var state_84049__$1 = state_84049;
if(cljs.core.truth_(inst_84017)){
var statearr_84051_84099 = state_84049__$1;
(statearr_84051_84099[(1)] = (9));

} else {
var statearr_84052_84100 = state_84049__$1;
(statearr_84052_84100[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (20))){
var inst_84044 = (state_84049[(2)]);
var state_84049__$1 = state_84049;
var statearr_84053_84101 = state_84049__$1;
(statearr_84053_84101[(2)] = inst_84044);

(statearr_84053_84101[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (1))){
var inst_83995 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_83996 = (function (){var c__17304__auto____$1 = inst_83995;
return (function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_83993){
var state_val_83994 = (state_83993[(1)]);
if((state_val_83994 === (1))){
var inst_83961 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_83962 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_83963 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_83962,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_83964 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_83965 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_83966 = cljs.core.PersistentHashMap.EMPTY;
var inst_83967 = inst_83961;
var inst_83968 = inst_83963;
var inst_83969 = inst_83964;
var inst_83970 = inst_83965;
var inst_83971 = inst_83966;
var state_83993__$1 = (function (){var statearr_84054 = state_83993;
(statearr_84054[(7)] = inst_83970);

(statearr_84054[(8)] = inst_83969);

(statearr_84054[(9)] = inst_83968);

(statearr_84054[(10)] = inst_83967);

(statearr_84054[(11)] = inst_83971);

return statearr_84054;
})();
var statearr_84055_84102 = state_83993__$1;
(statearr_84055_84102[(2)] = null);

(statearr_84055_84102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83994 === (2))){
var inst_83968 = (state_83993[(9)]);
var inst_83973 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_83968);
var inst_83974 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_83973], 0));
var inst_83975 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_83968,new cljs.core.Keyword(null,"opts","opts",155075701),inst_83974);
var inst_83976 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_83975,db_fn);
var state_83993__$1 = state_83993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83993__$1,(4),inst_83976);
} else {
if((state_val_83994 === (3))){
var inst_83991 = (state_83993[(2)]);
var state_83993__$1 = state_83993;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83993__$1,inst_83991);
} else {
if((state_val_83994 === (4))){
var inst_83969 = (state_83993[(8)]);
var inst_83967 = (state_83993[(10)]);
var inst_83971 = (state_83993[(11)]);
var inst_83978 = (state_83993[(2)]);
var inst_83979 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_83971,inst_83967,inst_83978);
var inst_83980 = cljs.core.first(inst_83969);
var state_83993__$1 = (function (){var statearr_84056 = state_83993;
(statearr_84056[(12)] = inst_83979);

return statearr_84056;
})();
if(cljs.core.truth_(inst_83980)){
var statearr_84057_84103 = state_83993__$1;
(statearr_84057_84103[(1)] = (5));

} else {
var statearr_84058_84104 = state_83993__$1;
(statearr_84058_84104[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83994 === (5))){
var inst_83970 = (state_83993[(7)]);
var inst_83969 = (state_83993[(8)]);
var inst_83979 = (state_83993[(12)]);
var inst_83982 = cljs.core.first(inst_83969);
var inst_83983 = cljs.core.first(inst_83970);
var inst_83984 = cljs.core.rest(inst_83969);
var inst_83985 = cljs.core.rest(inst_83970);
var inst_83967 = inst_83982;
var inst_83968 = inst_83983;
var inst_83969__$1 = inst_83984;
var inst_83970__$1 = inst_83985;
var inst_83971 = inst_83979;
var state_83993__$1 = (function (){var statearr_84059 = state_83993;
(statearr_84059[(7)] = inst_83970__$1);

(statearr_84059[(8)] = inst_83969__$1);

(statearr_84059[(9)] = inst_83968);

(statearr_84059[(10)] = inst_83967);

(statearr_84059[(11)] = inst_83971);

return statearr_84059;
})();
var statearr_84060_84105 = state_83993__$1;
(statearr_84060_84105[(2)] = null);

(statearr_84060_84105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83994 === (6))){
var inst_83979 = (state_83993[(12)]);
var state_83993__$1 = state_83993;
var statearr_84061_84106 = state_83993__$1;
(statearr_84061_84106[(2)] = inst_83979);

(statearr_84061_84106[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_83994 === (7))){
var inst_83989 = (state_83993[(2)]);
var state_83993__$1 = state_83993;
var statearr_84062_84107 = state_83993__$1;
(statearr_84062_84107[(2)] = inst_83989);

(statearr_84062_84107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__17178__auto__ = null;
var fluree$db$api_js$state_machine__17178__auto____0 = (function (){
var statearr_84063 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_84063[(0)] = fluree$db$api_js$state_machine__17178__auto__);

(statearr_84063[(1)] = (1));

return statearr_84063;
});
var fluree$db$api_js$state_machine__17178__auto____1 = (function (state_83993){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_83993);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e84064){var ex__17181__auto__ = e84064;
var statearr_84065_84108 = state_83993;
(statearr_84065_84108[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_83993[(4)]))){
var statearr_84066_84109 = state_83993;
(statearr_84066_84109[(1)] = cljs.core.first((state_83993[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84110 = state_83993;
state_83993 = G__84110;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__17178__auto__ = function(state_83993){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__17178__auto____1.call(this,state_83993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__17178__auto____0;
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__17178__auto____1;
return fluree$db$api_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_84067 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_84067[(6)] = c__17304__auto____$1);

return statearr_84067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
});
})();
var inst_83997 = cljs.core.async.impl.dispatch.run(inst_83996);
var state_84049__$1 = (function (){var statearr_84068 = state_84049;
(statearr_84068[(11)] = inst_83997);

return statearr_84068;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84049__$1,(2),inst_83995);
} else {
if((state_val_84050 === (4))){
var inst_84000 = (state_84049[(7)]);
var state_84049__$1 = state_84049;
var statearr_84069_84111 = state_84049__$1;
(statearr_84069_84111[(2)] = inst_84000);

(statearr_84069_84111[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (15))){
var state_84049__$1 = state_84049;
var statearr_84070_84112 = state_84049__$1;
(statearr_84070_84112[(2)] = (400));

(statearr_84070_84112[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (13))){
var state_84049__$1 = state_84049;
var statearr_84071_84113 = state_84049__$1;
(statearr_84071_84113[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (6))){
var inst_84006 = (state_84049[(9)]);
var inst_84014 = cljs.core.first(inst_84006);
var state_84049__$1 = state_84049;
var statearr_84073_84114 = state_84049__$1;
(statearr_84073_84114[(2)] = inst_84014);

(statearr_84073_84114[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (17))){
var inst_84027 = (state_84049[(2)]);
var state_84049__$1 = state_84049;
var statearr_84074_84115 = state_84049__$1;
(statearr_84074_84115[(2)] = inst_84027);

(statearr_84074_84115[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (3))){
var inst_84000 = (state_84049[(7)]);
var inst_84003 = (state_84049[(8)]);
var inst_84006 = (state_84049[(9)]);
var inst_84010 = (state_84049[(10)]);
var inst_84005 = cljs.core.vals(inst_84000);
var inst_84006__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_84005);
var inst_84007 = (function (){var responses = inst_84000;
var responses_STAR_ = inst_84003;
var statuses = inst_84006__$1;
return (function (p1__83954_SHARP_){
var or__4212__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__83954_SHARP_);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
});
})();
var inst_84008 = cljs.core.vals(inst_84000);
var inst_84009 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_84007,inst_84008);
var inst_84010__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_84009);
var inst_84011 = (function (){var responses = inst_84000;
var responses_STAR_ = inst_84003;
var statuses = inst_84006__$1;
var fuel = inst_84010__$1;
return (function (p1__83955_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__83955_SHARP_);
});
})();
var inst_84012 = cljs.core.every_QMARK_(inst_84011,inst_84006__$1);
var state_84049__$1 = (function (){var statearr_84075 = state_84049;
(statearr_84075[(9)] = inst_84006__$1);

(statearr_84075[(10)] = inst_84010__$1);

return statearr_84075;
})();
if(inst_84012){
var statearr_84076_84116 = state_84049__$1;
(statearr_84076_84116[(1)] = (6));

} else {
var statearr_84077_84117 = state_84049__$1;
(statearr_84077_84117[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (12))){
var state_84049__$1 = state_84049;
var statearr_84078_84118 = state_84049__$1;
(statearr_84078_84118[(2)] = (500));

(statearr_84078_84118[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (2))){
var inst_84000 = (state_84049[(7)]);
var inst_83999 = (state_84049[(2)]);
var inst_84000__$1 = fluree.db.util.async.throw_err(inst_83999);
var inst_84001 = (function (){var responses = inst_84000__$1;
return (function (acc,index,response){
var resp = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_84002 = cljs.core.PersistentHashMap.EMPTY;
var inst_84003 = cljs.core.reduce_kv(inst_84001,inst_84002,inst_84000__$1);
var state_84049__$1 = (function (){var statearr_84079 = state_84049;
(statearr_84079[(7)] = inst_84000__$1);

(statearr_84079[(8)] = inst_84003);

return statearr_84079;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_84080_84119 = state_84049__$1;
(statearr_84080_84119[(1)] = (3));

} else {
var statearr_84081_84120 = state_84049__$1;
(statearr_84081_84120[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (19))){
var inst_84033 = (state_84049[(12)]);
var inst_84003 = (state_84049[(8)]);
var inst_84010 = (state_84049[(10)]);
var inst_84042 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_84003,new cljs.core.Keyword(null,"status","status",-1997798413),inst_84033,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_84010], 0));
var state_84049__$1 = state_84049;
var statearr_84082_84121 = state_84049__$1;
(statearr_84082_84121[(2)] = inst_84042);

(statearr_84082_84121[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (11))){
var inst_84031 = (state_84049[(2)]);
var state_84049__$1 = state_84049;
var statearr_84083_84122 = state_84049__$1;
(statearr_84083_84122[(2)] = inst_84031);

(statearr_84083_84122[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (9))){
var state_84049__$1 = state_84049;
var statearr_84084_84123 = state_84049__$1;
(statearr_84084_84123[(2)] = (207));

(statearr_84084_84123[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (5))){
var inst_84047 = (state_84049[(2)]);
var state_84049__$1 = state_84049;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84049__$1,inst_84047);
} else {
if((state_val_84050 === (14))){
var inst_84029 = (state_84049[(2)]);
var state_84049__$1 = state_84049;
var statearr_84085_84124 = state_84049__$1;
(statearr_84085_84124[(2)] = inst_84029);

(statearr_84085_84124[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (16))){
var state_84049__$1 = state_84049;
var statearr_84086_84125 = state_84049__$1;
(statearr_84086_84125[(2)] = null);

(statearr_84086_84125[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (10))){
var inst_84000 = (state_84049[(7)]);
var inst_84003 = (state_84049[(8)]);
var inst_84006 = (state_84049[(9)]);
var inst_84010 = (state_84049[(10)]);
var inst_84020 = (function (){var responses = inst_84000;
var responses_STAR_ = inst_84003;
var statuses = inst_84006;
var fuel = inst_84010;
return (function (p1__83957_SHARP_){
return ((499) < p1__83957_SHARP_);
});
})();
var inst_84021 = cljs.core.some(inst_84020,inst_84006);
var state_84049__$1 = state_84049;
if(cljs.core.truth_(inst_84021)){
var statearr_84087_84126 = state_84049__$1;
(statearr_84087_84126[(1)] = (12));

} else {
var statearr_84088_84127 = state_84049__$1;
(statearr_84088_84127[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (18))){
var inst_84038 = (state_84049[(13)]);
var inst_84033 = (state_84049[(12)]);
var inst_84003 = (state_84049[(8)]);
var inst_84010 = (state_84049[(10)]);
var inst_84040 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_84003,new cljs.core.Keyword(null,"status","status",-1997798413),inst_84033,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_84010,new cljs.core.Keyword(null,"block","block",664686210),inst_84038], 0));
var state_84049__$1 = state_84049;
var statearr_84089_84128 = state_84049__$1;
(statearr_84089_84128[(2)] = inst_84040);

(statearr_84089_84128[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84050 === (8))){
var inst_84038 = (state_84049[(13)]);
var inst_84033 = (state_84049[(12)]);
var inst_84000 = (state_84049[(7)]);
var inst_84003 = (state_84049[(8)]);
var inst_84006 = (state_84049[(9)]);
var inst_84010 = (state_84049[(10)]);
var inst_84033__$1 = (state_84049[(2)]);
var inst_84034 = (function (){var responses = inst_84000;
var responses_STAR_ = inst_84003;
var statuses = inst_84006;
var fuel = inst_84010;
var status = inst_84033__$1;
return (function (p1__83958_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__83958_SHARP_));
});
})();
var inst_84035 = cljs.core.vals(inst_84000);
var inst_84036 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_84034,inst_84035);
var inst_84037 = cljs.core.first(inst_84036);
var inst_84038__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_84037);
var state_84049__$1 = (function (){var statearr_84090 = state_84049;
(statearr_84090[(13)] = inst_84038__$1);

(statearr_84090[(12)] = inst_84033__$1);

return statearr_84090;
})();
if(cljs.core.truth_(inst_84038__$1)){
var statearr_84091_84129 = state_84049__$1;
(statearr_84091_84129[(1)] = (18));

} else {
var statearr_84092_84130 = state_84049__$1;
(statearr_84092_84130[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__17178__auto__ = null;
var fluree$db$api_js$state_machine__17178__auto____0 = (function (){
var statearr_84093 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_84093[(0)] = fluree$db$api_js$state_machine__17178__auto__);

(statearr_84093[(1)] = (1));

return statearr_84093;
});
var fluree$db$api_js$state_machine__17178__auto____1 = (function (state_84049){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_84049);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e84094){var ex__17181__auto__ = e84094;
var statearr_84095_84131 = state_84049;
(statearr_84095_84131[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_84049[(4)]))){
var statearr_84096_84132 = state_84049;
(statearr_84096_84132[(1)] = cljs.core.first((state_84049[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84133 = state_84049;
state_84049 = G__84133;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__17178__auto__ = function(state_84049){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__17178__auto____1.call(this,state_84049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__17178__auto____0;
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__17178__auto____1;
return fluree$db$api_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_84097 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_84097[(6)] = c__17304__auto__);

return statearr_84097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__84135 = arguments.length;
switch (G__84135) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__84136 = opts;
var map__84136__$1 = cljs.core.__destructure_map(map__84136);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__84136__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__84136__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__84136__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__84136__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__84137 = (cljs.core.truth_((function (){var and__4210__auto__ = auth;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4210__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__84137,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__84137,(1),null);
var action__$1 = (function (){var or__4212__auto__ = action;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4212__auto__ = nonce;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4212__auto__ = expire;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e84140){var e = e84140;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__84143 = arguments.length;
switch (G__84143) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_84174){
var state_val_84175 = (state_84174[(1)]);
if((state_val_84175 === (7))){
var state_84174__$1 = state_84174;
var statearr_84176_84197 = state_84174__$1;
(statearr_84176_84197[(2)] = opts);

(statearr_84176_84197[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84175 === (1))){
var state_84174__$1 = state_84174;
var statearr_84177_84198 = state_84174__$1;
(statearr_84177_84198[(2)] = null);

(statearr_84177_84198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84175 === (4))){
var inst_84144 = (state_84174[(2)]);
var inst_84145 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_84144], 0));
var inst_84146 = cljs.core.ex_data(inst_84144);
var inst_84147 = cljs.core.ex_message(inst_84144);
var inst_84148 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_84146,new cljs.core.Keyword(null,"message","message",-406056002),inst_84147);
var state_84174__$1 = (function (){var statearr_84178 = state_84174;
(statearr_84178[(7)] = inst_84145);

return statearr_84178;
})();
var statearr_84179_84199 = state_84174__$1;
(statearr_84179_84199[(2)] = inst_84148);

(statearr_84179_84199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84175 === (6))){
var inst_84158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84159 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_84160 = (new cljs.core.PersistentVector(null,1,(5),inst_84158,inst_84159,null));
var inst_84161 = cljs.core.assoc_in(opts,inst_84160,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_84174__$1 = state_84174;
var statearr_84180_84200 = state_84174__$1;
(statearr_84180_84200[(2)] = inst_84161);

(statearr_84180_84200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84175 === (3))){
var inst_84172 = (state_84174[(2)]);
var state_84174__$1 = state_84174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84174__$1,inst_84172);
} else {
if((state_val_84175 === (2))){
var _ = (function (){var statearr_84182 = state_84174;
(statearr_84182[(4)] = cljs.core.cons((5),(state_84174[(4)])));

return statearr_84182;
})();
var inst_84154 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_84155 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_84156 = (inst_84155 == null);
var state_84174__$1 = (function (){var statearr_84183 = state_84174;
(statearr_84183[(8)] = inst_84154);

return statearr_84183;
})();
if(cljs.core.truth_(inst_84156)){
var statearr_84184_84201 = state_84174__$1;
(statearr_84184_84201[(1)] = (6));

} else {
var statearr_84185_84202 = state_84174__$1;
(statearr_84185_84202[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84175 === (9))){
var inst_84168 = (state_84174[(2)]);
var inst_84169 = fluree.db.util.async.throw_err(inst_84168);
var _ = (function (){var statearr_84186 = state_84174;
(statearr_84186[(4)] = cljs.core.rest((state_84174[(4)])));

return statearr_84186;
})();
var state_84174__$1 = state_84174;
var statearr_84187_84203 = state_84174__$1;
(statearr_84187_84203[(2)] = inst_84169);

(statearr_84187_84203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84175 === (5))){
var _ = (function (){var statearr_84188 = state_84174;
(statearr_84188[(4)] = cljs.core.rest((state_84174[(4)])));

return statearr_84188;
})();
var state_84174__$1 = state_84174;
var ex84181 = (state_84174__$1[(2)]);
var statearr_84189_84204 = state_84174__$1;
(statearr_84189_84204[(5)] = ex84181);


var statearr_84190_84205 = state_84174__$1;
(statearr_84190_84205[(1)] = (4));

(statearr_84190_84205[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_84175 === (8))){
var inst_84154 = (state_84174[(8)]);
var inst_84164 = (state_84174[(2)]);
var inst_84165 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_84154,inst_84164);
var inst_84166 = fluree.db.operations.command_async(conn,inst_84165);
var state_84174__$1 = state_84174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84174__$1,(9),inst_84166);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__17178__auto__ = null;
var fluree$db$api_js$state_machine__17178__auto____0 = (function (){
var statearr_84191 = [null,null,null,null,null,null,null,null,null];
(statearr_84191[(0)] = fluree$db$api_js$state_machine__17178__auto__);

(statearr_84191[(1)] = (1));

return statearr_84191;
});
var fluree$db$api_js$state_machine__17178__auto____1 = (function (state_84174){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_84174);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e84192){var ex__17181__auto__ = e84192;
var statearr_84193_84206 = state_84174;
(statearr_84193_84206[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_84174[(4)]))){
var statearr_84194_84207 = state_84174;
(statearr_84194_84207[(1)] = cljs.core.first((state_84174[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__84208 = state_84174;
state_84174 = G__84208;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__17178__auto__ = function(state_84174){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__17178__auto____1.call(this,state_84174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__17178__auto____0;
fluree$db$api_js$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__17178__auto____1;
return fluree$db$api_js$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_84195 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_84195[(6)] = c__17304__auto__);

return statearr_84195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

