// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__78235 = arguments.length;
switch (G__78235) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__17304__auto___78383 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_78322){
var state_val_78323 = (state_78322[(1)]);
if((state_val_78323 === (7))){
var inst_78253 = (state_78322[(7)]);
var inst_78256 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_78253);
var state_78322__$1 = state_78322;
var statearr_78324_78384 = state_78322__$1;
(statearr_78324_78384[(2)] = inst_78256);

(statearr_78324_78384[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (20))){
var inst_78248 = (state_78322[(8)]);
var inst_78277 = (state_78322[(9)]);
var inst_78281 = fluree.db.auth.roles(inst_78248,inst_78277);
var state_78322__$1 = state_78322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78322__$1,(23),inst_78281);
} else {
if((state_val_78323 === (27))){
var inst_78248 = (state_78322[(8)]);
var inst_78296 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_78297 = fluree.db.time_travel.as_of_block(inst_78248,inst_78296);
var state_78322__$1 = state_78322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78322__$1,(30),inst_78297);
} else {
if((state_val_78323 === (1))){
var state_78322__$1 = state_78322;
var statearr_78325_78385 = state_78322__$1;
(statearr_78325_78385[(2)] = null);

(statearr_78325_78385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (24))){
var inst_78248 = (state_78322[(8)]);
var inst_78289 = (state_78322[(10)]);
var inst_78291 = fluree.db.permissions.permission_map(inst_78248,inst_78289,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_78322__$1 = state_78322;
var statearr_78326_78386 = state_78322__$1;
(statearr_78326_78386[(2)] = inst_78291);

(statearr_78326_78386[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (4))){
var inst_78236 = (state_78322[(2)]);
var inst_78237 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_78236);
var inst_78238 = cljs.core.async.close_BANG_(pc);
var state_78322__$1 = (function (){var statearr_78327 = state_78322;
(statearr_78327[(11)] = inst_78237);

return statearr_78327;
})();
var statearr_78328_78387 = state_78322__$1;
(statearr_78328_78387[(2)] = inst_78238);

(statearr_78328_78387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (15))){
var inst_78253 = (state_78322[(7)]);
var inst_78267 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78253)," unknown."].join('');
var inst_78268 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78269 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_78270 = cljs.core.PersistentHashMap.fromArrays(inst_78268,inst_78269);
var inst_78271 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_78267,inst_78270);
var inst_78272 = (function(){throw inst_78271})();
var state_78322__$1 = state_78322;
var statearr_78329_78388 = state_78322__$1;
(statearr_78329_78388[(2)] = inst_78272);

(statearr_78329_78388[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (21))){
var state_78322__$1 = state_78322;
var statearr_78330_78389 = state_78322__$1;
(statearr_78330_78389[(2)] = null);

(statearr_78330_78389[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (31))){
var inst_78303 = (state_78322[(12)]);
var inst_78253 = (state_78322[(7)]);
var inst_78305 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_78303,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_78253);
var state_78322__$1 = state_78322;
var statearr_78331_78390 = state_78322__$1;
(statearr_78331_78390[(2)] = inst_78305);

(statearr_78331_78390[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (32))){
var inst_78303 = (state_78322[(12)]);
var state_78322__$1 = state_78322;
var statearr_78332_78391 = state_78322__$1;
(statearr_78332_78391[(2)] = inst_78303);

(statearr_78332_78391[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (33))){
var inst_78289 = (state_78322[(10)]);
var inst_78308 = (state_78322[(2)]);
var state_78322__$1 = (function (){var statearr_78333 = state_78322;
(statearr_78333[(13)] = inst_78308);

return statearr_78333;
})();
if(cljs.core.truth_(inst_78289)){
var statearr_78334_78392 = state_78322__$1;
(statearr_78334_78392[(1)] = (34));

} else {
var statearr_78335_78393 = state_78322__$1;
(statearr_78335_78393[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (13))){
var inst_78264 = (state_78322[(14)]);
var inst_78263 = (state_78322[(2)]);
var inst_78264__$1 = fluree.db.util.async.throw_err(inst_78263);
var state_78322__$1 = (function (){var statearr_78336 = state_78322;
(statearr_78336[(14)] = inst_78264__$1);

return statearr_78336;
})();
if(cljs.core.truth_(inst_78264__$1)){
var statearr_78337_78394 = state_78322__$1;
(statearr_78337_78394[(1)] = (14));

} else {
var statearr_78338_78395 = state_78322__$1;
(statearr_78338_78395[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (22))){
var inst_78287 = (state_78322[(2)]);
var state_78322__$1 = state_78322;
var statearr_78339_78396 = state_78322__$1;
(statearr_78339_78396[(2)] = inst_78287);

(statearr_78339_78396[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (36))){
var inst_78316 = (state_78322[(2)]);
var inst_78317 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_78316);
var _ = (function (){var statearr_78340 = state_78322;
(statearr_78340[(4)] = cljs.core.rest((state_78322[(4)])));

return statearr_78340;
})();
var state_78322__$1 = state_78322;
var statearr_78341_78397 = state_78322__$1;
(statearr_78341_78397[(2)] = inst_78317);

(statearr_78341_78397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (29))){
var inst_78253 = (state_78322[(7)]);
var inst_78303 = (state_78322[(2)]);
var state_78322__$1 = (function (){var statearr_78342 = state_78322;
(statearr_78342[(12)] = inst_78303);

return statearr_78342;
})();
if(cljs.core.truth_(inst_78253)){
var statearr_78343_78398 = state_78322__$1;
(statearr_78343_78398[(1)] = (31));

} else {
var statearr_78344_78399 = state_78322__$1;
(statearr_78344_78399[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (6))){
var inst_78253 = (state_78322[(7)]);
var inst_78247 = (state_78322[(2)]);
var inst_78248 = fluree.db.util.async.throw_err(inst_78247);
var inst_78249 = opts;
var inst_78250 = cljs.core.__destructure_map(inst_78249);
var inst_78251 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78250,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_78252 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78250,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_78253__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78250,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_78254 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78250,new cljs.core.Keyword(null,"block","block",664686210));
var state_78322__$1 = (function (){var statearr_78345 = state_78322;
(statearr_78345[(8)] = inst_78248);

(statearr_78345[(7)] = inst_78253__$1);

(statearr_78345[(15)] = inst_78252);

(statearr_78345[(16)] = inst_78251);

(statearr_78345[(17)] = inst_78254);

return statearr_78345;
})();
if(cljs.core.truth_(inst_78253__$1)){
var statearr_78346_78400 = state_78322__$1;
(statearr_78346_78400[(1)] = (7));

} else {
var statearr_78347_78401 = state_78322__$1;
(statearr_78347_78401[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (28))){
var inst_78248 = (state_78322[(8)]);
var state_78322__$1 = state_78322;
var statearr_78348_78402 = state_78322__$1;
(statearr_78348_78402[(2)] = inst_78248);

(statearr_78348_78402[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (25))){
var state_78322__$1 = state_78322;
var statearr_78349_78403 = state_78322__$1;
(statearr_78349_78403[(2)] = null);

(statearr_78349_78403[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (34))){
var inst_78294 = (state_78322[(18)]);
var state_78322__$1 = state_78322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78322__$1,(37),inst_78294);
} else {
if((state_val_78323 === (17))){
var inst_78251 = (state_78322[(16)]);
var state_78322__$1 = state_78322;
var statearr_78350_78404 = state_78322__$1;
(statearr_78350_78404[(2)] = inst_78251);

(statearr_78350_78404[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (3))){
var inst_78320 = (state_78322[(2)]);
var state_78322__$1 = state_78322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78322__$1,inst_78320);
} else {
if((state_val_78323 === (12))){
var inst_78251 = (state_78322[(16)]);
var inst_78277 = (state_78322[(2)]);
var state_78322__$1 = (function (){var statearr_78351 = state_78322;
(statearr_78351[(9)] = inst_78277);

return statearr_78351;
})();
if(cljs.core.truth_(inst_78251)){
var statearr_78352_78405 = state_78322__$1;
(statearr_78352_78405[(1)] = (17));

} else {
var statearr_78353_78406 = state_78322__$1;
(statearr_78353_78406[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (2))){
var _ = (function (){var statearr_78354 = state_78322;
(statearr_78354[(4)] = cljs.core.cons((5),(state_78322[(4)])));

return statearr_78354;
})();
var inst_78245 = fluree.db.session.db(conn,ledger,null);
var state_78322__$1 = state_78322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78322__$1,(6),inst_78245);
} else {
if((state_val_78323 === (23))){
var inst_78283 = (state_78322[(2)]);
var inst_78284 = fluree.db.util.async.throw_err(inst_78283);
var state_78322__$1 = state_78322;
var statearr_78355_78407 = state_78322__$1;
(statearr_78355_78407[(2)] = inst_78284);

(statearr_78355_78407[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (35))){
var inst_78308 = (state_78322[(13)]);
var state_78322__$1 = state_78322;
var statearr_78356_78408 = state_78322__$1;
(statearr_78356_78408[(2)] = inst_78308);

(statearr_78356_78408[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (19))){
var inst_78289 = (state_78322[(10)]);
var inst_78289__$1 = (state_78322[(2)]);
var state_78322__$1 = (function (){var statearr_78357 = state_78322;
(statearr_78357[(10)] = inst_78289__$1);

return statearr_78357;
})();
if(cljs.core.truth_(inst_78289__$1)){
var statearr_78358_78409 = state_78322__$1;
(statearr_78358_78409[(1)] = (24));

} else {
var statearr_78359_78410 = state_78322__$1;
(statearr_78359_78410[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (11))){
var state_78322__$1 = state_78322;
var statearr_78361_78411 = state_78322__$1;
(statearr_78361_78411[(2)] = null);

(statearr_78361_78411[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (9))){
var inst_78259 = (state_78322[(2)]);
var state_78322__$1 = state_78322;
if(cljs.core.truth_(inst_78259)){
var statearr_78362_78412 = state_78322__$1;
(statearr_78362_78412[(1)] = (10));

} else {
var statearr_78363_78413 = state_78322__$1;
(statearr_78363_78413[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (5))){
var _ = (function (){var statearr_78364 = state_78322;
(statearr_78364[(4)] = cljs.core.rest((state_78322[(4)])));

return statearr_78364;
})();
var state_78322__$1 = state_78322;
var ex78360 = (state_78322__$1[(2)]);
var statearr_78365_78414 = state_78322__$1;
(statearr_78365_78414[(5)] = ex78360);


var statearr_78366_78415 = state_78322__$1;
(statearr_78366_78415[(1)] = (4));

(statearr_78366_78415[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (14))){
var inst_78264 = (state_78322[(14)]);
var state_78322__$1 = state_78322;
var statearr_78367_78416 = state_78322__$1;
(statearr_78367_78416[(2)] = inst_78264);

(statearr_78367_78416[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (26))){
var inst_78254 = (state_78322[(17)]);
var inst_78294 = (state_78322[(2)]);
var state_78322__$1 = (function (){var statearr_78368 = state_78322;
(statearr_78368[(18)] = inst_78294);

return statearr_78368;
})();
if(cljs.core.truth_(inst_78254)){
var statearr_78369_78417 = state_78322__$1;
(statearr_78369_78417[(1)] = (27));

} else {
var statearr_78370_78418 = state_78322__$1;
(statearr_78370_78418[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (16))){
var inst_78274 = (state_78322[(2)]);
var state_78322__$1 = state_78322;
var statearr_78371_78419 = state_78322__$1;
(statearr_78371_78419[(2)] = inst_78274);

(statearr_78371_78419[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (30))){
var inst_78299 = (state_78322[(2)]);
var inst_78300 = fluree.db.util.async.throw_err(inst_78299);
var state_78322__$1 = state_78322;
var statearr_78372_78420 = state_78322__$1;
(statearr_78372_78420[(2)] = inst_78300);

(statearr_78372_78420[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (10))){
var inst_78248 = (state_78322[(8)]);
var inst_78253 = (state_78322[(7)]);
var inst_78261 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_78248,inst_78253);
var state_78322__$1 = state_78322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78322__$1,(13),inst_78261);
} else {
if((state_val_78323 === (18))){
var inst_78277 = (state_78322[(9)]);
var state_78322__$1 = state_78322;
if(cljs.core.truth_(inst_78277)){
var statearr_78373_78421 = state_78322__$1;
(statearr_78373_78421[(1)] = (20));

} else {
var statearr_78374_78422 = state_78322__$1;
(statearr_78374_78422[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (37))){
var inst_78308 = (state_78322[(13)]);
var inst_78311 = (state_78322[(2)]);
var inst_78312 = fluree.db.util.async.throw_err(inst_78311);
var inst_78313 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_78308,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_78312);
var state_78322__$1 = state_78322;
var statearr_78375_78423 = state_78322__$1;
(statearr_78375_78423[(2)] = inst_78313);

(statearr_78375_78423[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78323 === (8))){
var inst_78253 = (state_78322[(7)]);
var state_78322__$1 = state_78322;
var statearr_78376_78424 = state_78322__$1;
(statearr_78376_78424[(2)] = inst_78253);

(statearr_78376_78424[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__17178__auto__ = null;
var fluree$db$api$query$state_machine__17178__auto____0 = (function (){
var statearr_78377 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78377[(0)] = fluree$db$api$query$state_machine__17178__auto__);

(statearr_78377[(1)] = (1));

return statearr_78377;
});
var fluree$db$api$query$state_machine__17178__auto____1 = (function (state_78322){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_78322);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e78378){var ex__17181__auto__ = e78378;
var statearr_78379_78425 = state_78322;
(statearr_78379_78425[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_78322[(4)]))){
var statearr_78380_78426 = state_78322;
(statearr_78380_78426[(1)] = cljs.core.first((state_78322[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78427 = state_78322;
state_78322 = G__78427;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__17178__auto__ = function(state_78322){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__17178__auto____1.call(this,state_78322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__17178__auto____0;
fluree$db$api$query$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__17178__auto____1;
return fluree$db$api$query$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_78381 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_78381[(6)] = c__17304__auto___78383);

return statearr_78381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_78568){
var state_val_78569 = (state_78568[(1)]);
if((state_val_78569 === (7))){
var inst_78448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78449 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_78450 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_78451 = [inst_78449,inst_78450];
var inst_78452 = (new cljs.core.PersistentVector(null,2,(5),inst_78448,inst_78451,null));
var state_78568__$1 = state_78568;
var statearr_78570_78640 = state_78568__$1;
(statearr_78570_78640[(2)] = inst_78452);

(statearr_78570_78640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (20))){
var inst_78478 = (state_78568[(7)]);
var state_78568__$1 = state_78568;
var statearr_78571_78641 = state_78568__$1;
(statearr_78571_78641[(2)] = inst_78478);

(statearr_78571_78641[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (27))){
var state_78568__$1 = state_78568;
var statearr_78572_78642 = state_78568__$1;
(statearr_78572_78642[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (1))){
var state_78568__$1 = state_78568;
var statearr_78574_78643 = state_78568__$1;
(statearr_78574_78643[(2)] = null);

(statearr_78574_78643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (24))){
var inst_78477 = (state_78568[(8)]);
var state_78568__$1 = state_78568;
if(cljs.core.truth_(inst_78477)){
var statearr_78575_78644 = state_78568__$1;
(statearr_78575_78644[(1)] = (26));

} else {
var statearr_78576_78645 = state_78568__$1;
(statearr_78576_78645[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (39))){
var inst_78524 = (state_78568[(9)]);
var inst_78523 = (state_78568[(10)]);
var inst_78549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78550 = [inst_78523,inst_78524];
var inst_78551 = (new cljs.core.PersistentVector(null,2,(5),inst_78549,inst_78550,null));
var state_78568__$1 = state_78568;
var statearr_78577_78646 = state_78568__$1;
(statearr_78577_78646[(2)] = inst_78551);

(statearr_78577_78646[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (4))){
var inst_78428 = (state_78568[(2)]);
var state_78568__$1 = state_78568;
var statearr_78578_78647 = state_78568__$1;
(statearr_78578_78647[(2)] = inst_78428);

(statearr_78578_78647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (15))){
var inst_78457 = (state_78568[(11)]);
var inst_78462 = (state_78568[(12)]);
var inst_78471 = (state_78568[(2)]);
var inst_78472 = [inst_78462,inst_78471];
var inst_78473 = (new cljs.core.PersistentVector(null,2,(5),inst_78457,inst_78472,null));
var state_78568__$1 = state_78568;
var statearr_78579_78648 = state_78568__$1;
(statearr_78579_78648[(2)] = inst_78473);

(statearr_78579_78648[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (21))){
var inst_78477 = (state_78568[(8)]);
var state_78568__$1 = state_78568;
var statearr_78580_78649 = state_78568__$1;
(statearr_78580_78649[(2)] = inst_78477);

(statearr_78580_78649[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (31))){
var inst_78518 = (state_78568[(2)]);
var state_78568__$1 = state_78568;
var statearr_78581_78650 = state_78568__$1;
(statearr_78581_78650[(2)] = inst_78518);

(statearr_78581_78650[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (32))){
var inst_78524 = (state_78568[(9)]);
var inst_78527 = cljs.core.pos_int_QMARK_(inst_78524);
var state_78568__$1 = state_78568;
var statearr_78582_78651 = state_78568__$1;
(statearr_78582_78651[(2)] = inst_78527);

(statearr_78582_78651[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (40))){
var inst_78479 = (state_78568[(13)]);
var inst_78555 = (state_78568[(14)]);
var inst_78553 = (state_78568[(2)]);
var inst_78554 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78553,(0),null);
var inst_78555__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78553,(1),null);
var inst_78556 = (inst_78555__$1 > inst_78479);
var state_78568__$1 = (function (){var statearr_78583 = state_78568;
(statearr_78583[(15)] = inst_78554);

(statearr_78583[(14)] = inst_78555__$1);

return statearr_78583;
})();
if(cljs.core.truth_(inst_78556)){
var statearr_78584_78652 = state_78568__$1;
(statearr_78584_78652[(1)] = (41));

} else {
var statearr_78585_78653 = state_78568__$1;
(statearr_78585_78653[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (33))){
var inst_78525 = (state_78568[(16)]);
var state_78568__$1 = state_78568;
var statearr_78586_78654 = state_78568__$1;
(statearr_78586_78654[(2)] = inst_78525);

(statearr_78586_78654[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (13))){
var inst_78463 = (state_78568[(17)]);
var inst_78465 = fluree.db.time_travel.block_to_int_format(db,inst_78463);
var state_78568__$1 = state_78568;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78568__$1,(16),inst_78465);
} else {
if((state_val_78569 === (22))){
var inst_78496 = (state_78568[(2)]);
var state_78568__$1 = state_78568;
if(cljs.core.truth_(inst_78496)){
var statearr_78587_78655 = state_78568__$1;
(statearr_78587_78655[(1)] = (23));

} else {
var statearr_78588_78656 = state_78568__$1;
(statearr_78588_78656[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (36))){
var state_78568__$1 = state_78568;
var statearr_78589_78657 = state_78568__$1;
(statearr_78589_78657[(2)] = null);

(statearr_78589_78657[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (41))){
var inst_78479 = (state_78568[(13)]);
var state_78568__$1 = state_78568;
var statearr_78590_78658 = state_78568__$1;
(statearr_78590_78658[(2)] = inst_78479);

(statearr_78590_78658[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (43))){
var inst_78554 = (state_78568[(15)]);
var inst_78560 = (state_78568[(2)]);
var inst_78561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78562 = [inst_78554,inst_78560];
var inst_78563 = (new cljs.core.PersistentVector(null,2,(5),inst_78561,inst_78562,null));
var _ = (function (){var statearr_78591 = state_78568;
(statearr_78591[(4)] = cljs.core.rest((state_78568[(4)])));

return statearr_78591;
})();
var state_78568__$1 = state_78568;
var statearr_78592_78659 = state_78568__$1;
(statearr_78592_78659[(2)] = inst_78563);

(statearr_78592_78659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (29))){
var inst_78454 = (state_78568[(18)]);
var inst_78509 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78454], 0));
var inst_78510 = ["Invalid block range provided: ",inst_78509].join('');
var inst_78511 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78512 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_78513 = cljs.core.PersistentHashMap.fromArrays(inst_78511,inst_78512);
var inst_78514 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_78510,inst_78513);
var inst_78515 = (function(){throw inst_78514})();
var state_78568__$1 = state_78568;
var statearr_78593_78660 = state_78568__$1;
(statearr_78593_78660[(2)] = inst_78515);

(statearr_78593_78660[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (6))){
var inst_78446 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_78568__$1 = state_78568;
var statearr_78594_78661 = state_78568__$1;
(statearr_78594_78661[(2)] = inst_78446);

(statearr_78594_78661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (28))){
var inst_78520 = (state_78568[(2)]);
var state_78568__$1 = state_78568;
var statearr_78595_78662 = state_78568__$1;
(statearr_78595_78662[(2)] = inst_78520);

(statearr_78595_78662[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (25))){
var inst_78523 = (state_78568[(10)]);
var inst_78525 = (state_78568[(16)]);
var inst_78522 = (state_78568[(2)]);
var inst_78523__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78522,(0),null);
var inst_78524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78522,(1),null);
var inst_78525__$1 = cljs.core.pos_int_QMARK_(inst_78523__$1);
var state_78568__$1 = (function (){var statearr_78596 = state_78568;
(statearr_78596[(9)] = inst_78524);

(statearr_78596[(10)] = inst_78523__$1);

(statearr_78596[(16)] = inst_78525__$1);

return statearr_78596;
})();
if(inst_78525__$1){
var statearr_78597_78663 = state_78568__$1;
(statearr_78597_78663[(1)] = (32));

} else {
var statearr_78598_78664 = state_78568__$1;
(statearr_78598_78664[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (34))){
var inst_78530 = (state_78568[(2)]);
var inst_78531 = cljs.core.not(inst_78530);
var state_78568__$1 = state_78568;
if(inst_78531){
var statearr_78599_78665 = state_78568__$1;
(statearr_78599_78665[(1)] = (35));

} else {
var statearr_78600_78666 = state_78568__$1;
(statearr_78600_78666[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (17))){
var inst_78477 = (state_78568[(8)]);
var inst_78479 = (state_78568[(13)]);
var inst_78482 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78477], 0));
var inst_78483 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78479], 0));
var inst_78484 = ["Start block is out of range for this ledger. Start block provided: ",inst_78482,". Database block: ",inst_78483].join('');
var inst_78485 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78486 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_78487 = cljs.core.PersistentHashMap.fromArrays(inst_78485,inst_78486);
var inst_78488 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_78484,inst_78487);
var inst_78489 = (function(){throw inst_78488})();
var state_78568__$1 = state_78568;
var statearr_78601_78667 = state_78568__$1;
(statearr_78601_78667[(2)] = inst_78489);

(statearr_78601_78667[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (3))){
var inst_78566 = (state_78568[(2)]);
var state_78568__$1 = state_78568;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78568__$1,inst_78566);
} else {
if((state_val_78569 === (12))){
var inst_78463 = (state_78568[(17)]);
var inst_78454 = (state_78568[(18)]);
var inst_78461 = (state_78568[(2)]);
var inst_78462 = fluree.db.util.async.throw_err(inst_78461);
var inst_78463__$1 = cljs.core.second(inst_78454);
var state_78568__$1 = (function (){var statearr_78602 = state_78568;
(statearr_78602[(17)] = inst_78463__$1);

(statearr_78602[(12)] = inst_78462);

return statearr_78602;
})();
if(cljs.core.truth_(inst_78463__$1)){
var statearr_78603_78668 = state_78568__$1;
(statearr_78603_78668[(1)] = (13));

} else {
var statearr_78604_78669 = state_78568__$1;
(statearr_78604_78669[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (2))){
var _ = (function (){var statearr_78605 = state_78568;
(statearr_78605[(4)] = cljs.core.cons((5),(state_78568[(4)])));

return statearr_78605;
})();
var inst_78443 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_78444 = cljs.core.sequential_QMARK_(inst_78443);
var state_78568__$1 = state_78568;
if(inst_78444){
var statearr_78606_78670 = state_78568__$1;
(statearr_78606_78670[(1)] = (6));

} else {
var statearr_78607_78671 = state_78568__$1;
(statearr_78607_78671[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (23))){
var inst_78477 = (state_78568[(8)]);
var inst_78478 = (state_78568[(7)]);
var inst_78498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78499 = [inst_78477,inst_78478];
var inst_78500 = (new cljs.core.PersistentVector(null,2,(5),inst_78498,inst_78499,null));
var state_78568__$1 = state_78568;
var statearr_78608_78672 = state_78568__$1;
(statearr_78608_78672[(2)] = inst_78500);

(statearr_78608_78672[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (35))){
var inst_78454 = (state_78568[(18)]);
var inst_78533 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78454], 0));
var inst_78534 = ["Invalid block range provided: ",inst_78533].join('');
var inst_78535 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78536 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_78537 = cljs.core.PersistentHashMap.fromArrays(inst_78535,inst_78536);
var inst_78538 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_78534,inst_78537);
var inst_78539 = (function(){throw inst_78538})();
var state_78568__$1 = state_78568;
var statearr_78609_78673 = state_78568__$1;
(statearr_78609_78673[(2)] = inst_78539);

(statearr_78609_78673[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (19))){
var inst_78477 = (state_78568[(8)]);
var inst_78492 = (state_78568[(2)]);
var state_78568__$1 = (function (){var statearr_78610 = state_78568;
(statearr_78610[(19)] = inst_78492);

return statearr_78610;
})();
if(cljs.core.truth_(inst_78477)){
var statearr_78611_78674 = state_78568__$1;
(statearr_78611_78674[(1)] = (20));

} else {
var statearr_78612_78675 = state_78568__$1;
(statearr_78612_78675[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (11))){
var inst_78477 = (state_78568[(8)]);
var inst_78479 = (state_78568[(13)]);
var inst_78476 = (state_78568[(2)]);
var inst_78477__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78476,(0),null);
var inst_78478 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78476,(1),null);
var inst_78479__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_78480 = (inst_78477__$1 > inst_78479__$1);
var state_78568__$1 = (function (){var statearr_78614 = state_78568;
(statearr_78614[(8)] = inst_78477__$1);

(statearr_78614[(13)] = inst_78479__$1);

(statearr_78614[(7)] = inst_78478);

return statearr_78614;
})();
if(cljs.core.truth_(inst_78480)){
var statearr_78615_78676 = state_78568__$1;
(statearr_78615_78676[(1)] = (17));

} else {
var statearr_78616_78677 = state_78568__$1;
(statearr_78616_78677[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (9))){
var inst_78454 = (state_78568[(18)]);
var inst_78457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78458 = cljs.core.first(inst_78454);
var inst_78459 = fluree.db.time_travel.block_to_int_format(db,inst_78458);
var state_78568__$1 = (function (){var statearr_78617 = state_78568;
(statearr_78617[(11)] = inst_78457);

return statearr_78617;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78568__$1,(12),inst_78459);
} else {
if((state_val_78569 === (5))){
var _ = (function (){var statearr_78618 = state_78568;
(statearr_78618[(4)] = cljs.core.rest((state_78568[(4)])));

return statearr_78618;
})();
var state_78568__$1 = state_78568;
var ex78613 = (state_78568__$1[(2)]);
var statearr_78619_78678 = state_78568__$1;
(statearr_78619_78678[(5)] = ex78613);


if((ex78613 instanceof Error)){
var statearr_78620_78679 = state_78568__$1;
(statearr_78620_78679[(1)] = (4));

(statearr_78620_78679[(5)] = null);

} else {
throw ex78613;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (14))){
var state_78568__$1 = state_78568;
var statearr_78621_78680 = state_78568__$1;
(statearr_78621_78680[(2)] = null);

(statearr_78621_78680[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (26))){
var inst_78477 = (state_78568[(8)]);
var inst_78503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78504 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_78505 = [inst_78477,inst_78504];
var inst_78506 = (new cljs.core.PersistentVector(null,2,(5),inst_78503,inst_78505,null));
var state_78568__$1 = state_78568;
var statearr_78622_78681 = state_78568__$1;
(statearr_78622_78681[(2)] = inst_78506);

(statearr_78622_78681[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (16))){
var inst_78467 = (state_78568[(2)]);
var inst_78468 = fluree.db.util.async.throw_err(inst_78467);
var state_78568__$1 = state_78568;
var statearr_78623_78682 = state_78568__$1;
(statearr_78623_78682[(2)] = inst_78468);

(statearr_78623_78682[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (38))){
var inst_78524 = (state_78568[(9)]);
var inst_78523 = (state_78568[(10)]);
var inst_78545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78546 = [inst_78524,inst_78523];
var inst_78547 = (new cljs.core.PersistentVector(null,2,(5),inst_78545,inst_78546,null));
var state_78568__$1 = state_78568;
var statearr_78624_78683 = state_78568__$1;
(statearr_78624_78683[(2)] = inst_78547);

(statearr_78624_78683[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (30))){
var state_78568__$1 = state_78568;
var statearr_78625_78684 = state_78568__$1;
(statearr_78625_78684[(2)] = null);

(statearr_78625_78684[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (10))){
var inst_78454 = (state_78568[(18)]);
var state_78568__$1 = state_78568;
var statearr_78626_78685 = state_78568__$1;
(statearr_78626_78685[(2)] = inst_78454);

(statearr_78626_78685[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (18))){
var state_78568__$1 = state_78568;
var statearr_78627_78686 = state_78568__$1;
(statearr_78627_78686[(2)] = null);

(statearr_78627_78686[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (42))){
var inst_78555 = (state_78568[(14)]);
var state_78568__$1 = state_78568;
var statearr_78628_78687 = state_78568__$1;
(statearr_78628_78687[(2)] = inst_78555);

(statearr_78628_78687[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (37))){
var inst_78524 = (state_78568[(9)]);
var inst_78523 = (state_78568[(10)]);
var inst_78542 = (state_78568[(2)]);
var inst_78543 = (inst_78524 < inst_78523);
var state_78568__$1 = (function (){var statearr_78629 = state_78568;
(statearr_78629[(20)] = inst_78542);

return statearr_78629;
})();
if(cljs.core.truth_(inst_78543)){
var statearr_78630_78688 = state_78568__$1;
(statearr_78630_78688[(1)] = (38));

} else {
var statearr_78631_78689 = state_78568__$1;
(statearr_78631_78689[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (8))){
var inst_78454 = (state_78568[(18)]);
var inst_78454__$1 = (state_78568[(2)]);
var inst_78455 = cljs.core.some(cljs.core.string_QMARK_,inst_78454__$1);
var state_78568__$1 = (function (){var statearr_78632 = state_78568;
(statearr_78632[(18)] = inst_78454__$1);

return statearr_78632;
})();
if(cljs.core.truth_(inst_78455)){
var statearr_78633_78690 = state_78568__$1;
(statearr_78633_78690[(1)] = (9));

} else {
var statearr_78634_78691 = state_78568__$1;
(statearr_78634_78691[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__17178__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__17178__auto____0 = (function (){
var statearr_78635 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78635[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__17178__auto__);

(statearr_78635[(1)] = (1));

return statearr_78635;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__17178__auto____1 = (function (state_78568){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_78568);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e78636){var ex__17181__auto__ = e78636;
var statearr_78637_78692 = state_78568;
(statearr_78637_78692[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_78568[(4)]))){
var statearr_78638_78693 = state_78568;
(statearr_78638_78693[(1)] = cljs.core.first((state_78568[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78694 = state_78568;
state_78568 = G__78694;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__17178__auto__ = function(state_78568){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__17178__auto____1.call(this,state_78568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__17178__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__17178__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_78639 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_78639[(6)] = c__17304__auto__);

return statearr_78639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_78844){
var state_val_78845 = (state_78844[(1)]);
if((state_val_78845 === (7))){
var inst_78756 = (state_78844[(2)]);
var inst_78757 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78756,(0),null);
var inst_78758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78756,(1),null);
var inst_78766 = cljs.core.vals(inst_78758);
var inst_78767 = cljs.core.seq(inst_78766);
var inst_78768 = cljs.core.first(inst_78767);
var inst_78769 = cljs.core.next(inst_78767);
var inst_78770 = cljs.core.PersistentVector.EMPTY;
var inst_78771 = inst_78766;
var inst_78772 = inst_78770;
var state_78844__$1 = (function (){var statearr_78846 = state_78844;
(statearr_78846[(7)] = inst_78771);

(statearr_78846[(8)] = inst_78757);

(statearr_78846[(9)] = inst_78772);

(statearr_78846[(10)] = inst_78768);

(statearr_78846[(11)] = inst_78769);

return statearr_78846;
})();
var statearr_78847_78900 = state_78844__$1;
(statearr_78847_78900[(2)] = null);

(statearr_78847_78900[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (20))){
var inst_78778 = (state_78844[(12)]);
var inst_78783 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_78784 = cljs.core.PersistentHashMap.EMPTY;
var inst_78785 = [true,inst_78784];
var inst_78786 = cljs.core.PersistentHashMap.fromArrays(inst_78783,inst_78785);
var inst_78787 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_78786,inst_78778);
var state_78844__$1 = state_78844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78844__$1,(22),inst_78787);
} else {
if((state_val_78845 === (27))){
var inst_78832 = (state_78844[(2)]);
var state_78844__$1 = state_78844;
var statearr_78848_78901 = state_78844__$1;
(statearr_78848_78901[(2)] = inst_78832);

(statearr_78848_78901[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (1))){
var state_78844__$1 = state_78844;
var statearr_78849_78902 = state_78844__$1;
(statearr_78849_78902[(2)] = null);

(statearr_78849_78902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (24))){
var inst_78796 = (state_78844[(13)]);
var inst_78834 = (state_78844[(2)]);
var inst_78835 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_78836 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_78837 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_78838 = [inst_78836,inst_78837,inst_78796,inst_78834];
var inst_78839 = cljs.core.PersistentHashMap.fromArrays(inst_78835,inst_78838);
var _ = (function (){var statearr_78851 = state_78844;
(statearr_78851[(4)] = cljs.core.rest((state_78844[(4)])));

return statearr_78851;
})();
var state_78844__$1 = state_78844;
var statearr_78852_78903 = state_78844__$1;
(statearr_78852_78903[(2)] = inst_78839);

(statearr_78852_78903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (4))){
var inst_78697 = (state_78844[(2)]);
var state_78844__$1 = state_78844;
var statearr_78853_78904 = state_78844__$1;
(statearr_78853_78904[(2)] = inst_78697);

(statearr_78853_78904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (15))){
var inst_78720 = (state_78844[(14)]);
var inst_78715 = (state_78844[(15)]);
var inst_78727 = (state_78844[(16)]);
var inst_78737 = (state_78844[(17)]);
var inst_78728 = (state_78844[(18)]);
var inst_78716 = (state_78844[(19)]);
var inst_78721 = (state_78844[(20)]);
var inst_78735 = (state_78844[(21)]);
var inst_78713 = (state_78844[(22)]);
var inst_78742 = (state_78844[(23)]);
var inst_78719 = (state_78844[(24)]);
var inst_78748 = (function (){var vec__78710 = inst_78713;
var subject = inst_78735;
var flake = inst_78727;
var G__78709 = inst_78719;
var first__78712 = inst_78715;
var first__78725 = inst_78727;
var r = inst_78728;
var asserted_subjects = inst_78720;
var seq__78711 = inst_78716;
var flake_SINGLEQUOTE_ = inst_78742;
var retracted_subjects = inst_78721;
var vec__78723 = inst_78719;
var seq__78724 = inst_78728;
var asserted_QMARK_ = inst_78737;
return (function (p1__78696_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__78696_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_78749 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_78721,inst_78735,inst_78748);
var tmp78850 = inst_78720;
var inst_78719__$1 = inst_78728;
var inst_78720__$1 = tmp78850;
var inst_78721__$1 = inst_78749;
var state_78844__$1 = (function (){var statearr_78854 = state_78844;
(statearr_78854[(14)] = inst_78720__$1);

(statearr_78854[(20)] = inst_78721__$1);

(statearr_78854[(24)] = inst_78719__$1);

return statearr_78854;
})();
var statearr_78855_78905 = state_78844__$1;
(statearr_78855_78905[(2)] = null);

(statearr_78855_78905[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (21))){
var inst_78794 = (state_78844[(2)]);
var state_78844__$1 = state_78844;
var statearr_78856_78906 = state_78844__$1;
(statearr_78856_78906[(2)] = inst_78794);

(statearr_78856_78906[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (13))){
var inst_78737 = (state_78844[(17)]);
var inst_78742 = (state_78844[(2)]);
var state_78844__$1 = (function (){var statearr_78857 = state_78844;
(statearr_78857[(23)] = inst_78742);

return statearr_78857;
})();
if(cljs.core.truth_(inst_78737)){
var statearr_78858_78907 = state_78844__$1;
(statearr_78858_78907[(1)] = (14));

} else {
var statearr_78859_78908 = state_78844__$1;
(statearr_78859_78908[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (22))){
var inst_78772 = (state_78844[(9)]);
var inst_78779 = (state_78844[(25)]);
var inst_78789 = (state_78844[(2)]);
var inst_78790 = fluree.db.util.async.throw_err(inst_78789);
var inst_78791 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_78772,inst_78790);
var inst_78771 = inst_78779;
var inst_78772__$1 = inst_78791;
var state_78844__$1 = (function (){var statearr_78860 = state_78844;
(statearr_78860[(7)] = inst_78771);

(statearr_78860[(9)] = inst_78772__$1);

return statearr_78860;
})();
var statearr_78861_78909 = state_78844__$1;
(statearr_78861_78909[(2)] = null);

(statearr_78861_78909[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (6))){
var inst_78727 = (state_78844[(16)]);
var inst_78719 = (state_78844[(24)]);
var inst_78726 = cljs.core.seq(inst_78719);
var inst_78727__$1 = cljs.core.first(inst_78726);
var inst_78728 = cljs.core.next(inst_78726);
var inst_78729 = cljs.core.not(inst_78727__$1);
var state_78844__$1 = (function (){var statearr_78862 = state_78844;
(statearr_78862[(16)] = inst_78727__$1);

(statearr_78862[(18)] = inst_78728);

return statearr_78862;
})();
if(inst_78729){
var statearr_78863_78910 = state_78844__$1;
(statearr_78863_78910[(1)] = (8));

} else {
var statearr_78864_78911 = state_78844__$1;
(statearr_78864_78911[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (28))){
var inst_78810 = (state_78844[(26)]);
var inst_78817 = (state_78844[(27)]);
var inst_78827 = (state_78844[(2)]);
var inst_78828 = fluree.db.util.async.throw_err(inst_78827);
var inst_78829 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_78810,inst_78828);
var inst_78809 = inst_78817;
var inst_78810__$1 = inst_78829;
var state_78844__$1 = (function (){var statearr_78865 = state_78844;
(statearr_78865[(26)] = inst_78810__$1);

(statearr_78865[(28)] = inst_78809);

return statearr_78865;
})();
var statearr_78866_78912 = state_78844__$1;
(statearr_78866_78912[(2)] = null);

(statearr_78866_78912[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (25))){
var inst_78810 = (state_78844[(26)]);
var state_78844__$1 = state_78844;
var statearr_78867_78913 = state_78844__$1;
(statearr_78867_78913[(2)] = inst_78810);

(statearr_78867_78913[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (17))){
var inst_78771 = (state_78844[(7)]);
var inst_78778 = (state_78844[(12)]);
var inst_78777 = cljs.core.seq(inst_78771);
var inst_78778__$1 = cljs.core.first(inst_78777);
var inst_78779 = cljs.core.next(inst_78777);
var inst_78780 = cljs.core.not(inst_78778__$1);
var state_78844__$1 = (function (){var statearr_78868 = state_78844;
(statearr_78868[(12)] = inst_78778__$1);

(statearr_78868[(25)] = inst_78779);

return statearr_78868;
})();
if(inst_78780){
var statearr_78869_78914 = state_78844__$1;
(statearr_78869_78914[(1)] = (19));

} else {
var statearr_78870_78915 = state_78844__$1;
(statearr_78870_78915[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (3))){
var inst_78842 = (state_78844[(2)]);
var state_78844__$1 = state_78844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78844__$1,inst_78842);
} else {
if((state_val_78845 === (12))){
var inst_78727 = (state_78844[(16)]);
var inst_78740 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_78727);
var state_78844__$1 = state_78844;
var statearr_78871_78916 = state_78844__$1;
(statearr_78871_78916[(2)] = inst_78740);

(statearr_78871_78916[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (2))){
var inst_78713 = (state_78844[(22)]);
var _ = (function (){var statearr_78872 = state_78844;
(statearr_78872[(4)] = cljs.core.cons((5),(state_78844[(4)])));

return statearr_78872;
})();
var inst_78713__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_78714 = cljs.core.seq(inst_78713__$1);
var inst_78715 = cljs.core.first(inst_78714);
var inst_78716 = cljs.core.next(inst_78714);
var inst_78717 = cljs.core.PersistentHashMap.EMPTY;
var inst_78718 = cljs.core.PersistentHashMap.EMPTY;
var inst_78719 = inst_78713__$1;
var inst_78720 = inst_78717;
var inst_78721 = inst_78718;
var state_78844__$1 = (function (){var statearr_78873 = state_78844;
(statearr_78873[(14)] = inst_78720);

(statearr_78873[(15)] = inst_78715);

(statearr_78873[(19)] = inst_78716);

(statearr_78873[(20)] = inst_78721);

(statearr_78873[(22)] = inst_78713__$1);

(statearr_78873[(24)] = inst_78719);

return statearr_78873;
})();
var statearr_78874_78917 = state_78844__$1;
(statearr_78874_78917[(2)] = null);

(statearr_78874_78917[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (23))){
var inst_78809 = (state_78844[(28)]);
var inst_78816 = (state_78844[(29)]);
var inst_78815 = cljs.core.seq(inst_78809);
var inst_78816__$1 = cljs.core.first(inst_78815);
var inst_78817 = cljs.core.next(inst_78815);
var inst_78818 = cljs.core.not(inst_78816__$1);
var state_78844__$1 = (function (){var statearr_78875 = state_78844;
(statearr_78875[(27)] = inst_78817);

(statearr_78875[(29)] = inst_78816__$1);

return statearr_78875;
})();
if(inst_78818){
var statearr_78876_78918 = state_78844__$1;
(statearr_78876_78918[(1)] = (25));

} else {
var statearr_78877_78919 = state_78844__$1;
(statearr_78877_78919[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (19))){
var inst_78772 = (state_78844[(9)]);
var state_78844__$1 = state_78844;
var statearr_78878_78920 = state_78844__$1;
(statearr_78878_78920[(2)] = inst_78772);

(statearr_78878_78920[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (11))){
var inst_78727 = (state_78844[(16)]);
var state_78844__$1 = state_78844;
var statearr_78880_78921 = state_78844__$1;
(statearr_78880_78921[(2)] = inst_78727);

(statearr_78880_78921[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (9))){
var inst_78727 = (state_78844[(16)]);
var inst_78737 = (state_78844[(17)]);
var inst_78735 = inst_78727.s;
var inst_78736 = inst_78727.op;
var inst_78737__$1 = inst_78736 === true;
var state_78844__$1 = (function (){var statearr_78882 = state_78844;
(statearr_78882[(17)] = inst_78737__$1);

(statearr_78882[(21)] = inst_78735);

return statearr_78882;
})();
if(cljs.core.truth_(inst_78737__$1)){
var statearr_78883_78922 = state_78844__$1;
(statearr_78883_78922[(1)] = (11));

} else {
var statearr_78884_78923 = state_78844__$1;
(statearr_78884_78923[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (5))){
var _ = (function (){var statearr_78885 = state_78844;
(statearr_78885[(4)] = cljs.core.rest((state_78844[(4)])));

return statearr_78885;
})();
var state_78844__$1 = state_78844;
var ex78879 = (state_78844__$1[(2)]);
var statearr_78886_78924 = state_78844__$1;
(statearr_78886_78924[(5)] = ex78879);


if((ex78879 instanceof Error)){
var statearr_78887_78925 = state_78844__$1;
(statearr_78887_78925[(1)] = (4));

(statearr_78887_78925[(5)] = null);

} else {
throw ex78879;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (14))){
var inst_78720 = (state_78844[(14)]);
var inst_78715 = (state_78844[(15)]);
var inst_78727 = (state_78844[(16)]);
var inst_78737 = (state_78844[(17)]);
var inst_78728 = (state_78844[(18)]);
var inst_78716 = (state_78844[(19)]);
var inst_78721 = (state_78844[(20)]);
var inst_78735 = (state_78844[(21)]);
var inst_78713 = (state_78844[(22)]);
var inst_78742 = (state_78844[(23)]);
var inst_78719 = (state_78844[(24)]);
var inst_78744 = (function (){var vec__78710 = inst_78713;
var subject = inst_78735;
var flake = inst_78727;
var G__78709 = inst_78719;
var first__78712 = inst_78715;
var first__78725 = inst_78727;
var r = inst_78728;
var asserted_subjects = inst_78720;
var seq__78711 = inst_78716;
var flake_SINGLEQUOTE_ = inst_78742;
var retracted_subjects = inst_78721;
var vec__78723 = inst_78719;
var seq__78724 = inst_78728;
var asserted_QMARK_ = inst_78737;
return (function (p1__78695_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__78695_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_78745 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_78720,inst_78735,inst_78744);
var tmp78881 = inst_78721;
var inst_78719__$1 = inst_78728;
var inst_78720__$1 = inst_78745;
var inst_78721__$1 = tmp78881;
var state_78844__$1 = (function (){var statearr_78888 = state_78844;
(statearr_78888[(14)] = inst_78720__$1);

(statearr_78888[(20)] = inst_78721__$1);

(statearr_78888[(24)] = inst_78719__$1);

return statearr_78888;
})();
var statearr_78889_78926 = state_78844__$1;
(statearr_78889_78926[(2)] = null);

(statearr_78889_78926[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (26))){
var inst_78816 = (state_78844[(29)]);
var inst_78821 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_78822 = cljs.core.PersistentHashMap.EMPTY;
var inst_78823 = [true,inst_78822];
var inst_78824 = cljs.core.PersistentHashMap.fromArrays(inst_78821,inst_78823);
var inst_78825 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_78824,inst_78816);
var state_78844__$1 = state_78844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78844__$1,(28),inst_78825);
} else {
if((state_val_78845 === (16))){
var inst_78752 = (state_78844[(2)]);
var state_78844__$1 = state_78844;
var statearr_78890_78927 = state_78844__$1;
(statearr_78890_78927[(2)] = inst_78752);

(statearr_78890_78927[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (10))){
var inst_78754 = (state_78844[(2)]);
var state_78844__$1 = state_78844;
var statearr_78891_78928 = state_78844__$1;
(statearr_78891_78928[(2)] = inst_78754);

(statearr_78891_78928[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (18))){
var inst_78757 = (state_78844[(8)]);
var inst_78796 = (state_78844[(2)]);
var inst_78804 = cljs.core.vals(inst_78757);
var inst_78805 = cljs.core.seq(inst_78804);
var inst_78806 = cljs.core.first(inst_78805);
var inst_78807 = cljs.core.next(inst_78805);
var inst_78808 = cljs.core.PersistentVector.EMPTY;
var inst_78809 = inst_78804;
var inst_78810 = inst_78808;
var state_78844__$1 = (function (){var statearr_78892 = state_78844;
(statearr_78892[(30)] = inst_78806);

(statearr_78892[(26)] = inst_78810);

(statearr_78892[(13)] = inst_78796);

(statearr_78892[(31)] = inst_78807);

(statearr_78892[(28)] = inst_78809);

return statearr_78892;
})();
var statearr_78893_78929 = state_78844__$1;
(statearr_78893_78929[(2)] = null);

(statearr_78893_78929[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (8))){
var inst_78720 = (state_78844[(14)]);
var inst_78721 = (state_78844[(20)]);
var inst_78731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78732 = [inst_78720,inst_78721];
var inst_78733 = (new cljs.core.PersistentVector(null,2,(5),inst_78731,inst_78732,null));
var state_78844__$1 = state_78844;
var statearr_78894_78930 = state_78844__$1;
(statearr_78894_78930[(2)] = inst_78733);

(statearr_78894_78930[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__17178__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__17178__auto____0 = (function (){
var statearr_78895 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78895[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__17178__auto__);

(statearr_78895[(1)] = (1));

return statearr_78895;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__17178__auto____1 = (function (state_78844){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_78844);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e78896){var ex__17181__auto__ = e78896;
var statearr_78897_78931 = state_78844;
(statearr_78897_78931[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_78844[(4)]))){
var statearr_78898_78932 = state_78844;
(statearr_78898_78932[(1)] = cljs.core.first((state_78844[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78933 = state_78844;
state_78844 = G__78933;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__17178__auto__ = function(state_78844){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__17178__auto____1.call(this,state_78844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__17178__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__17178__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_78899 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_78899[(6)] = c__17304__auto__);

return statearr_78899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_78965){
var state_val_78966 = (state_78965[(1)]);
if((state_val_78966 === (1))){
var inst_78934 = cljs.core.volatile_BANG_((0));
var inst_78935 = cljs.core.PersistentHashMap.EMPTY;
var inst_78936 = cljs.core.volatile_BANG_(inst_78935);
var inst_78937 = cljs.core.first(resp);
var inst_78938 = cljs.core.rest(resp);
var inst_78939 = cljs.core.PersistentVector.EMPTY;
var inst_78940 = inst_78934;
var inst_78941 = inst_78936;
var inst_78942 = inst_78937;
var inst_78943 = inst_78938;
var inst_78944 = inst_78939;
var state_78965__$1 = (function (){var statearr_78967 = state_78965;
(statearr_78967[(7)] = inst_78940);

(statearr_78967[(8)] = inst_78944);

(statearr_78967[(9)] = inst_78943);

(statearr_78967[(10)] = inst_78941);

(statearr_78967[(11)] = inst_78942);

return statearr_78967;
})();
var statearr_78968_78983 = state_78965__$1;
(statearr_78968_78983[(2)] = null);

(statearr_78968_78983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78966 === (2))){
var inst_78940 = (state_78965[(7)]);
var inst_78941 = (state_78965[(10)]);
var inst_78942 = (state_78965[(11)]);
var inst_78946 = fluree.db.api.query.format_block_resp_pretty(db,inst_78942,inst_78941,inst_78940);
var state_78965__$1 = state_78965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78965__$1,(4),inst_78946);
} else {
if((state_val_78966 === (3))){
var inst_78963 = (state_78965[(2)]);
var state_78965__$1 = state_78965;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78965__$1,inst_78963);
} else {
if((state_val_78966 === (4))){
var inst_78944 = (state_78965[(8)]);
var inst_78943 = (state_78965[(9)]);
var inst_78948 = (state_78965[(2)]);
var inst_78949 = fluree.db.util.async.throw_err(inst_78948);
var inst_78950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78951 = [inst_78949];
var inst_78952 = (new cljs.core.PersistentVector(null,1,(5),inst_78950,inst_78951,null));
var inst_78953 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_78944,inst_78952);
var inst_78954 = cljs.core.first(inst_78943);
var state_78965__$1 = (function (){var statearr_78971 = state_78965;
(statearr_78971[(12)] = inst_78953);

return statearr_78971;
})();
if(cljs.core.truth_(inst_78954)){
var statearr_78972_78984 = state_78965__$1;
(statearr_78972_78984[(1)] = (5));

} else {
var statearr_78973_78985 = state_78965__$1;
(statearr_78973_78985[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78966 === (5))){
var inst_78940 = (state_78965[(7)]);
var inst_78943 = (state_78965[(9)]);
var inst_78941 = (state_78965[(10)]);
var inst_78953 = (state_78965[(12)]);
var inst_78956 = cljs.core.first(inst_78943);
var inst_78957 = cljs.core.rest(inst_78943);
var tmp78969 = inst_78940;
var tmp78970 = inst_78941;
var inst_78940__$1 = tmp78969;
var inst_78941__$1 = tmp78970;
var inst_78942 = inst_78956;
var inst_78943__$1 = inst_78957;
var inst_78944 = inst_78953;
var state_78965__$1 = (function (){var statearr_78974 = state_78965;
(statearr_78974[(7)] = inst_78940__$1);

(statearr_78974[(8)] = inst_78944);

(statearr_78974[(9)] = inst_78943__$1);

(statearr_78974[(10)] = inst_78941__$1);

(statearr_78974[(11)] = inst_78942);

return statearr_78974;
})();
var statearr_78975_78986 = state_78965__$1;
(statearr_78975_78986[(2)] = null);

(statearr_78975_78986[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78966 === (6))){
var inst_78953 = (state_78965[(12)]);
var state_78965__$1 = state_78965;
var statearr_78976_78987 = state_78965__$1;
(statearr_78976_78987[(2)] = inst_78953);

(statearr_78976_78987[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78966 === (7))){
var inst_78961 = (state_78965[(2)]);
var state_78965__$1 = state_78965;
var statearr_78977_78988 = state_78965__$1;
(statearr_78977_78988[(2)] = inst_78961);

(statearr_78977_78988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__17178__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__17178__auto____0 = (function (){
var statearr_78978 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78978[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__17178__auto__);

(statearr_78978[(1)] = (1));

return statearr_78978;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__17178__auto____1 = (function (state_78965){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_78965);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e78979){var ex__17181__auto__ = e78979;
var statearr_78980_78989 = state_78965;
(statearr_78980_78989[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_78965[(4)]))){
var statearr_78981_78990 = state_78965;
(statearr_78981_78990[(1)] = cljs.core.first((state_78965[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78991 = state_78965;
state_78965 = G__78991;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__17178__auto__ = function(state_78965){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__17178__auto____1.call(this,state_78965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__17178__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__17178__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_78982 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_78982[(6)] = c__17304__auto__);

return statearr_78982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__78993 = arguments.length;
switch (G__78993) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__78995){
var map__78996 = p__78995;
var map__78996__$1 = cljs.core.__destructure_map(map__78996);
var query = map__78996__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78996__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_79081){
var state_val_79082 = (state_79081[(1)]);
if((state_val_79082 === (7))){
var inst_79007 = (state_79081[(7)]);
var inst_79011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79012 = ["_auth/id",inst_79007];
var inst_79013 = (new cljs.core.PersistentVector(null,2,(5),inst_79011,inst_79012,null));
var state_79081__$1 = state_79081;
var statearr_79083_79127 = state_79081__$1;
(statearr_79083_79127[(2)] = inst_79013);

(statearr_79083_79127[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (20))){
var inst_79061 = (state_79081[(2)]);
var inst_79062 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_79081__$1 = (function (){var statearr_79084 = state_79081;
(statearr_79084[(8)] = inst_79061);

return statearr_79084;
})();
if(cljs.core.truth_(inst_79062)){
var statearr_79085_79128 = state_79081__$1;
(statearr_79085_79128[(1)] = (22));

} else {
var statearr_79086_79129 = state_79081__$1;
(statearr_79086_79129[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (27))){
var inst_79064 = (state_79081[(9)]);
var inst_79008 = (state_79081[(10)]);
var inst_79070 = (state_79081[(2)]);
var inst_79071 = fluree.db.util.core.response_time_formatted(inst_79008);
var inst_79072 = [(200),inst_79070,(100),inst_79071];
var inst_79073 = cljs.core.PersistentHashMap.fromArrays(inst_79064,inst_79072);
var state_79081__$1 = state_79081;
var statearr_79087_79130 = state_79081__$1;
(statearr_79087_79130[(2)] = inst_79073);

(statearr_79087_79130[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (1))){
var state_79081__$1 = state_79081;
var statearr_79088_79131 = state_79081__$1;
(statearr_79088_79131[(2)] = null);

(statearr_79088_79131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (24))){
var inst_79076 = (state_79081[(2)]);
var _ = (function (){var statearr_79089 = state_79081;
(statearr_79089[(4)] = cljs.core.rest((state_79081[(4)])));

return statearr_79089;
})();
var state_79081__$1 = state_79081;
var statearr_79090_79132 = state_79081__$1;
(statearr_79090_79132[(2)] = inst_79076);

(statearr_79090_79132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (4))){
var inst_78997 = (state_79081[(2)]);
var state_79081__$1 = state_79081;
var statearr_79091_79133 = state_79081__$1;
(statearr_79091_79133[(2)] = inst_78997);

(statearr_79091_79133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (15))){
var inst_79048 = (state_79081[(11)]);
var state_79081__$1 = state_79081;
var statearr_79092_79134 = state_79081__$1;
(statearr_79092_79134[(2)] = inst_79048);

(statearr_79092_79134[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (21))){
var inst_79057 = (state_79081[(2)]);
var inst_79058 = fluree.db.util.async.throw_err(inst_79057);
var state_79081__$1 = state_79081;
var statearr_79093_79135 = state_79081__$1;
(statearr_79093_79135[(2)] = inst_79058);

(statearr_79093_79135[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (13))){
var inst_79048 = (state_79081[(11)]);
var inst_79006 = (state_79081[(12)]);
var inst_79047 = (state_79081[(2)]);
var inst_79048__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_79006);
var state_79081__$1 = (function (){var statearr_79094 = state_79081;
(statearr_79094[(11)] = inst_79048__$1);

(statearr_79094[(13)] = inst_79047);

return statearr_79094;
})();
if(cljs.core.truth_(inst_79048__$1)){
var statearr_79095_79136 = state_79081__$1;
(statearr_79095_79136[(1)] = (15));

} else {
var statearr_79096_79137 = state_79081__$1;
(statearr_79096_79137[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (22))){
var inst_79061 = (state_79081[(8)]);
var inst_79064 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_79065 = cljs.core.sequential_QMARK_(inst_79061);
var state_79081__$1 = (function (){var statearr_79097 = state_79081;
(statearr_79097[(9)] = inst_79064);

return statearr_79097;
})();
if(inst_79065){
var statearr_79098_79138 = state_79081__$1;
(statearr_79098_79138[(1)] = (25));

} else {
var statearr_79099_79139 = state_79081__$1;
(statearr_79099_79139[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (6))){
var inst_79006 = (state_79081[(12)]);
var inst_79022 = (state_79081[(14)]);
var inst_79021 = (state_79081[(2)]);
var inst_79022__$1 = fluree.db.util.async.throw_err(inst_79021);
var inst_79023 = fluree.db.api.query.resolve_block_range(inst_79022__$1,inst_79006);
var state_79081__$1 = (function (){var statearr_79100 = state_79081;
(statearr_79100[(14)] = inst_79022__$1);

return statearr_79100;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79081__$1,(10),inst_79023);
} else {
if((state_val_79082 === (25))){
var inst_79061 = (state_79081[(8)]);
var inst_79067 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_79061);
var state_79081__$1 = state_79081;
var statearr_79101_79140 = state_79081__$1;
(statearr_79101_79140[(2)] = inst_79067);

(statearr_79101_79140[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (17))){
var inst_79053 = (state_79081[(2)]);
var state_79081__$1 = state_79081;
if(cljs.core.truth_(inst_79053)){
var statearr_79102_79141 = state_79081__$1;
(statearr_79102_79141[(1)] = (18));

} else {
var statearr_79103_79142 = state_79081__$1;
(statearr_79103_79142[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (3))){
var inst_79079 = (state_79081[(2)]);
var state_79081__$1 = state_79081;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79081__$1,inst_79079);
} else {
if((state_val_79082 === (12))){
var inst_79006 = (state_79081[(12)]);
var inst_79039 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79006], 0));
var inst_79040 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_79039].join('');
var inst_79041 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79042 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_79043 = cljs.core.PersistentHashMap.fromArrays(inst_79041,inst_79042);
var inst_79044 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_79040,inst_79043);
var inst_79045 = (function(){throw inst_79044})();
var state_79081__$1 = state_79081;
var statearr_79104_79143 = state_79081__$1;
(statearr_79104_79143[(2)] = inst_79045);

(statearr_79104_79143[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (2))){
var inst_79007 = (state_79081[(7)]);
var _ = (function (){var statearr_79105 = state_79081;
(statearr_79105[(4)] = cljs.core.cons((5),(state_79081[(4)])));

return statearr_79105;
})();
var inst_79006 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_79007__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_79008 = fluree.db.util.core.current_time_millis();
var inst_79009 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_79081__$1 = (function (){var statearr_79106 = state_79081;
(statearr_79106[(7)] = inst_79007__$1);

(statearr_79106[(12)] = inst_79006);

(statearr_79106[(15)] = inst_79009);

(statearr_79106[(10)] = inst_79008);

return statearr_79106;
})();
if(cljs.core.truth_(inst_79007__$1)){
var statearr_79107_79144 = state_79081__$1;
(statearr_79107_79144[(1)] = (7));

} else {
var statearr_79108_79145 = state_79081__$1;
(statearr_79108_79145[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (23))){
var inst_79061 = (state_79081[(8)]);
var state_79081__$1 = state_79081;
var statearr_79109_79146 = state_79081__$1;
(statearr_79109_79146[(2)] = inst_79061);

(statearr_79109_79146[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (19))){
var inst_79047 = (state_79081[(13)]);
var state_79081__$1 = state_79081;
var statearr_79110_79147 = state_79081__$1;
(statearr_79110_79147[(2)] = inst_79047);

(statearr_79110_79147[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (11))){
var inst_79027 = (state_79081[(16)]);
var inst_79028 = (state_79081[(17)]);
var inst_79022 = (state_79081[(14)]);
var inst_79034 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_79022,inst_79027,inst_79028,opts);
var state_79081__$1 = state_79081;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79081__$1,(14),inst_79034);
} else {
if((state_val_79082 === (9))){
var inst_79009 = (state_79081[(15)]);
var inst_79016 = (state_79081[(2)]);
var inst_79017 = [inst_79016];
var inst_79018 = cljs.core.PersistentHashMap.fromArrays(inst_79009,inst_79017);
var inst_79019 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_79018);
var state_79081__$1 = state_79081;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79081__$1,(6),inst_79019);
} else {
if((state_val_79082 === (5))){
var _ = (function (){var statearr_79112 = state_79081;
(statearr_79112[(4)] = cljs.core.rest((state_79081[(4)])));

return statearr_79112;
})();
var state_79081__$1 = state_79081;
var ex79111 = (state_79081__$1[(2)]);
var statearr_79113_79148 = state_79081__$1;
(statearr_79113_79148[(5)] = ex79111);


if((ex79111 instanceof Error)){
var statearr_79114_79149 = state_79081__$1;
(statearr_79114_79149[(1)] = (4));

(statearr_79114_79149[(5)] = null);

} else {
throw ex79111;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (14))){
var inst_79036 = (state_79081[(2)]);
var inst_79037 = fluree.db.util.async.throw_err(inst_79036);
var state_79081__$1 = state_79081;
var statearr_79115_79150 = state_79081__$1;
(statearr_79115_79150[(2)] = inst_79037);

(statearr_79115_79150[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (26))){
var inst_79061 = (state_79081[(8)]);
var state_79081__$1 = state_79081;
var statearr_79116_79151 = state_79081__$1;
(statearr_79116_79151[(2)] = inst_79061);

(statearr_79116_79151[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (16))){
var inst_79006 = (state_79081[(12)]);
var inst_79051 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_79006);
var state_79081__$1 = state_79081;
var statearr_79117_79152 = state_79081__$1;
(statearr_79117_79152[(2)] = inst_79051);

(statearr_79117_79152[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (10))){
var inst_79006 = (state_79081[(12)]);
var inst_79025 = (state_79081[(2)]);
var inst_79026 = fluree.db.util.async.throw_err(inst_79025);
var inst_79027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79026,(0),null);
var inst_79028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79026,(1),null);
var inst_79029 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_79030 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_79006,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_79031 = cljs.core.keys(inst_79030);
var inst_79032 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_79029,inst_79031);
var state_79081__$1 = (function (){var statearr_79118 = state_79081;
(statearr_79118[(16)] = inst_79027);

(statearr_79118[(17)] = inst_79028);

return statearr_79118;
})();
if(inst_79032){
var statearr_79119_79153 = state_79081__$1;
(statearr_79119_79153[(1)] = (11));

} else {
var statearr_79120_79154 = state_79081__$1;
(statearr_79120_79154[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79082 === (18))){
var inst_79022 = (state_79081[(14)]);
var inst_79047 = (state_79081[(13)]);
var inst_79055 = fluree.db.api.query.format_blocks_resp_pretty(inst_79022,inst_79047);
var state_79081__$1 = state_79081;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79081__$1,(21),inst_79055);
} else {
if((state_val_79082 === (8))){
var state_79081__$1 = state_79081;
var statearr_79121_79155 = state_79081__$1;
(statearr_79121_79155[(2)] = null);

(statearr_79121_79155[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__17178__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__17178__auto____0 = (function (){
var statearr_79122 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79122[(0)] = fluree$db$api$query$block_query_async_$_state_machine__17178__auto__);

(statearr_79122[(1)] = (1));

return statearr_79122;
});
var fluree$db$api$query$block_query_async_$_state_machine__17178__auto____1 = (function (state_79081){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_79081);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e79123){var ex__17181__auto__ = e79123;
var statearr_79124_79156 = state_79081;
(statearr_79124_79156[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_79081[(4)]))){
var statearr_79125_79157 = state_79081;
(statearr_79125_79157[(1)] = cljs.core.first((state_79081[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79158 = state_79081;
state_79081 = G__79158;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__17178__auto__ = function(state_79081){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__17178__auto____1.call(this,state_79081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__17178__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__17178__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_79126 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_79126[(6)] = c__17304__auto__);

return statearr_79126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__79159 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__79159,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__79159,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__79159,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__79159,(3),null);
var vec__79162 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__79162,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__79162,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__79165 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__79165,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__79165,(1),null);
var or__4212__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4824__auto__ = [];
var len__4818__auto___79169 = arguments.length;
var i__4819__auto___79170 = (0);
while(true){
if((i__4819__auto___79170 < len__4818__auto___79169)){
args__4824__auto__.push((arguments[i__4819__auto___79170]));

var G__79171 = (i__4819__auto___79170 + (1));
i__4819__auto___79170 = G__79171;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq79168){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq79168));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_79367){
var state_val_79368 = (state_79367[(1)]);
if((state_val_79368 === (7))){
var inst_79294 = (state_79367[(7)]);
var inst_79287 = (state_79367[(8)]);
var inst_79293 = cljs.core.seq(inst_79287);
var inst_79294__$1 = cljs.core.first(inst_79293);
var inst_79295 = cljs.core.next(inst_79293);
var state_79367__$1 = (function (){var statearr_79369 = state_79367;
(statearr_79369[(7)] = inst_79294__$1);

(statearr_79369[(9)] = inst_79295);

return statearr_79369;
})();
if(cljs.core.truth_(inst_79294__$1)){
var statearr_79370_79470 = state_79367__$1;
(statearr_79370_79470[(1)] = (9));

} else {
var statearr_79371_79471 = state_79367__$1;
(statearr_79371_79471[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (20))){
var inst_79357 = (state_79367[(2)]);
var state_79367__$1 = state_79367;
var statearr_79372_79472 = state_79367__$1;
(statearr_79372_79472[(2)] = inst_79357);

(statearr_79372_79472[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (27))){
var inst_79333 = (state_79367[(10)]);
var inst_79315 = (state_79367[(11)]);
var inst_79312 = (state_79367[(12)]);
var inst_79335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79336 = [inst_79315,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_79337 = (new cljs.core.PersistentVector(null,2,(5),inst_79335,inst_79336,null));
var inst_79338 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_79333,inst_79337,fluree.db.api.query.min_safe,inst_79312);
var state_79367__$1 = state_79367;
var statearr_79373_79473 = state_79367__$1;
(statearr_79373_79473[(2)] = inst_79338);

(statearr_79373_79473[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (1))){
var state_79367__$1 = state_79367;
var statearr_79374_79474 = state_79367__$1;
(statearr_79374_79474[(2)] = null);

(statearr_79374_79474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (24))){
var inst_79294 = (state_79367[(7)]);
var inst_79315 = (state_79367[(11)]);
var inst_79325 = (state_79367[(13)]);
var inst_79327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79328 = [inst_79315,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_79329 = (new cljs.core.PersistentVector(null,2,(5),inst_79327,inst_79328,null));
var inst_79330 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_79325,inst_79329,cljs.core.conj,inst_79294);
var state_79367__$1 = state_79367;
var statearr_79376_79475 = state_79367__$1;
(statearr_79376_79475[(2)] = inst_79330);

(statearr_79376_79475[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (4))){
var inst_79173 = (state_79367[(2)]);
var state_79367__$1 = state_79367;
var statearr_79377_79476 = state_79367__$1;
(statearr_79377_79476[(2)] = inst_79173);

(statearr_79377_79476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (15))){
var inst_79288 = (state_79367[(14)]);
var inst_79295 = (state_79367[(9)]);
var tmp79375 = inst_79288;
var inst_79287 = inst_79295;
var inst_79288__$1 = tmp79375;
var state_79367__$1 = (function (){var statearr_79378 = state_79367;
(statearr_79378[(14)] = inst_79288__$1);

(statearr_79378[(8)] = inst_79287);

return statearr_79378;
})();
var statearr_79379_79477 = state_79367__$1;
(statearr_79379_79477[(2)] = null);

(statearr_79379_79477[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (21))){
var inst_79288 = (state_79367[(14)]);
var inst_79315 = (state_79367[(11)]);
var inst_79319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79320 = [inst_79315,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_79321 = (new cljs.core.PersistentVector(null,2,(5),inst_79319,inst_79320,null));
var inst_79322 = cljs.core.assoc_in(inst_79288,inst_79321,inst_79315);
var state_79367__$1 = state_79367;
var statearr_79380_79478 = state_79367__$1;
(statearr_79380_79478[(2)] = inst_79322);

(statearr_79380_79478[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (31))){
var inst_79341 = (state_79367[(15)]);
var state_79367__$1 = state_79367;
var statearr_79381_79479 = state_79367__$1;
(statearr_79381_79479[(2)] = inst_79341);

(statearr_79381_79479[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (32))){
var inst_79295 = (state_79367[(9)]);
var inst_79349 = (state_79367[(2)]);
var inst_79287 = inst_79295;
var inst_79288 = inst_79349;
var state_79367__$1 = (function (){var statearr_79382 = state_79367;
(statearr_79382[(14)] = inst_79288);

(statearr_79382[(8)] = inst_79287);

return statearr_79382;
})();
var statearr_79383_79480 = state_79367__$1;
(statearr_79383_79480[(2)] = null);

(statearr_79383_79480[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (33))){
var inst_79288 = (state_79367[(14)]);
var state_79367__$1 = state_79367;
var statearr_79384_79481 = state_79367__$1;
(statearr_79384_79481[(2)] = inst_79288);

(statearr_79384_79481[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (13))){
var inst_79297 = (state_79367[(16)]);
var state_79367__$1 = state_79367;
var statearr_79385_79482 = state_79367__$1;
(statearr_79385_79482[(2)] = inst_79297);

(statearr_79385_79482[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (22))){
var inst_79288 = (state_79367[(14)]);
var state_79367__$1 = state_79367;
var statearr_79386_79483 = state_79367__$1;
(statearr_79386_79483[(2)] = inst_79288);

(statearr_79386_79483[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (29))){
var inst_79341 = (state_79367[(2)]);
var state_79367__$1 = (function (){var statearr_79387 = state_79367;
(statearr_79387[(15)] = inst_79341);

return statearr_79387;
})();
if(cljs.core.truth_(show_auth)){
var statearr_79388_79484 = state_79367__$1;
(statearr_79388_79484[(1)] = (30));

} else {
var statearr_79389_79485 = state_79367__$1;
(statearr_79389_79485[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (6))){
var inst_79273 = (state_79367[(2)]);
var inst_79274 = fluree.db.util.async.throw_err(inst_79273);
var inst_79282 = resp;
var inst_79283 = cljs.core.seq(inst_79282);
var inst_79284 = cljs.core.first(inst_79283);
var inst_79285 = cljs.core.next(inst_79283);
var inst_79286 = cljs.core.PersistentHashMap.EMPTY;
var inst_79287 = inst_79282;
var inst_79288 = inst_79286;
var state_79367__$1 = (function (){var statearr_79390 = state_79367;
(statearr_79390[(17)] = inst_79285);

(statearr_79390[(14)] = inst_79288);

(statearr_79390[(8)] = inst_79287);

(statearr_79390[(18)] = inst_79284);

(statearr_79390[(19)] = inst_79274);

return statearr_79390;
})();
var statearr_79391_79486 = state_79367__$1;
(statearr_79391_79486[(2)] = null);

(statearr_79391_79486[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (28))){
var inst_79333 = (state_79367[(10)]);
var state_79367__$1 = state_79367;
var statearr_79392_79487 = state_79367__$1;
(statearr_79392_79487[(2)] = inst_79333);

(statearr_79392_79487[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (25))){
var inst_79325 = (state_79367[(13)]);
var state_79367__$1 = state_79367;
var statearr_79393_79488 = state_79367__$1;
(statearr_79393_79488[(2)] = inst_79325);

(statearr_79393_79488[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (34))){
var state_79367__$1 = state_79367;
var statearr_79394_79489 = state_79367__$1;
(statearr_79394_79489[(2)] = null);

(statearr_79394_79489[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (17))){
var inst_79359 = (state_79367[(2)]);
var state_79367__$1 = state_79367;
var statearr_79395_79490 = state_79367__$1;
(statearr_79395_79490[(2)] = inst_79359);

(statearr_79395_79490[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (3))){
var inst_79365 = (state_79367[(2)]);
var state_79367__$1 = state_79367;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79367__$1,inst_79365);
} else {
if((state_val_79368 === (12))){
var inst_79294 = (state_79367[(7)]);
var inst_79274 = (state_79367[(19)]);
var inst_79299 = fluree.db.api.query.auth_match(auth,inst_79274,inst_79294);
var inst_79300 = cljs.core.not(inst_79299);
var state_79367__$1 = state_79367;
var statearr_79396_79491 = state_79367__$1;
(statearr_79396_79491[(2)] = inst_79300);

(statearr_79396_79491[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (2))){
var _ = (function (){var statearr_79397 = state_79367;
(statearr_79397[(4)] = cljs.core.cons((5),(state_79367[(4)])));

return statearr_79397;
})();
var inst_79179 = (function (){return (function (p1__79172_SHARP_){
return p1__79172_SHARP_.t;
});
})();
var inst_79180 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_79179,resp);
var inst_79181 = cljs.core.set(inst_79180);
var inst_79269 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_79270 = (function (){var ts = inst_79181;
var c__17304__auto____$1 = inst_79269;
return (function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_79267){
var state_val_79268 = (state_79267[(1)]);
if((state_val_79268 === (7))){
var inst_79201 = (state_79267[(7)]);
var inst_79195 = (state_79267[(8)]);
var inst_79213 = (state_79267[(9)]);
var inst_79207 = (state_79267[(10)]);
var inst_79206 = (state_79267[(2)]);
var inst_79207__$1 = fluree.db.util.async.throw_err(inst_79206);
var inst_79209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79210 = [inst_79201,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_79211 = (new cljs.core.PersistentVector(null,2,(5),inst_79209,inst_79210,null));
var inst_79212 = cljs.core.assoc_in(inst_79195,inst_79211,inst_79207__$1);
var inst_79213__$1 = auth;
var state_79267__$1 = (function (){var statearr_79398 = state_79267;
(statearr_79398[(9)] = inst_79213__$1);

(statearr_79398[(10)] = inst_79207__$1);

(statearr_79398[(11)] = inst_79212);

return statearr_79398;
})();
if(cljs.core.truth_(inst_79213__$1)){
var statearr_79399_79492 = state_79267__$1;
(statearr_79399_79492[(1)] = (8));

} else {
var statearr_79400_79493 = state_79267__$1;
(statearr_79400_79493[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79268 === (1))){
var inst_79189 = (state_79267[(12)]);
var inst_79189__$1 = ts;
var inst_79190 = cljs.core.seq(inst_79189__$1);
var inst_79191 = cljs.core.first(inst_79190);
var inst_79192 = cljs.core.next(inst_79190);
var inst_79193 = cljs.core.PersistentHashMap.EMPTY;
var inst_79194 = inst_79189__$1;
var inst_79195 = inst_79193;
var state_79267__$1 = (function (){var statearr_79401 = state_79267;
(statearr_79401[(8)] = inst_79195);

(statearr_79401[(12)] = inst_79189__$1);

(statearr_79401[(13)] = inst_79194);

(statearr_79401[(14)] = inst_79191);

(statearr_79401[(15)] = inst_79192);

return statearr_79401;
})();
var statearr_79402_79494 = state_79267__$1;
(statearr_79402_79494[(2)] = null);

(statearr_79402_79494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79268 === (4))){
var inst_79201 = (state_79267[(7)]);
var inst_79204 = fluree.db.time_travel.non_border_t_to_block(db,inst_79201);
var state_79267__$1 = state_79267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79267__$1,(7),inst_79204);
} else {
if((state_val_79268 === (13))){
var inst_79202 = (state_79267[(16)]);
var inst_79259 = (state_79267[(2)]);
var inst_79194 = inst_79202;
var inst_79195 = inst_79259;
var state_79267__$1 = (function (){var statearr_79403 = state_79267;
(statearr_79403[(8)] = inst_79195);

(statearr_79403[(13)] = inst_79194);

return statearr_79403;
})();
var statearr_79404_79495 = state_79267__$1;
(statearr_79404_79495[(2)] = null);

(statearr_79404_79495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79268 === (6))){
var inst_79263 = (state_79267[(2)]);
var state_79267__$1 = state_79267;
var statearr_79405_79496 = state_79267__$1;
(statearr_79405_79496[(2)] = inst_79263);

(statearr_79405_79496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79268 === (3))){
var inst_79265 = (state_79267[(2)]);
var state_79267__$1 = state_79267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79267__$1,inst_79265);
} else {
if((state_val_79268 === (12))){
var inst_79212 = (state_79267[(11)]);
var state_79267__$1 = state_79267;
var statearr_79406_79497 = state_79267__$1;
(statearr_79406_79497[(2)] = inst_79212);

(statearr_79406_79497[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79268 === (2))){
var inst_79201 = (state_79267[(7)]);
var inst_79194 = (state_79267[(13)]);
var inst_79200 = cljs.core.seq(inst_79194);
var inst_79201__$1 = cljs.core.first(inst_79200);
var inst_79202 = cljs.core.next(inst_79200);
var state_79267__$1 = (function (){var statearr_79407 = state_79267;
(statearr_79407[(16)] = inst_79202);

(statearr_79407[(7)] = inst_79201__$1);

return statearr_79407;
})();
if(cljs.core.truth_(inst_79201__$1)){
var statearr_79408_79498 = state_79267__$1;
(statearr_79408_79498[(1)] = (4));

} else {
var statearr_79409_79499 = state_79267__$1;
(statearr_79409_79499[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79268 === (11))){
var inst_79202 = (state_79267[(16)]);
var inst_79201 = (state_79267[(7)]);
var inst_79195 = (state_79267[(8)]);
var inst_79189 = (state_79267[(12)]);
var inst_79194 = (state_79267[(13)]);
var inst_79207 = (state_79267[(10)]);
var inst_79212 = (state_79267[(11)]);
var inst_79191 = (state_79267[(14)]);
var inst_79192 = (state_79267[(15)]);
var inst_79219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79220 = [inst_79201,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_79221 = (new cljs.core.PersistentVector(null,2,(5),inst_79219,inst_79220,null));
var inst_79234 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_79235 = (function (){var vec__79186 = inst_79189;
var t = inst_79201;
var first__79199 = inst_79201;
var G__79208 = inst_79212;
var block = inst_79207;
var r = inst_79202;
var seq__79187 = inst_79192;
var acc = inst_79195;
var first__79188 = inst_79191;
var vec__79197 = inst_79194;
var c__17304__auto____$2 = inst_79234;
var seq__79198 = inst_79202;
var G__79185 = inst_79194;
return (function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_79232){
var state_val_79233 = (state_79232[(1)]);
if((state_val_79233 === (1))){
var state_79232__$1 = state_79232;
var statearr_79410_79500 = state_79232__$1;
(statearr_79410_79500[(2)] = null);

(statearr_79410_79500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79233 === (2))){
var ___$1 = (function (){var statearr_79411 = state_79232;
(statearr_79411[(4)] = cljs.core.cons((5),(state_79232[(4)])));

return statearr_79411;
})();
var ___$2 = (function (){var statearr_79412 = state_79232;
(statearr_79412[(4)] = cljs.core.rest((state_79232[(4)])));

return statearr_79412;
})();
var state_79232__$1 = state_79232;
var statearr_79413_79501 = state_79232__$1;
(statearr_79413_79501[(2)] = db);

(statearr_79413_79501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79233 === (3))){
var inst_79230 = (state_79232[(2)]);
var state_79232__$1 = state_79232;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79232__$1,inst_79230);
} else {
if((state_val_79233 === (4))){
var inst_79222 = (state_79232[(2)]);
var state_79232__$1 = state_79232;
var statearr_79415_79502 = state_79232__$1;
(statearr_79415_79502[(2)] = inst_79222);

(statearr_79415_79502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79233 === (5))){
var ___$1 = (function (){var statearr_79416 = state_79232;
(statearr_79416[(4)] = cljs.core.rest((state_79232[(4)])));

return statearr_79416;
})();
var state_79232__$1 = state_79232;
var ex79414 = (state_79232__$1[(2)]);
var statearr_79417_79503 = state_79232__$1;
(statearr_79417_79503[(5)] = ex79414);


if((ex79414 instanceof Error)){
var statearr_79418_79504 = state_79232__$1;
(statearr_79418_79504[(1)] = (4));

(statearr_79418_79504[(5)] = null);

} else {
throw ex79414;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____0 = (function (){
var statearr_79419 = [null,null,null,null,null,null,null];
(statearr_79419[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__);

(statearr_79419[(1)] = (1));

return statearr_79419;
});
var fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____1 = (function (state_79232){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_79232);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e79420){var ex__17181__auto__ = e79420;
var statearr_79421_79505 = state_79232;
(statearr_79421_79505[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_79232[(4)]))){
var statearr_79422_79506 = state_79232;
(statearr_79422_79506[(1)] = cljs.core.first((state_79232[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79507 = state_79232;
state_79232 = G__79507;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__ = function(state_79232){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____1.call(this,state_79232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_79423 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_79423[(6)] = c__17304__auto____$2);

return statearr_79423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
});
})();
var inst_79236 = cljs.core.async.impl.dispatch.run(inst_79235);
var inst_79237 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_79238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79239 = ["?auth","?id"];
var inst_79240 = (new cljs.core.PersistentVector(null,2,(5),inst_79238,inst_79239,null));
var inst_79241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79243 = [inst_79201,"_tx/auth","?auth"];
var inst_79244 = (new cljs.core.PersistentVector(null,3,(5),inst_79242,inst_79243,null));
var inst_79245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79246 = ["?auth","_auth/id","?id"];
var inst_79247 = (new cljs.core.PersistentVector(null,3,(5),inst_79245,inst_79246,null));
var inst_79248 = [inst_79244,inst_79247];
var inst_79249 = (new cljs.core.PersistentVector(null,2,(5),inst_79241,inst_79248,null));
var inst_79250 = [inst_79240,inst_79249];
var inst_79251 = cljs.core.PersistentHashMap.fromArrays(inst_79237,inst_79250);
var inst_79252 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_79234,inst_79251) : fluree.db.api.query.query_async.call(null,inst_79234,inst_79251));
var state_79267__$1 = (function (){var statearr_79424 = state_79267;
(statearr_79424[(17)] = inst_79236);

(statearr_79424[(18)] = inst_79221);

return statearr_79424;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79267__$1,(14),inst_79252);
} else {
if((state_val_79268 === (9))){
var state_79267__$1 = state_79267;
var statearr_79425_79508 = state_79267__$1;
(statearr_79425_79508[(2)] = show_auth);

(statearr_79425_79508[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79268 === (5))){
var inst_79195 = (state_79267[(8)]);
var state_79267__$1 = state_79267;
var statearr_79426_79509 = state_79267__$1;
(statearr_79426_79509[(2)] = inst_79195);

(statearr_79426_79509[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79268 === (14))){
var inst_79221 = (state_79267[(18)]);
var inst_79212 = (state_79267[(11)]);
var inst_79254 = (state_79267[(2)]);
var inst_79255 = fluree.db.util.async.throw_err(inst_79254);
var inst_79256 = cljs.core.assoc_in(inst_79212,inst_79221,inst_79255);
var state_79267__$1 = state_79267;
var statearr_79427_79510 = state_79267__$1;
(statearr_79427_79510[(2)] = inst_79256);

(statearr_79427_79510[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79268 === (10))){
var inst_79217 = (state_79267[(2)]);
var state_79267__$1 = state_79267;
if(cljs.core.truth_(inst_79217)){
var statearr_79428_79511 = state_79267__$1;
(statearr_79428_79511[(1)] = (11));

} else {
var statearr_79429_79512 = state_79267__$1;
(statearr_79429_79512[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79268 === (8))){
var inst_79213 = (state_79267[(9)]);
var state_79267__$1 = state_79267;
var statearr_79430_79513 = state_79267__$1;
(statearr_79430_79513[(2)] = inst_79213);

(statearr_79430_79513[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____0 = (function (){
var statearr_79431 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79431[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__);

(statearr_79431[(1)] = (1));

return statearr_79431;
});
var fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____1 = (function (state_79267){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_79267);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e79432){var ex__17181__auto__ = e79432;
var statearr_79433_79514 = state_79267;
(statearr_79433_79514[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_79267[(4)]))){
var statearr_79434_79515 = state_79267;
(statearr_79434_79515[(1)] = cljs.core.first((state_79267[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79516 = state_79267;
state_79267 = G__79516;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__ = function(state_79267){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____1.call(this,state_79267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_79435 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_79435[(6)] = c__17304__auto____$1);

return statearr_79435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
});
})();
var inst_79271 = cljs.core.async.impl.dispatch.run(inst_79270);
var state_79367__$1 = (function (){var statearr_79436 = state_79367;
(statearr_79436[(20)] = inst_79271);

return statearr_79436;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79367__$1,(6),inst_79269);
} else {
if((state_val_79368 === (23))){
var inst_79325 = (state_79367[(2)]);
var state_79367__$1 = (function (){var statearr_79437 = state_79367;
(statearr_79437[(13)] = inst_79325);

return statearr_79437;
})();
var statearr_79438_79517 = state_79367__$1;
(statearr_79438_79517[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (35))){
var inst_79355 = (state_79367[(2)]);
var state_79367__$1 = state_79367;
var statearr_79440_79518 = state_79367__$1;
(statearr_79440_79518[(2)] = inst_79355);

(statearr_79440_79518[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (19))){
var state_79367__$1 = state_79367;
var statearr_79441_79519 = state_79367__$1;
(statearr_79441_79519[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (11))){
var inst_79306 = (state_79367[(2)]);
var state_79367__$1 = state_79367;
if(cljs.core.truth_(inst_79306)){
var statearr_79444_79520 = state_79367__$1;
(statearr_79444_79520[(1)] = (15));

} else {
var statearr_79445_79521 = state_79367__$1;
(statearr_79445_79521[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (9))){
var inst_79297 = (state_79367[(16)]);
var inst_79297__$1 = auth;
var state_79367__$1 = (function (){var statearr_79446 = state_79367;
(statearr_79446[(16)] = inst_79297__$1);

return statearr_79446;
})();
if(cljs.core.truth_(inst_79297__$1)){
var statearr_79447_79522 = state_79367__$1;
(statearr_79447_79522[(1)] = (12));

} else {
var statearr_79448_79523 = state_79367__$1;
(statearr_79448_79523[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (5))){
var _ = (function (){var statearr_79449 = state_79367;
(statearr_79449[(4)] = cljs.core.rest((state_79367[(4)])));

return statearr_79449;
})();
var state_79367__$1 = state_79367;
var ex79443 = (state_79367__$1[(2)]);
var statearr_79450_79524 = state_79367__$1;
(statearr_79450_79524[(5)] = ex79443);


if((ex79443 instanceof Error)){
var statearr_79451_79525 = state_79367__$1;
(statearr_79451_79525[(1)] = (4));

(statearr_79451_79525[(5)] = null);

} else {
throw ex79443;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (14))){
var inst_79303 = (state_79367[(2)]);
var state_79367__$1 = state_79367;
var statearr_79452_79526 = state_79367__$1;
(statearr_79452_79526[(2)] = inst_79303);

(statearr_79452_79526[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (26))){
var inst_79333 = (state_79367[(2)]);
var state_79367__$1 = (function (){var statearr_79453 = state_79367;
(statearr_79453[(10)] = inst_79333);

return statearr_79453;
})();
var statearr_79454_79527 = state_79367__$1;
(statearr_79454_79527[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (16))){
var inst_79294 = (state_79367[(7)]);
var state_79367__$1 = state_79367;
if(cljs.core.truth_(inst_79294)){
var statearr_79456_79528 = state_79367__$1;
(statearr_79456_79528[(1)] = (18));

} else {
var statearr_79457_79529 = state_79367__$1;
(statearr_79457_79529[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (30))){
var inst_79315 = (state_79367[(11)]);
var inst_79316 = (state_79367[(21)]);
var inst_79341 = (state_79367[(15)]);
var inst_79343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79344 = [inst_79315,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_79345 = (new cljs.core.PersistentVector(null,2,(5),inst_79343,inst_79344,null));
var inst_79346 = cljs.core.assoc_in(inst_79341,inst_79345,inst_79316);
var state_79367__$1 = state_79367;
var statearr_79458_79530 = state_79367__$1;
(statearr_79458_79530[(2)] = inst_79346);

(statearr_79458_79530[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (10))){
var inst_79294 = (state_79367[(7)]);
var state_79367__$1 = state_79367;
var statearr_79459_79531 = state_79367__$1;
(statearr_79459_79531[(2)] = inst_79294);

(statearr_79459_79531[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (18))){
var inst_79294 = (state_79367[(7)]);
var inst_79312 = (state_79367[(12)]);
var inst_79274 = (state_79367[(19)]);
var inst_79312__$1 = inst_79294.t;
var inst_79313 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79274,inst_79312__$1);
var inst_79314 = cljs.core.__destructure_map(inst_79313);
var inst_79315 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79314,new cljs.core.Keyword(null,"block","block",664686210));
var inst_79316 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79314,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_79367__$1 = (function (){var statearr_79460 = state_79367;
(statearr_79460[(11)] = inst_79315);

(statearr_79460[(21)] = inst_79316);

(statearr_79460[(12)] = inst_79312__$1);

return statearr_79460;
})();
var statearr_79461_79532 = state_79367__$1;
(statearr_79461_79532[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79368 === (8))){
var inst_79361 = (state_79367[(2)]);
var inst_79362 = cljs.core.vals(inst_79361);
var _ = (function (){var statearr_79463 = state_79367;
(statearr_79463[(4)] = cljs.core.rest((state_79367[(4)])));

return statearr_79463;
})();
var state_79367__$1 = state_79367;
var statearr_79464_79533 = state_79367__$1;
(statearr_79464_79533[(2)] = inst_79362);

(statearr_79464_79533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____0 = (function (){
var statearr_79465 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79465[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__);

(statearr_79465[(1)] = (1));

return statearr_79465;
});
var fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____1 = (function (state_79367){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_79367);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e79466){var ex__17181__auto__ = e79466;
var statearr_79467_79534 = state_79367;
(statearr_79467_79534[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_79367[(4)]))){
var statearr_79468_79535 = state_79367;
(statearr_79468_79535[(1)] = cljs.core.first((state_79367[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79536 = state_79367;
state_79367 = G__79536;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__ = function(state_79367){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____1.call(this,state_79367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__17178__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_79469 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_79469[(6)] = c__17304__auto__);

return statearr_79469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_79663){
var state_val_79664 = (state_79663[(1)]);
if((state_val_79664 === (7))){
var inst_79559 = (state_79663[(7)]);
var inst_79561 = fluree.db.api.query.resolve_block_range(inst_79559,query_map);
var state_79663__$1 = state_79663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79663__$1,(10),inst_79561);
} else {
if((state_val_79664 === (20))){
var inst_79588 = (state_79663[(2)]);
var inst_79589 = fluree.db.util.async.throw_err(inst_79588);
var inst_79590 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_79589);
var inst_79591 = (inst_79590 - (1));
var state_79663__$1 = state_79663;
var statearr_79665_79728 = state_79663__$1;
(statearr_79665_79728[(2)] = inst_79591);

(statearr_79665_79728[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (27))){
var state_79663__$1 = state_79663;
var statearr_79666_79729 = state_79663__$1;
(statearr_79666_79729[(2)] = null);

(statearr_79666_79729[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (1))){
var state_79663__$1 = state_79663;
var statearr_79667_79730 = state_79663__$1;
(statearr_79667_79730[(2)] = null);

(statearr_79667_79730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (24))){
var inst_79598 = (state_79663[(2)]);
var inst_79599 = fluree.db.util.async.throw_err(inst_79598);
var inst_79600 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_79599);
var state_79663__$1 = state_79663;
var statearr_79668_79731 = state_79663__$1;
(statearr_79668_79731[(2)] = inst_79600);

(statearr_79668_79731[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (39))){
var inst_79635 = (state_79663[(2)]);
var inst_79636 = fluree.db.util.async.throw_err(inst_79635);
var state_79663__$1 = state_79663;
var statearr_79669_79732 = state_79663__$1;
(statearr_79669_79732[(2)] = inst_79636);

(statearr_79669_79732[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (4))){
var inst_79537 = (state_79663[(2)]);
var state_79663__$1 = state_79663;
var statearr_79670_79733 = state_79663__$1;
(statearr_79670_79733[(2)] = inst_79537);

(statearr_79670_79733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (15))){
var inst_79568 = (state_79663[(8)]);
var state_79663__$1 = state_79663;
var statearr_79671_79734 = state_79663__$1;
(statearr_79671_79734[(2)] = inst_79568);

(statearr_79671_79734[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (21))){
var inst_79569 = (state_79663[(9)]);
var inst_79559 = (state_79663[(7)]);
var inst_79596 = fluree.db.time_travel.as_of_block(inst_79559,inst_79569);
var state_79663__$1 = state_79663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79663__$1,(24),inst_79596);
} else {
if((state_val_79664 === (31))){
var inst_79553 = (state_79663[(10)]);
var state_79663__$1 = state_79663;
var statearr_79672_79735 = state_79663__$1;
(statearr_79672_79735[(2)] = inst_79553);

(statearr_79672_79735[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (32))){
var inst_79614 = (state_79663[(11)]);
var inst_79619 = (state_79663[(12)]);
var inst_79559 = (state_79663[(7)]);
var inst_79623 = (state_79663[(2)]);
var inst_79624 = fluree.db.api.query.format_history_resp(inst_79559,inst_79614,inst_79619,inst_79623);
var state_79663__$1 = state_79663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79663__$1,(29),inst_79624);
} else {
if((state_val_79664 === (40))){
var inst_79614 = (state_79663[(11)]);
var inst_79640 = (state_79663[(13)]);
var inst_79642 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_79643 = cljs.core.count(inst_79614);
var inst_79644 = [inst_79640,inst_79643,(200)];
var inst_79645 = cljs.core.PersistentHashMap.fromArrays(inst_79642,inst_79644);
var state_79663__$1 = state_79663;
var statearr_79673_79736 = state_79663__$1;
(statearr_79673_79736[(2)] = inst_79645);

(statearr_79673_79736[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (33))){
var inst_79552 = (state_79663[(14)]);
var state_79663__$1 = state_79663;
var statearr_79674_79737 = state_79663__$1;
(statearr_79674_79737[(2)] = inst_79552);

(statearr_79674_79737[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (13))){
var inst_79658 = (state_79663[(2)]);
var _ = (function (){var statearr_79675 = state_79663;
(statearr_79675[(4)] = cljs.core.rest((state_79663[(4)])));

return statearr_79675;
})();
var state_79663__$1 = state_79663;
var statearr_79676_79738 = state_79663__$1;
(statearr_79676_79738[(2)] = inst_79658);

(statearr_79676_79738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (22))){
var inst_79559 = (state_79663[(7)]);
var inst_79602 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_79559);
var state_79663__$1 = state_79663;
var statearr_79677_79739 = state_79663__$1;
(statearr_79677_79739[(2)] = inst_79602);

(statearr_79677_79739[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (36))){
var inst_79559 = (state_79663[(7)]);
var inst_79627 = (state_79663[(15)]);
var inst_79633 = fluree.db.api.query.format_blocks_resp_pretty(inst_79559,inst_79627);
var state_79663__$1 = state_79663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79663__$1,(39),inst_79633);
} else {
if((state_val_79664 === (41))){
var inst_79640 = (state_79663[(13)]);
var state_79663__$1 = state_79663;
var statearr_79678_79740 = state_79663__$1;
(statearr_79678_79740[(2)] = inst_79640);

(statearr_79678_79740[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (29))){
var inst_79552 = (state_79663[(14)]);
var inst_79626 = (state_79663[(2)]);
var inst_79627 = fluree.db.util.async.throw_err(inst_79626);
var state_79663__$1 = (function (){var statearr_79679 = state_79663;
(statearr_79679[(15)] = inst_79627);

return statearr_79679;
})();
if(cljs.core.truth_(inst_79552)){
var statearr_79680_79741 = state_79663__$1;
(statearr_79680_79741[(1)] = (33));

} else {
var statearr_79681_79742 = state_79663__$1;
(statearr_79681_79742[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (6))){
var inst_79549 = (state_79663[(16)]);
var inst_79558 = (state_79663[(2)]);
var inst_79559 = fluree.db.util.async.throw_err(inst_79558);
var state_79663__$1 = (function (){var statearr_79682 = state_79663;
(statearr_79682[(7)] = inst_79559);

return statearr_79682;
})();
if(cljs.core.truth_(inst_79549)){
var statearr_79683_79743 = state_79663__$1;
(statearr_79683_79743[(1)] = (7));

} else {
var statearr_79684_79744 = state_79663__$1;
(statearr_79684_79744[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (28))){
var inst_79554 = (state_79663[(17)]);
var inst_79619 = (state_79663[(2)]);
var state_79663__$1 = (function (){var statearr_79685 = state_79663;
(statearr_79685[(12)] = inst_79619);

return statearr_79685;
})();
if(cljs.core.truth_(inst_79554)){
var statearr_79686_79745 = state_79663__$1;
(statearr_79686_79745[(1)] = (30));

} else {
var statearr_79687_79746 = state_79663__$1;
(statearr_79687_79746[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (25))){
var inst_79555 = (state_79663[(18)]);
var inst_79613 = (state_79663[(2)]);
var inst_79614 = fluree.db.util.async.throw_err(inst_79613);
var state_79663__$1 = (function (){var statearr_79688 = state_79663;
(statearr_79688[(11)] = inst_79614);

return statearr_79688;
})();
if(cljs.core.truth_(inst_79555)){
var statearr_79689_79747 = state_79663__$1;
(statearr_79689_79747[(1)] = (26));

} else {
var statearr_79690_79748 = state_79663__$1;
(statearr_79690_79748[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (34))){
var inst_79551 = (state_79663[(19)]);
var state_79663__$1 = state_79663;
var statearr_79691_79749 = state_79663__$1;
(statearr_79691_79749[(2)] = inst_79551);

(statearr_79691_79749[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (17))){
var inst_79559 = (state_79663[(7)]);
var inst_79568 = (state_79663[(8)]);
var inst_79585 = (inst_79568 - (1));
var inst_79586 = fluree.db.time_travel.as_of_block(inst_79559,inst_79585);
var state_79663__$1 = state_79663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79663__$1,(20),inst_79586);
} else {
if((state_val_79664 === (3))){
var inst_79661 = (state_79663[(2)]);
var state_79663__$1 = state_79663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79663__$1,inst_79661);
} else {
if((state_val_79664 === (12))){
var inst_79650 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_79651 = ["History query not properly formatted. Provided ",inst_79650].join('');
var inst_79652 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79653 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_79654 = cljs.core.PersistentHashMap.fromArrays(inst_79652,inst_79653);
var inst_79655 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_79651,inst_79654);
var inst_79656 = (function(){throw inst_79655})();
var state_79663__$1 = state_79663;
var statearr_79692_79750 = state_79663__$1;
(statearr_79692_79750[(2)] = inst_79656);

(statearr_79692_79750[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (2))){
var _ = (function (){var statearr_79693 = state_79663;
(statearr_79693[(4)] = cljs.core.cons((5),(state_79663[(4)])));

return statearr_79693;
})();
var inst_79547 = query_map;
var inst_79548 = cljs.core.__destructure_map(inst_79547);
var inst_79549 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79548,new cljs.core.Keyword(null,"block","block",664686210));
var inst_79550 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79548,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_79551 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79548,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_79552 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79548,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_79553 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79548,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_79554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79548,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_79555 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79548,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_79556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79548,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_79663__$1 = (function (){var statearr_79694 = state_79663;
(statearr_79694[(16)] = inst_79549);

(statearr_79694[(20)] = inst_79550);

(statearr_79694[(14)] = inst_79552);

(statearr_79694[(21)] = inst_79556);

(statearr_79694[(19)] = inst_79551);

(statearr_79694[(18)] = inst_79555);

(statearr_79694[(10)] = inst_79553);

(statearr_79694[(17)] = inst_79554);

return statearr_79694;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79663__$1,(6),sources);
} else {
if((state_val_79664 === (23))){
var inst_79550 = (state_79663[(20)]);
var inst_79594 = (state_79663[(22)]);
var inst_79559 = (state_79663[(7)]);
var inst_79604 = (state_79663[(2)]);
var inst_79605 = fluree.db.api.query.get_history_pattern(inst_79550);
var inst_79606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79605,(0),null);
var inst_79607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79605,(1),null);
var inst_79608 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_79609 = [inst_79594,inst_79604];
var inst_79610 = cljs.core.PersistentHashMap.fromArrays(inst_79608,inst_79609);
var inst_79611 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_79559,inst_79607,cljs.core._EQ_,inst_79606,inst_79610);
var state_79663__$1 = state_79663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79663__$1,(25),inst_79611);
} else {
if((state_val_79664 === (35))){
var inst_79631 = (state_79663[(2)]);
var state_79663__$1 = state_79663;
if(cljs.core.truth_(inst_79631)){
var statearr_79695_79751 = state_79663__$1;
(statearr_79695_79751[(1)] = (36));

} else {
var statearr_79696_79752 = state_79663__$1;
(statearr_79696_79752[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (19))){
var inst_79569 = (state_79663[(9)]);
var inst_79594 = (state_79663[(2)]);
var state_79663__$1 = (function (){var statearr_79697 = state_79663;
(statearr_79697[(22)] = inst_79594);

return statearr_79697;
})();
if(cljs.core.truth_(inst_79569)){
var statearr_79698_79753 = state_79663__$1;
(statearr_79698_79753[(1)] = (21));

} else {
var statearr_79699_79754 = state_79663__$1;
(statearr_79699_79754[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (11))){
var inst_79556 = (state_79663[(21)]);
var inst_79568 = (state_79663[(8)]);
var inst_79578 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_79556);
var state_79663__$1 = (function (){var statearr_79701 = state_79663;
(statearr_79701[(23)] = inst_79578);

return statearr_79701;
})();
if(cljs.core.truth_(inst_79568)){
var statearr_79702_79755 = state_79663__$1;
(statearr_79702_79755[(1)] = (14));

} else {
var statearr_79703_79756 = state_79663__$1;
(statearr_79703_79756[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (9))){
var inst_79567 = (state_79663[(2)]);
var inst_79568 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79567,(0),null);
var inst_79569 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79567,(1),null);
var inst_79570 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_79571 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_79572 = cljs.core.keys(inst_79571);
var inst_79573 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_79570,inst_79572);
var state_79663__$1 = (function (){var statearr_79704 = state_79663;
(statearr_79704[(9)] = inst_79569);

(statearr_79704[(8)] = inst_79568);

return statearr_79704;
})();
if(inst_79573){
var statearr_79705_79757 = state_79663__$1;
(statearr_79705_79757[(1)] = (11));

} else {
var statearr_79706_79758 = state_79663__$1;
(statearr_79706_79758[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (5))){
var _ = (function (){var statearr_79707 = state_79663;
(statearr_79707[(4)] = cljs.core.rest((state_79663[(4)])));

return statearr_79707;
})();
var state_79663__$1 = state_79663;
var ex79700 = (state_79663__$1[(2)]);
var statearr_79708_79759 = state_79663__$1;
(statearr_79708_79759[(5)] = ex79700);


if((ex79700 instanceof Error)){
var statearr_79709_79760 = state_79663__$1;
(statearr_79709_79760[(1)] = (4));

(statearr_79709_79760[(5)] = null);

} else {
throw ex79700;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (14))){
var inst_79568 = (state_79663[(8)]);
var inst_79580 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_79568);
var state_79663__$1 = state_79663;
var statearr_79710_79761 = state_79663__$1;
(statearr_79710_79761[(2)] = inst_79580);

(statearr_79710_79761[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (26))){
var inst_79555 = (state_79663[(18)]);
var inst_79616 = cljs.core.set(inst_79555);
var state_79663__$1 = state_79663;
var statearr_79711_79762 = state_79663__$1;
(statearr_79711_79762[(2)] = inst_79616);

(statearr_79711_79762[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (16))){
var inst_79583 = (state_79663[(2)]);
var state_79663__$1 = state_79663;
if(cljs.core.truth_(inst_79583)){
var statearr_79712_79763 = state_79663__$1;
(statearr_79712_79763[(1)] = (17));

} else {
var statearr_79713_79764 = state_79663__$1;
(statearr_79713_79764[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (38))){
var inst_79578 = (state_79663[(23)]);
var inst_79640 = (state_79663[(2)]);
var state_79663__$1 = (function (){var statearr_79714 = state_79663;
(statearr_79714[(13)] = inst_79640);

return statearr_79714;
})();
if(cljs.core.truth_(inst_79578)){
var statearr_79715_79765 = state_79663__$1;
(statearr_79715_79765[(1)] = (40));

} else {
var statearr_79716_79766 = state_79663__$1;
(statearr_79716_79766[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (30))){
var inst_79554 = (state_79663[(17)]);
var state_79663__$1 = state_79663;
var statearr_79717_79767 = state_79663__$1;
(statearr_79717_79767[(2)] = inst_79554);

(statearr_79717_79767[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (10))){
var inst_79563 = (state_79663[(2)]);
var inst_79564 = fluree.db.util.async.throw_err(inst_79563);
var state_79663__$1 = state_79663;
var statearr_79718_79768 = state_79663__$1;
(statearr_79718_79768[(2)] = inst_79564);

(statearr_79718_79768[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (18))){
var state_79663__$1 = state_79663;
var statearr_79719_79769 = state_79663__$1;
(statearr_79719_79769[(2)] = (-1));

(statearr_79719_79769[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (42))){
var inst_79648 = (state_79663[(2)]);
var state_79663__$1 = state_79663;
var statearr_79720_79770 = state_79663__$1;
(statearr_79720_79770[(2)] = inst_79648);

(statearr_79720_79770[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (37))){
var inst_79627 = (state_79663[(15)]);
var inst_79638 = fluree.db.api.query.block_Flakes__GT_vector(inst_79627);
var state_79663__$1 = state_79663;
var statearr_79721_79771 = state_79663__$1;
(statearr_79721_79771[(2)] = inst_79638);

(statearr_79721_79771[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79664 === (8))){
var state_79663__$1 = state_79663;
var statearr_79722_79772 = state_79663__$1;
(statearr_79722_79772[(2)] = null);

(statearr_79722_79772[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__17178__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__17178__auto____0 = (function (){
var statearr_79723 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79723[(0)] = fluree$db$api$query$history_query_async_$_state_machine__17178__auto__);

(statearr_79723[(1)] = (1));

return statearr_79723;
});
var fluree$db$api$query$history_query_async_$_state_machine__17178__auto____1 = (function (state_79663){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_79663);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e79724){var ex__17181__auto__ = e79724;
var statearr_79725_79773 = state_79663;
(statearr_79725_79773[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_79663[(4)]))){
var statearr_79726_79774 = state_79663;
(statearr_79726_79774[(1)] = cljs.core.first((state_79663[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79775 = state_79663;
state_79663 = G__79775;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__17178__auto__ = function(state_79663){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__17178__auto____1.call(this,state_79663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__17178__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__17178__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_79727 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_79727[(6)] = c__17304__auto__);

return statearr_79727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_79908){
var state_val_79909 = (state_79908[(1)]);
if((state_val_79909 === (7))){
var inst_79805 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_79806 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_79805].join('');
var inst_79807 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79808 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_79809 = cljs.core.PersistentHashMap.fromArrays(inst_79807,inst_79808);
var inst_79810 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_79806,inst_79809);
var inst_79811 = (function(){throw inst_79810})();
var state_79908__$1 = state_79908;
var statearr_79910_79989 = state_79908__$1;
(statearr_79910_79989[(2)] = inst_79811);

(statearr_79910_79989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (20))){
var inst_79843 = (state_79908[(2)]);
var state_79908__$1 = state_79908;
if(cljs.core.truth_(inst_79843)){
var statearr_79911_79990 = state_79908__$1;
(statearr_79911_79990[(1)] = (21));

} else {
var statearr_79912_79991 = state_79908__$1;
(statearr_79912_79991[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (27))){
var inst_79787 = (state_79908[(7)]);
var state_79908__$1 = state_79908;
var statearr_79913_79992 = state_79908__$1;
(statearr_79913_79992[(2)] = inst_79787);

(statearr_79913_79992[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (1))){
var state_79908__$1 = state_79908;
var statearr_79914_79993 = state_79908__$1;
(statearr_79914_79993[(2)] = null);

(statearr_79914_79993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (24))){
var inst_79849 = (state_79908[(8)]);
var state_79908__$1 = state_79908;
var statearr_79915_79994 = state_79908__$1;
(statearr_79915_79994[(2)] = inst_79849);

(statearr_79915_79994[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (39))){
var inst_79793 = (state_79908[(9)]);
var state_79908__$1 = state_79908;
if(cljs.core.truth_(inst_79793)){
var statearr_79916_79995 = state_79908__$1;
(statearr_79916_79995[(1)] = (42));

} else {
var statearr_79917_79996 = state_79908__$1;
(statearr_79917_79996[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (46))){
var inst_79881 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79882 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_79883 = cljs.core.PersistentHashMap.fromArrays(inst_79881,inst_79882);
var inst_79884 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_79883);
var inst_79885 = (function(){throw inst_79884})();
var state_79908__$1 = state_79908;
var statearr_79918_79997 = state_79908__$1;
(statearr_79918_79997[(2)] = inst_79885);

(statearr_79918_79997[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (4))){
var inst_79777 = (state_79908[(2)]);
var state_79908__$1 = state_79908;
var statearr_79919_79998 = state_79908__$1;
(statearr_79919_79998[(2)] = inst_79777);

(statearr_79919_79998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (15))){
var inst_79828 = (state_79908[(10)]);
var inst_79790 = (state_79908[(11)]);
var inst_79830 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_79828);
var inst_79831 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_79828);
var inst_79832 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_79828);
var inst_79833 = fluree.db.api.query.get_sources(inst_79830,inst_79831,inst_79832,inst_79790);
var state_79908__$1 = state_79908;
var statearr_79920_79999 = state_79908__$1;
(statearr_79920_79999[(2)] = inst_79833);

(statearr_79920_79999[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (48))){
var inst_79838 = (state_79908[(12)]);
var inst_79892 = (state_79908[(2)]);
var inst_79893 = fluree.db.util.async.throw_err(inst_79892);
var state_79908__$1 = (function (){var statearr_79921 = state_79908;
(statearr_79921[(13)] = inst_79893);

return statearr_79921;
})();
if(cljs.core.truth_(inst_79838)){
var statearr_79922_80000 = state_79908__$1;
(statearr_79922_80000[(1)] = (49));

} else {
var statearr_79923_80001 = state_79908__$1;
(statearr_79923_80001[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (50))){
var inst_79893 = (state_79908[(13)]);
var state_79908__$1 = state_79908;
var statearr_79924_80002 = state_79908__$1;
(statearr_79924_80002[(2)] = inst_79893);

(statearr_79924_80002[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (21))){
var inst_79845 = cljs.core.volatile_BANG_((0));
var state_79908__$1 = state_79908;
var statearr_79925_80003 = state_79908__$1;
(statearr_79925_80003[(2)] = inst_79845);

(statearr_79925_80003[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (31))){
var inst_79791 = (state_79908[(14)]);
var state_79908__$1 = state_79908;
if(cljs.core.truth_(inst_79791)){
var statearr_79926_80004 = state_79908__$1;
(statearr_79926_80004[(1)] = (33));

} else {
var statearr_79927_80005 = state_79908__$1;
(statearr_79927_80005[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (32))){
var inst_79868 = (state_79908[(2)]);
var state_79908__$1 = state_79908;
var statearr_79928_80006 = state_79908__$1;
(statearr_79928_80006[(2)] = inst_79868);

(statearr_79928_80006[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (40))){
var inst_79870 = (state_79908[(15)]);
var state_79908__$1 = state_79908;
var statearr_79929_80007 = state_79908__$1;
(statearr_79929_80007[(2)] = inst_79870);

(statearr_79929_80007[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (33))){
var inst_79791 = (state_79908[(14)]);
var state_79908__$1 = state_79908;
var statearr_79930_80008 = state_79908__$1;
(statearr_79930_80008[(2)] = inst_79791);

(statearr_79930_80008[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (13))){
var inst_79788 = (state_79908[(16)]);
var inst_79817 = (state_79908[(2)]);
var inst_79818 = fluree.db.util.async.throw_err(inst_79817);
var inst_79819 = fluree.db.time_travel.as_of_block(inst_79818,inst_79788);
var state_79908__$1 = state_79908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79908__$1,(12),inst_79819);
} else {
if((state_val_79909 === (22))){
var state_79908__$1 = state_79908;
var statearr_79931_80009 = state_79908__$1;
(statearr_79931_80009[(2)] = null);

(statearr_79931_80009[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (36))){
var inst_79795 = (state_79908[(17)]);
var state_79908__$1 = state_79908;
var statearr_79932_80010 = state_79908__$1;
(statearr_79932_80010[(2)] = inst_79795);

(statearr_79932_80010[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (41))){
var inst_79878 = (state_79908[(2)]);
var state_79908__$1 = state_79908;
if(cljs.core.truth_(inst_79878)){
var statearr_79933_80011 = state_79908__$1;
(statearr_79933_80011[(1)] = (45));

} else {
var statearr_79934_80012 = state_79908__$1;
(statearr_79934_80012[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (43))){
var inst_79789 = (state_79908[(18)]);
var state_79908__$1 = state_79908;
var statearr_79935_80013 = state_79908__$1;
(statearr_79935_80013[(2)] = inst_79789);

(statearr_79935_80013[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (29))){
var inst_79870 = (state_79908[(15)]);
var inst_79870__$1 = (state_79908[(2)]);
var state_79908__$1 = (function (){var statearr_79936 = state_79908;
(statearr_79936[(15)] = inst_79870__$1);

return statearr_79936;
})();
if(cljs.core.truth_(inst_79870__$1)){
var statearr_79937_80014 = state_79908__$1;
(statearr_79937_80014[(1)] = (39));

} else {
var statearr_79938_80015 = state_79908__$1;
(statearr_79938_80015[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (44))){
var inst_79875 = (state_79908[(2)]);
var state_79908__$1 = state_79908;
var statearr_79939_80016 = state_79908__$1;
(statearr_79939_80016[(2)] = inst_79875);

(statearr_79939_80016[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (6))){
var state_79908__$1 = state_79908;
var statearr_79940_80017 = state_79908__$1;
(statearr_79940_80017[(2)] = null);

(statearr_79940_80017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (28))){
var inst_79792 = (state_79908[(19)]);
var state_79908__$1 = state_79908;
if(cljs.core.truth_(inst_79792)){
var statearr_79941_80018 = state_79908__$1;
(statearr_79941_80018[(1)] = (30));

} else {
var statearr_79942_80019 = state_79908__$1;
(statearr_79942_80019[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (51))){
var inst_79903 = (state_79908[(2)]);
var _ = (function (){var statearr_79943 = state_79908;
(statearr_79943[(4)] = cljs.core.rest((state_79908[(4)])));

return statearr_79943;
})();
var state_79908__$1 = state_79908;
var statearr_79944_80020 = state_79908__$1;
(statearr_79944_80020[(2)] = inst_79903);

(statearr_79944_80020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (25))){
var state_79908__$1 = state_79908;
var statearr_79945_80021 = state_79908__$1;
(statearr_79945_80021[(2)] = (1000000));

(statearr_79945_80021[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (34))){
var inst_79795 = (state_79908[(17)]);
var state_79908__$1 = state_79908;
if(cljs.core.truth_(inst_79795)){
var statearr_79946_80022 = state_79908__$1;
(statearr_79946_80022[(1)] = (36));

} else {
var statearr_79947_80023 = state_79908__$1;
(statearr_79947_80023[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (17))){
var inst_79839 = (state_79908[(20)]);
var inst_79794 = (state_79908[(21)]);
var inst_79837 = (state_79908[(2)]);
var inst_79838 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_79794);
var inst_79839__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_79794);
var state_79908__$1 = (function (){var statearr_79948 = state_79908;
(statearr_79948[(12)] = inst_79838);

(statearr_79948[(20)] = inst_79839__$1);

(statearr_79948[(22)] = inst_79837);

return statearr_79948;
})();
if(cljs.core.truth_(inst_79839__$1)){
var statearr_79949_80024 = state_79908__$1;
(statearr_79949_80024[(1)] = (18));

} else {
var statearr_79950_80025 = state_79908__$1;
(statearr_79950_80025[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (3))){
var inst_79906 = (state_79908[(2)]);
var state_79908__$1 = state_79908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79908__$1,inst_79906);
} else {
if((state_val_79909 === (12))){
var inst_79821 = (state_79908[(2)]);
var inst_79822 = fluree.db.util.async.throw_err(inst_79821);
var state_79908__$1 = state_79908;
var statearr_79951_80026 = state_79908__$1;
(statearr_79951_80026[(2)] = inst_79822);

(statearr_79951_80026[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (2))){
var inst_79788 = (state_79908[(16)]);
var inst_79789 = (state_79908[(18)]);
var inst_79791 = (state_79908[(14)]);
var inst_79792 = (state_79908[(19)]);
var inst_79790 = (state_79908[(11)]);
var inst_79787 = (state_79908[(7)]);
var inst_79793 = (state_79908[(9)]);
var inst_79786 = (state_79908[(23)]);
var inst_79794 = (state_79908[(21)]);
var inst_79795 = (state_79908[(17)]);
var _ = (function (){var statearr_79952 = state_79908;
(statearr_79952[(4)] = cljs.core.cons((5),(state_79908[(4)])));

return statearr_79952;
})();
var inst_79784 = flureeQL;
var inst_79785 = cljs.core.__destructure_map(inst_79784);
var inst_79786__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79785,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_79787__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79785,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_79788__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79785,new cljs.core.Keyword(null,"block","block",664686210));
var inst_79789__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79785,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_79790__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79785,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_79791__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79785,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_79792__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79785,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_79793__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79785,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_79794__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79785,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_79795__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79785,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_79796 = (function (){var construct = inst_79786__$1;
var select = inst_79787__$1;
var block = inst_79788__$1;
var map__79783 = inst_79785;
var where = inst_79789__$1;
var prefixes = inst_79790__$1;
var selectDistinct = inst_79791__$1;
var selectOne = inst_79792__$1;
var from = inst_79793__$1;
var opts = inst_79794__$1;
var selectReduced = inst_79795__$1;
return (function (p1__79776_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__79776_SHARP_);
});
})();
var inst_79797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79798 = [inst_79787__$1,inst_79792__$1,inst_79791__$1,inst_79795__$1];
var inst_79799 = (new cljs.core.PersistentVector(null,4,(5),inst_79797,inst_79798,null));
var inst_79800 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_79799);
var inst_79801 = cljs.core.count(inst_79800);
var inst_79802 = (inst_79796.cljs$core$IFn$_invoke$arity$1 ? inst_79796.cljs$core$IFn$_invoke$arity$1(inst_79801) : inst_79796.call(null,inst_79801));
var state_79908__$1 = (function (){var statearr_79953 = state_79908;
(statearr_79953[(16)] = inst_79788__$1);

(statearr_79953[(18)] = inst_79789__$1);

(statearr_79953[(14)] = inst_79791__$1);

(statearr_79953[(19)] = inst_79792__$1);

(statearr_79953[(11)] = inst_79790__$1);

(statearr_79953[(7)] = inst_79787__$1);

(statearr_79953[(9)] = inst_79793__$1);

(statearr_79953[(23)] = inst_79786__$1);

(statearr_79953[(21)] = inst_79794__$1);

(statearr_79953[(17)] = inst_79795__$1);

return statearr_79953;
})();
if(cljs.core.truth_(inst_79802)){
var statearr_79954_80027 = state_79908__$1;
(statearr_79954_80027[(1)] = (6));

} else {
var statearr_79955_80028 = state_79908__$1;
(statearr_79955_80028[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (23))){
var inst_79794 = (state_79908[(21)]);
var inst_79849 = (state_79908[(8)]);
var inst_79848 = (state_79908[(2)]);
var inst_79849__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_79794);
var state_79908__$1 = (function (){var statearr_79956 = state_79908;
(statearr_79956[(8)] = inst_79849__$1);

(statearr_79956[(24)] = inst_79848);

return statearr_79956;
})();
if(cljs.core.truth_(inst_79849__$1)){
var statearr_79957_80029 = state_79908__$1;
(statearr_79957_80029[(1)] = (24));

} else {
var statearr_79958_80030 = state_79908__$1;
(statearr_79958_80030[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (47))){
var inst_79828 = (state_79908[(10)]);
var inst_79854 = (state_79908[(25)]);
var inst_79887 = (state_79908[(2)]);
var inst_79888 = fluree.db.util.core.current_time_millis();
var inst_79889 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_79854);
var inst_79890 = fluree.db.query.fql.query(inst_79828,inst_79889);
var state_79908__$1 = (function (){var statearr_79959 = state_79908;
(statearr_79959[(26)] = inst_79888);

(statearr_79959[(27)] = inst_79887);

return statearr_79959;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79908__$1,(48),inst_79890);
} else {
if((state_val_79909 === (35))){
var inst_79866 = (state_79908[(2)]);
var state_79908__$1 = state_79908;
var statearr_79960_80031 = state_79908__$1;
(statearr_79960_80031[(2)] = inst_79866);

(statearr_79960_80031[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (19))){
var inst_79838 = (state_79908[(12)]);
var state_79908__$1 = state_79908;
var statearr_79961_80032 = state_79908__$1;
(statearr_79961_80032[(2)] = inst_79838);

(statearr_79961_80032[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (11))){
var inst_79790 = (state_79908[(11)]);
var inst_79828 = (state_79908[(2)]);
var state_79908__$1 = (function (){var statearr_79963 = state_79908;
(statearr_79963[(10)] = inst_79828);

return statearr_79963;
})();
if(cljs.core.truth_(inst_79790)){
var statearr_79964_80033 = state_79908__$1;
(statearr_79964_80033[(1)] = (15));

} else {
var statearr_79965_80034 = state_79908__$1;
(statearr_79965_80034[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (9))){
var inst_79814 = (state_79908[(28)]);
var state_79908__$1 = state_79908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79908__$1,(13),inst_79814);
} else {
if((state_val_79909 === (5))){
var _ = (function (){var statearr_79966 = state_79908;
(statearr_79966[(4)] = cljs.core.rest((state_79908[(4)])));

return statearr_79966;
})();
var state_79908__$1 = state_79908;
var ex79962 = (state_79908__$1[(2)]);
var statearr_79967_80035 = state_79908__$1;
(statearr_79967_80035[(5)] = ex79962);


if((ex79962 instanceof Error)){
var statearr_79968_80036 = state_79908__$1;
(statearr_79968_80036[(1)] = (4));

(statearr_79968_80036[(5)] = null);

} else {
throw ex79962;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (14))){
var inst_79825 = (state_79908[(2)]);
var inst_79826 = fluree.db.util.async.throw_err(inst_79825);
var state_79908__$1 = state_79908;
var statearr_79969_80037 = state_79908__$1;
(statearr_79969_80037[(2)] = inst_79826);

(statearr_79969_80037[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (45))){
var state_79908__$1 = state_79908;
var statearr_79970_80038 = state_79908__$1;
(statearr_79970_80038[(2)] = null);

(statearr_79970_80038[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (26))){
var inst_79787 = (state_79908[(7)]);
var inst_79837 = (state_79908[(22)]);
var inst_79794 = (state_79908[(21)]);
var inst_79848 = (state_79908[(24)]);
var inst_79853 = (state_79908[(2)]);
var inst_79854 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_79794,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_79837,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_79853,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_79848], 0));
var state_79908__$1 = (function (){var statearr_79971 = state_79908;
(statearr_79971[(25)] = inst_79854);

return statearr_79971;
})();
if(cljs.core.truth_(inst_79787)){
var statearr_79972_80039 = state_79908__$1;
(statearr_79972_80039[(1)] = (27));

} else {
var statearr_79973_80040 = state_79908__$1;
(statearr_79973_80040[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (16))){
var inst_79835 = cljs.core.PersistentHashMap.EMPTY;
var state_79908__$1 = state_79908;
var statearr_79974_80041 = state_79908__$1;
(statearr_79974_80041[(2)] = inst_79835);

(statearr_79974_80041[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (38))){
var inst_79864 = (state_79908[(2)]);
var state_79908__$1 = state_79908;
var statearr_79975_80042 = state_79908__$1;
(statearr_79975_80042[(2)] = inst_79864);

(statearr_79975_80042[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (30))){
var inst_79792 = (state_79908[(19)]);
var state_79908__$1 = state_79908;
var statearr_79976_80043 = state_79908__$1;
(statearr_79976_80043[(2)] = inst_79792);

(statearr_79976_80043[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (10))){
var inst_79814 = (state_79908[(28)]);
var state_79908__$1 = state_79908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79908__$1,(14),inst_79814);
} else {
if((state_val_79909 === (18))){
var inst_79839 = (state_79908[(20)]);
var state_79908__$1 = state_79908;
var statearr_79977_80044 = state_79908__$1;
(statearr_79977_80044[(2)] = inst_79839);

(statearr_79977_80044[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (42))){
var inst_79793 = (state_79908[(9)]);
var state_79908__$1 = state_79908;
var statearr_79978_80045 = state_79908__$1;
(statearr_79978_80045[(2)] = inst_79793);

(statearr_79978_80045[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (37))){
var inst_79786 = (state_79908[(23)]);
var state_79908__$1 = state_79908;
var statearr_79979_80046 = state_79908__$1;
(statearr_79979_80046[(2)] = inst_79786);

(statearr_79979_80046[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (8))){
var inst_79788 = (state_79908[(16)]);
var inst_79813 = (state_79908[(2)]);
var inst_79814 = sources;
var state_79908__$1 = (function (){var statearr_79980 = state_79908;
(statearr_79980[(28)] = inst_79814);

(statearr_79980[(29)] = inst_79813);

return statearr_79980;
})();
if(cljs.core.truth_(inst_79788)){
var statearr_79981_80047 = state_79908__$1;
(statearr_79981_80047[(1)] = (9));

} else {
var statearr_79982_80048 = state_79908__$1;
(statearr_79982_80048[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79909 === (49))){
var inst_79888 = (state_79908[(26)]);
var inst_79828 = (state_79908[(10)]);
var inst_79893 = (state_79908[(13)]);
var inst_79848 = (state_79908[(24)]);
var inst_79895 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_79896 = cljs.core.deref(inst_79848);
var inst_79897 = fluree.db.util.core.response_time_formatted(inst_79888);
var inst_79898 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_79828);
var inst_79899 = [(200),inst_79893,inst_79896,inst_79897,inst_79898];
var inst_79900 = cljs.core.PersistentHashMap.fromArrays(inst_79895,inst_79899);
var state_79908__$1 = state_79908;
var statearr_79983_80049 = state_79908__$1;
(statearr_79983_80049[(2)] = inst_79900);

(statearr_79983_80049[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__17178__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__17178__auto____0 = (function (){
var statearr_79984 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79984[(0)] = fluree$db$api$query$query_async_$_state_machine__17178__auto__);

(statearr_79984[(1)] = (1));

return statearr_79984;
});
var fluree$db$api$query$query_async_$_state_machine__17178__auto____1 = (function (state_79908){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_79908);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e79985){var ex__17181__auto__ = e79985;
var statearr_79986_80050 = state_79908;
(statearr_79986_80050[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_79908[(4)]))){
var statearr_79987_80051 = state_79908;
(statearr_79987_80051[(1)] = cljs.core.first((state_79908[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80052 = state_79908;
state_79908 = G__80052;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__17178__auto__ = function(state_79908){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__17178__auto____1.call(this,state_79908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__17178__auto____0;
fluree$db$api$query$query_async_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__17178__auto____1;
return fluree$db$api$query$query_async_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_79988 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_79988[(6)] = c__17304__auto__);

return statearr_79988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_80193){
var state_val_80194 = (state_80193[(1)]);
if((state_val_80194 === (7))){
var inst_80188 = (state_80193[(2)]);
var _ = (function (){var statearr_80195 = state_80193;
(statearr_80195[(4)] = cljs.core.rest((state_80193[(4)])));

return statearr_80195;
})();
var state_80193__$1 = state_80193;
var statearr_80196_80272 = state_80193__$1;
(statearr_80196_80272[(2)] = inst_80188);

(statearr_80196_80272[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (20))){
var inst_80160 = (state_80193[(2)]);
var state_80193__$1 = state_80193;
var statearr_80197_80273 = state_80193__$1;
(statearr_80197_80273[(2)] = inst_80160);

(statearr_80197_80273[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (27))){
var inst_80140 = (state_80193[(7)]);
var state_80193__$1 = state_80193;
var statearr_80198_80274 = state_80193__$1;
(statearr_80198_80274[(2)] = inst_80140);

(statearr_80198_80274[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (1))){
var state_80193__$1 = state_80193;
var statearr_80199_80275 = state_80193__$1;
(statearr_80199_80275[(2)] = null);

(statearr_80199_80275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (24))){
var inst_80137 = (state_80193[(8)]);
var state_80193__$1 = state_80193;
var statearr_80200_80276 = state_80193__$1;
(statearr_80200_80276[(2)] = inst_80137);

(statearr_80200_80276[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (39))){
var inst_80105 = (state_80193[(9)]);
var inst_80094 = (state_80193[(10)]);
var inst_80127 = (state_80193[(11)]);
var inst_80171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80172 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_80105];
var inst_80173 = (new cljs.core.PersistentVector(null,2,(5),inst_80171,inst_80172,null));
var inst_80174 = cljs.core.assoc_in(inst_80094,inst_80173,inst_80127);
var state_80193__$1 = state_80193;
var statearr_80201_80277 = state_80193__$1;
(statearr_80201_80277[(2)] = inst_80174);

(statearr_80201_80277[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (4))){
var inst_80053 = (state_80193[(2)]);
var state_80193__$1 = state_80193;
var statearr_80202_80278 = state_80193__$1;
(statearr_80202_80278[(2)] = inst_80053);

(statearr_80202_80278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (15))){
var inst_80127 = (state_80193[(11)]);
var inst_80092 = (state_80193[(12)]);
var inst_80130 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_80127);
var inst_80131 = (inst_80092 == null);
var state_80193__$1 = (function (){var statearr_80203 = state_80193;
(statearr_80203[(13)] = inst_80130);

return statearr_80203;
})();
if(cljs.core.truth_(inst_80131)){
var statearr_80204_80279 = state_80193__$1;
(statearr_80204_80279[(1)] = (18));

} else {
var statearr_80205_80280 = state_80193__$1;
(statearr_80205_80280[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (21))){
var inst_80130 = (state_80193[(13)]);
var state_80193__$1 = state_80193;
var statearr_80206_80281 = state_80193__$1;
(statearr_80206_80281[(2)] = inst_80130);

(statearr_80206_80281[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (31))){
var state_80193__$1 = state_80193;
var statearr_80207_80282 = state_80193__$1;
(statearr_80207_80282[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (32))){
var inst_80156 = (state_80193[(2)]);
var state_80193__$1 = state_80193;
var statearr_80209_80283 = state_80193__$1;
(statearr_80209_80283[(2)] = inst_80156);

(statearr_80209_80283[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (40))){
var inst_80125 = (state_80193[(14)]);
var state_80193__$1 = state_80193;
if(cljs.core.truth_(inst_80125)){
var statearr_80210_80284 = state_80193__$1;
(statearr_80210_80284[(1)] = (42));

} else {
var statearr_80211_80285 = state_80193__$1;
(statearr_80211_80285[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (33))){
var inst_80130 = (state_80193[(13)]);
var inst_80092 = (state_80193[(12)]);
var inst_80151 = ((inst_80130 > inst_80092) ? inst_80130 : inst_80092);
var state_80193__$1 = state_80193;
var statearr_80212_80286 = state_80193__$1;
(statearr_80212_80286[(2)] = inst_80151);

(statearr_80212_80286[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (13))){
var inst_80116 = (state_80193[(2)]);
var state_80193__$1 = state_80193;
var statearr_80213_80287 = state_80193__$1;
(statearr_80213_80287[(2)] = inst_80116);

(statearr_80213_80287[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (22))){
var inst_80137 = (state_80193[(8)]);
var inst_80130 = (state_80193[(13)]);
var inst_80137__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_80130);
var state_80193__$1 = (function (){var statearr_80214 = state_80193;
(statearr_80214[(8)] = inst_80137__$1);

return statearr_80214;
})();
if(inst_80137__$1){
var statearr_80215_80288 = state_80193__$1;
(statearr_80215_80288[(1)] = (24));

} else {
var statearr_80216_80289 = state_80193__$1;
(statearr_80216_80289[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (36))){
var inst_80093 = (state_80193[(15)]);
var inst_80127 = (state_80193[(11)]);
var inst_80165 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_80127,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_80166 = (inst_80093 + inst_80165);
var state_80193__$1 = state_80193;
var statearr_80217_80290 = state_80193__$1;
(statearr_80217_80290[(2)] = inst_80166);

(statearr_80217_80290[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (41))){
var inst_80169 = (state_80193[(16)]);
var inst_80163 = (state_80193[(17)]);
var inst_80104 = (state_80193[(18)]);
var inst_80183 = (state_80193[(2)]);
var inst_80091 = inst_80104;
var inst_80092 = inst_80163;
var inst_80093 = inst_80169;
var inst_80094 = inst_80183;
var state_80193__$1 = (function (){var statearr_80218 = state_80193;
(statearr_80218[(15)] = inst_80093);

(statearr_80218[(10)] = inst_80094);

(statearr_80218[(19)] = inst_80091);

(statearr_80218[(12)] = inst_80092);

return statearr_80218;
})();
var statearr_80219_80291 = state_80193__$1;
(statearr_80219_80291[(2)] = null);

(statearr_80219_80291[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (43))){
var inst_80127 = (state_80193[(11)]);
var state_80193__$1 = state_80193;
var statearr_80220_80292 = state_80193__$1;
(statearr_80220_80292[(2)] = inst_80127);

(statearr_80220_80292[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (29))){
var inst_80145 = (state_80193[(2)]);
var state_80193__$1 = state_80193;
var statearr_80221_80293 = state_80193__$1;
(statearr_80221_80293[(2)] = inst_80145);

(statearr_80221_80293[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (44))){
var inst_80105 = (state_80193[(9)]);
var inst_80094 = (state_80193[(10)]);
var inst_80180 = (state_80193[(2)]);
var inst_80181 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_80094,inst_80105,inst_80180);
var state_80193__$1 = state_80193;
var statearr_80222_80294 = state_80193__$1;
(statearr_80222_80294[(2)] = inst_80181);

(statearr_80222_80294[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (6))){
var inst_80091 = (state_80193[(19)]);
var inst_80106 = (state_80193[(20)]);
var inst_80102 = cljs.core.seq(inst_80091);
var inst_80103 = cljs.core.first(inst_80102);
var inst_80104 = cljs.core.next(inst_80102);
var inst_80105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80103,(0),null);
var inst_80106__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80103,(1),null);
var inst_80107 = (inst_80106__$1 == null);
var state_80193__$1 = (function (){var statearr_80223 = state_80193;
(statearr_80223[(9)] = inst_80105);

(statearr_80223[(18)] = inst_80104);

(statearr_80223[(20)] = inst_80106__$1);

return statearr_80223;
})();
if(cljs.core.truth_(inst_80107)){
var statearr_80224_80295 = state_80193__$1;
(statearr_80224_80295[(1)] = (8));

} else {
var statearr_80225_80296 = state_80193__$1;
(statearr_80225_80296[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (28))){
var inst_80092 = (state_80193[(12)]);
var inst_80143 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_80092);
var state_80193__$1 = state_80193;
var statearr_80226_80297 = state_80193__$1;
(statearr_80226_80297[(2)] = inst_80143);

(statearr_80226_80297[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (25))){
var inst_80140 = (state_80193[(7)]);
var inst_80092 = (state_80193[(12)]);
var inst_80140__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_80092);
var state_80193__$1 = (function (){var statearr_80227 = state_80193;
(statearr_80227[(7)] = inst_80140__$1);

return statearr_80227;
})();
if(inst_80140__$1){
var statearr_80228_80298 = state_80193__$1;
(statearr_80228_80298[(1)] = (27));

} else {
var statearr_80229_80299 = state_80193__$1;
(statearr_80229_80299[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (34))){
var state_80193__$1 = state_80193;
var statearr_80230_80300 = state_80193__$1;
(statearr_80230_80300[(2)] = null);

(statearr_80230_80300[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (17))){
var inst_80124 = (state_80193[(21)]);
var inst_80163 = (state_80193[(2)]);
var state_80193__$1 = (function (){var statearr_80231 = state_80193;
(statearr_80231[(17)] = inst_80163);

return statearr_80231;
})();
if(cljs.core.truth_(inst_80124)){
var statearr_80232_80301 = state_80193__$1;
(statearr_80232_80301[(1)] = (36));

} else {
var statearr_80233_80302 = state_80193__$1;
(statearr_80233_80302[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (3))){
var inst_80191 = (state_80193[(2)]);
var state_80193__$1 = state_80193;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80193__$1,inst_80191);
} else {
if((state_val_80194 === (12))){
var inst_80094 = (state_80193[(10)]);
var state_80193__$1 = state_80193;
var statearr_80234_80303 = state_80193__$1;
(statearr_80234_80303[(2)] = inst_80094);

(statearr_80234_80303[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (2))){
var inst_80063 = (state_80193[(22)]);
var inst_80067 = (state_80193[(23)]);
var inst_80068 = (state_80193[(24)]);
var _ = (function (){var statearr_80235 = state_80193;
(statearr_80235[(4)] = cljs.core.cons((5),(state_80193[(4)])));

return statearr_80235;
})();
var inst_80059 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_80060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80061 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_80062 = (new cljs.core.PersistentVector(null,2,(5),inst_80060,inst_80061,null));
var inst_80063__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_80062);
var inst_80064 = (function (){var global_block = inst_80059;
var global_meta_QMARK_ = inst_80063__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4212__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4210__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4210__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_80065 = cljs.core.PersistentHashMap.EMPTY;
var inst_80066 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_80067__$1 = cljs.core.reduce_kv(inst_80064,inst_80065,inst_80066);
var inst_80068__$1 = fluree.db.util.core.current_time_millis();
var inst_80070 = (function (){var global_block = inst_80059;
var global_meta_QMARK_ = inst_80063__$1;
var queries = inst_80067__$1;
var start_time = inst_80068__$1;
return (function (p__80069){
var vec__80236 = p__80069;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80236,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80236,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_80071 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_80070,inst_80067__$1);
var inst_80085 = cljs.core.seq(inst_80071);
var inst_80086 = cljs.core.first(inst_80085);
var inst_80087 = cljs.core.next(inst_80085);
var inst_80088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80086,(0),null);
var inst_80089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80086,(1),null);
var inst_80090 = cljs.core.PersistentHashMap.EMPTY;
var inst_80091 = inst_80071;
var inst_80092 = null;
var inst_80093 = (0);
var inst_80094 = inst_80090;
var state_80193__$1 = (function (){var statearr_80239 = state_80193;
(statearr_80239[(25)] = inst_80089);

(statearr_80239[(22)] = inst_80063__$1);

(statearr_80239[(26)] = inst_80088);

(statearr_80239[(15)] = inst_80093);

(statearr_80239[(23)] = inst_80067__$1);

(statearr_80239[(10)] = inst_80094);

(statearr_80239[(24)] = inst_80068__$1);

(statearr_80239[(19)] = inst_80091);

(statearr_80239[(27)] = inst_80087);

(statearr_80239[(12)] = inst_80092);

return statearr_80239;
})();
var statearr_80240_80304 = state_80193__$1;
(statearr_80240_80304[(2)] = null);

(statearr_80240_80304[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (23))){
var inst_80158 = (state_80193[(2)]);
var state_80193__$1 = state_80193;
var statearr_80241_80305 = state_80193__$1;
(statearr_80241_80305[(2)] = inst_80158);

(statearr_80241_80305[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (35))){
var inst_80154 = (state_80193[(2)]);
var state_80193__$1 = state_80193;
var statearr_80242_80306 = state_80193__$1;
(statearr_80242_80306[(2)] = inst_80154);

(statearr_80242_80306[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (19))){
var inst_80130 = (state_80193[(13)]);
var inst_80092 = (state_80193[(12)]);
var inst_80134 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_80092,inst_80130);
var state_80193__$1 = state_80193;
if(inst_80134){
var statearr_80243_80307 = state_80193__$1;
(statearr_80243_80307[(1)] = (21));

} else {
var statearr_80244_80308 = state_80193__$1;
(statearr_80244_80308[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (11))){
var inst_80093 = (state_80193[(15)]);
var inst_80094 = (state_80193[(10)]);
var inst_80068 = (state_80193[(24)]);
var inst_80092 = (state_80193[(12)]);
var inst_80110 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_80111 = fluree.db.util.core.response_time_formatted(inst_80068);
var inst_80112 = [inst_80094,inst_80093,inst_80092,inst_80111];
var inst_80113 = cljs.core.PersistentHashMap.fromArrays(inst_80110,inst_80112);
var state_80193__$1 = state_80193;
var statearr_80246_80309 = state_80193__$1;
(statearr_80246_80309[(2)] = inst_80113);

(statearr_80246_80309[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (9))){
var inst_80067 = (state_80193[(23)]);
var inst_80105 = (state_80193[(9)]);
var inst_80106 = (state_80193[(20)]);
var inst_80119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80120 = [inst_80105,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_80121 = (new cljs.core.PersistentVector(null,2,(5),inst_80119,inst_80120,null));
var inst_80122 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_80067,inst_80121);
var inst_80123 = cljs.core.__destructure_map(inst_80122);
var inst_80124 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_80123,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_80125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_80123,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_80193__$1 = (function (){var statearr_80247 = state_80193;
(statearr_80247[(14)] = inst_80125);

(statearr_80247[(21)] = inst_80124);

return statearr_80247;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80193__$1,(14),inst_80106);
} else {
if((state_val_80194 === (5))){
var _ = (function (){var statearr_80248 = state_80193;
(statearr_80248[(4)] = cljs.core.rest((state_80193[(4)])));

return statearr_80248;
})();
var state_80193__$1 = state_80193;
var ex80245 = (state_80193__$1[(2)]);
var statearr_80249_80310 = state_80193__$1;
(statearr_80249_80310[(5)] = ex80245);


var statearr_80250_80311 = state_80193__$1;
(statearr_80250_80311[(1)] = (4));

(statearr_80250_80311[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (14))){
var inst_80127 = (state_80193[(11)]);
var inst_80124 = (state_80193[(21)]);
var inst_80127__$1 = (state_80193[(2)]);
var inst_80128 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_80127__$1);
var state_80193__$1 = (function (){var statearr_80251 = state_80193;
(statearr_80251[(11)] = inst_80127__$1);

(statearr_80251[(28)] = inst_80128);

return statearr_80251;
})();
if(cljs.core.truth_(inst_80124)){
var statearr_80252_80312 = state_80193__$1;
(statearr_80252_80312[(1)] = (15));

} else {
var statearr_80253_80313 = state_80193__$1;
(statearr_80253_80313[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (26))){
var inst_80147 = (state_80193[(2)]);
var state_80193__$1 = state_80193;
if(cljs.core.truth_(inst_80147)){
var statearr_80254_80314 = state_80193__$1;
(statearr_80254_80314[(1)] = (30));

} else {
var statearr_80255_80315 = state_80193__$1;
(statearr_80255_80315[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (16))){
var state_80193__$1 = state_80193;
var statearr_80256_80316 = state_80193__$1;
(statearr_80256_80316[(2)] = null);

(statearr_80256_80316[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (38))){
var inst_80128 = (state_80193[(28)]);
var inst_80169 = (state_80193[(2)]);
var state_80193__$1 = (function (){var statearr_80257 = state_80193;
(statearr_80257[(16)] = inst_80169);

return statearr_80257;
})();
if(cljs.core.truth_(inst_80128)){
var statearr_80258_80317 = state_80193__$1;
(statearr_80258_80317[(1)] = (39));

} else {
var statearr_80259_80318 = state_80193__$1;
(statearr_80259_80318[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (30))){
var state_80193__$1 = state_80193;
var statearr_80260_80319 = state_80193__$1;
(statearr_80260_80319[(2)] = (207));

(statearr_80260_80319[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (10))){
var inst_80186 = (state_80193[(2)]);
var state_80193__$1 = state_80193;
var statearr_80261_80320 = state_80193__$1;
(statearr_80261_80320[(2)] = inst_80186);

(statearr_80261_80320[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (18))){
var inst_80130 = (state_80193[(13)]);
var state_80193__$1 = state_80193;
var statearr_80262_80321 = state_80193__$1;
(statearr_80262_80321[(2)] = inst_80130);

(statearr_80262_80321[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (42))){
var inst_80127 = (state_80193[(11)]);
var inst_80177 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_80127);
var state_80193__$1 = state_80193;
var statearr_80263_80322 = state_80193__$1;
(statearr_80263_80322[(2)] = inst_80177);

(statearr_80263_80322[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (37))){
var state_80193__$1 = state_80193;
var statearr_80264_80323 = state_80193__$1;
(statearr_80264_80323[(2)] = null);

(statearr_80264_80323[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80194 === (8))){
var inst_80063 = (state_80193[(22)]);
var state_80193__$1 = state_80193;
if(cljs.core.truth_(inst_80063)){
var statearr_80265_80324 = state_80193__$1;
(statearr_80265_80324[(1)] = (11));

} else {
var statearr_80266_80325 = state_80193__$1;
(statearr_80266_80325[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__17178__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__17178__auto____0 = (function (){
var statearr_80267 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80267[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__17178__auto__);

(statearr_80267[(1)] = (1));

return statearr_80267;
});
var fluree$db$api$query$multi_query_async_$_state_machine__17178__auto____1 = (function (state_80193){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_80193);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e80268){var ex__17181__auto__ = e80268;
var statearr_80269_80326 = state_80193;
(statearr_80269_80326[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_80193[(4)]))){
var statearr_80270_80327 = state_80193;
(statearr_80270_80327[(1)] = cljs.core.first((state_80193[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80328 = state_80193;
state_80193 = G__80328;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__17178__auto__ = function(state_80193){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__17178__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__17178__auto____1.call(this,state_80193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__17178__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__17178__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_80271 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_80271[(6)] = c__17304__auto__);

return statearr_80271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__80329 = query_type;
var G__80329__$1 = (((G__80329 instanceof cljs.core.Keyword))?G__80329.fqn:null);
switch (G__80329__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__80329__$1)].join('')));

}
});
