// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.crypto.sha2');
goog.require('cljs.core');
goog.require('goog.crypt.Sha256');
goog.require('goog.crypt.Sha512');
fluree.crypto.sha2.hash = (function fluree$crypto$sha2$hash(ba,hash_size){
if(cljs.core.truth_((function (){var fexpr__80350 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(512),null,(256),null], null), null);
return (fexpr__80350.cljs$core$IFn$_invoke$arity$1 ? fexpr__80350.cljs$core$IFn$_invoke$arity$1(hash_size) : fexpr__80350.call(null,hash_size));
})())){
} else {
throw (new Error("Assert failed: (#{512 256} hash-size)"));
}

var digest = (function (){var G__80351 = hash_size;
switch (G__80351) {
case (256):
var G__80352 = (new goog.crypt.Sha256());
G__80352.update(ba);

return G__80352;

break;
case (512):
var G__80353 = (new goog.crypt.Sha512());
G__80353.update(ba);

return G__80353;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__80351)].join('')));

}
})();
return digest.digest();
});
/**
 * Create a sha2 hash from byte-array.
 */
fluree.crypto.sha2.sha2_256 = (function fluree$crypto$sha2$sha2_256(ba){
return fluree.crypto.sha2.hash(ba,(256));
});
goog.exportSymbol('fluree.crypto.sha2.sha2_256', fluree.crypto.sha2.sha2_256);
/**
 * Create a sha2 hash from byte-array.
 */
fluree.crypto.sha2.sha2_512 = (function fluree$crypto$sha2$sha2_512(ba){
return fluree.crypto.sha2.hash(ba,(512));
});
goog.exportSymbol('fluree.crypto.sha2.sha2_512', fluree.crypto.sha2.sha2_512);
