// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__19241 = arguments.length;
switch (G__19241) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async19242 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19242 = (function (f,blockable,meta19243){
this.f = f;
this.blockable = blockable;
this.meta19243 = meta19243;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async19242.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19244,meta19243__$1){
var self__ = this;
var _19244__$1 = this;
return (new cljs.core.async.t_cljs$core$async19242(self__.f,self__.blockable,meta19243__$1));
}));

(cljs.core.async.t_cljs$core$async19242.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19244){
var self__ = this;
var _19244__$1 = this;
return self__.meta19243;
}));

(cljs.core.async.t_cljs$core$async19242.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19242.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async19242.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async19242.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async19242.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta19243","meta19243",510244746,null)], null);
}));

(cljs.core.async.t_cljs$core$async19242.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async19242.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19242");

(cljs.core.async.t_cljs$core$async19242.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async19242");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async19242.
 */
cljs.core.async.__GT_t_cljs$core$async19242 = (function cljs$core$async$__GT_t_cljs$core$async19242(f__$1,blockable__$1,meta19243){
return (new cljs.core.async.t_cljs$core$async19242(f__$1,blockable__$1,meta19243));
});

}

return (new cljs.core.async.t_cljs$core$async19242(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__19248 = arguments.length;
switch (G__19248) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__19251 = arguments.length;
switch (G__19251) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__19254 = arguments.length;
switch (G__19254) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_19256 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_19256) : fn1.call(null,val_19256));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_19256) : fn1.call(null,val_19256));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__19258 = arguments.length;
switch (G__19258) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4695__auto___19260 = n;
var x_19261 = (0);
while(true){
if((x_19261 < n__4695__auto___19260)){
(a[x_19261] = x_19261);

var G__19262 = (x_19261 + (1));
x_19261 = G__19262;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async19263 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19263 = (function (flag,meta19264){
this.flag = flag;
this.meta19264 = meta19264;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async19263.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19265,meta19264__$1){
var self__ = this;
var _19265__$1 = this;
return (new cljs.core.async.t_cljs$core$async19263(self__.flag,meta19264__$1));
}));

(cljs.core.async.t_cljs$core$async19263.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19265){
var self__ = this;
var _19265__$1 = this;
return self__.meta19264;
}));

(cljs.core.async.t_cljs$core$async19263.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19263.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async19263.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async19263.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async19263.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta19264","meta19264",-1709372354,null)], null);
}));

(cljs.core.async.t_cljs$core$async19263.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async19263.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19263");

(cljs.core.async.t_cljs$core$async19263.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async19263");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async19263.
 */
cljs.core.async.__GT_t_cljs$core$async19263 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async19263(flag__$1,meta19264){
return (new cljs.core.async.t_cljs$core$async19263(flag__$1,meta19264));
});

}

return (new cljs.core.async.t_cljs$core$async19263(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async19266 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19266 = (function (flag,cb,meta19267){
this.flag = flag;
this.cb = cb;
this.meta19267 = meta19267;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async19266.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19268,meta19267__$1){
var self__ = this;
var _19268__$1 = this;
return (new cljs.core.async.t_cljs$core$async19266(self__.flag,self__.cb,meta19267__$1));
}));

(cljs.core.async.t_cljs$core$async19266.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19268){
var self__ = this;
var _19268__$1 = this;
return self__.meta19267;
}));

(cljs.core.async.t_cljs$core$async19266.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19266.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async19266.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async19266.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async19266.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta19267","meta19267",399537301,null)], null);
}));

(cljs.core.async.t_cljs$core$async19266.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async19266.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19266");

(cljs.core.async.t_cljs$core$async19266.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async19266");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async19266.
 */
cljs.core.async.__GT_t_cljs$core$async19266 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async19266(flag__$1,cb__$1,meta19267){
return (new cljs.core.async.t_cljs$core$async19266(flag__$1,cb__$1,meta19267));
});

}

return (new cljs.core.async.t_cljs$core$async19266(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19269_SHARP_){
var G__19271 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19269_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__19271) : fret.call(null,G__19271));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19270_SHARP_){
var G__19272 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19270_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__19272) : fret.call(null,G__19272));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4212__auto__ = wport;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return port;
}
})()], null));
} else {
var G__19273 = (i + (1));
i = G__19273;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4212__auto__ = ret;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4210__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4210__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___19278 = arguments.length;
var i__4819__auto___19279 = (0);
while(true){
if((i__4819__auto___19279 < len__4818__auto___19278)){
args__4824__auto__.push((arguments[i__4819__auto___19279]));

var G__19280 = (i__4819__auto___19279 + (1));
i__4819__auto___19279 = G__19280;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__19276){
var map__19277 = p__19276;
var map__19277__$1 = cljs.core.__destructure_map(map__19277);
var opts = map__19277__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq19274){
var G__19275 = cljs.core.first(seq19274);
var seq19274__$1 = cljs.core.next(seq19274);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19275,seq19274__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__19282 = arguments.length;
switch (G__19282) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__17304__auto___19329 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_19306){
var state_val_19307 = (state_19306[(1)]);
if((state_val_19307 === (7))){
var inst_19302 = (state_19306[(2)]);
var state_19306__$1 = state_19306;
var statearr_19308_19330 = state_19306__$1;
(statearr_19308_19330[(2)] = inst_19302);

(statearr_19308_19330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19307 === (1))){
var state_19306__$1 = state_19306;
var statearr_19309_19331 = state_19306__$1;
(statearr_19309_19331[(2)] = null);

(statearr_19309_19331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19307 === (4))){
var inst_19285 = (state_19306[(7)]);
var inst_19285__$1 = (state_19306[(2)]);
var inst_19286 = (inst_19285__$1 == null);
var state_19306__$1 = (function (){var statearr_19310 = state_19306;
(statearr_19310[(7)] = inst_19285__$1);

return statearr_19310;
})();
if(cljs.core.truth_(inst_19286)){
var statearr_19311_19332 = state_19306__$1;
(statearr_19311_19332[(1)] = (5));

} else {
var statearr_19312_19333 = state_19306__$1;
(statearr_19312_19333[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19307 === (13))){
var state_19306__$1 = state_19306;
var statearr_19313_19334 = state_19306__$1;
(statearr_19313_19334[(2)] = null);

(statearr_19313_19334[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19307 === (6))){
var inst_19285 = (state_19306[(7)]);
var state_19306__$1 = state_19306;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19306__$1,(11),to,inst_19285);
} else {
if((state_val_19307 === (3))){
var inst_19304 = (state_19306[(2)]);
var state_19306__$1 = state_19306;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19306__$1,inst_19304);
} else {
if((state_val_19307 === (12))){
var state_19306__$1 = state_19306;
var statearr_19314_19335 = state_19306__$1;
(statearr_19314_19335[(2)] = null);

(statearr_19314_19335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19307 === (2))){
var state_19306__$1 = state_19306;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19306__$1,(4),from);
} else {
if((state_val_19307 === (11))){
var inst_19295 = (state_19306[(2)]);
var state_19306__$1 = state_19306;
if(cljs.core.truth_(inst_19295)){
var statearr_19315_19336 = state_19306__$1;
(statearr_19315_19336[(1)] = (12));

} else {
var statearr_19316_19337 = state_19306__$1;
(statearr_19316_19337[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19307 === (9))){
var state_19306__$1 = state_19306;
var statearr_19317_19338 = state_19306__$1;
(statearr_19317_19338[(2)] = null);

(statearr_19317_19338[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19307 === (5))){
var state_19306__$1 = state_19306;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19318_19339 = state_19306__$1;
(statearr_19318_19339[(1)] = (8));

} else {
var statearr_19319_19340 = state_19306__$1;
(statearr_19319_19340[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19307 === (14))){
var inst_19300 = (state_19306[(2)]);
var state_19306__$1 = state_19306;
var statearr_19320_19341 = state_19306__$1;
(statearr_19320_19341[(2)] = inst_19300);

(statearr_19320_19341[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19307 === (10))){
var inst_19292 = (state_19306[(2)]);
var state_19306__$1 = state_19306;
var statearr_19321_19342 = state_19306__$1;
(statearr_19321_19342[(2)] = inst_19292);

(statearr_19321_19342[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19307 === (8))){
var inst_19289 = cljs.core.async.close_BANG_(to);
var state_19306__$1 = state_19306;
var statearr_19322_19343 = state_19306__$1;
(statearr_19322_19343[(2)] = inst_19289);

(statearr_19322_19343[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_19323 = [null,null,null,null,null,null,null,null];
(statearr_19323[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_19323[(1)] = (1));

return statearr_19323;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_19306){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19306);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19324){var ex__17181__auto__ = e19324;
var statearr_19325_19344 = state_19306;
(statearr_19325_19344[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19306[(4)]))){
var statearr_19326_19345 = state_19306;
(statearr_19326_19345[(1)] = cljs.core.first((state_19306[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19346 = state_19306;
state_19306 = G__19346;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_19306){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_19306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_19327 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19327[(6)] = c__17304__auto___19329);

return statearr_19327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__19347){
var vec__19348 = p__19347;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19348,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19348,(1),null);
var job = vec__19348;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__17304__auto___19524 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_19355){
var state_val_19356 = (state_19355[(1)]);
if((state_val_19356 === (1))){
var state_19355__$1 = state_19355;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19355__$1,(2),res,v);
} else {
if((state_val_19356 === (2))){
var inst_19352 = (state_19355[(2)]);
var inst_19353 = cljs.core.async.close_BANG_(res);
var state_19355__$1 = (function (){var statearr_19357 = state_19355;
(statearr_19357[(7)] = inst_19352);

return statearr_19357;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_19355__$1,inst_19353);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0 = (function (){
var statearr_19358 = [null,null,null,null,null,null,null,null];
(statearr_19358[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__);

(statearr_19358[(1)] = (1));

return statearr_19358;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1 = (function (state_19355){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19355);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19359){var ex__17181__auto__ = e19359;
var statearr_19360_19525 = state_19355;
(statearr_19360_19525[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19355[(4)]))){
var statearr_19361_19526 = state_19355;
(statearr_19361_19526[(1)] = cljs.core.first((state_19355[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19527 = state_19355;
state_19355 = G__19527;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = function(state_19355){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1.call(this,state_19355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_19362 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19362[(6)] = c__17304__auto___19524);

return statearr_19362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__19363){
var vec__19364 = p__19363;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19364,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19364,(1),null);
var job = vec__19364;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4695__auto___19528 = n;
var __19529 = (0);
while(true){
if((__19529 < n__4695__auto___19528)){
var G__19367_19530 = type;
var G__19367_19531__$1 = (((G__19367_19530 instanceof cljs.core.Keyword))?G__19367_19530.fqn:null);
switch (G__19367_19531__$1) {
case "compute":
var c__17304__auto___19533 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__19529,c__17304__auto___19533,G__19367_19530,G__19367_19531__$1,n__4695__auto___19528,jobs,results,process,async){
return (function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = ((function (__19529,c__17304__auto___19533,G__19367_19530,G__19367_19531__$1,n__4695__auto___19528,jobs,results,process,async){
return (function (state_19380){
var state_val_19381 = (state_19380[(1)]);
if((state_val_19381 === (1))){
var state_19380__$1 = state_19380;
var statearr_19382_19534 = state_19380__$1;
(statearr_19382_19534[(2)] = null);

(statearr_19382_19534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19381 === (2))){
var state_19380__$1 = state_19380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19380__$1,(4),jobs);
} else {
if((state_val_19381 === (3))){
var inst_19378 = (state_19380[(2)]);
var state_19380__$1 = state_19380;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19380__$1,inst_19378);
} else {
if((state_val_19381 === (4))){
var inst_19370 = (state_19380[(2)]);
var inst_19371 = process(inst_19370);
var state_19380__$1 = state_19380;
if(cljs.core.truth_(inst_19371)){
var statearr_19383_19535 = state_19380__$1;
(statearr_19383_19535[(1)] = (5));

} else {
var statearr_19384_19536 = state_19380__$1;
(statearr_19384_19536[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19381 === (5))){
var state_19380__$1 = state_19380;
var statearr_19385_19537 = state_19380__$1;
(statearr_19385_19537[(2)] = null);

(statearr_19385_19537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19381 === (6))){
var state_19380__$1 = state_19380;
var statearr_19386_19538 = state_19380__$1;
(statearr_19386_19538[(2)] = null);

(statearr_19386_19538[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19381 === (7))){
var inst_19376 = (state_19380[(2)]);
var state_19380__$1 = state_19380;
var statearr_19387_19539 = state_19380__$1;
(statearr_19387_19539[(2)] = inst_19376);

(statearr_19387_19539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19529,c__17304__auto___19533,G__19367_19530,G__19367_19531__$1,n__4695__auto___19528,jobs,results,process,async))
;
return ((function (__19529,switch__17177__auto__,c__17304__auto___19533,G__19367_19530,G__19367_19531__$1,n__4695__auto___19528,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0 = (function (){
var statearr_19388 = [null,null,null,null,null,null,null];
(statearr_19388[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__);

(statearr_19388[(1)] = (1));

return statearr_19388;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1 = (function (state_19380){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19380);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19389){var ex__17181__auto__ = e19389;
var statearr_19390_19540 = state_19380;
(statearr_19390_19540[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19380[(4)]))){
var statearr_19391_19541 = state_19380;
(statearr_19391_19541[(1)] = cljs.core.first((state_19380[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19542 = state_19380;
state_19380 = G__19542;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = function(state_19380){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1.call(this,state_19380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__;
})()
;})(__19529,switch__17177__auto__,c__17304__auto___19533,G__19367_19530,G__19367_19531__$1,n__4695__auto___19528,jobs,results,process,async))
})();
var state__17306__auto__ = (function (){var statearr_19392 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19392[(6)] = c__17304__auto___19533);

return statearr_19392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
});})(__19529,c__17304__auto___19533,G__19367_19530,G__19367_19531__$1,n__4695__auto___19528,jobs,results,process,async))
);


break;
case "async":
var c__17304__auto___19543 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__19529,c__17304__auto___19543,G__19367_19530,G__19367_19531__$1,n__4695__auto___19528,jobs,results,process,async){
return (function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = ((function (__19529,c__17304__auto___19543,G__19367_19530,G__19367_19531__$1,n__4695__auto___19528,jobs,results,process,async){
return (function (state_19405){
var state_val_19406 = (state_19405[(1)]);
if((state_val_19406 === (1))){
var state_19405__$1 = state_19405;
var statearr_19407_19544 = state_19405__$1;
(statearr_19407_19544[(2)] = null);

(statearr_19407_19544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19406 === (2))){
var state_19405__$1 = state_19405;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19405__$1,(4),jobs);
} else {
if((state_val_19406 === (3))){
var inst_19403 = (state_19405[(2)]);
var state_19405__$1 = state_19405;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19405__$1,inst_19403);
} else {
if((state_val_19406 === (4))){
var inst_19395 = (state_19405[(2)]);
var inst_19396 = async(inst_19395);
var state_19405__$1 = state_19405;
if(cljs.core.truth_(inst_19396)){
var statearr_19408_19545 = state_19405__$1;
(statearr_19408_19545[(1)] = (5));

} else {
var statearr_19409_19546 = state_19405__$1;
(statearr_19409_19546[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19406 === (5))){
var state_19405__$1 = state_19405;
var statearr_19410_19547 = state_19405__$1;
(statearr_19410_19547[(2)] = null);

(statearr_19410_19547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19406 === (6))){
var state_19405__$1 = state_19405;
var statearr_19411_19548 = state_19405__$1;
(statearr_19411_19548[(2)] = null);

(statearr_19411_19548[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19406 === (7))){
var inst_19401 = (state_19405[(2)]);
var state_19405__$1 = state_19405;
var statearr_19412_19549 = state_19405__$1;
(statearr_19412_19549[(2)] = inst_19401);

(statearr_19412_19549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19529,c__17304__auto___19543,G__19367_19530,G__19367_19531__$1,n__4695__auto___19528,jobs,results,process,async))
;
return ((function (__19529,switch__17177__auto__,c__17304__auto___19543,G__19367_19530,G__19367_19531__$1,n__4695__auto___19528,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0 = (function (){
var statearr_19413 = [null,null,null,null,null,null,null];
(statearr_19413[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__);

(statearr_19413[(1)] = (1));

return statearr_19413;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1 = (function (state_19405){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19405);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19414){var ex__17181__auto__ = e19414;
var statearr_19415_19550 = state_19405;
(statearr_19415_19550[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19405[(4)]))){
var statearr_19416_19551 = state_19405;
(statearr_19416_19551[(1)] = cljs.core.first((state_19405[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19552 = state_19405;
state_19405 = G__19552;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = function(state_19405){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1.call(this,state_19405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__;
})()
;})(__19529,switch__17177__auto__,c__17304__auto___19543,G__19367_19530,G__19367_19531__$1,n__4695__auto___19528,jobs,results,process,async))
})();
var state__17306__auto__ = (function (){var statearr_19417 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19417[(6)] = c__17304__auto___19543);

return statearr_19417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
});})(__19529,c__17304__auto___19543,G__19367_19530,G__19367_19531__$1,n__4695__auto___19528,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__19367_19531__$1)].join('')));

}

var G__19553 = (__19529 + (1));
__19529 = G__19553;
continue;
} else {
}
break;
}

var c__17304__auto___19554 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_19439){
var state_val_19440 = (state_19439[(1)]);
if((state_val_19440 === (7))){
var inst_19435 = (state_19439[(2)]);
var state_19439__$1 = state_19439;
var statearr_19441_19555 = state_19439__$1;
(statearr_19441_19555[(2)] = inst_19435);

(statearr_19441_19555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19440 === (1))){
var state_19439__$1 = state_19439;
var statearr_19442_19556 = state_19439__$1;
(statearr_19442_19556[(2)] = null);

(statearr_19442_19556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19440 === (4))){
var inst_19420 = (state_19439[(7)]);
var inst_19420__$1 = (state_19439[(2)]);
var inst_19421 = (inst_19420__$1 == null);
var state_19439__$1 = (function (){var statearr_19443 = state_19439;
(statearr_19443[(7)] = inst_19420__$1);

return statearr_19443;
})();
if(cljs.core.truth_(inst_19421)){
var statearr_19444_19557 = state_19439__$1;
(statearr_19444_19557[(1)] = (5));

} else {
var statearr_19445_19558 = state_19439__$1;
(statearr_19445_19558[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19440 === (6))){
var inst_19425 = (state_19439[(8)]);
var inst_19420 = (state_19439[(7)]);
var inst_19425__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_19426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19427 = [inst_19420,inst_19425__$1];
var inst_19428 = (new cljs.core.PersistentVector(null,2,(5),inst_19426,inst_19427,null));
var state_19439__$1 = (function (){var statearr_19446 = state_19439;
(statearr_19446[(8)] = inst_19425__$1);

return statearr_19446;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19439__$1,(8),jobs,inst_19428);
} else {
if((state_val_19440 === (3))){
var inst_19437 = (state_19439[(2)]);
var state_19439__$1 = state_19439;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19439__$1,inst_19437);
} else {
if((state_val_19440 === (2))){
var state_19439__$1 = state_19439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19439__$1,(4),from);
} else {
if((state_val_19440 === (9))){
var inst_19432 = (state_19439[(2)]);
var state_19439__$1 = (function (){var statearr_19447 = state_19439;
(statearr_19447[(9)] = inst_19432);

return statearr_19447;
})();
var statearr_19448_19559 = state_19439__$1;
(statearr_19448_19559[(2)] = null);

(statearr_19448_19559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19440 === (5))){
var inst_19423 = cljs.core.async.close_BANG_(jobs);
var state_19439__$1 = state_19439;
var statearr_19449_19560 = state_19439__$1;
(statearr_19449_19560[(2)] = inst_19423);

(statearr_19449_19560[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19440 === (8))){
var inst_19425 = (state_19439[(8)]);
var inst_19430 = (state_19439[(2)]);
var state_19439__$1 = (function (){var statearr_19450 = state_19439;
(statearr_19450[(10)] = inst_19430);

return statearr_19450;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19439__$1,(9),results,inst_19425);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0 = (function (){
var statearr_19451 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19451[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__);

(statearr_19451[(1)] = (1));

return statearr_19451;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1 = (function (state_19439){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19439);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19452){var ex__17181__auto__ = e19452;
var statearr_19453_19561 = state_19439;
(statearr_19453_19561[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19439[(4)]))){
var statearr_19454_19562 = state_19439;
(statearr_19454_19562[(1)] = cljs.core.first((state_19439[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19563 = state_19439;
state_19439 = G__19563;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = function(state_19439){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1.call(this,state_19439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_19455 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19455[(6)] = c__17304__auto___19554);

return statearr_19455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_19493){
var state_val_19494 = (state_19493[(1)]);
if((state_val_19494 === (7))){
var inst_19489 = (state_19493[(2)]);
var state_19493__$1 = state_19493;
var statearr_19495_19564 = state_19493__$1;
(statearr_19495_19564[(2)] = inst_19489);

(statearr_19495_19564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (20))){
var state_19493__$1 = state_19493;
var statearr_19496_19565 = state_19493__$1;
(statearr_19496_19565[(2)] = null);

(statearr_19496_19565[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (1))){
var state_19493__$1 = state_19493;
var statearr_19497_19566 = state_19493__$1;
(statearr_19497_19566[(2)] = null);

(statearr_19497_19566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (4))){
var inst_19458 = (state_19493[(7)]);
var inst_19458__$1 = (state_19493[(2)]);
var inst_19459 = (inst_19458__$1 == null);
var state_19493__$1 = (function (){var statearr_19498 = state_19493;
(statearr_19498[(7)] = inst_19458__$1);

return statearr_19498;
})();
if(cljs.core.truth_(inst_19459)){
var statearr_19499_19567 = state_19493__$1;
(statearr_19499_19567[(1)] = (5));

} else {
var statearr_19500_19568 = state_19493__$1;
(statearr_19500_19568[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (15))){
var inst_19471 = (state_19493[(8)]);
var state_19493__$1 = state_19493;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19493__$1,(18),to,inst_19471);
} else {
if((state_val_19494 === (21))){
var inst_19484 = (state_19493[(2)]);
var state_19493__$1 = state_19493;
var statearr_19501_19569 = state_19493__$1;
(statearr_19501_19569[(2)] = inst_19484);

(statearr_19501_19569[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (13))){
var inst_19486 = (state_19493[(2)]);
var state_19493__$1 = (function (){var statearr_19502 = state_19493;
(statearr_19502[(9)] = inst_19486);

return statearr_19502;
})();
var statearr_19503_19570 = state_19493__$1;
(statearr_19503_19570[(2)] = null);

(statearr_19503_19570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (6))){
var inst_19458 = (state_19493[(7)]);
var state_19493__$1 = state_19493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19493__$1,(11),inst_19458);
} else {
if((state_val_19494 === (17))){
var inst_19479 = (state_19493[(2)]);
var state_19493__$1 = state_19493;
if(cljs.core.truth_(inst_19479)){
var statearr_19504_19571 = state_19493__$1;
(statearr_19504_19571[(1)] = (19));

} else {
var statearr_19505_19572 = state_19493__$1;
(statearr_19505_19572[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (3))){
var inst_19491 = (state_19493[(2)]);
var state_19493__$1 = state_19493;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19493__$1,inst_19491);
} else {
if((state_val_19494 === (12))){
var inst_19468 = (state_19493[(10)]);
var state_19493__$1 = state_19493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19493__$1,(14),inst_19468);
} else {
if((state_val_19494 === (2))){
var state_19493__$1 = state_19493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19493__$1,(4),results);
} else {
if((state_val_19494 === (19))){
var state_19493__$1 = state_19493;
var statearr_19506_19573 = state_19493__$1;
(statearr_19506_19573[(2)] = null);

(statearr_19506_19573[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (11))){
var inst_19468 = (state_19493[(2)]);
var state_19493__$1 = (function (){var statearr_19507 = state_19493;
(statearr_19507[(10)] = inst_19468);

return statearr_19507;
})();
var statearr_19508_19574 = state_19493__$1;
(statearr_19508_19574[(2)] = null);

(statearr_19508_19574[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (9))){
var state_19493__$1 = state_19493;
var statearr_19509_19575 = state_19493__$1;
(statearr_19509_19575[(2)] = null);

(statearr_19509_19575[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (5))){
var state_19493__$1 = state_19493;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19510_19576 = state_19493__$1;
(statearr_19510_19576[(1)] = (8));

} else {
var statearr_19511_19577 = state_19493__$1;
(statearr_19511_19577[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (14))){
var inst_19473 = (state_19493[(11)]);
var inst_19471 = (state_19493[(8)]);
var inst_19471__$1 = (state_19493[(2)]);
var inst_19472 = (inst_19471__$1 == null);
var inst_19473__$1 = cljs.core.not(inst_19472);
var state_19493__$1 = (function (){var statearr_19512 = state_19493;
(statearr_19512[(11)] = inst_19473__$1);

(statearr_19512[(8)] = inst_19471__$1);

return statearr_19512;
})();
if(inst_19473__$1){
var statearr_19513_19578 = state_19493__$1;
(statearr_19513_19578[(1)] = (15));

} else {
var statearr_19514_19579 = state_19493__$1;
(statearr_19514_19579[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (16))){
var inst_19473 = (state_19493[(11)]);
var state_19493__$1 = state_19493;
var statearr_19515_19580 = state_19493__$1;
(statearr_19515_19580[(2)] = inst_19473);

(statearr_19515_19580[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (10))){
var inst_19465 = (state_19493[(2)]);
var state_19493__$1 = state_19493;
var statearr_19516_19581 = state_19493__$1;
(statearr_19516_19581[(2)] = inst_19465);

(statearr_19516_19581[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (18))){
var inst_19476 = (state_19493[(2)]);
var state_19493__$1 = state_19493;
var statearr_19517_19582 = state_19493__$1;
(statearr_19517_19582[(2)] = inst_19476);

(statearr_19517_19582[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19494 === (8))){
var inst_19462 = cljs.core.async.close_BANG_(to);
var state_19493__$1 = state_19493;
var statearr_19518_19583 = state_19493__$1;
(statearr_19518_19583[(2)] = inst_19462);

(statearr_19518_19583[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0 = (function (){
var statearr_19519 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19519[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__);

(statearr_19519[(1)] = (1));

return statearr_19519;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1 = (function (state_19493){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19493);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19520){var ex__17181__auto__ = e19520;
var statearr_19521_19584 = state_19493;
(statearr_19521_19584[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19493[(4)]))){
var statearr_19522_19585 = state_19493;
(statearr_19522_19585[(1)] = cljs.core.first((state_19493[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19586 = state_19493;
state_19493 = G__19586;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = function(state_19493){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1.call(this,state_19493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_19523 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19523[(6)] = c__17304__auto__);

return statearr_19523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__19588 = arguments.length;
switch (G__19588) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__19591 = arguments.length;
switch (G__19591) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__19594 = arguments.length;
switch (G__19594) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__17304__auto___19644 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_19620){
var state_val_19621 = (state_19620[(1)]);
if((state_val_19621 === (7))){
var inst_19616 = (state_19620[(2)]);
var state_19620__$1 = state_19620;
var statearr_19622_19645 = state_19620__$1;
(statearr_19622_19645[(2)] = inst_19616);

(statearr_19622_19645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (1))){
var state_19620__$1 = state_19620;
var statearr_19623_19646 = state_19620__$1;
(statearr_19623_19646[(2)] = null);

(statearr_19623_19646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (4))){
var inst_19597 = (state_19620[(7)]);
var inst_19597__$1 = (state_19620[(2)]);
var inst_19598 = (inst_19597__$1 == null);
var state_19620__$1 = (function (){var statearr_19624 = state_19620;
(statearr_19624[(7)] = inst_19597__$1);

return statearr_19624;
})();
if(cljs.core.truth_(inst_19598)){
var statearr_19625_19647 = state_19620__$1;
(statearr_19625_19647[(1)] = (5));

} else {
var statearr_19626_19648 = state_19620__$1;
(statearr_19626_19648[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (13))){
var state_19620__$1 = state_19620;
var statearr_19627_19649 = state_19620__$1;
(statearr_19627_19649[(2)] = null);

(statearr_19627_19649[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (6))){
var inst_19597 = (state_19620[(7)]);
var inst_19603 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_19597) : p.call(null,inst_19597));
var state_19620__$1 = state_19620;
if(cljs.core.truth_(inst_19603)){
var statearr_19628_19650 = state_19620__$1;
(statearr_19628_19650[(1)] = (9));

} else {
var statearr_19629_19651 = state_19620__$1;
(statearr_19629_19651[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (3))){
var inst_19618 = (state_19620[(2)]);
var state_19620__$1 = state_19620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19620__$1,inst_19618);
} else {
if((state_val_19621 === (12))){
var state_19620__$1 = state_19620;
var statearr_19630_19652 = state_19620__$1;
(statearr_19630_19652[(2)] = null);

(statearr_19630_19652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (2))){
var state_19620__$1 = state_19620;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19620__$1,(4),ch);
} else {
if((state_val_19621 === (11))){
var inst_19597 = (state_19620[(7)]);
var inst_19607 = (state_19620[(2)]);
var state_19620__$1 = state_19620;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19620__$1,(8),inst_19607,inst_19597);
} else {
if((state_val_19621 === (9))){
var state_19620__$1 = state_19620;
var statearr_19631_19653 = state_19620__$1;
(statearr_19631_19653[(2)] = tc);

(statearr_19631_19653[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (5))){
var inst_19600 = cljs.core.async.close_BANG_(tc);
var inst_19601 = cljs.core.async.close_BANG_(fc);
var state_19620__$1 = (function (){var statearr_19632 = state_19620;
(statearr_19632[(8)] = inst_19600);

return statearr_19632;
})();
var statearr_19633_19654 = state_19620__$1;
(statearr_19633_19654[(2)] = inst_19601);

(statearr_19633_19654[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (14))){
var inst_19614 = (state_19620[(2)]);
var state_19620__$1 = state_19620;
var statearr_19634_19655 = state_19620__$1;
(statearr_19634_19655[(2)] = inst_19614);

(statearr_19634_19655[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (10))){
var state_19620__$1 = state_19620;
var statearr_19635_19656 = state_19620__$1;
(statearr_19635_19656[(2)] = fc);

(statearr_19635_19656[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (8))){
var inst_19609 = (state_19620[(2)]);
var state_19620__$1 = state_19620;
if(cljs.core.truth_(inst_19609)){
var statearr_19636_19657 = state_19620__$1;
(statearr_19636_19657[(1)] = (12));

} else {
var statearr_19637_19658 = state_19620__$1;
(statearr_19637_19658[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_19638 = [null,null,null,null,null,null,null,null,null];
(statearr_19638[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_19638[(1)] = (1));

return statearr_19638;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_19620){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19620);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19639){var ex__17181__auto__ = e19639;
var statearr_19640_19659 = state_19620;
(statearr_19640_19659[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19620[(4)]))){
var statearr_19641_19660 = state_19620;
(statearr_19641_19660[(1)] = cljs.core.first((state_19620[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19661 = state_19620;
state_19620 = G__19661;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_19620){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_19620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_19642 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19642[(6)] = c__17304__auto___19644);

return statearr_19642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_19683){
var state_val_19684 = (state_19683[(1)]);
if((state_val_19684 === (7))){
var inst_19679 = (state_19683[(2)]);
var state_19683__$1 = state_19683;
var statearr_19685_19704 = state_19683__$1;
(statearr_19685_19704[(2)] = inst_19679);

(statearr_19685_19704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19684 === (1))){
var inst_19662 = init;
var inst_19663 = inst_19662;
var state_19683__$1 = (function (){var statearr_19686 = state_19683;
(statearr_19686[(7)] = inst_19663);

return statearr_19686;
})();
var statearr_19687_19705 = state_19683__$1;
(statearr_19687_19705[(2)] = null);

(statearr_19687_19705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19684 === (4))){
var inst_19666 = (state_19683[(8)]);
var inst_19666__$1 = (state_19683[(2)]);
var inst_19667 = (inst_19666__$1 == null);
var state_19683__$1 = (function (){var statearr_19688 = state_19683;
(statearr_19688[(8)] = inst_19666__$1);

return statearr_19688;
})();
if(cljs.core.truth_(inst_19667)){
var statearr_19689_19706 = state_19683__$1;
(statearr_19689_19706[(1)] = (5));

} else {
var statearr_19690_19707 = state_19683__$1;
(statearr_19690_19707[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19684 === (6))){
var inst_19663 = (state_19683[(7)]);
var inst_19666 = (state_19683[(8)]);
var inst_19670 = (state_19683[(9)]);
var inst_19670__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_19663,inst_19666) : f.call(null,inst_19663,inst_19666));
var inst_19671 = cljs.core.reduced_QMARK_(inst_19670__$1);
var state_19683__$1 = (function (){var statearr_19691 = state_19683;
(statearr_19691[(9)] = inst_19670__$1);

return statearr_19691;
})();
if(inst_19671){
var statearr_19692_19708 = state_19683__$1;
(statearr_19692_19708[(1)] = (8));

} else {
var statearr_19693_19709 = state_19683__$1;
(statearr_19693_19709[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19684 === (3))){
var inst_19681 = (state_19683[(2)]);
var state_19683__$1 = state_19683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19683__$1,inst_19681);
} else {
if((state_val_19684 === (2))){
var state_19683__$1 = state_19683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19683__$1,(4),ch);
} else {
if((state_val_19684 === (9))){
var inst_19670 = (state_19683[(9)]);
var inst_19663 = inst_19670;
var state_19683__$1 = (function (){var statearr_19694 = state_19683;
(statearr_19694[(7)] = inst_19663);

return statearr_19694;
})();
var statearr_19695_19710 = state_19683__$1;
(statearr_19695_19710[(2)] = null);

(statearr_19695_19710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19684 === (5))){
var inst_19663 = (state_19683[(7)]);
var state_19683__$1 = state_19683;
var statearr_19696_19711 = state_19683__$1;
(statearr_19696_19711[(2)] = inst_19663);

(statearr_19696_19711[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19684 === (10))){
var inst_19677 = (state_19683[(2)]);
var state_19683__$1 = state_19683;
var statearr_19697_19712 = state_19683__$1;
(statearr_19697_19712[(2)] = inst_19677);

(statearr_19697_19712[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19684 === (8))){
var inst_19670 = (state_19683[(9)]);
var inst_19673 = cljs.core.deref(inst_19670);
var state_19683__$1 = state_19683;
var statearr_19698_19713 = state_19683__$1;
(statearr_19698_19713[(2)] = inst_19673);

(statearr_19698_19713[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__17178__auto__ = null;
var cljs$core$async$reduce_$_state_machine__17178__auto____0 = (function (){
var statearr_19699 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19699[(0)] = cljs$core$async$reduce_$_state_machine__17178__auto__);

(statearr_19699[(1)] = (1));

return statearr_19699;
});
var cljs$core$async$reduce_$_state_machine__17178__auto____1 = (function (state_19683){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19683);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19700){var ex__17181__auto__ = e19700;
var statearr_19701_19714 = state_19683;
(statearr_19701_19714[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19683[(4)]))){
var statearr_19702_19715 = state_19683;
(statearr_19702_19715[(1)] = cljs.core.first((state_19683[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19716 = state_19683;
state_19683 = G__19716;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__17178__auto__ = function(state_19683){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__17178__auto____1.call(this,state_19683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__17178__auto____0;
cljs$core$async$reduce_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__17178__auto____1;
return cljs$core$async$reduce_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_19703 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19703[(6)] = c__17304__auto__);

return statearr_19703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_19722){
var state_val_19723 = (state_19722[(1)]);
if((state_val_19723 === (1))){
var inst_19717 = cljs.core.async.reduce(f__$1,init,ch);
var state_19722__$1 = state_19722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19722__$1,(2),inst_19717);
} else {
if((state_val_19723 === (2))){
var inst_19719 = (state_19722[(2)]);
var inst_19720 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_19719) : f__$1.call(null,inst_19719));
var state_19722__$1 = state_19722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19722__$1,inst_19720);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__17178__auto__ = null;
var cljs$core$async$transduce_$_state_machine__17178__auto____0 = (function (){
var statearr_19724 = [null,null,null,null,null,null,null];
(statearr_19724[(0)] = cljs$core$async$transduce_$_state_machine__17178__auto__);

(statearr_19724[(1)] = (1));

return statearr_19724;
});
var cljs$core$async$transduce_$_state_machine__17178__auto____1 = (function (state_19722){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19722);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19725){var ex__17181__auto__ = e19725;
var statearr_19726_19729 = state_19722;
(statearr_19726_19729[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19722[(4)]))){
var statearr_19727_19730 = state_19722;
(statearr_19727_19730[(1)] = cljs.core.first((state_19722[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19731 = state_19722;
state_19722 = G__19731;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__17178__auto__ = function(state_19722){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__17178__auto____1.call(this,state_19722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__17178__auto____0;
cljs$core$async$transduce_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__17178__auto____1;
return cljs$core$async$transduce_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_19728 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19728[(6)] = c__17304__auto__);

return statearr_19728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__19733 = arguments.length;
switch (G__19733) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_19758){
var state_val_19759 = (state_19758[(1)]);
if((state_val_19759 === (7))){
var inst_19740 = (state_19758[(2)]);
var state_19758__$1 = state_19758;
var statearr_19760_19782 = state_19758__$1;
(statearr_19760_19782[(2)] = inst_19740);

(statearr_19760_19782[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19759 === (1))){
var inst_19734 = cljs.core.seq(coll);
var inst_19735 = inst_19734;
var state_19758__$1 = (function (){var statearr_19761 = state_19758;
(statearr_19761[(7)] = inst_19735);

return statearr_19761;
})();
var statearr_19762_19783 = state_19758__$1;
(statearr_19762_19783[(2)] = null);

(statearr_19762_19783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19759 === (4))){
var inst_19735 = (state_19758[(7)]);
var inst_19738 = cljs.core.first(inst_19735);
var state_19758__$1 = state_19758;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19758__$1,(7),ch,inst_19738);
} else {
if((state_val_19759 === (13))){
var inst_19752 = (state_19758[(2)]);
var state_19758__$1 = state_19758;
var statearr_19763_19784 = state_19758__$1;
(statearr_19763_19784[(2)] = inst_19752);

(statearr_19763_19784[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19759 === (6))){
var inst_19743 = (state_19758[(2)]);
var state_19758__$1 = state_19758;
if(cljs.core.truth_(inst_19743)){
var statearr_19764_19785 = state_19758__$1;
(statearr_19764_19785[(1)] = (8));

} else {
var statearr_19765_19786 = state_19758__$1;
(statearr_19765_19786[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19759 === (3))){
var inst_19756 = (state_19758[(2)]);
var state_19758__$1 = state_19758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19758__$1,inst_19756);
} else {
if((state_val_19759 === (12))){
var state_19758__$1 = state_19758;
var statearr_19766_19787 = state_19758__$1;
(statearr_19766_19787[(2)] = null);

(statearr_19766_19787[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19759 === (2))){
var inst_19735 = (state_19758[(7)]);
var state_19758__$1 = state_19758;
if(cljs.core.truth_(inst_19735)){
var statearr_19767_19788 = state_19758__$1;
(statearr_19767_19788[(1)] = (4));

} else {
var statearr_19768_19789 = state_19758__$1;
(statearr_19768_19789[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19759 === (11))){
var inst_19749 = cljs.core.async.close_BANG_(ch);
var state_19758__$1 = state_19758;
var statearr_19769_19790 = state_19758__$1;
(statearr_19769_19790[(2)] = inst_19749);

(statearr_19769_19790[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19759 === (9))){
var state_19758__$1 = state_19758;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19770_19791 = state_19758__$1;
(statearr_19770_19791[(1)] = (11));

} else {
var statearr_19771_19792 = state_19758__$1;
(statearr_19771_19792[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19759 === (5))){
var inst_19735 = (state_19758[(7)]);
var state_19758__$1 = state_19758;
var statearr_19772_19793 = state_19758__$1;
(statearr_19772_19793[(2)] = inst_19735);

(statearr_19772_19793[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19759 === (10))){
var inst_19754 = (state_19758[(2)]);
var state_19758__$1 = state_19758;
var statearr_19773_19794 = state_19758__$1;
(statearr_19773_19794[(2)] = inst_19754);

(statearr_19773_19794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19759 === (8))){
var inst_19735 = (state_19758[(7)]);
var inst_19745 = cljs.core.next(inst_19735);
var inst_19735__$1 = inst_19745;
var state_19758__$1 = (function (){var statearr_19774 = state_19758;
(statearr_19774[(7)] = inst_19735__$1);

return statearr_19774;
})();
var statearr_19775_19795 = state_19758__$1;
(statearr_19775_19795[(2)] = null);

(statearr_19775_19795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_19776 = [null,null,null,null,null,null,null,null];
(statearr_19776[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_19776[(1)] = (1));

return statearr_19776;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_19758){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19758);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19777){var ex__17181__auto__ = e19777;
var statearr_19778_19796 = state_19758;
(statearr_19778_19796[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19758[(4)]))){
var statearr_19779_19797 = state_19758;
(statearr_19779_19797[(1)] = cljs.core.first((state_19758[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19798 = state_19758;
state_19758 = G__19798;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_19758){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_19758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_19780 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19780[(6)] = c__17304__auto__);

return statearr_19780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__19800 = arguments.length;
switch (G__19800) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_19802 = (function (_){
var x__4509__auto__ = (((_ == null))?null:_);
var m__4510__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4510__auto__.call(null,_));
} else {
var m__4508__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4508__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_19802(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_19803 = (function (m,ch,close_QMARK_){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4510__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4508__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_19803(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_19804 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_19804(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_19805 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_19805(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async19806 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19806 = (function (ch,cs,meta19807){
this.ch = ch;
this.cs = cs;
this.meta19807 = meta19807;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async19806.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19808,meta19807__$1){
var self__ = this;
var _19808__$1 = this;
return (new cljs.core.async.t_cljs$core$async19806(self__.ch,self__.cs,meta19807__$1));
}));

(cljs.core.async.t_cljs$core$async19806.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19808){
var self__ = this;
var _19808__$1 = this;
return self__.meta19807;
}));

(cljs.core.async.t_cljs$core$async19806.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19806.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async19806.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async19806.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async19806.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async19806.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async19806.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta19807","meta19807",35545187,null)], null);
}));

(cljs.core.async.t_cljs$core$async19806.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async19806.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19806");

(cljs.core.async.t_cljs$core$async19806.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async19806");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async19806.
 */
cljs.core.async.__GT_t_cljs$core$async19806 = (function cljs$core$async$mult_$___GT_t_cljs$core$async19806(ch__$1,cs__$1,meta19807){
return (new cljs.core.async.t_cljs$core$async19806(ch__$1,cs__$1,meta19807));
});

}

return (new cljs.core.async.t_cljs$core$async19806(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__17304__auto___20025 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_19941){
var state_val_19942 = (state_19941[(1)]);
if((state_val_19942 === (7))){
var inst_19937 = (state_19941[(2)]);
var state_19941__$1 = state_19941;
var statearr_19943_20026 = state_19941__$1;
(statearr_19943_20026[(2)] = inst_19937);

(statearr_19943_20026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (20))){
var inst_19842 = (state_19941[(7)]);
var inst_19854 = cljs.core.first(inst_19842);
var inst_19855 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19854,(0),null);
var inst_19856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19854,(1),null);
var state_19941__$1 = (function (){var statearr_19944 = state_19941;
(statearr_19944[(8)] = inst_19855);

return statearr_19944;
})();
if(cljs.core.truth_(inst_19856)){
var statearr_19945_20027 = state_19941__$1;
(statearr_19945_20027[(1)] = (22));

} else {
var statearr_19946_20028 = state_19941__$1;
(statearr_19946_20028[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (27))){
var inst_19886 = (state_19941[(9)]);
var inst_19884 = (state_19941[(10)]);
var inst_19891 = (state_19941[(11)]);
var inst_19811 = (state_19941[(12)]);
var inst_19891__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_19884,inst_19886);
var inst_19892 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_19891__$1,inst_19811,done);
var state_19941__$1 = (function (){var statearr_19947 = state_19941;
(statearr_19947[(11)] = inst_19891__$1);

return statearr_19947;
})();
if(cljs.core.truth_(inst_19892)){
var statearr_19948_20029 = state_19941__$1;
(statearr_19948_20029[(1)] = (30));

} else {
var statearr_19949_20030 = state_19941__$1;
(statearr_19949_20030[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (1))){
var state_19941__$1 = state_19941;
var statearr_19950_20031 = state_19941__$1;
(statearr_19950_20031[(2)] = null);

(statearr_19950_20031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (24))){
var inst_19842 = (state_19941[(7)]);
var inst_19861 = (state_19941[(2)]);
var inst_19862 = cljs.core.next(inst_19842);
var inst_19820 = inst_19862;
var inst_19821 = null;
var inst_19822 = (0);
var inst_19823 = (0);
var state_19941__$1 = (function (){var statearr_19951 = state_19941;
(statearr_19951[(13)] = inst_19822);

(statearr_19951[(14)] = inst_19820);

(statearr_19951[(15)] = inst_19861);

(statearr_19951[(16)] = inst_19821);

(statearr_19951[(17)] = inst_19823);

return statearr_19951;
})();
var statearr_19952_20032 = state_19941__$1;
(statearr_19952_20032[(2)] = null);

(statearr_19952_20032[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (39))){
var state_19941__$1 = state_19941;
var statearr_19956_20033 = state_19941__$1;
(statearr_19956_20033[(2)] = null);

(statearr_19956_20033[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (4))){
var inst_19811 = (state_19941[(12)]);
var inst_19811__$1 = (state_19941[(2)]);
var inst_19812 = (inst_19811__$1 == null);
var state_19941__$1 = (function (){var statearr_19957 = state_19941;
(statearr_19957[(12)] = inst_19811__$1);

return statearr_19957;
})();
if(cljs.core.truth_(inst_19812)){
var statearr_19958_20034 = state_19941__$1;
(statearr_19958_20034[(1)] = (5));

} else {
var statearr_19959_20035 = state_19941__$1;
(statearr_19959_20035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (15))){
var inst_19822 = (state_19941[(13)]);
var inst_19820 = (state_19941[(14)]);
var inst_19821 = (state_19941[(16)]);
var inst_19823 = (state_19941[(17)]);
var inst_19838 = (state_19941[(2)]);
var inst_19839 = (inst_19823 + (1));
var tmp19953 = inst_19822;
var tmp19954 = inst_19820;
var tmp19955 = inst_19821;
var inst_19820__$1 = tmp19954;
var inst_19821__$1 = tmp19955;
var inst_19822__$1 = tmp19953;
var inst_19823__$1 = inst_19839;
var state_19941__$1 = (function (){var statearr_19960 = state_19941;
(statearr_19960[(13)] = inst_19822__$1);

(statearr_19960[(14)] = inst_19820__$1);

(statearr_19960[(16)] = inst_19821__$1);

(statearr_19960[(18)] = inst_19838);

(statearr_19960[(17)] = inst_19823__$1);

return statearr_19960;
})();
var statearr_19961_20036 = state_19941__$1;
(statearr_19961_20036[(2)] = null);

(statearr_19961_20036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (21))){
var inst_19865 = (state_19941[(2)]);
var state_19941__$1 = state_19941;
var statearr_19965_20037 = state_19941__$1;
(statearr_19965_20037[(2)] = inst_19865);

(statearr_19965_20037[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (31))){
var inst_19891 = (state_19941[(11)]);
var inst_19895 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_19891);
var state_19941__$1 = state_19941;
var statearr_19966_20038 = state_19941__$1;
(statearr_19966_20038[(2)] = inst_19895);

(statearr_19966_20038[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (32))){
var inst_19883 = (state_19941[(19)]);
var inst_19886 = (state_19941[(9)]);
var inst_19885 = (state_19941[(20)]);
var inst_19884 = (state_19941[(10)]);
var inst_19897 = (state_19941[(2)]);
var inst_19898 = (inst_19886 + (1));
var tmp19962 = inst_19883;
var tmp19963 = inst_19885;
var tmp19964 = inst_19884;
var inst_19883__$1 = tmp19962;
var inst_19884__$1 = tmp19964;
var inst_19885__$1 = tmp19963;
var inst_19886__$1 = inst_19898;
var state_19941__$1 = (function (){var statearr_19967 = state_19941;
(statearr_19967[(21)] = inst_19897);

(statearr_19967[(19)] = inst_19883__$1);

(statearr_19967[(9)] = inst_19886__$1);

(statearr_19967[(20)] = inst_19885__$1);

(statearr_19967[(10)] = inst_19884__$1);

return statearr_19967;
})();
var statearr_19968_20039 = state_19941__$1;
(statearr_19968_20039[(2)] = null);

(statearr_19968_20039[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (40))){
var inst_19910 = (state_19941[(22)]);
var inst_19914 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_19910);
var state_19941__$1 = state_19941;
var statearr_19969_20040 = state_19941__$1;
(statearr_19969_20040[(2)] = inst_19914);

(statearr_19969_20040[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (33))){
var inst_19901 = (state_19941[(23)]);
var inst_19903 = cljs.core.chunked_seq_QMARK_(inst_19901);
var state_19941__$1 = state_19941;
if(inst_19903){
var statearr_19970_20041 = state_19941__$1;
(statearr_19970_20041[(1)] = (36));

} else {
var statearr_19971_20042 = state_19941__$1;
(statearr_19971_20042[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (13))){
var inst_19832 = (state_19941[(24)]);
var inst_19835 = cljs.core.async.close_BANG_(inst_19832);
var state_19941__$1 = state_19941;
var statearr_19972_20043 = state_19941__$1;
(statearr_19972_20043[(2)] = inst_19835);

(statearr_19972_20043[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (22))){
var inst_19855 = (state_19941[(8)]);
var inst_19858 = cljs.core.async.close_BANG_(inst_19855);
var state_19941__$1 = state_19941;
var statearr_19973_20044 = state_19941__$1;
(statearr_19973_20044[(2)] = inst_19858);

(statearr_19973_20044[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (36))){
var inst_19901 = (state_19941[(23)]);
var inst_19905 = cljs.core.chunk_first(inst_19901);
var inst_19906 = cljs.core.chunk_rest(inst_19901);
var inst_19907 = cljs.core.count(inst_19905);
var inst_19883 = inst_19906;
var inst_19884 = inst_19905;
var inst_19885 = inst_19907;
var inst_19886 = (0);
var state_19941__$1 = (function (){var statearr_19974 = state_19941;
(statearr_19974[(19)] = inst_19883);

(statearr_19974[(9)] = inst_19886);

(statearr_19974[(20)] = inst_19885);

(statearr_19974[(10)] = inst_19884);

return statearr_19974;
})();
var statearr_19975_20045 = state_19941__$1;
(statearr_19975_20045[(2)] = null);

(statearr_19975_20045[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (41))){
var inst_19901 = (state_19941[(23)]);
var inst_19916 = (state_19941[(2)]);
var inst_19917 = cljs.core.next(inst_19901);
var inst_19883 = inst_19917;
var inst_19884 = null;
var inst_19885 = (0);
var inst_19886 = (0);
var state_19941__$1 = (function (){var statearr_19976 = state_19941;
(statearr_19976[(19)] = inst_19883);

(statearr_19976[(9)] = inst_19886);

(statearr_19976[(25)] = inst_19916);

(statearr_19976[(20)] = inst_19885);

(statearr_19976[(10)] = inst_19884);

return statearr_19976;
})();
var statearr_19977_20046 = state_19941__$1;
(statearr_19977_20046[(2)] = null);

(statearr_19977_20046[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (43))){
var state_19941__$1 = state_19941;
var statearr_19978_20047 = state_19941__$1;
(statearr_19978_20047[(2)] = null);

(statearr_19978_20047[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (29))){
var inst_19925 = (state_19941[(2)]);
var state_19941__$1 = state_19941;
var statearr_19979_20048 = state_19941__$1;
(statearr_19979_20048[(2)] = inst_19925);

(statearr_19979_20048[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (44))){
var inst_19934 = (state_19941[(2)]);
var state_19941__$1 = (function (){var statearr_19980 = state_19941;
(statearr_19980[(26)] = inst_19934);

return statearr_19980;
})();
var statearr_19981_20049 = state_19941__$1;
(statearr_19981_20049[(2)] = null);

(statearr_19981_20049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (6))){
var inst_19875 = (state_19941[(27)]);
var inst_19874 = cljs.core.deref(cs);
var inst_19875__$1 = cljs.core.keys(inst_19874);
var inst_19876 = cljs.core.count(inst_19875__$1);
var inst_19877 = cljs.core.reset_BANG_(dctr,inst_19876);
var inst_19882 = cljs.core.seq(inst_19875__$1);
var inst_19883 = inst_19882;
var inst_19884 = null;
var inst_19885 = (0);
var inst_19886 = (0);
var state_19941__$1 = (function (){var statearr_19982 = state_19941;
(statearr_19982[(19)] = inst_19883);

(statearr_19982[(9)] = inst_19886);

(statearr_19982[(20)] = inst_19885);

(statearr_19982[(10)] = inst_19884);

(statearr_19982[(27)] = inst_19875__$1);

(statearr_19982[(28)] = inst_19877);

return statearr_19982;
})();
var statearr_19983_20050 = state_19941__$1;
(statearr_19983_20050[(2)] = null);

(statearr_19983_20050[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (28))){
var inst_19883 = (state_19941[(19)]);
var inst_19901 = (state_19941[(23)]);
var inst_19901__$1 = cljs.core.seq(inst_19883);
var state_19941__$1 = (function (){var statearr_19984 = state_19941;
(statearr_19984[(23)] = inst_19901__$1);

return statearr_19984;
})();
if(inst_19901__$1){
var statearr_19985_20051 = state_19941__$1;
(statearr_19985_20051[(1)] = (33));

} else {
var statearr_19986_20052 = state_19941__$1;
(statearr_19986_20052[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (25))){
var inst_19886 = (state_19941[(9)]);
var inst_19885 = (state_19941[(20)]);
var inst_19888 = (inst_19886 < inst_19885);
var inst_19889 = inst_19888;
var state_19941__$1 = state_19941;
if(cljs.core.truth_(inst_19889)){
var statearr_19987_20053 = state_19941__$1;
(statearr_19987_20053[(1)] = (27));

} else {
var statearr_19988_20054 = state_19941__$1;
(statearr_19988_20054[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (34))){
var state_19941__$1 = state_19941;
var statearr_19989_20055 = state_19941__$1;
(statearr_19989_20055[(2)] = null);

(statearr_19989_20055[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (17))){
var state_19941__$1 = state_19941;
var statearr_19990_20056 = state_19941__$1;
(statearr_19990_20056[(2)] = null);

(statearr_19990_20056[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (3))){
var inst_19939 = (state_19941[(2)]);
var state_19941__$1 = state_19941;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19941__$1,inst_19939);
} else {
if((state_val_19942 === (12))){
var inst_19870 = (state_19941[(2)]);
var state_19941__$1 = state_19941;
var statearr_19991_20057 = state_19941__$1;
(statearr_19991_20057[(2)] = inst_19870);

(statearr_19991_20057[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (2))){
var state_19941__$1 = state_19941;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19941__$1,(4),ch);
} else {
if((state_val_19942 === (23))){
var state_19941__$1 = state_19941;
var statearr_19992_20058 = state_19941__$1;
(statearr_19992_20058[(2)] = null);

(statearr_19992_20058[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (35))){
var inst_19923 = (state_19941[(2)]);
var state_19941__$1 = state_19941;
var statearr_19993_20059 = state_19941__$1;
(statearr_19993_20059[(2)] = inst_19923);

(statearr_19993_20059[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (19))){
var inst_19842 = (state_19941[(7)]);
var inst_19846 = cljs.core.chunk_first(inst_19842);
var inst_19847 = cljs.core.chunk_rest(inst_19842);
var inst_19848 = cljs.core.count(inst_19846);
var inst_19820 = inst_19847;
var inst_19821 = inst_19846;
var inst_19822 = inst_19848;
var inst_19823 = (0);
var state_19941__$1 = (function (){var statearr_19994 = state_19941;
(statearr_19994[(13)] = inst_19822);

(statearr_19994[(14)] = inst_19820);

(statearr_19994[(16)] = inst_19821);

(statearr_19994[(17)] = inst_19823);

return statearr_19994;
})();
var statearr_19995_20060 = state_19941__$1;
(statearr_19995_20060[(2)] = null);

(statearr_19995_20060[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (11))){
var inst_19842 = (state_19941[(7)]);
var inst_19820 = (state_19941[(14)]);
var inst_19842__$1 = cljs.core.seq(inst_19820);
var state_19941__$1 = (function (){var statearr_19996 = state_19941;
(statearr_19996[(7)] = inst_19842__$1);

return statearr_19996;
})();
if(inst_19842__$1){
var statearr_19997_20061 = state_19941__$1;
(statearr_19997_20061[(1)] = (16));

} else {
var statearr_19998_20062 = state_19941__$1;
(statearr_19998_20062[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (9))){
var inst_19872 = (state_19941[(2)]);
var state_19941__$1 = state_19941;
var statearr_19999_20063 = state_19941__$1;
(statearr_19999_20063[(2)] = inst_19872);

(statearr_19999_20063[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (5))){
var inst_19818 = cljs.core.deref(cs);
var inst_19819 = cljs.core.seq(inst_19818);
var inst_19820 = inst_19819;
var inst_19821 = null;
var inst_19822 = (0);
var inst_19823 = (0);
var state_19941__$1 = (function (){var statearr_20000 = state_19941;
(statearr_20000[(13)] = inst_19822);

(statearr_20000[(14)] = inst_19820);

(statearr_20000[(16)] = inst_19821);

(statearr_20000[(17)] = inst_19823);

return statearr_20000;
})();
var statearr_20001_20064 = state_19941__$1;
(statearr_20001_20064[(2)] = null);

(statearr_20001_20064[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (14))){
var state_19941__$1 = state_19941;
var statearr_20002_20065 = state_19941__$1;
(statearr_20002_20065[(2)] = null);

(statearr_20002_20065[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (45))){
var inst_19931 = (state_19941[(2)]);
var state_19941__$1 = state_19941;
var statearr_20003_20066 = state_19941__$1;
(statearr_20003_20066[(2)] = inst_19931);

(statearr_20003_20066[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (26))){
var inst_19875 = (state_19941[(27)]);
var inst_19927 = (state_19941[(2)]);
var inst_19928 = cljs.core.seq(inst_19875);
var state_19941__$1 = (function (){var statearr_20004 = state_19941;
(statearr_20004[(29)] = inst_19927);

return statearr_20004;
})();
if(inst_19928){
var statearr_20005_20067 = state_19941__$1;
(statearr_20005_20067[(1)] = (42));

} else {
var statearr_20006_20068 = state_19941__$1;
(statearr_20006_20068[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (16))){
var inst_19842 = (state_19941[(7)]);
var inst_19844 = cljs.core.chunked_seq_QMARK_(inst_19842);
var state_19941__$1 = state_19941;
if(inst_19844){
var statearr_20007_20069 = state_19941__$1;
(statearr_20007_20069[(1)] = (19));

} else {
var statearr_20008_20070 = state_19941__$1;
(statearr_20008_20070[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (38))){
var inst_19920 = (state_19941[(2)]);
var state_19941__$1 = state_19941;
var statearr_20009_20071 = state_19941__$1;
(statearr_20009_20071[(2)] = inst_19920);

(statearr_20009_20071[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (30))){
var state_19941__$1 = state_19941;
var statearr_20010_20072 = state_19941__$1;
(statearr_20010_20072[(2)] = null);

(statearr_20010_20072[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (10))){
var inst_19821 = (state_19941[(16)]);
var inst_19823 = (state_19941[(17)]);
var inst_19831 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_19821,inst_19823);
var inst_19832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19831,(0),null);
var inst_19833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19831,(1),null);
var state_19941__$1 = (function (){var statearr_20011 = state_19941;
(statearr_20011[(24)] = inst_19832);

return statearr_20011;
})();
if(cljs.core.truth_(inst_19833)){
var statearr_20012_20073 = state_19941__$1;
(statearr_20012_20073[(1)] = (13));

} else {
var statearr_20013_20074 = state_19941__$1;
(statearr_20013_20074[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (18))){
var inst_19868 = (state_19941[(2)]);
var state_19941__$1 = state_19941;
var statearr_20014_20075 = state_19941__$1;
(statearr_20014_20075[(2)] = inst_19868);

(statearr_20014_20075[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (42))){
var state_19941__$1 = state_19941;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19941__$1,(45),dchan);
} else {
if((state_val_19942 === (37))){
var inst_19901 = (state_19941[(23)]);
var inst_19811 = (state_19941[(12)]);
var inst_19910 = (state_19941[(22)]);
var inst_19910__$1 = cljs.core.first(inst_19901);
var inst_19911 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_19910__$1,inst_19811,done);
var state_19941__$1 = (function (){var statearr_20015 = state_19941;
(statearr_20015[(22)] = inst_19910__$1);

return statearr_20015;
})();
if(cljs.core.truth_(inst_19911)){
var statearr_20016_20076 = state_19941__$1;
(statearr_20016_20076[(1)] = (39));

} else {
var statearr_20017_20077 = state_19941__$1;
(statearr_20017_20077[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19942 === (8))){
var inst_19822 = (state_19941[(13)]);
var inst_19823 = (state_19941[(17)]);
var inst_19825 = (inst_19823 < inst_19822);
var inst_19826 = inst_19825;
var state_19941__$1 = state_19941;
if(cljs.core.truth_(inst_19826)){
var statearr_20018_20078 = state_19941__$1;
(statearr_20018_20078[(1)] = (10));

} else {
var statearr_20019_20079 = state_19941__$1;
(statearr_20019_20079[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__17178__auto__ = null;
var cljs$core$async$mult_$_state_machine__17178__auto____0 = (function (){
var statearr_20020 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20020[(0)] = cljs$core$async$mult_$_state_machine__17178__auto__);

(statearr_20020[(1)] = (1));

return statearr_20020;
});
var cljs$core$async$mult_$_state_machine__17178__auto____1 = (function (state_19941){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19941);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e20021){var ex__17181__auto__ = e20021;
var statearr_20022_20080 = state_19941;
(statearr_20022_20080[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19941[(4)]))){
var statearr_20023_20081 = state_19941;
(statearr_20023_20081[(1)] = cljs.core.first((state_19941[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20082 = state_19941;
state_19941 = G__20082;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__17178__auto__ = function(state_19941){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__17178__auto____1.call(this,state_19941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__17178__auto____0;
cljs$core$async$mult_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__17178__auto____1;
return cljs$core$async$mult_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_20024 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_20024[(6)] = c__17304__auto___20025);

return statearr_20024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__20084 = arguments.length;
switch (G__20084) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_20086 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_20086(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_20087 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_20087(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_20088 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_20088(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_20089 = (function (m,state_map){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4510__auto__.call(null,m,state_map));
} else {
var m__4508__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4508__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_20089(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_20090 = (function (m,mode){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4510__auto__.call(null,m,mode));
} else {
var m__4508__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4508__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_20090(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___20100 = arguments.length;
var i__4819__auto___20101 = (0);
while(true){
if((i__4819__auto___20101 < len__4818__auto___20100)){
args__4824__auto__.push((arguments[i__4819__auto___20101]));

var G__20102 = (i__4819__auto___20101 + (1));
i__4819__auto___20101 = G__20102;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((3) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4825__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__20095){
var map__20096 = p__20095;
var map__20096__$1 = cljs.core.__destructure_map(map__20096);
var opts = map__20096__$1;
var statearr_20097_20103 = state;
(statearr_20097_20103[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_20098_20104 = state;
(statearr_20098_20104[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_20099_20105 = state;
(statearr_20099_20105[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq20091){
var G__20092 = cljs.core.first(seq20091);
var seq20091__$1 = cljs.core.next(seq20091);
var G__20093 = cljs.core.first(seq20091__$1);
var seq20091__$2 = cljs.core.next(seq20091__$1);
var G__20094 = cljs.core.first(seq20091__$2);
var seq20091__$3 = cljs.core.next(seq20091__$2);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__20092,G__20093,G__20094,seq20091__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20106 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20106 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta20107){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta20107 = meta20107;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20106.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20108,meta20107__$1){
var self__ = this;
var _20108__$1 = this;
return (new cljs.core.async.t_cljs$core$async20106(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta20107__$1));
}));

(cljs.core.async.t_cljs$core$async20106.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20108){
var self__ = this;
var _20108__$1 = this;
return self__.meta20107;
}));

(cljs.core.async.t_cljs$core$async20106.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20106.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async20106.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20106.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async20106.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async20106.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async20106.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async20106.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async20106.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta20107","meta20107",-1426575587,null)], null);
}));

(cljs.core.async.t_cljs$core$async20106.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20106.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20106");

(cljs.core.async.t_cljs$core$async20106.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async20106");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20106.
 */
cljs.core.async.__GT_t_cljs$core$async20106 = (function cljs$core$async$mix_$___GT_t_cljs$core$async20106(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20107){
return (new cljs.core.async.t_cljs$core$async20106(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20107));
});

}

return (new cljs.core.async.t_cljs$core$async20106(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17304__auto___20221 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_20176){
var state_val_20177 = (state_20176[(1)]);
if((state_val_20177 === (7))){
var inst_20136 = (state_20176[(2)]);
var state_20176__$1 = state_20176;
if(cljs.core.truth_(inst_20136)){
var statearr_20178_20222 = state_20176__$1;
(statearr_20178_20222[(1)] = (8));

} else {
var statearr_20179_20223 = state_20176__$1;
(statearr_20179_20223[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (20))){
var inst_20129 = (state_20176[(7)]);
var state_20176__$1 = state_20176;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20176__$1,(23),out,inst_20129);
} else {
if((state_val_20177 === (1))){
var inst_20112 = calc_state();
var inst_20113 = cljs.core.__destructure_map(inst_20112);
var inst_20114 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20113,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20115 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20113,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20116 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20113,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_20117 = inst_20112;
var state_20176__$1 = (function (){var statearr_20180 = state_20176;
(statearr_20180[(8)] = inst_20115);

(statearr_20180[(9)] = inst_20114);

(statearr_20180[(10)] = inst_20116);

(statearr_20180[(11)] = inst_20117);

return statearr_20180;
})();
var statearr_20181_20224 = state_20176__$1;
(statearr_20181_20224[(2)] = null);

(statearr_20181_20224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (24))){
var inst_20120 = (state_20176[(12)]);
var inst_20117 = inst_20120;
var state_20176__$1 = (function (){var statearr_20182 = state_20176;
(statearr_20182[(11)] = inst_20117);

return statearr_20182;
})();
var statearr_20183_20225 = state_20176__$1;
(statearr_20183_20225[(2)] = null);

(statearr_20183_20225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (4))){
var inst_20129 = (state_20176[(7)]);
var inst_20131 = (state_20176[(13)]);
var inst_20128 = (state_20176[(2)]);
var inst_20129__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20128,(0),null);
var inst_20130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20128,(1),null);
var inst_20131__$1 = (inst_20129__$1 == null);
var state_20176__$1 = (function (){var statearr_20184 = state_20176;
(statearr_20184[(7)] = inst_20129__$1);

(statearr_20184[(14)] = inst_20130);

(statearr_20184[(13)] = inst_20131__$1);

return statearr_20184;
})();
if(cljs.core.truth_(inst_20131__$1)){
var statearr_20185_20226 = state_20176__$1;
(statearr_20185_20226[(1)] = (5));

} else {
var statearr_20186_20227 = state_20176__$1;
(statearr_20186_20227[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (15))){
var inst_20121 = (state_20176[(15)]);
var inst_20150 = (state_20176[(16)]);
var inst_20150__$1 = cljs.core.empty_QMARK_(inst_20121);
var state_20176__$1 = (function (){var statearr_20187 = state_20176;
(statearr_20187[(16)] = inst_20150__$1);

return statearr_20187;
})();
if(inst_20150__$1){
var statearr_20188_20228 = state_20176__$1;
(statearr_20188_20228[(1)] = (17));

} else {
var statearr_20189_20229 = state_20176__$1;
(statearr_20189_20229[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (21))){
var inst_20120 = (state_20176[(12)]);
var inst_20117 = inst_20120;
var state_20176__$1 = (function (){var statearr_20190 = state_20176;
(statearr_20190[(11)] = inst_20117);

return statearr_20190;
})();
var statearr_20191_20230 = state_20176__$1;
(statearr_20191_20230[(2)] = null);

(statearr_20191_20230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (13))){
var inst_20143 = (state_20176[(2)]);
var inst_20144 = calc_state();
var inst_20117 = inst_20144;
var state_20176__$1 = (function (){var statearr_20192 = state_20176;
(statearr_20192[(17)] = inst_20143);

(statearr_20192[(11)] = inst_20117);

return statearr_20192;
})();
var statearr_20193_20231 = state_20176__$1;
(statearr_20193_20231[(2)] = null);

(statearr_20193_20231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (22))){
var inst_20170 = (state_20176[(2)]);
var state_20176__$1 = state_20176;
var statearr_20194_20232 = state_20176__$1;
(statearr_20194_20232[(2)] = inst_20170);

(statearr_20194_20232[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (6))){
var inst_20130 = (state_20176[(14)]);
var inst_20134 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20130,change);
var state_20176__$1 = state_20176;
var statearr_20195_20233 = state_20176__$1;
(statearr_20195_20233[(2)] = inst_20134);

(statearr_20195_20233[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (25))){
var state_20176__$1 = state_20176;
var statearr_20196_20234 = state_20176__$1;
(statearr_20196_20234[(2)] = null);

(statearr_20196_20234[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (17))){
var inst_20122 = (state_20176[(18)]);
var inst_20130 = (state_20176[(14)]);
var inst_20152 = (inst_20122.cljs$core$IFn$_invoke$arity$1 ? inst_20122.cljs$core$IFn$_invoke$arity$1(inst_20130) : inst_20122.call(null,inst_20130));
var inst_20153 = cljs.core.not(inst_20152);
var state_20176__$1 = state_20176;
var statearr_20197_20235 = state_20176__$1;
(statearr_20197_20235[(2)] = inst_20153);

(statearr_20197_20235[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (3))){
var inst_20174 = (state_20176[(2)]);
var state_20176__$1 = state_20176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20176__$1,inst_20174);
} else {
if((state_val_20177 === (12))){
var state_20176__$1 = state_20176;
var statearr_20198_20236 = state_20176__$1;
(statearr_20198_20236[(2)] = null);

(statearr_20198_20236[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (2))){
var inst_20120 = (state_20176[(12)]);
var inst_20117 = (state_20176[(11)]);
var inst_20120__$1 = cljs.core.__destructure_map(inst_20117);
var inst_20121 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20120__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20120__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20123 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20120__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_20176__$1 = (function (){var statearr_20199 = state_20176;
(statearr_20199[(18)] = inst_20122);

(statearr_20199[(15)] = inst_20121);

(statearr_20199[(12)] = inst_20120__$1);

return statearr_20199;
})();
return cljs.core.async.ioc_alts_BANG_(state_20176__$1,(4),inst_20123);
} else {
if((state_val_20177 === (23))){
var inst_20161 = (state_20176[(2)]);
var state_20176__$1 = state_20176;
if(cljs.core.truth_(inst_20161)){
var statearr_20200_20237 = state_20176__$1;
(statearr_20200_20237[(1)] = (24));

} else {
var statearr_20201_20238 = state_20176__$1;
(statearr_20201_20238[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (19))){
var inst_20156 = (state_20176[(2)]);
var state_20176__$1 = state_20176;
var statearr_20202_20239 = state_20176__$1;
(statearr_20202_20239[(2)] = inst_20156);

(statearr_20202_20239[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (11))){
var inst_20130 = (state_20176[(14)]);
var inst_20140 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_20130);
var state_20176__$1 = state_20176;
var statearr_20203_20240 = state_20176__$1;
(statearr_20203_20240[(2)] = inst_20140);

(statearr_20203_20240[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (9))){
var inst_20147 = (state_20176[(19)]);
var inst_20130 = (state_20176[(14)]);
var inst_20121 = (state_20176[(15)]);
var inst_20147__$1 = (inst_20121.cljs$core$IFn$_invoke$arity$1 ? inst_20121.cljs$core$IFn$_invoke$arity$1(inst_20130) : inst_20121.call(null,inst_20130));
var state_20176__$1 = (function (){var statearr_20204 = state_20176;
(statearr_20204[(19)] = inst_20147__$1);

return statearr_20204;
})();
if(cljs.core.truth_(inst_20147__$1)){
var statearr_20205_20241 = state_20176__$1;
(statearr_20205_20241[(1)] = (14));

} else {
var statearr_20206_20242 = state_20176__$1;
(statearr_20206_20242[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (5))){
var inst_20131 = (state_20176[(13)]);
var state_20176__$1 = state_20176;
var statearr_20207_20243 = state_20176__$1;
(statearr_20207_20243[(2)] = inst_20131);

(statearr_20207_20243[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (14))){
var inst_20147 = (state_20176[(19)]);
var state_20176__$1 = state_20176;
var statearr_20208_20244 = state_20176__$1;
(statearr_20208_20244[(2)] = inst_20147);

(statearr_20208_20244[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (26))){
var inst_20166 = (state_20176[(2)]);
var state_20176__$1 = state_20176;
var statearr_20209_20245 = state_20176__$1;
(statearr_20209_20245[(2)] = inst_20166);

(statearr_20209_20245[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (16))){
var inst_20158 = (state_20176[(2)]);
var state_20176__$1 = state_20176;
if(cljs.core.truth_(inst_20158)){
var statearr_20210_20246 = state_20176__$1;
(statearr_20210_20246[(1)] = (20));

} else {
var statearr_20211_20247 = state_20176__$1;
(statearr_20211_20247[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (10))){
var inst_20172 = (state_20176[(2)]);
var state_20176__$1 = state_20176;
var statearr_20212_20248 = state_20176__$1;
(statearr_20212_20248[(2)] = inst_20172);

(statearr_20212_20248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (18))){
var inst_20150 = (state_20176[(16)]);
var state_20176__$1 = state_20176;
var statearr_20213_20249 = state_20176__$1;
(statearr_20213_20249[(2)] = inst_20150);

(statearr_20213_20249[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20177 === (8))){
var inst_20129 = (state_20176[(7)]);
var inst_20138 = (inst_20129 == null);
var state_20176__$1 = state_20176;
if(cljs.core.truth_(inst_20138)){
var statearr_20214_20250 = state_20176__$1;
(statearr_20214_20250[(1)] = (11));

} else {
var statearr_20215_20251 = state_20176__$1;
(statearr_20215_20251[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__17178__auto__ = null;
var cljs$core$async$mix_$_state_machine__17178__auto____0 = (function (){
var statearr_20216 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20216[(0)] = cljs$core$async$mix_$_state_machine__17178__auto__);

(statearr_20216[(1)] = (1));

return statearr_20216;
});
var cljs$core$async$mix_$_state_machine__17178__auto____1 = (function (state_20176){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_20176);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e20217){var ex__17181__auto__ = e20217;
var statearr_20218_20252 = state_20176;
(statearr_20218_20252[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_20176[(4)]))){
var statearr_20219_20253 = state_20176;
(statearr_20219_20253[(1)] = cljs.core.first((state_20176[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20254 = state_20176;
state_20176 = G__20254;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__17178__auto__ = function(state_20176){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__17178__auto____1.call(this,state_20176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__17178__auto____0;
cljs$core$async$mix_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__17178__auto____1;
return cljs$core$async$mix_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_20220 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_20220[(6)] = c__17304__auto___20221);

return statearr_20220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_20257 = (function (p,v,ch,close_QMARK_){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4510__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4508__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_20257(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_20258 = (function (p,v,ch){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4510__auto__.call(null,p,v,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4508__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_20258(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_20259 = (function() {
var G__20260 = null;
var G__20260__1 = (function (p){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4510__auto__.call(null,p));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4508__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__20260__2 = (function (p,v){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4510__auto__.call(null,p,v));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4508__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__20260 = function(p,v){
switch(arguments.length){
case 1:
return G__20260__1.call(this,p);
case 2:
return G__20260__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20260.cljs$core$IFn$_invoke$arity$1 = G__20260__1;
G__20260.cljs$core$IFn$_invoke$arity$2 = G__20260__2;
return G__20260;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__20256 = arguments.length;
switch (G__20256) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_20259.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_20259.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__20264 = arguments.length;
switch (G__20264) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__20262_SHARP_){
if(cljs.core.truth_((p1__20262_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__20262_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__20262_SHARP_.call(null,topic)))){
return p1__20262_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__20262_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20265 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20265 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20266){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20266 = meta20266;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20265.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20267,meta20266__$1){
var self__ = this;
var _20267__$1 = this;
return (new cljs.core.async.t_cljs$core$async20265(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20266__$1));
}));

(cljs.core.async.t_cljs$core$async20265.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20267){
var self__ = this;
var _20267__$1 = this;
return self__.meta20266;
}));

(cljs.core.async.t_cljs$core$async20265.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20265.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async20265.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20265.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async20265.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async20265.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async20265.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async20265.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20266","meta20266",-575936791,null)], null);
}));

(cljs.core.async.t_cljs$core$async20265.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20265.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20265");

(cljs.core.async.t_cljs$core$async20265.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async20265");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20265.
 */
cljs.core.async.__GT_t_cljs$core$async20265 = (function cljs$core$async$__GT_t_cljs$core$async20265(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20266){
return (new cljs.core.async.t_cljs$core$async20265(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20266));
});

}

return (new cljs.core.async.t_cljs$core$async20265(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17304__auto___20386 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_20339){
var state_val_20340 = (state_20339[(1)]);
if((state_val_20340 === (7))){
var inst_20335 = (state_20339[(2)]);
var state_20339__$1 = state_20339;
var statearr_20341_20387 = state_20339__$1;
(statearr_20341_20387[(2)] = inst_20335);

(statearr_20341_20387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (20))){
var state_20339__$1 = state_20339;
var statearr_20342_20388 = state_20339__$1;
(statearr_20342_20388[(2)] = null);

(statearr_20342_20388[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (1))){
var state_20339__$1 = state_20339;
var statearr_20343_20389 = state_20339__$1;
(statearr_20343_20389[(2)] = null);

(statearr_20343_20389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (24))){
var inst_20318 = (state_20339[(7)]);
var inst_20327 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_20318);
var state_20339__$1 = state_20339;
var statearr_20344_20390 = state_20339__$1;
(statearr_20344_20390[(2)] = inst_20327);

(statearr_20344_20390[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (4))){
var inst_20270 = (state_20339[(8)]);
var inst_20270__$1 = (state_20339[(2)]);
var inst_20271 = (inst_20270__$1 == null);
var state_20339__$1 = (function (){var statearr_20345 = state_20339;
(statearr_20345[(8)] = inst_20270__$1);

return statearr_20345;
})();
if(cljs.core.truth_(inst_20271)){
var statearr_20346_20391 = state_20339__$1;
(statearr_20346_20391[(1)] = (5));

} else {
var statearr_20347_20392 = state_20339__$1;
(statearr_20347_20392[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (15))){
var inst_20312 = (state_20339[(2)]);
var state_20339__$1 = state_20339;
var statearr_20348_20393 = state_20339__$1;
(statearr_20348_20393[(2)] = inst_20312);

(statearr_20348_20393[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (21))){
var inst_20332 = (state_20339[(2)]);
var state_20339__$1 = (function (){var statearr_20349 = state_20339;
(statearr_20349[(9)] = inst_20332);

return statearr_20349;
})();
var statearr_20350_20394 = state_20339__$1;
(statearr_20350_20394[(2)] = null);

(statearr_20350_20394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (13))){
var inst_20294 = (state_20339[(10)]);
var inst_20296 = cljs.core.chunked_seq_QMARK_(inst_20294);
var state_20339__$1 = state_20339;
if(inst_20296){
var statearr_20351_20395 = state_20339__$1;
(statearr_20351_20395[(1)] = (16));

} else {
var statearr_20352_20396 = state_20339__$1;
(statearr_20352_20396[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (22))){
var inst_20324 = (state_20339[(2)]);
var state_20339__$1 = state_20339;
if(cljs.core.truth_(inst_20324)){
var statearr_20353_20397 = state_20339__$1;
(statearr_20353_20397[(1)] = (23));

} else {
var statearr_20354_20398 = state_20339__$1;
(statearr_20354_20398[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (6))){
var inst_20318 = (state_20339[(7)]);
var inst_20320 = (state_20339[(11)]);
var inst_20270 = (state_20339[(8)]);
var inst_20318__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_20270) : topic_fn.call(null,inst_20270));
var inst_20319 = cljs.core.deref(mults);
var inst_20320__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20319,inst_20318__$1);
var state_20339__$1 = (function (){var statearr_20355 = state_20339;
(statearr_20355[(7)] = inst_20318__$1);

(statearr_20355[(11)] = inst_20320__$1);

return statearr_20355;
})();
if(cljs.core.truth_(inst_20320__$1)){
var statearr_20356_20399 = state_20339__$1;
(statearr_20356_20399[(1)] = (19));

} else {
var statearr_20357_20400 = state_20339__$1;
(statearr_20357_20400[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (25))){
var inst_20329 = (state_20339[(2)]);
var state_20339__$1 = state_20339;
var statearr_20358_20401 = state_20339__$1;
(statearr_20358_20401[(2)] = inst_20329);

(statearr_20358_20401[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (17))){
var inst_20294 = (state_20339[(10)]);
var inst_20303 = cljs.core.first(inst_20294);
var inst_20304 = cljs.core.async.muxch_STAR_(inst_20303);
var inst_20305 = cljs.core.async.close_BANG_(inst_20304);
var inst_20306 = cljs.core.next(inst_20294);
var inst_20280 = inst_20306;
var inst_20281 = null;
var inst_20282 = (0);
var inst_20283 = (0);
var state_20339__$1 = (function (){var statearr_20359 = state_20339;
(statearr_20359[(12)] = inst_20305);

(statearr_20359[(13)] = inst_20283);

(statearr_20359[(14)] = inst_20282);

(statearr_20359[(15)] = inst_20280);

(statearr_20359[(16)] = inst_20281);

return statearr_20359;
})();
var statearr_20360_20402 = state_20339__$1;
(statearr_20360_20402[(2)] = null);

(statearr_20360_20402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (3))){
var inst_20337 = (state_20339[(2)]);
var state_20339__$1 = state_20339;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20339__$1,inst_20337);
} else {
if((state_val_20340 === (12))){
var inst_20314 = (state_20339[(2)]);
var state_20339__$1 = state_20339;
var statearr_20361_20403 = state_20339__$1;
(statearr_20361_20403[(2)] = inst_20314);

(statearr_20361_20403[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (2))){
var state_20339__$1 = state_20339;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20339__$1,(4),ch);
} else {
if((state_val_20340 === (23))){
var state_20339__$1 = state_20339;
var statearr_20362_20404 = state_20339__$1;
(statearr_20362_20404[(2)] = null);

(statearr_20362_20404[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (19))){
var inst_20320 = (state_20339[(11)]);
var inst_20270 = (state_20339[(8)]);
var inst_20322 = cljs.core.async.muxch_STAR_(inst_20320);
var state_20339__$1 = state_20339;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20339__$1,(22),inst_20322,inst_20270);
} else {
if((state_val_20340 === (11))){
var inst_20280 = (state_20339[(15)]);
var inst_20294 = (state_20339[(10)]);
var inst_20294__$1 = cljs.core.seq(inst_20280);
var state_20339__$1 = (function (){var statearr_20363 = state_20339;
(statearr_20363[(10)] = inst_20294__$1);

return statearr_20363;
})();
if(inst_20294__$1){
var statearr_20364_20405 = state_20339__$1;
(statearr_20364_20405[(1)] = (13));

} else {
var statearr_20365_20406 = state_20339__$1;
(statearr_20365_20406[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (9))){
var inst_20316 = (state_20339[(2)]);
var state_20339__$1 = state_20339;
var statearr_20366_20407 = state_20339__$1;
(statearr_20366_20407[(2)] = inst_20316);

(statearr_20366_20407[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (5))){
var inst_20277 = cljs.core.deref(mults);
var inst_20278 = cljs.core.vals(inst_20277);
var inst_20279 = cljs.core.seq(inst_20278);
var inst_20280 = inst_20279;
var inst_20281 = null;
var inst_20282 = (0);
var inst_20283 = (0);
var state_20339__$1 = (function (){var statearr_20367 = state_20339;
(statearr_20367[(13)] = inst_20283);

(statearr_20367[(14)] = inst_20282);

(statearr_20367[(15)] = inst_20280);

(statearr_20367[(16)] = inst_20281);

return statearr_20367;
})();
var statearr_20368_20408 = state_20339__$1;
(statearr_20368_20408[(2)] = null);

(statearr_20368_20408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (14))){
var state_20339__$1 = state_20339;
var statearr_20372_20409 = state_20339__$1;
(statearr_20372_20409[(2)] = null);

(statearr_20372_20409[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (16))){
var inst_20294 = (state_20339[(10)]);
var inst_20298 = cljs.core.chunk_first(inst_20294);
var inst_20299 = cljs.core.chunk_rest(inst_20294);
var inst_20300 = cljs.core.count(inst_20298);
var inst_20280 = inst_20299;
var inst_20281 = inst_20298;
var inst_20282 = inst_20300;
var inst_20283 = (0);
var state_20339__$1 = (function (){var statearr_20373 = state_20339;
(statearr_20373[(13)] = inst_20283);

(statearr_20373[(14)] = inst_20282);

(statearr_20373[(15)] = inst_20280);

(statearr_20373[(16)] = inst_20281);

return statearr_20373;
})();
var statearr_20374_20410 = state_20339__$1;
(statearr_20374_20410[(2)] = null);

(statearr_20374_20410[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (10))){
var inst_20283 = (state_20339[(13)]);
var inst_20282 = (state_20339[(14)]);
var inst_20280 = (state_20339[(15)]);
var inst_20281 = (state_20339[(16)]);
var inst_20288 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_20281,inst_20283);
var inst_20289 = cljs.core.async.muxch_STAR_(inst_20288);
var inst_20290 = cljs.core.async.close_BANG_(inst_20289);
var inst_20291 = (inst_20283 + (1));
var tmp20369 = inst_20282;
var tmp20370 = inst_20280;
var tmp20371 = inst_20281;
var inst_20280__$1 = tmp20370;
var inst_20281__$1 = tmp20371;
var inst_20282__$1 = tmp20369;
var inst_20283__$1 = inst_20291;
var state_20339__$1 = (function (){var statearr_20375 = state_20339;
(statearr_20375[(13)] = inst_20283__$1);

(statearr_20375[(14)] = inst_20282__$1);

(statearr_20375[(17)] = inst_20290);

(statearr_20375[(15)] = inst_20280__$1);

(statearr_20375[(16)] = inst_20281__$1);

return statearr_20375;
})();
var statearr_20376_20411 = state_20339__$1;
(statearr_20376_20411[(2)] = null);

(statearr_20376_20411[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (18))){
var inst_20309 = (state_20339[(2)]);
var state_20339__$1 = state_20339;
var statearr_20377_20412 = state_20339__$1;
(statearr_20377_20412[(2)] = inst_20309);

(statearr_20377_20412[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20340 === (8))){
var inst_20283 = (state_20339[(13)]);
var inst_20282 = (state_20339[(14)]);
var inst_20285 = (inst_20283 < inst_20282);
var inst_20286 = inst_20285;
var state_20339__$1 = state_20339;
if(cljs.core.truth_(inst_20286)){
var statearr_20378_20413 = state_20339__$1;
(statearr_20378_20413[(1)] = (10));

} else {
var statearr_20379_20414 = state_20339__$1;
(statearr_20379_20414[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_20380 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20380[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_20380[(1)] = (1));

return statearr_20380;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_20339){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_20339);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e20381){var ex__17181__auto__ = e20381;
var statearr_20382_20415 = state_20339;
(statearr_20382_20415[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_20339[(4)]))){
var statearr_20383_20416 = state_20339;
(statearr_20383_20416[(1)] = cljs.core.first((state_20339[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20417 = state_20339;
state_20339 = G__20417;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_20339){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_20339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_20384 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_20384[(6)] = c__17304__auto___20386);

return statearr_20384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__20419 = arguments.length;
switch (G__20419) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__20422 = arguments.length;
switch (G__20422) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__20425 = arguments.length;
switch (G__20425) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__17304__auto___20503 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_20468){
var state_val_20469 = (state_20468[(1)]);
if((state_val_20469 === (7))){
var state_20468__$1 = state_20468;
var statearr_20470_20504 = state_20468__$1;
(statearr_20470_20504[(2)] = null);

(statearr_20470_20504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (1))){
var state_20468__$1 = state_20468;
var statearr_20471_20505 = state_20468__$1;
(statearr_20471_20505[(2)] = null);

(statearr_20471_20505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (4))){
var inst_20429 = (state_20468[(7)]);
var inst_20428 = (state_20468[(8)]);
var inst_20431 = (inst_20429 < inst_20428);
var state_20468__$1 = state_20468;
if(cljs.core.truth_(inst_20431)){
var statearr_20472_20506 = state_20468__$1;
(statearr_20472_20506[(1)] = (6));

} else {
var statearr_20473_20507 = state_20468__$1;
(statearr_20473_20507[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (15))){
var inst_20454 = (state_20468[(9)]);
var inst_20459 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_20454);
var state_20468__$1 = state_20468;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20468__$1,(17),out,inst_20459);
} else {
if((state_val_20469 === (13))){
var inst_20454 = (state_20468[(9)]);
var inst_20454__$1 = (state_20468[(2)]);
var inst_20455 = cljs.core.some(cljs.core.nil_QMARK_,inst_20454__$1);
var state_20468__$1 = (function (){var statearr_20474 = state_20468;
(statearr_20474[(9)] = inst_20454__$1);

return statearr_20474;
})();
if(cljs.core.truth_(inst_20455)){
var statearr_20475_20508 = state_20468__$1;
(statearr_20475_20508[(1)] = (14));

} else {
var statearr_20476_20509 = state_20468__$1;
(statearr_20476_20509[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (6))){
var state_20468__$1 = state_20468;
var statearr_20477_20510 = state_20468__$1;
(statearr_20477_20510[(2)] = null);

(statearr_20477_20510[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (17))){
var inst_20461 = (state_20468[(2)]);
var state_20468__$1 = (function (){var statearr_20479 = state_20468;
(statearr_20479[(10)] = inst_20461);

return statearr_20479;
})();
var statearr_20480_20511 = state_20468__$1;
(statearr_20480_20511[(2)] = null);

(statearr_20480_20511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (3))){
var inst_20466 = (state_20468[(2)]);
var state_20468__$1 = state_20468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20468__$1,inst_20466);
} else {
if((state_val_20469 === (12))){
var _ = (function (){var statearr_20481 = state_20468;
(statearr_20481[(4)] = cljs.core.rest((state_20468[(4)])));

return statearr_20481;
})();
var state_20468__$1 = state_20468;
var ex20478 = (state_20468__$1[(2)]);
var statearr_20482_20512 = state_20468__$1;
(statearr_20482_20512[(5)] = ex20478);


if((ex20478 instanceof Object)){
var statearr_20483_20513 = state_20468__$1;
(statearr_20483_20513[(1)] = (11));

(statearr_20483_20513[(5)] = null);

} else {
throw ex20478;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (2))){
var inst_20427 = cljs.core.reset_BANG_(dctr,cnt);
var inst_20428 = cnt;
var inst_20429 = (0);
var state_20468__$1 = (function (){var statearr_20484 = state_20468;
(statearr_20484[(7)] = inst_20429);

(statearr_20484[(11)] = inst_20427);

(statearr_20484[(8)] = inst_20428);

return statearr_20484;
})();
var statearr_20485_20514 = state_20468__$1;
(statearr_20485_20514[(2)] = null);

(statearr_20485_20514[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (11))){
var inst_20433 = (state_20468[(2)]);
var inst_20434 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_20468__$1 = (function (){var statearr_20486 = state_20468;
(statearr_20486[(12)] = inst_20433);

return statearr_20486;
})();
var statearr_20487_20515 = state_20468__$1;
(statearr_20487_20515[(2)] = inst_20434);

(statearr_20487_20515[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (9))){
var inst_20429 = (state_20468[(7)]);
var _ = (function (){var statearr_20488 = state_20468;
(statearr_20488[(4)] = cljs.core.cons((12),(state_20468[(4)])));

return statearr_20488;
})();
var inst_20440 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_20429) : chs__$1.call(null,inst_20429));
var inst_20441 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_20429) : done.call(null,inst_20429));
var inst_20442 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_20440,inst_20441);
var ___$1 = (function (){var statearr_20489 = state_20468;
(statearr_20489[(4)] = cljs.core.rest((state_20468[(4)])));

return statearr_20489;
})();
var state_20468__$1 = state_20468;
var statearr_20490_20516 = state_20468__$1;
(statearr_20490_20516[(2)] = inst_20442);

(statearr_20490_20516[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (5))){
var inst_20452 = (state_20468[(2)]);
var state_20468__$1 = (function (){var statearr_20491 = state_20468;
(statearr_20491[(13)] = inst_20452);

return statearr_20491;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20468__$1,(13),dchan);
} else {
if((state_val_20469 === (14))){
var inst_20457 = cljs.core.async.close_BANG_(out);
var state_20468__$1 = state_20468;
var statearr_20492_20517 = state_20468__$1;
(statearr_20492_20517[(2)] = inst_20457);

(statearr_20492_20517[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (16))){
var inst_20464 = (state_20468[(2)]);
var state_20468__$1 = state_20468;
var statearr_20493_20518 = state_20468__$1;
(statearr_20493_20518[(2)] = inst_20464);

(statearr_20493_20518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (10))){
var inst_20429 = (state_20468[(7)]);
var inst_20445 = (state_20468[(2)]);
var inst_20446 = (inst_20429 + (1));
var inst_20429__$1 = inst_20446;
var state_20468__$1 = (function (){var statearr_20494 = state_20468;
(statearr_20494[(7)] = inst_20429__$1);

(statearr_20494[(14)] = inst_20445);

return statearr_20494;
})();
var statearr_20495_20519 = state_20468__$1;
(statearr_20495_20519[(2)] = null);

(statearr_20495_20519[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20469 === (8))){
var inst_20450 = (state_20468[(2)]);
var state_20468__$1 = state_20468;
var statearr_20496_20520 = state_20468__$1;
(statearr_20496_20520[(2)] = inst_20450);

(statearr_20496_20520[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_20497 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20497[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_20497[(1)] = (1));

return statearr_20497;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_20468){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_20468);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e20498){var ex__17181__auto__ = e20498;
var statearr_20499_20521 = state_20468;
(statearr_20499_20521[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_20468[(4)]))){
var statearr_20500_20522 = state_20468;
(statearr_20500_20522[(1)] = cljs.core.first((state_20468[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20523 = state_20468;
state_20468 = G__20523;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_20468){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_20468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_20501 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_20501[(6)] = c__17304__auto___20503);

return statearr_20501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__20526 = arguments.length;
switch (G__20526) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17304__auto___20581 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_20558){
var state_val_20559 = (state_20558[(1)]);
if((state_val_20559 === (7))){
var inst_20537 = (state_20558[(7)]);
var inst_20538 = (state_20558[(8)]);
var inst_20537__$1 = (state_20558[(2)]);
var inst_20538__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20537__$1,(0),null);
var inst_20539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20537__$1,(1),null);
var inst_20540 = (inst_20538__$1 == null);
var state_20558__$1 = (function (){var statearr_20560 = state_20558;
(statearr_20560[(7)] = inst_20537__$1);

(statearr_20560[(8)] = inst_20538__$1);

(statearr_20560[(9)] = inst_20539);

return statearr_20560;
})();
if(cljs.core.truth_(inst_20540)){
var statearr_20561_20582 = state_20558__$1;
(statearr_20561_20582[(1)] = (8));

} else {
var statearr_20562_20583 = state_20558__$1;
(statearr_20562_20583[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20559 === (1))){
var inst_20527 = cljs.core.vec(chs);
var inst_20528 = inst_20527;
var state_20558__$1 = (function (){var statearr_20563 = state_20558;
(statearr_20563[(10)] = inst_20528);

return statearr_20563;
})();
var statearr_20564_20584 = state_20558__$1;
(statearr_20564_20584[(2)] = null);

(statearr_20564_20584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20559 === (4))){
var inst_20528 = (state_20558[(10)]);
var state_20558__$1 = state_20558;
return cljs.core.async.ioc_alts_BANG_(state_20558__$1,(7),inst_20528);
} else {
if((state_val_20559 === (6))){
var inst_20554 = (state_20558[(2)]);
var state_20558__$1 = state_20558;
var statearr_20565_20585 = state_20558__$1;
(statearr_20565_20585[(2)] = inst_20554);

(statearr_20565_20585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20559 === (3))){
var inst_20556 = (state_20558[(2)]);
var state_20558__$1 = state_20558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20558__$1,inst_20556);
} else {
if((state_val_20559 === (2))){
var inst_20528 = (state_20558[(10)]);
var inst_20530 = cljs.core.count(inst_20528);
var inst_20531 = (inst_20530 > (0));
var state_20558__$1 = state_20558;
if(cljs.core.truth_(inst_20531)){
var statearr_20567_20586 = state_20558__$1;
(statearr_20567_20586[(1)] = (4));

} else {
var statearr_20568_20587 = state_20558__$1;
(statearr_20568_20587[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20559 === (11))){
var inst_20528 = (state_20558[(10)]);
var inst_20547 = (state_20558[(2)]);
var tmp20566 = inst_20528;
var inst_20528__$1 = tmp20566;
var state_20558__$1 = (function (){var statearr_20569 = state_20558;
(statearr_20569[(10)] = inst_20528__$1);

(statearr_20569[(11)] = inst_20547);

return statearr_20569;
})();
var statearr_20570_20588 = state_20558__$1;
(statearr_20570_20588[(2)] = null);

(statearr_20570_20588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20559 === (9))){
var inst_20538 = (state_20558[(8)]);
var state_20558__$1 = state_20558;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20558__$1,(11),out,inst_20538);
} else {
if((state_val_20559 === (5))){
var inst_20552 = cljs.core.async.close_BANG_(out);
var state_20558__$1 = state_20558;
var statearr_20571_20589 = state_20558__$1;
(statearr_20571_20589[(2)] = inst_20552);

(statearr_20571_20589[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20559 === (10))){
var inst_20550 = (state_20558[(2)]);
var state_20558__$1 = state_20558;
var statearr_20572_20590 = state_20558__$1;
(statearr_20572_20590[(2)] = inst_20550);

(statearr_20572_20590[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20559 === (8))){
var inst_20528 = (state_20558[(10)]);
var inst_20537 = (state_20558[(7)]);
var inst_20538 = (state_20558[(8)]);
var inst_20539 = (state_20558[(9)]);
var inst_20542 = (function (){var cs = inst_20528;
var vec__20533 = inst_20537;
var v = inst_20538;
var c = inst_20539;
return (function (p1__20524_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__20524_SHARP_);
});
})();
var inst_20543 = cljs.core.filterv(inst_20542,inst_20528);
var inst_20528__$1 = inst_20543;
var state_20558__$1 = (function (){var statearr_20573 = state_20558;
(statearr_20573[(10)] = inst_20528__$1);

return statearr_20573;
})();
var statearr_20574_20591 = state_20558__$1;
(statearr_20574_20591[(2)] = null);

(statearr_20574_20591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_20575 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20575[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_20575[(1)] = (1));

return statearr_20575;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_20558){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_20558);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e20576){var ex__17181__auto__ = e20576;
var statearr_20577_20592 = state_20558;
(statearr_20577_20592[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_20558[(4)]))){
var statearr_20578_20593 = state_20558;
(statearr_20578_20593[(1)] = cljs.core.first((state_20558[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20594 = state_20558;
state_20558 = G__20594;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_20558){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_20558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_20579 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_20579[(6)] = c__17304__auto___20581);

return statearr_20579;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__20596 = arguments.length;
switch (G__20596) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17304__auto___20642 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_20620){
var state_val_20621 = (state_20620[(1)]);
if((state_val_20621 === (7))){
var inst_20602 = (state_20620[(7)]);
var inst_20602__$1 = (state_20620[(2)]);
var inst_20603 = (inst_20602__$1 == null);
var inst_20604 = cljs.core.not(inst_20603);
var state_20620__$1 = (function (){var statearr_20622 = state_20620;
(statearr_20622[(7)] = inst_20602__$1);

return statearr_20622;
})();
if(inst_20604){
var statearr_20623_20643 = state_20620__$1;
(statearr_20623_20643[(1)] = (8));

} else {
var statearr_20624_20644 = state_20620__$1;
(statearr_20624_20644[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20621 === (1))){
var inst_20597 = (0);
var state_20620__$1 = (function (){var statearr_20625 = state_20620;
(statearr_20625[(8)] = inst_20597);

return statearr_20625;
})();
var statearr_20626_20645 = state_20620__$1;
(statearr_20626_20645[(2)] = null);

(statearr_20626_20645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20621 === (4))){
var state_20620__$1 = state_20620;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20620__$1,(7),ch);
} else {
if((state_val_20621 === (6))){
var inst_20615 = (state_20620[(2)]);
var state_20620__$1 = state_20620;
var statearr_20627_20646 = state_20620__$1;
(statearr_20627_20646[(2)] = inst_20615);

(statearr_20627_20646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20621 === (3))){
var inst_20617 = (state_20620[(2)]);
var inst_20618 = cljs.core.async.close_BANG_(out);
var state_20620__$1 = (function (){var statearr_20628 = state_20620;
(statearr_20628[(9)] = inst_20617);

return statearr_20628;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_20620__$1,inst_20618);
} else {
if((state_val_20621 === (2))){
var inst_20597 = (state_20620[(8)]);
var inst_20599 = (inst_20597 < n);
var state_20620__$1 = state_20620;
if(cljs.core.truth_(inst_20599)){
var statearr_20629_20647 = state_20620__$1;
(statearr_20629_20647[(1)] = (4));

} else {
var statearr_20630_20648 = state_20620__$1;
(statearr_20630_20648[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20621 === (11))){
var inst_20597 = (state_20620[(8)]);
var inst_20607 = (state_20620[(2)]);
var inst_20608 = (inst_20597 + (1));
var inst_20597__$1 = inst_20608;
var state_20620__$1 = (function (){var statearr_20631 = state_20620;
(statearr_20631[(10)] = inst_20607);

(statearr_20631[(8)] = inst_20597__$1);

return statearr_20631;
})();
var statearr_20632_20649 = state_20620__$1;
(statearr_20632_20649[(2)] = null);

(statearr_20632_20649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20621 === (9))){
var state_20620__$1 = state_20620;
var statearr_20633_20650 = state_20620__$1;
(statearr_20633_20650[(2)] = null);

(statearr_20633_20650[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20621 === (5))){
var state_20620__$1 = state_20620;
var statearr_20634_20651 = state_20620__$1;
(statearr_20634_20651[(2)] = null);

(statearr_20634_20651[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20621 === (10))){
var inst_20612 = (state_20620[(2)]);
var state_20620__$1 = state_20620;
var statearr_20635_20652 = state_20620__$1;
(statearr_20635_20652[(2)] = inst_20612);

(statearr_20635_20652[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20621 === (8))){
var inst_20602 = (state_20620[(7)]);
var state_20620__$1 = state_20620;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20620__$1,(11),out,inst_20602);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_20636 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20636[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_20636[(1)] = (1));

return statearr_20636;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_20620){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_20620);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e20637){var ex__17181__auto__ = e20637;
var statearr_20638_20653 = state_20620;
(statearr_20638_20653[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_20620[(4)]))){
var statearr_20639_20654 = state_20620;
(statearr_20639_20654[(1)] = cljs.core.first((state_20620[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20655 = state_20620;
state_20620 = G__20655;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_20620){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_20620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_20640 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_20640[(6)] = c__17304__auto___20642);

return statearr_20640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20657 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20657 = (function (f,ch,meta20658){
this.f = f;
this.ch = ch;
this.meta20658 = meta20658;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20659,meta20658__$1){
var self__ = this;
var _20659__$1 = this;
return (new cljs.core.async.t_cljs$core$async20657(self__.f,self__.ch,meta20658__$1));
}));

(cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20659){
var self__ = this;
var _20659__$1 = this;
return self__.meta20658;
}));

(cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20660 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20660 = (function (f,ch,meta20658,_,fn1,meta20661){
this.f = f;
this.ch = ch;
this.meta20658 = meta20658;
this._ = _;
this.fn1 = fn1;
this.meta20661 = meta20661;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20660.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20662,meta20661__$1){
var self__ = this;
var _20662__$1 = this;
return (new cljs.core.async.t_cljs$core$async20660(self__.f,self__.ch,self__.meta20658,self__._,self__.fn1,meta20661__$1));
}));

(cljs.core.async.t_cljs$core$async20660.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20662){
var self__ = this;
var _20662__$1 = this;
return self__.meta20661;
}));

(cljs.core.async.t_cljs$core$async20660.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20660.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async20660.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async20660.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__20656_SHARP_){
var G__20663 = (((p1__20656_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__20656_SHARP_) : self__.f.call(null,p1__20656_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__20663) : f1.call(null,G__20663));
});
}));

(cljs.core.async.t_cljs$core$async20660.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20658","meta20658",-1864962380,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async20657","cljs.core.async/t_cljs$core$async20657",-154492623,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta20661","meta20661",-216609031,null)], null);
}));

(cljs.core.async.t_cljs$core$async20660.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20660.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20660");

(cljs.core.async.t_cljs$core$async20660.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async20660");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20660.
 */
cljs.core.async.__GT_t_cljs$core$async20660 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async20660(f__$1,ch__$1,meta20658__$1,___$2,fn1__$1,meta20661){
return (new cljs.core.async.t_cljs$core$async20660(f__$1,ch__$1,meta20658__$1,___$2,fn1__$1,meta20661));
});

}

return (new cljs.core.async.t_cljs$core$async20660(self__.f,self__.ch,self__.meta20658,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4210__auto__ = ret;
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4210__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__20664 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__20664) : self__.f.call(null,G__20664));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20657.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async20657.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20658","meta20658",-1864962380,null)], null);
}));

(cljs.core.async.t_cljs$core$async20657.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20657.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20657");

(cljs.core.async.t_cljs$core$async20657.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async20657");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20657.
 */
cljs.core.async.__GT_t_cljs$core$async20657 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async20657(f__$1,ch__$1,meta20658){
return (new cljs.core.async.t_cljs$core$async20657(f__$1,ch__$1,meta20658));
});

}

return (new cljs.core.async.t_cljs$core$async20657(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20665 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20665 = (function (f,ch,meta20666){
this.f = f;
this.ch = ch;
this.meta20666 = meta20666;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20667,meta20666__$1){
var self__ = this;
var _20667__$1 = this;
return (new cljs.core.async.t_cljs$core$async20665(self__.f,self__.ch,meta20666__$1));
}));

(cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20667){
var self__ = this;
var _20667__$1 = this;
return self__.meta20666;
}));

(cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async20665.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20666","meta20666",-435294268,null)], null);
}));

(cljs.core.async.t_cljs$core$async20665.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20665.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20665");

(cljs.core.async.t_cljs$core$async20665.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async20665");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20665.
 */
cljs.core.async.__GT_t_cljs$core$async20665 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async20665(f__$1,ch__$1,meta20666){
return (new cljs.core.async.t_cljs$core$async20665(f__$1,ch__$1,meta20666));
});

}

return (new cljs.core.async.t_cljs$core$async20665(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20668 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20668 = (function (p,ch,meta20669){
this.p = p;
this.ch = ch;
this.meta20669 = meta20669;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20668.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20670,meta20669__$1){
var self__ = this;
var _20670__$1 = this;
return (new cljs.core.async.t_cljs$core$async20668(self__.p,self__.ch,meta20669__$1));
}));

(cljs.core.async.t_cljs$core$async20668.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20670){
var self__ = this;
var _20670__$1 = this;
return self__.meta20669;
}));

(cljs.core.async.t_cljs$core$async20668.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20668.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async20668.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async20668.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20668.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async20668.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20668.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async20668.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20669","meta20669",-384570899,null)], null);
}));

(cljs.core.async.t_cljs$core$async20668.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20668.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20668");

(cljs.core.async.t_cljs$core$async20668.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async20668");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20668.
 */
cljs.core.async.__GT_t_cljs$core$async20668 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async20668(p__$1,ch__$1,meta20669){
return (new cljs.core.async.t_cljs$core$async20668(p__$1,ch__$1,meta20669));
});

}

return (new cljs.core.async.t_cljs$core$async20668(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__20672 = arguments.length;
switch (G__20672) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17304__auto___20713 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_20693){
var state_val_20694 = (state_20693[(1)]);
if((state_val_20694 === (7))){
var inst_20689 = (state_20693[(2)]);
var state_20693__$1 = state_20693;
var statearr_20695_20714 = state_20693__$1;
(statearr_20695_20714[(2)] = inst_20689);

(statearr_20695_20714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (1))){
var state_20693__$1 = state_20693;
var statearr_20696_20715 = state_20693__$1;
(statearr_20696_20715[(2)] = null);

(statearr_20696_20715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (4))){
var inst_20675 = (state_20693[(7)]);
var inst_20675__$1 = (state_20693[(2)]);
var inst_20676 = (inst_20675__$1 == null);
var state_20693__$1 = (function (){var statearr_20697 = state_20693;
(statearr_20697[(7)] = inst_20675__$1);

return statearr_20697;
})();
if(cljs.core.truth_(inst_20676)){
var statearr_20698_20716 = state_20693__$1;
(statearr_20698_20716[(1)] = (5));

} else {
var statearr_20699_20717 = state_20693__$1;
(statearr_20699_20717[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (6))){
var inst_20675 = (state_20693[(7)]);
var inst_20680 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_20675) : p.call(null,inst_20675));
var state_20693__$1 = state_20693;
if(cljs.core.truth_(inst_20680)){
var statearr_20700_20718 = state_20693__$1;
(statearr_20700_20718[(1)] = (8));

} else {
var statearr_20701_20719 = state_20693__$1;
(statearr_20701_20719[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (3))){
var inst_20691 = (state_20693[(2)]);
var state_20693__$1 = state_20693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20693__$1,inst_20691);
} else {
if((state_val_20694 === (2))){
var state_20693__$1 = state_20693;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20693__$1,(4),ch);
} else {
if((state_val_20694 === (11))){
var inst_20683 = (state_20693[(2)]);
var state_20693__$1 = state_20693;
var statearr_20702_20720 = state_20693__$1;
(statearr_20702_20720[(2)] = inst_20683);

(statearr_20702_20720[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (9))){
var state_20693__$1 = state_20693;
var statearr_20703_20721 = state_20693__$1;
(statearr_20703_20721[(2)] = null);

(statearr_20703_20721[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (5))){
var inst_20678 = cljs.core.async.close_BANG_(out);
var state_20693__$1 = state_20693;
var statearr_20704_20722 = state_20693__$1;
(statearr_20704_20722[(2)] = inst_20678);

(statearr_20704_20722[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (10))){
var inst_20686 = (state_20693[(2)]);
var state_20693__$1 = (function (){var statearr_20705 = state_20693;
(statearr_20705[(8)] = inst_20686);

return statearr_20705;
})();
var statearr_20706_20723 = state_20693__$1;
(statearr_20706_20723[(2)] = null);

(statearr_20706_20723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20694 === (8))){
var inst_20675 = (state_20693[(7)]);
var state_20693__$1 = state_20693;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20693__$1,(11),out,inst_20675);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_20707 = [null,null,null,null,null,null,null,null,null];
(statearr_20707[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_20707[(1)] = (1));

return statearr_20707;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_20693){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_20693);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e20708){var ex__17181__auto__ = e20708;
var statearr_20709_20724 = state_20693;
(statearr_20709_20724[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_20693[(4)]))){
var statearr_20710_20725 = state_20693;
(statearr_20710_20725[(1)] = cljs.core.first((state_20693[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20726 = state_20693;
state_20693 = G__20726;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_20693){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_20693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_20711 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_20711[(6)] = c__17304__auto___20713);

return statearr_20711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__20728 = arguments.length;
switch (G__20728) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_20791){
var state_val_20792 = (state_20791[(1)]);
if((state_val_20792 === (7))){
var inst_20787 = (state_20791[(2)]);
var state_20791__$1 = state_20791;
var statearr_20793_20832 = state_20791__$1;
(statearr_20793_20832[(2)] = inst_20787);

(statearr_20793_20832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (20))){
var inst_20757 = (state_20791[(7)]);
var inst_20768 = (state_20791[(2)]);
var inst_20769 = cljs.core.next(inst_20757);
var inst_20743 = inst_20769;
var inst_20744 = null;
var inst_20745 = (0);
var inst_20746 = (0);
var state_20791__$1 = (function (){var statearr_20794 = state_20791;
(statearr_20794[(8)] = inst_20745);

(statearr_20794[(9)] = inst_20746);

(statearr_20794[(10)] = inst_20768);

(statearr_20794[(11)] = inst_20744);

(statearr_20794[(12)] = inst_20743);

return statearr_20794;
})();
var statearr_20795_20833 = state_20791__$1;
(statearr_20795_20833[(2)] = null);

(statearr_20795_20833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (1))){
var state_20791__$1 = state_20791;
var statearr_20796_20834 = state_20791__$1;
(statearr_20796_20834[(2)] = null);

(statearr_20796_20834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (4))){
var inst_20732 = (state_20791[(13)]);
var inst_20732__$1 = (state_20791[(2)]);
var inst_20733 = (inst_20732__$1 == null);
var state_20791__$1 = (function (){var statearr_20797 = state_20791;
(statearr_20797[(13)] = inst_20732__$1);

return statearr_20797;
})();
if(cljs.core.truth_(inst_20733)){
var statearr_20798_20835 = state_20791__$1;
(statearr_20798_20835[(1)] = (5));

} else {
var statearr_20799_20836 = state_20791__$1;
(statearr_20799_20836[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (15))){
var state_20791__$1 = state_20791;
var statearr_20803_20837 = state_20791__$1;
(statearr_20803_20837[(2)] = null);

(statearr_20803_20837[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (21))){
var state_20791__$1 = state_20791;
var statearr_20804_20838 = state_20791__$1;
(statearr_20804_20838[(2)] = null);

(statearr_20804_20838[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (13))){
var inst_20745 = (state_20791[(8)]);
var inst_20746 = (state_20791[(9)]);
var inst_20744 = (state_20791[(11)]);
var inst_20743 = (state_20791[(12)]);
var inst_20753 = (state_20791[(2)]);
var inst_20754 = (inst_20746 + (1));
var tmp20800 = inst_20745;
var tmp20801 = inst_20744;
var tmp20802 = inst_20743;
var inst_20743__$1 = tmp20802;
var inst_20744__$1 = tmp20801;
var inst_20745__$1 = tmp20800;
var inst_20746__$1 = inst_20754;
var state_20791__$1 = (function (){var statearr_20805 = state_20791;
(statearr_20805[(14)] = inst_20753);

(statearr_20805[(8)] = inst_20745__$1);

(statearr_20805[(9)] = inst_20746__$1);

(statearr_20805[(11)] = inst_20744__$1);

(statearr_20805[(12)] = inst_20743__$1);

return statearr_20805;
})();
var statearr_20806_20839 = state_20791__$1;
(statearr_20806_20839[(2)] = null);

(statearr_20806_20839[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (22))){
var state_20791__$1 = state_20791;
var statearr_20807_20840 = state_20791__$1;
(statearr_20807_20840[(2)] = null);

(statearr_20807_20840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (6))){
var inst_20732 = (state_20791[(13)]);
var inst_20741 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_20732) : f.call(null,inst_20732));
var inst_20742 = cljs.core.seq(inst_20741);
var inst_20743 = inst_20742;
var inst_20744 = null;
var inst_20745 = (0);
var inst_20746 = (0);
var state_20791__$1 = (function (){var statearr_20808 = state_20791;
(statearr_20808[(8)] = inst_20745);

(statearr_20808[(9)] = inst_20746);

(statearr_20808[(11)] = inst_20744);

(statearr_20808[(12)] = inst_20743);

return statearr_20808;
})();
var statearr_20809_20841 = state_20791__$1;
(statearr_20809_20841[(2)] = null);

(statearr_20809_20841[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (17))){
var inst_20757 = (state_20791[(7)]);
var inst_20761 = cljs.core.chunk_first(inst_20757);
var inst_20762 = cljs.core.chunk_rest(inst_20757);
var inst_20763 = cljs.core.count(inst_20761);
var inst_20743 = inst_20762;
var inst_20744 = inst_20761;
var inst_20745 = inst_20763;
var inst_20746 = (0);
var state_20791__$1 = (function (){var statearr_20810 = state_20791;
(statearr_20810[(8)] = inst_20745);

(statearr_20810[(9)] = inst_20746);

(statearr_20810[(11)] = inst_20744);

(statearr_20810[(12)] = inst_20743);

return statearr_20810;
})();
var statearr_20811_20842 = state_20791__$1;
(statearr_20811_20842[(2)] = null);

(statearr_20811_20842[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (3))){
var inst_20789 = (state_20791[(2)]);
var state_20791__$1 = state_20791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20791__$1,inst_20789);
} else {
if((state_val_20792 === (12))){
var inst_20777 = (state_20791[(2)]);
var state_20791__$1 = state_20791;
var statearr_20812_20843 = state_20791__$1;
(statearr_20812_20843[(2)] = inst_20777);

(statearr_20812_20843[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (2))){
var state_20791__$1 = state_20791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20791__$1,(4),in$);
} else {
if((state_val_20792 === (23))){
var inst_20785 = (state_20791[(2)]);
var state_20791__$1 = state_20791;
var statearr_20813_20844 = state_20791__$1;
(statearr_20813_20844[(2)] = inst_20785);

(statearr_20813_20844[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (19))){
var inst_20772 = (state_20791[(2)]);
var state_20791__$1 = state_20791;
var statearr_20814_20845 = state_20791__$1;
(statearr_20814_20845[(2)] = inst_20772);

(statearr_20814_20845[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (11))){
var inst_20757 = (state_20791[(7)]);
var inst_20743 = (state_20791[(12)]);
var inst_20757__$1 = cljs.core.seq(inst_20743);
var state_20791__$1 = (function (){var statearr_20815 = state_20791;
(statearr_20815[(7)] = inst_20757__$1);

return statearr_20815;
})();
if(inst_20757__$1){
var statearr_20816_20846 = state_20791__$1;
(statearr_20816_20846[(1)] = (14));

} else {
var statearr_20817_20847 = state_20791__$1;
(statearr_20817_20847[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (9))){
var inst_20779 = (state_20791[(2)]);
var inst_20780 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_20791__$1 = (function (){var statearr_20818 = state_20791;
(statearr_20818[(15)] = inst_20779);

return statearr_20818;
})();
if(cljs.core.truth_(inst_20780)){
var statearr_20819_20848 = state_20791__$1;
(statearr_20819_20848[(1)] = (21));

} else {
var statearr_20820_20849 = state_20791__$1;
(statearr_20820_20849[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (5))){
var inst_20735 = cljs.core.async.close_BANG_(out);
var state_20791__$1 = state_20791;
var statearr_20821_20850 = state_20791__$1;
(statearr_20821_20850[(2)] = inst_20735);

(statearr_20821_20850[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (14))){
var inst_20757 = (state_20791[(7)]);
var inst_20759 = cljs.core.chunked_seq_QMARK_(inst_20757);
var state_20791__$1 = state_20791;
if(inst_20759){
var statearr_20822_20851 = state_20791__$1;
(statearr_20822_20851[(1)] = (17));

} else {
var statearr_20823_20852 = state_20791__$1;
(statearr_20823_20852[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (16))){
var inst_20775 = (state_20791[(2)]);
var state_20791__$1 = state_20791;
var statearr_20824_20853 = state_20791__$1;
(statearr_20824_20853[(2)] = inst_20775);

(statearr_20824_20853[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20792 === (10))){
var inst_20746 = (state_20791[(9)]);
var inst_20744 = (state_20791[(11)]);
var inst_20751 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_20744,inst_20746);
var state_20791__$1 = state_20791;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20791__$1,(13),out,inst_20751);
} else {
if((state_val_20792 === (18))){
var inst_20757 = (state_20791[(7)]);
var inst_20766 = cljs.core.first(inst_20757);
var state_20791__$1 = state_20791;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20791__$1,(20),out,inst_20766);
} else {
if((state_val_20792 === (8))){
var inst_20745 = (state_20791[(8)]);
var inst_20746 = (state_20791[(9)]);
var inst_20748 = (inst_20746 < inst_20745);
var inst_20749 = inst_20748;
var state_20791__$1 = state_20791;
if(cljs.core.truth_(inst_20749)){
var statearr_20825_20854 = state_20791__$1;
(statearr_20825_20854[(1)] = (10));

} else {
var statearr_20826_20855 = state_20791__$1;
(statearr_20826_20855[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__17178__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__17178__auto____0 = (function (){
var statearr_20827 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20827[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__17178__auto__);

(statearr_20827[(1)] = (1));

return statearr_20827;
});
var cljs$core$async$mapcat_STAR__$_state_machine__17178__auto____1 = (function (state_20791){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_20791);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e20828){var ex__17181__auto__ = e20828;
var statearr_20829_20856 = state_20791;
(statearr_20829_20856[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_20791[(4)]))){
var statearr_20830_20857 = state_20791;
(statearr_20830_20857[(1)] = cljs.core.first((state_20791[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20858 = state_20791;
state_20791 = G__20858;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__17178__auto__ = function(state_20791){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__17178__auto____1.call(this,state_20791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__17178__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__17178__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_20831 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_20831[(6)] = c__17304__auto__);

return statearr_20831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__20860 = arguments.length;
switch (G__20860) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__20863 = arguments.length;
switch (G__20863) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__20866 = arguments.length;
switch (G__20866) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17304__auto___20914 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_20890){
var state_val_20891 = (state_20890[(1)]);
if((state_val_20891 === (7))){
var inst_20885 = (state_20890[(2)]);
var state_20890__$1 = state_20890;
var statearr_20892_20915 = state_20890__$1;
(statearr_20892_20915[(2)] = inst_20885);

(statearr_20892_20915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20891 === (1))){
var inst_20867 = null;
var state_20890__$1 = (function (){var statearr_20893 = state_20890;
(statearr_20893[(7)] = inst_20867);

return statearr_20893;
})();
var statearr_20894_20916 = state_20890__$1;
(statearr_20894_20916[(2)] = null);

(statearr_20894_20916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20891 === (4))){
var inst_20870 = (state_20890[(8)]);
var inst_20870__$1 = (state_20890[(2)]);
var inst_20871 = (inst_20870__$1 == null);
var inst_20872 = cljs.core.not(inst_20871);
var state_20890__$1 = (function (){var statearr_20895 = state_20890;
(statearr_20895[(8)] = inst_20870__$1);

return statearr_20895;
})();
if(inst_20872){
var statearr_20896_20917 = state_20890__$1;
(statearr_20896_20917[(1)] = (5));

} else {
var statearr_20897_20918 = state_20890__$1;
(statearr_20897_20918[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20891 === (6))){
var state_20890__$1 = state_20890;
var statearr_20898_20919 = state_20890__$1;
(statearr_20898_20919[(2)] = null);

(statearr_20898_20919[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20891 === (3))){
var inst_20887 = (state_20890[(2)]);
var inst_20888 = cljs.core.async.close_BANG_(out);
var state_20890__$1 = (function (){var statearr_20899 = state_20890;
(statearr_20899[(9)] = inst_20887);

return statearr_20899;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_20890__$1,inst_20888);
} else {
if((state_val_20891 === (2))){
var state_20890__$1 = state_20890;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20890__$1,(4),ch);
} else {
if((state_val_20891 === (11))){
var inst_20870 = (state_20890[(8)]);
var inst_20879 = (state_20890[(2)]);
var inst_20867 = inst_20870;
var state_20890__$1 = (function (){var statearr_20900 = state_20890;
(statearr_20900[(7)] = inst_20867);

(statearr_20900[(10)] = inst_20879);

return statearr_20900;
})();
var statearr_20901_20920 = state_20890__$1;
(statearr_20901_20920[(2)] = null);

(statearr_20901_20920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20891 === (9))){
var inst_20870 = (state_20890[(8)]);
var state_20890__$1 = state_20890;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20890__$1,(11),out,inst_20870);
} else {
if((state_val_20891 === (5))){
var inst_20867 = (state_20890[(7)]);
var inst_20870 = (state_20890[(8)]);
var inst_20874 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20870,inst_20867);
var state_20890__$1 = state_20890;
if(inst_20874){
var statearr_20903_20921 = state_20890__$1;
(statearr_20903_20921[(1)] = (8));

} else {
var statearr_20904_20922 = state_20890__$1;
(statearr_20904_20922[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20891 === (10))){
var inst_20882 = (state_20890[(2)]);
var state_20890__$1 = state_20890;
var statearr_20905_20923 = state_20890__$1;
(statearr_20905_20923[(2)] = inst_20882);

(statearr_20905_20923[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20891 === (8))){
var inst_20867 = (state_20890[(7)]);
var tmp20902 = inst_20867;
var inst_20867__$1 = tmp20902;
var state_20890__$1 = (function (){var statearr_20906 = state_20890;
(statearr_20906[(7)] = inst_20867__$1);

return statearr_20906;
})();
var statearr_20907_20924 = state_20890__$1;
(statearr_20907_20924[(2)] = null);

(statearr_20907_20924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_20908 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20908[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_20908[(1)] = (1));

return statearr_20908;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_20890){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_20890);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e20909){var ex__17181__auto__ = e20909;
var statearr_20910_20925 = state_20890;
(statearr_20910_20925[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_20890[(4)]))){
var statearr_20911_20926 = state_20890;
(statearr_20911_20926[(1)] = cljs.core.first((state_20890[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20927 = state_20890;
state_20890 = G__20927;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_20890){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_20890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_20912 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_20912[(6)] = c__17304__auto___20914);

return statearr_20912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__20929 = arguments.length;
switch (G__20929) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17304__auto___20996 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_20967){
var state_val_20968 = (state_20967[(1)]);
if((state_val_20968 === (7))){
var inst_20963 = (state_20967[(2)]);
var state_20967__$1 = state_20967;
var statearr_20969_20997 = state_20967__$1;
(statearr_20969_20997[(2)] = inst_20963);

(statearr_20969_20997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20968 === (1))){
var inst_20930 = (new Array(n));
var inst_20931 = inst_20930;
var inst_20932 = (0);
var state_20967__$1 = (function (){var statearr_20970 = state_20967;
(statearr_20970[(7)] = inst_20931);

(statearr_20970[(8)] = inst_20932);

return statearr_20970;
})();
var statearr_20971_20998 = state_20967__$1;
(statearr_20971_20998[(2)] = null);

(statearr_20971_20998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20968 === (4))){
var inst_20935 = (state_20967[(9)]);
var inst_20935__$1 = (state_20967[(2)]);
var inst_20936 = (inst_20935__$1 == null);
var inst_20937 = cljs.core.not(inst_20936);
var state_20967__$1 = (function (){var statearr_20972 = state_20967;
(statearr_20972[(9)] = inst_20935__$1);

return statearr_20972;
})();
if(inst_20937){
var statearr_20973_20999 = state_20967__$1;
(statearr_20973_20999[(1)] = (5));

} else {
var statearr_20974_21000 = state_20967__$1;
(statearr_20974_21000[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20968 === (15))){
var inst_20957 = (state_20967[(2)]);
var state_20967__$1 = state_20967;
var statearr_20975_21001 = state_20967__$1;
(statearr_20975_21001[(2)] = inst_20957);

(statearr_20975_21001[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20968 === (13))){
var state_20967__$1 = state_20967;
var statearr_20976_21002 = state_20967__$1;
(statearr_20976_21002[(2)] = null);

(statearr_20976_21002[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20968 === (6))){
var inst_20932 = (state_20967[(8)]);
var inst_20953 = (inst_20932 > (0));
var state_20967__$1 = state_20967;
if(cljs.core.truth_(inst_20953)){
var statearr_20977_21003 = state_20967__$1;
(statearr_20977_21003[(1)] = (12));

} else {
var statearr_20978_21004 = state_20967__$1;
(statearr_20978_21004[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20968 === (3))){
var inst_20965 = (state_20967[(2)]);
var state_20967__$1 = state_20967;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20967__$1,inst_20965);
} else {
if((state_val_20968 === (12))){
var inst_20931 = (state_20967[(7)]);
var inst_20955 = cljs.core.vec(inst_20931);
var state_20967__$1 = state_20967;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20967__$1,(15),out,inst_20955);
} else {
if((state_val_20968 === (2))){
var state_20967__$1 = state_20967;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20967__$1,(4),ch);
} else {
if((state_val_20968 === (11))){
var inst_20947 = (state_20967[(2)]);
var inst_20948 = (new Array(n));
var inst_20931 = inst_20948;
var inst_20932 = (0);
var state_20967__$1 = (function (){var statearr_20979 = state_20967;
(statearr_20979[(10)] = inst_20947);

(statearr_20979[(7)] = inst_20931);

(statearr_20979[(8)] = inst_20932);

return statearr_20979;
})();
var statearr_20980_21005 = state_20967__$1;
(statearr_20980_21005[(2)] = null);

(statearr_20980_21005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20968 === (9))){
var inst_20931 = (state_20967[(7)]);
var inst_20945 = cljs.core.vec(inst_20931);
var state_20967__$1 = state_20967;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20967__$1,(11),out,inst_20945);
} else {
if((state_val_20968 === (5))){
var inst_20940 = (state_20967[(11)]);
var inst_20931 = (state_20967[(7)]);
var inst_20932 = (state_20967[(8)]);
var inst_20935 = (state_20967[(9)]);
var inst_20939 = (inst_20931[inst_20932] = inst_20935);
var inst_20940__$1 = (inst_20932 + (1));
var inst_20941 = (inst_20940__$1 < n);
var state_20967__$1 = (function (){var statearr_20981 = state_20967;
(statearr_20981[(11)] = inst_20940__$1);

(statearr_20981[(12)] = inst_20939);

return statearr_20981;
})();
if(cljs.core.truth_(inst_20941)){
var statearr_20982_21006 = state_20967__$1;
(statearr_20982_21006[(1)] = (8));

} else {
var statearr_20983_21007 = state_20967__$1;
(statearr_20983_21007[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20968 === (14))){
var inst_20960 = (state_20967[(2)]);
var inst_20961 = cljs.core.async.close_BANG_(out);
var state_20967__$1 = (function (){var statearr_20985 = state_20967;
(statearr_20985[(13)] = inst_20960);

return statearr_20985;
})();
var statearr_20986_21008 = state_20967__$1;
(statearr_20986_21008[(2)] = inst_20961);

(statearr_20986_21008[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20968 === (10))){
var inst_20951 = (state_20967[(2)]);
var state_20967__$1 = state_20967;
var statearr_20987_21009 = state_20967__$1;
(statearr_20987_21009[(2)] = inst_20951);

(statearr_20987_21009[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20968 === (8))){
var inst_20940 = (state_20967[(11)]);
var inst_20931 = (state_20967[(7)]);
var tmp20984 = inst_20931;
var inst_20931__$1 = tmp20984;
var inst_20932 = inst_20940;
var state_20967__$1 = (function (){var statearr_20988 = state_20967;
(statearr_20988[(7)] = inst_20931__$1);

(statearr_20988[(8)] = inst_20932);

return statearr_20988;
})();
var statearr_20989_21010 = state_20967__$1;
(statearr_20989_21010[(2)] = null);

(statearr_20989_21010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_20990 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20990[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_20990[(1)] = (1));

return statearr_20990;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_20967){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_20967);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e20991){var ex__17181__auto__ = e20991;
var statearr_20992_21011 = state_20967;
(statearr_20992_21011[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_20967[(4)]))){
var statearr_20993_21012 = state_20967;
(statearr_20993_21012[(1)] = cljs.core.first((state_20967[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21013 = state_20967;
state_20967 = G__21013;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_20967){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_20967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_20994 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_20994[(6)] = c__17304__auto___20996);

return statearr_20994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__21015 = arguments.length;
switch (G__21015) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17304__auto___21093 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_21060){
var state_val_21061 = (state_21060[(1)]);
if((state_val_21061 === (7))){
var inst_21056 = (state_21060[(2)]);
var state_21060__$1 = state_21060;
var statearr_21062_21094 = state_21060__$1;
(statearr_21062_21094[(2)] = inst_21056);

(statearr_21062_21094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (1))){
var inst_21016 = [];
var inst_21017 = inst_21016;
var inst_21018 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21060__$1 = (function (){var statearr_21063 = state_21060;
(statearr_21063[(7)] = inst_21017);

(statearr_21063[(8)] = inst_21018);

return statearr_21063;
})();
var statearr_21064_21095 = state_21060__$1;
(statearr_21064_21095[(2)] = null);

(statearr_21064_21095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (4))){
var inst_21021 = (state_21060[(9)]);
var inst_21021__$1 = (state_21060[(2)]);
var inst_21022 = (inst_21021__$1 == null);
var inst_21023 = cljs.core.not(inst_21022);
var state_21060__$1 = (function (){var statearr_21065 = state_21060;
(statearr_21065[(9)] = inst_21021__$1);

return statearr_21065;
})();
if(inst_21023){
var statearr_21066_21096 = state_21060__$1;
(statearr_21066_21096[(1)] = (5));

} else {
var statearr_21067_21097 = state_21060__$1;
(statearr_21067_21097[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (15))){
var inst_21017 = (state_21060[(7)]);
var inst_21048 = cljs.core.vec(inst_21017);
var state_21060__$1 = state_21060;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21060__$1,(18),out,inst_21048);
} else {
if((state_val_21061 === (13))){
var inst_21043 = (state_21060[(2)]);
var state_21060__$1 = state_21060;
var statearr_21068_21098 = state_21060__$1;
(statearr_21068_21098[(2)] = inst_21043);

(statearr_21068_21098[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (6))){
var inst_21017 = (state_21060[(7)]);
var inst_21045 = inst_21017.length;
var inst_21046 = (inst_21045 > (0));
var state_21060__$1 = state_21060;
if(cljs.core.truth_(inst_21046)){
var statearr_21069_21099 = state_21060__$1;
(statearr_21069_21099[(1)] = (15));

} else {
var statearr_21070_21100 = state_21060__$1;
(statearr_21070_21100[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (17))){
var inst_21053 = (state_21060[(2)]);
var inst_21054 = cljs.core.async.close_BANG_(out);
var state_21060__$1 = (function (){var statearr_21071 = state_21060;
(statearr_21071[(10)] = inst_21053);

return statearr_21071;
})();
var statearr_21072_21101 = state_21060__$1;
(statearr_21072_21101[(2)] = inst_21054);

(statearr_21072_21101[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (3))){
var inst_21058 = (state_21060[(2)]);
var state_21060__$1 = state_21060;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21060__$1,inst_21058);
} else {
if((state_val_21061 === (12))){
var inst_21017 = (state_21060[(7)]);
var inst_21036 = cljs.core.vec(inst_21017);
var state_21060__$1 = state_21060;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21060__$1,(14),out,inst_21036);
} else {
if((state_val_21061 === (2))){
var state_21060__$1 = state_21060;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21060__$1,(4),ch);
} else {
if((state_val_21061 === (11))){
var inst_21021 = (state_21060[(9)]);
var inst_21025 = (state_21060[(11)]);
var inst_21017 = (state_21060[(7)]);
var inst_21033 = inst_21017.push(inst_21021);
var tmp21073 = inst_21017;
var inst_21017__$1 = tmp21073;
var inst_21018 = inst_21025;
var state_21060__$1 = (function (){var statearr_21074 = state_21060;
(statearr_21074[(12)] = inst_21033);

(statearr_21074[(7)] = inst_21017__$1);

(statearr_21074[(8)] = inst_21018);

return statearr_21074;
})();
var statearr_21075_21102 = state_21060__$1;
(statearr_21075_21102[(2)] = null);

(statearr_21075_21102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (9))){
var inst_21018 = (state_21060[(8)]);
var inst_21029 = cljs.core.keyword_identical_QMARK_(inst_21018,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_21060__$1 = state_21060;
var statearr_21076_21103 = state_21060__$1;
(statearr_21076_21103[(2)] = inst_21029);

(statearr_21076_21103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (5))){
var inst_21021 = (state_21060[(9)]);
var inst_21026 = (state_21060[(13)]);
var inst_21025 = (state_21060[(11)]);
var inst_21018 = (state_21060[(8)]);
var inst_21025__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_21021) : f.call(null,inst_21021));
var inst_21026__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21025__$1,inst_21018);
var state_21060__$1 = (function (){var statearr_21077 = state_21060;
(statearr_21077[(13)] = inst_21026__$1);

(statearr_21077[(11)] = inst_21025__$1);

return statearr_21077;
})();
if(inst_21026__$1){
var statearr_21078_21104 = state_21060__$1;
(statearr_21078_21104[(1)] = (8));

} else {
var statearr_21079_21105 = state_21060__$1;
(statearr_21079_21105[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (14))){
var inst_21021 = (state_21060[(9)]);
var inst_21025 = (state_21060[(11)]);
var inst_21038 = (state_21060[(2)]);
var inst_21039 = [];
var inst_21040 = inst_21039.push(inst_21021);
var inst_21017 = inst_21039;
var inst_21018 = inst_21025;
var state_21060__$1 = (function (){var statearr_21080 = state_21060;
(statearr_21080[(14)] = inst_21040);

(statearr_21080[(15)] = inst_21038);

(statearr_21080[(7)] = inst_21017);

(statearr_21080[(8)] = inst_21018);

return statearr_21080;
})();
var statearr_21081_21106 = state_21060__$1;
(statearr_21081_21106[(2)] = null);

(statearr_21081_21106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (16))){
var state_21060__$1 = state_21060;
var statearr_21082_21107 = state_21060__$1;
(statearr_21082_21107[(2)] = null);

(statearr_21082_21107[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (10))){
var inst_21031 = (state_21060[(2)]);
var state_21060__$1 = state_21060;
if(cljs.core.truth_(inst_21031)){
var statearr_21083_21108 = state_21060__$1;
(statearr_21083_21108[(1)] = (11));

} else {
var statearr_21084_21109 = state_21060__$1;
(statearr_21084_21109[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (18))){
var inst_21050 = (state_21060[(2)]);
var state_21060__$1 = state_21060;
var statearr_21085_21110 = state_21060__$1;
(statearr_21085_21110[(2)] = inst_21050);

(statearr_21085_21110[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21061 === (8))){
var inst_21026 = (state_21060[(13)]);
var state_21060__$1 = state_21060;
var statearr_21086_21111 = state_21060__$1;
(statearr_21086_21111[(2)] = inst_21026);

(statearr_21086_21111[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_21087 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21087[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_21087[(1)] = (1));

return statearr_21087;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_21060){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_21060);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e21088){var ex__17181__auto__ = e21088;
var statearr_21089_21112 = state_21060;
(statearr_21089_21112[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_21060[(4)]))){
var statearr_21090_21113 = state_21060;
(statearr_21090_21113[(1)] = cljs.core.first((state_21060[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21114 = state_21060;
state_21060 = G__21114;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_21060){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_21060);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_21091 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_21091[(6)] = c__17304__auto___21093);

return statearr_21091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

