// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__76733 = (line + (1));
var G__76734 = (1);
var G__76735 = (counter + (1));
line = G__76733;
col = G__76734;
counter = G__76735;
continue;
} else {
var G__76736 = line;
var G__76737 = (col + (1));
var G__76738 = (counter + (1));
line = G__76736;
col = G__76737;
counter = G__76738;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__76739 = cljs.core.next(chars);
var G__76740 = (n__$1 - (1));
chars = G__76739;
n__$1 = G__76740;
continue;
} else {
var G__76741 = cljs.core.next(chars);
var G__76742 = n__$1;
chars = G__76741;
n__$1 = G__76742;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__76743){
var map__76744 = p__76743;
var map__76744__$1 = cljs.core.__destructure_map(map__76744);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76744__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76744__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76744__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76744__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__76745_76753 = cljs.core.seq(full_reasons);
var chunk__76746_76754 = null;
var count__76747_76755 = (0);
var i__76748_76756 = (0);
while(true){
if((i__76748_76756 < count__76747_76755)){
var r_76757 = chunk__76746_76754.cljs$core$IIndexed$_nth$arity$2(null,i__76748_76756);
instaparse.failure.print_reason(r_76757);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__76758 = seq__76745_76753;
var G__76759 = chunk__76746_76754;
var G__76760 = count__76747_76755;
var G__76761 = (i__76748_76756 + (1));
seq__76745_76753 = G__76758;
chunk__76746_76754 = G__76759;
count__76747_76755 = G__76760;
i__76748_76756 = G__76761;
continue;
} else {
var temp__5753__auto___76762 = cljs.core.seq(seq__76745_76753);
if(temp__5753__auto___76762){
var seq__76745_76763__$1 = temp__5753__auto___76762;
if(cljs.core.chunked_seq_QMARK_(seq__76745_76763__$1)){
var c__4638__auto___76764 = cljs.core.chunk_first(seq__76745_76763__$1);
var G__76765 = cljs.core.chunk_rest(seq__76745_76763__$1);
var G__76766 = c__4638__auto___76764;
var G__76767 = cljs.core.count(c__4638__auto___76764);
var G__76768 = (0);
seq__76745_76753 = G__76765;
chunk__76746_76754 = G__76766;
count__76747_76755 = G__76767;
i__76748_76756 = G__76768;
continue;
} else {
var r_76769 = cljs.core.first(seq__76745_76763__$1);
instaparse.failure.print_reason(r_76769);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__76770 = cljs.core.next(seq__76745_76763__$1);
var G__76771 = null;
var G__76772 = (0);
var G__76773 = (0);
seq__76745_76753 = G__76770;
chunk__76746_76754 = G__76771;
count__76747_76755 = G__76772;
i__76748_76756 = G__76773;
continue;
}
} else {
}
}
break;
}

var seq__76749 = cljs.core.seq(partial_reasons);
var chunk__76750 = null;
var count__76751 = (0);
var i__76752 = (0);
while(true){
if((i__76752 < count__76751)){
var r = chunk__76750.cljs$core$IIndexed$_nth$arity$2(null,i__76752);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__76774 = seq__76749;
var G__76775 = chunk__76750;
var G__76776 = count__76751;
var G__76777 = (i__76752 + (1));
seq__76749 = G__76774;
chunk__76750 = G__76775;
count__76751 = G__76776;
i__76752 = G__76777;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__76749);
if(temp__5753__auto__){
var seq__76749__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__76749__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__76749__$1);
var G__76778 = cljs.core.chunk_rest(seq__76749__$1);
var G__76779 = c__4638__auto__;
var G__76780 = cljs.core.count(c__4638__auto__);
var G__76781 = (0);
seq__76749 = G__76778;
chunk__76750 = G__76779;
count__76751 = G__76780;
i__76752 = G__76781;
continue;
} else {
var r = cljs.core.first(seq__76749__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__76782 = cljs.core.next(seq__76749__$1);
var G__76783 = null;
var G__76784 = (0);
var G__76785 = (0);
seq__76749 = G__76782;
chunk__76750 = G__76783;
count__76751 = G__76784;
i__76752 = G__76785;
continue;
}
} else {
return null;
}
}
break;
}
});
