// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.response;
if(cljs.core.truth_(temp__5753__auto__)){
var resp = temp__5753__auto__;
var temp__5753__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5753__auto____$1)){
var st = temp__5753__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?cljs.core.cst$kw$xhttp_SLASH_timeout:(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4210__auto__;
}
})())?cljs.core.cst$kw$xhttp_SLASH_http_DASH_error:(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return (status >= (500));
} else {
return and__4210__auto__;
}
})())?cljs.core.cst$kw$xhttp_SLASH_exception:(function (){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["XHTTP Request Error:",e.request], 0));

return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return (status > (0));
} else {
return and__4210__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__35512 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__35512,cljs.core.cst$kw$status,status);
} else {
return G__35512;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__35513 = opts;
var map__35513__$1 = cljs.core.__destructure_map(map__35513);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35513__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35513__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35513__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__35514 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__35514__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__35514,headers], 0)):G__35514);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__35514__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__35514__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$method,"post",cljs.core.cst$kw$timeout,request_timeout,cljs.core.cst$kw$headers,headers__$1,cljs.core.cst$kw$data,message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__35515 = opts;
var map__35515__$1 = cljs.core.__destructure_map(map__35515);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35515__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35515__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35515__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35515__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35515__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__35516 = cljs.core.PersistentArrayMap.EMPTY;
var G__35516__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__35516,headers], 0)):G__35516);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__35516__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__35516__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$method,"get",cljs.core.cst$kw$timeout,request_timeout,cljs.core.cst$kw$headers,headers__$1], null))).then((function (resp){
var data = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__35517 = output_format;
var G__35517__$1 = (((G__35517 instanceof cljs.core.Keyword))?G__35517.fqn:null);
switch (G__35517__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__35519 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__35519,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__35519;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_35551){
var state_val_35552 = (state_35551[(1)]);
if((state_val_35552 === (7))){
var inst_35547 = (state_35551[(2)]);
var state_35551__$1 = state_35551;
var statearr_35553_35578 = state_35551__$1;
(statearr_35553_35578[(2)] = inst_35547);

(statearr_35553_35578[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35552 === (1))){
var state_35551__$1 = state_35551;
var statearr_35554_35579 = state_35551__$1;
(statearr_35554_35579[(2)] = null);

(statearr_35554_35579[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35552 === (4))){
var inst_35522 = (state_35551[(7)]);
var inst_35522__$1 = (state_35551[(2)]);
var inst_35523 = (inst_35522__$1 == null);
var state_35551__$1 = (function (){var statearr_35555 = state_35551;
(statearr_35555[(7)] = inst_35522__$1);

return statearr_35555;
})();
if(cljs.core.truth_(inst_35523)){
var statearr_35556_35580 = state_35551__$1;
(statearr_35556_35580[(1)] = (5));

} else {
var statearr_35557_35581 = state_35551__$1;
(statearr_35557_35581[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35552 === (6))){
var inst_35522 = (state_35551[(7)]);
var inst_35530 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35522,(0),null);
var inst_35531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35522,(1),null);
var state_35551__$1 = (function (){var statearr_35558 = state_35551;
(statearr_35558[(8)] = inst_35531);

(statearr_35558[(9)] = inst_35530);

return statearr_35558;
})();
var statearr_35559_35582 = state_35551__$1;
(statearr_35559_35582[(2)] = null);

(statearr_35559_35582[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35552 === (3))){
var inst_35549 = (state_35551[(2)]);
var state_35551__$1 = state_35551;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35551__$1,inst_35549);
} else {
if((state_val_35552 === (2))){
var state_35551__$1 = state_35551;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35551__$1,(4),pub_chan);
} else {
if((state_val_35552 === (11))){
var _ = (function (){var statearr_35561 = state_35551;
(statearr_35561[(4)] = cljs.core.rest((state_35551[(4)])));

return statearr_35561;
})();
var state_35551__$1 = state_35551;
var ex35560 = (state_35551__$1[(2)]);
var statearr_35562_35583 = state_35551__$1;
(statearr_35562_35583[(5)] = ex35560);


var statearr_35563_35584 = state_35551__$1;
(statearr_35563_35584[(1)] = (10));

(statearr_35563_35584[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_35552 === (9))){
var inst_35544 = (state_35551[(2)]);
var state_35551__$1 = (function (){var statearr_35564 = state_35551;
(statearr_35564[(10)] = inst_35544);

return statearr_35564;
})();
var statearr_35565_35585 = state_35551__$1;
(statearr_35565_35585[(2)] = null);

(statearr_35565_35585[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35552 === (5))){
var inst_35525 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_35551__$1 = state_35551;
var statearr_35566_35586 = state_35551__$1;
(statearr_35566_35586[(2)] = inst_35525);

(statearr_35566_35586[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35552 === (10))){
var inst_35531 = (state_35551[(8)]);
var inst_35530 = (state_35551[(9)]);
var inst_35532 = (state_35551[(2)]);
var inst_35533 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35532,"Error sending websocket message:",inst_35530], 0));
var inst_35534 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_35531,false);
var state_35551__$1 = (function (){var statearr_35567 = state_35551;
(statearr_35567[(11)] = inst_35533);

return statearr_35567;
})();
var statearr_35568_35587 = state_35551__$1;
(statearr_35568_35587[(2)] = inst_35534);

(statearr_35568_35587[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35552 === (8))){
var inst_35531 = (state_35551[(8)]);
var inst_35530 = (state_35551[(9)]);
var _ = (function (){var statearr_35569 = state_35551;
(statearr_35569[(4)] = cljs.core.cons((11),(state_35551[(4)])));

return statearr_35569;
})();
var inst_35540 = ws.send(inst_35530);
var inst_35541 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_35531,true);
var ___$1 = (function (){var statearr_35570 = state_35551;
(statearr_35570[(4)] = cljs.core.rest((state_35551[(4)])));

return statearr_35570;
})();
var state_35551__$1 = (function (){var statearr_35571 = state_35551;
(statearr_35571[(12)] = inst_35540);

return statearr_35571;
})();
var statearr_35572_35588 = state_35551__$1;
(statearr_35572_35588[(2)] = inst_35541);

(statearr_35572_35588[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16395__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16395__auto____0 = (function (){
var statearr_35573 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35573[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16395__auto__);

(statearr_35573[(1)] = (1));

return statearr_35573;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16395__auto____1 = (function (state_35551){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_35551);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e35574){var ex__16398__auto__ = e35574;
var statearr_35575_35589 = state_35551;
(statearr_35575_35589[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_35551[(4)]))){
var statearr_35576_35590 = state_35551;
(statearr_35576_35590[(1)] = cljs.core.first((state_35551[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__35591 = state_35551;
state_35551 = G__35591;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16395__auto__ = function(state_35551){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16395__auto____1.call(this,state_35551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16395__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16395__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_35577 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_35577[(6)] = c__16469__auto__);

return statearr_35577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__16469__auto___35629 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_35616){
var state_val_35617 = (state_35616[(1)]);
if((state_val_35617 === (1))){
var inst_35595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35596 = [open_QMARK_,timeout_chan];
var inst_35597 = (new cljs.core.PersistentVector(null,2,(5),inst_35595,inst_35596,null));
var state_35616__$1 = state_35616;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_35616__$1,(2),inst_35597,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_35617 === (2))){
var inst_35599 = (state_35616[(2)]);
var inst_35600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35599,(0),null);
var inst_35601 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35599,(1),null);
var inst_35602 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35601,timeout_chan);
var state_35616__$1 = (function (){var statearr_35618 = state_35616;
(statearr_35618[(7)] = inst_35600);

return statearr_35618;
})();
if(inst_35602){
var statearr_35619_35630 = state_35616__$1;
(statearr_35619_35630[(1)] = (3));

} else {
var statearr_35620_35631 = state_35616__$1;
(statearr_35620_35631[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (3))){
var inst_35604 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_35605 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35606 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_35607 = cljs.core.PersistentHashMap.fromArrays(inst_35605,inst_35606);
var inst_35608 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35604,inst_35607);
var inst_35609 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_35608);
var inst_35610 = fluree.db.util.xhttp.close_websocket(ws);
var state_35616__$1 = (function (){var statearr_35621 = state_35616;
(statearr_35621[(8)] = inst_35609);

return statearr_35621;
})();
var statearr_35622_35632 = state_35616__$1;
(statearr_35622_35632[(2)] = inst_35610);

(statearr_35622_35632[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (4))){
var inst_35612 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_35616__$1 = state_35616;
var statearr_35623_35633 = state_35616__$1;
(statearr_35623_35633[(2)] = inst_35612);

(statearr_35623_35633[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (5))){
var inst_35614 = (state_35616[(2)]);
var state_35616__$1 = state_35616;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35616__$1,inst_35614);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__16395__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__16395__auto____0 = (function (){
var statearr_35624 = [null,null,null,null,null,null,null,null,null];
(statearr_35624[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__16395__auto__);

(statearr_35624[(1)] = (1));

return statearr_35624;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__16395__auto____1 = (function (state_35616){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_35616);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e35625){var ex__16398__auto__ = e35625;
var statearr_35626_35634 = state_35616;
(statearr_35626_35634[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_35616[(4)]))){
var statearr_35627_35635 = state_35616;
(statearr_35627_35635[(1)] = cljs.core.first((state_35616[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__35636 = state_35616;
state_35616 = G__35636;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__16395__auto__ = function(state_35616){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__16395__auto____1.call(this,state_35616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__16395__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__16395__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_35628 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_35628[(6)] = c__16469__auto___35629);

return statearr_35628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
