// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k43776,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__43780 = k43776;
var G__43780__$1 = (((G__43780 instanceof cljs.core.Keyword))?G__43780.fqn:null);
switch (G__43780__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k43776,else__4464__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__43781){
var vec__43782 = p__43781;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43782,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43782,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__43775){
var self__ = this;
var G__43775__$1 = this;
return (new cljs.core.RecordIter((0),G__43775__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__43785 = (function (coll__4458__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__43785(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this43777,other43778){
var self__ = this;
var this43777__$1 = this;
return (((!((other43778 == null)))) && ((((this43777__$1.constructor === other43778.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43777__$1.conn,other43778.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43777__$1.network,other43778.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43777__$1.dbid,other43778.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43777__$1.db_name,other43778.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43777__$1.update_chan,other43778.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43777__$1.transact_chan,other43778.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43777__$1.state,other43778.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43777__$1.schema_cache,other43778.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43777__$1.blank_db,other43778.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43777__$1.close,other43778.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43777__$1.id,other43778.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43777__$1.__extmap,other43778.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k43776){
var self__ = this;
var this__4468__auto____$1 = this;
var G__43786 = k43776;
var G__43786__$1 = (((G__43786 instanceof cljs.core.Keyword))?G__43786.fqn:null);
switch (G__43786__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k43776);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__43775){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__43787 = cljs.core.keyword_identical_QMARK_;
var expr__43788 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__43790 = cljs.core.cst$kw$conn;
var G__43791 = expr__43788;
return (pred__43787.cljs$core$IFn$_invoke$arity$2 ? pred__43787.cljs$core$IFn$_invoke$arity$2(G__43790,G__43791) : pred__43787.call(null,G__43790,G__43791));
})())){
return (new fluree.db.session.DbSession(G__43775,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43792 = cljs.core.cst$kw$network;
var G__43793 = expr__43788;
return (pred__43787.cljs$core$IFn$_invoke$arity$2 ? pred__43787.cljs$core$IFn$_invoke$arity$2(G__43792,G__43793) : pred__43787.call(null,G__43792,G__43793));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__43775,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43794 = cljs.core.cst$kw$dbid;
var G__43795 = expr__43788;
return (pred__43787.cljs$core$IFn$_invoke$arity$2 ? pred__43787.cljs$core$IFn$_invoke$arity$2(G__43794,G__43795) : pred__43787.call(null,G__43794,G__43795));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__43775,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43796 = cljs.core.cst$kw$db_DASH_name;
var G__43797 = expr__43788;
return (pred__43787.cljs$core$IFn$_invoke$arity$2 ? pred__43787.cljs$core$IFn$_invoke$arity$2(G__43796,G__43797) : pred__43787.call(null,G__43796,G__43797));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__43775,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43798 = cljs.core.cst$kw$update_DASH_chan;
var G__43799 = expr__43788;
return (pred__43787.cljs$core$IFn$_invoke$arity$2 ? pred__43787.cljs$core$IFn$_invoke$arity$2(G__43798,G__43799) : pred__43787.call(null,G__43798,G__43799));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__43775,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43800 = cljs.core.cst$kw$transact_DASH_chan;
var G__43801 = expr__43788;
return (pred__43787.cljs$core$IFn$_invoke$arity$2 ? pred__43787.cljs$core$IFn$_invoke$arity$2(G__43800,G__43801) : pred__43787.call(null,G__43800,G__43801));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__43775,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43802 = cljs.core.cst$kw$state;
var G__43803 = expr__43788;
return (pred__43787.cljs$core$IFn$_invoke$arity$2 ? pred__43787.cljs$core$IFn$_invoke$arity$2(G__43802,G__43803) : pred__43787.call(null,G__43802,G__43803));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__43775,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43804 = cljs.core.cst$kw$schema_DASH_cache;
var G__43805 = expr__43788;
return (pred__43787.cljs$core$IFn$_invoke$arity$2 ? pred__43787.cljs$core$IFn$_invoke$arity$2(G__43804,G__43805) : pred__43787.call(null,G__43804,G__43805));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__43775,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43806 = cljs.core.cst$kw$blank_DASH_db;
var G__43807 = expr__43788;
return (pred__43787.cljs$core$IFn$_invoke$arity$2 ? pred__43787.cljs$core$IFn$_invoke$arity$2(G__43806,G__43807) : pred__43787.call(null,G__43806,G__43807));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__43775,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43808 = cljs.core.cst$kw$close;
var G__43809 = expr__43788;
return (pred__43787.cljs$core$IFn$_invoke$arity$2 ? pred__43787.cljs$core$IFn$_invoke$arity$2(G__43808,G__43809) : pred__43787.call(null,G__43808,G__43809));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__43775,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43810 = cljs.core.cst$kw$id;
var G__43811 = expr__43788;
return (pred__43787.cljs$core$IFn$_invoke$arity$2 ? pred__43787.cljs$core$IFn$_invoke$arity$2(G__43810,G__43811) : pred__43787.call(null,G__43810,G__43811));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__43775,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__43775),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__43775){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__43775,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__43779){
var extmap__4501__auto__ = (function (){var G__43812 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__43779,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__43779)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__43812);
} else {
return G__43812;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__43779),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__43779),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__43779),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__43779),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__43779),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__43779),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__43779),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__43779),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__43779),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__43779),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__43779),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__43815 = session;
var map__43815__$1 = cljs.core.__destructure_map(map__43815);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43815__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43815__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___43967 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43919){
var state_val_43920 = (state_43919[(1)]);
if((state_val_43920 === (7))){
var inst_43836 = (state_43919[(7)]);
var inst_43841 = cljs.core.empty_QMARK_(inst_43836);
var state_43919__$1 = state_43919;
if(inst_43841){
var statearr_43921_43968 = state_43919__$1;
(statearr_43921_43968[(1)] = (10));

} else {
var statearr_43922_43969 = state_43919__$1;
(statearr_43922_43969[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (20))){
var inst_43867 = (state_43919[(8)]);
var inst_43827 = (state_43919[(9)]);
var inst_43829 = (state_43919[(10)]);
var inst_43828 = (state_43919[(11)]);
var inst_43872 = fluree.db.storage.core.read_block(inst_43827,inst_43828,inst_43829,inst_43867);
var state_43919__$1 = state_43919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43919__$1,(22),inst_43872);
} else {
if((state_val_43920 === (27))){
var inst_43903 = (state_43919[(12)]);
var inst_43908 = (state_43919[(13)]);
var inst_43906 = (state_43919[(2)]);
var inst_43907 = fluree.db.util.async.throw_err(inst_43906);
var inst_43908__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43903,cljs.core.cst$kw$schema,inst_43907);
var inst_43909 = fluree.db.query.schema.setting_map(inst_43908__$1);
var state_43919__$1 = (function (){var statearr_43923 = state_43919;
(statearr_43923[(13)] = inst_43908__$1);

return statearr_43923;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43919__$1,(28),inst_43909);
} else {
if((state_val_43920 === (1))){
var state_43919__$1 = state_43919;
var statearr_43924_43970 = state_43919__$1;
(statearr_43924_43970[(2)] = null);

(statearr_43924_43970[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (24))){
var inst_43867 = (state_43919[(8)]);
var inst_43829 = (state_43919[(10)]);
var inst_43828 = (state_43919[(11)]);
var inst_43889 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43867)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43828),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43829),"."].join('');
var inst_43890 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43891 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_43892 = cljs.core.PersistentHashMap.fromArrays(inst_43890,inst_43891);
var inst_43893 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43889,inst_43892);
var inst_43894 = (function(){throw inst_43893})();
var state_43919__$1 = state_43919;
var statearr_43925_43971 = state_43919__$1;
(statearr_43925_43971[(2)] = inst_43894);

(statearr_43925_43971[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (4))){
var inst_43816 = (state_43919[(2)]);
var inst_43817 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_43816);
var state_43919__$1 = state_43919;
var statearr_43926_43972 = state_43919__$1;
(statearr_43926_43972[(2)] = inst_43817);

(statearr_43926_43972[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (15))){
var state_43919__$1 = state_43919;
var statearr_43927_43973 = state_43919__$1;
(statearr_43927_43973[(2)] = null);

(statearr_43927_43973[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (21))){
var inst_43898 = (state_43919[(2)]);
var state_43919__$1 = state_43919;
var statearr_43928_43974 = state_43919__$1;
(statearr_43928_43974[(2)] = inst_43898);

(statearr_43928_43974[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (13))){
var inst_43836 = (state_43919[(7)]);
var inst_43861 = (state_43919[(14)]);
var inst_43860 = (state_43919[(2)]);
var inst_43861__$1 = fluree.db.util.async.throw_err(inst_43860);
var inst_43862 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_43836);
var state_43919__$1 = (function (){var statearr_43929 = state_43919;
(statearr_43929[(15)] = inst_43862);

(statearr_43929[(14)] = inst_43861__$1);

return statearr_43929;
})();
if(cljs.core.truth_(inst_43861__$1)){
var statearr_43930_43975 = state_43919__$1;
(statearr_43930_43975[(1)] = (14));

} else {
var statearr_43931_43976 = state_43919__$1;
(statearr_43931_43976[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (22))){
var inst_43875 = (state_43919[(16)]);
var inst_43874 = (state_43919[(2)]);
var inst_43875__$1 = fluree.db.util.async.throw_err(inst_43874);
var state_43919__$1 = (function (){var statearr_43932 = state_43919;
(statearr_43932[(16)] = inst_43875__$1);

return statearr_43932;
})();
if(cljs.core.truth_(inst_43875__$1)){
var statearr_43933_43977 = state_43919__$1;
(statearr_43933_43977[(1)] = (23));

} else {
var statearr_43934_43978 = state_43919__$1;
(statearr_43934_43978[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (6))){
var inst_43836 = (state_43919[(7)]);
var inst_43835 = (state_43919[(2)]);
var inst_43836__$1 = fluree.db.util.async.throw_err(inst_43835);
var inst_43837 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_43836__$1);
var inst_43838 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_43837);
var inst_43839 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_43838);
var state_43919__$1 = (function (){var statearr_43935 = state_43919;
(statearr_43935[(7)] = inst_43836__$1);

return statearr_43935;
})();
if(inst_43839){
var statearr_43936_43979 = state_43919__$1;
(statearr_43936_43979[(1)] = (7));

} else {
var statearr_43937_43980 = state_43919__$1;
(statearr_43937_43980[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (28))){
var inst_43908 = (state_43919[(13)]);
var inst_43911 = (state_43919[(2)]);
var inst_43912 = fluree.db.util.async.throw_err(inst_43911);
var inst_43913 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43908,cljs.core.cst$kw$settings,inst_43912);
var inst_43914 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_43913);
var _ = (function (){var statearr_43938 = state_43919;
(statearr_43938[(4)] = cljs.core.rest((state_43919[(4)])));

return statearr_43938;
})();
var state_43919__$1 = state_43919;
var statearr_43939_43981 = state_43919__$1;
(statearr_43939_43981[(2)] = inst_43914);

(statearr_43939_43981[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (25))){
var inst_43896 = (state_43919[(2)]);
var state_43919__$1 = state_43919;
var statearr_43940_43982 = state_43919__$1;
(statearr_43940_43982[(2)] = inst_43896);

(statearr_43940_43982[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (17))){
var inst_43867 = (state_43919[(8)]);
var inst_43862 = (state_43919[(15)]);
var inst_43869 = (inst_43867 > inst_43862);
var state_43919__$1 = state_43919;
if(cljs.core.truth_(inst_43869)){
var statearr_43941_43983 = state_43919__$1;
(statearr_43941_43983[(1)] = (19));

} else {
var statearr_43942_43984 = state_43919__$1;
(statearr_43942_43984[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (3))){
var inst_43917 = (state_43919[(2)]);
var state_43919__$1 = state_43919;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43919__$1,inst_43917);
} else {
if((state_val_43920 === (12))){
var inst_43848 = (state_43919[(2)]);
var inst_43849 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43850 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_43851 = cljs.core.PersistentHashMap.fromArrays(inst_43849,inst_43850);
var inst_43852 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43848,inst_43851);
var inst_43853 = (function(){throw inst_43852})();
var state_43919__$1 = state_43919;
var statearr_43943_43985 = state_43919__$1;
(statearr_43943_43985[(2)] = inst_43853);

(statearr_43943_43985[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (2))){
var inst_43827 = (state_43919[(9)]);
var inst_43829 = (state_43919[(10)]);
var inst_43828 = (state_43919[(11)]);
var _ = (function (){var statearr_43944 = state_43919;
(statearr_43944[(4)] = cljs.core.cons((5),(state_43919[(4)])));

return statearr_43944;
})();
var inst_43824 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_43825 = session;
var inst_43826 = cljs.core.__destructure_map(inst_43825);
var inst_43827__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43826,cljs.core.cst$kw$conn);
var inst_43828__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43826,cljs.core.cst$kw$network);
var inst_43829__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43826,cljs.core.cst$kw$dbid);
var inst_43830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43831 = [inst_43828__$1,inst_43829__$1];
var inst_43832 = (new cljs.core.PersistentVector(null,2,(5),inst_43830,inst_43831,null));
var inst_43833 = fluree.db.operations.ledger_info_async(inst_43827__$1,inst_43832);
var state_43919__$1 = (function (){var statearr_43945 = state_43919;
(statearr_43945[(9)] = inst_43827__$1);

(statearr_43945[(10)] = inst_43829__$1);

(statearr_43945[(11)] = inst_43828__$1);

(statearr_43945[(17)] = inst_43824);

return statearr_43945;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43919__$1,(6),inst_43833);
} else {
if((state_val_43920 === (23))){
var inst_43875 = (state_43919[(16)]);
var inst_43866 = (state_43919[(18)]);
var inst_43878 = cljs.core.__destructure_map(inst_43875);
var inst_43879 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43878,cljs.core.cst$kw$flakes);
var inst_43880 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43878,cljs.core.cst$kw$block);
var inst_43881 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43878,cljs.core.cst$kw$t);
var inst_43882 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_43866,inst_43880,inst_43879);
var state_43919__$1 = (function (){var statearr_43946 = state_43919;
(statearr_43946[(19)] = inst_43881);

return statearr_43946;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43919__$1,(26),inst_43882);
} else {
if((state_val_43920 === (19))){
var inst_43866 = (state_43919[(18)]);
var state_43919__$1 = state_43919;
var statearr_43947_43986 = state_43919__$1;
(statearr_43947_43986[(2)] = inst_43866);

(statearr_43947_43986[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (11))){
var inst_43829 = (state_43919[(10)]);
var inst_43828 = (state_43919[(11)]);
var inst_43836 = (state_43919[(7)]);
var inst_43845 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_43836);
var inst_43846 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43828),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43829)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43845),"."].join('');
var state_43919__$1 = state_43919;
var statearr_43949_43987 = state_43919__$1;
(statearr_43949_43987[(2)] = inst_43846);

(statearr_43949_43987[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (9))){
var inst_43827 = (state_43919[(9)]);
var inst_43829 = (state_43919[(10)]);
var inst_43828 = (state_43919[(11)]);
var inst_43824 = (state_43919[(17)]);
var inst_43836 = (state_43919[(7)]);
var inst_43856 = (state_43919[(2)]);
var inst_43857 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_43836);
var inst_43858 = fluree.db.storage.core.reify_db(inst_43827,inst_43828,inst_43829,inst_43824,inst_43857);
var state_43919__$1 = (function (){var statearr_43950 = state_43919;
(statearr_43950[(20)] = inst_43856);

return statearr_43950;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43919__$1,(13),inst_43858);
} else {
if((state_val_43920 === (5))){
var _ = (function (){var statearr_43951 = state_43919;
(statearr_43951[(4)] = cljs.core.rest((state_43919[(4)])));

return statearr_43951;
})();
var state_43919__$1 = state_43919;
var ex43948 = (state_43919__$1[(2)]);
var statearr_43952_43988 = state_43919__$1;
(statearr_43952_43988[(5)] = ex43948);


var statearr_43953_43989 = state_43919__$1;
(statearr_43953_43989[(1)] = (4));

(statearr_43953_43989[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (14))){
var inst_43861 = (state_43919[(14)]);
var inst_43864 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_43861);
var inst_43865 = (inst_43864 + (1));
var inst_43866 = inst_43861;
var inst_43867 = inst_43865;
var state_43919__$1 = (function (){var statearr_43954 = state_43919;
(statearr_43954[(8)] = inst_43867);

(statearr_43954[(18)] = inst_43866);

return statearr_43954;
})();
var statearr_43955_43990 = state_43919__$1;
(statearr_43955_43990[(2)] = null);

(statearr_43955_43990[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (26))){
var inst_43867 = (state_43919[(8)]);
var inst_43884 = (state_43919[(2)]);
var inst_43885 = fluree.db.util.async.throw_err(inst_43884);
var inst_43886 = (inst_43867 + (1));
var inst_43866 = inst_43885;
var inst_43867__$1 = inst_43886;
var state_43919__$1 = (function (){var statearr_43956 = state_43919;
(statearr_43956[(8)] = inst_43867__$1);

(statearr_43956[(18)] = inst_43866);

return statearr_43956;
})();
var statearr_43957_43991 = state_43919__$1;
(statearr_43957_43991[(2)] = null);

(statearr_43957_43991[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (16))){
var inst_43903 = (state_43919[(12)]);
var inst_43903__$1 = (state_43919[(2)]);
var inst_43904 = fluree.db.query.schema.schema_map(inst_43903__$1);
var state_43919__$1 = (function (){var statearr_43958 = state_43919;
(statearr_43958[(12)] = inst_43903__$1);

return statearr_43958;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43919__$1,(27),inst_43904);
} else {
if((state_val_43920 === (10))){
var inst_43829 = (state_43919[(10)]);
var inst_43828 = (state_43919[(11)]);
var inst_43843 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43828),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43829)," is not found on this ledger group."].join('');
var state_43919__$1 = state_43919;
var statearr_43959_43992 = state_43919__$1;
(statearr_43959_43992[(2)] = inst_43843);

(statearr_43959_43992[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (18))){
var inst_43900 = (state_43919[(2)]);
var state_43919__$1 = state_43919;
var statearr_43960_43993 = state_43919__$1;
(statearr_43960_43993[(2)] = inst_43900);

(statearr_43960_43993[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43920 === (8))){
var state_43919__$1 = state_43919;
var statearr_43961_43994 = state_43919__$1;
(statearr_43961_43994[(2)] = null);

(statearr_43961_43994[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__16395__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__16395__auto____0 = (function (){
var statearr_43962 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43962[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__16395__auto__);

(statearr_43962[(1)] = (1));

return statearr_43962;
});
var fluree$db$session$full_load_existing_db_$_state_machine__16395__auto____1 = (function (state_43919){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43919);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43963){var ex__16398__auto__ = e43963;
var statearr_43964_43995 = state_43919;
(statearr_43964_43995[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43919[(4)]))){
var statearr_43965_43996 = state_43919;
(statearr_43965_43996[(1)] = cljs.core.first((state_43919[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43997 = state_43919;
state_43919 = G__43997;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__16395__auto__ = function(state_43919){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__16395__auto____1.call(this,state_43919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__16395__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__16395__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43966 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43966[(6)] = c__16469__auto___43967);

return statearr_43966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,cljs.core.cst$kw$db_SLASH_indexing,pc);
} else {
return s;
}
}));
var res_pc = cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__43998 = cljs.core.get_global_hierarchy;
return (fexpr__43998.cljs$core$IFn$_invoke$arity$0 ? fexpr__43998.cljs$core$IFn$_invoke$arity$0() : fexpr__43998.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_ledger_DASH_update,(function (_,___$1,___$2){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_44000){
var state_val_44001 = (state_44000[(1)]);
if((state_val_44001 === (1))){
var state_44000__$1 = state_44000;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44000__$1,cljs.core.cst$kw$fluree$db$session_SLASH_no_DASH_op);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__16395__auto__ = null;
var fluree$db$session$state_machine__16395__auto____0 = (function (){
var statearr_44002 = [null,null,null,null,null,null,null];
(statearr_44002[(0)] = fluree$db$session$state_machine__16395__auto__);

(statearr_44002[(1)] = (1));

return statearr_44002;
});
var fluree$db$session$state_machine__16395__auto____1 = (function (state_44000){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_44000);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e44003){var ex__16398__auto__ = e44003;
var statearr_44004_44007 = state_44000;
(statearr_44004_44007[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_44000[(4)]))){
var statearr_44005_44008 = state_44000;
(statearr_44005_44008[(1)] = cljs.core.first((state_44000[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__44009 = state_44000;
state_44000 = G__44009;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$session$state_machine__16395__auto__ = function(state_44000){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16395__auto____1.call(this,state_44000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16395__auto____0;
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16395__auto____1;
return fluree$db$session$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_44006 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_44006[(6)] = c__16469__auto__);

return statearr_44006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__44011){
var map__44012 = p__44011;
var map__44012__$1 = cljs.core.__destructure_map(map__44012);
var data = map__44012__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44012__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44012__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44012__$1,cljs.core.cst$kw$flakes);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_44071){
var state_val_44072 = (state_44071[(1)]);
if((state_val_44072 === (7))){
var inst_44023 = (state_44071[(7)]);
var inst_44026 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_44027 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_44028 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44026),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44027),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44023),". No-op."].join('');
var inst_44029 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44028], 0));
var state_44071__$1 = state_44071;
var statearr_44073_44111 = state_44071__$1;
(statearr_44073_44111[(2)] = inst_44029);

(statearr_44073_44111[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (1))){
var state_44071__$1 = state_44071;
var statearr_44074_44112 = state_44071__$1;
(statearr_44074_44112[(2)] = null);

(statearr_44074_44112[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (4))){
var inst_44013 = (state_44071[(2)]);
var state_44071__$1 = state_44071;
var statearr_44075_44113 = state_44071__$1;
(statearr_44075_44113[(2)] = inst_44013);

(statearr_44075_44113[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (15))){
var inst_44052 = (state_44071[(2)]);
var state_44071__$1 = state_44071;
var statearr_44076_44114 = state_44071__$1;
(statearr_44076_44114[(2)] = inst_44052);

(statearr_44076_44114[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (13))){
var inst_44043 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var inst_44044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44045 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_44046 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_44047 = [inst_44045,inst_44046];
var inst_44048 = (new cljs.core.PersistentVector(null,2,(5),inst_44044,inst_44047,null));
var inst_44049 = (function (){var G__44077 = inst_44043;
var G__44078 = cljs.core.cst$kw$local_DASH_ledger_DASH_update;
var G__44079 = inst_44048;
var G__44080 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__44077,G__44078,G__44079,G__44080) : fluree.db.conn_events.process_event.call(null,G__44077,G__44078,G__44079,G__44080));
})();
var state_44071__$1 = state_44071;
var statearr_44081_44115 = state_44071__$1;
(statearr_44081_44115[(2)] = inst_44049);

(statearr_44081_44115[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (6))){
var inst_44023 = (state_44071[(7)]);
var inst_44022 = (state_44071[(8)]);
var inst_44021 = (state_44071[(2)]);
var inst_44022__$1 = fluree.db.util.async.throw_err(inst_44021);
var inst_44023__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_44022__$1);
var inst_44024 = (block <= inst_44023__$1);
var state_44071__$1 = (function (){var statearr_44082 = state_44071;
(statearr_44082[(7)] = inst_44023__$1);

(statearr_44082[(8)] = inst_44022__$1);

return statearr_44082;
})();
if(cljs.core.truth_(inst_44024)){
var statearr_44083_44116 = state_44071__$1;
(statearr_44083_44116[(1)] = (7));

} else {
var statearr_44084_44117 = state_44071__$1;
(statearr_44084_44117[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (17))){
var state_44071__$1 = state_44071;
var statearr_44085_44118 = state_44071__$1;
(statearr_44085_44118[(2)] = null);

(statearr_44085_44118[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (3))){
var inst_44069 = (state_44071[(2)]);
var state_44071__$1 = state_44071;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44071__$1,inst_44069);
} else {
if((state_val_44072 === (12))){
var inst_44064 = (state_44071[(2)]);
var state_44071__$1 = state_44071;
var statearr_44086_44119 = state_44071__$1;
(statearr_44086_44119[(2)] = inst_44064);

(statearr_44086_44119[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (2))){
var inst_44019 = (state_44071[(9)]);
var _ = (function (){var statearr_44087 = state_44071;
(statearr_44087[(4)] = cljs.core.cons((5),(state_44071[(4)])));

return statearr_44087;
})();
var inst_44019__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_44071__$1 = (function (){var statearr_44088 = state_44071;
(statearr_44088[(9)] = inst_44019__$1);

return statearr_44088;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44071__$1,(6),inst_44019__$1);
} else {
if((state_val_44072 === (11))){
var state_44071__$1 = state_44071;
var statearr_44090_44120 = state_44071__$1;
(statearr_44090_44120[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (9))){
var inst_44066 = (state_44071[(2)]);
var _ = (function (){var statearr_44092 = state_44071;
(statearr_44092[(4)] = cljs.core.rest((state_44071[(4)])));

return statearr_44092;
})();
var state_44071__$1 = state_44071;
var statearr_44093_44121 = state_44071__$1;
(statearr_44093_44121[(2)] = inst_44066);

(statearr_44093_44121[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (5))){
var _ = (function (){var statearr_44094 = state_44071;
(statearr_44094[(4)] = cljs.core.rest((state_44071[(4)])));

return statearr_44094;
})();
var state_44071__$1 = state_44071;
var ex44089 = (state_44071__$1[(2)]);
var statearr_44095_44122 = state_44071__$1;
(statearr_44095_44122[(5)] = ex44089);


if((ex44089 instanceof Error)){
var statearr_44096_44123 = state_44071__$1;
(statearr_44096_44123[(1)] = (4));

(statearr_44096_44123[(5)] = null);

} else {
throw ex44089;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (14))){
var state_44071__$1 = state_44071;
var statearr_44097_44124 = state_44071__$1;
(statearr_44097_44124[(2)] = null);

(statearr_44097_44124[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (16))){
var inst_44023 = (state_44071[(7)]);
var inst_44055 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_44056 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_44057 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44055),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44056),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44023),". Forcing a db reload."].join('');
var inst_44058 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44057], 0));
var inst_44059 = fluree.db.session.reload_db_BANG_(session);
var state_44071__$1 = (function (){var statearr_44098 = state_44071;
(statearr_44098[(10)] = inst_44058);

return statearr_44098;
})();
var statearr_44099_44125 = state_44071__$1;
(statearr_44099_44125[(2)] = inst_44059);

(statearr_44099_44125[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (10))){
var inst_44019 = (state_44071[(9)]);
var inst_44023 = (state_44071[(7)]);
var inst_44022 = (state_44071[(8)]);
var inst_44034 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_44035 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_44036 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44034),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44035),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_44037 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44036], 0));
var inst_44038 = (function (){var current_db_ch = inst_44019;
var current_db = inst_44022;
var current_block = inst_44023;
return (function (p1__44010_SHARP_){
if((p1__44010_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__44010_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__44010_SHARP_);
}
});
})();
var inst_44039 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_44038,flakes);
var inst_44040 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_44022,block,inst_44039);
var inst_44041 = fluree.db.session.cas_db_BANG_(session,inst_44019,inst_44040);
var state_44071__$1 = (function (){var statearr_44100 = state_44071;
(statearr_44100[(11)] = inst_44037);

return statearr_44100;
})();
if(inst_44041){
var statearr_44101_44126 = state_44071__$1;
(statearr_44101_44126[(1)] = (13));

} else {
var statearr_44102_44127 = state_44071__$1;
(statearr_44102_44127[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (18))){
var inst_44062 = (state_44071[(2)]);
var state_44071__$1 = state_44071;
var statearr_44103_44128 = state_44071__$1;
(statearr_44103_44128[(2)] = inst_44062);

(statearr_44103_44128[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44072 === (8))){
var inst_44023 = (state_44071[(7)]);
var inst_44031 = ((1) + inst_44023);
var inst_44032 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_44031);
var state_44071__$1 = state_44071;
if(inst_44032){
var statearr_44104_44129 = state_44071__$1;
(statearr_44104_44129[(1)] = (10));

} else {
var statearr_44105_44130 = state_44071__$1;
(statearr_44105_44130[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__16395__auto__ = null;
var fluree$db$session$state_machine__16395__auto____0 = (function (){
var statearr_44106 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44106[(0)] = fluree$db$session$state_machine__16395__auto__);

(statearr_44106[(1)] = (1));

return statearr_44106;
});
var fluree$db$session$state_machine__16395__auto____1 = (function (state_44071){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_44071);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e44107){var ex__16398__auto__ = e44107;
var statearr_44108_44131 = state_44071;
(statearr_44108_44131[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_44071[(4)]))){
var statearr_44109_44132 = state_44071;
(statearr_44109_44132[(1)] = cljs.core.first((state_44071[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__44133 = state_44071;
state_44071 = G__44133;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$session$state_machine__16395__auto__ = function(state_44071){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16395__auto____1.call(this,state_44071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16395__auto____0;
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16395__auto____1;
return fluree$db$session$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_44110 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_44110[(6)] = c__16469__auto__);

return statearr_44110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_44140){
var state_val_44141 = (state_44140[(1)]);
if((state_val_44141 === (1))){
var inst_44134 = fluree.db.session.clear_db_BANG_(session);
var inst_44135 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_44136 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_44137 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44135),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_44136)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_44138 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44137], 0));
var state_44140__$1 = (function (){var statearr_44142 = state_44140;
(statearr_44142[(7)] = inst_44138);

(statearr_44142[(8)] = inst_44134);

return statearr_44142;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44140__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__16395__auto__ = null;
var fluree$db$session$state_machine__16395__auto____0 = (function (){
var statearr_44143 = [null,null,null,null,null,null,null,null,null];
(statearr_44143[(0)] = fluree$db$session$state_machine__16395__auto__);

(statearr_44143[(1)] = (1));

return statearr_44143;
});
var fluree$db$session$state_machine__16395__auto____1 = (function (state_44140){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_44140);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e44144){var ex__16398__auto__ = e44144;
var statearr_44145_44148 = state_44140;
(statearr_44145_44148[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_44140[(4)]))){
var statearr_44146_44149 = state_44140;
(statearr_44146_44149[(1)] = cljs.core.first((state_44140[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__44150 = state_44140;
state_44140 = G__44150;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$session$state_machine__16395__auto__ = function(state_44140){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16395__auto____1.call(this,state_44140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16395__auto____0;
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16395__auto____1;
return fluree$db$session$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_44147 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_44147[(6)] = c__16469__auto__);

return statearr_44147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__44152 = arguments.length;
switch (G__44152) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__44153 = session;
var map__44153__$1 = cljs.core.__destructure_map(map__44153);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44153__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44153__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44153__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44153__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44153__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44153__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44153__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__44154_44157 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__44154_44157.cljs$core$IFn$_invoke$arity$3 ? fexpr__44154_44157.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__44154_44157.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__44155_44158 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__44155_44158.cljs$core$IFn$_invoke$arity$0 ? fexpr__44155_44158.cljs$core$IFn$_invoke$arity$0() : fexpr__44155_44158.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_44211){
var state_val_44212 = (state_44211[(1)]);
if((state_val_44212 === (7))){
var inst_44207 = (state_44211[(2)]);
var state_44211__$1 = state_44211;
var statearr_44213_44244 = state_44211__$1;
(statearr_44213_44244[(2)] = inst_44207);

(statearr_44213_44244[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (1))){
var state_44211__$1 = state_44211;
var statearr_44214_44245 = state_44211__$1;
(statearr_44214_44245[(2)] = null);

(statearr_44214_44245[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (4))){
var inst_44162 = (state_44211[(7)]);
var inst_44161 = (state_44211[(2)]);
var inst_44162__$1 = fluree.db.util.async.throw_err(inst_44161);
var inst_44163 = fluree.db.session.from_cache(network,ledger_id);
var inst_44164 = (inst_44162__$1 == null);
var state_44211__$1 = (function (){var statearr_44215 = state_44211;
(statearr_44215[(8)] = inst_44163);

(statearr_44215[(7)] = inst_44162__$1);

return statearr_44215;
})();
if(cljs.core.truth_(inst_44164)){
var statearr_44216_44246 = state_44211__$1;
(statearr_44216_44246[(1)] = (5));

} else {
var statearr_44217_44247 = state_44211__$1;
(statearr_44217_44247[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (15))){
var inst_44199 = (state_44211[(2)]);
var state_44211__$1 = (function (){var statearr_44218 = state_44211;
(statearr_44218[(9)] = inst_44199);

return statearr_44218;
})();
var statearr_44219_44248 = state_44211__$1;
(statearr_44219_44248[(2)] = null);

(statearr_44219_44248[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (13))){
var inst_44203 = (state_44211[(2)]);
var state_44211__$1 = state_44211;
var statearr_44221_44249 = state_44211__$1;
(statearr_44221_44249[(2)] = inst_44203);

(statearr_44221_44249[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (6))){
var inst_44163 = (state_44211[(8)]);
var inst_44169 = (inst_44163 == null);
var state_44211__$1 = state_44211;
if(cljs.core.truth_(inst_44169)){
var statearr_44222_44250 = state_44211__$1;
(statearr_44222_44250[(1)] = (8));

} else {
var statearr_44223_44251 = state_44211__$1;
(statearr_44223_44251[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (17))){
var _ = (function (){var statearr_44224 = state_44211;
(statearr_44224[(4)] = cljs.core.rest((state_44211[(4)])));

return statearr_44224;
})();
var state_44211__$1 = state_44211;
var ex44220 = (state_44211__$1[(2)]);
var statearr_44225_44252 = state_44211__$1;
(statearr_44225_44252[(5)] = ex44220);


var statearr_44226_44253 = state_44211__$1;
(statearr_44226_44253[(1)] = (16));

(statearr_44226_44253[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (3))){
var inst_44209 = (state_44211[(2)]);
var state_44211__$1 = state_44211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44211__$1,inst_44209);
} else {
if((state_val_44212 === (12))){
var state_44211__$1 = state_44211;
var statearr_44227_44254 = state_44211__$1;
(statearr_44227_44254[(2)] = null);

(statearr_44227_44254[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (2))){
var state_44211__$1 = state_44211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44211__$1,(4),update_chan);
} else {
if((state_val_44212 === (11))){
var state_44211__$1 = state_44211;
var statearr_44228_44255 = state_44211__$1;
(statearr_44228_44255[(2)] = null);

(statearr_44228_44255[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (9))){
var state_44211__$1 = state_44211;
var statearr_44229_44256 = state_44211__$1;
(statearr_44229_44256[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (5))){
var inst_44166 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_44167 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44166], 0));
var state_44211__$1 = state_44211;
var statearr_44231_44257 = state_44211__$1;
(statearr_44231_44257[(2)] = inst_44167);

(statearr_44231_44257[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (14))){
var inst_44163 = (state_44211[(8)]);
var inst_44162 = (state_44211[(7)]);
var _ = (function (){var statearr_44232 = state_44211;
(statearr_44232[(4)] = cljs.core.cons((17),(state_44211[(4)])));

return statearr_44232;
})();
var inst_44187 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44162,(0),null);
var inst_44188 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44162,(1),null);
var inst_44189 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_44190 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44162], 0));
var inst_44191 = fluree.db.util.core.trunc(inst_44190,(200));
var inst_44192 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44189,inst_44191], 0));
var inst_44193 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_44163,inst_44187,inst_44188) : fluree.db.session.process_ledger_update.call(null,inst_44163,inst_44187,inst_44188));
var state_44211__$1 = (function (){var statearr_44233 = state_44211;
(statearr_44233[(10)] = inst_44192);

return statearr_44233;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44211__$1,(18),inst_44193);
} else {
if((state_val_44212 === (16))){
var inst_44162 = (state_44211[(7)]);
var inst_44177 = (state_44211[(2)]);
var inst_44178 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44177,"Exception processing ledger updates for message: ",inst_44162], 0));
var state_44211__$1 = state_44211;
var statearr_44234_44258 = state_44211__$1;
(statearr_44234_44258[(2)] = inst_44178);

(statearr_44234_44258[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (10))){
var inst_44205 = (state_44211[(2)]);
var state_44211__$1 = state_44211;
var statearr_44235_44259 = state_44211__$1;
(statearr_44235_44259[(2)] = inst_44205);

(statearr_44235_44259[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (18))){
var inst_44195 = (state_44211[(2)]);
var inst_44196 = fluree.db.util.async.throw_err(inst_44195);
var _ = (function (){var statearr_44236 = state_44211;
(statearr_44236[(4)] = cljs.core.rest((state_44211[(4)])));

return statearr_44236;
})();
var state_44211__$1 = state_44211;
var statearr_44237_44260 = state_44211__$1;
(statearr_44237_44260[(2)] = inst_44196);

(statearr_44237_44260[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (8))){
var inst_44162 = (state_44211[(7)]);
var inst_44171 = cljs.core.first(inst_44162);
var inst_44172 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44171], 0));
var inst_44173 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_44172].join('');
var inst_44174 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44173], 0));
var state_44211__$1 = state_44211;
var statearr_44238_44261 = state_44211__$1;
(statearr_44238_44261[(2)] = inst_44174);

(statearr_44238_44261[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__16395__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__16395__auto____0 = (function (){
var statearr_44239 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44239[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__16395__auto__);

(statearr_44239[(1)] = (1));

return statearr_44239;
});
var fluree$db$session$process_ledger_updates_$_state_machine__16395__auto____1 = (function (state_44211){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_44211);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e44240){var ex__16398__auto__ = e44240;
var statearr_44241_44262 = state_44211;
(statearr_44241_44262[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_44211[(4)]))){
var statearr_44242_44263 = state_44211;
(statearr_44242_44263[(1)] = cljs.core.first((state_44211[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__44264 = state_44211;
state_44211 = G__44264;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__16395__auto__ = function(state_44211){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__16395__auto____1.call(this,state_44211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__16395__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__16395__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_44243 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_44243[(6)] = c__16469__auto__);

return statearr_44243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__44265){
var map__44266 = p__44265;
var map__44266__$1 = cljs.core.__destructure_map(map__44266);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44266__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44266__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44266__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44266__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44266__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44266__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44266__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44266__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44266__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__44270 = block_result;
var map__44270__$1 = cljs.core.__destructure_map(map__44270);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44270__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44270__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44270__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44270__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44270__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__44271 = tx_result;
var map__44271__$1 = cljs.core.__destructure_map(map__44271);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44271__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44271__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__44267_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__44267_SHARP_.t);
}):(function (p1__44268_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__44268_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__44269_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__44269_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__44269_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__44272 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44272,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44272,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44272,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44272,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__44276 = arguments.length;
switch (G__44276) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__44277){
var map__44278 = p__44277;
var map__44278__$1 = cljs.core.__destructure_map(map__44278);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44278__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44278__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44278__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44278__$1,cljs.core.cst$kw$jwt);
var vec__44279 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44279,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44279,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44279,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4212__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4212__auto____$1 = state;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__44283_44403 = network;
var G__44284_44404 = ledger_id;
var G__44285_44405 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__44286_44406 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__44287 = cljs.core.seq(tids);
var chunk__44288 = null;
var count__44289 = (0);
var i__44290 = (0);
while(true){
if((i__44290 < count__44289)){
var tid = chunk__44288.cljs$core$IIndexed$_nth$arity$2(null,i__44290);
var temp__5753__auto___44408__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___44408__$1)){
var keyed_callbacks_44409 = temp__5753__auto___44408__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_44410 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__44331_44411 = cljs.core.seq(keyed_callbacks_44409);
var chunk__44332_44412 = null;
var count__44333_44413 = (0);
var i__44334_44414 = (0);
while(true){
if((i__44334_44414 < count__44333_44413)){
var vec__44343_44415 = chunk__44332_44412.cljs$core$IIndexed$_nth$arity$2(null,i__44334_44414);
var k_44416 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44343_44415,(0),null);
var f_44417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44343_44415,(1),null);
try{(f_44417.cljs$core$IFn$_invoke$arity$1 ? f_44417.cljs$core$IFn$_invoke$arity$1(tx_response_44410) : f_44417.call(null,tx_response_44410));
}catch (e44346){var e_44418 = e44346;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_44418,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__44419 = seq__44331_44411;
var G__44420 = chunk__44332_44412;
var G__44421 = count__44333_44413;
var G__44422 = (i__44334_44414 + (1));
seq__44331_44411 = G__44419;
chunk__44332_44412 = G__44420;
count__44333_44413 = G__44421;
i__44334_44414 = G__44422;
continue;
} else {
var temp__5753__auto___44423__$2 = cljs.core.seq(seq__44331_44411);
if(temp__5753__auto___44423__$2){
var seq__44331_44424__$1 = temp__5753__auto___44423__$2;
if(cljs.core.chunked_seq_QMARK_(seq__44331_44424__$1)){
var c__4638__auto___44425 = cljs.core.chunk_first(seq__44331_44424__$1);
var G__44426 = cljs.core.chunk_rest(seq__44331_44424__$1);
var G__44427 = c__4638__auto___44425;
var G__44428 = cljs.core.count(c__4638__auto___44425);
var G__44429 = (0);
seq__44331_44411 = G__44426;
chunk__44332_44412 = G__44427;
count__44333_44413 = G__44428;
i__44334_44414 = G__44429;
continue;
} else {
var vec__44347_44430 = cljs.core.first(seq__44331_44424__$1);
var k_44431 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44347_44430,(0),null);
var f_44432 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44347_44430,(1),null);
try{(f_44432.cljs$core$IFn$_invoke$arity$1 ? f_44432.cljs$core$IFn$_invoke$arity$1(tx_response_44410) : f_44432.call(null,tx_response_44410));
}catch (e44350){var e_44433 = e44350;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_44433,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__44434 = cljs.core.next(seq__44331_44424__$1);
var G__44435 = null;
var G__44436 = (0);
var G__44437 = (0);
seq__44331_44411 = G__44434;
chunk__44332_44412 = G__44435;
count__44333_44413 = G__44436;
i__44334_44414 = G__44437;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__44438 = seq__44287;
var G__44439 = chunk__44288;
var G__44440 = count__44289;
var G__44441 = (i__44290 + (1));
seq__44287 = G__44438;
chunk__44288 = G__44439;
count__44289 = G__44440;
i__44290 = G__44441;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__44287);
if(temp__5753__auto____$1){
var seq__44287__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__44287__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__44287__$1);
var G__44442 = cljs.core.chunk_rest(seq__44287__$1);
var G__44443 = c__4638__auto__;
var G__44444 = cljs.core.count(c__4638__auto__);
var G__44445 = (0);
seq__44287 = G__44442;
chunk__44288 = G__44443;
count__44289 = G__44444;
i__44290 = G__44445;
continue;
} else {
var tid = cljs.core.first(seq__44287__$1);
var temp__5753__auto___44446__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___44446__$2)){
var keyed_callbacks_44447 = temp__5753__auto___44446__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_44448 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__44351_44449 = cljs.core.seq(keyed_callbacks_44447);
var chunk__44352_44450 = null;
var count__44353_44451 = (0);
var i__44354_44452 = (0);
while(true){
if((i__44354_44452 < count__44353_44451)){
var vec__44363_44453 = chunk__44352_44450.cljs$core$IIndexed$_nth$arity$2(null,i__44354_44452);
var k_44454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44363_44453,(0),null);
var f_44455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44363_44453,(1),null);
try{(f_44455.cljs$core$IFn$_invoke$arity$1 ? f_44455.cljs$core$IFn$_invoke$arity$1(tx_response_44448) : f_44455.call(null,tx_response_44448));
}catch (e44366){var e_44456 = e44366;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_44456,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__44457 = seq__44351_44449;
var G__44458 = chunk__44352_44450;
var G__44459 = count__44353_44451;
var G__44460 = (i__44354_44452 + (1));
seq__44351_44449 = G__44457;
chunk__44352_44450 = G__44458;
count__44353_44451 = G__44459;
i__44354_44452 = G__44460;
continue;
} else {
var temp__5753__auto___44461__$3 = cljs.core.seq(seq__44351_44449);
if(temp__5753__auto___44461__$3){
var seq__44351_44462__$1 = temp__5753__auto___44461__$3;
if(cljs.core.chunked_seq_QMARK_(seq__44351_44462__$1)){
var c__4638__auto___44463 = cljs.core.chunk_first(seq__44351_44462__$1);
var G__44464 = cljs.core.chunk_rest(seq__44351_44462__$1);
var G__44465 = c__4638__auto___44463;
var G__44466 = cljs.core.count(c__4638__auto___44463);
var G__44467 = (0);
seq__44351_44449 = G__44464;
chunk__44352_44450 = G__44465;
count__44353_44451 = G__44466;
i__44354_44452 = G__44467;
continue;
} else {
var vec__44367_44468 = cljs.core.first(seq__44351_44462__$1);
var k_44469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44367_44468,(0),null);
var f_44470 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44367_44468,(1),null);
try{(f_44470.cljs$core$IFn$_invoke$arity$1 ? f_44470.cljs$core$IFn$_invoke$arity$1(tx_response_44448) : f_44470.call(null,tx_response_44448));
}catch (e44370){var e_44471 = e44370;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_44471,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__44472 = cljs.core.next(seq__44351_44462__$1);
var G__44473 = null;
var G__44474 = (0);
var G__44475 = (0);
seq__44351_44449 = G__44472;
chunk__44352_44450 = G__44473;
count__44353_44451 = G__44474;
i__44354_44452 = G__44475;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__44476 = cljs.core.next(seq__44287__$1);
var G__44477 = null;
var G__44478 = (0);
var G__44479 = (0);
seq__44287 = G__44476;
chunk__44288 = G__44477;
count__44289 = G__44478;
i__44290 = G__44479;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__44282_44407 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__44282_44407.cljs$core$IFn$_invoke$arity$4 ? fexpr__44282_44407.cljs$core$IFn$_invoke$arity$4(G__44283_44403,G__44284_44404,G__44285_44405,G__44286_44406) : fexpr__44282_44407.call(null,G__44283_44403,G__44284_44404,G__44285_44405,G__44286_44406));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_44480 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__16469__auto___44481 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_44387){
var state_val_44388 = (state_44387[(1)]);
if((state_val_44388 === (1))){
var state_44387__$1 = state_44387;
var statearr_44389_44482 = state_44387__$1;
(statearr_44389_44482[(2)] = null);

(statearr_44389_44482[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44388 === (2))){
var inst_44372 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_44387__$1 = state_44387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44387__$1,(4),inst_44372);
} else {
if((state_val_44388 === (3))){
var inst_44385 = (state_44387[(2)]);
var state_44387__$1 = state_44387;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44387__$1,inst_44385);
} else {
if((state_val_44388 === (4))){
var inst_44374 = (state_44387[(7)]);
var inst_44374__$1 = (state_44387[(2)]);
var inst_44375 = (inst_44374__$1 == null);
var state_44387__$1 = (function (){var statearr_44390 = state_44387;
(statearr_44390[(7)] = inst_44374__$1);

return statearr_44390;
})();
if(cljs.core.truth_(inst_44375)){
var statearr_44391_44483 = state_44387__$1;
(statearr_44391_44483[(1)] = (5));

} else {
var statearr_44392_44484 = state_44387__$1;
(statearr_44392_44484[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44388 === (5))){
var inst_44377 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_44378 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44377], 0));
var state_44387__$1 = state_44387;
var statearr_44393_44485 = state_44387__$1;
(statearr_44393_44485[(2)] = inst_44378);

(statearr_44393_44485[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44388 === (6))){
var inst_44374 = (state_44387[(7)]);
var inst_44380 = (transact_handler_44480.cljs$core$IFn$_invoke$arity$2 ? transact_handler_44480.cljs$core$IFn$_invoke$arity$2(conn,inst_44374) : transact_handler_44480.call(null,conn,inst_44374));
var state_44387__$1 = (function (){var statearr_44394 = state_44387;
(statearr_44394[(8)] = inst_44380);

return statearr_44394;
})();
var statearr_44395_44486 = state_44387__$1;
(statearr_44395_44486[(2)] = null);

(statearr_44395_44486[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44388 === (7))){
var inst_44383 = (state_44387[(2)]);
var state_44387__$1 = state_44387;
var statearr_44396_44487 = state_44387__$1;
(statearr_44396_44487[(2)] = inst_44383);

(statearr_44396_44487[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__16395__auto__ = null;
var fluree$db$session$state_machine__16395__auto____0 = (function (){
var statearr_44397 = [null,null,null,null,null,null,null,null,null];
(statearr_44397[(0)] = fluree$db$session$state_machine__16395__auto__);

(statearr_44397[(1)] = (1));

return statearr_44397;
});
var fluree$db$session$state_machine__16395__auto____1 = (function (state_44387){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_44387);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e44398){var ex__16398__auto__ = e44398;
var statearr_44399_44488 = state_44387;
(statearr_44399_44488[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_44387[(4)]))){
var statearr_44400_44489 = state_44387;
(statearr_44400_44489[(1)] = cljs.core.first((state_44387[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__44490 = state_44387;
state_44387 = G__44490;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$session$state_machine__16395__auto__ = function(state_44387){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16395__auto____1.call(this,state_44387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16395__auto____0;
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16395__auto____1;
return fluree$db$session$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_44401 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_44401[(6)] = c__16469__auto___44481);

return statearr_44401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__44491_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__44491_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__44491_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__44492_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__44492_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
}));

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__44495 = arguments.length;
switch (G__44495) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__44496 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__44493_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__44493_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__44496);
} else {
return G__44496;
}
})();
var seq__44497 = cljs.core.seq(sessions);
var chunk__44498 = null;
var count__44499 = (0);
var i__44500 = (0);
while(true){
if((i__44500 < count__44499)){
var session = chunk__44498.cljs$core$IIndexed$_nth$arity$2(null,i__44500);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__44502 = seq__44497;
var G__44503 = chunk__44498;
var G__44504 = count__44499;
var G__44505 = (i__44500 + (1));
seq__44497 = G__44502;
chunk__44498 = G__44503;
count__44499 = G__44504;
i__44500 = G__44505;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__44497);
if(temp__5753__auto__){
var seq__44497__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44497__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__44497__$1);
var G__44506 = cljs.core.chunk_rest(seq__44497__$1);
var G__44507 = c__4638__auto__;
var G__44508 = cljs.core.count(c__4638__auto__);
var G__44509 = (0);
seq__44497 = G__44506;
chunk__44498 = G__44507;
count__44499 = G__44508;
i__44500 = G__44509;
continue;
} else {
var session = cljs.core.first(seq__44497__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__44510 = cljs.core.next(seq__44497__$1);
var G__44511 = null;
var G__44512 = (0);
var G__44513 = (0);
seq__44497 = G__44510;
chunk__44498 = G__44511;
count__44499 = G__44512;
i__44500 = G__44513;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
