// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_31507){
var state_val_31508 = (state_31507[(1)]);
if((state_val_31508 === (1))){
var state_31507__$1 = state_31507;
var statearr_31509_31523 = state_31507__$1;
(statearr_31509_31523[(2)] = null);

(statearr_31509_31523[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31508 === (2))){
var _ = (function (){var statearr_31510 = state_31507;
(statearr_31510[(4)] = cljs.core.cons((5),(state_31507[(4)])));

return statearr_31510;
})();
var inst_31498 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_31507__$1 = state_31507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31507__$1,(6),inst_31498);
} else {
if((state_val_31508 === (3))){
var inst_31505 = (state_31507[(2)]);
var state_31507__$1 = state_31507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31507__$1,inst_31505);
} else {
if((state_val_31508 === (4))){
var inst_31492 = (state_31507[(2)]);
var state_31507__$1 = state_31507;
var statearr_31512_31524 = state_31507__$1;
(statearr_31512_31524[(2)] = inst_31492);

(statearr_31512_31524[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31508 === (5))){
var _ = (function (){var statearr_31513 = state_31507;
(statearr_31513[(4)] = cljs.core.rest((state_31507[(4)])));

return statearr_31513;
})();
var state_31507__$1 = state_31507;
var ex31511 = (state_31507__$1[(2)]);
var statearr_31514_31525 = state_31507__$1;
(statearr_31514_31525[(5)] = ex31511);


if((ex31511 instanceof Error)){
var statearr_31515_31526 = state_31507__$1;
(statearr_31515_31526[(1)] = (4));

(statearr_31515_31526[(5)] = null);

} else {
throw ex31511;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31508 === (6))){
var inst_31500 = (state_31507[(2)]);
var inst_31501 = fluree.db.util.async.throw_err(inst_31500);
var inst_31502 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_31501);
var _ = (function (){var statearr_31516 = state_31507;
(statearr_31516[(4)] = cljs.core.rest((state_31507[(4)])));

return statearr_31516;
})();
var state_31507__$1 = state_31507;
var statearr_31517_31527 = state_31507__$1;
(statearr_31517_31527[(2)] = inst_31502);

(statearr_31517_31527[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto____0 = (function (){
var statearr_31518 = [null,null,null,null,null,null,null];
(statearr_31518[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto__);

(statearr_31518[(1)] = (1));

return statearr_31518;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto____1 = (function (state_31507){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_31507);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e31519){var ex__16398__auto__ = e31519;
var statearr_31520_31528 = state_31507;
(statearr_31520_31528[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_31507[(4)]))){
var statearr_31521_31529 = state_31507;
(statearr_31521_31529[(1)] = cljs.core.first((state_31507[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__31530 = state_31507;
state_31507 = G__31530;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto__ = function(state_31507){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto____1.call(this,state_31507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_31522 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_31522[(6)] = c__16469__auto__);

return statearr_31522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_31562){
var state_val_31563 = (state_31562[(1)]);
if((state_val_31563 === (7))){
var inst_31546 = (state_31562[(7)]);
var inst_31548 = cljs.core.empty_QMARK_(inst_31546);
var inst_31549 = (!(inst_31548));
var state_31562__$1 = state_31562;
var statearr_31564_31588 = state_31562__$1;
(statearr_31564_31588[(2)] = inst_31549);

(statearr_31564_31588[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31563 === (1))){
var state_31562__$1 = state_31562;
var statearr_31565_31589 = state_31562__$1;
(statearr_31565_31589[(2)] = null);

(statearr_31565_31589[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31563 === (4))){
var inst_31532 = (state_31562[(2)]);
var state_31562__$1 = state_31562;
var statearr_31566_31590 = state_31562__$1;
(statearr_31566_31590[(2)] = inst_31532);

(statearr_31566_31590[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31563 === (6))){
var inst_31546 = (state_31562[(7)]);
var inst_31538 = (state_31562[(8)]);
var inst_31544 = (state_31562[(2)]);
var inst_31545 = fluree.db.util.async.throw_err(inst_31544);
var inst_31546__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_31538,inst_31545);
var state_31562__$1 = (function (){var statearr_31567 = state_31562;
(statearr_31567[(7)] = inst_31546__$1);

return statearr_31567;
})();
if(cljs.core.truth_(inst_31546__$1)){
var statearr_31568_31591 = state_31562__$1;
(statearr_31568_31591[(1)] = (7));

} else {
var statearr_31569_31592 = state_31562__$1;
(statearr_31569_31592[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31563 === (3))){
var inst_31560 = (state_31562[(2)]);
var state_31562__$1 = state_31562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31562__$1,inst_31560);
} else {
if((state_val_31563 === (12))){
var inst_31557 = (state_31562[(2)]);
var _ = (function (){var statearr_31570 = state_31562;
(statearr_31570[(4)] = cljs.core.rest((state_31562[(4)])));

return statearr_31570;
})();
var state_31562__$1 = state_31562;
var statearr_31571_31593 = state_31562__$1;
(statearr_31571_31593[(2)] = inst_31557);

(statearr_31571_31593[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31563 === (2))){
var _ = (function (){var statearr_31572 = state_31562;
(statearr_31572[(4)] = cljs.core.cons((5),(state_31562[(4)])));

return statearr_31572;
})();
var inst_31538 = (function (){return (function (p1__31531_SHARP_){
return p1__31531_SHARP_.o;
});
})();
var inst_31539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31540 = [pred_id];
var inst_31541 = (new cljs.core.PersistentVector(null,1,(5),inst_31539,inst_31540,null));
var inst_31542 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_31541);
var state_31562__$1 = (function (){var statearr_31573 = state_31562;
(statearr_31573[(8)] = inst_31538);

return statearr_31573;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31562__$1,(6),inst_31542);
} else {
if((state_val_31563 === (11))){
var state_31562__$1 = state_31562;
var statearr_31575_31594 = state_31562__$1;
(statearr_31575_31594[(2)] = true);

(statearr_31575_31594[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31563 === (9))){
var inst_31552 = (state_31562[(2)]);
var state_31562__$1 = state_31562;
if(cljs.core.truth_(inst_31552)){
var statearr_31576_31595 = state_31562__$1;
(statearr_31576_31595[(1)] = (10));

} else {
var statearr_31577_31596 = state_31562__$1;
(statearr_31577_31596[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31563 === (5))){
var _ = (function (){var statearr_31578 = state_31562;
(statearr_31578[(4)] = cljs.core.rest((state_31562[(4)])));

return statearr_31578;
})();
var state_31562__$1 = state_31562;
var ex31574 = (state_31562__$1[(2)]);
var statearr_31579_31597 = state_31562__$1;
(statearr_31579_31597[(5)] = ex31574);


if((ex31574 instanceof Error)){
var statearr_31580_31598 = state_31562__$1;
(statearr_31580_31598[(1)] = (4));

(statearr_31580_31598[(5)] = null);

} else {
throw ex31574;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31563 === (10))){
var inst_31546 = (state_31562[(7)]);
var inst_31554 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_31546);
var state_31562__$1 = state_31562;
var statearr_31581_31599 = state_31562__$1;
(statearr_31581_31599[(2)] = inst_31554);

(statearr_31581_31599[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31563 === (8))){
var inst_31546 = (state_31562[(7)]);
var state_31562__$1 = state_31562;
var statearr_31582_31600 = state_31562__$1;
(statearr_31582_31600[(2)] = inst_31546);

(statearr_31582_31600[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_31583 = [null,null,null,null,null,null,null,null,null];
(statearr_31583[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto__);

(statearr_31583[(1)] = (1));

return statearr_31583;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto____1 = (function (state_31562){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_31562);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e31584){var ex__16398__auto__ = e31584;
var statearr_31585_31601 = state_31562;
(statearr_31585_31601[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_31562[(4)]))){
var statearr_31586_31602 = state_31562;
(statearr_31586_31602[(1)] = cljs.core.first((state_31562[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__31603 = state_31562;
state_31562 = G__31603;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto__ = function(state_31562){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto____1.call(this,state_31562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_31587 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_31587[(6)] = c__16469__auto__);

return statearr_31587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_31684){
var state_val_31685 = (state_31684[(1)]);
if((state_val_31685 === (7))){
var state_31684__$1 = state_31684;
var statearr_31686_31724 = state_31684__$1;
(statearr_31686_31724[(2)] = flakes);

(statearr_31686_31724[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (20))){
var inst_31641 = (state_31684[(7)]);
var inst_31674 = (state_31684[(2)]);
var inst_31633 = inst_31641;
var inst_31634 = inst_31674;
var state_31684__$1 = (function (){var statearr_31687 = state_31684;
(statearr_31687[(8)] = inst_31634);

(statearr_31687[(9)] = inst_31633);

return statearr_31687;
})();
var statearr_31688_31725 = state_31684__$1;
(statearr_31688_31725[(2)] = null);

(statearr_31688_31725[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (1))){
var state_31684__$1 = state_31684;
var statearr_31689_31726 = state_31684__$1;
(statearr_31689_31726[(2)] = null);

(statearr_31689_31726[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (4))){
var inst_31606 = (state_31684[(2)]);
var state_31684__$1 = state_31684;
var statearr_31690_31727 = state_31684__$1;
(statearr_31690_31727[(2)] = inst_31606);

(statearr_31690_31727[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (15))){
var inst_31640 = (state_31684[(10)]);
var inst_31658 = inst_31640.o;
var state_31684__$1 = state_31684;
var statearr_31691_31728 = state_31684__$1;
(statearr_31691_31728[(2)] = inst_31658);

(statearr_31691_31728[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (13))){
var inst_31677 = (state_31684[(2)]);
var state_31684__$1 = state_31684;
var statearr_31692_31729 = state_31684__$1;
(statearr_31692_31729[(2)] = inst_31677);

(statearr_31692_31729[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (6))){
var inst_31613 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_31684__$1 = state_31684;
var statearr_31693_31730 = state_31684__$1;
(statearr_31693_31730[(2)] = inst_31613);

(statearr_31693_31730[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (17))){
var inst_31655 = (state_31684[(2)]);
var inst_31656 = fluree.db.util.async.throw_err(inst_31655);
var state_31684__$1 = state_31684;
var statearr_31694_31731 = state_31684__$1;
(statearr_31694_31731[(2)] = inst_31656);

(statearr_31694_31731[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (3))){
var inst_31682 = (state_31684[(2)]);
var state_31684__$1 = state_31684;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31684__$1,inst_31682);
} else {
if((state_val_31685 === (12))){
var inst_31647 = (state_31684[(11)]);
var inst_31640 = (state_31684[(10)]);
var inst_31645 = inst_31640.p;
var inst_31646 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_31645);
var inst_31647__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_31646);
var inst_31648 = inst_31640.op;
var inst_31649 = inst_31648 === false;
var inst_31650 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_31647__$1);
var state_31684__$1 = (function (){var statearr_31695 = state_31684;
(statearr_31695[(12)] = inst_31649);

(statearr_31695[(11)] = inst_31647__$1);

return statearr_31695;
})();
if(inst_31650){
var statearr_31696_31732 = state_31684__$1;
(statearr_31696_31732[(1)] = (14));

} else {
var statearr_31697_31733 = state_31684__$1;
(statearr_31697_31733[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (2))){
var _ = (function (){var statearr_31698 = state_31684;
(statearr_31698[(4)] = cljs.core.cons((5),(state_31684[(4)])));

return statearr_31698;
})();
var state_31684__$1 = state_31684;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_31699_31734 = state_31684__$1;
(statearr_31699_31734[(1)] = (6));

} else {
var statearr_31700_31735 = state_31684__$1;
(statearr_31700_31735[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (19))){
var inst_31634 = (state_31684[(8)]);
var inst_31647 = (state_31684[(11)]);
var inst_31660 = (state_31684[(13)]);
var inst_31640 = (state_31684[(10)]);
var inst_31668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31669 = inst_31640.s;
var inst_31670 = [inst_31669,inst_31647,cljs.core.cst$kw$new];
var inst_31671 = (new cljs.core.PersistentVector(null,3,(5),inst_31668,inst_31670,null));
var inst_31672 = cljs.core.assoc_in(inst_31634,inst_31671,inst_31660);
var state_31684__$1 = state_31684;
var statearr_31701_31736 = state_31684__$1;
(statearr_31701_31736[(2)] = inst_31672);

(statearr_31701_31736[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (11))){
var inst_31634 = (state_31684[(8)]);
var state_31684__$1 = state_31684;
var statearr_31703_31737 = state_31684__$1;
(statearr_31703_31737[(2)] = inst_31634);

(statearr_31703_31737[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (9))){
var inst_31633 = (state_31684[(9)]);
var inst_31640 = (state_31684[(10)]);
var inst_31639 = cljs.core.seq(inst_31633);
var inst_31640__$1 = cljs.core.first(inst_31639);
var inst_31641 = cljs.core.next(inst_31639);
var inst_31642 = cljs.core.not(inst_31640__$1);
var state_31684__$1 = (function (){var statearr_31704 = state_31684;
(statearr_31704[(7)] = inst_31641);

(statearr_31704[(10)] = inst_31640__$1);

return statearr_31704;
})();
if(inst_31642){
var statearr_31705_31738 = state_31684__$1;
(statearr_31705_31738[(1)] = (11));

} else {
var statearr_31706_31739 = state_31684__$1;
(statearr_31706_31739[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (5))){
var _ = (function (){var statearr_31707 = state_31684;
(statearr_31707[(4)] = cljs.core.rest((state_31684[(4)])));

return statearr_31707;
})();
var state_31684__$1 = state_31684;
var ex31702 = (state_31684__$1[(2)]);
var statearr_31708_31740 = state_31684__$1;
(statearr_31708_31740[(5)] = ex31702);


if((ex31702 instanceof Error)){
var statearr_31709_31741 = state_31684__$1;
(statearr_31709_31741[(1)] = (4));

(statearr_31709_31741[(5)] = null);

} else {
throw ex31702;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (14))){
var inst_31640 = (state_31684[(10)]);
var inst_31652 = inst_31640.o;
var inst_31653 = fluree.db.query.schema.convert_type_to_kw(inst_31652,db);
var state_31684__$1 = state_31684;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31684__$1,(17),inst_31653);
} else {
if((state_val_31685 === (16))){
var inst_31649 = (state_31684[(12)]);
var inst_31660 = (state_31684[(2)]);
var state_31684__$1 = (function (){var statearr_31710 = state_31684;
(statearr_31710[(13)] = inst_31660);

return statearr_31710;
})();
if(cljs.core.truth_(inst_31649)){
var statearr_31711_31742 = state_31684__$1;
(statearr_31711_31742[(1)] = (18));

} else {
var statearr_31712_31743 = state_31684__$1;
(statearr_31712_31743[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (10))){
var inst_31679 = (state_31684[(2)]);
var _ = (function (){var statearr_31713 = state_31684;
(statearr_31713[(4)] = cljs.core.rest((state_31684[(4)])));

return statearr_31713;
})();
var state_31684__$1 = state_31684;
var statearr_31714_31744 = state_31684__$1;
(statearr_31714_31744[(2)] = inst_31679);

(statearr_31714_31744[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (18))){
var inst_31634 = (state_31684[(8)]);
var inst_31647 = (state_31684[(11)]);
var inst_31660 = (state_31684[(13)]);
var inst_31640 = (state_31684[(10)]);
var inst_31662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31663 = inst_31640.s;
var inst_31664 = [inst_31663,inst_31647,cljs.core.cst$kw$old];
var inst_31665 = (new cljs.core.PersistentVector(null,3,(5),inst_31662,inst_31664,null));
var inst_31666 = cljs.core.assoc_in(inst_31634,inst_31665,inst_31660);
var state_31684__$1 = state_31684;
var statearr_31715_31745 = state_31684__$1;
(statearr_31715_31745[(2)] = inst_31666);

(statearr_31715_31745[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31685 === (8))){
var inst_31616 = (state_31684[(2)]);
var inst_31617 = cljs.core.PersistentHashSet.EMPTY;
var inst_31618 = cljs.core.vals(tempids);
var inst_31619 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31617,inst_31618);
var inst_31620 = (function (){var pred_flakes = inst_31616;
var is_new_QMARK_ = inst_31619;
return (function (p1__31605_SHARP_,p2__31604_SHARP_){
var f = p2__31604_SHARP_;
return cljs.core.assoc_in(p1__31605_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__31716 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__31716) : is_new_QMARK_.call(null,G__31716));
})()));
});
})();
var inst_31621 = cljs.core.PersistentHashMap.EMPTY;
var inst_31622 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_31620,inst_31621,inst_31616);
var inst_31630 = cljs.core.seq(inst_31616);
var inst_31631 = cljs.core.first(inst_31630);
var inst_31632 = cljs.core.next(inst_31630);
var inst_31633 = inst_31616;
var inst_31634 = inst_31622;
var state_31684__$1 = (function (){var statearr_31717 = state_31684;
(statearr_31717[(14)] = inst_31632);

(statearr_31717[(15)] = inst_31631);

(statearr_31717[(8)] = inst_31634);

(statearr_31717[(9)] = inst_31633);

return statearr_31717;
})();
var statearr_31718_31746 = state_31684__$1;
(statearr_31718_31746[(2)] = null);

(statearr_31718_31746[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto____0 = (function (){
var statearr_31719 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31719[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto__);

(statearr_31719[(1)] = (1));

return statearr_31719;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto____1 = (function (state_31684){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_31684);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e31720){var ex__16398__auto__ = e31720;
var statearr_31721_31747 = state_31684;
(statearr_31721_31747[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_31684[(4)]))){
var statearr_31722_31748 = state_31684;
(statearr_31722_31748[(1)] = cljs.core.first((state_31684[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__31749 = state_31684;
state_31684 = G__31749;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto__ = function(state_31684){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto____1.call(this,state_31684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_31723 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_31723[(6)] = c__16469__auto__);

return statearr_31723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__31751 = arguments.length;
switch (G__31751) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__31754 = arguments.length;
switch (G__31754) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32066){
var state_val_32067 = (state_32066[(1)]);
if((state_val_32067 === (121))){
var inst_32021 = (state_32066[(7)]);
var state_32066__$1 = state_32066;
var statearr_32068_32261 = state_32066__$1;
(statearr_32068_32261[(2)] = inst_32021);

(statearr_32068_32261[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (65))){
var inst_31920 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_31920)){
var statearr_32069_32262 = state_32066__$1;
(statearr_32069_32262[(1)] = (66));

} else {
var statearr_32070_32263 = state_32066__$1;
(statearr_32070_32263[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (70))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31930 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_31931 = (inst_31926.cljs$core$IFn$_invoke$arity$5 ? inst_31926.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_31930,null) : inst_31926.call(null,cljs.core.PersistentArrayMap,null,3,inst_31930,null));
var inst_31932 = (inst_31926.cljs$core$IFn$_invoke$arity$4 ? inst_31926.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31931,null) : inst_31926.call(null,cljs.core.PersistentHashSet,null,inst_31931,null));
var inst_31933 = (inst_31932.cljs$core$IFn$_invoke$arity$1 ? inst_31932.cljs$core$IFn$_invoke$arity$1(inst_31925) : inst_31932.call(null,inst_31925));
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_31933)){
var statearr_32071_32264 = state_32066__$1;
(statearr_32071_32264[(1)] = (72));

} else {
var statearr_32072_32265 = state_32066__$1;
(statearr_32072_32265[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (62))){
var inst_31910 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32073_32266 = state_32066__$1;
(statearr_32073_32266[(2)] = inst_31910);

(statearr_32073_32266[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (74))){
var inst_32016 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32074_32267 = state_32066__$1;
(statearr_32074_32267[(2)] = inst_32016);

(statearr_32074_32267[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (110))){
var inst_32043 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_32043)){
var statearr_32075_32268 = state_32066__$1;
(statearr_32075_32268[(1)] = (117));

} else {
var statearr_32076_32269 = state_32066__$1;
(statearr_32076_32269[(1)] = (118));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (7))){
var inst_32061 = (state_32066[(2)]);
var _ = (function (){var statearr_32077 = state_32066;
(statearr_32077[(4)] = cljs.core.rest((state_32066[(4)])));

return statearr_32077;
})();
var state_32066__$1 = state_32066;
var statearr_32078_32270 = state_32066__$1;
(statearr_32078_32270[(2)] = inst_32061);

(statearr_32078_32270[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (59))){
var inst_31794 = (state_32066[(10)]);
var inst_31914 = (state_32066[(11)]);
var inst_31913 = (state_32066[(2)]);
var inst_31914__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31794);
var state_32066__$1 = (function (){var statearr_32079 = state_32066;
(statearr_32079[(11)] = inst_31914__$1);

(statearr_32079[(12)] = inst_31913);

return statearr_32079;
})();
if(cljs.core.truth_(inst_31914__$1)){
var statearr_32080_32271 = state_32066__$1;
(statearr_32080_32271[(1)] = (63));

} else {
var statearr_32081_32272 = state_32066__$1;
(statearr_32081_32272[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (86))){
var inst_31956 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32082_32273 = state_32066__$1;
(statearr_32082_32273[(2)] = inst_31956);

(statearr_32082_32273[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (20))){
var inst_31794 = (state_32066[(10)]);
var inst_31820 = (state_32066[(13)]);
var inst_31820__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31794);
var state_32066__$1 = (function (){var statearr_32083 = state_32066;
(statearr_32083[(13)] = inst_31820__$1);

return statearr_32083;
})();
if(cljs.core.truth_(inst_31820__$1)){
var statearr_32084_32274 = state_32066__$1;
(statearr_32084_32274[(1)] = (23));

} else {
var statearr_32085_32275 = state_32066__$1;
(statearr_32085_32275[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (72))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31935 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31925,inst_31926,throw_QMARK_);
var state_32066__$1 = state_32066;
var statearr_32086_32276 = state_32066__$1;
(statearr_32086_32276[(2)] = inst_31935);

(statearr_32086_32276[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (58))){
var inst_31875 = (state_32066[(14)]);
var state_32066__$1 = state_32066;
var statearr_32087_32277 = state_32066__$1;
(statearr_32087_32277[(2)] = inst_31875);

(statearr_32087_32277[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (60))){
var inst_31782 = (state_32066[(15)]);
var inst_31793 = (state_32066[(16)]);
var inst_31901 = fluree.db.dbproto._p_prop(inst_31782,cljs.core.cst$kw$name,inst_31793);
var inst_31902 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31901)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_31903 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31904 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_31905 = cljs.core.PersistentHashMap.fromArrays(inst_31903,inst_31904);
var inst_31906 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31902,inst_31905);
var inst_31907 = (function(){throw inst_31906})();
var state_32066__$1 = state_32066;
var statearr_32088_32278 = state_32066__$1;
(statearr_32088_32278[(2)] = inst_31907);

(statearr_32088_32278[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (27))){
var inst_31823 = (state_32066[(17)]);
var state_32066__$1 = state_32066;
var statearr_32089_32279 = state_32066__$1;
(statearr_32089_32279[(2)] = inst_31823);

(statearr_32089_32279[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (1))){
var state_32066__$1 = state_32066;
var statearr_32090_32280 = state_32066__$1;
(statearr_32090_32280[(2)] = null);

(statearr_32090_32280[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (69))){
var inst_31913 = (state_32066[(12)]);
var state_32066__$1 = state_32066;
var statearr_32091_32281 = state_32066__$1;
(statearr_32091_32281[(2)] = inst_31913);

(statearr_32091_32281[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (101))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31994 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31925,inst_31926,throw_QMARK_);
var state_32066__$1 = state_32066;
var statearr_32092_32282 = state_32066__$1;
(statearr_32092_32282[(2)] = inst_31994);

(statearr_32092_32282[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (24))){
var inst_31820 = (state_32066[(13)]);
var state_32066__$1 = state_32066;
var statearr_32093_32283 = state_32066__$1;
(statearr_32093_32283[(2)] = inst_31820);

(statearr_32093_32283[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (102))){
var inst_31996 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32094_32284 = state_32066__$1;
(statearr_32094_32284[(2)] = inst_31996);

(statearr_32094_32284[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (55))){
var inst_31892 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32095_32285 = state_32066__$1;
(statearr_32095_32285[(2)] = inst_31892);

(statearr_32095_32285[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (85))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31954 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31925,inst_31926,throw_QMARK_);
var state_32066__$1 = state_32066;
var statearr_32096_32286 = state_32066__$1;
(statearr_32096_32286[(2)] = inst_31954);

(statearr_32096_32286[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (39))){
var inst_31857 = (state_32066[(18)]);
var state_32066__$1 = state_32066;
var statearr_32097_32287 = state_32066__$1;
(statearr_32097_32287[(2)] = inst_31857);

(statearr_32097_32287[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (88))){
var inst_31913 = (state_32066[(12)]);
var state_32066__$1 = state_32066;
var statearr_32098_32288 = state_32066__$1;
(statearr_32098_32288[(2)] = inst_31913);

(statearr_32098_32288[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (46))){
var inst_31794 = (state_32066[(10)]);
var inst_31876 = (state_32066[(19)]);
var inst_31875 = (state_32066[(2)]);
var inst_31876__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_31794);
var state_32066__$1 = (function (){var statearr_32099 = state_32066;
(statearr_32099[(14)] = inst_31875);

(statearr_32099[(19)] = inst_31876__$1);

return statearr_32099;
})();
if(cljs.core.truth_(inst_31876__$1)){
var statearr_32100_32289 = state_32066__$1;
(statearr_32100_32289[(1)] = (47));

} else {
var statearr_32101_32290 = state_32066__$1;
(statearr_32101_32290[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (4))){
var inst_31755 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32102_32291 = state_32066__$1;
(statearr_32102_32291[(2)] = inst_31755);

(statearr_32102_32291[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (77))){
var inst_32014 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32103_32292 = state_32066__$1;
(statearr_32103_32292[(2)] = inst_32014);

(statearr_32103_32292[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (106))){
var inst_32006 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32104_32293 = state_32066__$1;
(statearr_32104_32293[(2)] = inst_32006);

(statearr_32104_32293[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (119))){
var inst_31792 = (state_32066[(20)]);
var inst_32056 = (state_32066[(2)]);
var inst_31781 = inst_31792;
var inst_31782 = inst_32056;
var state_32066__$1 = (function (){var statearr_32105 = state_32066;
(statearr_32105[(15)] = inst_31782);

(statearr_32105[(21)] = inst_31781);

return statearr_32105;
})();
var statearr_32106_32294 = state_32066__$1;
(statearr_32106_32294[(2)] = null);

(statearr_32106_32294[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (95))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31978 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_31979 = (inst_31926.cljs$core$IFn$_invoke$arity$5 ? inst_31926.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_31978,null) : inst_31926.call(null,cljs.core.PersistentArrayMap,null,5,inst_31978,null));
var inst_31980 = (inst_31926.cljs$core$IFn$_invoke$arity$4 ? inst_31926.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31979,null) : inst_31926.call(null,cljs.core.PersistentHashSet,null,inst_31979,null));
var inst_31981 = (inst_31980.cljs$core$IFn$_invoke$arity$1 ? inst_31980.cljs$core$IFn$_invoke$arity$1(inst_31925) : inst_31980.call(null,inst_31925));
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_31981)){
var statearr_32107_32295 = state_32066__$1;
(statearr_32107_32295[(1)] = (96));

} else {
var statearr_32108_32296 = state_32066__$1;
(statearr_32108_32296[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (54))){
var inst_31883 = (state_32066[(22)]);
var state_32066__$1 = state_32066;
var statearr_32109_32297 = state_32066__$1;
(statearr_32109_32297[(2)] = inst_31883);

(statearr_32109_32297[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (92))){
var inst_31913 = (state_32066[(12)]);
var state_32066__$1 = state_32066;
var statearr_32110_32298 = state_32066__$1;
(statearr_32110_32298[(2)] = inst_31913);

(statearr_32110_32298[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (104))){
var inst_31913 = (state_32066[(12)]);
var state_32066__$1 = state_32066;
var statearr_32111_32299 = state_32066__$1;
(statearr_32111_32299[(2)] = inst_31913);

(statearr_32111_32299[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (15))){
var inst_31802 = (state_32066[(23)]);
var state_32066__$1 = state_32066;
var statearr_32112_32300 = state_32066__$1;
(statearr_32112_32300[(2)] = inst_31802);

(statearr_32112_32300[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (48))){
var inst_31876 = (state_32066[(19)]);
var state_32066__$1 = state_32066;
var statearr_32113_32301 = state_32066__$1;
(statearr_32113_32301[(2)] = inst_31876);

(statearr_32113_32301[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (50))){
var inst_31794 = (state_32066[(10)]);
var inst_31883 = (state_32066[(22)]);
var inst_31881 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_31882 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31881);
var inst_31883__$1 = inst_31882 === true;
var state_32066__$1 = (function (){var statearr_32114 = state_32066;
(statearr_32114[(22)] = inst_31883__$1);

return statearr_32114;
})();
if(cljs.core.truth_(inst_31883__$1)){
var statearr_32115_32302 = state_32066__$1;
(statearr_32115_32302[(1)] = (53));

} else {
var statearr_32116_32303 = state_32066__$1;
(statearr_32116_32303[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (116))){
var inst_32037 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32117_32304 = state_32066__$1;
(statearr_32117_32304[(2)] = inst_32037);

(statearr_32117_32304[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (75))){
var inst_31926 = (state_32066[(8)]);
var state_32066__$1 = state_32066;
var G__32118_32305 = inst_31926;
var G__32118_32306__$1 = (((G__32118_32305 instanceof cljs.core.Keyword))?G__32118_32305.fqn:null);
switch (G__32118_32306__$1) {
case "long":
var statearr_32119_32308 = state_32066__$1;
(statearr_32119_32308[(1)] = (79));


break;
case "bigint":
var statearr_32120_32309 = state_32066__$1;
(statearr_32120_32309[(1)] = (83));


break;
case "double":
var statearr_32121_32310 = state_32066__$1;
(statearr_32121_32310[(1)] = (87));


break;
case "float":
var statearr_32122_32311 = state_32066__$1;
(statearr_32122_32311[(1)] = (91));


break;
case "bigdec":
var statearr_32123_32312 = state_32066__$1;
(statearr_32123_32312[(1)] = (95));


break;
case "string":
var statearr_32124_32313 = state_32066__$1;
(statearr_32124_32313[(1)] = (99));


break;
case "instant":
var statearr_32125_32314 = state_32066__$1;
(statearr_32125_32314[(1)] = (103));


break;
default:
var statearr_32126_32315 = state_32066__$1;
(statearr_32126_32315[(1)] = (107));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (99))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31988 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_31989 = (inst_31926.cljs$core$IFn$_invoke$arity$5 ? inst_31926.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_31988,null) : inst_31926.call(null,cljs.core.PersistentArrayMap,null,5,inst_31988,null));
var inst_31990 = (inst_31926.cljs$core$IFn$_invoke$arity$4 ? inst_31926.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31989,null) : inst_31926.call(null,cljs.core.PersistentHashSet,null,inst_31989,null));
var inst_31991 = (inst_31990.cljs$core$IFn$_invoke$arity$1 ? inst_31990.cljs$core$IFn$_invoke$arity$1(inst_31925) : inst_31990.call(null,inst_31925));
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_31991)){
var statearr_32127_32316 = state_32066__$1;
(statearr_32127_32316[(1)] = (100));

} else {
var statearr_32128_32317 = state_32066__$1;
(statearr_32128_32317[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (21))){
var inst_31818 = (state_32066[(24)]);
var state_32066__$1 = state_32066;
var statearr_32129_32318 = state_32066__$1;
(statearr_32129_32318[(2)] = inst_31818);

(statearr_32129_32318[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (31))){
var inst_31834 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32130_32319 = state_32066__$1;
(statearr_32130_32319[(2)] = inst_31834);

(statearr_32130_32319[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (113))){
var inst_32040 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32131_32320 = state_32066__$1;
(statearr_32131_32320[(2)] = inst_32040);

(statearr_32131_32320[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (32))){
var state_32066__$1 = state_32066;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_32132_32321 = state_32066__$1;
(statearr_32132_32321[(1)] = (35));

} else {
var statearr_32133_32322 = state_32066__$1;
(statearr_32133_32322[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (40))){
var inst_31870 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_31870)){
var statearr_32134_32323 = state_32066__$1;
(statearr_32134_32323[(1)] = (44));

} else {
var statearr_32135_32324 = state_32066__$1;
(statearr_32135_32324[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (91))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31968 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_31969 = (inst_31926.cljs$core$IFn$_invoke$arity$5 ? inst_31926.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_31968,null) : inst_31926.call(null,cljs.core.PersistentArrayMap,null,3,inst_31968,null));
var inst_31970 = (inst_31926.cljs$core$IFn$_invoke$arity$4 ? inst_31926.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31969,null) : inst_31926.call(null,cljs.core.PersistentHashSet,null,inst_31969,null));
var inst_31971 = (inst_31970.cljs$core$IFn$_invoke$arity$1 ? inst_31970.cljs$core$IFn$_invoke$arity$1(inst_31925) : inst_31970.call(null,inst_31925));
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_31971)){
var statearr_32136_32325 = state_32066__$1;
(statearr_32136_32325[(1)] = (92));

} else {
var statearr_32137_32326 = state_32066__$1;
(statearr_32137_32326[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (117))){
var state_32066__$1 = state_32066;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_32138_32327 = state_32066__$1;
(statearr_32138_32327[(1)] = (120));

} else {
var statearr_32139_32328 = state_32066__$1;
(statearr_32139_32328[(1)] = (121));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (108))){
var inst_31794 = (state_32066[(10)]);
var inst_32025 = (state_32066[(25)]);
var inst_32025__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_31794);
var state_32066__$1 = (function (){var statearr_32140 = state_32066;
(statearr_32140[(25)] = inst_32025__$1);

return statearr_32140;
})();
if(cljs.core.truth_(inst_32025__$1)){
var statearr_32141_32329 = state_32066__$1;
(statearr_32141_32329[(1)] = (111));

} else {
var statearr_32142_32330 = state_32066__$1;
(statearr_32142_32330[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (56))){
var inst_31887 = (state_32066[(2)]);
var inst_31888 = fluree.db.util.async.throw_err(inst_31887);
var inst_31889 = cljs.core.not(inst_31888);
var state_32066__$1 = state_32066;
var statearr_32143_32331 = state_32066__$1;
(statearr_32143_32331[(2)] = inst_31889);

(statearr_32143_32331[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (33))){
var inst_31817 = (state_32066[(26)]);
var state_32066__$1 = state_32066;
var statearr_32144_32332 = state_32066__$1;
(statearr_32144_32332[(2)] = inst_31817);

(statearr_32144_32332[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (13))){
var inst_31812 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_31812)){
var statearr_32145_32333 = state_32066__$1;
(statearr_32145_32333[(1)] = (17));

} else {
var statearr_32146_32334 = state_32066__$1;
(statearr_32146_32334[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (22))){
var inst_31843 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_31843)){
var statearr_32147_32335 = state_32066__$1;
(statearr_32147_32335[(1)] = (32));

} else {
var statearr_32148_32336 = state_32066__$1;
(statearr_32148_32336[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (90))){
var inst_31966 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32149_32337 = state_32066__$1;
(statearr_32149_32337[(2)] = inst_31966);

(statearr_32149_32337[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (109))){
var inst_32023 = (state_32066[(27)]);
var state_32066__$1 = state_32066;
var statearr_32150_32338 = state_32066__$1;
(statearr_32150_32338[(2)] = inst_32023);

(statearr_32150_32338[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (36))){
var inst_31817 = (state_32066[(26)]);
var state_32066__$1 = state_32066;
var statearr_32151_32339 = state_32066__$1;
(statearr_32151_32339[(2)] = inst_31817);

(statearr_32151_32339[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (41))){
var inst_31794 = (state_32066[(10)]);
var inst_31862 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_31863 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31862);
var inst_31864 = inst_31863 === true;
var state_32066__$1 = state_32066;
var statearr_32152_32340 = state_32066__$1;
(statearr_32152_32340[(2)] = inst_31864);

(statearr_32152_32340[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (118))){
var inst_32021 = (state_32066[(7)]);
var state_32066__$1 = state_32066;
var statearr_32153_32341 = state_32066__$1;
(statearr_32153_32341[(2)] = inst_32021);

(statearr_32153_32341[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (89))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31964 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31925,inst_31926,throw_QMARK_);
var state_32066__$1 = state_32066;
var statearr_32154_32342 = state_32066__$1;
(statearr_32154_32342[(2)] = inst_31964);

(statearr_32154_32342[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (100))){
var inst_31913 = (state_32066[(12)]);
var state_32066__$1 = state_32066;
var statearr_32155_32343 = state_32066__$1;
(statearr_32155_32343[(2)] = inst_31913);

(statearr_32155_32343[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (122))){
var inst_32053 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32156_32344 = state_32066__$1;
(statearr_32156_32344[(2)] = inst_32053);

(statearr_32156_32344[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (43))){
var inst_31867 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32157_32345 = state_32066__$1;
(statearr_32157_32345[(2)] = inst_31867);

(statearr_32157_32345[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (61))){
var inst_31875 = (state_32066[(14)]);
var state_32066__$1 = state_32066;
var statearr_32158_32346 = state_32066__$1;
(statearr_32158_32346[(2)] = inst_31875);

(statearr_32158_32346[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (29))){
var inst_31794 = (state_32066[(10)]);
var inst_31829 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_31830 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31829);
var inst_31831 = inst_31830 === true;
var state_32066__$1 = state_32066;
var statearr_32159_32347 = state_32066__$1;
(statearr_32159_32347[(2)] = inst_31831);

(statearr_32159_32347[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (44))){
var inst_31856 = (state_32066[(28)]);
var inst_31872 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_31856,"a component","a non-component",throw_QMARK_);
var state_32066__$1 = state_32066;
var statearr_32160_32348 = state_32066__$1;
(statearr_32160_32348[(2)] = inst_31872);

(statearr_32160_32348[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (93))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31974 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31925,inst_31926,throw_QMARK_);
var state_32066__$1 = state_32066;
var statearr_32161_32349 = state_32066__$1;
(statearr_32161_32349[(2)] = inst_31974);

(statearr_32161_32349[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (6))){
var inst_31781 = (state_32066[(21)]);
var inst_31793 = (state_32066[(16)]);
var inst_31790 = cljs.core.seq(inst_31781);
var inst_31791 = cljs.core.first(inst_31790);
var inst_31792 = cljs.core.next(inst_31790);
var inst_31793__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31791,(0),null);
var inst_31794 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31791,(1),null);
var inst_31795 = cljs.core.not(inst_31793__$1);
var state_32066__$1 = (function (){var statearr_32162 = state_32066;
(statearr_32162[(10)] = inst_31794);

(statearr_32162[(20)] = inst_31792);

(statearr_32162[(16)] = inst_31793__$1);

return statearr_32162;
})();
if(inst_31795){
var statearr_32163_32350 = state_32066__$1;
(statearr_32163_32350[(1)] = (8));

} else {
var statearr_32164_32351 = state_32066__$1;
(statearr_32164_32351[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (111))){
var inst_31794 = (state_32066[(10)]);
var inst_32029 = (state_32066[(29)]);
var inst_32027 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_32028 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32027);
var inst_32029__$1 = inst_32028 === true;
var state_32066__$1 = (function (){var statearr_32165 = state_32066;
(statearr_32165[(29)] = inst_32029__$1);

return statearr_32165;
})();
if(cljs.core.truth_(inst_32029__$1)){
var statearr_32166_32352 = state_32066__$1;
(statearr_32166_32352[(1)] = (114));

} else {
var statearr_32167_32353 = state_32066__$1;
(statearr_32167_32353[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (28))){
var inst_31837 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32168_32354 = state_32066__$1;
(statearr_32168_32354[(2)] = inst_31837);

(statearr_32168_32354[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (64))){
var inst_31914 = (state_32066[(11)]);
var state_32066__$1 = state_32066;
var statearr_32169_32355 = state_32066__$1;
(statearr_32169_32355[(2)] = inst_31914);

(statearr_32169_32355[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (103))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31998 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_31999 = (inst_31926.cljs$core$IFn$_invoke$arity$5 ? inst_31926.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_31998,null) : inst_31926.call(null,cljs.core.PersistentArrayMap,null,2,inst_31998,null));
var inst_32000 = (inst_31926.cljs$core$IFn$_invoke$arity$4 ? inst_31926.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31999,null) : inst_31926.call(null,cljs.core.PersistentHashSet,null,inst_31999,null));
var inst_32001 = (inst_32000.cljs$core$IFn$_invoke$arity$1 ? inst_32000.cljs$core$IFn$_invoke$arity$1(inst_31925) : inst_32000.call(null,inst_31925));
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_32001)){
var statearr_32170_32356 = state_32066__$1;
(statearr_32170_32356[(1)] = (104));

} else {
var statearr_32171_32357 = state_32066__$1;
(statearr_32171_32357[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (51))){
var inst_31879 = (state_32066[(30)]);
var state_32066__$1 = state_32066;
var statearr_32172_32358 = state_32066__$1;
(statearr_32172_32358[(2)] = inst_31879);

(statearr_32172_32358[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (25))){
var inst_31840 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32173_32359 = state_32066__$1;
(statearr_32173_32359[(2)] = inst_31840);

(statearr_32173_32359[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (34))){
var inst_31794 = (state_32066[(10)]);
var inst_31857 = (state_32066[(18)]);
var inst_31856 = (state_32066[(2)]);
var inst_31857__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_31794);
var state_32066__$1 = (function (){var statearr_32174 = state_32066;
(statearr_32174[(28)] = inst_31856);

(statearr_32174[(18)] = inst_31857__$1);

return statearr_32174;
})();
if(cljs.core.truth_(inst_31857__$1)){
var statearr_32175_32360 = state_32066__$1;
(statearr_32175_32360[(1)] = (38));

} else {
var statearr_32176_32361 = state_32066__$1;
(statearr_32176_32361[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (17))){
var inst_31782 = (state_32066[(15)]);
var inst_31814 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_31782,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_32066__$1 = state_32066;
var statearr_32177_32362 = state_32066__$1;
(statearr_32177_32362[(2)] = inst_31814);

(statearr_32177_32362[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (3))){
var inst_32064 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32066__$1,inst_32064);
} else {
if((state_val_32067 === (12))){
var inst_31798 = (state_32066[(31)]);
var state_32066__$1 = state_32066;
var statearr_32178_32363 = state_32066__$1;
(statearr_32178_32363[(2)] = inst_31798);

(statearr_32178_32363[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (2))){
var _ = (function (){var statearr_32179 = state_32066;
(statearr_32179[(4)] = cljs.core.cons((5),(state_32066[(4)])));

return statearr_32179;
})();
var inst_31774 = pred_changes;
var inst_31775 = cljs.core.seq(inst_31774);
var inst_31776 = cljs.core.first(inst_31775);
var inst_31777 = cljs.core.next(inst_31775);
var inst_31778 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31776,(0),null);
var inst_31779 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31776,(1),null);
var inst_31780 = db;
var inst_31781 = inst_31774;
var inst_31782 = inst_31780;
var state_32066__$1 = (function (){var statearr_32180 = state_32066;
(statearr_32180[(32)] = inst_31779);

(statearr_32180[(15)] = inst_31782);

(statearr_32180[(33)] = inst_31778);

(statearr_32180[(34)] = inst_31777);

(statearr_32180[(21)] = inst_31781);

return statearr_32180;
})();
var statearr_32181_32364 = state_32066__$1;
(statearr_32181_32364[(2)] = null);

(statearr_32181_32364[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (66))){
var inst_31794 = (state_32066[(10)]);
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31923 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_31924 = cljs.core.__destructure_map(inst_31923);
var inst_31925__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31924,cljs.core.cst$kw$old);
var inst_31926__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31924,cljs.core.cst$kw$new);
var inst_31927 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31926__$1,inst_31925__$1);
var state_32066__$1 = (function (){var statearr_32182 = state_32066;
(statearr_32182[(8)] = inst_31926__$1);

(statearr_32182[(9)] = inst_31925__$1);

return statearr_32182;
})();
if(inst_31927){
var statearr_32183_32365 = state_32066__$1;
(statearr_32183_32365[(1)] = (69));

} else {
var statearr_32184_32366 = state_32066__$1;
(statearr_32184_32366[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (107))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_32008 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31925,inst_31926,throw_QMARK_);
var state_32066__$1 = state_32066;
var statearr_32185_32367 = state_32066__$1;
(statearr_32185_32367[(2)] = inst_32008);

(statearr_32185_32367[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (23))){
var inst_31823 = (state_32066[(17)]);
var inst_31794 = (state_32066[(10)]);
var inst_31822 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_31823__$1 = inst_31822 === true;
var state_32066__$1 = (function (){var statearr_32186 = state_32066;
(statearr_32186[(17)] = inst_31823__$1);

return statearr_32186;
})();
if(cljs.core.truth_(inst_31823__$1)){
var statearr_32187_32368 = state_32066__$1;
(statearr_32187_32368[(1)] = (26));

} else {
var statearr_32188_32369 = state_32066__$1;
(statearr_32188_32369[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (47))){
var inst_31879 = (state_32066[(30)]);
var inst_31794 = (state_32066[(10)]);
var inst_31878 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_31879__$1 = cljs.core.not(inst_31878);
var state_32066__$1 = (function (){var statearr_32189 = state_32066;
(statearr_32189[(30)] = inst_31879__$1);

return statearr_32189;
})();
if(inst_31879__$1){
var statearr_32190_32370 = state_32066__$1;
(statearr_32190_32370[(1)] = (50));

} else {
var statearr_32191_32371 = state_32066__$1;
(statearr_32191_32371[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (35))){
var inst_31846 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31847 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_31848 = cljs.core.PersistentHashMap.fromArrays(inst_31846,inst_31847);
var inst_31849 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_31848);
var inst_31850 = (function(){throw inst_31849})();
var state_32066__$1 = state_32066;
var statearr_32192_32372 = state_32066__$1;
(statearr_32192_32372[(2)] = inst_31850);

(statearr_32192_32372[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (82))){
var inst_31946 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32193_32373 = state_32066__$1;
(statearr_32193_32373[(2)] = inst_31946);

(statearr_32193_32373[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (76))){
var state_32066__$1 = state_32066;
var statearr_32194_32374 = state_32066__$1;
(statearr_32194_32374[(2)] = null);

(statearr_32194_32374[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (97))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31984 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31925,inst_31926,throw_QMARK_);
var state_32066__$1 = state_32066;
var statearr_32195_32375 = state_32066__$1;
(statearr_32195_32375[(2)] = inst_31984);

(statearr_32195_32375[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (19))){
var inst_31794 = (state_32066[(10)]);
var inst_31818 = (state_32066[(24)]);
var inst_31817 = (state_32066[(2)]);
var inst_31818__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_31794);
var state_32066__$1 = (function (){var statearr_32196 = state_32066;
(statearr_32196[(24)] = inst_31818__$1);

(statearr_32196[(26)] = inst_31817);

return statearr_32196;
})();
if(cljs.core.truth_(inst_31818__$1)){
var statearr_32197_32376 = state_32066__$1;
(statearr_32197_32376[(1)] = (20));

} else {
var statearr_32198_32377 = state_32066__$1;
(statearr_32198_32377[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (57))){
var state_32066__$1 = state_32066;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_32199_32378 = state_32066__$1;
(statearr_32199_32378[(1)] = (60));

} else {
var statearr_32200_32379 = state_32066__$1;
(statearr_32200_32379[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (68))){
var inst_31794 = (state_32066[(10)]);
var inst_32023 = (state_32066[(27)]);
var inst_32021 = (state_32066[(2)]);
var inst_32022 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_32023__$1 = inst_32022 === true;
var state_32066__$1 = (function (){var statearr_32201 = state_32066;
(statearr_32201[(7)] = inst_32021);

(statearr_32201[(27)] = inst_32023__$1);

return statearr_32201;
})();
if(cljs.core.truth_(inst_32023__$1)){
var statearr_32202_32380 = state_32066__$1;
(statearr_32202_32380[(1)] = (108));

} else {
var statearr_32203_32381 = state_32066__$1;
(statearr_32203_32381[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (11))){
var inst_31802 = (state_32066[(23)]);
var inst_31794 = (state_32066[(10)]);
var inst_31800 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_31801 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_31802__$1 = inst_31801 === false;
var state_32066__$1 = (function (){var statearr_32204 = state_32066;
(statearr_32204[(23)] = inst_31802__$1);

return statearr_32204;
})();
if(cljs.core.truth_(inst_31802__$1)){
var statearr_32205_32382 = state_32066__$1;
(statearr_32205_32382[(1)] = (14));

} else {
var statearr_32206_32383 = state_32066__$1;
(statearr_32206_32383[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (115))){
var inst_32029 = (state_32066[(29)]);
var state_32066__$1 = state_32066;
var statearr_32208_32384 = state_32066__$1;
(statearr_32208_32384[(2)] = inst_32029);

(statearr_32208_32384[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (9))){
var inst_31794 = (state_32066[(10)]);
var inst_31798 = (state_32066[(31)]);
var inst_31798__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_31794);
var state_32066__$1 = (function (){var statearr_32209 = state_32066;
(statearr_32209[(31)] = inst_31798__$1);

return statearr_32209;
})();
if(cljs.core.truth_(inst_31798__$1)){
var statearr_32210_32385 = state_32066__$1;
(statearr_32210_32385[(1)] = (11));

} else {
var statearr_32211_32386 = state_32066__$1;
(statearr_32211_32386[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (5))){
var _ = (function (){var statearr_32212 = state_32066;
(statearr_32212[(4)] = cljs.core.rest((state_32066[(4)])));

return statearr_32212;
})();
var state_32066__$1 = state_32066;
var ex32207 = (state_32066__$1[(2)]);
var statearr_32213_32387 = state_32066__$1;
(statearr_32213_32387[(5)] = ex32207);


if((ex32207 instanceof Error)){
var statearr_32214_32388 = state_32066__$1;
(statearr_32214_32388[(1)] = (4));

(statearr_32214_32388[(5)] = null);

} else {
throw ex32207;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (112))){
var inst_32025 = (state_32066[(25)]);
var state_32066__$1 = state_32066;
var statearr_32215_32389 = state_32066__$1;
(statearr_32215_32389[(2)] = inst_32025);

(statearr_32215_32389[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (83))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31948 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_31949 = (inst_31926.cljs$core$IFn$_invoke$arity$5 ? inst_31926.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_31948,null) : inst_31926.call(null,cljs.core.PersistentArrayMap,null,3,inst_31948,null));
var inst_31950 = (inst_31926.cljs$core$IFn$_invoke$arity$4 ? inst_31926.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31949,null) : inst_31926.call(null,cljs.core.PersistentHashSet,null,inst_31949,null));
var inst_31951 = (inst_31950.cljs$core$IFn$_invoke$arity$1 ? inst_31950.cljs$core$IFn$_invoke$arity$1(inst_31925) : inst_31950.call(null,inst_31925));
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_31951)){
var statearr_32216_32390 = state_32066__$1;
(statearr_32216_32390[(1)] = (84));

} else {
var statearr_32217_32391 = state_32066__$1;
(statearr_32217_32391[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (14))){
var inst_31794 = (state_32066[(10)]);
var inst_31804 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_31805 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_31804);
var inst_31806 = inst_31805 === true;
var state_32066__$1 = state_32066;
var statearr_32218_32392 = state_32066__$1;
(statearr_32218_32392[(2)] = inst_31806);

(statearr_32218_32392[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (45))){
var inst_31856 = (state_32066[(28)]);
var state_32066__$1 = state_32066;
var statearr_32219_32393 = state_32066__$1;
(statearr_32219_32393[(2)] = inst_31856);

(statearr_32219_32393[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (53))){
var inst_31782 = (state_32066[(15)]);
var inst_31793 = (state_32066[(16)]);
var inst_31885 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_31782,inst_31793);
var state_32066__$1 = state_32066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32066__$1,(56),inst_31885);
} else {
if((state_val_32067 === (78))){
var inst_32011 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32220_32394 = state_32066__$1;
(statearr_32220_32394[(2)] = inst_32011);

(statearr_32220_32394[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (26))){
var inst_31794 = (state_32066[(10)]);
var inst_31827 = (state_32066[(35)]);
var inst_31825 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_31826 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31825);
var inst_31827__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_31826);
var state_32066__$1 = (function (){var statearr_32221 = state_32066;
(statearr_32221[(35)] = inst_31827__$1);

return statearr_32221;
})();
if(inst_31827__$1){
var statearr_32222_32395 = state_32066__$1;
(statearr_32222_32395[(1)] = (29));

} else {
var statearr_32223_32396 = state_32066__$1;
(statearr_32223_32396[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (16))){
var inst_31809 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32224_32397 = state_32066__$1;
(statearr_32224_32397[(2)] = inst_31809);

(statearr_32224_32397[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (81))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31944 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31925,inst_31926,throw_QMARK_);
var state_32066__$1 = state_32066;
var statearr_32225_32398 = state_32066__$1;
(statearr_32225_32398[(2)] = inst_31944);

(statearr_32225_32398[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (120))){
var inst_32046 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32047 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_32048 = cljs.core.PersistentHashMap.fromArrays(inst_32046,inst_32047);
var inst_32049 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_32048);
var inst_32050 = (function(){throw inst_32049})();
var state_32066__$1 = state_32066;
var statearr_32226_32399 = state_32066__$1;
(statearr_32226_32399[(2)] = inst_32050);

(statearr_32226_32399[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (79))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31938 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_31939 = (inst_31926.cljs$core$IFn$_invoke$arity$5 ? inst_31926.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_31938,null) : inst_31926.call(null,cljs.core.PersistentArrayMap,null,2,inst_31938,null));
var inst_31940 = (inst_31926.cljs$core$IFn$_invoke$arity$4 ? inst_31926.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31939,null) : inst_31926.call(null,cljs.core.PersistentHashSet,null,inst_31939,null));
var inst_31941 = (inst_31940.cljs$core$IFn$_invoke$arity$1 ? inst_31940.cljs$core$IFn$_invoke$arity$1(inst_31925) : inst_31940.call(null,inst_31925));
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_31941)){
var statearr_32227_32400 = state_32066__$1;
(statearr_32227_32400[(1)] = (80));

} else {
var statearr_32228_32401 = state_32066__$1;
(statearr_32228_32401[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (38))){
var inst_31794 = (state_32066[(10)]);
var inst_31860 = (state_32066[(36)]);
var inst_31859 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_31860__$1 = cljs.core.not(inst_31859);
var state_32066__$1 = (function (){var statearr_32229 = state_32066;
(statearr_32229[(36)] = inst_31860__$1);

return statearr_32229;
})();
if(inst_31860__$1){
var statearr_32230_32402 = state_32066__$1;
(statearr_32230_32402[(1)] = (41));

} else {
var statearr_32231_32403 = state_32066__$1;
(statearr_32231_32403[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (98))){
var inst_31986 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32232_32404 = state_32066__$1;
(statearr_32232_32404[(2)] = inst_31986);

(statearr_32232_32404[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (87))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_31958 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_31959 = (inst_31926.cljs$core$IFn$_invoke$arity$5 ? inst_31926.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_31958,null) : inst_31926.call(null,cljs.core.PersistentArrayMap,null,3,inst_31958,null));
var inst_31960 = (inst_31926.cljs$core$IFn$_invoke$arity$4 ? inst_31926.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31959,null) : inst_31926.call(null,cljs.core.PersistentHashSet,null,inst_31959,null));
var inst_31961 = (inst_31960.cljs$core$IFn$_invoke$arity$1 ? inst_31960.cljs$core$IFn$_invoke$arity$1(inst_31925) : inst_31960.call(null,inst_31925));
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_31961)){
var statearr_32233_32405 = state_32066__$1;
(statearr_32233_32405[(1)] = (88));

} else {
var statearr_32234_32406 = state_32066__$1;
(statearr_32234_32406[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (30))){
var inst_31827 = (state_32066[(35)]);
var state_32066__$1 = state_32066;
var statearr_32235_32407 = state_32066__$1;
(statearr_32235_32407[(2)] = inst_31827);

(statearr_32235_32407[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (73))){
var state_32066__$1 = state_32066;
var statearr_32236_32408 = state_32066__$1;
(statearr_32236_32408[(1)] = (75));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (96))){
var inst_31913 = (state_32066[(12)]);
var state_32066__$1 = state_32066;
var statearr_32238_32409 = state_32066__$1;
(statearr_32238_32409[(2)] = inst_31913);

(statearr_32238_32409[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (10))){
var inst_32059 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32239_32410 = state_32066__$1;
(statearr_32239_32410[(2)] = inst_32059);

(statearr_32239_32410[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (18))){
var inst_31782 = (state_32066[(15)]);
var state_32066__$1 = state_32066;
var statearr_32240_32411 = state_32066__$1;
(statearr_32240_32411[(2)] = inst_31782);

(statearr_32240_32411[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (105))){
var inst_31926 = (state_32066[(8)]);
var inst_31925 = (state_32066[(9)]);
var inst_32004 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31925,inst_31926,throw_QMARK_);
var state_32066__$1 = state_32066;
var statearr_32241_32412 = state_32066__$1;
(statearr_32241_32412[(2)] = inst_32004);

(statearr_32241_32412[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (52))){
var inst_31895 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32242_32413 = state_32066__$1;
(statearr_32242_32413[(2)] = inst_31895);

(statearr_32242_32413[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (114))){
var inst_31794 = (state_32066[(10)]);
var inst_32031 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_32032 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32031);
var inst_32033 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_32032);
var inst_32034 = (!(inst_32033));
var state_32066__$1 = state_32066;
var statearr_32243_32414 = state_32066__$1;
(statearr_32243_32414[(2)] = inst_32034);

(statearr_32243_32414[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (67))){
var inst_31913 = (state_32066[(12)]);
var state_32066__$1 = state_32066;
var statearr_32244_32415 = state_32066__$1;
(statearr_32244_32415[(2)] = inst_31913);

(statearr_32244_32415[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (71))){
var inst_32018 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32245_32416 = state_32066__$1;
(statearr_32245_32416[(2)] = inst_32018);

(statearr_32245_32416[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (42))){
var inst_31860 = (state_32066[(36)]);
var state_32066__$1 = state_32066;
var statearr_32246_32417 = state_32066__$1;
(statearr_32246_32417[(2)] = inst_31860);

(statearr_32246_32417[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (80))){
var inst_31913 = (state_32066[(12)]);
var state_32066__$1 = state_32066;
var statearr_32247_32418 = state_32066__$1;
(statearr_32247_32418[(2)] = inst_31913);

(statearr_32247_32418[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (37))){
var inst_31853 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32248_32419 = state_32066__$1;
(statearr_32248_32419[(2)] = inst_31853);

(statearr_32248_32419[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (63))){
var inst_31794 = (state_32066[(10)]);
var inst_31916 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31794);
var inst_31917 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_31916);
var state_32066__$1 = state_32066;
var statearr_32249_32420 = state_32066__$1;
(statearr_32249_32420[(2)] = inst_31917);

(statearr_32249_32420[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (94))){
var inst_31976 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32250_32421 = state_32066__$1;
(statearr_32250_32421[(2)] = inst_31976);

(statearr_32250_32421[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (8))){
var inst_31782 = (state_32066[(15)]);
var state_32066__$1 = state_32066;
var statearr_32251_32422 = state_32066__$1;
(statearr_32251_32422[(2)] = inst_31782);

(statearr_32251_32422[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (49))){
var inst_31898 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_31898)){
var statearr_32252_32423 = state_32066__$1;
(statearr_32252_32423[(1)] = (57));

} else {
var statearr_32253_32424 = state_32066__$1;
(statearr_32253_32424[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32067 === (84))){
var inst_31913 = (state_32066[(12)]);
var state_32066__$1 = state_32066;
var statearr_32254_32425 = state_32066__$1;
(statearr_32254_32425[(2)] = inst_31913);

(statearr_32254_32425[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__16395__auto__ = null;
var fluree$db$query$schema$state_machine__16395__auto____0 = (function (){
var statearr_32255 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32255[(0)] = fluree$db$query$schema$state_machine__16395__auto__);

(statearr_32255[(1)] = (1));

return statearr_32255;
});
var fluree$db$query$schema$state_machine__16395__auto____1 = (function (state_32066){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32066);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32256){var ex__16398__auto__ = e32256;
var statearr_32257_32426 = state_32066;
(statearr_32257_32426[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32066[(4)]))){
var statearr_32258_32427 = state_32066;
(statearr_32258_32427[(1)] = cljs.core.first((state_32066[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32428 = state_32066;
state_32066 = G__32428;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__16395__auto__ = function(state_32066){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__16395__auto____1.call(this,state_32066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__16395__auto____0;
fluree$db$query$schema$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__16395__auto____1;
return fluree$db$query$schema$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32259 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32259[(6)] = c__16469__auto__);

return statearr_32259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__32430 = arguments.length;
switch (G__32430) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32454){
var state_val_32455 = (state_32454[(1)]);
if((state_val_32455 === (7))){
var state_32454__$1 = state_32454;
var statearr_32456_32476 = state_32454__$1;
(statearr_32456_32476[(2)] = db);

(statearr_32456_32476[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32455 === (1))){
var state_32454__$1 = state_32454;
var statearr_32457_32477 = state_32454__$1;
(statearr_32457_32477[(2)] = null);

(statearr_32457_32477[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32455 === (4))){
var inst_32431 = (state_32454[(2)]);
var state_32454__$1 = state_32454;
var statearr_32458_32478 = state_32454__$1;
(statearr_32458_32478[(2)] = inst_32431);

(statearr_32458_32478[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32455 === (6))){
var inst_32440 = (state_32454[(7)]);
var inst_32439 = (state_32454[(2)]);
var inst_32440__$1 = fluree.db.util.async.throw_err(inst_32439);
var inst_32441 = cljs.core.empty_QMARK_(inst_32440__$1);
var state_32454__$1 = (function (){var statearr_32459 = state_32454;
(statearr_32459[(7)] = inst_32440__$1);

return statearr_32459;
})();
if(inst_32441){
var statearr_32460_32479 = state_32454__$1;
(statearr_32460_32479[(1)] = (7));

} else {
var statearr_32461_32480 = state_32454__$1;
(statearr_32461_32480[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32455 === (3))){
var inst_32452 = (state_32454[(2)]);
var state_32454__$1 = state_32454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32454__$1,inst_32452);
} else {
if((state_val_32455 === (2))){
var _ = (function (){var statearr_32463 = state_32454;
(statearr_32463[(4)] = cljs.core.cons((5),(state_32454[(4)])));

return statearr_32463;
})();
var inst_32437 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_32454__$1 = state_32454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32454__$1,(6),inst_32437);
} else {
if((state_val_32455 === (9))){
var inst_32449 = (state_32454[(2)]);
var _ = (function (){var statearr_32464 = state_32454;
(statearr_32464[(4)] = cljs.core.rest((state_32454[(4)])));

return statearr_32464;
})();
var state_32454__$1 = state_32454;
var statearr_32465_32481 = state_32454__$1;
(statearr_32465_32481[(2)] = inst_32449);

(statearr_32465_32481[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32455 === (5))){
var _ = (function (){var statearr_32466 = state_32454;
(statearr_32466[(4)] = cljs.core.rest((state_32454[(4)])));

return statearr_32466;
})();
var state_32454__$1 = state_32454;
var ex32462 = (state_32454__$1[(2)]);
var statearr_32467_32482 = state_32454__$1;
(statearr_32467_32482[(5)] = ex32462);


if((ex32462 instanceof Error)){
var statearr_32468_32483 = state_32454__$1;
(statearr_32468_32483[(1)] = (4));

(statearr_32468_32483[(5)] = null);

} else {
throw ex32462;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32455 === (10))){
var inst_32446 = (state_32454[(2)]);
var inst_32447 = fluree.db.util.async.throw_err(inst_32446);
var state_32454__$1 = state_32454;
var statearr_32469_32484 = state_32454__$1;
(statearr_32469_32484[(2)] = inst_32447);

(statearr_32469_32484[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32455 === (8))){
var inst_32440 = (state_32454[(7)]);
var inst_32444 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_32440,db,true);
var state_32454__$1 = state_32454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32454__$1,(10),inst_32444);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__16395__auto__ = null;
var fluree$db$query$schema$state_machine__16395__auto____0 = (function (){
var statearr_32470 = [null,null,null,null,null,null,null,null];
(statearr_32470[(0)] = fluree$db$query$schema$state_machine__16395__auto__);

(statearr_32470[(1)] = (1));

return statearr_32470;
});
var fluree$db$query$schema$state_machine__16395__auto____1 = (function (state_32454){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32454);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32471){var ex__16398__auto__ = e32471;
var statearr_32472_32485 = state_32454;
(statearr_32472_32485[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32454[(4)]))){
var statearr_32473_32486 = state_32454;
(statearr_32473_32486[(1)] = cljs.core.first((state_32454[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32487 = state_32454;
state_32454 = G__32487;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__16395__auto__ = function(state_32454){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__16395__auto____1.call(this,state_32454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__16395__auto____0;
fluree$db$query$schema$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__16395__auto____1;
return fluree$db$query$schema$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32474 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32474[(6)] = c__16469__auto__);

return statearr_32474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__32489 = arguments.length;
switch (G__32489) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__32491 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32491,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32491,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32491,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4210__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4210__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__32494_SHARP_,p2__32495_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__32494_SHARP_,p2__32495_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__32496_SHARP_){
var f = p1__32496_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32562){
var state_val_32563 = (state_32562[(1)]);
if((state_val_32563 === (1))){
var state_32562__$1 = state_32562;
var statearr_32564_32582 = state_32562__$1;
(statearr_32564_32582[(2)] = null);

(statearr_32564_32582[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32563 === (2))){
var _ = (function (){var statearr_32565 = state_32562;
(statearr_32565[(4)] = cljs.core.cons((5),(state_32562[(4)])));

return statearr_32565;
})();
var inst_32514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32515 = fluree.db.flake.max_subject_id((1));
var inst_32516 = [inst_32515];
var inst_32517 = (new cljs.core.PersistentVector(null,1,(5),inst_32514,inst_32516,null));
var inst_32518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32519 = [(0)];
var inst_32520 = (new cljs.core.PersistentVector(null,1,(5),inst_32518,inst_32519,null));
var inst_32521 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_32517,cljs.core._LT__EQ_,inst_32520);
var state_32562__$1 = state_32562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32562__$1,(6),inst_32521);
} else {
if((state_val_32563 === (3))){
var inst_32560 = (state_32562[(2)]);
var state_32562__$1 = state_32562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32562__$1,inst_32560);
} else {
if((state_val_32563 === (4))){
var inst_32502 = (state_32562[(2)]);
var state_32562__$1 = state_32562;
var statearr_32567_32583 = state_32562__$1;
(statearr_32567_32583[(2)] = inst_32502);

(statearr_32567_32583[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32563 === (5))){
var _ = (function (){var statearr_32568 = state_32562;
(statearr_32568[(4)] = cljs.core.rest((state_32562[(4)])));

return statearr_32568;
})();
var state_32562__$1 = state_32562;
var ex32566 = (state_32562__$1[(2)]);
var statearr_32569_32584 = state_32562__$1;
(statearr_32569_32584[(5)] = ex32566);


if((ex32566 instanceof Error)){
var statearr_32570_32585 = state_32562__$1;
(statearr_32570_32585[(1)] = (4));

(statearr_32570_32585[(5)] = null);

} else {
throw ex32566;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32563 === (6))){
var inst_32523 = (state_32562[(2)]);
var inst_32524 = fluree.db.util.async.throw_err(inst_32523);
var inst_32525 = (function (){var schema_flakes = inst_32524;
return (function (p1__32497_SHARP_){
return (p1__32497_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_32526 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32525,inst_32524);
var inst_32527 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32526,(0),null);
var inst_32528 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32526,(1),null);
var inst_32529 = (function (){var schema_flakes = inst_32524;
var vec__32508 = inst_32526;
var collection_flakes = inst_32527;
var predicate_flakes = inst_32528;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__32500_SHARP_,p2__32499_SHARP_){
var f = p2__32499_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32500_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,specs,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,partition,cljs.core.cst$kw$partition,partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_32530 = [(-1),"_tx"];
var inst_32531 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid,cljs.core.cst$kw$partition,cljs.core.cst$kw$spec,cljs.core.cst$kw$specDoc];
var inst_32532 = ["_tx",(-1),(-1),(-1),null,null];
var inst_32533 = cljs.core.PersistentHashMap.fromArrays(inst_32531,inst_32532);
var inst_32534 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid,cljs.core.cst$kw$partition,cljs.core.cst$kw$spec,cljs.core.cst$kw$specDoc];
var inst_32535 = ["_tx",(-1),(-1),(-1),null,null];
var inst_32536 = cljs.core.PersistentHashMap.fromArrays(inst_32534,inst_32535);
var inst_32537 = [inst_32533,inst_32536];
var inst_32538 = cljs.core.PersistentHashMap.fromArrays(inst_32530,inst_32537);
var inst_32539 = (function (){var schema_flakes = inst_32524;
var vec__32508 = inst_32526;
var collection_flakes = inst_32527;
var predicate_flakes = inst_32528;
return (function (p1__32498_SHARP_){
return p1__32498_SHARP_.s;
});
})();
var inst_32540 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32539,inst_32527);
var inst_32541 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32529,inst_32538,inst_32540);
var inst_32543 = (function (){var schema_flakes = inst_32524;
var vec__32508 = inst_32526;
var collection_flakes = inst_32527;
var predicate_flakes = inst_32528;
var coll = inst_32541;
return (function (p__32542,pred_flakes){
var vec__32571 = p__32542;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32571,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32571,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__32574 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__32574.cljs$core$IFn$_invoke$arity$1 ? fexpr__32574.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__32574.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4212__auto__ = ref_QMARK_;
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$retractDuplicates,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_32544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32545 = cljs.core.PersistentHashMap.EMPTY;
var inst_32546 = cljs.core.PersistentHashSet.EMPTY;
var inst_32547 = [inst_32545,inst_32546];
var inst_32548 = (new cljs.core.PersistentVector(null,2,(5),inst_32544,inst_32547,null));
var inst_32549 = (function (){var schema_flakes = inst_32524;
var vec__32508 = inst_32526;
var collection_flakes = inst_32527;
var predicate_flakes = inst_32528;
var coll = inst_32541;
return (function (p1__32501_SHARP_){
return p1__32501_SHARP_.s;
});
})();
var inst_32550 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32549,inst_32528);
var inst_32551 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32543,inst_32548,inst_32550);
var inst_32552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32551,(0),null);
var inst_32553 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32551,(1),null);
var inst_32554 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_32555 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_32556 = [inst_32555,inst_32541,inst_32552,inst_32553];
var inst_32557 = cljs.core.PersistentHashMap.fromArrays(inst_32554,inst_32556);
var _ = (function (){var statearr_32575 = state_32562;
(statearr_32575[(4)] = cljs.core.rest((state_32562[(4)])));

return statearr_32575;
})();
var state_32562__$1 = state_32562;
var statearr_32576_32586 = state_32562__$1;
(statearr_32576_32586[(2)] = inst_32557);

(statearr_32576_32586[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__16395__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__16395__auto____0 = (function (){
var statearr_32577 = [null,null,null,null,null,null,null];
(statearr_32577[(0)] = fluree$db$query$schema$schema_map_$_state_machine__16395__auto__);

(statearr_32577[(1)] = (1));

return statearr_32577;
});
var fluree$db$query$schema$schema_map_$_state_machine__16395__auto____1 = (function (state_32562){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32562);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32578){var ex__16398__auto__ = e32578;
var statearr_32579_32587 = state_32562;
(statearr_32579_32587[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32562[(4)]))){
var statearr_32580_32588 = state_32562;
(statearr_32580_32588[(1)] = cljs.core.first((state_32562[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32589 = state_32562;
state_32562 = G__32589;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__16395__auto__ = function(state_32562){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__16395__auto____1.call(this,state_32562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__16395__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__16395__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32581 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32581[(6)] = c__16469__auto__);

return statearr_32581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32631){
var state_val_32632 = (state_32631[(1)]);
if((state_val_32632 === (7))){
var inst_32614 = (state_32631[(2)]);
var inst_32615 = fluree.db.query.schema.flake__GT_pred_map(inst_32614);
var inst_32616 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_32617 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32615,(114));
var inst_32618 = cljs.core.boolean$(inst_32617);
var inst_32619 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32615,(110));
var inst_32620 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32615,(117));
var inst_32621 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_32620);
var inst_32622 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32615,(111));
var inst_32623 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32615,(115));
var inst_32624 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32615,(112));
var inst_32625 = [inst_32618,inst_32619,inst_32621,inst_32622,inst_32623,inst_32624];
var inst_32626 = cljs.core.PersistentHashMap.fromArrays(inst_32616,inst_32625);
var _ = (function (){var statearr_32633 = state_32631;
(statearr_32633[(4)] = cljs.core.rest((state_32631[(4)])));

return statearr_32633;
})();
var state_32631__$1 = state_32631;
var statearr_32634_32657 = state_32631__$1;
(statearr_32634_32657[(2)] = inst_32626);

(statearr_32634_32657[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32632 === (1))){
var state_32631__$1 = state_32631;
var statearr_32635_32658 = state_32631__$1;
(statearr_32635_32658[(2)] = null);

(statearr_32635_32658[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32632 === (4))){
var inst_32590 = (state_32631[(2)]);
var state_32631__$1 = state_32631;
var statearr_32636_32659 = state_32631__$1;
(statearr_32636_32659[(2)] = inst_32590);

(statearr_32636_32659[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32632 === (6))){
var _ = (function (){var statearr_32637 = state_32631;
(statearr_32637[(4)] = cljs.core.cons((9),(state_32631[(4)])));

return statearr_32637;
})();
var inst_32602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32604 = ["_setting/id","root"];
var inst_32605 = (new cljs.core.PersistentVector(null,2,(5),inst_32603,inst_32604,null));
var inst_32606 = [inst_32605];
var inst_32607 = (new cljs.core.PersistentVector(null,1,(5),inst_32602,inst_32606,null));
var inst_32608 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_32607);
var state_32631__$1 = state_32631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32631__$1,(10),inst_32608);
} else {
if((state_val_32632 === (3))){
var inst_32629 = (state_32631[(2)]);
var state_32631__$1 = state_32631;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32631__$1,inst_32629);
} else {
if((state_val_32632 === (2))){
var _ = (function (){var statearr_32640 = state_32631;
(statearr_32640[(4)] = cljs.core.cons((5),(state_32631[(4)])));

return statearr_32640;
})();
var state_32631__$1 = state_32631;
var statearr_32641_32660 = state_32631__$1;
(statearr_32641_32660[(2)] = null);

(statearr_32641_32660[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32632 === (9))){
var _ = (function (){var statearr_32642 = state_32631;
(statearr_32642[(4)] = cljs.core.rest((state_32631[(4)])));

return statearr_32642;
})();
var state_32631__$1 = state_32631;
var ex32638 = (state_32631__$1[(2)]);
var statearr_32643_32661 = state_32631__$1;
(statearr_32643_32661[(5)] = ex32638);


var statearr_32644_32662 = state_32631__$1;
(statearr_32644_32662[(1)] = (8));

(statearr_32644_32662[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32632 === (5))){
var _ = (function (){var statearr_32645 = state_32631;
(statearr_32645[(4)] = cljs.core.rest((state_32631[(4)])));

return statearr_32645;
})();
var state_32631__$1 = state_32631;
var ex32639 = (state_32631__$1[(2)]);
var statearr_32646_32663 = state_32631__$1;
(statearr_32646_32663[(5)] = ex32639);


if((ex32639 instanceof Error)){
var statearr_32647_32664 = state_32631__$1;
(statearr_32647_32664[(1)] = (4));

(statearr_32647_32664[(5)] = null);

} else {
throw ex32639;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32632 === (10))){
var inst_32610 = (state_32631[(2)]);
var inst_32611 = fluree.db.util.async.throw_err(inst_32610);
var _ = (function (){var statearr_32648 = state_32631;
(statearr_32648[(4)] = cljs.core.rest((state_32631[(4)])));

return statearr_32648;
})();
var state_32631__$1 = state_32631;
var statearr_32649_32665 = state_32631__$1;
(statearr_32649_32665[(2)] = inst_32611);

(statearr_32649_32665[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32632 === (8))){
var inst_32596 = (state_32631[(2)]);
var state_32631__$1 = (function (){var statearr_32650 = state_32631;
(statearr_32650[(7)] = inst_32596);

return statearr_32650;
})();
var statearr_32651_32666 = state_32631__$1;
(statearr_32651_32666[(2)] = null);

(statearr_32651_32666[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__16395__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__16395__auto____0 = (function (){
var statearr_32652 = [null,null,null,null,null,null,null,null];
(statearr_32652[(0)] = fluree$db$query$schema$setting_map_$_state_machine__16395__auto__);

(statearr_32652[(1)] = (1));

return statearr_32652;
});
var fluree$db$query$schema$setting_map_$_state_machine__16395__auto____1 = (function (state_32631){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32631);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32653){var ex__16398__auto__ = e32653;
var statearr_32654_32667 = state_32631;
(statearr_32654_32667[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32631[(4)]))){
var statearr_32655_32668 = state_32631;
(statearr_32655_32668[(1)] = cljs.core.first((state_32631[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32669 = state_32631;
state_32631 = G__32669;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__16395__auto__ = function(state_32631){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__16395__auto____1.call(this,state_32631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__16395__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__16395__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32656 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32656[(6)] = c__16469__auto__);

return statearr_32656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
