// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35639_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35639_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__35643 = coll;
var vec__35644 = G__35643;
var seq__35645 = cljs.core.seq(vec__35644);
var first__35646 = cljs.core.first(seq__35645);
var seq__35645__$1 = cljs.core.next(seq__35645);
var clause = first__35646;
var r = seq__35645__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__35643__$1 = G__35643;
var res__$1 = res;
while(true){
var vec__35650 = G__35643__$1;
var seq__35651 = cljs.core.seq(vec__35650);
var first__35652 = cljs.core.first(seq__35651);
var seq__35651__$1 = cljs.core.next(seq__35651);
var clause__$1 = first__35652;
var r__$1 = seq__35651__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__35653 = r__$1;
var G__35654 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__35643__$1 = G__35653;
res__$1 = G__35654;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__35655){
var map__35656 = p__35655;
var map__35656__$1 = cljs.core.__destructure_map(map__35656);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35656__$1,cljs.core.cst$kw$optional);
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__35660 = coll;
var vec__35661 = G__35660;
var seq__35662 = cljs.core.seq(vec__35661);
var first__35663 = cljs.core.first(seq__35662);
var seq__35662__$1 = cljs.core.next(seq__35662);
var clause = first__35663;
var r = seq__35662__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__35660__$1 = G__35660;
var res__$1 = res;
while(true){
var vec__35667 = G__35660__$1;
var seq__35668 = cljs.core.seq(vec__35667);
var first__35669 = cljs.core.first(seq__35668);
var seq__35668__$1 = cljs.core.next(seq__35668);
var clause__$1 = first__35669;
var r__$1 = seq__35668__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__35670 = r__$1;
var G__35671 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__35660__$1 = G__35670;
res__$1 = G__35671;
continue;
} else {
var G__35672 = r__$1;
var G__35673 = res__$2;
G__35660__$1 = G__35672;
res__$1 = G__35673;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__35677 = coll;
var vec__35678 = G__35677;
var seq__35679 = cljs.core.seq(vec__35678);
var first__35680 = cljs.core.first(seq__35679);
var seq__35679__$1 = cljs.core.next(seq__35679);
var clause = first__35680;
var r = seq__35679__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__35677__$1 = G__35677;
var res__$1 = res;
while(true){
var vec__35684 = G__35677__$1;
var seq__35685 = cljs.core.seq(vec__35684);
var first__35686 = cljs.core.first(seq__35685);
var seq__35685__$1 = cljs.core.next(seq__35685);
var clause__$1 = first__35686;
var r__$1 = seq__35685__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__35687 = r__$1;
var G__35688 = res__$2;
G__35677__$1 = G__35687;
res__$1 = G__35688;
continue;
} else {
var G__35689 = r__$1;
var G__35690 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__35677__$1 = G__35689;
res__$1 = G__35690;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__35693 = clause;
var G__35693__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__35693):G__35693);
var G__35693__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__35693__$1)
;
var G__35693__$3 = (function (){var fexpr__35694 = (function (p1__35691_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35691_SHARP_)," ."].join('');
});
return fexpr__35694(G__35693__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__35695 = (function (p1__35692_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35692_SHARP_),"}"].join('');
});
return fexpr__35695(G__35693__$3);
} else {
return G__35693__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__35699 = opts;
var map__35699__$1 = cljs.core.__destructure_map(map__35699);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35699__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35699__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35699__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35699__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35699__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35696_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35696_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__35697_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__35697_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__35698_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__35698_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4212__auto__ = language;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_35713){
var state_val_35714 = (state_35713[(1)]);
if((state_val_35714 === (1))){
var inst_35700 = fluree.db.util.core.url_encode(query);
var inst_35701 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35700)].join('');
var inst_35702 = ["User-Agent","Accept"];
var inst_35703 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_35704 = cljs.core.PersistentHashMap.fromArrays(inst_35702,inst_35703);
var inst_35705 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_35706 = [inst_35704,(30000),cljs.core.cst$kw$wikidata];
var inst_35707 = cljs.core.PersistentHashMap.fromArrays(inst_35705,inst_35706);
var inst_35708 = fluree.db.util.xhttp.get(inst_35701,inst_35707);
var state_35713__$1 = state_35713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35713__$1,(2),inst_35708);
} else {
if((state_val_35714 === (2))){
var inst_35710 = (state_35713[(2)]);
var inst_35711 = fluree.db.util.async.throw_err(inst_35710);
var state_35713__$1 = state_35713;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35713__$1,inst_35711);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto____0 = (function (){
var statearr_35715 = [null,null,null,null,null,null,null];
(statearr_35715[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto__);

(statearr_35715[(1)] = (1));

return statearr_35715;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto____1 = (function (state_35713){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_35713);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e35716){var ex__16398__auto__ = e35716;
var statearr_35717_35720 = state_35713;
(statearr_35717_35720[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_35713[(4)]))){
var statearr_35718_35721 = state_35713;
(statearr_35718_35721[(1)] = cljs.core.first((state_35713[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__35722 = state_35713;
state_35713 = G__35722;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto__ = function(state_35713){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto____1.call(this,state_35713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_35719 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_35719[(6)] = c__16469__auto__);

return statearr_35719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_35740){
var state_val_35741 = (state_35740[(1)]);
if((state_val_35741 === (1))){
var inst_35723 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_35740__$1 = state_35740;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35740__$1,(2),inst_35723);
} else {
if((state_val_35741 === (2))){
var inst_35726 = (state_35740[(7)]);
var inst_35725 = (state_35740[(2)]);
var inst_35726__$1 = fluree.db.util.async.throw_err(inst_35725);
var inst_35727 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_35726__$1);
var inst_35728 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_35727);
var state_35740__$1 = (function (){var statearr_35742 = state_35740;
(statearr_35742[(7)] = inst_35726__$1);

return statearr_35742;
})();
if(inst_35728){
var statearr_35743_35752 = state_35740__$1;
(statearr_35743_35752[(1)] = (3));

} else {
var statearr_35744_35753 = state_35740__$1;
(statearr_35744_35753[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35741 === (3))){
var inst_35726 = (state_35740[(7)]);
var state_35740__$1 = state_35740;
var statearr_35745_35754 = state_35740__$1;
(statearr_35745_35754[(2)] = inst_35726);

(statearr_35745_35754[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35741 === (4))){
var inst_35726 = (state_35740[(7)]);
var inst_35731 = (function (){var body = inst_35726;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_35732 = cljs.core.second(inst_35726);
var inst_35733 = cljs.core.second(inst_35732);
var inst_35734 = cljs.core.first(inst_35733);
var inst_35735 = cljs.core.second(inst_35734);
var inst_35736 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_35731,inst_35735);
var state_35740__$1 = state_35740;
var statearr_35746_35755 = state_35740__$1;
(statearr_35746_35755[(2)] = inst_35736);

(statearr_35746_35755[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35741 === (5))){
var inst_35738 = (state_35740[(2)]);
var state_35740__$1 = state_35740;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35740__$1,inst_35738);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto____0 = (function (){
var statearr_35747 = [null,null,null,null,null,null,null,null];
(statearr_35747[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto__);

(statearr_35747[(1)] = (1));

return statearr_35747;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto____1 = (function (state_35740){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_35740);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e35748){var ex__16398__auto__ = e35748;
var statearr_35749_35756 = state_35740;
(statearr_35749_35756[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_35740[(4)]))){
var statearr_35750_35757 = state_35740;
(statearr_35750_35757[(1)] = cljs.core.first((state_35740[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__35758 = state_35740;
state_35740 = G__35758;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto__ = function(state_35740){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto____1.call(this,state_35740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_35751 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_35751[(6)] = c__16469__auto__);

return statearr_35751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35759_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35759_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35760_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35760_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35761_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__35761_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__35761_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__35761_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_35807){
var state_val_35808 = (state_35807[(1)]);
if((state_val_35808 === (7))){
var inst_35772 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_35807__$1 = state_35807;
var statearr_35809_35837 = state_35807__$1;
(statearr_35809_35837[(2)] = inst_35772);

(statearr_35809_35837[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (1))){
var state_35807__$1 = state_35807;
var statearr_35810_35838 = state_35807__$1;
(statearr_35810_35838[(2)] = null);

(statearr_35810_35838[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (4))){
var inst_35762 = (state_35807[(2)]);
var state_35807__$1 = state_35807;
var statearr_35811_35839 = state_35807__$1;
(statearr_35811_35839[(2)] = inst_35762);

(statearr_35811_35839[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (15))){
var inst_35781 = (state_35807[(7)]);
var inst_35780 = (state_35807[(8)]);
var inst_35786 = (state_35807[(9)]);
var inst_35791 = (state_35807[(2)]);
var inst_35792 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_35786,(0),inst_35791);
var inst_35793 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35794 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_35780);
var inst_35795 = [inst_35781,inst_35794];
var inst_35796 = cljs.core.PersistentHashMap.fromArrays(inst_35793,inst_35795);
var inst_35797 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35792,inst_35796);
var inst_35798 = (function(){throw inst_35797})();
var state_35807__$1 = state_35807;
var statearr_35812_35840 = state_35807__$1;
(statearr_35812_35840[(2)] = inst_35798);

(statearr_35812_35840[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (13))){
var inst_35785 = (state_35807[(10)]);
var state_35807__$1 = state_35807;
var statearr_35813_35841 = state_35807__$1;
(statearr_35813_35841[(2)] = inst_35785);

(statearr_35813_35841[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (6))){
var state_35807__$1 = state_35807;
var statearr_35814_35842 = state_35807__$1;
(statearr_35814_35842[(2)] = null);

(statearr_35814_35842[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (3))){
var inst_35805 = (state_35807[(2)]);
var state_35807__$1 = state_35807;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35807__$1,inst_35805);
} else {
if((state_val_35808 === (12))){
var inst_35802 = (state_35807[(2)]);
var _ = (function (){var statearr_35815 = state_35807;
(statearr_35815[(4)] = cljs.core.rest((state_35807[(4)])));

return statearr_35815;
})();
var state_35807__$1 = state_35807;
var statearr_35816_35843 = state_35807__$1;
(statearr_35816_35843[(2)] = inst_35802);

(statearr_35816_35843[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (2))){
var _ = (function (){var statearr_35817 = state_35807;
(statearr_35817[(4)] = cljs.core.cons((5),(state_35807[(4)])));

return statearr_35817;
})();
var inst_35769 = cljs.core.empty_QMARK_(matching_vars);
var state_35807__$1 = state_35807;
if(inst_35769){
var statearr_35818_35844 = state_35807__$1;
(statearr_35818_35844[(1)] = (6));

} else {
var statearr_35819_35845 = state_35807__$1;
(statearr_35819_35845[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (11))){
var inst_35780 = (state_35807[(8)]);
var inst_35800 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_35780,all_vars);
var state_35807__$1 = state_35807;
var statearr_35821_35846 = state_35807__$1;
(statearr_35821_35846[(2)] = inst_35800);

(statearr_35821_35846[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (9))){
var inst_35781 = (state_35807[(7)]);
var inst_35780 = (state_35807[(8)]);
var inst_35778 = (state_35807[(2)]);
var inst_35779 = fluree.db.util.async.throw_err(inst_35778);
var inst_35780__$1 = cljs.core.__destructure_map(inst_35779);
var inst_35781__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35780__$1,cljs.core.cst$kw$status);
var inst_35782 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35780__$1,cljs.core.cst$kw$message);
var inst_35783 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_35781__$1);
var state_35807__$1 = (function (){var statearr_35822 = state_35807;
(statearr_35822[(7)] = inst_35781__$1);

(statearr_35822[(11)] = inst_35782);

(statearr_35822[(8)] = inst_35780__$1);

return statearr_35822;
})();
if(inst_35783){
var statearr_35823_35847 = state_35807__$1;
(statearr_35823_35847[(1)] = (10));

} else {
var statearr_35824_35848 = state_35807__$1;
(statearr_35824_35848[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (5))){
var _ = (function (){var statearr_35825 = state_35807;
(statearr_35825[(4)] = cljs.core.rest((state_35807[(4)])));

return statearr_35825;
})();
var state_35807__$1 = state_35807;
var ex35820 = (state_35807__$1[(2)]);
var statearr_35826_35849 = state_35807__$1;
(statearr_35826_35849[(5)] = ex35820);


if((ex35820 instanceof Error)){
var statearr_35827_35850 = state_35807__$1;
(statearr_35827_35850[(1)] = (4));

(statearr_35827_35850[(5)] = null);

} else {
throw ex35820;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (14))){
var state_35807__$1 = state_35807;
var statearr_35828_35851 = state_35807__$1;
(statearr_35828_35851[(2)] = (1000));

(statearr_35828_35851[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (10))){
var inst_35782 = (state_35807[(11)]);
var inst_35780 = (state_35807[(8)]);
var inst_35785 = (state_35807[(10)]);
var inst_35785__$1 = cljs.core.count(inst_35782);
var inst_35786 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_35780);
var inst_35787 = (inst_35785__$1 < (1000));
var state_35807__$1 = (function (){var statearr_35829 = state_35807;
(statearr_35829[(9)] = inst_35786);

(statearr_35829[(10)] = inst_35785__$1);

return statearr_35829;
})();
if(cljs.core.truth_(inst_35787)){
var statearr_35830_35852 = state_35807__$1;
(statearr_35830_35852[(1)] = (13));

} else {
var statearr_35831_35853 = state_35807__$1;
(statearr_35831_35853[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35808 === (8))){
var inst_35774 = (state_35807[(2)]);
var inst_35775 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_35774,optional_clauses);
var inst_35776 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_35775);
var state_35807__$1 = state_35807;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35807__$1,(9),inst_35776);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto____0 = (function (){
var statearr_35832 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35832[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto__);

(statearr_35832[(1)] = (1));

return statearr_35832;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto____1 = (function (state_35807){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_35807);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e35833){var ex__16398__auto__ = e35833;
var statearr_35834_35854 = state_35807;
(statearr_35834_35854[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_35807[(4)]))){
var statearr_35835_35855 = state_35807;
(statearr_35835_35855[(1)] = cljs.core.first((state_35807[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__35856 = state_35807;
state_35807 = G__35856;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto__ = function(state_35807){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto____1.call(this,state_35807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_35836 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_35836[(6)] = c__16469__auto__);

return statearr_35836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
