// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__34479 = arguments.length;
switch (G__34479) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__34482 = arguments.length;
switch (G__34482) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___34535 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34513){
var state_val_34514 = (state_34513[(1)]);
if((state_val_34514 === (1))){
var state_34513__$1 = state_34513;
var statearr_34515_34536 = state_34513__$1;
(statearr_34515_34536[(2)] = null);

(statearr_34515_34536[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34514 === (2))){
var _ = (function (){var statearr_34516 = state_34513;
(statearr_34516[(4)] = cljs.core.cons((5),(state_34513[(4)])));

return statearr_34516;
})();
var inst_34490 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_34513__$1 = state_34513;
if(cljs.core.truth_(inst_34490)){
var statearr_34517_34537 = state_34513__$1;
(statearr_34517_34537[(1)] = (6));

} else {
var statearr_34518_34538 = state_34513__$1;
(statearr_34518_34538[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34514 === (3))){
var inst_34511 = (state_34513[(2)]);
var state_34513__$1 = state_34513;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34513__$1,inst_34511);
} else {
if((state_val_34514 === (4))){
var inst_34483 = (state_34513[(2)]);
var inst_34484 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_34483);
var state_34513__$1 = state_34513;
var statearr_34520_34539 = state_34513__$1;
(statearr_34520_34539[(2)] = inst_34484);

(statearr_34520_34539[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34514 === (5))){
var _ = (function (){var statearr_34521 = state_34513;
(statearr_34521[(4)] = cljs.core.rest((state_34513[(4)])));

return statearr_34521;
})();
var state_34513__$1 = state_34513;
var ex34519 = (state_34513__$1[(2)]);
var statearr_34522_34540 = state_34513__$1;
(statearr_34522_34540[(5)] = ex34519);


var statearr_34523_34541 = state_34513__$1;
(statearr_34523_34541[(1)] = (4));

(statearr_34523_34541[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_34514 === (6))){
var inst_34492 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34493 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_34494 = cljs.core.PersistentHashMap.fromArrays(inst_34492,inst_34493);
var inst_34495 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_34494);
var inst_34496 = (function(){throw inst_34495})();
var state_34513__$1 = state_34513;
var statearr_34524_34542 = state_34513__$1;
(statearr_34524_34542[(2)] = inst_34496);

(statearr_34524_34542[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34514 === (7))){
var inst_34498 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_34499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34500 = [operation,data,pc,opts];
var inst_34501 = (new cljs.core.PersistentVector(null,4,(5),inst_34499,inst_34500,null));
var inst_34502 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_34498,inst_34501);
var inst_34503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34504 = [operation,data,pc,opts];
var inst_34505 = (new cljs.core.PersistentVector(null,4,(5),inst_34503,inst_34504,null));
var inst_34506 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_34505], 0));
var state_34513__$1 = (function (){var statearr_34525 = state_34513;
(statearr_34525[(7)] = inst_34502);

return statearr_34525;
})();
var statearr_34526_34543 = state_34513__$1;
(statearr_34526_34543[(2)] = inst_34506);

(statearr_34526_34543[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34514 === (8))){
var inst_34508 = (state_34513[(2)]);
var _ = (function (){var statearr_34527 = state_34513;
(statearr_34527[(4)] = cljs.core.rest((state_34513[(4)])));

return statearr_34527;
})();
var state_34513__$1 = state_34513;
var statearr_34528_34544 = state_34513__$1;
(statearr_34528_34544[(2)] = inst_34508);

(statearr_34528_34544[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__16395__auto__ = null;
var fluree$db$operations$state_machine__16395__auto____0 = (function (){
var statearr_34529 = [null,null,null,null,null,null,null,null];
(statearr_34529[(0)] = fluree$db$operations$state_machine__16395__auto__);

(statearr_34529[(1)] = (1));

return statearr_34529;
});
var fluree$db$operations$state_machine__16395__auto____1 = (function (state_34513){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34513);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34530){var ex__16398__auto__ = e34530;
var statearr_34531_34545 = state_34513;
(statearr_34531_34545[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34513[(4)]))){
var statearr_34532_34546 = state_34513;
(statearr_34532_34546[(1)] = cljs.core.first((state_34513[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34547 = state_34513;
state_34513 = G__34547;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$operations$state_machine__16395__auto__ = function(state_34513){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__16395__auto____1.call(this,state_34513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__16395__auto____0;
fluree$db$operations$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__16395__auto____1;
return fluree$db$operations$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34533 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34533[(6)] = c__16469__auto___34535);

return statearr_34533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__34549 = arguments.length;
switch (G__34549) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__34550){
var map__34551 = p__34550;
var map__34551__$1 = cljs.core.__destructure_map(map__34551);
var opts = map__34551__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34551__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__34552 = session;
var map__34552__$1 = cljs.core.__destructure_map(map__34552);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34552__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34552__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34552__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4824__auto__ = [];
var len__4818__auto___34579 = arguments.length;
var i__4819__auto___34580 = (0);
while(true){
if((i__4819__auto___34580 < len__4818__auto___34579)){
args__4824__auto__.push((arguments[i__4819__auto___34580]));

var G__34581 = (i__4819__auto___34580 + (1));
i__4819__auto___34580 = G__34581;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__34556){
var vec__34557 = p__34556;
var map__34560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34557,(0),null);
var map__34560__$1 = cljs.core.__destructure_map(map__34560);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34560__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34560__$1,cljs.core.cst$kw$toTime);
var opts = vec__34557;
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34572){
var state_val_34573 = (state_34572[(1)]);
if((state_val_34573 === (1))){
var inst_34562 = session;
var inst_34563 = cljs.core.__destructure_map(inst_34562);
var inst_34564 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34563,cljs.core.cst$kw$network);
var inst_34565 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34563,cljs.core.cst$kw$dbid);
var inst_34566 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34563,cljs.core.cst$kw$conn);
var inst_34567 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_34568 = [inst_34564,inst_34565,toBlock,toTime];
var inst_34569 = cljs.core.PersistentHashMap.fromArrays(inst_34567,inst_34568);
var inst_34570 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_34566,cljs.core.cst$kw$garbage,inst_34569);
var state_34572__$1 = state_34572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34572__$1,inst_34570);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__16395__auto__ = null;
var fluree$db$operations$state_machine__16395__auto____0 = (function (){
var statearr_34574 = [null,null,null,null,null,null,null];
(statearr_34574[(0)] = fluree$db$operations$state_machine__16395__auto__);

(statearr_34574[(1)] = (1));

return statearr_34574;
});
var fluree$db$operations$state_machine__16395__auto____1 = (function (state_34572){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34572);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34575){var ex__16398__auto__ = e34575;
var statearr_34576_34582 = state_34572;
(statearr_34576_34582[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34572[(4)]))){
var statearr_34577_34583 = state_34572;
(statearr_34577_34583[(1)] = cljs.core.first((state_34572[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34584 = state_34572;
state_34572 = G__34584;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$operations$state_machine__16395__auto__ = function(state_34572){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__16395__auto____1.call(this,state_34572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__16395__auto____0;
fluree$db$operations$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__16395__auto____1;
return fluree$db$operations$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34578 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34578[(6)] = c__16469__auto__);

return statearr_34578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq34554){
var G__34555 = cljs.core.first(seq34554);
var seq34554__$1 = cljs.core.next(seq34554);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34555,seq34554__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__34585 = session;
var map__34585__$1 = cljs.core.__destructure_map(map__34585);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34585__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34585__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34585__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__34587 = arguments.length;
switch (G__34587) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__34588 = opts;
var map__34588__$1 = cljs.core.__destructure_map(map__34588);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34588__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34588__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4212__auto__ = auth;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
