// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k32687,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__32691 = k32687;
var G__32691__$1 = (((G__32691 instanceof cljs.core.Keyword))?G__32691.fqn:null);
switch (G__32691__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32687,else__4464__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__32692){
var vec__32693 = p__32692;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32693,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32693,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32686){
var self__ = this;
var G__32686__$1 = this;
return (new cljs.core.RecordIter((0),G__32686__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__32696 = (function (coll__4458__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__32696(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32688,other32689){
var self__ = this;
var this32688__$1 = this;
return (((!((other32689 == null)))) && ((((this32688__$1.constructor === other32689.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32688__$1.index_type,other32689.index_type)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32688__$1.comparator,other32689.comparator)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32688__$1.historyComparator,other32689.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32688__$1.__extmap,other32689.__extmap)))))))))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k32687){
var self__ = this;
var this__4468__auto____$1 = this;
var G__32697 = k32687;
var G__32697__$1 = (((G__32697 instanceof cljs.core.Keyword))?G__32697.fqn:null);
switch (G__32697__$1) {
case "index-type":
case "comparator":
case "historyComparator":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k32687);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__32686){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__32698 = cljs.core.keyword_identical_QMARK_;
var expr__32699 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__32701 = cljs.core.cst$kw$index_DASH_type;
var G__32702 = expr__32699;
return (pred__32698.cljs$core$IFn$_invoke$arity$2 ? pred__32698.cljs$core$IFn$_invoke$arity$2(G__32701,G__32702) : pred__32698.call(null,G__32701,G__32702));
})())){
return (new fluree.db.index.IndexConfig(G__32686,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32703 = cljs.core.cst$kw$comparator;
var G__32704 = expr__32699;
return (pred__32698.cljs$core$IFn$_invoke$arity$2 ? pred__32698.cljs$core$IFn$_invoke$arity$2(G__32703,G__32704) : pred__32698.call(null,G__32703,G__32704));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__32686,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32705 = cljs.core.cst$kw$historyComparator;
var G__32706 = expr__32699;
return (pred__32698.cljs$core$IFn$_invoke$arity$2 ? pred__32698.cljs$core$IFn$_invoke$arity$2(G__32705,G__32706) : pred__32698.call(null,G__32705,G__32706));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__32686,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__32686),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__32686){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__32686,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__32690){
var extmap__4501__auto__ = (function (){var G__32707 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32690,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__32690)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32707);
} else {
return G__32707;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__32690),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__32690),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__32690),null,cljs.core.not_empty(extmap__4501__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k32711,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__32715 = k32711;
var G__32715__$1 = (((G__32715 instanceof cljs.core.Keyword))?G__32715.fqn:null);
switch (G__32715__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32711,else__4464__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__32716){
var vec__32717 = p__32716;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32717,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32717,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32710){
var self__ = this;
var G__32710__$1 = this;
return (new cljs.core.RecordIter((0),G__32710__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32721){
var state_val_32722 = (state_32721[(1)]);
if((state_val_32722 === (1))){
var state_32721__$1 = state_32721;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32721__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__16395__auto__ = null;
var fluree$db$index$state_machine__16395__auto____0 = (function (){
var statearr_32723 = [null,null,null,null,null,null,null];
(statearr_32723[(0)] = fluree$db$index$state_machine__16395__auto__);

(statearr_32723[(1)] = (1));

return statearr_32723;
});
var fluree$db$index$state_machine__16395__auto____1 = (function (state_32721){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32721);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32724){var ex__16398__auto__ = e32724;
var statearr_32725_32837 = state_32721;
(statearr_32725_32837[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32721[(4)]))){
var statearr_32726_32838 = state_32721;
(statearr_32726_32838[(1)] = cljs.core.first((state_32721[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32839 = state_32721;
state_32721 = G__32839;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$index$state_machine__16395__auto__ = function(state_32721){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16395__auto____1.call(this,state_32721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16395__auto____0;
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16395__auto____1;
return fluree$db$index$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32727 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32727[(6)] = c__16469__auto__);

return statearr_32727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4212__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4212__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32752){
var state_val_32753 = (state_32752[(1)]);
if((state_val_32753 === (7))){
var inst_32734 = (state_32752[(7)]);
var inst_32738 = fluree.db.dbproto._resolve(inst_32734);
var state_32752__$1 = state_32752;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32752__$1,(10),inst_32738);
} else {
if((state_val_32753 === (1))){
var state_32752__$1 = state_32752;
var statearr_32754_32840 = state_32752__$1;
(statearr_32754_32840[(2)] = null);

(statearr_32754_32840[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32753 === (4))){
var inst_32728 = (state_32752[(2)]);
var state_32752__$1 = state_32752;
var statearr_32755_32841 = state_32752__$1;
(statearr_32755_32841[(2)] = inst_32728);

(statearr_32755_32841[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32753 === (6))){
var inst_32734 = (state_32752[(7)]);
var state_32752__$1 = state_32752;
var statearr_32756_32842 = state_32752__$1;
(statearr_32756_32842[(2)] = inst_32734);

(statearr_32756_32842[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32753 === (3))){
var inst_32750 = (state_32752[(2)]);
var state_32752__$1 = state_32752;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32752__$1,inst_32750);
} else {
if((state_val_32753 === (2))){
var inst_32734 = (state_32752[(7)]);
var _ = (function (){var statearr_32758 = state_32752;
(statearr_32758[(4)] = cljs.core.cons((5),(state_32752[(4)])));

return statearr_32758;
})();
var inst_32734__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_32735 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_32734__$1);
var state_32752__$1 = (function (){var statearr_32759 = state_32752;
(statearr_32759[(7)] = inst_32734__$1);

return statearr_32759;
})();
if(cljs.core.truth_(inst_32735)){
var statearr_32760_32843 = state_32752__$1;
(statearr_32760_32843[(1)] = (6));

} else {
var statearr_32761_32844 = state_32752__$1;
(statearr_32761_32844[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32753 === (9))){
var inst_32744 = (state_32752[(2)]);
var inst_32745 = fluree.db.util.async.throw_err(inst_32744);
var state_32752__$1 = state_32752;
var statearr_32762_32845 = state_32752__$1;
(statearr_32762_32845[(2)] = inst_32745);

(statearr_32762_32845[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32753 === (5))){
var _ = (function (){var statearr_32763 = state_32752;
(statearr_32763[(4)] = cljs.core.rest((state_32752[(4)])));

return statearr_32763;
})();
var state_32752__$1 = state_32752;
var ex32757 = (state_32752__$1[(2)]);
var statearr_32764_32846 = state_32752__$1;
(statearr_32764_32846[(5)] = ex32757);


if((ex32757 instanceof Error)){
var statearr_32765_32847 = state_32752__$1;
(statearr_32765_32847[(1)] = (4));

(statearr_32765_32847[(5)] = null);

} else {
throw ex32757;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32753 === (10))){
var inst_32740 = (state_32752[(2)]);
var inst_32741 = fluree.db.util.async.throw_err(inst_32740);
var inst_32742 = fluree.db.dbproto._lookup_leaf(inst_32741,flake);
var state_32752__$1 = state_32752;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32752__$1,(9),inst_32742);
} else {
if((state_val_32753 === (8))){
var inst_32747 = (state_32752[(2)]);
var _ = (function (){var statearr_32766 = state_32752;
(statearr_32766[(4)] = cljs.core.rest((state_32752[(4)])));

return statearr_32766;
})();
var state_32752__$1 = state_32752;
var statearr_32767_32848 = state_32752__$1;
(statearr_32767_32848[(2)] = inst_32747);

(statearr_32767_32848[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__16395__auto__ = null;
var fluree$db$index$state_machine__16395__auto____0 = (function (){
var statearr_32768 = [null,null,null,null,null,null,null,null];
(statearr_32768[(0)] = fluree$db$index$state_machine__16395__auto__);

(statearr_32768[(1)] = (1));

return statearr_32768;
});
var fluree$db$index$state_machine__16395__auto____1 = (function (state_32752){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32752);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32769){var ex__16398__auto__ = e32769;
var statearr_32770_32849 = state_32752;
(statearr_32770_32849[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32752[(4)]))){
var statearr_32771_32850 = state_32752;
(statearr_32771_32850[(1)] = cljs.core.first((state_32752[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32851 = state_32752;
state_32752 = G__32851;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$index$state_machine__16395__auto__ = function(state_32752){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16395__auto____1.call(this,state_32752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16395__auto____0;
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16395__auto____1;
return fluree$db$index$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32772 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32772[(6)] = c__16469__auto__);

return statearr_32772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32797){
var state_val_32798 = (state_32797[(1)]);
if((state_val_32798 === (7))){
var inst_32779 = (state_32797[(7)]);
var inst_32783 = fluree.db.dbproto._resolve(inst_32779);
var state_32797__$1 = state_32797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32797__$1,(10),inst_32783);
} else {
if((state_val_32798 === (1))){
var state_32797__$1 = state_32797;
var statearr_32799_32852 = state_32797__$1;
(statearr_32799_32852[(2)] = null);

(statearr_32799_32852[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32798 === (4))){
var inst_32773 = (state_32797[(2)]);
var state_32797__$1 = state_32797;
var statearr_32800_32853 = state_32797__$1;
(statearr_32800_32853[(2)] = inst_32773);

(statearr_32800_32853[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32798 === (6))){
var inst_32779 = (state_32797[(7)]);
var state_32797__$1 = state_32797;
var statearr_32801_32854 = state_32797__$1;
(statearr_32801_32854[(2)] = inst_32779);

(statearr_32801_32854[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32798 === (3))){
var inst_32795 = (state_32797[(2)]);
var state_32797__$1 = state_32797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32797__$1,inst_32795);
} else {
if((state_val_32798 === (2))){
var inst_32779 = (state_32797[(7)]);
var _ = (function (){var statearr_32803 = state_32797;
(statearr_32803[(4)] = cljs.core.cons((5),(state_32797[(4)])));

return statearr_32803;
})();
var inst_32779__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_32780 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_32779__$1);
var state_32797__$1 = (function (){var statearr_32804 = state_32797;
(statearr_32804[(7)] = inst_32779__$1);

return statearr_32804;
})();
if(cljs.core.truth_(inst_32780)){
var statearr_32805_32855 = state_32797__$1;
(statearr_32805_32855[(1)] = (6));

} else {
var statearr_32806_32856 = state_32797__$1;
(statearr_32806_32856[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32798 === (9))){
var inst_32789 = (state_32797[(2)]);
var inst_32790 = fluree.db.util.async.throw_err(inst_32789);
var state_32797__$1 = state_32797;
var statearr_32807_32857 = state_32797__$1;
(statearr_32807_32857[(2)] = inst_32790);

(statearr_32807_32857[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32798 === (5))){
var _ = (function (){var statearr_32808 = state_32797;
(statearr_32808[(4)] = cljs.core.rest((state_32797[(4)])));

return statearr_32808;
})();
var state_32797__$1 = state_32797;
var ex32802 = (state_32797__$1[(2)]);
var statearr_32809_32858 = state_32797__$1;
(statearr_32809_32858[(5)] = ex32802);


if((ex32802 instanceof Error)){
var statearr_32810_32859 = state_32797__$1;
(statearr_32810_32859[(1)] = (4));

(statearr_32810_32859[(5)] = null);

} else {
throw ex32802;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32798 === (10))){
var inst_32785 = (state_32797[(2)]);
var inst_32786 = fluree.db.util.async.throw_err(inst_32785);
var inst_32787 = fluree.db.dbproto._lookup_leaf_after(inst_32786,flake);
var state_32797__$1 = state_32797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32797__$1,(9),inst_32787);
} else {
if((state_val_32798 === (8))){
var inst_32792 = (state_32797[(2)]);
var _ = (function (){var statearr_32811 = state_32797;
(statearr_32811[(4)] = cljs.core.rest((state_32797[(4)])));

return statearr_32811;
})();
var state_32797__$1 = state_32797;
var statearr_32812_32860 = state_32797__$1;
(statearr_32812_32860[(2)] = inst_32792);

(statearr_32812_32860[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__16395__auto__ = null;
var fluree$db$index$state_machine__16395__auto____0 = (function (){
var statearr_32813 = [null,null,null,null,null,null,null,null];
(statearr_32813[(0)] = fluree$db$index$state_machine__16395__auto__);

(statearr_32813[(1)] = (1));

return statearr_32813;
});
var fluree$db$index$state_machine__16395__auto____1 = (function (state_32797){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32797);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32814){var ex__16398__auto__ = e32814;
var statearr_32815_32861 = state_32797;
(statearr_32815_32861[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32797[(4)]))){
var statearr_32816_32862 = state_32797;
(statearr_32816_32862[(1)] = cljs.core.first((state_32797[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32863 = state_32797;
state_32797 = G__32863;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$index$state_machine__16395__auto__ = function(state_32797){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16395__auto____1.call(this,state_32797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16395__auto____0;
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16395__auto____1;
return fluree$db$index$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32817 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32817[(6)] = c__16469__auto__);

return statearr_32817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__32818 = (function (coll__4458__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__32818(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32712,other32713){
var self__ = this;
var this32712__$1 = this;
return (((!((other32713 == null)))) && ((((this32712__$1.constructor === other32713.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32712__$1.block,other32713.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32712__$1.t,other32713.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32712__$1.rhs,other32713.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32712__$1.children,other32713.children)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32712__$1.config,other32713.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32712__$1.leftmost_QMARK_,other32713.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32712__$1.__extmap,other32713.__extmap)))))))))))))))));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k32711){
var self__ = this;
var this__4468__auto____$1 = this;
var G__32819 = k32711;
var G__32819__$1 = (((G__32819 instanceof cljs.core.Keyword))?G__32819.fqn:null);
switch (G__32819__$1) {
case "block":
case "t":
case "rhs":
case "children":
case "config":
case "leftmost?":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k32711);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__32710){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__32820 = cljs.core.keyword_identical_QMARK_;
var expr__32821 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__32823 = cljs.core.cst$kw$block;
var G__32824 = expr__32821;
return (pred__32820.cljs$core$IFn$_invoke$arity$2 ? pred__32820.cljs$core$IFn$_invoke$arity$2(G__32823,G__32824) : pred__32820.call(null,G__32823,G__32824));
})())){
return (new fluree.db.index.IndexNode(G__32710,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32825 = cljs.core.cst$kw$t;
var G__32826 = expr__32821;
return (pred__32820.cljs$core$IFn$_invoke$arity$2 ? pred__32820.cljs$core$IFn$_invoke$arity$2(G__32825,G__32826) : pred__32820.call(null,G__32825,G__32826));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__32710,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32827 = cljs.core.cst$kw$rhs;
var G__32828 = expr__32821;
return (pred__32820.cljs$core$IFn$_invoke$arity$2 ? pred__32820.cljs$core$IFn$_invoke$arity$2(G__32827,G__32828) : pred__32820.call(null,G__32827,G__32828));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__32710,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32829 = cljs.core.cst$kw$children;
var G__32830 = expr__32821;
return (pred__32820.cljs$core$IFn$_invoke$arity$2 ? pred__32820.cljs$core$IFn$_invoke$arity$2(G__32829,G__32830) : pred__32820.call(null,G__32829,G__32830));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__32710,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32831 = cljs.core.cst$kw$config;
var G__32832 = expr__32821;
return (pred__32820.cljs$core$IFn$_invoke$arity$2 ? pred__32820.cljs$core$IFn$_invoke$arity$2(G__32831,G__32832) : pred__32820.call(null,G__32831,G__32832));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__32710,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32833 = cljs.core.cst$kw$leftmost_QMARK_;
var G__32834 = expr__32821;
return (pred__32820.cljs$core$IFn$_invoke$arity$2 ? pred__32820.cljs$core$IFn$_invoke$arity$2(G__32833,G__32834) : pred__32820.call(null,G__32833,G__32834));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__32710,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__32710),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__32710){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__32710,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__32714){
var extmap__4501__auto__ = (function (){var G__32835 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32714,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__32714)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32835);
} else {
return G__32835;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__32714),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__32714),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__32714),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__32714),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__32714),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__32714),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k32866,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__32870 = k32866;
var G__32870__$1 = (((G__32870 instanceof cljs.core.Keyword))?G__32870.fqn:null);
switch (G__32870__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32866,else__4464__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__32871){
var vec__32872 = p__32871;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32872,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32872,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32865){
var self__ = this;
var G__32865__$1 = this;
return (new cljs.core.RecordIter((0),G__32865__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32876){
var state_val_32877 = (state_32876[(1)]);
if((state_val_32877 === (1))){
var state_32876__$1 = state_32876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32876__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__16395__auto__ = null;
var fluree$db$index$state_machine__16395__auto____0 = (function (){
var statearr_32878 = [null,null,null,null,null,null,null];
(statearr_32878[(0)] = fluree$db$index$state_machine__16395__auto__);

(statearr_32878[(1)] = (1));

return statearr_32878;
});
var fluree$db$index$state_machine__16395__auto____1 = (function (state_32876){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32876);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32879){var ex__16398__auto__ = e32879;
var statearr_32880_32912 = state_32876;
(statearr_32880_32912[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32876[(4)]))){
var statearr_32881_32913 = state_32876;
(statearr_32881_32913[(1)] = cljs.core.first((state_32876[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32914 = state_32876;
state_32876 = G__32914;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$index$state_machine__16395__auto__ = function(state_32876){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16395__auto____1.call(this,state_32876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16395__auto____0;
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16395__auto____1;
return fluree$db$index$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32882 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32882[(6)] = c__16469__auto__);

return statearr_32882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32888){
var state_val_32889 = (state_32888[(1)]);
if((state_val_32889 === (1))){
var inst_32883 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32884 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_32885 = cljs.core.PersistentHashMap.fromArrays(inst_32883,inst_32884);
var inst_32886 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_32885);
var state_32888__$1 = state_32888;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32888__$1,inst_32886);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__16395__auto__ = null;
var fluree$db$index$state_machine__16395__auto____0 = (function (){
var statearr_32890 = [null,null,null,null,null,null,null];
(statearr_32890[(0)] = fluree$db$index$state_machine__16395__auto__);

(statearr_32890[(1)] = (1));

return statearr_32890;
});
var fluree$db$index$state_machine__16395__auto____1 = (function (state_32888){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32888);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32891){var ex__16398__auto__ = e32891;
var statearr_32892_32915 = state_32888;
(statearr_32892_32915[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32888[(4)]))){
var statearr_32893_32916 = state_32888;
(statearr_32893_32916[(1)] = cljs.core.first((state_32888[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32917 = state_32888;
state_32888 = G__32917;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$index$state_machine__16395__auto__ = function(state_32888){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16395__auto____1.call(this,state_32888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16395__auto____0;
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16395__auto____1;
return fluree$db$index$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32894 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32894[(6)] = c__16469__auto__);

return statearr_32894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__32895 = (function (coll__4458__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__32895(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32867,other32868){
var self__ = this;
var this32867__$1 = this;
return (((!((other32868 == null)))) && ((((this32867__$1.constructor === other32868.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32867__$1.block,other32868.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32867__$1.t,other32868.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32867__$1.flakes,other32868.flakes)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32867__$1.rhs,other32868.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32867__$1.config,other32868.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32867__$1.__extmap,other32868.__extmap)))))))))))))));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k32866){
var self__ = this;
var this__4468__auto____$1 = this;
var G__32896 = k32866;
var G__32896__$1 = (((G__32896 instanceof cljs.core.Keyword))?G__32896.fqn:null);
switch (G__32896__$1) {
case "block":
case "t":
case "flakes":
case "rhs":
case "config":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k32866);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__32865){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__32897 = cljs.core.keyword_identical_QMARK_;
var expr__32898 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__32900 = cljs.core.cst$kw$block;
var G__32901 = expr__32898;
return (pred__32897.cljs$core$IFn$_invoke$arity$2 ? pred__32897.cljs$core$IFn$_invoke$arity$2(G__32900,G__32901) : pred__32897.call(null,G__32900,G__32901));
})())){
return (new fluree.db.index.DataNode(G__32865,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32902 = cljs.core.cst$kw$t;
var G__32903 = expr__32898;
return (pred__32897.cljs$core$IFn$_invoke$arity$2 ? pred__32897.cljs$core$IFn$_invoke$arity$2(G__32902,G__32903) : pred__32897.call(null,G__32902,G__32903));
})())){
return (new fluree.db.index.DataNode(self__.block,G__32865,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32904 = cljs.core.cst$kw$flakes;
var G__32905 = expr__32898;
return (pred__32897.cljs$core$IFn$_invoke$arity$2 ? pred__32897.cljs$core$IFn$_invoke$arity$2(G__32904,G__32905) : pred__32897.call(null,G__32904,G__32905));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__32865,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32906 = cljs.core.cst$kw$rhs;
var G__32907 = expr__32898;
return (pred__32897.cljs$core$IFn$_invoke$arity$2 ? pred__32897.cljs$core$IFn$_invoke$arity$2(G__32906,G__32907) : pred__32897.call(null,G__32906,G__32907));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__32865,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32908 = cljs.core.cst$kw$config;
var G__32909 = expr__32898;
return (pred__32897.cljs$core$IFn$_invoke$arity$2 ? pred__32897.cljs$core$IFn$_invoke$arity$2(G__32908,G__32909) : pred__32897.call(null,G__32908,G__32909));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__32865,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__32865),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__32865){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__32865,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__32869){
var extmap__4501__auto__ = (function (){var G__32910 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32869,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__32869)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32910);
} else {
return G__32910;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__32869),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__32869),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__32869),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__32869),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__32869),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
