// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44864 = arguments.length;
var i__4819__auto___44865 = (0);
while(true){
if((i__4819__auto___44865 < len__4818__auto___44864)){
args__4824__auto__.push((arguments[i__4819__auto___44865]));

var G__44866 = (i__4819__auto___44865 + (1));
i__4819__auto___44865 = G__44866;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq44861){
var G__44862 = cljs.core.first(seq44861);
var seq44861__$1 = cljs.core.next(seq44861);
var G__44863 = cljs.core.first(seq44861__$1);
var seq44861__$2 = cljs.core.next(seq44861__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44862,G__44863,seq44861__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e44867){var e = e44867;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e44868){var e = e44868;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e44869){var e = e44869;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e44870){var e = e44870;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e44871){var e = e44871;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44874 = arguments.length;
var i__4819__auto___44875 = (0);
while(true){
if((i__4819__auto___44875 < len__4818__auto___44874)){
args__4824__auto__.push((arguments[i__4819__auto___44875]));

var G__44876 = (i__4819__auto___44875 + (1));
i__4819__auto___44875 = G__44876;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e44873){var e = e44873;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq44872){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44872));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44879 = arguments.length;
var i__4819__auto___44880 = (0);
while(true){
if((i__4819__auto___44880 < len__4818__auto___44879)){
args__4824__auto__.push((arguments[i__4819__auto___44880]));

var G__44881 = (i__4819__auto___44880 + (1));
i__4819__auto___44880 = G__44881;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e44878){var e = e44878;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq44877){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44877));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e44882){var e = e44882;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44885 = arguments.length;
var i__4819__auto___44886 = (0);
while(true){
if((i__4819__auto___44886 < len__4818__auto___44885)){
args__4824__auto__.push((arguments[i__4819__auto___44886]));

var G__44887 = (i__4819__auto___44886 + (1));
i__4819__auto___44886 = G__44887;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e44884){var e = e44884;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq44883){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44883));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44890 = arguments.length;
var i__4819__auto___44891 = (0);
while(true){
if((i__4819__auto___44891 < len__4818__auto___44890)){
args__4824__auto__.push((arguments[i__4819__auto___44891]));

var G__44892 = (i__4819__auto___44891 + (1));
i__4819__auto___44891 = G__44892;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e44889){var e = e44889;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq44888){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44888));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e44893){var e = e44893;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e44894){var e = e44894;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44897 = arguments.length;
var i__4819__auto___44898 = (0);
while(true){
if((i__4819__auto___44898 < len__4818__auto___44897)){
args__4824__auto__.push((arguments[i__4819__auto___44898]));

var G__44899 = (i__4819__auto___44898 + (1));
i__4819__auto___44898 = G__44899;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e44896){var e = e44896;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq44895){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44895));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44902 = arguments.length;
var i__4819__auto___44903 = (0);
while(true){
if((i__4819__auto___44903 < len__4818__auto___44902)){
args__4824__auto__.push((arguments[i__4819__auto___44903]));

var G__44904 = (i__4819__auto___44903 + (1));
i__4819__auto___44903 = G__44904;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e44901){var e = e44901;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq44900){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44900));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44907 = arguments.length;
var i__4819__auto___44908 = (0);
while(true){
if((i__4819__auto___44908 < len__4818__auto___44907)){
args__4824__auto__.push((arguments[i__4819__auto___44908]));

var G__44909 = (i__4819__auto___44908 + (1));
i__4819__auto___44908 = G__44909;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e44906){var e = e44906;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq44905){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44905));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44912 = arguments.length;
var i__4819__auto___44913 = (0);
while(true){
if((i__4819__auto___44913 < len__4818__auto___44912)){
args__4824__auto__.push((arguments[i__4819__auto___44913]));

var G__44914 = (i__4819__auto___44913 + (1));
i__4819__auto___44913 = G__44914;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e44911){var e = e44911;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq44910){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44910));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44917 = arguments.length;
var i__4819__auto___44918 = (0);
while(true){
if((i__4819__auto___44918 < len__4818__auto___44917)){
args__4824__auto__.push((arguments[i__4819__auto___44918]));

var G__44919 = (i__4819__auto___44918 + (1));
i__4819__auto___44918 = G__44919;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e44916){var e = e44916;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq44915){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44915));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44922 = arguments.length;
var i__4819__auto___44923 = (0);
while(true){
if((i__4819__auto___44923 < len__4818__auto___44922)){
args__4824__auto__.push((arguments[i__4819__auto___44923]));

var G__44924 = (i__4819__auto___44923 + (1));
i__4819__auto___44923 = G__44924;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e44921){var e = e44921;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq44920){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44920));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44927 = arguments.length;
var i__4819__auto___44928 = (0);
while(true){
if((i__4819__auto___44928 < len__4818__auto___44927)){
args__4824__auto__.push((arguments[i__4819__auto___44928]));

var G__44929 = (i__4819__auto___44928 + (1));
i__4819__auto___44928 = G__44929;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e44926){var e = e44926;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq44925){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44925));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__44931 = arguments.length;
switch (G__44931) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_44959){
var state_val_44960 = (state_44959[(1)]);
if((state_val_44960 === (7))){
var inst_44944 = (state_44959[(7)]);
var inst_44947 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44944,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_44959__$1 = state_44959;
var statearr_44961_45047 = state_44959__$1;
(statearr_44961_45047[(2)] = inst_44947);

(statearr_44961_45047[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44960 === (1))){
var state_44959__$1 = state_44959;
var statearr_44962_45048 = state_44959__$1;
(statearr_44962_45048[(2)] = null);

(statearr_44962_45048[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44960 === (4))){
var inst_44932 = (state_44959[(2)]);
var state_44959__$1 = state_44959;
var statearr_44963_45049 = state_44959__$1;
(statearr_44963_45049[(2)] = inst_44932);

(statearr_44963_45049[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44960 === (6))){
var inst_44944 = (state_44959[(7)]);
var inst_44944__$1 = (state_44959[(2)]);
var inst_44945 = fluree.db.util.core.exception_QMARK_(inst_44944__$1);
var state_44959__$1 = (function (){var statearr_44964 = state_44959;
(statearr_44964[(7)] = inst_44944__$1);

return statearr_44964;
})();
if(inst_44945){
var statearr_44965_45050 = state_44959__$1;
(statearr_44965_45050[(1)] = (7));

} else {
var statearr_44966_45051 = state_44959__$1;
(statearr_44966_45051[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44960 === (3))){
var inst_44957 = (state_44959[(2)]);
var state_44959__$1 = state_44959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44959__$1,inst_44957);
} else {
if((state_val_44960 === (2))){
var inst_44938 = (state_44959[(8)]);
var _ = (function (){var statearr_44968 = state_44959;
(statearr_44968[(4)] = cljs.core.cons((5),(state_44959[(4)])));

return statearr_44968;
})();
var inst_44938__$1 = cljs.core.volatile_BANG_((0));
var inst_44939 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_44940 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_44939,cljs.core.cst$kw$fuel,inst_44938__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_44941 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_44940);
var inst_44942 = fluree.db.query.fql.query(db,inst_44941);
var state_44959__$1 = (function (){var statearr_44969 = state_44959;
(statearr_44969[(8)] = inst_44938__$1);

return statearr_44969;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44959__$1,(6),inst_44942);
} else {
if((state_val_44960 === (9))){
var inst_44954 = (state_44959[(2)]);
var _ = (function (){var statearr_44970 = state_44959;
(statearr_44970[(4)] = cljs.core.rest((state_44959[(4)])));

return statearr_44970;
})();
var state_44959__$1 = state_44959;
var statearr_44971_45052 = state_44959__$1;
(statearr_44971_45052[(2)] = inst_44954);

(statearr_44971_45052[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44960 === (5))){
var _ = (function (){var statearr_44972 = state_44959;
(statearr_44972[(4)] = cljs.core.rest((state_44959[(4)])));

return statearr_44972;
})();
var state_44959__$1 = state_44959;
var ex44967 = (state_44959__$1[(2)]);
var statearr_44973_45053 = state_44959__$1;
(statearr_44973_45053[(5)] = ex44967);


if((ex44967 instanceof Error)){
var statearr_44974_45054 = state_44959__$1;
(statearr_44974_45054[(1)] = (4));

(statearr_44974_45054[(5)] = null);

} else {
throw ex44967;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44960 === (8))){
var inst_44938 = (state_44959[(8)]);
var inst_44944 = (state_44959[(7)]);
var inst_44949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44950 = cljs.core.deref(inst_44938);
var inst_44951 = [inst_44944,inst_44950];
var inst_44952 = (new cljs.core.PersistentVector(null,2,(5),inst_44949,inst_44951,null));
var state_44959__$1 = state_44959;
var statearr_44975_45055 = state_44959__$1;
(statearr_44975_45055[(2)] = inst_44952);

(statearr_44975_45055[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16395__auto____0 = (function (){
var statearr_44976 = [null,null,null,null,null,null,null,null,null];
(statearr_44976[(0)] = fluree$db$dbfunctions$internal$state_machine__16395__auto__);

(statearr_44976[(1)] = (1));

return statearr_44976;
});
var fluree$db$dbfunctions$internal$state_machine__16395__auto____1 = (function (state_44959){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_44959);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e44977){var ex__16398__auto__ = e44977;
var statearr_44978_45056 = state_44959;
(statearr_44978_45056[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_44959[(4)]))){
var statearr_44979_45057 = state_44959;
(statearr_44979_45057[(1)] = cljs.core.first((state_44959[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45058 = state_44959;
state_44959 = G__45058;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16395__auto__ = function(state_44959){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____1.call(this,state_44959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_44980 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_44980[(6)] = c__16469__auto__);

return statearr_44980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45025){
var state_val_45026 = (state_45025[(1)]);
if((state_val_45026 === (7))){
var inst_45011 = (state_45025[(2)]);
var inst_45012 = fluree.db.query.fql.query(db,inst_45011);
var state_45025__$1 = state_45025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45025__$1,(8),inst_45012);
} else {
if((state_val_45026 === (1))){
var inst_44981 = typeof select === 'string';
var state_45025__$1 = state_45025;
if(cljs.core.truth_(inst_44981)){
var statearr_45027_45059 = state_45025__$1;
(statearr_45027_45059[(1)] = (2));

} else {
var statearr_45028_45060 = state_45025__$1;
(statearr_45028_45060[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45026 === (4))){
var inst_44987 = (state_45025[(7)]);
var inst_44994 = (state_45025[(8)]);
var inst_44986 = (state_45025[(2)]);
var inst_44987__$1 = cljs.core.volatile_BANG_((0));
var inst_44988 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_44989 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_44990 = [inst_44987__$1,(100000)];
var inst_44991 = cljs.core.PersistentHashMap.fromArrays(inst_44989,inst_44990);
var inst_44992 = [inst_44986,from,where,block,limit,inst_44991];
var inst_44993 = cljs.core.PersistentHashMap.fromArrays(inst_44988,inst_44992);
var inst_44994__$1 = fluree.db.util.core.without_nils(inst_44993);
var inst_44995 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44994__$1);
var inst_44996 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44994__$1);
var inst_44997 = cljs.core.first(inst_44996);
var inst_44998 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44997], 0));
var inst_44999 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_44998);
var inst_45000 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44994__$1);
var inst_45001 = cljs.core.last(inst_45000);
var inst_45002 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_45001], 0));
var inst_45003 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_45002);
var inst_45004 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44995,inst_44999,inst_45003], 0));
var state_45025__$1 = (function (){var statearr_45029 = state_45025;
(statearr_45029[(7)] = inst_44987__$1);

(statearr_45029[(8)] = inst_44994__$1);

return statearr_45029;
})();
if(cljs.core.truth_(inst_45004)){
var statearr_45030_45061 = state_45025__$1;
(statearr_45030_45061[(1)] = (5));

} else {
var statearr_45031_45062 = state_45025__$1;
(statearr_45031_45062[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45026 === (6))){
var inst_44994 = (state_45025[(8)]);
var state_45025__$1 = state_45025;
var statearr_45032_45063 = state_45025__$1;
(statearr_45032_45063[(2)] = inst_44994);

(statearr_45032_45063[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45026 === (3))){
var state_45025__$1 = state_45025;
var statearr_45033_45064 = state_45025__$1;
(statearr_45033_45064[(2)] = select);

(statearr_45033_45064[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45026 === (2))){
var inst_44983 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_45025__$1 = state_45025;
var statearr_45034_45065 = state_45025__$1;
(statearr_45034_45065[(2)] = inst_44983);

(statearr_45034_45065[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45026 === (11))){
var inst_45023 = (state_45025[(2)]);
var state_45025__$1 = state_45025;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45025__$1,inst_45023);
} else {
if((state_val_45026 === (9))){
var inst_45014 = (state_45025[(9)]);
var state_45025__$1 = state_45025;
var statearr_45035_45066 = state_45025__$1;
(statearr_45035_45066[(2)] = inst_45014);

(statearr_45035_45066[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45026 === (5))){
var inst_44994 = (state_45025[(8)]);
var inst_45006 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44994);
var inst_45007 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_45006);
var inst_45008 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_44994,cljs.core.cst$kw$where,inst_45007);
var state_45025__$1 = state_45025;
var statearr_45036_45067 = state_45025__$1;
(statearr_45036_45067[(2)] = inst_45008);

(statearr_45036_45067[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45026 === (10))){
var inst_44987 = (state_45025[(7)]);
var inst_45014 = (state_45025[(9)]);
var inst_45018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45019 = cljs.core.deref(inst_44987);
var inst_45020 = [inst_45014,inst_45019];
var inst_45021 = (new cljs.core.PersistentVector(null,2,(5),inst_45018,inst_45020,null));
var state_45025__$1 = state_45025;
var statearr_45037_45068 = state_45025__$1;
(statearr_45037_45068[(2)] = inst_45021);

(statearr_45037_45068[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45026 === (8))){
var inst_45014 = (state_45025[(9)]);
var inst_45014__$1 = (state_45025[(2)]);
var inst_45015 = fluree.db.util.core.exception_QMARK_(inst_45014__$1);
var state_45025__$1 = (function (){var statearr_45038 = state_45025;
(statearr_45038[(9)] = inst_45014__$1);

return statearr_45038;
})();
if(inst_45015){
var statearr_45039_45069 = state_45025__$1;
(statearr_45039_45069[(1)] = (9));

} else {
var statearr_45040_45070 = state_45025__$1;
(statearr_45040_45070[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16395__auto____0 = (function (){
var statearr_45041 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45041[(0)] = fluree$db$dbfunctions$internal$state_machine__16395__auto__);

(statearr_45041[(1)] = (1));

return statearr_45041;
});
var fluree$db$dbfunctions$internal$state_machine__16395__auto____1 = (function (state_45025){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45025);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45042){var ex__16398__auto__ = e45042;
var statearr_45043_45071 = state_45025;
(statearr_45043_45071[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45025[(4)]))){
var statearr_45044_45072 = state_45025;
(statearr_45044_45072[(1)] = cljs.core.first((state_45025[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45073 = state_45025;
state_45025 = G__45073;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16395__auto__ = function(state_45025){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____1.call(this,state_45025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45045 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45045[(6)] = c__16469__auto__);

return statearr_45045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__45077 = path;
var vec__45078 = G__45077;
var seq__45079 = cljs.core.seq(vec__45078);
var first__45080 = cljs.core.first(seq__45079);
var seq__45079__$1 = cljs.core.next(seq__45079);
var var$ = first__45080;
var r = seq__45079__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__45077__$1 = G__45077;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__45084 = G__45077__$1;
var seq__45085 = cljs.core.seq(vec__45084);
var first__45086 = cljs.core.first(seq__45085);
var seq__45085__$1 = cljs.core.next(seq__45085);
var var$__$1 = first__45086;
var r__$1 = seq__45085__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__45087 = r__$1;
var G__45088 = n__$2;
var G__45089 = next_clauses;
G__45077__$1 = G__45087;
n__$1 = G__45088;
where_clauses__$1 = G__45089;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__45090 = r__$1;
var G__45091 = next_n;
var G__45092 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__45077__$1 = G__45090;
n__$1 = G__45091;
where_clauses__$1 = G__45092;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45129){
var state_val_45130 = (state_45129[(1)]);
if((state_val_45130 === (7))){
var inst_45102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45103 = [path];
var inst_45104 = (new cljs.core.PersistentVector(null,1,(5),inst_45102,inst_45103,null));
var state_45129__$1 = state_45129;
var statearr_45131_45159 = state_45129__$1;
(statearr_45131_45159[(2)] = inst_45104);

(statearr_45131_45159[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45130 === (1))){
var state_45129__$1 = state_45129;
var statearr_45132_45160 = state_45129__$1;
(statearr_45132_45160[(2)] = null);

(statearr_45132_45160[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45130 === (4))){
var inst_45093 = (state_45129[(2)]);
var state_45129__$1 = state_45129;
var statearr_45133_45161 = state_45129__$1;
(statearr_45133_45161[(2)] = inst_45093);

(statearr_45133_45161[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45130 === (13))){
var inst_45120 = (state_45129[(2)]);
var inst_45121 = fluree.db.util.async.throw_err(inst_45120);
var _ = (function (){var statearr_45134 = state_45129;
(statearr_45134[(4)] = cljs.core.rest((state_45129[(4)])));

return statearr_45134;
})();
var state_45129__$1 = state_45129;
var statearr_45135_45162 = state_45129__$1;
(statearr_45135_45162[(2)] = inst_45121);

(statearr_45135_45162[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45130 === (6))){
var state_45129__$1 = state_45129;
var statearr_45137_45163 = state_45129__$1;
(statearr_45137_45163[(2)] = path);

(statearr_45137_45163[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45130 === (3))){
var inst_45127 = (state_45129[(2)]);
var state_45129__$1 = state_45129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45129__$1,inst_45127);
} else {
if((state_val_45130 === (12))){
var _ = (function (){var statearr_45138 = state_45129;
(statearr_45138[(4)] = cljs.core.rest((state_45129[(4)])));

return statearr_45138;
})();
var state_45129__$1 = state_45129;
var ex45136 = (state_45129__$1[(2)]);
var statearr_45139_45164 = state_45129__$1;
(statearr_45139_45164[(5)] = ex45136);


var statearr_45140_45165 = state_45129__$1;
(statearr_45140_45165[(1)] = (11));

(statearr_45140_45165[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45130 === (2))){
var _ = (function (){var statearr_45141 = state_45129;
(statearr_45141[(4)] = cljs.core.cons((5),(state_45129[(4)])));

return statearr_45141;
})();
var inst_45099 = cljs.core.vector_QMARK_(path);
var state_45129__$1 = state_45129;
if(inst_45099){
var statearr_45142_45166 = state_45129__$1;
(statearr_45142_45166[(1)] = (6));

} else {
var statearr_45143_45167 = state_45129__$1;
(statearr_45143_45167[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45130 === (11))){
var inst_45106 = (state_45129[(7)]);
var inst_45111 = (state_45129[(2)]);
var inst_45112 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45111,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_45106,endSubject], 0));
var state_45129__$1 = state_45129;
var statearr_45145_45168 = state_45129__$1;
(statearr_45145_45168[(2)] = inst_45112);

(statearr_45145_45168[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45130 === (9))){
var inst_45110 = (state_45129[(8)]);
var _ = (function (){var statearr_45146 = state_45129;
(statearr_45146[(4)] = cljs.core.cons((12),(state_45129[(4)])));

return statearr_45146;
})();
var inst_45118 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_45110);
var state_45129__$1 = state_45129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45129__$1,(13),inst_45118);
} else {
if((state_val_45130 === (5))){
var _ = (function (){var statearr_45147 = state_45129;
(statearr_45147[(4)] = cljs.core.rest((state_45129[(4)])));

return statearr_45147;
})();
var state_45129__$1 = state_45129;
var ex45144 = (state_45129__$1[(2)]);
var statearr_45148_45169 = state_45129__$1;
(statearr_45148_45169[(5)] = ex45144);


if((ex45144 instanceof Error)){
var statearr_45149_45170 = state_45129__$1;
(statearr_45149_45170[(1)] = (4));

(statearr_45149_45170[(5)] = null);

} else {
throw ex45144;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45130 === (10))){
var inst_45124 = (state_45129[(2)]);
var _ = (function (){var statearr_45150 = state_45129;
(statearr_45150[(4)] = cljs.core.rest((state_45129[(4)])));

return statearr_45150;
})();
var state_45129__$1 = state_45129;
var statearr_45151_45171 = state_45129__$1;
(statearr_45151_45171[(2)] = inst_45124);

(statearr_45151_45171[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45130 === (8))){
var inst_45106 = (state_45129[(7)]);
var inst_45106__$1 = (state_45129[(2)]);
var inst_45107 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_45106__$1,endSubject);
var inst_45108 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_45109 = ["?var1",inst_45107];
var inst_45110 = cljs.core.PersistentHashMap.fromArrays(inst_45108,inst_45109);
var state_45129__$1 = (function (){var statearr_45152 = state_45129;
(statearr_45152[(7)] = inst_45106__$1);

(statearr_45152[(8)] = inst_45110);

return statearr_45152;
})();
var statearr_45153_45172 = state_45129__$1;
(statearr_45153_45172[(2)] = null);

(statearr_45153_45172[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_45154 = [null,null,null,null,null,null,null,null,null];
(statearr_45154[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto__);

(statearr_45154[(1)] = (1));

return statearr_45154;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto____1 = (function (state_45129){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45129);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45155){var ex__16398__auto__ = e45155;
var statearr_45156_45173 = state_45129;
(statearr_45156_45173[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45129[(4)]))){
var statearr_45157_45174 = state_45129;
(statearr_45157_45174[(1)] = cljs.core.first((state_45129[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45175 = state_45129;
state_45129 = G__45175;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto__ = function(state_45129){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto____1.call(this,state_45129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45158 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45158[(6)] = c__16469__auto__);

return statearr_45158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e45176){var e = e45176;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e45177){var e = e45177;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e45178){var e = e45178;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e45179){var e = e45179;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45182 = arguments.length;
var i__4819__auto___45183 = (0);
while(true){
if((i__4819__auto___45183 < len__4818__auto___45182)){
args__4824__auto__.push((arguments[i__4819__auto___45183]));

var G__45184 = (i__4819__auto___45183 + (1));
i__4819__auto___45183 = G__45184;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e45181){var e = e45181;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq45180){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45180));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45187 = arguments.length;
var i__4819__auto___45188 = (0);
while(true){
if((i__4819__auto___45188 < len__4818__auto___45187)){
args__4824__auto__.push((arguments[i__4819__auto___45188]));

var G__45189 = (i__4819__auto___45188 + (1));
i__4819__auto___45188 = G__45189;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e45186){var e = e45186;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq45185){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45185));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45192 = arguments.length;
var i__4819__auto___45193 = (0);
while(true){
if((i__4819__auto___45193 < len__4818__auto___45192)){
args__4824__auto__.push((arguments[i__4819__auto___45193]));

var G__45194 = (i__4819__auto___45193 + (1));
i__4819__auto___45193 = G__45194;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4212__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e45191){var e = e45191;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq45190){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45190));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45197 = arguments.length;
var i__4819__auto___45198 = (0);
while(true){
if((i__4819__auto___45198 < len__4818__auto___45197)){
args__4824__auto__.push((arguments[i__4819__auto___45198]));

var G__45199 = (i__4819__auto___45198 + (1));
i__4819__auto___45198 = G__45199;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e45196){var e = e45196;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq45195){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45195));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e45200){var e = e45200;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e45201){var e = e45201;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e45202){var e = e45202;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e45203){var e = e45203;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e45204){var e = e45204;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__45210 = path;
var vec__45211 = G__45210;
var seq__45212 = cljs.core.seq(vec__45211);
var first__45213 = cljs.core.first(seq__45212);
var seq__45212__$1 = cljs.core.next(seq__45212);
var pred = first__45213;
var r = seq__45212__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__45210__$1 = G__45210;
var subjects__$1 = subjects;
while(true){
var vec__45217 = G__45210__$1;
var seq__45218 = cljs.core.seq(vec__45217);
var first__45219 = cljs.core.first(seq__45218);
var seq__45218__$1 = cljs.core.next(seq__45218);
var pred__$1 = first__45219;
var r__$1 = seq__45218__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__45210__$1,subjects__$1,vec__45217,seq__45218,first__45219,seq__45218__$1,pred__$1,r__$1,subjects__$2,G__45210,vec__45211,seq__45212,first__45213,seq__45212__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__45210__$1,subjects__$1,vec__45217,seq__45218,first__45219,seq__45218__$1,pred__$1,r__$1,subjects__$2,G__45210,vec__45211,seq__45212,first__45213,seq__45212__$1,pred,r,subjects){
return (function (p1__45205_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__45205_SHARP_,pred__$1);
});})(G__45210__$1,subjects__$1,vec__45217,seq__45218,first__45219,seq__45218__$1,pred__$1,r__$1,subjects__$2,G__45210,vec__45211,seq__45212,first__45213,seq__45212__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__45210__$1,subjects__$1,vec__45217,seq__45218,first__45219,seq__45218__$1,pred__$1,r__$1,subjects__$2,G__45210,vec__45211,seq__45212,first__45213,seq__45212__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4210__auto__ = r__$1;
if(and__4210__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4210__auto__;
}
})())){
var G__45220 = r__$1;
var G__45221 = next_subjects;
G__45210__$1 = G__45220;
subjects__$1 = G__45221;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e45206){var e = e45206;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e45222){var e = e45222;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e45223){var e = e45223;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45226 = arguments.length;
var i__4819__auto___45227 = (0);
while(true){
if((i__4819__auto___45227 < len__4818__auto___45226)){
args__4824__auto__.push((arguments[i__4819__auto___45227]));

var G__45228 = (i__4819__auto___45227 + (1));
i__4819__auto___45227 = G__45228;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e45225){var e = e45225;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq45224){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45224));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e45229){var e = e45229;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45232 = arguments.length;
var i__4819__auto___45233 = (0);
while(true){
if((i__4819__auto___45233 < len__4818__auto___45232)){
args__4824__auto__.push((arguments[i__4819__auto___45233]));

var G__45234 = (i__4819__auto___45233 + (1));
i__4819__auto___45233 = G__45234;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e45231){var e = e45231;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq45230){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45230));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e45235){var e = e45235;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45292){
var state_val_45293 = (state_45292[(1)]);
if((state_val_45293 === (7))){
var inst_45238 = (state_45292[(2)]);
var state_45292__$1 = state_45292;
var statearr_45294_45328 = state_45292__$1;
(statearr_45294_45328[(2)] = inst_45238);

(statearr_45294_45328[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (1))){
var state_45292__$1 = state_45292;
var statearr_45295_45329 = state_45292__$1;
(statearr_45295_45329[(2)] = null);

(statearr_45295_45329[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (4))){
var inst_45237 = (state_45292[(2)]);
var state_45292__$1 = (function (){var statearr_45296 = state_45292;
(statearr_45296[(7)] = inst_45237);

return statearr_45296;
})();
var statearr_45297_45330 = state_45292__$1;
(statearr_45297_45330[(2)] = null);

(statearr_45297_45330[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (15))){
var inst_45262 = (state_45292[(8)]);
var inst_45275 = (state_45292[(9)]);
var inst_45263 = (state_45292[(10)]);
var inst_45260 = (state_45292[(11)]);
var inst_45273 = (state_45292[(12)]);
var inst_45272 = (state_45292[(13)]);
var inst_45279 = (function (){var db = inst_45260;
var prevT = inst_45262;
var db_SINGLEQUOTE_ = inst_45263;
var prev_vals = inst_45272;
var fuel = inst_45273;
var G__45274 = inst_45275;
return (function (p1__45236_SHARP_){
var f = p1__45236_SHARP_;
return f.o;
});
})();
var inst_45280 = (inst_45279.cljs$core$IFn$_invoke$arity$1 ? inst_45279.cljs$core$IFn$_invoke$arity$1(inst_45275) : inst_45279.call(null,inst_45275));
var state_45292__$1 = state_45292;
var statearr_45298_45331 = state_45292__$1;
(statearr_45298_45331[(2)] = inst_45280);

(statearr_45298_45331[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (13))){
var inst_45275 = (state_45292[(9)]);
var inst_45272 = (state_45292[(13)]);
var inst_45271 = (state_45292[(2)]);
var inst_45272__$1 = fluree.db.util.async.throw_err(inst_45271);
var inst_45273 = fluree.db.dbfunctions.internal.count(inst_45272__$1);
var inst_45275__$1 = cljs.core.first(inst_45272__$1);
var inst_45276 = (inst_45275__$1 == null);
var state_45292__$1 = (function (){var statearr_45299 = state_45292;
(statearr_45299[(9)] = inst_45275__$1);

(statearr_45299[(12)] = inst_45273);

(statearr_45299[(13)] = inst_45272__$1);

return statearr_45299;
})();
if(cljs.core.truth_(inst_45276)){
var statearr_45300_45332 = state_45292__$1;
(statearr_45300_45332[(1)] = (14));

} else {
var statearr_45301_45333 = state_45292__$1;
(statearr_45301_45333[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (6))){
var inst_45247 = (state_45292[(2)]);
var state_45292__$1 = state_45292;
var statearr_45302_45334 = state_45292__$1;
(statearr_45302_45334[(2)] = inst_45247);

(statearr_45302_45334[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (3))){
var inst_45290 = (state_45292[(2)]);
var state_45292__$1 = state_45292;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45292__$1,inst_45290);
} else {
if((state_val_45293 === (12))){
var inst_45287 = (state_45292[(2)]);
var _ = (function (){var statearr_45303 = state_45292;
(statearr_45303[(4)] = cljs.core.rest((state_45292[(4)])));

return statearr_45303;
})();
var state_45292__$1 = state_45292;
var statearr_45304_45335 = state_45292__$1;
(statearr_45304_45335[(2)] = inst_45287);

(statearr_45304_45335[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (2))){
var _ = (function (){var statearr_45306 = state_45292;
(statearr_45306[(4)] = cljs.core.cons((9),(state_45292[(4)])));

return statearr_45306;
})();
var inst_45253 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45254 = typeof inst_45253 === 'string';
var state_45292__$1 = state_45292;
if(cljs.core.truth_(inst_45254)){
var statearr_45307_45336 = state_45292__$1;
(statearr_45307_45336[(1)] = (10));

} else {
var statearr_45308_45337 = state_45292__$1;
(statearr_45308_45337[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (11))){
var inst_45262 = (state_45292[(8)]);
var inst_45263 = (state_45292[(10)]);
var inst_45260 = (state_45292[(11)]);
var inst_45260__$1 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45261 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_45260__$1);
var inst_45262__$1 = fluree.db.dbfunctions.internal.inc(inst_45261);
var inst_45263__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_45260__$1,cljs.core.cst$kw$t,inst_45262__$1);
var inst_45264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45265 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45266 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45267 = [inst_45265,inst_45266];
var inst_45268 = (new cljs.core.PersistentVector(null,2,(5),inst_45264,inst_45267,null));
var inst_45269 = fluree.db.dbproto._search(inst_45263__$1,inst_45268);
var state_45292__$1 = (function (){var statearr_45309 = state_45292;
(statearr_45309[(8)] = inst_45262__$1);

(statearr_45309[(10)] = inst_45263__$1);

(statearr_45309[(11)] = inst_45260__$1);

return statearr_45309;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45292__$1,(13),inst_45269);
} else {
if((state_val_45293 === (9))){
var _ = (function (){var statearr_45310 = state_45292;
(statearr_45310[(4)] = cljs.core.rest((state_45292[(4)])));

return statearr_45310;
})();
var state_45292__$1 = state_45292;
var ex45305 = (state_45292__$1[(2)]);
var statearr_45311_45338 = state_45292__$1;
(statearr_45311_45338[(5)] = ex45305);


var statearr_45312_45339 = state_45292__$1;
(statearr_45312_45339[(1)] = (4));

(statearr_45312_45339[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (5))){
var inst_45237 = (state_45292[(7)]);
var _ = (function (){var statearr_45313 = state_45292;
(statearr_45313[(4)] = cljs.core.cons((8),(state_45292[(4)])));

return statearr_45313;
})();
var inst_45244 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45237,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_45314 = state_45292;
(statearr_45314[(4)] = cljs.core.rest((state_45292[(4)])));

return statearr_45314;
})();
var state_45292__$1 = state_45292;
var statearr_45315_45340 = state_45292__$1;
(statearr_45315_45340[(2)] = inst_45244);

(statearr_45315_45340[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (14))){
var state_45292__$1 = state_45292;
var statearr_45316_45341 = state_45292__$1;
(statearr_45316_45341[(2)] = null);

(statearr_45316_45341[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (16))){
var inst_45273 = (state_45292[(12)]);
var inst_45282 = (state_45292[(2)]);
var inst_45283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45284 = [inst_45282,inst_45273];
var inst_45285 = (new cljs.core.PersistentVector(null,2,(5),inst_45283,inst_45284,null));
var state_45292__$1 = state_45292;
var statearr_45318_45342 = state_45292__$1;
(statearr_45318_45342[(2)] = inst_45285);

(statearr_45318_45342[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (10))){
var inst_45256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45257 = [null,(0)];
var inst_45258 = (new cljs.core.PersistentVector(null,2,(5),inst_45256,inst_45257,null));
var state_45292__$1 = state_45292;
var statearr_45319_45343 = state_45292__$1;
(statearr_45319_45343[(2)] = inst_45258);

(statearr_45319_45343[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45293 === (8))){
var _ = (function (){var statearr_45320 = state_45292;
(statearr_45320[(4)] = cljs.core.rest((state_45292[(4)])));

return statearr_45320;
})();
var state_45292__$1 = state_45292;
var ex45317 = (state_45292__$1[(2)]);
var statearr_45321_45344 = state_45292__$1;
(statearr_45321_45344[(5)] = ex45317);


var statearr_45322_45345 = state_45292__$1;
(statearr_45322_45345[(1)] = (7));

(statearr_45322_45345[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto____0 = (function (){
var statearr_45323 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45323[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto__);

(statearr_45323[(1)] = (1));

return statearr_45323;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto____1 = (function (state_45292){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45292);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45324){var ex__16398__auto__ = e45324;
var statearr_45325_45346 = state_45292;
(statearr_45325_45346[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45292[(4)]))){
var statearr_45326_45347 = state_45292;
(statearr_45326_45347[(1)] = cljs.core.first((state_45292[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45348 = state_45292;
state_45292 = G__45348;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto__ = function(state_45292){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto____1.call(this,state_45292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45327 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45327[(6)] = c__16469__auto__);

return statearr_45327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45400){
var state_val_45401 = (state_45400[(1)]);
if((state_val_45401 === (7))){
var inst_45350 = (state_45400[(2)]);
var state_45400__$1 = state_45400;
var statearr_45402_45431 = state_45400__$1;
(statearr_45402_45431[(2)] = inst_45350);

(statearr_45402_45431[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45401 === (1))){
var state_45400__$1 = state_45400;
var statearr_45403_45432 = state_45400__$1;
(statearr_45403_45432[(2)] = null);

(statearr_45403_45432[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45401 === (4))){
var inst_45349 = (state_45400[(2)]);
var state_45400__$1 = (function (){var statearr_45404 = state_45400;
(statearr_45404[(7)] = inst_45349);

return statearr_45404;
})();
var statearr_45405_45433 = state_45400__$1;
(statearr_45405_45433[(2)] = null);

(statearr_45405_45433[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45401 === (13))){
var inst_45395 = (state_45400[(2)]);
var _ = (function (){var statearr_45406 = state_45400;
(statearr_45406[(4)] = cljs.core.rest((state_45400[(4)])));

return statearr_45406;
})();
var state_45400__$1 = state_45400;
var statearr_45407_45434 = state_45400__$1;
(statearr_45407_45434[(2)] = inst_45395);

(statearr_45407_45434[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45401 === (6))){
var inst_45359 = (state_45400[(2)]);
var state_45400__$1 = state_45400;
var statearr_45408_45435 = state_45400__$1;
(statearr_45408_45435[(2)] = inst_45359);

(statearr_45408_45435[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45401 === (3))){
var inst_45398 = (state_45400[(2)]);
var state_45400__$1 = state_45400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45400__$1,inst_45398);
} else {
if((state_val_45401 === (12))){
var inst_45382 = (state_45400[(8)]);
var inst_45391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45392 = [null,inst_45382];
var inst_45393 = (new cljs.core.PersistentVector(null,2,(5),inst_45391,inst_45392,null));
var state_45400__$1 = state_45400;
var statearr_45409_45436 = state_45400__$1;
(statearr_45409_45436[(2)] = inst_45393);

(statearr_45409_45436[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45401 === (2))){
var _ = (function (){var statearr_45411 = state_45400;
(statearr_45411[(4)] = cljs.core.cons((9),(state_45400[(4)])));

return statearr_45411;
})();
var inst_45368 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_45369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45371 = [null,pred_name,"?o"];
var inst_45372 = (new cljs.core.PersistentVector(null,3,(5),inst_45370,inst_45371,null));
var inst_45373 = [inst_45372];
var inst_45374 = (new cljs.core.PersistentVector(null,1,(5),inst_45369,inst_45373,null));
var inst_45375 = ["?o",inst_45374,opts];
var inst_45376 = cljs.core.PersistentHashMap.fromArrays(inst_45368,inst_45375);
var inst_45377 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_45376);
var state_45400__$1 = state_45400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45400__$1,(10),inst_45377);
} else {
if((state_val_45401 === (11))){
var inst_45381 = (state_45400[(9)]);
var inst_45382 = (state_45400[(8)]);
var inst_45386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45387 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_45381);
var inst_45388 = [inst_45387,inst_45382];
var inst_45389 = (new cljs.core.PersistentVector(null,2,(5),inst_45386,inst_45388,null));
var state_45400__$1 = state_45400;
var statearr_45412_45437 = state_45400__$1;
(statearr_45412_45437[(2)] = inst_45389);

(statearr_45412_45437[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45401 === (9))){
var _ = (function (){var statearr_45413 = state_45400;
(statearr_45413[(4)] = cljs.core.rest((state_45400[(4)])));

return statearr_45413;
})();
var state_45400__$1 = state_45400;
var ex45410 = (state_45400__$1[(2)]);
var statearr_45414_45438 = state_45400__$1;
(statearr_45414_45438[(5)] = ex45410);


var statearr_45415_45439 = state_45400__$1;
(statearr_45415_45439[(1)] = (4));

(statearr_45415_45439[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45401 === (5))){
var inst_45349 = (state_45400[(7)]);
var _ = (function (){var statearr_45417 = state_45400;
(statearr_45417[(4)] = cljs.core.cons((8),(state_45400[(4)])));

return statearr_45417;
})();
var inst_45356 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45349,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_45418 = state_45400;
(statearr_45418[(4)] = cljs.core.rest((state_45400[(4)])));

return statearr_45418;
})();
var state_45400__$1 = state_45400;
var statearr_45419_45440 = state_45400__$1;
(statearr_45419_45440[(2)] = inst_45356);

(statearr_45419_45440[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45401 === (10))){
var inst_45381 = (state_45400[(9)]);
var inst_45379 = (state_45400[(2)]);
var inst_45380 = fluree.db.util.async.throw_err(inst_45379);
var inst_45381__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45380,(0),null);
var inst_45382 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45380,(1),null);
var inst_45383 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_45381__$1);
var inst_45384 = cljs.core.not(inst_45383);
var state_45400__$1 = (function (){var statearr_45420 = state_45400;
(statearr_45420[(9)] = inst_45381__$1);

(statearr_45420[(8)] = inst_45382);

return statearr_45420;
})();
if(inst_45384){
var statearr_45421_45441 = state_45400__$1;
(statearr_45421_45441[(1)] = (11));

} else {
var statearr_45422_45442 = state_45400__$1;
(statearr_45422_45442[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45401 === (8))){
var _ = (function (){var statearr_45423 = state_45400;
(statearr_45423[(4)] = cljs.core.rest((state_45400[(4)])));

return statearr_45423;
})();
var state_45400__$1 = state_45400;
var ex45416 = (state_45400__$1[(2)]);
var statearr_45424_45443 = state_45400__$1;
(statearr_45424_45443[(5)] = ex45416);


var statearr_45425_45444 = state_45400__$1;
(statearr_45425_45444[(1)] = (7));

(statearr_45425_45444[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto____0 = (function (){
var statearr_45426 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45426[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto__);

(statearr_45426[(1)] = (1));

return statearr_45426;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto____1 = (function (state_45400){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45400);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45427){var ex__16398__auto__ = e45427;
var statearr_45428_45445 = state_45400;
(statearr_45428_45445[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45400[(4)]))){
var statearr_45429_45446 = state_45400;
(statearr_45429_45446[(1)] = cljs.core.first((state_45400[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45447 = state_45400;
state_45400 = G__45447;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto__ = function(state_45400){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto____1.call(this,state_45400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45430 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45430[(6)] = c__16469__auto__);

return statearr_45430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4210__auto__ = typeof email === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4210__auto__;
}
})());
}catch (e45448){var e = e45448;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__45450 = arguments.length;
switch (G__45450) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45520){
var state_val_45521 = (state_45520[(1)]);
if((state_val_45521 === (7))){
var inst_45452 = (state_45520[(2)]);
var state_45520__$1 = state_45520;
var statearr_45522_45566 = state_45520__$1;
(statearr_45522_45566[(2)] = inst_45452);

(statearr_45522_45566[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (20))){
var inst_45496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45497 = ["*"];
var inst_45498 = (new cljs.core.PersistentVector(null,1,(5),inst_45496,inst_45497,null));
var state_45520__$1 = state_45520;
var statearr_45523_45567 = state_45520__$1;
(statearr_45523_45567[(2)] = inst_45498);

(statearr_45523_45567[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (1))){
var state_45520__$1 = state_45520;
var statearr_45524_45568 = state_45520__$1;
(statearr_45524_45568[(2)] = null);

(statearr_45524_45568[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (4))){
var inst_45451 = (state_45520[(2)]);
var state_45520__$1 = (function (){var statearr_45525 = state_45520;
(statearr_45525[(7)] = inst_45451);

return statearr_45525;
})();
var statearr_45526_45569 = state_45520__$1;
(statearr_45526_45569[(2)] = null);

(statearr_45526_45569[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (15))){
var inst_45515 = (state_45520[(2)]);
var _ = (function (){var statearr_45527 = state_45520;
(statearr_45527[(4)] = cljs.core.rest((state_45520[(4)])));

return statearr_45527;
})();
var state_45520__$1 = state_45520;
var statearr_45528_45570 = state_45520__$1;
(statearr_45528_45570[(2)] = inst_45515);

(statearr_45528_45570[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (21))){
var inst_45479 = (state_45520[(8)]);
var inst_45486 = (state_45520[(9)]);
var inst_45500 = (state_45520[(2)]);
var inst_45501 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_45502 = cljs.core.PersistentHashMap.EMPTY;
var inst_45503 = [inst_45500,inst_45486,inst_45502];
var inst_45504 = cljs.core.PersistentHashMap.fromArrays(inst_45501,inst_45503);
var inst_45505 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_45479,inst_45504);
var state_45520__$1 = state_45520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45520__$1,(22),inst_45505);
} else {
if((state_val_45521 === (13))){
var inst_45474 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_45520__$1 = state_45520;
var statearr_45529_45571 = state_45520__$1;
(statearr_45529_45571[(2)] = inst_45474);

(statearr_45529_45571[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (22))){
var inst_45507 = (state_45520[(2)]);
var inst_45508 = fluree.db.util.async.throw_err(inst_45507);
var inst_45509 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45508,(0),null);
var inst_45510 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45508,(1),null);
var inst_45511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45512 = [inst_45509,inst_45510];
var inst_45513 = (new cljs.core.PersistentVector(null,2,(5),inst_45511,inst_45512,null));
var state_45520__$1 = state_45520;
var statearr_45530_45572 = state_45520__$1;
(statearr_45530_45572[(2)] = inst_45513);

(statearr_45530_45572[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (6))){
var inst_45461 = (state_45520[(2)]);
var state_45520__$1 = state_45520;
var statearr_45531_45573 = state_45520__$1;
(statearr_45531_45573[(2)] = inst_45461);

(statearr_45531_45573[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (17))){
var inst_45483 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45484 = fluree.db.dbfunctions.internal.get(inst_45483,cljs.core.cst$kw$_id);
var state_45520__$1 = state_45520;
var statearr_45532_45574 = state_45520__$1;
(statearr_45532_45574[(2)] = inst_45484);

(statearr_45532_45574[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (3))){
var inst_45518 = (state_45520[(2)]);
var state_45520__$1 = state_45520;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45520__$1,inst_45518);
} else {
if((state_val_45521 === (12))){
var inst_45472 = (state_45520[(2)]);
var state_45520__$1 = state_45520;
if(cljs.core.truth_(inst_45472)){
var statearr_45533_45575 = state_45520__$1;
(statearr_45533_45575[(1)] = (13));

} else {
var statearr_45534_45576 = state_45520__$1;
(statearr_45534_45576[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (2))){
var inst_45467 = (state_45520[(10)]);
var _ = (function (){var statearr_45535 = state_45520;
(statearr_45535[(4)] = cljs.core.cons((9),(state_45520[(4)])));

return statearr_45535;
})();
var inst_45467__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_45520__$1 = (function (){var statearr_45536 = state_45520;
(statearr_45536[(10)] = inst_45467__$1);

return statearr_45536;
})();
if(cljs.core.truth_(inst_45467__$1)){
var statearr_45537_45577 = state_45520__$1;
(statearr_45537_45577[(1)] = (10));

} else {
var statearr_45538_45578 = state_45520__$1;
(statearr_45538_45578[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (19))){
var inst_45488 = cljs.core.PersistentVector.EMPTY;
var inst_45489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45490 = ["*"];
var inst_45491 = (new cljs.core.PersistentVector(null,1,(5),inst_45489,inst_45490,null));
var inst_45492 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_45493 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_45491,inst_45492);
var inst_45494 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_45488,inst_45493);
var state_45520__$1 = state_45520;
var statearr_45540_45579 = state_45520__$1;
(statearr_45540_45579[(2)] = inst_45494);

(statearr_45540_45579[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (11))){
var inst_45467 = (state_45520[(10)]);
var state_45520__$1 = state_45520;
var statearr_45541_45580 = state_45520__$1;
(statearr_45541_45580[(2)] = inst_45467);

(statearr_45541_45580[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (9))){
var _ = (function (){var statearr_45542 = state_45520;
(statearr_45542[(4)] = cljs.core.rest((state_45520[(4)])));

return statearr_45542;
})();
var state_45520__$1 = state_45520;
var ex45539 = (state_45520__$1[(2)]);
var statearr_45543_45581 = state_45520__$1;
(statearr_45543_45581[(5)] = ex45539);


var statearr_45544_45582 = state_45520__$1;
(statearr_45544_45582[(1)] = (4));

(statearr_45544_45582[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (5))){
var inst_45451 = (state_45520[(7)]);
var _ = (function (){var statearr_45545 = state_45520;
(statearr_45545[(4)] = cljs.core.cons((8),(state_45520[(4)])));

return statearr_45545;
})();
var inst_45458 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45451,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_45546 = state_45520;
(statearr_45546[(4)] = cljs.core.rest((state_45520[(4)])));

return statearr_45546;
})();
var state_45520__$1 = state_45520;
var statearr_45547_45583 = state_45520__$1;
(statearr_45547_45583[(2)] = inst_45458);

(statearr_45547_45583[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (14))){
var inst_45480 = (state_45520[(11)]);
var inst_45479 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45480__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_45520__$1 = (function (){var statearr_45548 = state_45520;
(statearr_45548[(8)] = inst_45479);

(statearr_45548[(11)] = inst_45480__$1);

return statearr_45548;
})();
if(cljs.core.truth_(inst_45480__$1)){
var statearr_45549_45584 = state_45520__$1;
(statearr_45549_45584[(1)] = (16));

} else {
var statearr_45550_45585 = state_45520__$1;
(statearr_45550_45585[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (16))){
var inst_45480 = (state_45520[(11)]);
var state_45520__$1 = state_45520;
var statearr_45551_45586 = state_45520__$1;
(statearr_45551_45586[(2)] = inst_45480);

(statearr_45551_45586[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (10))){
var inst_45469 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_45520__$1 = state_45520;
var statearr_45553_45587 = state_45520__$1;
(statearr_45553_45587[(2)] = inst_45469);

(statearr_45553_45587[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (18))){
var inst_45486 = (state_45520[(2)]);
var state_45520__$1 = (function (){var statearr_45554 = state_45520;
(statearr_45554[(9)] = inst_45486);

return statearr_45554;
})();
if(cljs.core.truth_(additional_params)){
var statearr_45555_45588 = state_45520__$1;
(statearr_45555_45588[(1)] = (19));

} else {
var statearr_45556_45589 = state_45520__$1;
(statearr_45556_45589[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45521 === (8))){
var _ = (function (){var statearr_45557 = state_45520;
(statearr_45557[(4)] = cljs.core.rest((state_45520[(4)])));

return statearr_45557;
})();
var state_45520__$1 = state_45520;
var ex45552 = (state_45520__$1[(2)]);
var statearr_45558_45590 = state_45520__$1;
(statearr_45558_45590[(5)] = ex45552);


var statearr_45559_45591 = state_45520__$1;
(statearr_45559_45591[(1)] = (7));

(statearr_45559_45591[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16395__auto____0 = (function (){
var statearr_45560 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45560[(0)] = fluree$db$dbfunctions$internal$state_machine__16395__auto__);

(statearr_45560[(1)] = (1));

return statearr_45560;
});
var fluree$db$dbfunctions$internal$state_machine__16395__auto____1 = (function (state_45520){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45520);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45561){var ex__16398__auto__ = e45561;
var statearr_45562_45592 = state_45520;
(statearr_45562_45592[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45520[(4)]))){
var statearr_45563_45593 = state_45520;
(statearr_45563_45593[(1)] = cljs.core.first((state_45520[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45594 = state_45520;
state_45520 = G__45594;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16395__auto__ = function(state_45520){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____1.call(this,state_45520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45564 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45564[(6)] = c__16469__auto__);

return statearr_45564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__45596 = arguments.length;
switch (G__45596) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45640){
var state_val_45641 = (state_45640[(1)]);
if((state_val_45641 === (7))){
var inst_45618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45619 = ["*"];
var inst_45620 = (new cljs.core.PersistentVector(null,1,(5),inst_45618,inst_45619,null));
var state_45640__$1 = state_45640;
var statearr_45642_45662 = state_45640__$1;
(statearr_45642_45662[(2)] = inst_45620);

(statearr_45642_45662[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (1))){
var state_45640__$1 = state_45640;
var statearr_45643_45663 = state_45640__$1;
(statearr_45643_45663[(2)] = null);

(statearr_45643_45663[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (4))){
var inst_45597 = (state_45640[(2)]);
var inst_45598 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45597,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_45640__$1 = state_45640;
var statearr_45644_45664 = state_45640__$1;
(statearr_45644_45664[(2)] = inst_45598);

(statearr_45644_45664[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (6))){
var inst_45610 = cljs.core.PersistentVector.EMPTY;
var inst_45611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45612 = ["*"];
var inst_45613 = (new cljs.core.PersistentVector(null,1,(5),inst_45611,inst_45612,null));
var inst_45614 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_45615 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_45613,inst_45614);
var inst_45616 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_45610,inst_45615);
var state_45640__$1 = state_45640;
var statearr_45645_45665 = state_45640__$1;
(statearr_45645_45665[(2)] = inst_45616);

(statearr_45645_45665[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (3))){
var inst_45638 = (state_45640[(2)]);
var state_45640__$1 = state_45640;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45640__$1,inst_45638);
} else {
if((state_val_45641 === (2))){
var _ = (function (){var statearr_45647 = state_45640;
(statearr_45647[(4)] = cljs.core.cons((5),(state_45640[(4)])));

return statearr_45647;
})();
var inst_45607 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45608 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_45640__$1 = (function (){var statearr_45648 = state_45640;
(statearr_45648[(7)] = inst_45607);

(statearr_45648[(8)] = inst_45608);

return statearr_45648;
})();
if(cljs.core.truth_(additional_params)){
var statearr_45649_45666 = state_45640__$1;
(statearr_45649_45666[(1)] = (6));

} else {
var statearr_45650_45667 = state_45640__$1;
(statearr_45650_45667[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (9))){
var inst_45629 = (state_45640[(2)]);
var inst_45630 = fluree.db.util.async.throw_err(inst_45629);
var inst_45631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45630,(0),null);
var inst_45632 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45630,(1),null);
var inst_45633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45634 = [inst_45631,inst_45632];
var inst_45635 = (new cljs.core.PersistentVector(null,2,(5),inst_45633,inst_45634,null));
var _ = (function (){var statearr_45651 = state_45640;
(statearr_45651[(4)] = cljs.core.rest((state_45640[(4)])));

return statearr_45651;
})();
var state_45640__$1 = state_45640;
var statearr_45652_45668 = state_45640__$1;
(statearr_45652_45668[(2)] = inst_45635);

(statearr_45652_45668[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (5))){
var _ = (function (){var statearr_45653 = state_45640;
(statearr_45653[(4)] = cljs.core.rest((state_45640[(4)])));

return statearr_45653;
})();
var state_45640__$1 = state_45640;
var ex45646 = (state_45640__$1[(2)]);
var statearr_45654_45669 = state_45640__$1;
(statearr_45654_45669[(5)] = ex45646);


var statearr_45655_45670 = state_45640__$1;
(statearr_45655_45670[(1)] = (4));

(statearr_45655_45670[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (8))){
var inst_45607 = (state_45640[(7)]);
var inst_45608 = (state_45640[(8)]);
var inst_45622 = (state_45640[(2)]);
var inst_45623 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_45624 = cljs.core.PersistentHashMap.EMPTY;
var inst_45625 = [inst_45622,inst_45608,inst_45624];
var inst_45626 = cljs.core.PersistentHashMap.fromArrays(inst_45623,inst_45625);
var inst_45627 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_45607,inst_45626);
var state_45640__$1 = state_45640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45640__$1,(9),inst_45627);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16395__auto____0 = (function (){
var statearr_45656 = [null,null,null,null,null,null,null,null,null];
(statearr_45656[(0)] = fluree$db$dbfunctions$internal$state_machine__16395__auto__);

(statearr_45656[(1)] = (1));

return statearr_45656;
});
var fluree$db$dbfunctions$internal$state_machine__16395__auto____1 = (function (state_45640){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45640);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45657){var ex__16398__auto__ = e45657;
var statearr_45658_45671 = state_45640;
(statearr_45658_45671[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45640[(4)]))){
var statearr_45659_45672 = state_45640;
(statearr_45659_45672[(1)] = cljs.core.first((state_45640[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45673 = state_45640;
state_45640 = G__45673;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16395__auto__ = function(state_45640){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____1.call(this,state_45640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45660 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45660[(6)] = c__16469__auto__);

return statearr_45660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45717){
var state_val_45718 = (state_45717[(1)]);
if((state_val_45718 === (1))){
var state_45717__$1 = state_45717;
var statearr_45719_45733 = state_45717__$1;
(statearr_45719_45733[(2)] = null);

(statearr_45719_45733[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45718 === (2))){
var _ = (function (){var statearr_45720 = state_45717;
(statearr_45720[(4)] = cljs.core.cons((5),(state_45717[(4)])));

return statearr_45720;
})();
var inst_45684 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_45685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45686 = ["_user/_auth"];
var inst_45687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45688 = ["*"];
var inst_45689 = (new cljs.core.PersistentVector(null,1,(5),inst_45687,inst_45688,null));
var inst_45690 = [inst_45689];
var inst_45691 = cljs.core.PersistentHashMap.fromArrays(inst_45686,inst_45690);
var inst_45692 = [inst_45691];
var inst_45693 = (new cljs.core.PersistentVector(null,1,(5),inst_45685,inst_45692,null));
var inst_45694 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45695 = cljs.core.PersistentHashMap.EMPTY;
var inst_45696 = [inst_45693,inst_45694,inst_45695];
var inst_45697 = cljs.core.PersistentHashMap.fromArrays(inst_45684,inst_45696);
var inst_45698 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45699 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_45698,inst_45697);
var state_45717__$1 = state_45717;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45717__$1,(6),inst_45699);
} else {
if((state_val_45718 === (3))){
var inst_45715 = (state_45717[(2)]);
var state_45717__$1 = state_45717;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45717__$1,inst_45715);
} else {
if((state_val_45718 === (4))){
var inst_45674 = (state_45717[(2)]);
var inst_45675 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45674,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_45717__$1 = state_45717;
var statearr_45722_45734 = state_45717__$1;
(statearr_45722_45734[(2)] = inst_45675);

(statearr_45722_45734[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45718 === (5))){
var _ = (function (){var statearr_45723 = state_45717;
(statearr_45723[(4)] = cljs.core.rest((state_45717[(4)])));

return statearr_45723;
})();
var state_45717__$1 = state_45717;
var ex45721 = (state_45717__$1[(2)]);
var statearr_45724_45735 = state_45717__$1;
(statearr_45724_45735[(5)] = ex45721);


var statearr_45725_45736 = state_45717__$1;
(statearr_45725_45736[(1)] = (4));

(statearr_45725_45736[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45718 === (6))){
var inst_45701 = (state_45717[(2)]);
var inst_45702 = fluree.db.util.async.throw_err(inst_45701);
var inst_45703 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45702,(0),null);
var inst_45704 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45702,(1),null);
var inst_45705 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45706 = ["_user/_auth","_id"];
var inst_45707 = (new cljs.core.PersistentVector(null,2,(5),inst_45705,inst_45706,null));
var inst_45708 = fluree.db.dbfunctions.internal.get_in(inst_45703,inst_45707);
var inst_45709 = cljs.core.first(inst_45708);
var inst_45710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45711 = [inst_45709,inst_45704];
var inst_45712 = (new cljs.core.PersistentVector(null,2,(5),inst_45710,inst_45711,null));
var _ = (function (){var statearr_45726 = state_45717;
(statearr_45726[(4)] = cljs.core.rest((state_45717[(4)])));

return statearr_45726;
})();
var state_45717__$1 = state_45717;
var statearr_45727_45737 = state_45717__$1;
(statearr_45727_45737[(2)] = inst_45712);

(statearr_45727_45737[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto____0 = (function (){
var statearr_45728 = [null,null,null,null,null,null,null];
(statearr_45728[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto__);

(statearr_45728[(1)] = (1));

return statearr_45728;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto____1 = (function (state_45717){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45717);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45729){var ex__16398__auto__ = e45729;
var statearr_45730_45738 = state_45717;
(statearr_45730_45738[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45717[(4)]))){
var statearr_45731_45739 = state_45717;
(statearr_45731_45739[(1)] = cljs.core.first((state_45717[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45740 = state_45717;
state_45717 = G__45740;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto__ = function(state_45717){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto____1.call(this,state_45717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45732 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45732[(6)] = c__16469__auto__);

return statearr_45732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45757){
var state_val_45758 = (state_45757[(1)]);
if((state_val_45758 === (1))){
var state_45757__$1 = state_45757;
var statearr_45759_45773 = state_45757__$1;
(statearr_45759_45773[(2)] = null);

(statearr_45759_45773[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45758 === (2))){
var _ = (function (){var statearr_45760 = state_45757;
(statearr_45760[(4)] = cljs.core.cons((5),(state_45757[(4)])));

return statearr_45760;
})();
var inst_45747 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45748 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45749 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_45748,inst_45747);
var state_45757__$1 = state_45757;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45757__$1,(6),inst_45749);
} else {
if((state_val_45758 === (3))){
var inst_45755 = (state_45757[(2)]);
var state_45757__$1 = state_45757;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45757__$1,inst_45755);
} else {
if((state_val_45758 === (4))){
var inst_45741 = (state_45757[(2)]);
var state_45757__$1 = state_45757;
var statearr_45762_45774 = state_45757__$1;
(statearr_45762_45774[(2)] = inst_45741);

(statearr_45762_45774[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45758 === (5))){
var _ = (function (){var statearr_45763 = state_45757;
(statearr_45763[(4)] = cljs.core.rest((state_45757[(4)])));

return statearr_45763;
})();
var state_45757__$1 = state_45757;
var ex45761 = (state_45757__$1[(2)]);
var statearr_45764_45775 = state_45757__$1;
(statearr_45764_45775[(5)] = ex45761);


if((ex45761 instanceof Error)){
var statearr_45765_45776 = state_45757__$1;
(statearr_45765_45776[(1)] = (4));

(statearr_45765_45776[(5)] = null);

} else {
throw ex45761;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45758 === (6))){
var inst_45751 = (state_45757[(2)]);
var inst_45752 = fluree.db.util.async.throw_err(inst_45751);
var _ = (function (){var statearr_45766 = state_45757;
(statearr_45766[(4)] = cljs.core.rest((state_45757[(4)])));

return statearr_45766;
})();
var state_45757__$1 = state_45757;
var statearr_45767_45777 = state_45757__$1;
(statearr_45767_45777[(2)] = inst_45752);

(statearr_45767_45777[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto____0 = (function (){
var statearr_45768 = [null,null,null,null,null,null,null];
(statearr_45768[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto__);

(statearr_45768[(1)] = (1));

return statearr_45768;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto____1 = (function (state_45757){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45757);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45769){var ex__16398__auto__ = e45769;
var statearr_45770_45778 = state_45757;
(statearr_45770_45778[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45757[(4)]))){
var statearr_45771_45779 = state_45757;
(statearr_45771_45779[(1)] = cljs.core.first((state_45757[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45780 = state_45757;
state_45757 = G__45780;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto__ = function(state_45757){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto____1.call(this,state_45757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45772 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45772[(6)] = c__16469__auto__);

return statearr_45772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__45781_SHARP_){
return p1__45781_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45782_SHARP_){
return p1__45782_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e45783){var e = e45783;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__45784_SHARP_){
return p1__45784_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45785_SHARP_){
return p1__45785_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e45786){var e = e45786;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__45788 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__45788);
})() | (0));
return num;
}catch (e45787){var e = e45787;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45868){
var state_val_45869 = (state_45868[(1)]);
if((state_val_45869 === (7))){
var inst_45807 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_45808 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45809 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45810 = cljs.core.PersistentHashMap.fromArrays(inst_45808,inst_45809);
var inst_45811 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45807,inst_45810);
var inst_45812 = (function(){throw inst_45811})();
var state_45868__$1 = state_45868;
var statearr_45870_45905 = state_45868__$1;
(statearr_45870_45905[(2)] = inst_45812);

(statearr_45870_45905[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (1))){
var state_45868__$1 = state_45868;
var statearr_45871_45906 = state_45868__$1;
(statearr_45871_45906[(2)] = null);

(statearr_45871_45906[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (4))){
var inst_45789 = (state_45868[(2)]);
var state_45868__$1 = state_45868;
var statearr_45872_45907 = state_45868__$1;
(statearr_45872_45907[(2)] = inst_45789);

(statearr_45872_45907[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (15))){
var inst_45852 = (state_45868[(7)]);
var inst_45848 = (state_45868[(2)]);
var inst_45849 = fluree.db.util.async.throw_err(inst_45848);
var inst_45850 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45849,(0),null);
var inst_45851 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45849,(1),null);
var inst_45852__$1 = cljs.core.first(inst_45850);
var inst_45853 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45852__$1,compare_val);
var state_45868__$1 = (function (){var statearr_45873 = state_45868;
(statearr_45873[(8)] = inst_45851);

(statearr_45873[(7)] = inst_45852__$1);

return statearr_45873;
})();
if(inst_45853){
var statearr_45874_45908 = state_45868__$1;
(statearr_45874_45908[(1)] = (16));

} else {
var statearr_45875_45909 = state_45868__$1;
(statearr_45875_45909[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (13))){
var state_45868__$1 = state_45868;
var statearr_45876_45910 = state_45868__$1;
(statearr_45876_45910[(2)] = null);

(statearr_45876_45910[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (6))){
var state_45868__$1 = state_45868;
var statearr_45877_45911 = state_45868__$1;
(statearr_45877_45911[(2)] = null);

(statearr_45877_45911[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (17))){
var inst_45852 = (state_45868[(7)]);
var inst_45856 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45852)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_45857 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45858 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45859 = cljs.core.PersistentHashMap.fromArrays(inst_45857,inst_45858);
var inst_45860 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45856,inst_45859);
var inst_45861 = (function(){throw inst_45860})();
var state_45868__$1 = state_45868;
var statearr_45878_45912 = state_45868__$1;
(statearr_45878_45912[(2)] = inst_45861);

(statearr_45878_45912[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (3))){
var inst_45866 = (state_45868[(2)]);
var state_45868__$1 = state_45868;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45868__$1,inst_45866);
} else {
if((state_val_45869 === (12))){
var inst_45804 = (state_45868[(9)]);
var inst_45827 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_45804], 0));
var inst_45828 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45829 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45830 = cljs.core.PersistentHashMap.fromArrays(inst_45828,inst_45829);
var inst_45831 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45827,inst_45830);
var inst_45832 = (function(){throw inst_45831})();
var state_45868__$1 = state_45868;
var statearr_45879_45913 = state_45868__$1;
(statearr_45879_45913[(2)] = inst_45832);

(statearr_45879_45913[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (2))){
var inst_45801 = (state_45868[(10)]);
var inst_45803 = (state_45868[(11)]);
var inst_45802 = (state_45868[(12)]);
var _ = (function (){var statearr_45880 = state_45868;
(statearr_45880[(4)] = cljs.core.cons((5),(state_45868[(4)])));

return statearr_45880;
})();
var inst_45799 = _QMARK_ctx;
var inst_45800 = cljs.core.__destructure_map(inst_45799);
var inst_45801__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45800,cljs.core.cst$kw$sid);
var inst_45802__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45800,cljs.core.cst$kw$pid);
var inst_45803__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45800,cljs.core.cst$kw$db);
var inst_45804 = fluree.db.dbproto._p_prop(inst_45803__$1,cljs.core.cst$kw$name,inst_45802__$1);
var state_45868__$1 = (function (){var statearr_45881 = state_45868;
(statearr_45881[(10)] = inst_45801__$1);

(statearr_45881[(11)] = inst_45803__$1);

(statearr_45881[(9)] = inst_45804);

(statearr_45881[(12)] = inst_45802__$1);

return statearr_45881;
})();
if(cljs.core.truth_(inst_45801__$1)){
var statearr_45882_45914 = state_45868__$1;
(statearr_45882_45914[(1)] = (6));

} else {
var statearr_45883_45915 = state_45868__$1;
(statearr_45883_45915[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (11))){
var inst_45803 = (state_45868[(11)]);
var inst_45802 = (state_45868[(12)]);
var inst_45824 = (state_45868[(2)]);
var inst_45825 = fluree.db.dbproto._p_prop(inst_45803,cljs.core.cst$kw$multi,inst_45802);
var state_45868__$1 = (function (){var statearr_45885 = state_45868;
(statearr_45885[(13)] = inst_45824);

return statearr_45885;
})();
if(cljs.core.truth_(inst_45825)){
var statearr_45886_45916 = state_45868__$1;
(statearr_45886_45916[(1)] = (12));

} else {
var statearr_45887_45917 = state_45868__$1;
(statearr_45887_45917[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (9))){
var state_45868__$1 = state_45868;
var statearr_45888_45918 = state_45868__$1;
(statearr_45888_45918[(2)] = null);

(statearr_45888_45918[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (5))){
var _ = (function (){var statearr_45889 = state_45868;
(statearr_45889[(4)] = cljs.core.rest((state_45868[(4)])));

return statearr_45889;
})();
var state_45868__$1 = state_45868;
var ex45884 = (state_45868__$1[(2)]);
var statearr_45890_45919 = state_45868__$1;
(statearr_45890_45919[(5)] = ex45884);


if((ex45884 instanceof Error)){
var statearr_45891_45920 = state_45868__$1;
(statearr_45891_45920[(1)] = (4));

(statearr_45891_45920[(5)] = null);

} else {
throw ex45884;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (14))){
var inst_45801 = (state_45868[(10)]);
var inst_45803 = (state_45868[(11)]);
var inst_45804 = (state_45868[(9)]);
var inst_45835 = (state_45868[(2)]);
var inst_45836 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_45837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45839 = [inst_45801,inst_45804,"?current-val"];
var inst_45840 = (new cljs.core.PersistentVector(null,3,(5),inst_45838,inst_45839,null));
var inst_45841 = [inst_45840];
var inst_45842 = (new cljs.core.PersistentVector(null,1,(5),inst_45837,inst_45841,null));
var inst_45843 = cljs.core.PersistentHashMap.EMPTY;
var inst_45844 = ["?current-val",inst_45842,inst_45843];
var inst_45845 = cljs.core.PersistentHashMap.fromArrays(inst_45836,inst_45844);
var inst_45846 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_45803,inst_45845);
var state_45868__$1 = (function (){var statearr_45892 = state_45868;
(statearr_45892[(14)] = inst_45835);

return statearr_45892;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45868__$1,(15),inst_45846);
} else {
if((state_val_45869 === (16))){
var state_45868__$1 = state_45868;
var statearr_45893_45921 = state_45868__$1;
(statearr_45893_45921[(2)] = new_val);

(statearr_45893_45921[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (10))){
var inst_45817 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_45818 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45819 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45820 = cljs.core.PersistentHashMap.fromArrays(inst_45818,inst_45819);
var inst_45821 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45817,inst_45820);
var inst_45822 = (function(){throw inst_45821})();
var state_45868__$1 = state_45868;
var statearr_45894_45922 = state_45868__$1;
(statearr_45894_45922[(2)] = inst_45822);

(statearr_45894_45922[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (18))){
var inst_45863 = (state_45868[(2)]);
var _ = (function (){var statearr_45895 = state_45868;
(statearr_45895[(4)] = cljs.core.rest((state_45868[(4)])));

return statearr_45895;
})();
var state_45868__$1 = state_45868;
var statearr_45896_45923 = state_45868__$1;
(statearr_45896_45923[(2)] = inst_45863);

(statearr_45896_45923[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45869 === (8))){
var inst_45804 = (state_45868[(9)]);
var inst_45814 = (state_45868[(2)]);
var state_45868__$1 = (function (){var statearr_45897 = state_45868;
(statearr_45897[(15)] = inst_45814);

return statearr_45897;
})();
if(cljs.core.truth_(inst_45804)){
var statearr_45898_45924 = state_45868__$1;
(statearr_45898_45924[(1)] = (9));

} else {
var statearr_45899_45925 = state_45868__$1;
(statearr_45899_45925[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto____0 = (function (){
var statearr_45900 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45900[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto__);

(statearr_45900[(1)] = (1));

return statearr_45900;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto____1 = (function (state_45868){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45868);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45901){var ex__16398__auto__ = e45901;
var statearr_45902_45926 = state_45868;
(statearr_45902_45926[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45868[(4)]))){
var statearr_45903_45927 = state_45868;
(statearr_45903_45927[(1)] = cljs.core.first((state_45868[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45928 = state_45868;
state_45868 = G__45928;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto__ = function(state_45868){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto____1.call(this,state_45868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45904 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45904[(6)] = c__16469__auto__);

return statearr_45904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
