// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
/**
 * Returns an empty TTL cache for db-function caching.
 *   Implication of this caching strategy is changes to db functions that get
 *   update will take 5 seconds to recompile, benefit is that the same function
 *   call for a ledger will not have to recompile every time.
 */
fluree.db.dbfunctions.core.db_fn_cache_factory = (function fluree$db$dbfunctions$core$db_fn_cache_factory(){
return cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ttl,(5000)], 0));
});
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.dbfunctions.core.db_fn_cache_factory());
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,fluree.db.dbfunctions.core.db_fn_cache_factory());
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__4210__auto__ = typeof value === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__4210__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$cas,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$subs,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,302,null,302,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,715,null,715,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,232,null,232,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_cas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$cas,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,813,null,813,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$compare_DASH_val,cljs.core.cst$sym$new_DASH_val], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,522,null,522,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,428,null,428,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,389,null,389,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,258,null,258,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,727,null,727,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,534,null,534,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,608,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,621,null,621,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,751,null,751,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,171,null,171,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,779,null,779,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,697,null,697,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,415,null,415,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,376,null,376,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,467,null,467,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,789,null,789,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,190,null,190,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,569,null,569,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,376,null,376,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,660,null,660,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,454,null,454,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,595,null,595,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,507,null,507,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,334,null,334,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Returns the value of a nested structure",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null),"Length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,559,null,559,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,546,null,546,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,801,null,801,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not_EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,441,null,441,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,272,null,272,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,402,null,402,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,582,null,582,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,763,null,763,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,348,null,348,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns true if key is present.",(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,362,null,362,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns a hash-set of values",(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null),"9 + count of items in hash-set"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,685,null,685,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,216,null,216,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,60,null,60,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_subs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$subs,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,634,null,634,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,203,null,203,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,647,null,647,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,480,null,480,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,290,null,290,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,739,null,739,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,245,null,245,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,672,null,672,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__72934 = cljs.core.meta(f);
var map__72934__$1 = cljs.core.__destructure_map(map__72934);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72934__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72934__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4210__auto__ = (function (){var G__72936 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__72935 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__72935.cljs$core$IFn$_invoke$arity$1 ? fexpr__72935.cljs$core$IFn$_invoke$arity$1(G__72936) : fexpr__72935.call(null,G__72936));
})();
if(cljs.core.truth_(and__4210__auto__)){
var G__72938 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__72937 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__72937.cljs$core$IFn$_invoke$arity$1 ? fexpr__72937.cljs$core$IFn$_invoke$arity$1(G__72938) : fexpr__72937.call(null,G__72938));
} else {
return and__4210__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__72933_SHARP_){
return (cljs.core.count(p1__72933_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_fn,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_73023){
var state_val_73024 = (state_73023[(1)]);
if((state_val_73024 === (7))){
var inst_72948 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_72949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72950 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_72951 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_72952 = [fn_name,inst_72950,inst_72951];
var inst_72953 = (new cljs.core.PersistentVector(null,3,(5),inst_72949,inst_72952,null));
var inst_72954 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72948,inst_72953);
var state_73023__$1 = state_73023;
var statearr_73025_73062 = state_73023__$1;
(statearr_73025_73062[(2)] = inst_72954);

(statearr_73025_73062[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (1))){
var state_73023__$1 = state_73023;
var statearr_73026_73063 = state_73023__$1;
(statearr_73026_73063[(2)] = null);

(statearr_73026_73063[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (4))){
var inst_72939 = (state_73023[(2)]);
var state_73023__$1 = state_73023;
var statearr_73027_73064 = state_73023__$1;
(statearr_73027_73064[(2)] = inst_72939);

(statearr_73027_73064[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (15))){
var inst_72986 = (state_73023[(7)]);
var inst_72972 = (state_73023[(8)]);
var inst_72984 = (state_73023[(2)]);
var inst_72985 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72972,"_fn/params");
var inst_72986__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_72985);
var inst_72987 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72972,"_fn/code");
var inst_72988 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_72987);
var inst_72989 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_72988,funType,inst_72986__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_72988,funType,inst_72986__$1));
var state_73023__$1 = (function (){var statearr_73028 = state_73023;
(statearr_73028[(7)] = inst_72986__$1);

(statearr_73028[(9)] = inst_72984);

return statearr_73028;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73023__$1,(16),inst_72989);
} else {
if((state_val_73024 === (13))){
var inst_72975 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_72976 = ["Unknown function: ",inst_72975].join('');
var inst_72977 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_72978 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_72979 = cljs.core.PersistentHashMap.fromArrays(inst_72977,inst_72978);
var inst_72980 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72976,inst_72979);
var inst_72981 = (function(){throw inst_72980})();
var state_73023__$1 = state_73023;
var statearr_73029_73065 = state_73023__$1;
(statearr_73029_73065[(2)] = inst_72981);

(statearr_73029_73065[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (6))){
var state_73023__$1 = state_73023;
var statearr_73030_73066 = state_73023__$1;
(statearr_73030_73066[(2)] = null);

(statearr_73030_73066[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (17))){
var state_73023__$1 = state_73023;
var statearr_73031_73067 = state_73023__$1;
(statearr_73031_73067[(2)] = null);

(statearr_73031_73067[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (3))){
var inst_73021 = (state_73023[(2)]);
var state_73023__$1 = state_73023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73023__$1,inst_73021);
} else {
if((state_val_73024 === (12))){
var inst_72972 = (state_73023[(8)]);
var inst_72971 = (state_73023[(2)]);
var inst_72972__$1 = fluree.db.util.async.throw_err(inst_72971);
var inst_72973 = cljs.core.empty_QMARK_(inst_72972__$1);
var state_73023__$1 = (function (){var statearr_73032 = state_73023;
(statearr_73032[(8)] = inst_72972__$1);

return statearr_73032;
})();
if(inst_72973){
var statearr_73033_73068 = state_73023__$1;
(statearr_73033_73068[(1)] = (13));

} else {
var statearr_73034_73069 = state_73023__$1;
(statearr_73034_73069[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (2))){
var inst_72945 = (state_73023[(10)]);
var _ = (function (){var statearr_73035 = state_73023;
(statearr_73035[(4)] = cljs.core.cons((5),(state_73023[(4)])));

return statearr_73035;
})();
var inst_72945__$1 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var state_73023__$1 = (function (){var statearr_73036 = state_73023;
(statearr_73036[(10)] = inst_72945__$1);

return statearr_73036;
})();
if(cljs.core.truth_(inst_72945__$1)){
var statearr_73037_73070 = state_73023__$1;
(statearr_73037_73070[(1)] = (6));

} else {
var statearr_73038_73071 = state_73023__$1;
(statearr_73038_73071[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (19))){
var inst_73006 = (state_73023[(11)]);
var inst_73016 = (state_73023[(2)]);
var state_73023__$1 = (function (){var statearr_73039 = state_73023;
(statearr_73039[(12)] = inst_73016);

return statearr_73039;
})();
var statearr_73040_73072 = state_73023__$1;
(statearr_73040_73072[(2)] = inst_73006);

(statearr_73040_73072[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (11))){
var inst_73018 = (state_73023[(2)]);
var _ = (function (){var statearr_73042 = state_73023;
(statearr_73042[(4)] = cljs.core.rest((state_73023[(4)])));

return statearr_73042;
})();
var state_73023__$1 = state_73023;
var statearr_73043_73073 = state_73023__$1;
(statearr_73043_73073[(2)] = inst_73018);

(statearr_73043_73073[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (9))){
var inst_72956 = (state_73023[(13)]);
var state_73023__$1 = state_73023;
var statearr_73044_73074 = state_73023__$1;
(statearr_73044_73074[(2)] = inst_72956);

(statearr_73044_73074[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (5))){
var _ = (function (){var statearr_73045 = state_73023;
(statearr_73045[(4)] = cljs.core.rest((state_73023[(4)])));

return statearr_73045;
})();
var state_73023__$1 = state_73023;
var ex73041 = (state_73023__$1[(2)]);
var statearr_73046_73075 = state_73023__$1;
(statearr_73046_73075[(5)] = ex73041);


if((ex73041 instanceof Error)){
var statearr_73047_73076 = state_73023__$1;
(statearr_73047_73076[(1)] = (4));

(statearr_73047_73076[(5)] = null);

} else {
throw ex73041;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (14))){
var state_73023__$1 = state_73023;
var statearr_73048_73077 = state_73023__$1;
(statearr_73048_73077[(2)] = null);

(statearr_73048_73077[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (16))){
var inst_72956 = (state_73023[(13)]);
var inst_72986 = (state_73023[(7)]);
var inst_72972 = (state_73023[(8)]);
var inst_72984 = (state_73023[(9)]);
var inst_72968 = (state_73023[(14)]);
var inst_72945 = (state_73023[(10)]);
var inst_72991 = (state_73023[(2)]);
var inst_72992 = fluree.db.util.async.throw_err(inst_72991);
var inst_72993 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72972,"_fn/spec");
var inst_72994 = cljs.core.PersistentVector.EMPTY;
var inst_72995 = cljs.core.cst$sym$_QMARK_ctx;
var inst_72996 = (function (){var forward_time_travel_db_QMARK_ = inst_72945;
var or__4212__auto__ = inst_72956;
var query = inst_72968;
var res = inst_72972;
var _ = inst_72984;
var params = inst_72986;
var code = inst_72992;
var spec = inst_72993;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_72997 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_72996,inst_72986);
var inst_72998 = cljs.core.cons(inst_72995,inst_72997);
var inst_72999 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_72994,inst_72998);
var inst_73000 = fluree.db.dbfunctions.core.build_fn(inst_72999,inst_72992);
var inst_73001 = [cljs.core.cst$kw$f,cljs.core.cst$kw$params,cljs.core.cst$kw$arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,cljs.core.cst$kw$code];
var inst_73002 = cljs.core.count(inst_72986);
var inst_73003 = [inst_73002];
var inst_73004 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_73003);
var inst_73005 = [inst_73000,inst_72986,inst_73004,false,inst_72993,null];
var inst_73006 = cljs.core.PersistentHashMap.fromArrays(inst_73001,inst_73005);
var state_73023__$1 = (function (){var statearr_73049 = state_73023;
(statearr_73049[(11)] = inst_73006);

return statearr_73049;
})();
if(cljs.core.truth_(inst_72945)){
var statearr_73050_73078 = state_73023__$1;
(statearr_73050_73078[(1)] = (17));

} else {
var statearr_73051_73079 = state_73023__$1;
(statearr_73051_73079[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (10))){
var inst_72968 = (state_73023[(14)]);
var inst_72959 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_72960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72961 = ["_fn/params","_fn/code","_fn/spec"];
var inst_72962 = (new cljs.core.PersistentVector(null,3,(5),inst_72960,inst_72961,null));
var inst_72963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72964 = cljs.core.name(fn_name);
var inst_72965 = ["_fn/name",inst_72964];
var inst_72966 = (new cljs.core.PersistentVector(null,2,(5),inst_72963,inst_72965,null));
var inst_72967 = [inst_72962,inst_72966];
var inst_72968__$1 = cljs.core.PersistentHashMap.fromArrays(inst_72959,inst_72967);
var inst_72969 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_72968__$1);
var state_73023__$1 = (function (){var statearr_73052 = state_73023;
(statearr_73052[(14)] = inst_72968__$1);

return statearr_73052;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73023__$1,(12),inst_72969);
} else {
if((state_val_73024 === (18))){
var inst_73006 = (state_73023[(11)]);
var inst_73009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73010 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_73011 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_73012 = [fn_name,inst_73010,inst_73011];
var inst_73013 = (new cljs.core.PersistentVector(null,3,(5),inst_73009,inst_73012,null));
var inst_73014 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_73013,inst_73006);
var state_73023__$1 = state_73023;
var statearr_73053_73080 = state_73023__$1;
(statearr_73053_73080[(2)] = inst_73014);

(statearr_73053_73080[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73024 === (8))){
var inst_72956 = (state_73023[(13)]);
var inst_72956__$1 = (state_73023[(2)]);
var state_73023__$1 = (function (){var statearr_73054 = state_73023;
(statearr_73054[(13)] = inst_72956__$1);

return statearr_73054;
})();
if(cljs.core.truth_(inst_72956__$1)){
var statearr_73055_73081 = state_73023__$1;
(statearr_73055_73081[(1)] = (9));

} else {
var statearr_73056_73082 = state_73023__$1;
(statearr_73056_73082[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto____0 = (function (){
var statearr_73057 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73057[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto__);

(statearr_73057[(1)] = (1));

return statearr_73057;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto____1 = (function (state_73023){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_73023);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e73058){var ex__16398__auto__ = e73058;
var statearr_73059_73083 = state_73023;
(statearr_73059_73083[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_73023[(4)]))){
var statearr_73060_73084 = state_73023;
(statearr_73060_73084[(1)] = cljs.core.first((state_73023[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__73085 = state_73023;
state_73023 = G__73085;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto__ = function(state_73023){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto____1.call(this,state_73023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_73061 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_73061[(6)] = c__16469__auto__);

return statearr_73061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__73087 = arguments.length;
switch (G__73087) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__73091 = arguments.length;
switch (G__73091) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_73221){
var state_val_73222 = (state_73221[(1)]);
if((state_val_73222 === (7))){
var inst_73216 = (state_73221[(2)]);
var _ = (function (){var statearr_73223 = state_73221;
(statearr_73223[(4)] = cljs.core.rest((state_73221[(4)])));

return statearr_73223;
})();
var state_73221__$1 = state_73221;
var statearr_73224_73304 = state_73221__$1;
(statearr_73224_73304[(2)] = inst_73216);

(statearr_73224_73304[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (20))){
var inst_73130 = (state_73221[(7)]);
var state_73221__$1 = state_73221;
var statearr_73225_73305 = state_73221__$1;
(statearr_73225_73305[(2)] = inst_73130);

(statearr_73225_73305[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (27))){
var inst_73117 = (state_73221[(8)]);
var inst_73143 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_73144 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73117)," used in function.",inst_73143].join('');
var inst_73145 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73146 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_73147 = cljs.core.PersistentHashMap.fromArrays(inst_73145,inst_73146);
var inst_73148 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73144,inst_73147);
var inst_73149 = (function(){throw inst_73148})();
var state_73221__$1 = state_73221;
var statearr_73226_73306 = state_73221__$1;
(statearr_73226_73306[(2)] = inst_73149);

(statearr_73226_73306[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (1))){
var state_73221__$1 = state_73221;
var statearr_73227_73307 = state_73221__$1;
(statearr_73227_73307[(2)] = null);

(statearr_73227_73307[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (24))){
var inst_73140 = (state_73221[(9)]);
var inst_73140__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_73221__$1 = (function (){var statearr_73228 = state_73221;
(statearr_73228[(9)] = inst_73140__$1);

return statearr_73228;
})();
if(inst_73140__$1){
var statearr_73229_73308 = state_73221__$1;
(statearr_73229_73308[(1)] = (26));

} else {
var statearr_73230_73309 = state_73221__$1;
(statearr_73230_73309[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (39))){
var inst_73117 = (state_73221[(8)]);
var inst_73177 = (inst_73117 == null);
var state_73221__$1 = state_73221;
if(cljs.core.truth_(inst_73177)){
var statearr_73231_73310 = state_73221__$1;
(statearr_73231_73310[(1)] = (42));

} else {
var statearr_73232_73311 = state_73221__$1;
(statearr_73232_73311[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (46))){
var state_73221__$1 = state_73221;
var statearr_73233_73312 = state_73221__$1;
(statearr_73233_73312[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (4))){
var inst_73092 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73235_73313 = state_73221__$1;
(statearr_73235_73313[(2)] = inst_73092);

(statearr_73235_73313[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (15))){
var inst_73117 = (state_73221[(8)]);
var inst_73128 = (inst_73117 instanceof cljs.core.Symbol);
var state_73221__$1 = state_73221;
if(cljs.core.truth_(inst_73128)){
var statearr_73236_73314 = state_73221__$1;
(statearr_73236_73314[(1)] = (17));

} else {
var statearr_73237_73315 = state_73221__$1;
(statearr_73237_73315[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (48))){
var inst_73184 = (state_73221[(2)]);
var inst_73185 = fluree.db.util.async.throw_err(inst_73184);
var state_73221__$1 = state_73221;
var statearr_73238_73316 = state_73221__$1;
(statearr_73238_73316[(2)] = inst_73185);

(statearr_73238_73316[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (50))){
var state_73221__$1 = state_73221;
var statearr_73239_73317 = state_73221__$1;
(statearr_73239_73317[(2)] = null);

(statearr_73239_73317[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (21))){
var inst_73111 = (state_73221[(10)]);
var inst_73110 = (state_73221[(11)]);
var inst_73105 = (state_73221[(12)]);
var inst_73108 = (state_73221[(13)]);
var inst_73117 = (state_73221[(8)]);
var inst_73130 = (state_73221[(7)]);
var inst_73118 = (state_73221[(14)]);
var inst_73107 = (state_73221[(15)]);
var inst_73137 = (state_73221[(16)]);
var inst_73133 = [inst_73117];
var inst_73134 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_73133);
var inst_73135 = (function (){var x = inst_73117;
var vec__73102 = inst_73105;
var G__73101 = inst_73110;
var r = inst_73118;
var seq__73103 = inst_73108;
var or__4212__auto__ = inst_73130;
var acc = inst_73111;
var first__73115 = inst_73117;
var vec__73113 = inst_73110;
var first__73104 = inst_73107;
var seq__73114 = inst_73118;
return (function (p1__73089_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__73089_SHARP_);
});
})();
var inst_73136 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_73135,params);
var inst_73137__$1 = cljs.core.some(inst_73134,inst_73136);
var state_73221__$1 = (function (){var statearr_73240 = state_73221;
(statearr_73240[(16)] = inst_73137__$1);

return statearr_73240;
})();
if(cljs.core.truth_(inst_73137__$1)){
var statearr_73241_73318 = state_73221__$1;
(statearr_73241_73318[(1)] = (23));

} else {
var statearr_73242_73319 = state_73221__$1;
(statearr_73242_73319[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (31))){
var inst_73167 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
if(cljs.core.truth_(inst_73167)){
var statearr_73243_73320 = state_73221__$1;
(statearr_73243_73320[(1)] = (35));

} else {
var statearr_73244_73321 = state_73221__$1;
(statearr_73244_73321[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (32))){
var inst_73160 = (state_73221[(17)]);
var state_73221__$1 = state_73221;
var statearr_73245_73322 = state_73221__$1;
(statearr_73245_73322[(2)] = inst_73160);

(statearr_73245_73322[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (40))){
var inst_73202 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73246_73323 = state_73221__$1;
(statearr_73246_73323[(2)] = inst_73202);

(statearr_73246_73323[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (33))){
var inst_73117 = (state_73221[(8)]);
var inst_73163 = (inst_73117 == null);
var state_73221__$1 = state_73221;
var statearr_73247_73324 = state_73221__$1;
(statearr_73247_73324[(2)] = inst_73163);

(statearr_73247_73324[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (13))){
var inst_73111 = (state_73221[(10)]);
var inst_73118 = (state_73221[(14)]);
var inst_73210 = (state_73221[(2)]);
var inst_73211 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_73111,inst_73210);
var inst_73110 = inst_73118;
var inst_73111__$1 = inst_73211;
var state_73221__$1 = (function (){var statearr_73248 = state_73221;
(statearr_73248[(10)] = inst_73111__$1);

(statearr_73248[(11)] = inst_73110);

return statearr_73248;
})();
var statearr_73249_73325 = state_73221__$1;
(statearr_73249_73325[(2)] = null);

(statearr_73249_73325[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (22))){
var inst_73155 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73250_73326 = state_73221__$1;
(statearr_73250_73326[(2)] = inst_73155);

(statearr_73250_73326[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (36))){
var inst_73117 = (state_73221[(8)]);
var inst_73170 = cljs.core.vector_QMARK_(inst_73117);
var state_73221__$1 = state_73221;
if(inst_73170){
var statearr_73251_73327 = state_73221__$1;
(statearr_73251_73327[(1)] = (38));

} else {
var statearr_73252_73328 = state_73221__$1;
(statearr_73252_73328[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (41))){
var inst_73174 = (state_73221[(2)]);
var inst_73175 = fluree.db.util.async.throw_err(inst_73174);
var state_73221__$1 = state_73221;
var statearr_73253_73329 = state_73221__$1;
(statearr_73253_73329[(2)] = inst_73175);

(statearr_73253_73329[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (43))){
var inst_73117 = (state_73221[(8)]);
var inst_73180 = cljs.core.list_QMARK_(inst_73117);
var state_73221__$1 = state_73221;
if(inst_73180){
var statearr_73254_73330 = state_73221__$1;
(statearr_73254_73330[(1)] = (45));

} else {
var statearr_73255_73331 = state_73221__$1;
(statearr_73255_73331[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (29))){
var inst_73157 = (state_73221[(18)]);
var state_73221__$1 = state_73221;
var statearr_73256_73332 = state_73221__$1;
(statearr_73256_73332[(2)] = inst_73157);

(statearr_73256_73332[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (44))){
var inst_73200 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73257_73333 = state_73221__$1;
(statearr_73257_73333[(2)] = inst_73200);

(statearr_73257_73333[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (6))){
var inst_73110 = (state_73221[(11)]);
var inst_73117 = (state_73221[(8)]);
var inst_73116 = cljs.core.seq(inst_73110);
var inst_73117__$1 = cljs.core.first(inst_73116);
var inst_73118 = cljs.core.next(inst_73116);
var inst_73119 = (inst_73117__$1 == null);
var state_73221__$1 = (function (){var statearr_73258 = state_73221;
(statearr_73258[(8)] = inst_73117__$1);

(statearr_73258[(14)] = inst_73118);

return statearr_73258;
})();
if(cljs.core.truth_(inst_73119)){
var statearr_73259_73334 = state_73221__$1;
(statearr_73259_73334[(1)] = (8));

} else {
var statearr_73260_73335 = state_73221__$1;
(statearr_73260_73335[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (28))){
var inst_73151 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73261_73336 = state_73221__$1;
(statearr_73261_73336[(2)] = inst_73151);

(statearr_73261_73336[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (51))){
var inst_73196 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73262_73337 = state_73221__$1;
(statearr_73262_73337[(2)] = inst_73196);

(statearr_73262_73337[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (25))){
var inst_73153 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73263_73338 = state_73221__$1;
(statearr_73263_73338[(2)] = inst_73153);

(statearr_73263_73338[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (34))){
var inst_73165 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73264_73339 = state_73221__$1;
(statearr_73264_73339[(2)] = inst_73165);

(statearr_73264_73339[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (17))){
var inst_73117 = (state_73221[(8)]);
var inst_73130 = (state_73221[(7)]);
var inst_73130__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_73117) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_73117));
var state_73221__$1 = (function (){var statearr_73265 = state_73221;
(statearr_73265[(7)] = inst_73130__$1);

return statearr_73265;
})();
if(cljs.core.truth_(inst_73130__$1)){
var statearr_73266_73340 = state_73221__$1;
(statearr_73266_73340[(1)] = (20));

} else {
var statearr_73267_73341 = state_73221__$1;
(statearr_73267_73341[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (3))){
var inst_73219 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73221__$1,inst_73219);
} else {
if((state_val_73222 === (12))){
var inst_73117 = (state_73221[(8)]);
var inst_73125 = typeof inst_73117 === 'number';
var state_73221__$1 = state_73221;
if(cljs.core.truth_(inst_73125)){
var statearr_73268_73342 = state_73221__$1;
(statearr_73268_73342[(1)] = (14));

} else {
var statearr_73269_73343 = state_73221__$1;
(statearr_73269_73343[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (2))){
var inst_73105 = (state_73221[(12)]);
var _ = (function (){var statearr_73270 = state_73221;
(statearr_73270[(4)] = cljs.core.cons((5),(state_73221[(4)])));

return statearr_73270;
})();
var inst_73105__$1 = vec;
var inst_73106 = cljs.core.seq(inst_73105__$1);
var inst_73107 = cljs.core.first(inst_73106);
var inst_73108 = cljs.core.next(inst_73106);
var inst_73109 = cljs.core.PersistentVector.EMPTY;
var inst_73110 = inst_73105__$1;
var inst_73111 = inst_73109;
var state_73221__$1 = (function (){var statearr_73271 = state_73221;
(statearr_73271[(10)] = inst_73111);

(statearr_73271[(11)] = inst_73110);

(statearr_73271[(12)] = inst_73105__$1);

(statearr_73271[(13)] = inst_73108);

(statearr_73271[(15)] = inst_73107);

return statearr_73271;
})();
var statearr_73272_73344 = state_73221__$1;
(statearr_73272_73344[(2)] = null);

(statearr_73272_73344[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (23))){
var inst_73137 = (state_73221[(16)]);
var state_73221__$1 = state_73221;
var statearr_73273_73345 = state_73221__$1;
(statearr_73273_73345[(2)] = inst_73137);

(statearr_73273_73345[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (47))){
var inst_73198 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73274_73346 = state_73221__$1;
(statearr_73274_73346[(2)] = inst_73198);

(statearr_73274_73346[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (35))){
var inst_73117 = (state_73221[(8)]);
var state_73221__$1 = state_73221;
var statearr_73275_73347 = state_73221__$1;
(statearr_73275_73347[(2)] = inst_73117);

(statearr_73275_73347[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (19))){
var inst_73206 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73276_73348 = state_73221__$1;
(statearr_73276_73348[(2)] = inst_73206);

(statearr_73276_73348[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (11))){
var inst_73117 = (state_73221[(8)]);
var state_73221__$1 = state_73221;
var statearr_73278_73349 = state_73221__$1;
(statearr_73278_73349[(2)] = inst_73117);

(statearr_73278_73349[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (9))){
var inst_73117 = (state_73221[(8)]);
var inst_73122 = typeof inst_73117 === 'string';
var state_73221__$1 = state_73221;
if(cljs.core.truth_(inst_73122)){
var statearr_73279_73350 = state_73221__$1;
(statearr_73279_73350[(1)] = (11));

} else {
var statearr_73280_73351 = state_73221__$1;
(statearr_73280_73351[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (5))){
var _ = (function (){var statearr_73281 = state_73221;
(statearr_73281[(4)] = cljs.core.rest((state_73221[(4)])));

return statearr_73281;
})();
var state_73221__$1 = state_73221;
var ex73277 = (state_73221__$1[(2)]);
var statearr_73282_73352 = state_73221__$1;
(statearr_73282_73352[(5)] = ex73277);


if((ex73277 instanceof Error)){
var statearr_73283_73353 = state_73221__$1;
(statearr_73283_73353[(1)] = (4));

(statearr_73283_73353[(5)] = null);

} else {
throw ex73277;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (14))){
var inst_73117 = (state_73221[(8)]);
var state_73221__$1 = state_73221;
var statearr_73284_73354 = state_73221__$1;
(statearr_73284_73354[(2)] = inst_73117);

(statearr_73284_73354[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (45))){
var inst_73117 = (state_73221[(8)]);
var inst_73182 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_73117,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_73117,funType,params));
var state_73221__$1 = state_73221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73221__$1,(48),inst_73182);
} else {
if((state_val_73222 === (26))){
var inst_73140 = (state_73221[(9)]);
var state_73221__$1 = state_73221;
var statearr_73285_73355 = state_73221__$1;
(statearr_73285_73355[(2)] = inst_73140);

(statearr_73285_73355[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (16))){
var inst_73208 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73286_73356 = state_73221__$1;
(statearr_73286_73356[(2)] = inst_73208);

(statearr_73286_73356[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (38))){
var inst_73117 = (state_73221[(8)]);
var inst_73172 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_73117,funType,params);
var state_73221__$1 = state_73221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73221__$1,(41),inst_73172);
} else {
if((state_val_73222 === (30))){
var inst_73160 = (state_73221[(17)]);
var inst_73117 = (state_73221[(8)]);
var inst_73160__$1 = inst_73117 === false;
var state_73221__$1 = (function (){var statearr_73287 = state_73221;
(statearr_73287[(17)] = inst_73160__$1);

return statearr_73287;
})();
if(cljs.core.truth_(inst_73160__$1)){
var statearr_73288_73357 = state_73221__$1;
(statearr_73288_73357[(1)] = (32));

} else {
var statearr_73289_73358 = state_73221__$1;
(statearr_73289_73358[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (10))){
var inst_73214 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73290_73359 = state_73221__$1;
(statearr_73290_73359[(2)] = inst_73214);

(statearr_73290_73359[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (18))){
var inst_73157 = (state_73221[(18)]);
var inst_73117 = (state_73221[(8)]);
var inst_73157__$1 = inst_73117 === true;
var state_73221__$1 = (function (){var statearr_73291 = state_73221;
(statearr_73291[(18)] = inst_73157__$1);

return statearr_73291;
})();
if(cljs.core.truth_(inst_73157__$1)){
var statearr_73292_73360 = state_73221__$1;
(statearr_73292_73360[(1)] = (29));

} else {
var statearr_73293_73361 = state_73221__$1;
(statearr_73293_73361[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (42))){
var inst_73117 = (state_73221[(8)]);
var state_73221__$1 = state_73221;
var statearr_73294_73362 = state_73221__$1;
(statearr_73294_73362[(2)] = inst_73117);

(statearr_73294_73362[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (37))){
var inst_73204 = (state_73221[(2)]);
var state_73221__$1 = state_73221;
var statearr_73295_73363 = state_73221__$1;
(statearr_73295_73363[(2)] = inst_73204);

(statearr_73295_73363[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (8))){
var inst_73111 = (state_73221[(10)]);
var state_73221__$1 = state_73221;
var statearr_73296_73364 = state_73221__$1;
(statearr_73296_73364[(2)] = inst_73111);

(statearr_73296_73364[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73222 === (49))){
var inst_73117 = (state_73221[(8)]);
var inst_73188 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73117], 0));
var inst_73189 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_73190 = ["Illegal element (",inst_73188,") in vector: ",inst_73189,"."].join('');
var inst_73191 = cljs.core.PersistentHashMap.EMPTY;
var inst_73192 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73190,inst_73191);
var inst_73193 = (function(){throw inst_73192})();
var state_73221__$1 = state_73221;
var statearr_73297_73365 = state_73221__$1;
(statearr_73297_73365[(2)] = inst_73193);

(statearr_73297_73365[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__16395__auto____0 = (function (){
var statearr_73298 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73298[(0)] = fluree$db$dbfunctions$core$state_machine__16395__auto__);

(statearr_73298[(1)] = (1));

return statearr_73298;
});
var fluree$db$dbfunctions$core$state_machine__16395__auto____1 = (function (state_73221){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_73221);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e73299){var ex__16398__auto__ = e73299;
var statearr_73300_73366 = state_73221;
(statearr_73300_73366[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_73221[(4)]))){
var statearr_73301_73367 = state_73221;
(statearr_73301_73367[(1)] = cljs.core.first((state_73221[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__73368 = state_73221;
state_73221 = G__73368;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__16395__auto__ = function(state_73221){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__16395__auto____1.call(this,state_73221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__16395__auto____0;
fluree$db$dbfunctions$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__16395__auto____1;
return fluree$db$dbfunctions$core$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_73302 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_73302[(6)] = c__16469__auto__);

return statearr_73302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Looks up function in local-function map. If exists returns map of function details,
 *   if doesn't exist returns nil.
 */
fluree.db.dbfunctions.core.find_local_fn_STAR_ = (function fluree$db$dbfunctions$core$find_local_fn_STAR_(fn_name){
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name));
if(cljs.core.truth_(temp__5753__auto__)){
var local_fn = temp__5753__auto__;
return fluree.db.dbfunctions.core.resolve_local_fn(local_fn);
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_local_fn = cljs.core.memoize(fluree.db.dbfunctions.core.find_local_fn_STAR_);
/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__73371 = arguments.length;
switch (G__73371) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_73535){
var state_val_73536 = (state_73535[(1)]);
if((state_val_73536 === (7))){
var inst_73379 = (state_73535[(7)]);
var inst_73385 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_73379,type);
var state_73535__$1 = state_73535;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73535__$1,(9),inst_73385);
} else {
if((state_val_73536 === (59))){
var inst_73428 = (state_73535[(8)]);
var inst_73499 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73428], 0));
var inst_73500 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_73428) : type.call(null,inst_73428));
var inst_73501 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_73502 = ["Illegal element (",inst_73499,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73500),") in function argument: ",inst_73501,"."].join('');
var inst_73503 = cljs.core.PersistentHashMap.EMPTY;
var inst_73504 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73502,inst_73503);
var inst_73505 = (function(){throw inst_73504})();
var state_73535__$1 = state_73535;
var statearr_73537_73632 = state_73535__$1;
(statearr_73537_73632[(2)] = inst_73505);

(statearr_73537_73632[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (20))){
var inst_73434 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
if(cljs.core.truth_(inst_73434)){
var statearr_73538_73633 = state_73535__$1;
(statearr_73538_73633[(1)] = (21));

} else {
var statearr_73539_73634 = state_73535__$1;
(statearr_73539_73634[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (58))){
var inst_73495 = (state_73535[(2)]);
var inst_73496 = fluree.db.util.async.throw_err(inst_73495);
var state_73535__$1 = state_73535;
var statearr_73540_73635 = state_73535__$1;
(statearr_73540_73635[(2)] = inst_73496);

(statearr_73540_73635[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (60))){
var state_73535__$1 = state_73535;
var statearr_73541_73636 = state_73535__$1;
(statearr_73541_73636[(2)] = null);

(statearr_73541_73636[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (27))){
var inst_73440 = (state_73535[(2)]);
var inst_73441 = fluree.db.util.async.throw_err(inst_73440);
var state_73535__$1 = state_73535;
var statearr_73542_73637 = state_73535__$1;
(statearr_73542_73637[(2)] = inst_73441);

(statearr_73542_73637[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (1))){
var state_73535__$1 = state_73535;
var statearr_73543_73638 = state_73535__$1;
(statearr_73543_73638[(2)] = null);

(statearr_73543_73638[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (24))){
var inst_73428 = (state_73535[(8)]);
var inst_73438 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_73428,type,params);
var state_73535__$1 = state_73535;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73535__$1,(27),inst_73438);
} else {
if((state_val_73536 === (55))){
var inst_73428 = (state_73535[(8)]);
var inst_73493 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_73428,type,params);
var state_73535__$1 = state_73535;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73535__$1,(58),inst_73493);
} else {
if((state_val_73536 === (39))){
var inst_73476 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
var statearr_73544_73639 = state_73535__$1;
(statearr_73544_73639[(2)] = inst_73476);

(statearr_73544_73639[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (46))){
var inst_73478 = (state_73535[(9)]);
var state_73535__$1 = state_73535;
var statearr_73545_73640 = state_73535__$1;
(statearr_73545_73640[(2)] = inst_73478);

(statearr_73545_73640[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (4))){
var inst_73372 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
var statearr_73546_73641 = state_73535__$1;
(statearr_73546_73641[(2)] = inst_73372);

(statearr_73546_73641[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (54))){
var inst_73512 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
var statearr_73547_73642 = state_73535__$1;
(statearr_73547_73642[(2)] = inst_73512);

(statearr_73547_73642[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (15))){
var inst_73380 = (state_73535[(10)]);
var inst_73409 = (state_73535[(2)]);
var inst_73417 = cljs.core.seq(inst_73380);
var inst_73418 = cljs.core.first(inst_73417);
var inst_73419 = cljs.core.next(inst_73417);
var inst_73420 = cljs.core.PersistentVector.EMPTY;
var inst_73421 = inst_73380;
var inst_73422 = inst_73420;
var state_73535__$1 = (function (){var statearr_73548 = state_73535;
(statearr_73548[(11)] = inst_73422);

(statearr_73548[(12)] = inst_73419);

(statearr_73548[(13)] = inst_73421);

(statearr_73548[(14)] = inst_73409);

(statearr_73548[(15)] = inst_73418);

return statearr_73548;
})();
var statearr_73549_73643 = state_73535__$1;
(statearr_73549_73643[(2)] = null);

(statearr_73549_73643[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (48))){
var inst_73488 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
if(cljs.core.truth_(inst_73488)){
var statearr_73550_73644 = state_73535__$1;
(statearr_73550_73644[(1)] = (52));

} else {
var statearr_73551_73645 = state_73535__$1;
(statearr_73551_73645[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (50))){
var inst_73428 = (state_73535[(8)]);
var inst_73484 = (inst_73428 == null);
var state_73535__$1 = state_73535;
var statearr_73552_73646 = state_73535__$1;
(statearr_73552_73646[(2)] = inst_73484);

(statearr_73552_73646[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (21))){
var inst_73428 = (state_73535[(8)]);
var inst_73436 = cljs.core.list_QMARK_(inst_73428);
var state_73535__$1 = state_73535;
if(inst_73436){
var statearr_73553_73647 = state_73535__$1;
(statearr_73553_73647[(1)] = (24));

} else {
var statearr_73554_73648 = state_73535__$1;
(statearr_73554_73648[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (31))){
var inst_73428 = (state_73535[(8)]);
var state_73535__$1 = state_73535;
var statearr_73555_73649 = state_73535__$1;
(statearr_73555_73649[(2)] = inst_73428);

(statearr_73555_73649[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (32))){
var inst_73428 = (state_73535[(8)]);
var inst_73449 = (inst_73428 instanceof cljs.core.Symbol);
var state_73535__$1 = state_73535;
if(cljs.core.truth_(inst_73449)){
var statearr_73556_73650 = state_73535__$1;
(statearr_73556_73650[(1)] = (34));

} else {
var statearr_73557_73651 = state_73535__$1;
(statearr_73557_73651[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (40))){
var inst_73458 = (state_73535[(16)]);
var state_73535__$1 = state_73535;
var statearr_73558_73652 = state_73535__$1;
(statearr_73558_73652[(2)] = inst_73458);

(statearr_73558_73652[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (56))){
var state_73535__$1 = state_73535;
var statearr_73559_73653 = state_73535__$1;
(statearr_73559_73653[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (33))){
var inst_73516 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
var statearr_73561_73654 = state_73535__$1;
(statearr_73561_73654[(2)] = inst_73516);

(statearr_73561_73654[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (13))){
var inst_73393 = (state_73535[(17)]);
var inst_73381 = (state_73535[(18)]);
var inst_73379 = (state_73535[(7)]);
var inst_73403 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73379),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73393),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73381),"."].join('');
var inst_73404 = cljs.core.PersistentHashMap.EMPTY;
var inst_73405 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73403,inst_73404);
var inst_73406 = (function(){throw inst_73405})();
var state_73535__$1 = state_73535;
var statearr_73562_73655 = state_73535__$1;
(statearr_73562_73655[(2)] = inst_73406);

(statearr_73562_73655[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (22))){
var inst_73422 = (state_73535[(11)]);
var state_73535__$1 = state_73535;
var statearr_73563_73656 = state_73535__$1;
(statearr_73563_73656[(2)] = inst_73422);

(statearr_73563_73656[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (36))){
var inst_73514 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
var statearr_73564_73657 = state_73535__$1;
(statearr_73564_73657[(2)] = inst_73514);

(statearr_73564_73657[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (41))){
var inst_73461 = (state_73535[(19)]);
var inst_73461__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_73535__$1 = (function (){var statearr_73565 = state_73535;
(statearr_73565[(19)] = inst_73461__$1);

return statearr_73565;
})();
if(inst_73461__$1){
var statearr_73566_73658 = state_73535__$1;
(statearr_73566_73658[(1)] = (43));

} else {
var statearr_73567_73659 = state_73535__$1;
(statearr_73567_73659[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (43))){
var inst_73461 = (state_73535[(19)]);
var state_73535__$1 = state_73535;
var statearr_73568_73660 = state_73535__$1;
(statearr_73568_73660[(2)] = inst_73461);

(statearr_73568_73660[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (61))){
var inst_73508 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
var statearr_73569_73661 = state_73535__$1;
(statearr_73569_73661[(2)] = inst_73508);

(statearr_73569_73661[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (29))){
var inst_73428 = (state_73535[(8)]);
var inst_73446 = typeof inst_73428 === 'number';
var state_73535__$1 = state_73535;
if(cljs.core.truth_(inst_73446)){
var statearr_73570_73662 = state_73535__$1;
(statearr_73570_73662[(1)] = (31));

} else {
var statearr_73571_73663 = state_73535__$1;
(statearr_73571_73663[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (44))){
var inst_73428 = (state_73535[(8)]);
var inst_73464 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_73465 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73428)," used in function argument: ",inst_73464].join('');
var inst_73466 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73467 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_73468 = cljs.core.PersistentHashMap.fromArrays(inst_73466,inst_73467);
var inst_73469 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73465,inst_73468);
var inst_73470 = (function(){throw inst_73469})();
var state_73535__$1 = state_73535;
var statearr_73572_73664 = state_73535__$1;
(statearr_73572_73664[(2)] = inst_73470);

(statearr_73572_73664[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (6))){
var inst_73382 = (state_73535[(20)]);
var state_73535__$1 = state_73535;
var statearr_73573_73665 = state_73535__$1;
(statearr_73573_73665[(2)] = inst_73382);

(statearr_73573_73665[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (28))){
var inst_73428 = (state_73535[(8)]);
var state_73535__$1 = state_73535;
var statearr_73574_73666 = state_73535__$1;
(statearr_73574_73666[(2)] = inst_73428);

(statearr_73574_73666[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (51))){
var inst_73486 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
var statearr_73575_73667 = state_73535__$1;
(statearr_73575_73667[(2)] = inst_73486);

(statearr_73575_73667[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (25))){
var inst_73428 = (state_73535[(8)]);
var inst_73443 = typeof inst_73428 === 'string';
var state_73535__$1 = state_73535;
if(cljs.core.truth_(inst_73443)){
var statearr_73576_73668 = state_73535__$1;
(statearr_73576_73668[(1)] = (28));

} else {
var statearr_73577_73669 = state_73535__$1;
(statearr_73577_73669[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (34))){
var inst_73428 = (state_73535[(8)]);
var inst_73451 = (state_73535[(21)]);
var inst_73451__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_73428) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_73428));
var state_73535__$1 = (function (){var statearr_73578 = state_73535;
(statearr_73578[(21)] = inst_73451__$1);

return statearr_73578;
})();
if(cljs.core.truth_(inst_73451__$1)){
var statearr_73579_73670 = state_73535__$1;
(statearr_73579_73670[(1)] = (37));

} else {
var statearr_73580_73671 = state_73535__$1;
(statearr_73580_73671[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (17))){
var inst_73392 = (state_73535[(22)]);
var inst_73527 = (state_73535[(2)]);
var inst_73528 = cljs.core.cst$sym$_QMARK_ctx;
var inst_73529 = cljs.core.cons(inst_73528,inst_73527);
var inst_73530 = cljs.core.cons(inst_73392,inst_73529);
var _ = (function (){var statearr_73581 = state_73535;
(statearr_73581[(4)] = cljs.core.rest((state_73535[(4)])));

return statearr_73581;
})();
var state_73535__$1 = state_73535;
var statearr_73582_73672 = state_73535__$1;
(statearr_73582_73672[(2)] = inst_73530);

(statearr_73582_73672[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (3))){
var inst_73533 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73535__$1,inst_73533);
} else {
if((state_val_73536 === (12))){
var inst_73400 = (state_73535[(2)]);
var inst_73401 = cljs.core.not(inst_73400);
var state_73535__$1 = state_73535;
if(inst_73401){
var statearr_73583_73673 = state_73535__$1;
(statearr_73583_73673[(1)] = (13));

} else {
var statearr_73584_73674 = state_73535__$1;
(statearr_73584_73674[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (2))){
var inst_73382 = (state_73535[(20)]);
var inst_73380 = (state_73535[(10)]);
var inst_73379 = (state_73535[(7)]);
var _ = (function (){var statearr_73585 = state_73535;
(statearr_73585[(4)] = cljs.core.cons((5),(state_73535[(4)])));

return statearr_73585;
})();
var inst_73379__$1 = cljs.core.first(form);
var inst_73380__$1 = cljs.core.rest(form);
var inst_73381 = cljs.core.count(inst_73380__$1);
var inst_73382__$1 = (fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1(inst_73379__$1) : fluree.db.dbfunctions.core.find_local_fn.call(null,inst_73379__$1));
var state_73535__$1 = (function (){var statearr_73586 = state_73535;
(statearr_73586[(20)] = inst_73382__$1);

(statearr_73586[(10)] = inst_73380__$1);

(statearr_73586[(18)] = inst_73381);

(statearr_73586[(7)] = inst_73379__$1);

return statearr_73586;
})();
if(cljs.core.truth_(inst_73382__$1)){
var statearr_73587_73675 = state_73535__$1;
(statearr_73587_73675[(1)] = (6));

} else {
var statearr_73588_73676 = state_73535__$1;
(statearr_73588_73676[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (23))){
var inst_73525 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
var statearr_73589_73677 = state_73535__$1;
(statearr_73589_73677[(2)] = inst_73525);

(statearr_73589_73677[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (47))){
var inst_73481 = (state_73535[(23)]);
var inst_73428 = (state_73535[(8)]);
var inst_73481__$1 = inst_73428 === false;
var state_73535__$1 = (function (){var statearr_73590 = state_73535;
(statearr_73590[(23)] = inst_73481__$1);

return statearr_73590;
})();
if(cljs.core.truth_(inst_73481__$1)){
var statearr_73591_73678 = state_73535__$1;
(statearr_73591_73678[(1)] = (49));

} else {
var statearr_73592_73679 = state_73535__$1;
(statearr_73592_73679[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (35))){
var inst_73428 = (state_73535[(8)]);
var inst_73478 = (state_73535[(9)]);
var inst_73478__$1 = inst_73428 === true;
var state_73535__$1 = (function (){var statearr_73593 = state_73535;
(statearr_73593[(9)] = inst_73478__$1);

return statearr_73593;
})();
if(cljs.core.truth_(inst_73478__$1)){
var statearr_73594_73680 = state_73535__$1;
(statearr_73594_73680[(1)] = (46));

} else {
var statearr_73595_73681 = state_73535__$1;
(statearr_73595_73681[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (19))){
var inst_73428 = (state_73535[(8)]);
var inst_73432 = inst_73428 === false;
var state_73535__$1 = state_73535;
var statearr_73596_73682 = state_73535__$1;
(statearr_73596_73682[(2)] = inst_73432);

(statearr_73596_73682[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (57))){
var inst_73510 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
var statearr_73597_73683 = state_73535__$1;
(statearr_73597_73683[(2)] = inst_73510);

(statearr_73597_73683[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (11))){
var inst_73393 = (state_73535[(17)]);
var inst_73381 = (state_73535[(18)]);
var inst_73398 = (inst_73393.cljs$core$IFn$_invoke$arity$1 ? inst_73393.cljs$core$IFn$_invoke$arity$1(inst_73381) : inst_73393.call(null,inst_73381));
var state_73535__$1 = state_73535;
var statearr_73599_73684 = state_73535__$1;
(statearr_73599_73684[(2)] = inst_73398);

(statearr_73599_73684[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (9))){
var inst_73387 = (state_73535[(2)]);
var inst_73388 = fluree.db.util.async.throw_err(inst_73387);
var state_73535__$1 = state_73535;
var statearr_73600_73685 = state_73535__$1;
(statearr_73600_73685[(2)] = inst_73388);

(statearr_73600_73685[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (5))){
var _ = (function (){var statearr_73601 = state_73535;
(statearr_73601[(4)] = cljs.core.rest((state_73535[(4)])));

return statearr_73601;
})();
var state_73535__$1 = state_73535;
var ex73598 = (state_73535__$1[(2)]);
var statearr_73602_73686 = state_73535__$1;
(statearr_73602_73686[(5)] = ex73598);


if((ex73598 instanceof Error)){
var statearr_73603_73687 = state_73535__$1;
(statearr_73603_73687[(1)] = (4));

(statearr_73603_73687[(5)] = null);

} else {
throw ex73598;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (14))){
var state_73535__$1 = state_73535;
var statearr_73604_73688 = state_73535__$1;
(statearr_73604_73688[(2)] = null);

(statearr_73604_73688[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (45))){
var inst_73472 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
var statearr_73605_73689 = state_73535__$1;
(statearr_73605_73689[(2)] = inst_73472);

(statearr_73605_73689[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (53))){
var inst_73428 = (state_73535[(8)]);
var inst_73491 = cljs.core.vector_QMARK_(inst_73428);
var state_73535__$1 = state_73535;
if(inst_73491){
var statearr_73606_73690 = state_73535__$1;
(statearr_73606_73690[(1)] = (55));

} else {
var statearr_73607_73691 = state_73535__$1;
(statearr_73607_73691[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (26))){
var inst_73422 = (state_73535[(11)]);
var inst_73429 = (state_73535[(24)]);
var inst_73520 = (state_73535[(2)]);
var inst_73521 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_73422,inst_73520);
var inst_73421 = inst_73429;
var inst_73422__$1 = inst_73521;
var state_73535__$1 = (function (){var statearr_73608 = state_73535;
(statearr_73608[(11)] = inst_73422__$1);

(statearr_73608[(13)] = inst_73421);

return statearr_73608;
})();
var statearr_73609_73692 = state_73535__$1;
(statearr_73609_73692[(2)] = null);

(statearr_73609_73692[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (16))){
var inst_73428 = (state_73535[(8)]);
var inst_73421 = (state_73535[(13)]);
var inst_73427 = cljs.core.seq(inst_73421);
var inst_73428__$1 = cljs.core.first(inst_73427);
var inst_73429 = cljs.core.next(inst_73427);
var state_73535__$1 = (function (){var statearr_73610 = state_73535;
(statearr_73610[(8)] = inst_73428__$1);

(statearr_73610[(24)] = inst_73429);

return statearr_73610;
})();
if(cljs.core.truth_(inst_73428__$1)){
var statearr_73611_73693 = state_73535__$1;
(statearr_73611_73693[(1)] = (18));

} else {
var statearr_73612_73694 = state_73535__$1;
(statearr_73612_73694[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (38))){
var inst_73428 = (state_73535[(8)]);
var inst_73422 = (state_73535[(11)]);
var inst_73393 = (state_73535[(17)]);
var inst_73419 = (state_73535[(12)]);
var inst_73421 = (state_73535[(13)]);
var inst_73395 = (state_73535[(25)]);
var inst_73391 = (state_73535[(26)]);
var inst_73394 = (state_73535[(27)]);
var inst_73409 = (state_73535[(14)]);
var inst_73390 = (state_73535[(28)]);
var inst_73451 = (state_73535[(21)]);
var inst_73429 = (state_73535[(24)]);
var inst_73392 = (state_73535[(22)]);
var inst_73380 = (state_73535[(10)]);
var inst_73458 = (state_73535[(16)]);
var inst_73381 = (state_73535[(18)]);
var inst_73418 = (state_73535[(15)]);
var inst_73379 = (state_73535[(7)]);
var inst_73454 = [inst_73428];
var inst_73455 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_73454);
var inst_73456 = (function (){var arity = inst_73393;
var args_n = inst_73381;
var fn_map = inst_73390;
var first__73426 = inst_73428;
var args = inst_73380;
var seq__73415 = inst_73419;
var vec__73414 = inst_73380;
var r = inst_73429;
var first__73416 = inst_73418;
var G__73413 = inst_73421;
var or__4212__auto__ = inst_73451;
var _ = inst_73409;
var acc = inst_73422;
var arglist = inst_73394;
var seq__73425 = inst_73429;
var map__73378 = inst_73391;
var fn_name = inst_73379;
var _AMPERSAND_args_QMARK_ = inst_73395;
var arg = inst_73428;
var vec__73424 = inst_73421;
var f = inst_73392;
return (function (p1__73369_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__73369_SHARP_);
});
})();
var inst_73457 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_73456,params);
var inst_73458__$1 = cljs.core.some(inst_73455,inst_73457);
var state_73535__$1 = (function (){var statearr_73613 = state_73535;
(statearr_73613[(16)] = inst_73458__$1);

return statearr_73613;
})();
if(cljs.core.truth_(inst_73458__$1)){
var statearr_73614_73695 = state_73535__$1;
(statearr_73614_73695[(1)] = (40));

} else {
var statearr_73615_73696 = state_73535__$1;
(statearr_73615_73696[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (30))){
var inst_73518 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
var statearr_73616_73697 = state_73535__$1;
(statearr_73616_73697[(2)] = inst_73518);

(statearr_73616_73697[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (10))){
var inst_73395 = (state_73535[(25)]);
var state_73535__$1 = state_73535;
var statearr_73617_73698 = state_73535__$1;
(statearr_73617_73698[(2)] = inst_73395);

(statearr_73617_73698[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (18))){
var inst_73428 = (state_73535[(8)]);
var state_73535__$1 = state_73535;
var statearr_73618_73699 = state_73535__$1;
(statearr_73618_73699[(2)] = inst_73428);

(statearr_73618_73699[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (52))){
var inst_73428 = (state_73535[(8)]);
var state_73535__$1 = state_73535;
var statearr_73619_73700 = state_73535__$1;
(statearr_73619_73700[(2)] = inst_73428);

(statearr_73619_73700[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (42))){
var inst_73474 = (state_73535[(2)]);
var state_73535__$1 = state_73535;
var statearr_73620_73701 = state_73535__$1;
(statearr_73620_73701[(2)] = inst_73474);

(statearr_73620_73701[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (37))){
var inst_73451 = (state_73535[(21)]);
var state_73535__$1 = state_73535;
var statearr_73621_73702 = state_73535__$1;
(statearr_73621_73702[(2)] = inst_73451);

(statearr_73621_73702[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (8))){
var inst_73395 = (state_73535[(25)]);
var inst_73391 = (state_73535[(26)]);
var inst_73390 = (state_73535[(28)]);
var inst_73390__$1 = (state_73535[(2)]);
var inst_73391__$1 = cljs.core.__destructure_map(inst_73390__$1);
var inst_73392 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73391__$1,cljs.core.cst$kw$f);
var inst_73393 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73391__$1,cljs.core.cst$kw$arity);
var inst_73394 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73391__$1,cljs.core.cst$kw$arglist);
var inst_73395__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73391__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_73535__$1 = (function (){var statearr_73622 = state_73535;
(statearr_73622[(17)] = inst_73393);

(statearr_73622[(25)] = inst_73395__$1);

(statearr_73622[(26)] = inst_73391__$1);

(statearr_73622[(27)] = inst_73394);

(statearr_73622[(28)] = inst_73390__$1);

(statearr_73622[(22)] = inst_73392);

return statearr_73622;
})();
if(cljs.core.truth_(inst_73395__$1)){
var statearr_73623_73703 = state_73535__$1;
(statearr_73623_73703[(1)] = (10));

} else {
var statearr_73624_73704 = state_73535__$1;
(statearr_73624_73704[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73536 === (49))){
var inst_73481 = (state_73535[(23)]);
var state_73535__$1 = state_73535;
var statearr_73625_73705 = state_73535__$1;
(statearr_73625_73705[(2)] = inst_73481);

(statearr_73625_73705[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__16395__auto____0 = (function (){
var statearr_73626 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73626[(0)] = fluree$db$dbfunctions$core$state_machine__16395__auto__);

(statearr_73626[(1)] = (1));

return statearr_73626;
});
var fluree$db$dbfunctions$core$state_machine__16395__auto____1 = (function (state_73535){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_73535);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e73627){var ex__16398__auto__ = e73627;
var statearr_73628_73706 = state_73535;
(statearr_73628_73706[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_73535[(4)]))){
var statearr_73629_73707 = state_73535;
(statearr_73629_73707[(1)] = cljs.core.first((state_73535[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__73708 = state_73535;
state_73535 = G__73708;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__16395__auto__ = function(state_73535){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__16395__auto____1.call(this,state_73535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__16395__auto____0;
fluree$db$dbfunctions$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__16395__auto____1;
return fluree$db$dbfunctions$core$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_73630 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_73630[(6)] = c__16469__auto__);

return statearr_73630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__73710 = arguments.length;
switch (G__73710) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_73792){
var state_val_73793 = (state_73792[(1)]);
if((state_val_73793 === (7))){
var inst_73720 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var state_73792__$1 = state_73792;
var statearr_73794_73842 = state_73792__$1;
(statearr_73794_73842[(2)] = inst_73720);

(statearr_73794_73842[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (20))){
var inst_73770 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_73792__$1 = state_73792;
var statearr_73795_73843 = state_73792__$1;
(statearr_73795_73843[(2)] = inst_73770);

(statearr_73795_73843[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (1))){
var state_73792__$1 = state_73792;
var statearr_73796_73844 = state_73792__$1;
(statearr_73796_73844[(2)] = null);

(statearr_73796_73844[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (24))){
var inst_73767 = (state_73792[(7)]);
var inst_73776 = cljs.core.eval(inst_73767);
var state_73792__$1 = state_73792;
var statearr_73798_73845 = state_73792__$1;
(statearr_73798_73845[(2)] = inst_73776);

(statearr_73798_73845[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (4))){
var inst_73711 = (state_73792[(2)]);
var state_73792__$1 = state_73792;
var statearr_73799_73846 = state_73792__$1;
(statearr_73799_73846[(2)] = inst_73711);

(statearr_73799_73846[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (15))){
var _ = (function (){var statearr_73800 = state_73792;
(statearr_73800[(4)] = cljs.core.rest((state_73792[(4)])));

return statearr_73800;
})();
var state_73792__$1 = state_73792;
var ex73797 = (state_73792__$1[(2)]);
var statearr_73801_73847 = state_73792__$1;
(statearr_73801_73847[(5)] = ex73797);


var statearr_73802_73848 = state_73792__$1;
(statearr_73802_73848[(1)] = (14));

(statearr_73802_73848[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (21))){
var inst_73768 = (state_73792[(8)]);
var state_73792__$1 = state_73792;
var statearr_73803_73849 = state_73792__$1;
(statearr_73803_73849[(2)] = inst_73768);

(statearr_73803_73849[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (13))){
var inst_73785 = (state_73792[(2)]);
var state_73792__$1 = state_73792;
var statearr_73804_73850 = state_73792__$1;
(statearr_73804_73850[(2)] = inst_73785);

(statearr_73804_73850[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (22))){
var inst_73773 = (state_73792[(2)]);
var state_73792__$1 = state_73792;
if(cljs.core.truth_(inst_73773)){
var statearr_73805_73851 = state_73792__$1;
(statearr_73805_73851[(1)] = (23));

} else {
var statearr_73806_73852 = state_73792__$1;
(statearr_73806_73852[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (6))){
var inst_73717 = (state_73792[(9)]);
var state_73792__$1 = state_73792;
var statearr_73807_73853 = state_73792__$1;
(statearr_73807_73853[(2)] = inst_73717);

(statearr_73807_73853[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (25))){
var inst_73778 = (state_73792[(2)]);
var inst_73779 = [cljs.core.cst$kw$fnstr];
var inst_73780 = [fn_str];
var inst_73781 = cljs.core.PersistentHashMap.fromArrays(inst_73779,inst_73780);
var inst_73782 = cljs.core.with_meta(inst_73778,inst_73781);
var _ = (function (){var statearr_73808 = state_73792;
(statearr_73808[(4)] = cljs.core.rest((state_73792[(4)])));

return statearr_73808;
})();
var state_73792__$1 = state_73792;
var statearr_73809_73854 = state_73792__$1;
(statearr_73809_73854[(2)] = inst_73782);

(statearr_73809_73854[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (17))){
var inst_73743 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73744 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_73745 = cljs.core.PersistentHashMap.fromArrays(inst_73743,inst_73744);
var inst_73746 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_73745);
var inst_73747 = (function(){throw inst_73746})();
var state_73792__$1 = state_73792;
var statearr_73810_73855 = state_73792__$1;
(statearr_73810_73855[(2)] = inst_73747);

(statearr_73810_73855[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (3))){
var inst_73790 = (state_73792[(2)]);
var state_73792__$1 = state_73792;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73792__$1,inst_73790);
} else {
if((state_val_73793 === (12))){
var _ = (function (){var statearr_73811 = state_73792;
(statearr_73811[(4)] = cljs.core.cons((15),(state_73792[(4)])));

return statearr_73811;
})();
var inst_73740 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_73792__$1 = state_73792;
if(cljs.core.truth_(inst_73740)){
var statearr_73812_73856 = state_73792__$1;
(statearr_73812_73856[(1)] = (16));

} else {
var statearr_73813_73857 = state_73792__$1;
(statearr_73813_73857[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (2))){
var inst_73717 = (state_73792[(9)]);
var _ = (function (){var statearr_73814 = state_73792;
(statearr_73814[(4)] = cljs.core.cons((5),(state_73792[(4)])));

return statearr_73814;
})();
var inst_73717__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var state_73792__$1 = (function (){var statearr_73815 = state_73792;
(statearr_73815[(9)] = inst_73717__$1);

return statearr_73815;
})();
if(inst_73717__$1){
var statearr_73816_73858 = state_73792__$1;
(statearr_73816_73858[(1)] = (6));

} else {
var statearr_73817_73859 = state_73792__$1;
(statearr_73817_73859[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (23))){
var inst_73767 = (state_73792[(7)]);
var state_73792__$1 = state_73792;
var statearr_73818_73860 = state_73792__$1;
(statearr_73818_73860[(2)] = inst_73767);

(statearr_73818_73860[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (19))){
var inst_73768 = (state_73792[(8)]);
var inst_73753 = (state_73792[(2)]);
var inst_73754 = fluree.db.util.async.throw_err(inst_73753);
var inst_73755 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_73756 = (new cljs.core.List(null,inst_73755,null,(1),null));
var inst_73757 = cljs.core.cst$sym$_QMARK_ctx;
var inst_73758 = (new cljs.core.List(null,inst_73757,null,(1),null));
var inst_73759 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_73758);
var inst_73760 = cljs.core.seq(inst_73759);
var inst_73761 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_73760);
var inst_73762 = cljs.core.vec(inst_73761);
var inst_73763 = (new cljs.core.List(null,inst_73762,null,(1),null));
var inst_73764 = (new cljs.core.List(null,inst_73754,null,(1),null));
var inst_73765 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_73756,inst_73763,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73764], 0));
var inst_73766 = cljs.core.seq(inst_73765);
var inst_73767 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_73766);
var inst_73768__$1 = params;
var state_73792__$1 = (function (){var statearr_73819 = state_73792;
(statearr_73819[(8)] = inst_73768__$1);

(statearr_73819[(7)] = inst_73767);

return statearr_73819;
})();
if(cljs.core.truth_(inst_73768__$1)){
var statearr_73820_73861 = state_73792__$1;
(statearr_73820_73861[(1)] = (20));

} else {
var statearr_73821_73862 = state_73792__$1;
(statearr_73821_73862[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (11))){
var inst_73787 = (state_73792[(2)]);
var _ = (function (){var statearr_73823 = state_73792;
(statearr_73823[(4)] = cljs.core.rest((state_73792[(4)])));

return statearr_73823;
})();
var state_73792__$1 = state_73792;
var statearr_73824_73863 = state_73792__$1;
(statearr_73824_73863[(2)] = inst_73787);

(statearr_73824_73863[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (9))){
var inst_73724 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_73725 = fluree.db.dbfunctions.core.true_or_false = inst_73724;
var state_73792__$1 = state_73792;
var statearr_73825_73864 = state_73792__$1;
(statearr_73825_73864[(2)] = inst_73725);

(statearr_73825_73864[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (5))){
var _ = (function (){var statearr_73826 = state_73792;
(statearr_73826[(4)] = cljs.core.rest((state_73792[(4)])));

return statearr_73826;
})();
var state_73792__$1 = state_73792;
var ex73822 = (state_73792__$1[(2)]);
var statearr_73827_73865 = state_73792__$1;
(statearr_73827_73865[(5)] = ex73822);


if((ex73822 instanceof Error)){
var statearr_73828_73866 = state_73792__$1;
(statearr_73828_73866[(1)] = (4));

(statearr_73828_73866[(5)] = null);

} else {
throw ex73822;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (14))){
var inst_73727 = (state_73792[(2)]);
var inst_73728 = (function(){throw inst_73727})();
var inst_73729 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_73730 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73731 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_73732 = cljs.core.PersistentHashMap.fromArrays(inst_73730,inst_73731);
var inst_73733 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73729,inst_73732);
var inst_73734 = (function(){throw inst_73733})();
var state_73792__$1 = (function (){var statearr_73829 = state_73792;
(statearr_73829[(10)] = inst_73728);

return statearr_73829;
})();
var statearr_73830_73867 = state_73792__$1;
(statearr_73830_73867[(2)] = inst_73734);

(statearr_73830_73867[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (16))){
var state_73792__$1 = state_73792;
var statearr_73831_73868 = state_73792__$1;
(statearr_73831_73868[(2)] = null);

(statearr_73831_73868[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (10))){
var state_73792__$1 = state_73792;
var statearr_73832_73869 = state_73792__$1;
(statearr_73832_73869[(2)] = null);

(statearr_73832_73869[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73793 === (18))){
var inst_73749 = (state_73792[(2)]);
var inst_73750 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_73751 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_73750,type,params);
var state_73792__$1 = (function (){var statearr_73833 = state_73792;
(statearr_73833[(11)] = inst_73749);

return statearr_73833;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73792__$1,(19),inst_73751);
} else {
if((state_val_73793 === (8))){
var inst_73722 = (state_73792[(2)]);
var state_73792__$1 = state_73792;
if(cljs.core.truth_(inst_73722)){
var statearr_73834_73870 = state_73792__$1;
(statearr_73834_73870[(1)] = (9));

} else {
var statearr_73835_73871 = state_73792__$1;
(statearr_73835_73871[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__16395__auto____0 = (function (){
var statearr_73836 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73836[(0)] = fluree$db$dbfunctions$core$state_machine__16395__auto__);

(statearr_73836[(1)] = (1));

return statearr_73836;
});
var fluree$db$dbfunctions$core$state_machine__16395__auto____1 = (function (state_73792){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_73792);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e73837){var ex__16398__auto__ = e73837;
var statearr_73838_73872 = state_73792;
(statearr_73838_73872[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_73792[(4)]))){
var statearr_73839_73873 = state_73792;
(statearr_73839_73873[(1)] = cljs.core.first((state_73792[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__73874 = state_73792;
state_73792 = G__73874;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__16395__auto__ = function(state_73792){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__16395__auto____1.call(this,state_73792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__16395__auto____0;
fluree$db$dbfunctions$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__16395__auto____1;
return fluree$db$dbfunctions$core$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_73840 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_73840[(6)] = c__16469__auto__);

return statearr_73840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_73902){
var state_val_73903 = (state_73902[(1)]);
if((state_val_73903 === (7))){
var inst_73889 = (state_73902[(7)]);
var state_73902__$1 = state_73902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73902__$1,(10),inst_73889);
} else {
if((state_val_73903 === (1))){
var state_73902__$1 = state_73902;
var statearr_73904_73924 = state_73902__$1;
(statearr_73904_73924[(2)] = null);

(statearr_73904_73924[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73903 === (4))){
var inst_73875 = (state_73902[(2)]);
var state_73902__$1 = state_73902;
var statearr_73905_73925 = state_73902__$1;
(statearr_73905_73925[(2)] = inst_73875);

(statearr_73905_73925[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73903 === (6))){
var inst_73889 = (state_73902[(7)]);
var inst_73884 = (state_73902[(8)]);
var inst_73887 = (state_73902[(2)]);
var inst_73888 = fluree.db.util.async.throw_err(inst_73887);
var inst_73889__$1 = (inst_73888.cljs$core$IFn$_invoke$arity$1 ? inst_73888.cljs$core$IFn$_invoke$arity$1(inst_73884) : inst_73888.call(null,inst_73884));
var inst_73890 = fluree.db.util.async.channel_QMARK_(inst_73889__$1);
var state_73902__$1 = (function (){var statearr_73906 = state_73902;
(statearr_73906[(7)] = inst_73889__$1);

return statearr_73906;
})();
if(inst_73890){
var statearr_73907_73926 = state_73902__$1;
(statearr_73907_73926[(1)] = (7));

} else {
var statearr_73908_73927 = state_73902__$1;
(statearr_73908_73927[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73903 === (3))){
var inst_73900 = (state_73902[(2)]);
var state_73902__$1 = state_73902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73902__$1,inst_73900);
} else {
if((state_val_73903 === (2))){
var _ = (function (){var statearr_73910 = state_73902;
(statearr_73910[(4)] = cljs.core.cons((5),(state_73902[(4)])));

return statearr_73910;
})();
var inst_73881 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_73882 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_73883 = [db,block_instant,s,p,auth_id,fuel];
var inst_73884 = cljs.core.PersistentHashMap.fromArrays(inst_73882,inst_73883);
var inst_73885 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_73881,"txn",null);
var state_73902__$1 = (function (){var statearr_73911 = state_73902;
(statearr_73911[(8)] = inst_73884);

return statearr_73911;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73902__$1,(6),inst_73885);
} else {
if((state_val_73903 === (9))){
var inst_73897 = (state_73902[(2)]);
var _ = (function (){var statearr_73912 = state_73902;
(statearr_73912[(4)] = cljs.core.rest((state_73902[(4)])));

return statearr_73912;
})();
var state_73902__$1 = state_73902;
var statearr_73913_73928 = state_73902__$1;
(statearr_73913_73928[(2)] = inst_73897);

(statearr_73913_73928[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73903 === (5))){
var _ = (function (){var statearr_73914 = state_73902;
(statearr_73914[(4)] = cljs.core.rest((state_73902[(4)])));

return statearr_73914;
})();
var state_73902__$1 = state_73902;
var ex73909 = (state_73902__$1[(2)]);
var statearr_73915_73929 = state_73902__$1;
(statearr_73915_73929[(5)] = ex73909);


if((ex73909 instanceof Error)){
var statearr_73916_73930 = state_73902__$1;
(statearr_73916_73930[(1)] = (4));

(statearr_73916_73930[(5)] = null);

} else {
throw ex73909;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73903 === (10))){
var inst_73893 = (state_73902[(2)]);
var inst_73894 = fluree.db.util.async.throw_err(inst_73893);
var state_73902__$1 = state_73902;
var statearr_73917_73931 = state_73902__$1;
(statearr_73917_73931[(2)] = inst_73894);

(statearr_73917_73931[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73903 === (8))){
var inst_73889 = (state_73902[(7)]);
var state_73902__$1 = state_73902;
var statearr_73918_73932 = state_73902__$1;
(statearr_73918_73932[(2)] = inst_73889);

(statearr_73918_73932[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto____0 = (function (){
var statearr_73919 = [null,null,null,null,null,null,null,null,null];
(statearr_73919[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto__);

(statearr_73919[(1)] = (1));

return statearr_73919;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto____1 = (function (state_73902){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_73902);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e73920){var ex__16398__auto__ = e73920;
var statearr_73921_73933 = state_73902;
(statearr_73921_73933[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_73902[(4)]))){
var statearr_73922_73934 = state_73902;
(statearr_73922_73934[(1)] = cljs.core.first((state_73902[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__73935 = state_73902;
state_73902 = G__73935;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto__ = function(state_73902){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto____1.call(this,state_73902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_73923 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_73923[(6)] = c__16469__auto__);

return statearr_73923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
