// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__73960_74129 = cljs.core.seq(servers);
var chunk__73961_74130 = null;
var count__73962_74131 = (0);
var i__73963_74132 = (0);
while(true){
if((i__73963_74132 < count__73962_74131)){
var server_74133 = chunk__73961_74130.cljs$core$IIndexed$_nth$arity$2(null,i__73963_74132);
var healthcheck_uri_74134 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_74133),"/fdb/health"].join('');
var resp_chan_74135 = fluree.db.util.xhttp.post_json(healthcheck_uri_74134,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__16469__auto___74136 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__73960_74129,chunk__73961_74130,count__73962_74131,i__73963_74132,c__16469__auto___74136,healthcheck_uri_74134,resp_chan_74135,server_74133){
return (function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = ((function (seq__73960_74129,chunk__73961_74130,count__73962_74131,i__73963_74132,c__16469__auto___74136,healthcheck_uri_74134,resp_chan_74135,server_74133){
return (function (state_74024){
var state_val_74025 = (state_74024[(1)]);
if((state_val_74025 === (1))){
var state_74024__$1 = state_74024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74024__$1,(2),resp_chan_74135);
} else {
if((state_val_74025 === (2))){
var inst_74013 = (state_74024[(7)]);
var inst_74013__$1 = (state_74024[(2)]);
var inst_74014 = fluree.db.util.core.exception_QMARK_(inst_74013__$1);
var state_74024__$1 = (function (){var statearr_74026 = state_74024;
(statearr_74026[(7)] = inst_74013__$1);

return statearr_74026;
})();
if(inst_74014){
var statearr_74027_74137 = state_74024__$1;
(statearr_74027_74137[(1)] = (3));

} else {
var statearr_74028_74138 = state_74024__$1;
(statearr_74028_74138[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74025 === (3))){
var inst_74013 = (state_74024[(7)]);
var inst_74016 = cljs.core.ex_message(inst_74013);
var inst_74017 = cljs.core.ex_data(inst_74013);
var inst_74018 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_74016,inst_74017], 0));
var state_74024__$1 = state_74024;
var statearr_74029_74139 = state_74024__$1;
(statearr_74029_74139[(2)] = inst_74018);

(statearr_74029_74139[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74025 === (4))){
var inst_74020 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_74133);
var state_74024__$1 = state_74024;
var statearr_74030_74140 = state_74024__$1;
(statearr_74030_74140[(2)] = inst_74020);

(statearr_74030_74140[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74025 === (5))){
var inst_74022 = (state_74024[(2)]);
var state_74024__$1 = state_74024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74024__$1,inst_74022);
} else {
return null;
}
}
}
}
}
});})(seq__73960_74129,chunk__73961_74130,count__73962_74131,i__73963_74132,c__16469__auto___74136,healthcheck_uri_74134,resp_chan_74135,server_74133))
;
return ((function (seq__73960_74129,chunk__73961_74130,count__73962_74131,i__73963_74132,switch__16394__auto__,c__16469__auto___74136,healthcheck_uri_74134,resp_chan_74135,server_74133){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0 = (function (){
var statearr_74031 = [null,null,null,null,null,null,null,null];
(statearr_74031[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__);

(statearr_74031[(1)] = (1));

return statearr_74031;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1 = (function (state_74024){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74024);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74032){var ex__16398__auto__ = e74032;
var statearr_74033_74141 = state_74024;
(statearr_74033_74141[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74024[(4)]))){
var statearr_74034_74142 = state_74024;
(statearr_74034_74142[(1)] = cljs.core.first((state_74024[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74143 = state_74024;
state_74024 = G__74143;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__ = function(state_74024){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1.call(this,state_74024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__;
})()
;})(seq__73960_74129,chunk__73961_74130,count__73962_74131,i__73963_74132,switch__16394__auto__,c__16469__auto___74136,healthcheck_uri_74134,resp_chan_74135,server_74133))
})();
var state__16471__auto__ = (function (){var statearr_74035 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74035[(6)] = c__16469__auto___74136);

return statearr_74035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
});})(seq__73960_74129,chunk__73961_74130,count__73962_74131,i__73963_74132,c__16469__auto___74136,healthcheck_uri_74134,resp_chan_74135,server_74133))
);



var G__74144 = seq__73960_74129;
var G__74145 = chunk__73961_74130;
var G__74146 = count__73962_74131;
var G__74147 = (i__73963_74132 + (1));
seq__73960_74129 = G__74144;
chunk__73961_74130 = G__74145;
count__73962_74131 = G__74146;
i__73963_74132 = G__74147;
continue;
} else {
var temp__5753__auto___74148 = cljs.core.seq(seq__73960_74129);
if(temp__5753__auto___74148){
var seq__73960_74149__$1 = temp__5753__auto___74148;
if(cljs.core.chunked_seq_QMARK_(seq__73960_74149__$1)){
var c__4638__auto___74150 = cljs.core.chunk_first(seq__73960_74149__$1);
var G__74151 = cljs.core.chunk_rest(seq__73960_74149__$1);
var G__74152 = c__4638__auto___74150;
var G__74153 = cljs.core.count(c__4638__auto___74150);
var G__74154 = (0);
seq__73960_74129 = G__74151;
chunk__73961_74130 = G__74152;
count__73962_74131 = G__74153;
i__73963_74132 = G__74154;
continue;
} else {
var server_74155 = cljs.core.first(seq__73960_74149__$1);
var healthcheck_uri_74156 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_74155),"/fdb/health"].join('');
var resp_chan_74157 = fluree.db.util.xhttp.post_json(healthcheck_uri_74156,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__16469__auto___74158 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__73960_74129,chunk__73961_74130,count__73962_74131,i__73963_74132,c__16469__auto___74158,healthcheck_uri_74156,resp_chan_74157,server_74155,seq__73960_74149__$1,temp__5753__auto___74148){
return (function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = ((function (seq__73960_74129,chunk__73961_74130,count__73962_74131,i__73963_74132,c__16469__auto___74158,healthcheck_uri_74156,resp_chan_74157,server_74155,seq__73960_74149__$1,temp__5753__auto___74148){
return (function (state_74048){
var state_val_74049 = (state_74048[(1)]);
if((state_val_74049 === (1))){
var state_74048__$1 = state_74048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74048__$1,(2),resp_chan_74157);
} else {
if((state_val_74049 === (2))){
var inst_74037 = (state_74048[(7)]);
var inst_74037__$1 = (state_74048[(2)]);
var inst_74038 = fluree.db.util.core.exception_QMARK_(inst_74037__$1);
var state_74048__$1 = (function (){var statearr_74050 = state_74048;
(statearr_74050[(7)] = inst_74037__$1);

return statearr_74050;
})();
if(inst_74038){
var statearr_74051_74159 = state_74048__$1;
(statearr_74051_74159[(1)] = (3));

} else {
var statearr_74052_74160 = state_74048__$1;
(statearr_74052_74160[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74049 === (3))){
var inst_74037 = (state_74048[(7)]);
var inst_74040 = cljs.core.ex_message(inst_74037);
var inst_74041 = cljs.core.ex_data(inst_74037);
var inst_74042 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_74040,inst_74041], 0));
var state_74048__$1 = state_74048;
var statearr_74053_74161 = state_74048__$1;
(statearr_74053_74161[(2)] = inst_74042);

(statearr_74053_74161[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74049 === (4))){
var inst_74044 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_74155);
var state_74048__$1 = state_74048;
var statearr_74054_74162 = state_74048__$1;
(statearr_74054_74162[(2)] = inst_74044);

(statearr_74054_74162[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74049 === (5))){
var inst_74046 = (state_74048[(2)]);
var state_74048__$1 = state_74048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74048__$1,inst_74046);
} else {
return null;
}
}
}
}
}
});})(seq__73960_74129,chunk__73961_74130,count__73962_74131,i__73963_74132,c__16469__auto___74158,healthcheck_uri_74156,resp_chan_74157,server_74155,seq__73960_74149__$1,temp__5753__auto___74148))
;
return ((function (seq__73960_74129,chunk__73961_74130,count__73962_74131,i__73963_74132,switch__16394__auto__,c__16469__auto___74158,healthcheck_uri_74156,resp_chan_74157,server_74155,seq__73960_74149__$1,temp__5753__auto___74148){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0 = (function (){
var statearr_74055 = [null,null,null,null,null,null,null,null];
(statearr_74055[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__);

(statearr_74055[(1)] = (1));

return statearr_74055;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1 = (function (state_74048){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74048);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74056){var ex__16398__auto__ = e74056;
var statearr_74057_74163 = state_74048;
(statearr_74057_74163[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74048[(4)]))){
var statearr_74058_74164 = state_74048;
(statearr_74058_74164[(1)] = cljs.core.first((state_74048[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74165 = state_74048;
state_74048 = G__74165;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__ = function(state_74048){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1.call(this,state_74048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__;
})()
;})(seq__73960_74129,chunk__73961_74130,count__73962_74131,i__73963_74132,switch__16394__auto__,c__16469__auto___74158,healthcheck_uri_74156,resp_chan_74157,server_74155,seq__73960_74149__$1,temp__5753__auto___74148))
})();
var state__16471__auto__ = (function (){var statearr_74059 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74059[(6)] = c__16469__auto___74158);

return statearr_74059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
});})(seq__73960_74129,chunk__73961_74130,count__73962_74131,i__73963_74132,c__16469__auto___74158,healthcheck_uri_74156,resp_chan_74157,server_74155,seq__73960_74149__$1,temp__5753__auto___74148))
);



var G__74166 = cljs.core.next(seq__73960_74149__$1);
var G__74167 = null;
var G__74168 = (0);
var G__74169 = (0);
seq__73960_74129 = G__74166;
chunk__73961_74130 = G__74167;
count__73962_74131 = G__74168;
i__73963_74132 = G__74169;
continue;
}
} else {
}
}
break;
}

var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74103){
var state_val_74104 = (state_74103[(1)]);
if((state_val_74104 === (7))){
var inst_74075 = (state_74103[(7)]);
var inst_74082 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74075,cljs.core.cst$kw$default);
var state_74103__$1 = state_74103;
if(inst_74082){
var statearr_74105_74170 = state_74103__$1;
(statearr_74105_74170[(1)] = (9));

} else {
var statearr_74106_74171 = state_74103__$1;
(statearr_74106_74171[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74104 === (1))){
var inst_74068 = (state_74103[(8)]);
var inst_74067 = (state_74103[(9)]);
var inst_74067__$1 = promise_chan;
var inst_74068__$1 = cljs.core.async.timeout((60000));
var inst_74069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74070 = [inst_74067__$1,inst_74068__$1];
var inst_74071 = (new cljs.core.PersistentVector(null,2,(5),inst_74069,inst_74070,null));
var state_74103__$1 = (function (){var statearr_74107 = state_74103;
(statearr_74107[(8)] = inst_74068__$1);

(statearr_74107[(9)] = inst_74067__$1);

return statearr_74107;
})();
return cljs.core.async.ioc_alts_BANG_(state_74103__$1,(2),inst_74071);
} else {
if((state_val_74104 === (4))){
var inst_74068 = (state_74103[(8)]);
var inst_74075 = (state_74103[(7)]);
var inst_74079 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74075,inst_74068);
var state_74103__$1 = state_74103;
if(inst_74079){
var statearr_74108_74172 = state_74103__$1;
(statearr_74108_74172[(1)] = (6));

} else {
var statearr_74109_74173 = state_74103__$1;
(statearr_74109_74173[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74104 === (13))){
var state_74103__$1 = state_74103;
var statearr_74110_74174 = state_74103__$1;
(statearr_74110_74174[(2)] = null);

(statearr_74110_74174[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74104 === (6))){
var state_74103__$1 = state_74103;
var statearr_74111_74175 = state_74103__$1;
(statearr_74111_74175[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_74111_74175[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74104 === (3))){
var state_74103__$1 = state_74103;
var statearr_74112_74176 = state_74103__$1;
(statearr_74112_74176[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_74112_74176[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74104 === (12))){
var inst_74093 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_74094 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74095 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_74096 = cljs.core.PersistentHashMap.fromArrays(inst_74094,inst_74095);
var inst_74097 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_74096);
var inst_74098 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_74097);
var state_74103__$1 = (function (){var statearr_74113 = state_74103;
(statearr_74113[(10)] = inst_74093);

return statearr_74113;
})();
var statearr_74114_74177 = state_74103__$1;
(statearr_74114_74177[(2)] = inst_74098);

(statearr_74114_74177[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74104 === (2))){
var inst_74075 = (state_74103[(7)]);
var inst_74067 = (state_74103[(9)]);
var inst_74073 = (state_74103[(2)]);
var inst_74074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74073,(0),null);
var inst_74075__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74073,(1),null);
var inst_74076 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74075__$1,inst_74067);
var state_74103__$1 = (function (){var statearr_74115 = state_74103;
(statearr_74115[(7)] = inst_74075__$1);

(statearr_74115[(11)] = inst_74074);

return statearr_74115;
})();
if(inst_74076){
var statearr_74116_74178 = state_74103__$1;
(statearr_74116_74178[(1)] = (3));

} else {
var statearr_74117_74179 = state_74103__$1;
(statearr_74117_74179[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74104 === (11))){
var inst_74086 = (state_74103[(2)]);
var state_74103__$1 = state_74103;
var statearr_74118_74180 = state_74103__$1;
(statearr_74118_74180[(2)] = inst_74086);

(statearr_74118_74180[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74104 === (9))){
var inst_74074 = (state_74103[(11)]);
var state_74103__$1 = state_74103;
var statearr_74119_74181 = state_74103__$1;
(statearr_74119_74181[(2)] = inst_74074);

(statearr_74119_74181[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74104 === (5))){
var inst_74090 = (state_74103[(2)]);
var inst_74091 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_74090);
var state_74103__$1 = state_74103;
if(inst_74091){
var statearr_74120_74182 = state_74103__$1;
(statearr_74120_74182[(1)] = (12));

} else {
var statearr_74121_74183 = state_74103__$1;
(statearr_74121_74183[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74104 === (14))){
var inst_74101 = (state_74103[(2)]);
var state_74103__$1 = state_74103;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74103__$1,inst_74101);
} else {
if((state_val_74104 === (10))){
var state_74103__$1 = state_74103;
var statearr_74122_74184 = state_74103__$1;
(statearr_74122_74184[(2)] = null);

(statearr_74122_74184[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74104 === (8))){
var inst_74088 = (state_74103[(2)]);
var state_74103__$1 = state_74103;
var statearr_74123_74185 = state_74103__$1;
(statearr_74123_74185[(2)] = inst_74088);

(statearr_74123_74185[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0 = (function (){
var statearr_74124 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74124[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__);

(statearr_74124[(1)] = (1));

return statearr_74124;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1 = (function (state_74103){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74103);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74125){var ex__16398__auto__ = e74125;
var statearr_74126_74186 = state_74103;
(statearr_74126_74186[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74103[(4)]))){
var statearr_74127_74187 = state_74103;
(statearr_74127_74187[(1)] = cljs.core.first((state_74103[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74188 = state_74103;
state_74103 = G__74188;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__ = function(state_74103){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1.call(this,state_74103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74128 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74128[(6)] = c__16469__auto__);

return statearr_74128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74232){
var state_val_74233 = (state_74232[(1)]);
if((state_val_74233 === (7))){
var state_74232__$1 = state_74232;
var statearr_74234_74260 = state_74232__$1;
(statearr_74234_74260[(2)] = null);

(statearr_74234_74260[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74233 === (1))){
var state_74232__$1 = state_74232;
var statearr_74235_74261 = state_74232__$1;
(statearr_74235_74261[(2)] = null);

(statearr_74235_74261[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74233 === (4))){
var inst_74189 = (state_74232[(2)]);
var state_74232__$1 = state_74232;
var statearr_74236_74262 = state_74232__$1;
(statearr_74236_74262[(2)] = inst_74189);

(statearr_74236_74262[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74233 === (6))){
var inst_74211 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_74232__$1 = state_74232;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74232__$1,(9),inst_74211);
} else {
if((state_val_74233 === (3))){
var inst_74230 = (state_74232[(2)]);
var state_74232__$1 = state_74232;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74232__$1,inst_74230);
} else {
if((state_val_74233 === (12))){
var inst_74224 = (state_74232[(2)]);
var state_74232__$1 = state_74232;
var statearr_74237_74263 = state_74232__$1;
(statearr_74237_74263[(2)] = inst_74224);

(statearr_74237_74263[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74233 === (2))){
var inst_74200 = (state_74232[(7)]);
var inst_74195 = (state_74232[(8)]);
var inst_74205 = (state_74232[(9)]);
var _ = (function (){var statearr_74238 = state_74232;
(statearr_74238[(4)] = cljs.core.cons((5),(state_74232[(4)])));

return statearr_74238;
})();
var inst_74195__$1 = fluree.db.util.core.random_uuid();
var inst_74196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74197 = [conn_id,cljs.core.cst$kw$ws];
var inst_74198 = (new cljs.core.PersistentVector(null,2,(5),inst_74196,inst_74197,null));
var inst_74199 = (function (){var lock_id = inst_74195__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_74200__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_74198,inst_74199);
var inst_74201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74202 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_74203 = (new cljs.core.PersistentVector(null,3,(5),inst_74201,inst_74202,null));
var inst_74204 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74200__$1,inst_74203);
var inst_74205__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74195__$1,inst_74204);
var inst_74206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74207 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_74208 = (new cljs.core.PersistentVector(null,3,(5),inst_74206,inst_74207,null));
var inst_74209 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74200__$1,inst_74208);
var state_74232__$1 = (function (){var statearr_74239 = state_74232;
(statearr_74239[(7)] = inst_74200__$1);

(statearr_74239[(8)] = inst_74195__$1);

(statearr_74239[(9)] = inst_74205__$1);

(statearr_74239[(10)] = inst_74209);

return statearr_74239;
})();
if(inst_74205__$1){
var statearr_74240_74264 = state_74232__$1;
(statearr_74240_74264[(1)] = (6));

} else {
var statearr_74241_74265 = state_74232__$1;
(statearr_74241_74265[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74233 === (11))){
var inst_74216 = (state_74232[(11)]);
var inst_74215 = (state_74232[(12)]);
var inst_74209 = (state_74232[(10)]);
var inst_74222 = fluree.db.util.xhttp.try_socket(inst_74215,sub_chan,pub_chan,inst_74209,(60000),inst_74216);
var state_74232__$1 = state_74232;
var statearr_74243_74266 = state_74232__$1;
(statearr_74243_74266[(2)] = inst_74222);

(statearr_74243_74266[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74233 === (9))){
var inst_74200 = (state_74232[(7)]);
var inst_74195 = (state_74232[(8)]);
var inst_74213 = (state_74232[(13)]);
var inst_74215 = (state_74232[(12)]);
var inst_74205 = (state_74232[(9)]);
var inst_74209 = (state_74232[(10)]);
var inst_74213__$1 = (state_74232[(2)]);
var inst_74214 = clojure.string.replace(inst_74213__$1,"http","ws");
var inst_74215__$1 = [inst_74214,"/fdb/ws"].join('');
var inst_74216 = (function (){var lock_id = inst_74195;
var state = inst_74200;
var have_lock_QMARK_ = inst_74205;
var resp_chan = inst_74209;
var healthy_server = inst_74213__$1;
var ws_url = inst_74215__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_74217 = fluree.db.util.core.exception_QMARK_(inst_74213__$1);
var state_74232__$1 = (function (){var statearr_74244 = state_74232;
(statearr_74244[(11)] = inst_74216);

(statearr_74244[(13)] = inst_74213__$1);

(statearr_74244[(12)] = inst_74215__$1);

return statearr_74244;
})();
if(inst_74217){
var statearr_74245_74267 = state_74232__$1;
(statearr_74245_74267[(1)] = (10));

} else {
var statearr_74246_74268 = state_74232__$1;
(statearr_74246_74268[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74233 === (5))){
var _ = (function (){var statearr_74247 = state_74232;
(statearr_74247[(4)] = cljs.core.rest((state_74232[(4)])));

return statearr_74247;
})();
var state_74232__$1 = state_74232;
var ex74242 = (state_74232__$1[(2)]);
var statearr_74248_74269 = state_74232__$1;
(statearr_74248_74269[(5)] = ex74242);


if((ex74242 instanceof Error)){
var statearr_74249_74270 = state_74232__$1;
(statearr_74249_74270[(1)] = (4));

(statearr_74249_74270[(5)] = null);

} else {
throw ex74242;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74233 === (10))){
var inst_74213 = (state_74232[(13)]);
var inst_74209 = (state_74232[(10)]);
var inst_74219 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_74220 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74209,inst_74213);
var state_74232__$1 = (function (){var statearr_74250 = state_74232;
(statearr_74250[(14)] = inst_74219);

return statearr_74250;
})();
var statearr_74251_74271 = state_74232__$1;
(statearr_74251_74271[(2)] = inst_74220);

(statearr_74251_74271[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74233 === (8))){
var inst_74209 = (state_74232[(10)]);
var inst_74227 = (state_74232[(2)]);
var _ = (function (){var statearr_74252 = state_74232;
(statearr_74252[(4)] = cljs.core.rest((state_74232[(4)])));

return statearr_74252;
})();
var state_74232__$1 = (function (){var statearr_74253 = state_74232;
(statearr_74253[(15)] = inst_74227);

return statearr_74253;
})();
var statearr_74254_74272 = state_74232__$1;
(statearr_74254_74272[(2)] = inst_74209);

(statearr_74254_74272[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__16395__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__16395__auto____0 = (function (){
var statearr_74255 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74255[(0)] = fluree$db$connection$establish_socket_$_state_machine__16395__auto__);

(statearr_74255[(1)] = (1));

return statearr_74255;
});
var fluree$db$connection$establish_socket_$_state_machine__16395__auto____1 = (function (state_74232){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74232);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74256){var ex__16398__auto__ = e74256;
var statearr_74257_74273 = state_74232;
(statearr_74257_74273[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74232[(4)]))){
var statearr_74258_74274 = state_74232;
(statearr_74258_74274[(1)] = cljs.core.first((state_74232[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74275 = state_74232;
state_74232 = G__74275;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__16395__auto__ = function(state_74232){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__16395__auto____1.call(this,state_74232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__16395__auto____0;
fluree$db$connection$establish_socket_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__16395__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74259 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74259[(6)] = c__16469__auto__);

return statearr_74259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k74277,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__74281 = k74277;
var G__74281__$1 = (((G__74281 instanceof cljs.core.Keyword))?G__74281.fqn:null);
switch (G__74281__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k74277,else__4464__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__74282){
var vec__74283 = p__74282;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74283,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74283,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__74276){
var self__ = this;
var G__74276__$1 = this;
return (new cljs.core.RecordIter((0),G__74276__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__74286 = (function (coll__4458__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__74286(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this74278,other74279){
var self__ = this;
var this74278__$1 = this;
return (((!((other74279 == null)))) && ((((this74278__$1.constructor === other74279.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.id,other74279.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.servers,other74279.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.state,other74279.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.req_chan,other74279.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.sub_chan,other74279.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.pub_chan,other74279.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.storage_read,other74279.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.storage_write,other74279.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.object_cache,other74279.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.parallelism,other74279.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.serializer,other74279.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.default_network,other74279.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.transactor_QMARK_,other74279.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.publish,other74279.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.transact_handler,other74279.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.tx_private_key,other74279.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.tx_key_id,other74279.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.meta,other74279.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.add_listener,other74279.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.remove_listener,other74279.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.close,other74279.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74278__$1.__extmap,other74279.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k74277){
var self__ = this;
var this__4468__auto____$1 = this;
var G__74287 = k74277;
var G__74287__$1 = (((G__74287 instanceof cljs.core.Keyword))?G__74287.fqn:null);
switch (G__74287__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k74277);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__74276){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__74288 = cljs.core.keyword_identical_QMARK_;
var expr__74289 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__74291 = cljs.core.cst$kw$id;
var G__74292 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74291,G__74292) : pred__74288.call(null,G__74291,G__74292));
})())){
return (new fluree.db.connection.Connection(G__74276,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74293 = cljs.core.cst$kw$servers;
var G__74294 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74293,G__74294) : pred__74288.call(null,G__74293,G__74294));
})())){
return (new fluree.db.connection.Connection(self__.id,G__74276,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74295 = cljs.core.cst$kw$state;
var G__74296 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74295,G__74296) : pred__74288.call(null,G__74295,G__74296));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__74276,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74297 = cljs.core.cst$kw$req_DASH_chan;
var G__74298 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74297,G__74298) : pred__74288.call(null,G__74297,G__74298));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__74276,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74299 = cljs.core.cst$kw$sub_DASH_chan;
var G__74300 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74299,G__74300) : pred__74288.call(null,G__74299,G__74300));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__74276,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74301 = cljs.core.cst$kw$pub_DASH_chan;
var G__74302 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74301,G__74302) : pred__74288.call(null,G__74301,G__74302));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__74276,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74303 = cljs.core.cst$kw$storage_DASH_read;
var G__74304 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74303,G__74304) : pred__74288.call(null,G__74303,G__74304));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__74276,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74305 = cljs.core.cst$kw$storage_DASH_write;
var G__74306 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74305,G__74306) : pred__74288.call(null,G__74305,G__74306));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__74276,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74307 = cljs.core.cst$kw$object_DASH_cache;
var G__74308 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74307,G__74308) : pred__74288.call(null,G__74307,G__74308));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__74276,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74309 = cljs.core.cst$kw$parallelism;
var G__74310 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74309,G__74310) : pred__74288.call(null,G__74309,G__74310));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__74276,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74311 = cljs.core.cst$kw$serializer;
var G__74312 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74311,G__74312) : pred__74288.call(null,G__74311,G__74312));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__74276,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74313 = cljs.core.cst$kw$default_DASH_network;
var G__74314 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74313,G__74314) : pred__74288.call(null,G__74313,G__74314));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__74276,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74315 = cljs.core.cst$kw$transactor_QMARK_;
var G__74316 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74315,G__74316) : pred__74288.call(null,G__74315,G__74316));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__74276,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74317 = cljs.core.cst$kw$publish;
var G__74318 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74317,G__74318) : pred__74288.call(null,G__74317,G__74318));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__74276,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74319 = cljs.core.cst$kw$transact_DASH_handler;
var G__74320 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74319,G__74320) : pred__74288.call(null,G__74319,G__74320));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__74276,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74321 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__74322 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74321,G__74322) : pred__74288.call(null,G__74321,G__74322));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__74276,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74323 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__74324 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74323,G__74324) : pred__74288.call(null,G__74323,G__74324));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__74276,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74325 = cljs.core.cst$kw$meta;
var G__74326 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74325,G__74326) : pred__74288.call(null,G__74325,G__74326));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__74276,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74327 = cljs.core.cst$kw$add_DASH_listener;
var G__74328 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74327,G__74328) : pred__74288.call(null,G__74327,G__74328));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__74276,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74329 = cljs.core.cst$kw$remove_DASH_listener;
var G__74330 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74329,G__74330) : pred__74288.call(null,G__74329,G__74330));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__74276,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74331 = cljs.core.cst$kw$close;
var G__74332 = expr__74289;
return (pred__74288.cljs$core$IFn$_invoke$arity$2 ? pred__74288.cljs$core$IFn$_invoke$arity$2(G__74331,G__74332) : pred__74288.call(null,G__74331,G__74332));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__74276,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__74276),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__74276){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__74276,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__74280){
var extmap__4501__auto__ = (function (){var G__74333 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__74280,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__74280)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__74333);
} else {
return G__74333;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__74280),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__74280),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__74339 = servers_STAR_;
var vec__74340 = G__74339;
var seq__74341 = cljs.core.seq(vec__74340);
var first__74342 = cljs.core.first(seq__74341);
var seq__74341__$1 = cljs.core.next(seq__74341);
var server = first__74342;
var r = seq__74341__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__74339__$1 = G__74339;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__74346 = G__74339__$1;
var seq__74347 = cljs.core.seq(vec__74346);
var first__74348 = cljs.core.first(seq__74347);
var seq__74347__$1 = cljs.core.next(seq__74347);
var server__$1 = first__74348;
var r__$1 = seq__74347__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__4210__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__74349 = r__$1;
var G__74350 = is_https_QMARK_;
var G__74351 = result_STAR_;
G__74339__$1 = G__74349;
https_QMARK___$1 = G__74350;
result__$1 = G__74351;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__74352 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__74352 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__74352);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74381){
var state_val_74382 = (state_74381[(1)]);
if((state_val_74382 === (7))){
var inst_74367 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74368 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74369 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74370 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74371 = fluree.db.connection.establish_socket(inst_74367,inst_74368,inst_74369,inst_74370);
var state_74381__$1 = state_74381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74381__$1,(9),inst_74371);
} else {
if((state_val_74382 === (1))){
var state_74381__$1 = state_74381;
var statearr_74383_74402 = state_74381__$1;
(statearr_74383_74402[(2)] = null);

(statearr_74383_74402[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74382 === (4))){
var inst_74353 = (state_74381[(2)]);
var state_74381__$1 = state_74381;
var statearr_74384_74403 = state_74381__$1;
(statearr_74384_74403[(2)] = inst_74353);

(statearr_74384_74403[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74382 === (6))){
var inst_74364 = (state_74381[(7)]);
var state_74381__$1 = state_74381;
var statearr_74385_74404 = state_74381__$1;
(statearr_74385_74404[(2)] = inst_74364);

(statearr_74385_74404[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74382 === (3))){
var inst_74379 = (state_74381[(2)]);
var state_74381__$1 = state_74381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74381__$1,inst_74379);
} else {
if((state_val_74382 === (2))){
var inst_74364 = (state_74381[(7)]);
var _ = (function (){var statearr_74387 = state_74381;
(statearr_74387[(4)] = cljs.core.cons((5),(state_74381[(4)])));

return statearr_74387;
})();
var inst_74359 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_74360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74361 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74362 = [inst_74361,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_74363 = (new cljs.core.PersistentVector(null,3,(5),inst_74360,inst_74362,null));
var inst_74364__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74359,inst_74363);
var state_74381__$1 = (function (){var statearr_74388 = state_74381;
(statearr_74388[(7)] = inst_74364__$1);

return statearr_74388;
})();
if(cljs.core.truth_(inst_74364__$1)){
var statearr_74389_74405 = state_74381__$1;
(statearr_74389_74405[(1)] = (6));

} else {
var statearr_74390_74406 = state_74381__$1;
(statearr_74390_74406[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74382 === (9))){
var inst_74373 = (state_74381[(2)]);
var inst_74374 = fluree.db.util.async.throw_err(inst_74373);
var state_74381__$1 = state_74381;
var statearr_74391_74407 = state_74381__$1;
(statearr_74391_74407[(2)] = inst_74374);

(statearr_74391_74407[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74382 === (5))){
var _ = (function (){var statearr_74392 = state_74381;
(statearr_74392[(4)] = cljs.core.rest((state_74381[(4)])));

return statearr_74392;
})();
var state_74381__$1 = state_74381;
var ex74386 = (state_74381__$1[(2)]);
var statearr_74393_74408 = state_74381__$1;
(statearr_74393_74408[(5)] = ex74386);


if((ex74386 instanceof Error)){
var statearr_74394_74409 = state_74381__$1;
(statearr_74394_74409[(1)] = (4));

(statearr_74394_74409[(5)] = null);

} else {
throw ex74386;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74382 === (8))){
var inst_74376 = (state_74381[(2)]);
var _ = (function (){var statearr_74395 = state_74381;
(statearr_74395[(4)] = cljs.core.rest((state_74381[(4)])));

return statearr_74395;
})();
var state_74381__$1 = state_74381;
var statearr_74396_74410 = state_74381__$1;
(statearr_74396_74410[(2)] = inst_74376);

(statearr_74396_74410[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__16395__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__16395__auto____0 = (function (){
var statearr_74397 = [null,null,null,null,null,null,null,null];
(statearr_74397[(0)] = fluree$db$connection$get_socket_$_state_machine__16395__auto__);

(statearr_74397[(1)] = (1));

return statearr_74397;
});
var fluree$db$connection$get_socket_$_state_machine__16395__auto____1 = (function (state_74381){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74381);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74398){var ex__16398__auto__ = e74398;
var statearr_74399_74411 = state_74381;
(statearr_74399_74411[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74381[(4)]))){
var statearr_74400_74412 = state_74381;
(statearr_74400_74412[(1)] = cljs.core.first((state_74381[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74413 = state_74381;
state_74381 = G__74413;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__16395__auto__ = function(state_74381){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__16395__auto____1.call(this,state_74381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__16395__auto____0;
fluree$db$connection$get_socket_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__16395__auto____1;
return fluree$db$connection$get_socket_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74401 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74401[(6)] = c__16469__auto__);

return statearr_74401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e74414){var e = e74414;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4212__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74541){
var state_val_74542 = (state_74541[(1)]);
if((state_val_74542 === (7))){
var inst_74537 = (state_74541[(2)]);
var state_74541__$1 = state_74541;
var statearr_74544_74614 = state_74541__$1;
(statearr_74544_74614[(2)] = inst_74537);

(statearr_74544_74614[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (20))){
var _ = (function (){var statearr_74545 = state_74541;
(statearr_74545[(4)] = cljs.core.rest((state_74541[(4)])));

return statearr_74545;
})();
var state_74541__$1 = state_74541;
var ex74543 = (state_74541__$1[(2)]);
var statearr_74546_74615 = state_74541__$1;
(statearr_74546_74615[(5)] = ex74543);


var statearr_74547_74616 = state_74541__$1;
(statearr_74547_74616[(1)] = (10));

(statearr_74547_74616[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (27))){
var inst_74529 = (state_74541[(2)]);
var _ = (function (){var statearr_74548 = state_74541;
(statearr_74548[(4)] = cljs.core.rest((state_74541[(4)])));

return statearr_74548;
})();
var state_74541__$1 = state_74541;
var statearr_74549_74617 = state_74541__$1;
(statearr_74549_74617[(2)] = inst_74529);

(statearr_74549_74617[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (1))){
var inst_74416 = (0);
var state_74541__$1 = (function (){var statearr_74550 = state_74541;
(statearr_74550[(7)] = inst_74416);

return statearr_74550;
})();
var statearr_74551_74618 = state_74541__$1;
(statearr_74551_74618[(2)] = null);

(statearr_74551_74618[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (24))){
var inst_74507 = (state_74541[(8)]);
var inst_74507__$1 = (state_74541[(2)]);
var inst_74508 = inst_74507__$1 === true;
var state_74541__$1 = (function (){var statearr_74552 = state_74541;
(statearr_74552[(8)] = inst_74507__$1);

return statearr_74552;
})();
if(cljs.core.truth_(inst_74508)){
var statearr_74553_74619 = state_74541__$1;
(statearr_74553_74619[(1)] = (25));

} else {
var statearr_74554_74620 = state_74541__$1;
(statearr_74554_74620[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (4))){
var inst_74419 = (state_74541[(9)]);
var inst_74419__$1 = (state_74541[(2)]);
var state_74541__$1 = (function (){var statearr_74555 = state_74541;
(statearr_74555[(9)] = inst_74419__$1);

return statearr_74555;
})();
if(cljs.core.truth_(inst_74419__$1)){
var statearr_74556_74621 = state_74541__$1;
(statearr_74556_74621[(1)] = (5));

} else {
var statearr_74557_74622 = state_74541__$1;
(statearr_74557_74622[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (15))){
var inst_74432 = (state_74541[(10)]);
var state_74541__$1 = state_74541;
var statearr_74558_74623 = state_74541__$1;
(statearr_74558_74623[(2)] = inst_74432);

(statearr_74558_74623[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (21))){
var inst_74458 = (state_74541[(11)]);
var inst_74460 = (state_74541[(12)]);
var inst_74419 = (state_74541[(9)]);
var inst_74457 = (state_74541[(13)]);
var inst_74455 = (state_74541[(14)]);
var inst_74464 = (state_74541[(15)]);
var inst_74463 = (state_74541[(16)]);
var inst_74459 = (state_74541[(17)]);
var inst_74416 = (state_74541[(7)]);
var inst_74456 = (state_74541[(18)]);
var inst_74466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74467 = [cljs.core.cst$kw$pending_DASH_req,inst_74463];
var inst_74468 = (new cljs.core.PersistentVector(null,2,(5),inst_74466,inst_74467,null));
var inst_74469 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_74468,inst_74458);
var inst_74496 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_74497 = (function (){var resp_chan = inst_74458;
var timeout = inst_74464;
var i = inst_74416;
var data = inst_74457;
var c__16469__auto____$1 = inst_74496;
var _ = inst_74455;
var req_id = inst_74463;
var operation = inst_74456;
var msg = inst_74419;
var vec__74451 = inst_74419;
var map__74454 = inst_74460;
var opts = inst_74459;
return (function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74494){
var state_val_74495 = (state_74494[(1)]);
if((state_val_74495 === (1))){
var inst_74473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74474 = cljs.core.async.timeout(timeout);
var inst_74475 = [resp_chan,inst_74474];
var inst_74476 = (new cljs.core.PersistentVector(null,2,(5),inst_74473,inst_74475,null));
var state_74494__$1 = state_74494;
return cljs.core.async.ioc_alts_BANG_(state_74494__$1,(2),inst_74476);
} else {
if((state_val_74495 === (2))){
var inst_74479 = (state_74494[(7)]);
var inst_74478 = (state_74494[(2)]);
var inst_74479__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74478,(0),null);
var inst_74480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74478,(1),null);
var inst_74481 = (function (){var vec__74470 = inst_74478;
var resp = inst_74479__$1;
var c = inst_74480;
return (function (p1__74415_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__74415_SHARP_,req_id);
});
})();
var inst_74482 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_74481);
var inst_74483 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74480,resp_chan);
var state_74494__$1 = (function (){var statearr_74559 = state_74494;
(statearr_74559[(7)] = inst_74479__$1);

(statearr_74559[(8)] = inst_74482);

return statearr_74559;
})();
if(inst_74483){
var statearr_74560_74624 = state_74494__$1;
(statearr_74560_74624[(1)] = (3));

} else {
var statearr_74561_74625 = state_74494__$1;
(statearr_74561_74625[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74495 === (3))){
var inst_74479 = (state_74494[(7)]);
var state_74494__$1 = state_74494;
var statearr_74562_74626 = state_74494__$1;
(statearr_74562_74626[(2)] = inst_74479);

(statearr_74562_74626[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74495 === (4))){
var inst_74486 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_74487 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74488 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_74489 = cljs.core.PersistentHashMap.fromArrays(inst_74487,inst_74488);
var inst_74490 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74486,inst_74489);
var state_74494__$1 = state_74494;
var statearr_74563_74627 = state_74494__$1;
(statearr_74563_74627[(2)] = inst_74490);

(statearr_74563_74627[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74495 === (5))){
var inst_74492 = (state_74494[(2)]);
var state_74494__$1 = state_74494;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74494__$1,inst_74492);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__16395__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__16395__auto____0 = (function (){
var statearr_74564 = [null,null,null,null,null,null,null,null,null];
(statearr_74564[(0)] = fluree$db$connection$msg_producer_$_state_machine__16395__auto__);

(statearr_74564[(1)] = (1));

return statearr_74564;
});
var fluree$db$connection$msg_producer_$_state_machine__16395__auto____1 = (function (state_74494){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74494);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74565){var ex__16398__auto__ = e74565;
var statearr_74566_74628 = state_74494;
(statearr_74566_74628[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74494[(4)]))){
var statearr_74567_74629 = state_74494;
(statearr_74567_74629[(1)] = cljs.core.first((state_74494[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74630 = state_74494;
state_74494 = G__74630;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__16395__auto__ = function(state_74494){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__16395__auto____1.call(this,state_74494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__16395__auto____0;
fluree$db$connection$msg_producer_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__16395__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74568 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74568[(6)] = c__16469__auto____$1);

return statearr_74568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
});
})();
var inst_74498 = cljs.core.async.impl.dispatch.run(inst_74497);
var state_74541__$1 = (function (){var statearr_74569 = state_74541;
(statearr_74569[(19)] = inst_74498);

(statearr_74569[(20)] = inst_74469);

return statearr_74569;
})();
var statearr_74570_74631 = state_74541__$1;
(statearr_74570_74631[(2)] = inst_74496);

(statearr_74570_74631[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (31))){
var inst_74517 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_74541__$1 = state_74541;
var statearr_74571_74632 = state_74541__$1;
(statearr_74571_74632[(2)] = inst_74517);

(statearr_74571_74632[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (32))){
var state_74541__$1 = state_74541;
var statearr_74572_74633 = state_74541__$1;
(statearr_74572_74633[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (33))){
var inst_74525 = (state_74541[(2)]);
var state_74541__$1 = state_74541;
var statearr_74574_74634 = state_74541__$1;
(statearr_74574_74634[(2)] = inst_74525);

(statearr_74574_74634[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (13))){
var inst_74432 = (state_74541[(10)]);
var inst_74429 = (state_74541[(2)]);
var inst_74430 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74429,(0),null);
var inst_74431 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74429,(1),null);
var inst_74432__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74429,(2),null);
var state_74541__$1 = (function (){var statearr_74575 = state_74541;
(statearr_74575[(21)] = inst_74431);

(statearr_74575[(10)] = inst_74432__$1);

(statearr_74575[(22)] = inst_74430);

return statearr_74575;
})();
if(cljs.core.truth_(inst_74432__$1)){
var statearr_74576_74635 = state_74541__$1;
(statearr_74576_74635[(1)] = (14));

} else {
var statearr_74577_74636 = state_74541__$1;
(statearr_74577_74636[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (22))){
var state_74541__$1 = state_74541;
var statearr_74578_74637 = state_74541__$1;
(statearr_74578_74637[(2)] = null);

(statearr_74578_74637[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (36))){
var inst_74523 = (state_74541[(2)]);
var state_74541__$1 = state_74541;
var statearr_74579_74638 = state_74541__$1;
(statearr_74579_74638[(2)] = inst_74523);

(statearr_74579_74638[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (29))){
var inst_74507 = (state_74541[(8)]);
var inst_74515 = (inst_74507 == null);
var state_74541__$1 = state_74541;
if(cljs.core.truth_(inst_74515)){
var statearr_74580_74639 = state_74541__$1;
(statearr_74580_74639[(1)] = (31));

} else {
var statearr_74581_74640 = state_74541__$1;
(statearr_74581_74640[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (6))){
var state_74541__$1 = state_74541;
var statearr_74582_74641 = state_74541__$1;
(statearr_74582_74641[(2)] = null);

(statearr_74582_74641[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (28))){
var inst_74507 = (state_74541[(8)]);
var inst_74513 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74507,"Error processing message in producer."], 0));
var state_74541__$1 = state_74541;
var statearr_74583_74642 = state_74541__$1;
(statearr_74583_74642[(2)] = inst_74513);

(statearr_74583_74642[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (25))){
var state_74541__$1 = state_74541;
var statearr_74584_74643 = state_74541__$1;
(statearr_74584_74643[(2)] = null);

(statearr_74584_74643[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (34))){
var inst_74507 = (state_74541[(8)]);
var inst_74520 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_74507], 0));
var state_74541__$1 = state_74541;
var statearr_74585_74644 = state_74541__$1;
(statearr_74585_74644[(2)] = inst_74520);

(statearr_74585_74644[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (17))){
var inst_74421 = (state_74541[(23)]);
var inst_74432 = (state_74541[(10)]);
var inst_74439 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74432,inst_74421);
var state_74541__$1 = state_74541;
var statearr_74586_74645 = state_74541__$1;
(statearr_74586_74645[(2)] = inst_74439);

(statearr_74586_74645[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (3))){
var inst_74539 = (state_74541[(2)]);
var state_74541__$1 = state_74541;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74541__$1,inst_74539);
} else {
if((state_val_74542 === (12))){
var state_74541__$1 = state_74541;
var statearr_74587_74646 = state_74541__$1;
(statearr_74587_74646[(2)] = null);

(statearr_74587_74646[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (2))){
var state_74541__$1 = state_74541;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74541__$1,(4),req_chan);
} else {
if((state_val_74542 === (23))){
var inst_74457 = (state_74541[(13)]);
var inst_74463 = (state_74541[(16)]);
var inst_74456 = (state_74541[(18)]);
var inst_74501 = (state_74541[(2)]);
var inst_74502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74503 = [inst_74456,inst_74463,inst_74457];
var inst_74504 = (new cljs.core.PersistentVector(null,3,(5),inst_74502,inst_74503,null));
var inst_74505 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_74504) : publish_fn.call(null,conn,inst_74504));
var state_74541__$1 = (function (){var statearr_74588 = state_74541;
(statearr_74588[(24)] = inst_74501);

return statearr_74588;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74541__$1,(24),inst_74505);
} else {
if((state_val_74542 === (35))){
var state_74541__$1 = state_74541;
var statearr_74589_74647 = state_74541__$1;
(statearr_74589_74647[(2)] = null);

(statearr_74589_74647[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (19))){
var inst_74445 = (state_74541[(2)]);
var state_74541__$1 = state_74541;
var statearr_74590_74648 = state_74541__$1;
(statearr_74590_74648[(2)] = inst_74445);

(statearr_74590_74648[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (11))){
var inst_74419 = (state_74541[(9)]);
var state_74541__$1 = state_74541;
var statearr_74591_74649 = state_74541__$1;
(statearr_74591_74649[(2)] = inst_74419);

(statearr_74591_74649[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (9))){
var inst_74416 = (state_74541[(7)]);
var inst_74532 = (state_74541[(2)]);
var inst_74533 = (inst_74416 + (1));
var inst_74416__$1 = inst_74533;
var state_74541__$1 = (function (){var statearr_74592 = state_74541;
(statearr_74592[(25)] = inst_74532);

(statearr_74592[(7)] = inst_74416__$1);

return statearr_74592;
})();
var statearr_74593_74650 = state_74541__$1;
(statearr_74593_74650[(2)] = null);

(statearr_74593_74650[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (5))){
var state_74541__$1 = state_74541;
var statearr_74594_74651 = state_74541__$1;
(statearr_74594_74651[(2)] = null);

(statearr_74594_74651[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (14))){
var inst_74432 = (state_74541[(10)]);
var inst_74434 = fluree.db.util.async.channel_QMARK_(inst_74432);
var state_74541__$1 = state_74541;
var statearr_74595_74652 = state_74541__$1;
(statearr_74595_74652[(2)] = inst_74434);

(statearr_74595_74652[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (26))){
var inst_74507 = (state_74541[(8)]);
var inst_74511 = fluree.db.util.core.exception_QMARK_(inst_74507);
var state_74541__$1 = state_74541;
if(inst_74511){
var statearr_74596_74653 = state_74541__$1;
(statearr_74596_74653[(1)] = (28));

} else {
var statearr_74597_74654 = state_74541__$1;
(statearr_74597_74654[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (16))){
var inst_74437 = (state_74541[(2)]);
var state_74541__$1 = state_74541;
if(cljs.core.truth_(inst_74437)){
var statearr_74598_74655 = state_74541__$1;
(statearr_74598_74655[(1)] = (17));

} else {
var statearr_74599_74656 = state_74541__$1;
(statearr_74599_74656[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (30))){
var inst_74527 = (state_74541[(2)]);
var state_74541__$1 = state_74541;
var statearr_74600_74657 = state_74541__$1;
(statearr_74600_74657[(2)] = inst_74527);

(statearr_74600_74657[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (10))){
var inst_74419 = (state_74541[(9)]);
var inst_74421 = (state_74541[(2)]);
var inst_74425 = cljs.core.sequential_QMARK_(inst_74419);
var state_74541__$1 = (function (){var statearr_74601 = state_74541;
(statearr_74601[(23)] = inst_74421);

return statearr_74601;
})();
if(inst_74425){
var statearr_74602_74658 = state_74541__$1;
(statearr_74602_74658[(1)] = (11));

} else {
var statearr_74603_74659 = state_74541__$1;
(statearr_74603_74659[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (18))){
var inst_74419 = (state_74541[(9)]);
var inst_74421 = (state_74541[(23)]);
var inst_74441 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74419], 0));
var inst_74442 = ["Error processing ledger request, no valid return channel: ",inst_74441].join('');
var inst_74443 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74421,inst_74442], 0));
var state_74541__$1 = state_74541;
var statearr_74604_74660 = state_74541__$1;
(statearr_74604_74660[(2)] = inst_74443);

(statearr_74604_74660[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74542 === (8))){
var inst_74458 = (state_74541[(11)]);
var inst_74460 = (state_74541[(12)]);
var inst_74419 = (state_74541[(9)]);
var inst_74459 = (state_74541[(17)]);
var _ = (function (){var statearr_74605 = state_74541;
(statearr_74605[(4)] = cljs.core.cons((20),(state_74541[(4)])));

return statearr_74605;
})();
var inst_74455 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_74419], 0));
var inst_74456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74419,(0),null);
var inst_74457 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74419,(1),null);
var inst_74458__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74419,(2),null);
var inst_74459__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74419,(3),null);
var inst_74460__$1 = cljs.core.__destructure_map(inst_74459__$1);
var inst_74461 = fluree.db.util.core.random_uuid();
var inst_74462 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74461);
var inst_74463 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_74460__$1,cljs.core.cst$kw$req_DASH_id,inst_74462);
var inst_74464 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_74460__$1,cljs.core.cst$kw$timeout,(60000));
var state_74541__$1 = (function (){var statearr_74606 = state_74541;
(statearr_74606[(11)] = inst_74458__$1);

(statearr_74606[(12)] = inst_74460__$1);

(statearr_74606[(13)] = inst_74457);

(statearr_74606[(14)] = inst_74455);

(statearr_74606[(15)] = inst_74464);

(statearr_74606[(16)] = inst_74463);

(statearr_74606[(17)] = inst_74459__$1);

(statearr_74606[(18)] = inst_74456);

return statearr_74606;
})();
if(cljs.core.truth_(inst_74458__$1)){
var statearr_74607_74661 = state_74541__$1;
(statearr_74607_74661[(1)] = (21));

} else {
var statearr_74608_74662 = state_74541__$1;
(statearr_74608_74662[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__16395__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__16395__auto____0 = (function (){
var statearr_74609 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74609[(0)] = fluree$db$connection$msg_producer_$_state_machine__16395__auto__);

(statearr_74609[(1)] = (1));

return statearr_74609;
});
var fluree$db$connection$msg_producer_$_state_machine__16395__auto____1 = (function (state_74541){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74541);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74610){var ex__16398__auto__ = e74610;
var statearr_74611_74663 = state_74541;
(statearr_74611_74663[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74541[(4)]))){
var statearr_74612_74664 = state_74541;
(statearr_74612_74664[(1)] = cljs.core.first((state_74541[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74665 = state_74541;
state_74541 = G__74665;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__16395__auto__ = function(state_74541){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__16395__auto____1.call(this,state_74541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__16395__auto____0;
fluree$db$connection$msg_producer_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__16395__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74613 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74613[(6)] = c__16469__auto__);

return statearr_74613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__74666 = conn;
var map__74666__$1 = cljs.core.__destructure_map(map__74666);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74666__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74751){
var state_val_74752 = (state_74751[(1)]);
if((state_val_74752 === (7))){
var inst_74747 = (state_74751[(2)]);
var state_74751__$1 = state_74751;
var statearr_74753_74804 = state_74751__$1;
(statearr_74753_74804[(2)] = inst_74747);

(statearr_74753_74804[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (20))){
var inst_74685 = (state_74751[(7)]);
var inst_74699 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_74700 = [inst_74685];
var inst_74701 = cljs.core.PersistentHashMap.fromArrays(inst_74699,inst_74700);
var inst_74702 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_74701], 0));
var state_74751__$1 = state_74751;
var statearr_74754_74805 = state_74751__$1;
(statearr_74754_74805[(2)] = inst_74702);

(statearr_74754_74805[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (27))){
var state_74751__$1 = state_74751;
var statearr_74755_74806 = state_74751__$1;
(statearr_74755_74806[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (1))){
var inst_74667 = (0);
var state_74751__$1 = (function (){var statearr_74757 = state_74751;
(statearr_74757[(8)] = inst_74667);

return statearr_74757;
})();
var statearr_74758_74807 = state_74751__$1;
(statearr_74758_74807[(2)] = null);

(statearr_74758_74807[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (24))){
var inst_74678 = (state_74751[(9)]);
var inst_74727 = fluree.db.util.core.exception_QMARK_(inst_74678);
var state_74751__$1 = state_74751;
if(inst_74727){
var statearr_74759_74808 = state_74751__$1;
(statearr_74759_74808[(1)] = (26));

} else {
var statearr_74760_74809 = state_74751__$1;
(statearr_74760_74809[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (4))){
var inst_74672 = (state_74751[(10)]);
var inst_74677 = (state_74751[(2)]);
var inst_74678 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74677,(0),null);
var inst_74679 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74677,(1),null);
var inst_74680 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74679,inst_74672);
var state_74751__$1 = (function (){var statearr_74761 = state_74751;
(statearr_74761[(9)] = inst_74678);

return statearr_74761;
})();
if(inst_74680){
var statearr_74762_74810 = state_74751__$1;
(statearr_74762_74810[(1)] = (5));

} else {
var statearr_74763_74811 = state_74751__$1;
(statearr_74763_74811[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (15))){
var inst_74685 = (state_74751[(7)]);
var inst_74694 = typeof inst_74685 === 'string';
var state_74751__$1 = state_74751;
if(cljs.core.truth_(inst_74694)){
var statearr_74764_74812 = state_74751__$1;
(statearr_74764_74812[(1)] = (17));

} else {
var statearr_74765_74813 = state_74751__$1;
(statearr_74765_74813[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (21))){
var state_74751__$1 = state_74751;
var statearr_74766_74814 = state_74751__$1;
(statearr_74766_74814[(2)] = null);

(statearr_74766_74814[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (31))){
var inst_74741 = (state_74751[(2)]);
var state_74751__$1 = state_74751;
var statearr_74767_74815 = state_74751__$1;
(statearr_74767_74815[(2)] = inst_74741);

(statearr_74767_74815[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (13))){
var inst_74711 = (state_74751[(2)]);
var inst_74712 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74713 = fluree.db.connection.close_websocket(inst_74712);
var inst_74714 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74715 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_74714);
var state_74751__$1 = (function (){var statearr_74768 = state_74751;
(statearr_74768[(11)] = inst_74713);

(statearr_74768[(12)] = inst_74711);

return statearr_74768;
})();
var statearr_74769_74816 = state_74751__$1;
(statearr_74769_74816[(2)] = inst_74715);

(statearr_74769_74816[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (22))){
var inst_74705 = (state_74751[(2)]);
var state_74751__$1 = state_74751;
var statearr_74770_74817 = state_74751__$1;
(statearr_74770_74817[(2)] = inst_74705);

(statearr_74770_74817[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (29))){
var inst_74678 = (state_74751[(9)]);
var inst_74733 = fluree.db.util.json.parse(inst_74678);
var inst_74734 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74733], 0));
var inst_74735 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_74734], 0));
var inst_74736 = fluree.db.util.json.parse(inst_74678);
var inst_74737 = fluree.db.conn_events.process_events(conn,inst_74736);
var inst_74667 = (0);
var state_74751__$1 = (function (){var statearr_74771 = state_74751;
(statearr_74771[(13)] = inst_74735);

(statearr_74771[(14)] = inst_74737);

(statearr_74771[(8)] = inst_74667);

return statearr_74771;
})();
var statearr_74772_74818 = state_74751__$1;
(statearr_74772_74818[(2)] = null);

(statearr_74772_74818[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (6))){
var inst_74678 = (state_74751[(9)]);
var inst_74723 = (inst_74678 == null);
var state_74751__$1 = state_74751;
if(cljs.core.truth_(inst_74723)){
var statearr_74773_74819 = state_74751__$1;
(statearr_74773_74819[(1)] = (23));

} else {
var statearr_74774_74820 = state_74751__$1;
(statearr_74774_74820[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (28))){
var inst_74743 = (state_74751[(2)]);
var state_74751__$1 = state_74751;
var statearr_74775_74821 = state_74751__$1;
(statearr_74775_74821[(2)] = inst_74743);

(statearr_74775_74821[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (25))){
var inst_74745 = (state_74751[(2)]);
var state_74751__$1 = state_74751;
var statearr_74776_74822 = state_74751__$1;
(statearr_74776_74822[(2)] = inst_74745);

(statearr_74776_74822[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (17))){
var inst_74685 = (state_74751[(7)]);
var inst_74696 = cljs.core.eval(inst_74685);
var state_74751__$1 = state_74751;
var statearr_74777_74823 = state_74751__$1;
(statearr_74777_74823[(2)] = inst_74696);

(statearr_74777_74823[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (3))){
var inst_74749 = (state_74751[(2)]);
var state_74751__$1 = state_74751;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74751__$1,inst_74749);
} else {
if((state_val_74752 === (12))){
var inst_74685 = (state_74751[(7)]);
var inst_74690 = cljs.core.fn_QMARK_(inst_74685);
var state_74751__$1 = state_74751;
if(inst_74690){
var statearr_74778_74824 = state_74751__$1;
(statearr_74778_74824[(1)] = (14));

} else {
var statearr_74779_74825 = state_74751__$1;
(statearr_74779_74825[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (2))){
var inst_74672 = (state_74751[(10)]);
var inst_74672__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_74673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74674 = [sub_chan,inst_74672__$1];
var inst_74675 = (new cljs.core.PersistentVector(null,2,(5),inst_74673,inst_74674,null));
var state_74751__$1 = (function (){var statearr_74780 = state_74751;
(statearr_74780[(10)] = inst_74672__$1);

return statearr_74780;
})();
return cljs.core.async.ioc_alts_BANG_(state_74751__$1,(4),inst_74675);
} else {
if((state_val_74752 === (23))){
var inst_74725 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_74751__$1 = state_74751;
var statearr_74781_74826 = state_74751__$1;
(statearr_74781_74826[(2)] = inst_74725);

(statearr_74781_74826[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (19))){
var inst_74707 = (state_74751[(2)]);
var state_74751__$1 = state_74751;
var statearr_74782_74827 = state_74751__$1;
(statearr_74782_74827[(2)] = inst_74707);

(statearr_74782_74827[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (11))){
var inst_74688 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_74751__$1 = state_74751;
var statearr_74783_74828 = state_74751__$1;
(statearr_74783_74828[(2)] = inst_74688);

(statearr_74783_74828[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (9))){
var inst_74667 = (state_74751[(8)]);
var inst_74717 = fluree.db.connection.ping_transactor(conn);
var inst_74718 = (inst_74667 + (1));
var inst_74667__$1 = inst_74718;
var state_74751__$1 = (function (){var statearr_74784 = state_74751;
(statearr_74784[(15)] = inst_74717);

(statearr_74784[(8)] = inst_74667__$1);

return statearr_74784;
})();
var statearr_74785_74829 = state_74751__$1;
(statearr_74785_74829[(2)] = null);

(statearr_74785_74829[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (5))){
var inst_74667 = (state_74751[(8)]);
var inst_74682 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_74667);
var state_74751__$1 = state_74751;
if(inst_74682){
var statearr_74786_74830 = state_74751__$1;
(statearr_74786_74830[(1)] = (8));

} else {
var statearr_74787_74831 = state_74751__$1;
(statearr_74787_74831[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (14))){
var inst_74685 = (state_74751[(7)]);
var inst_74692 = (inst_74685.cljs$core$IFn$_invoke$arity$0 ? inst_74685.cljs$core$IFn$_invoke$arity$0() : inst_74685.call(null));
var state_74751__$1 = state_74751;
var statearr_74788_74832 = state_74751__$1;
(statearr_74788_74832[(2)] = inst_74692);

(statearr_74788_74832[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (26))){
var inst_74678 = (state_74751[(9)]);
var inst_74729 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74678], 0));
var inst_74667 = (0);
var state_74751__$1 = (function (){var statearr_74789 = state_74751;
(statearr_74789[(16)] = inst_74729);

(statearr_74789[(8)] = inst_74667);

return statearr_74789;
})();
var statearr_74790_74833 = state_74751__$1;
(statearr_74790_74833[(2)] = null);

(statearr_74790_74833[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (16))){
var inst_74709 = (state_74751[(2)]);
var state_74751__$1 = state_74751;
var statearr_74791_74834 = state_74751__$1;
(statearr_74791_74834[(2)] = inst_74709);

(statearr_74791_74834[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (30))){
var state_74751__$1 = state_74751;
var statearr_74792_74835 = state_74751__$1;
(statearr_74792_74835[(2)] = null);

(statearr_74792_74835[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (10))){
var inst_74721 = (state_74751[(2)]);
var state_74751__$1 = state_74751;
var statearr_74793_74836 = state_74751__$1;
(statearr_74793_74836[(2)] = inst_74721);

(statearr_74793_74836[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (18))){
var state_74751__$1 = state_74751;
var statearr_74794_74837 = state_74751__$1;
(statearr_74794_74837[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_74752 === (8))){
var inst_74685 = (state_74751[(7)]);
var inst_74684 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_74685__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74686 = (inst_74685__$1 == null);
var state_74751__$1 = (function (){var statearr_74796 = state_74751;
(statearr_74796[(17)] = inst_74684);

(statearr_74796[(7)] = inst_74685__$1);

return statearr_74796;
})();
if(cljs.core.truth_(inst_74686)){
var statearr_74797_74838 = state_74751__$1;
(statearr_74797_74838[(1)] = (11));

} else {
var statearr_74798_74839 = state_74751__$1;
(statearr_74798_74839[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__16395__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__16395__auto____0 = (function (){
var statearr_74799 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74799[(0)] = fluree$db$connection$msg_consumer_$_state_machine__16395__auto__);

(statearr_74799[(1)] = (1));

return statearr_74799;
});
var fluree$db$connection$msg_consumer_$_state_machine__16395__auto____1 = (function (state_74751){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74751);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74800){var ex__16398__auto__ = e74800;
var statearr_74801_74840 = state_74751;
(statearr_74801_74840[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74751[(4)]))){
var statearr_74802_74841 = state_74751;
(statearr_74802_74841[(1)] = cljs.core.first((state_74751[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74842 = state_74751;
state_74751 = G__74842;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__16395__auto__ = function(state_74751){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__16395__auto____1.call(this,state_74751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__16395__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__16395__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74803 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74803[(6)] = c__16469__auto__);

return statearr_74803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__74844 = arguments.length;
switch (G__74844) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__74845 = opts;
var map__74845__$1 = cljs.core.__destructure_map(map__74845);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74845__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74845__$1,cljs.core.cst$kw$jwt);
return (function (k){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74897){
var state_val_74898 = (state_74897[(1)]);
if((state_val_74898 === (7))){
var inst_74855 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_74856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74857 = [conn_id,cljs.core.cst$kw$token];
var inst_74858 = (new cljs.core.PersistentVector(null,2,(5),inst_74856,inst_74857,null));
var inst_74859 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74855,inst_74858);
var state_74897__$1 = state_74897;
var statearr_74899_74930 = state_74897__$1;
(statearr_74899_74930[(2)] = inst_74859);

(statearr_74899_74930[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (1))){
var state_74897__$1 = state_74897;
var statearr_74900_74931 = state_74897__$1;
(statearr_74900_74931[(2)] = null);

(statearr_74900_74931[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (4))){
var inst_74846 = (state_74897[(2)]);
var state_74897__$1 = state_74897;
var statearr_74901_74932 = state_74897__$1;
(statearr_74901_74932[(2)] = inst_74846);

(statearr_74901_74932[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (15))){
var inst_74866 = (state_74897[(7)]);
var inst_74885 = (state_74897[(2)]);
var inst_74886 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_74887 = [(5000),inst_74885,cljs.core.cst$kw$json];
var inst_74888 = cljs.core.PersistentHashMap.fromArrays(inst_74886,inst_74887);
var inst_74889 = fluree.db.util.xhttp.get(inst_74866,inst_74888);
var state_74897__$1 = state_74897;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74897__$1,(16),inst_74889);
} else {
if((state_val_74898 === (13))){
var inst_74876 = (state_74897[(8)]);
var inst_74866 = (state_74897[(7)]);
var inst_74878 = [cljs.core.cst$kw$headers];
var inst_74879 = [inst_74876];
var inst_74880 = cljs.core.PersistentHashMap.fromArrays(inst_74878,inst_74879);
var inst_74881 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_74866,inst_74880,private$);
var inst_74882 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_74881);
var state_74897__$1 = state_74897;
var statearr_74902_74933 = state_74897__$1;
(statearr_74902_74933[(2)] = inst_74882);

(statearr_74902_74933[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (6))){
var inst_74852 = (state_74897[(9)]);
var state_74897__$1 = state_74897;
var statearr_74903_74934 = state_74897__$1;
(statearr_74903_74934[(2)] = inst_74852);

(statearr_74903_74934[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (3))){
var inst_74895 = (state_74897[(2)]);
var state_74897__$1 = state_74897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74897__$1,inst_74895);
} else {
if((state_val_74898 === (12))){
var inst_74876 = (state_74897[(2)]);
var state_74897__$1 = (function (){var statearr_74904 = state_74897;
(statearr_74904[(8)] = inst_74876);

return statearr_74904;
})();
if(cljs.core.truth_(private$)){
var statearr_74905_74935 = state_74897__$1;
(statearr_74905_74935[(1)] = (13));

} else {
var statearr_74906_74936 = state_74897__$1;
(statearr_74906_74936[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (2))){
var inst_74852 = (state_74897[(9)]);
var _ = (function (){var statearr_74907 = state_74897;
(statearr_74907[(4)] = cljs.core.cons((5),(state_74897[(4)])));

return statearr_74907;
})();
var inst_74852__$1 = jwt;
var state_74897__$1 = (function (){var statearr_74908 = state_74897;
(statearr_74908[(9)] = inst_74852__$1);

return statearr_74908;
})();
if(cljs.core.truth_(inst_74852__$1)){
var statearr_74909_74937 = state_74897__$1;
(statearr_74909_74937[(1)] = (6));

} else {
var statearr_74910_74938 = state_74897__$1;
(statearr_74910_74938[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (11))){
var inst_74870 = (state_74897[(10)]);
var state_74897__$1 = state_74897;
var statearr_74912_74939 = state_74897__$1;
(statearr_74912_74939[(2)] = inst_74870);

(statearr_74912_74939[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (9))){
var inst_74862 = (state_74897[(11)]);
var inst_74861 = (state_74897[(12)]);
var inst_74865 = (state_74897[(2)]);
var inst_74866 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74865),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74862)].join('');
var inst_74868 = ["Accept"];
var inst_74869 = ["application/json"];
var inst_74870 = cljs.core.PersistentHashMap.fromArrays(inst_74868,inst_74869);
var state_74897__$1 = (function (){var statearr_74913 = state_74897;
(statearr_74913[(7)] = inst_74866);

(statearr_74913[(10)] = inst_74870);

return statearr_74913;
})();
if(cljs.core.truth_(inst_74861)){
var statearr_74914_74940 = state_74897__$1;
(statearr_74914_74940[(1)] = (10));

} else {
var statearr_74915_74941 = state_74897__$1;
(statearr_74915_74941[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (5))){
var _ = (function (){var statearr_74916 = state_74897;
(statearr_74916[(4)] = cljs.core.rest((state_74897[(4)])));

return statearr_74916;
})();
var state_74897__$1 = state_74897;
var ex74911 = (state_74897__$1[(2)]);
var statearr_74917_74942 = state_74897__$1;
(statearr_74917_74942[(5)] = ex74911);


if((ex74911 instanceof Error)){
var statearr_74918_74943 = state_74897__$1;
(statearr_74918_74943[(1)] = (4));

(statearr_74918_74943[(5)] = null);

} else {
throw ex74911;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (14))){
var inst_74876 = (state_74897[(8)]);
var state_74897__$1 = state_74897;
var statearr_74919_74944 = state_74897__$1;
(statearr_74919_74944[(2)] = inst_74876);

(statearr_74919_74944[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (16))){
var inst_74891 = (state_74897[(2)]);
var inst_74892 = fluree.db.util.async.throw_err(inst_74891);
var _ = (function (){var statearr_74920 = state_74897;
(statearr_74920[(4)] = cljs.core.rest((state_74897[(4)])));

return statearr_74920;
})();
var state_74897__$1 = state_74897;
var statearr_74921_74945 = state_74897__$1;
(statearr_74921_74945[(2)] = inst_74892);

(statearr_74921_74945[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (10))){
var inst_74861 = (state_74897[(12)]);
var inst_74870 = (state_74897[(10)]);
var inst_74872 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74861)].join('');
var inst_74873 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74870,"Authorization",inst_74872);
var state_74897__$1 = state_74897;
var statearr_74922_74946 = state_74897__$1;
(statearr_74922_74946[(2)] = inst_74873);

(statearr_74922_74946[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74898 === (8))){
var inst_74861 = (state_74897[(2)]);
var inst_74862 = clojure.string.replace(k,"_","/");
var inst_74863 = fluree.db.connection.get_server(conn_id,servers);
var state_74897__$1 = (function (){var statearr_74923 = state_74897;
(statearr_74923[(11)] = inst_74862);

(statearr_74923[(12)] = inst_74861);

return statearr_74923;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74897__$1,(9),inst_74863);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__16395__auto__ = null;
var fluree$db$connection$state_machine__16395__auto____0 = (function (){
var statearr_74924 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74924[(0)] = fluree$db$connection$state_machine__16395__auto__);

(statearr_74924[(1)] = (1));

return statearr_74924;
});
var fluree$db$connection$state_machine__16395__auto____1 = (function (state_74897){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74897);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74925){var ex__16398__auto__ = e74925;
var statearr_74926_74947 = state_74897;
(statearr_74926_74947[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74897[(4)]))){
var statearr_74927_74948 = state_74897;
(statearr_74927_74948[(1)] = cljs.core.first((state_74897[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74949 = state_74897;
state_74897 = G__74949;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$state_machine__16395__auto__ = function(state_74897){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__16395__auto____1.call(this,state_74897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__16395__auto____0;
fluree$db$connection$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__16395__auto____1;
return fluree$db$connection$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74928 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74928[(6)] = c__16469__auto__);

return statearr_74928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__74950_SHARP_){
if(cljs.core.truth_(p1__74950_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),(function (p1__74951_SHARP_){
var or__4212__auto__ = p1__74951_SHARP_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return token;
}
}));

return true;
}catch (e74952){var e = e74952;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__74953 = opts;
var map__74953__$1 = cljs.core.__destructure_map(map__74953);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74953__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74953__$1,cljs.core.cst$kw$parallelism,(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74953__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74953__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74953__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74953__$1,cljs.core.cst$kw$storage_DASH_write,(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74953__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74953__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74953__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74953__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74953__$1,cljs.core.cst$kw$storage_DASH_list);
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4212__auto__ = object_cache;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4212__auto__ = storage_read;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4212__auto__ = storage_exists;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = storage_read;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4210__auto__ = storage_write;
if(cljs.core.truth_(and__4210__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4210__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_list,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__74954_74955 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__74954_74955.cljs$core$IFn$_invoke$arity$0 ? fexpr__74954_74955.cljs$core$IFn$_invoke$arity$0() : fexpr__74954_74955.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4824__auto__ = [];
var len__4818__auto___74996 = arguments.length;
var i__4819__auto___74997 = (0);
while(true){
if((i__4819__auto___74997 < len__4818__auto___74996)){
args__4824__auto__.push((arguments[i__4819__auto___74997]));

var G__74998 = (i__4819__auto___74997 + (1));
i__4819__auto___74997 = G__74998;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__74958){
var vec__74959 = p__74958;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74959,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__16469__auto___74999 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74979){
var state_val_74980 = (state_74979[(1)]);
if((state_val_74980 === (1))){
var inst_74962 = fluree.db.connection.get_socket(conn);
var state_74979__$1 = state_74979;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74979__$1,(2),inst_74962);
} else {
if((state_val_74980 === (2))){
var inst_74965 = (state_74979[(7)]);
var inst_74964 = (state_74979[(8)]);
var inst_74964__$1 = (state_74979[(2)]);
var inst_74965__$1 = (inst_74964__$1 == null);
var state_74979__$1 = (function (){var statearr_74981 = state_74979;
(statearr_74981[(7)] = inst_74965__$1);

(statearr_74981[(8)] = inst_74964__$1);

return statearr_74981;
})();
if(cljs.core.truth_(inst_74965__$1)){
var statearr_74982_75000 = state_74979__$1;
(statearr_74982_75000[(1)] = (3));

} else {
var statearr_74983_75001 = state_74979__$1;
(statearr_74983_75001[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74980 === (3))){
var inst_74965 = (state_74979[(7)]);
var state_74979__$1 = state_74979;
var statearr_74984_75002 = state_74979__$1;
(statearr_74984_75002[(2)] = inst_74965);

(statearr_74984_75002[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74980 === (4))){
var inst_74964 = (state_74979[(8)]);
var inst_74968 = fluree.db.util.core.exception_QMARK_(inst_74964);
var state_74979__$1 = state_74979;
var statearr_74985_75003 = state_74979__$1;
(statearr_74985_75003[(2)] = inst_74968);

(statearr_74985_75003[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74980 === (5))){
var inst_74970 = (state_74979[(2)]);
var state_74979__$1 = state_74979;
if(cljs.core.truth_(inst_74970)){
var statearr_74986_75004 = state_74979__$1;
(statearr_74986_75004[(1)] = (6));

} else {
var statearr_74987_75005 = state_74979__$1;
(statearr_74987_75005[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74980 === (6))){
var inst_74964 = (state_74979[(8)]);
var inst_74972 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74964,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_74973 = cljs.core.async.close_BANG_(conn);
var state_74979__$1 = (function (){var statearr_74988 = state_74979;
(statearr_74988[(9)] = inst_74972);

return statearr_74988;
})();
var statearr_74989_75006 = state_74979__$1;
(statearr_74989_75006[(2)] = inst_74973);

(statearr_74989_75006[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74980 === (7))){
var inst_74975 = fluree.db.connection.msg_consumer(conn);
var state_74979__$1 = state_74979;
var statearr_74990_75007 = state_74979__$1;
(statearr_74990_75007[(2)] = inst_74975);

(statearr_74990_75007[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74980 === (8))){
var inst_74977 = (state_74979[(2)]);
var state_74979__$1 = state_74979;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74979__$1,inst_74977);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__16395__auto__ = null;
var fluree$db$connection$state_machine__16395__auto____0 = (function (){
var statearr_74991 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74991[(0)] = fluree$db$connection$state_machine__16395__auto__);

(statearr_74991[(1)] = (1));

return statearr_74991;
});
var fluree$db$connection$state_machine__16395__auto____1 = (function (state_74979){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74979);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74992){var ex__16398__auto__ = e74992;
var statearr_74993_75008 = state_74979;
(statearr_74993_75008[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74979[(4)]))){
var statearr_74994_75009 = state_74979;
(statearr_74994_75009[(1)] = cljs.core.first((state_74979[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__75010 = state_74979;
state_74979 = G__75010;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$state_machine__16395__auto__ = function(state_74979){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__16395__auto____1.call(this,state_74979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__16395__auto____0;
fluree$db$connection$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__16395__auto____1;
return fluree$db$connection$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74995 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74995[(6)] = c__16469__auto___74999);

return statearr_74995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq74956){
var G__74957 = cljs.core.first(seq74956);
var seq74956__$1 = cljs.core.next(seq74956);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74957,seq74956__$1);
}));

