// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__10481){
var vec__10482 = p__10481;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10482,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10482,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__10485 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10485,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10485,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10485,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10485,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10485,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(goog.object.get(source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5753__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__10488 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10488,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10488,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10488,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10488,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10488,(4),null);
var vec__10491 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10491,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10491,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10491,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10491,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10491,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4212__auto__ = source;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4212__auto__ = line;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4212__auto__ = col;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__10494 = segmap;
var map__10494__$1 = cljs.core.__destructure_map(map__10494);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10494__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10494__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10494__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10494__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10494__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__10496 = arguments.length;
switch (G__10496) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__10500 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__10504 = cljs.core.next(segs__$1);
var G__10505 = nrelseg;
var G__10506 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__10504;
relseg__$1 = G__10505;
result__$1 = G__10506;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10500,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10500,(1),null);
var G__10507 = (gline + (1));
var G__10508 = cljs.core.next(lines__$1);
var G__10509 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__10510 = result__$1;
gline = G__10507;
lines__$1 = G__10508;
relseg = G__10509;
result = G__10510;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__10512 = segmap;
var map__10512__$1 = cljs.core.__destructure_map(map__10512);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10512__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10512__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10512__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10512__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10512__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__10511_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__10511_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__10514 = arguments.length;
switch (G__10514) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__10518 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__10522 = cljs.core.next(segs__$1);
var G__10523 = nrelseg;
var G__10524 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__10522;
relseg__$1 = G__10523;
result__$1 = G__10524;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10518,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10518,(1),null);
var G__10525 = (gline + (1));
var G__10526 = cljs.core.next(lines__$1);
var G__10527 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__10528 = result__$1;
gline = G__10525;
lines__$1 = G__10526;
relseg = G__10527;
result = G__10528;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__10529){
var vec__10530 = p__10529;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10530,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10530,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10530,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10530,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10530,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__10533){
var vec__10534 = p__10533;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10534,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10534,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10534,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10534,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10534,(4),null);
var seg = vec__10534;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__10537){
var vec__10538 = p__10537;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10538,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10538,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10538,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10538,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10538,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__10544 = cljs.core.seq(infos);
var chunk__10545 = null;
var count__10546 = (0);
var i__10547 = (0);
while(true){
if((i__10547 < count__10546)){
var info = chunk__10545.cljs$core$IIndexed$_nth$arity$2(null,i__10547);
var segv_10898 = info__GT_segv(info,source_idx,line,col);
var gline_10899 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_10900 = cljs.core.count(cljs.core.deref(lines));
if((gline_10899 > (lc_10900 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__10544,chunk__10545,count__10546,i__10547,segv_10898,gline_10899,lc_10900,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_10899 - (lc_10900 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_10898], null));
});})(seq__10544,chunk__10545,count__10546,i__10547,segv_10898,gline_10899,lc_10900,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__10544,chunk__10545,count__10546,i__10547,segv_10898,gline_10899,lc_10900,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_10899], null),cljs.core.conj,segv_10898);
});})(seq__10544,chunk__10545,count__10546,i__10547,segv_10898,gline_10899,lc_10900,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__10901 = seq__10544;
var G__10902 = chunk__10545;
var G__10903 = count__10546;
var G__10904 = (i__10547 + (1));
seq__10544 = G__10901;
chunk__10545 = G__10902;
count__10546 = G__10903;
i__10547 = G__10904;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__10544);
if(temp__5753__auto__){
var seq__10544__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10544__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__10544__$1);
var G__10905 = cljs.core.chunk_rest(seq__10544__$1);
var G__10906 = c__4638__auto__;
var G__10907 = cljs.core.count(c__4638__auto__);
var G__10908 = (0);
seq__10544 = G__10905;
chunk__10545 = G__10906;
count__10546 = G__10907;
i__10547 = G__10908;
continue;
} else {
var info = cljs.core.first(seq__10544__$1);
var segv_10909 = info__GT_segv(info,source_idx,line,col);
var gline_10910 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_10911 = cljs.core.count(cljs.core.deref(lines));
if((gline_10910 > (lc_10911 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__10544,chunk__10545,count__10546,i__10547,segv_10909,gline_10910,lc_10911,info,seq__10544__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_10910 - (lc_10911 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_10909], null));
});})(seq__10544,chunk__10545,count__10546,i__10547,segv_10909,gline_10910,lc_10911,info,seq__10544__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__10544,chunk__10545,count__10546,i__10547,segv_10909,gline_10910,lc_10911,info,seq__10544__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_10910], null),cljs.core.conj,segv_10909);
});})(seq__10544,chunk__10545,count__10546,i__10547,segv_10909,gline_10910,lc_10911,info,seq__10544__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__10912 = cljs.core.next(seq__10544__$1);
var G__10913 = null;
var G__10914 = (0);
var G__10915 = (0);
seq__10544 = G__10912;
chunk__10545 = G__10913;
count__10546 = G__10914;
i__10547 = G__10915;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__10548_10916 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__10549_10917 = null;
var count__10550_10918 = (0);
var i__10551_10919 = (0);
while(true){
if((i__10551_10919 < count__10550_10918)){
var vec__10724_10920 = chunk__10549_10917.cljs$core$IIndexed$_nth$arity$2(null,i__10551_10919);
var source_idx_10921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10724_10920,(0),null);
var vec__10727_10922 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10724_10920,(1),null);
var __10923 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10727_10922,(0),null);
var lines_10924__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10727_10922,(1),null);
var seq__10730_10925 = cljs.core.seq(lines_10924__$1);
var chunk__10731_10926 = null;
var count__10732_10927 = (0);
var i__10733_10928 = (0);
while(true){
if((i__10733_10928 < count__10732_10927)){
var vec__10772_10929 = chunk__10731_10926.cljs$core$IIndexed$_nth$arity$2(null,i__10733_10928);
var line_10930 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10772_10929,(0),null);
var cols_10931 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10772_10929,(1),null);
var seq__10775_10932 = cljs.core.seq(cols_10931);
var chunk__10776_10933 = null;
var count__10777_10934 = (0);
var i__10778_10935 = (0);
while(true){
if((i__10778_10935 < count__10777_10934)){
var vec__10785_10936 = chunk__10776_10933.cljs$core$IIndexed$_nth$arity$2(null,i__10778_10935);
var col_10937 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10785_10936,(0),null);
var infos_10938 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10785_10936,(1),null);
encode_cols(infos_10938,source_idx_10921,line_10930,col_10937);


var G__10939 = seq__10775_10932;
var G__10940 = chunk__10776_10933;
var G__10941 = count__10777_10934;
var G__10942 = (i__10778_10935 + (1));
seq__10775_10932 = G__10939;
chunk__10776_10933 = G__10940;
count__10777_10934 = G__10941;
i__10778_10935 = G__10942;
continue;
} else {
var temp__5753__auto___10943 = cljs.core.seq(seq__10775_10932);
if(temp__5753__auto___10943){
var seq__10775_10944__$1 = temp__5753__auto___10943;
if(cljs.core.chunked_seq_QMARK_(seq__10775_10944__$1)){
var c__4638__auto___10945 = cljs.core.chunk_first(seq__10775_10944__$1);
var G__10946 = cljs.core.chunk_rest(seq__10775_10944__$1);
var G__10947 = c__4638__auto___10945;
var G__10948 = cljs.core.count(c__4638__auto___10945);
var G__10949 = (0);
seq__10775_10932 = G__10946;
chunk__10776_10933 = G__10947;
count__10777_10934 = G__10948;
i__10778_10935 = G__10949;
continue;
} else {
var vec__10788_10950 = cljs.core.first(seq__10775_10944__$1);
var col_10951 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10788_10950,(0),null);
var infos_10952 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10788_10950,(1),null);
encode_cols(infos_10952,source_idx_10921,line_10930,col_10951);


var G__10953 = cljs.core.next(seq__10775_10944__$1);
var G__10954 = null;
var G__10955 = (0);
var G__10956 = (0);
seq__10775_10932 = G__10953;
chunk__10776_10933 = G__10954;
count__10777_10934 = G__10955;
i__10778_10935 = G__10956;
continue;
}
} else {
}
}
break;
}


var G__10957 = seq__10730_10925;
var G__10958 = chunk__10731_10926;
var G__10959 = count__10732_10927;
var G__10960 = (i__10733_10928 + (1));
seq__10730_10925 = G__10957;
chunk__10731_10926 = G__10958;
count__10732_10927 = G__10959;
i__10733_10928 = G__10960;
continue;
} else {
var temp__5753__auto___10961 = cljs.core.seq(seq__10730_10925);
if(temp__5753__auto___10961){
var seq__10730_10962__$1 = temp__5753__auto___10961;
if(cljs.core.chunked_seq_QMARK_(seq__10730_10962__$1)){
var c__4638__auto___10963 = cljs.core.chunk_first(seq__10730_10962__$1);
var G__10964 = cljs.core.chunk_rest(seq__10730_10962__$1);
var G__10965 = c__4638__auto___10963;
var G__10966 = cljs.core.count(c__4638__auto___10963);
var G__10967 = (0);
seq__10730_10925 = G__10964;
chunk__10731_10926 = G__10965;
count__10732_10927 = G__10966;
i__10733_10928 = G__10967;
continue;
} else {
var vec__10791_10968 = cljs.core.first(seq__10730_10962__$1);
var line_10969 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10791_10968,(0),null);
var cols_10970 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10791_10968,(1),null);
var seq__10794_10971 = cljs.core.seq(cols_10970);
var chunk__10795_10972 = null;
var count__10796_10973 = (0);
var i__10797_10974 = (0);
while(true){
if((i__10797_10974 < count__10796_10973)){
var vec__10804_10975 = chunk__10795_10972.cljs$core$IIndexed$_nth$arity$2(null,i__10797_10974);
var col_10976 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10804_10975,(0),null);
var infos_10977 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10804_10975,(1),null);
encode_cols(infos_10977,source_idx_10921,line_10969,col_10976);


var G__10978 = seq__10794_10971;
var G__10979 = chunk__10795_10972;
var G__10980 = count__10796_10973;
var G__10981 = (i__10797_10974 + (1));
seq__10794_10971 = G__10978;
chunk__10795_10972 = G__10979;
count__10796_10973 = G__10980;
i__10797_10974 = G__10981;
continue;
} else {
var temp__5753__auto___10982__$1 = cljs.core.seq(seq__10794_10971);
if(temp__5753__auto___10982__$1){
var seq__10794_10983__$1 = temp__5753__auto___10982__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10794_10983__$1)){
var c__4638__auto___10984 = cljs.core.chunk_first(seq__10794_10983__$1);
var G__10985 = cljs.core.chunk_rest(seq__10794_10983__$1);
var G__10986 = c__4638__auto___10984;
var G__10987 = cljs.core.count(c__4638__auto___10984);
var G__10988 = (0);
seq__10794_10971 = G__10985;
chunk__10795_10972 = G__10986;
count__10796_10973 = G__10987;
i__10797_10974 = G__10988;
continue;
} else {
var vec__10807_10989 = cljs.core.first(seq__10794_10983__$1);
var col_10990 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10807_10989,(0),null);
var infos_10991 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10807_10989,(1),null);
encode_cols(infos_10991,source_idx_10921,line_10969,col_10990);


var G__10992 = cljs.core.next(seq__10794_10983__$1);
var G__10993 = null;
var G__10994 = (0);
var G__10995 = (0);
seq__10794_10971 = G__10992;
chunk__10795_10972 = G__10993;
count__10796_10973 = G__10994;
i__10797_10974 = G__10995;
continue;
}
} else {
}
}
break;
}


var G__10996 = cljs.core.next(seq__10730_10962__$1);
var G__10997 = null;
var G__10998 = (0);
var G__10999 = (0);
seq__10730_10925 = G__10996;
chunk__10731_10926 = G__10997;
count__10732_10927 = G__10998;
i__10733_10928 = G__10999;
continue;
}
} else {
}
}
break;
}


var G__11000 = seq__10548_10916;
var G__11001 = chunk__10549_10917;
var G__11002 = count__10550_10918;
var G__11003 = (i__10551_10919 + (1));
seq__10548_10916 = G__11000;
chunk__10549_10917 = G__11001;
count__10550_10918 = G__11002;
i__10551_10919 = G__11003;
continue;
} else {
var temp__5753__auto___11004 = cljs.core.seq(seq__10548_10916);
if(temp__5753__auto___11004){
var seq__10548_11005__$1 = temp__5753__auto___11004;
if(cljs.core.chunked_seq_QMARK_(seq__10548_11005__$1)){
var c__4638__auto___11006 = cljs.core.chunk_first(seq__10548_11005__$1);
var G__11007 = cljs.core.chunk_rest(seq__10548_11005__$1);
var G__11008 = c__4638__auto___11006;
var G__11009 = cljs.core.count(c__4638__auto___11006);
var G__11010 = (0);
seq__10548_10916 = G__11007;
chunk__10549_10917 = G__11008;
count__10550_10918 = G__11009;
i__10551_10919 = G__11010;
continue;
} else {
var vec__10810_11011 = cljs.core.first(seq__10548_11005__$1);
var source_idx_11012 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10810_11011,(0),null);
var vec__10813_11013 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10810_11011,(1),null);
var __11014 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10813_11013,(0),null);
var lines_11015__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10813_11013,(1),null);
var seq__10816_11016 = cljs.core.seq(lines_11015__$1);
var chunk__10817_11017 = null;
var count__10818_11018 = (0);
var i__10819_11019 = (0);
while(true){
if((i__10819_11019 < count__10818_11018)){
var vec__10858_11020 = chunk__10817_11017.cljs$core$IIndexed$_nth$arity$2(null,i__10819_11019);
var line_11021 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10858_11020,(0),null);
var cols_11022 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10858_11020,(1),null);
var seq__10861_11023 = cljs.core.seq(cols_11022);
var chunk__10862_11024 = null;
var count__10863_11025 = (0);
var i__10864_11026 = (0);
while(true){
if((i__10864_11026 < count__10863_11025)){
var vec__10871_11027 = chunk__10862_11024.cljs$core$IIndexed$_nth$arity$2(null,i__10864_11026);
var col_11028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10871_11027,(0),null);
var infos_11029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10871_11027,(1),null);
encode_cols(infos_11029,source_idx_11012,line_11021,col_11028);


var G__11030 = seq__10861_11023;
var G__11031 = chunk__10862_11024;
var G__11032 = count__10863_11025;
var G__11033 = (i__10864_11026 + (1));
seq__10861_11023 = G__11030;
chunk__10862_11024 = G__11031;
count__10863_11025 = G__11032;
i__10864_11026 = G__11033;
continue;
} else {
var temp__5753__auto___11034__$1 = cljs.core.seq(seq__10861_11023);
if(temp__5753__auto___11034__$1){
var seq__10861_11035__$1 = temp__5753__auto___11034__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10861_11035__$1)){
var c__4638__auto___11036 = cljs.core.chunk_first(seq__10861_11035__$1);
var G__11037 = cljs.core.chunk_rest(seq__10861_11035__$1);
var G__11038 = c__4638__auto___11036;
var G__11039 = cljs.core.count(c__4638__auto___11036);
var G__11040 = (0);
seq__10861_11023 = G__11037;
chunk__10862_11024 = G__11038;
count__10863_11025 = G__11039;
i__10864_11026 = G__11040;
continue;
} else {
var vec__10874_11041 = cljs.core.first(seq__10861_11035__$1);
var col_11042 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10874_11041,(0),null);
var infos_11043 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10874_11041,(1),null);
encode_cols(infos_11043,source_idx_11012,line_11021,col_11042);


var G__11044 = cljs.core.next(seq__10861_11035__$1);
var G__11045 = null;
var G__11046 = (0);
var G__11047 = (0);
seq__10861_11023 = G__11044;
chunk__10862_11024 = G__11045;
count__10863_11025 = G__11046;
i__10864_11026 = G__11047;
continue;
}
} else {
}
}
break;
}


var G__11048 = seq__10816_11016;
var G__11049 = chunk__10817_11017;
var G__11050 = count__10818_11018;
var G__11051 = (i__10819_11019 + (1));
seq__10816_11016 = G__11048;
chunk__10817_11017 = G__11049;
count__10818_11018 = G__11050;
i__10819_11019 = G__11051;
continue;
} else {
var temp__5753__auto___11052__$1 = cljs.core.seq(seq__10816_11016);
if(temp__5753__auto___11052__$1){
var seq__10816_11053__$1 = temp__5753__auto___11052__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10816_11053__$1)){
var c__4638__auto___11054 = cljs.core.chunk_first(seq__10816_11053__$1);
var G__11055 = cljs.core.chunk_rest(seq__10816_11053__$1);
var G__11056 = c__4638__auto___11054;
var G__11057 = cljs.core.count(c__4638__auto___11054);
var G__11058 = (0);
seq__10816_11016 = G__11055;
chunk__10817_11017 = G__11056;
count__10818_11018 = G__11057;
i__10819_11019 = G__11058;
continue;
} else {
var vec__10877_11059 = cljs.core.first(seq__10816_11053__$1);
var line_11060 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10877_11059,(0),null);
var cols_11061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10877_11059,(1),null);
var seq__10880_11062 = cljs.core.seq(cols_11061);
var chunk__10881_11063 = null;
var count__10882_11064 = (0);
var i__10883_11065 = (0);
while(true){
if((i__10883_11065 < count__10882_11064)){
var vec__10890_11066 = chunk__10881_11063.cljs$core$IIndexed$_nth$arity$2(null,i__10883_11065);
var col_11067 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10890_11066,(0),null);
var infos_11068 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10890_11066,(1),null);
encode_cols(infos_11068,source_idx_11012,line_11060,col_11067);


var G__11069 = seq__10880_11062;
var G__11070 = chunk__10881_11063;
var G__11071 = count__10882_11064;
var G__11072 = (i__10883_11065 + (1));
seq__10880_11062 = G__11069;
chunk__10881_11063 = G__11070;
count__10882_11064 = G__11071;
i__10883_11065 = G__11072;
continue;
} else {
var temp__5753__auto___11073__$2 = cljs.core.seq(seq__10880_11062);
if(temp__5753__auto___11073__$2){
var seq__10880_11074__$1 = temp__5753__auto___11073__$2;
if(cljs.core.chunked_seq_QMARK_(seq__10880_11074__$1)){
var c__4638__auto___11075 = cljs.core.chunk_first(seq__10880_11074__$1);
var G__11076 = cljs.core.chunk_rest(seq__10880_11074__$1);
var G__11077 = c__4638__auto___11075;
var G__11078 = cljs.core.count(c__4638__auto___11075);
var G__11079 = (0);
seq__10880_11062 = G__11076;
chunk__10881_11063 = G__11077;
count__10882_11064 = G__11078;
i__10883_11065 = G__11079;
continue;
} else {
var vec__10893_11080 = cljs.core.first(seq__10880_11074__$1);
var col_11081 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10893_11080,(0),null);
var infos_11082 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10893_11080,(1),null);
encode_cols(infos_11082,source_idx_11012,line_11060,col_11081);


var G__11083 = cljs.core.next(seq__10880_11074__$1);
var G__11084 = null;
var G__11085 = (0);
var G__11086 = (0);
seq__10880_11062 = G__11083;
chunk__10881_11063 = G__11084;
count__10882_11064 = G__11085;
i__10883_11065 = G__11086;
continue;
}
} else {
}
}
break;
}


var G__11087 = cljs.core.next(seq__10816_11053__$1);
var G__11088 = null;
var G__11089 = (0);
var G__11090 = (0);
seq__10816_11016 = G__11087;
chunk__10817_11017 = G__11088;
count__10818_11018 = G__11089;
i__10819_11019 = G__11090;
continue;
}
} else {
}
}
break;
}


var G__11091 = cljs.core.next(seq__10548_11005__$1);
var G__11092 = null;
var G__11093 = (0);
var G__11094 = (0);
seq__10548_10916 = G__11091;
chunk__10549_10917 = G__11092;
count__10550_10918 = G__11093;
i__10551_10919 = G__11094;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__10896 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__10541_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__10541_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__10542_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__10542_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10543_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__10543_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__10897 = G__10896;
goog.object.set(G__10897,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts)));

return G__10897;
} else {
return G__10896;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__11095 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11095,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11095,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__11098 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11098,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11098,(1),null);
var G__11103 = cljs.core.next(col_map_seq);
var G__11104 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__11098,col,infos,vec__11095,line,col_map){
return (function (v,p__11101){
var map__11102 = p__11101;
var map__11102__$1 = cljs.core.__destructure_map(map__11102);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11102__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11102__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__11098,col,infos,vec__11095,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__11103;
new_cols = G__11104;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__11105 = cljs.core.next(line_map_seq);
var G__11106 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__11105;
new_lines = G__11106;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__11107_11315 = cljs.core.seq(reverse_map);
var chunk__11108_11316 = null;
var count__11109_11317 = (0);
var i__11110_11318 = (0);
while(true){
if((i__11110_11318 < count__11109_11317)){
var vec__11213_11319 = chunk__11108_11316.cljs$core$IIndexed$_nth$arity$2(null,i__11110_11318);
var line_11320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11213_11319,(0),null);
var columns_11321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11213_11319,(1),null);
var seq__11216_11322 = cljs.core.seq(columns_11321);
var chunk__11217_11323 = null;
var count__11218_11324 = (0);
var i__11219_11325 = (0);
while(true){
if((i__11219_11325 < count__11218_11324)){
var vec__11242_11326 = chunk__11217_11323.cljs$core$IIndexed$_nth$arity$2(null,i__11219_11325);
var column_11327 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11242_11326,(0),null);
var column_info_11328 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11242_11326,(1),null);
var seq__11245_11329 = cljs.core.seq(column_info_11328);
var chunk__11246_11330 = null;
var count__11247_11331 = (0);
var i__11248_11332 = (0);
while(true){
if((i__11248_11332 < count__11247_11331)){
var map__11251_11333 = chunk__11246_11330.cljs$core$IIndexed$_nth$arity$2(null,i__11248_11332);
var map__11251_11334__$1 = cljs.core.__destructure_map(map__11251_11333);
var gline_11335 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11251_11334__$1,cljs.core.cst$kw$gline);
var gcol_11336 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11251_11334__$1,cljs.core.cst$kw$gcol);
var name_11337 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11251_11334__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11335], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11245_11329,chunk__11246_11330,count__11247_11331,i__11248_11332,seq__11216_11322,chunk__11217_11323,count__11218_11324,i__11219_11325,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11251_11333,map__11251_11334__$1,gline_11335,gcol_11336,name_11337,vec__11242_11326,column_11327,column_info_11328,vec__11213_11319,line_11320,columns_11321,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11336], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11320,cljs.core.cst$kw$col,column_11327,cljs.core.cst$kw$name,name_11337], null));
});})(seq__11245_11329,chunk__11246_11330,count__11247_11331,i__11248_11332,seq__11216_11322,chunk__11217_11323,count__11218_11324,i__11219_11325,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11251_11333,map__11251_11334__$1,gline_11335,gcol_11336,name_11337,vec__11242_11326,column_11327,column_info_11328,vec__11213_11319,line_11320,columns_11321,inverted))
,cljs.core.sorted_map()));


var G__11338 = seq__11245_11329;
var G__11339 = chunk__11246_11330;
var G__11340 = count__11247_11331;
var G__11341 = (i__11248_11332 + (1));
seq__11245_11329 = G__11338;
chunk__11246_11330 = G__11339;
count__11247_11331 = G__11340;
i__11248_11332 = G__11341;
continue;
} else {
var temp__5753__auto___11342 = cljs.core.seq(seq__11245_11329);
if(temp__5753__auto___11342){
var seq__11245_11343__$1 = temp__5753__auto___11342;
if(cljs.core.chunked_seq_QMARK_(seq__11245_11343__$1)){
var c__4638__auto___11344 = cljs.core.chunk_first(seq__11245_11343__$1);
var G__11345 = cljs.core.chunk_rest(seq__11245_11343__$1);
var G__11346 = c__4638__auto___11344;
var G__11347 = cljs.core.count(c__4638__auto___11344);
var G__11348 = (0);
seq__11245_11329 = G__11345;
chunk__11246_11330 = G__11346;
count__11247_11331 = G__11347;
i__11248_11332 = G__11348;
continue;
} else {
var map__11252_11349 = cljs.core.first(seq__11245_11343__$1);
var map__11252_11350__$1 = cljs.core.__destructure_map(map__11252_11349);
var gline_11351 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11252_11350__$1,cljs.core.cst$kw$gline);
var gcol_11352 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11252_11350__$1,cljs.core.cst$kw$gcol);
var name_11353 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11252_11350__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11351], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11245_11329,chunk__11246_11330,count__11247_11331,i__11248_11332,seq__11216_11322,chunk__11217_11323,count__11218_11324,i__11219_11325,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11252_11349,map__11252_11350__$1,gline_11351,gcol_11352,name_11353,seq__11245_11343__$1,temp__5753__auto___11342,vec__11242_11326,column_11327,column_info_11328,vec__11213_11319,line_11320,columns_11321,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11352], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11320,cljs.core.cst$kw$col,column_11327,cljs.core.cst$kw$name,name_11353], null));
});})(seq__11245_11329,chunk__11246_11330,count__11247_11331,i__11248_11332,seq__11216_11322,chunk__11217_11323,count__11218_11324,i__11219_11325,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11252_11349,map__11252_11350__$1,gline_11351,gcol_11352,name_11353,seq__11245_11343__$1,temp__5753__auto___11342,vec__11242_11326,column_11327,column_info_11328,vec__11213_11319,line_11320,columns_11321,inverted))
,cljs.core.sorted_map()));


var G__11354 = cljs.core.next(seq__11245_11343__$1);
var G__11355 = null;
var G__11356 = (0);
var G__11357 = (0);
seq__11245_11329 = G__11354;
chunk__11246_11330 = G__11355;
count__11247_11331 = G__11356;
i__11248_11332 = G__11357;
continue;
}
} else {
}
}
break;
}


var G__11358 = seq__11216_11322;
var G__11359 = chunk__11217_11323;
var G__11360 = count__11218_11324;
var G__11361 = (i__11219_11325 + (1));
seq__11216_11322 = G__11358;
chunk__11217_11323 = G__11359;
count__11218_11324 = G__11360;
i__11219_11325 = G__11361;
continue;
} else {
var temp__5753__auto___11362 = cljs.core.seq(seq__11216_11322);
if(temp__5753__auto___11362){
var seq__11216_11363__$1 = temp__5753__auto___11362;
if(cljs.core.chunked_seq_QMARK_(seq__11216_11363__$1)){
var c__4638__auto___11364 = cljs.core.chunk_first(seq__11216_11363__$1);
var G__11365 = cljs.core.chunk_rest(seq__11216_11363__$1);
var G__11366 = c__4638__auto___11364;
var G__11367 = cljs.core.count(c__4638__auto___11364);
var G__11368 = (0);
seq__11216_11322 = G__11365;
chunk__11217_11323 = G__11366;
count__11218_11324 = G__11367;
i__11219_11325 = G__11368;
continue;
} else {
var vec__11253_11369 = cljs.core.first(seq__11216_11363__$1);
var column_11370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11253_11369,(0),null);
var column_info_11371 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11253_11369,(1),null);
var seq__11256_11372 = cljs.core.seq(column_info_11371);
var chunk__11257_11373 = null;
var count__11258_11374 = (0);
var i__11259_11375 = (0);
while(true){
if((i__11259_11375 < count__11258_11374)){
var map__11262_11376 = chunk__11257_11373.cljs$core$IIndexed$_nth$arity$2(null,i__11259_11375);
var map__11262_11377__$1 = cljs.core.__destructure_map(map__11262_11376);
var gline_11378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11262_11377__$1,cljs.core.cst$kw$gline);
var gcol_11379 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11262_11377__$1,cljs.core.cst$kw$gcol);
var name_11380 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11262_11377__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11378], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11256_11372,chunk__11257_11373,count__11258_11374,i__11259_11375,seq__11216_11322,chunk__11217_11323,count__11218_11324,i__11219_11325,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11262_11376,map__11262_11377__$1,gline_11378,gcol_11379,name_11380,vec__11253_11369,column_11370,column_info_11371,seq__11216_11363__$1,temp__5753__auto___11362,vec__11213_11319,line_11320,columns_11321,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11379], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11320,cljs.core.cst$kw$col,column_11370,cljs.core.cst$kw$name,name_11380], null));
});})(seq__11256_11372,chunk__11257_11373,count__11258_11374,i__11259_11375,seq__11216_11322,chunk__11217_11323,count__11218_11324,i__11219_11325,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11262_11376,map__11262_11377__$1,gline_11378,gcol_11379,name_11380,vec__11253_11369,column_11370,column_info_11371,seq__11216_11363__$1,temp__5753__auto___11362,vec__11213_11319,line_11320,columns_11321,inverted))
,cljs.core.sorted_map()));


var G__11381 = seq__11256_11372;
var G__11382 = chunk__11257_11373;
var G__11383 = count__11258_11374;
var G__11384 = (i__11259_11375 + (1));
seq__11256_11372 = G__11381;
chunk__11257_11373 = G__11382;
count__11258_11374 = G__11383;
i__11259_11375 = G__11384;
continue;
} else {
var temp__5753__auto___11385__$1 = cljs.core.seq(seq__11256_11372);
if(temp__5753__auto___11385__$1){
var seq__11256_11386__$1 = temp__5753__auto___11385__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11256_11386__$1)){
var c__4638__auto___11387 = cljs.core.chunk_first(seq__11256_11386__$1);
var G__11388 = cljs.core.chunk_rest(seq__11256_11386__$1);
var G__11389 = c__4638__auto___11387;
var G__11390 = cljs.core.count(c__4638__auto___11387);
var G__11391 = (0);
seq__11256_11372 = G__11388;
chunk__11257_11373 = G__11389;
count__11258_11374 = G__11390;
i__11259_11375 = G__11391;
continue;
} else {
var map__11263_11392 = cljs.core.first(seq__11256_11386__$1);
var map__11263_11393__$1 = cljs.core.__destructure_map(map__11263_11392);
var gline_11394 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11263_11393__$1,cljs.core.cst$kw$gline);
var gcol_11395 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11263_11393__$1,cljs.core.cst$kw$gcol);
var name_11396 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11263_11393__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11394], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11256_11372,chunk__11257_11373,count__11258_11374,i__11259_11375,seq__11216_11322,chunk__11217_11323,count__11218_11324,i__11219_11325,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11263_11392,map__11263_11393__$1,gline_11394,gcol_11395,name_11396,seq__11256_11386__$1,temp__5753__auto___11385__$1,vec__11253_11369,column_11370,column_info_11371,seq__11216_11363__$1,temp__5753__auto___11362,vec__11213_11319,line_11320,columns_11321,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11395], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11320,cljs.core.cst$kw$col,column_11370,cljs.core.cst$kw$name,name_11396], null));
});})(seq__11256_11372,chunk__11257_11373,count__11258_11374,i__11259_11375,seq__11216_11322,chunk__11217_11323,count__11218_11324,i__11219_11325,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11263_11392,map__11263_11393__$1,gline_11394,gcol_11395,name_11396,seq__11256_11386__$1,temp__5753__auto___11385__$1,vec__11253_11369,column_11370,column_info_11371,seq__11216_11363__$1,temp__5753__auto___11362,vec__11213_11319,line_11320,columns_11321,inverted))
,cljs.core.sorted_map()));


var G__11397 = cljs.core.next(seq__11256_11386__$1);
var G__11398 = null;
var G__11399 = (0);
var G__11400 = (0);
seq__11256_11372 = G__11397;
chunk__11257_11373 = G__11398;
count__11258_11374 = G__11399;
i__11259_11375 = G__11400;
continue;
}
} else {
}
}
break;
}


var G__11401 = cljs.core.next(seq__11216_11363__$1);
var G__11402 = null;
var G__11403 = (0);
var G__11404 = (0);
seq__11216_11322 = G__11401;
chunk__11217_11323 = G__11402;
count__11218_11324 = G__11403;
i__11219_11325 = G__11404;
continue;
}
} else {
}
}
break;
}


var G__11405 = seq__11107_11315;
var G__11406 = chunk__11108_11316;
var G__11407 = count__11109_11317;
var G__11408 = (i__11110_11318 + (1));
seq__11107_11315 = G__11405;
chunk__11108_11316 = G__11406;
count__11109_11317 = G__11407;
i__11110_11318 = G__11408;
continue;
} else {
var temp__5753__auto___11409 = cljs.core.seq(seq__11107_11315);
if(temp__5753__auto___11409){
var seq__11107_11410__$1 = temp__5753__auto___11409;
if(cljs.core.chunked_seq_QMARK_(seq__11107_11410__$1)){
var c__4638__auto___11411 = cljs.core.chunk_first(seq__11107_11410__$1);
var G__11412 = cljs.core.chunk_rest(seq__11107_11410__$1);
var G__11413 = c__4638__auto___11411;
var G__11414 = cljs.core.count(c__4638__auto___11411);
var G__11415 = (0);
seq__11107_11315 = G__11412;
chunk__11108_11316 = G__11413;
count__11109_11317 = G__11414;
i__11110_11318 = G__11415;
continue;
} else {
var vec__11264_11416 = cljs.core.first(seq__11107_11410__$1);
var line_11417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11264_11416,(0),null);
var columns_11418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11264_11416,(1),null);
var seq__11267_11419 = cljs.core.seq(columns_11418);
var chunk__11268_11420 = null;
var count__11269_11421 = (0);
var i__11270_11422 = (0);
while(true){
if((i__11270_11422 < count__11269_11421)){
var vec__11293_11423 = chunk__11268_11420.cljs$core$IIndexed$_nth$arity$2(null,i__11270_11422);
var column_11424 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11293_11423,(0),null);
var column_info_11425 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11293_11423,(1),null);
var seq__11296_11426 = cljs.core.seq(column_info_11425);
var chunk__11297_11427 = null;
var count__11298_11428 = (0);
var i__11299_11429 = (0);
while(true){
if((i__11299_11429 < count__11298_11428)){
var map__11302_11430 = chunk__11297_11427.cljs$core$IIndexed$_nth$arity$2(null,i__11299_11429);
var map__11302_11431__$1 = cljs.core.__destructure_map(map__11302_11430);
var gline_11432 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11302_11431__$1,cljs.core.cst$kw$gline);
var gcol_11433 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11302_11431__$1,cljs.core.cst$kw$gcol);
var name_11434 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11302_11431__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11432], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11296_11426,chunk__11297_11427,count__11298_11428,i__11299_11429,seq__11267_11419,chunk__11268_11420,count__11269_11421,i__11270_11422,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11302_11430,map__11302_11431__$1,gline_11432,gcol_11433,name_11434,vec__11293_11423,column_11424,column_info_11425,vec__11264_11416,line_11417,columns_11418,seq__11107_11410__$1,temp__5753__auto___11409,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11433], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11417,cljs.core.cst$kw$col,column_11424,cljs.core.cst$kw$name,name_11434], null));
});})(seq__11296_11426,chunk__11297_11427,count__11298_11428,i__11299_11429,seq__11267_11419,chunk__11268_11420,count__11269_11421,i__11270_11422,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11302_11430,map__11302_11431__$1,gline_11432,gcol_11433,name_11434,vec__11293_11423,column_11424,column_info_11425,vec__11264_11416,line_11417,columns_11418,seq__11107_11410__$1,temp__5753__auto___11409,inverted))
,cljs.core.sorted_map()));


var G__11435 = seq__11296_11426;
var G__11436 = chunk__11297_11427;
var G__11437 = count__11298_11428;
var G__11438 = (i__11299_11429 + (1));
seq__11296_11426 = G__11435;
chunk__11297_11427 = G__11436;
count__11298_11428 = G__11437;
i__11299_11429 = G__11438;
continue;
} else {
var temp__5753__auto___11439__$1 = cljs.core.seq(seq__11296_11426);
if(temp__5753__auto___11439__$1){
var seq__11296_11440__$1 = temp__5753__auto___11439__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11296_11440__$1)){
var c__4638__auto___11441 = cljs.core.chunk_first(seq__11296_11440__$1);
var G__11442 = cljs.core.chunk_rest(seq__11296_11440__$1);
var G__11443 = c__4638__auto___11441;
var G__11444 = cljs.core.count(c__4638__auto___11441);
var G__11445 = (0);
seq__11296_11426 = G__11442;
chunk__11297_11427 = G__11443;
count__11298_11428 = G__11444;
i__11299_11429 = G__11445;
continue;
} else {
var map__11303_11446 = cljs.core.first(seq__11296_11440__$1);
var map__11303_11447__$1 = cljs.core.__destructure_map(map__11303_11446);
var gline_11448 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11303_11447__$1,cljs.core.cst$kw$gline);
var gcol_11449 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11303_11447__$1,cljs.core.cst$kw$gcol);
var name_11450 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11303_11447__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11448], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11296_11426,chunk__11297_11427,count__11298_11428,i__11299_11429,seq__11267_11419,chunk__11268_11420,count__11269_11421,i__11270_11422,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11303_11446,map__11303_11447__$1,gline_11448,gcol_11449,name_11450,seq__11296_11440__$1,temp__5753__auto___11439__$1,vec__11293_11423,column_11424,column_info_11425,vec__11264_11416,line_11417,columns_11418,seq__11107_11410__$1,temp__5753__auto___11409,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11449], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11417,cljs.core.cst$kw$col,column_11424,cljs.core.cst$kw$name,name_11450], null));
});})(seq__11296_11426,chunk__11297_11427,count__11298_11428,i__11299_11429,seq__11267_11419,chunk__11268_11420,count__11269_11421,i__11270_11422,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11303_11446,map__11303_11447__$1,gline_11448,gcol_11449,name_11450,seq__11296_11440__$1,temp__5753__auto___11439__$1,vec__11293_11423,column_11424,column_info_11425,vec__11264_11416,line_11417,columns_11418,seq__11107_11410__$1,temp__5753__auto___11409,inverted))
,cljs.core.sorted_map()));


var G__11451 = cljs.core.next(seq__11296_11440__$1);
var G__11452 = null;
var G__11453 = (0);
var G__11454 = (0);
seq__11296_11426 = G__11451;
chunk__11297_11427 = G__11452;
count__11298_11428 = G__11453;
i__11299_11429 = G__11454;
continue;
}
} else {
}
}
break;
}


var G__11455 = seq__11267_11419;
var G__11456 = chunk__11268_11420;
var G__11457 = count__11269_11421;
var G__11458 = (i__11270_11422 + (1));
seq__11267_11419 = G__11455;
chunk__11268_11420 = G__11456;
count__11269_11421 = G__11457;
i__11270_11422 = G__11458;
continue;
} else {
var temp__5753__auto___11459__$1 = cljs.core.seq(seq__11267_11419);
if(temp__5753__auto___11459__$1){
var seq__11267_11460__$1 = temp__5753__auto___11459__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11267_11460__$1)){
var c__4638__auto___11461 = cljs.core.chunk_first(seq__11267_11460__$1);
var G__11462 = cljs.core.chunk_rest(seq__11267_11460__$1);
var G__11463 = c__4638__auto___11461;
var G__11464 = cljs.core.count(c__4638__auto___11461);
var G__11465 = (0);
seq__11267_11419 = G__11462;
chunk__11268_11420 = G__11463;
count__11269_11421 = G__11464;
i__11270_11422 = G__11465;
continue;
} else {
var vec__11304_11466 = cljs.core.first(seq__11267_11460__$1);
var column_11467 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11304_11466,(0),null);
var column_info_11468 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11304_11466,(1),null);
var seq__11307_11469 = cljs.core.seq(column_info_11468);
var chunk__11308_11470 = null;
var count__11309_11471 = (0);
var i__11310_11472 = (0);
while(true){
if((i__11310_11472 < count__11309_11471)){
var map__11313_11473 = chunk__11308_11470.cljs$core$IIndexed$_nth$arity$2(null,i__11310_11472);
var map__11313_11474__$1 = cljs.core.__destructure_map(map__11313_11473);
var gline_11475 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11313_11474__$1,cljs.core.cst$kw$gline);
var gcol_11476 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11313_11474__$1,cljs.core.cst$kw$gcol);
var name_11477 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11313_11474__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11475], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11307_11469,chunk__11308_11470,count__11309_11471,i__11310_11472,seq__11267_11419,chunk__11268_11420,count__11269_11421,i__11270_11422,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11313_11473,map__11313_11474__$1,gline_11475,gcol_11476,name_11477,vec__11304_11466,column_11467,column_info_11468,seq__11267_11460__$1,temp__5753__auto___11459__$1,vec__11264_11416,line_11417,columns_11418,seq__11107_11410__$1,temp__5753__auto___11409,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11476], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11417,cljs.core.cst$kw$col,column_11467,cljs.core.cst$kw$name,name_11477], null));
});})(seq__11307_11469,chunk__11308_11470,count__11309_11471,i__11310_11472,seq__11267_11419,chunk__11268_11420,count__11269_11421,i__11270_11422,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11313_11473,map__11313_11474__$1,gline_11475,gcol_11476,name_11477,vec__11304_11466,column_11467,column_info_11468,seq__11267_11460__$1,temp__5753__auto___11459__$1,vec__11264_11416,line_11417,columns_11418,seq__11107_11410__$1,temp__5753__auto___11409,inverted))
,cljs.core.sorted_map()));


var G__11478 = seq__11307_11469;
var G__11479 = chunk__11308_11470;
var G__11480 = count__11309_11471;
var G__11481 = (i__11310_11472 + (1));
seq__11307_11469 = G__11478;
chunk__11308_11470 = G__11479;
count__11309_11471 = G__11480;
i__11310_11472 = G__11481;
continue;
} else {
var temp__5753__auto___11482__$2 = cljs.core.seq(seq__11307_11469);
if(temp__5753__auto___11482__$2){
var seq__11307_11483__$1 = temp__5753__auto___11482__$2;
if(cljs.core.chunked_seq_QMARK_(seq__11307_11483__$1)){
var c__4638__auto___11484 = cljs.core.chunk_first(seq__11307_11483__$1);
var G__11485 = cljs.core.chunk_rest(seq__11307_11483__$1);
var G__11486 = c__4638__auto___11484;
var G__11487 = cljs.core.count(c__4638__auto___11484);
var G__11488 = (0);
seq__11307_11469 = G__11485;
chunk__11308_11470 = G__11486;
count__11309_11471 = G__11487;
i__11310_11472 = G__11488;
continue;
} else {
var map__11314_11489 = cljs.core.first(seq__11307_11483__$1);
var map__11314_11490__$1 = cljs.core.__destructure_map(map__11314_11489);
var gline_11491 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11314_11490__$1,cljs.core.cst$kw$gline);
var gcol_11492 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11314_11490__$1,cljs.core.cst$kw$gcol);
var name_11493 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11314_11490__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11491], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11307_11469,chunk__11308_11470,count__11309_11471,i__11310_11472,seq__11267_11419,chunk__11268_11420,count__11269_11421,i__11270_11422,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11314_11489,map__11314_11490__$1,gline_11491,gcol_11492,name_11493,seq__11307_11483__$1,temp__5753__auto___11482__$2,vec__11304_11466,column_11467,column_info_11468,seq__11267_11460__$1,temp__5753__auto___11459__$1,vec__11264_11416,line_11417,columns_11418,seq__11107_11410__$1,temp__5753__auto___11409,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11492], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11417,cljs.core.cst$kw$col,column_11467,cljs.core.cst$kw$name,name_11493], null));
});})(seq__11307_11469,chunk__11308_11470,count__11309_11471,i__11310_11472,seq__11267_11419,chunk__11268_11420,count__11269_11421,i__11270_11422,seq__11107_11315,chunk__11108_11316,count__11109_11317,i__11110_11318,map__11314_11489,map__11314_11490__$1,gline_11491,gcol_11492,name_11493,seq__11307_11483__$1,temp__5753__auto___11482__$2,vec__11304_11466,column_11467,column_info_11468,seq__11267_11460__$1,temp__5753__auto___11459__$1,vec__11264_11416,line_11417,columns_11418,seq__11107_11410__$1,temp__5753__auto___11409,inverted))
,cljs.core.sorted_map()));


var G__11494 = cljs.core.next(seq__11307_11483__$1);
var G__11495 = null;
var G__11496 = (0);
var G__11497 = (0);
seq__11307_11469 = G__11494;
chunk__11308_11470 = G__11495;
count__11309_11471 = G__11496;
i__11310_11472 = G__11497;
continue;
}
} else {
}
}
break;
}


var G__11498 = cljs.core.next(seq__11267_11460__$1);
var G__11499 = null;
var G__11500 = (0);
var G__11501 = (0);
seq__11267_11419 = G__11498;
chunk__11268_11420 = G__11499;
count__11269_11421 = G__11500;
i__11270_11422 = G__11501;
continue;
}
} else {
}
}
break;
}


var G__11502 = cljs.core.next(seq__11107_11410__$1);
var G__11503 = null;
var G__11504 = (0);
var G__11505 = (0);
seq__11107_11315 = G__11502;
chunk__11108_11316 = G__11503;
count__11109_11317 = G__11504;
i__11110_11318 = G__11505;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
