// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43421(s__43422){
return (new cljs.core.LazySeq(null,(function (){
var s__43422__$1 = s__43422;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43422__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43427 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43427,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43427,(1),null);
var iterys__4607__auto__ = ((function (s__43422__$1,vec__43427,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__43421_$_iter__43423(s__43424){
return (new cljs.core.LazySeq(null,((function (s__43422__$1,vec__43427,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__43424__$1 = s__43424;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43424__$1);
if(temp__5753__auto____$1){
var s__43424__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43424__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43424__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43426 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43425 = (0);
while(true){
if((i__43425 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43425);
cljs.core.chunk_append(b__43426,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__43479 = (i__43425 + (1));
i__43425 = G__43479;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43426),tailrecursion$priority_map$iter__43421_$_iter__43423(cljs.core.chunk_rest(s__43424__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43426),null);
}
} else {
var item = cljs.core.first(s__43424__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__43421_$_iter__43423(cljs.core.rest(s__43424__$2)));
}
} else {
return null;
}
break;
}
});})(s__43422__$1,vec__43427,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__43422__$1,vec__43427,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43421(cljs.core.rest(s__43422__$1)));
} else {
var G__43480 = cljs.core.rest(s__43422__$1);
s__43422__$1 = G__43480;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43430(s__43431){
return (new cljs.core.LazySeq(null,(function (){
var s__43431__$1 = s__43431;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43431__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43436 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43436,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43436,(1),null);
var iterys__4607__auto__ = ((function (s__43431__$1,vec__43436,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__43430_$_iter__43432(s__43433){
return (new cljs.core.LazySeq(null,((function (s__43431__$1,vec__43436,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__43433__$1 = s__43433;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43433__$1);
if(temp__5753__auto____$1){
var s__43433__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43433__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43433__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43435 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43434 = (0);
while(true){
if((i__43434 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43434);
cljs.core.chunk_append(b__43435,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__43481 = (i__43434 + (1));
i__43434 = G__43481;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43435),tailrecursion$priority_map$iter__43430_$_iter__43432(cljs.core.chunk_rest(s__43433__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43435),null);
}
} else {
var item = cljs.core.first(s__43433__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__43430_$_iter__43432(cljs.core.rest(s__43433__$2)));
}
} else {
return null;
}
break;
}
});})(s__43431__$1,vec__43436,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__43431__$1,vec__43436,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43430(cljs.core.rest(s__43431__$1)));
} else {
var G__43482 = cljs.core.rest(s__43431__$1);
s__43431__$1 = G__43482;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__43439 = item;
var G__43440 = cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found;
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__43439,G__43440) : self__.item__GT_priority.call(null,G__43439,G__43440));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43441(s__43442){
return (new cljs.core.LazySeq(null,(function (){
var s__43442__$1 = s__43442;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43442__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43447 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43447,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43447,(1),null);
var iterys__4607__auto__ = ((function (s__43442__$1,vec__43447,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__43441_$_iter__43443(s__43444){
return (new cljs.core.LazySeq(null,((function (s__43442__$1,vec__43447,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__43444__$1 = s__43444;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43444__$1);
if(temp__5753__auto____$1){
var s__43444__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43444__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43444__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43446 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43445 = (0);
while(true){
if((i__43445 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43445);
cljs.core.chunk_append(b__43446,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__43483 = (i__43445 + (1));
i__43445 = G__43483;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43446),tailrecursion$priority_map$iter__43441_$_iter__43443(cljs.core.chunk_rest(s__43444__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43446),null);
}
} else {
var item = cljs.core.first(s__43444__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__43441_$_iter__43443(cljs.core.rest(s__43444__$2)));
}
} else {
return null;
}
break;
}
});})(s__43442__$1,vec__43447,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__43442__$1,vec__43447,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43441(cljs.core.rest(s__43442__$1)));
} else {
var G__43484 = cljs.core.rest(s__43442__$1);
s__43442__$1 = G__43484;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43450(s__43451){
return (new cljs.core.LazySeq(null,(function (){
var s__43451__$1 = s__43451;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43451__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43456 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43456,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43456,(1),null);
var iterys__4607__auto__ = ((function (s__43451__$1,vec__43456,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__43450_$_iter__43452(s__43453){
return (new cljs.core.LazySeq(null,((function (s__43451__$1,vec__43456,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__43453__$1 = s__43453;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43453__$1);
if(temp__5753__auto____$1){
var s__43453__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43453__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43453__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43455 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43454 = (0);
while(true){
if((i__43454 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43454);
cljs.core.chunk_append(b__43455,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__43485 = (i__43454 + (1));
i__43454 = G__43485;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43455),tailrecursion$priority_map$iter__43450_$_iter__43452(cljs.core.chunk_rest(s__43453__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43455),null);
}
} else {
var item = cljs.core.first(s__43453__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__43450_$_iter__43452(cljs.core.rest(s__43453__$2)));
}
} else {
return null;
}
break;
}
});})(s__43451__$1,vec__43456,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__43451__$1,vec__43456,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43450(cljs.core.rest(s__43451__$1)));
} else {
var G__43486 = cljs.core.rest(s__43451__$1);
s__43451__$1 = G__43486;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__43487 = null;
var G__43487__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__43487__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__43487 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__43487__2.call(this,self__,item);
case 3:
return G__43487__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__43487.cljs$core$IFn$_invoke$arity$2 = G__43487__2;
G__43487.cljs$core$IFn$_invoke$arity$3 = G__43487__3;
return G__43487;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args43420){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args43420)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__43459 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__43459.cljs$core$IFn$_invoke$arity$1 ? fexpr__43459.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__43459.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43460(s__43461){
return (new cljs.core.LazySeq(null,(function (){
var s__43461__$1 = s__43461;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43461__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43466 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43466,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43466,(1),null);
var iterys__4607__auto__ = ((function (s__43461__$1,vec__43466,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__43460_$_iter__43462(s__43463){
return (new cljs.core.LazySeq(null,((function (s__43461__$1,vec__43466,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__43463__$1 = s__43463;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43463__$1);
if(temp__5753__auto____$1){
var s__43463__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43463__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43463__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43465 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43464 = (0);
while(true){
if((i__43464 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43464);
cljs.core.chunk_append(b__43465,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__43488 = (i__43464 + (1));
i__43464 = G__43488;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43465),tailrecursion$priority_map$iter__43460_$_iter__43462(cljs.core.chunk_rest(s__43463__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43465),null);
}
} else {
var item = cljs.core.first(s__43463__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__43460_$_iter__43462(cljs.core.rest(s__43463__$2)));
}
} else {
return null;
}
break;
}
});})(s__43461__$1,vec__43466,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__43461__$1,vec__43466,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43460(cljs.core.rest(s__43461__$1)));
} else {
var G__43489 = cljs.core.rest(s__43461__$1);
s__43461__$1 = G__43489;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43469(s__43470){
return (new cljs.core.LazySeq(null,(function (){
var s__43470__$1 = s__43470;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43470__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43475 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43475,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43475,(1),null);
var iterys__4607__auto__ = ((function (s__43470__$1,vec__43475,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__43469_$_iter__43471(s__43472){
return (new cljs.core.LazySeq(null,((function (s__43470__$1,vec__43475,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__43472__$1 = s__43472;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43472__$1);
if(temp__5753__auto____$1){
var s__43472__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43472__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43472__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43474 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43473 = (0);
while(true){
if((i__43473 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43473);
cljs.core.chunk_append(b__43474,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__43490 = (i__43473 + (1));
i__43473 = G__43490;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43474),tailrecursion$priority_map$iter__43469_$_iter__43471(cljs.core.chunk_rest(s__43472__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43474),null);
}
} else {
var item = cljs.core.first(s__43472__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__43469_$_iter__43471(cljs.core.rest(s__43472__$2)));
}
} else {
return null;
}
break;
}
});})(s__43470__$1,vec__43475,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__43470__$1,vec__43475,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43469(cljs.core.rest(s__43470__$1)));
} else {
var G__43491 = cljs.core.rest(s__43470__$1);
s__43470__$1 = G__43491;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__43478 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__43478) : self__.keyfn.call(null,G__43478));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$priority_DASH__GT_set_DASH_of_DASH_items,cljs.core.cst$sym$item_DASH__GT_priority,cljs.core.cst$sym$meta,cljs.core.cst$sym$keyfn,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__43493 = arguments.length;
switch (G__43493) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4824__auto__ = [];
var len__4818__auto___43496 = arguments.length;
var i__4819__auto___43497 = (0);
while(true){
if((i__4819__auto___43497 < len__4818__auto___43496)){
args__4824__auto__.push((arguments[i__4819__auto___43497]));

var G__43498 = (i__4819__auto___43497 + (1));
i__4819__auto___43497 = G__43498;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__43499 = cljs.core.nnext(in$);
var G__43500 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43499;
out = G__43500;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq43495){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43495));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4824__auto__ = [];
var len__4818__auto___43503 = arguments.length;
var i__4819__auto___43504 = (0);
while(true){
if((i__4819__auto___43504 < len__4818__auto___43503)){
args__4824__auto__.push((arguments[i__4819__auto___43504]));

var G__43505 = (i__4819__auto___43504 + (1));
i__4819__auto___43504 = G__43505;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__43506 = cljs.core.nnext(in$);
var G__43507 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43506;
out = G__43507;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq43501){
var G__43502 = cljs.core.first(seq43501);
var seq43501__$1 = cljs.core.next(seq43501);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43502,seq43501__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4824__auto__ = [];
var len__4818__auto___43510 = arguments.length;
var i__4819__auto___43511 = (0);
while(true){
if((i__4819__auto___43511 < len__4818__auto___43510)){
args__4824__auto__.push((arguments[i__4819__auto___43511]));

var G__43512 = (i__4819__auto___43511 + (1));
i__4819__auto___43511 = G__43512;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__43513 = cljs.core.nnext(in$);
var G__43514 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43513;
out = G__43514;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq43508){
var G__43509 = cljs.core.first(seq43508);
var seq43508__$1 = cljs.core.next(seq43508);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43509,seq43508__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4824__auto__ = [];
var len__4818__auto___43518 = arguments.length;
var i__4819__auto___43519 = (0);
while(true){
if((i__4819__auto___43519 < len__4818__auto___43518)){
args__4824__auto__.push((arguments[i__4819__auto___43519]));

var G__43520 = (i__4819__auto___43519 + (1));
i__4819__auto___43519 = G__43520;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__43521 = cljs.core.nnext(in$);
var G__43522 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43521;
out = G__43522;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq43515){
var G__43516 = cljs.core.first(seq43515);
var seq43515__$1 = cljs.core.next(seq43515);
var G__43517 = cljs.core.first(seq43515__$1);
var seq43515__$2 = cljs.core.next(seq43515__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43516,G__43517,seq43515__$2);
}));

