// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32943){
var state_val_32944 = (state_32943[(1)]);
if((state_val_32944 === (7))){
var inst_32932 = (state_32943[(7)]);
var inst_32934 = fluree.db.storage.core.serde(conn);
var inst_32935 = fluree.db.serde.protocol._deserialize_block(inst_32934,inst_32932);
var state_32943__$1 = state_32943;
var statearr_32945_32964 = state_32943__$1;
(statearr_32945_32964[(2)] = inst_32935);

(statearr_32945_32964[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32944 === (1))){
var state_32943__$1 = state_32943;
var statearr_32946_32965 = state_32943__$1;
(statearr_32946_32965[(2)] = null);

(statearr_32946_32965[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32944 === (4))){
var inst_32922 = (state_32943[(2)]);
var state_32943__$1 = state_32943;
var statearr_32947_32966 = state_32943__$1;
(statearr_32947_32966[(2)] = inst_32922);

(statearr_32947_32966[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32944 === (6))){
var inst_32932 = (state_32943[(7)]);
var inst_32931 = (state_32943[(2)]);
var inst_32932__$1 = fluree.db.util.async.throw_err(inst_32931);
var state_32943__$1 = (function (){var statearr_32948 = state_32943;
(statearr_32948[(7)] = inst_32932__$1);

return statearr_32948;
})();
if(cljs.core.truth_(inst_32932__$1)){
var statearr_32949_32967 = state_32943__$1;
(statearr_32949_32967[(1)] = (7));

} else {
var statearr_32950_32968 = state_32943__$1;
(statearr_32950_32968[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32944 === (3))){
var inst_32941 = (state_32943[(2)]);
var state_32943__$1 = state_32943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32943__$1,inst_32941);
} else {
if((state_val_32944 === (2))){
var _ = (function (){var statearr_32952 = state_32943;
(statearr_32952[(4)] = cljs.core.cons((5),(state_32943[(4)])));

return statearr_32952;
})();
var inst_32928 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_32929 = fluree.db.storage.core.storage_read(conn,inst_32928);
var state_32943__$1 = state_32943;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32943__$1,(6),inst_32929);
} else {
if((state_val_32944 === (9))){
var inst_32938 = (state_32943[(2)]);
var _ = (function (){var statearr_32953 = state_32943;
(statearr_32953[(4)] = cljs.core.rest((state_32943[(4)])));

return statearr_32953;
})();
var state_32943__$1 = state_32943;
var statearr_32954_32969 = state_32943__$1;
(statearr_32954_32969[(2)] = inst_32938);

(statearr_32954_32969[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32944 === (5))){
var _ = (function (){var statearr_32955 = state_32943;
(statearr_32955[(4)] = cljs.core.rest((state_32943[(4)])));

return statearr_32955;
})();
var state_32943__$1 = state_32943;
var ex32951 = (state_32943__$1[(2)]);
var statearr_32956_32970 = state_32943__$1;
(statearr_32956_32970[(5)] = ex32951);


if((ex32951 instanceof Error)){
var statearr_32957_32971 = state_32943__$1;
(statearr_32957_32971[(1)] = (4));

(statearr_32957_32971[(5)] = null);

} else {
throw ex32951;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32944 === (8))){
var state_32943__$1 = state_32943;
var statearr_32958_32972 = state_32943__$1;
(statearr_32958_32972[(2)] = null);

(statearr_32958_32972[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__16395__auto____0 = (function (){
var statearr_32959 = [null,null,null,null,null,null,null,null];
(statearr_32959[(0)] = fluree$db$storage$core$read_block_$_state_machine__16395__auto__);

(statearr_32959[(1)] = (1));

return statearr_32959;
});
var fluree$db$storage$core$read_block_$_state_machine__16395__auto____1 = (function (state_32943){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32943);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32960){var ex__16398__auto__ = e32960;
var statearr_32961_32973 = state_32943;
(statearr_32961_32973[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32943[(4)]))){
var statearr_32962_32974 = state_32943;
(statearr_32962_32974[(1)] = cljs.core.first((state_32943[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32975 = state_32943;
state_32943 = G__32975;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__16395__auto__ = function(state_32943){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__16395__auto____1.call(this,state_32943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__16395__auto____0;
fluree$db$storage$core$read_block_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__16395__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32963 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32963[(6)] = c__16469__auto__);

return statearr_32963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32998){
var state_val_32999 = (state_32998[(1)]);
if((state_val_32999 === (7))){
var inst_32987 = (state_32998[(7)]);
var inst_32989 = fluree.db.storage.core.serde(conn);
var inst_32990 = fluree.db.serde.protocol._deserialize_block(inst_32989,inst_32987);
var state_32998__$1 = state_32998;
var statearr_33000_33019 = state_32998__$1;
(statearr_33000_33019[(2)] = inst_32990);

(statearr_33000_33019[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32999 === (1))){
var state_32998__$1 = state_32998;
var statearr_33001_33020 = state_32998__$1;
(statearr_33001_33020[(2)] = null);

(statearr_33001_33020[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32999 === (4))){
var inst_32976 = (state_32998[(2)]);
var state_32998__$1 = state_32998;
var statearr_33002_33021 = state_32998__$1;
(statearr_33002_33021[(2)] = inst_32976);

(statearr_33002_33021[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32999 === (6))){
var inst_32987 = (state_32998[(7)]);
var inst_32986 = (state_32998[(2)]);
var inst_32987__$1 = fluree.db.util.async.throw_err(inst_32986);
var state_32998__$1 = (function (){var statearr_33003 = state_32998;
(statearr_33003[(7)] = inst_32987__$1);

return statearr_33003;
})();
if(cljs.core.truth_(inst_32987__$1)){
var statearr_33004_33022 = state_32998__$1;
(statearr_33004_33022[(1)] = (7));

} else {
var statearr_33005_33023 = state_32998__$1;
(statearr_33005_33023[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32999 === (3))){
var inst_32996 = (state_32998[(2)]);
var state_32998__$1 = state_32998;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32998__$1,inst_32996);
} else {
if((state_val_32999 === (2))){
var _ = (function (){var statearr_33007 = state_32998;
(statearr_33007[(4)] = cljs.core.cons((5),(state_32998[(4)])));

return statearr_33007;
})();
var inst_32982 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_32983 = [inst_32982,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_32984 = fluree.db.storage.core.storage_read(conn,inst_32983);
var state_32998__$1 = state_32998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32998__$1,(6),inst_32984);
} else {
if((state_val_32999 === (9))){
var inst_32993 = (state_32998[(2)]);
var _ = (function (){var statearr_33008 = state_32998;
(statearr_33008[(4)] = cljs.core.rest((state_32998[(4)])));

return statearr_33008;
})();
var state_32998__$1 = state_32998;
var statearr_33009_33024 = state_32998__$1;
(statearr_33009_33024[(2)] = inst_32993);

(statearr_33009_33024[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32999 === (5))){
var _ = (function (){var statearr_33010 = state_32998;
(statearr_33010[(4)] = cljs.core.rest((state_32998[(4)])));

return statearr_33010;
})();
var state_32998__$1 = state_32998;
var ex33006 = (state_32998__$1[(2)]);
var statearr_33011_33025 = state_32998__$1;
(statearr_33011_33025[(5)] = ex33006);


if((ex33006 instanceof Error)){
var statearr_33012_33026 = state_32998__$1;
(statearr_33012_33026[(1)] = (4));

(statearr_33012_33026[(5)] = null);

} else {
throw ex33006;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32999 === (8))){
var state_32998__$1 = state_32998;
var statearr_33013_33027 = state_32998__$1;
(statearr_33013_33027[(2)] = null);

(statearr_33013_33027[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__16395__auto____0 = (function (){
var statearr_33014 = [null,null,null,null,null,null,null,null];
(statearr_33014[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__16395__auto__);

(statearr_33014[(1)] = (1));

return statearr_33014;
});
var fluree$db$storage$core$read_block_version_$_state_machine__16395__auto____1 = (function (state_32998){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32998);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33015){var ex__16398__auto__ = e33015;
var statearr_33016_33028 = state_32998;
(statearr_33016_33028[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32998[(4)]))){
var statearr_33017_33029 = state_32998;
(statearr_33017_33029[(1)] = cljs.core.first((state_32998[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33030 = state_32998;
state_32998 = G__33030;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__16395__auto__ = function(state_32998){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__16395__auto____1.call(this,state_32998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__16395__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__16395__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33018 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33018[(6)] = c__16469__auto__);

return statearr_33018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33054){
var state_val_33055 = (state_33054[(1)]);
if((state_val_33055 === (1))){
var state_33054__$1 = state_33054;
var statearr_33056_33070 = state_33054__$1;
(statearr_33056_33070[(2)] = null);

(statearr_33056_33070[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33055 === (2))){
var _ = (function (){var statearr_33057 = state_33054;
(statearr_33057[(4)] = cljs.core.cons((5),(state_33054[(4)])));

return statearr_33057;
})();
var inst_33037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33038 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_33039 = (new cljs.core.PersistentVector(null,3,(5),inst_33037,inst_33038,null));
var inst_33040 = cljs.core.select_keys(block_data,inst_33039);
var inst_33041 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_33040);
var inst_33042 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_33041);
var inst_33043 = [inst_33042,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_33044 = fluree.db.storage.core.serde(conn);
var inst_33045 = fluree.db.serde.protocol._serialize_block(inst_33044,inst_33040);
var inst_33046 = fluree.db.storage.core.storage_write(conn,inst_33043,inst_33045);
var state_33054__$1 = state_33054;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33054__$1,(6),inst_33046);
} else {
if((state_val_33055 === (3))){
var inst_33052 = (state_33054[(2)]);
var state_33054__$1 = state_33054;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33054__$1,inst_33052);
} else {
if((state_val_33055 === (4))){
var inst_33031 = (state_33054[(2)]);
var state_33054__$1 = state_33054;
var statearr_33059_33071 = state_33054__$1;
(statearr_33059_33071[(2)] = inst_33031);

(statearr_33059_33071[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33055 === (5))){
var _ = (function (){var statearr_33060 = state_33054;
(statearr_33060[(4)] = cljs.core.rest((state_33054[(4)])));

return statearr_33060;
})();
var state_33054__$1 = state_33054;
var ex33058 = (state_33054__$1[(2)]);
var statearr_33061_33072 = state_33054__$1;
(statearr_33061_33072[(5)] = ex33058);


if((ex33058 instanceof Error)){
var statearr_33062_33073 = state_33054__$1;
(statearr_33062_33073[(1)] = (4));

(statearr_33062_33073[(5)] = null);

} else {
throw ex33058;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33055 === (6))){
var inst_33048 = (state_33054[(2)]);
var inst_33049 = fluree.db.util.async.throw_err(inst_33048);
var _ = (function (){var statearr_33063 = state_33054;
(statearr_33063[(4)] = cljs.core.rest((state_33054[(4)])));

return statearr_33063;
})();
var state_33054__$1 = state_33054;
var statearr_33064_33074 = state_33054__$1;
(statearr_33064_33074[(2)] = inst_33049);

(statearr_33064_33074[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__16395__auto____0 = (function (){
var statearr_33065 = [null,null,null,null,null,null,null];
(statearr_33065[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__16395__auto__);

(statearr_33065[(1)] = (1));

return statearr_33065;
});
var fluree$db$storage$core$write_block_version_$_state_machine__16395__auto____1 = (function (state_33054){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33054);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33066){var ex__16398__auto__ = e33066;
var statearr_33067_33075 = state_33054;
(statearr_33067_33075[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33054[(4)]))){
var statearr_33068_33076 = state_33054;
(statearr_33068_33076[(1)] = cljs.core.first((state_33054[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33077 = state_33054;
state_33054 = G__33077;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__16395__auto__ = function(state_33054){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__16395__auto____1.call(this,state_33054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__16395__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__16395__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33069 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33069[(6)] = c__16469__auto__);

return statearr_33069;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33100){
var state_val_33101 = (state_33100[(1)]);
if((state_val_33101 === (1))){
var state_33100__$1 = state_33100;
var statearr_33102_33116 = state_33100__$1;
(statearr_33102_33116[(2)] = null);

(statearr_33102_33116[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33101 === (2))){
var _ = (function (){var statearr_33103 = state_33100;
(statearr_33103[(4)] = cljs.core.cons((5),(state_33100[(4)])));

return statearr_33103;
})();
var inst_33084 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33085 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_33086 = (new cljs.core.PersistentVector(null,3,(5),inst_33084,inst_33085,null));
var inst_33087 = cljs.core.select_keys(block_data,inst_33086);
var inst_33088 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_33087);
var inst_33089 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_33088);
var inst_33090 = fluree.db.storage.core.serde(conn);
var inst_33091 = fluree.db.serde.protocol._serialize_block(inst_33090,inst_33087);
var inst_33092 = fluree.db.storage.core.storage_write(conn,inst_33089,inst_33091);
var state_33100__$1 = state_33100;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33100__$1,(6),inst_33092);
} else {
if((state_val_33101 === (3))){
var inst_33098 = (state_33100[(2)]);
var state_33100__$1 = state_33100;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33100__$1,inst_33098);
} else {
if((state_val_33101 === (4))){
var inst_33078 = (state_33100[(2)]);
var state_33100__$1 = state_33100;
var statearr_33105_33117 = state_33100__$1;
(statearr_33105_33117[(2)] = inst_33078);

(statearr_33105_33117[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33101 === (5))){
var _ = (function (){var statearr_33106 = state_33100;
(statearr_33106[(4)] = cljs.core.rest((state_33100[(4)])));

return statearr_33106;
})();
var state_33100__$1 = state_33100;
var ex33104 = (state_33100__$1[(2)]);
var statearr_33107_33118 = state_33100__$1;
(statearr_33107_33118[(5)] = ex33104);


if((ex33104 instanceof Error)){
var statearr_33108_33119 = state_33100__$1;
(statearr_33108_33119[(1)] = (4));

(statearr_33108_33119[(5)] = null);

} else {
throw ex33104;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33101 === (6))){
var inst_33094 = (state_33100[(2)]);
var inst_33095 = fluree.db.util.async.throw_err(inst_33094);
var _ = (function (){var statearr_33109 = state_33100;
(statearr_33109[(4)] = cljs.core.rest((state_33100[(4)])));

return statearr_33109;
})();
var state_33100__$1 = state_33100;
var statearr_33110_33120 = state_33100__$1;
(statearr_33110_33120[(2)] = inst_33095);

(statearr_33110_33120[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__16395__auto____0 = (function (){
var statearr_33111 = [null,null,null,null,null,null,null];
(statearr_33111[(0)] = fluree$db$storage$core$write_block_$_state_machine__16395__auto__);

(statearr_33111[(1)] = (1));

return statearr_33111;
});
var fluree$db$storage$core$write_block_$_state_machine__16395__auto____1 = (function (state_33100){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33100);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33112){var ex__16398__auto__ = e33112;
var statearr_33113_33121 = state_33100;
(statearr_33113_33121[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33100[(4)]))){
var statearr_33114_33122 = state_33100;
(statearr_33114_33122[(1)] = cljs.core.first((state_33100[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33123 = state_33100;
state_33100 = G__33123;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__16395__auto__ = function(state_33100){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__16395__auto____1.call(this,state_33100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__16395__auto____0;
fluree$db$storage$core$write_block_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__16395__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33115 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33115[(6)] = c__16469__auto__);

return statearr_33115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33143){
var state_val_33144 = (state_33143[(1)]);
if((state_val_33144 === (1))){
var state_33143__$1 = state_33143;
var statearr_33145_33159 = state_33143__$1;
(statearr_33145_33159[(2)] = null);

(statearr_33145_33159[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33144 === (2))){
var _ = (function (){var statearr_33146 = state_33143;
(statearr_33146[(4)] = cljs.core.cons((5),(state_33143[(4)])));

return statearr_33146;
})();
var inst_33130 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_33131 = [history,next_his_key];
var inst_33132 = cljs.core.PersistentHashMap.fromArrays(inst_33130,inst_33131);
var inst_33133 = fluree.db.storage.core.serde(conn);
var inst_33134 = fluree.db.serde.protocol._serialize_leaf(inst_33133,inst_33132);
var inst_33135 = fluree.db.storage.core.storage_write(conn,his_key,inst_33134);
var state_33143__$1 = state_33143;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33143__$1,(6),inst_33135);
} else {
if((state_val_33144 === (3))){
var inst_33141 = (state_33143[(2)]);
var state_33143__$1 = state_33143;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33143__$1,inst_33141);
} else {
if((state_val_33144 === (4))){
var inst_33124 = (state_33143[(2)]);
var state_33143__$1 = state_33143;
var statearr_33148_33160 = state_33143__$1;
(statearr_33148_33160[(2)] = inst_33124);

(statearr_33148_33160[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33144 === (5))){
var _ = (function (){var statearr_33149 = state_33143;
(statearr_33149[(4)] = cljs.core.rest((state_33143[(4)])));

return statearr_33149;
})();
var state_33143__$1 = state_33143;
var ex33147 = (state_33143__$1[(2)]);
var statearr_33150_33161 = state_33143__$1;
(statearr_33150_33161[(5)] = ex33147);


if((ex33147 instanceof Error)){
var statearr_33151_33162 = state_33143__$1;
(statearr_33151_33162[(1)] = (4));

(statearr_33151_33162[(5)] = null);

} else {
throw ex33147;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33144 === (6))){
var inst_33137 = (state_33143[(2)]);
var inst_33138 = fluree.db.util.async.throw_err(inst_33137);
var _ = (function (){var statearr_33152 = state_33143;
(statearr_33152[(4)] = cljs.core.rest((state_33143[(4)])));

return statearr_33152;
})();
var state_33143__$1 = state_33143;
var statearr_33153_33163 = state_33143__$1;
(statearr_33153_33163[(2)] = inst_33138);

(statearr_33153_33163[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__16395__auto____0 = (function (){
var statearr_33154 = [null,null,null,null,null,null,null];
(statearr_33154[(0)] = fluree$db$storage$core$write_history_$_state_machine__16395__auto__);

(statearr_33154[(1)] = (1));

return statearr_33154;
});
var fluree$db$storage$core$write_history_$_state_machine__16395__auto____1 = (function (state_33143){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33143);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33155){var ex__16398__auto__ = e33155;
var statearr_33156_33164 = state_33143;
(statearr_33156_33164[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33143[(4)]))){
var statearr_33157_33165 = state_33143;
(statearr_33157_33165[(1)] = cljs.core.first((state_33143[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33166 = state_33143;
state_33143 = G__33166;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__16395__auto__ = function(state_33143){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__16395__auto____1.call(this,state_33143);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__16395__auto____0;
fluree$db$storage$core$write_history_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__16395__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33158 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33158[(6)] = c__16469__auto__);

return statearr_33158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33192){
var state_val_33193 = (state_33192[(1)]);
if((state_val_33193 === (1))){
var state_33192__$1 = state_33192;
var statearr_33194_33211 = state_33192__$1;
(statearr_33194_33211[(2)] = null);

(statearr_33194_33211[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33193 === (2))){
var inst_33173 = (state_33192[(7)]);
var _ = (function (){var statearr_33195 = state_33192;
(statearr_33195[(4)] = cljs.core.cons((5),(state_33192[(4)])));

return statearr_33195;
})();
var inst_33173__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_33174 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33173__$1),"-his"].join('');
var inst_33175 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_33176 = [flakes,inst_33174];
var inst_33177 = cljs.core.PersistentHashMap.fromArrays(inst_33175,inst_33176);
var inst_33178 = fluree.db.storage.core.serde(conn);
var inst_33179 = fluree.db.serde.protocol._serialize_leaf(inst_33178,inst_33177);
var inst_33180 = fluree.db.storage.core.write_history(conn,history,inst_33174,null);
var inst_33181 = fluree.db.storage.core.storage_write(conn,inst_33173__$1,inst_33179);
var state_33192__$1 = (function (){var statearr_33196 = state_33192;
(statearr_33196[(7)] = inst_33173__$1);

(statearr_33196[(8)] = inst_33181);

return statearr_33196;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33192__$1,(6),inst_33180);
} else {
if((state_val_33193 === (3))){
var inst_33190 = (state_33192[(2)]);
var state_33192__$1 = state_33192;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33192__$1,inst_33190);
} else {
if((state_val_33193 === (4))){
var inst_33167 = (state_33192[(2)]);
var state_33192__$1 = state_33192;
var statearr_33198_33212 = state_33192__$1;
(statearr_33198_33212[(2)] = inst_33167);

(statearr_33198_33212[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33193 === (5))){
var _ = (function (){var statearr_33199 = state_33192;
(statearr_33199[(4)] = cljs.core.rest((state_33192[(4)])));

return statearr_33199;
})();
var state_33192__$1 = state_33192;
var ex33197 = (state_33192__$1[(2)]);
var statearr_33200_33213 = state_33192__$1;
(statearr_33200_33213[(5)] = ex33197);


if((ex33197 instanceof Error)){
var statearr_33201_33214 = state_33192__$1;
(statearr_33201_33214[(1)] = (4));

(statearr_33201_33214[(5)] = null);

} else {
throw ex33197;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33193 === (6))){
var inst_33181 = (state_33192[(8)]);
var inst_33183 = (state_33192[(2)]);
var inst_33184 = fluree.db.util.async.throw_err(inst_33183);
var state_33192__$1 = (function (){var statearr_33202 = state_33192;
(statearr_33202[(9)] = inst_33184);

return statearr_33202;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33192__$1,(7),inst_33181);
} else {
if((state_val_33193 === (7))){
var inst_33173 = (state_33192[(7)]);
var inst_33186 = (state_33192[(2)]);
var inst_33187 = fluree.db.util.async.throw_err(inst_33186);
var _ = (function (){var statearr_33203 = state_33192;
(statearr_33203[(4)] = cljs.core.rest((state_33192[(4)])));

return statearr_33203;
})();
var state_33192__$1 = (function (){var statearr_33204 = state_33192;
(statearr_33204[(10)] = inst_33187);

return statearr_33204;
})();
var statearr_33205_33215 = state_33192__$1;
(statearr_33205_33215[(2)] = inst_33173);

(statearr_33205_33215[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__16395__auto____0 = (function (){
var statearr_33206 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33206[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__16395__auto__);

(statearr_33206[(1)] = (1));

return statearr_33206;
});
var fluree$db$storage$core$write_leaf_$_state_machine__16395__auto____1 = (function (state_33192){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33192);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33207){var ex__16398__auto__ = e33207;
var statearr_33208_33216 = state_33192;
(statearr_33208_33216[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33192[(4)]))){
var statearr_33209_33217 = state_33192;
(statearr_33209_33217[(1)] = cljs.core.first((state_33192[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33218 = state_33192;
state_33192 = G__33218;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__16395__auto__ = function(state_33192){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__16395__auto____1.call(this,state_33192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__16395__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__16395__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33210 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33210[(6)] = c__16469__auto__);

return statearr_33210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33235){
var state_val_33236 = (state_33235[(1)]);
if((state_val_33236 === (1))){
var state_33235__$1 = state_33235;
var statearr_33237_33252 = state_33235__$1;
(statearr_33237_33252[(2)] = null);

(statearr_33237_33252[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33236 === (2))){
var _ = (function (){var statearr_33238 = state_33235;
(statearr_33238[(4)] = cljs.core.cons((5),(state_33235[(4)])));

return statearr_33238;
})();
var inst_33225 = fluree.db.storage.core.serde(conn);
var inst_33226 = fluree.db.serde.protocol._serialize_branch(inst_33225,data);
var inst_33227 = fluree.db.storage.core.storage_write(conn,key,inst_33226);
var state_33235__$1 = state_33235;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33235__$1,(6),inst_33227);
} else {
if((state_val_33236 === (3))){
var inst_33233 = (state_33235[(2)]);
var state_33235__$1 = state_33235;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33235__$1,inst_33233);
} else {
if((state_val_33236 === (4))){
var inst_33219 = (state_33235[(2)]);
var state_33235__$1 = state_33235;
var statearr_33240_33253 = state_33235__$1;
(statearr_33240_33253[(2)] = inst_33219);

(statearr_33240_33253[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33236 === (5))){
var _ = (function (){var statearr_33241 = state_33235;
(statearr_33241[(4)] = cljs.core.rest((state_33235[(4)])));

return statearr_33241;
})();
var state_33235__$1 = state_33235;
var ex33239 = (state_33235__$1[(2)]);
var statearr_33242_33254 = state_33235__$1;
(statearr_33242_33254[(5)] = ex33239);


if((ex33239 instanceof Error)){
var statearr_33243_33255 = state_33235__$1;
(statearr_33243_33255[(1)] = (4));

(statearr_33243_33255[(5)] = null);

} else {
throw ex33239;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33236 === (6))){
var inst_33229 = (state_33235[(2)]);
var inst_33230 = fluree.db.util.async.throw_err(inst_33229);
var _ = (function (){var statearr_33244 = state_33235;
(statearr_33244[(4)] = cljs.core.rest((state_33235[(4)])));

return statearr_33244;
})();
var state_33235__$1 = (function (){var statearr_33245 = state_33235;
(statearr_33245[(7)] = inst_33230);

return statearr_33245;
})();
var statearr_33246_33256 = state_33235__$1;
(statearr_33246_33256[(2)] = key);

(statearr_33246_33256[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto____0 = (function (){
var statearr_33247 = [null,null,null,null,null,null,null,null];
(statearr_33247[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto__);

(statearr_33247[(1)] = (1));

return statearr_33247;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto____1 = (function (state_33235){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33235);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33248){var ex__16398__auto__ = e33248;
var statearr_33249_33257 = state_33235;
(statearr_33249_33257[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33235[(4)]))){
var statearr_33250_33258 = state_33235;
(statearr_33250_33258[(1)] = cljs.core.first((state_33235[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33259 = state_33235;
state_33235 = G__33259;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto__ = function(state_33235){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto____1.call(this,state_33235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33251 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33251[(6)] = c__16469__auto__);

return statearr_33251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__33260_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__33260_SHARP_));
}),children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__33261){
var map__33262 = p__33261;
var map__33262__$1 = cljs.core.__destructure_map(map__33262);
var progress = map__33262__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33262__$1,cljs.core.cst$kw$garbage);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33290){
var state_val_33291 = (state_33290[(1)]);
if((state_val_33291 === (1))){
var state_33290__$1 = state_33290;
var statearr_33292_33308 = state_33290__$1;
(statearr_33292_33308[(2)] = null);

(statearr_33292_33308[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33291 === (2))){
var inst_33276 = (state_33290[(7)]);
var _ = (function (){var statearr_33293 = state_33290;
(statearr_33293[(4)] = cljs.core.cons((5),(state_33290[(4)])));

return statearr_33293;
})();
var inst_33270 = db;
var inst_33271 = cljs.core.__destructure_map(inst_33270);
var inst_33272 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33271,cljs.core.cst$kw$conn);
var inst_33273 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33271,cljs.core.cst$kw$network);
var inst_33274 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33271,cljs.core.cst$kw$dbid);
var inst_33275 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33271,cljs.core.cst$kw$block);
var inst_33276__$1 = fluree.db.storage.core.ledger_garbage_key(inst_33273,inst_33274,inst_33275);
var inst_33277 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_33278 = [inst_33274,inst_33275,garbage];
var inst_33279 = cljs.core.PersistentHashMap.fromArrays(inst_33277,inst_33278);
var inst_33280 = fluree.db.storage.core.serde(inst_33272);
var inst_33281 = fluree.db.serde.protocol._serialize_garbage(inst_33280,inst_33279);
var inst_33282 = fluree.db.storage.core.storage_write(inst_33272,inst_33276__$1,inst_33281);
var state_33290__$1 = (function (){var statearr_33294 = state_33290;
(statearr_33294[(7)] = inst_33276__$1);

return statearr_33294;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33290__$1,(6),inst_33282);
} else {
if((state_val_33291 === (3))){
var inst_33288 = (state_33290[(2)]);
var state_33290__$1 = state_33290;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33290__$1,inst_33288);
} else {
if((state_val_33291 === (4))){
var inst_33263 = (state_33290[(2)]);
var state_33290__$1 = state_33290;
var statearr_33296_33309 = state_33290__$1;
(statearr_33296_33309[(2)] = inst_33263);

(statearr_33296_33309[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33291 === (5))){
var _ = (function (){var statearr_33297 = state_33290;
(statearr_33297[(4)] = cljs.core.rest((state_33290[(4)])));

return statearr_33297;
})();
var state_33290__$1 = state_33290;
var ex33295 = (state_33290__$1[(2)]);
var statearr_33298_33310 = state_33290__$1;
(statearr_33298_33310[(5)] = ex33295);


if((ex33295 instanceof Error)){
var statearr_33299_33311 = state_33290__$1;
(statearr_33299_33311[(1)] = (4));

(statearr_33299_33311[(5)] = null);

} else {
throw ex33295;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33291 === (6))){
var inst_33276 = (state_33290[(7)]);
var inst_33284 = (state_33290[(2)]);
var inst_33285 = fluree.db.util.async.throw_err(inst_33284);
var _ = (function (){var statearr_33300 = state_33290;
(statearr_33300[(4)] = cljs.core.rest((state_33290[(4)])));

return statearr_33300;
})();
var state_33290__$1 = (function (){var statearr_33301 = state_33290;
(statearr_33301[(8)] = inst_33285);

return statearr_33301;
})();
var statearr_33302_33312 = state_33290__$1;
(statearr_33302_33312[(2)] = inst_33276);

(statearr_33302_33312[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__16395__auto____0 = (function (){
var statearr_33303 = [null,null,null,null,null,null,null,null,null];
(statearr_33303[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__16395__auto__);

(statearr_33303[(1)] = (1));

return statearr_33303;
});
var fluree$db$storage$core$write_garbage_$_state_machine__16395__auto____1 = (function (state_33290){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33290);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33304){var ex__16398__auto__ = e33304;
var statearr_33305_33313 = state_33290;
(statearr_33305_33313[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33290[(4)]))){
var statearr_33306_33314 = state_33290;
(statearr_33306_33314[(1)] = cljs.core.first((state_33290[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33315 = state_33290;
state_33290 = G__33315;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__16395__auto__ = function(state_33290){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__16395__auto____1.call(this,state_33290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__16395__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__16395__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33307 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33307[(6)] = c__16469__auto__);

return statearr_33307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__33317 = arguments.length;
switch (G__33317) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33373){
var state_val_33374 = (state_33373[(1)]);
if((state_val_33374 === (7))){
var state_33373__$1 = state_33373;
var statearr_33375_33401 = state_33373__$1;
(statearr_33375_33401[(2)] = (0));

(statearr_33375_33401[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33374 === (1))){
var state_33373__$1 = state_33373;
var statearr_33376_33402 = state_33373__$1;
(statearr_33376_33402[(2)] = null);

(statearr_33376_33402[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33374 === (4))){
var inst_33318 = (state_33373[(2)]);
var state_33373__$1 = state_33373;
var statearr_33377_33403 = state_33373__$1;
(statearr_33377_33403[(2)] = inst_33318);

(statearr_33377_33403[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33374 === (6))){
var inst_33343 = (state_33373[(7)]);
var state_33373__$1 = state_33373;
var statearr_33378_33404 = state_33373__$1;
(statearr_33378_33404[(2)] = inst_33343);

(statearr_33378_33404[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33374 === (3))){
var inst_33371 = (state_33373[(2)]);
var state_33373__$1 = state_33373;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33373__$1,inst_33371);
} else {
if((state_val_33374 === (12))){
var inst_33340 = (state_33373[(8)]);
var inst_33367 = (state_33373[(2)]);
var inst_33368 = fluree.db.util.async.throw_err(inst_33367);
var _ = (function (){var statearr_33379 = state_33373;
(statearr_33379[(4)] = cljs.core.rest((state_33373[(4)])));

return statearr_33379;
})();
var state_33373__$1 = (function (){var statearr_33380 = state_33373;
(statearr_33380[(9)] = inst_33368);

return statearr_33380;
})();
var statearr_33381_33405 = state_33373__$1;
(statearr_33381_33405[(2)] = inst_33340);

(statearr_33381_33405[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33374 === (2))){
var inst_33335 = (state_33373[(10)]);
var inst_33331 = (state_33373[(11)]);
var inst_33343 = (state_33373[(7)]);
var inst_33333 = (state_33373[(12)]);
var _ = (function (){var statearr_33382 = state_33373;
(statearr_33382[(4)] = cljs.core.cons((5),(state_33373[(4)])));

return statearr_33382;
})();
var inst_33325 = db;
var inst_33326 = cljs.core.__destructure_map(inst_33325);
var inst_33327 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$network);
var inst_33328 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$t);
var inst_33329 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$fork);
var inst_33330 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$spot);
var inst_33331__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$stats);
var inst_33332 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$conn);
var inst_33333__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$block);
var inst_33334 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$psot);
var inst_33335__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$dbid);
var inst_33336 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$ecount);
var inst_33337 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$opst);
var inst_33338 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$fork_DASH_block);
var inst_33339 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33326,cljs.core.cst$kw$post);
var inst_33340 = fluree.db.storage.core.ledger_root_key(inst_33327,inst_33335__$1,inst_33333__$1);
var inst_33341 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_33342 = fluree.db.storage.core.child_data(inst_33334);
var inst_33343__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_33331__$1);
var state_33373__$1 = (function (){var statearr_33383 = state_33373;
(statearr_33383[(13)] = inst_33328);

(statearr_33383[(14)] = inst_33337);

(statearr_33383[(15)] = inst_33342);

(statearr_33383[(10)] = inst_33335__$1);

(statearr_33383[(16)] = inst_33336);

(statearr_33383[(17)] = inst_33332);

(statearr_33383[(18)] = inst_33330);

(statearr_33383[(19)] = inst_33341);

(statearr_33383[(20)] = inst_33338);

(statearr_33383[(8)] = inst_33340);

(statearr_33383[(11)] = inst_33331__$1);

(statearr_33383[(21)] = inst_33339);

(statearr_33383[(22)] = inst_33329);

(statearr_33383[(7)] = inst_33343__$1);

(statearr_33383[(12)] = inst_33333__$1);

return statearr_33383;
})();
if(cljs.core.truth_(inst_33343__$1)){
var statearr_33384_33406 = state_33373__$1;
(statearr_33384_33406[(1)] = (6));

} else {
var statearr_33385_33407 = state_33373__$1;
(statearr_33385_33407[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33374 === (11))){
var inst_33328 = (state_33373[(13)]);
var inst_33337 = (state_33373[(14)]);
var inst_33342 = (state_33373[(15)]);
var inst_33335 = (state_33373[(10)]);
var inst_33347 = (state_33373[(23)]);
var inst_33332 = (state_33373[(17)]);
var inst_33330 = (state_33373[(18)]);
var inst_33341 = (state_33373[(19)]);
var inst_33338 = (state_33373[(20)]);
var inst_33340 = (state_33373[(8)]);
var inst_33331 = (state_33373[(11)]);
var inst_33339 = (state_33373[(21)]);
var inst_33329 = (state_33373[(22)]);
var inst_33333 = (state_33373[(12)]);
var inst_33352 = (state_33373[(2)]);
var inst_33353 = fluree.db.storage.core.child_data(inst_33337);
var inst_33354 = fluree.db.storage.core.child_data(inst_33339);
var inst_33355 = fluree.db.util.core.current_time_millis();
var inst_33356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33357 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_33358 = (new cljs.core.PersistentVector(null,2,(5),inst_33356,inst_33357,null));
var inst_33359 = cljs.core.select_keys(inst_33331,inst_33358);
var inst_33360 = fluree.db.storage.core.child_data(inst_33330);
var inst_33361 = [inst_33333,inst_33342,inst_33335,inst_33347,inst_33352,inst_33353,inst_33354,inst_33328,inst_33355,inst_33329,inst_33338,inst_33359,inst_33360];
var inst_33362 = cljs.core.PersistentHashMap.fromArrays(inst_33341,inst_33361);
var inst_33363 = fluree.db.storage.core.serde(inst_33332);
var inst_33364 = fluree.db.serde.protocol._serialize_db_root(inst_33363,inst_33362);
var inst_33365 = fluree.db.storage.core.storage_write(inst_33332,inst_33340,inst_33364);
var state_33373__$1 = state_33373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33373__$1,(12),inst_33365);
} else {
if((state_val_33374 === (9))){
var inst_33348 = (state_33373[(24)]);
var state_33373__$1 = state_33373;
var statearr_33387_33408 = state_33373__$1;
(statearr_33387_33408[(2)] = inst_33348);

(statearr_33387_33408[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33374 === (5))){
var _ = (function (){var statearr_33388 = state_33373;
(statearr_33388[(4)] = cljs.core.rest((state_33373[(4)])));

return statearr_33388;
})();
var state_33373__$1 = state_33373;
var ex33386 = (state_33373__$1[(2)]);
var statearr_33389_33409 = state_33373__$1;
(statearr_33389_33409[(5)] = ex33386);


if((ex33386 instanceof Error)){
var statearr_33390_33410 = state_33373__$1;
(statearr_33390_33410[(1)] = (4));

(statearr_33390_33410[(5)] = null);

} else {
throw ex33386;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33374 === (10))){
var inst_33336 = (state_33373[(16)]);
var state_33373__$1 = state_33373;
var statearr_33391_33411 = state_33373__$1;
(statearr_33391_33411[(2)] = inst_33336);

(statearr_33391_33411[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33374 === (8))){
var inst_33348 = (state_33373[(24)]);
var inst_33347 = (state_33373[(2)]);
var inst_33348__$1 = custom_ecount;
var state_33373__$1 = (function (){var statearr_33392 = state_33373;
(statearr_33392[(23)] = inst_33347);

(statearr_33392[(24)] = inst_33348__$1);

return statearr_33392;
})();
if(cljs.core.truth_(inst_33348__$1)){
var statearr_33393_33412 = state_33373__$1;
(statearr_33393_33412[(1)] = (9));

} else {
var statearr_33394_33413 = state_33373__$1;
(statearr_33394_33413[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__16395__auto__ = null;
var fluree$db$storage$core$state_machine__16395__auto____0 = (function (){
var statearr_33395 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33395[(0)] = fluree$db$storage$core$state_machine__16395__auto__);

(statearr_33395[(1)] = (1));

return statearr_33395;
});
var fluree$db$storage$core$state_machine__16395__auto____1 = (function (state_33373){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33373);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33396){var ex__16398__auto__ = e33396;
var statearr_33397_33414 = state_33373;
(statearr_33397_33414[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33373[(4)]))){
var statearr_33398_33415 = state_33373;
(statearr_33398_33415[(1)] = cljs.core.first((state_33373[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33416 = state_33373;
state_33373 = G__33416;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__16395__auto__ = function(state_33373){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__16395__auto____1.call(this,state_33373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__16395__auto____0;
fluree$db$storage$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__16395__auto____1;
return fluree$db$storage$core$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33399 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33399[(6)] = c__16469__auto__);

return statearr_33399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___33475 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33449){
var state_val_33450 = (state_33449[(1)]);
if((state_val_33450 === (7))){
var inst_33429 = (state_33449[(7)]);
var state_33449__$1 = state_33449;
var statearr_33451_33476 = state_33449__$1;
(statearr_33451_33476[(2)] = inst_33429);

(statearr_33451_33476[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33450 === (1))){
var state_33449__$1 = state_33449;
var statearr_33452_33477 = state_33449__$1;
(statearr_33452_33477[(2)] = null);

(statearr_33452_33477[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33450 === (4))){
var inst_33417 = (state_33449[(2)]);
var inst_33418 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_33419 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33417);
var inst_33420 = cljs.core.async.close_BANG_(return_ch);
var state_33449__$1 = (function (){var statearr_33453 = state_33449;
(statearr_33453[(8)] = inst_33418);

(statearr_33453[(9)] = inst_33419);

return statearr_33453;
})();
var statearr_33454_33478 = state_33449__$1;
(statearr_33454_33478[(2)] = inst_33420);

(statearr_33454_33478[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33450 === (6))){
var inst_33429 = (state_33449[(7)]);
var inst_33428 = (state_33449[(10)]);
var inst_33428__$1 = (state_33449[(2)]);
var inst_33429__$1 = (inst_33428__$1 == null);
var state_33449__$1 = (function (){var statearr_33455 = state_33449;
(statearr_33455[(7)] = inst_33429__$1);

(statearr_33455[(10)] = inst_33428__$1);

return statearr_33455;
})();
if(cljs.core.truth_(inst_33429__$1)){
var statearr_33456_33479 = state_33449__$1;
(statearr_33456_33479[(1)] = (7));

} else {
var statearr_33457_33480 = state_33449__$1;
(statearr_33457_33480[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33450 === (3))){
var inst_33447 = (state_33449[(2)]);
var state_33449__$1 = state_33449;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33449__$1,inst_33447);
} else {
if((state_val_33450 === (12))){
var inst_33444 = (state_33449[(2)]);
var _ = (function (){var statearr_33458 = state_33449;
(statearr_33458[(4)] = cljs.core.rest((state_33449[(4)])));

return statearr_33458;
})();
var state_33449__$1 = state_33449;
var statearr_33459_33481 = state_33449__$1;
(statearr_33459_33481[(2)] = inst_33444);

(statearr_33459_33481[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33450 === (2))){
var _ = (function (){var statearr_33460 = state_33449;
(statearr_33460[(4)] = cljs.core.cons((5),(state_33449[(4)])));

return statearr_33460;
})();
var inst_33426 = fluree.db.storage.core.storage_read(conn,key);
var state_33449__$1 = state_33449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33449__$1,(6),inst_33426);
} else {
if((state_val_33450 === (11))){
var inst_33428 = (state_33449[(10)]);
var inst_33438 = fluree.db.storage.core.serde(conn);
var inst_33439 = fluree.db.serde.protocol._deserialize_leaf(inst_33438,inst_33428);
var inst_33440 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_33439);
var inst_33441 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_33440);
var inst_33442 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33441);
var state_33449__$1 = state_33449;
var statearr_33462_33482 = state_33449__$1;
(statearr_33462_33482[(2)] = inst_33442);

(statearr_33462_33482[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33450 === (9))){
var inst_33434 = (state_33449[(2)]);
var state_33449__$1 = state_33449;
if(cljs.core.truth_(inst_33434)){
var statearr_33463_33483 = state_33449__$1;
(statearr_33463_33483[(1)] = (10));

} else {
var statearr_33464_33484 = state_33449__$1;
(statearr_33464_33484[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33450 === (5))){
var _ = (function (){var statearr_33465 = state_33449;
(statearr_33465[(4)] = cljs.core.rest((state_33449[(4)])));

return statearr_33465;
})();
var state_33449__$1 = state_33449;
var ex33461 = (state_33449__$1[(2)]);
var statearr_33466_33485 = state_33449__$1;
(statearr_33466_33485[(5)] = ex33461);


var statearr_33467_33486 = state_33449__$1;
(statearr_33467_33486[(1)] = (4));

(statearr_33467_33486[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33450 === (10))){
var inst_33436 = cljs.core.async.close_BANG_(return_ch);
var state_33449__$1 = state_33449;
var statearr_33468_33487 = state_33449__$1;
(statearr_33468_33487[(2)] = inst_33436);

(statearr_33468_33487[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33450 === (8))){
var inst_33428 = (state_33449[(10)]);
var inst_33432 = (inst_33428 instanceof Error);
var state_33449__$1 = state_33449;
var statearr_33469_33488 = state_33449__$1;
(statearr_33469_33488[(2)] = inst_33432);

(statearr_33469_33488[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__16395__auto____0 = (function (){
var statearr_33470 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33470[(0)] = fluree$db$storage$core$reify_history_$_state_machine__16395__auto__);

(statearr_33470[(1)] = (1));

return statearr_33470;
});
var fluree$db$storage$core$reify_history_$_state_machine__16395__auto____1 = (function (state_33449){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33449);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33471){var ex__16398__auto__ = e33471;
var statearr_33472_33489 = state_33449;
(statearr_33472_33489[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33449[(4)]))){
var statearr_33473_33490 = state_33449;
(statearr_33473_33490[(1)] = cljs.core.first((state_33449[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33491 = state_33449;
state_33449 = G__33491;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__16395__auto__ = function(state_33449){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__16395__auto____1.call(this,state_33449);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__16395__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__16395__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33474 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33474[(6)] = c__16469__auto___33475);

return statearr_33474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__33493 = arguments.length;
switch (G__33493) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4210__auto__ = (rhs == null);
if(and__4210__auto__){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___33605 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33556){
var state_val_33557 = (state_33556[(1)]);
if((state_val_33557 === (7))){
var state_33556__$1 = state_33556;
var statearr_33558_33606 = state_33556__$1;
(statearr_33558_33606[(2)] = cljs.core.cst$kw$novelty);

(statearr_33558_33606[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (20))){
var inst_33535 = cljs.core.PersistentVector.EMPTY;
var state_33556__$1 = state_33556;
var statearr_33559_33607 = state_33556__$1;
(statearr_33559_33607[(2)] = inst_33535);

(statearr_33559_33607[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (1))){
var state_33556__$1 = state_33556;
var statearr_33560_33608 = state_33556__$1;
(statearr_33560_33608[(2)] = null);

(statearr_33560_33608[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (24))){
var state_33556__$1 = state_33556;
var statearr_33561_33609 = state_33556__$1;
(statearr_33561_33609[(2)] = null);

(statearr_33561_33609[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (4))){
var inst_33496 = (state_33556[(2)]);
var inst_33497 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_33498 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_33496);
var inst_33499 = cljs.core.async.close_BANG_(result_ch);
var state_33556__$1 = (function (){var statearr_33562 = state_33556;
(statearr_33562[(7)] = inst_33497);

(statearr_33562[(8)] = inst_33498);

return statearr_33562;
})();
var statearr_33563_33610 = state_33556__$1;
(statearr_33563_33610[(2)] = inst_33499);

(statearr_33563_33610[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (15))){
var inst_33521 = (state_33556[(2)]);
var state_33556__$1 = state_33556;
var statearr_33564_33611 = state_33556__$1;
(statearr_33564_33611[(2)] = inst_33521);

(statearr_33564_33611[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (21))){
var inst_33508 = (state_33556[(9)]);
var inst_33538 = (state_33556[(10)]);
var inst_33525 = (state_33556[(11)]);
var inst_33510 = (state_33556[(12)]);
var inst_33509 = (state_33556[(13)]);
var inst_33545 = (state_33556[(2)]);
var inst_33546 = (function (){var base_node = inst_33508;
var first_flake = inst_33509;
var node_t = inst_33510;
var source = inst_33525;
var coll = inst_33538;
var conj_QMARK_ = inst_33545;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__33566 = f.p;
var fexpr__33565 = (function (){var or__4212__auto__ = remove_preds;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__33565.cljs$core$IFn$_invoke$arity$1 ? fexpr__33565.cljs$core$IFn$_invoke$arity$1(G__33566) : fexpr__33565.call(null,G__33566));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_33547 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_33508);
var inst_33548 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_33546,inst_33547,inst_33538);
var inst_33549 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_33548);
var inst_33550 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33508,cljs.core.cst$kw$flakes,inst_33549);
var inst_33551 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_33550);
var _ = (function (){var statearr_33567 = state_33556;
(statearr_33567[(4)] = cljs.core.rest((state_33556[(4)])));

return statearr_33567;
})();
var state_33556__$1 = state_33556;
var statearr_33568_33612 = state_33556__$1;
(statearr_33568_33612[(2)] = inst_33551);

(statearr_33568_33612[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (13))){
var state_33556__$1 = state_33556;
var statearr_33569_33613 = state_33556__$1;
(statearr_33569_33613[(2)] = cljs.core.cst$kw$none);

(statearr_33569_33613[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (22))){
var inst_33508 = (state_33556[(9)]);
var inst_33538 = (state_33556[(10)]);
var inst_33525 = (state_33556[(11)]);
var inst_33510 = (state_33556[(12)]);
var inst_33509 = (state_33556[(13)]);
var inst_33539 = (function (){var base_node = inst_33508;
var first_flake = inst_33509;
var node_t = inst_33510;
var source = inst_33525;
var coll = inst_33538;
return (function (f){
return f.op === true;
});
})();
var state_33556__$1 = state_33556;
var statearr_33570_33614 = state_33556__$1;
(statearr_33570_33614[(2)] = inst_33539);

(statearr_33570_33614[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (6))){
var inst_33508 = (state_33556[(9)]);
var inst_33510 = (state_33556[(12)]);
var inst_33507 = (state_33556[(2)]);
var inst_33508__$1 = fluree.db.util.async.throw_err(inst_33507);
var inst_33509 = fluree.db.dbproto._first_flake(inst_33508__$1);
var inst_33510__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_33508__$1);
var inst_33511 = (inst_33510__$1 > t);
var state_33556__$1 = (function (){var statearr_33571 = state_33556;
(statearr_33571[(9)] = inst_33508__$1);

(statearr_33571[(12)] = inst_33510__$1);

(statearr_33571[(13)] = inst_33509);

return statearr_33571;
})();
if(cljs.core.truth_(inst_33511)){
var statearr_33572_33615 = state_33556__$1;
(statearr_33572_33615[(1)] = (7));

} else {
var statearr_33573_33616 = state_33556__$1;
(statearr_33573_33616[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (17))){
var inst_33509 = (state_33556[(13)]);
var inst_33526 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_33509,rhs,leftmost_QMARK_,t);
var state_33556__$1 = state_33556;
var statearr_33574_33617 = state_33556__$1;
(statearr_33574_33617[(2)] = inst_33526);

(statearr_33574_33617[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (3))){
var inst_33554 = (state_33556[(2)]);
var state_33556__$1 = state_33556;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33556__$1,inst_33554);
} else {
if((state_val_33557 === (12))){
var inst_33523 = (state_33556[(2)]);
var state_33556__$1 = state_33556;
var statearr_33575_33618 = state_33556__$1;
(statearr_33575_33618[(2)] = inst_33523);

(statearr_33575_33618[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (2))){
var _ = (function (){var statearr_33576 = state_33556;
(statearr_33576[(4)] = cljs.core.cons((5),(state_33556[(4)])));

return statearr_33576;
})();
var inst_33505 = fluree.db.dbproto._resolve(node);
var state_33556__$1 = state_33556;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33556__$1,(6),inst_33505);
} else {
if((state_val_33557 === (23))){
var inst_33508 = (state_33556[(9)]);
var inst_33538 = (state_33556[(10)]);
var inst_33525 = (state_33556[(11)]);
var inst_33510 = (state_33556[(12)]);
var inst_33509 = (state_33556[(13)]);
var inst_33541 = (function (){var base_node = inst_33508;
var first_flake = inst_33509;
var node_t = inst_33510;
var source = inst_33525;
var coll = inst_33538;
return (function (f){
return f.op === false;
});
})();
var state_33556__$1 = state_33556;
var statearr_33577_33619 = state_33556__$1;
(statearr_33577_33619[(2)] = inst_33541);

(statearr_33577_33619[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (19))){
var inst_33528 = (state_33556[(14)]);
var inst_33531 = (state_33556[(2)]);
var inst_33532 = fluree.db.util.async.throw_err(inst_33531);
var inst_33533 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_33528,inst_33532);
var state_33556__$1 = state_33556;
var statearr_33578_33620 = state_33556__$1;
(statearr_33578_33620[(2)] = inst_33533);

(statearr_33578_33620[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (11))){
var inst_33510 = (state_33556[(12)]);
var inst_33517 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33510,t);
var state_33556__$1 = state_33556;
if(inst_33517){
var statearr_33580_33621 = state_33556__$1;
(statearr_33580_33621[(1)] = (13));

} else {
var statearr_33581_33622 = state_33556__$1;
(statearr_33581_33622[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (9))){
var inst_33525 = (state_33556[(11)]);
var inst_33525__$1 = (state_33556[(2)]);
var state_33556__$1 = (function (){var statearr_33582 = state_33556;
(statearr_33582[(11)] = inst_33525__$1);

return statearr_33582;
})();
var G__33583_33623 = inst_33525__$1;
var G__33583_33624__$1 = (((G__33583_33623 instanceof cljs.core.Keyword))?G__33583_33623.fqn:null);
switch (G__33583_33624__$1) {
case "novelty":
var statearr_33584_33626 = state_33556__$1;
(statearr_33584_33626[(1)] = (17));


break;
case "history":
var statearr_33585_33627 = state_33556__$1;
(statearr_33585_33627[(1)] = (18));


break;
case "none":
var statearr_33586_33628 = state_33556__$1;
(statearr_33586_33628[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33583_33624__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (5))){
var _ = (function (){var statearr_33587 = state_33556;
(statearr_33587[(4)] = cljs.core.rest((state_33556[(4)])));

return statearr_33587;
})();
var state_33556__$1 = state_33556;
var ex33579 = (state_33556__$1[(2)]);
var statearr_33588_33629 = state_33556__$1;
(statearr_33588_33629[(5)] = ex33579);


var statearr_33589_33630 = state_33556__$1;
(statearr_33589_33630[(1)] = (4));

(statearr_33589_33630[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (14))){
var state_33556__$1 = state_33556;
var statearr_33590_33631 = state_33556__$1;
(statearr_33590_33631[(2)] = null);

(statearr_33590_33631[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (16))){
var inst_33525 = (state_33556[(11)]);
var inst_33538 = (state_33556[(2)]);
var state_33556__$1 = (function (){var statearr_33591 = state_33556;
(statearr_33591[(10)] = inst_33538);

return statearr_33591;
})();
var G__33592_33632 = inst_33525;
var G__33592_33633__$1 = (((G__33592_33632 instanceof cljs.core.Keyword))?G__33592_33632.fqn:null);
switch (G__33592_33633__$1) {
case "novelty":
var statearr_33593_33635 = state_33556__$1;
(statearr_33593_33635[(1)] = (22));


break;
case "history":
var statearr_33594_33636 = state_33556__$1;
(statearr_33594_33636[(1)] = (23));


break;
case "none":
var statearr_33595_33637 = state_33556__$1;
(statearr_33595_33637[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33592_33633__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (10))){
var state_33556__$1 = state_33556;
var statearr_33596_33638 = state_33556__$1;
(statearr_33596_33638[(2)] = cljs.core.cst$kw$history);

(statearr_33596_33638[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33557 === (18))){
var inst_33508 = (state_33556[(9)]);
var inst_33525 = (state_33556[(11)]);
var inst_33510 = (state_33556[(12)]);
var inst_33509 = (state_33556[(13)]);
var inst_33528 = (function (){var base_node = inst_33508;
var first_flake = inst_33509;
var node_t = inst_33510;
var source = inst_33525;
return (function (p1__33495_SHARP_){
return (p1__33495_SHARP_.t <= t);
});
})();
var inst_33529 = fluree.db.dbproto._resolve_history(node);
var state_33556__$1 = (function (){var statearr_33597 = state_33556;
(statearr_33597[(14)] = inst_33528);

return statearr_33597;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33556__$1,(19),inst_33529);
} else {
if((state_val_33557 === (8))){
var inst_33510 = (state_33556[(12)]);
var inst_33514 = (inst_33510 < t);
var state_33556__$1 = state_33556;
if(cljs.core.truth_(inst_33514)){
var statearr_33598_33639 = state_33556__$1;
(statearr_33598_33639[(1)] = (10));

} else {
var statearr_33599_33640 = state_33556__$1;
(statearr_33599_33640[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__16395__auto____0 = (function (){
var statearr_33600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33600[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__16395__auto__);

(statearr_33600[(1)] = (1));

return statearr_33600;
});
var fluree$db$storage$core$resolve_t_$_state_machine__16395__auto____1 = (function (state_33556){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33556);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33601){var ex__16398__auto__ = e33601;
var statearr_33602_33641 = state_33556;
(statearr_33602_33641[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33556[(4)]))){
var statearr_33603_33642 = state_33556;
(statearr_33603_33642[(1)] = cljs.core.first((state_33556[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33643 = state_33556;
state_33556 = G__33643;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__16395__auto__ = function(state_33556){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__16395__auto____1.call(this,state_33556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__16395__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__16395__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33604 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33604[(6)] = c__16469__auto___33605);

return statearr_33604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33703){
var state_val_33704 = (state_33703[(1)]);
if((state_val_33704 === (7))){
var inst_33654 = (state_33703[(7)]);
var inst_33658 = (inst_33654 <= from_t);
var state_33703__$1 = state_33703;
var statearr_33705_33745 = state_33703__$1;
(statearr_33705_33745[(2)] = inst_33658);

(statearr_33705_33745[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (20))){
var inst_33688 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_33689 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33688)].join('');
var inst_33690 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33691 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_33692 = cljs.core.PersistentHashMap.fromArrays(inst_33690,inst_33691);
var inst_33693 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33689,inst_33692);
var inst_33694 = (function(){throw inst_33693})();
var state_33703__$1 = state_33703;
var statearr_33706_33746 = state_33703__$1;
(statearr_33706_33746[(2)] = inst_33694);

(statearr_33706_33746[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (1))){
var state_33703__$1 = state_33703;
var statearr_33707_33747 = state_33703__$1;
(statearr_33707_33747[(2)] = null);

(statearr_33707_33747[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (4))){
var inst_33646 = (state_33703[(2)]);
var inst_33647 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_33646], 0));
var inst_33648 = (function(){throw inst_33646})();
var state_33703__$1 = (function (){var statearr_33708 = state_33703;
(statearr_33708[(8)] = inst_33647);

return statearr_33708;
})();
var statearr_33709_33748 = state_33703__$1;
(statearr_33709_33748[(2)] = inst_33648);

(statearr_33709_33748[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (15))){
var inst_33673 = (state_33703[(2)]);
var state_33703__$1 = (function (){var statearr_33710 = state_33703;
(statearr_33710[(9)] = inst_33673);

return statearr_33710;
})();
if(cljs.core.truth_(from_t)){
var statearr_33711_33749 = state_33703__$1;
(statearr_33711_33749[(1)] = (16));

} else {
var statearr_33712_33750 = state_33703__$1;
(statearr_33712_33750[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (21))){
var inst_33682 = (state_33703[(10)]);
var inst_33683 = (state_33703[(11)]);
var inst_33684 = (state_33703[(12)]);
var inst_33696 = (state_33703[(2)]);
var inst_33697 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_33683,inst_33684,leftmost_QMARK_,to_t);
var inst_33698 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33697,inst_33682);
var _ = (function (){var statearr_33713 = state_33703;
(statearr_33713[(4)] = cljs.core.rest((state_33703[(4)])));

return statearr_33713;
})();
var state_33703__$1 = (function (){var statearr_33714 = state_33703;
(statearr_33714[(13)] = inst_33696);

return statearr_33714;
})();
var statearr_33715_33751 = state_33703__$1;
(statearr_33715_33751[(2)] = inst_33698);

(statearr_33715_33751[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (13))){
var inst_33666 = (state_33703[(14)]);
var inst_33654 = (state_33703[(7)]);
var inst_33669 = (function (){var node_t = inst_33654;
var G__33662 = inst_33666;
return (function (p1__33644_SHARP_){
return (p1__33644_SHARP_.t < to_t);
});
})();
var inst_33670 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_33669,inst_33666);
var state_33703__$1 = state_33703;
var statearr_33716_33752 = state_33703__$1;
(statearr_33716_33752[(2)] = inst_33670);

(statearr_33716_33752[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (6))){
var inst_33655 = (state_33703[(15)]);
var state_33703__$1 = state_33703;
var statearr_33717_33753 = state_33703__$1;
(statearr_33717_33753[(2)] = inst_33655);

(statearr_33717_33753[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (17))){
var inst_33673 = (state_33703[(9)]);
var state_33703__$1 = state_33703;
var statearr_33718_33754 = state_33703__$1;
(statearr_33718_33754[(2)] = inst_33673);

(statearr_33718_33754[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (3))){
var inst_33701 = (state_33703[(2)]);
var state_33703__$1 = state_33703;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33703__$1,inst_33701);
} else {
if((state_val_33704 === (12))){
var inst_33654 = (state_33703[(7)]);
var inst_33665 = (state_33703[(2)]);
var inst_33666 = fluree.db.util.async.throw_err(inst_33665);
var inst_33667 = (to_t > inst_33654);
var state_33703__$1 = (function (){var statearr_33719 = state_33703;
(statearr_33719[(14)] = inst_33666);

return statearr_33719;
})();
if(cljs.core.truth_(inst_33667)){
var statearr_33720_33755 = state_33703__$1;
(statearr_33720_33755[(1)] = (13));

} else {
var statearr_33721_33756 = state_33703__$1;
(statearr_33721_33756[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (2))){
var inst_33655 = (state_33703[(15)]);
var _ = (function (){var statearr_33722 = state_33703;
(statearr_33722[(4)] = cljs.core.cons((5),(state_33703[(4)])));

return statearr_33722;
})();
var inst_33654 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_33655__$1 = (from_t == null);
var state_33703__$1 = (function (){var statearr_33723 = state_33703;
(statearr_33723[(15)] = inst_33655__$1);

(statearr_33723[(7)] = inst_33654);

return statearr_33723;
})();
if(cljs.core.truth_(inst_33655__$1)){
var statearr_33724_33757 = state_33703__$1;
(statearr_33724_33757[(1)] = (6));

} else {
var statearr_33725_33758 = state_33703__$1;
(statearr_33725_33758[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (19))){
var state_33703__$1 = state_33703;
var statearr_33726_33759 = state_33703__$1;
(statearr_33726_33759[(2)] = null);

(statearr_33726_33759[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (11))){
var inst_33682 = (state_33703[(2)]);
var inst_33683 = fluree.db.dbproto._first_flake(node);
var inst_33684 = fluree.db.dbproto._rhs(node);
var inst_33685 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_33703__$1 = (function (){var statearr_33728 = state_33703;
(statearr_33728[(10)] = inst_33682);

(statearr_33728[(11)] = inst_33683);

(statearr_33728[(12)] = inst_33684);

return statearr_33728;
})();
if(cljs.core.truth_(inst_33685)){
var statearr_33729_33760 = state_33703__$1;
(statearr_33729_33760[(1)] = (19));

} else {
var statearr_33730_33761 = state_33703__$1;
(statearr_33730_33761[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (9))){
var inst_33663 = fluree.db.dbproto._resolve_history(node);
var state_33703__$1 = state_33703;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33703__$1,(12),inst_33663);
} else {
if((state_val_33704 === (5))){
var _ = (function (){var statearr_33731 = state_33703;
(statearr_33731[(4)] = cljs.core.rest((state_33703[(4)])));

return statearr_33731;
})();
var state_33703__$1 = state_33703;
var ex33727 = (state_33703__$1[(2)]);
var statearr_33732_33762 = state_33703__$1;
(statearr_33732_33762[(5)] = ex33727);


var statearr_33733_33763 = state_33703__$1;
(statearr_33733_33763[(1)] = (4));

(statearr_33733_33763[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (14))){
var inst_33666 = (state_33703[(14)]);
var state_33703__$1 = state_33703;
var statearr_33734_33764 = state_33703__$1;
(statearr_33734_33764[(2)] = inst_33666);

(statearr_33734_33764[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (16))){
var inst_33654 = (state_33703[(7)]);
var inst_33673 = (state_33703[(9)]);
var inst_33675 = (function (){var node_t = inst_33654;
var G__33662 = inst_33673;
return (function (p1__33645_SHARP_){
return (p1__33645_SHARP_.t <= from_t);
});
})();
var inst_33676 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_33675,inst_33673);
var state_33703__$1 = state_33703;
var statearr_33735_33765 = state_33703__$1;
(statearr_33735_33765[(2)] = inst_33676);

(statearr_33735_33765[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (10))){
var state_33703__$1 = state_33703;
var statearr_33736_33766 = state_33703__$1;
(statearr_33736_33766[(2)] = null);

(statearr_33736_33766[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (18))){
var inst_33679 = (state_33703[(2)]);
var state_33703__$1 = state_33703;
var statearr_33737_33767 = state_33703__$1;
(statearr_33737_33767[(2)] = inst_33679);

(statearr_33737_33767[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33704 === (8))){
var inst_33660 = (state_33703[(2)]);
var state_33703__$1 = state_33703;
if(cljs.core.truth_(inst_33660)){
var statearr_33738_33768 = state_33703__$1;
(statearr_33738_33768[(1)] = (9));

} else {
var statearr_33739_33769 = state_33703__$1;
(statearr_33739_33769[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto____0 = (function (){
var statearr_33740 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33740[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto__);

(statearr_33740[(1)] = (1));

return statearr_33740;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto____1 = (function (state_33703){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33703);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33741){var ex__16398__auto__ = e33741;
var statearr_33742_33770 = state_33703;
(statearr_33742_33770[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33703[(4)]))){
var statearr_33743_33771 = state_33703;
(statearr_33743_33771[(1)] = cljs.core.first((state_33703[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33772 = state_33703;
state_33703 = G__33772;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto__ = function(state_33703){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto____1.call(this,state_33703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33744 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33744[(6)] = c__16469__auto__);

return statearr_33744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4212__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__33773_33783 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33774_33784 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33773_33783,G__33774_33784) : object_cache.call(null,G__33773_33783,G__33774_33784));

var G__33775 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33776 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__33777 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33778 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33777,G__33778) : object_cache.call(null,G__33777,G__33778));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33775,G__33776) : object_cache.call(null,G__33775,G__33776));
} else {
var G__33779 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33780 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__33781 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33782 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33781,G__33782) : object_cache.call(null,G__33781,G__33782));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33779,G__33780) : object_cache.call(null,G__33779,G__33780));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33805){
var state_val_33806 = (state_33805[(1)]);
if((state_val_33806 === (7))){
var state_33805__$1 = state_33805;
var statearr_33807_33827 = state_33805__$1;
(statearr_33807_33827[(2)] = null);

(statearr_33807_33827[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33806 === (1))){
var state_33805__$1 = state_33805;
var statearr_33808_33828 = state_33805__$1;
(statearr_33808_33828[(2)] = null);

(statearr_33808_33828[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33806 === (4))){
var inst_33785 = (state_33805[(2)]);
var state_33805__$1 = state_33805;
var statearr_33809_33829 = state_33805__$1;
(statearr_33809_33829[(2)] = inst_33785);

(statearr_33809_33829[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33806 === (6))){
var inst_33791 = (state_33805[(7)]);
var inst_33793 = fluree.db.storage.core.serde(conn);
var state_33805__$1 = (function (){var statearr_33810 = state_33805;
(statearr_33810[(8)] = inst_33793);

return statearr_33810;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33805__$1,(9),inst_33791);
} else {
if((state_val_33806 === (3))){
var inst_33803 = (state_33805[(2)]);
var state_33805__$1 = state_33805;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33805__$1,inst_33803);
} else {
if((state_val_33806 === (2))){
var inst_33791 = (state_33805[(7)]);
var _ = (function (){var statearr_33812 = state_33805;
(statearr_33812[(4)] = cljs.core.cons((5),(state_33805[(4)])));

return statearr_33812;
})();
var inst_33791__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_33805__$1 = (function (){var statearr_33813 = state_33805;
(statearr_33813[(7)] = inst_33791__$1);

return statearr_33813;
})();
if(cljs.core.truth_(inst_33791__$1)){
var statearr_33814_33830 = state_33805__$1;
(statearr_33814_33830[(1)] = (6));

} else {
var statearr_33815_33831 = state_33805__$1;
(statearr_33815_33831[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33806 === (9))){
var inst_33793 = (state_33805[(8)]);
var inst_33795 = (state_33805[(2)]);
var inst_33796 = fluree.db.util.async.throw_err(inst_33795);
var inst_33797 = fluree.db.serde.protocol._deserialize_branch(inst_33793,inst_33796);
var state_33805__$1 = state_33805;
var statearr_33816_33832 = state_33805__$1;
(statearr_33816_33832[(2)] = inst_33797);

(statearr_33816_33832[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33806 === (5))){
var _ = (function (){var statearr_33817 = state_33805;
(statearr_33817[(4)] = cljs.core.rest((state_33805[(4)])));

return statearr_33817;
})();
var state_33805__$1 = state_33805;
var ex33811 = (state_33805__$1[(2)]);
var statearr_33818_33833 = state_33805__$1;
(statearr_33818_33833[(5)] = ex33811);


if((ex33811 instanceof Error)){
var statearr_33819_33834 = state_33805__$1;
(statearr_33819_33834[(1)] = (4));

(statearr_33819_33834[(5)] = null);

} else {
throw ex33811;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33806 === (8))){
var inst_33800 = (state_33805[(2)]);
var _ = (function (){var statearr_33820 = state_33805;
(statearr_33820[(4)] = cljs.core.rest((state_33805[(4)])));

return statearr_33820;
})();
var state_33805__$1 = state_33805;
var statearr_33821_33835 = state_33805__$1;
(statearr_33821_33835[(2)] = inst_33800);

(statearr_33821_33835[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__16395__auto____0 = (function (){
var statearr_33822 = [null,null,null,null,null,null,null,null,null];
(statearr_33822[(0)] = fluree$db$storage$core$read_branch_$_state_machine__16395__auto__);

(statearr_33822[(1)] = (1));

return statearr_33822;
});
var fluree$db$storage$core$read_branch_$_state_machine__16395__auto____1 = (function (state_33805){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33805);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33823){var ex__16398__auto__ = e33823;
var statearr_33824_33836 = state_33805;
(statearr_33824_33836[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33805[(4)]))){
var statearr_33825_33837 = state_33805;
(statearr_33825_33837[(1)] = cljs.core.first((state_33805[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33838 = state_33805;
state_33805 = G__33838;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__16395__auto__ = function(state_33805){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__16395__auto____1.call(this,state_33805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__16395__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__16395__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33826 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33826[(6)] = c__16469__auto__);

return statearr_33826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___33917 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33889){
var state_val_33890 = (state_33889[(1)]);
if((state_val_33890 === (7))){
var inst_33856 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_33857 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33858 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_33859 = cljs.core.PersistentHashMap.fromArrays(inst_33857,inst_33858);
var inst_33860 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33856,inst_33859);
var inst_33861 = (function(){throw inst_33860})();
var state_33889__$1 = state_33889;
var statearr_33891_33918 = state_33889__$1;
(statearr_33891_33918[(2)] = inst_33861);

(statearr_33891_33918[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33890 === (1))){
var state_33889__$1 = state_33889;
var statearr_33892_33919 = state_33889__$1;
(statearr_33892_33919[(2)] = null);

(statearr_33892_33919[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33890 === (4))){
var inst_33839 = (state_33889[(2)]);
var inst_33840 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_33841 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33839);
var inst_33842 = cljs.core.async.close_BANG_(return_ch);
var state_33889__$1 = (function (){var statearr_33893 = state_33889;
(statearr_33893[(7)] = inst_33840);

(statearr_33893[(8)] = inst_33841);

return statearr_33893;
})();
var statearr_33894_33920 = state_33889__$1;
(statearr_33894_33920[(2)] = inst_33842);

(statearr_33894_33920[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33890 === (6))){
var inst_33853 = (state_33889[(9)]);
var inst_33852 = (state_33889[(2)]);
var inst_33853__$1 = fluree.db.util.async.throw_err(inst_33852);
var inst_33854 = (inst_33853__$1 == null);
var state_33889__$1 = (function (){var statearr_33895 = state_33889;
(statearr_33895[(9)] = inst_33853__$1);

return statearr_33895;
})();
if(cljs.core.truth_(inst_33854)){
var statearr_33896_33921 = state_33889__$1;
(statearr_33896_33921[(1)] = (7));

} else {
var statearr_33897_33922 = state_33889__$1;
(statearr_33897_33922[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33890 === (3))){
var inst_33887 = (state_33889[(2)]);
var state_33889__$1 = state_33889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33889__$1,inst_33887);
} else {
if((state_val_33890 === (12))){
var inst_33853 = (state_33889[(9)]);
var inst_33870 = (state_33889[(2)]);
var inst_33871 = cljs.core.__destructure_map(inst_33853);
var inst_33872 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33871,cljs.core.cst$kw$children);
var inst_33873 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33871,cljs.core.cst$kw$rhs);
var inst_33874 = config;
var inst_33875 = cljs.core.__destructure_map(inst_33874);
var inst_33876 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33875,cljs.core.cst$kw$comparator);
var inst_33878 = (function (){var data = inst_33853;
var _ = inst_33870;
var map__33848 = inst_33871;
var children = inst_33872;
var rhs = inst_33873;
var map__33849 = inst_33875;
var comparator = inst_33876;
return (function (idx,p__33877){
var map__33898 = p__33877;
var map__33898__$1 = cljs.core.__destructure_map(map__33898);
var child = map__33898__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33898__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33898__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33898__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33898__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33898__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4210__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return (idx === (0));
} else {
return and__4210__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_33879 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_33878,inst_33872);
var inst_33880 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_33879);
var inst_33881 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_33880,inst_33879);
var inst_33882 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_33876,inst_33881);
var inst_33883 = fluree.db.index.__GT_IndexNode(block,t,inst_33873,inst_33882,config,leftmost_QMARK_);
var inst_33884 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33883);
var _ = (function (){var statearr_33899 = state_33889;
(statearr_33899[(4)] = cljs.core.rest((state_33889[(4)])));

return statearr_33899;
})();
var state_33889__$1 = state_33889;
var statearr_33900_33923 = state_33889__$1;
(statearr_33900_33923[(2)] = inst_33884);

(statearr_33900_33923[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33890 === (2))){
var _ = (function (){var statearr_33901 = state_33889;
(statearr_33901[(4)] = cljs.core.cons((5),(state_33889[(4)])));

return statearr_33901;
})();
var inst_33850 = fluree.db.storage.core.read_branch(conn,key);
var state_33889__$1 = state_33889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33889__$1,(6),inst_33850);
} else {
if((state_val_33890 === (11))){
var state_33889__$1 = state_33889;
var statearr_33903_33924 = state_33889__$1;
(statearr_33903_33924[(2)] = null);

(statearr_33903_33924[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33890 === (9))){
var inst_33853 = (state_33889[(9)]);
var inst_33864 = (state_33889[(2)]);
var inst_33865 = fluree.db.util.core.exception_QMARK_(inst_33853);
var state_33889__$1 = (function (){var statearr_33904 = state_33889;
(statearr_33904[(10)] = inst_33864);

return statearr_33904;
})();
if(inst_33865){
var statearr_33905_33925 = state_33889__$1;
(statearr_33905_33925[(1)] = (10));

} else {
var statearr_33906_33926 = state_33889__$1;
(statearr_33906_33926[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33890 === (5))){
var _ = (function (){var statearr_33907 = state_33889;
(statearr_33907[(4)] = cljs.core.rest((state_33889[(4)])));

return statearr_33907;
})();
var state_33889__$1 = state_33889;
var ex33902 = (state_33889__$1[(2)]);
var statearr_33908_33927 = state_33889__$1;
(statearr_33908_33927[(5)] = ex33902);


var statearr_33909_33928 = state_33889__$1;
(statearr_33909_33928[(1)] = (4));

(statearr_33909_33928[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33890 === (10))){
var inst_33853 = (state_33889[(9)]);
var inst_33867 = (function(){throw inst_33853})();
var state_33889__$1 = state_33889;
var statearr_33910_33929 = state_33889__$1;
(statearr_33910_33929[(2)] = inst_33867);

(statearr_33910_33929[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33890 === (8))){
var state_33889__$1 = state_33889;
var statearr_33911_33930 = state_33889__$1;
(statearr_33911_33930[(2)] = null);

(statearr_33911_33930[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__16395__auto____0 = (function (){
var statearr_33912 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33912[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__16395__auto__);

(statearr_33912[(1)] = (1));

return statearr_33912;
});
var fluree$db$storage$core$reify_branch_$_state_machine__16395__auto____1 = (function (state_33889){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33889);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33913){var ex__16398__auto__ = e33913;
var statearr_33914_33931 = state_33889;
(statearr_33914_33931[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33889[(4)]))){
var statearr_33915_33932 = state_33889;
(statearr_33915_33932[(1)] = cljs.core.first((state_33889[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33933 = state_33889;
state_33889 = G__33933;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__16395__auto__ = function(state_33889){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__16395__auto____1.call(this,state_33889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__16395__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__16395__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33916 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33916[(6)] = c__16469__auto___33917);

return statearr_33916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33954){
var state_val_33955 = (state_33954[(1)]);
if((state_val_33955 === (7))){
var state_33954__$1 = state_33954;
var statearr_33956_33976 = state_33954__$1;
(statearr_33956_33976[(2)] = null);

(statearr_33956_33976[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33955 === (1))){
var state_33954__$1 = state_33954;
var statearr_33957_33977 = state_33954__$1;
(statearr_33957_33977[(2)] = null);

(statearr_33957_33977[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33955 === (4))){
var inst_33934 = (state_33954[(2)]);
var state_33954__$1 = state_33954;
var statearr_33958_33978 = state_33954__$1;
(statearr_33958_33978[(2)] = inst_33934);

(statearr_33958_33978[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33955 === (6))){
var inst_33940 = (state_33954[(7)]);
var inst_33942 = fluree.db.storage.core.serde(conn);
var state_33954__$1 = (function (){var statearr_33959 = state_33954;
(statearr_33959[(8)] = inst_33942);

return statearr_33959;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33954__$1,(9),inst_33940);
} else {
if((state_val_33955 === (3))){
var inst_33952 = (state_33954[(2)]);
var state_33954__$1 = state_33954;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33954__$1,inst_33952);
} else {
if((state_val_33955 === (2))){
var inst_33940 = (state_33954[(7)]);
var _ = (function (){var statearr_33961 = state_33954;
(statearr_33961[(4)] = cljs.core.cons((5),(state_33954[(4)])));

return statearr_33961;
})();
var inst_33940__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_33954__$1 = (function (){var statearr_33962 = state_33954;
(statearr_33962[(7)] = inst_33940__$1);

return statearr_33962;
})();
if(cljs.core.truth_(inst_33940__$1)){
var statearr_33963_33979 = state_33954__$1;
(statearr_33963_33979[(1)] = (6));

} else {
var statearr_33964_33980 = state_33954__$1;
(statearr_33964_33980[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33955 === (9))){
var inst_33942 = (state_33954[(8)]);
var inst_33944 = (state_33954[(2)]);
var inst_33945 = fluree.db.util.async.throw_err(inst_33944);
var inst_33946 = fluree.db.serde.protocol._deserialize_leaf(inst_33942,inst_33945);
var state_33954__$1 = state_33954;
var statearr_33965_33981 = state_33954__$1;
(statearr_33965_33981[(2)] = inst_33946);

(statearr_33965_33981[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33955 === (5))){
var _ = (function (){var statearr_33966 = state_33954;
(statearr_33966[(4)] = cljs.core.rest((state_33954[(4)])));

return statearr_33966;
})();
var state_33954__$1 = state_33954;
var ex33960 = (state_33954__$1[(2)]);
var statearr_33967_33982 = state_33954__$1;
(statearr_33967_33982[(5)] = ex33960);


if((ex33960 instanceof Error)){
var statearr_33968_33983 = state_33954__$1;
(statearr_33968_33983[(1)] = (4));

(statearr_33968_33983[(5)] = null);

} else {
throw ex33960;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33955 === (8))){
var inst_33949 = (state_33954[(2)]);
var _ = (function (){var statearr_33969 = state_33954;
(statearr_33969[(4)] = cljs.core.rest((state_33954[(4)])));

return statearr_33969;
})();
var state_33954__$1 = state_33954;
var statearr_33970_33984 = state_33954__$1;
(statearr_33970_33984[(2)] = inst_33949);

(statearr_33970_33984[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__16395__auto____0 = (function (){
var statearr_33971 = [null,null,null,null,null,null,null,null,null];
(statearr_33971[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__16395__auto__);

(statearr_33971[(1)] = (1));

return statearr_33971;
});
var fluree$db$storage$core$read_leaf_$_state_machine__16395__auto____1 = (function (state_33954){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33954);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33972){var ex__16398__auto__ = e33972;
var statearr_33973_33985 = state_33954;
(statearr_33973_33985[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33954[(4)]))){
var statearr_33974_33986 = state_33954;
(statearr_33974_33986[(1)] = cljs.core.first((state_33954[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33987 = state_33954;
state_33954 = G__33987;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__16395__auto__ = function(state_33954){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__16395__auto____1.call(this,state_33954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__16395__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__16395__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33975 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33975[(6)] = c__16469__auto__);

return statearr_33975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___34060 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34032){
var state_val_34033 = (state_34032[(1)]);
if((state_val_34033 === (7))){
var inst_34004 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_34005 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34006 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_34007 = cljs.core.PersistentHashMap.fromArrays(inst_34005,inst_34006);
var inst_34008 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34004,inst_34007);
var inst_34009 = (function(){throw inst_34008})();
var state_34032__$1 = state_34032;
var statearr_34034_34061 = state_34032__$1;
(statearr_34034_34061[(2)] = inst_34009);

(statearr_34034_34061[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34033 === (1))){
var state_34032__$1 = state_34032;
var statearr_34035_34062 = state_34032__$1;
(statearr_34035_34062[(2)] = null);

(statearr_34035_34062[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34033 === (4))){
var inst_33988 = (state_34032[(2)]);
var inst_33989 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_33990 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33988);
var inst_33991 = cljs.core.async.close_BANG_(return_ch);
var state_34032__$1 = (function (){var statearr_34036 = state_34032;
(statearr_34036[(7)] = inst_33989);

(statearr_34036[(8)] = inst_33990);

return statearr_34036;
})();
var statearr_34037_34063 = state_34032__$1;
(statearr_34037_34063[(2)] = inst_33991);

(statearr_34037_34063[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34033 === (6))){
var inst_34001 = (state_34032[(9)]);
var inst_34001__$1 = (state_34032[(2)]);
var inst_34002 = (inst_34001__$1 == null);
var state_34032__$1 = (function (){var statearr_34038 = state_34032;
(statearr_34038[(9)] = inst_34001__$1);

return statearr_34038;
})();
if(cljs.core.truth_(inst_34002)){
var statearr_34039_34064 = state_34032__$1;
(statearr_34039_34064[(1)] = (7));

} else {
var statearr_34040_34065 = state_34032__$1;
(statearr_34040_34065[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34033 === (3))){
var inst_34030 = (state_34032[(2)]);
var state_34032__$1 = state_34032;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34032__$1,inst_34030);
} else {
if((state_val_34033 === (12))){
var inst_34001 = (state_34032[(9)]);
var inst_34018 = (state_34032[(2)]);
var inst_34019 = cljs.core.__destructure_map(inst_34001);
var inst_34020 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34019,cljs.core.cst$kw$flakes);
var inst_34021 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34019,cljs.core.cst$kw$his);
var inst_34022 = config;
var inst_34023 = cljs.core.__destructure_map(inst_34022);
var inst_34024 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34023,cljs.core.cst$kw$comparator);
var inst_34025 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_34024,inst_34020);
var inst_34026 = fluree.db.index.data_node(block,t,inst_34025,rhs,config);
var inst_34027 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_34026);
var _ = (function (){var statearr_34041 = state_34032;
(statearr_34041[(4)] = cljs.core.rest((state_34032[(4)])));

return statearr_34041;
})();
var state_34032__$1 = (function (){var statearr_34042 = state_34032;
(statearr_34042[(10)] = inst_34018);

(statearr_34042[(11)] = inst_34021);

return statearr_34042;
})();
var statearr_34043_34066 = state_34032__$1;
(statearr_34043_34066[(2)] = inst_34027);

(statearr_34043_34066[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34033 === (2))){
var _ = (function (){var statearr_34044 = state_34032;
(statearr_34044[(4)] = cljs.core.cons((5),(state_34032[(4)])));

return statearr_34044;
})();
var inst_33999 = fluree.db.storage.core.read_leaf(conn,key);
var state_34032__$1 = state_34032;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34032__$1,(6),inst_33999);
} else {
if((state_val_34033 === (11))){
var state_34032__$1 = state_34032;
var statearr_34046_34067 = state_34032__$1;
(statearr_34046_34067[(2)] = null);

(statearr_34046_34067[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34033 === (9))){
var inst_34001 = (state_34032[(9)]);
var inst_34012 = (state_34032[(2)]);
var inst_34013 = fluree.db.util.core.exception_QMARK_(inst_34001);
var state_34032__$1 = (function (){var statearr_34047 = state_34032;
(statearr_34047[(12)] = inst_34012);

return statearr_34047;
})();
if(inst_34013){
var statearr_34048_34068 = state_34032__$1;
(statearr_34048_34068[(1)] = (10));

} else {
var statearr_34049_34069 = state_34032__$1;
(statearr_34049_34069[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34033 === (5))){
var _ = (function (){var statearr_34050 = state_34032;
(statearr_34050[(4)] = cljs.core.rest((state_34032[(4)])));

return statearr_34050;
})();
var state_34032__$1 = state_34032;
var ex34045 = (state_34032__$1[(2)]);
var statearr_34051_34070 = state_34032__$1;
(statearr_34051_34070[(5)] = ex34045);


var statearr_34052_34071 = state_34032__$1;
(statearr_34052_34071[(1)] = (4));

(statearr_34052_34071[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_34033 === (10))){
var inst_34001 = (state_34032[(9)]);
var inst_34015 = (function(){throw inst_34001})();
var state_34032__$1 = state_34032;
var statearr_34053_34072 = state_34032__$1;
(statearr_34053_34072[(2)] = inst_34015);

(statearr_34053_34072[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34033 === (8))){
var state_34032__$1 = state_34032;
var statearr_34054_34073 = state_34032__$1;
(statearr_34054_34073[(2)] = null);

(statearr_34054_34073[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto____0 = (function (){
var statearr_34055 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34055[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto__);

(statearr_34055[(1)] = (1));

return statearr_34055;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto____1 = (function (state_34032){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34032);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34056){var ex__16398__auto__ = e34056;
var statearr_34057_34074 = state_34032;
(statearr_34057_34074[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34032[(4)]))){
var statearr_34058_34075 = state_34032;
(statearr_34058_34075[(1)] = cljs.core.first((state_34032[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34076 = state_34032;
state_34032 = G__34076;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto__ = function(state_34032){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto____1.call(this,state_34032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34059 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34059[(6)] = c__16469__auto___34060);

return statearr_34059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k34078,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__34082 = k34078;
var G__34082__$1 = (((G__34082 instanceof cljs.core.Keyword))?G__34082.fqn:null);
switch (G__34082__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34078,else__4464__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__34083){
var vec__34084 = p__34083;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34084,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34084,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34077){
var self__ = this;
var G__34077__$1 = this;
return (new cljs.core.RecordIter((0),G__34077__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__34087 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__34088 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__34089 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__34090 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__34089,G__34090) : object_cache.call(null,G__34089,G__34090));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__34091 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__34092 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__34091,G__34092) : object_cache.call(null,G__34091,G__34092));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__34087,G__34088) : object_cache.call(null,G__34087,G__34088));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__34093 = history_id;
var G__34094 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__34093,G__34094) : object_cache.call(null,G__34093,G__34094));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__34095 = (function (coll__4458__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__34095(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34079,other34080){
var self__ = this;
var this34079__$1 = this;
return (((!((other34080 == null)))) && ((((this34079__$1.constructor === other34080.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.conn,other34080.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.config,other34080.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.network,other34080.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.dbid,other34080.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.id,other34080.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.leaf,other34080.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.first,other34080.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.rhs,other34080.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.size,other34080.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.block,other34080.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.t,other34080.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.tt_id,other34080.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.leftmost_QMARK_,other34080.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.tempid,other34080.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34079__$1.__extmap,other34080.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k34078){
var self__ = this;
var this__4468__auto____$1 = this;
var G__34096 = k34078;
var G__34096__$1 = (((G__34096 instanceof cljs.core.Keyword))?G__34096.fqn:null);
switch (G__34096__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34078);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__34077){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__34097 = cljs.core.keyword_identical_QMARK_;
var expr__34098 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__34100 = cljs.core.cst$kw$conn;
var G__34101 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34100,G__34101) : pred__34097.call(null,G__34100,G__34101));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__34077,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34102 = cljs.core.cst$kw$config;
var G__34103 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34102,G__34103) : pred__34097.call(null,G__34102,G__34103));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__34077,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34104 = cljs.core.cst$kw$network;
var G__34105 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34104,G__34105) : pred__34097.call(null,G__34104,G__34105));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__34077,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34106 = cljs.core.cst$kw$dbid;
var G__34107 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34106,G__34107) : pred__34097.call(null,G__34106,G__34107));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__34077,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34108 = cljs.core.cst$kw$id;
var G__34109 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34108,G__34109) : pred__34097.call(null,G__34108,G__34109));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__34077,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34110 = cljs.core.cst$kw$leaf;
var G__34111 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34110,G__34111) : pred__34097.call(null,G__34110,G__34111));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__34077,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34112 = cljs.core.cst$kw$first;
var G__34113 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34112,G__34113) : pred__34097.call(null,G__34112,G__34113));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__34077,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34114 = cljs.core.cst$kw$rhs;
var G__34115 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34114,G__34115) : pred__34097.call(null,G__34114,G__34115));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__34077,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34116 = cljs.core.cst$kw$size;
var G__34117 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34116,G__34117) : pred__34097.call(null,G__34116,G__34117));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__34077,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34118 = cljs.core.cst$kw$block;
var G__34119 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34118,G__34119) : pred__34097.call(null,G__34118,G__34119));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__34077,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34120 = cljs.core.cst$kw$t;
var G__34121 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34120,G__34121) : pred__34097.call(null,G__34120,G__34121));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__34077,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34122 = cljs.core.cst$kw$tt_DASH_id;
var G__34123 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34122,G__34123) : pred__34097.call(null,G__34122,G__34123));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__34077,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34124 = cljs.core.cst$kw$leftmost_QMARK_;
var G__34125 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34124,G__34125) : pred__34097.call(null,G__34124,G__34125));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__34077,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34126 = cljs.core.cst$kw$tempid;
var G__34127 = expr__34098;
return (pred__34097.cljs$core$IFn$_invoke$arity$2 ? pred__34097.cljs$core$IFn$_invoke$arity$2(G__34126,G__34127) : pred__34097.call(null,G__34126,G__34127));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__34077,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__34077),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__34077){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__34077,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__34081){
var extmap__4501__auto__ = (function (){var G__34128 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34081,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__34081)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34128);
} else {
return G__34128;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__34081),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__34081),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__34131 = blank_db;
var map__34131__$1 = cljs.core.__destructure_map(map__34131);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34131__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34131__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34131__$1,cljs.core.cst$kw$index_DASH_configs);
var map__34132 = root_data;
var map__34132__$1 = cljs.core.__destructure_map(map__34132);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34132__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34132__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34132__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34132__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34154){
var state_val_34155 = (state_34154[(1)]);
if((state_val_34155 === (7))){
var state_34154__$1 = state_34154;
var statearr_34156_34176 = state_34154__$1;
(statearr_34156_34176[(2)] = null);

(statearr_34156_34176[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34155 === (1))){
var state_34154__$1 = state_34154;
var statearr_34157_34177 = state_34154__$1;
(statearr_34157_34177[(2)] = null);

(statearr_34157_34177[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34155 === (4))){
var inst_34133 = (state_34154[(2)]);
var state_34154__$1 = state_34154;
var statearr_34158_34178 = state_34154__$1;
(statearr_34158_34178[(2)] = inst_34133);

(statearr_34158_34178[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34155 === (6))){
var inst_34140 = (state_34154[(7)]);
var inst_34142 = fluree.db.storage.core.serde(conn);
var state_34154__$1 = (function (){var statearr_34159 = state_34154;
(statearr_34159[(8)] = inst_34142);

return statearr_34159;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34154__$1,(9),inst_34140);
} else {
if((state_val_34155 === (3))){
var inst_34152 = (state_34154[(2)]);
var state_34154__$1 = state_34154;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34154__$1,inst_34152);
} else {
if((state_val_34155 === (2))){
var inst_34140 = (state_34154[(7)]);
var _ = (function (){var statearr_34161 = state_34154;
(statearr_34161[(4)] = cljs.core.cons((5),(state_34154[(4)])));

return statearr_34161;
})();
var inst_34139 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_34140__$1 = fluree.db.storage.core.storage_read(conn,inst_34139);
var state_34154__$1 = (function (){var statearr_34162 = state_34154;
(statearr_34162[(7)] = inst_34140__$1);

return statearr_34162;
})();
if(cljs.core.truth_(inst_34140__$1)){
var statearr_34163_34179 = state_34154__$1;
(statearr_34163_34179[(1)] = (6));

} else {
var statearr_34164_34180 = state_34154__$1;
(statearr_34164_34180[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34155 === (9))){
var inst_34142 = (state_34154[(8)]);
var inst_34144 = (state_34154[(2)]);
var inst_34145 = fluree.db.util.async.throw_err(inst_34144);
var inst_34146 = fluree.db.serde.protocol._deserialize_garbage(inst_34142,inst_34145);
var state_34154__$1 = state_34154;
var statearr_34165_34181 = state_34154__$1;
(statearr_34165_34181[(2)] = inst_34146);

(statearr_34165_34181[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34155 === (5))){
var _ = (function (){var statearr_34166 = state_34154;
(statearr_34166[(4)] = cljs.core.rest((state_34154[(4)])));

return statearr_34166;
})();
var state_34154__$1 = state_34154;
var ex34160 = (state_34154__$1[(2)]);
var statearr_34167_34182 = state_34154__$1;
(statearr_34167_34182[(5)] = ex34160);


if((ex34160 instanceof Error)){
var statearr_34168_34183 = state_34154__$1;
(statearr_34168_34183[(1)] = (4));

(statearr_34168_34183[(5)] = null);

} else {
throw ex34160;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34155 === (8))){
var inst_34149 = (state_34154[(2)]);
var _ = (function (){var statearr_34169 = state_34154;
(statearr_34169[(4)] = cljs.core.rest((state_34154[(4)])));

return statearr_34169;
})();
var state_34154__$1 = state_34154;
var statearr_34170_34184 = state_34154__$1;
(statearr_34170_34184[(2)] = inst_34149);

(statearr_34170_34184[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__16395__auto____0 = (function (){
var statearr_34171 = [null,null,null,null,null,null,null,null,null];
(statearr_34171[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__16395__auto__);

(statearr_34171[(1)] = (1));

return statearr_34171;
});
var fluree$db$storage$core$read_garbage_$_state_machine__16395__auto____1 = (function (state_34154){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34154);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34172){var ex__16398__auto__ = e34172;
var statearr_34173_34185 = state_34154;
(statearr_34173_34185[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34154[(4)]))){
var statearr_34174_34186 = state_34154;
(statearr_34174_34186[(1)] = cljs.core.first((state_34154[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34187 = state_34154;
state_34154 = G__34187;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__16395__auto__ = function(state_34154){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__16395__auto____1.call(this,state_34154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__16395__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__16395__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34175 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34175[(6)] = c__16469__auto__);

return statearr_34175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34209){
var state_val_34210 = (state_34209[(1)]);
if((state_val_34210 === (7))){
var inst_34198 = (state_34209[(7)]);
var inst_34200 = fluree.db.storage.core.serde(conn);
var inst_34201 = fluree.db.serde.protocol._deserialize_db_root(inst_34200,inst_34198);
var state_34209__$1 = state_34209;
var statearr_34211_34230 = state_34209__$1;
(statearr_34211_34230[(2)] = inst_34201);

(statearr_34211_34230[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34210 === (1))){
var state_34209__$1 = state_34209;
var statearr_34212_34231 = state_34209__$1;
(statearr_34212_34231[(2)] = null);

(statearr_34212_34231[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34210 === (4))){
var inst_34188 = (state_34209[(2)]);
var state_34209__$1 = state_34209;
var statearr_34213_34232 = state_34209__$1;
(statearr_34213_34232[(2)] = inst_34188);

(statearr_34213_34232[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34210 === (6))){
var inst_34198 = (state_34209[(7)]);
var inst_34197 = (state_34209[(2)]);
var inst_34198__$1 = fluree.db.util.async.throw_err(inst_34197);
var state_34209__$1 = (function (){var statearr_34214 = state_34209;
(statearr_34214[(7)] = inst_34198__$1);

return statearr_34214;
})();
if(cljs.core.truth_(inst_34198__$1)){
var statearr_34215_34233 = state_34209__$1;
(statearr_34215_34233[(1)] = (7));

} else {
var statearr_34216_34234 = state_34209__$1;
(statearr_34216_34234[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34210 === (3))){
var inst_34207 = (state_34209[(2)]);
var state_34209__$1 = state_34209;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34209__$1,inst_34207);
} else {
if((state_val_34210 === (2))){
var _ = (function (){var statearr_34218 = state_34209;
(statearr_34218[(4)] = cljs.core.cons((5),(state_34209[(4)])));

return statearr_34218;
})();
var inst_34194 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_34195 = fluree.db.storage.core.storage_read(conn,inst_34194);
var state_34209__$1 = state_34209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34209__$1,(6),inst_34195);
} else {
if((state_val_34210 === (9))){
var inst_34204 = (state_34209[(2)]);
var _ = (function (){var statearr_34219 = state_34209;
(statearr_34219[(4)] = cljs.core.rest((state_34209[(4)])));

return statearr_34219;
})();
var state_34209__$1 = state_34209;
var statearr_34220_34235 = state_34209__$1;
(statearr_34220_34235[(2)] = inst_34204);

(statearr_34220_34235[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34210 === (5))){
var _ = (function (){var statearr_34221 = state_34209;
(statearr_34221[(4)] = cljs.core.rest((state_34209[(4)])));

return statearr_34221;
})();
var state_34209__$1 = state_34209;
var ex34217 = (state_34209__$1[(2)]);
var statearr_34222_34236 = state_34209__$1;
(statearr_34222_34236[(5)] = ex34217);


if((ex34217 instanceof Error)){
var statearr_34223_34237 = state_34209__$1;
(statearr_34223_34237[(1)] = (4));

(statearr_34223_34237[(5)] = null);

} else {
throw ex34217;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34210 === (8))){
var state_34209__$1 = state_34209;
var statearr_34224_34238 = state_34209__$1;
(statearr_34224_34238[(2)] = null);

(statearr_34224_34238[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__16395__auto____0 = (function (){
var statearr_34225 = [null,null,null,null,null,null,null,null];
(statearr_34225[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__16395__auto__);

(statearr_34225[(1)] = (1));

return statearr_34225;
});
var fluree$db$storage$core$read_db_root_$_state_machine__16395__auto____1 = (function (state_34209){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34209);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34226){var ex__16398__auto__ = e34226;
var statearr_34227_34239 = state_34209;
(statearr_34227_34239[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34209[(4)]))){
var statearr_34228_34240 = state_34209;
(statearr_34228_34240[(1)] = cljs.core.first((state_34209[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34241 = state_34209;
state_34209 = G__34241;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__16395__auto__ = function(state_34209){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__16395__auto____1.call(this,state_34209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__16395__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__16395__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34229 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34229[(6)] = c__16469__auto__);

return statearr_34229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34277){
var state_val_34278 = (state_34277[(1)]);
if((state_val_34278 === (7))){
var inst_34251 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_34252 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34253 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_34254 = cljs.core.PersistentHashMap.fromArrays(inst_34252,inst_34253);
var inst_34255 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34251,inst_34254);
var inst_34256 = (function(){throw inst_34255})();
var state_34277__$1 = state_34277;
var statearr_34279_34301 = state_34277__$1;
(statearr_34279_34301[(2)] = inst_34256);

(statearr_34279_34301[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34278 === (1))){
var state_34277__$1 = state_34277;
var statearr_34280_34302 = state_34277__$1;
(statearr_34280_34302[(2)] = null);

(statearr_34280_34302[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34278 === (4))){
var inst_34242 = (state_34277[(2)]);
var state_34277__$1 = state_34277;
var statearr_34281_34303 = state_34277__$1;
(statearr_34281_34303[(2)] = inst_34242);

(statearr_34281_34303[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34278 === (6))){
var state_34277__$1 = state_34277;
var statearr_34282_34304 = state_34277__$1;
(statearr_34282_34304[(2)] = null);

(statearr_34282_34304[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34278 === (3))){
var inst_34275 = (state_34277[(2)]);
var state_34277__$1 = state_34277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34277__$1,inst_34275);
} else {
if((state_val_34278 === (2))){
var inst_34248 = (state_34277[(7)]);
var _ = (function (){var statearr_34283 = state_34277;
(statearr_34283[(4)] = cljs.core.cons((5),(state_34277[(4)])));

return statearr_34283;
})();
var inst_34248__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_34277__$1 = (function (){var statearr_34284 = state_34277;
(statearr_34284[(7)] = inst_34248__$1);

return statearr_34284;
})();
if(cljs.core.truth_(inst_34248__$1)){
var statearr_34285_34305 = state_34277__$1;
(statearr_34285_34305[(1)] = (6));

} else {
var statearr_34286_34306 = state_34277__$1;
(statearr_34286_34306[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34278 === (11))){
var inst_34267 = (state_34277[(8)]);
var inst_34270 = (state_34277[(2)]);
var inst_34271 = fluree.db.util.async.throw_err(inst_34270);
var inst_34272 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34267,cljs.core.cst$kw$settings,inst_34271);
var _ = (function (){var statearr_34288 = state_34277;
(statearr_34288[(4)] = cljs.core.rest((state_34277[(4)])));

return statearr_34288;
})();
var state_34277__$1 = state_34277;
var statearr_34289_34307 = state_34277__$1;
(statearr_34289_34307[(2)] = inst_34272);

(statearr_34289_34307[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34278 === (9))){
var inst_34262 = (state_34277[(9)]);
var inst_34260 = (state_34277[(2)]);
var inst_34261 = fluree.db.util.async.throw_err(inst_34260);
var inst_34262__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_34261);
var inst_34263 = fluree.db.query.schema.schema_map(inst_34262__$1);
var state_34277__$1 = (function (){var statearr_34290 = state_34277;
(statearr_34290[(9)] = inst_34262__$1);

return statearr_34290;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34277__$1,(10),inst_34263);
} else {
if((state_val_34278 === (5))){
var _ = (function (){var statearr_34291 = state_34277;
(statearr_34291[(4)] = cljs.core.rest((state_34277[(4)])));

return statearr_34291;
})();
var state_34277__$1 = state_34277;
var ex34287 = (state_34277__$1[(2)]);
var statearr_34292_34308 = state_34277__$1;
(statearr_34292_34308[(5)] = ex34287);


if((ex34287 instanceof Error)){
var statearr_34293_34309 = state_34277__$1;
(statearr_34293_34309[(1)] = (4));

(statearr_34293_34309[(5)] = null);

} else {
throw ex34287;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34278 === (10))){
var inst_34262 = (state_34277[(9)]);
var inst_34267 = (state_34277[(8)]);
var inst_34265 = (state_34277[(2)]);
var inst_34266 = fluree.db.util.async.throw_err(inst_34265);
var inst_34267__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34262,cljs.core.cst$kw$schema,inst_34266);
var inst_34268 = fluree.db.query.schema.setting_map(inst_34267__$1);
var state_34277__$1 = (function (){var statearr_34294 = state_34277;
(statearr_34294[(8)] = inst_34267__$1);

return statearr_34294;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34277__$1,(11),inst_34268);
} else {
if((state_val_34278 === (8))){
var inst_34248 = (state_34277[(7)]);
var inst_34258 = (state_34277[(2)]);
var state_34277__$1 = (function (){var statearr_34295 = state_34277;
(statearr_34295[(10)] = inst_34258);

return statearr_34295;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34277__$1,(9),inst_34248);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__16395__auto____0 = (function (){
var statearr_34296 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34296[(0)] = fluree$db$storage$core$reify_db_$_state_machine__16395__auto__);

(statearr_34296[(1)] = (1));

return statearr_34296;
});
var fluree$db$storage$core$reify_db_$_state_machine__16395__auto____1 = (function (state_34277){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34277);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34297){var ex__16398__auto__ = e34297;
var statearr_34298_34310 = state_34277;
(statearr_34298_34310[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34277[(4)]))){
var statearr_34299_34311 = state_34277;
(statearr_34299_34311[(1)] = cljs.core.first((state_34277[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34312 = state_34277;
state_34277 = G__34312;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__16395__auto__ = function(state_34277){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__16395__auto____1.call(this,state_34277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__16395__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__16395__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34300 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34300[(6)] = c__16469__auto__);

return statearr_34300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__34314 = arguments.length;
switch (G__34314) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34367){
var state_val_34368 = (state_34367[(1)]);
if((state_val_34368 === (7))){
var inst_34324 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_34325 = (new Error(inst_34324));
var inst_34326 = (function(){throw inst_34325})();
var state_34367__$1 = state_34367;
var statearr_34369_34409 = state_34367__$1;
(statearr_34369_34409[(2)] = inst_34326);

(statearr_34369_34409[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (20))){
var inst_34358 = (state_34367[(2)]);
var state_34367__$1 = state_34367;
var statearr_34370_34410 = state_34367__$1;
(statearr_34370_34410[(2)] = inst_34358);

(statearr_34370_34410[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (1))){
var state_34367__$1 = state_34367;
var statearr_34371_34411 = state_34367__$1;
(statearr_34371_34411[(2)] = null);

(statearr_34371_34411[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (4))){
var inst_34315 = (state_34367[(2)]);
var state_34367__$1 = state_34367;
var statearr_34372_34412 = state_34367__$1;
(statearr_34372_34412[(2)] = inst_34315);

(statearr_34372_34412[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (15))){
var inst_34333 = (state_34367[(7)]);
var state_34367__$1 = state_34367;
var statearr_34373_34413 = state_34367__$1;
(statearr_34373_34413[(2)] = inst_34333);

(statearr_34373_34413[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (21))){
var inst_34337 = (state_34367[(8)]);
var inst_34332 = (state_34367[(9)]);
var inst_34333 = (state_34367[(7)]);
var inst_34351 = (inst_34332 + (1));
var inst_34352 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34333,inst_34337);
var inst_34332__$1 = inst_34351;
var inst_34333__$1 = inst_34352;
var state_34367__$1 = (function (){var statearr_34374 = state_34367;
(statearr_34374[(9)] = inst_34332__$1);

(statearr_34374[(7)] = inst_34333__$1);

return statearr_34374;
})();
var statearr_34375_34414 = state_34367__$1;
(statearr_34375_34414[(2)] = null);

(statearr_34375_34414[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (13))){
var inst_34337 = (state_34367[(8)]);
var inst_34341 = (inst_34337 instanceof Error);
var state_34367__$1 = state_34367;
var statearr_34376_34415 = state_34367__$1;
(statearr_34376_34415[(2)] = inst_34341);

(statearr_34376_34415[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (22))){
var state_34367__$1 = state_34367;
var statearr_34377_34416 = state_34367__$1;
(statearr_34377_34416[(2)] = null);

(statearr_34377_34416[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (6))){
var state_34367__$1 = state_34367;
var statearr_34378_34417 = state_34367__$1;
(statearr_34378_34417[(2)] = null);

(statearr_34378_34417[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (17))){
var inst_34360 = (state_34367[(2)]);
var state_34367__$1 = state_34367;
var statearr_34379_34418 = state_34367__$1;
(statearr_34379_34418[(2)] = inst_34360);

(statearr_34379_34418[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (3))){
var inst_34365 = (state_34367[(2)]);
var state_34367__$1 = state_34367;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34367__$1,inst_34365);
} else {
if((state_val_34368 === (12))){
var inst_34338 = (state_34367[(10)]);
var state_34367__$1 = state_34367;
var statearr_34380_34419 = state_34367__$1;
(statearr_34380_34419[(2)] = inst_34338);

(statearr_34380_34419[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (2))){
var _ = (function (){var statearr_34381 = state_34367;
(statearr_34381[(4)] = cljs.core.cons((5),(state_34367[(4)])));

return statearr_34381;
})();
var inst_34321 = (end >= start);
var state_34367__$1 = state_34367;
if(cljs.core.truth_(inst_34321)){
var statearr_34382_34420 = state_34367__$1;
(statearr_34382_34420[(1)] = (6));

} else {
var statearr_34383_34421 = state_34367__$1;
(statearr_34383_34421[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (23))){
var inst_34356 = (state_34367[(2)]);
var state_34367__$1 = state_34367;
var statearr_34384_34422 = state_34367__$1;
(statearr_34384_34422[(2)] = inst_34356);

(statearr_34384_34422[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (19))){
var state_34367__$1 = state_34367;
var statearr_34385_34423 = state_34367__$1;
(statearr_34385_34423[(1)] = (21));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (11))){
var inst_34337 = (state_34367[(8)]);
var inst_34338 = (state_34367[(10)]);
var inst_34337__$1 = (state_34367[(2)]);
var inst_34338__$1 = (inst_34337__$1 == null);
var state_34367__$1 = (function (){var statearr_34388 = state_34367;
(statearr_34388[(8)] = inst_34337__$1);

(statearr_34388[(10)] = inst_34338__$1);

return statearr_34388;
})();
if(cljs.core.truth_(inst_34338__$1)){
var statearr_34389_34424 = state_34367__$1;
(statearr_34389_34424[(1)] = (12));

} else {
var statearr_34390_34425 = state_34367__$1;
(statearr_34390_34425[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (9))){
var inst_34332 = (state_34367[(9)]);
var inst_34335 = fluree.db.storage.core.read_block(conn,network,dbid,inst_34332);
var state_34367__$1 = state_34367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34367__$1,(11),inst_34335);
} else {
if((state_val_34368 === (5))){
var _ = (function (){var statearr_34391 = state_34367;
(statearr_34391[(4)] = cljs.core.rest((state_34367[(4)])));

return statearr_34391;
})();
var state_34367__$1 = state_34367;
var ex34387 = (state_34367__$1[(2)]);
var statearr_34392_34426 = state_34367__$1;
(statearr_34392_34426[(5)] = ex34387);


if((ex34387 instanceof Error)){
var statearr_34393_34427 = state_34367__$1;
(statearr_34393_34427[(1)] = (4));

(statearr_34393_34427[(5)] = null);

} else {
throw ex34387;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (14))){
var inst_34343 = (state_34367[(2)]);
var state_34367__$1 = state_34367;
if(cljs.core.truth_(inst_34343)){
var statearr_34394_34428 = state_34367__$1;
(statearr_34394_34428[(1)] = (15));

} else {
var statearr_34395_34429 = state_34367__$1;
(statearr_34395_34429[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (16))){
var inst_34332 = (state_34367[(9)]);
var inst_34346 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34332,end);
var state_34367__$1 = state_34367;
if(inst_34346){
var statearr_34396_34430 = state_34367__$1;
(statearr_34396_34430[(1)] = (18));

} else {
var statearr_34397_34431 = state_34367__$1;
(statearr_34397_34431[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (10))){
var inst_34362 = (state_34367[(2)]);
var _ = (function (){var statearr_34398 = state_34367;
(statearr_34398[(4)] = cljs.core.rest((state_34367[(4)])));

return statearr_34398;
})();
var state_34367__$1 = state_34367;
var statearr_34399_34432 = state_34367__$1;
(statearr_34399_34432[(2)] = inst_34362);

(statearr_34399_34432[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (18))){
var inst_34337 = (state_34367[(8)]);
var inst_34333 = (state_34367[(7)]);
var inst_34348 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34333,inst_34337);
var state_34367__$1 = state_34367;
var statearr_34400_34433 = state_34367__$1;
(statearr_34400_34433[(2)] = inst_34348);

(statearr_34400_34433[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34368 === (8))){
var inst_34328 = (state_34367[(2)]);
var inst_34329 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_34330 = start;
var inst_34331 = cljs.core.PersistentVector.EMPTY;
var inst_34332 = inst_34330;
var inst_34333 = inst_34331;
var state_34367__$1 = (function (){var statearr_34401 = state_34367;
(statearr_34401[(9)] = inst_34332);

(statearr_34401[(7)] = inst_34333);

(statearr_34401[(11)] = inst_34328);

(statearr_34401[(12)] = inst_34329);

return statearr_34401;
})();
var statearr_34402_34434 = state_34367__$1;
(statearr_34402_34434[(2)] = null);

(statearr_34402_34434[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__16395__auto__ = null;
var fluree$db$storage$core$state_machine__16395__auto____0 = (function (){
var statearr_34403 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34403[(0)] = fluree$db$storage$core$state_machine__16395__auto__);

(statearr_34403[(1)] = (1));

return statearr_34403;
});
var fluree$db$storage$core$state_machine__16395__auto____1 = (function (state_34367){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34367);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34404){var ex__16398__auto__ = e34404;
var statearr_34405_34435 = state_34367;
(statearr_34405_34435[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34367[(4)]))){
var statearr_34406_34436 = state_34367;
(statearr_34406_34436[(1)] = cljs.core.first((state_34367[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34437 = state_34367;
state_34367 = G__34437;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__16395__auto__ = function(state_34367){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__16395__auto____1.call(this,state_34367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__16395__auto____0;
fluree$db$storage$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__16395__auto____1;
return fluree$db$storage$core$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34407 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34407[(6)] = c__16469__auto__);

return statearr_34407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34453){
var state_val_34454 = (state_34453[(1)]);
if((state_val_34454 === (1))){
var state_34453__$1 = state_34453;
var statearr_34455_34469 = state_34453__$1;
(statearr_34455_34469[(2)] = null);

(statearr_34455_34469[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34454 === (2))){
var _ = (function (){var statearr_34456 = state_34453;
(statearr_34456[(4)] = cljs.core.cons((5),(state_34453[(4)])));

return statearr_34456;
})();
var inst_34444 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_34453__$1 = state_34453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34453__$1,(6),inst_34444);
} else {
if((state_val_34454 === (3))){
var inst_34451 = (state_34453[(2)]);
var state_34453__$1 = state_34453;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34453__$1,inst_34451);
} else {
if((state_val_34454 === (4))){
var inst_34438 = (state_34453[(2)]);
var state_34453__$1 = state_34453;
var statearr_34458_34470 = state_34453__$1;
(statearr_34458_34470[(2)] = inst_34438);

(statearr_34458_34470[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34454 === (5))){
var _ = (function (){var statearr_34459 = state_34453;
(statearr_34459[(4)] = cljs.core.rest((state_34453[(4)])));

return statearr_34459;
})();
var state_34453__$1 = state_34453;
var ex34457 = (state_34453__$1[(2)]);
var statearr_34460_34471 = state_34453__$1;
(statearr_34460_34471[(5)] = ex34457);


if((ex34457 instanceof Error)){
var statearr_34461_34472 = state_34453__$1;
(statearr_34461_34472[(1)] = (4));

(statearr_34461_34472[(5)] = null);

} else {
throw ex34457;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34454 === (6))){
var inst_34446 = (state_34453[(2)]);
var inst_34447 = fluree.db.util.async.throw_err(inst_34446);
var inst_34448 = cljs.core.first(inst_34447);
var _ = (function (){var statearr_34462 = state_34453;
(statearr_34462[(4)] = cljs.core.rest((state_34453[(4)])));

return statearr_34462;
})();
var state_34453__$1 = state_34453;
var statearr_34463_34473 = state_34453__$1;
(statearr_34463_34473[(2)] = inst_34448);

(statearr_34463_34473[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__16395__auto____0 = (function (){
var statearr_34464 = [null,null,null,null,null,null,null];
(statearr_34464[(0)] = fluree$db$storage$core$block_$_state_machine__16395__auto__);

(statearr_34464[(1)] = (1));

return statearr_34464;
});
var fluree$db$storage$core$block_$_state_machine__16395__auto____1 = (function (state_34453){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34453);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34465){var ex__16398__auto__ = e34465;
var statearr_34466_34474 = state_34453;
(statearr_34466_34474[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34453[(4)]))){
var statearr_34467_34475 = state_34453;
(statearr_34467_34475[(1)] = cljs.core.first((state_34453[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34476 = state_34453;
state_34453 = G__34476;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__16395__auto__ = function(state_34453){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__16395__auto____1.call(this,state_34453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__16395__auto____0;
fluree$db$storage$core$block_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__16395__auto____1;
return fluree$db$storage$core$block_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34468 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34468[(6)] = c__16469__auto__);

return statearr_34468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
