// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k43615,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__43619 = k43615;
var G__43619__$1 = (((G__43619 instanceof cljs.core.Keyword))?G__43619.fqn:null);
switch (G__43619__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k43615,else__4464__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__43620){
var vec__43621 = p__43620;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43621,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43621,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__43614){
var self__ = this;
var G__43614__$1 = this;
return (new cljs.core.RecordIter((0),G__43614__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__43624 = (function (coll__4458__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__43624(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this43616,other43617){
var self__ = this;
var this43616__$1 = this;
return (((!((other43617 == null)))) && ((((this43616__$1.constructor === other43617.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43616__$1.conn,other43617.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43616__$1.network,other43617.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43616__$1.dbid,other43617.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43616__$1.db_name,other43617.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43616__$1.update_chan,other43617.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43616__$1.transact_chan,other43617.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43616__$1.state,other43617.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43616__$1.schema_cache,other43617.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43616__$1.blank_db,other43617.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43616__$1.close,other43617.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43616__$1.id,other43617.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43616__$1.__extmap,other43617.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k43615){
var self__ = this;
var this__4468__auto____$1 = this;
var G__43625 = k43615;
var G__43625__$1 = (((G__43625 instanceof cljs.core.Keyword))?G__43625.fqn:null);
switch (G__43625__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k43615);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__43614){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__43626 = cljs.core.keyword_identical_QMARK_;
var expr__43627 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__43629 = cljs.core.cst$kw$conn;
var G__43630 = expr__43627;
return (pred__43626.cljs$core$IFn$_invoke$arity$2 ? pred__43626.cljs$core$IFn$_invoke$arity$2(G__43629,G__43630) : pred__43626.call(null,G__43629,G__43630));
})())){
return (new fluree.db.session.DbSession(G__43614,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43631 = cljs.core.cst$kw$network;
var G__43632 = expr__43627;
return (pred__43626.cljs$core$IFn$_invoke$arity$2 ? pred__43626.cljs$core$IFn$_invoke$arity$2(G__43631,G__43632) : pred__43626.call(null,G__43631,G__43632));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__43614,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43633 = cljs.core.cst$kw$dbid;
var G__43634 = expr__43627;
return (pred__43626.cljs$core$IFn$_invoke$arity$2 ? pred__43626.cljs$core$IFn$_invoke$arity$2(G__43633,G__43634) : pred__43626.call(null,G__43633,G__43634));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__43614,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43635 = cljs.core.cst$kw$db_DASH_name;
var G__43636 = expr__43627;
return (pred__43626.cljs$core$IFn$_invoke$arity$2 ? pred__43626.cljs$core$IFn$_invoke$arity$2(G__43635,G__43636) : pred__43626.call(null,G__43635,G__43636));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__43614,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43637 = cljs.core.cst$kw$update_DASH_chan;
var G__43638 = expr__43627;
return (pred__43626.cljs$core$IFn$_invoke$arity$2 ? pred__43626.cljs$core$IFn$_invoke$arity$2(G__43637,G__43638) : pred__43626.call(null,G__43637,G__43638));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__43614,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43639 = cljs.core.cst$kw$transact_DASH_chan;
var G__43640 = expr__43627;
return (pred__43626.cljs$core$IFn$_invoke$arity$2 ? pred__43626.cljs$core$IFn$_invoke$arity$2(G__43639,G__43640) : pred__43626.call(null,G__43639,G__43640));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__43614,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43641 = cljs.core.cst$kw$state;
var G__43642 = expr__43627;
return (pred__43626.cljs$core$IFn$_invoke$arity$2 ? pred__43626.cljs$core$IFn$_invoke$arity$2(G__43641,G__43642) : pred__43626.call(null,G__43641,G__43642));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__43614,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43643 = cljs.core.cst$kw$schema_DASH_cache;
var G__43644 = expr__43627;
return (pred__43626.cljs$core$IFn$_invoke$arity$2 ? pred__43626.cljs$core$IFn$_invoke$arity$2(G__43643,G__43644) : pred__43626.call(null,G__43643,G__43644));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__43614,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43645 = cljs.core.cst$kw$blank_DASH_db;
var G__43646 = expr__43627;
return (pred__43626.cljs$core$IFn$_invoke$arity$2 ? pred__43626.cljs$core$IFn$_invoke$arity$2(G__43645,G__43646) : pred__43626.call(null,G__43645,G__43646));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__43614,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43647 = cljs.core.cst$kw$close;
var G__43648 = expr__43627;
return (pred__43626.cljs$core$IFn$_invoke$arity$2 ? pred__43626.cljs$core$IFn$_invoke$arity$2(G__43647,G__43648) : pred__43626.call(null,G__43647,G__43648));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__43614,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43649 = cljs.core.cst$kw$id;
var G__43650 = expr__43627;
return (pred__43626.cljs$core$IFn$_invoke$arity$2 ? pred__43626.cljs$core$IFn$_invoke$arity$2(G__43649,G__43650) : pred__43626.call(null,G__43649,G__43650));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__43614,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__43614),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__43614){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__43614,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__43618){
var extmap__4501__auto__ = (function (){var G__43651 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__43618,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__43618)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__43651);
} else {
return G__43651;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__43618),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__43618),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__43618),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__43618),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__43618),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__43618),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__43618),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__43618),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__43618),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__43618),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__43618),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__43654 = session;
var map__43654__$1 = cljs.core.__destructure_map(map__43654);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43654__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43654__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___43806 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43758){
var state_val_43759 = (state_43758[(1)]);
if((state_val_43759 === (7))){
var inst_43675 = (state_43758[(7)]);
var inst_43680 = cljs.core.empty_QMARK_(inst_43675);
var state_43758__$1 = state_43758;
if(inst_43680){
var statearr_43760_43807 = state_43758__$1;
(statearr_43760_43807[(1)] = (10));

} else {
var statearr_43761_43808 = state_43758__$1;
(statearr_43761_43808[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (20))){
var inst_43668 = (state_43758[(8)]);
var inst_43667 = (state_43758[(9)]);
var inst_43706 = (state_43758[(10)]);
var inst_43666 = (state_43758[(11)]);
var inst_43711 = fluree.db.storage.core.read_block(inst_43666,inst_43667,inst_43668,inst_43706);
var state_43758__$1 = state_43758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43758__$1,(22),inst_43711);
} else {
if((state_val_43759 === (27))){
var inst_43747 = (state_43758[(12)]);
var inst_43742 = (state_43758[(13)]);
var inst_43745 = (state_43758[(2)]);
var inst_43746 = fluree.db.util.async.throw_err(inst_43745);
var inst_43747__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43742,cljs.core.cst$kw$schema,inst_43746);
var inst_43748 = fluree.db.query.schema.setting_map(inst_43747__$1);
var state_43758__$1 = (function (){var statearr_43762 = state_43758;
(statearr_43762[(12)] = inst_43747__$1);

return statearr_43762;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43758__$1,(28),inst_43748);
} else {
if((state_val_43759 === (1))){
var state_43758__$1 = state_43758;
var statearr_43763_43809 = state_43758__$1;
(statearr_43763_43809[(2)] = null);

(statearr_43763_43809[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (24))){
var inst_43668 = (state_43758[(8)]);
var inst_43667 = (state_43758[(9)]);
var inst_43706 = (state_43758[(10)]);
var inst_43728 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43706)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43667),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43668),"."].join('');
var inst_43729 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43730 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_43731 = cljs.core.PersistentHashMap.fromArrays(inst_43729,inst_43730);
var inst_43732 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43728,inst_43731);
var inst_43733 = (function(){throw inst_43732})();
var state_43758__$1 = state_43758;
var statearr_43764_43810 = state_43758__$1;
(statearr_43764_43810[(2)] = inst_43733);

(statearr_43764_43810[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (4))){
var inst_43655 = (state_43758[(2)]);
var inst_43656 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_43655);
var state_43758__$1 = state_43758;
var statearr_43765_43811 = state_43758__$1;
(statearr_43765_43811[(2)] = inst_43656);

(statearr_43765_43811[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (15))){
var state_43758__$1 = state_43758;
var statearr_43766_43812 = state_43758__$1;
(statearr_43766_43812[(2)] = null);

(statearr_43766_43812[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (21))){
var inst_43737 = (state_43758[(2)]);
var state_43758__$1 = state_43758;
var statearr_43767_43813 = state_43758__$1;
(statearr_43767_43813[(2)] = inst_43737);

(statearr_43767_43813[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (13))){
var inst_43675 = (state_43758[(7)]);
var inst_43700 = (state_43758[(14)]);
var inst_43699 = (state_43758[(2)]);
var inst_43700__$1 = fluree.db.util.async.throw_err(inst_43699);
var inst_43701 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_43675);
var state_43758__$1 = (function (){var statearr_43768 = state_43758;
(statearr_43768[(15)] = inst_43701);

(statearr_43768[(14)] = inst_43700__$1);

return statearr_43768;
})();
if(cljs.core.truth_(inst_43700__$1)){
var statearr_43769_43814 = state_43758__$1;
(statearr_43769_43814[(1)] = (14));

} else {
var statearr_43770_43815 = state_43758__$1;
(statearr_43770_43815[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (22))){
var inst_43714 = (state_43758[(16)]);
var inst_43713 = (state_43758[(2)]);
var inst_43714__$1 = fluree.db.util.async.throw_err(inst_43713);
var state_43758__$1 = (function (){var statearr_43771 = state_43758;
(statearr_43771[(16)] = inst_43714__$1);

return statearr_43771;
})();
if(cljs.core.truth_(inst_43714__$1)){
var statearr_43772_43816 = state_43758__$1;
(statearr_43772_43816[(1)] = (23));

} else {
var statearr_43773_43817 = state_43758__$1;
(statearr_43773_43817[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (6))){
var inst_43675 = (state_43758[(7)]);
var inst_43674 = (state_43758[(2)]);
var inst_43675__$1 = fluree.db.util.async.throw_err(inst_43674);
var inst_43676 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_43675__$1);
var inst_43677 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_43676);
var inst_43678 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_43677);
var state_43758__$1 = (function (){var statearr_43774 = state_43758;
(statearr_43774[(7)] = inst_43675__$1);

return statearr_43774;
})();
if(inst_43678){
var statearr_43775_43818 = state_43758__$1;
(statearr_43775_43818[(1)] = (7));

} else {
var statearr_43776_43819 = state_43758__$1;
(statearr_43776_43819[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (28))){
var inst_43747 = (state_43758[(12)]);
var inst_43750 = (state_43758[(2)]);
var inst_43751 = fluree.db.util.async.throw_err(inst_43750);
var inst_43752 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43747,cljs.core.cst$kw$settings,inst_43751);
var inst_43753 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_43752);
var _ = (function (){var statearr_43777 = state_43758;
(statearr_43777[(4)] = cljs.core.rest((state_43758[(4)])));

return statearr_43777;
})();
var state_43758__$1 = state_43758;
var statearr_43778_43820 = state_43758__$1;
(statearr_43778_43820[(2)] = inst_43753);

(statearr_43778_43820[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (25))){
var inst_43735 = (state_43758[(2)]);
var state_43758__$1 = state_43758;
var statearr_43779_43821 = state_43758__$1;
(statearr_43779_43821[(2)] = inst_43735);

(statearr_43779_43821[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (17))){
var inst_43701 = (state_43758[(15)]);
var inst_43706 = (state_43758[(10)]);
var inst_43708 = (inst_43706 > inst_43701);
var state_43758__$1 = state_43758;
if(cljs.core.truth_(inst_43708)){
var statearr_43780_43822 = state_43758__$1;
(statearr_43780_43822[(1)] = (19));

} else {
var statearr_43781_43823 = state_43758__$1;
(statearr_43781_43823[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (3))){
var inst_43756 = (state_43758[(2)]);
var state_43758__$1 = state_43758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43758__$1,inst_43756);
} else {
if((state_val_43759 === (12))){
var inst_43687 = (state_43758[(2)]);
var inst_43688 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43689 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_43690 = cljs.core.PersistentHashMap.fromArrays(inst_43688,inst_43689);
var inst_43691 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43687,inst_43690);
var inst_43692 = (function(){throw inst_43691})();
var state_43758__$1 = state_43758;
var statearr_43782_43824 = state_43758__$1;
(statearr_43782_43824[(2)] = inst_43692);

(statearr_43782_43824[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (2))){
var inst_43668 = (state_43758[(8)]);
var inst_43667 = (state_43758[(9)]);
var inst_43666 = (state_43758[(11)]);
var _ = (function (){var statearr_43783 = state_43758;
(statearr_43783[(4)] = cljs.core.cons((5),(state_43758[(4)])));

return statearr_43783;
})();
var inst_43663 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_43664 = session;
var inst_43665 = cljs.core.__destructure_map(inst_43664);
var inst_43666__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43665,cljs.core.cst$kw$conn);
var inst_43667__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43665,cljs.core.cst$kw$network);
var inst_43668__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43665,cljs.core.cst$kw$dbid);
var inst_43669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43670 = [inst_43667__$1,inst_43668__$1];
var inst_43671 = (new cljs.core.PersistentVector(null,2,(5),inst_43669,inst_43670,null));
var inst_43672 = fluree.db.operations.ledger_info_async(inst_43666__$1,inst_43671);
var state_43758__$1 = (function (){var statearr_43784 = state_43758;
(statearr_43784[(8)] = inst_43668__$1);

(statearr_43784[(17)] = inst_43663);

(statearr_43784[(9)] = inst_43667__$1);

(statearr_43784[(11)] = inst_43666__$1);

return statearr_43784;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43758__$1,(6),inst_43672);
} else {
if((state_val_43759 === (23))){
var inst_43705 = (state_43758[(18)]);
var inst_43714 = (state_43758[(16)]);
var inst_43717 = cljs.core.__destructure_map(inst_43714);
var inst_43718 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43717,cljs.core.cst$kw$flakes);
var inst_43719 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43717,cljs.core.cst$kw$block);
var inst_43720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43717,cljs.core.cst$kw$t);
var inst_43721 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_43705,inst_43719,inst_43718);
var state_43758__$1 = (function (){var statearr_43785 = state_43758;
(statearr_43785[(19)] = inst_43720);

return statearr_43785;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43758__$1,(26),inst_43721);
} else {
if((state_val_43759 === (19))){
var inst_43705 = (state_43758[(18)]);
var state_43758__$1 = state_43758;
var statearr_43786_43825 = state_43758__$1;
(statearr_43786_43825[(2)] = inst_43705);

(statearr_43786_43825[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (11))){
var inst_43675 = (state_43758[(7)]);
var inst_43668 = (state_43758[(8)]);
var inst_43667 = (state_43758[(9)]);
var inst_43684 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_43675);
var inst_43685 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43667),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43668)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43684),"."].join('');
var state_43758__$1 = state_43758;
var statearr_43788_43826 = state_43758__$1;
(statearr_43788_43826[(2)] = inst_43685);

(statearr_43788_43826[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (9))){
var inst_43675 = (state_43758[(7)]);
var inst_43668 = (state_43758[(8)]);
var inst_43663 = (state_43758[(17)]);
var inst_43667 = (state_43758[(9)]);
var inst_43666 = (state_43758[(11)]);
var inst_43695 = (state_43758[(2)]);
var inst_43696 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_43675);
var inst_43697 = fluree.db.storage.core.reify_db(inst_43666,inst_43667,inst_43668,inst_43663,inst_43696);
var state_43758__$1 = (function (){var statearr_43789 = state_43758;
(statearr_43789[(20)] = inst_43695);

return statearr_43789;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43758__$1,(13),inst_43697);
} else {
if((state_val_43759 === (5))){
var _ = (function (){var statearr_43790 = state_43758;
(statearr_43790[(4)] = cljs.core.rest((state_43758[(4)])));

return statearr_43790;
})();
var state_43758__$1 = state_43758;
var ex43787 = (state_43758__$1[(2)]);
var statearr_43791_43827 = state_43758__$1;
(statearr_43791_43827[(5)] = ex43787);


var statearr_43792_43828 = state_43758__$1;
(statearr_43792_43828[(1)] = (4));

(statearr_43792_43828[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (14))){
var inst_43700 = (state_43758[(14)]);
var inst_43703 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_43700);
var inst_43704 = (inst_43703 + (1));
var inst_43705 = inst_43700;
var inst_43706 = inst_43704;
var state_43758__$1 = (function (){var statearr_43793 = state_43758;
(statearr_43793[(18)] = inst_43705);

(statearr_43793[(10)] = inst_43706);

return statearr_43793;
})();
var statearr_43794_43829 = state_43758__$1;
(statearr_43794_43829[(2)] = null);

(statearr_43794_43829[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (26))){
var inst_43706 = (state_43758[(10)]);
var inst_43723 = (state_43758[(2)]);
var inst_43724 = fluree.db.util.async.throw_err(inst_43723);
var inst_43725 = (inst_43706 + (1));
var inst_43705 = inst_43724;
var inst_43706__$1 = inst_43725;
var state_43758__$1 = (function (){var statearr_43795 = state_43758;
(statearr_43795[(18)] = inst_43705);

(statearr_43795[(10)] = inst_43706__$1);

return statearr_43795;
})();
var statearr_43796_43830 = state_43758__$1;
(statearr_43796_43830[(2)] = null);

(statearr_43796_43830[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (16))){
var inst_43742 = (state_43758[(13)]);
var inst_43742__$1 = (state_43758[(2)]);
var inst_43743 = fluree.db.query.schema.schema_map(inst_43742__$1);
var state_43758__$1 = (function (){var statearr_43797 = state_43758;
(statearr_43797[(13)] = inst_43742__$1);

return statearr_43797;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43758__$1,(27),inst_43743);
} else {
if((state_val_43759 === (10))){
var inst_43668 = (state_43758[(8)]);
var inst_43667 = (state_43758[(9)]);
var inst_43682 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43667),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43668)," is not found on this ledger group."].join('');
var state_43758__$1 = state_43758;
var statearr_43798_43831 = state_43758__$1;
(statearr_43798_43831[(2)] = inst_43682);

(statearr_43798_43831[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (18))){
var inst_43739 = (state_43758[(2)]);
var state_43758__$1 = state_43758;
var statearr_43799_43832 = state_43758__$1;
(statearr_43799_43832[(2)] = inst_43739);

(statearr_43799_43832[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43759 === (8))){
var state_43758__$1 = state_43758;
var statearr_43800_43833 = state_43758__$1;
(statearr_43800_43833[(2)] = null);

(statearr_43800_43833[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__16395__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__16395__auto____0 = (function (){
var statearr_43801 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43801[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__16395__auto__);

(statearr_43801[(1)] = (1));

return statearr_43801;
});
var fluree$db$session$full_load_existing_db_$_state_machine__16395__auto____1 = (function (state_43758){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43758);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43802){var ex__16398__auto__ = e43802;
var statearr_43803_43834 = state_43758;
(statearr_43803_43834[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43758[(4)]))){
var statearr_43804_43835 = state_43758;
(statearr_43804_43835[(1)] = cljs.core.first((state_43758[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43836 = state_43758;
state_43758 = G__43836;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__16395__auto__ = function(state_43758){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__16395__auto____1.call(this,state_43758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__16395__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__16395__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43805 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43805[(6)] = c__16469__auto___43806);

return statearr_43805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__43837 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__43837,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__43837;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__43838 = cljs.core.get_global_hierarchy;
return (fexpr__43838.cljs$core$IFn$_invoke$arity$0 ? fexpr__43838.cljs$core$IFn$_invoke$arity$0() : fexpr__43838.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_ledger_DASH_update,(function (_,___$1,___$2){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43840){
var state_val_43841 = (state_43840[(1)]);
if((state_val_43841 === (1))){
var state_43840__$1 = state_43840;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43840__$1,cljs.core.cst$kw$fluree$db$session_SLASH_no_DASH_op);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__16395__auto__ = null;
var fluree$db$session$state_machine__16395__auto____0 = (function (){
var statearr_43842 = [null,null,null,null,null,null,null];
(statearr_43842[(0)] = fluree$db$session$state_machine__16395__auto__);

(statearr_43842[(1)] = (1));

return statearr_43842;
});
var fluree$db$session$state_machine__16395__auto____1 = (function (state_43840){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43840);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43843){var ex__16398__auto__ = e43843;
var statearr_43844_43847 = state_43840;
(statearr_43844_43847[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43840[(4)]))){
var statearr_43845_43848 = state_43840;
(statearr_43845_43848[(1)] = cljs.core.first((state_43840[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43849 = state_43840;
state_43840 = G__43849;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$session$state_machine__16395__auto__ = function(state_43840){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16395__auto____1.call(this,state_43840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16395__auto____0;
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16395__auto____1;
return fluree$db$session$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43846 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43846[(6)] = c__16469__auto__);

return statearr_43846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__43851){
var map__43852 = p__43851;
var map__43852__$1 = cljs.core.__destructure_map(map__43852);
var data = map__43852__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43852__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43852__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43852__$1,cljs.core.cst$kw$flakes);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43911){
var state_val_43912 = (state_43911[(1)]);
if((state_val_43912 === (7))){
var inst_43866 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43867 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43868 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43866),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43867),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_43869 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43868], 0));
var state_43911__$1 = state_43911;
var statearr_43913_43951 = state_43911__$1;
(statearr_43913_43951[(2)] = inst_43869);

(statearr_43913_43951[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (1))){
var state_43911__$1 = state_43911;
var statearr_43914_43952 = state_43911__$1;
(statearr_43914_43952[(2)] = null);

(statearr_43914_43952[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (4))){
var inst_43853 = (state_43911[(2)]);
var state_43911__$1 = state_43911;
var statearr_43915_43953 = state_43911__$1;
(statearr_43915_43953[(2)] = inst_43853);

(statearr_43915_43953[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (15))){
var inst_43892 = (state_43911[(2)]);
var state_43911__$1 = state_43911;
var statearr_43916_43954 = state_43911__$1;
(statearr_43916_43954[(2)] = inst_43892);

(statearr_43916_43954[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (13))){
var inst_43883 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var inst_43884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43885 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43886 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43887 = [inst_43885,inst_43886];
var inst_43888 = (new cljs.core.PersistentVector(null,2,(5),inst_43884,inst_43887,null));
var inst_43889 = (function (){var G__43917 = inst_43883;
var G__43918 = cljs.core.cst$kw$local_DASH_ledger_DASH_update;
var G__43919 = inst_43888;
var G__43920 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__43917,G__43918,G__43919,G__43920) : fluree.db.conn_events.process_event.call(null,G__43917,G__43918,G__43919,G__43920));
})();
var state_43911__$1 = state_43911;
var statearr_43921_43955 = state_43911__$1;
(statearr_43921_43955[(2)] = inst_43889);

(statearr_43921_43955[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (6))){
var inst_43862 = (state_43911[(7)]);
var inst_43863 = (state_43911[(8)]);
var inst_43861 = (state_43911[(2)]);
var inst_43862__$1 = fluree.db.util.async.throw_err(inst_43861);
var inst_43863__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_43862__$1);
var inst_43864 = (block <= inst_43863__$1);
var state_43911__$1 = (function (){var statearr_43922 = state_43911;
(statearr_43922[(7)] = inst_43862__$1);

(statearr_43922[(8)] = inst_43863__$1);

return statearr_43922;
})();
if(cljs.core.truth_(inst_43864)){
var statearr_43923_43956 = state_43911__$1;
(statearr_43923_43956[(1)] = (7));

} else {
var statearr_43924_43957 = state_43911__$1;
(statearr_43924_43957[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (17))){
var state_43911__$1 = state_43911;
var statearr_43925_43958 = state_43911__$1;
(statearr_43925_43958[(2)] = null);

(statearr_43925_43958[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (3))){
var inst_43909 = (state_43911[(2)]);
var state_43911__$1 = state_43911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43911__$1,inst_43909);
} else {
if((state_val_43912 === (12))){
var inst_43904 = (state_43911[(2)]);
var state_43911__$1 = state_43911;
var statearr_43926_43959 = state_43911__$1;
(statearr_43926_43959[(2)] = inst_43904);

(statearr_43926_43959[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (2))){
var inst_43859 = (state_43911[(9)]);
var _ = (function (){var statearr_43927 = state_43911;
(statearr_43927[(4)] = cljs.core.cons((5),(state_43911[(4)])));

return statearr_43927;
})();
var inst_43859__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_43911__$1 = (function (){var statearr_43928 = state_43911;
(statearr_43928[(9)] = inst_43859__$1);

return statearr_43928;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43911__$1,(6),inst_43859__$1);
} else {
if((state_val_43912 === (11))){
var state_43911__$1 = state_43911;
var statearr_43930_43960 = state_43911__$1;
(statearr_43930_43960[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (9))){
var inst_43906 = (state_43911[(2)]);
var _ = (function (){var statearr_43932 = state_43911;
(statearr_43932[(4)] = cljs.core.rest((state_43911[(4)])));

return statearr_43932;
})();
var state_43911__$1 = state_43911;
var statearr_43933_43961 = state_43911__$1;
(statearr_43933_43961[(2)] = inst_43906);

(statearr_43933_43961[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (5))){
var _ = (function (){var statearr_43934 = state_43911;
(statearr_43934[(4)] = cljs.core.rest((state_43911[(4)])));

return statearr_43934;
})();
var state_43911__$1 = state_43911;
var ex43929 = (state_43911__$1[(2)]);
var statearr_43935_43962 = state_43911__$1;
(statearr_43935_43962[(5)] = ex43929);


if((ex43929 instanceof Error)){
var statearr_43936_43963 = state_43911__$1;
(statearr_43936_43963[(1)] = (4));

(statearr_43936_43963[(5)] = null);

} else {
throw ex43929;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (14))){
var state_43911__$1 = state_43911;
var statearr_43937_43964 = state_43911__$1;
(statearr_43937_43964[(2)] = null);

(statearr_43937_43964[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (16))){
var inst_43863 = (state_43911[(8)]);
var inst_43895 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43896 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43897 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43895),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43896),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43863),". Forcing a db reload."].join('');
var inst_43898 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43897], 0));
var inst_43899 = fluree.db.session.reload_db_BANG_(session);
var state_43911__$1 = (function (){var statearr_43938 = state_43911;
(statearr_43938[(10)] = inst_43898);

return statearr_43938;
})();
var statearr_43939_43965 = state_43911__$1;
(statearr_43939_43965[(2)] = inst_43899);

(statearr_43939_43965[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (10))){
var inst_43859 = (state_43911[(9)]);
var inst_43862 = (state_43911[(7)]);
var inst_43863 = (state_43911[(8)]);
var inst_43874 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43875 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43876 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43874),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43875),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_43877 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43876], 0));
var inst_43878 = (function (){var current_db_ch = inst_43859;
var current_db = inst_43862;
var current_block = inst_43863;
return (function (p1__43850_SHARP_){
if((p1__43850_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__43850_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__43850_SHARP_);
}
});
})();
var inst_43879 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_43878,flakes);
var inst_43880 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_43862,block,inst_43879);
var inst_43881 = fluree.db.session.cas_db_BANG_(session,inst_43859,inst_43880);
var state_43911__$1 = (function (){var statearr_43940 = state_43911;
(statearr_43940[(11)] = inst_43877);

return statearr_43940;
})();
if(inst_43881){
var statearr_43941_43966 = state_43911__$1;
(statearr_43941_43966[(1)] = (13));

} else {
var statearr_43942_43967 = state_43911__$1;
(statearr_43942_43967[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (18))){
var inst_43902 = (state_43911[(2)]);
var state_43911__$1 = state_43911;
var statearr_43943_43968 = state_43911__$1;
(statearr_43943_43968[(2)] = inst_43902);

(statearr_43943_43968[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43912 === (8))){
var inst_43863 = (state_43911[(8)]);
var inst_43871 = ((1) + inst_43863);
var inst_43872 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_43871);
var state_43911__$1 = state_43911;
if(inst_43872){
var statearr_43944_43969 = state_43911__$1;
(statearr_43944_43969[(1)] = (10));

} else {
var statearr_43945_43970 = state_43911__$1;
(statearr_43945_43970[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__16395__auto__ = null;
var fluree$db$session$state_machine__16395__auto____0 = (function (){
var statearr_43946 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43946[(0)] = fluree$db$session$state_machine__16395__auto__);

(statearr_43946[(1)] = (1));

return statearr_43946;
});
var fluree$db$session$state_machine__16395__auto____1 = (function (state_43911){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43911);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43947){var ex__16398__auto__ = e43947;
var statearr_43948_43971 = state_43911;
(statearr_43948_43971[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43911[(4)]))){
var statearr_43949_43972 = state_43911;
(statearr_43949_43972[(1)] = cljs.core.first((state_43911[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43973 = state_43911;
state_43911 = G__43973;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$session$state_machine__16395__auto__ = function(state_43911){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16395__auto____1.call(this,state_43911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16395__auto____0;
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16395__auto____1;
return fluree$db$session$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43950 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43950[(6)] = c__16469__auto__);

return statearr_43950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43980){
var state_val_43981 = (state_43980[(1)]);
if((state_val_43981 === (1))){
var inst_43974 = fluree.db.session.clear_db_BANG_(session);
var inst_43975 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43976 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43977 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43975),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43976)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_43978 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43977], 0));
var state_43980__$1 = (function (){var statearr_43982 = state_43980;
(statearr_43982[(7)] = inst_43978);

(statearr_43982[(8)] = inst_43974);

return statearr_43982;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_43980__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__16395__auto__ = null;
var fluree$db$session$state_machine__16395__auto____0 = (function (){
var statearr_43983 = [null,null,null,null,null,null,null,null,null];
(statearr_43983[(0)] = fluree$db$session$state_machine__16395__auto__);

(statearr_43983[(1)] = (1));

return statearr_43983;
});
var fluree$db$session$state_machine__16395__auto____1 = (function (state_43980){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43980);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43984){var ex__16398__auto__ = e43984;
var statearr_43985_43988 = state_43980;
(statearr_43985_43988[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43980[(4)]))){
var statearr_43986_43989 = state_43980;
(statearr_43986_43989[(1)] = cljs.core.first((state_43980[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43990 = state_43980;
state_43980 = G__43990;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$session$state_machine__16395__auto__ = function(state_43980){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16395__auto____1.call(this,state_43980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16395__auto____0;
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16395__auto____1;
return fluree$db$session$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43987 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43987[(6)] = c__16469__auto__);

return statearr_43987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__43992 = arguments.length;
switch (G__43992) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__43993 = session;
var map__43993__$1 = cljs.core.__destructure_map(map__43993);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43993__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43993__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43993__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43993__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43993__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43993__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43993__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__43994_43997 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__43994_43997.cljs$core$IFn$_invoke$arity$3 ? fexpr__43994_43997.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__43994_43997.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__43995_43998 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__43995_43998.cljs$core$IFn$_invoke$arity$0 ? fexpr__43995_43998.cljs$core$IFn$_invoke$arity$0() : fexpr__43995_43998.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_44051){
var state_val_44052 = (state_44051[(1)]);
if((state_val_44052 === (7))){
var inst_44047 = (state_44051[(2)]);
var state_44051__$1 = state_44051;
var statearr_44053_44084 = state_44051__$1;
(statearr_44053_44084[(2)] = inst_44047);

(statearr_44053_44084[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (1))){
var state_44051__$1 = state_44051;
var statearr_44054_44085 = state_44051__$1;
(statearr_44054_44085[(2)] = null);

(statearr_44054_44085[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (4))){
var inst_44002 = (state_44051[(7)]);
var inst_44001 = (state_44051[(2)]);
var inst_44002__$1 = fluree.db.util.async.throw_err(inst_44001);
var inst_44003 = fluree.db.session.from_cache(network,ledger_id);
var inst_44004 = (inst_44002__$1 == null);
var state_44051__$1 = (function (){var statearr_44055 = state_44051;
(statearr_44055[(7)] = inst_44002__$1);

(statearr_44055[(8)] = inst_44003);

return statearr_44055;
})();
if(cljs.core.truth_(inst_44004)){
var statearr_44056_44086 = state_44051__$1;
(statearr_44056_44086[(1)] = (5));

} else {
var statearr_44057_44087 = state_44051__$1;
(statearr_44057_44087[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (15))){
var inst_44039 = (state_44051[(2)]);
var state_44051__$1 = (function (){var statearr_44058 = state_44051;
(statearr_44058[(9)] = inst_44039);

return statearr_44058;
})();
var statearr_44059_44088 = state_44051__$1;
(statearr_44059_44088[(2)] = null);

(statearr_44059_44088[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (13))){
var inst_44043 = (state_44051[(2)]);
var state_44051__$1 = state_44051;
var statearr_44061_44089 = state_44051__$1;
(statearr_44061_44089[(2)] = inst_44043);

(statearr_44061_44089[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (6))){
var inst_44003 = (state_44051[(8)]);
var inst_44009 = (inst_44003 == null);
var state_44051__$1 = state_44051;
if(cljs.core.truth_(inst_44009)){
var statearr_44062_44090 = state_44051__$1;
(statearr_44062_44090[(1)] = (8));

} else {
var statearr_44063_44091 = state_44051__$1;
(statearr_44063_44091[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (17))){
var _ = (function (){var statearr_44064 = state_44051;
(statearr_44064[(4)] = cljs.core.rest((state_44051[(4)])));

return statearr_44064;
})();
var state_44051__$1 = state_44051;
var ex44060 = (state_44051__$1[(2)]);
var statearr_44065_44092 = state_44051__$1;
(statearr_44065_44092[(5)] = ex44060);


var statearr_44066_44093 = state_44051__$1;
(statearr_44066_44093[(1)] = (16));

(statearr_44066_44093[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (3))){
var inst_44049 = (state_44051[(2)]);
var state_44051__$1 = state_44051;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44051__$1,inst_44049);
} else {
if((state_val_44052 === (12))){
var state_44051__$1 = state_44051;
var statearr_44067_44094 = state_44051__$1;
(statearr_44067_44094[(2)] = null);

(statearr_44067_44094[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (2))){
var state_44051__$1 = state_44051;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44051__$1,(4),update_chan);
} else {
if((state_val_44052 === (11))){
var state_44051__$1 = state_44051;
var statearr_44068_44095 = state_44051__$1;
(statearr_44068_44095[(2)] = null);

(statearr_44068_44095[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (9))){
var state_44051__$1 = state_44051;
var statearr_44069_44096 = state_44051__$1;
(statearr_44069_44096[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (5))){
var inst_44006 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_44007 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44006], 0));
var state_44051__$1 = state_44051;
var statearr_44071_44097 = state_44051__$1;
(statearr_44071_44097[(2)] = inst_44007);

(statearr_44071_44097[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (14))){
var inst_44002 = (state_44051[(7)]);
var inst_44003 = (state_44051[(8)]);
var _ = (function (){var statearr_44072 = state_44051;
(statearr_44072[(4)] = cljs.core.cons((17),(state_44051[(4)])));

return statearr_44072;
})();
var inst_44027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44002,(0),null);
var inst_44028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44002,(1),null);
var inst_44029 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_44030 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44002], 0));
var inst_44031 = fluree.db.util.core.trunc(inst_44030,(200));
var inst_44032 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44029,inst_44031], 0));
var inst_44033 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_44003,inst_44027,inst_44028) : fluree.db.session.process_ledger_update.call(null,inst_44003,inst_44027,inst_44028));
var state_44051__$1 = (function (){var statearr_44073 = state_44051;
(statearr_44073[(10)] = inst_44032);

return statearr_44073;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44051__$1,(18),inst_44033);
} else {
if((state_val_44052 === (16))){
var inst_44002 = (state_44051[(7)]);
var inst_44017 = (state_44051[(2)]);
var inst_44018 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44017,"Exception processing ledger updates for message: ",inst_44002], 0));
var state_44051__$1 = state_44051;
var statearr_44074_44098 = state_44051__$1;
(statearr_44074_44098[(2)] = inst_44018);

(statearr_44074_44098[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (10))){
var inst_44045 = (state_44051[(2)]);
var state_44051__$1 = state_44051;
var statearr_44075_44099 = state_44051__$1;
(statearr_44075_44099[(2)] = inst_44045);

(statearr_44075_44099[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (18))){
var inst_44035 = (state_44051[(2)]);
var inst_44036 = fluree.db.util.async.throw_err(inst_44035);
var _ = (function (){var statearr_44076 = state_44051;
(statearr_44076[(4)] = cljs.core.rest((state_44051[(4)])));

return statearr_44076;
})();
var state_44051__$1 = state_44051;
var statearr_44077_44100 = state_44051__$1;
(statearr_44077_44100[(2)] = inst_44036);

(statearr_44077_44100[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44052 === (8))){
var inst_44002 = (state_44051[(7)]);
var inst_44011 = cljs.core.first(inst_44002);
var inst_44012 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44011], 0));
var inst_44013 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_44012].join('');
var inst_44014 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44013], 0));
var state_44051__$1 = state_44051;
var statearr_44078_44101 = state_44051__$1;
(statearr_44078_44101[(2)] = inst_44014);

(statearr_44078_44101[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__16395__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__16395__auto____0 = (function (){
var statearr_44079 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44079[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__16395__auto__);

(statearr_44079[(1)] = (1));

return statearr_44079;
});
var fluree$db$session$process_ledger_updates_$_state_machine__16395__auto____1 = (function (state_44051){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_44051);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e44080){var ex__16398__auto__ = e44080;
var statearr_44081_44102 = state_44051;
(statearr_44081_44102[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_44051[(4)]))){
var statearr_44082_44103 = state_44051;
(statearr_44082_44103[(1)] = cljs.core.first((state_44051[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__44104 = state_44051;
state_44051 = G__44104;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__16395__auto__ = function(state_44051){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__16395__auto____1.call(this,state_44051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__16395__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__16395__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_44083 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_44083[(6)] = c__16469__auto__);

return statearr_44083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__44105){
var map__44106 = p__44105;
var map__44106__$1 = cljs.core.__destructure_map(map__44106);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44106__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44106__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44106__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44106__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44106__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44106__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44106__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44106__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44106__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__44110 = block_result;
var map__44110__$1 = cljs.core.__destructure_map(map__44110);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44110__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44110__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44110__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44110__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44110__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__44111 = tx_result;
var map__44111__$1 = cljs.core.__destructure_map(map__44111);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44111__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44111__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__44107_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__44107_SHARP_.t);
}):(function (p1__44108_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__44108_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__44109_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__44109_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__44109_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__44112 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44112,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44112,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44112,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44112,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__44116 = arguments.length;
switch (G__44116) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__44117){
var map__44118 = p__44117;
var map__44118__$1 = cljs.core.__destructure_map(map__44118);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44118__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44118__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44118__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44118__$1,cljs.core.cst$kw$jwt);
var vec__44119 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44119,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44119,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44119,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4212__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4212__auto____$1 = state;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__44123_44243 = network;
var G__44124_44244 = ledger_id;
var G__44125_44245 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__44126_44246 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__44127 = cljs.core.seq(tids);
var chunk__44128 = null;
var count__44129 = (0);
var i__44130 = (0);
while(true){
if((i__44130 < count__44129)){
var tid = chunk__44128.cljs$core$IIndexed$_nth$arity$2(null,i__44130);
var temp__5753__auto___44248__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___44248__$1)){
var keyed_callbacks_44249 = temp__5753__auto___44248__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_44250 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__44171_44251 = cljs.core.seq(keyed_callbacks_44249);
var chunk__44172_44252 = null;
var count__44173_44253 = (0);
var i__44174_44254 = (0);
while(true){
if((i__44174_44254 < count__44173_44253)){
var vec__44183_44255 = chunk__44172_44252.cljs$core$IIndexed$_nth$arity$2(null,i__44174_44254);
var k_44256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44183_44255,(0),null);
var f_44257 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44183_44255,(1),null);
try{(f_44257.cljs$core$IFn$_invoke$arity$1 ? f_44257.cljs$core$IFn$_invoke$arity$1(tx_response_44250) : f_44257.call(null,tx_response_44250));
}catch (e44186){var e_44258 = e44186;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_44258,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__44259 = seq__44171_44251;
var G__44260 = chunk__44172_44252;
var G__44261 = count__44173_44253;
var G__44262 = (i__44174_44254 + (1));
seq__44171_44251 = G__44259;
chunk__44172_44252 = G__44260;
count__44173_44253 = G__44261;
i__44174_44254 = G__44262;
continue;
} else {
var temp__5753__auto___44263__$2 = cljs.core.seq(seq__44171_44251);
if(temp__5753__auto___44263__$2){
var seq__44171_44264__$1 = temp__5753__auto___44263__$2;
if(cljs.core.chunked_seq_QMARK_(seq__44171_44264__$1)){
var c__4638__auto___44265 = cljs.core.chunk_first(seq__44171_44264__$1);
var G__44266 = cljs.core.chunk_rest(seq__44171_44264__$1);
var G__44267 = c__4638__auto___44265;
var G__44268 = cljs.core.count(c__4638__auto___44265);
var G__44269 = (0);
seq__44171_44251 = G__44266;
chunk__44172_44252 = G__44267;
count__44173_44253 = G__44268;
i__44174_44254 = G__44269;
continue;
} else {
var vec__44187_44270 = cljs.core.first(seq__44171_44264__$1);
var k_44271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44187_44270,(0),null);
var f_44272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44187_44270,(1),null);
try{(f_44272.cljs$core$IFn$_invoke$arity$1 ? f_44272.cljs$core$IFn$_invoke$arity$1(tx_response_44250) : f_44272.call(null,tx_response_44250));
}catch (e44190){var e_44273 = e44190;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_44273,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__44274 = cljs.core.next(seq__44171_44264__$1);
var G__44275 = null;
var G__44276 = (0);
var G__44277 = (0);
seq__44171_44251 = G__44274;
chunk__44172_44252 = G__44275;
count__44173_44253 = G__44276;
i__44174_44254 = G__44277;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__44278 = seq__44127;
var G__44279 = chunk__44128;
var G__44280 = count__44129;
var G__44281 = (i__44130 + (1));
seq__44127 = G__44278;
chunk__44128 = G__44279;
count__44129 = G__44280;
i__44130 = G__44281;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__44127);
if(temp__5753__auto____$1){
var seq__44127__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__44127__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__44127__$1);
var G__44282 = cljs.core.chunk_rest(seq__44127__$1);
var G__44283 = c__4638__auto__;
var G__44284 = cljs.core.count(c__4638__auto__);
var G__44285 = (0);
seq__44127 = G__44282;
chunk__44128 = G__44283;
count__44129 = G__44284;
i__44130 = G__44285;
continue;
} else {
var tid = cljs.core.first(seq__44127__$1);
var temp__5753__auto___44286__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___44286__$2)){
var keyed_callbacks_44287 = temp__5753__auto___44286__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_44288 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__44191_44289 = cljs.core.seq(keyed_callbacks_44287);
var chunk__44192_44290 = null;
var count__44193_44291 = (0);
var i__44194_44292 = (0);
while(true){
if((i__44194_44292 < count__44193_44291)){
var vec__44203_44293 = chunk__44192_44290.cljs$core$IIndexed$_nth$arity$2(null,i__44194_44292);
var k_44294 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44203_44293,(0),null);
var f_44295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44203_44293,(1),null);
try{(f_44295.cljs$core$IFn$_invoke$arity$1 ? f_44295.cljs$core$IFn$_invoke$arity$1(tx_response_44288) : f_44295.call(null,tx_response_44288));
}catch (e44206){var e_44296 = e44206;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_44296,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__44297 = seq__44191_44289;
var G__44298 = chunk__44192_44290;
var G__44299 = count__44193_44291;
var G__44300 = (i__44194_44292 + (1));
seq__44191_44289 = G__44297;
chunk__44192_44290 = G__44298;
count__44193_44291 = G__44299;
i__44194_44292 = G__44300;
continue;
} else {
var temp__5753__auto___44301__$3 = cljs.core.seq(seq__44191_44289);
if(temp__5753__auto___44301__$3){
var seq__44191_44302__$1 = temp__5753__auto___44301__$3;
if(cljs.core.chunked_seq_QMARK_(seq__44191_44302__$1)){
var c__4638__auto___44303 = cljs.core.chunk_first(seq__44191_44302__$1);
var G__44304 = cljs.core.chunk_rest(seq__44191_44302__$1);
var G__44305 = c__4638__auto___44303;
var G__44306 = cljs.core.count(c__4638__auto___44303);
var G__44307 = (0);
seq__44191_44289 = G__44304;
chunk__44192_44290 = G__44305;
count__44193_44291 = G__44306;
i__44194_44292 = G__44307;
continue;
} else {
var vec__44207_44308 = cljs.core.first(seq__44191_44302__$1);
var k_44309 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44207_44308,(0),null);
var f_44310 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44207_44308,(1),null);
try{(f_44310.cljs$core$IFn$_invoke$arity$1 ? f_44310.cljs$core$IFn$_invoke$arity$1(tx_response_44288) : f_44310.call(null,tx_response_44288));
}catch (e44210){var e_44311 = e44210;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_44311,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__44312 = cljs.core.next(seq__44191_44302__$1);
var G__44313 = null;
var G__44314 = (0);
var G__44315 = (0);
seq__44191_44289 = G__44312;
chunk__44192_44290 = G__44313;
count__44193_44291 = G__44314;
i__44194_44292 = G__44315;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__44316 = cljs.core.next(seq__44127__$1);
var G__44317 = null;
var G__44318 = (0);
var G__44319 = (0);
seq__44127 = G__44316;
chunk__44128 = G__44317;
count__44129 = G__44318;
i__44130 = G__44319;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__44122_44247 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__44122_44247.cljs$core$IFn$_invoke$arity$4 ? fexpr__44122_44247.cljs$core$IFn$_invoke$arity$4(G__44123_44243,G__44124_44244,G__44125_44245,G__44126_44246) : fexpr__44122_44247.call(null,G__44123_44243,G__44124_44244,G__44125_44245,G__44126_44246));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_44320 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__16469__auto___44321 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_44227){
var state_val_44228 = (state_44227[(1)]);
if((state_val_44228 === (1))){
var state_44227__$1 = state_44227;
var statearr_44229_44322 = state_44227__$1;
(statearr_44229_44322[(2)] = null);

(statearr_44229_44322[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44228 === (2))){
var inst_44212 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_44227__$1 = state_44227;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44227__$1,(4),inst_44212);
} else {
if((state_val_44228 === (3))){
var inst_44225 = (state_44227[(2)]);
var state_44227__$1 = state_44227;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44227__$1,inst_44225);
} else {
if((state_val_44228 === (4))){
var inst_44214 = (state_44227[(7)]);
var inst_44214__$1 = (state_44227[(2)]);
var inst_44215 = (inst_44214__$1 == null);
var state_44227__$1 = (function (){var statearr_44230 = state_44227;
(statearr_44230[(7)] = inst_44214__$1);

return statearr_44230;
})();
if(cljs.core.truth_(inst_44215)){
var statearr_44231_44323 = state_44227__$1;
(statearr_44231_44323[(1)] = (5));

} else {
var statearr_44232_44324 = state_44227__$1;
(statearr_44232_44324[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44228 === (5))){
var inst_44217 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_44218 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44217], 0));
var state_44227__$1 = state_44227;
var statearr_44233_44325 = state_44227__$1;
(statearr_44233_44325[(2)] = inst_44218);

(statearr_44233_44325[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44228 === (6))){
var inst_44214 = (state_44227[(7)]);
var inst_44220 = (transact_handler_44320.cljs$core$IFn$_invoke$arity$2 ? transact_handler_44320.cljs$core$IFn$_invoke$arity$2(conn,inst_44214) : transact_handler_44320.call(null,conn,inst_44214));
var state_44227__$1 = (function (){var statearr_44234 = state_44227;
(statearr_44234[(8)] = inst_44220);

return statearr_44234;
})();
var statearr_44235_44326 = state_44227__$1;
(statearr_44235_44326[(2)] = null);

(statearr_44235_44326[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44228 === (7))){
var inst_44223 = (state_44227[(2)]);
var state_44227__$1 = state_44227;
var statearr_44236_44327 = state_44227__$1;
(statearr_44236_44327[(2)] = inst_44223);

(statearr_44236_44327[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__16395__auto__ = null;
var fluree$db$session$state_machine__16395__auto____0 = (function (){
var statearr_44237 = [null,null,null,null,null,null,null,null,null];
(statearr_44237[(0)] = fluree$db$session$state_machine__16395__auto__);

(statearr_44237[(1)] = (1));

return statearr_44237;
});
var fluree$db$session$state_machine__16395__auto____1 = (function (state_44227){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_44227);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e44238){var ex__16398__auto__ = e44238;
var statearr_44239_44328 = state_44227;
(statearr_44239_44328[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_44227[(4)]))){
var statearr_44240_44329 = state_44227;
(statearr_44240_44329[(1)] = cljs.core.first((state_44227[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__44330 = state_44227;
state_44227 = G__44330;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$session$state_machine__16395__auto__ = function(state_44227){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__16395__auto____1.call(this,state_44227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__16395__auto____0;
fluree$db$session$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__16395__auto____1;
return fluree$db$session$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_44241 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_44241[(6)] = c__16469__auto___44321);

return statearr_44241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__44331_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__44331_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__44331_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__44332_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__44332_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
}));

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__44335 = arguments.length;
switch (G__44335) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__44336 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__44333_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__44333_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__44336);
} else {
return G__44336;
}
})();
var seq__44337 = cljs.core.seq(sessions);
var chunk__44338 = null;
var count__44339 = (0);
var i__44340 = (0);
while(true){
if((i__44340 < count__44339)){
var session = chunk__44338.cljs$core$IIndexed$_nth$arity$2(null,i__44340);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__44342 = seq__44337;
var G__44343 = chunk__44338;
var G__44344 = count__44339;
var G__44345 = (i__44340 + (1));
seq__44337 = G__44342;
chunk__44338 = G__44343;
count__44339 = G__44344;
i__44340 = G__44345;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__44337);
if(temp__5753__auto__){
var seq__44337__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44337__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__44337__$1);
var G__44346 = cljs.core.chunk_rest(seq__44337__$1);
var G__44347 = c__4638__auto__;
var G__44348 = cljs.core.count(c__4638__auto__);
var G__44349 = (0);
seq__44337 = G__44346;
chunk__44338 = G__44347;
count__44339 = G__44348;
i__44340 = G__44349;
continue;
} else {
var session = cljs.core.first(seq__44337__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__44350 = cljs.core.next(seq__44337__$1);
var G__44351 = null;
var G__44352 = (0);
var G__44353 = (0);
seq__44337 = G__44350;
chunk__44338 = G__44351;
count__44339 = G__44352;
i__44340 = G__44353;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
