// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4212__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__29442 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29442,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29442,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29442,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29442,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29442,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29442,(5),null);
var G__29445 = idx;
var G__29445__$1 = (((G__29445 instanceof cljs.core.Keyword))?G__29445.fqn:null);
switch (G__29445__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29445__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__29447 = idx;
var G__29447__$1 = (((G__29447 instanceof cljs.core.Keyword))?G__29447.fqn:null);
switch (G__29447__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29447__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__29449 = idx;
var G__29449__$1 = (((G__29449 instanceof cljs.core.Keyword))?G__29449.fqn:null);
switch (G__29449__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29449__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__29452 = arguments.length;
switch (G__29452) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__29453 = (function (){var pred__29456 = cljs.core.identical_QMARK_;
var expr__29457 = test;
if(cljs.core.truth_((pred__29456.cljs$core$IFn$_invoke$arity$2 ? pred__29456.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__29457) : pred__29456.call(null,cljs.core._EQ_,expr__29457)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__29456.cljs$core$IFn$_invoke$arity$2 ? pred__29456.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__29457) : pred__29456.call(null,cljs.core._LT_,expr__29457)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__29456.cljs$core$IFn$_invoke$arity$2 ? pred__29456.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__29457) : pred__29456.call(null,cljs.core._LT__EQ_,expr__29457)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__29456.cljs$core$IFn$_invoke$arity$2 ? pred__29456.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__29457) : pred__29456.call(null,cljs.core._GT_,expr__29457)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__29456.cljs$core$IFn$_invoke$arity$2 ? pred__29456.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__29457) : pred__29456.call(null,cljs.core._GT__EQ_,expr__29457)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__29457)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29453,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29453,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29453,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29453,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_29696){
var state_val_29697 = (state_29696[(1)]);
if((state_val_29697 === (65))){
var inst_29611 = (state_29696[(7)]);
var inst_29667 = (state_29696[(8)]);
var inst_29667__$1 = (state_29696[(2)]);
var inst_29668 = cljs.core.count(inst_29667__$1);
var state_29696__$1 = (function (){var statearr_29698 = state_29696;
(statearr_29698[(8)] = inst_29667__$1);

(statearr_29698[(9)] = inst_29668);

return statearr_29698;
})();
if(cljs.core.truth_(inst_29611)){
var statearr_29699_29836 = state_29696__$1;
(statearr_29699_29836[(1)] = (81));

} else {
var statearr_29700_29837 = state_29696__$1;
(statearr_29700_29837[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (70))){
var inst_29642 = (state_29696[(2)]);
var state_29696__$1 = state_29696;
if(cljs.core.truth_(inst_29642)){
var statearr_29701_29838 = state_29696__$1;
(statearr_29701_29838[(1)] = (71));

} else {
var statearr_29702_29839 = state_29696__$1;
(statearr_29702_29839[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (62))){
var inst_29581 = (state_29696[(10)]);
var inst_29595 = (state_29696[(11)]);
var inst_29610 = (state_29696[(2)]);
var inst_29611 = fluree.db.dbproto._rhs(inst_29595);
var state_29696__$1 = (function (){var statearr_29703 = state_29696;
(statearr_29703[(7)] = inst_29611);

(statearr_29703[(12)] = inst_29610);

return statearr_29703;
})();
if(cljs.core.truth_(inst_29581)){
var statearr_29704_29840 = state_29696__$1;
(statearr_29704_29840[(1)] = (63));

} else {
var statearr_29705_29841 = state_29696__$1;
(statearr_29705_29841[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (74))){
var inst_29635 = (state_29696[(13)]);
var inst_29649 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_29635);
var state_29696__$1 = state_29696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29696__$1,(77),inst_29649);
} else {
if((state_val_29697 === (7))){
var inst_29472 = (state_29696[(14)]);
var state_29696__$1 = state_29696;
var statearr_29706_29842 = state_29696__$1;
(statearr_29706_29842[(2)] = inst_29472);

(statearr_29706_29842[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (59))){
var inst_29558 = (state_29696[(15)]);
var inst_29557 = (state_29696[(16)]);
var inst_29602 = (state_29696[(17)]);
var inst_29601 = (state_29696[(2)]);
var inst_29602__$1 = fluree.db.util.async.throw_err(inst_29601);
var inst_29603 = fluree.db.flake.subrange(inst_29602__$1,start_test,inst_29557,end_test,inst_29558);
var inst_29604 = fluree.db.query.range.value_with_nil_pred(idx,inst_29557,inst_29558);
var state_29696__$1 = (function (){var statearr_29707 = state_29696;
(statearr_29707[(18)] = inst_29603);

(statearr_29707[(17)] = inst_29602__$1);

return statearr_29707;
})();
if(inst_29604){
var statearr_29708_29843 = state_29696__$1;
(statearr_29708_29843[(1)] = (60));

} else {
var statearr_29709_29844 = state_29696__$1;
(statearr_29709_29844[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (86))){
var inst_29676 = (state_29696[(2)]);
var state_29696__$1 = state_29696;
var statearr_29710_29845 = state_29696__$1;
(statearr_29710_29845[(2)] = inst_29676);

(statearr_29710_29845[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (20))){
var inst_29521 = (state_29696[(19)]);
var inst_29473 = (state_29696[(20)]);
var inst_29520 = (state_29696[(2)]);
var inst_29521__$1 = (inst_29473 == null);
var state_29696__$1 = (function (){var statearr_29711 = state_29696;
(statearr_29711[(19)] = inst_29521__$1);

(statearr_29711[(21)] = inst_29520);

return statearr_29711;
})();
if(cljs.core.truth_(inst_29521__$1)){
var statearr_29712_29846 = state_29696__$1;
(statearr_29712_29846[(1)] = (22));

} else {
var statearr_29713_29847 = state_29696__$1;
(statearr_29713_29847[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (72))){
var inst_29628 = (state_29696[(22)]);
var inst_29646 = (inst_29628 + (1));
var inst_29647 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_29696__$1 = (function (){var statearr_29714 = state_29696;
(statearr_29714[(23)] = inst_29646);

return statearr_29714;
})();
if(cljs.core.truth_(inst_29647)){
var statearr_29715_29848 = state_29696__$1;
(statearr_29715_29848[(1)] = (74));

} else {
var statearr_29716_29849 = state_29696__$1;
(statearr_29716_29849[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (58))){
var inst_29691 = (state_29696[(2)]);
var _ = (function (){var statearr_29717 = state_29696;
(statearr_29717[(4)] = cljs.core.rest((state_29696[(4)])));

return statearr_29717;
})();
var state_29696__$1 = state_29696;
var statearr_29718_29850 = state_29696__$1;
(statearr_29718_29850[(2)] = inst_29691);

(statearr_29718_29850[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (60))){
var inst_29585 = (state_29696[(24)]);
var inst_29590 = (state_29696[(25)]);
var inst_29502 = (state_29696[(26)]);
var inst_29493 = (state_29696[(27)]);
var inst_29575 = (state_29696[(28)]);
var inst_29603 = (state_29696[(18)]);
var inst_29547 = (state_29696[(29)]);
var inst_29538 = (state_29696[(30)]);
var inst_29564 = (state_29696[(31)]);
var inst_29529 = (state_29696[(32)]);
var inst_29596 = (state_29696[(33)]);
var inst_29511 = (state_29696[(34)]);
var inst_29475 = (state_29696[(35)]);
var inst_29558 = (state_29696[(15)]);
var inst_29568 = (state_29696[(36)]);
var inst_29476 = (state_29696[(37)]);
var inst_29482 = (state_29696[(38)]);
var inst_29563 = (state_29696[(39)]);
var inst_29478 = (state_29696[(40)]);
var inst_29581 = (state_29696[(10)]);
var inst_29597 = (state_29696[(41)]);
var inst_29557 = (state_29696[(16)]);
var inst_29574 = (state_29696[(42)]);
var inst_29556 = (state_29696[(43)]);
var inst_29520 = (state_29696[(21)]);
var inst_29471 = (state_29696[(44)]);
var inst_29595 = (state_29696[(11)]);
var inst_29483 = (state_29696[(45)]);
var inst_29602 = (state_29696[(17)]);
var inst_29606 = (function (){var no_filter_QMARK_ = inst_29581;
var next_node = inst_29595;
var flakes = inst_29602;
var s1 = inst_29493;
var o2 = inst_29520;
var t1 = inst_29475;
var vec__29465 = inst_29471;
var i = inst_29596;
var m1 = inst_29547;
var root_node = inst_29590;
var to_t = inst_29575;
var s2 = inst_29502;
var p2 = inst_29538;
var permissions = inst_29564;
var limit = inst_29563;
var start_flake = inst_29557;
var acc = inst_29597;
var t2 = inst_29482;
var op1 = inst_29476;
var o1 = inst_29511;
var end_flake = inst_29558;
var base_result = inst_29603;
var p1 = inst_29529;
var vec__29468 = inst_29478;
var idx_compare = inst_29568;
var op2 = inst_29483;
var from_t = inst_29574;
var m2 = inst_29556;
var novelty = inst_29585;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_29607 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_29606,inst_29603,inst_29603);
var state_29696__$1 = state_29696;
var statearr_29719_29851 = state_29696__$1;
(statearr_29719_29851[(2)] = inst_29607);

(statearr_29719_29851[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (27))){
var inst_29530 = (state_29696[(46)]);
var inst_29480 = (state_29696[(47)]);
var inst_29529 = (state_29696[(2)]);
var inst_29530__$1 = (inst_29480 == null);
var state_29696__$1 = (function (){var statearr_29720 = state_29696;
(statearr_29720[(46)] = inst_29530__$1);

(statearr_29720[(32)] = inst_29529);

return statearr_29720;
})();
if(cljs.core.truth_(inst_29530__$1)){
var statearr_29721_29852 = state_29696__$1;
(statearr_29721_29852[(1)] = (28));

} else {
var statearr_29722_29853 = state_29696__$1;
(statearr_29722_29853[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (1))){
var state_29696__$1 = state_29696;
var statearr_29723_29854 = state_29696__$1;
(statearr_29723_29854[(2)] = null);

(statearr_29723_29854[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (69))){
var inst_29563 = (state_29696[(39)]);
var inst_29628 = (state_29696[(22)]);
var inst_29640 = (inst_29628 > inst_29563);
var state_29696__$1 = state_29696;
var statearr_29724_29855 = state_29696__$1;
(statearr_29724_29855[(2)] = inst_29640);

(statearr_29724_29855[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (24))){
var inst_29525 = (state_29696[(2)]);
var state_29696__$1 = state_29696;
if(cljs.core.truth_(inst_29525)){
var statearr_29725_29856 = state_29696__$1;
(statearr_29725_29856[(1)] = (25));

} else {
var statearr_29726_29857 = state_29696__$1;
(statearr_29726_29857[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (55))){
var inst_29590 = (state_29696[(25)]);
var inst_29557 = (state_29696[(16)]);
var inst_29589 = (state_29696[(2)]);
var inst_29590__$1 = fluree.db.util.async.throw_err(inst_29589);
var inst_29591 = fluree.db.dbproto._lookup_leaf(inst_29590__$1,inst_29557);
var state_29696__$1 = (function (){var statearr_29727 = state_29696;
(statearr_29727[(25)] = inst_29590__$1);

return statearr_29727;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29696__$1,(56),inst_29591);
} else {
if((state_val_29697 === (85))){
var inst_29671 = (state_29696[(48)]);
var state_29696__$1 = state_29696;
var statearr_29728_29858 = state_29696__$1;
(statearr_29728_29858[(2)] = inst_29671);

(statearr_29728_29858[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (39))){
var inst_29545 = (state_29696[(2)]);
var state_29696__$1 = state_29696;
var statearr_29729_29859 = state_29696__$1;
(statearr_29729_29859[(2)] = inst_29545);

(statearr_29729_29859[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (88))){
var inst_29590 = (state_29696[(25)]);
var inst_29611 = (state_29696[(7)]);
var inst_29683 = fluree.db.dbproto._lookup_leaf(inst_29590,inst_29611);
var state_29696__$1 = state_29696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29696__$1,(90),inst_29683);
} else {
if((state_val_29697 === (46))){
var inst_29559 = (state_29696[(49)]);
var state_29696__$1 = state_29696;
var statearr_29730_29860 = state_29696__$1;
(statearr_29730_29860[(2)] = inst_29559);

(statearr_29730_29860[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (4))){
var inst_29459 = (state_29696[(2)]);
var state_29696__$1 = state_29696;
var statearr_29731_29861 = state_29696__$1;
(statearr_29731_29861[(2)] = inst_29459);

(statearr_29731_29861[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (77))){
var inst_29651 = (state_29696[(2)]);
var inst_29652 = fluree.db.util.async.throw_err(inst_29651);
var state_29696__$1 = state_29696;
if(cljs.core.truth_(inst_29652)){
var statearr_29732_29862 = state_29696__$1;
(statearr_29732_29862[(1)] = (78));

} else {
var statearr_29733_29863 = state_29696__$1;
(statearr_29733_29863[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (54))){
var inst_29581 = (state_29696[(2)]);
var inst_29582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29583 = [cljs.core.cst$kw$novelty,idx];
var inst_29584 = (new cljs.core.PersistentVector(null,2,(5),inst_29582,inst_29583,null));
var inst_29585 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_29584);
var inst_29586 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_29587 = fluree.db.dbproto._resolve(inst_29586);
var state_29696__$1 = (function (){var statearr_29734 = state_29696;
(statearr_29734[(24)] = inst_29585);

(statearr_29734[(10)] = inst_29581);

return statearr_29734;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29696__$1,(55),inst_29587);
} else {
if((state_val_29697 === (15))){
var inst_29474 = (state_29696[(50)]);
var state_29696__$1 = state_29696;
var statearr_29735_29864 = state_29696__$1;
(statearr_29735_29864[(2)] = inst_29474);

(statearr_29735_29864[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (48))){
var inst_29569 = (state_29696[(51)]);
var inst_29563 = (state_29696[(2)]);
var inst_29564 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_29565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29566 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_29567 = (new cljs.core.PersistentVector(null,3,(5),inst_29565,inst_29566,null));
var inst_29568 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_29567);
var inst_29569__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_29696__$1 = (function (){var statearr_29736 = state_29696;
(statearr_29736[(31)] = inst_29564);

(statearr_29736[(36)] = inst_29568);

(statearr_29736[(39)] = inst_29563);

(statearr_29736[(51)] = inst_29569__$1);

return statearr_29736;
})();
if(cljs.core.truth_(inst_29569__$1)){
var statearr_29737_29865 = state_29696__$1;
(statearr_29737_29865[(1)] = (49));

} else {
var statearr_29738_29866 = state_29696__$1;
(statearr_29738_29866[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (50))){
var inst_29572 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_29696__$1 = state_29696;
var statearr_29739_29867 = state_29696__$1;
(statearr_29739_29867[(2)] = inst_29572);

(statearr_29739_29867[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (75))){
var inst_29629 = (state_29696[(52)]);
var state_29696__$1 = state_29696;
var statearr_29740_29868 = state_29696__$1;
(statearr_29740_29868[(2)] = inst_29629);

(statearr_29740_29868[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (21))){
var inst_29516 = (state_29696[(2)]);
var inst_29517 = fluree.db.util.async.throw_err(inst_29516);
var state_29696__$1 = state_29696;
var statearr_29741_29869 = state_29696__$1;
(statearr_29741_29869[(2)] = inst_29517);

(statearr_29741_29869[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (31))){
var state_29696__$1 = state_29696;
var statearr_29742_29870 = state_29696__$1;
(statearr_29742_29870[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_29742_29870[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (32))){
var inst_29480 = (state_29696[(47)]);
var state_29696__$1 = state_29696;
var statearr_29743_29871 = state_29696__$1;
(statearr_29743_29871[(2)] = inst_29480);

(statearr_29743_29871[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (40))){
var inst_29484 = (state_29696[(53)]);
var state_29696__$1 = state_29696;
var statearr_29744_29872 = state_29696__$1;
(statearr_29744_29872[(2)] = inst_29484);

(statearr_29744_29872[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (56))){
var inst_29593 = (state_29696[(2)]);
var inst_29594 = fluree.db.util.async.throw_err(inst_29593);
var inst_29595 = inst_29594;
var inst_29596 = (0);
var inst_29597 = null;
var state_29696__$1 = (function (){var statearr_29745 = state_29696;
(statearr_29745[(33)] = inst_29596);

(statearr_29745[(41)] = inst_29597);

(statearr_29745[(11)] = inst_29595);

return statearr_29745;
})();
var statearr_29746_29873 = state_29696__$1;
(statearr_29746_29873[(2)] = null);

(statearr_29746_29873[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (33))){
var inst_29477 = (state_29696[(54)]);
var inst_29538 = (state_29696[(2)]);
var state_29696__$1 = (function (){var statearr_29747 = state_29696;
(statearr_29747[(30)] = inst_29538);

return statearr_29747;
})();
if(cljs.core.truth_(inst_29477)){
var statearr_29748_29874 = state_29696__$1;
(statearr_29748_29874[(1)] = (34));

} else {
var statearr_29749_29875 = state_29696__$1;
(statearr_29749_29875[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (13))){
var inst_29498 = (state_29696[(2)]);
var inst_29499 = fluree.db.util.async.throw_err(inst_29498);
var state_29696__$1 = state_29696;
var statearr_29750_29876 = state_29696__$1;
(statearr_29750_29876[(2)] = inst_29499);

(statearr_29750_29876[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (22))){
var inst_29511 = (state_29696[(34)]);
var state_29696__$1 = state_29696;
var statearr_29751_29877 = state_29696__$1;
(statearr_29751_29877[(2)] = inst_29511);

(statearr_29751_29877[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (90))){
var inst_29667 = (state_29696[(8)]);
var inst_29668 = (state_29696[(9)]);
var inst_29685 = (state_29696[(2)]);
var inst_29686 = fluree.db.util.async.throw_err(inst_29685);
var inst_29595 = inst_29686;
var inst_29596 = inst_29668;
var inst_29597 = inst_29667;
var state_29696__$1 = (function (){var statearr_29752 = state_29696;
(statearr_29752[(33)] = inst_29596);

(statearr_29752[(41)] = inst_29597);

(statearr_29752[(11)] = inst_29595);

return statearr_29752;
})();
var statearr_29753_29878 = state_29696__$1;
(statearr_29753_29878[(2)] = null);

(statearr_29753_29878[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (36))){
var inst_29484 = (state_29696[(53)]);
var inst_29547 = (state_29696[(2)]);
var state_29696__$1 = (function (){var statearr_29754 = state_29696;
(statearr_29754[(29)] = inst_29547);

return statearr_29754;
})();
if(cljs.core.truth_(inst_29484)){
var statearr_29755_29879 = state_29696__$1;
(statearr_29755_29879[(1)] = (40));

} else {
var statearr_29756_29880 = state_29696__$1;
(statearr_29756_29880[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (41))){
var inst_29550 = (cljs.core._LT__EQ_ === end_test);
var state_29696__$1 = state_29696;
if(cljs.core.truth_(inst_29550)){
var statearr_29757_29881 = state_29696__$1;
(statearr_29757_29881[(1)] = (43));

} else {
var statearr_29758_29882 = state_29696__$1;
(statearr_29758_29882[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (89))){
var inst_29689 = (state_29696[(2)]);
var state_29696__$1 = state_29696;
var statearr_29759_29883 = state_29696__$1;
(statearr_29759_29883[(2)] = inst_29689);

(statearr_29759_29883[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (43))){
var state_29696__$1 = state_29696;
var statearr_29760_29884 = state_29696__$1;
(statearr_29760_29884[(2)] = (2147483647));

(statearr_29760_29884[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (61))){
var inst_29603 = (state_29696[(18)]);
var state_29696__$1 = state_29696;
var statearr_29761_29885 = state_29696__$1;
(statearr_29761_29885[(2)] = inst_29603);

(statearr_29761_29885[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (29))){
var inst_29530 = (state_29696[(46)]);
var state_29696__$1 = state_29696;
var statearr_29762_29886 = state_29696__$1;
(statearr_29762_29886[(2)] = inst_29530);

(statearr_29762_29886[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (44))){
var state_29696__$1 = state_29696;
var statearr_29763_29887 = state_29696__$1;
(statearr_29763_29887[(2)] = fluree.db.util.core.min_integer);

(statearr_29763_29887[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (6))){
var inst_29472 = (state_29696[(14)]);
var inst_29487 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29472);
var state_29696__$1 = state_29696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29696__$1,(9),inst_29487);
} else {
if((state_val_29697 === (28))){
var inst_29520 = (state_29696[(21)]);
var state_29696__$1 = state_29696;
var statearr_29764_29888 = state_29696__$1;
(statearr_29764_29888[(2)] = inst_29520);

(statearr_29764_29888[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (64))){
var inst_29596 = (state_29696[(33)]);
var inst_29610 = (state_29696[(12)]);
var inst_29624 = cljs.core.seq(inst_29610);
var inst_29625 = cljs.core.first(inst_29624);
var inst_29626 = cljs.core.next(inst_29624);
var inst_29627 = inst_29610;
var inst_29628 = inst_29596;
var inst_29629 = inst_29610;
var state_29696__$1 = (function (){var statearr_29765 = state_29696;
(statearr_29765[(55)] = inst_29627);

(statearr_29765[(52)] = inst_29629);

(statearr_29765[(22)] = inst_29628);

(statearr_29765[(56)] = inst_29625);

(statearr_29765[(57)] = inst_29626);

return statearr_29765;
})();
var statearr_29766_29889 = state_29696__$1;
(statearr_29766_29889[(2)] = null);

(statearr_29766_29889[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (51))){
var inst_29574 = (state_29696[(2)]);
var inst_29575 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_29576 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_29696__$1 = (function (){var statearr_29767 = state_29696;
(statearr_29767[(28)] = inst_29575);

(statearr_29767[(42)] = inst_29574);

return statearr_29767;
})();
if(cljs.core.truth_(inst_29576)){
var statearr_29768_29890 = state_29696__$1;
(statearr_29768_29890[(1)] = (52));

} else {
var statearr_29769_29891 = state_29696__$1;
(statearr_29769_29891[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (25))){
var state_29696__$1 = state_29696;
var statearr_29770_29892 = state_29696__$1;
(statearr_29770_29892[(2)] = (-1));

(statearr_29770_29892[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (34))){
var inst_29477 = (state_29696[(54)]);
var state_29696__$1 = state_29696;
var statearr_29771_29893 = state_29696__$1;
(statearr_29771_29893[(2)] = inst_29477);

(statearr_29771_29893[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (17))){
var inst_29507 = (state_29696[(2)]);
var inst_29508 = fluree.db.util.async.throw_err(inst_29507);
var state_29696__$1 = state_29696;
var statearr_29772_29894 = state_29696__$1;
(statearr_29772_29894[(2)] = inst_29508);

(statearr_29772_29894[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (3))){
var inst_29694 = (state_29696[(2)]);
var state_29696__$1 = state_29696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29696__$1,inst_29694);
} else {
if((state_val_29697 === (12))){
var inst_29474 = (state_29696[(50)]);
var inst_29502 = (state_29696[(2)]);
var inst_29503 = fluree.db.util.core.pred_ident_QMARK_(inst_29474);
var state_29696__$1 = (function (){var statearr_29773 = state_29696;
(statearr_29773[(26)] = inst_29502);

return statearr_29773;
})();
if(inst_29503){
var statearr_29774_29895 = state_29696__$1;
(statearr_29774_29895[(1)] = (14));

} else {
var statearr_29775_29896 = state_29696__$1;
(statearr_29775_29896[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (2))){
var inst_29478 = (state_29696[(40)]);
var inst_29471 = (state_29696[(44)]);
var inst_29472 = (state_29696[(14)]);
var _ = (function (){var statearr_29776 = state_29696;
(statearr_29776[(4)] = cljs.core.cons((5),(state_29696[(4)])));

return statearr_29776;
})();
var inst_29471__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_29472__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29471__$1,(0),null);
var inst_29473 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29471__$1,(1),null);
var inst_29474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29471__$1,(2),null);
var inst_29475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29471__$1,(3),null);
var inst_29476 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29471__$1,(4),null);
var inst_29477 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29471__$1,(5),null);
var inst_29478__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_29479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29478__$1,(0),null);
var inst_29480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29478__$1,(1),null);
var inst_29481 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29478__$1,(2),null);
var inst_29482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29478__$1,(3),null);
var inst_29483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29478__$1,(4),null);
var inst_29484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29478__$1,(5),null);
var inst_29485 = fluree.db.util.core.pred_ident_QMARK_(inst_29472__$1);
var state_29696__$1 = (function (){var statearr_29777 = state_29696;
(statearr_29777[(53)] = inst_29484);

(statearr_29777[(58)] = inst_29479);

(statearr_29777[(50)] = inst_29474);

(statearr_29777[(35)] = inst_29475);

(statearr_29777[(54)] = inst_29477);

(statearr_29777[(37)] = inst_29476);

(statearr_29777[(38)] = inst_29482);

(statearr_29777[(40)] = inst_29478__$1);

(statearr_29777[(20)] = inst_29473);

(statearr_29777[(47)] = inst_29480);

(statearr_29777[(44)] = inst_29471__$1);

(statearr_29777[(45)] = inst_29483);

(statearr_29777[(59)] = inst_29481);

(statearr_29777[(14)] = inst_29472__$1);

return statearr_29777;
})();
if(inst_29485){
var statearr_29778_29897 = state_29696__$1;
(statearr_29778_29897[(1)] = (6));

} else {
var statearr_29779_29898 = state_29696__$1;
(statearr_29779_29898[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (66))){
var inst_29635 = (state_29696[(13)]);
var inst_29627 = (state_29696[(55)]);
var inst_29637 = (state_29696[(60)]);
var inst_29634 = cljs.core.seq(inst_29627);
var inst_29635__$1 = cljs.core.first(inst_29634);
var inst_29636 = cljs.core.next(inst_29634);
var inst_29637__$1 = (inst_29635__$1 == null);
var state_29696__$1 = (function (){var statearr_29780 = state_29696;
(statearr_29780[(13)] = inst_29635__$1);

(statearr_29780[(61)] = inst_29636);

(statearr_29780[(60)] = inst_29637__$1);

return statearr_29780;
})();
if(cljs.core.truth_(inst_29637__$1)){
var statearr_29781_29899 = state_29696__$1;
(statearr_29781_29899[(1)] = (68));

} else {
var statearr_29782_29900 = state_29696__$1;
(statearr_29782_29900[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (23))){
var inst_29521 = (state_29696[(19)]);
var state_29696__$1 = state_29696;
var statearr_29783_29901 = state_29696__$1;
(statearr_29783_29901[(2)] = inst_29521);

(statearr_29783_29901[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (47))){
var state_29696__$1 = state_29696;
var statearr_29784_29902 = state_29696__$1;
(statearr_29784_29902[(2)] = fluree.db.util.core.max_long);

(statearr_29784_29902[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (35))){
var inst_29541 = (cljs.core._GT__EQ_ === start_test);
var state_29696__$1 = state_29696;
if(cljs.core.truth_(inst_29541)){
var statearr_29785_29903 = state_29696__$1;
(statearr_29785_29903[(1)] = (37));

} else {
var statearr_29786_29904 = state_29696__$1;
(statearr_29786_29904[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (82))){
var inst_29611 = (state_29696[(7)]);
var state_29696__$1 = state_29696;
var statearr_29787_29905 = state_29696__$1;
(statearr_29787_29905[(2)] = inst_29611);

(statearr_29787_29905[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (76))){
var inst_29646 = (state_29696[(23)]);
var inst_29636 = (state_29696[(61)]);
var inst_29660 = (state_29696[(2)]);
var inst_29627 = inst_29636;
var inst_29628 = inst_29646;
var inst_29629 = inst_29660;
var state_29696__$1 = (function (){var statearr_29788 = state_29696;
(statearr_29788[(55)] = inst_29627);

(statearr_29788[(52)] = inst_29629);

(statearr_29788[(22)] = inst_29628);

return statearr_29788;
})();
var statearr_29789_29906 = state_29696__$1;
(statearr_29789_29906[(2)] = null);

(statearr_29789_29906[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (19))){
var inst_29481 = (state_29696[(59)]);
var state_29696__$1 = state_29696;
var statearr_29790_29907 = state_29696__$1;
(statearr_29790_29907[(2)] = inst_29481);

(statearr_29790_29907[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (57))){
var inst_29585 = (state_29696[(24)]);
var inst_29575 = (state_29696[(28)]);
var inst_29574 = (state_29696[(42)]);
var inst_29595 = (state_29696[(11)]);
var inst_29599 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_29595,inst_29574,inst_29575,inst_29585);
var state_29696__$1 = state_29696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29696__$1,(59),inst_29599);
} else {
if((state_val_29697 === (68))){
var inst_29637 = (state_29696[(60)]);
var state_29696__$1 = state_29696;
var statearr_29791_29908 = state_29696__$1;
(statearr_29791_29908[(2)] = inst_29637);

(statearr_29791_29908[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (11))){
var inst_29479 = (state_29696[(58)]);
var state_29696__$1 = state_29696;
var statearr_29793_29909 = state_29696__$1;
(statearr_29793_29909[(2)] = inst_29479);

(statearr_29793_29909[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (9))){
var inst_29489 = (state_29696[(2)]);
var inst_29490 = fluree.db.util.async.throw_err(inst_29489);
var state_29696__$1 = state_29696;
var statearr_29794_29910 = state_29696__$1;
(statearr_29794_29910[(2)] = inst_29490);

(statearr_29794_29910[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (5))){
var _ = (function (){var statearr_29795 = state_29696;
(statearr_29795[(4)] = cljs.core.rest((state_29696[(4)])));

return statearr_29795;
})();
var state_29696__$1 = state_29696;
var ex29792 = (state_29696__$1[(2)]);
var statearr_29796_29911 = state_29696__$1;
(statearr_29796_29911[(5)] = ex29792);


if((ex29792 instanceof Error)){
var statearr_29797_29912 = state_29696__$1;
(statearr_29797_29912[(1)] = (4));

(statearr_29797_29912[(5)] = null);

} else {
throw ex29792;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (83))){
var inst_29679 = (state_29696[(2)]);
var inst_29680 = cljs.core.not(inst_29679);
var state_29696__$1 = state_29696;
if(inst_29680){
var statearr_29798_29913 = state_29696__$1;
(statearr_29798_29913[(1)] = (87));

} else {
var statearr_29799_29914 = state_29696__$1;
(statearr_29799_29914[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (14))){
var inst_29474 = (state_29696[(50)]);
var inst_29505 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29474);
var state_29696__$1 = state_29696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29696__$1,(17),inst_29505);
} else {
if((state_val_29697 === (45))){
var inst_29554 = (state_29696[(2)]);
var state_29696__$1 = state_29696;
var statearr_29800_29915 = state_29696__$1;
(statearr_29800_29915[(2)] = inst_29554);

(statearr_29800_29915[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (53))){
var state_29696__$1 = state_29696;
var statearr_29801_29916 = state_29696__$1;
(statearr_29801_29916[(2)] = true);

(statearr_29801_29916[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (78))){
var inst_29629 = (state_29696[(52)]);
var state_29696__$1 = state_29696;
var statearr_29802_29917 = state_29696__$1;
(statearr_29802_29917[(2)] = inst_29629);

(statearr_29802_29917[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (26))){
var inst_29473 = (state_29696[(20)]);
var state_29696__$1 = state_29696;
var statearr_29803_29918 = state_29696__$1;
(statearr_29803_29918[(2)] = inst_29473);

(statearr_29803_29918[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (16))){
var inst_29481 = (state_29696[(59)]);
var inst_29511 = (state_29696[(2)]);
var inst_29512 = fluree.db.util.core.pred_ident_QMARK_(inst_29481);
var state_29696__$1 = (function (){var statearr_29804 = state_29696;
(statearr_29804[(34)] = inst_29511);

return statearr_29804;
})();
if(inst_29512){
var statearr_29805_29919 = state_29696__$1;
(statearr_29805_29919[(1)] = (18));

} else {
var statearr_29806_29920 = state_29696__$1;
(statearr_29806_29920[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (81))){
var inst_29611 = (state_29696[(7)]);
var inst_29558 = (state_29696[(15)]);
var inst_29568 = (state_29696[(36)]);
var inst_29671 = (state_29696[(48)]);
var inst_29670 = (inst_29568.cljs$core$IFn$_invoke$arity$2 ? inst_29568.cljs$core$IFn$_invoke$arity$2(inst_29611,inst_29558) : inst_29568.call(null,inst_29611,inst_29558));
var inst_29671__$1 = (inst_29670 < (0));
var state_29696__$1 = (function (){var statearr_29807 = state_29696;
(statearr_29807[(48)] = inst_29671__$1);

return statearr_29807;
})();
if(cljs.core.truth_(inst_29671__$1)){
var statearr_29808_29921 = state_29696__$1;
(statearr_29808_29921[(1)] = (84));

} else {
var statearr_29809_29922 = state_29696__$1;
(statearr_29809_29922[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (79))){
var inst_29635 = (state_29696[(13)]);
var inst_29629 = (state_29696[(52)]);
var inst_29655 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_29629,inst_29635);
var state_29696__$1 = state_29696;
var statearr_29810_29923 = state_29696__$1;
(statearr_29810_29923[(2)] = inst_29655);

(statearr_29810_29923[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (38))){
var state_29696__$1 = state_29696;
var statearr_29811_29924 = state_29696__$1;
(statearr_29811_29924[(2)] = (2147483647));

(statearr_29811_29924[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (87))){
var inst_29667 = (state_29696[(8)]);
var state_29696__$1 = state_29696;
var statearr_29812_29925 = state_29696__$1;
(statearr_29812_29925[(2)] = inst_29667);

(statearr_29812_29925[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (30))){
var inst_29534 = (state_29696[(2)]);
var state_29696__$1 = state_29696;
if(cljs.core.truth_(inst_29534)){
var statearr_29813_29926 = state_29696__$1;
(statearr_29813_29926[(1)] = (31));

} else {
var statearr_29814_29927 = state_29696__$1;
(statearr_29814_29927[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (73))){
var inst_29663 = (state_29696[(2)]);
var state_29696__$1 = state_29696;
var statearr_29815_29928 = state_29696__$1;
(statearr_29815_29928[(2)] = inst_29663);

(statearr_29815_29928[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (10))){
var inst_29479 = (state_29696[(58)]);
var inst_29496 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29479);
var state_29696__$1 = state_29696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29696__$1,(13),inst_29496);
} else {
if((state_val_29697 === (18))){
var inst_29481 = (state_29696[(59)]);
var inst_29514 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29481);
var state_29696__$1 = state_29696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29696__$1,(21),inst_29514);
} else {
if((state_val_29697 === (52))){
var inst_29502 = (state_29696[(26)]);
var inst_29493 = (state_29696[(27)]);
var inst_29538 = (state_29696[(30)]);
var inst_29564 = (state_29696[(31)]);
var inst_29529 = (state_29696[(32)]);
var inst_29578 = fluree.db.permissions_validate.no_filter_QMARK_(inst_29564,inst_29493,inst_29502,inst_29529,inst_29538);
var state_29696__$1 = state_29696;
var statearr_29816_29929 = state_29696__$1;
(statearr_29816_29929[(2)] = inst_29578);

(statearr_29816_29929[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (67))){
var inst_29665 = (state_29696[(2)]);
var state_29696__$1 = state_29696;
var statearr_29817_29930 = state_29696__$1;
(statearr_29817_29930[(2)] = inst_29665);

(statearr_29817_29930[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (71))){
var inst_29629 = (state_29696[(52)]);
var inst_29597 = (state_29696[(41)]);
var inst_29644 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29629,inst_29597);
var state_29696__$1 = state_29696;
var statearr_29818_29931 = state_29696__$1;
(statearr_29818_29931[(2)] = inst_29644);

(statearr_29818_29931[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (42))){
var inst_29502 = (state_29696[(26)]);
var inst_29493 = (state_29696[(27)]);
var inst_29547 = (state_29696[(29)]);
var inst_29538 = (state_29696[(30)]);
var inst_29529 = (state_29696[(32)]);
var inst_29511 = (state_29696[(34)]);
var inst_29475 = (state_29696[(35)]);
var inst_29476 = (state_29696[(37)]);
var inst_29482 = (state_29696[(38)]);
var inst_29556 = (state_29696[(43)]);
var inst_29520 = (state_29696[(21)]);
var inst_29483 = (state_29696[(45)]);
var inst_29559 = (state_29696[(49)]);
var inst_29556__$1 = (state_29696[(2)]);
var inst_29557 = fluree.db.flake.__GT_Flake(inst_29493,inst_29529,inst_29511,inst_29475,inst_29476,inst_29547);
var inst_29558 = fluree.db.flake.__GT_Flake(inst_29502,inst_29538,inst_29520,inst_29482,inst_29483,inst_29556__$1);
var inst_29559__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_29696__$1 = (function (){var statearr_29819 = state_29696;
(statearr_29819[(15)] = inst_29558);

(statearr_29819[(16)] = inst_29557);

(statearr_29819[(43)] = inst_29556__$1);

(statearr_29819[(49)] = inst_29559__$1);

return statearr_29819;
})();
if(cljs.core.truth_(inst_29559__$1)){
var statearr_29820_29932 = state_29696__$1;
(statearr_29820_29932[(1)] = (46));

} else {
var statearr_29821_29933 = state_29696__$1;
(statearr_29821_29933[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (80))){
var inst_29657 = (state_29696[(2)]);
var state_29696__$1 = state_29696;
var statearr_29822_29934 = state_29696__$1;
(statearr_29822_29934[(2)] = inst_29657);

(statearr_29822_29934[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (37))){
var state_29696__$1 = state_29696;
var statearr_29823_29935 = state_29696__$1;
(statearr_29823_29935[(2)] = fluree.db.util.core.min_integer);

(statearr_29823_29935[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (63))){
var inst_29596 = (state_29696[(33)]);
var inst_29563 = (state_29696[(39)]);
var inst_29597 = (state_29696[(41)]);
var inst_29610 = (state_29696[(12)]);
var inst_29613 = (inst_29563 - inst_29596);
var inst_29614 = fluree.db.flake.take(inst_29613,inst_29610);
var inst_29615 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29614,inst_29597);
var state_29696__$1 = state_29696;
var statearr_29824_29936 = state_29696__$1;
(statearr_29824_29936[(2)] = inst_29615);

(statearr_29824_29936[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (8))){
var inst_29479 = (state_29696[(58)]);
var inst_29493 = (state_29696[(2)]);
var inst_29494 = fluree.db.util.core.pred_ident_QMARK_(inst_29479);
var state_29696__$1 = (function (){var statearr_29825 = state_29696;
(statearr_29825[(27)] = inst_29493);

return statearr_29825;
})();
if(inst_29494){
var statearr_29826_29937 = state_29696__$1;
(statearr_29826_29937[(1)] = (10));

} else {
var statearr_29827_29938 = state_29696__$1;
(statearr_29827_29938[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (49))){
var inst_29569 = (state_29696[(51)]);
var state_29696__$1 = state_29696;
var statearr_29828_29939 = state_29696__$1;
(statearr_29828_29939[(2)] = inst_29569);

(statearr_29828_29939[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29697 === (84))){
var inst_29563 = (state_29696[(39)]);
var inst_29668 = (state_29696[(9)]);
var inst_29673 = (inst_29668 < inst_29563);
var state_29696__$1 = state_29696;
var statearr_29829_29940 = state_29696__$1;
(statearr_29829_29940[(2)] = inst_29673);

(statearr_29829_29940[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16395__auto__ = null;
var fluree$db$query$range$state_machine__16395__auto____0 = (function (){
var statearr_29830 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29830[(0)] = fluree$db$query$range$state_machine__16395__auto__);

(statearr_29830[(1)] = (1));

return statearr_29830;
});
var fluree$db$query$range$state_machine__16395__auto____1 = (function (state_29696){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_29696);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e29831){var ex__16398__auto__ = e29831;
var statearr_29832_29941 = state_29696;
(statearr_29832_29941[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_29696[(4)]))){
var statearr_29833_29942 = state_29696;
(statearr_29833_29942[(1)] = cljs.core.first((state_29696[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__29943 = state_29696;
state_29696 = G__29943;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16395__auto__ = function(state_29696){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16395__auto____1.call(this,state_29696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16395__auto____0;
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16395__auto____1;
return fluree$db$query$range$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_29834 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_29834[(6)] = c__16469__auto__);

return statearr_29834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_30018){
var state_val_30019 = (state_30018[(1)]);
if((state_val_30019 === (7))){
var inst_30013 = (state_30018[(2)]);
var _ = (function (){var statearr_30020 = state_30018;
(statearr_30020[(4)] = cljs.core.rest((state_30018[(4)])));

return statearr_30020;
})();
var state_30018__$1 = state_30018;
var statearr_30021_30061 = state_30018__$1;
(statearr_30021_30061[(2)] = inst_30013);

(statearr_30021_30061[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (20))){
var inst_29995 = (state_30018[(2)]);
var inst_29996 = fluree.db.util.async.throw_err(inst_29995);
var state_30018__$1 = state_30018;
var statearr_30022_30062 = state_30018__$1;
(statearr_30022_30062[(2)] = inst_29996);

(statearr_30022_30062[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (1))){
var state_30018__$1 = state_30018;
var statearr_30023_30063 = state_30018__$1;
(statearr_30023_30063[(2)] = null);

(statearr_30023_30063[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (4))){
var inst_29944 = (state_30018[(2)]);
var state_30018__$1 = state_30018;
var statearr_30024_30064 = state_30018__$1;
(statearr_30024_30064[(2)] = inst_29944);

(statearr_30024_30064[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (15))){
var inst_29991 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_30018__$1 = state_30018;
if(cljs.core.truth_(inst_29991)){
var statearr_30025_30065 = state_30018__$1;
(statearr_30025_30065[(1)] = (17));

} else {
var statearr_30026_30066 = state_30018__$1;
(statearr_30026_30066[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (21))){
var state_30018__$1 = state_30018;
var statearr_30027_30067 = state_30018__$1;
(statearr_30027_30067[(2)] = (0));

(statearr_30027_30067[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (13))){
var inst_29983 = (state_30018[(2)]);
var state_30018__$1 = state_30018;
var statearr_30028_30068 = state_30018__$1;
(statearr_30028_30068[(2)] = inst_29983);

(statearr_30028_30068[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (22))){
var state_30018__$1 = state_30018;
var statearr_30029_30069 = state_30018__$1;
(statearr_30029_30069[(2)] = (1));

(statearr_30029_30069[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (6))){
var inst_29975 = (state_30018[(7)]);
var inst_29964 = (state_30018[(8)]);
var inst_29973 = (state_30018[(9)]);
var inst_29972 = cljs.core.seq(inst_29964);
var inst_29973__$1 = cljs.core.first(inst_29972);
var inst_29974 = cljs.core.next(inst_29972);
var inst_29975__$1 = (inst_29973__$1 == null);
var state_30018__$1 = (function (){var statearr_30030 = state_30018;
(statearr_30030[(7)] = inst_29975__$1);

(statearr_30030[(10)] = inst_29974);

(statearr_30030[(9)] = inst_29973__$1);

return statearr_30030;
})();
if(cljs.core.truth_(inst_29975__$1)){
var statearr_30031_30070 = state_30018__$1;
(statearr_30031_30070[(1)] = (8));

} else {
var statearr_30032_30071 = state_30018__$1;
(statearr_30032_30071[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (17))){
var inst_29973 = (state_30018[(9)]);
var inst_29993 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_29973);
var state_30018__$1 = state_30018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30018__$1,(20),inst_29993);
} else {
if((state_val_30019 === (3))){
var inst_30016 = (state_30018[(2)]);
var state_30018__$1 = state_30018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30018__$1,inst_30016);
} else {
if((state_val_30019 === (12))){
var inst_29966 = (state_30018[(11)]);
var inst_29981 = (inst_29966 >= subject_limit);
var state_30018__$1 = state_30018;
var statearr_30033_30072 = state_30018__$1;
(statearr_30033_30072[(2)] = inst_29981);

(statearr_30033_30072[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (2))){
var _ = (function (){var statearr_30034 = state_30018;
(statearr_30034[(4)] = cljs.core.cons((5),(state_30018[(4)])));

return statearr_30034;
})();
var inst_29957 = subject_groups;
var inst_29958 = cljs.core.seq(inst_29957);
var inst_29959 = cljs.core.first(inst_29958);
var inst_29960 = cljs.core.next(inst_29958);
var inst_29961 = flake_start;
var inst_29962 = subject_start;
var inst_29963 = cljs.core.PersistentVector.EMPTY;
var inst_29964 = inst_29957;
var inst_29965 = inst_29961;
var inst_29966 = inst_29962;
var inst_29967 = inst_29963;
var state_30018__$1 = (function (){var statearr_30035 = state_30018;
(statearr_30035[(12)] = inst_29960);

(statearr_30035[(8)] = inst_29964);

(statearr_30035[(13)] = inst_29959);

(statearr_30035[(14)] = inst_29965);

(statearr_30035[(11)] = inst_29966);

(statearr_30035[(15)] = inst_29967);

return statearr_30035;
})();
var statearr_30036_30073 = state_30018__$1;
(statearr_30036_30073[(2)] = null);

(statearr_30036_30073[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (23))){
var inst_29999 = (state_30018[(16)]);
var inst_29965 = (state_30018[(14)]);
var inst_29966 = (state_30018[(11)]);
var inst_29974 = (state_30018[(10)]);
var inst_29967 = (state_30018[(15)]);
var inst_30000 = (state_30018[(17)]);
var inst_30005 = (state_30018[(2)]);
var inst_30006 = (inst_29965 + inst_30000);
var inst_30007 = (inst_29966 + inst_30005);
var inst_30008 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29967,inst_29999);
var inst_29964 = inst_29974;
var inst_29965__$1 = inst_30006;
var inst_29966__$1 = inst_30007;
var inst_29967__$1 = inst_30008;
var state_30018__$1 = (function (){var statearr_30037 = state_30018;
(statearr_30037[(8)] = inst_29964);

(statearr_30037[(14)] = inst_29965__$1);

(statearr_30037[(11)] = inst_29966__$1);

(statearr_30037[(15)] = inst_29967__$1);

return statearr_30037;
})();
var statearr_30038_30074 = state_30018__$1;
(statearr_30038_30074[(2)] = null);

(statearr_30038_30074[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (19))){
var inst_29999 = (state_30018[(16)]);
var inst_30000 = (state_30018[(17)]);
var inst_29999__$1 = (state_30018[(2)]);
var inst_30000__$1 = cljs.core.count(inst_29999__$1);
var inst_30001 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_30000__$1);
var state_30018__$1 = (function (){var statearr_30039 = state_30018;
(statearr_30039[(16)] = inst_29999__$1);

(statearr_30039[(17)] = inst_30000__$1);

return statearr_30039;
})();
if(inst_30001){
var statearr_30040_30075 = state_30018__$1;
(statearr_30040_30075[(1)] = (21));

} else {
var statearr_30041_30076 = state_30018__$1;
(statearr_30041_30076[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (11))){
var inst_29978 = (state_30018[(18)]);
var state_30018__$1 = state_30018;
var statearr_30043_30077 = state_30018__$1;
(statearr_30043_30077[(2)] = inst_29978);

(statearr_30043_30077[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (9))){
var inst_29978 = (state_30018[(18)]);
var inst_29965 = (state_30018[(14)]);
var inst_29978__$1 = (inst_29965 >= flake_limit);
var state_30018__$1 = (function (){var statearr_30044 = state_30018;
(statearr_30044[(18)] = inst_29978__$1);

return statearr_30044;
})();
if(cljs.core.truth_(inst_29978__$1)){
var statearr_30045_30078 = state_30018__$1;
(statearr_30045_30078[(1)] = (11));

} else {
var statearr_30046_30079 = state_30018__$1;
(statearr_30046_30079[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (5))){
var _ = (function (){var statearr_30047 = state_30018;
(statearr_30047[(4)] = cljs.core.rest((state_30018[(4)])));

return statearr_30047;
})();
var state_30018__$1 = state_30018;
var ex30042 = (state_30018__$1[(2)]);
var statearr_30048_30080 = state_30018__$1;
(statearr_30048_30080[(5)] = ex30042);


if((ex30042 instanceof Error)){
var statearr_30049_30081 = state_30018__$1;
(statearr_30049_30081[(1)] = (4));

(statearr_30049_30081[(5)] = null);

} else {
throw ex30042;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (14))){
var inst_29965 = (state_30018[(14)]);
var inst_29966 = (state_30018[(11)]);
var inst_29967 = (state_30018[(15)]);
var inst_29987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29988 = [inst_29965,inst_29966,inst_29967];
var inst_29989 = (new cljs.core.PersistentVector(null,3,(5),inst_29987,inst_29988,null));
var state_30018__$1 = state_30018;
var statearr_30050_30082 = state_30018__$1;
(statearr_30050_30082[(2)] = inst_29989);

(statearr_30050_30082[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (16))){
var inst_30011 = (state_30018[(2)]);
var state_30018__$1 = state_30018;
var statearr_30051_30083 = state_30018__$1;
(statearr_30051_30083[(2)] = inst_30011);

(statearr_30051_30083[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (10))){
var inst_29985 = (state_30018[(2)]);
var state_30018__$1 = state_30018;
if(cljs.core.truth_(inst_29985)){
var statearr_30052_30084 = state_30018__$1;
(statearr_30052_30084[(1)] = (14));

} else {
var statearr_30053_30085 = state_30018__$1;
(statearr_30053_30085[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (18))){
var inst_29973 = (state_30018[(9)]);
var state_30018__$1 = state_30018;
var statearr_30054_30086 = state_30018__$1;
(statearr_30054_30086[(2)] = inst_29973);

(statearr_30054_30086[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30019 === (8))){
var inst_29975 = (state_30018[(7)]);
var state_30018__$1 = state_30018;
var statearr_30055_30087 = state_30018__$1;
(statearr_30055_30087[(2)] = inst_29975);

(statearr_30055_30087[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto____0 = (function (){
var statearr_30056 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30056[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto__);

(statearr_30056[(1)] = (1));

return statearr_30056;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto____1 = (function (state_30018){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_30018);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e30057){var ex__16398__auto__ = e30057;
var statearr_30058_30088 = state_30018;
(statearr_30058_30088[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_30018[(4)]))){
var statearr_30059_30089 = state_30018;
(statearr_30059_30089[(1)] = cljs.core.first((state_30018[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__30090 = state_30018;
state_30018 = G__30090;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto__ = function(state_30018){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto____1.call(this,state_30018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_30060 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_30060[(6)] = c__16469__auto__);

return statearr_30060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_30136){
var state_val_30137 = (state_30136[(1)]);
if((state_val_30137 === (7))){
var state_30136__$1 = state_30136;
var statearr_30138_30176 = state_30136__$1;
(statearr_30138_30176[(2)] = null);

(statearr_30138_30176[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (20))){
var inst_30122 = (state_30136[(2)]);
var inst_30123 = fluree.db.util.async.throw_err(inst_30122);
var inst_30101 = inst_30123;
var state_30136__$1 = (function (){var statearr_30139 = state_30136;
(statearr_30139[(7)] = inst_30101);

return statearr_30139;
})();
var statearr_30140_30177 = state_30136__$1;
(statearr_30140_30177[(2)] = null);

(statearr_30140_30177[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (1))){
var state_30136__$1 = state_30136;
var statearr_30141_30178 = state_30136__$1;
(statearr_30141_30178[(2)] = null);

(statearr_30141_30178[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (4))){
var inst_30091 = (state_30136[(2)]);
var state_30136__$1 = state_30136;
var statearr_30142_30179 = state_30136__$1;
(statearr_30142_30179[(2)] = inst_30091);

(statearr_30142_30179[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (15))){
var inst_30101 = (state_30136[(7)]);
var inst_30118 = (state_30136[(8)]);
var inst_30118__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_30101);
var state_30136__$1 = (function (){var statearr_30143 = state_30136;
(statearr_30143[(8)] = inst_30118__$1);

return statearr_30143;
})();
if(cljs.core.truth_(inst_30118__$1)){
var statearr_30144_30180 = state_30136__$1;
(statearr_30144_30180[(1)] = (17));

} else {
var statearr_30145_30181 = state_30136__$1;
(statearr_30145_30181[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (13))){
var inst_30111 = (state_30136[(2)]);
var inst_30112 = fluree.db.util.async.throw_err(inst_30111);
var _ = (function (){var statearr_30146 = state_30136;
(statearr_30146[(4)] = cljs.core.rest((state_30136[(4)])));

return statearr_30146;
})();
var state_30136__$1 = state_30136;
var statearr_30147_30182 = state_30136__$1;
(statearr_30147_30182[(2)] = inst_30112);

(statearr_30147_30182[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (6))){
var inst_30099 = (state_30136[(2)]);
var inst_30100 = fluree.db.util.async.throw_err(inst_30099);
var inst_30101 = inst_30100;
var state_30136__$1 = (function (){var statearr_30148 = state_30136;
(statearr_30148[(7)] = inst_30101);

return statearr_30148;
})();
var statearr_30149_30183 = state_30136__$1;
(statearr_30149_30183[(2)] = null);

(statearr_30149_30183[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (17))){
var inst_30118 = (state_30136[(8)]);
var inst_30120 = fluree.db.dbproto._lookup_leaf(root_node,inst_30118);
var state_30136__$1 = state_30136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30136__$1,(20),inst_30120);
} else {
if((state_val_30137 === (3))){
var inst_30134 = (state_30136[(2)]);
var state_30136__$1 = state_30136;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30136__$1,inst_30134);
} else {
if((state_val_30137 === (12))){
var _ = (function (){var statearr_30151 = state_30136;
(statearr_30151[(4)] = cljs.core.rest((state_30136[(4)])));

return statearr_30151;
})();
var state_30136__$1 = state_30136;
var ex30150 = (state_30136__$1[(2)]);
var statearr_30152_30184 = state_30136__$1;
(statearr_30152_30184[(5)] = ex30150);


var statearr_30153_30185 = state_30136__$1;
(statearr_30153_30185[(1)] = (11));

(statearr_30153_30185[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (2))){
var _ = (function (){var statearr_30154 = state_30136;
(statearr_30154[(4)] = cljs.core.cons((5),(state_30136[(4)])));

return statearr_30154;
})();
var inst_30097 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_30136__$1 = state_30136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30136__$1,(6),inst_30097);
} else {
if((state_val_30137 === (19))){
var inst_30127 = (state_30136[(2)]);
var state_30136__$1 = state_30136;
var statearr_30155_30186 = state_30136__$1;
(statearr_30155_30186[(2)] = inst_30127);

(statearr_30155_30186[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (11))){
var inst_30103 = (state_30136[(2)]);
var state_30136__$1 = (function (){var statearr_30157 = state_30136;
(statearr_30157[(9)] = inst_30103);

return statearr_30157;
})();
var statearr_30158_30187 = state_30136__$1;
(statearr_30158_30187[(2)] = null);

(statearr_30158_30187[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (9))){
var inst_30101 = (state_30136[(7)]);
var _ = (function (){var statearr_30159 = state_30136;
(statearr_30159[(4)] = cljs.core.cons((12),(state_30136[(4)])));

return statearr_30159;
})();
var inst_30109 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_30101,t,novelty,fast_forward_db_QMARK_);
var state_30136__$1 = state_30136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30136__$1,(13),inst_30109);
} else {
if((state_val_30137 === (5))){
var _ = (function (){var statearr_30160 = state_30136;
(statearr_30160[(4)] = cljs.core.rest((state_30136[(4)])));

return statearr_30160;
})();
var state_30136__$1 = state_30136;
var ex30156 = (state_30136__$1[(2)]);
var statearr_30161_30188 = state_30136__$1;
(statearr_30161_30188[(5)] = ex30156);


if((ex30156 instanceof Error)){
var statearr_30162_30189 = state_30136__$1;
(statearr_30162_30189[(1)] = (4));

(statearr_30162_30189[(5)] = null);

} else {
throw ex30156;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (14))){
var inst_30115 = (state_30136[(10)]);
var state_30136__$1 = state_30136;
var statearr_30163_30190 = state_30136__$1;
(statearr_30163_30190[(2)] = inst_30115);

(statearr_30163_30190[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (16))){
var inst_30129 = (state_30136[(2)]);
var state_30136__$1 = state_30136;
var statearr_30164_30191 = state_30136__$1;
(statearr_30164_30191[(2)] = inst_30129);

(statearr_30164_30191[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (10))){
var inst_30115 = (state_30136[(10)]);
var inst_30115__$1 = (state_30136[(2)]);
var state_30136__$1 = (function (){var statearr_30165 = state_30136;
(statearr_30165[(10)] = inst_30115__$1);

return statearr_30165;
})();
if(cljs.core.truth_(inst_30115__$1)){
var statearr_30166_30192 = state_30136__$1;
(statearr_30166_30192[(1)] = (14));

} else {
var statearr_30167_30193 = state_30136__$1;
(statearr_30167_30193[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (18))){
var state_30136__$1 = state_30136;
var statearr_30168_30194 = state_30136__$1;
(statearr_30168_30194[(2)] = null);

(statearr_30168_30194[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30137 === (8))){
var inst_30131 = (state_30136[(2)]);
var _ = (function (){var statearr_30169 = state_30136;
(statearr_30169[(4)] = cljs.core.rest((state_30136[(4)])));

return statearr_30169;
})();
var state_30136__$1 = state_30136;
var statearr_30170_30195 = state_30136__$1;
(statearr_30170_30195[(2)] = inst_30131);

(statearr_30170_30195[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto____0 = (function (){
var statearr_30171 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30171[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto__);

(statearr_30171[(1)] = (1));

return statearr_30171;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto____1 = (function (state_30136){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_30136);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e30172){var ex__16398__auto__ = e30172;
var statearr_30173_30196 = state_30136;
(statearr_30173_30196[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_30136[(4)]))){
var statearr_30174_30197 = state_30136;
(statearr_30174_30197[(1)] = cljs.core.first((state_30136[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__30198 = state_30136;
state_30136 = G__30198;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto__ = function(state_30136){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto____1.call(this,state_30136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_30175 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_30175[(6)] = c__16469__auto__);

return statearr_30175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__30205 = arguments.length;
switch (G__30205) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__30206 = (function (){var pred__30209 = cljs.core.identical_QMARK_;
var expr__30210 = test;
if(cljs.core.truth_((pred__30209.cljs$core$IFn$_invoke$arity$2 ? pred__30209.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__30210) : pred__30209.call(null,cljs.core._EQ_,expr__30210)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__30209.cljs$core$IFn$_invoke$arity$2 ? pred__30209.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__30210) : pred__30209.call(null,cljs.core._LT_,expr__30210)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__30209.cljs$core$IFn$_invoke$arity$2 ? pred__30209.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__30210) : pred__30209.call(null,cljs.core._LT__EQ_,expr__30210)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__30209.cljs$core$IFn$_invoke$arity$2 ? pred__30209.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__30210) : pred__30209.call(null,cljs.core._GT_,expr__30210)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__30209.cljs$core$IFn$_invoke$arity$2 ? pred__30209.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__30210) : pred__30209.call(null,cljs.core._GT__EQ_,expr__30210)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__30210)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30206,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30206,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30206,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30206,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_30582){
var state_val_30583 = (state_30582[(1)]);
if((state_val_30583 === (121))){
var inst_30538 = (state_30582[(7)]);
var state_30582__$1 = state_30582;
var statearr_30584_30780 = state_30582__$1;
(statearr_30584_30780[(2)] = inst_30538);

(statearr_30584_30780[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (65))){
var inst_30390 = (state_30582[(8)]);
var inst_30396 = (state_30582[(2)]);
var state_30582__$1 = (function (){var statearr_30585 = state_30582;
(statearr_30585[(9)] = inst_30396);

return statearr_30585;
})();
if(cljs.core.truth_(inst_30390)){
var statearr_30586_30781 = state_30582__$1;
(statearr_30586_30781[(1)] = (66));

} else {
var statearr_30587_30782 = state_30582__$1;
(statearr_30587_30782[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (70))){
var inst_30574 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
var statearr_30588_30783 = state_30582__$1;
(statearr_30588_30783[(2)] = inst_30574);

(statearr_30588_30783[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (62))){
var inst_30389 = (state_30582[(2)]);
var inst_30390 = fluree.db.util.async.throw_err(inst_30389);
var inst_30391 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_30582__$1 = (function (){var statearr_30589 = state_30582;
(statearr_30589[(8)] = inst_30390);

return statearr_30589;
})();
if(cljs.core.truth_(inst_30391)){
var statearr_30590_30784 = state_30582__$1;
(statearr_30590_30784[(1)] = (63));

} else {
var statearr_30591_30785 = state_30582__$1;
(statearr_30591_30785[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (74))){
var inst_30409 = (state_30582[(10)]);
var inst_30243 = (state_30582[(11)]);
var inst_30301 = (state_30582[(12)]);
var inst_30399 = (state_30582[(13)]);
var inst_30236 = (state_30582[(14)]);
var inst_30362 = (state_30582[(15)]);
var inst_30403 = (state_30582[(16)]);
var inst_30300 = (state_30582[(17)]);
var inst_30249 = (state_30582[(18)]);
var inst_30380 = (state_30582[(19)]);
var inst_30322 = (state_30582[(20)]);
var inst_30400 = (state_30582[(21)]);
var inst_30370 = (state_30582[(22)]);
var inst_30232 = (state_30582[(23)]);
var inst_30390 = (state_30582[(8)]);
var inst_30381 = (state_30582[(24)]);
var inst_30259 = (state_30582[(25)]);
var inst_30359 = (state_30582[(26)]);
var inst_30376 = (state_30582[(27)]);
var inst_30268 = (state_30582[(28)]);
var inst_30247 = (state_30582[(29)]);
var inst_30239 = (state_30582[(30)]);
var inst_30375 = (state_30582[(31)]);
var inst_30244 = (state_30582[(32)]);
var inst_30369 = (state_30582[(33)]);
var inst_30304 = (state_30582[(34)]);
var inst_30396 = (state_30582[(9)]);
var inst_30313 = (state_30582[(35)]);
var inst_30401 = (state_30582[(36)]);
var inst_30248 = (state_30582[(37)]);
var inst_30386 = (state_30582[(38)]);
var inst_30358 = (state_30582[(39)]);
var inst_30340 = (state_30582[(40)]);
var inst_30363 = (state_30582[(41)]);
var inst_30237 = (state_30582[(42)]);
var inst_30402 = (state_30582[(43)]);
var inst_30371 = (state_30582[(44)]);
var inst_30360 = (state_30582[(45)]);
var inst_30349 = (state_30582[(46)]);
var inst_30331 = (state_30582[(47)]);
var inst_30417 = (state_30582[(48)]);
var inst_30419 = (function (){var no_filter_QMARK_ = inst_30396;
var t = inst_30376;
var max_limit_QMARK_ = inst_30370;
var next_node = inst_30399;
var fast_forward_db_QMARK_ = inst_30381;
var s1 = inst_30259;
var o2 = inst_30322;
var t1 = inst_30236;
var vec__30225 = inst_30300;
var predicate_fn = inst_30249;
var i = inst_30401;
var m1 = inst_30349;
var root_node = inst_30386;
var s2 = inst_30268;
var p2 = inst_30340;
var permissions = inst_30371;
var limit = inst_30369;
var start_flake = inst_30359;
var flake_limit = inst_30363;
var offset = inst_30400;
var acc = inst_30403;
var vec__30228 = inst_30301;
var t2 = inst_30243;
var vec__30221 = inst_30239;
var op1 = inst_30237;
var o1 = inst_30313;
var end_flake = inst_30360;
var base_result = inst_30409;
var s = inst_30402;
var node_start = inst_30390;
var p1 = inst_30331;
var subject_fn = inst_30248;
var vec__30218 = inst_30232;
var object_fn = inst_30304;
var idx_compare = inst_30375;
var map__30224 = inst_30247;
var G__30410 = inst_30417;
var map__30231 = inst_30362;
var op2 = inst_30244;
var m2 = inst_30358;
var novelty = inst_30380;
return (function (p1__30200_SHARP_){
var G__30592 = p1__30200_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__30592) : subject_fn.call(null,G__30592));
});
})();
var inst_30420 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_30419,inst_30417);
var state_30582__$1 = state_30582;
var statearr_30593_30786 = state_30582__$1;
(statearr_30593_30786[(2)] = inst_30420);

(statearr_30593_30786[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (110))){
var inst_30551 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
var statearr_30594_30787 = state_30582__$1;
(statearr_30594_30787[(2)] = inst_30551);

(statearr_30594_30787[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (7))){
var inst_30233 = (state_30582[(49)]);
var state_30582__$1 = state_30582;
var statearr_30595_30788 = state_30582__$1;
(statearr_30595_30788[(2)] = inst_30233);

(statearr_30595_30788[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (59))){
var state_30582__$1 = state_30582;
var statearr_30596_30789 = state_30582__$1;
(statearr_30596_30789[(2)] = fluree.db.util.core.max_long);

(statearr_30596_30789[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (86))){
var inst_30396 = (state_30582[(9)]);
var state_30582__$1 = state_30582;
var statearr_30597_30790 = state_30582__$1;
(statearr_30597_30790[(2)] = inst_30396);

(statearr_30597_30790[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (20))){
var state_30582__$1 = state_30582;
var statearr_30598_30791 = state_30582__$1;
(statearr_30598_30791[(2)] = null);

(statearr_30598_30791[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (72))){
var inst_30409 = (state_30582[(10)]);
var state_30582__$1 = state_30582;
var statearr_30599_30792 = state_30582__$1;
(statearr_30599_30792[(2)] = inst_30409);

(statearr_30599_30792[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (58))){
var inst_30364 = (state_30582[(50)]);
var state_30582__$1 = state_30582;
var statearr_30600_30793 = state_30582__$1;
(statearr_30600_30793[(2)] = inst_30364);

(statearr_30600_30793[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (60))){
var inst_30369 = (state_30582[(33)]);
var inst_30369__$1 = (state_30582[(2)]);
var inst_30370 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30369__$1,fluree.db.util.core.max_long);
var inst_30371 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_30372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30373 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_30374 = (new cljs.core.PersistentVector(null,3,(5),inst_30372,inst_30373,null));
var inst_30375 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_30374);
var inst_30376 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_30377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30378 = [cljs.core.cst$kw$novelty,idx];
var inst_30379 = (new cljs.core.PersistentVector(null,2,(5),inst_30377,inst_30378,null));
var inst_30380 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_30379);
var inst_30381 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_30382 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_30383 = fluree.db.dbproto._resolve(inst_30382);
var state_30582__$1 = (function (){var statearr_30601 = state_30582;
(statearr_30601[(19)] = inst_30380);

(statearr_30601[(22)] = inst_30370);

(statearr_30601[(24)] = inst_30381);

(statearr_30601[(27)] = inst_30376);

(statearr_30601[(31)] = inst_30375);

(statearr_30601[(33)] = inst_30369__$1);

(statearr_30601[(44)] = inst_30371);

return statearr_30601;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30582__$1,(61),inst_30383);
} else {
if((state_val_30583 === (27))){
var inst_30302 = (state_30582[(51)]);
var state_30582__$1 = state_30582;
var statearr_30602_30794 = state_30582__$1;
(statearr_30602_30794[(2)] = inst_30302);

(statearr_30602_30794[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (1))){
var state_30582__$1 = state_30582;
var statearr_30603_30795 = state_30582__$1;
(statearr_30603_30795[(2)] = null);

(statearr_30603_30795[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (69))){
var inst_30399 = (state_30582[(13)]);
var inst_30359 = (state_30582[(26)]);
var inst_30360 = (state_30582[(45)]);
var inst_30408 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_30399);
var inst_30409 = fluree.db.flake.subrange(inst_30408,start_test,inst_30359,end_test,inst_30360);
var inst_30411 = fluree.db.query.range.value_with_nil_pred(idx,inst_30359,inst_30360);
var state_30582__$1 = (function (){var statearr_30604 = state_30582;
(statearr_30604[(10)] = inst_30409);

return statearr_30604;
})();
if(inst_30411){
var statearr_30605_30796 = state_30582__$1;
(statearr_30605_30796[(1)] = (71));

} else {
var statearr_30606_30797 = state_30582__$1;
(statearr_30606_30797[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (101))){
var inst_30497 = (state_30582[(52)]);
var inst_30495 = (state_30582[(53)]);
var inst_30496 = (state_30582[(54)]);
var inst_30363 = (state_30582[(41)]);
var inst_30500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30501 = (inst_30497 - inst_30363);
var inst_30502 = (inst_30496 - inst_30501);
var inst_30503 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_30502,inst_30495);
var inst_30504 = [inst_30363,inst_30503];
var inst_30505 = (new cljs.core.PersistentVector(null,2,(5),inst_30500,inst_30504,null));
var state_30582__$1 = state_30582;
var statearr_30607_30798 = state_30582__$1;
(statearr_30607_30798[(2)] = inst_30505);

(statearr_30607_30798[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (24))){
var inst_30235 = (state_30582[(55)]);
var inst_30245 = (state_30582[(56)]);
var inst_30242 = (state_30582[(57)]);
var inst_30243 = (state_30582[(11)]);
var inst_30238 = (state_30582[(58)]);
var inst_30250 = (state_30582[(59)]);
var inst_30236 = (state_30582[(14)]);
var inst_30249 = (state_30582[(18)]);
var inst_30232 = (state_30582[(23)]);
var inst_30259 = (state_30582[(25)]);
var inst_30268 = (state_30582[(28)]);
var inst_30247 = (state_30582[(29)]);
var inst_30239 = (state_30582[(30)]);
var inst_30244 = (state_30582[(32)]);
var inst_30282 = (state_30582[(60)]);
var inst_30234 = (state_30582[(61)]);
var inst_30248 = (state_30582[(37)]);
var inst_30241 = (state_30582[(62)]);
var inst_30237 = (state_30582[(42)]);
var inst_30292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30294 = [null,null];
var inst_30295 = (new cljs.core.PersistentVector(null,2,(5),inst_30293,inst_30294,null));
var inst_30296 = (function (){var bool = inst_30282;
var s1 = inst_30259;
var o2 = inst_30242;
var t1 = inst_30236;
var predicate_fn = inst_30249;
var m1 = inst_30238;
var s2 = inst_30268;
var p2 = inst_30241;
var t2 = inst_30243;
var vec__30221 = inst_30239;
var op1 = inst_30237;
var o1 = inst_30235;
var p1 = inst_30234;
var subject_fn = inst_30248;
var vec__30218 = inst_30232;
var object_fn = inst_30250;
var map__30224 = inst_30247;
var op2 = inst_30244;
var m2 = inst_30245;
var temp__5755__auto__ = inst_30282;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_30297 = [inst_30295,inst_30296];
var inst_30298 = (new cljs.core.PersistentVector(null,2,(5),inst_30292,inst_30297,null));
var state_30582__$1 = state_30582;
var statearr_30608_30799 = state_30582__$1;
(statearr_30608_30799[(2)] = inst_30298);

(statearr_30608_30799[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (102))){
var inst_30497 = (state_30582[(52)]);
var inst_30495 = (state_30582[(53)]);
var inst_30507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30508 = [inst_30497,inst_30495];
var inst_30509 = (new cljs.core.PersistentVector(null,2,(5),inst_30507,inst_30508,null));
var state_30582__$1 = state_30582;
var statearr_30609_30800 = state_30582__$1;
(statearr_30609_30800[(2)] = inst_30509);

(statearr_30609_30800[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (55))){
var state_30582__$1 = state_30582;
var statearr_30610_30801 = state_30582__$1;
(statearr_30610_30801[(2)] = (2147483647));

(statearr_30610_30801[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (85))){
var inst_30445 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
if(cljs.core.truth_(inst_30445)){
var statearr_30611_30802 = state_30582__$1;
(statearr_30611_30802[(1)] = (89));

} else {
var statearr_30612_30803 = state_30582__$1;
(statearr_30612_30803[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (39))){
var inst_30241 = (state_30582[(62)]);
var inst_30332 = (state_30582[(63)]);
var inst_30331 = (state_30582[(2)]);
var inst_30332__$1 = (inst_30241 == null);
var state_30582__$1 = (function (){var statearr_30613 = state_30582;
(statearr_30613[(63)] = inst_30332__$1);

(statearr_30613[(47)] = inst_30331);

return statearr_30613;
})();
if(cljs.core.truth_(inst_30332__$1)){
var statearr_30614_30804 = state_30582__$1;
(statearr_30614_30804[(1)] = (40));

} else {
var statearr_30615_30805 = state_30582__$1;
(statearr_30615_30805[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (88))){
var inst_30442 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
var statearr_30616_30806 = state_30582__$1;
(statearr_30616_30806[(2)] = inst_30442);

(statearr_30616_30806[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (46))){
var inst_30238 = (state_30582[(58)]);
var state_30582__$1 = state_30582;
var statearr_30617_30807 = state_30582__$1;
(statearr_30617_30807[(2)] = inst_30238);

(statearr_30617_30807[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (4))){
var inst_30212 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
var statearr_30618_30808 = state_30582__$1;
(statearr_30618_30808[(2)] = inst_30212);

(statearr_30618_30808[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (77))){
var inst_30409 = (state_30582[(10)]);
var inst_30243 = (state_30582[(11)]);
var inst_30301 = (state_30582[(12)]);
var inst_30399 = (state_30582[(13)]);
var inst_30423 = (state_30582[(64)]);
var inst_30236 = (state_30582[(14)]);
var inst_30362 = (state_30582[(15)]);
var inst_30403 = (state_30582[(16)]);
var inst_30300 = (state_30582[(17)]);
var inst_30249 = (state_30582[(18)]);
var inst_30380 = (state_30582[(19)]);
var inst_30322 = (state_30582[(20)]);
var inst_30400 = (state_30582[(21)]);
var inst_30370 = (state_30582[(22)]);
var inst_30232 = (state_30582[(23)]);
var inst_30390 = (state_30582[(8)]);
var inst_30381 = (state_30582[(24)]);
var inst_30259 = (state_30582[(25)]);
var inst_30359 = (state_30582[(26)]);
var inst_30376 = (state_30582[(27)]);
var inst_30268 = (state_30582[(28)]);
var inst_30247 = (state_30582[(29)]);
var inst_30239 = (state_30582[(30)]);
var inst_30375 = (state_30582[(31)]);
var inst_30244 = (state_30582[(32)]);
var inst_30369 = (state_30582[(33)]);
var inst_30304 = (state_30582[(34)]);
var inst_30396 = (state_30582[(9)]);
var inst_30313 = (state_30582[(35)]);
var inst_30401 = (state_30582[(36)]);
var inst_30248 = (state_30582[(37)]);
var inst_30386 = (state_30582[(38)]);
var inst_30358 = (state_30582[(39)]);
var inst_30340 = (state_30582[(40)]);
var inst_30363 = (state_30582[(41)]);
var inst_30237 = (state_30582[(42)]);
var inst_30402 = (state_30582[(43)]);
var inst_30371 = (state_30582[(44)]);
var inst_30360 = (state_30582[(45)]);
var inst_30349 = (state_30582[(46)]);
var inst_30331 = (state_30582[(47)]);
var inst_30425 = (function (){var no_filter_QMARK_ = inst_30396;
var t = inst_30376;
var max_limit_QMARK_ = inst_30370;
var next_node = inst_30399;
var fast_forward_db_QMARK_ = inst_30381;
var s1 = inst_30259;
var o2 = inst_30322;
var t1 = inst_30236;
var vec__30225 = inst_30300;
var predicate_fn = inst_30249;
var i = inst_30401;
var m1 = inst_30349;
var root_node = inst_30386;
var s2 = inst_30268;
var p2 = inst_30340;
var permissions = inst_30371;
var limit = inst_30369;
var start_flake = inst_30359;
var flake_limit = inst_30363;
var offset = inst_30400;
var acc = inst_30403;
var vec__30228 = inst_30301;
var t2 = inst_30243;
var vec__30221 = inst_30239;
var op1 = inst_30237;
var o1 = inst_30313;
var end_flake = inst_30360;
var base_result = inst_30409;
var s = inst_30402;
var node_start = inst_30390;
var p1 = inst_30331;
var subject_fn = inst_30248;
var vec__30218 = inst_30232;
var object_fn = inst_30304;
var idx_compare = inst_30375;
var map__30224 = inst_30247;
var G__30410 = inst_30423;
var map__30231 = inst_30362;
var op2 = inst_30244;
var m2 = inst_30358;
var novelty = inst_30380;
return (function (p1__30201_SHARP_){
var G__30619 = p1__30201_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__30619) : predicate_fn.call(null,G__30619));
});
})();
var inst_30426 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_30425,inst_30423);
var state_30582__$1 = state_30582;
var statearr_30620_30809 = state_30582__$1;
(statearr_30620_30809[(2)] = inst_30426);

(statearr_30620_30809[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (106))){
var inst_30436 = (state_30582[(65)]);
var state_30582__$1 = state_30582;
var statearr_30621_30810 = state_30582__$1;
(statearr_30621_30810[(2)] = inst_30436);

(statearr_30621_30810[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (119))){
var inst_30554 = (state_30582[(66)]);
var state_30582__$1 = state_30582;
var statearr_30622_30811 = state_30582__$1;
(statearr_30622_30811[(2)] = inst_30554);

(statearr_30622_30811[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (95))){
var inst_30479 = (state_30582[(67)]);
var inst_30478 = (state_30582[(68)]);
var inst_30477 = (state_30582[(69)]);
var inst_30369 = (state_30582[(33)]);
var inst_30402 = (state_30582[(43)]);
var inst_30469 = (state_30582[(70)]);
var inst_30477__$1 = cljs.core.count(inst_30469);
var inst_30478__$1 = (inst_30402 + inst_30477__$1);
var inst_30479__$1 = (inst_30478__$1 - inst_30369);
var inst_30480 = cljs.core.pos_int_QMARK_(inst_30479__$1);
var state_30582__$1 = (function (){var statearr_30623 = state_30582;
(statearr_30623[(67)] = inst_30479__$1);

(statearr_30623[(68)] = inst_30478__$1);

(statearr_30623[(69)] = inst_30477__$1);

return statearr_30623;
})();
if(inst_30480){
var statearr_30624_30812 = state_30582__$1;
(statearr_30624_30812[(1)] = (98));

} else {
var statearr_30625_30813 = state_30582__$1;
(statearr_30625_30813[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (54))){
var inst_30243 = (state_30582[(11)]);
var inst_30236 = (state_30582[(14)]);
var inst_30362 = (state_30582[(15)]);
var inst_30322 = (state_30582[(20)]);
var inst_30259 = (state_30582[(25)]);
var inst_30268 = (state_30582[(28)]);
var inst_30244 = (state_30582[(32)]);
var inst_30313 = (state_30582[(35)]);
var inst_30358 = (state_30582[(39)]);
var inst_30340 = (state_30582[(40)]);
var inst_30364 = (state_30582[(50)]);
var inst_30237 = (state_30582[(42)]);
var inst_30349 = (state_30582[(46)]);
var inst_30331 = (state_30582[(47)]);
var inst_30358__$1 = (state_30582[(2)]);
var inst_30359 = fluree.db.flake.__GT_Flake(inst_30259,inst_30331,inst_30313,inst_30236,inst_30237,inst_30349);
var inst_30360 = fluree.db.flake.__GT_Flake(inst_30268,inst_30340,inst_30322,inst_30243,inst_30244,inst_30358__$1);
var inst_30361 = opts;
var inst_30362__$1 = cljs.core.__destructure_map(inst_30361);
var inst_30363 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_30362__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_30364__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30362__$1,cljs.core.cst$kw$limit);
var inst_30365 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_30362__$1,cljs.core.cst$kw$offset,(0));
var state_30582__$1 = (function (){var statearr_30626 = state_30582;
(statearr_30626[(15)] = inst_30362__$1);

(statearr_30626[(26)] = inst_30359);

(statearr_30626[(71)] = inst_30365);

(statearr_30626[(39)] = inst_30358__$1);

(statearr_30626[(41)] = inst_30363);

(statearr_30626[(50)] = inst_30364__$1);

(statearr_30626[(45)] = inst_30360);

return statearr_30626;
})();
if(cljs.core.truth_(inst_30364__$1)){
var statearr_30627_30814 = state_30582__$1;
(statearr_30627_30814[(1)] = (58));

} else {
var statearr_30628_30815 = state_30582__$1;
(statearr_30628_30815[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (92))){
var inst_30458 = (state_30582[(72)]);
var inst_30403 = (state_30582[(16)]);
var inst_30400 = (state_30582[(21)]);
var inst_30401 = (state_30582[(36)]);
var inst_30402 = (state_30582[(43)]);
var inst_30461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30462 = (inst_30400 - inst_30458);
var inst_30463 = [inst_30462,inst_30401,inst_30402,inst_30403];
var inst_30464 = (new cljs.core.PersistentVector(null,4,(5),inst_30461,inst_30463,null));
var state_30582__$1 = state_30582;
var statearr_30629_30816 = state_30582__$1;
(statearr_30629_30816[(2)] = inst_30464);

(statearr_30629_30816[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (104))){
var inst_30520 = (state_30582[(2)]);
var inst_30521 = fluree.db.util.async.throw_err(inst_30520);
var state_30582__$1 = state_30582;
var statearr_30630_30817 = state_30582__$1;
(statearr_30630_30817[(2)] = inst_30521);

(statearr_30630_30817[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (15))){
var inst_30242 = (state_30582[(57)]);
var inst_30272 = cljs.core.boolean_QMARK_(inst_30242);
var state_30582__$1 = state_30582;
if(inst_30272){
var statearr_30631_30818 = state_30582__$1;
(statearr_30631_30818[(1)] = (17));

} else {
var statearr_30632_30819 = state_30582__$1;
(statearr_30632_30819[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (48))){
var inst_30245 = (state_30582[(56)]);
var inst_30349 = (state_30582[(2)]);
var state_30582__$1 = (function (){var statearr_30633 = state_30582;
(statearr_30633[(46)] = inst_30349);

return statearr_30633;
})();
if(cljs.core.truth_(inst_30245)){
var statearr_30634_30820 = state_30582__$1;
(statearr_30634_30820[(1)] = (52));

} else {
var statearr_30635_30821 = state_30582__$1;
(statearr_30635_30821[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (50))){
var state_30582__$1 = state_30582;
var statearr_30636_30822 = state_30582__$1;
(statearr_30636_30822[(2)] = (2147483647));

(statearr_30636_30822[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (116))){
var inst_30554 = (state_30582[(66)]);
var inst_30562 = (state_30582[(2)]);
var state_30582__$1 = (function (){var statearr_30637 = state_30582;
(statearr_30637[(73)] = inst_30562);

return statearr_30637;
})();
if(cljs.core.truth_(inst_30554)){
var statearr_30638_30823 = state_30582__$1;
(statearr_30638_30823[(1)] = (118));

} else {
var statearr_30639_30824 = state_30582__$1;
(statearr_30639_30824[(1)] = (119));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (75))){
var inst_30417 = (state_30582[(48)]);
var state_30582__$1 = state_30582;
var statearr_30640_30825 = state_30582__$1;
(statearr_30640_30825[(2)] = inst_30417);

(statearr_30640_30825[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (99))){
var inst_30478 = (state_30582[(68)]);
var inst_30487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30488 = [inst_30478,inst_30478];
var inst_30489 = (new cljs.core.PersistentVector(null,2,(5),inst_30487,inst_30488,null));
var state_30582__$1 = state_30582;
var statearr_30641_30826 = state_30582__$1;
(statearr_30641_30826[(2)] = inst_30489);

(statearr_30641_30826[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (21))){
var state_30582__$1 = state_30582;
var statearr_30642_30827 = state_30582__$1;
(statearr_30642_30827[(2)] = null);

(statearr_30642_30827[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (31))){
var inst_30303 = (state_30582[(74)]);
var state_30582__$1 = state_30582;
var statearr_30643_30828 = state_30582__$1;
(statearr_30643_30828[(2)] = inst_30303);

(statearr_30643_30828[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (113))){
var inst_30548 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
var statearr_30644_30829 = state_30582__$1;
(statearr_30644_30829[(2)] = inst_30548);

(statearr_30644_30829[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (32))){
var inst_30323 = (state_30582[(75)]);
var inst_30234 = (state_30582[(61)]);
var inst_30322 = (state_30582[(2)]);
var inst_30323__$1 = (inst_30234 == null);
var state_30582__$1 = (function (){var statearr_30645 = state_30582;
(statearr_30645[(75)] = inst_30323__$1);

(statearr_30645[(20)] = inst_30322);

return statearr_30645;
})();
if(cljs.core.truth_(inst_30323__$1)){
var statearr_30646_30830 = state_30582__$1;
(statearr_30646_30830[(1)] = (34));

} else {
var statearr_30647_30831 = state_30582__$1;
(statearr_30647_30831[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (40))){
var inst_30322 = (state_30582[(20)]);
var state_30582__$1 = state_30582;
var statearr_30648_30832 = state_30582__$1;
(statearr_30648_30832[(2)] = inst_30322);

(statearr_30648_30832[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (91))){
var inst_30436 = (state_30582[(65)]);
var inst_30534 = (state_30582[(2)]);
var inst_30535 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30534,(0),null);
var inst_30536 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30534,(1),null);
var inst_30537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30534,(2),null);
var inst_30538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30534,(3),null);
var state_30582__$1 = (function (){var statearr_30649 = state_30582;
(statearr_30649[(76)] = inst_30535);

(statearr_30649[(77)] = inst_30537);

(statearr_30649[(78)] = inst_30536);

(statearr_30649[(7)] = inst_30538);

return statearr_30649;
})();
if(cljs.core.truth_(inst_30436)){
var statearr_30650_30833 = state_30582__$1;
(statearr_30650_30833[(1)] = (105));

} else {
var statearr_30651_30834 = state_30582__$1;
(statearr_30651_30834[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (117))){
var inst_30558 = (state_30582[(2)]);
var inst_30559 = fluree.db.util.async.throw_err(inst_30558);
var state_30582__$1 = state_30582;
var statearr_30652_30835 = state_30582__$1;
(statearr_30652_30835[(2)] = inst_30559);

(statearr_30652_30835[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (108))){
var inst_30536 = (state_30582[(78)]);
var inst_30363 = (state_30582[(41)]);
var inst_30543 = (state_30582[(79)]);
var inst_30543__$1 = (inst_30536 < inst_30363);
var state_30582__$1 = (function (){var statearr_30653 = state_30582;
(statearr_30653[(79)] = inst_30543__$1);

return statearr_30653;
})();
if(cljs.core.truth_(inst_30543__$1)){
var statearr_30654_30836 = state_30582__$1;
(statearr_30654_30836[(1)] = (111));

} else {
var statearr_30655_30837 = state_30582__$1;
(statearr_30655_30837[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (56))){
var state_30582__$1 = state_30582;
var statearr_30656_30838 = state_30582__$1;
(statearr_30656_30838[(2)] = fluree.db.util.core.min_integer);

(statearr_30656_30838[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (33))){
var inst_30318 = (state_30582[(2)]);
var inst_30319 = fluree.db.util.async.throw_err(inst_30318);
var state_30582__$1 = state_30582;
var statearr_30657_30839 = state_30582__$1;
(statearr_30657_30839[(2)] = inst_30319);

(statearr_30657_30839[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (13))){
var inst_30264 = (state_30582[(2)]);
var inst_30265 = fluree.db.util.async.throw_err(inst_30264);
var state_30582__$1 = state_30582;
var statearr_30658_30840 = state_30582__$1;
(statearr_30658_30840[(2)] = inst_30265);

(statearr_30658_30840[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (22))){
var inst_30278 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
var statearr_30659_30841 = state_30582__$1;
(statearr_30659_30841[(2)] = inst_30278);

(statearr_30659_30841[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (90))){
var inst_30458 = (state_30582[(72)]);
var inst_30409 = (state_30582[(10)]);
var inst_30243 = (state_30582[(11)]);
var inst_30301 = (state_30582[(12)]);
var inst_30399 = (state_30582[(13)]);
var inst_30236 = (state_30582[(14)]);
var inst_30435 = (state_30582[(80)]);
var inst_30362 = (state_30582[(15)]);
var inst_30403 = (state_30582[(16)]);
var inst_30300 = (state_30582[(17)]);
var inst_30249 = (state_30582[(18)]);
var inst_30380 = (state_30582[(19)]);
var inst_30436 = (state_30582[(65)]);
var inst_30322 = (state_30582[(20)]);
var inst_30400 = (state_30582[(21)]);
var inst_30370 = (state_30582[(22)]);
var inst_30232 = (state_30582[(23)]);
var inst_30390 = (state_30582[(8)]);
var inst_30381 = (state_30582[(24)]);
var inst_30259 = (state_30582[(25)]);
var inst_30359 = (state_30582[(26)]);
var inst_30376 = (state_30582[(27)]);
var inst_30268 = (state_30582[(28)]);
var inst_30247 = (state_30582[(29)]);
var inst_30239 = (state_30582[(30)]);
var inst_30375 = (state_30582[(31)]);
var inst_30244 = (state_30582[(32)]);
var inst_30369 = (state_30582[(33)]);
var inst_30304 = (state_30582[(34)]);
var inst_30396 = (state_30582[(9)]);
var inst_30313 = (state_30582[(35)]);
var inst_30401 = (state_30582[(36)]);
var inst_30248 = (state_30582[(37)]);
var inst_30386 = (state_30582[(38)]);
var inst_30358 = (state_30582[(39)]);
var inst_30340 = (state_30582[(40)]);
var inst_30363 = (state_30582[(41)]);
var inst_30237 = (state_30582[(42)]);
var inst_30402 = (state_30582[(43)]);
var inst_30371 = (state_30582[(44)]);
var inst_30360 = (state_30582[(45)]);
var inst_30349 = (state_30582[(46)]);
var inst_30331 = (state_30582[(47)]);
var inst_30457 = (state_30582[(81)]);
var inst_30456 = (function (){var no_filter_QMARK_ = inst_30396;
var base_result_SINGLEQUOTE_ = inst_30435;
var t = inst_30376;
var max_limit_QMARK_ = inst_30370;
var next_node = inst_30399;
var fast_forward_db_QMARK_ = inst_30381;
var s1 = inst_30259;
var o2 = inst_30322;
var t1 = inst_30236;
var vec__30225 = inst_30300;
var predicate_fn = inst_30249;
var i = inst_30401;
var rhs = inst_30436;
var m1 = inst_30349;
var root_node = inst_30386;
var s2 = inst_30268;
var p2 = inst_30340;
var permissions = inst_30371;
var limit = inst_30369;
var start_flake = inst_30359;
var flake_limit = inst_30363;
var offset = inst_30400;
var acc = inst_30403;
var vec__30228 = inst_30301;
var t2 = inst_30243;
var vec__30221 = inst_30239;
var op1 = inst_30237;
var o1 = inst_30313;
var end_flake = inst_30360;
var base_result = inst_30409;
var s = inst_30402;
var node_start = inst_30390;
var p1 = inst_30331;
var subject_fn = inst_30248;
var vec__30218 = inst_30232;
var object_fn = inst_30304;
var idx_compare = inst_30375;
var map__30224 = inst_30247;
var map__30231 = inst_30362;
var op2 = inst_30244;
var m2 = inst_30358;
var novelty = inst_30380;
return (function (p1__30203_SHARP_){
return p1__30203_SHARP_.s;
});
})();
var inst_30457__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_30456,inst_30435);
var inst_30458__$1 = cljs.core.count(inst_30457__$1);
var inst_30459 = (inst_30400 > inst_30458__$1);
var state_30582__$1 = (function (){var statearr_30660 = state_30582;
(statearr_30660[(72)] = inst_30458__$1);

(statearr_30660[(81)] = inst_30457__$1);

return statearr_30660;
})();
if(cljs.core.truth_(inst_30459)){
var statearr_30661_30842 = state_30582__$1;
(statearr_30661_30842[(1)] = (92));

} else {
var statearr_30662_30843 = state_30582__$1;
(statearr_30662_30843[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (109))){
var inst_30541 = (state_30582[(82)]);
var state_30582__$1 = state_30582;
var statearr_30663_30844 = state_30582__$1;
(statearr_30663_30844[(2)] = inst_30541);

(statearr_30663_30844[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (36))){
var inst_30327 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
if(cljs.core.truth_(inst_30327)){
var statearr_30664_30845 = state_30582__$1;
(statearr_30664_30845[(1)] = (37));

} else {
var statearr_30665_30846 = state_30582__$1;
(statearr_30665_30846[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (41))){
var inst_30332 = (state_30582[(63)]);
var state_30582__$1 = state_30582;
var statearr_30666_30847 = state_30582__$1;
(statearr_30666_30847[(2)] = inst_30332);

(statearr_30666_30847[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (118))){
var inst_30562 = (state_30582[(73)]);
var state_30582__$1 = state_30582;
var statearr_30667_30848 = state_30582__$1;
(statearr_30667_30848[(2)] = inst_30562);

(statearr_30667_30848[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (89))){
var inst_30435 = (state_30582[(80)]);
var inst_30403 = (state_30582[(16)]);
var inst_30401 = (state_30582[(36)]);
var inst_30363 = (state_30582[(41)]);
var inst_30402 = (state_30582[(43)]);
var inst_30447 = cljs.core.count(inst_30435);
var inst_30448 = (inst_30363 - inst_30401);
var inst_30449 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_30448,inst_30435);
var inst_30450 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30403,inst_30449);
var inst_30451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30452 = (inst_30401 + inst_30447);
var inst_30453 = [(0),inst_30452,inst_30402,inst_30450];
var inst_30454 = (new cljs.core.PersistentVector(null,4,(5),inst_30451,inst_30453,null));
var state_30582__$1 = state_30582;
var statearr_30668_30849 = state_30582__$1;
(statearr_30668_30849[(2)] = inst_30454);

(statearr_30668_30849[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (100))){
var inst_30497 = (state_30582[(52)]);
var inst_30495 = (state_30582[(53)]);
var inst_30496 = (state_30582[(54)]);
var inst_30401 = (state_30582[(36)]);
var inst_30363 = (state_30582[(41)]);
var inst_30469 = (state_30582[(70)]);
var inst_30491 = (state_30582[(2)]);
var inst_30492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30491,(0),null);
var inst_30493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30491,(1),null);
var inst_30494 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_30493,inst_30469);
var inst_30495__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_30494);
var inst_30496__$1 = cljs.core.count(inst_30495__$1);
var inst_30497__$1 = (inst_30401 + inst_30496__$1);
var inst_30498 = (inst_30497__$1 > inst_30363);
var state_30582__$1 = (function (){var statearr_30669 = state_30582;
(statearr_30669[(52)] = inst_30497__$1);

(statearr_30669[(83)] = inst_30492);

(statearr_30669[(53)] = inst_30495__$1);

(statearr_30669[(54)] = inst_30496__$1);

return statearr_30669;
})();
if(cljs.core.truth_(inst_30498)){
var statearr_30670_30850 = state_30582__$1;
(statearr_30670_30850[(1)] = (101));

} else {
var statearr_30671_30851 = state_30582__$1;
(statearr_30671_30851[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (122))){
var inst_30535 = (state_30582[(76)]);
var inst_30537 = (state_30582[(77)]);
var inst_30562 = (state_30582[(73)]);
var inst_30536 = (state_30582[(78)]);
var inst_30538 = (state_30582[(7)]);
var inst_30399 = inst_30562;
var inst_30400 = inst_30535;
var inst_30401 = inst_30536;
var inst_30402 = inst_30537;
var inst_30403 = inst_30538;
var state_30582__$1 = (function (){var statearr_30672 = state_30582;
(statearr_30672[(13)] = inst_30399);

(statearr_30672[(16)] = inst_30403);

(statearr_30672[(21)] = inst_30400);

(statearr_30672[(36)] = inst_30401);

(statearr_30672[(43)] = inst_30402);

return statearr_30672;
})();
var statearr_30673_30852 = state_30582__$1;
(statearr_30673_30852[(2)] = null);

(statearr_30673_30852[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (43))){
var state_30582__$1 = state_30582;
var statearr_30674_30853 = state_30582__$1;
(statearr_30674_30853[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_30674_30853[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (61))){
var inst_30380 = (state_30582[(19)]);
var inst_30381 = (state_30582[(24)]);
var inst_30359 = (state_30582[(26)]);
var inst_30376 = (state_30582[(27)]);
var inst_30386 = (state_30582[(38)]);
var inst_30385 = (state_30582[(2)]);
var inst_30386__$1 = fluree.db.util.async.throw_err(inst_30385);
var inst_30387 = fluree.db.query.range.find_next_valid_node(inst_30386__$1,inst_30359,inst_30376,inst_30380,inst_30381);
var state_30582__$1 = (function (){var statearr_30675 = state_30582;
(statearr_30675[(38)] = inst_30386__$1);

return statearr_30675;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30582__$1,(62),inst_30387);
} else {
if((state_val_30583 === (29))){
var inst_30309 = (state_30582[(2)]);
var inst_30310 = fluree.db.util.async.throw_err(inst_30309);
var state_30582__$1 = state_30582;
var statearr_30676_30854 = state_30582__$1;
(statearr_30676_30854[(2)] = inst_30310);

(statearr_30676_30854[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (44))){
var inst_30241 = (state_30582[(62)]);
var state_30582__$1 = state_30582;
var statearr_30677_30855 = state_30582__$1;
(statearr_30677_30855[(2)] = inst_30241);

(statearr_30677_30855[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (93))){
var inst_30400 = (state_30582[(21)]);
var inst_30396 = (state_30582[(9)]);
var inst_30457 = (state_30582[(81)]);
var inst_30469 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_30400,inst_30457);
var state_30582__$1 = (function (){var statearr_30678 = state_30582;
(statearr_30678[(70)] = inst_30469);

return statearr_30678;
})();
if(cljs.core.truth_(inst_30396)){
var statearr_30679_30856 = state_30582__$1;
(statearr_30679_30856[(1)] = (95));

} else {
var statearr_30680_30857 = state_30582__$1;
(statearr_30680_30857[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (6))){
var inst_30233 = (state_30582[(49)]);
var inst_30253 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30233);
var state_30582__$1 = state_30582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30582__$1,(9),inst_30253);
} else {
if((state_val_30583 === (111))){
var inst_30537 = (state_30582[(77)]);
var inst_30369 = (state_30582[(33)]);
var inst_30545 = (inst_30537 < inst_30369);
var state_30582__$1 = state_30582;
var statearr_30681_30858 = state_30582__$1;
(statearr_30681_30858[(2)] = inst_30545);

(statearr_30681_30858[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (28))){
var inst_30303 = (state_30582[(74)]);
var inst_30313 = (state_30582[(2)]);
var inst_30314 = fluree.db.util.core.pred_ident_QMARK_(inst_30303);
var state_30582__$1 = (function (){var statearr_30682 = state_30582;
(statearr_30682[(35)] = inst_30313);

return statearr_30682;
})();
if(inst_30314){
var statearr_30683_30859 = state_30582__$1;
(statearr_30683_30859[(1)] = (30));

} else {
var statearr_30684_30860 = state_30582__$1;
(statearr_30684_30860[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (64))){
var state_30582__$1 = state_30582;
var statearr_30685_30861 = state_30582__$1;
(statearr_30685_30861[(2)] = true);

(statearr_30685_30861[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (103))){
var inst_30492 = (state_30582[(83)]);
var inst_30511 = (state_30582[(2)]);
var inst_30512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30511,(0),null);
var inst_30513 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30511,(1),null);
var inst_30514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30515 = [inst_30512,inst_30492,inst_30513];
var inst_30516 = (new cljs.core.PersistentVector(null,3,(5),inst_30514,inst_30515,null));
var state_30582__$1 = state_30582;
var statearr_30686_30862 = state_30582__$1;
(statearr_30686_30862[(2)] = inst_30516);

(statearr_30686_30862[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (51))){
var inst_30347 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
var statearr_30687_30863 = state_30582__$1;
(statearr_30687_30863[(2)] = inst_30347);

(statearr_30687_30863[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (25))){
var inst_30301 = (state_30582[(12)]);
var inst_30300 = (state_30582[(17)]);
var inst_30302 = (state_30582[(51)]);
var inst_30300__$1 = (state_30582[(2)]);
var inst_30301__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30300__$1,(0),null);
var inst_30302__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30301__$1,(0),null);
var inst_30303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30301__$1,(1),null);
var inst_30304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30300__$1,(1),null);
var inst_30305 = fluree.db.util.core.pred_ident_QMARK_(inst_30302__$1);
var state_30582__$1 = (function (){var statearr_30688 = state_30582;
(statearr_30688[(12)] = inst_30301__$1);

(statearr_30688[(17)] = inst_30300__$1);

(statearr_30688[(74)] = inst_30303);

(statearr_30688[(34)] = inst_30304);

(statearr_30688[(51)] = inst_30302__$1);

return statearr_30688;
})();
if(inst_30305){
var statearr_30689_30864 = state_30582__$1;
(statearr_30689_30864[(1)] = (26));

} else {
var statearr_30690_30865 = state_30582__$1;
(statearr_30690_30865[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (34))){
var inst_30313 = (state_30582[(35)]);
var state_30582__$1 = state_30582;
var statearr_30691_30866 = state_30582__$1;
(statearr_30691_30866[(2)] = inst_30313);

(statearr_30691_30866[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (17))){
var inst_30242 = (state_30582[(57)]);
var state_30582__$1 = state_30582;
var statearr_30692_30867 = state_30582__$1;
(statearr_30692_30867[(2)] = inst_30242);

(statearr_30692_30867[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (3))){
var inst_30580 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30582__$1,inst_30580);
} else {
if((state_val_30583 === (12))){
var inst_30235 = (state_30582[(55)]);
var inst_30268 = (state_30582[(2)]);
var inst_30269 = cljs.core.boolean_QMARK_(inst_30235);
var state_30582__$1 = (function (){var statearr_30693 = state_30582;
(statearr_30693[(28)] = inst_30268);

return statearr_30693;
})();
if(inst_30269){
var statearr_30694_30868 = state_30582__$1;
(statearr_30694_30868[(1)] = (14));

} else {
var statearr_30695_30869 = state_30582__$1;
(statearr_30695_30869[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (2))){
var inst_30232 = (state_30582[(23)]);
var inst_30247 = (state_30582[(29)]);
var inst_30239 = (state_30582[(30)]);
var inst_30233 = (state_30582[(49)]);
var _ = (function (){var statearr_30696 = state_30582;
(statearr_30696[(4)] = cljs.core.cons((5),(state_30582[(4)])));

return statearr_30696;
})();
var inst_30232__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_30233__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30232__$1,(0),null);
var inst_30234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30232__$1,(1),null);
var inst_30235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30232__$1,(2),null);
var inst_30236 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30232__$1,(3),null);
var inst_30237 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30232__$1,(4),null);
var inst_30238 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30232__$1,(5),null);
var inst_30239__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_30240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30239__$1,(0),null);
var inst_30241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30239__$1,(1),null);
var inst_30242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30239__$1,(2),null);
var inst_30243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30239__$1,(3),null);
var inst_30244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30239__$1,(4),null);
var inst_30245 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30239__$1,(5),null);
var inst_30246 = opts;
var inst_30247__$1 = cljs.core.__destructure_map(inst_30246);
var inst_30248 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30247__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_30249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30247__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_30250 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30247__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_30251 = fluree.db.util.core.pred_ident_QMARK_(inst_30233__$1);
var state_30582__$1 = (function (){var statearr_30697 = state_30582;
(statearr_30697[(55)] = inst_30235);

(statearr_30697[(56)] = inst_30245);

(statearr_30697[(57)] = inst_30242);

(statearr_30697[(11)] = inst_30243);

(statearr_30697[(58)] = inst_30238);

(statearr_30697[(84)] = inst_30240);

(statearr_30697[(59)] = inst_30250);

(statearr_30697[(14)] = inst_30236);

(statearr_30697[(18)] = inst_30249);

(statearr_30697[(23)] = inst_30232__$1);

(statearr_30697[(29)] = inst_30247__$1);

(statearr_30697[(30)] = inst_30239__$1);

(statearr_30697[(32)] = inst_30244);

(statearr_30697[(61)] = inst_30234);

(statearr_30697[(37)] = inst_30248);

(statearr_30697[(62)] = inst_30241);

(statearr_30697[(42)] = inst_30237);

(statearr_30697[(49)] = inst_30233__$1);

return statearr_30697;
})();
if(inst_30251){
var statearr_30698_30870 = state_30582__$1;
(statearr_30698_30870[(1)] = (6));

} else {
var statearr_30699_30871 = state_30582__$1;
(statearr_30699_30871[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (66))){
var inst_30390 = (state_30582[(8)]);
var inst_30365 = (state_30582[(71)]);
var inst_30398 = cljs.core.PersistentVector.EMPTY;
var inst_30399 = inst_30390;
var inst_30400 = inst_30365;
var inst_30401 = (0);
var inst_30402 = (0);
var inst_30403 = inst_30398;
var state_30582__$1 = (function (){var statearr_30700 = state_30582;
(statearr_30700[(13)] = inst_30399);

(statearr_30700[(16)] = inst_30403);

(statearr_30700[(21)] = inst_30400);

(statearr_30700[(36)] = inst_30401);

(statearr_30700[(43)] = inst_30402);

return statearr_30700;
})();
var statearr_30701_30872 = state_30582__$1;
(statearr_30701_30872[(2)] = null);

(statearr_30701_30872[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (107))){
var inst_30554 = (state_30582[(66)]);
var inst_30554__$1 = (state_30582[(2)]);
var state_30582__$1 = (function (){var statearr_30702 = state_30582;
(statearr_30702[(66)] = inst_30554__$1);

return statearr_30702;
})();
if(cljs.core.truth_(inst_30554__$1)){
var statearr_30703_30873 = state_30582__$1;
(statearr_30703_30873[(1)] = (114));

} else {
var statearr_30704_30874 = state_30582__$1;
(statearr_30704_30874[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (23))){
var inst_30235 = (state_30582[(55)]);
var inst_30242 = (state_30582[(57)]);
var inst_30250 = (state_30582[(59)]);
var inst_30285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30287 = [inst_30235,inst_30242];
var inst_30288 = (new cljs.core.PersistentVector(null,2,(5),inst_30286,inst_30287,null));
var inst_30289 = [inst_30288,inst_30250];
var inst_30290 = (new cljs.core.PersistentVector(null,2,(5),inst_30285,inst_30289,null));
var state_30582__$1 = state_30582;
var statearr_30705_30875 = state_30582__$1;
(statearr_30705_30875[(2)] = inst_30290);

(statearr_30705_30875[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (47))){
var inst_30343 = (cljs.core._GT__EQ_ === start_test);
var state_30582__$1 = state_30582;
if(cljs.core.truth_(inst_30343)){
var statearr_30706_30876 = state_30582__$1;
(statearr_30706_30876[(1)] = (49));

} else {
var statearr_30707_30877 = state_30582__$1;
(statearr_30707_30877[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (35))){
var inst_30323 = (state_30582[(75)]);
var state_30582__$1 = state_30582;
var statearr_30708_30878 = state_30582__$1;
(statearr_30708_30878[(2)] = inst_30323);

(statearr_30708_30878[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (82))){
var inst_30399 = (state_30582[(13)]);
var inst_30370 = (state_30582[(22)]);
var inst_30435 = (state_30582[(2)]);
var inst_30436 = fluree.db.dbproto._rhs(inst_30399);
var state_30582__$1 = (function (){var statearr_30709 = state_30582;
(statearr_30709[(80)] = inst_30435);

(statearr_30709[(65)] = inst_30436);

return statearr_30709;
})();
if(cljs.core.truth_(inst_30370)){
var statearr_30710_30879 = state_30582__$1;
(statearr_30710_30879[(1)] = (83));

} else {
var statearr_30711_30880 = state_30582__$1;
(statearr_30711_30880[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (76))){
var inst_30249 = (state_30582[(18)]);
var inst_30423 = (state_30582[(2)]);
var state_30582__$1 = (function (){var statearr_30712 = state_30582;
(statearr_30712[(64)] = inst_30423);

return statearr_30712;
})();
if(cljs.core.truth_(inst_30249)){
var statearr_30713_30881 = state_30582__$1;
(statearr_30713_30881[(1)] = (77));

} else {
var statearr_30714_30882 = state_30582__$1;
(statearr_30714_30882[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (97))){
var inst_30403 = (state_30582[(16)]);
var inst_30523 = (state_30582[(2)]);
var inst_30524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30523,(0),null);
var inst_30525 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30523,(1),null);
var inst_30526 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30523,(2),null);
var inst_30527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30528 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30403,inst_30526);
var inst_30529 = [(0),inst_30524,inst_30525,inst_30528];
var inst_30530 = (new cljs.core.PersistentVector(null,4,(5),inst_30527,inst_30529,null));
var state_30582__$1 = state_30582;
var statearr_30715_30883 = state_30582__$1;
(statearr_30715_30883[(2)] = inst_30530);

(statearr_30715_30883[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (19))){
var inst_30280 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
var statearr_30716_30884 = state_30582__$1;
(statearr_30716_30884[(2)] = inst_30280);

(statearr_30716_30884[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (57))){
var inst_30356 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
var statearr_30717_30885 = state_30582__$1;
(statearr_30717_30885[(2)] = inst_30356);

(statearr_30717_30885[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (68))){
var inst_30577 = (state_30582[(2)]);
var _ = (function (){var statearr_30718 = state_30582;
(statearr_30718[(4)] = cljs.core.rest((state_30582[(4)])));

return statearr_30718;
})();
var state_30582__$1 = state_30582;
var statearr_30719_30886 = state_30582__$1;
(statearr_30719_30886[(2)] = inst_30577);

(statearr_30719_30886[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (11))){
var inst_30240 = (state_30582[(84)]);
var state_30582__$1 = state_30582;
var statearr_30720_30887 = state_30582__$1;
(statearr_30720_30887[(2)] = inst_30240);

(statearr_30720_30887[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (115))){
var state_30582__$1 = state_30582;
var statearr_30722_30888 = state_30582__$1;
(statearr_30722_30888[(2)] = null);

(statearr_30722_30888[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (9))){
var inst_30255 = (state_30582[(2)]);
var inst_30256 = fluree.db.util.async.throw_err(inst_30255);
var state_30582__$1 = state_30582;
var statearr_30723_30889 = state_30582__$1;
(statearr_30723_30889[(2)] = inst_30256);

(statearr_30723_30889[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (5))){
var _ = (function (){var statearr_30724 = state_30582;
(statearr_30724[(4)] = cljs.core.rest((state_30582[(4)])));

return statearr_30724;
})();
var state_30582__$1 = state_30582;
var ex30721 = (state_30582__$1[(2)]);
var statearr_30725_30890 = state_30582__$1;
(statearr_30725_30890[(5)] = ex30721);


if((ex30721 instanceof Error)){
var statearr_30726_30891 = state_30582__$1;
(statearr_30726_30891[(1)] = (4));

(statearr_30726_30891[(5)] = null);

} else {
throw ex30721;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (112))){
var inst_30543 = (state_30582[(79)]);
var state_30582__$1 = state_30582;
var statearr_30727_30892 = state_30582__$1;
(statearr_30727_30892[(2)] = inst_30543);

(statearr_30727_30892[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (83))){
var inst_30400 = (state_30582[(21)]);
var inst_30438 = (state_30582[(85)]);
var inst_30438__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_30400);
var state_30582__$1 = (function (){var statearr_30728 = state_30582;
(statearr_30728[(85)] = inst_30438__$1);

return statearr_30728;
})();
if(inst_30438__$1){
var statearr_30729_30893 = state_30582__$1;
(statearr_30729_30893[(1)] = (86));

} else {
var statearr_30730_30894 = state_30582__$1;
(statearr_30730_30894[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (14))){
var inst_30235 = (state_30582[(55)]);
var state_30582__$1 = state_30582;
var statearr_30731_30895 = state_30582__$1;
(statearr_30731_30895[(2)] = inst_30235);

(statearr_30731_30895[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (45))){
var inst_30238 = (state_30582[(58)]);
var inst_30340 = (state_30582[(2)]);
var state_30582__$1 = (function (){var statearr_30732 = state_30582;
(statearr_30732[(40)] = inst_30340);

return statearr_30732;
})();
if(cljs.core.truth_(inst_30238)){
var statearr_30733_30896 = state_30582__$1;
(statearr_30733_30896[(1)] = (46));

} else {
var statearr_30734_30897 = state_30582__$1;
(statearr_30734_30897[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (53))){
var inst_30352 = (cljs.core._LT__EQ_ === end_test);
var state_30582__$1 = state_30582;
if(cljs.core.truth_(inst_30352)){
var statearr_30735_30898 = state_30582__$1;
(statearr_30735_30898[(1)] = (55));

} else {
var statearr_30736_30899 = state_30582__$1;
(statearr_30736_30899[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (78))){
var inst_30423 = (state_30582[(64)]);
var state_30582__$1 = state_30582;
var statearr_30737_30900 = state_30582__$1;
(statearr_30737_30900[(2)] = inst_30423);

(statearr_30737_30900[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (26))){
var inst_30302 = (state_30582[(51)]);
var inst_30307 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30302);
var state_30582__$1 = state_30582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30582__$1,(29),inst_30307);
} else {
if((state_val_30583 === (123))){
var inst_30572 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
var statearr_30738_30901 = state_30582__$1;
(statearr_30738_30901[(2)] = inst_30572);

(statearr_30738_30901[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (16))){
var inst_30282 = (state_30582[(60)]);
var inst_30282__$1 = (state_30582[(2)]);
var inst_30283 = (inst_30282__$1 == null);
var state_30582__$1 = (function (){var statearr_30739 = state_30582;
(statearr_30739[(60)] = inst_30282__$1);

return statearr_30739;
})();
if(cljs.core.truth_(inst_30283)){
var statearr_30740_30902 = state_30582__$1;
(statearr_30740_30902[(1)] = (23));

} else {
var statearr_30741_30903 = state_30582__$1;
(statearr_30741_30903[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (81))){
var inst_30429 = (state_30582[(86)]);
var state_30582__$1 = state_30582;
var statearr_30742_30904 = state_30582__$1;
(statearr_30742_30904[(2)] = inst_30429);

(statearr_30742_30904[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (120))){
var inst_30566 = (state_30582[(2)]);
var inst_30567 = cljs.core.not(inst_30566);
var state_30582__$1 = state_30582;
if(inst_30567){
var statearr_30743_30905 = state_30582__$1;
(statearr_30743_30905[(1)] = (121));

} else {
var statearr_30744_30906 = state_30582__$1;
(statearr_30744_30906[(1)] = (122));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (79))){
var inst_30304 = (state_30582[(34)]);
var inst_30429 = (state_30582[(2)]);
var state_30582__$1 = (function (){var statearr_30745 = state_30582;
(statearr_30745[(86)] = inst_30429);

return statearr_30745;
})();
if(cljs.core.truth_(inst_30304)){
var statearr_30746_30907 = state_30582__$1;
(statearr_30746_30907[(1)] = (80));

} else {
var statearr_30747_30908 = state_30582__$1;
(statearr_30747_30908[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (38))){
var inst_30234 = (state_30582[(61)]);
var state_30582__$1 = state_30582;
var statearr_30748_30909 = state_30582__$1;
(statearr_30748_30909[(2)] = inst_30234);

(statearr_30748_30909[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (98))){
var inst_30479 = (state_30582[(67)]);
var inst_30477 = (state_30582[(69)]);
var inst_30369 = (state_30582[(33)]);
var inst_30482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30483 = (inst_30477 - inst_30479);
var inst_30484 = [inst_30369,inst_30483];
var inst_30485 = (new cljs.core.PersistentVector(null,2,(5),inst_30482,inst_30484,null));
var state_30582__$1 = state_30582;
var statearr_30749_30910 = state_30582__$1;
(statearr_30749_30910[(2)] = inst_30485);

(statearr_30749_30910[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (87))){
var inst_30438 = (state_30582[(85)]);
var state_30582__$1 = state_30582;
var statearr_30750_30911 = state_30582__$1;
(statearr_30750_30911[(2)] = inst_30438);

(statearr_30750_30911[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (30))){
var inst_30303 = (state_30582[(74)]);
var inst_30316 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30303);
var state_30582__$1 = state_30582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30582__$1,(33),inst_30316);
} else {
if((state_val_30583 === (73))){
var inst_30248 = (state_30582[(37)]);
var inst_30417 = (state_30582[(2)]);
var state_30582__$1 = (function (){var statearr_30751 = state_30582;
(statearr_30751[(48)] = inst_30417);

return statearr_30751;
})();
if(cljs.core.truth_(inst_30248)){
var statearr_30752_30912 = state_30582__$1;
(statearr_30752_30912[(1)] = (74));

} else {
var statearr_30753_30913 = state_30582__$1;
(statearr_30753_30913[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (96))){
var inst_30369 = (state_30582[(33)]);
var inst_30401 = (state_30582[(36)]);
var inst_30363 = (state_30582[(41)]);
var inst_30402 = (state_30582[(43)]);
var inst_30469 = (state_30582[(70)]);
var inst_30518 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_30469,inst_30401,inst_30402,inst_30363,inst_30369);
var state_30582__$1 = state_30582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30582__$1,(104),inst_30518);
} else {
if((state_val_30583 === (10))){
var inst_30240 = (state_30582[(84)]);
var inst_30262 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30240);
var state_30582__$1 = state_30582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30582__$1,(13),inst_30262);
} else {
if((state_val_30583 === (18))){
var state_30582__$1 = state_30582;
var statearr_30754_30914 = state_30582__$1;
(statearr_30754_30914[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (105))){
var inst_30436 = (state_30582[(65)]);
var inst_30375 = (state_30582[(31)]);
var inst_30360 = (state_30582[(45)]);
var inst_30541 = (state_30582[(82)]);
var inst_30540 = (inst_30375.cljs$core$IFn$_invoke$arity$2 ? inst_30375.cljs$core$IFn$_invoke$arity$2(inst_30436,inst_30360) : inst_30375.call(null,inst_30436,inst_30360));
var inst_30541__$1 = (inst_30540 < (0));
var state_30582__$1 = (function (){var statearr_30756 = state_30582;
(statearr_30756[(82)] = inst_30541__$1);

return statearr_30756;
})();
if(cljs.core.truth_(inst_30541__$1)){
var statearr_30757_30915 = state_30582__$1;
(statearr_30757_30915[(1)] = (108));

} else {
var statearr_30758_30916 = state_30582__$1;
(statearr_30758_30916[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (52))){
var inst_30245 = (state_30582[(56)]);
var state_30582__$1 = state_30582;
var statearr_30759_30917 = state_30582__$1;
(statearr_30759_30917[(2)] = inst_30245);

(statearr_30759_30917[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (114))){
var inst_30380 = (state_30582[(19)]);
var inst_30436 = (state_30582[(65)]);
var inst_30381 = (state_30582[(24)]);
var inst_30376 = (state_30582[(27)]);
var inst_30386 = (state_30582[(38)]);
var inst_30556 = fluree.db.query.range.find_next_valid_node(inst_30386,inst_30436,inst_30376,inst_30380,inst_30381);
var state_30582__$1 = state_30582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30582__$1,(117),inst_30556);
} else {
if((state_val_30583 === (67))){
var state_30582__$1 = state_30582;
var statearr_30760_30918 = state_30582__$1;
(statearr_30760_30918[(2)] = null);

(statearr_30760_30918[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (71))){
var inst_30409 = (state_30582[(10)]);
var inst_30243 = (state_30582[(11)]);
var inst_30301 = (state_30582[(12)]);
var inst_30399 = (state_30582[(13)]);
var inst_30236 = (state_30582[(14)]);
var inst_30362 = (state_30582[(15)]);
var inst_30403 = (state_30582[(16)]);
var inst_30300 = (state_30582[(17)]);
var inst_30249 = (state_30582[(18)]);
var inst_30380 = (state_30582[(19)]);
var inst_30322 = (state_30582[(20)]);
var inst_30400 = (state_30582[(21)]);
var inst_30370 = (state_30582[(22)]);
var inst_30232 = (state_30582[(23)]);
var inst_30390 = (state_30582[(8)]);
var inst_30381 = (state_30582[(24)]);
var inst_30259 = (state_30582[(25)]);
var inst_30359 = (state_30582[(26)]);
var inst_30376 = (state_30582[(27)]);
var inst_30268 = (state_30582[(28)]);
var inst_30247 = (state_30582[(29)]);
var inst_30239 = (state_30582[(30)]);
var inst_30375 = (state_30582[(31)]);
var inst_30244 = (state_30582[(32)]);
var inst_30369 = (state_30582[(33)]);
var inst_30304 = (state_30582[(34)]);
var inst_30396 = (state_30582[(9)]);
var inst_30313 = (state_30582[(35)]);
var inst_30401 = (state_30582[(36)]);
var inst_30248 = (state_30582[(37)]);
var inst_30386 = (state_30582[(38)]);
var inst_30358 = (state_30582[(39)]);
var inst_30340 = (state_30582[(40)]);
var inst_30363 = (state_30582[(41)]);
var inst_30237 = (state_30582[(42)]);
var inst_30402 = (state_30582[(43)]);
var inst_30371 = (state_30582[(44)]);
var inst_30360 = (state_30582[(45)]);
var inst_30349 = (state_30582[(46)]);
var inst_30331 = (state_30582[(47)]);
var inst_30413 = (function (){var no_filter_QMARK_ = inst_30396;
var t = inst_30376;
var max_limit_QMARK_ = inst_30370;
var next_node = inst_30399;
var fast_forward_db_QMARK_ = inst_30381;
var s1 = inst_30259;
var o2 = inst_30322;
var t1 = inst_30236;
var vec__30225 = inst_30300;
var predicate_fn = inst_30249;
var i = inst_30401;
var m1 = inst_30349;
var root_node = inst_30386;
var s2 = inst_30268;
var p2 = inst_30340;
var permissions = inst_30371;
var limit = inst_30369;
var start_flake = inst_30359;
var flake_limit = inst_30363;
var offset = inst_30400;
var acc = inst_30403;
var vec__30228 = inst_30301;
var t2 = inst_30243;
var vec__30221 = inst_30239;
var op1 = inst_30237;
var o1 = inst_30313;
var end_flake = inst_30360;
var base_result = inst_30409;
var s = inst_30402;
var node_start = inst_30390;
var p1 = inst_30331;
var subject_fn = inst_30248;
var vec__30218 = inst_30232;
var object_fn = inst_30304;
var idx_compare = inst_30375;
var map__30224 = inst_30247;
var G__30410 = inst_30409;
var map__30231 = inst_30362;
var op2 = inst_30244;
var m2 = inst_30358;
var novelty = inst_30380;
return (function (p1__30199_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__30199_SHARP_.o,start_flake.o);
});
})();
var inst_30414 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_30413,inst_30409);
var state_30582__$1 = state_30582;
var statearr_30761_30919 = state_30582__$1;
(statearr_30761_30919[(2)] = inst_30414);

(statearr_30761_30919[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (42))){
var inst_30336 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
if(cljs.core.truth_(inst_30336)){
var statearr_30762_30920 = state_30582__$1;
(statearr_30762_30920[(1)] = (43));

} else {
var statearr_30763_30921 = state_30582__$1;
(statearr_30763_30921[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (80))){
var inst_30409 = (state_30582[(10)]);
var inst_30243 = (state_30582[(11)]);
var inst_30301 = (state_30582[(12)]);
var inst_30399 = (state_30582[(13)]);
var inst_30236 = (state_30582[(14)]);
var inst_30362 = (state_30582[(15)]);
var inst_30403 = (state_30582[(16)]);
var inst_30300 = (state_30582[(17)]);
var inst_30249 = (state_30582[(18)]);
var inst_30380 = (state_30582[(19)]);
var inst_30322 = (state_30582[(20)]);
var inst_30400 = (state_30582[(21)]);
var inst_30370 = (state_30582[(22)]);
var inst_30232 = (state_30582[(23)]);
var inst_30390 = (state_30582[(8)]);
var inst_30381 = (state_30582[(24)]);
var inst_30259 = (state_30582[(25)]);
var inst_30359 = (state_30582[(26)]);
var inst_30376 = (state_30582[(27)]);
var inst_30268 = (state_30582[(28)]);
var inst_30247 = (state_30582[(29)]);
var inst_30239 = (state_30582[(30)]);
var inst_30375 = (state_30582[(31)]);
var inst_30244 = (state_30582[(32)]);
var inst_30369 = (state_30582[(33)]);
var inst_30304 = (state_30582[(34)]);
var inst_30396 = (state_30582[(9)]);
var inst_30429 = (state_30582[(86)]);
var inst_30313 = (state_30582[(35)]);
var inst_30401 = (state_30582[(36)]);
var inst_30248 = (state_30582[(37)]);
var inst_30386 = (state_30582[(38)]);
var inst_30358 = (state_30582[(39)]);
var inst_30340 = (state_30582[(40)]);
var inst_30363 = (state_30582[(41)]);
var inst_30237 = (state_30582[(42)]);
var inst_30402 = (state_30582[(43)]);
var inst_30371 = (state_30582[(44)]);
var inst_30360 = (state_30582[(45)]);
var inst_30349 = (state_30582[(46)]);
var inst_30331 = (state_30582[(47)]);
var inst_30431 = (function (){var no_filter_QMARK_ = inst_30396;
var t = inst_30376;
var max_limit_QMARK_ = inst_30370;
var next_node = inst_30399;
var fast_forward_db_QMARK_ = inst_30381;
var s1 = inst_30259;
var o2 = inst_30322;
var t1 = inst_30236;
var vec__30225 = inst_30300;
var predicate_fn = inst_30249;
var i = inst_30401;
var m1 = inst_30349;
var root_node = inst_30386;
var s2 = inst_30268;
var p2 = inst_30340;
var permissions = inst_30371;
var limit = inst_30369;
var start_flake = inst_30359;
var flake_limit = inst_30363;
var offset = inst_30400;
var acc = inst_30403;
var vec__30228 = inst_30301;
var t2 = inst_30243;
var vec__30221 = inst_30239;
var op1 = inst_30237;
var o1 = inst_30313;
var end_flake = inst_30360;
var base_result = inst_30409;
var s = inst_30402;
var node_start = inst_30390;
var p1 = inst_30331;
var subject_fn = inst_30248;
var vec__30218 = inst_30232;
var object_fn = inst_30304;
var idx_compare = inst_30375;
var map__30224 = inst_30247;
var G__30410 = inst_30429;
var map__30231 = inst_30362;
var op2 = inst_30244;
var m2 = inst_30358;
var novelty = inst_30380;
return (function (p1__30202_SHARP_){
var G__30764 = p1__30202_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__30764) : object_fn.call(null,G__30764));
});
})();
var inst_30432 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_30431,inst_30429);
var state_30582__$1 = state_30582;
var statearr_30765_30922 = state_30582__$1;
(statearr_30765_30922[(2)] = inst_30432);

(statearr_30765_30922[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (37))){
var state_30582__$1 = state_30582;
var statearr_30766_30923 = state_30582__$1;
(statearr_30766_30923[(2)] = (-1));

(statearr_30766_30923[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (63))){
var inst_30259 = (state_30582[(25)]);
var inst_30268 = (state_30582[(28)]);
var inst_30340 = (state_30582[(40)]);
var inst_30371 = (state_30582[(44)]);
var inst_30331 = (state_30582[(47)]);
var inst_30393 = fluree.db.permissions_validate.no_filter_QMARK_(inst_30371,inst_30259,inst_30268,inst_30331,inst_30340);
var state_30582__$1 = state_30582;
var statearr_30767_30924 = state_30582__$1;
(statearr_30767_30924[(2)] = inst_30393);

(statearr_30767_30924[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (94))){
var inst_30532 = (state_30582[(2)]);
var state_30582__$1 = state_30582;
var statearr_30768_30925 = state_30582__$1;
(statearr_30768_30925[(2)] = inst_30532);

(statearr_30768_30925[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (8))){
var inst_30240 = (state_30582[(84)]);
var inst_30259 = (state_30582[(2)]);
var inst_30260 = fluree.db.util.core.pred_ident_QMARK_(inst_30240);
var state_30582__$1 = (function (){var statearr_30769 = state_30582;
(statearr_30769[(25)] = inst_30259);

return statearr_30769;
})();
if(inst_30260){
var statearr_30770_30926 = state_30582__$1;
(statearr_30770_30926[(1)] = (10));

} else {
var statearr_30771_30927 = state_30582__$1;
(statearr_30771_30927[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (49))){
var state_30582__$1 = state_30582;
var statearr_30772_30928 = state_30582__$1;
(statearr_30772_30928[(2)] = fluree.db.util.core.min_integer);

(statearr_30772_30928[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30583 === (84))){
var inst_30370 = (state_30582[(22)]);
var state_30582__$1 = state_30582;
var statearr_30773_30929 = state_30582__$1;
(statearr_30773_30929[(2)] = inst_30370);

(statearr_30773_30929[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16395__auto__ = null;
var fluree$db$query$range$state_machine__16395__auto____0 = (function (){
var statearr_30774 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30774[(0)] = fluree$db$query$range$state_machine__16395__auto__);

(statearr_30774[(1)] = (1));

return statearr_30774;
});
var fluree$db$query$range$state_machine__16395__auto____1 = (function (state_30582){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_30582);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e30775){var ex__16398__auto__ = e30775;
var statearr_30776_30930 = state_30582;
(statearr_30776_30930[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_30582[(4)]))){
var statearr_30777_30931 = state_30582;
(statearr_30777_30931[(1)] = cljs.core.first((state_30582[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__30932 = state_30582;
state_30582 = G__30932;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16395__auto__ = function(state_30582){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16395__auto____1.call(this,state_30582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16395__auto____0;
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16395__auto____1;
return fluree$db$query$range$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_30778 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_30778[(6)] = c__16469__auto__);

return statearr_30778;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_30988){
var state_val_30989 = (state_30988[(1)]);
if((state_val_30989 === (7))){
var inst_30952 = (state_30988[(7)]);
var inst_30962 = (state_30988[(8)]);
var inst_30960 = fluree.db.flake.Flake__GT_parts(inst_30952);
var inst_30961 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30960,(0),null);
var inst_30962__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30960,(1),null);
var inst_30963 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30960,(2),null);
var inst_30964 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30960,(3),null);
var inst_30965 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30960,(4),null);
var inst_30966 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30960,(5),null);
var inst_30967 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_30963,inst_30962__$1);
var state_30988__$1 = (function (){var statearr_30990 = state_30988;
(statearr_30990[(9)] = inst_30966);

(statearr_30990[(8)] = inst_30962__$1);

(statearr_30990[(10)] = inst_30964);

(statearr_30990[(11)] = inst_30965);

(statearr_30990[(12)] = inst_30961);

return statearr_30990;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30988__$1,(10),inst_30967);
} else {
if((state_val_30989 === (1))){
var inst_30940 = flakes;
var inst_30941 = cljs.core.seq(inst_30940);
var inst_30942 = cljs.core.first(inst_30941);
var inst_30943 = cljs.core.next(inst_30941);
var inst_30944 = cljs.core.PersistentVector.EMPTY;
var inst_30945 = inst_30940;
var inst_30946 = inst_30944;
var state_30988__$1 = (function (){var statearr_30991 = state_30988;
(statearr_30991[(13)] = inst_30943);

(statearr_30991[(14)] = inst_30945);

(statearr_30991[(15)] = inst_30942);

(statearr_30991[(16)] = inst_30946);

return statearr_30991;
})();
var statearr_30992_31010 = state_30988__$1;
(statearr_30992_31010[(2)] = null);

(statearr_30992_31010[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30989 === (4))){
var inst_30952 = (state_30988[(7)]);
var inst_30955 = fluree.db.query.range.is_tag_flake_QMARK_(inst_30952);
var state_30988__$1 = state_30988;
if(inst_30955){
var statearr_30993_31011 = state_30988__$1;
(statearr_30993_31011[(1)] = (7));

} else {
var statearr_30994_31012 = state_30988__$1;
(statearr_30994_31012[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30989 === (6))){
var inst_30984 = (state_30988[(2)]);
var state_30988__$1 = state_30988;
var statearr_30995_31013 = state_30988__$1;
(statearr_30995_31013[(2)] = inst_30984);

(statearr_30995_31013[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30989 === (3))){
var inst_30986 = (state_30988[(2)]);
var state_30988__$1 = state_30988;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30988__$1,inst_30986);
} else {
if((state_val_30989 === (2))){
var inst_30952 = (state_30988[(7)]);
var inst_30945 = (state_30988[(14)]);
var inst_30951 = cljs.core.seq(inst_30945);
var inst_30952__$1 = cljs.core.first(inst_30951);
var inst_30953 = cljs.core.next(inst_30951);
var state_30988__$1 = (function (){var statearr_30996 = state_30988;
(statearr_30996[(7)] = inst_30952__$1);

(statearr_30996[(17)] = inst_30953);

return statearr_30996;
})();
if(cljs.core.truth_(inst_30952__$1)){
var statearr_30997_31014 = state_30988__$1;
(statearr_30997_31014[(1)] = (4));

} else {
var statearr_30998_31015 = state_30988__$1;
(statearr_30998_31015[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30989 === (9))){
var inst_30981 = (state_30988[(2)]);
var state_30988__$1 = state_30988;
var statearr_30999_31016 = state_30988__$1;
(statearr_30999_31016[(2)] = inst_30981);

(statearr_30999_31016[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30989 === (5))){
var inst_30946 = (state_30988[(16)]);
var state_30988__$1 = state_30988;
var statearr_31000_31017 = state_30988__$1;
(statearr_31000_31017[(2)] = inst_30946);

(statearr_31000_31017[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30989 === (10))){
var inst_30966 = (state_30988[(9)]);
var inst_30962 = (state_30988[(8)]);
var inst_30964 = (state_30988[(10)]);
var inst_30965 = (state_30988[(11)]);
var inst_30953 = (state_30988[(17)]);
var inst_30946 = (state_30988[(16)]);
var inst_30961 = (state_30988[(12)]);
var inst_30969 = (state_30988[(2)]);
var inst_30970 = fluree.db.util.async.throw_err(inst_30969);
var inst_30971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30972 = [inst_30961,inst_30962,inst_30970,inst_30964,inst_30965,inst_30966];
var inst_30973 = (new cljs.core.PersistentVector(null,6,(5),inst_30971,inst_30972,null));
var inst_30974 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_30973);
var inst_30975 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30946,inst_30974);
var inst_30945 = inst_30953;
var inst_30946__$1 = inst_30975;
var state_30988__$1 = (function (){var statearr_31001 = state_30988;
(statearr_31001[(14)] = inst_30945);

(statearr_31001[(16)] = inst_30946__$1);

return statearr_31001;
})();
var statearr_31002_31018 = state_30988__$1;
(statearr_31002_31018[(2)] = null);

(statearr_31002_31018[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30989 === (8))){
var inst_30952 = (state_30988[(7)]);
var inst_30953 = (state_30988[(17)]);
var inst_30946 = (state_30988[(16)]);
var inst_30978 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30946,inst_30952);
var inst_30945 = inst_30953;
var inst_30946__$1 = inst_30978;
var state_30988__$1 = (function (){var statearr_31003 = state_30988;
(statearr_31003[(14)] = inst_30945);

(statearr_31003[(16)] = inst_30946__$1);

return statearr_31003;
})();
var statearr_31004_31019 = state_30988__$1;
(statearr_31004_31019[(2)] = null);

(statearr_31004_31019[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto____0 = (function (){
var statearr_31005 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31005[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto__);

(statearr_31005[(1)] = (1));

return statearr_31005;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto____1 = (function (state_30988){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_30988);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e31006){var ex__16398__auto__ = e31006;
var statearr_31007_31020 = state_30988;
(statearr_31007_31020[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_30988[(4)]))){
var statearr_31008_31021 = state_30988;
(statearr_31008_31021[(1)] = cljs.core.first((state_30988[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__31022 = state_30988;
state_30988 = G__31022;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto__ = function(state_30988){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto____1.call(this,state_30988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_31009 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_31009[(6)] = c__16469__auto__);

return statearr_31009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__31024 = arguments.length;
switch (G__31024) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_31194){
var state_val_31195 = (state_31194[(1)]);
if((state_val_31195 === (65))){
var state_31194__$1 = state_31194;
var statearr_31196_31296 = state_31194__$1;
(statearr_31196_31296[(2)] = null);

(statearr_31196_31296[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (70))){
var inst_31189 = (state_31194[(2)]);
var _ = (function (){var statearr_31197 = state_31194;
(statearr_31197[(4)] = cljs.core.rest((state_31194[(4)])));

return statearr_31197;
})();
var state_31194__$1 = state_31194;
var statearr_31198_31297 = state_31194__$1;
(statearr_31198_31297[(2)] = inst_31189);

(statearr_31198_31297[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (62))){
var inst_31175 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
var statearr_31199_31298 = state_31194__$1;
(statearr_31199_31298[(2)] = inst_31175);

(statearr_31199_31298[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (7))){
var state_31194__$1 = state_31194;
var statearr_31200_31299 = state_31194__$1;
(statearr_31200_31299[(2)] = false);

(statearr_31200_31299[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (59))){
var inst_31149 = (state_31194[(2)]);
var inst_31150 = fluree.db.util.async.throw_err(inst_31149);
var state_31194__$1 = state_31194;
var statearr_31201_31300 = state_31194__$1;
(statearr_31201_31300[(2)] = inst_31150);

(statearr_31201_31300[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (20))){
var state_31194__$1 = state_31194;
var statearr_31202_31301 = state_31194__$1;
(statearr_31202_31301[(2)] = null);

(statearr_31202_31301[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (58))){
var inst_31139 = (state_31194[(2)]);
var inst_31140 = fluree.db.util.async.throw_err(inst_31139);
var inst_31141 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_31140);
var state_31194__$1 = state_31194;
var statearr_31203_31302 = state_31194__$1;
(statearr_31203_31302[(2)] = inst_31141);

(statearr_31203_31302[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (60))){
var inst_31038 = (state_31194[(7)]);
var inst_31036 = (state_31194[(8)]);
var inst_31035 = (state_31194[(9)]);
var inst_31075 = (state_31194[(10)]);
var inst_31155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31156 = [inst_31036,inst_31035,inst_31075,inst_31038];
var inst_31157 = (new cljs.core.PersistentVector(null,4,(5),inst_31155,inst_31156,null));
var inst_31158 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_31157,opts);
var state_31194__$1 = state_31194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31194__$1,(63),inst_31158);
} else {
if((state_val_31195 === (27))){
var inst_31086 = (state_31194[(11)]);
var inst_31075 = (state_31194[(10)]);
var inst_31086__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_31075);
var state_31194__$1 = (function (){var statearr_31204 = state_31194;
(statearr_31204[(11)] = inst_31086__$1);

return statearr_31204;
})();
if(inst_31086__$1){
var statearr_31205_31303 = state_31194__$1;
(statearr_31205_31303[(1)] = (30));

} else {
var statearr_31206_31304 = state_31194__$1;
(statearr_31206_31304[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (1))){
var state_31194__$1 = state_31194;
var statearr_31207_31305 = state_31194__$1;
(statearr_31207_31305[(2)] = null);

(statearr_31207_31305[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (69))){
var inst_31181 = (state_31194[(12)]);
var state_31194__$1 = state_31194;
var statearr_31208_31306 = state_31194__$1;
(statearr_31208_31306[(2)] = inst_31181);

(statearr_31208_31306[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (24))){
var inst_31036 = (state_31194[(8)]);
var state_31194__$1 = state_31194;
if(cljs.core.truth_(inst_31036)){
var statearr_31209_31307 = state_31194__$1;
(statearr_31209_31307[(1)] = (27));

} else {
var statearr_31210_31308 = state_31194__$1;
(statearr_31210_31308[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (55))){
var inst_31075 = (state_31194[(10)]);
var inst_31133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31134 = [inst_31075];
var inst_31135 = (new cljs.core.PersistentVector(null,1,(5),inst_31133,inst_31134,null));
var inst_31136 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$limit,(1));
var inst_31137 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_31135,inst_31136);
var state_31194__$1 = state_31194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31194__$1,(58),inst_31137);
} else {
if((state_val_31195 === (39))){
var inst_31106 = (state_31194[(2)]);
var inst_31107 = fluree.db.util.async.throw_err(inst_31106);
var state_31194__$1 = state_31194;
var statearr_31211_31309 = state_31194__$1;
(statearr_31211_31309[(2)] = inst_31107);

(statearr_31211_31309[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (46))){
var inst_31119 = (state_31194[(13)]);
var inst_31119__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_31194__$1 = (function (){var statearr_31212 = state_31194;
(statearr_31212[(13)] = inst_31119__$1);

return statearr_31212;
})();
if(cljs.core.truth_(inst_31119__$1)){
var statearr_31213_31310 = state_31194__$1;
(statearr_31213_31310[(1)] = (49));

} else {
var statearr_31214_31311 = state_31194__$1;
(statearr_31214_31311[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (4))){
var inst_31025 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
var statearr_31215_31312 = state_31194__$1;
(statearr_31215_31312[(2)] = inst_31025);

(statearr_31215_31312[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (54))){
var inst_31131 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
if(cljs.core.truth_(inst_31131)){
var statearr_31216_31313 = state_31194__$1;
(statearr_31216_31313[(1)] = (55));

} else {
var statearr_31217_31314 = state_31194__$1;
(statearr_31217_31314[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (15))){
var inst_31037 = (state_31194[(14)]);
var inst_31056 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_31037);
var state_31194__$1 = state_31194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31194__$1,(18),inst_31056);
} else {
if((state_val_31195 === (48))){
var inst_31177 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
var statearr_31218_31315 = state_31194__$1;
(statearr_31218_31315[(2)] = inst_31177);

(statearr_31218_31315[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (50))){
var inst_31045 = (state_31194[(15)]);
var inst_31119 = (state_31194[(13)]);
var inst_31050 = (state_31194[(16)]);
var inst_31038 = (state_31194[(7)]);
var inst_31034 = (state_31194[(17)]);
var inst_31039 = (state_31194[(18)]);
var inst_31036 = (state_31194[(8)]);
var inst_31035 = (state_31194[(9)]);
var inst_31075 = (state_31194[(10)]);
var inst_31123 = (function (){var t = inst_31038;
var p = inst_31036;
var idx_predicate_QMARK_ = inst_31039;
var o = inst_31075;
var tag_predicate_QMARK_ = inst_31045;
var temp__5751__auto__ = inst_31119;
var s = inst_31035;
var o_coerce_QMARK_ = inst_31050;
var vec__31031 = inst_31034;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_31194__$1 = state_31194;
var statearr_31219_31316 = state_31194__$1;
(statearr_31219_31316[(2)] = inst_31123);

(statearr_31219_31316[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (21))){
var inst_31071 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
var statearr_31220_31317 = state_31194__$1;
(statearr_31220_31317[(2)] = inst_31071);

(statearr_31220_31317[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (31))){
var inst_31086 = (state_31194[(11)]);
var state_31194__$1 = state_31194;
var statearr_31221_31318 = state_31194__$1;
(statearr_31221_31318[(2)] = inst_31086);

(statearr_31221_31318[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (32))){
var inst_31096 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
var statearr_31222_31319 = state_31194__$1;
(statearr_31222_31319[(2)] = inst_31096);

(statearr_31222_31319[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (40))){
var inst_31039 = (state_31194[(18)]);
var inst_31110 = (state_31194[(19)]);
var inst_31110__$1 = cljs.core.not(inst_31039);
var state_31194__$1 = (function (){var statearr_31223 = state_31194;
(statearr_31223[(19)] = inst_31110__$1);

return statearr_31223;
})();
if(inst_31110__$1){
var statearr_31224_31320 = state_31194__$1;
(statearr_31224_31320[(1)] = (43));

} else {
var statearr_31225_31321 = state_31194__$1;
(statearr_31225_31321[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (56))){
var inst_31038 = (state_31194[(7)]);
var inst_31036 = (state_31194[(8)]);
var inst_31125 = (state_31194[(20)]);
var inst_31035 = (state_31194[(9)]);
var inst_31143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31144 = [inst_31036,inst_31035,null,inst_31038];
var inst_31145 = (new cljs.core.PersistentVector(null,4,(5),inst_31143,inst_31144,null));
var inst_31146 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_31125);
var inst_31147 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_31145,inst_31146);
var state_31194__$1 = state_31194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31194__$1,(59),inst_31147);
} else {
if((state_val_31195 === (33))){
var inst_31075 = (state_31194[(10)]);
var inst_31089 = cljs.core.fn_QMARK_(inst_31075);
var inst_31090 = (!(inst_31089));
var state_31194__$1 = state_31194;
var statearr_31226_31322 = state_31194__$1;
(statearr_31226_31322[(2)] = inst_31090);

(statearr_31226_31322[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (13))){
var inst_31037 = (state_31194[(14)]);
var inst_31054 = fluree.db.query.range.tag_string_QMARK_(inst_31037);
var state_31194__$1 = state_31194;
if(cljs.core.truth_(inst_31054)){
var statearr_31227_31323 = state_31194__$1;
(statearr_31227_31323[(1)] = (15));

} else {
var statearr_31228_31324 = state_31194__$1;
(statearr_31228_31324[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (22))){
var inst_31067 = (state_31194[(2)]);
var inst_31068 = fluree.db.util.async.throw_err(inst_31067);
var state_31194__$1 = state_31194;
var statearr_31229_31325 = state_31194__$1;
(statearr_31229_31325[(2)] = inst_31068);

(statearr_31229_31325[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (36))){
var inst_31038 = (state_31194[(7)]);
var inst_31036 = (state_31194[(8)]);
var inst_31035 = (state_31194[(9)]);
var inst_31075 = (state_31194[(10)]);
var inst_31101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31102 = [inst_31036,inst_31075,inst_31035,inst_31038];
var inst_31103 = (new cljs.core.PersistentVector(null,4,(5),inst_31101,inst_31102,null));
var inst_31104 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_31103,opts);
var state_31194__$1 = state_31194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31194__$1,(39),inst_31104);
} else {
if((state_val_31195 === (41))){
var inst_31036 = (state_31194[(8)]);
var state_31194__$1 = state_31194;
var statearr_31230_31326 = state_31194__$1;
(statearr_31230_31326[(2)] = inst_31036);

(statearr_31230_31326[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (43))){
var inst_31075 = (state_31194[(10)]);
var state_31194__$1 = state_31194;
var statearr_31231_31327 = state_31194__$1;
(statearr_31231_31327[(2)] = inst_31075);

(statearr_31231_31327[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (61))){
var inst_31075 = (state_31194[(10)]);
var state_31194__$1 = state_31194;
if(cljs.core.truth_(inst_31075)){
var statearr_31232_31328 = state_31194__$1;
(statearr_31232_31328[(1)] = (64));

} else {
var statearr_31233_31329 = state_31194__$1;
(statearr_31233_31329[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (29))){
var inst_31099 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
if(cljs.core.truth_(inst_31099)){
var statearr_31234_31330 = state_31194__$1;
(statearr_31234_31330[(1)] = (36));

} else {
var statearr_31235_31331 = state_31194__$1;
(statearr_31235_31331[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (44))){
var inst_31110 = (state_31194[(19)]);
var state_31194__$1 = state_31194;
var statearr_31236_31332 = state_31194__$1;
(statearr_31236_31332[(2)] = inst_31110);

(statearr_31236_31332[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (6))){
var inst_31036 = (state_31194[(8)]);
var inst_31041 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_31036);
var inst_31042 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_31041);
var state_31194__$1 = state_31194;
var statearr_31237_31333 = state_31194__$1;
(statearr_31237_31333[(2)] = inst_31042);

(statearr_31237_31333[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (28))){
var inst_31036 = (state_31194[(8)]);
var state_31194__$1 = state_31194;
var statearr_31238_31334 = state_31194__$1;
(statearr_31238_31334[(2)] = inst_31036);

(statearr_31238_31334[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (64))){
var inst_31038 = (state_31194[(7)]);
var inst_31036 = (state_31194[(8)]);
var inst_31035 = (state_31194[(9)]);
var inst_31075 = (state_31194[(10)]);
var inst_31164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31165 = [inst_31075,inst_31036,inst_31035,inst_31038];
var inst_31166 = (new cljs.core.PersistentVector(null,4,(5),inst_31164,inst_31165,null));
var inst_31167 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_31166,opts);
var state_31194__$1 = state_31194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31194__$1,(67),inst_31167);
} else {
if((state_val_31195 === (51))){
var inst_31036 = (state_31194[(8)]);
var inst_31126 = (state_31194[(21)]);
var inst_31125 = (state_31194[(2)]);
var inst_31126__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_31036);
var state_31194__$1 = (function (){var statearr_31239 = state_31194;
(statearr_31239[(20)] = inst_31125);

(statearr_31239[(21)] = inst_31126__$1);

return statearr_31239;
})();
if(inst_31126__$1){
var statearr_31240_31335 = state_31194__$1;
(statearr_31240_31335[(1)] = (52));

} else {
var statearr_31241_31336 = state_31194__$1;
(statearr_31241_31336[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (25))){
var inst_31045 = (state_31194[(15)]);
var inst_31181 = (state_31194[(2)]);
var state_31194__$1 = (function (){var statearr_31242 = state_31194;
(statearr_31242[(12)] = inst_31181);

return statearr_31242;
})();
if(cljs.core.truth_(inst_31045)){
var statearr_31243_31337 = state_31194__$1;
(statearr_31243_31337[(1)] = (68));

} else {
var statearr_31244_31338 = state_31194__$1;
(statearr_31244_31338[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (34))){
var inst_31039 = (state_31194[(18)]);
var state_31194__$1 = state_31194;
var statearr_31245_31339 = state_31194__$1;
(statearr_31245_31339[(2)] = inst_31039);

(statearr_31245_31339[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (17))){
var inst_31073 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
var statearr_31246_31340 = state_31194__$1;
(statearr_31246_31340[(2)] = inst_31073);

(statearr_31246_31340[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (3))){
var inst_31192 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31194__$1,inst_31192);
} else {
if((state_val_31195 === (12))){
var inst_31037 = (state_31194[(14)]);
var state_31194__$1 = state_31194;
var statearr_31247_31341 = state_31194__$1;
(statearr_31247_31341[(2)] = inst_31037);

(statearr_31247_31341[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (2))){
var inst_31034 = (state_31194[(17)]);
var inst_31036 = (state_31194[(8)]);
var _ = (function (){var statearr_31248 = state_31194;
(statearr_31248[(4)] = cljs.core.cons((5),(state_31194[(4)])));

return statearr_31248;
})();
var inst_31034__$1 = fparts;
var inst_31035 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31034__$1,(0),null);
var inst_31036__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31034__$1,(1),null);
var inst_31037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31034__$1,(2),null);
var inst_31038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31034__$1,(3),null);
var inst_31039 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_31036__$1);
var state_31194__$1 = (function (){var statearr_31249 = state_31194;
(statearr_31249[(7)] = inst_31038);

(statearr_31249[(17)] = inst_31034__$1);

(statearr_31249[(18)] = inst_31039);

(statearr_31249[(8)] = inst_31036__$1);

(statearr_31249[(9)] = inst_31035);

(statearr_31249[(14)] = inst_31037);

return statearr_31249;
})();
if(cljs.core.truth_(inst_31036__$1)){
var statearr_31250_31342 = state_31194__$1;
(statearr_31250_31342[(1)] = (6));

} else {
var statearr_31251_31343 = state_31194__$1;
(statearr_31251_31343[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (66))){
var inst_31173 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
var statearr_31252_31344 = state_31194__$1;
(statearr_31252_31344[(2)] = inst_31173);

(statearr_31252_31344[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (23))){
var inst_31038 = (state_31194[(7)]);
var inst_31036 = (state_31194[(8)]);
var inst_31035 = (state_31194[(9)]);
var inst_31075 = (state_31194[(10)]);
var inst_31077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31078 = [inst_31035,inst_31036,inst_31075,inst_31038];
var inst_31079 = (new cljs.core.PersistentVector(null,4,(5),inst_31077,inst_31078,null));
var inst_31080 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_31079,opts);
var state_31194__$1 = state_31194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31194__$1,(26),inst_31080);
} else {
if((state_val_31195 === (47))){
var inst_31036 = (state_31194[(8)]);
var state_31194__$1 = state_31194;
if(cljs.core.truth_(inst_31036)){
var statearr_31253_31345 = state_31194__$1;
(statearr_31253_31345[(1)] = (60));

} else {
var statearr_31254_31346 = state_31194__$1;
(statearr_31254_31346[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (35))){
var inst_31093 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
var statearr_31255_31347 = state_31194__$1;
(statearr_31255_31347[(2)] = inst_31093);

(statearr_31255_31347[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (19))){
var inst_31036 = (state_31194[(8)]);
var inst_31037 = (state_31194[(14)]);
var inst_31063 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_31036);
var inst_31064 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31063),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31037)].join('');
var inst_31065 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_31064);
var state_31194__$1 = state_31194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31194__$1,(22),inst_31065);
} else {
if((state_val_31195 === (57))){
var inst_31152 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
var statearr_31256_31348 = state_31194__$1;
(statearr_31256_31348[(2)] = inst_31152);

(statearr_31256_31348[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (68))){
var inst_31181 = (state_31194[(12)]);
var inst_31183 = fluree.db.query.range.coerce_tag_flakes(db,inst_31181);
var state_31194__$1 = state_31194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31194__$1,(71),inst_31183);
} else {
if((state_val_31195 === (11))){
var inst_31050 = (state_31194[(16)]);
var inst_31050__$1 = (state_31194[(2)]);
var inst_31051 = cljs.core.not(inst_31050__$1);
var state_31194__$1 = (function (){var statearr_31258 = state_31194;
(statearr_31258[(16)] = inst_31050__$1);

return statearr_31258;
})();
if(inst_31051){
var statearr_31259_31349 = state_31194__$1;
(statearr_31259_31349[(1)] = (12));

} else {
var statearr_31260_31350 = state_31194__$1;
(statearr_31260_31350[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (9))){
var inst_31037 = (state_31194[(14)]);
var inst_31047 = typeof inst_31037 === 'string';
var state_31194__$1 = state_31194;
var statearr_31261_31351 = state_31194__$1;
(statearr_31261_31351[(2)] = inst_31047);

(statearr_31261_31351[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (5))){
var _ = (function (){var statearr_31262 = state_31194;
(statearr_31262[(4)] = cljs.core.rest((state_31194[(4)])));

return statearr_31262;
})();
var state_31194__$1 = state_31194;
var ex31257 = (state_31194__$1[(2)]);
var statearr_31263_31352 = state_31194__$1;
(statearr_31263_31352[(5)] = ex31257);


if((ex31257 instanceof Error)){
var statearr_31264_31353 = state_31194__$1;
(statearr_31264_31353[(1)] = (4));

(statearr_31264_31353[(5)] = null);

} else {
throw ex31257;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (14))){
var inst_31035 = (state_31194[(9)]);
var inst_31075 = (state_31194[(2)]);
var state_31194__$1 = (function (){var statearr_31265 = state_31194;
(statearr_31265[(10)] = inst_31075);

return statearr_31265;
})();
if(cljs.core.truth_(inst_31035)){
var statearr_31266_31354 = state_31194__$1;
(statearr_31266_31354[(1)] = (23));

} else {
var statearr_31267_31355 = state_31194__$1;
(statearr_31267_31355[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (45))){
var inst_31114 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
var statearr_31268_31356 = state_31194__$1;
(statearr_31268_31356[(2)] = inst_31114);

(statearr_31268_31356[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (53))){
var inst_31126 = (state_31194[(21)]);
var state_31194__$1 = state_31194;
var statearr_31269_31357 = state_31194__$1;
(statearr_31269_31357[(2)] = inst_31126);

(statearr_31269_31357[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (26))){
var inst_31082 = (state_31194[(2)]);
var inst_31083 = fluree.db.util.async.throw_err(inst_31082);
var state_31194__$1 = state_31194;
var statearr_31270_31358 = state_31194__$1;
(statearr_31270_31358[(2)] = inst_31083);

(statearr_31270_31358[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (16))){
var inst_31037 = (state_31194[(14)]);
var inst_31061 = typeof inst_31037 === 'string';
var state_31194__$1 = state_31194;
if(cljs.core.truth_(inst_31061)){
var statearr_31271_31359 = state_31194__$1;
(statearr_31271_31359[(1)] = (19));

} else {
var statearr_31272_31360 = state_31194__$1;
(statearr_31272_31360[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (38))){
var inst_31179 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
var statearr_31273_31361 = state_31194__$1;
(statearr_31273_31361[(2)] = inst_31179);

(statearr_31273_31361[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (30))){
var inst_31039 = (state_31194[(18)]);
var state_31194__$1 = state_31194;
if(cljs.core.truth_(inst_31039)){
var statearr_31274_31362 = state_31194__$1;
(statearr_31274_31362[(1)] = (33));

} else {
var statearr_31275_31363 = state_31194__$1;
(statearr_31275_31363[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (10))){
var inst_31045 = (state_31194[(15)]);
var state_31194__$1 = state_31194;
var statearr_31276_31364 = state_31194__$1;
(statearr_31276_31364[(2)] = inst_31045);

(statearr_31276_31364[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (18))){
var inst_31058 = (state_31194[(2)]);
var inst_31059 = fluree.db.util.async.throw_err(inst_31058);
var state_31194__$1 = state_31194;
var statearr_31277_31365 = state_31194__$1;
(statearr_31277_31365[(2)] = inst_31059);

(statearr_31277_31365[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (52))){
var inst_31075 = (state_31194[(10)]);
var inst_31128 = cljs.core.int_QMARK_(inst_31075);
var state_31194__$1 = state_31194;
var statearr_31278_31366 = state_31194__$1;
(statearr_31278_31366[(2)] = inst_31128);

(statearr_31278_31366[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (67))){
var inst_31169 = (state_31194[(2)]);
var inst_31170 = fluree.db.util.async.throw_err(inst_31169);
var state_31194__$1 = state_31194;
var statearr_31279_31367 = state_31194__$1;
(statearr_31279_31367[(2)] = inst_31170);

(statearr_31279_31367[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (71))){
var inst_31185 = (state_31194[(2)]);
var inst_31186 = fluree.db.util.async.throw_err(inst_31185);
var state_31194__$1 = state_31194;
var statearr_31280_31368 = state_31194__$1;
(statearr_31280_31368[(2)] = inst_31186);

(statearr_31280_31368[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (42))){
var inst_31117 = (state_31194[(2)]);
var state_31194__$1 = state_31194;
if(cljs.core.truth_(inst_31117)){
var statearr_31281_31369 = state_31194__$1;
(statearr_31281_31369[(1)] = (46));

} else {
var statearr_31282_31370 = state_31194__$1;
(statearr_31282_31370[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (37))){
var inst_31036 = (state_31194[(8)]);
var state_31194__$1 = state_31194;
if(cljs.core.truth_(inst_31036)){
var statearr_31283_31371 = state_31194__$1;
(statearr_31283_31371[(1)] = (40));

} else {
var statearr_31284_31372 = state_31194__$1;
(statearr_31284_31372[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (63))){
var inst_31160 = (state_31194[(2)]);
var inst_31161 = fluree.db.util.async.throw_err(inst_31160);
var state_31194__$1 = state_31194;
var statearr_31285_31373 = state_31194__$1;
(statearr_31285_31373[(2)] = inst_31161);

(statearr_31285_31373[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (8))){
var inst_31045 = (state_31194[(15)]);
var inst_31045__$1 = (state_31194[(2)]);
var state_31194__$1 = (function (){var statearr_31286 = state_31194;
(statearr_31286[(15)] = inst_31045__$1);

return statearr_31286;
})();
if(cljs.core.truth_(inst_31045__$1)){
var statearr_31287_31374 = state_31194__$1;
(statearr_31287_31374[(1)] = (9));

} else {
var statearr_31288_31375 = state_31194__$1;
(statearr_31288_31375[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31195 === (49))){
var inst_31045 = (state_31194[(15)]);
var inst_31119 = (state_31194[(13)]);
var inst_31050 = (state_31194[(16)]);
var inst_31038 = (state_31194[(7)]);
var inst_31034 = (state_31194[(17)]);
var inst_31039 = (state_31194[(18)]);
var inst_31036 = (state_31194[(8)]);
var inst_31035 = (state_31194[(9)]);
var inst_31075 = (state_31194[(10)]);
var inst_31121 = (function (){var obj_fn = inst_31119;
var t = inst_31038;
var p = inst_31036;
var idx_predicate_QMARK_ = inst_31039;
var o = inst_31075;
var tag_predicate_QMARK_ = inst_31045;
var temp__5751__auto__ = inst_31119;
var s = inst_31035;
var o_coerce_QMARK_ = inst_31050;
var vec__31031 = inst_31034;
return (function (x){
var and__4210__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4210__auto__;
}
});
})();
var state_31194__$1 = state_31194;
var statearr_31289_31376 = state_31194__$1;
(statearr_31289_31376[(2)] = inst_31121);

(statearr_31289_31376[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16395__auto__ = null;
var fluree$db$query$range$state_machine__16395__auto____0 = (function (){
var statearr_31290 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31290[(0)] = fluree$db$query$range$state_machine__16395__auto__);

(statearr_31290[(1)] = (1));

return statearr_31290;
});
var fluree$db$query$range$state_machine__16395__auto____1 = (function (state_31194){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_31194);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e31291){var ex__16398__auto__ = e31291;
var statearr_31292_31377 = state_31194;
(statearr_31292_31377[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_31194[(4)]))){
var statearr_31293_31378 = state_31194;
(statearr_31293_31378[(1)] = cljs.core.first((state_31194[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__31379 = state_31194;
state_31194 = G__31379;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16395__auto__ = function(state_31194){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16395__auto____1.call(this,state_31194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16395__auto____0;
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16395__auto____1;
return fluree$db$query$range$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_31294 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_31294[(6)] = c__16469__auto__);

return statearr_31294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__31381 = arguments.length;
switch (G__31381) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_31416){
var state_val_31417 = (state_31416[(1)]);
if((state_val_31417 === (7))){
var inst_31403 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_31404 = ["Invalid collection name: ",inst_31403].join('');
var inst_31405 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31406 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_31407 = cljs.core.PersistentHashMap.fromArrays(inst_31405,inst_31406);
var inst_31408 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31404,inst_31407);
var inst_31409 = (function(){throw inst_31408})();
var state_31416__$1 = state_31416;
var statearr_31418_31438 = state_31416__$1;
(statearr_31418_31438[(2)] = inst_31409);

(statearr_31418_31438[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31417 === (1))){
var state_31416__$1 = state_31416;
var statearr_31419_31439 = state_31416__$1;
(statearr_31419_31439[(2)] = null);

(statearr_31419_31439[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31417 === (4))){
var inst_31382 = (state_31416[(2)]);
var state_31416__$1 = state_31416;
var statearr_31420_31440 = state_31416__$1;
(statearr_31420_31440[(2)] = inst_31382);

(statearr_31420_31440[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31417 === (6))){
var inst_31388 = (state_31416[(7)]);
var inst_31390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31391 = fluree.db.flake.max_subject_id(inst_31388);
var inst_31392 = [inst_31391];
var inst_31393 = (new cljs.core.PersistentVector(null,1,(5),inst_31390,inst_31392,null));
var inst_31394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31395 = fluree.db.flake.min_subject_id(inst_31388);
var inst_31396 = [inst_31395];
var inst_31397 = (new cljs.core.PersistentVector(null,1,(5),inst_31394,inst_31396,null));
var inst_31398 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_31393,cljs.core._LT__EQ_,inst_31397,opts);
var state_31416__$1 = state_31416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31416__$1,(9),inst_31398);
} else {
if((state_val_31417 === (3))){
var inst_31414 = (state_31416[(2)]);
var state_31416__$1 = state_31416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31416__$1,inst_31414);
} else {
if((state_val_31417 === (2))){
var inst_31388 = (state_31416[(7)]);
var _ = (function (){var statearr_31422 = state_31416;
(statearr_31422[(4)] = cljs.core.cons((5),(state_31416[(4)])));

return statearr_31422;
})();
var inst_31388__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,name);
var state_31416__$1 = (function (){var statearr_31423 = state_31416;
(statearr_31423[(7)] = inst_31388__$1);

return statearr_31423;
})();
if(cljs.core.truth_(inst_31388__$1)){
var statearr_31424_31441 = state_31416__$1;
(statearr_31424_31441[(1)] = (6));

} else {
var statearr_31425_31442 = state_31416__$1;
(statearr_31425_31442[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31417 === (9))){
var inst_31400 = (state_31416[(2)]);
var inst_31401 = fluree.db.util.async.throw_err(inst_31400);
var state_31416__$1 = state_31416;
var statearr_31426_31443 = state_31416__$1;
(statearr_31426_31443[(2)] = inst_31401);

(statearr_31426_31443[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31417 === (5))){
var _ = (function (){var statearr_31427 = state_31416;
(statearr_31427[(4)] = cljs.core.rest((state_31416[(4)])));

return statearr_31427;
})();
var state_31416__$1 = state_31416;
var ex31421 = (state_31416__$1[(2)]);
var statearr_31428_31444 = state_31416__$1;
(statearr_31428_31444[(5)] = ex31421);


var statearr_31429_31445 = state_31416__$1;
(statearr_31429_31445[(1)] = (4));

(statearr_31429_31445[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31417 === (8))){
var inst_31411 = (state_31416[(2)]);
var _ = (function (){var statearr_31430 = state_31416;
(statearr_31430[(4)] = cljs.core.rest((state_31416[(4)])));

return statearr_31430;
})();
var state_31416__$1 = state_31416;
var statearr_31431_31446 = state_31416__$1;
(statearr_31431_31446[(2)] = inst_31411);

(statearr_31431_31446[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16395__auto__ = null;
var fluree$db$query$range$state_machine__16395__auto____0 = (function (){
var statearr_31432 = [null,null,null,null,null,null,null,null];
(statearr_31432[(0)] = fluree$db$query$range$state_machine__16395__auto__);

(statearr_31432[(1)] = (1));

return statearr_31432;
});
var fluree$db$query$range$state_machine__16395__auto____1 = (function (state_31416){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_31416);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e31433){var ex__16398__auto__ = e31433;
var statearr_31434_31447 = state_31416;
(statearr_31434_31447[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_31416[(4)]))){
var statearr_31435_31448 = state_31416;
(statearr_31435_31448[(1)] = cljs.core.first((state_31416[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__31449 = state_31416;
state_31416 = G__31449;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16395__auto__ = function(state_31416){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16395__auto____1.call(this,state_31416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16395__auto____0;
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16395__auto____1;
return fluree$db$query$range$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_31436 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_31436[(6)] = c__16469__auto__);

return statearr_31436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__31453 = flakes;
var vec__31454 = G__31453;
var seq__31455 = cljs.core.seq(vec__31454);
var first__31456 = cljs.core.first(seq__31455);
var seq__31455__$1 = cljs.core.next(seq__31455);
var flake_SINGLEQUOTE_ = first__31456;
var r = seq__31455__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__31453__$1 = G__31453;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__31462 = G__31453__$1;
var seq__31463 = cljs.core.seq(vec__31462);
var first__31464 = cljs.core.first(seq__31463);
var seq__31463__$1 = cljs.core.next(seq__31463);
var flake_SINGLEQUOTE___$1 = first__31464;
var r__$1 = seq__31463__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e31466){var e = e31466;
return null;
}})();
var map__31465 = cmd_map;
var map__31465__$1 = cljs.core.__destructure_map(map__31465);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31465__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31465__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31465__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31465__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31465__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31465__$1,cljs.core.cst$kw$expire);
var G__31467 = r__$1;
var G__31468 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__31453__$1 = G__31467;
result_STAR___$1 = G__31468;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__31477 = blocks;
var vec__31478 = G__31477;
var seq__31479 = cljs.core.seq(vec__31478);
var first__31480 = cljs.core.first(seq__31479);
var seq__31479__$1 = cljs.core.next(seq__31479);
var block_SINGLEQUOTE_ = first__31480;
var r = seq__31479__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__31477__$1 = G__31477;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__31485 = G__31477__$1;
var seq__31486 = cljs.core.seq(vec__31485);
var first__31487 = cljs.core.first(seq__31486);
var seq__31486__$1 = cljs.core.next(seq__31486);
var block_SINGLEQUOTE___$1 = first__31487;
var r__$1 = seq__31486__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__31488 = block_SINGLEQUOTE___$1;
var map__31488__$1 = cljs.core.__destructure_map(map__31488);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31488__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31488__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31488__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__31477__$1,result_STAR___$1,map__31488,map__31488__$1,block,t,flakes,vec__31485,seq__31486,first__31487,seq__31486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31477,vec__31478,seq__31479,first__31480,seq__31479__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31469_SHARP_){
var f = p1__31469_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__31477__$1,result_STAR___$1,map__31488,map__31488__$1,block,t,flakes,vec__31485,seq__31486,first__31487,seq__31486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31477,vec__31478,seq__31479,first__31480,seq__31479__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__31477__$1,result_STAR___$1,map__31488,map__31488__$1,block,t,flakes,prev_hash,vec__31485,seq__31486,first__31487,seq__31486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31477,vec__31478,seq__31479,first__31480,seq__31479__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31470_SHARP_){
var f = p1__31470_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__31477__$1,result_STAR___$1,map__31488,map__31488__$1,block,t,flakes,prev_hash,vec__31485,seq__31486,first__31487,seq__31486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31477,vec__31478,seq__31479,first__31480,seq__31479__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__31477__$1,result_STAR___$1,map__31488,map__31488__$1,block,t,flakes,prev_hash,hash,vec__31485,seq__31486,first__31487,seq__31486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31477,vec__31478,seq__31479,first__31480,seq__31479__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31471_SHARP_){
var f = p1__31471_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__31477__$1,result_STAR___$1,map__31488,map__31488__$1,block,t,flakes,prev_hash,hash,vec__31485,seq__31486,first__31487,seq__31486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31477,vec__31478,seq__31479,first__31480,seq__31479__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__31477__$1,result_STAR___$1,map__31488,map__31488__$1,block,t,flakes,prev_hash,hash,instant,vec__31485,seq__31486,first__31487,seq__31486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31477,vec__31478,seq__31479,first__31480,seq__31479__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31472_SHARP_){
var f = p1__31472_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__31477__$1,result_STAR___$1,map__31488,map__31488__$1,block,t,flakes,prev_hash,hash,instant,vec__31485,seq__31486,first__31487,seq__31486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31477,vec__31478,seq__31479,first__31480,seq__31479__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__31477__$1,result_STAR___$1,map__31488,map__31488__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__31485,seq__31486,first__31487,seq__31486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31477,vec__31478,seq__31479,first__31480,seq__31479__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31473_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31473_SHARP_.p,(106));
});})(G__31477__$1,result_STAR___$1,map__31488,map__31488__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__31485,seq__31486,first__31487,seq__31486__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31477,vec__31478,seq__31479,first__31480,seq__31479__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__31489 = r__$1;
var G__31490 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__31477__$1 = G__31489;
result_STAR___$1 = G__31490;
continue;
}
break;
}
});
