// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35640_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35640_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__35644 = coll;
var vec__35645 = G__35644;
var seq__35646 = cljs.core.seq(vec__35645);
var first__35647 = cljs.core.first(seq__35646);
var seq__35646__$1 = cljs.core.next(seq__35646);
var clause = first__35647;
var r = seq__35646__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__35644__$1 = G__35644;
var res__$1 = res;
while(true){
var vec__35651 = G__35644__$1;
var seq__35652 = cljs.core.seq(vec__35651);
var first__35653 = cljs.core.first(seq__35652);
var seq__35652__$1 = cljs.core.next(seq__35652);
var clause__$1 = first__35653;
var r__$1 = seq__35652__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__35654 = r__$1;
var G__35655 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__35644__$1 = G__35654;
res__$1 = G__35655;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__35656){
var map__35657 = p__35656;
var map__35657__$1 = cljs.core.__destructure_map(map__35657);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35657__$1,cljs.core.cst$kw$optional);
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__35661 = coll;
var vec__35662 = G__35661;
var seq__35663 = cljs.core.seq(vec__35662);
var first__35664 = cljs.core.first(seq__35663);
var seq__35663__$1 = cljs.core.next(seq__35663);
var clause = first__35664;
var r = seq__35663__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__35661__$1 = G__35661;
var res__$1 = res;
while(true){
var vec__35668 = G__35661__$1;
var seq__35669 = cljs.core.seq(vec__35668);
var first__35670 = cljs.core.first(seq__35669);
var seq__35669__$1 = cljs.core.next(seq__35669);
var clause__$1 = first__35670;
var r__$1 = seq__35669__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__35671 = r__$1;
var G__35672 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__35661__$1 = G__35671;
res__$1 = G__35672;
continue;
} else {
var G__35673 = r__$1;
var G__35674 = res__$2;
G__35661__$1 = G__35673;
res__$1 = G__35674;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__35678 = coll;
var vec__35679 = G__35678;
var seq__35680 = cljs.core.seq(vec__35679);
var first__35681 = cljs.core.first(seq__35680);
var seq__35680__$1 = cljs.core.next(seq__35680);
var clause = first__35681;
var r = seq__35680__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__35678__$1 = G__35678;
var res__$1 = res;
while(true){
var vec__35685 = G__35678__$1;
var seq__35686 = cljs.core.seq(vec__35685);
var first__35687 = cljs.core.first(seq__35686);
var seq__35686__$1 = cljs.core.next(seq__35686);
var clause__$1 = first__35687;
var r__$1 = seq__35686__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__35688 = r__$1;
var G__35689 = res__$2;
G__35678__$1 = G__35688;
res__$1 = G__35689;
continue;
} else {
var G__35690 = r__$1;
var G__35691 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__35678__$1 = G__35690;
res__$1 = G__35691;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__35694 = clause;
var G__35694__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__35694):G__35694);
var G__35694__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__35694__$1)
;
var G__35694__$3 = (function (){var fexpr__35695 = (function (p1__35692_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35692_SHARP_)," ."].join('');
});
return fexpr__35695(G__35694__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__35696 = (function (p1__35693_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35693_SHARP_),"}"].join('');
});
return fexpr__35696(G__35694__$3);
} else {
return G__35694__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__35700 = opts;
var map__35700__$1 = cljs.core.__destructure_map(map__35700);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35700__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35700__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35700__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35700__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35700__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35697_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35697_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__35698_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__35698_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__35699_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__35699_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4212__auto__ = language;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_35714){
var state_val_35715 = (state_35714[(1)]);
if((state_val_35715 === (1))){
var inst_35701 = fluree.db.util.core.url_encode(query);
var inst_35702 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35701)].join('');
var inst_35703 = ["User-Agent","Accept"];
var inst_35704 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_35705 = cljs.core.PersistentHashMap.fromArrays(inst_35703,inst_35704);
var inst_35706 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_35707 = [inst_35705,(30000),cljs.core.cst$kw$wikidata];
var inst_35708 = cljs.core.PersistentHashMap.fromArrays(inst_35706,inst_35707);
var inst_35709 = fluree.db.util.xhttp.get(inst_35702,inst_35708);
var state_35714__$1 = state_35714;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35714__$1,(2),inst_35709);
} else {
if((state_val_35715 === (2))){
var inst_35711 = (state_35714[(2)]);
var inst_35712 = fluree.db.util.async.throw_err(inst_35711);
var state_35714__$1 = state_35714;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35714__$1,inst_35712);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto____0 = (function (){
var statearr_35716 = [null,null,null,null,null,null,null];
(statearr_35716[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto__);

(statearr_35716[(1)] = (1));

return statearr_35716;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto____1 = (function (state_35714){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_35714);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e35717){var ex__16398__auto__ = e35717;
var statearr_35718_35721 = state_35714;
(statearr_35718_35721[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_35714[(4)]))){
var statearr_35719_35722 = state_35714;
(statearr_35719_35722[(1)] = cljs.core.first((state_35714[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__35723 = state_35714;
state_35714 = G__35723;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto__ = function(state_35714){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto____1.call(this,state_35714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_35720 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_35720[(6)] = c__16469__auto__);

return statearr_35720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_35741){
var state_val_35742 = (state_35741[(1)]);
if((state_val_35742 === (1))){
var inst_35724 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_35741__$1 = state_35741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35741__$1,(2),inst_35724);
} else {
if((state_val_35742 === (2))){
var inst_35727 = (state_35741[(7)]);
var inst_35726 = (state_35741[(2)]);
var inst_35727__$1 = fluree.db.util.async.throw_err(inst_35726);
var inst_35728 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_35727__$1);
var inst_35729 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_35728);
var state_35741__$1 = (function (){var statearr_35743 = state_35741;
(statearr_35743[(7)] = inst_35727__$1);

return statearr_35743;
})();
if(inst_35729){
var statearr_35744_35753 = state_35741__$1;
(statearr_35744_35753[(1)] = (3));

} else {
var statearr_35745_35754 = state_35741__$1;
(statearr_35745_35754[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35742 === (3))){
var inst_35727 = (state_35741[(7)]);
var state_35741__$1 = state_35741;
var statearr_35746_35755 = state_35741__$1;
(statearr_35746_35755[(2)] = inst_35727);

(statearr_35746_35755[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35742 === (4))){
var inst_35727 = (state_35741[(7)]);
var inst_35732 = (function (){var body = inst_35727;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_35733 = cljs.core.second(inst_35727);
var inst_35734 = cljs.core.second(inst_35733);
var inst_35735 = cljs.core.first(inst_35734);
var inst_35736 = cljs.core.second(inst_35735);
var inst_35737 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_35732,inst_35736);
var state_35741__$1 = state_35741;
var statearr_35747_35756 = state_35741__$1;
(statearr_35747_35756[(2)] = inst_35737);

(statearr_35747_35756[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35742 === (5))){
var inst_35739 = (state_35741[(2)]);
var state_35741__$1 = state_35741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35741__$1,inst_35739);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto____0 = (function (){
var statearr_35748 = [null,null,null,null,null,null,null,null];
(statearr_35748[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto__);

(statearr_35748[(1)] = (1));

return statearr_35748;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto____1 = (function (state_35741){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_35741);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e35749){var ex__16398__auto__ = e35749;
var statearr_35750_35757 = state_35741;
(statearr_35750_35757[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_35741[(4)]))){
var statearr_35751_35758 = state_35741;
(statearr_35751_35758[(1)] = cljs.core.first((state_35741[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__35759 = state_35741;
state_35741 = G__35759;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto__ = function(state_35741){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto____1.call(this,state_35741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_35752 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_35752[(6)] = c__16469__auto__);

return statearr_35752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35760_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35760_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35761_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35761_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35762_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__35762_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__35762_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__35762_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_35808){
var state_val_35809 = (state_35808[(1)]);
if((state_val_35809 === (7))){
var inst_35773 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_35808__$1 = state_35808;
var statearr_35810_35838 = state_35808__$1;
(statearr_35810_35838[(2)] = inst_35773);

(statearr_35810_35838[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (1))){
var state_35808__$1 = state_35808;
var statearr_35811_35839 = state_35808__$1;
(statearr_35811_35839[(2)] = null);

(statearr_35811_35839[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (4))){
var inst_35763 = (state_35808[(2)]);
var state_35808__$1 = state_35808;
var statearr_35812_35840 = state_35808__$1;
(statearr_35812_35840[(2)] = inst_35763);

(statearr_35812_35840[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (15))){
var inst_35781 = (state_35808[(7)]);
var inst_35787 = (state_35808[(8)]);
var inst_35782 = (state_35808[(9)]);
var inst_35792 = (state_35808[(2)]);
var inst_35793 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_35787,(0),inst_35792);
var inst_35794 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35795 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_35781);
var inst_35796 = [inst_35782,inst_35795];
var inst_35797 = cljs.core.PersistentHashMap.fromArrays(inst_35794,inst_35796);
var inst_35798 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35793,inst_35797);
var inst_35799 = (function(){throw inst_35798})();
var state_35808__$1 = state_35808;
var statearr_35813_35841 = state_35808__$1;
(statearr_35813_35841[(2)] = inst_35799);

(statearr_35813_35841[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (13))){
var inst_35786 = (state_35808[(10)]);
var state_35808__$1 = state_35808;
var statearr_35814_35842 = state_35808__$1;
(statearr_35814_35842[(2)] = inst_35786);

(statearr_35814_35842[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (6))){
var state_35808__$1 = state_35808;
var statearr_35815_35843 = state_35808__$1;
(statearr_35815_35843[(2)] = null);

(statearr_35815_35843[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (3))){
var inst_35806 = (state_35808[(2)]);
var state_35808__$1 = state_35808;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35808__$1,inst_35806);
} else {
if((state_val_35809 === (12))){
var inst_35803 = (state_35808[(2)]);
var _ = (function (){var statearr_35816 = state_35808;
(statearr_35816[(4)] = cljs.core.rest((state_35808[(4)])));

return statearr_35816;
})();
var state_35808__$1 = state_35808;
var statearr_35817_35844 = state_35808__$1;
(statearr_35817_35844[(2)] = inst_35803);

(statearr_35817_35844[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (2))){
var _ = (function (){var statearr_35818 = state_35808;
(statearr_35818[(4)] = cljs.core.cons((5),(state_35808[(4)])));

return statearr_35818;
})();
var inst_35770 = cljs.core.empty_QMARK_(matching_vars);
var state_35808__$1 = state_35808;
if(inst_35770){
var statearr_35819_35845 = state_35808__$1;
(statearr_35819_35845[(1)] = (6));

} else {
var statearr_35820_35846 = state_35808__$1;
(statearr_35820_35846[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (11))){
var inst_35781 = (state_35808[(7)]);
var inst_35801 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_35781,all_vars);
var state_35808__$1 = state_35808;
var statearr_35822_35847 = state_35808__$1;
(statearr_35822_35847[(2)] = inst_35801);

(statearr_35822_35847[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (9))){
var inst_35781 = (state_35808[(7)]);
var inst_35782 = (state_35808[(9)]);
var inst_35779 = (state_35808[(2)]);
var inst_35780 = fluree.db.util.async.throw_err(inst_35779);
var inst_35781__$1 = cljs.core.__destructure_map(inst_35780);
var inst_35782__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35781__$1,cljs.core.cst$kw$status);
var inst_35783 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35781__$1,cljs.core.cst$kw$message);
var inst_35784 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_35782__$1);
var state_35808__$1 = (function (){var statearr_35823 = state_35808;
(statearr_35823[(7)] = inst_35781__$1);

(statearr_35823[(11)] = inst_35783);

(statearr_35823[(9)] = inst_35782__$1);

return statearr_35823;
})();
if(inst_35784){
var statearr_35824_35848 = state_35808__$1;
(statearr_35824_35848[(1)] = (10));

} else {
var statearr_35825_35849 = state_35808__$1;
(statearr_35825_35849[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (5))){
var _ = (function (){var statearr_35826 = state_35808;
(statearr_35826[(4)] = cljs.core.rest((state_35808[(4)])));

return statearr_35826;
})();
var state_35808__$1 = state_35808;
var ex35821 = (state_35808__$1[(2)]);
var statearr_35827_35850 = state_35808__$1;
(statearr_35827_35850[(5)] = ex35821);


if((ex35821 instanceof Error)){
var statearr_35828_35851 = state_35808__$1;
(statearr_35828_35851[(1)] = (4));

(statearr_35828_35851[(5)] = null);

} else {
throw ex35821;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (14))){
var state_35808__$1 = state_35808;
var statearr_35829_35852 = state_35808__$1;
(statearr_35829_35852[(2)] = (1000));

(statearr_35829_35852[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (10))){
var inst_35781 = (state_35808[(7)]);
var inst_35783 = (state_35808[(11)]);
var inst_35786 = (state_35808[(10)]);
var inst_35786__$1 = cljs.core.count(inst_35783);
var inst_35787 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_35781);
var inst_35788 = (inst_35786__$1 < (1000));
var state_35808__$1 = (function (){var statearr_35830 = state_35808;
(statearr_35830[(8)] = inst_35787);

(statearr_35830[(10)] = inst_35786__$1);

return statearr_35830;
})();
if(cljs.core.truth_(inst_35788)){
var statearr_35831_35853 = state_35808__$1;
(statearr_35831_35853[(1)] = (13));

} else {
var statearr_35832_35854 = state_35808__$1;
(statearr_35832_35854[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35809 === (8))){
var inst_35775 = (state_35808[(2)]);
var inst_35776 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_35775,optional_clauses);
var inst_35777 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_35776);
var state_35808__$1 = state_35808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35808__$1,(9),inst_35777);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto____0 = (function (){
var statearr_35833 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35833[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto__);

(statearr_35833[(1)] = (1));

return statearr_35833;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto____1 = (function (state_35808){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_35808);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e35834){var ex__16398__auto__ = e35834;
var statearr_35835_35855 = state_35808;
(statearr_35835_35855[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_35808[(4)]))){
var statearr_35836_35856 = state_35808;
(statearr_35836_35856[(1)] = cljs.core.first((state_35808[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__35857 = state_35808;
state_35808 = G__35857;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto__ = function(state_35808){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto____1.call(this,state_35808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_35837 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_35837[(6)] = c__16469__auto__);

return statearr_35837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
