// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e35860){var e = e35860;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__35861_SHARP_){
var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__35861_SHARP_);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__35861_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__35861_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__35861_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35862_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35862_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35863_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35863_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4210__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4212__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__35868 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35868,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35868,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35864_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35864_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4210__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4210__auto__;
}
})())){
var vec__35871 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35871,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35871,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4212__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35865_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35865_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35866_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35866_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35867_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35867_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35874_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__35874_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (add_amount > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fuel;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4210__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__35875 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__35875) : intersecting_vars.call(null,G__35875));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__35878,optional_QMARK_,fuel,max_fuel){
var map__35879 = p__35878;
var map__35879__$1 = cljs.core.__destructure_map(map__35879);
var res = map__35879__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35879__$1,cljs.core.cst$kw$vars);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_35945){
var state_val_35946 = (state_35945[(1)]);
if((state_val_35946 === (7))){
var inst_35934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35935 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_35936 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35935,clause);
var inst_35937 = [null,inst_35936];
var inst_35938 = (new cljs.core.PersistentVector(null,2,(5),inst_35934,inst_35937,null));
var state_35945__$1 = state_35945;
var statearr_35947_35975 = state_35945__$1;
(statearr_35947_35975[(2)] = inst_35938);

(statearr_35947_35975[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35946 === (1))){
var state_35945__$1 = state_35945;
var statearr_35948_35976 = state_35945__$1;
(statearr_35948_35976[(2)] = null);

(statearr_35948_35976[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35946 === (4))){
var inst_35880 = (state_35945[(2)]);
var state_35945__$1 = state_35945;
var statearr_35949_35977 = state_35945__$1;
(statearr_35949_35977[(2)] = inst_35880);

(statearr_35949_35977[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35946 === (15))){
var inst_35923 = (state_35945[(2)]);
var inst_35924 = fluree.db.util.async.throw_err(inst_35923);
var inst_35925 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_35924);
var inst_35926 = cljs.core.count(inst_35925);
var inst_35927 = fluree.db.query.analytical.add_fuel(inst_35926,fuel,max_fuel);
var inst_35928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35929 = [inst_35924,r];
var inst_35930 = (new cljs.core.PersistentVector(null,2,(5),inst_35928,inst_35929,null));
var state_35945__$1 = (function (){var statearr_35950 = state_35945;
(statearr_35950[(7)] = inst_35927);

return statearr_35950;
})();
var statearr_35951_35978 = state_35945__$1;
(statearr_35951_35978[(2)] = inst_35930);

(statearr_35951_35978[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35946 === (13))){
var inst_35889 = (state_35945[(8)]);
var inst_35902 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_35903 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_35902);
var inst_35904 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_35889);
var inst_35905 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_35904);
var inst_35906 = cljs.core.set(inst_35905);
var inst_35907 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_35903);
var inst_35908 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_35907);
var inst_35909 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35906,inst_35908);
var inst_35910 = (function (){var all_wd = inst_35889;
var optional = inst_35903;
var all_wd_vars = inst_35906;
var all_vars = inst_35909;
return (function (p1__35876_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__35876_SHARP_) : all_vars.call(null,p1__35876_SHARP_));
});
})();
var inst_35911 = cljs.core.keys(vars);
var inst_35912 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35910,inst_35911);
var inst_35913 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_35912);
var inst_35914 = cljs.core.set(inst_35913);
var inst_35915 = (function (){var all_wd = inst_35889;
var optional = inst_35903;
var all_wd_vars = inst_35906;
var all_vars = inst_35909;
var intersecting_vars = inst_35914;
return (function (p1__35877_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__35877_SHARP_);
});
})();
var inst_35916 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35915,inst_35889);
var inst_35917 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_35916);
var inst_35918 = fluree.db.query.analytical.select_from_tuples(inst_35917,res);
var inst_35919 = fluree.db.query.analytical.replace_vars_wikidata(inst_35889,inst_35914,vars);
var inst_35920 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_35914,inst_35909);
var inst_35921 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_35919,inst_35917,inst_35918,inst_35920,inst_35903);
var state_35945__$1 = state_35945;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35945__$1,(15),inst_35921);
} else {
if((state_val_35946 === (6))){
var inst_35890 = (state_35945[(9)]);
var inst_35888 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_35889 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_35888);
var inst_35890__$1 = optional_QMARK_;
var state_35945__$1 = (function (){var statearr_35952 = state_35945;
(statearr_35952[(8)] = inst_35889);

(statearr_35952[(9)] = inst_35890__$1);

return statearr_35952;
})();
if(cljs.core.truth_(inst_35890__$1)){
var statearr_35953_35979 = state_35945__$1;
(statearr_35953_35979[(1)] = (9));

} else {
var statearr_35954_35980 = state_35945__$1;
(statearr_35954_35980[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35946 === (3))){
var inst_35943 = (state_35945[(2)]);
var state_35945__$1 = state_35945;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35945__$1,inst_35943);
} else {
if((state_val_35946 === (12))){
var inst_35898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35899 = [null,r];
var inst_35900 = (new cljs.core.PersistentVector(null,2,(5),inst_35898,inst_35899,null));
var state_35945__$1 = state_35945;
var statearr_35955_35981 = state_35945__$1;
(statearr_35955_35981[(2)] = inst_35900);

(statearr_35955_35981[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35946 === (2))){
var _ = (function (){var statearr_35956 = state_35945;
(statearr_35956[(4)] = cljs.core.cons((5),(state_35945[(4)])));

return statearr_35956;
})();
var inst_35886 = (r == null);
var state_35945__$1 = state_35945;
if(cljs.core.truth_(inst_35886)){
var statearr_35957_35982 = state_35945__$1;
(statearr_35957_35982[(1)] = (6));

} else {
var statearr_35958_35983 = state_35945__$1;
(statearr_35958_35983[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35946 === (11))){
var inst_35896 = (state_35945[(2)]);
var state_35945__$1 = state_35945;
if(cljs.core.truth_(inst_35896)){
var statearr_35960_35984 = state_35945__$1;
(statearr_35960_35984[(1)] = (12));

} else {
var statearr_35961_35985 = state_35945__$1;
(statearr_35961_35985[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35946 === (9))){
var inst_35889 = (state_35945[(8)]);
var inst_35892 = cljs.core.empty_QMARK_(inst_35889);
var inst_35893 = (!(inst_35892));
var state_35945__$1 = state_35945;
var statearr_35962_35986 = state_35945__$1;
(statearr_35962_35986[(2)] = inst_35893);

(statearr_35962_35986[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35946 === (5))){
var _ = (function (){var statearr_35963 = state_35945;
(statearr_35963[(4)] = cljs.core.rest((state_35945[(4)])));

return statearr_35963;
})();
var state_35945__$1 = state_35945;
var ex35959 = (state_35945__$1[(2)]);
var statearr_35964_35987 = state_35945__$1;
(statearr_35964_35987[(5)] = ex35959);


if((ex35959 instanceof Error)){
var statearr_35965_35988 = state_35945__$1;
(statearr_35965_35988[(1)] = (4));

(statearr_35965_35988[(5)] = null);

} else {
throw ex35959;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35946 === (14))){
var inst_35932 = (state_35945[(2)]);
var state_35945__$1 = state_35945;
var statearr_35966_35989 = state_35945__$1;
(statearr_35966_35989[(2)] = inst_35932);

(statearr_35966_35989[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35946 === (10))){
var inst_35890 = (state_35945[(9)]);
var state_35945__$1 = state_35945;
var statearr_35967_35990 = state_35945__$1;
(statearr_35967_35990[(2)] = inst_35890);

(statearr_35967_35990[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35946 === (8))){
var inst_35940 = (state_35945[(2)]);
var _ = (function (){var statearr_35968 = state_35945;
(statearr_35968[(4)] = cljs.core.rest((state_35945[(4)])));

return statearr_35968;
})();
var state_35945__$1 = state_35945;
var statearr_35969_35991 = state_35945__$1;
(statearr_35969_35991[(2)] = inst_35940);

(statearr_35969_35991[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto____0 = (function (){
var statearr_35970 = [null,null,null,null,null,null,null,null,null,null];
(statearr_35970[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto__);

(statearr_35970[(1)] = (1));

return statearr_35970;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto____1 = (function (state_35945){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_35945);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e35971){var ex__16398__auto__ = e35971;
var statearr_35972_35992 = state_35945;
(statearr_35972_35992[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_35945[(4)]))){
var statearr_35973_35993 = state_35945;
(statearr_35973_35993[(1)] = cljs.core.first((state_35945[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__35994 = state_35945;
state_35945 = G__35994;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto__ = function(state_35945){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto____1.call(this,state_35945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_35974 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_35974[(6)] = c__16469__auto__);

return statearr_35974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__35996 = arguments.length;
switch (G__35996) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_36090){
var state_val_36091 = (state_36090[(1)]);
if((state_val_36091 === (7))){
var inst_36003 = (state_36090[(7)]);
var inst_36013 = clojure.string.starts_with_QMARK_(inst_36003,"$fdb");
var state_36090__$1 = state_36090;
if(inst_36013){
var statearr_36092_36141 = state_36090__$1;
(statearr_36092_36141[(1)] = (9));

} else {
var statearr_36093_36142 = state_36090__$1;
(statearr_36093_36142[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (20))){
var state_36090__$1 = state_36090;
var statearr_36094_36143 = state_36090__$1;
(statearr_36094_36143[(2)] = null);

(statearr_36094_36143[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (27))){
var inst_36053 = (state_36090[(8)]);
var state_36090__$1 = state_36090;
var statearr_36095_36144 = state_36090__$1;
(statearr_36095_36144[(2)] = inst_36053);

(statearr_36095_36144[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (1))){
var state_36090__$1 = state_36090;
var statearr_36096_36145 = state_36090__$1;
(statearr_36096_36145[(2)] = null);

(statearr_36096_36145[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (24))){
var inst_36076 = (state_36090[(2)]);
var state_36090__$1 = state_36090;
var statearr_36097_36146 = state_36090__$1;
(statearr_36097_36146[(2)] = inst_36076);

(statearr_36097_36146[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (4))){
var inst_35997 = (state_36090[(2)]);
var state_36090__$1 = state_36090;
var statearr_36098_36147 = state_36090__$1;
(statearr_36098_36147[(2)] = inst_35997);

(statearr_36098_36147[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (15))){
var inst_36020 = (state_36090[(9)]);
var inst_36026 = (state_36090[(2)]);
var inst_36027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36028 = cljs.core.PersistentVector.EMPTY;
var inst_36029 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_36030 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36028,inst_36029);
var inst_36031 = [inst_36020,inst_36030];
var inst_36032 = (new cljs.core.PersistentVector(null,2,(5),inst_36027,inst_36031,null));
var state_36090__$1 = (function (){var statearr_36099 = state_36090;
(statearr_36099[(10)] = inst_36026);

return statearr_36099;
})();
var statearr_36100_36148 = state_36090__$1;
(statearr_36100_36148[(2)] = inst_36032);

(statearr_36100_36148[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (21))){
var inst_36079 = (state_36090[(2)]);
var state_36090__$1 = state_36090;
var statearr_36101_36149 = state_36090__$1;
(statearr_36101_36149[(2)] = inst_36079);

(statearr_36101_36149[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (13))){
var inst_36020 = (state_36090[(9)]);
var inst_36023 = (function(){throw inst_36020})();
var state_36090__$1 = state_36090;
var statearr_36102_36150 = state_36090__$1;
(statearr_36102_36150[(2)] = inst_36023);

(statearr_36102_36150[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (22))){
var inst_36044 = (state_36090[(11)]);
var inst_36042 = (state_36090[(12)]);
var inst_36046 = fluree.db.query.analytical.parse_block_from_source(inst_36042);
var inst_36047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36048 = [cljs.core.cst$kw$sources,inst_36044];
var inst_36049 = (new cljs.core.PersistentVector(null,2,(5),inst_36047,inst_36048,null));
var inst_36050 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_36049);
var state_36090__$1 = (function (){var statearr_36103 = state_36090;
(statearr_36103[(13)] = inst_36046);

return statearr_36103;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36090__$1,(25),inst_36050);
} else {
if((state_val_36091 === (29))){
var inst_36057 = (state_36090[(2)]);
var inst_36058 = fluree.db.util.async.throw_err(inst_36057);
var state_36090__$1 = state_36090;
var statearr_36104_36151 = state_36090__$1;
(statearr_36104_36151[(2)] = inst_36058);

(statearr_36104_36151[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (6))){
var inst_36006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36007 = cljs.core.PersistentVector.EMPTY;
var inst_36008 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_36009 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36007,inst_36008);
var inst_36010 = [db,inst_36009];
var inst_36011 = (new cljs.core.PersistentVector(null,2,(5),inst_36006,inst_36010,null));
var state_36090__$1 = state_36090;
var statearr_36105_36152 = state_36090__$1;
(statearr_36105_36152[(2)] = inst_36011);

(statearr_36105_36152[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (28))){
var inst_36061 = (state_36090[(2)]);
var inst_36062 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36063 = cljs.core.PersistentVector.EMPTY;
var inst_36064 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_36065 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36063,inst_36064);
var inst_36066 = [inst_36061,inst_36065];
var inst_36067 = (new cljs.core.PersistentVector(null,2,(5),inst_36062,inst_36066,null));
var state_36090__$1 = state_36090;
var statearr_36106_36153 = state_36090__$1;
(statearr_36106_36153[(2)] = inst_36067);

(statearr_36106_36153[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (25))){
var inst_36046 = (state_36090[(13)]);
var inst_36052 = (state_36090[(2)]);
var inst_36053 = fluree.db.util.async.throw_err(inst_36052);
var state_36090__$1 = (function (){var statearr_36107 = state_36090;
(statearr_36107[(8)] = inst_36053);

return statearr_36107;
})();
if(cljs.core.truth_(inst_36046)){
var statearr_36108_36154 = state_36090__$1;
(statearr_36108_36154[(1)] = (26));

} else {
var statearr_36109_36155 = state_36090__$1;
(statearr_36109_36155[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (17))){
var state_36090__$1 = state_36090;
var statearr_36110_36156 = state_36090__$1;
(statearr_36110_36156[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (3))){
var inst_36088 = (state_36090[(2)]);
var state_36090__$1 = state_36090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36090__$1,inst_36088);
} else {
if((state_val_36091 === (12))){
var inst_36020 = (state_36090[(9)]);
var inst_36019 = (state_36090[(2)]);
var inst_36020__$1 = fluree.db.util.async.throw_err(inst_36019);
var inst_36021 = fluree.db.util.core.exception_QMARK_(inst_36020__$1);
var state_36090__$1 = (function (){var statearr_36112 = state_36090;
(statearr_36112[(9)] = inst_36020__$1);

return statearr_36112;
})();
if(inst_36021){
var statearr_36113_36157 = state_36090__$1;
(statearr_36113_36157[(1)] = (13));

} else {
var statearr_36114_36158 = state_36090__$1;
(statearr_36114_36158[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (2))){
var inst_36003 = (state_36090[(7)]);
var _ = (function (){var statearr_36115 = state_36090;
(statearr_36115[(4)] = cljs.core.cons((5),(state_36090[(4)])));

return statearr_36115;
})();
var inst_36003__$1 = cljs.core.first(clause);
var inst_36004 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_36003__$1);
var state_36090__$1 = (function (){var statearr_36116 = state_36090;
(statearr_36116[(7)] = inst_36003__$1);

return statearr_36116;
})();
if(inst_36004){
var statearr_36117_36159 = state_36090__$1;
(statearr_36117_36159[(1)] = (6));

} else {
var statearr_36118_36160 = state_36090__$1;
(statearr_36118_36160[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (23))){
var inst_36003 = (state_36090[(7)]);
var inst_36069 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36003)," is not supported in Fluree"].join('');
var inst_36070 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36071 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36072 = cljs.core.PersistentHashMap.fromArrays(inst_36070,inst_36071);
var inst_36073 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36069,inst_36072);
var inst_36074 = (function(){throw inst_36073})();
var state_36090__$1 = state_36090;
var statearr_36119_36161 = state_36090__$1;
(statearr_36119_36161[(2)] = inst_36074);

(statearr_36119_36161[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (19))){
var inst_36044 = (state_36090[(11)]);
var inst_36003 = (state_36090[(7)]);
var inst_36041 = fluree.db.query.analytical.isolate_source_name(inst_36003);
var inst_36042 = fluree.db.query.analytical.isolate_source_block(inst_36003);
var inst_36043 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_36041);
var inst_36044__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_36043);
var state_36090__$1 = (function (){var statearr_36120 = state_36090;
(statearr_36120[(11)] = inst_36044__$1);

(statearr_36120[(12)] = inst_36042);

return statearr_36120;
})();
if(cljs.core.truth_(inst_36044__$1)){
var statearr_36121_36162 = state_36090__$1;
(statearr_36121_36162[(1)] = (22));

} else {
var statearr_36122_36163 = state_36090__$1;
(statearr_36122_36163[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (11))){
var inst_36083 = (state_36090[(2)]);
var state_36090__$1 = state_36090;
var statearr_36124_36164 = state_36090__$1;
(statearr_36124_36164[(2)] = inst_36083);

(statearr_36124_36164[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (9))){
var inst_36003 = (state_36090[(7)]);
var inst_36015 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_36003,(4));
var inst_36016 = fluree.db.query.analytical.parse_block_from_source(inst_36015);
var inst_36017 = fluree.db.time_travel.as_of_block(db,inst_36016);
var state_36090__$1 = state_36090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36090__$1,(12),inst_36017);
} else {
if((state_val_36091 === (5))){
var _ = (function (){var statearr_36125 = state_36090;
(statearr_36125[(4)] = cljs.core.rest((state_36090[(4)])));

return statearr_36125;
})();
var state_36090__$1 = state_36090;
var ex36123 = (state_36090__$1[(2)]);
var statearr_36126_36165 = state_36090__$1;
(statearr_36126_36165[(5)] = ex36123);


if((ex36123 instanceof Error)){
var statearr_36127_36166 = state_36090__$1;
(statearr_36127_36166[(1)] = (4));

(statearr_36127_36166[(5)] = null);

} else {
throw ex36123;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (14))){
var state_36090__$1 = state_36090;
var statearr_36128_36167 = state_36090__$1;
(statearr_36128_36167[(2)] = null);

(statearr_36128_36167[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (26))){
var inst_36046 = (state_36090[(13)]);
var inst_36053 = (state_36090[(8)]);
var inst_36055 = fluree.db.time_travel.as_of_block(inst_36053,inst_36046);
var state_36090__$1 = state_36090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36090__$1,(29),inst_36055);
} else {
if((state_val_36091 === (16))){
var inst_36036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36037 = ["$wd",clause];
var inst_36038 = (new cljs.core.PersistentVector(null,2,(5),inst_36036,inst_36037,null));
var state_36090__$1 = state_36090;
var statearr_36129_36168 = state_36090__$1;
(statearr_36129_36168[(2)] = inst_36038);

(statearr_36129_36168[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (10))){
var inst_36003 = (state_36090[(7)]);
var inst_36034 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_36003);
var state_36090__$1 = state_36090;
if(inst_36034){
var statearr_36130_36169 = state_36090__$1;
(statearr_36130_36169[(1)] = (16));

} else {
var statearr_36131_36170 = state_36090__$1;
(statearr_36131_36170[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (18))){
var inst_36081 = (state_36090[(2)]);
var state_36090__$1 = state_36090;
var statearr_36132_36171 = state_36090__$1;
(statearr_36132_36171[(2)] = inst_36081);

(statearr_36132_36171[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36091 === (8))){
var inst_36085 = (state_36090[(2)]);
var _ = (function (){var statearr_36133 = state_36090;
(statearr_36133[(4)] = cljs.core.rest((state_36090[(4)])));

return statearr_36133;
})();
var state_36090__$1 = state_36090;
var statearr_36134_36172 = state_36090__$1;
(statearr_36134_36172[(2)] = inst_36085);

(statearr_36134_36172[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16395__auto__ = null;
var fluree$db$query$analytical$state_machine__16395__auto____0 = (function (){
var statearr_36135 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36135[(0)] = fluree$db$query$analytical$state_machine__16395__auto__);

(statearr_36135[(1)] = (1));

return statearr_36135;
});
var fluree$db$query$analytical$state_machine__16395__auto____1 = (function (state_36090){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_36090);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e36136){var ex__16398__auto__ = e36136;
var statearr_36137_36173 = state_36090;
(statearr_36137_36173[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_36090[(4)]))){
var statearr_36138_36174 = state_36090;
(statearr_36138_36174[(1)] = cljs.core.first((state_36090[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__36175 = state_36090;
state_36090 = G__36175;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16395__auto__ = function(state_36090){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16395__auto____1.call(this,state_36090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16395__auto____0;
fluree$db$query$analytical$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16395__auto____1;
return fluree$db$query$analytical$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_36139 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_36139[(6)] = c__16469__auto__);

return statearr_36139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__36176){
var vec__36177 = p__36176;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36177,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36177,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36180_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__36180_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__36184 = subjects;
var vec__36185 = G__36184;
var seq__36186 = cljs.core.seq(vec__36185);
var first__36187 = cljs.core.first(seq__36186);
var seq__36186__$1 = cljs.core.next(seq__36186);
var subject = first__36187;
var r = seq__36186__$1;
var acc = expanded_map;
var G__36184__$1 = G__36184;
var acc__$1 = acc;
while(true){
var vec__36191 = G__36184__$1;
var seq__36192 = cljs.core.seq(vec__36191);
var first__36193 = cljs.core.first(seq__36192);
var seq__36192__$1 = cljs.core.next(seq__36192);
var subject__$1 = first__36193;
var r__$1 = seq__36192__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__36194 = r__$1;
var G__36195 = acc__$2;
G__36184__$1 = G__36194;
acc__$1 = G__36195;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__36184__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__36191,seq__36192,first__36193,seq__36192__$1,subject__$1,r__$1,acc__$2,G__36184,vec__36185,seq__36186,first__36187,seq__36186__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4212__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__36184__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__36191,seq__36192,first__36193,seq__36192__$1,subject__$1,r__$1,acc__$2,G__36184,vec__36185,seq__36186,first__36187,seq__36186__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__36184__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__36191,seq__36192,first__36193,seq__36192__$1,subject__$1,r__$1,acc__$2,G__36184,vec__36185,seq__36186,first__36187,seq__36186__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__36184__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__36191,seq__36192,first__36193,seq__36192__$1,subject__$1,r__$1,acc__$2,G__36184,vec__36185,seq__36186,first__36187,seq__36186__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__36184__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__36191,seq__36192,first__36193,seq__36192__$1,subject__$1,r__$1,acc__$2,G__36184,vec__36185,seq__36186,first__36187,seq__36186__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__36184__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__36191,seq__36192,first__36193,seq__36192__$1,subject__$1,r__$1,acc__$2,G__36184,vec__36185,seq__36186,first__36187,seq__36186__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__36196 = r__$1;
var G__36197 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__36184__$1 = G__36196;
acc__$1 = G__36197;
continue;
} else {
var G__36198 = subjects;
var G__36199 = acc_STAR_;
G__36184__$1 = G__36198;
acc__$1 = G__36199;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36200_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__36200_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_36291){
var state_val_36292 = (state_36291[(1)]);
if((state_val_36292 === (7))){
var state_36291__$1 = state_36291;
var statearr_36293_36339 = state_36291__$1;
(statearr_36293_36339[(2)] = (100));

(statearr_36293_36339[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (20))){
var inst_36240 = (state_36291[(7)]);
var state_36291__$1 = state_36291;
var statearr_36294_36340 = state_36291__$1;
(statearr_36294_36340[(2)] = inst_36240);

(statearr_36294_36340[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (1))){
var state_36291__$1 = state_36291;
var statearr_36295_36341 = state_36291__$1;
(statearr_36295_36341[(2)] = null);

(statearr_36295_36341[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (24))){
var inst_36277 = (state_36291[(8)]);
var inst_36212 = (state_36291[(9)]);
var inst_36278 = (state_36291[(10)]);
var inst_36279 = (state_36291[(11)]);
var inst_36282 = (function (){var max_depth = inst_36212;
var recur_map__$1 = inst_36278;
var subjects = inst_36277;
var tuples = inst_36279;
return (function (p1__36201_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__36201_SHARP_)],null));
});
})();
var inst_36283 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_36282,inst_36279);
var inst_36284 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_36283);
var state_36291__$1 = state_36291;
var statearr_36296_36342 = state_36291__$1;
(statearr_36296_36342[(2)] = inst_36284);

(statearr_36296_36342[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (4))){
var inst_36202 = (state_36291[(2)]);
var state_36291__$1 = state_36291;
var statearr_36297_36343 = state_36291__$1;
(statearr_36297_36343[(2)] = inst_36202);

(statearr_36297_36343[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (15))){
var inst_36225 = (state_36291[(12)]);
var inst_36236 = cljs.core.PersistentVector.EMPTY;
var inst_36237 = cljs.core.seq(inst_36225);
var inst_36238 = cljs.core.first(inst_36237);
var inst_36239 = cljs.core.next(inst_36237);
var inst_36240 = inst_36236;
var inst_36241 = inst_36225;
var state_36291__$1 = (function (){var statearr_36298 = state_36291;
(statearr_36298[(13)] = inst_36241);

(statearr_36298[(14)] = inst_36238);

(statearr_36298[(7)] = inst_36240);

(statearr_36298[(15)] = inst_36239);

return statearr_36298;
})();
var statearr_36299_36344 = state_36291__$1;
(statearr_36299_36344[(2)] = null);

(statearr_36299_36344[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (21))){
var inst_36261 = (state_36291[(2)]);
var state_36291__$1 = state_36291;
var statearr_36300_36345 = state_36291__$1;
(statearr_36300_36345[(2)] = inst_36261);

(statearr_36300_36345[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (13))){
var inst_36274 = (state_36291[(2)]);
var state_36291__$1 = state_36291;
var statearr_36301_36346 = state_36291__$1;
(statearr_36301_36346[(2)] = inst_36274);

(statearr_36301_36346[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (22))){
var inst_36248 = (state_36291[(16)]);
var inst_36240 = (state_36291[(7)]);
var inst_36255 = (state_36291[(2)]);
var inst_36256 = fluree.db.util.async.throw_err(inst_36255);
var inst_36257 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_36240,inst_36256);
var inst_36240__$1 = inst_36257;
var inst_36241 = inst_36248;
var state_36291__$1 = (function (){var statearr_36302 = state_36291;
(statearr_36302[(13)] = inst_36241);

(statearr_36302[(7)] = inst_36240__$1);

return statearr_36302;
})();
var statearr_36303_36347 = state_36291__$1;
(statearr_36303_36347[(2)] = null);

(statearr_36303_36347[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (6))){
var inst_36208 = (state_36291[(17)]);
var state_36291__$1 = state_36291;
var statearr_36304_36348 = state_36291__$1;
(statearr_36304_36348[(2)] = inst_36208);

(statearr_36304_36348[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (25))){
var inst_36286 = (state_36291[(2)]);
var _ = (function (){var statearr_36305 = state_36291;
(statearr_36305[(4)] = cljs.core.rest((state_36291[(4)])));

return statearr_36305;
})();
var state_36291__$1 = state_36291;
var statearr_36306_36349 = state_36291__$1;
(statearr_36306_36349[(2)] = inst_36286);

(statearr_36306_36349[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (17))){
var inst_36247 = (state_36291[(18)]);
var inst_36241 = (state_36291[(13)]);
var inst_36246 = cljs.core.seq(inst_36241);
var inst_36247__$1 = cljs.core.first(inst_36246);
var inst_36248 = cljs.core.next(inst_36246);
var state_36291__$1 = (function (){var statearr_36307 = state_36291;
(statearr_36307[(18)] = inst_36247__$1);

(statearr_36307[(16)] = inst_36248);

return statearr_36307;
})();
if(cljs.core.truth_(inst_36247__$1)){
var statearr_36308_36350 = state_36291__$1;
(statearr_36308_36350[(1)] = (19));

} else {
var statearr_36309_36351 = state_36291__$1;
(statearr_36309_36351[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (3))){
var inst_36289 = (state_36291[(2)]);
var state_36291__$1 = state_36291;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36291__$1,inst_36289);
} else {
if((state_val_36292 === (12))){
var inst_36214 = (state_36291[(19)]);
var inst_36225 = (state_36291[(12)]);
var inst_36220 = cljs.core.vals(inst_36214);
var inst_36221 = cljs.core.flatten(inst_36220);
var inst_36222 = cljs.core.set(inst_36221);
var inst_36223 = cljs.core.keys(inst_36214);
var inst_36224 = cljs.core.set(inst_36223);
var inst_36225__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_36222,inst_36224);
var inst_36226 = cljs.core.empty_QMARK_(inst_36225__$1);
var state_36291__$1 = (function (){var statearr_36310 = state_36291;
(statearr_36310[(12)] = inst_36225__$1);

return statearr_36310;
})();
if(inst_36226){
var statearr_36311_36352 = state_36291__$1;
(statearr_36311_36352[(1)] = (14));

} else {
var statearr_36312_36353 = state_36291__$1;
(statearr_36312_36353[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (2))){
var inst_36208 = (state_36291[(17)]);
var _ = (function (){var statearr_36313 = state_36291;
(statearr_36313[(4)] = cljs.core.cons((5),(state_36291[(4)])));

return statearr_36313;
})();
var inst_36208__$1 = depth;
var state_36291__$1 = (function (){var statearr_36314 = state_36291;
(statearr_36314[(17)] = inst_36208__$1);

return statearr_36314;
})();
if(cljs.core.truth_(inst_36208__$1)){
var statearr_36315_36354 = state_36291__$1;
(statearr_36315_36354[(1)] = (6));

} else {
var statearr_36316_36355 = state_36291__$1;
(statearr_36316_36355[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (23))){
var inst_36279 = (state_36291[(11)]);
var state_36291__$1 = state_36291;
var statearr_36317_36356 = state_36291__$1;
(statearr_36317_36356[(2)] = inst_36279);

(statearr_36317_36356[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (19))){
var inst_36247 = (state_36291[(18)]);
var inst_36250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36251 = [inst_36247,predicate];
var inst_36252 = (new cljs.core.PersistentVector(null,2,(5),inst_36250,inst_36251,null));
var inst_36253 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36252);
var state_36291__$1 = state_36291;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36291__$1,(22),inst_36253);
} else {
if((state_val_36292 === (11))){
var inst_36214 = (state_36291[(19)]);
var state_36291__$1 = state_36291;
var statearr_36319_36357 = state_36291__$1;
(statearr_36319_36357[(2)] = inst_36214);

(statearr_36319_36357[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (9))){
var inst_36215 = (state_36291[(20)]);
var inst_36212 = (state_36291[(9)]);
var inst_36217 = (inst_36215 >= inst_36212);
var state_36291__$1 = state_36291;
if(cljs.core.truth_(inst_36217)){
var statearr_36320_36358 = state_36291__$1;
(statearr_36320_36358[(1)] = (11));

} else {
var statearr_36321_36359 = state_36291__$1;
(statearr_36321_36359[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (5))){
var _ = (function (){var statearr_36322 = state_36291;
(statearr_36322[(4)] = cljs.core.rest((state_36291[(4)])));

return statearr_36322;
})();
var state_36291__$1 = state_36291;
var ex36318 = (state_36291__$1[(2)]);
var statearr_36323_36360 = state_36291__$1;
(statearr_36323_36360[(5)] = ex36318);


if((ex36318 instanceof Error)){
var statearr_36324_36361 = state_36291__$1;
(statearr_36324_36361[(1)] = (4));

(statearr_36324_36361[(5)] = null);

} else {
throw ex36318;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (14))){
var inst_36214 = (state_36291[(19)]);
var state_36291__$1 = state_36291;
var statearr_36325_36362 = state_36291__$1;
(statearr_36325_36362[(2)] = inst_36214);

(statearr_36325_36362[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (16))){
var inst_36272 = (state_36291[(2)]);
var state_36291__$1 = state_36291;
var statearr_36326_36363 = state_36291__$1;
(statearr_36326_36363[(2)] = inst_36272);

(statearr_36326_36363[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (10))){
var inst_36277 = (state_36291[(8)]);
var inst_36278 = (state_36291[(10)]);
var inst_36276 = (state_36291[(2)]);
var inst_36277__$1 = cljs.core.keys(inst_36276);
var inst_36278__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_36277__$1,inst_36276);
var inst_36279 = fluree.db.query.analytical.recur_map__GT_tuples(inst_36277__$1,inst_36278__$1);
var state_36291__$1 = (function (){var statearr_36327 = state_36291;
(statearr_36327[(8)] = inst_36277__$1);

(statearr_36327[(10)] = inst_36278__$1);

(statearr_36327[(11)] = inst_36279);

return statearr_36327;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_36328_36364 = state_36291__$1;
(statearr_36328_36364[(1)] = (23));

} else {
var statearr_36329_36365 = state_36291__$1;
(statearr_36329_36365[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (18))){
var inst_36215 = (state_36291[(20)]);
var inst_36214 = (state_36291[(19)]);
var inst_36263 = (state_36291[(2)]);
var inst_36264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36265 = [(0),(2)];
var inst_36266 = (new cljs.core.PersistentVector(null,2,(5),inst_36264,inst_36265,null));
var inst_36267 = fluree.db.query.analytical.get_ns_arrays(inst_36266,inst_36263);
var inst_36268 = fluree.db.query.analytical.tuples__GT_map(inst_36214,inst_36267);
var inst_36269 = (inst_36215 + (1));
var inst_36214__$1 = inst_36268;
var inst_36215__$1 = inst_36269;
var state_36291__$1 = (function (){var statearr_36330 = state_36291;
(statearr_36330[(20)] = inst_36215__$1);

(statearr_36330[(19)] = inst_36214__$1);

return statearr_36330;
})();
var statearr_36331_36366 = state_36291__$1;
(statearr_36331_36366[(2)] = null);

(statearr_36331_36366[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36292 === (8))){
var inst_36212 = (state_36291[(2)]);
var inst_36213 = recur_map;
var inst_36214 = inst_36213;
var inst_36215 = (1);
var state_36291__$1 = (function (){var statearr_36332 = state_36291;
(statearr_36332[(20)] = inst_36215);

(statearr_36332[(9)] = inst_36212);

(statearr_36332[(19)] = inst_36214);

return statearr_36332;
})();
var statearr_36333_36367 = state_36291__$1;
(statearr_36333_36367[(2)] = null);

(statearr_36333_36367[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto____0 = (function (){
var statearr_36334 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36334[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto__);

(statearr_36334[(1)] = (1));

return statearr_36334;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto____1 = (function (state_36291){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_36291);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e36335){var ex__16398__auto__ = e36335;
var statearr_36336_36368 = state_36291;
(statearr_36336_36368[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_36291[(4)]))){
var statearr_36337_36369 = state_36291;
(statearr_36337_36369[(1)] = cljs.core.first((state_36291[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__36370 = state_36291;
state_36291 = G__36370;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto__ = function(state_36291){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto____1.call(this,state_36291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_36338 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_36338[(6)] = c__16469__auto__);

return statearr_36338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__36371,clause,fuel,max_fuel){
var map__36372 = p__36371;
var map__36372__$1 = cljs.core.__destructure_map(map__36372);
var res = map__36372__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36372__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36372__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36372__$1,cljs.core.cst$kw$vars);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_36483){
var state_val_36484 = (state_36483[(1)]);
if((state_val_36484 === (7))){
var inst_36389 = (state_36483[(7)]);
var state_36483__$1 = state_36483;
var statearr_36485_36538 = state_36483__$1;
(statearr_36485_36538[(2)] = inst_36389);

(statearr_36485_36538[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (20))){
var inst_36417 = (state_36483[(8)]);
var inst_36448 = typeof inst_36417 === 'number';
var state_36483__$1 = state_36483;
if(cljs.core.truth_(inst_36448)){
var statearr_36486_36539 = state_36483__$1;
(statearr_36486_36539[(1)] = (22));

} else {
var statearr_36487_36540 = state_36483__$1;
(statearr_36487_36540[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (27))){
var inst_36463 = (state_36483[(2)]);
var state_36483__$1 = state_36483;
var statearr_36488_36541 = state_36483__$1;
(statearr_36488_36541[(2)] = inst_36463);

(statearr_36488_36541[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (1))){
var state_36483__$1 = state_36483;
var statearr_36489_36542 = state_36483__$1;
(statearr_36489_36542[(2)] = null);

(statearr_36489_36542[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (24))){
var inst_36465 = (state_36483[(2)]);
var state_36483__$1 = state_36483;
var statearr_36490_36543 = state_36483__$1;
(statearr_36490_36543[(2)] = inst_36465);

(statearr_36490_36543[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (4))){
var inst_36373 = (state_36483[(2)]);
var state_36483__$1 = state_36483;
var statearr_36491_36544 = state_36483__$1;
(statearr_36491_36544[(2)] = inst_36373);

(statearr_36491_36544[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (15))){
var inst_36431 = (state_36483[(2)]);
var inst_36432 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_36433 = fluree.db.query.analytical.variable_QMARK_(inst_36432);
var state_36483__$1 = (function (){var statearr_36492 = state_36483;
(statearr_36492[(9)] = inst_36431);

return statearr_36492;
})();
if(cljs.core.truth_(inst_36433)){
var statearr_36493_36545 = state_36483__$1;
(statearr_36493_36545[(1)] = (16));

} else {
var statearr_36494_36546 = state_36483__$1;
(statearr_36494_36546[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (21))){
var inst_36420 = (state_36483[(10)]);
var inst_36390 = (state_36483[(11)]);
var inst_36419 = (state_36483[(12)]);
var inst_36467 = (state_36483[(2)]);
var inst_36468 = fluree.db.query.analytical.tuples__GT_recur(db,inst_36420,inst_36467,inst_36390,inst_36419);
var state_36483__$1 = state_36483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36483__$1,(28),inst_36468);
} else {
if((state_val_36484 === (13))){
var inst_36399 = (state_36483[(13)]);
var inst_36423 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36399)].join('');
var inst_36424 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36425 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36426 = cljs.core.PersistentHashMap.fromArrays(inst_36424,inst_36425);
var inst_36427 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36423,inst_36426);
var inst_36428 = (function(){throw inst_36427})();
var state_36483__$1 = state_36483;
var statearr_36495_36547 = state_36483__$1;
(statearr_36495_36547[(2)] = inst_36428);

(statearr_36495_36547[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (22))){
var inst_36415 = (state_36483[(14)]);
var inst_36417 = (state_36483[(8)]);
var inst_36450 = cljs.core.PersistentHashMap.EMPTY;
var inst_36451 = cljs.core.flatten(inst_36415);
var inst_36452 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36450,inst_36417,inst_36451);
var state_36483__$1 = state_36483;
var statearr_36496_36548 = state_36483__$1;
(statearr_36496_36548[(2)] = inst_36452);

(statearr_36496_36548[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (6))){
var inst_36401 = (state_36483[(15)]);
var state_36483__$1 = state_36483;
var statearr_36497_36549 = state_36483__$1;
(statearr_36497_36549[(2)] = inst_36401);

(statearr_36497_36549[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (28))){
var inst_36470 = (state_36483[(2)]);
var inst_36471 = fluree.db.util.async.throw_err(inst_36470);
var state_36483__$1 = state_36483;
var statearr_36498_36550 = state_36483__$1;
(statearr_36498_36550[(2)] = inst_36471);

(statearr_36498_36550[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (25))){
var inst_36411 = (state_36483[(16)]);
var inst_36415 = (state_36483[(14)]);
var inst_36456 = cljs.core.PersistentHashMap.EMPTY;
var inst_36457 = cljs.core.first(inst_36411);
var inst_36458 = cljs.core.first(inst_36457);
var inst_36459 = cljs.core.flatten(inst_36415);
var inst_36460 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36456,inst_36458,inst_36459);
var state_36483__$1 = state_36483;
var statearr_36499_36551 = state_36483__$1;
(statearr_36499_36551[(2)] = inst_36460);

(statearr_36499_36551[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (17))){
var inst_36399 = (state_36483[(13)]);
var inst_36436 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36399)].join('');
var inst_36437 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36438 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36439 = cljs.core.PersistentHashMap.fromArrays(inst_36437,inst_36438);
var inst_36440 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36436,inst_36439);
var inst_36441 = (function(){throw inst_36440})();
var state_36483__$1 = state_36483;
var statearr_36500_36552 = state_36483__$1;
(statearr_36500_36552[(2)] = inst_36441);

(statearr_36500_36552[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (3))){
var inst_36481 = (state_36483[(2)]);
var state_36483__$1 = state_36483;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36483__$1,inst_36481);
} else {
if((state_val_36484 === (12))){
var inst_36386 = (state_36483[(17)]);
var inst_36474 = (state_36483[(2)]);
var inst_36475 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_36476 = cljs.core.keys(inst_36386);
var inst_36477 = [inst_36476,vars,inst_36474];
var inst_36478 = cljs.core.PersistentHashMap.fromArrays(inst_36475,inst_36477);
var _ = (function (){var statearr_36501 = state_36483;
(statearr_36501[(4)] = cljs.core.rest((state_36483[(4)])));

return statearr_36501;
})();
var state_36483__$1 = state_36483;
var statearr_36502_36553 = state_36483__$1;
(statearr_36502_36553[(2)] = inst_36478);

(statearr_36502_36553[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (2))){
var inst_36390 = (state_36483[(11)]);
var inst_36386 = (state_36483[(17)]);
var inst_36389 = (state_36483[(7)]);
var inst_36401 = (state_36483[(15)]);
var _ = (function (){var statearr_36503 = state_36483;
(statearr_36503[(4)] = cljs.core.cons((5),(state_36483[(4)])));

return statearr_36503;
})();
var inst_36383 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_36384 = cljs.core.__destructure_map(inst_36383);
var inst_36385 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36384,cljs.core.cst$kw$search);
var inst_36386__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36384,cljs.core.cst$kw$rel);
var inst_36387 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36384,cljs.core.cst$kw$opts);
var inst_36388 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_36389__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_36387);
var inst_36390__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_36387);
var inst_36392 = (function (){var map__36379 = inst_36384;
var search = inst_36385;
var rel = inst_36386__$1;
var opts = inst_36387;
var common_keys = inst_36388;
var object_fn = inst_36389__$1;
var recur_depth = inst_36390__$1;
return (function (p__36391,common_key){
var vec__36504 = p__36391;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36504,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36504,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__36507 = cljs.core._EQ_;
var expr__36508 = idx_of;
if(cljs.core.truth_((pred__36507.cljs$core$IFn$_invoke$arity$2 ? pred__36507.cljs$core$IFn$_invoke$arity$2((0),expr__36508) : pred__36507.call(null,(0),expr__36508)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__36507.cljs$core$IFn$_invoke$arity$2 ? pred__36507.cljs$core$IFn$_invoke$arity$2((1),expr__36508) : pred__36507.call(null,(1),expr__36508)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__36507.cljs$core$IFn$_invoke$arity$2 ? pred__36507.cljs$core$IFn$_invoke$arity$2((2),expr__36508) : pred__36507.call(null,(2),expr__36508)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__36508)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4210__auto__ = (!(single_v_QMARK_));
if(and__4210__auto__){
var and__4210__auto____$1 = object_fn;
if(cljs.core.truth_(and__4210__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_36393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36394 = cljs.core.PersistentHashMap.EMPTY;
var inst_36395 = [inst_36394,inst_36385];
var inst_36396 = (new cljs.core.PersistentVector(null,2,(5),inst_36393,inst_36395,null));
var inst_36397 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36392,inst_36396,inst_36388);
var inst_36398 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36397,(0),null);
var inst_36399 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36397,(1),null);
var inst_36400 = [cljs.core.cst$kw$object_DASH_fn];
var inst_36401__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_36398);
var state_36483__$1 = (function (){var statearr_36510 = state_36483;
(statearr_36510[(13)] = inst_36399);

(statearr_36510[(11)] = inst_36390__$1);

(statearr_36510[(18)] = inst_36400);

(statearr_36510[(17)] = inst_36386__$1);

(statearr_36510[(7)] = inst_36389__$1);

(statearr_36510[(15)] = inst_36401__$1);

return statearr_36510;
})();
if(cljs.core.truth_(inst_36401__$1)){
var statearr_36511_36554 = state_36483__$1;
(statearr_36511_36554[(1)] = (6));

} else {
var statearr_36512_36555 = state_36483__$1;
(statearr_36512_36555[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (23))){
var inst_36417 = (state_36483[(8)]);
var inst_36454 = cljs.core.coll_QMARK_(inst_36417);
var state_36483__$1 = state_36483;
if(inst_36454){
var statearr_36513_36556 = state_36483__$1;
(statearr_36513_36556[(1)] = (25));

} else {
var statearr_36514_36557 = state_36483__$1;
(statearr_36514_36557[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (19))){
var inst_36415 = (state_36483[(14)]);
var inst_36445 = cljs.core.PersistentHashMap.EMPTY;
var inst_36446 = fluree.db.query.analytical.tuples__GT_map(inst_36445,inst_36415);
var state_36483__$1 = state_36483;
var statearr_36515_36558 = state_36483__$1;
(statearr_36515_36558[(2)] = inst_36446);

(statearr_36515_36558[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (11))){
var inst_36415 = (state_36483[(14)]);
var state_36483__$1 = state_36483;
var statearr_36517_36559 = state_36483__$1;
(statearr_36517_36559[(2)] = inst_36415);

(statearr_36517_36559[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (9))){
var inst_36411 = (state_36483[(16)]);
var inst_36390 = (state_36483[(11)]);
var inst_36386 = (state_36483[(17)]);
var inst_36410 = (state_36483[(2)]);
var inst_36411__$1 = fluree.db.util.async.throw_err(inst_36410);
var inst_36412 = cljs.core.count(inst_36411__$1);
var inst_36413 = fluree.db.query.analytical.add_fuel(inst_36412,fuel,max_fuel);
var inst_36414 = cljs.core.vals(inst_36386);
var inst_36415 = fluree.db.query.analytical.get_ns_arrays(inst_36414,inst_36411__$1);
var state_36483__$1 = (function (){var statearr_36518 = state_36483;
(statearr_36518[(19)] = inst_36413);

(statearr_36518[(16)] = inst_36411__$1);

(statearr_36518[(14)] = inst_36415);

return statearr_36518;
})();
if(cljs.core.truth_(inst_36390)){
var statearr_36519_36560 = state_36483__$1;
(statearr_36519_36560[(1)] = (10));

} else {
var statearr_36520_36561 = state_36483__$1;
(statearr_36520_36561[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (5))){
var _ = (function (){var statearr_36521 = state_36483;
(statearr_36521[(4)] = cljs.core.rest((state_36483[(4)])));

return statearr_36521;
})();
var state_36483__$1 = state_36483;
var ex36516 = (state_36483__$1[(2)]);
var statearr_36522_36562 = state_36483__$1;
(statearr_36522_36562[(5)] = ex36516);


if((ex36516 instanceof Error)){
var statearr_36523_36563 = state_36483__$1;
(statearr_36523_36563[(1)] = (4));

(statearr_36523_36563[(5)] = null);

} else {
throw ex36516;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (14))){
var state_36483__$1 = state_36483;
var statearr_36524_36564 = state_36483__$1;
(statearr_36524_36564[(2)] = null);

(statearr_36524_36564[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (26))){
var state_36483__$1 = state_36483;
var statearr_36525_36565 = state_36483__$1;
(statearr_36525_36565[(2)] = null);

(statearr_36525_36565[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (16))){
var state_36483__$1 = state_36483;
var statearr_36526_36566 = state_36483__$1;
(statearr_36526_36566[(2)] = null);

(statearr_36526_36566[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (10))){
var inst_36399 = (state_36483[(13)]);
var inst_36420 = (state_36483[(10)]);
var inst_36417 = cljs.core.first(inst_36399);
var inst_36418 = cljs.core.first(clause);
var inst_36419 = fluree.db.query.analytical.variable_QMARK_(inst_36418);
var inst_36420__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_36399,(1));
var inst_36421 = fluree.db.query.analytical.variable_QMARK_(inst_36420__$1);
var state_36483__$1 = (function (){var statearr_36527 = state_36483;
(statearr_36527[(10)] = inst_36420__$1);

(statearr_36527[(12)] = inst_36419);

(statearr_36527[(8)] = inst_36417);

return statearr_36527;
})();
if(cljs.core.truth_(inst_36421)){
var statearr_36528_36567 = state_36483__$1;
(statearr_36528_36567[(1)] = (13));

} else {
var statearr_36529_36568 = state_36483__$1;
(statearr_36529_36568[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (18))){
var inst_36419 = (state_36483[(12)]);
var inst_36443 = (state_36483[(2)]);
var state_36483__$1 = (function (){var statearr_36530 = state_36483;
(statearr_36530[(20)] = inst_36443);

return statearr_36530;
})();
if(cljs.core.truth_(inst_36419)){
var statearr_36531_36569 = state_36483__$1;
(statearr_36531_36569[(1)] = (19));

} else {
var statearr_36532_36570 = state_36483__$1;
(statearr_36532_36570[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36484 === (8))){
var inst_36399 = (state_36483[(13)]);
var inst_36400 = (state_36483[(18)]);
var inst_36405 = (state_36483[(2)]);
var inst_36406 = [inst_36405];
var inst_36407 = cljs.core.PersistentHashMap.fromArrays(inst_36400,inst_36406);
var inst_36408 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_36399,inst_36407);
var state_36483__$1 = state_36483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36483__$1,(9),inst_36408);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto____0 = (function (){
var statearr_36533 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36533[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto__);

(statearr_36533[(1)] = (1));

return statearr_36533;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto____1 = (function (state_36483){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_36483);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e36534){var ex__16398__auto__ = e36534;
var statearr_36535_36571 = state_36483;
(statearr_36535_36571[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_36483[(4)]))){
var statearr_36536_36572 = state_36483;
(statearr_36536_36572[(1)] = cljs.core.first((state_36483[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__36573 = state_36483;
state_36483 = G__36573;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto__ = function(state_36483){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto____1.call(this,state_36483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_36537 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_36537[(6)] = c__16469__auto__);

return statearr_36537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__36574,res,clause){
var map__36575 = p__36574;
var map__36575__$1 = cljs.core.__destructure_map(map__36575);
var db = map__36575__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36575__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36575__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36575__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_36674){
var state_val_36675 = (state_36674[(1)]);
if((state_val_36675 === (7))){
var inst_36585 = (state_36674[(7)]);
var state_36674__$1 = state_36674;
var statearr_36676_36716 = state_36674__$1;
(statearr_36676_36716[(2)] = inst_36585);

(statearr_36676_36716[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (20))){
var inst_36665 = (state_36674[(2)]);
var state_36674__$1 = state_36674;
var statearr_36677_36717 = state_36674__$1;
(statearr_36677_36717[(2)] = inst_36665);

(statearr_36677_36717[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (1))){
var state_36674__$1 = state_36674;
var statearr_36678_36718 = state_36674__$1;
(statearr_36678_36718[(2)] = null);

(statearr_36678_36718[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (24))){
var inst_36644 = (state_36674[(2)]);
var inst_36645 = fluree.db.util.async.throw_err(inst_36644);
var state_36674__$1 = state_36674;
var statearr_36679_36719 = state_36674__$1;
(statearr_36679_36719[(2)] = inst_36645);

(statearr_36679_36719[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (4))){
var inst_36578 = (state_36674[(2)]);
var state_36674__$1 = state_36674;
var statearr_36680_36720 = state_36674__$1;
(statearr_36680_36720[(2)] = inst_36578);

(statearr_36680_36720[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (15))){
var inst_36585 = (state_36674[(7)]);
var inst_36587 = (state_36674[(8)]);
var inst_36606 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_36607 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_36608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36609 = [inst_36585];
var inst_36610 = (new cljs.core.PersistentVector(null,1,(5),inst_36608,inst_36609,null));
var inst_36611 = (function (){var subject_var = inst_36585;
var object_var = inst_36587;
var min_sid = inst_36606;
var max_sid = (0);
return (function (p1__36576_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__36576_SHARP_);
});
})();
var inst_36612 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_36606,(0));
var inst_36613 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_36611,inst_36612);
var inst_36614 = cljs.core.PersistentHashMap.EMPTY;
var inst_36615 = [inst_36610,inst_36613,inst_36614];
var inst_36616 = cljs.core.PersistentHashMap.fromArrays(inst_36607,inst_36615);
var state_36674__$1 = state_36674;
var statearr_36681_36721 = state_36674__$1;
(statearr_36681_36721[(2)] = inst_36616);

(statearr_36681_36721[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (21))){
var inst_36638 = (state_36674[(9)]);
var state_36674__$1 = state_36674;
var statearr_36682_36722 = state_36674__$1;
(statearr_36682_36722[(2)] = inst_36638);

(statearr_36682_36722[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (13))){
var inst_36587 = (state_36674[(8)]);
var state_36674__$1 = state_36674;
if(cljs.core.truth_(inst_36587)){
var statearr_36683_36723 = state_36674__$1;
(statearr_36683_36723[(1)] = (18));

} else {
var statearr_36684_36724 = state_36674__$1;
(statearr_36684_36724[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (22))){
var inst_36638 = (state_36674[(9)]);
var inst_36642 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_36638);
var state_36674__$1 = state_36674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36674__$1,(24),inst_36642);
} else {
if((state_val_36675 === (6))){
var inst_36587 = (state_36674[(8)]);
var state_36674__$1 = state_36674;
var statearr_36685_36725 = state_36674__$1;
(statearr_36685_36725[(2)] = inst_36587);

(statearr_36685_36725[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (17))){
var inst_36635 = (state_36674[(2)]);
var state_36674__$1 = state_36674;
var statearr_36686_36726 = state_36674__$1;
(statearr_36686_36726[(2)] = inst_36635);

(statearr_36686_36726[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (3))){
var inst_36672 = (state_36674[(2)]);
var state_36674__$1 = state_36674;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36674__$1,inst_36672);
} else {
if((state_val_36675 === (12))){
var inst_36600 = ["_tx",null,"_block",null];
var inst_36601 = (new cljs.core.PersistentArrayMap(null,2,inst_36600,null));
var inst_36602 = (new cljs.core.PersistentHashSet(null,inst_36601,null));
var inst_36603 = cljs.core.last(clause);
var inst_36604 = (inst_36602.cljs$core$IFn$_invoke$arity$1 ? inst_36602.cljs$core$IFn$_invoke$arity$1(inst_36603) : inst_36602.call(null,inst_36603));
var state_36674__$1 = state_36674;
if(cljs.core.truth_(inst_36604)){
var statearr_36687_36727 = state_36674__$1;
(statearr_36687_36727[(1)] = (15));

} else {
var statearr_36688_36728 = state_36674__$1;
(statearr_36688_36728[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (2))){
var inst_36585 = (state_36674[(7)]);
var _ = (function (){var statearr_36689 = state_36674;
(statearr_36689[(4)] = cljs.core.cons((5),(state_36674[(4)])));

return statearr_36689;
})();
var inst_36584 = cljs.core.first(clause);
var inst_36585__$1 = fluree.db.query.analytical.variable_QMARK_(inst_36584);
var inst_36586 = cljs.core.last(clause);
var inst_36587 = fluree.db.query.analytical.variable_QMARK_(inst_36586);
var state_36674__$1 = (function (){var statearr_36690 = state_36674;
(statearr_36690[(7)] = inst_36585__$1);

(statearr_36690[(8)] = inst_36587);

return statearr_36690;
})();
if(cljs.core.truth_(inst_36585__$1)){
var statearr_36691_36729 = state_36674__$1;
(statearr_36691_36729[(1)] = (6));

} else {
var statearr_36692_36730 = state_36674__$1;
(statearr_36692_36730[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (23))){
var inst_36587 = (state_36674[(8)]);
var inst_36647 = (state_36674[(2)]);
var inst_36648 = fluree.db.flake.sid__GT_cid(inst_36647);
var inst_36649 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_36648);
var inst_36650 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_36651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36652 = [inst_36587];
var inst_36653 = (new cljs.core.PersistentVector(null,1,(5),inst_36651,inst_36652,null));
var inst_36654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36656 = [inst_36649];
var inst_36657 = (new cljs.core.PersistentVector(null,1,(5),inst_36655,inst_36656,null));
var inst_36658 = [inst_36657];
var inst_36659 = (new cljs.core.PersistentVector(null,1,(5),inst_36654,inst_36658,null));
var inst_36660 = cljs.core.PersistentHashMap.EMPTY;
var inst_36661 = [inst_36653,inst_36659,inst_36660];
var inst_36662 = cljs.core.PersistentHashMap.fromArrays(inst_36650,inst_36661);
var state_36674__$1 = state_36674;
var statearr_36693_36731 = state_36674__$1;
(statearr_36693_36731[(2)] = inst_36662);

(statearr_36693_36731[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (19))){
var state_36674__$1 = state_36674;
var statearr_36694_36732 = state_36674__$1;
(statearr_36694_36732[(2)] = null);

(statearr_36694_36732[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (11))){
var inst_36669 = (state_36674[(2)]);
var _ = (function (){var statearr_36696 = state_36674;
(statearr_36696[(4)] = cljs.core.rest((state_36674[(4)])));

return statearr_36696;
})();
var state_36674__$1 = state_36674;
var statearr_36697_36733 = state_36674__$1;
(statearr_36697_36733[(2)] = inst_36669);

(statearr_36697_36733[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (9))){
var inst_36593 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36594 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36595 = cljs.core.PersistentHashMap.fromArrays(inst_36593,inst_36594);
var inst_36596 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_36595);
var inst_36597 = (function(){throw inst_36596})();
var state_36674__$1 = state_36674;
var statearr_36698_36734 = state_36674__$1;
(statearr_36698_36734[(2)] = inst_36597);

(statearr_36698_36734[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (5))){
var _ = (function (){var statearr_36699 = state_36674;
(statearr_36699[(4)] = cljs.core.rest((state_36674[(4)])));

return statearr_36699;
})();
var state_36674__$1 = state_36674;
var ex36695 = (state_36674__$1[(2)]);
var statearr_36700_36735 = state_36674__$1;
(statearr_36700_36735[(5)] = ex36695);


if((ex36695 instanceof Error)){
var statearr_36701_36736 = state_36674__$1;
(statearr_36701_36736[(1)] = (4));

(statearr_36701_36736[(5)] = null);

} else {
throw ex36695;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (14))){
var inst_36667 = (state_36674[(2)]);
var state_36674__$1 = state_36674;
var statearr_36702_36737 = state_36674__$1;
(statearr_36702_36737[(2)] = inst_36667);

(statearr_36702_36737[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (16))){
var inst_36585 = (state_36674[(7)]);
var inst_36587 = (state_36674[(8)]);
var inst_36618 = cljs.core.last(clause);
var inst_36619 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,inst_36618);
var inst_36620 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_36621 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36620,inst_36619);
var inst_36622 = fluree.db.flake.min_subject_id(inst_36619);
var inst_36623 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_36624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36625 = [inst_36585];
var inst_36626 = (new cljs.core.PersistentVector(null,1,(5),inst_36624,inst_36625,null));
var inst_36627 = (function (){var subject_var = inst_36585;
var object_var = inst_36587;
var partition = inst_36619;
var max_sid = inst_36621;
var min_sid = inst_36622;
return (function (p1__36577_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__36577_SHARP_);
});
})();
var inst_36628 = (inst_36621 + (1));
var inst_36629 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_36622,inst_36628);
var inst_36630 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_36627,inst_36629);
var inst_36631 = cljs.core.PersistentHashMap.EMPTY;
var inst_36632 = [inst_36626,inst_36630,inst_36631];
var inst_36633 = cljs.core.PersistentHashMap.fromArrays(inst_36623,inst_36632);
var state_36674__$1 = state_36674;
var statearr_36703_36738 = state_36674__$1;
(statearr_36703_36738[(2)] = inst_36633);

(statearr_36703_36738[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (10))){
var inst_36585 = (state_36674[(7)]);
var state_36674__$1 = state_36674;
if(cljs.core.truth_(inst_36585)){
var statearr_36704_36739 = state_36674__$1;
(statearr_36704_36739[(1)] = (12));

} else {
var statearr_36705_36740 = state_36674__$1;
(statearr_36705_36740[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (18))){
var inst_36638 = (state_36674[(9)]);
var inst_36638__$1 = cljs.core.first(clause);
var inst_36639 = typeof inst_36638__$1 === 'number';
var state_36674__$1 = (function (){var statearr_36706 = state_36674;
(statearr_36706[(9)] = inst_36638__$1);

return statearr_36706;
})();
if(cljs.core.truth_(inst_36639)){
var statearr_36707_36741 = state_36674__$1;
(statearr_36707_36741[(1)] = (21));

} else {
var statearr_36708_36742 = state_36674__$1;
(statearr_36708_36742[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36675 === (8))){
var inst_36591 = (state_36674[(2)]);
var state_36674__$1 = state_36674;
if(cljs.core.truth_(inst_36591)){
var statearr_36709_36743 = state_36674__$1;
(statearr_36709_36743[(1)] = (9));

} else {
var statearr_36710_36744 = state_36674__$1;
(statearr_36710_36744[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto____0 = (function (){
var statearr_36711 = [null,null,null,null,null,null,null,null,null,null];
(statearr_36711[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto__);

(statearr_36711[(1)] = (1));

return statearr_36711;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto____1 = (function (state_36674){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_36674);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e36712){var ex__16398__auto__ = e36712;
var statearr_36713_36745 = state_36674;
(statearr_36713_36745[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_36674[(4)]))){
var statearr_36714_36746 = state_36674;
(statearr_36714_36746[(1)] = cljs.core.first((state_36674[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__36747 = state_36674;
state_36674 = G__36747;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto__ = function(state_36674){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto____1.call(this,state_36674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_36715 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_36715[(6)] = c__16469__auto__);

return statearr_36715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__36754 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__36754 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__36754;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4611__auto__ = (function fluree$db$query$analytical$variance_$_iter__36755(s__36756){
return (new cljs.core.LazySeq(null,(function (){
var s__36756__$1 = s__36756;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__36756__$1);
if(temp__5753__auto__){
var s__36756__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36756__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__36756__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__36758 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__36757 = (0);
while(true){
if((i__36757 < size__4610__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__36757);
var delta = (x - mean);
cljs.core.chunk_append(b__36758,(delta * delta));

var G__36760 = (i__36757 + (1));
i__36757 = G__36760;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36758),fluree$db$query$analytical$variance_$_iter__36755(cljs.core.chunk_rest(s__36756__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36758),null);
}
} else {
var x = cljs.core.first(s__36756__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__36755(cljs.core.rest(s__36756__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__36759 = variance(coll);
return Math.sqrt(G__36759);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4295__auto__ = n;
var y__4296__auto__ = (- n);
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
}),(function() {
var G__36761 = null;
var G__36761__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__36761__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__36761 = function(n,coll){
switch(arguments.length){
case 1:
return G__36761__1.call(this,n);
case 2:
return G__36761__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36761.cljs$core$IFn$_invoke$arity$1 = G__36761__1;
G__36761.cljs$core$IFn$_invoke$arity$2 = G__36761__2;
return G__36761;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__36762 = null;
var G__36762__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__36762__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__36762 = function(n,coll){
switch(arguments.length){
case 1:
return G__36762__1.call(this,n);
case 2:
return G__36762__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36762.cljs$core$IFn$_invoke$arity$1 = G__36762__1;
G__36762.cljs$core$IFn$_invoke$arity$2 = G__36762__2;
return G__36762;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__36763 = null;
var G__36763__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__36763__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__36763 = function(n,coll){
switch(arguments.length){
case 1:
return G__36763__1.call(this,n);
case 2:
return G__36763__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36763.cljs$core$IFn$_invoke$arity$1 = G__36763__1;
G__36763.cljs$core$IFn$_invoke$arity$2 = G__36763__2;
return G__36763;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__36764 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36764,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36764,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36764,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__36767 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__36770 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__36770) : agg_fn.call(null,G__36770));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36767,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36767,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__36771 = agg;
var map__36771__$1 = cljs.core.__destructure_map(map__36771);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36771__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36771__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36771__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__36773 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36773,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36773,(1),null);
var map__36776 = res__$1;
var map__36776__$1 = cljs.core.__destructure_map(map__36776);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36776__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36776__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36772_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__36772_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36777_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__36777_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36778_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__36778_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__36779_SHARP_,p2__36780_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__36779_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__36780_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36781_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__36781_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__36784,row,b_tuple){
var vec__36785 = p__36784;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36785,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36785,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36782_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__36782_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = acc;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36783_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__36783_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36788_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__36788_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36789_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__36789_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__36794 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__36796 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__36795 = (function (p1__36790_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__36790_SHARP_);
});
return fexpr__36795(G__36796);
})()),cljs.core.set(b_idxs));
var fexpr__36793 = (function (p1__36791_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__36791_SHARP_);
});
return fexpr__36793(G__36794);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36792_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__36792_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36797_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__36797_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36798_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__36798_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__36803 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__36805 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__36804 = (function (p1__36799_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__36799_SHARP_);
});
return fexpr__36804(G__36805);
})()),cljs.core.set(b_idxs));
var fexpr__36802 = (function (p1__36800_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__36800_SHARP_);
});
return fexpr__36802(G__36803);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36801_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__36801_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__36807 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36807,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36807,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__36806_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__36806_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__36812 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36812,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36812,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36810_SHARP_){
return fluree.db.util.core.index_of(headers,p1__36810_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__36811_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__36811_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__36815,filters,optional_QMARK_){
var map__36816 = p__36815;
var map__36816__$1 = cljs.core.__destructure_map(map__36816);
var tuple_map = map__36816__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36816__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36816__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36816__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__36817 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36817,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36817,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__36820 = res;
var map__36820__$1 = cljs.core.__destructure_map(map__36820);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36820__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36820__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_36876){
var state_val_36877 = (state_36876[(1)]);
if((state_val_36877 === (7))){
var inst_36850 = (state_36876[(7)]);
var inst_36848 = (state_36876[(2)]);
var inst_36849 = fluree.db.util.async.throw_err(inst_36848);
var inst_36850__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36849,(0),null);
var inst_36851 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36849,(1),null);
var inst_36852 = (inst_36850__$1 == null);
var state_36876__$1 = (function (){var statearr_36878 = state_36876;
(statearr_36878[(8)] = inst_36851);

(statearr_36878[(7)] = inst_36850__$1);

return statearr_36878;
})();
if(cljs.core.truth_(inst_36852)){
var statearr_36879_36908 = state_36876__$1;
(statearr_36879_36908[(1)] = (8));

} else {
var statearr_36880_36909 = state_36876__$1;
(statearr_36880_36909[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (1))){
var inst_36828 = optional_clauses;
var inst_36829 = cljs.core.seq(inst_36828);
var inst_36830 = cljs.core.first(inst_36829);
var inst_36831 = cljs.core.next(inst_36829);
var inst_36832 = where_tuples;
var inst_36833 = inst_36828;
var inst_36834 = inst_36832;
var state_36876__$1 = (function (){var statearr_36881 = state_36876;
(statearr_36881[(9)] = inst_36833);

(statearr_36881[(10)] = inst_36830);

(statearr_36881[(11)] = inst_36831);

(statearr_36881[(12)] = inst_36834);

return statearr_36881;
})();
var statearr_36882_36910 = state_36876__$1;
(statearr_36882_36910[(2)] = null);

(statearr_36882_36910[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (4))){
var inst_36840 = (state_36876[(13)]);
var inst_36841 = (state_36876[(14)]);
var inst_36834 = (state_36876[(12)]);
var inst_36846 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_36834,inst_36840,inst_36841,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_36834,inst_36840,inst_36841,true,fuel,max_fuel,opts));
var state_36876__$1 = state_36876;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36876__$1,(7),inst_36846);
} else {
if((state_val_36877 === (15))){
var state_36876__$1 = state_36876;
var statearr_36883_36911 = state_36876__$1;
(statearr_36883_36911[(2)] = null);

(statearr_36883_36911[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (13))){
var inst_36867 = (state_36876[(2)]);
var state_36876__$1 = state_36876;
var statearr_36884_36912 = state_36876__$1;
(statearr_36884_36912[(2)] = inst_36867);

(statearr_36884_36912[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (6))){
var inst_36872 = (state_36876[(2)]);
var state_36876__$1 = state_36876;
var statearr_36885_36913 = state_36876__$1;
(statearr_36885_36913[(2)] = inst_36872);

(statearr_36885_36913[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (3))){
var inst_36874 = (state_36876[(2)]);
var state_36876__$1 = state_36876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36876__$1,inst_36874);
} else {
if((state_val_36877 === (12))){
var state_36876__$1 = state_36876;
var statearr_36886_36914 = state_36876__$1;
(statearr_36886_36914[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (2))){
var inst_36833 = (state_36876[(9)]);
var inst_36840 = (state_36876[(13)]);
var inst_36839 = cljs.core.seq(inst_36833);
var inst_36840__$1 = cljs.core.first(inst_36839);
var inst_36841 = cljs.core.next(inst_36839);
var state_36876__$1 = (function (){var statearr_36888 = state_36876;
(statearr_36888[(13)] = inst_36840__$1);

(statearr_36888[(14)] = inst_36841);

return statearr_36888;
})();
if(cljs.core.truth_(inst_36840__$1)){
var statearr_36889_36915 = state_36876__$1;
(statearr_36889_36915[(1)] = (4));

} else {
var statearr_36890_36916 = state_36876__$1;
(statearr_36890_36916[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (11))){
var inst_36851 = (state_36876[(8)]);
var inst_36850 = (state_36876[(7)]);
var inst_36833 = inst_36851;
var inst_36834 = inst_36850;
var state_36876__$1 = (function (){var statearr_36891 = state_36876;
(statearr_36891[(9)] = inst_36833);

(statearr_36891[(12)] = inst_36834);

return statearr_36891;
})();
var statearr_36892_36917 = state_36876__$1;
(statearr_36892_36917[(2)] = null);

(statearr_36892_36917[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (9))){
var inst_36840 = (state_36876[(13)]);
var inst_36856 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_36840);
var state_36876__$1 = state_36876;
if(cljs.core.truth_(inst_36856)){
var statearr_36893_36918 = state_36876__$1;
(statearr_36893_36918[(1)] = (11));

} else {
var statearr_36894_36919 = state_36876__$1;
(statearr_36894_36919[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (5))){
var inst_36834 = (state_36876[(12)]);
var state_36876__$1 = state_36876;
var statearr_36895_36920 = state_36876__$1;
(statearr_36895_36920[(2)] = inst_36834);

(statearr_36895_36920[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (14))){
var inst_36851 = (state_36876[(8)]);
var inst_36850 = (state_36876[(7)]);
var inst_36834 = (state_36876[(12)]);
var inst_36861 = fluree.db.query.analytical.left_outer_join(inst_36834,inst_36850);
var inst_36833 = inst_36851;
var inst_36834__$1 = inst_36861;
var state_36876__$1 = (function (){var statearr_36896 = state_36876;
(statearr_36896[(9)] = inst_36833);

(statearr_36896[(12)] = inst_36834__$1);

return statearr_36896;
})();
var statearr_36897_36921 = state_36876__$1;
(statearr_36897_36921[(2)] = null);

(statearr_36897_36921[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (16))){
var inst_36865 = (state_36876[(2)]);
var state_36876__$1 = state_36876;
var statearr_36899_36922 = state_36876__$1;
(statearr_36899_36922[(2)] = inst_36865);

(statearr_36899_36922[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (10))){
var inst_36869 = (state_36876[(2)]);
var state_36876__$1 = state_36876;
var statearr_36900_36923 = state_36876__$1;
(statearr_36900_36923[(2)] = inst_36869);

(statearr_36900_36923[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (8))){
var inst_36851 = (state_36876[(8)]);
var inst_36834 = (state_36876[(12)]);
var tmp36898 = inst_36834;
var inst_36833 = inst_36851;
var inst_36834__$1 = tmp36898;
var state_36876__$1 = (function (){var statearr_36901 = state_36876;
(statearr_36901[(9)] = inst_36833);

(statearr_36901[(12)] = inst_36834__$1);

return statearr_36901;
})();
var statearr_36902_36924 = state_36876__$1;
(statearr_36902_36924[(2)] = null);

(statearr_36902_36924[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto____0 = (function (){
var statearr_36903 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36903[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto__);

(statearr_36903[(1)] = (1));

return statearr_36903;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto____1 = (function (state_36876){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_36876);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e36904){var ex__16398__auto__ = e36904;
var statearr_36905_36925 = state_36876;
(statearr_36905_36925[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_36876[(4)]))){
var statearr_36906_36926 = state_36876;
(statearr_36906_36926[(1)] = cljs.core.first((state_36876[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__36927 = state_36876;
state_36876 = G__36927;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto__ = function(state_36876){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto____1.call(this,state_36876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_36907 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_36907[(6)] = c__16469__auto__);

return statearr_36907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__36929){
var vec__36930 = p__36929;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36930,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36930,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36928_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__36928_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__36934,p__36935,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__36936 = p__36934;
var map__36936__$1 = cljs.core.__destructure_map(map__36936);
var q_map = map__36936__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36936__$1,cljs.core.cst$kw$prefixes);
var map__36937 = p__36935;
var map__36937__$1 = cljs.core.__destructure_map(map__36937);
var res = map__36937__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36937__$1,cljs.core.cst$kw$vars);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_37174){
var state_val_37175 = (state_37174[(1)]);
if((state_val_37175 === (65))){
var inst_37123 = (state_37174[(7)]);
var inst_37124 = (state_37174[(8)]);
var inst_37135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37136 = fluree.db.query.analytical.full_text__GT_tuples(inst_37123,res,inst_37124);
var inst_37137 = [inst_37136,r];
var inst_37138 = (new cljs.core.PersistentVector(null,2,(5),inst_37135,inst_37137,null));
var state_37174__$1 = state_37174;
var statearr_37176_37289 = state_37174__$1;
(statearr_37176_37289[(2)] = inst_37138);

(statearr_37176_37289[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (70))){
var inst_37150 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37177_37290 = state_37174__$1;
(statearr_37177_37290[(2)] = inst_37150);

(statearr_37177_37290[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (62))){
var inst_37124 = (state_37174[(8)]);
var inst_37132 = cljs.core.second(inst_37124);
var inst_37133 = clojure.string.starts_with_QMARK_(inst_37132,"fullText:");
var state_37174__$1 = state_37174;
if(inst_37133){
var statearr_37178_37291 = state_37174__$1;
(statearr_37178_37291[(1)] = (65));

} else {
var statearr_37179_37292 = state_37174__$1;
(statearr_37179_37292[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (7))){
var inst_37043 = (state_37174[(9)]);
var inst_37042 = cljs.core.count(clause);
var inst_37043__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_37042);
var state_37174__$1 = (function (){var statearr_37180 = state_37174;
(statearr_37180[(9)] = inst_37043__$1);

return statearr_37180;
})();
if(inst_37043__$1){
var statearr_37181_37293 = state_37174__$1;
(statearr_37181_37293[(1)] = (31));

} else {
var statearr_37182_37294 = state_37174__$1;
(statearr_37182_37294[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (59))){
var inst_37157 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37183_37295 = state_37174__$1;
(statearr_37183_37295[(2)] = inst_37157);

(statearr_37183_37295[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (20))){
var inst_37006 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37184_37296 = state_37174__$1;
(statearr_37184_37296[(2)] = inst_37006);

(statearr_37184_37296[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (58))){
var state_37174__$1 = state_37174;
var statearr_37185_37297 = state_37174__$1;
(statearr_37185_37297[(2)] = null);

(statearr_37185_37297[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (60))){
var inst_37123 = (state_37174[(7)]);
var inst_37121 = (state_37174[(2)]);
var inst_37122 = fluree.db.util.async.throw_err(inst_37121);
var inst_37123__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37122,(0),null);
var inst_37124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37122,(1),null);
var inst_37125 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_37123__$1);
var state_37174__$1 = (function (){var statearr_37186 = state_37174;
(statearr_37186[(7)] = inst_37123__$1);

(statearr_37186[(8)] = inst_37124);

return statearr_37186;
})();
if(inst_37125){
var statearr_37187_37298 = state_37174__$1;
(statearr_37187_37298[(1)] = (61));

} else {
var statearr_37188_37299 = state_37174__$1;
(statearr_37188_37299[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (27))){
var inst_37036 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37189_37300 = state_37174__$1;
(statearr_37189_37300[(2)] = inst_37036);

(statearr_37189_37300[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (1))){
var state_37174__$1 = state_37174;
var statearr_37190_37301 = state_37174__$1;
(statearr_37190_37301[(2)] = null);

(statearr_37190_37301[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (69))){
var state_37174__$1 = state_37174;
var statearr_37191_37302 = state_37174__$1;
(statearr_37191_37302[(2)] = null);

(statearr_37191_37302[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (24))){
var inst_37000 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37192_37303 = state_37174__$1;
(statearr_37192_37303[(2)] = inst_37000);

(statearr_37192_37303[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (55))){
var inst_37106 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_37107 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37108 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_37109 = cljs.core.PersistentHashMap.fromArrays(inst_37107,inst_37108);
var inst_37110 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37106,inst_37109);
var inst_37111 = (function(){throw inst_37110})();
var state_37174__$1 = state_37174;
var statearr_37193_37304 = state_37174__$1;
(statearr_37193_37304[(2)] = inst_37111);

(statearr_37193_37304[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (39))){
var inst_37063 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
if(cljs.core.truth_(inst_37063)){
var statearr_37194_37305 = state_37174__$1;
(statearr_37194_37305[(1)] = (40));

} else {
var statearr_37195_37306 = state_37174__$1;
(statearr_37195_37306[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (46))){
var inst_37163 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37196_37307 = state_37174__$1;
(statearr_37196_37307[(2)] = inst_37163);

(statearr_37196_37307[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (4))){
var inst_36938 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37197_37308 = state_37174__$1;
(statearr_37197_37308[(2)] = inst_36938);

(statearr_37197_37308[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (54))){
var inst_37099 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_37100 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37101 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_37102 = cljs.core.PersistentHashMap.fromArrays(inst_37100,inst_37101);
var inst_37103 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37099,inst_37102);
var inst_37104 = (function(){throw inst_37103})();
var state_37174__$1 = state_37174;
var statearr_37198_37309 = state_37174__$1;
(statearr_37198_37309[(2)] = inst_37104);

(statearr_37198_37309[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (15))){
var inst_37038 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37199_37310 = state_37174__$1;
(statearr_37199_37310[(2)] = inst_37038);

(statearr_37199_37310[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (48))){
var inst_37087 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37088 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_37089 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_37088);
var inst_37090 = [inst_37089,r];
var inst_37091 = (new cljs.core.PersistentVector(null,2,(5),inst_37087,inst_37090,null));
var state_37174__$1 = state_37174;
var statearr_37200_37311 = state_37174__$1;
(statearr_37200_37311[(2)] = inst_37091);

(statearr_37200_37311[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (50))){
var inst_37161 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37201_37312 = state_37174__$1;
(statearr_37201_37312[(2)] = inst_37161);

(statearr_37201_37312[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (21))){
var inst_36976 = (state_37174[(10)]);
var inst_36984 = (state_37174[(11)]);
var inst_36972 = (state_37174[(12)]);
var inst_36977 = (state_37174[(13)]);
var inst_36975 = (state_37174[(14)]);
var inst_36974 = (state_37174[(15)]);
var inst_36951 = (state_37174[(16)]);
var inst_36947 = (state_37174[(17)]);
var inst_36983 = (state_37174[(18)]);
var inst_36988 = (state_37174[(2)]);
var inst_36989 = fluree.db.util.async.throw_err(inst_36988);
var inst_36990 = (function (){var new_res = inst_36989;
var rest = inst_36984;
var pred__36948 = inst_36951;
var tuples = inst_36977;
var expr__36949 = inst_36947;
var first__36981 = inst_36983;
var seq__36970 = inst_36975;
var first__36971 = inst_36974;
var seq__36980 = inst_36984;
var vec__36979 = inst_36976;
var vec__36969 = inst_36972;
var G__36968 = inst_36976;
var segment_type = inst_36947;
var clause_group = inst_36983;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_36991 = cljs.core.keys(vars);
var inst_36992 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36990,inst_36989,inst_36991);
var inst_36993 = fluree.db.query.analytical.res_absorb_vars(inst_36992);
var state_37174__$1 = (function (){var statearr_37202 = state_37174;
(statearr_37202[(19)] = inst_36993);

return statearr_37202;
})();
if(cljs.core.truth_(inst_36977)){
var statearr_37203_37313 = state_37174__$1;
(statearr_37203_37313[(1)] = (22));

} else {
var statearr_37204_37314 = state_37174__$1;
(statearr_37204_37314[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (31))){
var inst_37045 = cljs.core.second(clause);
var inst_37046 = clojure.string.starts_with_QMARK_(inst_37045,"fullText:");
var state_37174__$1 = state_37174;
var statearr_37205_37315 = state_37174__$1;
(statearr_37205_37315[(2)] = inst_37046);

(statearr_37205_37315[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (32))){
var inst_37043 = (state_37174[(9)]);
var state_37174__$1 = state_37174;
var statearr_37206_37316 = state_37174__$1;
(statearr_37206_37316[(2)] = inst_37043);

(statearr_37206_37316[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (40))){
var inst_37065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37066 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_37174__$1 = (function (){var statearr_37207 = state_37174;
(statearr_37207[(20)] = inst_37065);

return statearr_37207;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37174__$1,(43),inst_37066);
} else {
if((state_val_37175 === (56))){
var inst_37113 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37208_37317 = state_37174__$1;
(statearr_37208_37317[(2)] = inst_37113);

(statearr_37208_37317[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (33))){
var inst_37049 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
if(cljs.core.truth_(inst_37049)){
var statearr_37209_37318 = state_37174__$1;
(statearr_37209_37318[(1)] = (34));

} else {
var statearr_37210_37319 = state_37174__$1;
(statearr_37210_37319[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (13))){
var inst_36972 = (state_37174[(12)]);
var inst_36972__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_36973 = cljs.core.seq(inst_36972__$1);
var inst_36974 = cljs.core.first(inst_36973);
var inst_36975 = cljs.core.next(inst_36973);
var inst_36976 = inst_36972__$1;
var inst_36977 = null;
var state_37174__$1 = (function (){var statearr_37211 = state_37174;
(statearr_37211[(10)] = inst_36976);

(statearr_37211[(12)] = inst_36972__$1);

(statearr_37211[(13)] = inst_36977);

(statearr_37211[(14)] = inst_36975);

(statearr_37211[(15)] = inst_36974);

return statearr_37211;
})();
var statearr_37212_37320 = state_37174__$1;
(statearr_37212_37320[(2)] = null);

(statearr_37212_37320[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (22))){
var inst_36984 = (state_37174[(11)]);
var inst_36977 = (state_37174[(13)]);
var inst_36993 = (state_37174[(19)]);
var inst_36995 = fluree.db.query.union.results(inst_36977,inst_36993);
var inst_36976 = inst_36984;
var inst_36977__$1 = inst_36995;
var state_37174__$1 = (function (){var statearr_37213 = state_37174;
(statearr_37213[(10)] = inst_36976);

(statearr_37213[(13)] = inst_36977__$1);

return statearr_37213;
})();
var statearr_37214_37321 = state_37174__$1;
(statearr_37214_37321[(2)] = null);

(statearr_37214_37321[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (36))){
var inst_37167 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37215_37322 = state_37174__$1;
(statearr_37215_37322[(2)] = inst_37167);

(statearr_37215_37322[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (41))){
var inst_37073 = cljs.core.count(clause);
var inst_37074 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_37073);
var state_37174__$1 = state_37174;
if(inst_37074){
var statearr_37216_37323 = state_37174__$1;
(statearr_37216_37323[(1)] = (44));

} else {
var statearr_37217_37324 = state_37174__$1;
(statearr_37217_37324[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (43))){
var inst_37065 = (state_37174[(20)]);
var inst_37068 = (state_37174[(2)]);
var inst_37069 = fluree.db.util.async.throw_err(inst_37068);
var inst_37070 = [inst_37069,r];
var inst_37071 = (new cljs.core.PersistentVector(null,2,(5),inst_37065,inst_37070,null));
var state_37174__$1 = state_37174;
var statearr_37218_37325 = state_37174__$1;
(statearr_37218_37325[(2)] = inst_37071);

(statearr_37218_37325[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (61))){
var inst_37124 = (state_37174[(8)]);
var inst_37127 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_37124,r,res,optional_QMARK_,fuel,max_fuel);
var state_37174__$1 = state_37174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37174__$1,(64),inst_37127);
} else {
if((state_val_37175 === (29))){
var inst_36947 = (state_37174[(17)]);
var inst_37030 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36947)].join('');
var inst_37031 = (new Error(inst_37030));
var inst_37032 = (function(){throw inst_37031})();
var state_37174__$1 = state_37174;
var statearr_37219_37326 = state_37174__$1;
(statearr_37219_37326[(2)] = inst_37032);

(statearr_37219_37326[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (44))){
var inst_37076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37077 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_37174__$1 = (function (){var statearr_37220 = state_37174;
(statearr_37220[(21)] = inst_37076);

return statearr_37220;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37174__$1,(47),inst_37077);
} else {
if((state_val_37175 === (6))){
var inst_36951 = (state_37174[(16)]);
var inst_36947 = (state_37174[(17)]);
var inst_36946 = cljs.core.keys(clause);
var inst_36947__$1 = cljs.core.first(inst_36946);
var inst_36951__$1 = cljs.core._EQ_;
var inst_36952 = (function (){var G__37221 = cljs.core.cst$kw$optional;
var G__37222 = inst_36947__$1;
return (inst_36951__$1.cljs$core$IFn$_invoke$arity$2 ? inst_36951__$1.cljs$core$IFn$_invoke$arity$2(G__37221,G__37222) : inst_36951__$1.call(null,G__37221,G__37222));
})();
var state_37174__$1 = (function (){var statearr_37223 = state_37174;
(statearr_37223[(16)] = inst_36951__$1);

(statearr_37223[(17)] = inst_36947__$1);

return statearr_37223;
})();
if(cljs.core.truth_(inst_36952)){
var statearr_37224_37327 = state_37174__$1;
(statearr_37224_37327[(1)] = (9));

} else {
var statearr_37225_37328 = state_37174__$1;
(statearr_37225_37328[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (28))){
var inst_37024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37025 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_37026 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_37025,optional_QMARK_);
var inst_37027 = [inst_37026,r];
var inst_37028 = (new cljs.core.PersistentVector(null,2,(5),inst_37024,inst_37027,null));
var state_37174__$1 = state_37174;
var statearr_37226_37329 = state_37174__$1;
(statearr_37226_37329[(2)] = inst_37028);

(statearr_37226_37329[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (64))){
var inst_37129 = (state_37174[(2)]);
var inst_37130 = fluree.db.util.async.throw_err(inst_37129);
var state_37174__$1 = state_37174;
var statearr_37227_37330 = state_37174__$1;
(statearr_37227_37330[(2)] = inst_37130);

(statearr_37227_37330[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (51))){
var inst_37096 = cljs.core.first(clause);
var inst_37097 = cljs.core.sequential_QMARK_(inst_37096);
var state_37174__$1 = state_37174;
if(inst_37097){
var statearr_37228_37331 = state_37174__$1;
(statearr_37228_37331[(1)] = (54));

} else {
var statearr_37229_37332 = state_37174__$1;
(statearr_37229_37332[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (25))){
var inst_36951 = (state_37174[(16)]);
var inst_36947 = (state_37174[(17)]);
var inst_37012 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_37013 = (function (){var segment_type = inst_36947;
var pred__36948 = inst_36951;
var expr__36949 = inst_36947;
var bindings = inst_37012;
return (function (p1__36933_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__36933_SHARP_);
});
})();
var inst_37014 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_37013,inst_37012);
var inst_37015 = cljs.core.PersistentHashMap.EMPTY;
var inst_37016 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37015,inst_37014);
var inst_37017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37018 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_37016);
var inst_37019 = [inst_37018,r];
var inst_37020 = (new cljs.core.PersistentVector(null,2,(5),inst_37017,inst_37019,null));
var state_37174__$1 = state_37174;
var statearr_37230_37333 = state_37174__$1;
(statearr_37230_37333[(2)] = inst_37020);

(statearr_37230_37333[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (34))){
var inst_37051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37052 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_37053 = [inst_37052,r];
var inst_37054 = (new cljs.core.PersistentVector(null,2,(5),inst_37051,inst_37053,null));
var state_37174__$1 = state_37174;
var statearr_37231_37334 = state_37174__$1;
(statearr_37231_37334[(2)] = inst_37054);

(statearr_37231_37334[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (17))){
var inst_37008 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37232_37335 = state_37174__$1;
(statearr_37232_37335[(2)] = inst_37008);

(statearr_37232_37335[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (3))){
var inst_37172 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37174__$1,inst_37172);
} else {
if((state_val_37175 === (12))){
var inst_36954 = (state_37174[(22)]);
var inst_36958 = (state_37174[(2)]);
var inst_36959 = fluree.db.util.async.throw_err(inst_36958);
var inst_36960 = [inst_36959,r];
var inst_36961 = (new cljs.core.PersistentVector(null,2,(5),inst_36954,inst_36960,null));
var state_37174__$1 = state_37174;
var statearr_37233_37336 = state_37174__$1;
(statearr_37233_37336[(2)] = inst_36961);

(statearr_37233_37336[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (2))){
var _ = (function (){var statearr_37234 = state_37174;
(statearr_37234[(4)] = cljs.core.cons((5),(state_37174[(4)])));

return statearr_37234;
})();
var inst_36944 = cljs.core.map_QMARK_(clause);
var state_37174__$1 = state_37174;
if(inst_36944){
var statearr_37235_37337 = state_37174__$1;
(statearr_37235_37337[(1)] = (6));

} else {
var statearr_37236_37338 = state_37174__$1;
(statearr_37236_37338[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (66))){
var state_37174__$1 = state_37174;
var statearr_37237_37339 = state_37174__$1;
(statearr_37237_37339[(1)] = (68));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (23))){
var inst_36984 = (state_37174[(11)]);
var inst_36993 = (state_37174[(19)]);
var inst_36976 = inst_36984;
var inst_36977 = inst_36993;
var state_37174__$1 = (function (){var statearr_37239 = state_37174;
(statearr_37239[(10)] = inst_36976);

(statearr_37239[(13)] = inst_36977);

return statearr_37239;
})();
var statearr_37240_37340 = state_37174__$1;
(statearr_37240_37340[(2)] = null);

(statearr_37240_37340[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (47))){
var inst_37076 = (state_37174[(21)]);
var inst_37079 = (state_37174[(2)]);
var inst_37080 = fluree.db.util.async.throw_err(inst_37079);
var inst_37081 = [inst_37080,r];
var inst_37082 = (new cljs.core.PersistentVector(null,2,(5),inst_37076,inst_37081,null));
var state_37174__$1 = state_37174;
var statearr_37241_37341 = state_37174__$1;
(statearr_37241_37341[(2)] = inst_37082);

(statearr_37241_37341[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (35))){
var inst_37057 = (state_37174[(23)]);
var inst_37056 = cljs.core.count(clause);
var inst_37057__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_37056);
var state_37174__$1 = (function (){var statearr_37242 = state_37174;
(statearr_37242[(23)] = inst_37057__$1);

return statearr_37242;
})();
if(inst_37057__$1){
var statearr_37243_37342 = state_37174__$1;
(statearr_37243_37342[(1)] = (37));

} else {
var statearr_37244_37343 = state_37174__$1;
(statearr_37244_37343[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (19))){
var inst_36977 = (state_37174[(13)]);
var inst_37002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37003 = [inst_36977,r];
var inst_37004 = (new cljs.core.PersistentVector(null,2,(5),inst_37002,inst_37003,null));
var state_37174__$1 = state_37174;
var statearr_37245_37344 = state_37174__$1;
(statearr_37245_37344[(2)] = inst_37004);

(statearr_37245_37344[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (57))){
var inst_37119 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_37174__$1 = state_37174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37174__$1,(60),inst_37119);
} else {
if((state_val_37175 === (68))){
var inst_37123 = (state_37174[(7)]);
var inst_37124 = (state_37174[(8)]);
var inst_37141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37142 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_37123,res,inst_37124,fuel,max_fuel);
var state_37174__$1 = (function (){var statearr_37246 = state_37174;
(statearr_37246[(24)] = inst_37141);

return statearr_37246;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37174__$1,(71),inst_37142);
} else {
if((state_val_37175 === (11))){
var inst_37040 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37248_37345 = state_37174__$1;
(statearr_37248_37345[(2)] = inst_37040);

(statearr_37248_37345[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (9))){
var inst_36954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36955 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_36956 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_36955,res,fuel,max_fuel,opts);
var state_37174__$1 = (function (){var statearr_37249 = state_37174;
(statearr_37249[(22)] = inst_36954);

return statearr_37249;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37174__$1,(12),inst_36956);
} else {
if((state_val_37175 === (5))){
var _ = (function (){var statearr_37250 = state_37174;
(statearr_37250[(4)] = cljs.core.rest((state_37174[(4)])));

return statearr_37250;
})();
var state_37174__$1 = state_37174;
var ex37247 = (state_37174__$1[(2)]);
var statearr_37251_37346 = state_37174__$1;
(statearr_37251_37346[(5)] = ex37247);


if((ex37247 instanceof Error)){
var statearr_37252_37347 = state_37174__$1;
(statearr_37252_37347[(1)] = (4));

(statearr_37252_37347[(5)] = null);

} else {
throw ex37247;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (14))){
var inst_36951 = (state_37174[(16)]);
var inst_36947 = (state_37174[(17)]);
var inst_37010 = (function (){var G__37253 = cljs.core.cst$kw$bind;
var G__37254 = inst_36947;
return (inst_36951.cljs$core$IFn$_invoke$arity$2 ? inst_36951.cljs$core$IFn$_invoke$arity$2(G__37253,G__37254) : inst_36951.call(null,G__37253,G__37254));
})();
var state_37174__$1 = state_37174;
if(cljs.core.truth_(inst_37010)){
var statearr_37255_37348 = state_37174__$1;
(statearr_37255_37348[(1)] = (25));

} else {
var statearr_37256_37349 = state_37174__$1;
(statearr_37256_37349[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (45))){
var inst_37084 = cljs.core.count(clause);
var inst_37085 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_37084);
var state_37174__$1 = state_37174;
if(inst_37085){
var statearr_37257_37350 = state_37174__$1;
(statearr_37257_37350[(1)] = (48));

} else {
var statearr_37258_37351 = state_37174__$1;
(statearr_37258_37351[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (53))){
var inst_37159 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37259_37352 = state_37174__$1;
(statearr_37259_37352[(2)] = inst_37159);

(statearr_37259_37352[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (26))){
var inst_36951 = (state_37174[(16)]);
var inst_36947 = (state_37174[(17)]);
var inst_37022 = (function (){var G__37260 = cljs.core.cst$kw$filter;
var G__37261 = inst_36947;
return (inst_36951.cljs$core$IFn$_invoke$arity$2 ? inst_36951.cljs$core$IFn$_invoke$arity$2(G__37260,G__37261) : inst_36951.call(null,G__37260,G__37261));
})();
var state_37174__$1 = state_37174;
if(cljs.core.truth_(inst_37022)){
var statearr_37262_37353 = state_37174__$1;
(statearr_37262_37353[(1)] = (28));

} else {
var statearr_37263_37354 = state_37174__$1;
(statearr_37263_37354[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (16))){
var inst_36976 = (state_37174[(10)]);
var inst_36983 = (state_37174[(18)]);
var inst_36982 = cljs.core.seq(inst_36976);
var inst_36983__$1 = cljs.core.first(inst_36982);
var inst_36984 = cljs.core.next(inst_36982);
var state_37174__$1 = (function (){var statearr_37264 = state_37174;
(statearr_37264[(11)] = inst_36984);

(statearr_37264[(18)] = inst_36983__$1);

return statearr_37264;
})();
if(cljs.core.truth_(inst_36983__$1)){
var statearr_37265_37355 = state_37174__$1;
(statearr_37265_37355[(1)] = (18));

} else {
var statearr_37266_37356 = state_37174__$1;
(statearr_37266_37356[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (38))){
var inst_37057 = (state_37174[(23)]);
var state_37174__$1 = state_37174;
var statearr_37267_37357 = state_37174__$1;
(statearr_37267_37357[(2)] = inst_37057);

(statearr_37267_37357[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (30))){
var inst_37034 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37268_37358 = state_37174__$1;
(statearr_37268_37358[(2)] = inst_37034);

(statearr_37268_37358[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (10))){
var inst_36951 = (state_37174[(16)]);
var inst_36947 = (state_37174[(17)]);
var inst_36963 = (function (){var G__37269 = cljs.core.cst$kw$union;
var G__37270 = inst_36947;
return (inst_36951.cljs$core$IFn$_invoke$arity$2 ? inst_36951.cljs$core$IFn$_invoke$arity$2(G__37269,G__37270) : inst_36951.call(null,G__37269,G__37270));
})();
var state_37174__$1 = state_37174;
if(cljs.core.truth_(inst_36963)){
var statearr_37271_37359 = state_37174__$1;
(statearr_37271_37359[(1)] = (13));

} else {
var statearr_37272_37360 = state_37174__$1;
(statearr_37272_37360[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (18))){
var inst_36983 = (state_37174[(18)]);
var inst_36986 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_36983,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_36983,q_map,vars,fuel,max_fuel,opts));
var state_37174__$1 = state_37174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37174__$1,(21),inst_36986);
} else {
if((state_val_37175 === (52))){
var state_37174__$1 = state_37174;
var statearr_37273_37361 = state_37174__$1;
(statearr_37273_37361[(1)] = (57));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (67))){
var inst_37152 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37275_37362 = state_37174__$1;
(statearr_37275_37362[(2)] = inst_37152);

(statearr_37275_37362[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (71))){
var inst_37141 = (state_37174[(24)]);
var inst_37144 = (state_37174[(2)]);
var inst_37145 = fluree.db.util.async.throw_err(inst_37144);
var inst_37146 = [inst_37145,r];
var inst_37147 = (new cljs.core.PersistentVector(null,2,(5),inst_37141,inst_37146,null));
var state_37174__$1 = state_37174;
var statearr_37276_37363 = state_37174__$1;
(statearr_37276_37363[(2)] = inst_37147);

(statearr_37276_37363[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (42))){
var inst_37165 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37277_37364 = state_37174__$1;
(statearr_37277_37364[(2)] = inst_37165);

(statearr_37277_37364[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (37))){
var inst_37059 = cljs.core.second(clause);
var inst_37060 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37059,"rdf:type");
var state_37174__$1 = state_37174;
var statearr_37278_37365 = state_37174__$1;
(statearr_37278_37365[(2)] = inst_37060);

(statearr_37278_37365[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (63))){
var inst_37154 = (state_37174[(2)]);
var state_37174__$1 = state_37174;
var statearr_37279_37366 = state_37174__$1;
(statearr_37279_37366[(2)] = inst_37154);

(statearr_37279_37366[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (8))){
var inst_37169 = (state_37174[(2)]);
var _ = (function (){var statearr_37280 = state_37174;
(statearr_37280[(4)] = cljs.core.rest((state_37174[(4)])));

return statearr_37280;
})();
var state_37174__$1 = state_37174;
var statearr_37281_37367 = state_37174__$1;
(statearr_37281_37367[(2)] = inst_37169);

(statearr_37281_37367[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37175 === (49))){
var inst_37093 = cljs.core.count(clause);
var inst_37094 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_37093);
var state_37174__$1 = state_37174;
if(inst_37094){
var statearr_37282_37368 = state_37174__$1;
(statearr_37282_37368[(1)] = (51));

} else {
var statearr_37283_37369 = state_37174__$1;
(statearr_37283_37369[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto____0 = (function (){
var statearr_37284 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37284[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto__);

(statearr_37284[(1)] = (1));

return statearr_37284;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto____1 = (function (state_37174){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_37174);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e37285){var ex__16398__auto__ = e37285;
var statearr_37286_37370 = state_37174;
(statearr_37286_37370[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_37174[(4)]))){
var statearr_37287_37371 = state_37174;
(statearr_37287_37371[(1)] = cljs.core.first((state_37174[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__37372 = state_37174;
state_37174 = G__37372;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto__ = function(state_37174){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto____1.call(this,state_37174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_37288 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_37288[(6)] = c__16469__auto__);

return statearr_37288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__37374 = arguments.length;
switch (G__37374) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_37454){
var state_val_37455 = (state_37454[(1)]);
if((state_val_37455 === (7))){
var inst_37449 = (state_37454[(2)]);
var _ = (function (){var statearr_37456 = state_37454;
(statearr_37456[(4)] = cljs.core.rest((state_37454[(4)])));

return statearr_37456;
})();
var state_37454__$1 = state_37454;
var statearr_37457_37505 = state_37454__$1;
(statearr_37457_37505[(2)] = inst_37449);

(statearr_37457_37505[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (20))){
var inst_37414 = (state_37454[(7)]);
var inst_37426 = (state_37454[(2)]);
var inst_37396 = inst_37414;
var inst_37397 = inst_37426;
var state_37454__$1 = (function (){var statearr_37458 = state_37454;
(statearr_37458[(8)] = inst_37397);

(statearr_37458[(9)] = inst_37396);

return statearr_37458;
})();
var statearr_37459_37506 = state_37454__$1;
(statearr_37459_37506[(2)] = null);

(statearr_37459_37506[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (1))){
var state_37454__$1 = state_37454;
var statearr_37460_37507 = state_37454__$1;
(statearr_37460_37507[(2)] = null);

(statearr_37460_37507[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (24))){
var inst_37414 = (state_37454[(7)]);
var inst_37397 = (state_37454[(8)]);
var inst_37413 = (state_37454[(10)]);
var inst_37434 = fluree.db.query.analytical.inner_join(inst_37397,inst_37413);
var inst_37396 = inst_37414;
var inst_37397__$1 = inst_37434;
var state_37454__$1 = (function (){var statearr_37461 = state_37454;
(statearr_37461[(8)] = inst_37397__$1);

(statearr_37461[(9)] = inst_37396);

return statearr_37461;
})();
var statearr_37462_37508 = state_37454__$1;
(statearr_37462_37508[(2)] = null);

(statearr_37462_37508[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (4))){
var inst_37375 = (state_37454[(2)]);
var state_37454__$1 = state_37454;
var statearr_37464_37509 = state_37454__$1;
(statearr_37464_37509[(2)] = inst_37375);

(statearr_37464_37509[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (15))){
var inst_37413 = (state_37454[(10)]);
var state_37454__$1 = state_37454;
if(cljs.core.truth_(inst_37413)){
var statearr_37465_37510 = state_37454__$1;
(statearr_37465_37510[(1)] = (18));

} else {
var statearr_37466_37511 = state_37454__$1;
(statearr_37466_37511[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (21))){
var inst_37414 = (state_37454[(7)]);
var inst_37397 = (state_37454[(8)]);
var tmp37463 = inst_37397;
var inst_37396 = inst_37414;
var inst_37397__$1 = tmp37463;
var state_37454__$1 = (function (){var statearr_37467 = state_37454;
(statearr_37467[(8)] = inst_37397__$1);

(statearr_37467[(9)] = inst_37396);

return statearr_37467;
})();
var statearr_37468_37512 = state_37454__$1;
(statearr_37468_37512[(2)] = null);

(statearr_37468_37512[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (13))){
var inst_37397 = (state_37454[(8)]);
var inst_37420 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_37397,cljs.core.cst$kw$vars);
var inst_37421 = cljs.core.empty_QMARK_(inst_37420);
var state_37454__$1 = state_37454;
if(inst_37421){
var statearr_37469_37513 = state_37454__$1;
(statearr_37469_37513[(1)] = (15));

} else {
var statearr_37470_37514 = state_37454__$1;
(statearr_37470_37514[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (22))){
var state_37454__$1 = state_37454;
var statearr_37471_37515 = state_37454__$1;
(statearr_37471_37515[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (6))){
var inst_37396 = (state_37454[(9)]);
var inst_37403 = (state_37454[(11)]);
var inst_37402 = cljs.core.seq(inst_37396);
var inst_37403__$1 = cljs.core.first(inst_37402);
var inst_37404 = cljs.core.next(inst_37402);
var state_37454__$1 = (function (){var statearr_37473 = state_37454;
(statearr_37473[(12)] = inst_37404);

(statearr_37473[(11)] = inst_37403__$1);

return statearr_37473;
})();
if(cljs.core.truth_(inst_37403__$1)){
var statearr_37474_37516 = state_37454__$1;
(statearr_37474_37516[(1)] = (8));

} else {
var statearr_37475_37517 = state_37454__$1;
(statearr_37475_37517[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (25))){
var state_37454__$1 = state_37454;
var statearr_37476_37518 = state_37454__$1;
(statearr_37476_37518[(2)] = null);

(statearr_37476_37518[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (17))){
var inst_37442 = (state_37454[(2)]);
var state_37454__$1 = state_37454;
var statearr_37477_37519 = state_37454__$1;
(statearr_37477_37519[(2)] = inst_37442);

(statearr_37477_37519[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (3))){
var inst_37452 = (state_37454[(2)]);
var state_37454__$1 = state_37454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37454__$1,inst_37452);
} else {
if((state_val_37455 === (12))){
var inst_37414 = (state_37454[(7)]);
var inst_37413 = (state_37454[(10)]);
var inst_37396 = inst_37414;
var inst_37397 = inst_37413;
var state_37454__$1 = (function (){var statearr_37478 = state_37454;
(statearr_37478[(8)] = inst_37397);

(statearr_37478[(9)] = inst_37396);

return statearr_37478;
})();
var statearr_37479_37520 = state_37454__$1;
(statearr_37479_37520[(2)] = null);

(statearr_37479_37520[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (2))){
var _ = (function (){var statearr_37480 = state_37454;
(statearr_37480[(4)] = cljs.core.cons((5),(state_37454[(4)])));

return statearr_37480;
})();
var inst_37388 = where;
var inst_37389 = cljs.core.seq(inst_37388);
var inst_37390 = cljs.core.first(inst_37389);
var inst_37391 = cljs.core.next(inst_37389);
var inst_37392 = [cljs.core.cst$kw$vars];
var inst_37393 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_37394 = [inst_37393];
var inst_37395 = cljs.core.PersistentHashMap.fromArrays(inst_37392,inst_37394);
var inst_37396 = inst_37388;
var inst_37397 = inst_37395;
var state_37454__$1 = (function (){var statearr_37481 = state_37454;
(statearr_37481[(13)] = inst_37390);

(statearr_37481[(14)] = inst_37391);

(statearr_37481[(8)] = inst_37397);

(statearr_37481[(9)] = inst_37396);

return statearr_37481;
})();
var statearr_37482_37521 = state_37454__$1;
(statearr_37482_37521[(2)] = null);

(statearr_37482_37521[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (23))){
var inst_37440 = (state_37454[(2)]);
var state_37454__$1 = state_37454;
var statearr_37483_37522 = state_37454__$1;
(statearr_37483_37522[(2)] = inst_37440);

(statearr_37483_37522[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (19))){
var inst_37397 = (state_37454[(8)]);
var state_37454__$1 = state_37454;
var statearr_37484_37523 = state_37454__$1;
(statearr_37484_37523[(2)] = inst_37397);

(statearr_37484_37523[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (11))){
var inst_37403 = (state_37454[(11)]);
var inst_37411 = (state_37454[(2)]);
var inst_37412 = fluree.db.util.async.throw_err(inst_37411);
var inst_37413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37412,(0),null);
var inst_37414 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37412,(1),null);
var inst_37415 = cljs.core.count(inst_37403);
var inst_37416 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_37415);
var state_37454__$1 = (function (){var statearr_37486 = state_37454;
(statearr_37486[(7)] = inst_37414);

(statearr_37486[(10)] = inst_37413);

return statearr_37486;
})();
if(inst_37416){
var statearr_37487_37524 = state_37454__$1;
(statearr_37487_37524[(1)] = (12));

} else {
var statearr_37488_37525 = state_37454__$1;
(statearr_37488_37525[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (9))){
var inst_37397 = (state_37454[(8)]);
var state_37454__$1 = state_37454;
var statearr_37489_37526 = state_37454__$1;
(statearr_37489_37526[(2)] = inst_37397);

(statearr_37489_37526[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (5))){
var _ = (function (){var statearr_37490 = state_37454;
(statearr_37490[(4)] = cljs.core.rest((state_37454[(4)])));

return statearr_37490;
})();
var state_37454__$1 = state_37454;
var ex37485 = (state_37454__$1[(2)]);
var statearr_37491_37527 = state_37454__$1;
(statearr_37491_37527[(5)] = ex37485);


if((ex37485 instanceof Error)){
var statearr_37492_37528 = state_37454__$1;
(statearr_37492_37528[(1)] = (4));

(statearr_37492_37528[(5)] = null);

} else {
throw ex37485;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (14))){
var inst_37444 = (state_37454[(2)]);
var state_37454__$1 = state_37454;
var statearr_37493_37529 = state_37454__$1;
(statearr_37493_37529[(2)] = inst_37444);

(statearr_37493_37529[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (26))){
var inst_37438 = (state_37454[(2)]);
var state_37454__$1 = state_37454;
var statearr_37494_37530 = state_37454__$1;
(statearr_37494_37530[(2)] = inst_37438);

(statearr_37494_37530[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (16))){
var inst_37413 = (state_37454[(10)]);
var inst_37429 = (inst_37413 == null);
var state_37454__$1 = state_37454;
if(cljs.core.truth_(inst_37429)){
var statearr_37495_37531 = state_37454__$1;
(statearr_37495_37531[(1)] = (21));

} else {
var statearr_37496_37532 = state_37454__$1;
(statearr_37496_37532[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (10))){
var inst_37447 = (state_37454[(2)]);
var state_37454__$1 = state_37454;
var statearr_37497_37533 = state_37454__$1;
(statearr_37497_37533[(2)] = inst_37447);

(statearr_37497_37533[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (18))){
var inst_37413 = (state_37454[(10)]);
var state_37454__$1 = state_37454;
var statearr_37498_37534 = state_37454__$1;
(statearr_37498_37534[(2)] = inst_37413);

(statearr_37498_37534[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37455 === (8))){
var inst_37397 = (state_37454[(8)]);
var inst_37404 = (state_37454[(12)]);
var inst_37403 = (state_37454[(11)]);
var inst_37409 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_37397,inst_37403,inst_37404,false,fuel,max_fuel,opts);
var state_37454__$1 = state_37454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37454__$1,(11),inst_37409);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16395__auto__ = null;
var fluree$db$query$analytical$state_machine__16395__auto____0 = (function (){
var statearr_37499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37499[(0)] = fluree$db$query$analytical$state_machine__16395__auto__);

(statearr_37499[(1)] = (1));

return statearr_37499;
});
var fluree$db$query$analytical$state_machine__16395__auto____1 = (function (state_37454){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_37454);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e37500){var ex__16398__auto__ = e37500;
var statearr_37501_37535 = state_37454;
(statearr_37501_37535[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_37454[(4)]))){
var statearr_37502_37536 = state_37454;
(statearr_37502_37536[(1)] = cljs.core.first((state_37454[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__37537 = state_37454;
state_37454 = G__37537;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16395__auto__ = function(state_37454){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16395__auto____1.call(this,state_37454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16395__auto____0;
fluree$db$query$analytical$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16395__auto____1;
return fluree$db$query$analytical$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_37503 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_37503[(6)] = c__16469__auto__);

return statearr_37503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_37572){
var state_val_37573 = (state_37572[(1)]);
if((state_val_37573 === (7))){
var inst_37554 = (state_37572[(7)]);
var inst_37549 = (state_37572[(8)]);
var inst_37556 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_37549,inst_37554,fuel,max_fuel,opts);
var state_37572__$1 = state_37572;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37572__$1,(10),inst_37556);
} else {
if((state_val_37573 === (1))){
var state_37572__$1 = state_37572;
var statearr_37574_37599 = state_37572__$1;
(statearr_37574_37599[(2)] = null);

(statearr_37574_37599[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37573 === (4))){
var inst_37538 = (state_37572[(2)]);
var state_37572__$1 = state_37572;
var statearr_37575_37600 = state_37572__$1;
(statearr_37575_37600[(2)] = inst_37538);

(statearr_37575_37600[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37573 === (13))){
var inst_37567 = (state_37572[(2)]);
var _ = (function (){var statearr_37576 = state_37572;
(statearr_37576[(4)] = cljs.core.rest((state_37572[(4)])));

return statearr_37576;
})();
var state_37572__$1 = state_37572;
var statearr_37577_37601 = state_37572__$1;
(statearr_37577_37601[(2)] = inst_37567);

(statearr_37577_37601[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37573 === (6))){
var inst_37549 = (state_37572[(8)]);
var inst_37553 = (state_37572[(2)]);
var inst_37554 = fluree.db.util.async.throw_err(inst_37553);
var state_37572__$1 = (function (){var statearr_37578 = state_37572;
(statearr_37578[(7)] = inst_37554);

return statearr_37578;
})();
if(cljs.core.truth_(inst_37549)){
var statearr_37579_37602 = state_37572__$1;
(statearr_37579_37602[(1)] = (7));

} else {
var statearr_37580_37603 = state_37572__$1;
(statearr_37580_37603[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37573 === (3))){
var inst_37570 = (state_37572[(2)]);
var state_37572__$1 = state_37572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37572__$1,inst_37570);
} else {
if((state_val_37573 === (12))){
var inst_37562 = (state_37572[(9)]);
var state_37572__$1 = state_37572;
var statearr_37581_37604 = state_37572__$1;
(statearr_37581_37604[(2)] = inst_37562);

(statearr_37581_37604[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37573 === (2))){
var _ = (function (){var statearr_37582 = state_37572;
(statearr_37582[(4)] = cljs.core.cons((5),(state_37572[(4)])));

return statearr_37582;
})();
var inst_37545 = q_map;
var inst_37546 = cljs.core.__destructure_map(inst_37545);
var inst_37547 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37546,cljs.core.cst$kw$vars);
var inst_37548 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37546,cljs.core.cst$kw$where);
var inst_37549 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37546,cljs.core.cst$kw$optional);
var inst_37550 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37546,cljs.core.cst$kw$filter);
var inst_37551 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_37548,q_map,inst_37547,fuel,max_fuel,opts);
var state_37572__$1 = (function (){var statearr_37583 = state_37572;
(statearr_37583[(8)] = inst_37549);

(statearr_37583[(10)] = inst_37550);

return statearr_37583;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37572__$1,(6),inst_37551);
} else {
if((state_val_37573 === (11))){
var inst_37562 = (state_37572[(9)]);
var inst_37550 = (state_37572[(10)]);
var inst_37564 = fluree.db.query.analytical.tuples__GT_filtered(inst_37562,inst_37550,null);
var state_37572__$1 = state_37572;
var statearr_37585_37605 = state_37572__$1;
(statearr_37585_37605[(2)] = inst_37564);

(statearr_37585_37605[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37573 === (9))){
var inst_37550 = (state_37572[(10)]);
var inst_37562 = (state_37572[(2)]);
var state_37572__$1 = (function (){var statearr_37586 = state_37572;
(statearr_37586[(9)] = inst_37562);

return statearr_37586;
})();
if(cljs.core.truth_(inst_37550)){
var statearr_37587_37606 = state_37572__$1;
(statearr_37587_37606[(1)] = (11));

} else {
var statearr_37588_37607 = state_37572__$1;
(statearr_37588_37607[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37573 === (5))){
var _ = (function (){var statearr_37589 = state_37572;
(statearr_37589[(4)] = cljs.core.rest((state_37572[(4)])));

return statearr_37589;
})();
var state_37572__$1 = state_37572;
var ex37584 = (state_37572__$1[(2)]);
var statearr_37590_37608 = state_37572__$1;
(statearr_37590_37608[(5)] = ex37584);


if((ex37584 instanceof Error)){
var statearr_37591_37609 = state_37572__$1;
(statearr_37591_37609[(1)] = (4));

(statearr_37591_37609[(5)] = null);

} else {
throw ex37584;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37573 === (10))){
var inst_37558 = (state_37572[(2)]);
var inst_37559 = fluree.db.util.async.throw_err(inst_37558);
var state_37572__$1 = state_37572;
var statearr_37592_37610 = state_37572__$1;
(statearr_37592_37610[(2)] = inst_37559);

(statearr_37592_37610[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37573 === (8))){
var inst_37554 = (state_37572[(7)]);
var state_37572__$1 = state_37572;
var statearr_37593_37611 = state_37572__$1;
(statearr_37593_37611[(2)] = inst_37554);

(statearr_37593_37611[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__16395__auto____0 = (function (){
var statearr_37594 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37594[(0)] = fluree$db$query$analytical$q_$_state_machine__16395__auto__);

(statearr_37594[(1)] = (1));

return statearr_37594;
});
var fluree$db$query$analytical$q_$_state_machine__16395__auto____1 = (function (state_37572){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_37572);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e37595){var ex__16398__auto__ = e37595;
var statearr_37596_37612 = state_37572;
(statearr_37596_37612[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_37572[(4)]))){
var statearr_37597_37613 = state_37572;
(statearr_37597_37613[(1)] = cljs.core.first((state_37572[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__37614 = state_37572;
state_37572 = G__37614;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__16395__auto__ = function(state_37572){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__16395__auto____1.call(this,state_37572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__16395__auto____0;
fluree$db$query$analytical$q_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$q_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_37598 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_37598[(6)] = c__16469__auto__);

return statearr_37598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
