// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__42034 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42034,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42034,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42034,(2),null);
if(cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__42037){
var map__42038 = p__42037;
var map__42038__$1 = cljs.core.__destructure_map(map__42038);
var opts = map__42038__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42038__$1,cljs.core.cst$kw$reindex_QMARK_);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_42098){
var state_val_42099 = (state_42098[(1)]);
if((state_val_42099 === (7))){
var inst_42069 = cljs.core.not(reindex_QMARK_);
var state_42098__$1 = state_42098;
var statearr_42100_42124 = state_42098__$1;
(statearr_42100_42124[(2)] = inst_42069);

(statearr_42100_42124[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42099 === (1))){
var state_42098__$1 = state_42098;
var statearr_42101_42125 = state_42098__$1;
(statearr_42101_42125[(2)] = null);

(statearr_42101_42125[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42099 === (4))){
var inst_42039 = (state_42098[(2)]);
var state_42098__$1 = state_42098;
var statearr_42102_42126 = state_42098__$1;
(statearr_42102_42126[(2)] = inst_42039);

(statearr_42102_42126[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42099 === (6))){
var inst_42067 = (state_42098[(7)]);
var inst_42053 = (state_42098[(8)]);
var inst_42059 = (state_42098[(9)]);
var inst_42052 = (state_42098[(2)]);
var inst_42053__$1 = fluree.db.util.async.throw_err(inst_42052);
var inst_42054 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_42055 = cljs.core.__destructure_map(inst_42054);
var inst_42056 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42055,cljs.core.cst$kw$post);
var inst_42057 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42055,cljs.core.cst$kw$size);
var inst_42058 = fluree.db.flake.size_bytes(inst_42053__$1);
var inst_42059__$1 = (inst_42057 + inst_42058);
var inst_42060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42061 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_42062 = (new cljs.core.PersistentVector(null,2,(5),inst_42060,inst_42061,null));
var inst_42063 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_42062);
var inst_42064 = cljs.core.__destructure_map(inst_42063);
var inst_42065 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42064,cljs.core.cst$kw$novelty_DASH_min);
var inst_42066 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42064,cljs.core.cst$kw$novelty_DASH_max);
var inst_42067__$1 = (inst_42059__$1 > inst_42066);
var state_42098__$1 = (function (){var statearr_42103 = state_42098;
(statearr_42103[(10)] = inst_42056);

(statearr_42103[(11)] = inst_42065);

(statearr_42103[(7)] = inst_42067__$1);

(statearr_42103[(8)] = inst_42053__$1);

(statearr_42103[(9)] = inst_42059__$1);

return statearr_42103;
})();
if(cljs.core.truth_(inst_42067__$1)){
var statearr_42104_42127 = state_42098__$1;
(statearr_42104_42127[(1)] = (7));

} else {
var statearr_42105_42128 = state_42098__$1;
(statearr_42105_42128[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42099 === (3))){
var inst_42096 = (state_42098[(2)]);
var state_42098__$1 = state_42098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42098__$1,inst_42096);
} else {
if((state_val_42099 === (12))){
var inst_42056 = (state_42098[(10)]);
var inst_42053 = (state_42098[(8)]);
var inst_42059 = (state_42098[(9)]);
var inst_42082 = (state_42098[(2)]);
var inst_42083 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_42056,inst_42053);
var inst_42084 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_42085 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_42084,cljs.core.empty);
var inst_42086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42087 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_42088 = (new cljs.core.PersistentVector(null,2,(5),inst_42086,inst_42087,null));
var inst_42089 = cljs.core.assoc_in(db,inst_42088,inst_42083);
var inst_42090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42091 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_42092 = (new cljs.core.PersistentVector(null,2,(5),inst_42090,inst_42091,null));
var inst_42093 = cljs.core.assoc_in(inst_42089,inst_42092,inst_42059);
var _ = (function (){var statearr_42106 = state_42098;
(statearr_42106[(4)] = cljs.core.rest((state_42098[(4)])));

return statearr_42106;
})();
var state_42098__$1 = (function (){var statearr_42107 = state_42098;
(statearr_42107[(12)] = inst_42082);

(statearr_42107[(13)] = inst_42085);

return statearr_42107;
})();
var statearr_42108_42129 = state_42098__$1;
(statearr_42108_42129[(2)] = inst_42093);

(statearr_42108_42129[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42099 === (2))){
var _ = (function (){var statearr_42109 = state_42098;
(statearr_42109[(4)] = cljs.core.cons((5),(state_42098[(4)])));

return statearr_42109;
})();
var inst_42047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42048 = [pred_id];
var inst_42049 = (new cljs.core.PersistentVector(null,1,(5),inst_42047,inst_42048,null));
var inst_42050 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_42049);
var state_42098__$1 = state_42098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42098__$1,(6),inst_42050);
} else {
if((state_val_42099 === (11))){
var state_42098__$1 = state_42098;
var statearr_42111_42130 = state_42098__$1;
(statearr_42111_42130[(2)] = null);

(statearr_42111_42130[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42099 === (9))){
var inst_42072 = (state_42098[(2)]);
var state_42098__$1 = state_42098;
if(cljs.core.truth_(inst_42072)){
var statearr_42112_42131 = state_42098__$1;
(statearr_42112_42131[(1)] = (10));

} else {
var statearr_42113_42132 = state_42098__$1;
(statearr_42113_42132[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42099 === (5))){
var _ = (function (){var statearr_42114 = state_42098;
(statearr_42114[(4)] = cljs.core.rest((state_42098[(4)])));

return statearr_42114;
})();
var state_42098__$1 = state_42098;
var ex42110 = (state_42098__$1[(2)]);
var statearr_42115_42133 = state_42098__$1;
(statearr_42115_42133[(5)] = ex42110);


if((ex42110 instanceof Error)){
var statearr_42116_42134 = state_42098__$1;
(statearr_42116_42134[(1)] = (4));

(statearr_42116_42134[(5)] = null);

} else {
throw ex42110;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42099 === (10))){
var inst_42074 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_42075 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_42076 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_42077 = cljs.core.PersistentHashMap.fromArrays(inst_42075,inst_42076);
var inst_42078 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42074,inst_42077);
var inst_42079 = (function(){throw inst_42078})();
var state_42098__$1 = state_42098;
var statearr_42117_42135 = state_42098__$1;
(statearr_42117_42135[(2)] = inst_42079);

(statearr_42117_42135[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42099 === (8))){
var inst_42067 = (state_42098[(7)]);
var state_42098__$1 = state_42098;
var statearr_42118_42136 = state_42098__$1;
(statearr_42118_42136[(2)] = inst_42067);

(statearr_42118_42136[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto____0 = (function (){
var statearr_42119 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42119[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto__);

(statearr_42119[(1)] = (1));

return statearr_42119;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto____1 = (function (state_42098){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_42098);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e42120){var ex__16398__auto__ = e42120;
var statearr_42121_42137 = state_42098;
(statearr_42121_42137[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_42098[(4)]))){
var statearr_42122_42138 = state_42098;
(statearr_42122_42138[(1)] = cljs.core.first((state_42098[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__42139 = state_42098;
state_42098 = G__42139;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto__ = function(state_42098){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto____1.call(this,state_42098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_42123 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_42123[(6)] = c__16469__auto__);

return statearr_42123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__42144 = arguments.length;
switch (G__42144) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_42340){
var state_val_42341 = (state_42340[(1)]);
if((state_val_42341 === (7))){
var state_42340__$1 = state_42340;
var statearr_42342_42410 = state_42340__$1;
(statearr_42342_42410[(2)] = null);

(statearr_42342_42410[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (20))){
var inst_42265 = (state_42340[(7)]);
var inst_42266 = (state_42340[(8)]);
var inst_42182 = (state_42340[(9)]);
var inst_42264 = (state_42340[(10)]);
var inst_42262 = (state_42340[(11)]);
var inst_42233 = (state_42340[(12)]);
var inst_42263 = (state_42340[(13)]);
var inst_42183 = (state_42340[(14)]);
var inst_42276 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_42277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42278 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_42279 = (new cljs.core.PersistentVector(null,2,(5),inst_42277,inst_42278,null));
var inst_42280 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_42233,inst_42279);
var inst_42281 = (inst_42182 + inst_42280);
var inst_42282 = [inst_42262,inst_42263,inst_42264,inst_42265,inst_42281];
var inst_42283 = cljs.core.PersistentHashMap.fromArrays(inst_42276,inst_42282);
var inst_42284 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_42233,cljs.core.cst$kw$ecount,inst_42266,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_42283], 0));
var state_42340__$1 = (function (){var statearr_42343 = state_42340;
(statearr_42343[(15)] = inst_42284);

return statearr_42343;
})();
if(cljs.core.truth_(inst_42183)){
var statearr_42344_42411 = state_42340__$1;
(statearr_42344_42411[(1)] = (23));

} else {
var statearr_42345_42412 = state_42340__$1;
(statearr_42345_42412[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (27))){
var inst_42284 = (state_42340[(15)]);
var state_42340__$1 = state_42340;
var statearr_42346_42413 = state_42340__$1;
(statearr_42346_42413[(2)] = inst_42284);

(statearr_42346_42413[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (1))){
var state_42340__$1 = state_42340;
var statearr_42347_42414 = state_42340__$1;
(statearr_42347_42414[(2)] = null);

(statearr_42347_42414[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (24))){
var inst_42284 = (state_42340[(15)]);
var inst_42287 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_42284);
var inst_42288 = (inst_42287 == null);
var state_42340__$1 = state_42340;
var statearr_42348_42415 = state_42340__$1;
(statearr_42348_42415[(2)] = inst_42288);

(statearr_42348_42415[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (39))){
var inst_42323 = (state_42340[(16)]);
var inst_42314 = (state_42340[(17)]);
var inst_42315 = (state_42340[(18)]);
var inst_42316 = (state_42340[(19)]);
var inst_42273 = (state_42340[(20)]);
var inst_42330 = (state_42340[(2)]);
var inst_42261 = inst_42273;
var inst_42262 = inst_42315;
var inst_42263 = inst_42316;
var inst_42264 = inst_42323;
var inst_42265 = inst_42330;
var inst_42266 = inst_42314;
var state_42340__$1 = (function (){var statearr_42349 = state_42340;
(statearr_42349[(7)] = inst_42265);

(statearr_42349[(8)] = inst_42266);

(statearr_42349[(21)] = inst_42261);

(statearr_42349[(10)] = inst_42264);

(statearr_42349[(11)] = inst_42262);

(statearr_42349[(13)] = inst_42263);

return statearr_42349;
})();
var statearr_42350_42416 = state_42340__$1;
(statearr_42350_42416[(2)] = null);

(statearr_42350_42416[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (4))){
var inst_42145 = (state_42340[(2)]);
var state_42340__$1 = state_42340;
var statearr_42351_42417 = state_42340__$1;
(statearr_42351_42417[(2)] = inst_42145);

(statearr_42351_42417[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (15))){
var inst_42205 = (state_42340[(22)]);
var state_42340__$1 = state_42340;
var statearr_42352_42418 = state_42340__$1;
(statearr_42352_42418[(2)] = inst_42205);

(statearr_42352_42418[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (21))){
var inst_42265 = (state_42340[(7)]);
var inst_42266 = (state_42340[(8)]);
var inst_42173 = (state_42340[(23)]);
var inst_42261 = (state_42340[(21)]);
var inst_42242 = (state_42340[(24)]);
var inst_42167 = (state_42340[(25)]);
var inst_42182 = (state_42340[(9)]);
var inst_42184 = (state_42340[(26)]);
var inst_42272 = (state_42340[(27)]);
var inst_42169 = (state_42340[(28)]);
var inst_42264 = (state_42340[(10)]);
var inst_42152 = (state_42340[(29)]);
var inst_42262 = (state_42340[(11)]);
var inst_42243 = (state_42340[(30)]);
var inst_42233 = (state_42340[(12)]);
var inst_42181 = (state_42340[(31)]);
var inst_42186 = (state_42340[(32)]);
var inst_42192 = (state_42340[(33)]);
var inst_42263 = (state_42340[(13)]);
var inst_42183 = (state_42340[(14)]);
var inst_42273 = (state_42340[(20)]);
var inst_42177 = (state_42340[(34)]);
var inst_42311 = inst_42272.s;
var inst_42312 = fluree.db.flake.sid__GT_cid(inst_42311);
var inst_42313 = (function (){var flakes_bytes = inst_42182;
var t = inst_42152;
var seq__42269 = inst_42273;
var spot = inst_42262;
var add_flakes = inst_42169;
var root_setting_change_QMARK_ = inst_42184;
var vec__42238 = inst_42169;
var vec__42268 = inst_42261;
var ref_QMARK__map = inst_42181;
var r = inst_42273;
var psot = inst_42263;
var first__42240 = inst_42242;
var G__42237 = inst_42261;
var add_pred_to_idx_QMARK_ = inst_42192;
var _ = inst_42167;
var cid = inst_42312;
var ecount = inst_42266;
var pred_ecount = inst_42186;
var first__42270 = inst_42272;
var seq__42239 = inst_42243;
var db_STAR_ = inst_42233;
var schema_change_QMARK_ = inst_42183;
var add_preds = inst_42173;
var opst = inst_42265;
var idx_QMARK__map = inst_42177;
var post = inst_42264;
var f = inst_42272;
return (function (p1__42142_SHARP_){
if(cljs.core.truth_(p1__42142_SHARP_)){
var x__4295__auto__ = p1__42142_SHARP_;
var y__4296__auto__ = f.s;
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
} else {
return f.s;
}
});
})();
var inst_42314 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_42266,inst_42312,inst_42313);
var inst_42315 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42262,inst_42272);
var inst_42316 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42263,inst_42272);
var inst_42317 = inst_42272.p;
var inst_42318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42177,inst_42317);
var state_42340__$1 = (function (){var statearr_42353 = state_42340;
(statearr_42353[(17)] = inst_42314);

(statearr_42353[(18)] = inst_42315);

(statearr_42353[(19)] = inst_42316);

return statearr_42353;
})();
if(cljs.core.truth_(inst_42318)){
var statearr_42354_42419 = state_42340__$1;
(statearr_42354_42419[(1)] = (34));

} else {
var statearr_42355_42420 = state_42340__$1;
(statearr_42355_42420[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (31))){
var inst_42299 = (state_42340[(35)]);
var state_42340__$1 = state_42340;
var statearr_42356_42421 = state_42340__$1;
(statearr_42356_42421[(2)] = inst_42299);

(statearr_42356_42421[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (32))){
var inst_42309 = (state_42340[(2)]);
var state_42340__$1 = state_42340;
var statearr_42357_42422 = state_42340__$1;
(statearr_42357_42422[(2)] = inst_42309);

(statearr_42357_42422[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (33))){
var inst_42299 = (state_42340[(35)]);
var inst_42304 = (state_42340[(2)]);
var inst_42305 = fluree.db.util.async.throw_err(inst_42304);
var inst_42306 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42299,cljs.core.cst$kw$settings,inst_42305);
var state_42340__$1 = state_42340;
var statearr_42358_42423 = state_42340__$1;
(statearr_42358_42423[(2)] = inst_42306);

(statearr_42358_42423[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (13))){
var inst_42182 = (state_42340[(9)]);
var inst_42169 = (state_42340[(28)]);
var inst_42152 = (state_42340[(29)]);
var inst_42233 = (state_42340[(12)]);
var inst_42223 = (state_42340[(2)]);
var inst_42224 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42223,cljs.core.cst$kw$t,inst_42152);
var inst_42225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42226 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_42227 = (new cljs.core.PersistentVector(null,2,(5),inst_42225,inst_42226,null));
var inst_42228 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_42224,inst_42227,cljs.core._PLUS_,inst_42182);
var inst_42229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42230 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_42231 = (new cljs.core.PersistentVector(null,2,(5),inst_42229,inst_42230,null));
var inst_42232 = cljs.core.count(inst_42169);
var inst_42233__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_42228,inst_42231,cljs.core._PLUS_,inst_42232);
var inst_42241 = cljs.core.seq(inst_42169);
var inst_42242 = cljs.core.first(inst_42241);
var inst_42243 = cljs.core.next(inst_42241);
var inst_42244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42245 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_42246 = (new cljs.core.PersistentVector(null,2,(5),inst_42244,inst_42245,null));
var inst_42247 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_42233__$1,inst_42246);
var inst_42248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42249 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_42250 = (new cljs.core.PersistentVector(null,2,(5),inst_42248,inst_42249,null));
var inst_42251 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_42233__$1,inst_42250);
var inst_42252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42253 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_42254 = (new cljs.core.PersistentVector(null,2,(5),inst_42252,inst_42253,null));
var inst_42255 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_42233__$1,inst_42254);
var inst_42256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42257 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_42258 = (new cljs.core.PersistentVector(null,2,(5),inst_42256,inst_42257,null));
var inst_42259 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_42233__$1,inst_42258);
var inst_42260 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_42261 = inst_42169;
var inst_42262 = inst_42247;
var inst_42263 = inst_42251;
var inst_42264 = inst_42255;
var inst_42265 = inst_42259;
var inst_42266 = inst_42260;
var state_42340__$1 = (function (){var statearr_42359 = state_42340;
(statearr_42359[(7)] = inst_42265);

(statearr_42359[(8)] = inst_42266);

(statearr_42359[(21)] = inst_42261);

(statearr_42359[(24)] = inst_42242);

(statearr_42359[(10)] = inst_42264);

(statearr_42359[(11)] = inst_42262);

(statearr_42359[(30)] = inst_42243);

(statearr_42359[(12)] = inst_42233__$1);

(statearr_42359[(13)] = inst_42263);

return statearr_42359;
})();
var statearr_42360_42424 = state_42340__$1;
(statearr_42360_42424[(2)] = null);

(statearr_42360_42424[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (22))){
var inst_42333 = (state_42340[(2)]);
var state_42340__$1 = state_42340;
var statearr_42361_42425 = state_42340__$1;
(statearr_42361_42425[(2)] = inst_42333);

(statearr_42361_42425[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (36))){
var inst_42272 = (state_42340[(27)]);
var inst_42181 = (state_42340[(31)]);
var inst_42323 = (state_42340[(2)]);
var inst_42324 = inst_42272.p;
var inst_42325 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42181,inst_42324);
var state_42340__$1 = (function (){var statearr_42362 = state_42340;
(statearr_42362[(16)] = inst_42323);

return statearr_42362;
})();
if(cljs.core.truth_(inst_42325)){
var statearr_42363_42426 = state_42340__$1;
(statearr_42363_42426[(1)] = (37));

} else {
var statearr_42364_42427 = state_42340__$1;
(statearr_42364_42427[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (29))){
var inst_42284 = (state_42340[(15)]);
var inst_42294 = (state_42340[(2)]);
var inst_42295 = fluree.db.util.async.throw_err(inst_42294);
var inst_42296 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42284,cljs.core.cst$kw$schema,inst_42295);
var state_42340__$1 = state_42340;
var statearr_42365_42428 = state_42340__$1;
(statearr_42365_42428[(2)] = inst_42296);

(statearr_42365_42428[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (6))){
var inst_42152 = (state_42340[(29)]);
var inst_42157 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_42158 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_42159 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42157)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42158)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42152),"."].join('');
var inst_42160 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42161 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_42162 = cljs.core.PersistentHashMap.fromArrays(inst_42160,inst_42161);
var inst_42163 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42159,inst_42162);
var inst_42164 = (function(){throw inst_42163})();
var state_42340__$1 = state_42340;
var statearr_42366_42429 = state_42340__$1;
(statearr_42366_42429[(2)] = inst_42164);

(statearr_42366_42429[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (28))){
var inst_42184 = (state_42340[(26)]);
var inst_42299 = (state_42340[(2)]);
var state_42340__$1 = (function (){var statearr_42367 = state_42340;
(statearr_42367[(35)] = inst_42299);

return statearr_42367;
})();
if(cljs.core.truth_(inst_42184)){
var statearr_42368_42430 = state_42340__$1;
(statearr_42368_42430[(1)] = (30));

} else {
var statearr_42369_42431 = state_42340__$1;
(statearr_42369_42431[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (25))){
var inst_42290 = (state_42340[(2)]);
var state_42340__$1 = state_42340;
if(cljs.core.truth_(inst_42290)){
var statearr_42370_42432 = state_42340__$1;
(statearr_42370_42432[(1)] = (26));

} else {
var statearr_42371_42433 = state_42340__$1;
(statearr_42371_42433[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (34))){
var inst_42272 = (state_42340[(27)]);
var inst_42264 = (state_42340[(10)]);
var inst_42320 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42264,inst_42272);
var state_42340__$1 = state_42340;
var statearr_42372_42434 = state_42340__$1;
(statearr_42372_42434[(2)] = inst_42320);

(statearr_42372_42434[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (17))){
var inst_42212 = (state_42340[(36)]);
var inst_42216 = (state_42340[(2)]);
var inst_42217 = fluree.db.util.async.throw_err(inst_42216);
var inst_42204 = inst_42212;
var inst_42205 = inst_42217;
var state_42340__$1 = (function (){var statearr_42373 = state_42340;
(statearr_42373[(22)] = inst_42205);

(statearr_42373[(37)] = inst_42204);

return statearr_42373;
})();
var statearr_42374_42435 = state_42340__$1;
(statearr_42374_42435[(2)] = null);

(statearr_42374_42435[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (3))){
var inst_42338 = (state_42340[(2)]);
var state_42340__$1 = state_42340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42340__$1,inst_42338);
} else {
if((state_val_42341 === (12))){
var inst_42211 = (state_42340[(38)]);
var inst_42204 = (state_42340[(37)]);
var inst_42210 = cljs.core.seq(inst_42204);
var inst_42211__$1 = cljs.core.first(inst_42210);
var inst_42212 = cljs.core.next(inst_42210);
var state_42340__$1 = (function (){var statearr_42375 = state_42340;
(statearr_42375[(38)] = inst_42211__$1);

(statearr_42375[(36)] = inst_42212);

return statearr_42375;
})();
if(cljs.core.truth_(inst_42211__$1)){
var statearr_42376_42436 = state_42340__$1;
(statearr_42376_42436[(1)] = (14));

} else {
var statearr_42377_42437 = state_42340__$1;
(statearr_42377_42437[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (2))){
var inst_42152 = (state_42340[(29)]);
var _ = (function (){var statearr_42378 = state_42340;
(statearr_42378[(4)] = cljs.core.cons((5),(state_42340[(4)])));

return statearr_42378;
})();
var inst_42151 = cljs.core.first(flakes);
var inst_42152__$1 = inst_42151.t;
var inst_42153 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_42154 = (inst_42153 - (1));
var inst_42155 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_42152__$1,inst_42154);
var state_42340__$1 = (function (){var statearr_42379 = state_42340;
(statearr_42379[(29)] = inst_42152__$1);

return statearr_42379;
})();
if(inst_42155){
var statearr_42380_42438 = state_42340__$1;
(statearr_42380_42438[(1)] = (6));

} else {
var statearr_42381_42439 = state_42340__$1;
(statearr_42381_42439[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (23))){
var inst_42183 = (state_42340[(14)]);
var state_42340__$1 = state_42340;
var statearr_42382_42440 = state_42340__$1;
(statearr_42382_42440[(2)] = inst_42183);

(statearr_42382_42440[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (35))){
var inst_42264 = (state_42340[(10)]);
var state_42340__$1 = state_42340;
var statearr_42383_42441 = state_42340__$1;
(statearr_42383_42441[(2)] = inst_42264);

(statearr_42383_42441[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (19))){
var inst_42335 = (state_42340[(2)]);
var _ = (function (){var statearr_42384 = state_42340;
(statearr_42384[(4)] = cljs.core.rest((state_42340[(4)])));

return statearr_42384;
})();
var state_42340__$1 = state_42340;
var statearr_42385_42442 = state_42340__$1;
(statearr_42385_42442[(2)] = inst_42335);

(statearr_42385_42442[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (11))){
var inst_42192 = (state_42340[(33)]);
var inst_42192__$1 = (state_42340[(2)]);
var inst_42200 = cljs.core.seq(inst_42192__$1);
var inst_42201 = cljs.core.first(inst_42200);
var inst_42202 = cljs.core.next(inst_42200);
var inst_42203 = db;
var inst_42204 = inst_42192__$1;
var inst_42205 = inst_42203;
var state_42340__$1 = (function (){var statearr_42387 = state_42340;
(statearr_42387[(39)] = inst_42201);

(statearr_42387[(22)] = inst_42205);

(statearr_42387[(40)] = inst_42202);

(statearr_42387[(33)] = inst_42192__$1);

(statearr_42387[(37)] = inst_42204);

return statearr_42387;
})();
var statearr_42388_42443 = state_42340__$1;
(statearr_42388_42443[(2)] = null);

(statearr_42388_42443[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (9))){
var inst_42169 = (state_42340[(28)]);
var inst_42186 = (state_42340[(32)]);
var inst_42188 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_42169,inst_42186);
var state_42340__$1 = state_42340;
var statearr_42389_42444 = state_42340__$1;
(statearr_42389_42444[(2)] = inst_42188);

(statearr_42389_42444[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (5))){
var _ = (function (){var statearr_42390 = state_42340;
(statearr_42390[(4)] = cljs.core.rest((state_42340[(4)])));

return statearr_42390;
})();
var state_42340__$1 = state_42340;
var ex42386 = (state_42340__$1[(2)]);
var statearr_42391_42445 = state_42340__$1;
(statearr_42391_42445[(5)] = ex42386);


if((ex42386 instanceof Error)){
var statearr_42392_42446 = state_42340__$1;
(statearr_42392_42446[(1)] = (4));

(statearr_42392_42446[(5)] = null);

} else {
throw ex42386;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (14))){
var inst_42211 = (state_42340[(38)]);
var inst_42205 = (state_42340[(22)]);
var inst_42214 = fluree.db.graphdb.add_predicate_to_idx(inst_42205,inst_42211,opts);
var state_42340__$1 = state_42340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42340__$1,(17),inst_42214);
} else {
if((state_val_42341 === (26))){
var inst_42284 = (state_42340[(15)]);
var inst_42292 = fluree.db.query.schema.schema_map(inst_42284);
var state_42340__$1 = state_42340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42340__$1,(29),inst_42292);
} else {
if((state_val_42341 === (16))){
var inst_42221 = (state_42340[(2)]);
var state_42340__$1 = state_42340;
var statearr_42393_42447 = state_42340__$1;
(statearr_42393_42447[(2)] = inst_42221);

(statearr_42393_42447[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (38))){
var inst_42265 = (state_42340[(7)]);
var state_42340__$1 = state_42340;
var statearr_42394_42448 = state_42340__$1;
(statearr_42394_42448[(2)] = inst_42265);

(statearr_42394_42448[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (30))){
var inst_42299 = (state_42340[(35)]);
var inst_42302 = fluree.db.query.schema.setting_map(inst_42299);
var state_42340__$1 = state_42340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42340__$1,(33),inst_42302);
} else {
if((state_val_42341 === (10))){
var inst_42190 = cljs.core.PersistentVector.EMPTY;
var state_42340__$1 = state_42340;
var statearr_42395_42449 = state_42340__$1;
(statearr_42395_42449[(2)] = inst_42190);

(statearr_42395_42449[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (18))){
var inst_42261 = (state_42340[(21)]);
var inst_42272 = (state_42340[(27)]);
var inst_42271 = cljs.core.seq(inst_42261);
var inst_42272__$1 = cljs.core.first(inst_42271);
var inst_42273 = cljs.core.next(inst_42271);
var inst_42274 = cljs.core.not(inst_42272__$1);
var state_42340__$1 = (function (){var statearr_42396 = state_42340;
(statearr_42396[(27)] = inst_42272__$1);

(statearr_42396[(20)] = inst_42273);

return statearr_42396;
})();
if(inst_42274){
var statearr_42397_42450 = state_42340__$1;
(statearr_42397_42450[(1)] = (20));

} else {
var statearr_42398_42451 = state_42340__$1;
(statearr_42398_42451[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (37))){
var inst_42265 = (state_42340[(7)]);
var inst_42272 = (state_42340[(27)]);
var inst_42327 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42265,inst_42272);
var state_42340__$1 = state_42340;
var statearr_42399_42452 = state_42340__$1;
(statearr_42399_42452[(2)] = inst_42327);

(statearr_42399_42452[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42341 === (8))){
var inst_42173 = (state_42340[(23)]);
var inst_42167 = (state_42340[(25)]);
var inst_42169 = (state_42340[(28)]);
var inst_42152 = (state_42340[(29)]);
var inst_42183 = (state_42340[(14)]);
var inst_42177 = (state_42340[(34)]);
var inst_42167__$1 = (state_42340[(2)]);
var inst_42168 = (function (){var t = inst_42152;
var _ = inst_42167__$1;
return (function (p1__42140_SHARP_){
return cljs.core.not((function (){var G__42400 = p1__42140_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__42400) : fluree.db.graphdb.exclude_predicates.call(null,G__42400));
})());
});
})();
var inst_42169__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_42168,flakes);
var inst_42170 = cljs.core.PersistentHashSet.EMPTY;
var inst_42171 = (function (){var t = inst_42152;
var _ = inst_42167__$1;
var add_flakes = inst_42169__$1;
return (function (p1__42141_SHARP_){
return p1__42141_SHARP_.p;
});
})();
var inst_42172 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_42171,inst_42169__$1);
var inst_42173__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_42170,inst_42172);
var inst_42174 = cljs.core.PersistentHashMap.EMPTY;
var inst_42175 = (function (){var t = inst_42152;
var _ = inst_42167__$1;
var add_flakes = inst_42169__$1;
var add_preds = inst_42173__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_42176 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_42175,inst_42173__$1);
var inst_42177__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_42174,inst_42176);
var inst_42178 = cljs.core.PersistentHashMap.EMPTY;
var inst_42179 = (function (){var t = inst_42152;
var _ = inst_42167__$1;
var add_flakes = inst_42169__$1;
var add_preds = inst_42173__$1;
var idx_QMARK__map = inst_42177__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_42180 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_42179,inst_42173__$1);
var inst_42181 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_42178,inst_42180);
var inst_42182 = fluree.db.flake.size_bytes(inst_42169__$1);
var inst_42183__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_42169__$1);
var inst_42184 = fluree.db.util.schema.setting_change_QMARK_(inst_42169__$1);
var inst_42185 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_42186 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42185,(0));
var state_42340__$1 = (function (){var statearr_42401 = state_42340;
(statearr_42401[(23)] = inst_42173__$1);

(statearr_42401[(25)] = inst_42167__$1);

(statearr_42401[(9)] = inst_42182);

(statearr_42401[(26)] = inst_42184);

(statearr_42401[(28)] = inst_42169__$1);

(statearr_42401[(31)] = inst_42181);

(statearr_42401[(32)] = inst_42186);

(statearr_42401[(14)] = inst_42183__$1);

(statearr_42401[(34)] = inst_42177__$1);

return statearr_42401;
})();
if(cljs.core.truth_(inst_42183__$1)){
var statearr_42402_42453 = state_42340__$1;
(statearr_42402_42453[(1)] = (9));

} else {
var statearr_42403_42454 = state_42340__$1;
(statearr_42403_42454[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16395__auto__ = null;
var fluree$db$graphdb$state_machine__16395__auto____0 = (function (){
var statearr_42404 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42404[(0)] = fluree$db$graphdb$state_machine__16395__auto__);

(statearr_42404[(1)] = (1));

return statearr_42404;
});
var fluree$db$graphdb$state_machine__16395__auto____1 = (function (state_42340){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_42340);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e42405){var ex__16398__auto__ = e42405;
var statearr_42406_42455 = state_42340;
(statearr_42406_42455[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_42340[(4)]))){
var statearr_42407_42456 = state_42340;
(statearr_42407_42456[(1)] = cljs.core.first((state_42340[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__42457 = state_42340;
state_42340 = G__42457;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16395__auto__ = function(state_42340){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16395__auto____1.call(this,state_42340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16395__auto____0;
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16395__auto____1;
return fluree$db$graphdb$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_42408 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_42408[(6)] = c__16469__auto__);

return statearr_42408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__42459 = arguments.length;
switch (G__42459) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___42606 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_42555){
var state_val_42556 = (state_42555[(1)]);
if((state_val_42556 === (7))){
var state_42555__$1 = state_42555;
var statearr_42557_42607 = state_42555__$1;
(statearr_42557_42607[(2)] = null);

(statearr_42557_42607[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (20))){
var inst_42505 = (state_42555[(7)]);
var inst_42504 = (state_42555[(8)]);
var inst_42503 = (state_42555[(9)]);
var inst_42524 = (inst_42503 + (1));
var inst_42525 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42505,cljs.core.cst$kw$t,inst_42524);
var inst_42526 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_42525,inst_42504,opts);
var state_42555__$1 = state_42555;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42555__$1,(23),inst_42526);
} else {
if((state_val_42556 === (1))){
var state_42555__$1 = state_42555;
var statearr_42558_42608 = state_42555__$1;
(statearr_42558_42608[(2)] = null);

(statearr_42558_42608[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (24))){
var inst_42529 = (state_42555[(10)]);
var inst_42532 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42529,cljs.core.cst$kw$block,block);
var state_42555__$1 = state_42555;
var statearr_42559_42609 = state_42555__$1;
(statearr_42559_42609[(2)] = inst_42532);

(statearr_42559_42609[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (4))){
var inst_42460 = (state_42555[(2)]);
var inst_42461 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_42460);
var state_42555__$1 = state_42555;
var statearr_42560_42610 = state_42555__$1;
(statearr_42560_42610[(2)] = inst_42461);

(statearr_42560_42610[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (15))){
var inst_42511 = (state_42555[(11)]);
var state_42555__$1 = state_42555;
var statearr_42561_42611 = state_42555__$1;
(statearr_42561_42611[(2)] = inst_42511);

(statearr_42561_42611[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (21))){
var state_42555__$1 = state_42555;
var statearr_42562_42612 = state_42555__$1;
(statearr_42562_42612[(2)] = null);

(statearr_42562_42612[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (13))){
var inst_42547 = (state_42555[(2)]);
var inst_42548 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_42547);
var state_42555__$1 = state_42555;
var statearr_42563_42613 = state_42555__$1;
(statearr_42563_42613[(2)] = inst_42548);

(statearr_42563_42613[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (22))){
var inst_42543 = (state_42555[(2)]);
var state_42555__$1 = state_42555;
var statearr_42564_42614 = state_42555__$1;
(statearr_42564_42614[(2)] = inst_42543);

(statearr_42564_42614[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (6))){
var inst_42471 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_42472 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_42473 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42471)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42472)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_42474 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42475 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_42476 = cljs.core.PersistentHashMap.fromArrays(inst_42474,inst_42475);
var inst_42477 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42473,inst_42476);
var inst_42478 = (function(){throw inst_42477})();
var state_42555__$1 = state_42555;
var statearr_42567_42615 = state_42555__$1;
(statearr_42567_42615[(2)] = inst_42478);

(statearr_42567_42615[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (25))){
var inst_42512 = (state_42555[(12)]);
var inst_42529 = (state_42555[(10)]);
var inst_42511 = (state_42555[(11)]);
var inst_42534 = inst_42511.t;
var inst_42535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42536 = [inst_42511];
var inst_42537 = (new cljs.core.PersistentVector(null,1,(5),inst_42535,inst_42536,null));
var inst_42502 = inst_42512;
var inst_42503 = inst_42534;
var inst_42504 = inst_42537;
var inst_42505 = inst_42529;
var state_42555__$1 = (function (){var statearr_42568 = state_42555;
(statearr_42568[(7)] = inst_42505);

(statearr_42568[(13)] = inst_42502);

(statearr_42568[(8)] = inst_42504);

(statearr_42568[(9)] = inst_42503);

return statearr_42568;
})();
var statearr_42569_42616 = state_42555__$1;
(statearr_42569_42616[(2)] = null);

(statearr_42569_42616[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (17))){
var inst_42512 = (state_42555[(12)]);
var inst_42505 = (state_42555[(7)]);
var inst_42504 = (state_42555[(8)]);
var inst_42503 = (state_42555[(9)]);
var inst_42511 = (state_42555[(11)]);
var inst_42520 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42504,inst_42511);
var tmp42565 = inst_42505;
var tmp42566 = inst_42503;
var inst_42502 = inst_42512;
var inst_42503__$1 = tmp42566;
var inst_42504__$1 = inst_42520;
var inst_42505__$1 = tmp42565;
var state_42555__$1 = (function (){var statearr_42570 = state_42555;
(statearr_42570[(7)] = inst_42505__$1);

(statearr_42570[(13)] = inst_42502);

(statearr_42570[(8)] = inst_42504__$1);

(statearr_42570[(9)] = inst_42503__$1);

return statearr_42570;
})();
var statearr_42571_42617 = state_42555__$1;
(statearr_42571_42617[(2)] = null);

(statearr_42571_42617[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (3))){
var inst_42553 = (state_42555[(2)]);
var state_42555__$1 = state_42555;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42555__$1,inst_42553);
} else {
if((state_val_42556 === (12))){
var inst_42502 = (state_42555[(13)]);
var inst_42511 = (state_42555[(11)]);
var inst_42510 = cljs.core.seq(inst_42502);
var inst_42511__$1 = cljs.core.first(inst_42510);
var inst_42512 = cljs.core.next(inst_42510);
var state_42555__$1 = (function (){var statearr_42572 = state_42555;
(statearr_42572[(12)] = inst_42512);

(statearr_42572[(11)] = inst_42511__$1);

return statearr_42572;
})();
if(cljs.core.truth_(inst_42511__$1)){
var statearr_42573_42618 = state_42555__$1;
(statearr_42573_42618[(1)] = (14));

} else {
var statearr_42574_42619 = state_42555__$1;
(statearr_42574_42619[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (2))){
var _ = (function (){var statearr_42575 = state_42555;
(statearr_42575[(4)] = cljs.core.cons((5),(state_42555[(4)])));

return statearr_42575;
})();
var inst_42467 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_42468 = (inst_42467 + (1));
var inst_42469 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_42468);
var state_42555__$1 = state_42555;
if(inst_42469){
var statearr_42576_42620 = state_42555__$1;
(statearr_42576_42620[(1)] = (6));

} else {
var statearr_42577_42621 = state_42555__$1;
(statearr_42577_42621[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (23))){
var inst_42511 = (state_42555[(11)]);
var inst_42528 = (state_42555[(2)]);
var inst_42529 = fluree.db.util.async.throw_err(inst_42528);
var inst_42530 = (inst_42511 == null);
var state_42555__$1 = (function (){var statearr_42578 = state_42555;
(statearr_42578[(10)] = inst_42529);

return statearr_42578;
})();
if(cljs.core.truth_(inst_42530)){
var statearr_42579_42622 = state_42555__$1;
(statearr_42579_42622[(1)] = (24));

} else {
var statearr_42580_42623 = state_42555__$1;
(statearr_42580_42623[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (19))){
var inst_42545 = (state_42555[(2)]);
var state_42555__$1 = state_42555;
var statearr_42581_42624 = state_42555__$1;
(statearr_42581_42624[(2)] = inst_42545);

(statearr_42581_42624[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (11))){
var inst_42550 = (state_42555[(2)]);
var _ = (function (){var statearr_42583 = state_42555;
(statearr_42583[(4)] = cljs.core.rest((state_42555[(4)])));

return statearr_42583;
})();
var state_42555__$1 = state_42555;
var statearr_42584_42625 = state_42555__$1;
(statearr_42584_42625[(2)] = inst_42550);

(statearr_42584_42625[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (9))){
var inst_42484 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_42485 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_42484);
var state_42555__$1 = state_42555;
var statearr_42585_42626 = state_42555__$1;
(statearr_42585_42626[(2)] = inst_42485);

(statearr_42585_42626[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (5))){
var _ = (function (){var statearr_42586 = state_42555;
(statearr_42586[(4)] = cljs.core.rest((state_42555[(4)])));

return statearr_42586;
})();
var state_42555__$1 = state_42555;
var ex42582 = (state_42555__$1[(2)]);
var statearr_42587_42627 = state_42555__$1;
(statearr_42587_42627[(5)] = ex42582);


var statearr_42588_42628 = state_42555__$1;
(statearr_42588_42628[(1)] = (4));

(statearr_42588_42628[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (14))){
var inst_42503 = (state_42555[(9)]);
var inst_42511 = (state_42555[(11)]);
var inst_42514 = inst_42511.t;
var inst_42515 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42503,inst_42514);
var state_42555__$1 = state_42555;
var statearr_42589_42629 = state_42555__$1;
(statearr_42589_42629[(2)] = inst_42515);

(statearr_42589_42629[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (26))){
var inst_42540 = (state_42555[(2)]);
var state_42555__$1 = state_42555;
var statearr_42590_42630 = state_42555__$1;
(statearr_42590_42630[(2)] = inst_42540);

(statearr_42590_42630[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (16))){
var inst_42518 = (state_42555[(2)]);
var state_42555__$1 = state_42555;
if(cljs.core.truth_(inst_42518)){
var statearr_42591_42631 = state_42555__$1;
(statearr_42591_42631[(1)] = (17));

} else {
var statearr_42592_42632 = state_42555__$1;
(statearr_42592_42632[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (10))){
var inst_42487 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_42488 = cljs.core.first(inst_42487);
var inst_42496 = cljs.core.seq(inst_42487);
var inst_42497 = cljs.core.first(inst_42496);
var inst_42498 = cljs.core.next(inst_42496);
var inst_42499 = inst_42488.t;
var inst_42500 = cljs.core.PersistentVector.EMPTY;
var inst_42501 = db;
var inst_42502 = inst_42487;
var inst_42503 = inst_42499;
var inst_42504 = inst_42500;
var inst_42505 = inst_42501;
var state_42555__$1 = (function (){var statearr_42593 = state_42555;
(statearr_42593[(14)] = inst_42498);

(statearr_42593[(7)] = inst_42505);

(statearr_42593[(13)] = inst_42502);

(statearr_42593[(8)] = inst_42504);

(statearr_42593[(9)] = inst_42503);

(statearr_42593[(15)] = inst_42497);

return statearr_42593;
})();
var statearr_42594_42633 = state_42555__$1;
(statearr_42594_42633[(2)] = null);

(statearr_42594_42633[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (18))){
var state_42555__$1 = state_42555;
var statearr_42595_42634 = state_42555__$1;
(statearr_42595_42634[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42556 === (8))){
var inst_42481 = (state_42555[(2)]);
var inst_42482 = cljs.core.empty_QMARK_(flakes);
var state_42555__$1 = (function (){var statearr_42597 = state_42555;
(statearr_42597[(16)] = inst_42481);

return statearr_42597;
})();
if(inst_42482){
var statearr_42598_42635 = state_42555__$1;
(statearr_42598_42635[(1)] = (9));

} else {
var statearr_42599_42636 = state_42555__$1;
(statearr_42599_42636[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16395__auto__ = null;
var fluree$db$graphdb$state_machine__16395__auto____0 = (function (){
var statearr_42600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42600[(0)] = fluree$db$graphdb$state_machine__16395__auto__);

(statearr_42600[(1)] = (1));

return statearr_42600;
});
var fluree$db$graphdb$state_machine__16395__auto____1 = (function (state_42555){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_42555);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e42601){var ex__16398__auto__ = e42601;
var statearr_42602_42637 = state_42555;
(statearr_42602_42637[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_42555[(4)]))){
var statearr_42603_42638 = state_42555;
(statearr_42603_42638[(1)] = cljs.core.first((state_42555[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__42639 = state_42555;
state_42555 = G__42639;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16395__auto__ = function(state_42555){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16395__auto____1.call(this,state_42555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16395__auto____0;
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16395__auto____1;
return fluree$db$graphdb$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_42604 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_42604[(6)] = c__16469__auto___42606);

return statearr_42604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_42695){
var state_val_42696 = (state_42695[(1)]);
if((state_val_42696 === (7))){
var state_42695__$1 = state_42695;
var statearr_42697_42724 = state_42695__$1;
(statearr_42697_42724[(2)] = tt_id);

(statearr_42697_42724[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42696 === (1))){
var state_42695__$1 = state_42695;
var statearr_42698_42725 = state_42695__$1;
(statearr_42698_42725[(2)] = null);

(statearr_42698_42725[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42696 === (4))){
var inst_42640 = (state_42695[(2)]);
var state_42695__$1 = state_42695;
var statearr_42699_42726 = state_42695__$1;
(statearr_42699_42726[(2)] = inst_42640);

(statearr_42699_42726[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42696 === (13))){
var inst_42688 = (state_42695[(2)]);
var state_42695__$1 = state_42695;
var statearr_42700_42727 = state_42695__$1;
(statearr_42700_42727[(2)] = inst_42688);

(statearr_42700_42727[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42696 === (6))){
var inst_42648 = fluree.db.util.core.random_uuid();
var state_42695__$1 = state_42695;
var statearr_42701_42728 = state_42695__$1;
(statearr_42701_42728[(2)] = inst_42648);

(statearr_42701_42728[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42696 === (3))){
var inst_42693 = (state_42695[(2)]);
var state_42695__$1 = state_42695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42695__$1,inst_42693);
} else {
if((state_val_42696 === (12))){
var inst_42671 = (state_42695[(7)]);
var state_42695__$1 = state_42695;
var statearr_42702_42729 = state_42695__$1;
(statearr_42702_42729[(2)] = inst_42671);

(statearr_42702_42729[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42696 === (2))){
var _ = (function (){var statearr_42703 = state_42695;
(statearr_42703[(4)] = cljs.core.cons((5),(state_42695[(4)])));

return statearr_42703;
})();
var inst_42646 = (tt_id == null);
var state_42695__$1 = state_42695;
if(cljs.core.truth_(inst_42646)){
var statearr_42704_42730 = state_42695__$1;
(statearr_42704_42730[(1)] = (6));

} else {
var statearr_42705_42731 = state_42695__$1;
(statearr_42705_42731[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42696 === (11))){
var inst_42671 = (state_42695[(7)]);
var inst_42678 = (state_42695[(8)]);
var inst_42681 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_42671,inst_42678);
var state_42695__$1 = state_42695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42695__$1,(14),inst_42681);
} else {
if((state_val_42696 === (9))){
var inst_42672 = (state_42695[(9)]);
var inst_42678 = (state_42695[(8)]);
var inst_42677 = cljs.core.seq(inst_42672);
var inst_42678__$1 = cljs.core.first(inst_42677);
var inst_42679 = cljs.core.next(inst_42677);
var state_42695__$1 = (function (){var statearr_42707 = state_42695;
(statearr_42707[(10)] = inst_42679);

(statearr_42707[(8)] = inst_42678__$1);

return statearr_42707;
})();
if(cljs.core.truth_(inst_42678__$1)){
var statearr_42708_42732 = state_42695__$1;
(statearr_42708_42732[(1)] = (11));

} else {
var statearr_42709_42733 = state_42695__$1;
(statearr_42709_42733[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42696 === (5))){
var _ = (function (){var statearr_42710 = state_42695;
(statearr_42710[(4)] = cljs.core.rest((state_42695[(4)])));

return statearr_42710;
})();
var state_42695__$1 = state_42695;
var ex42706 = (state_42695__$1[(2)]);
var statearr_42711_42734 = state_42695__$1;
(statearr_42711_42734[(5)] = ex42706);


if((ex42706 instanceof Error)){
var statearr_42712_42735 = state_42695__$1;
(statearr_42712_42735[(1)] = (4));

(statearr_42712_42735[(5)] = null);

} else {
throw ex42706;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42696 === (14))){
var inst_42679 = (state_42695[(10)]);
var inst_42683 = (state_42695[(2)]);
var inst_42684 = fluree.db.util.async.throw_err(inst_42683);
var inst_42671 = inst_42684;
var inst_42672 = inst_42679;
var state_42695__$1 = (function (){var statearr_42713 = state_42695;
(statearr_42713[(7)] = inst_42671);

(statearr_42713[(9)] = inst_42672);

return statearr_42713;
})();
var statearr_42714_42736 = state_42695__$1;
(statearr_42714_42736[(2)] = null);

(statearr_42714_42736[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42696 === (10))){
var inst_42690 = (state_42695[(2)]);
var _ = (function (){var statearr_42715 = state_42695;
(statearr_42715[(4)] = cljs.core.rest((state_42695[(4)])));

return statearr_42715;
})();
var state_42695__$1 = state_42695;
var statearr_42716_42737 = state_42695__$1;
(statearr_42716_42737[(2)] = inst_42690);

(statearr_42716_42737[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42696 === (8))){
var inst_42651 = (state_42695[(2)]);
var inst_42652 = (function (){var tt_id_SINGLEQUOTE_ = inst_42651;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_42653 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_42651);
var inst_42654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42655 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_42656 = (new cljs.core.PersistentVector(null,4,(5),inst_42654,inst_42655,null));
var inst_42657 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_42652,inst_42653,inst_42656);
var inst_42658 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_42659 = cljs.core.reverse(inst_42658);
var inst_42660 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_42659);
var inst_42668 = cljs.core.seq(inst_42660);
var inst_42669 = cljs.core.first(inst_42668);
var inst_42670 = cljs.core.next(inst_42668);
var inst_42671 = inst_42657;
var inst_42672 = inst_42660;
var state_42695__$1 = (function (){var statearr_42717 = state_42695;
(statearr_42717[(7)] = inst_42671);

(statearr_42717[(9)] = inst_42672);

(statearr_42717[(11)] = inst_42670);

(statearr_42717[(12)] = inst_42669);

return statearr_42717;
})();
var statearr_42718_42738 = state_42695__$1;
(statearr_42718_42738[(2)] = null);

(statearr_42718_42738[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto____0 = (function (){
var statearr_42719 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42719[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto__);

(statearr_42719[(1)] = (1));

return statearr_42719;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto____1 = (function (state_42695){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_42695);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e42720){var ex__16398__auto__ = e42720;
var statearr_42721_42739 = state_42695;
(statearr_42721_42739[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_42695[(4)]))){
var statearr_42722_42740 = state_42695;
(statearr_42722_42740[(1)] = cljs.core.first((state_42695[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__42741 = state_42695;
state_42695 = G__42741;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto__ = function(state_42695){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto____1.call(this,state_42695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_42723 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_42723[(6)] = c__16469__auto__);

return statearr_42723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___42928 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_42859){
var state_val_42860 = (state_42859[(1)]);
if((state_val_42860 === (7))){
var inst_42769 = (state_42859[(7)]);
var inst_42769__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_42859__$1 = (function (){var statearr_42861 = state_42859;
(statearr_42861[(7)] = inst_42769__$1);

return statearr_42861;
})();
if(inst_42769__$1){
var statearr_42862_42929 = state_42859__$1;
(statearr_42862_42929[(1)] = (13));

} else {
var statearr_42863_42930 = state_42859__$1;
(statearr_42863_42930[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (20))){
var state_42859__$1 = state_42859;
var statearr_42864_42931 = state_42859__$1;
(statearr_42864_42931[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (27))){
var inst_42805 = (state_42859[(8)]);
var inst_42809 = inst_42805.s;
var state_42859__$1 = state_42859;
var statearr_42866_42932 = state_42859__$1;
(statearr_42866_42932[(2)] = inst_42809);

(statearr_42866_42932[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (1))){
var state_42859__$1 = state_42859;
var statearr_42867_42933 = state_42859__$1;
(statearr_42867_42933[(2)] = null);

(statearr_42867_42933[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (24))){
var inst_42799 = (state_42859[(9)]);
var inst_42803 = cljs.core.first(inst_42799);
var state_42859__$1 = state_42859;
var statearr_42868_42934 = state_42859__$1;
(statearr_42868_42934[(2)] = inst_42803);

(statearr_42868_42934[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (39))){
var state_42859__$1 = state_42859;
var statearr_42869_42935 = state_42859__$1;
(statearr_42869_42935[(1)] = (41));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (4))){
var inst_42742 = (state_42859[(2)]);
var inst_42743 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_42744 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42745 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_42746 = cljs.core.PersistentHashMap.fromArrays(inst_42744,inst_42745);
var inst_42747 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_42743,inst_42746,inst_42742);
var inst_42748 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_42747);
var state_42859__$1 = state_42859;
var statearr_42871_42936 = state_42859__$1;
(statearr_42871_42936[(2)] = inst_42748);

(statearr_42871_42936[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (15))){
var inst_42776 = (state_42859[(2)]);
var state_42859__$1 = state_42859;
if(cljs.core.truth_(inst_42776)){
var statearr_42872_42937 = state_42859__$1;
(statearr_42872_42937[(1)] = (16));

} else {
var statearr_42873_42938 = state_42859__$1;
(statearr_42873_42938[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (21))){
var inst_42825 = (state_42859[(2)]);
var state_42859__$1 = state_42859;
var statearr_42874_42939 = state_42859__$1;
(statearr_42874_42939[(2)] = inst_42825);

(statearr_42874_42939[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (31))){
var inst_42823 = (state_42859[(2)]);
var state_42859__$1 = state_42859;
var statearr_42875_42940 = state_42859__$1;
(statearr_42875_42940[(2)] = inst_42823);

(statearr_42875_42940[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (32))){
var inst_42829 = (state_42859[(10)]);
var inst_42831 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_42829);
var state_42859__$1 = state_42859;
var statearr_42876_42941 = state_42859__$1;
(statearr_42876_42941[(2)] = inst_42831);

(statearr_42876_42941[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (40))){
var inst_42852 = (state_42859[(2)]);
var state_42859__$1 = state_42859;
var statearr_42877_42942 = state_42859__$1;
(statearr_42877_42942[(2)] = inst_42852);

(statearr_42877_42942[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (33))){
var inst_42833 = (state_42859[(11)]);
var inst_42829 = (state_42859[(10)]);
var inst_42833__$1 = (inst_42829 == null);
var state_42859__$1 = (function (){var statearr_42878 = state_42859;
(statearr_42878[(11)] = inst_42833__$1);

return statearr_42878;
})();
if(cljs.core.truth_(inst_42833__$1)){
var statearr_42879_42943 = state_42859__$1;
(statearr_42879_42943[(1)] = (35));

} else {
var statearr_42880_42944 = state_42859__$1;
(statearr_42880_42944[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (13))){
var inst_42771 = cljs.core.first(ident);
var inst_42772 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_42771);
var inst_42773 = (inst_42772 == null);
var state_42859__$1 = state_42859;
var statearr_42881_42945 = state_42859__$1;
(statearr_42881_42945[(2)] = inst_42773);

(statearr_42881_42945[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (22))){
var inst_42799 = (state_42859[(9)]);
var inst_42798 = (state_42859[(2)]);
var inst_42799__$1 = fluree.db.util.async.throw_err(inst_42798);
var inst_42800 = (inst_42799__$1 == null);
var state_42859__$1 = (function (){var statearr_42882 = state_42859;
(statearr_42882[(9)] = inst_42799__$1);

return statearr_42882;
})();
if(cljs.core.truth_(inst_42800)){
var statearr_42883_42946 = state_42859__$1;
(statearr_42883_42946[(1)] = (23));

} else {
var statearr_42884_42947 = state_42859__$1;
(statearr_42884_42947[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (36))){
var inst_42833 = (state_42859[(11)]);
var state_42859__$1 = state_42859;
var statearr_42885_42948 = state_42859__$1;
(statearr_42885_42948[(2)] = inst_42833);

(statearr_42885_42948[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (41))){
var inst_42847 = cljs.core.async.close_BANG_(return_chan);
var state_42859__$1 = state_42859;
var statearr_42886_42949 = state_42859__$1;
(statearr_42886_42949[(2)] = inst_42847);

(statearr_42886_42949[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (43))){
var inst_42850 = (state_42859[(2)]);
var state_42859__$1 = state_42859;
var statearr_42887_42950 = state_42859__$1;
(statearr_42887_42950[(2)] = inst_42850);

(statearr_42887_42950[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (29))){
var inst_42814 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_42815 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_42814].join('');
var inst_42816 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42817 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_42818 = cljs.core.PersistentHashMap.fromArrays(inst_42816,inst_42817);
var inst_42819 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42815,inst_42818);
var inst_42820 = (function(){throw inst_42819})();
var state_42859__$1 = state_42859;
var statearr_42888_42951 = state_42859__$1;
(statearr_42888_42951[(2)] = inst_42820);

(statearr_42888_42951[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (6))){
var inst_42756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42757 = [ident];
var inst_42758 = (new cljs.core.PersistentVector(null,1,(5),inst_42756,inst_42757,null));
var inst_42759 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_42758);
var state_42859__$1 = state_42859;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42859__$1,(9),inst_42759);
} else {
if((state_val_42860 === (28))){
var inst_42811 = (state_42859[(2)]);
var state_42859__$1 = state_42859;
var statearr_42889_42952 = state_42859__$1;
(statearr_42889_42952[(2)] = inst_42811);

(statearr_42889_42952[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (25))){
var inst_42805 = (state_42859[(8)]);
var inst_42805__$1 = (state_42859[(2)]);
var inst_42806 = (inst_42805__$1 == null);
var state_42859__$1 = (function (){var statearr_42890 = state_42859;
(statearr_42890[(8)] = inst_42805__$1);

return statearr_42890;
})();
if(cljs.core.truth_(inst_42806)){
var statearr_42891_42953 = state_42859__$1;
(statearr_42891_42953[(1)] = (26));

} else {
var statearr_42892_42954 = state_42859__$1;
(statearr_42892_42954[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (34))){
var inst_42854 = (state_42859[(2)]);
var _ = (function (){var statearr_42893 = state_42859;
(statearr_42893[(4)] = cljs.core.rest((state_42859[(4)])));

return statearr_42893;
})();
var state_42859__$1 = state_42859;
var statearr_42894_42955 = state_42859__$1;
(statearr_42894_42955[(2)] = inst_42854);

(statearr_42894_42955[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (17))){
var inst_42787 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_42859__$1 = state_42859;
if(inst_42787){
var statearr_42895_42956 = state_42859__$1;
(statearr_42895_42956[(1)] = (19));

} else {
var statearr_42896_42957 = state_42859__$1;
(statearr_42896_42957[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (3))){
var inst_42857 = (state_42859[(2)]);
var state_42859__$1 = state_42859;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42859__$1,inst_42857);
} else {
if((state_val_42860 === (12))){
var inst_42767 = (state_42859[(2)]);
var state_42859__$1 = state_42859;
var statearr_42897_42958 = state_42859__$1;
(statearr_42897_42958[(2)] = inst_42767);

(statearr_42897_42958[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (2))){
var _ = (function (){var statearr_42898 = state_42859;
(statearr_42898[(4)] = cljs.core.cons((5),(state_42859[(4)])));

return statearr_42898;
})();
var inst_42754 = typeof ident === 'number';
var state_42859__$1 = state_42859;
if(cljs.core.truth_(inst_42754)){
var statearr_42899_42959 = state_42859__$1;
(statearr_42899_42959[(1)] = (6));

} else {
var statearr_42900_42960 = state_42859__$1;
(statearr_42900_42960[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (23))){
var state_42859__$1 = state_42859;
var statearr_42901_42961 = state_42859__$1;
(statearr_42901_42961[(2)] = null);

(statearr_42901_42961[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (35))){
var state_42859__$1 = state_42859;
var statearr_42902_42962 = state_42859__$1;
(statearr_42902_42962[(2)] = strict_QMARK_);

(statearr_42902_42962[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (19))){
var inst_42790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42791 = cljs.core.first(ident);
var inst_42792 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_42791);
var inst_42793 = cljs.core.second(ident);
var inst_42794 = [inst_42792,inst_42793];
var inst_42795 = (new cljs.core.PersistentVector(null,2,(5),inst_42790,inst_42794,null));
var inst_42796 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_42795);
var state_42859__$1 = state_42859;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42859__$1,(22),inst_42796);
} else {
if((state_val_42860 === (11))){
var state_42859__$1 = state_42859;
var statearr_42904_42963 = state_42859__$1;
(statearr_42904_42963[(2)] = null);

(statearr_42904_42963[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (9))){
var inst_42761 = (state_42859[(2)]);
var inst_42762 = fluree.db.util.async.throw_err(inst_42761);
var inst_42763 = cljs.core.not_empty(inst_42762);
var state_42859__$1 = state_42859;
if(cljs.core.truth_(inst_42763)){
var statearr_42905_42964 = state_42859__$1;
(statearr_42905_42964[(1)] = (10));

} else {
var statearr_42906_42965 = state_42859__$1;
(statearr_42906_42965[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (5))){
var _ = (function (){var statearr_42907 = state_42859;
(statearr_42907[(4)] = cljs.core.rest((state_42859[(4)])));

return statearr_42907;
})();
var state_42859__$1 = state_42859;
var ex42903 = (state_42859__$1[(2)]);
var statearr_42908_42966 = state_42859__$1;
(statearr_42908_42966[(5)] = ex42903);


var statearr_42909_42967 = state_42859__$1;
(statearr_42909_42967[(1)] = (4));

(statearr_42909_42967[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (14))){
var inst_42769 = (state_42859[(7)]);
var state_42859__$1 = state_42859;
var statearr_42910_42968 = state_42859__$1;
(statearr_42910_42968[(2)] = inst_42769);

(statearr_42910_42968[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (26))){
var state_42859__$1 = state_42859;
var statearr_42911_42969 = state_42859__$1;
(statearr_42911_42969[(2)] = null);

(statearr_42911_42969[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (16))){
var inst_42778 = cljs.core.first(ident);
var inst_42779 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42778], 0));
var inst_42780 = ["Subject ID lookup failed. The predicate ",inst_42779," does not exist."].join('');
var inst_42781 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42782 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_42783 = cljs.core.PersistentHashMap.fromArrays(inst_42781,inst_42782);
var inst_42784 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42780,inst_42783);
var inst_42785 = (function(){throw inst_42784})();
var state_42859__$1 = state_42859;
var statearr_42912_42970 = state_42859__$1;
(statearr_42912_42970[(2)] = inst_42785);

(statearr_42912_42970[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (38))){
var inst_42839 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_42840 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42841 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_42842 = cljs.core.PersistentHashMap.fromArrays(inst_42840,inst_42841);
var inst_42843 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42839,inst_42842);
var inst_42844 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_42843);
var state_42859__$1 = state_42859;
var statearr_42913_42971 = state_42859__$1;
(statearr_42913_42971[(2)] = inst_42844);

(statearr_42913_42971[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (30))){
var state_42859__$1 = state_42859;
var statearr_42914_42972 = state_42859__$1;
(statearr_42914_42972[(2)] = null);

(statearr_42914_42972[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (10))){
var state_42859__$1 = state_42859;
var statearr_42915_42973 = state_42859__$1;
(statearr_42915_42973[(2)] = ident);

(statearr_42915_42973[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (18))){
var inst_42827 = (state_42859[(2)]);
var state_42859__$1 = state_42859;
var statearr_42916_42974 = state_42859__$1;
(statearr_42916_42974[(2)] = inst_42827);

(statearr_42916_42974[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (42))){
var state_42859__$1 = state_42859;
var statearr_42917_42975 = state_42859__$1;
(statearr_42917_42975[(2)] = null);

(statearr_42917_42975[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (37))){
var inst_42837 = (state_42859[(2)]);
var state_42859__$1 = state_42859;
if(cljs.core.truth_(inst_42837)){
var statearr_42918_42976 = state_42859__$1;
(statearr_42918_42976[(1)] = (38));

} else {
var statearr_42919_42977 = state_42859__$1;
(statearr_42919_42977[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42860 === (8))){
var inst_42829 = (state_42859[(10)]);
var inst_42829__$1 = (state_42859[(2)]);
var state_42859__$1 = (function (){var statearr_42920 = state_42859;
(statearr_42920[(10)] = inst_42829__$1);

return statearr_42920;
})();
if(cljs.core.truth_(inst_42829__$1)){
var statearr_42921_42978 = state_42859__$1;
(statearr_42921_42978[(1)] = (32));

} else {
var statearr_42922_42979 = state_42859__$1;
(statearr_42922_42979[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__16395__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__16395__auto____0 = (function (){
var statearr_42923 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42923[(0)] = fluree$db$graphdb$subid_$_state_machine__16395__auto__);

(statearr_42923[(1)] = (1));

return statearr_42923;
});
var fluree$db$graphdb$subid_$_state_machine__16395__auto____1 = (function (state_42859){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_42859);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e42924){var ex__16398__auto__ = e42924;
var statearr_42925_42980 = state_42859;
(statearr_42925_42980[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_42859[(4)]))){
var statearr_42926_42981 = state_42859;
(statearr_42926_42981[(1)] = cljs.core.first((state_42859[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__42982 = state_42859;
state_42859 = G__42982;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__16395__auto__ = function(state_42859){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__16395__auto____1.call(this,state_42859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__16395__auto____0;
fluree$db$graphdb$subid_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__16395__auto____1;
return fluree$db$graphdb$subid_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_42927 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_42927[(6)] = c__16469__auto___42928);

return statearr_42927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__42983){
var map__42984 = p__42983;
var map__42984__$1 = cljs.core.__destructure_map(map__42984);
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42984__$1,cljs.core.cst$kw$current_DASH_db_DASH_fn);
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42984__$1,cljs.core.cst$kw$permissions);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43000){
var state_val_43001 = (state_43000[(1)]);
if((state_val_43001 === (1))){
var state_43000__$1 = state_43000;
var statearr_43002_43016 = state_43000__$1;
(statearr_43002_43016[(2)] = null);

(statearr_43002_43016[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43001 === (2))){
var _ = (function (){var statearr_43003 = state_43000;
(statearr_43003[(4)] = cljs.core.cons((5),(state_43000[(4)])));

return statearr_43003;
})();
var inst_42991 = (current_db_fn.cljs$core$IFn$_invoke$arity$0 ? current_db_fn.cljs$core$IFn$_invoke$arity$0() : current_db_fn.call(null));
var state_43000__$1 = state_43000;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43000__$1,(6),inst_42991);
} else {
if((state_val_43001 === (3))){
var inst_42998 = (state_43000[(2)]);
var state_43000__$1 = state_43000;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43000__$1,inst_42998);
} else {
if((state_val_43001 === (4))){
var inst_42985 = (state_43000[(2)]);
var state_43000__$1 = state_43000;
var statearr_43005_43017 = state_43000__$1;
(statearr_43005_43017[(2)] = inst_42985);

(statearr_43005_43017[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43001 === (5))){
var _ = (function (){var statearr_43006 = state_43000;
(statearr_43006[(4)] = cljs.core.rest((state_43000[(4)])));

return statearr_43006;
})();
var state_43000__$1 = state_43000;
var ex43004 = (state_43000__$1[(2)]);
var statearr_43007_43018 = state_43000__$1;
(statearr_43007_43018[(5)] = ex43004);


if((ex43004 instanceof Error)){
var statearr_43008_43019 = state_43000__$1;
(statearr_43008_43019[(1)] = (4));

(statearr_43008_43019[(5)] = null);

} else {
throw ex43004;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43001 === (6))){
var inst_42993 = (state_43000[(2)]);
var inst_42994 = fluree.db.util.async.throw_err(inst_42993);
var inst_42995 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42994,cljs.core.cst$kw$permissions,permissions);
var _ = (function (){var statearr_43009 = state_43000;
(statearr_43009[(4)] = cljs.core.rest((state_43000[(4)])));

return statearr_43009;
})();
var state_43000__$1 = state_43000;
var statearr_43010_43020 = state_43000__$1;
(statearr_43010_43020[(2)] = inst_42995);

(statearr_43010_43020[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto____0 = (function (){
var statearr_43011 = [null,null,null,null,null,null,null];
(statearr_43011[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto__);

(statearr_43011[(1)] = (1));

return statearr_43011;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto____1 = (function (state_43000){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43000);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43012){var ex__16398__auto__ = e43012;
var statearr_43013_43021 = state_43000;
(statearr_43013_43021[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43000[(4)]))){
var statearr_43014_43022 = state_43000;
(statearr_43014_43022[(1)] = cljs.core.first((state_43000[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43023 = state_43000;
state_43000 = G__43023;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto__ = function(state_43000){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto____1.call(this,state_43000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43015 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43015[(6)] = c__16469__auto__);

return statearr_43015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__43024,property,collection){
var map__43025 = p__43024;
var map__43025__$1 = cljs.core.__destructure_map(map__43025);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43025__$1,cljs.core.cst$kw$schema);
if(cljs.core.truth_((function (){var fexpr__43026 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$partition,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__43026.cljs$core$IFn$_invoke$arity$1 ? fexpr__43026.cljs$core$IFn$_invoke$arity$1(property) : fexpr__43026.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__43027,property,predicate){
var map__43028 = p__43027;
var map__43028__$1 = cljs.core.__destructure_map(map__43028);
var this$ = map__43028__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43028__$1,cljs.core.cst$kw$schema);
if(cljs.core.truth_((function (){var fexpr__43029 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$retractDuplicates,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__43029.cljs$core$IFn$_invoke$arity$1 ? fexpr__43029.cljs$core$IFn$_invoke$arity$1(property) : fexpr__43029.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__43030 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return fluree.db.dbproto._c_prop(this$,cljs.core.cst$kw$partition,G__43030);
} else {
return G__43030;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return cljs.core.cst$kw$fluree$db$graphdb_SLASH_no_DASH_pred;
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,cljs.core.cst$kw$name,pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__43032 = arguments.length;
switch (G__43032) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43064){
var state_val_43065 = (state_43064[(1)]);
if((state_val_43065 === (7))){
var state_43064__$1 = state_43064;
var statearr_43066_43160 = state_43064__$1;
(statearr_43066_43160[(2)] = null);

(statearr_43066_43160[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43065 === (1))){
var state_43064__$1 = state_43064;
var statearr_43067_43161 = state_43064__$1;
(statearr_43067_43161[(2)] = null);

(statearr_43067_43161[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43065 === (4))){
var inst_43033 = (state_43064[(2)]);
var state_43064__$1 = state_43064;
var statearr_43068_43162 = state_43064__$1;
(statearr_43068_43162[(2)] = inst_43033);

(statearr_43068_43162[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43065 === (6))){
var inst_43047 = (state_43064[(7)]);
var inst_43046 = (state_43064[(2)]);
var inst_43047__$1 = fluree.db.util.async.throw_err(inst_43046);
var inst_43048 = (inst_43047__$1 == null);
var state_43064__$1 = (function (){var statearr_43069 = state_43064;
(statearr_43069[(7)] = inst_43047__$1);

return statearr_43069;
})();
if(cljs.core.truth_(inst_43048)){
var statearr_43070_43163 = state_43064__$1;
(statearr_43070_43163[(1)] = (7));

} else {
var statearr_43071_43164 = state_43064__$1;
(statearr_43071_43164[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43065 === (3))){
var inst_43062 = (state_43064[(2)]);
var state_43064__$1 = state_43064;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43064__$1,inst_43062);
} else {
if((state_val_43065 === (12))){
var inst_43059 = (state_43064[(2)]);
var _ = (function (){var statearr_43072 = state_43064;
(statearr_43072[(4)] = cljs.core.rest((state_43064[(4)])));

return statearr_43072;
})();
var state_43064__$1 = state_43064;
var statearr_43073_43165 = state_43064__$1;
(statearr_43073_43165[(2)] = inst_43059);

(statearr_43073_43165[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43065 === (2))){
var _ = (function (){var statearr_43074 = state_43064;
(statearr_43074[(4)] = cljs.core.cons((5),(state_43064[(4)])));

return statearr_43074;
})();
var inst_43040 = fluree.db.dbproto._rootdb(this$);
var inst_43041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43042 = [tag_id,(30)];
var inst_43043 = (new cljs.core.PersistentVector(null,2,(5),inst_43041,inst_43042,null));
var inst_43044 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_43040,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_43043);
var state_43064__$1 = state_43064;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43064__$1,(6),inst_43044);
} else {
if((state_val_43065 === (11))){
var inst_43053 = (state_43064[(8)]);
var inst_43057 = inst_43053.o;
var state_43064__$1 = state_43064;
var statearr_43076_43166 = state_43064__$1;
(statearr_43076_43166[(2)] = inst_43057);

(statearr_43076_43166[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43065 === (9))){
var inst_43053 = (state_43064[(8)]);
var inst_43053__$1 = (state_43064[(2)]);
var inst_43054 = (inst_43053__$1 == null);
var state_43064__$1 = (function (){var statearr_43077 = state_43064;
(statearr_43077[(8)] = inst_43053__$1);

return statearr_43077;
})();
if(cljs.core.truth_(inst_43054)){
var statearr_43078_43167 = state_43064__$1;
(statearr_43078_43167[(1)] = (10));

} else {
var statearr_43079_43168 = state_43064__$1;
(statearr_43079_43168[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43065 === (5))){
var _ = (function (){var statearr_43080 = state_43064;
(statearr_43080[(4)] = cljs.core.rest((state_43064[(4)])));

return statearr_43080;
})();
var state_43064__$1 = state_43064;
var ex43075 = (state_43064__$1[(2)]);
var statearr_43081_43169 = state_43064__$1;
(statearr_43081_43169[(5)] = ex43075);


if((ex43075 instanceof Error)){
var statearr_43082_43170 = state_43064__$1;
(statearr_43082_43170[(1)] = (4));

(statearr_43082_43170[(5)] = null);

} else {
throw ex43075;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43065 === (10))){
var state_43064__$1 = state_43064;
var statearr_43083_43171 = state_43064__$1;
(statearr_43083_43171[(2)] = null);

(statearr_43083_43171[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43065 === (8))){
var inst_43047 = (state_43064[(7)]);
var inst_43051 = cljs.core.first(inst_43047);
var state_43064__$1 = state_43064;
var statearr_43084_43172 = state_43064__$1;
(statearr_43084_43172[(2)] = inst_43051);

(statearr_43084_43172[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16395__auto__ = null;
var fluree$db$graphdb$state_machine__16395__auto____0 = (function (){
var statearr_43085 = [null,null,null,null,null,null,null,null,null];
(statearr_43085[(0)] = fluree$db$graphdb$state_machine__16395__auto__);

(statearr_43085[(1)] = (1));

return statearr_43085;
});
var fluree$db$graphdb$state_machine__16395__auto____1 = (function (state_43064){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43064);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43086){var ex__16398__auto__ = e43086;
var statearr_43087_43173 = state_43064;
(statearr_43087_43173[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43064[(4)]))){
var statearr_43088_43174 = state_43064;
(statearr_43088_43174[(1)] = cljs.core.first((state_43064[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43175 = state_43064;
state_43064 = G__43175;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16395__auto__ = function(state_43064){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16395__auto____1.call(this,state_43064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16395__auto____0;
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16395__auto____1;
return fluree$db$graphdb$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43089 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43089[(6)] = c__16469__auto__);

return statearr_43089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43125){
var state_val_43126 = (state_43125[(1)]);
if((state_val_43126 === (7))){
var inst_43099 = fluree.db.dbproto._p_prop(this$,cljs.core.cst$kw$name,pred);
var state_43125__$1 = state_43125;
var statearr_43127_43176 = state_43125__$1;
(statearr_43127_43176[(2)] = inst_43099);

(statearr_43127_43176[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (1))){
var state_43125__$1 = state_43125;
var statearr_43128_43177 = state_43125__$1;
(statearr_43128_43177[(2)] = null);

(statearr_43128_43177[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (4))){
var inst_43090 = (state_43125[(2)]);
var state_43125__$1 = state_43125;
var statearr_43129_43178 = state_43125__$1;
(statearr_43129_43178[(2)] = inst_43090);

(statearr_43129_43178[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (15))){
var inst_43120 = (state_43125[(2)]);
var _ = (function (){var statearr_43130 = state_43125;
(statearr_43130[(4)] = cljs.core.rest((state_43125[(4)])));

return statearr_43130;
})();
var state_43125__$1 = state_43125;
var statearr_43131_43179 = state_43125__$1;
(statearr_43131_43179[(2)] = inst_43120);

(statearr_43131_43179[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (13))){
var inst_43105 = (state_43125[(7)]);
var inst_43111 = clojure.string.includes_QMARK_(inst_43105,":");
var state_43125__$1 = state_43125;
if(inst_43111){
var statearr_43132_43180 = state_43125__$1;
(statearr_43132_43180[(1)] = (16));

} else {
var statearr_43133_43181 = state_43125__$1;
(statearr_43133_43181[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (6))){
var state_43125__$1 = state_43125;
var statearr_43134_43182 = state_43125__$1;
(statearr_43134_43182[(2)] = pred);

(statearr_43134_43182[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (17))){
var inst_43105 = (state_43125[(7)]);
var state_43125__$1 = state_43125;
var statearr_43135_43183 = state_43125__$1;
(statearr_43135_43183[(2)] = inst_43105);

(statearr_43135_43183[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (3))){
var inst_43123 = (state_43125[(2)]);
var state_43125__$1 = state_43125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43125__$1,inst_43123);
} else {
if((state_val_43126 === (12))){
var inst_43109 = (state_43125[(2)]);
var state_43125__$1 = state_43125;
if(cljs.core.truth_(inst_43109)){
var statearr_43136_43184 = state_43125__$1;
(statearr_43136_43184[(1)] = (13));

} else {
var statearr_43137_43185 = state_43125__$1;
(statearr_43137_43185[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (2))){
var _ = (function (){var statearr_43138 = state_43125;
(statearr_43138[(4)] = cljs.core.cons((5),(state_43125[(4)])));

return statearr_43138;
})();
var inst_43096 = typeof pred === 'string';
var state_43125__$1 = state_43125;
if(cljs.core.truth_(inst_43096)){
var statearr_43139_43186 = state_43125__$1;
(statearr_43139_43186[(1)] = (6));

} else {
var statearr_43140_43187 = state_43125__$1;
(statearr_43140_43187[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (11))){
var inst_43101 = (state_43125[(8)]);
var state_43125__$1 = state_43125;
var statearr_43142_43188 = state_43125__$1;
(statearr_43142_43188[(2)] = inst_43101);

(statearr_43142_43188[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (9))){
var inst_43101 = (state_43125[(8)]);
var inst_43104 = (state_43125[(2)]);
var inst_43105 = fluree.db.util.async.throw_err(inst_43104);
var state_43125__$1 = (function (){var statearr_43143 = state_43125;
(statearr_43143[(7)] = inst_43105);

return statearr_43143;
})();
if(cljs.core.truth_(inst_43101)){
var statearr_43144_43189 = state_43125__$1;
(statearr_43144_43189[(1)] = (10));

} else {
var statearr_43145_43190 = state_43125__$1;
(statearr_43145_43190[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (5))){
var _ = (function (){var statearr_43146 = state_43125;
(statearr_43146[(4)] = cljs.core.rest((state_43125[(4)])));

return statearr_43146;
})();
var state_43125__$1 = state_43125;
var ex43141 = (state_43125__$1[(2)]);
var statearr_43147_43191 = state_43125__$1;
(statearr_43147_43191[(5)] = ex43141);


if((ex43141 instanceof Error)){
var statearr_43148_43192 = state_43125__$1;
(statearr_43148_43192[(1)] = (4));

(statearr_43148_43192[(5)] = null);

} else {
throw ex43141;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (14))){
var state_43125__$1 = state_43125;
var statearr_43149_43193 = state_43125__$1;
(statearr_43149_43193[(2)] = null);

(statearr_43149_43193[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (16))){
var inst_43105 = (state_43125[(7)]);
var inst_43113 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_43105,/:/);
var inst_43114 = cljs.core.second(inst_43113);
var state_43125__$1 = state_43125;
var statearr_43150_43194 = state_43125__$1;
(statearr_43150_43194[(2)] = inst_43114);

(statearr_43150_43194[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (10))){
var inst_43105 = (state_43125[(7)]);
var state_43125__$1 = state_43125;
var statearr_43151_43195 = state_43125__$1;
(statearr_43151_43195[(2)] = inst_43105);

(statearr_43151_43195[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (18))){
var inst_43117 = (state_43125[(2)]);
var state_43125__$1 = state_43125;
var statearr_43152_43196 = state_43125__$1;
(statearr_43152_43196[(2)] = inst_43117);

(statearr_43152_43196[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43126 === (8))){
var inst_43101 = (state_43125[(2)]);
var inst_43102 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_43125__$1 = (function (){var statearr_43153 = state_43125;
(statearr_43153[(8)] = inst_43101);

return statearr_43153;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43125__$1,(9),inst_43102);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16395__auto__ = null;
var fluree$db$graphdb$state_machine__16395__auto____0 = (function (){
var statearr_43154 = [null,null,null,null,null,null,null,null,null];
(statearr_43154[(0)] = fluree$db$graphdb$state_machine__16395__auto__);

(statearr_43154[(1)] = (1));

return statearr_43154;
});
var fluree$db$graphdb$state_machine__16395__auto____1 = (function (state_43125){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43125);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43155){var ex__16398__auto__ = e43155;
var statearr_43156_43197 = state_43125;
(statearr_43156_43197[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43125[(4)]))){
var statearr_43157_43198 = state_43125;
(statearr_43157_43198[(1)] = cljs.core.first((state_43125[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43199 = state_43125;
state_43125 = G__43199;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16395__auto__ = function(state_43125){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16395__auto____1.call(this,state_43125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16395__auto____0;
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16395__auto____1;
return fluree$db$graphdb$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43158 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43158[(6)] = c__16469__auto__);

return statearr_43158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__43201 = arguments.length;
switch (G__43201) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43234){
var state_val_43235 = (state_43234[(1)]);
if((state_val_43235 === (7))){
var state_43234__$1 = state_43234;
var statearr_43236_43324 = state_43234__$1;
(statearr_43236_43324[(2)] = null);

(statearr_43236_43324[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43235 === (1))){
var state_43234__$1 = state_43234;
var statearr_43237_43325 = state_43234__$1;
(statearr_43237_43325[(2)] = null);

(statearr_43237_43325[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43235 === (4))){
var inst_43202 = (state_43234[(2)]);
var state_43234__$1 = state_43234;
var statearr_43238_43326 = state_43234__$1;
(statearr_43238_43326[(2)] = inst_43202);

(statearr_43238_43326[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43235 === (6))){
var inst_43217 = (state_43234[(7)]);
var inst_43216 = (state_43234[(2)]);
var inst_43217__$1 = fluree.db.util.async.throw_err(inst_43216);
var inst_43218 = (inst_43217__$1 == null);
var state_43234__$1 = (function (){var statearr_43239 = state_43234;
(statearr_43239[(7)] = inst_43217__$1);

return statearr_43239;
})();
if(cljs.core.truth_(inst_43218)){
var statearr_43240_43327 = state_43234__$1;
(statearr_43240_43327[(1)] = (7));

} else {
var statearr_43241_43328 = state_43234__$1;
(statearr_43241_43328[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43235 === (3))){
var inst_43232 = (state_43234[(2)]);
var state_43234__$1 = state_43234;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43234__$1,inst_43232);
} else {
if((state_val_43235 === (12))){
var inst_43229 = (state_43234[(2)]);
var _ = (function (){var statearr_43242 = state_43234;
(statearr_43242[(4)] = cljs.core.rest((state_43234[(4)])));

return statearr_43242;
})();
var state_43234__$1 = state_43234;
var statearr_43243_43329 = state_43234__$1;
(statearr_43243_43329[(2)] = inst_43229);

(statearr_43243_43329[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43235 === (2))){
var _ = (function (){var statearr_43244 = state_43234;
(statearr_43244[(4)] = cljs.core.cons((5),(state_43234[(4)])));

return statearr_43244;
})();
var inst_43208 = (30);
var inst_43210 = fluree.db.dbproto._rootdb(this$);
var inst_43211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43212 = [inst_43208,tag_name];
var inst_43213 = (new cljs.core.PersistentVector(null,2,(5),inst_43211,inst_43212,null));
var inst_43214 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_43210,cljs.core.cst$kw$post,cljs.core._EQ_,inst_43213);
var state_43234__$1 = state_43234;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43234__$1,(6),inst_43214);
} else {
if((state_val_43235 === (11))){
var inst_43223 = (state_43234[(8)]);
var inst_43227 = inst_43223.s;
var state_43234__$1 = state_43234;
var statearr_43246_43330 = state_43234__$1;
(statearr_43246_43330[(2)] = inst_43227);

(statearr_43246_43330[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43235 === (9))){
var inst_43223 = (state_43234[(8)]);
var inst_43223__$1 = (state_43234[(2)]);
var inst_43224 = (inst_43223__$1 == null);
var state_43234__$1 = (function (){var statearr_43247 = state_43234;
(statearr_43247[(8)] = inst_43223__$1);

return statearr_43247;
})();
if(cljs.core.truth_(inst_43224)){
var statearr_43248_43331 = state_43234__$1;
(statearr_43248_43331[(1)] = (10));

} else {
var statearr_43249_43332 = state_43234__$1;
(statearr_43249_43332[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43235 === (5))){
var _ = (function (){var statearr_43250 = state_43234;
(statearr_43250[(4)] = cljs.core.rest((state_43234[(4)])));

return statearr_43250;
})();
var state_43234__$1 = state_43234;
var ex43245 = (state_43234__$1[(2)]);
var statearr_43251_43333 = state_43234__$1;
(statearr_43251_43333[(5)] = ex43245);


if((ex43245 instanceof Error)){
var statearr_43252_43334 = state_43234__$1;
(statearr_43252_43334[(1)] = (4));

(statearr_43252_43334[(5)] = null);

} else {
throw ex43245;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43235 === (10))){
var state_43234__$1 = state_43234;
var statearr_43253_43335 = state_43234__$1;
(statearr_43253_43335[(2)] = null);

(statearr_43253_43335[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43235 === (8))){
var inst_43217 = (state_43234[(7)]);
var inst_43221 = cljs.core.first(inst_43217);
var state_43234__$1 = state_43234;
var statearr_43254_43336 = state_43234__$1;
(statearr_43254_43336[(2)] = inst_43221);

(statearr_43254_43336[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16395__auto__ = null;
var fluree$db$graphdb$state_machine__16395__auto____0 = (function (){
var statearr_43255 = [null,null,null,null,null,null,null,null,null];
(statearr_43255[(0)] = fluree$db$graphdb$state_machine__16395__auto__);

(statearr_43255[(1)] = (1));

return statearr_43255;
});
var fluree$db$graphdb$state_machine__16395__auto____1 = (function (state_43234){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43234);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43256){var ex__16398__auto__ = e43256;
var statearr_43257_43337 = state_43234;
(statearr_43257_43337[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43234[(4)]))){
var statearr_43258_43338 = state_43234;
(statearr_43258_43338[(1)] = cljs.core.first((state_43234[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43339 = state_43234;
state_43234 = G__43339;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16395__auto__ = function(state_43234){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16395__auto____1.call(this,state_43234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16395__auto____0;
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16395__auto____1;
return fluree$db$graphdb$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43259 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43259[(6)] = c__16469__auto__);

return statearr_43259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43294){
var state_val_43295 = (state_43294[(1)]);
if((state_val_43295 === (7))){
var inst_43273 = typeof pred === 'string';
var state_43294__$1 = state_43294;
if(cljs.core.truth_(inst_43273)){
var statearr_43296_43340 = state_43294__$1;
(statearr_43296_43340[(1)] = (10));

} else {
var statearr_43297_43341 = state_43294__$1;
(statearr_43297_43341[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43295 === (1))){
var state_43294__$1 = state_43294;
var statearr_43298_43342 = state_43294__$1;
(statearr_43298_43342[(2)] = null);

(statearr_43298_43342[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43295 === (4))){
var inst_43260 = (state_43294[(2)]);
var state_43294__$1 = state_43294;
var statearr_43299_43343 = state_43294__$1;
(statearr_43299_43343[(2)] = inst_43260);

(statearr_43299_43343[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43295 === (15))){
var inst_43287 = (state_43294[(2)]);
var state_43294__$1 = state_43294;
var statearr_43300_43344 = state_43294__$1;
(statearr_43300_43344[(2)] = inst_43287);

(statearr_43300_43344[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43295 === (13))){
var inst_43278 = (state_43294[(7)]);
var inst_43280 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43278),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_43281 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_43280);
var state_43294__$1 = state_43294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43294__$1,(16),inst_43281);
} else {
if((state_val_43295 === (6))){
var inst_43268 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_43294__$1 = state_43294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43294__$1,(9),inst_43268);
} else {
if((state_val_43295 === (3))){
var inst_43292 = (state_43294[(2)]);
var state_43294__$1 = state_43294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43294__$1,inst_43292);
} else {
if((state_val_43295 === (12))){
var inst_43278 = (state_43294[(7)]);
var inst_43278__$1 = (state_43294[(2)]);
var state_43294__$1 = (function (){var statearr_43301 = state_43294;
(statearr_43301[(7)] = inst_43278__$1);

return statearr_43301;
})();
if(cljs.core.truth_(inst_43278__$1)){
var statearr_43302_43345 = state_43294__$1;
(statearr_43302_43345[(1)] = (13));

} else {
var statearr_43303_43346 = state_43294__$1;
(statearr_43303_43346[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43295 === (2))){
var _ = (function (){var statearr_43304 = state_43294;
(statearr_43304[(4)] = cljs.core.cons((5),(state_43294[(4)])));

return statearr_43304;
})();
var inst_43266 = clojure.string.includes_QMARK_(tag_name,"/");
var state_43294__$1 = state_43294;
if(inst_43266){
var statearr_43305_43347 = state_43294__$1;
(statearr_43305_43347[(1)] = (6));

} else {
var statearr_43306_43348 = state_43294__$1;
(statearr_43306_43348[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43295 === (11))){
var inst_43276 = fluree.db.dbproto._p_prop(this$,cljs.core.cst$kw$name,pred);
var state_43294__$1 = state_43294;
var statearr_43308_43349 = state_43294__$1;
(statearr_43308_43349[(2)] = inst_43276);

(statearr_43308_43349[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43295 === (9))){
var inst_43270 = (state_43294[(2)]);
var inst_43271 = fluree.db.util.async.throw_err(inst_43270);
var state_43294__$1 = state_43294;
var statearr_43309_43350 = state_43294__$1;
(statearr_43309_43350[(2)] = inst_43271);

(statearr_43309_43350[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43295 === (5))){
var _ = (function (){var statearr_43310 = state_43294;
(statearr_43310[(4)] = cljs.core.rest((state_43294[(4)])));

return statearr_43310;
})();
var state_43294__$1 = state_43294;
var ex43307 = (state_43294__$1[(2)]);
var statearr_43311_43351 = state_43294__$1;
(statearr_43311_43351[(5)] = ex43307);


if((ex43307 instanceof Error)){
var statearr_43312_43352 = state_43294__$1;
(statearr_43312_43352[(1)] = (4));

(statearr_43312_43352[(5)] = null);

} else {
throw ex43307;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43295 === (14))){
var state_43294__$1 = state_43294;
var statearr_43313_43353 = state_43294__$1;
(statearr_43313_43353[(2)] = null);

(statearr_43313_43353[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43295 === (16))){
var inst_43283 = (state_43294[(2)]);
var inst_43284 = fluree.db.util.async.throw_err(inst_43283);
var state_43294__$1 = state_43294;
var statearr_43314_43354 = state_43294__$1;
(statearr_43314_43354[(2)] = inst_43284);

(statearr_43314_43354[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43295 === (10))){
var state_43294__$1 = state_43294;
var statearr_43315_43355 = state_43294__$1;
(statearr_43315_43355[(2)] = pred);

(statearr_43315_43355[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43295 === (8))){
var inst_43289 = (state_43294[(2)]);
var _ = (function (){var statearr_43316 = state_43294;
(statearr_43316[(4)] = cljs.core.rest((state_43294[(4)])));

return statearr_43316;
})();
var state_43294__$1 = state_43294;
var statearr_43317_43356 = state_43294__$1;
(statearr_43317_43356[(2)] = inst_43289);

(statearr_43317_43356[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16395__auto__ = null;
var fluree$db$graphdb$state_machine__16395__auto____0 = (function (){
var statearr_43318 = [null,null,null,null,null,null,null,null];
(statearr_43318[(0)] = fluree$db$graphdb$state_machine__16395__auto__);

(statearr_43318[(1)] = (1));

return statearr_43318;
});
var fluree$db$graphdb$state_machine__16395__auto____1 = (function (state_43294){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43294);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43319){var ex__16398__auto__ = e43319;
var statearr_43320_43357 = state_43294;
(statearr_43320_43357[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43294[(4)]))){
var statearr_43321_43358 = state_43294;
(statearr_43321_43358[(1)] = cljs.core.first((state_43294[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43359 = state_43294;
state_43294 = G__43359;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16395__auto__ = function(state_43294){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16395__auto____1.call(this,state_43294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16395__auto____0;
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16395__auto____1;
return fluree$db$graphdb$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43322 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43322[(6)] = c__16469__auto__);

return statearr_43322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k43361,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__43365 = k43361;
var G__43365__$1 = (((G__43365 instanceof cljs.core.Keyword))?G__43365.fqn:null);
switch (G__43365__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k43361,else__4464__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__43366){
var vec__43367 = p__43366;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43367,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43367,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__43360){
var self__ = this;
var G__43360__$1 = this;
return (new cljs.core.RecordIter((0),G__43360__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__43370 = (function (coll__4458__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__43370(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this43362,other43363){
var self__ = this;
var this43362__$1 = this;
return (((!((other43363 == null)))) && ((((this43362__$1.constructor === other43363.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.conn,other43363.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.network,other43363.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.dbid,other43363.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.block,other43363.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.t,other43363.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.tt_id,other43363.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.stats,other43363.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.spot,other43363.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.psot,other43363.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.post,other43363.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.opst,other43363.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.schema,other43363.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.settings,other43363.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.index_configs,other43363.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.schema_cache,other43363.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.novelty,other43363.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.permissions,other43363.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.fork,other43363.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.fork_block,other43363.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.current_db_fn,other43363.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43362__$1.__extmap,other43363.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k43361){
var self__ = this;
var this__4468__auto____$1 = this;
var G__43371 = k43361;
var G__43371__$1 = (((G__43371 instanceof cljs.core.Keyword))?G__43371.fqn:null);
switch (G__43371__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k43361);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__43360){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__43372 = cljs.core.keyword_identical_QMARK_;
var expr__43373 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__43375 = cljs.core.cst$kw$conn;
var G__43376 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43375,G__43376) : pred__43372.call(null,G__43375,G__43376));
})())){
return (new fluree.db.graphdb.GraphDb(G__43360,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43377 = cljs.core.cst$kw$network;
var G__43378 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43377,G__43378) : pred__43372.call(null,G__43377,G__43378));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__43360,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43379 = cljs.core.cst$kw$dbid;
var G__43380 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43379,G__43380) : pred__43372.call(null,G__43379,G__43380));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__43360,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43381 = cljs.core.cst$kw$block;
var G__43382 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43381,G__43382) : pred__43372.call(null,G__43381,G__43382));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__43360,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43383 = cljs.core.cst$kw$t;
var G__43384 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43383,G__43384) : pred__43372.call(null,G__43383,G__43384));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__43360,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43385 = cljs.core.cst$kw$tt_DASH_id;
var G__43386 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43385,G__43386) : pred__43372.call(null,G__43385,G__43386));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__43360,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43387 = cljs.core.cst$kw$stats;
var G__43388 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43387,G__43388) : pred__43372.call(null,G__43387,G__43388));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__43360,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43389 = cljs.core.cst$kw$spot;
var G__43390 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43389,G__43390) : pred__43372.call(null,G__43389,G__43390));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__43360,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43391 = cljs.core.cst$kw$psot;
var G__43392 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43391,G__43392) : pred__43372.call(null,G__43391,G__43392));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__43360,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43393 = cljs.core.cst$kw$post;
var G__43394 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43393,G__43394) : pred__43372.call(null,G__43393,G__43394));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__43360,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43395 = cljs.core.cst$kw$opst;
var G__43396 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43395,G__43396) : pred__43372.call(null,G__43395,G__43396));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__43360,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43397 = cljs.core.cst$kw$schema;
var G__43398 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43397,G__43398) : pred__43372.call(null,G__43397,G__43398));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__43360,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43399 = cljs.core.cst$kw$settings;
var G__43400 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43399,G__43400) : pred__43372.call(null,G__43399,G__43400));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__43360,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43401 = cljs.core.cst$kw$index_DASH_configs;
var G__43402 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43401,G__43402) : pred__43372.call(null,G__43401,G__43402));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__43360,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43403 = cljs.core.cst$kw$schema_DASH_cache;
var G__43404 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43403,G__43404) : pred__43372.call(null,G__43403,G__43404));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__43360,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43405 = cljs.core.cst$kw$novelty;
var G__43406 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43405,G__43406) : pred__43372.call(null,G__43405,G__43406));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__43360,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43407 = cljs.core.cst$kw$permissions;
var G__43408 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43407,G__43408) : pred__43372.call(null,G__43407,G__43408));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__43360,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43409 = cljs.core.cst$kw$fork;
var G__43410 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43409,G__43410) : pred__43372.call(null,G__43409,G__43410));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__43360,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43411 = cljs.core.cst$kw$fork_DASH_block;
var G__43412 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43411,G__43412) : pred__43372.call(null,G__43411,G__43412));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__43360,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43413 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__43414 = expr__43373;
return (pred__43372.cljs$core$IFn$_invoke$arity$2 ? pred__43372.cljs$core$IFn$_invoke$arity$2(G__43413,G__43414) : pred__43372.call(null,G__43413,G__43414));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__43360,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__43360),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__43360){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__43360,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__43364){
var extmap__4501__auto__ = (function (){var G__43415 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__43364,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__43364)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__43415);
} else {
return G__43415;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__43364),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__43364),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
