// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44704 = arguments.length;
var i__4819__auto___44705 = (0);
while(true){
if((i__4819__auto___44705 < len__4818__auto___44704)){
args__4824__auto__.push((arguments[i__4819__auto___44705]));

var G__44706 = (i__4819__auto___44705 + (1));
i__4819__auto___44705 = G__44706;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq44701){
var G__44702 = cljs.core.first(seq44701);
var seq44701__$1 = cljs.core.next(seq44701);
var G__44703 = cljs.core.first(seq44701__$1);
var seq44701__$2 = cljs.core.next(seq44701__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44702,G__44703,seq44701__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e44707){var e = e44707;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e44708){var e = e44708;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e44709){var e = e44709;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e44710){var e = e44710;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e44711){var e = e44711;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44714 = arguments.length;
var i__4819__auto___44715 = (0);
while(true){
if((i__4819__auto___44715 < len__4818__auto___44714)){
args__4824__auto__.push((arguments[i__4819__auto___44715]));

var G__44716 = (i__4819__auto___44715 + (1));
i__4819__auto___44715 = G__44716;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e44713){var e = e44713;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq44712){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44712));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44719 = arguments.length;
var i__4819__auto___44720 = (0);
while(true){
if((i__4819__auto___44720 < len__4818__auto___44719)){
args__4824__auto__.push((arguments[i__4819__auto___44720]));

var G__44721 = (i__4819__auto___44720 + (1));
i__4819__auto___44720 = G__44721;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e44718){var e = e44718;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq44717){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44717));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e44722){var e = e44722;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44725 = arguments.length;
var i__4819__auto___44726 = (0);
while(true){
if((i__4819__auto___44726 < len__4818__auto___44725)){
args__4824__auto__.push((arguments[i__4819__auto___44726]));

var G__44727 = (i__4819__auto___44726 + (1));
i__4819__auto___44726 = G__44727;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e44724){var e = e44724;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq44723){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44723));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44730 = arguments.length;
var i__4819__auto___44731 = (0);
while(true){
if((i__4819__auto___44731 < len__4818__auto___44730)){
args__4824__auto__.push((arguments[i__4819__auto___44731]));

var G__44732 = (i__4819__auto___44731 + (1));
i__4819__auto___44731 = G__44732;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e44729){var e = e44729;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq44728){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44728));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e44733){var e = e44733;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e44734){var e = e44734;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44737 = arguments.length;
var i__4819__auto___44738 = (0);
while(true){
if((i__4819__auto___44738 < len__4818__auto___44737)){
args__4824__auto__.push((arguments[i__4819__auto___44738]));

var G__44739 = (i__4819__auto___44738 + (1));
i__4819__auto___44738 = G__44739;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e44736){var e = e44736;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq44735){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44735));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44742 = arguments.length;
var i__4819__auto___44743 = (0);
while(true){
if((i__4819__auto___44743 < len__4818__auto___44742)){
args__4824__auto__.push((arguments[i__4819__auto___44743]));

var G__44744 = (i__4819__auto___44743 + (1));
i__4819__auto___44743 = G__44744;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e44741){var e = e44741;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq44740){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44740));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44747 = arguments.length;
var i__4819__auto___44748 = (0);
while(true){
if((i__4819__auto___44748 < len__4818__auto___44747)){
args__4824__auto__.push((arguments[i__4819__auto___44748]));

var G__44749 = (i__4819__auto___44748 + (1));
i__4819__auto___44748 = G__44749;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e44746){var e = e44746;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq44745){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44745));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44752 = arguments.length;
var i__4819__auto___44753 = (0);
while(true){
if((i__4819__auto___44753 < len__4818__auto___44752)){
args__4824__auto__.push((arguments[i__4819__auto___44753]));

var G__44754 = (i__4819__auto___44753 + (1));
i__4819__auto___44753 = G__44754;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e44751){var e = e44751;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq44750){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44750));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44757 = arguments.length;
var i__4819__auto___44758 = (0);
while(true){
if((i__4819__auto___44758 < len__4818__auto___44757)){
args__4824__auto__.push((arguments[i__4819__auto___44758]));

var G__44759 = (i__4819__auto___44758 + (1));
i__4819__auto___44758 = G__44759;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e44756){var e = e44756;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq44755){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44755));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44762 = arguments.length;
var i__4819__auto___44763 = (0);
while(true){
if((i__4819__auto___44763 < len__4818__auto___44762)){
args__4824__auto__.push((arguments[i__4819__auto___44763]));

var G__44764 = (i__4819__auto___44763 + (1));
i__4819__auto___44763 = G__44764;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e44761){var e = e44761;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq44760){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44760));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44767 = arguments.length;
var i__4819__auto___44768 = (0);
while(true){
if((i__4819__auto___44768 < len__4818__auto___44767)){
args__4824__auto__.push((arguments[i__4819__auto___44768]));

var G__44769 = (i__4819__auto___44768 + (1));
i__4819__auto___44768 = G__44769;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e44766){var e = e44766;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq44765){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44765));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__44771 = arguments.length;
switch (G__44771) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_44799){
var state_val_44800 = (state_44799[(1)]);
if((state_val_44800 === (7))){
var inst_44784 = (state_44799[(7)]);
var inst_44787 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44784,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_44799__$1 = state_44799;
var statearr_44801_44887 = state_44799__$1;
(statearr_44801_44887[(2)] = inst_44787);

(statearr_44801_44887[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44800 === (1))){
var state_44799__$1 = state_44799;
var statearr_44802_44888 = state_44799__$1;
(statearr_44802_44888[(2)] = null);

(statearr_44802_44888[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44800 === (4))){
var inst_44772 = (state_44799[(2)]);
var state_44799__$1 = state_44799;
var statearr_44803_44889 = state_44799__$1;
(statearr_44803_44889[(2)] = inst_44772);

(statearr_44803_44889[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44800 === (6))){
var inst_44784 = (state_44799[(7)]);
var inst_44784__$1 = (state_44799[(2)]);
var inst_44785 = fluree.db.util.core.exception_QMARK_(inst_44784__$1);
var state_44799__$1 = (function (){var statearr_44804 = state_44799;
(statearr_44804[(7)] = inst_44784__$1);

return statearr_44804;
})();
if(inst_44785){
var statearr_44805_44890 = state_44799__$1;
(statearr_44805_44890[(1)] = (7));

} else {
var statearr_44806_44891 = state_44799__$1;
(statearr_44806_44891[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44800 === (3))){
var inst_44797 = (state_44799[(2)]);
var state_44799__$1 = state_44799;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44799__$1,inst_44797);
} else {
if((state_val_44800 === (2))){
var inst_44778 = (state_44799[(8)]);
var _ = (function (){var statearr_44808 = state_44799;
(statearr_44808[(4)] = cljs.core.cons((5),(state_44799[(4)])));

return statearr_44808;
})();
var inst_44778__$1 = cljs.core.volatile_BANG_((0));
var inst_44779 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_44780 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_44779,cljs.core.cst$kw$fuel,inst_44778__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_44781 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_44780);
var inst_44782 = fluree.db.query.fql.query(db,inst_44781);
var state_44799__$1 = (function (){var statearr_44809 = state_44799;
(statearr_44809[(8)] = inst_44778__$1);

return statearr_44809;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44799__$1,(6),inst_44782);
} else {
if((state_val_44800 === (9))){
var inst_44794 = (state_44799[(2)]);
var _ = (function (){var statearr_44810 = state_44799;
(statearr_44810[(4)] = cljs.core.rest((state_44799[(4)])));

return statearr_44810;
})();
var state_44799__$1 = state_44799;
var statearr_44811_44892 = state_44799__$1;
(statearr_44811_44892[(2)] = inst_44794);

(statearr_44811_44892[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44800 === (5))){
var _ = (function (){var statearr_44812 = state_44799;
(statearr_44812[(4)] = cljs.core.rest((state_44799[(4)])));

return statearr_44812;
})();
var state_44799__$1 = state_44799;
var ex44807 = (state_44799__$1[(2)]);
var statearr_44813_44893 = state_44799__$1;
(statearr_44813_44893[(5)] = ex44807);


if((ex44807 instanceof Error)){
var statearr_44814_44894 = state_44799__$1;
(statearr_44814_44894[(1)] = (4));

(statearr_44814_44894[(5)] = null);

} else {
throw ex44807;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44800 === (8))){
var inst_44778 = (state_44799[(8)]);
var inst_44784 = (state_44799[(7)]);
var inst_44789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44790 = cljs.core.deref(inst_44778);
var inst_44791 = [inst_44784,inst_44790];
var inst_44792 = (new cljs.core.PersistentVector(null,2,(5),inst_44789,inst_44791,null));
var state_44799__$1 = state_44799;
var statearr_44815_44895 = state_44799__$1;
(statearr_44815_44895[(2)] = inst_44792);

(statearr_44815_44895[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16395__auto____0 = (function (){
var statearr_44816 = [null,null,null,null,null,null,null,null,null];
(statearr_44816[(0)] = fluree$db$dbfunctions$internal$state_machine__16395__auto__);

(statearr_44816[(1)] = (1));

return statearr_44816;
});
var fluree$db$dbfunctions$internal$state_machine__16395__auto____1 = (function (state_44799){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_44799);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e44817){var ex__16398__auto__ = e44817;
var statearr_44818_44896 = state_44799;
(statearr_44818_44896[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_44799[(4)]))){
var statearr_44819_44897 = state_44799;
(statearr_44819_44897[(1)] = cljs.core.first((state_44799[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__44898 = state_44799;
state_44799 = G__44898;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16395__auto__ = function(state_44799){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____1.call(this,state_44799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_44820 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_44820[(6)] = c__16469__auto__);

return statearr_44820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_44865){
var state_val_44866 = (state_44865[(1)]);
if((state_val_44866 === (7))){
var inst_44851 = (state_44865[(2)]);
var inst_44852 = fluree.db.query.fql.query(db,inst_44851);
var state_44865__$1 = state_44865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44865__$1,(8),inst_44852);
} else {
if((state_val_44866 === (1))){
var inst_44821 = typeof select === 'string';
var state_44865__$1 = state_44865;
if(cljs.core.truth_(inst_44821)){
var statearr_44867_44899 = state_44865__$1;
(statearr_44867_44899[(1)] = (2));

} else {
var statearr_44868_44900 = state_44865__$1;
(statearr_44868_44900[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44866 === (4))){
var inst_44827 = (state_44865[(7)]);
var inst_44834 = (state_44865[(8)]);
var inst_44826 = (state_44865[(2)]);
var inst_44827__$1 = cljs.core.volatile_BANG_((0));
var inst_44828 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_44829 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_44830 = [inst_44827__$1,(100000)];
var inst_44831 = cljs.core.PersistentHashMap.fromArrays(inst_44829,inst_44830);
var inst_44832 = [inst_44826,from,where,block,limit,inst_44831];
var inst_44833 = cljs.core.PersistentHashMap.fromArrays(inst_44828,inst_44832);
var inst_44834__$1 = fluree.db.util.core.without_nils(inst_44833);
var inst_44835 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44834__$1);
var inst_44836 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44834__$1);
var inst_44837 = cljs.core.first(inst_44836);
var inst_44838 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44837], 0));
var inst_44839 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_44838);
var inst_44840 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44834__$1);
var inst_44841 = cljs.core.last(inst_44840);
var inst_44842 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44841], 0));
var inst_44843 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_44842);
var inst_44844 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_44835,inst_44839,inst_44843], 0));
var state_44865__$1 = (function (){var statearr_44869 = state_44865;
(statearr_44869[(7)] = inst_44827__$1);

(statearr_44869[(8)] = inst_44834__$1);

return statearr_44869;
})();
if(cljs.core.truth_(inst_44844)){
var statearr_44870_44901 = state_44865__$1;
(statearr_44870_44901[(1)] = (5));

} else {
var statearr_44871_44902 = state_44865__$1;
(statearr_44871_44902[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44866 === (6))){
var inst_44834 = (state_44865[(8)]);
var state_44865__$1 = state_44865;
var statearr_44872_44903 = state_44865__$1;
(statearr_44872_44903[(2)] = inst_44834);

(statearr_44872_44903[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44866 === (3))){
var state_44865__$1 = state_44865;
var statearr_44873_44904 = state_44865__$1;
(statearr_44873_44904[(2)] = select);

(statearr_44873_44904[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44866 === (2))){
var inst_44823 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_44865__$1 = state_44865;
var statearr_44874_44905 = state_44865__$1;
(statearr_44874_44905[(2)] = inst_44823);

(statearr_44874_44905[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44866 === (11))){
var inst_44863 = (state_44865[(2)]);
var state_44865__$1 = state_44865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44865__$1,inst_44863);
} else {
if((state_val_44866 === (9))){
var inst_44854 = (state_44865[(9)]);
var state_44865__$1 = state_44865;
var statearr_44875_44906 = state_44865__$1;
(statearr_44875_44906[(2)] = inst_44854);

(statearr_44875_44906[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44866 === (5))){
var inst_44834 = (state_44865[(8)]);
var inst_44846 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_44834);
var inst_44847 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_44846);
var inst_44848 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_44834,cljs.core.cst$kw$where,inst_44847);
var state_44865__$1 = state_44865;
var statearr_44876_44907 = state_44865__$1;
(statearr_44876_44907[(2)] = inst_44848);

(statearr_44876_44907[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44866 === (10))){
var inst_44827 = (state_44865[(7)]);
var inst_44854 = (state_44865[(9)]);
var inst_44858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44859 = cljs.core.deref(inst_44827);
var inst_44860 = [inst_44854,inst_44859];
var inst_44861 = (new cljs.core.PersistentVector(null,2,(5),inst_44858,inst_44860,null));
var state_44865__$1 = state_44865;
var statearr_44877_44908 = state_44865__$1;
(statearr_44877_44908[(2)] = inst_44861);

(statearr_44877_44908[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44866 === (8))){
var inst_44854 = (state_44865[(9)]);
var inst_44854__$1 = (state_44865[(2)]);
var inst_44855 = fluree.db.util.core.exception_QMARK_(inst_44854__$1);
var state_44865__$1 = (function (){var statearr_44878 = state_44865;
(statearr_44878[(9)] = inst_44854__$1);

return statearr_44878;
})();
if(inst_44855){
var statearr_44879_44909 = state_44865__$1;
(statearr_44879_44909[(1)] = (9));

} else {
var statearr_44880_44910 = state_44865__$1;
(statearr_44880_44910[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16395__auto____0 = (function (){
var statearr_44881 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44881[(0)] = fluree$db$dbfunctions$internal$state_machine__16395__auto__);

(statearr_44881[(1)] = (1));

return statearr_44881;
});
var fluree$db$dbfunctions$internal$state_machine__16395__auto____1 = (function (state_44865){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_44865);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e44882){var ex__16398__auto__ = e44882;
var statearr_44883_44911 = state_44865;
(statearr_44883_44911[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_44865[(4)]))){
var statearr_44884_44912 = state_44865;
(statearr_44884_44912[(1)] = cljs.core.first((state_44865[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__44913 = state_44865;
state_44865 = G__44913;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16395__auto__ = function(state_44865){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____1.call(this,state_44865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_44885 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_44885[(6)] = c__16469__auto__);

return statearr_44885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__44917 = path;
var vec__44918 = G__44917;
var seq__44919 = cljs.core.seq(vec__44918);
var first__44920 = cljs.core.first(seq__44919);
var seq__44919__$1 = cljs.core.next(seq__44919);
var var$ = first__44920;
var r = seq__44919__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__44917__$1 = G__44917;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__44924 = G__44917__$1;
var seq__44925 = cljs.core.seq(vec__44924);
var first__44926 = cljs.core.first(seq__44925);
var seq__44925__$1 = cljs.core.next(seq__44925);
var var$__$1 = first__44926;
var r__$1 = seq__44925__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__44927 = r__$1;
var G__44928 = n__$2;
var G__44929 = next_clauses;
G__44917__$1 = G__44927;
n__$1 = G__44928;
where_clauses__$1 = G__44929;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__44930 = r__$1;
var G__44931 = next_n;
var G__44932 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__44917__$1 = G__44930;
n__$1 = G__44931;
where_clauses__$1 = G__44932;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_44969){
var state_val_44970 = (state_44969[(1)]);
if((state_val_44970 === (7))){
var inst_44942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44943 = [path];
var inst_44944 = (new cljs.core.PersistentVector(null,1,(5),inst_44942,inst_44943,null));
var state_44969__$1 = state_44969;
var statearr_44971_44999 = state_44969__$1;
(statearr_44971_44999[(2)] = inst_44944);

(statearr_44971_44999[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44970 === (1))){
var state_44969__$1 = state_44969;
var statearr_44972_45000 = state_44969__$1;
(statearr_44972_45000[(2)] = null);

(statearr_44972_45000[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44970 === (4))){
var inst_44933 = (state_44969[(2)]);
var state_44969__$1 = state_44969;
var statearr_44973_45001 = state_44969__$1;
(statearr_44973_45001[(2)] = inst_44933);

(statearr_44973_45001[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44970 === (13))){
var inst_44960 = (state_44969[(2)]);
var inst_44961 = fluree.db.util.async.throw_err(inst_44960);
var _ = (function (){var statearr_44974 = state_44969;
(statearr_44974[(4)] = cljs.core.rest((state_44969[(4)])));

return statearr_44974;
})();
var state_44969__$1 = state_44969;
var statearr_44975_45002 = state_44969__$1;
(statearr_44975_45002[(2)] = inst_44961);

(statearr_44975_45002[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44970 === (6))){
var state_44969__$1 = state_44969;
var statearr_44977_45003 = state_44969__$1;
(statearr_44977_45003[(2)] = path);

(statearr_44977_45003[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44970 === (3))){
var inst_44967 = (state_44969[(2)]);
var state_44969__$1 = state_44969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44969__$1,inst_44967);
} else {
if((state_val_44970 === (12))){
var _ = (function (){var statearr_44978 = state_44969;
(statearr_44978[(4)] = cljs.core.rest((state_44969[(4)])));

return statearr_44978;
})();
var state_44969__$1 = state_44969;
var ex44976 = (state_44969__$1[(2)]);
var statearr_44979_45004 = state_44969__$1;
(statearr_44979_45004[(5)] = ex44976);


var statearr_44980_45005 = state_44969__$1;
(statearr_44980_45005[(1)] = (11));

(statearr_44980_45005[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44970 === (2))){
var _ = (function (){var statearr_44981 = state_44969;
(statearr_44981[(4)] = cljs.core.cons((5),(state_44969[(4)])));

return statearr_44981;
})();
var inst_44939 = cljs.core.vector_QMARK_(path);
var state_44969__$1 = state_44969;
if(inst_44939){
var statearr_44982_45006 = state_44969__$1;
(statearr_44982_45006[(1)] = (6));

} else {
var statearr_44983_45007 = state_44969__$1;
(statearr_44983_45007[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44970 === (11))){
var inst_44946 = (state_44969[(7)]);
var inst_44951 = (state_44969[(2)]);
var inst_44952 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_44951,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_44946,endSubject], 0));
var state_44969__$1 = state_44969;
var statearr_44985_45008 = state_44969__$1;
(statearr_44985_45008[(2)] = inst_44952);

(statearr_44985_45008[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44970 === (9))){
var inst_44950 = (state_44969[(8)]);
var _ = (function (){var statearr_44986 = state_44969;
(statearr_44986[(4)] = cljs.core.cons((12),(state_44969[(4)])));

return statearr_44986;
})();
var inst_44958 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_44950);
var state_44969__$1 = state_44969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44969__$1,(13),inst_44958);
} else {
if((state_val_44970 === (5))){
var _ = (function (){var statearr_44987 = state_44969;
(statearr_44987[(4)] = cljs.core.rest((state_44969[(4)])));

return statearr_44987;
})();
var state_44969__$1 = state_44969;
var ex44984 = (state_44969__$1[(2)]);
var statearr_44988_45009 = state_44969__$1;
(statearr_44988_45009[(5)] = ex44984);


if((ex44984 instanceof Error)){
var statearr_44989_45010 = state_44969__$1;
(statearr_44989_45010[(1)] = (4));

(statearr_44989_45010[(5)] = null);

} else {
throw ex44984;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44970 === (10))){
var inst_44964 = (state_44969[(2)]);
var _ = (function (){var statearr_44990 = state_44969;
(statearr_44990[(4)] = cljs.core.rest((state_44969[(4)])));

return statearr_44990;
})();
var state_44969__$1 = state_44969;
var statearr_44991_45011 = state_44969__$1;
(statearr_44991_45011[(2)] = inst_44964);

(statearr_44991_45011[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44970 === (8))){
var inst_44946 = (state_44969[(7)]);
var inst_44946__$1 = (state_44969[(2)]);
var inst_44947 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_44946__$1,endSubject);
var inst_44948 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_44949 = ["?var1",inst_44947];
var inst_44950 = cljs.core.PersistentHashMap.fromArrays(inst_44948,inst_44949);
var state_44969__$1 = (function (){var statearr_44992 = state_44969;
(statearr_44992[(7)] = inst_44946__$1);

(statearr_44992[(8)] = inst_44950);

return statearr_44992;
})();
var statearr_44993_45012 = state_44969__$1;
(statearr_44993_45012[(2)] = null);

(statearr_44993_45012[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_44994 = [null,null,null,null,null,null,null,null,null];
(statearr_44994[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto__);

(statearr_44994[(1)] = (1));

return statearr_44994;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto____1 = (function (state_44969){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_44969);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e44995){var ex__16398__auto__ = e44995;
var statearr_44996_45013 = state_44969;
(statearr_44996_45013[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_44969[(4)]))){
var statearr_44997_45014 = state_44969;
(statearr_44997_45014[(1)] = cljs.core.first((state_44969[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45015 = state_44969;
state_44969 = G__45015;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto__ = function(state_44969){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto____1.call(this,state_44969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_44998 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_44998[(6)] = c__16469__auto__);

return statearr_44998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e45016){var e = e45016;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e45017){var e = e45017;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e45018){var e = e45018;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e45019){var e = e45019;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45022 = arguments.length;
var i__4819__auto___45023 = (0);
while(true){
if((i__4819__auto___45023 < len__4818__auto___45022)){
args__4824__auto__.push((arguments[i__4819__auto___45023]));

var G__45024 = (i__4819__auto___45023 + (1));
i__4819__auto___45023 = G__45024;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e45021){var e = e45021;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq45020){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45020));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45027 = arguments.length;
var i__4819__auto___45028 = (0);
while(true){
if((i__4819__auto___45028 < len__4818__auto___45027)){
args__4824__auto__.push((arguments[i__4819__auto___45028]));

var G__45029 = (i__4819__auto___45028 + (1));
i__4819__auto___45028 = G__45029;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e45026){var e = e45026;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq45025){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45025));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45032 = arguments.length;
var i__4819__auto___45033 = (0);
while(true){
if((i__4819__auto___45033 < len__4818__auto___45032)){
args__4824__auto__.push((arguments[i__4819__auto___45033]));

var G__45034 = (i__4819__auto___45033 + (1));
i__4819__auto___45033 = G__45034;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4212__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e45031){var e = e45031;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq45030){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45030));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45037 = arguments.length;
var i__4819__auto___45038 = (0);
while(true){
if((i__4819__auto___45038 < len__4818__auto___45037)){
args__4824__auto__.push((arguments[i__4819__auto___45038]));

var G__45039 = (i__4819__auto___45038 + (1));
i__4819__auto___45038 = G__45039;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e45036){var e = e45036;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq45035){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45035));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e45040){var e = e45040;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e45041){var e = e45041;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e45042){var e = e45042;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e45043){var e = e45043;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e45044){var e = e45044;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__45050 = path;
var vec__45051 = G__45050;
var seq__45052 = cljs.core.seq(vec__45051);
var first__45053 = cljs.core.first(seq__45052);
var seq__45052__$1 = cljs.core.next(seq__45052);
var pred = first__45053;
var r = seq__45052__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__45050__$1 = G__45050;
var subjects__$1 = subjects;
while(true){
var vec__45057 = G__45050__$1;
var seq__45058 = cljs.core.seq(vec__45057);
var first__45059 = cljs.core.first(seq__45058);
var seq__45058__$1 = cljs.core.next(seq__45058);
var pred__$1 = first__45059;
var r__$1 = seq__45058__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__45050__$1,subjects__$1,vec__45057,seq__45058,first__45059,seq__45058__$1,pred__$1,r__$1,subjects__$2,G__45050,vec__45051,seq__45052,first__45053,seq__45052__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__45050__$1,subjects__$1,vec__45057,seq__45058,first__45059,seq__45058__$1,pred__$1,r__$1,subjects__$2,G__45050,vec__45051,seq__45052,first__45053,seq__45052__$1,pred,r,subjects){
return (function (p1__45045_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__45045_SHARP_,pred__$1);
});})(G__45050__$1,subjects__$1,vec__45057,seq__45058,first__45059,seq__45058__$1,pred__$1,r__$1,subjects__$2,G__45050,vec__45051,seq__45052,first__45053,seq__45052__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__45050__$1,subjects__$1,vec__45057,seq__45058,first__45059,seq__45058__$1,pred__$1,r__$1,subjects__$2,G__45050,vec__45051,seq__45052,first__45053,seq__45052__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4210__auto__ = r__$1;
if(and__4210__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4210__auto__;
}
})())){
var G__45060 = r__$1;
var G__45061 = next_subjects;
G__45050__$1 = G__45060;
subjects__$1 = G__45061;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e45046){var e = e45046;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e45062){var e = e45062;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e45063){var e = e45063;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45066 = arguments.length;
var i__4819__auto___45067 = (0);
while(true){
if((i__4819__auto___45067 < len__4818__auto___45066)){
args__4824__auto__.push((arguments[i__4819__auto___45067]));

var G__45068 = (i__4819__auto___45067 + (1));
i__4819__auto___45067 = G__45068;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e45065){var e = e45065;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq45064){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45064));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e45069){var e = e45069;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___45072 = arguments.length;
var i__4819__auto___45073 = (0);
while(true){
if((i__4819__auto___45073 < len__4818__auto___45072)){
args__4824__auto__.push((arguments[i__4819__auto___45073]));

var G__45074 = (i__4819__auto___45073 + (1));
i__4819__auto___45073 = G__45074;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e45071){var e = e45071;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq45070){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45070));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e45075){var e = e45075;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45132){
var state_val_45133 = (state_45132[(1)]);
if((state_val_45133 === (7))){
var inst_45078 = (state_45132[(2)]);
var state_45132__$1 = state_45132;
var statearr_45134_45168 = state_45132__$1;
(statearr_45134_45168[(2)] = inst_45078);

(statearr_45134_45168[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (1))){
var state_45132__$1 = state_45132;
var statearr_45135_45169 = state_45132__$1;
(statearr_45135_45169[(2)] = null);

(statearr_45135_45169[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (4))){
var inst_45077 = (state_45132[(2)]);
var state_45132__$1 = (function (){var statearr_45136 = state_45132;
(statearr_45136[(7)] = inst_45077);

return statearr_45136;
})();
var statearr_45137_45170 = state_45132__$1;
(statearr_45137_45170[(2)] = null);

(statearr_45137_45170[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (15))){
var inst_45115 = (state_45132[(8)]);
var inst_45100 = (state_45132[(9)]);
var inst_45113 = (state_45132[(10)]);
var inst_45112 = (state_45132[(11)]);
var inst_45103 = (state_45132[(12)]);
var inst_45102 = (state_45132[(13)]);
var inst_45119 = (function (){var db = inst_45100;
var prevT = inst_45102;
var db_SINGLEQUOTE_ = inst_45103;
var prev_vals = inst_45112;
var fuel = inst_45113;
var G__45114 = inst_45115;
return (function (p1__45076_SHARP_){
var f = p1__45076_SHARP_;
return f.o;
});
})();
var inst_45120 = (inst_45119.cljs$core$IFn$_invoke$arity$1 ? inst_45119.cljs$core$IFn$_invoke$arity$1(inst_45115) : inst_45119.call(null,inst_45115));
var state_45132__$1 = state_45132;
var statearr_45138_45171 = state_45132__$1;
(statearr_45138_45171[(2)] = inst_45120);

(statearr_45138_45171[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (13))){
var inst_45115 = (state_45132[(8)]);
var inst_45112 = (state_45132[(11)]);
var inst_45111 = (state_45132[(2)]);
var inst_45112__$1 = fluree.db.util.async.throw_err(inst_45111);
var inst_45113 = fluree.db.dbfunctions.internal.count(inst_45112__$1);
var inst_45115__$1 = cljs.core.first(inst_45112__$1);
var inst_45116 = (inst_45115__$1 == null);
var state_45132__$1 = (function (){var statearr_45139 = state_45132;
(statearr_45139[(8)] = inst_45115__$1);

(statearr_45139[(10)] = inst_45113);

(statearr_45139[(11)] = inst_45112__$1);

return statearr_45139;
})();
if(cljs.core.truth_(inst_45116)){
var statearr_45140_45172 = state_45132__$1;
(statearr_45140_45172[(1)] = (14));

} else {
var statearr_45141_45173 = state_45132__$1;
(statearr_45141_45173[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (6))){
var inst_45087 = (state_45132[(2)]);
var state_45132__$1 = state_45132;
var statearr_45142_45174 = state_45132__$1;
(statearr_45142_45174[(2)] = inst_45087);

(statearr_45142_45174[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (3))){
var inst_45130 = (state_45132[(2)]);
var state_45132__$1 = state_45132;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45132__$1,inst_45130);
} else {
if((state_val_45133 === (12))){
var inst_45127 = (state_45132[(2)]);
var _ = (function (){var statearr_45143 = state_45132;
(statearr_45143[(4)] = cljs.core.rest((state_45132[(4)])));

return statearr_45143;
})();
var state_45132__$1 = state_45132;
var statearr_45144_45175 = state_45132__$1;
(statearr_45144_45175[(2)] = inst_45127);

(statearr_45144_45175[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (2))){
var _ = (function (){var statearr_45146 = state_45132;
(statearr_45146[(4)] = cljs.core.cons((9),(state_45132[(4)])));

return statearr_45146;
})();
var inst_45093 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45094 = typeof inst_45093 === 'string';
var state_45132__$1 = state_45132;
if(cljs.core.truth_(inst_45094)){
var statearr_45147_45176 = state_45132__$1;
(statearr_45147_45176[(1)] = (10));

} else {
var statearr_45148_45177 = state_45132__$1;
(statearr_45148_45177[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (11))){
var inst_45100 = (state_45132[(9)]);
var inst_45103 = (state_45132[(12)]);
var inst_45102 = (state_45132[(13)]);
var inst_45100__$1 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45101 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_45100__$1);
var inst_45102__$1 = fluree.db.dbfunctions.internal.inc(inst_45101);
var inst_45103__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_45100__$1,cljs.core.cst$kw$t,inst_45102__$1);
var inst_45104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45105 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45106 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45107 = [inst_45105,inst_45106];
var inst_45108 = (new cljs.core.PersistentVector(null,2,(5),inst_45104,inst_45107,null));
var inst_45109 = fluree.db.dbproto._search(inst_45103__$1,inst_45108);
var state_45132__$1 = (function (){var statearr_45149 = state_45132;
(statearr_45149[(9)] = inst_45100__$1);

(statearr_45149[(12)] = inst_45103__$1);

(statearr_45149[(13)] = inst_45102__$1);

return statearr_45149;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45132__$1,(13),inst_45109);
} else {
if((state_val_45133 === (9))){
var _ = (function (){var statearr_45150 = state_45132;
(statearr_45150[(4)] = cljs.core.rest((state_45132[(4)])));

return statearr_45150;
})();
var state_45132__$1 = state_45132;
var ex45145 = (state_45132__$1[(2)]);
var statearr_45151_45178 = state_45132__$1;
(statearr_45151_45178[(5)] = ex45145);


var statearr_45152_45179 = state_45132__$1;
(statearr_45152_45179[(1)] = (4));

(statearr_45152_45179[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (5))){
var inst_45077 = (state_45132[(7)]);
var _ = (function (){var statearr_45153 = state_45132;
(statearr_45153[(4)] = cljs.core.cons((8),(state_45132[(4)])));

return statearr_45153;
})();
var inst_45084 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45077,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_45154 = state_45132;
(statearr_45154[(4)] = cljs.core.rest((state_45132[(4)])));

return statearr_45154;
})();
var state_45132__$1 = state_45132;
var statearr_45155_45180 = state_45132__$1;
(statearr_45155_45180[(2)] = inst_45084);

(statearr_45155_45180[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (14))){
var state_45132__$1 = state_45132;
var statearr_45156_45181 = state_45132__$1;
(statearr_45156_45181[(2)] = null);

(statearr_45156_45181[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (16))){
var inst_45113 = (state_45132[(10)]);
var inst_45122 = (state_45132[(2)]);
var inst_45123 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45124 = [inst_45122,inst_45113];
var inst_45125 = (new cljs.core.PersistentVector(null,2,(5),inst_45123,inst_45124,null));
var state_45132__$1 = state_45132;
var statearr_45158_45182 = state_45132__$1;
(statearr_45158_45182[(2)] = inst_45125);

(statearr_45158_45182[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (10))){
var inst_45096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45097 = [null,(0)];
var inst_45098 = (new cljs.core.PersistentVector(null,2,(5),inst_45096,inst_45097,null));
var state_45132__$1 = state_45132;
var statearr_45159_45183 = state_45132__$1;
(statearr_45159_45183[(2)] = inst_45098);

(statearr_45159_45183[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45133 === (8))){
var _ = (function (){var statearr_45160 = state_45132;
(statearr_45160[(4)] = cljs.core.rest((state_45132[(4)])));

return statearr_45160;
})();
var state_45132__$1 = state_45132;
var ex45157 = (state_45132__$1[(2)]);
var statearr_45161_45184 = state_45132__$1;
(statearr_45161_45184[(5)] = ex45157);


var statearr_45162_45185 = state_45132__$1;
(statearr_45162_45185[(1)] = (7));

(statearr_45162_45185[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto____0 = (function (){
var statearr_45163 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45163[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto__);

(statearr_45163[(1)] = (1));

return statearr_45163;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto____1 = (function (state_45132){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45132);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45164){var ex__16398__auto__ = e45164;
var statearr_45165_45186 = state_45132;
(statearr_45165_45186[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45132[(4)]))){
var statearr_45166_45187 = state_45132;
(statearr_45166_45187[(1)] = cljs.core.first((state_45132[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45188 = state_45132;
state_45132 = G__45188;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto__ = function(state_45132){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto____1.call(this,state_45132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45167 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45167[(6)] = c__16469__auto__);

return statearr_45167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45240){
var state_val_45241 = (state_45240[(1)]);
if((state_val_45241 === (7))){
var inst_45190 = (state_45240[(2)]);
var state_45240__$1 = state_45240;
var statearr_45242_45271 = state_45240__$1;
(statearr_45242_45271[(2)] = inst_45190);

(statearr_45242_45271[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45241 === (1))){
var state_45240__$1 = state_45240;
var statearr_45243_45272 = state_45240__$1;
(statearr_45243_45272[(2)] = null);

(statearr_45243_45272[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45241 === (4))){
var inst_45189 = (state_45240[(2)]);
var state_45240__$1 = (function (){var statearr_45244 = state_45240;
(statearr_45244[(7)] = inst_45189);

return statearr_45244;
})();
var statearr_45245_45273 = state_45240__$1;
(statearr_45245_45273[(2)] = null);

(statearr_45245_45273[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45241 === (13))){
var inst_45235 = (state_45240[(2)]);
var _ = (function (){var statearr_45246 = state_45240;
(statearr_45246[(4)] = cljs.core.rest((state_45240[(4)])));

return statearr_45246;
})();
var state_45240__$1 = state_45240;
var statearr_45247_45274 = state_45240__$1;
(statearr_45247_45274[(2)] = inst_45235);

(statearr_45247_45274[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45241 === (6))){
var inst_45199 = (state_45240[(2)]);
var state_45240__$1 = state_45240;
var statearr_45248_45275 = state_45240__$1;
(statearr_45248_45275[(2)] = inst_45199);

(statearr_45248_45275[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45241 === (3))){
var inst_45238 = (state_45240[(2)]);
var state_45240__$1 = state_45240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45240__$1,inst_45238);
} else {
if((state_val_45241 === (12))){
var inst_45222 = (state_45240[(8)]);
var inst_45231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45232 = [null,inst_45222];
var inst_45233 = (new cljs.core.PersistentVector(null,2,(5),inst_45231,inst_45232,null));
var state_45240__$1 = state_45240;
var statearr_45249_45276 = state_45240__$1;
(statearr_45249_45276[(2)] = inst_45233);

(statearr_45249_45276[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45241 === (2))){
var _ = (function (){var statearr_45251 = state_45240;
(statearr_45251[(4)] = cljs.core.cons((9),(state_45240[(4)])));

return statearr_45251;
})();
var inst_45208 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_45209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45211 = [null,pred_name,"?o"];
var inst_45212 = (new cljs.core.PersistentVector(null,3,(5),inst_45210,inst_45211,null));
var inst_45213 = [inst_45212];
var inst_45214 = (new cljs.core.PersistentVector(null,1,(5),inst_45209,inst_45213,null));
var inst_45215 = ["?o",inst_45214,opts];
var inst_45216 = cljs.core.PersistentHashMap.fromArrays(inst_45208,inst_45215);
var inst_45217 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_45216);
var state_45240__$1 = state_45240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45240__$1,(10),inst_45217);
} else {
if((state_val_45241 === (11))){
var inst_45222 = (state_45240[(8)]);
var inst_45221 = (state_45240[(9)]);
var inst_45226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45227 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_45221);
var inst_45228 = [inst_45227,inst_45222];
var inst_45229 = (new cljs.core.PersistentVector(null,2,(5),inst_45226,inst_45228,null));
var state_45240__$1 = state_45240;
var statearr_45252_45277 = state_45240__$1;
(statearr_45252_45277[(2)] = inst_45229);

(statearr_45252_45277[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45241 === (9))){
var _ = (function (){var statearr_45253 = state_45240;
(statearr_45253[(4)] = cljs.core.rest((state_45240[(4)])));

return statearr_45253;
})();
var state_45240__$1 = state_45240;
var ex45250 = (state_45240__$1[(2)]);
var statearr_45254_45278 = state_45240__$1;
(statearr_45254_45278[(5)] = ex45250);


var statearr_45255_45279 = state_45240__$1;
(statearr_45255_45279[(1)] = (4));

(statearr_45255_45279[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45241 === (5))){
var inst_45189 = (state_45240[(7)]);
var _ = (function (){var statearr_45257 = state_45240;
(statearr_45257[(4)] = cljs.core.cons((8),(state_45240[(4)])));

return statearr_45257;
})();
var inst_45196 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45189,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_45258 = state_45240;
(statearr_45258[(4)] = cljs.core.rest((state_45240[(4)])));

return statearr_45258;
})();
var state_45240__$1 = state_45240;
var statearr_45259_45280 = state_45240__$1;
(statearr_45259_45280[(2)] = inst_45196);

(statearr_45259_45280[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45241 === (10))){
var inst_45221 = (state_45240[(9)]);
var inst_45219 = (state_45240[(2)]);
var inst_45220 = fluree.db.util.async.throw_err(inst_45219);
var inst_45221__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45220,(0),null);
var inst_45222 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45220,(1),null);
var inst_45223 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_45221__$1);
var inst_45224 = cljs.core.not(inst_45223);
var state_45240__$1 = (function (){var statearr_45260 = state_45240;
(statearr_45260[(8)] = inst_45222);

(statearr_45260[(9)] = inst_45221__$1);

return statearr_45260;
})();
if(inst_45224){
var statearr_45261_45281 = state_45240__$1;
(statearr_45261_45281[(1)] = (11));

} else {
var statearr_45262_45282 = state_45240__$1;
(statearr_45262_45282[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45241 === (8))){
var _ = (function (){var statearr_45263 = state_45240;
(statearr_45263[(4)] = cljs.core.rest((state_45240[(4)])));

return statearr_45263;
})();
var state_45240__$1 = state_45240;
var ex45256 = (state_45240__$1[(2)]);
var statearr_45264_45283 = state_45240__$1;
(statearr_45264_45283[(5)] = ex45256);


var statearr_45265_45284 = state_45240__$1;
(statearr_45265_45284[(1)] = (7));

(statearr_45265_45284[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto____0 = (function (){
var statearr_45266 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45266[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto__);

(statearr_45266[(1)] = (1));

return statearr_45266;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto____1 = (function (state_45240){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45240);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45267){var ex__16398__auto__ = e45267;
var statearr_45268_45285 = state_45240;
(statearr_45268_45285[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45240[(4)]))){
var statearr_45269_45286 = state_45240;
(statearr_45269_45286[(1)] = cljs.core.first((state_45240[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45287 = state_45240;
state_45240 = G__45287;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto__ = function(state_45240){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto____1.call(this,state_45240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45270 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45270[(6)] = c__16469__auto__);

return statearr_45270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4210__auto__ = typeof email === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4210__auto__;
}
})());
}catch (e45288){var e = e45288;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__45290 = arguments.length;
switch (G__45290) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45360){
var state_val_45361 = (state_45360[(1)]);
if((state_val_45361 === (7))){
var inst_45292 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
var statearr_45362_45406 = state_45360__$1;
(statearr_45362_45406[(2)] = inst_45292);

(statearr_45362_45406[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (20))){
var inst_45336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45337 = ["*"];
var inst_45338 = (new cljs.core.PersistentVector(null,1,(5),inst_45336,inst_45337,null));
var state_45360__$1 = state_45360;
var statearr_45363_45407 = state_45360__$1;
(statearr_45363_45407[(2)] = inst_45338);

(statearr_45363_45407[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (1))){
var state_45360__$1 = state_45360;
var statearr_45364_45408 = state_45360__$1;
(statearr_45364_45408[(2)] = null);

(statearr_45364_45408[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (4))){
var inst_45291 = (state_45360[(2)]);
var state_45360__$1 = (function (){var statearr_45365 = state_45360;
(statearr_45365[(7)] = inst_45291);

return statearr_45365;
})();
var statearr_45366_45409 = state_45360__$1;
(statearr_45366_45409[(2)] = null);

(statearr_45366_45409[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (15))){
var inst_45355 = (state_45360[(2)]);
var _ = (function (){var statearr_45367 = state_45360;
(statearr_45367[(4)] = cljs.core.rest((state_45360[(4)])));

return statearr_45367;
})();
var state_45360__$1 = state_45360;
var statearr_45368_45410 = state_45360__$1;
(statearr_45368_45410[(2)] = inst_45355);

(statearr_45368_45410[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (21))){
var inst_45319 = (state_45360[(8)]);
var inst_45326 = (state_45360[(9)]);
var inst_45340 = (state_45360[(2)]);
var inst_45341 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_45342 = cljs.core.PersistentHashMap.EMPTY;
var inst_45343 = [inst_45340,inst_45326,inst_45342];
var inst_45344 = cljs.core.PersistentHashMap.fromArrays(inst_45341,inst_45343);
var inst_45345 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_45319,inst_45344);
var state_45360__$1 = state_45360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45360__$1,(22),inst_45345);
} else {
if((state_val_45361 === (13))){
var inst_45314 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_45360__$1 = state_45360;
var statearr_45369_45411 = state_45360__$1;
(statearr_45369_45411[(2)] = inst_45314);

(statearr_45369_45411[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (22))){
var inst_45347 = (state_45360[(2)]);
var inst_45348 = fluree.db.util.async.throw_err(inst_45347);
var inst_45349 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45348,(0),null);
var inst_45350 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45348,(1),null);
var inst_45351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45352 = [inst_45349,inst_45350];
var inst_45353 = (new cljs.core.PersistentVector(null,2,(5),inst_45351,inst_45352,null));
var state_45360__$1 = state_45360;
var statearr_45370_45412 = state_45360__$1;
(statearr_45370_45412[(2)] = inst_45353);

(statearr_45370_45412[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (6))){
var inst_45301 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
var statearr_45371_45413 = state_45360__$1;
(statearr_45371_45413[(2)] = inst_45301);

(statearr_45371_45413[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (17))){
var inst_45323 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45324 = fluree.db.dbfunctions.internal.get(inst_45323,cljs.core.cst$kw$_id);
var state_45360__$1 = state_45360;
var statearr_45372_45414 = state_45360__$1;
(statearr_45372_45414[(2)] = inst_45324);

(statearr_45372_45414[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (3))){
var inst_45358 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45360__$1,inst_45358);
} else {
if((state_val_45361 === (12))){
var inst_45312 = (state_45360[(2)]);
var state_45360__$1 = state_45360;
if(cljs.core.truth_(inst_45312)){
var statearr_45373_45415 = state_45360__$1;
(statearr_45373_45415[(1)] = (13));

} else {
var statearr_45374_45416 = state_45360__$1;
(statearr_45374_45416[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (2))){
var inst_45307 = (state_45360[(10)]);
var _ = (function (){var statearr_45375 = state_45360;
(statearr_45375[(4)] = cljs.core.cons((9),(state_45360[(4)])));

return statearr_45375;
})();
var inst_45307__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_45360__$1 = (function (){var statearr_45376 = state_45360;
(statearr_45376[(10)] = inst_45307__$1);

return statearr_45376;
})();
if(cljs.core.truth_(inst_45307__$1)){
var statearr_45377_45417 = state_45360__$1;
(statearr_45377_45417[(1)] = (10));

} else {
var statearr_45378_45418 = state_45360__$1;
(statearr_45378_45418[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (19))){
var inst_45328 = cljs.core.PersistentVector.EMPTY;
var inst_45329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45330 = ["*"];
var inst_45331 = (new cljs.core.PersistentVector(null,1,(5),inst_45329,inst_45330,null));
var inst_45332 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_45333 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_45331,inst_45332);
var inst_45334 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_45328,inst_45333);
var state_45360__$1 = state_45360;
var statearr_45380_45419 = state_45360__$1;
(statearr_45380_45419[(2)] = inst_45334);

(statearr_45380_45419[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (11))){
var inst_45307 = (state_45360[(10)]);
var state_45360__$1 = state_45360;
var statearr_45381_45420 = state_45360__$1;
(statearr_45381_45420[(2)] = inst_45307);

(statearr_45381_45420[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (9))){
var _ = (function (){var statearr_45382 = state_45360;
(statearr_45382[(4)] = cljs.core.rest((state_45360[(4)])));

return statearr_45382;
})();
var state_45360__$1 = state_45360;
var ex45379 = (state_45360__$1[(2)]);
var statearr_45383_45421 = state_45360__$1;
(statearr_45383_45421[(5)] = ex45379);


var statearr_45384_45422 = state_45360__$1;
(statearr_45384_45422[(1)] = (4));

(statearr_45384_45422[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (5))){
var inst_45291 = (state_45360[(7)]);
var _ = (function (){var statearr_45385 = state_45360;
(statearr_45385[(4)] = cljs.core.cons((8),(state_45360[(4)])));

return statearr_45385;
})();
var inst_45298 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45291,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_45386 = state_45360;
(statearr_45386[(4)] = cljs.core.rest((state_45360[(4)])));

return statearr_45386;
})();
var state_45360__$1 = state_45360;
var statearr_45387_45423 = state_45360__$1;
(statearr_45387_45423[(2)] = inst_45298);

(statearr_45387_45423[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (14))){
var inst_45320 = (state_45360[(11)]);
var inst_45319 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45320__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_45360__$1 = (function (){var statearr_45388 = state_45360;
(statearr_45388[(11)] = inst_45320__$1);

(statearr_45388[(8)] = inst_45319);

return statearr_45388;
})();
if(cljs.core.truth_(inst_45320__$1)){
var statearr_45389_45424 = state_45360__$1;
(statearr_45389_45424[(1)] = (16));

} else {
var statearr_45390_45425 = state_45360__$1;
(statearr_45390_45425[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (16))){
var inst_45320 = (state_45360[(11)]);
var state_45360__$1 = state_45360;
var statearr_45391_45426 = state_45360__$1;
(statearr_45391_45426[(2)] = inst_45320);

(statearr_45391_45426[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (10))){
var inst_45309 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_45360__$1 = state_45360;
var statearr_45393_45427 = state_45360__$1;
(statearr_45393_45427[(2)] = inst_45309);

(statearr_45393_45427[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (18))){
var inst_45326 = (state_45360[(2)]);
var state_45360__$1 = (function (){var statearr_45394 = state_45360;
(statearr_45394[(9)] = inst_45326);

return statearr_45394;
})();
if(cljs.core.truth_(additional_params)){
var statearr_45395_45428 = state_45360__$1;
(statearr_45395_45428[(1)] = (19));

} else {
var statearr_45396_45429 = state_45360__$1;
(statearr_45396_45429[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45361 === (8))){
var _ = (function (){var statearr_45397 = state_45360;
(statearr_45397[(4)] = cljs.core.rest((state_45360[(4)])));

return statearr_45397;
})();
var state_45360__$1 = state_45360;
var ex45392 = (state_45360__$1[(2)]);
var statearr_45398_45430 = state_45360__$1;
(statearr_45398_45430[(5)] = ex45392);


var statearr_45399_45431 = state_45360__$1;
(statearr_45399_45431[(1)] = (7));

(statearr_45399_45431[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16395__auto____0 = (function (){
var statearr_45400 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45400[(0)] = fluree$db$dbfunctions$internal$state_machine__16395__auto__);

(statearr_45400[(1)] = (1));

return statearr_45400;
});
var fluree$db$dbfunctions$internal$state_machine__16395__auto____1 = (function (state_45360){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45360);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45401){var ex__16398__auto__ = e45401;
var statearr_45402_45432 = state_45360;
(statearr_45402_45432[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45360[(4)]))){
var statearr_45403_45433 = state_45360;
(statearr_45403_45433[(1)] = cljs.core.first((state_45360[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45434 = state_45360;
state_45360 = G__45434;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16395__auto__ = function(state_45360){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____1.call(this,state_45360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45404 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45404[(6)] = c__16469__auto__);

return statearr_45404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__45436 = arguments.length;
switch (G__45436) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45480){
var state_val_45481 = (state_45480[(1)]);
if((state_val_45481 === (7))){
var inst_45458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45459 = ["*"];
var inst_45460 = (new cljs.core.PersistentVector(null,1,(5),inst_45458,inst_45459,null));
var state_45480__$1 = state_45480;
var statearr_45482_45502 = state_45480__$1;
(statearr_45482_45502[(2)] = inst_45460);

(statearr_45482_45502[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45481 === (1))){
var state_45480__$1 = state_45480;
var statearr_45483_45503 = state_45480__$1;
(statearr_45483_45503[(2)] = null);

(statearr_45483_45503[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45481 === (4))){
var inst_45437 = (state_45480[(2)]);
var inst_45438 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45437,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_45480__$1 = state_45480;
var statearr_45484_45504 = state_45480__$1;
(statearr_45484_45504[(2)] = inst_45438);

(statearr_45484_45504[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45481 === (6))){
var inst_45450 = cljs.core.PersistentVector.EMPTY;
var inst_45451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45452 = ["*"];
var inst_45453 = (new cljs.core.PersistentVector(null,1,(5),inst_45451,inst_45452,null));
var inst_45454 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_45455 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_45453,inst_45454);
var inst_45456 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_45450,inst_45455);
var state_45480__$1 = state_45480;
var statearr_45485_45505 = state_45480__$1;
(statearr_45485_45505[(2)] = inst_45456);

(statearr_45485_45505[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45481 === (3))){
var inst_45478 = (state_45480[(2)]);
var state_45480__$1 = state_45480;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45480__$1,inst_45478);
} else {
if((state_val_45481 === (2))){
var _ = (function (){var statearr_45487 = state_45480;
(statearr_45487[(4)] = cljs.core.cons((5),(state_45480[(4)])));

return statearr_45487;
})();
var inst_45447 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45448 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_45480__$1 = (function (){var statearr_45488 = state_45480;
(statearr_45488[(7)] = inst_45448);

(statearr_45488[(8)] = inst_45447);

return statearr_45488;
})();
if(cljs.core.truth_(additional_params)){
var statearr_45489_45506 = state_45480__$1;
(statearr_45489_45506[(1)] = (6));

} else {
var statearr_45490_45507 = state_45480__$1;
(statearr_45490_45507[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45481 === (9))){
var inst_45469 = (state_45480[(2)]);
var inst_45470 = fluree.db.util.async.throw_err(inst_45469);
var inst_45471 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45470,(0),null);
var inst_45472 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45470,(1),null);
var inst_45473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45474 = [inst_45471,inst_45472];
var inst_45475 = (new cljs.core.PersistentVector(null,2,(5),inst_45473,inst_45474,null));
var _ = (function (){var statearr_45491 = state_45480;
(statearr_45491[(4)] = cljs.core.rest((state_45480[(4)])));

return statearr_45491;
})();
var state_45480__$1 = state_45480;
var statearr_45492_45508 = state_45480__$1;
(statearr_45492_45508[(2)] = inst_45475);

(statearr_45492_45508[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45481 === (5))){
var _ = (function (){var statearr_45493 = state_45480;
(statearr_45493[(4)] = cljs.core.rest((state_45480[(4)])));

return statearr_45493;
})();
var state_45480__$1 = state_45480;
var ex45486 = (state_45480__$1[(2)]);
var statearr_45494_45509 = state_45480__$1;
(statearr_45494_45509[(5)] = ex45486);


var statearr_45495_45510 = state_45480__$1;
(statearr_45495_45510[(1)] = (4));

(statearr_45495_45510[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45481 === (8))){
var inst_45448 = (state_45480[(7)]);
var inst_45447 = (state_45480[(8)]);
var inst_45462 = (state_45480[(2)]);
var inst_45463 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_45464 = cljs.core.PersistentHashMap.EMPTY;
var inst_45465 = [inst_45462,inst_45448,inst_45464];
var inst_45466 = cljs.core.PersistentHashMap.fromArrays(inst_45463,inst_45465);
var inst_45467 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_45447,inst_45466);
var state_45480__$1 = state_45480;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45480__$1,(9),inst_45467);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16395__auto____0 = (function (){
var statearr_45496 = [null,null,null,null,null,null,null,null,null];
(statearr_45496[(0)] = fluree$db$dbfunctions$internal$state_machine__16395__auto__);

(statearr_45496[(1)] = (1));

return statearr_45496;
});
var fluree$db$dbfunctions$internal$state_machine__16395__auto____1 = (function (state_45480){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45480);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45497){var ex__16398__auto__ = e45497;
var statearr_45498_45511 = state_45480;
(statearr_45498_45511[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45480[(4)]))){
var statearr_45499_45512 = state_45480;
(statearr_45499_45512[(1)] = cljs.core.first((state_45480[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45513 = state_45480;
state_45480 = G__45513;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16395__auto__ = function(state_45480){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16395__auto____1.call(this,state_45480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45500 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45500[(6)] = c__16469__auto__);

return statearr_45500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45557){
var state_val_45558 = (state_45557[(1)]);
if((state_val_45558 === (1))){
var state_45557__$1 = state_45557;
var statearr_45559_45573 = state_45557__$1;
(statearr_45559_45573[(2)] = null);

(statearr_45559_45573[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45558 === (2))){
var _ = (function (){var statearr_45560 = state_45557;
(statearr_45560[(4)] = cljs.core.cons((5),(state_45557[(4)])));

return statearr_45560;
})();
var inst_45524 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_45525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45526 = ["_user/_auth"];
var inst_45527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45528 = ["*"];
var inst_45529 = (new cljs.core.PersistentVector(null,1,(5),inst_45527,inst_45528,null));
var inst_45530 = [inst_45529];
var inst_45531 = cljs.core.PersistentHashMap.fromArrays(inst_45526,inst_45530);
var inst_45532 = [inst_45531];
var inst_45533 = (new cljs.core.PersistentVector(null,1,(5),inst_45525,inst_45532,null));
var inst_45534 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45535 = cljs.core.PersistentHashMap.EMPTY;
var inst_45536 = [inst_45533,inst_45534,inst_45535];
var inst_45537 = cljs.core.PersistentHashMap.fromArrays(inst_45524,inst_45536);
var inst_45538 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45539 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_45538,inst_45537);
var state_45557__$1 = state_45557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45557__$1,(6),inst_45539);
} else {
if((state_val_45558 === (3))){
var inst_45555 = (state_45557[(2)]);
var state_45557__$1 = state_45557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45557__$1,inst_45555);
} else {
if((state_val_45558 === (4))){
var inst_45514 = (state_45557[(2)]);
var inst_45515 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_45514,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_45557__$1 = state_45557;
var statearr_45562_45574 = state_45557__$1;
(statearr_45562_45574[(2)] = inst_45515);

(statearr_45562_45574[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45558 === (5))){
var _ = (function (){var statearr_45563 = state_45557;
(statearr_45563[(4)] = cljs.core.rest((state_45557[(4)])));

return statearr_45563;
})();
var state_45557__$1 = state_45557;
var ex45561 = (state_45557__$1[(2)]);
var statearr_45564_45575 = state_45557__$1;
(statearr_45564_45575[(5)] = ex45561);


var statearr_45565_45576 = state_45557__$1;
(statearr_45565_45576[(1)] = (4));

(statearr_45565_45576[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45558 === (6))){
var inst_45541 = (state_45557[(2)]);
var inst_45542 = fluree.db.util.async.throw_err(inst_45541);
var inst_45543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45542,(0),null);
var inst_45544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45542,(1),null);
var inst_45545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45546 = ["_user/_auth","_id"];
var inst_45547 = (new cljs.core.PersistentVector(null,2,(5),inst_45545,inst_45546,null));
var inst_45548 = fluree.db.dbfunctions.internal.get_in(inst_45543,inst_45547);
var inst_45549 = cljs.core.first(inst_45548);
var inst_45550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45551 = [inst_45549,inst_45544];
var inst_45552 = (new cljs.core.PersistentVector(null,2,(5),inst_45550,inst_45551,null));
var _ = (function (){var statearr_45566 = state_45557;
(statearr_45566[(4)] = cljs.core.rest((state_45557[(4)])));

return statearr_45566;
})();
var state_45557__$1 = state_45557;
var statearr_45567_45577 = state_45557__$1;
(statearr_45567_45577[(2)] = inst_45552);

(statearr_45567_45577[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto____0 = (function (){
var statearr_45568 = [null,null,null,null,null,null,null];
(statearr_45568[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto__);

(statearr_45568[(1)] = (1));

return statearr_45568;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto____1 = (function (state_45557){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45557);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45569){var ex__16398__auto__ = e45569;
var statearr_45570_45578 = state_45557;
(statearr_45570_45578[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45557[(4)]))){
var statearr_45571_45579 = state_45557;
(statearr_45571_45579[(1)] = cljs.core.first((state_45557[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45580 = state_45557;
state_45557 = G__45580;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto__ = function(state_45557){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto____1.call(this,state_45557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45572 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45572[(6)] = c__16469__auto__);

return statearr_45572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45597){
var state_val_45598 = (state_45597[(1)]);
if((state_val_45598 === (1))){
var state_45597__$1 = state_45597;
var statearr_45599_45613 = state_45597__$1;
(statearr_45599_45613[(2)] = null);

(statearr_45599_45613[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45598 === (2))){
var _ = (function (){var statearr_45600 = state_45597;
(statearr_45600[(4)] = cljs.core.cons((5),(state_45597[(4)])));

return statearr_45600;
})();
var inst_45587 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45588 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_45589 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_45588,inst_45587);
var state_45597__$1 = state_45597;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45597__$1,(6),inst_45589);
} else {
if((state_val_45598 === (3))){
var inst_45595 = (state_45597[(2)]);
var state_45597__$1 = state_45597;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45597__$1,inst_45595);
} else {
if((state_val_45598 === (4))){
var inst_45581 = (state_45597[(2)]);
var state_45597__$1 = state_45597;
var statearr_45602_45614 = state_45597__$1;
(statearr_45602_45614[(2)] = inst_45581);

(statearr_45602_45614[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45598 === (5))){
var _ = (function (){var statearr_45603 = state_45597;
(statearr_45603[(4)] = cljs.core.rest((state_45597[(4)])));

return statearr_45603;
})();
var state_45597__$1 = state_45597;
var ex45601 = (state_45597__$1[(2)]);
var statearr_45604_45615 = state_45597__$1;
(statearr_45604_45615[(5)] = ex45601);


if((ex45601 instanceof Error)){
var statearr_45605_45616 = state_45597__$1;
(statearr_45605_45616[(1)] = (4));

(statearr_45605_45616[(5)] = null);

} else {
throw ex45601;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45598 === (6))){
var inst_45591 = (state_45597[(2)]);
var inst_45592 = fluree.db.util.async.throw_err(inst_45591);
var _ = (function (){var statearr_45606 = state_45597;
(statearr_45606[(4)] = cljs.core.rest((state_45597[(4)])));

return statearr_45606;
})();
var state_45597__$1 = state_45597;
var statearr_45607_45617 = state_45597__$1;
(statearr_45607_45617[(2)] = inst_45592);

(statearr_45607_45617[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto____0 = (function (){
var statearr_45608 = [null,null,null,null,null,null,null];
(statearr_45608[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto__);

(statearr_45608[(1)] = (1));

return statearr_45608;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto____1 = (function (state_45597){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45597);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45609){var ex__16398__auto__ = e45609;
var statearr_45610_45618 = state_45597;
(statearr_45610_45618[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45597[(4)]))){
var statearr_45611_45619 = state_45597;
(statearr_45611_45619[(1)] = cljs.core.first((state_45597[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45620 = state_45597;
state_45597 = G__45620;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto__ = function(state_45597){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto____1.call(this,state_45597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45612 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45612[(6)] = c__16469__auto__);

return statearr_45612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__45621_SHARP_){
return p1__45621_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45622_SHARP_){
return p1__45622_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e45623){var e = e45623;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__45624_SHARP_){
return p1__45624_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__45625_SHARP_){
return p1__45625_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e45626){var e = e45626;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__45628 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__45628);
})() | (0));
return num;
}catch (e45627){var e = e45627;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_45708){
var state_val_45709 = (state_45708[(1)]);
if((state_val_45709 === (7))){
var inst_45647 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_45648 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45649 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45650 = cljs.core.PersistentHashMap.fromArrays(inst_45648,inst_45649);
var inst_45651 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45647,inst_45650);
var inst_45652 = (function(){throw inst_45651})();
var state_45708__$1 = state_45708;
var statearr_45710_45745 = state_45708__$1;
(statearr_45710_45745[(2)] = inst_45652);

(statearr_45710_45745[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (1))){
var state_45708__$1 = state_45708;
var statearr_45711_45746 = state_45708__$1;
(statearr_45711_45746[(2)] = null);

(statearr_45711_45746[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (4))){
var inst_45629 = (state_45708[(2)]);
var state_45708__$1 = state_45708;
var statearr_45712_45747 = state_45708__$1;
(statearr_45712_45747[(2)] = inst_45629);

(statearr_45712_45747[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (15))){
var inst_45692 = (state_45708[(7)]);
var inst_45688 = (state_45708[(2)]);
var inst_45689 = fluree.db.util.async.throw_err(inst_45688);
var inst_45690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45689,(0),null);
var inst_45691 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45689,(1),null);
var inst_45692__$1 = cljs.core.first(inst_45690);
var inst_45693 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45692__$1,compare_val);
var state_45708__$1 = (function (){var statearr_45713 = state_45708;
(statearr_45713[(7)] = inst_45692__$1);

(statearr_45713[(8)] = inst_45691);

return statearr_45713;
})();
if(inst_45693){
var statearr_45714_45748 = state_45708__$1;
(statearr_45714_45748[(1)] = (16));

} else {
var statearr_45715_45749 = state_45708__$1;
(statearr_45715_45749[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (13))){
var state_45708__$1 = state_45708;
var statearr_45716_45750 = state_45708__$1;
(statearr_45716_45750[(2)] = null);

(statearr_45716_45750[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (6))){
var state_45708__$1 = state_45708;
var statearr_45717_45751 = state_45708__$1;
(statearr_45717_45751[(2)] = null);

(statearr_45717_45751[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (17))){
var inst_45692 = (state_45708[(7)]);
var inst_45696 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_45692)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_45697 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45698 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45699 = cljs.core.PersistentHashMap.fromArrays(inst_45697,inst_45698);
var inst_45700 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45696,inst_45699);
var inst_45701 = (function(){throw inst_45700})();
var state_45708__$1 = state_45708;
var statearr_45718_45752 = state_45708__$1;
(statearr_45718_45752[(2)] = inst_45701);

(statearr_45718_45752[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (3))){
var inst_45706 = (state_45708[(2)]);
var state_45708__$1 = state_45708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45708__$1,inst_45706);
} else {
if((state_val_45709 === (12))){
var inst_45644 = (state_45708[(9)]);
var inst_45667 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_45644], 0));
var inst_45668 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45669 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45670 = cljs.core.PersistentHashMap.fromArrays(inst_45668,inst_45669);
var inst_45671 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45667,inst_45670);
var inst_45672 = (function(){throw inst_45671})();
var state_45708__$1 = state_45708;
var statearr_45719_45753 = state_45708__$1;
(statearr_45719_45753[(2)] = inst_45672);

(statearr_45719_45753[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (2))){
var inst_45642 = (state_45708[(10)]);
var inst_45643 = (state_45708[(11)]);
var inst_45641 = (state_45708[(12)]);
var _ = (function (){var statearr_45720 = state_45708;
(statearr_45720[(4)] = cljs.core.cons((5),(state_45708[(4)])));

return statearr_45720;
})();
var inst_45639 = _QMARK_ctx;
var inst_45640 = cljs.core.__destructure_map(inst_45639);
var inst_45641__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45640,cljs.core.cst$kw$sid);
var inst_45642__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45640,cljs.core.cst$kw$pid);
var inst_45643__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45640,cljs.core.cst$kw$db);
var inst_45644 = fluree.db.dbproto._p_prop(inst_45643__$1,cljs.core.cst$kw$name,inst_45642__$1);
var state_45708__$1 = (function (){var statearr_45721 = state_45708;
(statearr_45721[(10)] = inst_45642__$1);

(statearr_45721[(11)] = inst_45643__$1);

(statearr_45721[(9)] = inst_45644);

(statearr_45721[(12)] = inst_45641__$1);

return statearr_45721;
})();
if(cljs.core.truth_(inst_45641__$1)){
var statearr_45722_45754 = state_45708__$1;
(statearr_45722_45754[(1)] = (6));

} else {
var statearr_45723_45755 = state_45708__$1;
(statearr_45723_45755[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (11))){
var inst_45642 = (state_45708[(10)]);
var inst_45643 = (state_45708[(11)]);
var inst_45664 = (state_45708[(2)]);
var inst_45665 = fluree.db.dbproto._p_prop(inst_45643,cljs.core.cst$kw$multi,inst_45642);
var state_45708__$1 = (function (){var statearr_45725 = state_45708;
(statearr_45725[(13)] = inst_45664);

return statearr_45725;
})();
if(cljs.core.truth_(inst_45665)){
var statearr_45726_45756 = state_45708__$1;
(statearr_45726_45756[(1)] = (12));

} else {
var statearr_45727_45757 = state_45708__$1;
(statearr_45727_45757[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (9))){
var state_45708__$1 = state_45708;
var statearr_45728_45758 = state_45708__$1;
(statearr_45728_45758[(2)] = null);

(statearr_45728_45758[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (5))){
var _ = (function (){var statearr_45729 = state_45708;
(statearr_45729[(4)] = cljs.core.rest((state_45708[(4)])));

return statearr_45729;
})();
var state_45708__$1 = state_45708;
var ex45724 = (state_45708__$1[(2)]);
var statearr_45730_45759 = state_45708__$1;
(statearr_45730_45759[(5)] = ex45724);


if((ex45724 instanceof Error)){
var statearr_45731_45760 = state_45708__$1;
(statearr_45731_45760[(1)] = (4));

(statearr_45731_45760[(5)] = null);

} else {
throw ex45724;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (14))){
var inst_45643 = (state_45708[(11)]);
var inst_45644 = (state_45708[(9)]);
var inst_45641 = (state_45708[(12)]);
var inst_45675 = (state_45708[(2)]);
var inst_45676 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_45677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45679 = [inst_45641,inst_45644,"?current-val"];
var inst_45680 = (new cljs.core.PersistentVector(null,3,(5),inst_45678,inst_45679,null));
var inst_45681 = [inst_45680];
var inst_45682 = (new cljs.core.PersistentVector(null,1,(5),inst_45677,inst_45681,null));
var inst_45683 = cljs.core.PersistentHashMap.EMPTY;
var inst_45684 = ["?current-val",inst_45682,inst_45683];
var inst_45685 = cljs.core.PersistentHashMap.fromArrays(inst_45676,inst_45684);
var inst_45686 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_45643,inst_45685);
var state_45708__$1 = (function (){var statearr_45732 = state_45708;
(statearr_45732[(14)] = inst_45675);

return statearr_45732;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45708__$1,(15),inst_45686);
} else {
if((state_val_45709 === (16))){
var state_45708__$1 = state_45708;
var statearr_45733_45761 = state_45708__$1;
(statearr_45733_45761[(2)] = new_val);

(statearr_45733_45761[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (10))){
var inst_45657 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_45658 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45659 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_45660 = cljs.core.PersistentHashMap.fromArrays(inst_45658,inst_45659);
var inst_45661 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45657,inst_45660);
var inst_45662 = (function(){throw inst_45661})();
var state_45708__$1 = state_45708;
var statearr_45734_45762 = state_45708__$1;
(statearr_45734_45762[(2)] = inst_45662);

(statearr_45734_45762[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (18))){
var inst_45703 = (state_45708[(2)]);
var _ = (function (){var statearr_45735 = state_45708;
(statearr_45735[(4)] = cljs.core.rest((state_45708[(4)])));

return statearr_45735;
})();
var state_45708__$1 = state_45708;
var statearr_45736_45763 = state_45708__$1;
(statearr_45736_45763[(2)] = inst_45703);

(statearr_45736_45763[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45709 === (8))){
var inst_45644 = (state_45708[(9)]);
var inst_45654 = (state_45708[(2)]);
var state_45708__$1 = (function (){var statearr_45737 = state_45708;
(statearr_45737[(15)] = inst_45654);

return statearr_45737;
})();
if(cljs.core.truth_(inst_45644)){
var statearr_45738_45764 = state_45708__$1;
(statearr_45738_45764[(1)] = (9));

} else {
var statearr_45739_45765 = state_45708__$1;
(statearr_45739_45765[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto____0 = (function (){
var statearr_45740 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45740[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto__);

(statearr_45740[(1)] = (1));

return statearr_45740;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto____1 = (function (state_45708){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_45708);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e45741){var ex__16398__auto__ = e45741;
var statearr_45742_45766 = state_45708;
(statearr_45742_45766[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_45708[(4)]))){
var statearr_45743_45767 = state_45708;
(statearr_45743_45767[(1)] = cljs.core.first((state_45708[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__45768 = state_45708;
state_45708 = G__45768;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto__ = function(state_45708){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto____1.call(this,state_45708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_45744 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_45744[(6)] = c__16469__auto__);

return statearr_45744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
