// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4867__auto___68910 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_68961){
var state_val_68962 = (state_68961[(1)]);
if((state_val_68962 === (7))){
var inst_68956 = (state_68961[(2)]);
var _ = (function (){var statearr_68963 = state_68961;
(statearr_68963[(4)] = cljs.core.rest((state_68961[(4)])));

return statearr_68963;
})();
var state_68961__$1 = state_68961;
var statearr_68964_68991 = state_68961__$1;
(statearr_68964_68991[(2)] = inst_68956);

(statearr_68964_68991[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68962 === (1))){
var state_68961__$1 = state_68961;
var statearr_68965_68992 = state_68961__$1;
(statearr_68965_68992[(2)] = null);

(statearr_68965_68992[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68962 === (4))){
var inst_68911 = (state_68961[(2)]);
var state_68961__$1 = state_68961;
var statearr_68966_68993 = state_68961__$1;
(statearr_68966_68993[(2)] = inst_68911);

(statearr_68966_68993[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68962 === (13))){
var inst_68952 = (state_68961[(2)]);
var state_68961__$1 = state_68961;
var statearr_68967_68994 = state_68961__$1;
(statearr_68967_68994[(2)] = inst_68952);

(statearr_68967_68994[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68962 === (6))){
var inst_68929 = (state_68961[(7)]);
var inst_68936 = (state_68961[(8)]);
var inst_68935 = cljs.core.seq(inst_68929);
var inst_68936__$1 = cljs.core.first(inst_68935);
var inst_68937 = cljs.core.next(inst_68935);
var inst_68938 = cljs.core.not(inst_68936__$1);
var state_68961__$1 = (function (){var statearr_68968 = state_68961;
(statearr_68968[(9)] = inst_68937);

(statearr_68968[(8)] = inst_68936__$1);

return statearr_68968;
})();
if(inst_68938){
var statearr_68969_68995 = state_68961__$1;
(statearr_68969_68995[(1)] = (8));

} else {
var statearr_68970_68996 = state_68961__$1;
(statearr_68970_68996[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68962 === (3))){
var inst_68959 = (state_68961[(2)]);
var state_68961__$1 = state_68961;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68961__$1,inst_68959);
} else {
if((state_val_68962 === (12))){
var inst_68937 = (state_68961[(9)]);
var inst_68930 = (state_68961[(10)]);
var inst_68936 = (state_68961[(8)]);
var inst_68949 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_68930,inst_68936);
var inst_68929 = inst_68937;
var inst_68930__$1 = inst_68949;
var state_68961__$1 = (function (){var statearr_68971 = state_68961;
(statearr_68971[(7)] = inst_68929);

(statearr_68971[(10)] = inst_68930__$1);

return statearr_68971;
})();
var statearr_68972_68997 = state_68961__$1;
(statearr_68972_68997[(2)] = null);

(statearr_68972_68997[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68962 === (2))){
var _ = (function (){var statearr_68973 = state_68961;
(statearr_68973[(4)] = cljs.core.cons((5),(state_68961[(4)])));

return statearr_68973;
})();
var inst_68924 = args;
var inst_68925 = cljs.core.seq(inst_68924);
var inst_68926 = cljs.core.first(inst_68925);
var inst_68927 = cljs.core.next(inst_68925);
var inst_68928 = cljs.core.PersistentVector.EMPTY;
var inst_68929 = inst_68924;
var inst_68930 = inst_68928;
var state_68961__$1 = (function (){var statearr_68974 = state_68961;
(statearr_68974[(7)] = inst_68929);

(statearr_68974[(11)] = inst_68927);

(statearr_68974[(10)] = inst_68930);

(statearr_68974[(12)] = inst_68926);

return statearr_68974;
})();
var statearr_68975_68998 = state_68961__$1;
(statearr_68975_68998[(2)] = null);

(statearr_68975_68998[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68962 === (11))){
var inst_68936 = (state_68961[(8)]);
var state_68961__$1 = state_68961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68961__$1,(14),inst_68936);
} else {
if((state_val_68962 === (9))){
var inst_68936 = (state_68961[(8)]);
var inst_68941 = fluree.db.util.async.channel_QMARK_(inst_68936);
var state_68961__$1 = state_68961;
if(inst_68941){
var statearr_68977_68999 = state_68961__$1;
(statearr_68977_68999[(1)] = (11));

} else {
var statearr_68978_69000 = state_68961__$1;
(statearr_68978_69000[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68962 === (5))){
var _ = (function (){var statearr_68979 = state_68961;
(statearr_68979[(4)] = cljs.core.rest((state_68961[(4)])));

return statearr_68979;
})();
var state_68961__$1 = state_68961;
var ex68976 = (state_68961__$1[(2)]);
var statearr_68980_69001 = state_68961__$1;
(statearr_68980_69001[(5)] = ex68976);


if((ex68976 instanceof Error)){
var statearr_68981_69002 = state_68961__$1;
(statearr_68981_69002[(1)] = (4));

(statearr_68981_69002[(5)] = null);

} else {
throw ex68976;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68962 === (14))){
var inst_68937 = (state_68961[(9)]);
var inst_68930 = (state_68961[(10)]);
var inst_68944 = (state_68961[(2)]);
var inst_68945 = fluree.db.util.async.throw_err(inst_68944);
var inst_68946 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_68930,inst_68945);
var inst_68929 = inst_68937;
var inst_68930__$1 = inst_68946;
var state_68961__$1 = (function (){var statearr_68982 = state_68961;
(statearr_68982[(7)] = inst_68929);

(statearr_68982[(10)] = inst_68930__$1);

return statearr_68982;
})();
var statearr_68983_69003 = state_68961__$1;
(statearr_68983_69003[(2)] = null);

(statearr_68983_69003[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68962 === (10))){
var inst_68954 = (state_68961[(2)]);
var state_68961__$1 = state_68961;
var statearr_68984_69004 = state_68961__$1;
(statearr_68984_69004[(2)] = inst_68954);

(statearr_68984_69004[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68962 === (8))){
var inst_68930 = (state_68961[(10)]);
var state_68961__$1 = state_68961;
var statearr_68985_69005 = state_68961__$1;
(statearr_68985_69005[(2)] = inst_68930);

(statearr_68985_69005[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto____0 = (function (){
var statearr_68986 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68986[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto__);

(statearr_68986[(1)] = (1));

return statearr_68986;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto____1 = (function (state_68961){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_68961);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e68987){var ex__16398__auto__ = e68987;
var statearr_68988_69006 = state_68961;
(statearr_68988_69006[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_68961[(4)]))){
var statearr_68989_69007 = state_68961;
(statearr_68989_69007[(1)] = cljs.core.first((state_68961[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69008 = state_68961;
state_68961 = G__69008;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto__ = function(state_68961){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto____1.call(this,state_68961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_68990 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_68990[(6)] = c__16469__auto__);

return statearr_68990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__69009 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69009,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69009,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69057){
var state_val_69058 = (state_69057[(1)]);
if((state_val_69058 === (7))){
var state_69057__$1 = state_69057;
var statearr_69059_69088 = state_69057__$1;
(statearr_69059_69088[(2)] = coll);

(statearr_69059_69088[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69058 === (1))){
var state_69057__$1 = state_69057;
var statearr_69060_69089 = state_69057__$1;
(statearr_69060_69089[(2)] = null);

(statearr_69060_69089[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69058 === (4))){
var inst_69012 = (state_69057[(2)]);
var state_69057__$1 = state_69057;
var statearr_69061_69090 = state_69057__$1;
(statearr_69061_69090[(2)] = inst_69012);

(statearr_69061_69090[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69058 === (15))){
var inst_69031 = (state_69057[(7)]);
var inst_69039 = (state_69057[(2)]);
var inst_69040 = fluree.db.dbfunctions.internal.nth(inst_69031,inst_69039);
var inst_69041 = cljs.core.count(inst_69031);
var inst_69042 = ((9) + inst_69041);
var inst_69043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69044 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69046 = [inst_69031,inst_69039];
var inst_69047 = (new cljs.core.PersistentVector(null,2,(5),inst_69045,inst_69046,null));
var inst_69048 = ["nth",inst_69047,inst_69040];
var inst_69049 = cljs.core.PersistentHashMap.fromArrays(inst_69044,inst_69048);
var inst_69050 = [inst_69049,inst_69042];
var inst_69051 = (new cljs.core.PersistentVector(null,2,(5),inst_69043,inst_69050,null));
var inst_69052 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69051);
var _ = (function (){var statearr_69062 = state_69057;
(statearr_69062[(4)] = cljs.core.rest((state_69057[(4)])));

return statearr_69062;
})();
var state_69057__$1 = (function (){var statearr_69063 = state_69057;
(statearr_69063[(8)] = inst_69052);

return statearr_69063;
})();
var statearr_69064_69091 = state_69057__$1;
(statearr_69064_69091[(2)] = inst_69040);

(statearr_69064_69091[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69058 === (13))){
var state_69057__$1 = state_69057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69057__$1,(16),key);
} else {
if((state_val_69058 === (6))){
var state_69057__$1 = state_69057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69057__$1,(9),coll);
} else {
if((state_val_69058 === (3))){
var inst_69055 = (state_69057[(2)]);
var state_69057__$1 = state_69057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69057__$1,inst_69055);
} else {
if((state_val_69058 === (12))){
var inst_69031 = (state_69057[(2)]);
var inst_69032 = fluree.db.util.async.channel_QMARK_(key);
var state_69057__$1 = (function (){var statearr_69065 = state_69057;
(statearr_69065[(7)] = inst_69031);

return statearr_69065;
})();
if(inst_69032){
var statearr_69066_69092 = state_69057__$1;
(statearr_69066_69092[(1)] = (13));

} else {
var statearr_69067_69093 = state_69057__$1;
(statearr_69067_69093[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69058 === (2))){
var _ = (function (){var statearr_69068 = state_69057;
(statearr_69068[(4)] = cljs.core.cons((5),(state_69057[(4)])));

return statearr_69068;
})();
var inst_69018 = fluree.db.util.async.channel_QMARK_(coll);
var state_69057__$1 = state_69057;
if(inst_69018){
var statearr_69069_69094 = state_69057__$1;
(statearr_69069_69094[(1)] = (6));

} else {
var statearr_69070_69095 = state_69057__$1;
(statearr_69070_69095[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69058 === (11))){
var inst_69025 = (state_69057[(9)]);
var state_69057__$1 = state_69057;
var statearr_69072_69096 = state_69057__$1;
(statearr_69072_69096[(2)] = inst_69025);

(statearr_69072_69096[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69058 === (9))){
var inst_69021 = (state_69057[(2)]);
var inst_69022 = fluree.db.util.async.throw_err(inst_69021);
var state_69057__$1 = state_69057;
var statearr_69073_69097 = state_69057__$1;
(statearr_69073_69097[(2)] = inst_69022);

(statearr_69073_69097[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69058 === (5))){
var _ = (function (){var statearr_69074 = state_69057;
(statearr_69074[(4)] = cljs.core.rest((state_69057[(4)])));

return statearr_69074;
})();
var state_69057__$1 = state_69057;
var ex69071 = (state_69057__$1[(2)]);
var statearr_69075_69098 = state_69057__$1;
(statearr_69075_69098[(5)] = ex69071);


if((ex69071 instanceof Error)){
var statearr_69076_69099 = state_69057__$1;
(statearr_69076_69099[(1)] = (4));

(statearr_69076_69099[(5)] = null);

} else {
throw ex69071;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69058 === (14))){
var state_69057__$1 = state_69057;
var statearr_69077_69100 = state_69057__$1;
(statearr_69077_69100[(2)] = key);

(statearr_69077_69100[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69058 === (16))){
var inst_69035 = (state_69057[(2)]);
var inst_69036 = fluree.db.util.async.throw_err(inst_69035);
var state_69057__$1 = state_69057;
var statearr_69078_69101 = state_69057__$1;
(statearr_69078_69101[(2)] = inst_69036);

(statearr_69078_69101[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69058 === (10))){
var inst_69025 = (state_69057[(9)]);
var inst_69028 = cljs.core.vec(inst_69025);
var state_69057__$1 = state_69057;
var statearr_69079_69102 = state_69057__$1;
(statearr_69079_69102[(2)] = inst_69028);

(statearr_69079_69102[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69058 === (8))){
var inst_69025 = (state_69057[(9)]);
var inst_69025__$1 = (state_69057[(2)]);
var inst_69026 = cljs.core.set_QMARK_(inst_69025__$1);
var state_69057__$1 = (function (){var statearr_69080 = state_69057;
(statearr_69080[(9)] = inst_69025__$1);

return statearr_69080;
})();
if(inst_69026){
var statearr_69081_69103 = state_69057__$1;
(statearr_69081_69103[(1)] = (10));

} else {
var statearr_69082_69104 = state_69057__$1;
(statearr_69082_69104[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto____0 = (function (){
var statearr_69083 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69083[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto__);

(statearr_69083[(1)] = (1));

return statearr_69083;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto____1 = (function (state_69057){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69057);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69084){var ex__16398__auto__ = e69084;
var statearr_69085_69105 = state_69057;
(statearr_69085_69105[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69057[(4)]))){
var statearr_69086_69106 = state_69057;
(statearr_69086_69106[(1)] = cljs.core.first((state_69057[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69107 = state_69057;
state_69057 = G__69107;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto__ = function(state_69057){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto____1.call(this,state_69057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69087 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69087[(6)] = c__16469__auto__);

return statearr_69087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69168){
var state_val_69169 = (state_69168[(1)]);
if((state_val_69169 === (7))){
var state_69168__$1 = state_69168;
var statearr_69170_69204 = state_69168__$1;
(statearr_69170_69204[(2)] = test);

(statearr_69170_69204[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (20))){
var inst_69142 = (state_69168[(2)]);
var inst_69143 = fluree.db.util.async.throw_err(inst_69142);
var state_69168__$1 = state_69168;
var statearr_69171_69205 = state_69168__$1;
(statearr_69171_69205[(2)] = inst_69143);

(statearr_69171_69205[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (1))){
var state_69168__$1 = state_69168;
var statearr_69172_69206 = state_69168__$1;
(statearr_69172_69206[(2)] = null);

(statearr_69172_69206[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (4))){
var inst_69108 = (state_69168[(2)]);
var state_69168__$1 = state_69168;
var statearr_69173_69207 = state_69168__$1;
(statearr_69173_69207[(2)] = inst_69108);

(statearr_69173_69207[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (15))){
var inst_69126 = (state_69168[(7)]);
var inst_69134 = (state_69168[(2)]);
var inst_69135 = [inst_69134,f];
var inst_69136 = (new cljs.core.PersistentVector(null,2,(5),inst_69126,inst_69135,null));
var state_69168__$1 = state_69168;
var statearr_69174_69208 = state_69168__$1;
(statearr_69174_69208[(2)] = inst_69136);

(statearr_69174_69208[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (13))){
var state_69168__$1 = state_69168;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69168__$1,(16),t);
} else {
if((state_val_69169 === (6))){
var state_69168__$1 = state_69168;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69168__$1,(9),test);
} else {
if((state_val_69169 === (17))){
var state_69168__$1 = state_69168;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69168__$1,(20),f);
} else {
if((state_val_69169 === (3))){
var inst_69166 = (state_69168[(2)]);
var state_69168__$1 = state_69168;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69168__$1,inst_69166);
} else {
if((state_val_69169 === (12))){
var inst_69124 = (state_69168[(8)]);
var inst_69150 = (state_69168[(2)]);
var inst_69151 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69150,(0),null);
var inst_69152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69150,(1),null);
var inst_69153 = fluree.db.dbfunctions.internal.if_else(inst_69124,inst_69151,inst_69152);
var inst_69154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69155 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69157 = [inst_69124,inst_69151,inst_69152];
var inst_69158 = (new cljs.core.PersistentVector(null,3,(5),inst_69156,inst_69157,null));
var inst_69159 = ["if-else",inst_69158,inst_69153];
var inst_69160 = cljs.core.PersistentHashMap.fromArrays(inst_69155,inst_69159);
var inst_69161 = [inst_69160,(10)];
var inst_69162 = (new cljs.core.PersistentVector(null,2,(5),inst_69154,inst_69161,null));
var inst_69163 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69162);
var _ = (function (){var statearr_69175 = state_69168;
(statearr_69175[(4)] = cljs.core.rest((state_69168[(4)])));

return statearr_69175;
})();
var state_69168__$1 = (function (){var statearr_69176 = state_69168;
(statearr_69176[(9)] = inst_69163);

return statearr_69176;
})();
var statearr_69177_69209 = state_69168__$1;
(statearr_69177_69209[(2)] = inst_69153);

(statearr_69177_69209[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (2))){
var _ = (function (){var statearr_69178 = state_69168;
(statearr_69178[(4)] = cljs.core.cons((5),(state_69168[(4)])));

return statearr_69178;
})();
var inst_69117 = fluree.db.util.async.channel_QMARK_(test);
var state_69168__$1 = state_69168;
if(inst_69117){
var statearr_69179_69210 = state_69168__$1;
(statearr_69179_69210[(1)] = (6));

} else {
var statearr_69180_69211 = state_69168__$1;
(statearr_69180_69211[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (19))){
var inst_69138 = (state_69168[(10)]);
var inst_69146 = (state_69168[(2)]);
var inst_69147 = [f,inst_69146];
var inst_69148 = (new cljs.core.PersistentVector(null,2,(5),inst_69138,inst_69147,null));
var state_69168__$1 = state_69168;
var statearr_69181_69212 = state_69168__$1;
(statearr_69181_69212[(2)] = inst_69148);

(statearr_69181_69212[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (11))){
var inst_69138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69139 = fluree.db.util.async.channel_QMARK_(f);
var state_69168__$1 = (function (){var statearr_69183 = state_69168;
(statearr_69183[(10)] = inst_69138);

return statearr_69183;
})();
if(inst_69139){
var statearr_69184_69213 = state_69168__$1;
(statearr_69184_69213[(1)] = (17));

} else {
var statearr_69185_69214 = state_69168__$1;
(statearr_69185_69214[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (9))){
var inst_69120 = (state_69168[(2)]);
var inst_69121 = fluree.db.util.async.throw_err(inst_69120);
var state_69168__$1 = state_69168;
var statearr_69186_69215 = state_69168__$1;
(statearr_69186_69215[(2)] = inst_69121);

(statearr_69186_69215[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (5))){
var _ = (function (){var statearr_69187 = state_69168;
(statearr_69187[(4)] = cljs.core.rest((state_69168[(4)])));

return statearr_69187;
})();
var state_69168__$1 = state_69168;
var ex69182 = (state_69168__$1[(2)]);
var statearr_69188_69216 = state_69168__$1;
(statearr_69188_69216[(5)] = ex69182);


if((ex69182 instanceof Error)){
var statearr_69189_69217 = state_69168__$1;
(statearr_69189_69217[(1)] = (4));

(statearr_69189_69217[(5)] = null);

} else {
throw ex69182;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (14))){
var state_69168__$1 = state_69168;
var statearr_69190_69218 = state_69168__$1;
(statearr_69190_69218[(2)] = t);

(statearr_69190_69218[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (16))){
var inst_69130 = (state_69168[(2)]);
var inst_69131 = fluree.db.util.async.throw_err(inst_69130);
var state_69168__$1 = state_69168;
var statearr_69191_69219 = state_69168__$1;
(statearr_69191_69219[(2)] = inst_69131);

(statearr_69191_69219[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (10))){
var inst_69126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69127 = fluree.db.util.async.channel_QMARK_(t);
var state_69168__$1 = (function (){var statearr_69192 = state_69168;
(statearr_69192[(7)] = inst_69126);

return statearr_69192;
})();
if(inst_69127){
var statearr_69193_69220 = state_69168__$1;
(statearr_69193_69220[(1)] = (13));

} else {
var statearr_69194_69221 = state_69168__$1;
(statearr_69194_69221[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (18))){
var state_69168__$1 = state_69168;
var statearr_69195_69222 = state_69168__$1;
(statearr_69195_69222[(2)] = f);

(statearr_69195_69222[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69169 === (8))){
var inst_69124 = (state_69168[(8)]);
var inst_69124__$1 = (state_69168[(2)]);
var state_69168__$1 = (function (){var statearr_69196 = state_69168;
(statearr_69196[(8)] = inst_69124__$1);

return statearr_69196;
})();
if(cljs.core.truth_(inst_69124__$1)){
var statearr_69197_69223 = state_69168__$1;
(statearr_69197_69223[(1)] = (10));

} else {
var statearr_69198_69224 = state_69168__$1;
(statearr_69198_69224[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto____0 = (function (){
var statearr_69199 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_69199[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto__);

(statearr_69199[(1)] = (1));

return statearr_69199;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto____1 = (function (state_69168){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69168);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69200){var ex__16398__auto__ = e69200;
var statearr_69201_69225 = state_69168;
(statearr_69201_69225[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69168[(4)]))){
var statearr_69202_69226 = state_69168;
(statearr_69202_69226[(1)] = cljs.core.first((state_69168[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69227 = state_69168;
state_69168 = G__69227;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto__ = function(state_69168){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto____1.call(this,state_69168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69203 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69203[(6)] = c__16469__auto__);

return statearr_69203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69257){
var state_val_69258 = (state_69257[(1)]);
if((state_val_69258 === (7))){
var state_69257__$1 = state_69257;
var statearr_69259_69278 = state_69257__$1;
(statearr_69259_69278[(2)] = arg);

(statearr_69259_69278[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69258 === (1))){
var state_69257__$1 = state_69257;
var statearr_69260_69279 = state_69257__$1;
(statearr_69260_69279[(2)] = null);

(statearr_69260_69279[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69258 === (4))){
var inst_69228 = (state_69257[(2)]);
var state_69257__$1 = state_69257;
var statearr_69261_69280 = state_69257__$1;
(statearr_69261_69280[(2)] = inst_69228);

(statearr_69261_69280[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69258 === (6))){
var state_69257__$1 = state_69257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69257__$1,(9),arg);
} else {
if((state_val_69258 === (3))){
var inst_69255 = (state_69257[(2)]);
var state_69257__$1 = state_69257;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69257__$1,inst_69255);
} else {
if((state_val_69258 === (2))){
var _ = (function (){var statearr_69263 = state_69257;
(statearr_69263[(4)] = cljs.core.cons((5),(state_69257[(4)])));

return statearr_69263;
})();
var inst_69234 = fluree.db.util.async.channel_QMARK_(arg);
var state_69257__$1 = state_69257;
if(inst_69234){
var statearr_69264_69281 = state_69257__$1;
(statearr_69264_69281[(1)] = (6));

} else {
var statearr_69265_69282 = state_69257__$1;
(statearr_69265_69282[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69258 === (9))){
var inst_69237 = (state_69257[(2)]);
var inst_69238 = fluree.db.util.async.throw_err(inst_69237);
var state_69257__$1 = state_69257;
var statearr_69266_69283 = state_69257__$1;
(statearr_69266_69283[(2)] = inst_69238);

(statearr_69266_69283[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69258 === (5))){
var _ = (function (){var statearr_69267 = state_69257;
(statearr_69267[(4)] = cljs.core.rest((state_69257[(4)])));

return statearr_69267;
})();
var state_69257__$1 = state_69257;
var ex69262 = (state_69257__$1[(2)]);
var statearr_69268_69284 = state_69257__$1;
(statearr_69268_69284[(5)] = ex69262);


if((ex69262 instanceof Error)){
var statearr_69269_69285 = state_69257__$1;
(statearr_69269_69285[(1)] = (4));

(statearr_69269_69285[(5)] = null);

} else {
throw ex69262;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69258 === (8))){
var inst_69241 = (state_69257[(2)]);
var inst_69242 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_69241);
var inst_69243 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69244 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69246 = [inst_69241];
var inst_69247 = (new cljs.core.PersistentVector(null,1,(5),inst_69245,inst_69246,null));
var inst_69248 = ["nil?",inst_69247,inst_69242];
var inst_69249 = cljs.core.PersistentHashMap.fromArrays(inst_69244,inst_69248);
var inst_69250 = [inst_69249,(10)];
var inst_69251 = (new cljs.core.PersistentVector(null,2,(5),inst_69243,inst_69250,null));
var inst_69252 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69251);
var _ = (function (){var statearr_69270 = state_69257;
(statearr_69270[(4)] = cljs.core.rest((state_69257[(4)])));

return statearr_69270;
})();
var state_69257__$1 = (function (){var statearr_69271 = state_69257;
(statearr_69271[(7)] = inst_69252);

return statearr_69271;
})();
var statearr_69272_69286 = state_69257__$1;
(statearr_69272_69286[(2)] = inst_69242);

(statearr_69272_69286[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_69273 = [null,null,null,null,null,null,null,null];
(statearr_69273[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto__);

(statearr_69273[(1)] = (1));

return statearr_69273;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto____1 = (function (state_69257){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69257);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69274){var ex__16398__auto__ = e69274;
var statearr_69275_69287 = state_69257;
(statearr_69275_69287[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69257[(4)]))){
var statearr_69276_69288 = state_69257;
(statearr_69276_69288[(1)] = cljs.core.first((state_69257[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69289 = state_69257;
state_69257 = G__69289;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto__ = function(state_69257){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto____1.call(this,state_69257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69277 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69277[(6)] = c__16469__auto__);

return statearr_69277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69319){
var state_val_69320 = (state_69319[(1)]);
if((state_val_69320 === (7))){
var state_69319__$1 = state_69319;
var statearr_69321_69340 = state_69319__$1;
(statearr_69321_69340[(2)] = arg);

(statearr_69321_69340[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69320 === (1))){
var state_69319__$1 = state_69319;
var statearr_69322_69341 = state_69319__$1;
(statearr_69322_69341[(2)] = null);

(statearr_69322_69341[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69320 === (4))){
var inst_69290 = (state_69319[(2)]);
var state_69319__$1 = state_69319;
var statearr_69323_69342 = state_69319__$1;
(statearr_69323_69342[(2)] = inst_69290);

(statearr_69323_69342[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69320 === (6))){
var state_69319__$1 = state_69319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69319__$1,(9),arg);
} else {
if((state_val_69320 === (3))){
var inst_69317 = (state_69319[(2)]);
var state_69319__$1 = state_69319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69319__$1,inst_69317);
} else {
if((state_val_69320 === (2))){
var _ = (function (){var statearr_69325 = state_69319;
(statearr_69325[(4)] = cljs.core.cons((5),(state_69319[(4)])));

return statearr_69325;
})();
var inst_69296 = fluree.db.util.async.channel_QMARK_(arg);
var state_69319__$1 = state_69319;
if(inst_69296){
var statearr_69326_69343 = state_69319__$1;
(statearr_69326_69343[(1)] = (6));

} else {
var statearr_69327_69344 = state_69319__$1;
(statearr_69327_69344[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69320 === (9))){
var inst_69299 = (state_69319[(2)]);
var inst_69300 = fluree.db.util.async.throw_err(inst_69299);
var state_69319__$1 = state_69319;
var statearr_69328_69345 = state_69319__$1;
(statearr_69328_69345[(2)] = inst_69300);

(statearr_69328_69345[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69320 === (5))){
var _ = (function (){var statearr_69329 = state_69319;
(statearr_69329[(4)] = cljs.core.rest((state_69319[(4)])));

return statearr_69329;
})();
var state_69319__$1 = state_69319;
var ex69324 = (state_69319__$1[(2)]);
var statearr_69330_69346 = state_69319__$1;
(statearr_69330_69346[(5)] = ex69324);


if((ex69324 instanceof Error)){
var statearr_69331_69347 = state_69319__$1;
(statearr_69331_69347[(1)] = (4));

(statearr_69331_69347[(5)] = null);

} else {
throw ex69324;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69320 === (8))){
var inst_69303 = (state_69319[(2)]);
var inst_69304 = fluree.db.dbfunctions.internal.not(inst_69303);
var inst_69305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69306 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69308 = [inst_69303];
var inst_69309 = (new cljs.core.PersistentVector(null,1,(5),inst_69307,inst_69308,null));
var inst_69310 = ["not?",inst_69309,inst_69304];
var inst_69311 = cljs.core.PersistentHashMap.fromArrays(inst_69306,inst_69310);
var inst_69312 = [inst_69311,(10)];
var inst_69313 = (new cljs.core.PersistentVector(null,2,(5),inst_69305,inst_69312,null));
var inst_69314 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69313);
var _ = (function (){var statearr_69332 = state_69319;
(statearr_69332[(4)] = cljs.core.rest((state_69319[(4)])));

return statearr_69332;
})();
var state_69319__$1 = (function (){var statearr_69333 = state_69319;
(statearr_69333[(7)] = inst_69314);

return statearr_69333;
})();
var statearr_69334_69348 = state_69319__$1;
(statearr_69334_69348[(2)] = inst_69304);

(statearr_69334_69348[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto____0 = (function (){
var statearr_69335 = [null,null,null,null,null,null,null,null];
(statearr_69335[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto__);

(statearr_69335[(1)] = (1));

return statearr_69335;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto____1 = (function (state_69319){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69319);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69336){var ex__16398__auto__ = e69336;
var statearr_69337_69349 = state_69319;
(statearr_69337_69349[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69319[(4)]))){
var statearr_69338_69350 = state_69319;
(statearr_69338_69350[(1)] = cljs.core.first((state_69319[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69351 = state_69319;
state_69319 = G__69351;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto__ = function(state_69319){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto____1.call(this,state_69319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69339 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69339[(6)] = c__16469__auto__);

return statearr_69339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69381){
var state_val_69382 = (state_69381[(1)]);
if((state_val_69382 === (7))){
var state_69381__$1 = state_69381;
var statearr_69383_69402 = state_69381__$1;
(statearr_69383_69402[(2)] = arg);

(statearr_69383_69402[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69382 === (1))){
var state_69381__$1 = state_69381;
var statearr_69384_69403 = state_69381__$1;
(statearr_69384_69403[(2)] = null);

(statearr_69384_69403[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69382 === (4))){
var inst_69352 = (state_69381[(2)]);
var state_69381__$1 = state_69381;
var statearr_69385_69404 = state_69381__$1;
(statearr_69385_69404[(2)] = inst_69352);

(statearr_69385_69404[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69382 === (6))){
var state_69381__$1 = state_69381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69381__$1,(9),arg);
} else {
if((state_val_69382 === (3))){
var inst_69379 = (state_69381[(2)]);
var state_69381__$1 = state_69381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69381__$1,inst_69379);
} else {
if((state_val_69382 === (2))){
var _ = (function (){var statearr_69387 = state_69381;
(statearr_69387[(4)] = cljs.core.cons((5),(state_69381[(4)])));

return statearr_69387;
})();
var inst_69358 = fluree.db.util.async.channel_QMARK_(arg);
var state_69381__$1 = state_69381;
if(inst_69358){
var statearr_69388_69405 = state_69381__$1;
(statearr_69388_69405[(1)] = (6));

} else {
var statearr_69389_69406 = state_69381__$1;
(statearr_69389_69406[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69382 === (9))){
var inst_69361 = (state_69381[(2)]);
var inst_69362 = fluree.db.util.async.throw_err(inst_69361);
var state_69381__$1 = state_69381;
var statearr_69390_69407 = state_69381__$1;
(statearr_69390_69407[(2)] = inst_69362);

(statearr_69390_69407[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69382 === (5))){
var _ = (function (){var statearr_69391 = state_69381;
(statearr_69391[(4)] = cljs.core.rest((state_69381[(4)])));

return statearr_69391;
})();
var state_69381__$1 = state_69381;
var ex69386 = (state_69381__$1[(2)]);
var statearr_69392_69408 = state_69381__$1;
(statearr_69392_69408[(5)] = ex69386);


if((ex69386 instanceof Error)){
var statearr_69393_69409 = state_69381__$1;
(statearr_69393_69409[(1)] = (4));

(statearr_69393_69409[(5)] = null);

} else {
throw ex69386;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69382 === (8))){
var inst_69365 = (state_69381[(2)]);
var inst_69366 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_69365);
var inst_69367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69368 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69370 = [inst_69365];
var inst_69371 = (new cljs.core.PersistentVector(null,1,(5),inst_69369,inst_69370,null));
var inst_69372 = ["empty?",inst_69371,inst_69366];
var inst_69373 = cljs.core.PersistentHashMap.fromArrays(inst_69368,inst_69372);
var inst_69374 = [inst_69373,(10)];
var inst_69375 = (new cljs.core.PersistentVector(null,2,(5),inst_69367,inst_69374,null));
var inst_69376 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69375);
var _ = (function (){var statearr_69394 = state_69381;
(statearr_69394[(4)] = cljs.core.rest((state_69381[(4)])));

return statearr_69394;
})();
var state_69381__$1 = (function (){var statearr_69395 = state_69381;
(statearr_69395[(7)] = inst_69376);

return statearr_69395;
})();
var statearr_69396_69410 = state_69381__$1;
(statearr_69396_69410[(2)] = inst_69366);

(statearr_69396_69410[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_69397 = [null,null,null,null,null,null,null,null];
(statearr_69397[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto__);

(statearr_69397[(1)] = (1));

return statearr_69397;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto____1 = (function (state_69381){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69381);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69398){var ex__16398__auto__ = e69398;
var statearr_69399_69411 = state_69381;
(statearr_69399_69411[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69381[(4)]))){
var statearr_69400_69412 = state_69381;
(statearr_69400_69412[(1)] = cljs.core.first((state_69381[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69413 = state_69381;
state_69381 = G__69413;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto__ = function(state_69381){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto____1.call(this,state_69381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69401 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69401[(6)] = c__16469__auto__);

return statearr_69401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___69458 = arguments.length;
var i__4819__auto___69459 = (0);
while(true){
if((i__4819__auto___69459 < len__4818__auto___69458)){
args__4824__auto__.push((arguments[i__4819__auto___69459]));

var G__69460 = (i__4819__auto___69459 + (1));
i__4819__auto___69459 = G__69460;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69441){
var state_val_69442 = (state_69441[(1)]);
if((state_val_69442 === (1))){
var state_69441__$1 = state_69441;
var statearr_69443_69461 = state_69441__$1;
(statearr_69443_69461[(2)] = null);

(statearr_69443_69461[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69442 === (2))){
var _ = (function (){var statearr_69444 = state_69441;
(statearr_69444[(4)] = cljs.core.cons((5),(state_69441[(4)])));

return statearr_69444;
})();
var inst_69422 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_69441__$1 = state_69441;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69441__$1,(6),inst_69422);
} else {
if((state_val_69442 === (3))){
var inst_69439 = (state_69441[(2)]);
var state_69441__$1 = state_69441;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69441__$1,inst_69439);
} else {
if((state_val_69442 === (4))){
var inst_69416 = (state_69441[(2)]);
var state_69441__$1 = state_69441;
var statearr_69446_69462 = state_69441__$1;
(statearr_69446_69462[(2)] = inst_69416);

(statearr_69446_69462[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69442 === (5))){
var _ = (function (){var statearr_69447 = state_69441;
(statearr_69447[(4)] = cljs.core.rest((state_69441[(4)])));

return statearr_69447;
})();
var state_69441__$1 = state_69441;
var ex69445 = (state_69441__$1[(2)]);
var statearr_69448_69463 = state_69441__$1;
(statearr_69448_69463[(5)] = ex69445);


if((ex69445 instanceof Error)){
var statearr_69449_69464 = state_69441__$1;
(statearr_69449_69464[(1)] = (4));

(statearr_69449_69464[(5)] = null);

} else {
throw ex69445;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69442 === (6))){
var inst_69424 = (state_69441[(2)]);
var inst_69425 = fluree.db.util.async.throw_err(inst_69424);
var inst_69426 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_69425);
var inst_69427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69428 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69430 = [inst_69425];
var inst_69431 = (new cljs.core.PersistentVector(null,1,(5),inst_69429,inst_69430,null));
var inst_69432 = ["str",inst_69431,inst_69426];
var inst_69433 = cljs.core.PersistentHashMap.fromArrays(inst_69428,inst_69432);
var inst_69434 = [inst_69433,(10)];
var inst_69435 = (new cljs.core.PersistentVector(null,2,(5),inst_69427,inst_69434,null));
var inst_69436 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69435);
var _ = (function (){var statearr_69450 = state_69441;
(statearr_69450[(4)] = cljs.core.rest((state_69441[(4)])));

return statearr_69450;
})();
var state_69441__$1 = (function (){var statearr_69451 = state_69441;
(statearr_69451[(7)] = inst_69436);

return statearr_69451;
})();
var statearr_69452_69465 = state_69441__$1;
(statearr_69452_69465[(2)] = inst_69426);

(statearr_69452_69465[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_69453 = [null,null,null,null,null,null,null,null];
(statearr_69453[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_69453[(1)] = (1));

return statearr_69453;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_69441){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69441);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69454){var ex__16398__auto__ = e69454;
var statearr_69455_69466 = state_69441;
(statearr_69455_69466[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69441[(4)]))){
var statearr_69456_69467 = state_69441;
(statearr_69456_69467[(1)] = cljs.core.first((state_69441[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69468 = state_69441;
state_69441 = G__69468;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_69441){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_69441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69457 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69457[(6)] = c__16469__auto__);

return statearr_69457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq69414){
var G__69415 = cljs.core.first(seq69414);
var seq69414__$1 = cljs.core.next(seq69414);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69415,seq69414__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69494){
var state_val_69495 = (state_69494[(1)]);
if((state_val_69495 === (1))){
var state_69494__$1 = state_69494;
var statearr_69496_69511 = state_69494__$1;
(statearr_69496_69511[(2)] = null);

(statearr_69496_69511[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69495 === (2))){
var _ = (function (){var statearr_69497 = state_69494;
(statearr_69497[(4)] = cljs.core.cons((5),(state_69494[(4)])));

return statearr_69497;
})();
var inst_69475 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_69494__$1 = state_69494;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69494__$1,(6),inst_69475);
} else {
if((state_val_69495 === (3))){
var inst_69492 = (state_69494[(2)]);
var state_69494__$1 = state_69494;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69494__$1,inst_69492);
} else {
if((state_val_69495 === (4))){
var inst_69469 = (state_69494[(2)]);
var state_69494__$1 = state_69494;
var statearr_69499_69512 = state_69494__$1;
(statearr_69499_69512[(2)] = inst_69469);

(statearr_69499_69512[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69495 === (5))){
var _ = (function (){var statearr_69500 = state_69494;
(statearr_69500[(4)] = cljs.core.rest((state_69494[(4)])));

return statearr_69500;
})();
var state_69494__$1 = state_69494;
var ex69498 = (state_69494__$1[(2)]);
var statearr_69501_69513 = state_69494__$1;
(statearr_69501_69513[(5)] = ex69498);


if((ex69498 instanceof Error)){
var statearr_69502_69514 = state_69494__$1;
(statearr_69502_69514[(1)] = (4));

(statearr_69502_69514[(5)] = null);

} else {
throw ex69498;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69495 === (6))){
var inst_69477 = (state_69494[(2)]);
var inst_69478 = fluree.db.util.async.throw_err(inst_69477);
var inst_69479 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_69478);
var inst_69480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69481 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69483 = [inst_69478];
var inst_69484 = (new cljs.core.PersistentVector(null,1,(5),inst_69482,inst_69483,null));
var inst_69485 = ["subs",inst_69484,inst_69479];
var inst_69486 = cljs.core.PersistentHashMap.fromArrays(inst_69481,inst_69485);
var inst_69487 = [inst_69486,(30)];
var inst_69488 = (new cljs.core.PersistentVector(null,2,(5),inst_69480,inst_69487,null));
var inst_69489 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69488);
var _ = (function (){var statearr_69503 = state_69494;
(statearr_69503[(4)] = cljs.core.rest((state_69494[(4)])));

return statearr_69503;
})();
var state_69494__$1 = (function (){var statearr_69504 = state_69494;
(statearr_69504[(7)] = inst_69489);

return statearr_69504;
})();
var statearr_69505_69515 = state_69494__$1;
(statearr_69505_69515[(2)] = inst_69479);

(statearr_69505_69515[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto____0 = (function (){
var statearr_69506 = [null,null,null,null,null,null,null,null];
(statearr_69506[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto__);

(statearr_69506[(1)] = (1));

return statearr_69506;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto____1 = (function (state_69494){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69494);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69507){var ex__16398__auto__ = e69507;
var statearr_69508_69516 = state_69494;
(statearr_69508_69516[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69494[(4)]))){
var statearr_69509_69517 = state_69494;
(statearr_69509_69517[(1)] = cljs.core.first((state_69494[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69518 = state_69494;
state_69494 = G__69518;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto__ = function(state_69494){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto____1.call(this,state_69494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69510 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69510[(6)] = c__16469__auto__);

return statearr_69510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69548){
var state_val_69549 = (state_69548[(1)]);
if((state_val_69549 === (7))){
var state_69548__$1 = state_69548;
var statearr_69550_69569 = state_69548__$1;
(statearr_69550_69569[(2)] = str);

(statearr_69550_69569[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69549 === (1))){
var state_69548__$1 = state_69548;
var statearr_69551_69570 = state_69548__$1;
(statearr_69551_69570[(2)] = null);

(statearr_69551_69570[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69549 === (4))){
var inst_69519 = (state_69548[(2)]);
var state_69548__$1 = state_69548;
var statearr_69552_69571 = state_69548__$1;
(statearr_69552_69571[(2)] = inst_69519);

(statearr_69552_69571[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69549 === (6))){
var state_69548__$1 = state_69548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69548__$1,(9),str);
} else {
if((state_val_69549 === (3))){
var inst_69546 = (state_69548[(2)]);
var state_69548__$1 = state_69548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69548__$1,inst_69546);
} else {
if((state_val_69549 === (2))){
var _ = (function (){var statearr_69554 = state_69548;
(statearr_69554[(4)] = cljs.core.cons((5),(state_69548[(4)])));

return statearr_69554;
})();
var inst_69525 = fluree.db.util.async.channel_QMARK_(str);
var state_69548__$1 = state_69548;
if(inst_69525){
var statearr_69555_69572 = state_69548__$1;
(statearr_69555_69572[(1)] = (6));

} else {
var statearr_69556_69573 = state_69548__$1;
(statearr_69556_69573[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69549 === (9))){
var inst_69528 = (state_69548[(2)]);
var inst_69529 = fluree.db.util.async.throw_err(inst_69528);
var state_69548__$1 = state_69548;
var statearr_69557_69574 = state_69548__$1;
(statearr_69557_69574[(2)] = inst_69529);

(statearr_69557_69574[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69549 === (5))){
var _ = (function (){var statearr_69558 = state_69548;
(statearr_69558[(4)] = cljs.core.rest((state_69548[(4)])));

return statearr_69558;
})();
var state_69548__$1 = state_69548;
var ex69553 = (state_69548__$1[(2)]);
var statearr_69559_69575 = state_69548__$1;
(statearr_69559_69575[(5)] = ex69553);


if((ex69553 instanceof Error)){
var statearr_69560_69576 = state_69548__$1;
(statearr_69560_69576[(1)] = (4));

(statearr_69560_69576[(5)] = null);

} else {
throw ex69553;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69549 === (8))){
var inst_69532 = (state_69548[(2)]);
var inst_69533 = fluree.db.dbfunctions.internal.lower_case(inst_69532);
var inst_69534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69535 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69537 = [inst_69532];
var inst_69538 = (new cljs.core.PersistentVector(null,1,(5),inst_69536,inst_69537,null));
var inst_69539 = ["lower-case",inst_69538,inst_69533];
var inst_69540 = cljs.core.PersistentHashMap.fromArrays(inst_69535,inst_69539);
var inst_69541 = [inst_69540,(10)];
var inst_69542 = (new cljs.core.PersistentVector(null,2,(5),inst_69534,inst_69541,null));
var inst_69543 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69542);
var _ = (function (){var statearr_69561 = state_69548;
(statearr_69561[(4)] = cljs.core.rest((state_69548[(4)])));

return statearr_69561;
})();
var state_69548__$1 = (function (){var statearr_69562 = state_69548;
(statearr_69562[(7)] = inst_69543);

return statearr_69562;
})();
var statearr_69563_69577 = state_69548__$1;
(statearr_69563_69577[(2)] = inst_69533);

(statearr_69563_69577[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto____0 = (function (){
var statearr_69564 = [null,null,null,null,null,null,null,null];
(statearr_69564[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto__);

(statearr_69564[(1)] = (1));

return statearr_69564;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto____1 = (function (state_69548){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69548);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69565){var ex__16398__auto__ = e69565;
var statearr_69566_69578 = state_69548;
(statearr_69566_69578[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69548[(4)]))){
var statearr_69567_69579 = state_69548;
(statearr_69567_69579[(1)] = cljs.core.first((state_69548[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69580 = state_69548;
state_69548 = G__69580;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto__ = function(state_69548){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto____1.call(this,state_69548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69568 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69568[(6)] = c__16469__auto__);

return statearr_69568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69610){
var state_val_69611 = (state_69610[(1)]);
if((state_val_69611 === (7))){
var state_69610__$1 = state_69610;
var statearr_69612_69631 = state_69610__$1;
(statearr_69612_69631[(2)] = str);

(statearr_69612_69631[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69611 === (1))){
var state_69610__$1 = state_69610;
var statearr_69613_69632 = state_69610__$1;
(statearr_69613_69632[(2)] = null);

(statearr_69613_69632[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69611 === (4))){
var inst_69581 = (state_69610[(2)]);
var state_69610__$1 = state_69610;
var statearr_69614_69633 = state_69610__$1;
(statearr_69614_69633[(2)] = inst_69581);

(statearr_69614_69633[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69611 === (6))){
var state_69610__$1 = state_69610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69610__$1,(9),str);
} else {
if((state_val_69611 === (3))){
var inst_69608 = (state_69610[(2)]);
var state_69610__$1 = state_69610;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69610__$1,inst_69608);
} else {
if((state_val_69611 === (2))){
var _ = (function (){var statearr_69616 = state_69610;
(statearr_69616[(4)] = cljs.core.cons((5),(state_69610[(4)])));

return statearr_69616;
})();
var inst_69587 = fluree.db.util.async.channel_QMARK_(str);
var state_69610__$1 = state_69610;
if(inst_69587){
var statearr_69617_69634 = state_69610__$1;
(statearr_69617_69634[(1)] = (6));

} else {
var statearr_69618_69635 = state_69610__$1;
(statearr_69618_69635[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69611 === (9))){
var inst_69590 = (state_69610[(2)]);
var inst_69591 = fluree.db.util.async.throw_err(inst_69590);
var state_69610__$1 = state_69610;
var statearr_69619_69636 = state_69610__$1;
(statearr_69619_69636[(2)] = inst_69591);

(statearr_69619_69636[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69611 === (5))){
var _ = (function (){var statearr_69620 = state_69610;
(statearr_69620[(4)] = cljs.core.rest((state_69610[(4)])));

return statearr_69620;
})();
var state_69610__$1 = state_69610;
var ex69615 = (state_69610__$1[(2)]);
var statearr_69621_69637 = state_69610__$1;
(statearr_69621_69637[(5)] = ex69615);


if((ex69615 instanceof Error)){
var statearr_69622_69638 = state_69610__$1;
(statearr_69622_69638[(1)] = (4));

(statearr_69622_69638[(5)] = null);

} else {
throw ex69615;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69611 === (8))){
var inst_69594 = (state_69610[(2)]);
var inst_69595 = fluree.db.dbfunctions.internal.upper_case(inst_69594);
var inst_69596 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69597 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69599 = [inst_69594];
var inst_69600 = (new cljs.core.PersistentVector(null,1,(5),inst_69598,inst_69599,null));
var inst_69601 = ["upper-case",inst_69600,inst_69595];
var inst_69602 = cljs.core.PersistentHashMap.fromArrays(inst_69597,inst_69601);
var inst_69603 = [inst_69602,(10)];
var inst_69604 = (new cljs.core.PersistentVector(null,2,(5),inst_69596,inst_69603,null));
var inst_69605 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69604);
var _ = (function (){var statearr_69623 = state_69610;
(statearr_69623[(4)] = cljs.core.rest((state_69610[(4)])));

return statearr_69623;
})();
var state_69610__$1 = (function (){var statearr_69624 = state_69610;
(statearr_69624[(7)] = inst_69605);

return statearr_69624;
})();
var statearr_69625_69639 = state_69610__$1;
(statearr_69625_69639[(2)] = inst_69595);

(statearr_69625_69639[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto____0 = (function (){
var statearr_69626 = [null,null,null,null,null,null,null,null];
(statearr_69626[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto__);

(statearr_69626[(1)] = (1));

return statearr_69626;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto____1 = (function (state_69610){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69610);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69627){var ex__16398__auto__ = e69627;
var statearr_69628_69640 = state_69610;
(statearr_69628_69640[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69610[(4)]))){
var statearr_69629_69641 = state_69610;
(statearr_69629_69641[(1)] = cljs.core.first((state_69610[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69642 = state_69610;
state_69610 = G__69642;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto__ = function(state_69610){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto____1.call(this,state_69610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69630 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69630[(6)] = c__16469__auto__);

return statearr_69630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4210__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4210__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__69644 = arguments.length;
switch (G__69644) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69672){
var state_val_69673 = (state_69672[(1)]);
if((state_val_69673 === (1))){
var state_69672__$1 = state_69672;
var statearr_69674_69690 = state_69672__$1;
(statearr_69674_69690[(2)] = null);

(statearr_69674_69690[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69673 === (2))){
var _ = (function (){var statearr_69675 = state_69672;
(statearr_69675[(4)] = cljs.core.cons((5),(state_69672[(4)])));

return statearr_69675;
})();
var inst_69654 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_69672__$1 = state_69672;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69672__$1,(6),inst_69654);
} else {
if((state_val_69673 === (3))){
var inst_69670 = (state_69672[(2)]);
var state_69672__$1 = state_69672;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69672__$1,inst_69670);
} else {
if((state_val_69673 === (4))){
var inst_69645 = (state_69672[(2)]);
var state_69672__$1 = state_69672;
var statearr_69677_69691 = state_69672__$1;
(statearr_69677_69691[(2)] = inst_69645);

(statearr_69677_69691[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69673 === (5))){
var _ = (function (){var statearr_69678 = state_69672;
(statearr_69678[(4)] = cljs.core.rest((state_69672[(4)])));

return statearr_69678;
})();
var state_69672__$1 = state_69672;
var ex69676 = (state_69672__$1[(2)]);
var statearr_69679_69692 = state_69672__$1;
(statearr_69679_69692[(5)] = ex69676);


if((ex69676 instanceof Error)){
var statearr_69680_69693 = state_69672__$1;
(statearr_69680_69693[(1)] = (4));

(statearr_69680_69693[(5)] = null);

} else {
throw ex69676;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69673 === (6))){
var inst_69656 = (state_69672[(2)]);
var inst_69657 = fluree.db.util.async.throw_err(inst_69656);
var inst_69658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69657,(0),null);
var inst_69659 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69657,(1),null);
var inst_69660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69661 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69662 = ["?s","?ctx",inst_69658];
var inst_69663 = cljs.core.PersistentHashMap.fromArrays(inst_69661,inst_69662);
var inst_69664 = ((10) + inst_69659);
var inst_69665 = [inst_69663,inst_69664];
var inst_69666 = (new cljs.core.PersistentVector(null,2,(5),inst_69660,inst_69665,null));
var inst_69667 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69666);
var _ = (function (){var statearr_69681 = state_69672;
(statearr_69681[(4)] = cljs.core.rest((state_69672[(4)])));

return statearr_69681;
})();
var state_69672__$1 = (function (){var statearr_69682 = state_69672;
(statearr_69682[(7)] = inst_69667);

return statearr_69682;
})();
var statearr_69683_69694 = state_69672__$1;
(statearr_69683_69694[(2)] = inst_69658);

(statearr_69683_69694[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_69684 = [null,null,null,null,null,null,null,null];
(statearr_69684[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_69684[(1)] = (1));

return statearr_69684;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_69672){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69672);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69685){var ex__16398__auto__ = e69685;
var statearr_69686_69695 = state_69672;
(statearr_69686_69695[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69672[(4)]))){
var statearr_69687_69696 = state_69672;
(statearr_69687_69696[(1)] = cljs.core.first((state_69672[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69697 = state_69672;
state_69672 = G__69697;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_69672){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_69672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69688 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69688[(6)] = c__16469__auto__);

return statearr_69688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__69699 = arguments.length;
switch (G__69699) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69737){
var state_val_69738 = (state_69737[(1)]);
if((state_val_69738 === (7))){
var inst_69730 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_69737__$1 = state_69737;
var statearr_69739_69759 = state_69737__$1;
(statearr_69739_69759[(2)] = inst_69730);

(statearr_69739_69759[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69738 === (1))){
var state_69737__$1 = state_69737;
var statearr_69740_69760 = state_69737__$1;
(statearr_69740_69760[(2)] = null);

(statearr_69740_69760[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69738 === (4))){
var inst_69700 = (state_69737[(2)]);
var state_69737__$1 = state_69737;
var statearr_69741_69761 = state_69737__$1;
(statearr_69741_69761[(2)] = inst_69700);

(statearr_69741_69761[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69738 === (6))){
var inst_69711 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_69737__$1 = state_69737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69737__$1,(10),inst_69711);
} else {
if((state_val_69738 === (3))){
var inst_69735 = (state_69737[(2)]);
var state_69737__$1 = state_69737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69737__$1,inst_69735);
} else {
if((state_val_69738 === (2))){
var _ = (function (){var statearr_69743 = state_69737;
(statearr_69743[(4)] = cljs.core.cons((5),(state_69737[(4)])));

return statearr_69743;
})();
var inst_69706 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_69737__$1 = state_69737;
if(cljs.core.truth_(inst_69706)){
var statearr_69744_69762 = state_69737__$1;
(statearr_69744_69762[(1)] = (6));

} else {
var statearr_69745_69763 = state_69737__$1;
(statearr_69745_69763[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69738 === (9))){
var inst_69717 = (state_69737[(2)]);
var inst_69718 = fluree.db.util.async.throw_err(inst_69717);
var inst_69719 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69718,(0),null);
var inst_69720 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69718,(1),null);
var inst_69721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69722 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69723 = ["?p","?ctx",inst_69719];
var inst_69724 = cljs.core.PersistentHashMap.fromArrays(inst_69722,inst_69723);
var inst_69725 = ((10) + inst_69720);
var inst_69726 = [inst_69724,inst_69725];
var inst_69727 = (new cljs.core.PersistentVector(null,2,(5),inst_69721,inst_69726,null));
var inst_69728 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69727);
var state_69737__$1 = (function (){var statearr_69746 = state_69737;
(statearr_69746[(7)] = inst_69728);

return statearr_69746;
})();
var statearr_69747_69764 = state_69737__$1;
(statearr_69747_69764[(2)] = inst_69719);

(statearr_69747_69764[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69738 === (5))){
var _ = (function (){var statearr_69748 = state_69737;
(statearr_69748[(4)] = cljs.core.rest((state_69737[(4)])));

return statearr_69748;
})();
var state_69737__$1 = state_69737;
var ex69742 = (state_69737__$1[(2)]);
var statearr_69749_69765 = state_69737__$1;
(statearr_69749_69765[(5)] = ex69742);


if((ex69742 instanceof Error)){
var statearr_69750_69766 = state_69737__$1;
(statearr_69750_69766[(1)] = (4));

(statearr_69750_69766[(5)] = null);

} else {
throw ex69742;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69738 === (10))){
var inst_69713 = (state_69737[(2)]);
var inst_69714 = fluree.db.util.async.throw_err(inst_69713);
var inst_69715 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_69714);
var state_69737__$1 = state_69737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69737__$1,(9),inst_69715);
} else {
if((state_val_69738 === (8))){
var inst_69732 = (state_69737[(2)]);
var _ = (function (){var statearr_69751 = state_69737;
(statearr_69751[(4)] = cljs.core.rest((state_69737[(4)])));

return statearr_69751;
})();
var state_69737__$1 = state_69737;
var statearr_69752_69767 = state_69737__$1;
(statearr_69752_69767[(2)] = inst_69732);

(statearr_69752_69767[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_69753 = [null,null,null,null,null,null,null,null];
(statearr_69753[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_69753[(1)] = (1));

return statearr_69753;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_69737){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69737);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69754){var ex__16398__auto__ = e69754;
var statearr_69755_69768 = state_69737;
(statearr_69755_69768[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69737[(4)]))){
var statearr_69756_69769 = state_69737;
(statearr_69756_69769[(1)] = cljs.core.first((state_69737[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69770 = state_69737;
state_69737 = G__69770;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_69737){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_69737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69757 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69757[(6)] = c__16469__auto__);

return statearr_69757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___69819 = arguments.length;
var i__4819__auto___69820 = (0);
while(true){
if((i__4819__auto___69820 < len__4818__auto___69819)){
args__4824__auto__.push((arguments[i__4819__auto___69820]));

var G__69821 = (i__4819__auto___69820 + (1));
i__4819__auto___69820 = G__69821;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69802){
var state_val_69803 = (state_69802[(1)]);
if((state_val_69803 === (1))){
var state_69802__$1 = state_69802;
var statearr_69804_69822 = state_69802__$1;
(statearr_69804_69822[(2)] = null);

(statearr_69804_69822[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69803 === (2))){
var _ = (function (){var statearr_69805 = state_69802;
(statearr_69805[(4)] = cljs.core.cons((5),(state_69802[(4)])));

return statearr_69805;
})();
var inst_69779 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_69802__$1 = state_69802;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69802__$1,(6),inst_69779);
} else {
if((state_val_69803 === (3))){
var inst_69800 = (state_69802[(2)]);
var state_69802__$1 = state_69802;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69802__$1,inst_69800);
} else {
if((state_val_69803 === (4))){
var inst_69773 = (state_69802[(2)]);
var state_69802__$1 = state_69802;
var statearr_69807_69823 = state_69802__$1;
(statearr_69807_69823[(2)] = inst_69773);

(statearr_69807_69823[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69803 === (5))){
var _ = (function (){var statearr_69808 = state_69802;
(statearr_69808[(4)] = cljs.core.rest((state_69802[(4)])));

return statearr_69808;
})();
var state_69802__$1 = state_69802;
var ex69806 = (state_69802__$1[(2)]);
var statearr_69809_69824 = state_69802__$1;
(statearr_69809_69824[(5)] = ex69806);


if((ex69806 instanceof Error)){
var statearr_69810_69825 = state_69802__$1;
(statearr_69810_69825[(1)] = (4));

(statearr_69810_69825[(5)] = null);

} else {
throw ex69806;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69803 === (6))){
var inst_69781 = (state_69802[(2)]);
var inst_69782 = fluree.db.util.async.throw_err(inst_69781);
var inst_69783 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_69782);
var inst_69784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69785 = [inst_69782];
var inst_69786 = (new cljs.core.PersistentVector(null,1,(5),inst_69784,inst_69785,null));
var inst_69787 = cljs.core.count(inst_69786);
var inst_69788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69789 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69791 = [inst_69782];
var inst_69792 = (new cljs.core.PersistentVector(null,1,(5),inst_69790,inst_69791,null));
var inst_69793 = ["and",inst_69792,inst_69783];
var inst_69794 = cljs.core.PersistentHashMap.fromArrays(inst_69789,inst_69793);
var inst_69795 = [inst_69794,inst_69787];
var inst_69796 = (new cljs.core.PersistentVector(null,2,(5),inst_69788,inst_69795,null));
var inst_69797 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69796);
var _ = (function (){var statearr_69811 = state_69802;
(statearr_69811[(4)] = cljs.core.rest((state_69802[(4)])));

return statearr_69811;
})();
var state_69802__$1 = (function (){var statearr_69812 = state_69802;
(statearr_69812[(7)] = inst_69797);

return statearr_69812;
})();
var statearr_69813_69826 = state_69802__$1;
(statearr_69813_69826[(2)] = inst_69783);

(statearr_69813_69826[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_69814 = [null,null,null,null,null,null,null,null];
(statearr_69814[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_69814[(1)] = (1));

return statearr_69814;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_69802){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69802);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69815){var ex__16398__auto__ = e69815;
var statearr_69816_69827 = state_69802;
(statearr_69816_69827[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69802[(4)]))){
var statearr_69817_69828 = state_69802;
(statearr_69817_69828[(1)] = cljs.core.first((state_69802[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69829 = state_69802;
state_69802 = G__69829;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_69802){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_69802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69818 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69818[(6)] = c__16469__auto__);

return statearr_69818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq69771){
var G__69772 = cljs.core.first(seq69771);
var seq69771__$1 = cljs.core.next(seq69771);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69772,seq69771__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___69878 = arguments.length;
var i__4819__auto___69879 = (0);
while(true){
if((i__4819__auto___69879 < len__4818__auto___69878)){
args__4824__auto__.push((arguments[i__4819__auto___69879]));

var G__69880 = (i__4819__auto___69879 + (1));
i__4819__auto___69879 = G__69880;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69861){
var state_val_69862 = (state_69861[(1)]);
if((state_val_69862 === (1))){
var state_69861__$1 = state_69861;
var statearr_69863_69881 = state_69861__$1;
(statearr_69863_69881[(2)] = null);

(statearr_69863_69881[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69862 === (2))){
var _ = (function (){var statearr_69864 = state_69861;
(statearr_69864[(4)] = cljs.core.cons((5),(state_69861[(4)])));

return statearr_69864;
})();
var inst_69838 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_69861__$1 = state_69861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69861__$1,(6),inst_69838);
} else {
if((state_val_69862 === (3))){
var inst_69859 = (state_69861[(2)]);
var state_69861__$1 = state_69861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69861__$1,inst_69859);
} else {
if((state_val_69862 === (4))){
var inst_69832 = (state_69861[(2)]);
var state_69861__$1 = state_69861;
var statearr_69866_69882 = state_69861__$1;
(statearr_69866_69882[(2)] = inst_69832);

(statearr_69866_69882[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69862 === (5))){
var _ = (function (){var statearr_69867 = state_69861;
(statearr_69867[(4)] = cljs.core.rest((state_69861[(4)])));

return statearr_69867;
})();
var state_69861__$1 = state_69861;
var ex69865 = (state_69861__$1[(2)]);
var statearr_69868_69883 = state_69861__$1;
(statearr_69868_69883[(5)] = ex69865);


if((ex69865 instanceof Error)){
var statearr_69869_69884 = state_69861__$1;
(statearr_69869_69884[(1)] = (4));

(statearr_69869_69884[(5)] = null);

} else {
throw ex69865;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69862 === (6))){
var inst_69840 = (state_69861[(2)]);
var inst_69841 = fluree.db.util.async.throw_err(inst_69840);
var inst_69842 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_69841);
var inst_69843 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69844 = [inst_69841];
var inst_69845 = (new cljs.core.PersistentVector(null,1,(5),inst_69843,inst_69844,null));
var inst_69846 = cljs.core.count(inst_69845);
var inst_69847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69848 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69850 = [inst_69841];
var inst_69851 = (new cljs.core.PersistentVector(null,1,(5),inst_69849,inst_69850,null));
var inst_69852 = ["or",inst_69851,inst_69842];
var inst_69853 = cljs.core.PersistentHashMap.fromArrays(inst_69848,inst_69852);
var inst_69854 = [inst_69853,inst_69846];
var inst_69855 = (new cljs.core.PersistentVector(null,2,(5),inst_69847,inst_69854,null));
var inst_69856 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69855);
var _ = (function (){var statearr_69870 = state_69861;
(statearr_69870[(4)] = cljs.core.rest((state_69861[(4)])));

return statearr_69870;
})();
var state_69861__$1 = (function (){var statearr_69871 = state_69861;
(statearr_69871[(7)] = inst_69856);

return statearr_69871;
})();
var statearr_69872_69885 = state_69861__$1;
(statearr_69872_69885[(2)] = inst_69842);

(statearr_69872_69885[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_69873 = [null,null,null,null,null,null,null,null];
(statearr_69873[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_69873[(1)] = (1));

return statearr_69873;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_69861){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69861);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69874){var ex__16398__auto__ = e69874;
var statearr_69875_69886 = state_69861;
(statearr_69875_69886[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69861[(4)]))){
var statearr_69876_69887 = state_69861;
(statearr_69876_69887[(1)] = cljs.core.first((state_69861[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69888 = state_69861;
state_69861 = G__69888;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_69861){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_69861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69877 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69877[(6)] = c__16469__auto__);

return statearr_69877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq69830){
var G__69831 = cljs.core.first(seq69830);
var seq69830__$1 = cljs.core.next(seq69830);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69831,seq69830__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69926){
var state_val_69927 = (state_69926[(1)]);
if((state_val_69927 === (7))){
var inst_69902 = fluree.db.util.async.channel_QMARK_(coll);
var state_69926__$1 = state_69926;
if(inst_69902){
var statearr_69928_69951 = state_69926__$1;
(statearr_69928_69951[(1)] = (10));

} else {
var statearr_69929_69952 = state_69926__$1;
(statearr_69929_69952[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69927 === (1))){
var state_69926__$1 = state_69926;
var statearr_69930_69953 = state_69926__$1;
(statearr_69930_69953[(2)] = null);

(statearr_69930_69953[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69927 === (4))){
var inst_69889 = (state_69926[(2)]);
var state_69926__$1 = state_69926;
var statearr_69931_69954 = state_69926__$1;
(statearr_69931_69954[(2)] = inst_69889);

(statearr_69931_69954[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69927 === (13))){
var inst_69905 = (state_69926[(2)]);
var inst_69906 = fluree.db.util.async.throw_err(inst_69905);
var state_69926__$1 = state_69926;
var statearr_69932_69955 = state_69926__$1;
(statearr_69932_69955[(2)] = inst_69906);

(statearr_69932_69955[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69927 === (6))){
var inst_69897 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_69926__$1 = state_69926;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69926__$1,(9),inst_69897);
} else {
if((state_val_69927 === (3))){
var inst_69924 = (state_69926[(2)]);
var state_69926__$1 = state_69926;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69926__$1,inst_69924);
} else {
if((state_val_69927 === (12))){
var inst_69909 = (state_69926[(2)]);
var state_69926__$1 = state_69926;
var statearr_69933_69956 = state_69926__$1;
(statearr_69933_69956[(2)] = inst_69909);

(statearr_69933_69956[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69927 === (2))){
var _ = (function (){var statearr_69934 = state_69926;
(statearr_69934[(4)] = cljs.core.cons((5),(state_69926[(4)])));

return statearr_69934;
})();
var inst_69895 = cljs.core.vector_QMARK_(coll);
var state_69926__$1 = state_69926;
if(inst_69895){
var statearr_69935_69957 = state_69926__$1;
(statearr_69935_69957[(1)] = (6));

} else {
var statearr_69936_69958 = state_69926__$1;
(statearr_69936_69958[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69927 === (11))){
var state_69926__$1 = state_69926;
var statearr_69938_69959 = state_69926__$1;
(statearr_69938_69959[(2)] = coll);

(statearr_69938_69959[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69927 === (9))){
var inst_69899 = (state_69926[(2)]);
var inst_69900 = fluree.db.util.async.throw_err(inst_69899);
var state_69926__$1 = state_69926;
var statearr_69939_69960 = state_69926__$1;
(statearr_69939_69960[(2)] = inst_69900);

(statearr_69939_69960[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69927 === (5))){
var _ = (function (){var statearr_69940 = state_69926;
(statearr_69940[(4)] = cljs.core.rest((state_69926[(4)])));

return statearr_69940;
})();
var state_69926__$1 = state_69926;
var ex69937 = (state_69926__$1[(2)]);
var statearr_69941_69961 = state_69926__$1;
(statearr_69941_69961[(5)] = ex69937);


if((ex69937 instanceof Error)){
var statearr_69942_69962 = state_69926__$1;
(statearr_69942_69962[(1)] = (4));

(statearr_69942_69962[(5)] = null);

} else {
throw ex69937;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69927 === (10))){
var state_69926__$1 = state_69926;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69926__$1,(13),coll);
} else {
if((state_val_69927 === (8))){
var inst_69911 = (state_69926[(2)]);
var inst_69912 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_69911);
var inst_69913 = cljs.core.count(inst_69912);
var inst_69914 = ((9) + inst_69913);
var inst_69915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69916 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69917 = ["count",inst_69911,inst_69913];
var inst_69918 = cljs.core.PersistentHashMap.fromArrays(inst_69916,inst_69917);
var inst_69919 = [inst_69918,inst_69914];
var inst_69920 = (new cljs.core.PersistentVector(null,2,(5),inst_69915,inst_69919,null));
var inst_69921 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69920);
var _ = (function (){var statearr_69943 = state_69926;
(statearr_69943[(4)] = cljs.core.rest((state_69926[(4)])));

return statearr_69943;
})();
var state_69926__$1 = (function (){var statearr_69944 = state_69926;
(statearr_69944[(7)] = inst_69921);

return statearr_69944;
})();
var statearr_69945_69963 = state_69926__$1;
(statearr_69945_69963[(2)] = inst_69913);

(statearr_69945_69963[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto____0 = (function (){
var statearr_69946 = [null,null,null,null,null,null,null,null];
(statearr_69946[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto__);

(statearr_69946[(1)] = (1));

return statearr_69946;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto____1 = (function (state_69926){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69926);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69947){var ex__16398__auto__ = e69947;
var statearr_69948_69964 = state_69926;
(statearr_69948_69964[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69926[(4)]))){
var statearr_69949_69965 = state_69926;
(statearr_69949_69965[(1)] = cljs.core.first((state_69926[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69966 = state_69926;
state_69926 = G__69966;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto__ = function(state_69926){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto____1.call(this,state_69926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69950 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69950[(6)] = c__16469__auto__);

return statearr_69950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70016){
var state_val_70017 = (state_70016[(1)]);
if((state_val_70017 === (7))){
var state_70016__$1 = state_70016;
var statearr_70018_70051 = state_70016__$1;
(statearr_70018_70051[(2)] = subject);

(statearr_70018_70051[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (1))){
var state_70016__$1 = state_70016;
var statearr_70019_70052 = state_70016__$1;
(statearr_70019_70052[(2)] = null);

(statearr_70019_70052[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (4))){
var inst_69967 = (state_70016[(2)]);
var state_70016__$1 = state_70016;
var statearr_70020_70053 = state_70016__$1;
(statearr_70020_70053[(2)] = inst_69967);

(statearr_70020_70053[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (15))){
var inst_69980 = (state_70016[(7)]);
var state_70016__$1 = state_70016;
var statearr_70021_70054 = state_70016__$1;
(statearr_70021_70054[(2)] = inst_69980);

(statearr_70021_70054[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (13))){
var inst_69984 = (state_70016[(2)]);
var inst_69985 = fluree.db.util.async.throw_err(inst_69984);
var state_70016__$1 = state_70016;
var statearr_70022_70055 = state_70016__$1;
(statearr_70022_70055[(2)] = inst_69985);

(statearr_70022_70055[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (6))){
var state_70016__$1 = state_70016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70016__$1,(9),subject);
} else {
if((state_val_70017 === (17))){
var inst_69980 = (state_70016[(7)]);
var inst_69994 = cljs.core.first(inst_69980);
var state_70016__$1 = state_70016;
var statearr_70023_70056 = state_70016__$1;
(statearr_70023_70056[(2)] = inst_69994);

(statearr_70023_70056[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (3))){
var inst_70014 = (state_70016[(2)]);
var state_70016__$1 = state_70016;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70016__$1,inst_70014);
} else {
if((state_val_70017 === (12))){
var inst_69980 = (state_70016[(7)]);
var inst_69988 = (state_70016[(2)]);
var inst_69989 = cljs.core.vector_QMARK_(inst_69980);
var state_70016__$1 = (function (){var statearr_70024 = state_70016;
(statearr_70024[(8)] = inst_69988);

return statearr_70024;
})();
if(inst_69989){
var statearr_70025_70057 = state_70016__$1;
(statearr_70025_70057[(1)] = (14));

} else {
var statearr_70026_70058 = state_70016__$1;
(statearr_70026_70058[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (2))){
var _ = (function (){var statearr_70027 = state_70016;
(statearr_70027[(4)] = cljs.core.cons((5),(state_70016[(4)])));

return statearr_70027;
})();
var inst_69973 = fluree.db.util.async.channel_QMARK_(subject);
var state_70016__$1 = state_70016;
if(inst_69973){
var statearr_70028_70059 = state_70016__$1;
(statearr_70028_70059[(1)] = (6));

} else {
var statearr_70029_70060 = state_70016__$1;
(statearr_70029_70060[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (19))){
var inst_69997 = (state_70016[(2)]);
var state_70016__$1 = state_70016;
var statearr_70030_70061 = state_70016__$1;
(statearr_70030_70061[(2)] = inst_69997);

(statearr_70030_70061[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (11))){
var state_70016__$1 = state_70016;
var statearr_70032_70062 = state_70016__$1;
(statearr_70032_70062[(2)] = pred);

(statearr_70032_70062[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (9))){
var inst_69976 = (state_70016[(2)]);
var inst_69977 = fluree.db.util.async.throw_err(inst_69976);
var state_70016__$1 = state_70016;
var statearr_70033_70063 = state_70016__$1;
(statearr_70033_70063[(2)] = inst_69977);

(statearr_70033_70063[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (5))){
var _ = (function (){var statearr_70034 = state_70016;
(statearr_70034[(4)] = cljs.core.rest((state_70016[(4)])));

return statearr_70034;
})();
var state_70016__$1 = state_70016;
var ex70031 = (state_70016__$1[(2)]);
var statearr_70035_70064 = state_70016__$1;
(statearr_70035_70064[(5)] = ex70031);


if((ex70031 instanceof Error)){
var statearr_70036_70065 = state_70016__$1;
(statearr_70036_70065[(1)] = (4));

(statearr_70036_70065[(5)] = null);

} else {
throw ex70031;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (14))){
var inst_69980 = (state_70016[(7)]);
var inst_69991 = cljs.core.count(inst_69980);
var inst_69992 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_69991);
var state_70016__$1 = state_70016;
if(inst_69992){
var statearr_70037_70066 = state_70016__$1;
(statearr_70037_70066[(1)] = (17));

} else {
var statearr_70038_70067 = state_70016__$1;
(statearr_70038_70067[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (16))){
var inst_69988 = (state_70016[(8)]);
var inst_69980 = (state_70016[(7)]);
var inst_70000 = (state_70016[(2)]);
var inst_70001 = fluree.db.dbfunctions.internal.get(inst_70000,inst_69988);
var inst_70002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70003 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70005 = [inst_69980,inst_69988];
var inst_70006 = (new cljs.core.PersistentVector(null,2,(5),inst_70004,inst_70005,null));
var inst_70007 = ["get",inst_70006,inst_70001];
var inst_70008 = cljs.core.PersistentHashMap.fromArrays(inst_70003,inst_70007);
var inst_70009 = [inst_70008,(10)];
var inst_70010 = (new cljs.core.PersistentVector(null,2,(5),inst_70002,inst_70009,null));
var inst_70011 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70010);
var _ = (function (){var statearr_70039 = state_70016;
(statearr_70039[(4)] = cljs.core.rest((state_70016[(4)])));

return statearr_70039;
})();
var state_70016__$1 = (function (){var statearr_70040 = state_70016;
(statearr_70040[(9)] = inst_70011);

return statearr_70040;
})();
var statearr_70041_70068 = state_70016__$1;
(statearr_70041_70068[(2)] = inst_70001);

(statearr_70041_70068[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (10))){
var state_70016__$1 = state_70016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70016__$1,(13),pred);
} else {
if((state_val_70017 === (18))){
var inst_69980 = (state_70016[(7)]);
var state_70016__$1 = state_70016;
var statearr_70042_70069 = state_70016__$1;
(statearr_70042_70069[(2)] = inst_69980);

(statearr_70042_70069[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70017 === (8))){
var inst_69980 = (state_70016[(2)]);
var inst_69981 = fluree.db.util.async.channel_QMARK_(pred);
var state_70016__$1 = (function (){var statearr_70043 = state_70016;
(statearr_70043[(7)] = inst_69980);

return statearr_70043;
})();
if(inst_69981){
var statearr_70044_70070 = state_70016__$1;
(statearr_70044_70070[(1)] = (10));

} else {
var statearr_70045_70071 = state_70016__$1;
(statearr_70045_70071[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto____0 = (function (){
var statearr_70046 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70046[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto__);

(statearr_70046[(1)] = (1));

return statearr_70046;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto____1 = (function (state_70016){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70016);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70047){var ex__16398__auto__ = e70047;
var statearr_70048_70072 = state_70016;
(statearr_70048_70072[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70016[(4)]))){
var statearr_70049_70073 = state_70016;
(statearr_70049_70073[(1)] = cljs.core.first((state_70016[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70074 = state_70016;
state_70016 = G__70074;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto__ = function(state_70016){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto____1.call(this,state_70016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70050 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70050[(6)] = c__16469__auto__);

return statearr_70050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70113){
var state_val_70114 = (state_70113[(1)]);
if((state_val_70114 === (7))){
var inst_70081 = (state_70113[(7)]);
var state_70113__$1 = state_70113;
var statearr_70115_70139 = state_70113__$1;
(statearr_70115_70139[(2)] = inst_70081);

(statearr_70115_70139[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70114 === (1))){
var state_70113__$1 = state_70113;
var statearr_70116_70140 = state_70113__$1;
(statearr_70116_70140[(2)] = null);

(statearr_70116_70140[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70114 === (4))){
var inst_70075 = (state_70113[(2)]);
var state_70113__$1 = state_70113;
var statearr_70117_70141 = state_70113__$1;
(statearr_70117_70141[(2)] = inst_70075);

(statearr_70117_70141[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70114 === (6))){
var inst_70083 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_70113__$1 = state_70113;
var statearr_70118_70142 = state_70113__$1;
(statearr_70118_70142[(2)] = inst_70083);

(statearr_70118_70142[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70114 === (3))){
var inst_70111 = (state_70113[(2)]);
var state_70113__$1 = state_70113;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70113__$1,inst_70111);
} else {
if((state_val_70114 === (12))){
var inst_70093 = (state_70113[(2)]);
var inst_70094 = fluree.db.util.async.throw_err(inst_70093);
var inst_70095 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70094,(0),null);
var inst_70096 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70094,(1),null);
var inst_70097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70098 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70099 = ["?pO","?ctx",inst_70095];
var inst_70100 = cljs.core.PersistentHashMap.fromArrays(inst_70098,inst_70099);
var inst_70101 = ((10) + inst_70096);
var inst_70102 = [inst_70100,inst_70101];
var inst_70103 = (new cljs.core.PersistentVector(null,2,(5),inst_70097,inst_70102,null));
var inst_70104 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70103);
var state_70113__$1 = (function (){var statearr_70119 = state_70113;
(statearr_70119[(8)] = inst_70104);

return statearr_70119;
})();
var statearr_70120_70143 = state_70113__$1;
(statearr_70120_70143[(2)] = inst_70095);

(statearr_70120_70143[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70114 === (2))){
var inst_70081 = (state_70113[(7)]);
var _ = (function (){var statearr_70121 = state_70113;
(statearr_70121[(4)] = cljs.core.cons((5),(state_70113[(4)])));

return statearr_70121;
})();
var inst_70081__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_70113__$1 = (function (){var statearr_70122 = state_70113;
(statearr_70122[(7)] = inst_70081__$1);

return statearr_70122;
})();
if(cljs.core.truth_(inst_70081__$1)){
var statearr_70123_70144 = state_70113__$1;
(statearr_70123_70144[(1)] = (6));

} else {
var statearr_70124_70145 = state_70113__$1;
(statearr_70124_70145[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70114 === (11))){
var inst_70108 = (state_70113[(2)]);
var _ = (function (){var statearr_70126 = state_70113;
(statearr_70126[(4)] = cljs.core.rest((state_70113[(4)])));

return statearr_70126;
})();
var state_70113__$1 = state_70113;
var statearr_70127_70146 = state_70113__$1;
(statearr_70127_70146[(2)] = inst_70108);

(statearr_70127_70146[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70114 === (9))){
var inst_70091 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_70113__$1 = state_70113;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70113__$1,(12),inst_70091);
} else {
if((state_val_70114 === (5))){
var _ = (function (){var statearr_70128 = state_70113;
(statearr_70128[(4)] = cljs.core.rest((state_70113[(4)])));

return statearr_70128;
})();
var state_70113__$1 = state_70113;
var ex70125 = (state_70113__$1[(2)]);
var statearr_70129_70147 = state_70113__$1;
(statearr_70129_70147[(5)] = ex70125);


if((ex70125 instanceof Error)){
var statearr_70130_70148 = state_70113__$1;
(statearr_70130_70148[(1)] = (4));

(statearr_70130_70148[(5)] = null);

} else {
throw ex70125;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70114 === (10))){
var inst_70106 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_70113__$1 = state_70113;
var statearr_70131_70149 = state_70113__$1;
(statearr_70131_70149[(2)] = inst_70106);

(statearr_70131_70149[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70114 === (8))){
var inst_70086 = (state_70113[(2)]);
var state_70113__$1 = state_70113;
if(cljs.core.truth_(inst_70086)){
var statearr_70132_70150 = state_70113__$1;
(statearr_70132_70150[(1)] = (9));

} else {
var statearr_70133_70151 = state_70113__$1;
(statearr_70133_70151[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto____0 = (function (){
var statearr_70134 = [null,null,null,null,null,null,null,null,null];
(statearr_70134[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto__);

(statearr_70134[(1)] = (1));

return statearr_70134;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto____1 = (function (state_70113){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70113);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70135){var ex__16398__auto__ = e70135;
var statearr_70136_70152 = state_70113;
(statearr_70136_70152[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70113[(4)]))){
var statearr_70137_70153 = state_70113;
(statearr_70137_70153[(1)] = cljs.core.first((state_70113[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70154 = state_70113;
state_70113 = G__70154;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto__ = function(state_70113){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto____1.call(this,state_70113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70138 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70138[(6)] = c__16469__auto__);

return statearr_70138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70206){
var state_val_70207 = (state_70206[(1)]);
if((state_val_70207 === (7))){
var state_70206__$1 = state_70206;
var statearr_70208_70241 = state_70206__$1;
(statearr_70208_70241[(2)] = subject);

(statearr_70208_70241[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (1))){
var state_70206__$1 = state_70206;
var statearr_70209_70242 = state_70206__$1;
(statearr_70209_70242[(2)] = null);

(statearr_70209_70242[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (4))){
var inst_70155 = (state_70206[(2)]);
var state_70206__$1 = state_70206;
var statearr_70210_70243 = state_70206__$1;
(statearr_70210_70243[(2)] = inst_70155);

(statearr_70210_70243[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (15))){
var inst_70168 = (state_70206[(7)]);
var state_70206__$1 = state_70206;
var statearr_70211_70244 = state_70206__$1;
(statearr_70211_70244[(2)] = inst_70168);

(statearr_70211_70244[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (13))){
var inst_70172 = (state_70206[(2)]);
var inst_70173 = fluree.db.util.async.throw_err(inst_70172);
var state_70206__$1 = state_70206;
var statearr_70212_70245 = state_70206__$1;
(statearr_70212_70245[(2)] = inst_70173);

(statearr_70212_70245[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (6))){
var state_70206__$1 = state_70206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70206__$1,(9),subject);
} else {
if((state_val_70207 === (17))){
var inst_70168 = (state_70206[(7)]);
var inst_70182 = cljs.core.first(inst_70168);
var state_70206__$1 = state_70206;
var statearr_70213_70246 = state_70206__$1;
(statearr_70213_70246[(2)] = inst_70182);

(statearr_70213_70246[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (3))){
var inst_70204 = (state_70206[(2)]);
var state_70206__$1 = state_70206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70206__$1,inst_70204);
} else {
if((state_val_70207 === (12))){
var inst_70168 = (state_70206[(7)]);
var inst_70176 = (state_70206[(2)]);
var inst_70177 = cljs.core.vector_QMARK_(inst_70168);
var state_70206__$1 = (function (){var statearr_70214 = state_70206;
(statearr_70214[(8)] = inst_70176);

return statearr_70214;
})();
if(inst_70177){
var statearr_70215_70247 = state_70206__$1;
(statearr_70215_70247[(1)] = (14));

} else {
var statearr_70216_70248 = state_70206__$1;
(statearr_70216_70248[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (2))){
var _ = (function (){var statearr_70217 = state_70206;
(statearr_70217[(4)] = cljs.core.cons((5),(state_70206[(4)])));

return statearr_70217;
})();
var inst_70161 = fluree.db.util.async.channel_QMARK_(subject);
var state_70206__$1 = state_70206;
if(inst_70161){
var statearr_70218_70249 = state_70206__$1;
(statearr_70218_70249[(1)] = (6));

} else {
var statearr_70219_70250 = state_70206__$1;
(statearr_70219_70250[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (19))){
var inst_70185 = (state_70206[(2)]);
var state_70206__$1 = state_70206;
var statearr_70220_70251 = state_70206__$1;
(statearr_70220_70251[(2)] = inst_70185);

(statearr_70220_70251[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (11))){
var state_70206__$1 = state_70206;
var statearr_70222_70252 = state_70206__$1;
(statearr_70222_70252[(2)] = path);

(statearr_70222_70252[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (9))){
var inst_70164 = (state_70206[(2)]);
var inst_70165 = fluree.db.util.async.throw_err(inst_70164);
var state_70206__$1 = state_70206;
var statearr_70223_70253 = state_70206__$1;
(statearr_70223_70253[(2)] = inst_70165);

(statearr_70223_70253[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (5))){
var _ = (function (){var statearr_70224 = state_70206;
(statearr_70224[(4)] = cljs.core.rest((state_70206[(4)])));

return statearr_70224;
})();
var state_70206__$1 = state_70206;
var ex70221 = (state_70206__$1[(2)]);
var statearr_70225_70254 = state_70206__$1;
(statearr_70225_70254[(5)] = ex70221);


if((ex70221 instanceof Error)){
var statearr_70226_70255 = state_70206__$1;
(statearr_70226_70255[(1)] = (4));

(statearr_70226_70255[(5)] = null);

} else {
throw ex70221;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (14))){
var inst_70168 = (state_70206[(7)]);
var inst_70179 = cljs.core.count(inst_70168);
var inst_70180 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_70179);
var state_70206__$1 = state_70206;
if(inst_70180){
var statearr_70227_70256 = state_70206__$1;
(statearr_70227_70256[(1)] = (17));

} else {
var statearr_70228_70257 = state_70206__$1;
(statearr_70228_70257[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (16))){
var inst_70168 = (state_70206[(7)]);
var inst_70176 = (state_70206[(8)]);
var inst_70188 = (state_70206[(2)]);
var inst_70189 = fluree.db.dbfunctions.internal.get_all(inst_70188,inst_70176);
var inst_70190 = cljs.core.count(inst_70176);
var inst_70191 = ((9) + inst_70190);
var inst_70192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70193 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70195 = [inst_70168,inst_70176];
var inst_70196 = (new cljs.core.PersistentVector(null,2,(5),inst_70194,inst_70195,null));
var inst_70197 = ["get-all",inst_70196,inst_70189];
var inst_70198 = cljs.core.PersistentHashMap.fromArrays(inst_70193,inst_70197);
var inst_70199 = [inst_70198,inst_70191];
var inst_70200 = (new cljs.core.PersistentVector(null,2,(5),inst_70192,inst_70199,null));
var inst_70201 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70200);
var _ = (function (){var statearr_70229 = state_70206;
(statearr_70229[(4)] = cljs.core.rest((state_70206[(4)])));

return statearr_70229;
})();
var state_70206__$1 = (function (){var statearr_70230 = state_70206;
(statearr_70230[(9)] = inst_70201);

return statearr_70230;
})();
var statearr_70231_70258 = state_70206__$1;
(statearr_70231_70258[(2)] = inst_70189);

(statearr_70231_70258[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (10))){
var state_70206__$1 = state_70206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70206__$1,(13),path);
} else {
if((state_val_70207 === (18))){
var inst_70168 = (state_70206[(7)]);
var state_70206__$1 = state_70206;
var statearr_70232_70259 = state_70206__$1;
(statearr_70232_70259[(2)] = inst_70168);

(statearr_70232_70259[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70207 === (8))){
var inst_70168 = (state_70206[(2)]);
var inst_70169 = fluree.db.util.async.channel_QMARK_(path);
var state_70206__$1 = (function (){var statearr_70233 = state_70206;
(statearr_70233[(7)] = inst_70168);

return statearr_70233;
})();
if(inst_70169){
var statearr_70234_70260 = state_70206__$1;
(statearr_70234_70260[(1)] = (10));

} else {
var statearr_70235_70261 = state_70206__$1;
(statearr_70235_70261[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto____0 = (function (){
var statearr_70236 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70236[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto__);

(statearr_70236[(1)] = (1));

return statearr_70236;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto____1 = (function (state_70206){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70206);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70237){var ex__16398__auto__ = e70237;
var statearr_70238_70262 = state_70206;
(statearr_70238_70262[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70206[(4)]))){
var statearr_70239_70263 = state_70206;
(statearr_70239_70263[(1)] = cljs.core.first((state_70206[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70264 = state_70206;
state_70206 = G__70264;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto__ = function(state_70206){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto____1.call(this,state_70206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70240 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70240[(6)] = c__16469__auto__);

return statearr_70240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70303){
var state_val_70304 = (state_70303[(1)]);
if((state_val_70304 === (7))){
var state_70303__$1 = state_70303;
var statearr_70305_70329 = state_70303__$1;
(statearr_70305_70329[(2)] = subject);

(statearr_70305_70329[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70304 === (1))){
var state_70303__$1 = state_70303;
var statearr_70306_70330 = state_70303__$1;
(statearr_70306_70330[(2)] = null);

(statearr_70306_70330[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70304 === (4))){
var inst_70265 = (state_70303[(2)]);
var state_70303__$1 = state_70303;
var statearr_70307_70331 = state_70303__$1;
(statearr_70307_70331[(2)] = inst_70265);

(statearr_70307_70331[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70304 === (13))){
var inst_70282 = (state_70303[(2)]);
var inst_70283 = fluree.db.util.async.throw_err(inst_70282);
var state_70303__$1 = state_70303;
var statearr_70308_70332 = state_70303__$1;
(statearr_70308_70332[(2)] = inst_70283);

(statearr_70308_70332[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70304 === (6))){
var state_70303__$1 = state_70303;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70303__$1,(9),subject);
} else {
if((state_val_70304 === (3))){
var inst_70301 = (state_70303[(2)]);
var state_70303__$1 = state_70303;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70303__$1,inst_70301);
} else {
if((state_val_70304 === (12))){
var inst_70278 = (state_70303[(7)]);
var inst_70286 = (state_70303[(2)]);
var inst_70287 = fluree.db.dbfunctions.internal.get_in(inst_70278,inst_70286);
var inst_70288 = cljs.core.count(inst_70286);
var inst_70289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70290 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70292 = [inst_70278,inst_70286];
var inst_70293 = (new cljs.core.PersistentVector(null,2,(5),inst_70291,inst_70292,null));
var inst_70294 = ["get-in",inst_70293,inst_70287];
var inst_70295 = cljs.core.PersistentHashMap.fromArrays(inst_70290,inst_70294);
var inst_70296 = [inst_70295,inst_70288];
var inst_70297 = (new cljs.core.PersistentVector(null,2,(5),inst_70289,inst_70296,null));
var inst_70298 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70297);
var _ = (function (){var statearr_70309 = state_70303;
(statearr_70309[(4)] = cljs.core.rest((state_70303[(4)])));

return statearr_70309;
})();
var state_70303__$1 = (function (){var statearr_70310 = state_70303;
(statearr_70310[(8)] = inst_70298);

return statearr_70310;
})();
var statearr_70311_70333 = state_70303__$1;
(statearr_70311_70333[(2)] = inst_70287);

(statearr_70311_70333[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70304 === (2))){
var _ = (function (){var statearr_70312 = state_70303;
(statearr_70312[(4)] = cljs.core.cons((5),(state_70303[(4)])));

return statearr_70312;
})();
var inst_70271 = fluree.db.util.async.channel_QMARK_(subject);
var state_70303__$1 = state_70303;
if(inst_70271){
var statearr_70313_70334 = state_70303__$1;
(statearr_70313_70334[(1)] = (6));

} else {
var statearr_70314_70335 = state_70303__$1;
(statearr_70314_70335[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70304 === (11))){
var state_70303__$1 = state_70303;
var statearr_70316_70336 = state_70303__$1;
(statearr_70316_70336[(2)] = path);

(statearr_70316_70336[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70304 === (9))){
var inst_70274 = (state_70303[(2)]);
var inst_70275 = fluree.db.util.async.throw_err(inst_70274);
var state_70303__$1 = state_70303;
var statearr_70317_70337 = state_70303__$1;
(statearr_70317_70337[(2)] = inst_70275);

(statearr_70317_70337[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70304 === (5))){
var _ = (function (){var statearr_70318 = state_70303;
(statearr_70318[(4)] = cljs.core.rest((state_70303[(4)])));

return statearr_70318;
})();
var state_70303__$1 = state_70303;
var ex70315 = (state_70303__$1[(2)]);
var statearr_70319_70338 = state_70303__$1;
(statearr_70319_70338[(5)] = ex70315);


if((ex70315 instanceof Error)){
var statearr_70320_70339 = state_70303__$1;
(statearr_70320_70339[(1)] = (4));

(statearr_70320_70339[(5)] = null);

} else {
throw ex70315;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70304 === (10))){
var state_70303__$1 = state_70303;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70303__$1,(13),path);
} else {
if((state_val_70304 === (8))){
var inst_70278 = (state_70303[(2)]);
var inst_70279 = fluree.db.util.async.channel_QMARK_(path);
var state_70303__$1 = (function (){var statearr_70321 = state_70303;
(statearr_70321[(7)] = inst_70278);

return statearr_70321;
})();
if(inst_70279){
var statearr_70322_70340 = state_70303__$1;
(statearr_70322_70340[(1)] = (10));

} else {
var statearr_70323_70341 = state_70303__$1;
(statearr_70323_70341[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto____0 = (function (){
var statearr_70324 = [null,null,null,null,null,null,null,null,null];
(statearr_70324[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto__);

(statearr_70324[(1)] = (1));

return statearr_70324;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto____1 = (function (state_70303){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70303);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70325){var ex__16398__auto__ = e70325;
var statearr_70326_70342 = state_70303;
(statearr_70326_70342[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70303[(4)]))){
var statearr_70327_70343 = state_70303;
(statearr_70327_70343[(1)] = cljs.core.first((state_70303[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70344 = state_70303;
state_70303 = G__70344;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto__ = function(state_70303){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto____1.call(this,state_70303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70328 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70328[(6)] = c__16469__auto__);

return statearr_70328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70389){
var state_val_70390 = (state_70389[(1)]);
if((state_val_70390 === (7))){
var state_70389__$1 = state_70389;
var statearr_70391_70420 = state_70389__$1;
(statearr_70391_70420[(2)] = coll);

(statearr_70391_70420[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70390 === (1))){
var state_70389__$1 = state_70389;
var statearr_70392_70421 = state_70389__$1;
(statearr_70392_70421[(2)] = null);

(statearr_70392_70421[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70390 === (4))){
var inst_70345 = (state_70389[(2)]);
var state_70389__$1 = state_70389;
var statearr_70393_70422 = state_70389__$1;
(statearr_70393_70422[(2)] = inst_70345);

(statearr_70393_70422[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70390 === (15))){
var inst_70365 = (state_70389[(7)]);
var inst_70373 = (state_70389[(2)]);
var inst_70374 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_70365,inst_70373);
var inst_70375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70376 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70378 = [inst_70365,inst_70373];
var inst_70379 = (new cljs.core.PersistentVector(null,2,(5),inst_70377,inst_70378,null));
var inst_70380 = ["contains?",inst_70379,inst_70374];
var inst_70381 = cljs.core.PersistentHashMap.fromArrays(inst_70376,inst_70380);
var inst_70382 = [inst_70381,(10)];
var inst_70383 = (new cljs.core.PersistentVector(null,2,(5),inst_70375,inst_70382,null));
var inst_70384 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70383);
var _ = (function (){var statearr_70394 = state_70389;
(statearr_70394[(4)] = cljs.core.rest((state_70389[(4)])));

return statearr_70394;
})();
var state_70389__$1 = (function (){var statearr_70395 = state_70389;
(statearr_70395[(8)] = inst_70384);

return statearr_70395;
})();
var statearr_70396_70423 = state_70389__$1;
(statearr_70396_70423[(2)] = inst_70374);

(statearr_70396_70423[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70390 === (13))){
var state_70389__$1 = state_70389;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70389__$1,(16),key);
} else {
if((state_val_70390 === (6))){
var state_70389__$1 = state_70389;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70389__$1,(9),coll);
} else {
if((state_val_70390 === (3))){
var inst_70387 = (state_70389[(2)]);
var state_70389__$1 = state_70389;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70389__$1,inst_70387);
} else {
if((state_val_70390 === (12))){
var inst_70365 = (state_70389[(2)]);
var inst_70366 = fluree.db.util.async.channel_QMARK_(key);
var state_70389__$1 = (function (){var statearr_70397 = state_70389;
(statearr_70397[(7)] = inst_70365);

return statearr_70397;
})();
if(inst_70366){
var statearr_70398_70424 = state_70389__$1;
(statearr_70398_70424[(1)] = (13));

} else {
var statearr_70399_70425 = state_70389__$1;
(statearr_70399_70425[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70390 === (2))){
var _ = (function (){var statearr_70400 = state_70389;
(statearr_70400[(4)] = cljs.core.cons((5),(state_70389[(4)])));

return statearr_70400;
})();
var inst_70351 = fluree.db.util.async.channel_QMARK_(coll);
var state_70389__$1 = state_70389;
if(inst_70351){
var statearr_70401_70426 = state_70389__$1;
(statearr_70401_70426[(1)] = (6));

} else {
var statearr_70402_70427 = state_70389__$1;
(statearr_70402_70427[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70390 === (11))){
var inst_70358 = (state_70389[(9)]);
var inst_70362 = cljs.core.flatten(inst_70358);
var inst_70363 = cljs.core.set(inst_70362);
var state_70389__$1 = state_70389;
var statearr_70404_70428 = state_70389__$1;
(statearr_70404_70428[(2)] = inst_70363);

(statearr_70404_70428[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70390 === (9))){
var inst_70354 = (state_70389[(2)]);
var inst_70355 = fluree.db.util.async.throw_err(inst_70354);
var state_70389__$1 = state_70389;
var statearr_70405_70429 = state_70389__$1;
(statearr_70405_70429[(2)] = inst_70355);

(statearr_70405_70429[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70390 === (5))){
var _ = (function (){var statearr_70406 = state_70389;
(statearr_70406[(4)] = cljs.core.rest((state_70389[(4)])));

return statearr_70406;
})();
var state_70389__$1 = state_70389;
var ex70403 = (state_70389__$1[(2)]);
var statearr_70407_70430 = state_70389__$1;
(statearr_70407_70430[(5)] = ex70403);


if((ex70403 instanceof Error)){
var statearr_70408_70431 = state_70389__$1;
(statearr_70408_70431[(1)] = (4));

(statearr_70408_70431[(5)] = null);

} else {
throw ex70403;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70390 === (14))){
var state_70389__$1 = state_70389;
var statearr_70409_70432 = state_70389__$1;
(statearr_70409_70432[(2)] = key);

(statearr_70409_70432[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70390 === (16))){
var inst_70369 = (state_70389[(2)]);
var inst_70370 = fluree.db.util.async.throw_err(inst_70369);
var state_70389__$1 = state_70389;
var statearr_70410_70433 = state_70389__$1;
(statearr_70410_70433[(2)] = inst_70370);

(statearr_70410_70433[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70390 === (10))){
var inst_70358 = (state_70389[(9)]);
var state_70389__$1 = state_70389;
var statearr_70411_70434 = state_70389__$1;
(statearr_70411_70434[(2)] = inst_70358);

(statearr_70411_70434[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70390 === (8))){
var inst_70358 = (state_70389[(9)]);
var inst_70358__$1 = (state_70389[(2)]);
var inst_70359 = cljs.core.set_QMARK_(inst_70358__$1);
var state_70389__$1 = (function (){var statearr_70412 = state_70389;
(statearr_70412[(9)] = inst_70358__$1);

return statearr_70412;
})();
if(inst_70359){
var statearr_70413_70435 = state_70389__$1;
(statearr_70413_70435[(1)] = (10));

} else {
var statearr_70414_70436 = state_70389__$1;
(statearr_70414_70436[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_70415 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70415[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto__);

(statearr_70415[(1)] = (1));

return statearr_70415;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto____1 = (function (state_70389){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70389);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70416){var ex__16398__auto__ = e70416;
var statearr_70417_70437 = state_70389;
(statearr_70417_70437[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70389[(4)]))){
var statearr_70418_70438 = state_70389;
(statearr_70418_70438[(1)] = cljs.core.first((state_70389[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70439 = state_70389;
state_70389 = G__70439;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto__ = function(state_70389){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto____1.call(this,state_70389);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70419 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70419[(6)] = c__16469__auto__);

return statearr_70419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70511 = arguments.length;
var i__4819__auto___70512 = (0);
while(true){
if((i__4819__auto___70512 < len__4818__auto___70511)){
args__4824__auto__.push((arguments[i__4819__auto___70512]));

var G__70513 = (i__4819__auto___70512 + (1));
i__4819__auto___70512 = G__70513;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70485){
var state_val_70486 = (state_70485[(1)]);
if((state_val_70486 === (7))){
var inst_70451 = (state_70485[(7)]);
var inst_70455 = cljs.core.first(inst_70451);
var inst_70456 = cljs.core.coll_QMARK_(inst_70455);
var state_70485__$1 = state_70485;
var statearr_70487_70514 = state_70485__$1;
(statearr_70487_70514[(2)] = inst_70456);

(statearr_70487_70514[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70486 === (1))){
var state_70485__$1 = state_70485;
var statearr_70488_70515 = state_70485__$1;
(statearr_70488_70515[(2)] = null);

(statearr_70488_70515[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70486 === (4))){
var inst_70442 = (state_70485[(2)]);
var state_70485__$1 = state_70485;
var statearr_70489_70516 = state_70485__$1;
(statearr_70489_70516[(2)] = inst_70442);

(statearr_70489_70516[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70486 === (6))){
var inst_70453 = (state_70485[(8)]);
var inst_70451 = (state_70485[(7)]);
var inst_70450 = (state_70485[(2)]);
var inst_70451__$1 = fluree.db.util.async.throw_err(inst_70450);
var inst_70452 = cljs.core.count(inst_70451__$1);
var inst_70453__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_70452);
var state_70485__$1 = (function (){var statearr_70490 = state_70485;
(statearr_70490[(8)] = inst_70453__$1);

(statearr_70490[(7)] = inst_70451__$1);

return statearr_70490;
})();
if(inst_70453__$1){
var statearr_70491_70517 = state_70485__$1;
(statearr_70491_70517[(1)] = (7));

} else {
var statearr_70492_70518 = state_70485__$1;
(statearr_70492_70518[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70486 === (3))){
var inst_70483 = (state_70485[(2)]);
var state_70485__$1 = state_70485;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70485__$1,inst_70483);
} else {
if((state_val_70486 === (12))){
var inst_70464 = (state_70485[(2)]);
var inst_70465 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_70464);
var inst_70466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70467 = [inst_70464];
var inst_70468 = (new cljs.core.PersistentVector(null,1,(5),inst_70466,inst_70467,null));
var inst_70469 = cljs.core.count(inst_70468);
var inst_70470 = ((9) + inst_70469);
var inst_70471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70472 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70474 = [inst_70464];
var inst_70475 = (new cljs.core.PersistentVector(null,1,(5),inst_70473,inst_70474,null));
var inst_70476 = ["hash-set",inst_70475,inst_70465];
var inst_70477 = cljs.core.PersistentHashMap.fromArrays(inst_70472,inst_70476);
var inst_70478 = [inst_70477,inst_70470];
var inst_70479 = (new cljs.core.PersistentVector(null,2,(5),inst_70471,inst_70478,null));
var inst_70480 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70479);
var _ = (function (){var statearr_70493 = state_70485;
(statearr_70493[(4)] = cljs.core.rest((state_70485[(4)])));

return statearr_70493;
})();
var state_70485__$1 = (function (){var statearr_70494 = state_70485;
(statearr_70494[(9)] = inst_70480);

return statearr_70494;
})();
var statearr_70495_70519 = state_70485__$1;
(statearr_70495_70519[(2)] = inst_70465);

(statearr_70495_70519[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70486 === (2))){
var _ = (function (){var statearr_70496 = state_70485;
(statearr_70496[(4)] = cljs.core.cons((5),(state_70485[(4)])));

return statearr_70496;
})();
var inst_70448 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70485__$1 = state_70485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70485__$1,(6),inst_70448);
} else {
if((state_val_70486 === (11))){
var inst_70451 = (state_70485[(7)]);
var state_70485__$1 = state_70485;
var statearr_70498_70520 = state_70485__$1;
(statearr_70498_70520[(2)] = inst_70451);

(statearr_70498_70520[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70486 === (9))){
var inst_70459 = (state_70485[(2)]);
var state_70485__$1 = state_70485;
if(cljs.core.truth_(inst_70459)){
var statearr_70499_70521 = state_70485__$1;
(statearr_70499_70521[(1)] = (10));

} else {
var statearr_70500_70522 = state_70485__$1;
(statearr_70500_70522[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70486 === (5))){
var _ = (function (){var statearr_70501 = state_70485;
(statearr_70501[(4)] = cljs.core.rest((state_70485[(4)])));

return statearr_70501;
})();
var state_70485__$1 = state_70485;
var ex70497 = (state_70485__$1[(2)]);
var statearr_70502_70523 = state_70485__$1;
(statearr_70502_70523[(5)] = ex70497);


if((ex70497 instanceof Error)){
var statearr_70503_70524 = state_70485__$1;
(statearr_70503_70524[(1)] = (4));

(statearr_70503_70524[(5)] = null);

} else {
throw ex70497;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70486 === (10))){
var inst_70451 = (state_70485[(7)]);
var inst_70461 = cljs.core.first(inst_70451);
var state_70485__$1 = state_70485;
var statearr_70504_70525 = state_70485__$1;
(statearr_70504_70525[(2)] = inst_70461);

(statearr_70504_70525[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70486 === (8))){
var inst_70453 = (state_70485[(8)]);
var state_70485__$1 = state_70485;
var statearr_70505_70526 = state_70485__$1;
(statearr_70505_70526[(2)] = inst_70453);

(statearr_70505_70526[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70506 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70506[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70506[(1)] = (1));

return statearr_70506;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70485){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70485);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70507){var ex__16398__auto__ = e70507;
var statearr_70508_70527 = state_70485;
(statearr_70508_70527[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70485[(4)]))){
var statearr_70509_70528 = state_70485;
(statearr_70509_70528[(1)] = cljs.core.first((state_70485[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70529 = state_70485;
state_70485 = G__70529;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70485){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70510 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70510[(6)] = c__16469__auto__);

return statearr_70510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq70440){
var G__70441 = cljs.core.first(seq70440);
var seq70440__$1 = cljs.core.next(seq70440);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70441,seq70440__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70579 = arguments.length;
var i__4819__auto___70580 = (0);
while(true){
if((i__4819__auto___70580 < len__4818__auto___70579)){
args__4824__auto__.push((arguments[i__4819__auto___70580]));

var G__70581 = (i__4819__auto___70580 + (1));
i__4819__auto___70580 = G__70581;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70562){
var state_val_70563 = (state_70562[(1)]);
if((state_val_70563 === (1))){
var state_70562__$1 = state_70562;
var statearr_70564_70582 = state_70562__$1;
(statearr_70564_70582[(2)] = null);

(statearr_70564_70582[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70563 === (2))){
var _ = (function (){var statearr_70565 = state_70562;
(statearr_70565[(4)] = cljs.core.cons((5),(state_70562[(4)])));

return statearr_70565;
})();
var inst_70538 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70562__$1 = state_70562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70562__$1,(6),inst_70538);
} else {
if((state_val_70563 === (3))){
var inst_70560 = (state_70562[(2)]);
var state_70562__$1 = state_70562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70562__$1,inst_70560);
} else {
if((state_val_70563 === (4))){
var inst_70532 = (state_70562[(2)]);
var state_70562__$1 = state_70562;
var statearr_70567_70583 = state_70562__$1;
(statearr_70567_70583[(2)] = inst_70532);

(statearr_70567_70583[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70563 === (5))){
var _ = (function (){var statearr_70568 = state_70562;
(statearr_70568[(4)] = cljs.core.rest((state_70562[(4)])));

return statearr_70568;
})();
var state_70562__$1 = state_70562;
var ex70566 = (state_70562__$1[(2)]);
var statearr_70569_70584 = state_70562__$1;
(statearr_70569_70584[(5)] = ex70566);


if((ex70566 instanceof Error)){
var statearr_70570_70585 = state_70562__$1;
(statearr_70570_70585[(1)] = (4));

(statearr_70570_70585[(5)] = null);

} else {
throw ex70566;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70563 === (6))){
var inst_70540 = (state_70562[(2)]);
var inst_70541 = fluree.db.util.async.throw_err(inst_70540);
var inst_70542 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_70541);
var inst_70543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70544 = [inst_70541];
var inst_70545 = (new cljs.core.PersistentVector(null,1,(5),inst_70543,inst_70544,null));
var inst_70546 = cljs.core.count(inst_70545);
var inst_70547 = ((9) + inst_70546);
var inst_70548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70549 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70551 = [inst_70541];
var inst_70552 = (new cljs.core.PersistentVector(null,1,(5),inst_70550,inst_70551,null));
var inst_70553 = ["==",inst_70552,inst_70542];
var inst_70554 = cljs.core.PersistentHashMap.fromArrays(inst_70549,inst_70553);
var inst_70555 = [inst_70554,inst_70547];
var inst_70556 = (new cljs.core.PersistentVector(null,2,(5),inst_70548,inst_70555,null));
var inst_70557 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70556);
var _ = (function (){var statearr_70571 = state_70562;
(statearr_70571[(4)] = cljs.core.rest((state_70562[(4)])));

return statearr_70571;
})();
var state_70562__$1 = (function (){var statearr_70572 = state_70562;
(statearr_70572[(7)] = inst_70557);

return statearr_70572;
})();
var statearr_70573_70586 = state_70562__$1;
(statearr_70573_70586[(2)] = inst_70542);

(statearr_70573_70586[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70574 = [null,null,null,null,null,null,null,null];
(statearr_70574[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70574[(1)] = (1));

return statearr_70574;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70562){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70562);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70575){var ex__16398__auto__ = e70575;
var statearr_70576_70587 = state_70562;
(statearr_70576_70587[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70562[(4)]))){
var statearr_70577_70588 = state_70562;
(statearr_70577_70588[(1)] = cljs.core.first((state_70562[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70589 = state_70562;
state_70562 = G__70589;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70562){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70578 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70578[(6)] = c__16469__auto__);

return statearr_70578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq70530){
var G__70531 = cljs.core.first(seq70530);
var seq70530__$1 = cljs.core.next(seq70530);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70531,seq70530__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70639 = arguments.length;
var i__4819__auto___70640 = (0);
while(true){
if((i__4819__auto___70640 < len__4818__auto___70639)){
args__4824__auto__.push((arguments[i__4819__auto___70640]));

var G__70641 = (i__4819__auto___70640 + (1));
i__4819__auto___70640 = G__70641;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70622){
var state_val_70623 = (state_70622[(1)]);
if((state_val_70623 === (1))){
var state_70622__$1 = state_70622;
var statearr_70624_70642 = state_70622__$1;
(statearr_70624_70642[(2)] = null);

(statearr_70624_70642[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70623 === (2))){
var _ = (function (){var statearr_70625 = state_70622;
(statearr_70625[(4)] = cljs.core.cons((5),(state_70622[(4)])));

return statearr_70625;
})();
var inst_70598 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70622__$1 = state_70622;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70622__$1,(6),inst_70598);
} else {
if((state_val_70623 === (3))){
var inst_70620 = (state_70622[(2)]);
var state_70622__$1 = state_70622;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70622__$1,inst_70620);
} else {
if((state_val_70623 === (4))){
var inst_70592 = (state_70622[(2)]);
var state_70622__$1 = state_70622;
var statearr_70627_70643 = state_70622__$1;
(statearr_70627_70643[(2)] = inst_70592);

(statearr_70627_70643[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70623 === (5))){
var _ = (function (){var statearr_70628 = state_70622;
(statearr_70628[(4)] = cljs.core.rest((state_70622[(4)])));

return statearr_70628;
})();
var state_70622__$1 = state_70622;
var ex70626 = (state_70622__$1[(2)]);
var statearr_70629_70644 = state_70622__$1;
(statearr_70629_70644[(5)] = ex70626);


if((ex70626 instanceof Error)){
var statearr_70630_70645 = state_70622__$1;
(statearr_70630_70645[(1)] = (4));

(statearr_70630_70645[(5)] = null);

} else {
throw ex70626;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70623 === (6))){
var inst_70600 = (state_70622[(2)]);
var inst_70601 = fluree.db.util.async.throw_err(inst_70600);
var inst_70602 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_70601);
var inst_70603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70604 = [inst_70601];
var inst_70605 = (new cljs.core.PersistentVector(null,1,(5),inst_70603,inst_70604,null));
var inst_70606 = cljs.core.count(inst_70605);
var inst_70607 = ((9) + inst_70606);
var inst_70608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70609 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70610 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70611 = [inst_70601];
var inst_70612 = (new cljs.core.PersistentVector(null,1,(5),inst_70610,inst_70611,null));
var inst_70613 = [">",inst_70612,inst_70602];
var inst_70614 = cljs.core.PersistentHashMap.fromArrays(inst_70609,inst_70613);
var inst_70615 = [inst_70614,inst_70607];
var inst_70616 = (new cljs.core.PersistentVector(null,2,(5),inst_70608,inst_70615,null));
var inst_70617 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70616);
var _ = (function (){var statearr_70631 = state_70622;
(statearr_70631[(4)] = cljs.core.rest((state_70622[(4)])));

return statearr_70631;
})();
var state_70622__$1 = (function (){var statearr_70632 = state_70622;
(statearr_70632[(7)] = inst_70617);

return statearr_70632;
})();
var statearr_70633_70646 = state_70622__$1;
(statearr_70633_70646[(2)] = inst_70602);

(statearr_70633_70646[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70634 = [null,null,null,null,null,null,null,null];
(statearr_70634[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70634[(1)] = (1));

return statearr_70634;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70622){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70622);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70635){var ex__16398__auto__ = e70635;
var statearr_70636_70647 = state_70622;
(statearr_70636_70647[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70622[(4)]))){
var statearr_70637_70648 = state_70622;
(statearr_70637_70648[(1)] = cljs.core.first((state_70622[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70649 = state_70622;
state_70622 = G__70649;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70622){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70638 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70638[(6)] = c__16469__auto__);

return statearr_70638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq70590){
var G__70591 = cljs.core.first(seq70590);
var seq70590__$1 = cljs.core.next(seq70590);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70591,seq70590__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70699 = arguments.length;
var i__4819__auto___70700 = (0);
while(true){
if((i__4819__auto___70700 < len__4818__auto___70699)){
args__4824__auto__.push((arguments[i__4819__auto___70700]));

var G__70701 = (i__4819__auto___70700 + (1));
i__4819__auto___70700 = G__70701;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70682){
var state_val_70683 = (state_70682[(1)]);
if((state_val_70683 === (1))){
var state_70682__$1 = state_70682;
var statearr_70684_70702 = state_70682__$1;
(statearr_70684_70702[(2)] = null);

(statearr_70684_70702[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70683 === (2))){
var _ = (function (){var statearr_70685 = state_70682;
(statearr_70685[(4)] = cljs.core.cons((5),(state_70682[(4)])));

return statearr_70685;
})();
var inst_70658 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70682__$1 = state_70682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70682__$1,(6),inst_70658);
} else {
if((state_val_70683 === (3))){
var inst_70680 = (state_70682[(2)]);
var state_70682__$1 = state_70682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70682__$1,inst_70680);
} else {
if((state_val_70683 === (4))){
var inst_70652 = (state_70682[(2)]);
var state_70682__$1 = state_70682;
var statearr_70687_70703 = state_70682__$1;
(statearr_70687_70703[(2)] = inst_70652);

(statearr_70687_70703[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70683 === (5))){
var _ = (function (){var statearr_70688 = state_70682;
(statearr_70688[(4)] = cljs.core.rest((state_70682[(4)])));

return statearr_70688;
})();
var state_70682__$1 = state_70682;
var ex70686 = (state_70682__$1[(2)]);
var statearr_70689_70704 = state_70682__$1;
(statearr_70689_70704[(5)] = ex70686);


if((ex70686 instanceof Error)){
var statearr_70690_70705 = state_70682__$1;
(statearr_70690_70705[(1)] = (4));

(statearr_70690_70705[(5)] = null);

} else {
throw ex70686;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70683 === (6))){
var inst_70660 = (state_70682[(2)]);
var inst_70661 = fluree.db.util.async.throw_err(inst_70660);
var inst_70662 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_70661);
var inst_70663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70664 = [inst_70661];
var inst_70665 = (new cljs.core.PersistentVector(null,1,(5),inst_70663,inst_70664,null));
var inst_70666 = cljs.core.count(inst_70665);
var inst_70667 = ((9) + inst_70666);
var inst_70668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70669 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70671 = [inst_70661];
var inst_70672 = (new cljs.core.PersistentVector(null,1,(5),inst_70670,inst_70671,null));
var inst_70673 = ["<",inst_70672,inst_70662];
var inst_70674 = cljs.core.PersistentHashMap.fromArrays(inst_70669,inst_70673);
var inst_70675 = [inst_70674,inst_70667];
var inst_70676 = (new cljs.core.PersistentVector(null,2,(5),inst_70668,inst_70675,null));
var inst_70677 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70676);
var _ = (function (){var statearr_70691 = state_70682;
(statearr_70691[(4)] = cljs.core.rest((state_70682[(4)])));

return statearr_70691;
})();
var state_70682__$1 = (function (){var statearr_70692 = state_70682;
(statearr_70692[(7)] = inst_70677);

return statearr_70692;
})();
var statearr_70693_70706 = state_70682__$1;
(statearr_70693_70706[(2)] = inst_70662);

(statearr_70693_70706[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70694 = [null,null,null,null,null,null,null,null];
(statearr_70694[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70694[(1)] = (1));

return statearr_70694;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70682){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70682);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70695){var ex__16398__auto__ = e70695;
var statearr_70696_70707 = state_70682;
(statearr_70696_70707[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70682[(4)]))){
var statearr_70697_70708 = state_70682;
(statearr_70697_70708[(1)] = cljs.core.first((state_70682[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70709 = state_70682;
state_70682 = G__70709;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70682){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70698 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70698[(6)] = c__16469__auto__);

return statearr_70698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq70650){
var G__70651 = cljs.core.first(seq70650);
var seq70650__$1 = cljs.core.next(seq70650);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70651,seq70650__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70759 = arguments.length;
var i__4819__auto___70760 = (0);
while(true){
if((i__4819__auto___70760 < len__4818__auto___70759)){
args__4824__auto__.push((arguments[i__4819__auto___70760]));

var G__70761 = (i__4819__auto___70760 + (1));
i__4819__auto___70760 = G__70761;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70742){
var state_val_70743 = (state_70742[(1)]);
if((state_val_70743 === (1))){
var state_70742__$1 = state_70742;
var statearr_70744_70762 = state_70742__$1;
(statearr_70744_70762[(2)] = null);

(statearr_70744_70762[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70743 === (2))){
var _ = (function (){var statearr_70745 = state_70742;
(statearr_70745[(4)] = cljs.core.cons((5),(state_70742[(4)])));

return statearr_70745;
})();
var inst_70718 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70742__$1 = state_70742;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70742__$1,(6),inst_70718);
} else {
if((state_val_70743 === (3))){
var inst_70740 = (state_70742[(2)]);
var state_70742__$1 = state_70742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70742__$1,inst_70740);
} else {
if((state_val_70743 === (4))){
var inst_70712 = (state_70742[(2)]);
var state_70742__$1 = state_70742;
var statearr_70747_70763 = state_70742__$1;
(statearr_70747_70763[(2)] = inst_70712);

(statearr_70747_70763[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70743 === (5))){
var _ = (function (){var statearr_70748 = state_70742;
(statearr_70748[(4)] = cljs.core.rest((state_70742[(4)])));

return statearr_70748;
})();
var state_70742__$1 = state_70742;
var ex70746 = (state_70742__$1[(2)]);
var statearr_70749_70764 = state_70742__$1;
(statearr_70749_70764[(5)] = ex70746);


if((ex70746 instanceof Error)){
var statearr_70750_70765 = state_70742__$1;
(statearr_70750_70765[(1)] = (4));

(statearr_70750_70765[(5)] = null);

} else {
throw ex70746;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70743 === (6))){
var inst_70720 = (state_70742[(2)]);
var inst_70721 = fluree.db.util.async.throw_err(inst_70720);
var inst_70722 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_70721);
var inst_70723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70724 = [inst_70721];
var inst_70725 = (new cljs.core.PersistentVector(null,1,(5),inst_70723,inst_70724,null));
var inst_70726 = cljs.core.count(inst_70725);
var inst_70727 = ((9) + inst_70726);
var inst_70728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70729 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70731 = [inst_70721];
var inst_70732 = (new cljs.core.PersistentVector(null,1,(5),inst_70730,inst_70731,null));
var inst_70733 = ["<=",inst_70732,inst_70722];
var inst_70734 = cljs.core.PersistentHashMap.fromArrays(inst_70729,inst_70733);
var inst_70735 = [inst_70734,inst_70727];
var inst_70736 = (new cljs.core.PersistentVector(null,2,(5),inst_70728,inst_70735,null));
var inst_70737 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70736);
var _ = (function (){var statearr_70751 = state_70742;
(statearr_70751[(4)] = cljs.core.rest((state_70742[(4)])));

return statearr_70751;
})();
var state_70742__$1 = (function (){var statearr_70752 = state_70742;
(statearr_70752[(7)] = inst_70737);

return statearr_70752;
})();
var statearr_70753_70766 = state_70742__$1;
(statearr_70753_70766[(2)] = inst_70722);

(statearr_70753_70766[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70754 = [null,null,null,null,null,null,null,null];
(statearr_70754[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70754[(1)] = (1));

return statearr_70754;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70742){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70742);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70755){var ex__16398__auto__ = e70755;
var statearr_70756_70767 = state_70742;
(statearr_70756_70767[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70742[(4)]))){
var statearr_70757_70768 = state_70742;
(statearr_70757_70768[(1)] = cljs.core.first((state_70742[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70769 = state_70742;
state_70742 = G__70769;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70742){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70758 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70758[(6)] = c__16469__auto__);

return statearr_70758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq70710){
var G__70711 = cljs.core.first(seq70710);
var seq70710__$1 = cljs.core.next(seq70710);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70711,seq70710__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70819 = arguments.length;
var i__4819__auto___70820 = (0);
while(true){
if((i__4819__auto___70820 < len__4818__auto___70819)){
args__4824__auto__.push((arguments[i__4819__auto___70820]));

var G__70821 = (i__4819__auto___70820 + (1));
i__4819__auto___70820 = G__70821;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70802){
var state_val_70803 = (state_70802[(1)]);
if((state_val_70803 === (1))){
var state_70802__$1 = state_70802;
var statearr_70804_70822 = state_70802__$1;
(statearr_70804_70822[(2)] = null);

(statearr_70804_70822[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70803 === (2))){
var _ = (function (){var statearr_70805 = state_70802;
(statearr_70805[(4)] = cljs.core.cons((5),(state_70802[(4)])));

return statearr_70805;
})();
var inst_70778 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70802__$1 = state_70802;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70802__$1,(6),inst_70778);
} else {
if((state_val_70803 === (3))){
var inst_70800 = (state_70802[(2)]);
var state_70802__$1 = state_70802;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70802__$1,inst_70800);
} else {
if((state_val_70803 === (4))){
var inst_70772 = (state_70802[(2)]);
var state_70802__$1 = state_70802;
var statearr_70807_70823 = state_70802__$1;
(statearr_70807_70823[(2)] = inst_70772);

(statearr_70807_70823[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70803 === (5))){
var _ = (function (){var statearr_70808 = state_70802;
(statearr_70808[(4)] = cljs.core.rest((state_70802[(4)])));

return statearr_70808;
})();
var state_70802__$1 = state_70802;
var ex70806 = (state_70802__$1[(2)]);
var statearr_70809_70824 = state_70802__$1;
(statearr_70809_70824[(5)] = ex70806);


if((ex70806 instanceof Error)){
var statearr_70810_70825 = state_70802__$1;
(statearr_70810_70825[(1)] = (4));

(statearr_70810_70825[(5)] = null);

} else {
throw ex70806;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70803 === (6))){
var inst_70780 = (state_70802[(2)]);
var inst_70781 = fluree.db.util.async.throw_err(inst_70780);
var inst_70782 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_70781);
var inst_70783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70784 = [inst_70781];
var inst_70785 = (new cljs.core.PersistentVector(null,1,(5),inst_70783,inst_70784,null));
var inst_70786 = cljs.core.count(inst_70785);
var inst_70787 = ((9) + inst_70786);
var inst_70788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70789 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70791 = [inst_70781];
var inst_70792 = (new cljs.core.PersistentVector(null,1,(5),inst_70790,inst_70791,null));
var inst_70793 = [">=",inst_70792,inst_70782];
var inst_70794 = cljs.core.PersistentHashMap.fromArrays(inst_70789,inst_70793);
var inst_70795 = [inst_70794,inst_70787];
var inst_70796 = (new cljs.core.PersistentVector(null,2,(5),inst_70788,inst_70795,null));
var inst_70797 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70796);
var _ = (function (){var statearr_70811 = state_70802;
(statearr_70811[(4)] = cljs.core.rest((state_70802[(4)])));

return statearr_70811;
})();
var state_70802__$1 = (function (){var statearr_70812 = state_70802;
(statearr_70812[(7)] = inst_70797);

return statearr_70812;
})();
var statearr_70813_70826 = state_70802__$1;
(statearr_70813_70826[(2)] = inst_70782);

(statearr_70813_70826[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70814 = [null,null,null,null,null,null,null,null];
(statearr_70814[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70814[(1)] = (1));

return statearr_70814;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70802){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70802);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70815){var ex__16398__auto__ = e70815;
var statearr_70816_70827 = state_70802;
(statearr_70816_70827[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70802[(4)]))){
var statearr_70817_70828 = state_70802;
(statearr_70817_70828[(1)] = cljs.core.first((state_70802[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70829 = state_70802;
state_70802 = G__70829;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70802){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70818 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70818[(6)] = c__16469__auto__);

return statearr_70818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq70770){
var G__70771 = cljs.core.first(seq70770);
var seq70770__$1 = cljs.core.next(seq70770);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70771,seq70770__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70879 = arguments.length;
var i__4819__auto___70880 = (0);
while(true){
if((i__4819__auto___70880 < len__4818__auto___70879)){
args__4824__auto__.push((arguments[i__4819__auto___70880]));

var G__70881 = (i__4819__auto___70880 + (1));
i__4819__auto___70880 = G__70881;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70862){
var state_val_70863 = (state_70862[(1)]);
if((state_val_70863 === (1))){
var state_70862__$1 = state_70862;
var statearr_70864_70882 = state_70862__$1;
(statearr_70864_70882[(2)] = null);

(statearr_70864_70882[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70863 === (2))){
var _ = (function (){var statearr_70865 = state_70862;
(statearr_70865[(4)] = cljs.core.cons((5),(state_70862[(4)])));

return statearr_70865;
})();
var inst_70838 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70862__$1 = state_70862;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70862__$1,(6),inst_70838);
} else {
if((state_val_70863 === (3))){
var inst_70860 = (state_70862[(2)]);
var state_70862__$1 = state_70862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70862__$1,inst_70860);
} else {
if((state_val_70863 === (4))){
var inst_70832 = (state_70862[(2)]);
var state_70862__$1 = state_70862;
var statearr_70867_70883 = state_70862__$1;
(statearr_70867_70883[(2)] = inst_70832);

(statearr_70867_70883[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70863 === (5))){
var _ = (function (){var statearr_70868 = state_70862;
(statearr_70868[(4)] = cljs.core.rest((state_70862[(4)])));

return statearr_70868;
})();
var state_70862__$1 = state_70862;
var ex70866 = (state_70862__$1[(2)]);
var statearr_70869_70884 = state_70862__$1;
(statearr_70869_70884[(5)] = ex70866);


if((ex70866 instanceof Error)){
var statearr_70870_70885 = state_70862__$1;
(statearr_70870_70885[(1)] = (4));

(statearr_70870_70885[(5)] = null);

} else {
throw ex70866;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70863 === (6))){
var inst_70840 = (state_70862[(2)]);
var inst_70841 = fluree.db.util.async.throw_err(inst_70840);
var inst_70842 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_70841);
var inst_70843 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70844 = [inst_70841];
var inst_70845 = (new cljs.core.PersistentVector(null,1,(5),inst_70843,inst_70844,null));
var inst_70846 = cljs.core.count(inst_70845);
var inst_70847 = ((9) + inst_70846);
var inst_70848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70849 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70851 = [inst_70841];
var inst_70852 = (new cljs.core.PersistentVector(null,1,(5),inst_70850,inst_70851,null));
var inst_70853 = ["not=",inst_70852,inst_70842];
var inst_70854 = cljs.core.PersistentHashMap.fromArrays(inst_70849,inst_70853);
var inst_70855 = [inst_70854,inst_70847];
var inst_70856 = (new cljs.core.PersistentVector(null,2,(5),inst_70848,inst_70855,null));
var inst_70857 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70856);
var _ = (function (){var statearr_70871 = state_70862;
(statearr_70871[(4)] = cljs.core.rest((state_70862[(4)])));

return statearr_70871;
})();
var state_70862__$1 = (function (){var statearr_70872 = state_70862;
(statearr_70872[(7)] = inst_70857);

return statearr_70872;
})();
var statearr_70873_70886 = state_70862__$1;
(statearr_70873_70886[(2)] = inst_70842);

(statearr_70873_70886[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70874 = [null,null,null,null,null,null,null,null];
(statearr_70874[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70874[(1)] = (1));

return statearr_70874;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70862){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70862);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70875){var ex__16398__auto__ = e70875;
var statearr_70876_70887 = state_70862;
(statearr_70876_70887[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70862[(4)]))){
var statearr_70877_70888 = state_70862;
(statearr_70877_70888[(1)] = cljs.core.first((state_70862[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70889 = state_70862;
state_70862 = G__70889;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70862){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70878 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70878[(6)] = c__16469__auto__);

return statearr_70878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq70830){
var G__70831 = cljs.core.first(seq70830);
var seq70830__$1 = cljs.core.next(seq70830);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70831,seq70830__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70939 = arguments.length;
var i__4819__auto___70940 = (0);
while(true){
if((i__4819__auto___70940 < len__4818__auto___70939)){
args__4824__auto__.push((arguments[i__4819__auto___70940]));

var G__70941 = (i__4819__auto___70940 + (1));
i__4819__auto___70940 = G__70941;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70922){
var state_val_70923 = (state_70922[(1)]);
if((state_val_70923 === (1))){
var state_70922__$1 = state_70922;
var statearr_70924_70942 = state_70922__$1;
(statearr_70924_70942[(2)] = null);

(statearr_70924_70942[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70923 === (2))){
var _ = (function (){var statearr_70925 = state_70922;
(statearr_70925[(4)] = cljs.core.cons((5),(state_70922[(4)])));

return statearr_70925;
})();
var inst_70898 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70922__$1 = state_70922;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70922__$1,(6),inst_70898);
} else {
if((state_val_70923 === (3))){
var inst_70920 = (state_70922[(2)]);
var state_70922__$1 = state_70922;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70922__$1,inst_70920);
} else {
if((state_val_70923 === (4))){
var inst_70892 = (state_70922[(2)]);
var state_70922__$1 = state_70922;
var statearr_70927_70943 = state_70922__$1;
(statearr_70927_70943[(2)] = inst_70892);

(statearr_70927_70943[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70923 === (5))){
var _ = (function (){var statearr_70928 = state_70922;
(statearr_70928[(4)] = cljs.core.rest((state_70922[(4)])));

return statearr_70928;
})();
var state_70922__$1 = state_70922;
var ex70926 = (state_70922__$1[(2)]);
var statearr_70929_70944 = state_70922__$1;
(statearr_70929_70944[(5)] = ex70926);


if((ex70926 instanceof Error)){
var statearr_70930_70945 = state_70922__$1;
(statearr_70930_70945[(1)] = (4));

(statearr_70930_70945[(5)] = null);

} else {
throw ex70926;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70923 === (6))){
var inst_70900 = (state_70922[(2)]);
var inst_70901 = fluree.db.util.async.throw_err(inst_70900);
var inst_70902 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_70901);
var inst_70903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70904 = [inst_70901];
var inst_70905 = (new cljs.core.PersistentVector(null,1,(5),inst_70903,inst_70904,null));
var inst_70906 = cljs.core.count(inst_70905);
var inst_70907 = ((9) + inst_70906);
var inst_70908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70909 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70911 = [inst_70901];
var inst_70912 = (new cljs.core.PersistentVector(null,1,(5),inst_70910,inst_70911,null));
var inst_70913 = ["max",inst_70912,inst_70902];
var inst_70914 = cljs.core.PersistentHashMap.fromArrays(inst_70909,inst_70913);
var inst_70915 = [inst_70914,inst_70907];
var inst_70916 = (new cljs.core.PersistentVector(null,2,(5),inst_70908,inst_70915,null));
var inst_70917 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70916);
var _ = (function (){var statearr_70931 = state_70922;
(statearr_70931[(4)] = cljs.core.rest((state_70922[(4)])));

return statearr_70931;
})();
var state_70922__$1 = (function (){var statearr_70932 = state_70922;
(statearr_70932[(7)] = inst_70917);

return statearr_70932;
})();
var statearr_70933_70946 = state_70922__$1;
(statearr_70933_70946[(2)] = inst_70902);

(statearr_70933_70946[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70934 = [null,null,null,null,null,null,null,null];
(statearr_70934[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70934[(1)] = (1));

return statearr_70934;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70922){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70922);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70935){var ex__16398__auto__ = e70935;
var statearr_70936_70947 = state_70922;
(statearr_70936_70947[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70922[(4)]))){
var statearr_70937_70948 = state_70922;
(statearr_70937_70948[(1)] = cljs.core.first((state_70922[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70949 = state_70922;
state_70922 = G__70949;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70922){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70938 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70938[(6)] = c__16469__auto__);

return statearr_70938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq70890){
var G__70891 = cljs.core.first(seq70890);
var seq70890__$1 = cljs.core.next(seq70890);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70891,seq70890__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70999 = arguments.length;
var i__4819__auto___71000 = (0);
while(true){
if((i__4819__auto___71000 < len__4818__auto___70999)){
args__4824__auto__.push((arguments[i__4819__auto___71000]));

var G__71001 = (i__4819__auto___71000 + (1));
i__4819__auto___71000 = G__71001;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70982){
var state_val_70983 = (state_70982[(1)]);
if((state_val_70983 === (1))){
var state_70982__$1 = state_70982;
var statearr_70984_71002 = state_70982__$1;
(statearr_70984_71002[(2)] = null);

(statearr_70984_71002[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70983 === (2))){
var _ = (function (){var statearr_70985 = state_70982;
(statearr_70985[(4)] = cljs.core.cons((5),(state_70982[(4)])));

return statearr_70985;
})();
var inst_70958 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70982__$1 = state_70982;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70982__$1,(6),inst_70958);
} else {
if((state_val_70983 === (3))){
var inst_70980 = (state_70982[(2)]);
var state_70982__$1 = state_70982;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70982__$1,inst_70980);
} else {
if((state_val_70983 === (4))){
var inst_70952 = (state_70982[(2)]);
var state_70982__$1 = state_70982;
var statearr_70987_71003 = state_70982__$1;
(statearr_70987_71003[(2)] = inst_70952);

(statearr_70987_71003[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70983 === (5))){
var _ = (function (){var statearr_70988 = state_70982;
(statearr_70988[(4)] = cljs.core.rest((state_70982[(4)])));

return statearr_70988;
})();
var state_70982__$1 = state_70982;
var ex70986 = (state_70982__$1[(2)]);
var statearr_70989_71004 = state_70982__$1;
(statearr_70989_71004[(5)] = ex70986);


if((ex70986 instanceof Error)){
var statearr_70990_71005 = state_70982__$1;
(statearr_70990_71005[(1)] = (4));

(statearr_70990_71005[(5)] = null);

} else {
throw ex70986;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70983 === (6))){
var inst_70960 = (state_70982[(2)]);
var inst_70961 = fluree.db.util.async.throw_err(inst_70960);
var inst_70962 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_70961);
var inst_70963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70964 = [inst_70961];
var inst_70965 = (new cljs.core.PersistentVector(null,1,(5),inst_70963,inst_70964,null));
var inst_70966 = cljs.core.count(inst_70965);
var inst_70967 = ((9) + inst_70966);
var inst_70968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70969 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70971 = [inst_70961];
var inst_70972 = (new cljs.core.PersistentVector(null,1,(5),inst_70970,inst_70971,null));
var inst_70973 = ["min",inst_70972,inst_70962];
var inst_70974 = cljs.core.PersistentHashMap.fromArrays(inst_70969,inst_70973);
var inst_70975 = [inst_70974,inst_70967];
var inst_70976 = (new cljs.core.PersistentVector(null,2,(5),inst_70968,inst_70975,null));
var inst_70977 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70976);
var _ = (function (){var statearr_70991 = state_70982;
(statearr_70991[(4)] = cljs.core.rest((state_70982[(4)])));

return statearr_70991;
})();
var state_70982__$1 = (function (){var statearr_70992 = state_70982;
(statearr_70992[(7)] = inst_70977);

return statearr_70992;
})();
var statearr_70993_71006 = state_70982__$1;
(statearr_70993_71006[(2)] = inst_70962);

(statearr_70993_71006[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70994 = [null,null,null,null,null,null,null,null];
(statearr_70994[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70994[(1)] = (1));

return statearr_70994;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70982){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70982);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70995){var ex__16398__auto__ = e70995;
var statearr_70996_71007 = state_70982;
(statearr_70996_71007[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70982[(4)]))){
var statearr_70997_71008 = state_70982;
(statearr_70997_71008[(1)] = cljs.core.first((state_70982[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71009 = state_70982;
state_70982 = G__71009;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70982){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70998 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70998[(6)] = c__16469__auto__);

return statearr_70998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq70950){
var G__70951 = cljs.core.first(seq70950);
var seq70950__$1 = cljs.core.next(seq70950);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70951,seq70950__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__71011 = arguments.length;
switch (G__71011) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71056){
var state_val_71057 = (state_71056[(1)]);
if((state_val_71057 === (7))){
var state_71056__$1 = state_71056;
var statearr_71058_71195 = state_71056__$1;
(statearr_71058_71195[(2)] = query_map);

(statearr_71058_71195[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71057 === (1))){
var state_71056__$1 = state_71056;
var statearr_71059_71196 = state_71056__$1;
(statearr_71059_71196[(2)] = null);

(statearr_71059_71196[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71057 === (4))){
var inst_71012 = (state_71056[(2)]);
var state_71056__$1 = state_71056;
var statearr_71060_71197 = state_71056__$1;
(statearr_71060_71197[(2)] = inst_71012);

(statearr_71060_71197[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71057 === (13))){
var inst_71034 = (state_71056[(7)]);
var inst_71038 = (state_71056[(2)]);
var inst_71039 = fluree.db.util.async.throw_err(inst_71038);
var inst_71040 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71039,(0),null);
var inst_71041 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71039,(1),null);
var inst_71042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71043 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71045 = [inst_71034];
var inst_71046 = (new cljs.core.PersistentVector(null,1,(5),inst_71044,inst_71045,null));
var inst_71047 = ["query",inst_71046,inst_71040];
var inst_71048 = cljs.core.PersistentHashMap.fromArrays(inst_71043,inst_71047);
var inst_71049 = [inst_71048,inst_71041];
var inst_71050 = (new cljs.core.PersistentVector(null,2,(5),inst_71042,inst_71049,null));
var inst_71051 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71050);
var _ = (function (){var statearr_71061 = state_71056;
(statearr_71061[(4)] = cljs.core.rest((state_71056[(4)])));

return statearr_71061;
})();
var state_71056__$1 = (function (){var statearr_71062 = state_71056;
(statearr_71062[(8)] = inst_71051);

return statearr_71062;
})();
var statearr_71063_71198 = state_71056__$1;
(statearr_71063_71198[(2)] = inst_71040);

(statearr_71063_71198[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71057 === (6))){
var state_71056__$1 = state_71056;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71056__$1,(9),query_map);
} else {
if((state_val_71057 === (3))){
var inst_71054 = (state_71056[(2)]);
var state_71056__$1 = state_71056;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71056__$1,inst_71054);
} else {
if((state_val_71057 === (12))){
var inst_71034 = (state_71056[(7)]);
var inst_71034__$1 = (state_71056[(2)]);
var inst_71035 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_71036 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_71035,inst_71034__$1);
var state_71056__$1 = (function (){var statearr_71064 = state_71056;
(statearr_71064[(7)] = inst_71034__$1);

return statearr_71064;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71056__$1,(13),inst_71036);
} else {
if((state_val_71057 === (2))){
var _ = (function (){var statearr_71065 = state_71056;
(statearr_71065[(4)] = cljs.core.cons((5),(state_71056[(4)])));

return statearr_71065;
})();
var inst_71021 = fluree.db.util.async.channel_QMARK_(query_map);
var state_71056__$1 = state_71056;
if(inst_71021){
var statearr_71066_71199 = state_71056__$1;
(statearr_71066_71199[(1)] = (6));

} else {
var statearr_71067_71200 = state_71056__$1;
(statearr_71067_71200[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71057 === (11))){
var inst_71028 = (state_71056[(9)]);
var state_71056__$1 = state_71056;
var statearr_71069_71201 = state_71056__$1;
(statearr_71069_71201[(2)] = inst_71028);

(statearr_71069_71201[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71057 === (9))){
var inst_71024 = (state_71056[(2)]);
var inst_71025 = fluree.db.util.async.throw_err(inst_71024);
var state_71056__$1 = state_71056;
var statearr_71070_71202 = state_71056__$1;
(statearr_71070_71202[(2)] = inst_71025);

(statearr_71070_71202[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71057 === (5))){
var _ = (function (){var statearr_71071 = state_71056;
(statearr_71071[(4)] = cljs.core.rest((state_71056[(4)])));

return statearr_71071;
})();
var state_71056__$1 = state_71056;
var ex71068 = (state_71056__$1[(2)]);
var statearr_71072_71203 = state_71056__$1;
(statearr_71072_71203[(5)] = ex71068);


if((ex71068 instanceof Error)){
var statearr_71073_71204 = state_71056__$1;
(statearr_71073_71204[(1)] = (4));

(statearr_71073_71204[(5)] = null);

} else {
throw ex71068;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71057 === (10))){
var inst_71028 = (state_71056[(9)]);
var inst_71031 = fluree.db.util.json.parse(inst_71028);
var state_71056__$1 = state_71056;
var statearr_71074_71205 = state_71056__$1;
(statearr_71074_71205[(2)] = inst_71031);

(statearr_71074_71205[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71057 === (8))){
var inst_71028 = (state_71056[(9)]);
var inst_71028__$1 = (state_71056[(2)]);
var inst_71029 = typeof inst_71028__$1 === 'string';
var state_71056__$1 = (function (){var statearr_71075 = state_71056;
(statearr_71075[(9)] = inst_71028__$1);

return statearr_71075;
})();
if(cljs.core.truth_(inst_71029)){
var statearr_71076_71206 = state_71056__$1;
(statearr_71076_71206[(1)] = (10));

} else {
var statearr_71077_71207 = state_71056__$1;
(statearr_71077_71207[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71078 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71078[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71078[(1)] = (1));

return statearr_71078;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71056){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71056);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71079){var ex__16398__auto__ = e71079;
var statearr_71080_71208 = state_71056;
(statearr_71080_71208[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71056[(4)]))){
var statearr_71081_71209 = state_71056;
(statearr_71081_71209[(1)] = cljs.core.first((state_71056[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71210 = state_71056;
state_71056 = G__71210;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71056){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71082 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71082[(6)] = c__16469__auto__);

return statearr_71082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71153){
var state_val_71154 = (state_71153[(1)]);
if((state_val_71154 === (7))){
var state_71153__$1 = state_71153;
var statearr_71155_71211 = state_71153__$1;
(statearr_71155_71211[(2)] = select);

(statearr_71155_71211[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (20))){
var inst_71123 = (state_71153[(2)]);
var inst_71124 = fluree.db.util.async.channel_QMARK_(limit);
var state_71153__$1 = (function (){var statearr_71156 = state_71153;
(statearr_71156[(7)] = inst_71123);

return statearr_71156;
})();
if(inst_71124){
var statearr_71157_71212 = state_71153__$1;
(statearr_71157_71212[(1)] = (22));

} else {
var statearr_71158_71213 = state_71153__$1;
(statearr_71158_71213[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (1))){
var state_71153__$1 = state_71153;
var statearr_71159_71214 = state_71153__$1;
(statearr_71159_71214[(2)] = null);

(statearr_71159_71214[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (24))){
var inst_71099 = (state_71153[(8)]);
var inst_71123 = (state_71153[(7)]);
var inst_71107 = (state_71153[(9)]);
var inst_71115 = (state_71153[(10)]);
var inst_71131 = (state_71153[(2)]);
var inst_71132 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_71133 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_71132,inst_71099,inst_71107,inst_71115,inst_71123,inst_71131);
var state_71153__$1 = state_71153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71153__$1,(26),inst_71133);
} else {
if((state_val_71154 === (4))){
var inst_71083 = (state_71153[(2)]);
var state_71153__$1 = state_71153;
var statearr_71160_71215 = state_71153__$1;
(statearr_71160_71215[(2)] = inst_71083);

(statearr_71160_71215[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (15))){
var state_71153__$1 = state_71153;
var statearr_71161_71216 = state_71153__$1;
(statearr_71161_71216[(2)] = where);

(statearr_71161_71216[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (21))){
var inst_71119 = (state_71153[(2)]);
var inst_71120 = fluree.db.util.async.throw_err(inst_71119);
var state_71153__$1 = state_71153;
var statearr_71162_71217 = state_71153__$1;
(statearr_71162_71217[(2)] = inst_71120);

(statearr_71162_71217[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (13))){
var inst_71103 = (state_71153[(2)]);
var inst_71104 = fluree.db.util.async.throw_err(inst_71103);
var state_71153__$1 = state_71153;
var statearr_71163_71218 = state_71153__$1;
(statearr_71163_71218[(2)] = inst_71104);

(statearr_71163_71218[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (22))){
var state_71153__$1 = state_71153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71153__$1,(25),limit);
} else {
if((state_val_71154 === (6))){
var state_71153__$1 = state_71153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71153__$1,(9),select);
} else {
if((state_val_71154 === (25))){
var inst_71127 = (state_71153[(2)]);
var inst_71128 = fluree.db.util.async.throw_err(inst_71127);
var state_71153__$1 = state_71153;
var statearr_71164_71219 = state_71153__$1;
(statearr_71164_71219[(2)] = inst_71128);

(statearr_71164_71219[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (17))){
var inst_71111 = (state_71153[(2)]);
var inst_71112 = fluree.db.util.async.throw_err(inst_71111);
var state_71153__$1 = state_71153;
var statearr_71165_71220 = state_71153__$1;
(statearr_71165_71220[(2)] = inst_71112);

(statearr_71165_71220[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (3))){
var inst_71151 = (state_71153[(2)]);
var state_71153__$1 = state_71153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71153__$1,inst_71151);
} else {
if((state_val_71154 === (12))){
var inst_71107 = (state_71153[(2)]);
var inst_71108 = fluree.db.util.async.channel_QMARK_(where);
var state_71153__$1 = (function (){var statearr_71166 = state_71153;
(statearr_71166[(9)] = inst_71107);

return statearr_71166;
})();
if(inst_71108){
var statearr_71167_71221 = state_71153__$1;
(statearr_71167_71221[(1)] = (14));

} else {
var statearr_71168_71222 = state_71153__$1;
(statearr_71168_71222[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (2))){
var _ = (function (){var statearr_71169 = state_71153;
(statearr_71169[(4)] = cljs.core.cons((5),(state_71153[(4)])));

return statearr_71169;
})();
var inst_71092 = fluree.db.util.async.channel_QMARK_(select);
var state_71153__$1 = state_71153;
if(inst_71092){
var statearr_71170_71223 = state_71153__$1;
(statearr_71170_71223[(1)] = (6));

} else {
var statearr_71171_71224 = state_71153__$1;
(statearr_71171_71224[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (23))){
var state_71153__$1 = state_71153;
var statearr_71172_71225 = state_71153__$1;
(statearr_71172_71225[(2)] = limit);

(statearr_71172_71225[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (19))){
var state_71153__$1 = state_71153;
var statearr_71173_71226 = state_71153__$1;
(statearr_71173_71226[(2)] = block);

(statearr_71173_71226[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (11))){
var state_71153__$1 = state_71153;
var statearr_71175_71227 = state_71153__$1;
(statearr_71175_71227[(2)] = from);

(statearr_71175_71227[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (9))){
var inst_71095 = (state_71153[(2)]);
var inst_71096 = fluree.db.util.async.throw_err(inst_71095);
var state_71153__$1 = state_71153;
var statearr_71176_71228 = state_71153__$1;
(statearr_71176_71228[(2)] = inst_71096);

(statearr_71176_71228[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (5))){
var _ = (function (){var statearr_71177 = state_71153;
(statearr_71177[(4)] = cljs.core.rest((state_71153[(4)])));

return statearr_71177;
})();
var state_71153__$1 = state_71153;
var ex71174 = (state_71153__$1[(2)]);
var statearr_71178_71229 = state_71153__$1;
(statearr_71178_71229[(5)] = ex71174);


if((ex71174 instanceof Error)){
var statearr_71179_71230 = state_71153__$1;
(statearr_71179_71230[(1)] = (4));

(statearr_71179_71230[(5)] = null);

} else {
throw ex71174;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (14))){
var state_71153__$1 = state_71153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71153__$1,(17),where);
} else {
if((state_val_71154 === (26))){
var inst_71099 = (state_71153[(8)]);
var inst_71123 = (state_71153[(7)]);
var inst_71107 = (state_71153[(9)]);
var inst_71115 = (state_71153[(10)]);
var inst_71135 = (state_71153[(2)]);
var inst_71136 = fluree.db.util.async.throw_err(inst_71135);
var inst_71137 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71136,(0),null);
var inst_71138 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71136,(1),null);
var inst_71139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71140 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71142 = [inst_71099,inst_71107,inst_71115,inst_71123];
var inst_71143 = (new cljs.core.PersistentVector(null,4,(5),inst_71141,inst_71142,null));
var inst_71144 = ["query",inst_71143,inst_71137];
var inst_71145 = cljs.core.PersistentHashMap.fromArrays(inst_71140,inst_71144);
var inst_71146 = [inst_71145,inst_71138];
var inst_71147 = (new cljs.core.PersistentVector(null,2,(5),inst_71139,inst_71146,null));
var inst_71148 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71147);
var _ = (function (){var statearr_71180 = state_71153;
(statearr_71180[(4)] = cljs.core.rest((state_71153[(4)])));

return statearr_71180;
})();
var state_71153__$1 = (function (){var statearr_71181 = state_71153;
(statearr_71181[(11)] = inst_71148);

return statearr_71181;
})();
var statearr_71182_71231 = state_71153__$1;
(statearr_71182_71231[(2)] = inst_71137);

(statearr_71182_71231[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (16))){
var inst_71115 = (state_71153[(2)]);
var inst_71116 = fluree.db.util.async.channel_QMARK_(block);
var state_71153__$1 = (function (){var statearr_71183 = state_71153;
(statearr_71183[(10)] = inst_71115);

return statearr_71183;
})();
if(inst_71116){
var statearr_71184_71232 = state_71153__$1;
(statearr_71184_71232[(1)] = (18));

} else {
var statearr_71185_71233 = state_71153__$1;
(statearr_71185_71233[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71154 === (10))){
var state_71153__$1 = state_71153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71153__$1,(13),from);
} else {
if((state_val_71154 === (18))){
var state_71153__$1 = state_71153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71153__$1,(21),block);
} else {
if((state_val_71154 === (8))){
var inst_71099 = (state_71153[(2)]);
var inst_71100 = fluree.db.util.async.channel_QMARK_(from);
var state_71153__$1 = (function (){var statearr_71186 = state_71153;
(statearr_71186[(8)] = inst_71099);

return statearr_71186;
})();
if(inst_71100){
var statearr_71187_71234 = state_71153__$1;
(statearr_71187_71234[(1)] = (10));

} else {
var statearr_71188_71235 = state_71153__$1;
(statearr_71188_71235[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71189 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71189[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71189[(1)] = (1));

return statearr_71189;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71153){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71153);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71190){var ex__16398__auto__ = e71190;
var statearr_71191_71236 = state_71153;
(statearr_71191_71236[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71153[(4)]))){
var statearr_71192_71237 = state_71153;
(statearr_71192_71237[(1)] = cljs.core.first((state_71153[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71238 = state_71153;
state_71153 = G__71238;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71153){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71193 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71193[(6)] = c__16469__auto__);

return statearr_71193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71294){
var state_val_71295 = (state_71294[(1)]);
if((state_val_71295 === (7))){
var state_71294__$1 = state_71294;
var statearr_71296_71327 = state_71294__$1;
(statearr_71296_71327[(2)] = startSubject);

(statearr_71296_71327[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (1))){
var state_71294__$1 = state_71294;
var statearr_71297_71328 = state_71294__$1;
(statearr_71297_71328[(2)] = null);

(statearr_71297_71328[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (4))){
var inst_71239 = (state_71294[(2)]);
var state_71294__$1 = state_71294;
var statearr_71298_71329 = state_71294__$1;
(statearr_71298_71329[(2)] = inst_71239);

(statearr_71298_71329[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (15))){
var inst_71271 = (state_71294[(2)]);
var inst_71272 = fluree.db.util.async.throw_err(inst_71271);
var inst_71273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71272,(0),null);
var inst_71274 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71272,(1),null);
var inst_71275 = cljs.core.empty_QMARK_(inst_71273);
var state_71294__$1 = (function (){var statearr_71299 = state_71294;
(statearr_71299[(7)] = inst_71274);

return statearr_71299;
})();
if(inst_71275){
var statearr_71300_71330 = state_71294__$1;
(statearr_71300_71330[(1)] = (16));

} else {
var statearr_71301_71331 = state_71294__$1;
(statearr_71301_71331[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (13))){
var inst_71255 = (state_71294[(8)]);
var inst_71267 = (state_71294[(9)]);
var inst_71259 = (state_71294[(10)]);
var inst_71267__$1 = (state_71294[(2)]);
var inst_71268 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_71269 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_71268,inst_71255,inst_71259,inst_71267__$1);
var state_71294__$1 = (function (){var statearr_71302 = state_71294;
(statearr_71302[(9)] = inst_71267__$1);

return statearr_71302;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71294__$1,(15),inst_71269);
} else {
if((state_val_71295 === (6))){
var state_71294__$1 = state_71294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71294__$1,(9),startSubject);
} else {
if((state_val_71295 === (17))){
var state_71294__$1 = state_71294;
var statearr_71303_71332 = state_71294__$1;
(statearr_71303_71332[(2)] = true);

(statearr_71303_71332[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (3))){
var inst_71292 = (state_71294[(2)]);
var state_71294__$1 = state_71294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71294__$1,inst_71292);
} else {
if((state_val_71295 === (12))){
var state_71294__$1 = state_71294;
var statearr_71304_71333 = state_71294__$1;
(statearr_71304_71333[(2)] = endSubject);

(statearr_71304_71333[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (2))){
var _ = (function (){var statearr_71305 = state_71294;
(statearr_71305[(4)] = cljs.core.cons((5),(state_71294[(4)])));

return statearr_71305;
})();
var inst_71248 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_71294__$1 = state_71294;
if(inst_71248){
var statearr_71306_71334 = state_71294__$1;
(statearr_71306_71334[(1)] = (6));

} else {
var statearr_71307_71335 = state_71294__$1;
(statearr_71307_71335[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (11))){
var state_71294__$1 = state_71294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71294__$1,(14),endSubject);
} else {
if((state_val_71295 === (9))){
var inst_71251 = (state_71294[(2)]);
var inst_71252 = fluree.db.util.async.throw_err(inst_71251);
var state_71294__$1 = state_71294;
var statearr_71309_71336 = state_71294__$1;
(statearr_71309_71336[(2)] = inst_71252);

(statearr_71309_71336[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (5))){
var _ = (function (){var statearr_71310 = state_71294;
(statearr_71310[(4)] = cljs.core.rest((state_71294[(4)])));

return statearr_71310;
})();
var state_71294__$1 = state_71294;
var ex71308 = (state_71294__$1[(2)]);
var statearr_71311_71337 = state_71294__$1;
(statearr_71311_71337[(5)] = ex71308);


if((ex71308 instanceof Error)){
var statearr_71312_71338 = state_71294__$1;
(statearr_71312_71338[(1)] = (4));

(statearr_71312_71338[(5)] = null);

} else {
throw ex71308;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (14))){
var inst_71263 = (state_71294[(2)]);
var inst_71264 = fluree.db.util.async.throw_err(inst_71263);
var state_71294__$1 = state_71294;
var statearr_71313_71339 = state_71294__$1;
(statearr_71313_71339[(2)] = inst_71264);

(statearr_71313_71339[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (16))){
var state_71294__$1 = state_71294;
var statearr_71314_71340 = state_71294__$1;
(statearr_71314_71340[(2)] = false);

(statearr_71314_71340[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (10))){
var inst_71258 = (state_71294[(2)]);
var inst_71259 = fluree.db.util.async.throw_err(inst_71258);
var inst_71260 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_71294__$1 = (function (){var statearr_71315 = state_71294;
(statearr_71315[(10)] = inst_71259);

return statearr_71315;
})();
if(inst_71260){
var statearr_71316_71341 = state_71294__$1;
(statearr_71316_71341[(1)] = (11));

} else {
var statearr_71317_71342 = state_71294__$1;
(statearr_71317_71342[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (18))){
var inst_71255 = (state_71294[(8)]);
var inst_71267 = (state_71294[(9)]);
var inst_71259 = (state_71294[(10)]);
var inst_71274 = (state_71294[(7)]);
var inst_71279 = (state_71294[(2)]);
var inst_71280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71281 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71283 = [inst_71255,inst_71259,inst_71267];
var inst_71284 = (new cljs.core.PersistentVector(null,3,(5),inst_71282,inst_71283,null));
var inst_71285 = ["relationship?",inst_71284,inst_71279];
var inst_71286 = cljs.core.PersistentHashMap.fromArrays(inst_71281,inst_71285);
var inst_71287 = [inst_71286,inst_71274];
var inst_71288 = (new cljs.core.PersistentVector(null,2,(5),inst_71280,inst_71287,null));
var inst_71289 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71288);
var _ = (function (){var statearr_71318 = state_71294;
(statearr_71318[(4)] = cljs.core.rest((state_71294[(4)])));

return statearr_71318;
})();
var state_71294__$1 = (function (){var statearr_71319 = state_71294;
(statearr_71319[(11)] = inst_71289);

return statearr_71319;
})();
var statearr_71320_71343 = state_71294__$1;
(statearr_71320_71343[(2)] = inst_71279);

(statearr_71320_71343[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71295 === (8))){
var inst_71255 = (state_71294[(2)]);
var inst_71256 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_71294__$1 = (function (){var statearr_71321 = state_71294;
(statearr_71321[(8)] = inst_71255);

return statearr_71321;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71294__$1,(10),inst_71256);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_71322 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71322[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto__);

(statearr_71322[(1)] = (1));

return statearr_71322;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto____1 = (function (state_71294){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71294);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71323){var ex__16398__auto__ = e71323;
var statearr_71324_71344 = state_71294;
(statearr_71324_71344[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71294[(4)]))){
var statearr_71325_71345 = state_71294;
(statearr_71325_71345[(1)] = cljs.core.first((state_71294[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71346 = state_71294;
state_71294 = G__71346;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto__ = function(state_71294){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto____1.call(this,state_71294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71326 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71326[(6)] = c__16469__auto__);

return statearr_71326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71383){
var state_val_71384 = (state_71383[(1)]);
if((state_val_71384 === (7))){
var state_71383__$1 = state_71383;
var statearr_71385_71405 = state_71383__$1;
(statearr_71385_71405[(2)] = pred_name);

(statearr_71385_71405[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71384 === (1))){
var state_71383__$1 = state_71383;
var statearr_71386_71406 = state_71383__$1;
(statearr_71386_71406[(2)] = null);

(statearr_71386_71406[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71384 === (4))){
var inst_71347 = (state_71383[(2)]);
var state_71383__$1 = state_71383;
var statearr_71387_71407 = state_71383__$1;
(statearr_71387_71407[(2)] = inst_71347);

(statearr_71387_71407[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71384 === (6))){
var state_71383__$1 = state_71383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71383__$1,(9),pred_name);
} else {
if((state_val_71384 === (3))){
var inst_71381 = (state_71383[(2)]);
var state_71383__$1 = state_71383;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71383__$1,inst_71381);
} else {
if((state_val_71384 === (2))){
var _ = (function (){var statearr_71389 = state_71383;
(statearr_71389[(4)] = cljs.core.cons((5),(state_71383[(4)])));

return statearr_71389;
})();
var inst_71356 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_71383__$1 = state_71383;
if(inst_71356){
var statearr_71390_71408 = state_71383__$1;
(statearr_71390_71408[(1)] = (6));

} else {
var statearr_71391_71409 = state_71383__$1;
(statearr_71391_71409[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71384 === (9))){
var inst_71359 = (state_71383[(2)]);
var inst_71360 = fluree.db.util.async.throw_err(inst_71359);
var state_71383__$1 = state_71383;
var statearr_71392_71410 = state_71383__$1;
(statearr_71392_71410[(2)] = inst_71360);

(statearr_71392_71410[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71384 === (5))){
var _ = (function (){var statearr_71393 = state_71383;
(statearr_71393[(4)] = cljs.core.rest((state_71383[(4)])));

return statearr_71393;
})();
var state_71383__$1 = state_71383;
var ex71388 = (state_71383__$1[(2)]);
var statearr_71394_71411 = state_71383__$1;
(statearr_71394_71411[(5)] = ex71388);


if((ex71388 instanceof Error)){
var statearr_71395_71412 = state_71383__$1;
(statearr_71395_71412[(1)] = (4));

(statearr_71395_71412[(5)] = null);

} else {
throw ex71388;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71384 === (10))){
var inst_71363 = (state_71383[(7)]);
var inst_71367 = (state_71383[(2)]);
var inst_71368 = fluree.db.util.async.throw_err(inst_71367);
var inst_71369 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71368,(0),null);
var inst_71370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71368,(1),null);
var inst_71371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71372 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71373 = ["max-pred-val",inst_71363,inst_71369];
var inst_71374 = cljs.core.PersistentHashMap.fromArrays(inst_71372,inst_71373);
var inst_71375 = (inst_71370 + (10));
var inst_71376 = [inst_71374,inst_71375];
var inst_71377 = (new cljs.core.PersistentVector(null,2,(5),inst_71371,inst_71376,null));
var inst_71378 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71377);
var _ = (function (){var statearr_71396 = state_71383;
(statearr_71396[(4)] = cljs.core.rest((state_71383[(4)])));

return statearr_71396;
})();
var state_71383__$1 = (function (){var statearr_71397 = state_71383;
(statearr_71397[(8)] = inst_71378);

return statearr_71397;
})();
var statearr_71398_71413 = state_71383__$1;
(statearr_71398_71413[(2)] = inst_71369);

(statearr_71398_71413[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71384 === (8))){
var inst_71363 = (state_71383[(7)]);
var inst_71363__$1 = (state_71383[(2)]);
var inst_71364 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_71365 = fluree.db.dbfunctions.internal.max_pred_val(inst_71364,inst_71363__$1,null);
var state_71383__$1 = (function (){var statearr_71399 = state_71383;
(statearr_71399[(7)] = inst_71363__$1);

return statearr_71399;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71383__$1,(10),inst_71365);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto____0 = (function (){
var statearr_71400 = [null,null,null,null,null,null,null,null,null];
(statearr_71400[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto__);

(statearr_71400[(1)] = (1));

return statearr_71400;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto____1 = (function (state_71383){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71383);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71401){var ex__16398__auto__ = e71401;
var statearr_71402_71414 = state_71383;
(statearr_71402_71414[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71383[(4)]))){
var statearr_71403_71415 = state_71383;
(statearr_71403_71415[(1)] = cljs.core.first((state_71383[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71416 = state_71383;
state_71383 = G__71416;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto__ = function(state_71383){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto____1.call(this,state_71383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71404 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71404[(6)] = c__16469__auto__);

return statearr_71404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71443){
var state_val_71444 = (state_71443[(1)]);
if((state_val_71444 === (7))){
var state_71443__$1 = state_71443;
var statearr_71445_71464 = state_71443__$1;
(statearr_71445_71464[(2)] = n);

(statearr_71445_71464[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71444 === (1))){
var state_71443__$1 = state_71443;
var statearr_71446_71465 = state_71443__$1;
(statearr_71446_71465[(2)] = null);

(statearr_71446_71465[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71444 === (4))){
var inst_71417 = (state_71443[(2)]);
var state_71443__$1 = state_71443;
var statearr_71447_71466 = state_71443__$1;
(statearr_71447_71466[(2)] = inst_71417);

(statearr_71447_71466[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71444 === (6))){
var state_71443__$1 = state_71443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71443__$1,(9),n);
} else {
if((state_val_71444 === (3))){
var inst_71441 = (state_71443[(2)]);
var state_71443__$1 = state_71443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71443__$1,inst_71441);
} else {
if((state_val_71444 === (2))){
var _ = (function (){var statearr_71449 = state_71443;
(statearr_71449[(4)] = cljs.core.cons((5),(state_71443[(4)])));

return statearr_71449;
})();
var inst_71423 = fluree.db.util.async.channel_QMARK_(n);
var state_71443__$1 = state_71443;
if(inst_71423){
var statearr_71450_71467 = state_71443__$1;
(statearr_71450_71467[(1)] = (6));

} else {
var statearr_71451_71468 = state_71443__$1;
(statearr_71451_71468[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71444 === (9))){
var inst_71426 = (state_71443[(2)]);
var inst_71427 = fluree.db.util.async.throw_err(inst_71426);
var state_71443__$1 = state_71443;
var statearr_71452_71469 = state_71443__$1;
(statearr_71452_71469[(2)] = inst_71427);

(statearr_71452_71469[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71444 === (5))){
var _ = (function (){var statearr_71453 = state_71443;
(statearr_71453[(4)] = cljs.core.rest((state_71443[(4)])));

return statearr_71453;
})();
var state_71443__$1 = state_71443;
var ex71448 = (state_71443__$1[(2)]);
var statearr_71454_71470 = state_71443__$1;
(statearr_71454_71470[(5)] = ex71448);


if((ex71448 instanceof Error)){
var statearr_71455_71471 = state_71443__$1;
(statearr_71455_71471[(1)] = (4));

(statearr_71455_71471[(5)] = null);

} else {
throw ex71448;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71444 === (8))){
var inst_71430 = (state_71443[(2)]);
var inst_71431 = fluree.db.dbfunctions.internal.inc(inst_71430);
var inst_71432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71433 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71434 = ["inc",inst_71430,inst_71431];
var inst_71435 = cljs.core.PersistentHashMap.fromArrays(inst_71433,inst_71434);
var inst_71436 = [inst_71435,(10)];
var inst_71437 = (new cljs.core.PersistentVector(null,2,(5),inst_71432,inst_71436,null));
var inst_71438 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71437);
var _ = (function (){var statearr_71456 = state_71443;
(statearr_71456[(4)] = cljs.core.rest((state_71443[(4)])));

return statearr_71456;
})();
var state_71443__$1 = (function (){var statearr_71457 = state_71443;
(statearr_71457[(7)] = inst_71438);

return statearr_71457;
})();
var statearr_71458_71472 = state_71443__$1;
(statearr_71458_71472[(2)] = inst_71431);

(statearr_71458_71472[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto____0 = (function (){
var statearr_71459 = [null,null,null,null,null,null,null,null];
(statearr_71459[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto__);

(statearr_71459[(1)] = (1));

return statearr_71459;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto____1 = (function (state_71443){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71443);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71460){var ex__16398__auto__ = e71460;
var statearr_71461_71473 = state_71443;
(statearr_71461_71473[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71443[(4)]))){
var statearr_71462_71474 = state_71443;
(statearr_71462_71474[(1)] = cljs.core.first((state_71443[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71475 = state_71443;
state_71443 = G__71475;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto__ = function(state_71443){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto____1.call(this,state_71443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71463 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71463[(6)] = c__16469__auto__);

return statearr_71463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71502){
var state_val_71503 = (state_71502[(1)]);
if((state_val_71503 === (7))){
var state_71502__$1 = state_71502;
var statearr_71504_71523 = state_71502__$1;
(statearr_71504_71523[(2)] = n);

(statearr_71504_71523[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71503 === (1))){
var state_71502__$1 = state_71502;
var statearr_71505_71524 = state_71502__$1;
(statearr_71505_71524[(2)] = null);

(statearr_71505_71524[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71503 === (4))){
var inst_71476 = (state_71502[(2)]);
var state_71502__$1 = state_71502;
var statearr_71506_71525 = state_71502__$1;
(statearr_71506_71525[(2)] = inst_71476);

(statearr_71506_71525[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71503 === (6))){
var state_71502__$1 = state_71502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71502__$1,(9),n);
} else {
if((state_val_71503 === (3))){
var inst_71500 = (state_71502[(2)]);
var state_71502__$1 = state_71502;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71502__$1,inst_71500);
} else {
if((state_val_71503 === (2))){
var _ = (function (){var statearr_71508 = state_71502;
(statearr_71508[(4)] = cljs.core.cons((5),(state_71502[(4)])));

return statearr_71508;
})();
var inst_71482 = fluree.db.util.async.channel_QMARK_(n);
var state_71502__$1 = state_71502;
if(inst_71482){
var statearr_71509_71526 = state_71502__$1;
(statearr_71509_71526[(1)] = (6));

} else {
var statearr_71510_71527 = state_71502__$1;
(statearr_71510_71527[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71503 === (9))){
var inst_71485 = (state_71502[(2)]);
var inst_71486 = fluree.db.util.async.throw_err(inst_71485);
var state_71502__$1 = state_71502;
var statearr_71511_71528 = state_71502__$1;
(statearr_71511_71528[(2)] = inst_71486);

(statearr_71511_71528[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71503 === (5))){
var _ = (function (){var statearr_71512 = state_71502;
(statearr_71512[(4)] = cljs.core.rest((state_71502[(4)])));

return statearr_71512;
})();
var state_71502__$1 = state_71502;
var ex71507 = (state_71502__$1[(2)]);
var statearr_71513_71529 = state_71502__$1;
(statearr_71513_71529[(5)] = ex71507);


if((ex71507 instanceof Error)){
var statearr_71514_71530 = state_71502__$1;
(statearr_71514_71530[(1)] = (4));

(statearr_71514_71530[(5)] = null);

} else {
throw ex71507;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71503 === (8))){
var inst_71489 = (state_71502[(2)]);
var inst_71490 = fluree.db.dbfunctions.internal.dec(inst_71489);
var inst_71491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71492 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71493 = ["dec",inst_71489,inst_71490];
var inst_71494 = cljs.core.PersistentHashMap.fromArrays(inst_71492,inst_71493);
var inst_71495 = [inst_71494,(10)];
var inst_71496 = (new cljs.core.PersistentVector(null,2,(5),inst_71491,inst_71495,null));
var inst_71497 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71496);
var _ = (function (){var statearr_71515 = state_71502;
(statearr_71515[(4)] = cljs.core.rest((state_71502[(4)])));

return statearr_71515;
})();
var state_71502__$1 = (function (){var statearr_71516 = state_71502;
(statearr_71516[(7)] = inst_71497);

return statearr_71516;
})();
var statearr_71517_71531 = state_71502__$1;
(statearr_71517_71531[(2)] = inst_71490);

(statearr_71517_71531[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto____0 = (function (){
var statearr_71518 = [null,null,null,null,null,null,null,null];
(statearr_71518[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto__);

(statearr_71518[(1)] = (1));

return statearr_71518;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto____1 = (function (state_71502){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71502);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71519){var ex__16398__auto__ = e71519;
var statearr_71520_71532 = state_71502;
(statearr_71520_71532[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71502[(4)]))){
var statearr_71521_71533 = state_71502;
(statearr_71521_71533[(1)] = cljs.core.first((state_71502[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71534 = state_71502;
state_71502 = G__71534;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto__ = function(state_71502){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto____1.call(this,state_71502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71522 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71522[(6)] = c__16469__auto__);

return statearr_71522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71584 = arguments.length;
var i__4819__auto___71585 = (0);
while(true){
if((i__4819__auto___71585 < len__4818__auto___71584)){
args__4824__auto__.push((arguments[i__4819__auto___71585]));

var G__71586 = (i__4819__auto___71585 + (1));
i__4819__auto___71585 = G__71586;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71567){
var state_val_71568 = (state_71567[(1)]);
if((state_val_71568 === (1))){
var state_71567__$1 = state_71567;
var statearr_71569_71587 = state_71567__$1;
(statearr_71569_71587[(2)] = null);

(statearr_71569_71587[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71568 === (2))){
var _ = (function (){var statearr_71570 = state_71567;
(statearr_71570[(4)] = cljs.core.cons((5),(state_71567[(4)])));

return statearr_71570;
})();
var inst_71543 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71567__$1 = state_71567;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71567__$1,(6),inst_71543);
} else {
if((state_val_71568 === (3))){
var inst_71565 = (state_71567[(2)]);
var state_71567__$1 = state_71567;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71567__$1,inst_71565);
} else {
if((state_val_71568 === (4))){
var inst_71537 = (state_71567[(2)]);
var state_71567__$1 = state_71567;
var statearr_71572_71588 = state_71567__$1;
(statearr_71572_71588[(2)] = inst_71537);

(statearr_71572_71588[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71568 === (5))){
var _ = (function (){var statearr_71573 = state_71567;
(statearr_71573[(4)] = cljs.core.rest((state_71567[(4)])));

return statearr_71573;
})();
var state_71567__$1 = state_71567;
var ex71571 = (state_71567__$1[(2)]);
var statearr_71574_71589 = state_71567__$1;
(statearr_71574_71589[(5)] = ex71571);


if((ex71571 instanceof Error)){
var statearr_71575_71590 = state_71567__$1;
(statearr_71575_71590[(1)] = (4));

(statearr_71575_71590[(5)] = null);

} else {
throw ex71571;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71568 === (6))){
var inst_71545 = (state_71567[(2)]);
var inst_71546 = fluree.db.util.async.throw_err(inst_71545);
var inst_71547 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_71546);
var inst_71548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71549 = [inst_71546];
var inst_71550 = (new cljs.core.PersistentVector(null,1,(5),inst_71548,inst_71549,null));
var inst_71551 = cljs.core.count(inst_71550);
var inst_71552 = ((9) + inst_71551);
var inst_71553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71554 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71556 = [inst_71546];
var inst_71557 = (new cljs.core.PersistentVector(null,1,(5),inst_71555,inst_71556,null));
var inst_71558 = ["+",inst_71557,inst_71547];
var inst_71559 = cljs.core.PersistentHashMap.fromArrays(inst_71554,inst_71558);
var inst_71560 = [inst_71559,inst_71552];
var inst_71561 = (new cljs.core.PersistentVector(null,2,(5),inst_71553,inst_71560,null));
var inst_71562 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71561);
var _ = (function (){var statearr_71576 = state_71567;
(statearr_71576[(4)] = cljs.core.rest((state_71567[(4)])));

return statearr_71576;
})();
var state_71567__$1 = (function (){var statearr_71577 = state_71567;
(statearr_71577[(7)] = inst_71562);

return statearr_71577;
})();
var statearr_71578_71591 = state_71567__$1;
(statearr_71578_71591[(2)] = inst_71547);

(statearr_71578_71591[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71579 = [null,null,null,null,null,null,null,null];
(statearr_71579[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71579[(1)] = (1));

return statearr_71579;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71567){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71567);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71580){var ex__16398__auto__ = e71580;
var statearr_71581_71592 = state_71567;
(statearr_71581_71592[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71567[(4)]))){
var statearr_71582_71593 = state_71567;
(statearr_71582_71593[(1)] = cljs.core.first((state_71567[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71594 = state_71567;
state_71567 = G__71594;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71567){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71583 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71583[(6)] = c__16469__auto__);

return statearr_71583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq71535){
var G__71536 = cljs.core.first(seq71535);
var seq71535__$1 = cljs.core.next(seq71535);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71536,seq71535__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71644 = arguments.length;
var i__4819__auto___71645 = (0);
while(true){
if((i__4819__auto___71645 < len__4818__auto___71644)){
args__4824__auto__.push((arguments[i__4819__auto___71645]));

var G__71646 = (i__4819__auto___71645 + (1));
i__4819__auto___71645 = G__71646;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71627){
var state_val_71628 = (state_71627[(1)]);
if((state_val_71628 === (1))){
var state_71627__$1 = state_71627;
var statearr_71629_71647 = state_71627__$1;
(statearr_71629_71647[(2)] = null);

(statearr_71629_71647[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71628 === (2))){
var _ = (function (){var statearr_71630 = state_71627;
(statearr_71630[(4)] = cljs.core.cons((5),(state_71627[(4)])));

return statearr_71630;
})();
var inst_71603 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71627__$1 = state_71627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71627__$1,(6),inst_71603);
} else {
if((state_val_71628 === (3))){
var inst_71625 = (state_71627[(2)]);
var state_71627__$1 = state_71627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71627__$1,inst_71625);
} else {
if((state_val_71628 === (4))){
var inst_71597 = (state_71627[(2)]);
var state_71627__$1 = state_71627;
var statearr_71632_71648 = state_71627__$1;
(statearr_71632_71648[(2)] = inst_71597);

(statearr_71632_71648[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71628 === (5))){
var _ = (function (){var statearr_71633 = state_71627;
(statearr_71633[(4)] = cljs.core.rest((state_71627[(4)])));

return statearr_71633;
})();
var state_71627__$1 = state_71627;
var ex71631 = (state_71627__$1[(2)]);
var statearr_71634_71649 = state_71627__$1;
(statearr_71634_71649[(5)] = ex71631);


if((ex71631 instanceof Error)){
var statearr_71635_71650 = state_71627__$1;
(statearr_71635_71650[(1)] = (4));

(statearr_71635_71650[(5)] = null);

} else {
throw ex71631;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71628 === (6))){
var inst_71605 = (state_71627[(2)]);
var inst_71606 = fluree.db.util.async.throw_err(inst_71605);
var inst_71607 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_71606);
var inst_71608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71609 = [inst_71606];
var inst_71610 = (new cljs.core.PersistentVector(null,1,(5),inst_71608,inst_71609,null));
var inst_71611 = cljs.core.count(inst_71610);
var inst_71612 = ((9) + inst_71611);
var inst_71613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71614 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71616 = [inst_71606];
var inst_71617 = (new cljs.core.PersistentVector(null,1,(5),inst_71615,inst_71616,null));
var inst_71618 = ["-",inst_71617,inst_71607];
var inst_71619 = cljs.core.PersistentHashMap.fromArrays(inst_71614,inst_71618);
var inst_71620 = [inst_71619,inst_71612];
var inst_71621 = (new cljs.core.PersistentVector(null,2,(5),inst_71613,inst_71620,null));
var inst_71622 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71621);
var _ = (function (){var statearr_71636 = state_71627;
(statearr_71636[(4)] = cljs.core.rest((state_71627[(4)])));

return statearr_71636;
})();
var state_71627__$1 = (function (){var statearr_71637 = state_71627;
(statearr_71637[(7)] = inst_71622);

return statearr_71637;
})();
var statearr_71638_71651 = state_71627__$1;
(statearr_71638_71651[(2)] = inst_71607);

(statearr_71638_71651[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71639 = [null,null,null,null,null,null,null,null];
(statearr_71639[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71639[(1)] = (1));

return statearr_71639;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71627){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71627);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71640){var ex__16398__auto__ = e71640;
var statearr_71641_71652 = state_71627;
(statearr_71641_71652[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71627[(4)]))){
var statearr_71642_71653 = state_71627;
(statearr_71642_71653[(1)] = cljs.core.first((state_71627[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71654 = state_71627;
state_71627 = G__71654;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71627){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71643 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71643[(6)] = c__16469__auto__);

return statearr_71643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq71595){
var G__71596 = cljs.core.first(seq71595);
var seq71595__$1 = cljs.core.next(seq71595);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71596,seq71595__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71704 = arguments.length;
var i__4819__auto___71705 = (0);
while(true){
if((i__4819__auto___71705 < len__4818__auto___71704)){
args__4824__auto__.push((arguments[i__4819__auto___71705]));

var G__71706 = (i__4819__auto___71705 + (1));
i__4819__auto___71705 = G__71706;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71687){
var state_val_71688 = (state_71687[(1)]);
if((state_val_71688 === (1))){
var state_71687__$1 = state_71687;
var statearr_71689_71707 = state_71687__$1;
(statearr_71689_71707[(2)] = null);

(statearr_71689_71707[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71688 === (2))){
var _ = (function (){var statearr_71690 = state_71687;
(statearr_71690[(4)] = cljs.core.cons((5),(state_71687[(4)])));

return statearr_71690;
})();
var inst_71663 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71687__$1 = state_71687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71687__$1,(6),inst_71663);
} else {
if((state_val_71688 === (3))){
var inst_71685 = (state_71687[(2)]);
var state_71687__$1 = state_71687;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71687__$1,inst_71685);
} else {
if((state_val_71688 === (4))){
var inst_71657 = (state_71687[(2)]);
var state_71687__$1 = state_71687;
var statearr_71692_71708 = state_71687__$1;
(statearr_71692_71708[(2)] = inst_71657);

(statearr_71692_71708[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71688 === (5))){
var _ = (function (){var statearr_71693 = state_71687;
(statearr_71693[(4)] = cljs.core.rest((state_71687[(4)])));

return statearr_71693;
})();
var state_71687__$1 = state_71687;
var ex71691 = (state_71687__$1[(2)]);
var statearr_71694_71709 = state_71687__$1;
(statearr_71694_71709[(5)] = ex71691);


if((ex71691 instanceof Error)){
var statearr_71695_71710 = state_71687__$1;
(statearr_71695_71710[(1)] = (4));

(statearr_71695_71710[(5)] = null);

} else {
throw ex71691;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71688 === (6))){
var inst_71665 = (state_71687[(2)]);
var inst_71666 = fluree.db.util.async.throw_err(inst_71665);
var inst_71667 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_71666);
var inst_71668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71669 = [inst_71666];
var inst_71670 = (new cljs.core.PersistentVector(null,1,(5),inst_71668,inst_71669,null));
var inst_71671 = cljs.core.count(inst_71670);
var inst_71672 = ((9) + inst_71671);
var inst_71673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71674 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71676 = [inst_71666];
var inst_71677 = (new cljs.core.PersistentVector(null,1,(5),inst_71675,inst_71676,null));
var inst_71678 = ["*",inst_71677,inst_71667];
var inst_71679 = cljs.core.PersistentHashMap.fromArrays(inst_71674,inst_71678);
var inst_71680 = [inst_71679,inst_71672];
var inst_71681 = (new cljs.core.PersistentVector(null,2,(5),inst_71673,inst_71680,null));
var inst_71682 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71681);
var _ = (function (){var statearr_71696 = state_71687;
(statearr_71696[(4)] = cljs.core.rest((state_71687[(4)])));

return statearr_71696;
})();
var state_71687__$1 = (function (){var statearr_71697 = state_71687;
(statearr_71697[(7)] = inst_71682);

return statearr_71697;
})();
var statearr_71698_71711 = state_71687__$1;
(statearr_71698_71711[(2)] = inst_71667);

(statearr_71698_71711[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71699 = [null,null,null,null,null,null,null,null];
(statearr_71699[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71699[(1)] = (1));

return statearr_71699;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71687){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71687);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71700){var ex__16398__auto__ = e71700;
var statearr_71701_71712 = state_71687;
(statearr_71701_71712[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71687[(4)]))){
var statearr_71702_71713 = state_71687;
(statearr_71702_71713[(1)] = cljs.core.first((state_71687[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71714 = state_71687;
state_71687 = G__71714;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71687){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71703 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71703[(6)] = c__16469__auto__);

return statearr_71703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq71655){
var G__71656 = cljs.core.first(seq71655);
var seq71655__$1 = cljs.core.next(seq71655);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71656,seq71655__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71764 = arguments.length;
var i__4819__auto___71765 = (0);
while(true){
if((i__4819__auto___71765 < len__4818__auto___71764)){
args__4824__auto__.push((arguments[i__4819__auto___71765]));

var G__71766 = (i__4819__auto___71765 + (1));
i__4819__auto___71765 = G__71766;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71747){
var state_val_71748 = (state_71747[(1)]);
if((state_val_71748 === (1))){
var state_71747__$1 = state_71747;
var statearr_71749_71767 = state_71747__$1;
(statearr_71749_71767[(2)] = null);

(statearr_71749_71767[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71748 === (2))){
var _ = (function (){var statearr_71750 = state_71747;
(statearr_71750[(4)] = cljs.core.cons((5),(state_71747[(4)])));

return statearr_71750;
})();
var inst_71723 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71747__$1 = state_71747;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71747__$1,(6),inst_71723);
} else {
if((state_val_71748 === (3))){
var inst_71745 = (state_71747[(2)]);
var state_71747__$1 = state_71747;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71747__$1,inst_71745);
} else {
if((state_val_71748 === (4))){
var inst_71717 = (state_71747[(2)]);
var state_71747__$1 = state_71747;
var statearr_71752_71768 = state_71747__$1;
(statearr_71752_71768[(2)] = inst_71717);

(statearr_71752_71768[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71748 === (5))){
var _ = (function (){var statearr_71753 = state_71747;
(statearr_71753[(4)] = cljs.core.rest((state_71747[(4)])));

return statearr_71753;
})();
var state_71747__$1 = state_71747;
var ex71751 = (state_71747__$1[(2)]);
var statearr_71754_71769 = state_71747__$1;
(statearr_71754_71769[(5)] = ex71751);


if((ex71751 instanceof Error)){
var statearr_71755_71770 = state_71747__$1;
(statearr_71755_71770[(1)] = (4));

(statearr_71755_71770[(5)] = null);

} else {
throw ex71751;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71748 === (6))){
var inst_71725 = (state_71747[(2)]);
var inst_71726 = fluree.db.util.async.throw_err(inst_71725);
var inst_71727 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_71726);
var inst_71728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71729 = [inst_71726];
var inst_71730 = (new cljs.core.PersistentVector(null,1,(5),inst_71728,inst_71729,null));
var inst_71731 = cljs.core.count(inst_71730);
var inst_71732 = ((9) + inst_71731);
var inst_71733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71734 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71736 = [inst_71726];
var inst_71737 = (new cljs.core.PersistentVector(null,1,(5),inst_71735,inst_71736,null));
var inst_71738 = ["/",inst_71737,inst_71727];
var inst_71739 = cljs.core.PersistentHashMap.fromArrays(inst_71734,inst_71738);
var inst_71740 = [inst_71739,inst_71732];
var inst_71741 = (new cljs.core.PersistentVector(null,2,(5),inst_71733,inst_71740,null));
var inst_71742 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71741);
var _ = (function (){var statearr_71756 = state_71747;
(statearr_71756[(4)] = cljs.core.rest((state_71747[(4)])));

return statearr_71756;
})();
var state_71747__$1 = (function (){var statearr_71757 = state_71747;
(statearr_71757[(7)] = inst_71742);

return statearr_71757;
})();
var statearr_71758_71771 = state_71747__$1;
(statearr_71758_71771[(2)] = inst_71727);

(statearr_71758_71771[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71759 = [null,null,null,null,null,null,null,null];
(statearr_71759[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71759[(1)] = (1));

return statearr_71759;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71747){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71747);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71760){var ex__16398__auto__ = e71760;
var statearr_71761_71772 = state_71747;
(statearr_71761_71772[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71747[(4)]))){
var statearr_71762_71773 = state_71747;
(statearr_71762_71773[(1)] = cljs.core.first((state_71747[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71774 = state_71747;
state_71747 = G__71774;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71747){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71747);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71763 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71763[(6)] = c__16469__auto__);

return statearr_71763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq71715){
var G__71716 = cljs.core.first(seq71715);
var seq71715__$1 = cljs.core.next(seq71715);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71716,seq71715__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71812){
var state_val_71813 = (state_71812[(1)]);
if((state_val_71813 === (7))){
var state_71812__$1 = state_71812;
var statearr_71814_71838 = state_71812__$1;
(statearr_71814_71838[(2)] = n);

(statearr_71814_71838[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71813 === (1))){
var state_71812__$1 = state_71812;
var statearr_71815_71839 = state_71812__$1;
(statearr_71815_71839[(2)] = null);

(statearr_71815_71839[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71813 === (4))){
var inst_71775 = (state_71812[(2)]);
var state_71812__$1 = state_71812;
var statearr_71816_71840 = state_71812__$1;
(statearr_71816_71840[(2)] = inst_71775);

(statearr_71816_71840[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71813 === (13))){
var inst_71792 = (state_71812[(2)]);
var inst_71793 = fluree.db.util.async.throw_err(inst_71792);
var state_71812__$1 = state_71812;
var statearr_71817_71841 = state_71812__$1;
(statearr_71817_71841[(2)] = inst_71793);

(statearr_71817_71841[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71813 === (6))){
var state_71812__$1 = state_71812;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71812__$1,(9),n);
} else {
if((state_val_71813 === (3))){
var inst_71810 = (state_71812[(2)]);
var state_71812__$1 = state_71812;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71812__$1,inst_71810);
} else {
if((state_val_71813 === (12))){
var inst_71788 = (state_71812[(7)]);
var inst_71796 = (state_71812[(2)]);
var inst_71797 = fluree.db.dbfunctions.internal.quot(inst_71788,inst_71796);
var inst_71798 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71799 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71801 = [inst_71788,inst_71796];
var inst_71802 = (new cljs.core.PersistentVector(null,2,(5),inst_71800,inst_71801,null));
var inst_71803 = ["quot",inst_71802,inst_71797];
var inst_71804 = cljs.core.PersistentHashMap.fromArrays(inst_71799,inst_71803);
var inst_71805 = [inst_71804,(2)];
var inst_71806 = (new cljs.core.PersistentVector(null,2,(5),inst_71798,inst_71805,null));
var inst_71807 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71806);
var _ = (function (){var statearr_71818 = state_71812;
(statearr_71818[(4)] = cljs.core.rest((state_71812[(4)])));

return statearr_71818;
})();
var state_71812__$1 = (function (){var statearr_71819 = state_71812;
(statearr_71819[(8)] = inst_71807);

return statearr_71819;
})();
var statearr_71820_71842 = state_71812__$1;
(statearr_71820_71842[(2)] = inst_71797);

(statearr_71820_71842[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71813 === (2))){
var _ = (function (){var statearr_71821 = state_71812;
(statearr_71821[(4)] = cljs.core.cons((5),(state_71812[(4)])));

return statearr_71821;
})();
var inst_71781 = fluree.db.util.async.channel_QMARK_(n);
var state_71812__$1 = state_71812;
if(inst_71781){
var statearr_71822_71843 = state_71812__$1;
(statearr_71822_71843[(1)] = (6));

} else {
var statearr_71823_71844 = state_71812__$1;
(statearr_71823_71844[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71813 === (11))){
var state_71812__$1 = state_71812;
var statearr_71825_71845 = state_71812__$1;
(statearr_71825_71845[(2)] = d);

(statearr_71825_71845[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71813 === (9))){
var inst_71784 = (state_71812[(2)]);
var inst_71785 = fluree.db.util.async.throw_err(inst_71784);
var state_71812__$1 = state_71812;
var statearr_71826_71846 = state_71812__$1;
(statearr_71826_71846[(2)] = inst_71785);

(statearr_71826_71846[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71813 === (5))){
var _ = (function (){var statearr_71827 = state_71812;
(statearr_71827[(4)] = cljs.core.rest((state_71812[(4)])));

return statearr_71827;
})();
var state_71812__$1 = state_71812;
var ex71824 = (state_71812__$1[(2)]);
var statearr_71828_71847 = state_71812__$1;
(statearr_71828_71847[(5)] = ex71824);


if((ex71824 instanceof Error)){
var statearr_71829_71848 = state_71812__$1;
(statearr_71829_71848[(1)] = (4));

(statearr_71829_71848[(5)] = null);

} else {
throw ex71824;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71813 === (10))){
var state_71812__$1 = state_71812;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71812__$1,(13),d);
} else {
if((state_val_71813 === (8))){
var inst_71788 = (state_71812[(2)]);
var inst_71789 = fluree.db.util.async.channel_QMARK_(d);
var state_71812__$1 = (function (){var statearr_71830 = state_71812;
(statearr_71830[(7)] = inst_71788);

return statearr_71830;
})();
if(inst_71789){
var statearr_71831_71849 = state_71812__$1;
(statearr_71831_71849[(1)] = (10));

} else {
var statearr_71832_71850 = state_71812__$1;
(statearr_71832_71850[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto____0 = (function (){
var statearr_71833 = [null,null,null,null,null,null,null,null,null];
(statearr_71833[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto__);

(statearr_71833[(1)] = (1));

return statearr_71833;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto____1 = (function (state_71812){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71812);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71834){var ex__16398__auto__ = e71834;
var statearr_71835_71851 = state_71812;
(statearr_71835_71851[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71812[(4)]))){
var statearr_71836_71852 = state_71812;
(statearr_71836_71852[(1)] = cljs.core.first((state_71812[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71853 = state_71812;
state_71812 = G__71853;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto__ = function(state_71812){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto____1.call(this,state_71812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71837 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71837[(6)] = c__16469__auto__);

return statearr_71837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71891){
var state_val_71892 = (state_71891[(1)]);
if((state_val_71892 === (7))){
var state_71891__$1 = state_71891;
var statearr_71893_71917 = state_71891__$1;
(statearr_71893_71917[(2)] = n);

(statearr_71893_71917[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71892 === (1))){
var state_71891__$1 = state_71891;
var statearr_71894_71918 = state_71891__$1;
(statearr_71894_71918[(2)] = null);

(statearr_71894_71918[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71892 === (4))){
var inst_71854 = (state_71891[(2)]);
var state_71891__$1 = state_71891;
var statearr_71895_71919 = state_71891__$1;
(statearr_71895_71919[(2)] = inst_71854);

(statearr_71895_71919[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71892 === (13))){
var inst_71871 = (state_71891[(2)]);
var inst_71872 = fluree.db.util.async.throw_err(inst_71871);
var state_71891__$1 = state_71891;
var statearr_71896_71920 = state_71891__$1;
(statearr_71896_71920[(2)] = inst_71872);

(statearr_71896_71920[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71892 === (6))){
var state_71891__$1 = state_71891;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71891__$1,(9),n);
} else {
if((state_val_71892 === (3))){
var inst_71889 = (state_71891[(2)]);
var state_71891__$1 = state_71891;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71891__$1,inst_71889);
} else {
if((state_val_71892 === (12))){
var inst_71867 = (state_71891[(7)]);
var inst_71875 = (state_71891[(2)]);
var inst_71876 = fluree.db.dbfunctions.internal.mod(inst_71867,inst_71875);
var inst_71877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71878 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71880 = [inst_71867,inst_71875];
var inst_71881 = (new cljs.core.PersistentVector(null,2,(5),inst_71879,inst_71880,null));
var inst_71882 = ["mod",inst_71881,inst_71876];
var inst_71883 = cljs.core.PersistentHashMap.fromArrays(inst_71878,inst_71882);
var inst_71884 = [inst_71883,(2)];
var inst_71885 = (new cljs.core.PersistentVector(null,2,(5),inst_71877,inst_71884,null));
var inst_71886 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71885);
var _ = (function (){var statearr_71897 = state_71891;
(statearr_71897[(4)] = cljs.core.rest((state_71891[(4)])));

return statearr_71897;
})();
var state_71891__$1 = (function (){var statearr_71898 = state_71891;
(statearr_71898[(8)] = inst_71886);

return statearr_71898;
})();
var statearr_71899_71921 = state_71891__$1;
(statearr_71899_71921[(2)] = inst_71876);

(statearr_71899_71921[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71892 === (2))){
var _ = (function (){var statearr_71900 = state_71891;
(statearr_71900[(4)] = cljs.core.cons((5),(state_71891[(4)])));

return statearr_71900;
})();
var inst_71860 = fluree.db.util.async.channel_QMARK_(n);
var state_71891__$1 = state_71891;
if(inst_71860){
var statearr_71901_71922 = state_71891__$1;
(statearr_71901_71922[(1)] = (6));

} else {
var statearr_71902_71923 = state_71891__$1;
(statearr_71902_71923[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71892 === (11))){
var state_71891__$1 = state_71891;
var statearr_71904_71924 = state_71891__$1;
(statearr_71904_71924[(2)] = d);

(statearr_71904_71924[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71892 === (9))){
var inst_71863 = (state_71891[(2)]);
var inst_71864 = fluree.db.util.async.throw_err(inst_71863);
var state_71891__$1 = state_71891;
var statearr_71905_71925 = state_71891__$1;
(statearr_71905_71925[(2)] = inst_71864);

(statearr_71905_71925[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71892 === (5))){
var _ = (function (){var statearr_71906 = state_71891;
(statearr_71906[(4)] = cljs.core.rest((state_71891[(4)])));

return statearr_71906;
})();
var state_71891__$1 = state_71891;
var ex71903 = (state_71891__$1[(2)]);
var statearr_71907_71926 = state_71891__$1;
(statearr_71907_71926[(5)] = ex71903);


if((ex71903 instanceof Error)){
var statearr_71908_71927 = state_71891__$1;
(statearr_71908_71927[(1)] = (4));

(statearr_71908_71927[(5)] = null);

} else {
throw ex71903;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71892 === (10))){
var state_71891__$1 = state_71891;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71891__$1,(13),d);
} else {
if((state_val_71892 === (8))){
var inst_71867 = (state_71891[(2)]);
var inst_71868 = fluree.db.util.async.channel_QMARK_(d);
var state_71891__$1 = (function (){var statearr_71909 = state_71891;
(statearr_71909[(7)] = inst_71867);

return statearr_71909;
})();
if(inst_71868){
var statearr_71910_71928 = state_71891__$1;
(statearr_71910_71928[(1)] = (10));

} else {
var statearr_71911_71929 = state_71891__$1;
(statearr_71911_71929[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto____0 = (function (){
var statearr_71912 = [null,null,null,null,null,null,null,null,null];
(statearr_71912[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto__);

(statearr_71912[(1)] = (1));

return statearr_71912;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto____1 = (function (state_71891){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71891);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71913){var ex__16398__auto__ = e71913;
var statearr_71914_71930 = state_71891;
(statearr_71914_71930[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71891[(4)]))){
var statearr_71915_71931 = state_71891;
(statearr_71915_71931[(1)] = cljs.core.first((state_71891[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71932 = state_71891;
state_71891 = G__71932;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto__ = function(state_71891){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto____1.call(this,state_71891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71916 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71916[(6)] = c__16469__auto__);

return statearr_71916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71970){
var state_val_71971 = (state_71970[(1)]);
if((state_val_71971 === (7))){
var state_71970__$1 = state_71970;
var statearr_71972_71996 = state_71970__$1;
(statearr_71972_71996[(2)] = n);

(statearr_71972_71996[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71971 === (1))){
var state_71970__$1 = state_71970;
var statearr_71973_71997 = state_71970__$1;
(statearr_71973_71997[(2)] = null);

(statearr_71973_71997[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71971 === (4))){
var inst_71933 = (state_71970[(2)]);
var state_71970__$1 = state_71970;
var statearr_71974_71998 = state_71970__$1;
(statearr_71974_71998[(2)] = inst_71933);

(statearr_71974_71998[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71971 === (13))){
var inst_71950 = (state_71970[(2)]);
var inst_71951 = fluree.db.util.async.throw_err(inst_71950);
var state_71970__$1 = state_71970;
var statearr_71975_71999 = state_71970__$1;
(statearr_71975_71999[(2)] = inst_71951);

(statearr_71975_71999[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71971 === (6))){
var state_71970__$1 = state_71970;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71970__$1,(9),n);
} else {
if((state_val_71971 === (3))){
var inst_71968 = (state_71970[(2)]);
var state_71970__$1 = state_71970;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71970__$1,inst_71968);
} else {
if((state_val_71971 === (12))){
var inst_71946 = (state_71970[(7)]);
var inst_71954 = (state_71970[(2)]);
var inst_71955 = fluree.db.dbfunctions.internal.rem(inst_71946,inst_71954);
var inst_71956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71957 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71959 = [inst_71946,inst_71954];
var inst_71960 = (new cljs.core.PersistentVector(null,2,(5),inst_71958,inst_71959,null));
var inst_71961 = ["rem",inst_71960,inst_71955];
var inst_71962 = cljs.core.PersistentHashMap.fromArrays(inst_71957,inst_71961);
var inst_71963 = [inst_71962,(2)];
var inst_71964 = (new cljs.core.PersistentVector(null,2,(5),inst_71956,inst_71963,null));
var inst_71965 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71964);
var _ = (function (){var statearr_71976 = state_71970;
(statearr_71976[(4)] = cljs.core.rest((state_71970[(4)])));

return statearr_71976;
})();
var state_71970__$1 = (function (){var statearr_71977 = state_71970;
(statearr_71977[(8)] = inst_71965);

return statearr_71977;
})();
var statearr_71978_72000 = state_71970__$1;
(statearr_71978_72000[(2)] = inst_71955);

(statearr_71978_72000[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71971 === (2))){
var _ = (function (){var statearr_71979 = state_71970;
(statearr_71979[(4)] = cljs.core.cons((5),(state_71970[(4)])));

return statearr_71979;
})();
var inst_71939 = fluree.db.util.async.channel_QMARK_(n);
var state_71970__$1 = state_71970;
if(inst_71939){
var statearr_71980_72001 = state_71970__$1;
(statearr_71980_72001[(1)] = (6));

} else {
var statearr_71981_72002 = state_71970__$1;
(statearr_71981_72002[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71971 === (11))){
var state_71970__$1 = state_71970;
var statearr_71983_72003 = state_71970__$1;
(statearr_71983_72003[(2)] = d);

(statearr_71983_72003[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71971 === (9))){
var inst_71942 = (state_71970[(2)]);
var inst_71943 = fluree.db.util.async.throw_err(inst_71942);
var state_71970__$1 = state_71970;
var statearr_71984_72004 = state_71970__$1;
(statearr_71984_72004[(2)] = inst_71943);

(statearr_71984_72004[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71971 === (5))){
var _ = (function (){var statearr_71985 = state_71970;
(statearr_71985[(4)] = cljs.core.rest((state_71970[(4)])));

return statearr_71985;
})();
var state_71970__$1 = state_71970;
var ex71982 = (state_71970__$1[(2)]);
var statearr_71986_72005 = state_71970__$1;
(statearr_71986_72005[(5)] = ex71982);


if((ex71982 instanceof Error)){
var statearr_71987_72006 = state_71970__$1;
(statearr_71987_72006[(1)] = (4));

(statearr_71987_72006[(5)] = null);

} else {
throw ex71982;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71971 === (10))){
var state_71970__$1 = state_71970;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71970__$1,(13),d);
} else {
if((state_val_71971 === (8))){
var inst_71946 = (state_71970[(2)]);
var inst_71947 = fluree.db.util.async.channel_QMARK_(d);
var state_71970__$1 = (function (){var statearr_71988 = state_71970;
(statearr_71988[(7)] = inst_71946);

return statearr_71988;
})();
if(inst_71947){
var statearr_71989_72007 = state_71970__$1;
(statearr_71989_72007[(1)] = (10));

} else {
var statearr_71990_72008 = state_71970__$1;
(statearr_71990_72008[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto____0 = (function (){
var statearr_71991 = [null,null,null,null,null,null,null,null,null];
(statearr_71991[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto__);

(statearr_71991[(1)] = (1));

return statearr_71991;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto____1 = (function (state_71970){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71970);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71992){var ex__16398__auto__ = e71992;
var statearr_71993_72009 = state_71970;
(statearr_71993_72009[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71970[(4)]))){
var statearr_71994_72010 = state_71970;
(statearr_71994_72010[(1)] = cljs.core.first((state_71970[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72011 = state_71970;
state_71970 = G__72011;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto__ = function(state_71970){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto____1.call(this,state_71970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71995 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71995[(6)] = c__16469__auto__);

return statearr_71995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72038){
var state_val_72039 = (state_72038[(1)]);
if((state_val_72039 === (7))){
var state_72038__$1 = state_72038;
var statearr_72040_72059 = state_72038__$1;
(statearr_72040_72059[(2)] = x);

(statearr_72040_72059[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72039 === (1))){
var state_72038__$1 = state_72038;
var statearr_72041_72060 = state_72038__$1;
(statearr_72041_72060[(2)] = null);

(statearr_72041_72060[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72039 === (4))){
var inst_72012 = (state_72038[(2)]);
var state_72038__$1 = state_72038;
var statearr_72042_72061 = state_72038__$1;
(statearr_72042_72061[(2)] = inst_72012);

(statearr_72042_72061[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72039 === (6))){
var state_72038__$1 = state_72038;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72038__$1,(9),x);
} else {
if((state_val_72039 === (3))){
var inst_72036 = (state_72038[(2)]);
var state_72038__$1 = state_72038;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72038__$1,inst_72036);
} else {
if((state_val_72039 === (2))){
var _ = (function (){var statearr_72044 = state_72038;
(statearr_72044[(4)] = cljs.core.cons((5),(state_72038[(4)])));

return statearr_72044;
})();
var inst_72018 = fluree.db.util.async.channel_QMARK_(x);
var state_72038__$1 = state_72038;
if(inst_72018){
var statearr_72045_72062 = state_72038__$1;
(statearr_72045_72062[(1)] = (6));

} else {
var statearr_72046_72063 = state_72038__$1;
(statearr_72046_72063[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72039 === (9))){
var inst_72021 = (state_72038[(2)]);
var inst_72022 = fluree.db.util.async.throw_err(inst_72021);
var state_72038__$1 = state_72038;
var statearr_72047_72064 = state_72038__$1;
(statearr_72047_72064[(2)] = inst_72022);

(statearr_72047_72064[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72039 === (5))){
var _ = (function (){var statearr_72048 = state_72038;
(statearr_72048[(4)] = cljs.core.rest((state_72038[(4)])));

return statearr_72048;
})();
var state_72038__$1 = state_72038;
var ex72043 = (state_72038__$1[(2)]);
var statearr_72049_72065 = state_72038__$1;
(statearr_72049_72065[(5)] = ex72043);


if((ex72043 instanceof Error)){
var statearr_72050_72066 = state_72038__$1;
(statearr_72050_72066[(1)] = (4));

(statearr_72050_72066[(5)] = null);

} else {
throw ex72043;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72039 === (8))){
var inst_72025 = (state_72038[(2)]);
var inst_72026 = fluree.db.dbfunctions.internal.boolean$(inst_72025);
var inst_72027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72028 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72029 = ["boolean",inst_72025,inst_72026];
var inst_72030 = cljs.core.PersistentHashMap.fromArrays(inst_72028,inst_72029);
var inst_72031 = [inst_72030,(10)];
var inst_72032 = (new cljs.core.PersistentVector(null,2,(5),inst_72027,inst_72031,null));
var inst_72033 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72032);
var _ = (function (){var statearr_72051 = state_72038;
(statearr_72051[(4)] = cljs.core.rest((state_72038[(4)])));

return statearr_72051;
})();
var state_72038__$1 = (function (){var statearr_72052 = state_72038;
(statearr_72052[(7)] = inst_72033);

return statearr_72052;
})();
var statearr_72053_72067 = state_72038__$1;
(statearr_72053_72067[(2)] = inst_72026);

(statearr_72053_72067[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto____0 = (function (){
var statearr_72054 = [null,null,null,null,null,null,null,null];
(statearr_72054[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto__);

(statearr_72054[(1)] = (1));

return statearr_72054;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto____1 = (function (state_72038){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72038);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72055){var ex__16398__auto__ = e72055;
var statearr_72056_72068 = state_72038;
(statearr_72056_72068[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72038[(4)]))){
var statearr_72057_72069 = state_72038;
(statearr_72057_72069[(1)] = cljs.core.first((state_72038[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72070 = state_72038;
state_72038 = G__72070;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto__ = function(state_72038){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto____1.call(this,state_72038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72058 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72058[(6)] = c__16469__auto__);

return statearr_72058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72108){
var state_val_72109 = (state_72108[(1)]);
if((state_val_72109 === (7))){
var state_72108__$1 = state_72108;
var statearr_72110_72134 = state_72108__$1;
(statearr_72110_72134[(2)] = pattern);

(statearr_72110_72134[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72109 === (1))){
var state_72108__$1 = state_72108;
var statearr_72111_72135 = state_72108__$1;
(statearr_72111_72135[(2)] = null);

(statearr_72111_72135[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72109 === (4))){
var inst_72071 = (state_72108[(2)]);
var state_72108__$1 = state_72108;
var statearr_72112_72136 = state_72108__$1;
(statearr_72112_72136[(2)] = inst_72071);

(statearr_72112_72136[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72109 === (13))){
var inst_72088 = (state_72108[(2)]);
var inst_72089 = fluree.db.util.async.throw_err(inst_72088);
var state_72108__$1 = state_72108;
var statearr_72113_72137 = state_72108__$1;
(statearr_72113_72137[(2)] = inst_72089);

(statearr_72113_72137[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72109 === (6))){
var state_72108__$1 = state_72108;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72108__$1,(9),pattern);
} else {
if((state_val_72109 === (3))){
var inst_72106 = (state_72108[(2)]);
var state_72108__$1 = state_72108;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72108__$1,inst_72106);
} else {
if((state_val_72109 === (12))){
var inst_72084 = (state_72108[(7)]);
var inst_72092 = (state_72108[(2)]);
var inst_72093 = fluree.db.dbfunctions.internal.re_find(inst_72084,inst_72092);
var inst_72094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72095 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72097 = [inst_72084,inst_72092];
var inst_72098 = (new cljs.core.PersistentVector(null,2,(5),inst_72096,inst_72097,null));
var inst_72099 = ["re-find",inst_72098,inst_72093];
var inst_72100 = cljs.core.PersistentHashMap.fromArrays(inst_72095,inst_72099);
var inst_72101 = [inst_72100,(10)];
var inst_72102 = (new cljs.core.PersistentVector(null,2,(5),inst_72094,inst_72101,null));
var inst_72103 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72102);
var _ = (function (){var statearr_72114 = state_72108;
(statearr_72114[(4)] = cljs.core.rest((state_72108[(4)])));

return statearr_72114;
})();
var state_72108__$1 = (function (){var statearr_72115 = state_72108;
(statearr_72115[(8)] = inst_72103);

return statearr_72115;
})();
var statearr_72116_72138 = state_72108__$1;
(statearr_72116_72138[(2)] = inst_72093);

(statearr_72116_72138[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72109 === (2))){
var _ = (function (){var statearr_72117 = state_72108;
(statearr_72117[(4)] = cljs.core.cons((5),(state_72108[(4)])));

return statearr_72117;
})();
var inst_72077 = fluree.db.util.async.channel_QMARK_(pattern);
var state_72108__$1 = state_72108;
if(inst_72077){
var statearr_72118_72139 = state_72108__$1;
(statearr_72118_72139[(1)] = (6));

} else {
var statearr_72119_72140 = state_72108__$1;
(statearr_72119_72140[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72109 === (11))){
var state_72108__$1 = state_72108;
var statearr_72121_72141 = state_72108__$1;
(statearr_72121_72141[(2)] = string);

(statearr_72121_72141[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72109 === (9))){
var inst_72080 = (state_72108[(2)]);
var inst_72081 = fluree.db.util.async.throw_err(inst_72080);
var state_72108__$1 = state_72108;
var statearr_72122_72142 = state_72108__$1;
(statearr_72122_72142[(2)] = inst_72081);

(statearr_72122_72142[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72109 === (5))){
var _ = (function (){var statearr_72123 = state_72108;
(statearr_72123[(4)] = cljs.core.rest((state_72108[(4)])));

return statearr_72123;
})();
var state_72108__$1 = state_72108;
var ex72120 = (state_72108__$1[(2)]);
var statearr_72124_72143 = state_72108__$1;
(statearr_72124_72143[(5)] = ex72120);


if((ex72120 instanceof Error)){
var statearr_72125_72144 = state_72108__$1;
(statearr_72125_72144[(1)] = (4));

(statearr_72125_72144[(5)] = null);

} else {
throw ex72120;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72109 === (10))){
var state_72108__$1 = state_72108;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72108__$1,(13),string);
} else {
if((state_val_72109 === (8))){
var inst_72084 = (state_72108[(2)]);
var inst_72085 = fluree.db.util.async.channel_QMARK_(string);
var state_72108__$1 = (function (){var statearr_72126 = state_72108;
(statearr_72126[(7)] = inst_72084);

return statearr_72126;
})();
if(inst_72085){
var statearr_72127_72145 = state_72108__$1;
(statearr_72127_72145[(1)] = (10));

} else {
var statearr_72128_72146 = state_72108__$1;
(statearr_72128_72146[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto____0 = (function (){
var statearr_72129 = [null,null,null,null,null,null,null,null,null];
(statearr_72129[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto__);

(statearr_72129[(1)] = (1));

return statearr_72129;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto____1 = (function (state_72108){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72108);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72130){var ex__16398__auto__ = e72130;
var statearr_72131_72147 = state_72108;
(statearr_72131_72147[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72108[(4)]))){
var statearr_72132_72148 = state_72108;
(statearr_72132_72148[(1)] = cljs.core.first((state_72108[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72149 = state_72108;
state_72108 = G__72149;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto__ = function(state_72108){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto____1.call(this,state_72108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72133 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72133[(6)] = c__16469__auto__);

return statearr_72133;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72176){
var state_val_72177 = (state_72176[(1)]);
if((state_val_72177 === (7))){
var state_72176__$1 = state_72176;
var statearr_72178_72197 = state_72176__$1;
(statearr_72178_72197[(2)] = email);

(statearr_72178_72197[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (1))){
var state_72176__$1 = state_72176;
var statearr_72179_72198 = state_72176__$1;
(statearr_72179_72198[(2)] = null);

(statearr_72179_72198[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (4))){
var inst_72150 = (state_72176[(2)]);
var state_72176__$1 = state_72176;
var statearr_72180_72199 = state_72176__$1;
(statearr_72180_72199[(2)] = inst_72150);

(statearr_72180_72199[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (6))){
var state_72176__$1 = state_72176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72176__$1,(9),email);
} else {
if((state_val_72177 === (3))){
var inst_72174 = (state_72176[(2)]);
var state_72176__$1 = state_72176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72176__$1,inst_72174);
} else {
if((state_val_72177 === (2))){
var _ = (function (){var statearr_72182 = state_72176;
(statearr_72182[(4)] = cljs.core.cons((5),(state_72176[(4)])));

return statearr_72182;
})();
var inst_72156 = fluree.db.util.async.channel_QMARK_(email);
var state_72176__$1 = state_72176;
if(inst_72156){
var statearr_72183_72200 = state_72176__$1;
(statearr_72183_72200[(1)] = (6));

} else {
var statearr_72184_72201 = state_72176__$1;
(statearr_72184_72201[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (9))){
var inst_72159 = (state_72176[(2)]);
var inst_72160 = fluree.db.util.async.throw_err(inst_72159);
var state_72176__$1 = state_72176;
var statearr_72185_72202 = state_72176__$1;
(statearr_72185_72202[(2)] = inst_72160);

(statearr_72185_72202[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (5))){
var _ = (function (){var statearr_72186 = state_72176;
(statearr_72186[(4)] = cljs.core.rest((state_72176[(4)])));

return statearr_72186;
})();
var state_72176__$1 = state_72176;
var ex72181 = (state_72176__$1[(2)]);
var statearr_72187_72203 = state_72176__$1;
(statearr_72187_72203[(5)] = ex72181);


if((ex72181 instanceof Error)){
var statearr_72188_72204 = state_72176__$1;
(statearr_72188_72204[(1)] = (4));

(statearr_72188_72204[(5)] = null);

} else {
throw ex72181;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72177 === (8))){
var inst_72163 = (state_72176[(2)]);
var inst_72164 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_72163);
var inst_72165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72166 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72167 = ["re-find",inst_72163,inst_72164];
var inst_72168 = cljs.core.PersistentHashMap.fromArrays(inst_72166,inst_72167);
var inst_72169 = [inst_72168,(10)];
var inst_72170 = (new cljs.core.PersistentVector(null,2,(5),inst_72165,inst_72169,null));
var inst_72171 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72170);
var _ = (function (){var statearr_72189 = state_72176;
(statearr_72189[(4)] = cljs.core.rest((state_72176[(4)])));

return statearr_72189;
})();
var state_72176__$1 = (function (){var statearr_72190 = state_72176;
(statearr_72190[(7)] = inst_72171);

return statearr_72190;
})();
var statearr_72191_72205 = state_72176__$1;
(statearr_72191_72205[(2)] = inst_72164);

(statearr_72191_72205[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_72192 = [null,null,null,null,null,null,null,null];
(statearr_72192[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto__);

(statearr_72192[(1)] = (1));

return statearr_72192;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto____1 = (function (state_72176){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72176);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72193){var ex__16398__auto__ = e72193;
var statearr_72194_72206 = state_72176;
(statearr_72194_72206[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72176[(4)]))){
var statearr_72195_72207 = state_72176;
(statearr_72195_72207[(1)] = cljs.core.first((state_72176[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72208 = state_72176;
state_72176 = G__72208;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto__ = function(state_72176){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto____1.call(this,state_72176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72196 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72196[(6)] = c__16469__auto__);

return statearr_72196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72255){
var state_val_72256 = (state_72255[(1)]);
if((state_val_72256 === (7))){
var inst_72225 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_72255__$1 = state_72255;
if(cljs.core.truth_(inst_72225)){
var statearr_72257_72284 = state_72255__$1;
(statearr_72257_72284[(1)] = (9));

} else {
var statearr_72258_72285 = state_72255__$1;
(statearr_72258_72285[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72256 === (1))){
var state_72255__$1 = state_72255;
var statearr_72259_72286 = state_72255__$1;
(statearr_72259_72286[(2)] = null);

(statearr_72259_72286[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72256 === (4))){
var inst_72209 = (state_72255[(2)]);
var state_72255__$1 = state_72255;
var statearr_72260_72287 = state_72255__$1;
(statearr_72260_72287[(2)] = inst_72209);

(statearr_72260_72287[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72256 === (15))){
var inst_72236 = (state_72255[(2)]);
var state_72255__$1 = state_72255;
var statearr_72261_72288 = state_72255__$1;
(statearr_72261_72288[(2)] = inst_72236);

(statearr_72261_72288[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72256 === (13))){
var inst_72233 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_72255__$1 = state_72255;
var statearr_72262_72289 = state_72255__$1;
(statearr_72262_72289[(2)] = inst_72233);

(statearr_72262_72289[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72256 === (6))){
var inst_72220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72221 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_72222 = [inst_72221,(0)];
var inst_72223 = (new cljs.core.PersistentVector(null,2,(5),inst_72220,inst_72222,null));
var state_72255__$1 = state_72255;
var statearr_72263_72290 = state_72255__$1;
(statearr_72263_72290[(2)] = inst_72223);

(statearr_72263_72290[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72256 === (3))){
var inst_72253 = (state_72255[(2)]);
var state_72255__$1 = state_72255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72255__$1,inst_72253);
} else {
if((state_val_72256 === (12))){
var inst_72229 = (state_72255[(2)]);
var inst_72230 = fluree.db.util.async.throw_err(inst_72229);
var state_72255__$1 = state_72255;
var statearr_72264_72291 = state_72255__$1;
(statearr_72264_72291[(2)] = inst_72230);

(statearr_72264_72291[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72256 === (2))){
var _ = (function (){var statearr_72265 = state_72255;
(statearr_72265[(4)] = cljs.core.cons((5),(state_72255[(4)])));

return statearr_72265;
})();
var inst_72218 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_72255__$1 = state_72255;
if(cljs.core.truth_(inst_72218)){
var statearr_72266_72292 = state_72255__$1;
(statearr_72266_72292[(1)] = (6));

} else {
var statearr_72267_72293 = state_72255__$1;
(statearr_72267_72293[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72256 === (11))){
var inst_72238 = (state_72255[(2)]);
var state_72255__$1 = state_72255;
var statearr_72269_72294 = state_72255__$1;
(statearr_72269_72294[(2)] = inst_72238);

(statearr_72269_72294[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72256 === (9))){
var inst_72227 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_72255__$1 = state_72255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72255__$1,(12),inst_72227);
} else {
if((state_val_72256 === (5))){
var _ = (function (){var statearr_72270 = state_72255;
(statearr_72270[(4)] = cljs.core.rest((state_72255[(4)])));

return statearr_72270;
})();
var state_72255__$1 = state_72255;
var ex72268 = (state_72255__$1[(2)]);
var statearr_72271_72295 = state_72255__$1;
(statearr_72271_72295[(5)] = ex72268);


if((ex72268 instanceof Error)){
var statearr_72272_72296 = state_72255__$1;
(statearr_72272_72296[(1)] = (4));

(statearr_72272_72296[(5)] = null);

} else {
throw ex72268;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72256 === (14))){
var state_72255__$1 = state_72255;
var statearr_72273_72297 = state_72255__$1;
(statearr_72273_72297[(2)] = null);

(statearr_72273_72297[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72256 === (10))){
var state_72255__$1 = state_72255;
var statearr_72274_72298 = state_72255__$1;
(statearr_72274_72298[(1)] = (13));



return cljs.core.cst$kw$recur;
} else {
if((state_val_72256 === (8))){
var inst_72240 = (state_72255[(2)]);
var inst_72241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72240,(0),null);
var inst_72242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72240,(1),null);
var inst_72243 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72244 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72245 = ["?user_id","?ctx",inst_72241];
var inst_72246 = cljs.core.PersistentHashMap.fromArrays(inst_72244,inst_72245);
var inst_72247 = ((10) + inst_72242);
var inst_72248 = [inst_72246,inst_72247];
var inst_72249 = (new cljs.core.PersistentVector(null,2,(5),inst_72243,inst_72248,null));
var inst_72250 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72249);
var _ = (function (){var statearr_72276 = state_72255;
(statearr_72276[(4)] = cljs.core.rest((state_72255[(4)])));

return statearr_72276;
})();
var state_72255__$1 = (function (){var statearr_72277 = state_72255;
(statearr_72277[(7)] = inst_72250);

return statearr_72277;
})();
var statearr_72278_72299 = state_72255__$1;
(statearr_72278_72299[(2)] = inst_72241);

(statearr_72278_72299[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto____0 = (function (){
var statearr_72279 = [null,null,null,null,null,null,null,null];
(statearr_72279[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto__);

(statearr_72279[(1)] = (1));

return statearr_72279;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto____1 = (function (state_72255){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72255);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72280){var ex__16398__auto__ = e72280;
var statearr_72281_72300 = state_72255;
(statearr_72281_72300[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72255[(4)]))){
var statearr_72282_72301 = state_72255;
(statearr_72282_72301[(1)] = cljs.core.first((state_72255[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72302 = state_72255;
state_72255 = G__72302;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto__ = function(state_72255){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto____1.call(this,state_72255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72283 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72283[(6)] = c__16469__auto__);

return statearr_72283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72330){
var state_val_72331 = (state_72330[(1)]);
if((state_val_72331 === (7))){
var inst_72323 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_72330__$1 = state_72330;
var statearr_72332_72351 = state_72330__$1;
(statearr_72332_72351[(2)] = inst_72323);

(statearr_72332_72351[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72331 === (1))){
var state_72330__$1 = state_72330;
var statearr_72333_72352 = state_72330__$1;
(statearr_72333_72352[(2)] = null);

(statearr_72333_72352[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72331 === (4))){
var inst_72303 = (state_72330[(2)]);
var state_72330__$1 = state_72330;
var statearr_72334_72353 = state_72330__$1;
(statearr_72334_72353[(2)] = inst_72303);

(statearr_72334_72353[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72331 === (6))){
var inst_72311 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_72330__$1 = state_72330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72330__$1,(9),inst_72311);
} else {
if((state_val_72331 === (3))){
var inst_72328 = (state_72330[(2)]);
var state_72330__$1 = state_72330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72330__$1,inst_72328);
} else {
if((state_val_72331 === (2))){
var _ = (function (){var statearr_72336 = state_72330;
(statearr_72336[(4)] = cljs.core.cons((5),(state_72330[(4)])));

return statearr_72336;
})();
var inst_72309 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_72330__$1 = state_72330;
if(cljs.core.truth_(inst_72309)){
var statearr_72337_72354 = state_72330__$1;
(statearr_72337_72354[(1)] = (6));

} else {
var statearr_72338_72355 = state_72330__$1;
(statearr_72338_72355[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72331 === (9))){
var inst_72313 = (state_72330[(2)]);
var inst_72314 = fluree.db.util.async.throw_err(inst_72313);
var inst_72315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72316 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72317 = ["?auth_id","?ctx",inst_72314];
var inst_72318 = cljs.core.PersistentHashMap.fromArrays(inst_72316,inst_72317);
var inst_72319 = [inst_72318,(10)];
var inst_72320 = (new cljs.core.PersistentVector(null,2,(5),inst_72315,inst_72319,null));
var inst_72321 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72320);
var state_72330__$1 = (function (){var statearr_72339 = state_72330;
(statearr_72339[(7)] = inst_72321);

return statearr_72339;
})();
var statearr_72340_72356 = state_72330__$1;
(statearr_72340_72356[(2)] = inst_72314);

(statearr_72340_72356[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72331 === (5))){
var _ = (function (){var statearr_72341 = state_72330;
(statearr_72341[(4)] = cljs.core.rest((state_72330[(4)])));

return statearr_72341;
})();
var state_72330__$1 = state_72330;
var ex72335 = (state_72330__$1[(2)]);
var statearr_72342_72357 = state_72330__$1;
(statearr_72342_72357[(5)] = ex72335);


if((ex72335 instanceof Error)){
var statearr_72343_72358 = state_72330__$1;
(statearr_72343_72358[(1)] = (4));

(statearr_72343_72358[(5)] = null);

} else {
throw ex72335;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72331 === (8))){
var inst_72325 = (state_72330[(2)]);
var _ = (function (){var statearr_72344 = state_72330;
(statearr_72344[(4)] = cljs.core.rest((state_72330[(4)])));

return statearr_72344;
})();
var state_72330__$1 = state_72330;
var statearr_72345_72359 = state_72330__$1;
(statearr_72345_72359[(2)] = inst_72325);

(statearr_72345_72359[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto____0 = (function (){
var statearr_72346 = [null,null,null,null,null,null,null,null];
(statearr_72346[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto__);

(statearr_72346[(1)] = (1));

return statearr_72346;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto____1 = (function (state_72330){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72330);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72347){var ex__16398__auto__ = e72347;
var statearr_72348_72360 = state_72330;
(statearr_72348_72360[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72330[(4)]))){
var statearr_72349_72361 = state_72330;
(statearr_72349_72361[(1)] = cljs.core.first((state_72330[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72362 = state_72330;
state_72330 = G__72362;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto__ = function(state_72330){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto____1.call(this,state_72330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72350 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72350[(6)] = c__16469__auto__);

return statearr_72350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__72364 = arguments.length;
switch (G__72364) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72406){
var state_val_72407 = (state_72406[(1)]);
if((state_val_72407 === (7))){
var state_72406__$1 = state_72406;
var statearr_72408_72438 = state_72406__$1;
(statearr_72408_72438[(2)] = seed);

(statearr_72408_72438[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (1))){
var state_72406__$1 = state_72406;
var statearr_72409_72439 = state_72406__$1;
(statearr_72409_72439[(2)] = null);

(statearr_72409_72439[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (4))){
var inst_72365 = (state_72406[(2)]);
var state_72406__$1 = state_72406;
var statearr_72410_72440 = state_72406__$1;
(statearr_72410_72440[(2)] = inst_72365);

(statearr_72410_72440[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (15))){
var state_72406__$1 = state_72406;
var statearr_72411_72441 = state_72406__$1;
(statearr_72411_72441[(2)] = (10));

(statearr_72411_72441[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (13))){
var inst_72382 = (state_72406[(2)]);
var inst_72383 = fluree.db.util.async.throw_err(inst_72382);
var state_72406__$1 = state_72406;
var statearr_72412_72442 = state_72406__$1;
(statearr_72412_72442[(2)] = inst_72383);

(statearr_72412_72442[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (6))){
var state_72406__$1 = state_72406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72406__$1,(9),seed);
} else {
if((state_val_72407 === (3))){
var inst_72404 = (state_72406[(2)]);
var state_72406__$1 = state_72406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72406__$1,inst_72404);
} else {
if((state_val_72407 === (12))){
var inst_72386 = (state_72406[(7)]);
var inst_72386__$1 = (state_72406[(2)]);
var state_72406__$1 = (function (){var statearr_72413 = state_72406;
(statearr_72413[(7)] = inst_72386__$1);

return statearr_72413;
})();
if(cljs.core.truth_(inst_72386__$1)){
var statearr_72414_72443 = state_72406__$1;
(statearr_72414_72443[(1)] = (14));

} else {
var statearr_72415_72444 = state_72406__$1;
(statearr_72415_72444[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (2))){
var _ = (function (){var statearr_72416 = state_72406;
(statearr_72416[(4)] = cljs.core.cons((5),(state_72406[(4)])));

return statearr_72416;
})();
var inst_72371 = fluree.db.util.async.channel_QMARK_(seed);
var state_72406__$1 = state_72406;
if(inst_72371){
var statearr_72417_72445 = state_72406__$1;
(statearr_72417_72445[(1)] = (6));

} else {
var statearr_72418_72446 = state_72406__$1;
(statearr_72418_72446[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (11))){
var state_72406__$1 = state_72406;
var statearr_72420_72447 = state_72406__$1;
(statearr_72420_72447[(2)] = max);

(statearr_72420_72447[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (9))){
var inst_72374 = (state_72406[(2)]);
var inst_72375 = fluree.db.util.async.throw_err(inst_72374);
var state_72406__$1 = state_72406;
var statearr_72421_72448 = state_72406__$1;
(statearr_72421_72448[(2)] = inst_72375);

(statearr_72421_72448[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (5))){
var _ = (function (){var statearr_72422 = state_72406;
(statearr_72422[(4)] = cljs.core.rest((state_72406[(4)])));

return statearr_72422;
})();
var state_72406__$1 = state_72406;
var ex72419 = (state_72406__$1[(2)]);
var statearr_72423_72449 = state_72406__$1;
(statearr_72423_72449[(5)] = ex72419);


if((ex72419 instanceof Error)){
var statearr_72424_72450 = state_72406__$1;
(statearr_72424_72450[(1)] = (4));

(statearr_72424_72450[(5)] = null);

} else {
throw ex72419;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (14))){
var inst_72386 = (state_72406[(7)]);
var state_72406__$1 = state_72406;
var statearr_72425_72451 = state_72406__$1;
(statearr_72425_72451[(2)] = inst_72386);

(statearr_72425_72451[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (16))){
var inst_72378 = (state_72406[(8)]);
var inst_72390 = (state_72406[(2)]);
var inst_72391 = fluree.db.dbfunctions.internal.rand(inst_72378,inst_72390);
var inst_72392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72393 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72395 = [max,seed];
var inst_72396 = (new cljs.core.PersistentVector(null,2,(5),inst_72394,inst_72395,null));
var inst_72397 = ["rand",inst_72396,inst_72391];
var inst_72398 = cljs.core.PersistentHashMap.fromArrays(inst_72393,inst_72397);
var inst_72399 = [inst_72398,(10)];
var inst_72400 = (new cljs.core.PersistentVector(null,2,(5),inst_72392,inst_72399,null));
var inst_72401 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72400);
var _ = (function (){var statearr_72426 = state_72406;
(statearr_72426[(4)] = cljs.core.rest((state_72406[(4)])));

return statearr_72426;
})();
var state_72406__$1 = (function (){var statearr_72427 = state_72406;
(statearr_72427[(9)] = inst_72401);

return statearr_72427;
})();
var statearr_72428_72452 = state_72406__$1;
(statearr_72428_72452[(2)] = inst_72391);

(statearr_72428_72452[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72407 === (10))){
var state_72406__$1 = state_72406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72406__$1,(13),max);
} else {
if((state_val_72407 === (8))){
var inst_72378 = (state_72406[(2)]);
var inst_72379 = fluree.db.util.async.channel_QMARK_(max);
var state_72406__$1 = (function (){var statearr_72429 = state_72406;
(statearr_72429[(8)] = inst_72378);

return statearr_72429;
})();
if(inst_72379){
var statearr_72430_72453 = state_72406__$1;
(statearr_72430_72453[(1)] = (10));

} else {
var statearr_72431_72454 = state_72406__$1;
(statearr_72431_72454[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_72432 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72432[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_72432[(1)] = (1));

return statearr_72432;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_72406){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72406);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72433){var ex__16398__auto__ = e72433;
var statearr_72434_72455 = state_72406;
(statearr_72434_72455[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72406[(4)]))){
var statearr_72435_72456 = state_72406;
(statearr_72435_72456[(1)] = cljs.core.first((state_72406[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72457 = state_72406;
state_72406 = G__72457;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_72406){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_72406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72436 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72436[(6)] = c__16469__auto__);

return statearr_72436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72478){
var state_val_72479 = (state_72478[(1)]);
if((state_val_72479 === (1))){
var state_72478__$1 = state_72478;
var statearr_72480_72495 = state_72478__$1;
(statearr_72480_72495[(2)] = null);

(statearr_72480_72495[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72479 === (2))){
var _ = (function (){var statearr_72481 = state_72478;
(statearr_72481[(4)] = cljs.core.cons((5),(state_72478[(4)])));

return statearr_72481;
})();
var inst_72464 = fluree.db.util.core.random_uuid();
var inst_72465 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72464);
var inst_72466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72467 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72468 = cljs.core.PersistentVector.EMPTY;
var inst_72469 = ["uuid",inst_72468,inst_72465];
var inst_72470 = cljs.core.PersistentHashMap.fromArrays(inst_72467,inst_72469);
var inst_72471 = [inst_72470,(10)];
var inst_72472 = (new cljs.core.PersistentVector(null,2,(5),inst_72466,inst_72471,null));
var inst_72473 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72472);
var ___$1 = (function (){var statearr_72482 = state_72478;
(statearr_72482[(4)] = cljs.core.rest((state_72478[(4)])));

return statearr_72482;
})();
var state_72478__$1 = (function (){var statearr_72483 = state_72478;
(statearr_72483[(7)] = inst_72473);

return statearr_72483;
})();
var statearr_72484_72496 = state_72478__$1;
(statearr_72484_72496[(2)] = inst_72465);

(statearr_72484_72496[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72479 === (3))){
var inst_72476 = (state_72478[(2)]);
var state_72478__$1 = state_72478;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72478__$1,inst_72476);
} else {
if((state_val_72479 === (4))){
var inst_72458 = (state_72478[(2)]);
var state_72478__$1 = state_72478;
var statearr_72486_72497 = state_72478__$1;
(statearr_72486_72497[(2)] = inst_72458);

(statearr_72486_72497[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72479 === (5))){
var _ = (function (){var statearr_72487 = state_72478;
(statearr_72487[(4)] = cljs.core.rest((state_72478[(4)])));

return statearr_72487;
})();
var state_72478__$1 = state_72478;
var ex72485 = (state_72478__$1[(2)]);
var statearr_72488_72498 = state_72478__$1;
(statearr_72488_72498[(5)] = ex72485);


if((ex72485 instanceof Error)){
var statearr_72489_72499 = state_72478__$1;
(statearr_72489_72499[(1)] = (4));

(statearr_72489_72499[(5)] = null);

} else {
throw ex72485;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto____0 = (function (){
var statearr_72490 = [null,null,null,null,null,null,null,null];
(statearr_72490[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto__);

(statearr_72490[(1)] = (1));

return statearr_72490;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto____1 = (function (state_72478){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72478);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72491){var ex__16398__auto__ = e72491;
var statearr_72492_72500 = state_72478;
(statearr_72492_72500[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72478[(4)]))){
var statearr_72493_72501 = state_72478;
(statearr_72493_72501[(1)] = cljs.core.first((state_72478[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72502 = state_72478;
state_72478 = G__72502;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto__ = function(state_72478){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto____1.call(this,state_72478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72494 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72494[(6)] = c__16469__auto__);

return statearr_72494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72532){
var state_val_72533 = (state_72532[(1)]);
if((state_val_72533 === (7))){
var state_72532__$1 = state_72532;
var statearr_72534_72553 = state_72532__$1;
(statearr_72534_72553[(2)] = num);

(statearr_72534_72553[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72533 === (1))){
var state_72532__$1 = state_72532;
var statearr_72535_72554 = state_72532__$1;
(statearr_72535_72554[(2)] = null);

(statearr_72535_72554[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72533 === (4))){
var inst_72503 = (state_72532[(2)]);
var state_72532__$1 = state_72532;
var statearr_72536_72555 = state_72532__$1;
(statearr_72536_72555[(2)] = inst_72503);

(statearr_72536_72555[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72533 === (6))){
var state_72532__$1 = state_72532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72532__$1,(9),num);
} else {
if((state_val_72533 === (3))){
var inst_72530 = (state_72532[(2)]);
var state_72532__$1 = state_72532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72532__$1,inst_72530);
} else {
if((state_val_72533 === (2))){
var _ = (function (){var statearr_72538 = state_72532;
(statearr_72538[(4)] = cljs.core.cons((5),(state_72532[(4)])));

return statearr_72538;
})();
var inst_72509 = fluree.db.util.async.channel_QMARK_(num);
var state_72532__$1 = state_72532;
if(inst_72509){
var statearr_72539_72556 = state_72532__$1;
(statearr_72539_72556[(1)] = (6));

} else {
var statearr_72540_72557 = state_72532__$1;
(statearr_72540_72557[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72533 === (9))){
var inst_72512 = (state_72532[(2)]);
var inst_72513 = fluree.db.util.async.throw_err(inst_72512);
var state_72532__$1 = state_72532;
var statearr_72541_72558 = state_72532__$1;
(statearr_72541_72558[(2)] = inst_72513);

(statearr_72541_72558[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72533 === (5))){
var _ = (function (){var statearr_72542 = state_72532;
(statearr_72542[(4)] = cljs.core.rest((state_72532[(4)])));

return statearr_72542;
})();
var state_72532__$1 = state_72532;
var ex72537 = (state_72532__$1[(2)]);
var statearr_72543_72559 = state_72532__$1;
(statearr_72543_72559[(5)] = ex72537);


if((ex72537 instanceof Error)){
var statearr_72544_72560 = state_72532__$1;
(statearr_72544_72560[(1)] = (4));

(statearr_72544_72560[(5)] = null);

} else {
throw ex72537;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72533 === (8))){
var inst_72516 = (state_72532[(2)]);
var inst_72517 = fluree.db.dbfunctions.internal.ceil(inst_72516);
var inst_72518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72519 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72521 = [fluree.db.dbfunctions.fns.ceil];
var inst_72522 = (new cljs.core.PersistentVector(null,1,(5),inst_72520,inst_72521,null));
var inst_72523 = ["",inst_72522,inst_72517];
var inst_72524 = cljs.core.PersistentHashMap.fromArrays(inst_72519,inst_72523);
var inst_72525 = [inst_72524,(10)];
var inst_72526 = (new cljs.core.PersistentVector(null,2,(5),inst_72518,inst_72525,null));
var inst_72527 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72526);
var _ = (function (){var statearr_72545 = state_72532;
(statearr_72545[(4)] = cljs.core.rest((state_72532[(4)])));

return statearr_72545;
})();
var state_72532__$1 = (function (){var statearr_72546 = state_72532;
(statearr_72546[(7)] = inst_72527);

return statearr_72546;
})();
var statearr_72547_72561 = state_72532__$1;
(statearr_72547_72561[(2)] = inst_72517);

(statearr_72547_72561[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto____0 = (function (){
var statearr_72548 = [null,null,null,null,null,null,null,null];
(statearr_72548[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto__);

(statearr_72548[(1)] = (1));

return statearr_72548;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto____1 = (function (state_72532){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72532);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72549){var ex__16398__auto__ = e72549;
var statearr_72550_72562 = state_72532;
(statearr_72550_72562[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72532[(4)]))){
var statearr_72551_72563 = state_72532;
(statearr_72551_72563[(1)] = cljs.core.first((state_72532[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72564 = state_72532;
state_72532 = G__72564;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto__ = function(state_72532){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto____1.call(this,state_72532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72552 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72552[(6)] = c__16469__auto__);

return statearr_72552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72594){
var state_val_72595 = (state_72594[(1)]);
if((state_val_72595 === (7))){
var state_72594__$1 = state_72594;
var statearr_72596_72615 = state_72594__$1;
(statearr_72596_72615[(2)] = num);

(statearr_72596_72615[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72595 === (1))){
var state_72594__$1 = state_72594;
var statearr_72597_72616 = state_72594__$1;
(statearr_72597_72616[(2)] = null);

(statearr_72597_72616[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72595 === (4))){
var inst_72565 = (state_72594[(2)]);
var state_72594__$1 = state_72594;
var statearr_72598_72617 = state_72594__$1;
(statearr_72598_72617[(2)] = inst_72565);

(statearr_72598_72617[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72595 === (6))){
var state_72594__$1 = state_72594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72594__$1,(9),num);
} else {
if((state_val_72595 === (3))){
var inst_72592 = (state_72594[(2)]);
var state_72594__$1 = state_72594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72594__$1,inst_72592);
} else {
if((state_val_72595 === (2))){
var _ = (function (){var statearr_72600 = state_72594;
(statearr_72600[(4)] = cljs.core.cons((5),(state_72594[(4)])));

return statearr_72600;
})();
var inst_72571 = fluree.db.util.async.channel_QMARK_(num);
var state_72594__$1 = state_72594;
if(inst_72571){
var statearr_72601_72618 = state_72594__$1;
(statearr_72601_72618[(1)] = (6));

} else {
var statearr_72602_72619 = state_72594__$1;
(statearr_72602_72619[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72595 === (9))){
var inst_72574 = (state_72594[(2)]);
var inst_72575 = fluree.db.util.async.throw_err(inst_72574);
var state_72594__$1 = state_72594;
var statearr_72603_72620 = state_72594__$1;
(statearr_72603_72620[(2)] = inst_72575);

(statearr_72603_72620[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72595 === (5))){
var _ = (function (){var statearr_72604 = state_72594;
(statearr_72604[(4)] = cljs.core.rest((state_72594[(4)])));

return statearr_72604;
})();
var state_72594__$1 = state_72594;
var ex72599 = (state_72594__$1[(2)]);
var statearr_72605_72621 = state_72594__$1;
(statearr_72605_72621[(5)] = ex72599);


if((ex72599 instanceof Error)){
var statearr_72606_72622 = state_72594__$1;
(statearr_72606_72622[(1)] = (4));

(statearr_72606_72622[(5)] = null);

} else {
throw ex72599;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72595 === (8))){
var inst_72578 = (state_72594[(2)]);
var inst_72579 = fluree.db.dbfunctions.internal.floor(inst_72578);
var inst_72580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72581 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72583 = [fluree.db.dbfunctions.fns.floor];
var inst_72584 = (new cljs.core.PersistentVector(null,1,(5),inst_72582,inst_72583,null));
var inst_72585 = ["",inst_72584,inst_72579];
var inst_72586 = cljs.core.PersistentHashMap.fromArrays(inst_72581,inst_72585);
var inst_72587 = [inst_72586,(10)];
var inst_72588 = (new cljs.core.PersistentVector(null,2,(5),inst_72580,inst_72587,null));
var inst_72589 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72588);
var _ = (function (){var statearr_72607 = state_72594;
(statearr_72607[(4)] = cljs.core.rest((state_72594[(4)])));

return statearr_72607;
})();
var state_72594__$1 = (function (){var statearr_72608 = state_72594;
(statearr_72608[(7)] = inst_72589);

return statearr_72608;
})();
var statearr_72609_72623 = state_72594__$1;
(statearr_72609_72623[(2)] = inst_72579);

(statearr_72609_72623[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto____0 = (function (){
var statearr_72610 = [null,null,null,null,null,null,null,null];
(statearr_72610[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto__);

(statearr_72610[(1)] = (1));

return statearr_72610;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto____1 = (function (state_72594){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72594);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72611){var ex__16398__auto__ = e72611;
var statearr_72612_72624 = state_72594;
(statearr_72612_72624[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72594[(4)]))){
var statearr_72613_72625 = state_72594;
(statearr_72613_72625[(1)] = cljs.core.first((state_72594[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72626 = state_72594;
state_72594 = G__72626;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto__ = function(state_72594){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto____1.call(this,state_72594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72614 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72614[(6)] = c__16469__auto__);

return statearr_72614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72651){
var state_val_72652 = (state_72651[(1)]);
if((state_val_72652 === (1))){
var state_72651__$1 = state_72651;
var statearr_72653_72668 = state_72651__$1;
(statearr_72653_72668[(2)] = null);

(statearr_72653_72668[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72652 === (2))){
var _ = (function (){var statearr_72654 = state_72651;
(statearr_72654[(4)] = cljs.core.cons((5),(state_72651[(4)])));

return statearr_72654;
})();
var inst_72633 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_72651__$1 = state_72651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72651__$1,(6),inst_72633);
} else {
if((state_val_72652 === (3))){
var inst_72649 = (state_72651[(2)]);
var state_72651__$1 = state_72651;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72651__$1,inst_72649);
} else {
if((state_val_72652 === (4))){
var inst_72627 = (state_72651[(2)]);
var state_72651__$1 = state_72651;
var statearr_72656_72669 = state_72651__$1;
(statearr_72656_72669[(2)] = inst_72627);

(statearr_72656_72669[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72652 === (5))){
var _ = (function (){var statearr_72657 = state_72651;
(statearr_72657[(4)] = cljs.core.rest((state_72651[(4)])));

return statearr_72657;
})();
var state_72651__$1 = state_72651;
var ex72655 = (state_72651__$1[(2)]);
var statearr_72658_72670 = state_72651__$1;
(statearr_72658_72670[(5)] = ex72655);


if((ex72655 instanceof Error)){
var statearr_72659_72671 = state_72651__$1;
(statearr_72659_72671[(1)] = (4));

(statearr_72659_72671[(5)] = null);

} else {
throw ex72655;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72652 === (6))){
var inst_72635 = (state_72651[(2)]);
var inst_72636 = fluree.db.util.async.throw_err(inst_72635);
var inst_72637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72638 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72640 = [compare_val,new_val];
var inst_72641 = (new cljs.core.PersistentVector(null,2,(5),inst_72639,inst_72640,null));
var inst_72642 = ["",inst_72641,inst_72636];
var inst_72643 = cljs.core.PersistentHashMap.fromArrays(inst_72638,inst_72642);
var inst_72644 = [inst_72643,(10)];
var inst_72645 = (new cljs.core.PersistentVector(null,2,(5),inst_72637,inst_72644,null));
var inst_72646 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72645);
var _ = (function (){var statearr_72660 = state_72651;
(statearr_72660[(4)] = cljs.core.rest((state_72651[(4)])));

return statearr_72660;
})();
var state_72651__$1 = (function (){var statearr_72661 = state_72651;
(statearr_72661[(7)] = inst_72646);

return statearr_72661;
})();
var statearr_72662_72672 = state_72651__$1;
(statearr_72662_72672[(2)] = inst_72636);

(statearr_72662_72672[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto____0 = (function (){
var statearr_72663 = [null,null,null,null,null,null,null,null];
(statearr_72663[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto__);

(statearr_72663[(1)] = (1));

return statearr_72663;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto____1 = (function (state_72651){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72651);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72664){var ex__16398__auto__ = e72664;
var statearr_72665_72673 = state_72651;
(statearr_72665_72673[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72651[(4)]))){
var statearr_72666_72674 = state_72651;
(statearr_72666_72674[(1)] = cljs.core.first((state_72651[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72675 = state_72651;
state_72651 = G__72675;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto__ = function(state_72651){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto____1.call(this,state_72651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72667 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72667[(6)] = c__16469__auto__);

return statearr_72667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
