// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__16529 = arguments.length;
switch (G__16529) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16530 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16530 = (function (f,blockable,meta16531){
this.f = f;
this.blockable = blockable;
this.meta16531 = meta16531;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16530.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16532,meta16531__$1){
var self__ = this;
var _16532__$1 = this;
return (new cljs.core.async.t_cljs$core$async16530(self__.f,self__.blockable,meta16531__$1));
}));

(cljs.core.async.t_cljs$core$async16530.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16532){
var self__ = this;
var _16532__$1 = this;
return self__.meta16531;
}));

(cljs.core.async.t_cljs$core$async16530.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16530.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16530.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async16530.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async16530.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta16531], null);
}));

(cljs.core.async.t_cljs$core$async16530.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16530.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16530");

(cljs.core.async.t_cljs$core$async16530.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async16530");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16530.
 */
cljs.core.async.__GT_t_cljs$core$async16530 = (function cljs$core$async$__GT_t_cljs$core$async16530(f__$1,blockable__$1,meta16531){
return (new cljs.core.async.t_cljs$core$async16530(f__$1,blockable__$1,meta16531));
});

}

return (new cljs.core.async.t_cljs$core$async16530(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__16536 = arguments.length;
switch (G__16536) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__16539 = arguments.length;
switch (G__16539) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__16542 = arguments.length;
switch (G__16542) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_16544 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16544) : fn1.call(null,val_16544));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16544) : fn1.call(null,val_16544));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__16546 = arguments.length;
switch (G__16546) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4695__auto___16548 = n;
var x_16549 = (0);
while(true){
if((x_16549 < n__4695__auto___16548)){
(a[x_16549] = x_16549);

var G__16550 = (x_16549 + (1));
x_16549 = G__16550;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16551 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16551 = (function (flag,meta16552){
this.flag = flag;
this.meta16552 = meta16552;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16551.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16553,meta16552__$1){
var self__ = this;
var _16553__$1 = this;
return (new cljs.core.async.t_cljs$core$async16551(self__.flag,meta16552__$1));
}));

(cljs.core.async.t_cljs$core$async16551.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16553){
var self__ = this;
var _16553__$1 = this;
return self__.meta16552;
}));

(cljs.core.async.t_cljs$core$async16551.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16551.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async16551.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16551.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async16551.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta16552], null);
}));

(cljs.core.async.t_cljs$core$async16551.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16551.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16551");

(cljs.core.async.t_cljs$core$async16551.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async16551");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16551.
 */
cljs.core.async.__GT_t_cljs$core$async16551 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async16551(flag__$1,meta16552){
return (new cljs.core.async.t_cljs$core$async16551(flag__$1,meta16552));
});

}

return (new cljs.core.async.t_cljs$core$async16551(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16554 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16554 = (function (flag,cb,meta16555){
this.flag = flag;
this.cb = cb;
this.meta16555 = meta16555;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16554.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16556,meta16555__$1){
var self__ = this;
var _16556__$1 = this;
return (new cljs.core.async.t_cljs$core$async16554(self__.flag,self__.cb,meta16555__$1));
}));

(cljs.core.async.t_cljs$core$async16554.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16556){
var self__ = this;
var _16556__$1 = this;
return self__.meta16555;
}));

(cljs.core.async.t_cljs$core$async16554.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16554.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async16554.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16554.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async16554.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta16555], null);
}));

(cljs.core.async.t_cljs$core$async16554.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16554.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16554");

(cljs.core.async.t_cljs$core$async16554.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async16554");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16554.
 */
cljs.core.async.__GT_t_cljs$core$async16554 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async16554(flag__$1,cb__$1,meta16555){
return (new cljs.core.async.t_cljs$core$async16554(flag__$1,cb__$1,meta16555));
});

}

return (new cljs.core.async.t_cljs$core$async16554(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16557_SHARP_){
var G__16559 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16557_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16559) : fret.call(null,G__16559));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16558_SHARP_){
var G__16560 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16558_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16560) : fret.call(null,G__16560));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4212__auto__ = wport;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return port;
}
})()], null));
} else {
var G__16561 = (i + (1));
i = G__16561;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4212__auto__ = ret;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5753__auto__ = (function (){var and__4210__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4210__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___16566 = arguments.length;
var i__4819__auto___16567 = (0);
while(true){
if((i__4819__auto___16567 < len__4818__auto___16566)){
args__4824__auto__.push((arguments[i__4819__auto___16567]));

var G__16568 = (i__4819__auto___16567 + (1));
i__4819__auto___16567 = G__16568;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__16564){
var map__16565 = p__16564;
var map__16565__$1 = cljs.core.__destructure_map(map__16565);
var opts = map__16565__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq16562){
var G__16563 = cljs.core.first(seq16562);
var seq16562__$1 = cljs.core.next(seq16562);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16563,seq16562__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__16570 = arguments.length;
switch (G__16570) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16469__auto___16617 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_16594){
var state_val_16595 = (state_16594[(1)]);
if((state_val_16595 === (7))){
var inst_16590 = (state_16594[(2)]);
var state_16594__$1 = state_16594;
var statearr_16596_16618 = state_16594__$1;
(statearr_16596_16618[(2)] = inst_16590);

(statearr_16596_16618[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16595 === (1))){
var state_16594__$1 = state_16594;
var statearr_16597_16619 = state_16594__$1;
(statearr_16597_16619[(2)] = null);

(statearr_16597_16619[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16595 === (4))){
var inst_16573 = (state_16594[(7)]);
var inst_16573__$1 = (state_16594[(2)]);
var inst_16574 = (inst_16573__$1 == null);
var state_16594__$1 = (function (){var statearr_16598 = state_16594;
(statearr_16598[(7)] = inst_16573__$1);

return statearr_16598;
})();
if(cljs.core.truth_(inst_16574)){
var statearr_16599_16620 = state_16594__$1;
(statearr_16599_16620[(1)] = (5));

} else {
var statearr_16600_16621 = state_16594__$1;
(statearr_16600_16621[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16595 === (13))){
var state_16594__$1 = state_16594;
var statearr_16601_16622 = state_16594__$1;
(statearr_16601_16622[(2)] = null);

(statearr_16601_16622[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16595 === (6))){
var inst_16573 = (state_16594[(7)]);
var state_16594__$1 = state_16594;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16594__$1,(11),to,inst_16573);
} else {
if((state_val_16595 === (3))){
var inst_16592 = (state_16594[(2)]);
var state_16594__$1 = state_16594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16594__$1,inst_16592);
} else {
if((state_val_16595 === (12))){
var state_16594__$1 = state_16594;
var statearr_16602_16623 = state_16594__$1;
(statearr_16602_16623[(2)] = null);

(statearr_16602_16623[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16595 === (2))){
var state_16594__$1 = state_16594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16594__$1,(4),from);
} else {
if((state_val_16595 === (11))){
var inst_16583 = (state_16594[(2)]);
var state_16594__$1 = state_16594;
if(cljs.core.truth_(inst_16583)){
var statearr_16603_16624 = state_16594__$1;
(statearr_16603_16624[(1)] = (12));

} else {
var statearr_16604_16625 = state_16594__$1;
(statearr_16604_16625[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16595 === (9))){
var state_16594__$1 = state_16594;
var statearr_16605_16626 = state_16594__$1;
(statearr_16605_16626[(2)] = null);

(statearr_16605_16626[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16595 === (5))){
var state_16594__$1 = state_16594;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16606_16627 = state_16594__$1;
(statearr_16606_16627[(1)] = (8));

} else {
var statearr_16607_16628 = state_16594__$1;
(statearr_16607_16628[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16595 === (14))){
var inst_16588 = (state_16594[(2)]);
var state_16594__$1 = state_16594;
var statearr_16608_16629 = state_16594__$1;
(statearr_16608_16629[(2)] = inst_16588);

(statearr_16608_16629[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16595 === (10))){
var inst_16580 = (state_16594[(2)]);
var state_16594__$1 = state_16594;
var statearr_16609_16630 = state_16594__$1;
(statearr_16609_16630[(2)] = inst_16580);

(statearr_16609_16630[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16595 === (8))){
var inst_16577 = cljs.core.async.close_BANG_(to);
var state_16594__$1 = state_16594;
var statearr_16610_16631 = state_16594__$1;
(statearr_16610_16631[(2)] = inst_16577);

(statearr_16610_16631[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16395__auto__ = null;
var cljs$core$async$state_machine__16395__auto____0 = (function (){
var statearr_16611 = [null,null,null,null,null,null,null,null];
(statearr_16611[(0)] = cljs$core$async$state_machine__16395__auto__);

(statearr_16611[(1)] = (1));

return statearr_16611;
});
var cljs$core$async$state_machine__16395__auto____1 = (function (state_16594){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_16594);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e16612){var ex__16398__auto__ = e16612;
var statearr_16613_16632 = state_16594;
(statearr_16613_16632[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_16594[(4)]))){
var statearr_16614_16633 = state_16594;
(statearr_16614_16633[(1)] = cljs.core.first((state_16594[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__16634 = state_16594;
state_16594 = G__16634;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$state_machine__16395__auto__ = function(state_16594){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16395__auto____1.call(this,state_16594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16395__auto____0;
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16395__auto____1;
return cljs$core$async$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_16615 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_16615[(6)] = c__16469__auto___16617);

return statearr_16615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__16635){
var vec__16636 = p__16635;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16636,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16636,(1),null);
var job = vec__16636;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__16469__auto___16812 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_16643){
var state_val_16644 = (state_16643[(1)]);
if((state_val_16644 === (1))){
var state_16643__$1 = state_16643;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16643__$1,(2),res,v);
} else {
if((state_val_16644 === (2))){
var inst_16640 = (state_16643[(2)]);
var inst_16641 = cljs.core.async.close_BANG_(res);
var state_16643__$1 = (function (){var statearr_16645 = state_16643;
(statearr_16645[(7)] = inst_16640);

return statearr_16645;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16643__$1,inst_16641);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0 = (function (){
var statearr_16646 = [null,null,null,null,null,null,null,null];
(statearr_16646[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__);

(statearr_16646[(1)] = (1));

return statearr_16646;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1 = (function (state_16643){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_16643);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e16647){var ex__16398__auto__ = e16647;
var statearr_16648_16813 = state_16643;
(statearr_16648_16813[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_16643[(4)]))){
var statearr_16649_16814 = state_16643;
(statearr_16649_16814[(1)] = cljs.core.first((state_16643[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__16815 = state_16643;
state_16643 = G__16815;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__ = function(state_16643){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1.call(this,state_16643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_16650 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_16650[(6)] = c__16469__auto___16812);

return statearr_16650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__16651){
var vec__16652 = p__16651;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16652,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16652,(1),null);
var job = vec__16652;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4695__auto___16816 = n;
var __16817 = (0);
while(true){
if((__16817 < n__4695__auto___16816)){
var G__16655_16818 = type;
var G__16655_16819__$1 = (((G__16655_16818 instanceof cljs.core.Keyword))?G__16655_16818.fqn:null);
switch (G__16655_16819__$1) {
case "compute":
var c__16469__auto___16821 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__16817,c__16469__auto___16821,G__16655_16818,G__16655_16819__$1,n__4695__auto___16816,jobs,results,process,async){
return (function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = ((function (__16817,c__16469__auto___16821,G__16655_16818,G__16655_16819__$1,n__4695__auto___16816,jobs,results,process,async){
return (function (state_16668){
var state_val_16669 = (state_16668[(1)]);
if((state_val_16669 === (1))){
var state_16668__$1 = state_16668;
var statearr_16670_16822 = state_16668__$1;
(statearr_16670_16822[(2)] = null);

(statearr_16670_16822[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16669 === (2))){
var state_16668__$1 = state_16668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16668__$1,(4),jobs);
} else {
if((state_val_16669 === (3))){
var inst_16666 = (state_16668[(2)]);
var state_16668__$1 = state_16668;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16668__$1,inst_16666);
} else {
if((state_val_16669 === (4))){
var inst_16658 = (state_16668[(2)]);
var inst_16659 = process(inst_16658);
var state_16668__$1 = state_16668;
if(cljs.core.truth_(inst_16659)){
var statearr_16671_16823 = state_16668__$1;
(statearr_16671_16823[(1)] = (5));

} else {
var statearr_16672_16824 = state_16668__$1;
(statearr_16672_16824[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16669 === (5))){
var state_16668__$1 = state_16668;
var statearr_16673_16825 = state_16668__$1;
(statearr_16673_16825[(2)] = null);

(statearr_16673_16825[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16669 === (6))){
var state_16668__$1 = state_16668;
var statearr_16674_16826 = state_16668__$1;
(statearr_16674_16826[(2)] = null);

(statearr_16674_16826[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16669 === (7))){
var inst_16664 = (state_16668[(2)]);
var state_16668__$1 = state_16668;
var statearr_16675_16827 = state_16668__$1;
(statearr_16675_16827[(2)] = inst_16664);

(statearr_16675_16827[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__16817,c__16469__auto___16821,G__16655_16818,G__16655_16819__$1,n__4695__auto___16816,jobs,results,process,async))
;
return ((function (__16817,switch__16394__auto__,c__16469__auto___16821,G__16655_16818,G__16655_16819__$1,n__4695__auto___16816,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0 = (function (){
var statearr_16676 = [null,null,null,null,null,null,null];
(statearr_16676[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__);

(statearr_16676[(1)] = (1));

return statearr_16676;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1 = (function (state_16668){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_16668);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e16677){var ex__16398__auto__ = e16677;
var statearr_16678_16828 = state_16668;
(statearr_16678_16828[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_16668[(4)]))){
var statearr_16679_16829 = state_16668;
(statearr_16679_16829[(1)] = cljs.core.first((state_16668[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__16830 = state_16668;
state_16668 = G__16830;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__ = function(state_16668){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1.call(this,state_16668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__;
})()
;})(__16817,switch__16394__auto__,c__16469__auto___16821,G__16655_16818,G__16655_16819__$1,n__4695__auto___16816,jobs,results,process,async))
})();
var state__16471__auto__ = (function (){var statearr_16680 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_16680[(6)] = c__16469__auto___16821);

return statearr_16680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
});})(__16817,c__16469__auto___16821,G__16655_16818,G__16655_16819__$1,n__4695__auto___16816,jobs,results,process,async))
);


break;
case "async":
var c__16469__auto___16831 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__16817,c__16469__auto___16831,G__16655_16818,G__16655_16819__$1,n__4695__auto___16816,jobs,results,process,async){
return (function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = ((function (__16817,c__16469__auto___16831,G__16655_16818,G__16655_16819__$1,n__4695__auto___16816,jobs,results,process,async){
return (function (state_16693){
var state_val_16694 = (state_16693[(1)]);
if((state_val_16694 === (1))){
var state_16693__$1 = state_16693;
var statearr_16695_16832 = state_16693__$1;
(statearr_16695_16832[(2)] = null);

(statearr_16695_16832[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16694 === (2))){
var state_16693__$1 = state_16693;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16693__$1,(4),jobs);
} else {
if((state_val_16694 === (3))){
var inst_16691 = (state_16693[(2)]);
var state_16693__$1 = state_16693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16693__$1,inst_16691);
} else {
if((state_val_16694 === (4))){
var inst_16683 = (state_16693[(2)]);
var inst_16684 = async(inst_16683);
var state_16693__$1 = state_16693;
if(cljs.core.truth_(inst_16684)){
var statearr_16696_16833 = state_16693__$1;
(statearr_16696_16833[(1)] = (5));

} else {
var statearr_16697_16834 = state_16693__$1;
(statearr_16697_16834[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16694 === (5))){
var state_16693__$1 = state_16693;
var statearr_16698_16835 = state_16693__$1;
(statearr_16698_16835[(2)] = null);

(statearr_16698_16835[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16694 === (6))){
var state_16693__$1 = state_16693;
var statearr_16699_16836 = state_16693__$1;
(statearr_16699_16836[(2)] = null);

(statearr_16699_16836[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16694 === (7))){
var inst_16689 = (state_16693[(2)]);
var state_16693__$1 = state_16693;
var statearr_16700_16837 = state_16693__$1;
(statearr_16700_16837[(2)] = inst_16689);

(statearr_16700_16837[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__16817,c__16469__auto___16831,G__16655_16818,G__16655_16819__$1,n__4695__auto___16816,jobs,results,process,async))
;
return ((function (__16817,switch__16394__auto__,c__16469__auto___16831,G__16655_16818,G__16655_16819__$1,n__4695__auto___16816,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0 = (function (){
var statearr_16701 = [null,null,null,null,null,null,null];
(statearr_16701[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__);

(statearr_16701[(1)] = (1));

return statearr_16701;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1 = (function (state_16693){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_16693);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e16702){var ex__16398__auto__ = e16702;
var statearr_16703_16838 = state_16693;
(statearr_16703_16838[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_16693[(4)]))){
var statearr_16704_16839 = state_16693;
(statearr_16704_16839[(1)] = cljs.core.first((state_16693[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__16840 = state_16693;
state_16693 = G__16840;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__ = function(state_16693){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1.call(this,state_16693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__;
})()
;})(__16817,switch__16394__auto__,c__16469__auto___16831,G__16655_16818,G__16655_16819__$1,n__4695__auto___16816,jobs,results,process,async))
})();
var state__16471__auto__ = (function (){var statearr_16705 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_16705[(6)] = c__16469__auto___16831);

return statearr_16705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
});})(__16817,c__16469__auto___16831,G__16655_16818,G__16655_16819__$1,n__4695__auto___16816,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__16655_16819__$1)].join('')));

}

var G__16841 = (__16817 + (1));
__16817 = G__16841;
continue;
} else {
}
break;
}

var c__16469__auto___16842 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_16727){
var state_val_16728 = (state_16727[(1)]);
if((state_val_16728 === (7))){
var inst_16723 = (state_16727[(2)]);
var state_16727__$1 = state_16727;
var statearr_16729_16843 = state_16727__$1;
(statearr_16729_16843[(2)] = inst_16723);

(statearr_16729_16843[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16728 === (1))){
var state_16727__$1 = state_16727;
var statearr_16730_16844 = state_16727__$1;
(statearr_16730_16844[(2)] = null);

(statearr_16730_16844[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16728 === (4))){
var inst_16708 = (state_16727[(7)]);
var inst_16708__$1 = (state_16727[(2)]);
var inst_16709 = (inst_16708__$1 == null);
var state_16727__$1 = (function (){var statearr_16731 = state_16727;
(statearr_16731[(7)] = inst_16708__$1);

return statearr_16731;
})();
if(cljs.core.truth_(inst_16709)){
var statearr_16732_16845 = state_16727__$1;
(statearr_16732_16845[(1)] = (5));

} else {
var statearr_16733_16846 = state_16727__$1;
(statearr_16733_16846[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16728 === (6))){
var inst_16713 = (state_16727[(8)]);
var inst_16708 = (state_16727[(7)]);
var inst_16713__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_16714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16715 = [inst_16708,inst_16713__$1];
var inst_16716 = (new cljs.core.PersistentVector(null,2,(5),inst_16714,inst_16715,null));
var state_16727__$1 = (function (){var statearr_16734 = state_16727;
(statearr_16734[(8)] = inst_16713__$1);

return statearr_16734;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16727__$1,(8),jobs,inst_16716);
} else {
if((state_val_16728 === (3))){
var inst_16725 = (state_16727[(2)]);
var state_16727__$1 = state_16727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16727__$1,inst_16725);
} else {
if((state_val_16728 === (2))){
var state_16727__$1 = state_16727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16727__$1,(4),from);
} else {
if((state_val_16728 === (9))){
var inst_16720 = (state_16727[(2)]);
var state_16727__$1 = (function (){var statearr_16735 = state_16727;
(statearr_16735[(9)] = inst_16720);

return statearr_16735;
})();
var statearr_16736_16847 = state_16727__$1;
(statearr_16736_16847[(2)] = null);

(statearr_16736_16847[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16728 === (5))){
var inst_16711 = cljs.core.async.close_BANG_(jobs);
var state_16727__$1 = state_16727;
var statearr_16737_16848 = state_16727__$1;
(statearr_16737_16848[(2)] = inst_16711);

(statearr_16737_16848[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16728 === (8))){
var inst_16713 = (state_16727[(8)]);
var inst_16718 = (state_16727[(2)]);
var state_16727__$1 = (function (){var statearr_16738 = state_16727;
(statearr_16738[(10)] = inst_16718);

return statearr_16738;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16727__$1,(9),results,inst_16713);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0 = (function (){
var statearr_16739 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16739[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__);

(statearr_16739[(1)] = (1));

return statearr_16739;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1 = (function (state_16727){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_16727);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e16740){var ex__16398__auto__ = e16740;
var statearr_16741_16849 = state_16727;
(statearr_16741_16849[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_16727[(4)]))){
var statearr_16742_16850 = state_16727;
(statearr_16742_16850[(1)] = cljs.core.first((state_16727[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__16851 = state_16727;
state_16727 = G__16851;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__ = function(state_16727){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1.call(this,state_16727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_16743 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_16743[(6)] = c__16469__auto___16842);

return statearr_16743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_16781){
var state_val_16782 = (state_16781[(1)]);
if((state_val_16782 === (7))){
var inst_16777 = (state_16781[(2)]);
var state_16781__$1 = state_16781;
var statearr_16783_16852 = state_16781__$1;
(statearr_16783_16852[(2)] = inst_16777);

(statearr_16783_16852[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (20))){
var state_16781__$1 = state_16781;
var statearr_16784_16853 = state_16781__$1;
(statearr_16784_16853[(2)] = null);

(statearr_16784_16853[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (1))){
var state_16781__$1 = state_16781;
var statearr_16785_16854 = state_16781__$1;
(statearr_16785_16854[(2)] = null);

(statearr_16785_16854[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (4))){
var inst_16746 = (state_16781[(7)]);
var inst_16746__$1 = (state_16781[(2)]);
var inst_16747 = (inst_16746__$1 == null);
var state_16781__$1 = (function (){var statearr_16786 = state_16781;
(statearr_16786[(7)] = inst_16746__$1);

return statearr_16786;
})();
if(cljs.core.truth_(inst_16747)){
var statearr_16787_16855 = state_16781__$1;
(statearr_16787_16855[(1)] = (5));

} else {
var statearr_16788_16856 = state_16781__$1;
(statearr_16788_16856[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (15))){
var inst_16759 = (state_16781[(8)]);
var state_16781__$1 = state_16781;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16781__$1,(18),to,inst_16759);
} else {
if((state_val_16782 === (21))){
var inst_16772 = (state_16781[(2)]);
var state_16781__$1 = state_16781;
var statearr_16789_16857 = state_16781__$1;
(statearr_16789_16857[(2)] = inst_16772);

(statearr_16789_16857[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (13))){
var inst_16774 = (state_16781[(2)]);
var state_16781__$1 = (function (){var statearr_16790 = state_16781;
(statearr_16790[(9)] = inst_16774);

return statearr_16790;
})();
var statearr_16791_16858 = state_16781__$1;
(statearr_16791_16858[(2)] = null);

(statearr_16791_16858[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (6))){
var inst_16746 = (state_16781[(7)]);
var state_16781__$1 = state_16781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16781__$1,(11),inst_16746);
} else {
if((state_val_16782 === (17))){
var inst_16767 = (state_16781[(2)]);
var state_16781__$1 = state_16781;
if(cljs.core.truth_(inst_16767)){
var statearr_16792_16859 = state_16781__$1;
(statearr_16792_16859[(1)] = (19));

} else {
var statearr_16793_16860 = state_16781__$1;
(statearr_16793_16860[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (3))){
var inst_16779 = (state_16781[(2)]);
var state_16781__$1 = state_16781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16781__$1,inst_16779);
} else {
if((state_val_16782 === (12))){
var inst_16756 = (state_16781[(10)]);
var state_16781__$1 = state_16781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16781__$1,(14),inst_16756);
} else {
if((state_val_16782 === (2))){
var state_16781__$1 = state_16781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16781__$1,(4),results);
} else {
if((state_val_16782 === (19))){
var state_16781__$1 = state_16781;
var statearr_16794_16861 = state_16781__$1;
(statearr_16794_16861[(2)] = null);

(statearr_16794_16861[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (11))){
var inst_16756 = (state_16781[(2)]);
var state_16781__$1 = (function (){var statearr_16795 = state_16781;
(statearr_16795[(10)] = inst_16756);

return statearr_16795;
})();
var statearr_16796_16862 = state_16781__$1;
(statearr_16796_16862[(2)] = null);

(statearr_16796_16862[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (9))){
var state_16781__$1 = state_16781;
var statearr_16797_16863 = state_16781__$1;
(statearr_16797_16863[(2)] = null);

(statearr_16797_16863[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (5))){
var state_16781__$1 = state_16781;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16798_16864 = state_16781__$1;
(statearr_16798_16864[(1)] = (8));

} else {
var statearr_16799_16865 = state_16781__$1;
(statearr_16799_16865[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (14))){
var inst_16759 = (state_16781[(8)]);
var inst_16761 = (state_16781[(11)]);
var inst_16759__$1 = (state_16781[(2)]);
var inst_16760 = (inst_16759__$1 == null);
var inst_16761__$1 = cljs.core.not(inst_16760);
var state_16781__$1 = (function (){var statearr_16800 = state_16781;
(statearr_16800[(8)] = inst_16759__$1);

(statearr_16800[(11)] = inst_16761__$1);

return statearr_16800;
})();
if(inst_16761__$1){
var statearr_16801_16866 = state_16781__$1;
(statearr_16801_16866[(1)] = (15));

} else {
var statearr_16802_16867 = state_16781__$1;
(statearr_16802_16867[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (16))){
var inst_16761 = (state_16781[(11)]);
var state_16781__$1 = state_16781;
var statearr_16803_16868 = state_16781__$1;
(statearr_16803_16868[(2)] = inst_16761);

(statearr_16803_16868[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (10))){
var inst_16753 = (state_16781[(2)]);
var state_16781__$1 = state_16781;
var statearr_16804_16869 = state_16781__$1;
(statearr_16804_16869[(2)] = inst_16753);

(statearr_16804_16869[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (18))){
var inst_16764 = (state_16781[(2)]);
var state_16781__$1 = state_16781;
var statearr_16805_16870 = state_16781__$1;
(statearr_16805_16870[(2)] = inst_16764);

(statearr_16805_16870[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16782 === (8))){
var inst_16750 = cljs.core.async.close_BANG_(to);
var state_16781__$1 = state_16781;
var statearr_16806_16871 = state_16781__$1;
(statearr_16806_16871[(2)] = inst_16750);

(statearr_16806_16871[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0 = (function (){
var statearr_16807 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16807[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__);

(statearr_16807[(1)] = (1));

return statearr_16807;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1 = (function (state_16781){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_16781);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e16808){var ex__16398__auto__ = e16808;
var statearr_16809_16872 = state_16781;
(statearr_16809_16872[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_16781[(4)]))){
var statearr_16810_16873 = state_16781;
(statearr_16810_16873[(1)] = cljs.core.first((state_16781[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__16874 = state_16781;
state_16781 = G__16874;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__ = function(state_16781){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1.call(this,state_16781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16395__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_16811 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_16811[(6)] = c__16469__auto__);

return statearr_16811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__16876 = arguments.length;
switch (G__16876) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__16879 = arguments.length;
switch (G__16879) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__16882 = arguments.length;
switch (G__16882) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__16469__auto___16932 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_16908){
var state_val_16909 = (state_16908[(1)]);
if((state_val_16909 === (7))){
var inst_16904 = (state_16908[(2)]);
var state_16908__$1 = state_16908;
var statearr_16910_16933 = state_16908__$1;
(statearr_16910_16933[(2)] = inst_16904);

(statearr_16910_16933[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16909 === (1))){
var state_16908__$1 = state_16908;
var statearr_16911_16934 = state_16908__$1;
(statearr_16911_16934[(2)] = null);

(statearr_16911_16934[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16909 === (4))){
var inst_16885 = (state_16908[(7)]);
var inst_16885__$1 = (state_16908[(2)]);
var inst_16886 = (inst_16885__$1 == null);
var state_16908__$1 = (function (){var statearr_16912 = state_16908;
(statearr_16912[(7)] = inst_16885__$1);

return statearr_16912;
})();
if(cljs.core.truth_(inst_16886)){
var statearr_16913_16935 = state_16908__$1;
(statearr_16913_16935[(1)] = (5));

} else {
var statearr_16914_16936 = state_16908__$1;
(statearr_16914_16936[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16909 === (13))){
var state_16908__$1 = state_16908;
var statearr_16915_16937 = state_16908__$1;
(statearr_16915_16937[(2)] = null);

(statearr_16915_16937[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16909 === (6))){
var inst_16885 = (state_16908[(7)]);
var inst_16891 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_16885) : p.call(null,inst_16885));
var state_16908__$1 = state_16908;
if(cljs.core.truth_(inst_16891)){
var statearr_16916_16938 = state_16908__$1;
(statearr_16916_16938[(1)] = (9));

} else {
var statearr_16917_16939 = state_16908__$1;
(statearr_16917_16939[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16909 === (3))){
var inst_16906 = (state_16908[(2)]);
var state_16908__$1 = state_16908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16908__$1,inst_16906);
} else {
if((state_val_16909 === (12))){
var state_16908__$1 = state_16908;
var statearr_16918_16940 = state_16908__$1;
(statearr_16918_16940[(2)] = null);

(statearr_16918_16940[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16909 === (2))){
var state_16908__$1 = state_16908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16908__$1,(4),ch);
} else {
if((state_val_16909 === (11))){
var inst_16885 = (state_16908[(7)]);
var inst_16895 = (state_16908[(2)]);
var state_16908__$1 = state_16908;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16908__$1,(8),inst_16895,inst_16885);
} else {
if((state_val_16909 === (9))){
var state_16908__$1 = state_16908;
var statearr_16919_16941 = state_16908__$1;
(statearr_16919_16941[(2)] = tc);

(statearr_16919_16941[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16909 === (5))){
var inst_16888 = cljs.core.async.close_BANG_(tc);
var inst_16889 = cljs.core.async.close_BANG_(fc);
var state_16908__$1 = (function (){var statearr_16920 = state_16908;
(statearr_16920[(8)] = inst_16888);

return statearr_16920;
})();
var statearr_16921_16942 = state_16908__$1;
(statearr_16921_16942[(2)] = inst_16889);

(statearr_16921_16942[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16909 === (14))){
var inst_16902 = (state_16908[(2)]);
var state_16908__$1 = state_16908;
var statearr_16922_16943 = state_16908__$1;
(statearr_16922_16943[(2)] = inst_16902);

(statearr_16922_16943[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16909 === (10))){
var state_16908__$1 = state_16908;
var statearr_16923_16944 = state_16908__$1;
(statearr_16923_16944[(2)] = fc);

(statearr_16923_16944[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16909 === (8))){
var inst_16897 = (state_16908[(2)]);
var state_16908__$1 = state_16908;
if(cljs.core.truth_(inst_16897)){
var statearr_16924_16945 = state_16908__$1;
(statearr_16924_16945[(1)] = (12));

} else {
var statearr_16925_16946 = state_16908__$1;
(statearr_16925_16946[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16395__auto__ = null;
var cljs$core$async$state_machine__16395__auto____0 = (function (){
var statearr_16926 = [null,null,null,null,null,null,null,null,null];
(statearr_16926[(0)] = cljs$core$async$state_machine__16395__auto__);

(statearr_16926[(1)] = (1));

return statearr_16926;
});
var cljs$core$async$state_machine__16395__auto____1 = (function (state_16908){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_16908);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e16927){var ex__16398__auto__ = e16927;
var statearr_16928_16947 = state_16908;
(statearr_16928_16947[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_16908[(4)]))){
var statearr_16929_16948 = state_16908;
(statearr_16929_16948[(1)] = cljs.core.first((state_16908[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__16949 = state_16908;
state_16908 = G__16949;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$state_machine__16395__auto__ = function(state_16908){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16395__auto____1.call(this,state_16908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16395__auto____0;
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16395__auto____1;
return cljs$core$async$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_16930 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_16930[(6)] = c__16469__auto___16932);

return statearr_16930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_16971){
var state_val_16972 = (state_16971[(1)]);
if((state_val_16972 === (7))){
var inst_16967 = (state_16971[(2)]);
var state_16971__$1 = state_16971;
var statearr_16973_16992 = state_16971__$1;
(statearr_16973_16992[(2)] = inst_16967);

(statearr_16973_16992[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16972 === (1))){
var inst_16950 = init;
var inst_16951 = inst_16950;
var state_16971__$1 = (function (){var statearr_16974 = state_16971;
(statearr_16974[(7)] = inst_16951);

return statearr_16974;
})();
var statearr_16975_16993 = state_16971__$1;
(statearr_16975_16993[(2)] = null);

(statearr_16975_16993[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16972 === (4))){
var inst_16954 = (state_16971[(8)]);
var inst_16954__$1 = (state_16971[(2)]);
var inst_16955 = (inst_16954__$1 == null);
var state_16971__$1 = (function (){var statearr_16976 = state_16971;
(statearr_16976[(8)] = inst_16954__$1);

return statearr_16976;
})();
if(cljs.core.truth_(inst_16955)){
var statearr_16977_16994 = state_16971__$1;
(statearr_16977_16994[(1)] = (5));

} else {
var statearr_16978_16995 = state_16971__$1;
(statearr_16978_16995[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16972 === (6))){
var inst_16951 = (state_16971[(7)]);
var inst_16958 = (state_16971[(9)]);
var inst_16954 = (state_16971[(8)]);
var inst_16958__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_16951,inst_16954) : f.call(null,inst_16951,inst_16954));
var inst_16959 = cljs.core.reduced_QMARK_(inst_16958__$1);
var state_16971__$1 = (function (){var statearr_16979 = state_16971;
(statearr_16979[(9)] = inst_16958__$1);

return statearr_16979;
})();
if(inst_16959){
var statearr_16980_16996 = state_16971__$1;
(statearr_16980_16996[(1)] = (8));

} else {
var statearr_16981_16997 = state_16971__$1;
(statearr_16981_16997[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16972 === (3))){
var inst_16969 = (state_16971[(2)]);
var state_16971__$1 = state_16971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16971__$1,inst_16969);
} else {
if((state_val_16972 === (2))){
var state_16971__$1 = state_16971;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16971__$1,(4),ch);
} else {
if((state_val_16972 === (9))){
var inst_16958 = (state_16971[(9)]);
var inst_16951 = inst_16958;
var state_16971__$1 = (function (){var statearr_16982 = state_16971;
(statearr_16982[(7)] = inst_16951);

return statearr_16982;
})();
var statearr_16983_16998 = state_16971__$1;
(statearr_16983_16998[(2)] = null);

(statearr_16983_16998[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16972 === (5))){
var inst_16951 = (state_16971[(7)]);
var state_16971__$1 = state_16971;
var statearr_16984_16999 = state_16971__$1;
(statearr_16984_16999[(2)] = inst_16951);

(statearr_16984_16999[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16972 === (10))){
var inst_16965 = (state_16971[(2)]);
var state_16971__$1 = state_16971;
var statearr_16985_17000 = state_16971__$1;
(statearr_16985_17000[(2)] = inst_16965);

(statearr_16985_17000[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16972 === (8))){
var inst_16958 = (state_16971[(9)]);
var inst_16961 = cljs.core.deref(inst_16958);
var state_16971__$1 = state_16971;
var statearr_16986_17001 = state_16971__$1;
(statearr_16986_17001[(2)] = inst_16961);

(statearr_16986_17001[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__16395__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16395__auto____0 = (function (){
var statearr_16987 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16987[(0)] = cljs$core$async$reduce_$_state_machine__16395__auto__);

(statearr_16987[(1)] = (1));

return statearr_16987;
});
var cljs$core$async$reduce_$_state_machine__16395__auto____1 = (function (state_16971){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_16971);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e16988){var ex__16398__auto__ = e16988;
var statearr_16989_17002 = state_16971;
(statearr_16989_17002[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_16971[(4)]))){
var statearr_16990_17003 = state_16971;
(statearr_16990_17003[(1)] = cljs.core.first((state_16971[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__17004 = state_16971;
state_16971 = G__17004;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16395__auto__ = function(state_16971){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16395__auto____1.call(this,state_16971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16395__auto____0;
cljs$core$async$reduce_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16395__auto____1;
return cljs$core$async$reduce_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_16991 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_16991[(6)] = c__16469__auto__);

return statearr_16991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_17010){
var state_val_17011 = (state_17010[(1)]);
if((state_val_17011 === (1))){
var inst_17005 = cljs.core.async.reduce(f__$1,init,ch);
var state_17010__$1 = state_17010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17010__$1,(2),inst_17005);
} else {
if((state_val_17011 === (2))){
var inst_17007 = (state_17010[(2)]);
var inst_17008 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_17007) : f__$1.call(null,inst_17007));
var state_17010__$1 = state_17010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17010__$1,inst_17008);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__16395__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16395__auto____0 = (function (){
var statearr_17012 = [null,null,null,null,null,null,null];
(statearr_17012[(0)] = cljs$core$async$transduce_$_state_machine__16395__auto__);

(statearr_17012[(1)] = (1));

return statearr_17012;
});
var cljs$core$async$transduce_$_state_machine__16395__auto____1 = (function (state_17010){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_17010);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e17013){var ex__16398__auto__ = e17013;
var statearr_17014_17017 = state_17010;
(statearr_17014_17017[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_17010[(4)]))){
var statearr_17015_17018 = state_17010;
(statearr_17015_17018[(1)] = cljs.core.first((state_17010[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__17019 = state_17010;
state_17010 = G__17019;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16395__auto__ = function(state_17010){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16395__auto____1.call(this,state_17010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16395__auto____0;
cljs$core$async$transduce_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16395__auto____1;
return cljs$core$async$transduce_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_17016 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_17016[(6)] = c__16469__auto__);

return statearr_17016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__17021 = arguments.length;
switch (G__17021) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_17046){
var state_val_17047 = (state_17046[(1)]);
if((state_val_17047 === (7))){
var inst_17028 = (state_17046[(2)]);
var state_17046__$1 = state_17046;
var statearr_17048_17070 = state_17046__$1;
(statearr_17048_17070[(2)] = inst_17028);

(statearr_17048_17070[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17047 === (1))){
var inst_17022 = cljs.core.seq(coll);
var inst_17023 = inst_17022;
var state_17046__$1 = (function (){var statearr_17049 = state_17046;
(statearr_17049[(7)] = inst_17023);

return statearr_17049;
})();
var statearr_17050_17071 = state_17046__$1;
(statearr_17050_17071[(2)] = null);

(statearr_17050_17071[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17047 === (4))){
var inst_17023 = (state_17046[(7)]);
var inst_17026 = cljs.core.first(inst_17023);
var state_17046__$1 = state_17046;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17046__$1,(7),ch,inst_17026);
} else {
if((state_val_17047 === (13))){
var inst_17040 = (state_17046[(2)]);
var state_17046__$1 = state_17046;
var statearr_17051_17072 = state_17046__$1;
(statearr_17051_17072[(2)] = inst_17040);

(statearr_17051_17072[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17047 === (6))){
var inst_17031 = (state_17046[(2)]);
var state_17046__$1 = state_17046;
if(cljs.core.truth_(inst_17031)){
var statearr_17052_17073 = state_17046__$1;
(statearr_17052_17073[(1)] = (8));

} else {
var statearr_17053_17074 = state_17046__$1;
(statearr_17053_17074[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17047 === (3))){
var inst_17044 = (state_17046[(2)]);
var state_17046__$1 = state_17046;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17046__$1,inst_17044);
} else {
if((state_val_17047 === (12))){
var state_17046__$1 = state_17046;
var statearr_17054_17075 = state_17046__$1;
(statearr_17054_17075[(2)] = null);

(statearr_17054_17075[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17047 === (2))){
var inst_17023 = (state_17046[(7)]);
var state_17046__$1 = state_17046;
if(cljs.core.truth_(inst_17023)){
var statearr_17055_17076 = state_17046__$1;
(statearr_17055_17076[(1)] = (4));

} else {
var statearr_17056_17077 = state_17046__$1;
(statearr_17056_17077[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17047 === (11))){
var inst_17037 = cljs.core.async.close_BANG_(ch);
var state_17046__$1 = state_17046;
var statearr_17057_17078 = state_17046__$1;
(statearr_17057_17078[(2)] = inst_17037);

(statearr_17057_17078[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17047 === (9))){
var state_17046__$1 = state_17046;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17058_17079 = state_17046__$1;
(statearr_17058_17079[(1)] = (11));

} else {
var statearr_17059_17080 = state_17046__$1;
(statearr_17059_17080[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17047 === (5))){
var inst_17023 = (state_17046[(7)]);
var state_17046__$1 = state_17046;
var statearr_17060_17081 = state_17046__$1;
(statearr_17060_17081[(2)] = inst_17023);

(statearr_17060_17081[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17047 === (10))){
var inst_17042 = (state_17046[(2)]);
var state_17046__$1 = state_17046;
var statearr_17061_17082 = state_17046__$1;
(statearr_17061_17082[(2)] = inst_17042);

(statearr_17061_17082[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17047 === (8))){
var inst_17023 = (state_17046[(7)]);
var inst_17033 = cljs.core.next(inst_17023);
var inst_17023__$1 = inst_17033;
var state_17046__$1 = (function (){var statearr_17062 = state_17046;
(statearr_17062[(7)] = inst_17023__$1);

return statearr_17062;
})();
var statearr_17063_17083 = state_17046__$1;
(statearr_17063_17083[(2)] = null);

(statearr_17063_17083[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16395__auto__ = null;
var cljs$core$async$state_machine__16395__auto____0 = (function (){
var statearr_17064 = [null,null,null,null,null,null,null,null];
(statearr_17064[(0)] = cljs$core$async$state_machine__16395__auto__);

(statearr_17064[(1)] = (1));

return statearr_17064;
});
var cljs$core$async$state_machine__16395__auto____1 = (function (state_17046){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_17046);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e17065){var ex__16398__auto__ = e17065;
var statearr_17066_17084 = state_17046;
(statearr_17066_17084[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_17046[(4)]))){
var statearr_17067_17085 = state_17046;
(statearr_17067_17085[(1)] = cljs.core.first((state_17046[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__17086 = state_17046;
state_17046 = G__17086;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$state_machine__16395__auto__ = function(state_17046){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16395__auto____1.call(this,state_17046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16395__auto____0;
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16395__auto____1;
return cljs$core$async$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_17068 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_17068[(6)] = c__16469__auto__);

return statearr_17068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__17088 = arguments.length;
switch (G__17088) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_17090 = (function (_){
var x__4509__auto__ = (((_ == null))?null:_);
var m__4510__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4510__auto__.call(null,_));
} else {
var m__4508__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4508__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_17090(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_17091 = (function (m,ch,close_QMARK_){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4510__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4508__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_17091(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_17092 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_17092(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_17093 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_17093(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17094 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17094 = (function (ch,cs,meta17095){
this.ch = ch;
this.cs = cs;
this.meta17095 = meta17095;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17094.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17096,meta17095__$1){
var self__ = this;
var _17096__$1 = this;
return (new cljs.core.async.t_cljs$core$async17094(self__.ch,self__.cs,meta17095__$1));
}));

(cljs.core.async.t_cljs$core$async17094.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17096){
var self__ = this;
var _17096__$1 = this;
return self__.meta17095;
}));

(cljs.core.async.t_cljs$core$async17094.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17094.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async17094.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17094.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async17094.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async17094.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async17094.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta17095], null);
}));

(cljs.core.async.t_cljs$core$async17094.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17094.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17094");

(cljs.core.async.t_cljs$core$async17094.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async17094");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17094.
 */
cljs.core.async.__GT_t_cljs$core$async17094 = (function cljs$core$async$mult_$___GT_t_cljs$core$async17094(ch__$1,cs__$1,meta17095){
return (new cljs.core.async.t_cljs$core$async17094(ch__$1,cs__$1,meta17095));
});

}

return (new cljs.core.async.t_cljs$core$async17094(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__16469__auto___17313 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_17229){
var state_val_17230 = (state_17229[(1)]);
if((state_val_17230 === (7))){
var inst_17225 = (state_17229[(2)]);
var state_17229__$1 = state_17229;
var statearr_17231_17314 = state_17229__$1;
(statearr_17231_17314[(2)] = inst_17225);

(statearr_17231_17314[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (20))){
var inst_17130 = (state_17229[(7)]);
var inst_17142 = cljs.core.first(inst_17130);
var inst_17143 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17142,(0),null);
var inst_17144 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17142,(1),null);
var state_17229__$1 = (function (){var statearr_17232 = state_17229;
(statearr_17232[(8)] = inst_17143);

return statearr_17232;
})();
if(cljs.core.truth_(inst_17144)){
var statearr_17233_17315 = state_17229__$1;
(statearr_17233_17315[(1)] = (22));

} else {
var statearr_17234_17316 = state_17229__$1;
(statearr_17234_17316[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (27))){
var inst_17174 = (state_17229[(9)]);
var inst_17099 = (state_17229[(10)]);
var inst_17172 = (state_17229[(11)]);
var inst_17179 = (state_17229[(12)]);
var inst_17179__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17172,inst_17174);
var inst_17180 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17179__$1,inst_17099,done);
var state_17229__$1 = (function (){var statearr_17235 = state_17229;
(statearr_17235[(12)] = inst_17179__$1);

return statearr_17235;
})();
if(cljs.core.truth_(inst_17180)){
var statearr_17236_17317 = state_17229__$1;
(statearr_17236_17317[(1)] = (30));

} else {
var statearr_17237_17318 = state_17229__$1;
(statearr_17237_17318[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (1))){
var state_17229__$1 = state_17229;
var statearr_17238_17319 = state_17229__$1;
(statearr_17238_17319[(2)] = null);

(statearr_17238_17319[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (24))){
var inst_17130 = (state_17229[(7)]);
var inst_17149 = (state_17229[(2)]);
var inst_17150 = cljs.core.next(inst_17130);
var inst_17108 = inst_17150;
var inst_17109 = null;
var inst_17110 = (0);
var inst_17111 = (0);
var state_17229__$1 = (function (){var statearr_17239 = state_17229;
(statearr_17239[(13)] = inst_17111);

(statearr_17239[(14)] = inst_17110);

(statearr_17239[(15)] = inst_17109);

(statearr_17239[(16)] = inst_17108);

(statearr_17239[(17)] = inst_17149);

return statearr_17239;
})();
var statearr_17240_17320 = state_17229__$1;
(statearr_17240_17320[(2)] = null);

(statearr_17240_17320[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (39))){
var state_17229__$1 = state_17229;
var statearr_17244_17321 = state_17229__$1;
(statearr_17244_17321[(2)] = null);

(statearr_17244_17321[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (4))){
var inst_17099 = (state_17229[(10)]);
var inst_17099__$1 = (state_17229[(2)]);
var inst_17100 = (inst_17099__$1 == null);
var state_17229__$1 = (function (){var statearr_17245 = state_17229;
(statearr_17245[(10)] = inst_17099__$1);

return statearr_17245;
})();
if(cljs.core.truth_(inst_17100)){
var statearr_17246_17322 = state_17229__$1;
(statearr_17246_17322[(1)] = (5));

} else {
var statearr_17247_17323 = state_17229__$1;
(statearr_17247_17323[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (15))){
var inst_17111 = (state_17229[(13)]);
var inst_17110 = (state_17229[(14)]);
var inst_17109 = (state_17229[(15)]);
var inst_17108 = (state_17229[(16)]);
var inst_17126 = (state_17229[(2)]);
var inst_17127 = (inst_17111 + (1));
var tmp17241 = inst_17110;
var tmp17242 = inst_17109;
var tmp17243 = inst_17108;
var inst_17108__$1 = tmp17243;
var inst_17109__$1 = tmp17242;
var inst_17110__$1 = tmp17241;
var inst_17111__$1 = inst_17127;
var state_17229__$1 = (function (){var statearr_17248 = state_17229;
(statearr_17248[(13)] = inst_17111__$1);

(statearr_17248[(14)] = inst_17110__$1);

(statearr_17248[(18)] = inst_17126);

(statearr_17248[(15)] = inst_17109__$1);

(statearr_17248[(16)] = inst_17108__$1);

return statearr_17248;
})();
var statearr_17249_17324 = state_17229__$1;
(statearr_17249_17324[(2)] = null);

(statearr_17249_17324[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (21))){
var inst_17153 = (state_17229[(2)]);
var state_17229__$1 = state_17229;
var statearr_17253_17325 = state_17229__$1;
(statearr_17253_17325[(2)] = inst_17153);

(statearr_17253_17325[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (31))){
var inst_17179 = (state_17229[(12)]);
var inst_17183 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17179);
var state_17229__$1 = state_17229;
var statearr_17254_17326 = state_17229__$1;
(statearr_17254_17326[(2)] = inst_17183);

(statearr_17254_17326[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (32))){
var inst_17173 = (state_17229[(19)]);
var inst_17174 = (state_17229[(9)]);
var inst_17171 = (state_17229[(20)]);
var inst_17172 = (state_17229[(11)]);
var inst_17185 = (state_17229[(2)]);
var inst_17186 = (inst_17174 + (1));
var tmp17250 = inst_17173;
var tmp17251 = inst_17171;
var tmp17252 = inst_17172;
var inst_17171__$1 = tmp17251;
var inst_17172__$1 = tmp17252;
var inst_17173__$1 = tmp17250;
var inst_17174__$1 = inst_17186;
var state_17229__$1 = (function (){var statearr_17255 = state_17229;
(statearr_17255[(21)] = inst_17185);

(statearr_17255[(19)] = inst_17173__$1);

(statearr_17255[(9)] = inst_17174__$1);

(statearr_17255[(20)] = inst_17171__$1);

(statearr_17255[(11)] = inst_17172__$1);

return statearr_17255;
})();
var statearr_17256_17327 = state_17229__$1;
(statearr_17256_17327[(2)] = null);

(statearr_17256_17327[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (40))){
var inst_17198 = (state_17229[(22)]);
var inst_17202 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17198);
var state_17229__$1 = state_17229;
var statearr_17257_17328 = state_17229__$1;
(statearr_17257_17328[(2)] = inst_17202);

(statearr_17257_17328[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (33))){
var inst_17189 = (state_17229[(23)]);
var inst_17191 = cljs.core.chunked_seq_QMARK_(inst_17189);
var state_17229__$1 = state_17229;
if(inst_17191){
var statearr_17258_17329 = state_17229__$1;
(statearr_17258_17329[(1)] = (36));

} else {
var statearr_17259_17330 = state_17229__$1;
(statearr_17259_17330[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (13))){
var inst_17120 = (state_17229[(24)]);
var inst_17123 = cljs.core.async.close_BANG_(inst_17120);
var state_17229__$1 = state_17229;
var statearr_17260_17331 = state_17229__$1;
(statearr_17260_17331[(2)] = inst_17123);

(statearr_17260_17331[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (22))){
var inst_17143 = (state_17229[(8)]);
var inst_17146 = cljs.core.async.close_BANG_(inst_17143);
var state_17229__$1 = state_17229;
var statearr_17261_17332 = state_17229__$1;
(statearr_17261_17332[(2)] = inst_17146);

(statearr_17261_17332[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (36))){
var inst_17189 = (state_17229[(23)]);
var inst_17193 = cljs.core.chunk_first(inst_17189);
var inst_17194 = cljs.core.chunk_rest(inst_17189);
var inst_17195 = cljs.core.count(inst_17193);
var inst_17171 = inst_17194;
var inst_17172 = inst_17193;
var inst_17173 = inst_17195;
var inst_17174 = (0);
var state_17229__$1 = (function (){var statearr_17262 = state_17229;
(statearr_17262[(19)] = inst_17173);

(statearr_17262[(9)] = inst_17174);

(statearr_17262[(20)] = inst_17171);

(statearr_17262[(11)] = inst_17172);

return statearr_17262;
})();
var statearr_17263_17333 = state_17229__$1;
(statearr_17263_17333[(2)] = null);

(statearr_17263_17333[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (41))){
var inst_17189 = (state_17229[(23)]);
var inst_17204 = (state_17229[(2)]);
var inst_17205 = cljs.core.next(inst_17189);
var inst_17171 = inst_17205;
var inst_17172 = null;
var inst_17173 = (0);
var inst_17174 = (0);
var state_17229__$1 = (function (){var statearr_17264 = state_17229;
(statearr_17264[(19)] = inst_17173);

(statearr_17264[(9)] = inst_17174);

(statearr_17264[(20)] = inst_17171);

(statearr_17264[(11)] = inst_17172);

(statearr_17264[(25)] = inst_17204);

return statearr_17264;
})();
var statearr_17265_17334 = state_17229__$1;
(statearr_17265_17334[(2)] = null);

(statearr_17265_17334[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (43))){
var state_17229__$1 = state_17229;
var statearr_17266_17335 = state_17229__$1;
(statearr_17266_17335[(2)] = null);

(statearr_17266_17335[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (29))){
var inst_17213 = (state_17229[(2)]);
var state_17229__$1 = state_17229;
var statearr_17267_17336 = state_17229__$1;
(statearr_17267_17336[(2)] = inst_17213);

(statearr_17267_17336[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (44))){
var inst_17222 = (state_17229[(2)]);
var state_17229__$1 = (function (){var statearr_17268 = state_17229;
(statearr_17268[(26)] = inst_17222);

return statearr_17268;
})();
var statearr_17269_17337 = state_17229__$1;
(statearr_17269_17337[(2)] = null);

(statearr_17269_17337[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (6))){
var inst_17163 = (state_17229[(27)]);
var inst_17162 = cljs.core.deref(cs);
var inst_17163__$1 = cljs.core.keys(inst_17162);
var inst_17164 = cljs.core.count(inst_17163__$1);
var inst_17165 = cljs.core.reset_BANG_(dctr,inst_17164);
var inst_17170 = cljs.core.seq(inst_17163__$1);
var inst_17171 = inst_17170;
var inst_17172 = null;
var inst_17173 = (0);
var inst_17174 = (0);
var state_17229__$1 = (function (){var statearr_17270 = state_17229;
(statearr_17270[(28)] = inst_17165);

(statearr_17270[(27)] = inst_17163__$1);

(statearr_17270[(19)] = inst_17173);

(statearr_17270[(9)] = inst_17174);

(statearr_17270[(20)] = inst_17171);

(statearr_17270[(11)] = inst_17172);

return statearr_17270;
})();
var statearr_17271_17338 = state_17229__$1;
(statearr_17271_17338[(2)] = null);

(statearr_17271_17338[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (28))){
var inst_17171 = (state_17229[(20)]);
var inst_17189 = (state_17229[(23)]);
var inst_17189__$1 = cljs.core.seq(inst_17171);
var state_17229__$1 = (function (){var statearr_17272 = state_17229;
(statearr_17272[(23)] = inst_17189__$1);

return statearr_17272;
})();
if(inst_17189__$1){
var statearr_17273_17339 = state_17229__$1;
(statearr_17273_17339[(1)] = (33));

} else {
var statearr_17274_17340 = state_17229__$1;
(statearr_17274_17340[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (25))){
var inst_17173 = (state_17229[(19)]);
var inst_17174 = (state_17229[(9)]);
var inst_17176 = (inst_17174 < inst_17173);
var inst_17177 = inst_17176;
var state_17229__$1 = state_17229;
if(cljs.core.truth_(inst_17177)){
var statearr_17275_17341 = state_17229__$1;
(statearr_17275_17341[(1)] = (27));

} else {
var statearr_17276_17342 = state_17229__$1;
(statearr_17276_17342[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (34))){
var state_17229__$1 = state_17229;
var statearr_17277_17343 = state_17229__$1;
(statearr_17277_17343[(2)] = null);

(statearr_17277_17343[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (17))){
var state_17229__$1 = state_17229;
var statearr_17278_17344 = state_17229__$1;
(statearr_17278_17344[(2)] = null);

(statearr_17278_17344[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (3))){
var inst_17227 = (state_17229[(2)]);
var state_17229__$1 = state_17229;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17229__$1,inst_17227);
} else {
if((state_val_17230 === (12))){
var inst_17158 = (state_17229[(2)]);
var state_17229__$1 = state_17229;
var statearr_17279_17345 = state_17229__$1;
(statearr_17279_17345[(2)] = inst_17158);

(statearr_17279_17345[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (2))){
var state_17229__$1 = state_17229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17229__$1,(4),ch);
} else {
if((state_val_17230 === (23))){
var state_17229__$1 = state_17229;
var statearr_17280_17346 = state_17229__$1;
(statearr_17280_17346[(2)] = null);

(statearr_17280_17346[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (35))){
var inst_17211 = (state_17229[(2)]);
var state_17229__$1 = state_17229;
var statearr_17281_17347 = state_17229__$1;
(statearr_17281_17347[(2)] = inst_17211);

(statearr_17281_17347[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (19))){
var inst_17130 = (state_17229[(7)]);
var inst_17134 = cljs.core.chunk_first(inst_17130);
var inst_17135 = cljs.core.chunk_rest(inst_17130);
var inst_17136 = cljs.core.count(inst_17134);
var inst_17108 = inst_17135;
var inst_17109 = inst_17134;
var inst_17110 = inst_17136;
var inst_17111 = (0);
var state_17229__$1 = (function (){var statearr_17282 = state_17229;
(statearr_17282[(13)] = inst_17111);

(statearr_17282[(14)] = inst_17110);

(statearr_17282[(15)] = inst_17109);

(statearr_17282[(16)] = inst_17108);

return statearr_17282;
})();
var statearr_17283_17348 = state_17229__$1;
(statearr_17283_17348[(2)] = null);

(statearr_17283_17348[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (11))){
var inst_17130 = (state_17229[(7)]);
var inst_17108 = (state_17229[(16)]);
var inst_17130__$1 = cljs.core.seq(inst_17108);
var state_17229__$1 = (function (){var statearr_17284 = state_17229;
(statearr_17284[(7)] = inst_17130__$1);

return statearr_17284;
})();
if(inst_17130__$1){
var statearr_17285_17349 = state_17229__$1;
(statearr_17285_17349[(1)] = (16));

} else {
var statearr_17286_17350 = state_17229__$1;
(statearr_17286_17350[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (9))){
var inst_17160 = (state_17229[(2)]);
var state_17229__$1 = state_17229;
var statearr_17287_17351 = state_17229__$1;
(statearr_17287_17351[(2)] = inst_17160);

(statearr_17287_17351[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (5))){
var inst_17106 = cljs.core.deref(cs);
var inst_17107 = cljs.core.seq(inst_17106);
var inst_17108 = inst_17107;
var inst_17109 = null;
var inst_17110 = (0);
var inst_17111 = (0);
var state_17229__$1 = (function (){var statearr_17288 = state_17229;
(statearr_17288[(13)] = inst_17111);

(statearr_17288[(14)] = inst_17110);

(statearr_17288[(15)] = inst_17109);

(statearr_17288[(16)] = inst_17108);

return statearr_17288;
})();
var statearr_17289_17352 = state_17229__$1;
(statearr_17289_17352[(2)] = null);

(statearr_17289_17352[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (14))){
var state_17229__$1 = state_17229;
var statearr_17290_17353 = state_17229__$1;
(statearr_17290_17353[(2)] = null);

(statearr_17290_17353[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (45))){
var inst_17219 = (state_17229[(2)]);
var state_17229__$1 = state_17229;
var statearr_17291_17354 = state_17229__$1;
(statearr_17291_17354[(2)] = inst_17219);

(statearr_17291_17354[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (26))){
var inst_17163 = (state_17229[(27)]);
var inst_17215 = (state_17229[(2)]);
var inst_17216 = cljs.core.seq(inst_17163);
var state_17229__$1 = (function (){var statearr_17292 = state_17229;
(statearr_17292[(29)] = inst_17215);

return statearr_17292;
})();
if(inst_17216){
var statearr_17293_17355 = state_17229__$1;
(statearr_17293_17355[(1)] = (42));

} else {
var statearr_17294_17356 = state_17229__$1;
(statearr_17294_17356[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (16))){
var inst_17130 = (state_17229[(7)]);
var inst_17132 = cljs.core.chunked_seq_QMARK_(inst_17130);
var state_17229__$1 = state_17229;
if(inst_17132){
var statearr_17295_17357 = state_17229__$1;
(statearr_17295_17357[(1)] = (19));

} else {
var statearr_17296_17358 = state_17229__$1;
(statearr_17296_17358[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (38))){
var inst_17208 = (state_17229[(2)]);
var state_17229__$1 = state_17229;
var statearr_17297_17359 = state_17229__$1;
(statearr_17297_17359[(2)] = inst_17208);

(statearr_17297_17359[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (30))){
var state_17229__$1 = state_17229;
var statearr_17298_17360 = state_17229__$1;
(statearr_17298_17360[(2)] = null);

(statearr_17298_17360[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (10))){
var inst_17111 = (state_17229[(13)]);
var inst_17109 = (state_17229[(15)]);
var inst_17119 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17109,inst_17111);
var inst_17120 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17119,(0),null);
var inst_17121 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17119,(1),null);
var state_17229__$1 = (function (){var statearr_17299 = state_17229;
(statearr_17299[(24)] = inst_17120);

return statearr_17299;
})();
if(cljs.core.truth_(inst_17121)){
var statearr_17300_17361 = state_17229__$1;
(statearr_17300_17361[(1)] = (13));

} else {
var statearr_17301_17362 = state_17229__$1;
(statearr_17301_17362[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (18))){
var inst_17156 = (state_17229[(2)]);
var state_17229__$1 = state_17229;
var statearr_17302_17363 = state_17229__$1;
(statearr_17302_17363[(2)] = inst_17156);

(statearr_17302_17363[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (42))){
var state_17229__$1 = state_17229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17229__$1,(45),dchan);
} else {
if((state_val_17230 === (37))){
var inst_17198 = (state_17229[(22)]);
var inst_17099 = (state_17229[(10)]);
var inst_17189 = (state_17229[(23)]);
var inst_17198__$1 = cljs.core.first(inst_17189);
var inst_17199 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17198__$1,inst_17099,done);
var state_17229__$1 = (function (){var statearr_17303 = state_17229;
(statearr_17303[(22)] = inst_17198__$1);

return statearr_17303;
})();
if(cljs.core.truth_(inst_17199)){
var statearr_17304_17364 = state_17229__$1;
(statearr_17304_17364[(1)] = (39));

} else {
var statearr_17305_17365 = state_17229__$1;
(statearr_17305_17365[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17230 === (8))){
var inst_17111 = (state_17229[(13)]);
var inst_17110 = (state_17229[(14)]);
var inst_17113 = (inst_17111 < inst_17110);
var inst_17114 = inst_17113;
var state_17229__$1 = state_17229;
if(cljs.core.truth_(inst_17114)){
var statearr_17306_17366 = state_17229__$1;
(statearr_17306_17366[(1)] = (10));

} else {
var statearr_17307_17367 = state_17229__$1;
(statearr_17307_17367[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__16395__auto__ = null;
var cljs$core$async$mult_$_state_machine__16395__auto____0 = (function (){
var statearr_17308 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17308[(0)] = cljs$core$async$mult_$_state_machine__16395__auto__);

(statearr_17308[(1)] = (1));

return statearr_17308;
});
var cljs$core$async$mult_$_state_machine__16395__auto____1 = (function (state_17229){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_17229);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e17309){var ex__16398__auto__ = e17309;
var statearr_17310_17368 = state_17229;
(statearr_17310_17368[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_17229[(4)]))){
var statearr_17311_17369 = state_17229;
(statearr_17311_17369[(1)] = cljs.core.first((state_17229[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__17370 = state_17229;
state_17229 = G__17370;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16395__auto__ = function(state_17229){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16395__auto____1.call(this,state_17229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16395__auto____0;
cljs$core$async$mult_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16395__auto____1;
return cljs$core$async$mult_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_17312 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_17312[(6)] = c__16469__auto___17313);

return statearr_17312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__17372 = arguments.length;
switch (G__17372) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_17374 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_17374(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_17375 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_17375(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_17376 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_17376(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_17377 = (function (m,state_map){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4510__auto__.call(null,m,state_map));
} else {
var m__4508__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4508__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_17377(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_17378 = (function (m,mode){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4510__auto__.call(null,m,mode));
} else {
var m__4508__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4508__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_17378(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___17388 = arguments.length;
var i__4819__auto___17389 = (0);
while(true){
if((i__4819__auto___17389 < len__4818__auto___17388)){
args__4824__auto__.push((arguments[i__4819__auto___17389]));

var G__17390 = (i__4819__auto___17389 + (1));
i__4819__auto___17389 = G__17390;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((3) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4825__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__17383){
var map__17384 = p__17383;
var map__17384__$1 = cljs.core.__destructure_map(map__17384);
var opts = map__17384__$1;
var statearr_17385_17391 = state;
(statearr_17385_17391[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_17386_17392 = state;
(statearr_17386_17392[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_17387_17393 = state;
(statearr_17387_17393[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq17379){
var G__17380 = cljs.core.first(seq17379);
var seq17379__$1 = cljs.core.next(seq17379);
var G__17381 = cljs.core.first(seq17379__$1);
var seq17379__$2 = cljs.core.next(seq17379__$1);
var G__17382 = cljs.core.first(seq17379__$2);
var seq17379__$3 = cljs.core.next(seq17379__$2);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17380,G__17381,G__17382,seq17379__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17394 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17394 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta17395){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta17395 = meta17395;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17394.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17396,meta17395__$1){
var self__ = this;
var _17396__$1 = this;
return (new cljs.core.async.t_cljs$core$async17394(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta17395__$1));
}));

(cljs.core.async.t_cljs$core$async17394.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17396){
var self__ = this;
var _17396__$1 = this;
return self__.meta17395;
}));

(cljs.core.async.t_cljs$core$async17394.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17394.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async17394.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17394.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17394.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17394.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17394.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17394.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17394.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta17395], null);
}));

(cljs.core.async.t_cljs$core$async17394.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17394.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17394");

(cljs.core.async.t_cljs$core$async17394.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async17394");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17394.
 */
cljs.core.async.__GT_t_cljs$core$async17394 = (function cljs$core$async$mix_$___GT_t_cljs$core$async17394(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta17395){
return (new cljs.core.async.t_cljs$core$async17394(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta17395));
});

}

return (new cljs.core.async.t_cljs$core$async17394(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16469__auto___17509 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_17464){
var state_val_17465 = (state_17464[(1)]);
if((state_val_17465 === (7))){
var inst_17424 = (state_17464[(2)]);
var state_17464__$1 = state_17464;
if(cljs.core.truth_(inst_17424)){
var statearr_17466_17510 = state_17464__$1;
(statearr_17466_17510[(1)] = (8));

} else {
var statearr_17467_17511 = state_17464__$1;
(statearr_17467_17511[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (20))){
var inst_17417 = (state_17464[(7)]);
var state_17464__$1 = state_17464;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17464__$1,(23),out,inst_17417);
} else {
if((state_val_17465 === (1))){
var inst_17400 = calc_state();
var inst_17401 = cljs.core.__destructure_map(inst_17400);
var inst_17402 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17401,cljs.core.cst$kw$solos);
var inst_17403 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17401,cljs.core.cst$kw$mutes);
var inst_17404 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17401,cljs.core.cst$kw$reads);
var inst_17405 = inst_17400;
var state_17464__$1 = (function (){var statearr_17468 = state_17464;
(statearr_17468[(8)] = inst_17404);

(statearr_17468[(9)] = inst_17402);

(statearr_17468[(10)] = inst_17403);

(statearr_17468[(11)] = inst_17405);

return statearr_17468;
})();
var statearr_17469_17512 = state_17464__$1;
(statearr_17469_17512[(2)] = null);

(statearr_17469_17512[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (24))){
var inst_17408 = (state_17464[(12)]);
var inst_17405 = inst_17408;
var state_17464__$1 = (function (){var statearr_17470 = state_17464;
(statearr_17470[(11)] = inst_17405);

return statearr_17470;
})();
var statearr_17471_17513 = state_17464__$1;
(statearr_17471_17513[(2)] = null);

(statearr_17471_17513[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (4))){
var inst_17417 = (state_17464[(7)]);
var inst_17419 = (state_17464[(13)]);
var inst_17416 = (state_17464[(2)]);
var inst_17417__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17416,(0),null);
var inst_17418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17416,(1),null);
var inst_17419__$1 = (inst_17417__$1 == null);
var state_17464__$1 = (function (){var statearr_17472 = state_17464;
(statearr_17472[(14)] = inst_17418);

(statearr_17472[(7)] = inst_17417__$1);

(statearr_17472[(13)] = inst_17419__$1);

return statearr_17472;
})();
if(cljs.core.truth_(inst_17419__$1)){
var statearr_17473_17514 = state_17464__$1;
(statearr_17473_17514[(1)] = (5));

} else {
var statearr_17474_17515 = state_17464__$1;
(statearr_17474_17515[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (15))){
var inst_17438 = (state_17464[(15)]);
var inst_17409 = (state_17464[(16)]);
var inst_17438__$1 = cljs.core.empty_QMARK_(inst_17409);
var state_17464__$1 = (function (){var statearr_17475 = state_17464;
(statearr_17475[(15)] = inst_17438__$1);

return statearr_17475;
})();
if(inst_17438__$1){
var statearr_17476_17516 = state_17464__$1;
(statearr_17476_17516[(1)] = (17));

} else {
var statearr_17477_17517 = state_17464__$1;
(statearr_17477_17517[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (21))){
var inst_17408 = (state_17464[(12)]);
var inst_17405 = inst_17408;
var state_17464__$1 = (function (){var statearr_17478 = state_17464;
(statearr_17478[(11)] = inst_17405);

return statearr_17478;
})();
var statearr_17479_17518 = state_17464__$1;
(statearr_17479_17518[(2)] = null);

(statearr_17479_17518[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (13))){
var inst_17431 = (state_17464[(2)]);
var inst_17432 = calc_state();
var inst_17405 = inst_17432;
var state_17464__$1 = (function (){var statearr_17480 = state_17464;
(statearr_17480[(11)] = inst_17405);

(statearr_17480[(17)] = inst_17431);

return statearr_17480;
})();
var statearr_17481_17519 = state_17464__$1;
(statearr_17481_17519[(2)] = null);

(statearr_17481_17519[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (22))){
var inst_17458 = (state_17464[(2)]);
var state_17464__$1 = state_17464;
var statearr_17482_17520 = state_17464__$1;
(statearr_17482_17520[(2)] = inst_17458);

(statearr_17482_17520[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (6))){
var inst_17418 = (state_17464[(14)]);
var inst_17422 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17418,change);
var state_17464__$1 = state_17464;
var statearr_17483_17521 = state_17464__$1;
(statearr_17483_17521[(2)] = inst_17422);

(statearr_17483_17521[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (25))){
var state_17464__$1 = state_17464;
var statearr_17484_17522 = state_17464__$1;
(statearr_17484_17522[(2)] = null);

(statearr_17484_17522[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (17))){
var inst_17418 = (state_17464[(14)]);
var inst_17410 = (state_17464[(18)]);
var inst_17440 = (inst_17410.cljs$core$IFn$_invoke$arity$1 ? inst_17410.cljs$core$IFn$_invoke$arity$1(inst_17418) : inst_17410.call(null,inst_17418));
var inst_17441 = cljs.core.not(inst_17440);
var state_17464__$1 = state_17464;
var statearr_17485_17523 = state_17464__$1;
(statearr_17485_17523[(2)] = inst_17441);

(statearr_17485_17523[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (3))){
var inst_17462 = (state_17464[(2)]);
var state_17464__$1 = state_17464;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17464__$1,inst_17462);
} else {
if((state_val_17465 === (12))){
var state_17464__$1 = state_17464;
var statearr_17486_17524 = state_17464__$1;
(statearr_17486_17524[(2)] = null);

(statearr_17486_17524[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (2))){
var inst_17408 = (state_17464[(12)]);
var inst_17405 = (state_17464[(11)]);
var inst_17408__$1 = cljs.core.__destructure_map(inst_17405);
var inst_17409 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17408__$1,cljs.core.cst$kw$solos);
var inst_17410 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17408__$1,cljs.core.cst$kw$mutes);
var inst_17411 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17408__$1,cljs.core.cst$kw$reads);
var state_17464__$1 = (function (){var statearr_17487 = state_17464;
(statearr_17487[(12)] = inst_17408__$1);

(statearr_17487[(18)] = inst_17410);

(statearr_17487[(16)] = inst_17409);

return statearr_17487;
})();
return cljs.core.async.ioc_alts_BANG_(state_17464__$1,(4),inst_17411);
} else {
if((state_val_17465 === (23))){
var inst_17449 = (state_17464[(2)]);
var state_17464__$1 = state_17464;
if(cljs.core.truth_(inst_17449)){
var statearr_17488_17525 = state_17464__$1;
(statearr_17488_17525[(1)] = (24));

} else {
var statearr_17489_17526 = state_17464__$1;
(statearr_17489_17526[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (19))){
var inst_17444 = (state_17464[(2)]);
var state_17464__$1 = state_17464;
var statearr_17490_17527 = state_17464__$1;
(statearr_17490_17527[(2)] = inst_17444);

(statearr_17490_17527[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (11))){
var inst_17418 = (state_17464[(14)]);
var inst_17428 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_17418);
var state_17464__$1 = state_17464;
var statearr_17491_17528 = state_17464__$1;
(statearr_17491_17528[(2)] = inst_17428);

(statearr_17491_17528[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (9))){
var inst_17418 = (state_17464[(14)]);
var inst_17435 = (state_17464[(19)]);
var inst_17409 = (state_17464[(16)]);
var inst_17435__$1 = (inst_17409.cljs$core$IFn$_invoke$arity$1 ? inst_17409.cljs$core$IFn$_invoke$arity$1(inst_17418) : inst_17409.call(null,inst_17418));
var state_17464__$1 = (function (){var statearr_17492 = state_17464;
(statearr_17492[(19)] = inst_17435__$1);

return statearr_17492;
})();
if(cljs.core.truth_(inst_17435__$1)){
var statearr_17493_17529 = state_17464__$1;
(statearr_17493_17529[(1)] = (14));

} else {
var statearr_17494_17530 = state_17464__$1;
(statearr_17494_17530[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (5))){
var inst_17419 = (state_17464[(13)]);
var state_17464__$1 = state_17464;
var statearr_17495_17531 = state_17464__$1;
(statearr_17495_17531[(2)] = inst_17419);

(statearr_17495_17531[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (14))){
var inst_17435 = (state_17464[(19)]);
var state_17464__$1 = state_17464;
var statearr_17496_17532 = state_17464__$1;
(statearr_17496_17532[(2)] = inst_17435);

(statearr_17496_17532[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (26))){
var inst_17454 = (state_17464[(2)]);
var state_17464__$1 = state_17464;
var statearr_17497_17533 = state_17464__$1;
(statearr_17497_17533[(2)] = inst_17454);

(statearr_17497_17533[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (16))){
var inst_17446 = (state_17464[(2)]);
var state_17464__$1 = state_17464;
if(cljs.core.truth_(inst_17446)){
var statearr_17498_17534 = state_17464__$1;
(statearr_17498_17534[(1)] = (20));

} else {
var statearr_17499_17535 = state_17464__$1;
(statearr_17499_17535[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (10))){
var inst_17460 = (state_17464[(2)]);
var state_17464__$1 = state_17464;
var statearr_17500_17536 = state_17464__$1;
(statearr_17500_17536[(2)] = inst_17460);

(statearr_17500_17536[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (18))){
var inst_17438 = (state_17464[(15)]);
var state_17464__$1 = state_17464;
var statearr_17501_17537 = state_17464__$1;
(statearr_17501_17537[(2)] = inst_17438);

(statearr_17501_17537[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17465 === (8))){
var inst_17417 = (state_17464[(7)]);
var inst_17426 = (inst_17417 == null);
var state_17464__$1 = state_17464;
if(cljs.core.truth_(inst_17426)){
var statearr_17502_17538 = state_17464__$1;
(statearr_17502_17538[(1)] = (11));

} else {
var statearr_17503_17539 = state_17464__$1;
(statearr_17503_17539[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__16395__auto__ = null;
var cljs$core$async$mix_$_state_machine__16395__auto____0 = (function (){
var statearr_17504 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17504[(0)] = cljs$core$async$mix_$_state_machine__16395__auto__);

(statearr_17504[(1)] = (1));

return statearr_17504;
});
var cljs$core$async$mix_$_state_machine__16395__auto____1 = (function (state_17464){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_17464);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e17505){var ex__16398__auto__ = e17505;
var statearr_17506_17540 = state_17464;
(statearr_17506_17540[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_17464[(4)]))){
var statearr_17507_17541 = state_17464;
(statearr_17507_17541[(1)] = cljs.core.first((state_17464[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__17542 = state_17464;
state_17464 = G__17542;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16395__auto__ = function(state_17464){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16395__auto____1.call(this,state_17464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16395__auto____0;
cljs$core$async$mix_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16395__auto____1;
return cljs$core$async$mix_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_17508 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_17508[(6)] = c__16469__auto___17509);

return statearr_17508;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_17545 = (function (p,v,ch,close_QMARK_){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4510__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4508__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_17545(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_17546 = (function (p,v,ch){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4510__auto__.call(null,p,v,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4508__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_17546(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_17547 = (function() {
var G__17548 = null;
var G__17548__1 = (function (p){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4510__auto__.call(null,p));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4508__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__17548__2 = (function (p,v){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4510__auto__.call(null,p,v));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4508__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__17548 = function(p,v){
switch(arguments.length){
case 1:
return G__17548__1.call(this,p);
case 2:
return G__17548__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17548.cljs$core$IFn$_invoke$arity$1 = G__17548__1;
G__17548.cljs$core$IFn$_invoke$arity$2 = G__17548__2;
return G__17548;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__17544 = arguments.length;
switch (G__17544) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_17547.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_17547.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__17552 = arguments.length;
switch (G__17552) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__17550_SHARP_){
if(cljs.core.truth_((p1__17550_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17550_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__17550_SHARP_.call(null,topic)))){
return p1__17550_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__17550_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17553 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17553 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta17554){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta17554 = meta17554;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17553.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17555,meta17554__$1){
var self__ = this;
var _17555__$1 = this;
return (new cljs.core.async.t_cljs$core$async17553(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta17554__$1));
}));

(cljs.core.async.t_cljs$core$async17553.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17555){
var self__ = this;
var _17555__$1 = this;
return self__.meta17554;
}));

(cljs.core.async.t_cljs$core$async17553.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17553.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async17553.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17553.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async17553.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async17553.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async17553.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async17553.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta17554], null);
}));

(cljs.core.async.t_cljs$core$async17553.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17553.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17553");

(cljs.core.async.t_cljs$core$async17553.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async17553");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17553.
 */
cljs.core.async.__GT_t_cljs$core$async17553 = (function cljs$core$async$__GT_t_cljs$core$async17553(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta17554){
return (new cljs.core.async.t_cljs$core$async17553(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta17554));
});

}

return (new cljs.core.async.t_cljs$core$async17553(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16469__auto___17674 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_17627){
var state_val_17628 = (state_17627[(1)]);
if((state_val_17628 === (7))){
var inst_17623 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17629_17675 = state_17627__$1;
(statearr_17629_17675[(2)] = inst_17623);

(statearr_17629_17675[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (20))){
var state_17627__$1 = state_17627;
var statearr_17630_17676 = state_17627__$1;
(statearr_17630_17676[(2)] = null);

(statearr_17630_17676[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (1))){
var state_17627__$1 = state_17627;
var statearr_17631_17677 = state_17627__$1;
(statearr_17631_17677[(2)] = null);

(statearr_17631_17677[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (24))){
var inst_17606 = (state_17627[(7)]);
var inst_17615 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_17606);
var state_17627__$1 = state_17627;
var statearr_17632_17678 = state_17627__$1;
(statearr_17632_17678[(2)] = inst_17615);

(statearr_17632_17678[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (4))){
var inst_17558 = (state_17627[(8)]);
var inst_17558__$1 = (state_17627[(2)]);
var inst_17559 = (inst_17558__$1 == null);
var state_17627__$1 = (function (){var statearr_17633 = state_17627;
(statearr_17633[(8)] = inst_17558__$1);

return statearr_17633;
})();
if(cljs.core.truth_(inst_17559)){
var statearr_17634_17679 = state_17627__$1;
(statearr_17634_17679[(1)] = (5));

} else {
var statearr_17635_17680 = state_17627__$1;
(statearr_17635_17680[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (15))){
var inst_17600 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17636_17681 = state_17627__$1;
(statearr_17636_17681[(2)] = inst_17600);

(statearr_17636_17681[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (21))){
var inst_17620 = (state_17627[(2)]);
var state_17627__$1 = (function (){var statearr_17637 = state_17627;
(statearr_17637[(9)] = inst_17620);

return statearr_17637;
})();
var statearr_17638_17682 = state_17627__$1;
(statearr_17638_17682[(2)] = null);

(statearr_17638_17682[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (13))){
var inst_17582 = (state_17627[(10)]);
var inst_17584 = cljs.core.chunked_seq_QMARK_(inst_17582);
var state_17627__$1 = state_17627;
if(inst_17584){
var statearr_17639_17683 = state_17627__$1;
(statearr_17639_17683[(1)] = (16));

} else {
var statearr_17640_17684 = state_17627__$1;
(statearr_17640_17684[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (22))){
var inst_17612 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
if(cljs.core.truth_(inst_17612)){
var statearr_17641_17685 = state_17627__$1;
(statearr_17641_17685[(1)] = (23));

} else {
var statearr_17642_17686 = state_17627__$1;
(statearr_17642_17686[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (6))){
var inst_17558 = (state_17627[(8)]);
var inst_17606 = (state_17627[(7)]);
var inst_17608 = (state_17627[(11)]);
var inst_17606__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_17558) : topic_fn.call(null,inst_17558));
var inst_17607 = cljs.core.deref(mults);
var inst_17608__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17607,inst_17606__$1);
var state_17627__$1 = (function (){var statearr_17643 = state_17627;
(statearr_17643[(7)] = inst_17606__$1);

(statearr_17643[(11)] = inst_17608__$1);

return statearr_17643;
})();
if(cljs.core.truth_(inst_17608__$1)){
var statearr_17644_17687 = state_17627__$1;
(statearr_17644_17687[(1)] = (19));

} else {
var statearr_17645_17688 = state_17627__$1;
(statearr_17645_17688[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (25))){
var inst_17617 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17646_17689 = state_17627__$1;
(statearr_17646_17689[(2)] = inst_17617);

(statearr_17646_17689[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (17))){
var inst_17582 = (state_17627[(10)]);
var inst_17591 = cljs.core.first(inst_17582);
var inst_17592 = cljs.core.async.muxch_STAR_(inst_17591);
var inst_17593 = cljs.core.async.close_BANG_(inst_17592);
var inst_17594 = cljs.core.next(inst_17582);
var inst_17568 = inst_17594;
var inst_17569 = null;
var inst_17570 = (0);
var inst_17571 = (0);
var state_17627__$1 = (function (){var statearr_17647 = state_17627;
(statearr_17647[(12)] = inst_17593);

(statearr_17647[(13)] = inst_17568);

(statearr_17647[(14)] = inst_17571);

(statearr_17647[(15)] = inst_17570);

(statearr_17647[(16)] = inst_17569);

return statearr_17647;
})();
var statearr_17648_17690 = state_17627__$1;
(statearr_17648_17690[(2)] = null);

(statearr_17648_17690[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (3))){
var inst_17625 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17627__$1,inst_17625);
} else {
if((state_val_17628 === (12))){
var inst_17602 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17649_17691 = state_17627__$1;
(statearr_17649_17691[(2)] = inst_17602);

(statearr_17649_17691[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (2))){
var state_17627__$1 = state_17627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17627__$1,(4),ch);
} else {
if((state_val_17628 === (23))){
var state_17627__$1 = state_17627;
var statearr_17650_17692 = state_17627__$1;
(statearr_17650_17692[(2)] = null);

(statearr_17650_17692[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (19))){
var inst_17558 = (state_17627[(8)]);
var inst_17608 = (state_17627[(11)]);
var inst_17610 = cljs.core.async.muxch_STAR_(inst_17608);
var state_17627__$1 = state_17627;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17627__$1,(22),inst_17610,inst_17558);
} else {
if((state_val_17628 === (11))){
var inst_17582 = (state_17627[(10)]);
var inst_17568 = (state_17627[(13)]);
var inst_17582__$1 = cljs.core.seq(inst_17568);
var state_17627__$1 = (function (){var statearr_17651 = state_17627;
(statearr_17651[(10)] = inst_17582__$1);

return statearr_17651;
})();
if(inst_17582__$1){
var statearr_17652_17693 = state_17627__$1;
(statearr_17652_17693[(1)] = (13));

} else {
var statearr_17653_17694 = state_17627__$1;
(statearr_17653_17694[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (9))){
var inst_17604 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17654_17695 = state_17627__$1;
(statearr_17654_17695[(2)] = inst_17604);

(statearr_17654_17695[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (5))){
var inst_17565 = cljs.core.deref(mults);
var inst_17566 = cljs.core.vals(inst_17565);
var inst_17567 = cljs.core.seq(inst_17566);
var inst_17568 = inst_17567;
var inst_17569 = null;
var inst_17570 = (0);
var inst_17571 = (0);
var state_17627__$1 = (function (){var statearr_17655 = state_17627;
(statearr_17655[(13)] = inst_17568);

(statearr_17655[(14)] = inst_17571);

(statearr_17655[(15)] = inst_17570);

(statearr_17655[(16)] = inst_17569);

return statearr_17655;
})();
var statearr_17656_17696 = state_17627__$1;
(statearr_17656_17696[(2)] = null);

(statearr_17656_17696[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (14))){
var state_17627__$1 = state_17627;
var statearr_17660_17697 = state_17627__$1;
(statearr_17660_17697[(2)] = null);

(statearr_17660_17697[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (16))){
var inst_17582 = (state_17627[(10)]);
var inst_17586 = cljs.core.chunk_first(inst_17582);
var inst_17587 = cljs.core.chunk_rest(inst_17582);
var inst_17588 = cljs.core.count(inst_17586);
var inst_17568 = inst_17587;
var inst_17569 = inst_17586;
var inst_17570 = inst_17588;
var inst_17571 = (0);
var state_17627__$1 = (function (){var statearr_17661 = state_17627;
(statearr_17661[(13)] = inst_17568);

(statearr_17661[(14)] = inst_17571);

(statearr_17661[(15)] = inst_17570);

(statearr_17661[(16)] = inst_17569);

return statearr_17661;
})();
var statearr_17662_17698 = state_17627__$1;
(statearr_17662_17698[(2)] = null);

(statearr_17662_17698[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (10))){
var inst_17568 = (state_17627[(13)]);
var inst_17571 = (state_17627[(14)]);
var inst_17570 = (state_17627[(15)]);
var inst_17569 = (state_17627[(16)]);
var inst_17576 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17569,inst_17571);
var inst_17577 = cljs.core.async.muxch_STAR_(inst_17576);
var inst_17578 = cljs.core.async.close_BANG_(inst_17577);
var inst_17579 = (inst_17571 + (1));
var tmp17657 = inst_17568;
var tmp17658 = inst_17570;
var tmp17659 = inst_17569;
var inst_17568__$1 = tmp17657;
var inst_17569__$1 = tmp17659;
var inst_17570__$1 = tmp17658;
var inst_17571__$1 = inst_17579;
var state_17627__$1 = (function (){var statearr_17663 = state_17627;
(statearr_17663[(13)] = inst_17568__$1);

(statearr_17663[(14)] = inst_17571__$1);

(statearr_17663[(15)] = inst_17570__$1);

(statearr_17663[(16)] = inst_17569__$1);

(statearr_17663[(17)] = inst_17578);

return statearr_17663;
})();
var statearr_17664_17699 = state_17627__$1;
(statearr_17664_17699[(2)] = null);

(statearr_17664_17699[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (18))){
var inst_17597 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17665_17700 = state_17627__$1;
(statearr_17665_17700[(2)] = inst_17597);

(statearr_17665_17700[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (8))){
var inst_17571 = (state_17627[(14)]);
var inst_17570 = (state_17627[(15)]);
var inst_17573 = (inst_17571 < inst_17570);
var inst_17574 = inst_17573;
var state_17627__$1 = state_17627;
if(cljs.core.truth_(inst_17574)){
var statearr_17666_17701 = state_17627__$1;
(statearr_17666_17701[(1)] = (10));

} else {
var statearr_17667_17702 = state_17627__$1;
(statearr_17667_17702[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16395__auto__ = null;
var cljs$core$async$state_machine__16395__auto____0 = (function (){
var statearr_17668 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17668[(0)] = cljs$core$async$state_machine__16395__auto__);

(statearr_17668[(1)] = (1));

return statearr_17668;
});
var cljs$core$async$state_machine__16395__auto____1 = (function (state_17627){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_17627);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e17669){var ex__16398__auto__ = e17669;
var statearr_17670_17703 = state_17627;
(statearr_17670_17703[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_17627[(4)]))){
var statearr_17671_17704 = state_17627;
(statearr_17671_17704[(1)] = cljs.core.first((state_17627[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__17705 = state_17627;
state_17627 = G__17705;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$state_machine__16395__auto__ = function(state_17627){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16395__auto____1.call(this,state_17627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16395__auto____0;
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16395__auto____1;
return cljs$core$async$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_17672 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_17672[(6)] = c__16469__auto___17674);

return statearr_17672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__17707 = arguments.length;
switch (G__17707) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__17710 = arguments.length;
switch (G__17710) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__17713 = arguments.length;
switch (G__17713) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__16469__auto___17791 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_17756){
var state_val_17757 = (state_17756[(1)]);
if((state_val_17757 === (7))){
var state_17756__$1 = state_17756;
var statearr_17758_17792 = state_17756__$1;
(statearr_17758_17792[(2)] = null);

(statearr_17758_17792[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (1))){
var state_17756__$1 = state_17756;
var statearr_17759_17793 = state_17756__$1;
(statearr_17759_17793[(2)] = null);

(statearr_17759_17793[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (4))){
var inst_17717 = (state_17756[(7)]);
var inst_17716 = (state_17756[(8)]);
var inst_17719 = (inst_17717 < inst_17716);
var state_17756__$1 = state_17756;
if(cljs.core.truth_(inst_17719)){
var statearr_17760_17794 = state_17756__$1;
(statearr_17760_17794[(1)] = (6));

} else {
var statearr_17761_17795 = state_17756__$1;
(statearr_17761_17795[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (15))){
var inst_17742 = (state_17756[(9)]);
var inst_17747 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_17742);
var state_17756__$1 = state_17756;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17756__$1,(17),out,inst_17747);
} else {
if((state_val_17757 === (13))){
var inst_17742 = (state_17756[(9)]);
var inst_17742__$1 = (state_17756[(2)]);
var inst_17743 = cljs.core.some(cljs.core.nil_QMARK_,inst_17742__$1);
var state_17756__$1 = (function (){var statearr_17762 = state_17756;
(statearr_17762[(9)] = inst_17742__$1);

return statearr_17762;
})();
if(cljs.core.truth_(inst_17743)){
var statearr_17763_17796 = state_17756__$1;
(statearr_17763_17796[(1)] = (14));

} else {
var statearr_17764_17797 = state_17756__$1;
(statearr_17764_17797[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (6))){
var state_17756__$1 = state_17756;
var statearr_17765_17798 = state_17756__$1;
(statearr_17765_17798[(2)] = null);

(statearr_17765_17798[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (17))){
var inst_17749 = (state_17756[(2)]);
var state_17756__$1 = (function (){var statearr_17767 = state_17756;
(statearr_17767[(10)] = inst_17749);

return statearr_17767;
})();
var statearr_17768_17799 = state_17756__$1;
(statearr_17768_17799[(2)] = null);

(statearr_17768_17799[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (3))){
var inst_17754 = (state_17756[(2)]);
var state_17756__$1 = state_17756;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17756__$1,inst_17754);
} else {
if((state_val_17757 === (12))){
var _ = (function (){var statearr_17769 = state_17756;
(statearr_17769[(4)] = cljs.core.rest((state_17756[(4)])));

return statearr_17769;
})();
var state_17756__$1 = state_17756;
var ex17766 = (state_17756__$1[(2)]);
var statearr_17770_17800 = state_17756__$1;
(statearr_17770_17800[(5)] = ex17766);


if((ex17766 instanceof Object)){
var statearr_17771_17801 = state_17756__$1;
(statearr_17771_17801[(1)] = (11));

(statearr_17771_17801[(5)] = null);

} else {
throw ex17766;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (2))){
var inst_17715 = cljs.core.reset_BANG_(dctr,cnt);
var inst_17716 = cnt;
var inst_17717 = (0);
var state_17756__$1 = (function (){var statearr_17772 = state_17756;
(statearr_17772[(7)] = inst_17717);

(statearr_17772[(8)] = inst_17716);

(statearr_17772[(11)] = inst_17715);

return statearr_17772;
})();
var statearr_17773_17802 = state_17756__$1;
(statearr_17773_17802[(2)] = null);

(statearr_17773_17802[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (11))){
var inst_17721 = (state_17756[(2)]);
var inst_17722 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_17756__$1 = (function (){var statearr_17774 = state_17756;
(statearr_17774[(12)] = inst_17721);

return statearr_17774;
})();
var statearr_17775_17803 = state_17756__$1;
(statearr_17775_17803[(2)] = inst_17722);

(statearr_17775_17803[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (9))){
var inst_17717 = (state_17756[(7)]);
var _ = (function (){var statearr_17776 = state_17756;
(statearr_17776[(4)] = cljs.core.cons((12),(state_17756[(4)])));

return statearr_17776;
})();
var inst_17728 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_17717) : chs__$1.call(null,inst_17717));
var inst_17729 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_17717) : done.call(null,inst_17717));
var inst_17730 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_17728,inst_17729);
var ___$1 = (function (){var statearr_17777 = state_17756;
(statearr_17777[(4)] = cljs.core.rest((state_17756[(4)])));

return statearr_17777;
})();
var state_17756__$1 = state_17756;
var statearr_17778_17804 = state_17756__$1;
(statearr_17778_17804[(2)] = inst_17730);

(statearr_17778_17804[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (5))){
var inst_17740 = (state_17756[(2)]);
var state_17756__$1 = (function (){var statearr_17779 = state_17756;
(statearr_17779[(13)] = inst_17740);

return statearr_17779;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17756__$1,(13),dchan);
} else {
if((state_val_17757 === (14))){
var inst_17745 = cljs.core.async.close_BANG_(out);
var state_17756__$1 = state_17756;
var statearr_17780_17805 = state_17756__$1;
(statearr_17780_17805[(2)] = inst_17745);

(statearr_17780_17805[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (16))){
var inst_17752 = (state_17756[(2)]);
var state_17756__$1 = state_17756;
var statearr_17781_17806 = state_17756__$1;
(statearr_17781_17806[(2)] = inst_17752);

(statearr_17781_17806[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (10))){
var inst_17717 = (state_17756[(7)]);
var inst_17733 = (state_17756[(2)]);
var inst_17734 = (inst_17717 + (1));
var inst_17717__$1 = inst_17734;
var state_17756__$1 = (function (){var statearr_17782 = state_17756;
(statearr_17782[(7)] = inst_17717__$1);

(statearr_17782[(14)] = inst_17733);

return statearr_17782;
})();
var statearr_17783_17807 = state_17756__$1;
(statearr_17783_17807[(2)] = null);

(statearr_17783_17807[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17757 === (8))){
var inst_17738 = (state_17756[(2)]);
var state_17756__$1 = state_17756;
var statearr_17784_17808 = state_17756__$1;
(statearr_17784_17808[(2)] = inst_17738);

(statearr_17784_17808[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16395__auto__ = null;
var cljs$core$async$state_machine__16395__auto____0 = (function (){
var statearr_17785 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17785[(0)] = cljs$core$async$state_machine__16395__auto__);

(statearr_17785[(1)] = (1));

return statearr_17785;
});
var cljs$core$async$state_machine__16395__auto____1 = (function (state_17756){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_17756);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e17786){var ex__16398__auto__ = e17786;
var statearr_17787_17809 = state_17756;
(statearr_17787_17809[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_17756[(4)]))){
var statearr_17788_17810 = state_17756;
(statearr_17788_17810[(1)] = cljs.core.first((state_17756[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__17811 = state_17756;
state_17756 = G__17811;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$state_machine__16395__auto__ = function(state_17756){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16395__auto____1.call(this,state_17756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16395__auto____0;
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16395__auto____1;
return cljs$core$async$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_17789 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_17789[(6)] = c__16469__auto___17791);

return statearr_17789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__17814 = arguments.length;
switch (G__17814) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16469__auto___17869 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_17846){
var state_val_17847 = (state_17846[(1)]);
if((state_val_17847 === (7))){
var inst_17826 = (state_17846[(7)]);
var inst_17825 = (state_17846[(8)]);
var inst_17825__$1 = (state_17846[(2)]);
var inst_17826__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17825__$1,(0),null);
var inst_17827 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17825__$1,(1),null);
var inst_17828 = (inst_17826__$1 == null);
var state_17846__$1 = (function (){var statearr_17848 = state_17846;
(statearr_17848[(7)] = inst_17826__$1);

(statearr_17848[(8)] = inst_17825__$1);

(statearr_17848[(9)] = inst_17827);

return statearr_17848;
})();
if(cljs.core.truth_(inst_17828)){
var statearr_17849_17870 = state_17846__$1;
(statearr_17849_17870[(1)] = (8));

} else {
var statearr_17850_17871 = state_17846__$1;
(statearr_17850_17871[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17847 === (1))){
var inst_17815 = cljs.core.vec(chs);
var inst_17816 = inst_17815;
var state_17846__$1 = (function (){var statearr_17851 = state_17846;
(statearr_17851[(10)] = inst_17816);

return statearr_17851;
})();
var statearr_17852_17872 = state_17846__$1;
(statearr_17852_17872[(2)] = null);

(statearr_17852_17872[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17847 === (4))){
var inst_17816 = (state_17846[(10)]);
var state_17846__$1 = state_17846;
return cljs.core.async.ioc_alts_BANG_(state_17846__$1,(7),inst_17816);
} else {
if((state_val_17847 === (6))){
var inst_17842 = (state_17846[(2)]);
var state_17846__$1 = state_17846;
var statearr_17853_17873 = state_17846__$1;
(statearr_17853_17873[(2)] = inst_17842);

(statearr_17853_17873[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17847 === (3))){
var inst_17844 = (state_17846[(2)]);
var state_17846__$1 = state_17846;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17846__$1,inst_17844);
} else {
if((state_val_17847 === (2))){
var inst_17816 = (state_17846[(10)]);
var inst_17818 = cljs.core.count(inst_17816);
var inst_17819 = (inst_17818 > (0));
var state_17846__$1 = state_17846;
if(cljs.core.truth_(inst_17819)){
var statearr_17855_17874 = state_17846__$1;
(statearr_17855_17874[(1)] = (4));

} else {
var statearr_17856_17875 = state_17846__$1;
(statearr_17856_17875[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17847 === (11))){
var inst_17816 = (state_17846[(10)]);
var inst_17835 = (state_17846[(2)]);
var tmp17854 = inst_17816;
var inst_17816__$1 = tmp17854;
var state_17846__$1 = (function (){var statearr_17857 = state_17846;
(statearr_17857[(11)] = inst_17835);

(statearr_17857[(10)] = inst_17816__$1);

return statearr_17857;
})();
var statearr_17858_17876 = state_17846__$1;
(statearr_17858_17876[(2)] = null);

(statearr_17858_17876[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17847 === (9))){
var inst_17826 = (state_17846[(7)]);
var state_17846__$1 = state_17846;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17846__$1,(11),out,inst_17826);
} else {
if((state_val_17847 === (5))){
var inst_17840 = cljs.core.async.close_BANG_(out);
var state_17846__$1 = state_17846;
var statearr_17859_17877 = state_17846__$1;
(statearr_17859_17877[(2)] = inst_17840);

(statearr_17859_17877[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17847 === (10))){
var inst_17838 = (state_17846[(2)]);
var state_17846__$1 = state_17846;
var statearr_17860_17878 = state_17846__$1;
(statearr_17860_17878[(2)] = inst_17838);

(statearr_17860_17878[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17847 === (8))){
var inst_17826 = (state_17846[(7)]);
var inst_17825 = (state_17846[(8)]);
var inst_17816 = (state_17846[(10)]);
var inst_17827 = (state_17846[(9)]);
var inst_17830 = (function (){var cs = inst_17816;
var vec__17821 = inst_17825;
var v = inst_17826;
var c = inst_17827;
return (function (p1__17812_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__17812_SHARP_);
});
})();
var inst_17831 = cljs.core.filterv(inst_17830,inst_17816);
var inst_17816__$1 = inst_17831;
var state_17846__$1 = (function (){var statearr_17861 = state_17846;
(statearr_17861[(10)] = inst_17816__$1);

return statearr_17861;
})();
var statearr_17862_17879 = state_17846__$1;
(statearr_17862_17879[(2)] = null);

(statearr_17862_17879[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16395__auto__ = null;
var cljs$core$async$state_machine__16395__auto____0 = (function (){
var statearr_17863 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17863[(0)] = cljs$core$async$state_machine__16395__auto__);

(statearr_17863[(1)] = (1));

return statearr_17863;
});
var cljs$core$async$state_machine__16395__auto____1 = (function (state_17846){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_17846);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e17864){var ex__16398__auto__ = e17864;
var statearr_17865_17880 = state_17846;
(statearr_17865_17880[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_17846[(4)]))){
var statearr_17866_17881 = state_17846;
(statearr_17866_17881[(1)] = cljs.core.first((state_17846[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__17882 = state_17846;
state_17846 = G__17882;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$state_machine__16395__auto__ = function(state_17846){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16395__auto____1.call(this,state_17846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16395__auto____0;
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16395__auto____1;
return cljs$core$async$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_17867 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_17867[(6)] = c__16469__auto___17869);

return statearr_17867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__17884 = arguments.length;
switch (G__17884) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16469__auto___17930 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_17908){
var state_val_17909 = (state_17908[(1)]);
if((state_val_17909 === (7))){
var inst_17890 = (state_17908[(7)]);
var inst_17890__$1 = (state_17908[(2)]);
var inst_17891 = (inst_17890__$1 == null);
var inst_17892 = cljs.core.not(inst_17891);
var state_17908__$1 = (function (){var statearr_17910 = state_17908;
(statearr_17910[(7)] = inst_17890__$1);

return statearr_17910;
})();
if(inst_17892){
var statearr_17911_17931 = state_17908__$1;
(statearr_17911_17931[(1)] = (8));

} else {
var statearr_17912_17932 = state_17908__$1;
(statearr_17912_17932[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17909 === (1))){
var inst_17885 = (0);
var state_17908__$1 = (function (){var statearr_17913 = state_17908;
(statearr_17913[(8)] = inst_17885);

return statearr_17913;
})();
var statearr_17914_17933 = state_17908__$1;
(statearr_17914_17933[(2)] = null);

(statearr_17914_17933[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17909 === (4))){
var state_17908__$1 = state_17908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17908__$1,(7),ch);
} else {
if((state_val_17909 === (6))){
var inst_17903 = (state_17908[(2)]);
var state_17908__$1 = state_17908;
var statearr_17915_17934 = state_17908__$1;
(statearr_17915_17934[(2)] = inst_17903);

(statearr_17915_17934[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17909 === (3))){
var inst_17905 = (state_17908[(2)]);
var inst_17906 = cljs.core.async.close_BANG_(out);
var state_17908__$1 = (function (){var statearr_17916 = state_17908;
(statearr_17916[(9)] = inst_17905);

return statearr_17916;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17908__$1,inst_17906);
} else {
if((state_val_17909 === (2))){
var inst_17885 = (state_17908[(8)]);
var inst_17887 = (inst_17885 < n);
var state_17908__$1 = state_17908;
if(cljs.core.truth_(inst_17887)){
var statearr_17917_17935 = state_17908__$1;
(statearr_17917_17935[(1)] = (4));

} else {
var statearr_17918_17936 = state_17908__$1;
(statearr_17918_17936[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17909 === (11))){
var inst_17885 = (state_17908[(8)]);
var inst_17895 = (state_17908[(2)]);
var inst_17896 = (inst_17885 + (1));
var inst_17885__$1 = inst_17896;
var state_17908__$1 = (function (){var statearr_17919 = state_17908;
(statearr_17919[(10)] = inst_17895);

(statearr_17919[(8)] = inst_17885__$1);

return statearr_17919;
})();
var statearr_17920_17937 = state_17908__$1;
(statearr_17920_17937[(2)] = null);

(statearr_17920_17937[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17909 === (9))){
var state_17908__$1 = state_17908;
var statearr_17921_17938 = state_17908__$1;
(statearr_17921_17938[(2)] = null);

(statearr_17921_17938[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17909 === (5))){
var state_17908__$1 = state_17908;
var statearr_17922_17939 = state_17908__$1;
(statearr_17922_17939[(2)] = null);

(statearr_17922_17939[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17909 === (10))){
var inst_17900 = (state_17908[(2)]);
var state_17908__$1 = state_17908;
var statearr_17923_17940 = state_17908__$1;
(statearr_17923_17940[(2)] = inst_17900);

(statearr_17923_17940[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17909 === (8))){
var inst_17890 = (state_17908[(7)]);
var state_17908__$1 = state_17908;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17908__$1,(11),out,inst_17890);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16395__auto__ = null;
var cljs$core$async$state_machine__16395__auto____0 = (function (){
var statearr_17924 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17924[(0)] = cljs$core$async$state_machine__16395__auto__);

(statearr_17924[(1)] = (1));

return statearr_17924;
});
var cljs$core$async$state_machine__16395__auto____1 = (function (state_17908){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_17908);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e17925){var ex__16398__auto__ = e17925;
var statearr_17926_17941 = state_17908;
(statearr_17926_17941[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_17908[(4)]))){
var statearr_17927_17942 = state_17908;
(statearr_17927_17942[(1)] = cljs.core.first((state_17908[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__17943 = state_17908;
state_17908 = G__17943;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$state_machine__16395__auto__ = function(state_17908){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16395__auto____1.call(this,state_17908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16395__auto____0;
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16395__auto____1;
return cljs$core$async$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_17928 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_17928[(6)] = c__16469__auto___17930);

return statearr_17928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17945 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17945 = (function (f,ch,meta17946){
this.f = f;
this.ch = ch;
this.meta17946 = meta17946;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17945.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17947,meta17946__$1){
var self__ = this;
var _17947__$1 = this;
return (new cljs.core.async.t_cljs$core$async17945(self__.f,self__.ch,meta17946__$1));
}));

(cljs.core.async.t_cljs$core$async17945.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17947){
var self__ = this;
var _17947__$1 = this;
return self__.meta17946;
}));

(cljs.core.async.t_cljs$core$async17945.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17945.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17945.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17945.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17945.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17948 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17948 = (function (f,ch,meta17946,_,fn1,meta17949){
this.f = f;
this.ch = ch;
this.meta17946 = meta17946;
this._ = _;
this.fn1 = fn1;
this.meta17949 = meta17949;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17948.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17950,meta17949__$1){
var self__ = this;
var _17950__$1 = this;
return (new cljs.core.async.t_cljs$core$async17948(self__.f,self__.ch,self__.meta17946,self__._,self__.fn1,meta17949__$1));
}));

(cljs.core.async.t_cljs$core$async17948.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17950){
var self__ = this;
var _17950__$1 = this;
return self__.meta17949;
}));

(cljs.core.async.t_cljs$core$async17948.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17948.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async17948.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async17948.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__17944_SHARP_){
var G__17951 = (((p1__17944_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__17944_SHARP_) : self__.f.call(null,p1__17944_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__17951) : f1.call(null,G__17951));
});
}));

(cljs.core.async.t_cljs$core$async17948.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17946,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async17945], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta17949], null);
}));

(cljs.core.async.t_cljs$core$async17948.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17948.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17948");

(cljs.core.async.t_cljs$core$async17948.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async17948");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17948.
 */
cljs.core.async.__GT_t_cljs$core$async17948 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17948(f__$1,ch__$1,meta17946__$1,___$2,fn1__$1,meta17949){
return (new cljs.core.async.t_cljs$core$async17948(f__$1,ch__$1,meta17946__$1,___$2,fn1__$1,meta17949));
});

}

return (new cljs.core.async.t_cljs$core$async17948(self__.f,self__.ch,self__.meta17946,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4210__auto__ = ret;
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4210__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__17952 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__17952) : self__.f.call(null,G__17952));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async17945.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17945.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async17945.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17946], null);
}));

(cljs.core.async.t_cljs$core$async17945.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17945.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17945");

(cljs.core.async.t_cljs$core$async17945.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async17945");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17945.
 */
cljs.core.async.__GT_t_cljs$core$async17945 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17945(f__$1,ch__$1,meta17946){
return (new cljs.core.async.t_cljs$core$async17945(f__$1,ch__$1,meta17946));
});

}

return (new cljs.core.async.t_cljs$core$async17945(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17953 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17953 = (function (f,ch,meta17954){
this.f = f;
this.ch = ch;
this.meta17954 = meta17954;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17953.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17955,meta17954__$1){
var self__ = this;
var _17955__$1 = this;
return (new cljs.core.async.t_cljs$core$async17953(self__.f,self__.ch,meta17954__$1));
}));

(cljs.core.async.t_cljs$core$async17953.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17955){
var self__ = this;
var _17955__$1 = this;
return self__.meta17954;
}));

(cljs.core.async.t_cljs$core$async17953.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17953.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17953.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17953.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async17953.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17953.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async17953.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17954], null);
}));

(cljs.core.async.t_cljs$core$async17953.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17953.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17953");

(cljs.core.async.t_cljs$core$async17953.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async17953");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17953.
 */
cljs.core.async.__GT_t_cljs$core$async17953 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async17953(f__$1,ch__$1,meta17954){
return (new cljs.core.async.t_cljs$core$async17953(f__$1,ch__$1,meta17954));
});

}

return (new cljs.core.async.t_cljs$core$async17953(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17956 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17956 = (function (p,ch,meta17957){
this.p = p;
this.ch = ch;
this.meta17957 = meta17957;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17956.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17958,meta17957__$1){
var self__ = this;
var _17958__$1 = this;
return (new cljs.core.async.t_cljs$core$async17956(self__.p,self__.ch,meta17957__$1));
}));

(cljs.core.async.t_cljs$core$async17956.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17958){
var self__ = this;
var _17958__$1 = this;
return self__.meta17957;
}));

(cljs.core.async.t_cljs$core$async17956.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17956.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17956.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17956.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17956.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async17956.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17956.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async17956.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17957], null);
}));

(cljs.core.async.t_cljs$core$async17956.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17956.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17956");

(cljs.core.async.t_cljs$core$async17956.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async17956");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17956.
 */
cljs.core.async.__GT_t_cljs$core$async17956 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async17956(p__$1,ch__$1,meta17957){
return (new cljs.core.async.t_cljs$core$async17956(p__$1,ch__$1,meta17957));
});

}

return (new cljs.core.async.t_cljs$core$async17956(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__17960 = arguments.length;
switch (G__17960) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16469__auto___18001 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_17981){
var state_val_17982 = (state_17981[(1)]);
if((state_val_17982 === (7))){
var inst_17977 = (state_17981[(2)]);
var state_17981__$1 = state_17981;
var statearr_17983_18002 = state_17981__$1;
(statearr_17983_18002[(2)] = inst_17977);

(statearr_17983_18002[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17982 === (1))){
var state_17981__$1 = state_17981;
var statearr_17984_18003 = state_17981__$1;
(statearr_17984_18003[(2)] = null);

(statearr_17984_18003[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17982 === (4))){
var inst_17963 = (state_17981[(7)]);
var inst_17963__$1 = (state_17981[(2)]);
var inst_17964 = (inst_17963__$1 == null);
var state_17981__$1 = (function (){var statearr_17985 = state_17981;
(statearr_17985[(7)] = inst_17963__$1);

return statearr_17985;
})();
if(cljs.core.truth_(inst_17964)){
var statearr_17986_18004 = state_17981__$1;
(statearr_17986_18004[(1)] = (5));

} else {
var statearr_17987_18005 = state_17981__$1;
(statearr_17987_18005[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17982 === (6))){
var inst_17963 = (state_17981[(7)]);
var inst_17968 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17963) : p.call(null,inst_17963));
var state_17981__$1 = state_17981;
if(cljs.core.truth_(inst_17968)){
var statearr_17988_18006 = state_17981__$1;
(statearr_17988_18006[(1)] = (8));

} else {
var statearr_17989_18007 = state_17981__$1;
(statearr_17989_18007[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17982 === (3))){
var inst_17979 = (state_17981[(2)]);
var state_17981__$1 = state_17981;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17981__$1,inst_17979);
} else {
if((state_val_17982 === (2))){
var state_17981__$1 = state_17981;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17981__$1,(4),ch);
} else {
if((state_val_17982 === (11))){
var inst_17971 = (state_17981[(2)]);
var state_17981__$1 = state_17981;
var statearr_17990_18008 = state_17981__$1;
(statearr_17990_18008[(2)] = inst_17971);

(statearr_17990_18008[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17982 === (9))){
var state_17981__$1 = state_17981;
var statearr_17991_18009 = state_17981__$1;
(statearr_17991_18009[(2)] = null);

(statearr_17991_18009[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17982 === (5))){
var inst_17966 = cljs.core.async.close_BANG_(out);
var state_17981__$1 = state_17981;
var statearr_17992_18010 = state_17981__$1;
(statearr_17992_18010[(2)] = inst_17966);

(statearr_17992_18010[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17982 === (10))){
var inst_17974 = (state_17981[(2)]);
var state_17981__$1 = (function (){var statearr_17993 = state_17981;
(statearr_17993[(8)] = inst_17974);

return statearr_17993;
})();
var statearr_17994_18011 = state_17981__$1;
(statearr_17994_18011[(2)] = null);

(statearr_17994_18011[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17982 === (8))){
var inst_17963 = (state_17981[(7)]);
var state_17981__$1 = state_17981;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17981__$1,(11),out,inst_17963);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16395__auto__ = null;
var cljs$core$async$state_machine__16395__auto____0 = (function (){
var statearr_17995 = [null,null,null,null,null,null,null,null,null];
(statearr_17995[(0)] = cljs$core$async$state_machine__16395__auto__);

(statearr_17995[(1)] = (1));

return statearr_17995;
});
var cljs$core$async$state_machine__16395__auto____1 = (function (state_17981){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_17981);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e17996){var ex__16398__auto__ = e17996;
var statearr_17997_18012 = state_17981;
(statearr_17997_18012[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_17981[(4)]))){
var statearr_17998_18013 = state_17981;
(statearr_17998_18013[(1)] = cljs.core.first((state_17981[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__18014 = state_17981;
state_17981 = G__18014;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$state_machine__16395__auto__ = function(state_17981){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16395__auto____1.call(this,state_17981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16395__auto____0;
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16395__auto____1;
return cljs$core$async$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_17999 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_17999[(6)] = c__16469__auto___18001);

return statearr_17999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__18016 = arguments.length;
switch (G__18016) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_18079){
var state_val_18080 = (state_18079[(1)]);
if((state_val_18080 === (7))){
var inst_18075 = (state_18079[(2)]);
var state_18079__$1 = state_18079;
var statearr_18081_18120 = state_18079__$1;
(statearr_18081_18120[(2)] = inst_18075);

(statearr_18081_18120[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (20))){
var inst_18045 = (state_18079[(7)]);
var inst_18056 = (state_18079[(2)]);
var inst_18057 = cljs.core.next(inst_18045);
var inst_18031 = inst_18057;
var inst_18032 = null;
var inst_18033 = (0);
var inst_18034 = (0);
var state_18079__$1 = (function (){var statearr_18082 = state_18079;
(statearr_18082[(8)] = inst_18031);

(statearr_18082[(9)] = inst_18034);

(statearr_18082[(10)] = inst_18033);

(statearr_18082[(11)] = inst_18056);

(statearr_18082[(12)] = inst_18032);

return statearr_18082;
})();
var statearr_18083_18121 = state_18079__$1;
(statearr_18083_18121[(2)] = null);

(statearr_18083_18121[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (1))){
var state_18079__$1 = state_18079;
var statearr_18084_18122 = state_18079__$1;
(statearr_18084_18122[(2)] = null);

(statearr_18084_18122[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (4))){
var inst_18020 = (state_18079[(13)]);
var inst_18020__$1 = (state_18079[(2)]);
var inst_18021 = (inst_18020__$1 == null);
var state_18079__$1 = (function (){var statearr_18085 = state_18079;
(statearr_18085[(13)] = inst_18020__$1);

return statearr_18085;
})();
if(cljs.core.truth_(inst_18021)){
var statearr_18086_18123 = state_18079__$1;
(statearr_18086_18123[(1)] = (5));

} else {
var statearr_18087_18124 = state_18079__$1;
(statearr_18087_18124[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (15))){
var state_18079__$1 = state_18079;
var statearr_18091_18125 = state_18079__$1;
(statearr_18091_18125[(2)] = null);

(statearr_18091_18125[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (21))){
var state_18079__$1 = state_18079;
var statearr_18092_18126 = state_18079__$1;
(statearr_18092_18126[(2)] = null);

(statearr_18092_18126[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (13))){
var inst_18031 = (state_18079[(8)]);
var inst_18034 = (state_18079[(9)]);
var inst_18033 = (state_18079[(10)]);
var inst_18032 = (state_18079[(12)]);
var inst_18041 = (state_18079[(2)]);
var inst_18042 = (inst_18034 + (1));
var tmp18088 = inst_18031;
var tmp18089 = inst_18033;
var tmp18090 = inst_18032;
var inst_18031__$1 = tmp18088;
var inst_18032__$1 = tmp18090;
var inst_18033__$1 = tmp18089;
var inst_18034__$1 = inst_18042;
var state_18079__$1 = (function (){var statearr_18093 = state_18079;
(statearr_18093[(8)] = inst_18031__$1);

(statearr_18093[(9)] = inst_18034__$1);

(statearr_18093[(10)] = inst_18033__$1);

(statearr_18093[(12)] = inst_18032__$1);

(statearr_18093[(14)] = inst_18041);

return statearr_18093;
})();
var statearr_18094_18127 = state_18079__$1;
(statearr_18094_18127[(2)] = null);

(statearr_18094_18127[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (22))){
var state_18079__$1 = state_18079;
var statearr_18095_18128 = state_18079__$1;
(statearr_18095_18128[(2)] = null);

(statearr_18095_18128[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (6))){
var inst_18020 = (state_18079[(13)]);
var inst_18029 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18020) : f.call(null,inst_18020));
var inst_18030 = cljs.core.seq(inst_18029);
var inst_18031 = inst_18030;
var inst_18032 = null;
var inst_18033 = (0);
var inst_18034 = (0);
var state_18079__$1 = (function (){var statearr_18096 = state_18079;
(statearr_18096[(8)] = inst_18031);

(statearr_18096[(9)] = inst_18034);

(statearr_18096[(10)] = inst_18033);

(statearr_18096[(12)] = inst_18032);

return statearr_18096;
})();
var statearr_18097_18129 = state_18079__$1;
(statearr_18097_18129[(2)] = null);

(statearr_18097_18129[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (17))){
var inst_18045 = (state_18079[(7)]);
var inst_18049 = cljs.core.chunk_first(inst_18045);
var inst_18050 = cljs.core.chunk_rest(inst_18045);
var inst_18051 = cljs.core.count(inst_18049);
var inst_18031 = inst_18050;
var inst_18032 = inst_18049;
var inst_18033 = inst_18051;
var inst_18034 = (0);
var state_18079__$1 = (function (){var statearr_18098 = state_18079;
(statearr_18098[(8)] = inst_18031);

(statearr_18098[(9)] = inst_18034);

(statearr_18098[(10)] = inst_18033);

(statearr_18098[(12)] = inst_18032);

return statearr_18098;
})();
var statearr_18099_18130 = state_18079__$1;
(statearr_18099_18130[(2)] = null);

(statearr_18099_18130[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (3))){
var inst_18077 = (state_18079[(2)]);
var state_18079__$1 = state_18079;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18079__$1,inst_18077);
} else {
if((state_val_18080 === (12))){
var inst_18065 = (state_18079[(2)]);
var state_18079__$1 = state_18079;
var statearr_18100_18131 = state_18079__$1;
(statearr_18100_18131[(2)] = inst_18065);

(statearr_18100_18131[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (2))){
var state_18079__$1 = state_18079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18079__$1,(4),in$);
} else {
if((state_val_18080 === (23))){
var inst_18073 = (state_18079[(2)]);
var state_18079__$1 = state_18079;
var statearr_18101_18132 = state_18079__$1;
(statearr_18101_18132[(2)] = inst_18073);

(statearr_18101_18132[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (19))){
var inst_18060 = (state_18079[(2)]);
var state_18079__$1 = state_18079;
var statearr_18102_18133 = state_18079__$1;
(statearr_18102_18133[(2)] = inst_18060);

(statearr_18102_18133[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (11))){
var inst_18031 = (state_18079[(8)]);
var inst_18045 = (state_18079[(7)]);
var inst_18045__$1 = cljs.core.seq(inst_18031);
var state_18079__$1 = (function (){var statearr_18103 = state_18079;
(statearr_18103[(7)] = inst_18045__$1);

return statearr_18103;
})();
if(inst_18045__$1){
var statearr_18104_18134 = state_18079__$1;
(statearr_18104_18134[(1)] = (14));

} else {
var statearr_18105_18135 = state_18079__$1;
(statearr_18105_18135[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (9))){
var inst_18067 = (state_18079[(2)]);
var inst_18068 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_18079__$1 = (function (){var statearr_18106 = state_18079;
(statearr_18106[(15)] = inst_18067);

return statearr_18106;
})();
if(cljs.core.truth_(inst_18068)){
var statearr_18107_18136 = state_18079__$1;
(statearr_18107_18136[(1)] = (21));

} else {
var statearr_18108_18137 = state_18079__$1;
(statearr_18108_18137[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (5))){
var inst_18023 = cljs.core.async.close_BANG_(out);
var state_18079__$1 = state_18079;
var statearr_18109_18138 = state_18079__$1;
(statearr_18109_18138[(2)] = inst_18023);

(statearr_18109_18138[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (14))){
var inst_18045 = (state_18079[(7)]);
var inst_18047 = cljs.core.chunked_seq_QMARK_(inst_18045);
var state_18079__$1 = state_18079;
if(inst_18047){
var statearr_18110_18139 = state_18079__$1;
(statearr_18110_18139[(1)] = (17));

} else {
var statearr_18111_18140 = state_18079__$1;
(statearr_18111_18140[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (16))){
var inst_18063 = (state_18079[(2)]);
var state_18079__$1 = state_18079;
var statearr_18112_18141 = state_18079__$1;
(statearr_18112_18141[(2)] = inst_18063);

(statearr_18112_18141[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18080 === (10))){
var inst_18034 = (state_18079[(9)]);
var inst_18032 = (state_18079[(12)]);
var inst_18039 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18032,inst_18034);
var state_18079__$1 = state_18079;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18079__$1,(13),out,inst_18039);
} else {
if((state_val_18080 === (18))){
var inst_18045 = (state_18079[(7)]);
var inst_18054 = cljs.core.first(inst_18045);
var state_18079__$1 = state_18079;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18079__$1,(20),out,inst_18054);
} else {
if((state_val_18080 === (8))){
var inst_18034 = (state_18079[(9)]);
var inst_18033 = (state_18079[(10)]);
var inst_18036 = (inst_18034 < inst_18033);
var inst_18037 = inst_18036;
var state_18079__$1 = state_18079;
if(cljs.core.truth_(inst_18037)){
var statearr_18113_18142 = state_18079__$1;
(statearr_18113_18142[(1)] = (10));

} else {
var statearr_18114_18143 = state_18079__$1;
(statearr_18114_18143[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16395__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16395__auto____0 = (function (){
var statearr_18115 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18115[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16395__auto__);

(statearr_18115[(1)] = (1));

return statearr_18115;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16395__auto____1 = (function (state_18079){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_18079);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e18116){var ex__16398__auto__ = e18116;
var statearr_18117_18144 = state_18079;
(statearr_18117_18144[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_18079[(4)]))){
var statearr_18118_18145 = state_18079;
(statearr_18118_18145[(1)] = cljs.core.first((state_18079[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__18146 = state_18079;
state_18079 = G__18146;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16395__auto__ = function(state_18079){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16395__auto____1.call(this,state_18079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16395__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16395__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_18119 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_18119[(6)] = c__16469__auto__);

return statearr_18119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__18148 = arguments.length;
switch (G__18148) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__18151 = arguments.length;
switch (G__18151) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__18154 = arguments.length;
switch (G__18154) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16469__auto___18202 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_18178){
var state_val_18179 = (state_18178[(1)]);
if((state_val_18179 === (7))){
var inst_18173 = (state_18178[(2)]);
var state_18178__$1 = state_18178;
var statearr_18180_18203 = state_18178__$1;
(statearr_18180_18203[(2)] = inst_18173);

(statearr_18180_18203[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18179 === (1))){
var inst_18155 = null;
var state_18178__$1 = (function (){var statearr_18181 = state_18178;
(statearr_18181[(7)] = inst_18155);

return statearr_18181;
})();
var statearr_18182_18204 = state_18178__$1;
(statearr_18182_18204[(2)] = null);

(statearr_18182_18204[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18179 === (4))){
var inst_18158 = (state_18178[(8)]);
var inst_18158__$1 = (state_18178[(2)]);
var inst_18159 = (inst_18158__$1 == null);
var inst_18160 = cljs.core.not(inst_18159);
var state_18178__$1 = (function (){var statearr_18183 = state_18178;
(statearr_18183[(8)] = inst_18158__$1);

return statearr_18183;
})();
if(inst_18160){
var statearr_18184_18205 = state_18178__$1;
(statearr_18184_18205[(1)] = (5));

} else {
var statearr_18185_18206 = state_18178__$1;
(statearr_18185_18206[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18179 === (6))){
var state_18178__$1 = state_18178;
var statearr_18186_18207 = state_18178__$1;
(statearr_18186_18207[(2)] = null);

(statearr_18186_18207[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18179 === (3))){
var inst_18175 = (state_18178[(2)]);
var inst_18176 = cljs.core.async.close_BANG_(out);
var state_18178__$1 = (function (){var statearr_18187 = state_18178;
(statearr_18187[(9)] = inst_18175);

return statearr_18187;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18178__$1,inst_18176);
} else {
if((state_val_18179 === (2))){
var state_18178__$1 = state_18178;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18178__$1,(4),ch);
} else {
if((state_val_18179 === (11))){
var inst_18158 = (state_18178[(8)]);
var inst_18167 = (state_18178[(2)]);
var inst_18155 = inst_18158;
var state_18178__$1 = (function (){var statearr_18188 = state_18178;
(statearr_18188[(7)] = inst_18155);

(statearr_18188[(10)] = inst_18167);

return statearr_18188;
})();
var statearr_18189_18208 = state_18178__$1;
(statearr_18189_18208[(2)] = null);

(statearr_18189_18208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18179 === (9))){
var inst_18158 = (state_18178[(8)]);
var state_18178__$1 = state_18178;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18178__$1,(11),out,inst_18158);
} else {
if((state_val_18179 === (5))){
var inst_18158 = (state_18178[(8)]);
var inst_18155 = (state_18178[(7)]);
var inst_18162 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18158,inst_18155);
var state_18178__$1 = state_18178;
if(inst_18162){
var statearr_18191_18209 = state_18178__$1;
(statearr_18191_18209[(1)] = (8));

} else {
var statearr_18192_18210 = state_18178__$1;
(statearr_18192_18210[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18179 === (10))){
var inst_18170 = (state_18178[(2)]);
var state_18178__$1 = state_18178;
var statearr_18193_18211 = state_18178__$1;
(statearr_18193_18211[(2)] = inst_18170);

(statearr_18193_18211[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18179 === (8))){
var inst_18155 = (state_18178[(7)]);
var tmp18190 = inst_18155;
var inst_18155__$1 = tmp18190;
var state_18178__$1 = (function (){var statearr_18194 = state_18178;
(statearr_18194[(7)] = inst_18155__$1);

return statearr_18194;
})();
var statearr_18195_18212 = state_18178__$1;
(statearr_18195_18212[(2)] = null);

(statearr_18195_18212[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16395__auto__ = null;
var cljs$core$async$state_machine__16395__auto____0 = (function (){
var statearr_18196 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18196[(0)] = cljs$core$async$state_machine__16395__auto__);

(statearr_18196[(1)] = (1));

return statearr_18196;
});
var cljs$core$async$state_machine__16395__auto____1 = (function (state_18178){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_18178);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e18197){var ex__16398__auto__ = e18197;
var statearr_18198_18213 = state_18178;
(statearr_18198_18213[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_18178[(4)]))){
var statearr_18199_18214 = state_18178;
(statearr_18199_18214[(1)] = cljs.core.first((state_18178[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__18215 = state_18178;
state_18178 = G__18215;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$state_machine__16395__auto__ = function(state_18178){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16395__auto____1.call(this,state_18178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16395__auto____0;
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16395__auto____1;
return cljs$core$async$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_18200 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_18200[(6)] = c__16469__auto___18202);

return statearr_18200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__18217 = arguments.length;
switch (G__18217) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16469__auto___18284 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_18255){
var state_val_18256 = (state_18255[(1)]);
if((state_val_18256 === (7))){
var inst_18251 = (state_18255[(2)]);
var state_18255__$1 = state_18255;
var statearr_18257_18285 = state_18255__$1;
(statearr_18257_18285[(2)] = inst_18251);

(statearr_18257_18285[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18256 === (1))){
var inst_18218 = (new Array(n));
var inst_18219 = inst_18218;
var inst_18220 = (0);
var state_18255__$1 = (function (){var statearr_18258 = state_18255;
(statearr_18258[(7)] = inst_18220);

(statearr_18258[(8)] = inst_18219);

return statearr_18258;
})();
var statearr_18259_18286 = state_18255__$1;
(statearr_18259_18286[(2)] = null);

(statearr_18259_18286[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18256 === (4))){
var inst_18223 = (state_18255[(9)]);
var inst_18223__$1 = (state_18255[(2)]);
var inst_18224 = (inst_18223__$1 == null);
var inst_18225 = cljs.core.not(inst_18224);
var state_18255__$1 = (function (){var statearr_18260 = state_18255;
(statearr_18260[(9)] = inst_18223__$1);

return statearr_18260;
})();
if(inst_18225){
var statearr_18261_18287 = state_18255__$1;
(statearr_18261_18287[(1)] = (5));

} else {
var statearr_18262_18288 = state_18255__$1;
(statearr_18262_18288[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18256 === (15))){
var inst_18245 = (state_18255[(2)]);
var state_18255__$1 = state_18255;
var statearr_18263_18289 = state_18255__$1;
(statearr_18263_18289[(2)] = inst_18245);

(statearr_18263_18289[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18256 === (13))){
var state_18255__$1 = state_18255;
var statearr_18264_18290 = state_18255__$1;
(statearr_18264_18290[(2)] = null);

(statearr_18264_18290[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18256 === (6))){
var inst_18220 = (state_18255[(7)]);
var inst_18241 = (inst_18220 > (0));
var state_18255__$1 = state_18255;
if(cljs.core.truth_(inst_18241)){
var statearr_18265_18291 = state_18255__$1;
(statearr_18265_18291[(1)] = (12));

} else {
var statearr_18266_18292 = state_18255__$1;
(statearr_18266_18292[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18256 === (3))){
var inst_18253 = (state_18255[(2)]);
var state_18255__$1 = state_18255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18255__$1,inst_18253);
} else {
if((state_val_18256 === (12))){
var inst_18219 = (state_18255[(8)]);
var inst_18243 = cljs.core.vec(inst_18219);
var state_18255__$1 = state_18255;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18255__$1,(15),out,inst_18243);
} else {
if((state_val_18256 === (2))){
var state_18255__$1 = state_18255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18255__$1,(4),ch);
} else {
if((state_val_18256 === (11))){
var inst_18235 = (state_18255[(2)]);
var inst_18236 = (new Array(n));
var inst_18219 = inst_18236;
var inst_18220 = (0);
var state_18255__$1 = (function (){var statearr_18267 = state_18255;
(statearr_18267[(7)] = inst_18220);

(statearr_18267[(8)] = inst_18219);

(statearr_18267[(10)] = inst_18235);

return statearr_18267;
})();
var statearr_18268_18293 = state_18255__$1;
(statearr_18268_18293[(2)] = null);

(statearr_18268_18293[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18256 === (9))){
var inst_18219 = (state_18255[(8)]);
var inst_18233 = cljs.core.vec(inst_18219);
var state_18255__$1 = state_18255;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18255__$1,(11),out,inst_18233);
} else {
if((state_val_18256 === (5))){
var inst_18220 = (state_18255[(7)]);
var inst_18219 = (state_18255[(8)]);
var inst_18228 = (state_18255[(11)]);
var inst_18223 = (state_18255[(9)]);
var inst_18227 = (inst_18219[inst_18220] = inst_18223);
var inst_18228__$1 = (inst_18220 + (1));
var inst_18229 = (inst_18228__$1 < n);
var state_18255__$1 = (function (){var statearr_18269 = state_18255;
(statearr_18269[(11)] = inst_18228__$1);

(statearr_18269[(12)] = inst_18227);

return statearr_18269;
})();
if(cljs.core.truth_(inst_18229)){
var statearr_18270_18294 = state_18255__$1;
(statearr_18270_18294[(1)] = (8));

} else {
var statearr_18271_18295 = state_18255__$1;
(statearr_18271_18295[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18256 === (14))){
var inst_18248 = (state_18255[(2)]);
var inst_18249 = cljs.core.async.close_BANG_(out);
var state_18255__$1 = (function (){var statearr_18273 = state_18255;
(statearr_18273[(13)] = inst_18248);

return statearr_18273;
})();
var statearr_18274_18296 = state_18255__$1;
(statearr_18274_18296[(2)] = inst_18249);

(statearr_18274_18296[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18256 === (10))){
var inst_18239 = (state_18255[(2)]);
var state_18255__$1 = state_18255;
var statearr_18275_18297 = state_18255__$1;
(statearr_18275_18297[(2)] = inst_18239);

(statearr_18275_18297[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18256 === (8))){
var inst_18219 = (state_18255[(8)]);
var inst_18228 = (state_18255[(11)]);
var tmp18272 = inst_18219;
var inst_18219__$1 = tmp18272;
var inst_18220 = inst_18228;
var state_18255__$1 = (function (){var statearr_18276 = state_18255;
(statearr_18276[(7)] = inst_18220);

(statearr_18276[(8)] = inst_18219__$1);

return statearr_18276;
})();
var statearr_18277_18298 = state_18255__$1;
(statearr_18277_18298[(2)] = null);

(statearr_18277_18298[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16395__auto__ = null;
var cljs$core$async$state_machine__16395__auto____0 = (function (){
var statearr_18278 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18278[(0)] = cljs$core$async$state_machine__16395__auto__);

(statearr_18278[(1)] = (1));

return statearr_18278;
});
var cljs$core$async$state_machine__16395__auto____1 = (function (state_18255){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_18255);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e18279){var ex__16398__auto__ = e18279;
var statearr_18280_18299 = state_18255;
(statearr_18280_18299[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_18255[(4)]))){
var statearr_18281_18300 = state_18255;
(statearr_18281_18300[(1)] = cljs.core.first((state_18255[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__18301 = state_18255;
state_18255 = G__18301;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$state_machine__16395__auto__ = function(state_18255){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16395__auto____1.call(this,state_18255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16395__auto____0;
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16395__auto____1;
return cljs$core$async$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_18282 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_18282[(6)] = c__16469__auto___18284);

return statearr_18282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__18303 = arguments.length;
switch (G__18303) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16469__auto___18381 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_18348){
var state_val_18349 = (state_18348[(1)]);
if((state_val_18349 === (7))){
var inst_18344 = (state_18348[(2)]);
var state_18348__$1 = state_18348;
var statearr_18350_18382 = state_18348__$1;
(statearr_18350_18382[(2)] = inst_18344);

(statearr_18350_18382[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (1))){
var inst_18304 = [];
var inst_18305 = inst_18304;
var inst_18306 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_18348__$1 = (function (){var statearr_18351 = state_18348;
(statearr_18351[(7)] = inst_18306);

(statearr_18351[(8)] = inst_18305);

return statearr_18351;
})();
var statearr_18352_18383 = state_18348__$1;
(statearr_18352_18383[(2)] = null);

(statearr_18352_18383[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (4))){
var inst_18309 = (state_18348[(9)]);
var inst_18309__$1 = (state_18348[(2)]);
var inst_18310 = (inst_18309__$1 == null);
var inst_18311 = cljs.core.not(inst_18310);
var state_18348__$1 = (function (){var statearr_18353 = state_18348;
(statearr_18353[(9)] = inst_18309__$1);

return statearr_18353;
})();
if(inst_18311){
var statearr_18354_18384 = state_18348__$1;
(statearr_18354_18384[(1)] = (5));

} else {
var statearr_18355_18385 = state_18348__$1;
(statearr_18355_18385[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (15))){
var inst_18305 = (state_18348[(8)]);
var inst_18336 = cljs.core.vec(inst_18305);
var state_18348__$1 = state_18348;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18348__$1,(18),out,inst_18336);
} else {
if((state_val_18349 === (13))){
var inst_18331 = (state_18348[(2)]);
var state_18348__$1 = state_18348;
var statearr_18356_18386 = state_18348__$1;
(statearr_18356_18386[(2)] = inst_18331);

(statearr_18356_18386[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (6))){
var inst_18305 = (state_18348[(8)]);
var inst_18333 = inst_18305.length;
var inst_18334 = (inst_18333 > (0));
var state_18348__$1 = state_18348;
if(cljs.core.truth_(inst_18334)){
var statearr_18357_18387 = state_18348__$1;
(statearr_18357_18387[(1)] = (15));

} else {
var statearr_18358_18388 = state_18348__$1;
(statearr_18358_18388[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (17))){
var inst_18341 = (state_18348[(2)]);
var inst_18342 = cljs.core.async.close_BANG_(out);
var state_18348__$1 = (function (){var statearr_18359 = state_18348;
(statearr_18359[(10)] = inst_18341);

return statearr_18359;
})();
var statearr_18360_18389 = state_18348__$1;
(statearr_18360_18389[(2)] = inst_18342);

(statearr_18360_18389[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (3))){
var inst_18346 = (state_18348[(2)]);
var state_18348__$1 = state_18348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18348__$1,inst_18346);
} else {
if((state_val_18349 === (12))){
var inst_18305 = (state_18348[(8)]);
var inst_18324 = cljs.core.vec(inst_18305);
var state_18348__$1 = state_18348;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18348__$1,(14),out,inst_18324);
} else {
if((state_val_18349 === (2))){
var state_18348__$1 = state_18348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18348__$1,(4),ch);
} else {
if((state_val_18349 === (11))){
var inst_18305 = (state_18348[(8)]);
var inst_18309 = (state_18348[(9)]);
var inst_18313 = (state_18348[(11)]);
var inst_18321 = inst_18305.push(inst_18309);
var tmp18361 = inst_18305;
var inst_18305__$1 = tmp18361;
var inst_18306 = inst_18313;
var state_18348__$1 = (function (){var statearr_18362 = state_18348;
(statearr_18362[(7)] = inst_18306);

(statearr_18362[(8)] = inst_18305__$1);

(statearr_18362[(12)] = inst_18321);

return statearr_18362;
})();
var statearr_18363_18390 = state_18348__$1;
(statearr_18363_18390[(2)] = null);

(statearr_18363_18390[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (9))){
var inst_18306 = (state_18348[(7)]);
var inst_18317 = cljs.core.keyword_identical_QMARK_(inst_18306,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var state_18348__$1 = state_18348;
var statearr_18364_18391 = state_18348__$1;
(statearr_18364_18391[(2)] = inst_18317);

(statearr_18364_18391[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (5))){
var inst_18306 = (state_18348[(7)]);
var inst_18309 = (state_18348[(9)]);
var inst_18313 = (state_18348[(11)]);
var inst_18314 = (state_18348[(13)]);
var inst_18313__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18309) : f.call(null,inst_18309));
var inst_18314__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18313__$1,inst_18306);
var state_18348__$1 = (function (){var statearr_18365 = state_18348;
(statearr_18365[(11)] = inst_18313__$1);

(statearr_18365[(13)] = inst_18314__$1);

return statearr_18365;
})();
if(inst_18314__$1){
var statearr_18366_18392 = state_18348__$1;
(statearr_18366_18392[(1)] = (8));

} else {
var statearr_18367_18393 = state_18348__$1;
(statearr_18367_18393[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (14))){
var inst_18309 = (state_18348[(9)]);
var inst_18313 = (state_18348[(11)]);
var inst_18326 = (state_18348[(2)]);
var inst_18327 = [];
var inst_18328 = inst_18327.push(inst_18309);
var inst_18305 = inst_18327;
var inst_18306 = inst_18313;
var state_18348__$1 = (function (){var statearr_18368 = state_18348;
(statearr_18368[(7)] = inst_18306);

(statearr_18368[(8)] = inst_18305);

(statearr_18368[(14)] = inst_18328);

(statearr_18368[(15)] = inst_18326);

return statearr_18368;
})();
var statearr_18369_18394 = state_18348__$1;
(statearr_18369_18394[(2)] = null);

(statearr_18369_18394[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (16))){
var state_18348__$1 = state_18348;
var statearr_18370_18395 = state_18348__$1;
(statearr_18370_18395[(2)] = null);

(statearr_18370_18395[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (10))){
var inst_18319 = (state_18348[(2)]);
var state_18348__$1 = state_18348;
if(cljs.core.truth_(inst_18319)){
var statearr_18371_18396 = state_18348__$1;
(statearr_18371_18396[(1)] = (11));

} else {
var statearr_18372_18397 = state_18348__$1;
(statearr_18372_18397[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (18))){
var inst_18338 = (state_18348[(2)]);
var state_18348__$1 = state_18348;
var statearr_18373_18398 = state_18348__$1;
(statearr_18373_18398[(2)] = inst_18338);

(statearr_18373_18398[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18349 === (8))){
var inst_18314 = (state_18348[(13)]);
var state_18348__$1 = state_18348;
var statearr_18374_18399 = state_18348__$1;
(statearr_18374_18399[(2)] = inst_18314);

(statearr_18374_18399[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16395__auto__ = null;
var cljs$core$async$state_machine__16395__auto____0 = (function (){
var statearr_18375 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18375[(0)] = cljs$core$async$state_machine__16395__auto__);

(statearr_18375[(1)] = (1));

return statearr_18375;
});
var cljs$core$async$state_machine__16395__auto____1 = (function (state_18348){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_18348);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e18376){var ex__16398__auto__ = e18376;
var statearr_18377_18400 = state_18348;
(statearr_18377_18400[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_18348[(4)]))){
var statearr_18378_18401 = state_18348;
(statearr_18378_18401[(1)] = cljs.core.first((state_18348[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__18402 = state_18348;
state_18348 = G__18402;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
cljs$core$async$state_machine__16395__auto__ = function(state_18348){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16395__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16395__auto____1.call(this,state_18348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16395__auto____0;
cljs$core$async$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16395__auto____1;
return cljs$core$async$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_18379 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_18379[(6)] = c__16469__auto___18381);

return statearr_18379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

