// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43337(s__43338){
return (new cljs.core.LazySeq(null,(function (){
var s__43338__$1 = s__43338;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43338__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43343 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43343,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43343,(1),null);
var iterys__4607__auto__ = ((function (s__43338__$1,vec__43343,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__43337_$_iter__43339(s__43340){
return (new cljs.core.LazySeq(null,((function (s__43338__$1,vec__43343,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__43340__$1 = s__43340;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43340__$1);
if(temp__5753__auto____$1){
var s__43340__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43340__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43340__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43342 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43341 = (0);
while(true){
if((i__43341 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43341);
cljs.core.chunk_append(b__43342,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__43395 = (i__43341 + (1));
i__43341 = G__43395;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43342),tailrecursion$priority_map$iter__43337_$_iter__43339(cljs.core.chunk_rest(s__43340__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43342),null);
}
} else {
var item = cljs.core.first(s__43340__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__43337_$_iter__43339(cljs.core.rest(s__43340__$2)));
}
} else {
return null;
}
break;
}
});})(s__43338__$1,vec__43343,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__43338__$1,vec__43343,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43337(cljs.core.rest(s__43338__$1)));
} else {
var G__43396 = cljs.core.rest(s__43338__$1);
s__43338__$1 = G__43396;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43346(s__43347){
return (new cljs.core.LazySeq(null,(function (){
var s__43347__$1 = s__43347;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43347__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43352 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43352,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43352,(1),null);
var iterys__4607__auto__ = ((function (s__43347__$1,vec__43352,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__43346_$_iter__43348(s__43349){
return (new cljs.core.LazySeq(null,((function (s__43347__$1,vec__43352,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__43349__$1 = s__43349;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43349__$1);
if(temp__5753__auto____$1){
var s__43349__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43349__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43349__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43351 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43350 = (0);
while(true){
if((i__43350 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43350);
cljs.core.chunk_append(b__43351,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__43397 = (i__43350 + (1));
i__43350 = G__43397;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43351),tailrecursion$priority_map$iter__43346_$_iter__43348(cljs.core.chunk_rest(s__43349__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43351),null);
}
} else {
var item = cljs.core.first(s__43349__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__43346_$_iter__43348(cljs.core.rest(s__43349__$2)));
}
} else {
return null;
}
break;
}
});})(s__43347__$1,vec__43352,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__43347__$1,vec__43352,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43346(cljs.core.rest(s__43347__$1)));
} else {
var G__43398 = cljs.core.rest(s__43347__$1);
s__43347__$1 = G__43398;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__43355 = item;
var G__43356 = cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found;
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__43355,G__43356) : self__.item__GT_priority.call(null,G__43355,G__43356));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43357(s__43358){
return (new cljs.core.LazySeq(null,(function (){
var s__43358__$1 = s__43358;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43358__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43363 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43363,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43363,(1),null);
var iterys__4607__auto__ = ((function (s__43358__$1,vec__43363,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__43357_$_iter__43359(s__43360){
return (new cljs.core.LazySeq(null,((function (s__43358__$1,vec__43363,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__43360__$1 = s__43360;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43360__$1);
if(temp__5753__auto____$1){
var s__43360__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43360__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43360__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43362 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43361 = (0);
while(true){
if((i__43361 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43361);
cljs.core.chunk_append(b__43362,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__43399 = (i__43361 + (1));
i__43361 = G__43399;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43362),tailrecursion$priority_map$iter__43357_$_iter__43359(cljs.core.chunk_rest(s__43360__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43362),null);
}
} else {
var item = cljs.core.first(s__43360__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__43357_$_iter__43359(cljs.core.rest(s__43360__$2)));
}
} else {
return null;
}
break;
}
});})(s__43358__$1,vec__43363,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__43358__$1,vec__43363,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43357(cljs.core.rest(s__43358__$1)));
} else {
var G__43400 = cljs.core.rest(s__43358__$1);
s__43358__$1 = G__43400;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43366(s__43367){
return (new cljs.core.LazySeq(null,(function (){
var s__43367__$1 = s__43367;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43367__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43372 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43372,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43372,(1),null);
var iterys__4607__auto__ = ((function (s__43367__$1,vec__43372,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__43366_$_iter__43368(s__43369){
return (new cljs.core.LazySeq(null,((function (s__43367__$1,vec__43372,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__43369__$1 = s__43369;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43369__$1);
if(temp__5753__auto____$1){
var s__43369__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43369__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43369__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43371 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43370 = (0);
while(true){
if((i__43370 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43370);
cljs.core.chunk_append(b__43371,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__43401 = (i__43370 + (1));
i__43370 = G__43401;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43371),tailrecursion$priority_map$iter__43366_$_iter__43368(cljs.core.chunk_rest(s__43369__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43371),null);
}
} else {
var item = cljs.core.first(s__43369__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__43366_$_iter__43368(cljs.core.rest(s__43369__$2)));
}
} else {
return null;
}
break;
}
});})(s__43367__$1,vec__43372,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__43367__$1,vec__43372,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43366(cljs.core.rest(s__43367__$1)));
} else {
var G__43402 = cljs.core.rest(s__43367__$1);
s__43367__$1 = G__43402;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__43403 = null;
var G__43403__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__43403__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__43403 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__43403__2.call(this,self__,item);
case 3:
return G__43403__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__43403.cljs$core$IFn$_invoke$arity$2 = G__43403__2;
G__43403.cljs$core$IFn$_invoke$arity$3 = G__43403__3;
return G__43403;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args43336){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args43336)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__43375 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__43375.cljs$core$IFn$_invoke$arity$1 ? fexpr__43375.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__43375.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43376(s__43377){
return (new cljs.core.LazySeq(null,(function (){
var s__43377__$1 = s__43377;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43377__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43382 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43382,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43382,(1),null);
var iterys__4607__auto__ = ((function (s__43377__$1,vec__43382,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__43376_$_iter__43378(s__43379){
return (new cljs.core.LazySeq(null,((function (s__43377__$1,vec__43382,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__43379__$1 = s__43379;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43379__$1);
if(temp__5753__auto____$1){
var s__43379__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43379__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43379__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43381 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43380 = (0);
while(true){
if((i__43380 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43380);
cljs.core.chunk_append(b__43381,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__43404 = (i__43380 + (1));
i__43380 = G__43404;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43381),tailrecursion$priority_map$iter__43376_$_iter__43378(cljs.core.chunk_rest(s__43379__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43381),null);
}
} else {
var item = cljs.core.first(s__43379__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__43376_$_iter__43378(cljs.core.rest(s__43379__$2)));
}
} else {
return null;
}
break;
}
});})(s__43377__$1,vec__43382,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__43377__$1,vec__43382,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43376(cljs.core.rest(s__43377__$1)));
} else {
var G__43405 = cljs.core.rest(s__43377__$1);
s__43377__$1 = G__43405;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43385(s__43386){
return (new cljs.core.LazySeq(null,(function (){
var s__43386__$1 = s__43386;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43386__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43391 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43391,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43391,(1),null);
var iterys__4607__auto__ = ((function (s__43386__$1,vec__43391,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__43385_$_iter__43387(s__43388){
return (new cljs.core.LazySeq(null,((function (s__43386__$1,vec__43391,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__43388__$1 = s__43388;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43388__$1);
if(temp__5753__auto____$1){
var s__43388__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43388__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43388__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43390 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43389 = (0);
while(true){
if((i__43389 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43389);
cljs.core.chunk_append(b__43390,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__43406 = (i__43389 + (1));
i__43389 = G__43406;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43390),tailrecursion$priority_map$iter__43385_$_iter__43387(cljs.core.chunk_rest(s__43388__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43390),null);
}
} else {
var item = cljs.core.first(s__43388__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__43385_$_iter__43387(cljs.core.rest(s__43388__$2)));
}
} else {
return null;
}
break;
}
});})(s__43386__$1,vec__43391,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__43386__$1,vec__43391,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43385(cljs.core.rest(s__43386__$1)));
} else {
var G__43407 = cljs.core.rest(s__43386__$1);
s__43386__$1 = G__43407;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__43394 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__43394) : self__.keyfn.call(null,G__43394));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$priority_DASH__GT_set_DASH_of_DASH_items,cljs.core.cst$sym$item_DASH__GT_priority,cljs.core.cst$sym$meta,cljs.core.cst$sym$keyfn,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__43409 = arguments.length;
switch (G__43409) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4824__auto__ = [];
var len__4818__auto___43412 = arguments.length;
var i__4819__auto___43413 = (0);
while(true){
if((i__4819__auto___43413 < len__4818__auto___43412)){
args__4824__auto__.push((arguments[i__4819__auto___43413]));

var G__43414 = (i__4819__auto___43413 + (1));
i__4819__auto___43413 = G__43414;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__43415 = cljs.core.nnext(in$);
var G__43416 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43415;
out = G__43416;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq43411){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43411));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4824__auto__ = [];
var len__4818__auto___43419 = arguments.length;
var i__4819__auto___43420 = (0);
while(true){
if((i__4819__auto___43420 < len__4818__auto___43419)){
args__4824__auto__.push((arguments[i__4819__auto___43420]));

var G__43421 = (i__4819__auto___43420 + (1));
i__4819__auto___43420 = G__43421;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__43422 = cljs.core.nnext(in$);
var G__43423 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43422;
out = G__43423;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq43417){
var G__43418 = cljs.core.first(seq43417);
var seq43417__$1 = cljs.core.next(seq43417);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43418,seq43417__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4824__auto__ = [];
var len__4818__auto___43426 = arguments.length;
var i__4819__auto___43427 = (0);
while(true){
if((i__4819__auto___43427 < len__4818__auto___43426)){
args__4824__auto__.push((arguments[i__4819__auto___43427]));

var G__43428 = (i__4819__auto___43427 + (1));
i__4819__auto___43427 = G__43428;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__43429 = cljs.core.nnext(in$);
var G__43430 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43429;
out = G__43430;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq43424){
var G__43425 = cljs.core.first(seq43424);
var seq43424__$1 = cljs.core.next(seq43424);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43425,seq43424__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4824__auto__ = [];
var len__4818__auto___43434 = arguments.length;
var i__4819__auto___43435 = (0);
while(true){
if((i__4819__auto___43435 < len__4818__auto___43434)){
args__4824__auto__.push((arguments[i__4819__auto___43435]));

var G__43436 = (i__4819__auto___43435 + (1));
i__4819__auto___43435 = G__43436;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__43437 = cljs.core.nnext(in$);
var G__43438 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43437;
out = G__43438;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq43431){
var G__43432 = cljs.core.first(seq43431);
var seq43431__$1 = cljs.core.next(seq43431);
var G__43433 = cljs.core.first(seq43431__$1);
var seq43431__$2 = cljs.core.next(seq43431__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43432,G__43433,seq43431__$2);
}));

