// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29063){
var state_val_29064 = (state_29063[(1)]);
if((state_val_29064 === (7))){
var inst_29052 = (state_29063[(7)]);
var inst_29054 = fluree.db.storage.core.serde(conn);
var inst_29055 = fluree.db.serde.protocol._deserialize_block(inst_29054,inst_29052);
var state_29063__$1 = state_29063;
var statearr_29065_29084 = state_29063__$1;
(statearr_29065_29084[(2)] = inst_29055);

(statearr_29065_29084[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29064 === (1))){
var state_29063__$1 = state_29063;
var statearr_29066_29085 = state_29063__$1;
(statearr_29066_29085[(2)] = null);

(statearr_29066_29085[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29064 === (4))){
var inst_29042 = (state_29063[(2)]);
var state_29063__$1 = state_29063;
var statearr_29067_29086 = state_29063__$1;
(statearr_29067_29086[(2)] = inst_29042);

(statearr_29067_29086[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29064 === (6))){
var inst_29052 = (state_29063[(7)]);
var inst_29051 = (state_29063[(2)]);
var inst_29052__$1 = fluree.db.util.async.throw_err(inst_29051);
var state_29063__$1 = (function (){var statearr_29068 = state_29063;
(statearr_29068[(7)] = inst_29052__$1);

return statearr_29068;
})();
if(cljs.core.truth_(inst_29052__$1)){
var statearr_29069_29087 = state_29063__$1;
(statearr_29069_29087[(1)] = (7));

} else {
var statearr_29070_29088 = state_29063__$1;
(statearr_29070_29088[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29064 === (3))){
var inst_29061 = (state_29063[(2)]);
var state_29063__$1 = state_29063;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29063__$1,inst_29061);
} else {
if((state_val_29064 === (2))){
var _ = (function (){var statearr_29072 = state_29063;
(statearr_29072[(4)] = cljs.core.cons((5),(state_29063[(4)])));

return statearr_29072;
})();
var inst_29048 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_29049 = fluree.db.storage.core.storage_read(conn,inst_29048);
var state_29063__$1 = state_29063;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29063__$1,(6),inst_29049);
} else {
if((state_val_29064 === (9))){
var inst_29058 = (state_29063[(2)]);
var _ = (function (){var statearr_29073 = state_29063;
(statearr_29073[(4)] = cljs.core.rest((state_29063[(4)])));

return statearr_29073;
})();
var state_29063__$1 = state_29063;
var statearr_29074_29089 = state_29063__$1;
(statearr_29074_29089[(2)] = inst_29058);

(statearr_29074_29089[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29064 === (5))){
var _ = (function (){var statearr_29075 = state_29063;
(statearr_29075[(4)] = cljs.core.rest((state_29063[(4)])));

return statearr_29075;
})();
var state_29063__$1 = state_29063;
var ex29071 = (state_29063__$1[(2)]);
var statearr_29076_29090 = state_29063__$1;
(statearr_29076_29090[(5)] = ex29071);


if((ex29071 instanceof Error)){
var statearr_29077_29091 = state_29063__$1;
(statearr_29077_29091[(1)] = (4));

(statearr_29077_29091[(5)] = null);

} else {
throw ex29071;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29064 === (8))){
var state_29063__$1 = state_29063;
var statearr_29078_29092 = state_29063__$1;
(statearr_29078_29092[(2)] = null);

(statearr_29078_29092[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__10750__auto____0 = (function (){
var statearr_29079 = [null,null,null,null,null,null,null,null];
(statearr_29079[(0)] = fluree$db$storage$core$read_block_$_state_machine__10750__auto__);

(statearr_29079[(1)] = (1));

return statearr_29079;
});
var fluree$db$storage$core$read_block_$_state_machine__10750__auto____1 = (function (state_29063){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29063);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29080){var ex__10753__auto__ = e29080;
var statearr_29081_29093 = state_29063;
(statearr_29081_29093[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29063[(4)]))){
var statearr_29082_29094 = state_29063;
(statearr_29082_29094[(1)] = cljs.core.first((state_29063[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29095 = state_29063;
state_29063 = G__29095;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__10750__auto__ = function(state_29063){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__10750__auto____1.call(this,state_29063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__10750__auto____0;
fluree$db$storage$core$read_block_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__10750__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29083 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29083[(6)] = c__10876__auto__);

return statearr_29083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29118){
var state_val_29119 = (state_29118[(1)]);
if((state_val_29119 === (7))){
var inst_29107 = (state_29118[(7)]);
var inst_29109 = fluree.db.storage.core.serde(conn);
var inst_29110 = fluree.db.serde.protocol._deserialize_block(inst_29109,inst_29107);
var state_29118__$1 = state_29118;
var statearr_29120_29139 = state_29118__$1;
(statearr_29120_29139[(2)] = inst_29110);

(statearr_29120_29139[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29119 === (1))){
var state_29118__$1 = state_29118;
var statearr_29121_29140 = state_29118__$1;
(statearr_29121_29140[(2)] = null);

(statearr_29121_29140[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29119 === (4))){
var inst_29096 = (state_29118[(2)]);
var state_29118__$1 = state_29118;
var statearr_29122_29141 = state_29118__$1;
(statearr_29122_29141[(2)] = inst_29096);

(statearr_29122_29141[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29119 === (6))){
var inst_29107 = (state_29118[(7)]);
var inst_29106 = (state_29118[(2)]);
var inst_29107__$1 = fluree.db.util.async.throw_err(inst_29106);
var state_29118__$1 = (function (){var statearr_29123 = state_29118;
(statearr_29123[(7)] = inst_29107__$1);

return statearr_29123;
})();
if(cljs.core.truth_(inst_29107__$1)){
var statearr_29124_29142 = state_29118__$1;
(statearr_29124_29142[(1)] = (7));

} else {
var statearr_29125_29143 = state_29118__$1;
(statearr_29125_29143[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29119 === (3))){
var inst_29116 = (state_29118[(2)]);
var state_29118__$1 = state_29118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29118__$1,inst_29116);
} else {
if((state_val_29119 === (2))){
var _ = (function (){var statearr_29127 = state_29118;
(statearr_29127[(4)] = cljs.core.cons((5),(state_29118[(4)])));

return statearr_29127;
})();
var inst_29102 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_29103 = [inst_29102,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_29104 = fluree.db.storage.core.storage_read(conn,inst_29103);
var state_29118__$1 = state_29118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29118__$1,(6),inst_29104);
} else {
if((state_val_29119 === (9))){
var inst_29113 = (state_29118[(2)]);
var _ = (function (){var statearr_29128 = state_29118;
(statearr_29128[(4)] = cljs.core.rest((state_29118[(4)])));

return statearr_29128;
})();
var state_29118__$1 = state_29118;
var statearr_29129_29144 = state_29118__$1;
(statearr_29129_29144[(2)] = inst_29113);

(statearr_29129_29144[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29119 === (5))){
var _ = (function (){var statearr_29130 = state_29118;
(statearr_29130[(4)] = cljs.core.rest((state_29118[(4)])));

return statearr_29130;
})();
var state_29118__$1 = state_29118;
var ex29126 = (state_29118__$1[(2)]);
var statearr_29131_29145 = state_29118__$1;
(statearr_29131_29145[(5)] = ex29126);


if((ex29126 instanceof Error)){
var statearr_29132_29146 = state_29118__$1;
(statearr_29132_29146[(1)] = (4));

(statearr_29132_29146[(5)] = null);

} else {
throw ex29126;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29119 === (8))){
var state_29118__$1 = state_29118;
var statearr_29133_29147 = state_29118__$1;
(statearr_29133_29147[(2)] = null);

(statearr_29133_29147[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__10750__auto____0 = (function (){
var statearr_29134 = [null,null,null,null,null,null,null,null];
(statearr_29134[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__10750__auto__);

(statearr_29134[(1)] = (1));

return statearr_29134;
});
var fluree$db$storage$core$read_block_version_$_state_machine__10750__auto____1 = (function (state_29118){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29118);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29135){var ex__10753__auto__ = e29135;
var statearr_29136_29148 = state_29118;
(statearr_29136_29148[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29118[(4)]))){
var statearr_29137_29149 = state_29118;
(statearr_29137_29149[(1)] = cljs.core.first((state_29118[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29150 = state_29118;
state_29118 = G__29150;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__10750__auto__ = function(state_29118){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__10750__auto____1.call(this,state_29118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__10750__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__10750__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29138 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29138[(6)] = c__10876__auto__);

return statearr_29138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29174){
var state_val_29175 = (state_29174[(1)]);
if((state_val_29175 === (1))){
var state_29174__$1 = state_29174;
var statearr_29176_29190 = state_29174__$1;
(statearr_29176_29190[(2)] = null);

(statearr_29176_29190[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29175 === (2))){
var _ = (function (){var statearr_29177 = state_29174;
(statearr_29177[(4)] = cljs.core.cons((5),(state_29174[(4)])));

return statearr_29177;
})();
var inst_29157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29158 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_29159 = (new cljs.core.PersistentVector(null,3,(5),inst_29157,inst_29158,null));
var inst_29160 = cljs.core.select_keys(block_data,inst_29159);
var inst_29161 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_29160);
var inst_29162 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_29161);
var inst_29163 = [inst_29162,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_29164 = fluree.db.storage.core.serde(conn);
var inst_29165 = fluree.db.serde.protocol._serialize_block(inst_29164,inst_29160);
var inst_29166 = fluree.db.storage.core.storage_write(conn,inst_29163,inst_29165);
var state_29174__$1 = state_29174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29174__$1,(6),inst_29166);
} else {
if((state_val_29175 === (3))){
var inst_29172 = (state_29174[(2)]);
var state_29174__$1 = state_29174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29174__$1,inst_29172);
} else {
if((state_val_29175 === (4))){
var inst_29151 = (state_29174[(2)]);
var state_29174__$1 = state_29174;
var statearr_29179_29191 = state_29174__$1;
(statearr_29179_29191[(2)] = inst_29151);

(statearr_29179_29191[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29175 === (5))){
var _ = (function (){var statearr_29180 = state_29174;
(statearr_29180[(4)] = cljs.core.rest((state_29174[(4)])));

return statearr_29180;
})();
var state_29174__$1 = state_29174;
var ex29178 = (state_29174__$1[(2)]);
var statearr_29181_29192 = state_29174__$1;
(statearr_29181_29192[(5)] = ex29178);


if((ex29178 instanceof Error)){
var statearr_29182_29193 = state_29174__$1;
(statearr_29182_29193[(1)] = (4));

(statearr_29182_29193[(5)] = null);

} else {
throw ex29178;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29175 === (6))){
var inst_29168 = (state_29174[(2)]);
var inst_29169 = fluree.db.util.async.throw_err(inst_29168);
var _ = (function (){var statearr_29183 = state_29174;
(statearr_29183[(4)] = cljs.core.rest((state_29174[(4)])));

return statearr_29183;
})();
var state_29174__$1 = state_29174;
var statearr_29184_29194 = state_29174__$1;
(statearr_29184_29194[(2)] = inst_29169);

(statearr_29184_29194[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__10750__auto____0 = (function (){
var statearr_29185 = [null,null,null,null,null,null,null];
(statearr_29185[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__10750__auto__);

(statearr_29185[(1)] = (1));

return statearr_29185;
});
var fluree$db$storage$core$write_block_version_$_state_machine__10750__auto____1 = (function (state_29174){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29174);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29186){var ex__10753__auto__ = e29186;
var statearr_29187_29195 = state_29174;
(statearr_29187_29195[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29174[(4)]))){
var statearr_29188_29196 = state_29174;
(statearr_29188_29196[(1)] = cljs.core.first((state_29174[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29197 = state_29174;
state_29174 = G__29197;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__10750__auto__ = function(state_29174){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__10750__auto____1.call(this,state_29174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__10750__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__10750__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29189 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29189[(6)] = c__10876__auto__);

return statearr_29189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29220){
var state_val_29221 = (state_29220[(1)]);
if((state_val_29221 === (1))){
var state_29220__$1 = state_29220;
var statearr_29222_29236 = state_29220__$1;
(statearr_29222_29236[(2)] = null);

(statearr_29222_29236[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29221 === (2))){
var _ = (function (){var statearr_29223 = state_29220;
(statearr_29223[(4)] = cljs.core.cons((5),(state_29220[(4)])));

return statearr_29223;
})();
var inst_29204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29205 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_29206 = (new cljs.core.PersistentVector(null,3,(5),inst_29204,inst_29205,null));
var inst_29207 = cljs.core.select_keys(block_data,inst_29206);
var inst_29208 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_29207);
var inst_29209 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_29208);
var inst_29210 = fluree.db.storage.core.serde(conn);
var inst_29211 = fluree.db.serde.protocol._serialize_block(inst_29210,inst_29207);
var inst_29212 = fluree.db.storage.core.storage_write(conn,inst_29209,inst_29211);
var state_29220__$1 = state_29220;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29220__$1,(6),inst_29212);
} else {
if((state_val_29221 === (3))){
var inst_29218 = (state_29220[(2)]);
var state_29220__$1 = state_29220;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29220__$1,inst_29218);
} else {
if((state_val_29221 === (4))){
var inst_29198 = (state_29220[(2)]);
var state_29220__$1 = state_29220;
var statearr_29225_29237 = state_29220__$1;
(statearr_29225_29237[(2)] = inst_29198);

(statearr_29225_29237[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29221 === (5))){
var _ = (function (){var statearr_29226 = state_29220;
(statearr_29226[(4)] = cljs.core.rest((state_29220[(4)])));

return statearr_29226;
})();
var state_29220__$1 = state_29220;
var ex29224 = (state_29220__$1[(2)]);
var statearr_29227_29238 = state_29220__$1;
(statearr_29227_29238[(5)] = ex29224);


if((ex29224 instanceof Error)){
var statearr_29228_29239 = state_29220__$1;
(statearr_29228_29239[(1)] = (4));

(statearr_29228_29239[(5)] = null);

} else {
throw ex29224;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29221 === (6))){
var inst_29214 = (state_29220[(2)]);
var inst_29215 = fluree.db.util.async.throw_err(inst_29214);
var _ = (function (){var statearr_29229 = state_29220;
(statearr_29229[(4)] = cljs.core.rest((state_29220[(4)])));

return statearr_29229;
})();
var state_29220__$1 = state_29220;
var statearr_29230_29240 = state_29220__$1;
(statearr_29230_29240[(2)] = inst_29215);

(statearr_29230_29240[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__10750__auto____0 = (function (){
var statearr_29231 = [null,null,null,null,null,null,null];
(statearr_29231[(0)] = fluree$db$storage$core$write_block_$_state_machine__10750__auto__);

(statearr_29231[(1)] = (1));

return statearr_29231;
});
var fluree$db$storage$core$write_block_$_state_machine__10750__auto____1 = (function (state_29220){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29220);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29232){var ex__10753__auto__ = e29232;
var statearr_29233_29241 = state_29220;
(statearr_29233_29241[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29220[(4)]))){
var statearr_29234_29242 = state_29220;
(statearr_29234_29242[(1)] = cljs.core.first((state_29220[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29243 = state_29220;
state_29220 = G__29243;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__10750__auto__ = function(state_29220){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__10750__auto____1.call(this,state_29220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__10750__auto____0;
fluree$db$storage$core$write_block_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__10750__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29235 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29235[(6)] = c__10876__auto__);

return statearr_29235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29263){
var state_val_29264 = (state_29263[(1)]);
if((state_val_29264 === (1))){
var state_29263__$1 = state_29263;
var statearr_29265_29279 = state_29263__$1;
(statearr_29265_29279[(2)] = null);

(statearr_29265_29279[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29264 === (2))){
var _ = (function (){var statearr_29266 = state_29263;
(statearr_29266[(4)] = cljs.core.cons((5),(state_29263[(4)])));

return statearr_29266;
})();
var inst_29250 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_29251 = [history,next_his_key];
var inst_29252 = cljs.core.PersistentHashMap.fromArrays(inst_29250,inst_29251);
var inst_29253 = fluree.db.storage.core.serde(conn);
var inst_29254 = fluree.db.serde.protocol._serialize_leaf(inst_29253,inst_29252);
var inst_29255 = fluree.db.storage.core.storage_write(conn,his_key,inst_29254);
var state_29263__$1 = state_29263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29263__$1,(6),inst_29255);
} else {
if((state_val_29264 === (3))){
var inst_29261 = (state_29263[(2)]);
var state_29263__$1 = state_29263;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29263__$1,inst_29261);
} else {
if((state_val_29264 === (4))){
var inst_29244 = (state_29263[(2)]);
var state_29263__$1 = state_29263;
var statearr_29268_29280 = state_29263__$1;
(statearr_29268_29280[(2)] = inst_29244);

(statearr_29268_29280[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29264 === (5))){
var _ = (function (){var statearr_29269 = state_29263;
(statearr_29269[(4)] = cljs.core.rest((state_29263[(4)])));

return statearr_29269;
})();
var state_29263__$1 = state_29263;
var ex29267 = (state_29263__$1[(2)]);
var statearr_29270_29281 = state_29263__$1;
(statearr_29270_29281[(5)] = ex29267);


if((ex29267 instanceof Error)){
var statearr_29271_29282 = state_29263__$1;
(statearr_29271_29282[(1)] = (4));

(statearr_29271_29282[(5)] = null);

} else {
throw ex29267;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29264 === (6))){
var inst_29257 = (state_29263[(2)]);
var inst_29258 = fluree.db.util.async.throw_err(inst_29257);
var _ = (function (){var statearr_29272 = state_29263;
(statearr_29272[(4)] = cljs.core.rest((state_29263[(4)])));

return statearr_29272;
})();
var state_29263__$1 = state_29263;
var statearr_29273_29283 = state_29263__$1;
(statearr_29273_29283[(2)] = inst_29258);

(statearr_29273_29283[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__10750__auto____0 = (function (){
var statearr_29274 = [null,null,null,null,null,null,null];
(statearr_29274[(0)] = fluree$db$storage$core$write_history_$_state_machine__10750__auto__);

(statearr_29274[(1)] = (1));

return statearr_29274;
});
var fluree$db$storage$core$write_history_$_state_machine__10750__auto____1 = (function (state_29263){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29263);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29275){var ex__10753__auto__ = e29275;
var statearr_29276_29284 = state_29263;
(statearr_29276_29284[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29263[(4)]))){
var statearr_29277_29285 = state_29263;
(statearr_29277_29285[(1)] = cljs.core.first((state_29263[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29286 = state_29263;
state_29263 = G__29286;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__10750__auto__ = function(state_29263){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__10750__auto____1.call(this,state_29263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__10750__auto____0;
fluree$db$storage$core$write_history_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__10750__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29278 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29278[(6)] = c__10876__auto__);

return statearr_29278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29312){
var state_val_29313 = (state_29312[(1)]);
if((state_val_29313 === (1))){
var state_29312__$1 = state_29312;
var statearr_29314_29331 = state_29312__$1;
(statearr_29314_29331[(2)] = null);

(statearr_29314_29331[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29313 === (2))){
var inst_29293 = (state_29312[(7)]);
var _ = (function (){var statearr_29315 = state_29312;
(statearr_29315[(4)] = cljs.core.cons((5),(state_29312[(4)])));

return statearr_29315;
})();
var inst_29293__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_29294 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29293__$1),"-his"].join('');
var inst_29295 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_29296 = [flakes,inst_29294];
var inst_29297 = cljs.core.PersistentHashMap.fromArrays(inst_29295,inst_29296);
var inst_29298 = fluree.db.storage.core.serde(conn);
var inst_29299 = fluree.db.serde.protocol._serialize_leaf(inst_29298,inst_29297);
var inst_29300 = fluree.db.storage.core.write_history(conn,history,inst_29294,null);
var inst_29301 = fluree.db.storage.core.storage_write(conn,inst_29293__$1,inst_29299);
var state_29312__$1 = (function (){var statearr_29316 = state_29312;
(statearr_29316[(8)] = inst_29301);

(statearr_29316[(7)] = inst_29293__$1);

return statearr_29316;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29312__$1,(6),inst_29300);
} else {
if((state_val_29313 === (3))){
var inst_29310 = (state_29312[(2)]);
var state_29312__$1 = state_29312;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29312__$1,inst_29310);
} else {
if((state_val_29313 === (4))){
var inst_29287 = (state_29312[(2)]);
var state_29312__$1 = state_29312;
var statearr_29318_29332 = state_29312__$1;
(statearr_29318_29332[(2)] = inst_29287);

(statearr_29318_29332[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29313 === (5))){
var _ = (function (){var statearr_29319 = state_29312;
(statearr_29319[(4)] = cljs.core.rest((state_29312[(4)])));

return statearr_29319;
})();
var state_29312__$1 = state_29312;
var ex29317 = (state_29312__$1[(2)]);
var statearr_29320_29333 = state_29312__$1;
(statearr_29320_29333[(5)] = ex29317);


if((ex29317 instanceof Error)){
var statearr_29321_29334 = state_29312__$1;
(statearr_29321_29334[(1)] = (4));

(statearr_29321_29334[(5)] = null);

} else {
throw ex29317;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29313 === (6))){
var inst_29301 = (state_29312[(8)]);
var inst_29303 = (state_29312[(2)]);
var inst_29304 = fluree.db.util.async.throw_err(inst_29303);
var state_29312__$1 = (function (){var statearr_29322 = state_29312;
(statearr_29322[(9)] = inst_29304);

return statearr_29322;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29312__$1,(7),inst_29301);
} else {
if((state_val_29313 === (7))){
var inst_29293 = (state_29312[(7)]);
var inst_29306 = (state_29312[(2)]);
var inst_29307 = fluree.db.util.async.throw_err(inst_29306);
var _ = (function (){var statearr_29323 = state_29312;
(statearr_29323[(4)] = cljs.core.rest((state_29312[(4)])));

return statearr_29323;
})();
var state_29312__$1 = (function (){var statearr_29324 = state_29312;
(statearr_29324[(10)] = inst_29307);

return statearr_29324;
})();
var statearr_29325_29335 = state_29312__$1;
(statearr_29325_29335[(2)] = inst_29293);

(statearr_29325_29335[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__10750__auto____0 = (function (){
var statearr_29326 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29326[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__10750__auto__);

(statearr_29326[(1)] = (1));

return statearr_29326;
});
var fluree$db$storage$core$write_leaf_$_state_machine__10750__auto____1 = (function (state_29312){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29312);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29327){var ex__10753__auto__ = e29327;
var statearr_29328_29336 = state_29312;
(statearr_29328_29336[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29312[(4)]))){
var statearr_29329_29337 = state_29312;
(statearr_29329_29337[(1)] = cljs.core.first((state_29312[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29338 = state_29312;
state_29312 = G__29338;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__10750__auto__ = function(state_29312){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__10750__auto____1.call(this,state_29312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__10750__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__10750__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29330 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29330[(6)] = c__10876__auto__);

return statearr_29330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29355){
var state_val_29356 = (state_29355[(1)]);
if((state_val_29356 === (1))){
var state_29355__$1 = state_29355;
var statearr_29357_29372 = state_29355__$1;
(statearr_29357_29372[(2)] = null);

(statearr_29357_29372[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29356 === (2))){
var _ = (function (){var statearr_29358 = state_29355;
(statearr_29358[(4)] = cljs.core.cons((5),(state_29355[(4)])));

return statearr_29358;
})();
var inst_29345 = fluree.db.storage.core.serde(conn);
var inst_29346 = fluree.db.serde.protocol._serialize_branch(inst_29345,data);
var inst_29347 = fluree.db.storage.core.storage_write(conn,key,inst_29346);
var state_29355__$1 = state_29355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29355__$1,(6),inst_29347);
} else {
if((state_val_29356 === (3))){
var inst_29353 = (state_29355[(2)]);
var state_29355__$1 = state_29355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29355__$1,inst_29353);
} else {
if((state_val_29356 === (4))){
var inst_29339 = (state_29355[(2)]);
var state_29355__$1 = state_29355;
var statearr_29360_29373 = state_29355__$1;
(statearr_29360_29373[(2)] = inst_29339);

(statearr_29360_29373[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29356 === (5))){
var _ = (function (){var statearr_29361 = state_29355;
(statearr_29361[(4)] = cljs.core.rest((state_29355[(4)])));

return statearr_29361;
})();
var state_29355__$1 = state_29355;
var ex29359 = (state_29355__$1[(2)]);
var statearr_29362_29374 = state_29355__$1;
(statearr_29362_29374[(5)] = ex29359);


if((ex29359 instanceof Error)){
var statearr_29363_29375 = state_29355__$1;
(statearr_29363_29375[(1)] = (4));

(statearr_29363_29375[(5)] = null);

} else {
throw ex29359;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29356 === (6))){
var inst_29349 = (state_29355[(2)]);
var inst_29350 = fluree.db.util.async.throw_err(inst_29349);
var _ = (function (){var statearr_29364 = state_29355;
(statearr_29364[(4)] = cljs.core.rest((state_29355[(4)])));

return statearr_29364;
})();
var state_29355__$1 = (function (){var statearr_29365 = state_29355;
(statearr_29365[(7)] = inst_29350);

return statearr_29365;
})();
var statearr_29366_29376 = state_29355__$1;
(statearr_29366_29376[(2)] = key);

(statearr_29366_29376[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__10750__auto____0 = (function (){
var statearr_29367 = [null,null,null,null,null,null,null,null];
(statearr_29367[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__10750__auto__);

(statearr_29367[(1)] = (1));

return statearr_29367;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__10750__auto____1 = (function (state_29355){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29355);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29368){var ex__10753__auto__ = e29368;
var statearr_29369_29377 = state_29355;
(statearr_29369_29377[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29355[(4)]))){
var statearr_29370_29378 = state_29355;
(statearr_29370_29378[(1)] = cljs.core.first((state_29355[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29379 = state_29355;
state_29355 = G__29379;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__10750__auto__ = function(state_29355){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__10750__auto____1.call(this,state_29355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__10750__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__10750__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29371 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29371[(6)] = c__10876__auto__);

return statearr_29371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__29380_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__29380_SHARP_));
}),children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__29381){
var map__29382 = p__29381;
var map__29382__$1 = cljs.core.__destructure_map(map__29382);
var progress = map__29382__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29382__$1,cljs.core.cst$kw$garbage);
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29410){
var state_val_29411 = (state_29410[(1)]);
if((state_val_29411 === (1))){
var state_29410__$1 = state_29410;
var statearr_29412_29428 = state_29410__$1;
(statearr_29412_29428[(2)] = null);

(statearr_29412_29428[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29411 === (2))){
var inst_29396 = (state_29410[(7)]);
var _ = (function (){var statearr_29413 = state_29410;
(statearr_29413[(4)] = cljs.core.cons((5),(state_29410[(4)])));

return statearr_29413;
})();
var inst_29390 = db;
var inst_29391 = cljs.core.__destructure_map(inst_29390);
var inst_29392 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29391,cljs.core.cst$kw$conn);
var inst_29393 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29391,cljs.core.cst$kw$network);
var inst_29394 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29391,cljs.core.cst$kw$dbid);
var inst_29395 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29391,cljs.core.cst$kw$block);
var inst_29396__$1 = fluree.db.storage.core.ledger_garbage_key(inst_29393,inst_29394,inst_29395);
var inst_29397 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_29398 = [inst_29394,inst_29395,garbage];
var inst_29399 = cljs.core.PersistentHashMap.fromArrays(inst_29397,inst_29398);
var inst_29400 = fluree.db.storage.core.serde(inst_29392);
var inst_29401 = fluree.db.serde.protocol._serialize_garbage(inst_29400,inst_29399);
var inst_29402 = fluree.db.storage.core.storage_write(inst_29392,inst_29396__$1,inst_29401);
var state_29410__$1 = (function (){var statearr_29414 = state_29410;
(statearr_29414[(7)] = inst_29396__$1);

return statearr_29414;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29410__$1,(6),inst_29402);
} else {
if((state_val_29411 === (3))){
var inst_29408 = (state_29410[(2)]);
var state_29410__$1 = state_29410;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29410__$1,inst_29408);
} else {
if((state_val_29411 === (4))){
var inst_29383 = (state_29410[(2)]);
var state_29410__$1 = state_29410;
var statearr_29416_29429 = state_29410__$1;
(statearr_29416_29429[(2)] = inst_29383);

(statearr_29416_29429[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29411 === (5))){
var _ = (function (){var statearr_29417 = state_29410;
(statearr_29417[(4)] = cljs.core.rest((state_29410[(4)])));

return statearr_29417;
})();
var state_29410__$1 = state_29410;
var ex29415 = (state_29410__$1[(2)]);
var statearr_29418_29430 = state_29410__$1;
(statearr_29418_29430[(5)] = ex29415);


if((ex29415 instanceof Error)){
var statearr_29419_29431 = state_29410__$1;
(statearr_29419_29431[(1)] = (4));

(statearr_29419_29431[(5)] = null);

} else {
throw ex29415;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29411 === (6))){
var inst_29396 = (state_29410[(7)]);
var inst_29404 = (state_29410[(2)]);
var inst_29405 = fluree.db.util.async.throw_err(inst_29404);
var _ = (function (){var statearr_29420 = state_29410;
(statearr_29420[(4)] = cljs.core.rest((state_29410[(4)])));

return statearr_29420;
})();
var state_29410__$1 = (function (){var statearr_29421 = state_29410;
(statearr_29421[(8)] = inst_29405);

return statearr_29421;
})();
var statearr_29422_29432 = state_29410__$1;
(statearr_29422_29432[(2)] = inst_29396);

(statearr_29422_29432[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__10750__auto____0 = (function (){
var statearr_29423 = [null,null,null,null,null,null,null,null,null];
(statearr_29423[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__10750__auto__);

(statearr_29423[(1)] = (1));

return statearr_29423;
});
var fluree$db$storage$core$write_garbage_$_state_machine__10750__auto____1 = (function (state_29410){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29410);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29424){var ex__10753__auto__ = e29424;
var statearr_29425_29433 = state_29410;
(statearr_29425_29433[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29410[(4)]))){
var statearr_29426_29434 = state_29410;
(statearr_29426_29434[(1)] = cljs.core.first((state_29410[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29435 = state_29410;
state_29410 = G__29435;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__10750__auto__ = function(state_29410){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__10750__auto____1.call(this,state_29410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__10750__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__10750__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29427 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29427[(6)] = c__10876__auto__);

return statearr_29427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__29437 = arguments.length;
switch (G__29437) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29493){
var state_val_29494 = (state_29493[(1)]);
if((state_val_29494 === (7))){
var state_29493__$1 = state_29493;
var statearr_29495_29521 = state_29493__$1;
(statearr_29495_29521[(2)] = (0));

(statearr_29495_29521[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29494 === (1))){
var state_29493__$1 = state_29493;
var statearr_29496_29522 = state_29493__$1;
(statearr_29496_29522[(2)] = null);

(statearr_29496_29522[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29494 === (4))){
var inst_29438 = (state_29493[(2)]);
var state_29493__$1 = state_29493;
var statearr_29497_29523 = state_29493__$1;
(statearr_29497_29523[(2)] = inst_29438);

(statearr_29497_29523[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29494 === (6))){
var inst_29463 = (state_29493[(7)]);
var state_29493__$1 = state_29493;
var statearr_29498_29524 = state_29493__$1;
(statearr_29498_29524[(2)] = inst_29463);

(statearr_29498_29524[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29494 === (3))){
var inst_29491 = (state_29493[(2)]);
var state_29493__$1 = state_29493;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29493__$1,inst_29491);
} else {
if((state_val_29494 === (12))){
var inst_29460 = (state_29493[(8)]);
var inst_29487 = (state_29493[(2)]);
var inst_29488 = fluree.db.util.async.throw_err(inst_29487);
var _ = (function (){var statearr_29499 = state_29493;
(statearr_29499[(4)] = cljs.core.rest((state_29493[(4)])));

return statearr_29499;
})();
var state_29493__$1 = (function (){var statearr_29500 = state_29493;
(statearr_29500[(9)] = inst_29488);

return statearr_29500;
})();
var statearr_29501_29525 = state_29493__$1;
(statearr_29501_29525[(2)] = inst_29460);

(statearr_29501_29525[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29494 === (2))){
var inst_29453 = (state_29493[(10)]);
var inst_29455 = (state_29493[(11)]);
var inst_29451 = (state_29493[(12)]);
var inst_29463 = (state_29493[(7)]);
var _ = (function (){var statearr_29502 = state_29493;
(statearr_29502[(4)] = cljs.core.cons((5),(state_29493[(4)])));

return statearr_29502;
})();
var inst_29445 = db;
var inst_29446 = cljs.core.__destructure_map(inst_29445);
var inst_29447 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$network);
var inst_29448 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$t);
var inst_29449 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$fork);
var inst_29450 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$spot);
var inst_29451__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$stats);
var inst_29452 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$conn);
var inst_29453__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$block);
var inst_29454 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$psot);
var inst_29455__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$dbid);
var inst_29456 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$ecount);
var inst_29457 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$opst);
var inst_29458 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$fork_DASH_block);
var inst_29459 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29446,cljs.core.cst$kw$post);
var inst_29460 = fluree.db.storage.core.ledger_root_key(inst_29447,inst_29455__$1,inst_29453__$1);
var inst_29461 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_29462 = fluree.db.storage.core.child_data(inst_29454);
var inst_29463__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_29451__$1);
var state_29493__$1 = (function (){var statearr_29503 = state_29493;
(statearr_29503[(13)] = inst_29449);

(statearr_29503[(14)] = inst_29461);

(statearr_29503[(15)] = inst_29459);

(statearr_29503[(10)] = inst_29453__$1);

(statearr_29503[(11)] = inst_29455__$1);

(statearr_29503[(16)] = inst_29450);

(statearr_29503[(17)] = inst_29462);

(statearr_29503[(12)] = inst_29451__$1);

(statearr_29503[(18)] = inst_29457);

(statearr_29503[(8)] = inst_29460);

(statearr_29503[(7)] = inst_29463__$1);

(statearr_29503[(19)] = inst_29458);

(statearr_29503[(20)] = inst_29452);

(statearr_29503[(21)] = inst_29456);

(statearr_29503[(22)] = inst_29448);

return statearr_29503;
})();
if(cljs.core.truth_(inst_29463__$1)){
var statearr_29504_29526 = state_29493__$1;
(statearr_29504_29526[(1)] = (6));

} else {
var statearr_29505_29527 = state_29493__$1;
(statearr_29505_29527[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29494 === (11))){
var inst_29449 = (state_29493[(13)]);
var inst_29467 = (state_29493[(23)]);
var inst_29461 = (state_29493[(14)]);
var inst_29459 = (state_29493[(15)]);
var inst_29453 = (state_29493[(10)]);
var inst_29455 = (state_29493[(11)]);
var inst_29450 = (state_29493[(16)]);
var inst_29462 = (state_29493[(17)]);
var inst_29451 = (state_29493[(12)]);
var inst_29457 = (state_29493[(18)]);
var inst_29460 = (state_29493[(8)]);
var inst_29458 = (state_29493[(19)]);
var inst_29452 = (state_29493[(20)]);
var inst_29448 = (state_29493[(22)]);
var inst_29472 = (state_29493[(2)]);
var inst_29473 = fluree.db.storage.core.child_data(inst_29457);
var inst_29474 = fluree.db.storage.core.child_data(inst_29459);
var inst_29475 = fluree.db.util.core.current_time_millis();
var inst_29476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29477 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_29478 = (new cljs.core.PersistentVector(null,2,(5),inst_29476,inst_29477,null));
var inst_29479 = cljs.core.select_keys(inst_29451,inst_29478);
var inst_29480 = fluree.db.storage.core.child_data(inst_29450);
var inst_29481 = [inst_29453,inst_29462,inst_29455,inst_29467,inst_29472,inst_29473,inst_29474,inst_29448,inst_29475,inst_29449,inst_29458,inst_29479,inst_29480];
var inst_29482 = cljs.core.PersistentHashMap.fromArrays(inst_29461,inst_29481);
var inst_29483 = fluree.db.storage.core.serde(inst_29452);
var inst_29484 = fluree.db.serde.protocol._serialize_db_root(inst_29483,inst_29482);
var inst_29485 = fluree.db.storage.core.storage_write(inst_29452,inst_29460,inst_29484);
var state_29493__$1 = state_29493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29493__$1,(12),inst_29485);
} else {
if((state_val_29494 === (9))){
var inst_29468 = (state_29493[(24)]);
var state_29493__$1 = state_29493;
var statearr_29507_29528 = state_29493__$1;
(statearr_29507_29528[(2)] = inst_29468);

(statearr_29507_29528[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29494 === (5))){
var _ = (function (){var statearr_29508 = state_29493;
(statearr_29508[(4)] = cljs.core.rest((state_29493[(4)])));

return statearr_29508;
})();
var state_29493__$1 = state_29493;
var ex29506 = (state_29493__$1[(2)]);
var statearr_29509_29529 = state_29493__$1;
(statearr_29509_29529[(5)] = ex29506);


if((ex29506 instanceof Error)){
var statearr_29510_29530 = state_29493__$1;
(statearr_29510_29530[(1)] = (4));

(statearr_29510_29530[(5)] = null);

} else {
throw ex29506;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29494 === (10))){
var inst_29456 = (state_29493[(21)]);
var state_29493__$1 = state_29493;
var statearr_29511_29531 = state_29493__$1;
(statearr_29511_29531[(2)] = inst_29456);

(statearr_29511_29531[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29494 === (8))){
var inst_29468 = (state_29493[(24)]);
var inst_29467 = (state_29493[(2)]);
var inst_29468__$1 = custom_ecount;
var state_29493__$1 = (function (){var statearr_29512 = state_29493;
(statearr_29512[(24)] = inst_29468__$1);

(statearr_29512[(23)] = inst_29467);

return statearr_29512;
})();
if(cljs.core.truth_(inst_29468__$1)){
var statearr_29513_29532 = state_29493__$1;
(statearr_29513_29532[(1)] = (9));

} else {
var statearr_29514_29533 = state_29493__$1;
(statearr_29514_29533[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__10750__auto__ = null;
var fluree$db$storage$core$state_machine__10750__auto____0 = (function (){
var statearr_29515 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29515[(0)] = fluree$db$storage$core$state_machine__10750__auto__);

(statearr_29515[(1)] = (1));

return statearr_29515;
});
var fluree$db$storage$core$state_machine__10750__auto____1 = (function (state_29493){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29493);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29516){var ex__10753__auto__ = e29516;
var statearr_29517_29534 = state_29493;
(statearr_29517_29534[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29493[(4)]))){
var statearr_29518_29535 = state_29493;
(statearr_29518_29535[(1)] = cljs.core.first((state_29493[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29536 = state_29493;
state_29493 = G__29536;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__10750__auto__ = function(state_29493){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__10750__auto____1.call(this,state_29493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__10750__auto____0;
fluree$db$storage$core$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__10750__auto____1;
return fluree$db$storage$core$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29519 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29519[(6)] = c__10876__auto__);

return statearr_29519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10876__auto___29595 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29569){
var state_val_29570 = (state_29569[(1)]);
if((state_val_29570 === (7))){
var inst_29549 = (state_29569[(7)]);
var state_29569__$1 = state_29569;
var statearr_29571_29596 = state_29569__$1;
(statearr_29571_29596[(2)] = inst_29549);

(statearr_29571_29596[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29570 === (1))){
var state_29569__$1 = state_29569;
var statearr_29572_29597 = state_29569__$1;
(statearr_29572_29597[(2)] = null);

(statearr_29572_29597[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29570 === (4))){
var inst_29537 = (state_29569[(2)]);
var inst_29538 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_29539 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_29537);
var inst_29540 = cljs.core.async.close_BANG_(return_ch);
var state_29569__$1 = (function (){var statearr_29573 = state_29569;
(statearr_29573[(8)] = inst_29538);

(statearr_29573[(9)] = inst_29539);

return statearr_29573;
})();
var statearr_29574_29598 = state_29569__$1;
(statearr_29574_29598[(2)] = inst_29540);

(statearr_29574_29598[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29570 === (6))){
var inst_29549 = (state_29569[(7)]);
var inst_29548 = (state_29569[(10)]);
var inst_29548__$1 = (state_29569[(2)]);
var inst_29549__$1 = (inst_29548__$1 == null);
var state_29569__$1 = (function (){var statearr_29575 = state_29569;
(statearr_29575[(7)] = inst_29549__$1);

(statearr_29575[(10)] = inst_29548__$1);

return statearr_29575;
})();
if(cljs.core.truth_(inst_29549__$1)){
var statearr_29576_29599 = state_29569__$1;
(statearr_29576_29599[(1)] = (7));

} else {
var statearr_29577_29600 = state_29569__$1;
(statearr_29577_29600[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29570 === (3))){
var inst_29567 = (state_29569[(2)]);
var state_29569__$1 = state_29569;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29569__$1,inst_29567);
} else {
if((state_val_29570 === (12))){
var inst_29564 = (state_29569[(2)]);
var _ = (function (){var statearr_29578 = state_29569;
(statearr_29578[(4)] = cljs.core.rest((state_29569[(4)])));

return statearr_29578;
})();
var state_29569__$1 = state_29569;
var statearr_29579_29601 = state_29569__$1;
(statearr_29579_29601[(2)] = inst_29564);

(statearr_29579_29601[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29570 === (2))){
var _ = (function (){var statearr_29580 = state_29569;
(statearr_29580[(4)] = cljs.core.cons((5),(state_29569[(4)])));

return statearr_29580;
})();
var inst_29546 = fluree.db.storage.core.storage_read(conn,key);
var state_29569__$1 = state_29569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29569__$1,(6),inst_29546);
} else {
if((state_val_29570 === (11))){
var inst_29548 = (state_29569[(10)]);
var inst_29558 = fluree.db.storage.core.serde(conn);
var inst_29559 = fluree.db.serde.protocol._deserialize_leaf(inst_29558,inst_29548);
var inst_29560 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_29559);
var inst_29561 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_29560);
var inst_29562 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_29561);
var state_29569__$1 = state_29569;
var statearr_29582_29602 = state_29569__$1;
(statearr_29582_29602[(2)] = inst_29562);

(statearr_29582_29602[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29570 === (9))){
var inst_29554 = (state_29569[(2)]);
var state_29569__$1 = state_29569;
if(cljs.core.truth_(inst_29554)){
var statearr_29583_29603 = state_29569__$1;
(statearr_29583_29603[(1)] = (10));

} else {
var statearr_29584_29604 = state_29569__$1;
(statearr_29584_29604[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29570 === (5))){
var _ = (function (){var statearr_29585 = state_29569;
(statearr_29585[(4)] = cljs.core.rest((state_29569[(4)])));

return statearr_29585;
})();
var state_29569__$1 = state_29569;
var ex29581 = (state_29569__$1[(2)]);
var statearr_29586_29605 = state_29569__$1;
(statearr_29586_29605[(5)] = ex29581);


var statearr_29587_29606 = state_29569__$1;
(statearr_29587_29606[(1)] = (4));

(statearr_29587_29606[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_29570 === (10))){
var inst_29556 = cljs.core.async.close_BANG_(return_ch);
var state_29569__$1 = state_29569;
var statearr_29588_29607 = state_29569__$1;
(statearr_29588_29607[(2)] = inst_29556);

(statearr_29588_29607[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29570 === (8))){
var inst_29548 = (state_29569[(10)]);
var inst_29552 = (inst_29548 instanceof Error);
var state_29569__$1 = state_29569;
var statearr_29589_29608 = state_29569__$1;
(statearr_29589_29608[(2)] = inst_29552);

(statearr_29589_29608[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__10750__auto____0 = (function (){
var statearr_29590 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29590[(0)] = fluree$db$storage$core$reify_history_$_state_machine__10750__auto__);

(statearr_29590[(1)] = (1));

return statearr_29590;
});
var fluree$db$storage$core$reify_history_$_state_machine__10750__auto____1 = (function (state_29569){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29569);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29591){var ex__10753__auto__ = e29591;
var statearr_29592_29609 = state_29569;
(statearr_29592_29609[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29569[(4)]))){
var statearr_29593_29610 = state_29569;
(statearr_29593_29610[(1)] = cljs.core.first((state_29569[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29611 = state_29569;
state_29569 = G__29611;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__10750__auto__ = function(state_29569){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__10750__auto____1.call(this,state_29569);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__10750__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__10750__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29594 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29594[(6)] = c__10876__auto___29595);

return statearr_29594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__29613 = arguments.length;
switch (G__29613) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4210__auto__ = (rhs == null);
if(and__4210__auto__){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10876__auto___29725 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29676){
var state_val_29677 = (state_29676[(1)]);
if((state_val_29677 === (7))){
var state_29676__$1 = state_29676;
var statearr_29678_29726 = state_29676__$1;
(statearr_29678_29726[(2)] = cljs.core.cst$kw$novelty);

(statearr_29678_29726[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (20))){
var inst_29655 = cljs.core.PersistentVector.EMPTY;
var state_29676__$1 = state_29676;
var statearr_29679_29727 = state_29676__$1;
(statearr_29679_29727[(2)] = inst_29655);

(statearr_29679_29727[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (1))){
var state_29676__$1 = state_29676;
var statearr_29680_29728 = state_29676__$1;
(statearr_29680_29728[(2)] = null);

(statearr_29680_29728[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (24))){
var state_29676__$1 = state_29676;
var statearr_29681_29729 = state_29676__$1;
(statearr_29681_29729[(2)] = null);

(statearr_29681_29729[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (4))){
var inst_29616 = (state_29676[(2)]);
var inst_29617 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_29618 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_29616);
var inst_29619 = cljs.core.async.close_BANG_(result_ch);
var state_29676__$1 = (function (){var statearr_29682 = state_29676;
(statearr_29682[(7)] = inst_29617);

(statearr_29682[(8)] = inst_29618);

return statearr_29682;
})();
var statearr_29683_29730 = state_29676__$1;
(statearr_29683_29730[(2)] = inst_29619);

(statearr_29683_29730[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (15))){
var inst_29641 = (state_29676[(2)]);
var state_29676__$1 = state_29676;
var statearr_29684_29731 = state_29676__$1;
(statearr_29684_29731[(2)] = inst_29641);

(statearr_29684_29731[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (21))){
var inst_29630 = (state_29676[(9)]);
var inst_29658 = (state_29676[(10)]);
var inst_29629 = (state_29676[(11)]);
var inst_29628 = (state_29676[(12)]);
var inst_29645 = (state_29676[(13)]);
var inst_29665 = (state_29676[(2)]);
var inst_29666 = (function (){var base_node = inst_29628;
var first_flake = inst_29629;
var node_t = inst_29630;
var source = inst_29645;
var coll = inst_29658;
var conj_QMARK_ = inst_29665;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__29686 = f.p;
var fexpr__29685 = (function (){var or__4212__auto__ = remove_preds;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__29685.cljs$core$IFn$_invoke$arity$1 ? fexpr__29685.cljs$core$IFn$_invoke$arity$1(G__29686) : fexpr__29685.call(null,G__29686));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_29667 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_29628);
var inst_29668 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_29666,inst_29667,inst_29658);
var inst_29669 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_29668);
var inst_29670 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29628,cljs.core.cst$kw$flakes,inst_29669);
var inst_29671 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_29670);
var _ = (function (){var statearr_29687 = state_29676;
(statearr_29687[(4)] = cljs.core.rest((state_29676[(4)])));

return statearr_29687;
})();
var state_29676__$1 = state_29676;
var statearr_29688_29732 = state_29676__$1;
(statearr_29688_29732[(2)] = inst_29671);

(statearr_29688_29732[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (13))){
var state_29676__$1 = state_29676;
var statearr_29689_29733 = state_29676__$1;
(statearr_29689_29733[(2)] = cljs.core.cst$kw$none);

(statearr_29689_29733[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (22))){
var inst_29630 = (state_29676[(9)]);
var inst_29658 = (state_29676[(10)]);
var inst_29629 = (state_29676[(11)]);
var inst_29628 = (state_29676[(12)]);
var inst_29645 = (state_29676[(13)]);
var inst_29659 = (function (){var base_node = inst_29628;
var first_flake = inst_29629;
var node_t = inst_29630;
var source = inst_29645;
var coll = inst_29658;
return (function (f){
return f.op === true;
});
})();
var state_29676__$1 = state_29676;
var statearr_29690_29734 = state_29676__$1;
(statearr_29690_29734[(2)] = inst_29659);

(statearr_29690_29734[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (6))){
var inst_29630 = (state_29676[(9)]);
var inst_29628 = (state_29676[(12)]);
var inst_29627 = (state_29676[(2)]);
var inst_29628__$1 = fluree.db.util.async.throw_err(inst_29627);
var inst_29629 = fluree.db.dbproto._first_flake(inst_29628__$1);
var inst_29630__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_29628__$1);
var inst_29631 = (inst_29630__$1 > t);
var state_29676__$1 = (function (){var statearr_29691 = state_29676;
(statearr_29691[(9)] = inst_29630__$1);

(statearr_29691[(11)] = inst_29629);

(statearr_29691[(12)] = inst_29628__$1);

return statearr_29691;
})();
if(cljs.core.truth_(inst_29631)){
var statearr_29692_29735 = state_29676__$1;
(statearr_29692_29735[(1)] = (7));

} else {
var statearr_29693_29736 = state_29676__$1;
(statearr_29693_29736[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (17))){
var inst_29629 = (state_29676[(11)]);
var inst_29646 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_29629,rhs,leftmost_QMARK_,t);
var state_29676__$1 = state_29676;
var statearr_29694_29737 = state_29676__$1;
(statearr_29694_29737[(2)] = inst_29646);

(statearr_29694_29737[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (3))){
var inst_29674 = (state_29676[(2)]);
var state_29676__$1 = state_29676;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29676__$1,inst_29674);
} else {
if((state_val_29677 === (12))){
var inst_29643 = (state_29676[(2)]);
var state_29676__$1 = state_29676;
var statearr_29695_29738 = state_29676__$1;
(statearr_29695_29738[(2)] = inst_29643);

(statearr_29695_29738[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (2))){
var _ = (function (){var statearr_29696 = state_29676;
(statearr_29696[(4)] = cljs.core.cons((5),(state_29676[(4)])));

return statearr_29696;
})();
var inst_29625 = fluree.db.dbproto._resolve(node);
var state_29676__$1 = state_29676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29676__$1,(6),inst_29625);
} else {
if((state_val_29677 === (23))){
var inst_29630 = (state_29676[(9)]);
var inst_29658 = (state_29676[(10)]);
var inst_29629 = (state_29676[(11)]);
var inst_29628 = (state_29676[(12)]);
var inst_29645 = (state_29676[(13)]);
var inst_29661 = (function (){var base_node = inst_29628;
var first_flake = inst_29629;
var node_t = inst_29630;
var source = inst_29645;
var coll = inst_29658;
return (function (f){
return f.op === false;
});
})();
var state_29676__$1 = state_29676;
var statearr_29697_29739 = state_29676__$1;
(statearr_29697_29739[(2)] = inst_29661);

(statearr_29697_29739[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (19))){
var inst_29648 = (state_29676[(14)]);
var inst_29651 = (state_29676[(2)]);
var inst_29652 = fluree.db.util.async.throw_err(inst_29651);
var inst_29653 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_29648,inst_29652);
var state_29676__$1 = state_29676;
var statearr_29698_29740 = state_29676__$1;
(statearr_29698_29740[(2)] = inst_29653);

(statearr_29698_29740[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (11))){
var inst_29630 = (state_29676[(9)]);
var inst_29637 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29630,t);
var state_29676__$1 = state_29676;
if(inst_29637){
var statearr_29700_29741 = state_29676__$1;
(statearr_29700_29741[(1)] = (13));

} else {
var statearr_29701_29742 = state_29676__$1;
(statearr_29701_29742[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (9))){
var inst_29645 = (state_29676[(13)]);
var inst_29645__$1 = (state_29676[(2)]);
var state_29676__$1 = (function (){var statearr_29702 = state_29676;
(statearr_29702[(13)] = inst_29645__$1);

return statearr_29702;
})();
var G__29703_29743 = inst_29645__$1;
var G__29703_29744__$1 = (((G__29703_29743 instanceof cljs.core.Keyword))?G__29703_29743.fqn:null);
switch (G__29703_29744__$1) {
case "novelty":
var statearr_29704_29746 = state_29676__$1;
(statearr_29704_29746[(1)] = (17));


break;
case "history":
var statearr_29705_29747 = state_29676__$1;
(statearr_29705_29747[(1)] = (18));


break;
case "none":
var statearr_29706_29748 = state_29676__$1;
(statearr_29706_29748[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29703_29744__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (5))){
var _ = (function (){var statearr_29707 = state_29676;
(statearr_29707[(4)] = cljs.core.rest((state_29676[(4)])));

return statearr_29707;
})();
var state_29676__$1 = state_29676;
var ex29699 = (state_29676__$1[(2)]);
var statearr_29708_29749 = state_29676__$1;
(statearr_29708_29749[(5)] = ex29699);


var statearr_29709_29750 = state_29676__$1;
(statearr_29709_29750[(1)] = (4));

(statearr_29709_29750[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (14))){
var state_29676__$1 = state_29676;
var statearr_29710_29751 = state_29676__$1;
(statearr_29710_29751[(2)] = null);

(statearr_29710_29751[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (16))){
var inst_29645 = (state_29676[(13)]);
var inst_29658 = (state_29676[(2)]);
var state_29676__$1 = (function (){var statearr_29711 = state_29676;
(statearr_29711[(10)] = inst_29658);

return statearr_29711;
})();
var G__29712_29752 = inst_29645;
var G__29712_29753__$1 = (((G__29712_29752 instanceof cljs.core.Keyword))?G__29712_29752.fqn:null);
switch (G__29712_29753__$1) {
case "novelty":
var statearr_29713_29755 = state_29676__$1;
(statearr_29713_29755[(1)] = (22));


break;
case "history":
var statearr_29714_29756 = state_29676__$1;
(statearr_29714_29756[(1)] = (23));


break;
case "none":
var statearr_29715_29757 = state_29676__$1;
(statearr_29715_29757[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29712_29753__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (10))){
var state_29676__$1 = state_29676;
var statearr_29716_29758 = state_29676__$1;
(statearr_29716_29758[(2)] = cljs.core.cst$kw$history);

(statearr_29716_29758[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29677 === (18))){
var inst_29630 = (state_29676[(9)]);
var inst_29629 = (state_29676[(11)]);
var inst_29628 = (state_29676[(12)]);
var inst_29645 = (state_29676[(13)]);
var inst_29648 = (function (){var base_node = inst_29628;
var first_flake = inst_29629;
var node_t = inst_29630;
var source = inst_29645;
return (function (p1__29615_SHARP_){
return (p1__29615_SHARP_.t <= t);
});
})();
var inst_29649 = fluree.db.dbproto._resolve_history(node);
var state_29676__$1 = (function (){var statearr_29717 = state_29676;
(statearr_29717[(14)] = inst_29648);

return statearr_29717;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29676__$1,(19),inst_29649);
} else {
if((state_val_29677 === (8))){
var inst_29630 = (state_29676[(9)]);
var inst_29634 = (inst_29630 < t);
var state_29676__$1 = state_29676;
if(cljs.core.truth_(inst_29634)){
var statearr_29718_29759 = state_29676__$1;
(statearr_29718_29759[(1)] = (10));

} else {
var statearr_29719_29760 = state_29676__$1;
(statearr_29719_29760[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__10750__auto____0 = (function (){
var statearr_29720 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29720[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__10750__auto__);

(statearr_29720[(1)] = (1));

return statearr_29720;
});
var fluree$db$storage$core$resolve_t_$_state_machine__10750__auto____1 = (function (state_29676){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29676);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29721){var ex__10753__auto__ = e29721;
var statearr_29722_29761 = state_29676;
(statearr_29722_29761[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29676[(4)]))){
var statearr_29723_29762 = state_29676;
(statearr_29723_29762[(1)] = cljs.core.first((state_29676[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29763 = state_29676;
state_29676 = G__29763;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__10750__auto__ = function(state_29676){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__10750__auto____1.call(this,state_29676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__10750__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__10750__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29724 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29724[(6)] = c__10876__auto___29725);

return statearr_29724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29823){
var state_val_29824 = (state_29823[(1)]);
if((state_val_29824 === (7))){
var inst_29774 = (state_29823[(7)]);
var inst_29778 = (inst_29774 <= from_t);
var state_29823__$1 = state_29823;
var statearr_29825_29865 = state_29823__$1;
(statearr_29825_29865[(2)] = inst_29778);

(statearr_29825_29865[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (20))){
var inst_29808 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_29809 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29808)].join('');
var inst_29810 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_29811 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_29812 = cljs.core.PersistentHashMap.fromArrays(inst_29810,inst_29811);
var inst_29813 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29809,inst_29812);
var inst_29814 = (function(){throw inst_29813})();
var state_29823__$1 = state_29823;
var statearr_29826_29866 = state_29823__$1;
(statearr_29826_29866[(2)] = inst_29814);

(statearr_29826_29866[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (1))){
var state_29823__$1 = state_29823;
var statearr_29827_29867 = state_29823__$1;
(statearr_29827_29867[(2)] = null);

(statearr_29827_29867[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (4))){
var inst_29766 = (state_29823[(2)]);
var inst_29767 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29766], 0));
var inst_29768 = (function(){throw inst_29766})();
var state_29823__$1 = (function (){var statearr_29828 = state_29823;
(statearr_29828[(8)] = inst_29767);

return statearr_29828;
})();
var statearr_29829_29868 = state_29823__$1;
(statearr_29829_29868[(2)] = inst_29768);

(statearr_29829_29868[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (15))){
var inst_29793 = (state_29823[(2)]);
var state_29823__$1 = (function (){var statearr_29830 = state_29823;
(statearr_29830[(9)] = inst_29793);

return statearr_29830;
})();
if(cljs.core.truth_(from_t)){
var statearr_29831_29869 = state_29823__$1;
(statearr_29831_29869[(1)] = (16));

} else {
var statearr_29832_29870 = state_29823__$1;
(statearr_29832_29870[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (21))){
var inst_29804 = (state_29823[(10)]);
var inst_29803 = (state_29823[(11)]);
var inst_29802 = (state_29823[(12)]);
var inst_29816 = (state_29823[(2)]);
var inst_29817 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_29803,inst_29804,leftmost_QMARK_,to_t);
var inst_29818 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29817,inst_29802);
var _ = (function (){var statearr_29833 = state_29823;
(statearr_29833[(4)] = cljs.core.rest((state_29823[(4)])));

return statearr_29833;
})();
var state_29823__$1 = (function (){var statearr_29834 = state_29823;
(statearr_29834[(13)] = inst_29816);

return statearr_29834;
})();
var statearr_29835_29871 = state_29823__$1;
(statearr_29835_29871[(2)] = inst_29818);

(statearr_29835_29871[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (13))){
var inst_29774 = (state_29823[(7)]);
var inst_29786 = (state_29823[(14)]);
var inst_29789 = (function (){var node_t = inst_29774;
var G__29782 = inst_29786;
return (function (p1__29764_SHARP_){
return (p1__29764_SHARP_.t < to_t);
});
})();
var inst_29790 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_29789,inst_29786);
var state_29823__$1 = state_29823;
var statearr_29836_29872 = state_29823__$1;
(statearr_29836_29872[(2)] = inst_29790);

(statearr_29836_29872[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (6))){
var inst_29775 = (state_29823[(15)]);
var state_29823__$1 = state_29823;
var statearr_29837_29873 = state_29823__$1;
(statearr_29837_29873[(2)] = inst_29775);

(statearr_29837_29873[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (17))){
var inst_29793 = (state_29823[(9)]);
var state_29823__$1 = state_29823;
var statearr_29838_29874 = state_29823__$1;
(statearr_29838_29874[(2)] = inst_29793);

(statearr_29838_29874[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (3))){
var inst_29821 = (state_29823[(2)]);
var state_29823__$1 = state_29823;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29823__$1,inst_29821);
} else {
if((state_val_29824 === (12))){
var inst_29774 = (state_29823[(7)]);
var inst_29785 = (state_29823[(2)]);
var inst_29786 = fluree.db.util.async.throw_err(inst_29785);
var inst_29787 = (to_t > inst_29774);
var state_29823__$1 = (function (){var statearr_29839 = state_29823;
(statearr_29839[(14)] = inst_29786);

return statearr_29839;
})();
if(cljs.core.truth_(inst_29787)){
var statearr_29840_29875 = state_29823__$1;
(statearr_29840_29875[(1)] = (13));

} else {
var statearr_29841_29876 = state_29823__$1;
(statearr_29841_29876[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (2))){
var inst_29775 = (state_29823[(15)]);
var _ = (function (){var statearr_29842 = state_29823;
(statearr_29842[(4)] = cljs.core.cons((5),(state_29823[(4)])));

return statearr_29842;
})();
var inst_29774 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_29775__$1 = (from_t == null);
var state_29823__$1 = (function (){var statearr_29843 = state_29823;
(statearr_29843[(15)] = inst_29775__$1);

(statearr_29843[(7)] = inst_29774);

return statearr_29843;
})();
if(cljs.core.truth_(inst_29775__$1)){
var statearr_29844_29877 = state_29823__$1;
(statearr_29844_29877[(1)] = (6));

} else {
var statearr_29845_29878 = state_29823__$1;
(statearr_29845_29878[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (19))){
var state_29823__$1 = state_29823;
var statearr_29846_29879 = state_29823__$1;
(statearr_29846_29879[(2)] = null);

(statearr_29846_29879[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (11))){
var inst_29802 = (state_29823[(2)]);
var inst_29803 = fluree.db.dbproto._first_flake(node);
var inst_29804 = fluree.db.dbproto._rhs(node);
var inst_29805 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_29823__$1 = (function (){var statearr_29848 = state_29823;
(statearr_29848[(10)] = inst_29804);

(statearr_29848[(11)] = inst_29803);

(statearr_29848[(12)] = inst_29802);

return statearr_29848;
})();
if(cljs.core.truth_(inst_29805)){
var statearr_29849_29880 = state_29823__$1;
(statearr_29849_29880[(1)] = (19));

} else {
var statearr_29850_29881 = state_29823__$1;
(statearr_29850_29881[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (9))){
var inst_29783 = fluree.db.dbproto._resolve_history(node);
var state_29823__$1 = state_29823;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29823__$1,(12),inst_29783);
} else {
if((state_val_29824 === (5))){
var _ = (function (){var statearr_29851 = state_29823;
(statearr_29851[(4)] = cljs.core.rest((state_29823[(4)])));

return statearr_29851;
})();
var state_29823__$1 = state_29823;
var ex29847 = (state_29823__$1[(2)]);
var statearr_29852_29882 = state_29823__$1;
(statearr_29852_29882[(5)] = ex29847);


var statearr_29853_29883 = state_29823__$1;
(statearr_29853_29883[(1)] = (4));

(statearr_29853_29883[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (14))){
var inst_29786 = (state_29823[(14)]);
var state_29823__$1 = state_29823;
var statearr_29854_29884 = state_29823__$1;
(statearr_29854_29884[(2)] = inst_29786);

(statearr_29854_29884[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (16))){
var inst_29774 = (state_29823[(7)]);
var inst_29793 = (state_29823[(9)]);
var inst_29795 = (function (){var node_t = inst_29774;
var G__29782 = inst_29793;
return (function (p1__29765_SHARP_){
return (p1__29765_SHARP_.t <= from_t);
});
})();
var inst_29796 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_29795,inst_29793);
var state_29823__$1 = state_29823;
var statearr_29855_29885 = state_29823__$1;
(statearr_29855_29885[(2)] = inst_29796);

(statearr_29855_29885[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (10))){
var state_29823__$1 = state_29823;
var statearr_29856_29886 = state_29823__$1;
(statearr_29856_29886[(2)] = null);

(statearr_29856_29886[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (18))){
var inst_29799 = (state_29823[(2)]);
var state_29823__$1 = state_29823;
var statearr_29857_29887 = state_29823__$1;
(statearr_29857_29887[(2)] = inst_29799);

(statearr_29857_29887[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29824 === (8))){
var inst_29780 = (state_29823[(2)]);
var state_29823__$1 = state_29823;
if(cljs.core.truth_(inst_29780)){
var statearr_29858_29888 = state_29823__$1;
(statearr_29858_29888[(1)] = (9));

} else {
var statearr_29859_29889 = state_29823__$1;
(statearr_29859_29889[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__10750__auto____0 = (function (){
var statearr_29860 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29860[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__10750__auto__);

(statearr_29860[(1)] = (1));

return statearr_29860;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__10750__auto____1 = (function (state_29823){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29823);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29861){var ex__10753__auto__ = e29861;
var statearr_29862_29890 = state_29823;
(statearr_29862_29890[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29823[(4)]))){
var statearr_29863_29891 = state_29823;
(statearr_29863_29891[(1)] = cljs.core.first((state_29823[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29892 = state_29823;
state_29823 = G__29892;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__10750__auto__ = function(state_29823){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__10750__auto____1.call(this,state_29823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__10750__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__10750__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29864 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29864[(6)] = c__10876__auto__);

return statearr_29864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4212__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__29893_29903 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__29894_29904 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29893_29903,G__29894_29904) : object_cache.call(null,G__29893_29903,G__29894_29904));

var G__29895 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__29896 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__29897 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__29898 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29897,G__29898) : object_cache.call(null,G__29897,G__29898));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29895,G__29896) : object_cache.call(null,G__29895,G__29896));
} else {
var G__29899 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__29900 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__29901 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__29902 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29901,G__29902) : object_cache.call(null,G__29901,G__29902));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__29899,G__29900) : object_cache.call(null,G__29899,G__29900));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29925){
var state_val_29926 = (state_29925[(1)]);
if((state_val_29926 === (7))){
var state_29925__$1 = state_29925;
var statearr_29927_29947 = state_29925__$1;
(statearr_29927_29947[(2)] = null);

(statearr_29927_29947[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29926 === (1))){
var state_29925__$1 = state_29925;
var statearr_29928_29948 = state_29925__$1;
(statearr_29928_29948[(2)] = null);

(statearr_29928_29948[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29926 === (4))){
var inst_29905 = (state_29925[(2)]);
var state_29925__$1 = state_29925;
var statearr_29929_29949 = state_29925__$1;
(statearr_29929_29949[(2)] = inst_29905);

(statearr_29929_29949[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29926 === (6))){
var inst_29911 = (state_29925[(7)]);
var inst_29913 = fluree.db.storage.core.serde(conn);
var state_29925__$1 = (function (){var statearr_29930 = state_29925;
(statearr_29930[(8)] = inst_29913);

return statearr_29930;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29925__$1,(9),inst_29911);
} else {
if((state_val_29926 === (3))){
var inst_29923 = (state_29925[(2)]);
var state_29925__$1 = state_29925;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29925__$1,inst_29923);
} else {
if((state_val_29926 === (2))){
var inst_29911 = (state_29925[(7)]);
var _ = (function (){var statearr_29932 = state_29925;
(statearr_29932[(4)] = cljs.core.cons((5),(state_29925[(4)])));

return statearr_29932;
})();
var inst_29911__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_29925__$1 = (function (){var statearr_29933 = state_29925;
(statearr_29933[(7)] = inst_29911__$1);

return statearr_29933;
})();
if(cljs.core.truth_(inst_29911__$1)){
var statearr_29934_29950 = state_29925__$1;
(statearr_29934_29950[(1)] = (6));

} else {
var statearr_29935_29951 = state_29925__$1;
(statearr_29935_29951[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29926 === (9))){
var inst_29913 = (state_29925[(8)]);
var inst_29915 = (state_29925[(2)]);
var inst_29916 = fluree.db.util.async.throw_err(inst_29915);
var inst_29917 = fluree.db.serde.protocol._deserialize_branch(inst_29913,inst_29916);
var state_29925__$1 = state_29925;
var statearr_29936_29952 = state_29925__$1;
(statearr_29936_29952[(2)] = inst_29917);

(statearr_29936_29952[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29926 === (5))){
var _ = (function (){var statearr_29937 = state_29925;
(statearr_29937[(4)] = cljs.core.rest((state_29925[(4)])));

return statearr_29937;
})();
var state_29925__$1 = state_29925;
var ex29931 = (state_29925__$1[(2)]);
var statearr_29938_29953 = state_29925__$1;
(statearr_29938_29953[(5)] = ex29931);


if((ex29931 instanceof Error)){
var statearr_29939_29954 = state_29925__$1;
(statearr_29939_29954[(1)] = (4));

(statearr_29939_29954[(5)] = null);

} else {
throw ex29931;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29926 === (8))){
var inst_29920 = (state_29925[(2)]);
var _ = (function (){var statearr_29940 = state_29925;
(statearr_29940[(4)] = cljs.core.rest((state_29925[(4)])));

return statearr_29940;
})();
var state_29925__$1 = state_29925;
var statearr_29941_29955 = state_29925__$1;
(statearr_29941_29955[(2)] = inst_29920);

(statearr_29941_29955[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__10750__auto____0 = (function (){
var statearr_29942 = [null,null,null,null,null,null,null,null,null];
(statearr_29942[(0)] = fluree$db$storage$core$read_branch_$_state_machine__10750__auto__);

(statearr_29942[(1)] = (1));

return statearr_29942;
});
var fluree$db$storage$core$read_branch_$_state_machine__10750__auto____1 = (function (state_29925){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29925);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29943){var ex__10753__auto__ = e29943;
var statearr_29944_29956 = state_29925;
(statearr_29944_29956[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29925[(4)]))){
var statearr_29945_29957 = state_29925;
(statearr_29945_29957[(1)] = cljs.core.first((state_29925[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29958 = state_29925;
state_29925 = G__29958;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__10750__auto__ = function(state_29925){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__10750__auto____1.call(this,state_29925);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__10750__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__10750__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29946 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29946[(6)] = c__10876__auto__);

return statearr_29946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10876__auto___30037 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_30009){
var state_val_30010 = (state_30009[(1)]);
if((state_val_30010 === (7))){
var inst_29976 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_29977 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_29978 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_29979 = cljs.core.PersistentHashMap.fromArrays(inst_29977,inst_29978);
var inst_29980 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29976,inst_29979);
var inst_29981 = (function(){throw inst_29980})();
var state_30009__$1 = state_30009;
var statearr_30011_30038 = state_30009__$1;
(statearr_30011_30038[(2)] = inst_29981);

(statearr_30011_30038[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30010 === (1))){
var state_30009__$1 = state_30009;
var statearr_30012_30039 = state_30009__$1;
(statearr_30012_30039[(2)] = null);

(statearr_30012_30039[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30010 === (4))){
var inst_29959 = (state_30009[(2)]);
var inst_29960 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_29961 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_29959);
var inst_29962 = cljs.core.async.close_BANG_(return_ch);
var state_30009__$1 = (function (){var statearr_30013 = state_30009;
(statearr_30013[(7)] = inst_29960);

(statearr_30013[(8)] = inst_29961);

return statearr_30013;
})();
var statearr_30014_30040 = state_30009__$1;
(statearr_30014_30040[(2)] = inst_29962);

(statearr_30014_30040[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30010 === (6))){
var inst_29973 = (state_30009[(9)]);
var inst_29972 = (state_30009[(2)]);
var inst_29973__$1 = fluree.db.util.async.throw_err(inst_29972);
var inst_29974 = (inst_29973__$1 == null);
var state_30009__$1 = (function (){var statearr_30015 = state_30009;
(statearr_30015[(9)] = inst_29973__$1);

return statearr_30015;
})();
if(cljs.core.truth_(inst_29974)){
var statearr_30016_30041 = state_30009__$1;
(statearr_30016_30041[(1)] = (7));

} else {
var statearr_30017_30042 = state_30009__$1;
(statearr_30017_30042[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30010 === (3))){
var inst_30007 = (state_30009[(2)]);
var state_30009__$1 = state_30009;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30009__$1,inst_30007);
} else {
if((state_val_30010 === (12))){
var inst_29973 = (state_30009[(9)]);
var inst_29990 = (state_30009[(2)]);
var inst_29991 = cljs.core.__destructure_map(inst_29973);
var inst_29992 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29991,cljs.core.cst$kw$children);
var inst_29993 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29991,cljs.core.cst$kw$rhs);
var inst_29994 = config;
var inst_29995 = cljs.core.__destructure_map(inst_29994);
var inst_29996 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29995,cljs.core.cst$kw$comparator);
var inst_29998 = (function (){var data = inst_29973;
var _ = inst_29990;
var map__29968 = inst_29991;
var children = inst_29992;
var rhs = inst_29993;
var map__29969 = inst_29995;
var comparator = inst_29996;
return (function (idx,p__29997){
var map__30018 = p__29997;
var map__30018__$1 = cljs.core.__destructure_map(map__30018);
var child = map__30018__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30018__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30018__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30018__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30018__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30018__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4210__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return (idx === (0));
} else {
return and__4210__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_29999 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_29998,inst_29992);
var inst_30000 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_29999);
var inst_30001 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_30000,inst_29999);
var inst_30002 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_29996,inst_30001);
var inst_30003 = fluree.db.index.__GT_IndexNode(block,t,inst_29993,inst_30002,config,leftmost_QMARK_);
var inst_30004 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_30003);
var _ = (function (){var statearr_30019 = state_30009;
(statearr_30019[(4)] = cljs.core.rest((state_30009[(4)])));

return statearr_30019;
})();
var state_30009__$1 = state_30009;
var statearr_30020_30043 = state_30009__$1;
(statearr_30020_30043[(2)] = inst_30004);

(statearr_30020_30043[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30010 === (2))){
var _ = (function (){var statearr_30021 = state_30009;
(statearr_30021[(4)] = cljs.core.cons((5),(state_30009[(4)])));

return statearr_30021;
})();
var inst_29970 = fluree.db.storage.core.read_branch(conn,key);
var state_30009__$1 = state_30009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30009__$1,(6),inst_29970);
} else {
if((state_val_30010 === (11))){
var state_30009__$1 = state_30009;
var statearr_30023_30044 = state_30009__$1;
(statearr_30023_30044[(2)] = null);

(statearr_30023_30044[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30010 === (9))){
var inst_29973 = (state_30009[(9)]);
var inst_29984 = (state_30009[(2)]);
var inst_29985 = fluree.db.util.core.exception_QMARK_(inst_29973);
var state_30009__$1 = (function (){var statearr_30024 = state_30009;
(statearr_30024[(10)] = inst_29984);

return statearr_30024;
})();
if(inst_29985){
var statearr_30025_30045 = state_30009__$1;
(statearr_30025_30045[(1)] = (10));

} else {
var statearr_30026_30046 = state_30009__$1;
(statearr_30026_30046[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30010 === (5))){
var _ = (function (){var statearr_30027 = state_30009;
(statearr_30027[(4)] = cljs.core.rest((state_30009[(4)])));

return statearr_30027;
})();
var state_30009__$1 = state_30009;
var ex30022 = (state_30009__$1[(2)]);
var statearr_30028_30047 = state_30009__$1;
(statearr_30028_30047[(5)] = ex30022);


var statearr_30029_30048 = state_30009__$1;
(statearr_30029_30048[(1)] = (4));

(statearr_30029_30048[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_30010 === (10))){
var inst_29973 = (state_30009[(9)]);
var inst_29987 = (function(){throw inst_29973})();
var state_30009__$1 = state_30009;
var statearr_30030_30049 = state_30009__$1;
(statearr_30030_30049[(2)] = inst_29987);

(statearr_30030_30049[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30010 === (8))){
var state_30009__$1 = state_30009;
var statearr_30031_30050 = state_30009__$1;
(statearr_30031_30050[(2)] = null);

(statearr_30031_30050[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__10750__auto____0 = (function (){
var statearr_30032 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30032[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__10750__auto__);

(statearr_30032[(1)] = (1));

return statearr_30032;
});
var fluree$db$storage$core$reify_branch_$_state_machine__10750__auto____1 = (function (state_30009){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_30009);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e30033){var ex__10753__auto__ = e30033;
var statearr_30034_30051 = state_30009;
(statearr_30034_30051[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_30009[(4)]))){
var statearr_30035_30052 = state_30009;
(statearr_30035_30052[(1)] = cljs.core.first((state_30009[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__30053 = state_30009;
state_30009 = G__30053;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__10750__auto__ = function(state_30009){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__10750__auto____1.call(this,state_30009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__10750__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__10750__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_30036 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_30036[(6)] = c__10876__auto___30037);

return statearr_30036;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_30074){
var state_val_30075 = (state_30074[(1)]);
if((state_val_30075 === (7))){
var state_30074__$1 = state_30074;
var statearr_30076_30096 = state_30074__$1;
(statearr_30076_30096[(2)] = null);

(statearr_30076_30096[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30075 === (1))){
var state_30074__$1 = state_30074;
var statearr_30077_30097 = state_30074__$1;
(statearr_30077_30097[(2)] = null);

(statearr_30077_30097[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30075 === (4))){
var inst_30054 = (state_30074[(2)]);
var state_30074__$1 = state_30074;
var statearr_30078_30098 = state_30074__$1;
(statearr_30078_30098[(2)] = inst_30054);

(statearr_30078_30098[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30075 === (6))){
var inst_30060 = (state_30074[(7)]);
var inst_30062 = fluree.db.storage.core.serde(conn);
var state_30074__$1 = (function (){var statearr_30079 = state_30074;
(statearr_30079[(8)] = inst_30062);

return statearr_30079;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30074__$1,(9),inst_30060);
} else {
if((state_val_30075 === (3))){
var inst_30072 = (state_30074[(2)]);
var state_30074__$1 = state_30074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30074__$1,inst_30072);
} else {
if((state_val_30075 === (2))){
var inst_30060 = (state_30074[(7)]);
var _ = (function (){var statearr_30081 = state_30074;
(statearr_30081[(4)] = cljs.core.cons((5),(state_30074[(4)])));

return statearr_30081;
})();
var inst_30060__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_30074__$1 = (function (){var statearr_30082 = state_30074;
(statearr_30082[(7)] = inst_30060__$1);

return statearr_30082;
})();
if(cljs.core.truth_(inst_30060__$1)){
var statearr_30083_30099 = state_30074__$1;
(statearr_30083_30099[(1)] = (6));

} else {
var statearr_30084_30100 = state_30074__$1;
(statearr_30084_30100[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30075 === (9))){
var inst_30062 = (state_30074[(8)]);
var inst_30064 = (state_30074[(2)]);
var inst_30065 = fluree.db.util.async.throw_err(inst_30064);
var inst_30066 = fluree.db.serde.protocol._deserialize_leaf(inst_30062,inst_30065);
var state_30074__$1 = state_30074;
var statearr_30085_30101 = state_30074__$1;
(statearr_30085_30101[(2)] = inst_30066);

(statearr_30085_30101[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30075 === (5))){
var _ = (function (){var statearr_30086 = state_30074;
(statearr_30086[(4)] = cljs.core.rest((state_30074[(4)])));

return statearr_30086;
})();
var state_30074__$1 = state_30074;
var ex30080 = (state_30074__$1[(2)]);
var statearr_30087_30102 = state_30074__$1;
(statearr_30087_30102[(5)] = ex30080);


if((ex30080 instanceof Error)){
var statearr_30088_30103 = state_30074__$1;
(statearr_30088_30103[(1)] = (4));

(statearr_30088_30103[(5)] = null);

} else {
throw ex30080;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30075 === (8))){
var inst_30069 = (state_30074[(2)]);
var _ = (function (){var statearr_30089 = state_30074;
(statearr_30089[(4)] = cljs.core.rest((state_30074[(4)])));

return statearr_30089;
})();
var state_30074__$1 = state_30074;
var statearr_30090_30104 = state_30074__$1;
(statearr_30090_30104[(2)] = inst_30069);

(statearr_30090_30104[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__10750__auto____0 = (function (){
var statearr_30091 = [null,null,null,null,null,null,null,null,null];
(statearr_30091[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__10750__auto__);

(statearr_30091[(1)] = (1));

return statearr_30091;
});
var fluree$db$storage$core$read_leaf_$_state_machine__10750__auto____1 = (function (state_30074){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_30074);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e30092){var ex__10753__auto__ = e30092;
var statearr_30093_30105 = state_30074;
(statearr_30093_30105[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_30074[(4)]))){
var statearr_30094_30106 = state_30074;
(statearr_30094_30106[(1)] = cljs.core.first((state_30074[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__30107 = state_30074;
state_30074 = G__30107;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__10750__auto__ = function(state_30074){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__10750__auto____1.call(this,state_30074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__10750__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__10750__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_30095 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_30095[(6)] = c__10876__auto__);

return statearr_30095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10876__auto___30180 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_30152){
var state_val_30153 = (state_30152[(1)]);
if((state_val_30153 === (7))){
var inst_30124 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_30125 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30126 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_30127 = cljs.core.PersistentHashMap.fromArrays(inst_30125,inst_30126);
var inst_30128 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30124,inst_30127);
var inst_30129 = (function(){throw inst_30128})();
var state_30152__$1 = state_30152;
var statearr_30154_30181 = state_30152__$1;
(statearr_30154_30181[(2)] = inst_30129);

(statearr_30154_30181[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30153 === (1))){
var state_30152__$1 = state_30152;
var statearr_30155_30182 = state_30152__$1;
(statearr_30155_30182[(2)] = null);

(statearr_30155_30182[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30153 === (4))){
var inst_30108 = (state_30152[(2)]);
var inst_30109 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_30110 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_30108);
var inst_30111 = cljs.core.async.close_BANG_(return_ch);
var state_30152__$1 = (function (){var statearr_30156 = state_30152;
(statearr_30156[(7)] = inst_30110);

(statearr_30156[(8)] = inst_30109);

return statearr_30156;
})();
var statearr_30157_30183 = state_30152__$1;
(statearr_30157_30183[(2)] = inst_30111);

(statearr_30157_30183[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30153 === (6))){
var inst_30121 = (state_30152[(9)]);
var inst_30121__$1 = (state_30152[(2)]);
var inst_30122 = (inst_30121__$1 == null);
var state_30152__$1 = (function (){var statearr_30158 = state_30152;
(statearr_30158[(9)] = inst_30121__$1);

return statearr_30158;
})();
if(cljs.core.truth_(inst_30122)){
var statearr_30159_30184 = state_30152__$1;
(statearr_30159_30184[(1)] = (7));

} else {
var statearr_30160_30185 = state_30152__$1;
(statearr_30160_30185[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30153 === (3))){
var inst_30150 = (state_30152[(2)]);
var state_30152__$1 = state_30152;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30152__$1,inst_30150);
} else {
if((state_val_30153 === (12))){
var inst_30121 = (state_30152[(9)]);
var inst_30138 = (state_30152[(2)]);
var inst_30139 = cljs.core.__destructure_map(inst_30121);
var inst_30140 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30139,cljs.core.cst$kw$flakes);
var inst_30141 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30139,cljs.core.cst$kw$his);
var inst_30142 = config;
var inst_30143 = cljs.core.__destructure_map(inst_30142);
var inst_30144 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30143,cljs.core.cst$kw$comparator);
var inst_30145 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_30144,inst_30140);
var inst_30146 = fluree.db.index.data_node(block,t,inst_30145,rhs,config);
var inst_30147 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_30146);
var _ = (function (){var statearr_30161 = state_30152;
(statearr_30161[(4)] = cljs.core.rest((state_30152[(4)])));

return statearr_30161;
})();
var state_30152__$1 = (function (){var statearr_30162 = state_30152;
(statearr_30162[(10)] = inst_30138);

(statearr_30162[(11)] = inst_30141);

return statearr_30162;
})();
var statearr_30163_30186 = state_30152__$1;
(statearr_30163_30186[(2)] = inst_30147);

(statearr_30163_30186[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30153 === (2))){
var _ = (function (){var statearr_30164 = state_30152;
(statearr_30164[(4)] = cljs.core.cons((5),(state_30152[(4)])));

return statearr_30164;
})();
var inst_30119 = fluree.db.storage.core.read_leaf(conn,key);
var state_30152__$1 = state_30152;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30152__$1,(6),inst_30119);
} else {
if((state_val_30153 === (11))){
var state_30152__$1 = state_30152;
var statearr_30166_30187 = state_30152__$1;
(statearr_30166_30187[(2)] = null);

(statearr_30166_30187[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30153 === (9))){
var inst_30121 = (state_30152[(9)]);
var inst_30132 = (state_30152[(2)]);
var inst_30133 = fluree.db.util.core.exception_QMARK_(inst_30121);
var state_30152__$1 = (function (){var statearr_30167 = state_30152;
(statearr_30167[(12)] = inst_30132);

return statearr_30167;
})();
if(inst_30133){
var statearr_30168_30188 = state_30152__$1;
(statearr_30168_30188[(1)] = (10));

} else {
var statearr_30169_30189 = state_30152__$1;
(statearr_30169_30189[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30153 === (5))){
var _ = (function (){var statearr_30170 = state_30152;
(statearr_30170[(4)] = cljs.core.rest((state_30152[(4)])));

return statearr_30170;
})();
var state_30152__$1 = state_30152;
var ex30165 = (state_30152__$1[(2)]);
var statearr_30171_30190 = state_30152__$1;
(statearr_30171_30190[(5)] = ex30165);


var statearr_30172_30191 = state_30152__$1;
(statearr_30172_30191[(1)] = (4));

(statearr_30172_30191[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_30153 === (10))){
var inst_30121 = (state_30152[(9)]);
var inst_30135 = (function(){throw inst_30121})();
var state_30152__$1 = state_30152;
var statearr_30173_30192 = state_30152__$1;
(statearr_30173_30192[(2)] = inst_30135);

(statearr_30173_30192[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30153 === (8))){
var state_30152__$1 = state_30152;
var statearr_30174_30193 = state_30152__$1;
(statearr_30174_30193[(2)] = null);

(statearr_30174_30193[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__10750__auto____0 = (function (){
var statearr_30175 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30175[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__10750__auto__);

(statearr_30175[(1)] = (1));

return statearr_30175;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__10750__auto____1 = (function (state_30152){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_30152);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e30176){var ex__10753__auto__ = e30176;
var statearr_30177_30194 = state_30152;
(statearr_30177_30194[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_30152[(4)]))){
var statearr_30178_30195 = state_30152;
(statearr_30178_30195[(1)] = cljs.core.first((state_30152[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__30196 = state_30152;
state_30152 = G__30196;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__10750__auto__ = function(state_30152){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__10750__auto____1.call(this,state_30152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__10750__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__10750__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_30179 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_30179[(6)] = c__10876__auto___30180);

return statearr_30179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k30198,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__30202 = k30198;
var G__30202__$1 = (((G__30202 instanceof cljs.core.Keyword))?G__30202.fqn:null);
switch (G__30202__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k30198,else__4464__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__30203){
var vec__30204 = p__30203;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30204,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30204,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__30197){
var self__ = this;
var G__30197__$1 = this;
return (new cljs.core.RecordIter((0),G__30197__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__30207 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__30208 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__30209 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__30210 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__30209,G__30210) : object_cache.call(null,G__30209,G__30210));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__30211 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__30212 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__30211,G__30212) : object_cache.call(null,G__30211,G__30212));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__30207,G__30208) : object_cache.call(null,G__30207,G__30208));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__30213 = history_id;
var G__30214 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__30213,G__30214) : object_cache.call(null,G__30213,G__30214));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__30215 = (function (coll__4458__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__30215(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this30199,other30200){
var self__ = this;
var this30199__$1 = this;
return (((!((other30200 == null)))) && ((((this30199__$1.constructor === other30200.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.conn,other30200.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.config,other30200.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.network,other30200.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.dbid,other30200.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.id,other30200.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.leaf,other30200.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.first,other30200.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.rhs,other30200.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.size,other30200.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.block,other30200.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.t,other30200.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.tt_id,other30200.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.leftmost_QMARK_,other30200.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.tempid,other30200.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30199__$1.__extmap,other30200.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k30198){
var self__ = this;
var this__4468__auto____$1 = this;
var G__30216 = k30198;
var G__30216__$1 = (((G__30216 instanceof cljs.core.Keyword))?G__30216.fqn:null);
switch (G__30216__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k30198);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__30197){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__30217 = cljs.core.keyword_identical_QMARK_;
var expr__30218 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__30220 = cljs.core.cst$kw$conn;
var G__30221 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30220,G__30221) : pred__30217.call(null,G__30220,G__30221));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__30197,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30222 = cljs.core.cst$kw$config;
var G__30223 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30222,G__30223) : pred__30217.call(null,G__30222,G__30223));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__30197,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30224 = cljs.core.cst$kw$network;
var G__30225 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30224,G__30225) : pred__30217.call(null,G__30224,G__30225));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__30197,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30226 = cljs.core.cst$kw$dbid;
var G__30227 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30226,G__30227) : pred__30217.call(null,G__30226,G__30227));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__30197,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30228 = cljs.core.cst$kw$id;
var G__30229 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30228,G__30229) : pred__30217.call(null,G__30228,G__30229));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__30197,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30230 = cljs.core.cst$kw$leaf;
var G__30231 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30230,G__30231) : pred__30217.call(null,G__30230,G__30231));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__30197,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30232 = cljs.core.cst$kw$first;
var G__30233 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30232,G__30233) : pred__30217.call(null,G__30232,G__30233));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__30197,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30234 = cljs.core.cst$kw$rhs;
var G__30235 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30234,G__30235) : pred__30217.call(null,G__30234,G__30235));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__30197,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30236 = cljs.core.cst$kw$size;
var G__30237 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30236,G__30237) : pred__30217.call(null,G__30236,G__30237));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__30197,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30238 = cljs.core.cst$kw$block;
var G__30239 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30238,G__30239) : pred__30217.call(null,G__30238,G__30239));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__30197,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30240 = cljs.core.cst$kw$t;
var G__30241 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30240,G__30241) : pred__30217.call(null,G__30240,G__30241));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__30197,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30242 = cljs.core.cst$kw$tt_DASH_id;
var G__30243 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30242,G__30243) : pred__30217.call(null,G__30242,G__30243));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__30197,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30244 = cljs.core.cst$kw$leftmost_QMARK_;
var G__30245 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30244,G__30245) : pred__30217.call(null,G__30244,G__30245));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__30197,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__30246 = cljs.core.cst$kw$tempid;
var G__30247 = expr__30218;
return (pred__30217.cljs$core$IFn$_invoke$arity$2 ? pred__30217.cljs$core$IFn$_invoke$arity$2(G__30246,G__30247) : pred__30217.call(null,G__30246,G__30247));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__30197,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__30197),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__30197){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__30197,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__30201){
var extmap__4501__auto__ = (function (){var G__30248 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__30201,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__30201)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__30248);
} else {
return G__30248;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__30201),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__30201),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__30251 = blank_db;
var map__30251__$1 = cljs.core.__destructure_map(map__30251);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30251__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30251__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30251__$1,cljs.core.cst$kw$index_DASH_configs);
var map__30252 = root_data;
var map__30252__$1 = cljs.core.__destructure_map(map__30252);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30252__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30252__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30252__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30252__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_30274){
var state_val_30275 = (state_30274[(1)]);
if((state_val_30275 === (7))){
var state_30274__$1 = state_30274;
var statearr_30276_30296 = state_30274__$1;
(statearr_30276_30296[(2)] = null);

(statearr_30276_30296[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30275 === (1))){
var state_30274__$1 = state_30274;
var statearr_30277_30297 = state_30274__$1;
(statearr_30277_30297[(2)] = null);

(statearr_30277_30297[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30275 === (4))){
var inst_30253 = (state_30274[(2)]);
var state_30274__$1 = state_30274;
var statearr_30278_30298 = state_30274__$1;
(statearr_30278_30298[(2)] = inst_30253);

(statearr_30278_30298[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30275 === (6))){
var inst_30260 = (state_30274[(7)]);
var inst_30262 = fluree.db.storage.core.serde(conn);
var state_30274__$1 = (function (){var statearr_30279 = state_30274;
(statearr_30279[(8)] = inst_30262);

return statearr_30279;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30274__$1,(9),inst_30260);
} else {
if((state_val_30275 === (3))){
var inst_30272 = (state_30274[(2)]);
var state_30274__$1 = state_30274;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30274__$1,inst_30272);
} else {
if((state_val_30275 === (2))){
var inst_30260 = (state_30274[(7)]);
var _ = (function (){var statearr_30281 = state_30274;
(statearr_30281[(4)] = cljs.core.cons((5),(state_30274[(4)])));

return statearr_30281;
})();
var inst_30259 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_30260__$1 = fluree.db.storage.core.storage_read(conn,inst_30259);
var state_30274__$1 = (function (){var statearr_30282 = state_30274;
(statearr_30282[(7)] = inst_30260__$1);

return statearr_30282;
})();
if(cljs.core.truth_(inst_30260__$1)){
var statearr_30283_30299 = state_30274__$1;
(statearr_30283_30299[(1)] = (6));

} else {
var statearr_30284_30300 = state_30274__$1;
(statearr_30284_30300[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30275 === (9))){
var inst_30262 = (state_30274[(8)]);
var inst_30264 = (state_30274[(2)]);
var inst_30265 = fluree.db.util.async.throw_err(inst_30264);
var inst_30266 = fluree.db.serde.protocol._deserialize_garbage(inst_30262,inst_30265);
var state_30274__$1 = state_30274;
var statearr_30285_30301 = state_30274__$1;
(statearr_30285_30301[(2)] = inst_30266);

(statearr_30285_30301[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30275 === (5))){
var _ = (function (){var statearr_30286 = state_30274;
(statearr_30286[(4)] = cljs.core.rest((state_30274[(4)])));

return statearr_30286;
})();
var state_30274__$1 = state_30274;
var ex30280 = (state_30274__$1[(2)]);
var statearr_30287_30302 = state_30274__$1;
(statearr_30287_30302[(5)] = ex30280);


if((ex30280 instanceof Error)){
var statearr_30288_30303 = state_30274__$1;
(statearr_30288_30303[(1)] = (4));

(statearr_30288_30303[(5)] = null);

} else {
throw ex30280;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30275 === (8))){
var inst_30269 = (state_30274[(2)]);
var _ = (function (){var statearr_30289 = state_30274;
(statearr_30289[(4)] = cljs.core.rest((state_30274[(4)])));

return statearr_30289;
})();
var state_30274__$1 = state_30274;
var statearr_30290_30304 = state_30274__$1;
(statearr_30290_30304[(2)] = inst_30269);

(statearr_30290_30304[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__10750__auto____0 = (function (){
var statearr_30291 = [null,null,null,null,null,null,null,null,null];
(statearr_30291[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__10750__auto__);

(statearr_30291[(1)] = (1));

return statearr_30291;
});
var fluree$db$storage$core$read_garbage_$_state_machine__10750__auto____1 = (function (state_30274){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_30274);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e30292){var ex__10753__auto__ = e30292;
var statearr_30293_30305 = state_30274;
(statearr_30293_30305[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_30274[(4)]))){
var statearr_30294_30306 = state_30274;
(statearr_30294_30306[(1)] = cljs.core.first((state_30274[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__30307 = state_30274;
state_30274 = G__30307;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__10750__auto__ = function(state_30274){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__10750__auto____1.call(this,state_30274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__10750__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__10750__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_30295 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_30295[(6)] = c__10876__auto__);

return statearr_30295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_30329){
var state_val_30330 = (state_30329[(1)]);
if((state_val_30330 === (7))){
var inst_30318 = (state_30329[(7)]);
var inst_30320 = fluree.db.storage.core.serde(conn);
var inst_30321 = fluree.db.serde.protocol._deserialize_db_root(inst_30320,inst_30318);
var state_30329__$1 = state_30329;
var statearr_30331_30350 = state_30329__$1;
(statearr_30331_30350[(2)] = inst_30321);

(statearr_30331_30350[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30330 === (1))){
var state_30329__$1 = state_30329;
var statearr_30332_30351 = state_30329__$1;
(statearr_30332_30351[(2)] = null);

(statearr_30332_30351[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30330 === (4))){
var inst_30308 = (state_30329[(2)]);
var state_30329__$1 = state_30329;
var statearr_30333_30352 = state_30329__$1;
(statearr_30333_30352[(2)] = inst_30308);

(statearr_30333_30352[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30330 === (6))){
var inst_30318 = (state_30329[(7)]);
var inst_30317 = (state_30329[(2)]);
var inst_30318__$1 = fluree.db.util.async.throw_err(inst_30317);
var state_30329__$1 = (function (){var statearr_30334 = state_30329;
(statearr_30334[(7)] = inst_30318__$1);

return statearr_30334;
})();
if(cljs.core.truth_(inst_30318__$1)){
var statearr_30335_30353 = state_30329__$1;
(statearr_30335_30353[(1)] = (7));

} else {
var statearr_30336_30354 = state_30329__$1;
(statearr_30336_30354[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30330 === (3))){
var inst_30327 = (state_30329[(2)]);
var state_30329__$1 = state_30329;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30329__$1,inst_30327);
} else {
if((state_val_30330 === (2))){
var _ = (function (){var statearr_30338 = state_30329;
(statearr_30338[(4)] = cljs.core.cons((5),(state_30329[(4)])));

return statearr_30338;
})();
var inst_30314 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_30315 = fluree.db.storage.core.storage_read(conn,inst_30314);
var state_30329__$1 = state_30329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30329__$1,(6),inst_30315);
} else {
if((state_val_30330 === (9))){
var inst_30324 = (state_30329[(2)]);
var _ = (function (){var statearr_30339 = state_30329;
(statearr_30339[(4)] = cljs.core.rest((state_30329[(4)])));

return statearr_30339;
})();
var state_30329__$1 = state_30329;
var statearr_30340_30355 = state_30329__$1;
(statearr_30340_30355[(2)] = inst_30324);

(statearr_30340_30355[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30330 === (5))){
var _ = (function (){var statearr_30341 = state_30329;
(statearr_30341[(4)] = cljs.core.rest((state_30329[(4)])));

return statearr_30341;
})();
var state_30329__$1 = state_30329;
var ex30337 = (state_30329__$1[(2)]);
var statearr_30342_30356 = state_30329__$1;
(statearr_30342_30356[(5)] = ex30337);


if((ex30337 instanceof Error)){
var statearr_30343_30357 = state_30329__$1;
(statearr_30343_30357[(1)] = (4));

(statearr_30343_30357[(5)] = null);

} else {
throw ex30337;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30330 === (8))){
var state_30329__$1 = state_30329;
var statearr_30344_30358 = state_30329__$1;
(statearr_30344_30358[(2)] = null);

(statearr_30344_30358[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__10750__auto____0 = (function (){
var statearr_30345 = [null,null,null,null,null,null,null,null];
(statearr_30345[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__10750__auto__);

(statearr_30345[(1)] = (1));

return statearr_30345;
});
var fluree$db$storage$core$read_db_root_$_state_machine__10750__auto____1 = (function (state_30329){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_30329);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e30346){var ex__10753__auto__ = e30346;
var statearr_30347_30359 = state_30329;
(statearr_30347_30359[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_30329[(4)]))){
var statearr_30348_30360 = state_30329;
(statearr_30348_30360[(1)] = cljs.core.first((state_30329[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__30361 = state_30329;
state_30329 = G__30361;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__10750__auto__ = function(state_30329){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__10750__auto____1.call(this,state_30329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__10750__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__10750__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_30349 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_30349[(6)] = c__10876__auto__);

return statearr_30349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_30397){
var state_val_30398 = (state_30397[(1)]);
if((state_val_30398 === (7))){
var inst_30371 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_30372 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30373 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_30374 = cljs.core.PersistentHashMap.fromArrays(inst_30372,inst_30373);
var inst_30375 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30371,inst_30374);
var inst_30376 = (function(){throw inst_30375})();
var state_30397__$1 = state_30397;
var statearr_30399_30421 = state_30397__$1;
(statearr_30399_30421[(2)] = inst_30376);

(statearr_30399_30421[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30398 === (1))){
var state_30397__$1 = state_30397;
var statearr_30400_30422 = state_30397__$1;
(statearr_30400_30422[(2)] = null);

(statearr_30400_30422[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30398 === (4))){
var inst_30362 = (state_30397[(2)]);
var state_30397__$1 = state_30397;
var statearr_30401_30423 = state_30397__$1;
(statearr_30401_30423[(2)] = inst_30362);

(statearr_30401_30423[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30398 === (6))){
var state_30397__$1 = state_30397;
var statearr_30402_30424 = state_30397__$1;
(statearr_30402_30424[(2)] = null);

(statearr_30402_30424[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30398 === (3))){
var inst_30395 = (state_30397[(2)]);
var state_30397__$1 = state_30397;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30397__$1,inst_30395);
} else {
if((state_val_30398 === (2))){
var inst_30368 = (state_30397[(7)]);
var _ = (function (){var statearr_30403 = state_30397;
(statearr_30403[(4)] = cljs.core.cons((5),(state_30397[(4)])));

return statearr_30403;
})();
var inst_30368__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_30397__$1 = (function (){var statearr_30404 = state_30397;
(statearr_30404[(7)] = inst_30368__$1);

return statearr_30404;
})();
if(cljs.core.truth_(inst_30368__$1)){
var statearr_30405_30425 = state_30397__$1;
(statearr_30405_30425[(1)] = (6));

} else {
var statearr_30406_30426 = state_30397__$1;
(statearr_30406_30426[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30398 === (11))){
var inst_30387 = (state_30397[(8)]);
var inst_30390 = (state_30397[(2)]);
var inst_30391 = fluree.db.util.async.throw_err(inst_30390);
var inst_30392 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_30387,cljs.core.cst$kw$settings,inst_30391);
var _ = (function (){var statearr_30408 = state_30397;
(statearr_30408[(4)] = cljs.core.rest((state_30397[(4)])));

return statearr_30408;
})();
var state_30397__$1 = state_30397;
var statearr_30409_30427 = state_30397__$1;
(statearr_30409_30427[(2)] = inst_30392);

(statearr_30409_30427[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30398 === (9))){
var inst_30382 = (state_30397[(9)]);
var inst_30380 = (state_30397[(2)]);
var inst_30381 = fluree.db.util.async.throw_err(inst_30380);
var inst_30382__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_30381);
var inst_30383 = fluree.db.query.schema.schema_map(inst_30382__$1);
var state_30397__$1 = (function (){var statearr_30410 = state_30397;
(statearr_30410[(9)] = inst_30382__$1);

return statearr_30410;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30397__$1,(10),inst_30383);
} else {
if((state_val_30398 === (5))){
var _ = (function (){var statearr_30411 = state_30397;
(statearr_30411[(4)] = cljs.core.rest((state_30397[(4)])));

return statearr_30411;
})();
var state_30397__$1 = state_30397;
var ex30407 = (state_30397__$1[(2)]);
var statearr_30412_30428 = state_30397__$1;
(statearr_30412_30428[(5)] = ex30407);


if((ex30407 instanceof Error)){
var statearr_30413_30429 = state_30397__$1;
(statearr_30413_30429[(1)] = (4));

(statearr_30413_30429[(5)] = null);

} else {
throw ex30407;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30398 === (10))){
var inst_30387 = (state_30397[(8)]);
var inst_30382 = (state_30397[(9)]);
var inst_30385 = (state_30397[(2)]);
var inst_30386 = fluree.db.util.async.throw_err(inst_30385);
var inst_30387__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_30382,cljs.core.cst$kw$schema,inst_30386);
var inst_30388 = fluree.db.query.schema.setting_map(inst_30387__$1);
var state_30397__$1 = (function (){var statearr_30414 = state_30397;
(statearr_30414[(8)] = inst_30387__$1);

return statearr_30414;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30397__$1,(11),inst_30388);
} else {
if((state_val_30398 === (8))){
var inst_30368 = (state_30397[(7)]);
var inst_30378 = (state_30397[(2)]);
var state_30397__$1 = (function (){var statearr_30415 = state_30397;
(statearr_30415[(10)] = inst_30378);

return statearr_30415;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30397__$1,(9),inst_30368);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__10750__auto____0 = (function (){
var statearr_30416 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30416[(0)] = fluree$db$storage$core$reify_db_$_state_machine__10750__auto__);

(statearr_30416[(1)] = (1));

return statearr_30416;
});
var fluree$db$storage$core$reify_db_$_state_machine__10750__auto____1 = (function (state_30397){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_30397);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e30417){var ex__10753__auto__ = e30417;
var statearr_30418_30430 = state_30397;
(statearr_30418_30430[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_30397[(4)]))){
var statearr_30419_30431 = state_30397;
(statearr_30419_30431[(1)] = cljs.core.first((state_30397[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__30432 = state_30397;
state_30397 = G__30432;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__10750__auto__ = function(state_30397){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__10750__auto____1.call(this,state_30397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__10750__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__10750__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_30420 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_30420[(6)] = c__10876__auto__);

return statearr_30420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__30434 = arguments.length;
switch (G__30434) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_30487){
var state_val_30488 = (state_30487[(1)]);
if((state_val_30488 === (7))){
var inst_30444 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_30445 = (new Error(inst_30444));
var inst_30446 = (function(){throw inst_30445})();
var state_30487__$1 = state_30487;
var statearr_30489_30529 = state_30487__$1;
(statearr_30489_30529[(2)] = inst_30446);

(statearr_30489_30529[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (20))){
var inst_30478 = (state_30487[(2)]);
var state_30487__$1 = state_30487;
var statearr_30490_30530 = state_30487__$1;
(statearr_30490_30530[(2)] = inst_30478);

(statearr_30490_30530[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (1))){
var state_30487__$1 = state_30487;
var statearr_30491_30531 = state_30487__$1;
(statearr_30491_30531[(2)] = null);

(statearr_30491_30531[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (4))){
var inst_30435 = (state_30487[(2)]);
var state_30487__$1 = state_30487;
var statearr_30492_30532 = state_30487__$1;
(statearr_30492_30532[(2)] = inst_30435);

(statearr_30492_30532[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (15))){
var inst_30453 = (state_30487[(7)]);
var state_30487__$1 = state_30487;
var statearr_30493_30533 = state_30487__$1;
(statearr_30493_30533[(2)] = inst_30453);

(statearr_30493_30533[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (21))){
var inst_30452 = (state_30487[(8)]);
var inst_30453 = (state_30487[(7)]);
var inst_30457 = (state_30487[(9)]);
var inst_30471 = (inst_30452 + (1));
var inst_30472 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30453,inst_30457);
var inst_30452__$1 = inst_30471;
var inst_30453__$1 = inst_30472;
var state_30487__$1 = (function (){var statearr_30494 = state_30487;
(statearr_30494[(8)] = inst_30452__$1);

(statearr_30494[(7)] = inst_30453__$1);

return statearr_30494;
})();
var statearr_30495_30534 = state_30487__$1;
(statearr_30495_30534[(2)] = null);

(statearr_30495_30534[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (13))){
var inst_30457 = (state_30487[(9)]);
var inst_30461 = (inst_30457 instanceof Error);
var state_30487__$1 = state_30487;
var statearr_30496_30535 = state_30487__$1;
(statearr_30496_30535[(2)] = inst_30461);

(statearr_30496_30535[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (22))){
var state_30487__$1 = state_30487;
var statearr_30497_30536 = state_30487__$1;
(statearr_30497_30536[(2)] = null);

(statearr_30497_30536[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (6))){
var state_30487__$1 = state_30487;
var statearr_30498_30537 = state_30487__$1;
(statearr_30498_30537[(2)] = null);

(statearr_30498_30537[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (17))){
var inst_30480 = (state_30487[(2)]);
var state_30487__$1 = state_30487;
var statearr_30499_30538 = state_30487__$1;
(statearr_30499_30538[(2)] = inst_30480);

(statearr_30499_30538[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (3))){
var inst_30485 = (state_30487[(2)]);
var state_30487__$1 = state_30487;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30487__$1,inst_30485);
} else {
if((state_val_30488 === (12))){
var inst_30458 = (state_30487[(10)]);
var state_30487__$1 = state_30487;
var statearr_30500_30539 = state_30487__$1;
(statearr_30500_30539[(2)] = inst_30458);

(statearr_30500_30539[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (2))){
var _ = (function (){var statearr_30501 = state_30487;
(statearr_30501[(4)] = cljs.core.cons((5),(state_30487[(4)])));

return statearr_30501;
})();
var inst_30441 = (end >= start);
var state_30487__$1 = state_30487;
if(cljs.core.truth_(inst_30441)){
var statearr_30502_30540 = state_30487__$1;
(statearr_30502_30540[(1)] = (6));

} else {
var statearr_30503_30541 = state_30487__$1;
(statearr_30503_30541[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (23))){
var inst_30476 = (state_30487[(2)]);
var state_30487__$1 = state_30487;
var statearr_30504_30542 = state_30487__$1;
(statearr_30504_30542[(2)] = inst_30476);

(statearr_30504_30542[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (19))){
var state_30487__$1 = state_30487;
var statearr_30505_30543 = state_30487__$1;
(statearr_30505_30543[(1)] = (21));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (11))){
var inst_30458 = (state_30487[(10)]);
var inst_30457 = (state_30487[(9)]);
var inst_30457__$1 = (state_30487[(2)]);
var inst_30458__$1 = (inst_30457__$1 == null);
var state_30487__$1 = (function (){var statearr_30508 = state_30487;
(statearr_30508[(10)] = inst_30458__$1);

(statearr_30508[(9)] = inst_30457__$1);

return statearr_30508;
})();
if(cljs.core.truth_(inst_30458__$1)){
var statearr_30509_30544 = state_30487__$1;
(statearr_30509_30544[(1)] = (12));

} else {
var statearr_30510_30545 = state_30487__$1;
(statearr_30510_30545[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (9))){
var inst_30452 = (state_30487[(8)]);
var inst_30455 = fluree.db.storage.core.read_block(conn,network,dbid,inst_30452);
var state_30487__$1 = state_30487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30487__$1,(11),inst_30455);
} else {
if((state_val_30488 === (5))){
var _ = (function (){var statearr_30511 = state_30487;
(statearr_30511[(4)] = cljs.core.rest((state_30487[(4)])));

return statearr_30511;
})();
var state_30487__$1 = state_30487;
var ex30507 = (state_30487__$1[(2)]);
var statearr_30512_30546 = state_30487__$1;
(statearr_30512_30546[(5)] = ex30507);


if((ex30507 instanceof Error)){
var statearr_30513_30547 = state_30487__$1;
(statearr_30513_30547[(1)] = (4));

(statearr_30513_30547[(5)] = null);

} else {
throw ex30507;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (14))){
var inst_30463 = (state_30487[(2)]);
var state_30487__$1 = state_30487;
if(cljs.core.truth_(inst_30463)){
var statearr_30514_30548 = state_30487__$1;
(statearr_30514_30548[(1)] = (15));

} else {
var statearr_30515_30549 = state_30487__$1;
(statearr_30515_30549[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (16))){
var inst_30452 = (state_30487[(8)]);
var inst_30466 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30452,end);
var state_30487__$1 = state_30487;
if(inst_30466){
var statearr_30516_30550 = state_30487__$1;
(statearr_30516_30550[(1)] = (18));

} else {
var statearr_30517_30551 = state_30487__$1;
(statearr_30517_30551[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (10))){
var inst_30482 = (state_30487[(2)]);
var _ = (function (){var statearr_30518 = state_30487;
(statearr_30518[(4)] = cljs.core.rest((state_30487[(4)])));

return statearr_30518;
})();
var state_30487__$1 = state_30487;
var statearr_30519_30552 = state_30487__$1;
(statearr_30519_30552[(2)] = inst_30482);

(statearr_30519_30552[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (18))){
var inst_30453 = (state_30487[(7)]);
var inst_30457 = (state_30487[(9)]);
var inst_30468 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30453,inst_30457);
var state_30487__$1 = state_30487;
var statearr_30520_30553 = state_30487__$1;
(statearr_30520_30553[(2)] = inst_30468);

(statearr_30520_30553[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30488 === (8))){
var inst_30448 = (state_30487[(2)]);
var inst_30449 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_30450 = start;
var inst_30451 = cljs.core.PersistentVector.EMPTY;
var inst_30452 = inst_30450;
var inst_30453 = inst_30451;
var state_30487__$1 = (function (){var statearr_30521 = state_30487;
(statearr_30521[(11)] = inst_30449);

(statearr_30521[(8)] = inst_30452);

(statearr_30521[(7)] = inst_30453);

(statearr_30521[(12)] = inst_30448);

return statearr_30521;
})();
var statearr_30522_30554 = state_30487__$1;
(statearr_30522_30554[(2)] = null);

(statearr_30522_30554[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__10750__auto__ = null;
var fluree$db$storage$core$state_machine__10750__auto____0 = (function (){
var statearr_30523 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30523[(0)] = fluree$db$storage$core$state_machine__10750__auto__);

(statearr_30523[(1)] = (1));

return statearr_30523;
});
var fluree$db$storage$core$state_machine__10750__auto____1 = (function (state_30487){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_30487);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e30524){var ex__10753__auto__ = e30524;
var statearr_30525_30555 = state_30487;
(statearr_30525_30555[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_30487[(4)]))){
var statearr_30526_30556 = state_30487;
(statearr_30526_30556[(1)] = cljs.core.first((state_30487[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__30557 = state_30487;
state_30487 = G__30557;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__10750__auto__ = function(state_30487){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__10750__auto____1.call(this,state_30487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__10750__auto____0;
fluree$db$storage$core$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__10750__auto____1;
return fluree$db$storage$core$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_30527 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_30527[(6)] = c__10876__auto__);

return statearr_30527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_30573){
var state_val_30574 = (state_30573[(1)]);
if((state_val_30574 === (1))){
var state_30573__$1 = state_30573;
var statearr_30575_30589 = state_30573__$1;
(statearr_30575_30589[(2)] = null);

(statearr_30575_30589[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30574 === (2))){
var _ = (function (){var statearr_30576 = state_30573;
(statearr_30576[(4)] = cljs.core.cons((5),(state_30573[(4)])));

return statearr_30576;
})();
var inst_30564 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_30573__$1 = state_30573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30573__$1,(6),inst_30564);
} else {
if((state_val_30574 === (3))){
var inst_30571 = (state_30573[(2)]);
var state_30573__$1 = state_30573;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30573__$1,inst_30571);
} else {
if((state_val_30574 === (4))){
var inst_30558 = (state_30573[(2)]);
var state_30573__$1 = state_30573;
var statearr_30578_30590 = state_30573__$1;
(statearr_30578_30590[(2)] = inst_30558);

(statearr_30578_30590[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30574 === (5))){
var _ = (function (){var statearr_30579 = state_30573;
(statearr_30579[(4)] = cljs.core.rest((state_30573[(4)])));

return statearr_30579;
})();
var state_30573__$1 = state_30573;
var ex30577 = (state_30573__$1[(2)]);
var statearr_30580_30591 = state_30573__$1;
(statearr_30580_30591[(5)] = ex30577);


if((ex30577 instanceof Error)){
var statearr_30581_30592 = state_30573__$1;
(statearr_30581_30592[(1)] = (4));

(statearr_30581_30592[(5)] = null);

} else {
throw ex30577;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30574 === (6))){
var inst_30566 = (state_30573[(2)]);
var inst_30567 = fluree.db.util.async.throw_err(inst_30566);
var inst_30568 = cljs.core.first(inst_30567);
var _ = (function (){var statearr_30582 = state_30573;
(statearr_30582[(4)] = cljs.core.rest((state_30573[(4)])));

return statearr_30582;
})();
var state_30573__$1 = state_30573;
var statearr_30583_30593 = state_30573__$1;
(statearr_30583_30593[(2)] = inst_30568);

(statearr_30583_30593[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__10750__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__10750__auto____0 = (function (){
var statearr_30584 = [null,null,null,null,null,null,null];
(statearr_30584[(0)] = fluree$db$storage$core$block_$_state_machine__10750__auto__);

(statearr_30584[(1)] = (1));

return statearr_30584;
});
var fluree$db$storage$core$block_$_state_machine__10750__auto____1 = (function (state_30573){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_30573);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e30585){var ex__10753__auto__ = e30585;
var statearr_30586_30594 = state_30573;
(statearr_30586_30594[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_30573[(4)]))){
var statearr_30587_30595 = state_30573;
(statearr_30587_30595[(1)] = cljs.core.first((state_30573[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__30596 = state_30573;
state_30573 = G__30596;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__10750__auto__ = function(state_30573){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__10750__auto____1.call(this,state_30573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__10750__auto____0;
fluree$db$storage$core$block_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__10750__auto____1;
return fluree$db$storage$core$block_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_30588 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_30588[(6)] = c__10876__auto__);

return statearr_30588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
