// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k39624,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__39628 = k39624;
var G__39628__$1 = (((G__39628 instanceof cljs.core.Keyword))?G__39628.fqn:null);
switch (G__39628__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39624,else__4464__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__39629){
var vec__39630 = p__39629;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39630,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39630,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39623){
var self__ = this;
var G__39623__$1 = this;
return (new cljs.core.RecordIter((0),G__39623__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__39633 = (function (coll__4458__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__39633(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39625,other39626){
var self__ = this;
var this39625__$1 = this;
return (((!((other39626 == null)))) && ((((this39625__$1.constructor === other39626.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39625__$1.conn,other39626.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39625__$1.network,other39626.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39625__$1.dbid,other39626.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39625__$1.db_name,other39626.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39625__$1.update_chan,other39626.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39625__$1.transact_chan,other39626.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39625__$1.state,other39626.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39625__$1.schema_cache,other39626.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39625__$1.blank_db,other39626.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39625__$1.close,other39626.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39625__$1.id,other39626.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39625__$1.__extmap,other39626.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k39624){
var self__ = this;
var this__4468__auto____$1 = this;
var G__39634 = k39624;
var G__39634__$1 = (((G__39634 instanceof cljs.core.Keyword))?G__39634.fqn:null);
switch (G__39634__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k39624);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__39623){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__39635 = cljs.core.keyword_identical_QMARK_;
var expr__39636 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__39638 = cljs.core.cst$kw$conn;
var G__39639 = expr__39636;
return (pred__39635.cljs$core$IFn$_invoke$arity$2 ? pred__39635.cljs$core$IFn$_invoke$arity$2(G__39638,G__39639) : pred__39635.call(null,G__39638,G__39639));
})())){
return (new fluree.db.session.DbSession(G__39623,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39640 = cljs.core.cst$kw$network;
var G__39641 = expr__39636;
return (pred__39635.cljs$core$IFn$_invoke$arity$2 ? pred__39635.cljs$core$IFn$_invoke$arity$2(G__39640,G__39641) : pred__39635.call(null,G__39640,G__39641));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__39623,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39642 = cljs.core.cst$kw$dbid;
var G__39643 = expr__39636;
return (pred__39635.cljs$core$IFn$_invoke$arity$2 ? pred__39635.cljs$core$IFn$_invoke$arity$2(G__39642,G__39643) : pred__39635.call(null,G__39642,G__39643));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__39623,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39644 = cljs.core.cst$kw$db_DASH_name;
var G__39645 = expr__39636;
return (pred__39635.cljs$core$IFn$_invoke$arity$2 ? pred__39635.cljs$core$IFn$_invoke$arity$2(G__39644,G__39645) : pred__39635.call(null,G__39644,G__39645));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__39623,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39646 = cljs.core.cst$kw$update_DASH_chan;
var G__39647 = expr__39636;
return (pred__39635.cljs$core$IFn$_invoke$arity$2 ? pred__39635.cljs$core$IFn$_invoke$arity$2(G__39646,G__39647) : pred__39635.call(null,G__39646,G__39647));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__39623,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39648 = cljs.core.cst$kw$transact_DASH_chan;
var G__39649 = expr__39636;
return (pred__39635.cljs$core$IFn$_invoke$arity$2 ? pred__39635.cljs$core$IFn$_invoke$arity$2(G__39648,G__39649) : pred__39635.call(null,G__39648,G__39649));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__39623,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39650 = cljs.core.cst$kw$state;
var G__39651 = expr__39636;
return (pred__39635.cljs$core$IFn$_invoke$arity$2 ? pred__39635.cljs$core$IFn$_invoke$arity$2(G__39650,G__39651) : pred__39635.call(null,G__39650,G__39651));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__39623,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39652 = cljs.core.cst$kw$schema_DASH_cache;
var G__39653 = expr__39636;
return (pred__39635.cljs$core$IFn$_invoke$arity$2 ? pred__39635.cljs$core$IFn$_invoke$arity$2(G__39652,G__39653) : pred__39635.call(null,G__39652,G__39653));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__39623,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39654 = cljs.core.cst$kw$blank_DASH_db;
var G__39655 = expr__39636;
return (pred__39635.cljs$core$IFn$_invoke$arity$2 ? pred__39635.cljs$core$IFn$_invoke$arity$2(G__39654,G__39655) : pred__39635.call(null,G__39654,G__39655));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__39623,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39656 = cljs.core.cst$kw$close;
var G__39657 = expr__39636;
return (pred__39635.cljs$core$IFn$_invoke$arity$2 ? pred__39635.cljs$core$IFn$_invoke$arity$2(G__39656,G__39657) : pred__39635.call(null,G__39656,G__39657));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__39623,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39658 = cljs.core.cst$kw$id;
var G__39659 = expr__39636;
return (pred__39635.cljs$core$IFn$_invoke$arity$2 ? pred__39635.cljs$core$IFn$_invoke$arity$2(G__39658,G__39659) : pred__39635.call(null,G__39658,G__39659));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__39623,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__39623),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__39623){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__39623,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__39627){
var extmap__4501__auto__ = (function (){var G__39660 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39627,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__39627)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__39660);
} else {
return G__39660;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__39627),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__39627),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__39627),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__39627),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__39627),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__39627),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__39627),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__39627),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__39627),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__39627),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__39627),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__39663 = session;
var map__39663__$1 = cljs.core.__destructure_map(map__39663);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39663__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39663__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10876__auto___39815 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_39767){
var state_val_39768 = (state_39767[(1)]);
if((state_val_39768 === (7))){
var inst_39684 = (state_39767[(7)]);
var inst_39689 = cljs.core.empty_QMARK_(inst_39684);
var state_39767__$1 = state_39767;
if(inst_39689){
var statearr_39769_39816 = state_39767__$1;
(statearr_39769_39816[(1)] = (10));

} else {
var statearr_39770_39817 = state_39767__$1;
(statearr_39770_39817[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (20))){
var inst_39675 = (state_39767[(8)]);
var inst_39676 = (state_39767[(9)]);
var inst_39715 = (state_39767[(10)]);
var inst_39677 = (state_39767[(11)]);
var inst_39720 = fluree.db.storage.core.read_block(inst_39675,inst_39676,inst_39677,inst_39715);
var state_39767__$1 = state_39767;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39767__$1,(22),inst_39720);
} else {
if((state_val_39768 === (27))){
var inst_39756 = (state_39767[(12)]);
var inst_39751 = (state_39767[(13)]);
var inst_39754 = (state_39767[(2)]);
var inst_39755 = fluree.db.util.async.throw_err(inst_39754);
var inst_39756__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39751,cljs.core.cst$kw$schema,inst_39755);
var inst_39757 = fluree.db.query.schema.setting_map(inst_39756__$1);
var state_39767__$1 = (function (){var statearr_39771 = state_39767;
(statearr_39771[(12)] = inst_39756__$1);

return statearr_39771;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39767__$1,(28),inst_39757);
} else {
if((state_val_39768 === (1))){
var state_39767__$1 = state_39767;
var statearr_39772_39818 = state_39767__$1;
(statearr_39772_39818[(2)] = null);

(statearr_39772_39818[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (24))){
var inst_39676 = (state_39767[(9)]);
var inst_39715 = (state_39767[(10)]);
var inst_39677 = (state_39767[(11)]);
var inst_39737 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39715)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39676),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39677),"."].join('');
var inst_39738 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39739 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_39740 = cljs.core.PersistentHashMap.fromArrays(inst_39738,inst_39739);
var inst_39741 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39737,inst_39740);
var inst_39742 = (function(){throw inst_39741})();
var state_39767__$1 = state_39767;
var statearr_39773_39819 = state_39767__$1;
(statearr_39773_39819[(2)] = inst_39742);

(statearr_39773_39819[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (4))){
var inst_39664 = (state_39767[(2)]);
var inst_39665 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_39664);
var state_39767__$1 = state_39767;
var statearr_39774_39820 = state_39767__$1;
(statearr_39774_39820[(2)] = inst_39665);

(statearr_39774_39820[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (15))){
var state_39767__$1 = state_39767;
var statearr_39775_39821 = state_39767__$1;
(statearr_39775_39821[(2)] = null);

(statearr_39775_39821[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (21))){
var inst_39746 = (state_39767[(2)]);
var state_39767__$1 = state_39767;
var statearr_39776_39822 = state_39767__$1;
(statearr_39776_39822[(2)] = inst_39746);

(statearr_39776_39822[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (13))){
var inst_39709 = (state_39767[(14)]);
var inst_39684 = (state_39767[(7)]);
var inst_39708 = (state_39767[(2)]);
var inst_39709__$1 = fluree.db.util.async.throw_err(inst_39708);
var inst_39710 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_39684);
var state_39767__$1 = (function (){var statearr_39777 = state_39767;
(statearr_39777[(14)] = inst_39709__$1);

(statearr_39777[(15)] = inst_39710);

return statearr_39777;
})();
if(cljs.core.truth_(inst_39709__$1)){
var statearr_39778_39823 = state_39767__$1;
(statearr_39778_39823[(1)] = (14));

} else {
var statearr_39779_39824 = state_39767__$1;
(statearr_39779_39824[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (22))){
var inst_39723 = (state_39767[(16)]);
var inst_39722 = (state_39767[(2)]);
var inst_39723__$1 = fluree.db.util.async.throw_err(inst_39722);
var state_39767__$1 = (function (){var statearr_39780 = state_39767;
(statearr_39780[(16)] = inst_39723__$1);

return statearr_39780;
})();
if(cljs.core.truth_(inst_39723__$1)){
var statearr_39781_39825 = state_39767__$1;
(statearr_39781_39825[(1)] = (23));

} else {
var statearr_39782_39826 = state_39767__$1;
(statearr_39782_39826[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (6))){
var inst_39684 = (state_39767[(7)]);
var inst_39683 = (state_39767[(2)]);
var inst_39684__$1 = fluree.db.util.async.throw_err(inst_39683);
var inst_39685 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_39684__$1);
var inst_39686 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_39685);
var inst_39687 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_39686);
var state_39767__$1 = (function (){var statearr_39783 = state_39767;
(statearr_39783[(7)] = inst_39684__$1);

return statearr_39783;
})();
if(inst_39687){
var statearr_39784_39827 = state_39767__$1;
(statearr_39784_39827[(1)] = (7));

} else {
var statearr_39785_39828 = state_39767__$1;
(statearr_39785_39828[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (28))){
var inst_39756 = (state_39767[(12)]);
var inst_39759 = (state_39767[(2)]);
var inst_39760 = fluree.db.util.async.throw_err(inst_39759);
var inst_39761 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39756,cljs.core.cst$kw$settings,inst_39760);
var inst_39762 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_39761);
var _ = (function (){var statearr_39786 = state_39767;
(statearr_39786[(4)] = cljs.core.rest((state_39767[(4)])));

return statearr_39786;
})();
var state_39767__$1 = state_39767;
var statearr_39787_39829 = state_39767__$1;
(statearr_39787_39829[(2)] = inst_39762);

(statearr_39787_39829[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (25))){
var inst_39744 = (state_39767[(2)]);
var state_39767__$1 = state_39767;
var statearr_39788_39830 = state_39767__$1;
(statearr_39788_39830[(2)] = inst_39744);

(statearr_39788_39830[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (17))){
var inst_39710 = (state_39767[(15)]);
var inst_39715 = (state_39767[(10)]);
var inst_39717 = (inst_39715 > inst_39710);
var state_39767__$1 = state_39767;
if(cljs.core.truth_(inst_39717)){
var statearr_39789_39831 = state_39767__$1;
(statearr_39789_39831[(1)] = (19));

} else {
var statearr_39790_39832 = state_39767__$1;
(statearr_39790_39832[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (3))){
var inst_39765 = (state_39767[(2)]);
var state_39767__$1 = state_39767;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39767__$1,inst_39765);
} else {
if((state_val_39768 === (12))){
var inst_39696 = (state_39767[(2)]);
var inst_39697 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39698 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_39699 = cljs.core.PersistentHashMap.fromArrays(inst_39697,inst_39698);
var inst_39700 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39696,inst_39699);
var inst_39701 = (function(){throw inst_39700})();
var state_39767__$1 = state_39767;
var statearr_39791_39833 = state_39767__$1;
(statearr_39791_39833[(2)] = inst_39701);

(statearr_39791_39833[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (2))){
var inst_39675 = (state_39767[(8)]);
var inst_39676 = (state_39767[(9)]);
var inst_39677 = (state_39767[(11)]);
var _ = (function (){var statearr_39792 = state_39767;
(statearr_39792[(4)] = cljs.core.cons((5),(state_39767[(4)])));

return statearr_39792;
})();
var inst_39672 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_39673 = session;
var inst_39674 = cljs.core.__destructure_map(inst_39673);
var inst_39675__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39674,cljs.core.cst$kw$conn);
var inst_39676__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39674,cljs.core.cst$kw$network);
var inst_39677__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39674,cljs.core.cst$kw$dbid);
var inst_39678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39679 = [inst_39676__$1,inst_39677__$1];
var inst_39680 = (new cljs.core.PersistentVector(null,2,(5),inst_39678,inst_39679,null));
var inst_39681 = fluree.db.operations.ledger_info_async(inst_39675__$1,inst_39680);
var state_39767__$1 = (function (){var statearr_39793 = state_39767;
(statearr_39793[(8)] = inst_39675__$1);

(statearr_39793[(9)] = inst_39676__$1);

(statearr_39793[(11)] = inst_39677__$1);

(statearr_39793[(17)] = inst_39672);

return statearr_39793;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39767__$1,(6),inst_39681);
} else {
if((state_val_39768 === (23))){
var inst_39714 = (state_39767[(18)]);
var inst_39723 = (state_39767[(16)]);
var inst_39726 = cljs.core.__destructure_map(inst_39723);
var inst_39727 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39726,cljs.core.cst$kw$flakes);
var inst_39728 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39726,cljs.core.cst$kw$block);
var inst_39729 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39726,cljs.core.cst$kw$t);
var inst_39730 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_39714,inst_39728,inst_39727);
var state_39767__$1 = (function (){var statearr_39794 = state_39767;
(statearr_39794[(19)] = inst_39729);

return statearr_39794;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39767__$1,(26),inst_39730);
} else {
if((state_val_39768 === (19))){
var inst_39714 = (state_39767[(18)]);
var state_39767__$1 = state_39767;
var statearr_39795_39834 = state_39767__$1;
(statearr_39795_39834[(2)] = inst_39714);

(statearr_39795_39834[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (11))){
var inst_39676 = (state_39767[(9)]);
var inst_39677 = (state_39767[(11)]);
var inst_39684 = (state_39767[(7)]);
var inst_39693 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_39684);
var inst_39694 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39676),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39677)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39693),"."].join('');
var state_39767__$1 = state_39767;
var statearr_39797_39835 = state_39767__$1;
(statearr_39797_39835[(2)] = inst_39694);

(statearr_39797_39835[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (9))){
var inst_39675 = (state_39767[(8)]);
var inst_39676 = (state_39767[(9)]);
var inst_39677 = (state_39767[(11)]);
var inst_39672 = (state_39767[(17)]);
var inst_39684 = (state_39767[(7)]);
var inst_39704 = (state_39767[(2)]);
var inst_39705 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_39684);
var inst_39706 = fluree.db.storage.core.reify_db(inst_39675,inst_39676,inst_39677,inst_39672,inst_39705);
var state_39767__$1 = (function (){var statearr_39798 = state_39767;
(statearr_39798[(20)] = inst_39704);

return statearr_39798;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39767__$1,(13),inst_39706);
} else {
if((state_val_39768 === (5))){
var _ = (function (){var statearr_39799 = state_39767;
(statearr_39799[(4)] = cljs.core.rest((state_39767[(4)])));

return statearr_39799;
})();
var state_39767__$1 = state_39767;
var ex39796 = (state_39767__$1[(2)]);
var statearr_39800_39836 = state_39767__$1;
(statearr_39800_39836[(5)] = ex39796);


var statearr_39801_39837 = state_39767__$1;
(statearr_39801_39837[(1)] = (4));

(statearr_39801_39837[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (14))){
var inst_39709 = (state_39767[(14)]);
var inst_39712 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_39709);
var inst_39713 = (inst_39712 + (1));
var inst_39714 = inst_39709;
var inst_39715 = inst_39713;
var state_39767__$1 = (function (){var statearr_39802 = state_39767;
(statearr_39802[(18)] = inst_39714);

(statearr_39802[(10)] = inst_39715);

return statearr_39802;
})();
var statearr_39803_39838 = state_39767__$1;
(statearr_39803_39838[(2)] = null);

(statearr_39803_39838[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (26))){
var inst_39715 = (state_39767[(10)]);
var inst_39732 = (state_39767[(2)]);
var inst_39733 = fluree.db.util.async.throw_err(inst_39732);
var inst_39734 = (inst_39715 + (1));
var inst_39714 = inst_39733;
var inst_39715__$1 = inst_39734;
var state_39767__$1 = (function (){var statearr_39804 = state_39767;
(statearr_39804[(18)] = inst_39714);

(statearr_39804[(10)] = inst_39715__$1);

return statearr_39804;
})();
var statearr_39805_39839 = state_39767__$1;
(statearr_39805_39839[(2)] = null);

(statearr_39805_39839[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (16))){
var inst_39751 = (state_39767[(13)]);
var inst_39751__$1 = (state_39767[(2)]);
var inst_39752 = fluree.db.query.schema.schema_map(inst_39751__$1);
var state_39767__$1 = (function (){var statearr_39806 = state_39767;
(statearr_39806[(13)] = inst_39751__$1);

return statearr_39806;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39767__$1,(27),inst_39752);
} else {
if((state_val_39768 === (10))){
var inst_39676 = (state_39767[(9)]);
var inst_39677 = (state_39767[(11)]);
var inst_39691 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39676),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39677)," is not found on this ledger group."].join('');
var state_39767__$1 = state_39767;
var statearr_39807_39840 = state_39767__$1;
(statearr_39807_39840[(2)] = inst_39691);

(statearr_39807_39840[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (18))){
var inst_39748 = (state_39767[(2)]);
var state_39767__$1 = state_39767;
var statearr_39808_39841 = state_39767__$1;
(statearr_39808_39841[(2)] = inst_39748);

(statearr_39808_39841[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39768 === (8))){
var state_39767__$1 = state_39767;
var statearr_39809_39842 = state_39767__$1;
(statearr_39809_39842[(2)] = null);

(statearr_39809_39842[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__10750__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__10750__auto____0 = (function (){
var statearr_39810 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39810[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__10750__auto__);

(statearr_39810[(1)] = (1));

return statearr_39810;
});
var fluree$db$session$full_load_existing_db_$_state_machine__10750__auto____1 = (function (state_39767){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_39767);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e39811){var ex__10753__auto__ = e39811;
var statearr_39812_39843 = state_39767;
(statearr_39812_39843[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_39767[(4)]))){
var statearr_39813_39844 = state_39767;
(statearr_39813_39844[(1)] = cljs.core.first((state_39767[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__39845 = state_39767;
state_39767 = G__39845;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__10750__auto__ = function(state_39767){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__10750__auto____1.call(this,state_39767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__10750__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__10750__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_39814 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_39814[(6)] = c__10876__auto___39815);

return statearr_39814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__39846 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39846,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__39846;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__39847 = cljs.core.get_global_hierarchy;
return (fexpr__39847.cljs$core$IFn$_invoke$arity$0 ? fexpr__39847.cljs$core$IFn$_invoke$arity$0() : fexpr__39847.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_ledger_DASH_update,(function (_,___$1,___$2){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_39849){
var state_val_39850 = (state_39849[(1)]);
if((state_val_39850 === (1))){
var state_39849__$1 = state_39849;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39849__$1,cljs.core.cst$kw$fluree$db$session_SLASH_no_DASH_op);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__10750__auto__ = null;
var fluree$db$session$state_machine__10750__auto____0 = (function (){
var statearr_39851 = [null,null,null,null,null,null,null];
(statearr_39851[(0)] = fluree$db$session$state_machine__10750__auto__);

(statearr_39851[(1)] = (1));

return statearr_39851;
});
var fluree$db$session$state_machine__10750__auto____1 = (function (state_39849){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_39849);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e39852){var ex__10753__auto__ = e39852;
var statearr_39853_39856 = state_39849;
(statearr_39853_39856[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_39849[(4)]))){
var statearr_39854_39857 = state_39849;
(statearr_39854_39857[(1)] = cljs.core.first((state_39849[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__39858 = state_39849;
state_39849 = G__39858;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$session$state_machine__10750__auto__ = function(state_39849){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10750__auto____1.call(this,state_39849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10750__auto____0;
fluree$db$session$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10750__auto____1;
return fluree$db$session$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_39855 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_39855[(6)] = c__10876__auto__);

return statearr_39855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__39860){
var map__39861 = p__39860;
var map__39861__$1 = cljs.core.__destructure_map(map__39861);
var data = map__39861__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39861__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39861__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39861__$1,cljs.core.cst$kw$flakes);
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_39920){
var state_val_39921 = (state_39920[(1)]);
if((state_val_39921 === (7))){
var inst_39875 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_39876 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_39877 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39875),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39876),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_39878 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39877], 0));
var state_39920__$1 = state_39920;
var statearr_39922_39960 = state_39920__$1;
(statearr_39922_39960[(2)] = inst_39878);

(statearr_39922_39960[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (1))){
var state_39920__$1 = state_39920;
var statearr_39923_39961 = state_39920__$1;
(statearr_39923_39961[(2)] = null);

(statearr_39923_39961[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (4))){
var inst_39862 = (state_39920[(2)]);
var state_39920__$1 = state_39920;
var statearr_39924_39962 = state_39920__$1;
(statearr_39924_39962[(2)] = inst_39862);

(statearr_39924_39962[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (15))){
var inst_39901 = (state_39920[(2)]);
var state_39920__$1 = state_39920;
var statearr_39925_39963 = state_39920__$1;
(statearr_39925_39963[(2)] = inst_39901);

(statearr_39925_39963[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (13))){
var inst_39892 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var inst_39893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39894 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_39895 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_39896 = [inst_39894,inst_39895];
var inst_39897 = (new cljs.core.PersistentVector(null,2,(5),inst_39893,inst_39896,null));
var inst_39898 = (function (){var G__39926 = inst_39892;
var G__39927 = cljs.core.cst$kw$local_DASH_ledger_DASH_update;
var G__39928 = inst_39897;
var G__39929 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__39926,G__39927,G__39928,G__39929) : fluree.db.conn_events.process_event.call(null,G__39926,G__39927,G__39928,G__39929));
})();
var state_39920__$1 = state_39920;
var statearr_39930_39964 = state_39920__$1;
(statearr_39930_39964[(2)] = inst_39898);

(statearr_39930_39964[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (6))){
var inst_39871 = (state_39920[(7)]);
var inst_39872 = (state_39920[(8)]);
var inst_39870 = (state_39920[(2)]);
var inst_39871__$1 = fluree.db.util.async.throw_err(inst_39870);
var inst_39872__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_39871__$1);
var inst_39873 = (block <= inst_39872__$1);
var state_39920__$1 = (function (){var statearr_39931 = state_39920;
(statearr_39931[(7)] = inst_39871__$1);

(statearr_39931[(8)] = inst_39872__$1);

return statearr_39931;
})();
if(cljs.core.truth_(inst_39873)){
var statearr_39932_39965 = state_39920__$1;
(statearr_39932_39965[(1)] = (7));

} else {
var statearr_39933_39966 = state_39920__$1;
(statearr_39933_39966[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (17))){
var state_39920__$1 = state_39920;
var statearr_39934_39967 = state_39920__$1;
(statearr_39934_39967[(2)] = null);

(statearr_39934_39967[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (3))){
var inst_39918 = (state_39920[(2)]);
var state_39920__$1 = state_39920;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39920__$1,inst_39918);
} else {
if((state_val_39921 === (12))){
var inst_39913 = (state_39920[(2)]);
var state_39920__$1 = state_39920;
var statearr_39935_39968 = state_39920__$1;
(statearr_39935_39968[(2)] = inst_39913);

(statearr_39935_39968[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (2))){
var inst_39868 = (state_39920[(9)]);
var _ = (function (){var statearr_39936 = state_39920;
(statearr_39936[(4)] = cljs.core.cons((5),(state_39920[(4)])));

return statearr_39936;
})();
var inst_39868__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_39920__$1 = (function (){var statearr_39937 = state_39920;
(statearr_39937[(9)] = inst_39868__$1);

return statearr_39937;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39920__$1,(6),inst_39868__$1);
} else {
if((state_val_39921 === (11))){
var state_39920__$1 = state_39920;
var statearr_39939_39969 = state_39920__$1;
(statearr_39939_39969[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (9))){
var inst_39915 = (state_39920[(2)]);
var _ = (function (){var statearr_39941 = state_39920;
(statearr_39941[(4)] = cljs.core.rest((state_39920[(4)])));

return statearr_39941;
})();
var state_39920__$1 = state_39920;
var statearr_39942_39970 = state_39920__$1;
(statearr_39942_39970[(2)] = inst_39915);

(statearr_39942_39970[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (5))){
var _ = (function (){var statearr_39943 = state_39920;
(statearr_39943[(4)] = cljs.core.rest((state_39920[(4)])));

return statearr_39943;
})();
var state_39920__$1 = state_39920;
var ex39938 = (state_39920__$1[(2)]);
var statearr_39944_39971 = state_39920__$1;
(statearr_39944_39971[(5)] = ex39938);


if((ex39938 instanceof Error)){
var statearr_39945_39972 = state_39920__$1;
(statearr_39945_39972[(1)] = (4));

(statearr_39945_39972[(5)] = null);

} else {
throw ex39938;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (14))){
var state_39920__$1 = state_39920;
var statearr_39946_39973 = state_39920__$1;
(statearr_39946_39973[(2)] = null);

(statearr_39946_39973[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (16))){
var inst_39872 = (state_39920[(8)]);
var inst_39904 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_39905 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_39906 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39904),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39905),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39872),". Forcing a db reload."].join('');
var inst_39907 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39906], 0));
var inst_39908 = fluree.db.session.reload_db_BANG_(session);
var state_39920__$1 = (function (){var statearr_39947 = state_39920;
(statearr_39947[(10)] = inst_39907);

return statearr_39947;
})();
var statearr_39948_39974 = state_39920__$1;
(statearr_39948_39974[(2)] = inst_39908);

(statearr_39948_39974[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (10))){
var inst_39871 = (state_39920[(7)]);
var inst_39868 = (state_39920[(9)]);
var inst_39872 = (state_39920[(8)]);
var inst_39883 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_39884 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_39885 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39883),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39884),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_39886 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39885], 0));
var inst_39887 = (function (){var current_db_ch = inst_39868;
var current_db = inst_39871;
var current_block = inst_39872;
return (function (p1__39859_SHARP_){
if((p1__39859_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__39859_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__39859_SHARP_);
}
});
})();
var inst_39888 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39887,flakes);
var inst_39889 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_39871,block,inst_39888);
var inst_39890 = fluree.db.session.cas_db_BANG_(session,inst_39868,inst_39889);
var state_39920__$1 = (function (){var statearr_39949 = state_39920;
(statearr_39949[(11)] = inst_39886);

return statearr_39949;
})();
if(inst_39890){
var statearr_39950_39975 = state_39920__$1;
(statearr_39950_39975[(1)] = (13));

} else {
var statearr_39951_39976 = state_39920__$1;
(statearr_39951_39976[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (18))){
var inst_39911 = (state_39920[(2)]);
var state_39920__$1 = state_39920;
var statearr_39952_39977 = state_39920__$1;
(statearr_39952_39977[(2)] = inst_39911);

(statearr_39952_39977[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39921 === (8))){
var inst_39872 = (state_39920[(8)]);
var inst_39880 = ((1) + inst_39872);
var inst_39881 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_39880);
var state_39920__$1 = state_39920;
if(inst_39881){
var statearr_39953_39978 = state_39920__$1;
(statearr_39953_39978[(1)] = (10));

} else {
var statearr_39954_39979 = state_39920__$1;
(statearr_39954_39979[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__10750__auto__ = null;
var fluree$db$session$state_machine__10750__auto____0 = (function (){
var statearr_39955 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39955[(0)] = fluree$db$session$state_machine__10750__auto__);

(statearr_39955[(1)] = (1));

return statearr_39955;
});
var fluree$db$session$state_machine__10750__auto____1 = (function (state_39920){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_39920);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e39956){var ex__10753__auto__ = e39956;
var statearr_39957_39980 = state_39920;
(statearr_39957_39980[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_39920[(4)]))){
var statearr_39958_39981 = state_39920;
(statearr_39958_39981[(1)] = cljs.core.first((state_39920[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__39982 = state_39920;
state_39920 = G__39982;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$session$state_machine__10750__auto__ = function(state_39920){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10750__auto____1.call(this,state_39920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10750__auto____0;
fluree$db$session$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10750__auto____1;
return fluree$db$session$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_39959 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_39959[(6)] = c__10876__auto__);

return statearr_39959;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_39989){
var state_val_39990 = (state_39989[(1)]);
if((state_val_39990 === (1))){
var inst_39983 = fluree.db.session.clear_db_BANG_(session);
var inst_39984 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_39985 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_39986 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39984),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39985)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_39987 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39986], 0));
var state_39989__$1 = (function (){var statearr_39991 = state_39989;
(statearr_39991[(7)] = inst_39983);

(statearr_39991[(8)] = inst_39987);

return statearr_39991;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_39989__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__10750__auto__ = null;
var fluree$db$session$state_machine__10750__auto____0 = (function (){
var statearr_39992 = [null,null,null,null,null,null,null,null,null];
(statearr_39992[(0)] = fluree$db$session$state_machine__10750__auto__);

(statearr_39992[(1)] = (1));

return statearr_39992;
});
var fluree$db$session$state_machine__10750__auto____1 = (function (state_39989){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_39989);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e39993){var ex__10753__auto__ = e39993;
var statearr_39994_39997 = state_39989;
(statearr_39994_39997[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_39989[(4)]))){
var statearr_39995_39998 = state_39989;
(statearr_39995_39998[(1)] = cljs.core.first((state_39989[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__39999 = state_39989;
state_39989 = G__39999;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$session$state_machine__10750__auto__ = function(state_39989){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10750__auto____1.call(this,state_39989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10750__auto____0;
fluree$db$session$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10750__auto____1;
return fluree$db$session$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_39996 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_39996[(6)] = c__10876__auto__);

return statearr_39996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__40001 = arguments.length;
switch (G__40001) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__40002 = session;
var map__40002__$1 = cljs.core.__destructure_map(map__40002);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40002__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40002__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40002__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40002__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40002__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40002__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40002__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__40003_40006 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__40003_40006.cljs$core$IFn$_invoke$arity$3 ? fexpr__40003_40006.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__40003_40006.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__40004_40007 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__40004_40007.cljs$core$IFn$_invoke$arity$0 ? fexpr__40004_40007.cljs$core$IFn$_invoke$arity$0() : fexpr__40004_40007.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_40060){
var state_val_40061 = (state_40060[(1)]);
if((state_val_40061 === (7))){
var inst_40056 = (state_40060[(2)]);
var state_40060__$1 = state_40060;
var statearr_40062_40093 = state_40060__$1;
(statearr_40062_40093[(2)] = inst_40056);

(statearr_40062_40093[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (1))){
var state_40060__$1 = state_40060;
var statearr_40063_40094 = state_40060__$1;
(statearr_40063_40094[(2)] = null);

(statearr_40063_40094[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (4))){
var inst_40011 = (state_40060[(7)]);
var inst_40010 = (state_40060[(2)]);
var inst_40011__$1 = fluree.db.util.async.throw_err(inst_40010);
var inst_40012 = fluree.db.session.from_cache(network,ledger_id);
var inst_40013 = (inst_40011__$1 == null);
var state_40060__$1 = (function (){var statearr_40064 = state_40060;
(statearr_40064[(8)] = inst_40012);

(statearr_40064[(7)] = inst_40011__$1);

return statearr_40064;
})();
if(cljs.core.truth_(inst_40013)){
var statearr_40065_40095 = state_40060__$1;
(statearr_40065_40095[(1)] = (5));

} else {
var statearr_40066_40096 = state_40060__$1;
(statearr_40066_40096[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (15))){
var inst_40048 = (state_40060[(2)]);
var state_40060__$1 = (function (){var statearr_40067 = state_40060;
(statearr_40067[(9)] = inst_40048);

return statearr_40067;
})();
var statearr_40068_40097 = state_40060__$1;
(statearr_40068_40097[(2)] = null);

(statearr_40068_40097[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (13))){
var inst_40052 = (state_40060[(2)]);
var state_40060__$1 = state_40060;
var statearr_40070_40098 = state_40060__$1;
(statearr_40070_40098[(2)] = inst_40052);

(statearr_40070_40098[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (6))){
var inst_40012 = (state_40060[(8)]);
var inst_40018 = (inst_40012 == null);
var state_40060__$1 = state_40060;
if(cljs.core.truth_(inst_40018)){
var statearr_40071_40099 = state_40060__$1;
(statearr_40071_40099[(1)] = (8));

} else {
var statearr_40072_40100 = state_40060__$1;
(statearr_40072_40100[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (17))){
var _ = (function (){var statearr_40073 = state_40060;
(statearr_40073[(4)] = cljs.core.rest((state_40060[(4)])));

return statearr_40073;
})();
var state_40060__$1 = state_40060;
var ex40069 = (state_40060__$1[(2)]);
var statearr_40074_40101 = state_40060__$1;
(statearr_40074_40101[(5)] = ex40069);


var statearr_40075_40102 = state_40060__$1;
(statearr_40075_40102[(1)] = (16));

(statearr_40075_40102[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (3))){
var inst_40058 = (state_40060[(2)]);
var state_40060__$1 = state_40060;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40060__$1,inst_40058);
} else {
if((state_val_40061 === (12))){
var state_40060__$1 = state_40060;
var statearr_40076_40103 = state_40060__$1;
(statearr_40076_40103[(2)] = null);

(statearr_40076_40103[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (2))){
var state_40060__$1 = state_40060;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40060__$1,(4),update_chan);
} else {
if((state_val_40061 === (11))){
var state_40060__$1 = state_40060;
var statearr_40077_40104 = state_40060__$1;
(statearr_40077_40104[(2)] = null);

(statearr_40077_40104[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (9))){
var state_40060__$1 = state_40060;
var statearr_40078_40105 = state_40060__$1;
(statearr_40078_40105[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (5))){
var inst_40015 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_40016 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40015], 0));
var state_40060__$1 = state_40060;
var statearr_40080_40106 = state_40060__$1;
(statearr_40080_40106[(2)] = inst_40016);

(statearr_40080_40106[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (14))){
var inst_40012 = (state_40060[(8)]);
var inst_40011 = (state_40060[(7)]);
var _ = (function (){var statearr_40081 = state_40060;
(statearr_40081[(4)] = cljs.core.cons((17),(state_40060[(4)])));

return statearr_40081;
})();
var inst_40036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40011,(0),null);
var inst_40037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40011,(1),null);
var inst_40038 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_40039 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40011], 0));
var inst_40040 = fluree.db.util.core.trunc(inst_40039,(200));
var inst_40041 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40038,inst_40040], 0));
var inst_40042 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_40012,inst_40036,inst_40037) : fluree.db.session.process_ledger_update.call(null,inst_40012,inst_40036,inst_40037));
var state_40060__$1 = (function (){var statearr_40082 = state_40060;
(statearr_40082[(10)] = inst_40041);

return statearr_40082;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40060__$1,(18),inst_40042);
} else {
if((state_val_40061 === (16))){
var inst_40011 = (state_40060[(7)]);
var inst_40026 = (state_40060[(2)]);
var inst_40027 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40026,"Exception processing ledger updates for message: ",inst_40011], 0));
var state_40060__$1 = state_40060;
var statearr_40083_40107 = state_40060__$1;
(statearr_40083_40107[(2)] = inst_40027);

(statearr_40083_40107[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (10))){
var inst_40054 = (state_40060[(2)]);
var state_40060__$1 = state_40060;
var statearr_40084_40108 = state_40060__$1;
(statearr_40084_40108[(2)] = inst_40054);

(statearr_40084_40108[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (18))){
var inst_40044 = (state_40060[(2)]);
var inst_40045 = fluree.db.util.async.throw_err(inst_40044);
var _ = (function (){var statearr_40085 = state_40060;
(statearr_40085[(4)] = cljs.core.rest((state_40060[(4)])));

return statearr_40085;
})();
var state_40060__$1 = state_40060;
var statearr_40086_40109 = state_40060__$1;
(statearr_40086_40109[(2)] = inst_40045);

(statearr_40086_40109[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40061 === (8))){
var inst_40011 = (state_40060[(7)]);
var inst_40020 = cljs.core.first(inst_40011);
var inst_40021 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40020], 0));
var inst_40022 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_40021].join('');
var inst_40023 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40022], 0));
var state_40060__$1 = state_40060;
var statearr_40087_40110 = state_40060__$1;
(statearr_40087_40110[(2)] = inst_40023);

(statearr_40087_40110[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__10750__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__10750__auto____0 = (function (){
var statearr_40088 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40088[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__10750__auto__);

(statearr_40088[(1)] = (1));

return statearr_40088;
});
var fluree$db$session$process_ledger_updates_$_state_machine__10750__auto____1 = (function (state_40060){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_40060);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e40089){var ex__10753__auto__ = e40089;
var statearr_40090_40111 = state_40060;
(statearr_40090_40111[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_40060[(4)]))){
var statearr_40091_40112 = state_40060;
(statearr_40091_40112[(1)] = cljs.core.first((state_40060[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__40113 = state_40060;
state_40060 = G__40113;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__10750__auto__ = function(state_40060){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__10750__auto____1.call(this,state_40060);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__10750__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__10750__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_40092 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_40092[(6)] = c__10876__auto__);

return statearr_40092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__40114){
var map__40115 = p__40114;
var map__40115__$1 = cljs.core.__destructure_map(map__40115);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40115__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40115__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40115__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40115__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40115__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40115__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40115__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40115__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40115__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__40119 = block_result;
var map__40119__$1 = cljs.core.__destructure_map(map__40119);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40119__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40119__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40119__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40119__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40119__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__40120 = tx_result;
var map__40120__$1 = cljs.core.__destructure_map(map__40120);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40120__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40120__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__40116_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__40116_SHARP_.t);
}):(function (p1__40117_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40117_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__40118_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__40118_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40118_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__40121 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40121,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40121,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40121,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40121,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__40125 = arguments.length;
switch (G__40125) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__40126){
var map__40127 = p__40126;
var map__40127__$1 = cljs.core.__destructure_map(map__40127);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40127__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40127__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40127__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40127__$1,cljs.core.cst$kw$jwt);
var vec__40128 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40128,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40128,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40128,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4212__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4212__auto____$1 = state;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__40132_40252 = network;
var G__40133_40253 = ledger_id;
var G__40134_40254 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__40135_40255 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__40136 = cljs.core.seq(tids);
var chunk__40137 = null;
var count__40138 = (0);
var i__40139 = (0);
while(true){
if((i__40139 < count__40138)){
var tid = chunk__40137.cljs$core$IIndexed$_nth$arity$2(null,i__40139);
var temp__5753__auto___40257__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___40257__$1)){
var keyed_callbacks_40258 = temp__5753__auto___40257__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_40259 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__40180_40260 = cljs.core.seq(keyed_callbacks_40258);
var chunk__40181_40261 = null;
var count__40182_40262 = (0);
var i__40183_40263 = (0);
while(true){
if((i__40183_40263 < count__40182_40262)){
var vec__40192_40264 = chunk__40181_40261.cljs$core$IIndexed$_nth$arity$2(null,i__40183_40263);
var k_40265 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40192_40264,(0),null);
var f_40266 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40192_40264,(1),null);
try{(f_40266.cljs$core$IFn$_invoke$arity$1 ? f_40266.cljs$core$IFn$_invoke$arity$1(tx_response_40259) : f_40266.call(null,tx_response_40259));
}catch (e40195){var e_40267 = e40195;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_40267,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__40268 = seq__40180_40260;
var G__40269 = chunk__40181_40261;
var G__40270 = count__40182_40262;
var G__40271 = (i__40183_40263 + (1));
seq__40180_40260 = G__40268;
chunk__40181_40261 = G__40269;
count__40182_40262 = G__40270;
i__40183_40263 = G__40271;
continue;
} else {
var temp__5753__auto___40272__$2 = cljs.core.seq(seq__40180_40260);
if(temp__5753__auto___40272__$2){
var seq__40180_40273__$1 = temp__5753__auto___40272__$2;
if(cljs.core.chunked_seq_QMARK_(seq__40180_40273__$1)){
var c__4638__auto___40274 = cljs.core.chunk_first(seq__40180_40273__$1);
var G__40275 = cljs.core.chunk_rest(seq__40180_40273__$1);
var G__40276 = c__4638__auto___40274;
var G__40277 = cljs.core.count(c__4638__auto___40274);
var G__40278 = (0);
seq__40180_40260 = G__40275;
chunk__40181_40261 = G__40276;
count__40182_40262 = G__40277;
i__40183_40263 = G__40278;
continue;
} else {
var vec__40196_40279 = cljs.core.first(seq__40180_40273__$1);
var k_40280 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40196_40279,(0),null);
var f_40281 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40196_40279,(1),null);
try{(f_40281.cljs$core$IFn$_invoke$arity$1 ? f_40281.cljs$core$IFn$_invoke$arity$1(tx_response_40259) : f_40281.call(null,tx_response_40259));
}catch (e40199){var e_40282 = e40199;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_40282,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__40283 = cljs.core.next(seq__40180_40273__$1);
var G__40284 = null;
var G__40285 = (0);
var G__40286 = (0);
seq__40180_40260 = G__40283;
chunk__40181_40261 = G__40284;
count__40182_40262 = G__40285;
i__40183_40263 = G__40286;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__40287 = seq__40136;
var G__40288 = chunk__40137;
var G__40289 = count__40138;
var G__40290 = (i__40139 + (1));
seq__40136 = G__40287;
chunk__40137 = G__40288;
count__40138 = G__40289;
i__40139 = G__40290;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__40136);
if(temp__5753__auto____$1){
var seq__40136__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__40136__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__40136__$1);
var G__40291 = cljs.core.chunk_rest(seq__40136__$1);
var G__40292 = c__4638__auto__;
var G__40293 = cljs.core.count(c__4638__auto__);
var G__40294 = (0);
seq__40136 = G__40291;
chunk__40137 = G__40292;
count__40138 = G__40293;
i__40139 = G__40294;
continue;
} else {
var tid = cljs.core.first(seq__40136__$1);
var temp__5753__auto___40295__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___40295__$2)){
var keyed_callbacks_40296 = temp__5753__auto___40295__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_40297 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__40200_40298 = cljs.core.seq(keyed_callbacks_40296);
var chunk__40201_40299 = null;
var count__40202_40300 = (0);
var i__40203_40301 = (0);
while(true){
if((i__40203_40301 < count__40202_40300)){
var vec__40212_40302 = chunk__40201_40299.cljs$core$IIndexed$_nth$arity$2(null,i__40203_40301);
var k_40303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40212_40302,(0),null);
var f_40304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40212_40302,(1),null);
try{(f_40304.cljs$core$IFn$_invoke$arity$1 ? f_40304.cljs$core$IFn$_invoke$arity$1(tx_response_40297) : f_40304.call(null,tx_response_40297));
}catch (e40215){var e_40305 = e40215;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_40305,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__40306 = seq__40200_40298;
var G__40307 = chunk__40201_40299;
var G__40308 = count__40202_40300;
var G__40309 = (i__40203_40301 + (1));
seq__40200_40298 = G__40306;
chunk__40201_40299 = G__40307;
count__40202_40300 = G__40308;
i__40203_40301 = G__40309;
continue;
} else {
var temp__5753__auto___40310__$3 = cljs.core.seq(seq__40200_40298);
if(temp__5753__auto___40310__$3){
var seq__40200_40311__$1 = temp__5753__auto___40310__$3;
if(cljs.core.chunked_seq_QMARK_(seq__40200_40311__$1)){
var c__4638__auto___40312 = cljs.core.chunk_first(seq__40200_40311__$1);
var G__40313 = cljs.core.chunk_rest(seq__40200_40311__$1);
var G__40314 = c__4638__auto___40312;
var G__40315 = cljs.core.count(c__4638__auto___40312);
var G__40316 = (0);
seq__40200_40298 = G__40313;
chunk__40201_40299 = G__40314;
count__40202_40300 = G__40315;
i__40203_40301 = G__40316;
continue;
} else {
var vec__40216_40317 = cljs.core.first(seq__40200_40311__$1);
var k_40318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40216_40317,(0),null);
var f_40319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40216_40317,(1),null);
try{(f_40319.cljs$core$IFn$_invoke$arity$1 ? f_40319.cljs$core$IFn$_invoke$arity$1(tx_response_40297) : f_40319.call(null,tx_response_40297));
}catch (e40219){var e_40320 = e40219;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_40320,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__40321 = cljs.core.next(seq__40200_40311__$1);
var G__40322 = null;
var G__40323 = (0);
var G__40324 = (0);
seq__40200_40298 = G__40321;
chunk__40201_40299 = G__40322;
count__40202_40300 = G__40323;
i__40203_40301 = G__40324;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__40325 = cljs.core.next(seq__40136__$1);
var G__40326 = null;
var G__40327 = (0);
var G__40328 = (0);
seq__40136 = G__40325;
chunk__40137 = G__40326;
count__40138 = G__40327;
i__40139 = G__40328;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__40131_40256 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__40131_40256.cljs$core$IFn$_invoke$arity$4 ? fexpr__40131_40256.cljs$core$IFn$_invoke$arity$4(G__40132_40252,G__40133_40253,G__40134_40254,G__40135_40255) : fexpr__40131_40256.call(null,G__40132_40252,G__40133_40253,G__40134_40254,G__40135_40255));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_40329 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__10876__auto___40330 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_40236){
var state_val_40237 = (state_40236[(1)]);
if((state_val_40237 === (1))){
var state_40236__$1 = state_40236;
var statearr_40238_40331 = state_40236__$1;
(statearr_40238_40331[(2)] = null);

(statearr_40238_40331[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40237 === (2))){
var inst_40221 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_40236__$1 = state_40236;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40236__$1,(4),inst_40221);
} else {
if((state_val_40237 === (3))){
var inst_40234 = (state_40236[(2)]);
var state_40236__$1 = state_40236;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40236__$1,inst_40234);
} else {
if((state_val_40237 === (4))){
var inst_40223 = (state_40236[(7)]);
var inst_40223__$1 = (state_40236[(2)]);
var inst_40224 = (inst_40223__$1 == null);
var state_40236__$1 = (function (){var statearr_40239 = state_40236;
(statearr_40239[(7)] = inst_40223__$1);

return statearr_40239;
})();
if(cljs.core.truth_(inst_40224)){
var statearr_40240_40332 = state_40236__$1;
(statearr_40240_40332[(1)] = (5));

} else {
var statearr_40241_40333 = state_40236__$1;
(statearr_40241_40333[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40237 === (5))){
var inst_40226 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_40227 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40226], 0));
var state_40236__$1 = state_40236;
var statearr_40242_40334 = state_40236__$1;
(statearr_40242_40334[(2)] = inst_40227);

(statearr_40242_40334[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40237 === (6))){
var inst_40223 = (state_40236[(7)]);
var inst_40229 = (transact_handler_40329.cljs$core$IFn$_invoke$arity$2 ? transact_handler_40329.cljs$core$IFn$_invoke$arity$2(conn,inst_40223) : transact_handler_40329.call(null,conn,inst_40223));
var state_40236__$1 = (function (){var statearr_40243 = state_40236;
(statearr_40243[(8)] = inst_40229);

return statearr_40243;
})();
var statearr_40244_40335 = state_40236__$1;
(statearr_40244_40335[(2)] = null);

(statearr_40244_40335[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40237 === (7))){
var inst_40232 = (state_40236[(2)]);
var state_40236__$1 = state_40236;
var statearr_40245_40336 = state_40236__$1;
(statearr_40245_40336[(2)] = inst_40232);

(statearr_40245_40336[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__10750__auto__ = null;
var fluree$db$session$state_machine__10750__auto____0 = (function (){
var statearr_40246 = [null,null,null,null,null,null,null,null,null];
(statearr_40246[(0)] = fluree$db$session$state_machine__10750__auto__);

(statearr_40246[(1)] = (1));

return statearr_40246;
});
var fluree$db$session$state_machine__10750__auto____1 = (function (state_40236){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_40236);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e40247){var ex__10753__auto__ = e40247;
var statearr_40248_40337 = state_40236;
(statearr_40248_40337[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_40236[(4)]))){
var statearr_40249_40338 = state_40236;
(statearr_40249_40338[(1)] = cljs.core.first((state_40236[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__40339 = state_40236;
state_40236 = G__40339;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$session$state_machine__10750__auto__ = function(state_40236){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10750__auto____1.call(this,state_40236);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10750__auto____0;
fluree$db$session$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10750__auto____1;
return fluree$db$session$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_40250 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_40250[(6)] = c__10876__auto___40330);

return statearr_40250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__40340_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__40340_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__40340_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__40341_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__40341_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
}));

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__40344 = arguments.length;
switch (G__40344) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__40345 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__40342_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__40342_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__40345);
} else {
return G__40345;
}
})();
var seq__40346 = cljs.core.seq(sessions);
var chunk__40347 = null;
var count__40348 = (0);
var i__40349 = (0);
while(true){
if((i__40349 < count__40348)){
var session = chunk__40347.cljs$core$IIndexed$_nth$arity$2(null,i__40349);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__40351 = seq__40346;
var G__40352 = chunk__40347;
var G__40353 = count__40348;
var G__40354 = (i__40349 + (1));
seq__40346 = G__40351;
chunk__40347 = G__40352;
count__40348 = G__40353;
i__40349 = G__40354;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__40346);
if(temp__5753__auto__){
var seq__40346__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40346__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__40346__$1);
var G__40355 = cljs.core.chunk_rest(seq__40346__$1);
var G__40356 = c__4638__auto__;
var G__40357 = cljs.core.count(c__4638__auto__);
var G__40358 = (0);
seq__40346 = G__40355;
chunk__40347 = G__40356;
count__40348 = G__40357;
i__40349 = G__40358;
continue;
} else {
var session = cljs.core.first(seq__40346__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__40359 = cljs.core.next(seq__40346__$1);
var G__40360 = null;
var G__40361 = (0);
var G__40362 = (0);
seq__40346 = G__40359;
chunk__40347 = G__40360;
count__40348 = G__40361;
i__40349 = G__40362;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
