// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__30600 = arguments.length;
switch (G__30600) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__30603 = arguments.length;
switch (G__30603) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10876__auto___30656 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_30634){
var state_val_30635 = (state_30634[(1)]);
if((state_val_30635 === (1))){
var state_30634__$1 = state_30634;
var statearr_30636_30657 = state_30634__$1;
(statearr_30636_30657[(2)] = null);

(statearr_30636_30657[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30635 === (2))){
var _ = (function (){var statearr_30637 = state_30634;
(statearr_30637[(4)] = cljs.core.cons((5),(state_30634[(4)])));

return statearr_30637;
})();
var inst_30611 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_30634__$1 = state_30634;
if(cljs.core.truth_(inst_30611)){
var statearr_30638_30658 = state_30634__$1;
(statearr_30638_30658[(1)] = (6));

} else {
var statearr_30639_30659 = state_30634__$1;
(statearr_30639_30659[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30635 === (3))){
var inst_30632 = (state_30634[(2)]);
var state_30634__$1 = state_30634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30634__$1,inst_30632);
} else {
if((state_val_30635 === (4))){
var inst_30604 = (state_30634[(2)]);
var inst_30605 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_30604);
var state_30634__$1 = state_30634;
var statearr_30641_30660 = state_30634__$1;
(statearr_30641_30660[(2)] = inst_30605);

(statearr_30641_30660[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30635 === (5))){
var _ = (function (){var statearr_30642 = state_30634;
(statearr_30642[(4)] = cljs.core.rest((state_30634[(4)])));

return statearr_30642;
})();
var state_30634__$1 = state_30634;
var ex30640 = (state_30634__$1[(2)]);
var statearr_30643_30661 = state_30634__$1;
(statearr_30643_30661[(5)] = ex30640);


var statearr_30644_30662 = state_30634__$1;
(statearr_30644_30662[(1)] = (4));

(statearr_30644_30662[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_30635 === (6))){
var inst_30613 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30614 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_30615 = cljs.core.PersistentHashMap.fromArrays(inst_30613,inst_30614);
var inst_30616 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_30615);
var inst_30617 = (function(){throw inst_30616})();
var state_30634__$1 = state_30634;
var statearr_30645_30663 = state_30634__$1;
(statearr_30645_30663[(2)] = inst_30617);

(statearr_30645_30663[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30635 === (7))){
var inst_30619 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_30620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30621 = [operation,data,pc,opts];
var inst_30622 = (new cljs.core.PersistentVector(null,4,(5),inst_30620,inst_30621,null));
var inst_30623 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_30619,inst_30622);
var inst_30624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30625 = [operation,data,pc,opts];
var inst_30626 = (new cljs.core.PersistentVector(null,4,(5),inst_30624,inst_30625,null));
var inst_30627 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_30626], 0));
var state_30634__$1 = (function (){var statearr_30646 = state_30634;
(statearr_30646[(7)] = inst_30623);

return statearr_30646;
})();
var statearr_30647_30664 = state_30634__$1;
(statearr_30647_30664[(2)] = inst_30627);

(statearr_30647_30664[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30635 === (8))){
var inst_30629 = (state_30634[(2)]);
var _ = (function (){var statearr_30648 = state_30634;
(statearr_30648[(4)] = cljs.core.rest((state_30634[(4)])));

return statearr_30648;
})();
var state_30634__$1 = state_30634;
var statearr_30649_30665 = state_30634__$1;
(statearr_30649_30665[(2)] = inst_30629);

(statearr_30649_30665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__10750__auto__ = null;
var fluree$db$operations$state_machine__10750__auto____0 = (function (){
var statearr_30650 = [null,null,null,null,null,null,null,null];
(statearr_30650[(0)] = fluree$db$operations$state_machine__10750__auto__);

(statearr_30650[(1)] = (1));

return statearr_30650;
});
var fluree$db$operations$state_machine__10750__auto____1 = (function (state_30634){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_30634);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e30651){var ex__10753__auto__ = e30651;
var statearr_30652_30666 = state_30634;
(statearr_30652_30666[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_30634[(4)]))){
var statearr_30653_30667 = state_30634;
(statearr_30653_30667[(1)] = cljs.core.first((state_30634[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__30668 = state_30634;
state_30634 = G__30668;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$operations$state_machine__10750__auto__ = function(state_30634){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__10750__auto____1.call(this,state_30634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__10750__auto____0;
fluree$db$operations$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__10750__auto____1;
return fluree$db$operations$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_30654 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_30654[(6)] = c__10876__auto___30656);

return statearr_30654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__30670 = arguments.length;
switch (G__30670) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__30671){
var map__30672 = p__30671;
var map__30672__$1 = cljs.core.__destructure_map(map__30672);
var opts = map__30672__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30672__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__30673 = session;
var map__30673__$1 = cljs.core.__destructure_map(map__30673);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30673__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30673__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30673__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4824__auto__ = [];
var len__4818__auto___30700 = arguments.length;
var i__4819__auto___30701 = (0);
while(true){
if((i__4819__auto___30701 < len__4818__auto___30700)){
args__4824__auto__.push((arguments[i__4819__auto___30701]));

var G__30702 = (i__4819__auto___30701 + (1));
i__4819__auto___30701 = G__30702;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__30677){
var vec__30678 = p__30677;
var map__30681 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30678,(0),null);
var map__30681__$1 = cljs.core.__destructure_map(map__30681);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30681__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30681__$1,cljs.core.cst$kw$toTime);
var opts = vec__30678;
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_30693){
var state_val_30694 = (state_30693[(1)]);
if((state_val_30694 === (1))){
var inst_30683 = session;
var inst_30684 = cljs.core.__destructure_map(inst_30683);
var inst_30685 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30684,cljs.core.cst$kw$network);
var inst_30686 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30684,cljs.core.cst$kw$dbid);
var inst_30687 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30684,cljs.core.cst$kw$conn);
var inst_30688 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_30689 = [inst_30685,inst_30686,toBlock,toTime];
var inst_30690 = cljs.core.PersistentHashMap.fromArrays(inst_30688,inst_30689);
var inst_30691 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_30687,cljs.core.cst$kw$garbage,inst_30690);
var state_30693__$1 = state_30693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30693__$1,inst_30691);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__10750__auto__ = null;
var fluree$db$operations$state_machine__10750__auto____0 = (function (){
var statearr_30695 = [null,null,null,null,null,null,null];
(statearr_30695[(0)] = fluree$db$operations$state_machine__10750__auto__);

(statearr_30695[(1)] = (1));

return statearr_30695;
});
var fluree$db$operations$state_machine__10750__auto____1 = (function (state_30693){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_30693);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e30696){var ex__10753__auto__ = e30696;
var statearr_30697_30703 = state_30693;
(statearr_30697_30703[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_30693[(4)]))){
var statearr_30698_30704 = state_30693;
(statearr_30698_30704[(1)] = cljs.core.first((state_30693[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__30705 = state_30693;
state_30693 = G__30705;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$operations$state_machine__10750__auto__ = function(state_30693){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__10750__auto____1.call(this,state_30693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__10750__auto____0;
fluree$db$operations$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__10750__auto____1;
return fluree$db$operations$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_30699 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_30699[(6)] = c__10876__auto__);

return statearr_30699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq30675){
var G__30676 = cljs.core.first(seq30675);
var seq30675__$1 = cljs.core.next(seq30675);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30676,seq30675__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__30706 = session;
var map__30706__$1 = cljs.core.__destructure_map(map__30706);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30706__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30706__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30706__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__30708 = arguments.length;
switch (G__30708) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__30709 = opts;
var map__30709__$1 = cljs.core.__destructure_map(map__30709);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30709__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30709__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4212__auto__ = auth;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
