// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
/**
 * Returns an empty TTL cache for db-function caching.
 *   Implication of this caching strategy is changes to db functions that get
 *   update will take 5 seconds to recompile, benefit is that the same function
 *   call for a ledger will not have to recompile every time.
 */
fluree.db.dbfunctions.core.db_fn_cache_factory = (function fluree$db$dbfunctions$core$db_fn_cache_factory(){
return cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ttl,(5000)], 0));
});
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.dbfunctions.core.db_fn_cache_factory());
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,fluree.db.dbfunctions.core.db_fn_cache_factory());
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__4210__auto__ = typeof value === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__4210__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$cas,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$subs,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,302,null,302,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,715,null,715,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,232,null,232,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_cas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$cas,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,813,null,813,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$compare_DASH_val,cljs.core.cst$sym$new_DASH_val], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,522,null,522,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,428,null,428,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,389,null,389,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,258,null,258,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,727,null,727,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,534,null,534,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,608,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,621,null,621,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,751,null,751,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,171,null,171,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,779,null,779,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,697,null,697,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,415,null,415,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,376,null,376,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,467,null,467,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,789,null,789,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,190,null,190,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,569,null,569,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,376,null,376,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,660,null,660,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,454,null,454,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,595,null,595,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,507,null,507,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,334,null,334,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Returns the value of a nested structure",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null),"Length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,559,null,559,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,546,null,546,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,801,null,801,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not_EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,441,null,441,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,272,null,272,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,402,null,402,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,582,null,582,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,763,null,763,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,348,null,348,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns true if key is present.",(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,362,null,362,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns a hash-set of values",(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null),"9 + count of items in hash-set"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,685,null,685,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,216,null,216,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,60,null,60,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_subs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$subs,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,634,null,634,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,203,null,203,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,647,null,647,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,480,null,480,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,290,null,290,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,739,null,739,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,245,null,245,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,672,null,672,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__68500 = cljs.core.meta(f);
var map__68500__$1 = cljs.core.__destructure_map(map__68500);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68500__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68500__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4210__auto__ = (function (){var G__68502 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__68501 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__68501.cljs$core$IFn$_invoke$arity$1 ? fexpr__68501.cljs$core$IFn$_invoke$arity$1(G__68502) : fexpr__68501.call(null,G__68502));
})();
if(cljs.core.truth_(and__4210__auto__)){
var G__68504 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__68503 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__68503.cljs$core$IFn$_invoke$arity$1 ? fexpr__68503.cljs$core$IFn$_invoke$arity$1(G__68504) : fexpr__68503.call(null,G__68504));
} else {
return and__4210__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__68499_SHARP_){
return (cljs.core.count(p1__68499_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_fn,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_68589){
var state_val_68590 = (state_68589[(1)]);
if((state_val_68590 === (7))){
var inst_68514 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_68515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68516 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_68517 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_68518 = [fn_name,inst_68516,inst_68517];
var inst_68519 = (new cljs.core.PersistentVector(null,3,(5),inst_68515,inst_68518,null));
var inst_68520 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68514,inst_68519);
var state_68589__$1 = state_68589;
var statearr_68591_68628 = state_68589__$1;
(statearr_68591_68628[(2)] = inst_68520);

(statearr_68591_68628[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (1))){
var state_68589__$1 = state_68589;
var statearr_68592_68629 = state_68589__$1;
(statearr_68592_68629[(2)] = null);

(statearr_68592_68629[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (4))){
var inst_68505 = (state_68589[(2)]);
var state_68589__$1 = state_68589;
var statearr_68593_68630 = state_68589__$1;
(statearr_68593_68630[(2)] = inst_68505);

(statearr_68593_68630[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (15))){
var inst_68538 = (state_68589[(7)]);
var inst_68552 = (state_68589[(8)]);
var inst_68550 = (state_68589[(2)]);
var inst_68551 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68538,"_fn/params");
var inst_68552__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_68551);
var inst_68553 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68538,"_fn/code");
var inst_68554 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_68553);
var inst_68555 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_68554,funType,inst_68552__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_68554,funType,inst_68552__$1));
var state_68589__$1 = (function (){var statearr_68594 = state_68589;
(statearr_68594[(8)] = inst_68552__$1);

(statearr_68594[(9)] = inst_68550);

return statearr_68594;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68589__$1,(16),inst_68555);
} else {
if((state_val_68590 === (13))){
var inst_68541 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_68542 = ["Unknown function: ",inst_68541].join('');
var inst_68543 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_68544 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_68545 = cljs.core.PersistentHashMap.fromArrays(inst_68543,inst_68544);
var inst_68546 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_68542,inst_68545);
var inst_68547 = (function(){throw inst_68546})();
var state_68589__$1 = state_68589;
var statearr_68595_68631 = state_68589__$1;
(statearr_68595_68631[(2)] = inst_68547);

(statearr_68595_68631[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (6))){
var state_68589__$1 = state_68589;
var statearr_68596_68632 = state_68589__$1;
(statearr_68596_68632[(2)] = null);

(statearr_68596_68632[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (17))){
var state_68589__$1 = state_68589;
var statearr_68597_68633 = state_68589__$1;
(statearr_68597_68633[(2)] = null);

(statearr_68597_68633[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (3))){
var inst_68587 = (state_68589[(2)]);
var state_68589__$1 = state_68589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68589__$1,inst_68587);
} else {
if((state_val_68590 === (12))){
var inst_68538 = (state_68589[(7)]);
var inst_68537 = (state_68589[(2)]);
var inst_68538__$1 = fluree.db.util.async.throw_err(inst_68537);
var inst_68539 = cljs.core.empty_QMARK_(inst_68538__$1);
var state_68589__$1 = (function (){var statearr_68598 = state_68589;
(statearr_68598[(7)] = inst_68538__$1);

return statearr_68598;
})();
if(inst_68539){
var statearr_68599_68634 = state_68589__$1;
(statearr_68599_68634[(1)] = (13));

} else {
var statearr_68600_68635 = state_68589__$1;
(statearr_68600_68635[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (2))){
var inst_68511 = (state_68589[(10)]);
var _ = (function (){var statearr_68601 = state_68589;
(statearr_68601[(4)] = cljs.core.cons((5),(state_68589[(4)])));

return statearr_68601;
})();
var inst_68511__$1 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var state_68589__$1 = (function (){var statearr_68602 = state_68589;
(statearr_68602[(10)] = inst_68511__$1);

return statearr_68602;
})();
if(cljs.core.truth_(inst_68511__$1)){
var statearr_68603_68636 = state_68589__$1;
(statearr_68603_68636[(1)] = (6));

} else {
var statearr_68604_68637 = state_68589__$1;
(statearr_68604_68637[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (19))){
var inst_68572 = (state_68589[(11)]);
var inst_68582 = (state_68589[(2)]);
var state_68589__$1 = (function (){var statearr_68605 = state_68589;
(statearr_68605[(12)] = inst_68582);

return statearr_68605;
})();
var statearr_68606_68638 = state_68589__$1;
(statearr_68606_68638[(2)] = inst_68572);

(statearr_68606_68638[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (11))){
var inst_68584 = (state_68589[(2)]);
var _ = (function (){var statearr_68608 = state_68589;
(statearr_68608[(4)] = cljs.core.rest((state_68589[(4)])));

return statearr_68608;
})();
var state_68589__$1 = state_68589;
var statearr_68609_68639 = state_68589__$1;
(statearr_68609_68639[(2)] = inst_68584);

(statearr_68609_68639[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (9))){
var inst_68522 = (state_68589[(13)]);
var state_68589__$1 = state_68589;
var statearr_68610_68640 = state_68589__$1;
(statearr_68610_68640[(2)] = inst_68522);

(statearr_68610_68640[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (5))){
var _ = (function (){var statearr_68611 = state_68589;
(statearr_68611[(4)] = cljs.core.rest((state_68589[(4)])));

return statearr_68611;
})();
var state_68589__$1 = state_68589;
var ex68607 = (state_68589__$1[(2)]);
var statearr_68612_68641 = state_68589__$1;
(statearr_68612_68641[(5)] = ex68607);


if((ex68607 instanceof Error)){
var statearr_68613_68642 = state_68589__$1;
(statearr_68613_68642[(1)] = (4));

(statearr_68613_68642[(5)] = null);

} else {
throw ex68607;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (14))){
var state_68589__$1 = state_68589;
var statearr_68614_68643 = state_68589__$1;
(statearr_68614_68643[(2)] = null);

(statearr_68614_68643[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (16))){
var inst_68538 = (state_68589[(7)]);
var inst_68511 = (state_68589[(10)]);
var inst_68552 = (state_68589[(8)]);
var inst_68534 = (state_68589[(14)]);
var inst_68550 = (state_68589[(9)]);
var inst_68522 = (state_68589[(13)]);
var inst_68557 = (state_68589[(2)]);
var inst_68558 = fluree.db.util.async.throw_err(inst_68557);
var inst_68559 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68538,"_fn/spec");
var inst_68560 = cljs.core.PersistentVector.EMPTY;
var inst_68561 = cljs.core.cst$sym$_QMARK_ctx;
var inst_68562 = (function (){var forward_time_travel_db_QMARK_ = inst_68511;
var or__4212__auto__ = inst_68522;
var query = inst_68534;
var res = inst_68538;
var _ = inst_68550;
var params = inst_68552;
var code = inst_68558;
var spec = inst_68559;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_68563 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_68562,inst_68552);
var inst_68564 = cljs.core.cons(inst_68561,inst_68563);
var inst_68565 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_68560,inst_68564);
var inst_68566 = fluree.db.dbfunctions.core.build_fn(inst_68565,inst_68558);
var inst_68567 = [cljs.core.cst$kw$f,cljs.core.cst$kw$params,cljs.core.cst$kw$arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,cljs.core.cst$kw$code];
var inst_68568 = cljs.core.count(inst_68552);
var inst_68569 = [inst_68568];
var inst_68570 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_68569);
var inst_68571 = [inst_68566,inst_68552,inst_68570,false,inst_68559,null];
var inst_68572 = cljs.core.PersistentHashMap.fromArrays(inst_68567,inst_68571);
var state_68589__$1 = (function (){var statearr_68615 = state_68589;
(statearr_68615[(11)] = inst_68572);

return statearr_68615;
})();
if(cljs.core.truth_(inst_68511)){
var statearr_68616_68644 = state_68589__$1;
(statearr_68616_68644[(1)] = (17));

} else {
var statearr_68617_68645 = state_68589__$1;
(statearr_68617_68645[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (10))){
var inst_68534 = (state_68589[(14)]);
var inst_68525 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_68526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68527 = ["_fn/params","_fn/code","_fn/spec"];
var inst_68528 = (new cljs.core.PersistentVector(null,3,(5),inst_68526,inst_68527,null));
var inst_68529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68530 = cljs.core.name(fn_name);
var inst_68531 = ["_fn/name",inst_68530];
var inst_68532 = (new cljs.core.PersistentVector(null,2,(5),inst_68529,inst_68531,null));
var inst_68533 = [inst_68528,inst_68532];
var inst_68534__$1 = cljs.core.PersistentHashMap.fromArrays(inst_68525,inst_68533);
var inst_68535 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_68534__$1);
var state_68589__$1 = (function (){var statearr_68618 = state_68589;
(statearr_68618[(14)] = inst_68534__$1);

return statearr_68618;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68589__$1,(12),inst_68535);
} else {
if((state_val_68590 === (18))){
var inst_68572 = (state_68589[(11)]);
var inst_68575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68576 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_68577 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_68578 = [fn_name,inst_68576,inst_68577];
var inst_68579 = (new cljs.core.PersistentVector(null,3,(5),inst_68575,inst_68578,null));
var inst_68580 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_68579,inst_68572);
var state_68589__$1 = state_68589;
var statearr_68619_68646 = state_68589__$1;
(statearr_68619_68646[(2)] = inst_68580);

(statearr_68619_68646[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68590 === (8))){
var inst_68522 = (state_68589[(13)]);
var inst_68522__$1 = (state_68589[(2)]);
var state_68589__$1 = (function (){var statearr_68620 = state_68589;
(statearr_68620[(13)] = inst_68522__$1);

return statearr_68620;
})();
if(cljs.core.truth_(inst_68522__$1)){
var statearr_68621_68647 = state_68589__$1;
(statearr_68621_68647[(1)] = (9));

} else {
var statearr_68622_68648 = state_68589__$1;
(statearr_68622_68648[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10750__auto____0 = (function (){
var statearr_68623 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68623[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10750__auto__);

(statearr_68623[(1)] = (1));

return statearr_68623;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10750__auto____1 = (function (state_68589){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_68589);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e68624){var ex__10753__auto__ = e68624;
var statearr_68625_68649 = state_68589;
(statearr_68625_68649[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_68589[(4)]))){
var statearr_68626_68650 = state_68589;
(statearr_68626_68650[(1)] = cljs.core.first((state_68589[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__68651 = state_68589;
state_68589 = G__68651;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10750__auto__ = function(state_68589){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10750__auto____1.call(this,state_68589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10750__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_68627 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_68627[(6)] = c__10876__auto__);

return statearr_68627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__68653 = arguments.length;
switch (G__68653) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__68657 = arguments.length;
switch (G__68657) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_68787){
var state_val_68788 = (state_68787[(1)]);
if((state_val_68788 === (7))){
var inst_68782 = (state_68787[(2)]);
var _ = (function (){var statearr_68789 = state_68787;
(statearr_68789[(4)] = cljs.core.rest((state_68787[(4)])));

return statearr_68789;
})();
var state_68787__$1 = state_68787;
var statearr_68790_68870 = state_68787__$1;
(statearr_68790_68870[(2)] = inst_68782);

(statearr_68790_68870[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (20))){
var inst_68696 = (state_68787[(7)]);
var state_68787__$1 = state_68787;
var statearr_68791_68871 = state_68787__$1;
(statearr_68791_68871[(2)] = inst_68696);

(statearr_68791_68871[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (27))){
var inst_68683 = (state_68787[(8)]);
var inst_68709 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_68710 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68683)," used in function.",inst_68709].join('');
var inst_68711 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_68712 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_68713 = cljs.core.PersistentHashMap.fromArrays(inst_68711,inst_68712);
var inst_68714 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_68710,inst_68713);
var inst_68715 = (function(){throw inst_68714})();
var state_68787__$1 = state_68787;
var statearr_68792_68872 = state_68787__$1;
(statearr_68792_68872[(2)] = inst_68715);

(statearr_68792_68872[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (1))){
var state_68787__$1 = state_68787;
var statearr_68793_68873 = state_68787__$1;
(statearr_68793_68873[(2)] = null);

(statearr_68793_68873[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (24))){
var inst_68706 = (state_68787[(9)]);
var inst_68706__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_68787__$1 = (function (){var statearr_68794 = state_68787;
(statearr_68794[(9)] = inst_68706__$1);

return statearr_68794;
})();
if(inst_68706__$1){
var statearr_68795_68874 = state_68787__$1;
(statearr_68795_68874[(1)] = (26));

} else {
var statearr_68796_68875 = state_68787__$1;
(statearr_68796_68875[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (39))){
var inst_68683 = (state_68787[(8)]);
var inst_68743 = (inst_68683 == null);
var state_68787__$1 = state_68787;
if(cljs.core.truth_(inst_68743)){
var statearr_68797_68876 = state_68787__$1;
(statearr_68797_68876[(1)] = (42));

} else {
var statearr_68798_68877 = state_68787__$1;
(statearr_68798_68877[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (46))){
var state_68787__$1 = state_68787;
var statearr_68799_68878 = state_68787__$1;
(statearr_68799_68878[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (4))){
var inst_68658 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68801_68879 = state_68787__$1;
(statearr_68801_68879[(2)] = inst_68658);

(statearr_68801_68879[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (15))){
var inst_68683 = (state_68787[(8)]);
var inst_68694 = (inst_68683 instanceof cljs.core.Symbol);
var state_68787__$1 = state_68787;
if(cljs.core.truth_(inst_68694)){
var statearr_68802_68880 = state_68787__$1;
(statearr_68802_68880[(1)] = (17));

} else {
var statearr_68803_68881 = state_68787__$1;
(statearr_68803_68881[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (48))){
var inst_68750 = (state_68787[(2)]);
var inst_68751 = fluree.db.util.async.throw_err(inst_68750);
var state_68787__$1 = state_68787;
var statearr_68804_68882 = state_68787__$1;
(statearr_68804_68882[(2)] = inst_68751);

(statearr_68804_68882[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (50))){
var state_68787__$1 = state_68787;
var statearr_68805_68883 = state_68787__$1;
(statearr_68805_68883[(2)] = null);

(statearr_68805_68883[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (21))){
var inst_68696 = (state_68787[(7)]);
var inst_68703 = (state_68787[(10)]);
var inst_68673 = (state_68787[(11)]);
var inst_68684 = (state_68787[(12)]);
var inst_68671 = (state_68787[(13)]);
var inst_68683 = (state_68787[(8)]);
var inst_68677 = (state_68787[(14)]);
var inst_68676 = (state_68787[(15)]);
var inst_68674 = (state_68787[(16)]);
var inst_68699 = [inst_68683];
var inst_68700 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_68699);
var inst_68701 = (function (){var x = inst_68683;
var G__68667 = inst_68676;
var seq__68669 = inst_68674;
var vec__68668 = inst_68671;
var r = inst_68684;
var or__4212__auto__ = inst_68696;
var acc = inst_68677;
var first__68670 = inst_68673;
var seq__68680 = inst_68684;
var first__68681 = inst_68683;
var vec__68679 = inst_68676;
return (function (p1__68655_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__68655_SHARP_);
});
})();
var inst_68702 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_68701,params);
var inst_68703__$1 = cljs.core.some(inst_68700,inst_68702);
var state_68787__$1 = (function (){var statearr_68806 = state_68787;
(statearr_68806[(10)] = inst_68703__$1);

return statearr_68806;
})();
if(cljs.core.truth_(inst_68703__$1)){
var statearr_68807_68884 = state_68787__$1;
(statearr_68807_68884[(1)] = (23));

} else {
var statearr_68808_68885 = state_68787__$1;
(statearr_68808_68885[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (31))){
var inst_68733 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
if(cljs.core.truth_(inst_68733)){
var statearr_68809_68886 = state_68787__$1;
(statearr_68809_68886[(1)] = (35));

} else {
var statearr_68810_68887 = state_68787__$1;
(statearr_68810_68887[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (32))){
var inst_68726 = (state_68787[(17)]);
var state_68787__$1 = state_68787;
var statearr_68811_68888 = state_68787__$1;
(statearr_68811_68888[(2)] = inst_68726);

(statearr_68811_68888[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (40))){
var inst_68768 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68812_68889 = state_68787__$1;
(statearr_68812_68889[(2)] = inst_68768);

(statearr_68812_68889[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (33))){
var inst_68683 = (state_68787[(8)]);
var inst_68729 = (inst_68683 == null);
var state_68787__$1 = state_68787;
var statearr_68813_68890 = state_68787__$1;
(statearr_68813_68890[(2)] = inst_68729);

(statearr_68813_68890[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (13))){
var inst_68684 = (state_68787[(12)]);
var inst_68677 = (state_68787[(14)]);
var inst_68776 = (state_68787[(2)]);
var inst_68777 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_68677,inst_68776);
var inst_68676 = inst_68684;
var inst_68677__$1 = inst_68777;
var state_68787__$1 = (function (){var statearr_68814 = state_68787;
(statearr_68814[(14)] = inst_68677__$1);

(statearr_68814[(15)] = inst_68676);

return statearr_68814;
})();
var statearr_68815_68891 = state_68787__$1;
(statearr_68815_68891[(2)] = null);

(statearr_68815_68891[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (22))){
var inst_68721 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68816_68892 = state_68787__$1;
(statearr_68816_68892[(2)] = inst_68721);

(statearr_68816_68892[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (36))){
var inst_68683 = (state_68787[(8)]);
var inst_68736 = cljs.core.vector_QMARK_(inst_68683);
var state_68787__$1 = state_68787;
if(inst_68736){
var statearr_68817_68893 = state_68787__$1;
(statearr_68817_68893[(1)] = (38));

} else {
var statearr_68818_68894 = state_68787__$1;
(statearr_68818_68894[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (41))){
var inst_68740 = (state_68787[(2)]);
var inst_68741 = fluree.db.util.async.throw_err(inst_68740);
var state_68787__$1 = state_68787;
var statearr_68819_68895 = state_68787__$1;
(statearr_68819_68895[(2)] = inst_68741);

(statearr_68819_68895[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (43))){
var inst_68683 = (state_68787[(8)]);
var inst_68746 = cljs.core.list_QMARK_(inst_68683);
var state_68787__$1 = state_68787;
if(inst_68746){
var statearr_68820_68896 = state_68787__$1;
(statearr_68820_68896[(1)] = (45));

} else {
var statearr_68821_68897 = state_68787__$1;
(statearr_68821_68897[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (29))){
var inst_68723 = (state_68787[(18)]);
var state_68787__$1 = state_68787;
var statearr_68822_68898 = state_68787__$1;
(statearr_68822_68898[(2)] = inst_68723);

(statearr_68822_68898[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (44))){
var inst_68766 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68823_68899 = state_68787__$1;
(statearr_68823_68899[(2)] = inst_68766);

(statearr_68823_68899[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (6))){
var inst_68683 = (state_68787[(8)]);
var inst_68676 = (state_68787[(15)]);
var inst_68682 = cljs.core.seq(inst_68676);
var inst_68683__$1 = cljs.core.first(inst_68682);
var inst_68684 = cljs.core.next(inst_68682);
var inst_68685 = (inst_68683__$1 == null);
var state_68787__$1 = (function (){var statearr_68824 = state_68787;
(statearr_68824[(12)] = inst_68684);

(statearr_68824[(8)] = inst_68683__$1);

return statearr_68824;
})();
if(cljs.core.truth_(inst_68685)){
var statearr_68825_68900 = state_68787__$1;
(statearr_68825_68900[(1)] = (8));

} else {
var statearr_68826_68901 = state_68787__$1;
(statearr_68826_68901[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (28))){
var inst_68717 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68827_68902 = state_68787__$1;
(statearr_68827_68902[(2)] = inst_68717);

(statearr_68827_68902[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (51))){
var inst_68762 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68828_68903 = state_68787__$1;
(statearr_68828_68903[(2)] = inst_68762);

(statearr_68828_68903[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (25))){
var inst_68719 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68829_68904 = state_68787__$1;
(statearr_68829_68904[(2)] = inst_68719);

(statearr_68829_68904[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (34))){
var inst_68731 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68830_68905 = state_68787__$1;
(statearr_68830_68905[(2)] = inst_68731);

(statearr_68830_68905[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (17))){
var inst_68696 = (state_68787[(7)]);
var inst_68683 = (state_68787[(8)]);
var inst_68696__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_68683) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_68683));
var state_68787__$1 = (function (){var statearr_68831 = state_68787;
(statearr_68831[(7)] = inst_68696__$1);

return statearr_68831;
})();
if(cljs.core.truth_(inst_68696__$1)){
var statearr_68832_68906 = state_68787__$1;
(statearr_68832_68906[(1)] = (20));

} else {
var statearr_68833_68907 = state_68787__$1;
(statearr_68833_68907[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (3))){
var inst_68785 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68787__$1,inst_68785);
} else {
if((state_val_68788 === (12))){
var inst_68683 = (state_68787[(8)]);
var inst_68691 = typeof inst_68683 === 'number';
var state_68787__$1 = state_68787;
if(cljs.core.truth_(inst_68691)){
var statearr_68834_68908 = state_68787__$1;
(statearr_68834_68908[(1)] = (14));

} else {
var statearr_68835_68909 = state_68787__$1;
(statearr_68835_68909[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (2))){
var inst_68671 = (state_68787[(13)]);
var _ = (function (){var statearr_68836 = state_68787;
(statearr_68836[(4)] = cljs.core.cons((5),(state_68787[(4)])));

return statearr_68836;
})();
var inst_68671__$1 = vec;
var inst_68672 = cljs.core.seq(inst_68671__$1);
var inst_68673 = cljs.core.first(inst_68672);
var inst_68674 = cljs.core.next(inst_68672);
var inst_68675 = cljs.core.PersistentVector.EMPTY;
var inst_68676 = inst_68671__$1;
var inst_68677 = inst_68675;
var state_68787__$1 = (function (){var statearr_68837 = state_68787;
(statearr_68837[(11)] = inst_68673);

(statearr_68837[(13)] = inst_68671__$1);

(statearr_68837[(14)] = inst_68677);

(statearr_68837[(15)] = inst_68676);

(statearr_68837[(16)] = inst_68674);

return statearr_68837;
})();
var statearr_68838_68910 = state_68787__$1;
(statearr_68838_68910[(2)] = null);

(statearr_68838_68910[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (23))){
var inst_68703 = (state_68787[(10)]);
var state_68787__$1 = state_68787;
var statearr_68839_68911 = state_68787__$1;
(statearr_68839_68911[(2)] = inst_68703);

(statearr_68839_68911[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (47))){
var inst_68764 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68840_68912 = state_68787__$1;
(statearr_68840_68912[(2)] = inst_68764);

(statearr_68840_68912[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (35))){
var inst_68683 = (state_68787[(8)]);
var state_68787__$1 = state_68787;
var statearr_68841_68913 = state_68787__$1;
(statearr_68841_68913[(2)] = inst_68683);

(statearr_68841_68913[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (19))){
var inst_68772 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68842_68914 = state_68787__$1;
(statearr_68842_68914[(2)] = inst_68772);

(statearr_68842_68914[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (11))){
var inst_68683 = (state_68787[(8)]);
var state_68787__$1 = state_68787;
var statearr_68844_68915 = state_68787__$1;
(statearr_68844_68915[(2)] = inst_68683);

(statearr_68844_68915[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (9))){
var inst_68683 = (state_68787[(8)]);
var inst_68688 = typeof inst_68683 === 'string';
var state_68787__$1 = state_68787;
if(cljs.core.truth_(inst_68688)){
var statearr_68845_68916 = state_68787__$1;
(statearr_68845_68916[(1)] = (11));

} else {
var statearr_68846_68917 = state_68787__$1;
(statearr_68846_68917[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (5))){
var _ = (function (){var statearr_68847 = state_68787;
(statearr_68847[(4)] = cljs.core.rest((state_68787[(4)])));

return statearr_68847;
})();
var state_68787__$1 = state_68787;
var ex68843 = (state_68787__$1[(2)]);
var statearr_68848_68918 = state_68787__$1;
(statearr_68848_68918[(5)] = ex68843);


if((ex68843 instanceof Error)){
var statearr_68849_68919 = state_68787__$1;
(statearr_68849_68919[(1)] = (4));

(statearr_68849_68919[(5)] = null);

} else {
throw ex68843;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (14))){
var inst_68683 = (state_68787[(8)]);
var state_68787__$1 = state_68787;
var statearr_68850_68920 = state_68787__$1;
(statearr_68850_68920[(2)] = inst_68683);

(statearr_68850_68920[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (45))){
var inst_68683 = (state_68787[(8)]);
var inst_68748 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_68683,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_68683,funType,params));
var state_68787__$1 = state_68787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68787__$1,(48),inst_68748);
} else {
if((state_val_68788 === (26))){
var inst_68706 = (state_68787[(9)]);
var state_68787__$1 = state_68787;
var statearr_68851_68921 = state_68787__$1;
(statearr_68851_68921[(2)] = inst_68706);

(statearr_68851_68921[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (16))){
var inst_68774 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68852_68922 = state_68787__$1;
(statearr_68852_68922[(2)] = inst_68774);

(statearr_68852_68922[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (38))){
var inst_68683 = (state_68787[(8)]);
var inst_68738 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_68683,funType,params);
var state_68787__$1 = state_68787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68787__$1,(41),inst_68738);
} else {
if((state_val_68788 === (30))){
var inst_68726 = (state_68787[(17)]);
var inst_68683 = (state_68787[(8)]);
var inst_68726__$1 = inst_68683 === false;
var state_68787__$1 = (function (){var statearr_68853 = state_68787;
(statearr_68853[(17)] = inst_68726__$1);

return statearr_68853;
})();
if(cljs.core.truth_(inst_68726__$1)){
var statearr_68854_68923 = state_68787__$1;
(statearr_68854_68923[(1)] = (32));

} else {
var statearr_68855_68924 = state_68787__$1;
(statearr_68855_68924[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (10))){
var inst_68780 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68856_68925 = state_68787__$1;
(statearr_68856_68925[(2)] = inst_68780);

(statearr_68856_68925[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (18))){
var inst_68723 = (state_68787[(18)]);
var inst_68683 = (state_68787[(8)]);
var inst_68723__$1 = inst_68683 === true;
var state_68787__$1 = (function (){var statearr_68857 = state_68787;
(statearr_68857[(18)] = inst_68723__$1);

return statearr_68857;
})();
if(cljs.core.truth_(inst_68723__$1)){
var statearr_68858_68926 = state_68787__$1;
(statearr_68858_68926[(1)] = (29));

} else {
var statearr_68859_68927 = state_68787__$1;
(statearr_68859_68927[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (42))){
var inst_68683 = (state_68787[(8)]);
var state_68787__$1 = state_68787;
var statearr_68860_68928 = state_68787__$1;
(statearr_68860_68928[(2)] = inst_68683);

(statearr_68860_68928[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (37))){
var inst_68770 = (state_68787[(2)]);
var state_68787__$1 = state_68787;
var statearr_68861_68929 = state_68787__$1;
(statearr_68861_68929[(2)] = inst_68770);

(statearr_68861_68929[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (8))){
var inst_68677 = (state_68787[(14)]);
var state_68787__$1 = state_68787;
var statearr_68862_68930 = state_68787__$1;
(statearr_68862_68930[(2)] = inst_68677);

(statearr_68862_68930[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68788 === (49))){
var inst_68683 = (state_68787[(8)]);
var inst_68754 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68683], 0));
var inst_68755 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_68756 = ["Illegal element (",inst_68754,") in vector: ",inst_68755,"."].join('');
var inst_68757 = cljs.core.PersistentHashMap.EMPTY;
var inst_68758 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_68756,inst_68757);
var inst_68759 = (function(){throw inst_68758})();
var state_68787__$1 = state_68787;
var statearr_68863_68931 = state_68787__$1;
(statearr_68863_68931[(2)] = inst_68759);

(statearr_68863_68931[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__10750__auto____0 = (function (){
var statearr_68864 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68864[(0)] = fluree$db$dbfunctions$core$state_machine__10750__auto__);

(statearr_68864[(1)] = (1));

return statearr_68864;
});
var fluree$db$dbfunctions$core$state_machine__10750__auto____1 = (function (state_68787){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_68787);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e68865){var ex__10753__auto__ = e68865;
var statearr_68866_68932 = state_68787;
(statearr_68866_68932[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_68787[(4)]))){
var statearr_68867_68933 = state_68787;
(statearr_68867_68933[(1)] = cljs.core.first((state_68787[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__68934 = state_68787;
state_68787 = G__68934;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__10750__auto__ = function(state_68787){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__10750__auto____1.call(this,state_68787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__10750__auto____0;
fluree$db$dbfunctions$core$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__10750__auto____1;
return fluree$db$dbfunctions$core$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_68868 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_68868[(6)] = c__10876__auto__);

return statearr_68868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Looks up function in local-function map. If exists returns map of function details,
 *   if doesn't exist returns nil.
 */
fluree.db.dbfunctions.core.find_local_fn_STAR_ = (function fluree$db$dbfunctions$core$find_local_fn_STAR_(fn_name){
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name));
if(cljs.core.truth_(temp__5753__auto__)){
var local_fn = temp__5753__auto__;
return fluree.db.dbfunctions.core.resolve_local_fn(local_fn);
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_local_fn = cljs.core.memoize(fluree.db.dbfunctions.core.find_local_fn_STAR_);
/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__68937 = arguments.length;
switch (G__68937) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_69101){
var state_val_69102 = (state_69101[(1)]);
if((state_val_69102 === (7))){
var inst_68945 = (state_69101[(7)]);
var inst_68951 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_68945,type);
var state_69101__$1 = state_69101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69101__$1,(9),inst_68951);
} else {
if((state_val_69102 === (59))){
var inst_68994 = (state_69101[(8)]);
var inst_69065 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68994], 0));
var inst_69066 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_68994) : type.call(null,inst_68994));
var inst_69067 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_69068 = ["Illegal element (",inst_69065,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69066),") in function argument: ",inst_69067,"."].join('');
var inst_69069 = cljs.core.PersistentHashMap.EMPTY;
var inst_69070 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69068,inst_69069);
var inst_69071 = (function(){throw inst_69070})();
var state_69101__$1 = state_69101;
var statearr_69103_69198 = state_69101__$1;
(statearr_69103_69198[(2)] = inst_69071);

(statearr_69103_69198[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (20))){
var inst_69000 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
if(cljs.core.truth_(inst_69000)){
var statearr_69104_69199 = state_69101__$1;
(statearr_69104_69199[(1)] = (21));

} else {
var statearr_69105_69200 = state_69101__$1;
(statearr_69105_69200[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (58))){
var inst_69061 = (state_69101[(2)]);
var inst_69062 = fluree.db.util.async.throw_err(inst_69061);
var state_69101__$1 = state_69101;
var statearr_69106_69201 = state_69101__$1;
(statearr_69106_69201[(2)] = inst_69062);

(statearr_69106_69201[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (60))){
var state_69101__$1 = state_69101;
var statearr_69107_69202 = state_69101__$1;
(statearr_69107_69202[(2)] = null);

(statearr_69107_69202[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (27))){
var inst_69006 = (state_69101[(2)]);
var inst_69007 = fluree.db.util.async.throw_err(inst_69006);
var state_69101__$1 = state_69101;
var statearr_69108_69203 = state_69101__$1;
(statearr_69108_69203[(2)] = inst_69007);

(statearr_69108_69203[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (1))){
var state_69101__$1 = state_69101;
var statearr_69109_69204 = state_69101__$1;
(statearr_69109_69204[(2)] = null);

(statearr_69109_69204[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (24))){
var inst_68994 = (state_69101[(8)]);
var inst_69004 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_68994,type,params);
var state_69101__$1 = state_69101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69101__$1,(27),inst_69004);
} else {
if((state_val_69102 === (55))){
var inst_68994 = (state_69101[(8)]);
var inst_69059 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_68994,type,params);
var state_69101__$1 = state_69101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69101__$1,(58),inst_69059);
} else {
if((state_val_69102 === (39))){
var inst_69042 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
var statearr_69110_69205 = state_69101__$1;
(statearr_69110_69205[(2)] = inst_69042);

(statearr_69110_69205[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (46))){
var inst_69044 = (state_69101[(9)]);
var state_69101__$1 = state_69101;
var statearr_69111_69206 = state_69101__$1;
(statearr_69111_69206[(2)] = inst_69044);

(statearr_69111_69206[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (4))){
var inst_68938 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
var statearr_69112_69207 = state_69101__$1;
(statearr_69112_69207[(2)] = inst_68938);

(statearr_69112_69207[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (54))){
var inst_69078 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
var statearr_69113_69208 = state_69101__$1;
(statearr_69113_69208[(2)] = inst_69078);

(statearr_69113_69208[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (15))){
var inst_68946 = (state_69101[(10)]);
var inst_68975 = (state_69101[(2)]);
var inst_68983 = cljs.core.seq(inst_68946);
var inst_68984 = cljs.core.first(inst_68983);
var inst_68985 = cljs.core.next(inst_68983);
var inst_68986 = cljs.core.PersistentVector.EMPTY;
var inst_68987 = inst_68946;
var inst_68988 = inst_68986;
var state_69101__$1 = (function (){var statearr_69114 = state_69101;
(statearr_69114[(11)] = inst_68988);

(statearr_69114[(12)] = inst_68987);

(statearr_69114[(13)] = inst_68975);

(statearr_69114[(14)] = inst_68985);

(statearr_69114[(15)] = inst_68984);

return statearr_69114;
})();
var statearr_69115_69209 = state_69101__$1;
(statearr_69115_69209[(2)] = null);

(statearr_69115_69209[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (48))){
var inst_69054 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
if(cljs.core.truth_(inst_69054)){
var statearr_69116_69210 = state_69101__$1;
(statearr_69116_69210[(1)] = (52));

} else {
var statearr_69117_69211 = state_69101__$1;
(statearr_69117_69211[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (50))){
var inst_68994 = (state_69101[(8)]);
var inst_69050 = (inst_68994 == null);
var state_69101__$1 = state_69101;
var statearr_69118_69212 = state_69101__$1;
(statearr_69118_69212[(2)] = inst_69050);

(statearr_69118_69212[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (21))){
var inst_68994 = (state_69101[(8)]);
var inst_69002 = cljs.core.list_QMARK_(inst_68994);
var state_69101__$1 = state_69101;
if(inst_69002){
var statearr_69119_69213 = state_69101__$1;
(statearr_69119_69213[(1)] = (24));

} else {
var statearr_69120_69214 = state_69101__$1;
(statearr_69120_69214[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (31))){
var inst_68994 = (state_69101[(8)]);
var state_69101__$1 = state_69101;
var statearr_69121_69215 = state_69101__$1;
(statearr_69121_69215[(2)] = inst_68994);

(statearr_69121_69215[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (32))){
var inst_68994 = (state_69101[(8)]);
var inst_69015 = (inst_68994 instanceof cljs.core.Symbol);
var state_69101__$1 = state_69101;
if(cljs.core.truth_(inst_69015)){
var statearr_69122_69216 = state_69101__$1;
(statearr_69122_69216[(1)] = (34));

} else {
var statearr_69123_69217 = state_69101__$1;
(statearr_69123_69217[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (40))){
var inst_69024 = (state_69101[(16)]);
var state_69101__$1 = state_69101;
var statearr_69124_69218 = state_69101__$1;
(statearr_69124_69218[(2)] = inst_69024);

(statearr_69124_69218[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (56))){
var state_69101__$1 = state_69101;
var statearr_69125_69219 = state_69101__$1;
(statearr_69125_69219[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (33))){
var inst_69082 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
var statearr_69127_69220 = state_69101__$1;
(statearr_69127_69220[(2)] = inst_69082);

(statearr_69127_69220[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (13))){
var inst_68947 = (state_69101[(17)]);
var inst_68945 = (state_69101[(7)]);
var inst_68959 = (state_69101[(18)]);
var inst_68969 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68945),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68959),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68947),"."].join('');
var inst_68970 = cljs.core.PersistentHashMap.EMPTY;
var inst_68971 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_68969,inst_68970);
var inst_68972 = (function(){throw inst_68971})();
var state_69101__$1 = state_69101;
var statearr_69128_69221 = state_69101__$1;
(statearr_69128_69221[(2)] = inst_68972);

(statearr_69128_69221[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (22))){
var inst_68988 = (state_69101[(11)]);
var state_69101__$1 = state_69101;
var statearr_69129_69222 = state_69101__$1;
(statearr_69129_69222[(2)] = inst_68988);

(statearr_69129_69222[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (36))){
var inst_69080 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
var statearr_69130_69223 = state_69101__$1;
(statearr_69130_69223[(2)] = inst_69080);

(statearr_69130_69223[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (41))){
var inst_69027 = (state_69101[(19)]);
var inst_69027__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_69101__$1 = (function (){var statearr_69131 = state_69101;
(statearr_69131[(19)] = inst_69027__$1);

return statearr_69131;
})();
if(inst_69027__$1){
var statearr_69132_69224 = state_69101__$1;
(statearr_69132_69224[(1)] = (43));

} else {
var statearr_69133_69225 = state_69101__$1;
(statearr_69133_69225[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (43))){
var inst_69027 = (state_69101[(19)]);
var state_69101__$1 = state_69101;
var statearr_69134_69226 = state_69101__$1;
(statearr_69134_69226[(2)] = inst_69027);

(statearr_69134_69226[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (61))){
var inst_69074 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
var statearr_69135_69227 = state_69101__$1;
(statearr_69135_69227[(2)] = inst_69074);

(statearr_69135_69227[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (29))){
var inst_68994 = (state_69101[(8)]);
var inst_69012 = typeof inst_68994 === 'number';
var state_69101__$1 = state_69101;
if(cljs.core.truth_(inst_69012)){
var statearr_69136_69228 = state_69101__$1;
(statearr_69136_69228[(1)] = (31));

} else {
var statearr_69137_69229 = state_69101__$1;
(statearr_69137_69229[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (44))){
var inst_68994 = (state_69101[(8)]);
var inst_69030 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_69031 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68994)," used in function argument: ",inst_69030].join('');
var inst_69032 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_69033 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_69034 = cljs.core.PersistentHashMap.fromArrays(inst_69032,inst_69033);
var inst_69035 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69031,inst_69034);
var inst_69036 = (function(){throw inst_69035})();
var state_69101__$1 = state_69101;
var statearr_69138_69230 = state_69101__$1;
(statearr_69138_69230[(2)] = inst_69036);

(statearr_69138_69230[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (6))){
var inst_68948 = (state_69101[(20)]);
var state_69101__$1 = state_69101;
var statearr_69139_69231 = state_69101__$1;
(statearr_69139_69231[(2)] = inst_68948);

(statearr_69139_69231[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (28))){
var inst_68994 = (state_69101[(8)]);
var state_69101__$1 = state_69101;
var statearr_69140_69232 = state_69101__$1;
(statearr_69140_69232[(2)] = inst_68994);

(statearr_69140_69232[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (51))){
var inst_69052 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
var statearr_69141_69233 = state_69101__$1;
(statearr_69141_69233[(2)] = inst_69052);

(statearr_69141_69233[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (25))){
var inst_68994 = (state_69101[(8)]);
var inst_69009 = typeof inst_68994 === 'string';
var state_69101__$1 = state_69101;
if(cljs.core.truth_(inst_69009)){
var statearr_69142_69234 = state_69101__$1;
(statearr_69142_69234[(1)] = (28));

} else {
var statearr_69143_69235 = state_69101__$1;
(statearr_69143_69235[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (34))){
var inst_68994 = (state_69101[(8)]);
var inst_69017 = (state_69101[(21)]);
var inst_69017__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_68994) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_68994));
var state_69101__$1 = (function (){var statearr_69144 = state_69101;
(statearr_69144[(21)] = inst_69017__$1);

return statearr_69144;
})();
if(cljs.core.truth_(inst_69017__$1)){
var statearr_69145_69236 = state_69101__$1;
(statearr_69145_69236[(1)] = (37));

} else {
var statearr_69146_69237 = state_69101__$1;
(statearr_69146_69237[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (17))){
var inst_68958 = (state_69101[(22)]);
var inst_69093 = (state_69101[(2)]);
var inst_69094 = cljs.core.cst$sym$_QMARK_ctx;
var inst_69095 = cljs.core.cons(inst_69094,inst_69093);
var inst_69096 = cljs.core.cons(inst_68958,inst_69095);
var _ = (function (){var statearr_69147 = state_69101;
(statearr_69147[(4)] = cljs.core.rest((state_69101[(4)])));

return statearr_69147;
})();
var state_69101__$1 = state_69101;
var statearr_69148_69238 = state_69101__$1;
(statearr_69148_69238[(2)] = inst_69096);

(statearr_69148_69238[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (3))){
var inst_69099 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69101__$1,inst_69099);
} else {
if((state_val_69102 === (12))){
var inst_68966 = (state_69101[(2)]);
var inst_68967 = cljs.core.not(inst_68966);
var state_69101__$1 = state_69101;
if(inst_68967){
var statearr_69149_69239 = state_69101__$1;
(statearr_69149_69239[(1)] = (13));

} else {
var statearr_69150_69240 = state_69101__$1;
(statearr_69150_69240[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (2))){
var inst_68946 = (state_69101[(10)]);
var inst_68945 = (state_69101[(7)]);
var inst_68948 = (state_69101[(20)]);
var _ = (function (){var statearr_69151 = state_69101;
(statearr_69151[(4)] = cljs.core.cons((5),(state_69101[(4)])));

return statearr_69151;
})();
var inst_68945__$1 = cljs.core.first(form);
var inst_68946__$1 = cljs.core.rest(form);
var inst_68947 = cljs.core.count(inst_68946__$1);
var inst_68948__$1 = (fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1(inst_68945__$1) : fluree.db.dbfunctions.core.find_local_fn.call(null,inst_68945__$1));
var state_69101__$1 = (function (){var statearr_69152 = state_69101;
(statearr_69152[(10)] = inst_68946__$1);

(statearr_69152[(17)] = inst_68947);

(statearr_69152[(7)] = inst_68945__$1);

(statearr_69152[(20)] = inst_68948__$1);

return statearr_69152;
})();
if(cljs.core.truth_(inst_68948__$1)){
var statearr_69153_69241 = state_69101__$1;
(statearr_69153_69241[(1)] = (6));

} else {
var statearr_69154_69242 = state_69101__$1;
(statearr_69154_69242[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (23))){
var inst_69091 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
var statearr_69155_69243 = state_69101__$1;
(statearr_69155_69243[(2)] = inst_69091);

(statearr_69155_69243[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (47))){
var inst_68994 = (state_69101[(8)]);
var inst_69047 = (state_69101[(23)]);
var inst_69047__$1 = inst_68994 === false;
var state_69101__$1 = (function (){var statearr_69156 = state_69101;
(statearr_69156[(23)] = inst_69047__$1);

return statearr_69156;
})();
if(cljs.core.truth_(inst_69047__$1)){
var statearr_69157_69244 = state_69101__$1;
(statearr_69157_69244[(1)] = (49));

} else {
var statearr_69158_69245 = state_69101__$1;
(statearr_69158_69245[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (35))){
var inst_68994 = (state_69101[(8)]);
var inst_69044 = (state_69101[(9)]);
var inst_69044__$1 = inst_68994 === true;
var state_69101__$1 = (function (){var statearr_69159 = state_69101;
(statearr_69159[(9)] = inst_69044__$1);

return statearr_69159;
})();
if(cljs.core.truth_(inst_69044__$1)){
var statearr_69160_69246 = state_69101__$1;
(statearr_69160_69246[(1)] = (46));

} else {
var statearr_69161_69247 = state_69101__$1;
(statearr_69161_69247[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (19))){
var inst_68994 = (state_69101[(8)]);
var inst_68998 = inst_68994 === false;
var state_69101__$1 = state_69101;
var statearr_69162_69248 = state_69101__$1;
(statearr_69162_69248[(2)] = inst_68998);

(statearr_69162_69248[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (57))){
var inst_69076 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
var statearr_69163_69249 = state_69101__$1;
(statearr_69163_69249[(2)] = inst_69076);

(statearr_69163_69249[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (11))){
var inst_68947 = (state_69101[(17)]);
var inst_68959 = (state_69101[(18)]);
var inst_68964 = (inst_68959.cljs$core$IFn$_invoke$arity$1 ? inst_68959.cljs$core$IFn$_invoke$arity$1(inst_68947) : inst_68959.call(null,inst_68947));
var state_69101__$1 = state_69101;
var statearr_69165_69250 = state_69101__$1;
(statearr_69165_69250[(2)] = inst_68964);

(statearr_69165_69250[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (9))){
var inst_68953 = (state_69101[(2)]);
var inst_68954 = fluree.db.util.async.throw_err(inst_68953);
var state_69101__$1 = state_69101;
var statearr_69166_69251 = state_69101__$1;
(statearr_69166_69251[(2)] = inst_68954);

(statearr_69166_69251[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (5))){
var _ = (function (){var statearr_69167 = state_69101;
(statearr_69167[(4)] = cljs.core.rest((state_69101[(4)])));

return statearr_69167;
})();
var state_69101__$1 = state_69101;
var ex69164 = (state_69101__$1[(2)]);
var statearr_69168_69252 = state_69101__$1;
(statearr_69168_69252[(5)] = ex69164);


if((ex69164 instanceof Error)){
var statearr_69169_69253 = state_69101__$1;
(statearr_69169_69253[(1)] = (4));

(statearr_69169_69253[(5)] = null);

} else {
throw ex69164;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (14))){
var state_69101__$1 = state_69101;
var statearr_69170_69254 = state_69101__$1;
(statearr_69170_69254[(2)] = null);

(statearr_69170_69254[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (45))){
var inst_69038 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
var statearr_69171_69255 = state_69101__$1;
(statearr_69171_69255[(2)] = inst_69038);

(statearr_69171_69255[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (53))){
var inst_68994 = (state_69101[(8)]);
var inst_69057 = cljs.core.vector_QMARK_(inst_68994);
var state_69101__$1 = state_69101;
if(inst_69057){
var statearr_69172_69256 = state_69101__$1;
(statearr_69172_69256[(1)] = (55));

} else {
var statearr_69173_69257 = state_69101__$1;
(statearr_69173_69257[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (26))){
var inst_68988 = (state_69101[(11)]);
var inst_68995 = (state_69101[(24)]);
var inst_69086 = (state_69101[(2)]);
var inst_69087 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_68988,inst_69086);
var inst_68987 = inst_68995;
var inst_68988__$1 = inst_69087;
var state_69101__$1 = (function (){var statearr_69174 = state_69101;
(statearr_69174[(11)] = inst_68988__$1);

(statearr_69174[(12)] = inst_68987);

return statearr_69174;
})();
var statearr_69175_69258 = state_69101__$1;
(statearr_69175_69258[(2)] = null);

(statearr_69175_69258[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (16))){
var inst_68994 = (state_69101[(8)]);
var inst_68987 = (state_69101[(12)]);
var inst_68993 = cljs.core.seq(inst_68987);
var inst_68994__$1 = cljs.core.first(inst_68993);
var inst_68995 = cljs.core.next(inst_68993);
var state_69101__$1 = (function (){var statearr_69176 = state_69101;
(statearr_69176[(8)] = inst_68994__$1);

(statearr_69176[(24)] = inst_68995);

return statearr_69176;
})();
if(cljs.core.truth_(inst_68994__$1)){
var statearr_69177_69259 = state_69101__$1;
(statearr_69177_69259[(1)] = (18));

} else {
var statearr_69178_69260 = state_69101__$1;
(statearr_69178_69260[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (38))){
var inst_68988 = (state_69101[(11)]);
var inst_68946 = (state_69101[(10)]);
var inst_68994 = (state_69101[(8)]);
var inst_69017 = (state_69101[(21)]);
var inst_68987 = (state_69101[(12)]);
var inst_68947 = (state_69101[(17)]);
var inst_68975 = (state_69101[(13)]);
var inst_68958 = (state_69101[(22)]);
var inst_68985 = (state_69101[(14)]);
var inst_69024 = (state_69101[(16)]);
var inst_68956 = (state_69101[(25)]);
var inst_68945 = (state_69101[(7)]);
var inst_68959 = (state_69101[(18)]);
var inst_68984 = (state_69101[(15)]);
var inst_68957 = (state_69101[(26)]);
var inst_68960 = (state_69101[(27)]);
var inst_68995 = (state_69101[(24)]);
var inst_68961 = (state_69101[(28)]);
var inst_69020 = [inst_68994];
var inst_69021 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_69020);
var inst_69022 = (function (){var arity = inst_68959;
var args_n = inst_68947;
var fn_map = inst_68956;
var first__68982 = inst_68984;
var args = inst_68946;
var r = inst_68995;
var vec__68980 = inst_68946;
var or__4212__auto__ = inst_69017;
var _ = inst_68975;
var acc = inst_68988;
var seq__68981 = inst_68985;
var vec__68990 = inst_68987;
var arglist = inst_68960;
var fn_name = inst_68945;
var _AMPERSAND_args_QMARK_ = inst_68961;
var arg = inst_68994;
var G__68979 = inst_68987;
var map__68944 = inst_68957;
var first__68992 = inst_68994;
var seq__68991 = inst_68995;
var f = inst_68958;
return (function (p1__68935_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__68935_SHARP_);
});
})();
var inst_69023 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_69022,params);
var inst_69024__$1 = cljs.core.some(inst_69021,inst_69023);
var state_69101__$1 = (function (){var statearr_69179 = state_69101;
(statearr_69179[(16)] = inst_69024__$1);

return statearr_69179;
})();
if(cljs.core.truth_(inst_69024__$1)){
var statearr_69180_69261 = state_69101__$1;
(statearr_69180_69261[(1)] = (40));

} else {
var statearr_69181_69262 = state_69101__$1;
(statearr_69181_69262[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (30))){
var inst_69084 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
var statearr_69182_69263 = state_69101__$1;
(statearr_69182_69263[(2)] = inst_69084);

(statearr_69182_69263[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (10))){
var inst_68961 = (state_69101[(28)]);
var state_69101__$1 = state_69101;
var statearr_69183_69264 = state_69101__$1;
(statearr_69183_69264[(2)] = inst_68961);

(statearr_69183_69264[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (18))){
var inst_68994 = (state_69101[(8)]);
var state_69101__$1 = state_69101;
var statearr_69184_69265 = state_69101__$1;
(statearr_69184_69265[(2)] = inst_68994);

(statearr_69184_69265[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (52))){
var inst_68994 = (state_69101[(8)]);
var state_69101__$1 = state_69101;
var statearr_69185_69266 = state_69101__$1;
(statearr_69185_69266[(2)] = inst_68994);

(statearr_69185_69266[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (42))){
var inst_69040 = (state_69101[(2)]);
var state_69101__$1 = state_69101;
var statearr_69186_69267 = state_69101__$1;
(statearr_69186_69267[(2)] = inst_69040);

(statearr_69186_69267[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (37))){
var inst_69017 = (state_69101[(21)]);
var state_69101__$1 = state_69101;
var statearr_69187_69268 = state_69101__$1;
(statearr_69187_69268[(2)] = inst_69017);

(statearr_69187_69268[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (8))){
var inst_68956 = (state_69101[(25)]);
var inst_68957 = (state_69101[(26)]);
var inst_68961 = (state_69101[(28)]);
var inst_68956__$1 = (state_69101[(2)]);
var inst_68957__$1 = cljs.core.__destructure_map(inst_68956__$1);
var inst_68958 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68957__$1,cljs.core.cst$kw$f);
var inst_68959 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68957__$1,cljs.core.cst$kw$arity);
var inst_68960 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68957__$1,cljs.core.cst$kw$arglist);
var inst_68961__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68957__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_69101__$1 = (function (){var statearr_69188 = state_69101;
(statearr_69188[(22)] = inst_68958);

(statearr_69188[(25)] = inst_68956__$1);

(statearr_69188[(18)] = inst_68959);

(statearr_69188[(26)] = inst_68957__$1);

(statearr_69188[(27)] = inst_68960);

(statearr_69188[(28)] = inst_68961__$1);

return statearr_69188;
})();
if(cljs.core.truth_(inst_68961__$1)){
var statearr_69189_69269 = state_69101__$1;
(statearr_69189_69269[(1)] = (10));

} else {
var statearr_69190_69270 = state_69101__$1;
(statearr_69190_69270[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69102 === (49))){
var inst_69047 = (state_69101[(23)]);
var state_69101__$1 = state_69101;
var statearr_69191_69271 = state_69101__$1;
(statearr_69191_69271[(2)] = inst_69047);

(statearr_69191_69271[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__10750__auto____0 = (function (){
var statearr_69192 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69192[(0)] = fluree$db$dbfunctions$core$state_machine__10750__auto__);

(statearr_69192[(1)] = (1));

return statearr_69192;
});
var fluree$db$dbfunctions$core$state_machine__10750__auto____1 = (function (state_69101){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_69101);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e69193){var ex__10753__auto__ = e69193;
var statearr_69194_69272 = state_69101;
(statearr_69194_69272[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_69101[(4)]))){
var statearr_69195_69273 = state_69101;
(statearr_69195_69273[(1)] = cljs.core.first((state_69101[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__69274 = state_69101;
state_69101 = G__69274;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__10750__auto__ = function(state_69101){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__10750__auto____1.call(this,state_69101);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__10750__auto____0;
fluree$db$dbfunctions$core$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__10750__auto____1;
return fluree$db$dbfunctions$core$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_69196 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_69196[(6)] = c__10876__auto__);

return statearr_69196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__69276 = arguments.length;
switch (G__69276) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_69358){
var state_val_69359 = (state_69358[(1)]);
if((state_val_69359 === (7))){
var inst_69286 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var state_69358__$1 = state_69358;
var statearr_69360_69408 = state_69358__$1;
(statearr_69360_69408[(2)] = inst_69286);

(statearr_69360_69408[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (20))){
var inst_69336 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_69358__$1 = state_69358;
var statearr_69361_69409 = state_69358__$1;
(statearr_69361_69409[(2)] = inst_69336);

(statearr_69361_69409[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (1))){
var state_69358__$1 = state_69358;
var statearr_69362_69410 = state_69358__$1;
(statearr_69362_69410[(2)] = null);

(statearr_69362_69410[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (24))){
var inst_69333 = (state_69358[(7)]);
var inst_69342 = cljs.core.eval(inst_69333);
var state_69358__$1 = state_69358;
var statearr_69364_69411 = state_69358__$1;
(statearr_69364_69411[(2)] = inst_69342);

(statearr_69364_69411[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (4))){
var inst_69277 = (state_69358[(2)]);
var state_69358__$1 = state_69358;
var statearr_69365_69412 = state_69358__$1;
(statearr_69365_69412[(2)] = inst_69277);

(statearr_69365_69412[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (15))){
var _ = (function (){var statearr_69366 = state_69358;
(statearr_69366[(4)] = cljs.core.rest((state_69358[(4)])));

return statearr_69366;
})();
var state_69358__$1 = state_69358;
var ex69363 = (state_69358__$1[(2)]);
var statearr_69367_69413 = state_69358__$1;
(statearr_69367_69413[(5)] = ex69363);


var statearr_69368_69414 = state_69358__$1;
(statearr_69368_69414[(1)] = (14));

(statearr_69368_69414[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (21))){
var inst_69334 = (state_69358[(8)]);
var state_69358__$1 = state_69358;
var statearr_69369_69415 = state_69358__$1;
(statearr_69369_69415[(2)] = inst_69334);

(statearr_69369_69415[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (13))){
var inst_69351 = (state_69358[(2)]);
var state_69358__$1 = state_69358;
var statearr_69370_69416 = state_69358__$1;
(statearr_69370_69416[(2)] = inst_69351);

(statearr_69370_69416[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (22))){
var inst_69339 = (state_69358[(2)]);
var state_69358__$1 = state_69358;
if(cljs.core.truth_(inst_69339)){
var statearr_69371_69417 = state_69358__$1;
(statearr_69371_69417[(1)] = (23));

} else {
var statearr_69372_69418 = state_69358__$1;
(statearr_69372_69418[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (6))){
var inst_69283 = (state_69358[(9)]);
var state_69358__$1 = state_69358;
var statearr_69373_69419 = state_69358__$1;
(statearr_69373_69419[(2)] = inst_69283);

(statearr_69373_69419[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (25))){
var inst_69344 = (state_69358[(2)]);
var inst_69345 = [cljs.core.cst$kw$fnstr];
var inst_69346 = [fn_str];
var inst_69347 = cljs.core.PersistentHashMap.fromArrays(inst_69345,inst_69346);
var inst_69348 = cljs.core.with_meta(inst_69344,inst_69347);
var _ = (function (){var statearr_69374 = state_69358;
(statearr_69374[(4)] = cljs.core.rest((state_69358[(4)])));

return statearr_69374;
})();
var state_69358__$1 = state_69358;
var statearr_69375_69420 = state_69358__$1;
(statearr_69375_69420[(2)] = inst_69348);

(statearr_69375_69420[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (17))){
var inst_69309 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_69310 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_69311 = cljs.core.PersistentHashMap.fromArrays(inst_69309,inst_69310);
var inst_69312 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_69311);
var inst_69313 = (function(){throw inst_69312})();
var state_69358__$1 = state_69358;
var statearr_69376_69421 = state_69358__$1;
(statearr_69376_69421[(2)] = inst_69313);

(statearr_69376_69421[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (3))){
var inst_69356 = (state_69358[(2)]);
var state_69358__$1 = state_69358;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69358__$1,inst_69356);
} else {
if((state_val_69359 === (12))){
var _ = (function (){var statearr_69377 = state_69358;
(statearr_69377[(4)] = cljs.core.cons((15),(state_69358[(4)])));

return statearr_69377;
})();
var inst_69306 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_69358__$1 = state_69358;
if(cljs.core.truth_(inst_69306)){
var statearr_69378_69422 = state_69358__$1;
(statearr_69378_69422[(1)] = (16));

} else {
var statearr_69379_69423 = state_69358__$1;
(statearr_69379_69423[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (2))){
var inst_69283 = (state_69358[(9)]);
var _ = (function (){var statearr_69380 = state_69358;
(statearr_69380[(4)] = cljs.core.cons((5),(state_69358[(4)])));

return statearr_69380;
})();
var inst_69283__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var state_69358__$1 = (function (){var statearr_69381 = state_69358;
(statearr_69381[(9)] = inst_69283__$1);

return statearr_69381;
})();
if(inst_69283__$1){
var statearr_69382_69424 = state_69358__$1;
(statearr_69382_69424[(1)] = (6));

} else {
var statearr_69383_69425 = state_69358__$1;
(statearr_69383_69425[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (23))){
var inst_69333 = (state_69358[(7)]);
var state_69358__$1 = state_69358;
var statearr_69384_69426 = state_69358__$1;
(statearr_69384_69426[(2)] = inst_69333);

(statearr_69384_69426[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (19))){
var inst_69334 = (state_69358[(8)]);
var inst_69319 = (state_69358[(2)]);
var inst_69320 = fluree.db.util.async.throw_err(inst_69319);
var inst_69321 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_69322 = (new cljs.core.List(null,inst_69321,null,(1),null));
var inst_69323 = cljs.core.cst$sym$_QMARK_ctx;
var inst_69324 = (new cljs.core.List(null,inst_69323,null,(1),null));
var inst_69325 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_69324);
var inst_69326 = cljs.core.seq(inst_69325);
var inst_69327 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_69326);
var inst_69328 = cljs.core.vec(inst_69327);
var inst_69329 = (new cljs.core.List(null,inst_69328,null,(1),null));
var inst_69330 = (new cljs.core.List(null,inst_69320,null,(1),null));
var inst_69331 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_69322,inst_69329,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69330], 0));
var inst_69332 = cljs.core.seq(inst_69331);
var inst_69333 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_69332);
var inst_69334__$1 = params;
var state_69358__$1 = (function (){var statearr_69385 = state_69358;
(statearr_69385[(7)] = inst_69333);

(statearr_69385[(8)] = inst_69334__$1);

return statearr_69385;
})();
if(cljs.core.truth_(inst_69334__$1)){
var statearr_69386_69427 = state_69358__$1;
(statearr_69386_69427[(1)] = (20));

} else {
var statearr_69387_69428 = state_69358__$1;
(statearr_69387_69428[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (11))){
var inst_69353 = (state_69358[(2)]);
var _ = (function (){var statearr_69389 = state_69358;
(statearr_69389[(4)] = cljs.core.rest((state_69358[(4)])));

return statearr_69389;
})();
var state_69358__$1 = state_69358;
var statearr_69390_69429 = state_69358__$1;
(statearr_69390_69429[(2)] = inst_69353);

(statearr_69390_69429[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (9))){
var inst_69290 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_69291 = fluree.db.dbfunctions.core.true_or_false = inst_69290;
var state_69358__$1 = state_69358;
var statearr_69391_69430 = state_69358__$1;
(statearr_69391_69430[(2)] = inst_69291);

(statearr_69391_69430[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (5))){
var _ = (function (){var statearr_69392 = state_69358;
(statearr_69392[(4)] = cljs.core.rest((state_69358[(4)])));

return statearr_69392;
})();
var state_69358__$1 = state_69358;
var ex69388 = (state_69358__$1[(2)]);
var statearr_69393_69431 = state_69358__$1;
(statearr_69393_69431[(5)] = ex69388);


if((ex69388 instanceof Error)){
var statearr_69394_69432 = state_69358__$1;
(statearr_69394_69432[(1)] = (4));

(statearr_69394_69432[(5)] = null);

} else {
throw ex69388;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (14))){
var inst_69293 = (state_69358[(2)]);
var inst_69294 = (function(){throw inst_69293})();
var inst_69295 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_69296 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_69297 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_69298 = cljs.core.PersistentHashMap.fromArrays(inst_69296,inst_69297);
var inst_69299 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69295,inst_69298);
var inst_69300 = (function(){throw inst_69299})();
var state_69358__$1 = (function (){var statearr_69395 = state_69358;
(statearr_69395[(10)] = inst_69294);

return statearr_69395;
})();
var statearr_69396_69433 = state_69358__$1;
(statearr_69396_69433[(2)] = inst_69300);

(statearr_69396_69433[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (16))){
var state_69358__$1 = state_69358;
var statearr_69397_69434 = state_69358__$1;
(statearr_69397_69434[(2)] = null);

(statearr_69397_69434[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (10))){
var state_69358__$1 = state_69358;
var statearr_69398_69435 = state_69358__$1;
(statearr_69398_69435[(2)] = null);

(statearr_69398_69435[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69359 === (18))){
var inst_69315 = (state_69358[(2)]);
var inst_69316 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_69317 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_69316,type,params);
var state_69358__$1 = (function (){var statearr_69399 = state_69358;
(statearr_69399[(11)] = inst_69315);

return statearr_69399;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69358__$1,(19),inst_69317);
} else {
if((state_val_69359 === (8))){
var inst_69288 = (state_69358[(2)]);
var state_69358__$1 = state_69358;
if(cljs.core.truth_(inst_69288)){
var statearr_69400_69436 = state_69358__$1;
(statearr_69400_69436[(1)] = (9));

} else {
var statearr_69401_69437 = state_69358__$1;
(statearr_69401_69437[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__10750__auto____0 = (function (){
var statearr_69402 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69402[(0)] = fluree$db$dbfunctions$core$state_machine__10750__auto__);

(statearr_69402[(1)] = (1));

return statearr_69402;
});
var fluree$db$dbfunctions$core$state_machine__10750__auto____1 = (function (state_69358){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_69358);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e69403){var ex__10753__auto__ = e69403;
var statearr_69404_69438 = state_69358;
(statearr_69404_69438[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_69358[(4)]))){
var statearr_69405_69439 = state_69358;
(statearr_69405_69439[(1)] = cljs.core.first((state_69358[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__69440 = state_69358;
state_69358 = G__69440;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__10750__auto__ = function(state_69358){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__10750__auto____1.call(this,state_69358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__10750__auto____0;
fluree$db$dbfunctions$core$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__10750__auto____1;
return fluree$db$dbfunctions$core$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_69406 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_69406[(6)] = c__10876__auto__);

return statearr_69406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_69468){
var state_val_69469 = (state_69468[(1)]);
if((state_val_69469 === (7))){
var inst_69455 = (state_69468[(7)]);
var state_69468__$1 = state_69468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69468__$1,(10),inst_69455);
} else {
if((state_val_69469 === (1))){
var state_69468__$1 = state_69468;
var statearr_69470_69490 = state_69468__$1;
(statearr_69470_69490[(2)] = null);

(statearr_69470_69490[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69469 === (4))){
var inst_69441 = (state_69468[(2)]);
var state_69468__$1 = state_69468;
var statearr_69471_69491 = state_69468__$1;
(statearr_69471_69491[(2)] = inst_69441);

(statearr_69471_69491[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69469 === (6))){
var inst_69450 = (state_69468[(8)]);
var inst_69455 = (state_69468[(7)]);
var inst_69453 = (state_69468[(2)]);
var inst_69454 = fluree.db.util.async.throw_err(inst_69453);
var inst_69455__$1 = (inst_69454.cljs$core$IFn$_invoke$arity$1 ? inst_69454.cljs$core$IFn$_invoke$arity$1(inst_69450) : inst_69454.call(null,inst_69450));
var inst_69456 = fluree.db.util.async.channel_QMARK_(inst_69455__$1);
var state_69468__$1 = (function (){var statearr_69472 = state_69468;
(statearr_69472[(7)] = inst_69455__$1);

return statearr_69472;
})();
if(inst_69456){
var statearr_69473_69492 = state_69468__$1;
(statearr_69473_69492[(1)] = (7));

} else {
var statearr_69474_69493 = state_69468__$1;
(statearr_69474_69493[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69469 === (3))){
var inst_69466 = (state_69468[(2)]);
var state_69468__$1 = state_69468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69468__$1,inst_69466);
} else {
if((state_val_69469 === (2))){
var _ = (function (){var statearr_69476 = state_69468;
(statearr_69476[(4)] = cljs.core.cons((5),(state_69468[(4)])));

return statearr_69476;
})();
var inst_69447 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_69448 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_69449 = [db,block_instant,s,p,auth_id,fuel];
var inst_69450 = cljs.core.PersistentHashMap.fromArrays(inst_69448,inst_69449);
var inst_69451 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_69447,"txn",null);
var state_69468__$1 = (function (){var statearr_69477 = state_69468;
(statearr_69477[(8)] = inst_69450);

return statearr_69477;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69468__$1,(6),inst_69451);
} else {
if((state_val_69469 === (9))){
var inst_69463 = (state_69468[(2)]);
var _ = (function (){var statearr_69478 = state_69468;
(statearr_69478[(4)] = cljs.core.rest((state_69468[(4)])));

return statearr_69478;
})();
var state_69468__$1 = state_69468;
var statearr_69479_69494 = state_69468__$1;
(statearr_69479_69494[(2)] = inst_69463);

(statearr_69479_69494[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69469 === (5))){
var _ = (function (){var statearr_69480 = state_69468;
(statearr_69480[(4)] = cljs.core.rest((state_69468[(4)])));

return statearr_69480;
})();
var state_69468__$1 = state_69468;
var ex69475 = (state_69468__$1[(2)]);
var statearr_69481_69495 = state_69468__$1;
(statearr_69481_69495[(5)] = ex69475);


if((ex69475 instanceof Error)){
var statearr_69482_69496 = state_69468__$1;
(statearr_69482_69496[(1)] = (4));

(statearr_69482_69496[(5)] = null);

} else {
throw ex69475;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69469 === (10))){
var inst_69459 = (state_69468[(2)]);
var inst_69460 = fluree.db.util.async.throw_err(inst_69459);
var state_69468__$1 = state_69468;
var statearr_69483_69497 = state_69468__$1;
(statearr_69483_69497[(2)] = inst_69460);

(statearr_69483_69497[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69469 === (8))){
var inst_69455 = (state_69468[(7)]);
var state_69468__$1 = state_69468;
var statearr_69484_69498 = state_69468__$1;
(statearr_69484_69498[(2)] = inst_69455);

(statearr_69484_69498[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10750__auto____0 = (function (){
var statearr_69485 = [null,null,null,null,null,null,null,null,null];
(statearr_69485[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10750__auto__);

(statearr_69485[(1)] = (1));

return statearr_69485;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10750__auto____1 = (function (state_69468){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_69468);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e69486){var ex__10753__auto__ = e69486;
var statearr_69487_69499 = state_69468;
(statearr_69487_69499[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_69468[(4)]))){
var statearr_69488_69500 = state_69468;
(statearr_69488_69500[(1)] = cljs.core.first((state_69468[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__69501 = state_69468;
state_69468 = G__69501;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10750__auto__ = function(state_69468){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10750__auto____1.call(this,state_69468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_69489 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_69489[(6)] = c__10876__auto__);

return statearr_69489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
