// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__69526_69695 = cljs.core.seq(servers);
var chunk__69527_69696 = null;
var count__69528_69697 = (0);
var i__69529_69698 = (0);
while(true){
if((i__69529_69698 < count__69528_69697)){
var server_69699 = chunk__69527_69696.cljs$core$IIndexed$_nth$arity$2(null,i__69529_69698);
var healthcheck_uri_69700 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_69699),"/fdb/health"].join('');
var resp_chan_69701 = fluree.db.util.xhttp.post_json(healthcheck_uri_69700,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__10876__auto___69702 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__69526_69695,chunk__69527_69696,count__69528_69697,i__69529_69698,c__10876__auto___69702,healthcheck_uri_69700,resp_chan_69701,server_69699){
return (function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = ((function (seq__69526_69695,chunk__69527_69696,count__69528_69697,i__69529_69698,c__10876__auto___69702,healthcheck_uri_69700,resp_chan_69701,server_69699){
return (function (state_69590){
var state_val_69591 = (state_69590[(1)]);
if((state_val_69591 === (1))){
var state_69590__$1 = state_69590;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69590__$1,(2),resp_chan_69701);
} else {
if((state_val_69591 === (2))){
var inst_69579 = (state_69590[(7)]);
var inst_69579__$1 = (state_69590[(2)]);
var inst_69580 = fluree.db.util.core.exception_QMARK_(inst_69579__$1);
var state_69590__$1 = (function (){var statearr_69592 = state_69590;
(statearr_69592[(7)] = inst_69579__$1);

return statearr_69592;
})();
if(inst_69580){
var statearr_69593_69703 = state_69590__$1;
(statearr_69593_69703[(1)] = (3));

} else {
var statearr_69594_69704 = state_69590__$1;
(statearr_69594_69704[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69591 === (3))){
var inst_69579 = (state_69590[(7)]);
var inst_69582 = cljs.core.ex_message(inst_69579);
var inst_69583 = cljs.core.ex_data(inst_69579);
var inst_69584 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_69582,inst_69583], 0));
var state_69590__$1 = state_69590;
var statearr_69595_69705 = state_69590__$1;
(statearr_69595_69705[(2)] = inst_69584);

(statearr_69595_69705[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69591 === (4))){
var inst_69586 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_69699);
var state_69590__$1 = state_69590;
var statearr_69596_69706 = state_69590__$1;
(statearr_69596_69706[(2)] = inst_69586);

(statearr_69596_69706[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69591 === (5))){
var inst_69588 = (state_69590[(2)]);
var state_69590__$1 = state_69590;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69590__$1,inst_69588);
} else {
return null;
}
}
}
}
}
});})(seq__69526_69695,chunk__69527_69696,count__69528_69697,i__69529_69698,c__10876__auto___69702,healthcheck_uri_69700,resp_chan_69701,server_69699))
;
return ((function (seq__69526_69695,chunk__69527_69696,count__69528_69697,i__69529_69698,switch__10749__auto__,c__10876__auto___69702,healthcheck_uri_69700,resp_chan_69701,server_69699){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____0 = (function (){
var statearr_69597 = [null,null,null,null,null,null,null,null];
(statearr_69597[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__);

(statearr_69597[(1)] = (1));

return statearr_69597;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____1 = (function (state_69590){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_69590);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e69598){var ex__10753__auto__ = e69598;
var statearr_69599_69707 = state_69590;
(statearr_69599_69707[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_69590[(4)]))){
var statearr_69600_69708 = state_69590;
(statearr_69600_69708[(1)] = cljs.core.first((state_69590[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__69709 = state_69590;
state_69590 = G__69709;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__ = function(state_69590){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____1.call(this,state_69590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__;
})()
;})(seq__69526_69695,chunk__69527_69696,count__69528_69697,i__69529_69698,switch__10749__auto__,c__10876__auto___69702,healthcheck_uri_69700,resp_chan_69701,server_69699))
})();
var state__10878__auto__ = (function (){var statearr_69601 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_69601[(6)] = c__10876__auto___69702);

return statearr_69601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
});})(seq__69526_69695,chunk__69527_69696,count__69528_69697,i__69529_69698,c__10876__auto___69702,healthcheck_uri_69700,resp_chan_69701,server_69699))
);



var G__69710 = seq__69526_69695;
var G__69711 = chunk__69527_69696;
var G__69712 = count__69528_69697;
var G__69713 = (i__69529_69698 + (1));
seq__69526_69695 = G__69710;
chunk__69527_69696 = G__69711;
count__69528_69697 = G__69712;
i__69529_69698 = G__69713;
continue;
} else {
var temp__5753__auto___69714 = cljs.core.seq(seq__69526_69695);
if(temp__5753__auto___69714){
var seq__69526_69715__$1 = temp__5753__auto___69714;
if(cljs.core.chunked_seq_QMARK_(seq__69526_69715__$1)){
var c__4638__auto___69716 = cljs.core.chunk_first(seq__69526_69715__$1);
var G__69717 = cljs.core.chunk_rest(seq__69526_69715__$1);
var G__69718 = c__4638__auto___69716;
var G__69719 = cljs.core.count(c__4638__auto___69716);
var G__69720 = (0);
seq__69526_69695 = G__69717;
chunk__69527_69696 = G__69718;
count__69528_69697 = G__69719;
i__69529_69698 = G__69720;
continue;
} else {
var server_69721 = cljs.core.first(seq__69526_69715__$1);
var healthcheck_uri_69722 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_69721),"/fdb/health"].join('');
var resp_chan_69723 = fluree.db.util.xhttp.post_json(healthcheck_uri_69722,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__10876__auto___69724 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__69526_69695,chunk__69527_69696,count__69528_69697,i__69529_69698,c__10876__auto___69724,healthcheck_uri_69722,resp_chan_69723,server_69721,seq__69526_69715__$1,temp__5753__auto___69714){
return (function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = ((function (seq__69526_69695,chunk__69527_69696,count__69528_69697,i__69529_69698,c__10876__auto___69724,healthcheck_uri_69722,resp_chan_69723,server_69721,seq__69526_69715__$1,temp__5753__auto___69714){
return (function (state_69614){
var state_val_69615 = (state_69614[(1)]);
if((state_val_69615 === (1))){
var state_69614__$1 = state_69614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69614__$1,(2),resp_chan_69723);
} else {
if((state_val_69615 === (2))){
var inst_69603 = (state_69614[(7)]);
var inst_69603__$1 = (state_69614[(2)]);
var inst_69604 = fluree.db.util.core.exception_QMARK_(inst_69603__$1);
var state_69614__$1 = (function (){var statearr_69616 = state_69614;
(statearr_69616[(7)] = inst_69603__$1);

return statearr_69616;
})();
if(inst_69604){
var statearr_69617_69725 = state_69614__$1;
(statearr_69617_69725[(1)] = (3));

} else {
var statearr_69618_69726 = state_69614__$1;
(statearr_69618_69726[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69615 === (3))){
var inst_69603 = (state_69614[(7)]);
var inst_69606 = cljs.core.ex_message(inst_69603);
var inst_69607 = cljs.core.ex_data(inst_69603);
var inst_69608 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_69606,inst_69607], 0));
var state_69614__$1 = state_69614;
var statearr_69619_69727 = state_69614__$1;
(statearr_69619_69727[(2)] = inst_69608);

(statearr_69619_69727[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69615 === (4))){
var inst_69610 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_69721);
var state_69614__$1 = state_69614;
var statearr_69620_69728 = state_69614__$1;
(statearr_69620_69728[(2)] = inst_69610);

(statearr_69620_69728[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69615 === (5))){
var inst_69612 = (state_69614[(2)]);
var state_69614__$1 = state_69614;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69614__$1,inst_69612);
} else {
return null;
}
}
}
}
}
});})(seq__69526_69695,chunk__69527_69696,count__69528_69697,i__69529_69698,c__10876__auto___69724,healthcheck_uri_69722,resp_chan_69723,server_69721,seq__69526_69715__$1,temp__5753__auto___69714))
;
return ((function (seq__69526_69695,chunk__69527_69696,count__69528_69697,i__69529_69698,switch__10749__auto__,c__10876__auto___69724,healthcheck_uri_69722,resp_chan_69723,server_69721,seq__69526_69715__$1,temp__5753__auto___69714){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____0 = (function (){
var statearr_69621 = [null,null,null,null,null,null,null,null];
(statearr_69621[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__);

(statearr_69621[(1)] = (1));

return statearr_69621;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____1 = (function (state_69614){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_69614);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e69622){var ex__10753__auto__ = e69622;
var statearr_69623_69729 = state_69614;
(statearr_69623_69729[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_69614[(4)]))){
var statearr_69624_69730 = state_69614;
(statearr_69624_69730[(1)] = cljs.core.first((state_69614[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__69731 = state_69614;
state_69614 = G__69731;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__ = function(state_69614){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____1.call(this,state_69614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__;
})()
;})(seq__69526_69695,chunk__69527_69696,count__69528_69697,i__69529_69698,switch__10749__auto__,c__10876__auto___69724,healthcheck_uri_69722,resp_chan_69723,server_69721,seq__69526_69715__$1,temp__5753__auto___69714))
})();
var state__10878__auto__ = (function (){var statearr_69625 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_69625[(6)] = c__10876__auto___69724);

return statearr_69625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
});})(seq__69526_69695,chunk__69527_69696,count__69528_69697,i__69529_69698,c__10876__auto___69724,healthcheck_uri_69722,resp_chan_69723,server_69721,seq__69526_69715__$1,temp__5753__auto___69714))
);



var G__69732 = cljs.core.next(seq__69526_69715__$1);
var G__69733 = null;
var G__69734 = (0);
var G__69735 = (0);
seq__69526_69695 = G__69732;
chunk__69527_69696 = G__69733;
count__69528_69697 = G__69734;
i__69529_69698 = G__69735;
continue;
}
} else {
}
}
break;
}

var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_69669){
var state_val_69670 = (state_69669[(1)]);
if((state_val_69670 === (7))){
var inst_69641 = (state_69669[(7)]);
var inst_69648 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69641,cljs.core.cst$kw$default);
var state_69669__$1 = state_69669;
if(inst_69648){
var statearr_69671_69736 = state_69669__$1;
(statearr_69671_69736[(1)] = (9));

} else {
var statearr_69672_69737 = state_69669__$1;
(statearr_69672_69737[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69670 === (1))){
var inst_69633 = (state_69669[(8)]);
var inst_69634 = (state_69669[(9)]);
var inst_69633__$1 = promise_chan;
var inst_69634__$1 = cljs.core.async.timeout((60000));
var inst_69635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69636 = [inst_69633__$1,inst_69634__$1];
var inst_69637 = (new cljs.core.PersistentVector(null,2,(5),inst_69635,inst_69636,null));
var state_69669__$1 = (function (){var statearr_69673 = state_69669;
(statearr_69673[(8)] = inst_69633__$1);

(statearr_69673[(9)] = inst_69634__$1);

return statearr_69673;
})();
return cljs.core.async.ioc_alts_BANG_(state_69669__$1,(2),inst_69637);
} else {
if((state_val_69670 === (4))){
var inst_69641 = (state_69669[(7)]);
var inst_69634 = (state_69669[(9)]);
var inst_69645 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69641,inst_69634);
var state_69669__$1 = state_69669;
if(inst_69645){
var statearr_69674_69738 = state_69669__$1;
(statearr_69674_69738[(1)] = (6));

} else {
var statearr_69675_69739 = state_69669__$1;
(statearr_69675_69739[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69670 === (13))){
var state_69669__$1 = state_69669;
var statearr_69676_69740 = state_69669__$1;
(statearr_69676_69740[(2)] = null);

(statearr_69676_69740[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69670 === (6))){
var state_69669__$1 = state_69669;
var statearr_69677_69741 = state_69669__$1;
(statearr_69677_69741[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_69677_69741[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69670 === (3))){
var state_69669__$1 = state_69669;
var statearr_69678_69742 = state_69669__$1;
(statearr_69678_69742[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_69678_69742[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69670 === (12))){
var inst_69659 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_69660 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_69661 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_69662 = cljs.core.PersistentHashMap.fromArrays(inst_69660,inst_69661);
var inst_69663 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_69662);
var inst_69664 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_69663);
var state_69669__$1 = (function (){var statearr_69679 = state_69669;
(statearr_69679[(10)] = inst_69659);

return statearr_69679;
})();
var statearr_69680_69743 = state_69669__$1;
(statearr_69680_69743[(2)] = inst_69664);

(statearr_69680_69743[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69670 === (2))){
var inst_69641 = (state_69669[(7)]);
var inst_69633 = (state_69669[(8)]);
var inst_69639 = (state_69669[(2)]);
var inst_69640 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69639,(0),null);
var inst_69641__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69639,(1),null);
var inst_69642 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69641__$1,inst_69633);
var state_69669__$1 = (function (){var statearr_69681 = state_69669;
(statearr_69681[(7)] = inst_69641__$1);

(statearr_69681[(11)] = inst_69640);

return statearr_69681;
})();
if(inst_69642){
var statearr_69682_69744 = state_69669__$1;
(statearr_69682_69744[(1)] = (3));

} else {
var statearr_69683_69745 = state_69669__$1;
(statearr_69683_69745[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69670 === (11))){
var inst_69652 = (state_69669[(2)]);
var state_69669__$1 = state_69669;
var statearr_69684_69746 = state_69669__$1;
(statearr_69684_69746[(2)] = inst_69652);

(statearr_69684_69746[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69670 === (9))){
var inst_69640 = (state_69669[(11)]);
var state_69669__$1 = state_69669;
var statearr_69685_69747 = state_69669__$1;
(statearr_69685_69747[(2)] = inst_69640);

(statearr_69685_69747[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69670 === (5))){
var inst_69656 = (state_69669[(2)]);
var inst_69657 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_69656);
var state_69669__$1 = state_69669;
if(inst_69657){
var statearr_69686_69748 = state_69669__$1;
(statearr_69686_69748[(1)] = (12));

} else {
var statearr_69687_69749 = state_69669__$1;
(statearr_69687_69749[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69670 === (14))){
var inst_69667 = (state_69669[(2)]);
var state_69669__$1 = state_69669;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69669__$1,inst_69667);
} else {
if((state_val_69670 === (10))){
var state_69669__$1 = state_69669;
var statearr_69688_69750 = state_69669__$1;
(statearr_69688_69750[(2)] = null);

(statearr_69688_69750[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69670 === (8))){
var inst_69654 = (state_69669[(2)]);
var state_69669__$1 = state_69669;
var statearr_69689_69751 = state_69669__$1;
(statearr_69689_69751[(2)] = inst_69654);

(statearr_69689_69751[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____0 = (function (){
var statearr_69690 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69690[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__);

(statearr_69690[(1)] = (1));

return statearr_69690;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____1 = (function (state_69669){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_69669);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e69691){var ex__10753__auto__ = e69691;
var statearr_69692_69752 = state_69669;
(statearr_69692_69752[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_69669[(4)]))){
var statearr_69693_69753 = state_69669;
(statearr_69693_69753[(1)] = cljs.core.first((state_69669[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__69754 = state_69669;
state_69669 = G__69754;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__ = function(state_69669){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____1.call(this,state_69669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_69694 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_69694[(6)] = c__10876__auto__);

return statearr_69694;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_69798){
var state_val_69799 = (state_69798[(1)]);
if((state_val_69799 === (7))){
var state_69798__$1 = state_69798;
var statearr_69800_69826 = state_69798__$1;
(statearr_69800_69826[(2)] = null);

(statearr_69800_69826[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69799 === (1))){
var state_69798__$1 = state_69798;
var statearr_69801_69827 = state_69798__$1;
(statearr_69801_69827[(2)] = null);

(statearr_69801_69827[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69799 === (4))){
var inst_69755 = (state_69798[(2)]);
var state_69798__$1 = state_69798;
var statearr_69802_69828 = state_69798__$1;
(statearr_69802_69828[(2)] = inst_69755);

(statearr_69802_69828[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69799 === (6))){
var inst_69777 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_69798__$1 = state_69798;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69798__$1,(9),inst_69777);
} else {
if((state_val_69799 === (3))){
var inst_69796 = (state_69798[(2)]);
var state_69798__$1 = state_69798;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69798__$1,inst_69796);
} else {
if((state_val_69799 === (12))){
var inst_69790 = (state_69798[(2)]);
var state_69798__$1 = state_69798;
var statearr_69803_69829 = state_69798__$1;
(statearr_69803_69829[(2)] = inst_69790);

(statearr_69803_69829[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69799 === (2))){
var inst_69761 = (state_69798[(7)]);
var inst_69766 = (state_69798[(8)]);
var inst_69771 = (state_69798[(9)]);
var _ = (function (){var statearr_69804 = state_69798;
(statearr_69804[(4)] = cljs.core.cons((5),(state_69798[(4)])));

return statearr_69804;
})();
var inst_69761__$1 = fluree.db.util.core.random_uuid();
var inst_69762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69763 = [conn_id,cljs.core.cst$kw$ws];
var inst_69764 = (new cljs.core.PersistentVector(null,2,(5),inst_69762,inst_69763,null));
var inst_69765 = (function (){var lock_id = inst_69761__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_69766__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_69764,inst_69765);
var inst_69767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69768 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_69769 = (new cljs.core.PersistentVector(null,3,(5),inst_69767,inst_69768,null));
var inst_69770 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_69766__$1,inst_69769);
var inst_69771__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69761__$1,inst_69770);
var inst_69772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69773 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_69774 = (new cljs.core.PersistentVector(null,3,(5),inst_69772,inst_69773,null));
var inst_69775 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_69766__$1,inst_69774);
var state_69798__$1 = (function (){var statearr_69805 = state_69798;
(statearr_69805[(7)] = inst_69761__$1);

(statearr_69805[(8)] = inst_69766__$1);

(statearr_69805[(10)] = inst_69775);

(statearr_69805[(9)] = inst_69771__$1);

return statearr_69805;
})();
if(inst_69771__$1){
var statearr_69806_69830 = state_69798__$1;
(statearr_69806_69830[(1)] = (6));

} else {
var statearr_69807_69831 = state_69798__$1;
(statearr_69807_69831[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69799 === (11))){
var inst_69781 = (state_69798[(11)]);
var inst_69775 = (state_69798[(10)]);
var inst_69782 = (state_69798[(12)]);
var inst_69788 = fluree.db.util.xhttp.try_socket(inst_69781,sub_chan,pub_chan,inst_69775,(60000),inst_69782);
var state_69798__$1 = state_69798;
var statearr_69809_69832 = state_69798__$1;
(statearr_69809_69832[(2)] = inst_69788);

(statearr_69809_69832[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69799 === (9))){
var inst_69761 = (state_69798[(7)]);
var inst_69781 = (state_69798[(11)]);
var inst_69766 = (state_69798[(8)]);
var inst_69779 = (state_69798[(13)]);
var inst_69775 = (state_69798[(10)]);
var inst_69771 = (state_69798[(9)]);
var inst_69779__$1 = (state_69798[(2)]);
var inst_69780 = clojure.string.replace(inst_69779__$1,"http","ws");
var inst_69781__$1 = [inst_69780,"/fdb/ws"].join('');
var inst_69782 = (function (){var lock_id = inst_69761;
var state = inst_69766;
var have_lock_QMARK_ = inst_69771;
var resp_chan = inst_69775;
var healthy_server = inst_69779__$1;
var ws_url = inst_69781__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_69783 = fluree.db.util.core.exception_QMARK_(inst_69779__$1);
var state_69798__$1 = (function (){var statearr_69810 = state_69798;
(statearr_69810[(11)] = inst_69781__$1);

(statearr_69810[(13)] = inst_69779__$1);

(statearr_69810[(12)] = inst_69782);

return statearr_69810;
})();
if(inst_69783){
var statearr_69811_69833 = state_69798__$1;
(statearr_69811_69833[(1)] = (10));

} else {
var statearr_69812_69834 = state_69798__$1;
(statearr_69812_69834[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69799 === (5))){
var _ = (function (){var statearr_69813 = state_69798;
(statearr_69813[(4)] = cljs.core.rest((state_69798[(4)])));

return statearr_69813;
})();
var state_69798__$1 = state_69798;
var ex69808 = (state_69798__$1[(2)]);
var statearr_69814_69835 = state_69798__$1;
(statearr_69814_69835[(5)] = ex69808);


if((ex69808 instanceof Error)){
var statearr_69815_69836 = state_69798__$1;
(statearr_69815_69836[(1)] = (4));

(statearr_69815_69836[(5)] = null);

} else {
throw ex69808;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69799 === (10))){
var inst_69779 = (state_69798[(13)]);
var inst_69775 = (state_69798[(10)]);
var inst_69785 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_69786 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69775,inst_69779);
var state_69798__$1 = (function (){var statearr_69816 = state_69798;
(statearr_69816[(14)] = inst_69785);

return statearr_69816;
})();
var statearr_69817_69837 = state_69798__$1;
(statearr_69817_69837[(2)] = inst_69786);

(statearr_69817_69837[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69799 === (8))){
var inst_69775 = (state_69798[(10)]);
var inst_69793 = (state_69798[(2)]);
var _ = (function (){var statearr_69818 = state_69798;
(statearr_69818[(4)] = cljs.core.rest((state_69798[(4)])));

return statearr_69818;
})();
var state_69798__$1 = (function (){var statearr_69819 = state_69798;
(statearr_69819[(15)] = inst_69793);

return statearr_69819;
})();
var statearr_69820_69838 = state_69798__$1;
(statearr_69820_69838[(2)] = inst_69775);

(statearr_69820_69838[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__10750__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__10750__auto____0 = (function (){
var statearr_69821 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69821[(0)] = fluree$db$connection$establish_socket_$_state_machine__10750__auto__);

(statearr_69821[(1)] = (1));

return statearr_69821;
});
var fluree$db$connection$establish_socket_$_state_machine__10750__auto____1 = (function (state_69798){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_69798);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e69822){var ex__10753__auto__ = e69822;
var statearr_69823_69839 = state_69798;
(statearr_69823_69839[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_69798[(4)]))){
var statearr_69824_69840 = state_69798;
(statearr_69824_69840[(1)] = cljs.core.first((state_69798[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__69841 = state_69798;
state_69798 = G__69841;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__10750__auto__ = function(state_69798){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__10750__auto____1.call(this,state_69798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__10750__auto____0;
fluree$db$connection$establish_socket_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__10750__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_69825 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_69825[(6)] = c__10876__auto__);

return statearr_69825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k69843,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__69847 = k69843;
var G__69847__$1 = (((G__69847 instanceof cljs.core.Keyword))?G__69847.fqn:null);
switch (G__69847__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k69843,else__4464__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__69848){
var vec__69849 = p__69848;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69849,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69849,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__69842){
var self__ = this;
var G__69842__$1 = this;
return (new cljs.core.RecordIter((0),G__69842__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__69852 = (function (coll__4458__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__69852(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this69844,other69845){
var self__ = this;
var this69844__$1 = this;
return (((!((other69845 == null)))) && ((((this69844__$1.constructor === other69845.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.id,other69845.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.servers,other69845.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.state,other69845.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.req_chan,other69845.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.sub_chan,other69845.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.pub_chan,other69845.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.storage_read,other69845.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.storage_write,other69845.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.object_cache,other69845.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.parallelism,other69845.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.serializer,other69845.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.default_network,other69845.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.transactor_QMARK_,other69845.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.publish,other69845.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.transact_handler,other69845.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.tx_private_key,other69845.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.tx_key_id,other69845.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.meta,other69845.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.add_listener,other69845.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.remove_listener,other69845.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.close,other69845.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this69844__$1.__extmap,other69845.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k69843){
var self__ = this;
var this__4468__auto____$1 = this;
var G__69853 = k69843;
var G__69853__$1 = (((G__69853 instanceof cljs.core.Keyword))?G__69853.fqn:null);
switch (G__69853__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k69843);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__69842){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__69854 = cljs.core.keyword_identical_QMARK_;
var expr__69855 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__69857 = cljs.core.cst$kw$id;
var G__69858 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69857,G__69858) : pred__69854.call(null,G__69857,G__69858));
})())){
return (new fluree.db.connection.Connection(G__69842,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69859 = cljs.core.cst$kw$servers;
var G__69860 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69859,G__69860) : pred__69854.call(null,G__69859,G__69860));
})())){
return (new fluree.db.connection.Connection(self__.id,G__69842,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69861 = cljs.core.cst$kw$state;
var G__69862 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69861,G__69862) : pred__69854.call(null,G__69861,G__69862));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__69842,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69863 = cljs.core.cst$kw$req_DASH_chan;
var G__69864 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69863,G__69864) : pred__69854.call(null,G__69863,G__69864));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__69842,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69865 = cljs.core.cst$kw$sub_DASH_chan;
var G__69866 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69865,G__69866) : pred__69854.call(null,G__69865,G__69866));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__69842,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69867 = cljs.core.cst$kw$pub_DASH_chan;
var G__69868 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69867,G__69868) : pred__69854.call(null,G__69867,G__69868));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__69842,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69869 = cljs.core.cst$kw$storage_DASH_read;
var G__69870 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69869,G__69870) : pred__69854.call(null,G__69869,G__69870));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__69842,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69871 = cljs.core.cst$kw$storage_DASH_write;
var G__69872 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69871,G__69872) : pred__69854.call(null,G__69871,G__69872));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__69842,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69873 = cljs.core.cst$kw$object_DASH_cache;
var G__69874 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69873,G__69874) : pred__69854.call(null,G__69873,G__69874));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__69842,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69875 = cljs.core.cst$kw$parallelism;
var G__69876 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69875,G__69876) : pred__69854.call(null,G__69875,G__69876));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__69842,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69877 = cljs.core.cst$kw$serializer;
var G__69878 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69877,G__69878) : pred__69854.call(null,G__69877,G__69878));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__69842,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69879 = cljs.core.cst$kw$default_DASH_network;
var G__69880 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69879,G__69880) : pred__69854.call(null,G__69879,G__69880));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__69842,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69881 = cljs.core.cst$kw$transactor_QMARK_;
var G__69882 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69881,G__69882) : pred__69854.call(null,G__69881,G__69882));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__69842,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69883 = cljs.core.cst$kw$publish;
var G__69884 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69883,G__69884) : pred__69854.call(null,G__69883,G__69884));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__69842,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69885 = cljs.core.cst$kw$transact_DASH_handler;
var G__69886 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69885,G__69886) : pred__69854.call(null,G__69885,G__69886));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__69842,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69887 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__69888 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69887,G__69888) : pred__69854.call(null,G__69887,G__69888));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__69842,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69889 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__69890 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69889,G__69890) : pred__69854.call(null,G__69889,G__69890));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__69842,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69891 = cljs.core.cst$kw$meta;
var G__69892 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69891,G__69892) : pred__69854.call(null,G__69891,G__69892));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__69842,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69893 = cljs.core.cst$kw$add_DASH_listener;
var G__69894 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69893,G__69894) : pred__69854.call(null,G__69893,G__69894));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__69842,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69895 = cljs.core.cst$kw$remove_DASH_listener;
var G__69896 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69895,G__69896) : pred__69854.call(null,G__69895,G__69896));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__69842,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__69897 = cljs.core.cst$kw$close;
var G__69898 = expr__69855;
return (pred__69854.cljs$core$IFn$_invoke$arity$2 ? pred__69854.cljs$core$IFn$_invoke$arity$2(G__69897,G__69898) : pred__69854.call(null,G__69897,G__69898));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__69842,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__69842),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__69842){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__69842,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__69846){
var extmap__4501__auto__ = (function (){var G__69899 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__69846,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__69846)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__69899);
} else {
return G__69899;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__69846),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__69846),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__69905 = servers_STAR_;
var vec__69906 = G__69905;
var seq__69907 = cljs.core.seq(vec__69906);
var first__69908 = cljs.core.first(seq__69907);
var seq__69907__$1 = cljs.core.next(seq__69907);
var server = first__69908;
var r = seq__69907__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__69905__$1 = G__69905;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__69912 = G__69905__$1;
var seq__69913 = cljs.core.seq(vec__69912);
var first__69914 = cljs.core.first(seq__69913);
var seq__69913__$1 = cljs.core.next(seq__69913);
var server__$1 = first__69914;
var r__$1 = seq__69913__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__4210__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__69915 = r__$1;
var G__69916 = is_https_QMARK_;
var G__69917 = result_STAR_;
G__69905__$1 = G__69915;
https_QMARK___$1 = G__69916;
result__$1 = G__69917;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__69918 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__69918 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__69918);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_69947){
var state_val_69948 = (state_69947[(1)]);
if((state_val_69948 === (7))){
var inst_69933 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_69934 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_69935 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_69936 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_69937 = fluree.db.connection.establish_socket(inst_69933,inst_69934,inst_69935,inst_69936);
var state_69947__$1 = state_69947;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69947__$1,(9),inst_69937);
} else {
if((state_val_69948 === (1))){
var state_69947__$1 = state_69947;
var statearr_69949_69968 = state_69947__$1;
(statearr_69949_69968[(2)] = null);

(statearr_69949_69968[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69948 === (4))){
var inst_69919 = (state_69947[(2)]);
var state_69947__$1 = state_69947;
var statearr_69950_69969 = state_69947__$1;
(statearr_69950_69969[(2)] = inst_69919);

(statearr_69950_69969[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69948 === (6))){
var inst_69930 = (state_69947[(7)]);
var state_69947__$1 = state_69947;
var statearr_69951_69970 = state_69947__$1;
(statearr_69951_69970[(2)] = inst_69930);

(statearr_69951_69970[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69948 === (3))){
var inst_69945 = (state_69947[(2)]);
var state_69947__$1 = state_69947;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69947__$1,inst_69945);
} else {
if((state_val_69948 === (2))){
var inst_69930 = (state_69947[(7)]);
var _ = (function (){var statearr_69953 = state_69947;
(statearr_69953[(4)] = cljs.core.cons((5),(state_69947[(4)])));

return statearr_69953;
})();
var inst_69925 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_69926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69927 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_69928 = [inst_69927,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_69929 = (new cljs.core.PersistentVector(null,3,(5),inst_69926,inst_69928,null));
var inst_69930__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_69925,inst_69929);
var state_69947__$1 = (function (){var statearr_69954 = state_69947;
(statearr_69954[(7)] = inst_69930__$1);

return statearr_69954;
})();
if(cljs.core.truth_(inst_69930__$1)){
var statearr_69955_69971 = state_69947__$1;
(statearr_69955_69971[(1)] = (6));

} else {
var statearr_69956_69972 = state_69947__$1;
(statearr_69956_69972[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69948 === (9))){
var inst_69939 = (state_69947[(2)]);
var inst_69940 = fluree.db.util.async.throw_err(inst_69939);
var state_69947__$1 = state_69947;
var statearr_69957_69973 = state_69947__$1;
(statearr_69957_69973[(2)] = inst_69940);

(statearr_69957_69973[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69948 === (5))){
var _ = (function (){var statearr_69958 = state_69947;
(statearr_69958[(4)] = cljs.core.rest((state_69947[(4)])));

return statearr_69958;
})();
var state_69947__$1 = state_69947;
var ex69952 = (state_69947__$1[(2)]);
var statearr_69959_69974 = state_69947__$1;
(statearr_69959_69974[(5)] = ex69952);


if((ex69952 instanceof Error)){
var statearr_69960_69975 = state_69947__$1;
(statearr_69960_69975[(1)] = (4));

(statearr_69960_69975[(5)] = null);

} else {
throw ex69952;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69948 === (8))){
var inst_69942 = (state_69947[(2)]);
var _ = (function (){var statearr_69961 = state_69947;
(statearr_69961[(4)] = cljs.core.rest((state_69947[(4)])));

return statearr_69961;
})();
var state_69947__$1 = state_69947;
var statearr_69962_69976 = state_69947__$1;
(statearr_69962_69976[(2)] = inst_69942);

(statearr_69962_69976[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__10750__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__10750__auto____0 = (function (){
var statearr_69963 = [null,null,null,null,null,null,null,null];
(statearr_69963[(0)] = fluree$db$connection$get_socket_$_state_machine__10750__auto__);

(statearr_69963[(1)] = (1));

return statearr_69963;
});
var fluree$db$connection$get_socket_$_state_machine__10750__auto____1 = (function (state_69947){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_69947);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e69964){var ex__10753__auto__ = e69964;
var statearr_69965_69977 = state_69947;
(statearr_69965_69977[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_69947[(4)]))){
var statearr_69966_69978 = state_69947;
(statearr_69966_69978[(1)] = cljs.core.first((state_69947[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__69979 = state_69947;
state_69947 = G__69979;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__10750__auto__ = function(state_69947){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__10750__auto____1.call(this,state_69947);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__10750__auto____0;
fluree$db$connection$get_socket_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__10750__auto____1;
return fluree$db$connection$get_socket_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_69967 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_69967[(6)] = c__10876__auto__);

return statearr_69967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e69980){var e = e69980;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4212__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_70107){
var state_val_70108 = (state_70107[(1)]);
if((state_val_70108 === (7))){
var inst_70103 = (state_70107[(2)]);
var state_70107__$1 = state_70107;
var statearr_70110_70180 = state_70107__$1;
(statearr_70110_70180[(2)] = inst_70103);

(statearr_70110_70180[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (20))){
var _ = (function (){var statearr_70111 = state_70107;
(statearr_70111[(4)] = cljs.core.rest((state_70107[(4)])));

return statearr_70111;
})();
var state_70107__$1 = state_70107;
var ex70109 = (state_70107__$1[(2)]);
var statearr_70112_70181 = state_70107__$1;
(statearr_70112_70181[(5)] = ex70109);


var statearr_70113_70182 = state_70107__$1;
(statearr_70113_70182[(1)] = (10));

(statearr_70113_70182[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (27))){
var inst_70095 = (state_70107[(2)]);
var _ = (function (){var statearr_70114 = state_70107;
(statearr_70114[(4)] = cljs.core.rest((state_70107[(4)])));

return statearr_70114;
})();
var state_70107__$1 = state_70107;
var statearr_70115_70183 = state_70107__$1;
(statearr_70115_70183[(2)] = inst_70095);

(statearr_70115_70183[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (1))){
var inst_69982 = (0);
var state_70107__$1 = (function (){var statearr_70116 = state_70107;
(statearr_70116[(7)] = inst_69982);

return statearr_70116;
})();
var statearr_70117_70184 = state_70107__$1;
(statearr_70117_70184[(2)] = null);

(statearr_70117_70184[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (24))){
var inst_70073 = (state_70107[(8)]);
var inst_70073__$1 = (state_70107[(2)]);
var inst_70074 = inst_70073__$1 === true;
var state_70107__$1 = (function (){var statearr_70118 = state_70107;
(statearr_70118[(8)] = inst_70073__$1);

return statearr_70118;
})();
if(cljs.core.truth_(inst_70074)){
var statearr_70119_70185 = state_70107__$1;
(statearr_70119_70185[(1)] = (25));

} else {
var statearr_70120_70186 = state_70107__$1;
(statearr_70120_70186[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (4))){
var inst_69985 = (state_70107[(9)]);
var inst_69985__$1 = (state_70107[(2)]);
var state_70107__$1 = (function (){var statearr_70121 = state_70107;
(statearr_70121[(9)] = inst_69985__$1);

return statearr_70121;
})();
if(cljs.core.truth_(inst_69985__$1)){
var statearr_70122_70187 = state_70107__$1;
(statearr_70122_70187[(1)] = (5));

} else {
var statearr_70123_70188 = state_70107__$1;
(statearr_70123_70188[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (15))){
var inst_69998 = (state_70107[(10)]);
var state_70107__$1 = state_70107;
var statearr_70124_70189 = state_70107__$1;
(statearr_70124_70189[(2)] = inst_69998);

(statearr_70124_70189[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (21))){
var inst_70024 = (state_70107[(11)]);
var inst_70029 = (state_70107[(12)]);
var inst_69985 = (state_70107[(9)]);
var inst_70030 = (state_70107[(13)]);
var inst_70025 = (state_70107[(14)]);
var inst_70023 = (state_70107[(15)]);
var inst_70026 = (state_70107[(16)]);
var inst_70021 = (state_70107[(17)]);
var inst_70022 = (state_70107[(18)]);
var inst_69982 = (state_70107[(7)]);
var inst_70032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70033 = [cljs.core.cst$kw$pending_DASH_req,inst_70029];
var inst_70034 = (new cljs.core.PersistentVector(null,2,(5),inst_70032,inst_70033,null));
var inst_70035 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_70034,inst_70024);
var inst_70062 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_70063 = (function (){var resp_chan = inst_70024;
var timeout = inst_70030;
var vec__70017 = inst_69985;
var i = inst_69982;
var data = inst_70023;
var _ = inst_70021;
var req_id = inst_70029;
var operation = inst_70022;
var c__10876__auto____$1 = inst_70062;
var msg = inst_69985;
var map__70020 = inst_70026;
var opts = inst_70025;
return (function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_70060){
var state_val_70061 = (state_70060[(1)]);
if((state_val_70061 === (1))){
var inst_70039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70040 = cljs.core.async.timeout(timeout);
var inst_70041 = [resp_chan,inst_70040];
var inst_70042 = (new cljs.core.PersistentVector(null,2,(5),inst_70039,inst_70041,null));
var state_70060__$1 = state_70060;
return cljs.core.async.ioc_alts_BANG_(state_70060__$1,(2),inst_70042);
} else {
if((state_val_70061 === (2))){
var inst_70045 = (state_70060[(7)]);
var inst_70044 = (state_70060[(2)]);
var inst_70045__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70044,(0),null);
var inst_70046 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70044,(1),null);
var inst_70047 = (function (){var vec__70036 = inst_70044;
var resp = inst_70045__$1;
var c = inst_70046;
return (function (p1__69981_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__69981_SHARP_,req_id);
});
})();
var inst_70048 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_70047);
var inst_70049 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_70046,resp_chan);
var state_70060__$1 = (function (){var statearr_70125 = state_70060;
(statearr_70125[(7)] = inst_70045__$1);

(statearr_70125[(8)] = inst_70048);

return statearr_70125;
})();
if(inst_70049){
var statearr_70126_70190 = state_70060__$1;
(statearr_70126_70190[(1)] = (3));

} else {
var statearr_70127_70191 = state_70060__$1;
(statearr_70127_70191[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70061 === (3))){
var inst_70045 = (state_70060[(7)]);
var state_70060__$1 = state_70060;
var statearr_70128_70192 = state_70060__$1;
(statearr_70128_70192[(2)] = inst_70045);

(statearr_70128_70192[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70061 === (4))){
var inst_70052 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_70053 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_70054 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_70055 = cljs.core.PersistentHashMap.fromArrays(inst_70053,inst_70054);
var inst_70056 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70052,inst_70055);
var state_70060__$1 = state_70060;
var statearr_70129_70193 = state_70060__$1;
(statearr_70129_70193[(2)] = inst_70056);

(statearr_70129_70193[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70061 === (5))){
var inst_70058 = (state_70060[(2)]);
var state_70060__$1 = state_70060;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70060__$1,inst_70058);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__10750__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__10750__auto____0 = (function (){
var statearr_70130 = [null,null,null,null,null,null,null,null,null];
(statearr_70130[(0)] = fluree$db$connection$msg_producer_$_state_machine__10750__auto__);

(statearr_70130[(1)] = (1));

return statearr_70130;
});
var fluree$db$connection$msg_producer_$_state_machine__10750__auto____1 = (function (state_70060){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_70060);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e70131){var ex__10753__auto__ = e70131;
var statearr_70132_70194 = state_70060;
(statearr_70132_70194[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_70060[(4)]))){
var statearr_70133_70195 = state_70060;
(statearr_70133_70195[(1)] = cljs.core.first((state_70060[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__70196 = state_70060;
state_70060 = G__70196;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__10750__auto__ = function(state_70060){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__10750__auto____1.call(this,state_70060);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__10750__auto____0;
fluree$db$connection$msg_producer_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__10750__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_70134 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_70134[(6)] = c__10876__auto____$1);

return statearr_70134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
});
})();
var inst_70064 = cljs.core.async.impl.dispatch.run(inst_70063);
var state_70107__$1 = (function (){var statearr_70135 = state_70107;
(statearr_70135[(19)] = inst_70035);

(statearr_70135[(20)] = inst_70064);

return statearr_70135;
})();
var statearr_70136_70197 = state_70107__$1;
(statearr_70136_70197[(2)] = inst_70062);

(statearr_70136_70197[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (31))){
var inst_70083 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_70107__$1 = state_70107;
var statearr_70137_70198 = state_70107__$1;
(statearr_70137_70198[(2)] = inst_70083);

(statearr_70137_70198[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (32))){
var state_70107__$1 = state_70107;
var statearr_70138_70199 = state_70107__$1;
(statearr_70138_70199[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (33))){
var inst_70091 = (state_70107[(2)]);
var state_70107__$1 = state_70107;
var statearr_70140_70200 = state_70107__$1;
(statearr_70140_70200[(2)] = inst_70091);

(statearr_70140_70200[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (13))){
var inst_69998 = (state_70107[(10)]);
var inst_69995 = (state_70107[(2)]);
var inst_69996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69995,(0),null);
var inst_69997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69995,(1),null);
var inst_69998__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69995,(2),null);
var state_70107__$1 = (function (){var statearr_70141 = state_70107;
(statearr_70141[(21)] = inst_69996);

(statearr_70141[(22)] = inst_69997);

(statearr_70141[(10)] = inst_69998__$1);

return statearr_70141;
})();
if(cljs.core.truth_(inst_69998__$1)){
var statearr_70142_70201 = state_70107__$1;
(statearr_70142_70201[(1)] = (14));

} else {
var statearr_70143_70202 = state_70107__$1;
(statearr_70143_70202[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (22))){
var state_70107__$1 = state_70107;
var statearr_70144_70203 = state_70107__$1;
(statearr_70144_70203[(2)] = null);

(statearr_70144_70203[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (36))){
var inst_70089 = (state_70107[(2)]);
var state_70107__$1 = state_70107;
var statearr_70145_70204 = state_70107__$1;
(statearr_70145_70204[(2)] = inst_70089);

(statearr_70145_70204[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (29))){
var inst_70073 = (state_70107[(8)]);
var inst_70081 = (inst_70073 == null);
var state_70107__$1 = state_70107;
if(cljs.core.truth_(inst_70081)){
var statearr_70146_70205 = state_70107__$1;
(statearr_70146_70205[(1)] = (31));

} else {
var statearr_70147_70206 = state_70107__$1;
(statearr_70147_70206[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (6))){
var state_70107__$1 = state_70107;
var statearr_70148_70207 = state_70107__$1;
(statearr_70148_70207[(2)] = null);

(statearr_70148_70207[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (28))){
var inst_70073 = (state_70107[(8)]);
var inst_70079 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70073,"Error processing message in producer."], 0));
var state_70107__$1 = state_70107;
var statearr_70149_70208 = state_70107__$1;
(statearr_70149_70208[(2)] = inst_70079);

(statearr_70149_70208[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (25))){
var state_70107__$1 = state_70107;
var statearr_70150_70209 = state_70107__$1;
(statearr_70150_70209[(2)] = null);

(statearr_70150_70209[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (34))){
var inst_70073 = (state_70107[(8)]);
var inst_70086 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_70073], 0));
var state_70107__$1 = state_70107;
var statearr_70151_70210 = state_70107__$1;
(statearr_70151_70210[(2)] = inst_70086);

(statearr_70151_70210[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (17))){
var inst_69987 = (state_70107[(23)]);
var inst_69998 = (state_70107[(10)]);
var inst_70005 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69998,inst_69987);
var state_70107__$1 = state_70107;
var statearr_70152_70211 = state_70107__$1;
(statearr_70152_70211[(2)] = inst_70005);

(statearr_70152_70211[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (3))){
var inst_70105 = (state_70107[(2)]);
var state_70107__$1 = state_70107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70107__$1,inst_70105);
} else {
if((state_val_70108 === (12))){
var state_70107__$1 = state_70107;
var statearr_70153_70212 = state_70107__$1;
(statearr_70153_70212[(2)] = null);

(statearr_70153_70212[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (2))){
var state_70107__$1 = state_70107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70107__$1,(4),req_chan);
} else {
if((state_val_70108 === (23))){
var inst_70029 = (state_70107[(12)]);
var inst_70023 = (state_70107[(15)]);
var inst_70022 = (state_70107[(18)]);
var inst_70067 = (state_70107[(2)]);
var inst_70068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70069 = [inst_70022,inst_70029,inst_70023];
var inst_70070 = (new cljs.core.PersistentVector(null,3,(5),inst_70068,inst_70069,null));
var inst_70071 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_70070) : publish_fn.call(null,conn,inst_70070));
var state_70107__$1 = (function (){var statearr_70154 = state_70107;
(statearr_70154[(24)] = inst_70067);

return statearr_70154;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70107__$1,(24),inst_70071);
} else {
if((state_val_70108 === (35))){
var state_70107__$1 = state_70107;
var statearr_70155_70213 = state_70107__$1;
(statearr_70155_70213[(2)] = null);

(statearr_70155_70213[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (19))){
var inst_70011 = (state_70107[(2)]);
var state_70107__$1 = state_70107;
var statearr_70156_70214 = state_70107__$1;
(statearr_70156_70214[(2)] = inst_70011);

(statearr_70156_70214[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (11))){
var inst_69985 = (state_70107[(9)]);
var state_70107__$1 = state_70107;
var statearr_70157_70215 = state_70107__$1;
(statearr_70157_70215[(2)] = inst_69985);

(statearr_70157_70215[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (9))){
var inst_69982 = (state_70107[(7)]);
var inst_70098 = (state_70107[(2)]);
var inst_70099 = (inst_69982 + (1));
var inst_69982__$1 = inst_70099;
var state_70107__$1 = (function (){var statearr_70158 = state_70107;
(statearr_70158[(25)] = inst_70098);

(statearr_70158[(7)] = inst_69982__$1);

return statearr_70158;
})();
var statearr_70159_70216 = state_70107__$1;
(statearr_70159_70216[(2)] = null);

(statearr_70159_70216[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (5))){
var state_70107__$1 = state_70107;
var statearr_70160_70217 = state_70107__$1;
(statearr_70160_70217[(2)] = null);

(statearr_70160_70217[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (14))){
var inst_69998 = (state_70107[(10)]);
var inst_70000 = fluree.db.util.async.channel_QMARK_(inst_69998);
var state_70107__$1 = state_70107;
var statearr_70161_70218 = state_70107__$1;
(statearr_70161_70218[(2)] = inst_70000);

(statearr_70161_70218[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (26))){
var inst_70073 = (state_70107[(8)]);
var inst_70077 = fluree.db.util.core.exception_QMARK_(inst_70073);
var state_70107__$1 = state_70107;
if(inst_70077){
var statearr_70162_70219 = state_70107__$1;
(statearr_70162_70219[(1)] = (28));

} else {
var statearr_70163_70220 = state_70107__$1;
(statearr_70163_70220[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (16))){
var inst_70003 = (state_70107[(2)]);
var state_70107__$1 = state_70107;
if(cljs.core.truth_(inst_70003)){
var statearr_70164_70221 = state_70107__$1;
(statearr_70164_70221[(1)] = (17));

} else {
var statearr_70165_70222 = state_70107__$1;
(statearr_70165_70222[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (30))){
var inst_70093 = (state_70107[(2)]);
var state_70107__$1 = state_70107;
var statearr_70166_70223 = state_70107__$1;
(statearr_70166_70223[(2)] = inst_70093);

(statearr_70166_70223[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (10))){
var inst_69985 = (state_70107[(9)]);
var inst_69987 = (state_70107[(2)]);
var inst_69991 = cljs.core.sequential_QMARK_(inst_69985);
var state_70107__$1 = (function (){var statearr_70167 = state_70107;
(statearr_70167[(23)] = inst_69987);

return statearr_70167;
})();
if(inst_69991){
var statearr_70168_70224 = state_70107__$1;
(statearr_70168_70224[(1)] = (11));

} else {
var statearr_70169_70225 = state_70107__$1;
(statearr_70169_70225[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (18))){
var inst_69985 = (state_70107[(9)]);
var inst_69987 = (state_70107[(23)]);
var inst_70007 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69985], 0));
var inst_70008 = ["Error processing ledger request, no valid return channel: ",inst_70007].join('');
var inst_70009 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69987,inst_70008], 0));
var state_70107__$1 = state_70107;
var statearr_70170_70226 = state_70107__$1;
(statearr_70170_70226[(2)] = inst_70009);

(statearr_70170_70226[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70108 === (8))){
var inst_70024 = (state_70107[(11)]);
var inst_69985 = (state_70107[(9)]);
var inst_70025 = (state_70107[(14)]);
var inst_70026 = (state_70107[(16)]);
var _ = (function (){var statearr_70171 = state_70107;
(statearr_70171[(4)] = cljs.core.cons((20),(state_70107[(4)])));

return statearr_70171;
})();
var inst_70021 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_69985], 0));
var inst_70022 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69985,(0),null);
var inst_70023 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69985,(1),null);
var inst_70024__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69985,(2),null);
var inst_70025__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69985,(3),null);
var inst_70026__$1 = cljs.core.__destructure_map(inst_70025__$1);
var inst_70027 = fluree.db.util.core.random_uuid();
var inst_70028 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70027);
var inst_70029 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_70026__$1,cljs.core.cst$kw$req_DASH_id,inst_70028);
var inst_70030 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_70026__$1,cljs.core.cst$kw$timeout,(60000));
var state_70107__$1 = (function (){var statearr_70172 = state_70107;
(statearr_70172[(11)] = inst_70024__$1);

(statearr_70172[(12)] = inst_70029);

(statearr_70172[(13)] = inst_70030);

(statearr_70172[(14)] = inst_70025__$1);

(statearr_70172[(15)] = inst_70023);

(statearr_70172[(16)] = inst_70026__$1);

(statearr_70172[(17)] = inst_70021);

(statearr_70172[(18)] = inst_70022);

return statearr_70172;
})();
if(cljs.core.truth_(inst_70024__$1)){
var statearr_70173_70227 = state_70107__$1;
(statearr_70173_70227[(1)] = (21));

} else {
var statearr_70174_70228 = state_70107__$1;
(statearr_70174_70228[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__10750__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__10750__auto____0 = (function (){
var statearr_70175 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70175[(0)] = fluree$db$connection$msg_producer_$_state_machine__10750__auto__);

(statearr_70175[(1)] = (1));

return statearr_70175;
});
var fluree$db$connection$msg_producer_$_state_machine__10750__auto____1 = (function (state_70107){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_70107);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e70176){var ex__10753__auto__ = e70176;
var statearr_70177_70229 = state_70107;
(statearr_70177_70229[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_70107[(4)]))){
var statearr_70178_70230 = state_70107;
(statearr_70178_70230[(1)] = cljs.core.first((state_70107[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__70231 = state_70107;
state_70107 = G__70231;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__10750__auto__ = function(state_70107){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__10750__auto____1.call(this,state_70107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__10750__auto____0;
fluree$db$connection$msg_producer_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__10750__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_70179 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_70179[(6)] = c__10876__auto__);

return statearr_70179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__70232 = conn;
var map__70232__$1 = cljs.core.__destructure_map(map__70232);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70232__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_70317){
var state_val_70318 = (state_70317[(1)]);
if((state_val_70318 === (7))){
var inst_70313 = (state_70317[(2)]);
var state_70317__$1 = state_70317;
var statearr_70319_70370 = state_70317__$1;
(statearr_70319_70370[(2)] = inst_70313);

(statearr_70319_70370[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (20))){
var inst_70251 = (state_70317[(7)]);
var inst_70265 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_70266 = [inst_70251];
var inst_70267 = cljs.core.PersistentHashMap.fromArrays(inst_70265,inst_70266);
var inst_70268 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_70267], 0));
var state_70317__$1 = state_70317;
var statearr_70320_70371 = state_70317__$1;
(statearr_70320_70371[(2)] = inst_70268);

(statearr_70320_70371[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (27))){
var state_70317__$1 = state_70317;
var statearr_70321_70372 = state_70317__$1;
(statearr_70321_70372[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (1))){
var inst_70233 = (0);
var state_70317__$1 = (function (){var statearr_70323 = state_70317;
(statearr_70323[(8)] = inst_70233);

return statearr_70323;
})();
var statearr_70324_70373 = state_70317__$1;
(statearr_70324_70373[(2)] = null);

(statearr_70324_70373[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (24))){
var inst_70244 = (state_70317[(9)]);
var inst_70293 = fluree.db.util.core.exception_QMARK_(inst_70244);
var state_70317__$1 = state_70317;
if(inst_70293){
var statearr_70325_70374 = state_70317__$1;
(statearr_70325_70374[(1)] = (26));

} else {
var statearr_70326_70375 = state_70317__$1;
(statearr_70326_70375[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (4))){
var inst_70238 = (state_70317[(10)]);
var inst_70243 = (state_70317[(2)]);
var inst_70244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70243,(0),null);
var inst_70245 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70243,(1),null);
var inst_70246 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_70245,inst_70238);
var state_70317__$1 = (function (){var statearr_70327 = state_70317;
(statearr_70327[(9)] = inst_70244);

return statearr_70327;
})();
if(inst_70246){
var statearr_70328_70376 = state_70317__$1;
(statearr_70328_70376[(1)] = (5));

} else {
var statearr_70329_70377 = state_70317__$1;
(statearr_70329_70377[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (15))){
var inst_70251 = (state_70317[(7)]);
var inst_70260 = typeof inst_70251 === 'string';
var state_70317__$1 = state_70317;
if(cljs.core.truth_(inst_70260)){
var statearr_70330_70378 = state_70317__$1;
(statearr_70330_70378[(1)] = (17));

} else {
var statearr_70331_70379 = state_70317__$1;
(statearr_70331_70379[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (21))){
var state_70317__$1 = state_70317;
var statearr_70332_70380 = state_70317__$1;
(statearr_70332_70380[(2)] = null);

(statearr_70332_70380[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (31))){
var inst_70307 = (state_70317[(2)]);
var state_70317__$1 = state_70317;
var statearr_70333_70381 = state_70317__$1;
(statearr_70333_70381[(2)] = inst_70307);

(statearr_70333_70381[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (13))){
var inst_70277 = (state_70317[(2)]);
var inst_70278 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_70279 = fluree.db.connection.close_websocket(inst_70278);
var inst_70280 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_70281 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_70280);
var state_70317__$1 = (function (){var statearr_70334 = state_70317;
(statearr_70334[(11)] = inst_70279);

(statearr_70334[(12)] = inst_70277);

return statearr_70334;
})();
var statearr_70335_70382 = state_70317__$1;
(statearr_70335_70382[(2)] = inst_70281);

(statearr_70335_70382[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (22))){
var inst_70271 = (state_70317[(2)]);
var state_70317__$1 = state_70317;
var statearr_70336_70383 = state_70317__$1;
(statearr_70336_70383[(2)] = inst_70271);

(statearr_70336_70383[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (29))){
var inst_70244 = (state_70317[(9)]);
var inst_70299 = fluree.db.util.json.parse(inst_70244);
var inst_70300 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70299], 0));
var inst_70301 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_70300], 0));
var inst_70302 = fluree.db.util.json.parse(inst_70244);
var inst_70303 = fluree.db.conn_events.process_events(conn,inst_70302);
var inst_70233 = (0);
var state_70317__$1 = (function (){var statearr_70337 = state_70317;
(statearr_70337[(13)] = inst_70303);

(statearr_70337[(14)] = inst_70301);

(statearr_70337[(8)] = inst_70233);

return statearr_70337;
})();
var statearr_70338_70384 = state_70317__$1;
(statearr_70338_70384[(2)] = null);

(statearr_70338_70384[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (6))){
var inst_70244 = (state_70317[(9)]);
var inst_70289 = (inst_70244 == null);
var state_70317__$1 = state_70317;
if(cljs.core.truth_(inst_70289)){
var statearr_70339_70385 = state_70317__$1;
(statearr_70339_70385[(1)] = (23));

} else {
var statearr_70340_70386 = state_70317__$1;
(statearr_70340_70386[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (28))){
var inst_70309 = (state_70317[(2)]);
var state_70317__$1 = state_70317;
var statearr_70341_70387 = state_70317__$1;
(statearr_70341_70387[(2)] = inst_70309);

(statearr_70341_70387[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (25))){
var inst_70311 = (state_70317[(2)]);
var state_70317__$1 = state_70317;
var statearr_70342_70388 = state_70317__$1;
(statearr_70342_70388[(2)] = inst_70311);

(statearr_70342_70388[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (17))){
var inst_70251 = (state_70317[(7)]);
var inst_70262 = cljs.core.eval(inst_70251);
var state_70317__$1 = state_70317;
var statearr_70343_70389 = state_70317__$1;
(statearr_70343_70389[(2)] = inst_70262);

(statearr_70343_70389[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (3))){
var inst_70315 = (state_70317[(2)]);
var state_70317__$1 = state_70317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70317__$1,inst_70315);
} else {
if((state_val_70318 === (12))){
var inst_70251 = (state_70317[(7)]);
var inst_70256 = cljs.core.fn_QMARK_(inst_70251);
var state_70317__$1 = state_70317;
if(inst_70256){
var statearr_70344_70390 = state_70317__$1;
(statearr_70344_70390[(1)] = (14));

} else {
var statearr_70345_70391 = state_70317__$1;
(statearr_70345_70391[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (2))){
var inst_70238 = (state_70317[(10)]);
var inst_70238__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_70239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70240 = [sub_chan,inst_70238__$1];
var inst_70241 = (new cljs.core.PersistentVector(null,2,(5),inst_70239,inst_70240,null));
var state_70317__$1 = (function (){var statearr_70346 = state_70317;
(statearr_70346[(10)] = inst_70238__$1);

return statearr_70346;
})();
return cljs.core.async.ioc_alts_BANG_(state_70317__$1,(4),inst_70241);
} else {
if((state_val_70318 === (23))){
var inst_70291 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_70317__$1 = state_70317;
var statearr_70347_70392 = state_70317__$1;
(statearr_70347_70392[(2)] = inst_70291);

(statearr_70347_70392[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (19))){
var inst_70273 = (state_70317[(2)]);
var state_70317__$1 = state_70317;
var statearr_70348_70393 = state_70317__$1;
(statearr_70348_70393[(2)] = inst_70273);

(statearr_70348_70393[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (11))){
var inst_70254 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_70317__$1 = state_70317;
var statearr_70349_70394 = state_70317__$1;
(statearr_70349_70394[(2)] = inst_70254);

(statearr_70349_70394[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (9))){
var inst_70233 = (state_70317[(8)]);
var inst_70283 = fluree.db.connection.ping_transactor(conn);
var inst_70284 = (inst_70233 + (1));
var inst_70233__$1 = inst_70284;
var state_70317__$1 = (function (){var statearr_70350 = state_70317;
(statearr_70350[(15)] = inst_70283);

(statearr_70350[(8)] = inst_70233__$1);

return statearr_70350;
})();
var statearr_70351_70395 = state_70317__$1;
(statearr_70351_70395[(2)] = null);

(statearr_70351_70395[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (5))){
var inst_70233 = (state_70317[(8)]);
var inst_70248 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_70233);
var state_70317__$1 = state_70317;
if(inst_70248){
var statearr_70352_70396 = state_70317__$1;
(statearr_70352_70396[(1)] = (8));

} else {
var statearr_70353_70397 = state_70317__$1;
(statearr_70353_70397[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (14))){
var inst_70251 = (state_70317[(7)]);
var inst_70258 = (inst_70251.cljs$core$IFn$_invoke$arity$0 ? inst_70251.cljs$core$IFn$_invoke$arity$0() : inst_70251.call(null));
var state_70317__$1 = state_70317;
var statearr_70354_70398 = state_70317__$1;
(statearr_70354_70398[(2)] = inst_70258);

(statearr_70354_70398[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (26))){
var inst_70244 = (state_70317[(9)]);
var inst_70295 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70244], 0));
var inst_70233 = (0);
var state_70317__$1 = (function (){var statearr_70355 = state_70317;
(statearr_70355[(16)] = inst_70295);

(statearr_70355[(8)] = inst_70233);

return statearr_70355;
})();
var statearr_70356_70399 = state_70317__$1;
(statearr_70356_70399[(2)] = null);

(statearr_70356_70399[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (16))){
var inst_70275 = (state_70317[(2)]);
var state_70317__$1 = state_70317;
var statearr_70357_70400 = state_70317__$1;
(statearr_70357_70400[(2)] = inst_70275);

(statearr_70357_70400[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (30))){
var state_70317__$1 = state_70317;
var statearr_70358_70401 = state_70317__$1;
(statearr_70358_70401[(2)] = null);

(statearr_70358_70401[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (10))){
var inst_70287 = (state_70317[(2)]);
var state_70317__$1 = state_70317;
var statearr_70359_70402 = state_70317__$1;
(statearr_70359_70402[(2)] = inst_70287);

(statearr_70359_70402[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (18))){
var state_70317__$1 = state_70317;
var statearr_70360_70403 = state_70317__$1;
(statearr_70360_70403[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_70318 === (8))){
var inst_70251 = (state_70317[(7)]);
var inst_70250 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_70251__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_70252 = (inst_70251__$1 == null);
var state_70317__$1 = (function (){var statearr_70362 = state_70317;
(statearr_70362[(7)] = inst_70251__$1);

(statearr_70362[(17)] = inst_70250);

return statearr_70362;
})();
if(cljs.core.truth_(inst_70252)){
var statearr_70363_70404 = state_70317__$1;
(statearr_70363_70404[(1)] = (11));

} else {
var statearr_70364_70405 = state_70317__$1;
(statearr_70364_70405[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__10750__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__10750__auto____0 = (function (){
var statearr_70365 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70365[(0)] = fluree$db$connection$msg_consumer_$_state_machine__10750__auto__);

(statearr_70365[(1)] = (1));

return statearr_70365;
});
var fluree$db$connection$msg_consumer_$_state_machine__10750__auto____1 = (function (state_70317){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_70317);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e70366){var ex__10753__auto__ = e70366;
var statearr_70367_70406 = state_70317;
(statearr_70367_70406[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_70317[(4)]))){
var statearr_70368_70407 = state_70317;
(statearr_70368_70407[(1)] = cljs.core.first((state_70317[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__70408 = state_70317;
state_70317 = G__70408;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__10750__auto__ = function(state_70317){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__10750__auto____1.call(this,state_70317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__10750__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__10750__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_70369 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_70369[(6)] = c__10876__auto__);

return statearr_70369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__70410 = arguments.length;
switch (G__70410) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__70411 = opts;
var map__70411__$1 = cljs.core.__destructure_map(map__70411);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70411__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70411__$1,cljs.core.cst$kw$jwt);
return (function (k){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_70463){
var state_val_70464 = (state_70463[(1)]);
if((state_val_70464 === (7))){
var inst_70421 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_70422 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70423 = [conn_id,cljs.core.cst$kw$token];
var inst_70424 = (new cljs.core.PersistentVector(null,2,(5),inst_70422,inst_70423,null));
var inst_70425 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_70421,inst_70424);
var state_70463__$1 = state_70463;
var statearr_70465_70496 = state_70463__$1;
(statearr_70465_70496[(2)] = inst_70425);

(statearr_70465_70496[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (1))){
var state_70463__$1 = state_70463;
var statearr_70466_70497 = state_70463__$1;
(statearr_70466_70497[(2)] = null);

(statearr_70466_70497[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (4))){
var inst_70412 = (state_70463[(2)]);
var state_70463__$1 = state_70463;
var statearr_70467_70498 = state_70463__$1;
(statearr_70467_70498[(2)] = inst_70412);

(statearr_70467_70498[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (15))){
var inst_70432 = (state_70463[(7)]);
var inst_70451 = (state_70463[(2)]);
var inst_70452 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_70453 = [(5000),inst_70451,cljs.core.cst$kw$json];
var inst_70454 = cljs.core.PersistentHashMap.fromArrays(inst_70452,inst_70453);
var inst_70455 = fluree.db.util.xhttp.get(inst_70432,inst_70454);
var state_70463__$1 = state_70463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70463__$1,(16),inst_70455);
} else {
if((state_val_70464 === (13))){
var inst_70442 = (state_70463[(8)]);
var inst_70432 = (state_70463[(7)]);
var inst_70444 = [cljs.core.cst$kw$headers];
var inst_70445 = [inst_70442];
var inst_70446 = cljs.core.PersistentHashMap.fromArrays(inst_70444,inst_70445);
var inst_70447 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_70432,inst_70446,private$);
var inst_70448 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_70447);
var state_70463__$1 = state_70463;
var statearr_70468_70499 = state_70463__$1;
(statearr_70468_70499[(2)] = inst_70448);

(statearr_70468_70499[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (6))){
var inst_70418 = (state_70463[(9)]);
var state_70463__$1 = state_70463;
var statearr_70469_70500 = state_70463__$1;
(statearr_70469_70500[(2)] = inst_70418);

(statearr_70469_70500[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (3))){
var inst_70461 = (state_70463[(2)]);
var state_70463__$1 = state_70463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70463__$1,inst_70461);
} else {
if((state_val_70464 === (12))){
var inst_70442 = (state_70463[(2)]);
var state_70463__$1 = (function (){var statearr_70470 = state_70463;
(statearr_70470[(8)] = inst_70442);

return statearr_70470;
})();
if(cljs.core.truth_(private$)){
var statearr_70471_70501 = state_70463__$1;
(statearr_70471_70501[(1)] = (13));

} else {
var statearr_70472_70502 = state_70463__$1;
(statearr_70472_70502[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (2))){
var inst_70418 = (state_70463[(9)]);
var _ = (function (){var statearr_70473 = state_70463;
(statearr_70473[(4)] = cljs.core.cons((5),(state_70463[(4)])));

return statearr_70473;
})();
var inst_70418__$1 = jwt;
var state_70463__$1 = (function (){var statearr_70474 = state_70463;
(statearr_70474[(9)] = inst_70418__$1);

return statearr_70474;
})();
if(cljs.core.truth_(inst_70418__$1)){
var statearr_70475_70503 = state_70463__$1;
(statearr_70475_70503[(1)] = (6));

} else {
var statearr_70476_70504 = state_70463__$1;
(statearr_70476_70504[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (11))){
var inst_70436 = (state_70463[(10)]);
var state_70463__$1 = state_70463;
var statearr_70478_70505 = state_70463__$1;
(statearr_70478_70505[(2)] = inst_70436);

(statearr_70478_70505[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (9))){
var inst_70427 = (state_70463[(11)]);
var inst_70428 = (state_70463[(12)]);
var inst_70431 = (state_70463[(2)]);
var inst_70432 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70431),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70428)].join('');
var inst_70434 = ["Accept"];
var inst_70435 = ["application/json"];
var inst_70436 = cljs.core.PersistentHashMap.fromArrays(inst_70434,inst_70435);
var state_70463__$1 = (function (){var statearr_70479 = state_70463;
(statearr_70479[(10)] = inst_70436);

(statearr_70479[(7)] = inst_70432);

return statearr_70479;
})();
if(cljs.core.truth_(inst_70427)){
var statearr_70480_70506 = state_70463__$1;
(statearr_70480_70506[(1)] = (10));

} else {
var statearr_70481_70507 = state_70463__$1;
(statearr_70481_70507[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (5))){
var _ = (function (){var statearr_70482 = state_70463;
(statearr_70482[(4)] = cljs.core.rest((state_70463[(4)])));

return statearr_70482;
})();
var state_70463__$1 = state_70463;
var ex70477 = (state_70463__$1[(2)]);
var statearr_70483_70508 = state_70463__$1;
(statearr_70483_70508[(5)] = ex70477);


if((ex70477 instanceof Error)){
var statearr_70484_70509 = state_70463__$1;
(statearr_70484_70509[(1)] = (4));

(statearr_70484_70509[(5)] = null);

} else {
throw ex70477;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (14))){
var inst_70442 = (state_70463[(8)]);
var state_70463__$1 = state_70463;
var statearr_70485_70510 = state_70463__$1;
(statearr_70485_70510[(2)] = inst_70442);

(statearr_70485_70510[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (16))){
var inst_70457 = (state_70463[(2)]);
var inst_70458 = fluree.db.util.async.throw_err(inst_70457);
var _ = (function (){var statearr_70486 = state_70463;
(statearr_70486[(4)] = cljs.core.rest((state_70463[(4)])));

return statearr_70486;
})();
var state_70463__$1 = state_70463;
var statearr_70487_70511 = state_70463__$1;
(statearr_70487_70511[(2)] = inst_70458);

(statearr_70487_70511[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (10))){
var inst_70436 = (state_70463[(10)]);
var inst_70427 = (state_70463[(11)]);
var inst_70438 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70427)].join('');
var inst_70439 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_70436,"Authorization",inst_70438);
var state_70463__$1 = state_70463;
var statearr_70488_70512 = state_70463__$1;
(statearr_70488_70512[(2)] = inst_70439);

(statearr_70488_70512[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70464 === (8))){
var inst_70427 = (state_70463[(2)]);
var inst_70428 = clojure.string.replace(k,"_","/");
var inst_70429 = fluree.db.connection.get_server(conn_id,servers);
var state_70463__$1 = (function (){var statearr_70489 = state_70463;
(statearr_70489[(11)] = inst_70427);

(statearr_70489[(12)] = inst_70428);

return statearr_70489;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70463__$1,(9),inst_70429);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__10750__auto__ = null;
var fluree$db$connection$state_machine__10750__auto____0 = (function (){
var statearr_70490 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70490[(0)] = fluree$db$connection$state_machine__10750__auto__);

(statearr_70490[(1)] = (1));

return statearr_70490;
});
var fluree$db$connection$state_machine__10750__auto____1 = (function (state_70463){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_70463);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e70491){var ex__10753__auto__ = e70491;
var statearr_70492_70513 = state_70463;
(statearr_70492_70513[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_70463[(4)]))){
var statearr_70493_70514 = state_70463;
(statearr_70493_70514[(1)] = cljs.core.first((state_70463[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__70515 = state_70463;
state_70463 = G__70515;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$connection$state_machine__10750__auto__ = function(state_70463){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__10750__auto____1.call(this,state_70463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__10750__auto____0;
fluree$db$connection$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__10750__auto____1;
return fluree$db$connection$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_70494 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_70494[(6)] = c__10876__auto__);

return statearr_70494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__70516_SHARP_){
if(cljs.core.truth_(p1__70516_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),(function (p1__70517_SHARP_){
var or__4212__auto__ = p1__70517_SHARP_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return token;
}
}));

return true;
}catch (e70518){var e = e70518;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__70519 = opts;
var map__70519__$1 = cljs.core.__destructure_map(map__70519);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70519__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70519__$1,cljs.core.cst$kw$parallelism,(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70519__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70519__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70519__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70519__$1,cljs.core.cst$kw$storage_DASH_write,(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70519__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70519__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70519__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70519__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,cljs.core.cst$kw$storage_DASH_list);
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4212__auto__ = object_cache;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4212__auto__ = storage_read;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4212__auto__ = storage_exists;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = storage_read;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4210__auto__ = storage_write;
if(cljs.core.truth_(and__4210__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4210__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_list,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__70520_70521 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__70520_70521.cljs$core$IFn$_invoke$arity$0 ? fexpr__70520_70521.cljs$core$IFn$_invoke$arity$0() : fexpr__70520_70521.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70562 = arguments.length;
var i__4819__auto___70563 = (0);
while(true){
if((i__4819__auto___70563 < len__4818__auto___70562)){
args__4824__auto__.push((arguments[i__4819__auto___70563]));

var G__70564 = (i__4819__auto___70563 + (1));
i__4819__auto___70563 = G__70564;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__70524){
var vec__70525 = p__70524;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70525,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__10876__auto___70565 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_70545){
var state_val_70546 = (state_70545[(1)]);
if((state_val_70546 === (1))){
var inst_70528 = fluree.db.connection.get_socket(conn);
var state_70545__$1 = state_70545;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70545__$1,(2),inst_70528);
} else {
if((state_val_70546 === (2))){
var inst_70531 = (state_70545[(7)]);
var inst_70530 = (state_70545[(8)]);
var inst_70530__$1 = (state_70545[(2)]);
var inst_70531__$1 = (inst_70530__$1 == null);
var state_70545__$1 = (function (){var statearr_70547 = state_70545;
(statearr_70547[(7)] = inst_70531__$1);

(statearr_70547[(8)] = inst_70530__$1);

return statearr_70547;
})();
if(cljs.core.truth_(inst_70531__$1)){
var statearr_70548_70566 = state_70545__$1;
(statearr_70548_70566[(1)] = (3));

} else {
var statearr_70549_70567 = state_70545__$1;
(statearr_70549_70567[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70546 === (3))){
var inst_70531 = (state_70545[(7)]);
var state_70545__$1 = state_70545;
var statearr_70550_70568 = state_70545__$1;
(statearr_70550_70568[(2)] = inst_70531);

(statearr_70550_70568[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70546 === (4))){
var inst_70530 = (state_70545[(8)]);
var inst_70534 = fluree.db.util.core.exception_QMARK_(inst_70530);
var state_70545__$1 = state_70545;
var statearr_70551_70569 = state_70545__$1;
(statearr_70551_70569[(2)] = inst_70534);

(statearr_70551_70569[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70546 === (5))){
var inst_70536 = (state_70545[(2)]);
var state_70545__$1 = state_70545;
if(cljs.core.truth_(inst_70536)){
var statearr_70552_70570 = state_70545__$1;
(statearr_70552_70570[(1)] = (6));

} else {
var statearr_70553_70571 = state_70545__$1;
(statearr_70553_70571[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70546 === (6))){
var inst_70530 = (state_70545[(8)]);
var inst_70538 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70530,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_70539 = cljs.core.async.close_BANG_(conn);
var state_70545__$1 = (function (){var statearr_70554 = state_70545;
(statearr_70554[(9)] = inst_70538);

return statearr_70554;
})();
var statearr_70555_70572 = state_70545__$1;
(statearr_70555_70572[(2)] = inst_70539);

(statearr_70555_70572[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70546 === (7))){
var inst_70541 = fluree.db.connection.msg_consumer(conn);
var state_70545__$1 = state_70545;
var statearr_70556_70573 = state_70545__$1;
(statearr_70556_70573[(2)] = inst_70541);

(statearr_70556_70573[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70546 === (8))){
var inst_70543 = (state_70545[(2)]);
var state_70545__$1 = state_70545;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70545__$1,inst_70543);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__10750__auto__ = null;
var fluree$db$connection$state_machine__10750__auto____0 = (function (){
var statearr_70557 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70557[(0)] = fluree$db$connection$state_machine__10750__auto__);

(statearr_70557[(1)] = (1));

return statearr_70557;
});
var fluree$db$connection$state_machine__10750__auto____1 = (function (state_70545){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_70545);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e70558){var ex__10753__auto__ = e70558;
var statearr_70559_70574 = state_70545;
(statearr_70559_70574[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_70545[(4)]))){
var statearr_70560_70575 = state_70545;
(statearr_70560_70575[(1)] = cljs.core.first((state_70545[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__70576 = state_70545;
state_70545 = G__70576;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$connection$state_machine__10750__auto__ = function(state_70545){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__10750__auto____1.call(this,state_70545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__10750__auto____0;
fluree$db$connection$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__10750__auto____1;
return fluree$db$connection$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_70561 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_70561[(6)] = c__10876__auto___70565);

return statearr_70561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq70522){
var G__70523 = cljs.core.first(seq70522);
var seq70522__$1 = cljs.core.next(seq70522);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70523,seq70522__$1);
}));

