// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__12813 = arguments.length;
switch (G__12813) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12814 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12814 = (function (f,blockable,meta12815){
this.f = f;
this.blockable = blockable;
this.meta12815 = meta12815;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12814.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12816,meta12815__$1){
var self__ = this;
var _12816__$1 = this;
return (new cljs.core.async.t_cljs$core$async12814(self__.f,self__.blockable,meta12815__$1));
}));

(cljs.core.async.t_cljs$core$async12814.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12816){
var self__ = this;
var _12816__$1 = this;
return self__.meta12815;
}));

(cljs.core.async.t_cljs$core$async12814.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12814.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12814.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async12814.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async12814.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta12815], null);
}));

(cljs.core.async.t_cljs$core$async12814.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12814.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12814");

(cljs.core.async.t_cljs$core$async12814.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async12814");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12814.
 */
cljs.core.async.__GT_t_cljs$core$async12814 = (function cljs$core$async$__GT_t_cljs$core$async12814(f__$1,blockable__$1,meta12815){
return (new cljs.core.async.t_cljs$core$async12814(f__$1,blockable__$1,meta12815));
});

}

return (new cljs.core.async.t_cljs$core$async12814(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__12820 = arguments.length;
switch (G__12820) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__12823 = arguments.length;
switch (G__12823) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__12826 = arguments.length;
switch (G__12826) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_12828 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_12828) : fn1.call(null,val_12828));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_12828) : fn1.call(null,val_12828));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__12830 = arguments.length;
switch (G__12830) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4695__auto___12832 = n;
var x_12833 = (0);
while(true){
if((x_12833 < n__4695__auto___12832)){
(a[x_12833] = x_12833);

var G__12834 = (x_12833 + (1));
x_12833 = G__12834;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12835 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12835 = (function (flag,meta12836){
this.flag = flag;
this.meta12836 = meta12836;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12835.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12837,meta12836__$1){
var self__ = this;
var _12837__$1 = this;
return (new cljs.core.async.t_cljs$core$async12835(self__.flag,meta12836__$1));
}));

(cljs.core.async.t_cljs$core$async12835.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12837){
var self__ = this;
var _12837__$1 = this;
return self__.meta12836;
}));

(cljs.core.async.t_cljs$core$async12835.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12835.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async12835.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12835.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async12835.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta12836], null);
}));

(cljs.core.async.t_cljs$core$async12835.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12835.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12835");

(cljs.core.async.t_cljs$core$async12835.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async12835");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12835.
 */
cljs.core.async.__GT_t_cljs$core$async12835 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async12835(flag__$1,meta12836){
return (new cljs.core.async.t_cljs$core$async12835(flag__$1,meta12836));
});

}

return (new cljs.core.async.t_cljs$core$async12835(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12838 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12838 = (function (flag,cb,meta12839){
this.flag = flag;
this.cb = cb;
this.meta12839 = meta12839;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12838.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12840,meta12839__$1){
var self__ = this;
var _12840__$1 = this;
return (new cljs.core.async.t_cljs$core$async12838(self__.flag,self__.cb,meta12839__$1));
}));

(cljs.core.async.t_cljs$core$async12838.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12840){
var self__ = this;
var _12840__$1 = this;
return self__.meta12839;
}));

(cljs.core.async.t_cljs$core$async12838.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12838.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async12838.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12838.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async12838.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta12839], null);
}));

(cljs.core.async.t_cljs$core$async12838.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12838.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12838");

(cljs.core.async.t_cljs$core$async12838.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async12838");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12838.
 */
cljs.core.async.__GT_t_cljs$core$async12838 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async12838(flag__$1,cb__$1,meta12839){
return (new cljs.core.async.t_cljs$core$async12838(flag__$1,cb__$1,meta12839));
});

}

return (new cljs.core.async.t_cljs$core$async12838(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12841_SHARP_){
var G__12843 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12841_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__12843) : fret.call(null,G__12843));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12842_SHARP_){
var G__12844 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12842_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__12844) : fret.call(null,G__12844));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4212__auto__ = wport;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return port;
}
})()], null));
} else {
var G__12845 = (i + (1));
i = G__12845;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4212__auto__ = ret;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5753__auto__ = (function (){var and__4210__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4210__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___12850 = arguments.length;
var i__4819__auto___12851 = (0);
while(true){
if((i__4819__auto___12851 < len__4818__auto___12850)){
args__4824__auto__.push((arguments[i__4819__auto___12851]));

var G__12852 = (i__4819__auto___12851 + (1));
i__4819__auto___12851 = G__12852;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12848){
var map__12849 = p__12848;
var map__12849__$1 = cljs.core.__destructure_map(map__12849);
var opts = map__12849__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12846){
var G__12847 = cljs.core.first(seq12846);
var seq12846__$1 = cljs.core.next(seq12846);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12847,seq12846__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__12854 = arguments.length;
switch (G__12854) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__10876__auto___12901 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_12878){
var state_val_12879 = (state_12878[(1)]);
if((state_val_12879 === (7))){
var inst_12874 = (state_12878[(2)]);
var state_12878__$1 = state_12878;
var statearr_12880_12902 = state_12878__$1;
(statearr_12880_12902[(2)] = inst_12874);

(statearr_12880_12902[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12879 === (1))){
var state_12878__$1 = state_12878;
var statearr_12881_12903 = state_12878__$1;
(statearr_12881_12903[(2)] = null);

(statearr_12881_12903[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12879 === (4))){
var inst_12857 = (state_12878[(7)]);
var inst_12857__$1 = (state_12878[(2)]);
var inst_12858 = (inst_12857__$1 == null);
var state_12878__$1 = (function (){var statearr_12882 = state_12878;
(statearr_12882[(7)] = inst_12857__$1);

return statearr_12882;
})();
if(cljs.core.truth_(inst_12858)){
var statearr_12883_12904 = state_12878__$1;
(statearr_12883_12904[(1)] = (5));

} else {
var statearr_12884_12905 = state_12878__$1;
(statearr_12884_12905[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_12879 === (13))){
var state_12878__$1 = state_12878;
var statearr_12885_12906 = state_12878__$1;
(statearr_12885_12906[(2)] = null);

(statearr_12885_12906[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12879 === (6))){
var inst_12857 = (state_12878[(7)]);
var state_12878__$1 = state_12878;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12878__$1,(11),to,inst_12857);
} else {
if((state_val_12879 === (3))){
var inst_12876 = (state_12878[(2)]);
var state_12878__$1 = state_12878;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12878__$1,inst_12876);
} else {
if((state_val_12879 === (12))){
var state_12878__$1 = state_12878;
var statearr_12886_12907 = state_12878__$1;
(statearr_12886_12907[(2)] = null);

(statearr_12886_12907[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12879 === (2))){
var state_12878__$1 = state_12878;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12878__$1,(4),from);
} else {
if((state_val_12879 === (11))){
var inst_12867 = (state_12878[(2)]);
var state_12878__$1 = state_12878;
if(cljs.core.truth_(inst_12867)){
var statearr_12887_12908 = state_12878__$1;
(statearr_12887_12908[(1)] = (12));

} else {
var statearr_12888_12909 = state_12878__$1;
(statearr_12888_12909[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_12879 === (9))){
var state_12878__$1 = state_12878;
var statearr_12889_12910 = state_12878__$1;
(statearr_12889_12910[(2)] = null);

(statearr_12889_12910[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12879 === (5))){
var state_12878__$1 = state_12878;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12890_12911 = state_12878__$1;
(statearr_12890_12911[(1)] = (8));

} else {
var statearr_12891_12912 = state_12878__$1;
(statearr_12891_12912[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_12879 === (14))){
var inst_12872 = (state_12878[(2)]);
var state_12878__$1 = state_12878;
var statearr_12892_12913 = state_12878__$1;
(statearr_12892_12913[(2)] = inst_12872);

(statearr_12892_12913[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12879 === (10))){
var inst_12864 = (state_12878[(2)]);
var state_12878__$1 = state_12878;
var statearr_12893_12914 = state_12878__$1;
(statearr_12893_12914[(2)] = inst_12864);

(statearr_12893_12914[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12879 === (8))){
var inst_12861 = cljs.core.async.close_BANG_(to);
var state_12878__$1 = state_12878;
var statearr_12894_12915 = state_12878__$1;
(statearr_12894_12915[(2)] = inst_12861);

(statearr_12894_12915[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10750__auto__ = null;
var cljs$core$async$state_machine__10750__auto____0 = (function (){
var statearr_12895 = [null,null,null,null,null,null,null,null];
(statearr_12895[(0)] = cljs$core$async$state_machine__10750__auto__);

(statearr_12895[(1)] = (1));

return statearr_12895;
});
var cljs$core$async$state_machine__10750__auto____1 = (function (state_12878){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_12878);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e12896){var ex__10753__auto__ = e12896;
var statearr_12897_12916 = state_12878;
(statearr_12897_12916[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_12878[(4)]))){
var statearr_12898_12917 = state_12878;
(statearr_12898_12917[(1)] = cljs.core.first((state_12878[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__12918 = state_12878;
state_12878 = G__12918;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$state_machine__10750__auto__ = function(state_12878){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10750__auto____1.call(this,state_12878);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10750__auto____0;
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10750__auto____1;
return cljs$core$async$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_12899 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_12899[(6)] = c__10876__auto___12901);

return statearr_12899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__12919){
var vec__12920 = p__12919;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12920,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12920,(1),null);
var job = vec__12920;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__10876__auto___13096 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_12927){
var state_val_12928 = (state_12927[(1)]);
if((state_val_12928 === (1))){
var state_12927__$1 = state_12927;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12927__$1,(2),res,v);
} else {
if((state_val_12928 === (2))){
var inst_12924 = (state_12927[(2)]);
var inst_12925 = cljs.core.async.close_BANG_(res);
var state_12927__$1 = (function (){var statearr_12929 = state_12927;
(statearr_12929[(7)] = inst_12924);

return statearr_12929;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_12927__$1,inst_12925);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0 = (function (){
var statearr_12930 = [null,null,null,null,null,null,null,null];
(statearr_12930[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__);

(statearr_12930[(1)] = (1));

return statearr_12930;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1 = (function (state_12927){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_12927);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e12931){var ex__10753__auto__ = e12931;
var statearr_12932_13097 = state_12927;
(statearr_12932_13097[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_12927[(4)]))){
var statearr_12933_13098 = state_12927;
(statearr_12933_13098[(1)] = cljs.core.first((state_12927[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__13099 = state_12927;
state_12927 = G__13099;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__ = function(state_12927){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1.call(this,state_12927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_12934 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_12934[(6)] = c__10876__auto___13096);

return statearr_12934;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__12935){
var vec__12936 = p__12935;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12936,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12936,(1),null);
var job = vec__12936;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4695__auto___13100 = n;
var __13101 = (0);
while(true){
if((__13101 < n__4695__auto___13100)){
var G__12939_13102 = type;
var G__12939_13103__$1 = (((G__12939_13102 instanceof cljs.core.Keyword))?G__12939_13102.fqn:null);
switch (G__12939_13103__$1) {
case "compute":
var c__10876__auto___13105 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__13101,c__10876__auto___13105,G__12939_13102,G__12939_13103__$1,n__4695__auto___13100,jobs,results,process,async){
return (function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = ((function (__13101,c__10876__auto___13105,G__12939_13102,G__12939_13103__$1,n__4695__auto___13100,jobs,results,process,async){
return (function (state_12952){
var state_val_12953 = (state_12952[(1)]);
if((state_val_12953 === (1))){
var state_12952__$1 = state_12952;
var statearr_12954_13106 = state_12952__$1;
(statearr_12954_13106[(2)] = null);

(statearr_12954_13106[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12953 === (2))){
var state_12952__$1 = state_12952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12952__$1,(4),jobs);
} else {
if((state_val_12953 === (3))){
var inst_12950 = (state_12952[(2)]);
var state_12952__$1 = state_12952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12952__$1,inst_12950);
} else {
if((state_val_12953 === (4))){
var inst_12942 = (state_12952[(2)]);
var inst_12943 = process(inst_12942);
var state_12952__$1 = state_12952;
if(cljs.core.truth_(inst_12943)){
var statearr_12955_13107 = state_12952__$1;
(statearr_12955_13107[(1)] = (5));

} else {
var statearr_12956_13108 = state_12952__$1;
(statearr_12956_13108[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_12953 === (5))){
var state_12952__$1 = state_12952;
var statearr_12957_13109 = state_12952__$1;
(statearr_12957_13109[(2)] = null);

(statearr_12957_13109[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12953 === (6))){
var state_12952__$1 = state_12952;
var statearr_12958_13110 = state_12952__$1;
(statearr_12958_13110[(2)] = null);

(statearr_12958_13110[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12953 === (7))){
var inst_12948 = (state_12952[(2)]);
var state_12952__$1 = state_12952;
var statearr_12959_13111 = state_12952__$1;
(statearr_12959_13111[(2)] = inst_12948);

(statearr_12959_13111[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__13101,c__10876__auto___13105,G__12939_13102,G__12939_13103__$1,n__4695__auto___13100,jobs,results,process,async))
;
return ((function (__13101,switch__10749__auto__,c__10876__auto___13105,G__12939_13102,G__12939_13103__$1,n__4695__auto___13100,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0 = (function (){
var statearr_12960 = [null,null,null,null,null,null,null];
(statearr_12960[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__);

(statearr_12960[(1)] = (1));

return statearr_12960;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1 = (function (state_12952){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_12952);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e12961){var ex__10753__auto__ = e12961;
var statearr_12962_13112 = state_12952;
(statearr_12962_13112[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_12952[(4)]))){
var statearr_12963_13113 = state_12952;
(statearr_12963_13113[(1)] = cljs.core.first((state_12952[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__13114 = state_12952;
state_12952 = G__13114;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__ = function(state_12952){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1.call(this,state_12952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__;
})()
;})(__13101,switch__10749__auto__,c__10876__auto___13105,G__12939_13102,G__12939_13103__$1,n__4695__auto___13100,jobs,results,process,async))
})();
var state__10878__auto__ = (function (){var statearr_12964 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_12964[(6)] = c__10876__auto___13105);

return statearr_12964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
});})(__13101,c__10876__auto___13105,G__12939_13102,G__12939_13103__$1,n__4695__auto___13100,jobs,results,process,async))
);


break;
case "async":
var c__10876__auto___13115 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__13101,c__10876__auto___13115,G__12939_13102,G__12939_13103__$1,n__4695__auto___13100,jobs,results,process,async){
return (function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = ((function (__13101,c__10876__auto___13115,G__12939_13102,G__12939_13103__$1,n__4695__auto___13100,jobs,results,process,async){
return (function (state_12977){
var state_val_12978 = (state_12977[(1)]);
if((state_val_12978 === (1))){
var state_12977__$1 = state_12977;
var statearr_12979_13116 = state_12977__$1;
(statearr_12979_13116[(2)] = null);

(statearr_12979_13116[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12978 === (2))){
var state_12977__$1 = state_12977;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12977__$1,(4),jobs);
} else {
if((state_val_12978 === (3))){
var inst_12975 = (state_12977[(2)]);
var state_12977__$1 = state_12977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12977__$1,inst_12975);
} else {
if((state_val_12978 === (4))){
var inst_12967 = (state_12977[(2)]);
var inst_12968 = async(inst_12967);
var state_12977__$1 = state_12977;
if(cljs.core.truth_(inst_12968)){
var statearr_12980_13117 = state_12977__$1;
(statearr_12980_13117[(1)] = (5));

} else {
var statearr_12981_13118 = state_12977__$1;
(statearr_12981_13118[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_12978 === (5))){
var state_12977__$1 = state_12977;
var statearr_12982_13119 = state_12977__$1;
(statearr_12982_13119[(2)] = null);

(statearr_12982_13119[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12978 === (6))){
var state_12977__$1 = state_12977;
var statearr_12983_13120 = state_12977__$1;
(statearr_12983_13120[(2)] = null);

(statearr_12983_13120[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_12978 === (7))){
var inst_12973 = (state_12977[(2)]);
var state_12977__$1 = state_12977;
var statearr_12984_13121 = state_12977__$1;
(statearr_12984_13121[(2)] = inst_12973);

(statearr_12984_13121[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__13101,c__10876__auto___13115,G__12939_13102,G__12939_13103__$1,n__4695__auto___13100,jobs,results,process,async))
;
return ((function (__13101,switch__10749__auto__,c__10876__auto___13115,G__12939_13102,G__12939_13103__$1,n__4695__auto___13100,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0 = (function (){
var statearr_12985 = [null,null,null,null,null,null,null];
(statearr_12985[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__);

(statearr_12985[(1)] = (1));

return statearr_12985;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1 = (function (state_12977){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_12977);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e12986){var ex__10753__auto__ = e12986;
var statearr_12987_13122 = state_12977;
(statearr_12987_13122[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_12977[(4)]))){
var statearr_12988_13123 = state_12977;
(statearr_12988_13123[(1)] = cljs.core.first((state_12977[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__13124 = state_12977;
state_12977 = G__13124;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__ = function(state_12977){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1.call(this,state_12977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__;
})()
;})(__13101,switch__10749__auto__,c__10876__auto___13115,G__12939_13102,G__12939_13103__$1,n__4695__auto___13100,jobs,results,process,async))
})();
var state__10878__auto__ = (function (){var statearr_12989 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_12989[(6)] = c__10876__auto___13115);

return statearr_12989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
});})(__13101,c__10876__auto___13115,G__12939_13102,G__12939_13103__$1,n__4695__auto___13100,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__12939_13103__$1)].join('')));

}

var G__13125 = (__13101 + (1));
__13101 = G__13125;
continue;
} else {
}
break;
}

var c__10876__auto___13126 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_13011){
var state_val_13012 = (state_13011[(1)]);
if((state_val_13012 === (7))){
var inst_13007 = (state_13011[(2)]);
var state_13011__$1 = state_13011;
var statearr_13013_13127 = state_13011__$1;
(statearr_13013_13127[(2)] = inst_13007);

(statearr_13013_13127[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13012 === (1))){
var state_13011__$1 = state_13011;
var statearr_13014_13128 = state_13011__$1;
(statearr_13014_13128[(2)] = null);

(statearr_13014_13128[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13012 === (4))){
var inst_12992 = (state_13011[(7)]);
var inst_12992__$1 = (state_13011[(2)]);
var inst_12993 = (inst_12992__$1 == null);
var state_13011__$1 = (function (){var statearr_13015 = state_13011;
(statearr_13015[(7)] = inst_12992__$1);

return statearr_13015;
})();
if(cljs.core.truth_(inst_12993)){
var statearr_13016_13129 = state_13011__$1;
(statearr_13016_13129[(1)] = (5));

} else {
var statearr_13017_13130 = state_13011__$1;
(statearr_13017_13130[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13012 === (6))){
var inst_12997 = (state_13011[(8)]);
var inst_12992 = (state_13011[(7)]);
var inst_12997__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_12998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12999 = [inst_12992,inst_12997__$1];
var inst_13000 = (new cljs.core.PersistentVector(null,2,(5),inst_12998,inst_12999,null));
var state_13011__$1 = (function (){var statearr_13018 = state_13011;
(statearr_13018[(8)] = inst_12997__$1);

return statearr_13018;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13011__$1,(8),jobs,inst_13000);
} else {
if((state_val_13012 === (3))){
var inst_13009 = (state_13011[(2)]);
var state_13011__$1 = state_13011;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13011__$1,inst_13009);
} else {
if((state_val_13012 === (2))){
var state_13011__$1 = state_13011;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13011__$1,(4),from);
} else {
if((state_val_13012 === (9))){
var inst_13004 = (state_13011[(2)]);
var state_13011__$1 = (function (){var statearr_13019 = state_13011;
(statearr_13019[(9)] = inst_13004);

return statearr_13019;
})();
var statearr_13020_13131 = state_13011__$1;
(statearr_13020_13131[(2)] = null);

(statearr_13020_13131[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13012 === (5))){
var inst_12995 = cljs.core.async.close_BANG_(jobs);
var state_13011__$1 = state_13011;
var statearr_13021_13132 = state_13011__$1;
(statearr_13021_13132[(2)] = inst_12995);

(statearr_13021_13132[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13012 === (8))){
var inst_12997 = (state_13011[(8)]);
var inst_13002 = (state_13011[(2)]);
var state_13011__$1 = (function (){var statearr_13022 = state_13011;
(statearr_13022[(10)] = inst_13002);

return statearr_13022;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13011__$1,(9),results,inst_12997);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0 = (function (){
var statearr_13023 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13023[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__);

(statearr_13023[(1)] = (1));

return statearr_13023;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1 = (function (state_13011){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_13011);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e13024){var ex__10753__auto__ = e13024;
var statearr_13025_13133 = state_13011;
(statearr_13025_13133[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_13011[(4)]))){
var statearr_13026_13134 = state_13011;
(statearr_13026_13134[(1)] = cljs.core.first((state_13011[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__13135 = state_13011;
state_13011 = G__13135;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__ = function(state_13011){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1.call(this,state_13011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_13027 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_13027[(6)] = c__10876__auto___13126);

return statearr_13027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_13065){
var state_val_13066 = (state_13065[(1)]);
if((state_val_13066 === (7))){
var inst_13061 = (state_13065[(2)]);
var state_13065__$1 = state_13065;
var statearr_13067_13136 = state_13065__$1;
(statearr_13067_13136[(2)] = inst_13061);

(statearr_13067_13136[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (20))){
var state_13065__$1 = state_13065;
var statearr_13068_13137 = state_13065__$1;
(statearr_13068_13137[(2)] = null);

(statearr_13068_13137[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (1))){
var state_13065__$1 = state_13065;
var statearr_13069_13138 = state_13065__$1;
(statearr_13069_13138[(2)] = null);

(statearr_13069_13138[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (4))){
var inst_13030 = (state_13065[(7)]);
var inst_13030__$1 = (state_13065[(2)]);
var inst_13031 = (inst_13030__$1 == null);
var state_13065__$1 = (function (){var statearr_13070 = state_13065;
(statearr_13070[(7)] = inst_13030__$1);

return statearr_13070;
})();
if(cljs.core.truth_(inst_13031)){
var statearr_13071_13139 = state_13065__$1;
(statearr_13071_13139[(1)] = (5));

} else {
var statearr_13072_13140 = state_13065__$1;
(statearr_13072_13140[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (15))){
var inst_13043 = (state_13065[(8)]);
var state_13065__$1 = state_13065;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13065__$1,(18),to,inst_13043);
} else {
if((state_val_13066 === (21))){
var inst_13056 = (state_13065[(2)]);
var state_13065__$1 = state_13065;
var statearr_13073_13141 = state_13065__$1;
(statearr_13073_13141[(2)] = inst_13056);

(statearr_13073_13141[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (13))){
var inst_13058 = (state_13065[(2)]);
var state_13065__$1 = (function (){var statearr_13074 = state_13065;
(statearr_13074[(9)] = inst_13058);

return statearr_13074;
})();
var statearr_13075_13142 = state_13065__$1;
(statearr_13075_13142[(2)] = null);

(statearr_13075_13142[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (6))){
var inst_13030 = (state_13065[(7)]);
var state_13065__$1 = state_13065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13065__$1,(11),inst_13030);
} else {
if((state_val_13066 === (17))){
var inst_13051 = (state_13065[(2)]);
var state_13065__$1 = state_13065;
if(cljs.core.truth_(inst_13051)){
var statearr_13076_13143 = state_13065__$1;
(statearr_13076_13143[(1)] = (19));

} else {
var statearr_13077_13144 = state_13065__$1;
(statearr_13077_13144[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (3))){
var inst_13063 = (state_13065[(2)]);
var state_13065__$1 = state_13065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13065__$1,inst_13063);
} else {
if((state_val_13066 === (12))){
var inst_13040 = (state_13065[(10)]);
var state_13065__$1 = state_13065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13065__$1,(14),inst_13040);
} else {
if((state_val_13066 === (2))){
var state_13065__$1 = state_13065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13065__$1,(4),results);
} else {
if((state_val_13066 === (19))){
var state_13065__$1 = state_13065;
var statearr_13078_13145 = state_13065__$1;
(statearr_13078_13145[(2)] = null);

(statearr_13078_13145[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (11))){
var inst_13040 = (state_13065[(2)]);
var state_13065__$1 = (function (){var statearr_13079 = state_13065;
(statearr_13079[(10)] = inst_13040);

return statearr_13079;
})();
var statearr_13080_13146 = state_13065__$1;
(statearr_13080_13146[(2)] = null);

(statearr_13080_13146[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (9))){
var state_13065__$1 = state_13065;
var statearr_13081_13147 = state_13065__$1;
(statearr_13081_13147[(2)] = null);

(statearr_13081_13147[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (5))){
var state_13065__$1 = state_13065;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13082_13148 = state_13065__$1;
(statearr_13082_13148[(1)] = (8));

} else {
var statearr_13083_13149 = state_13065__$1;
(statearr_13083_13149[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (14))){
var inst_13043 = (state_13065[(8)]);
var inst_13045 = (state_13065[(11)]);
var inst_13043__$1 = (state_13065[(2)]);
var inst_13044 = (inst_13043__$1 == null);
var inst_13045__$1 = cljs.core.not(inst_13044);
var state_13065__$1 = (function (){var statearr_13084 = state_13065;
(statearr_13084[(8)] = inst_13043__$1);

(statearr_13084[(11)] = inst_13045__$1);

return statearr_13084;
})();
if(inst_13045__$1){
var statearr_13085_13150 = state_13065__$1;
(statearr_13085_13150[(1)] = (15));

} else {
var statearr_13086_13151 = state_13065__$1;
(statearr_13086_13151[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (16))){
var inst_13045 = (state_13065[(11)]);
var state_13065__$1 = state_13065;
var statearr_13087_13152 = state_13065__$1;
(statearr_13087_13152[(2)] = inst_13045);

(statearr_13087_13152[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (10))){
var inst_13037 = (state_13065[(2)]);
var state_13065__$1 = state_13065;
var statearr_13088_13153 = state_13065__$1;
(statearr_13088_13153[(2)] = inst_13037);

(statearr_13088_13153[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (18))){
var inst_13048 = (state_13065[(2)]);
var state_13065__$1 = state_13065;
var statearr_13089_13154 = state_13065__$1;
(statearr_13089_13154[(2)] = inst_13048);

(statearr_13089_13154[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13066 === (8))){
var inst_13034 = cljs.core.async.close_BANG_(to);
var state_13065__$1 = state_13065;
var statearr_13090_13155 = state_13065__$1;
(statearr_13090_13155[(2)] = inst_13034);

(statearr_13090_13155[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0 = (function (){
var statearr_13091 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13091[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__);

(statearr_13091[(1)] = (1));

return statearr_13091;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1 = (function (state_13065){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_13065);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e13092){var ex__10753__auto__ = e13092;
var statearr_13093_13156 = state_13065;
(statearr_13093_13156[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_13065[(4)]))){
var statearr_13094_13157 = state_13065;
(statearr_13094_13157[(1)] = cljs.core.first((state_13065[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__13158 = state_13065;
state_13065 = G__13158;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__ = function(state_13065){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1.call(this,state_13065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10750__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_13095 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_13095[(6)] = c__10876__auto__);

return statearr_13095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__13160 = arguments.length;
switch (G__13160) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__13163 = arguments.length;
switch (G__13163) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__13166 = arguments.length;
switch (G__13166) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__10876__auto___13216 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_13192){
var state_val_13193 = (state_13192[(1)]);
if((state_val_13193 === (7))){
var inst_13188 = (state_13192[(2)]);
var state_13192__$1 = state_13192;
var statearr_13194_13217 = state_13192__$1;
(statearr_13194_13217[(2)] = inst_13188);

(statearr_13194_13217[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13193 === (1))){
var state_13192__$1 = state_13192;
var statearr_13195_13218 = state_13192__$1;
(statearr_13195_13218[(2)] = null);

(statearr_13195_13218[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13193 === (4))){
var inst_13169 = (state_13192[(7)]);
var inst_13169__$1 = (state_13192[(2)]);
var inst_13170 = (inst_13169__$1 == null);
var state_13192__$1 = (function (){var statearr_13196 = state_13192;
(statearr_13196[(7)] = inst_13169__$1);

return statearr_13196;
})();
if(cljs.core.truth_(inst_13170)){
var statearr_13197_13219 = state_13192__$1;
(statearr_13197_13219[(1)] = (5));

} else {
var statearr_13198_13220 = state_13192__$1;
(statearr_13198_13220[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13193 === (13))){
var state_13192__$1 = state_13192;
var statearr_13199_13221 = state_13192__$1;
(statearr_13199_13221[(2)] = null);

(statearr_13199_13221[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13193 === (6))){
var inst_13169 = (state_13192[(7)]);
var inst_13175 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_13169) : p.call(null,inst_13169));
var state_13192__$1 = state_13192;
if(cljs.core.truth_(inst_13175)){
var statearr_13200_13222 = state_13192__$1;
(statearr_13200_13222[(1)] = (9));

} else {
var statearr_13201_13223 = state_13192__$1;
(statearr_13201_13223[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13193 === (3))){
var inst_13190 = (state_13192[(2)]);
var state_13192__$1 = state_13192;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13192__$1,inst_13190);
} else {
if((state_val_13193 === (12))){
var state_13192__$1 = state_13192;
var statearr_13202_13224 = state_13192__$1;
(statearr_13202_13224[(2)] = null);

(statearr_13202_13224[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13193 === (2))){
var state_13192__$1 = state_13192;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13192__$1,(4),ch);
} else {
if((state_val_13193 === (11))){
var inst_13169 = (state_13192[(7)]);
var inst_13179 = (state_13192[(2)]);
var state_13192__$1 = state_13192;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13192__$1,(8),inst_13179,inst_13169);
} else {
if((state_val_13193 === (9))){
var state_13192__$1 = state_13192;
var statearr_13203_13225 = state_13192__$1;
(statearr_13203_13225[(2)] = tc);

(statearr_13203_13225[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13193 === (5))){
var inst_13172 = cljs.core.async.close_BANG_(tc);
var inst_13173 = cljs.core.async.close_BANG_(fc);
var state_13192__$1 = (function (){var statearr_13204 = state_13192;
(statearr_13204[(8)] = inst_13172);

return statearr_13204;
})();
var statearr_13205_13226 = state_13192__$1;
(statearr_13205_13226[(2)] = inst_13173);

(statearr_13205_13226[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13193 === (14))){
var inst_13186 = (state_13192[(2)]);
var state_13192__$1 = state_13192;
var statearr_13206_13227 = state_13192__$1;
(statearr_13206_13227[(2)] = inst_13186);

(statearr_13206_13227[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13193 === (10))){
var state_13192__$1 = state_13192;
var statearr_13207_13228 = state_13192__$1;
(statearr_13207_13228[(2)] = fc);

(statearr_13207_13228[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13193 === (8))){
var inst_13181 = (state_13192[(2)]);
var state_13192__$1 = state_13192;
if(cljs.core.truth_(inst_13181)){
var statearr_13208_13229 = state_13192__$1;
(statearr_13208_13229[(1)] = (12));

} else {
var statearr_13209_13230 = state_13192__$1;
(statearr_13209_13230[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10750__auto__ = null;
var cljs$core$async$state_machine__10750__auto____0 = (function (){
var statearr_13210 = [null,null,null,null,null,null,null,null,null];
(statearr_13210[(0)] = cljs$core$async$state_machine__10750__auto__);

(statearr_13210[(1)] = (1));

return statearr_13210;
});
var cljs$core$async$state_machine__10750__auto____1 = (function (state_13192){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_13192);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e13211){var ex__10753__auto__ = e13211;
var statearr_13212_13231 = state_13192;
(statearr_13212_13231[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_13192[(4)]))){
var statearr_13213_13232 = state_13192;
(statearr_13213_13232[(1)] = cljs.core.first((state_13192[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__13233 = state_13192;
state_13192 = G__13233;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$state_machine__10750__auto__ = function(state_13192){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10750__auto____1.call(this,state_13192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10750__auto____0;
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10750__auto____1;
return cljs$core$async$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_13214 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_13214[(6)] = c__10876__auto___13216);

return statearr_13214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_13255){
var state_val_13256 = (state_13255[(1)]);
if((state_val_13256 === (7))){
var inst_13251 = (state_13255[(2)]);
var state_13255__$1 = state_13255;
var statearr_13257_13276 = state_13255__$1;
(statearr_13257_13276[(2)] = inst_13251);

(statearr_13257_13276[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13256 === (1))){
var inst_13234 = init;
var inst_13235 = inst_13234;
var state_13255__$1 = (function (){var statearr_13258 = state_13255;
(statearr_13258[(7)] = inst_13235);

return statearr_13258;
})();
var statearr_13259_13277 = state_13255__$1;
(statearr_13259_13277[(2)] = null);

(statearr_13259_13277[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13256 === (4))){
var inst_13238 = (state_13255[(8)]);
var inst_13238__$1 = (state_13255[(2)]);
var inst_13239 = (inst_13238__$1 == null);
var state_13255__$1 = (function (){var statearr_13260 = state_13255;
(statearr_13260[(8)] = inst_13238__$1);

return statearr_13260;
})();
if(cljs.core.truth_(inst_13239)){
var statearr_13261_13278 = state_13255__$1;
(statearr_13261_13278[(1)] = (5));

} else {
var statearr_13262_13279 = state_13255__$1;
(statearr_13262_13279[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13256 === (6))){
var inst_13238 = (state_13255[(8)]);
var inst_13242 = (state_13255[(9)]);
var inst_13235 = (state_13255[(7)]);
var inst_13242__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_13235,inst_13238) : f.call(null,inst_13235,inst_13238));
var inst_13243 = cljs.core.reduced_QMARK_(inst_13242__$1);
var state_13255__$1 = (function (){var statearr_13263 = state_13255;
(statearr_13263[(9)] = inst_13242__$1);

return statearr_13263;
})();
if(inst_13243){
var statearr_13264_13280 = state_13255__$1;
(statearr_13264_13280[(1)] = (8));

} else {
var statearr_13265_13281 = state_13255__$1;
(statearr_13265_13281[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13256 === (3))){
var inst_13253 = (state_13255[(2)]);
var state_13255__$1 = state_13255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13255__$1,inst_13253);
} else {
if((state_val_13256 === (2))){
var state_13255__$1 = state_13255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13255__$1,(4),ch);
} else {
if((state_val_13256 === (9))){
var inst_13242 = (state_13255[(9)]);
var inst_13235 = inst_13242;
var state_13255__$1 = (function (){var statearr_13266 = state_13255;
(statearr_13266[(7)] = inst_13235);

return statearr_13266;
})();
var statearr_13267_13282 = state_13255__$1;
(statearr_13267_13282[(2)] = null);

(statearr_13267_13282[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13256 === (5))){
var inst_13235 = (state_13255[(7)]);
var state_13255__$1 = state_13255;
var statearr_13268_13283 = state_13255__$1;
(statearr_13268_13283[(2)] = inst_13235);

(statearr_13268_13283[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13256 === (10))){
var inst_13249 = (state_13255[(2)]);
var state_13255__$1 = state_13255;
var statearr_13269_13284 = state_13255__$1;
(statearr_13269_13284[(2)] = inst_13249);

(statearr_13269_13284[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13256 === (8))){
var inst_13242 = (state_13255[(9)]);
var inst_13245 = cljs.core.deref(inst_13242);
var state_13255__$1 = state_13255;
var statearr_13270_13285 = state_13255__$1;
(statearr_13270_13285[(2)] = inst_13245);

(statearr_13270_13285[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__10750__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10750__auto____0 = (function (){
var statearr_13271 = [null,null,null,null,null,null,null,null,null,null];
(statearr_13271[(0)] = cljs$core$async$reduce_$_state_machine__10750__auto__);

(statearr_13271[(1)] = (1));

return statearr_13271;
});
var cljs$core$async$reduce_$_state_machine__10750__auto____1 = (function (state_13255){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_13255);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e13272){var ex__10753__auto__ = e13272;
var statearr_13273_13286 = state_13255;
(statearr_13273_13286[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_13255[(4)]))){
var statearr_13274_13287 = state_13255;
(statearr_13274_13287[(1)] = cljs.core.first((state_13255[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__13288 = state_13255;
state_13255 = G__13288;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10750__auto__ = function(state_13255){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10750__auto____1.call(this,state_13255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10750__auto____0;
cljs$core$async$reduce_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10750__auto____1;
return cljs$core$async$reduce_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_13275 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_13275[(6)] = c__10876__auto__);

return statearr_13275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_13294){
var state_val_13295 = (state_13294[(1)]);
if((state_val_13295 === (1))){
var inst_13289 = cljs.core.async.reduce(f__$1,init,ch);
var state_13294__$1 = state_13294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13294__$1,(2),inst_13289);
} else {
if((state_val_13295 === (2))){
var inst_13291 = (state_13294[(2)]);
var inst_13292 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_13291) : f__$1.call(null,inst_13291));
var state_13294__$1 = state_13294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13294__$1,inst_13292);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__10750__auto__ = null;
var cljs$core$async$transduce_$_state_machine__10750__auto____0 = (function (){
var statearr_13296 = [null,null,null,null,null,null,null];
(statearr_13296[(0)] = cljs$core$async$transduce_$_state_machine__10750__auto__);

(statearr_13296[(1)] = (1));

return statearr_13296;
});
var cljs$core$async$transduce_$_state_machine__10750__auto____1 = (function (state_13294){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_13294);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e13297){var ex__10753__auto__ = e13297;
var statearr_13298_13301 = state_13294;
(statearr_13298_13301[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_13294[(4)]))){
var statearr_13299_13302 = state_13294;
(statearr_13299_13302[(1)] = cljs.core.first((state_13294[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__13303 = state_13294;
state_13294 = G__13303;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__10750__auto__ = function(state_13294){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__10750__auto____1.call(this,state_13294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__10750__auto____0;
cljs$core$async$transduce_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__10750__auto____1;
return cljs$core$async$transduce_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_13300 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_13300[(6)] = c__10876__auto__);

return statearr_13300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__13305 = arguments.length;
switch (G__13305) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_13330){
var state_val_13331 = (state_13330[(1)]);
if((state_val_13331 === (7))){
var inst_13312 = (state_13330[(2)]);
var state_13330__$1 = state_13330;
var statearr_13332_13354 = state_13330__$1;
(statearr_13332_13354[(2)] = inst_13312);

(statearr_13332_13354[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13331 === (1))){
var inst_13306 = cljs.core.seq(coll);
var inst_13307 = inst_13306;
var state_13330__$1 = (function (){var statearr_13333 = state_13330;
(statearr_13333[(7)] = inst_13307);

return statearr_13333;
})();
var statearr_13334_13355 = state_13330__$1;
(statearr_13334_13355[(2)] = null);

(statearr_13334_13355[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13331 === (4))){
var inst_13307 = (state_13330[(7)]);
var inst_13310 = cljs.core.first(inst_13307);
var state_13330__$1 = state_13330;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13330__$1,(7),ch,inst_13310);
} else {
if((state_val_13331 === (13))){
var inst_13324 = (state_13330[(2)]);
var state_13330__$1 = state_13330;
var statearr_13335_13356 = state_13330__$1;
(statearr_13335_13356[(2)] = inst_13324);

(statearr_13335_13356[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13331 === (6))){
var inst_13315 = (state_13330[(2)]);
var state_13330__$1 = state_13330;
if(cljs.core.truth_(inst_13315)){
var statearr_13336_13357 = state_13330__$1;
(statearr_13336_13357[(1)] = (8));

} else {
var statearr_13337_13358 = state_13330__$1;
(statearr_13337_13358[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13331 === (3))){
var inst_13328 = (state_13330[(2)]);
var state_13330__$1 = state_13330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13330__$1,inst_13328);
} else {
if((state_val_13331 === (12))){
var state_13330__$1 = state_13330;
var statearr_13338_13359 = state_13330__$1;
(statearr_13338_13359[(2)] = null);

(statearr_13338_13359[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13331 === (2))){
var inst_13307 = (state_13330[(7)]);
var state_13330__$1 = state_13330;
if(cljs.core.truth_(inst_13307)){
var statearr_13339_13360 = state_13330__$1;
(statearr_13339_13360[(1)] = (4));

} else {
var statearr_13340_13361 = state_13330__$1;
(statearr_13340_13361[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13331 === (11))){
var inst_13321 = cljs.core.async.close_BANG_(ch);
var state_13330__$1 = state_13330;
var statearr_13341_13362 = state_13330__$1;
(statearr_13341_13362[(2)] = inst_13321);

(statearr_13341_13362[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13331 === (9))){
var state_13330__$1 = state_13330;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13342_13363 = state_13330__$1;
(statearr_13342_13363[(1)] = (11));

} else {
var statearr_13343_13364 = state_13330__$1;
(statearr_13343_13364[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13331 === (5))){
var inst_13307 = (state_13330[(7)]);
var state_13330__$1 = state_13330;
var statearr_13344_13365 = state_13330__$1;
(statearr_13344_13365[(2)] = inst_13307);

(statearr_13344_13365[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13331 === (10))){
var inst_13326 = (state_13330[(2)]);
var state_13330__$1 = state_13330;
var statearr_13345_13366 = state_13330__$1;
(statearr_13345_13366[(2)] = inst_13326);

(statearr_13345_13366[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13331 === (8))){
var inst_13307 = (state_13330[(7)]);
var inst_13317 = cljs.core.next(inst_13307);
var inst_13307__$1 = inst_13317;
var state_13330__$1 = (function (){var statearr_13346 = state_13330;
(statearr_13346[(7)] = inst_13307__$1);

return statearr_13346;
})();
var statearr_13347_13367 = state_13330__$1;
(statearr_13347_13367[(2)] = null);

(statearr_13347_13367[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10750__auto__ = null;
var cljs$core$async$state_machine__10750__auto____0 = (function (){
var statearr_13348 = [null,null,null,null,null,null,null,null];
(statearr_13348[(0)] = cljs$core$async$state_machine__10750__auto__);

(statearr_13348[(1)] = (1));

return statearr_13348;
});
var cljs$core$async$state_machine__10750__auto____1 = (function (state_13330){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_13330);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e13349){var ex__10753__auto__ = e13349;
var statearr_13350_13368 = state_13330;
(statearr_13350_13368[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_13330[(4)]))){
var statearr_13351_13369 = state_13330;
(statearr_13351_13369[(1)] = cljs.core.first((state_13330[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__13370 = state_13330;
state_13330 = G__13370;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$state_machine__10750__auto__ = function(state_13330){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10750__auto____1.call(this,state_13330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10750__auto____0;
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10750__auto____1;
return cljs$core$async$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_13352 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_13352[(6)] = c__10876__auto__);

return statearr_13352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__13372 = arguments.length;
switch (G__13372) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_13374 = (function (_){
var x__4509__auto__ = (((_ == null))?null:_);
var m__4510__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4510__auto__.call(null,_));
} else {
var m__4508__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4508__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_13374(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_13375 = (function (m,ch,close_QMARK_){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4510__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4508__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_13375(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_13376 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_13376(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_13377 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_13377(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13378 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13378 = (function (ch,cs,meta13379){
this.ch = ch;
this.cs = cs;
this.meta13379 = meta13379;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13378.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13380,meta13379__$1){
var self__ = this;
var _13380__$1 = this;
return (new cljs.core.async.t_cljs$core$async13378(self__.ch,self__.cs,meta13379__$1));
}));

(cljs.core.async.t_cljs$core$async13378.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13380){
var self__ = this;
var _13380__$1 = this;
return self__.meta13379;
}));

(cljs.core.async.t_cljs$core$async13378.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13378.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async13378.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13378.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async13378.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async13378.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async13378.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta13379], null);
}));

(cljs.core.async.t_cljs$core$async13378.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13378.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13378");

(cljs.core.async.t_cljs$core$async13378.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13378");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13378.
 */
cljs.core.async.__GT_t_cljs$core$async13378 = (function cljs$core$async$mult_$___GT_t_cljs$core$async13378(ch__$1,cs__$1,meta13379){
return (new cljs.core.async.t_cljs$core$async13378(ch__$1,cs__$1,meta13379));
});

}

return (new cljs.core.async.t_cljs$core$async13378(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__10876__auto___13597 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_13513){
var state_val_13514 = (state_13513[(1)]);
if((state_val_13514 === (7))){
var inst_13509 = (state_13513[(2)]);
var state_13513__$1 = state_13513;
var statearr_13515_13598 = state_13513__$1;
(statearr_13515_13598[(2)] = inst_13509);

(statearr_13515_13598[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (20))){
var inst_13414 = (state_13513[(7)]);
var inst_13426 = cljs.core.first(inst_13414);
var inst_13427 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13426,(0),null);
var inst_13428 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13426,(1),null);
var state_13513__$1 = (function (){var statearr_13516 = state_13513;
(statearr_13516[(8)] = inst_13427);

return statearr_13516;
})();
if(cljs.core.truth_(inst_13428)){
var statearr_13517_13599 = state_13513__$1;
(statearr_13517_13599[(1)] = (22));

} else {
var statearr_13518_13600 = state_13513__$1;
(statearr_13518_13600[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (27))){
var inst_13456 = (state_13513[(9)]);
var inst_13383 = (state_13513[(10)]);
var inst_13463 = (state_13513[(11)]);
var inst_13458 = (state_13513[(12)]);
var inst_13463__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_13456,inst_13458);
var inst_13464 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_13463__$1,inst_13383,done);
var state_13513__$1 = (function (){var statearr_13519 = state_13513;
(statearr_13519[(11)] = inst_13463__$1);

return statearr_13519;
})();
if(cljs.core.truth_(inst_13464)){
var statearr_13520_13601 = state_13513__$1;
(statearr_13520_13601[(1)] = (30));

} else {
var statearr_13521_13602 = state_13513__$1;
(statearr_13521_13602[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (1))){
var state_13513__$1 = state_13513;
var statearr_13522_13603 = state_13513__$1;
(statearr_13522_13603[(2)] = null);

(statearr_13522_13603[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (24))){
var inst_13414 = (state_13513[(7)]);
var inst_13433 = (state_13513[(2)]);
var inst_13434 = cljs.core.next(inst_13414);
var inst_13392 = inst_13434;
var inst_13393 = null;
var inst_13394 = (0);
var inst_13395 = (0);
var state_13513__$1 = (function (){var statearr_13523 = state_13513;
(statearr_13523[(13)] = inst_13394);

(statearr_13523[(14)] = inst_13393);

(statearr_13523[(15)] = inst_13395);

(statearr_13523[(16)] = inst_13433);

(statearr_13523[(17)] = inst_13392);

return statearr_13523;
})();
var statearr_13524_13604 = state_13513__$1;
(statearr_13524_13604[(2)] = null);

(statearr_13524_13604[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (39))){
var state_13513__$1 = state_13513;
var statearr_13528_13605 = state_13513__$1;
(statearr_13528_13605[(2)] = null);

(statearr_13528_13605[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (4))){
var inst_13383 = (state_13513[(10)]);
var inst_13383__$1 = (state_13513[(2)]);
var inst_13384 = (inst_13383__$1 == null);
var state_13513__$1 = (function (){var statearr_13529 = state_13513;
(statearr_13529[(10)] = inst_13383__$1);

return statearr_13529;
})();
if(cljs.core.truth_(inst_13384)){
var statearr_13530_13606 = state_13513__$1;
(statearr_13530_13606[(1)] = (5));

} else {
var statearr_13531_13607 = state_13513__$1;
(statearr_13531_13607[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (15))){
var inst_13394 = (state_13513[(13)]);
var inst_13393 = (state_13513[(14)]);
var inst_13395 = (state_13513[(15)]);
var inst_13392 = (state_13513[(17)]);
var inst_13410 = (state_13513[(2)]);
var inst_13411 = (inst_13395 + (1));
var tmp13525 = inst_13394;
var tmp13526 = inst_13393;
var tmp13527 = inst_13392;
var inst_13392__$1 = tmp13527;
var inst_13393__$1 = tmp13526;
var inst_13394__$1 = tmp13525;
var inst_13395__$1 = inst_13411;
var state_13513__$1 = (function (){var statearr_13532 = state_13513;
(statearr_13532[(13)] = inst_13394__$1);

(statearr_13532[(14)] = inst_13393__$1);

(statearr_13532[(15)] = inst_13395__$1);

(statearr_13532[(18)] = inst_13410);

(statearr_13532[(17)] = inst_13392__$1);

return statearr_13532;
})();
var statearr_13533_13608 = state_13513__$1;
(statearr_13533_13608[(2)] = null);

(statearr_13533_13608[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (21))){
var inst_13437 = (state_13513[(2)]);
var state_13513__$1 = state_13513;
var statearr_13537_13609 = state_13513__$1;
(statearr_13537_13609[(2)] = inst_13437);

(statearr_13537_13609[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (31))){
var inst_13463 = (state_13513[(11)]);
var inst_13467 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_13463);
var state_13513__$1 = state_13513;
var statearr_13538_13610 = state_13513__$1;
(statearr_13538_13610[(2)] = inst_13467);

(statearr_13538_13610[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (32))){
var inst_13456 = (state_13513[(9)]);
var inst_13455 = (state_13513[(19)]);
var inst_13457 = (state_13513[(20)]);
var inst_13458 = (state_13513[(12)]);
var inst_13469 = (state_13513[(2)]);
var inst_13470 = (inst_13458 + (1));
var tmp13534 = inst_13456;
var tmp13535 = inst_13455;
var tmp13536 = inst_13457;
var inst_13455__$1 = tmp13535;
var inst_13456__$1 = tmp13534;
var inst_13457__$1 = tmp13536;
var inst_13458__$1 = inst_13470;
var state_13513__$1 = (function (){var statearr_13539 = state_13513;
(statearr_13539[(9)] = inst_13456__$1);

(statearr_13539[(21)] = inst_13469);

(statearr_13539[(19)] = inst_13455__$1);

(statearr_13539[(20)] = inst_13457__$1);

(statearr_13539[(12)] = inst_13458__$1);

return statearr_13539;
})();
var statearr_13540_13611 = state_13513__$1;
(statearr_13540_13611[(2)] = null);

(statearr_13540_13611[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (40))){
var inst_13482 = (state_13513[(22)]);
var inst_13486 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_13482);
var state_13513__$1 = state_13513;
var statearr_13541_13612 = state_13513__$1;
(statearr_13541_13612[(2)] = inst_13486);

(statearr_13541_13612[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (33))){
var inst_13473 = (state_13513[(23)]);
var inst_13475 = cljs.core.chunked_seq_QMARK_(inst_13473);
var state_13513__$1 = state_13513;
if(inst_13475){
var statearr_13542_13613 = state_13513__$1;
(statearr_13542_13613[(1)] = (36));

} else {
var statearr_13543_13614 = state_13513__$1;
(statearr_13543_13614[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (13))){
var inst_13404 = (state_13513[(24)]);
var inst_13407 = cljs.core.async.close_BANG_(inst_13404);
var state_13513__$1 = state_13513;
var statearr_13544_13615 = state_13513__$1;
(statearr_13544_13615[(2)] = inst_13407);

(statearr_13544_13615[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (22))){
var inst_13427 = (state_13513[(8)]);
var inst_13430 = cljs.core.async.close_BANG_(inst_13427);
var state_13513__$1 = state_13513;
var statearr_13545_13616 = state_13513__$1;
(statearr_13545_13616[(2)] = inst_13430);

(statearr_13545_13616[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (36))){
var inst_13473 = (state_13513[(23)]);
var inst_13477 = cljs.core.chunk_first(inst_13473);
var inst_13478 = cljs.core.chunk_rest(inst_13473);
var inst_13479 = cljs.core.count(inst_13477);
var inst_13455 = inst_13478;
var inst_13456 = inst_13477;
var inst_13457 = inst_13479;
var inst_13458 = (0);
var state_13513__$1 = (function (){var statearr_13546 = state_13513;
(statearr_13546[(9)] = inst_13456);

(statearr_13546[(19)] = inst_13455);

(statearr_13546[(20)] = inst_13457);

(statearr_13546[(12)] = inst_13458);

return statearr_13546;
})();
var statearr_13547_13617 = state_13513__$1;
(statearr_13547_13617[(2)] = null);

(statearr_13547_13617[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (41))){
var inst_13473 = (state_13513[(23)]);
var inst_13488 = (state_13513[(2)]);
var inst_13489 = cljs.core.next(inst_13473);
var inst_13455 = inst_13489;
var inst_13456 = null;
var inst_13457 = (0);
var inst_13458 = (0);
var state_13513__$1 = (function (){var statearr_13548 = state_13513;
(statearr_13548[(9)] = inst_13456);

(statearr_13548[(19)] = inst_13455);

(statearr_13548[(20)] = inst_13457);

(statearr_13548[(25)] = inst_13488);

(statearr_13548[(12)] = inst_13458);

return statearr_13548;
})();
var statearr_13549_13618 = state_13513__$1;
(statearr_13549_13618[(2)] = null);

(statearr_13549_13618[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (43))){
var state_13513__$1 = state_13513;
var statearr_13550_13619 = state_13513__$1;
(statearr_13550_13619[(2)] = null);

(statearr_13550_13619[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (29))){
var inst_13497 = (state_13513[(2)]);
var state_13513__$1 = state_13513;
var statearr_13551_13620 = state_13513__$1;
(statearr_13551_13620[(2)] = inst_13497);

(statearr_13551_13620[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (44))){
var inst_13506 = (state_13513[(2)]);
var state_13513__$1 = (function (){var statearr_13552 = state_13513;
(statearr_13552[(26)] = inst_13506);

return statearr_13552;
})();
var statearr_13553_13621 = state_13513__$1;
(statearr_13553_13621[(2)] = null);

(statearr_13553_13621[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (6))){
var inst_13447 = (state_13513[(27)]);
var inst_13446 = cljs.core.deref(cs);
var inst_13447__$1 = cljs.core.keys(inst_13446);
var inst_13448 = cljs.core.count(inst_13447__$1);
var inst_13449 = cljs.core.reset_BANG_(dctr,inst_13448);
var inst_13454 = cljs.core.seq(inst_13447__$1);
var inst_13455 = inst_13454;
var inst_13456 = null;
var inst_13457 = (0);
var inst_13458 = (0);
var state_13513__$1 = (function (){var statearr_13554 = state_13513;
(statearr_13554[(9)] = inst_13456);

(statearr_13554[(19)] = inst_13455);

(statearr_13554[(28)] = inst_13449);

(statearr_13554[(20)] = inst_13457);

(statearr_13554[(27)] = inst_13447__$1);

(statearr_13554[(12)] = inst_13458);

return statearr_13554;
})();
var statearr_13555_13622 = state_13513__$1;
(statearr_13555_13622[(2)] = null);

(statearr_13555_13622[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (28))){
var inst_13455 = (state_13513[(19)]);
var inst_13473 = (state_13513[(23)]);
var inst_13473__$1 = cljs.core.seq(inst_13455);
var state_13513__$1 = (function (){var statearr_13556 = state_13513;
(statearr_13556[(23)] = inst_13473__$1);

return statearr_13556;
})();
if(inst_13473__$1){
var statearr_13557_13623 = state_13513__$1;
(statearr_13557_13623[(1)] = (33));

} else {
var statearr_13558_13624 = state_13513__$1;
(statearr_13558_13624[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (25))){
var inst_13457 = (state_13513[(20)]);
var inst_13458 = (state_13513[(12)]);
var inst_13460 = (inst_13458 < inst_13457);
var inst_13461 = inst_13460;
var state_13513__$1 = state_13513;
if(cljs.core.truth_(inst_13461)){
var statearr_13559_13625 = state_13513__$1;
(statearr_13559_13625[(1)] = (27));

} else {
var statearr_13560_13626 = state_13513__$1;
(statearr_13560_13626[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (34))){
var state_13513__$1 = state_13513;
var statearr_13561_13627 = state_13513__$1;
(statearr_13561_13627[(2)] = null);

(statearr_13561_13627[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (17))){
var state_13513__$1 = state_13513;
var statearr_13562_13628 = state_13513__$1;
(statearr_13562_13628[(2)] = null);

(statearr_13562_13628[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (3))){
var inst_13511 = (state_13513[(2)]);
var state_13513__$1 = state_13513;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13513__$1,inst_13511);
} else {
if((state_val_13514 === (12))){
var inst_13442 = (state_13513[(2)]);
var state_13513__$1 = state_13513;
var statearr_13563_13629 = state_13513__$1;
(statearr_13563_13629[(2)] = inst_13442);

(statearr_13563_13629[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (2))){
var state_13513__$1 = state_13513;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13513__$1,(4),ch);
} else {
if((state_val_13514 === (23))){
var state_13513__$1 = state_13513;
var statearr_13564_13630 = state_13513__$1;
(statearr_13564_13630[(2)] = null);

(statearr_13564_13630[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (35))){
var inst_13495 = (state_13513[(2)]);
var state_13513__$1 = state_13513;
var statearr_13565_13631 = state_13513__$1;
(statearr_13565_13631[(2)] = inst_13495);

(statearr_13565_13631[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (19))){
var inst_13414 = (state_13513[(7)]);
var inst_13418 = cljs.core.chunk_first(inst_13414);
var inst_13419 = cljs.core.chunk_rest(inst_13414);
var inst_13420 = cljs.core.count(inst_13418);
var inst_13392 = inst_13419;
var inst_13393 = inst_13418;
var inst_13394 = inst_13420;
var inst_13395 = (0);
var state_13513__$1 = (function (){var statearr_13566 = state_13513;
(statearr_13566[(13)] = inst_13394);

(statearr_13566[(14)] = inst_13393);

(statearr_13566[(15)] = inst_13395);

(statearr_13566[(17)] = inst_13392);

return statearr_13566;
})();
var statearr_13567_13632 = state_13513__$1;
(statearr_13567_13632[(2)] = null);

(statearr_13567_13632[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (11))){
var inst_13414 = (state_13513[(7)]);
var inst_13392 = (state_13513[(17)]);
var inst_13414__$1 = cljs.core.seq(inst_13392);
var state_13513__$1 = (function (){var statearr_13568 = state_13513;
(statearr_13568[(7)] = inst_13414__$1);

return statearr_13568;
})();
if(inst_13414__$1){
var statearr_13569_13633 = state_13513__$1;
(statearr_13569_13633[(1)] = (16));

} else {
var statearr_13570_13634 = state_13513__$1;
(statearr_13570_13634[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (9))){
var inst_13444 = (state_13513[(2)]);
var state_13513__$1 = state_13513;
var statearr_13571_13635 = state_13513__$1;
(statearr_13571_13635[(2)] = inst_13444);

(statearr_13571_13635[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (5))){
var inst_13390 = cljs.core.deref(cs);
var inst_13391 = cljs.core.seq(inst_13390);
var inst_13392 = inst_13391;
var inst_13393 = null;
var inst_13394 = (0);
var inst_13395 = (0);
var state_13513__$1 = (function (){var statearr_13572 = state_13513;
(statearr_13572[(13)] = inst_13394);

(statearr_13572[(14)] = inst_13393);

(statearr_13572[(15)] = inst_13395);

(statearr_13572[(17)] = inst_13392);

return statearr_13572;
})();
var statearr_13573_13636 = state_13513__$1;
(statearr_13573_13636[(2)] = null);

(statearr_13573_13636[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (14))){
var state_13513__$1 = state_13513;
var statearr_13574_13637 = state_13513__$1;
(statearr_13574_13637[(2)] = null);

(statearr_13574_13637[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (45))){
var inst_13503 = (state_13513[(2)]);
var state_13513__$1 = state_13513;
var statearr_13575_13638 = state_13513__$1;
(statearr_13575_13638[(2)] = inst_13503);

(statearr_13575_13638[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (26))){
var inst_13447 = (state_13513[(27)]);
var inst_13499 = (state_13513[(2)]);
var inst_13500 = cljs.core.seq(inst_13447);
var state_13513__$1 = (function (){var statearr_13576 = state_13513;
(statearr_13576[(29)] = inst_13499);

return statearr_13576;
})();
if(inst_13500){
var statearr_13577_13639 = state_13513__$1;
(statearr_13577_13639[(1)] = (42));

} else {
var statearr_13578_13640 = state_13513__$1;
(statearr_13578_13640[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (16))){
var inst_13414 = (state_13513[(7)]);
var inst_13416 = cljs.core.chunked_seq_QMARK_(inst_13414);
var state_13513__$1 = state_13513;
if(inst_13416){
var statearr_13579_13641 = state_13513__$1;
(statearr_13579_13641[(1)] = (19));

} else {
var statearr_13580_13642 = state_13513__$1;
(statearr_13580_13642[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (38))){
var inst_13492 = (state_13513[(2)]);
var state_13513__$1 = state_13513;
var statearr_13581_13643 = state_13513__$1;
(statearr_13581_13643[(2)] = inst_13492);

(statearr_13581_13643[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (30))){
var state_13513__$1 = state_13513;
var statearr_13582_13644 = state_13513__$1;
(statearr_13582_13644[(2)] = null);

(statearr_13582_13644[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (10))){
var inst_13393 = (state_13513[(14)]);
var inst_13395 = (state_13513[(15)]);
var inst_13403 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_13393,inst_13395);
var inst_13404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13403,(0),null);
var inst_13405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13403,(1),null);
var state_13513__$1 = (function (){var statearr_13583 = state_13513;
(statearr_13583[(24)] = inst_13404);

return statearr_13583;
})();
if(cljs.core.truth_(inst_13405)){
var statearr_13584_13645 = state_13513__$1;
(statearr_13584_13645[(1)] = (13));

} else {
var statearr_13585_13646 = state_13513__$1;
(statearr_13585_13646[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (18))){
var inst_13440 = (state_13513[(2)]);
var state_13513__$1 = state_13513;
var statearr_13586_13647 = state_13513__$1;
(statearr_13586_13647[(2)] = inst_13440);

(statearr_13586_13647[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (42))){
var state_13513__$1 = state_13513;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13513__$1,(45),dchan);
} else {
if((state_val_13514 === (37))){
var inst_13383 = (state_13513[(10)]);
var inst_13482 = (state_13513[(22)]);
var inst_13473 = (state_13513[(23)]);
var inst_13482__$1 = cljs.core.first(inst_13473);
var inst_13483 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_13482__$1,inst_13383,done);
var state_13513__$1 = (function (){var statearr_13587 = state_13513;
(statearr_13587[(22)] = inst_13482__$1);

return statearr_13587;
})();
if(cljs.core.truth_(inst_13483)){
var statearr_13588_13648 = state_13513__$1;
(statearr_13588_13648[(1)] = (39));

} else {
var statearr_13589_13649 = state_13513__$1;
(statearr_13589_13649[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13514 === (8))){
var inst_13394 = (state_13513[(13)]);
var inst_13395 = (state_13513[(15)]);
var inst_13397 = (inst_13395 < inst_13394);
var inst_13398 = inst_13397;
var state_13513__$1 = state_13513;
if(cljs.core.truth_(inst_13398)){
var statearr_13590_13650 = state_13513__$1;
(statearr_13590_13650[(1)] = (10));

} else {
var statearr_13591_13651 = state_13513__$1;
(statearr_13591_13651[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__10750__auto__ = null;
var cljs$core$async$mult_$_state_machine__10750__auto____0 = (function (){
var statearr_13592 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13592[(0)] = cljs$core$async$mult_$_state_machine__10750__auto__);

(statearr_13592[(1)] = (1));

return statearr_13592;
});
var cljs$core$async$mult_$_state_machine__10750__auto____1 = (function (state_13513){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_13513);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e13593){var ex__10753__auto__ = e13593;
var statearr_13594_13652 = state_13513;
(statearr_13594_13652[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_13513[(4)]))){
var statearr_13595_13653 = state_13513;
(statearr_13595_13653[(1)] = cljs.core.first((state_13513[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__13654 = state_13513;
state_13513 = G__13654;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10750__auto__ = function(state_13513){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10750__auto____1.call(this,state_13513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10750__auto____0;
cljs$core$async$mult_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10750__auto____1;
return cljs$core$async$mult_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_13596 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_13596[(6)] = c__10876__auto___13597);

return statearr_13596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__13656 = arguments.length;
switch (G__13656) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_13658 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_13658(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_13659 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_13659(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_13660 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_13660(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_13661 = (function (m,state_map){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4510__auto__.call(null,m,state_map));
} else {
var m__4508__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4508__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_13661(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_13662 = (function (m,mode){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4510__auto__.call(null,m,mode));
} else {
var m__4508__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4508__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_13662(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___13672 = arguments.length;
var i__4819__auto___13673 = (0);
while(true){
if((i__4819__auto___13673 < len__4818__auto___13672)){
args__4824__auto__.push((arguments[i__4819__auto___13673]));

var G__13674 = (i__4819__auto___13673 + (1));
i__4819__auto___13673 = G__13674;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((3) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4825__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13667){
var map__13668 = p__13667;
var map__13668__$1 = cljs.core.__destructure_map(map__13668);
var opts = map__13668__$1;
var statearr_13669_13675 = state;
(statearr_13669_13675[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_13670_13676 = state;
(statearr_13670_13676[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_13671_13677 = state;
(statearr_13671_13677[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13663){
var G__13664 = cljs.core.first(seq13663);
var seq13663__$1 = cljs.core.next(seq13663);
var G__13665 = cljs.core.first(seq13663__$1);
var seq13663__$2 = cljs.core.next(seq13663__$1);
var G__13666 = cljs.core.first(seq13663__$2);
var seq13663__$3 = cljs.core.next(seq13663__$2);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13664,G__13665,G__13666,seq13663__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13678 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13678 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13679){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13679 = meta13679;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13678.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13680,meta13679__$1){
var self__ = this;
var _13680__$1 = this;
return (new cljs.core.async.t_cljs$core$async13678(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13679__$1));
}));

(cljs.core.async.t_cljs$core$async13678.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13680){
var self__ = this;
var _13680__$1 = this;
return self__.meta13679;
}));

(cljs.core.async.t_cljs$core$async13678.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13678.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async13678.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13678.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13678.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13678.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13678.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13678.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13678.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta13679], null);
}));

(cljs.core.async.t_cljs$core$async13678.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13678.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13678");

(cljs.core.async.t_cljs$core$async13678.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13678");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13678.
 */
cljs.core.async.__GT_t_cljs$core$async13678 = (function cljs$core$async$mix_$___GT_t_cljs$core$async13678(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13679){
return (new cljs.core.async.t_cljs$core$async13678(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13679));
});

}

return (new cljs.core.async.t_cljs$core$async13678(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10876__auto___13793 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_13748){
var state_val_13749 = (state_13748[(1)]);
if((state_val_13749 === (7))){
var inst_13708 = (state_13748[(2)]);
var state_13748__$1 = state_13748;
if(cljs.core.truth_(inst_13708)){
var statearr_13750_13794 = state_13748__$1;
(statearr_13750_13794[(1)] = (8));

} else {
var statearr_13751_13795 = state_13748__$1;
(statearr_13751_13795[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (20))){
var inst_13701 = (state_13748[(7)]);
var state_13748__$1 = state_13748;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13748__$1,(23),out,inst_13701);
} else {
if((state_val_13749 === (1))){
var inst_13684 = calc_state();
var inst_13685 = cljs.core.__destructure_map(inst_13684);
var inst_13686 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13685,cljs.core.cst$kw$solos);
var inst_13687 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13685,cljs.core.cst$kw$mutes);
var inst_13688 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13685,cljs.core.cst$kw$reads);
var inst_13689 = inst_13684;
var state_13748__$1 = (function (){var statearr_13752 = state_13748;
(statearr_13752[(8)] = inst_13688);

(statearr_13752[(9)] = inst_13689);

(statearr_13752[(10)] = inst_13686);

(statearr_13752[(11)] = inst_13687);

return statearr_13752;
})();
var statearr_13753_13796 = state_13748__$1;
(statearr_13753_13796[(2)] = null);

(statearr_13753_13796[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (24))){
var inst_13692 = (state_13748[(12)]);
var inst_13689 = inst_13692;
var state_13748__$1 = (function (){var statearr_13754 = state_13748;
(statearr_13754[(9)] = inst_13689);

return statearr_13754;
})();
var statearr_13755_13797 = state_13748__$1;
(statearr_13755_13797[(2)] = null);

(statearr_13755_13797[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (4))){
var inst_13701 = (state_13748[(7)]);
var inst_13703 = (state_13748[(13)]);
var inst_13700 = (state_13748[(2)]);
var inst_13701__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13700,(0),null);
var inst_13702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13700,(1),null);
var inst_13703__$1 = (inst_13701__$1 == null);
var state_13748__$1 = (function (){var statearr_13756 = state_13748;
(statearr_13756[(14)] = inst_13702);

(statearr_13756[(7)] = inst_13701__$1);

(statearr_13756[(13)] = inst_13703__$1);

return statearr_13756;
})();
if(cljs.core.truth_(inst_13703__$1)){
var statearr_13757_13798 = state_13748__$1;
(statearr_13757_13798[(1)] = (5));

} else {
var statearr_13758_13799 = state_13748__$1;
(statearr_13758_13799[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (15))){
var inst_13693 = (state_13748[(15)]);
var inst_13722 = (state_13748[(16)]);
var inst_13722__$1 = cljs.core.empty_QMARK_(inst_13693);
var state_13748__$1 = (function (){var statearr_13759 = state_13748;
(statearr_13759[(16)] = inst_13722__$1);

return statearr_13759;
})();
if(inst_13722__$1){
var statearr_13760_13800 = state_13748__$1;
(statearr_13760_13800[(1)] = (17));

} else {
var statearr_13761_13801 = state_13748__$1;
(statearr_13761_13801[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (21))){
var inst_13692 = (state_13748[(12)]);
var inst_13689 = inst_13692;
var state_13748__$1 = (function (){var statearr_13762 = state_13748;
(statearr_13762[(9)] = inst_13689);

return statearr_13762;
})();
var statearr_13763_13802 = state_13748__$1;
(statearr_13763_13802[(2)] = null);

(statearr_13763_13802[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (13))){
var inst_13715 = (state_13748[(2)]);
var inst_13716 = calc_state();
var inst_13689 = inst_13716;
var state_13748__$1 = (function (){var statearr_13764 = state_13748;
(statearr_13764[(17)] = inst_13715);

(statearr_13764[(9)] = inst_13689);

return statearr_13764;
})();
var statearr_13765_13803 = state_13748__$1;
(statearr_13765_13803[(2)] = null);

(statearr_13765_13803[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (22))){
var inst_13742 = (state_13748[(2)]);
var state_13748__$1 = state_13748;
var statearr_13766_13804 = state_13748__$1;
(statearr_13766_13804[(2)] = inst_13742);

(statearr_13766_13804[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (6))){
var inst_13702 = (state_13748[(14)]);
var inst_13706 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13702,change);
var state_13748__$1 = state_13748;
var statearr_13767_13805 = state_13748__$1;
(statearr_13767_13805[(2)] = inst_13706);

(statearr_13767_13805[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (25))){
var state_13748__$1 = state_13748;
var statearr_13768_13806 = state_13748__$1;
(statearr_13768_13806[(2)] = null);

(statearr_13768_13806[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (17))){
var inst_13702 = (state_13748[(14)]);
var inst_13694 = (state_13748[(18)]);
var inst_13724 = (inst_13694.cljs$core$IFn$_invoke$arity$1 ? inst_13694.cljs$core$IFn$_invoke$arity$1(inst_13702) : inst_13694.call(null,inst_13702));
var inst_13725 = cljs.core.not(inst_13724);
var state_13748__$1 = state_13748;
var statearr_13769_13807 = state_13748__$1;
(statearr_13769_13807[(2)] = inst_13725);

(statearr_13769_13807[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (3))){
var inst_13746 = (state_13748[(2)]);
var state_13748__$1 = state_13748;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13748__$1,inst_13746);
} else {
if((state_val_13749 === (12))){
var state_13748__$1 = state_13748;
var statearr_13770_13808 = state_13748__$1;
(statearr_13770_13808[(2)] = null);

(statearr_13770_13808[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (2))){
var inst_13689 = (state_13748[(9)]);
var inst_13692 = (state_13748[(12)]);
var inst_13692__$1 = cljs.core.__destructure_map(inst_13689);
var inst_13693 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13692__$1,cljs.core.cst$kw$solos);
var inst_13694 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13692__$1,cljs.core.cst$kw$mutes);
var inst_13695 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13692__$1,cljs.core.cst$kw$reads);
var state_13748__$1 = (function (){var statearr_13771 = state_13748;
(statearr_13771[(15)] = inst_13693);

(statearr_13771[(18)] = inst_13694);

(statearr_13771[(12)] = inst_13692__$1);

return statearr_13771;
})();
return cljs.core.async.ioc_alts_BANG_(state_13748__$1,(4),inst_13695);
} else {
if((state_val_13749 === (23))){
var inst_13733 = (state_13748[(2)]);
var state_13748__$1 = state_13748;
if(cljs.core.truth_(inst_13733)){
var statearr_13772_13809 = state_13748__$1;
(statearr_13772_13809[(1)] = (24));

} else {
var statearr_13773_13810 = state_13748__$1;
(statearr_13773_13810[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (19))){
var inst_13728 = (state_13748[(2)]);
var state_13748__$1 = state_13748;
var statearr_13774_13811 = state_13748__$1;
(statearr_13774_13811[(2)] = inst_13728);

(statearr_13774_13811[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (11))){
var inst_13702 = (state_13748[(14)]);
var inst_13712 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_13702);
var state_13748__$1 = state_13748;
var statearr_13775_13812 = state_13748__$1;
(statearr_13775_13812[(2)] = inst_13712);

(statearr_13775_13812[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (9))){
var inst_13702 = (state_13748[(14)]);
var inst_13719 = (state_13748[(19)]);
var inst_13693 = (state_13748[(15)]);
var inst_13719__$1 = (inst_13693.cljs$core$IFn$_invoke$arity$1 ? inst_13693.cljs$core$IFn$_invoke$arity$1(inst_13702) : inst_13693.call(null,inst_13702));
var state_13748__$1 = (function (){var statearr_13776 = state_13748;
(statearr_13776[(19)] = inst_13719__$1);

return statearr_13776;
})();
if(cljs.core.truth_(inst_13719__$1)){
var statearr_13777_13813 = state_13748__$1;
(statearr_13777_13813[(1)] = (14));

} else {
var statearr_13778_13814 = state_13748__$1;
(statearr_13778_13814[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (5))){
var inst_13703 = (state_13748[(13)]);
var state_13748__$1 = state_13748;
var statearr_13779_13815 = state_13748__$1;
(statearr_13779_13815[(2)] = inst_13703);

(statearr_13779_13815[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (14))){
var inst_13719 = (state_13748[(19)]);
var state_13748__$1 = state_13748;
var statearr_13780_13816 = state_13748__$1;
(statearr_13780_13816[(2)] = inst_13719);

(statearr_13780_13816[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (26))){
var inst_13738 = (state_13748[(2)]);
var state_13748__$1 = state_13748;
var statearr_13781_13817 = state_13748__$1;
(statearr_13781_13817[(2)] = inst_13738);

(statearr_13781_13817[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (16))){
var inst_13730 = (state_13748[(2)]);
var state_13748__$1 = state_13748;
if(cljs.core.truth_(inst_13730)){
var statearr_13782_13818 = state_13748__$1;
(statearr_13782_13818[(1)] = (20));

} else {
var statearr_13783_13819 = state_13748__$1;
(statearr_13783_13819[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (10))){
var inst_13744 = (state_13748[(2)]);
var state_13748__$1 = state_13748;
var statearr_13784_13820 = state_13748__$1;
(statearr_13784_13820[(2)] = inst_13744);

(statearr_13784_13820[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (18))){
var inst_13722 = (state_13748[(16)]);
var state_13748__$1 = state_13748;
var statearr_13785_13821 = state_13748__$1;
(statearr_13785_13821[(2)] = inst_13722);

(statearr_13785_13821[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13749 === (8))){
var inst_13701 = (state_13748[(7)]);
var inst_13710 = (inst_13701 == null);
var state_13748__$1 = state_13748;
if(cljs.core.truth_(inst_13710)){
var statearr_13786_13822 = state_13748__$1;
(statearr_13786_13822[(1)] = (11));

} else {
var statearr_13787_13823 = state_13748__$1;
(statearr_13787_13823[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__10750__auto__ = null;
var cljs$core$async$mix_$_state_machine__10750__auto____0 = (function (){
var statearr_13788 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13788[(0)] = cljs$core$async$mix_$_state_machine__10750__auto__);

(statearr_13788[(1)] = (1));

return statearr_13788;
});
var cljs$core$async$mix_$_state_machine__10750__auto____1 = (function (state_13748){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_13748);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e13789){var ex__10753__auto__ = e13789;
var statearr_13790_13824 = state_13748;
(statearr_13790_13824[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_13748[(4)]))){
var statearr_13791_13825 = state_13748;
(statearr_13791_13825[(1)] = cljs.core.first((state_13748[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__13826 = state_13748;
state_13748 = G__13826;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10750__auto__ = function(state_13748){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10750__auto____1.call(this,state_13748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10750__auto____0;
cljs$core$async$mix_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10750__auto____1;
return cljs$core$async$mix_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_13792 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_13792[(6)] = c__10876__auto___13793);

return statearr_13792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_13829 = (function (p,v,ch,close_QMARK_){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4510__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4508__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_13829(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_13830 = (function (p,v,ch){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4510__auto__.call(null,p,v,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4508__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_13830(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_13831 = (function() {
var G__13832 = null;
var G__13832__1 = (function (p){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4510__auto__.call(null,p));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4508__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__13832__2 = (function (p,v){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4510__auto__.call(null,p,v));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4508__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__13832 = function(p,v){
switch(arguments.length){
case 1:
return G__13832__1.call(this,p);
case 2:
return G__13832__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13832.cljs$core$IFn$_invoke$arity$1 = G__13832__1;
G__13832.cljs$core$IFn$_invoke$arity$2 = G__13832__2;
return G__13832;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__13828 = arguments.length;
switch (G__13828) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_13831.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_13831.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__13836 = arguments.length;
switch (G__13836) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__13834_SHARP_){
if(cljs.core.truth_((p1__13834_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__13834_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__13834_SHARP_.call(null,topic)))){
return p1__13834_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__13834_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13837 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13837 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta13838){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta13838 = meta13838;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13837.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13839,meta13838__$1){
var self__ = this;
var _13839__$1 = this;
return (new cljs.core.async.t_cljs$core$async13837(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta13838__$1));
}));

(cljs.core.async.t_cljs$core$async13837.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13839){
var self__ = this;
var _13839__$1 = this;
return self__.meta13838;
}));

(cljs.core.async.t_cljs$core$async13837.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13837.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async13837.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13837.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async13837.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async13837.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async13837.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async13837.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta13838], null);
}));

(cljs.core.async.t_cljs$core$async13837.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13837.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13837");

(cljs.core.async.t_cljs$core$async13837.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13837");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13837.
 */
cljs.core.async.__GT_t_cljs$core$async13837 = (function cljs$core$async$__GT_t_cljs$core$async13837(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta13838){
return (new cljs.core.async.t_cljs$core$async13837(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta13838));
});

}

return (new cljs.core.async.t_cljs$core$async13837(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10876__auto___13958 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_13911){
var state_val_13912 = (state_13911[(1)]);
if((state_val_13912 === (7))){
var inst_13907 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
var statearr_13913_13959 = state_13911__$1;
(statearr_13913_13959[(2)] = inst_13907);

(statearr_13913_13959[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (20))){
var state_13911__$1 = state_13911;
var statearr_13914_13960 = state_13911__$1;
(statearr_13914_13960[(2)] = null);

(statearr_13914_13960[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (1))){
var state_13911__$1 = state_13911;
var statearr_13915_13961 = state_13911__$1;
(statearr_13915_13961[(2)] = null);

(statearr_13915_13961[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (24))){
var inst_13890 = (state_13911[(7)]);
var inst_13899 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_13890);
var state_13911__$1 = state_13911;
var statearr_13916_13962 = state_13911__$1;
(statearr_13916_13962[(2)] = inst_13899);

(statearr_13916_13962[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (4))){
var inst_13842 = (state_13911[(8)]);
var inst_13842__$1 = (state_13911[(2)]);
var inst_13843 = (inst_13842__$1 == null);
var state_13911__$1 = (function (){var statearr_13917 = state_13911;
(statearr_13917[(8)] = inst_13842__$1);

return statearr_13917;
})();
if(cljs.core.truth_(inst_13843)){
var statearr_13918_13963 = state_13911__$1;
(statearr_13918_13963[(1)] = (5));

} else {
var statearr_13919_13964 = state_13911__$1;
(statearr_13919_13964[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (15))){
var inst_13884 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
var statearr_13920_13965 = state_13911__$1;
(statearr_13920_13965[(2)] = inst_13884);

(statearr_13920_13965[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (21))){
var inst_13904 = (state_13911[(2)]);
var state_13911__$1 = (function (){var statearr_13921 = state_13911;
(statearr_13921[(9)] = inst_13904);

return statearr_13921;
})();
var statearr_13922_13966 = state_13911__$1;
(statearr_13922_13966[(2)] = null);

(statearr_13922_13966[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (13))){
var inst_13866 = (state_13911[(10)]);
var inst_13868 = cljs.core.chunked_seq_QMARK_(inst_13866);
var state_13911__$1 = state_13911;
if(inst_13868){
var statearr_13923_13967 = state_13911__$1;
(statearr_13923_13967[(1)] = (16));

} else {
var statearr_13924_13968 = state_13911__$1;
(statearr_13924_13968[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (22))){
var inst_13896 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
if(cljs.core.truth_(inst_13896)){
var statearr_13925_13969 = state_13911__$1;
(statearr_13925_13969[(1)] = (23));

} else {
var statearr_13926_13970 = state_13911__$1;
(statearr_13926_13970[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (6))){
var inst_13892 = (state_13911[(11)]);
var inst_13890 = (state_13911[(7)]);
var inst_13842 = (state_13911[(8)]);
var inst_13890__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_13842) : topic_fn.call(null,inst_13842));
var inst_13891 = cljs.core.deref(mults);
var inst_13892__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13891,inst_13890__$1);
var state_13911__$1 = (function (){var statearr_13927 = state_13911;
(statearr_13927[(11)] = inst_13892__$1);

(statearr_13927[(7)] = inst_13890__$1);

return statearr_13927;
})();
if(cljs.core.truth_(inst_13892__$1)){
var statearr_13928_13971 = state_13911__$1;
(statearr_13928_13971[(1)] = (19));

} else {
var statearr_13929_13972 = state_13911__$1;
(statearr_13929_13972[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (25))){
var inst_13901 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
var statearr_13930_13973 = state_13911__$1;
(statearr_13930_13973[(2)] = inst_13901);

(statearr_13930_13973[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (17))){
var inst_13866 = (state_13911[(10)]);
var inst_13875 = cljs.core.first(inst_13866);
var inst_13876 = cljs.core.async.muxch_STAR_(inst_13875);
var inst_13877 = cljs.core.async.close_BANG_(inst_13876);
var inst_13878 = cljs.core.next(inst_13866);
var inst_13852 = inst_13878;
var inst_13853 = null;
var inst_13854 = (0);
var inst_13855 = (0);
var state_13911__$1 = (function (){var statearr_13931 = state_13911;
(statearr_13931[(12)] = inst_13853);

(statearr_13931[(13)] = inst_13855);

(statearr_13931[(14)] = inst_13852);

(statearr_13931[(15)] = inst_13877);

(statearr_13931[(16)] = inst_13854);

return statearr_13931;
})();
var statearr_13932_13974 = state_13911__$1;
(statearr_13932_13974[(2)] = null);

(statearr_13932_13974[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (3))){
var inst_13909 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13911__$1,inst_13909);
} else {
if((state_val_13912 === (12))){
var inst_13886 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
var statearr_13933_13975 = state_13911__$1;
(statearr_13933_13975[(2)] = inst_13886);

(statearr_13933_13975[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (2))){
var state_13911__$1 = state_13911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13911__$1,(4),ch);
} else {
if((state_val_13912 === (23))){
var state_13911__$1 = state_13911;
var statearr_13934_13976 = state_13911__$1;
(statearr_13934_13976[(2)] = null);

(statearr_13934_13976[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (19))){
var inst_13892 = (state_13911[(11)]);
var inst_13842 = (state_13911[(8)]);
var inst_13894 = cljs.core.async.muxch_STAR_(inst_13892);
var state_13911__$1 = state_13911;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13911__$1,(22),inst_13894,inst_13842);
} else {
if((state_val_13912 === (11))){
var inst_13866 = (state_13911[(10)]);
var inst_13852 = (state_13911[(14)]);
var inst_13866__$1 = cljs.core.seq(inst_13852);
var state_13911__$1 = (function (){var statearr_13935 = state_13911;
(statearr_13935[(10)] = inst_13866__$1);

return statearr_13935;
})();
if(inst_13866__$1){
var statearr_13936_13977 = state_13911__$1;
(statearr_13936_13977[(1)] = (13));

} else {
var statearr_13937_13978 = state_13911__$1;
(statearr_13937_13978[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (9))){
var inst_13888 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
var statearr_13938_13979 = state_13911__$1;
(statearr_13938_13979[(2)] = inst_13888);

(statearr_13938_13979[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (5))){
var inst_13849 = cljs.core.deref(mults);
var inst_13850 = cljs.core.vals(inst_13849);
var inst_13851 = cljs.core.seq(inst_13850);
var inst_13852 = inst_13851;
var inst_13853 = null;
var inst_13854 = (0);
var inst_13855 = (0);
var state_13911__$1 = (function (){var statearr_13939 = state_13911;
(statearr_13939[(12)] = inst_13853);

(statearr_13939[(13)] = inst_13855);

(statearr_13939[(14)] = inst_13852);

(statearr_13939[(16)] = inst_13854);

return statearr_13939;
})();
var statearr_13940_13980 = state_13911__$1;
(statearr_13940_13980[(2)] = null);

(statearr_13940_13980[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (14))){
var state_13911__$1 = state_13911;
var statearr_13944_13981 = state_13911__$1;
(statearr_13944_13981[(2)] = null);

(statearr_13944_13981[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (16))){
var inst_13866 = (state_13911[(10)]);
var inst_13870 = cljs.core.chunk_first(inst_13866);
var inst_13871 = cljs.core.chunk_rest(inst_13866);
var inst_13872 = cljs.core.count(inst_13870);
var inst_13852 = inst_13871;
var inst_13853 = inst_13870;
var inst_13854 = inst_13872;
var inst_13855 = (0);
var state_13911__$1 = (function (){var statearr_13945 = state_13911;
(statearr_13945[(12)] = inst_13853);

(statearr_13945[(13)] = inst_13855);

(statearr_13945[(14)] = inst_13852);

(statearr_13945[(16)] = inst_13854);

return statearr_13945;
})();
var statearr_13946_13982 = state_13911__$1;
(statearr_13946_13982[(2)] = null);

(statearr_13946_13982[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (10))){
var inst_13853 = (state_13911[(12)]);
var inst_13855 = (state_13911[(13)]);
var inst_13852 = (state_13911[(14)]);
var inst_13854 = (state_13911[(16)]);
var inst_13860 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_13853,inst_13855);
var inst_13861 = cljs.core.async.muxch_STAR_(inst_13860);
var inst_13862 = cljs.core.async.close_BANG_(inst_13861);
var inst_13863 = (inst_13855 + (1));
var tmp13941 = inst_13853;
var tmp13942 = inst_13852;
var tmp13943 = inst_13854;
var inst_13852__$1 = tmp13942;
var inst_13853__$1 = tmp13941;
var inst_13854__$1 = tmp13943;
var inst_13855__$1 = inst_13863;
var state_13911__$1 = (function (){var statearr_13947 = state_13911;
(statearr_13947[(12)] = inst_13853__$1);

(statearr_13947[(17)] = inst_13862);

(statearr_13947[(13)] = inst_13855__$1);

(statearr_13947[(14)] = inst_13852__$1);

(statearr_13947[(16)] = inst_13854__$1);

return statearr_13947;
})();
var statearr_13948_13983 = state_13911__$1;
(statearr_13948_13983[(2)] = null);

(statearr_13948_13983[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (18))){
var inst_13881 = (state_13911[(2)]);
var state_13911__$1 = state_13911;
var statearr_13949_13984 = state_13911__$1;
(statearr_13949_13984[(2)] = inst_13881);

(statearr_13949_13984[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_13912 === (8))){
var inst_13855 = (state_13911[(13)]);
var inst_13854 = (state_13911[(16)]);
var inst_13857 = (inst_13855 < inst_13854);
var inst_13858 = inst_13857;
var state_13911__$1 = state_13911;
if(cljs.core.truth_(inst_13858)){
var statearr_13950_13985 = state_13911__$1;
(statearr_13950_13985[(1)] = (10));

} else {
var statearr_13951_13986 = state_13911__$1;
(statearr_13951_13986[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10750__auto__ = null;
var cljs$core$async$state_machine__10750__auto____0 = (function (){
var statearr_13952 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13952[(0)] = cljs$core$async$state_machine__10750__auto__);

(statearr_13952[(1)] = (1));

return statearr_13952;
});
var cljs$core$async$state_machine__10750__auto____1 = (function (state_13911){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_13911);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e13953){var ex__10753__auto__ = e13953;
var statearr_13954_13987 = state_13911;
(statearr_13954_13987[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_13911[(4)]))){
var statearr_13955_13988 = state_13911;
(statearr_13955_13988[(1)] = cljs.core.first((state_13911[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__13989 = state_13911;
state_13911 = G__13989;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$state_machine__10750__auto__ = function(state_13911){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10750__auto____1.call(this,state_13911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10750__auto____0;
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10750__auto____1;
return cljs$core$async$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_13956 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_13956[(6)] = c__10876__auto___13958);

return statearr_13956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__13991 = arguments.length;
switch (G__13991) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__13994 = arguments.length;
switch (G__13994) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__13997 = arguments.length;
switch (G__13997) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__10876__auto___14075 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_14040){
var state_val_14041 = (state_14040[(1)]);
if((state_val_14041 === (7))){
var state_14040__$1 = state_14040;
var statearr_14042_14076 = state_14040__$1;
(statearr_14042_14076[(2)] = null);

(statearr_14042_14076[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (1))){
var state_14040__$1 = state_14040;
var statearr_14043_14077 = state_14040__$1;
(statearr_14043_14077[(2)] = null);

(statearr_14043_14077[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (4))){
var inst_14000 = (state_14040[(7)]);
var inst_14001 = (state_14040[(8)]);
var inst_14003 = (inst_14001 < inst_14000);
var state_14040__$1 = state_14040;
if(cljs.core.truth_(inst_14003)){
var statearr_14044_14078 = state_14040__$1;
(statearr_14044_14078[(1)] = (6));

} else {
var statearr_14045_14079 = state_14040__$1;
(statearr_14045_14079[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (15))){
var inst_14026 = (state_14040[(9)]);
var inst_14031 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_14026);
var state_14040__$1 = state_14040;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14040__$1,(17),out,inst_14031);
} else {
if((state_val_14041 === (13))){
var inst_14026 = (state_14040[(9)]);
var inst_14026__$1 = (state_14040[(2)]);
var inst_14027 = cljs.core.some(cljs.core.nil_QMARK_,inst_14026__$1);
var state_14040__$1 = (function (){var statearr_14046 = state_14040;
(statearr_14046[(9)] = inst_14026__$1);

return statearr_14046;
})();
if(cljs.core.truth_(inst_14027)){
var statearr_14047_14080 = state_14040__$1;
(statearr_14047_14080[(1)] = (14));

} else {
var statearr_14048_14081 = state_14040__$1;
(statearr_14048_14081[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (6))){
var state_14040__$1 = state_14040;
var statearr_14049_14082 = state_14040__$1;
(statearr_14049_14082[(2)] = null);

(statearr_14049_14082[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (17))){
var inst_14033 = (state_14040[(2)]);
var state_14040__$1 = (function (){var statearr_14051 = state_14040;
(statearr_14051[(10)] = inst_14033);

return statearr_14051;
})();
var statearr_14052_14083 = state_14040__$1;
(statearr_14052_14083[(2)] = null);

(statearr_14052_14083[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (3))){
var inst_14038 = (state_14040[(2)]);
var state_14040__$1 = state_14040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14040__$1,inst_14038);
} else {
if((state_val_14041 === (12))){
var _ = (function (){var statearr_14053 = state_14040;
(statearr_14053[(4)] = cljs.core.rest((state_14040[(4)])));

return statearr_14053;
})();
var state_14040__$1 = state_14040;
var ex14050 = (state_14040__$1[(2)]);
var statearr_14054_14084 = state_14040__$1;
(statearr_14054_14084[(5)] = ex14050);


if((ex14050 instanceof Object)){
var statearr_14055_14085 = state_14040__$1;
(statearr_14055_14085[(1)] = (11));

(statearr_14055_14085[(5)] = null);

} else {
throw ex14050;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (2))){
var inst_13999 = cljs.core.reset_BANG_(dctr,cnt);
var inst_14000 = cnt;
var inst_14001 = (0);
var state_14040__$1 = (function (){var statearr_14056 = state_14040;
(statearr_14056[(7)] = inst_14000);

(statearr_14056[(8)] = inst_14001);

(statearr_14056[(11)] = inst_13999);

return statearr_14056;
})();
var statearr_14057_14086 = state_14040__$1;
(statearr_14057_14086[(2)] = null);

(statearr_14057_14086[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (11))){
var inst_14005 = (state_14040[(2)]);
var inst_14006 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_14040__$1 = (function (){var statearr_14058 = state_14040;
(statearr_14058[(12)] = inst_14005);

return statearr_14058;
})();
var statearr_14059_14087 = state_14040__$1;
(statearr_14059_14087[(2)] = inst_14006);

(statearr_14059_14087[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (9))){
var inst_14001 = (state_14040[(8)]);
var _ = (function (){var statearr_14060 = state_14040;
(statearr_14060[(4)] = cljs.core.cons((12),(state_14040[(4)])));

return statearr_14060;
})();
var inst_14012 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_14001) : chs__$1.call(null,inst_14001));
var inst_14013 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_14001) : done.call(null,inst_14001));
var inst_14014 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_14012,inst_14013);
var ___$1 = (function (){var statearr_14061 = state_14040;
(statearr_14061[(4)] = cljs.core.rest((state_14040[(4)])));

return statearr_14061;
})();
var state_14040__$1 = state_14040;
var statearr_14062_14088 = state_14040__$1;
(statearr_14062_14088[(2)] = inst_14014);

(statearr_14062_14088[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (5))){
var inst_14024 = (state_14040[(2)]);
var state_14040__$1 = (function (){var statearr_14063 = state_14040;
(statearr_14063[(13)] = inst_14024);

return statearr_14063;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14040__$1,(13),dchan);
} else {
if((state_val_14041 === (14))){
var inst_14029 = cljs.core.async.close_BANG_(out);
var state_14040__$1 = state_14040;
var statearr_14064_14089 = state_14040__$1;
(statearr_14064_14089[(2)] = inst_14029);

(statearr_14064_14089[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (16))){
var inst_14036 = (state_14040[(2)]);
var state_14040__$1 = state_14040;
var statearr_14065_14090 = state_14040__$1;
(statearr_14065_14090[(2)] = inst_14036);

(statearr_14065_14090[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (10))){
var inst_14001 = (state_14040[(8)]);
var inst_14017 = (state_14040[(2)]);
var inst_14018 = (inst_14001 + (1));
var inst_14001__$1 = inst_14018;
var state_14040__$1 = (function (){var statearr_14066 = state_14040;
(statearr_14066[(8)] = inst_14001__$1);

(statearr_14066[(14)] = inst_14017);

return statearr_14066;
})();
var statearr_14067_14091 = state_14040__$1;
(statearr_14067_14091[(2)] = null);

(statearr_14067_14091[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14041 === (8))){
var inst_14022 = (state_14040[(2)]);
var state_14040__$1 = state_14040;
var statearr_14068_14092 = state_14040__$1;
(statearr_14068_14092[(2)] = inst_14022);

(statearr_14068_14092[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10750__auto__ = null;
var cljs$core$async$state_machine__10750__auto____0 = (function (){
var statearr_14069 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14069[(0)] = cljs$core$async$state_machine__10750__auto__);

(statearr_14069[(1)] = (1));

return statearr_14069;
});
var cljs$core$async$state_machine__10750__auto____1 = (function (state_14040){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_14040);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e14070){var ex__10753__auto__ = e14070;
var statearr_14071_14093 = state_14040;
(statearr_14071_14093[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_14040[(4)]))){
var statearr_14072_14094 = state_14040;
(statearr_14072_14094[(1)] = cljs.core.first((state_14040[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__14095 = state_14040;
state_14040 = G__14095;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$state_machine__10750__auto__ = function(state_14040){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10750__auto____1.call(this,state_14040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10750__auto____0;
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10750__auto____1;
return cljs$core$async$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_14073 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_14073[(6)] = c__10876__auto___14075);

return statearr_14073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__14098 = arguments.length;
switch (G__14098) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__10876__auto___14153 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_14130){
var state_val_14131 = (state_14130[(1)]);
if((state_val_14131 === (7))){
var inst_14109 = (state_14130[(7)]);
var inst_14110 = (state_14130[(8)]);
var inst_14109__$1 = (state_14130[(2)]);
var inst_14110__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14109__$1,(0),null);
var inst_14111 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14109__$1,(1),null);
var inst_14112 = (inst_14110__$1 == null);
var state_14130__$1 = (function (){var statearr_14132 = state_14130;
(statearr_14132[(7)] = inst_14109__$1);

(statearr_14132[(8)] = inst_14110__$1);

(statearr_14132[(9)] = inst_14111);

return statearr_14132;
})();
if(cljs.core.truth_(inst_14112)){
var statearr_14133_14154 = state_14130__$1;
(statearr_14133_14154[(1)] = (8));

} else {
var statearr_14134_14155 = state_14130__$1;
(statearr_14134_14155[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14131 === (1))){
var inst_14099 = cljs.core.vec(chs);
var inst_14100 = inst_14099;
var state_14130__$1 = (function (){var statearr_14135 = state_14130;
(statearr_14135[(10)] = inst_14100);

return statearr_14135;
})();
var statearr_14136_14156 = state_14130__$1;
(statearr_14136_14156[(2)] = null);

(statearr_14136_14156[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14131 === (4))){
var inst_14100 = (state_14130[(10)]);
var state_14130__$1 = state_14130;
return cljs.core.async.ioc_alts_BANG_(state_14130__$1,(7),inst_14100);
} else {
if((state_val_14131 === (6))){
var inst_14126 = (state_14130[(2)]);
var state_14130__$1 = state_14130;
var statearr_14137_14157 = state_14130__$1;
(statearr_14137_14157[(2)] = inst_14126);

(statearr_14137_14157[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14131 === (3))){
var inst_14128 = (state_14130[(2)]);
var state_14130__$1 = state_14130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14130__$1,inst_14128);
} else {
if((state_val_14131 === (2))){
var inst_14100 = (state_14130[(10)]);
var inst_14102 = cljs.core.count(inst_14100);
var inst_14103 = (inst_14102 > (0));
var state_14130__$1 = state_14130;
if(cljs.core.truth_(inst_14103)){
var statearr_14139_14158 = state_14130__$1;
(statearr_14139_14158[(1)] = (4));

} else {
var statearr_14140_14159 = state_14130__$1;
(statearr_14140_14159[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14131 === (11))){
var inst_14100 = (state_14130[(10)]);
var inst_14119 = (state_14130[(2)]);
var tmp14138 = inst_14100;
var inst_14100__$1 = tmp14138;
var state_14130__$1 = (function (){var statearr_14141 = state_14130;
(statearr_14141[(11)] = inst_14119);

(statearr_14141[(10)] = inst_14100__$1);

return statearr_14141;
})();
var statearr_14142_14160 = state_14130__$1;
(statearr_14142_14160[(2)] = null);

(statearr_14142_14160[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14131 === (9))){
var inst_14110 = (state_14130[(8)]);
var state_14130__$1 = state_14130;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14130__$1,(11),out,inst_14110);
} else {
if((state_val_14131 === (5))){
var inst_14124 = cljs.core.async.close_BANG_(out);
var state_14130__$1 = state_14130;
var statearr_14143_14161 = state_14130__$1;
(statearr_14143_14161[(2)] = inst_14124);

(statearr_14143_14161[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14131 === (10))){
var inst_14122 = (state_14130[(2)]);
var state_14130__$1 = state_14130;
var statearr_14144_14162 = state_14130__$1;
(statearr_14144_14162[(2)] = inst_14122);

(statearr_14144_14162[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14131 === (8))){
var inst_14109 = (state_14130[(7)]);
var inst_14100 = (state_14130[(10)]);
var inst_14110 = (state_14130[(8)]);
var inst_14111 = (state_14130[(9)]);
var inst_14114 = (function (){var cs = inst_14100;
var vec__14105 = inst_14109;
var v = inst_14110;
var c = inst_14111;
return (function (p1__14096_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__14096_SHARP_);
});
})();
var inst_14115 = cljs.core.filterv(inst_14114,inst_14100);
var inst_14100__$1 = inst_14115;
var state_14130__$1 = (function (){var statearr_14145 = state_14130;
(statearr_14145[(10)] = inst_14100__$1);

return statearr_14145;
})();
var statearr_14146_14163 = state_14130__$1;
(statearr_14146_14163[(2)] = null);

(statearr_14146_14163[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10750__auto__ = null;
var cljs$core$async$state_machine__10750__auto____0 = (function (){
var statearr_14147 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14147[(0)] = cljs$core$async$state_machine__10750__auto__);

(statearr_14147[(1)] = (1));

return statearr_14147;
});
var cljs$core$async$state_machine__10750__auto____1 = (function (state_14130){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_14130);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e14148){var ex__10753__auto__ = e14148;
var statearr_14149_14164 = state_14130;
(statearr_14149_14164[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_14130[(4)]))){
var statearr_14150_14165 = state_14130;
(statearr_14150_14165[(1)] = cljs.core.first((state_14130[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__14166 = state_14130;
state_14130 = G__14166;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$state_machine__10750__auto__ = function(state_14130){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10750__auto____1.call(this,state_14130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10750__auto____0;
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10750__auto____1;
return cljs$core$async$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_14151 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_14151[(6)] = c__10876__auto___14153);

return statearr_14151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__14168 = arguments.length;
switch (G__14168) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__10876__auto___14214 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_14192){
var state_val_14193 = (state_14192[(1)]);
if((state_val_14193 === (7))){
var inst_14174 = (state_14192[(7)]);
var inst_14174__$1 = (state_14192[(2)]);
var inst_14175 = (inst_14174__$1 == null);
var inst_14176 = cljs.core.not(inst_14175);
var state_14192__$1 = (function (){var statearr_14194 = state_14192;
(statearr_14194[(7)] = inst_14174__$1);

return statearr_14194;
})();
if(inst_14176){
var statearr_14195_14215 = state_14192__$1;
(statearr_14195_14215[(1)] = (8));

} else {
var statearr_14196_14216 = state_14192__$1;
(statearr_14196_14216[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14193 === (1))){
var inst_14169 = (0);
var state_14192__$1 = (function (){var statearr_14197 = state_14192;
(statearr_14197[(8)] = inst_14169);

return statearr_14197;
})();
var statearr_14198_14217 = state_14192__$1;
(statearr_14198_14217[(2)] = null);

(statearr_14198_14217[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14193 === (4))){
var state_14192__$1 = state_14192;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14192__$1,(7),ch);
} else {
if((state_val_14193 === (6))){
var inst_14187 = (state_14192[(2)]);
var state_14192__$1 = state_14192;
var statearr_14199_14218 = state_14192__$1;
(statearr_14199_14218[(2)] = inst_14187);

(statearr_14199_14218[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14193 === (3))){
var inst_14189 = (state_14192[(2)]);
var inst_14190 = cljs.core.async.close_BANG_(out);
var state_14192__$1 = (function (){var statearr_14200 = state_14192;
(statearr_14200[(9)] = inst_14189);

return statearr_14200;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14192__$1,inst_14190);
} else {
if((state_val_14193 === (2))){
var inst_14169 = (state_14192[(8)]);
var inst_14171 = (inst_14169 < n);
var state_14192__$1 = state_14192;
if(cljs.core.truth_(inst_14171)){
var statearr_14201_14219 = state_14192__$1;
(statearr_14201_14219[(1)] = (4));

} else {
var statearr_14202_14220 = state_14192__$1;
(statearr_14202_14220[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14193 === (11))){
var inst_14169 = (state_14192[(8)]);
var inst_14179 = (state_14192[(2)]);
var inst_14180 = (inst_14169 + (1));
var inst_14169__$1 = inst_14180;
var state_14192__$1 = (function (){var statearr_14203 = state_14192;
(statearr_14203[(8)] = inst_14169__$1);

(statearr_14203[(10)] = inst_14179);

return statearr_14203;
})();
var statearr_14204_14221 = state_14192__$1;
(statearr_14204_14221[(2)] = null);

(statearr_14204_14221[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14193 === (9))){
var state_14192__$1 = state_14192;
var statearr_14205_14222 = state_14192__$1;
(statearr_14205_14222[(2)] = null);

(statearr_14205_14222[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14193 === (5))){
var state_14192__$1 = state_14192;
var statearr_14206_14223 = state_14192__$1;
(statearr_14206_14223[(2)] = null);

(statearr_14206_14223[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14193 === (10))){
var inst_14184 = (state_14192[(2)]);
var state_14192__$1 = state_14192;
var statearr_14207_14224 = state_14192__$1;
(statearr_14207_14224[(2)] = inst_14184);

(statearr_14207_14224[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14193 === (8))){
var inst_14174 = (state_14192[(7)]);
var state_14192__$1 = state_14192;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14192__$1,(11),out,inst_14174);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10750__auto__ = null;
var cljs$core$async$state_machine__10750__auto____0 = (function (){
var statearr_14208 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14208[(0)] = cljs$core$async$state_machine__10750__auto__);

(statearr_14208[(1)] = (1));

return statearr_14208;
});
var cljs$core$async$state_machine__10750__auto____1 = (function (state_14192){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_14192);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e14209){var ex__10753__auto__ = e14209;
var statearr_14210_14225 = state_14192;
(statearr_14210_14225[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_14192[(4)]))){
var statearr_14211_14226 = state_14192;
(statearr_14211_14226[(1)] = cljs.core.first((state_14192[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__14227 = state_14192;
state_14192 = G__14227;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$state_machine__10750__auto__ = function(state_14192){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10750__auto____1.call(this,state_14192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10750__auto____0;
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10750__auto____1;
return cljs$core$async$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_14212 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_14212[(6)] = c__10876__auto___14214);

return statearr_14212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14229 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14229 = (function (f,ch,meta14230){
this.f = f;
this.ch = ch;
this.meta14230 = meta14230;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14229.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14231,meta14230__$1){
var self__ = this;
var _14231__$1 = this;
return (new cljs.core.async.t_cljs$core$async14229(self__.f,self__.ch,meta14230__$1));
}));

(cljs.core.async.t_cljs$core$async14229.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14231){
var self__ = this;
var _14231__$1 = this;
return self__.meta14230;
}));

(cljs.core.async.t_cljs$core$async14229.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14229.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14229.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14229.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14229.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14232 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14232 = (function (f,ch,meta14230,_,fn1,meta14233){
this.f = f;
this.ch = ch;
this.meta14230 = meta14230;
this._ = _;
this.fn1 = fn1;
this.meta14233 = meta14233;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14232.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14234,meta14233__$1){
var self__ = this;
var _14234__$1 = this;
return (new cljs.core.async.t_cljs$core$async14232(self__.f,self__.ch,self__.meta14230,self__._,self__.fn1,meta14233__$1));
}));

(cljs.core.async.t_cljs$core$async14232.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14234){
var self__ = this;
var _14234__$1 = this;
return self__.meta14233;
}));

(cljs.core.async.t_cljs$core$async14232.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14232.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async14232.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14232.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__14228_SHARP_){
var G__14235 = (((p1__14228_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__14228_SHARP_) : self__.f.call(null,p1__14228_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__14235) : f1.call(null,G__14235));
});
}));

(cljs.core.async.t_cljs$core$async14232.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta14230,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async14229], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta14233], null);
}));

(cljs.core.async.t_cljs$core$async14232.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14232.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14232");

(cljs.core.async.t_cljs$core$async14232.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async14232");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14232.
 */
cljs.core.async.__GT_t_cljs$core$async14232 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14232(f__$1,ch__$1,meta14230__$1,___$2,fn1__$1,meta14233){
return (new cljs.core.async.t_cljs$core$async14232(f__$1,ch__$1,meta14230__$1,___$2,fn1__$1,meta14233));
});

}

return (new cljs.core.async.t_cljs$core$async14232(self__.f,self__.ch,self__.meta14230,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4210__auto__ = ret;
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4210__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__14236 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__14236) : self__.f.call(null,G__14236));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async14229.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14229.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async14229.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta14230], null);
}));

(cljs.core.async.t_cljs$core$async14229.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14229.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14229");

(cljs.core.async.t_cljs$core$async14229.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async14229");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14229.
 */
cljs.core.async.__GT_t_cljs$core$async14229 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14229(f__$1,ch__$1,meta14230){
return (new cljs.core.async.t_cljs$core$async14229(f__$1,ch__$1,meta14230));
});

}

return (new cljs.core.async.t_cljs$core$async14229(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14237 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14237 = (function (f,ch,meta14238){
this.f = f;
this.ch = ch;
this.meta14238 = meta14238;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14237.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14239,meta14238__$1){
var self__ = this;
var _14239__$1 = this;
return (new cljs.core.async.t_cljs$core$async14237(self__.f,self__.ch,meta14238__$1));
}));

(cljs.core.async.t_cljs$core$async14237.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14239){
var self__ = this;
var _14239__$1 = this;
return self__.meta14238;
}));

(cljs.core.async.t_cljs$core$async14237.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14237.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14237.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14237.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async14237.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14237.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async14237.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta14238], null);
}));

(cljs.core.async.t_cljs$core$async14237.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14237.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14237");

(cljs.core.async.t_cljs$core$async14237.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async14237");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14237.
 */
cljs.core.async.__GT_t_cljs$core$async14237 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async14237(f__$1,ch__$1,meta14238){
return (new cljs.core.async.t_cljs$core$async14237(f__$1,ch__$1,meta14238));
});

}

return (new cljs.core.async.t_cljs$core$async14237(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14240 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14240 = (function (p,ch,meta14241){
this.p = p;
this.ch = ch;
this.meta14241 = meta14241;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14240.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14242,meta14241__$1){
var self__ = this;
var _14242__$1 = this;
return (new cljs.core.async.t_cljs$core$async14240(self__.p,self__.ch,meta14241__$1));
}));

(cljs.core.async.t_cljs$core$async14240.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14242){
var self__ = this;
var _14242__$1 = this;
return self__.meta14241;
}));

(cljs.core.async.t_cljs$core$async14240.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14240.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14240.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async14240.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14240.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async14240.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14240.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async14240.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta14241], null);
}));

(cljs.core.async.t_cljs$core$async14240.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14240.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14240");

(cljs.core.async.t_cljs$core$async14240.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async14240");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14240.
 */
cljs.core.async.__GT_t_cljs$core$async14240 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async14240(p__$1,ch__$1,meta14241){
return (new cljs.core.async.t_cljs$core$async14240(p__$1,ch__$1,meta14241));
});

}

return (new cljs.core.async.t_cljs$core$async14240(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__14244 = arguments.length;
switch (G__14244) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__10876__auto___14285 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_14265){
var state_val_14266 = (state_14265[(1)]);
if((state_val_14266 === (7))){
var inst_14261 = (state_14265[(2)]);
var state_14265__$1 = state_14265;
var statearr_14267_14286 = state_14265__$1;
(statearr_14267_14286[(2)] = inst_14261);

(statearr_14267_14286[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14266 === (1))){
var state_14265__$1 = state_14265;
var statearr_14268_14287 = state_14265__$1;
(statearr_14268_14287[(2)] = null);

(statearr_14268_14287[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14266 === (4))){
var inst_14247 = (state_14265[(7)]);
var inst_14247__$1 = (state_14265[(2)]);
var inst_14248 = (inst_14247__$1 == null);
var state_14265__$1 = (function (){var statearr_14269 = state_14265;
(statearr_14269[(7)] = inst_14247__$1);

return statearr_14269;
})();
if(cljs.core.truth_(inst_14248)){
var statearr_14270_14288 = state_14265__$1;
(statearr_14270_14288[(1)] = (5));

} else {
var statearr_14271_14289 = state_14265__$1;
(statearr_14271_14289[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14266 === (6))){
var inst_14247 = (state_14265[(7)]);
var inst_14252 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_14247) : p.call(null,inst_14247));
var state_14265__$1 = state_14265;
if(cljs.core.truth_(inst_14252)){
var statearr_14272_14290 = state_14265__$1;
(statearr_14272_14290[(1)] = (8));

} else {
var statearr_14273_14291 = state_14265__$1;
(statearr_14273_14291[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14266 === (3))){
var inst_14263 = (state_14265[(2)]);
var state_14265__$1 = state_14265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14265__$1,inst_14263);
} else {
if((state_val_14266 === (2))){
var state_14265__$1 = state_14265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14265__$1,(4),ch);
} else {
if((state_val_14266 === (11))){
var inst_14255 = (state_14265[(2)]);
var state_14265__$1 = state_14265;
var statearr_14274_14292 = state_14265__$1;
(statearr_14274_14292[(2)] = inst_14255);

(statearr_14274_14292[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14266 === (9))){
var state_14265__$1 = state_14265;
var statearr_14275_14293 = state_14265__$1;
(statearr_14275_14293[(2)] = null);

(statearr_14275_14293[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14266 === (5))){
var inst_14250 = cljs.core.async.close_BANG_(out);
var state_14265__$1 = state_14265;
var statearr_14276_14294 = state_14265__$1;
(statearr_14276_14294[(2)] = inst_14250);

(statearr_14276_14294[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14266 === (10))){
var inst_14258 = (state_14265[(2)]);
var state_14265__$1 = (function (){var statearr_14277 = state_14265;
(statearr_14277[(8)] = inst_14258);

return statearr_14277;
})();
var statearr_14278_14295 = state_14265__$1;
(statearr_14278_14295[(2)] = null);

(statearr_14278_14295[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14266 === (8))){
var inst_14247 = (state_14265[(7)]);
var state_14265__$1 = state_14265;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14265__$1,(11),out,inst_14247);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10750__auto__ = null;
var cljs$core$async$state_machine__10750__auto____0 = (function (){
var statearr_14279 = [null,null,null,null,null,null,null,null,null];
(statearr_14279[(0)] = cljs$core$async$state_machine__10750__auto__);

(statearr_14279[(1)] = (1));

return statearr_14279;
});
var cljs$core$async$state_machine__10750__auto____1 = (function (state_14265){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_14265);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e14280){var ex__10753__auto__ = e14280;
var statearr_14281_14296 = state_14265;
(statearr_14281_14296[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_14265[(4)]))){
var statearr_14282_14297 = state_14265;
(statearr_14282_14297[(1)] = cljs.core.first((state_14265[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__14298 = state_14265;
state_14265 = G__14298;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$state_machine__10750__auto__ = function(state_14265){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10750__auto____1.call(this,state_14265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10750__auto____0;
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10750__auto____1;
return cljs$core$async$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_14283 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_14283[(6)] = c__10876__auto___14285);

return statearr_14283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__14300 = arguments.length;
switch (G__14300) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_14363){
var state_val_14364 = (state_14363[(1)]);
if((state_val_14364 === (7))){
var inst_14359 = (state_14363[(2)]);
var state_14363__$1 = state_14363;
var statearr_14365_14404 = state_14363__$1;
(statearr_14365_14404[(2)] = inst_14359);

(statearr_14365_14404[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (20))){
var inst_14329 = (state_14363[(7)]);
var inst_14340 = (state_14363[(2)]);
var inst_14341 = cljs.core.next(inst_14329);
var inst_14315 = inst_14341;
var inst_14316 = null;
var inst_14317 = (0);
var inst_14318 = (0);
var state_14363__$1 = (function (){var statearr_14366 = state_14363;
(statearr_14366[(8)] = inst_14340);

(statearr_14366[(9)] = inst_14317);

(statearr_14366[(10)] = inst_14315);

(statearr_14366[(11)] = inst_14318);

(statearr_14366[(12)] = inst_14316);

return statearr_14366;
})();
var statearr_14367_14405 = state_14363__$1;
(statearr_14367_14405[(2)] = null);

(statearr_14367_14405[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (1))){
var state_14363__$1 = state_14363;
var statearr_14368_14406 = state_14363__$1;
(statearr_14368_14406[(2)] = null);

(statearr_14368_14406[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (4))){
var inst_14304 = (state_14363[(13)]);
var inst_14304__$1 = (state_14363[(2)]);
var inst_14305 = (inst_14304__$1 == null);
var state_14363__$1 = (function (){var statearr_14369 = state_14363;
(statearr_14369[(13)] = inst_14304__$1);

return statearr_14369;
})();
if(cljs.core.truth_(inst_14305)){
var statearr_14370_14407 = state_14363__$1;
(statearr_14370_14407[(1)] = (5));

} else {
var statearr_14371_14408 = state_14363__$1;
(statearr_14371_14408[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (15))){
var state_14363__$1 = state_14363;
var statearr_14375_14409 = state_14363__$1;
(statearr_14375_14409[(2)] = null);

(statearr_14375_14409[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (21))){
var state_14363__$1 = state_14363;
var statearr_14376_14410 = state_14363__$1;
(statearr_14376_14410[(2)] = null);

(statearr_14376_14410[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (13))){
var inst_14317 = (state_14363[(9)]);
var inst_14315 = (state_14363[(10)]);
var inst_14318 = (state_14363[(11)]);
var inst_14316 = (state_14363[(12)]);
var inst_14325 = (state_14363[(2)]);
var inst_14326 = (inst_14318 + (1));
var tmp14372 = inst_14317;
var tmp14373 = inst_14315;
var tmp14374 = inst_14316;
var inst_14315__$1 = tmp14373;
var inst_14316__$1 = tmp14374;
var inst_14317__$1 = tmp14372;
var inst_14318__$1 = inst_14326;
var state_14363__$1 = (function (){var statearr_14377 = state_14363;
(statearr_14377[(14)] = inst_14325);

(statearr_14377[(9)] = inst_14317__$1);

(statearr_14377[(10)] = inst_14315__$1);

(statearr_14377[(11)] = inst_14318__$1);

(statearr_14377[(12)] = inst_14316__$1);

return statearr_14377;
})();
var statearr_14378_14411 = state_14363__$1;
(statearr_14378_14411[(2)] = null);

(statearr_14378_14411[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (22))){
var state_14363__$1 = state_14363;
var statearr_14379_14412 = state_14363__$1;
(statearr_14379_14412[(2)] = null);

(statearr_14379_14412[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (6))){
var inst_14304 = (state_14363[(13)]);
var inst_14313 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_14304) : f.call(null,inst_14304));
var inst_14314 = cljs.core.seq(inst_14313);
var inst_14315 = inst_14314;
var inst_14316 = null;
var inst_14317 = (0);
var inst_14318 = (0);
var state_14363__$1 = (function (){var statearr_14380 = state_14363;
(statearr_14380[(9)] = inst_14317);

(statearr_14380[(10)] = inst_14315);

(statearr_14380[(11)] = inst_14318);

(statearr_14380[(12)] = inst_14316);

return statearr_14380;
})();
var statearr_14381_14413 = state_14363__$1;
(statearr_14381_14413[(2)] = null);

(statearr_14381_14413[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (17))){
var inst_14329 = (state_14363[(7)]);
var inst_14333 = cljs.core.chunk_first(inst_14329);
var inst_14334 = cljs.core.chunk_rest(inst_14329);
var inst_14335 = cljs.core.count(inst_14333);
var inst_14315 = inst_14334;
var inst_14316 = inst_14333;
var inst_14317 = inst_14335;
var inst_14318 = (0);
var state_14363__$1 = (function (){var statearr_14382 = state_14363;
(statearr_14382[(9)] = inst_14317);

(statearr_14382[(10)] = inst_14315);

(statearr_14382[(11)] = inst_14318);

(statearr_14382[(12)] = inst_14316);

return statearr_14382;
})();
var statearr_14383_14414 = state_14363__$1;
(statearr_14383_14414[(2)] = null);

(statearr_14383_14414[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (3))){
var inst_14361 = (state_14363[(2)]);
var state_14363__$1 = state_14363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14363__$1,inst_14361);
} else {
if((state_val_14364 === (12))){
var inst_14349 = (state_14363[(2)]);
var state_14363__$1 = state_14363;
var statearr_14384_14415 = state_14363__$1;
(statearr_14384_14415[(2)] = inst_14349);

(statearr_14384_14415[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (2))){
var state_14363__$1 = state_14363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14363__$1,(4),in$);
} else {
if((state_val_14364 === (23))){
var inst_14357 = (state_14363[(2)]);
var state_14363__$1 = state_14363;
var statearr_14385_14416 = state_14363__$1;
(statearr_14385_14416[(2)] = inst_14357);

(statearr_14385_14416[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (19))){
var inst_14344 = (state_14363[(2)]);
var state_14363__$1 = state_14363;
var statearr_14386_14417 = state_14363__$1;
(statearr_14386_14417[(2)] = inst_14344);

(statearr_14386_14417[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (11))){
var inst_14315 = (state_14363[(10)]);
var inst_14329 = (state_14363[(7)]);
var inst_14329__$1 = cljs.core.seq(inst_14315);
var state_14363__$1 = (function (){var statearr_14387 = state_14363;
(statearr_14387[(7)] = inst_14329__$1);

return statearr_14387;
})();
if(inst_14329__$1){
var statearr_14388_14418 = state_14363__$1;
(statearr_14388_14418[(1)] = (14));

} else {
var statearr_14389_14419 = state_14363__$1;
(statearr_14389_14419[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (9))){
var inst_14351 = (state_14363[(2)]);
var inst_14352 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_14363__$1 = (function (){var statearr_14390 = state_14363;
(statearr_14390[(15)] = inst_14351);

return statearr_14390;
})();
if(cljs.core.truth_(inst_14352)){
var statearr_14391_14420 = state_14363__$1;
(statearr_14391_14420[(1)] = (21));

} else {
var statearr_14392_14421 = state_14363__$1;
(statearr_14392_14421[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (5))){
var inst_14307 = cljs.core.async.close_BANG_(out);
var state_14363__$1 = state_14363;
var statearr_14393_14422 = state_14363__$1;
(statearr_14393_14422[(2)] = inst_14307);

(statearr_14393_14422[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (14))){
var inst_14329 = (state_14363[(7)]);
var inst_14331 = cljs.core.chunked_seq_QMARK_(inst_14329);
var state_14363__$1 = state_14363;
if(inst_14331){
var statearr_14394_14423 = state_14363__$1;
(statearr_14394_14423[(1)] = (17));

} else {
var statearr_14395_14424 = state_14363__$1;
(statearr_14395_14424[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (16))){
var inst_14347 = (state_14363[(2)]);
var state_14363__$1 = state_14363;
var statearr_14396_14425 = state_14363__$1;
(statearr_14396_14425[(2)] = inst_14347);

(statearr_14396_14425[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14364 === (10))){
var inst_14318 = (state_14363[(11)]);
var inst_14316 = (state_14363[(12)]);
var inst_14323 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_14316,inst_14318);
var state_14363__$1 = state_14363;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14363__$1,(13),out,inst_14323);
} else {
if((state_val_14364 === (18))){
var inst_14329 = (state_14363[(7)]);
var inst_14338 = cljs.core.first(inst_14329);
var state_14363__$1 = state_14363;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14363__$1,(20),out,inst_14338);
} else {
if((state_val_14364 === (8))){
var inst_14317 = (state_14363[(9)]);
var inst_14318 = (state_14363[(11)]);
var inst_14320 = (inst_14318 < inst_14317);
var inst_14321 = inst_14320;
var state_14363__$1 = state_14363;
if(cljs.core.truth_(inst_14321)){
var statearr_14397_14426 = state_14363__$1;
(statearr_14397_14426[(1)] = (10));

} else {
var statearr_14398_14427 = state_14363__$1;
(statearr_14398_14427[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10750__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10750__auto____0 = (function (){
var statearr_14399 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14399[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10750__auto__);

(statearr_14399[(1)] = (1));

return statearr_14399;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10750__auto____1 = (function (state_14363){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_14363);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e14400){var ex__10753__auto__ = e14400;
var statearr_14401_14428 = state_14363;
(statearr_14401_14428[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_14363[(4)]))){
var statearr_14402_14429 = state_14363;
(statearr_14402_14429[(1)] = cljs.core.first((state_14363[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__14430 = state_14363;
state_14363 = G__14430;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10750__auto__ = function(state_14363){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10750__auto____1.call(this,state_14363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10750__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10750__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_14403 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_14403[(6)] = c__10876__auto__);

return statearr_14403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__14432 = arguments.length;
switch (G__14432) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__14435 = arguments.length;
switch (G__14435) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__14438 = arguments.length;
switch (G__14438) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__10876__auto___14486 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_14462){
var state_val_14463 = (state_14462[(1)]);
if((state_val_14463 === (7))){
var inst_14457 = (state_14462[(2)]);
var state_14462__$1 = state_14462;
var statearr_14464_14487 = state_14462__$1;
(statearr_14464_14487[(2)] = inst_14457);

(statearr_14464_14487[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14463 === (1))){
var inst_14439 = null;
var state_14462__$1 = (function (){var statearr_14465 = state_14462;
(statearr_14465[(7)] = inst_14439);

return statearr_14465;
})();
var statearr_14466_14488 = state_14462__$1;
(statearr_14466_14488[(2)] = null);

(statearr_14466_14488[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14463 === (4))){
var inst_14442 = (state_14462[(8)]);
var inst_14442__$1 = (state_14462[(2)]);
var inst_14443 = (inst_14442__$1 == null);
var inst_14444 = cljs.core.not(inst_14443);
var state_14462__$1 = (function (){var statearr_14467 = state_14462;
(statearr_14467[(8)] = inst_14442__$1);

return statearr_14467;
})();
if(inst_14444){
var statearr_14468_14489 = state_14462__$1;
(statearr_14468_14489[(1)] = (5));

} else {
var statearr_14469_14490 = state_14462__$1;
(statearr_14469_14490[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14463 === (6))){
var state_14462__$1 = state_14462;
var statearr_14470_14491 = state_14462__$1;
(statearr_14470_14491[(2)] = null);

(statearr_14470_14491[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14463 === (3))){
var inst_14459 = (state_14462[(2)]);
var inst_14460 = cljs.core.async.close_BANG_(out);
var state_14462__$1 = (function (){var statearr_14471 = state_14462;
(statearr_14471[(9)] = inst_14459);

return statearr_14471;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14462__$1,inst_14460);
} else {
if((state_val_14463 === (2))){
var state_14462__$1 = state_14462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14462__$1,(4),ch);
} else {
if((state_val_14463 === (11))){
var inst_14442 = (state_14462[(8)]);
var inst_14451 = (state_14462[(2)]);
var inst_14439 = inst_14442;
var state_14462__$1 = (function (){var statearr_14472 = state_14462;
(statearr_14472[(7)] = inst_14439);

(statearr_14472[(10)] = inst_14451);

return statearr_14472;
})();
var statearr_14473_14492 = state_14462__$1;
(statearr_14473_14492[(2)] = null);

(statearr_14473_14492[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14463 === (9))){
var inst_14442 = (state_14462[(8)]);
var state_14462__$1 = state_14462;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14462__$1,(11),out,inst_14442);
} else {
if((state_val_14463 === (5))){
var inst_14439 = (state_14462[(7)]);
var inst_14442 = (state_14462[(8)]);
var inst_14446 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14442,inst_14439);
var state_14462__$1 = state_14462;
if(inst_14446){
var statearr_14475_14493 = state_14462__$1;
(statearr_14475_14493[(1)] = (8));

} else {
var statearr_14476_14494 = state_14462__$1;
(statearr_14476_14494[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14463 === (10))){
var inst_14454 = (state_14462[(2)]);
var state_14462__$1 = state_14462;
var statearr_14477_14495 = state_14462__$1;
(statearr_14477_14495[(2)] = inst_14454);

(statearr_14477_14495[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14463 === (8))){
var inst_14439 = (state_14462[(7)]);
var tmp14474 = inst_14439;
var inst_14439__$1 = tmp14474;
var state_14462__$1 = (function (){var statearr_14478 = state_14462;
(statearr_14478[(7)] = inst_14439__$1);

return statearr_14478;
})();
var statearr_14479_14496 = state_14462__$1;
(statearr_14479_14496[(2)] = null);

(statearr_14479_14496[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10750__auto__ = null;
var cljs$core$async$state_machine__10750__auto____0 = (function (){
var statearr_14480 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14480[(0)] = cljs$core$async$state_machine__10750__auto__);

(statearr_14480[(1)] = (1));

return statearr_14480;
});
var cljs$core$async$state_machine__10750__auto____1 = (function (state_14462){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_14462);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e14481){var ex__10753__auto__ = e14481;
var statearr_14482_14497 = state_14462;
(statearr_14482_14497[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_14462[(4)]))){
var statearr_14483_14498 = state_14462;
(statearr_14483_14498[(1)] = cljs.core.first((state_14462[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__14499 = state_14462;
state_14462 = G__14499;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$state_machine__10750__auto__ = function(state_14462){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10750__auto____1.call(this,state_14462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10750__auto____0;
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10750__auto____1;
return cljs$core$async$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_14484 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_14484[(6)] = c__10876__auto___14486);

return statearr_14484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__14501 = arguments.length;
switch (G__14501) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__10876__auto___14568 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_14539){
var state_val_14540 = (state_14539[(1)]);
if((state_val_14540 === (7))){
var inst_14535 = (state_14539[(2)]);
var state_14539__$1 = state_14539;
var statearr_14541_14569 = state_14539__$1;
(statearr_14541_14569[(2)] = inst_14535);

(statearr_14541_14569[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14540 === (1))){
var inst_14502 = (new Array(n));
var inst_14503 = inst_14502;
var inst_14504 = (0);
var state_14539__$1 = (function (){var statearr_14542 = state_14539;
(statearr_14542[(7)] = inst_14503);

(statearr_14542[(8)] = inst_14504);

return statearr_14542;
})();
var statearr_14543_14570 = state_14539__$1;
(statearr_14543_14570[(2)] = null);

(statearr_14543_14570[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14540 === (4))){
var inst_14507 = (state_14539[(9)]);
var inst_14507__$1 = (state_14539[(2)]);
var inst_14508 = (inst_14507__$1 == null);
var inst_14509 = cljs.core.not(inst_14508);
var state_14539__$1 = (function (){var statearr_14544 = state_14539;
(statearr_14544[(9)] = inst_14507__$1);

return statearr_14544;
})();
if(inst_14509){
var statearr_14545_14571 = state_14539__$1;
(statearr_14545_14571[(1)] = (5));

} else {
var statearr_14546_14572 = state_14539__$1;
(statearr_14546_14572[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14540 === (15))){
var inst_14529 = (state_14539[(2)]);
var state_14539__$1 = state_14539;
var statearr_14547_14573 = state_14539__$1;
(statearr_14547_14573[(2)] = inst_14529);

(statearr_14547_14573[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14540 === (13))){
var state_14539__$1 = state_14539;
var statearr_14548_14574 = state_14539__$1;
(statearr_14548_14574[(2)] = null);

(statearr_14548_14574[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14540 === (6))){
var inst_14504 = (state_14539[(8)]);
var inst_14525 = (inst_14504 > (0));
var state_14539__$1 = state_14539;
if(cljs.core.truth_(inst_14525)){
var statearr_14549_14575 = state_14539__$1;
(statearr_14549_14575[(1)] = (12));

} else {
var statearr_14550_14576 = state_14539__$1;
(statearr_14550_14576[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14540 === (3))){
var inst_14537 = (state_14539[(2)]);
var state_14539__$1 = state_14539;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14539__$1,inst_14537);
} else {
if((state_val_14540 === (12))){
var inst_14503 = (state_14539[(7)]);
var inst_14527 = cljs.core.vec(inst_14503);
var state_14539__$1 = state_14539;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14539__$1,(15),out,inst_14527);
} else {
if((state_val_14540 === (2))){
var state_14539__$1 = state_14539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14539__$1,(4),ch);
} else {
if((state_val_14540 === (11))){
var inst_14519 = (state_14539[(2)]);
var inst_14520 = (new Array(n));
var inst_14503 = inst_14520;
var inst_14504 = (0);
var state_14539__$1 = (function (){var statearr_14551 = state_14539;
(statearr_14551[(7)] = inst_14503);

(statearr_14551[(10)] = inst_14519);

(statearr_14551[(8)] = inst_14504);

return statearr_14551;
})();
var statearr_14552_14577 = state_14539__$1;
(statearr_14552_14577[(2)] = null);

(statearr_14552_14577[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14540 === (9))){
var inst_14503 = (state_14539[(7)]);
var inst_14517 = cljs.core.vec(inst_14503);
var state_14539__$1 = state_14539;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14539__$1,(11),out,inst_14517);
} else {
if((state_val_14540 === (5))){
var inst_14503 = (state_14539[(7)]);
var inst_14507 = (state_14539[(9)]);
var inst_14512 = (state_14539[(11)]);
var inst_14504 = (state_14539[(8)]);
var inst_14511 = (inst_14503[inst_14504] = inst_14507);
var inst_14512__$1 = (inst_14504 + (1));
var inst_14513 = (inst_14512__$1 < n);
var state_14539__$1 = (function (){var statearr_14553 = state_14539;
(statearr_14553[(11)] = inst_14512__$1);

(statearr_14553[(12)] = inst_14511);

return statearr_14553;
})();
if(cljs.core.truth_(inst_14513)){
var statearr_14554_14578 = state_14539__$1;
(statearr_14554_14578[(1)] = (8));

} else {
var statearr_14555_14579 = state_14539__$1;
(statearr_14555_14579[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14540 === (14))){
var inst_14532 = (state_14539[(2)]);
var inst_14533 = cljs.core.async.close_BANG_(out);
var state_14539__$1 = (function (){var statearr_14557 = state_14539;
(statearr_14557[(13)] = inst_14532);

return statearr_14557;
})();
var statearr_14558_14580 = state_14539__$1;
(statearr_14558_14580[(2)] = inst_14533);

(statearr_14558_14580[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14540 === (10))){
var inst_14523 = (state_14539[(2)]);
var state_14539__$1 = state_14539;
var statearr_14559_14581 = state_14539__$1;
(statearr_14559_14581[(2)] = inst_14523);

(statearr_14559_14581[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14540 === (8))){
var inst_14503 = (state_14539[(7)]);
var inst_14512 = (state_14539[(11)]);
var tmp14556 = inst_14503;
var inst_14503__$1 = tmp14556;
var inst_14504 = inst_14512;
var state_14539__$1 = (function (){var statearr_14560 = state_14539;
(statearr_14560[(7)] = inst_14503__$1);

(statearr_14560[(8)] = inst_14504);

return statearr_14560;
})();
var statearr_14561_14582 = state_14539__$1;
(statearr_14561_14582[(2)] = null);

(statearr_14561_14582[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10750__auto__ = null;
var cljs$core$async$state_machine__10750__auto____0 = (function (){
var statearr_14562 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14562[(0)] = cljs$core$async$state_machine__10750__auto__);

(statearr_14562[(1)] = (1));

return statearr_14562;
});
var cljs$core$async$state_machine__10750__auto____1 = (function (state_14539){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_14539);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e14563){var ex__10753__auto__ = e14563;
var statearr_14564_14583 = state_14539;
(statearr_14564_14583[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_14539[(4)]))){
var statearr_14565_14584 = state_14539;
(statearr_14565_14584[(1)] = cljs.core.first((state_14539[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__14585 = state_14539;
state_14539 = G__14585;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$state_machine__10750__auto__ = function(state_14539){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10750__auto____1.call(this,state_14539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10750__auto____0;
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10750__auto____1;
return cljs$core$async$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_14566 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_14566[(6)] = c__10876__auto___14568);

return statearr_14566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__14587 = arguments.length;
switch (G__14587) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__10876__auto___14665 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_14632){
var state_val_14633 = (state_14632[(1)]);
if((state_val_14633 === (7))){
var inst_14628 = (state_14632[(2)]);
var state_14632__$1 = state_14632;
var statearr_14634_14666 = state_14632__$1;
(statearr_14634_14666[(2)] = inst_14628);

(statearr_14634_14666[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (1))){
var inst_14588 = [];
var inst_14589 = inst_14588;
var inst_14590 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_14632__$1 = (function (){var statearr_14635 = state_14632;
(statearr_14635[(7)] = inst_14589);

(statearr_14635[(8)] = inst_14590);

return statearr_14635;
})();
var statearr_14636_14667 = state_14632__$1;
(statearr_14636_14667[(2)] = null);

(statearr_14636_14667[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (4))){
var inst_14593 = (state_14632[(9)]);
var inst_14593__$1 = (state_14632[(2)]);
var inst_14594 = (inst_14593__$1 == null);
var inst_14595 = cljs.core.not(inst_14594);
var state_14632__$1 = (function (){var statearr_14637 = state_14632;
(statearr_14637[(9)] = inst_14593__$1);

return statearr_14637;
})();
if(inst_14595){
var statearr_14638_14668 = state_14632__$1;
(statearr_14638_14668[(1)] = (5));

} else {
var statearr_14639_14669 = state_14632__$1;
(statearr_14639_14669[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (15))){
var inst_14589 = (state_14632[(7)]);
var inst_14620 = cljs.core.vec(inst_14589);
var state_14632__$1 = state_14632;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14632__$1,(18),out,inst_14620);
} else {
if((state_val_14633 === (13))){
var inst_14615 = (state_14632[(2)]);
var state_14632__$1 = state_14632;
var statearr_14640_14670 = state_14632__$1;
(statearr_14640_14670[(2)] = inst_14615);

(statearr_14640_14670[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (6))){
var inst_14589 = (state_14632[(7)]);
var inst_14617 = inst_14589.length;
var inst_14618 = (inst_14617 > (0));
var state_14632__$1 = state_14632;
if(cljs.core.truth_(inst_14618)){
var statearr_14641_14671 = state_14632__$1;
(statearr_14641_14671[(1)] = (15));

} else {
var statearr_14642_14672 = state_14632__$1;
(statearr_14642_14672[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (17))){
var inst_14625 = (state_14632[(2)]);
var inst_14626 = cljs.core.async.close_BANG_(out);
var state_14632__$1 = (function (){var statearr_14643 = state_14632;
(statearr_14643[(10)] = inst_14625);

return statearr_14643;
})();
var statearr_14644_14673 = state_14632__$1;
(statearr_14644_14673[(2)] = inst_14626);

(statearr_14644_14673[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (3))){
var inst_14630 = (state_14632[(2)]);
var state_14632__$1 = state_14632;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14632__$1,inst_14630);
} else {
if((state_val_14633 === (12))){
var inst_14589 = (state_14632[(7)]);
var inst_14608 = cljs.core.vec(inst_14589);
var state_14632__$1 = state_14632;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14632__$1,(14),out,inst_14608);
} else {
if((state_val_14633 === (2))){
var state_14632__$1 = state_14632;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14632__$1,(4),ch);
} else {
if((state_val_14633 === (11))){
var inst_14589 = (state_14632[(7)]);
var inst_14597 = (state_14632[(11)]);
var inst_14593 = (state_14632[(9)]);
var inst_14605 = inst_14589.push(inst_14593);
var tmp14645 = inst_14589;
var inst_14589__$1 = tmp14645;
var inst_14590 = inst_14597;
var state_14632__$1 = (function (){var statearr_14646 = state_14632;
(statearr_14646[(7)] = inst_14589__$1);

(statearr_14646[(8)] = inst_14590);

(statearr_14646[(12)] = inst_14605);

return statearr_14646;
})();
var statearr_14647_14674 = state_14632__$1;
(statearr_14647_14674[(2)] = null);

(statearr_14647_14674[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (9))){
var inst_14590 = (state_14632[(8)]);
var inst_14601 = cljs.core.keyword_identical_QMARK_(inst_14590,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var state_14632__$1 = state_14632;
var statearr_14648_14675 = state_14632__$1;
(statearr_14648_14675[(2)] = inst_14601);

(statearr_14648_14675[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (5))){
var inst_14597 = (state_14632[(11)]);
var inst_14590 = (state_14632[(8)]);
var inst_14593 = (state_14632[(9)]);
var inst_14598 = (state_14632[(13)]);
var inst_14597__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_14593) : f.call(null,inst_14593));
var inst_14598__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14597__$1,inst_14590);
var state_14632__$1 = (function (){var statearr_14649 = state_14632;
(statearr_14649[(11)] = inst_14597__$1);

(statearr_14649[(13)] = inst_14598__$1);

return statearr_14649;
})();
if(inst_14598__$1){
var statearr_14650_14676 = state_14632__$1;
(statearr_14650_14676[(1)] = (8));

} else {
var statearr_14651_14677 = state_14632__$1;
(statearr_14651_14677[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (14))){
var inst_14597 = (state_14632[(11)]);
var inst_14593 = (state_14632[(9)]);
var inst_14610 = (state_14632[(2)]);
var inst_14611 = [];
var inst_14612 = inst_14611.push(inst_14593);
var inst_14589 = inst_14611;
var inst_14590 = inst_14597;
var state_14632__$1 = (function (){var statearr_14652 = state_14632;
(statearr_14652[(7)] = inst_14589);

(statearr_14652[(14)] = inst_14610);

(statearr_14652[(8)] = inst_14590);

(statearr_14652[(15)] = inst_14612);

return statearr_14652;
})();
var statearr_14653_14678 = state_14632__$1;
(statearr_14653_14678[(2)] = null);

(statearr_14653_14678[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (16))){
var state_14632__$1 = state_14632;
var statearr_14654_14679 = state_14632__$1;
(statearr_14654_14679[(2)] = null);

(statearr_14654_14679[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (10))){
var inst_14603 = (state_14632[(2)]);
var state_14632__$1 = state_14632;
if(cljs.core.truth_(inst_14603)){
var statearr_14655_14680 = state_14632__$1;
(statearr_14655_14680[(1)] = (11));

} else {
var statearr_14656_14681 = state_14632__$1;
(statearr_14656_14681[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (18))){
var inst_14622 = (state_14632[(2)]);
var state_14632__$1 = state_14632;
var statearr_14657_14682 = state_14632__$1;
(statearr_14657_14682[(2)] = inst_14622);

(statearr_14657_14682[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14633 === (8))){
var inst_14598 = (state_14632[(13)]);
var state_14632__$1 = state_14632;
var statearr_14658_14683 = state_14632__$1;
(statearr_14658_14683[(2)] = inst_14598);

(statearr_14658_14683[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10750__auto__ = null;
var cljs$core$async$state_machine__10750__auto____0 = (function (){
var statearr_14659 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14659[(0)] = cljs$core$async$state_machine__10750__auto__);

(statearr_14659[(1)] = (1));

return statearr_14659;
});
var cljs$core$async$state_machine__10750__auto____1 = (function (state_14632){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_14632);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e14660){var ex__10753__auto__ = e14660;
var statearr_14661_14684 = state_14632;
(statearr_14661_14684[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_14632[(4)]))){
var statearr_14662_14685 = state_14632;
(statearr_14662_14685[(1)] = cljs.core.first((state_14632[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__14686 = state_14632;
state_14632 = G__14686;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
cljs$core$async$state_machine__10750__auto__ = function(state_14632){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10750__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10750__auto____1.call(this,state_14632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10750__auto____0;
cljs$core$async$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10750__auto____1;
return cljs$core$async$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_14663 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_14663[(6)] = c__10876__auto___14665);

return statearr_14663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

