// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5753__auto__)){
var st = temp__5753__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__45570 = cljs.core._EQ_;
var expr__45571 = e.getLastErrorCode();
if(cljs.core.truth_((pred__45570.cljs$core$IFn$_invoke$arity$2 ? pred__45570.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__45571) : pred__45570.call(null,goog.net.ErrorCode.NO_ERROR,expr__45571)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__45570.cljs$core$IFn$_invoke$arity$2 ? pred__45570.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__45571) : pred__45570.call(null,goog.net.ErrorCode.EXCEPTION,expr__45571)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__45570.cljs$core$IFn$_invoke$arity$2 ? pred__45570.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__45571) : pred__45570.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__45571)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__45570.cljs$core$IFn$_invoke$arity$2 ? pred__45570.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__45571) : pred__45570.call(null,goog.net.ErrorCode.ABORT,expr__45571)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__45570.cljs$core$IFn$_invoke$arity$2 ? pred__45570.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__45571) : pred__45570.call(null,goog.net.ErrorCode.TIMEOUT,expr__45571)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return (status > (0));
} else {
return and__4210__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__45573 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45573,cljs.core.cst$kw$status,status);
} else {
return G__45573;
}
})());
});
fluree.db.util.xhttp.throw_if_timeout = (function fluree$db$util$xhttp$throw_if_timeout(response){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.util.xhttp.TimeoutException,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$error_SLASH_via.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(response)))))){
throw (new fluree.db.util.xhttp.TimeoutException(cljs.core.cst$kw$error_SLASH_cause.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(response))));
} else {
return response;
}
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__45574 = opts;
var map__45574__$1 = cljs.core.__destructure_map(map__45574);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__45574__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45574__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45574__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__45575 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__45575__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__45575,headers], 0)):G__45575);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45575__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__45575__$1;
}
})();
try{var G__45577_45583 = url;
var G__45578_45584 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__45579_45585 = "POST";
var G__45580_45586 = fluree.db.util.json.stringify(message);
var G__45581_45587 = cljs.core.clj__GT_js(headers__$1);
var G__45582_45588 = request_timeout;
goog.net.XhrIo.send(G__45577_45583,G__45578_45584,G__45579_45585,G__45580_45586,G__45581_45587,G__45582_45588);
}catch (e45576){var e_45589 = e45576;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_45589);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__45590 = opts;
var map__45590__$1 = cljs.core.__destructure_map(map__45590);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__45590__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45590__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45590__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45590__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__45590__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__45591 = cljs.core.PersistentArrayMap.EMPTY;
var G__45591__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__45591,headers], 0)):G__45591);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45591__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__45591__$1;
}
})();
try{var G__45593_45600 = url;
var G__45594_45601 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__45599 = output_format;
var G__45599__$1 = (((G__45599 instanceof cljs.core.Keyword))?G__45599.fqn:null);
switch (G__45599__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__45595_45602 = "GET";
var G__45596_45603 = body;
var G__45597_45604 = cljs.core.clj__GT_js(headers__$1);
var G__45598_45605 = request_timeout;
goog.net.XhrIo.send(G__45593_45600,G__45594_45601,G__45595_45602,G__45596_45603,G__45597_45604,G__45598_45605);
}catch (e45592){var e_45607 = e45592;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_45607);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__45608 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45608,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__45608;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_45640){
var state_val_45641 = (state_45640[(1)]);
if((state_val_45641 === (7))){
var inst_45636 = (state_45640[(2)]);
var state_45640__$1 = state_45640;
var statearr_45642_45667 = state_45640__$1;
(statearr_45642_45667[(2)] = inst_45636);

(statearr_45642_45667[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (1))){
var state_45640__$1 = state_45640;
var statearr_45643_45668 = state_45640__$1;
(statearr_45643_45668[(2)] = null);

(statearr_45643_45668[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (4))){
var inst_45611 = (state_45640[(7)]);
var inst_45611__$1 = (state_45640[(2)]);
var inst_45612 = (inst_45611__$1 == null);
var state_45640__$1 = (function (){var statearr_45644 = state_45640;
(statearr_45644[(7)] = inst_45611__$1);

return statearr_45644;
})();
if(cljs.core.truth_(inst_45612)){
var statearr_45645_45669 = state_45640__$1;
(statearr_45645_45669[(1)] = (5));

} else {
var statearr_45646_45670 = state_45640__$1;
(statearr_45646_45670[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (6))){
var inst_45611 = (state_45640[(7)]);
var inst_45619 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45611,(0),null);
var inst_45620 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45611,(1),null);
var state_45640__$1 = (function (){var statearr_45647 = state_45640;
(statearr_45647[(8)] = inst_45620);

(statearr_45647[(9)] = inst_45619);

return statearr_45647;
})();
var statearr_45648_45671 = state_45640__$1;
(statearr_45648_45671[(2)] = null);

(statearr_45648_45671[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (3))){
var inst_45638 = (state_45640[(2)]);
var state_45640__$1 = state_45640;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45640__$1,inst_45638);
} else {
if((state_val_45641 === (2))){
var state_45640__$1 = state_45640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45640__$1,(4),pub_chan);
} else {
if((state_val_45641 === (11))){
var _ = (function (){var statearr_45650 = state_45640;
(statearr_45650[(4)] = cljs.core.rest((state_45640[(4)])));

return statearr_45650;
})();
var state_45640__$1 = state_45640;
var ex45649 = (state_45640__$1[(2)]);
var statearr_45651_45672 = state_45640__$1;
(statearr_45651_45672[(5)] = ex45649);


var statearr_45652_45673 = state_45640__$1;
(statearr_45652_45673[(1)] = (10));

(statearr_45652_45673[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (9))){
var inst_45633 = (state_45640[(2)]);
var state_45640__$1 = (function (){var statearr_45653 = state_45640;
(statearr_45653[(10)] = inst_45633);

return statearr_45653;
})();
var statearr_45654_45674 = state_45640__$1;
(statearr_45654_45674[(2)] = null);

(statearr_45654_45674[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (5))){
var inst_45614 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_45640__$1 = state_45640;
var statearr_45655_45675 = state_45640__$1;
(statearr_45655_45675[(2)] = inst_45614);

(statearr_45655_45675[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (10))){
var inst_45620 = (state_45640[(8)]);
var inst_45619 = (state_45640[(9)]);
var inst_45621 = (state_45640[(2)]);
var inst_45622 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_45621,"Error sending websocket message:",inst_45619], 0));
var inst_45623 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_45620,false);
var state_45640__$1 = (function (){var statearr_45656 = state_45640;
(statearr_45656[(11)] = inst_45622);

return statearr_45656;
})();
var statearr_45657_45676 = state_45640__$1;
(statearr_45657_45676[(2)] = inst_45623);

(statearr_45657_45676[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45641 === (8))){
var inst_45620 = (state_45640[(8)]);
var inst_45619 = (state_45640[(9)]);
var _ = (function (){var statearr_45658 = state_45640;
(statearr_45658[(4)] = cljs.core.cons((11),(state_45640[(4)])));

return statearr_45658;
})();
var inst_45629 = ws.send(inst_45619);
var inst_45630 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_45620,true);
var ___$1 = (function (){var statearr_45659 = state_45640;
(statearr_45659[(4)] = cljs.core.rest((state_45640[(4)])));

return statearr_45659;
})();
var state_45640__$1 = (function (){var statearr_45660 = state_45640;
(statearr_45660[(12)] = inst_45629);

return statearr_45660;
})();
var statearr_45661_45677 = state_45640__$1;
(statearr_45661_45677[(2)] = inst_45630);

(statearr_45661_45677[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__24298__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__24298__auto____0 = (function (){
var statearr_45662 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45662[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__24298__auto__);

(statearr_45662[(1)] = (1));

return statearr_45662;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__24298__auto____1 = (function (state_45640){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_45640);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e45663){var ex__24301__auto__ = e45663;
var statearr_45664_45678 = state_45640;
(statearr_45664_45678[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_45640[(4)]))){
var statearr_45665_45679 = state_45640;
(statearr_45665_45679[(1)] = cljs.core.first((state_45640[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__45680 = state_45640;
state_45640 = G__45680;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__24298__auto__ = function(state_45640){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__24298__auto____1.call(this,state_45640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__24298__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__24298__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_45666 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_45666[(6)] = c__24424__auto__);

return statearr_45666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__24424__auto___45718 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_45705){
var state_val_45706 = (state_45705[(1)]);
if((state_val_45706 === (1))){
var inst_45684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45685 = [open_QMARK_,timeout_chan];
var inst_45686 = (new cljs.core.PersistentVector(null,2,(5),inst_45684,inst_45685,null));
var state_45705__$1 = state_45705;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_45705__$1,(2),inst_45686,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_45706 === (2))){
var inst_45688 = (state_45705[(2)]);
var inst_45689 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45688,(0),null);
var inst_45690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45688,(1),null);
var inst_45691 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45690,timeout_chan);
var state_45705__$1 = (function (){var statearr_45707 = state_45705;
(statearr_45707[(7)] = inst_45689);

return statearr_45707;
})();
if(inst_45691){
var statearr_45708_45719 = state_45705__$1;
(statearr_45708_45719[(1)] = (3));

} else {
var statearr_45709_45720 = state_45705__$1;
(statearr_45709_45720[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_45706 === (3))){
var inst_45693 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_45694 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_45695 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_45696 = cljs.core.PersistentHashMap.fromArrays(inst_45694,inst_45695);
var inst_45697 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_45693,inst_45696);
var inst_45698 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_45697);
var inst_45699 = fluree.db.util.xhttp.close_websocket(ws);
var state_45705__$1 = (function (){var statearr_45710 = state_45705;
(statearr_45710[(8)] = inst_45698);

return statearr_45710;
})();
var statearr_45711_45721 = state_45705__$1;
(statearr_45711_45721[(2)] = inst_45699);

(statearr_45711_45721[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45706 === (4))){
var inst_45701 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_45705__$1 = state_45705;
var statearr_45712_45722 = state_45705__$1;
(statearr_45712_45722[(2)] = inst_45701);

(statearr_45712_45722[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_45706 === (5))){
var inst_45703 = (state_45705[(2)]);
var state_45705__$1 = state_45705;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45705__$1,inst_45703);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__24298__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__24298__auto____0 = (function (){
var statearr_45713 = [null,null,null,null,null,null,null,null,null];
(statearr_45713[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__24298__auto__);

(statearr_45713[(1)] = (1));

return statearr_45713;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__24298__auto____1 = (function (state_45705){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_45705);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e45714){var ex__24301__auto__ = e45714;
var statearr_45715_45723 = state_45705;
(statearr_45715_45723[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_45705[(4)]))){
var statearr_45716_45724 = state_45705;
(statearr_45716_45724[(1)] = cljs.core.first((state_45705[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__45725 = state_45705;
state_45705 = G__45725;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__24298__auto__ = function(state_45705){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__24298__auto____1.call(this,state_45705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__24298__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__24298__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_45717 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_45717[(6)] = c__24424__auto___45718);

return statearr_45717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
