// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4212__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_36758){
var state_val_36759 = (state_36758[(1)]);
if((state_val_36759 === (7))){
var inst_36753 = (state_36758[(2)]);
var _ = (function (){var statearr_36760 = state_36758;
(statearr_36760[(4)] = cljs.core.rest((state_36758[(4)])));

return statearr_36760;
})();
var state_36758__$1 = state_36758;
var statearr_36761_36783 = state_36758__$1;
(statearr_36761_36783[(2)] = inst_36753);

(statearr_36761_36783[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36759 === (1))){
var state_36758__$1 = state_36758;
var statearr_36762_36784 = state_36758__$1;
(statearr_36762_36784[(2)] = null);

(statearr_36762_36784[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36759 === (4))){
var inst_36715 = (state_36758[(2)]);
var state_36758__$1 = state_36758;
var statearr_36763_36785 = state_36758__$1;
(statearr_36763_36785[(2)] = inst_36715);

(statearr_36763_36785[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36759 === (6))){
var inst_36740 = (state_36758[(7)]);
var inst_36733 = (state_36758[(8)]);
var inst_36739 = cljs.core.seq(inst_36733);
var inst_36740__$1 = cljs.core.first(inst_36739);
var inst_36741 = cljs.core.next(inst_36739);
var inst_36742 = cljs.core.not(inst_36740__$1);
var state_36758__$1 = (function (){var statearr_36764 = state_36758;
(statearr_36764[(7)] = inst_36740__$1);

(statearr_36764[(9)] = inst_36741);

return statearr_36764;
})();
if(inst_36742){
var statearr_36765_36786 = state_36758__$1;
(statearr_36765_36786[(1)] = (8));

} else {
var statearr_36766_36787 = state_36758__$1;
(statearr_36766_36787[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36759 === (3))){
var inst_36756 = (state_36758[(2)]);
var state_36758__$1 = state_36758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36758__$1,inst_36756);
} else {
if((state_val_36759 === (2))){
var _ = (function (){var statearr_36767 = state_36758;
(statearr_36767[(4)] = cljs.core.cons((5),(state_36758[(4)])));

return statearr_36767;
})();
var inst_36728 = chs;
var inst_36729 = cljs.core.seq(inst_36728);
var inst_36730 = cljs.core.first(inst_36729);
var inst_36731 = cljs.core.next(inst_36729);
var inst_36732 = coll;
var inst_36733 = inst_36728;
var inst_36734 = inst_36732;
var state_36758__$1 = (function (){var statearr_36768 = state_36758;
(statearr_36768[(10)] = inst_36730);

(statearr_36768[(11)] = inst_36731);

(statearr_36768[(12)] = inst_36734);

(statearr_36768[(8)] = inst_36733);

return statearr_36768;
})();
var statearr_36769_36788 = state_36758__$1;
(statearr_36769_36788[(2)] = null);

(statearr_36769_36788[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36759 === (11))){
var inst_36741 = (state_36758[(9)]);
var inst_36734 = (state_36758[(12)]);
var inst_36746 = (state_36758[(2)]);
var inst_36747 = fluree.db.util.async.throw_err(inst_36746);
var inst_36748 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36734,inst_36747);
var inst_36733 = inst_36741;
var inst_36734__$1 = inst_36748;
var state_36758__$1 = (function (){var statearr_36771 = state_36758;
(statearr_36771[(12)] = inst_36734__$1);

(statearr_36771[(8)] = inst_36733);

return statearr_36771;
})();
var statearr_36772_36789 = state_36758__$1;
(statearr_36772_36789[(2)] = null);

(statearr_36772_36789[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36759 === (9))){
var inst_36740 = (state_36758[(7)]);
var state_36758__$1 = state_36758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36758__$1,(11),inst_36740);
} else {
if((state_val_36759 === (5))){
var _ = (function (){var statearr_36773 = state_36758;
(statearr_36773[(4)] = cljs.core.rest((state_36758[(4)])));

return statearr_36773;
})();
var state_36758__$1 = state_36758;
var ex36770 = (state_36758__$1[(2)]);
var statearr_36774_36790 = state_36758__$1;
(statearr_36774_36790[(5)] = ex36770);


var statearr_36775_36791 = state_36758__$1;
(statearr_36775_36791[(1)] = (4));

(statearr_36775_36791[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_36759 === (10))){
var inst_36751 = (state_36758[(2)]);
var state_36758__$1 = state_36758;
var statearr_36776_36792 = state_36758__$1;
(statearr_36776_36792[(2)] = inst_36751);

(statearr_36776_36792[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36759 === (8))){
var inst_36734 = (state_36758[(12)]);
var state_36758__$1 = state_36758;
var statearr_36777_36793 = state_36758__$1;
(statearr_36777_36793[(2)] = inst_36734);

(statearr_36777_36793[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__24298__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__24298__auto____0 = (function (){
var statearr_36778 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36778[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__24298__auto__);

(statearr_36778[(1)] = (1));

return statearr_36778;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__24298__auto____1 = (function (state_36758){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_36758);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e36779){var ex__24301__auto__ = e36779;
var statearr_36780_36794 = state_36758;
(statearr_36780_36794[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_36758[(4)]))){
var statearr_36781_36795 = state_36758;
(statearr_36781_36795[(1)] = cljs.core.first((state_36758[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__36796 = state_36758;
state_36758 = G__36796;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__24298__auto__ = function(state_36758){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__24298__auto____1.call(this,state_36758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__24298__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__24298__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_36782 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_36782[(6)] = c__24424__auto__);

return statearr_36782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_36822){
var state_val_36823 = (state_36822[(1)]);
if((state_val_36823 === (7))){
var inst_36817 = (state_36822[(2)]);
var _ = (function (){var statearr_36824 = state_36822;
(statearr_36824[(4)] = cljs.core.rest((state_36822[(4)])));

return statearr_36824;
})();
var state_36822__$1 = state_36822;
var statearr_36825_36847 = state_36822__$1;
(statearr_36825_36847[(2)] = inst_36817);

(statearr_36825_36847[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36823 === (1))){
var state_36822__$1 = state_36822;
var statearr_36826_36848 = state_36822__$1;
(statearr_36826_36848[(2)] = null);

(statearr_36826_36848[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36823 === (4))){
var inst_36797 = (state_36822[(2)]);
var state_36822__$1 = state_36822;
var statearr_36827_36849 = state_36822__$1;
(statearr_36827_36849[(2)] = inst_36797);

(statearr_36827_36849[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36823 === (6))){
var state_36822__$1 = state_36822;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36822__$1,(8),chan);
} else {
if((state_val_36823 === (3))){
var inst_36820 = (state_36822[(2)]);
var state_36822__$1 = state_36822;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36822__$1,inst_36820);
} else {
if((state_val_36823 === (2))){
var _ = (function (){var statearr_36828 = state_36822;
(statearr_36828[(4)] = cljs.core.cons((5),(state_36822[(4)])));

return statearr_36828;
})();
var inst_36803 = coll;
var inst_36804 = inst_36803;
var state_36822__$1 = (function (){var statearr_36829 = state_36822;
(statearr_36829[(7)] = inst_36804);

return statearr_36829;
})();
var statearr_36830_36850 = state_36822__$1;
(statearr_36830_36850[(2)] = null);

(statearr_36830_36850[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36823 === (11))){
var inst_36815 = (state_36822[(2)]);
var state_36822__$1 = state_36822;
var statearr_36832_36851 = state_36822__$1;
(statearr_36832_36851[(2)] = inst_36815);

(statearr_36832_36851[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36823 === (9))){
var inst_36804 = (state_36822[(7)]);
var state_36822__$1 = state_36822;
var statearr_36833_36852 = state_36822__$1;
(statearr_36833_36852[(2)] = inst_36804);

(statearr_36833_36852[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36823 === (5))){
var _ = (function (){var statearr_36834 = state_36822;
(statearr_36834[(4)] = cljs.core.rest((state_36822[(4)])));

return statearr_36834;
})();
var state_36822__$1 = state_36822;
var ex36831 = (state_36822__$1[(2)]);
var statearr_36835_36853 = state_36822__$1;
(statearr_36835_36853[(5)] = ex36831);


var statearr_36836_36854 = state_36822__$1;
(statearr_36836_36854[(1)] = (4));

(statearr_36836_36854[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_36823 === (10))){
var inst_36804 = (state_36822[(7)]);
var inst_36808 = (state_36822[(8)]);
var inst_36812 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36804,inst_36808);
var inst_36804__$1 = inst_36812;
var state_36822__$1 = (function (){var statearr_36837 = state_36822;
(statearr_36837[(7)] = inst_36804__$1);

return statearr_36837;
})();
var statearr_36838_36855 = state_36822__$1;
(statearr_36838_36855[(2)] = null);

(statearr_36838_36855[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36823 === (8))){
var inst_36808 = (state_36822[(8)]);
var inst_36807 = (state_36822[(2)]);
var inst_36808__$1 = fluree.db.util.async.throw_err(inst_36807);
var inst_36809 = (inst_36808__$1 == null);
var state_36822__$1 = (function (){var statearr_36839 = state_36822;
(statearr_36839[(8)] = inst_36808__$1);

return statearr_36839;
})();
if(cljs.core.truth_(inst_36809)){
var statearr_36840_36856 = state_36822__$1;
(statearr_36840_36856[(1)] = (9));

} else {
var statearr_36841_36857 = state_36822__$1;
(statearr_36841_36857[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__24298__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__24298__auto____0 = (function (){
var statearr_36842 = [null,null,null,null,null,null,null,null,null];
(statearr_36842[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__24298__auto__);

(statearr_36842[(1)] = (1));

return statearr_36842;
});
var fluree$db$util$async$into_QMARK__$_state_machine__24298__auto____1 = (function (state_36822){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_36822);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e36843){var ex__24301__auto__ = e36843;
var statearr_36844_36858 = state_36822;
(statearr_36844_36858[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_36822[(4)]))){
var statearr_36845_36859 = state_36822;
(statearr_36845_36859[(1)] = cljs.core.first((state_36822[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__36860 = state_36822;
state_36822 = G__36860;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__24298__auto__ = function(state_36822){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__24298__auto____1.call(this,state_36822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__24298__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__24298__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_36846 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_36846[(6)] = c__24424__auto__);

return statearr_36846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
