// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4212__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__39499 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39499,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39499,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39499,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39499,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39499,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39499,(5),null);
var G__39502 = idx;
var G__39502__$1 = (((G__39502 instanceof cljs.core.Keyword))?G__39502.fqn:null);
switch (G__39502__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39502__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__39504 = idx;
var G__39504__$1 = (((G__39504 instanceof cljs.core.Keyword))?G__39504.fqn:null);
switch (G__39504__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39504__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__39506 = idx;
var G__39506__$1 = (((G__39506 instanceof cljs.core.Keyword))?G__39506.fqn:null);
switch (G__39506__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39506__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__39509 = arguments.length;
switch (G__39509) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__39510 = (function (){var pred__39513 = cljs.core.identical_QMARK_;
var expr__39514 = test;
if(cljs.core.truth_((pred__39513.cljs$core$IFn$_invoke$arity$2 ? pred__39513.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__39514) : pred__39513.call(null,cljs.core._EQ_,expr__39514)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__39513.cljs$core$IFn$_invoke$arity$2 ? pred__39513.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__39514) : pred__39513.call(null,cljs.core._LT_,expr__39514)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__39513.cljs$core$IFn$_invoke$arity$2 ? pred__39513.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__39514) : pred__39513.call(null,cljs.core._LT__EQ_,expr__39514)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__39513.cljs$core$IFn$_invoke$arity$2 ? pred__39513.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__39514) : pred__39513.call(null,cljs.core._GT_,expr__39514)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__39513.cljs$core$IFn$_invoke$arity$2 ? pred__39513.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__39514) : pred__39513.call(null,cljs.core._GT__EQ_,expr__39514)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__39514)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39510,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39510,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39510,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39510,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_39753){
var state_val_39754 = (state_39753[(1)]);
if((state_val_39754 === (65))){
var inst_39668 = (state_39753[(7)]);
var inst_39724 = (state_39753[(8)]);
var inst_39724__$1 = (state_39753[(2)]);
var inst_39725 = cljs.core.count(inst_39724__$1);
var state_39753__$1 = (function (){var statearr_39755 = state_39753;
(statearr_39755[(9)] = inst_39725);

(statearr_39755[(8)] = inst_39724__$1);

return statearr_39755;
})();
if(cljs.core.truth_(inst_39668)){
var statearr_39756_39893 = state_39753__$1;
(statearr_39756_39893[(1)] = (81));

} else {
var statearr_39757_39894 = state_39753__$1;
(statearr_39757_39894[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (70))){
var inst_39699 = (state_39753[(2)]);
var state_39753__$1 = state_39753;
if(cljs.core.truth_(inst_39699)){
var statearr_39758_39895 = state_39753__$1;
(statearr_39758_39895[(1)] = (71));

} else {
var statearr_39759_39896 = state_39753__$1;
(statearr_39759_39896[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (62))){
var inst_39638 = (state_39753[(10)]);
var inst_39652 = (state_39753[(11)]);
var inst_39667 = (state_39753[(2)]);
var inst_39668 = fluree.db.dbproto._rhs(inst_39652);
var state_39753__$1 = (function (){var statearr_39760 = state_39753;
(statearr_39760[(7)] = inst_39668);

(statearr_39760[(12)] = inst_39667);

return statearr_39760;
})();
if(cljs.core.truth_(inst_39638)){
var statearr_39761_39897 = state_39753__$1;
(statearr_39761_39897[(1)] = (63));

} else {
var statearr_39762_39898 = state_39753__$1;
(statearr_39762_39898[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (74))){
var inst_39692 = (state_39753[(13)]);
var inst_39706 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_39692);
var state_39753__$1 = state_39753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39753__$1,(77),inst_39706);
} else {
if((state_val_39754 === (7))){
var inst_39529 = (state_39753[(14)]);
var state_39753__$1 = state_39753;
var statearr_39763_39899 = state_39753__$1;
(statearr_39763_39899[(2)] = inst_39529);

(statearr_39763_39899[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (59))){
var inst_39615 = (state_39753[(15)]);
var inst_39614 = (state_39753[(16)]);
var inst_39659 = (state_39753[(17)]);
var inst_39658 = (state_39753[(2)]);
var inst_39659__$1 = fluree.db.util.async.throw_err(inst_39658);
var inst_39660 = fluree.db.flake.subrange(inst_39659__$1,start_test,inst_39614,end_test,inst_39615);
var inst_39661 = fluree.db.query.range.value_with_nil_pred(idx,inst_39614,inst_39615);
var state_39753__$1 = (function (){var statearr_39764 = state_39753;
(statearr_39764[(18)] = inst_39660);

(statearr_39764[(17)] = inst_39659__$1);

return statearr_39764;
})();
if(inst_39661){
var statearr_39765_39900 = state_39753__$1;
(statearr_39765_39900[(1)] = (60));

} else {
var statearr_39766_39901 = state_39753__$1;
(statearr_39766_39901[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (86))){
var inst_39733 = (state_39753[(2)]);
var state_39753__$1 = state_39753;
var statearr_39767_39902 = state_39753__$1;
(statearr_39767_39902[(2)] = inst_39733);

(statearr_39767_39902[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (20))){
var inst_39530 = (state_39753[(19)]);
var inst_39578 = (state_39753[(20)]);
var inst_39577 = (state_39753[(2)]);
var inst_39578__$1 = (inst_39530 == null);
var state_39753__$1 = (function (){var statearr_39768 = state_39753;
(statearr_39768[(21)] = inst_39577);

(statearr_39768[(20)] = inst_39578__$1);

return statearr_39768;
})();
if(cljs.core.truth_(inst_39578__$1)){
var statearr_39769_39903 = state_39753__$1;
(statearr_39769_39903[(1)] = (22));

} else {
var statearr_39770_39904 = state_39753__$1;
(statearr_39770_39904[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (72))){
var inst_39685 = (state_39753[(22)]);
var inst_39703 = (inst_39685 + (1));
var inst_39704 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_39753__$1 = (function (){var statearr_39771 = state_39753;
(statearr_39771[(23)] = inst_39703);

return statearr_39771;
})();
if(cljs.core.truth_(inst_39704)){
var statearr_39772_39905 = state_39753__$1;
(statearr_39772_39905[(1)] = (74));

} else {
var statearr_39773_39906 = state_39753__$1;
(statearr_39773_39906[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (58))){
var inst_39748 = (state_39753[(2)]);
var _ = (function (){var statearr_39774 = state_39753;
(statearr_39774[(4)] = cljs.core.rest((state_39753[(4)])));

return statearr_39774;
})();
var state_39753__$1 = state_39753;
var statearr_39775_39907 = state_39753__$1;
(statearr_39775_39907[(2)] = inst_39748);

(statearr_39775_39907[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (60))){
var inst_39577 = (state_39753[(21)]);
var inst_39550 = (state_39753[(24)]);
var inst_39586 = (state_39753[(25)]);
var inst_39621 = (state_39753[(26)]);
var inst_39653 = (state_39753[(27)]);
var inst_39625 = (state_39753[(28)]);
var inst_39533 = (state_39753[(29)]);
var inst_39532 = (state_39753[(30)]);
var inst_39654 = (state_39753[(31)]);
var inst_39559 = (state_39753[(32)]);
var inst_39638 = (state_39753[(10)]);
var inst_39615 = (state_39753[(15)]);
var inst_39535 = (state_39753[(33)]);
var inst_39540 = (state_39753[(34)]);
var inst_39652 = (state_39753[(11)]);
var inst_39604 = (state_39753[(35)]);
var inst_39614 = (state_39753[(16)]);
var inst_39539 = (state_39753[(36)]);
var inst_39631 = (state_39753[(37)]);
var inst_39642 = (state_39753[(38)]);
var inst_39595 = (state_39753[(39)]);
var inst_39568 = (state_39753[(40)]);
var inst_39620 = (state_39753[(41)]);
var inst_39613 = (state_39753[(42)]);
var inst_39528 = (state_39753[(43)]);
var inst_39660 = (state_39753[(18)]);
var inst_39647 = (state_39753[(44)]);
var inst_39659 = (state_39753[(17)]);
var inst_39632 = (state_39753[(45)]);
var inst_39663 = (function (){var no_filter_QMARK_ = inst_39638;
var next_node = inst_39652;
var flakes = inst_39659;
var s1 = inst_39550;
var o2 = inst_39577;
var t1 = inst_39532;
var i = inst_39653;
var m1 = inst_39604;
var root_node = inst_39647;
var to_t = inst_39632;
var s2 = inst_39559;
var p2 = inst_39595;
var permissions = inst_39621;
var limit = inst_39620;
var start_flake = inst_39614;
var vec__39522 = inst_39528;
var acc = inst_39654;
var t2 = inst_39539;
var op1 = inst_39533;
var o1 = inst_39568;
var end_flake = inst_39615;
var base_result = inst_39660;
var p1 = inst_39586;
var vec__39525 = inst_39535;
var idx_compare = inst_39625;
var op2 = inst_39540;
var from_t = inst_39631;
var m2 = inst_39613;
var novelty = inst_39642;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_39664 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39663,inst_39660,inst_39660);
var state_39753__$1 = state_39753;
var statearr_39776_39908 = state_39753__$1;
(statearr_39776_39908[(2)] = inst_39664);

(statearr_39776_39908[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (27))){
var inst_39537 = (state_39753[(46)]);
var inst_39587 = (state_39753[(47)]);
var inst_39586 = (state_39753[(2)]);
var inst_39587__$1 = (inst_39537 == null);
var state_39753__$1 = (function (){var statearr_39777 = state_39753;
(statearr_39777[(25)] = inst_39586);

(statearr_39777[(47)] = inst_39587__$1);

return statearr_39777;
})();
if(cljs.core.truth_(inst_39587__$1)){
var statearr_39778_39909 = state_39753__$1;
(statearr_39778_39909[(1)] = (28));

} else {
var statearr_39779_39910 = state_39753__$1;
(statearr_39779_39910[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (1))){
var state_39753__$1 = state_39753;
var statearr_39780_39911 = state_39753__$1;
(statearr_39780_39911[(2)] = null);

(statearr_39780_39911[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (69))){
var inst_39685 = (state_39753[(22)]);
var inst_39620 = (state_39753[(41)]);
var inst_39697 = (inst_39685 > inst_39620);
var state_39753__$1 = state_39753;
var statearr_39781_39912 = state_39753__$1;
(statearr_39781_39912[(2)] = inst_39697);

(statearr_39781_39912[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (24))){
var inst_39582 = (state_39753[(2)]);
var state_39753__$1 = state_39753;
if(cljs.core.truth_(inst_39582)){
var statearr_39782_39913 = state_39753__$1;
(statearr_39782_39913[(1)] = (25));

} else {
var statearr_39783_39914 = state_39753__$1;
(statearr_39783_39914[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (55))){
var inst_39614 = (state_39753[(16)]);
var inst_39647 = (state_39753[(44)]);
var inst_39646 = (state_39753[(2)]);
var inst_39647__$1 = fluree.db.util.async.throw_err(inst_39646);
var inst_39648 = fluree.db.dbproto._lookup_leaf(inst_39647__$1,inst_39614);
var state_39753__$1 = (function (){var statearr_39784 = state_39753;
(statearr_39784[(44)] = inst_39647__$1);

return statearr_39784;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39753__$1,(56),inst_39648);
} else {
if((state_val_39754 === (85))){
var inst_39728 = (state_39753[(48)]);
var state_39753__$1 = state_39753;
var statearr_39785_39915 = state_39753__$1;
(statearr_39785_39915[(2)] = inst_39728);

(statearr_39785_39915[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (39))){
var inst_39602 = (state_39753[(2)]);
var state_39753__$1 = state_39753;
var statearr_39786_39916 = state_39753__$1;
(statearr_39786_39916[(2)] = inst_39602);

(statearr_39786_39916[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (88))){
var inst_39668 = (state_39753[(7)]);
var inst_39647 = (state_39753[(44)]);
var inst_39740 = fluree.db.dbproto._lookup_leaf(inst_39647,inst_39668);
var state_39753__$1 = state_39753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39753__$1,(90),inst_39740);
} else {
if((state_val_39754 === (46))){
var inst_39616 = (state_39753[(49)]);
var state_39753__$1 = state_39753;
var statearr_39787_39917 = state_39753__$1;
(statearr_39787_39917[(2)] = inst_39616);

(statearr_39787_39917[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (4))){
var inst_39516 = (state_39753[(2)]);
var state_39753__$1 = state_39753;
var statearr_39788_39918 = state_39753__$1;
(statearr_39788_39918[(2)] = inst_39516);

(statearr_39788_39918[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (77))){
var inst_39708 = (state_39753[(2)]);
var inst_39709 = fluree.db.util.async.throw_err(inst_39708);
var state_39753__$1 = state_39753;
if(cljs.core.truth_(inst_39709)){
var statearr_39789_39919 = state_39753__$1;
(statearr_39789_39919[(1)] = (78));

} else {
var statearr_39790_39920 = state_39753__$1;
(statearr_39790_39920[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (54))){
var inst_39638 = (state_39753[(2)]);
var inst_39639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39640 = [cljs.core.cst$kw$novelty,idx];
var inst_39641 = (new cljs.core.PersistentVector(null,2,(5),inst_39639,inst_39640,null));
var inst_39642 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_39641);
var inst_39643 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_39644 = fluree.db.dbproto._resolve(inst_39643);
var state_39753__$1 = (function (){var statearr_39791 = state_39753;
(statearr_39791[(10)] = inst_39638);

(statearr_39791[(38)] = inst_39642);

return statearr_39791;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39753__$1,(55),inst_39644);
} else {
if((state_val_39754 === (15))){
var inst_39531 = (state_39753[(50)]);
var state_39753__$1 = state_39753;
var statearr_39792_39921 = state_39753__$1;
(statearr_39792_39921[(2)] = inst_39531);

(statearr_39792_39921[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (48))){
var inst_39626 = (state_39753[(51)]);
var inst_39620 = (state_39753[(2)]);
var inst_39621 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_39622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39623 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_39624 = (new cljs.core.PersistentVector(null,3,(5),inst_39622,inst_39623,null));
var inst_39625 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_39624);
var inst_39626__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_39753__$1 = (function (){var statearr_39793 = state_39753;
(statearr_39793[(26)] = inst_39621);

(statearr_39793[(28)] = inst_39625);

(statearr_39793[(41)] = inst_39620);

(statearr_39793[(51)] = inst_39626__$1);

return statearr_39793;
})();
if(cljs.core.truth_(inst_39626__$1)){
var statearr_39794_39922 = state_39753__$1;
(statearr_39794_39922[(1)] = (49));

} else {
var statearr_39795_39923 = state_39753__$1;
(statearr_39795_39923[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (50))){
var inst_39629 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_39753__$1 = state_39753;
var statearr_39796_39924 = state_39753__$1;
(statearr_39796_39924[(2)] = inst_39629);

(statearr_39796_39924[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (75))){
var inst_39686 = (state_39753[(52)]);
var state_39753__$1 = state_39753;
var statearr_39797_39925 = state_39753__$1;
(statearr_39797_39925[(2)] = inst_39686);

(statearr_39797_39925[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (21))){
var inst_39573 = (state_39753[(2)]);
var inst_39574 = fluree.db.util.async.throw_err(inst_39573);
var state_39753__$1 = state_39753;
var statearr_39798_39926 = state_39753__$1;
(statearr_39798_39926[(2)] = inst_39574);

(statearr_39798_39926[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (31))){
var state_39753__$1 = state_39753;
var statearr_39799_39927 = state_39753__$1;
(statearr_39799_39927[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_39799_39927[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (32))){
var inst_39537 = (state_39753[(46)]);
var state_39753__$1 = state_39753;
var statearr_39800_39928 = state_39753__$1;
(statearr_39800_39928[(2)] = inst_39537);

(statearr_39800_39928[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (40))){
var inst_39541 = (state_39753[(53)]);
var state_39753__$1 = state_39753;
var statearr_39801_39929 = state_39753__$1;
(statearr_39801_39929[(2)] = inst_39541);

(statearr_39801_39929[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (56))){
var inst_39650 = (state_39753[(2)]);
var inst_39651 = fluree.db.util.async.throw_err(inst_39650);
var inst_39652 = inst_39651;
var inst_39653 = (0);
var inst_39654 = null;
var state_39753__$1 = (function (){var statearr_39802 = state_39753;
(statearr_39802[(27)] = inst_39653);

(statearr_39802[(31)] = inst_39654);

(statearr_39802[(11)] = inst_39652);

return statearr_39802;
})();
var statearr_39803_39930 = state_39753__$1;
(statearr_39803_39930[(2)] = null);

(statearr_39803_39930[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (33))){
var inst_39534 = (state_39753[(54)]);
var inst_39595 = (state_39753[(2)]);
var state_39753__$1 = (function (){var statearr_39804 = state_39753;
(statearr_39804[(39)] = inst_39595);

return statearr_39804;
})();
if(cljs.core.truth_(inst_39534)){
var statearr_39805_39931 = state_39753__$1;
(statearr_39805_39931[(1)] = (34));

} else {
var statearr_39806_39932 = state_39753__$1;
(statearr_39806_39932[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (13))){
var inst_39555 = (state_39753[(2)]);
var inst_39556 = fluree.db.util.async.throw_err(inst_39555);
var state_39753__$1 = state_39753;
var statearr_39807_39933 = state_39753__$1;
(statearr_39807_39933[(2)] = inst_39556);

(statearr_39807_39933[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (22))){
var inst_39568 = (state_39753[(40)]);
var state_39753__$1 = state_39753;
var statearr_39808_39934 = state_39753__$1;
(statearr_39808_39934[(2)] = inst_39568);

(statearr_39808_39934[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (90))){
var inst_39725 = (state_39753[(9)]);
var inst_39724 = (state_39753[(8)]);
var inst_39742 = (state_39753[(2)]);
var inst_39743 = fluree.db.util.async.throw_err(inst_39742);
var inst_39652 = inst_39743;
var inst_39653 = inst_39725;
var inst_39654 = inst_39724;
var state_39753__$1 = (function (){var statearr_39809 = state_39753;
(statearr_39809[(27)] = inst_39653);

(statearr_39809[(31)] = inst_39654);

(statearr_39809[(11)] = inst_39652);

return statearr_39809;
})();
var statearr_39810_39935 = state_39753__$1;
(statearr_39810_39935[(2)] = null);

(statearr_39810_39935[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (36))){
var inst_39541 = (state_39753[(53)]);
var inst_39604 = (state_39753[(2)]);
var state_39753__$1 = (function (){var statearr_39811 = state_39753;
(statearr_39811[(35)] = inst_39604);

return statearr_39811;
})();
if(cljs.core.truth_(inst_39541)){
var statearr_39812_39936 = state_39753__$1;
(statearr_39812_39936[(1)] = (40));

} else {
var statearr_39813_39937 = state_39753__$1;
(statearr_39813_39937[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (41))){
var inst_39607 = (cljs.core._LT__EQ_ === end_test);
var state_39753__$1 = state_39753;
if(cljs.core.truth_(inst_39607)){
var statearr_39814_39938 = state_39753__$1;
(statearr_39814_39938[(1)] = (43));

} else {
var statearr_39815_39939 = state_39753__$1;
(statearr_39815_39939[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (89))){
var inst_39746 = (state_39753[(2)]);
var state_39753__$1 = state_39753;
var statearr_39816_39940 = state_39753__$1;
(statearr_39816_39940[(2)] = inst_39746);

(statearr_39816_39940[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (43))){
var state_39753__$1 = state_39753;
var statearr_39817_39941 = state_39753__$1;
(statearr_39817_39941[(2)] = (2147483647));

(statearr_39817_39941[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (61))){
var inst_39660 = (state_39753[(18)]);
var state_39753__$1 = state_39753;
var statearr_39818_39942 = state_39753__$1;
(statearr_39818_39942[(2)] = inst_39660);

(statearr_39818_39942[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (29))){
var inst_39587 = (state_39753[(47)]);
var state_39753__$1 = state_39753;
var statearr_39819_39943 = state_39753__$1;
(statearr_39819_39943[(2)] = inst_39587);

(statearr_39819_39943[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (44))){
var state_39753__$1 = state_39753;
var statearr_39820_39944 = state_39753__$1;
(statearr_39820_39944[(2)] = fluree.db.util.core.min_integer);

(statearr_39820_39944[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (6))){
var inst_39529 = (state_39753[(14)]);
var inst_39544 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_39529);
var state_39753__$1 = state_39753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39753__$1,(9),inst_39544);
} else {
if((state_val_39754 === (28))){
var inst_39577 = (state_39753[(21)]);
var state_39753__$1 = state_39753;
var statearr_39821_39945 = state_39753__$1;
(statearr_39821_39945[(2)] = inst_39577);

(statearr_39821_39945[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (64))){
var inst_39653 = (state_39753[(27)]);
var inst_39667 = (state_39753[(12)]);
var inst_39681 = cljs.core.seq(inst_39667);
var inst_39682 = cljs.core.first(inst_39681);
var inst_39683 = cljs.core.next(inst_39681);
var inst_39684 = inst_39667;
var inst_39685 = inst_39653;
var inst_39686 = inst_39667;
var state_39753__$1 = (function (){var statearr_39822 = state_39753;
(statearr_39822[(22)] = inst_39685);

(statearr_39822[(52)] = inst_39686);

(statearr_39822[(55)] = inst_39683);

(statearr_39822[(56)] = inst_39682);

(statearr_39822[(57)] = inst_39684);

return statearr_39822;
})();
var statearr_39823_39946 = state_39753__$1;
(statearr_39823_39946[(2)] = null);

(statearr_39823_39946[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (51))){
var inst_39631 = (state_39753[(2)]);
var inst_39632 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_39633 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_39753__$1 = (function (){var statearr_39824 = state_39753;
(statearr_39824[(37)] = inst_39631);

(statearr_39824[(45)] = inst_39632);

return statearr_39824;
})();
if(cljs.core.truth_(inst_39633)){
var statearr_39825_39947 = state_39753__$1;
(statearr_39825_39947[(1)] = (52));

} else {
var statearr_39826_39948 = state_39753__$1;
(statearr_39826_39948[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (25))){
var state_39753__$1 = state_39753;
var statearr_39827_39949 = state_39753__$1;
(statearr_39827_39949[(2)] = (-1));

(statearr_39827_39949[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (34))){
var inst_39534 = (state_39753[(54)]);
var state_39753__$1 = state_39753;
var statearr_39828_39950 = state_39753__$1;
(statearr_39828_39950[(2)] = inst_39534);

(statearr_39828_39950[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (17))){
var inst_39564 = (state_39753[(2)]);
var inst_39565 = fluree.db.util.async.throw_err(inst_39564);
var state_39753__$1 = state_39753;
var statearr_39829_39951 = state_39753__$1;
(statearr_39829_39951[(2)] = inst_39565);

(statearr_39829_39951[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (3))){
var inst_39751 = (state_39753[(2)]);
var state_39753__$1 = state_39753;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39753__$1,inst_39751);
} else {
if((state_val_39754 === (12))){
var inst_39531 = (state_39753[(50)]);
var inst_39559 = (state_39753[(2)]);
var inst_39560 = fluree.db.util.core.pred_ident_QMARK_(inst_39531);
var state_39753__$1 = (function (){var statearr_39830 = state_39753;
(statearr_39830[(32)] = inst_39559);

return statearr_39830;
})();
if(inst_39560){
var statearr_39831_39952 = state_39753__$1;
(statearr_39831_39952[(1)] = (14));

} else {
var statearr_39832_39953 = state_39753__$1;
(statearr_39832_39953[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (2))){
var inst_39529 = (state_39753[(14)]);
var inst_39535 = (state_39753[(33)]);
var inst_39528 = (state_39753[(43)]);
var _ = (function (){var statearr_39833 = state_39753;
(statearr_39833[(4)] = cljs.core.cons((5),(state_39753[(4)])));

return statearr_39833;
})();
var inst_39528__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_39529__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39528__$1,(0),null);
var inst_39530 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39528__$1,(1),null);
var inst_39531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39528__$1,(2),null);
var inst_39532 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39528__$1,(3),null);
var inst_39533 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39528__$1,(4),null);
var inst_39534 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39528__$1,(5),null);
var inst_39535__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_39536 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39535__$1,(0),null);
var inst_39537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39535__$1,(1),null);
var inst_39538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39535__$1,(2),null);
var inst_39539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39535__$1,(3),null);
var inst_39540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39535__$1,(4),null);
var inst_39541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39535__$1,(5),null);
var inst_39542 = fluree.db.util.core.pred_ident_QMARK_(inst_39529__$1);
var state_39753__$1 = (function (){var statearr_39834 = state_39753;
(statearr_39834[(54)] = inst_39534);

(statearr_39834[(50)] = inst_39531);

(statearr_39834[(53)] = inst_39541);

(statearr_39834[(29)] = inst_39533);

(statearr_39834[(46)] = inst_39537);

(statearr_39834[(30)] = inst_39532);

(statearr_39834[(14)] = inst_39529__$1);

(statearr_39834[(33)] = inst_39535__$1);

(statearr_39834[(34)] = inst_39540);

(statearr_39834[(19)] = inst_39530);

(statearr_39834[(36)] = inst_39539);

(statearr_39834[(58)] = inst_39536);

(statearr_39834[(59)] = inst_39538);

(statearr_39834[(43)] = inst_39528__$1);

return statearr_39834;
})();
if(inst_39542){
var statearr_39835_39954 = state_39753__$1;
(statearr_39835_39954[(1)] = (6));

} else {
var statearr_39836_39955 = state_39753__$1;
(statearr_39836_39955[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (66))){
var inst_39694 = (state_39753[(60)]);
var inst_39692 = (state_39753[(13)]);
var inst_39684 = (state_39753[(57)]);
var inst_39691 = cljs.core.seq(inst_39684);
var inst_39692__$1 = cljs.core.first(inst_39691);
var inst_39693 = cljs.core.next(inst_39691);
var inst_39694__$1 = (inst_39692__$1 == null);
var state_39753__$1 = (function (){var statearr_39837 = state_39753;
(statearr_39837[(60)] = inst_39694__$1);

(statearr_39837[(61)] = inst_39693);

(statearr_39837[(13)] = inst_39692__$1);

return statearr_39837;
})();
if(cljs.core.truth_(inst_39694__$1)){
var statearr_39838_39956 = state_39753__$1;
(statearr_39838_39956[(1)] = (68));

} else {
var statearr_39839_39957 = state_39753__$1;
(statearr_39839_39957[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (23))){
var inst_39578 = (state_39753[(20)]);
var state_39753__$1 = state_39753;
var statearr_39840_39958 = state_39753__$1;
(statearr_39840_39958[(2)] = inst_39578);

(statearr_39840_39958[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (47))){
var state_39753__$1 = state_39753;
var statearr_39841_39959 = state_39753__$1;
(statearr_39841_39959[(2)] = fluree.db.util.core.max_long);

(statearr_39841_39959[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (35))){
var inst_39598 = (cljs.core._GT__EQ_ === start_test);
var state_39753__$1 = state_39753;
if(cljs.core.truth_(inst_39598)){
var statearr_39842_39960 = state_39753__$1;
(statearr_39842_39960[(1)] = (37));

} else {
var statearr_39843_39961 = state_39753__$1;
(statearr_39843_39961[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (82))){
var inst_39668 = (state_39753[(7)]);
var state_39753__$1 = state_39753;
var statearr_39844_39962 = state_39753__$1;
(statearr_39844_39962[(2)] = inst_39668);

(statearr_39844_39962[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (76))){
var inst_39693 = (state_39753[(61)]);
var inst_39703 = (state_39753[(23)]);
var inst_39717 = (state_39753[(2)]);
var inst_39684 = inst_39693;
var inst_39685 = inst_39703;
var inst_39686 = inst_39717;
var state_39753__$1 = (function (){var statearr_39845 = state_39753;
(statearr_39845[(22)] = inst_39685);

(statearr_39845[(52)] = inst_39686);

(statearr_39845[(57)] = inst_39684);

return statearr_39845;
})();
var statearr_39846_39963 = state_39753__$1;
(statearr_39846_39963[(2)] = null);

(statearr_39846_39963[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (19))){
var inst_39538 = (state_39753[(59)]);
var state_39753__$1 = state_39753;
var statearr_39847_39964 = state_39753__$1;
(statearr_39847_39964[(2)] = inst_39538);

(statearr_39847_39964[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (57))){
var inst_39652 = (state_39753[(11)]);
var inst_39631 = (state_39753[(37)]);
var inst_39642 = (state_39753[(38)]);
var inst_39632 = (state_39753[(45)]);
var inst_39656 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_39652,inst_39631,inst_39632,inst_39642);
var state_39753__$1 = state_39753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39753__$1,(59),inst_39656);
} else {
if((state_val_39754 === (68))){
var inst_39694 = (state_39753[(60)]);
var state_39753__$1 = state_39753;
var statearr_39848_39965 = state_39753__$1;
(statearr_39848_39965[(2)] = inst_39694);

(statearr_39848_39965[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (11))){
var inst_39536 = (state_39753[(58)]);
var state_39753__$1 = state_39753;
var statearr_39850_39966 = state_39753__$1;
(statearr_39850_39966[(2)] = inst_39536);

(statearr_39850_39966[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (9))){
var inst_39546 = (state_39753[(2)]);
var inst_39547 = fluree.db.util.async.throw_err(inst_39546);
var state_39753__$1 = state_39753;
var statearr_39851_39967 = state_39753__$1;
(statearr_39851_39967[(2)] = inst_39547);

(statearr_39851_39967[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (5))){
var _ = (function (){var statearr_39852 = state_39753;
(statearr_39852[(4)] = cljs.core.rest((state_39753[(4)])));

return statearr_39852;
})();
var state_39753__$1 = state_39753;
var ex39849 = (state_39753__$1[(2)]);
var statearr_39853_39968 = state_39753__$1;
(statearr_39853_39968[(5)] = ex39849);


if((ex39849 instanceof Error)){
var statearr_39854_39969 = state_39753__$1;
(statearr_39854_39969[(1)] = (4));

(statearr_39854_39969[(5)] = null);

} else {
throw ex39849;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (83))){
var inst_39736 = (state_39753[(2)]);
var inst_39737 = cljs.core.not(inst_39736);
var state_39753__$1 = state_39753;
if(inst_39737){
var statearr_39855_39970 = state_39753__$1;
(statearr_39855_39970[(1)] = (87));

} else {
var statearr_39856_39971 = state_39753__$1;
(statearr_39856_39971[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (14))){
var inst_39531 = (state_39753[(50)]);
var inst_39562 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_39531);
var state_39753__$1 = state_39753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39753__$1,(17),inst_39562);
} else {
if((state_val_39754 === (45))){
var inst_39611 = (state_39753[(2)]);
var state_39753__$1 = state_39753;
var statearr_39857_39972 = state_39753__$1;
(statearr_39857_39972[(2)] = inst_39611);

(statearr_39857_39972[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (53))){
var state_39753__$1 = state_39753;
var statearr_39858_39973 = state_39753__$1;
(statearr_39858_39973[(2)] = true);

(statearr_39858_39973[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (78))){
var inst_39686 = (state_39753[(52)]);
var state_39753__$1 = state_39753;
var statearr_39859_39974 = state_39753__$1;
(statearr_39859_39974[(2)] = inst_39686);

(statearr_39859_39974[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (26))){
var inst_39530 = (state_39753[(19)]);
var state_39753__$1 = state_39753;
var statearr_39860_39975 = state_39753__$1;
(statearr_39860_39975[(2)] = inst_39530);

(statearr_39860_39975[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (16))){
var inst_39538 = (state_39753[(59)]);
var inst_39568 = (state_39753[(2)]);
var inst_39569 = fluree.db.util.core.pred_ident_QMARK_(inst_39538);
var state_39753__$1 = (function (){var statearr_39861 = state_39753;
(statearr_39861[(40)] = inst_39568);

return statearr_39861;
})();
if(inst_39569){
var statearr_39862_39976 = state_39753__$1;
(statearr_39862_39976[(1)] = (18));

} else {
var statearr_39863_39977 = state_39753__$1;
(statearr_39863_39977[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (81))){
var inst_39668 = (state_39753[(7)]);
var inst_39625 = (state_39753[(28)]);
var inst_39728 = (state_39753[(48)]);
var inst_39615 = (state_39753[(15)]);
var inst_39727 = (inst_39625.cljs$core$IFn$_invoke$arity$2 ? inst_39625.cljs$core$IFn$_invoke$arity$2(inst_39668,inst_39615) : inst_39625.call(null,inst_39668,inst_39615));
var inst_39728__$1 = (inst_39727 < (0));
var state_39753__$1 = (function (){var statearr_39864 = state_39753;
(statearr_39864[(48)] = inst_39728__$1);

return statearr_39864;
})();
if(cljs.core.truth_(inst_39728__$1)){
var statearr_39865_39978 = state_39753__$1;
(statearr_39865_39978[(1)] = (84));

} else {
var statearr_39866_39979 = state_39753__$1;
(statearr_39866_39979[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (79))){
var inst_39686 = (state_39753[(52)]);
var inst_39692 = (state_39753[(13)]);
var inst_39712 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_39686,inst_39692);
var state_39753__$1 = state_39753;
var statearr_39867_39980 = state_39753__$1;
(statearr_39867_39980[(2)] = inst_39712);

(statearr_39867_39980[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (38))){
var state_39753__$1 = state_39753;
var statearr_39868_39981 = state_39753__$1;
(statearr_39868_39981[(2)] = (2147483647));

(statearr_39868_39981[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (87))){
var inst_39724 = (state_39753[(8)]);
var state_39753__$1 = state_39753;
var statearr_39869_39982 = state_39753__$1;
(statearr_39869_39982[(2)] = inst_39724);

(statearr_39869_39982[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (30))){
var inst_39591 = (state_39753[(2)]);
var state_39753__$1 = state_39753;
if(cljs.core.truth_(inst_39591)){
var statearr_39870_39983 = state_39753__$1;
(statearr_39870_39983[(1)] = (31));

} else {
var statearr_39871_39984 = state_39753__$1;
(statearr_39871_39984[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (73))){
var inst_39720 = (state_39753[(2)]);
var state_39753__$1 = state_39753;
var statearr_39872_39985 = state_39753__$1;
(statearr_39872_39985[(2)] = inst_39720);

(statearr_39872_39985[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (10))){
var inst_39536 = (state_39753[(58)]);
var inst_39553 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_39536);
var state_39753__$1 = state_39753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39753__$1,(13),inst_39553);
} else {
if((state_val_39754 === (18))){
var inst_39538 = (state_39753[(59)]);
var inst_39571 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_39538);
var state_39753__$1 = state_39753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39753__$1,(21),inst_39571);
} else {
if((state_val_39754 === (52))){
var inst_39550 = (state_39753[(24)]);
var inst_39586 = (state_39753[(25)]);
var inst_39621 = (state_39753[(26)]);
var inst_39559 = (state_39753[(32)]);
var inst_39595 = (state_39753[(39)]);
var inst_39635 = fluree.db.permissions_validate.no_filter_QMARK_(inst_39621,inst_39550,inst_39559,inst_39586,inst_39595);
var state_39753__$1 = state_39753;
var statearr_39873_39986 = state_39753__$1;
(statearr_39873_39986[(2)] = inst_39635);

(statearr_39873_39986[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (67))){
var inst_39722 = (state_39753[(2)]);
var state_39753__$1 = state_39753;
var statearr_39874_39987 = state_39753__$1;
(statearr_39874_39987[(2)] = inst_39722);

(statearr_39874_39987[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (71))){
var inst_39654 = (state_39753[(31)]);
var inst_39686 = (state_39753[(52)]);
var inst_39701 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39686,inst_39654);
var state_39753__$1 = state_39753;
var statearr_39875_39988 = state_39753__$1;
(statearr_39875_39988[(2)] = inst_39701);

(statearr_39875_39988[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (42))){
var inst_39577 = (state_39753[(21)]);
var inst_39550 = (state_39753[(24)]);
var inst_39586 = (state_39753[(25)]);
var inst_39533 = (state_39753[(29)]);
var inst_39532 = (state_39753[(30)]);
var inst_39559 = (state_39753[(32)]);
var inst_39540 = (state_39753[(34)]);
var inst_39604 = (state_39753[(35)]);
var inst_39616 = (state_39753[(49)]);
var inst_39539 = (state_39753[(36)]);
var inst_39595 = (state_39753[(39)]);
var inst_39568 = (state_39753[(40)]);
var inst_39613 = (state_39753[(42)]);
var inst_39613__$1 = (state_39753[(2)]);
var inst_39614 = fluree.db.flake.__GT_Flake(inst_39550,inst_39586,inst_39568,inst_39532,inst_39533,inst_39604);
var inst_39615 = fluree.db.flake.__GT_Flake(inst_39559,inst_39595,inst_39577,inst_39539,inst_39540,inst_39613__$1);
var inst_39616__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_39753__$1 = (function (){var statearr_39876 = state_39753;
(statearr_39876[(15)] = inst_39615);

(statearr_39876[(16)] = inst_39614);

(statearr_39876[(49)] = inst_39616__$1);

(statearr_39876[(42)] = inst_39613__$1);

return statearr_39876;
})();
if(cljs.core.truth_(inst_39616__$1)){
var statearr_39877_39989 = state_39753__$1;
(statearr_39877_39989[(1)] = (46));

} else {
var statearr_39878_39990 = state_39753__$1;
(statearr_39878_39990[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (80))){
var inst_39714 = (state_39753[(2)]);
var state_39753__$1 = state_39753;
var statearr_39879_39991 = state_39753__$1;
(statearr_39879_39991[(2)] = inst_39714);

(statearr_39879_39991[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (37))){
var state_39753__$1 = state_39753;
var statearr_39880_39992 = state_39753__$1;
(statearr_39880_39992[(2)] = fluree.db.util.core.min_integer);

(statearr_39880_39992[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (63))){
var inst_39653 = (state_39753[(27)]);
var inst_39654 = (state_39753[(31)]);
var inst_39620 = (state_39753[(41)]);
var inst_39667 = (state_39753[(12)]);
var inst_39670 = (inst_39620 - inst_39653);
var inst_39671 = fluree.db.flake.take(inst_39670,inst_39667);
var inst_39672 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39671,inst_39654);
var state_39753__$1 = state_39753;
var statearr_39881_39993 = state_39753__$1;
(statearr_39881_39993[(2)] = inst_39672);

(statearr_39881_39993[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (8))){
var inst_39536 = (state_39753[(58)]);
var inst_39550 = (state_39753[(2)]);
var inst_39551 = fluree.db.util.core.pred_ident_QMARK_(inst_39536);
var state_39753__$1 = (function (){var statearr_39882 = state_39753;
(statearr_39882[(24)] = inst_39550);

return statearr_39882;
})();
if(inst_39551){
var statearr_39883_39994 = state_39753__$1;
(statearr_39883_39994[(1)] = (10));

} else {
var statearr_39884_39995 = state_39753__$1;
(statearr_39884_39995[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (49))){
var inst_39626 = (state_39753[(51)]);
var state_39753__$1 = state_39753;
var statearr_39885_39996 = state_39753__$1;
(statearr_39885_39996[(2)] = inst_39626);

(statearr_39885_39996[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39754 === (84))){
var inst_39725 = (state_39753[(9)]);
var inst_39620 = (state_39753[(41)]);
var inst_39730 = (inst_39725 < inst_39620);
var state_39753__$1 = state_39753;
var statearr_39886_39997 = state_39753__$1;
(statearr_39886_39997[(2)] = inst_39730);

(statearr_39886_39997[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__24298__auto__ = null;
var fluree$db$query$range$state_machine__24298__auto____0 = (function (){
var statearr_39887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39887[(0)] = fluree$db$query$range$state_machine__24298__auto__);

(statearr_39887[(1)] = (1));

return statearr_39887;
});
var fluree$db$query$range$state_machine__24298__auto____1 = (function (state_39753){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_39753);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e39888){var ex__24301__auto__ = e39888;
var statearr_39889_39998 = state_39753;
(statearr_39889_39998[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_39753[(4)]))){
var statearr_39890_39999 = state_39753;
(statearr_39890_39999[(1)] = cljs.core.first((state_39753[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__40000 = state_39753;
state_39753 = G__40000;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__24298__auto__ = function(state_39753){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__24298__auto____1.call(this,state_39753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__24298__auto____0;
fluree$db$query$range$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__24298__auto____1;
return fluree$db$query$range$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_39891 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_39891[(6)] = c__24424__auto__);

return statearr_39891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_40075){
var state_val_40076 = (state_40075[(1)]);
if((state_val_40076 === (7))){
var inst_40070 = (state_40075[(2)]);
var _ = (function (){var statearr_40077 = state_40075;
(statearr_40077[(4)] = cljs.core.rest((state_40075[(4)])));

return statearr_40077;
})();
var state_40075__$1 = state_40075;
var statearr_40078_40118 = state_40075__$1;
(statearr_40078_40118[(2)] = inst_40070);

(statearr_40078_40118[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (20))){
var inst_40052 = (state_40075[(2)]);
var inst_40053 = fluree.db.util.async.throw_err(inst_40052);
var state_40075__$1 = state_40075;
var statearr_40079_40119 = state_40075__$1;
(statearr_40079_40119[(2)] = inst_40053);

(statearr_40079_40119[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (1))){
var state_40075__$1 = state_40075;
var statearr_40080_40120 = state_40075__$1;
(statearr_40080_40120[(2)] = null);

(statearr_40080_40120[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (4))){
var inst_40001 = (state_40075[(2)]);
var state_40075__$1 = state_40075;
var statearr_40081_40121 = state_40075__$1;
(statearr_40081_40121[(2)] = inst_40001);

(statearr_40081_40121[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (15))){
var inst_40048 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_40075__$1 = state_40075;
if(cljs.core.truth_(inst_40048)){
var statearr_40082_40122 = state_40075__$1;
(statearr_40082_40122[(1)] = (17));

} else {
var statearr_40083_40123 = state_40075__$1;
(statearr_40083_40123[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (21))){
var state_40075__$1 = state_40075;
var statearr_40084_40124 = state_40075__$1;
(statearr_40084_40124[(2)] = (0));

(statearr_40084_40124[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (13))){
var inst_40040 = (state_40075[(2)]);
var state_40075__$1 = state_40075;
var statearr_40085_40125 = state_40075__$1;
(statearr_40085_40125[(2)] = inst_40040);

(statearr_40085_40125[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (22))){
var state_40075__$1 = state_40075;
var statearr_40086_40126 = state_40075__$1;
(statearr_40086_40126[(2)] = (1));

(statearr_40086_40126[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (6))){
var inst_40030 = (state_40075[(7)]);
var inst_40021 = (state_40075[(8)]);
var inst_40032 = (state_40075[(9)]);
var inst_40029 = cljs.core.seq(inst_40021);
var inst_40030__$1 = cljs.core.first(inst_40029);
var inst_40031 = cljs.core.next(inst_40029);
var inst_40032__$1 = (inst_40030__$1 == null);
var state_40075__$1 = (function (){var statearr_40087 = state_40075;
(statearr_40087[(7)] = inst_40030__$1);

(statearr_40087[(10)] = inst_40031);

(statearr_40087[(9)] = inst_40032__$1);

return statearr_40087;
})();
if(cljs.core.truth_(inst_40032__$1)){
var statearr_40088_40127 = state_40075__$1;
(statearr_40088_40127[(1)] = (8));

} else {
var statearr_40089_40128 = state_40075__$1;
(statearr_40089_40128[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (17))){
var inst_40030 = (state_40075[(7)]);
var inst_40050 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_40030);
var state_40075__$1 = state_40075;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40075__$1,(20),inst_40050);
} else {
if((state_val_40076 === (3))){
var inst_40073 = (state_40075[(2)]);
var state_40075__$1 = state_40075;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40075__$1,inst_40073);
} else {
if((state_val_40076 === (12))){
var inst_40023 = (state_40075[(11)]);
var inst_40038 = (inst_40023 >= subject_limit);
var state_40075__$1 = state_40075;
var statearr_40090_40129 = state_40075__$1;
(statearr_40090_40129[(2)] = inst_40038);

(statearr_40090_40129[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (2))){
var _ = (function (){var statearr_40091 = state_40075;
(statearr_40091[(4)] = cljs.core.cons((5),(state_40075[(4)])));

return statearr_40091;
})();
var inst_40014 = subject_groups;
var inst_40015 = cljs.core.seq(inst_40014);
var inst_40016 = cljs.core.first(inst_40015);
var inst_40017 = cljs.core.next(inst_40015);
var inst_40018 = flake_start;
var inst_40019 = subject_start;
var inst_40020 = cljs.core.PersistentVector.EMPTY;
var inst_40021 = inst_40014;
var inst_40022 = inst_40018;
var inst_40023 = inst_40019;
var inst_40024 = inst_40020;
var state_40075__$1 = (function (){var statearr_40092 = state_40075;
(statearr_40092[(12)] = inst_40024);

(statearr_40092[(8)] = inst_40021);

(statearr_40092[(11)] = inst_40023);

(statearr_40092[(13)] = inst_40016);

(statearr_40092[(14)] = inst_40022);

(statearr_40092[(15)] = inst_40017);

return statearr_40092;
})();
var statearr_40093_40130 = state_40075__$1;
(statearr_40093_40130[(2)] = null);

(statearr_40093_40130[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (23))){
var inst_40024 = (state_40075[(12)]);
var inst_40023 = (state_40075[(11)]);
var inst_40031 = (state_40075[(10)]);
var inst_40056 = (state_40075[(16)]);
var inst_40022 = (state_40075[(14)]);
var inst_40057 = (state_40075[(17)]);
var inst_40062 = (state_40075[(2)]);
var inst_40063 = (inst_40022 + inst_40057);
var inst_40064 = (inst_40023 + inst_40062);
var inst_40065 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40024,inst_40056);
var inst_40021 = inst_40031;
var inst_40022__$1 = inst_40063;
var inst_40023__$1 = inst_40064;
var inst_40024__$1 = inst_40065;
var state_40075__$1 = (function (){var statearr_40094 = state_40075;
(statearr_40094[(12)] = inst_40024__$1);

(statearr_40094[(8)] = inst_40021);

(statearr_40094[(11)] = inst_40023__$1);

(statearr_40094[(14)] = inst_40022__$1);

return statearr_40094;
})();
var statearr_40095_40131 = state_40075__$1;
(statearr_40095_40131[(2)] = null);

(statearr_40095_40131[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (19))){
var inst_40056 = (state_40075[(16)]);
var inst_40057 = (state_40075[(17)]);
var inst_40056__$1 = (state_40075[(2)]);
var inst_40057__$1 = cljs.core.count(inst_40056__$1);
var inst_40058 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_40057__$1);
var state_40075__$1 = (function (){var statearr_40096 = state_40075;
(statearr_40096[(16)] = inst_40056__$1);

(statearr_40096[(17)] = inst_40057__$1);

return statearr_40096;
})();
if(inst_40058){
var statearr_40097_40132 = state_40075__$1;
(statearr_40097_40132[(1)] = (21));

} else {
var statearr_40098_40133 = state_40075__$1;
(statearr_40098_40133[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (11))){
var inst_40035 = (state_40075[(18)]);
var state_40075__$1 = state_40075;
var statearr_40100_40134 = state_40075__$1;
(statearr_40100_40134[(2)] = inst_40035);

(statearr_40100_40134[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (9))){
var inst_40035 = (state_40075[(18)]);
var inst_40022 = (state_40075[(14)]);
var inst_40035__$1 = (inst_40022 >= flake_limit);
var state_40075__$1 = (function (){var statearr_40101 = state_40075;
(statearr_40101[(18)] = inst_40035__$1);

return statearr_40101;
})();
if(cljs.core.truth_(inst_40035__$1)){
var statearr_40102_40135 = state_40075__$1;
(statearr_40102_40135[(1)] = (11));

} else {
var statearr_40103_40136 = state_40075__$1;
(statearr_40103_40136[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (5))){
var _ = (function (){var statearr_40104 = state_40075;
(statearr_40104[(4)] = cljs.core.rest((state_40075[(4)])));

return statearr_40104;
})();
var state_40075__$1 = state_40075;
var ex40099 = (state_40075__$1[(2)]);
var statearr_40105_40137 = state_40075__$1;
(statearr_40105_40137[(5)] = ex40099);


if((ex40099 instanceof Error)){
var statearr_40106_40138 = state_40075__$1;
(statearr_40106_40138[(1)] = (4));

(statearr_40106_40138[(5)] = null);

} else {
throw ex40099;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (14))){
var inst_40024 = (state_40075[(12)]);
var inst_40023 = (state_40075[(11)]);
var inst_40022 = (state_40075[(14)]);
var inst_40044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40045 = [inst_40022,inst_40023,inst_40024];
var inst_40046 = (new cljs.core.PersistentVector(null,3,(5),inst_40044,inst_40045,null));
var state_40075__$1 = state_40075;
var statearr_40107_40139 = state_40075__$1;
(statearr_40107_40139[(2)] = inst_40046);

(statearr_40107_40139[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (16))){
var inst_40068 = (state_40075[(2)]);
var state_40075__$1 = state_40075;
var statearr_40108_40140 = state_40075__$1;
(statearr_40108_40140[(2)] = inst_40068);

(statearr_40108_40140[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (10))){
var inst_40042 = (state_40075[(2)]);
var state_40075__$1 = state_40075;
if(cljs.core.truth_(inst_40042)){
var statearr_40109_40141 = state_40075__$1;
(statearr_40109_40141[(1)] = (14));

} else {
var statearr_40110_40142 = state_40075__$1;
(statearr_40110_40142[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (18))){
var inst_40030 = (state_40075[(7)]);
var state_40075__$1 = state_40075;
var statearr_40111_40143 = state_40075__$1;
(statearr_40111_40143[(2)] = inst_40030);

(statearr_40111_40143[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40076 === (8))){
var inst_40032 = (state_40075[(9)]);
var state_40075__$1 = state_40075;
var statearr_40112_40144 = state_40075__$1;
(statearr_40112_40144[(2)] = inst_40032);

(statearr_40112_40144[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__24298__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__24298__auto____0 = (function (){
var statearr_40113 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40113[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__24298__auto__);

(statearr_40113[(1)] = (1));

return statearr_40113;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__24298__auto____1 = (function (state_40075){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_40075);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e40114){var ex__24301__auto__ = e40114;
var statearr_40115_40145 = state_40075;
(statearr_40115_40145[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_40075[(4)]))){
var statearr_40116_40146 = state_40075;
(statearr_40116_40146[(1)] = cljs.core.first((state_40075[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__40147 = state_40075;
state_40075 = G__40147;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__24298__auto__ = function(state_40075){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__24298__auto____1.call(this,state_40075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__24298__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__24298__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_40117 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_40117[(6)] = c__24424__auto__);

return statearr_40117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_40193){
var state_val_40194 = (state_40193[(1)]);
if((state_val_40194 === (7))){
var state_40193__$1 = state_40193;
var statearr_40195_40233 = state_40193__$1;
(statearr_40195_40233[(2)] = null);

(statearr_40195_40233[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (20))){
var inst_40179 = (state_40193[(2)]);
var inst_40180 = fluree.db.util.async.throw_err(inst_40179);
var inst_40158 = inst_40180;
var state_40193__$1 = (function (){var statearr_40196 = state_40193;
(statearr_40196[(7)] = inst_40158);

return statearr_40196;
})();
var statearr_40197_40234 = state_40193__$1;
(statearr_40197_40234[(2)] = null);

(statearr_40197_40234[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (1))){
var state_40193__$1 = state_40193;
var statearr_40198_40235 = state_40193__$1;
(statearr_40198_40235[(2)] = null);

(statearr_40198_40235[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (4))){
var inst_40148 = (state_40193[(2)]);
var state_40193__$1 = state_40193;
var statearr_40199_40236 = state_40193__$1;
(statearr_40199_40236[(2)] = inst_40148);

(statearr_40199_40236[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (15))){
var inst_40175 = (state_40193[(8)]);
var inst_40158 = (state_40193[(7)]);
var inst_40175__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_40158);
var state_40193__$1 = (function (){var statearr_40200 = state_40193;
(statearr_40200[(8)] = inst_40175__$1);

return statearr_40200;
})();
if(cljs.core.truth_(inst_40175__$1)){
var statearr_40201_40237 = state_40193__$1;
(statearr_40201_40237[(1)] = (17));

} else {
var statearr_40202_40238 = state_40193__$1;
(statearr_40202_40238[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (13))){
var inst_40168 = (state_40193[(2)]);
var inst_40169 = fluree.db.util.async.throw_err(inst_40168);
var _ = (function (){var statearr_40203 = state_40193;
(statearr_40203[(4)] = cljs.core.rest((state_40193[(4)])));

return statearr_40203;
})();
var state_40193__$1 = state_40193;
var statearr_40204_40239 = state_40193__$1;
(statearr_40204_40239[(2)] = inst_40169);

(statearr_40204_40239[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (6))){
var inst_40156 = (state_40193[(2)]);
var inst_40157 = fluree.db.util.async.throw_err(inst_40156);
var inst_40158 = inst_40157;
var state_40193__$1 = (function (){var statearr_40205 = state_40193;
(statearr_40205[(7)] = inst_40158);

return statearr_40205;
})();
var statearr_40206_40240 = state_40193__$1;
(statearr_40206_40240[(2)] = null);

(statearr_40206_40240[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (17))){
var inst_40175 = (state_40193[(8)]);
var inst_40177 = fluree.db.dbproto._lookup_leaf(root_node,inst_40175);
var state_40193__$1 = state_40193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40193__$1,(20),inst_40177);
} else {
if((state_val_40194 === (3))){
var inst_40191 = (state_40193[(2)]);
var state_40193__$1 = state_40193;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40193__$1,inst_40191);
} else {
if((state_val_40194 === (12))){
var _ = (function (){var statearr_40208 = state_40193;
(statearr_40208[(4)] = cljs.core.rest((state_40193[(4)])));

return statearr_40208;
})();
var state_40193__$1 = state_40193;
var ex40207 = (state_40193__$1[(2)]);
var statearr_40209_40241 = state_40193__$1;
(statearr_40209_40241[(5)] = ex40207);


var statearr_40210_40242 = state_40193__$1;
(statearr_40210_40242[(1)] = (11));

(statearr_40210_40242[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (2))){
var _ = (function (){var statearr_40211 = state_40193;
(statearr_40211[(4)] = cljs.core.cons((5),(state_40193[(4)])));

return statearr_40211;
})();
var inst_40154 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_40193__$1 = state_40193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40193__$1,(6),inst_40154);
} else {
if((state_val_40194 === (19))){
var inst_40184 = (state_40193[(2)]);
var state_40193__$1 = state_40193;
var statearr_40212_40243 = state_40193__$1;
(statearr_40212_40243[(2)] = inst_40184);

(statearr_40212_40243[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (11))){
var inst_40160 = (state_40193[(2)]);
var state_40193__$1 = (function (){var statearr_40214 = state_40193;
(statearr_40214[(9)] = inst_40160);

return statearr_40214;
})();
var statearr_40215_40244 = state_40193__$1;
(statearr_40215_40244[(2)] = null);

(statearr_40215_40244[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (9))){
var inst_40158 = (state_40193[(7)]);
var _ = (function (){var statearr_40216 = state_40193;
(statearr_40216[(4)] = cljs.core.cons((12),(state_40193[(4)])));

return statearr_40216;
})();
var inst_40166 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_40158,t,novelty,fast_forward_db_QMARK_);
var state_40193__$1 = state_40193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40193__$1,(13),inst_40166);
} else {
if((state_val_40194 === (5))){
var _ = (function (){var statearr_40217 = state_40193;
(statearr_40217[(4)] = cljs.core.rest((state_40193[(4)])));

return statearr_40217;
})();
var state_40193__$1 = state_40193;
var ex40213 = (state_40193__$1[(2)]);
var statearr_40218_40245 = state_40193__$1;
(statearr_40218_40245[(5)] = ex40213);


if((ex40213 instanceof Error)){
var statearr_40219_40246 = state_40193__$1;
(statearr_40219_40246[(1)] = (4));

(statearr_40219_40246[(5)] = null);

} else {
throw ex40213;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (14))){
var inst_40172 = (state_40193[(10)]);
var state_40193__$1 = state_40193;
var statearr_40220_40247 = state_40193__$1;
(statearr_40220_40247[(2)] = inst_40172);

(statearr_40220_40247[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (16))){
var inst_40186 = (state_40193[(2)]);
var state_40193__$1 = state_40193;
var statearr_40221_40248 = state_40193__$1;
(statearr_40221_40248[(2)] = inst_40186);

(statearr_40221_40248[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (10))){
var inst_40172 = (state_40193[(10)]);
var inst_40172__$1 = (state_40193[(2)]);
var state_40193__$1 = (function (){var statearr_40222 = state_40193;
(statearr_40222[(10)] = inst_40172__$1);

return statearr_40222;
})();
if(cljs.core.truth_(inst_40172__$1)){
var statearr_40223_40249 = state_40193__$1;
(statearr_40223_40249[(1)] = (14));

} else {
var statearr_40224_40250 = state_40193__$1;
(statearr_40224_40250[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (18))){
var state_40193__$1 = state_40193;
var statearr_40225_40251 = state_40193__$1;
(statearr_40225_40251[(2)] = null);

(statearr_40225_40251[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40194 === (8))){
var inst_40188 = (state_40193[(2)]);
var _ = (function (){var statearr_40226 = state_40193;
(statearr_40226[(4)] = cljs.core.rest((state_40193[(4)])));

return statearr_40226;
})();
var state_40193__$1 = state_40193;
var statearr_40227_40252 = state_40193__$1;
(statearr_40227_40252[(2)] = inst_40188);

(statearr_40227_40252[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__24298__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__24298__auto____0 = (function (){
var statearr_40228 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40228[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__24298__auto__);

(statearr_40228[(1)] = (1));

return statearr_40228;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__24298__auto____1 = (function (state_40193){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_40193);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e40229){var ex__24301__auto__ = e40229;
var statearr_40230_40253 = state_40193;
(statearr_40230_40253[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_40193[(4)]))){
var statearr_40231_40254 = state_40193;
(statearr_40231_40254[(1)] = cljs.core.first((state_40193[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__40255 = state_40193;
state_40193 = G__40255;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__24298__auto__ = function(state_40193){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__24298__auto____1.call(this,state_40193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__24298__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__24298__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_40232 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_40232[(6)] = c__24424__auto__);

return statearr_40232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__40262 = arguments.length;
switch (G__40262) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__40263 = (function (){var pred__40266 = cljs.core.identical_QMARK_;
var expr__40267 = test;
if(cljs.core.truth_((pred__40266.cljs$core$IFn$_invoke$arity$2 ? pred__40266.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__40267) : pred__40266.call(null,cljs.core._EQ_,expr__40267)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__40266.cljs$core$IFn$_invoke$arity$2 ? pred__40266.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__40267) : pred__40266.call(null,cljs.core._LT_,expr__40267)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__40266.cljs$core$IFn$_invoke$arity$2 ? pred__40266.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__40267) : pred__40266.call(null,cljs.core._LT__EQ_,expr__40267)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__40266.cljs$core$IFn$_invoke$arity$2 ? pred__40266.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__40267) : pred__40266.call(null,cljs.core._GT_,expr__40267)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__40266.cljs$core$IFn$_invoke$arity$2 ? pred__40266.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__40267) : pred__40266.call(null,cljs.core._GT__EQ_,expr__40267)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__40267)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40263,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40263,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40263,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40263,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_40639){
var state_val_40640 = (state_40639[(1)]);
if((state_val_40640 === (121))){
var inst_40595 = (state_40639[(7)]);
var state_40639__$1 = state_40639;
var statearr_40641_40837 = state_40639__$1;
(statearr_40641_40837[(2)] = inst_40595);

(statearr_40641_40837[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (65))){
var inst_40447 = (state_40639[(8)]);
var inst_40453 = (state_40639[(2)]);
var state_40639__$1 = (function (){var statearr_40642 = state_40639;
(statearr_40642[(9)] = inst_40453);

return statearr_40642;
})();
if(cljs.core.truth_(inst_40447)){
var statearr_40643_40838 = state_40639__$1;
(statearr_40643_40838[(1)] = (66));

} else {
var statearr_40644_40839 = state_40639__$1;
(statearr_40644_40839[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (70))){
var inst_40631 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
var statearr_40645_40840 = state_40639__$1;
(statearr_40645_40840[(2)] = inst_40631);

(statearr_40645_40840[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (62))){
var inst_40446 = (state_40639[(2)]);
var inst_40447 = fluree.db.util.async.throw_err(inst_40446);
var inst_40448 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_40639__$1 = (function (){var statearr_40646 = state_40639;
(statearr_40646[(8)] = inst_40447);

return statearr_40646;
})();
if(cljs.core.truth_(inst_40448)){
var statearr_40647_40841 = state_40639__$1;
(statearr_40647_40841[(1)] = (63));

} else {
var statearr_40648_40842 = state_40639__$1;
(statearr_40648_40842[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (74))){
var inst_40433 = (state_40639[(10)]);
var inst_40289 = (state_40639[(11)]);
var inst_40305 = (state_40639[(12)]);
var inst_40427 = (state_40639[(13)]);
var inst_40294 = (state_40639[(14)]);
var inst_40438 = (state_40639[(15)]);
var inst_40316 = (state_40639[(16)]);
var inst_40370 = (state_40639[(17)]);
var inst_40358 = (state_40639[(18)]);
var inst_40361 = (state_40639[(19)]);
var inst_40428 = (state_40639[(20)]);
var inst_40458 = (state_40639[(21)]);
var inst_40379 = (state_40639[(22)]);
var inst_40443 = (state_40639[(23)]);
var inst_40426 = (state_40639[(24)]);
var inst_40296 = (state_40639[(25)]);
var inst_40417 = (state_40639[(26)]);
var inst_40357 = (state_40639[(27)]);
var inst_40457 = (state_40639[(28)]);
var inst_40474 = (state_40639[(29)]);
var inst_40459 = (state_40639[(30)]);
var inst_40420 = (state_40639[(31)]);
var inst_40406 = (state_40639[(32)]);
var inst_40447 = (state_40639[(8)]);
var inst_40432 = (state_40639[(33)]);
var inst_40453 = (state_40639[(9)]);
var inst_40300 = (state_40639[(34)]);
var inst_40419 = (state_40639[(35)]);
var inst_40397 = (state_40639[(36)]);
var inst_40456 = (state_40639[(37)]);
var inst_40388 = (state_40639[(38)]);
var inst_40304 = (state_40639[(39)]);
var inst_40325 = (state_40639[(40)]);
var inst_40460 = (state_40639[(41)]);
var inst_40415 = (state_40639[(42)]);
var inst_40437 = (state_40639[(43)]);
var inst_40416 = (state_40639[(44)]);
var inst_40466 = (state_40639[(45)]);
var inst_40306 = (state_40639[(46)]);
var inst_40293 = (state_40639[(47)]);
var inst_40301 = (state_40639[(48)]);
var inst_40476 = (function (){var no_filter_QMARK_ = inst_40453;
var vec__40278 = inst_40296;
var G__40467 = inst_40474;
var t = inst_40433;
var max_limit_QMARK_ = inst_40427;
var next_node = inst_40456;
var fast_forward_db_QMARK_ = inst_40438;
var s1 = inst_40316;
var o2 = inst_40379;
var t1 = inst_40293;
var predicate_fn = inst_40306;
var i = inst_40458;
var m1 = inst_40406;
var root_node = inst_40443;
var s2 = inst_40325;
var vec__40275 = inst_40289;
var p2 = inst_40397;
var vec__40282 = inst_40357;
var vec__40285 = inst_40358;
var permissions = inst_40428;
var limit = inst_40426;
var start_flake = inst_40416;
var flake_limit = inst_40420;
var offset = inst_40457;
var acc = inst_40460;
var t2 = inst_40300;
var op1 = inst_40294;
var o1 = inst_40370;
var end_flake = inst_40417;
var base_result = inst_40466;
var s = inst_40459;
var node_start = inst_40447;
var p1 = inst_40388;
var subject_fn = inst_40305;
var object_fn = inst_40361;
var idx_compare = inst_40432;
var map__40281 = inst_40304;
var op2 = inst_40301;
var m2 = inst_40415;
var map__40288 = inst_40419;
var novelty = inst_40437;
return (function (p1__40257_SHARP_){
var G__40649 = p1__40257_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__40649) : subject_fn.call(null,G__40649));
});
})();
var inst_40477 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_40476,inst_40474);
var state_40639__$1 = state_40639;
var statearr_40650_40843 = state_40639__$1;
(statearr_40650_40843[(2)] = inst_40477);

(statearr_40650_40843[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (110))){
var inst_40608 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
var statearr_40651_40844 = state_40639__$1;
(statearr_40651_40844[(2)] = inst_40608);

(statearr_40651_40844[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (7))){
var inst_40290 = (state_40639[(49)]);
var state_40639__$1 = state_40639;
var statearr_40652_40845 = state_40639__$1;
(statearr_40652_40845[(2)] = inst_40290);

(statearr_40652_40845[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (59))){
var state_40639__$1 = state_40639;
var statearr_40653_40846 = state_40639__$1;
(statearr_40653_40846[(2)] = fluree.db.util.core.max_long);

(statearr_40653_40846[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (86))){
var inst_40453 = (state_40639[(9)]);
var state_40639__$1 = state_40639;
var statearr_40654_40847 = state_40639__$1;
(statearr_40654_40847[(2)] = inst_40453);

(statearr_40654_40847[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (20))){
var state_40639__$1 = state_40639;
var statearr_40655_40848 = state_40639__$1;
(statearr_40655_40848[(2)] = null);

(statearr_40655_40848[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (72))){
var inst_40466 = (state_40639[(45)]);
var state_40639__$1 = state_40639;
var statearr_40656_40849 = state_40639__$1;
(statearr_40656_40849[(2)] = inst_40466);

(statearr_40656_40849[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (58))){
var inst_40421 = (state_40639[(50)]);
var state_40639__$1 = state_40639;
var statearr_40657_40850 = state_40639__$1;
(statearr_40657_40850[(2)] = inst_40421);

(statearr_40657_40850[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (60))){
var inst_40426 = (state_40639[(24)]);
var inst_40426__$1 = (state_40639[(2)]);
var inst_40427 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_40426__$1,fluree.db.util.core.max_long);
var inst_40428 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_40429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40430 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_40431 = (new cljs.core.PersistentVector(null,3,(5),inst_40429,inst_40430,null));
var inst_40432 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_40431);
var inst_40433 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_40434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40435 = [cljs.core.cst$kw$novelty,idx];
var inst_40436 = (new cljs.core.PersistentVector(null,2,(5),inst_40434,inst_40435,null));
var inst_40437 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_40436);
var inst_40438 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_40439 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_40440 = fluree.db.dbproto._resolve(inst_40439);
var state_40639__$1 = (function (){var statearr_40658 = state_40639;
(statearr_40658[(10)] = inst_40433);

(statearr_40658[(13)] = inst_40427);

(statearr_40658[(15)] = inst_40438);

(statearr_40658[(20)] = inst_40428);

(statearr_40658[(24)] = inst_40426__$1);

(statearr_40658[(33)] = inst_40432);

(statearr_40658[(43)] = inst_40437);

return statearr_40658;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40639__$1,(61),inst_40440);
} else {
if((state_val_40640 === (27))){
var inst_40359 = (state_40639[(51)]);
var state_40639__$1 = state_40639;
var statearr_40659_40851 = state_40639__$1;
(statearr_40659_40851[(2)] = inst_40359);

(statearr_40659_40851[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (1))){
var state_40639__$1 = state_40639;
var statearr_40660_40852 = state_40639__$1;
(statearr_40660_40852[(2)] = null);

(statearr_40660_40852[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (69))){
var inst_40417 = (state_40639[(26)]);
var inst_40456 = (state_40639[(37)]);
var inst_40416 = (state_40639[(44)]);
var inst_40465 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_40456);
var inst_40466 = fluree.db.flake.subrange(inst_40465,start_test,inst_40416,end_test,inst_40417);
var inst_40468 = fluree.db.query.range.value_with_nil_pred(idx,inst_40416,inst_40417);
var state_40639__$1 = (function (){var statearr_40661 = state_40639;
(statearr_40661[(45)] = inst_40466);

return statearr_40661;
})();
if(inst_40468){
var statearr_40662_40853 = state_40639__$1;
(statearr_40662_40853[(1)] = (71));

} else {
var statearr_40663_40854 = state_40639__$1;
(statearr_40663_40854[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (101))){
var inst_40420 = (state_40639[(31)]);
var inst_40554 = (state_40639[(52)]);
var inst_40553 = (state_40639[(53)]);
var inst_40552 = (state_40639[(54)]);
var inst_40557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40558 = (inst_40554 - inst_40420);
var inst_40559 = (inst_40553 - inst_40558);
var inst_40560 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_40559,inst_40552);
var inst_40561 = [inst_40420,inst_40560];
var inst_40562 = (new cljs.core.PersistentVector(null,2,(5),inst_40557,inst_40561,null));
var state_40639__$1 = state_40639;
var statearr_40664_40855 = state_40639__$1;
(statearr_40664_40855[(2)] = inst_40562);

(statearr_40664_40855[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (24))){
var inst_40289 = (state_40639[(11)]);
var inst_40305 = (state_40639[(12)]);
var inst_40294 = (state_40639[(14)]);
var inst_40316 = (state_40639[(16)]);
var inst_40295 = (state_40639[(55)]);
var inst_40296 = (state_40639[(25)]);
var inst_40291 = (state_40639[(56)]);
var inst_40302 = (state_40639[(57)]);
var inst_40300 = (state_40639[(34)]);
var inst_40299 = (state_40639[(58)]);
var inst_40304 = (state_40639[(39)]);
var inst_40325 = (state_40639[(40)]);
var inst_40307 = (state_40639[(59)]);
var inst_40298 = (state_40639[(60)]);
var inst_40292 = (state_40639[(61)]);
var inst_40339 = (state_40639[(62)]);
var inst_40306 = (state_40639[(46)]);
var inst_40293 = (state_40639[(47)]);
var inst_40301 = (state_40639[(48)]);
var inst_40349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40351 = [null,null];
var inst_40352 = (new cljs.core.PersistentVector(null,2,(5),inst_40350,inst_40351,null));
var inst_40353 = (function (){var bool = inst_40339;
var vec__40278 = inst_40296;
var s1 = inst_40316;
var o2 = inst_40299;
var t1 = inst_40293;
var predicate_fn = inst_40306;
var m1 = inst_40295;
var s2 = inst_40325;
var vec__40275 = inst_40289;
var p2 = inst_40298;
var t2 = inst_40300;
var op1 = inst_40294;
var o1 = inst_40292;
var p1 = inst_40291;
var subject_fn = inst_40305;
var object_fn = inst_40307;
var map__40281 = inst_40304;
var op2 = inst_40301;
var m2 = inst_40302;
var temp__5755__auto__ = inst_40339;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_40354 = [inst_40352,inst_40353];
var inst_40355 = (new cljs.core.PersistentVector(null,2,(5),inst_40349,inst_40354,null));
var state_40639__$1 = state_40639;
var statearr_40665_40856 = state_40639__$1;
(statearr_40665_40856[(2)] = inst_40355);

(statearr_40665_40856[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (102))){
var inst_40554 = (state_40639[(52)]);
var inst_40552 = (state_40639[(54)]);
var inst_40564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40565 = [inst_40554,inst_40552];
var inst_40566 = (new cljs.core.PersistentVector(null,2,(5),inst_40564,inst_40565,null));
var state_40639__$1 = state_40639;
var statearr_40666_40857 = state_40639__$1;
(statearr_40666_40857[(2)] = inst_40566);

(statearr_40666_40857[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (55))){
var state_40639__$1 = state_40639;
var statearr_40667_40858 = state_40639__$1;
(statearr_40667_40858[(2)] = (2147483647));

(statearr_40667_40858[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (85))){
var inst_40502 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
if(cljs.core.truth_(inst_40502)){
var statearr_40668_40859 = state_40639__$1;
(statearr_40668_40859[(1)] = (89));

} else {
var statearr_40669_40860 = state_40639__$1;
(statearr_40669_40860[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (39))){
var inst_40389 = (state_40639[(63)]);
var inst_40298 = (state_40639[(60)]);
var inst_40388 = (state_40639[(2)]);
var inst_40389__$1 = (inst_40298 == null);
var state_40639__$1 = (function (){var statearr_40670 = state_40639;
(statearr_40670[(63)] = inst_40389__$1);

(statearr_40670[(38)] = inst_40388);

return statearr_40670;
})();
if(cljs.core.truth_(inst_40389__$1)){
var statearr_40671_40861 = state_40639__$1;
(statearr_40671_40861[(1)] = (40));

} else {
var statearr_40672_40862 = state_40639__$1;
(statearr_40672_40862[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (88))){
var inst_40499 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
var statearr_40673_40863 = state_40639__$1;
(statearr_40673_40863[(2)] = inst_40499);

(statearr_40673_40863[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (46))){
var inst_40295 = (state_40639[(55)]);
var state_40639__$1 = state_40639;
var statearr_40674_40864 = state_40639__$1;
(statearr_40674_40864[(2)] = inst_40295);

(statearr_40674_40864[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (4))){
var inst_40269 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
var statearr_40675_40865 = state_40639__$1;
(statearr_40675_40865[(2)] = inst_40269);

(statearr_40675_40865[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (77))){
var inst_40433 = (state_40639[(10)]);
var inst_40289 = (state_40639[(11)]);
var inst_40305 = (state_40639[(12)]);
var inst_40427 = (state_40639[(13)]);
var inst_40294 = (state_40639[(14)]);
var inst_40438 = (state_40639[(15)]);
var inst_40316 = (state_40639[(16)]);
var inst_40370 = (state_40639[(17)]);
var inst_40358 = (state_40639[(18)]);
var inst_40361 = (state_40639[(19)]);
var inst_40428 = (state_40639[(20)]);
var inst_40458 = (state_40639[(21)]);
var inst_40379 = (state_40639[(22)]);
var inst_40443 = (state_40639[(23)]);
var inst_40426 = (state_40639[(24)]);
var inst_40296 = (state_40639[(25)]);
var inst_40417 = (state_40639[(26)]);
var inst_40357 = (state_40639[(27)]);
var inst_40457 = (state_40639[(28)]);
var inst_40459 = (state_40639[(30)]);
var inst_40420 = (state_40639[(31)]);
var inst_40406 = (state_40639[(32)]);
var inst_40480 = (state_40639[(64)]);
var inst_40447 = (state_40639[(8)]);
var inst_40432 = (state_40639[(33)]);
var inst_40453 = (state_40639[(9)]);
var inst_40300 = (state_40639[(34)]);
var inst_40419 = (state_40639[(35)]);
var inst_40397 = (state_40639[(36)]);
var inst_40456 = (state_40639[(37)]);
var inst_40388 = (state_40639[(38)]);
var inst_40304 = (state_40639[(39)]);
var inst_40325 = (state_40639[(40)]);
var inst_40460 = (state_40639[(41)]);
var inst_40415 = (state_40639[(42)]);
var inst_40437 = (state_40639[(43)]);
var inst_40416 = (state_40639[(44)]);
var inst_40466 = (state_40639[(45)]);
var inst_40306 = (state_40639[(46)]);
var inst_40293 = (state_40639[(47)]);
var inst_40301 = (state_40639[(48)]);
var inst_40482 = (function (){var no_filter_QMARK_ = inst_40453;
var vec__40278 = inst_40296;
var G__40467 = inst_40480;
var t = inst_40433;
var max_limit_QMARK_ = inst_40427;
var next_node = inst_40456;
var fast_forward_db_QMARK_ = inst_40438;
var s1 = inst_40316;
var o2 = inst_40379;
var t1 = inst_40293;
var predicate_fn = inst_40306;
var i = inst_40458;
var m1 = inst_40406;
var root_node = inst_40443;
var s2 = inst_40325;
var vec__40275 = inst_40289;
var p2 = inst_40397;
var vec__40282 = inst_40357;
var vec__40285 = inst_40358;
var permissions = inst_40428;
var limit = inst_40426;
var start_flake = inst_40416;
var flake_limit = inst_40420;
var offset = inst_40457;
var acc = inst_40460;
var t2 = inst_40300;
var op1 = inst_40294;
var o1 = inst_40370;
var end_flake = inst_40417;
var base_result = inst_40466;
var s = inst_40459;
var node_start = inst_40447;
var p1 = inst_40388;
var subject_fn = inst_40305;
var object_fn = inst_40361;
var idx_compare = inst_40432;
var map__40281 = inst_40304;
var op2 = inst_40301;
var m2 = inst_40415;
var map__40288 = inst_40419;
var novelty = inst_40437;
return (function (p1__40258_SHARP_){
var G__40676 = p1__40258_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__40676) : predicate_fn.call(null,G__40676));
});
})();
var inst_40483 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_40482,inst_40480);
var state_40639__$1 = state_40639;
var statearr_40677_40866 = state_40639__$1;
(statearr_40677_40866[(2)] = inst_40483);

(statearr_40677_40866[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (106))){
var inst_40493 = (state_40639[(65)]);
var state_40639__$1 = state_40639;
var statearr_40678_40867 = state_40639__$1;
(statearr_40678_40867[(2)] = inst_40493);

(statearr_40678_40867[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (119))){
var inst_40611 = (state_40639[(66)]);
var state_40639__$1 = state_40639;
var statearr_40679_40868 = state_40639__$1;
(statearr_40679_40868[(2)] = inst_40611);

(statearr_40679_40868[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (95))){
var inst_40536 = (state_40639[(67)]);
var inst_40426 = (state_40639[(24)]);
var inst_40459 = (state_40639[(30)]);
var inst_40526 = (state_40639[(68)]);
var inst_40535 = (state_40639[(69)]);
var inst_40534 = (state_40639[(70)]);
var inst_40534__$1 = cljs.core.count(inst_40526);
var inst_40535__$1 = (inst_40459 + inst_40534__$1);
var inst_40536__$1 = (inst_40535__$1 - inst_40426);
var inst_40537 = cljs.core.pos_int_QMARK_(inst_40536__$1);
var state_40639__$1 = (function (){var statearr_40680 = state_40639;
(statearr_40680[(67)] = inst_40536__$1);

(statearr_40680[(69)] = inst_40535__$1);

(statearr_40680[(70)] = inst_40534__$1);

return statearr_40680;
})();
if(inst_40537){
var statearr_40681_40869 = state_40639__$1;
(statearr_40681_40869[(1)] = (98));

} else {
var statearr_40682_40870 = state_40639__$1;
(statearr_40682_40870[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (54))){
var inst_40294 = (state_40639[(14)]);
var inst_40316 = (state_40639[(16)]);
var inst_40370 = (state_40639[(17)]);
var inst_40379 = (state_40639[(22)]);
var inst_40406 = (state_40639[(32)]);
var inst_40300 = (state_40639[(34)]);
var inst_40419 = (state_40639[(35)]);
var inst_40397 = (state_40639[(36)]);
var inst_40388 = (state_40639[(38)]);
var inst_40325 = (state_40639[(40)]);
var inst_40421 = (state_40639[(50)]);
var inst_40415 = (state_40639[(42)]);
var inst_40293 = (state_40639[(47)]);
var inst_40301 = (state_40639[(48)]);
var inst_40415__$1 = (state_40639[(2)]);
var inst_40416 = fluree.db.flake.__GT_Flake(inst_40316,inst_40388,inst_40370,inst_40293,inst_40294,inst_40406);
var inst_40417 = fluree.db.flake.__GT_Flake(inst_40325,inst_40397,inst_40379,inst_40300,inst_40301,inst_40415__$1);
var inst_40418 = opts;
var inst_40419__$1 = cljs.core.__destructure_map(inst_40418);
var inst_40420 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_40419__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_40421__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40419__$1,cljs.core.cst$kw$limit);
var inst_40422 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_40419__$1,cljs.core.cst$kw$offset,(0));
var state_40639__$1 = (function (){var statearr_40683 = state_40639;
(statearr_40683[(26)] = inst_40417);

(statearr_40683[(31)] = inst_40420);

(statearr_40683[(35)] = inst_40419__$1);

(statearr_40683[(71)] = inst_40422);

(statearr_40683[(50)] = inst_40421__$1);

(statearr_40683[(42)] = inst_40415__$1);

(statearr_40683[(44)] = inst_40416);

return statearr_40683;
})();
if(cljs.core.truth_(inst_40421__$1)){
var statearr_40684_40871 = state_40639__$1;
(statearr_40684_40871[(1)] = (58));

} else {
var statearr_40685_40872 = state_40639__$1;
(statearr_40685_40872[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (92))){
var inst_40515 = (state_40639[(72)]);
var inst_40458 = (state_40639[(21)]);
var inst_40457 = (state_40639[(28)]);
var inst_40459 = (state_40639[(30)]);
var inst_40460 = (state_40639[(41)]);
var inst_40518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40519 = (inst_40457 - inst_40515);
var inst_40520 = [inst_40519,inst_40458,inst_40459,inst_40460];
var inst_40521 = (new cljs.core.PersistentVector(null,4,(5),inst_40518,inst_40520,null));
var state_40639__$1 = state_40639;
var statearr_40686_40873 = state_40639__$1;
(statearr_40686_40873[(2)] = inst_40521);

(statearr_40686_40873[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (104))){
var inst_40577 = (state_40639[(2)]);
var inst_40578 = fluree.db.util.async.throw_err(inst_40577);
var state_40639__$1 = state_40639;
var statearr_40687_40874 = state_40639__$1;
(statearr_40687_40874[(2)] = inst_40578);

(statearr_40687_40874[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (15))){
var inst_40299 = (state_40639[(58)]);
var inst_40329 = cljs.core.boolean_QMARK_(inst_40299);
var state_40639__$1 = state_40639;
if(inst_40329){
var statearr_40688_40875 = state_40639__$1;
(statearr_40688_40875[(1)] = (17));

} else {
var statearr_40689_40876 = state_40639__$1;
(statearr_40689_40876[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (48))){
var inst_40302 = (state_40639[(57)]);
var inst_40406 = (state_40639[(2)]);
var state_40639__$1 = (function (){var statearr_40690 = state_40639;
(statearr_40690[(32)] = inst_40406);

return statearr_40690;
})();
if(cljs.core.truth_(inst_40302)){
var statearr_40691_40877 = state_40639__$1;
(statearr_40691_40877[(1)] = (52));

} else {
var statearr_40692_40878 = state_40639__$1;
(statearr_40692_40878[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (50))){
var state_40639__$1 = state_40639;
var statearr_40693_40879 = state_40639__$1;
(statearr_40693_40879[(2)] = (2147483647));

(statearr_40693_40879[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (116))){
var inst_40611 = (state_40639[(66)]);
var inst_40619 = (state_40639[(2)]);
var state_40639__$1 = (function (){var statearr_40694 = state_40639;
(statearr_40694[(73)] = inst_40619);

return statearr_40694;
})();
if(cljs.core.truth_(inst_40611)){
var statearr_40695_40880 = state_40639__$1;
(statearr_40695_40880[(1)] = (118));

} else {
var statearr_40696_40881 = state_40639__$1;
(statearr_40696_40881[(1)] = (119));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (75))){
var inst_40474 = (state_40639[(29)]);
var state_40639__$1 = state_40639;
var statearr_40697_40882 = state_40639__$1;
(statearr_40697_40882[(2)] = inst_40474);

(statearr_40697_40882[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (99))){
var inst_40535 = (state_40639[(69)]);
var inst_40544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40545 = [inst_40535,inst_40535];
var inst_40546 = (new cljs.core.PersistentVector(null,2,(5),inst_40544,inst_40545,null));
var state_40639__$1 = state_40639;
var statearr_40698_40883 = state_40639__$1;
(statearr_40698_40883[(2)] = inst_40546);

(statearr_40698_40883[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (21))){
var state_40639__$1 = state_40639;
var statearr_40699_40884 = state_40639__$1;
(statearr_40699_40884[(2)] = null);

(statearr_40699_40884[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (31))){
var inst_40360 = (state_40639[(74)]);
var state_40639__$1 = state_40639;
var statearr_40700_40885 = state_40639__$1;
(statearr_40700_40885[(2)] = inst_40360);

(statearr_40700_40885[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (113))){
var inst_40605 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
var statearr_40701_40886 = state_40639__$1;
(statearr_40701_40886[(2)] = inst_40605);

(statearr_40701_40886[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (32))){
var inst_40291 = (state_40639[(56)]);
var inst_40380 = (state_40639[(75)]);
var inst_40379 = (state_40639[(2)]);
var inst_40380__$1 = (inst_40291 == null);
var state_40639__$1 = (function (){var statearr_40702 = state_40639;
(statearr_40702[(22)] = inst_40379);

(statearr_40702[(75)] = inst_40380__$1);

return statearr_40702;
})();
if(cljs.core.truth_(inst_40380__$1)){
var statearr_40703_40887 = state_40639__$1;
(statearr_40703_40887[(1)] = (34));

} else {
var statearr_40704_40888 = state_40639__$1;
(statearr_40704_40888[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (40))){
var inst_40379 = (state_40639[(22)]);
var state_40639__$1 = state_40639;
var statearr_40705_40889 = state_40639__$1;
(statearr_40705_40889[(2)] = inst_40379);

(statearr_40705_40889[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (91))){
var inst_40493 = (state_40639[(65)]);
var inst_40591 = (state_40639[(2)]);
var inst_40592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40591,(0),null);
var inst_40593 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40591,(1),null);
var inst_40594 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40591,(2),null);
var inst_40595 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40591,(3),null);
var state_40639__$1 = (function (){var statearr_40706 = state_40639;
(statearr_40706[(76)] = inst_40592);

(statearr_40706[(7)] = inst_40595);

(statearr_40706[(77)] = inst_40594);

(statearr_40706[(78)] = inst_40593);

return statearr_40706;
})();
if(cljs.core.truth_(inst_40493)){
var statearr_40707_40890 = state_40639__$1;
(statearr_40707_40890[(1)] = (105));

} else {
var statearr_40708_40891 = state_40639__$1;
(statearr_40708_40891[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (117))){
var inst_40615 = (state_40639[(2)]);
var inst_40616 = fluree.db.util.async.throw_err(inst_40615);
var state_40639__$1 = state_40639;
var statearr_40709_40892 = state_40639__$1;
(statearr_40709_40892[(2)] = inst_40616);

(statearr_40709_40892[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (108))){
var inst_40420 = (state_40639[(31)]);
var inst_40600 = (state_40639[(79)]);
var inst_40593 = (state_40639[(78)]);
var inst_40600__$1 = (inst_40593 < inst_40420);
var state_40639__$1 = (function (){var statearr_40710 = state_40639;
(statearr_40710[(79)] = inst_40600__$1);

return statearr_40710;
})();
if(cljs.core.truth_(inst_40600__$1)){
var statearr_40711_40893 = state_40639__$1;
(statearr_40711_40893[(1)] = (111));

} else {
var statearr_40712_40894 = state_40639__$1;
(statearr_40712_40894[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (56))){
var state_40639__$1 = state_40639;
var statearr_40713_40895 = state_40639__$1;
(statearr_40713_40895[(2)] = fluree.db.util.core.min_integer);

(statearr_40713_40895[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (33))){
var inst_40375 = (state_40639[(2)]);
var inst_40376 = fluree.db.util.async.throw_err(inst_40375);
var state_40639__$1 = state_40639;
var statearr_40714_40896 = state_40639__$1;
(statearr_40714_40896[(2)] = inst_40376);

(statearr_40714_40896[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (13))){
var inst_40321 = (state_40639[(2)]);
var inst_40322 = fluree.db.util.async.throw_err(inst_40321);
var state_40639__$1 = state_40639;
var statearr_40715_40897 = state_40639__$1;
(statearr_40715_40897[(2)] = inst_40322);

(statearr_40715_40897[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (22))){
var inst_40335 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
var statearr_40716_40898 = state_40639__$1;
(statearr_40716_40898[(2)] = inst_40335);

(statearr_40716_40898[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (90))){
var inst_40433 = (state_40639[(10)]);
var inst_40289 = (state_40639[(11)]);
var inst_40305 = (state_40639[(12)]);
var inst_40427 = (state_40639[(13)]);
var inst_40294 = (state_40639[(14)]);
var inst_40438 = (state_40639[(15)]);
var inst_40515 = (state_40639[(72)]);
var inst_40316 = (state_40639[(16)]);
var inst_40370 = (state_40639[(17)]);
var inst_40358 = (state_40639[(18)]);
var inst_40361 = (state_40639[(19)]);
var inst_40428 = (state_40639[(20)]);
var inst_40458 = (state_40639[(21)]);
var inst_40379 = (state_40639[(22)]);
var inst_40443 = (state_40639[(23)]);
var inst_40426 = (state_40639[(24)]);
var inst_40296 = (state_40639[(25)]);
var inst_40417 = (state_40639[(26)]);
var inst_40357 = (state_40639[(27)]);
var inst_40493 = (state_40639[(65)]);
var inst_40514 = (state_40639[(80)]);
var inst_40457 = (state_40639[(28)]);
var inst_40459 = (state_40639[(30)]);
var inst_40420 = (state_40639[(31)]);
var inst_40406 = (state_40639[(32)]);
var inst_40447 = (state_40639[(8)]);
var inst_40432 = (state_40639[(33)]);
var inst_40453 = (state_40639[(9)]);
var inst_40300 = (state_40639[(34)]);
var inst_40419 = (state_40639[(35)]);
var inst_40397 = (state_40639[(36)]);
var inst_40456 = (state_40639[(37)]);
var inst_40388 = (state_40639[(38)]);
var inst_40304 = (state_40639[(39)]);
var inst_40325 = (state_40639[(40)]);
var inst_40460 = (state_40639[(41)]);
var inst_40492 = (state_40639[(81)]);
var inst_40415 = (state_40639[(42)]);
var inst_40437 = (state_40639[(43)]);
var inst_40416 = (state_40639[(44)]);
var inst_40466 = (state_40639[(45)]);
var inst_40306 = (state_40639[(46)]);
var inst_40293 = (state_40639[(47)]);
var inst_40301 = (state_40639[(48)]);
var inst_40513 = (function (){var no_filter_QMARK_ = inst_40453;
var vec__40278 = inst_40296;
var base_result_SINGLEQUOTE_ = inst_40492;
var t = inst_40433;
var max_limit_QMARK_ = inst_40427;
var next_node = inst_40456;
var fast_forward_db_QMARK_ = inst_40438;
var s1 = inst_40316;
var o2 = inst_40379;
var t1 = inst_40293;
var predicate_fn = inst_40306;
var i = inst_40458;
var rhs = inst_40493;
var m1 = inst_40406;
var root_node = inst_40443;
var s2 = inst_40325;
var vec__40275 = inst_40289;
var p2 = inst_40397;
var vec__40282 = inst_40357;
var vec__40285 = inst_40358;
var permissions = inst_40428;
var limit = inst_40426;
var start_flake = inst_40416;
var flake_limit = inst_40420;
var offset = inst_40457;
var acc = inst_40460;
var t2 = inst_40300;
var op1 = inst_40294;
var o1 = inst_40370;
var end_flake = inst_40417;
var base_result = inst_40466;
var s = inst_40459;
var node_start = inst_40447;
var p1 = inst_40388;
var subject_fn = inst_40305;
var object_fn = inst_40361;
var idx_compare = inst_40432;
var map__40281 = inst_40304;
var op2 = inst_40301;
var m2 = inst_40415;
var map__40288 = inst_40419;
var novelty = inst_40437;
return (function (p1__40260_SHARP_){
return p1__40260_SHARP_.s;
});
})();
var inst_40514__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_40513,inst_40492);
var inst_40515__$1 = cljs.core.count(inst_40514__$1);
var inst_40516 = (inst_40457 > inst_40515__$1);
var state_40639__$1 = (function (){var statearr_40717 = state_40639;
(statearr_40717[(72)] = inst_40515__$1);

(statearr_40717[(80)] = inst_40514__$1);

return statearr_40717;
})();
if(cljs.core.truth_(inst_40516)){
var statearr_40718_40899 = state_40639__$1;
(statearr_40718_40899[(1)] = (92));

} else {
var statearr_40719_40900 = state_40639__$1;
(statearr_40719_40900[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (109))){
var inst_40598 = (state_40639[(82)]);
var state_40639__$1 = state_40639;
var statearr_40720_40901 = state_40639__$1;
(statearr_40720_40901[(2)] = inst_40598);

(statearr_40720_40901[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (36))){
var inst_40384 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
if(cljs.core.truth_(inst_40384)){
var statearr_40721_40902 = state_40639__$1;
(statearr_40721_40902[(1)] = (37));

} else {
var statearr_40722_40903 = state_40639__$1;
(statearr_40722_40903[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (41))){
var inst_40389 = (state_40639[(63)]);
var state_40639__$1 = state_40639;
var statearr_40723_40904 = state_40639__$1;
(statearr_40723_40904[(2)] = inst_40389);

(statearr_40723_40904[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (118))){
var inst_40619 = (state_40639[(73)]);
var state_40639__$1 = state_40639;
var statearr_40724_40905 = state_40639__$1;
(statearr_40724_40905[(2)] = inst_40619);

(statearr_40724_40905[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (89))){
var inst_40458 = (state_40639[(21)]);
var inst_40459 = (state_40639[(30)]);
var inst_40420 = (state_40639[(31)]);
var inst_40460 = (state_40639[(41)]);
var inst_40492 = (state_40639[(81)]);
var inst_40504 = cljs.core.count(inst_40492);
var inst_40505 = (inst_40420 - inst_40458);
var inst_40506 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_40505,inst_40492);
var inst_40507 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40460,inst_40506);
var inst_40508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40509 = (inst_40458 + inst_40504);
var inst_40510 = [(0),inst_40509,inst_40459,inst_40507];
var inst_40511 = (new cljs.core.PersistentVector(null,4,(5),inst_40508,inst_40510,null));
var state_40639__$1 = state_40639;
var statearr_40725_40906 = state_40639__$1;
(statearr_40725_40906[(2)] = inst_40511);

(statearr_40725_40906[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (100))){
var inst_40458 = (state_40639[(21)]);
var inst_40420 = (state_40639[(31)]);
var inst_40554 = (state_40639[(52)]);
var inst_40526 = (state_40639[(68)]);
var inst_40553 = (state_40639[(53)]);
var inst_40552 = (state_40639[(54)]);
var inst_40548 = (state_40639[(2)]);
var inst_40549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40548,(0),null);
var inst_40550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40548,(1),null);
var inst_40551 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_40550,inst_40526);
var inst_40552__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_40551);
var inst_40553__$1 = cljs.core.count(inst_40552__$1);
var inst_40554__$1 = (inst_40458 + inst_40553__$1);
var inst_40555 = (inst_40554__$1 > inst_40420);
var state_40639__$1 = (function (){var statearr_40726 = state_40639;
(statearr_40726[(52)] = inst_40554__$1);

(statearr_40726[(83)] = inst_40549);

(statearr_40726[(53)] = inst_40553__$1);

(statearr_40726[(54)] = inst_40552__$1);

return statearr_40726;
})();
if(cljs.core.truth_(inst_40555)){
var statearr_40727_40907 = state_40639__$1;
(statearr_40727_40907[(1)] = (101));

} else {
var statearr_40728_40908 = state_40639__$1;
(statearr_40728_40908[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (122))){
var inst_40592 = (state_40639[(76)]);
var inst_40619 = (state_40639[(73)]);
var inst_40595 = (state_40639[(7)]);
var inst_40594 = (state_40639[(77)]);
var inst_40593 = (state_40639[(78)]);
var inst_40456 = inst_40619;
var inst_40457 = inst_40592;
var inst_40458 = inst_40593;
var inst_40459 = inst_40594;
var inst_40460 = inst_40595;
var state_40639__$1 = (function (){var statearr_40729 = state_40639;
(statearr_40729[(21)] = inst_40458);

(statearr_40729[(28)] = inst_40457);

(statearr_40729[(30)] = inst_40459);

(statearr_40729[(37)] = inst_40456);

(statearr_40729[(41)] = inst_40460);

return statearr_40729;
})();
var statearr_40730_40909 = state_40639__$1;
(statearr_40730_40909[(2)] = null);

(statearr_40730_40909[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (43))){
var state_40639__$1 = state_40639;
var statearr_40731_40910 = state_40639__$1;
(statearr_40731_40910[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_40731_40910[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (61))){
var inst_40433 = (state_40639[(10)]);
var inst_40438 = (state_40639[(15)]);
var inst_40443 = (state_40639[(23)]);
var inst_40437 = (state_40639[(43)]);
var inst_40416 = (state_40639[(44)]);
var inst_40442 = (state_40639[(2)]);
var inst_40443__$1 = fluree.db.util.async.throw_err(inst_40442);
var inst_40444 = fluree.db.query.range.find_next_valid_node(inst_40443__$1,inst_40416,inst_40433,inst_40437,inst_40438);
var state_40639__$1 = (function (){var statearr_40732 = state_40639;
(statearr_40732[(23)] = inst_40443__$1);

return statearr_40732;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40639__$1,(62),inst_40444);
} else {
if((state_val_40640 === (29))){
var inst_40366 = (state_40639[(2)]);
var inst_40367 = fluree.db.util.async.throw_err(inst_40366);
var state_40639__$1 = state_40639;
var statearr_40733_40911 = state_40639__$1;
(statearr_40733_40911[(2)] = inst_40367);

(statearr_40733_40911[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (44))){
var inst_40298 = (state_40639[(60)]);
var state_40639__$1 = state_40639;
var statearr_40734_40912 = state_40639__$1;
(statearr_40734_40912[(2)] = inst_40298);

(statearr_40734_40912[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (93))){
var inst_40514 = (state_40639[(80)]);
var inst_40457 = (state_40639[(28)]);
var inst_40453 = (state_40639[(9)]);
var inst_40526 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_40457,inst_40514);
var state_40639__$1 = (function (){var statearr_40735 = state_40639;
(statearr_40735[(68)] = inst_40526);

return statearr_40735;
})();
if(cljs.core.truth_(inst_40453)){
var statearr_40736_40913 = state_40639__$1;
(statearr_40736_40913[(1)] = (95));

} else {
var statearr_40737_40914 = state_40639__$1;
(statearr_40737_40914[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (6))){
var inst_40290 = (state_40639[(49)]);
var inst_40310 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_40290);
var state_40639__$1 = state_40639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40639__$1,(9),inst_40310);
} else {
if((state_val_40640 === (111))){
var inst_40426 = (state_40639[(24)]);
var inst_40594 = (state_40639[(77)]);
var inst_40602 = (inst_40594 < inst_40426);
var state_40639__$1 = state_40639;
var statearr_40738_40915 = state_40639__$1;
(statearr_40738_40915[(2)] = inst_40602);

(statearr_40738_40915[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (28))){
var inst_40360 = (state_40639[(74)]);
var inst_40370 = (state_40639[(2)]);
var inst_40371 = fluree.db.util.core.pred_ident_QMARK_(inst_40360);
var state_40639__$1 = (function (){var statearr_40739 = state_40639;
(statearr_40739[(17)] = inst_40370);

return statearr_40739;
})();
if(inst_40371){
var statearr_40740_40916 = state_40639__$1;
(statearr_40740_40916[(1)] = (30));

} else {
var statearr_40741_40917 = state_40639__$1;
(statearr_40741_40917[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (64))){
var state_40639__$1 = state_40639;
var statearr_40742_40918 = state_40639__$1;
(statearr_40742_40918[(2)] = true);

(statearr_40742_40918[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (103))){
var inst_40549 = (state_40639[(83)]);
var inst_40568 = (state_40639[(2)]);
var inst_40569 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40568,(0),null);
var inst_40570 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40568,(1),null);
var inst_40571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40572 = [inst_40569,inst_40549,inst_40570];
var inst_40573 = (new cljs.core.PersistentVector(null,3,(5),inst_40571,inst_40572,null));
var state_40639__$1 = state_40639;
var statearr_40743_40919 = state_40639__$1;
(statearr_40743_40919[(2)] = inst_40573);

(statearr_40743_40919[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (51))){
var inst_40404 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
var statearr_40744_40920 = state_40639__$1;
(statearr_40744_40920[(2)] = inst_40404);

(statearr_40744_40920[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (25))){
var inst_40358 = (state_40639[(18)]);
var inst_40357 = (state_40639[(27)]);
var inst_40359 = (state_40639[(51)]);
var inst_40357__$1 = (state_40639[(2)]);
var inst_40358__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40357__$1,(0),null);
var inst_40359__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40358__$1,(0),null);
var inst_40360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40358__$1,(1),null);
var inst_40361 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40357__$1,(1),null);
var inst_40362 = fluree.db.util.core.pred_ident_QMARK_(inst_40359__$1);
var state_40639__$1 = (function (){var statearr_40745 = state_40639;
(statearr_40745[(18)] = inst_40358__$1);

(statearr_40745[(19)] = inst_40361);

(statearr_40745[(74)] = inst_40360);

(statearr_40745[(27)] = inst_40357__$1);

(statearr_40745[(51)] = inst_40359__$1);

return statearr_40745;
})();
if(inst_40362){
var statearr_40746_40921 = state_40639__$1;
(statearr_40746_40921[(1)] = (26));

} else {
var statearr_40747_40922 = state_40639__$1;
(statearr_40747_40922[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (34))){
var inst_40370 = (state_40639[(17)]);
var state_40639__$1 = state_40639;
var statearr_40748_40923 = state_40639__$1;
(statearr_40748_40923[(2)] = inst_40370);

(statearr_40748_40923[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (17))){
var inst_40299 = (state_40639[(58)]);
var state_40639__$1 = state_40639;
var statearr_40749_40924 = state_40639__$1;
(statearr_40749_40924[(2)] = inst_40299);

(statearr_40749_40924[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (3))){
var inst_40637 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40639__$1,inst_40637);
} else {
if((state_val_40640 === (12))){
var inst_40292 = (state_40639[(61)]);
var inst_40325 = (state_40639[(2)]);
var inst_40326 = cljs.core.boolean_QMARK_(inst_40292);
var state_40639__$1 = (function (){var statearr_40750 = state_40639;
(statearr_40750[(40)] = inst_40325);

return statearr_40750;
})();
if(inst_40326){
var statearr_40751_40925 = state_40639__$1;
(statearr_40751_40925[(1)] = (14));

} else {
var statearr_40752_40926 = state_40639__$1;
(statearr_40752_40926[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (2))){
var inst_40289 = (state_40639[(11)]);
var inst_40290 = (state_40639[(49)]);
var inst_40296 = (state_40639[(25)]);
var inst_40304 = (state_40639[(39)]);
var _ = (function (){var statearr_40753 = state_40639;
(statearr_40753[(4)] = cljs.core.cons((5),(state_40639[(4)])));

return statearr_40753;
})();
var inst_40289__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_40290__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40289__$1,(0),null);
var inst_40291 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40289__$1,(1),null);
var inst_40292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40289__$1,(2),null);
var inst_40293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40289__$1,(3),null);
var inst_40294 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40289__$1,(4),null);
var inst_40295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40289__$1,(5),null);
var inst_40296__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_40297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40296__$1,(0),null);
var inst_40298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40296__$1,(1),null);
var inst_40299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40296__$1,(2),null);
var inst_40300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40296__$1,(3),null);
var inst_40301 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40296__$1,(4),null);
var inst_40302 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40296__$1,(5),null);
var inst_40303 = opts;
var inst_40304__$1 = cljs.core.__destructure_map(inst_40303);
var inst_40305 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40304__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_40306 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40304__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_40307 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40304__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_40308 = fluree.db.util.core.pred_ident_QMARK_(inst_40290__$1);
var state_40639__$1 = (function (){var statearr_40754 = state_40639;
(statearr_40754[(11)] = inst_40289__$1);

(statearr_40754[(12)] = inst_40305);

(statearr_40754[(14)] = inst_40294);

(statearr_40754[(49)] = inst_40290__$1);

(statearr_40754[(55)] = inst_40295);

(statearr_40754[(25)] = inst_40296__$1);

(statearr_40754[(84)] = inst_40297);

(statearr_40754[(56)] = inst_40291);

(statearr_40754[(57)] = inst_40302);

(statearr_40754[(34)] = inst_40300);

(statearr_40754[(58)] = inst_40299);

(statearr_40754[(39)] = inst_40304__$1);

(statearr_40754[(59)] = inst_40307);

(statearr_40754[(60)] = inst_40298);

(statearr_40754[(61)] = inst_40292);

(statearr_40754[(46)] = inst_40306);

(statearr_40754[(47)] = inst_40293);

(statearr_40754[(48)] = inst_40301);

return statearr_40754;
})();
if(inst_40308){
var statearr_40755_40927 = state_40639__$1;
(statearr_40755_40927[(1)] = (6));

} else {
var statearr_40756_40928 = state_40639__$1;
(statearr_40756_40928[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (66))){
var inst_40447 = (state_40639[(8)]);
var inst_40422 = (state_40639[(71)]);
var inst_40455 = cljs.core.PersistentVector.EMPTY;
var inst_40456 = inst_40447;
var inst_40457 = inst_40422;
var inst_40458 = (0);
var inst_40459 = (0);
var inst_40460 = inst_40455;
var state_40639__$1 = (function (){var statearr_40757 = state_40639;
(statearr_40757[(21)] = inst_40458);

(statearr_40757[(28)] = inst_40457);

(statearr_40757[(30)] = inst_40459);

(statearr_40757[(37)] = inst_40456);

(statearr_40757[(41)] = inst_40460);

return statearr_40757;
})();
var statearr_40758_40929 = state_40639__$1;
(statearr_40758_40929[(2)] = null);

(statearr_40758_40929[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (107))){
var inst_40611 = (state_40639[(66)]);
var inst_40611__$1 = (state_40639[(2)]);
var state_40639__$1 = (function (){var statearr_40759 = state_40639;
(statearr_40759[(66)] = inst_40611__$1);

return statearr_40759;
})();
if(cljs.core.truth_(inst_40611__$1)){
var statearr_40760_40930 = state_40639__$1;
(statearr_40760_40930[(1)] = (114));

} else {
var statearr_40761_40931 = state_40639__$1;
(statearr_40761_40931[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (23))){
var inst_40299 = (state_40639[(58)]);
var inst_40307 = (state_40639[(59)]);
var inst_40292 = (state_40639[(61)]);
var inst_40342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40344 = [inst_40292,inst_40299];
var inst_40345 = (new cljs.core.PersistentVector(null,2,(5),inst_40343,inst_40344,null));
var inst_40346 = [inst_40345,inst_40307];
var inst_40347 = (new cljs.core.PersistentVector(null,2,(5),inst_40342,inst_40346,null));
var state_40639__$1 = state_40639;
var statearr_40762_40932 = state_40639__$1;
(statearr_40762_40932[(2)] = inst_40347);

(statearr_40762_40932[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (47))){
var inst_40400 = (cljs.core._GT__EQ_ === start_test);
var state_40639__$1 = state_40639;
if(cljs.core.truth_(inst_40400)){
var statearr_40763_40933 = state_40639__$1;
(statearr_40763_40933[(1)] = (49));

} else {
var statearr_40764_40934 = state_40639__$1;
(statearr_40764_40934[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (35))){
var inst_40380 = (state_40639[(75)]);
var state_40639__$1 = state_40639;
var statearr_40765_40935 = state_40639__$1;
(statearr_40765_40935[(2)] = inst_40380);

(statearr_40765_40935[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (82))){
var inst_40427 = (state_40639[(13)]);
var inst_40456 = (state_40639[(37)]);
var inst_40492 = (state_40639[(2)]);
var inst_40493 = fluree.db.dbproto._rhs(inst_40456);
var state_40639__$1 = (function (){var statearr_40766 = state_40639;
(statearr_40766[(65)] = inst_40493);

(statearr_40766[(81)] = inst_40492);

return statearr_40766;
})();
if(cljs.core.truth_(inst_40427)){
var statearr_40767_40936 = state_40639__$1;
(statearr_40767_40936[(1)] = (83));

} else {
var statearr_40768_40937 = state_40639__$1;
(statearr_40768_40937[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (76))){
var inst_40306 = (state_40639[(46)]);
var inst_40480 = (state_40639[(2)]);
var state_40639__$1 = (function (){var statearr_40769 = state_40639;
(statearr_40769[(64)] = inst_40480);

return statearr_40769;
})();
if(cljs.core.truth_(inst_40306)){
var statearr_40770_40938 = state_40639__$1;
(statearr_40770_40938[(1)] = (77));

} else {
var statearr_40771_40939 = state_40639__$1;
(statearr_40771_40939[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (97))){
var inst_40460 = (state_40639[(41)]);
var inst_40580 = (state_40639[(2)]);
var inst_40581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40580,(0),null);
var inst_40582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40580,(1),null);
var inst_40583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40580,(2),null);
var inst_40584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40585 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40460,inst_40583);
var inst_40586 = [(0),inst_40581,inst_40582,inst_40585];
var inst_40587 = (new cljs.core.PersistentVector(null,4,(5),inst_40584,inst_40586,null));
var state_40639__$1 = state_40639;
var statearr_40772_40940 = state_40639__$1;
(statearr_40772_40940[(2)] = inst_40587);

(statearr_40772_40940[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (19))){
var inst_40337 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
var statearr_40773_40941 = state_40639__$1;
(statearr_40773_40941[(2)] = inst_40337);

(statearr_40773_40941[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (57))){
var inst_40413 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
var statearr_40774_40942 = state_40639__$1;
(statearr_40774_40942[(2)] = inst_40413);

(statearr_40774_40942[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (68))){
var inst_40634 = (state_40639[(2)]);
var _ = (function (){var statearr_40775 = state_40639;
(statearr_40775[(4)] = cljs.core.rest((state_40639[(4)])));

return statearr_40775;
})();
var state_40639__$1 = state_40639;
var statearr_40776_40943 = state_40639__$1;
(statearr_40776_40943[(2)] = inst_40634);

(statearr_40776_40943[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (11))){
var inst_40297 = (state_40639[(84)]);
var state_40639__$1 = state_40639;
var statearr_40777_40944 = state_40639__$1;
(statearr_40777_40944[(2)] = inst_40297);

(statearr_40777_40944[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (115))){
var state_40639__$1 = state_40639;
var statearr_40779_40945 = state_40639__$1;
(statearr_40779_40945[(2)] = null);

(statearr_40779_40945[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (9))){
var inst_40312 = (state_40639[(2)]);
var inst_40313 = fluree.db.util.async.throw_err(inst_40312);
var state_40639__$1 = state_40639;
var statearr_40780_40946 = state_40639__$1;
(statearr_40780_40946[(2)] = inst_40313);

(statearr_40780_40946[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (5))){
var _ = (function (){var statearr_40781 = state_40639;
(statearr_40781[(4)] = cljs.core.rest((state_40639[(4)])));

return statearr_40781;
})();
var state_40639__$1 = state_40639;
var ex40778 = (state_40639__$1[(2)]);
var statearr_40782_40947 = state_40639__$1;
(statearr_40782_40947[(5)] = ex40778);


if((ex40778 instanceof Error)){
var statearr_40783_40948 = state_40639__$1;
(statearr_40783_40948[(1)] = (4));

(statearr_40783_40948[(5)] = null);

} else {
throw ex40778;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (112))){
var inst_40600 = (state_40639[(79)]);
var state_40639__$1 = state_40639;
var statearr_40784_40949 = state_40639__$1;
(statearr_40784_40949[(2)] = inst_40600);

(statearr_40784_40949[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (83))){
var inst_40495 = (state_40639[(85)]);
var inst_40457 = (state_40639[(28)]);
var inst_40495__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_40457);
var state_40639__$1 = (function (){var statearr_40785 = state_40639;
(statearr_40785[(85)] = inst_40495__$1);

return statearr_40785;
})();
if(inst_40495__$1){
var statearr_40786_40950 = state_40639__$1;
(statearr_40786_40950[(1)] = (86));

} else {
var statearr_40787_40951 = state_40639__$1;
(statearr_40787_40951[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (14))){
var inst_40292 = (state_40639[(61)]);
var state_40639__$1 = state_40639;
var statearr_40788_40952 = state_40639__$1;
(statearr_40788_40952[(2)] = inst_40292);

(statearr_40788_40952[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (45))){
var inst_40295 = (state_40639[(55)]);
var inst_40397 = (state_40639[(2)]);
var state_40639__$1 = (function (){var statearr_40789 = state_40639;
(statearr_40789[(36)] = inst_40397);

return statearr_40789;
})();
if(cljs.core.truth_(inst_40295)){
var statearr_40790_40953 = state_40639__$1;
(statearr_40790_40953[(1)] = (46));

} else {
var statearr_40791_40954 = state_40639__$1;
(statearr_40791_40954[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (53))){
var inst_40409 = (cljs.core._LT__EQ_ === end_test);
var state_40639__$1 = state_40639;
if(cljs.core.truth_(inst_40409)){
var statearr_40792_40955 = state_40639__$1;
(statearr_40792_40955[(1)] = (55));

} else {
var statearr_40793_40956 = state_40639__$1;
(statearr_40793_40956[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (78))){
var inst_40480 = (state_40639[(64)]);
var state_40639__$1 = state_40639;
var statearr_40794_40957 = state_40639__$1;
(statearr_40794_40957[(2)] = inst_40480);

(statearr_40794_40957[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (26))){
var inst_40359 = (state_40639[(51)]);
var inst_40364 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_40359);
var state_40639__$1 = state_40639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40639__$1,(29),inst_40364);
} else {
if((state_val_40640 === (123))){
var inst_40629 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
var statearr_40795_40958 = state_40639__$1;
(statearr_40795_40958[(2)] = inst_40629);

(statearr_40795_40958[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (16))){
var inst_40339 = (state_40639[(62)]);
var inst_40339__$1 = (state_40639[(2)]);
var inst_40340 = (inst_40339__$1 == null);
var state_40639__$1 = (function (){var statearr_40796 = state_40639;
(statearr_40796[(62)] = inst_40339__$1);

return statearr_40796;
})();
if(cljs.core.truth_(inst_40340)){
var statearr_40797_40959 = state_40639__$1;
(statearr_40797_40959[(1)] = (23));

} else {
var statearr_40798_40960 = state_40639__$1;
(statearr_40798_40960[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (81))){
var inst_40486 = (state_40639[(86)]);
var state_40639__$1 = state_40639;
var statearr_40799_40961 = state_40639__$1;
(statearr_40799_40961[(2)] = inst_40486);

(statearr_40799_40961[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (120))){
var inst_40623 = (state_40639[(2)]);
var inst_40624 = cljs.core.not(inst_40623);
var state_40639__$1 = state_40639;
if(inst_40624){
var statearr_40800_40962 = state_40639__$1;
(statearr_40800_40962[(1)] = (121));

} else {
var statearr_40801_40963 = state_40639__$1;
(statearr_40801_40963[(1)] = (122));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (79))){
var inst_40361 = (state_40639[(19)]);
var inst_40486 = (state_40639[(2)]);
var state_40639__$1 = (function (){var statearr_40802 = state_40639;
(statearr_40802[(86)] = inst_40486);

return statearr_40802;
})();
if(cljs.core.truth_(inst_40361)){
var statearr_40803_40964 = state_40639__$1;
(statearr_40803_40964[(1)] = (80));

} else {
var statearr_40804_40965 = state_40639__$1;
(statearr_40804_40965[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (38))){
var inst_40291 = (state_40639[(56)]);
var state_40639__$1 = state_40639;
var statearr_40805_40966 = state_40639__$1;
(statearr_40805_40966[(2)] = inst_40291);

(statearr_40805_40966[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (98))){
var inst_40536 = (state_40639[(67)]);
var inst_40426 = (state_40639[(24)]);
var inst_40534 = (state_40639[(70)]);
var inst_40539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40540 = (inst_40534 - inst_40536);
var inst_40541 = [inst_40426,inst_40540];
var inst_40542 = (new cljs.core.PersistentVector(null,2,(5),inst_40539,inst_40541,null));
var state_40639__$1 = state_40639;
var statearr_40806_40967 = state_40639__$1;
(statearr_40806_40967[(2)] = inst_40542);

(statearr_40806_40967[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (87))){
var inst_40495 = (state_40639[(85)]);
var state_40639__$1 = state_40639;
var statearr_40807_40968 = state_40639__$1;
(statearr_40807_40968[(2)] = inst_40495);

(statearr_40807_40968[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (30))){
var inst_40360 = (state_40639[(74)]);
var inst_40373 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_40360);
var state_40639__$1 = state_40639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40639__$1,(33),inst_40373);
} else {
if((state_val_40640 === (73))){
var inst_40305 = (state_40639[(12)]);
var inst_40474 = (state_40639[(2)]);
var state_40639__$1 = (function (){var statearr_40808 = state_40639;
(statearr_40808[(29)] = inst_40474);

return statearr_40808;
})();
if(cljs.core.truth_(inst_40305)){
var statearr_40809_40969 = state_40639__$1;
(statearr_40809_40969[(1)] = (74));

} else {
var statearr_40810_40970 = state_40639__$1;
(statearr_40810_40970[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (96))){
var inst_40458 = (state_40639[(21)]);
var inst_40426 = (state_40639[(24)]);
var inst_40459 = (state_40639[(30)]);
var inst_40420 = (state_40639[(31)]);
var inst_40526 = (state_40639[(68)]);
var inst_40575 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_40526,inst_40458,inst_40459,inst_40420,inst_40426);
var state_40639__$1 = state_40639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40639__$1,(104),inst_40575);
} else {
if((state_val_40640 === (10))){
var inst_40297 = (state_40639[(84)]);
var inst_40319 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_40297);
var state_40639__$1 = state_40639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40639__$1,(13),inst_40319);
} else {
if((state_val_40640 === (18))){
var state_40639__$1 = state_40639;
var statearr_40811_40971 = state_40639__$1;
(statearr_40811_40971[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (105))){
var inst_40417 = (state_40639[(26)]);
var inst_40598 = (state_40639[(82)]);
var inst_40493 = (state_40639[(65)]);
var inst_40432 = (state_40639[(33)]);
var inst_40597 = (inst_40432.cljs$core$IFn$_invoke$arity$2 ? inst_40432.cljs$core$IFn$_invoke$arity$2(inst_40493,inst_40417) : inst_40432.call(null,inst_40493,inst_40417));
var inst_40598__$1 = (inst_40597 < (0));
var state_40639__$1 = (function (){var statearr_40813 = state_40639;
(statearr_40813[(82)] = inst_40598__$1);

return statearr_40813;
})();
if(cljs.core.truth_(inst_40598__$1)){
var statearr_40814_40972 = state_40639__$1;
(statearr_40814_40972[(1)] = (108));

} else {
var statearr_40815_40973 = state_40639__$1;
(statearr_40815_40973[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (52))){
var inst_40302 = (state_40639[(57)]);
var state_40639__$1 = state_40639;
var statearr_40816_40974 = state_40639__$1;
(statearr_40816_40974[(2)] = inst_40302);

(statearr_40816_40974[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (114))){
var inst_40433 = (state_40639[(10)]);
var inst_40438 = (state_40639[(15)]);
var inst_40443 = (state_40639[(23)]);
var inst_40493 = (state_40639[(65)]);
var inst_40437 = (state_40639[(43)]);
var inst_40613 = fluree.db.query.range.find_next_valid_node(inst_40443,inst_40493,inst_40433,inst_40437,inst_40438);
var state_40639__$1 = state_40639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40639__$1,(117),inst_40613);
} else {
if((state_val_40640 === (67))){
var state_40639__$1 = state_40639;
var statearr_40817_40975 = state_40639__$1;
(statearr_40817_40975[(2)] = null);

(statearr_40817_40975[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (71))){
var inst_40433 = (state_40639[(10)]);
var inst_40289 = (state_40639[(11)]);
var inst_40305 = (state_40639[(12)]);
var inst_40427 = (state_40639[(13)]);
var inst_40294 = (state_40639[(14)]);
var inst_40438 = (state_40639[(15)]);
var inst_40316 = (state_40639[(16)]);
var inst_40370 = (state_40639[(17)]);
var inst_40358 = (state_40639[(18)]);
var inst_40361 = (state_40639[(19)]);
var inst_40428 = (state_40639[(20)]);
var inst_40458 = (state_40639[(21)]);
var inst_40379 = (state_40639[(22)]);
var inst_40443 = (state_40639[(23)]);
var inst_40426 = (state_40639[(24)]);
var inst_40296 = (state_40639[(25)]);
var inst_40417 = (state_40639[(26)]);
var inst_40357 = (state_40639[(27)]);
var inst_40457 = (state_40639[(28)]);
var inst_40459 = (state_40639[(30)]);
var inst_40420 = (state_40639[(31)]);
var inst_40406 = (state_40639[(32)]);
var inst_40447 = (state_40639[(8)]);
var inst_40432 = (state_40639[(33)]);
var inst_40453 = (state_40639[(9)]);
var inst_40300 = (state_40639[(34)]);
var inst_40419 = (state_40639[(35)]);
var inst_40397 = (state_40639[(36)]);
var inst_40456 = (state_40639[(37)]);
var inst_40388 = (state_40639[(38)]);
var inst_40304 = (state_40639[(39)]);
var inst_40325 = (state_40639[(40)]);
var inst_40460 = (state_40639[(41)]);
var inst_40415 = (state_40639[(42)]);
var inst_40437 = (state_40639[(43)]);
var inst_40416 = (state_40639[(44)]);
var inst_40466 = (state_40639[(45)]);
var inst_40306 = (state_40639[(46)]);
var inst_40293 = (state_40639[(47)]);
var inst_40301 = (state_40639[(48)]);
var inst_40470 = (function (){var no_filter_QMARK_ = inst_40453;
var vec__40278 = inst_40296;
var G__40467 = inst_40466;
var t = inst_40433;
var max_limit_QMARK_ = inst_40427;
var next_node = inst_40456;
var fast_forward_db_QMARK_ = inst_40438;
var s1 = inst_40316;
var o2 = inst_40379;
var t1 = inst_40293;
var predicate_fn = inst_40306;
var i = inst_40458;
var m1 = inst_40406;
var root_node = inst_40443;
var s2 = inst_40325;
var vec__40275 = inst_40289;
var p2 = inst_40397;
var vec__40282 = inst_40357;
var vec__40285 = inst_40358;
var permissions = inst_40428;
var limit = inst_40426;
var start_flake = inst_40416;
var flake_limit = inst_40420;
var offset = inst_40457;
var acc = inst_40460;
var t2 = inst_40300;
var op1 = inst_40294;
var o1 = inst_40370;
var end_flake = inst_40417;
var base_result = inst_40466;
var s = inst_40459;
var node_start = inst_40447;
var p1 = inst_40388;
var subject_fn = inst_40305;
var object_fn = inst_40361;
var idx_compare = inst_40432;
var map__40281 = inst_40304;
var op2 = inst_40301;
var m2 = inst_40415;
var map__40288 = inst_40419;
var novelty = inst_40437;
return (function (p1__40256_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__40256_SHARP_.o,start_flake.o);
});
})();
var inst_40471 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_40470,inst_40466);
var state_40639__$1 = state_40639;
var statearr_40818_40976 = state_40639__$1;
(statearr_40818_40976[(2)] = inst_40471);

(statearr_40818_40976[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (42))){
var inst_40393 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
if(cljs.core.truth_(inst_40393)){
var statearr_40819_40977 = state_40639__$1;
(statearr_40819_40977[(1)] = (43));

} else {
var statearr_40820_40978 = state_40639__$1;
(statearr_40820_40978[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (80))){
var inst_40433 = (state_40639[(10)]);
var inst_40289 = (state_40639[(11)]);
var inst_40305 = (state_40639[(12)]);
var inst_40427 = (state_40639[(13)]);
var inst_40294 = (state_40639[(14)]);
var inst_40438 = (state_40639[(15)]);
var inst_40316 = (state_40639[(16)]);
var inst_40370 = (state_40639[(17)]);
var inst_40358 = (state_40639[(18)]);
var inst_40361 = (state_40639[(19)]);
var inst_40428 = (state_40639[(20)]);
var inst_40458 = (state_40639[(21)]);
var inst_40379 = (state_40639[(22)]);
var inst_40443 = (state_40639[(23)]);
var inst_40426 = (state_40639[(24)]);
var inst_40296 = (state_40639[(25)]);
var inst_40417 = (state_40639[(26)]);
var inst_40357 = (state_40639[(27)]);
var inst_40486 = (state_40639[(86)]);
var inst_40457 = (state_40639[(28)]);
var inst_40459 = (state_40639[(30)]);
var inst_40420 = (state_40639[(31)]);
var inst_40406 = (state_40639[(32)]);
var inst_40447 = (state_40639[(8)]);
var inst_40432 = (state_40639[(33)]);
var inst_40453 = (state_40639[(9)]);
var inst_40300 = (state_40639[(34)]);
var inst_40419 = (state_40639[(35)]);
var inst_40397 = (state_40639[(36)]);
var inst_40456 = (state_40639[(37)]);
var inst_40388 = (state_40639[(38)]);
var inst_40304 = (state_40639[(39)]);
var inst_40325 = (state_40639[(40)]);
var inst_40460 = (state_40639[(41)]);
var inst_40415 = (state_40639[(42)]);
var inst_40437 = (state_40639[(43)]);
var inst_40416 = (state_40639[(44)]);
var inst_40466 = (state_40639[(45)]);
var inst_40306 = (state_40639[(46)]);
var inst_40293 = (state_40639[(47)]);
var inst_40301 = (state_40639[(48)]);
var inst_40488 = (function (){var no_filter_QMARK_ = inst_40453;
var vec__40278 = inst_40296;
var G__40467 = inst_40486;
var t = inst_40433;
var max_limit_QMARK_ = inst_40427;
var next_node = inst_40456;
var fast_forward_db_QMARK_ = inst_40438;
var s1 = inst_40316;
var o2 = inst_40379;
var t1 = inst_40293;
var predicate_fn = inst_40306;
var i = inst_40458;
var m1 = inst_40406;
var root_node = inst_40443;
var s2 = inst_40325;
var vec__40275 = inst_40289;
var p2 = inst_40397;
var vec__40282 = inst_40357;
var vec__40285 = inst_40358;
var permissions = inst_40428;
var limit = inst_40426;
var start_flake = inst_40416;
var flake_limit = inst_40420;
var offset = inst_40457;
var acc = inst_40460;
var t2 = inst_40300;
var op1 = inst_40294;
var o1 = inst_40370;
var end_flake = inst_40417;
var base_result = inst_40466;
var s = inst_40459;
var node_start = inst_40447;
var p1 = inst_40388;
var subject_fn = inst_40305;
var object_fn = inst_40361;
var idx_compare = inst_40432;
var map__40281 = inst_40304;
var op2 = inst_40301;
var m2 = inst_40415;
var map__40288 = inst_40419;
var novelty = inst_40437;
return (function (p1__40259_SHARP_){
var G__40821 = p1__40259_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__40821) : object_fn.call(null,G__40821));
});
})();
var inst_40489 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_40488,inst_40486);
var state_40639__$1 = state_40639;
var statearr_40822_40979 = state_40639__$1;
(statearr_40822_40979[(2)] = inst_40489);

(statearr_40822_40979[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (37))){
var state_40639__$1 = state_40639;
var statearr_40823_40980 = state_40639__$1;
(statearr_40823_40980[(2)] = (-1));

(statearr_40823_40980[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (63))){
var inst_40316 = (state_40639[(16)]);
var inst_40428 = (state_40639[(20)]);
var inst_40397 = (state_40639[(36)]);
var inst_40388 = (state_40639[(38)]);
var inst_40325 = (state_40639[(40)]);
var inst_40450 = fluree.db.permissions_validate.no_filter_QMARK_(inst_40428,inst_40316,inst_40325,inst_40388,inst_40397);
var state_40639__$1 = state_40639;
var statearr_40824_40981 = state_40639__$1;
(statearr_40824_40981[(2)] = inst_40450);

(statearr_40824_40981[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (94))){
var inst_40589 = (state_40639[(2)]);
var state_40639__$1 = state_40639;
var statearr_40825_40982 = state_40639__$1;
(statearr_40825_40982[(2)] = inst_40589);

(statearr_40825_40982[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (8))){
var inst_40297 = (state_40639[(84)]);
var inst_40316 = (state_40639[(2)]);
var inst_40317 = fluree.db.util.core.pred_ident_QMARK_(inst_40297);
var state_40639__$1 = (function (){var statearr_40826 = state_40639;
(statearr_40826[(16)] = inst_40316);

return statearr_40826;
})();
if(inst_40317){
var statearr_40827_40983 = state_40639__$1;
(statearr_40827_40983[(1)] = (10));

} else {
var statearr_40828_40984 = state_40639__$1;
(statearr_40828_40984[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (49))){
var state_40639__$1 = state_40639;
var statearr_40829_40985 = state_40639__$1;
(statearr_40829_40985[(2)] = fluree.db.util.core.min_integer);

(statearr_40829_40985[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40640 === (84))){
var inst_40427 = (state_40639[(13)]);
var state_40639__$1 = state_40639;
var statearr_40830_40986 = state_40639__$1;
(statearr_40830_40986[(2)] = inst_40427);

(statearr_40830_40986[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__24298__auto__ = null;
var fluree$db$query$range$state_machine__24298__auto____0 = (function (){
var statearr_40831 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40831[(0)] = fluree$db$query$range$state_machine__24298__auto__);

(statearr_40831[(1)] = (1));

return statearr_40831;
});
var fluree$db$query$range$state_machine__24298__auto____1 = (function (state_40639){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_40639);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e40832){var ex__24301__auto__ = e40832;
var statearr_40833_40987 = state_40639;
(statearr_40833_40987[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_40639[(4)]))){
var statearr_40834_40988 = state_40639;
(statearr_40834_40988[(1)] = cljs.core.first((state_40639[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__40989 = state_40639;
state_40639 = G__40989;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__24298__auto__ = function(state_40639){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__24298__auto____1.call(this,state_40639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__24298__auto____0;
fluree$db$query$range$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__24298__auto____1;
return fluree$db$query$range$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_40835 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_40835[(6)] = c__24424__auto__);

return statearr_40835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_41045){
var state_val_41046 = (state_41045[(1)]);
if((state_val_41046 === (7))){
var inst_41009 = (state_41045[(7)]);
var inst_41019 = (state_41045[(8)]);
var inst_41017 = fluree.db.flake.Flake__GT_parts(inst_41009);
var inst_41018 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41017,(0),null);
var inst_41019__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41017,(1),null);
var inst_41020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41017,(2),null);
var inst_41021 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41017,(3),null);
var inst_41022 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41017,(4),null);
var inst_41023 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41017,(5),null);
var inst_41024 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_41020,inst_41019__$1);
var state_41045__$1 = (function (){var statearr_41047 = state_41045;
(statearr_41047[(8)] = inst_41019__$1);

(statearr_41047[(9)] = inst_41021);

(statearr_41047[(10)] = inst_41023);

(statearr_41047[(11)] = inst_41018);

(statearr_41047[(12)] = inst_41022);

return statearr_41047;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41045__$1,(10),inst_41024);
} else {
if((state_val_41046 === (1))){
var inst_40997 = flakes;
var inst_40998 = cljs.core.seq(inst_40997);
var inst_40999 = cljs.core.first(inst_40998);
var inst_41000 = cljs.core.next(inst_40998);
var inst_41001 = cljs.core.PersistentVector.EMPTY;
var inst_41002 = inst_40997;
var inst_41003 = inst_41001;
var state_41045__$1 = (function (){var statearr_41048 = state_41045;
(statearr_41048[(13)] = inst_41000);

(statearr_41048[(14)] = inst_40999);

(statearr_41048[(15)] = inst_41002);

(statearr_41048[(16)] = inst_41003);

return statearr_41048;
})();
var statearr_41049_41067 = state_41045__$1;
(statearr_41049_41067[(2)] = null);

(statearr_41049_41067[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41046 === (4))){
var inst_41009 = (state_41045[(7)]);
var inst_41012 = fluree.db.query.range.is_tag_flake_QMARK_(inst_41009);
var state_41045__$1 = state_41045;
if(inst_41012){
var statearr_41050_41068 = state_41045__$1;
(statearr_41050_41068[(1)] = (7));

} else {
var statearr_41051_41069 = state_41045__$1;
(statearr_41051_41069[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41046 === (6))){
var inst_41041 = (state_41045[(2)]);
var state_41045__$1 = state_41045;
var statearr_41052_41070 = state_41045__$1;
(statearr_41052_41070[(2)] = inst_41041);

(statearr_41052_41070[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41046 === (3))){
var inst_41043 = (state_41045[(2)]);
var state_41045__$1 = state_41045;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41045__$1,inst_41043);
} else {
if((state_val_41046 === (2))){
var inst_41009 = (state_41045[(7)]);
var inst_41002 = (state_41045[(15)]);
var inst_41008 = cljs.core.seq(inst_41002);
var inst_41009__$1 = cljs.core.first(inst_41008);
var inst_41010 = cljs.core.next(inst_41008);
var state_41045__$1 = (function (){var statearr_41053 = state_41045;
(statearr_41053[(7)] = inst_41009__$1);

(statearr_41053[(17)] = inst_41010);

return statearr_41053;
})();
if(cljs.core.truth_(inst_41009__$1)){
var statearr_41054_41071 = state_41045__$1;
(statearr_41054_41071[(1)] = (4));

} else {
var statearr_41055_41072 = state_41045__$1;
(statearr_41055_41072[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41046 === (9))){
var inst_41038 = (state_41045[(2)]);
var state_41045__$1 = state_41045;
var statearr_41056_41073 = state_41045__$1;
(statearr_41056_41073[(2)] = inst_41038);

(statearr_41056_41073[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41046 === (5))){
var inst_41003 = (state_41045[(16)]);
var state_41045__$1 = state_41045;
var statearr_41057_41074 = state_41045__$1;
(statearr_41057_41074[(2)] = inst_41003);

(statearr_41057_41074[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41046 === (10))){
var inst_41010 = (state_41045[(17)]);
var inst_41019 = (state_41045[(8)]);
var inst_41021 = (state_41045[(9)]);
var inst_41003 = (state_41045[(16)]);
var inst_41023 = (state_41045[(10)]);
var inst_41018 = (state_41045[(11)]);
var inst_41022 = (state_41045[(12)]);
var inst_41026 = (state_41045[(2)]);
var inst_41027 = fluree.db.util.async.throw_err(inst_41026);
var inst_41028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41029 = [inst_41018,inst_41019,inst_41027,inst_41021,inst_41022,inst_41023];
var inst_41030 = (new cljs.core.PersistentVector(null,6,(5),inst_41028,inst_41029,null));
var inst_41031 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_41030);
var inst_41032 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41003,inst_41031);
var inst_41002 = inst_41010;
var inst_41003__$1 = inst_41032;
var state_41045__$1 = (function (){var statearr_41058 = state_41045;
(statearr_41058[(15)] = inst_41002);

(statearr_41058[(16)] = inst_41003__$1);

return statearr_41058;
})();
var statearr_41059_41075 = state_41045__$1;
(statearr_41059_41075[(2)] = null);

(statearr_41059_41075[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41046 === (8))){
var inst_41009 = (state_41045[(7)]);
var inst_41010 = (state_41045[(17)]);
var inst_41003 = (state_41045[(16)]);
var inst_41035 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41003,inst_41009);
var inst_41002 = inst_41010;
var inst_41003__$1 = inst_41035;
var state_41045__$1 = (function (){var statearr_41060 = state_41045;
(statearr_41060[(15)] = inst_41002);

(statearr_41060[(16)] = inst_41003__$1);

return statearr_41060;
})();
var statearr_41061_41076 = state_41045__$1;
(statearr_41061_41076[(2)] = null);

(statearr_41061_41076[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__24298__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__24298__auto____0 = (function (){
var statearr_41062 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41062[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__24298__auto__);

(statearr_41062[(1)] = (1));

return statearr_41062;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__24298__auto____1 = (function (state_41045){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_41045);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e41063){var ex__24301__auto__ = e41063;
var statearr_41064_41077 = state_41045;
(statearr_41064_41077[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_41045[(4)]))){
var statearr_41065_41078 = state_41045;
(statearr_41065_41078[(1)] = cljs.core.first((state_41045[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__41079 = state_41045;
state_41045 = G__41079;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__24298__auto__ = function(state_41045){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__24298__auto____1.call(this,state_41045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__24298__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__24298__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_41066 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_41066[(6)] = c__24424__auto__);

return statearr_41066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__41081 = arguments.length;
switch (G__41081) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_41251){
var state_val_41252 = (state_41251[(1)]);
if((state_val_41252 === (65))){
var state_41251__$1 = state_41251;
var statearr_41253_41353 = state_41251__$1;
(statearr_41253_41353[(2)] = null);

(statearr_41253_41353[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (70))){
var inst_41246 = (state_41251[(2)]);
var _ = (function (){var statearr_41254 = state_41251;
(statearr_41254[(4)] = cljs.core.rest((state_41251[(4)])));

return statearr_41254;
})();
var state_41251__$1 = state_41251;
var statearr_41255_41354 = state_41251__$1;
(statearr_41255_41354[(2)] = inst_41246);

(statearr_41255_41354[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (62))){
var inst_41232 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
var statearr_41256_41355 = state_41251__$1;
(statearr_41256_41355[(2)] = inst_41232);

(statearr_41256_41355[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (7))){
var state_41251__$1 = state_41251;
var statearr_41257_41356 = state_41251__$1;
(statearr_41257_41356[(2)] = false);

(statearr_41257_41356[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (59))){
var inst_41206 = (state_41251[(2)]);
var inst_41207 = fluree.db.util.async.throw_err(inst_41206);
var state_41251__$1 = state_41251;
var statearr_41258_41357 = state_41251__$1;
(statearr_41258_41357[(2)] = inst_41207);

(statearr_41258_41357[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (20))){
var state_41251__$1 = state_41251;
var statearr_41259_41358 = state_41251__$1;
(statearr_41259_41358[(2)] = null);

(statearr_41259_41358[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (58))){
var inst_41196 = (state_41251[(2)]);
var inst_41197 = fluree.db.util.async.throw_err(inst_41196);
var inst_41198 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_41197);
var state_41251__$1 = state_41251;
var statearr_41260_41359 = state_41251__$1;
(statearr_41260_41359[(2)] = inst_41198);

(statearr_41260_41359[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (60))){
var inst_41132 = (state_41251[(7)]);
var inst_41093 = (state_41251[(8)]);
var inst_41092 = (state_41251[(9)]);
var inst_41095 = (state_41251[(10)]);
var inst_41212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41213 = [inst_41093,inst_41092,inst_41132,inst_41095];
var inst_41214 = (new cljs.core.PersistentVector(null,4,(5),inst_41212,inst_41213,null));
var inst_41215 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_41214,opts);
var state_41251__$1 = state_41251;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41251__$1,(63),inst_41215);
} else {
if((state_val_41252 === (27))){
var inst_41132 = (state_41251[(7)]);
var inst_41143 = (state_41251[(11)]);
var inst_41143__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_41132);
var state_41251__$1 = (function (){var statearr_41261 = state_41251;
(statearr_41261[(11)] = inst_41143__$1);

return statearr_41261;
})();
if(inst_41143__$1){
var statearr_41262_41360 = state_41251__$1;
(statearr_41262_41360[(1)] = (30));

} else {
var statearr_41263_41361 = state_41251__$1;
(statearr_41263_41361[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (1))){
var state_41251__$1 = state_41251;
var statearr_41264_41362 = state_41251__$1;
(statearr_41264_41362[(2)] = null);

(statearr_41264_41362[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (69))){
var inst_41238 = (state_41251[(12)]);
var state_41251__$1 = state_41251;
var statearr_41265_41363 = state_41251__$1;
(statearr_41265_41363[(2)] = inst_41238);

(statearr_41265_41363[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (24))){
var inst_41093 = (state_41251[(8)]);
var state_41251__$1 = state_41251;
if(cljs.core.truth_(inst_41093)){
var statearr_41266_41364 = state_41251__$1;
(statearr_41266_41364[(1)] = (27));

} else {
var statearr_41267_41365 = state_41251__$1;
(statearr_41267_41365[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (55))){
var inst_41132 = (state_41251[(7)]);
var inst_41190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41191 = [inst_41132];
var inst_41192 = (new cljs.core.PersistentVector(null,1,(5),inst_41190,inst_41191,null));
var inst_41193 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$limit,(1));
var inst_41194 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_41192,inst_41193);
var state_41251__$1 = state_41251;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41251__$1,(58),inst_41194);
} else {
if((state_val_41252 === (39))){
var inst_41163 = (state_41251[(2)]);
var inst_41164 = fluree.db.util.async.throw_err(inst_41163);
var state_41251__$1 = state_41251;
var statearr_41268_41366 = state_41251__$1;
(statearr_41268_41366[(2)] = inst_41164);

(statearr_41268_41366[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (46))){
var inst_41176 = (state_41251[(13)]);
var inst_41176__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_41251__$1 = (function (){var statearr_41269 = state_41251;
(statearr_41269[(13)] = inst_41176__$1);

return statearr_41269;
})();
if(cljs.core.truth_(inst_41176__$1)){
var statearr_41270_41367 = state_41251__$1;
(statearr_41270_41367[(1)] = (49));

} else {
var statearr_41271_41368 = state_41251__$1;
(statearr_41271_41368[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (4))){
var inst_41082 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
var statearr_41272_41369 = state_41251__$1;
(statearr_41272_41369[(2)] = inst_41082);

(statearr_41272_41369[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (54))){
var inst_41188 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
if(cljs.core.truth_(inst_41188)){
var statearr_41273_41370 = state_41251__$1;
(statearr_41273_41370[(1)] = (55));

} else {
var statearr_41274_41371 = state_41251__$1;
(statearr_41274_41371[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (15))){
var inst_41094 = (state_41251[(14)]);
var inst_41113 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_41094);
var state_41251__$1 = state_41251;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41251__$1,(18),inst_41113);
} else {
if((state_val_41252 === (48))){
var inst_41234 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
var statearr_41275_41372 = state_41251__$1;
(statearr_41275_41372[(2)] = inst_41234);

(statearr_41275_41372[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (50))){
var inst_41102 = (state_41251[(15)]);
var inst_41176 = (state_41251[(13)]);
var inst_41132 = (state_41251[(7)]);
var inst_41093 = (state_41251[(8)]);
var inst_41091 = (state_41251[(16)]);
var inst_41107 = (state_41251[(17)]);
var inst_41092 = (state_41251[(9)]);
var inst_41095 = (state_41251[(10)]);
var inst_41096 = (state_41251[(18)]);
var inst_41180 = (function (){var t = inst_41095;
var p = inst_41093;
var idx_predicate_QMARK_ = inst_41096;
var o = inst_41132;
var vec__41088 = inst_41091;
var tag_predicate_QMARK_ = inst_41102;
var temp__5751__auto__ = inst_41176;
var s = inst_41092;
var o_coerce_QMARK_ = inst_41107;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_41251__$1 = state_41251;
var statearr_41276_41373 = state_41251__$1;
(statearr_41276_41373[(2)] = inst_41180);

(statearr_41276_41373[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (21))){
var inst_41128 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
var statearr_41277_41374 = state_41251__$1;
(statearr_41277_41374[(2)] = inst_41128);

(statearr_41277_41374[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (31))){
var inst_41143 = (state_41251[(11)]);
var state_41251__$1 = state_41251;
var statearr_41278_41375 = state_41251__$1;
(statearr_41278_41375[(2)] = inst_41143);

(statearr_41278_41375[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (32))){
var inst_41153 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
var statearr_41279_41376 = state_41251__$1;
(statearr_41279_41376[(2)] = inst_41153);

(statearr_41279_41376[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (40))){
var inst_41167 = (state_41251[(19)]);
var inst_41096 = (state_41251[(18)]);
var inst_41167__$1 = cljs.core.not(inst_41096);
var state_41251__$1 = (function (){var statearr_41280 = state_41251;
(statearr_41280[(19)] = inst_41167__$1);

return statearr_41280;
})();
if(inst_41167__$1){
var statearr_41281_41377 = state_41251__$1;
(statearr_41281_41377[(1)] = (43));

} else {
var statearr_41282_41378 = state_41251__$1;
(statearr_41282_41378[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (56))){
var inst_41093 = (state_41251[(8)]);
var inst_41092 = (state_41251[(9)]);
var inst_41182 = (state_41251[(20)]);
var inst_41095 = (state_41251[(10)]);
var inst_41200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41201 = [inst_41093,inst_41092,null,inst_41095];
var inst_41202 = (new cljs.core.PersistentVector(null,4,(5),inst_41200,inst_41201,null));
var inst_41203 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_41182);
var inst_41204 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_41202,inst_41203);
var state_41251__$1 = state_41251;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41251__$1,(59),inst_41204);
} else {
if((state_val_41252 === (33))){
var inst_41132 = (state_41251[(7)]);
var inst_41146 = cljs.core.fn_QMARK_(inst_41132);
var inst_41147 = (!(inst_41146));
var state_41251__$1 = state_41251;
var statearr_41283_41379 = state_41251__$1;
(statearr_41283_41379[(2)] = inst_41147);

(statearr_41283_41379[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (13))){
var inst_41094 = (state_41251[(14)]);
var inst_41111 = fluree.db.query.range.tag_string_QMARK_(inst_41094);
var state_41251__$1 = state_41251;
if(cljs.core.truth_(inst_41111)){
var statearr_41284_41380 = state_41251__$1;
(statearr_41284_41380[(1)] = (15));

} else {
var statearr_41285_41381 = state_41251__$1;
(statearr_41285_41381[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (22))){
var inst_41124 = (state_41251[(2)]);
var inst_41125 = fluree.db.util.async.throw_err(inst_41124);
var state_41251__$1 = state_41251;
var statearr_41286_41382 = state_41251__$1;
(statearr_41286_41382[(2)] = inst_41125);

(statearr_41286_41382[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (36))){
var inst_41132 = (state_41251[(7)]);
var inst_41093 = (state_41251[(8)]);
var inst_41092 = (state_41251[(9)]);
var inst_41095 = (state_41251[(10)]);
var inst_41158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41159 = [inst_41093,inst_41132,inst_41092,inst_41095];
var inst_41160 = (new cljs.core.PersistentVector(null,4,(5),inst_41158,inst_41159,null));
var inst_41161 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_41160,opts);
var state_41251__$1 = state_41251;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41251__$1,(39),inst_41161);
} else {
if((state_val_41252 === (41))){
var inst_41093 = (state_41251[(8)]);
var state_41251__$1 = state_41251;
var statearr_41287_41383 = state_41251__$1;
(statearr_41287_41383[(2)] = inst_41093);

(statearr_41287_41383[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (43))){
var inst_41132 = (state_41251[(7)]);
var state_41251__$1 = state_41251;
var statearr_41288_41384 = state_41251__$1;
(statearr_41288_41384[(2)] = inst_41132);

(statearr_41288_41384[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (61))){
var inst_41132 = (state_41251[(7)]);
var state_41251__$1 = state_41251;
if(cljs.core.truth_(inst_41132)){
var statearr_41289_41385 = state_41251__$1;
(statearr_41289_41385[(1)] = (64));

} else {
var statearr_41290_41386 = state_41251__$1;
(statearr_41290_41386[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (29))){
var inst_41156 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
if(cljs.core.truth_(inst_41156)){
var statearr_41291_41387 = state_41251__$1;
(statearr_41291_41387[(1)] = (36));

} else {
var statearr_41292_41388 = state_41251__$1;
(statearr_41292_41388[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (44))){
var inst_41167 = (state_41251[(19)]);
var state_41251__$1 = state_41251;
var statearr_41293_41389 = state_41251__$1;
(statearr_41293_41389[(2)] = inst_41167);

(statearr_41293_41389[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (6))){
var inst_41093 = (state_41251[(8)]);
var inst_41098 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_41093);
var inst_41099 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_41098);
var state_41251__$1 = state_41251;
var statearr_41294_41390 = state_41251__$1;
(statearr_41294_41390[(2)] = inst_41099);

(statearr_41294_41390[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (28))){
var inst_41093 = (state_41251[(8)]);
var state_41251__$1 = state_41251;
var statearr_41295_41391 = state_41251__$1;
(statearr_41295_41391[(2)] = inst_41093);

(statearr_41295_41391[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (64))){
var inst_41132 = (state_41251[(7)]);
var inst_41093 = (state_41251[(8)]);
var inst_41092 = (state_41251[(9)]);
var inst_41095 = (state_41251[(10)]);
var inst_41221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41222 = [inst_41132,inst_41093,inst_41092,inst_41095];
var inst_41223 = (new cljs.core.PersistentVector(null,4,(5),inst_41221,inst_41222,null));
var inst_41224 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_41223,opts);
var state_41251__$1 = state_41251;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41251__$1,(67),inst_41224);
} else {
if((state_val_41252 === (51))){
var inst_41093 = (state_41251[(8)]);
var inst_41183 = (state_41251[(21)]);
var inst_41182 = (state_41251[(2)]);
var inst_41183__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_41093);
var state_41251__$1 = (function (){var statearr_41296 = state_41251;
(statearr_41296[(21)] = inst_41183__$1);

(statearr_41296[(20)] = inst_41182);

return statearr_41296;
})();
if(inst_41183__$1){
var statearr_41297_41392 = state_41251__$1;
(statearr_41297_41392[(1)] = (52));

} else {
var statearr_41298_41393 = state_41251__$1;
(statearr_41298_41393[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (25))){
var inst_41102 = (state_41251[(15)]);
var inst_41238 = (state_41251[(2)]);
var state_41251__$1 = (function (){var statearr_41299 = state_41251;
(statearr_41299[(12)] = inst_41238);

return statearr_41299;
})();
if(cljs.core.truth_(inst_41102)){
var statearr_41300_41394 = state_41251__$1;
(statearr_41300_41394[(1)] = (68));

} else {
var statearr_41301_41395 = state_41251__$1;
(statearr_41301_41395[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (34))){
var inst_41096 = (state_41251[(18)]);
var state_41251__$1 = state_41251;
var statearr_41302_41396 = state_41251__$1;
(statearr_41302_41396[(2)] = inst_41096);

(statearr_41302_41396[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (17))){
var inst_41130 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
var statearr_41303_41397 = state_41251__$1;
(statearr_41303_41397[(2)] = inst_41130);

(statearr_41303_41397[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (3))){
var inst_41249 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41251__$1,inst_41249);
} else {
if((state_val_41252 === (12))){
var inst_41094 = (state_41251[(14)]);
var state_41251__$1 = state_41251;
var statearr_41304_41398 = state_41251__$1;
(statearr_41304_41398[(2)] = inst_41094);

(statearr_41304_41398[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (2))){
var inst_41093 = (state_41251[(8)]);
var inst_41091 = (state_41251[(16)]);
var _ = (function (){var statearr_41305 = state_41251;
(statearr_41305[(4)] = cljs.core.cons((5),(state_41251[(4)])));

return statearr_41305;
})();
var inst_41091__$1 = fparts;
var inst_41092 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41091__$1,(0),null);
var inst_41093__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41091__$1,(1),null);
var inst_41094 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41091__$1,(2),null);
var inst_41095 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41091__$1,(3),null);
var inst_41096 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_41093__$1);
var state_41251__$1 = (function (){var statearr_41306 = state_41251;
(statearr_41306[(14)] = inst_41094);

(statearr_41306[(8)] = inst_41093__$1);

(statearr_41306[(16)] = inst_41091__$1);

(statearr_41306[(9)] = inst_41092);

(statearr_41306[(10)] = inst_41095);

(statearr_41306[(18)] = inst_41096);

return statearr_41306;
})();
if(cljs.core.truth_(inst_41093__$1)){
var statearr_41307_41399 = state_41251__$1;
(statearr_41307_41399[(1)] = (6));

} else {
var statearr_41308_41400 = state_41251__$1;
(statearr_41308_41400[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (66))){
var inst_41230 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
var statearr_41309_41401 = state_41251__$1;
(statearr_41309_41401[(2)] = inst_41230);

(statearr_41309_41401[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (23))){
var inst_41132 = (state_41251[(7)]);
var inst_41093 = (state_41251[(8)]);
var inst_41092 = (state_41251[(9)]);
var inst_41095 = (state_41251[(10)]);
var inst_41134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41135 = [inst_41092,inst_41093,inst_41132,inst_41095];
var inst_41136 = (new cljs.core.PersistentVector(null,4,(5),inst_41134,inst_41135,null));
var inst_41137 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_41136,opts);
var state_41251__$1 = state_41251;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41251__$1,(26),inst_41137);
} else {
if((state_val_41252 === (47))){
var inst_41093 = (state_41251[(8)]);
var state_41251__$1 = state_41251;
if(cljs.core.truth_(inst_41093)){
var statearr_41310_41402 = state_41251__$1;
(statearr_41310_41402[(1)] = (60));

} else {
var statearr_41311_41403 = state_41251__$1;
(statearr_41311_41403[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (35))){
var inst_41150 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
var statearr_41312_41404 = state_41251__$1;
(statearr_41312_41404[(2)] = inst_41150);

(statearr_41312_41404[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (19))){
var inst_41094 = (state_41251[(14)]);
var inst_41093 = (state_41251[(8)]);
var inst_41120 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_41093);
var inst_41121 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41120),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41094)].join('');
var inst_41122 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_41121);
var state_41251__$1 = state_41251;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41251__$1,(22),inst_41122);
} else {
if((state_val_41252 === (57))){
var inst_41209 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
var statearr_41313_41405 = state_41251__$1;
(statearr_41313_41405[(2)] = inst_41209);

(statearr_41313_41405[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (68))){
var inst_41238 = (state_41251[(12)]);
var inst_41240 = fluree.db.query.range.coerce_tag_flakes(db,inst_41238);
var state_41251__$1 = state_41251;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41251__$1,(71),inst_41240);
} else {
if((state_val_41252 === (11))){
var inst_41107 = (state_41251[(17)]);
var inst_41107__$1 = (state_41251[(2)]);
var inst_41108 = cljs.core.not(inst_41107__$1);
var state_41251__$1 = (function (){var statearr_41315 = state_41251;
(statearr_41315[(17)] = inst_41107__$1);

return statearr_41315;
})();
if(inst_41108){
var statearr_41316_41406 = state_41251__$1;
(statearr_41316_41406[(1)] = (12));

} else {
var statearr_41317_41407 = state_41251__$1;
(statearr_41317_41407[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (9))){
var inst_41094 = (state_41251[(14)]);
var inst_41104 = typeof inst_41094 === 'string';
var state_41251__$1 = state_41251;
var statearr_41318_41408 = state_41251__$1;
(statearr_41318_41408[(2)] = inst_41104);

(statearr_41318_41408[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (5))){
var _ = (function (){var statearr_41319 = state_41251;
(statearr_41319[(4)] = cljs.core.rest((state_41251[(4)])));

return statearr_41319;
})();
var state_41251__$1 = state_41251;
var ex41314 = (state_41251__$1[(2)]);
var statearr_41320_41409 = state_41251__$1;
(statearr_41320_41409[(5)] = ex41314);


if((ex41314 instanceof Error)){
var statearr_41321_41410 = state_41251__$1;
(statearr_41321_41410[(1)] = (4));

(statearr_41321_41410[(5)] = null);

} else {
throw ex41314;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (14))){
var inst_41092 = (state_41251[(9)]);
var inst_41132 = (state_41251[(2)]);
var state_41251__$1 = (function (){var statearr_41322 = state_41251;
(statearr_41322[(7)] = inst_41132);

return statearr_41322;
})();
if(cljs.core.truth_(inst_41092)){
var statearr_41323_41411 = state_41251__$1;
(statearr_41323_41411[(1)] = (23));

} else {
var statearr_41324_41412 = state_41251__$1;
(statearr_41324_41412[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (45))){
var inst_41171 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
var statearr_41325_41413 = state_41251__$1;
(statearr_41325_41413[(2)] = inst_41171);

(statearr_41325_41413[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (53))){
var inst_41183 = (state_41251[(21)]);
var state_41251__$1 = state_41251;
var statearr_41326_41414 = state_41251__$1;
(statearr_41326_41414[(2)] = inst_41183);

(statearr_41326_41414[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (26))){
var inst_41139 = (state_41251[(2)]);
var inst_41140 = fluree.db.util.async.throw_err(inst_41139);
var state_41251__$1 = state_41251;
var statearr_41327_41415 = state_41251__$1;
(statearr_41327_41415[(2)] = inst_41140);

(statearr_41327_41415[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (16))){
var inst_41094 = (state_41251[(14)]);
var inst_41118 = typeof inst_41094 === 'string';
var state_41251__$1 = state_41251;
if(cljs.core.truth_(inst_41118)){
var statearr_41328_41416 = state_41251__$1;
(statearr_41328_41416[(1)] = (19));

} else {
var statearr_41329_41417 = state_41251__$1;
(statearr_41329_41417[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (38))){
var inst_41236 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
var statearr_41330_41418 = state_41251__$1;
(statearr_41330_41418[(2)] = inst_41236);

(statearr_41330_41418[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (30))){
var inst_41096 = (state_41251[(18)]);
var state_41251__$1 = state_41251;
if(cljs.core.truth_(inst_41096)){
var statearr_41331_41419 = state_41251__$1;
(statearr_41331_41419[(1)] = (33));

} else {
var statearr_41332_41420 = state_41251__$1;
(statearr_41332_41420[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (10))){
var inst_41102 = (state_41251[(15)]);
var state_41251__$1 = state_41251;
var statearr_41333_41421 = state_41251__$1;
(statearr_41333_41421[(2)] = inst_41102);

(statearr_41333_41421[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (18))){
var inst_41115 = (state_41251[(2)]);
var inst_41116 = fluree.db.util.async.throw_err(inst_41115);
var state_41251__$1 = state_41251;
var statearr_41334_41422 = state_41251__$1;
(statearr_41334_41422[(2)] = inst_41116);

(statearr_41334_41422[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (52))){
var inst_41132 = (state_41251[(7)]);
var inst_41185 = cljs.core.int_QMARK_(inst_41132);
var state_41251__$1 = state_41251;
var statearr_41335_41423 = state_41251__$1;
(statearr_41335_41423[(2)] = inst_41185);

(statearr_41335_41423[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (67))){
var inst_41226 = (state_41251[(2)]);
var inst_41227 = fluree.db.util.async.throw_err(inst_41226);
var state_41251__$1 = state_41251;
var statearr_41336_41424 = state_41251__$1;
(statearr_41336_41424[(2)] = inst_41227);

(statearr_41336_41424[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (71))){
var inst_41242 = (state_41251[(2)]);
var inst_41243 = fluree.db.util.async.throw_err(inst_41242);
var state_41251__$1 = state_41251;
var statearr_41337_41425 = state_41251__$1;
(statearr_41337_41425[(2)] = inst_41243);

(statearr_41337_41425[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (42))){
var inst_41174 = (state_41251[(2)]);
var state_41251__$1 = state_41251;
if(cljs.core.truth_(inst_41174)){
var statearr_41338_41426 = state_41251__$1;
(statearr_41338_41426[(1)] = (46));

} else {
var statearr_41339_41427 = state_41251__$1;
(statearr_41339_41427[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (37))){
var inst_41093 = (state_41251[(8)]);
var state_41251__$1 = state_41251;
if(cljs.core.truth_(inst_41093)){
var statearr_41340_41428 = state_41251__$1;
(statearr_41340_41428[(1)] = (40));

} else {
var statearr_41341_41429 = state_41251__$1;
(statearr_41341_41429[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (63))){
var inst_41217 = (state_41251[(2)]);
var inst_41218 = fluree.db.util.async.throw_err(inst_41217);
var state_41251__$1 = state_41251;
var statearr_41342_41430 = state_41251__$1;
(statearr_41342_41430[(2)] = inst_41218);

(statearr_41342_41430[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (8))){
var inst_41102 = (state_41251[(15)]);
var inst_41102__$1 = (state_41251[(2)]);
var state_41251__$1 = (function (){var statearr_41343 = state_41251;
(statearr_41343[(15)] = inst_41102__$1);

return statearr_41343;
})();
if(cljs.core.truth_(inst_41102__$1)){
var statearr_41344_41431 = state_41251__$1;
(statearr_41344_41431[(1)] = (9));

} else {
var statearr_41345_41432 = state_41251__$1;
(statearr_41345_41432[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41252 === (49))){
var inst_41102 = (state_41251[(15)]);
var inst_41176 = (state_41251[(13)]);
var inst_41132 = (state_41251[(7)]);
var inst_41093 = (state_41251[(8)]);
var inst_41091 = (state_41251[(16)]);
var inst_41107 = (state_41251[(17)]);
var inst_41092 = (state_41251[(9)]);
var inst_41095 = (state_41251[(10)]);
var inst_41096 = (state_41251[(18)]);
var inst_41178 = (function (){var obj_fn = inst_41176;
var t = inst_41095;
var p = inst_41093;
var idx_predicate_QMARK_ = inst_41096;
var o = inst_41132;
var vec__41088 = inst_41091;
var tag_predicate_QMARK_ = inst_41102;
var temp__5751__auto__ = inst_41176;
var s = inst_41092;
var o_coerce_QMARK_ = inst_41107;
return (function (x){
var and__4210__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4210__auto__;
}
});
})();
var state_41251__$1 = state_41251;
var statearr_41346_41433 = state_41251__$1;
(statearr_41346_41433[(2)] = inst_41178);

(statearr_41346_41433[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__24298__auto__ = null;
var fluree$db$query$range$state_machine__24298__auto____0 = (function (){
var statearr_41347 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41347[(0)] = fluree$db$query$range$state_machine__24298__auto__);

(statearr_41347[(1)] = (1));

return statearr_41347;
});
var fluree$db$query$range$state_machine__24298__auto____1 = (function (state_41251){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_41251);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e41348){var ex__24301__auto__ = e41348;
var statearr_41349_41434 = state_41251;
(statearr_41349_41434[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_41251[(4)]))){
var statearr_41350_41435 = state_41251;
(statearr_41350_41435[(1)] = cljs.core.first((state_41251[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__41436 = state_41251;
state_41251 = G__41436;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__24298__auto__ = function(state_41251){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__24298__auto____1.call(this,state_41251);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__24298__auto____0;
fluree$db$query$range$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__24298__auto____1;
return fluree$db$query$range$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_41351 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_41351[(6)] = c__24424__auto__);

return statearr_41351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__41438 = arguments.length;
switch (G__41438) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_41473){
var state_val_41474 = (state_41473[(1)]);
if((state_val_41474 === (7))){
var inst_41460 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_41461 = ["Invalid collection name: ",inst_41460].join('');
var inst_41462 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41463 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_41464 = cljs.core.PersistentHashMap.fromArrays(inst_41462,inst_41463);
var inst_41465 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41461,inst_41464);
var inst_41466 = (function(){throw inst_41465})();
var state_41473__$1 = state_41473;
var statearr_41475_41495 = state_41473__$1;
(statearr_41475_41495[(2)] = inst_41466);

(statearr_41475_41495[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41474 === (1))){
var state_41473__$1 = state_41473;
var statearr_41476_41496 = state_41473__$1;
(statearr_41476_41496[(2)] = null);

(statearr_41476_41496[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41474 === (4))){
var inst_41439 = (state_41473[(2)]);
var state_41473__$1 = state_41473;
var statearr_41477_41497 = state_41473__$1;
(statearr_41477_41497[(2)] = inst_41439);

(statearr_41477_41497[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41474 === (6))){
var inst_41445 = (state_41473[(7)]);
var inst_41447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41448 = fluree.db.flake.max_subject_id(inst_41445);
var inst_41449 = [inst_41448];
var inst_41450 = (new cljs.core.PersistentVector(null,1,(5),inst_41447,inst_41449,null));
var inst_41451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41452 = fluree.db.flake.min_subject_id(inst_41445);
var inst_41453 = [inst_41452];
var inst_41454 = (new cljs.core.PersistentVector(null,1,(5),inst_41451,inst_41453,null));
var inst_41455 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_41450,cljs.core._LT__EQ_,inst_41454,opts);
var state_41473__$1 = state_41473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41473__$1,(9),inst_41455);
} else {
if((state_val_41474 === (3))){
var inst_41471 = (state_41473[(2)]);
var state_41473__$1 = state_41473;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41473__$1,inst_41471);
} else {
if((state_val_41474 === (2))){
var inst_41445 = (state_41473[(7)]);
var _ = (function (){var statearr_41479 = state_41473;
(statearr_41479[(4)] = cljs.core.cons((5),(state_41473[(4)])));

return statearr_41479;
})();
var inst_41445__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,name);
var state_41473__$1 = (function (){var statearr_41480 = state_41473;
(statearr_41480[(7)] = inst_41445__$1);

return statearr_41480;
})();
if(cljs.core.truth_(inst_41445__$1)){
var statearr_41481_41498 = state_41473__$1;
(statearr_41481_41498[(1)] = (6));

} else {
var statearr_41482_41499 = state_41473__$1;
(statearr_41482_41499[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41474 === (9))){
var inst_41457 = (state_41473[(2)]);
var inst_41458 = fluree.db.util.async.throw_err(inst_41457);
var state_41473__$1 = state_41473;
var statearr_41483_41500 = state_41473__$1;
(statearr_41483_41500[(2)] = inst_41458);

(statearr_41483_41500[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41474 === (5))){
var _ = (function (){var statearr_41484 = state_41473;
(statearr_41484[(4)] = cljs.core.rest((state_41473[(4)])));

return statearr_41484;
})();
var state_41473__$1 = state_41473;
var ex41478 = (state_41473__$1[(2)]);
var statearr_41485_41501 = state_41473__$1;
(statearr_41485_41501[(5)] = ex41478);


var statearr_41486_41502 = state_41473__$1;
(statearr_41486_41502[(1)] = (4));

(statearr_41486_41502[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41474 === (8))){
var inst_41468 = (state_41473[(2)]);
var _ = (function (){var statearr_41487 = state_41473;
(statearr_41487[(4)] = cljs.core.rest((state_41473[(4)])));

return statearr_41487;
})();
var state_41473__$1 = state_41473;
var statearr_41488_41503 = state_41473__$1;
(statearr_41488_41503[(2)] = inst_41468);

(statearr_41488_41503[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__24298__auto__ = null;
var fluree$db$query$range$state_machine__24298__auto____0 = (function (){
var statearr_41489 = [null,null,null,null,null,null,null,null];
(statearr_41489[(0)] = fluree$db$query$range$state_machine__24298__auto__);

(statearr_41489[(1)] = (1));

return statearr_41489;
});
var fluree$db$query$range$state_machine__24298__auto____1 = (function (state_41473){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_41473);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e41490){var ex__24301__auto__ = e41490;
var statearr_41491_41504 = state_41473;
(statearr_41491_41504[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_41473[(4)]))){
var statearr_41492_41505 = state_41473;
(statearr_41492_41505[(1)] = cljs.core.first((state_41473[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__41506 = state_41473;
state_41473 = G__41506;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__24298__auto__ = function(state_41473){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__24298__auto____1.call(this,state_41473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__24298__auto____0;
fluree$db$query$range$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__24298__auto____1;
return fluree$db$query$range$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_41493 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_41493[(6)] = c__24424__auto__);

return statearr_41493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__41510 = flakes;
var vec__41511 = G__41510;
var seq__41512 = cljs.core.seq(vec__41511);
var first__41513 = cljs.core.first(seq__41512);
var seq__41512__$1 = cljs.core.next(seq__41512);
var flake_SINGLEQUOTE_ = first__41513;
var r = seq__41512__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__41510__$1 = G__41510;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__41519 = G__41510__$1;
var seq__41520 = cljs.core.seq(vec__41519);
var first__41521 = cljs.core.first(seq__41520);
var seq__41520__$1 = cljs.core.next(seq__41520);
var flake_SINGLEQUOTE___$1 = first__41521;
var r__$1 = seq__41520__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e41523){var e = e41523;
return null;
}})();
var map__41522 = cmd_map;
var map__41522__$1 = cljs.core.__destructure_map(map__41522);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41522__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41522__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41522__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41522__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41522__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41522__$1,cljs.core.cst$kw$expire);
var G__41524 = r__$1;
var G__41525 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__41510__$1 = G__41524;
result_STAR___$1 = G__41525;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__41534 = blocks;
var vec__41535 = G__41534;
var seq__41536 = cljs.core.seq(vec__41535);
var first__41537 = cljs.core.first(seq__41536);
var seq__41536__$1 = cljs.core.next(seq__41536);
var block_SINGLEQUOTE_ = first__41537;
var r = seq__41536__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__41534__$1 = G__41534;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__41542 = G__41534__$1;
var seq__41543 = cljs.core.seq(vec__41542);
var first__41544 = cljs.core.first(seq__41543);
var seq__41543__$1 = cljs.core.next(seq__41543);
var block_SINGLEQUOTE___$1 = first__41544;
var r__$1 = seq__41543__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__41545 = block_SINGLEQUOTE___$1;
var map__41545__$1 = cljs.core.__destructure_map(map__41545);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41545__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41545__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41545__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__41534__$1,result_STAR___$1,map__41545,map__41545__$1,block,t,flakes,vec__41542,seq__41543,first__41544,seq__41543__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__41534,vec__41535,seq__41536,first__41537,seq__41536__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__41526_SHARP_){
var f = p1__41526_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__41534__$1,result_STAR___$1,map__41545,map__41545__$1,block,t,flakes,vec__41542,seq__41543,first__41544,seq__41543__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__41534,vec__41535,seq__41536,first__41537,seq__41536__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__41534__$1,result_STAR___$1,map__41545,map__41545__$1,block,t,flakes,prev_hash,vec__41542,seq__41543,first__41544,seq__41543__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__41534,vec__41535,seq__41536,first__41537,seq__41536__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__41527_SHARP_){
var f = p1__41527_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__41534__$1,result_STAR___$1,map__41545,map__41545__$1,block,t,flakes,prev_hash,vec__41542,seq__41543,first__41544,seq__41543__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__41534,vec__41535,seq__41536,first__41537,seq__41536__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__41534__$1,result_STAR___$1,map__41545,map__41545__$1,block,t,flakes,prev_hash,hash,vec__41542,seq__41543,first__41544,seq__41543__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__41534,vec__41535,seq__41536,first__41537,seq__41536__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__41528_SHARP_){
var f = p1__41528_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__41534__$1,result_STAR___$1,map__41545,map__41545__$1,block,t,flakes,prev_hash,hash,vec__41542,seq__41543,first__41544,seq__41543__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__41534,vec__41535,seq__41536,first__41537,seq__41536__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__41534__$1,result_STAR___$1,map__41545,map__41545__$1,block,t,flakes,prev_hash,hash,instant,vec__41542,seq__41543,first__41544,seq__41543__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__41534,vec__41535,seq__41536,first__41537,seq__41536__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__41529_SHARP_){
var f = p1__41529_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__41534__$1,result_STAR___$1,map__41545,map__41545__$1,block,t,flakes,prev_hash,hash,instant,vec__41542,seq__41543,first__41544,seq__41543__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__41534,vec__41535,seq__41536,first__41537,seq__41536__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__41534__$1,result_STAR___$1,map__41545,map__41545__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__41542,seq__41543,first__41544,seq__41543__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__41534,vec__41535,seq__41536,first__41537,seq__41536__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__41530_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__41530_SHARP_.p,(106));
});})(G__41534__$1,result_STAR___$1,map__41545,map__41545__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__41542,seq__41543,first__41544,seq__41543__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__41534,vec__41535,seq__41536,first__41537,seq__41536__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__41546 = r__$1;
var G__41547 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__41534__$1 = G__41546;
result_STAR___$1 = G__41547;
continue;
}
break;
}
});
