// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__48024 = arguments.length;
switch (G__48024) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__48025 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__48025) : f.call(null,G__48025));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__48026 = cljs.core._deref(vol);
var G__48027 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__48026,G__48027) : f.call(null,G__48026,G__48027));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__48028 = cljs.core._deref(vol);
var G__48029 = arg1;
var G__48030 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__48028,G__48029,G__48030) : f.call(null,G__48028,G__48029,G__48030));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__48031 = cljs.core._deref(vol);
var G__48032 = arg1;
var G__48033 = arg2;
var G__48034 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__48031,G__48032,G__48033,G__48034) : f.call(null,G__48031,G__48032,G__48033,G__48034));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__48037 = arguments.length;
switch (G__48037) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__48039 = null;
var G__48039__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__48039__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__48039__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__48039 = function(result,flake){
switch(arguments.length){
case 0:
return G__48039__0.call(this);
case 1:
return G__48039__1.call(this,result);
case 2:
return G__48039__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48039.cljs$core$IFn$_invoke$arity$0 = G__48039__0;
G__48039.cljs$core$IFn$_invoke$arity$1 = G__48039__1;
G__48039.cljs$core$IFn$_invoke$arity$2 = G__48039__2;
return G__48039;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__48040 = null;
var G__48040__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__48040__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__48040__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__48040 = function(result,flakes){
switch(arguments.length){
case 0:
return G__48040__0.call(this);
case 1:
return G__48040__1.call(this,result);
case 2:
return G__48040__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48040.cljs$core$IFn$_invoke$arity$0 = G__48040__0;
G__48040.cljs$core$IFn$_invoke$arity$1 = G__48040__1;
G__48040.cljs$core$IFn$_invoke$arity$2 = G__48040__2;
return G__48040;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__48042 = res;
var G__48042__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__48041_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__48041_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__48042):G__48042);
var G__48042__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__48042__$1):G__48042__$1);
var G__48042__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__48042__$2):G__48042__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__48042__$3);
} else {
return G__48042__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__48046 = arguments.length;
switch (G__48046) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_48418){
var state_val_48419 = (state_48418[(1)]);
if((state_val_48419 === (65))){
var inst_48200 = (state_48418[(2)]);
var inst_48201 = fluree.db.util.async.throw_err(inst_48200);
var state_48418__$1 = (function (){var statearr_48420 = state_48418;
(statearr_48420[(7)] = inst_48201);

return statearr_48420;
})();
if(cljs.core.truth_(fuel)){
var statearr_48421_48606 = state_48418__$1;
(statearr_48421_48606[(1)] = (66));

} else {
var statearr_48422_48607 = state_48418__$1;
(statearr_48422_48607[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (70))){
var inst_48224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48232 = flakes;
var inst_48233 = cljs.core.seq(inst_48232);
var inst_48234 = cljs.core.first(inst_48233);
var inst_48235 = cljs.core.next(inst_48233);
var inst_48236 = cljs.core.PersistentVector.EMPTY;
var inst_48237 = inst_48232;
var inst_48238 = inst_48236;
var state_48418__$1 = (function (){var statearr_48423 = state_48418;
(statearr_48423[(8)] = inst_48224);

(statearr_48423[(9)] = inst_48234);

(statearr_48423[(10)] = inst_48238);

(statearr_48423[(11)] = inst_48237);

(statearr_48423[(12)] = inst_48235);

return statearr_48423;
})();
var statearr_48424_48608 = state_48418__$1;
(statearr_48424_48608[(2)] = null);

(statearr_48424_48608[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (62))){
var inst_48191 = (state_48418[(13)]);
var inst_48194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48195 = inst_48191.o;
var inst_48196 = [inst_48195];
var inst_48197 = (new cljs.core.PersistentVector(null,1,(5),inst_48194,inst_48196,null));
var inst_48198 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_48197);
var state_48418__$1 = state_48418;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48418__$1,(65),inst_48198);
} else {
if((state_val_48419 === (74))){
var inst_48224 = (state_48418[(8)]);
var inst_48280 = (state_48418[(2)]);
var inst_48281 = [inst_48280,offset_map];
var inst_48282 = (new cljs.core.PersistentVector(null,2,(5),inst_48224,inst_48281,null));
var state_48418__$1 = state_48418;
var statearr_48425_48609 = state_48418__$1;
(statearr_48425_48609[(2)] = inst_48282);

(statearr_48425_48609[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (110))){
var inst_48388 = (state_48418[(14)]);
var inst_48391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48392 = [acc,inst_48388];
var inst_48393 = (new cljs.core.PersistentVector(null,2,(5),inst_48391,inst_48392,null));
var state_48418__$1 = state_48418;
var statearr_48426_48610 = state_48418__$1;
(statearr_48426_48610[(2)] = inst_48393);

(statearr_48426_48610[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (7))){
var inst_48058 = (state_48418[(15)]);
var state_48418__$1 = state_48418;
var statearr_48427_48611 = state_48418__$1;
(statearr_48427_48611[(2)] = inst_48058);

(statearr_48427_48611[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (59))){
var inst_48382 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48428_48612 = state_48418__$1;
(statearr_48428_48612[(2)] = inst_48382);

(statearr_48428_48612[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (86))){
var inst_48284 = (state_48418[(16)]);
var state_48418__$1 = state_48418;
var statearr_48429_48613 = state_48418__$1;
(statearr_48429_48613[(2)] = inst_48284);

(statearr_48429_48613[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (20))){
var inst_48087 = (state_48418[(17)]);
var inst_48099 = (state_48418[(18)]);
var inst_48100 = (state_48418[(19)]);
var inst_48098 = (state_48418[(2)]);
var inst_48099__$1 = cljs.core.__destructure_map(inst_48087);
var inst_48100__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48099__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_48101 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48099__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_48102 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48099__$1,cljs.core.cst$kw$limit);
var inst_48103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48099__$1,cljs.core.cst$kw$orderBy);
var inst_48104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48099__$1,cljs.core.cst$kw$offset);
var inst_48105 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48099__$1,cljs.core.cst$kw$p);
var state_48418__$1 = (function (){var statearr_48430 = state_48418;
(statearr_48430[(20)] = inst_48105);

(statearr_48430[(18)] = inst_48099__$1);

(statearr_48430[(21)] = inst_48104);

(statearr_48430[(19)] = inst_48100__$1);

(statearr_48430[(22)] = inst_48102);

(statearr_48430[(23)] = inst_48098);

(statearr_48430[(24)] = inst_48103);

(statearr_48430[(25)] = inst_48101);

return statearr_48430;
})();
if(cljs.core.truth_(inst_48100__$1)){
var statearr_48431_48614 = state_48418__$1;
(statearr_48431_48614[(1)] = (24));

} else {
var statearr_48432_48615 = state_48418__$1;
(statearr_48432_48615[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (72))){
var inst_48380 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48433_48616 = state_48418__$1;
(statearr_48433_48616[(2)] = inst_48380);

(statearr_48433_48616[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (58))){
var inst_48087 = (state_48418[(17)]);
var inst_48222 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_48087);
var state_48418__$1 = state_48418;
if(cljs.core.truth_(inst_48222)){
var statearr_48434_48617 = state_48418__$1;
(statearr_48434_48617[(1)] = (70));

} else {
var statearr_48435_48618 = state_48418__$1;
(statearr_48435_48618[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (60))){
var inst_48184 = (state_48418[(26)]);
var inst_48191 = (state_48418[(13)]);
var inst_48190 = cljs.core.seq(inst_48184);
var inst_48191__$1 = cljs.core.first(inst_48190);
var inst_48192 = cljs.core.next(inst_48190);
var state_48418__$1 = (function (){var statearr_48436 = state_48418;
(statearr_48436[(13)] = inst_48191__$1);

(statearr_48436[(27)] = inst_48192);

return statearr_48436;
})();
if(cljs.core.truth_(inst_48191__$1)){
var statearr_48437_48619 = state_48418__$1;
(statearr_48437_48619[(1)] = (62));

} else {
var statearr_48438_48620 = state_48418__$1;
(statearr_48438_48620[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (27))){
var inst_48104 = (state_48418[(21)]);
var inst_48108 = (state_48418[(28)]);
var inst_48108__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_48104);
var state_48418__$1 = (function (){var statearr_48439 = state_48418;
(statearr_48439[(28)] = inst_48108__$1);

return statearr_48439;
})();
if(inst_48108__$1){
var statearr_48440_48621 = state_48418__$1;
(statearr_48440_48621[(1)] = (30));

} else {
var statearr_48441_48622 = state_48418__$1;
(statearr_48441_48622[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (1))){
var state_48418__$1 = state_48418;
var statearr_48442_48623 = state_48418__$1;
(statearr_48442_48623[(2)] = null);

(statearr_48442_48623[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (69))){
var inst_48185 = (state_48418[(29)]);
var inst_48192 = (state_48418[(27)]);
var inst_48210 = (state_48418[(2)]);
var inst_48211 = fluree.db.util.async.throw_err(inst_48210);
var inst_48212 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_48185,inst_48211);
var inst_48184 = inst_48192;
var inst_48185__$1 = inst_48212;
var state_48418__$1 = (function (){var statearr_48443 = state_48418;
(statearr_48443[(29)] = inst_48185__$1);

(statearr_48443[(26)] = inst_48184);

return statearr_48443;
})();
var statearr_48444_48624 = state_48418__$1;
(statearr_48444_48624[(2)] = null);

(statearr_48444_48624[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (101))){
var inst_48325 = (state_48418[(30)]);
var inst_48345 = cljs.core.count(inst_48325);
var inst_48346 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_48345);
var state_48418__$1 = state_48418;
var statearr_48445_48625 = state_48418__$1;
(statearr_48445_48625[(2)] = inst_48346);

(statearr_48445_48625[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (24))){
var inst_48104 = (state_48418[(21)]);
var state_48418__$1 = state_48418;
if(cljs.core.truth_(inst_48104)){
var statearr_48446_48626 = state_48418__$1;
(statearr_48446_48626[(1)] = (27));

} else {
var statearr_48447_48627 = state_48418__$1;
(statearr_48447_48627[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (102))){
var state_48418__$1 = state_48418;
var statearr_48448_48628 = state_48418__$1;
(statearr_48448_48628[(2)] = null);

(statearr_48448_48628[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (55))){
var inst_48087 = (state_48418[(17)]);
var inst_48160 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_48087);
var state_48418__$1 = state_48418;
var statearr_48449_48629 = state_48418__$1;
(statearr_48449_48629[(2)] = inst_48160);

(statearr_48449_48629[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (85))){
var inst_48087 = (state_48418[(17)]);
var inst_48286 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_48087);
var state_48418__$1 = state_48418;
var statearr_48450_48630 = state_48418__$1;
(statearr_48450_48630[(2)] = inst_48286);

(statearr_48450_48630[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (39))){
var inst_48135 = (state_48418[(31)]);
var inst_48103 = (state_48418[(24)]);
var inst_48135__$1 = cljs.core.not(inst_48103);
var state_48418__$1 = (function (){var statearr_48451 = state_48418;
(statearr_48451[(31)] = inst_48135__$1);

return statearr_48451;
})();
if(inst_48135__$1){
var statearr_48452_48631 = state_48418__$1;
(statearr_48452_48631[(1)] = (42));

} else {
var statearr_48453_48632 = state_48418__$1;
(statearr_48453_48632[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (88))){
var inst_48291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48299 = flakes;
var inst_48300 = cljs.core.seq(inst_48299);
var inst_48301 = cljs.core.first(inst_48300);
var inst_48302 = cljs.core.next(inst_48300);
var inst_48303 = cljs.core.PersistentVector.EMPTY;
var inst_48304 = inst_48299;
var inst_48305 = inst_48303;
var state_48418__$1 = (function (){var statearr_48454 = state_48418;
(statearr_48454[(32)] = inst_48301);

(statearr_48454[(33)] = inst_48302);

(statearr_48454[(34)] = inst_48305);

(statearr_48454[(35)] = inst_48291);

(statearr_48454[(36)] = inst_48304);

return statearr_48454;
})();
var statearr_48455_48633 = state_48418__$1;
(statearr_48455_48633[(2)] = null);

(statearr_48455_48633[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (46))){
var inst_48102 = (state_48418[(22)]);
var state_48418__$1 = state_48418;
var statearr_48456_48634 = state_48418__$1;
(statearr_48456_48634[(2)] = inst_48102);

(statearr_48456_48634[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (4))){
var inst_48047 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48457_48635 = state_48418__$1;
(statearr_48457_48635[(2)] = inst_48047);

(statearr_48457_48635[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (77))){
var inst_48278 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48458_48636 = state_48418__$1;
(statearr_48458_48636[(2)] = inst_48278);

(statearr_48458_48636[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (106))){
var inst_48376 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48459_48637 = state_48418__$1;
(statearr_48459_48637[(2)] = inst_48376);

(statearr_48459_48637[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (95))){
var inst_48353 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48460_48638 = state_48418__$1;
(statearr_48460_48638[(2)] = inst_48353);

(statearr_48460_48638[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (54))){
var inst_48157 = (state_48418[(37)]);
var state_48418__$1 = state_48418;
var statearr_48461_48639 = state_48418__$1;
(statearr_48461_48639[(2)] = inst_48157);

(statearr_48461_48639[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (92))){
var inst_48291 = (state_48418[(35)]);
var inst_48355 = (state_48418[(2)]);
var inst_48356 = [inst_48355,offset_map];
var inst_48357 = (new cljs.core.PersistentVector(null,2,(5),inst_48291,inst_48356,null));
var state_48418__$1 = state_48418;
var statearr_48462_48640 = state_48418__$1;
(statearr_48462_48640[(2)] = inst_48357);

(statearr_48462_48640[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (104))){
var inst_48087 = (state_48418[(17)]);
var inst_48105 = (state_48418[(20)]);
var inst_48099 = (state_48418[(18)]);
var inst_48057 = (state_48418[(38)]);
var inst_48104 = (state_48418[(21)]);
var inst_48100 = (state_48418[(19)]);
var inst_48072 = (state_48418[(39)]);
var inst_48102 = (state_48418[(22)]);
var inst_48098 = (state_48418[(23)]);
var inst_48103 = (state_48418[(24)]);
var inst_48101 = (state_48418[(25)]);
var inst_48360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48361 = (function (){var p = inst_48105;
var pred_spec__$1 = inst_48072;
var orderBy = inst_48103;
var multi_QMARK_ = inst_48100;
var limit = inst_48102;
var offset = inst_48104;
var map__48053 = inst_48099;
var k = inst_48098;
var compact_QMARK_ = inst_48057;
var pred_spec_SINGLEQUOTE_ = inst_48087;
var ref_QMARK_ = inst_48101;
return (function (p1__48043_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$_id],[p1__48043_SHARP_.o]);
});
})();
var inst_48362 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_48361,flakes);
var inst_48363 = [inst_48362,offset_map];
var inst_48364 = (new cljs.core.PersistentVector(null,2,(5),inst_48360,inst_48363,null));
var state_48418__$1 = state_48418;
var statearr_48463_48641 = state_48418__$1;
(statearr_48463_48641[(2)] = inst_48364);

(statearr_48463_48641[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (15))){
var inst_48080 = (state_48418[(40)]);
var inst_48057 = (state_48418[(38)]);
var inst_48084 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_48080,cljs.core.cst$kw$compact_QMARK_,inst_48057);
var state_48418__$1 = state_48418;
var statearr_48464_48642 = state_48418__$1;
(statearr_48464_48642[(2)] = inst_48084);

(statearr_48464_48642[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (48))){
var inst_48151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48152 = [null,offset_map];
var inst_48153 = (new cljs.core.PersistentVector(null,2,(5),inst_48151,inst_48152,null));
var state_48418__$1 = state_48418;
var statearr_48465_48643 = state_48418__$1;
(statearr_48465_48643[(2)] = inst_48153);

(statearr_48465_48643[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (50))){
var inst_48384 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48466_48644 = state_48418__$1;
(statearr_48466_48644[(2)] = inst_48384);

(statearr_48466_48644[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (116))){
var inst_48387 = (state_48418[(41)]);
var inst_48098 = (state_48418[(23)]);
var inst_48388 = (state_48418[(14)]);
var inst_48402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48403 = cljs.core.first(inst_48387);
var inst_48404 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_48098,inst_48403);
var inst_48405 = [inst_48404,inst_48388];
var inst_48406 = (new cljs.core.PersistentVector(null,2,(5),inst_48402,inst_48405,null));
var state_48418__$1 = state_48418;
var statearr_48467_48645 = state_48418__$1;
(statearr_48467_48645[(2)] = inst_48406);

(statearr_48467_48645[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (75))){
var inst_48087 = (state_48418[(17)]);
var inst_48253 = (state_48418[(42)]);
var inst_48244 = (state_48418[(43)]);
var inst_48247 = cljs.core.deref(cache);
var inst_48248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48249 = inst_48244.o;
var inst_48250 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_48087);
var inst_48251 = [inst_48249,inst_48250];
var inst_48252 = (new cljs.core.PersistentVector(null,2,(5),inst_48248,inst_48251,null));
var inst_48253__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48247,inst_48252);
var state_48418__$1 = (function (){var statearr_48468 = state_48418;
(statearr_48468[(42)] = inst_48253__$1);

return statearr_48468;
})();
if(cljs.core.truth_(inst_48253__$1)){
var statearr_48469_48646 = state_48418__$1;
(statearr_48469_48646[(1)] = (78));

} else {
var statearr_48470_48647 = state_48418__$1;
(statearr_48470_48647[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (99))){
var inst_48343 = (state_48418[(2)]);
var state_48418__$1 = (function (){var statearr_48471 = state_48418;
(statearr_48471[(44)] = inst_48343);

return statearr_48471;
})();
if(cljs.core.truth_(fuel)){
var statearr_48472_48648 = state_48418__$1;
(statearr_48472_48648[(1)] = (101));

} else {
var statearr_48473_48649 = state_48418__$1;
(statearr_48473_48649[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (21))){
var inst_48091 = (state_48418[(45)]);
var state_48418__$1 = state_48418;
var statearr_48474_48650 = state_48418__$1;
(statearr_48474_48650[(2)] = inst_48091);

(statearr_48474_48650[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (31))){
var inst_48108 = (state_48418[(28)]);
var state_48418__$1 = state_48418;
var statearr_48475_48651 = state_48418__$1;
(statearr_48475_48651[(2)] = inst_48108);

(statearr_48475_48651[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (113))){
var inst_48387 = (state_48418[(41)]);
var inst_48098 = (state_48418[(23)]);
var inst_48388 = (state_48418[(14)]);
var inst_48396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48397 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_48098,inst_48387);
var inst_48398 = [inst_48397,inst_48388];
var inst_48399 = (new cljs.core.PersistentVector(null,2,(5),inst_48396,inst_48398,null));
var state_48418__$1 = state_48418;
var statearr_48476_48652 = state_48418__$1;
(statearr_48476_48652[(2)] = inst_48399);

(statearr_48476_48652[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (32))){
var inst_48114 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48477_48653 = state_48418__$1;
(statearr_48477_48653[(2)] = inst_48114);

(statearr_48477_48653[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (40))){
var inst_48100 = (state_48418[(19)]);
var state_48418__$1 = state_48418;
var statearr_48478_48654 = state_48418__$1;
(statearr_48478_48654[(2)] = inst_48100);

(statearr_48478_48654[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (91))){
var inst_48311 = (state_48418[(46)]);
var inst_48304 = (state_48418[(36)]);
var inst_48310 = cljs.core.seq(inst_48304);
var inst_48311__$1 = cljs.core.first(inst_48310);
var inst_48312 = cljs.core.next(inst_48310);
var state_48418__$1 = (function (){var statearr_48479 = state_48418;
(statearr_48479[(46)] = inst_48311__$1);

(statearr_48479[(47)] = inst_48312);

return statearr_48479;
})();
if(cljs.core.truth_(inst_48311__$1)){
var statearr_48480_48655 = state_48418__$1;
(statearr_48480_48655[(1)] = (93));

} else {
var statearr_48481_48656 = state_48418__$1;
(statearr_48481_48656[(1)] = (94));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (117))){
var state_48418__$1 = state_48418;
var statearr_48482_48657 = state_48418__$1;
(statearr_48482_48657[(2)] = null);

(statearr_48482_48657[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (108))){
var state_48418__$1 = state_48418;
var statearr_48483_48658 = state_48418__$1;
(statearr_48483_48658[(2)] = null);

(statearr_48483_48658[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (56))){
var inst_48162 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48484_48659 = state_48418__$1;
(statearr_48484_48659[(2)] = inst_48162);

(statearr_48484_48659[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (33))){
var inst_48105 = (state_48418[(20)]);
var inst_48122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48123 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_48105);
var state_48418__$1 = (function (){var statearr_48485 = state_48418;
(statearr_48485[(48)] = inst_48122);

return statearr_48485;
})();
if(cljs.core.truth_(inst_48123)){
var statearr_48486_48660 = state_48418__$1;
(statearr_48486_48660[(1)] = (36));

} else {
var statearr_48487_48661 = state_48418__$1;
(statearr_48487_48661[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (13))){
var inst_48072 = (state_48418[(39)]);
var state_48418__$1 = state_48418;
var statearr_48488_48662 = state_48418__$1;
(statearr_48488_48662[(2)] = inst_48072);

(statearr_48488_48662[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (22))){
var inst_48087 = (state_48418[(17)]);
var inst_48094 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_48087);
var state_48418__$1 = state_48418;
var statearr_48489_48663 = state_48418__$1;
(statearr_48489_48663[(2)] = inst_48094);

(statearr_48489_48663[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (90))){
var inst_48378 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48490_48664 = state_48418__$1;
(statearr_48490_48664[(2)] = inst_48378);

(statearr_48490_48664[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (109))){
var inst_48374 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48491_48665 = state_48418__$1;
(statearr_48491_48665[(2)] = inst_48374);

(statearr_48491_48665[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (36))){
var inst_48105 = (state_48418[(20)]);
var inst_48125 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_48105,cljs.core.dec);
var state_48418__$1 = state_48418;
var statearr_48492_48666 = state_48418__$1;
(statearr_48492_48666[(2)] = inst_48125);

(statearr_48492_48666[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (41))){
var inst_48149 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
if(cljs.core.truth_(inst_48149)){
var statearr_48493_48667 = state_48418__$1;
(statearr_48493_48667[(1)] = (48));

} else {
var statearr_48494_48668 = state_48418__$1;
(statearr_48494_48668[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (118))){
var inst_48409 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48495_48669 = state_48418__$1;
(statearr_48495_48669[(2)] = inst_48409);

(statearr_48495_48669[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (89))){
var inst_48101 = (state_48418[(25)]);
var state_48418__$1 = state_48418;
if(cljs.core.truth_(inst_48101)){
var statearr_48496_48670 = state_48418__$1;
(statearr_48496_48670[(1)] = (104));

} else {
var statearr_48497_48671 = state_48418__$1;
(statearr_48497_48671[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (100))){
var inst_48305 = (state_48418[(34)]);
var inst_48339 = (state_48418[(2)]);
var inst_48340 = fluree.db.util.async.throw_err(inst_48339);
var inst_48341 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_48305,inst_48340);
var state_48418__$1 = state_48418;
var statearr_48498_48672 = state_48418__$1;
(statearr_48498_48672[(2)] = inst_48341);

(statearr_48498_48672[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (43))){
var inst_48135 = (state_48418[(31)]);
var state_48418__$1 = state_48418;
var statearr_48499_48673 = state_48418__$1;
(statearr_48499_48673[(2)] = inst_48135);

(statearr_48499_48673[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (61))){
var inst_48171 = (state_48418[(49)]);
var inst_48218 = (state_48418[(2)]);
var inst_48219 = [inst_48218,offset_map];
var inst_48220 = (new cljs.core.PersistentVector(null,2,(5),inst_48171,inst_48219,null));
var state_48418__$1 = state_48418;
var statearr_48500_48674 = state_48418__$1;
(statearr_48500_48674[(2)] = inst_48220);

(statearr_48500_48674[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (29))){
var inst_48117 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48501_48675 = state_48418__$1;
(statearr_48501_48675[(2)] = inst_48117);

(statearr_48501_48675[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (44))){
var inst_48146 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48502_48676 = state_48418__$1;
(statearr_48502_48676[(2)] = inst_48146);

(statearr_48502_48676[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (93))){
var inst_48087 = (state_48418[(17)]);
var inst_48311 = (state_48418[(46)]);
var inst_48314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48315 = inst_48311.o;
var inst_48316 = [inst_48315];
var inst_48317 = (new cljs.core.PersistentVector(null,1,(5),inst_48314,inst_48316,null));
var inst_48318 = [cljs.core.cst$kw$limit];
var inst_48319 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_48087);
var inst_48320 = [inst_48319];
var inst_48321 = cljs.core.PersistentHashMap.fromArrays(inst_48318,inst_48320);
var inst_48322 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_48317,inst_48321);
var state_48418__$1 = state_48418;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48418__$1,(96),inst_48322);
} else {
if((state_val_48419 === (6))){
var inst_48060 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_48061 = (inst_48060 == null);
var state_48418__$1 = state_48418;
var statearr_48503_48677 = state_48418__$1;
(statearr_48503_48677[(2)] = inst_48061);

(statearr_48503_48677[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (111))){
var inst_48100 = (state_48418[(19)]);
var state_48418__$1 = state_48418;
if(cljs.core.truth_(inst_48100)){
var statearr_48504_48678 = state_48418__$1;
(statearr_48504_48678[(1)] = (113));

} else {
var statearr_48505_48679 = state_48418__$1;
(statearr_48505_48679[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (28))){
var inst_48104 = (state_48418[(21)]);
var state_48418__$1 = state_48418;
var statearr_48506_48680 = state_48418__$1;
(statearr_48506_48680[(2)] = inst_48104);

(statearr_48506_48680[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (64))){
var inst_48216 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48507_48681 = state_48418__$1;
(statearr_48507_48681[(2)] = inst_48216);

(statearr_48507_48681[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (103))){
var inst_48343 = (state_48418[(44)]);
var inst_48312 = (state_48418[(47)]);
var inst_48349 = (state_48418[(2)]);
var inst_48304 = inst_48312;
var inst_48305 = inst_48343;
var state_48418__$1 = (function (){var statearr_48508 = state_48418;
(statearr_48508[(50)] = inst_48349);

(statearr_48508[(34)] = inst_48305);

(statearr_48508[(36)] = inst_48304);

return statearr_48508;
})();
var statearr_48509_48682 = state_48418__$1;
(statearr_48509_48682[(2)] = null);

(statearr_48509_48682[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (51))){
var inst_48087 = (state_48418[(17)]);
var inst_48157 = (state_48418[(37)]);
var inst_48157__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_48087);
var state_48418__$1 = (function (){var statearr_48510 = state_48418;
(statearr_48510[(37)] = inst_48157__$1);

return statearr_48510;
})();
if(cljs.core.truth_(inst_48157__$1)){
var statearr_48511_48683 = state_48418__$1;
(statearr_48511_48683[(1)] = (54));

} else {
var statearr_48512_48684 = state_48418__$1;
(statearr_48512_48684[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (25))){
var inst_48100 = (state_48418[(19)]);
var state_48418__$1 = state_48418;
var statearr_48513_48685 = state_48418__$1;
(statearr_48513_48685[(2)] = inst_48100);

(statearr_48513_48685[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (34))){
var inst_48100 = (state_48418[(19)]);
var state_48418__$1 = state_48418;
if(cljs.core.truth_(inst_48100)){
var statearr_48514_48686 = state_48418__$1;
(statearr_48514_48686[(1)] = (39));

} else {
var statearr_48515_48687 = state_48418__$1;
(statearr_48515_48687[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (17))){
var inst_48087 = (state_48418[(17)]);
var inst_48088 = (state_48418[(51)]);
var inst_48087__$1 = (state_48418[(2)]);
var inst_48088__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_48087__$1);
var state_48418__$1 = (function (){var statearr_48516 = state_48418;
(statearr_48516[(17)] = inst_48087__$1);

(statearr_48516[(51)] = inst_48088__$1);

return statearr_48516;
})();
if(cljs.core.truth_(inst_48088__$1)){
var statearr_48517_48688 = state_48418__$1;
(statearr_48517_48688[(1)] = (18));

} else {
var statearr_48518_48689 = state_48418__$1;
(statearr_48518_48689[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (3))){
var inst_48416 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48418__$1,inst_48416);
} else {
if((state_val_48419 === (12))){
var inst_48072 = (state_48418[(39)]);
var inst_48077 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_48072,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_48418__$1 = state_48418;
var statearr_48519_48690 = state_48418__$1;
(statearr_48519_48690[(2)] = inst_48077);

(statearr_48519_48690[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (2))){
var inst_48058 = (state_48418[(15)]);
var _ = (function (){var statearr_48520 = state_48418;
(statearr_48520[(4)] = cljs.core.cons((5),(state_48418[(4)])));

return statearr_48520;
})();
var inst_48057 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_48058__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_48418__$1 = (function (){var statearr_48521 = state_48418;
(statearr_48521[(38)] = inst_48057);

(statearr_48521[(15)] = inst_48058__$1);

return statearr_48521;
})();
if(cljs.core.truth_(inst_48058__$1)){
var statearr_48522_48691 = state_48418__$1;
(statearr_48522_48691[(1)] = (6));

} else {
var statearr_48523_48692 = state_48418__$1;
(statearr_48523_48692[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (66))){
var inst_48201 = (state_48418[(7)]);
var inst_48203 = cljs.core.count(inst_48201);
var inst_48204 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_48203);
var state_48418__$1 = state_48418;
var statearr_48524_48693 = state_48418__$1;
(statearr_48524_48693[(2)] = inst_48204);

(statearr_48524_48693[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (107))){
var inst_48087 = (state_48418[(17)]);
var inst_48105 = (state_48418[(20)]);
var inst_48099 = (state_48418[(18)]);
var inst_48057 = (state_48418[(38)]);
var inst_48104 = (state_48418[(21)]);
var inst_48100 = (state_48418[(19)]);
var inst_48072 = (state_48418[(39)]);
var inst_48102 = (state_48418[(22)]);
var inst_48098 = (state_48418[(23)]);
var inst_48103 = (state_48418[(24)]);
var inst_48101 = (state_48418[(25)]);
var inst_48367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48368 = (function (){var p = inst_48105;
var pred_spec__$1 = inst_48072;
var orderBy = inst_48103;
var multi_QMARK_ = inst_48100;
var limit = inst_48102;
var offset = inst_48104;
var map__48053 = inst_48099;
var k = inst_48098;
var compact_QMARK_ = inst_48057;
var pred_spec_SINGLEQUOTE_ = inst_48087;
var ref_QMARK_ = inst_48101;
return (function (p1__48044_SHARP_){
return p1__48044_SHARP_.o;
});
})();
var inst_48369 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_48368,flakes);
var inst_48370 = [inst_48369,offset_map];
var inst_48371 = (new cljs.core.PersistentVector(null,2,(5),inst_48367,inst_48370,null));
var state_48418__$1 = state_48418;
var statearr_48525_48694 = state_48418__$1;
(statearr_48525_48694[(2)] = inst_48371);

(statearr_48525_48694[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (23))){
var inst_48096 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48526_48695 = state_48418__$1;
(statearr_48526_48695[(2)] = inst_48096);

(statearr_48526_48695[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (47))){
var inst_48143 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48527_48696 = state_48418__$1;
(statearr_48527_48696[(2)] = inst_48143);

(statearr_48527_48696[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (35))){
var inst_48387 = (state_48418[(41)]);
var inst_48386 = (state_48418[(2)]);
var inst_48387__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48386,(0),null);
var inst_48388 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48386,(1),null);
var inst_48389 = cljs.core.empty_QMARK_(inst_48387__$1);
var state_48418__$1 = (function (){var statearr_48528 = state_48418;
(statearr_48528[(41)] = inst_48387__$1);

(statearr_48528[(14)] = inst_48388);

return statearr_48528;
})();
if(inst_48389){
var statearr_48529_48697 = state_48418__$1;
(statearr_48529_48697[(1)] = (110));

} else {
var statearr_48530_48698 = state_48418__$1;
(statearr_48530_48698[(1)] = (111));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (82))){
var inst_48238 = (state_48418[(10)]);
var inst_48269 = (state_48418[(52)]);
var inst_48271 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_48238,inst_48269);
var state_48418__$1 = state_48418;
var statearr_48531_48699 = state_48418__$1;
(statearr_48531_48699[(2)] = inst_48271);

(statearr_48531_48699[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (76))){
var inst_48238 = (state_48418[(10)]);
var state_48418__$1 = state_48418;
var statearr_48532_48700 = state_48418__$1;
(statearr_48532_48700[(2)] = inst_48238);

(statearr_48532_48700[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (97))){
var inst_48305 = (state_48418[(34)]);
var inst_48311 = (state_48418[(46)]);
var inst_48328 = [cljs.core.cst$kw$_id];
var inst_48329 = inst_48311.o;
var inst_48330 = [inst_48329];
var inst_48331 = cljs.core.PersistentHashMap.fromArrays(inst_48328,inst_48330);
var inst_48332 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_48305,inst_48331);
var state_48418__$1 = state_48418;
var statearr_48533_48701 = state_48418__$1;
(statearr_48533_48701[(2)] = inst_48332);

(statearr_48533_48701[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (19))){
var inst_48087 = (state_48418[(17)]);
var inst_48091 = (state_48418[(45)]);
var inst_48091__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_48087);
var state_48418__$1 = (function (){var statearr_48534 = state_48418;
(statearr_48534[(45)] = inst_48091__$1);

return statearr_48534;
})();
if(cljs.core.truth_(inst_48091__$1)){
var statearr_48535_48702 = state_48418__$1;
(statearr_48535_48702[(1)] = (21));

} else {
var statearr_48536_48703 = state_48418__$1;
(statearr_48536_48703[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (57))){
var inst_48087 = (state_48418[(17)]);
var inst_48167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48168 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_48169 = (new cljs.core.PersistentVector(null,3,(5),inst_48167,inst_48168,null));
var inst_48170 = cljs.core.select_keys(inst_48087,inst_48169);
var inst_48171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48179 = flakes;
var inst_48180 = cljs.core.seq(inst_48179);
var inst_48181 = cljs.core.first(inst_48180);
var inst_48182 = cljs.core.next(inst_48180);
var inst_48183 = cljs.core.PersistentVector.EMPTY;
var inst_48184 = inst_48179;
var inst_48185 = inst_48183;
var state_48418__$1 = (function (){var statearr_48537 = state_48418;
(statearr_48537[(29)] = inst_48185);

(statearr_48537[(26)] = inst_48184);

(statearr_48537[(53)] = inst_48182);

(statearr_48537[(49)] = inst_48171);

(statearr_48537[(54)] = inst_48181);

(statearr_48537[(55)] = inst_48170);

return statearr_48537;
})();
var statearr_48538_48704 = state_48418__$1;
(statearr_48538_48704[(2)] = null);

(statearr_48538_48704[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (68))){
var inst_48201 = (state_48418[(7)]);
var inst_48170 = (state_48418[(55)]);
var inst_48207 = (state_48418[(2)]);
var inst_48208 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_48170,inst_48201) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_48170,inst_48201));
var state_48418__$1 = (function (){var statearr_48539 = state_48418;
(statearr_48539[(56)] = inst_48207);

return statearr_48539;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48418__$1,(69),inst_48208);
} else {
if((state_val_48419 === (11))){
var inst_48072 = (state_48418[(39)]);
var inst_48072__$1 = (state_48418[(2)]);
var inst_48074 = cljs.core.contains_QMARK_(inst_48072__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var inst_48075 = (!(inst_48074));
var state_48418__$1 = (function (){var statearr_48540 = state_48418;
(statearr_48540[(39)] = inst_48072__$1);

return statearr_48540;
})();
if(inst_48075){
var statearr_48541_48705 = state_48418__$1;
(statearr_48541_48705[(1)] = (12));

} else {
var statearr_48542_48706 = state_48418__$1;
(statearr_48542_48706[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (115))){
var inst_48411 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
var statearr_48544_48707 = state_48418__$1;
(statearr_48544_48707[(2)] = inst_48411);

(statearr_48544_48707[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (9))){
var inst_48066 = cljs.core.first(flakes);
var inst_48067 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_48066);
var inst_48068 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_48069 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_48067,inst_48068);
var state_48418__$1 = state_48418;
var statearr_48545_48708 = state_48418__$1;
(statearr_48545_48708[(2)] = inst_48069);

(statearr_48545_48708[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (5))){
var _ = (function (){var statearr_48546 = state_48418;
(statearr_48546[(4)] = cljs.core.rest((state_48418[(4)])));

return statearr_48546;
})();
var state_48418__$1 = state_48418;
var ex48543 = (state_48418__$1[(2)]);
var statearr_48547_48709 = state_48418__$1;
(statearr_48547_48709[(5)] = ex48543);


if((ex48543 instanceof Error)){
var statearr_48548_48710 = state_48418__$1;
(statearr_48548_48710[(1)] = (4));

(statearr_48548_48710[(5)] = null);

} else {
throw ex48543;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (112))){
var inst_48413 = (state_48418[(2)]);
var _ = (function (){var statearr_48549 = state_48418;
(statearr_48549[(4)] = cljs.core.rest((state_48418[(4)])));

return statearr_48549;
})();
var state_48418__$1 = state_48418;
var statearr_48550_48711 = state_48418__$1;
(statearr_48550_48711[(2)] = inst_48413);

(statearr_48550_48711[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (83))){
var inst_48238 = (state_48418[(10)]);
var state_48418__$1 = state_48418;
var statearr_48551_48712 = state_48418__$1;
(statearr_48551_48712[(2)] = inst_48238);

(statearr_48551_48712[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (14))){
var inst_48072 = (state_48418[(39)]);
var inst_48080 = (state_48418[(2)]);
var inst_48081 = cljs.core.contains_QMARK_(inst_48072,cljs.core.cst$kw$compact_QMARK_);
var inst_48082 = (!(inst_48081));
var state_48418__$1 = (function (){var statearr_48552 = state_48418;
(statearr_48552[(40)] = inst_48080);

return statearr_48552;
})();
if(inst_48082){
var statearr_48553_48713 = state_48418__$1;
(statearr_48553_48713[(1)] = (15));

} else {
var statearr_48554_48714 = state_48418__$1;
(statearr_48554_48714[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (45))){
var inst_48102 = (state_48418[(22)]);
var inst_48098 = (state_48418[(23)]);
var inst_48138 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_48098);
var inst_48139 = cljs.core.count(inst_48138);
var inst_48140 = (inst_48139 >= inst_48102);
var state_48418__$1 = state_48418;
var statearr_48555_48715 = state_48418__$1;
(statearr_48555_48715[(2)] = inst_48140);

(statearr_48555_48715[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (53))){
var inst_48165 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
if(cljs.core.truth_(inst_48165)){
var statearr_48556_48716 = state_48418__$1;
(statearr_48556_48716[(1)] = (57));

} else {
var statearr_48557_48717 = state_48418__$1;
(statearr_48557_48717[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (78))){
var inst_48253 = (state_48418[(42)]);
var state_48418__$1 = state_48418;
var statearr_48558_48718 = state_48418__$1;
(statearr_48558_48718[(2)] = inst_48253);

(statearr_48558_48718[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (26))){
var inst_48120 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
if(cljs.core.truth_(inst_48120)){
var statearr_48559_48719 = state_48418__$1;
(statearr_48559_48719[(1)] = (33));

} else {
var statearr_48560_48720 = state_48418__$1;
(statearr_48560_48720[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (16))){
var inst_48080 = (state_48418[(40)]);
var state_48418__$1 = state_48418;
var statearr_48561_48721 = state_48418__$1;
(statearr_48561_48721[(2)] = inst_48080);

(statearr_48561_48721[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (81))){
var inst_48087 = (state_48418[(17)]);
var inst_48244 = (state_48418[(43)]);
var inst_48260 = (state_48418[(2)]);
var inst_48261 = fluree.db.util.async.throw_err(inst_48260);
var inst_48262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48263 = inst_48244.o;
var inst_48264 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_48087);
var inst_48265 = [inst_48263,inst_48264];
var inst_48266 = (new cljs.core.PersistentVector(null,2,(5),inst_48262,inst_48265,null));
var inst_48267 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_48266,inst_48261);
var state_48418__$1 = (function (){var statearr_48562 = state_48418;
(statearr_48562[(57)] = inst_48267);

return statearr_48562;
})();
var statearr_48563_48722 = state_48418__$1;
(statearr_48563_48722[(2)] = inst_48261);

(statearr_48563_48722[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (79))){
var inst_48087 = (state_48418[(17)]);
var inst_48244 = (state_48418[(43)]);
var inst_48256 = inst_48244.o;
var inst_48257 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_48087);
var inst_48258 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_48256,inst_48257);
var state_48418__$1 = state_48418;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48418__$1,(81),inst_48258);
} else {
if((state_val_48419 === (38))){
var inst_48122 = (state_48418[(48)]);
var inst_48130 = (state_48418[(2)]);
var inst_48131 = [null,inst_48130];
var inst_48132 = (new cljs.core.PersistentVector(null,2,(5),inst_48122,inst_48131,null));
var state_48418__$1 = state_48418;
var statearr_48564_48723 = state_48418__$1;
(statearr_48564_48723[(2)] = inst_48132);

(statearr_48564_48723[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (98))){
var inst_48325 = (state_48418[(30)]);
var inst_48057 = (state_48418[(38)]);
var inst_48334 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_];
var inst_48335 = [true,inst_48057];
var inst_48336 = cljs.core.PersistentHashMap.fromArrays(inst_48334,inst_48335);
var inst_48337 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_48336,inst_48325) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_48336,inst_48325));
var state_48418__$1 = state_48418;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48418__$1,(100),inst_48337);
} else {
if((state_val_48419 === (87))){
var inst_48289 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
if(cljs.core.truth_(inst_48289)){
var statearr_48565_48724 = state_48418__$1;
(statearr_48565_48724[(1)] = (88));

} else {
var statearr_48566_48725 = state_48418__$1;
(statearr_48566_48725[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (30))){
var inst_48105 = (state_48418[(20)]);
var inst_48110 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_48105);
var inst_48111 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_48110);
var state_48418__$1 = state_48418;
var statearr_48567_48726 = state_48418__$1;
(statearr_48567_48726[(2)] = inst_48111);

(statearr_48567_48726[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (73))){
var inst_48244 = (state_48418[(43)]);
var inst_48237 = (state_48418[(11)]);
var inst_48243 = cljs.core.seq(inst_48237);
var inst_48244__$1 = cljs.core.first(inst_48243);
var inst_48245 = cljs.core.next(inst_48243);
var state_48418__$1 = (function (){var statearr_48568 = state_48418;
(statearr_48568[(58)] = inst_48245);

(statearr_48568[(43)] = inst_48244__$1);

return statearr_48568;
})();
if(cljs.core.truth_(inst_48244__$1)){
var statearr_48569_48727 = state_48418__$1;
(statearr_48569_48727[(1)] = (75));

} else {
var statearr_48570_48728 = state_48418__$1;
(statearr_48570_48728[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (96))){
var inst_48325 = (state_48418[(30)]);
var inst_48324 = (state_48418[(2)]);
var inst_48325__$1 = fluree.db.util.async.throw_err(inst_48324);
var inst_48326 = cljs.core.empty_QMARK_(inst_48325__$1);
var state_48418__$1 = (function (){var statearr_48571 = state_48418;
(statearr_48571[(30)] = inst_48325__$1);

return statearr_48571;
})();
if(inst_48326){
var statearr_48572_48729 = state_48418__$1;
(statearr_48572_48729[(1)] = (97));

} else {
var statearr_48573_48730 = state_48418__$1;
(statearr_48573_48730[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (10))){
var state_48418__$1 = state_48418;
var statearr_48574_48731 = state_48418__$1;
(statearr_48574_48731[(2)] = pred_spec);

(statearr_48574_48731[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (18))){
var inst_48088 = (state_48418[(51)]);
var state_48418__$1 = state_48418;
var statearr_48575_48732 = state_48418__$1;
(statearr_48575_48732[(2)] = inst_48088);

(statearr_48575_48732[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (105))){
var state_48418__$1 = state_48418;
var statearr_48576_48733 = state_48418__$1;
(statearr_48576_48733[(1)] = (107));



return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (52))){
var inst_48155 = (state_48418[(59)]);
var state_48418__$1 = state_48418;
var statearr_48578_48734 = state_48418__$1;
(statearr_48578_48734[(2)] = inst_48155);

(statearr_48578_48734[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (114))){
var state_48418__$1 = state_48418;
var statearr_48579_48735 = state_48418__$1;
(statearr_48579_48735[(1)] = (116));



return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (67))){
var state_48418__$1 = state_48418;
var statearr_48581_48736 = state_48418__$1;
(statearr_48581_48736[(2)] = null);

(statearr_48581_48736[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (71))){
var inst_48284 = (state_48418[(16)]);
var inst_48284__$1 = componentFollow_QMARK_;
var state_48418__$1 = (function (){var statearr_48582 = state_48418;
(statearr_48582[(16)] = inst_48284__$1);

return statearr_48582;
})();
if(cljs.core.truth_(inst_48284__$1)){
var statearr_48583_48737 = state_48418__$1;
(statearr_48583_48737[(1)] = (85));

} else {
var statearr_48584_48738 = state_48418__$1;
(statearr_48584_48738[(1)] = (86));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (42))){
var inst_48102 = (state_48418[(22)]);
var state_48418__$1 = state_48418;
if(cljs.core.truth_(inst_48102)){
var statearr_48585_48739 = state_48418__$1;
(statearr_48585_48739[(1)] = (45));

} else {
var statearr_48586_48740 = state_48418__$1;
(statearr_48586_48740[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (80))){
var inst_48269 = (state_48418[(52)]);
var inst_48269__$1 = (state_48418[(2)]);
var state_48418__$1 = (function (){var statearr_48587 = state_48418;
(statearr_48587[(52)] = inst_48269__$1);

return statearr_48587;
})();
if(cljs.core.truth_(inst_48269__$1)){
var statearr_48588_48741 = state_48418__$1;
(statearr_48588_48741[(1)] = (82));

} else {
var statearr_48589_48742 = state_48418__$1;
(statearr_48589_48742[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (37))){
var inst_48105 = (state_48418[(20)]);
var inst_48104 = (state_48418[(21)]);
var inst_48127 = (inst_48104 - (1));
var inst_48128 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_48105,inst_48127);
var state_48418__$1 = state_48418;
var statearr_48590_48743 = state_48418__$1;
(statearr_48590_48743[(2)] = inst_48128);

(statearr_48590_48743[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (63))){
var inst_48185 = (state_48418[(29)]);
var state_48418__$1 = state_48418;
var statearr_48591_48744 = state_48418__$1;
(statearr_48591_48744[(2)] = inst_48185);

(statearr_48591_48744[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (94))){
var inst_48305 = (state_48418[(34)]);
var state_48418__$1 = state_48418;
var statearr_48592_48745 = state_48418__$1;
(statearr_48592_48745[(2)] = inst_48305);

(statearr_48592_48745[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (8))){
var inst_48064 = (state_48418[(2)]);
var state_48418__$1 = state_48418;
if(cljs.core.truth_(inst_48064)){
var statearr_48593_48746 = state_48418__$1;
(statearr_48593_48746[(1)] = (9));

} else {
var statearr_48594_48747 = state_48418__$1;
(statearr_48594_48747[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (49))){
var inst_48155 = (state_48418[(59)]);
var inst_48155__$1 = cljs.core.not(recur_QMARK_);
var state_48418__$1 = (function (){var statearr_48595 = state_48418;
(statearr_48595[(59)] = inst_48155__$1);

return statearr_48595;
})();
if(inst_48155__$1){
var statearr_48596_48748 = state_48418__$1;
(statearr_48596_48748[(1)] = (51));

} else {
var statearr_48597_48749 = state_48418__$1;
(statearr_48597_48749[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48419 === (84))){
var inst_48245 = (state_48418[(58)]);
var inst_48274 = (state_48418[(2)]);
var inst_48237 = inst_48245;
var inst_48238 = inst_48274;
var state_48418__$1 = (function (){var statearr_48598 = state_48418;
(statearr_48598[(10)] = inst_48238);

(statearr_48598[(11)] = inst_48237);

return statearr_48598;
})();
var statearr_48599_48750 = state_48418__$1;
(statearr_48599_48750[(2)] = null);

(statearr_48599_48750[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__24298__auto__ = null;
var fluree$db$query$fql$state_machine__24298__auto____0 = (function (){
var statearr_48600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48600[(0)] = fluree$db$query$fql$state_machine__24298__auto__);

(statearr_48600[(1)] = (1));

return statearr_48600;
});
var fluree$db$query$fql$state_machine__24298__auto____1 = (function (state_48418){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_48418);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e48601){var ex__24301__auto__ = e48601;
var statearr_48602_48751 = state_48418;
(statearr_48602_48751[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_48418[(4)]))){
var statearr_48603_48752 = state_48418;
(statearr_48603_48752[(1)] = cljs.core.first((state_48418[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__48753 = state_48418;
state_48418 = G__48753;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__24298__auto__ = function(state_48418){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__24298__auto____1.call(this,state_48418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__24298__auto____0;
fluree$db$query$fql$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__24298__auto____1;
return fluree$db$query$fql$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_48604 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_48604[(6)] = c__24424__auto__);

return statearr_48604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_48913){
var state_val_48914 = (state_48913[(1)]);
if((state_val_48914 === (7))){
var inst_48908 = (state_48913[(2)]);
var _ = (function (){var statearr_48915 = state_48913;
(statearr_48915[(4)] = cljs.core.rest((state_48913[(4)])));

return statearr_48915;
})();
var state_48913__$1 = state_48913;
var statearr_48916_48998 = state_48913__$1;
(statearr_48916_48998[(2)] = inst_48908);

(statearr_48916_48998[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (20))){
var inst_48835 = (state_48913[(7)]);
var state_48913__$1 = state_48913;
var statearr_48917_48999 = state_48913__$1;
(statearr_48917_48999[(2)] = inst_48835);

(statearr_48917_48999[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (27))){
var inst_48790 = (state_48913[(8)]);
var state_48913__$1 = state_48913;
if(cljs.core.truth_(inst_48790)){
var statearr_48918_49000 = state_48913__$1;
(statearr_48918_49000[(1)] = (29));

} else {
var statearr_48919_49001 = state_48913__$1;
(statearr_48919_49001[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (1))){
var state_48913__$1 = state_48913;
var statearr_48920_49002 = state_48913__$1;
(statearr_48920_49002[(2)] = null);

(statearr_48920_49002[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (24))){
var inst_48791 = (state_48913[(9)]);
var state_48913__$1 = state_48913;
var statearr_48921_49003 = state_48913__$1;
(statearr_48921_49003[(2)] = inst_48791);

(statearr_48921_49003[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (39))){
var inst_48827 = (state_48913[(10)]);
var state_48913__$1 = state_48913;
var statearr_48922_49004 = state_48913__$1;
(statearr_48922_49004[(2)] = inst_48827);

(statearr_48922_49004[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (46))){
var inst_48792 = (state_48913[(11)]);
var state_48913__$1 = state_48913;
var statearr_48923_49005 = state_48913__$1;
(statearr_48923_49005[(2)] = inst_48792);

(statearr_48923_49005[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (4))){
var inst_48754 = (state_48913[(2)]);
var state_48913__$1 = state_48913;
var statearr_48924_49006 = state_48913__$1;
(statearr_48924_49006[(2)] = inst_48754);

(statearr_48924_49006[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (15))){
var inst_48803 = (state_48913[(12)]);
var inst_48809 = cljs.core.count(inst_48803);
var inst_48810 = fluree.db.query.fql.add_fuel(fuel,inst_48809,max_fuel);
var state_48913__$1 = state_48913;
var statearr_48925_49007 = state_48913__$1;
(statearr_48925_49007[(2)] = inst_48810);

(statearr_48925_49007[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (48))){
var inst_48779 = (state_48913[(13)]);
var inst_48772 = (state_48913[(14)]);
var inst_48894 = (state_48913[(15)]);
var inst_48902 = (state_48913[(2)]);
var inst_48903 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_48772,inst_48902,inst_48894);
var inst_48771 = inst_48779;
var inst_48772__$1 = inst_48903;
var state_48913__$1 = (function (){var statearr_48926 = state_48913;
(statearr_48926[(14)] = inst_48772__$1);

(statearr_48926[(16)] = inst_48771);

return statearr_48926;
})();
var statearr_48927_49008 = state_48913__$1;
(statearr_48927_49008[(2)] = null);

(statearr_48927_49008[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (50))){
var inst_48794 = (state_48913[(17)]);
var state_48913__$1 = state_48913;
var statearr_48928_49009 = state_48913__$1;
(statearr_48928_49009[(2)] = inst_48794);

(statearr_48928_49009[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (21))){
var inst_48791 = (state_48913[(9)]);
var state_48913__$1 = state_48913;
if(cljs.core.truth_(inst_48791)){
var statearr_48930_49010 = state_48913__$1;
(statearr_48930_49010[(1)] = (23));

} else {
var statearr_48931_49011 = state_48913__$1;
(statearr_48931_49011[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (31))){
var inst_48851 = (state_48913[(2)]);
var state_48913__$1 = state_48913;
if(cljs.core.truth_(inst_48851)){
var statearr_48932_49012 = state_48913__$1;
(statearr_48932_49012[(1)] = (32));

} else {
var statearr_48933_49013 = state_48913__$1;
(statearr_48933_49013[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (32))){
var inst_48834 = (state_48913[(18)]);
var inst_48827 = (state_48913[(10)]);
var inst_48826 = (state_48913[(19)]);
var inst_48853 = (inst_48826 + (1));
var tmp48929 = inst_48827;
var inst_48825 = inst_48834;
var inst_48826__$1 = inst_48853;
var inst_48827__$1 = tmp48929;
var state_48913__$1 = (function (){var statearr_48934 = state_48913;
(statearr_48934[(20)] = inst_48825);

(statearr_48934[(10)] = inst_48827__$1);

(statearr_48934[(19)] = inst_48826__$1);

return statearr_48934;
})();
var statearr_48935_49014 = state_48913__$1;
(statearr_48935_49014[(2)] = null);

(statearr_48935_49014[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (40))){
var state_48913__$1 = state_48913;
if(cljs.core.truth_(fuel)){
var statearr_48936_49015 = state_48913__$1;
(statearr_48936_49015[(1)] = (42));

} else {
var statearr_48937_49016 = state_48913__$1;
(statearr_48937_49016[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (33))){
var state_48913__$1 = state_48913;
var statearr_48938_49017 = state_48913__$1;
(statearr_48938_49017[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (13))){
var inst_48803 = (state_48913[(12)]);
var state_48913__$1 = state_48913;
var statearr_48940_49018 = state_48913__$1;
(statearr_48940_49018[(2)] = inst_48803);

(statearr_48940_49018[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (22))){
var inst_48844 = (state_48913[(2)]);
var state_48913__$1 = state_48913;
if(cljs.core.truth_(inst_48844)){
var statearr_48941_49019 = state_48913__$1;
(statearr_48941_49019[(1)] = (26));

} else {
var statearr_48942_49020 = state_48913__$1;
(statearr_48942_49020[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (36))){
var state_48913__$1 = state_48913;
var statearr_48943_49021 = state_48913__$1;
(statearr_48943_49021[(2)] = null);

(statearr_48943_49021[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (41))){
var inst_48834 = (state_48913[(18)]);
var inst_48826 = (state_48913[(19)]);
var inst_48883 = (state_48913[(2)]);
var inst_48884 = (inst_48826 + (1));
var inst_48825 = inst_48834;
var inst_48826__$1 = inst_48884;
var inst_48827 = inst_48883;
var state_48913__$1 = (function (){var statearr_48944 = state_48913;
(statearr_48944[(20)] = inst_48825);

(statearr_48944[(10)] = inst_48827);

(statearr_48944[(19)] = inst_48826__$1);

return statearr_48944;
})();
var statearr_48945_49022 = state_48913__$1;
(statearr_48945_49022[(2)] = null);

(statearr_48945_49022[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (43))){
var state_48913__$1 = state_48913;
var statearr_48946_49023 = state_48913__$1;
(statearr_48946_49023[(2)] = null);

(statearr_48946_49023[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (29))){
var inst_48790 = (state_48913[(8)]);
var inst_48826 = (state_48913[(19)]);
var inst_48848 = (inst_48826 < inst_48790);
var state_48913__$1 = state_48913;
var statearr_48947_49024 = state_48913__$1;
(statearr_48947_49024[(2)] = inst_48848);

(statearr_48947_49024[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (44))){
var inst_48867 = (state_48913[(21)]);
var inst_48863 = (state_48913[(22)]);
var inst_48876 = (state_48913[(2)]);
var inst_48877 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_48867,inst_48863) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_48867,inst_48863));
var state_48913__$1 = (function (){var statearr_48948 = state_48913;
(statearr_48948[(23)] = inst_48876);

return statearr_48948;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48913__$1,(45),inst_48877);
} else {
if((state_val_48914 === (6))){
var inst_48778 = (state_48913[(24)]);
var inst_48771 = (state_48913[(16)]);
var inst_48777 = cljs.core.seq(inst_48771);
var inst_48778__$1 = cljs.core.first(inst_48777);
var inst_48779 = cljs.core.next(inst_48777);
var inst_48780 = cljs.core.not(inst_48778__$1);
var state_48913__$1 = (function (){var statearr_48949 = state_48913;
(statearr_48949[(13)] = inst_48779);

(statearr_48949[(24)] = inst_48778__$1);

return statearr_48949;
})();
if(inst_48780){
var statearr_48950_49025 = state_48913__$1;
(statearr_48950_49025[(1)] = (8));

} else {
var statearr_48951_49026 = state_48913__$1;
(statearr_48951_49026[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (28))){
var inst_48892 = (state_48913[(2)]);
var state_48913__$1 = state_48913;
var statearr_48952_49027 = state_48913__$1;
(statearr_48952_49027[(2)] = inst_48892);

(statearr_48952_49027[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (51))){
var inst_48900 = (state_48913[(2)]);
var state_48913__$1 = state_48913;
var statearr_48953_49028 = state_48913__$1;
(statearr_48953_49028[(2)] = inst_48900);

(statearr_48953_49028[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (25))){
var inst_48842 = (state_48913[(2)]);
var state_48913__$1 = state_48913;
var statearr_48954_49029 = state_48913__$1;
(statearr_48954_49029[(2)] = inst_48842);

(statearr_48954_49029[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (34))){
var inst_48890 = (state_48913[(2)]);
var state_48913__$1 = state_48913;
var statearr_48955_49030 = state_48913__$1;
(statearr_48955_49030[(2)] = inst_48890);

(statearr_48955_49030[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (17))){
var inst_48803 = (state_48913[(12)]);
var inst_48813 = (state_48913[(2)]);
var inst_48821 = cljs.core.seq(inst_48803);
var inst_48822 = cljs.core.first(inst_48821);
var inst_48823 = cljs.core.next(inst_48821);
var inst_48824 = cljs.core.PersistentVector.EMPTY;
var inst_48825 = inst_48803;
var inst_48826 = (0);
var inst_48827 = inst_48824;
var state_48913__$1 = (function (){var statearr_48956 = state_48913;
(statearr_48956[(25)] = inst_48823);

(statearr_48956[(20)] = inst_48825);

(statearr_48956[(26)] = inst_48813);

(statearr_48956[(27)] = inst_48822);

(statearr_48956[(10)] = inst_48827);

(statearr_48956[(19)] = inst_48826);

return statearr_48956;
})();
var statearr_48957_49031 = state_48913__$1;
(statearr_48957_49031[(2)] = null);

(statearr_48957_49031[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (3))){
var inst_48911 = (state_48913[(2)]);
var state_48913__$1 = state_48913;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48913__$1,inst_48911);
} else {
if((state_val_48914 === (12))){
var state_48913__$1 = state_48913;
var statearr_48958_49032 = state_48913__$1;
(statearr_48958_49032[(2)] = fuel);

(statearr_48958_49032[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (2))){
var _ = (function (){var statearr_48959 = state_48913;
(statearr_48959[(4)] = cljs.core.cons((5),(state_48913[(4)])));

return statearr_48959;
})();
var inst_48767 = reverse_refs_specs;
var inst_48768 = cljs.core.seq(inst_48767);
var inst_48769 = cljs.core.first(inst_48768);
var inst_48770 = cljs.core.next(inst_48768);
var inst_48771 = inst_48767;
var inst_48772 = null;
var state_48913__$1 = (function (){var statearr_48960 = state_48913;
(statearr_48960[(14)] = inst_48772);

(statearr_48960[(28)] = inst_48769);

(statearr_48960[(16)] = inst_48771);

(statearr_48960[(29)] = inst_48770);

return statearr_48960;
})();
var statearr_48961_49033 = state_48913__$1;
(statearr_48961_49033[(2)] = null);

(statearr_48961_49033[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (23))){
var inst_48791 = (state_48913[(9)]);
var inst_48826 = (state_48913[(19)]);
var inst_48839 = (inst_48826 >= inst_48791);
var state_48913__$1 = state_48913;
var statearr_48962_49034 = state_48913__$1;
(statearr_48962_49034[(2)] = inst_48839);

(statearr_48962_49034[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (47))){
var inst_48793 = (state_48913[(30)]);
var state_48913__$1 = state_48913;
if(cljs.core.truth_(inst_48793)){
var statearr_48963_49035 = state_48913__$1;
(statearr_48963_49035[(1)] = (49));

} else {
var statearr_48964_49036 = state_48913__$1;
(statearr_48964_49036[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (35))){
var inst_48833 = (state_48913[(31)]);
var inst_48857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48858 = [inst_48833];
var inst_48859 = (new cljs.core.PersistentVector(null,1,(5),inst_48857,inst_48858,null));
var inst_48860 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_48859);
var state_48913__$1 = state_48913;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48913__$1,(38),inst_48860);
} else {
if((state_val_48914 === (19))){
var inst_48792 = (state_48913[(11)]);
var inst_48894 = (state_48913[(2)]);
var state_48913__$1 = (function (){var statearr_48965 = state_48913;
(statearr_48965[(15)] = inst_48894);

return statearr_48965;
})();
if(cljs.core.truth_(inst_48792)){
var statearr_48966_49037 = state_48913__$1;
(statearr_48966_49037[(1)] = (46));

} else {
var statearr_48967_49038 = state_48913__$1;
(statearr_48967_49038[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (11))){
var inst_48803 = (state_48913[(12)]);
var inst_48800 = (state_48913[(2)]);
var inst_48801 = fluree.db.util.async.throw_err(inst_48800);
var inst_48802 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_48801);
var inst_48803__$1 = cljs.core.not_empty(inst_48802);
var state_48913__$1 = (function (){var statearr_48969 = state_48913;
(statearr_48969[(12)] = inst_48803__$1);

return statearr_48969;
})();
if(cljs.core.truth_(inst_48803__$1)){
var statearr_48970_49039 = state_48913__$1;
(statearr_48970_49039[(1)] = (12));

} else {
var statearr_48971_49040 = state_48913__$1;
(statearr_48971_49040[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (9))){
var inst_48778 = (state_48913[(24)]);
var inst_48788 = (state_48913[(32)]);
var inst_48787 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48778,(0),null);
var inst_48788__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48778,(1),null);
var inst_48789 = cljs.core.__destructure_map(inst_48788__$1);
var inst_48790 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48789,cljs.core.cst$kw$offset);
var inst_48791 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48789,cljs.core.cst$kw$limit);
var inst_48792 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48789,cljs.core.cst$kw$as);
var inst_48793 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48789,cljs.core.cst$kw$name);
var inst_48794 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48789,cljs.core.cst$kw$p);
var inst_48795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48796 = [subject_id,inst_48787];
var inst_48797 = (new cljs.core.PersistentVector(null,2,(5),inst_48795,inst_48796,null));
var inst_48798 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_48797);
var state_48913__$1 = (function (){var statearr_48972 = state_48913;
(statearr_48972[(8)] = inst_48790);

(statearr_48972[(30)] = inst_48793);

(statearr_48972[(17)] = inst_48794);

(statearr_48972[(9)] = inst_48791);

(statearr_48972[(32)] = inst_48788__$1);

(statearr_48972[(11)] = inst_48792);

return statearr_48972;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48913__$1,(11),inst_48798);
} else {
if((state_val_48914 === (5))){
var _ = (function (){var statearr_48973 = state_48913;
(statearr_48973[(4)] = cljs.core.rest((state_48913[(4)])));

return statearr_48973;
})();
var state_48913__$1 = state_48913;
var ex48968 = (state_48913__$1[(2)]);
var statearr_48974_49041 = state_48913__$1;
(statearr_48974_49041[(5)] = ex48968);


if((ex48968 instanceof Error)){
var statearr_48975_49042 = state_48913__$1;
(statearr_48975_49042[(1)] = (4));

(statearr_48975_49042[(5)] = null);

} else {
throw ex48968;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (14))){
var inst_48807 = (state_48913[(2)]);
var state_48913__$1 = state_48913;
if(cljs.core.truth_(inst_48807)){
var statearr_48976_49043 = state_48913__$1;
(statearr_48976_49043[(1)] = (15));

} else {
var statearr_48977_49044 = state_48913__$1;
(statearr_48977_49044[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (45))){
var inst_48827 = (state_48913[(10)]);
var inst_48879 = (state_48913[(2)]);
var inst_48880 = fluree.db.util.async.throw_err(inst_48879);
var inst_48881 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_48827,inst_48880);
var state_48913__$1 = state_48913;
var statearr_48978_49045 = state_48913__$1;
(statearr_48978_49045[(2)] = inst_48881);

(statearr_48978_49045[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (26))){
var inst_48827 = (state_48913[(10)]);
var state_48913__$1 = state_48913;
var statearr_48979_49046 = state_48913__$1;
(statearr_48979_49046[(2)] = inst_48827);

(statearr_48979_49046[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (16))){
var state_48913__$1 = state_48913;
var statearr_48980_49047 = state_48913__$1;
(statearr_48980_49047[(2)] = null);

(statearr_48980_49047[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (38))){
var inst_48788 = (state_48913[(32)]);
var inst_48863 = (state_48913[(22)]);
var inst_48862 = (state_48913[(2)]);
var inst_48863__$1 = fluree.db.util.async.throw_err(inst_48862);
var inst_48864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48865 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_48866 = (new cljs.core.PersistentVector(null,4,(5),inst_48864,inst_48865,null));
var inst_48867 = cljs.core.select_keys(inst_48788,inst_48866);
var inst_48868 = cljs.core.empty_QMARK_(inst_48863__$1);
var state_48913__$1 = (function (){var statearr_48981 = state_48913;
(statearr_48981[(21)] = inst_48867);

(statearr_48981[(22)] = inst_48863__$1);

return statearr_48981;
})();
if(inst_48868){
var statearr_48982_49048 = state_48913__$1;
(statearr_48982_49048[(1)] = (39));

} else {
var statearr_48983_49049 = state_48913__$1;
(statearr_48983_49049[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (30))){
var inst_48790 = (state_48913[(8)]);
var state_48913__$1 = state_48913;
var statearr_48984_49050 = state_48913__$1;
(statearr_48984_49050[(2)] = inst_48790);

(statearr_48984_49050[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (10))){
var inst_48906 = (state_48913[(2)]);
var state_48913__$1 = state_48913;
var statearr_48985_49051 = state_48913__$1;
(statearr_48985_49051[(2)] = inst_48906);

(statearr_48985_49051[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (18))){
var inst_48833 = (state_48913[(31)]);
var inst_48825 = (state_48913[(20)]);
var inst_48835 = (state_48913[(7)]);
var inst_48832 = cljs.core.seq(inst_48825);
var inst_48833__$1 = cljs.core.first(inst_48832);
var inst_48834 = cljs.core.next(inst_48832);
var inst_48835__$1 = cljs.core.not(inst_48833__$1);
var state_48913__$1 = (function (){var statearr_48986 = state_48913;
(statearr_48986[(31)] = inst_48833__$1);

(statearr_48986[(7)] = inst_48835__$1);

(statearr_48986[(18)] = inst_48834);

return statearr_48986;
})();
if(inst_48835__$1){
var statearr_48987_49052 = state_48913__$1;
(statearr_48987_49052[(1)] = (20));

} else {
var statearr_48988_49053 = state_48913__$1;
(statearr_48988_49053[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (42))){
var inst_48863 = (state_48913[(22)]);
var inst_48872 = cljs.core.count(inst_48863);
var inst_48873 = fluree.db.query.fql.add_fuel(fuel,inst_48872,max_fuel);
var state_48913__$1 = state_48913;
var statearr_48989_49054 = state_48913__$1;
(statearr_48989_49054[(2)] = inst_48873);

(statearr_48989_49054[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (37))){
var inst_48888 = (state_48913[(2)]);
var state_48913__$1 = state_48913;
var statearr_48990_49055 = state_48913__$1;
(statearr_48990_49055[(2)] = inst_48888);

(statearr_48990_49055[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (8))){
var inst_48772 = (state_48913[(14)]);
var state_48913__$1 = state_48913;
var statearr_48991_49056 = state_48913__$1;
(statearr_48991_49056[(2)] = inst_48772);

(statearr_48991_49056[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48914 === (49))){
var inst_48793 = (state_48913[(30)]);
var state_48913__$1 = state_48913;
var statearr_48992_49057 = state_48913__$1;
(statearr_48992_49057[(2)] = inst_48793);

(statearr_48992_49057[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__24298__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__24298__auto____0 = (function (){
var statearr_48993 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48993[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__24298__auto__);

(statearr_48993[(1)] = (1));

return statearr_48993;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__24298__auto____1 = (function (state_48913){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_48913);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e48994){var ex__24301__auto__ = e48994;
var statearr_48995_49058 = state_48913;
(statearr_48995_49058[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_48913[(4)]))){
var statearr_48996_49059 = state_48913;
(statearr_48996_49059[(1)] = cljs.core.first((state_48913[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__49060 = state_48913;
state_48913 = G__49060;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__24298__auto__ = function(state_48913){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__24298__auto____1.call(this,state_48913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__24298__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__24298__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_48997 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_48997[(6)] = c__24424__auto__);

return statearr_48997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__49061 = select_spec;
var map__49061__$1 = cljs.core.__destructure_map(map__49061);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49061__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49061__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_49175){
var state_val_49176 = (state_49175[(1)]);
if((state_val_49176 === (7))){
var inst_49087 = flakes;
var inst_49088 = cljs.core.seq(inst_49087);
var inst_49089 = cljs.core.first(inst_49088);
var inst_49090 = cljs.core.next(inst_49088);
var inst_49091 = cljs.core.PersistentVector.EMPTY;
var inst_49092 = inst_49087;
var inst_49093 = (0);
var inst_49094 = inst_49091;
var state_49175__$1 = (function (){var statearr_49177 = state_49175;
(statearr_49177[(7)] = inst_49090);

(statearr_49177[(8)] = inst_49092);

(statearr_49177[(9)] = inst_49089);

(statearr_49177[(10)] = inst_49093);

(statearr_49177[(11)] = inst_49094);

return statearr_49177;
})();
var statearr_49178_49244 = state_49175__$1;
(statearr_49178_49244[(2)] = null);

(statearr_49178_49244[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (20))){
var state_49175__$1 = state_49175;
var statearr_49179_49245 = state_49175__$1;
(statearr_49179_49245[(2)] = results);

(statearr_49179_49245[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (27))){
var state_49175__$1 = state_49175;
var statearr_49180_49246 = state_49175__$1;
(statearr_49180_49246[(2)] = null);

(statearr_49180_49246[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (1))){
var state_49175__$1 = state_49175;
var statearr_49181_49247 = state_49175__$1;
(statearr_49181_49247[(2)] = null);

(statearr_49181_49247[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (24))){
var state_49175__$1 = state_49175;
var statearr_49182_49248 = state_49175__$1;
(statearr_49182_49248[(1)] = (26));



return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (39))){
var inst_49101 = (state_49175[(12)]);
var inst_49156 = (state_49175[(13)]);
var inst_49094 = (state_49175[(11)]);
var inst_49159 = (state_49175[(2)]);
var inst_49160 = fluree.db.util.async.throw_err(inst_49159);
var inst_49161 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_49094,inst_49160);
var inst_49092 = inst_49101;
var inst_49093 = inst_49156;
var inst_49094__$1 = inst_49161;
var state_49175__$1 = (function (){var statearr_49184 = state_49175;
(statearr_49184[(8)] = inst_49092);

(statearr_49184[(10)] = inst_49093);

(statearr_49184[(11)] = inst_49094__$1);

return statearr_49184;
})();
var statearr_49185_49249 = state_49175__$1;
(statearr_49185_49249[(2)] = null);

(statearr_49185_49249[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (4))){
var inst_49062 = (state_49175[(2)]);
var state_49175__$1 = state_49175;
var statearr_49186_49250 = state_49175__$1;
(statearr_49186_49250[(2)] = inst_49062);

(statearr_49186_49250[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (15))){
var inst_49075 = (state_49175[(14)]);
var state_49175__$1 = state_49175;
var statearr_49187_49251 = state_49175__$1;
(statearr_49187_49251[(2)] = inst_49075);

(statearr_49187_49251[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (21))){
var inst_49071 = (state_49175[(15)]);
var state_49175__$1 = state_49175;
if(cljs.core.truth_(inst_49071)){
var statearr_49188_49252 = state_49175__$1;
(statearr_49188_49252[(1)] = (23));

} else {
var statearr_49189_49253 = state_49175__$1;
(statearr_49189_49253[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (31))){
var inst_49139 = (state_49175[(16)]);
var state_49175__$1 = state_49175;
var statearr_49190_49254 = state_49175__$1;
(statearr_49190_49254[(2)] = inst_49139);

(statearr_49190_49254[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (32))){
var inst_49131 = (state_49175[(17)]);
var inst_49145 = (state_49175[(2)]);
var state_49175__$1 = (function (){var statearr_49191 = state_49175;
(statearr_49191[(18)] = inst_49145);

return statearr_49191;
})();
if(cljs.core.truth_(inst_49131)){
var statearr_49192_49255 = state_49175__$1;
(statearr_49192_49255[(1)] = (33));

} else {
var statearr_49193_49256 = state_49175__$1;
(statearr_49193_49256[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (33))){
var inst_49131 = (state_49175[(17)]);
var state_49175__$1 = state_49175;
var statearr_49194_49257 = state_49175__$1;
(statearr_49194_49257[(2)] = inst_49131);

(statearr_49194_49257[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (13))){
var inst_49111 = (state_49175[(2)]);
var state_49175__$1 = state_49175;
if(cljs.core.truth_(inst_49111)){
var statearr_49196_49258 = state_49175__$1;
(statearr_49196_49258[(1)] = (17));

} else {
var statearr_49197_49259 = state_49175__$1;
(statearr_49197_49259[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (22))){
var inst_49128 = (state_49175[(2)]);
var state_49175__$1 = state_49175;
var statearr_49198_49260 = state_49175__$1;
(statearr_49198_49260[(2)] = inst_49128);

(statearr_49198_49260[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (36))){
var inst_49093 = (state_49175[(10)]);
var inst_49101 = (state_49175[(12)]);
var inst_49094 = (state_49175[(11)]);
var inst_49153 = (inst_49093 + (1));
var tmp49195 = inst_49094;
var inst_49092 = inst_49101;
var inst_49093__$1 = inst_49153;
var inst_49094__$1 = tmp49195;
var state_49175__$1 = (function (){var statearr_49199 = state_49175;
(statearr_49199[(8)] = inst_49092);

(statearr_49199[(10)] = inst_49093__$1);

(statearr_49199[(11)] = inst_49094__$1);

return statearr_49199;
})();
var statearr_49200_49261 = state_49175__$1;
(statearr_49200_49261[(2)] = null);

(statearr_49200_49261[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (29))){
var inst_49138 = (state_49175[(2)]);
var inst_49139 = fluree.db.util.async.throw_err(inst_49138);
var state_49175__$1 = (function (){var statearr_49201 = state_49175;
(statearr_49201[(16)] = inst_49139);

return statearr_49201;
})();
if(cljs.core.truth_(fuel)){
var statearr_49202_49262 = state_49175__$1;
(statearr_49202_49262[(1)] = (30));

} else {
var statearr_49203_49263 = state_49175__$1;
(statearr_49203_49263[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (6))){
var state_49175__$1 = state_49175;
var statearr_49204_49264 = state_49175__$1;
(statearr_49204_49264[(2)] = results);

(statearr_49204_49264[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (28))){
var inst_49124 = (state_49175[(2)]);
var state_49175__$1 = state_49175;
var statearr_49205_49265 = state_49175__$1;
(statearr_49205_49265[(2)] = inst_49124);

(statearr_49205_49265[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (25))){
var inst_49126 = (state_49175[(2)]);
var state_49175__$1 = state_49175;
var statearr_49206_49266 = state_49175__$1;
(statearr_49206_49266[(2)] = inst_49126);

(statearr_49206_49266[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (34))){
var inst_49145 = (state_49175[(18)]);
var inst_49148 = cljs.core.empty_QMARK_(inst_49145);
var state_49175__$1 = state_49175;
var statearr_49207_49267 = state_49175__$1;
(statearr_49207_49267[(2)] = inst_49148);

(statearr_49207_49267[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (17))){
var inst_49094 = (state_49175[(11)]);
var inst_49113 = cljs.core.empty_QMARK_(inst_49094);
var state_49175__$1 = state_49175;
if(inst_49113){
var statearr_49208_49268 = state_49175__$1;
(statearr_49208_49268[(1)] = (20));

} else {
var statearr_49209_49269 = state_49175__$1;
(statearr_49209_49269[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (3))){
var inst_49173 = (state_49175[(2)]);
var state_49175__$1 = state_49175;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49175__$1,inst_49173);
} else {
if((state_val_49176 === (12))){
var inst_49075 = (state_49175[(14)]);
var state_49175__$1 = state_49175;
if(cljs.core.truth_(inst_49075)){
var statearr_49210_49270 = state_49175__$1;
(statearr_49210_49270[(1)] = (14));

} else {
var statearr_49211_49271 = state_49175__$1;
(statearr_49211_49271[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (2))){
var _ = (function (){var statearr_49212 = state_49175;
(statearr_49212[(4)] = cljs.core.cons((5),(state_49175[(4)])));

return statearr_49212;
})();
var inst_49069 = select_spec;
var inst_49070 = cljs.core.__destructure_map(inst_49069);
var inst_49071 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_49070,cljs.core.cst$kw$multi_QMARK_);
var inst_49072 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_49070,cljs.core.cst$kw$as);
var inst_49073 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_49070,cljs.core.cst$kw$recur_DASH_seen);
var inst_49074 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_49070,cljs.core.cst$kw$recur_DASH_depth);
var inst_49075 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_49070,cljs.core.cst$kw$limit);
var inst_49076 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_49077 = (inst_49074 > inst_49076);
var state_49175__$1 = (function (){var statearr_49213 = state_49175;
(statearr_49213[(19)] = inst_49072);

(statearr_49213[(15)] = inst_49071);

(statearr_49213[(20)] = inst_49073);

(statearr_49213[(14)] = inst_49075);

return statearr_49213;
})();
if(cljs.core.truth_(inst_49077)){
var statearr_49214_49272 = state_49175__$1;
(statearr_49214_49272[(1)] = (6));

} else {
var statearr_49215_49273 = state_49175__$1;
(statearr_49215_49273[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (23))){
var inst_49072 = (state_49175[(19)]);
var inst_49094 = (state_49175[(11)]);
var inst_49117 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_49072,inst_49094);
var state_49175__$1 = state_49175;
var statearr_49216_49274 = state_49175__$1;
(statearr_49216_49274[(2)] = inst_49117);

(statearr_49216_49274[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (35))){
var inst_49100 = (state_49175[(21)]);
var inst_49150 = (state_49175[(2)]);
var inst_49151 = fluree.db.query.fql.recur_select_spec(select_spec,inst_49100);
var state_49175__$1 = (function (){var statearr_49217 = state_49175;
(statearr_49217[(22)] = inst_49151);

return statearr_49217;
})();
if(cljs.core.truth_(inst_49150)){
var statearr_49218_49275 = state_49175__$1;
(statearr_49218_49275[(1)] = (36));

} else {
var statearr_49219_49276 = state_49175__$1;
(statearr_49219_49276[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (19))){
var inst_49166 = (state_49175[(2)]);
var state_49175__$1 = state_49175;
var statearr_49220_49277 = state_49175__$1;
(statearr_49220_49277[(2)] = inst_49166);

(statearr_49220_49277[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (11))){
var inst_49102 = (state_49175[(23)]);
var state_49175__$1 = state_49175;
var statearr_49222_49278 = state_49175__$1;
(statearr_49222_49278[(2)] = inst_49102);

(statearr_49222_49278[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (9))){
var inst_49092 = (state_49175[(8)]);
var inst_49100 = (state_49175[(21)]);
var inst_49102 = (state_49175[(23)]);
var inst_49099 = cljs.core.seq(inst_49092);
var inst_49100__$1 = cljs.core.first(inst_49099);
var inst_49101 = cljs.core.next(inst_49099);
var inst_49102__$1 = cljs.core.not(inst_49100__$1);
var state_49175__$1 = (function (){var statearr_49223 = state_49175;
(statearr_49223[(21)] = inst_49100__$1);

(statearr_49223[(12)] = inst_49101);

(statearr_49223[(23)] = inst_49102__$1);

return statearr_49223;
})();
if(inst_49102__$1){
var statearr_49224_49279 = state_49175__$1;
(statearr_49224_49279[(1)] = (11));

} else {
var statearr_49225_49280 = state_49175__$1;
(statearr_49225_49280[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (5))){
var _ = (function (){var statearr_49226 = state_49175;
(statearr_49226[(4)] = cljs.core.rest((state_49175[(4)])));

return statearr_49226;
})();
var state_49175__$1 = state_49175;
var ex49221 = (state_49175__$1[(2)]);
var statearr_49227_49281 = state_49175__$1;
(statearr_49227_49281[(5)] = ex49221);


if((ex49221 instanceof Error)){
var statearr_49228_49282 = state_49175__$1;
(statearr_49228_49282[(1)] = (4));

(statearr_49228_49282[(5)] = null);

} else {
throw ex49221;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (14))){
var inst_49093 = (state_49175[(10)]);
var inst_49075 = (state_49175[(14)]);
var inst_49106 = (inst_49093 < inst_49075);
var state_49175__$1 = state_49175;
var statearr_49229_49283 = state_49175__$1;
(statearr_49229_49283[(2)] = inst_49106);

(statearr_49229_49283[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (26))){
var inst_49072 = (state_49175[(19)]);
var inst_49094 = (state_49175[(11)]);
var inst_49120 = cljs.core.first(inst_49094);
var inst_49121 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_49072,inst_49120);
var state_49175__$1 = state_49175;
var statearr_49230_49284 = state_49175__$1;
(statearr_49230_49284[(2)] = inst_49121);

(statearr_49230_49284[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (16))){
var inst_49109 = (state_49175[(2)]);
var state_49175__$1 = state_49175;
var statearr_49231_49285 = state_49175__$1;
(statearr_49231_49285[(2)] = inst_49109);

(statearr_49231_49285[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (38))){
var inst_49164 = (state_49175[(2)]);
var state_49175__$1 = state_49175;
var statearr_49232_49286 = state_49175__$1;
(statearr_49232_49286[(2)] = inst_49164);

(statearr_49232_49286[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (30))){
var inst_49139 = (state_49175[(16)]);
var inst_49141 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_49142 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_49141,inst_49139);
var state_49175__$1 = state_49175;
var statearr_49233_49287 = state_49175__$1;
(statearr_49233_49287[(2)] = inst_49142);

(statearr_49233_49287[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (10))){
var inst_49168 = (state_49175[(2)]);
var state_49175__$1 = state_49175;
var statearr_49234_49288 = state_49175__$1;
(statearr_49234_49288[(2)] = inst_49168);

(statearr_49234_49288[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49176 === (18))){
var inst_49100 = (state_49175[(21)]);
var inst_49073 = (state_49175[(20)]);
var inst_49130 = inst_49100.o;
var inst_49131 = cljs.core.contains_QMARK_(inst_49073,inst_49130);
var inst_49133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49134 = [inst_49130];
var inst_49135 = (new cljs.core.PersistentVector(null,1,(5),inst_49133,inst_49134,null));
var inst_49136 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_49135);
var state_49175__$1 = (function (){var statearr_49235 = state_49175;
(statearr_49235[(17)] = inst_49131);

return statearr_49235;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49175__$1,(29),inst_49136);
} else {
if((state_val_49176 === (37))){
var inst_49093 = (state_49175[(10)]);
var inst_49145 = (state_49175[(18)]);
var inst_49151 = (state_49175[(22)]);
var inst_49156 = (inst_49093 + (1));
var inst_49157 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_49151,inst_49145) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_49151,inst_49145));
var state_49175__$1 = (function (){var statearr_49236 = state_49175;
(statearr_49236[(13)] = inst_49156);

return statearr_49236;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49175__$1,(39),inst_49157);
} else {
if((state_val_49176 === (8))){
var inst_49170 = (state_49175[(2)]);
var _ = (function (){var statearr_49237 = state_49175;
(statearr_49237[(4)] = cljs.core.rest((state_49175[(4)])));

return statearr_49237;
})();
var state_49175__$1 = state_49175;
var statearr_49238_49289 = state_49175__$1;
(statearr_49238_49289[(2)] = inst_49170);

(statearr_49238_49289[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__24298__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__24298__auto____0 = (function (){
var statearr_49239 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49239[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__24298__auto__);

(statearr_49239[(1)] = (1));

return statearr_49239;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__24298__auto____1 = (function (state_49175){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_49175);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e49240){var ex__24301__auto__ = e49240;
var statearr_49241_49290 = state_49175;
(statearr_49241_49290[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_49175[(4)]))){
var statearr_49242_49291 = state_49175;
(statearr_49242_49291[(1)] = cljs.core.first((state_49175[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__49292 = state_49175;
state_49175 = G__49292;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__24298__auto__ = function(state_49175){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__24298__auto____1.call(this,state_49175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__24298__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__24298__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_49243 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_49243[(6)] = c__24424__auto__);

return statearr_49243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_49473){
var state_val_49474 = (state_49473[(1)]);
if((state_val_49474 === (7))){
var state_49473__$1 = state_49473;
var statearr_49475_49561 = state_49473__$1;
(statearr_49475_49561[(2)] = null);

(statearr_49475_49561[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (20))){
var inst_49331 = cljs.core.PersistentHashMap.EMPTY;
var state_49473__$1 = state_49473;
var statearr_49476_49562 = state_49473__$1;
(statearr_49476_49562[(2)] = inst_49331);

(statearr_49476_49562[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (27))){
var inst_49319 = (state_49473[(7)]);
var inst_49333 = (state_49473[(8)]);
var inst_49349 = (state_49473[(9)]);
var inst_49313 = (state_49473[(10)]);
var inst_49452 = (state_49473[(2)]);
var inst_49453 = (function (){var top_level_subject = inst_49313;
var select_spec = inst_49319;
var base_acc = inst_49333;
var acc_PLUS_refs = inst_49349;
var result = inst_49452;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4212__auto__ = (function (){var and__4210__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_49454 = cljs.core.PersistentVector.EMPTY;
var inst_49455 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_49319);
var inst_49456 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_49455);
var inst_49457 = cljs.core.vals(inst_49456);
var inst_49458 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_49319);
var inst_49459 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_49458);
var inst_49460 = cljs.core.vals(inst_49459);
var inst_49461 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_49457,inst_49460);
var inst_49462 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_49453,inst_49454,inst_49461);
var inst_49464 = (function (){var top_level_subject = inst_49313;
var select_spec = inst_49319;
var base_acc = inst_49333;
var acc_PLUS_refs = inst_49349;
var result = inst_49452;
var sort_preds = inst_49462;
return (function (acc,p__49463){
var vec__49477 = p__49463;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49477,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49477,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49477,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49477,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_49465 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_49464,inst_49452,inst_49462);
var state_49473__$1 = state_49473;
var statearr_49480_49563 = state_49473__$1;
(statearr_49480_49563[(2)] = inst_49465);

(statearr_49480_49563[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (1))){
var state_49473__$1 = state_49473;
var statearr_49481_49564 = state_49473__$1;
(statearr_49481_49564[(2)] = null);

(statearr_49481_49564[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (24))){
var inst_49349 = (state_49473[(9)]);
var inst_49349__$1 = (state_49473[(2)]);
var inst_49350 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$p,flakes);
var inst_49351 = cljs.core.PersistentHashMap.EMPTY;
var inst_49352 = inst_49350;
var inst_49353 = inst_49349__$1;
var inst_49354 = inst_49351;
var state_49473__$1 = (function (){var statearr_49482 = state_49473;
(statearr_49482[(11)] = inst_49353);

(statearr_49482[(12)] = inst_49352);

(statearr_49482[(9)] = inst_49349__$1);

(statearr_49482[(13)] = inst_49354);

return statearr_49482;
})();
var statearr_49483_49565 = state_49473__$1;
(statearr_49483_49565[(2)] = null);

(statearr_49483_49565[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (39))){
var inst_49319 = (state_49473[(7)]);
var inst_49369 = (state_49473[(14)]);
var inst_49353 = (state_49473[(11)]);
var inst_49362 = (state_49473[(15)]);
var inst_49398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49399 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_49353,inst_49319,inst_49362,inst_49369,false);
var state_49473__$1 = (function (){var statearr_49484 = state_49473;
(statearr_49484[(16)] = inst_49398);

return statearr_49484;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49473__$1,(42),inst_49399);
} else {
if((state_val_49474 === (46))){
var inst_49362 = (state_49473[(15)]);
var inst_49352 = (state_49473[(12)]);
var inst_49354 = (state_49473[(13)]);
var inst_49416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49417 = [cljs.core.cst$kw$_id];
var inst_49418 = cljs.core.first(inst_49362);
var inst_49419 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(inst_49418);
var inst_49420 = [inst_49419];
var inst_49421 = cljs.core.PersistentHashMap.fromArrays(inst_49417,inst_49420);
var inst_49422 = cljs.core.rest(inst_49352);
var inst_49423 = [inst_49421,inst_49422,inst_49354];
var inst_49424 = (new cljs.core.PersistentVector(null,3,(5),inst_49416,inst_49423,null));
var state_49473__$1 = state_49473;
var statearr_49485_49566 = state_49473__$1;
(statearr_49485_49566[(2)] = inst_49424);

(statearr_49485_49566[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (4))){
var inst_49293 = (state_49473[(2)]);
var state_49473__$1 = state_49473;
var statearr_49486_49567 = state_49473__$1;
(statearr_49486_49567[(2)] = inst_49293);

(statearr_49486_49567[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (15))){
var inst_49319 = (state_49473[(7)]);
var inst_49320 = (state_49473[(17)]);
var inst_49319__$1 = (state_49473[(2)]);
var inst_49320__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_49319__$1);
var state_49473__$1 = (function (){var statearr_49487 = state_49473;
(statearr_49487[(7)] = inst_49319__$1);

(statearr_49487[(17)] = inst_49320__$1);

return statearr_49487;
})();
if(cljs.core.truth_(inst_49320__$1)){
var statearr_49488_49568 = state_49473__$1;
(statearr_49488_49568[(1)] = (16));

} else {
var statearr_49489_49569 = state_49473__$1;
(statearr_49489_49569[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (48))){
var inst_49435 = (state_49473[(2)]);
var state_49473__$1 = state_49473;
var statearr_49490_49570 = state_49473__$1;
(statearr_49490_49570[(2)] = inst_49435);

(statearr_49490_49570[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (50))){
var state_49473__$1 = state_49473;
var statearr_49491_49571 = state_49473__$1;
(statearr_49491_49571[(2)] = null);

(statearr_49491_49571[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (21))){
var inst_49319 = (state_49473[(7)]);
var inst_49333 = (state_49473[(2)]);
var inst_49334 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49335 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_49336 = (new cljs.core.PersistentVector(null,2,(5),inst_49334,inst_49335,null));
var inst_49337 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_49319,inst_49336);
var state_49473__$1 = (function (){var statearr_49492 = state_49473;
(statearr_49492[(8)] = inst_49333);

return statearr_49492;
})();
if(cljs.core.truth_(inst_49337)){
var statearr_49493_49572 = state_49473__$1;
(statearr_49493_49572[(1)] = (22));

} else {
var statearr_49494_49573 = state_49473__$1;
(statearr_49494_49573[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (31))){
var inst_49353 = (state_49473[(11)]);
var inst_49362 = (state_49473[(15)]);
var inst_49368 = (state_49473[(18)]);
var inst_49372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49373 = fluree.db.query.fql.flake__GT_recur(db,inst_49362,inst_49368,inst_49353,fuel,max_fuel,cache);
var state_49473__$1 = (function (){var statearr_49495 = state_49473;
(statearr_49495[(19)] = inst_49372);

return statearr_49495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49473__$1,(34),inst_49373);
} else {
if((state_val_49474 === (32))){
var inst_49368 = (state_49473[(18)]);
var state_49473__$1 = state_49473;
if(cljs.core.truth_(inst_49368)){
var statearr_49496_49574 = state_49473__$1;
(statearr_49496_49574[(1)] = (35));

} else {
var statearr_49497_49575 = state_49473__$1;
(statearr_49497_49575[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (40))){
var inst_49319 = (state_49473[(7)]);
var inst_49409 = (state_49473[(20)]);
var inst_49408 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_49319);
var inst_49409__$1 = cljs.core.empty_QMARK_(inst_49408);
var state_49473__$1 = (function (){var statearr_49498 = state_49473;
(statearr_49498[(20)] = inst_49409__$1);

return statearr_49498;
})();
if(inst_49409__$1){
var statearr_49499_49576 = state_49473__$1;
(statearr_49499_49576[(1)] = (43));

} else {
var statearr_49500_49577 = state_49473__$1;
(statearr_49500_49577[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (33))){
var inst_49362 = (state_49473[(15)]);
var inst_49441 = (state_49473[(2)]);
var inst_49442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49441,(0),null);
var inst_49443 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49441,(1),null);
var inst_49444 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49441,(2),null);
var inst_49445 = cljs.core.first(inst_49362);
var inst_49446 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(inst_49445);
var inst_49447 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_49442,cljs.core.cst$kw$_id,inst_49446);
var inst_49352 = inst_49443;
var inst_49353 = inst_49447;
var inst_49354 = inst_49444;
var state_49473__$1 = (function (){var statearr_49501 = state_49473;
(statearr_49501[(11)] = inst_49353);

(statearr_49501[(12)] = inst_49352);

(statearr_49501[(13)] = inst_49354);

return statearr_49501;
})();
var statearr_49502_49578 = state_49473__$1;
(statearr_49502_49578[(2)] = null);

(statearr_49502_49578[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (13))){
var inst_49313 = (state_49473[(10)]);
var inst_49316 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_49313);
var state_49473__$1 = state_49473;
var statearr_49503_49579 = state_49473__$1;
(statearr_49503_49579[(2)] = inst_49316);

(statearr_49503_49579[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (22))){
var inst_49319 = (state_49473[(7)]);
var inst_49339 = cljs.core.first(flakes);
var inst_49340 = fluree.db.query.fql.s(inst_49339);
var inst_49341 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_49319);
var inst_49342 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_49340,inst_49341);
var state_49473__$1 = state_49473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49473__$1,(25),inst_49342);
} else {
if((state_val_49474 === (36))){
var inst_49319 = (state_49473[(7)]);
var inst_49396 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_49319);
var state_49473__$1 = state_49473;
if(cljs.core.truth_(inst_49396)){
var statearr_49504_49580 = state_49473__$1;
(statearr_49504_49580[(1)] = (39));

} else {
var statearr_49505_49581 = state_49473__$1;
(statearr_49505_49581[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (41))){
var inst_49437 = (state_49473[(2)]);
var state_49473__$1 = state_49473;
var statearr_49506_49582 = state_49473__$1;
(statearr_49506_49582[(2)] = inst_49437);

(statearr_49506_49582[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (43))){
var inst_49319 = (state_49473[(7)]);
var inst_49411 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_49319);
var state_49473__$1 = state_49473;
var statearr_49507_49583 = state_49473__$1;
(statearr_49507_49583[(2)] = inst_49411);

(statearr_49507_49583[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (29))){
var inst_49319 = (state_49473[(7)]);
var inst_49362 = (state_49473[(15)]);
var inst_49352 = (state_49473[(12)]);
var inst_49368 = (state_49473[(18)]);
var inst_49362__$1 = cljs.core.first(inst_49352);
var inst_49363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49364 = cljs.core.first(inst_49362__$1);
var inst_49365 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_49364);
var inst_49366 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_49365];
var inst_49367 = (new cljs.core.PersistentVector(null,3,(5),inst_49363,inst_49366,null));
var inst_49368__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_49319,inst_49367);
var inst_49369 = fluree.db.query.fql.component_follow_QMARK_(inst_49368__$1,inst_49319);
var inst_49370 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_49368__$1);
var state_49473__$1 = (function (){var statearr_49508 = state_49473;
(statearr_49508[(14)] = inst_49369);

(statearr_49508[(15)] = inst_49362__$1);

(statearr_49508[(18)] = inst_49368__$1);

return statearr_49508;
})();
if(cljs.core.truth_(inst_49370)){
var statearr_49509_49584 = state_49473__$1;
(statearr_49509_49584[(1)] = (31));

} else {
var statearr_49510_49585 = state_49473__$1;
(statearr_49510_49585[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (44))){
var inst_49409 = (state_49473[(20)]);
var state_49473__$1 = state_49473;
var statearr_49511_49586 = state_49473__$1;
(statearr_49511_49586[(2)] = inst_49409);

(statearr_49511_49586[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (6))){
var state_49473__$1 = state_49473;
var statearr_49512_49587 = state_49473__$1;
(statearr_49512_49587[(2)] = null);

(statearr_49512_49587[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (28))){
var inst_49353 = (state_49473[(11)]);
var state_49473__$1 = state_49473;
var statearr_49513_49588 = state_49473__$1;
(statearr_49513_49588[(2)] = inst_49353);

(statearr_49513_49588[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (51))){
var inst_49433 = (state_49473[(2)]);
var state_49473__$1 = state_49473;
var statearr_49514_49589 = state_49473__$1;
(statearr_49514_49589[(2)] = inst_49433);

(statearr_49514_49589[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (25))){
var inst_49333 = (state_49473[(8)]);
var inst_49344 = (state_49473[(2)]);
var inst_49345 = fluree.db.util.async.throw_err(inst_49344);
var inst_49346 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_49333,inst_49345], 0));
var state_49473__$1 = state_49473;
var statearr_49515_49590 = state_49473__$1;
(statearr_49515_49590[(2)] = inst_49346);

(statearr_49515_49590[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (34))){
var inst_49372 = (state_49473[(19)]);
var inst_49352 = (state_49473[(12)]);
var inst_49354 = (state_49473[(13)]);
var inst_49375 = (state_49473[(2)]);
var inst_49376 = fluree.db.util.async.throw_err(inst_49375);
var inst_49377 = cljs.core.rest(inst_49352);
var inst_49378 = [inst_49376,inst_49377,inst_49354];
var inst_49379 = (new cljs.core.PersistentVector(null,3,(5),inst_49372,inst_49378,null));
var state_49473__$1 = state_49473;
var statearr_49516_49591 = state_49473__$1;
(statearr_49516_49591[(2)] = inst_49379);

(statearr_49516_49591[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (17))){
var inst_49319 = (state_49473[(7)]);
var inst_49323 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_49319);
var state_49473__$1 = state_49473;
var statearr_49518_49592 = state_49473__$1;
(statearr_49518_49592[(2)] = inst_49323);

(statearr_49518_49592[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (3))){
var inst_49471 = (state_49473[(2)]);
var state_49473__$1 = state_49473;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49473__$1,inst_49471);
} else {
if((state_val_49474 === (12))){
var _ = (function (){var statearr_49519 = state_49473;
(statearr_49519[(4)] = cljs.core.rest((state_49473[(4)])));

return statearr_49519;
})();
var state_49473__$1 = state_49473;
var ex49517 = (state_49473__$1[(2)]);
var statearr_49520_49593 = state_49473__$1;
(statearr_49520_49593[(5)] = ex49517);


var statearr_49521_49594 = state_49473__$1;
(statearr_49521_49594[(1)] = (11));

(statearr_49521_49594[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (2))){
var _ = (function (){var statearr_49522 = state_49473;
(statearr_49522[(4)] = cljs.core.cons((5),(state_49473[(4)])));

return statearr_49522;
})();
var inst_49299 = cljs.core.not_empty(flakes);
var state_49473__$1 = state_49473;
if(cljs.core.truth_(inst_49299)){
var statearr_49523_49595 = state_49473__$1;
(statearr_49523_49595[(1)] = (6));

} else {
var statearr_49524_49596 = state_49473__$1;
(statearr_49524_49596[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (23))){
var inst_49333 = (state_49473[(8)]);
var state_49473__$1 = state_49473;
var statearr_49525_49597 = state_49473__$1;
(statearr_49525_49597[(2)] = inst_49333);

(statearr_49525_49597[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (47))){
var state_49473__$1 = state_49473;
var statearr_49526_49598 = state_49473__$1;
(statearr_49526_49598[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (35))){
var inst_49369 = (state_49473[(14)]);
var inst_49353 = (state_49473[(11)]);
var inst_49362 = (state_49473[(15)]);
var inst_49368 = (state_49473[(18)]);
var inst_49354 = (state_49473[(13)]);
var inst_49385 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_49353,inst_49368,inst_49362,inst_49369,false,inst_49354);
var state_49473__$1 = state_49473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49473__$1,(38),inst_49385);
} else {
if((state_val_49474 === (19))){
var inst_49313 = (state_49473[(10)]);
var inst_49327 = [cljs.core.cst$kw$_id];
var inst_49328 = [inst_49313];
var inst_49329 = cljs.core.PersistentHashMap.fromArrays(inst_49327,inst_49328);
var state_49473__$1 = state_49473;
var statearr_49528_49599 = state_49473__$1;
(statearr_49528_49599[(2)] = inst_49329);

(statearr_49528_49599[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (11))){
var inst_49301 = (state_49473[(2)]);
var inst_49302 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_49301], 0));
var inst_49303 = (function(){throw inst_49301})();
var state_49473__$1 = (function (){var statearr_49530 = state_49473;
(statearr_49530[(21)] = inst_49302);

return statearr_49530;
})();
var statearr_49531_49600 = state_49473__$1;
(statearr_49531_49600[(2)] = inst_49303);

(statearr_49531_49600[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (9))){
var _ = (function (){var statearr_49532 = state_49473;
(statearr_49532[(4)] = cljs.core.cons((12),(state_49473[(4)])));

return statearr_49532;
})();
var inst_49309 = cljs.core.first(flakes);
var inst_49310 = fluree.db.query.fql.s(inst_49309);
var ___$1 = (function (){var statearr_49533 = state_49473;
(statearr_49533[(4)] = cljs.core.rest((state_49473[(4)])));

return statearr_49533;
})();
var state_49473__$1 = state_49473;
var statearr_49534_49601 = state_49473__$1;
(statearr_49534_49601[(2)] = inst_49310);

(statearr_49534_49601[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (5))){
var _ = (function (){var statearr_49535 = state_49473;
(statearr_49535[(4)] = cljs.core.rest((state_49473[(4)])));

return statearr_49535;
})();
var state_49473__$1 = state_49473;
var ex49529 = (state_49473__$1[(2)]);
var statearr_49536_49602 = state_49473__$1;
(statearr_49536_49602[(5)] = ex49529);


if((ex49529 instanceof Error)){
var statearr_49537_49603 = state_49473__$1;
(statearr_49537_49603[(1)] = (4));

(statearr_49537_49603[(5)] = null);

} else {
throw ex49529;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (14))){
var state_49473__$1 = state_49473;
var statearr_49538_49604 = state_49473__$1;
(statearr_49538_49604[(2)] = base_select_spec);

(statearr_49538_49604[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (45))){
var inst_49414 = (state_49473[(2)]);
var state_49473__$1 = state_49473;
if(cljs.core.truth_(inst_49414)){
var statearr_49539_49605 = state_49473__$1;
(statearr_49539_49605[(1)] = (46));

} else {
var statearr_49540_49606 = state_49473__$1;
(statearr_49540_49606[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (26))){
var inst_49352 = (state_49473[(12)]);
var inst_49356 = cljs.core.empty_QMARK_(inst_49352);
var state_49473__$1 = state_49473;
if(inst_49356){
var statearr_49541_49607 = state_49473__$1;
(statearr_49541_49607[(1)] = (28));

} else {
var statearr_49542_49608 = state_49473__$1;
(statearr_49542_49608[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (16))){
var inst_49320 = (state_49473[(17)]);
var state_49473__$1 = state_49473;
var statearr_49543_49609 = state_49473__$1;
(statearr_49543_49609[(2)] = inst_49320);

(statearr_49543_49609[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (38))){
var inst_49352 = (state_49473[(12)]);
var inst_49387 = (state_49473[(2)]);
var inst_49388 = fluree.db.util.async.throw_err(inst_49387);
var inst_49389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49388,(0),null);
var inst_49390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49388,(1),null);
var inst_49391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49392 = cljs.core.rest(inst_49352);
var inst_49393 = [inst_49389,inst_49392,inst_49390];
var inst_49394 = (new cljs.core.PersistentVector(null,3,(5),inst_49391,inst_49393,null));
var state_49473__$1 = state_49473;
var statearr_49544_49610 = state_49473__$1;
(statearr_49544_49610[(2)] = inst_49394);

(statearr_49544_49610[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (30))){
var inst_49450 = (state_49473[(2)]);
var state_49473__$1 = state_49473;
var statearr_49545_49611 = state_49473__$1;
(statearr_49545_49611[(2)] = inst_49450);

(statearr_49545_49611[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (10))){
var inst_49313 = (state_49473[(2)]);
var inst_49314 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_49473__$1 = (function (){var statearr_49546 = state_49473;
(statearr_49546[(10)] = inst_49313);

return statearr_49546;
})();
if(cljs.core.truth_(inst_49314)){
var statearr_49547_49612 = state_49473__$1;
(statearr_49547_49612[(1)] = (13));

} else {
var statearr_49548_49613 = state_49473__$1;
(statearr_49548_49613[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (18))){
var inst_49325 = (state_49473[(2)]);
var state_49473__$1 = state_49473;
if(cljs.core.truth_(inst_49325)){
var statearr_49549_49614 = state_49473__$1;
(statearr_49549_49614[(1)] = (19));

} else {
var statearr_49550_49615 = state_49473__$1;
(statearr_49550_49615[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (42))){
var inst_49398 = (state_49473[(16)]);
var inst_49352 = (state_49473[(12)]);
var inst_49354 = (state_49473[(13)]);
var inst_49401 = (state_49473[(2)]);
var inst_49402 = fluree.db.util.async.throw_err(inst_49401);
var inst_49403 = cljs.core.first(inst_49402);
var inst_49404 = cljs.core.rest(inst_49352);
var inst_49405 = [inst_49403,inst_49404,inst_49354];
var inst_49406 = (new cljs.core.PersistentVector(null,3,(5),inst_49398,inst_49405,null));
var state_49473__$1 = state_49473;
var statearr_49551_49616 = state_49473__$1;
(statearr_49551_49616[(2)] = inst_49406);

(statearr_49551_49616[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (37))){
var inst_49439 = (state_49473[(2)]);
var state_49473__$1 = state_49473;
var statearr_49552_49617 = state_49473__$1;
(statearr_49552_49617[(2)] = inst_49439);

(statearr_49552_49617[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (8))){
var inst_49468 = (state_49473[(2)]);
var _ = (function (){var statearr_49553 = state_49473;
(statearr_49553[(4)] = cljs.core.rest((state_49473[(4)])));

return statearr_49553;
})();
var state_49473__$1 = state_49473;
var statearr_49554_49618 = state_49473__$1;
(statearr_49554_49618[(2)] = inst_49468);

(statearr_49554_49618[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49474 === (49))){
var inst_49353 = (state_49473[(11)]);
var inst_49352 = (state_49473[(12)]);
var inst_49354 = (state_49473[(13)]);
var inst_49427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49428 = cljs.core.rest(inst_49352);
var inst_49429 = [inst_49353,inst_49428,inst_49354];
var inst_49430 = (new cljs.core.PersistentVector(null,3,(5),inst_49427,inst_49429,null));
var state_49473__$1 = state_49473;
var statearr_49555_49619 = state_49473__$1;
(statearr_49555_49619[(2)] = inst_49430);

(statearr_49555_49619[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__24298__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__24298__auto____0 = (function (){
var statearr_49556 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49556[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__24298__auto__);

(statearr_49556[(1)] = (1));

return statearr_49556;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__24298__auto____1 = (function (state_49473){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_49473);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e49557){var ex__24301__auto__ = e49557;
var statearr_49558_49620 = state_49473;
(statearr_49558_49620[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_49473[(4)]))){
var statearr_49559_49621 = state_49473;
(statearr_49559_49621[(1)] = cljs.core.first((state_49473[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__49622 = state_49473;
state_49473 = G__49622;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__24298__auto__ = function(state_49473){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__24298__auto____1.call(this,state_49473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__24298__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__24298__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_49560 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_49560[(6)] = c__24424__auto__);

return statearr_49560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__49625 = arguments.length;
switch (G__49625) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_49667){
var state_val_49668 = (state_49667[(1)]);
if((state_val_49668 === (7))){
var inst_49633 = (state_49667[(7)]);
var state_49667__$1 = state_49667;
var statearr_49669_49699 = state_49667__$1;
(statearr_49669_49699[(2)] = inst_49633);

(statearr_49669_49699[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49668 === (1))){
var state_49667__$1 = state_49667;
var statearr_49670_49700 = state_49667__$1;
(statearr_49670_49700[(2)] = null);

(statearr_49670_49700[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49668 === (4))){
var inst_49626 = (state_49667[(2)]);
var state_49667__$1 = state_49667;
var statearr_49671_49701 = state_49667__$1;
(statearr_49671_49701[(2)] = inst_49626);

(statearr_49671_49701[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49668 === (15))){
var inst_49661 = (state_49667[(2)]);
var inst_49662 = fluree.db.util.async.throw_err(inst_49661);
var _ = (function (){var statearr_49672 = state_49667;
(statearr_49672[(4)] = cljs.core.rest((state_49667[(4)])));

return statearr_49672;
})();
var state_49667__$1 = state_49667;
var statearr_49673_49702 = state_49667__$1;
(statearr_49673_49702[(2)] = inst_49662);

(statearr_49673_49702[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49668 === (13))){
var inst_49645 = (state_49667[(8)]);
var state_49667__$1 = state_49667;
var statearr_49674_49703 = state_49667__$1;
(statearr_49674_49703[(2)] = inst_49645);

(statearr_49674_49703[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49668 === (6))){
var inst_49633 = (state_49667[(7)]);
var inst_49635 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_49636 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_49633,inst_49635);
var state_49667__$1 = state_49667;
var statearr_49675_49704 = state_49667__$1;
(statearr_49675_49704[(2)] = inst_49636);

(statearr_49675_49704[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49668 === (3))){
var inst_49665 = (state_49667[(2)]);
var state_49667__$1 = state_49667;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49667__$1,inst_49665);
} else {
if((state_val_49668 === (12))){
var inst_49645 = (state_49667[(8)]);
var inst_49647 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_49648 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_49645,inst_49647);
var state_49667__$1 = state_49667;
var statearr_49676_49705 = state_49667__$1;
(statearr_49676_49705[(2)] = inst_49648);

(statearr_49676_49705[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49668 === (2))){
var _ = (function (){var statearr_49677 = state_49667;
(statearr_49677[(4)] = cljs.core.cons((5),(state_49667[(4)])));

return statearr_49677;
})();
var inst_49633 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_49667__$1 = (function (){var statearr_49678 = state_49667;
(statearr_49678[(7)] = inst_49633);

return statearr_49678;
})();
if(cljs.core.truth_(fuel)){
var statearr_49679_49706 = state_49667__$1;
(statearr_49679_49706[(1)] = (6));

} else {
var statearr_49680_49707 = state_49667__$1;
(statearr_49680_49707[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49668 === (11))){
var inst_49645 = (state_49667[(2)]);
var state_49667__$1 = (function (){var statearr_49682 = state_49667;
(statearr_49682[(8)] = inst_49645);

return statearr_49682;
})();
if(cljs.core.truth_(limit)){
var statearr_49683_49708 = state_49667__$1;
(statearr_49683_49708[(1)] = (12));

} else {
var statearr_49684_49709 = state_49667__$1;
(statearr_49684_49709[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49668 === (9))){
var inst_49639 = (state_49667[(9)]);
var inst_49641 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_49642 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_49639,inst_49641);
var state_49667__$1 = state_49667;
var statearr_49685_49710 = state_49667__$1;
(statearr_49685_49710[(2)] = inst_49642);

(statearr_49685_49710[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49668 === (5))){
var _ = (function (){var statearr_49686 = state_49667;
(statearr_49686[(4)] = cljs.core.rest((state_49667[(4)])));

return statearr_49686;
})();
var state_49667__$1 = state_49667;
var ex49681 = (state_49667__$1[(2)]);
var statearr_49687_49711 = state_49667__$1;
(statearr_49687_49711[(5)] = ex49681);


if((ex49681 instanceof Error)){
var statearr_49688_49712 = state_49667__$1;
(statearr_49688_49712[(1)] = (4));

(statearr_49688_49712[(5)] = null);

} else {
throw ex49681;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49668 === (14))){
var inst_49651 = (state_49667[(2)]);
var inst_49652 = (function (){return (function (x){
var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4210__auto__;
}
});
})();
var inst_49653 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_49652);
var inst_49654 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_49651,inst_49653);
var inst_49655 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_49654,flakes);
var inst_49656 = cljs.core.PersistentVector.EMPTY;
var inst_49657 = (function (){var xf = inst_49654;
var flakes_by_sub = inst_49655;
return (function (p1__49623_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__49623_SHARP_);
});
})();
var inst_49658 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_49657,inst_49655);
var inst_49659 = fluree.db.util.async.merge_into_QMARK_(inst_49656,inst_49658);
var state_49667__$1 = state_49667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49667__$1,(15),inst_49659);
} else {
if((state_val_49668 === (10))){
var inst_49639 = (state_49667[(9)]);
var state_49667__$1 = state_49667;
var statearr_49689_49713 = state_49667__$1;
(statearr_49689_49713[(2)] = inst_49639);

(statearr_49689_49713[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49668 === (8))){
var inst_49639 = (state_49667[(2)]);
var state_49667__$1 = (function (){var statearr_49690 = state_49667;
(statearr_49690[(9)] = inst_49639);

return statearr_49690;
})();
if(cljs.core.truth_(offset)){
var statearr_49691_49714 = state_49667__$1;
(statearr_49691_49714[(1)] = (9));

} else {
var statearr_49692_49715 = state_49667__$1;
(statearr_49692_49715[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__24298__auto__ = null;
var fluree$db$query$fql$state_machine__24298__auto____0 = (function (){
var statearr_49693 = [null,null,null,null,null,null,null,null,null,null];
(statearr_49693[(0)] = fluree$db$query$fql$state_machine__24298__auto__);

(statearr_49693[(1)] = (1));

return statearr_49693;
});
var fluree$db$query$fql$state_machine__24298__auto____1 = (function (state_49667){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_49667);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e49694){var ex__24301__auto__ = e49694;
var statearr_49695_49716 = state_49667;
(statearr_49695_49716[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_49667[(4)]))){
var statearr_49696_49717 = state_49667;
(statearr_49696_49717[(1)] = cljs.core.first((state_49667[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__49718 = state_49667;
state_49667 = G__49718;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__24298__auto__ = function(state_49667){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__24298__auto____1.call(this,state_49667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__24298__auto____0;
fluree$db$query$fql$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__24298__auto____1;
return fluree$db$query$fql$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_49697 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_49697[(6)] = c__24424__auto__);

return statearr_49697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__49720 = arguments.length;
switch (G__49720) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_49806){
var state_val_49807 = (state_49806[(1)]);
if((state_val_49807 === (7))){
var inst_49801 = (state_49806[(2)]);
var _ = (function (){var statearr_49809 = state_49806;
(statearr_49809[(4)] = cljs.core.rest((state_49806[(4)])));

return statearr_49809;
})();
var state_49806__$1 = state_49806;
var statearr_49810_49862 = state_49806__$1;
(statearr_49810_49862[(2)] = inst_49801);

(statearr_49810_49862[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (20))){
var inst_49741 = (state_49806[(7)]);
var inst_49748 = (state_49806[(8)]);
var inst_49740 = (state_49806[(9)]);
var inst_49769 = (inst_49740 + (1));
var tmp49808 = inst_49741;
var inst_49739 = inst_49748;
var inst_49740__$1 = inst_49769;
var inst_49741__$1 = tmp49808;
var state_49806__$1 = (function (){var statearr_49811 = state_49806;
(statearr_49811[(7)] = inst_49741__$1);

(statearr_49811[(10)] = inst_49739);

(statearr_49811[(9)] = inst_49740__$1);

return statearr_49811;
})();
var statearr_49812_49863 = state_49806__$1;
(statearr_49812_49863[(2)] = null);

(statearr_49812_49863[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (27))){
var inst_49779 = (state_49806[(11)]);
var inst_49781 = cljs.core.count(inst_49779);
var inst_49782 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_49781);
var state_49806__$1 = state_49806;
var statearr_49813_49864 = state_49806__$1;
(statearr_49813_49864[(2)] = inst_49782);

(statearr_49813_49864[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (1))){
var state_49806__$1 = state_49806;
var statearr_49814_49865 = state_49806__$1;
(statearr_49814_49865[(2)] = null);

(statearr_49814_49865[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (24))){
var state_49806__$1 = state_49806;
var statearr_49815_49866 = state_49806__$1;
(statearr_49815_49866[(2)] = null);

(statearr_49815_49866[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (4))){
var inst_49721 = (state_49806[(2)]);
var state_49806__$1 = state_49806;
var statearr_49816_49867 = state_49806__$1;
(statearr_49816_49867[(2)] = inst_49721);

(statearr_49816_49867[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (15))){
var inst_49762 = (state_49806[(12)]);
var inst_49762__$1 = offset;
var state_49806__$1 = (function (){var statearr_49817 = state_49806;
(statearr_49817[(12)] = inst_49762__$1);

return statearr_49817;
})();
if(cljs.core.truth_(inst_49762__$1)){
var statearr_49818_49868 = state_49806__$1;
(statearr_49818_49868[(1)] = (17));

} else {
var statearr_49819_49869 = state_49806__$1;
(statearr_49819_49869[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (21))){
var state_49806__$1 = state_49806;
var statearr_49820_49870 = state_49806__$1;
(statearr_49820_49870[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (13))){
var inst_49757 = (state_49806[(2)]);
var state_49806__$1 = state_49806;
var statearr_49822_49871 = state_49806__$1;
(statearr_49822_49871[(2)] = inst_49757);

(statearr_49822_49871[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (22))){
var inst_49797 = (state_49806[(2)]);
var state_49806__$1 = state_49806;
var statearr_49823_49872 = state_49806__$1;
(statearr_49823_49872[(2)] = inst_49797);

(statearr_49823_49872[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (29))){
var inst_49779 = (state_49806[(11)]);
var inst_49740 = (state_49806[(9)]);
var inst_49785 = (state_49806[(2)]);
var inst_49786 = (inst_49740 + (1));
var inst_49787 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_49779);
var state_49806__$1 = (function (){var statearr_49824 = state_49806;
(statearr_49824[(13)] = inst_49785);

(statearr_49824[(14)] = inst_49786);

return statearr_49824;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49806__$1,(30),inst_49787);
} else {
if((state_val_49807 === (6))){
var inst_49749 = (state_49806[(15)]);
var inst_49747 = (state_49806[(16)]);
var inst_49739 = (state_49806[(10)]);
var inst_49746 = cljs.core.seq(inst_49739);
var inst_49747__$1 = cljs.core.first(inst_49746);
var inst_49748 = cljs.core.next(inst_49746);
var inst_49749__$1 = (inst_49747__$1 == null);
var state_49806__$1 = (function (){var statearr_49825 = state_49806;
(statearr_49825[(15)] = inst_49749__$1);

(statearr_49825[(16)] = inst_49747__$1);

(statearr_49825[(8)] = inst_49748);

return statearr_49825;
})();
if(cljs.core.truth_(inst_49749__$1)){
var statearr_49826_49873 = state_49806__$1;
(statearr_49826_49873[(1)] = (8));

} else {
var statearr_49827_49874 = state_49806__$1;
(statearr_49827_49874[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (28))){
var state_49806__$1 = state_49806;
var statearr_49828_49875 = state_49806__$1;
(statearr_49828_49875[(2)] = null);

(statearr_49828_49875[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (25))){
var inst_49795 = (state_49806[(2)]);
var state_49806__$1 = state_49806;
var statearr_49829_49876 = state_49806__$1;
(statearr_49829_49876[(2)] = inst_49795);

(statearr_49829_49876[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (17))){
var inst_49740 = (state_49806[(9)]);
var inst_49764 = (inst_49740 < offset);
var state_49806__$1 = state_49806;
var statearr_49830_49877 = state_49806__$1;
(statearr_49830_49877[(2)] = inst_49764);

(statearr_49830_49877[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (3))){
var inst_49804 = (state_49806[(2)]);
var state_49806__$1 = state_49806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49806__$1,inst_49804);
} else {
if((state_val_49807 === (12))){
var inst_49752 = (state_49806[(17)]);
var state_49806__$1 = state_49806;
var statearr_49831_49878 = state_49806__$1;
(statearr_49831_49878[(2)] = inst_49752);

(statearr_49831_49878[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (2))){
var _ = (function (){var statearr_49832 = state_49806;
(statearr_49832[(4)] = cljs.core.cons((5),(state_49806[(4)])));

return statearr_49832;
})();
var inst_49734 = subjects;
var inst_49735 = cljs.core.seq(inst_49734);
var inst_49736 = cljs.core.first(inst_49735);
var inst_49737 = cljs.core.next(inst_49735);
var inst_49738 = cljs.core.PersistentVector.EMPTY;
var inst_49739 = inst_49734;
var inst_49740 = (0);
var inst_49741 = inst_49738;
var state_49806__$1 = (function (){var statearr_49833 = state_49806;
(statearr_49833[(18)] = inst_49736);

(statearr_49833[(7)] = inst_49741);

(statearr_49833[(19)] = inst_49737);

(statearr_49833[(10)] = inst_49739);

(statearr_49833[(9)] = inst_49740);

return statearr_49833;
})();
var statearr_49834_49879 = state_49806__$1;
(statearr_49834_49879[(2)] = null);

(statearr_49834_49879[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (23))){
var inst_49747 = (state_49806[(16)]);
var inst_49773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49774 = [inst_49747];
var inst_49775 = (new cljs.core.PersistentVector(null,1,(5),inst_49773,inst_49774,null));
var inst_49776 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_49775);
var state_49806__$1 = state_49806;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49806__$1,(26),inst_49776);
} else {
if((state_val_49807 === (19))){
var inst_49767 = (state_49806[(2)]);
var state_49806__$1 = state_49806;
if(cljs.core.truth_(inst_49767)){
var statearr_49835_49880 = state_49806__$1;
(statearr_49835_49880[(1)] = (20));

} else {
var statearr_49836_49881 = state_49806__$1;
(statearr_49836_49881[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (11))){
var inst_49740 = (state_49806[(9)]);
var inst_49754 = (inst_49740 > limit);
var state_49806__$1 = state_49806;
var statearr_49838_49882 = state_49806__$1;
(statearr_49838_49882[(2)] = inst_49754);

(statearr_49838_49882[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (9))){
var inst_49752 = (state_49806[(17)]);
var inst_49752__$1 = limit;
var state_49806__$1 = (function (){var statearr_49839 = state_49806;
(statearr_49839[(17)] = inst_49752__$1);

return statearr_49839;
})();
if(cljs.core.truth_(inst_49752__$1)){
var statearr_49840_49883 = state_49806__$1;
(statearr_49840_49883[(1)] = (11));

} else {
var statearr_49841_49884 = state_49806__$1;
(statearr_49841_49884[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (5))){
var _ = (function (){var statearr_49842 = state_49806;
(statearr_49842[(4)] = cljs.core.rest((state_49806[(4)])));

return statearr_49842;
})();
var state_49806__$1 = state_49806;
var ex49837 = (state_49806__$1[(2)]);
var statearr_49843_49885 = state_49806__$1;
(statearr_49843_49885[(5)] = ex49837);


if((ex49837 instanceof Error)){
var statearr_49844_49886 = state_49806__$1;
(statearr_49844_49886[(1)] = (4));

(statearr_49844_49886[(5)] = null);

} else {
throw ex49837;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (14))){
var inst_49741 = (state_49806[(7)]);
var state_49806__$1 = state_49806;
var statearr_49845_49887 = state_49806__$1;
(statearr_49845_49887[(2)] = inst_49741);

(statearr_49845_49887[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (26))){
var inst_49778 = (state_49806[(2)]);
var inst_49779 = fluree.db.util.async.throw_err(inst_49778);
var state_49806__$1 = (function (){var statearr_49846 = state_49806;
(statearr_49846[(11)] = inst_49779);

return statearr_49846;
})();
if(cljs.core.truth_(fuel)){
var statearr_49847_49888 = state_49806__$1;
(statearr_49847_49888[(1)] = (27));

} else {
var statearr_49848_49889 = state_49806__$1;
(statearr_49848_49889[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (16))){
var inst_49799 = (state_49806[(2)]);
var state_49806__$1 = state_49806;
var statearr_49849_49890 = state_49806__$1;
(statearr_49849_49890[(2)] = inst_49799);

(statearr_49849_49890[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (30))){
var inst_49786 = (state_49806[(14)]);
var inst_49741 = (state_49806[(7)]);
var inst_49748 = (state_49806[(8)]);
var inst_49789 = (state_49806[(2)]);
var inst_49790 = fluree.db.util.async.throw_err(inst_49789);
var inst_49791 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_49741,inst_49790);
var inst_49739 = inst_49748;
var inst_49740 = inst_49786;
var inst_49741__$1 = inst_49791;
var state_49806__$1 = (function (){var statearr_49850 = state_49806;
(statearr_49850[(7)] = inst_49741__$1);

(statearr_49850[(10)] = inst_49739);

(statearr_49850[(9)] = inst_49740);

return statearr_49850;
})();
var statearr_49851_49891 = state_49806__$1;
(statearr_49851_49891[(2)] = null);

(statearr_49851_49891[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (10))){
var inst_49759 = (state_49806[(2)]);
var state_49806__$1 = state_49806;
if(cljs.core.truth_(inst_49759)){
var statearr_49852_49892 = state_49806__$1;
(statearr_49852_49892[(1)] = (14));

} else {
var statearr_49853_49893 = state_49806__$1;
(statearr_49853_49893[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (18))){
var inst_49762 = (state_49806[(12)]);
var state_49806__$1 = state_49806;
var statearr_49854_49894 = state_49806__$1;
(statearr_49854_49894[(2)] = inst_49762);

(statearr_49854_49894[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49807 === (8))){
var inst_49749 = (state_49806[(15)]);
var state_49806__$1 = state_49806;
var statearr_49855_49895 = state_49806__$1;
(statearr_49855_49895[(2)] = inst_49749);

(statearr_49855_49895[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__24298__auto__ = null;
var fluree$db$query$fql$state_machine__24298__auto____0 = (function (){
var statearr_49856 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49856[(0)] = fluree$db$query$fql$state_machine__24298__auto__);

(statearr_49856[(1)] = (1));

return statearr_49856;
});
var fluree$db$query$fql$state_machine__24298__auto____1 = (function (state_49806){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_49806);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e49857){var ex__24301__auto__ = e49857;
var statearr_49858_49896 = state_49806;
(statearr_49858_49896[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_49806[(4)]))){
var statearr_49859_49897 = state_49806;
(statearr_49859_49897[(1)] = cljs.core.first((state_49806[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__49898 = state_49806;
state_49806 = G__49898;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__24298__auto__ = function(state_49806){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__24298__auto____1.call(this,state_49806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__24298__auto____0;
fluree$db$query$fql$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__24298__auto____1;
return fluree$db$query$fql$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_49860 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_49860[(6)] = c__24424__auto__);

return statearr_49860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4212__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__49900 = arguments.length;
switch (G__49900) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_50091){
var state_val_50092 = (state_50091[(1)]);
if((state_val_50092 === (7))){
var state_50091__$1 = state_50091;
var statearr_50093_50168 = state_50091__$1;
(statearr_50093_50168[(2)] = null);

(statearr_50093_50168[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (20))){
var inst_49943 = (state_50091[(7)]);
var inst_49941 = (state_50091[(8)]);
var inst_49971 = (state_50091[(2)]);
var inst_49972 = fluree.db.util.async.throw_err(inst_49971);
var inst_49973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49974 = [inst_49941];
var inst_49975 = (new cljs.core.PersistentVector(null,1,(5),inst_49973,inst_49974,null));
var inst_49976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49977 = [inst_49941,inst_49943];
var inst_49978 = (new cljs.core.PersistentVector(null,2,(5),inst_49976,inst_49977,null));
var inst_49979 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_49975,cljs.core._LT_,inst_49978);
var state_50091__$1 = (function (){var statearr_50094 = state_50091;
(statearr_50094[(9)] = inst_49972);

return statearr_50094;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50091__$1,(21),inst_49979);
} else {
if((state_val_50092 === (27))){
var inst_49942 = (state_50091[(10)]);
var inst_49960 = (state_50091[(11)]);
var inst_50008 = (inst_49960.cljs$core$IFn$_invoke$arity$2 ? inst_49960.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_49942) : inst_49960.call(null,cljs.core._GT__EQ_,inst_49942));
var state_50091__$1 = state_50091;
if(cljs.core.truth_(inst_50008)){
var statearr_50095_50169 = state_50091__$1;
(statearr_50095_50169[(1)] = (30));

} else {
var statearr_50096_50170 = state_50091__$1;
(statearr_50096_50170[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (1))){
var state_50091__$1 = state_50091;
var statearr_50097_50171 = state_50091__$1;
(statearr_50097_50171[(2)] = null);

(statearr_50097_50171[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (24))){
var inst_50057 = (state_50091[(2)]);
var state_50091__$1 = state_50091;
var statearr_50098_50172 = state_50091__$1;
(statearr_50098_50172[(2)] = inst_50057);

(statearr_50098_50172[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (39))){
var inst_50047 = null;
var state_50091__$1 = state_50091;
var statearr_50099_50173 = state_50091__$1;
(statearr_50099_50173[(2)] = inst_50047);

(statearr_50099_50173[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (46))){
var inst_50069 = (state_50091[(12)]);
var state_50091__$1 = state_50091;
var statearr_50100_50174 = state_50091__$1;
(statearr_50100_50174[(2)] = inst_50069);

(statearr_50100_50174[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (4))){
var inst_49901 = (state_50091[(2)]);
var state_50091__$1 = state_50091;
var statearr_50101_50175 = state_50091__$1;
(statearr_50101_50175[(2)] = inst_49901);

(statearr_50101_50175[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (15))){
var state_50091__$1 = state_50091;
var statearr_50102_50176 = state_50091__$1;
(statearr_50102_50176[(2)] = null);

(statearr_50102_50176[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (48))){
var inst_50068 = (state_50091[(13)]);
var state_50091__$1 = state_50091;
var statearr_50103_50177 = state_50091__$1;
(statearr_50103_50177[(2)] = inst_50068);

(statearr_50103_50177[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (50))){
var inst_50079 = (state_50091[(2)]);
var state_50091__$1 = state_50091;
var statearr_50104_50178 = state_50091__$1;
(statearr_50104_50178[(2)] = inst_50079);

(statearr_50104_50178[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (21))){
var inst_49972 = (state_50091[(9)]);
var inst_49981 = (state_50091[(2)]);
var inst_49982 = fluree.db.util.async.throw_err(inst_49981);
var inst_49983 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_49972,inst_49982);
var state_50091__$1 = state_50091;
var statearr_50105_50179 = state_50091__$1;
(statearr_50105_50179[(2)] = inst_49983);

(statearr_50105_50179[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (31))){
var inst_49942 = (state_50091[(10)]);
var inst_49960 = (state_50091[(11)]);
var inst_50021 = (inst_49960.cljs$core$IFn$_invoke$arity$2 ? inst_49960.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_49942) : inst_49960.call(null,cljs.core._LT_,inst_49942));
var state_50091__$1 = state_50091;
if(cljs.core.truth_(inst_50021)){
var statearr_50106_50180 = state_50091__$1;
(statearr_50106_50180[(1)] = (34));

} else {
var statearr_50107_50181 = state_50091__$1;
(statearr_50107_50181[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (32))){
var inst_50053 = (state_50091[(2)]);
var state_50091__$1 = state_50091;
var statearr_50108_50182 = state_50091__$1;
(statearr_50108_50182[(2)] = inst_50053);

(statearr_50108_50182[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (40))){
var inst_50049 = (state_50091[(2)]);
var state_50091__$1 = state_50091;
var statearr_50109_50183 = state_50091__$1;
(statearr_50109_50183[(2)] = inst_50049);

(statearr_50109_50183[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (33))){
var inst_50018 = (state_50091[(2)]);
var inst_50019 = fluree.db.util.async.throw_err(inst_50018);
var state_50091__$1 = state_50091;
var statearr_50110_50184 = state_50091__$1;
(statearr_50110_50184[(2)] = inst_50019);

(statearr_50110_50184[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (13))){
var inst_50081 = (state_50091[(2)]);
var state_50091__$1 = state_50091;
var statearr_50111_50185 = state_50091__$1;
(statearr_50111_50185[(2)] = inst_50081);

(statearr_50111_50185[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (22))){
var inst_49943 = (state_50091[(7)]);
var inst_49941 = (state_50091[(8)]);
var inst_49987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49988 = [inst_49941,inst_49943];
var inst_49989 = (new cljs.core.PersistentVector(null,2,(5),inst_49987,inst_49988,null));
var inst_49990 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_49989);
var state_50091__$1 = state_50091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50091__$1,(25),inst_49990);
} else {
if((state_val_50092 === (36))){
var inst_50051 = (state_50091[(2)]);
var state_50091__$1 = state_50091;
var statearr_50112_50186 = state_50091__$1;
(statearr_50112_50186[(2)] = inst_50051);

(statearr_50112_50186[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (41))){
var inst_50044 = (state_50091[(2)]);
var inst_50045 = fluree.db.util.async.throw_err(inst_50044);
var state_50091__$1 = state_50091;
var statearr_50113_50187 = state_50091__$1;
(statearr_50113_50187[(2)] = inst_50045);

(statearr_50113_50187[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (43))){
var inst_49927 = (state_50091[(14)]);
var inst_50060 = (state_50091[(15)]);
var inst_50061 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_49927,inst_50060);
var state_50091__$1 = state_50091;
var statearr_50114_50188 = state_50091__$1;
(statearr_50114_50188[(2)] = inst_50061);

(statearr_50114_50188[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (29))){
var inst_50005 = (state_50091[(2)]);
var inst_50006 = fluree.db.util.async.throw_err(inst_50005);
var state_50091__$1 = state_50091;
var statearr_50115_50189 = state_50091__$1;
(statearr_50115_50189[(2)] = inst_50006);

(statearr_50115_50189[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (44))){
var inst_49927 = (state_50091[(14)]);
var inst_50060 = (state_50091[(15)]);
var inst_50063 = cljs.core.PersistentHashSet.EMPTY;
var inst_50064 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_50063,inst_50060);
var inst_50065 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_49927,inst_50064);
var state_50091__$1 = state_50091;
var statearr_50116_50190 = state_50091__$1;
(statearr_50116_50190[(2)] = inst_50065);

(statearr_50116_50190[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (6))){
var inst_49912 = (state_50091[(16)]);
var inst_49922 = cljs.core.seq(inst_49912);
var inst_49923 = cljs.core.first(inst_49922);
var inst_49924 = cljs.core.next(inst_49922);
var inst_49925 = cljs.core.PersistentHashSet.EMPTY;
var inst_49926 = inst_49912;
var inst_49927 = inst_49925;
var state_50091__$1 = (function (){var statearr_50117 = state_50091;
(statearr_50117[(17)] = inst_49924);

(statearr_50117[(18)] = inst_49923);

(statearr_50117[(19)] = inst_49926);

(statearr_50117[(14)] = inst_49927);

return statearr_50117;
})();
var statearr_50118_50191 = state_50091__$1;
(statearr_50118_50191[(2)] = null);

(statearr_50118_50191[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (28))){
var inst_50055 = (state_50091[(2)]);
var state_50091__$1 = state_50091;
var statearr_50119_50192 = state_50091__$1;
(statearr_50119_50192[(2)] = inst_50055);

(statearr_50119_50192[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (25))){
var inst_49992 = (state_50091[(2)]);
var inst_49993 = fluree.db.util.async.throw_err(inst_49992);
var state_50091__$1 = state_50091;
var statearr_50120_50193 = state_50091__$1;
(statearr_50120_50193[(2)] = inst_49993);

(statearr_50120_50193[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (34))){
var inst_49943 = (state_50091[(7)]);
var inst_49941 = (state_50091[(8)]);
var inst_50023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50024 = [inst_49941];
var inst_50025 = (new cljs.core.PersistentVector(null,1,(5),inst_50023,inst_50024,null));
var inst_50026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50027 = [inst_49941,inst_49943];
var inst_50028 = (new cljs.core.PersistentVector(null,2,(5),inst_50026,inst_50027,null));
var inst_50029 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_50025,cljs.core._LT_,inst_50028);
var state_50091__$1 = state_50091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50091__$1,(37),inst_50029);
} else {
if((state_val_50092 === (17))){
var inst_49943 = (state_50091[(7)]);
var inst_49941 = (state_50091[(8)]);
var inst_49963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49964 = [inst_49941,inst_49943];
var inst_49965 = (new cljs.core.PersistentVector(null,2,(5),inst_49963,inst_49964,null));
var inst_49966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49967 = [inst_49941];
var inst_49968 = (new cljs.core.PersistentVector(null,1,(5),inst_49966,inst_49967,null));
var inst_49969 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_49965,cljs.core._LT__EQ_,inst_49968);
var state_50091__$1 = state_50091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50091__$1,(20),inst_49969);
} else {
if((state_val_50092 === (3))){
var inst_50089 = (state_50091[(2)]);
var state_50091__$1 = state_50091;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50091__$1,inst_50089);
} else {
if((state_val_50092 === (12))){
var inst_49933 = (state_50091[(20)]);
var inst_49941 = (state_50091[(8)]);
var inst_49941__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49933,(0),null);
var inst_49942 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49933,(1),null);
var inst_49943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49933,(2),null);
var inst_49944 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_49941__$1);
var inst_49945 = cljs.core.not(inst_49944);
var state_50091__$1 = (function (){var statearr_50121 = state_50091;
(statearr_50121[(7)] = inst_49943);

(statearr_50121[(10)] = inst_49942);

(statearr_50121[(8)] = inst_49941__$1);

return statearr_50121;
})();
if(inst_49945){
var statearr_50122_50194 = state_50091__$1;
(statearr_50122_50194[(1)] = (14));

} else {
var statearr_50123_50195 = state_50091__$1;
(statearr_50123_50195[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (2))){
var inst_49912 = (state_50091[(16)]);
var _ = (function (){var statearr_50124 = state_50091;
(statearr_50124[(4)] = cljs.core.cons((5),(state_50091[(4)])));

return statearr_50124;
})();
var inst_49910 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_49911 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49910,(0),null);
var inst_49912__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49910,(1),null);
var inst_49913 = cljs.core.not_empty(inst_49912__$1);
var state_50091__$1 = (function (){var statearr_50125 = state_50091;
(statearr_50125[(16)] = inst_49912__$1);

(statearr_50125[(21)] = inst_49911);

return statearr_50125;
})();
if(cljs.core.truth_(inst_49913)){
var statearr_50126_50196 = state_50091__$1;
(statearr_50126_50196[(1)] = (6));

} else {
var statearr_50127_50197 = state_50091__$1;
(statearr_50127_50197[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (23))){
var inst_49942 = (state_50091[(10)]);
var inst_49960 = (state_50091[(11)]);
var inst_49995 = (inst_49960.cljs$core$IFn$_invoke$arity$2 ? inst_49960.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_49942) : inst_49960.call(null,cljs.core._GT_,inst_49942));
var state_50091__$1 = state_50091;
if(cljs.core.truth_(inst_49995)){
var statearr_50128_50198 = state_50091__$1;
(statearr_50128_50198[(1)] = (26));

} else {
var statearr_50129_50199 = state_50091__$1;
(statearr_50129_50199[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (47))){
var inst_50074 = (state_50091[(2)]);
var state_50091__$1 = state_50091;
if(cljs.core.truth_(inst_50074)){
var statearr_50130_50200 = state_50091__$1;
(statearr_50130_50200[(1)] = (48));

} else {
var statearr_50131_50201 = state_50091__$1;
(statearr_50131_50201[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (35))){
var inst_49942 = (state_50091[(10)]);
var inst_49960 = (state_50091[(11)]);
var inst_50034 = (inst_49960.cljs$core$IFn$_invoke$arity$2 ? inst_49960.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_49942) : inst_49960.call(null,cljs.core._LT__EQ_,inst_49942));
var state_50091__$1 = state_50091;
if(cljs.core.truth_(inst_50034)){
var statearr_50132_50202 = state_50091__$1;
(statearr_50132_50202[(1)] = (38));

} else {
var statearr_50133_50203 = state_50091__$1;
(statearr_50133_50203[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (19))){
var inst_49911 = (state_50091[(21)]);
var inst_50059 = (state_50091[(2)]);
var inst_50060 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_50059);
var state_50091__$1 = (function (){var statearr_50134 = state_50091;
(statearr_50134[(15)] = inst_50060);

return statearr_50134;
})();
var G__50135_50204 = inst_49911;
var G__50135_50205__$1 = (((G__50135_50204 instanceof cljs.core.Keyword))?G__50135_50204.fqn:null);
switch (G__50135_50205__$1) {
case "or":
var statearr_50136_50207 = state_50091__$1;
(statearr_50136_50207[(1)] = (43));


break;
case "and":
var statearr_50137_50208 = state_50091__$1;
(statearr_50137_50208[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__50135_50205__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (11))){
var inst_49927 = (state_50091[(14)]);
var state_50091__$1 = state_50091;
var statearr_50139_50209 = state_50091__$1;
(statearr_50139_50209[(2)] = inst_49927);

(statearr_50139_50209[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (9))){
var inst_49933 = (state_50091[(20)]);
var inst_49926 = (state_50091[(19)]);
var inst_49932 = cljs.core.seq(inst_49926);
var inst_49933__$1 = cljs.core.first(inst_49932);
var inst_49934 = cljs.core.next(inst_49932);
var inst_49935 = cljs.core.not(inst_49933__$1);
var state_50091__$1 = (function (){var statearr_50140 = state_50091;
(statearr_50140[(20)] = inst_49933__$1);

(statearr_50140[(22)] = inst_49934);

return statearr_50140;
})();
if(inst_49935){
var statearr_50141_50210 = state_50091__$1;
(statearr_50141_50210[(1)] = (11));

} else {
var statearr_50142_50211 = state_50091__$1;
(statearr_50142_50211[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (5))){
var _ = (function (){var statearr_50143 = state_50091;
(statearr_50143[(4)] = cljs.core.rest((state_50091[(4)])));

return statearr_50143;
})();
var state_50091__$1 = state_50091;
var ex50138 = (state_50091__$1[(2)]);
var statearr_50144_50212 = state_50091__$1;
(statearr_50144_50212[(5)] = ex50138);


if((ex50138 instanceof Error)){
var statearr_50145_50213 = state_50091__$1;
(statearr_50145_50213[(1)] = (4));

(statearr_50145_50213[(5)] = null);

} else {
throw ex50138;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (14))){
var inst_49941 = (state_50091[(8)]);
var inst_49947 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_49941);
var inst_49948 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_49947)].join('');
var inst_49949 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_49950 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_49951 = cljs.core.PersistentHashMap.fromArrays(inst_49949,inst_49950);
var inst_49952 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_49948,inst_49951);
var inst_49953 = (function(){throw inst_49952})();
var state_50091__$1 = state_50091;
var statearr_50146_50214 = state_50091__$1;
(statearr_50146_50214[(2)] = inst_49953);

(statearr_50146_50214[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (45))){
var inst_50068 = (state_50091[(13)]);
var inst_50071 = cljs.core.empty_QMARK_(inst_50068);
var state_50091__$1 = state_50091;
var statearr_50147_50215 = state_50091__$1;
(statearr_50147_50215[(2)] = inst_50071);

(statearr_50147_50215[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (26))){
var inst_49943 = (state_50091[(7)]);
var inst_49941 = (state_50091[(8)]);
var inst_49997 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49998 = [inst_49941,inst_49943];
var inst_49999 = (new cljs.core.PersistentVector(null,2,(5),inst_49997,inst_49998,null));
var inst_50000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50001 = [inst_49941];
var inst_50002 = (new cljs.core.PersistentVector(null,1,(5),inst_50000,inst_50001,null));
var inst_50003 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_49999,cljs.core._LT__EQ_,inst_50002);
var state_50091__$1 = state_50091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50091__$1,(29),inst_50003);
} else {
if((state_val_50092 === (16))){
var inst_49942 = (state_50091[(10)]);
var inst_49960 = (state_50091[(11)]);
var inst_49956 = (state_50091[(2)]);
var inst_49960__$1 = cljs.core.identical_QMARK_;
var inst_49961 = (inst_49960__$1.cljs$core$IFn$_invoke$arity$2 ? inst_49960__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_49942) : inst_49960__$1.call(null,cljs.core.not_EQ_,inst_49942));
var state_50091__$1 = (function (){var statearr_50148 = state_50091;
(statearr_50148[(23)] = inst_49956);

(statearr_50148[(11)] = inst_49960__$1);

return statearr_50148;
})();
if(cljs.core.truth_(inst_49961)){
var statearr_50149_50216 = state_50091__$1;
(statearr_50149_50216[(1)] = (17));

} else {
var statearr_50150_50217 = state_50091__$1;
(statearr_50150_50217[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (38))){
var inst_49943 = (state_50091[(7)]);
var inst_49941 = (state_50091[(8)]);
var inst_50036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50037 = [inst_49941];
var inst_50038 = (new cljs.core.PersistentVector(null,1,(5),inst_50036,inst_50037,null));
var inst_50039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50040 = [inst_49941,inst_49943];
var inst_50041 = (new cljs.core.PersistentVector(null,2,(5),inst_50039,inst_50040,null));
var inst_50042 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_50038,cljs.core._LT__EQ_,inst_50041);
var state_50091__$1 = state_50091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50091__$1,(41),inst_50042);
} else {
if((state_val_50092 === (30))){
var inst_49943 = (state_50091[(7)]);
var inst_49941 = (state_50091[(8)]);
var inst_50010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50011 = [inst_49941,inst_49943];
var inst_50012 = (new cljs.core.PersistentVector(null,2,(5),inst_50010,inst_50011,null));
var inst_50013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50014 = [inst_49941];
var inst_50015 = (new cljs.core.PersistentVector(null,1,(5),inst_50013,inst_50014,null));
var inst_50016 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_50012,cljs.core._LT__EQ_,inst_50015);
var state_50091__$1 = state_50091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50091__$1,(33),inst_50016);
} else {
if((state_val_50092 === (10))){
var inst_50083 = (state_50091[(2)]);
var state_50091__$1 = state_50091;
var statearr_50151_50218 = state_50091__$1;
(statearr_50151_50218[(2)] = inst_50083);

(statearr_50151_50218[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (18))){
var inst_49942 = (state_50091[(10)]);
var inst_49960 = (state_50091[(11)]);
var inst_49985 = (inst_49960.cljs$core$IFn$_invoke$arity$2 ? inst_49960.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_49942) : inst_49960.call(null,cljs.core._EQ_,inst_49942));
var state_50091__$1 = state_50091;
if(cljs.core.truth_(inst_49985)){
var statearr_50152_50219 = state_50091__$1;
(statearr_50152_50219[(1)] = (22));

} else {
var statearr_50153_50220 = state_50091__$1;
(statearr_50153_50220[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (42))){
var inst_50069 = (state_50091[(12)]);
var inst_49911 = (state_50091[(21)]);
var inst_50068 = (state_50091[(2)]);
var inst_50069__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_49911);
var state_50091__$1 = (function (){var statearr_50154 = state_50091;
(statearr_50154[(12)] = inst_50069__$1);

(statearr_50154[(13)] = inst_50068);

return statearr_50154;
})();
if(inst_50069__$1){
var statearr_50155_50221 = state_50091__$1;
(statearr_50155_50221[(1)] = (45));

} else {
var statearr_50156_50222 = state_50091__$1;
(statearr_50156_50222[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (37))){
var inst_50031 = (state_50091[(2)]);
var inst_50032 = fluree.db.util.async.throw_err(inst_50031);
var state_50091__$1 = state_50091;
var statearr_50157_50223 = state_50091__$1;
(statearr_50157_50223[(2)] = inst_50032);

(statearr_50157_50223[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (8))){
var inst_50086 = (state_50091[(2)]);
var _ = (function (){var statearr_50158 = state_50091;
(statearr_50158[(4)] = cljs.core.rest((state_50091[(4)])));

return statearr_50158;
})();
var state_50091__$1 = state_50091;
var statearr_50159_50224 = state_50091__$1;
(statearr_50159_50224[(2)] = inst_50086);

(statearr_50159_50224[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50092 === (49))){
var inst_49934 = (state_50091[(22)]);
var inst_50068 = (state_50091[(13)]);
var inst_49926 = inst_49934;
var inst_49927 = inst_50068;
var state_50091__$1 = (function (){var statearr_50160 = state_50091;
(statearr_50160[(19)] = inst_49926);

(statearr_50160[(14)] = inst_49927);

return statearr_50160;
})();
var statearr_50161_50225 = state_50091__$1;
(statearr_50161_50225[(2)] = null);

(statearr_50161_50225[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__24298__auto__ = null;
var fluree$db$query$fql$state_machine__24298__auto____0 = (function (){
var statearr_50162 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50162[(0)] = fluree$db$query$fql$state_machine__24298__auto__);

(statearr_50162[(1)] = (1));

return statearr_50162;
});
var fluree$db$query$fql$state_machine__24298__auto____1 = (function (state_50091){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_50091);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e50163){var ex__24301__auto__ = e50163;
var statearr_50164_50226 = state_50091;
(statearr_50164_50226[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_50091[(4)]))){
var statearr_50165_50227 = state_50091;
(statearr_50165_50227[(1)] = cljs.core.first((state_50091[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__50228 = state_50091;
state_50091 = G__50228;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__24298__auto__ = function(state_50091){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__24298__auto____1.call(this,state_50091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__24298__auto____0;
fluree$db$query$fql$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__24298__auto____1;
return fluree$db$query$fql$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_50166 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_50166[(6)] = c__24424__auto__);

return statearr_50166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4212__auto__ = cljs.core.every_QMARK_((function (p1__50229_SHARP_){
return ((typeof p1__50229_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__50229_SHARP_)));
}),select_smt);
if(or__4212__auto__){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__50230_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__50230_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__50234 = vars;
var vec__50235 = G__50234;
var seq__50236 = cljs.core.seq(vec__50235);
var first__50237 = cljs.core.first(seq__50236);
var seq__50236__$1 = cljs.core.next(seq__50236);
var var$ = first__50237;
var r = seq__50236__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__50234__$1 = G__50234;
var all_vars__$1 = all_vars;
while(true){
var vec__50242 = G__50234__$1;
var seq__50243 = cljs.core.seq(vec__50242);
var first__50244 = cljs.core.first(seq__50243);
var seq__50243__$1 = cljs.core.next(seq__50243);
var var$__$1 = first__50244;
var r__$1 = seq__50243__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__50245 = cljs.core.set(all_vars__$2);
return (fexpr__50245.cljs$core$IFn$_invoke$arity$1 ? fexpr__50245.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__50245.call(null,var$__$1));
})())){
var G__50246 = r__$1;
var G__50247 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__50234__$1 = G__50246;
all_vars__$1 = G__50247;
continue;
} else {
var G__50248 = r__$1;
var G__50249 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__50234__$1 = G__50248;
all_vars__$1 = G__50249;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_50284){
var state_val_50285 = (state_50284[(1)]);
if((state_val_50285 === (1))){
var inst_50257 = functionArray;
var inst_50258 = cljs.core.seq(inst_50257);
var inst_50259 = cljs.core.first(inst_50258);
var inst_50260 = cljs.core.next(inst_50258);
var inst_50261 = cljs.core.PersistentVector.EMPTY;
var inst_50262 = inst_50257;
var inst_50263 = inst_50261;
var state_50284__$1 = (function (){var statearr_50286 = state_50284;
(statearr_50286[(7)] = inst_50259);

(statearr_50286[(8)] = inst_50262);

(statearr_50286[(9)] = inst_50263);

(statearr_50286[(10)] = inst_50260);

return statearr_50286;
})();
var statearr_50287_50300 = state_50284__$1;
(statearr_50287_50300[(2)] = null);

(statearr_50287_50300[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50285 === (2))){
var inst_50262 = (state_50284[(8)]);
var inst_50269 = (state_50284[(11)]);
var inst_50268 = cljs.core.seq(inst_50262);
var inst_50269__$1 = cljs.core.first(inst_50268);
var inst_50270 = cljs.core.next(inst_50268);
var state_50284__$1 = (function (){var statearr_50288 = state_50284;
(statearr_50288[(11)] = inst_50269__$1);

(statearr_50288[(12)] = inst_50270);

return statearr_50288;
})();
if(cljs.core.truth_(inst_50269__$1)){
var statearr_50289_50301 = state_50284__$1;
(statearr_50289_50301[(1)] = (4));

} else {
var statearr_50290_50302 = state_50284__$1;
(statearr_50290_50302[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50285 === (3))){
var inst_50282 = (state_50284[(2)]);
var state_50284__$1 = state_50284;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50284__$1,inst_50282);
} else {
if((state_val_50285 === (4))){
var inst_50269 = (state_50284[(11)]);
var inst_50272 = (inst_50269.cljs$core$IFn$_invoke$arity$1 ? inst_50269.cljs$core$IFn$_invoke$arity$1(tuple) : inst_50269.call(null,tuple));
var state_50284__$1 = state_50284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50284__$1,(7),inst_50272);
} else {
if((state_val_50285 === (5))){
var inst_50263 = (state_50284[(9)]);
var state_50284__$1 = state_50284;
var statearr_50291_50303 = state_50284__$1;
(statearr_50291_50303[(2)] = inst_50263);

(statearr_50291_50303[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50285 === (6))){
var inst_50280 = (state_50284[(2)]);
var state_50284__$1 = state_50284;
var statearr_50292_50304 = state_50284__$1;
(statearr_50292_50304[(2)] = inst_50280);

(statearr_50292_50304[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50285 === (7))){
var inst_50263 = (state_50284[(9)]);
var inst_50270 = (state_50284[(12)]);
var inst_50274 = (state_50284[(2)]);
var inst_50275 = fluree.db.util.async.throw_err(inst_50274);
var inst_50276 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_50263,inst_50275);
var inst_50262 = inst_50270;
var inst_50263__$1 = inst_50276;
var state_50284__$1 = (function (){var statearr_50293 = state_50284;
(statearr_50293[(8)] = inst_50262);

(statearr_50293[(9)] = inst_50263__$1);

return statearr_50293;
})();
var statearr_50294_50305 = state_50284__$1;
(statearr_50294_50305[(2)] = null);

(statearr_50294_50305[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__24298__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__24298__auto____0 = (function (){
var statearr_50295 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50295[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__24298__auto__);

(statearr_50295[(1)] = (1));

return statearr_50295;
});
var fluree$db$query$fql$format_tuple_$_state_machine__24298__auto____1 = (function (state_50284){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_50284);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e50296){var ex__24301__auto__ = e50296;
var statearr_50297_50306 = state_50284;
(statearr_50297_50306[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_50284[(4)]))){
var statearr_50298_50307 = state_50284;
(statearr_50298_50307[(1)] = cljs.core.first((state_50284[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__50308 = state_50284;
state_50284 = G__50308;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__24298__auto__ = function(state_50284){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__24298__auto____1.call(this,state_50284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__24298__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__24298__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_50299 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_50299[(6)] = c__24424__auto__);

return statearr_50299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__50309){
var vec__50310 = p__50309;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50310,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50310,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_50324){
var state_val_50325 = (state_50324[(1)]);
if((state_val_50325 === (1))){
var inst_50313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50314 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_50315 = [query_map,_id,query_opts];
var inst_50316 = cljs.core.PersistentHashMap.fromArrays(inst_50314,inst_50315);
var inst_50317 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_50316) : fluree.db.query.fql.query.call(null,db,inst_50316));
var state_50324__$1 = (function (){var statearr_50326 = state_50324;
(statearr_50326[(7)] = inst_50313);

return statearr_50326;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50324__$1,(2),inst_50317);
} else {
if((state_val_50325 === (2))){
var inst_50313 = (state_50324[(7)]);
var inst_50319 = (state_50324[(2)]);
var inst_50320 = fluree.db.util.async.throw_err(inst_50319);
var inst_50321 = [tuple_index,inst_50320];
var inst_50322 = (new cljs.core.PersistentVector(null,2,(5),inst_50313,inst_50321,null));
var state_50324__$1 = state_50324;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50324__$1,inst_50322);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__24298__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__24298__auto____0 = (function (){
var statearr_50327 = [null,null,null,null,null,null,null,null];
(statearr_50327[(0)] = fluree$db$query$fql$expand_map_$_state_machine__24298__auto__);

(statearr_50327[(1)] = (1));

return statearr_50327;
});
var fluree$db$query$fql$expand_map_$_state_machine__24298__auto____1 = (function (state_50324){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_50324);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e50328){var ex__24301__auto__ = e50328;
var statearr_50329_50332 = state_50324;
(statearr_50329_50332[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_50324[(4)]))){
var statearr_50330_50333 = state_50324;
(statearr_50330_50333[(1)] = cljs.core.first((state_50324[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__50334 = state_50324;
state_50324 = G__50334;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__24298__auto__ = function(state_50324){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__24298__auto____1.call(this,state_50324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__24298__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__24298__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_50331 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_50331[(6)] = c__24424__auto__);

return statearr_50331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__50335 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50335,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50335,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_50398){
var state_val_50399 = (state_50398[(1)]);
if((state_val_50399 === (7))){
var inst_50393 = (state_50398[(2)]);
var _ = (function (){var statearr_50400 = state_50398;
(statearr_50400[(4)] = cljs.core.rest((state_50398[(4)])));

return statearr_50400;
})();
var state_50398__$1 = state_50398;
var statearr_50401_50492 = state_50398__$1;
(statearr_50401_50492[(2)] = inst_50393);

(statearr_50401_50492[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (20))){
var inst_50384 = (state_50398[(2)]);
var state_50398__$1 = state_50398;
var statearr_50402_50493 = state_50398__$1;
(statearr_50402_50493[(2)] = inst_50384);

(statearr_50402_50493[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (1))){
var state_50398__$1 = state_50398;
var statearr_50403_50494 = state_50398__$1;
(statearr_50403_50494[(2)] = null);

(statearr_50403_50494[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (4))){
var inst_50340 = (state_50398[(2)]);
var state_50398__$1 = state_50398;
var statearr_50404_50495 = state_50398__$1;
(statearr_50404_50495[(2)] = inst_50340);

(statearr_50404_50495[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (15))){
var inst_50360 = (state_50398[(7)]);
var inst_50369 = cljs.core.second(inst_50360);
var inst_50370 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_50369);
var inst_50371 = (inst_50370 > max_fuel);
var state_50398__$1 = state_50398;
if(cljs.core.truth_(inst_50371)){
var statearr_50405_50496 = state_50398__$1;
(statearr_50405_50496[(1)] = (18));

} else {
var statearr_50406_50497 = state_50398__$1;
(statearr_50406_50497[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (13))){
var state_50398__$1 = state_50398;
var statearr_50407_50498 = state_50398__$1;
(statearr_50407_50498[(1)] = (15));



return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (6))){
var inst_50348 = (state_50398[(8)]);
var state_50398__$1 = state_50398;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50398__$1,(8),inst_50348);
} else {
if((state_val_50399 === (17))){
var inst_50387 = (state_50398[(2)]);
var state_50398__$1 = state_50398;
var statearr_50409_50499 = state_50398__$1;
(statearr_50409_50499[(2)] = inst_50387);

(statearr_50409_50499[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (3))){
var inst_50396 = (state_50398[(2)]);
var state_50398__$1 = state_50398;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50398__$1,inst_50396);
} else {
if((state_val_50399 === (12))){
var inst_50349 = (state_50398[(9)]);
var inst_50360 = (state_50398[(7)]);
var inst_50366 = (inst_50349.cljs$core$IFn$_invoke$arity$0 ? inst_50349.cljs$core$IFn$_invoke$arity$0() : inst_50349.call(null));
var state_50398__$1 = (function (){var statearr_50410 = state_50398;
(statearr_50410[(10)] = inst_50366);

return statearr_50410;
})();
var statearr_50411_50500 = state_50398__$1;
(statearr_50411_50500[(2)] = inst_50360);

(statearr_50411_50500[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (2))){
var inst_50349 = (state_50398[(9)]);
var inst_50348 = (state_50398[(8)]);
var _ = (function (){var statearr_50412 = state_50398;
(statearr_50412[(4)] = cljs.core.cons((5),(state_50398[(4)])));

return statearr_50412;
})();
var inst_50346 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_50347 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_50348__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_50349__$1 = (function (){var expandMaps = inst_50346;
var queue_ch = inst_50347;
var res_ch = inst_50348__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_50350 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_50351 = cljs.core.volatile_BANG_((0));
var inst_50352 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_50350,cljs.core.cst$kw$fuel,inst_50351);
var inst_50353 = (function (){var expandMaps = inst_50346;
var queue_ch = inst_50347;
var res_ch = inst_50348__$1;
var stop_BANG_ = inst_50349__$1;
var opts_STAR_ = inst_50352;
return (function (tuple_res,port){
var c__24424__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_50445){
var state_val_50446 = (state_50445[(1)]);
if((state_val_50446 === (7))){
var state_50445__$1 = state_50445;
var statearr_50447_50501 = state_50445__$1;
(statearr_50447_50501[(2)] = tuple_res);

(statearr_50447_50501[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50446 === (1))){
var state_50445__$1 = state_50445;
var statearr_50448_50502 = state_50445__$1;
(statearr_50448_50502[(2)] = null);

(statearr_50448_50502[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50446 === (4))){
var inst_50413 = (state_50445[(2)]);
var inst_50414 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_50413);
var inst_50415 = cljs.core.async.close_BANG_(port);
var state_50445__$1 = (function (){var statearr_50449 = state_50445;
(statearr_50449[(7)] = inst_50414);

return statearr_50449;
})();
var statearr_50450_50503 = state_50445__$1;
(statearr_50450_50503[(2)] = inst_50415);

(statearr_50450_50503[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50446 === (6))){
var inst_50422 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50423 = [tuple_res];
var inst_50424 = (new cljs.core.PersistentVector(null,1,(5),inst_50422,inst_50423,null));
var state_50445__$1 = state_50445;
var statearr_50451_50504 = state_50445__$1;
(statearr_50451_50504[(2)] = inst_50424);

(statearr_50451_50504[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50446 === (3))){
var inst_50443 = (state_50445[(2)]);
var state_50445__$1 = state_50445;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50445__$1,inst_50443);
} else {
if((state_val_50446 === (2))){
var ___$1 = (function (){var statearr_50453 = state_50445;
(statearr_50453[(4)] = cljs.core.cons((5),(state_50445[(4)])));

return statearr_50453;
})();
var state_50445__$1 = state_50445;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_50454_50505 = state_50445__$1;
(statearr_50454_50505[(1)] = (6));

} else {
var statearr_50455_50506 = state_50445__$1;
(statearr_50455_50506[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50446 === (9))){
var inst_50429 = (state_50445[(8)]);
var inst_50427 = (state_50445[(9)]);
var inst_50436 = (state_50445[(2)]);
var inst_50437 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_50427,inst_50436);
var inst_50438 = (inst_50429.cljs$core$IFn$_invoke$arity$1 ? inst_50429.cljs$core$IFn$_invoke$arity$1(inst_50437) : inst_50429.call(null,inst_50437));
var inst_50439 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_50438);
var inst_50440 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_50456 = state_50445;
(statearr_50456[(4)] = cljs.core.rest((state_50445[(4)])));

return statearr_50456;
})();
var state_50445__$1 = (function (){var statearr_50457 = state_50445;
(statearr_50457[(10)] = inst_50439);

return statearr_50457;
})();
var statearr_50458_50507 = state_50445__$1;
(statearr_50458_50507[(2)] = inst_50440);

(statearr_50458_50507[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50446 === (5))){
var ___$1 = (function (){var statearr_50459 = state_50445;
(statearr_50459[(4)] = cljs.core.rest((state_50445[(4)])));

return statearr_50459;
})();
var state_50445__$1 = state_50445;
var ex50452 = (state_50445__$1[(2)]);
var statearr_50460_50508 = state_50445__$1;
(statearr_50460_50508[(5)] = ex50452);


var statearr_50461_50509 = state_50445__$1;
(statearr_50461_50509[(1)] = (4));

(statearr_50461_50509[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_50446 === (8))){
var inst_50427 = (state_50445[(9)]);
var inst_50427__$1 = (state_50445[(2)]);
var inst_50428 = cljs.core.volatile_BANG_((0));
var inst_50429 = (function (){var tuple_res_SINGLEQUOTE_ = inst_50427__$1;
var query_fuel = inst_50428;
return (function (p1__50339_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__50339_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__50339_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_50430 = cljs.core.PersistentVector.EMPTY;
var inst_50431 = (function (){var tuple_res_SINGLEQUOTE_ = inst_50427__$1;
var query_fuel = inst_50428;
return (function (p1__50338_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,cljs.core.cst$kw$fuel,fuel),tuple_res_SINGLEQUOTE_,p1__50338_SHARP_);
});
})();
var inst_50432 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_50431,expandMaps);
var inst_50433 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_50432);
var inst_50434 = cljs.core.async.into(inst_50430,inst_50433);
var state_50445__$1 = (function (){var statearr_50462 = state_50445;
(statearr_50462[(8)] = inst_50429);

(statearr_50462[(9)] = inst_50427__$1);

return statearr_50462;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50445__$1,(9),inst_50434);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto____0 = (function (){
var statearr_50463 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_50463[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto__);

(statearr_50463[(1)] = (1));

return statearr_50463;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto____1 = (function (state_50445){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_50445);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e50464){var ex__24301__auto__ = e50464;
var statearr_50465_50510 = state_50445;
(statearr_50465_50510[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_50445[(4)]))){
var statearr_50466_50511 = state_50445;
(statearr_50466_50511[(1)] = cljs.core.first((state_50445[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__50512 = state_50445;
state_50445 = G__50512;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto__ = function(state_50445){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto____1.call(this,state_50445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_50467 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_50467[(6)] = c__24424__auto____$1);

return statearr_50467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto____$1;
});
})();
var inst_50354 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_50347,tuples_res);
var inst_50355 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_50348__$1,inst_50353,inst_50347);
var inst_50356 = cljs.core.PersistentVector.EMPTY;
var inst_50357 = inst_50356;
var state_50398__$1 = (function (){var statearr_50468 = state_50398;
(statearr_50468[(9)] = inst_50349__$1);

(statearr_50468[(11)] = inst_50357);

(statearr_50468[(12)] = inst_50355);

(statearr_50468[(13)] = inst_50354);

(statearr_50468[(8)] = inst_50348__$1);

return statearr_50468;
})();
var statearr_50469_50513 = state_50398__$1;
(statearr_50469_50513[(2)] = null);

(statearr_50469_50513[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (19))){
var inst_50357 = (state_50398[(11)]);
var inst_50360 = (state_50398[(7)]);
var inst_50380 = cljs.core.first(inst_50360);
var inst_50381 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_50357,inst_50380);
var inst_50357__$1 = inst_50381;
var state_50398__$1 = (function (){var statearr_50470 = state_50398;
(statearr_50470[(11)] = inst_50357__$1);

return statearr_50470;
})();
var statearr_50471_50514 = state_50398__$1;
(statearr_50471_50514[(2)] = null);

(statearr_50471_50514[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (11))){
var inst_50391 = (state_50398[(2)]);
var state_50398__$1 = state_50398;
var statearr_50473_50515 = state_50398__$1;
(statearr_50473_50515[(2)] = inst_50391);

(statearr_50473_50515[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (9))){
var inst_50357 = (state_50398[(11)]);
var state_50398__$1 = state_50398;
var statearr_50474_50516 = state_50398__$1;
(statearr_50474_50516[(2)] = inst_50357);

(statearr_50474_50516[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (5))){
var _ = (function (){var statearr_50475 = state_50398;
(statearr_50475[(4)] = cljs.core.rest((state_50398[(4)])));

return statearr_50475;
})();
var state_50398__$1 = state_50398;
var ex50472 = (state_50398__$1[(2)]);
var statearr_50476_50517 = state_50398__$1;
(statearr_50476_50517[(5)] = ex50472);


if((ex50472 instanceof Error)){
var statearr_50477_50518 = state_50398__$1;
(statearr_50477_50518[(1)] = (4));

(statearr_50477_50518[(5)] = null);

} else {
throw ex50472;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (14))){
var inst_50389 = (state_50398[(2)]);
var state_50398__$1 = state_50398;
var statearr_50478_50519 = state_50398__$1;
(statearr_50478_50519[(2)] = inst_50389);

(statearr_50478_50519[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (16))){
var state_50398__$1 = state_50398;
var statearr_50479_50520 = state_50398__$1;
(statearr_50479_50520[(2)] = null);

(statearr_50479_50520[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (10))){
var inst_50360 = (state_50398[(7)]);
var inst_50364 = fluree.db.util.core.exception_QMARK_(inst_50360);
var state_50398__$1 = state_50398;
if(inst_50364){
var statearr_50480_50521 = state_50398__$1;
(statearr_50480_50521[(1)] = (12));

} else {
var statearr_50481_50522 = state_50398__$1;
(statearr_50481_50522[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (18))){
var inst_50349 = (state_50398[(9)]);
var inst_50373 = (inst_50349.cljs$core$IFn$_invoke$arity$0 ? inst_50349.cljs$core$IFn$_invoke$arity$0() : inst_50349.call(null));
var inst_50374 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_50375 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_50376 = [cljs.core.cst$kw$db_SLASH_insufficient_DASH_fuel,(400)];
var inst_50377 = cljs.core.PersistentHashMap.fromArrays(inst_50375,inst_50376);
var inst_50378 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_50374,inst_50377);
var state_50398__$1 = (function (){var statearr_50482 = state_50398;
(statearr_50482[(14)] = inst_50373);

return statearr_50482;
})();
var statearr_50483_50523 = state_50398__$1;
(statearr_50483_50523[(2)] = inst_50378);

(statearr_50483_50523[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50399 === (8))){
var inst_50360 = (state_50398[(7)]);
var inst_50360__$1 = (state_50398[(2)]);
var inst_50361 = (inst_50360__$1 == null);
var state_50398__$1 = (function (){var statearr_50484 = state_50398;
(statearr_50484[(7)] = inst_50360__$1);

return statearr_50484;
})();
if(cljs.core.truth_(inst_50361)){
var statearr_50485_50524 = state_50398__$1;
(statearr_50485_50524[(1)] = (9));

} else {
var statearr_50486_50525 = state_50398__$1;
(statearr_50486_50525[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto____0 = (function (){
var statearr_50487 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50487[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto__);

(statearr_50487[(1)] = (1));

return statearr_50487;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto____1 = (function (state_50398){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_50398);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e50488){var ex__24301__auto__ = e50488;
var statearr_50489_50526 = state_50398;
(statearr_50489_50526[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_50398[(4)]))){
var statearr_50490_50527 = state_50398;
(statearr_50490_50527[(1)] = cljs.core.first((state_50398[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__50528 = state_50398;
state_50398 = G__50528;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto__ = function(state_50398){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto____1.call(this,state_50398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_50491 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_50491[(6)] = c__24424__auto__);

return statearr_50491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__50529 = select;
var map__50529__$1 = cljs.core.__destructure_map(map__50529);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50529__$1,cljs.core.cst$kw$as);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50529__$1,cljs.core.cst$kw$variable);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50529__$1,cljs.core.cst$kw$value);
var select_val = (function (){var or__4212__auto__ = as;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__50532 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50532,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50532,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50532,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__50530_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__50530_SHARP_,compare_idx));
}):(function (p1__50531_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__50531_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__50537 = arguments.length;
switch (G__50537) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__50538,p__50539,group_limit,opts){
var map__50540 = p__50538;
var map__50540__$1 = cljs.core.__destructure_map(map__50540);
var res = map__50540__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50540__$1,cljs.core.cst$kw$vars);
var map__50541 = p__50539;
var map__50541__$1 = cljs.core.__destructure_map(map__50541);
var select_spec = map__50541__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50541__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50541__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50541__$1,cljs.core.cst$kw$orderBy);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50541__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50541__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50541__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50541__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50541__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50541__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50541__$1,cljs.core.cst$kw$groupBy);
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_50678){
var state_val_50679 = (state_50678[(1)]);
if((state_val_50679 === (7))){
var inst_50548 = (state_50678[(7)]);
var state_50678__$1 = state_50678;
var statearr_50680_50782 = state_50678__$1;
(statearr_50680_50782[(2)] = inst_50548);

(statearr_50680_50782[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (59))){
var inst_50671 = (state_50678[(2)]);
var state_50678__$1 = state_50678;
var statearr_50681_50783 = state_50678__$1;
(statearr_50681_50783[(2)] = inst_50671);

(statearr_50681_50783[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (20))){
var inst_50584 = (state_50678[(8)]);
var inst_50587 = (state_50678[(9)]);
var inst_50583 = (state_50678[(2)]);
var inst_50584__$1 = cljs.core.__destructure_map(inst_50583);
var inst_50585 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50584__$1,cljs.core.cst$kw$headers);
var inst_50586 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50584__$1,cljs.core.cst$kw$tuples);
var inst_50587__$1 = offset;
var state_50678__$1 = (function (){var statearr_50682 = state_50678;
(statearr_50682[(8)] = inst_50584__$1);

(statearr_50682[(9)] = inst_50587__$1);

(statearr_50682[(10)] = inst_50585);

(statearr_50682[(11)] = inst_50586);

return statearr_50682;
})();
if(cljs.core.truth_(inst_50587__$1)){
var statearr_50683_50784 = state_50678__$1;
(statearr_50683_50784[(1)] = (21));

} else {
var statearr_50684_50785 = state_50678__$1;
(statearr_50684_50785[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (58))){
var inst_50663 = (state_50678[(12)]);
var state_50678__$1 = state_50678;
var statearr_50685_50786 = state_50678__$1;
(statearr_50685_50786[(2)] = inst_50663);

(statearr_50685_50786[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (60))){
var inst_50667 = (state_50678[(2)]);
var inst_50668 = fluree.db.util.async.throw_err(inst_50667);
var state_50678__$1 = state_50678;
var statearr_50686_50787 = state_50678__$1;
(statearr_50686_50787[(2)] = inst_50668);

(statearr_50686_50787[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (27))){
var inst_50599 = cljs.core.not(inVector_QMARK_);
var state_50678__$1 = state_50678;
var statearr_50687_50788 = state_50678__$1;
(statearr_50687_50788[(2)] = inst_50599);

(statearr_50687_50788[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (1))){
var state_50678__$1 = state_50678;
var statearr_50688_50789 = state_50678__$1;
(statearr_50688_50789[(2)] = null);

(statearr_50688_50789[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (24))){
var state_50678__$1 = state_50678;
var statearr_50689_50790 = state_50678__$1;
(statearr_50689_50790[(2)] = offset);

(statearr_50689_50790[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (55))){
var inst_50657 = (state_50678[(13)]);
var state_50678__$1 = state_50678;
var statearr_50690_50791 = state_50678__$1;
(statearr_50690_50791[(2)] = inst_50657);

(statearr_50690_50791[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (39))){
var inst_50625 = (state_50678[(14)]);
var inst_50627 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_50628 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_50625,inst_50627);
var state_50678__$1 = state_50678;
var statearr_50691_50792 = state_50678__$1;
(statearr_50691_50792[(2)] = inst_50628);

(statearr_50691_50792[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (46))){
var inst_50637 = (state_50678[(15)]);
var state_50678__$1 = state_50678;
var statearr_50692_50793 = state_50678__$1;
(statearr_50692_50793[(2)] = inst_50637);

(statearr_50692_50793[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (4))){
var inst_50542 = (state_50678[(2)]);
var state_50678__$1 = state_50678;
var statearr_50693_50794 = state_50678__$1;
(statearr_50693_50794[(2)] = inst_50542);

(statearr_50693_50794[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (54))){
var inst_50651 = (state_50678[(16)]);
var inst_50657 = (state_50678[(13)]);
var inst_50659 = cljs.core.PersistentVector.EMPTY;
var inst_50660 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_50659,inst_50651,inst_50657);
var state_50678__$1 = state_50678;
var statearr_50694_50795 = state_50678__$1;
(statearr_50694_50795[(2)] = inst_50660);

(statearr_50694_50795[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (15))){
var inst_50569 = (state_50678[(17)]);
var inst_50571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50572 = [inst_50569];
var inst_50573 = (new cljs.core.PersistentVector(null,1,(5),inst_50571,inst_50572,null));
var state_50678__$1 = state_50678;
var statearr_50695_50796 = state_50678__$1;
(statearr_50695_50796[(2)] = inst_50573);

(statearr_50695_50796[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (48))){
var inst_50607 = (state_50678[(18)]);
var inst_50602 = (state_50678[(19)]);
var inst_50584 = (state_50678[(8)]);
var inst_50643 = (state_50678[(20)]);
var inst_50585 = (state_50678[(10)]);
var inst_50586 = (state_50678[(11)]);
var inst_50596 = (state_50678[(21)]);
var inst_50645 = (function (){var map__50578 = inst_50584;
var headers = inst_50585;
var tuples = inst_50586;
var offset_SINGLEQUOTE_ = inst_50596;
var single_result_QMARK_ = inst_50602;
var pp_keys = inst_50607;
var G__50608 = inst_50643;
return (function (p1__50535_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__50535_SHARP_);
});
})();
var inst_50646 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_50645);
var inst_50647 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_50643,inst_50646);
var state_50678__$1 = state_50678;
var statearr_50696_50797 = state_50678__$1;
(statearr_50696_50797[(2)] = inst_50647);

(statearr_50696_50797[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (50))){
var inst_50650 = (state_50678[(2)]);
var inst_50651 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_50650);
var state_50678__$1 = (function (){var statearr_50697 = state_50678;
(statearr_50697[(16)] = inst_50651);

return statearr_50697;
})();
if(cljs.core.truth_(orderBy)){
var statearr_50698_50798 = state_50678__$1;
(statearr_50698_50798[(1)] = (51));

} else {
var statearr_50699_50799 = state_50678__$1;
(statearr_50699_50799[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (21))){
var inst_50589 = cljs.core.not(groupBy);
var state_50678__$1 = state_50678;
var statearr_50700_50800 = state_50678__$1;
(statearr_50700_50800[(2)] = inst_50589);

(statearr_50700_50800[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (31))){
var state_50678__$1 = state_50678;
var statearr_50701_50801 = state_50678__$1;
(statearr_50701_50801[(2)] = null);

(statearr_50701_50801[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (32))){
var inst_50602 = (state_50678[(19)]);
var inst_50585 = (state_50678[(10)]);
var inst_50607 = (state_50678[(2)]);
var inst_50609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50610 = fluree.db.query.fql.select_tuples_fn(inst_50585,vars,select);
var inst_50611 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_50610);
var inst_50612 = [inst_50611];
var inst_50613 = (new cljs.core.PersistentVector(null,1,(5),inst_50609,inst_50612,null));
var state_50678__$1 = (function (){var statearr_50702 = state_50678;
(statearr_50702[(18)] = inst_50607);

(statearr_50702[(22)] = inst_50613);

return statearr_50702;
})();
if(cljs.core.truth_(inst_50602)){
var statearr_50703_50802 = state_50678__$1;
(statearr_50703_50802[(1)] = (33));

} else {
var statearr_50704_50803 = state_50678__$1;
(statearr_50704_50803[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (40))){
var inst_50625 = (state_50678[(14)]);
var state_50678__$1 = state_50678;
var statearr_50705_50804 = state_50678__$1;
(statearr_50705_50804[(2)] = inst_50625);

(statearr_50705_50804[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (56))){
var inst_50663 = (state_50678[(2)]);
var state_50678__$1 = (function (){var statearr_50706 = state_50678;
(statearr_50706[(12)] = inst_50663);

return statearr_50706;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_50707_50805 = state_50678__$1;
(statearr_50707_50805[(1)] = (57));

} else {
var statearr_50708_50806 = state_50678__$1;
(statearr_50708_50806[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (33))){
var inst_50613 = (state_50678[(22)]);
var inst_50615 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_50616 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_50613,inst_50615);
var state_50678__$1 = state_50678;
var statearr_50709_50807 = state_50678__$1;
(statearr_50709_50807[(2)] = inst_50616);

(statearr_50709_50807[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (13))){
var inst_50558 = (state_50678[(23)]);
var state_50678__$1 = state_50678;
var statearr_50710_50808 = state_50678__$1;
(statearr_50710_50808[(2)] = inst_50558);

(statearr_50710_50808[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (22))){
var inst_50587 = (state_50678[(9)]);
var state_50678__$1 = state_50678;
var statearr_50711_50809 = state_50678__$1;
(statearr_50711_50809[(2)] = inst_50587);

(statearr_50711_50809[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (36))){
var inst_50619 = (state_50678[(24)]);
var inst_50621 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_50622 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_50619,inst_50621);
var state_50678__$1 = state_50678;
var statearr_50712_50810 = state_50678__$1;
(statearr_50712_50810[(2)] = inst_50622);

(statearr_50712_50810[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (41))){
var inst_50596 = (state_50678[(21)]);
var inst_50631 = (state_50678[(2)]);
var state_50678__$1 = (function (){var statearr_50713 = state_50678;
(statearr_50713[(25)] = inst_50631);

return statearr_50713;
})();
if(cljs.core.truth_(inst_50596)){
var statearr_50714_50811 = state_50678__$1;
(statearr_50714_50811[(1)] = (42));

} else {
var statearr_50715_50812 = state_50678__$1;
(statearr_50715_50812[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (43))){
var inst_50631 = (state_50678[(25)]);
var state_50678__$1 = state_50678;
var statearr_50716_50813 = state_50678__$1;
(statearr_50716_50813[(2)] = inst_50631);

(statearr_50716_50813[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (29))){
var inst_50602 = (state_50678[(2)]);
var state_50678__$1 = (function (){var statearr_50717 = state_50678;
(statearr_50717[(19)] = inst_50602);

return statearr_50717;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_50718_50814 = state_50678__$1;
(statearr_50718_50814[(1)] = (30));

} else {
var statearr_50719_50815 = state_50678__$1;
(statearr_50719_50815[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (44))){
var inst_50637 = (state_50678[(2)]);
var state_50678__$1 = (function (){var statearr_50720 = state_50678;
(statearr_50720[(15)] = inst_50637);

return statearr_50720;
})();
if(cljs.core.truth_(group_limit)){
var statearr_50721_50816 = state_50678__$1;
(statearr_50721_50816[(1)] = (45));

} else {
var statearr_50722_50817 = state_50678__$1;
(statearr_50722_50817[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (6))){
var inst_50550 = cljs.core.count(select);
var inst_50551 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_50550);
var state_50678__$1 = state_50678;
var statearr_50723_50818 = state_50678__$1;
(statearr_50723_50818[(2)] = inst_50551);

(statearr_50723_50818[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (28))){
var inst_50597 = (state_50678[(26)]);
var state_50678__$1 = state_50678;
var statearr_50724_50819 = state_50678__$1;
(statearr_50724_50819[(2)] = inst_50597);

(statearr_50724_50819[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (51))){
var inst_50585 = (state_50678[(10)]);
var inst_50586 = (state_50678[(11)]);
var inst_50654 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_50585,orderBy,inst_50586);
var state_50678__$1 = state_50678;
var statearr_50725_50820 = state_50678__$1;
(statearr_50725_50820[(2)] = inst_50654);

(statearr_50725_50820[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (25))){
var state_50678__$1 = state_50678;
var statearr_50726_50821 = state_50678__$1;
(statearr_50726_50821[(2)] = null);

(statearr_50726_50821[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (34))){
var inst_50613 = (state_50678[(22)]);
var state_50678__$1 = state_50678;
var statearr_50727_50822 = state_50678__$1;
(statearr_50727_50822[(2)] = inst_50613);

(statearr_50727_50822[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (17))){
var inst_50576 = (state_50678[(2)]);
var state_50678__$1 = state_50678;
var statearr_50728_50823 = state_50678__$1;
(statearr_50728_50823[(2)] = inst_50576);

(statearr_50728_50823[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (3))){
var inst_50676 = (state_50678[(2)]);
var state_50678__$1 = state_50678;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50678__$1,inst_50676);
} else {
if((state_val_50679 === (12))){
var inst_50558 = (state_50678[(23)]);
var inst_50560 = cljs.core.first(select);
var inst_50561 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_50560);
var inst_50562 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50561);
var inst_50563 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_50562,(1));
var inst_50564 = [inst_50563];
var inst_50565 = [inst_50558];
var inst_50566 = cljs.core.PersistentHashMap.fromArrays(inst_50564,inst_50565);
var state_50678__$1 = state_50678;
var statearr_50729_50824 = state_50678__$1;
(statearr_50729_50824[(2)] = inst_50566);

(statearr_50729_50824[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (2))){
var inst_50548 = (state_50678[(7)]);
var _ = (function (){var statearr_50730 = state_50678;
(statearr_50730[(4)] = cljs.core.cons((5),(state_50678[(4)])));

return statearr_50730;
})();
var inst_50548__$1 = aggregates;
var state_50678__$1 = (function (){var statearr_50731 = state_50678;
(statearr_50731[(7)] = inst_50548__$1);

return statearr_50731;
})();
if(cljs.core.truth_(inst_50548__$1)){
var statearr_50732_50825 = state_50678__$1;
(statearr_50732_50825[(1)] = (6));

} else {
var statearr_50733_50826 = state_50678__$1;
(statearr_50733_50826[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (23))){
var inst_50592 = (state_50678[(2)]);
var state_50678__$1 = state_50678;
if(cljs.core.truth_(inst_50592)){
var statearr_50734_50827 = state_50678__$1;
(statearr_50734_50827[(1)] = (24));

} else {
var statearr_50735_50828 = state_50678__$1;
(statearr_50735_50828[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (47))){
var inst_50643 = (state_50678[(2)]);
var state_50678__$1 = (function (){var statearr_50736 = state_50678;
(statearr_50736[(20)] = inst_50643);

return statearr_50736;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_50737_50829 = state_50678__$1;
(statearr_50737_50829[(1)] = (48));

} else {
var statearr_50738_50830 = state_50678__$1;
(statearr_50738_50830[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (35))){
var inst_50619 = (state_50678[(2)]);
var state_50678__$1 = (function (){var statearr_50739 = state_50678;
(statearr_50739[(24)] = inst_50619);

return statearr_50739;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_50740_50831 = state_50678__$1;
(statearr_50740_50831[(1)] = (36));

} else {
var statearr_50741_50832 = state_50678__$1;
(statearr_50741_50832[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (19))){
var state_50678__$1 = state_50678;
var statearr_50742_50833 = state_50678__$1;
(statearr_50742_50833[(2)] = res);

(statearr_50742_50833[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (57))){
var inst_50607 = (state_50678[(18)]);
var inst_50602 = (state_50678[(19)]);
var inst_50663 = (state_50678[(12)]);
var inst_50665 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_50607,inst_50602,db,fuel,max_fuel,opts,(8),inst_50663);
var state_50678__$1 = state_50678;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50678__$1,(60),inst_50665);
} else {
if((state_val_50679 === (11))){
var inst_50673 = (state_50678[(2)]);
var _ = (function (){var statearr_50744 = state_50678;
(statearr_50744[(4)] = cljs.core.rest((state_50678[(4)])));

return statearr_50744;
})();
var state_50678__$1 = state_50678;
var statearr_50745_50834 = state_50678__$1;
(statearr_50745_50834[(2)] = inst_50673);

(statearr_50745_50834[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (9))){
var inst_50556 = cljs.core.first(aggregates);
var inst_50557 = fluree.db.query.analytical.calculate_aggregate(res,inst_50556);
var inst_50558 = cljs.core.second(inst_50557);
var state_50678__$1 = (function (){var statearr_50746 = state_50678;
(statearr_50746[(23)] = inst_50558);

return statearr_50746;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_50747_50835 = state_50678__$1;
(statearr_50747_50835[(1)] = (12));

} else {
var statearr_50748_50836 = state_50678__$1;
(statearr_50748_50836[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (5))){
var _ = (function (){var statearr_50749 = state_50678;
(statearr_50749[(4)] = cljs.core.rest((state_50678[(4)])));

return statearr_50749;
})();
var state_50678__$1 = state_50678;
var ex50743 = (state_50678__$1[(2)]);
var statearr_50750_50837 = state_50678__$1;
(statearr_50750_50837[(5)] = ex50743);


if((ex50743 instanceof Error)){
var statearr_50751_50838 = state_50678__$1;
(statearr_50751_50838[(1)] = (4));

(statearr_50751_50838[(5)] = null);

} else {
throw ex50743;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (14))){
var inst_50569 = (state_50678[(2)]);
var state_50678__$1 = (function (){var statearr_50752 = state_50678;
(statearr_50752[(17)] = inst_50569);

return statearr_50752;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_50753_50839 = state_50678__$1;
(statearr_50753_50839[(1)] = (15));

} else {
var statearr_50754_50840 = state_50678__$1;
(statearr_50754_50840[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (45))){
var inst_50637 = (state_50678[(15)]);
var inst_50639 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_50640 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_50637,inst_50639);
var state_50678__$1 = state_50678;
var statearr_50755_50841 = state_50678__$1;
(statearr_50755_50841[(2)] = inst_50640);

(statearr_50755_50841[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (53))){
var inst_50657 = (state_50678[(2)]);
var state_50678__$1 = (function (){var statearr_50756 = state_50678;
(statearr_50756[(13)] = inst_50657);

return statearr_50756;
})();
var statearr_50757_50842 = state_50678__$1;
(statearr_50757_50842[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (26))){
var inst_50597 = (state_50678[(26)]);
var inst_50596 = (state_50678[(2)]);
var inst_50597__$1 = cljs.core.not(prettyPrint);
var state_50678__$1 = (function (){var statearr_50759 = state_50678;
(statearr_50759[(26)] = inst_50597__$1);

(statearr_50759[(21)] = inst_50596);

return statearr_50759;
})();
if(inst_50597__$1){
var statearr_50760_50843 = state_50678__$1;
(statearr_50760_50843[(1)] = (27));

} else {
var statearr_50761_50844 = state_50678__$1;
(statearr_50761_50844[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (16))){
var inst_50569 = (state_50678[(17)]);
var state_50678__$1 = state_50678;
var statearr_50762_50845 = state_50678__$1;
(statearr_50762_50845[(2)] = inst_50569);

(statearr_50762_50845[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (38))){
var inst_50625 = (state_50678[(2)]);
var state_50678__$1 = (function (){var statearr_50763 = state_50678;
(statearr_50763[(14)] = inst_50625);

return statearr_50763;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_50764_50846 = state_50678__$1;
(statearr_50764_50846[(1)] = (39));

} else {
var statearr_50765_50847 = state_50678__$1;
(statearr_50765_50847[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (30))){
var inst_50604 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_50678__$1 = state_50678;
var statearr_50766_50848 = state_50678__$1;
(statearr_50766_50848[(2)] = inst_50604);

(statearr_50766_50848[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (10))){
var state_50678__$1 = state_50678;
if(cljs.core.truth_(aggregates)){
var statearr_50767_50849 = state_50678__$1;
(statearr_50767_50849[(1)] = (18));

} else {
var statearr_50768_50850 = state_50678__$1;
(statearr_50768_50850[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (18))){
var inst_50580 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_50678__$1 = state_50678;
var statearr_50769_50851 = state_50678__$1;
(statearr_50769_50851[(2)] = inst_50580);

(statearr_50769_50851[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (52))){
var inst_50586 = (state_50678[(11)]);
var state_50678__$1 = state_50678;
var statearr_50770_50852 = state_50678__$1;
(statearr_50770_50852[(2)] = inst_50586);

(statearr_50770_50852[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (42))){
var inst_50631 = (state_50678[(25)]);
var inst_50596 = (state_50678[(21)]);
var inst_50633 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_50596);
var inst_50634 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_50631,inst_50633);
var state_50678__$1 = state_50678;
var statearr_50771_50853 = state_50678__$1;
(statearr_50771_50853[(2)] = inst_50634);

(statearr_50771_50853[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (37))){
var inst_50619 = (state_50678[(24)]);
var state_50678__$1 = state_50678;
var statearr_50772_50854 = state_50678__$1;
(statearr_50772_50854[(2)] = inst_50619);

(statearr_50772_50854[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (8))){
var inst_50554 = (state_50678[(2)]);
var state_50678__$1 = state_50678;
if(cljs.core.truth_(inst_50554)){
var statearr_50773_50855 = state_50678__$1;
(statearr_50773_50855[(1)] = (9));

} else {
var statearr_50774_50856 = state_50678__$1;
(statearr_50774_50856[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50679 === (49))){
var inst_50643 = (state_50678[(20)]);
var state_50678__$1 = state_50678;
var statearr_50775_50857 = state_50678__$1;
(statearr_50775_50857[(2)] = inst_50643);

(statearr_50775_50857[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__24298__auto__ = null;
var fluree$db$query$fql$state_machine__24298__auto____0 = (function (){
var statearr_50776 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50776[(0)] = fluree$db$query$fql$state_machine__24298__auto__);

(statearr_50776[(1)] = (1));

return statearr_50776;
});
var fluree$db$query$fql$state_machine__24298__auto____1 = (function (state_50678){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_50678);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e50777){var ex__24301__auto__ = e50777;
var statearr_50778_50858 = state_50678;
(statearr_50778_50858[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_50678[(4)]))){
var statearr_50779_50859 = state_50678;
(statearr_50779_50859[(1)] = cljs.core.first((state_50678[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__50860 = state_50678;
state_50678 = G__50860;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__24298__auto__ = function(state_50678){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__24298__auto____1.call(this,state_50678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__24298__auto____0;
fluree$db$query$fql$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__24298__auto____1;
return fluree$db$query$fql$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_50780 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_50780[(6)] = c__24424__auto__);

return statearr_50780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__50863,groupBy){
var map__50864 = p__50863;
var map__50864__$1 = cljs.core.__destructure_map(map__50864);
var res = map__50864__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50864__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50864__$1,cljs.core.cst$kw$tuples);
var vec__50865 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50865,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50865,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__50861_SHARP_){
return fluree.db.util.core.index_of(headers,p1__50861_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__50862_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__50862_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__50868 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50868,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50868,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__50871,p__50872,opts){
var map__50873 = p__50871;
var map__50873__$1 = cljs.core.__destructure_map(map__50873);
var res = map__50873__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50873__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50873__$1,cljs.core.cst$kw$vars);
var map__50874 = p__50872;
var map__50874__$1 = cljs.core.__destructure_map(map__50874);
var select_spec = map__50874__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50874__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50874__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50874__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50874__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50874__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50874__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50874__$1,cljs.core.cst$kw$offset);
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_51116){
var state_val_51117 = (state_51116[(1)]);
if((state_val_51117 === (65))){
var state_51116__$1 = state_51116;
var statearr_51118_51269 = state_51116__$1;
(statearr_51118_51269[(1)] = (67));



return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (70))){
var inst_51037 = (state_51116[(7)]);
var state_51116__$1 = state_51116;
var statearr_51120_51270 = state_51116__$1;
(statearr_51120_51270[(2)] = inst_51037);

(statearr_51120_51270[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (62))){
var state_51116__$1 = state_51116;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_51121_51271 = state_51116__$1;
(statearr_51121_51271[(1)] = (64));

} else {
var statearr_51122_51272 = state_51116__$1;
(statearr_51122_51272[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (74))){
var inst_50953 = (state_51116[(8)]);
var inst_50944 = (state_51116[(9)]);
var inst_51012 = (state_51116[(10)]);
var inst_51045 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_50944,inst_50953,inst_51012);
var state_51116__$1 = state_51116;
var statearr_51123_51273 = state_51116__$1;
(statearr_51123_51273[(2)] = inst_51045);

(statearr_51123_51273[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (7))){
var state_51116__$1 = state_51116;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_51124_51274 = state_51116__$1;
(statearr_51124_51274[(1)] = (82));

} else {
var statearr_51125_51275 = state_51116__$1;
(statearr_51125_51275[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (59))){
var inst_50942 = (state_51116[(11)]);
var inst_51012 = (state_51116[(10)]);
var inst_51016 = cljs.core.count(inst_51012);
var inst_51017 = (inst_50942 - inst_51016);
var state_51116__$1 = state_51116;
var statearr_51126_51276 = state_51116__$1;
(statearr_51126_51276[(2)] = inst_51017);

(statearr_51126_51276[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (86))){
var state_51116__$1 = state_51116;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_51127_51277 = state_51116__$1;
(statearr_51127_51277[(1)] = (89));

} else {
var statearr_51128_51278 = state_51116__$1;
(statearr_51128_51278[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (20))){
var state_51116__$1 = state_51116;
var statearr_51129_51279 = state_51116__$1;
(statearr_51129_51279[(2)] = (0));

(statearr_51129_51279[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (72))){
var inst_51042 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
if(cljs.core.truth_(inst_51042)){
var statearr_51130_51280 = state_51116__$1;
(statearr_51130_51280[(1)] = (73));

} else {
var statearr_51131_51281 = state_51116__$1;
(statearr_51131_51281[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (58))){
var state_51116__$1 = state_51116;
var statearr_51132_51282 = state_51116__$1;
(statearr_51132_51282[(2)] = null);

(statearr_51132_51282[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (60))){
var inst_50943 = (state_51116[(12)]);
var inst_51019 = (state_51116[(2)]);
var inst_51020 = (inst_50943 <= (0));
var state_51116__$1 = (function (){var statearr_51133 = state_51116;
(statearr_51133[(13)] = inst_51019);

return statearr_51133;
})();
if(cljs.core.truth_(inst_51020)){
var statearr_51134_51283 = state_51116__$1;
(statearr_51134_51283[(1)] = (61));

} else {
var statearr_51135_51284 = state_51116__$1;
(statearr_51135_51284[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (27))){
var inst_50942 = (state_51116[(11)]);
var inst_50966 = (inst_50942 < (1));
var state_51116__$1 = state_51116;
var statearr_51136_51285 = state_51116__$1;
(statearr_51136_51285[(2)] = inst_50966);

(statearr_51136_51285[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (1))){
var state_51116__$1 = state_51116;
var statearr_51137_51286 = state_51116__$1;
(statearr_51137_51286[(2)] = null);

(statearr_51137_51286[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (69))){
var inst_51032 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51138_51287 = state_51116__$1;
(statearr_51138_51287[(2)] = inst_51032);

(statearr_51138_51287[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (24))){
var inst_50944 = (state_51116[(9)]);
var state_51116__$1 = state_51116;
var statearr_51139_51288 = state_51116__$1;
(statearr_51139_51288[(2)] = inst_50944);

(statearr_51139_51288[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (55))){
var inst_51002 = (state_51116[(14)]);
var inst_50942 = (state_51116[(11)]);
var inst_51009 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_50942,inst_51002);
var state_51116__$1 = state_51116;
var statearr_51140_51289 = state_51116__$1;
(statearr_51140_51289[(2)] = inst_51009);

(statearr_51140_51289[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (85))){
var inst_51087 = (state_51116[(15)]);
var inst_51086 = (state_51116[(2)]);
var inst_51087__$1 = fluree.db.util.async.throw_err(inst_51086);
var inst_51088 = cljs.core.coll_QMARK_(inst_51087__$1);
var inst_51089 = (!(inst_51088));
var state_51116__$1 = (function (){var statearr_51141 = state_51116;
(statearr_51141[(15)] = inst_51087__$1);

return statearr_51141;
})();
if(inst_51089){
var statearr_51142_51290 = state_51116__$1;
(statearr_51142_51290[(1)] = (86));

} else {
var statearr_51143_51291 = state_51116__$1;
(statearr_51143_51291[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (39))){
var inst_50961 = (state_51116[(16)]);
var inst_50983 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_50984 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_50985 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_50961,inst_50983,inst_50984);
var state_51116__$1 = state_51116;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51116__$1,(42),inst_50985);
} else {
if((state_val_51117 === (88))){
var inst_51109 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51144_51292 = state_51116__$1;
(statearr_51144_51292[(2)] = inst_51109);

(statearr_51144_51292[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (46))){
var inst_50943 = (state_51116[(12)]);
var inst_50997 = ((0) < inst_50943);
var state_51116__$1 = state_51116;
if(cljs.core.truth_(inst_50997)){
var statearr_51145_51293 = state_51116__$1;
(statearr_51145_51293[(1)] = (49));

} else {
var statearr_51146_51294 = state_51116__$1;
(statearr_51146_51294[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (4))){
var inst_50875 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51147_51295 = state_51116__$1;
(statearr_51147_51295[(2)] = inst_50875);

(statearr_51147_51295[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (77))){
var inst_50942 = (state_51116[(11)]);
var inst_51053 = (inst_50942 - (1));
var state_51116__$1 = state_51116;
var statearr_51148_51296 = state_51116__$1;
(statearr_51148_51296[(2)] = inst_51053);

(statearr_51148_51296[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (95))){
var inst_51087 = (state_51116[(15)]);
var state_51116__$1 = state_51116;
var statearr_51149_51297 = state_51116__$1;
(statearr_51149_51297[(2)] = inst_51087);

(statearr_51149_51297[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (54))){
var inst_51007 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
if(cljs.core.truth_(inst_51007)){
var statearr_51150_51298 = state_51116__$1;
(statearr_51150_51298[(1)] = (55));

} else {
var statearr_51151_51299 = state_51116__$1;
(statearr_51151_51299[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (92))){
var inst_51087 = (state_51116[(15)]);
var inst_51100 = cljs.core.first(inst_51087);
var state_51116__$1 = state_51116;
var statearr_51152_51300 = state_51116__$1;
(statearr_51152_51300[(2)] = inst_51100);

(statearr_51152_51300[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (15))){
var inst_50893 = (state_51116[(17)]);
var inst_50901 = (state_51116[(2)]);
var inst_50902 = fluree.db.util.async.throw_err(inst_50901);
var inst_50903 = [inst_50893];
var inst_50904 = [inst_50902];
var inst_50905 = cljs.core.PersistentHashMap.fromArrays(inst_50903,inst_50904);
var state_51116__$1 = state_51116;
var statearr_51153_51301 = state_51116__$1;
(statearr_51153_51301[(2)] = inst_50905);

(statearr_51153_51301[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (48))){
var inst_51065 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51154_51302 = state_51116__$1;
(statearr_51154_51302[(2)] = inst_51065);

(statearr_51154_51302[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (50))){
var inst_50988 = (state_51116[(18)]);
var state_51116__$1 = state_51116;
var statearr_51155_51303 = state_51116__$1;
(statearr_51155_51303[(2)] = inst_50988);

(statearr_51155_51303[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (75))){
var inst_50957 = (state_51116[(19)]);
var inst_51019 = (state_51116[(13)]);
var inst_51036 = (state_51116[(20)]);
var inst_50954 = (state_51116[(21)]);
var inst_51047 = (state_51116[(2)]);
var inst_50940 = inst_50954;
var inst_50941 = inst_50957;
var inst_50942 = inst_51019;
var inst_50943 = inst_51036;
var inst_50944 = inst_51047;
var state_51116__$1 = (function (){var statearr_51156 = state_51116;
(statearr_51156[(22)] = inst_50941);

(statearr_51156[(9)] = inst_50944);

(statearr_51156[(11)] = inst_50942);

(statearr_51156[(23)] = inst_50940);

(statearr_51156[(12)] = inst_50943);

return statearr_51156;
})();
var statearr_51157_51304 = state_51116__$1;
(statearr_51157_51304[(2)] = null);

(statearr_51157_51304[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (21))){
var inst_50925 = (state_51116[(24)]);
var inst_50921 = (state_51116[(25)]);
var inst_50933 = (state_51116[(26)]);
var inst_50938 = (state_51116[(2)]);
var inst_50939 = cljs.core.PersistentHashMap.EMPTY;
var inst_50940 = inst_50921;
var inst_50941 = inst_50925;
var inst_50942 = inst_50933;
var inst_50943 = inst_50938;
var inst_50944 = inst_50939;
var state_51116__$1 = (function (){var statearr_51158 = state_51116;
(statearr_51158[(22)] = inst_50941);

(statearr_51158[(9)] = inst_50944);

(statearr_51158[(11)] = inst_50942);

(statearr_51158[(23)] = inst_50940);

(statearr_51158[(12)] = inst_50943);

return statearr_51158;
})();
var statearr_51159_51305 = state_51116__$1;
(statearr_51159_51305[(2)] = null);

(statearr_51159_51305[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (31))){
var inst_50958 = (state_51116[(27)]);
var inst_50943 = (state_51116[(12)]);
var inst_50972 = (inst_50943 >= inst_50958);
var state_51116__$1 = state_51116;
if(cljs.core.truth_(inst_50972)){
var statearr_51160_51306 = state_51116__$1;
(statearr_51160_51306[(1)] = (33));

} else {
var statearr_51161_51307 = state_51116__$1;
(statearr_51161_51307[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (32))){
var inst_51072 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51162_51308 = state_51116__$1;
(statearr_51162_51308[(2)] = inst_51072);

(statearr_51162_51308[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (40))){
var state_51116__$1 = state_51116;
var statearr_51163_51309 = state_51116__$1;
(statearr_51163_51309[(2)] = null);

(statearr_51163_51309[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (91))){
var inst_51097 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51164_51310 = state_51116__$1;
(statearr_51164_51310[(2)] = inst_51097);

(statearr_51164_51310[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (56))){
var inst_51002 = (state_51116[(14)]);
var state_51116__$1 = state_51116;
var statearr_51165_51311 = state_51116__$1;
(statearr_51165_51311[(2)] = inst_51002);

(statearr_51165_51311[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (33))){
var state_51116__$1 = state_51116;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_51166_51312 = state_51116__$1;
(statearr_51166_51312[(1)] = (36));

} else {
var statearr_51167_51313 = state_51116__$1;
(statearr_51167_51313[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (13))){
var inst_50925 = (state_51116[(24)]);
var inst_50921 = (state_51116[(25)]);
var inst_50890 = (state_51116[(28)]);
var inst_50921__$1 = cljs.core.keys(inst_50890);
var inst_50922 = cljs.core.seq(inst_50921__$1);
var inst_50923 = cljs.core.first(inst_50922);
var inst_50924 = cljs.core.next(inst_50922);
var inst_50925__$1 = cljs.core.vals(inst_50890);
var inst_50926 = cljs.core.seq(inst_50925__$1);
var inst_50927 = cljs.core.first(inst_50926);
var inst_50928 = cljs.core.next(inst_50926);
var inst_50929 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_51116__$1 = (function (){var statearr_51168 = state_51116;
(statearr_51168[(24)] = inst_50925__$1);

(statearr_51168[(29)] = inst_50927);

(statearr_51168[(25)] = inst_50921__$1);

(statearr_51168[(30)] = inst_50924);

(statearr_51168[(31)] = inst_50928);

(statearr_51168[(32)] = inst_50923);

return statearr_51168;
})();
if(inst_50929){
var statearr_51169_51314 = state_51116__$1;
(statearr_51169_51314[(1)] = (16));

} else {
var statearr_51170_51315 = state_51116__$1;
(statearr_51170_51315[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (22))){
var inst_50941 = (state_51116[(22)]);
var inst_50940 = (state_51116[(23)]);
var inst_50952 = cljs.core.seq(inst_50940);
var inst_50953 = cljs.core.first(inst_50952);
var inst_50954 = cljs.core.next(inst_50952);
var inst_50955 = cljs.core.seq(inst_50941);
var inst_50956 = cljs.core.first(inst_50955);
var inst_50957 = cljs.core.next(inst_50955);
var inst_50958 = cljs.core.count(inst_50956);
var inst_50959 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_50960 = [headers,vars,inst_50956];
var inst_50961 = cljs.core.PersistentHashMap.fromArrays(inst_50959,inst_50960);
var inst_50962 = (inst_50956 == null);
var state_51116__$1 = (function (){var statearr_51171 = state_51116;
(statearr_51171[(27)] = inst_50958);

(statearr_51171[(19)] = inst_50957);

(statearr_51171[(16)] = inst_50961);

(statearr_51171[(8)] = inst_50953);

(statearr_51171[(21)] = inst_50954);

return statearr_51171;
})();
if(cljs.core.truth_(inst_50962)){
var statearr_51172_51316 = state_51116__$1;
(statearr_51172_51316[(1)] = (24));

} else {
var statearr_51173_51317 = state_51116__$1;
(statearr_51173_51317[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (90))){
var inst_51087 = (state_51116[(15)]);
var state_51116__$1 = state_51116;
var statearr_51174_51318 = state_51116__$1;
(statearr_51174_51318[(2)] = inst_51087);

(statearr_51174_51318[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (36))){
var inst_50943 = (state_51116[(12)]);
var inst_50975 = (inst_50943 - (1));
var state_51116__$1 = state_51116;
var statearr_51175_51319 = state_51116__$1;
(statearr_51175_51319[(2)] = inst_50975);

(statearr_51175_51319[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (41))){
var inst_51068 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51176_51320 = state_51116__$1;
(statearr_51176_51320[(2)] = inst_51068);

(statearr_51176_51320[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (89))){
var inst_51087 = (state_51116[(15)]);
var inst_51092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_51093 = [inst_51087];
var inst_51094 = (new cljs.core.PersistentVector(null,1,(5),inst_51092,inst_51093,null));
var state_51116__$1 = state_51116;
var statearr_51177_51321 = state_51116__$1;
(statearr_51177_51321[(2)] = inst_51094);

(statearr_51177_51321[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (43))){
var inst_50988 = (state_51116[(18)]);
var inst_50991 = cljs.core.seq(inst_50988);
var state_51116__$1 = state_51116;
var statearr_51178_51322 = state_51116__$1;
(statearr_51178_51322[(2)] = inst_50991);

(statearr_51178_51322[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (61))){
var state_51116__$1 = state_51116;
var statearr_51179_51323 = state_51116__$1;
(statearr_51179_51323[(2)] = (0));

(statearr_51179_51323[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (29))){
var inst_50969 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
if(cljs.core.truth_(inst_50969)){
var statearr_51180_51324 = state_51116__$1;
(statearr_51180_51324[(1)] = (30));

} else {
var statearr_51181_51325 = state_51116__$1;
(statearr_51181_51325[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (44))){
var inst_50989 = (state_51116[(33)]);
var state_51116__$1 = state_51116;
var statearr_51182_51326 = state_51116__$1;
(statearr_51182_51326[(2)] = inst_50989);

(statearr_51182_51326[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (93))){
var state_51116__$1 = state_51116;
var statearr_51183_51327 = state_51116__$1;
(statearr_51183_51327[(1)] = (95));



return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (6))){
var inst_50882 = (state_51116[(34)]);
var inst_50882__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_50884 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_51116__$1 = (function (){var statearr_51185 = state_51116;
(statearr_51185[(34)] = inst_50882__$1);

(statearr_51185[(35)] = inst_50884);

return statearr_51185;
})();
if(cljs.core.truth_(inst_50882__$1)){
var statearr_51186_51328 = state_51116__$1;
(statearr_51186_51328[(1)] = (9));

} else {
var statearr_51187_51329 = state_51116__$1;
(statearr_51187_51329[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (28))){
var inst_50942 = (state_51116[(11)]);
var state_51116__$1 = state_51116;
var statearr_51188_51330 = state_51116__$1;
(statearr_51188_51330[(2)] = inst_50942);

(statearr_51188_51330[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (64))){
var inst_50943 = (state_51116[(12)]);
var inst_51024 = (inst_50943 - (1));
var state_51116__$1 = state_51116;
var statearr_51189_51331 = state_51116__$1;
(statearr_51189_51331[(2)] = inst_51024);

(statearr_51189_51331[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (51))){
var inst_50942 = (state_51116[(11)]);
var inst_51002 = (state_51116[(2)]);
var state_51116__$1 = (function (){var statearr_51190 = state_51116;
(statearr_51190[(14)] = inst_51002);

return statearr_51190;
})();
if(cljs.core.truth_(inst_50942)){
var statearr_51191_51332 = state_51116__$1;
(statearr_51191_51332[(1)] = (52));

} else {
var statearr_51192_51333 = state_51116__$1;
(statearr_51192_51333[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (25))){
var inst_50942 = (state_51116[(11)]);
var state_51116__$1 = state_51116;
if(cljs.core.truth_(inst_50942)){
var statearr_51193_51334 = state_51116__$1;
(statearr_51193_51334[(1)] = (27));

} else {
var statearr_51194_51335 = state_51116__$1;
(statearr_51194_51335[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (34))){
var state_51116__$1 = state_51116;
var statearr_51195_51336 = state_51116__$1;
(statearr_51195_51336[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (17))){
var state_51116__$1 = state_51116;
var statearr_51197_51337 = state_51116__$1;
(statearr_51197_51337[(2)] = limit);

(statearr_51197_51337[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (3))){
var inst_51114 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51116__$1,inst_51114);
} else {
if((state_val_51117 === (12))){
var inst_50890 = (state_51116[(28)]);
var inst_50892 = cljs.core.keys(inst_50890);
var inst_50893 = cljs.core.first(inst_50892);
var inst_50894 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_50895 = cljs.core.vals(inst_50890);
var inst_50896 = cljs.core.first(inst_50895);
var inst_50897 = [headers,vars,inst_50896];
var inst_50898 = cljs.core.PersistentHashMap.fromArrays(inst_50894,inst_50897);
var inst_50899 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_50898,select_spec,limit,opts);
var state_51116__$1 = (function (){var statearr_51198 = state_51116;
(statearr_51198[(17)] = inst_50893);

return statearr_51198;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51116__$1,(15),inst_50899);
} else {
if((state_val_51117 === (2))){
var _ = (function (){var statearr_51199 = state_51116;
(statearr_51199[(4)] = cljs.core.cons((5),(state_51116[(4)])));

return statearr_51199;
})();
var state_51116__$1 = state_51116;
if(cljs.core.truth_(groupBy)){
var statearr_51200_51338 = state_51116__$1;
(statearr_51200_51338[(1)] = (6));

} else {
var statearr_51201_51339 = state_51116__$1;
(statearr_51201_51339[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (66))){
var inst_51034 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51202_51340 = state_51116__$1;
(statearr_51202_51340[(2)] = inst_51034);

(statearr_51202_51340[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (23))){
var inst_51076 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51203_51341 = state_51116__$1;
(statearr_51203_51341[(2)] = inst_51076);

(statearr_51203_51341[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (47))){
var inst_50942 = (state_51116[(11)]);
var inst_51050 = (inst_50942 == null);
var state_51116__$1 = state_51116;
if(cljs.core.truth_(inst_51050)){
var statearr_51204_51342 = state_51116__$1;
(statearr_51204_51342[(1)] = (76));

} else {
var statearr_51205_51343 = state_51116__$1;
(statearr_51205_51343[(1)] = (77));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (35))){
var inst_51070 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51206_51344 = state_51116__$1;
(statearr_51206_51344[(2)] = inst_51070);

(statearr_51206_51344[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (82))){
var state_51116__$1 = state_51116;
var statearr_51207_51345 = state_51116__$1;
(statearr_51207_51345[(2)] = (1));

(statearr_51207_51345[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (76))){
var state_51116__$1 = state_51116;
var statearr_51208_51346 = state_51116__$1;
(statearr_51208_51346[(2)] = null);

(statearr_51208_51346[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (97))){
var inst_51105 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51209_51347 = state_51116__$1;
(statearr_51209_51347[(2)] = inst_51105);

(statearr_51209_51347[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (19))){
var inst_50934 = (state_51116[(36)]);
var state_51116__$1 = state_51116;
var statearr_51210_51348 = state_51116__$1;
(statearr_51210_51348[(2)] = inst_50934);

(statearr_51210_51348[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (57))){
var inst_50942 = (state_51116[(11)]);
var inst_51012 = (state_51116[(2)]);
var inst_51013 = (inst_50942 == null);
var state_51116__$1 = (function (){var statearr_51211 = state_51116;
(statearr_51211[(10)] = inst_51012);

return statearr_51211;
})();
if(cljs.core.truth_(inst_51013)){
var statearr_51212_51349 = state_51116__$1;
(statearr_51212_51349[(1)] = (58));

} else {
var statearr_51213_51350 = state_51116__$1;
(statearr_51213_51350[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (68))){
var state_51116__$1 = state_51116;
var statearr_51214_51351 = state_51116__$1;
(statearr_51214_51351[(2)] = null);

(statearr_51214_51351[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (11))){
var inst_50890 = (state_51116[(2)]);
var state_51116__$1 = (function (){var statearr_51216 = state_51116;
(statearr_51216[(28)] = inst_50890);

return statearr_51216;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_51217_51352 = state_51116__$1;
(statearr_51217_51352[(1)] = (12));

} else {
var statearr_51218_51353 = state_51116__$1;
(statearr_51218_51353[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (9))){
var inst_50882 = (state_51116[(34)]);
var inst_50884 = (state_51116[(35)]);
var inst_50886 = cljs.core.sorted_map_by(inst_50882);
var inst_50887 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_50886,inst_50884);
var state_51116__$1 = state_51116;
var statearr_51219_51354 = state_51116__$1;
(statearr_51219_51354[(2)] = inst_50887);

(statearr_51219_51354[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (5))){
var _ = (function (){var statearr_51220 = state_51116;
(statearr_51220[(4)] = cljs.core.rest((state_51116[(4)])));

return statearr_51220;
})();
var state_51116__$1 = state_51116;
var ex51215 = (state_51116__$1[(2)]);
var statearr_51221_51355 = state_51116__$1;
(statearr_51221_51355[(5)] = ex51215);


if((ex51215 instanceof Error)){
var statearr_51222_51356 = state_51116__$1;
(statearr_51222_51356[(1)] = (4));

(statearr_51222_51356[(5)] = null);

} else {
throw ex51215;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (83))){
var state_51116__$1 = state_51116;
var statearr_51223_51357 = state_51116__$1;
(statearr_51223_51357[(2)] = limit);

(statearr_51223_51357[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (14))){
var inst_51078 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51224_51358 = state_51116__$1;
(statearr_51224_51358[(2)] = inst_51078);

(statearr_51224_51358[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (45))){
var inst_50994 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
if(cljs.core.truth_(inst_50994)){
var statearr_51225_51359 = state_51116__$1;
(statearr_51225_51359[(1)] = (46));

} else {
var statearr_51226_51360 = state_51116__$1;
(statearr_51226_51360[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (53))){
var inst_50942 = (state_51116[(11)]);
var state_51116__$1 = state_51116;
var statearr_51227_51361 = state_51116__$1;
(statearr_51227_51361[(2)] = inst_50942);

(statearr_51227_51361[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (78))){
var inst_50943 = (state_51116[(12)]);
var inst_51055 = (state_51116[(2)]);
var inst_51056 = (inst_50943 <= (0));
var state_51116__$1 = (function (){var statearr_51228 = state_51116;
(statearr_51228[(37)] = inst_51055);

return statearr_51228;
})();
if(cljs.core.truth_(inst_51056)){
var statearr_51229_51362 = state_51116__$1;
(statearr_51229_51362[(1)] = (79));

} else {
var statearr_51230_51363 = state_51116__$1;
(statearr_51230_51363[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (26))){
var inst_51074 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51231_51364 = state_51116__$1;
(statearr_51231_51364[(2)] = inst_51074);

(statearr_51231_51364[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (16))){
var state_51116__$1 = state_51116;
var statearr_51232_51365 = state_51116__$1;
(statearr_51232_51365[(2)] = null);

(statearr_51232_51365[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (81))){
var inst_50957 = (state_51116[(19)]);
var inst_50953 = (state_51116[(8)]);
var inst_50944 = (state_51116[(9)]);
var inst_50954 = (state_51116[(21)]);
var inst_51055 = (state_51116[(37)]);
var inst_50988 = (state_51116[(18)]);
var inst_51061 = (state_51116[(2)]);
var inst_51062 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_50944,inst_50953,inst_50988);
var inst_50940 = inst_50954;
var inst_50941 = inst_50957;
var inst_50942 = inst_51055;
var inst_50943 = inst_51061;
var inst_50944__$1 = inst_51062;
var state_51116__$1 = (function (){var statearr_51235 = state_51116;
(statearr_51235[(22)] = inst_50941);

(statearr_51235[(9)] = inst_50944__$1);

(statearr_51235[(11)] = inst_50942);

(statearr_51235[(23)] = inst_50940);

(statearr_51235[(12)] = inst_50943);

return statearr_51235;
})();
var statearr_51236_51366 = state_51116__$1;
(statearr_51236_51366[(2)] = null);

(statearr_51236_51366[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (79))){
var state_51116__$1 = state_51116;
var statearr_51237_51367 = state_51116__$1;
(statearr_51237_51367[(2)] = (0));

(statearr_51237_51367[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (38))){
var inst_50957 = (state_51116[(19)]);
var inst_50944 = (state_51116[(9)]);
var inst_50942 = (state_51116[(11)]);
var inst_50954 = (state_51116[(21)]);
var inst_50979 = (state_51116[(2)]);
var tmp51233 = inst_50944;
var tmp51234 = inst_50942;
var inst_50940 = inst_50954;
var inst_50941 = inst_50957;
var inst_50942__$1 = tmp51234;
var inst_50943 = inst_50979;
var inst_50944__$1 = tmp51233;
var state_51116__$1 = (function (){var statearr_51238 = state_51116;
(statearr_51238[(22)] = inst_50941);

(statearr_51238[(9)] = inst_50944__$1);

(statearr_51238[(11)] = inst_50942__$1);

(statearr_51238[(23)] = inst_50940);

(statearr_51238[(12)] = inst_50943);

return statearr_51238;
})();
var statearr_51239_51368 = state_51116__$1;
(statearr_51239_51368[(2)] = null);

(statearr_51239_51368[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (87))){
var state_51116__$1 = state_51116;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_51240_51369 = state_51116__$1;
(statearr_51240_51369[(1)] = (92));

} else {
var statearr_51241_51370 = state_51116__$1;
(statearr_51241_51370[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (30))){
var inst_50944 = (state_51116[(9)]);
var state_51116__$1 = state_51116;
var statearr_51242_51371 = state_51116__$1;
(statearr_51242_51371[(2)] = inst_50944);

(statearr_51242_51371[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (73))){
var inst_50944 = (state_51116[(9)]);
var state_51116__$1 = state_51116;
var statearr_51243_51372 = state_51116__$1;
(statearr_51243_51372[(2)] = inst_50944);

(statearr_51243_51372[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (96))){
var state_51116__$1 = state_51116;
var statearr_51244_51373 = state_51116__$1;
(statearr_51244_51373[(2)] = null);

(statearr_51244_51373[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (10))){
var inst_50884 = (state_51116[(35)]);
var state_51116__$1 = state_51116;
var statearr_51245_51374 = state_51116__$1;
(statearr_51245_51374[(2)] = inst_50884);

(statearr_51245_51374[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (18))){
var inst_50934 = (state_51116[(36)]);
var inst_50933 = (state_51116[(2)]);
var inst_50934__$1 = offset;
var state_51116__$1 = (function (){var statearr_51246 = state_51116;
(statearr_51246[(36)] = inst_50934__$1);

(statearr_51246[(26)] = inst_50933);

return statearr_51246;
})();
if(cljs.core.truth_(inst_50934__$1)){
var statearr_51247_51375 = state_51116__$1;
(statearr_51247_51375[(1)] = (19));

} else {
var statearr_51248_51376 = state_51116__$1;
(statearr_51248_51376[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (52))){
var inst_50942 = (state_51116[(11)]);
var inst_51004 = ((0) < inst_50942);
var state_51116__$1 = state_51116;
var statearr_51249_51377 = state_51116__$1;
(statearr_51249_51377[(2)] = inst_51004);

(statearr_51249_51377[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (67))){
var inst_50958 = (state_51116[(27)]);
var inst_51012 = (state_51116[(10)]);
var inst_50943 = (state_51116[(12)]);
var inst_51027 = cljs.core.count(inst_51012);
var inst_51028 = (inst_50958 - inst_51027);
var inst_51029 = (inst_50943 - inst_51028);
var state_51116__$1 = state_51116;
var statearr_51250_51378 = state_51116__$1;
(statearr_51250_51378[(2)] = inst_51029);

(statearr_51250_51378[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (71))){
var inst_51012 = (state_51116[(10)]);
var inst_51040 = cljs.core.empty_QMARK_(inst_51012);
var state_51116__$1 = state_51116;
var statearr_51251_51379 = state_51116__$1;
(statearr_51251_51379[(2)] = inst_51040);

(statearr_51251_51379[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (42))){
var inst_50989 = (state_51116[(33)]);
var inst_50988 = (state_51116[(18)]);
var inst_50987 = (state_51116[(2)]);
var inst_50988__$1 = fluree.db.util.async.throw_err(inst_50987);
var inst_50989__$1 = cljs.core.coll_QMARK_(inst_50988__$1);
var state_51116__$1 = (function (){var statearr_51252 = state_51116;
(statearr_51252[(33)] = inst_50989__$1);

(statearr_51252[(18)] = inst_50988__$1);

return statearr_51252;
})();
if(inst_50989__$1){
var statearr_51253_51380 = state_51116__$1;
(statearr_51253_51380[(1)] = (43));

} else {
var statearr_51254_51381 = state_51116__$1;
(statearr_51254_51381[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (80))){
var inst_50943 = (state_51116[(12)]);
var inst_51059 = (inst_50943 - (1));
var state_51116__$1 = state_51116;
var statearr_51255_51382 = state_51116__$1;
(statearr_51255_51382[(2)] = inst_51059);

(statearr_51255_51382[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (37))){
var inst_50958 = (state_51116[(27)]);
var inst_50943 = (state_51116[(12)]);
var inst_50977 = (inst_50943 - inst_50958);
var state_51116__$1 = state_51116;
var statearr_51256_51383 = state_51116__$1;
(statearr_51256_51383[(2)] = inst_50977);

(statearr_51256_51383[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (63))){
var inst_51037 = (state_51116[(7)]);
var inst_51012 = (state_51116[(10)]);
var inst_51036 = (state_51116[(2)]);
var inst_51037__$1 = (inst_51012 == null);
var state_51116__$1 = (function (){var statearr_51257 = state_51116;
(statearr_51257[(7)] = inst_51037__$1);

(statearr_51257[(20)] = inst_51036);

return statearr_51257;
})();
if(cljs.core.truth_(inst_51037__$1)){
var statearr_51258_51384 = state_51116__$1;
(statearr_51258_51384[(1)] = (70));

} else {
var statearr_51259_51385 = state_51116__$1;
(statearr_51259_51385[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (94))){
var inst_51107 = (state_51116[(2)]);
var state_51116__$1 = state_51116;
var statearr_51260_51386 = state_51116__$1;
(statearr_51260_51386[(2)] = inst_51107);

(statearr_51260_51386[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (8))){
var inst_51111 = (state_51116[(2)]);
var _ = (function (){var statearr_51261 = state_51116;
(statearr_51261[(4)] = cljs.core.rest((state_51116[(4)])));

return statearr_51261;
})();
var state_51116__$1 = state_51116;
var statearr_51262_51387 = state_51116__$1;
(statearr_51262_51387[(2)] = inst_51111);

(statearr_51262_51387[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (49))){
var inst_50943 = (state_51116[(12)]);
var inst_50988 = (state_51116[(18)]);
var inst_50999 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_50943,inst_50988);
var state_51116__$1 = state_51116;
var statearr_51263_51388 = state_51116__$1;
(statearr_51263_51388[(2)] = inst_50999);

(statearr_51263_51388[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51117 === (84))){
var inst_51083 = (state_51116[(2)]);
var inst_51084 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_51083,opts);
var state_51116__$1 = state_51116;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51116__$1,(85),inst_51084);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__24298__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__24298__auto____0 = (function (){
var statearr_51264 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51264[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__24298__auto__);

(statearr_51264[(1)] = (1));

return statearr_51264;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__24298__auto____1 = (function (state_51116){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_51116);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e51265){var ex__24301__auto__ = e51265;
var statearr_51266_51389 = state_51116;
(statearr_51266_51389[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_51116[(4)]))){
var statearr_51267_51390 = state_51116;
(statearr_51267_51390[(1)] = cljs.core.first((state_51116[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__51391 = state_51116;
state_51116 = G__51391;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__24298__auto__ = function(state_51116){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__24298__auto____1.call(this,state_51116);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__24298__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__24298__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_51268 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_51268[(6)] = c__24424__auto__);

return statearr_51268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__51394,opts){
var map__51395 = p__51394;
var map__51395__$1 = cljs.core.__destructure_map(map__51395);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51395__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51395__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51395__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51395__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4212__auto__ = selectOne;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = select;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
var or__4212__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4212__auto____$2)){
return or__4212__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__51392_SHARP_){
return cljs.core.contains_QMARK_(p1__51392_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__51393_SHARP_){
return cljs.core.contains_QMARK_(p1__51393_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4212__auto__ = typeof orderBy === 'string';
if(or__4212__auto__){
return or__4212__auto__;
} else {
var and__4210__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4210__auto__){
var G__51397 = cljs.core.first(orderBy);
var fexpr__51396 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__51396.cljs$core$IFn$_invoke$arity$1 ? fexpr__51396.cljs$core$IFn$_invoke$arity$1(G__51397) : fexpr__51396.call(null,G__51397));
} else {
return and__4210__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4212__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})(),(function (){var or__4212__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4212__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4212__auto__ = selectDistinct;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__51398,p__51399){
var map__51400 = p__51398;
var map__51400__$1 = cljs.core.__destructure_map(map__51400);
var query_map = map__51400__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51400__$1,cljs.core.cst$kw$construct);
var map__51401 = p__51399;
var map__51401__$1 = cljs.core.__destructure_map(map__51401);
var where_result = map__51401__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51401__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51401__$1,cljs.core.cst$kw$tuples);
var vec__51402 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51402,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51402,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51402,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_51435){
var state_val_51436 = (state_51435[(1)]);
if((state_val_51436 === (7))){
var inst_51414 = (state_51435[(7)]);
var state_51435__$1 = state_51435;
var statearr_51437_51460 = state_51435__$1;
(statearr_51437_51460[(2)] = inst_51414);

(statearr_51437_51460[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51436 === (1))){
var state_51435__$1 = state_51435;
var statearr_51438_51461 = state_51435__$1;
(statearr_51438_51461[(2)] = null);

(statearr_51438_51461[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51436 === (4))){
var inst_51405 = (state_51435[(2)]);
var state_51435__$1 = state_51435;
var statearr_51439_51462 = state_51435__$1;
(statearr_51439_51462[(2)] = inst_51405);

(statearr_51439_51462[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51436 === (13))){
var inst_51424 = (state_51435[(2)]);
var inst_51425 = fluree.db.util.async.throw_err(inst_51424);
var state_51435__$1 = state_51435;
var statearr_51440_51463 = state_51435__$1;
(statearr_51440_51463[(2)] = inst_51425);

(statearr_51440_51463[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51436 === (6))){
var inst_51414 = (state_51435[(7)]);
var inst_51413 = (state_51435[(2)]);
var inst_51414__$1 = fluree.db.util.async.throw_err(inst_51413);
var inst_51415 = fluree.db.util.core.exception_QMARK_(inst_51414__$1);
var state_51435__$1 = (function (){var statearr_51441 = state_51435;
(statearr_51441[(7)] = inst_51414__$1);

return statearr_51441;
})();
if(inst_51415){
var statearr_51442_51464 = state_51435__$1;
(statearr_51442_51464[(1)] = (7));

} else {
var statearr_51443_51465 = state_51435__$1;
(statearr_51443_51465[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51436 === (3))){
var inst_51433 = (state_51435[(2)]);
var state_51435__$1 = state_51435;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51435__$1,inst_51433);
} else {
if((state_val_51436 === (12))){
var inst_51428 = (state_51435[(2)]);
var state_51435__$1 = state_51435;
var statearr_51444_51466 = state_51435__$1;
(statearr_51444_51466[(2)] = inst_51428);

(statearr_51444_51466[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51436 === (2))){
var _ = (function (){var statearr_51445 = state_51435;
(statearr_51445[(4)] = cljs.core.cons((5),(state_51435[(4)])));

return statearr_51445;
})();
var inst_51411 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_51435__$1 = state_51435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51435__$1,(6),inst_51411);
} else {
if((state_val_51436 === (11))){
var state_51435__$1 = state_51435;
var statearr_51447_51467 = state_51435__$1;
(statearr_51447_51467[(2)] = null);

(statearr_51447_51467[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51436 === (9))){
var inst_51430 = (state_51435[(2)]);
var _ = (function (){var statearr_51448 = state_51435;
(statearr_51448[(4)] = cljs.core.rest((state_51435[(4)])));

return statearr_51448;
})();
var state_51435__$1 = state_51435;
var statearr_51449_51468 = state_51435__$1;
(statearr_51449_51468[(2)] = inst_51430);

(statearr_51449_51468[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51436 === (5))){
var _ = (function (){var statearr_51450 = state_51435;
(statearr_51450[(4)] = cljs.core.rest((state_51435[(4)])));

return statearr_51450;
})();
var state_51435__$1 = state_51435;
var ex51446 = (state_51435__$1[(2)]);
var statearr_51451_51469 = state_51435__$1;
(statearr_51451_51469[(5)] = ex51446);


if((ex51446 instanceof Error)){
var statearr_51452_51470 = state_51435__$1;
(statearr_51452_51470[(1)] = (4));

(statearr_51452_51470[(5)] = null);

} else {
throw ex51446;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51436 === (10))){
var inst_51414 = (state_51435[(7)]);
var inst_51419 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_51414);
var inst_51420 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_51414);
var inst_51421 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_51419,inst_51420,query_map,opts);
var inst_51422 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_51414,inst_51421,opts);
var state_51435__$1 = state_51435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51435__$1,(13),inst_51422);
} else {
if((state_val_51436 === (8))){
var state_51435__$1 = state_51435;
var statearr_51453_51471 = state_51435__$1;
(statearr_51453_51471[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__24298__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__24298__auto____0 = (function (){
var statearr_51455 = [null,null,null,null,null,null,null,null];
(statearr_51455[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__24298__auto__);

(statearr_51455[(1)] = (1));

return statearr_51455;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__24298__auto____1 = (function (state_51435){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_51435);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e51456){var ex__24301__auto__ = e51456;
var statearr_51457_51472 = state_51435;
(statearr_51457_51472[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_51435[(4)]))){
var statearr_51458_51473 = state_51435;
(statearr_51458_51473[(1)] = cljs.core.first((state_51435[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__51474 = state_51435;
state_51435 = G__51474;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__24298__auto__ = function(state_51435){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__24298__auto____1.call(this,state_51435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__24298__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__24298__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_51459 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_51459[(6)] = c__24424__auto__);

return statearr_51459;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__51475 = query_map;
var map__51475__$1 = cljs.core.__destructure_map(map__51475);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51475__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51475__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51475__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51475__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51475__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51475__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51475__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51475__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51475__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51475__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51475__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51475__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__51476 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4212__auto__ = offset;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__51476,cljs.core.cst$kw$limit,(1));
} else {
return G__51476;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4212__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.truth_((function (){var or__4212__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_51831){
var state_val_51832 = (state_51831[(1)]);
if((state_val_51832 === (121))){
var inst_51792 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51833_52028 = state_51831__$1;
(statearr_51833_52028[(2)] = inst_51792);

(statearr_51833_52028[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (65))){
var inst_51669 = typeof from === 'string';
var state_51831__$1 = state_51831;
if(cljs.core.truth_(inst_51669)){
var statearr_51834_52029 = state_51831__$1;
(statearr_51834_52029[(1)] = (72));

} else {
var statearr_51835_52030 = state_51831__$1;
(statearr_51835_52030[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (70))){
var inst_51538 = (state_51831[(7)]);
var inst_51540 = (state_51831[(8)]);
var inst_51662 = (state_51831[(2)]);
var inst_51663 = fluree.db.util.async.throw_err(inst_51662);
var inst_51664 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_51540,fuel,max_fuel,inst_51538,inst_51663);
var state_51831__$1 = state_51831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51831__$1,(71),inst_51664);
} else {
if((state_val_51832 === (62))){
var inst_51642 = (state_51831[(9)]);
var state_51831__$1 = state_51831;
var statearr_51836_52031 = state_51831__$1;
(statearr_51836_52031[(2)] = inst_51642);

(statearr_51836_52031[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (74))){
var inst_51798 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51837_52032 = state_51831__$1;
(statearr_51837_52032[(2)] = inst_51798);

(statearr_51837_52032[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (110))){
var inst_51733 = (state_51831[(10)]);
var state_51831__$1 = state_51831;
var statearr_51838_52033 = state_51831__$1;
(statearr_51838_52033[(2)] = inst_51733);

(statearr_51838_52033[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (130))){
var inst_51818 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51839_52034 = state_51831__$1;
(statearr_51839_52034[(2)] = inst_51818);

(statearr_51839_52034[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (128))){
var inst_51809 = (state_51831[(11)]);
var inst_51814 = fluree.db.util.core.exception_QMARK_(inst_51809);
var inst_51815 = (!(inst_51814));
var state_51831__$1 = state_51831;
var statearr_51840_52035 = state_51831__$1;
(statearr_51840_52035[(2)] = inst_51815);

(statearr_51840_52035[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (7))){
var inst_51508 = (state_51831[(12)]);
var inst_51508__$1 = selectOne;
var state_51831__$1 = (function (){var statearr_51841 = state_51831;
(statearr_51841[(12)] = inst_51508__$1);

return statearr_51841;
})();
if(cljs.core.truth_(inst_51508__$1)){
var statearr_51842_52036 = state_51831__$1;
(statearr_51842_52036[(1)] = (9));

} else {
var statearr_51843_52037 = state_51831__$1;
(statearr_51843_52037[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (59))){
var inst_51620 = (state_51831[(13)]);
var inst_51538 = (state_51831[(7)]);
var inst_51528 = (state_51831[(14)]);
var inst_51540 = (state_51831[(8)]);
var inst_51634 = (state_51831[(2)]);
var inst_51635 = fluree.db.util.async.throw_err(inst_51634);
var inst_51636 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_51620,inst_51635);
var inst_51637 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_51540,fuel,max_fuel,inst_51538,inst_51636,inst_51528);
var state_51831__$1 = state_51831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51831__$1,(60),inst_51637);
} else {
if((state_val_51832 === (86))){
var inst_51538 = (state_51831[(7)]);
var inst_51530 = (state_51831[(15)]);
var inst_51528 = (state_51831[(14)]);
var inst_51540 = (state_51831[(8)]);
var inst_51702 = (state_51831[(2)]);
var inst_51703 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_51540,fuel,max_fuel,inst_51538,inst_51702,inst_51528,inst_51530);
var state_51831__$1 = state_51831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51831__$1,(87),inst_51703);
} else {
if((state_val_51832 === (20))){
var inst_51572 = (state_51831[(2)]);
var inst_51573 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_51572,(0),null);
var inst_51574 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_51572,(1),null);
var inst_51575 = typeof where === 'string';
var state_51831__$1 = (function (){var statearr_51844 = state_51831;
(statearr_51844[(16)] = inst_51573);

(statearr_51844[(17)] = inst_51574);

return statearr_51844;
})();
if(cljs.core.truth_(inst_51575)){
var statearr_51845_52038 = state_51831__$1;
(statearr_51845_52038[(1)] = (30));

} else {
var statearr_51846_52039 = state_51831__$1;
(statearr_51846_52039[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (72))){
var inst_51527 = (state_51831[(18)]);
var state_51831__$1 = state_51831;
if(cljs.core.truth_(inst_51527)){
var statearr_51847_52040 = state_51831__$1;
(statearr_51847_52040[(1)] = (75));

} else {
var statearr_51848_52041 = state_51831__$1;
(statearr_51848_52041[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (58))){
var inst_51628 = (state_51831[(2)]);
var inst_51629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_51630 = [from];
var inst_51631 = (new cljs.core.PersistentVector(null,1,(5),inst_51629,inst_51630,null));
var inst_51632 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_51631,inst_51628);
var state_51831__$1 = state_51831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51831__$1,(59),inst_51632);
} else {
if((state_val_51832 === (60))){
var inst_51639 = (state_51831[(2)]);
var inst_51640 = fluree.db.util.async.throw_err(inst_51639);
var state_51831__$1 = state_51831;
var statearr_51849_52042 = state_51831__$1;
(statearr_51849_52042[(2)] = inst_51640);

(statearr_51849_52042[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (27))){
var inst_51557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_51558 = [null,null];
var inst_51559 = (new cljs.core.PersistentVector(null,2,(5),inst_51557,inst_51558,null));
var state_51831__$1 = state_51831;
var statearr_51850_52043 = state_51831__$1;
(statearr_51850_52043[(2)] = inst_51559);

(statearr_51850_52043[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (1))){
var state_51831__$1 = state_51831;
var statearr_51851_52044 = state_51831__$1;
(statearr_51851_52044[(2)] = null);

(statearr_51851_52044[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (69))){
var inst_51659 = (state_51831[(2)]);
var inst_51660 = fluree.db.query.range._block_or_tx_collection(db,inst_51659);
var state_51831__$1 = state_51831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51831__$1,(70),inst_51660);
} else {
if((state_val_51832 === (101))){
var inst_51765 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51852_52045 = state_51831__$1;
(statearr_51852_52045[(2)] = inst_51765);

(statearr_51852_52045[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (24))){
var inst_51527 = (state_51831[(18)]);
var inst_51552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_51553 = [inst_51527,"ASC"];
var inst_51554 = (new cljs.core.PersistentVector(null,2,(5),inst_51552,inst_51553,null));
var state_51831__$1 = state_51831;
var statearr_51853_52046 = state_51831__$1;
(statearr_51853_52046[(2)] = inst_51554);

(statearr_51853_52046[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (102))){
var inst_51739 = (state_51831[(19)]);
var state_51831__$1 = state_51831;
var statearr_51854_52047 = state_51831__$1;
(statearr_51854_52047[(2)] = inst_51739);

(statearr_51854_52047[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (55))){
var inst_51527 = (state_51831[(18)]);
var inst_51620 = (state_51831[(2)]);
var state_51831__$1 = (function (){var statearr_51855 = state_51831;
(statearr_51855[(13)] = inst_51620);

return statearr_51855;
})();
if(cljs.core.truth_(inst_51527)){
var statearr_51856_52048 = state_51831__$1;
(statearr_51856_52048[(1)] = (56));

} else {
var statearr_51857_52049 = state_51831__$1;
(statearr_51857_52049[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (85))){
var inst_51694 = (state_51831[(20)]);
var inst_51698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_51699 = [inst_51694];
var inst_51700 = (new cljs.core.PersistentVector(null,1,(5),inst_51698,inst_51699,null));
var state_51831__$1 = state_51831;
var statearr_51858_52050 = state_51831__$1;
(statearr_51858_52050[(2)] = inst_51700);

(statearr_51858_52050[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (39))){
var inst_51528 = (state_51831[(14)]);
var state_51831__$1 = state_51831;
var statearr_51859_52051 = state_51831__$1;
(statearr_51859_52051[(2)] = inst_51528);

(statearr_51859_52051[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (88))){
var inst_51708 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_51831__$1 = state_51831;
var statearr_51860_52052 = state_51831__$1;
(statearr_51860_52052[(2)] = inst_51708);

(statearr_51860_52052[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (46))){
var inst_51605 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
if(cljs.core.truth_(inst_51605)){
var statearr_51861_52053 = state_51831__$1;
(statearr_51861_52053[(1)] = (47));

} else {
var statearr_51862_52054 = state_51831__$1;
(statearr_51862_52054[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (4))){
var inst_51495 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51863_52055 = state_51831__$1;
(statearr_51863_52055[(2)] = inst_51495);

(statearr_51863_52055[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (77))){
var inst_51678 = (state_51831[(2)]);
var inst_51679 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_51678);
var state_51831__$1 = state_51831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51831__$1,(78),inst_51679);
} else {
if((state_val_51832 === (106))){
var state_51831__$1 = state_51831;
var statearr_51864_52056 = state_51831__$1;
(statearr_51864_52056[(2)] = null);

(statearr_51864_52056[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (119))){
var inst_51784 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_51785 = ["Invalid 'from' in query:",inst_51784].join('');
var inst_51786 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_51787 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_51788 = cljs.core.PersistentHashMap.fromArrays(inst_51786,inst_51787);
var inst_51789 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_51785,inst_51788);
var state_51831__$1 = state_51831;
var statearr_51865_52057 = state_51831__$1;
(statearr_51865_52057[(2)] = inst_51789);

(statearr_51865_52057[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (95))){
var state_51831__$1 = state_51831;
var statearr_51866_52058 = state_51831__$1;
(statearr_51866_52058[(1)] = (119));



return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (54))){
var inst_51614 = (state_51831[(21)]);
var state_51831__$1 = state_51831;
var statearr_51868_52059 = state_51831__$1;
(statearr_51868_52059[(2)] = inst_51614);

(statearr_51868_52059[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (92))){
var inst_51713 = (state_51831[(22)]);
var state_51831__$1 = state_51831;
var statearr_51869_52060 = state_51831__$1;
(statearr_51869_52060[(2)] = inst_51713);

(statearr_51869_52060[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (104))){
var inst_51757 = (state_51831[(23)]);
var inst_51757__$1 = (state_51831[(2)]);
var state_51831__$1 = (function (){var statearr_51870 = state_51831;
(statearr_51870[(23)] = inst_51757__$1);

return statearr_51870;
})();
if(cljs.core.truth_(inst_51757__$1)){
var statearr_51871_52061 = state_51831__$1;
(statearr_51871_52061[(1)] = (109));

} else {
var statearr_51872_52062 = state_51831__$1;
(statearr_51872_52062[(1)] = (110));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (15))){
var inst_51531 = (state_51831[(24)]);
var inst_51529 = (state_51831[(25)]);
var inst_51535 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_51531,cljs.core.cst$kw$componentFollow_QMARK_,inst_51529);
var state_51831__$1 = state_51831;
var statearr_51873_52063 = state_51831__$1;
(statearr_51873_52063[(2)] = inst_51535);

(statearr_51873_52063[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (48))){
var inst_51642 = (state_51831[(9)]);
var inst_51642__$1 = typeof from === 'string';
var state_51831__$1 = (function (){var statearr_51874 = state_51831;
(statearr_51874[(9)] = inst_51642__$1);

return statearr_51874;
})();
if(cljs.core.truth_(inst_51642__$1)){
var statearr_51875_52064 = state_51831__$1;
(statearr_51875_52064[(1)] = (61));

} else {
var statearr_51876_52065 = state_51831__$1;
(statearr_51876_52065[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (50))){
var inst_51608 = (state_51831[(26)]);
var inst_51610 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_51611 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_51608,inst_51610);
var state_51831__$1 = state_51831;
var statearr_51877_52066 = state_51831__$1;
(statearr_51877_52066[(2)] = inst_51611);

(statearr_51877_52066[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (116))){
var state_51831__$1 = state_51831;
var statearr_51878_52067 = state_51831__$1;
(statearr_51878_52067[(2)] = null);

(statearr_51878_52067[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (75))){
var inst_51672 = cljs.core.PersistentHashMap.EMPTY;
var state_51831__$1 = state_51831;
var statearr_51879_52068 = state_51831__$1;
(statearr_51879_52068[(2)] = inst_51672);

(statearr_51879_52068[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (99))){
var inst_51733 = (state_51831[(10)]);
var state_51831__$1 = state_51831;
var statearr_51880_52069 = state_51831__$1;
(statearr_51880_52069[(2)] = inst_51733);

(statearr_51880_52069[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (21))){
var inst_51527 = (state_51831[(18)]);
var inst_51544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_51545 = cljs.core.second(inst_51527);
var inst_51546 = cljs.core.first(inst_51527);
var inst_51547 = [inst_51545,inst_51546];
var inst_51548 = (new cljs.core.PersistentVector(null,2,(5),inst_51544,inst_51547,null));
var state_51831__$1 = state_51831;
var statearr_51881_52070 = state_51831__$1;
(statearr_51881_52070[(2)] = inst_51548);

(statearr_51881_52070[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (31))){
var inst_51599 = (state_51831[(27)]);
var inst_51599__$1 = typeof from === 'string';
var state_51831__$1 = (function (){var statearr_51882 = state_51831;
(statearr_51882[(27)] = inst_51599__$1);

return statearr_51882;
})();
if(cljs.core.truth_(inst_51599__$1)){
var statearr_51883_52071 = state_51831__$1;
(statearr_51883_52071[(1)] = (44));

} else {
var statearr_51884_52072 = state_51831__$1;
(statearr_51884_52072[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (113))){
var state_51831__$1 = state_51831;
var statearr_51885_52073 = state_51831__$1;
(statearr_51885_52073[(2)] = null);

(statearr_51885_52073[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (32))){
var inst_51573 = (state_51831[(16)]);
var inst_51804 = (state_51831[(2)]);
var state_51831__$1 = (function (){var statearr_51886 = state_51831;
(statearr_51886[(28)] = inst_51804);

return statearr_51886;
})();
if(cljs.core.truth_(inst_51573)){
var statearr_51887_52074 = state_51831__$1;
(statearr_51887_52074[(1)] = (122));

} else {
var statearr_51888_52075 = state_51831__$1;
(statearr_51888_52075[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (40))){
var inst_51527 = (state_51831[(18)]);
var inst_51589 = (state_51831[(2)]);
var state_51831__$1 = (function (){var statearr_51889 = state_51831;
(statearr_51889[(29)] = inst_51589);

return statearr_51889;
})();
if(cljs.core.truth_(inst_51527)){
var statearr_51890_52076 = state_51831__$1;
(statearr_51890_52076[(1)] = (41));

} else {
var statearr_51891_52077 = state_51831__$1;
(statearr_51891_52077[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (129))){
var inst_51812 = (state_51831[(30)]);
var state_51831__$1 = state_51831;
var statearr_51892_52078 = state_51831__$1;
(statearr_51892_52078[(2)] = inst_51812);

(statearr_51892_52078[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (91))){
var inst_51715 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_51831__$1 = state_51831;
var statearr_51893_52079 = state_51831__$1;
(statearr_51893_52079[(2)] = inst_51715);

(statearr_51893_52079[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (117))){
var inst_51530 = (state_51831[(15)]);
var state_51831__$1 = state_51831;
var statearr_51894_52080 = state_51831__$1;
(statearr_51894_52080[(2)] = inst_51530);

(statearr_51894_52080[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (108))){
var inst_51754 = (state_51831[(2)]);
var inst_51755 = fluree.db.util.async.throw_err(inst_51754);
var state_51831__$1 = state_51831;
var statearr_51895_52081 = state_51831__$1;
(statearr_51895_52081[(2)] = inst_51755);

(statearr_51895_52081[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (56))){
var inst_51622 = cljs.core.PersistentHashMap.EMPTY;
var state_51831__$1 = state_51831;
var statearr_51896_52082 = state_51831__$1;
(statearr_51896_52082[(2)] = inst_51622);

(statearr_51896_52082[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (33))){
var state_51831__$1 = state_51831;
var statearr_51897_52083 = state_51831__$1;
(statearr_51897_52083[(2)] = from);

(statearr_51897_52083[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (13))){
var inst_51514 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_51515 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_51516 = cljs.core.PersistentHashMap.fromArrays(inst_51514,inst_51515);
var inst_51517 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_51516);
var inst_51518 = (function(){throw inst_51517})();
var state_51831__$1 = state_51831;
var statearr_51898_52084 = state_51831__$1;
(statearr_51898_52084[(2)] = inst_51518);

(statearr_51898_52084[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (22))){
var inst_51527 = (state_51831[(18)]);
var inst_51550 = typeof inst_51527 === 'string';
var state_51831__$1 = state_51831;
if(cljs.core.truth_(inst_51550)){
var statearr_51899_52085 = state_51831__$1;
(statearr_51899_52085[(1)] = (24));

} else {
var statearr_51900_52086 = state_51831__$1;
(statearr_51900_52086[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (90))){
var inst_51706 = (state_51831[(31)]);
var inst_51711 = (state_51831[(2)]);
var state_51831__$1 = (function (){var statearr_51901 = state_51831;
(statearr_51901[(32)] = inst_51711);

return statearr_51901;
})();
var statearr_51902_52087 = state_51831__$1;
(statearr_51902_52087[(2)] = inst_51706);

(statearr_51902_52087[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (109))){
var inst_51757 = (state_51831[(23)]);
var inst_51733 = (state_51831[(10)]);
var inst_51759 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_51733,inst_51757);
var state_51831__$1 = state_51831;
var statearr_51903_52088 = state_51831__$1;
(statearr_51903_52088[(2)] = inst_51759);

(statearr_51903_52088[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (36))){
var inst_51527 = (state_51831[(18)]);
var inst_51584 = (state_51831[(2)]);
var inst_51585 = fluree.db.util.async.throw_err(inst_51584);
var state_51831__$1 = (function (){var statearr_51904 = state_51831;
(statearr_51904[(33)] = inst_51585);

return statearr_51904;
})();
if(cljs.core.truth_(inst_51527)){
var statearr_51905_52089 = state_51831__$1;
(statearr_51905_52089[(1)] = (38));

} else {
var statearr_51906_52090 = state_51831__$1;
(statearr_51906_52090[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (41))){
var state_51831__$1 = state_51831;
var statearr_51907_52091 = state_51831__$1;
(statearr_51907_52091[(2)] = null);

(statearr_51907_52091[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (118))){
var inst_51538 = (state_51831[(7)]);
var inst_51773 = (state_51831[(34)]);
var inst_51540 = (state_51831[(8)]);
var inst_51769 = (state_51831[(35)]);
var inst_51777 = (state_51831[(2)]);
var inst_51778 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_51540,fuel,max_fuel,inst_51538,inst_51769,inst_51773,inst_51777);
var state_51831__$1 = state_51831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51831__$1,(112),inst_51778);
} else {
if((state_val_51832 === (89))){
var state_51831__$1 = state_51831;
var statearr_51908_52092 = state_51831__$1;
(statearr_51908_52092[(2)] = null);

(statearr_51908_52092[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (100))){
var inst_51739 = (state_51831[(19)]);
var inst_51744 = cljs.core.int_QMARK_(inst_51739);
var state_51831__$1 = state_51831;
if(inst_51744){
var statearr_51909_52093 = state_51831__$1;
(statearr_51909_52093[(1)] = (102));

} else {
var statearr_51910_52094 = state_51831__$1;
(statearr_51910_52094[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (131))){
var inst_51809 = (state_51831[(11)]);
var inst_51823 = cljs.core.first(inst_51809);
var state_51831__$1 = state_51831;
var statearr_51911_52095 = state_51831__$1;
(statearr_51911_52095[(2)] = inst_51823);

(statearr_51911_52095[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (122))){
var inst_51573 = (state_51831[(16)]);
var inst_51574 = (state_51831[(17)]);
var inst_51804 = (state_51831[(28)]);
var inst_51530 = (state_51831[(15)]);
var inst_51528 = (state_51831[(14)]);
var inst_51806 = fluree.db.query.fql.sort_offset_and_limit_res(inst_51573,inst_51574,inst_51530,inst_51528,inst_51804);
var state_51831__$1 = state_51831;
var statearr_51912_52096 = state_51831__$1;
(statearr_51912_52096[(2)] = inst_51806);

(statearr_51912_52096[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (43))){
var inst_51589 = (state_51831[(29)]);
var inst_51585 = (state_51831[(33)]);
var inst_51538 = (state_51831[(7)]);
var inst_51540 = (state_51831[(8)]);
var inst_51593 = (state_51831[(2)]);
var inst_51594 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_51540,fuel,max_fuel,inst_51538,inst_51585,inst_51589,inst_51593);
var state_51831__$1 = state_51831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51831__$1,(37),inst_51594);
} else {
if((state_val_51832 === (61))){
var inst_51644 = ["_tx",null,"_block",null];
var inst_51645 = (new cljs.core.PersistentArrayMap(null,2,inst_51644,null));
var inst_51646 = (new cljs.core.PersistentHashSet(null,inst_51645,null));
var inst_51647 = (inst_51646.cljs$core$IFn$_invoke$arity$1 ? inst_51646.cljs$core$IFn$_invoke$arity$1(from) : inst_51646.call(null,from));
var state_51831__$1 = state_51831;
var statearr_51913_52097 = state_51831__$1;
(statearr_51913_52097[(2)] = inst_51647);

(statearr_51913_52097[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (29))){
var inst_51562 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51914_52098 = state_51831__$1;
(statearr_51914_52098[(2)] = inst_51562);

(statearr_51914_52098[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (44))){
var inst_51601 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_51602 = clojure.string.includes_QMARK_(inst_51601,"/");
var state_51831__$1 = state_51831;
var statearr_51915_52099 = state_51831__$1;
(statearr_51915_52099[(2)] = inst_51602);

(statearr_51915_52099[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (93))){
var inst_51718 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
if(cljs.core.truth_(inst_51718)){
var statearr_51916_52100 = state_51831__$1;
(statearr_51916_52100[(1)] = (94));

} else {
var statearr_51917_52101 = state_51831__$1;
(statearr_51917_52101[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (6))){
var inst_51505 = (state_51831[(36)]);
var state_51831__$1 = state_51831;
var statearr_51918_52102 = state_51831__$1;
(statearr_51918_52102[(2)] = inst_51505);

(statearr_51918_52102[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (111))){
var inst_51740 = (state_51831[(37)]);
var inst_51762 = (state_51831[(2)]);
var inst_51732 = inst_51740;
var inst_51733 = inst_51762;
var state_51831__$1 = (function (){var statearr_51919 = state_51831;
(statearr_51919[(10)] = inst_51733);

(statearr_51919[(38)] = inst_51732);

return statearr_51919;
})();
var statearr_51920_52103 = state_51831__$1;
(statearr_51920_52103[(2)] = null);

(statearr_51920_52103[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (28))){
var state_51831__$1 = state_51831;
var statearr_51921_52104 = state_51831__$1;
(statearr_51921_52104[(2)] = null);

(statearr_51921_52104[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (64))){
var inst_51527 = (state_51831[(18)]);
var state_51831__$1 = state_51831;
if(cljs.core.truth_(inst_51527)){
var statearr_51922_52105 = state_51831__$1;
(statearr_51922_52105[(1)] = (67));

} else {
var statearr_51923_52106 = state_51831__$1;
(statearr_51923_52106[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (103))){
var state_51831__$1 = state_51831;
if(cljs.core.truth_(fuel)){
var statearr_51924_52107 = state_51831__$1;
(statearr_51924_52107[(1)] = (105));

} else {
var statearr_51925_52108 = state_51831__$1;
(statearr_51925_52108[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (51))){
var inst_51608 = (state_51831[(26)]);
var state_51831__$1 = state_51831;
var statearr_51926_52109 = state_51831__$1;
(statearr_51926_52109[(2)] = inst_51608);

(statearr_51926_52109[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (25))){
var state_51831__$1 = state_51831;
var statearr_51927_52110 = state_51831__$1;
(statearr_51927_52110[(1)] = (27));



return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (34))){
var state_51831__$1 = state_51831;
var statearr_51929_52111 = state_51831__$1;
(statearr_51929_52111[(2)] = null);

(statearr_51929_52111[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (125))){
var inst_51812 = (state_51831[(30)]);
var inst_51809 = (state_51831[(11)]);
var inst_51812__$1 = cljs.core.coll_QMARK_(inst_51809);
var state_51831__$1 = (function (){var statearr_51930 = state_51831;
(statearr_51930[(30)] = inst_51812__$1);

return statearr_51930;
})();
if(inst_51812__$1){
var statearr_51931_52112 = state_51831__$1;
(statearr_51931_52112[(1)] = (128));

} else {
var statearr_51932_52113 = state_51831__$1;
(statearr_51932_52113[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (17))){
var inst_51527 = (state_51831[(18)]);
var inst_51538 = (state_51831[(2)]);
var inst_51539 = cljs.core.PersistentHashMap.EMPTY;
var inst_51540 = cljs.core.volatile_BANG_(inst_51539);
var state_51831__$1 = (function (){var statearr_51933 = state_51831;
(statearr_51933[(7)] = inst_51538);

(statearr_51933[(8)] = inst_51540);

return statearr_51933;
})();
if(cljs.core.truth_(inst_51527)){
var statearr_51934_52114 = state_51831__$1;
(statearr_51934_52114[(1)] = (18));

} else {
var statearr_51935_52115 = state_51831__$1;
(statearr_51935_52115[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (3))){
var inst_51829 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51831__$1,inst_51829);
} else {
if((state_val_51832 === (12))){
var inst_51511 = (state_51831[(39)]);
var state_51831__$1 = state_51831;
var statearr_51936_52116 = state_51831__$1;
(statearr_51936_52116[(2)] = inst_51511);

(statearr_51936_52116[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (2))){
var inst_51505 = (state_51831[(36)]);
var _ = (function (){var statearr_51937 = state_51831;
(statearr_51937[(4)] = cljs.core.cons((5),(state_51831[(4)])));

return statearr_51937;
})();
var inst_51505__$1 = select;
var state_51831__$1 = (function (){var statearr_51938 = state_51831;
(statearr_51938[(36)] = inst_51505__$1);

return statearr_51938;
})();
if(cljs.core.truth_(inst_51505__$1)){
var statearr_51939_52117 = state_51831__$1;
(statearr_51939_52117[(1)] = (6));

} else {
var statearr_51940_52118 = state_51831__$1;
(statearr_51940_52118[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (66))){
var inst_51800 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51941_52119 = state_51831__$1;
(statearr_51941_52119[(2)] = inst_51800);

(statearr_51941_52119[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (107))){
var inst_51739 = (state_51831[(19)]);
var inst_51751 = (state_51831[(2)]);
var inst_51752 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_51739,false);
var state_51831__$1 = (function (){var statearr_51942 = state_51831;
(statearr_51942[(40)] = inst_51751);

return statearr_51942;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51831__$1,(108),inst_51752);
} else {
if((state_val_51832 === (23))){
var inst_51566 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51943_52120 = state_51831__$1;
(statearr_51943_52120[(2)] = inst_51566);

(statearr_51943_52120[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (47))){
var inst_51608 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_51831__$1 = (function (){var statearr_51944 = state_51831;
(statearr_51944[(26)] = inst_51608);

return statearr_51944;
})();
if(cljs.core.truth_(fuel)){
var statearr_51945_52121 = state_51831__$1;
(statearr_51945_52121[(1)] = (50));

} else {
var statearr_51946_52122 = state_51831__$1;
(statearr_51946_52122[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (35))){
var inst_51581 = (state_51831[(2)]);
var inst_51582 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_51581);
var state_51831__$1 = state_51831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51831__$1,(36),inst_51582);
} else {
if((state_val_51832 === (127))){
var inst_51821 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
if(cljs.core.truth_(inst_51821)){
var statearr_51947_52123 = state_51831__$1;
(statearr_51947_52123[(1)] = (131));

} else {
var statearr_51948_52124 = state_51831__$1;
(statearr_51948_52124[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (82))){
var inst_51796 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51949_52125 = state_51831__$1;
(statearr_51949_52125[(2)] = inst_51796);

(statearr_51949_52125[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (76))){
var inst_51530 = (state_51831[(15)]);
var inst_51528 = (state_51831[(14)]);
var inst_51674 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_51675 = [inst_51528,inst_51530];
var inst_51676 = cljs.core.PersistentHashMap.fromArrays(inst_51674,inst_51675);
var state_51831__$1 = state_51831;
var statearr_51950_52126 = state_51831__$1;
(statearr_51950_52126[(2)] = inst_51676);

(statearr_51950_52126[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (97))){
var inst_51739 = (state_51831[(19)]);
var inst_51732 = (state_51831[(38)]);
var inst_51738 = cljs.core.seq(inst_51732);
var inst_51739__$1 = cljs.core.first(inst_51738);
var inst_51740 = cljs.core.next(inst_51738);
var inst_51741 = cljs.core.not(inst_51739__$1);
var state_51831__$1 = (function (){var statearr_51951 = state_51831;
(statearr_51951[(19)] = inst_51739__$1);

(statearr_51951[(37)] = inst_51740);

return statearr_51951;
})();
if(inst_51741){
var statearr_51952_52127 = state_51831__$1;
(statearr_51952_52127[(1)] = (99));

} else {
var statearr_51953_52128 = state_51831__$1;
(statearr_51953_52128[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (19))){
var inst_51568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_51569 = [null,null];
var inst_51570 = (new cljs.core.PersistentVector(null,2,(5),inst_51568,inst_51569,null));
var state_51831__$1 = state_51831;
var statearr_51954_52129 = state_51831__$1;
(statearr_51954_52129[(2)] = inst_51570);

(statearr_51954_52129[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (57))){
var inst_51530 = (state_51831[(15)]);
var inst_51528 = (state_51831[(14)]);
var inst_51624 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_51625 = [inst_51528,inst_51530];
var inst_51626 = cljs.core.PersistentHashMap.fromArrays(inst_51624,inst_51625);
var state_51831__$1 = state_51831;
var statearr_51955_52130 = state_51831__$1;
(statearr_51955_52130[(2)] = inst_51626);

(statearr_51955_52130[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (68))){
var inst_51530 = (state_51831[(15)]);
var inst_51528 = (state_51831[(14)]);
var inst_51655 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_51656 = [inst_51528,inst_51530];
var inst_51657 = cljs.core.PersistentHashMap.fromArrays(inst_51655,inst_51656);
var state_51831__$1 = state_51831;
var statearr_51956_52131 = state_51831__$1;
(statearr_51956_52131[(2)] = inst_51657);

(statearr_51956_52131[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (11))){
var inst_51522 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51957_52132 = state_51831__$1;
(statearr_51957_52132[(2)] = inst_51522);

(statearr_51957_52132[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (115))){
var inst_51527 = (state_51831[(18)]);
var inst_51773 = (state_51831[(2)]);
var state_51831__$1 = (function (){var statearr_51959 = state_51831;
(statearr_51959[(34)] = inst_51773);

return statearr_51959;
})();
if(cljs.core.truth_(inst_51527)){
var statearr_51960_52133 = state_51831__$1;
(statearr_51960_52133[(1)] = (116));

} else {
var statearr_51961_52134 = state_51831__$1;
(statearr_51961_52134[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (9))){
var inst_51508 = (state_51831[(12)]);
var state_51831__$1 = state_51831;
var statearr_51962_52135 = state_51831__$1;
(statearr_51962_52135[(2)] = inst_51508);

(statearr_51962_52135[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (5))){
var _ = (function (){var statearr_51963 = state_51831;
(statearr_51963[(4)] = cljs.core.rest((state_51831[(4)])));

return statearr_51963;
})();
var state_51831__$1 = state_51831;
var ex51958 = (state_51831__$1[(2)]);
var statearr_51964_52136 = state_51831__$1;
(statearr_51964_52136[(5)] = ex51958);


if((ex51958 instanceof Error)){
var statearr_51965_52137 = state_51831__$1;
(statearr_51965_52137[(1)] = (4));

(statearr_51965_52137[(5)] = null);

} else {
throw ex51958;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (112))){
var inst_51780 = (state_51831[(2)]);
var inst_51781 = fluree.db.util.async.throw_err(inst_51780);
var state_51831__$1 = state_51831;
var statearr_51966_52138 = state_51831__$1;
(statearr_51966_52138[(2)] = inst_51781);

(statearr_51966_52138[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (83))){
var inst_51694 = (state_51831[(20)]);
var inst_51693 = (state_51831[(2)]);
var inst_51694__$1 = fluree.db.util.async.throw_err(inst_51693);
var inst_51695 = (inst_51694__$1 == null);
var state_51831__$1 = (function (){var statearr_51967 = state_51831;
(statearr_51967[(20)] = inst_51694__$1);

return statearr_51967;
})();
if(cljs.core.truth_(inst_51695)){
var statearr_51968_52139 = state_51831__$1;
(statearr_51968_52139[(1)] = (84));

} else {
var statearr_51969_52140 = state_51831__$1;
(statearr_51969_52140[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (14))){
var inst_51520 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51970_52141 = state_51831__$1;
(statearr_51970_52141[(2)] = inst_51520);

(statearr_51970_52141[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (45))){
var inst_51599 = (state_51831[(27)]);
var state_51831__$1 = state_51831;
var statearr_51971_52142 = state_51831__$1;
(statearr_51971_52142[(2)] = inst_51599);

(statearr_51971_52142[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (53))){
var inst_51614 = (state_51831[(21)]);
var inst_51616 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_51617 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_51614,inst_51616);
var state_51831__$1 = state_51831;
var statearr_51972_52143 = state_51831__$1;
(statearr_51972_52143[(2)] = inst_51617);

(statearr_51972_52143[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (78))){
var inst_51538 = (state_51831[(7)]);
var inst_51540 = (state_51831[(8)]);
var inst_51681 = (state_51831[(2)]);
var inst_51682 = fluree.db.util.async.throw_err(inst_51681);
var inst_51683 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_51540,fuel,max_fuel,inst_51538,inst_51682);
var state_51831__$1 = state_51831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51831__$1,(79),inst_51683);
} else {
if((state_val_51832 === (132))){
var inst_51809 = (state_51831[(11)]);
var state_51831__$1 = state_51831;
var statearr_51973_52144 = state_51831__$1;
(statearr_51973_52144[(2)] = inst_51809);

(statearr_51973_52144[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (26))){
var inst_51564 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51974_52145 = state_51831__$1;
(statearr_51974_52145[(2)] = inst_51564);

(statearr_51974_52145[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (123))){
var inst_51804 = (state_51831[(28)]);
var state_51831__$1 = state_51831;
var statearr_51975_52146 = state_51831__$1;
(statearr_51975_52146[(2)] = inst_51804);

(statearr_51975_52146[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (16))){
var inst_51531 = (state_51831[(24)]);
var state_51831__$1 = state_51831;
var statearr_51976_52147 = state_51831__$1;
(statearr_51976_52147[(2)] = inst_51531);

(statearr_51976_52147[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (133))){
var inst_51826 = (state_51831[(2)]);
var _ = (function (){var statearr_51977 = state_51831;
(statearr_51977[(4)] = cljs.core.rest((state_51831[(4)])));

return statearr_51977;
})();
var state_51831__$1 = state_51831;
var statearr_51978_52148 = state_51831__$1;
(statearr_51978_52148[(2)] = inst_51826);

(statearr_51978_52148[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (81))){
var inst_51713 = (state_51831[(22)]);
var inst_51713__$1 = cljs.core.sequential_QMARK_(from);
var state_51831__$1 = (function (){var statearr_51979 = state_51831;
(statearr_51979[(22)] = inst_51713__$1);

return statearr_51979;
})();
if(inst_51713__$1){
var statearr_51980_52149 = state_51831__$1;
(statearr_51980_52149[(1)] = (91));

} else {
var statearr_51981_52150 = state_51831__$1;
(statearr_51981_52150[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (120))){
var state_51831__$1 = state_51831;
var statearr_51982_52151 = state_51831__$1;
(statearr_51982_52151[(2)] = null);

(statearr_51982_52151[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (79))){
var inst_51685 = (state_51831[(2)]);
var inst_51686 = fluree.db.util.async.throw_err(inst_51685);
var state_51831__$1 = state_51831;
var statearr_51983_52152 = state_51831__$1;
(statearr_51983_52152[(2)] = inst_51686);

(statearr_51983_52152[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (38))){
var state_51831__$1 = state_51831;
var statearr_51984_52153 = state_51831__$1;
(statearr_51984_52153[(2)] = null);

(statearr_51984_52153[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (126))){
var inst_51810 = (state_51831[(41)]);
var state_51831__$1 = state_51831;
var statearr_51985_52154 = state_51831__$1;
(statearr_51985_52154[(2)] = inst_51810);

(statearr_51985_52154[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (98))){
var inst_51527 = (state_51831[(18)]);
var inst_51767 = (state_51831[(2)]);
var inst_51768 = cljs.core.PersistentVector.EMPTY;
var inst_51769 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_51768,inst_51767);
var state_51831__$1 = (function (){var statearr_51986 = state_51831;
(statearr_51986[(35)] = inst_51769);

return statearr_51986;
})();
if(cljs.core.truth_(inst_51527)){
var statearr_51987_52155 = state_51831__$1;
(statearr_51987_52155[(1)] = (113));

} else {
var statearr_51988_52156 = state_51831__$1;
(statearr_51988_52156[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (124))){
var inst_51810 = (state_51831[(41)]);
var inst_51809 = (state_51831[(2)]);
var inst_51810__$1 = selectOne;
var state_51831__$1 = (function (){var statearr_51989 = state_51831;
(statearr_51989[(41)] = inst_51810__$1);

(statearr_51989[(11)] = inst_51809);

return statearr_51989;
})();
if(cljs.core.truth_(inst_51810__$1)){
var statearr_51990_52157 = state_51831__$1;
(statearr_51990_52157[(1)] = (125));

} else {
var statearr_51991_52158 = state_51831__$1;
(statearr_51991_52158[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (87))){
var inst_51705 = (state_51831[(2)]);
var inst_51706 = fluree.db.util.async.throw_err(inst_51705);
var state_51831__$1 = (function (){var statearr_51992 = state_51831;
(statearr_51992[(31)] = inst_51706);

return statearr_51992;
})();
if(cljs.core.truth_(fuel)){
var statearr_51993_52159 = state_51831__$1;
(statearr_51993_52159[(1)] = (88));

} else {
var statearr_51994_52160 = state_51831__$1;
(statearr_51994_52160[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (30))){
var inst_51577 = typeof from === 'string';
var state_51831__$1 = state_51831;
if(cljs.core.truth_(inst_51577)){
var statearr_51995_52161 = state_51831__$1;
(statearr_51995_52161[(1)] = (33));

} else {
var statearr_51996_52162 = state_51831__$1;
(statearr_51996_52162[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (73))){
var inst_51688 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_51831__$1 = state_51831;
if(inst_51688){
var statearr_51997_52163 = state_51831__$1;
(statearr_51997_52163[(1)] = (80));

} else {
var statearr_51998_52164 = state_51831__$1;
(statearr_51998_52164[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (96))){
var inst_51794 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_51999_52165 = state_51831__$1;
(statearr_51999_52165[(2)] = inst_51794);

(statearr_51999_52165[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (10))){
var inst_51511 = (state_51831[(39)]);
var inst_51511__$1 = selectDistinct;
var state_51831__$1 = (function (){var statearr_52000 = state_51831;
(statearr_52000[(39)] = inst_51511__$1);

return statearr_52000;
})();
if(cljs.core.truth_(inst_51511__$1)){
var statearr_52001_52166 = state_51831__$1;
(statearr_52001_52166[(1)] = (12));

} else {
var statearr_52002_52167 = state_51831__$1;
(statearr_52002_52167[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (18))){
var inst_51527 = (state_51831[(18)]);
var inst_51542 = cljs.core.vector_QMARK_(inst_51527);
var state_51831__$1 = state_51831;
if(inst_51542){
var statearr_52003_52168 = state_51831__$1;
(statearr_52003_52168[(1)] = (21));

} else {
var statearr_52004_52169 = state_51831__$1;
(statearr_52004_52169[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (105))){
var inst_51748 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_51831__$1 = state_51831;
var statearr_52005_52170 = state_51831__$1;
(statearr_52005_52170[(2)] = inst_51748);

(statearr_52005_52170[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (52))){
var inst_51614 = (state_51831[(2)]);
var state_51831__$1 = (function (){var statearr_52006 = state_51831;
(statearr_52006[(21)] = inst_51614);

return statearr_52006;
})();
var statearr_52007_52171 = state_51831__$1;
(statearr_52007_52171[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (114))){
var inst_51528 = (state_51831[(14)]);
var state_51831__$1 = state_51831;
var statearr_52009_52172 = state_51831__$1;
(statearr_52009_52172[(2)] = inst_51528);

(statearr_52009_52172[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (67))){
var inst_51653 = cljs.core.PersistentHashMap.EMPTY;
var state_51831__$1 = state_51831;
var statearr_52010_52173 = state_51831__$1;
(statearr_52010_52173[(2)] = inst_51653);

(statearr_52010_52173[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (71))){
var inst_51666 = (state_51831[(2)]);
var inst_51667 = fluree.db.util.async.throw_err(inst_51666);
var state_51831__$1 = state_51831;
var statearr_52011_52174 = state_51831__$1;
(statearr_52011_52174[(2)] = inst_51667);

(statearr_52011_52174[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (42))){
var inst_51530 = (state_51831[(15)]);
var state_51831__$1 = state_51831;
var statearr_52012_52175 = state_51831__$1;
(statearr_52012_52175[(2)] = inst_51530);

(statearr_52012_52175[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (80))){
var inst_51691 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_51831__$1 = state_51831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51831__$1,(83),inst_51691);
} else {
if((state_val_51832 === (37))){
var inst_51596 = (state_51831[(2)]);
var inst_51597 = fluree.db.util.async.throw_err(inst_51596);
var state_51831__$1 = state_51831;
var statearr_52013_52176 = state_51831__$1;
(statearr_52013_52176[(2)] = inst_51597);

(statearr_52013_52176[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (63))){
var inst_51650 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
if(cljs.core.truth_(inst_51650)){
var statearr_52014_52177 = state_51831__$1;
(statearr_52014_52177[(1)] = (64));

} else {
var statearr_52015_52178 = state_51831__$1;
(statearr_52015_52178[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (94))){
var inst_51727 = from;
var inst_51728 = cljs.core.seq(inst_51727);
var inst_51729 = cljs.core.first(inst_51728);
var inst_51730 = cljs.core.next(inst_51728);
var inst_51731 = cljs.core.PersistentVector.EMPTY;
var inst_51732 = inst_51727;
var inst_51733 = inst_51731;
var state_51831__$1 = (function (){var statearr_52016 = state_51831;
(statearr_52016[(10)] = inst_51733);

(statearr_52016[(42)] = inst_51730);

(statearr_52016[(38)] = inst_51732);

(statearr_52016[(43)] = inst_51729);

return statearr_52016;
})();
var statearr_52017_52179 = state_51831__$1;
(statearr_52017_52179[(2)] = null);

(statearr_52017_52179[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (8))){
var inst_51529 = (state_51831[(25)]);
var inst_51524 = (state_51831[(2)]);
var inst_51525 = opts_SINGLEQUOTE_;
var inst_51526 = cljs.core.__destructure_map(inst_51525);
var inst_51527 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51526,cljs.core.cst$kw$orderBy);
var inst_51528 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51526,cljs.core.cst$kw$limit);
var inst_51529__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51526,cljs.core.cst$kw$component);
var inst_51530 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51526,cljs.core.cst$kw$offset);
var inst_51531 = fluree.db.query.fql_parser.parse_db(db,inst_51524,opts_SINGLEQUOTE_);
var inst_51532 = (inst_51529__$1 == null);
var inst_51533 = cljs.core.not(inst_51532);
var state_51831__$1 = (function (){var statearr_52018 = state_51831;
(statearr_52018[(15)] = inst_51530);

(statearr_52018[(24)] = inst_51531);

(statearr_52018[(14)] = inst_51528);

(statearr_52018[(25)] = inst_51529__$1);

(statearr_52018[(18)] = inst_51527);

return statearr_52018;
})();
if(inst_51533){
var statearr_52019_52180 = state_51831__$1;
(statearr_52019_52180[(1)] = (15));

} else {
var statearr_52020_52181 = state_51831__$1;
(statearr_52020_52181[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (49))){
var inst_51802 = (state_51831[(2)]);
var state_51831__$1 = state_51831;
var statearr_52021_52182 = state_51831__$1;
(statearr_52021_52182[(2)] = inst_51802);

(statearr_52021_52182[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51832 === (84))){
var state_51831__$1 = state_51831;
var statearr_52022_52183 = state_51831__$1;
(statearr_52022_52183[(2)] = null);

(statearr_52022_52183[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__24298__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__24298__auto____0 = (function (){
var statearr_52023 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52023[(0)] = fluree$db$query$fql$query_$_state_machine__24298__auto__);

(statearr_52023[(1)] = (1));

return statearr_52023;
});
var fluree$db$query$fql$query_$_state_machine__24298__auto____1 = (function (state_51831){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_51831);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e52024){var ex__24301__auto__ = e52024;
var statearr_52025_52184 = state_51831;
(statearr_52025_52184[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_51831[(4)]))){
var statearr_52026_52185 = state_51831;
(statearr_52026_52185[(1)] = cljs.core.first((state_51831[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__52186 = state_51831;
state_51831 = G__52186;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__24298__auto__ = function(state_51831){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__24298__auto____1.call(this,state_51831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__24298__auto____0;
fluree$db$query$fql$query_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__24298__auto____1;
return fluree$db$query$fql$query_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_52027 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_52027[(6)] = c__24424__auto__);

return statearr_52027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}

});
